#include "header.h"

struct dsp *dsp;

struct dsp *init_dsp (gchar *filename){
    struct dsp *dsp;

    dsp = g_new0(struct dsp, 1);   
    dsp->filename = g_strdup(filename); 
    dsp->fd = -1;
    return dsp;
}

void free_dsp(struct dsp *dsp){
    if (!dsp) return;

    close_dsp(dsp);
    CONDGFREE(dsp->filename);
    CONDGFREE(dsp->errstr);
}


int open_dsp(struct dsp *dsp, int rec){
    int tmp;

    dbg("open_dsp(%d)\n", rec);
    dsp->fd = open (dsp->filename, rec?O_RDONLY:O_WRONLY, 0);
    if (dsp->fd < 0){
        CONDGFREE(dsp->errstr);
        dsp->errstr = g_strdup_printf("Can't open file '%s'", dsp->filename);
        goto err;
    }

    if (ioctl(dsp->fd, SNDCTL_DSP_GETFMTS, &dsp->fmt_mask)){
        CONDGFREE(dsp->errstr);
        dsp->errstr = g_strdup("Can't get supported audio formats");
        goto err;
    }
    
    tmp=dsp->format;
    if (ioctl (dsp->fd, SNDCTL_DSP_SETFMT, &dsp->format)){
        CONDGFREE(dsp->errstr);
        dsp->errstr = g_strdup_printf("Can't set audio format %d, recommended %d", tmp, dsp->format);
        
        tmp=dsp->format;
        if (ioctl (dsp->fd, SNDCTL_DSP_SETFMT, &dsp->format)){
            CONDGFREE(dsp->errstr);
            dsp->errstr = g_strdup_printf("Can't set recommended audio format %d, return %d", tmp, dsp->format);
            
            tmp = dsp->format = AFMT_S16_NE;
            if (ioctl (dsp->fd, SNDCTL_DSP_SETFMT, &dsp->format)){
                CONDGFREE(dsp->errstr);
                dsp->errstr = g_strdup_printf("Can't set fallback audio %d, return %d", tmp, dsp->format);
                
                dsp->format = AFMT_S8;
                if (ioctl (dsp->fd, SNDCTL_DSP_SETFMT, &dsp->format)){
                    CONDGFREE(dsp->errstr);
                    dsp->errstr = g_strdup_printf("Can't set fallback audio format %d, return %d", tmp, dsp->format);
                    
                    dsp->format = AFMT_U8;
                    if (ioctl (dsp->fd, SNDCTL_DSP_SETFMT, &dsp->format)){
                        CONDGFREE(dsp->errstr);
                        dsp->errstr = g_strdup_printf("Can't set fallback audio format %d, return %d", tmp, dsp->format);
                        goto err;
                    }
                }
            }
        }
        /* fallback ok */
    }

    tmp=dsp->channels;
    if (ioctl (dsp->fd, SNDCTL_DSP_CHANNELS, &dsp->channels)){
        CONDGFREE(dsp->errstr);
        dsp->errstr = g_strdup_printf("Can't set channels %d, recommended %d", tmp, dsp->channels);
        
        tmp=dsp->channels;
        if (ioctl (dsp->fd, SNDCTL_DSP_CHANNELS, &dsp->channels)){
            CONDGFREE(dsp->errstr);
            dsp->errstr = g_strdup_printf("Can't set recommended channels %d, return %d", tmp, dsp->channels);
            goto err;
        }
        /* fallback ok */
    }

    tmp=dsp->speed;
    if (ioctl (dsp->fd, SNDCTL_DSP_SPEED, &dsp->speed)){
        CONDGFREE(dsp->errstr);
        dsp->errstr = g_strdup_printf("Can't set samplerate %d, recommended %d", tmp, dsp->speed);
        
        tmp=dsp->speed;
        if (ioctl (dsp->fd, SNDCTL_DSP_SPEED, &dsp->speed)){
            CONDGFREE(dsp->errstr);
            dsp->errstr = g_strdup_printf("Can't set recommended samplerate %d, return %d", tmp, dsp->speed);
            goto err;
        }
        /* fallback ok */
    }

    if (ioctl (dsp->fd, SNDCTL_DSP_GETBLKSIZE, &dsp->blksize)){
        CONDGFREE(dsp->errstr);
        dsp->errstr = g_strdup_printf("Can't set recommended samplerate %d, return %d", tmp, dsp->speed);
        goto err;
    } 
    
    if (rec){
        char buf[16];
        read(dsp->fd, buf, sizeof(buf));
    }else{
        char buf[16];
        memset(buf, 0, sizeof(buf));
        write(dsp->fd, buf, sizeof(buf));
    }
    goto x;
    
err:;
    if (dsp->fd>=0) close(dsp->fd);
    dsp->fd = -1;

x:;
    dbg(" dsp->fd=%d\n", dsp->fd);
    return dsp->fd;
} 

int close_dsp(struct dsp *dsp){
    dbg("close_dsp(fd=%d)\n",dsp->fd);

    if (dsp->fd >= 0) {
        set_handlers(dsp->fd, NULL, NULL, NULL, NULL);
        close(dsp->fd);
    }   
    dsp->fd=-1;
    return 0;
}

int reset_dsp(struct dsp *dsp){
    if (!dsp || dsp->fd<0) return 0;
    return ioctl(dsp->fd, SNDCTL_DSP_RESET, NULL); 
}

int sf2dsp(SF_INFO *sfinfo){
    int format;

    switch (sfinfo->format & SF_FORMAT_SUBMASK){
/*        case SF_FORMAT_PCM_U8:
            format=AFMT_U8;
            break;
        case SF_FORMAT_PCM_S8:
            format=AFMT_S8;
            break;*/
        case SF_FORMAT_ULAW:
            format=AFMT_MU_LAW;
            break;            
        case SF_FORMAT_ALAW:
            format=AFMT_A_LAW;
            break;            
        case SF_FORMAT_IMA_ADPCM:
            format=AFMT_IMA_ADPCM;
            break;            
        default:
            format=AFMT_S16_NE;    
    }
    return format;
}    

int dsp2sf(struct dsp *dsp){
    return 0;
}
