/*===========================================================================
*
*                            PUBLIC DOMAIN NOTICE
*               National Center for Biotechnology Information
*
*  This software/database is a "United States Government Work" under the
*  terms of the United States Copyright Act.  It was written as part of
*  the author's official duties as a United States Government employee and
*  thus cannot be copyrighted.  This software/database is freely available
*  to the public for use. The National Library of Medicine and the U.S.
*  Government have not placed any restriction on its use or reproduction.
*
*  Although all reasonable efforts have been taken to ensure the accuracy
*  and reliability of the software and data, the NLM and the U.S.
*  Government do not and cannot warrant the performance or results that
*  may be obtained by using this software or data. The NLM and the U.S.
*  Government disclaim all warranties, express or implied, including
*  warranties of performance, merchantability or fitness for any particular
*  purpose.
*
*  Please cite the author in any work or product based on this material.
*
* ===========================================================================
*
*/

#ifndef _h_klib_checksum_
#define _h_klib_checksum_

#ifndef _h_klib_extern_
#include <klib/extern.h>
#endif

#ifndef _h_klib_defs_
#include <klib/defs.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif


/*--------------------------------------------------------------------------
 * CRC32
 */

/* CRC32Init
 *  initializes table
 *  IDEMPOTENT
 */
KLIB_EXTERN void CC CRC32Init ( void );

/* CRC32
 *  runs checksum on arbitrary data, returning result
 *  initial checksum to be passed in is 0
 *  subsequent checksums should be return from prior invocation
 */
KLIB_EXTERN uint32_t CC CRC32 ( uint32_t checksum, const void *data, size_t size );


/*--------------------------------------------------------------------------
 * MD5
 *  taken from Peter Deutsch's sources due to simplicity
 */
typedef struct MD5State MD5State;
struct MD5State
{
    uint32_t count [ 2 ];
    uint32_t abcd [ 4 ];
    uint8_t buf [ 64 ];
};

/* MD5StateInit
 *  initialize the algorithm and state block
 */
KLIB_EXTERN void CC MD5StateInit ( MD5State *md5 );

/* MD5StateAppend
 *  run MD5 on data block
 *  accumulate results into "md5"
 *  processes data in chunks
 */
KLIB_EXTERN void CC MD5StateAppend ( MD5State *md5, const void *data, size_t size );

/* MD5StateFinish
 *  processes any remaining data in "md5"
 *  returns 16 bytes of digest
 */
KLIB_EXTERN void CC MD5StateFinish ( MD5State *md5, uint8_t digest [ 16 ] );


#ifdef __cplusplus
}
#endif

#endif /* _h_klib_checksum_ */
