##############################################################################  
#   
# This software is released under the Zope Public License (ZPL) Version 1.0
#
# Copyright (c) Digital Creations.  All rights reserved.  
# Portions Copyright (c) 1999 by Butch Landingin.
# Portions Copyright (c) 2000-2001 by Chris Withers.
#   
##############################################################################  
  
__version__='$Revision: 1.7 $'[11:-2]  
  
from AccessControl import ClassSecurityInfo
from OFS.Image import File, cookId
from SquishPermissions import View
import Globals

class Squishfile(File):  
    """ Squishdot File """  

    security = ClassSecurityInfo()

    meta_type = "Squishdot File"
    
    security.declarePrivate('__init__')
    def __init__(self,file=None):        
        if file:
            id, title = cookId(None,None,file)
            File.__init__(self,id,title,file)
  
    security.declareProtected(View, 'icon')
    def icon(self):
        return 'misc_/Squishdot/squishfile_img'

    security.declareProtected(View, 'file_name')
    def file_name(self):
        return self.getId()
  
    security.declareProtected(View, 'file_bytes')
    def file_bytes(self):  
        return self.get_size()
  
    security.declareProtected(View, 'file_kbytes')
    def file_kbytes(self):  
        return int(self.get_size()/1024)  
  
Globals.InitializeClass(Squishfile)
