<?php
/**
 * iso-2022-xx support functions
 *
 * Documents:
 * RFC1468 iso-2022-jp   (http://www.faqs.org/rfcs/rfc1468.html)
 * RFC1554 iso-2022-jp-2 (http://www.faqs.org/rfcs/rfc1554.html)
 * RFC1557 iso-2022-kr   (http://www.faqs.org/rfcs/rfc1557.html)
 * RFC1922 iso-2022-cn   (http://www.faqs.org/rfcs/rfc1922.html)
 *         iso-2022-cn-ext
 *
 * Mappings:
 * ftp://ftp.unicode.org/Public/MAPPINGS/OBSOLETE/EASTASIA/JIS/JIS0201.TXT
 * ftp://ftp.unicode.org/Public/MAPPINGS/OBSOLETE/EASTASIA/JIS/JIS0208.TXT
 * ftp://ftp.unicode.org/Public/MAPPINGS/OBSOLETE/EASTASIA/JIS/JIS0212.TXT
 * ftp://ftp.unicode.org/Public/MAPPINGS/OBSOLETE/EASTASIA/KSC/KSC5601.TXT
 * ftp://ftp.unicode.org/Public/MAPPINGS/OBSOLETE/EASTASIA/GB/GB2312.TXT
 * ftp://ftp.unicode.org/Public/MAPPINGS/ISO8859/8859-1.TXT
 * ftp://ftp.unicode.org/Public/MAPPINGS/ISO8859/8859-7.TXT
 *
 ************************************************************************
 * Original Unicode, Inc copyright statement:
 ************************************************************************
 * This file is provided as-is by Unicode, Inc. (The Unicode Consortium).
 * No claims are made as to fitness for any particular purpose.  No
 * warranties of any kind are expressed or implied.  The recipient
 * agrees to determine applicability of information provided.  If this
 * file has been provided on optical media by Unicode, Inc., the sole
 * remedy for any claim will be exchange of defective media within 90
 * days of receipt.
 *
 * Unicode, Inc. hereby grants the right to freely use the information
 * supplied in this file in the creation of products supporting the
 * Unicode Standard, and to make copies of this file in any form for
 * internal or external distribution as long as this notice remains
 ************************************************************************
 * @copyright (c) 2004-2005 The SquirrelMail Project Team
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 * @version $Id: iso_2022_support.php,v 1.5 2005/10/31 19:30:13 tokul Exp $
 * @package decode
 * @subpackage eastasia
 */

/**
 * Bogus function for iso-2022-support charset
 */
function charset_decode_iso_2022_support($string) {
  return 'Unsupported charset';
}
      
/**
 * 
 * @param string $string
 * @param integer $index
 * @param string $enc_table
 * @return string
 */
function get_iso_2022_symbol($string,$index,$enc_table) {

    if ($index>=strlen($string)) {
        $symbol='';
    } elseif ($enc_table=='ascii') {
        $symbol=htmlspecialchars($string[$index]);
    } elseif ($enc_table=='jis0208-1983') {
        $symbol=get_jis0208_1983_symbol($string[$index].$string[$index+1]);
    } else {
        $symbol='?';
    }
    return $symbol;
}

/**
 * @param string $enc_table iso-2022 encoding table
 * @return integer number of bytes used by characters in given encoding table
 */
function get_iso_2022_symbolsize($enc_table) {
    switch ($enc_table) {
    case 'jis0208-1983':
        $symbolsize=2;
        break;
    case 'ascii':
    default:
        $symbolsize=1;
    }
    return $symbolsize;
}

/**
 *
 */
function get_jis0208_1983_symbol($symbol) {
    $jis0208_1983 = array(
 "\x21\x21" => '&#12288;',
 "\x21\x22" => '&#12289;',
 "\x21\x23" => '&#12290;',
 "\x21\x24" => '&#65292;',
 "\x21\x25" => '&#65294;',
 "\x21\x26" => '&#12539;',
 "\x21\x27" => '&#65306;',
 "\x21\x28" => '&#65307;',
 "\x21\x29" => '&#65311;',
 "\x21\x2A" => '&#65281;',
 "\x21\x2B" => '&#12443;',
 "\x21\x2C" => '&#12444;',
 "\x21\x2D" => '&#180;',
 "\x21\x2E" => '&#65344;',
 "\x21\x2F" => '&#168;',
 "\x21\x30" => '&#65342;',
 "\x21\x31" => '&#65507;',
 "\x21\x32" => '&#65343;',
 "\x21\x33" => '&#12541;',
 "\x21\x34" => '&#12542;',
 "\x21\x35" => '&#12445;',
 "\x21\x36" => '&#12446;',
 "\x21\x37" => '&#12291;',
 "\x21\x38" => '&#20189;',
 "\x21\x39" => '&#12293;',
 "\x21\x3A" => '&#12294;',
 "\x21\x3B" => '&#12295;',
 "\x21\x3C" => '&#12540;',
 "\x21\x3D" => '&#8213;',
 "\x21\x3E" => '&#8208;',
 "\x21\x3F" => '&#65295;',
 "\x21\x40" => '&#92;',
 "\x21\x41" => '&#12316;',
 "\x21\x42" => '&#8214;',
 "\x21\x43" => '&#65372;',
 "\x21\x44" => '&#8230;',
 "\x21\x45" => '&#8229;',
 "\x21\x46" => '&#8216;',
 "\x21\x47" => '&#8217;',
 "\x21\x48" => '&#8220;',
 "\x21\x49" => '&#8221;',
 "\x21\x4A" => '&#65288;',
 "\x21\x4B" => '&#65289;',
 "\x21\x4C" => '&#12308;',
 "\x21\x4D" => '&#12309;',
 "\x21\x4E" => '&#65339;',
 "\x21\x4F" => '&#65341;',
 "\x21\x50" => '&#65371;',
 "\x21\x51" => '&#65373;',
 "\x21\x52" => '&#12296;',
 "\x21\x53" => '&#12297;',
 "\x21\x54" => '&#12298;',
 "\x21\x55" => '&#12299;',
 "\x21\x56" => '&#12300;',
 "\x21\x57" => '&#12301;',
 "\x21\x58" => '&#12302;',
 "\x21\x59" => '&#12303;',
 "\x21\x5A" => '&#12304;',
 "\x21\x5B" => '&#12305;',
 "\x21\x5C" => '&#65291;',
 "\x21\x5D" => '&#8722;',
 "\x21\x5E" => '&#177;',
 "\x21\x5F" => '&#215;',
 "\x21\x60" => '&#247;',
 "\x21\x61" => '&#65309;',
 "\x21\x62" => '&#8800;',
 "\x21\x63" => '&#65308;',
 "\x21\x64" => '&#65310;',
 "\x21\x65" => '&#8806;',
 "\x21\x66" => '&#8807;',
 "\x21\x67" => '&#8734;',
 "\x21\x68" => '&#8756;',
 "\x21\x69" => '&#9794;',
 "\x21\x6A" => '&#9792;',
 "\x21\x6B" => '&#176;',
 "\x21\x6C" => '&#8242;',
 "\x21\x6D" => '&#8243;',
 "\x21\x6E" => '&#8451;',
 "\x21\x6F" => '&#65509;',
 "\x21\x70" => '&#65284;',
 "\x21\x71" => '&#162;',
 "\x21\x72" => '&#163;',
 "\x21\x73" => '&#65285;',
 "\x21\x74" => '&#65283;',
 "\x21\x75" => '&#65286;',
 "\x21\x76" => '&#65290;',
 "\x21\x77" => '&#65312;',
 "\x21\x78" => '&#167;',
 "\x21\x79" => '&#9734;',
 "\x21\x7A" => '&#9733;',
 "\x21\x7B" => '&#9675;',
 "\x21\x7C" => '&#9679;',
 "\x21\x7D" => '&#9678;',
 "\x21\x7E" => '&#9671;',
 "\x22\x21" => '&#9670;',
 "\x22\x22" => '&#9633;',
 "\x22\x23" => '&#9632;',
 "\x22\x24" => '&#9651;',
 "\x22\x25" => '&#9650;',
 "\x22\x26" => '&#9661;',
 "\x22\x27" => '&#9660;',
 "\x22\x28" => '&#8251;',
 "\x22\x29" => '&#12306;',
 "\x22\x2A" => '&#8594;',
 "\x22\x2B" => '&#8592;',
 "\x22\x2C" => '&#8593;',
 "\x22\x2D" => '&#8595;',
 "\x22\x2E" => '&#12307;',
 "\x22\x3A" => '&#8712;',
 "\x22\x3B" => '&#8715;',
 "\x22\x3C" => '&#8838;',
 "\x22\x3D" => '&#8839;',
 "\x22\x3E" => '&#8834;',
 "\x22\x3F" => '&#8835;',
 "\x22\x40" => '&#8746;',
 "\x22\x41" => '&#8745;',
 "\x22\x4A" => '&#8743;',
 "\x22\x4B" => '&#8744;',
 "\x22\x4C" => '&#172;',
 "\x22\x4D" => '&#8658;',
 "\x22\x4E" => '&#8660;',
 "\x22\x4F" => '&#8704;',
 "\x22\x50" => '&#8707;',
 "\x22\x5C" => '&#8736;',
 "\x22\x5D" => '&#8869;',
 "\x22\x5E" => '&#8978;',
 "\x22\x5F" => '&#8706;',
 "\x22\x60" => '&#8711;',
 "\x22\x61" => '&#8801;',
 "\x22\x62" => '&#8786;',
 "\x22\x63" => '&#8810;',
 "\x22\x64" => '&#8811;',
 "\x22\x65" => '&#8730;',
 "\x22\x66" => '&#8765;',
 "\x22\x67" => '&#8733;',
 "\x22\x68" => '&#8757;',
 "\x22\x69" => '&#8747;',
 "\x22\x6A" => '&#8748;',
 "\x22\x72" => '&#8491;',
 "\x22\x73" => '&#8240;',
 "\x22\x74" => '&#9839;',
 "\x22\x75" => '&#9837;',
 "\x22\x76" => '&#9834;',
 "\x22\x77" => '&#8224;',
 "\x22\x78" => '&#8225;',
 "\x22\x79" => '&#182;',
 "\x22\x7E" => '&#9711;',
 "\x23\x30" => '&#65296;',
 "\x23\x31" => '&#65297;',
 "\x23\x32" => '&#65298;',
 "\x23\x33" => '&#65299;',
 "\x23\x34" => '&#65300;',
 "\x23\x35" => '&#65301;',
 "\x23\x36" => '&#65302;',
 "\x23\x37" => '&#65303;',
 "\x23\x38" => '&#65304;',
 "\x23\x39" => '&#65305;',
 "\x23\x41" => '&#65313;',
 "\x23\x42" => '&#65314;',
 "\x23\x43" => '&#65315;',
 "\x23\x44" => '&#65316;',
 "\x23\x45" => '&#65317;',
 "\x23\x46" => '&#65318;',
 "\x23\x47" => '&#65319;',
 "\x23\x48" => '&#65320;',
 "\x23\x49" => '&#65321;',
 "\x23\x4A" => '&#65322;',
 "\x23\x4B" => '&#65323;',
 "\x23\x4C" => '&#65324;',
 "\x23\x4D" => '&#65325;',
 "\x23\x4E" => '&#65326;',
 "\x23\x4F" => '&#65327;',
 "\x23\x50" => '&#65328;',
 "\x23\x51" => '&#65329;',
 "\x23\x52" => '&#65330;',
 "\x23\x53" => '&#65331;',
 "\x23\x54" => '&#65332;',
 "\x23\x55" => '&#65333;',
 "\x23\x56" => '&#65334;',
 "\x23\x57" => '&#65335;',
 "\x23\x58" => '&#65336;',
 "\x23\x59" => '&#65337;',
 "\x23\x5A" => '&#65338;',
 "\x23\x61" => '&#65345;',
 "\x23\x62" => '&#65346;',
 "\x23\x63" => '&#65347;',
 "\x23\x64" => '&#65348;',
 "\x23\x65" => '&#65349;',
 "\x23\x66" => '&#65350;',
 "\x23\x67" => '&#65351;',
 "\x23\x68" => '&#65352;',
 "\x23\x69" => '&#65353;',
 "\x23\x6A" => '&#65354;',
 "\x23\x6B" => '&#65355;',
 "\x23\x6C" => '&#65356;',
 "\x23\x6D" => '&#65357;',
 "\x23\x6E" => '&#65358;',
 "\x23\x6F" => '&#65359;',
 "\x23\x70" => '&#65360;',
 "\x23\x71" => '&#65361;',
 "\x23\x72" => '&#65362;',
 "\x23\x73" => '&#65363;',
 "\x23\x74" => '&#65364;',
 "\x23\x75" => '&#65365;',
 "\x23\x76" => '&#65366;',
 "\x23\x77" => '&#65367;',
 "\x23\x78" => '&#65368;',
 "\x23\x79" => '&#65369;',
 "\x23\x7A" => '&#65370;',
 "\x24\x21" => '&#12353;',
 "\x24\x22" => '&#12354;',
 "\x24\x23" => '&#12355;',
 "\x24\x24" => '&#12356;',
 "\x24\x25" => '&#12357;',
 "\x24\x26" => '&#12358;',
 "\x24\x27" => '&#12359;',
 "\x24\x28" => '&#12360;',
 "\x24\x29" => '&#12361;',
 "\x24\x2A" => '&#12362;',
 "\x24\x2B" => '&#12363;',
 "\x24\x2C" => '&#12364;',
 "\x24\x2D" => '&#12365;',
 "\x24\x2E" => '&#12366;',
 "\x24\x2F" => '&#12367;',
 "\x24\x30" => '&#12368;',
 "\x24\x31" => '&#12369;',
 "\x24\x32" => '&#12370;',
 "\x24\x33" => '&#12371;',
 "\x24\x34" => '&#12372;',
 "\x24\x35" => '&#12373;',
 "\x24\x36" => '&#12374;',
 "\x24\x37" => '&#12375;',
 "\x24\x38" => '&#12376;',
 "\x24\x39" => '&#12377;',
 "\x24\x3A" => '&#12378;',
 "\x24\x3B" => '&#12379;',
 "\x24\x3C" => '&#12380;',
 "\x24\x3D" => '&#12381;',
 "\x24\x3E" => '&#12382;',
 "\x24\x3F" => '&#12383;',
 "\x24\x40" => '&#12384;',
 "\x24\x41" => '&#12385;',
 "\x24\x42" => '&#12386;',
 "\x24\x43" => '&#12387;',
 "\x24\x44" => '&#12388;',
 "\x24\x45" => '&#12389;',
 "\x24\x46" => '&#12390;',
 "\x24\x47" => '&#12391;',
 "\x24\x48" => '&#12392;',
 "\x24\x49" => '&#12393;',
 "\x24\x4A" => '&#12394;',
 "\x24\x4B" => '&#12395;',
 "\x24\x4C" => '&#12396;',
 "\x24\x4D" => '&#12397;',
 "\x24\x4E" => '&#12398;',
 "\x24\x4F" => '&#12399;',
 "\x24\x50" => '&#12400;',
 "\x24\x51" => '&#12401;',
 "\x24\x52" => '&#12402;',
 "\x24\x53" => '&#12403;',
 "\x24\x54" => '&#12404;',
 "\x24\x55" => '&#12405;',
 "\x24\x56" => '&#12406;',
 "\x24\x57" => '&#12407;',
 "\x24\x58" => '&#12408;',
 "\x24\x59" => '&#12409;',
 "\x24\x5A" => '&#12410;',
 "\x24\x5B" => '&#12411;',
 "\x24\x5C" => '&#12412;',
 "\x24\x5D" => '&#12413;',
 "\x24\x5E" => '&#12414;',
 "\x24\x5F" => '&#12415;',
 "\x24\x60" => '&#12416;',
 "\x24\x61" => '&#12417;',
 "\x24\x62" => '&#12418;',
 "\x24\x63" => '&#12419;',
 "\x24\x64" => '&#12420;',
 "\x24\x65" => '&#12421;',
 "\x24\x66" => '&#12422;',
 "\x24\x67" => '&#12423;',
 "\x24\x68" => '&#12424;',
 "\x24\x69" => '&#12425;',
 "\x24\x6A" => '&#12426;',
 "\x24\x6B" => '&#12427;',
 "\x24\x6C" => '&#12428;',
 "\x24\x6D" => '&#12429;',
 "\x24\x6E" => '&#12430;',
 "\x24\x6F" => '&#12431;',
 "\x24\x70" => '&#12432;',
 "\x24\x71" => '&#12433;',
 "\x24\x72" => '&#12434;',
 "\x24\x73" => '&#12435;',
 "\x25\x21" => '&#12449;',
 "\x25\x22" => '&#12450;',
 "\x25\x23" => '&#12451;',
 "\x25\x24" => '&#12452;',
 "\x25\x25" => '&#12453;',
 "\x25\x26" => '&#12454;',
 "\x25\x27" => '&#12455;',
 "\x25\x28" => '&#12456;',
 "\x25\x29" => '&#12457;',
 "\x25\x2A" => '&#12458;',
 "\x25\x2B" => '&#12459;',
 "\x25\x2C" => '&#12460;',
 "\x25\x2D" => '&#12461;',
 "\x25\x2E" => '&#12462;',
 "\x25\x2F" => '&#12463;',
 "\x25\x30" => '&#12464;',
 "\x25\x31" => '&#12465;',
 "\x25\x32" => '&#12466;',
 "\x25\x33" => '&#12467;',
 "\x25\x34" => '&#12468;',
 "\x25\x35" => '&#12469;',
 "\x25\x36" => '&#12470;',
 "\x25\x37" => '&#12471;',
 "\x25\x38" => '&#12472;',
 "\x25\x39" => '&#12473;',
 "\x25\x3A" => '&#12474;',
 "\x25\x3B" => '&#12475;',
 "\x25\x3C" => '&#12476;',
 "\x25\x3D" => '&#12477;',
 "\x25\x3E" => '&#12478;',
 "\x25\x3F" => '&#12479;',
 "\x25\x40" => '&#12480;',
 "\x25\x41" => '&#12481;',
 "\x25\x42" => '&#12482;',
 "\x25\x43" => '&#12483;',
 "\x25\x44" => '&#12484;',
 "\x25\x45" => '&#12485;',
 "\x25\x46" => '&#12486;',
 "\x25\x47" => '&#12487;',
 "\x25\x48" => '&#12488;',
 "\x25\x49" => '&#12489;',
 "\x25\x4A" => '&#12490;',
 "\x25\x4B" => '&#12491;',
 "\x25\x4C" => '&#12492;',
 "\x25\x4D" => '&#12493;',
 "\x25\x4E" => '&#12494;',
 "\x25\x4F" => '&#12495;',
 "\x25\x50" => '&#12496;',
 "\x25\x51" => '&#12497;',
 "\x25\x52" => '&#12498;',
 "\x25\x53" => '&#12499;',
 "\x25\x54" => '&#12500;',
 "\x25\x55" => '&#12501;',
 "\x25\x56" => '&#12502;',
 "\x25\x57" => '&#12503;',
 "\x25\x58" => '&#12504;',
 "\x25\x59" => '&#12505;',
 "\x25\x5A" => '&#12506;',
 "\x25\x5B" => '&#12507;',
 "\x25\x5C" => '&#12508;',
 "\x25\x5D" => '&#12509;',
 "\x25\x5E" => '&#12510;',
 "\x25\x5F" => '&#12511;',
 "\x25\x60" => '&#12512;',
 "\x25\x61" => '&#12513;',
 "\x25\x62" => '&#12514;',
 "\x25\x63" => '&#12515;',
 "\x25\x64" => '&#12516;',
 "\x25\x65" => '&#12517;',
 "\x25\x66" => '&#12518;',
 "\x25\x67" => '&#12519;',
 "\x25\x68" => '&#12520;',
 "\x25\x69" => '&#12521;',
 "\x25\x6A" => '&#12522;',
 "\x25\x6B" => '&#12523;',
 "\x25\x6C" => '&#12524;',
 "\x25\x6D" => '&#12525;',
 "\x25\x6E" => '&#12526;',
 "\x25\x6F" => '&#12527;',
 "\x25\x70" => '&#12528;',
 "\x25\x71" => '&#12529;',
 "\x25\x72" => '&#12530;',
 "\x25\x73" => '&#12531;',
 "\x25\x74" => '&#12532;',
 "\x25\x75" => '&#12533;',
 "\x25\x76" => '&#12534;',
 "\x26\x21" => '&#913;',
 "\x26\x22" => '&#914;',
 "\x26\x23" => '&#915;',
 "\x26\x24" => '&#916;',
 "\x26\x25" => '&#917;',
 "\x26\x26" => '&#918;',
 "\x26\x27" => '&#919;',
 "\x26\x28" => '&#920;',
 "\x26\x29" => '&#921;',
 "\x26\x2A" => '&#922;',
 "\x26\x2B" => '&#923;',
 "\x26\x2C" => '&#924;',
 "\x26\x2D" => '&#925;',
 "\x26\x2E" => '&#926;',
 "\x26\x2F" => '&#927;',
 "\x26\x30" => '&#928;',
 "\x26\x31" => '&#929;',
 "\x26\x32" => '&#931;',
 "\x26\x33" => '&#932;',
 "\x26\x34" => '&#933;',
 "\x26\x35" => '&#934;',
 "\x26\x36" => '&#935;',
 "\x26\x37" => '&#936;',
 "\x26\x38" => '&#937;',
 "\x26\x41" => '&#945;',
 "\x26\x42" => '&#946;',
 "\x26\x43" => '&#947;',
 "\x26\x44" => '&#948;',
 "\x26\x45" => '&#949;',
 "\x26\x46" => '&#950;',
 "\x26\x47" => '&#951;',
 "\x26\x48" => '&#952;',
 "\x26\x49" => '&#953;',
 "\x26\x4A" => '&#954;',
 "\x26\x4B" => '&#955;',
 "\x26\x4C" => '&#956;',
 "\x26\x4D" => '&#957;',
 "\x26\x4E" => '&#958;',
 "\x26\x4F" => '&#959;',
 "\x26\x50" => '&#960;',
 "\x26\x51" => '&#961;',
 "\x26\x52" => '&#963;',
 "\x26\x53" => '&#964;',
 "\x26\x54" => '&#965;',
 "\x26\x55" => '&#966;',
 "\x26\x56" => '&#967;',
 "\x26\x57" => '&#968;',
 "\x26\x58" => '&#969;',
 "\x27\x21" => '&#1040;',
 "\x27\x22" => '&#1041;',
 "\x27\x23" => '&#1042;',
 "\x27\x24" => '&#1043;',
 "\x27\x25" => '&#1044;',
 "\x27\x26" => '&#1045;',
 "\x27\x27" => '&#1025;',
 "\x27\x28" => '&#1046;',
 "\x27\x29" => '&#1047;',
 "\x27\x2A" => '&#1048;',
 "\x27\x2B" => '&#1049;',
 "\x27\x2C" => '&#1050;',
 "\x27\x2D" => '&#1051;',
 "\x27\x2E" => '&#1052;',
 "\x27\x2F" => '&#1053;',
 "\x27\x30" => '&#1054;',
 "\x27\x31" => '&#1055;',
 "\x27\x32" => '&#1056;',
 "\x27\x33" => '&#1057;',
 "\x27\x34" => '&#1058;',
 "\x27\x35" => '&#1059;',
 "\x27\x36" => '&#1060;',
 "\x27\x37" => '&#1061;',
 "\x27\x38" => '&#1062;',
 "\x27\x39" => '&#1063;',
 "\x27\x3A" => '&#1064;',
 "\x27\x3B" => '&#1065;',
 "\x27\x3C" => '&#1066;',
 "\x27\x3D" => '&#1067;',
 "\x27\x3E" => '&#1068;',
 "\x27\x3F" => '&#1069;',
 "\x27\x40" => '&#1070;',
 "\x27\x41" => '&#1071;',
 "\x27\x51" => '&#1072;',
 "\x27\x52" => '&#1073;',
 "\x27\x53" => '&#1074;',
 "\x27\x54" => '&#1075;',
 "\x27\x55" => '&#1076;',
 "\x27\x56" => '&#1077;',
 "\x27\x57" => '&#1105;',
 "\x27\x58" => '&#1078;',
 "\x27\x59" => '&#1079;',
 "\x27\x5A" => '&#1080;',
 "\x27\x5B" => '&#1081;',
 "\x27\x5C" => '&#1082;',
 "\x27\x5D" => '&#1083;',
 "\x27\x5E" => '&#1084;',
 "\x27\x5F" => '&#1085;',
 "\x27\x60" => '&#1086;',
 "\x27\x61" => '&#1087;',
 "\x27\x62" => '&#1088;',
 "\x27\x63" => '&#1089;',
 "\x27\x64" => '&#1090;',
 "\x27\x65" => '&#1091;',
 "\x27\x66" => '&#1092;',
 "\x27\x67" => '&#1093;',
 "\x27\x68" => '&#1094;',
 "\x27\x69" => '&#1095;',
 "\x27\x6A" => '&#1096;',
 "\x27\x6B" => '&#1097;',
 "\x27\x6C" => '&#1098;',
 "\x27\x6D" => '&#1099;',
 "\x27\x6E" => '&#1100;',
 "\x27\x6F" => '&#1101;',
 "\x27\x70" => '&#1102;',
 "\x27\x71" => '&#1103;',
 "\x28\x21" => '&#9472;',
 "\x28\x22" => '&#9474;',
 "\x28\x23" => '&#9484;',
 "\x28\x24" => '&#9488;',
 "\x28\x25" => '&#9496;',
 "\x28\x26" => '&#9492;',
 "\x28\x27" => '&#9500;',
 "\x28\x28" => '&#9516;',
 "\x28\x29" => '&#9508;',
 "\x28\x2A" => '&#9524;',
 "\x28\x2B" => '&#9532;',
 "\x28\x2C" => '&#9473;',
 "\x28\x2D" => '&#9475;',
 "\x28\x2E" => '&#9487;',
 "\x28\x2F" => '&#9491;',
 "\x28\x30" => '&#9499;',
 "\x28\x31" => '&#9495;',
 "\x28\x32" => '&#9507;',
 "\x28\x33" => '&#9523;',
 "\x28\x34" => '&#9515;',
 "\x28\x35" => '&#9531;',
 "\x28\x36" => '&#9547;',
 "\x28\x37" => '&#9504;',
 "\x28\x38" => '&#9519;',
 "\x28\x39" => '&#9512;',
 "\x28\x3A" => '&#9527;',
 "\x28\x3B" => '&#9535;',
 "\x28\x3C" => '&#9501;',
 "\x28\x3D" => '&#9520;',
 "\x28\x3E" => '&#9509;',
 "\x28\x3F" => '&#9528;',
 "\x28\x40" => '&#9538;',
 "\x30\x21" => '&#20124;',
 "\x30\x22" => '&#21782;',
 "\x30\x23" => '&#23043;',
 "\x30\x24" => '&#38463;',
 "\x30\x25" => '&#21696;',
 "\x30\x26" => '&#24859;',
 "\x30\x27" => '&#25384;',
 "\x30\x28" => '&#23030;',
 "\x30\x29" => '&#36898;',
 "\x30\x2A" => '&#33909;',
 "\x30\x2B" => '&#33564;',
 "\x30\x2C" => '&#31312;',
 "\x30\x2D" => '&#24746;',
 "\x30\x2E" => '&#25569;',
 "\x30\x2F" => '&#28197;',
 "\x30\x30" => '&#26093;',
 "\x30\x31" => '&#33894;',
 "\x30\x32" => '&#33446;',
 "\x30\x33" => '&#39925;',
 "\x30\x34" => '&#26771;',
 "\x30\x35" => '&#22311;',
 "\x30\x36" => '&#26017;',
 "\x30\x37" => '&#25201;',
 "\x30\x38" => '&#23451;',
 "\x30\x39" => '&#22992;',
 "\x30\x3A" => '&#34427;',
 "\x30\x3B" => '&#39156;',
 "\x30\x3C" => '&#32098;',
 "\x30\x3D" => '&#32190;',
 "\x30\x3E" => '&#39822;',
 "\x30\x3F" => '&#25110;',
 "\x30\x40" => '&#31903;',
 "\x30\x41" => '&#34999;',
 "\x30\x42" => '&#23433;',
 "\x30\x43" => '&#24245;',
 "\x30\x44" => '&#25353;',
 "\x30\x45" => '&#26263;',
 "\x30\x46" => '&#26696;',
 "\x30\x47" => '&#38343;',
 "\x30\x48" => '&#38797;',
 "\x30\x49" => '&#26447;',
 "\x30\x4A" => '&#20197;',
 "\x30\x4B" => '&#20234;',
 "\x30\x4C" => '&#20301;',
 "\x30\x4D" => '&#20381;',
 "\x30\x4E" => '&#20553;',
 "\x30\x4F" => '&#22258;',
 "\x30\x50" => '&#22839;',
 "\x30\x51" => '&#22996;',
 "\x30\x52" => '&#23041;',
 "\x30\x53" => '&#23561;',
 "\x30\x54" => '&#24799;',
 "\x30\x55" => '&#24847;',
 "\x30\x56" => '&#24944;',
 "\x30\x57" => '&#26131;',
 "\x30\x58" => '&#26885;',
 "\x30\x59" => '&#28858;',
 "\x30\x5A" => '&#30031;',
 "\x30\x5B" => '&#30064;',
 "\x30\x5C" => '&#31227;',
 "\x30\x5D" => '&#32173;',
 "\x30\x5E" => '&#32239;',
 "\x30\x5F" => '&#32963;',
 "\x30\x60" => '&#33806;',
 "\x30\x61" => '&#34915;',
 "\x30\x62" => '&#35586;',
 "\x30\x63" => '&#36949;',
 "\x30\x64" => '&#36986;',
 "\x30\x65" => '&#21307;',
 "\x30\x66" => '&#20117;',
 "\x30\x67" => '&#20133;',
 "\x30\x68" => '&#22495;',
 "\x30\x69" => '&#32946;',
 "\x30\x6A" => '&#37057;',
 "\x30\x6B" => '&#30959;',
 "\x30\x6C" => '&#19968;',
 "\x30\x6D" => '&#22769;',
 "\x30\x6E" => '&#28322;',
 "\x30\x6F" => '&#36920;',
 "\x30\x70" => '&#31282;',
 "\x30\x71" => '&#33576;',
 "\x30\x72" => '&#33419;',
 "\x30\x73" => '&#39983;',
 "\x30\x74" => '&#20801;',
 "\x30\x75" => '&#21360;',
 "\x30\x76" => '&#21693;',
 "\x30\x77" => '&#21729;',
 "\x30\x78" => '&#22240;',
 "\x30\x79" => '&#23035;',
 "\x30\x7A" => '&#24341;',
 "\x30\x7B" => '&#39154;',
 "\x30\x7C" => '&#28139;',
 "\x30\x7D" => '&#32996;',
 "\x30\x7E" => '&#34093;',
 "\x31\x21" => '&#38498;',
 "\x31\x22" => '&#38512;',
 "\x31\x23" => '&#38560;',
 "\x31\x24" => '&#38907;',
 "\x31\x25" => '&#21515;',
 "\x31\x26" => '&#21491;',
 "\x31\x27" => '&#23431;',
 "\x31\x28" => '&#28879;',
 "\x31\x29" => '&#32701;',
 "\x31\x2A" => '&#36802;',
 "\x31\x2B" => '&#38632;',
 "\x31\x2C" => '&#21359;',
 "\x31\x2D" => '&#40284;',
 "\x31\x2E" => '&#31418;',
 "\x31\x2F" => '&#19985;',
 "\x31\x30" => '&#30867;',
 "\x31\x31" => '&#33276;',
 "\x31\x32" => '&#28198;',
 "\x31\x33" => '&#22040;',
 "\x31\x34" => '&#21764;',
 "\x31\x35" => '&#27421;',
 "\x31\x36" => '&#34074;',
 "\x31\x37" => '&#39995;',
 "\x31\x38" => '&#23013;',
 "\x31\x39" => '&#21417;',
 "\x31\x3A" => '&#28006;',
 "\x31\x3B" => '&#29916;',
 "\x31\x3C" => '&#38287;',
 "\x31\x3D" => '&#22082;',
 "\x31\x3E" => '&#20113;',
 "\x31\x3F" => '&#36939;',
 "\x31\x40" => '&#38642;',
 "\x31\x41" => '&#33615;',
 "\x31\x42" => '&#39180;',
 "\x31\x43" => '&#21473;',
 "\x31\x44" => '&#21942;',
 "\x31\x45" => '&#23344;',
 "\x31\x46" => '&#24433;',
 "\x31\x47" => '&#26144;',
 "\x31\x48" => '&#26355;',
 "\x31\x49" => '&#26628;',
 "\x31\x4A" => '&#27704;',
 "\x31\x4B" => '&#27891;',
 "\x31\x4C" => '&#27945;',
 "\x31\x4D" => '&#29787;',
 "\x31\x4E" => '&#30408;',
 "\x31\x4F" => '&#31310;',
 "\x31\x50" => '&#38964;',
 "\x31\x51" => '&#33521;',
 "\x31\x52" => '&#34907;',
 "\x31\x53" => '&#35424;',
 "\x31\x54" => '&#37613;',
 "\x31\x55" => '&#28082;',
 "\x31\x56" => '&#30123;',
 "\x31\x57" => '&#30410;',
 "\x31\x58" => '&#39365;',
 "\x31\x59" => '&#24742;',
 "\x31\x5A" => '&#35585;',
 "\x31\x5B" => '&#36234;',
 "\x31\x5C" => '&#38322;',
 "\x31\x5D" => '&#27022;',
 "\x31\x5E" => '&#21421;',
 "\x31\x5F" => '&#20870;',
 "\x31\x60" => '&#22290;',
 "\x31\x61" => '&#22576;',
 "\x31\x62" => '&#22852;',
 "\x31\x63" => '&#23476;',
 "\x31\x64" => '&#24310;',
 "\x31\x65" => '&#24616;',
 "\x31\x66" => '&#25513;',
 "\x31\x67" => '&#25588;',
 "\x31\x68" => '&#27839;',
 "\x31\x69" => '&#28436;',
 "\x31\x6A" => '&#28814;',
 "\x31\x6B" => '&#28948;',
 "\x31\x6C" => '&#29017;',
 "\x31\x6D" => '&#29141;',
 "\x31\x6E" => '&#29503;',
 "\x31\x6F" => '&#32257;',
 "\x31\x70" => '&#33398;',
 "\x31\x71" => '&#33489;',
 "\x31\x72" => '&#34199;',
 "\x31\x73" => '&#36960;',
 "\x31\x74" => '&#37467;',
 "\x31\x75" => '&#40219;',
 "\x31\x76" => '&#22633;',
 "\x31\x77" => '&#26044;',
 "\x31\x78" => '&#27738;',
 "\x31\x79" => '&#29989;',
 "\x31\x7A" => '&#20985;',
 "\x31\x7B" => '&#22830;',
 "\x31\x7C" => '&#22885;',
 "\x31\x7D" => '&#24448;',
 "\x31\x7E" => '&#24540;',
 "\x32\x21" => '&#25276;',
 "\x32\x22" => '&#26106;',
 "\x32\x23" => '&#27178;',
 "\x32\x24" => '&#27431;',
 "\x32\x25" => '&#27572;',
 "\x32\x26" => '&#29579;',
 "\x32\x27" => '&#32705;',
 "\x32\x28" => '&#35158;',
 "\x32\x29" => '&#40236;',
 "\x32\x2A" => '&#40206;',
 "\x32\x2B" => '&#40644;',
 "\x32\x2C" => '&#23713;',
 "\x32\x2D" => '&#27798;',
 "\x32\x2E" => '&#33659;',
 "\x32\x2F" => '&#20740;',
 "\x32\x30" => '&#23627;',
 "\x32\x31" => '&#25014;',
 "\x32\x32" => '&#33222;',
 "\x32\x33" => '&#26742;',
 "\x32\x34" => '&#29281;',
 "\x32\x35" => '&#20057;',
 "\x32\x36" => '&#20474;',
 "\x32\x37" => '&#21368;',
 "\x32\x38" => '&#24681;',
 "\x32\x39" => '&#28201;',
 "\x32\x3A" => '&#31311;',
 "\x32\x3B" => '&#38899;',
 "\x32\x3C" => '&#19979;',
 "\x32\x3D" => '&#21270;',
 "\x32\x3E" => '&#20206;',
 "\x32\x3F" => '&#20309;',
 "\x32\x40" => '&#20285;',
 "\x32\x41" => '&#20385;',
 "\x32\x42" => '&#20339;',
 "\x32\x43" => '&#21152;',
 "\x32\x44" => '&#21487;',
 "\x32\x45" => '&#22025;',
 "\x32\x46" => '&#22799;',
 "\x32\x47" => '&#23233;',
 "\x32\x48" => '&#23478;',
 "\x32\x49" => '&#23521;',
 "\x32\x4A" => '&#31185;',
 "\x32\x4B" => '&#26247;',
 "\x32\x4C" => '&#26524;',
 "\x32\x4D" => '&#26550;',
 "\x32\x4E" => '&#27468;',
 "\x32\x4F" => '&#27827;',
 "\x32\x50" => '&#28779;',
 "\x32\x51" => '&#29634;',
 "\x32\x52" => '&#31117;',
 "\x32\x53" => '&#31166;',
 "\x32\x54" => '&#31292;',
 "\x32\x55" => '&#31623;',
 "\x32\x56" => '&#33457;',
 "\x32\x57" => '&#33499;',
 "\x32\x58" => '&#33540;',
 "\x32\x59" => '&#33655;',
 "\x32\x5A" => '&#33775;',
 "\x32\x5B" => '&#33747;',
 "\x32\x5C" => '&#34662;',
 "\x32\x5D" => '&#35506;',
 "\x32\x5E" => '&#22057;',
 "\x32\x5F" => '&#36008;',
 "\x32\x60" => '&#36838;',
 "\x32\x61" => '&#36942;',
 "\x32\x62" => '&#38686;',
 "\x32\x63" => '&#34442;',
 "\x32\x64" => '&#20420;',
 "\x32\x65" => '&#23784;',
 "\x32\x66" => '&#25105;',
 "\x32\x67" => '&#29273;',
 "\x32\x68" => '&#30011;',
 "\x32\x69" => '&#33253;',
 "\x32\x6A" => '&#33469;',
 "\x32\x6B" => '&#34558;',
 "\x32\x6C" => '&#36032;',
 "\x32\x6D" => '&#38597;',
 "\x32\x6E" => '&#39187;',
 "\x32\x6F" => '&#39381;',
 "\x32\x70" => '&#20171;',
 "\x32\x71" => '&#20250;',
 "\x32\x72" => '&#35299;',
 "\x32\x73" => '&#22238;',
 "\x32\x74" => '&#22602;',
 "\x32\x75" => '&#22730;',
 "\x32\x76" => '&#24315;',
 "\x32\x77" => '&#24555;',
 "\x32\x78" => '&#24618;',
 "\x32\x79" => '&#24724;',
 "\x32\x7A" => '&#24674;',
 "\x32\x7B" => '&#25040;',
 "\x32\x7C" => '&#25106;',
 "\x32\x7D" => '&#25296;',
 "\x32\x7E" => '&#25913;',
 "\x33\x21" => '&#39745;',
 "\x33\x22" => '&#26214;',
 "\x33\x23" => '&#26800;',
 "\x33\x24" => '&#28023;',
 "\x33\x25" => '&#28784;',
 "\x33\x26" => '&#30028;',
 "\x33\x27" => '&#30342;',
 "\x33\x28" => '&#32117;',
 "\x33\x29" => '&#33445;',
 "\x33\x2A" => '&#34809;',
 "\x33\x2B" => '&#38283;',
 "\x33\x2C" => '&#38542;',
 "\x33\x2D" => '&#35997;',
 "\x33\x2E" => '&#20977;',
 "\x33\x2F" => '&#21182;',
 "\x33\x30" => '&#22806;',
 "\x33\x31" => '&#21683;',
 "\x33\x32" => '&#23475;',
 "\x33\x33" => '&#23830;',
 "\x33\x34" => '&#24936;',
 "\x33\x35" => '&#27010;',
 "\x33\x36" => '&#28079;',
 "\x33\x37" => '&#30861;',
 "\x33\x38" => '&#33995;',
 "\x33\x39" => '&#34903;',
 "\x33\x3A" => '&#35442;',
 "\x33\x3B" => '&#37799;',
 "\x33\x3C" => '&#39608;',
 "\x33\x3D" => '&#28012;',
 "\x33\x3E" => '&#39336;',
 "\x33\x3F" => '&#34521;',
 "\x33\x40" => '&#22435;',
 "\x33\x41" => '&#26623;',
 "\x33\x42" => '&#34510;',
 "\x33\x43" => '&#37390;',
 "\x33\x44" => '&#21123;',
 "\x33\x45" => '&#22151;',
 "\x33\x46" => '&#21508;',
 "\x33\x47" => '&#24275;',
 "\x33\x48" => '&#25313;',
 "\x33\x49" => '&#25785;',
 "\x33\x4A" => '&#26684;',
 "\x33\x4B" => '&#26680;',
 "\x33\x4C" => '&#27579;',
 "\x33\x4D" => '&#29554;',
 "\x33\x4E" => '&#30906;',
 "\x33\x4F" => '&#31339;',
 "\x33\x50" => '&#35226;',
 "\x33\x51" => '&#35282;',
 "\x33\x52" => '&#36203;',
 "\x33\x53" => '&#36611;',
 "\x33\x54" => '&#37101;',
 "\x33\x55" => '&#38307;',
 "\x33\x56" => '&#38548;',
 "\x33\x57" => '&#38761;',
 "\x33\x58" => '&#23398;',
 "\x33\x59" => '&#23731;',
 "\x33\x5A" => '&#27005;',
 "\x33\x5B" => '&#38989;',
 "\x33\x5C" => '&#38990;',
 "\x33\x5D" => '&#25499;',
 "\x33\x5E" => '&#31520;',
 "\x33\x5F" => '&#27179;',
 "\x33\x60" => '&#27263;',
 "\x33\x61" => '&#26806;',
 "\x33\x62" => '&#39949;',
 "\x33\x63" => '&#28511;',
 "\x33\x64" => '&#21106;',
 "\x33\x65" => '&#21917;',
 "\x33\x66" => '&#24688;',
 "\x33\x67" => '&#25324;',
 "\x33\x68" => '&#27963;',
 "\x33\x69" => '&#28167;',
 "\x33\x6A" => '&#28369;',
 "\x33\x6B" => '&#33883;',
 "\x33\x6C" => '&#35088;',
 "\x33\x6D" => '&#36676;',
 "\x33\x6E" => '&#19988;',
 "\x33\x6F" => '&#39993;',
 "\x33\x70" => '&#21494;',
 "\x33\x71" => '&#26907;',
 "\x33\x72" => '&#27194;',
 "\x33\x73" => '&#38788;',
 "\x33\x74" => '&#26666;',
 "\x33\x75" => '&#20828;',
 "\x33\x76" => '&#31427;',
 "\x33\x77" => '&#33970;',
 "\x33\x78" => '&#37340;',
 "\x33\x79" => '&#37772;',
 "\x33\x7A" => '&#22107;',
 "\x33\x7B" => '&#40232;',
 "\x33\x7C" => '&#26658;',
 "\x33\x7D" => '&#33541;',
 "\x33\x7E" => '&#33841;',
 "\x34\x21" => '&#31909;',
 "\x34\x22" => '&#21000;',
 "\x34\x23" => '&#33477;',
 "\x34\x24" => '&#29926;',
 "\x34\x25" => '&#20094;',
 "\x34\x26" => '&#20355;',
 "\x34\x27" => '&#20896;',
 "\x34\x28" => '&#23506;',
 "\x34\x29" => '&#21002;',
 "\x34\x2A" => '&#21208;',
 "\x34\x2B" => '&#21223;',
 "\x34\x2C" => '&#24059;',
 "\x34\x2D" => '&#21914;',
 "\x34\x2E" => '&#22570;',
 "\x34\x2F" => '&#23014;',
 "\x34\x30" => '&#23436;',
 "\x34\x31" => '&#23448;',
 "\x34\x32" => '&#23515;',
 "\x34\x33" => '&#24178;',
 "\x34\x34" => '&#24185;',
 "\x34\x35" => '&#24739;',
 "\x34\x36" => '&#24863;',
 "\x34\x37" => '&#24931;',
 "\x34\x38" => '&#25022;',
 "\x34\x39" => '&#25563;',
 "\x34\x3A" => '&#25954;',
 "\x34\x3B" => '&#26577;',
 "\x34\x3C" => '&#26707;',
 "\x34\x3D" => '&#26874;',
 "\x34\x3E" => '&#27454;',
 "\x34\x3F" => '&#27475;',
 "\x34\x40" => '&#27735;',
 "\x34\x41" => '&#28450;',
 "\x34\x42" => '&#28567;',
 "\x34\x43" => '&#28485;',
 "\x34\x44" => '&#29872;',
 "\x34\x45" => '&#29976;',
 "\x34\x46" => '&#30435;',
 "\x34\x47" => '&#30475;',
 "\x34\x48" => '&#31487;',
 "\x34\x49" => '&#31649;',
 "\x34\x4A" => '&#31777;',
 "\x34\x4B" => '&#32233;',
 "\x34\x4C" => '&#32566;',
 "\x34\x4D" => '&#32752;',
 "\x34\x4E" => '&#32925;',
 "\x34\x4F" => '&#33382;',
 "\x34\x50" => '&#33694;',
 "\x34\x51" => '&#35251;',
 "\x34\x52" => '&#35532;',
 "\x34\x53" => '&#36011;',
 "\x34\x54" => '&#36996;',
 "\x34\x55" => '&#37969;',
 "\x34\x56" => '&#38291;',
 "\x34\x57" => '&#38289;',
 "\x34\x58" => '&#38306;',
 "\x34\x59" => '&#38501;',
 "\x34\x5A" => '&#38867;',
 "\x34\x5B" => '&#39208;',
 "\x34\x5C" => '&#33304;',
 "\x34\x5D" => '&#20024;',
 "\x34\x5E" => '&#21547;',
 "\x34\x5F" => '&#23736;',
 "\x34\x60" => '&#24012;',
 "\x34\x61" => '&#29609;',
 "\x34\x62" => '&#30284;',
 "\x34\x63" => '&#30524;',
 "\x34\x64" => '&#23721;',
 "\x34\x65" => '&#32747;',
 "\x34\x66" => '&#36107;',
 "\x34\x67" => '&#38593;',
 "\x34\x68" => '&#38929;',
 "\x34\x69" => '&#38996;',
 "\x34\x6A" => '&#39000;',
 "\x34\x6B" => '&#20225;',
 "\x34\x6C" => '&#20238;',
 "\x34\x6D" => '&#21361;',
 "\x34\x6E" => '&#21916;',
 "\x34\x6F" => '&#22120;',
 "\x34\x70" => '&#22522;',
 "\x34\x71" => '&#22855;',
 "\x34\x72" => '&#23305;',
 "\x34\x73" => '&#23492;',
 "\x34\x74" => '&#23696;',
 "\x34\x75" => '&#24076;',
 "\x34\x76" => '&#24190;',
 "\x34\x77" => '&#24524;',
 "\x34\x78" => '&#25582;',
 "\x34\x79" => '&#26426;',
 "\x34\x7A" => '&#26071;',
 "\x34\x7B" => '&#26082;',
 "\x34\x7C" => '&#26399;',
 "\x34\x7D" => '&#26827;',
 "\x34\x7E" => '&#26820;',
 "\x35\x21" => '&#27231;',
 "\x35\x22" => '&#24112;',
 "\x35\x23" => '&#27589;',
 "\x35\x24" => '&#27671;',
 "\x35\x25" => '&#27773;',
 "\x35\x26" => '&#30079;',
 "\x35\x27" => '&#31048;',
 "\x35\x28" => '&#23395;',
 "\x35\x29" => '&#31232;',
 "\x35\x2A" => '&#32000;',
 "\x35\x2B" => '&#24509;',
 "\x35\x2C" => '&#35215;',
 "\x35\x2D" => '&#35352;',
 "\x35\x2E" => '&#36020;',
 "\x35\x2F" => '&#36215;',
 "\x35\x30" => '&#36556;',
 "\x35\x31" => '&#36637;',
 "\x35\x32" => '&#39138;',
 "\x35\x33" => '&#39438;',
 "\x35\x34" => '&#39740;',
 "\x35\x35" => '&#20096;',
 "\x35\x36" => '&#20605;',
 "\x35\x37" => '&#20736;',
 "\x35\x38" => '&#22931;',
 "\x35\x39" => '&#23452;',
 "\x35\x3A" => '&#25135;',
 "\x35\x3B" => '&#25216;',
 "\x35\x3C" => '&#25836;',
 "\x35\x3D" => '&#27450;',
 "\x35\x3E" => '&#29344;',
 "\x35\x3F" => '&#30097;',
 "\x35\x40" => '&#31047;',
 "\x35\x41" => '&#32681;',
 "\x35\x42" => '&#34811;',
 "\x35\x43" => '&#35516;',
 "\x35\x44" => '&#35696;',
 "\x35\x45" => '&#25516;',
 "\x35\x46" => '&#33738;',
 "\x35\x47" => '&#38816;',
 "\x35\x48" => '&#21513;',
 "\x35\x49" => '&#21507;',
 "\x35\x4A" => '&#21931;',
 "\x35\x4B" => '&#26708;',
 "\x35\x4C" => '&#27224;',
 "\x35\x4D" => '&#35440;',
 "\x35\x4E" => '&#30759;',
 "\x35\x4F" => '&#26485;',
 "\x35\x50" => '&#40653;',
 "\x35\x51" => '&#21364;',
 "\x35\x52" => '&#23458;',
 "\x35\x53" => '&#33050;',
 "\x35\x54" => '&#34384;',
 "\x35\x55" => '&#36870;',
 "\x35\x56" => '&#19992;',
 "\x35\x57" => '&#20037;',
 "\x35\x58" => '&#20167;',
 "\x35\x59" => '&#20241;',
 "\x35\x5A" => '&#21450;',
 "\x35\x5B" => '&#21560;',
 "\x35\x5C" => '&#23470;',
 "\x35\x5D" => '&#24339;',
 "\x35\x5E" => '&#24613;',
 "\x35\x5F" => '&#25937;',
 "\x35\x60" => '&#26429;',
 "\x35\x61" => '&#27714;',
 "\x35\x62" => '&#27762;',
 "\x35\x63" => '&#27875;',
 "\x35\x64" => '&#28792;',
 "\x35\x65" => '&#29699;',
 "\x35\x66" => '&#31350;',
 "\x35\x67" => '&#31406;',
 "\x35\x68" => '&#31496;',
 "\x35\x69" => '&#32026;',
 "\x35\x6A" => '&#31998;',
 "\x35\x6B" => '&#32102;',
 "\x35\x6C" => '&#26087;',
 "\x35\x6D" => '&#29275;',
 "\x35\x6E" => '&#21435;',
 "\x35\x6F" => '&#23621;',
 "\x35\x70" => '&#24040;',
 "\x35\x71" => '&#25298;',
 "\x35\x72" => '&#25312;',
 "\x35\x73" => '&#25369;',
 "\x35\x74" => '&#28192;',
 "\x35\x75" => '&#34394;',
 "\x35\x76" => '&#35377;',
 "\x35\x77" => '&#36317;',
 "\x35\x78" => '&#37624;',
 "\x35\x79" => '&#28417;',
 "\x35\x7A" => '&#31142;',
 "\x35\x7B" => '&#39770;',
 "\x35\x7C" => '&#20136;',
 "\x35\x7D" => '&#20139;',
 "\x35\x7E" => '&#20140;',
 "\x36\x21" => '&#20379;',
 "\x36\x22" => '&#20384;',
 "\x36\x23" => '&#20689;',
 "\x36\x24" => '&#20807;',
 "\x36\x25" => '&#31478;',
 "\x36\x26" => '&#20849;',
 "\x36\x27" => '&#20982;',
 "\x36\x28" => '&#21332;',
 "\x36\x29" => '&#21281;',
 "\x36\x2A" => '&#21375;',
 "\x36\x2B" => '&#21483;',
 "\x36\x2C" => '&#21932;',
 "\x36\x2D" => '&#22659;',
 "\x36\x2E" => '&#23777;',
 "\x36\x2F" => '&#24375;',
 "\x36\x30" => '&#24394;',
 "\x36\x31" => '&#24623;',
 "\x36\x32" => '&#24656;',
 "\x36\x33" => '&#24685;',
 "\x36\x34" => '&#25375;',
 "\x36\x35" => '&#25945;',
 "\x36\x36" => '&#27211;',
 "\x36\x37" => '&#27841;',
 "\x36\x38" => '&#29378;',
 "\x36\x39" => '&#29421;',
 "\x36\x3A" => '&#30703;',
 "\x36\x3B" => '&#33016;',
 "\x36\x3C" => '&#33029;',
 "\x36\x3D" => '&#33288;',
 "\x36\x3E" => '&#34126;',
 "\x36\x3F" => '&#37111;',
 "\x36\x40" => '&#37857;',
 "\x36\x41" => '&#38911;',
 "\x36\x42" => '&#39255;',
 "\x36\x43" => '&#39514;',
 "\x36\x44" => '&#20208;',
 "\x36\x45" => '&#20957;',
 "\x36\x46" => '&#23597;',
 "\x36\x47" => '&#26241;',
 "\x36\x48" => '&#26989;',
 "\x36\x49" => '&#23616;',
 "\x36\x4A" => '&#26354;',
 "\x36\x4B" => '&#26997;',
 "\x36\x4C" => '&#29577;',
 "\x36\x4D" => '&#26704;',
 "\x36\x4E" => '&#31873;',
 "\x36\x4F" => '&#20677;',
 "\x36\x50" => '&#21220;',
 "\x36\x51" => '&#22343;',
 "\x36\x52" => '&#24062;',
 "\x36\x53" => '&#37670;',
 "\x36\x54" => '&#26020;',
 "\x36\x55" => '&#27427;',
 "\x36\x56" => '&#27453;',
 "\x36\x57" => '&#29748;',
 "\x36\x58" => '&#31105;',
 "\x36\x59" => '&#31165;',
 "\x36\x5A" => '&#31563;',
 "\x36\x5B" => '&#32202;',
 "\x36\x5C" => '&#33465;',
 "\x36\x5D" => '&#33740;',
 "\x36\x5E" => '&#34943;',
 "\x36\x5F" => '&#35167;',
 "\x36\x60" => '&#35641;',
 "\x36\x61" => '&#36817;',
 "\x36\x62" => '&#37329;',
 "\x36\x63" => '&#21535;',
 "\x36\x64" => '&#37504;',
 "\x36\x65" => '&#20061;',
 "\x36\x66" => '&#20534;',
 "\x36\x67" => '&#21477;',
 "\x36\x68" => '&#21306;',
 "\x36\x69" => '&#29399;',
 "\x36\x6A" => '&#29590;',
 "\x36\x6B" => '&#30697;',
 "\x36\x6C" => '&#33510;',
 "\x36\x6D" => '&#36527;',
 "\x36\x6E" => '&#39366;',
 "\x36\x6F" => '&#39368;',
 "\x36\x70" => '&#39378;',
 "\x36\x71" => '&#20855;',
 "\x36\x72" => '&#24858;',
 "\x36\x73" => '&#34398;',
 "\x36\x74" => '&#21936;',
 "\x36\x75" => '&#31354;',
 "\x36\x76" => '&#20598;',
 "\x36\x77" => '&#23507;',
 "\x36\x78" => '&#36935;',
 "\x36\x79" => '&#38533;',
 "\x36\x7A" => '&#20018;',
 "\x36\x7B" => '&#27355;',
 "\x36\x7C" => '&#37351;',
 "\x36\x7D" => '&#23633;',
 "\x36\x7E" => '&#23624;',
 "\x37\x21" => '&#25496;',
 "\x37\x22" => '&#31391;',
 "\x37\x23" => '&#27795;',
 "\x37\x24" => '&#38772;',
 "\x37\x25" => '&#36705;',
 "\x37\x26" => '&#31402;',
 "\x37\x27" => '&#29066;',
 "\x37\x28" => '&#38536;',
 "\x37\x29" => '&#31874;',
 "\x37\x2A" => '&#26647;',
 "\x37\x2B" => '&#32368;',
 "\x37\x2C" => '&#26705;',
 "\x37\x2D" => '&#37740;',
 "\x37\x2E" => '&#21234;',
 "\x37\x2F" => '&#21531;',
 "\x37\x30" => '&#34219;',
 "\x37\x31" => '&#35347;',
 "\x37\x32" => '&#32676;',
 "\x37\x33" => '&#36557;',
 "\x37\x34" => '&#37089;',
 "\x37\x35" => '&#21350;',
 "\x37\x36" => '&#34952;',
 "\x37\x37" => '&#31041;',
 "\x37\x38" => '&#20418;',
 "\x37\x39" => '&#20670;',
 "\x37\x3A" => '&#21009;',
 "\x37\x3B" => '&#20804;',
 "\x37\x3C" => '&#21843;',
 "\x37\x3D" => '&#22317;',
 "\x37\x3E" => '&#29674;',
 "\x37\x3F" => '&#22411;',
 "\x37\x40" => '&#22865;',
 "\x37\x41" => '&#24418;',
 "\x37\x42" => '&#24452;',
 "\x37\x43" => '&#24693;',
 "\x37\x44" => '&#24950;',
 "\x37\x45" => '&#24935;',
 "\x37\x46" => '&#25001;',
 "\x37\x47" => '&#25522;',
 "\x37\x48" => '&#25658;',
 "\x37\x49" => '&#25964;',
 "\x37\x4A" => '&#26223;',
 "\x37\x4B" => '&#26690;',
 "\x37\x4C" => '&#28179;',
 "\x37\x4D" => '&#30054;',
 "\x37\x4E" => '&#31293;',
 "\x37\x4F" => '&#31995;',
 "\x37\x50" => '&#32076;',
 "\x37\x51" => '&#32153;',
 "\x37\x52" => '&#32331;',
 "\x37\x53" => '&#32619;',
 "\x37\x54" => '&#33550;',
 "\x37\x55" => '&#33610;',
 "\x37\x56" => '&#34509;',
 "\x37\x57" => '&#35336;',
 "\x37\x58" => '&#35427;',
 "\x37\x59" => '&#35686;',
 "\x37\x5A" => '&#36605;',
 "\x37\x5B" => '&#38938;',
 "\x37\x5C" => '&#40335;',
 "\x37\x5D" => '&#33464;',
 "\x37\x5E" => '&#36814;',
 "\x37\x5F" => '&#39912;',
 "\x37\x60" => '&#21127;',
 "\x37\x61" => '&#25119;',
 "\x37\x62" => '&#25731;',
 "\x37\x63" => '&#28608;',
 "\x37\x64" => '&#38553;',
 "\x37\x65" => '&#26689;',
 "\x37\x66" => '&#20625;',
 "\x37\x67" => '&#27424;',
 "\x37\x68" => '&#27770;',
 "\x37\x69" => '&#28500;',
 "\x37\x6A" => '&#31348;',
 "\x37\x6B" => '&#32080;',
 "\x37\x6C" => '&#34880;',
 "\x37\x6D" => '&#35363;',
 "\x37\x6E" => '&#26376;',
 "\x37\x6F" => '&#20214;',
 "\x37\x70" => '&#20537;',
 "\x37\x71" => '&#20518;',
 "\x37\x72" => '&#20581;',
 "\x37\x73" => '&#20860;',
 "\x37\x74" => '&#21048;',
 "\x37\x75" => '&#21091;',
 "\x37\x76" => '&#21927;',
 "\x37\x77" => '&#22287;',
 "\x37\x78" => '&#22533;',
 "\x37\x79" => '&#23244;',
 "\x37\x7A" => '&#24314;',
 "\x37\x7B" => '&#25010;',
 "\x37\x7C" => '&#25080;',
 "\x37\x7D" => '&#25331;',
 "\x37\x7E" => '&#25458;',
 "\x38\x21" => '&#26908;',
 "\x38\x22" => '&#27177;',
 "\x38\x23" => '&#29309;',
 "\x38\x24" => '&#29356;',
 "\x38\x25" => '&#29486;',
 "\x38\x26" => '&#30740;',
 "\x38\x27" => '&#30831;',
 "\x38\x28" => '&#32121;',
 "\x38\x29" => '&#30476;',
 "\x38\x2A" => '&#32937;',
 "\x38\x2B" => '&#35211;',
 "\x38\x2C" => '&#35609;',
 "\x38\x2D" => '&#36066;',
 "\x38\x2E" => '&#36562;',
 "\x38\x2F" => '&#36963;',
 "\x38\x30" => '&#37749;',
 "\x38\x31" => '&#38522;',
 "\x38\x32" => '&#38997;',
 "\x38\x33" => '&#39443;',
 "\x38\x34" => '&#40568;',
 "\x38\x35" => '&#20803;',
 "\x38\x36" => '&#21407;',
 "\x38\x37" => '&#21427;',
 "\x38\x38" => '&#24187;',
 "\x38\x39" => '&#24358;',
 "\x38\x3A" => '&#28187;',
 "\x38\x3B" => '&#28304;',
 "\x38\x3C" => '&#29572;',
 "\x38\x3D" => '&#29694;',
 "\x38\x3E" => '&#32067;',
 "\x38\x3F" => '&#33335;',
 "\x38\x40" => '&#35328;',
 "\x38\x41" => '&#35578;',
 "\x38\x42" => '&#38480;',
 "\x38\x43" => '&#20046;',
 "\x38\x44" => '&#20491;',
 "\x38\x45" => '&#21476;',
 "\x38\x46" => '&#21628;',
 "\x38\x47" => '&#22266;',
 "\x38\x48" => '&#22993;',
 "\x38\x49" => '&#23396;',
 "\x38\x4A" => '&#24049;',
 "\x38\x4B" => '&#24235;',
 "\x38\x4C" => '&#24359;',
 "\x38\x4D" => '&#25144;',
 "\x38\x4E" => '&#25925;',
 "\x38\x4F" => '&#26543;',
 "\x38\x50" => '&#28246;',
 "\x38\x51" => '&#29392;',
 "\x38\x52" => '&#31946;',
 "\x38\x53" => '&#34996;',
 "\x38\x54" => '&#32929;',
 "\x38\x55" => '&#32993;',
 "\x38\x56" => '&#33776;',
 "\x38\x57" => '&#34382;',
 "\x38\x58" => '&#35463;',
 "\x38\x59" => '&#36328;',
 "\x38\x5A" => '&#37431;',
 "\x38\x5B" => '&#38599;',
 "\x38\x5C" => '&#39015;',
 "\x38\x5D" => '&#40723;',
 "\x38\x5E" => '&#20116;',
 "\x38\x5F" => '&#20114;',
 "\x38\x60" => '&#20237;',
 "\x38\x61" => '&#21320;',
 "\x38\x62" => '&#21577;',
 "\x38\x63" => '&#21566;',
 "\x38\x64" => '&#23087;',
 "\x38\x65" => '&#24460;',
 "\x38\x66" => '&#24481;',
 "\x38\x67" => '&#24735;',
 "\x38\x68" => '&#26791;',
 "\x38\x69" => '&#27278;',
 "\x38\x6A" => '&#29786;',
 "\x38\x6B" => '&#30849;',
 "\x38\x6C" => '&#35486;',
 "\x38\x6D" => '&#35492;',
 "\x38\x6E" => '&#35703;',
 "\x38\x6F" => '&#37264;',
 "\x38\x70" => '&#20062;',
 "\x38\x71" => '&#39881;',
 "\x38\x72" => '&#20132;',
 "\x38\x73" => '&#20348;',
 "\x38\x74" => '&#20399;',
 "\x38\x75" => '&#20505;',
 "\x38\x76" => '&#20502;',
 "\x38\x77" => '&#20809;',
 "\x38\x78" => '&#20844;',
 "\x38\x79" => '&#21151;',
 "\x38\x7A" => '&#21177;',
 "\x38\x7B" => '&#21246;',
 "\x38\x7C" => '&#21402;',
 "\x38\x7D" => '&#21475;',
 "\x38\x7E" => '&#21521;',
 "\x39\x21" => '&#21518;',
 "\x39\x22" => '&#21897;',
 "\x39\x23" => '&#22353;',
 "\x39\x24" => '&#22434;',
 "\x39\x25" => '&#22909;',
 "\x39\x26" => '&#23380;',
 "\x39\x27" => '&#23389;',
 "\x39\x28" => '&#23439;',
 "\x39\x29" => '&#24037;',
 "\x39\x2A" => '&#24039;',
 "\x39\x2B" => '&#24055;',
 "\x39\x2C" => '&#24184;',
 "\x39\x2D" => '&#24195;',
 "\x39\x2E" => '&#24218;',
 "\x39\x2F" => '&#24247;',
 "\x39\x30" => '&#24344;',
 "\x39\x31" => '&#24658;',
 "\x39\x32" => '&#24908;',
 "\x39\x33" => '&#25239;',
 "\x39\x34" => '&#25304;',
 "\x39\x35" => '&#25511;',
 "\x39\x36" => '&#25915;',
 "\x39\x37" => '&#26114;',
 "\x39\x38" => '&#26179;',
 "\x39\x39" => '&#26356;',
 "\x39\x3A" => '&#26477;',
 "\x39\x3B" => '&#26657;',
 "\x39\x3C" => '&#26775;',
 "\x39\x3D" => '&#27083;',
 "\x39\x3E" => '&#27743;',
 "\x39\x3F" => '&#27946;',
 "\x39\x40" => '&#28009;',
 "\x39\x41" => '&#28207;',
 "\x39\x42" => '&#28317;',
 "\x39\x43" => '&#30002;',
 "\x39\x44" => '&#30343;',
 "\x39\x45" => '&#30828;',
 "\x39\x46" => '&#31295;',
 "\x39\x47" => '&#31968;',
 "\x39\x48" => '&#32005;',
 "\x39\x49" => '&#32024;',
 "\x39\x4A" => '&#32094;',
 "\x39\x4B" => '&#32177;',
 "\x39\x4C" => '&#32789;',
 "\x39\x4D" => '&#32771;',
 "\x39\x4E" => '&#32943;',
 "\x39\x4F" => '&#32945;',
 "\x39\x50" => '&#33108;',
 "\x39\x51" => '&#33167;',
 "\x39\x52" => '&#33322;',
 "\x39\x53" => '&#33618;',
 "\x39\x54" => '&#34892;',
 "\x39\x55" => '&#34913;',
 "\x39\x56" => '&#35611;',
 "\x39\x57" => '&#36002;',
 "\x39\x58" => '&#36092;',
 "\x39\x59" => '&#37066;',
 "\x39\x5A" => '&#37237;',
 "\x39\x5B" => '&#37489;',
 "\x39\x5C" => '&#30783;',
 "\x39\x5D" => '&#37628;',
 "\x39\x5E" => '&#38308;',
 "\x39\x5F" => '&#38477;',
 "\x39\x60" => '&#38917;',
 "\x39\x61" => '&#39321;',
 "\x39\x62" => '&#39640;',
 "\x39\x63" => '&#40251;',
 "\x39\x64" => '&#21083;',
 "\x39\x65" => '&#21163;',
 "\x39\x66" => '&#21495;',
 "\x39\x67" => '&#21512;',
 "\x39\x68" => '&#22741;',
 "\x39\x69" => '&#25335;',
 "\x39\x6A" => '&#28640;',
 "\x39\x6B" => '&#35946;',
 "\x39\x6C" => '&#36703;',
 "\x39\x6D" => '&#40633;',
 "\x39\x6E" => '&#20811;',
 "\x39\x6F" => '&#21051;',
 "\x39\x70" => '&#21578;',
 "\x39\x71" => '&#22269;',
 "\x39\x72" => '&#31296;',
 "\x39\x73" => '&#37239;',
 "\x39\x74" => '&#40288;',
 "\x39\x75" => '&#40658;',
 "\x39\x76" => '&#29508;',
 "\x39\x77" => '&#28425;',
 "\x39\x78" => '&#33136;',
 "\x39\x79" => '&#29969;',
 "\x39\x7A" => '&#24573;',
 "\x39\x7B" => '&#24794;',
 "\x39\x7C" => '&#39592;',
 "\x39\x7D" => '&#29403;',
 "\x39\x7E" => '&#36796;',
 "\x3A\x21" => '&#27492;',
 "\x3A\x22" => '&#38915;',
 "\x3A\x23" => '&#20170;',
 "\x3A\x24" => '&#22256;',
 "\x3A\x25" => '&#22372;',
 "\x3A\x26" => '&#22718;',
 "\x3A\x27" => '&#23130;',
 "\x3A\x28" => '&#24680;',
 "\x3A\x29" => '&#25031;',
 "\x3A\x2A" => '&#26127;',
 "\x3A\x2B" => '&#26118;',
 "\x3A\x2C" => '&#26681;',
 "\x3A\x2D" => '&#26801;',
 "\x3A\x2E" => '&#28151;',
 "\x3A\x2F" => '&#30165;',
 "\x3A\x30" => '&#32058;',
 "\x3A\x31" => '&#33390;',
 "\x3A\x32" => '&#39746;',
 "\x3A\x33" => '&#20123;',
 "\x3A\x34" => '&#20304;',
 "\x3A\x35" => '&#21449;',
 "\x3A\x36" => '&#21766;',
 "\x3A\x37" => '&#23919;',
 "\x3A\x38" => '&#24038;',
 "\x3A\x39" => '&#24046;',
 "\x3A\x3A" => '&#26619;',
 "\x3A\x3B" => '&#27801;',
 "\x3A\x3C" => '&#29811;',
 "\x3A\x3D" => '&#30722;',
 "\x3A\x3E" => '&#35408;',
 "\x3A\x3F" => '&#37782;',
 "\x3A\x40" => '&#35039;',
 "\x3A\x41" => '&#22352;',
 "\x3A\x42" => '&#24231;',
 "\x3A\x43" => '&#25387;',
 "\x3A\x44" => '&#20661;',
 "\x3A\x45" => '&#20652;',
 "\x3A\x46" => '&#20877;',
 "\x3A\x47" => '&#26368;',
 "\x3A\x48" => '&#21705;',
 "\x3A\x49" => '&#22622;',
 "\x3A\x4A" => '&#22971;',
 "\x3A\x4B" => '&#23472;',
 "\x3A\x4C" => '&#24425;',
 "\x3A\x4D" => '&#25165;',
 "\x3A\x4E" => '&#25505;',
 "\x3A\x4F" => '&#26685;',
 "\x3A\x50" => '&#27507;',
 "\x3A\x51" => '&#28168;',
 "\x3A\x52" => '&#28797;',
 "\x3A\x53" => '&#37319;',
 "\x3A\x54" => '&#29312;',
 "\x3A\x55" => '&#30741;',
 "\x3A\x56" => '&#30758;',
 "\x3A\x57" => '&#31085;',
 "\x3A\x58" => '&#25998;',
 "\x3A\x59" => '&#32048;',
 "\x3A\x5A" => '&#33756;',
 "\x3A\x5B" => '&#35009;',
 "\x3A\x5C" => '&#36617;',
 "\x3A\x5D" => '&#38555;',
 "\x3A\x5E" => '&#21092;',
 "\x3A\x5F" => '&#22312;',
 "\x3A\x60" => '&#26448;',
 "\x3A\x61" => '&#32618;',
 "\x3A\x62" => '&#36001;',
 "\x3A\x63" => '&#20916;',
 "\x3A\x64" => '&#22338;',
 "\x3A\x65" => '&#38442;',
 "\x3A\x66" => '&#22586;',
 "\x3A\x67" => '&#27018;',
 "\x3A\x68" => '&#32948;',
 "\x3A\x69" => '&#21682;',
 "\x3A\x6A" => '&#23822;',
 "\x3A\x6B" => '&#22524;',
 "\x3A\x6C" => '&#30869;',
 "\x3A\x6D" => '&#40442;',
 "\x3A\x6E" => '&#20316;',
 "\x3A\x6F" => '&#21066;',
 "\x3A\x70" => '&#21643;',
 "\x3A\x71" => '&#25662;',
 "\x3A\x72" => '&#26152;',
 "\x3A\x73" => '&#26388;',
 "\x3A\x74" => '&#26613;',
 "\x3A\x75" => '&#31364;',
 "\x3A\x76" => '&#31574;',
 "\x3A\x77" => '&#32034;',
 "\x3A\x78" => '&#37679;',
 "\x3A\x79" => '&#26716;',
 "\x3A\x7A" => '&#39853;',
 "\x3A\x7B" => '&#31545;',
 "\x3A\x7C" => '&#21273;',
 "\x3A\x7D" => '&#20874;',
 "\x3A\x7E" => '&#21047;',
 "\x3B\x21" => '&#23519;',
 "\x3B\x22" => '&#25334;',
 "\x3B\x23" => '&#25774;',
 "\x3B\x24" => '&#25830;',
 "\x3B\x25" => '&#26413;',
 "\x3B\x26" => '&#27578;',
 "\x3B\x27" => '&#34217;',
 "\x3B\x28" => '&#38609;',
 "\x3B\x29" => '&#30352;',
 "\x3B\x2A" => '&#39894;',
 "\x3B\x2B" => '&#25420;',
 "\x3B\x2C" => '&#37638;',
 "\x3B\x2D" => '&#39851;',
 "\x3B\x2E" => '&#30399;',
 "\x3B\x2F" => '&#26194;',
 "\x3B\x30" => '&#19977;',
 "\x3B\x31" => '&#20632;',
 "\x3B\x32" => '&#21442;',
 "\x3B\x33" => '&#23665;',
 "\x3B\x34" => '&#24808;',
 "\x3B\x35" => '&#25746;',
 "\x3B\x36" => '&#25955;',
 "\x3B\x37" => '&#26719;',
 "\x3B\x38" => '&#29158;',
 "\x3B\x39" => '&#29642;',
 "\x3B\x3A" => '&#29987;',
 "\x3B\x3B" => '&#31639;',
 "\x3B\x3C" => '&#32386;',
 "\x3B\x3D" => '&#34453;',
 "\x3B\x3E" => '&#35715;',
 "\x3B\x3F" => '&#36059;',
 "\x3B\x40" => '&#37240;',
 "\x3B\x41" => '&#39184;',
 "\x3B\x42" => '&#26028;',
 "\x3B\x43" => '&#26283;',
 "\x3B\x44" => '&#27531;',
 "\x3B\x45" => '&#20181;',
 "\x3B\x46" => '&#20180;',
 "\x3B\x47" => '&#20282;',
 "\x3B\x48" => '&#20351;',
 "\x3B\x49" => '&#21050;',
 "\x3B\x4A" => '&#21496;',
 "\x3B\x4B" => '&#21490;',
 "\x3B\x4C" => '&#21987;',
 "\x3B\x4D" => '&#22235;',
 "\x3B\x4E" => '&#22763;',
 "\x3B\x4F" => '&#22987;',
 "\x3B\x50" => '&#22985;',
 "\x3B\x51" => '&#23039;',
 "\x3B\x52" => '&#23376;',
 "\x3B\x53" => '&#23629;',
 "\x3B\x54" => '&#24066;',
 "\x3B\x55" => '&#24107;',
 "\x3B\x56" => '&#24535;',
 "\x3B\x57" => '&#24605;',
 "\x3B\x58" => '&#25351;',
 "\x3B\x59" => '&#25903;',
 "\x3B\x5A" => '&#23388;',
 "\x3B\x5B" => '&#26031;',
 "\x3B\x5C" => '&#26045;',
 "\x3B\x5D" => '&#26088;',
 "\x3B\x5E" => '&#26525;',
 "\x3B\x5F" => '&#27490;',
 "\x3B\x60" => '&#27515;',
 "\x3B\x61" => '&#27663;',
 "\x3B\x62" => '&#29509;',
 "\x3B\x63" => '&#31049;',
 "\x3B\x64" => '&#31169;',
 "\x3B\x65" => '&#31992;',
 "\x3B\x66" => '&#32025;',
 "\x3B\x67" => '&#32043;',
 "\x3B\x68" => '&#32930;',
 "\x3B\x69" => '&#33026;',
 "\x3B\x6A" => '&#33267;',
 "\x3B\x6B" => '&#35222;',
 "\x3B\x6C" => '&#35422;',
 "\x3B\x6D" => '&#35433;',
 "\x3B\x6E" => '&#35430;',
 "\x3B\x6F" => '&#35468;',
 "\x3B\x70" => '&#35566;',
 "\x3B\x71" => '&#36039;',
 "\x3B\x72" => '&#36060;',
 "\x3B\x73" => '&#38604;',
 "\x3B\x74" => '&#39164;',
 "\x3B\x75" => '&#27503;',
 "\x3B\x76" => '&#20107;',
 "\x3B\x77" => '&#20284;',
 "\x3B\x78" => '&#20365;',
 "\x3B\x79" => '&#20816;',
 "\x3B\x7A" => '&#23383;',
 "\x3B\x7B" => '&#23546;',
 "\x3B\x7C" => '&#24904;',
 "\x3B\x7D" => '&#25345;',
 "\x3B\x7E" => '&#26178;',
 "\x3C\x21" => '&#27425;',
 "\x3C\x22" => '&#28363;',
 "\x3C\x23" => '&#27835;',
 "\x3C\x24" => '&#29246;',
 "\x3C\x25" => '&#29885;',
 "\x3C\x26" => '&#30164;',
 "\x3C\x27" => '&#30913;',
 "\x3C\x28" => '&#31034;',
 "\x3C\x29" => '&#32780;',
 "\x3C\x2A" => '&#32819;',
 "\x3C\x2B" => '&#33258;',
 "\x3C\x2C" => '&#33940;',
 "\x3C\x2D" => '&#36766;',
 "\x3C\x2E" => '&#27728;',
 "\x3C\x2F" => '&#40575;',
 "\x3C\x30" => '&#24335;',
 "\x3C\x31" => '&#35672;',
 "\x3C\x32" => '&#40235;',
 "\x3C\x33" => '&#31482;',
 "\x3C\x34" => '&#36600;',
 "\x3C\x35" => '&#23437;',
 "\x3C\x36" => '&#38635;',
 "\x3C\x37" => '&#19971;',
 "\x3C\x38" => '&#21489;',
 "\x3C\x39" => '&#22519;',
 "\x3C\x3A" => '&#22833;',
 "\x3C\x3B" => '&#23241;',
 "\x3C\x3C" => '&#23460;',
 "\x3C\x3D" => '&#24713;',
 "\x3C\x3E" => '&#28287;',
 "\x3C\x3F" => '&#28422;',
 "\x3C\x40" => '&#30142;',
 "\x3C\x41" => '&#36074;',
 "\x3C\x42" => '&#23455;',
 "\x3C\x43" => '&#34048;',
 "\x3C\x44" => '&#31712;',
 "\x3C\x45" => '&#20594;',
 "\x3C\x46" => '&#26612;',
 "\x3C\x47" => '&#33437;',
 "\x3C\x48" => '&#23649;',
 "\x3C\x49" => '&#34122;',
 "\x3C\x4A" => '&#32286;',
 "\x3C\x4B" => '&#33294;',
 "\x3C\x4C" => '&#20889;',
 "\x3C\x4D" => '&#23556;',
 "\x3C\x4E" => '&#25448;',
 "\x3C\x4F" => '&#36198;',
 "\x3C\x50" => '&#26012;',
 "\x3C\x51" => '&#29038;',
 "\x3C\x52" => '&#31038;',
 "\x3C\x53" => '&#32023;',
 "\x3C\x54" => '&#32773;',
 "\x3C\x55" => '&#35613;',
 "\x3C\x56" => '&#36554;',
 "\x3C\x57" => '&#36974;',
 "\x3C\x58" => '&#34503;',
 "\x3C\x59" => '&#37034;',
 "\x3C\x5A" => '&#20511;',
 "\x3C\x5B" => '&#21242;',
 "\x3C\x5C" => '&#23610;',
 "\x3C\x5D" => '&#26451;',
 "\x3C\x5E" => '&#28796;',
 "\x3C\x5F" => '&#29237;',
 "\x3C\x60" => '&#37196;',
 "\x3C\x61" => '&#37320;',
 "\x3C\x62" => '&#37675;',
 "\x3C\x63" => '&#33509;',
 "\x3C\x64" => '&#23490;',
 "\x3C\x65" => '&#24369;',
 "\x3C\x66" => '&#24825;',
 "\x3C\x67" => '&#20027;',
 "\x3C\x68" => '&#21462;',
 "\x3C\x69" => '&#23432;',
 "\x3C\x6A" => '&#25163;',
 "\x3C\x6B" => '&#26417;',
 "\x3C\x6C" => '&#27530;',
 "\x3C\x6D" => '&#29417;',
 "\x3C\x6E" => '&#29664;',
 "\x3C\x6F" => '&#31278;',
 "\x3C\x70" => '&#33131;',
 "\x3C\x71" => '&#36259;',
 "\x3C\x72" => '&#37202;',
 "\x3C\x73" => '&#39318;',
 "\x3C\x74" => '&#20754;',
 "\x3C\x75" => '&#21463;',
 "\x3C\x76" => '&#21610;',
 "\x3C\x77" => '&#23551;',
 "\x3C\x78" => '&#25480;',
 "\x3C\x79" => '&#27193;',
 "\x3C\x7A" => '&#32172;',
 "\x3C\x7B" => '&#38656;',
 "\x3C\x7C" => '&#22234;',
 "\x3C\x7D" => '&#21454;',
 "\x3C\x7E" => '&#21608;',
 "\x3D\x21" => '&#23447;',
 "\x3D\x22" => '&#23601;',
 "\x3D\x23" => '&#24030;',
 "\x3D\x24" => '&#20462;',
 "\x3D\x25" => '&#24833;',
 "\x3D\x26" => '&#25342;',
 "\x3D\x27" => '&#27954;',
 "\x3D\x28" => '&#31168;',
 "\x3D\x29" => '&#31179;',
 "\x3D\x2A" => '&#32066;',
 "\x3D\x2B" => '&#32333;',
 "\x3D\x2C" => '&#32722;',
 "\x3D\x2D" => '&#33261;',
 "\x3D\x2E" => '&#33311;',
 "\x3D\x2F" => '&#33936;',
 "\x3D\x30" => '&#34886;',
 "\x3D\x31" => '&#35186;',
 "\x3D\x32" => '&#35728;',
 "\x3D\x33" => '&#36468;',
 "\x3D\x34" => '&#36655;',
 "\x3D\x35" => '&#36913;',
 "\x3D\x36" => '&#37195;',
 "\x3D\x37" => '&#37228;',
 "\x3D\x38" => '&#38598;',
 "\x3D\x39" => '&#37276;',
 "\x3D\x3A" => '&#20160;',
 "\x3D\x3B" => '&#20303;',
 "\x3D\x3C" => '&#20805;',
 "\x3D\x3D" => '&#21313;',
 "\x3D\x3E" => '&#24467;',
 "\x3D\x3F" => '&#25102;',
 "\x3D\x40" => '&#26580;',
 "\x3D\x41" => '&#27713;',
 "\x3D\x42" => '&#28171;',
 "\x3D\x43" => '&#29539;',
 "\x3D\x44" => '&#32294;',
 "\x3D\x45" => '&#37325;',
 "\x3D\x46" => '&#37507;',
 "\x3D\x47" => '&#21460;',
 "\x3D\x48" => '&#22809;',
 "\x3D\x49" => '&#23487;',
 "\x3D\x4A" => '&#28113;',
 "\x3D\x4B" => '&#31069;',
 "\x3D\x4C" => '&#32302;',
 "\x3D\x4D" => '&#31899;',
 "\x3D\x4E" => '&#22654;',
 "\x3D\x4F" => '&#29087;',
 "\x3D\x50" => '&#20986;',
 "\x3D\x51" => '&#34899;',
 "\x3D\x52" => '&#36848;',
 "\x3D\x53" => '&#20426;',
 "\x3D\x54" => '&#23803;',
 "\x3D\x55" => '&#26149;',
 "\x3D\x56" => '&#30636;',
 "\x3D\x57" => '&#31459;',
 "\x3D\x58" => '&#33308;',
 "\x3D\x59" => '&#39423;',
 "\x3D\x5A" => '&#20934;',
 "\x3D\x5B" => '&#24490;',
 "\x3D\x5C" => '&#26092;',
 "\x3D\x5D" => '&#26991;',
 "\x3D\x5E" => '&#27529;',
 "\x3D\x5F" => '&#28147;',
 "\x3D\x60" => '&#28310;',
 "\x3D\x61" => '&#28516;',
 "\x3D\x62" => '&#30462;',
 "\x3D\x63" => '&#32020;',
 "\x3D\x64" => '&#24033;',
 "\x3D\x65" => '&#36981;',
 "\x3D\x66" => '&#37255;',
 "\x3D\x67" => '&#38918;',
 "\x3D\x68" => '&#20966;',
 "\x3D\x69" => '&#21021;',
 "\x3D\x6A" => '&#25152;',
 "\x3D\x6B" => '&#26257;',
 "\x3D\x6C" => '&#26329;',
 "\x3D\x6D" => '&#28186;',
 "\x3D\x6E" => '&#24246;',
 "\x3D\x6F" => '&#32210;',
 "\x3D\x70" => '&#32626;',
 "\x3D\x71" => '&#26360;',
 "\x3D\x72" => '&#34223;',
 "\x3D\x73" => '&#34295;',
 "\x3D\x74" => '&#35576;',
 "\x3D\x75" => '&#21161;',
 "\x3D\x76" => '&#21465;',
 "\x3D\x77" => '&#22899;',
 "\x3D\x78" => '&#24207;',
 "\x3D\x79" => '&#24464;',
 "\x3D\x7A" => '&#24661;',
 "\x3D\x7B" => '&#37604;',
 "\x3D\x7C" => '&#38500;',
 "\x3D\x7D" => '&#20663;',
 "\x3D\x7E" => '&#20767;',
 "\x3E\x21" => '&#21213;',
 "\x3E\x22" => '&#21280;',
 "\x3E\x23" => '&#21319;',
 "\x3E\x24" => '&#21484;',
 "\x3E\x25" => '&#21736;',
 "\x3E\x26" => '&#21830;',
 "\x3E\x27" => '&#21809;',
 "\x3E\x28" => '&#22039;',
 "\x3E\x29" => '&#22888;',
 "\x3E\x2A" => '&#22974;',
 "\x3E\x2B" => '&#23100;',
 "\x3E\x2C" => '&#23477;',
 "\x3E\x2D" => '&#23558;',
 "\x3E\x2E" => '&#23567;',
 "\x3E\x2F" => '&#23569;',
 "\x3E\x30" => '&#23578;',
 "\x3E\x31" => '&#24196;',
 "\x3E\x32" => '&#24202;',
 "\x3E\x33" => '&#24288;',
 "\x3E\x34" => '&#24432;',
 "\x3E\x35" => '&#25215;',
 "\x3E\x36" => '&#25220;',
 "\x3E\x37" => '&#25307;',
 "\x3E\x38" => '&#25484;',
 "\x3E\x39" => '&#25463;',
 "\x3E\x3A" => '&#26119;',
 "\x3E\x3B" => '&#26124;',
 "\x3E\x3C" => '&#26157;',
 "\x3E\x3D" => '&#26230;',
 "\x3E\x3E" => '&#26494;',
 "\x3E\x3F" => '&#26786;',
 "\x3E\x40" => '&#27167;',
 "\x3E\x41" => '&#27189;',
 "\x3E\x42" => '&#27836;',
 "\x3E\x43" => '&#28040;',
 "\x3E\x44" => '&#28169;',
 "\x3E\x45" => '&#28248;',
 "\x3E\x46" => '&#28988;',
 "\x3E\x47" => '&#28966;',
 "\x3E\x48" => '&#29031;',
 "\x3E\x49" => '&#30151;',
 "\x3E\x4A" => '&#30465;',
 "\x3E\x4B" => '&#30813;',
 "\x3E\x4C" => '&#30977;',
 "\x3E\x4D" => '&#31077;',
 "\x3E\x4E" => '&#31216;',
 "\x3E\x4F" => '&#31456;',
 "\x3E\x50" => '&#31505;',
 "\x3E\x51" => '&#31911;',
 "\x3E\x52" => '&#32057;',
 "\x3E\x53" => '&#32918;',
 "\x3E\x54" => '&#33750;',
 "\x3E\x55" => '&#33931;',
 "\x3E\x56" => '&#34121;',
 "\x3E\x57" => '&#34909;',
 "\x3E\x58" => '&#35059;',
 "\x3E\x59" => '&#35359;',
 "\x3E\x5A" => '&#35388;',
 "\x3E\x5B" => '&#35412;',
 "\x3E\x5C" => '&#35443;',
 "\x3E\x5D" => '&#35937;',
 "\x3E\x5E" => '&#36062;',
 "\x3E\x5F" => '&#37284;',
 "\x3E\x60" => '&#37478;',
 "\x3E\x61" => '&#37758;',
 "\x3E\x62" => '&#37912;',
 "\x3E\x63" => '&#38556;',
 "\x3E\x64" => '&#38808;',
 "\x3E\x65" => '&#19978;',
 "\x3E\x66" => '&#19976;',
 "\x3E\x67" => '&#19998;',
 "\x3E\x68" => '&#20055;',
 "\x3E\x69" => '&#20887;',
 "\x3E\x6A" => '&#21104;',
 "\x3E\x6B" => '&#22478;',
 "\x3E\x6C" => '&#22580;',
 "\x3E\x6D" => '&#22732;',
 "\x3E\x6E" => '&#23330;',
 "\x3E\x6F" => '&#24120;',
 "\x3E\x70" => '&#24773;',
 "\x3E\x71" => '&#25854;',
 "\x3E\x72" => '&#26465;',
 "\x3E\x73" => '&#26454;',
 "\x3E\x74" => '&#27972;',
 "\x3E\x75" => '&#29366;',
 "\x3E\x76" => '&#30067;',
 "\x3E\x77" => '&#31331;',
 "\x3E\x78" => '&#33976;',
 "\x3E\x79" => '&#35698;',
 "\x3E\x7A" => '&#37304;',
 "\x3E\x7B" => '&#37664;',
 "\x3E\x7C" => '&#22065;',
 "\x3E\x7D" => '&#22516;',
 "\x3E\x7E" => '&#39166;',
 "\x3F\x21" => '&#25325;',
 "\x3F\x22" => '&#26893;',
 "\x3F\x23" => '&#27542;',
 "\x3F\x24" => '&#29165;',
 "\x3F\x25" => '&#32340;',
 "\x3F\x26" => '&#32887;',
 "\x3F\x27" => '&#33394;',
 "\x3F\x28" => '&#35302;',
 "\x3F\x29" => '&#39135;',
 "\x3F\x2A" => '&#34645;',
 "\x3F\x2B" => '&#36785;',
 "\x3F\x2C" => '&#23611;',
 "\x3F\x2D" => '&#20280;',
 "\x3F\x2E" => '&#20449;',
 "\x3F\x2F" => '&#20405;',
 "\x3F\x30" => '&#21767;',
 "\x3F\x31" => '&#23072;',
 "\x3F\x32" => '&#23517;',
 "\x3F\x33" => '&#23529;',
 "\x3F\x34" => '&#24515;',
 "\x3F\x35" => '&#24910;',
 "\x3F\x36" => '&#25391;',
 "\x3F\x37" => '&#26032;',
 "\x3F\x38" => '&#26187;',
 "\x3F\x39" => '&#26862;',
 "\x3F\x3A" => '&#27035;',
 "\x3F\x3B" => '&#28024;',
 "\x3F\x3C" => '&#28145;',
 "\x3F\x3D" => '&#30003;',
 "\x3F\x3E" => '&#30137;',
 "\x3F\x3F" => '&#30495;',
 "\x3F\x40" => '&#31070;',
 "\x3F\x41" => '&#31206;',
 "\x3F\x42" => '&#32051;',
 "\x3F\x43" => '&#33251;',
 "\x3F\x44" => '&#33455;',
 "\x3F\x45" => '&#34218;',
 "\x3F\x46" => '&#35242;',
 "\x3F\x47" => '&#35386;',
 "\x3F\x48" => '&#36523;',
 "\x3F\x49" => '&#36763;',
 "\x3F\x4A" => '&#36914;',
 "\x3F\x4B" => '&#37341;',
 "\x3F\x4C" => '&#38663;',
 "\x3F\x4D" => '&#20154;',
 "\x3F\x4E" => '&#20161;',
 "\x3F\x4F" => '&#20995;',
 "\x3F\x50" => '&#22645;',
 "\x3F\x51" => '&#22764;',
 "\x3F\x52" => '&#23563;',
 "\x3F\x53" => '&#29978;',
 "\x3F\x54" => '&#23613;',
 "\x3F\x55" => '&#33102;',
 "\x3F\x56" => '&#35338;',
 "\x3F\x57" => '&#36805;',
 "\x3F\x58" => '&#38499;',
 "\x3F\x59" => '&#38765;',
 "\x3F\x5A" => '&#31525;',
 "\x3F\x5B" => '&#35535;',
 "\x3F\x5C" => '&#38920;',
 "\x3F\x5D" => '&#37218;',
 "\x3F\x5E" => '&#22259;',
 "\x3F\x5F" => '&#21416;',
 "\x3F\x60" => '&#36887;',
 "\x3F\x61" => '&#21561;',
 "\x3F\x62" => '&#22402;',
 "\x3F\x63" => '&#24101;',
 "\x3F\x64" => '&#25512;',
 "\x3F\x65" => '&#27700;',
 "\x3F\x66" => '&#28810;',
 "\x3F\x67" => '&#30561;',
 "\x3F\x68" => '&#31883;',
 "\x3F\x69" => '&#32736;',
 "\x3F\x6A" => '&#34928;',
 "\x3F\x6B" => '&#36930;',
 "\x3F\x6C" => '&#37204;',
 "\x3F\x6D" => '&#37648;',
 "\x3F\x6E" => '&#37656;',
 "\x3F\x6F" => '&#38543;',
 "\x3F\x70" => '&#29790;',
 "\x3F\x71" => '&#39620;',
 "\x3F\x72" => '&#23815;',
 "\x3F\x73" => '&#23913;',
 "\x3F\x74" => '&#25968;',
 "\x3F\x75" => '&#26530;',
 "\x3F\x76" => '&#36264;',
 "\x3F\x77" => '&#38619;',
 "\x3F\x78" => '&#25454;',
 "\x3F\x79" => '&#26441;',
 "\x3F\x7A" => '&#26905;',
 "\x3F\x7B" => '&#33733;',
 "\x3F\x7C" => '&#38935;',
 "\x3F\x7D" => '&#38592;',
 "\x3F\x7E" => '&#35070;',
 "\x40\x21" => '&#28548;',
 "\x40\x22" => '&#25722;',
 "\x40\x23" => '&#23544;',
 "\x40\x24" => '&#19990;',
 "\x40\x25" => '&#28716;',
 "\x40\x26" => '&#30045;',
 "\x40\x27" => '&#26159;',
 "\x40\x28" => '&#20932;',
 "\x40\x29" => '&#21046;',
 "\x40\x2A" => '&#21218;',
 "\x40\x2B" => '&#22995;',
 "\x40\x2C" => '&#24449;',
 "\x40\x2D" => '&#24615;',
 "\x40\x2E" => '&#25104;',
 "\x40\x2F" => '&#25919;',
 "\x40\x30" => '&#25972;',
 "\x40\x31" => '&#26143;',
 "\x40\x32" => '&#26228;',
 "\x40\x33" => '&#26866;',
 "\x40\x34" => '&#26646;',
 "\x40\x35" => '&#27491;',
 "\x40\x36" => '&#28165;',
 "\x40\x37" => '&#29298;',
 "\x40\x38" => '&#29983;',
 "\x40\x39" => '&#30427;',
 "\x40\x3A" => '&#31934;',
 "\x40\x3B" => '&#32854;',
 "\x40\x3C" => '&#22768;',
 "\x40\x3D" => '&#35069;',
 "\x40\x3E" => '&#35199;',
 "\x40\x3F" => '&#35488;',
 "\x40\x40" => '&#35475;',
 "\x40\x41" => '&#35531;',
 "\x40\x42" => '&#36893;',
 "\x40\x43" => '&#37266;',
 "\x40\x44" => '&#38738;',
 "\x40\x45" => '&#38745;',
 "\x40\x46" => '&#25993;',
 "\x40\x47" => '&#31246;',
 "\x40\x48" => '&#33030;',
 "\x40\x49" => '&#38587;',
 "\x40\x4A" => '&#24109;',
 "\x40\x4B" => '&#24796;',
 "\x40\x4C" => '&#25114;',
 "\x40\x4D" => '&#26021;',
 "\x40\x4E" => '&#26132;',
 "\x40\x4F" => '&#26512;',
 "\x40\x50" => '&#30707;',
 "\x40\x51" => '&#31309;',
 "\x40\x52" => '&#31821;',
 "\x40\x53" => '&#32318;',
 "\x40\x54" => '&#33034;',
 "\x40\x55" => '&#36012;',
 "\x40\x56" => '&#36196;',
 "\x40\x57" => '&#36321;',
 "\x40\x58" => '&#36447;',
 "\x40\x59" => '&#30889;',
 "\x40\x5A" => '&#20999;',
 "\x40\x5B" => '&#25305;',
 "\x40\x5C" => '&#25509;',
 "\x40\x5D" => '&#25666;',
 "\x40\x5E" => '&#25240;',
 "\x40\x5F" => '&#35373;',
 "\x40\x60" => '&#31363;',
 "\x40\x61" => '&#31680;',
 "\x40\x62" => '&#35500;',
 "\x40\x63" => '&#38634;',
 "\x40\x64" => '&#32118;',
 "\x40\x65" => '&#33292;',
 "\x40\x66" => '&#34633;',
 "\x40\x67" => '&#20185;',
 "\x40\x68" => '&#20808;',
 "\x40\x69" => '&#21315;',
 "\x40\x6A" => '&#21344;',
 "\x40\x6B" => '&#23459;',
 "\x40\x6C" => '&#23554;',
 "\x40\x6D" => '&#23574;',
 "\x40\x6E" => '&#24029;',
 "\x40\x6F" => '&#25126;',
 "\x40\x70" => '&#25159;',
 "\x40\x71" => '&#25776;',
 "\x40\x72" => '&#26643;',
 "\x40\x73" => '&#26676;',
 "\x40\x74" => '&#27849;',
 "\x40\x75" => '&#27973;',
 "\x40\x76" => '&#27927;',
 "\x40\x77" => '&#26579;',
 "\x40\x78" => '&#28508;',
 "\x40\x79" => '&#29006;',
 "\x40\x7A" => '&#29053;',
 "\x40\x7B" => '&#26059;',
 "\x40\x7C" => '&#31359;',
 "\x40\x7D" => '&#31661;',
 "\x40\x7E" => '&#32218;',
 "\x41\x21" => '&#32330;',
 "\x41\x22" => '&#32680;',
 "\x41\x23" => '&#33146;',
 "\x41\x24" => '&#33307;',
 "\x41\x25" => '&#33337;',
 "\x41\x26" => '&#34214;',
 "\x41\x27" => '&#35438;',
 "\x41\x28" => '&#36046;',
 "\x41\x29" => '&#36341;',
 "\x41\x2A" => '&#36984;',
 "\x41\x2B" => '&#36983;',
 "\x41\x2C" => '&#37549;',
 "\x41\x2D" => '&#37521;',
 "\x41\x2E" => '&#38275;',
 "\x41\x2F" => '&#39854;',
 "\x41\x30" => '&#21069;',
 "\x41\x31" => '&#21892;',
 "\x41\x32" => '&#28472;',
 "\x41\x33" => '&#28982;',
 "\x41\x34" => '&#20840;',
 "\x41\x35" => '&#31109;',
 "\x41\x36" => '&#32341;',
 "\x41\x37" => '&#33203;',
 "\x41\x38" => '&#31950;',
 "\x41\x39" => '&#22092;',
 "\x41\x3A" => '&#22609;',
 "\x41\x3B" => '&#23720;',
 "\x41\x3C" => '&#25514;',
 "\x41\x3D" => '&#26366;',
 "\x41\x3E" => '&#26365;',
 "\x41\x3F" => '&#26970;',
 "\x41\x40" => '&#29401;',
 "\x41\x41" => '&#30095;',
 "\x41\x42" => '&#30094;',
 "\x41\x43" => '&#30990;',
 "\x41\x44" => '&#31062;',
 "\x41\x45" => '&#31199;',
 "\x41\x46" => '&#31895;',
 "\x41\x47" => '&#32032;',
 "\x41\x48" => '&#32068;',
 "\x41\x49" => '&#34311;',
 "\x41\x4A" => '&#35380;',
 "\x41\x4B" => '&#38459;',
 "\x41\x4C" => '&#36961;',
 "\x41\x4D" => '&#40736;',
 "\x41\x4E" => '&#20711;',
 "\x41\x4F" => '&#21109;',
 "\x41\x50" => '&#21452;',
 "\x41\x51" => '&#21474;',
 "\x41\x52" => '&#20489;',
 "\x41\x53" => '&#21930;',
 "\x41\x54" => '&#22766;',
 "\x41\x55" => '&#22863;',
 "\x41\x56" => '&#29245;',
 "\x41\x57" => '&#23435;',
 "\x41\x58" => '&#23652;',
 "\x41\x59" => '&#21277;',
 "\x41\x5A" => '&#24803;',
 "\x41\x5B" => '&#24819;',
 "\x41\x5C" => '&#25436;',
 "\x41\x5D" => '&#25475;',
 "\x41\x5E" => '&#25407;',
 "\x41\x5F" => '&#25531;',
 "\x41\x60" => '&#25805;',
 "\x41\x61" => '&#26089;',
 "\x41\x62" => '&#26361;',
 "\x41\x63" => '&#24035;',
 "\x41\x64" => '&#27085;',
 "\x41\x65" => '&#27133;',
 "\x41\x66" => '&#28437;',
 "\x41\x67" => '&#29157;',
 "\x41\x68" => '&#20105;',
 "\x41\x69" => '&#30185;',
 "\x41\x6A" => '&#30456;',
 "\x41\x6B" => '&#31379;',
 "\x41\x6C" => '&#31967;',
 "\x41\x6D" => '&#32207;',
 "\x41\x6E" => '&#32156;',
 "\x41\x6F" => '&#32865;',
 "\x41\x70" => '&#33609;',
 "\x41\x71" => '&#33624;',
 "\x41\x72" => '&#33900;',
 "\x41\x73" => '&#33980;',
 "\x41\x74" => '&#34299;',
 "\x41\x75" => '&#35013;',
 "\x41\x76" => '&#36208;',
 "\x41\x77" => '&#36865;',
 "\x41\x78" => '&#36973;',
 "\x41\x79" => '&#37783;',
 "\x41\x7A" => '&#38684;',
 "\x41\x7B" => '&#39442;',
 "\x41\x7C" => '&#20687;',
 "\x41\x7D" => '&#22679;',
 "\x41\x7E" => '&#24974;',
 "\x42\x21" => '&#33235;',
 "\x42\x22" => '&#34101;',
 "\x42\x23" => '&#36104;',
 "\x42\x24" => '&#36896;',
 "\x42\x25" => '&#20419;',
 "\x42\x26" => '&#20596;',
 "\x42\x27" => '&#21063;',
 "\x42\x28" => '&#21363;',
 "\x42\x29" => '&#24687;',
 "\x42\x2A" => '&#25417;',
 "\x42\x2B" => '&#26463;',
 "\x42\x2C" => '&#28204;',
 "\x42\x2D" => '&#36275;',
 "\x42\x2E" => '&#36895;',
 "\x42\x2F" => '&#20439;',
 "\x42\x30" => '&#23646;',
 "\x42\x31" => '&#36042;',
 "\x42\x32" => '&#26063;',
 "\x42\x33" => '&#32154;',
 "\x42\x34" => '&#21330;',
 "\x42\x35" => '&#34966;',
 "\x42\x36" => '&#20854;',
 "\x42\x37" => '&#25539;',
 "\x42\x38" => '&#23384;',
 "\x42\x39" => '&#23403;',
 "\x42\x3A" => '&#23562;',
 "\x42\x3B" => '&#25613;',
 "\x42\x3C" => '&#26449;',
 "\x42\x3D" => '&#36956;',
 "\x42\x3E" => '&#20182;',
 "\x42\x3F" => '&#22810;',
 "\x42\x40" => '&#22826;',
 "\x42\x41" => '&#27760;',
 "\x42\x42" => '&#35409;',
 "\x42\x43" => '&#21822;',
 "\x42\x44" => '&#22549;',
 "\x42\x45" => '&#22949;',
 "\x42\x46" => '&#24816;',
 "\x42\x47" => '&#25171;',
 "\x42\x48" => '&#26561;',
 "\x42\x49" => '&#33333;',
 "\x42\x4A" => '&#26965;',
 "\x42\x4B" => '&#38464;',
 "\x42\x4C" => '&#39364;',
 "\x42\x4D" => '&#39464;',
 "\x42\x4E" => '&#20307;',
 "\x42\x4F" => '&#22534;',
 "\x42\x50" => '&#23550;',
 "\x42\x51" => '&#32784;',
 "\x42\x52" => '&#23729;',
 "\x42\x53" => '&#24111;',
 "\x42\x54" => '&#24453;',
 "\x42\x55" => '&#24608;',
 "\x42\x56" => '&#24907;',
 "\x42\x57" => '&#25140;',
 "\x42\x58" => '&#26367;',
 "\x42\x59" => '&#27888;',
 "\x42\x5A" => '&#28382;',
 "\x42\x5B" => '&#32974;',
 "\x42\x5C" => '&#33151;',
 "\x42\x5D" => '&#33492;',
 "\x42\x5E" => '&#34955;',
 "\x42\x5F" => '&#36024;',
 "\x42\x60" => '&#36864;',
 "\x42\x61" => '&#36910;',
 "\x42\x62" => '&#38538;',
 "\x42\x63" => '&#40667;',
 "\x42\x64" => '&#39899;',
 "\x42\x65" => '&#20195;',
 "\x42\x66" => '&#21488;',
 "\x42\x67" => '&#22823;',
 "\x42\x68" => '&#31532;',
 "\x42\x69" => '&#37261;',
 "\x42\x6A" => '&#38988;',
 "\x42\x6B" => '&#40441;',
 "\x42\x6C" => '&#28381;',
 "\x42\x6D" => '&#28711;',
 "\x42\x6E" => '&#21331;',
 "\x42\x6F" => '&#21828;',
 "\x42\x70" => '&#23429;',
 "\x42\x71" => '&#25176;',
 "\x42\x72" => '&#25246;',
 "\x42\x73" => '&#25299;',
 "\x42\x74" => '&#27810;',
 "\x42\x75" => '&#28655;',
 "\x42\x76" => '&#29730;',
 "\x42\x77" => '&#35351;',
 "\x42\x78" => '&#37944;',
 "\x42\x79" => '&#28609;',
 "\x42\x7A" => '&#35582;',
 "\x42\x7B" => '&#33592;',
 "\x42\x7C" => '&#20967;',
 "\x42\x7D" => '&#34552;',
 "\x42\x7E" => '&#21482;',
 "\x43\x21" => '&#21481;',
 "\x43\x22" => '&#20294;',
 "\x43\x23" => '&#36948;',
 "\x43\x24" => '&#36784;',
 "\x43\x25" => '&#22890;',
 "\x43\x26" => '&#33073;',
 "\x43\x27" => '&#24061;',
 "\x43\x28" => '&#31466;',
 "\x43\x29" => '&#36799;',
 "\x43\x2A" => '&#26842;',
 "\x43\x2B" => '&#35895;',
 "\x43\x2C" => '&#29432;',
 "\x43\x2D" => '&#40008;',
 "\x43\x2E" => '&#27197;',
 "\x43\x2F" => '&#35504;',
 "\x43\x30" => '&#20025;',
 "\x43\x31" => '&#21336;',
 "\x43\x32" => '&#22022;',
 "\x43\x33" => '&#22374;',
 "\x43\x34" => '&#25285;',
 "\x43\x35" => '&#25506;',
 "\x43\x36" => '&#26086;',
 "\x43\x37" => '&#27470;',
 "\x43\x38" => '&#28129;',
 "\x43\x39" => '&#28251;',
 "\x43\x3A" => '&#28845;',
 "\x43\x3B" => '&#30701;',
 "\x43\x3C" => '&#31471;',
 "\x43\x3D" => '&#31658;',
 "\x43\x3E" => '&#32187;',
 "\x43\x3F" => '&#32829;',
 "\x43\x40" => '&#32966;',
 "\x43\x41" => '&#34507;',
 "\x43\x42" => '&#35477;',
 "\x43\x43" => '&#37723;',
 "\x43\x44" => '&#22243;',
 "\x43\x45" => '&#22727;',
 "\x43\x46" => '&#24382;',
 "\x43\x47" => '&#26029;',
 "\x43\x48" => '&#26262;',
 "\x43\x49" => '&#27264;',
 "\x43\x4A" => '&#27573;',
 "\x43\x4B" => '&#30007;',
 "\x43\x4C" => '&#35527;',
 "\x43\x4D" => '&#20516;',
 "\x43\x4E" => '&#30693;',
 "\x43\x4F" => '&#22320;',
 "\x43\x50" => '&#24347;',
 "\x43\x51" => '&#24677;',
 "\x43\x52" => '&#26234;',
 "\x43\x53" => '&#27744;',
 "\x43\x54" => '&#30196;',
 "\x43\x55" => '&#31258;',
 "\x43\x56" => '&#32622;',
 "\x43\x57" => '&#33268;',
 "\x43\x58" => '&#34584;',
 "\x43\x59" => '&#36933;',
 "\x43\x5A" => '&#39347;',
 "\x43\x5B" => '&#31689;',
 "\x43\x5C" => '&#30044;',
 "\x43\x5D" => '&#31481;',
 "\x43\x5E" => '&#31569;',
 "\x43\x5F" => '&#33988;',
 "\x43\x60" => '&#36880;',
 "\x43\x61" => '&#31209;',
 "\x43\x62" => '&#31378;',
 "\x43\x63" => '&#33590;',
 "\x43\x64" => '&#23265;',
 "\x43\x65" => '&#30528;',
 "\x43\x66" => '&#20013;',
 "\x43\x67" => '&#20210;',
 "\x43\x68" => '&#23449;',
 "\x43\x69" => '&#24544;',
 "\x43\x6A" => '&#25277;',
 "\x43\x6B" => '&#26172;',
 "\x43\x6C" => '&#26609;',
 "\x43\x6D" => '&#27880;',
 "\x43\x6E" => '&#34411;',
 "\x43\x6F" => '&#34935;',
 "\x43\x70" => '&#35387;',
 "\x43\x71" => '&#37198;',
 "\x43\x72" => '&#37619;',
 "\x43\x73" => '&#39376;',
 "\x43\x74" => '&#27159;',
 "\x43\x75" => '&#28710;',
 "\x43\x76" => '&#29482;',
 "\x43\x77" => '&#33511;',
 "\x43\x78" => '&#33879;',
 "\x43\x79" => '&#36015;',
 "\x43\x7A" => '&#19969;',
 "\x43\x7B" => '&#20806;',
 "\x43\x7C" => '&#20939;',
 "\x43\x7D" => '&#21899;',
 "\x43\x7E" => '&#23541;',
 "\x44\x21" => '&#24086;',
 "\x44\x22" => '&#24115;',
 "\x44\x23" => '&#24193;',
 "\x44\x24" => '&#24340;',
 "\x44\x25" => '&#24373;',
 "\x44\x26" => '&#24427;',
 "\x44\x27" => '&#24500;',
 "\x44\x28" => '&#25074;',
 "\x44\x29" => '&#25361;',
 "\x44\x2A" => '&#26274;',
 "\x44\x2B" => '&#26397;',
 "\x44\x2C" => '&#28526;',
 "\x44\x2D" => '&#29266;',
 "\x44\x2E" => '&#30010;',
 "\x44\x2F" => '&#30522;',
 "\x44\x30" => '&#32884;',
 "\x44\x31" => '&#33081;',
 "\x44\x32" => '&#33144;',
 "\x44\x33" => '&#34678;',
 "\x44\x34" => '&#35519;',
 "\x44\x35" => '&#35548;',
 "\x44\x36" => '&#36229;',
 "\x44\x37" => '&#36339;',
 "\x44\x38" => '&#37530;',
 "\x44\x39" => '&#38263;',
 "\x44\x3A" => '&#38914;',
 "\x44\x3B" => '&#40165;',
 "\x44\x3C" => '&#21189;',
 "\x44\x3D" => '&#25431;',
 "\x44\x3E" => '&#30452;',
 "\x44\x3F" => '&#26389;',
 "\x44\x40" => '&#27784;',
 "\x44\x41" => '&#29645;',
 "\x44\x42" => '&#36035;',
 "\x44\x43" => '&#37806;',
 "\x44\x44" => '&#38515;',
 "\x44\x45" => '&#27941;',
 "\x44\x46" => '&#22684;',
 "\x44\x47" => '&#26894;',
 "\x44\x48" => '&#27084;',
 "\x44\x49" => '&#36861;',
 "\x44\x4A" => '&#37786;',
 "\x44\x4B" => '&#30171;',
 "\x44\x4C" => '&#36890;',
 "\x44\x4D" => '&#22618;',
 "\x44\x4E" => '&#26626;',
 "\x44\x4F" => '&#25524;',
 "\x44\x50" => '&#27131;',
 "\x44\x51" => '&#20291;',
 "\x44\x52" => '&#28460;',
 "\x44\x53" => '&#26584;',
 "\x44\x54" => '&#36795;',
 "\x44\x55" => '&#34086;',
 "\x44\x56" => '&#32180;',
 "\x44\x57" => '&#37716;',
 "\x44\x58" => '&#26943;',
 "\x44\x59" => '&#28528;',
 "\x44\x5A" => '&#22378;',
 "\x44\x5B" => '&#22775;',
 "\x44\x5C" => '&#23340;',
 "\x44\x5D" => '&#32044;',
 "\x44\x5E" => '&#29226;',
 "\x44\x5F" => '&#21514;',
 "\x44\x60" => '&#37347;',
 "\x44\x61" => '&#40372;',
 "\x44\x62" => '&#20141;',
 "\x44\x63" => '&#20302;',
 "\x44\x64" => '&#20572;',
 "\x44\x65" => '&#20597;',
 "\x44\x66" => '&#21059;',
 "\x44\x67" => '&#35998;',
 "\x44\x68" => '&#21576;',
 "\x44\x69" => '&#22564;',
 "\x44\x6A" => '&#23450;',
 "\x44\x6B" => '&#24093;',
 "\x44\x6C" => '&#24213;',
 "\x44\x6D" => '&#24237;',
 "\x44\x6E" => '&#24311;',
 "\x44\x6F" => '&#24351;',
 "\x44\x70" => '&#24716;',
 "\x44\x71" => '&#25269;',
 "\x44\x72" => '&#25402;',
 "\x44\x73" => '&#25552;',
 "\x44\x74" => '&#26799;',
 "\x44\x75" => '&#27712;',
 "\x44\x76" => '&#30855;',
 "\x44\x77" => '&#31118;',
 "\x44\x78" => '&#31243;',
 "\x44\x79" => '&#32224;',
 "\x44\x7A" => '&#33351;',
 "\x44\x7B" => '&#35330;',
 "\x44\x7C" => '&#35558;',
 "\x44\x7D" => '&#36420;',
 "\x44\x7E" => '&#36883;',
 "\x45\x21" => '&#37048;',
 "\x45\x22" => '&#37165;',
 "\x45\x23" => '&#37336;',
 "\x45\x24" => '&#40718;',
 "\x45\x25" => '&#27877;',
 "\x45\x26" => '&#25688;',
 "\x45\x27" => '&#25826;',
 "\x45\x28" => '&#25973;',
 "\x45\x29" => '&#28404;',
 "\x45\x2A" => '&#30340;',
 "\x45\x2B" => '&#31515;',
 "\x45\x2C" => '&#36969;',
 "\x45\x2D" => '&#37841;',
 "\x45\x2E" => '&#28346;',
 "\x45\x2F" => '&#21746;',
 "\x45\x30" => '&#24505;',
 "\x45\x31" => '&#25764;',
 "\x45\x32" => '&#36685;',
 "\x45\x33" => '&#36845;',
 "\x45\x34" => '&#37444;',
 "\x45\x35" => '&#20856;',
 "\x45\x36" => '&#22635;',
 "\x45\x37" => '&#22825;',
 "\x45\x38" => '&#23637;',
 "\x45\x39" => '&#24215;',
 "\x45\x3A" => '&#28155;',
 "\x45\x3B" => '&#32399;',
 "\x45\x3C" => '&#29980;',
 "\x45\x3D" => '&#36028;',
 "\x45\x3E" => '&#36578;',
 "\x45\x3F" => '&#39003;',
 "\x45\x40" => '&#28857;',
 "\x45\x41" => '&#20253;',
 "\x45\x42" => '&#27583;',
 "\x45\x43" => '&#28593;',
 "\x45\x44" => '&#30000;',
 "\x45\x45" => '&#38651;',
 "\x45\x46" => '&#20814;',
 "\x45\x47" => '&#21520;',
 "\x45\x48" => '&#22581;',
 "\x45\x49" => '&#22615;',
 "\x45\x4A" => '&#22956;',
 "\x45\x4B" => '&#23648;',
 "\x45\x4C" => '&#24466;',
 "\x45\x4D" => '&#26007;',
 "\x45\x4E" => '&#26460;',
 "\x45\x4F" => '&#28193;',
 "\x45\x50" => '&#30331;',
 "\x45\x51" => '&#33759;',
 "\x45\x52" => '&#36077;',
 "\x45\x53" => '&#36884;',
 "\x45\x54" => '&#37117;',
 "\x45\x55" => '&#37709;',
 "\x45\x56" => '&#30757;',
 "\x45\x57" => '&#30778;',
 "\x45\x58" => '&#21162;',
 "\x45\x59" => '&#24230;',
 "\x45\x5A" => '&#22303;',
 "\x45\x5B" => '&#22900;',
 "\x45\x5C" => '&#24594;',
 "\x45\x5D" => '&#20498;',
 "\x45\x5E" => '&#20826;',
 "\x45\x5F" => '&#20908;',
 "\x45\x60" => '&#20941;',
 "\x45\x61" => '&#20992;',
 "\x45\x62" => '&#21776;',
 "\x45\x63" => '&#22612;',
 "\x45\x64" => '&#22616;',
 "\x45\x65" => '&#22871;',
 "\x45\x66" => '&#23445;',
 "\x45\x67" => '&#23798;',
 "\x45\x68" => '&#23947;',
 "\x45\x69" => '&#24764;',
 "\x45\x6A" => '&#25237;',
 "\x45\x6B" => '&#25645;',
 "\x45\x6C" => '&#26481;',
 "\x45\x6D" => '&#26691;',
 "\x45\x6E" => '&#26812;',
 "\x45\x6F" => '&#26847;',
 "\x45\x70" => '&#30423;',
 "\x45\x71" => '&#28120;',
 "\x45\x72" => '&#28271;',
 "\x45\x73" => '&#28059;',
 "\x45\x74" => '&#28783;',
 "\x45\x75" => '&#29128;',
 "\x45\x76" => '&#24403;',
 "\x45\x77" => '&#30168;',
 "\x45\x78" => '&#31095;',
 "\x45\x79" => '&#31561;',
 "\x45\x7A" => '&#31572;',
 "\x45\x7B" => '&#31570;',
 "\x45\x7C" => '&#31958;',
 "\x45\x7D" => '&#32113;',
 "\x45\x7E" => '&#21040;',
 "\x46\x21" => '&#33891;',
 "\x46\x22" => '&#34153;',
 "\x46\x23" => '&#34276;',
 "\x46\x24" => '&#35342;',
 "\x46\x25" => '&#35588;',
 "\x46\x26" => '&#35910;',
 "\x46\x27" => '&#36367;',
 "\x46\x28" => '&#36867;',
 "\x46\x29" => '&#36879;',
 "\x46\x2A" => '&#37913;',
 "\x46\x2B" => '&#38518;',
 "\x46\x2C" => '&#38957;',
 "\x46\x2D" => '&#39472;',
 "\x46\x2E" => '&#38360;',
 "\x46\x2F" => '&#20685;',
 "\x46\x30" => '&#21205;',
 "\x46\x31" => '&#21516;',
 "\x46\x32" => '&#22530;',
 "\x46\x33" => '&#23566;',
 "\x46\x34" => '&#24999;',
 "\x46\x35" => '&#25758;',
 "\x46\x36" => '&#27934;',
 "\x46\x37" => '&#30643;',
 "\x46\x38" => '&#31461;',
 "\x46\x39" => '&#33012;',
 "\x46\x3A" => '&#33796;',
 "\x46\x3B" => '&#36947;',
 "\x46\x3C" => '&#37509;',
 "\x46\x3D" => '&#23776;',
 "\x46\x3E" => '&#40199;',
 "\x46\x3F" => '&#21311;',
 "\x46\x40" => '&#24471;',
 "\x46\x41" => '&#24499;',
 "\x46\x42" => '&#28060;',
 "\x46\x43" => '&#29305;',
 "\x46\x44" => '&#30563;',
 "\x46\x45" => '&#31167;',
 "\x46\x46" => '&#31716;',
 "\x46\x47" => '&#27602;',
 "\x46\x48" => '&#29420;',
 "\x46\x49" => '&#35501;',
 "\x46\x4A" => '&#26627;',
 "\x46\x4B" => '&#27233;',
 "\x46\x4C" => '&#20984;',
 "\x46\x4D" => '&#31361;',
 "\x46\x4E" => '&#26932;',
 "\x46\x4F" => '&#23626;',
 "\x46\x50" => '&#40182;',
 "\x46\x51" => '&#33515;',
 "\x46\x52" => '&#23493;',
 "\x46\x53" => '&#37193;',
 "\x46\x54" => '&#28702;',
 "\x46\x55" => '&#22136;',
 "\x46\x56" => '&#23663;',
 "\x46\x57" => '&#24775;',
 "\x46\x58" => '&#25958;',
 "\x46\x59" => '&#27788;',
 "\x46\x5A" => '&#35930;',
 "\x46\x5B" => '&#36929;',
 "\x46\x5C" => '&#38931;',
 "\x46\x5D" => '&#21585;',
 "\x46\x5E" => '&#26311;',
 "\x46\x5F" => '&#37389;',
 "\x46\x60" => '&#22856;',
 "\x46\x61" => '&#37027;',
 "\x46\x62" => '&#20869;',
 "\x46\x63" => '&#20045;',
 "\x46\x64" => '&#20970;',
 "\x46\x65" => '&#34201;',
 "\x46\x66" => '&#35598;',
 "\x46\x67" => '&#28760;',
 "\x46\x68" => '&#25466;',
 "\x46\x69" => '&#37707;',
 "\x46\x6A" => '&#26978;',
 "\x46\x6B" => '&#39348;',
 "\x46\x6C" => '&#32260;',
 "\x46\x6D" => '&#30071;',
 "\x46\x6E" => '&#21335;',
 "\x46\x6F" => '&#26976;',
 "\x46\x70" => '&#36575;',
 "\x46\x71" => '&#38627;',
 "\x46\x72" => '&#27741;',
 "\x46\x73" => '&#20108;',
 "\x46\x74" => '&#23612;',
 "\x46\x75" => '&#24336;',
 "\x46\x76" => '&#36841;',
 "\x46\x77" => '&#21250;',
 "\x46\x78" => '&#36049;',
 "\x46\x79" => '&#32905;',
 "\x46\x7A" => '&#34425;',
 "\x46\x7B" => '&#24319;',
 "\x46\x7C" => '&#26085;',
 "\x46\x7D" => '&#20083;',
 "\x46\x7E" => '&#20837;',
 "\x47\x21" => '&#22914;',
 "\x47\x22" => '&#23615;',
 "\x47\x23" => '&#38894;',
 "\x47\x24" => '&#20219;',
 "\x47\x25" => '&#22922;',
 "\x47\x26" => '&#24525;',
 "\x47\x27" => '&#35469;',
 "\x47\x28" => '&#28641;',
 "\x47\x29" => '&#31152;',
 "\x47\x2A" => '&#31074;',
 "\x47\x2B" => '&#23527;',
 "\x47\x2C" => '&#33905;',
 "\x47\x2D" => '&#29483;',
 "\x47\x2E" => '&#29105;',
 "\x47\x2F" => '&#24180;',
 "\x47\x30" => '&#24565;',
 "\x47\x31" => '&#25467;',
 "\x47\x32" => '&#25754;',
 "\x47\x33" => '&#29123;',
 "\x47\x34" => '&#31896;',
 "\x47\x35" => '&#20035;',
 "\x47\x36" => '&#24316;',
 "\x47\x37" => '&#20043;',
 "\x47\x38" => '&#22492;',
 "\x47\x39" => '&#22178;',
 "\x47\x3A" => '&#24745;',
 "\x47\x3B" => '&#28611;',
 "\x47\x3C" => '&#32013;',
 "\x47\x3D" => '&#33021;',
 "\x47\x3E" => '&#33075;',
 "\x47\x3F" => '&#33215;',
 "\x47\x40" => '&#36786;',
 "\x47\x41" => '&#35223;',
 "\x47\x42" => '&#34468;',
 "\x47\x43" => '&#24052;',
 "\x47\x44" => '&#25226;',
 "\x47\x45" => '&#25773;',
 "\x47\x46" => '&#35207;',
 "\x47\x47" => '&#26487;',
 "\x47\x48" => '&#27874;',
 "\x47\x49" => '&#27966;',
 "\x47\x4A" => '&#29750;',
 "\x47\x4B" => '&#30772;',
 "\x47\x4C" => '&#23110;',
 "\x47\x4D" => '&#32629;',
 "\x47\x4E" => '&#33453;',
 "\x47\x4F" => '&#39340;',
 "\x47\x50" => '&#20467;',
 "\x47\x51" => '&#24259;',
 "\x47\x52" => '&#25309;',
 "\x47\x53" => '&#25490;',
 "\x47\x54" => '&#25943;',
 "\x47\x55" => '&#26479;',
 "\x47\x56" => '&#30403;',
 "\x47\x57" => '&#29260;',
 "\x47\x58" => '&#32972;',
 "\x47\x59" => '&#32954;',
 "\x47\x5A" => '&#36649;',
 "\x47\x5B" => '&#37197;',
 "\x47\x5C" => '&#20493;',
 "\x47\x5D" => '&#22521;',
 "\x47\x5E" => '&#23186;',
 "\x47\x5F" => '&#26757;',
 "\x47\x60" => '&#26995;',
 "\x47\x61" => '&#29028;',
 "\x47\x62" => '&#29437;',
 "\x47\x63" => '&#36023;',
 "\x47\x64" => '&#22770;',
 "\x47\x65" => '&#36064;',
 "\x47\x66" => '&#38506;',
 "\x47\x67" => '&#36889;',
 "\x47\x68" => '&#34687;',
 "\x47\x69" => '&#31204;',
 "\x47\x6A" => '&#30695;',
 "\x47\x6B" => '&#33833;',
 "\x47\x6C" => '&#20271;',
 "\x47\x6D" => '&#21093;',
 "\x47\x6E" => '&#21338;',
 "\x47\x6F" => '&#25293;',
 "\x47\x70" => '&#26575;',
 "\x47\x71" => '&#27850;',
 "\x47\x72" => '&#30333;',
 "\x47\x73" => '&#31636;',
 "\x47\x74" => '&#31893;',
 "\x47\x75" => '&#33334;',
 "\x47\x76" => '&#34180;',
 "\x47\x77" => '&#36843;',
 "\x47\x78" => '&#26333;',
 "\x47\x79" => '&#28448;',
 "\x47\x7A" => '&#29190;',
 "\x47\x7B" => '&#32283;',
 "\x47\x7C" => '&#33707;',
 "\x47\x7D" => '&#39361;',
 "\x47\x7E" => '&#40614;',
 "\x48\x21" => '&#20989;',
 "\x48\x22" => '&#31665;',
 "\x48\x23" => '&#30834;',
 "\x48\x24" => '&#31672;',
 "\x48\x25" => '&#32903;',
 "\x48\x26" => '&#31560;',
 "\x48\x27" => '&#27368;',
 "\x48\x28" => '&#24161;',
 "\x48\x29" => '&#32908;',
 "\x48\x2A" => '&#30033;',
 "\x48\x2B" => '&#30048;',
 "\x48\x2C" => '&#20843;',
 "\x48\x2D" => '&#37474;',
 "\x48\x2E" => '&#28300;',
 "\x48\x2F" => '&#30330;',
 "\x48\x30" => '&#37271;',
 "\x48\x31" => '&#39658;',
 "\x48\x32" => '&#20240;',
 "\x48\x33" => '&#32624;',
 "\x48\x34" => '&#25244;',
 "\x48\x35" => '&#31567;',
 "\x48\x36" => '&#38309;',
 "\x48\x37" => '&#40169;',
 "\x48\x38" => '&#22138;',
 "\x48\x39" => '&#22617;',
 "\x48\x3A" => '&#34532;',
 "\x48\x3B" => '&#38588;',
 "\x48\x3C" => '&#20276;',
 "\x48\x3D" => '&#21028;',
 "\x48\x3E" => '&#21322;',
 "\x48\x3F" => '&#21453;',
 "\x48\x40" => '&#21467;',
 "\x48\x41" => '&#24070;',
 "\x48\x42" => '&#25644;',
 "\x48\x43" => '&#26001;',
 "\x48\x44" => '&#26495;',
 "\x48\x45" => '&#27710;',
 "\x48\x46" => '&#27726;',
 "\x48\x47" => '&#29256;',
 "\x48\x48" => '&#29359;',
 "\x48\x49" => '&#29677;',
 "\x48\x4A" => '&#30036;',
 "\x48\x4B" => '&#32321;',
 "\x48\x4C" => '&#33324;',
 "\x48\x4D" => '&#34281;',
 "\x48\x4E" => '&#36009;',
 "\x48\x4F" => '&#31684;',
 "\x48\x50" => '&#37318;',
 "\x48\x51" => '&#29033;',
 "\x48\x52" => '&#38930;',
 "\x48\x53" => '&#39151;',
 "\x48\x54" => '&#25405;',
 "\x48\x55" => '&#26217;',
 "\x48\x56" => '&#30058;',
 "\x48\x57" => '&#30436;',
 "\x48\x58" => '&#30928;',
 "\x48\x59" => '&#34115;',
 "\x48\x5A" => '&#34542;',
 "\x48\x5B" => '&#21290;',
 "\x48\x5C" => '&#21329;',
 "\x48\x5D" => '&#21542;',
 "\x48\x5E" => '&#22915;',
 "\x48\x5F" => '&#24199;',
 "\x48\x60" => '&#24444;',
 "\x48\x61" => '&#24754;',
 "\x48\x62" => '&#25161;',
 "\x48\x63" => '&#25209;',
 "\x48\x64" => '&#25259;',
 "\x48\x65" => '&#26000;',
 "\x48\x66" => '&#27604;',
 "\x48\x67" => '&#27852;',
 "\x48\x68" => '&#30130;',
 "\x48\x69" => '&#30382;',
 "\x48\x6A" => '&#30865;',
 "\x48\x6B" => '&#31192;',
 "\x48\x6C" => '&#32203;',
 "\x48\x6D" => '&#32631;',
 "\x48\x6E" => '&#32933;',
 "\x48\x6F" => '&#34987;',
 "\x48\x70" => '&#35513;',
 "\x48\x71" => '&#36027;',
 "\x48\x72" => '&#36991;',
 "\x48\x73" => '&#38750;',
 "\x48\x74" => '&#39131;',
 "\x48\x75" => '&#27147;',
 "\x48\x76" => '&#31800;',
 "\x48\x77" => '&#20633;',
 "\x48\x78" => '&#23614;',
 "\x48\x79" => '&#24494;',
 "\x48\x7A" => '&#26503;',
 "\x48\x7B" => '&#27608;',
 "\x48\x7C" => '&#29749;',
 "\x48\x7D" => '&#30473;',
 "\x48\x7E" => '&#32654;',
 "\x49\x21" => '&#40763;',
 "\x49\x22" => '&#26570;',
 "\x49\x23" => '&#31255;',
 "\x49\x24" => '&#21305;',
 "\x49\x25" => '&#30091;',
 "\x49\x26" => '&#39661;',
 "\x49\x27" => '&#24422;',
 "\x49\x28" => '&#33181;',
 "\x49\x29" => '&#33777;',
 "\x49\x2A" => '&#32920;',
 "\x49\x2B" => '&#24380;',
 "\x49\x2C" => '&#24517;',
 "\x49\x2D" => '&#30050;',
 "\x49\x2E" => '&#31558;',
 "\x49\x2F" => '&#36924;',
 "\x49\x30" => '&#26727;',
 "\x49\x31" => '&#23019;',
 "\x49\x32" => '&#23195;',
 "\x49\x33" => '&#32016;',
 "\x49\x34" => '&#30334;',
 "\x49\x35" => '&#35628;',
 "\x49\x36" => '&#20469;',
 "\x49\x37" => '&#24426;',
 "\x49\x38" => '&#27161;',
 "\x49\x39" => '&#27703;',
 "\x49\x3A" => '&#28418;',
 "\x49\x3B" => '&#29922;',
 "\x49\x3C" => '&#31080;',
 "\x49\x3D" => '&#34920;',
 "\x49\x3E" => '&#35413;',
 "\x49\x3F" => '&#35961;',
 "\x49\x40" => '&#24287;',
 "\x49\x41" => '&#25551;',
 "\x49\x42" => '&#30149;',
 "\x49\x43" => '&#31186;',
 "\x49\x44" => '&#33495;',
 "\x49\x45" => '&#37672;',
 "\x49\x46" => '&#37618;',
 "\x49\x47" => '&#33948;',
 "\x49\x48" => '&#34541;',
 "\x49\x49" => '&#39981;',
 "\x49\x4A" => '&#21697;',
 "\x49\x4B" => '&#24428;',
 "\x49\x4C" => '&#25996;',
 "\x49\x4D" => '&#27996;',
 "\x49\x4E" => '&#28693;',
 "\x49\x4F" => '&#36007;',
 "\x49\x50" => '&#36051;',
 "\x49\x51" => '&#38971;',
 "\x49\x52" => '&#25935;',
 "\x49\x53" => '&#29942;',
 "\x49\x54" => '&#19981;',
 "\x49\x55" => '&#20184;',
 "\x49\x56" => '&#22496;',
 "\x49\x57" => '&#22827;',
 "\x49\x58" => '&#23142;',
 "\x49\x59" => '&#23500;',
 "\x49\x5A" => '&#20904;',
 "\x49\x5B" => '&#24067;',
 "\x49\x5C" => '&#24220;',
 "\x49\x5D" => '&#24598;',
 "\x49\x5E" => '&#25206;',
 "\x49\x5F" => '&#25975;',
 "\x49\x60" => '&#26023;',
 "\x49\x61" => '&#26222;',
 "\x49\x62" => '&#28014;',
 "\x49\x63" => '&#29238;',
 "\x49\x64" => '&#31526;',
 "\x49\x65" => '&#33104;',
 "\x49\x66" => '&#33178;',
 "\x49\x67" => '&#33433;',
 "\x49\x68" => '&#35676;',
 "\x49\x69" => '&#36000;',
 "\x49\x6A" => '&#36070;',
 "\x49\x6B" => '&#36212;',
 "\x49\x6C" => '&#38428;',
 "\x49\x6D" => '&#38468;',
 "\x49\x6E" => '&#20398;',
 "\x49\x6F" => '&#25771;',
 "\x49\x70" => '&#27494;',
 "\x49\x71" => '&#33310;',
 "\x49\x72" => '&#33889;',
 "\x49\x73" => '&#34154;',
 "\x49\x74" => '&#37096;',
 "\x49\x75" => '&#23553;',
 "\x49\x76" => '&#26963;',
 "\x49\x77" => '&#39080;',
 "\x49\x78" => '&#33914;',
 "\x49\x79" => '&#34135;',
 "\x49\x7A" => '&#20239;',
 "\x49\x7B" => '&#21103;',
 "\x49\x7C" => '&#24489;',
 "\x49\x7D" => '&#24133;',
 "\x49\x7E" => '&#26381;',
 "\x4A\x21" => '&#31119;',
 "\x4A\x22" => '&#33145;',
 "\x4A\x23" => '&#35079;',
 "\x4A\x24" => '&#35206;',
 "\x4A\x25" => '&#28149;',
 "\x4A\x26" => '&#24343;',
 "\x4A\x27" => '&#25173;',
 "\x4A\x28" => '&#27832;',
 "\x4A\x29" => '&#20175;',
 "\x4A\x2A" => '&#29289;',
 "\x4A\x2B" => '&#39826;',
 "\x4A\x2C" => '&#20998;',
 "\x4A\x2D" => '&#21563;',
 "\x4A\x2E" => '&#22132;',
 "\x4A\x2F" => '&#22707;',
 "\x4A\x30" => '&#24996;',
 "\x4A\x31" => '&#25198;',
 "\x4A\x32" => '&#28954;',
 "\x4A\x33" => '&#22894;',
 "\x4A\x34" => '&#31881;',
 "\x4A\x35" => '&#31966;',
 "\x4A\x36" => '&#32027;',
 "\x4A\x37" => '&#38640;',
 "\x4A\x38" => '&#25991;',
 "\x4A\x39" => '&#32862;',
 "\x4A\x3A" => '&#19993;',
 "\x4A\x3B" => '&#20341;',
 "\x4A\x3C" => '&#20853;',
 "\x4A\x3D" => '&#22592;',
 "\x4A\x3E" => '&#24163;',
 "\x4A\x3F" => '&#24179;',
 "\x4A\x40" => '&#24330;',
 "\x4A\x41" => '&#26564;',
 "\x4A\x42" => '&#20006;',
 "\x4A\x43" => '&#34109;',
 "\x4A\x44" => '&#38281;',
 "\x4A\x45" => '&#38491;',
 "\x4A\x46" => '&#31859;',
 "\x4A\x47" => '&#38913;',
 "\x4A\x48" => '&#20731;',
 "\x4A\x49" => '&#22721;',
 "\x4A\x4A" => '&#30294;',
 "\x4A\x4B" => '&#30887;',
 "\x4A\x4C" => '&#21029;',
 "\x4A\x4D" => '&#30629;',
 "\x4A\x4E" => '&#34065;',
 "\x4A\x4F" => '&#31622;',
 "\x4A\x50" => '&#20559;',
 "\x4A\x51" => '&#22793;',
 "\x4A\x52" => '&#29255;',
 "\x4A\x53" => '&#31687;',
 "\x4A\x54" => '&#32232;',
 "\x4A\x55" => '&#36794;',
 "\x4A\x56" => '&#36820;',
 "\x4A\x57" => '&#36941;',
 "\x4A\x58" => '&#20415;',
 "\x4A\x59" => '&#21193;',
 "\x4A\x5A" => '&#23081;',
 "\x4A\x5B" => '&#24321;',
 "\x4A\x5C" => '&#38829;',
 "\x4A\x5D" => '&#20445;',
 "\x4A\x5E" => '&#33303;',
 "\x4A\x5F" => '&#37610;',
 "\x4A\x60" => '&#22275;',
 "\x4A\x61" => '&#25429;',
 "\x4A\x62" => '&#27497;',
 "\x4A\x63" => '&#29995;',
 "\x4A\x64" => '&#35036;',
 "\x4A\x65" => '&#36628;',
 "\x4A\x66" => '&#31298;',
 "\x4A\x67" => '&#21215;',
 "\x4A\x68" => '&#22675;',
 "\x4A\x69" => '&#24917;',
 "\x4A\x6A" => '&#25098;',
 "\x4A\x6B" => '&#26286;',
 "\x4A\x6C" => '&#27597;',
 "\x4A\x6D" => '&#31807;',
 "\x4A\x6E" => '&#33769;',
 "\x4A\x6F" => '&#20515;',
 "\x4A\x70" => '&#20472;',
 "\x4A\x71" => '&#21253;',
 "\x4A\x72" => '&#21574;',
 "\x4A\x73" => '&#22577;',
 "\x4A\x74" => '&#22857;',
 "\x4A\x75" => '&#23453;',
 "\x4A\x76" => '&#23792;',
 "\x4A\x77" => '&#23791;',
 "\x4A\x78" => '&#23849;',
 "\x4A\x79" => '&#24214;',
 "\x4A\x7A" => '&#25265;',
 "\x4A\x7B" => '&#25447;',
 "\x4A\x7C" => '&#25918;',
 "\x4A\x7D" => '&#26041;',
 "\x4A\x7E" => '&#26379;',
 "\x4B\x21" => '&#27861;',
 "\x4B\x22" => '&#27873;',
 "\x4B\x23" => '&#28921;',
 "\x4B\x24" => '&#30770;',
 "\x4B\x25" => '&#32299;',
 "\x4B\x26" => '&#32990;',
 "\x4B\x27" => '&#33459;',
 "\x4B\x28" => '&#33804;',
 "\x4B\x29" => '&#34028;',
 "\x4B\x2A" => '&#34562;',
 "\x4B\x2B" => '&#35090;',
 "\x4B\x2C" => '&#35370;',
 "\x4B\x2D" => '&#35914;',
 "\x4B\x2E" => '&#37030;',
 "\x4B\x2F" => '&#37586;',
 "\x4B\x30" => '&#39165;',
 "\x4B\x31" => '&#40179;',
 "\x4B\x32" => '&#40300;',
 "\x4B\x33" => '&#20047;',
 "\x4B\x34" => '&#20129;',
 "\x4B\x35" => '&#20621;',
 "\x4B\x36" => '&#21078;',
 "\x4B\x37" => '&#22346;',
 "\x4B\x38" => '&#22952;',
 "\x4B\x39" => '&#24125;',
 "\x4B\x3A" => '&#24536;',
 "\x4B\x3B" => '&#24537;',
 "\x4B\x3C" => '&#25151;',
 "\x4B\x3D" => '&#26292;',
 "\x4B\x3E" => '&#26395;',
 "\x4B\x3F" => '&#26576;',
 "\x4B\x40" => '&#26834;',
 "\x4B\x41" => '&#20882;',
 "\x4B\x42" => '&#32033;',
 "\x4B\x43" => '&#32938;',
 "\x4B\x44" => '&#33192;',
 "\x4B\x45" => '&#35584;',
 "\x4B\x46" => '&#35980;',
 "\x4B\x47" => '&#36031;',
 "\x4B\x48" => '&#37502;',
 "\x4B\x49" => '&#38450;',
 "\x4B\x4A" => '&#21536;',
 "\x4B\x4B" => '&#38956;',
 "\x4B\x4C" => '&#21271;',
 "\x4B\x4D" => '&#20693;',
 "\x4B\x4E" => '&#21340;',
 "\x4B\x4F" => '&#22696;',
 "\x4B\x50" => '&#25778;',
 "\x4B\x51" => '&#26420;',
 "\x4B\x52" => '&#29287;',
 "\x4B\x53" => '&#30566;',
 "\x4B\x54" => '&#31302;',
 "\x4B\x55" => '&#37350;',
 "\x4B\x56" => '&#21187;',
 "\x4B\x57" => '&#27809;',
 "\x4B\x58" => '&#27526;',
 "\x4B\x59" => '&#22528;',
 "\x4B\x5A" => '&#24140;',
 "\x4B\x5B" => '&#22868;',
 "\x4B\x5C" => '&#26412;',
 "\x4B\x5D" => '&#32763;',
 "\x4B\x5E" => '&#20961;',
 "\x4B\x5F" => '&#30406;',
 "\x4B\x60" => '&#25705;',
 "\x4B\x61" => '&#30952;',
 "\x4B\x62" => '&#39764;',
 "\x4B\x63" => '&#40635;',
 "\x4B\x64" => '&#22475;',
 "\x4B\x65" => '&#22969;',
 "\x4B\x66" => '&#26151;',
 "\x4B\x67" => '&#26522;',
 "\x4B\x68" => '&#27598;',
 "\x4B\x69" => '&#21737;',
 "\x4B\x6A" => '&#27097;',
 "\x4B\x6B" => '&#24149;',
 "\x4B\x6C" => '&#33180;',
 "\x4B\x6D" => '&#26517;',
 "\x4B\x6E" => '&#39850;',
 "\x4B\x6F" => '&#26622;',
 "\x4B\x70" => '&#40018;',
 "\x4B\x71" => '&#26717;',
 "\x4B\x72" => '&#20134;',
 "\x4B\x73" => '&#20451;',
 "\x4B\x74" => '&#21448;',
 "\x4B\x75" => '&#25273;',
 "\x4B\x76" => '&#26411;',
 "\x4B\x77" => '&#27819;',
 "\x4B\x78" => '&#36804;',
 "\x4B\x79" => '&#20397;',
 "\x4B\x7A" => '&#32365;',
 "\x4B\x7B" => '&#40639;',
 "\x4B\x7C" => '&#19975;',
 "\x4B\x7D" => '&#24930;',
 "\x4B\x7E" => '&#28288;',
 "\x4C\x21" => '&#28459;',
 "\x4C\x22" => '&#34067;',
 "\x4C\x23" => '&#21619;',
 "\x4C\x24" => '&#26410;',
 "\x4C\x25" => '&#39749;',
 "\x4C\x26" => '&#24051;',
 "\x4C\x27" => '&#31637;',
 "\x4C\x28" => '&#23724;',
 "\x4C\x29" => '&#23494;',
 "\x4C\x2A" => '&#34588;',
 "\x4C\x2B" => '&#28234;',
 "\x4C\x2C" => '&#34001;',
 "\x4C\x2D" => '&#31252;',
 "\x4C\x2E" => '&#33032;',
 "\x4C\x2F" => '&#22937;',
 "\x4C\x30" => '&#31885;',
 "\x4C\x31" => '&#27665;',
 "\x4C\x32" => '&#30496;',
 "\x4C\x33" => '&#21209;',
 "\x4C\x34" => '&#22818;',
 "\x4C\x35" => '&#28961;',
 "\x4C\x36" => '&#29279;',
 "\x4C\x37" => '&#30683;',
 "\x4C\x38" => '&#38695;',
 "\x4C\x39" => '&#40289;',
 "\x4C\x3A" => '&#26891;',
 "\x4C\x3B" => '&#23167;',
 "\x4C\x3C" => '&#23064;',
 "\x4C\x3D" => '&#20901;',
 "\x4C\x3E" => '&#21517;',
 "\x4C\x3F" => '&#21629;',
 "\x4C\x40" => '&#26126;',
 "\x4C\x41" => '&#30431;',
 "\x4C\x42" => '&#36855;',
 "\x4C\x43" => '&#37528;',
 "\x4C\x44" => '&#40180;',
 "\x4C\x45" => '&#23018;',
 "\x4C\x46" => '&#29277;',
 "\x4C\x47" => '&#28357;',
 "\x4C\x48" => '&#20813;',
 "\x4C\x49" => '&#26825;',
 "\x4C\x4A" => '&#32191;',
 "\x4C\x4B" => '&#32236;',
 "\x4C\x4C" => '&#38754;',
 "\x4C\x4D" => '&#40634;',
 "\x4C\x4E" => '&#25720;',
 "\x4C\x4F" => '&#27169;',
 "\x4C\x50" => '&#33538;',
 "\x4C\x51" => '&#22916;',
 "\x4C\x52" => '&#23391;',
 "\x4C\x53" => '&#27611;',
 "\x4C\x54" => '&#29467;',
 "\x4C\x55" => '&#30450;',
 "\x4C\x56" => '&#32178;',
 "\x4C\x57" => '&#32791;',
 "\x4C\x58" => '&#33945;',
 "\x4C\x59" => '&#20786;',
 "\x4C\x5A" => '&#26408;',
 "\x4C\x5B" => '&#40665;',
 "\x4C\x5C" => '&#30446;',
 "\x4C\x5D" => '&#26466;',
 "\x4C\x5E" => '&#21247;',
 "\x4C\x5F" => '&#39173;',
 "\x4C\x60" => '&#23588;',
 "\x4C\x61" => '&#25147;',
 "\x4C\x62" => '&#31870;',
 "\x4C\x63" => '&#36016;',
 "\x4C\x64" => '&#21839;',
 "\x4C\x65" => '&#24758;',
 "\x4C\x66" => '&#32011;',
 "\x4C\x67" => '&#38272;',
 "\x4C\x68" => '&#21249;',
 "\x4C\x69" => '&#20063;',
 "\x4C\x6A" => '&#20918;',
 "\x4C\x6B" => '&#22812;',
 "\x4C\x6C" => '&#29242;',
 "\x4C\x6D" => '&#32822;',
 "\x4C\x6E" => '&#37326;',
 "\x4C\x6F" => '&#24357;',
 "\x4C\x70" => '&#30690;',
 "\x4C\x71" => '&#21380;',
 "\x4C\x72" => '&#24441;',
 "\x4C\x73" => '&#32004;',
 "\x4C\x74" => '&#34220;',
 "\x4C\x75" => '&#35379;',
 "\x4C\x76" => '&#36493;',
 "\x4C\x77" => '&#38742;',
 "\x4C\x78" => '&#26611;',
 "\x4C\x79" => '&#34222;',
 "\x4C\x7A" => '&#37971;',
 "\x4C\x7B" => '&#24841;',
 "\x4C\x7C" => '&#24840;',
 "\x4C\x7D" => '&#27833;',
 "\x4C\x7E" => '&#30290;',
 "\x4D\x21" => '&#35565;',
 "\x4D\x22" => '&#36664;',
 "\x4D\x23" => '&#21807;',
 "\x4D\x24" => '&#20305;',
 "\x4D\x25" => '&#20778;',
 "\x4D\x26" => '&#21191;',
 "\x4D\x27" => '&#21451;',
 "\x4D\x28" => '&#23461;',
 "\x4D\x29" => '&#24189;',
 "\x4D\x2A" => '&#24736;',
 "\x4D\x2B" => '&#24962;',
 "\x4D\x2C" => '&#25558;',
 "\x4D\x2D" => '&#26377;',
 "\x4D\x2E" => '&#26586;',
 "\x4D\x2F" => '&#28263;',
 "\x4D\x30" => '&#28044;',
 "\x4D\x31" => '&#29494;',
 "\x4D\x32" => '&#29495;',
 "\x4D\x33" => '&#30001;',
 "\x4D\x34" => '&#31056;',
 "\x4D\x35" => '&#35029;',
 "\x4D\x36" => '&#35480;',
 "\x4D\x37" => '&#36938;',
 "\x4D\x38" => '&#37009;',
 "\x4D\x39" => '&#37109;',
 "\x4D\x3A" => '&#38596;',
 "\x4D\x3B" => '&#34701;',
 "\x4D\x3C" => '&#22805;',
 "\x4D\x3D" => '&#20104;',
 "\x4D\x3E" => '&#20313;',
 "\x4D\x3F" => '&#19982;',
 "\x4D\x40" => '&#35465;',
 "\x4D\x41" => '&#36671;',
 "\x4D\x42" => '&#38928;',
 "\x4D\x43" => '&#20653;',
 "\x4D\x44" => '&#24188;',
 "\x4D\x45" => '&#22934;',
 "\x4D\x46" => '&#23481;',
 "\x4D\x47" => '&#24248;',
 "\x4D\x48" => '&#25562;',
 "\x4D\x49" => '&#25594;',
 "\x4D\x4A" => '&#25793;',
 "\x4D\x4B" => '&#26332;',
 "\x4D\x4C" => '&#26954;',
 "\x4D\x4D" => '&#27096;',
 "\x4D\x4E" => '&#27915;',
 "\x4D\x4F" => '&#28342;',
 "\x4D\x50" => '&#29076;',
 "\x4D\x51" => '&#29992;',
 "\x4D\x52" => '&#31407;',
 "\x4D\x53" => '&#32650;',
 "\x4D\x54" => '&#32768;',
 "\x4D\x55" => '&#33865;',
 "\x4D\x56" => '&#33993;',
 "\x4D\x57" => '&#35201;',
 "\x4D\x58" => '&#35617;',
 "\x4D\x59" => '&#36362;',
 "\x4D\x5A" => '&#36965;',
 "\x4D\x5B" => '&#38525;',
 "\x4D\x5C" => '&#39178;',
 "\x4D\x5D" => '&#24958;',
 "\x4D\x5E" => '&#25233;',
 "\x4D\x5F" => '&#27442;',
 "\x4D\x60" => '&#27779;',
 "\x4D\x61" => '&#28020;',
 "\x4D\x62" => '&#32716;',
 "\x4D\x63" => '&#32764;',
 "\x4D\x64" => '&#28096;',
 "\x4D\x65" => '&#32645;',
 "\x4D\x66" => '&#34746;',
 "\x4D\x67" => '&#35064;',
 "\x4D\x68" => '&#26469;',
 "\x4D\x69" => '&#33713;',
 "\x4D\x6A" => '&#38972;',
 "\x4D\x6B" => '&#38647;',
 "\x4D\x6C" => '&#27931;',
 "\x4D\x6D" => '&#32097;',
 "\x4D\x6E" => '&#33853;',
 "\x4D\x6F" => '&#37226;',
 "\x4D\x70" => '&#20081;',
 "\x4D\x71" => '&#21365;',
 "\x4D\x72" => '&#23888;',
 "\x4D\x73" => '&#27396;',
 "\x4D\x74" => '&#28651;',
 "\x4D\x75" => '&#34253;',
 "\x4D\x76" => '&#34349;',
 "\x4D\x77" => '&#35239;',
 "\x4D\x78" => '&#21033;',
 "\x4D\x79" => '&#21519;',
 "\x4D\x7A" => '&#23653;',
 "\x4D\x7B" => '&#26446;',
 "\x4D\x7C" => '&#26792;',
 "\x4D\x7D" => '&#29702;',
 "\x4D\x7E" => '&#29827;',
 "\x4E\x21" => '&#30178;',
 "\x4E\x22" => '&#35023;',
 "\x4E\x23" => '&#35041;',
 "\x4E\x24" => '&#37324;',
 "\x4E\x25" => '&#38626;',
 "\x4E\x26" => '&#38520;',
 "\x4E\x27" => '&#24459;',
 "\x4E\x28" => '&#29575;',
 "\x4E\x29" => '&#31435;',
 "\x4E\x2A" => '&#33870;',
 "\x4E\x2B" => '&#25504;',
 "\x4E\x2C" => '&#30053;',
 "\x4E\x2D" => '&#21129;',
 "\x4E\x2E" => '&#27969;',
 "\x4E\x2F" => '&#28316;',
 "\x4E\x30" => '&#29705;',
 "\x4E\x31" => '&#30041;',
 "\x4E\x32" => '&#30827;',
 "\x4E\x33" => '&#31890;',
 "\x4E\x34" => '&#38534;',
 "\x4E\x35" => '&#31452;',
 "\x4E\x36" => '&#40845;',
 "\x4E\x37" => '&#20406;',
 "\x4E\x38" => '&#24942;',
 "\x4E\x39" => '&#26053;',
 "\x4E\x3A" => '&#34396;',
 "\x4E\x3B" => '&#20102;',
 "\x4E\x3C" => '&#20142;',
 "\x4E\x3D" => '&#20698;',
 "\x4E\x3E" => '&#20001;',
 "\x4E\x3F" => '&#20940;',
 "\x4E\x40" => '&#23534;',
 "\x4E\x41" => '&#26009;',
 "\x4E\x42" => '&#26753;',
 "\x4E\x43" => '&#28092;',
 "\x4E\x44" => '&#29471;',
 "\x4E\x45" => '&#30274;',
 "\x4E\x46" => '&#30637;',
 "\x4E\x47" => '&#31260;',
 "\x4E\x48" => '&#31975;',
 "\x4E\x49" => '&#33391;',
 "\x4E\x4A" => '&#35538;',
 "\x4E\x4B" => '&#36988;',
 "\x4E\x4C" => '&#37327;',
 "\x4E\x4D" => '&#38517;',
 "\x4E\x4E" => '&#38936;',
 "\x4E\x4F" => '&#21147;',
 "\x4E\x50" => '&#32209;',
 "\x4E\x51" => '&#20523;',
 "\x4E\x52" => '&#21400;',
 "\x4E\x53" => '&#26519;',
 "\x4E\x54" => '&#28107;',
 "\x4E\x55" => '&#29136;',
 "\x4E\x56" => '&#29747;',
 "\x4E\x57" => '&#33256;',
 "\x4E\x58" => '&#36650;',
 "\x4E\x59" => '&#38563;',
 "\x4E\x5A" => '&#40023;',
 "\x4E\x5B" => '&#40607;',
 "\x4E\x5C" => '&#29792;',
 "\x4E\x5D" => '&#22593;',
 "\x4E\x5E" => '&#28057;',
 "\x4E\x5F" => '&#32047;',
 "\x4E\x60" => '&#39006;',
 "\x4E\x61" => '&#20196;',
 "\x4E\x62" => '&#20278;',
 "\x4E\x63" => '&#20363;',
 "\x4E\x64" => '&#20919;',
 "\x4E\x65" => '&#21169;',
 "\x4E\x66" => '&#23994;',
 "\x4E\x67" => '&#24604;',
 "\x4E\x68" => '&#29618;',
 "\x4E\x69" => '&#31036;',
 "\x4E\x6A" => '&#33491;',
 "\x4E\x6B" => '&#37428;',
 "\x4E\x6C" => '&#38583;',
 "\x4E\x6D" => '&#38646;',
 "\x4E\x6E" => '&#38666;',
 "\x4E\x6F" => '&#40599;',
 "\x4E\x70" => '&#40802;',
 "\x4E\x71" => '&#26278;',
 "\x4E\x72" => '&#27508;',
 "\x4E\x73" => '&#21015;',
 "\x4E\x74" => '&#21155;',
 "\x4E\x75" => '&#28872;',
 "\x4E\x76" => '&#35010;',
 "\x4E\x77" => '&#24265;',
 "\x4E\x78" => '&#24651;',
 "\x4E\x79" => '&#24976;',
 "\x4E\x7A" => '&#28451;',
 "\x4E\x7B" => '&#29001;',
 "\x4E\x7C" => '&#31806;',
 "\x4E\x7D" => '&#32244;',
 "\x4E\x7E" => '&#32879;',
 "\x4F\x21" => '&#34030;',
 "\x4F\x22" => '&#36899;',
 "\x4F\x23" => '&#37676;',
 "\x4F\x24" => '&#21570;',
 "\x4F\x25" => '&#39791;',
 "\x4F\x26" => '&#27347;',
 "\x4F\x27" => '&#28809;',
 "\x4F\x28" => '&#36034;',
 "\x4F\x29" => '&#36335;',
 "\x4F\x2A" => '&#38706;',
 "\x4F\x2B" => '&#21172;',
 "\x4F\x2C" => '&#23105;',
 "\x4F\x2D" => '&#24266;',
 "\x4F\x2E" => '&#24324;',
 "\x4F\x2F" => '&#26391;',
 "\x4F\x30" => '&#27004;',
 "\x4F\x31" => '&#27028;',
 "\x4F\x32" => '&#28010;',
 "\x4F\x33" => '&#28431;',
 "\x4F\x34" => '&#29282;',
 "\x4F\x35" => '&#29436;',
 "\x4F\x36" => '&#31725;',
 "\x4F\x37" => '&#32769;',
 "\x4F\x38" => '&#32894;',
 "\x4F\x39" => '&#34635;',
 "\x4F\x3A" => '&#37070;',
 "\x4F\x3B" => '&#20845;',
 "\x4F\x3C" => '&#40595;',
 "\x4F\x3D" => '&#31108;',
 "\x4F\x3E" => '&#32907;',
 "\x4F\x3F" => '&#37682;',
 "\x4F\x40" => '&#35542;',
 "\x4F\x41" => '&#20525;',
 "\x4F\x42" => '&#21644;',
 "\x4F\x43" => '&#35441;',
 "\x4F\x44" => '&#27498;',
 "\x4F\x45" => '&#36036;',
 "\x4F\x46" => '&#33031;',
 "\x4F\x47" => '&#24785;',
 "\x4F\x48" => '&#26528;',
 "\x4F\x49" => '&#40434;',
 "\x4F\x4A" => '&#20121;',
 "\x4F\x4B" => '&#20120;',
 "\x4F\x4C" => '&#39952;',
 "\x4F\x4D" => '&#35435;',
 "\x4F\x4E" => '&#34241;',
 "\x4F\x4F" => '&#34152;',
 "\x4F\x50" => '&#26880;',
 "\x4F\x51" => '&#28286;',
 "\x4F\x52" => '&#30871;',
 "\x4F\x53" => '&#33109;',
 "\x50\x21" => '&#24332;',
 "\x50\x22" => '&#19984;',
 "\x50\x23" => '&#19989;',
 "\x50\x24" => '&#20010;',
 "\x50\x25" => '&#20017;',
 "\x50\x26" => '&#20022;',
 "\x50\x27" => '&#20028;',
 "\x50\x28" => '&#20031;',
 "\x50\x29" => '&#20034;',
 "\x50\x2A" => '&#20054;',
 "\x50\x2B" => '&#20056;',
 "\x50\x2C" => '&#20098;',
 "\x50\x2D" => '&#20101;',
 "\x50\x2E" => '&#35947;',
 "\x50\x2F" => '&#20106;',
 "\x50\x30" => '&#33298;',
 "\x50\x31" => '&#24333;',
 "\x50\x32" => '&#20110;',
 "\x50\x33" => '&#20126;',
 "\x50\x34" => '&#20127;',
 "\x50\x35" => '&#20128;',
 "\x50\x36" => '&#20130;',
 "\x50\x37" => '&#20144;',
 "\x50\x38" => '&#20147;',
 "\x50\x39" => '&#20150;',
 "\x50\x3A" => '&#20174;',
 "\x50\x3B" => '&#20173;',
 "\x50\x3C" => '&#20164;',
 "\x50\x3D" => '&#20166;',
 "\x50\x3E" => '&#20162;',
 "\x50\x3F" => '&#20183;',
 "\x50\x40" => '&#20190;',
 "\x50\x41" => '&#20205;',
 "\x50\x42" => '&#20191;',
 "\x50\x43" => '&#20215;',
 "\x50\x44" => '&#20233;',
 "\x50\x45" => '&#20314;',
 "\x50\x46" => '&#20272;',
 "\x50\x47" => '&#20315;',
 "\x50\x48" => '&#20317;',
 "\x50\x49" => '&#20311;',
 "\x50\x4A" => '&#20295;',
 "\x50\x4B" => '&#20342;',
 "\x50\x4C" => '&#20360;',
 "\x50\x4D" => '&#20367;',
 "\x50\x4E" => '&#20376;',
 "\x50\x4F" => '&#20347;',
 "\x50\x50" => '&#20329;',
 "\x50\x51" => '&#20336;',
 "\x50\x52" => '&#20369;',
 "\x50\x53" => '&#20335;',
 "\x50\x54" => '&#20358;',
 "\x50\x55" => '&#20374;',
 "\x50\x56" => '&#20760;',
 "\x50\x57" => '&#20436;',
 "\x50\x58" => '&#20447;',
 "\x50\x59" => '&#20430;',
 "\x50\x5A" => '&#20440;',
 "\x50\x5B" => '&#20443;',
 "\x50\x5C" => '&#20433;',
 "\x50\x5D" => '&#20442;',
 "\x50\x5E" => '&#20432;',
 "\x50\x5F" => '&#20452;',
 "\x50\x60" => '&#20453;',
 "\x50\x61" => '&#20506;',
 "\x50\x62" => '&#20520;',
 "\x50\x63" => '&#20500;',
 "\x50\x64" => '&#20522;',
 "\x50\x65" => '&#20517;',
 "\x50\x66" => '&#20485;',
 "\x50\x67" => '&#20252;',
 "\x50\x68" => '&#20470;',
 "\x50\x69" => '&#20513;',
 "\x50\x6A" => '&#20521;',
 "\x50\x6B" => '&#20524;',
 "\x50\x6C" => '&#20478;',
 "\x50\x6D" => '&#20463;',
 "\x50\x6E" => '&#20497;',
 "\x50\x6F" => '&#20486;',
 "\x50\x70" => '&#20547;',
 "\x50\x71" => '&#20551;',
 "\x50\x72" => '&#26371;',
 "\x50\x73" => '&#20565;',
 "\x50\x74" => '&#20560;',
 "\x50\x75" => '&#20552;',
 "\x50\x76" => '&#20570;',
 "\x50\x77" => '&#20566;',
 "\x50\x78" => '&#20588;',
 "\x50\x79" => '&#20600;',
 "\x50\x7A" => '&#20608;',
 "\x50\x7B" => '&#20634;',
 "\x50\x7C" => '&#20613;',
 "\x50\x7D" => '&#20660;',
 "\x50\x7E" => '&#20658;',
 "\x51\x21" => '&#20681;',
 "\x51\x22" => '&#20682;',
 "\x51\x23" => '&#20659;',
 "\x51\x24" => '&#20674;',
 "\x51\x25" => '&#20694;',
 "\x51\x26" => '&#20702;',
 "\x51\x27" => '&#20709;',
 "\x51\x28" => '&#20717;',
 "\x51\x29" => '&#20707;',
 "\x51\x2A" => '&#20718;',
 "\x51\x2B" => '&#20729;',
 "\x51\x2C" => '&#20725;',
 "\x51\x2D" => '&#20745;',
 "\x51\x2E" => '&#20737;',
 "\x51\x2F" => '&#20738;',
 "\x51\x30" => '&#20758;',
 "\x51\x31" => '&#20757;',
 "\x51\x32" => '&#20756;',
 "\x51\x33" => '&#20762;',
 "\x51\x34" => '&#20769;',
 "\x51\x35" => '&#20794;',
 "\x51\x36" => '&#20791;',
 "\x51\x37" => '&#20796;',
 "\x51\x38" => '&#20795;',
 "\x51\x39" => '&#20799;',
 "\x51\x3A" => '&#20800;',
 "\x51\x3B" => '&#20818;',
 "\x51\x3C" => '&#20812;',
 "\x51\x3D" => '&#20820;',
 "\x51\x3E" => '&#20834;',
 "\x51\x3F" => '&#31480;',
 "\x51\x40" => '&#20841;',
 "\x51\x41" => '&#20842;',
 "\x51\x42" => '&#20846;',
 "\x51\x43" => '&#20864;',
 "\x51\x44" => '&#20866;',
 "\x51\x45" => '&#22232;',
 "\x51\x46" => '&#20876;',
 "\x51\x47" => '&#20873;',
 "\x51\x48" => '&#20879;',
 "\x51\x49" => '&#20881;',
 "\x51\x4A" => '&#20883;',
 "\x51\x4B" => '&#20885;',
 "\x51\x4C" => '&#20886;',
 "\x51\x4D" => '&#20900;',
 "\x51\x4E" => '&#20902;',
 "\x51\x4F" => '&#20898;',
 "\x51\x50" => '&#20905;',
 "\x51\x51" => '&#20906;',
 "\x51\x52" => '&#20907;',
 "\x51\x53" => '&#20915;',
 "\x51\x54" => '&#20913;',
 "\x51\x55" => '&#20914;',
 "\x51\x56" => '&#20912;',
 "\x51\x57" => '&#20917;',
 "\x51\x58" => '&#20925;',
 "\x51\x59" => '&#20933;',
 "\x51\x5A" => '&#20937;',
 "\x51\x5B" => '&#20955;',
 "\x51\x5C" => '&#20960;',
 "\x51\x5D" => '&#34389;',
 "\x51\x5E" => '&#20969;',
 "\x51\x5F" => '&#20973;',
 "\x51\x60" => '&#20976;',
 "\x51\x61" => '&#20981;',
 "\x51\x62" => '&#20990;',
 "\x51\x63" => '&#20996;',
 "\x51\x64" => '&#21003;',
 "\x51\x65" => '&#21012;',
 "\x51\x66" => '&#21006;',
 "\x51\x67" => '&#21031;',
 "\x51\x68" => '&#21034;',
 "\x51\x69" => '&#21038;',
 "\x51\x6A" => '&#21043;',
 "\x51\x6B" => '&#21049;',
 "\x51\x6C" => '&#21071;',
 "\x51\x6D" => '&#21060;',
 "\x51\x6E" => '&#21067;',
 "\x51\x6F" => '&#21068;',
 "\x51\x70" => '&#21086;',
 "\x51\x71" => '&#21076;',
 "\x51\x72" => '&#21098;',
 "\x51\x73" => '&#21108;',
 "\x51\x74" => '&#21097;',
 "\x51\x75" => '&#21107;',
 "\x51\x76" => '&#21119;',
 "\x51\x77" => '&#21117;',
 "\x51\x78" => '&#21133;',
 "\x51\x79" => '&#21140;',
 "\x51\x7A" => '&#21138;',
 "\x51\x7B" => '&#21105;',
 "\x51\x7C" => '&#21128;',
 "\x51\x7D" => '&#21137;',
 "\x51\x7E" => '&#36776;',
 "\x52\x21" => '&#36775;',
 "\x52\x22" => '&#21164;',
 "\x52\x23" => '&#21165;',
 "\x52\x24" => '&#21180;',
 "\x52\x25" => '&#21173;',
 "\x52\x26" => '&#21185;',
 "\x52\x27" => '&#21197;',
 "\x52\x28" => '&#21207;',
 "\x52\x29" => '&#21214;',
 "\x52\x2A" => '&#21219;',
 "\x52\x2B" => '&#21222;',
 "\x52\x2C" => '&#39149;',
 "\x52\x2D" => '&#21216;',
 "\x52\x2E" => '&#21235;',
 "\x52\x2F" => '&#21237;',
 "\x52\x30" => '&#21240;',
 "\x52\x31" => '&#21241;',
 "\x52\x32" => '&#21254;',
 "\x52\x33" => '&#21256;',
 "\x52\x34" => '&#30008;',
 "\x52\x35" => '&#21261;',
 "\x52\x36" => '&#21264;',
 "\x52\x37" => '&#21263;',
 "\x52\x38" => '&#21269;',
 "\x52\x39" => '&#21274;',
 "\x52\x3A" => '&#21283;',
 "\x52\x3B" => '&#21295;',
 "\x52\x3C" => '&#21297;',
 "\x52\x3D" => '&#21299;',
 "\x52\x3E" => '&#21304;',
 "\x52\x3F" => '&#21312;',
 "\x52\x40" => '&#21318;',
 "\x52\x41" => '&#21317;',
 "\x52\x42" => '&#19991;',
 "\x52\x43" => '&#21321;',
 "\x52\x44" => '&#21325;',
 "\x52\x45" => '&#20950;',
 "\x52\x46" => '&#21342;',
 "\x52\x47" => '&#21353;',
 "\x52\x48" => '&#21358;',
 "\x52\x49" => '&#22808;',
 "\x52\x4A" => '&#21371;',
 "\x52\x4B" => '&#21367;',
 "\x52\x4C" => '&#21378;',
 "\x52\x4D" => '&#21398;',
 "\x52\x4E" => '&#21408;',
 "\x52\x4F" => '&#21414;',
 "\x52\x50" => '&#21413;',
 "\x52\x51" => '&#21422;',
 "\x52\x52" => '&#21424;',
 "\x52\x53" => '&#21430;',
 "\x52\x54" => '&#21443;',
 "\x52\x55" => '&#31762;',
 "\x52\x56" => '&#38617;',
 "\x52\x57" => '&#21471;',
 "\x52\x58" => '&#26364;',
 "\x52\x59" => '&#29166;',
 "\x52\x5A" => '&#21486;',
 "\x52\x5B" => '&#21480;',
 "\x52\x5C" => '&#21485;',
 "\x52\x5D" => '&#21498;',
 "\x52\x5E" => '&#21505;',
 "\x52\x5F" => '&#21565;',
 "\x52\x60" => '&#21568;',
 "\x52\x61" => '&#21548;',
 "\x52\x62" => '&#21549;',
 "\x52\x63" => '&#21564;',
 "\x52\x64" => '&#21550;',
 "\x52\x65" => '&#21558;',
 "\x52\x66" => '&#21545;',
 "\x52\x67" => '&#21533;',
 "\x52\x68" => '&#21582;',
 "\x52\x69" => '&#21647;',
 "\x52\x6A" => '&#21621;',
 "\x52\x6B" => '&#21646;',
 "\x52\x6C" => '&#21599;',
 "\x52\x6D" => '&#21617;',
 "\x52\x6E" => '&#21623;',
 "\x52\x6F" => '&#21616;',
 "\x52\x70" => '&#21650;',
 "\x52\x71" => '&#21627;',
 "\x52\x72" => '&#21632;',
 "\x52\x73" => '&#21622;',
 "\x52\x74" => '&#21636;',
 "\x52\x75" => '&#21648;',
 "\x52\x76" => '&#21638;',
 "\x52\x77" => '&#21703;',
 "\x52\x78" => '&#21666;',
 "\x52\x79" => '&#21688;',
 "\x52\x7A" => '&#21669;',
 "\x52\x7B" => '&#21676;',
 "\x52\x7C" => '&#21700;',
 "\x52\x7D" => '&#21704;',
 "\x52\x7E" => '&#21672;',
 "\x53\x21" => '&#21675;',
 "\x53\x22" => '&#21698;',
 "\x53\x23" => '&#21668;',
 "\x53\x24" => '&#21694;',
 "\x53\x25" => '&#21692;',
 "\x53\x26" => '&#21720;',
 "\x53\x27" => '&#21733;',
 "\x53\x28" => '&#21734;',
 "\x53\x29" => '&#21775;',
 "\x53\x2A" => '&#21780;',
 "\x53\x2B" => '&#21757;',
 "\x53\x2C" => '&#21742;',
 "\x53\x2D" => '&#21741;',
 "\x53\x2E" => '&#21754;',
 "\x53\x2F" => '&#21730;',
 "\x53\x30" => '&#21817;',
 "\x53\x31" => '&#21824;',
 "\x53\x32" => '&#21859;',
 "\x53\x33" => '&#21836;',
 "\x53\x34" => '&#21806;',
 "\x53\x35" => '&#21852;',
 "\x53\x36" => '&#21829;',
 "\x53\x37" => '&#21846;',
 "\x53\x38" => '&#21847;',
 "\x53\x39" => '&#21816;',
 "\x53\x3A" => '&#21811;',
 "\x53\x3B" => '&#21853;',
 "\x53\x3C" => '&#21913;',
 "\x53\x3D" => '&#21888;',
 "\x53\x3E" => '&#21679;',
 "\x53\x3F" => '&#21898;',
 "\x53\x40" => '&#21919;',
 "\x53\x41" => '&#21883;',
 "\x53\x42" => '&#21886;',
 "\x53\x43" => '&#21912;',
 "\x53\x44" => '&#21918;',
 "\x53\x45" => '&#21934;',
 "\x53\x46" => '&#21884;',
 "\x53\x47" => '&#21891;',
 "\x53\x48" => '&#21929;',
 "\x53\x49" => '&#21895;',
 "\x53\x4A" => '&#21928;',
 "\x53\x4B" => '&#21978;',
 "\x53\x4C" => '&#21957;',
 "\x53\x4D" => '&#21983;',
 "\x53\x4E" => '&#21956;',
 "\x53\x4F" => '&#21980;',
 "\x53\x50" => '&#21988;',
 "\x53\x51" => '&#21972;',
 "\x53\x52" => '&#22036;',
 "\x53\x53" => '&#22007;',
 "\x53\x54" => '&#22038;',
 "\x53\x55" => '&#22014;',
 "\x53\x56" => '&#22013;',
 "\x53\x57" => '&#22043;',
 "\x53\x58" => '&#22009;',
 "\x53\x59" => '&#22094;',
 "\x53\x5A" => '&#22096;',
 "\x53\x5B" => '&#29151;',
 "\x53\x5C" => '&#22068;',
 "\x53\x5D" => '&#22070;',
 "\x53\x5E" => '&#22066;',
 "\x53\x5F" => '&#22072;',
 "\x53\x60" => '&#22123;',
 "\x53\x61" => '&#22116;',
 "\x53\x62" => '&#22063;',
 "\x53\x63" => '&#22124;',
 "\x53\x64" => '&#22122;',
 "\x53\x65" => '&#22150;',
 "\x53\x66" => '&#22144;',
 "\x53\x67" => '&#22154;',
 "\x53\x68" => '&#22176;',
 "\x53\x69" => '&#22164;',
 "\x53\x6A" => '&#22159;',
 "\x53\x6B" => '&#22181;',
 "\x53\x6C" => '&#22190;',
 "\x53\x6D" => '&#22198;',
 "\x53\x6E" => '&#22196;',
 "\x53\x6F" => '&#22210;',
 "\x53\x70" => '&#22204;',
 "\x53\x71" => '&#22209;',
 "\x53\x72" => '&#22211;',
 "\x53\x73" => '&#22208;',
 "\x53\x74" => '&#22216;',
 "\x53\x75" => '&#22222;',
 "\x53\x76" => '&#22225;',
 "\x53\x77" => '&#22227;',
 "\x53\x78" => '&#22231;',
 "\x53\x79" => '&#22254;',
 "\x53\x7A" => '&#22265;',
 "\x53\x7B" => '&#22272;',
 "\x53\x7C" => '&#22271;',
 "\x53\x7D" => '&#22276;',
 "\x53\x7E" => '&#22281;',
 "\x54\x21" => '&#22280;',
 "\x54\x22" => '&#22283;',
 "\x54\x23" => '&#22285;',
 "\x54\x24" => '&#22291;',
 "\x54\x25" => '&#22296;',
 "\x54\x26" => '&#22294;',
 "\x54\x27" => '&#21959;',
 "\x54\x28" => '&#22300;',
 "\x54\x29" => '&#22310;',
 "\x54\x2A" => '&#22327;',
 "\x54\x2B" => '&#22328;',
 "\x54\x2C" => '&#22350;',
 "\x54\x2D" => '&#22331;',
 "\x54\x2E" => '&#22336;',
 "\x54\x2F" => '&#22351;',
 "\x54\x30" => '&#22377;',
 "\x54\x31" => '&#22464;',
 "\x54\x32" => '&#22408;',
 "\x54\x33" => '&#22369;',
 "\x54\x34" => '&#22399;',
 "\x54\x35" => '&#22409;',
 "\x54\x36" => '&#22419;',
 "\x54\x37" => '&#22432;',
 "\x54\x38" => '&#22451;',
 "\x54\x39" => '&#22436;',
 "\x54\x3A" => '&#22442;',
 "\x54\x3B" => '&#22448;',
 "\x54\x3C" => '&#22467;',
 "\x54\x3D" => '&#22470;',
 "\x54\x3E" => '&#22484;',
 "\x54\x3F" => '&#22482;',
 "\x54\x40" => '&#22483;',
 "\x54\x41" => '&#22538;',
 "\x54\x42" => '&#22486;',
 "\x54\x43" => '&#22499;',
 "\x54\x44" => '&#22539;',
 "\x54\x45" => '&#22553;',
 "\x54\x46" => '&#22557;',
 "\x54\x47" => '&#22642;',
 "\x54\x48" => '&#22561;',
 "\x54\x49" => '&#22626;',
 "\x54\x4A" => '&#22603;',
 "\x54\x4B" => '&#22640;',
 "\x54\x4C" => '&#27584;',
 "\x54\x4D" => '&#22610;',
 "\x54\x4E" => '&#22589;',
 "\x54\x4F" => '&#22649;',
 "\x54\x50" => '&#22661;',
 "\x54\x51" => '&#22713;',
 "\x54\x52" => '&#22687;',
 "\x54\x53" => '&#22699;',
 "\x54\x54" => '&#22714;',
 "\x54\x55" => '&#22750;',
 "\x54\x56" => '&#22715;',
 "\x54\x57" => '&#22712;',
 "\x54\x58" => '&#22702;',
 "\x54\x59" => '&#22725;',
 "\x54\x5A" => '&#22739;',
 "\x54\x5B" => '&#22737;',
 "\x54\x5C" => '&#22743;',
 "\x54\x5D" => '&#22745;',
 "\x54\x5E" => '&#22744;',
 "\x54\x5F" => '&#22757;',
 "\x54\x60" => '&#22748;',
 "\x54\x61" => '&#22756;',
 "\x54\x62" => '&#22751;',
 "\x54\x63" => '&#22767;',
 "\x54\x64" => '&#22778;',
 "\x54\x65" => '&#22777;',
 "\x54\x66" => '&#22779;',
 "\x54\x67" => '&#22780;',
 "\x54\x68" => '&#22781;',
 "\x54\x69" => '&#22786;',
 "\x54\x6A" => '&#22794;',
 "\x54\x6B" => '&#22800;',
 "\x54\x6C" => '&#22811;',
 "\x54\x6D" => '&#26790;',
 "\x54\x6E" => '&#22821;',
 "\x54\x6F" => '&#22828;',
 "\x54\x70" => '&#22829;',
 "\x54\x71" => '&#22834;',
 "\x54\x72" => '&#22840;',
 "\x54\x73" => '&#22846;',
 "\x54\x74" => '&#31442;',
 "\x54\x75" => '&#22869;',
 "\x54\x76" => '&#22864;',
 "\x54\x77" => '&#22862;',
 "\x54\x78" => '&#22874;',
 "\x54\x79" => '&#22872;',
 "\x54\x7A" => '&#22882;',
 "\x54\x7B" => '&#22880;',
 "\x54\x7C" => '&#22887;',
 "\x54\x7D" => '&#22892;',
 "\x54\x7E" => '&#22889;',
 "\x55\x21" => '&#22904;',
 "\x55\x22" => '&#22913;',
 "\x55\x23" => '&#22941;',
 "\x55\x24" => '&#20318;',
 "\x55\x25" => '&#20395;',
 "\x55\x26" => '&#22947;',
 "\x55\x27" => '&#22962;',
 "\x55\x28" => '&#22982;',
 "\x55\x29" => '&#23016;',
 "\x55\x2A" => '&#23004;',
 "\x55\x2B" => '&#22925;',
 "\x55\x2C" => '&#23001;',
 "\x55\x2D" => '&#23002;',
 "\x55\x2E" => '&#23077;',
 "\x55\x2F" => '&#23071;',
 "\x55\x30" => '&#23057;',
 "\x55\x31" => '&#23068;',
 "\x55\x32" => '&#23049;',
 "\x55\x33" => '&#23066;',
 "\x55\x34" => '&#23104;',
 "\x55\x35" => '&#23148;',
 "\x55\x36" => '&#23113;',
 "\x55\x37" => '&#23093;',
 "\x55\x38" => '&#23094;',
 "\x55\x39" => '&#23138;',
 "\x55\x3A" => '&#23146;',
 "\x55\x3B" => '&#23194;',
 "\x55\x3C" => '&#23228;',
 "\x55\x3D" => '&#23230;',
 "\x55\x3E" => '&#23243;',
 "\x55\x3F" => '&#23234;',
 "\x55\x40" => '&#23229;',
 "\x55\x41" => '&#23267;',
 "\x55\x42" => '&#23255;',
 "\x55\x43" => '&#23270;',
 "\x55\x44" => '&#23273;',
 "\x55\x45" => '&#23254;',
 "\x55\x46" => '&#23290;',
 "\x55\x47" => '&#23291;',
 "\x55\x48" => '&#23308;',
 "\x55\x49" => '&#23307;',
 "\x55\x4A" => '&#23318;',
 "\x55\x4B" => '&#23346;',
 "\x55\x4C" => '&#23248;',
 "\x55\x4D" => '&#23338;',
 "\x55\x4E" => '&#23350;',
 "\x55\x4F" => '&#23358;',
 "\x55\x50" => '&#23363;',
 "\x55\x51" => '&#23365;',
 "\x55\x52" => '&#23360;',
 "\x55\x53" => '&#23377;',
 "\x55\x54" => '&#23381;',
 "\x55\x55" => '&#23386;',
 "\x55\x56" => '&#23387;',
 "\x55\x57" => '&#23397;',
 "\x55\x58" => '&#23401;',
 "\x55\x59" => '&#23408;',
 "\x55\x5A" => '&#23411;',
 "\x55\x5B" => '&#23413;',
 "\x55\x5C" => '&#23416;',
 "\x55\x5D" => '&#25992;',
 "\x55\x5E" => '&#23418;',
 "\x55\x5F" => '&#23424;',
 "\x55\x60" => '&#23427;',
 "\x55\x61" => '&#23462;',
 "\x55\x62" => '&#23480;',
 "\x55\x63" => '&#23491;',
 "\x55\x64" => '&#23495;',
 "\x55\x65" => '&#23497;',
 "\x55\x66" => '&#23508;',
 "\x55\x67" => '&#23504;',
 "\x55\x68" => '&#23524;',
 "\x55\x69" => '&#23526;',
 "\x55\x6A" => '&#23522;',
 "\x55\x6B" => '&#23518;',
 "\x55\x6C" => '&#23525;',
 "\x55\x6D" => '&#23531;',
 "\x55\x6E" => '&#23536;',
 "\x55\x6F" => '&#23542;',
 "\x55\x70" => '&#23539;',
 "\x55\x71" => '&#23557;',
 "\x55\x72" => '&#23559;',
 "\x55\x73" => '&#23560;',
 "\x55\x74" => '&#23565;',
 "\x55\x75" => '&#23571;',
 "\x55\x76" => '&#23584;',
 "\x55\x77" => '&#23586;',
 "\x55\x78" => '&#23592;',
 "\x55\x79" => '&#23608;',
 "\x55\x7A" => '&#23609;',
 "\x55\x7B" => '&#23617;',
 "\x55\x7C" => '&#23622;',
 "\x55\x7D" => '&#23630;',
 "\x55\x7E" => '&#23635;',
 "\x56\x21" => '&#23632;',
 "\x56\x22" => '&#23631;',
 "\x56\x23" => '&#23409;',
 "\x56\x24" => '&#23660;',
 "\x56\x25" => '&#23662;',
 "\x56\x26" => '&#20066;',
 "\x56\x27" => '&#23670;',
 "\x56\x28" => '&#23673;',
 "\x56\x29" => '&#23692;',
 "\x56\x2A" => '&#23697;',
 "\x56\x2B" => '&#23700;',
 "\x56\x2C" => '&#22939;',
 "\x56\x2D" => '&#23723;',
 "\x56\x2E" => '&#23739;',
 "\x56\x2F" => '&#23734;',
 "\x56\x30" => '&#23740;',
 "\x56\x31" => '&#23735;',
 "\x56\x32" => '&#23749;',
 "\x56\x33" => '&#23742;',
 "\x56\x34" => '&#23751;',
 "\x56\x35" => '&#23769;',
 "\x56\x36" => '&#23785;',
 "\x56\x37" => '&#23805;',
 "\x56\x38" => '&#23802;',
 "\x56\x39" => '&#23789;',
 "\x56\x3A" => '&#23948;',
 "\x56\x3B" => '&#23786;',
 "\x56\x3C" => '&#23819;',
 "\x56\x3D" => '&#23829;',
 "\x56\x3E" => '&#23831;',
 "\x56\x3F" => '&#23900;',
 "\x56\x40" => '&#23839;',
 "\x56\x41" => '&#23835;',
 "\x56\x42" => '&#23825;',
 "\x56\x43" => '&#23828;',
 "\x56\x44" => '&#23842;',
 "\x56\x45" => '&#23834;',
 "\x56\x46" => '&#23833;',
 "\x56\x47" => '&#23832;',
 "\x56\x48" => '&#23884;',
 "\x56\x49" => '&#23890;',
 "\x56\x4A" => '&#23886;',
 "\x56\x4B" => '&#23883;',
 "\x56\x4C" => '&#23916;',
 "\x56\x4D" => '&#23923;',
 "\x56\x4E" => '&#23926;',
 "\x56\x4F" => '&#23943;',
 "\x56\x50" => '&#23940;',
 "\x56\x51" => '&#23938;',
 "\x56\x52" => '&#23970;',
 "\x56\x53" => '&#23965;',
 "\x56\x54" => '&#23980;',
 "\x56\x55" => '&#23982;',
 "\x56\x56" => '&#23997;',
 "\x56\x57" => '&#23952;',
 "\x56\x58" => '&#23991;',
 "\x56\x59" => '&#23996;',
 "\x56\x5A" => '&#24009;',
 "\x56\x5B" => '&#24013;',
 "\x56\x5C" => '&#24019;',
 "\x56\x5D" => '&#24018;',
 "\x56\x5E" => '&#24022;',
 "\x56\x5F" => '&#24027;',
 "\x56\x60" => '&#24043;',
 "\x56\x61" => '&#24050;',
 "\x56\x62" => '&#24053;',
 "\x56\x63" => '&#24075;',
 "\x56\x64" => '&#24090;',
 "\x56\x65" => '&#24089;',
 "\x56\x66" => '&#24081;',
 "\x56\x67" => '&#24091;',
 "\x56\x68" => '&#24118;',
 "\x56\x69" => '&#24119;',
 "\x56\x6A" => '&#24132;',
 "\x56\x6B" => '&#24131;',
 "\x56\x6C" => '&#24128;',
 "\x56\x6D" => '&#24142;',
 "\x56\x6E" => '&#24151;',
 "\x56\x6F" => '&#24148;',
 "\x56\x70" => '&#24159;',
 "\x56\x71" => '&#24162;',
 "\x56\x72" => '&#24164;',
 "\x56\x73" => '&#24135;',
 "\x56\x74" => '&#24181;',
 "\x56\x75" => '&#24182;',
 "\x56\x76" => '&#24186;',
 "\x56\x77" => '&#40636;',
 "\x56\x78" => '&#24191;',
 "\x56\x79" => '&#24224;',
 "\x56\x7A" => '&#24257;',
 "\x56\x7B" => '&#24258;',
 "\x56\x7C" => '&#24264;',
 "\x56\x7D" => '&#24272;',
 "\x56\x7E" => '&#24271;',
 "\x57\x21" => '&#24278;',
 "\x57\x22" => '&#24291;',
 "\x57\x23" => '&#24285;',
 "\x57\x24" => '&#24282;',
 "\x57\x25" => '&#24283;',
 "\x57\x26" => '&#24290;',
 "\x57\x27" => '&#24289;',
 "\x57\x28" => '&#24296;',
 "\x57\x29" => '&#24297;',
 "\x57\x2A" => '&#24300;',
 "\x57\x2B" => '&#24305;',
 "\x57\x2C" => '&#24307;',
 "\x57\x2D" => '&#24304;',
 "\x57\x2E" => '&#24308;',
 "\x57\x2F" => '&#24312;',
 "\x57\x30" => '&#24318;',
 "\x57\x31" => '&#24323;',
 "\x57\x32" => '&#24329;',
 "\x57\x33" => '&#24413;',
 "\x57\x34" => '&#24412;',
 "\x57\x35" => '&#24331;',
 "\x57\x36" => '&#24337;',
 "\x57\x37" => '&#24342;',
 "\x57\x38" => '&#24361;',
 "\x57\x39" => '&#24365;',
 "\x57\x3A" => '&#24376;',
 "\x57\x3B" => '&#24385;',
 "\x57\x3C" => '&#24392;',
 "\x57\x3D" => '&#24396;',
 "\x57\x3E" => '&#24398;',
 "\x57\x3F" => '&#24367;',
 "\x57\x40" => '&#24401;',
 "\x57\x41" => '&#24406;',
 "\x57\x42" => '&#24407;',
 "\x57\x43" => '&#24409;',
 "\x57\x44" => '&#24417;',
 "\x57\x45" => '&#24429;',
 "\x57\x46" => '&#24435;',
 "\x57\x47" => '&#24439;',
 "\x57\x48" => '&#24451;',
 "\x57\x49" => '&#24450;',
 "\x57\x4A" => '&#24447;',
 "\x57\x4B" => '&#24458;',
 "\x57\x4C" => '&#24456;',
 "\x57\x4D" => '&#24465;',
 "\x57\x4E" => '&#24455;',
 "\x57\x4F" => '&#24478;',
 "\x57\x50" => '&#24473;',
 "\x57\x51" => '&#24472;',
 "\x57\x52" => '&#24480;',
 "\x57\x53" => '&#24488;',
 "\x57\x54" => '&#24493;',
 "\x57\x55" => '&#24508;',
 "\x57\x56" => '&#24534;',
 "\x57\x57" => '&#24571;',
 "\x57\x58" => '&#24548;',
 "\x57\x59" => '&#24568;',
 "\x57\x5A" => '&#24561;',
 "\x57\x5B" => '&#24541;',
 "\x57\x5C" => '&#24755;',
 "\x57\x5D" => '&#24575;',
 "\x57\x5E" => '&#24609;',
 "\x57\x5F" => '&#24672;',
 "\x57\x60" => '&#24601;',
 "\x57\x61" => '&#24592;',
 "\x57\x62" => '&#24617;',
 "\x57\x63" => '&#24590;',
 "\x57\x64" => '&#24625;',
 "\x57\x65" => '&#24603;',
 "\x57\x66" => '&#24597;',
 "\x57\x67" => '&#24619;',
 "\x57\x68" => '&#24614;',
 "\x57\x69" => '&#24591;',
 "\x57\x6A" => '&#24634;',
 "\x57\x6B" => '&#24666;',
 "\x57\x6C" => '&#24641;',
 "\x57\x6D" => '&#24682;',
 "\x57\x6E" => '&#24695;',
 "\x57\x6F" => '&#24671;',
 "\x57\x70" => '&#24650;',
 "\x57\x71" => '&#24646;',
 "\x57\x72" => '&#24653;',
 "\x57\x73" => '&#24675;',
 "\x57\x74" => '&#24643;',
 "\x57\x75" => '&#24676;',
 "\x57\x76" => '&#24642;',
 "\x57\x77" => '&#24684;',
 "\x57\x78" => '&#24683;',
 "\x57\x79" => '&#24665;',
 "\x57\x7A" => '&#24705;',
 "\x57\x7B" => '&#24717;',
 "\x57\x7C" => '&#24807;',
 "\x57\x7D" => '&#24707;',
 "\x57\x7E" => '&#24730;',
 "\x58\x21" => '&#24708;',
 "\x58\x22" => '&#24731;',
 "\x58\x23" => '&#24726;',
 "\x58\x24" => '&#24727;',
 "\x58\x25" => '&#24722;',
 "\x58\x26" => '&#24743;',
 "\x58\x27" => '&#24715;',
 "\x58\x28" => '&#24801;',
 "\x58\x29" => '&#24760;',
 "\x58\x2A" => '&#24800;',
 "\x58\x2B" => '&#24787;',
 "\x58\x2C" => '&#24756;',
 "\x58\x2D" => '&#24560;',
 "\x58\x2E" => '&#24765;',
 "\x58\x2F" => '&#24774;',
 "\x58\x30" => '&#24757;',
 "\x58\x31" => '&#24792;',
 "\x58\x32" => '&#24909;',
 "\x58\x33" => '&#24853;',
 "\x58\x34" => '&#24838;',
 "\x58\x35" => '&#24822;',
 "\x58\x36" => '&#24823;',
 "\x58\x37" => '&#24832;',
 "\x58\x38" => '&#24820;',
 "\x58\x39" => '&#24826;',
 "\x58\x3A" => '&#24835;',
 "\x58\x3B" => '&#24865;',
 "\x58\x3C" => '&#24827;',
 "\x58\x3D" => '&#24817;',
 "\x58\x3E" => '&#24845;',
 "\x58\x3F" => '&#24846;',
 "\x58\x40" => '&#24903;',
 "\x58\x41" => '&#24894;',
 "\x58\x42" => '&#24872;',
 "\x58\x43" => '&#24871;',
 "\x58\x44" => '&#24906;',
 "\x58\x45" => '&#24895;',
 "\x58\x46" => '&#24892;',
 "\x58\x47" => '&#24876;',
 "\x58\x48" => '&#24884;',
 "\x58\x49" => '&#24893;',
 "\x58\x4A" => '&#24898;',
 "\x58\x4B" => '&#24900;',
 "\x58\x4C" => '&#24947;',
 "\x58\x4D" => '&#24951;',
 "\x58\x4E" => '&#24920;',
 "\x58\x4F" => '&#24921;',
 "\x58\x50" => '&#24922;',
 "\x58\x51" => '&#24939;',
 "\x58\x52" => '&#24948;',
 "\x58\x53" => '&#24943;',
 "\x58\x54" => '&#24933;',
 "\x58\x55" => '&#24945;',
 "\x58\x56" => '&#24927;',
 "\x58\x57" => '&#24925;',
 "\x58\x58" => '&#24915;',
 "\x58\x59" => '&#24949;',
 "\x58\x5A" => '&#24985;',
 "\x58\x5B" => '&#24982;',
 "\x58\x5C" => '&#24967;',
 "\x58\x5D" => '&#25004;',
 "\x58\x5E" => '&#24980;',
 "\x58\x5F" => '&#24986;',
 "\x58\x60" => '&#24970;',
 "\x58\x61" => '&#24977;',
 "\x58\x62" => '&#25003;',
 "\x58\x63" => '&#25006;',
 "\x58\x64" => '&#25036;',
 "\x58\x65" => '&#25034;',
 "\x58\x66" => '&#25033;',
 "\x58\x67" => '&#25079;',
 "\x58\x68" => '&#25032;',
 "\x58\x69" => '&#25027;',
 "\x58\x6A" => '&#25030;',
 "\x58\x6B" => '&#25018;',
 "\x58\x6C" => '&#25035;',
 "\x58\x6D" => '&#32633;',
 "\x58\x6E" => '&#25037;',
 "\x58\x6F" => '&#25062;',
 "\x58\x70" => '&#25059;',
 "\x58\x71" => '&#25078;',
 "\x58\x72" => '&#25082;',
 "\x58\x73" => '&#25076;',
 "\x58\x74" => '&#25087;',
 "\x58\x75" => '&#25085;',
 "\x58\x76" => '&#25084;',
 "\x58\x77" => '&#25086;',
 "\x58\x78" => '&#25088;',
 "\x58\x79" => '&#25096;',
 "\x58\x7A" => '&#25097;',
 "\x58\x7B" => '&#25101;',
 "\x58\x7C" => '&#25100;',
 "\x58\x7D" => '&#25108;',
 "\x58\x7E" => '&#25115;',
 "\x59\x21" => '&#25118;',
 "\x59\x22" => '&#25121;',
 "\x59\x23" => '&#25130;',
 "\x59\x24" => '&#25134;',
 "\x59\x25" => '&#25136;',
 "\x59\x26" => '&#25138;',
 "\x59\x27" => '&#25139;',
 "\x59\x28" => '&#25153;',
 "\x59\x29" => '&#25166;',
 "\x59\x2A" => '&#25182;',
 "\x59\x2B" => '&#25187;',
 "\x59\x2C" => '&#25179;',
 "\x59\x2D" => '&#25184;',
 "\x59\x2E" => '&#25192;',
 "\x59\x2F" => '&#25212;',
 "\x59\x30" => '&#25218;',
 "\x59\x31" => '&#25225;',
 "\x59\x32" => '&#25214;',
 "\x59\x33" => '&#25234;',
 "\x59\x34" => '&#25235;',
 "\x59\x35" => '&#25238;',
 "\x59\x36" => '&#25300;',
 "\x59\x37" => '&#25219;',
 "\x59\x38" => '&#25236;',
 "\x59\x39" => '&#25303;',
 "\x59\x3A" => '&#25297;',
 "\x59\x3B" => '&#25275;',
 "\x59\x3C" => '&#25295;',
 "\x59\x3D" => '&#25343;',
 "\x59\x3E" => '&#25286;',
 "\x59\x3F" => '&#25812;',
 "\x59\x40" => '&#25288;',
 "\x59\x41" => '&#25308;',
 "\x59\x42" => '&#25292;',
 "\x59\x43" => '&#25290;',
 "\x59\x44" => '&#25282;',
 "\x59\x45" => '&#25287;',
 "\x59\x46" => '&#25243;',
 "\x59\x47" => '&#25289;',
 "\x59\x48" => '&#25356;',
 "\x59\x49" => '&#25326;',
 "\x59\x4A" => '&#25329;',
 "\x59\x4B" => '&#25383;',
 "\x59\x4C" => '&#25346;',
 "\x59\x4D" => '&#25352;',
 "\x59\x4E" => '&#25327;',
 "\x59\x4F" => '&#25333;',
 "\x59\x50" => '&#25424;',
 "\x59\x51" => '&#25406;',
 "\x59\x52" => '&#25421;',
 "\x59\x53" => '&#25628;',
 "\x59\x54" => '&#25423;',
 "\x59\x55" => '&#25494;',
 "\x59\x56" => '&#25486;',
 "\x59\x57" => '&#25472;',
 "\x59\x58" => '&#25515;',
 "\x59\x59" => '&#25462;',
 "\x59\x5A" => '&#25507;',
 "\x59\x5B" => '&#25487;',
 "\x59\x5C" => '&#25481;',
 "\x59\x5D" => '&#25503;',
 "\x59\x5E" => '&#25525;',
 "\x59\x5F" => '&#25451;',
 "\x59\x60" => '&#25449;',
 "\x59\x61" => '&#25534;',
 "\x59\x62" => '&#25577;',
 "\x59\x63" => '&#25536;',
 "\x59\x64" => '&#25542;',
 "\x59\x65" => '&#25571;',
 "\x59\x66" => '&#25545;',
 "\x59\x67" => '&#25554;',
 "\x59\x68" => '&#25590;',
 "\x59\x69" => '&#25540;',
 "\x59\x6A" => '&#25622;',
 "\x59\x6B" => '&#25652;',
 "\x59\x6C" => '&#25606;',
 "\x59\x6D" => '&#25619;',
 "\x59\x6E" => '&#25638;',
 "\x59\x6F" => '&#25654;',
 "\x59\x70" => '&#25885;',
 "\x59\x71" => '&#25623;',
 "\x59\x72" => '&#25640;',
 "\x59\x73" => '&#25615;',
 "\x59\x74" => '&#25703;',
 "\x59\x75" => '&#25711;',
 "\x59\x76" => '&#25718;',
 "\x59\x77" => '&#25678;',
 "\x59\x78" => '&#25898;',
 "\x59\x79" => '&#25749;',
 "\x59\x7A" => '&#25747;',
 "\x59\x7B" => '&#25765;',
 "\x59\x7C" => '&#25769;',
 "\x59\x7D" => '&#25736;',
 "\x59\x7E" => '&#25788;',
 "\x5A\x21" => '&#25818;',
 "\x5A\x22" => '&#25810;',
 "\x5A\x23" => '&#25797;',
 "\x5A\x24" => '&#25799;',
 "\x5A\x25" => '&#25787;',
 "\x5A\x26" => '&#25816;',
 "\x5A\x27" => '&#25794;',
 "\x5A\x28" => '&#25841;',
 "\x5A\x29" => '&#25831;',
 "\x5A\x2A" => '&#33289;',
 "\x5A\x2B" => '&#25824;',
 "\x5A\x2C" => '&#25825;',
 "\x5A\x2D" => '&#25260;',
 "\x5A\x2E" => '&#25827;',
 "\x5A\x2F" => '&#25839;',
 "\x5A\x30" => '&#25900;',
 "\x5A\x31" => '&#25846;',
 "\x5A\x32" => '&#25844;',
 "\x5A\x33" => '&#25842;',
 "\x5A\x34" => '&#25850;',
 "\x5A\x35" => '&#25856;',
 "\x5A\x36" => '&#25853;',
 "\x5A\x37" => '&#25880;',
 "\x5A\x38" => '&#25884;',
 "\x5A\x39" => '&#25861;',
 "\x5A\x3A" => '&#25892;',
 "\x5A\x3B" => '&#25891;',
 "\x5A\x3C" => '&#25899;',
 "\x5A\x3D" => '&#25908;',
 "\x5A\x3E" => '&#25909;',
 "\x5A\x3F" => '&#25911;',
 "\x5A\x40" => '&#25910;',
 "\x5A\x41" => '&#25912;',
 "\x5A\x42" => '&#30027;',
 "\x5A\x43" => '&#25928;',
 "\x5A\x44" => '&#25942;',
 "\x5A\x45" => '&#25941;',
 "\x5A\x46" => '&#25933;',
 "\x5A\x47" => '&#25944;',
 "\x5A\x48" => '&#25950;',
 "\x5A\x49" => '&#25949;',
 "\x5A\x4A" => '&#25970;',
 "\x5A\x4B" => '&#25976;',
 "\x5A\x4C" => '&#25986;',
 "\x5A\x4D" => '&#25987;',
 "\x5A\x4E" => '&#35722;',
 "\x5A\x4F" => '&#26011;',
 "\x5A\x50" => '&#26015;',
 "\x5A\x51" => '&#26027;',
 "\x5A\x52" => '&#26039;',
 "\x5A\x53" => '&#26051;',
 "\x5A\x54" => '&#26054;',
 "\x5A\x55" => '&#26049;',
 "\x5A\x56" => '&#26052;',
 "\x5A\x57" => '&#26060;',
 "\x5A\x58" => '&#26066;',
 "\x5A\x59" => '&#26075;',
 "\x5A\x5A" => '&#26073;',
 "\x5A\x5B" => '&#26080;',
 "\x5A\x5C" => '&#26081;',
 "\x5A\x5D" => '&#26097;',
 "\x5A\x5E" => '&#26482;',
 "\x5A\x5F" => '&#26122;',
 "\x5A\x60" => '&#26115;',
 "\x5A\x61" => '&#26107;',
 "\x5A\x62" => '&#26483;',
 "\x5A\x63" => '&#26165;',
 "\x5A\x64" => '&#26166;',
 "\x5A\x65" => '&#26164;',
 "\x5A\x66" => '&#26140;',
 "\x5A\x67" => '&#26191;',
 "\x5A\x68" => '&#26180;',
 "\x5A\x69" => '&#26185;',
 "\x5A\x6A" => '&#26177;',
 "\x5A\x6B" => '&#26206;',
 "\x5A\x6C" => '&#26205;',
 "\x5A\x6D" => '&#26212;',
 "\x5A\x6E" => '&#26215;',
 "\x5A\x6F" => '&#26216;',
 "\x5A\x70" => '&#26207;',
 "\x5A\x71" => '&#26210;',
 "\x5A\x72" => '&#26224;',
 "\x5A\x73" => '&#26243;',
 "\x5A\x74" => '&#26248;',
 "\x5A\x75" => '&#26254;',
 "\x5A\x76" => '&#26249;',
 "\x5A\x77" => '&#26244;',
 "\x5A\x78" => '&#26264;',
 "\x5A\x79" => '&#26269;',
 "\x5A\x7A" => '&#26305;',
 "\x5A\x7B" => '&#26297;',
 "\x5A\x7C" => '&#26313;',
 "\x5A\x7D" => '&#26302;',
 "\x5A\x7E" => '&#26300;',
 "\x5B\x21" => '&#26308;',
 "\x5B\x22" => '&#26296;',
 "\x5B\x23" => '&#26326;',
 "\x5B\x24" => '&#26330;',
 "\x5B\x25" => '&#26336;',
 "\x5B\x26" => '&#26175;',
 "\x5B\x27" => '&#26342;',
 "\x5B\x28" => '&#26345;',
 "\x5B\x29" => '&#26352;',
 "\x5B\x2A" => '&#26357;',
 "\x5B\x2B" => '&#26359;',
 "\x5B\x2C" => '&#26383;',
 "\x5B\x2D" => '&#26390;',
 "\x5B\x2E" => '&#26398;',
 "\x5B\x2F" => '&#26406;',
 "\x5B\x30" => '&#26407;',
 "\x5B\x31" => '&#38712;',
 "\x5B\x32" => '&#26414;',
 "\x5B\x33" => '&#26431;',
 "\x5B\x34" => '&#26422;',
 "\x5B\x35" => '&#26433;',
 "\x5B\x36" => '&#26424;',
 "\x5B\x37" => '&#26423;',
 "\x5B\x38" => '&#26438;',
 "\x5B\x39" => '&#26462;',
 "\x5B\x3A" => '&#26464;',
 "\x5B\x3B" => '&#26457;',
 "\x5B\x3C" => '&#26467;',
 "\x5B\x3D" => '&#26468;',
 "\x5B\x3E" => '&#26505;',
 "\x5B\x3F" => '&#26480;',
 "\x5B\x40" => '&#26537;',
 "\x5B\x41" => '&#26492;',
 "\x5B\x42" => '&#26474;',
 "\x5B\x43" => '&#26508;',
 "\x5B\x44" => '&#26507;',
 "\x5B\x45" => '&#26534;',
 "\x5B\x46" => '&#26529;',
 "\x5B\x47" => '&#26501;',
 "\x5B\x48" => '&#26551;',
 "\x5B\x49" => '&#26607;',
 "\x5B\x4A" => '&#26548;',
 "\x5B\x4B" => '&#26604;',
 "\x5B\x4C" => '&#26547;',
 "\x5B\x4D" => '&#26601;',
 "\x5B\x4E" => '&#26552;',
 "\x5B\x4F" => '&#26596;',
 "\x5B\x50" => '&#26590;',
 "\x5B\x51" => '&#26589;',
 "\x5B\x52" => '&#26594;',
 "\x5B\x53" => '&#26606;',
 "\x5B\x54" => '&#26553;',
 "\x5B\x55" => '&#26574;',
 "\x5B\x56" => '&#26566;',
 "\x5B\x57" => '&#26599;',
 "\x5B\x58" => '&#27292;',
 "\x5B\x59" => '&#26654;',
 "\x5B\x5A" => '&#26694;',
 "\x5B\x5B" => '&#26665;',
 "\x5B\x5C" => '&#26688;',
 "\x5B\x5D" => '&#26701;',
 "\x5B\x5E" => '&#26674;',
 "\x5B\x5F" => '&#26702;',
 "\x5B\x60" => '&#26803;',
 "\x5B\x61" => '&#26667;',
 "\x5B\x62" => '&#26713;',
 "\x5B\x63" => '&#26723;',
 "\x5B\x64" => '&#26743;',
 "\x5B\x65" => '&#26751;',
 "\x5B\x66" => '&#26783;',
 "\x5B\x67" => '&#26767;',
 "\x5B\x68" => '&#26797;',
 "\x5B\x69" => '&#26772;',
 "\x5B\x6A" => '&#26781;',
 "\x5B\x6B" => '&#26779;',
 "\x5B\x6C" => '&#26755;',
 "\x5B\x6D" => '&#27310;',
 "\x5B\x6E" => '&#26809;',
 "\x5B\x6F" => '&#26740;',
 "\x5B\x70" => '&#26805;',
 "\x5B\x71" => '&#26784;',
 "\x5B\x72" => '&#26810;',
 "\x5B\x73" => '&#26895;',
 "\x5B\x74" => '&#26765;',
 "\x5B\x75" => '&#26750;',
 "\x5B\x76" => '&#26881;',
 "\x5B\x77" => '&#26826;',
 "\x5B\x78" => '&#26888;',
 "\x5B\x79" => '&#26840;',
 "\x5B\x7A" => '&#26914;',
 "\x5B\x7B" => '&#26918;',
 "\x5B\x7C" => '&#26849;',
 "\x5B\x7D" => '&#26892;',
 "\x5B\x7E" => '&#26829;',
 "\x5C\x21" => '&#26836;',
 "\x5C\x22" => '&#26855;',
 "\x5C\x23" => '&#26837;',
 "\x5C\x24" => '&#26934;',
 "\x5C\x25" => '&#26898;',
 "\x5C\x26" => '&#26884;',
 "\x5C\x27" => '&#26839;',
 "\x5C\x28" => '&#26851;',
 "\x5C\x29" => '&#26917;',
 "\x5C\x2A" => '&#26873;',
 "\x5C\x2B" => '&#26848;',
 "\x5C\x2C" => '&#26863;',
 "\x5C\x2D" => '&#26920;',
 "\x5C\x2E" => '&#26922;',
 "\x5C\x2F" => '&#26906;',
 "\x5C\x30" => '&#26915;',
 "\x5C\x31" => '&#26913;',
 "\x5C\x32" => '&#26822;',
 "\x5C\x33" => '&#27001;',
 "\x5C\x34" => '&#26999;',
 "\x5C\x35" => '&#26972;',
 "\x5C\x36" => '&#27000;',
 "\x5C\x37" => '&#26987;',
 "\x5C\x38" => '&#26964;',
 "\x5C\x39" => '&#27006;',
 "\x5C\x3A" => '&#26990;',
 "\x5C\x3B" => '&#26937;',
 "\x5C\x3C" => '&#26996;',
 "\x5C\x3D" => '&#26941;',
 "\x5C\x3E" => '&#26969;',
 "\x5C\x3F" => '&#26928;',
 "\x5C\x40" => '&#26977;',
 "\x5C\x41" => '&#26974;',
 "\x5C\x42" => '&#26973;',
 "\x5C\x43" => '&#27009;',
 "\x5C\x44" => '&#26986;',
 "\x5C\x45" => '&#27058;',
 "\x5C\x46" => '&#27054;',
 "\x5C\x47" => '&#27088;',
 "\x5C\x48" => '&#27071;',
 "\x5C\x49" => '&#27073;',
 "\x5C\x4A" => '&#27091;',
 "\x5C\x4B" => '&#27070;',
 "\x5C\x4C" => '&#27086;',
 "\x5C\x4D" => '&#23528;',
 "\x5C\x4E" => '&#27082;',
 "\x5C\x4F" => '&#27101;',
 "\x5C\x50" => '&#27067;',
 "\x5C\x51" => '&#27075;',
 "\x5C\x52" => '&#27047;',
 "\x5C\x53" => '&#27182;',
 "\x5C\x54" => '&#27025;',
 "\x5C\x55" => '&#27040;',
 "\x5C\x56" => '&#27036;',
 "\x5C\x57" => '&#27029;',
 "\x5C\x58" => '&#27060;',
 "\x5C\x59" => '&#27102;',
 "\x5C\x5A" => '&#27112;',
 "\x5C\x5B" => '&#27138;',
 "\x5C\x5C" => '&#27163;',
 "\x5C\x5D" => '&#27135;',
 "\x5C\x5E" => '&#27402;',
 "\x5C\x5F" => '&#27129;',
 "\x5C\x60" => '&#27122;',
 "\x5C\x61" => '&#27111;',
 "\x5C\x62" => '&#27141;',
 "\x5C\x63" => '&#27057;',
 "\x5C\x64" => '&#27166;',
 "\x5C\x65" => '&#27117;',
 "\x5C\x66" => '&#27156;',
 "\x5C\x67" => '&#27115;',
 "\x5C\x68" => '&#27146;',
 "\x5C\x69" => '&#27154;',
 "\x5C\x6A" => '&#27329;',
 "\x5C\x6B" => '&#27171;',
 "\x5C\x6C" => '&#27155;',
 "\x5C\x6D" => '&#27204;',
 "\x5C\x6E" => '&#27148;',
 "\x5C\x6F" => '&#27250;',
 "\x5C\x70" => '&#27190;',
 "\x5C\x71" => '&#27256;',
 "\x5C\x72" => '&#27207;',
 "\x5C\x73" => '&#27234;',
 "\x5C\x74" => '&#27225;',
 "\x5C\x75" => '&#27238;',
 "\x5C\x76" => '&#27208;',
 "\x5C\x77" => '&#27192;',
 "\x5C\x78" => '&#27170;',
 "\x5C\x79" => '&#27280;',
 "\x5C\x7A" => '&#27277;',
 "\x5C\x7B" => '&#27296;',
 "\x5C\x7C" => '&#27268;',
 "\x5C\x7D" => '&#27298;',
 "\x5C\x7E" => '&#27299;',
 "\x5D\x21" => '&#27287;',
 "\x5D\x22" => '&#34327;',
 "\x5D\x23" => '&#27323;',
 "\x5D\x24" => '&#27331;',
 "\x5D\x25" => '&#27330;',
 "\x5D\x26" => '&#27320;',
 "\x5D\x27" => '&#27315;',
 "\x5D\x28" => '&#27308;',
 "\x5D\x29" => '&#27358;',
 "\x5D\x2A" => '&#27345;',
 "\x5D\x2B" => '&#27359;',
 "\x5D\x2C" => '&#27306;',
 "\x5D\x2D" => '&#27354;',
 "\x5D\x2E" => '&#27370;',
 "\x5D\x2F" => '&#27387;',
 "\x5D\x30" => '&#27397;',
 "\x5D\x31" => '&#34326;',
 "\x5D\x32" => '&#27386;',
 "\x5D\x33" => '&#27410;',
 "\x5D\x34" => '&#27414;',
 "\x5D\x35" => '&#39729;',
 "\x5D\x36" => '&#27423;',
 "\x5D\x37" => '&#27448;',
 "\x5D\x38" => '&#27447;',
 "\x5D\x39" => '&#30428;',
 "\x5D\x3A" => '&#27449;',
 "\x5D\x3B" => '&#39150;',
 "\x5D\x3C" => '&#27463;',
 "\x5D\x3D" => '&#27459;',
 "\x5D\x3E" => '&#27465;',
 "\x5D\x3F" => '&#27472;',
 "\x5D\x40" => '&#27481;',
 "\x5D\x41" => '&#27476;',
 "\x5D\x42" => '&#27483;',
 "\x5D\x43" => '&#27487;',
 "\x5D\x44" => '&#27489;',
 "\x5D\x45" => '&#27512;',
 "\x5D\x46" => '&#27513;',
 "\x5D\x47" => '&#27519;',
 "\x5D\x48" => '&#27520;',
 "\x5D\x49" => '&#27524;',
 "\x5D\x4A" => '&#27523;',
 "\x5D\x4B" => '&#27533;',
 "\x5D\x4C" => '&#27544;',
 "\x5D\x4D" => '&#27541;',
 "\x5D\x4E" => '&#27550;',
 "\x5D\x4F" => '&#27556;',
 "\x5D\x50" => '&#27562;',
 "\x5D\x51" => '&#27563;',
 "\x5D\x52" => '&#27567;',
 "\x5D\x53" => '&#27570;',
 "\x5D\x54" => '&#27569;',
 "\x5D\x55" => '&#27571;',
 "\x5D\x56" => '&#27575;',
 "\x5D\x57" => '&#27580;',
 "\x5D\x58" => '&#27590;',
 "\x5D\x59" => '&#27595;',
 "\x5D\x5A" => '&#27603;',
 "\x5D\x5B" => '&#27615;',
 "\x5D\x5C" => '&#27628;',
 "\x5D\x5D" => '&#27627;',
 "\x5D\x5E" => '&#27635;',
 "\x5D\x5F" => '&#27631;',
 "\x5D\x60" => '&#40638;',
 "\x5D\x61" => '&#27656;',
 "\x5D\x62" => '&#27667;',
 "\x5D\x63" => '&#27668;',
 "\x5D\x64" => '&#27675;',
 "\x5D\x65" => '&#27684;',
 "\x5D\x66" => '&#27683;',
 "\x5D\x67" => '&#27742;',
 "\x5D\x68" => '&#27733;',
 "\x5D\x69" => '&#27746;',
 "\x5D\x6A" => '&#27754;',
 "\x5D\x6B" => '&#27778;',
 "\x5D\x6C" => '&#27789;',
 "\x5D\x6D" => '&#27802;',
 "\x5D\x6E" => '&#27777;',
 "\x5D\x6F" => '&#27803;',
 "\x5D\x70" => '&#27774;',
 "\x5D\x71" => '&#27752;',
 "\x5D\x72" => '&#27763;',
 "\x5D\x73" => '&#27794;',
 "\x5D\x74" => '&#27792;',
 "\x5D\x75" => '&#27844;',
 "\x5D\x76" => '&#27889;',
 "\x5D\x77" => '&#27859;',
 "\x5D\x78" => '&#27837;',
 "\x5D\x79" => '&#27863;',
 "\x5D\x7A" => '&#27845;',
 "\x5D\x7B" => '&#27869;',
 "\x5D\x7C" => '&#27822;',
 "\x5D\x7D" => '&#27825;',
 "\x5D\x7E" => '&#27838;',
 "\x5E\x21" => '&#27834;',
 "\x5E\x22" => '&#27867;',
 "\x5E\x23" => '&#27887;',
 "\x5E\x24" => '&#27865;',
 "\x5E\x25" => '&#27882;',
 "\x5E\x26" => '&#27935;',
 "\x5E\x27" => '&#34893;',
 "\x5E\x28" => '&#27958;',
 "\x5E\x29" => '&#27947;',
 "\x5E\x2A" => '&#27965;',
 "\x5E\x2B" => '&#27960;',
 "\x5E\x2C" => '&#27929;',
 "\x5E\x2D" => '&#27957;',
 "\x5E\x2E" => '&#27955;',
 "\x5E\x2F" => '&#27922;',
 "\x5E\x30" => '&#27916;',
 "\x5E\x31" => '&#28003;',
 "\x5E\x32" => '&#28051;',
 "\x5E\x33" => '&#28004;',
 "\x5E\x34" => '&#27994;',
 "\x5E\x35" => '&#28025;',
 "\x5E\x36" => '&#27993;',
 "\x5E\x37" => '&#28046;',
 "\x5E\x38" => '&#28053;',
 "\x5E\x39" => '&#28644;',
 "\x5E\x3A" => '&#28037;',
 "\x5E\x3B" => '&#28153;',
 "\x5E\x3C" => '&#28181;',
 "\x5E\x3D" => '&#28170;',
 "\x5E\x3E" => '&#28085;',
 "\x5E\x3F" => '&#28103;',
 "\x5E\x40" => '&#28134;',
 "\x5E\x41" => '&#28088;',
 "\x5E\x42" => '&#28102;',
 "\x5E\x43" => '&#28140;',
 "\x5E\x44" => '&#28126;',
 "\x5E\x45" => '&#28108;',
 "\x5E\x46" => '&#28136;',
 "\x5E\x47" => '&#28114;',
 "\x5E\x48" => '&#28101;',
 "\x5E\x49" => '&#28154;',
 "\x5E\x4A" => '&#28121;',
 "\x5E\x4B" => '&#28132;',
 "\x5E\x4C" => '&#28117;',
 "\x5E\x4D" => '&#28138;',
 "\x5E\x4E" => '&#28142;',
 "\x5E\x4F" => '&#28205;',
 "\x5E\x50" => '&#28270;',
 "\x5E\x51" => '&#28206;',
 "\x5E\x52" => '&#28185;',
 "\x5E\x53" => '&#28274;',
 "\x5E\x54" => '&#28255;',
 "\x5E\x55" => '&#28222;',
 "\x5E\x56" => '&#28195;',
 "\x5E\x57" => '&#28267;',
 "\x5E\x58" => '&#28203;',
 "\x5E\x59" => '&#28278;',
 "\x5E\x5A" => '&#28237;',
 "\x5E\x5B" => '&#28191;',
 "\x5E\x5C" => '&#28227;',
 "\x5E\x5D" => '&#28218;',
 "\x5E\x5E" => '&#28238;',
 "\x5E\x5F" => '&#28196;',
 "\x5E\x60" => '&#28415;',
 "\x5E\x61" => '&#28189;',
 "\x5E\x62" => '&#28216;',
 "\x5E\x63" => '&#28290;',
 "\x5E\x64" => '&#28330;',
 "\x5E\x65" => '&#28312;',
 "\x5E\x66" => '&#28361;',
 "\x5E\x67" => '&#28343;',
 "\x5E\x68" => '&#28371;',
 "\x5E\x69" => '&#28349;',
 "\x5E\x6A" => '&#28335;',
 "\x5E\x6B" => '&#28356;',
 "\x5E\x6C" => '&#28338;',
 "\x5E\x6D" => '&#28372;',
 "\x5E\x6E" => '&#28373;',
 "\x5E\x6F" => '&#28303;',
 "\x5E\x70" => '&#28325;',
 "\x5E\x71" => '&#28354;',
 "\x5E\x72" => '&#28319;',
 "\x5E\x73" => '&#28481;',
 "\x5E\x74" => '&#28433;',
 "\x5E\x75" => '&#28748;',
 "\x5E\x76" => '&#28396;',
 "\x5E\x77" => '&#28408;',
 "\x5E\x78" => '&#28414;',
 "\x5E\x79" => '&#28479;',
 "\x5E\x7A" => '&#28402;',
 "\x5E\x7B" => '&#28465;',
 "\x5E\x7C" => '&#28399;',
 "\x5E\x7D" => '&#28466;',
 "\x5E\x7E" => '&#28364;',
 "\x5F\x21" => '&#28478;',
 "\x5F\x22" => '&#28435;',
 "\x5F\x23" => '&#28407;',
 "\x5F\x24" => '&#28550;',
 "\x5F\x25" => '&#28538;',
 "\x5F\x26" => '&#28536;',
 "\x5F\x27" => '&#28545;',
 "\x5F\x28" => '&#28544;',
 "\x5F\x29" => '&#28527;',
 "\x5F\x2A" => '&#28507;',
 "\x5F\x2B" => '&#28659;',
 "\x5F\x2C" => '&#28525;',
 "\x5F\x2D" => '&#28546;',
 "\x5F\x2E" => '&#28540;',
 "\x5F\x2F" => '&#28504;',
 "\x5F\x30" => '&#28558;',
 "\x5F\x31" => '&#28561;',
 "\x5F\x32" => '&#28610;',
 "\x5F\x33" => '&#28518;',
 "\x5F\x34" => '&#28595;',
 "\x5F\x35" => '&#28579;',
 "\x5F\x36" => '&#28577;',
 "\x5F\x37" => '&#28580;',
 "\x5F\x38" => '&#28601;',
 "\x5F\x39" => '&#28614;',
 "\x5F\x3A" => '&#28586;',
 "\x5F\x3B" => '&#28639;',
 "\x5F\x3C" => '&#28629;',
 "\x5F\x3D" => '&#28652;',
 "\x5F\x3E" => '&#28628;',
 "\x5F\x3F" => '&#28632;',
 "\x5F\x40" => '&#28657;',
 "\x5F\x41" => '&#28654;',
 "\x5F\x42" => '&#28635;',
 "\x5F\x43" => '&#28681;',
 "\x5F\x44" => '&#28683;',
 "\x5F\x45" => '&#28666;',
 "\x5F\x46" => '&#28689;',
 "\x5F\x47" => '&#28673;',
 "\x5F\x48" => '&#28687;',
 "\x5F\x49" => '&#28670;',
 "\x5F\x4A" => '&#28699;',
 "\x5F\x4B" => '&#28698;',
 "\x5F\x4C" => '&#28532;',
 "\x5F\x4D" => '&#28701;',
 "\x5F\x4E" => '&#28696;',
 "\x5F\x4F" => '&#28703;',
 "\x5F\x50" => '&#28720;',
 "\x5F\x51" => '&#28734;',
 "\x5F\x52" => '&#28722;',
 "\x5F\x53" => '&#28753;',
 "\x5F\x54" => '&#28771;',
 "\x5F\x55" => '&#28825;',
 "\x5F\x56" => '&#28818;',
 "\x5F\x57" => '&#28847;',
 "\x5F\x58" => '&#28913;',
 "\x5F\x59" => '&#28844;',
 "\x5F\x5A" => '&#28856;',
 "\x5F\x5B" => '&#28851;',
 "\x5F\x5C" => '&#28846;',
 "\x5F\x5D" => '&#28895;',
 "\x5F\x5E" => '&#28875;',
 "\x5F\x5F" => '&#28893;',
 "\x5F\x60" => '&#28889;',
 "\x5F\x61" => '&#28937;',
 "\x5F\x62" => '&#28925;',
 "\x5F\x63" => '&#28956;',
 "\x5F\x64" => '&#28953;',
 "\x5F\x65" => '&#29029;',
 "\x5F\x66" => '&#29013;',
 "\x5F\x67" => '&#29064;',
 "\x5F\x68" => '&#29030;',
 "\x5F\x69" => '&#29026;',
 "\x5F\x6A" => '&#29004;',
 "\x5F\x6B" => '&#29014;',
 "\x5F\x6C" => '&#29036;',
 "\x5F\x6D" => '&#29071;',
 "\x5F\x6E" => '&#29179;',
 "\x5F\x6F" => '&#29060;',
 "\x5F\x70" => '&#29077;',
 "\x5F\x71" => '&#29096;',
 "\x5F\x72" => '&#29100;',
 "\x5F\x73" => '&#29143;',
 "\x5F\x74" => '&#29113;',
 "\x5F\x75" => '&#29118;',
 "\x5F\x76" => '&#29138;',
 "\x5F\x77" => '&#29129;',
 "\x5F\x78" => '&#29140;',
 "\x5F\x79" => '&#29134;',
 "\x5F\x7A" => '&#29152;',
 "\x5F\x7B" => '&#29164;',
 "\x5F\x7C" => '&#29159;',
 "\x5F\x7D" => '&#29173;',
 "\x5F\x7E" => '&#29180;',
 "\x60\x21" => '&#29177;',
 "\x60\x22" => '&#29183;',
 "\x60\x23" => '&#29197;',
 "\x60\x24" => '&#29200;',
 "\x60\x25" => '&#29211;',
 "\x60\x26" => '&#29224;',
 "\x60\x27" => '&#29229;',
 "\x60\x28" => '&#29228;',
 "\x60\x29" => '&#29232;',
 "\x60\x2A" => '&#29234;',
 "\x60\x2B" => '&#29243;',
 "\x60\x2C" => '&#29244;',
 "\x60\x2D" => '&#29247;',
 "\x60\x2E" => '&#29248;',
 "\x60\x2F" => '&#29254;',
 "\x60\x30" => '&#29259;',
 "\x60\x31" => '&#29272;',
 "\x60\x32" => '&#29300;',
 "\x60\x33" => '&#29310;',
 "\x60\x34" => '&#29314;',
 "\x60\x35" => '&#29313;',
 "\x60\x36" => '&#29319;',
 "\x60\x37" => '&#29330;',
 "\x60\x38" => '&#29334;',
 "\x60\x39" => '&#29346;',
 "\x60\x3A" => '&#29351;',
 "\x60\x3B" => '&#29369;',
 "\x60\x3C" => '&#29362;',
 "\x60\x3D" => '&#29379;',
 "\x60\x3E" => '&#29382;',
 "\x60\x3F" => '&#29380;',
 "\x60\x40" => '&#29390;',
 "\x60\x41" => '&#29394;',
 "\x60\x42" => '&#29410;',
 "\x60\x43" => '&#29408;',
 "\x60\x44" => '&#29409;',
 "\x60\x45" => '&#29433;',
 "\x60\x46" => '&#29431;',
 "\x60\x47" => '&#20495;',
 "\x60\x48" => '&#29463;',
 "\x60\x49" => '&#29450;',
 "\x60\x4A" => '&#29468;',
 "\x60\x4B" => '&#29462;',
 "\x60\x4C" => '&#29469;',
 "\x60\x4D" => '&#29492;',
 "\x60\x4E" => '&#29487;',
 "\x60\x4F" => '&#29481;',
 "\x60\x50" => '&#29477;',
 "\x60\x51" => '&#29502;',
 "\x60\x52" => '&#29518;',
 "\x60\x53" => '&#29519;',
 "\x60\x54" => '&#40664;',
 "\x60\x55" => '&#29527;',
 "\x60\x56" => '&#29546;',
 "\x60\x57" => '&#29544;',
 "\x60\x58" => '&#29552;',
 "\x60\x59" => '&#29560;',
 "\x60\x5A" => '&#29557;',
 "\x60\x5B" => '&#29563;',
 "\x60\x5C" => '&#29562;',
 "\x60\x5D" => '&#29640;',
 "\x60\x5E" => '&#29619;',
 "\x60\x5F" => '&#29646;',
 "\x60\x60" => '&#29627;',
 "\x60\x61" => '&#29632;',
 "\x60\x62" => '&#29669;',
 "\x60\x63" => '&#29678;',
 "\x60\x64" => '&#29662;',
 "\x60\x65" => '&#29858;',
 "\x60\x66" => '&#29701;',
 "\x60\x67" => '&#29807;',
 "\x60\x68" => '&#29733;',
 "\x60\x69" => '&#29688;',
 "\x60\x6A" => '&#29746;',
 "\x60\x6B" => '&#29754;',
 "\x60\x6C" => '&#29781;',
 "\x60\x6D" => '&#29759;',
 "\x60\x6E" => '&#29791;',
 "\x60\x6F" => '&#29785;',
 "\x60\x70" => '&#29761;',
 "\x60\x71" => '&#29788;',
 "\x60\x72" => '&#29801;',
 "\x60\x73" => '&#29808;',
 "\x60\x74" => '&#29795;',
 "\x60\x75" => '&#29802;',
 "\x60\x76" => '&#29814;',
 "\x60\x77" => '&#29822;',
 "\x60\x78" => '&#29835;',
 "\x60\x79" => '&#29854;',
 "\x60\x7A" => '&#29863;',
 "\x60\x7B" => '&#29898;',
 "\x60\x7C" => '&#29903;',
 "\x60\x7D" => '&#29908;',
 "\x60\x7E" => '&#29681;',
 "\x61\x21" => '&#29920;',
 "\x61\x22" => '&#29923;',
 "\x61\x23" => '&#29927;',
 "\x61\x24" => '&#29929;',
 "\x61\x25" => '&#29934;',
 "\x61\x26" => '&#29938;',
 "\x61\x27" => '&#29936;',
 "\x61\x28" => '&#29937;',
 "\x61\x29" => '&#29944;',
 "\x61\x2A" => '&#29943;',
 "\x61\x2B" => '&#29956;',
 "\x61\x2C" => '&#29955;',
 "\x61\x2D" => '&#29957;',
 "\x61\x2E" => '&#29964;',
 "\x61\x2F" => '&#29966;',
 "\x61\x30" => '&#29965;',
 "\x61\x31" => '&#29973;',
 "\x61\x32" => '&#29971;',
 "\x61\x33" => '&#29982;',
 "\x61\x34" => '&#29990;',
 "\x61\x35" => '&#29996;',
 "\x61\x36" => '&#30012;',
 "\x61\x37" => '&#30020;',
 "\x61\x38" => '&#30029;',
 "\x61\x39" => '&#30026;',
 "\x61\x3A" => '&#30025;',
 "\x61\x3B" => '&#30043;',
 "\x61\x3C" => '&#30022;',
 "\x61\x3D" => '&#30042;',
 "\x61\x3E" => '&#30057;',
 "\x61\x3F" => '&#30052;',
 "\x61\x40" => '&#30055;',
 "\x61\x41" => '&#30059;',
 "\x61\x42" => '&#30061;',
 "\x61\x43" => '&#30072;',
 "\x61\x44" => '&#30070;',
 "\x61\x45" => '&#30086;',
 "\x61\x46" => '&#30087;',
 "\x61\x47" => '&#30068;',
 "\x61\x48" => '&#30090;',
 "\x61\x49" => '&#30089;',
 "\x61\x4A" => '&#30082;',
 "\x61\x4B" => '&#30100;',
 "\x61\x4C" => '&#30106;',
 "\x61\x4D" => '&#30109;',
 "\x61\x4E" => '&#30117;',
 "\x61\x4F" => '&#30115;',
 "\x61\x50" => '&#30146;',
 "\x61\x51" => '&#30131;',
 "\x61\x52" => '&#30147;',
 "\x61\x53" => '&#30133;',
 "\x61\x54" => '&#30141;',
 "\x61\x55" => '&#30136;',
 "\x61\x56" => '&#30140;',
 "\x61\x57" => '&#30129;',
 "\x61\x58" => '&#30157;',
 "\x61\x59" => '&#30154;',
 "\x61\x5A" => '&#30162;',
 "\x61\x5B" => '&#30169;',
 "\x61\x5C" => '&#30179;',
 "\x61\x5D" => '&#30174;',
 "\x61\x5E" => '&#30206;',
 "\x61\x5F" => '&#30207;',
 "\x61\x60" => '&#30204;',
 "\x61\x61" => '&#30209;',
 "\x61\x62" => '&#30192;',
 "\x61\x63" => '&#30202;',
 "\x61\x64" => '&#30194;',
 "\x61\x65" => '&#30195;',
 "\x61\x66" => '&#30219;',
 "\x61\x67" => '&#30221;',
 "\x61\x68" => '&#30217;',
 "\x61\x69" => '&#30239;',
 "\x61\x6A" => '&#30247;',
 "\x61\x6B" => '&#30240;',
 "\x61\x6C" => '&#30241;',
 "\x61\x6D" => '&#30242;',
 "\x61\x6E" => '&#30244;',
 "\x61\x6F" => '&#30260;',
 "\x61\x70" => '&#30256;',
 "\x61\x71" => '&#30267;',
 "\x61\x72" => '&#30279;',
 "\x61\x73" => '&#30280;',
 "\x61\x74" => '&#30278;',
 "\x61\x75" => '&#30300;',
 "\x61\x76" => '&#30296;',
 "\x61\x77" => '&#30305;',
 "\x61\x78" => '&#30306;',
 "\x61\x79" => '&#30312;',
 "\x61\x7A" => '&#30313;',
 "\x61\x7B" => '&#30314;',
 "\x61\x7C" => '&#30311;',
 "\x61\x7D" => '&#30316;',
 "\x61\x7E" => '&#30320;',
 "\x62\x21" => '&#30322;',
 "\x62\x22" => '&#30326;',
 "\x62\x23" => '&#30328;',
 "\x62\x24" => '&#30332;',
 "\x62\x25" => '&#30336;',
 "\x62\x26" => '&#30339;',
 "\x62\x27" => '&#30344;',
 "\x62\x28" => '&#30347;',
 "\x62\x29" => '&#30350;',
 "\x62\x2A" => '&#30358;',
 "\x62\x2B" => '&#30355;',
 "\x62\x2C" => '&#30361;',
 "\x62\x2D" => '&#30362;',
 "\x62\x2E" => '&#30384;',
 "\x62\x2F" => '&#30388;',
 "\x62\x30" => '&#30392;',
 "\x62\x31" => '&#30393;',
 "\x62\x32" => '&#30394;',
 "\x62\x33" => '&#30402;',
 "\x62\x34" => '&#30413;',
 "\x62\x35" => '&#30422;',
 "\x62\x36" => '&#30418;',
 "\x62\x37" => '&#30430;',
 "\x62\x38" => '&#30433;',
 "\x62\x39" => '&#30437;',
 "\x62\x3A" => '&#30439;',
 "\x62\x3B" => '&#30442;',
 "\x62\x3C" => '&#34351;',
 "\x62\x3D" => '&#30459;',
 "\x62\x3E" => '&#30472;',
 "\x62\x3F" => '&#30471;',
 "\x62\x40" => '&#30468;',
 "\x62\x41" => '&#30505;',
 "\x62\x42" => '&#30500;',
 "\x62\x43" => '&#30494;',
 "\x62\x44" => '&#30501;',
 "\x62\x45" => '&#30502;',
 "\x62\x46" => '&#30491;',
 "\x62\x47" => '&#30519;',
 "\x62\x48" => '&#30520;',
 "\x62\x49" => '&#30535;',
 "\x62\x4A" => '&#30554;',
 "\x62\x4B" => '&#30568;',
 "\x62\x4C" => '&#30571;',
 "\x62\x4D" => '&#30555;',
 "\x62\x4E" => '&#30565;',
 "\x62\x4F" => '&#30591;',
 "\x62\x50" => '&#30590;',
 "\x62\x51" => '&#30585;',
 "\x62\x52" => '&#30606;',
 "\x62\x53" => '&#30603;',
 "\x62\x54" => '&#30609;',
 "\x62\x55" => '&#30624;',
 "\x62\x56" => '&#30622;',
 "\x62\x57" => '&#30640;',
 "\x62\x58" => '&#30646;',
 "\x62\x59" => '&#30649;',
 "\x62\x5A" => '&#30655;',
 "\x62\x5B" => '&#30652;',
 "\x62\x5C" => '&#30653;',
 "\x62\x5D" => '&#30651;',
 "\x62\x5E" => '&#30663;',
 "\x62\x5F" => '&#30669;',
 "\x62\x60" => '&#30679;',
 "\x62\x61" => '&#30682;',
 "\x62\x62" => '&#30684;',
 "\x62\x63" => '&#30691;',
 "\x62\x64" => '&#30702;',
 "\x62\x65" => '&#30716;',
 "\x62\x66" => '&#30732;',
 "\x62\x67" => '&#30738;',
 "\x62\x68" => '&#31014;',
 "\x62\x69" => '&#30752;',
 "\x62\x6A" => '&#31018;',
 "\x62\x6B" => '&#30789;',
 "\x62\x6C" => '&#30862;',
 "\x62\x6D" => '&#30836;',
 "\x62\x6E" => '&#30854;',
 "\x62\x6F" => '&#30844;',
 "\x62\x70" => '&#30874;',
 "\x62\x71" => '&#30860;',
 "\x62\x72" => '&#30883;',
 "\x62\x73" => '&#30901;',
 "\x62\x74" => '&#30890;',
 "\x62\x75" => '&#30895;',
 "\x62\x76" => '&#30929;',
 "\x62\x77" => '&#30918;',
 "\x62\x78" => '&#30923;',
 "\x62\x79" => '&#30932;',
 "\x62\x7A" => '&#30910;',
 "\x62\x7B" => '&#30908;',
 "\x62\x7C" => '&#30917;',
 "\x62\x7D" => '&#30922;',
 "\x62\x7E" => '&#30956;',
 "\x63\x21" => '&#30951;',
 "\x63\x22" => '&#30938;',
 "\x63\x23" => '&#30973;',
 "\x63\x24" => '&#30964;',
 "\x63\x25" => '&#30983;',
 "\x63\x26" => '&#30994;',
 "\x63\x27" => '&#30993;',
 "\x63\x28" => '&#31001;',
 "\x63\x29" => '&#31020;',
 "\x63\x2A" => '&#31019;',
 "\x63\x2B" => '&#31040;',
 "\x63\x2C" => '&#31072;',
 "\x63\x2D" => '&#31063;',
 "\x63\x2E" => '&#31071;',
 "\x63\x2F" => '&#31066;',
 "\x63\x30" => '&#31061;',
 "\x63\x31" => '&#31059;',
 "\x63\x32" => '&#31098;',
 "\x63\x33" => '&#31103;',
 "\x63\x34" => '&#31114;',
 "\x63\x35" => '&#31133;',
 "\x63\x36" => '&#31143;',
 "\x63\x37" => '&#40779;',
 "\x63\x38" => '&#31146;',
 "\x63\x39" => '&#31150;',
 "\x63\x3A" => '&#31155;',
 "\x63\x3B" => '&#31161;',
 "\x63\x3C" => '&#31162;',
 "\x63\x3D" => '&#31177;',
 "\x63\x3E" => '&#31189;',
 "\x63\x3F" => '&#31207;',
 "\x63\x40" => '&#31212;',
 "\x63\x41" => '&#31201;',
 "\x63\x42" => '&#31203;',
 "\x63\x43" => '&#31240;',
 "\x63\x44" => '&#31245;',
 "\x63\x45" => '&#31256;',
 "\x63\x46" => '&#31257;',
 "\x63\x47" => '&#31264;',
 "\x63\x48" => '&#31263;',
 "\x63\x49" => '&#31104;',
 "\x63\x4A" => '&#31281;',
 "\x63\x4B" => '&#31291;',
 "\x63\x4C" => '&#31294;',
 "\x63\x4D" => '&#31287;',
 "\x63\x4E" => '&#31299;',
 "\x63\x4F" => '&#31319;',
 "\x63\x50" => '&#31305;',
 "\x63\x51" => '&#31329;',
 "\x63\x52" => '&#31330;',
 "\x63\x53" => '&#31337;',
 "\x63\x54" => '&#40861;',
 "\x63\x55" => '&#31344;',
 "\x63\x56" => '&#31353;',
 "\x63\x57" => '&#31357;',
 "\x63\x58" => '&#31368;',
 "\x63\x59" => '&#31383;',
 "\x63\x5A" => '&#31381;',
 "\x63\x5B" => '&#31384;',
 "\x63\x5C" => '&#31382;',
 "\x63\x5D" => '&#31401;',
 "\x63\x5E" => '&#31432;',
 "\x63\x5F" => '&#31408;',
 "\x63\x60" => '&#31414;',
 "\x63\x61" => '&#31429;',
 "\x63\x62" => '&#31428;',
 "\x63\x63" => '&#31423;',
 "\x63\x64" => '&#36995;',
 "\x63\x65" => '&#31431;',
 "\x63\x66" => '&#31434;',
 "\x63\x67" => '&#31437;',
 "\x63\x68" => '&#31439;',
 "\x63\x69" => '&#31445;',
 "\x63\x6A" => '&#31443;',
 "\x63\x6B" => '&#31449;',
 "\x63\x6C" => '&#31450;',
 "\x63\x6D" => '&#31453;',
 "\x63\x6E" => '&#31457;',
 "\x63\x6F" => '&#31458;',
 "\x63\x70" => '&#31462;',
 "\x63\x71" => '&#31469;',
 "\x63\x72" => '&#31472;',
 "\x63\x73" => '&#31490;',
 "\x63\x74" => '&#31503;',
 "\x63\x75" => '&#31498;',
 "\x63\x76" => '&#31494;',
 "\x63\x77" => '&#31539;',
 "\x63\x78" => '&#31512;',
 "\x63\x79" => '&#31513;',
 "\x63\x7A" => '&#31518;',
 "\x63\x7B" => '&#31541;',
 "\x63\x7C" => '&#31528;',
 "\x63\x7D" => '&#31542;',
 "\x63\x7E" => '&#31568;',
 "\x64\x21" => '&#31610;',
 "\x64\x22" => '&#31492;',
 "\x64\x23" => '&#31565;',
 "\x64\x24" => '&#31499;',
 "\x64\x25" => '&#31564;',
 "\x64\x26" => '&#31557;',
 "\x64\x27" => '&#31605;',
 "\x64\x28" => '&#31589;',
 "\x64\x29" => '&#31604;',
 "\x64\x2A" => '&#31591;',
 "\x64\x2B" => '&#31600;',
 "\x64\x2C" => '&#31601;',
 "\x64\x2D" => '&#31596;',
 "\x64\x2E" => '&#31598;',
 "\x64\x2F" => '&#31645;',
 "\x64\x30" => '&#31640;',
 "\x64\x31" => '&#31647;',
 "\x64\x32" => '&#31629;',
 "\x64\x33" => '&#31644;',
 "\x64\x34" => '&#31642;',
 "\x64\x35" => '&#31627;',
 "\x64\x36" => '&#31634;',
 "\x64\x37" => '&#31631;',
 "\x64\x38" => '&#31581;',
 "\x64\x39" => '&#31641;',
 "\x64\x3A" => '&#31691;',
 "\x64\x3B" => '&#31681;',
 "\x64\x3C" => '&#31692;',
 "\x64\x3D" => '&#31695;',
 "\x64\x3E" => '&#31668;',
 "\x64\x3F" => '&#31686;',
 "\x64\x40" => '&#31709;',
 "\x64\x41" => '&#31721;',
 "\x64\x42" => '&#31761;',
 "\x64\x43" => '&#31764;',
 "\x64\x44" => '&#31718;',
 "\x64\x45" => '&#31717;',
 "\x64\x46" => '&#31840;',
 "\x64\x47" => '&#31744;',
 "\x64\x48" => '&#31751;',
 "\x64\x49" => '&#31763;',
 "\x64\x4A" => '&#31731;',
 "\x64\x4B" => '&#31735;',
 "\x64\x4C" => '&#31767;',
 "\x64\x4D" => '&#31757;',
 "\x64\x4E" => '&#31734;',
 "\x64\x4F" => '&#31779;',
 "\x64\x50" => '&#31783;',
 "\x64\x51" => '&#31786;',
 "\x64\x52" => '&#31775;',
 "\x64\x53" => '&#31799;',
 "\x64\x54" => '&#31787;',
 "\x64\x55" => '&#31805;',
 "\x64\x56" => '&#31820;',
 "\x64\x57" => '&#31811;',
 "\x64\x58" => '&#31828;',
 "\x64\x59" => '&#31823;',
 "\x64\x5A" => '&#31808;',
 "\x64\x5B" => '&#31824;',
 "\x64\x5C" => '&#31832;',
 "\x64\x5D" => '&#31839;',
 "\x64\x5E" => '&#31844;',
 "\x64\x5F" => '&#31830;',
 "\x64\x60" => '&#31845;',
 "\x64\x61" => '&#31852;',
 "\x64\x62" => '&#31861;',
 "\x64\x63" => '&#31875;',
 "\x64\x64" => '&#31888;',
 "\x64\x65" => '&#31908;',
 "\x64\x66" => '&#31917;',
 "\x64\x67" => '&#31906;',
 "\x64\x68" => '&#31915;',
 "\x64\x69" => '&#31905;',
 "\x64\x6A" => '&#31912;',
 "\x64\x6B" => '&#31923;',
 "\x64\x6C" => '&#31922;',
 "\x64\x6D" => '&#31921;',
 "\x64\x6E" => '&#31918;',
 "\x64\x6F" => '&#31929;',
 "\x64\x70" => '&#31933;',
 "\x64\x71" => '&#31936;',
 "\x64\x72" => '&#31941;',
 "\x64\x73" => '&#31938;',
 "\x64\x74" => '&#31960;',
 "\x64\x75" => '&#31954;',
 "\x64\x76" => '&#31964;',
 "\x64\x77" => '&#31970;',
 "\x64\x78" => '&#39739;',
 "\x64\x79" => '&#31983;',
 "\x64\x7A" => '&#31986;',
 "\x64\x7B" => '&#31988;',
 "\x64\x7C" => '&#31990;',
 "\x64\x7D" => '&#31994;',
 "\x64\x7E" => '&#32006;',
 "\x65\x21" => '&#32002;',
 "\x65\x22" => '&#32028;',
 "\x65\x23" => '&#32021;',
 "\x65\x24" => '&#32010;',
 "\x65\x25" => '&#32069;',
 "\x65\x26" => '&#32075;',
 "\x65\x27" => '&#32046;',
 "\x65\x28" => '&#32050;',
 "\x65\x29" => '&#32063;',
 "\x65\x2A" => '&#32053;',
 "\x65\x2B" => '&#32070;',
 "\x65\x2C" => '&#32115;',
 "\x65\x2D" => '&#32086;',
 "\x65\x2E" => '&#32078;',
 "\x65\x2F" => '&#32114;',
 "\x65\x30" => '&#32104;',
 "\x65\x31" => '&#32110;',
 "\x65\x32" => '&#32079;',
 "\x65\x33" => '&#32099;',
 "\x65\x34" => '&#32147;',
 "\x65\x35" => '&#32137;',
 "\x65\x36" => '&#32091;',
 "\x65\x37" => '&#32143;',
 "\x65\x38" => '&#32125;',
 "\x65\x39" => '&#32155;',
 "\x65\x3A" => '&#32186;',
 "\x65\x3B" => '&#32174;',
 "\x65\x3C" => '&#32163;',
 "\x65\x3D" => '&#32181;',
 "\x65\x3E" => '&#32199;',
 "\x65\x3F" => '&#32189;',
 "\x65\x40" => '&#32171;',
 "\x65\x41" => '&#32317;',
 "\x65\x42" => '&#32162;',
 "\x65\x43" => '&#32175;',
 "\x65\x44" => '&#32220;',
 "\x65\x45" => '&#32184;',
 "\x65\x46" => '&#32159;',
 "\x65\x47" => '&#32176;',
 "\x65\x48" => '&#32216;',
 "\x65\x49" => '&#32221;',
 "\x65\x4A" => '&#32228;',
 "\x65\x4B" => '&#32222;',
 "\x65\x4C" => '&#32251;',
 "\x65\x4D" => '&#32242;',
 "\x65\x4E" => '&#32225;',
 "\x65\x4F" => '&#32261;',
 "\x65\x50" => '&#32266;',
 "\x65\x51" => '&#32291;',
 "\x65\x52" => '&#32289;',
 "\x65\x53" => '&#32274;',
 "\x65\x54" => '&#32305;',
 "\x65\x55" => '&#32287;',
 "\x65\x56" => '&#32265;',
 "\x65\x57" => '&#32267;',
 "\x65\x58" => '&#32290;',
 "\x65\x59" => '&#32326;',
 "\x65\x5A" => '&#32358;',
 "\x65\x5B" => '&#32315;',
 "\x65\x5C" => '&#32309;',
 "\x65\x5D" => '&#32313;',
 "\x65\x5E" => '&#32323;',
 "\x65\x5F" => '&#32311;',
 "\x65\x60" => '&#32306;',
 "\x65\x61" => '&#32314;',
 "\x65\x62" => '&#32359;',
 "\x65\x63" => '&#32349;',
 "\x65\x64" => '&#32342;',
 "\x65\x65" => '&#32350;',
 "\x65\x66" => '&#32345;',
 "\x65\x67" => '&#32346;',
 "\x65\x68" => '&#32377;',
 "\x65\x69" => '&#32362;',
 "\x65\x6A" => '&#32361;',
 "\x65\x6B" => '&#32380;',
 "\x65\x6C" => '&#32379;',
 "\x65\x6D" => '&#32387;',
 "\x65\x6E" => '&#32213;',
 "\x65\x6F" => '&#32381;',
 "\x65\x70" => '&#36782;',
 "\x65\x71" => '&#32383;',
 "\x65\x72" => '&#32392;',
 "\x65\x73" => '&#32393;',
 "\x65\x74" => '&#32396;',
 "\x65\x75" => '&#32402;',
 "\x65\x76" => '&#32400;',
 "\x65\x77" => '&#32403;',
 "\x65\x78" => '&#32404;',
 "\x65\x79" => '&#32406;',
 "\x65\x7A" => '&#32398;',
 "\x65\x7B" => '&#32411;',
 "\x65\x7C" => '&#32412;',
 "\x65\x7D" => '&#32568;',
 "\x65\x7E" => '&#32570;',
 "\x66\x21" => '&#32581;',
 "\x66\x22" => '&#32588;',
 "\x66\x23" => '&#32589;',
 "\x66\x24" => '&#32590;',
 "\x66\x25" => '&#32592;',
 "\x66\x26" => '&#32593;',
 "\x66\x27" => '&#32597;',
 "\x66\x28" => '&#32596;',
 "\x66\x29" => '&#32600;',
 "\x66\x2A" => '&#32607;',
 "\x66\x2B" => '&#32608;',
 "\x66\x2C" => '&#32616;',
 "\x66\x2D" => '&#32617;',
 "\x66\x2E" => '&#32615;',
 "\x66\x2F" => '&#32632;',
 "\x66\x30" => '&#32642;',
 "\x66\x31" => '&#32646;',
 "\x66\x32" => '&#32643;',
 "\x66\x33" => '&#32648;',
 "\x66\x34" => '&#32647;',
 "\x66\x35" => '&#32652;',
 "\x66\x36" => '&#32660;',
 "\x66\x37" => '&#32670;',
 "\x66\x38" => '&#32669;',
 "\x66\x39" => '&#32666;',
 "\x66\x3A" => '&#32675;',
 "\x66\x3B" => '&#32687;',
 "\x66\x3C" => '&#32690;',
 "\x66\x3D" => '&#32697;',
 "\x66\x3E" => '&#32686;',
 "\x66\x3F" => '&#32694;',
 "\x66\x40" => '&#32696;',
 "\x66\x41" => '&#35697;',
 "\x66\x42" => '&#32709;',
 "\x66\x43" => '&#32710;',
 "\x66\x44" => '&#32714;',
 "\x66\x45" => '&#32725;',
 "\x66\x46" => '&#32724;',
 "\x66\x47" => '&#32737;',
 "\x66\x48" => '&#32742;',
 "\x66\x49" => '&#32745;',
 "\x66\x4A" => '&#32755;',
 "\x66\x4B" => '&#32761;',
 "\x66\x4C" => '&#39132;',
 "\x66\x4D" => '&#32774;',
 "\x66\x4E" => '&#32772;',
 "\x66\x4F" => '&#32779;',
 "\x66\x50" => '&#32786;',
 "\x66\x51" => '&#32792;',
 "\x66\x52" => '&#32793;',
 "\x66\x53" => '&#32796;',
 "\x66\x54" => '&#32801;',
 "\x66\x55" => '&#32808;',
 "\x66\x56" => '&#32831;',
 "\x66\x57" => '&#32827;',
 "\x66\x58" => '&#32842;',
 "\x66\x59" => '&#32838;',
 "\x66\x5A" => '&#32850;',
 "\x66\x5B" => '&#32856;',
 "\x66\x5C" => '&#32858;',
 "\x66\x5D" => '&#32863;',
 "\x66\x5E" => '&#32866;',
 "\x66\x5F" => '&#32872;',
 "\x66\x60" => '&#32883;',
 "\x66\x61" => '&#32882;',
 "\x66\x62" => '&#32880;',
 "\x66\x63" => '&#32886;',
 "\x66\x64" => '&#32889;',
 "\x66\x65" => '&#32893;',
 "\x66\x66" => '&#32895;',
 "\x66\x67" => '&#32900;',
 "\x66\x68" => '&#32902;',
 "\x66\x69" => '&#32901;',
 "\x66\x6A" => '&#32923;',
 "\x66\x6B" => '&#32915;',
 "\x66\x6C" => '&#32922;',
 "\x66\x6D" => '&#32941;',
 "\x66\x6E" => '&#20880;',
 "\x66\x6F" => '&#32940;',
 "\x66\x70" => '&#32987;',
 "\x66\x71" => '&#32997;',
 "\x66\x72" => '&#32985;',
 "\x66\x73" => '&#32989;',
 "\x66\x74" => '&#32964;',
 "\x66\x75" => '&#32986;',
 "\x66\x76" => '&#32982;',
 "\x66\x77" => '&#33033;',
 "\x66\x78" => '&#33007;',
 "\x66\x79" => '&#33009;',
 "\x66\x7A" => '&#33051;',
 "\x66\x7B" => '&#33065;',
 "\x66\x7C" => '&#33059;',
 "\x66\x7D" => '&#33071;',
 "\x66\x7E" => '&#33099;',
 "\x67\x21" => '&#38539;',
 "\x67\x22" => '&#33094;',
 "\x67\x23" => '&#33086;',
 "\x67\x24" => '&#33107;',
 "\x67\x25" => '&#33105;',
 "\x67\x26" => '&#33020;',
 "\x67\x27" => '&#33137;',
 "\x67\x28" => '&#33134;',
 "\x67\x29" => '&#33125;',
 "\x67\x2A" => '&#33126;',
 "\x67\x2B" => '&#33140;',
 "\x67\x2C" => '&#33155;',
 "\x67\x2D" => '&#33160;',
 "\x67\x2E" => '&#33162;',
 "\x67\x2F" => '&#33152;',
 "\x67\x30" => '&#33154;',
 "\x67\x31" => '&#33184;',
 "\x67\x32" => '&#33173;',
 "\x67\x33" => '&#33188;',
 "\x67\x34" => '&#33187;',
 "\x67\x35" => '&#33119;',
 "\x67\x36" => '&#33171;',
 "\x67\x37" => '&#33193;',
 "\x67\x38" => '&#33200;',
 "\x67\x39" => '&#33205;',
 "\x67\x3A" => '&#33214;',
 "\x67\x3B" => '&#33208;',
 "\x67\x3C" => '&#33213;',
 "\x67\x3D" => '&#33216;',
 "\x67\x3E" => '&#33218;',
 "\x67\x3F" => '&#33210;',
 "\x67\x40" => '&#33225;',
 "\x67\x41" => '&#33229;',
 "\x67\x42" => '&#33233;',
 "\x67\x43" => '&#33241;',
 "\x67\x44" => '&#33240;',
 "\x67\x45" => '&#33224;',
 "\x67\x46" => '&#33242;',
 "\x67\x47" => '&#33247;',
 "\x67\x48" => '&#33248;',
 "\x67\x49" => '&#33255;',
 "\x67\x4A" => '&#33274;',
 "\x67\x4B" => '&#33275;',
 "\x67\x4C" => '&#33278;',
 "\x67\x4D" => '&#33281;',
 "\x67\x4E" => '&#33282;',
 "\x67\x4F" => '&#33285;',
 "\x67\x50" => '&#33287;',
 "\x67\x51" => '&#33290;',
 "\x67\x52" => '&#33293;',
 "\x67\x53" => '&#33296;',
 "\x67\x54" => '&#33302;',
 "\x67\x55" => '&#33321;',
 "\x67\x56" => '&#33323;',
 "\x67\x57" => '&#33336;',
 "\x67\x58" => '&#33331;',
 "\x67\x59" => '&#33344;',
 "\x67\x5A" => '&#33369;',
 "\x67\x5B" => '&#33368;',
 "\x67\x5C" => '&#33373;',
 "\x67\x5D" => '&#33370;',
 "\x67\x5E" => '&#33375;',
 "\x67\x5F" => '&#33380;',
 "\x67\x60" => '&#33378;',
 "\x67\x61" => '&#33384;',
 "\x67\x62" => '&#33386;',
 "\x67\x63" => '&#33387;',
 "\x67\x64" => '&#33326;',
 "\x67\x65" => '&#33393;',
 "\x67\x66" => '&#33399;',
 "\x67\x67" => '&#33400;',
 "\x67\x68" => '&#33406;',
 "\x67\x69" => '&#33421;',
 "\x67\x6A" => '&#33426;',
 "\x67\x6B" => '&#33451;',
 "\x67\x6C" => '&#33439;',
 "\x67\x6D" => '&#33467;',
 "\x67\x6E" => '&#33452;',
 "\x67\x6F" => '&#33505;',
 "\x67\x70" => '&#33507;',
 "\x67\x71" => '&#33503;',
 "\x67\x72" => '&#33490;',
 "\x67\x73" => '&#33524;',
 "\x67\x74" => '&#33523;',
 "\x67\x75" => '&#33530;',
 "\x67\x76" => '&#33683;',
 "\x67\x77" => '&#33539;',
 "\x67\x78" => '&#33531;',
 "\x67\x79" => '&#33529;',
 "\x67\x7A" => '&#33502;',
 "\x67\x7B" => '&#33542;',
 "\x67\x7C" => '&#33500;',
 "\x67\x7D" => '&#33545;',
 "\x67\x7E" => '&#33497;',
 "\x68\x21" => '&#33589;',
 "\x68\x22" => '&#33588;',
 "\x68\x23" => '&#33558;',
 "\x68\x24" => '&#33586;',
 "\x68\x25" => '&#33585;',
 "\x68\x26" => '&#33600;',
 "\x68\x27" => '&#33593;',
 "\x68\x28" => '&#33616;',
 "\x68\x29" => '&#33605;',
 "\x68\x2A" => '&#33583;',
 "\x68\x2B" => '&#33579;',
 "\x68\x2C" => '&#33559;',
 "\x68\x2D" => '&#33560;',
 "\x68\x2E" => '&#33669;',
 "\x68\x2F" => '&#33690;',
 "\x68\x30" => '&#33706;',
 "\x68\x31" => '&#33695;',
 "\x68\x32" => '&#33698;',
 "\x68\x33" => '&#33686;',
 "\x68\x34" => '&#33571;',
 "\x68\x35" => '&#33678;',
 "\x68\x36" => '&#33671;',
 "\x68\x37" => '&#33674;',
 "\x68\x38" => '&#33660;',
 "\x68\x39" => '&#33717;',
 "\x68\x3A" => '&#33651;',
 "\x68\x3B" => '&#33653;',
 "\x68\x3C" => '&#33696;',
 "\x68\x3D" => '&#33673;',
 "\x68\x3E" => '&#33704;',
 "\x68\x3F" => '&#33780;',
 "\x68\x40" => '&#33811;',
 "\x68\x41" => '&#33771;',
 "\x68\x42" => '&#33742;',
 "\x68\x43" => '&#33789;',
 "\x68\x44" => '&#33795;',
 "\x68\x45" => '&#33752;',
 "\x68\x46" => '&#33803;',
 "\x68\x47" => '&#33729;',
 "\x68\x48" => '&#33783;',
 "\x68\x49" => '&#33799;',
 "\x68\x4A" => '&#33760;',
 "\x68\x4B" => '&#33778;',
 "\x68\x4C" => '&#33805;',
 "\x68\x4D" => '&#33826;',
 "\x68\x4E" => '&#33824;',
 "\x68\x4F" => '&#33725;',
 "\x68\x50" => '&#33848;',
 "\x68\x51" => '&#34054;',
 "\x68\x52" => '&#33787;',
 "\x68\x53" => '&#33901;',
 "\x68\x54" => '&#33834;',
 "\x68\x55" => '&#33852;',
 "\x68\x56" => '&#34138;',
 "\x68\x57" => '&#33924;',
 "\x68\x58" => '&#33911;',
 "\x68\x59" => '&#33899;',
 "\x68\x5A" => '&#33965;',
 "\x68\x5B" => '&#33902;',
 "\x68\x5C" => '&#33922;',
 "\x68\x5D" => '&#33897;',
 "\x68\x5E" => '&#33862;',
 "\x68\x5F" => '&#33836;',
 "\x68\x60" => '&#33903;',
 "\x68\x61" => '&#33913;',
 "\x68\x62" => '&#33845;',
 "\x68\x63" => '&#33994;',
 "\x68\x64" => '&#33890;',
 "\x68\x65" => '&#33977;',
 "\x68\x66" => '&#33983;',
 "\x68\x67" => '&#33951;',
 "\x68\x68" => '&#34009;',
 "\x68\x69" => '&#33997;',
 "\x68\x6A" => '&#33979;',
 "\x68\x6B" => '&#34010;',
 "\x68\x6C" => '&#34000;',
 "\x68\x6D" => '&#33985;',
 "\x68\x6E" => '&#33990;',
 "\x68\x6F" => '&#34006;',
 "\x68\x70" => '&#33953;',
 "\x68\x71" => '&#34081;',
 "\x68\x72" => '&#34047;',
 "\x68\x73" => '&#34036;',
 "\x68\x74" => '&#34071;',
 "\x68\x75" => '&#34072;',
 "\x68\x76" => '&#34092;',
 "\x68\x77" => '&#34079;',
 "\x68\x78" => '&#34069;',
 "\x68\x79" => '&#34068;',
 "\x68\x7A" => '&#34044;',
 "\x68\x7B" => '&#34112;',
 "\x68\x7C" => '&#34147;',
 "\x68\x7D" => '&#34136;',
 "\x68\x7E" => '&#34120;',
 "\x69\x21" => '&#34113;',
 "\x69\x22" => '&#34306;',
 "\x69\x23" => '&#34123;',
 "\x69\x24" => '&#34133;',
 "\x69\x25" => '&#34176;',
 "\x69\x26" => '&#34212;',
 "\x69\x27" => '&#34184;',
 "\x69\x28" => '&#34193;',
 "\x69\x29" => '&#34186;',
 "\x69\x2A" => '&#34216;',
 "\x69\x2B" => '&#34157;',
 "\x69\x2C" => '&#34196;',
 "\x69\x2D" => '&#34203;',
 "\x69\x2E" => '&#34282;',
 "\x69\x2F" => '&#34183;',
 "\x69\x30" => '&#34204;',
 "\x69\x31" => '&#34167;',
 "\x69\x32" => '&#34174;',
 "\x69\x33" => '&#34192;',
 "\x69\x34" => '&#34249;',
 "\x69\x35" => '&#34234;',
 "\x69\x36" => '&#34255;',
 "\x69\x37" => '&#34233;',
 "\x69\x38" => '&#34256;',
 "\x69\x39" => '&#34261;',
 "\x69\x3A" => '&#34269;',
 "\x69\x3B" => '&#34277;',
 "\x69\x3C" => '&#34268;',
 "\x69\x3D" => '&#34297;',
 "\x69\x3E" => '&#34314;',
 "\x69\x3F" => '&#34323;',
 "\x69\x40" => '&#34315;',
 "\x69\x41" => '&#34302;',
 "\x69\x42" => '&#34298;',
 "\x69\x43" => '&#34310;',
 "\x69\x44" => '&#34338;',
 "\x69\x45" => '&#34330;',
 "\x69\x46" => '&#34352;',
 "\x69\x47" => '&#34367;',
 "\x69\x48" => '&#34381;',
 "\x69\x49" => '&#20053;',
 "\x69\x4A" => '&#34388;',
 "\x69\x4B" => '&#34399;',
 "\x69\x4C" => '&#34407;',
 "\x69\x4D" => '&#34417;',
 "\x69\x4E" => '&#34451;',
 "\x69\x4F" => '&#34467;',
 "\x69\x50" => '&#34473;',
 "\x69\x51" => '&#34474;',
 "\x69\x52" => '&#34443;',
 "\x69\x53" => '&#34444;',
 "\x69\x54" => '&#34486;',
 "\x69\x55" => '&#34479;',
 "\x69\x56" => '&#34500;',
 "\x69\x57" => '&#34502;',
 "\x69\x58" => '&#34480;',
 "\x69\x59" => '&#34505;',
 "\x69\x5A" => '&#34851;',
 "\x69\x5B" => '&#34475;',
 "\x69\x5C" => '&#34516;',
 "\x69\x5D" => '&#34526;',
 "\x69\x5E" => '&#34537;',
 "\x69\x5F" => '&#34540;',
 "\x69\x60" => '&#34527;',
 "\x69\x61" => '&#34523;',
 "\x69\x62" => '&#34543;',
 "\x69\x63" => '&#34578;',
 "\x69\x64" => '&#34566;',
 "\x69\x65" => '&#34568;',
 "\x69\x66" => '&#34560;',
 "\x69\x67" => '&#34563;',
 "\x69\x68" => '&#34555;',
 "\x69\x69" => '&#34577;',
 "\x69\x6A" => '&#34569;',
 "\x69\x6B" => '&#34573;',
 "\x69\x6C" => '&#34553;',
 "\x69\x6D" => '&#34570;',
 "\x69\x6E" => '&#34612;',
 "\x69\x6F" => '&#34623;',
 "\x69\x70" => '&#34615;',
 "\x69\x71" => '&#34619;',
 "\x69\x72" => '&#34597;',
 "\x69\x73" => '&#34601;',
 "\x69\x74" => '&#34586;',
 "\x69\x75" => '&#34656;',
 "\x69\x76" => '&#34655;',
 "\x69\x77" => '&#34680;',
 "\x69\x78" => '&#34636;',
 "\x69\x79" => '&#34638;',
 "\x69\x7A" => '&#34676;',
 "\x69\x7B" => '&#34647;',
 "\x69\x7C" => '&#34664;',
 "\x69\x7D" => '&#34670;',
 "\x69\x7E" => '&#34649;',
 "\x6A\x21" => '&#34643;',
 "\x6A\x22" => '&#34659;',
 "\x6A\x23" => '&#34666;',
 "\x6A\x24" => '&#34821;',
 "\x6A\x25" => '&#34722;',
 "\x6A\x26" => '&#34719;',
 "\x6A\x27" => '&#34690;',
 "\x6A\x28" => '&#34735;',
 "\x6A\x29" => '&#34763;',
 "\x6A\x2A" => '&#34749;',
 "\x6A\x2B" => '&#34752;',
 "\x6A\x2C" => '&#34768;',
 "\x6A\x2D" => '&#38614;',
 "\x6A\x2E" => '&#34731;',
 "\x6A\x2F" => '&#34756;',
 "\x6A\x30" => '&#34739;',
 "\x6A\x31" => '&#34759;',
 "\x6A\x32" => '&#34758;',
 "\x6A\x33" => '&#34747;',
 "\x6A\x34" => '&#34799;',
 "\x6A\x35" => '&#34802;',
 "\x6A\x36" => '&#34784;',
 "\x6A\x37" => '&#34831;',
 "\x6A\x38" => '&#34829;',
 "\x6A\x39" => '&#34814;',
 "\x6A\x3A" => '&#34806;',
 "\x6A\x3B" => '&#34807;',
 "\x6A\x3C" => '&#34830;',
 "\x6A\x3D" => '&#34770;',
 "\x6A\x3E" => '&#34833;',
 "\x6A\x3F" => '&#34838;',
 "\x6A\x40" => '&#34837;',
 "\x6A\x41" => '&#34850;',
 "\x6A\x42" => '&#34849;',
 "\x6A\x43" => '&#34865;',
 "\x6A\x44" => '&#34870;',
 "\x6A\x45" => '&#34873;',
 "\x6A\x46" => '&#34855;',
 "\x6A\x47" => '&#34875;',
 "\x6A\x48" => '&#34884;',
 "\x6A\x49" => '&#34882;',
 "\x6A\x4A" => '&#34898;',
 "\x6A\x4B" => '&#34905;',
 "\x6A\x4C" => '&#34910;',
 "\x6A\x4D" => '&#34914;',
 "\x6A\x4E" => '&#34923;',
 "\x6A\x4F" => '&#34945;',
 "\x6A\x50" => '&#34942;',
 "\x6A\x51" => '&#34974;',
 "\x6A\x52" => '&#34933;',
 "\x6A\x53" => '&#34941;',
 "\x6A\x54" => '&#34997;',
 "\x6A\x55" => '&#34930;',
 "\x6A\x56" => '&#34946;',
 "\x6A\x57" => '&#34967;',
 "\x6A\x58" => '&#34962;',
 "\x6A\x59" => '&#34990;',
 "\x6A\x5A" => '&#34969;',
 "\x6A\x5B" => '&#34978;',
 "\x6A\x5C" => '&#34957;',
 "\x6A\x5D" => '&#34980;',
 "\x6A\x5E" => '&#34992;',
 "\x6A\x5F" => '&#35007;',
 "\x6A\x60" => '&#34993;',
 "\x6A\x61" => '&#35011;',
 "\x6A\x62" => '&#35012;',
 "\x6A\x63" => '&#35028;',
 "\x6A\x64" => '&#35032;',
 "\x6A\x65" => '&#35033;',
 "\x6A\x66" => '&#35037;',
 "\x6A\x67" => '&#35065;',
 "\x6A\x68" => '&#35074;',
 "\x6A\x69" => '&#35068;',
 "\x6A\x6A" => '&#35060;',
 "\x6A\x6B" => '&#35048;',
 "\x6A\x6C" => '&#35058;',
 "\x6A\x6D" => '&#35076;',
 "\x6A\x6E" => '&#35084;',
 "\x6A\x6F" => '&#35082;',
 "\x6A\x70" => '&#35091;',
 "\x6A\x71" => '&#35139;',
 "\x6A\x72" => '&#35102;',
 "\x6A\x73" => '&#35109;',
 "\x6A\x74" => '&#35114;',
 "\x6A\x75" => '&#35115;',
 "\x6A\x76" => '&#35137;',
 "\x6A\x77" => '&#35140;',
 "\x6A\x78" => '&#35131;',
 "\x6A\x79" => '&#35126;',
 "\x6A\x7A" => '&#35128;',
 "\x6A\x7B" => '&#35148;',
 "\x6A\x7C" => '&#35101;',
 "\x6A\x7D" => '&#35168;',
 "\x6A\x7E" => '&#35166;',
 "\x6B\x21" => '&#35174;',
 "\x6B\x22" => '&#35172;',
 "\x6B\x23" => '&#35181;',
 "\x6B\x24" => '&#35178;',
 "\x6B\x25" => '&#35183;',
 "\x6B\x26" => '&#35188;',
 "\x6B\x27" => '&#35191;',
 "\x6B\x28" => '&#35198;',
 "\x6B\x29" => '&#35203;',
 "\x6B\x2A" => '&#35208;',
 "\x6B\x2B" => '&#35210;',
 "\x6B\x2C" => '&#35219;',
 "\x6B\x2D" => '&#35224;',
 "\x6B\x2E" => '&#35233;',
 "\x6B\x2F" => '&#35241;',
 "\x6B\x30" => '&#35238;',
 "\x6B\x31" => '&#35244;',
 "\x6B\x32" => '&#35247;',
 "\x6B\x33" => '&#35250;',
 "\x6B\x34" => '&#35258;',
 "\x6B\x35" => '&#35261;',
 "\x6B\x36" => '&#35263;',
 "\x6B\x37" => '&#35264;',
 "\x6B\x38" => '&#35290;',
 "\x6B\x39" => '&#35292;',
 "\x6B\x3A" => '&#35293;',
 "\x6B\x3B" => '&#35303;',
 "\x6B\x3C" => '&#35316;',
 "\x6B\x3D" => '&#35320;',
 "\x6B\x3E" => '&#35331;',
 "\x6B\x3F" => '&#35350;',
 "\x6B\x40" => '&#35344;',
 "\x6B\x41" => '&#35340;',
 "\x6B\x42" => '&#35355;',
 "\x6B\x43" => '&#35357;',
 "\x6B\x44" => '&#35365;',
 "\x6B\x45" => '&#35382;',
 "\x6B\x46" => '&#35393;',
 "\x6B\x47" => '&#35419;',
 "\x6B\x48" => '&#35410;',
 "\x6B\x49" => '&#35398;',
 "\x6B\x4A" => '&#35400;',
 "\x6B\x4B" => '&#35452;',
 "\x6B\x4C" => '&#35437;',
 "\x6B\x4D" => '&#35436;',
 "\x6B\x4E" => '&#35426;',
 "\x6B\x4F" => '&#35461;',
 "\x6B\x50" => '&#35458;',
 "\x6B\x51" => '&#35460;',
 "\x6B\x52" => '&#35496;',
 "\x6B\x53" => '&#35489;',
 "\x6B\x54" => '&#35473;',
 "\x6B\x55" => '&#35493;',
 "\x6B\x56" => '&#35494;',
 "\x6B\x57" => '&#35482;',
 "\x6B\x58" => '&#35491;',
 "\x6B\x59" => '&#35524;',
 "\x6B\x5A" => '&#35533;',
 "\x6B\x5B" => '&#35522;',
 "\x6B\x5C" => '&#35546;',
 "\x6B\x5D" => '&#35563;',
 "\x6B\x5E" => '&#35571;',
 "\x6B\x5F" => '&#35559;',
 "\x6B\x60" => '&#35556;',
 "\x6B\x61" => '&#35569;',
 "\x6B\x62" => '&#35604;',
 "\x6B\x63" => '&#35552;',
 "\x6B\x64" => '&#35554;',
 "\x6B\x65" => '&#35575;',
 "\x6B\x66" => '&#35550;',
 "\x6B\x67" => '&#35547;',
 "\x6B\x68" => '&#35596;',
 "\x6B\x69" => '&#35591;',
 "\x6B\x6A" => '&#35610;',
 "\x6B\x6B" => '&#35553;',
 "\x6B\x6C" => '&#35606;',
 "\x6B\x6D" => '&#35600;',
 "\x6B\x6E" => '&#35607;',
 "\x6B\x6F" => '&#35616;',
 "\x6B\x70" => '&#35635;',
 "\x6B\x71" => '&#38827;',
 "\x6B\x72" => '&#35622;',
 "\x6B\x73" => '&#35627;',
 "\x6B\x74" => '&#35646;',
 "\x6B\x75" => '&#35624;',
 "\x6B\x76" => '&#35649;',
 "\x6B\x77" => '&#35660;',
 "\x6B\x78" => '&#35663;',
 "\x6B\x79" => '&#35662;',
 "\x6B\x7A" => '&#35657;',
 "\x6B\x7B" => '&#35670;',
 "\x6B\x7C" => '&#35675;',
 "\x6B\x7D" => '&#35674;',
 "\x6B\x7E" => '&#35691;',
 "\x6C\x21" => '&#35679;',
 "\x6C\x22" => '&#35692;',
 "\x6C\x23" => '&#35695;',
 "\x6C\x24" => '&#35700;',
 "\x6C\x25" => '&#35709;',
 "\x6C\x26" => '&#35712;',
 "\x6C\x27" => '&#35724;',
 "\x6C\x28" => '&#35726;',
 "\x6C\x29" => '&#35730;',
 "\x6C\x2A" => '&#35731;',
 "\x6C\x2B" => '&#35734;',
 "\x6C\x2C" => '&#35737;',
 "\x6C\x2D" => '&#35738;',
 "\x6C\x2E" => '&#35898;',
 "\x6C\x2F" => '&#35905;',
 "\x6C\x30" => '&#35903;',
 "\x6C\x31" => '&#35912;',
 "\x6C\x32" => '&#35916;',
 "\x6C\x33" => '&#35918;',
 "\x6C\x34" => '&#35920;',
 "\x6C\x35" => '&#35925;',
 "\x6C\x36" => '&#35938;',
 "\x6C\x37" => '&#35948;',
 "\x6C\x38" => '&#35960;',
 "\x6C\x39" => '&#35962;',
 "\x6C\x3A" => '&#35970;',
 "\x6C\x3B" => '&#35977;',
 "\x6C\x3C" => '&#35973;',
 "\x6C\x3D" => '&#35978;',
 "\x6C\x3E" => '&#35981;',
 "\x6C\x3F" => '&#35982;',
 "\x6C\x40" => '&#35988;',
 "\x6C\x41" => '&#35964;',
 "\x6C\x42" => '&#35992;',
 "\x6C\x43" => '&#25117;',
 "\x6C\x44" => '&#36013;',
 "\x6C\x45" => '&#36010;',
 "\x6C\x46" => '&#36029;',
 "\x6C\x47" => '&#36018;',
 "\x6C\x48" => '&#36019;',
 "\x6C\x49" => '&#36014;',
 "\x6C\x4A" => '&#36022;',
 "\x6C\x4B" => '&#36040;',
 "\x6C\x4C" => '&#36033;',
 "\x6C\x4D" => '&#36068;',
 "\x6C\x4E" => '&#36067;',
 "\x6C\x4F" => '&#36058;',
 "\x6C\x50" => '&#36093;',
 "\x6C\x51" => '&#36090;',
 "\x6C\x52" => '&#36091;',
 "\x6C\x53" => '&#36100;',
 "\x6C\x54" => '&#36101;',
 "\x6C\x55" => '&#36106;',
 "\x6C\x56" => '&#36103;',
 "\x6C\x57" => '&#36111;',
 "\x6C\x58" => '&#36109;',
 "\x6C\x59" => '&#36112;',
 "\x6C\x5A" => '&#40782;',
 "\x6C\x5B" => '&#36115;',
 "\x6C\x5C" => '&#36045;',
 "\x6C\x5D" => '&#36116;',
 "\x6C\x5E" => '&#36118;',
 "\x6C\x5F" => '&#36199;',
 "\x6C\x60" => '&#36205;',
 "\x6C\x61" => '&#36209;',
 "\x6C\x62" => '&#36211;',
 "\x6C\x63" => '&#36225;',
 "\x6C\x64" => '&#36249;',
 "\x6C\x65" => '&#36290;',
 "\x6C\x66" => '&#36286;',
 "\x6C\x67" => '&#36282;',
 "\x6C\x68" => '&#36303;',
 "\x6C\x69" => '&#36314;',
 "\x6C\x6A" => '&#36310;',
 "\x6C\x6B" => '&#36300;',
 "\x6C\x6C" => '&#36315;',
 "\x6C\x6D" => '&#36299;',
 "\x6C\x6E" => '&#36330;',
 "\x6C\x6F" => '&#36331;',
 "\x6C\x70" => '&#36319;',
 "\x6C\x71" => '&#36323;',
 "\x6C\x72" => '&#36348;',
 "\x6C\x73" => '&#36360;',
 "\x6C\x74" => '&#36361;',
 "\x6C\x75" => '&#36351;',
 "\x6C\x76" => '&#36381;',
 "\x6C\x77" => '&#36382;',
 "\x6C\x78" => '&#36368;',
 "\x6C\x79" => '&#36383;',
 "\x6C\x7A" => '&#36418;',
 "\x6C\x7B" => '&#36405;',
 "\x6C\x7C" => '&#36400;',
 "\x6C\x7D" => '&#36404;',
 "\x6C\x7E" => '&#36426;',
 "\x6D\x21" => '&#36423;',
 "\x6D\x22" => '&#36425;',
 "\x6D\x23" => '&#36428;',
 "\x6D\x24" => '&#36432;',
 "\x6D\x25" => '&#36424;',
 "\x6D\x26" => '&#36441;',
 "\x6D\x27" => '&#36452;',
 "\x6D\x28" => '&#36448;',
 "\x6D\x29" => '&#36394;',
 "\x6D\x2A" => '&#36451;',
 "\x6D\x2B" => '&#36437;',
 "\x6D\x2C" => '&#36470;',
 "\x6D\x2D" => '&#36466;',
 "\x6D\x2E" => '&#36476;',
 "\x6D\x2F" => '&#36481;',
 "\x6D\x30" => '&#36487;',
 "\x6D\x31" => '&#36485;',
 "\x6D\x32" => '&#36484;',
 "\x6D\x33" => '&#36491;',
 "\x6D\x34" => '&#36490;',
 "\x6D\x35" => '&#36499;',
 "\x6D\x36" => '&#36497;',
 "\x6D\x37" => '&#36500;',
 "\x6D\x38" => '&#36505;',
 "\x6D\x39" => '&#36522;',
 "\x6D\x3A" => '&#36513;',
 "\x6D\x3B" => '&#36524;',
 "\x6D\x3C" => '&#36528;',
 "\x6D\x3D" => '&#36550;',
 "\x6D\x3E" => '&#36529;',
 "\x6D\x3F" => '&#36542;',
 "\x6D\x40" => '&#36549;',
 "\x6D\x41" => '&#36552;',
 "\x6D\x42" => '&#36555;',
 "\x6D\x43" => '&#36571;',
 "\x6D\x44" => '&#36579;',
 "\x6D\x45" => '&#36604;',
 "\x6D\x46" => '&#36603;',
 "\x6D\x47" => '&#36587;',
 "\x6D\x48" => '&#36606;',
 "\x6D\x49" => '&#36618;',
 "\x6D\x4A" => '&#36613;',
 "\x6D\x4B" => '&#36629;',
 "\x6D\x4C" => '&#36626;',
 "\x6D\x4D" => '&#36633;',
 "\x6D\x4E" => '&#36627;',
 "\x6D\x4F" => '&#36636;',
 "\x6D\x50" => '&#36639;',
 "\x6D\x51" => '&#36635;',
 "\x6D\x52" => '&#36620;',
 "\x6D\x53" => '&#36646;',
 "\x6D\x54" => '&#36659;',
 "\x6D\x55" => '&#36667;',
 "\x6D\x56" => '&#36665;',
 "\x6D\x57" => '&#36677;',
 "\x6D\x58" => '&#36674;',
 "\x6D\x59" => '&#36670;',
 "\x6D\x5A" => '&#36684;',
 "\x6D\x5B" => '&#36681;',
 "\x6D\x5C" => '&#36678;',
 "\x6D\x5D" => '&#36686;',
 "\x6D\x5E" => '&#36695;',
 "\x6D\x5F" => '&#36700;',
 "\x6D\x60" => '&#36706;',
 "\x6D\x61" => '&#36707;',
 "\x6D\x62" => '&#36708;',
 "\x6D\x63" => '&#36764;',
 "\x6D\x64" => '&#36767;',
 "\x6D\x65" => '&#36771;',
 "\x6D\x66" => '&#36781;',
 "\x6D\x67" => '&#36783;',
 "\x6D\x68" => '&#36791;',
 "\x6D\x69" => '&#36826;',
 "\x6D\x6A" => '&#36837;',
 "\x6D\x6B" => '&#36834;',
 "\x6D\x6C" => '&#36842;',
 "\x6D\x6D" => '&#36847;',
 "\x6D\x6E" => '&#36999;',
 "\x6D\x6F" => '&#36852;',
 "\x6D\x70" => '&#36869;',
 "\x6D\x71" => '&#36857;',
 "\x6D\x72" => '&#36858;',
 "\x6D\x73" => '&#36881;',
 "\x6D\x74" => '&#36885;',
 "\x6D\x75" => '&#36897;',
 "\x6D\x76" => '&#36877;',
 "\x6D\x77" => '&#36894;',
 "\x6D\x78" => '&#36886;',
 "\x6D\x79" => '&#36875;',
 "\x6D\x7A" => '&#36903;',
 "\x6D\x7B" => '&#36918;',
 "\x6D\x7C" => '&#36917;',
 "\x6D\x7D" => '&#36921;',
 "\x6D\x7E" => '&#36856;',
 "\x6E\x21" => '&#36943;',
 "\x6E\x22" => '&#36944;',
 "\x6E\x23" => '&#36945;',
 "\x6E\x24" => '&#36946;',
 "\x6E\x25" => '&#36878;',
 "\x6E\x26" => '&#36937;',
 "\x6E\x27" => '&#36926;',
 "\x6E\x28" => '&#36950;',
 "\x6E\x29" => '&#36952;',
 "\x6E\x2A" => '&#36958;',
 "\x6E\x2B" => '&#36968;',
 "\x6E\x2C" => '&#36975;',
 "\x6E\x2D" => '&#36982;',
 "\x6E\x2E" => '&#38568;',
 "\x6E\x2F" => '&#36978;',
 "\x6E\x30" => '&#36994;',
 "\x6E\x31" => '&#36989;',
 "\x6E\x32" => '&#36993;',
 "\x6E\x33" => '&#36992;',
 "\x6E\x34" => '&#37002;',
 "\x6E\x35" => '&#37001;',
 "\x6E\x36" => '&#37007;',
 "\x6E\x37" => '&#37032;',
 "\x6E\x38" => '&#37039;',
 "\x6E\x39" => '&#37041;',
 "\x6E\x3A" => '&#37045;',
 "\x6E\x3B" => '&#37090;',
 "\x6E\x3C" => '&#37092;',
 "\x6E\x3D" => '&#25160;',
 "\x6E\x3E" => '&#37083;',
 "\x6E\x3F" => '&#37122;',
 "\x6E\x40" => '&#37138;',
 "\x6E\x41" => '&#37145;',
 "\x6E\x42" => '&#37170;',
 "\x6E\x43" => '&#37168;',
 "\x6E\x44" => '&#37194;',
 "\x6E\x45" => '&#37206;',
 "\x6E\x46" => '&#37208;',
 "\x6E\x47" => '&#37219;',
 "\x6E\x48" => '&#37221;',
 "\x6E\x49" => '&#37225;',
 "\x6E\x4A" => '&#37235;',
 "\x6E\x4B" => '&#37234;',
 "\x6E\x4C" => '&#37259;',
 "\x6E\x4D" => '&#37257;',
 "\x6E\x4E" => '&#37250;',
 "\x6E\x4F" => '&#37282;',
 "\x6E\x50" => '&#37291;',
 "\x6E\x51" => '&#37295;',
 "\x6E\x52" => '&#37290;',
 "\x6E\x53" => '&#37301;',
 "\x6E\x54" => '&#37300;',
 "\x6E\x55" => '&#37306;',
 "\x6E\x56" => '&#37312;',
 "\x6E\x57" => '&#37313;',
 "\x6E\x58" => '&#37321;',
 "\x6E\x59" => '&#37323;',
 "\x6E\x5A" => '&#37328;',
 "\x6E\x5B" => '&#37334;',
 "\x6E\x5C" => '&#37343;',
 "\x6E\x5D" => '&#37345;',
 "\x6E\x5E" => '&#37339;',
 "\x6E\x5F" => '&#37372;',
 "\x6E\x60" => '&#37365;',
 "\x6E\x61" => '&#37366;',
 "\x6E\x62" => '&#37406;',
 "\x6E\x63" => '&#37375;',
 "\x6E\x64" => '&#37396;',
 "\x6E\x65" => '&#37420;',
 "\x6E\x66" => '&#37397;',
 "\x6E\x67" => '&#37393;',
 "\x6E\x68" => '&#37470;',
 "\x6E\x69" => '&#37463;',
 "\x6E\x6A" => '&#37445;',
 "\x6E\x6B" => '&#37449;',
 "\x6E\x6C" => '&#37476;',
 "\x6E\x6D" => '&#37448;',
 "\x6E\x6E" => '&#37525;',
 "\x6E\x6F" => '&#37439;',
 "\x6E\x70" => '&#37451;',
 "\x6E\x71" => '&#37456;',
 "\x6E\x72" => '&#37532;',
 "\x6E\x73" => '&#37526;',
 "\x6E\x74" => '&#37523;',
 "\x6E\x75" => '&#37531;',
 "\x6E\x76" => '&#37466;',
 "\x6E\x77" => '&#37583;',
 "\x6E\x78" => '&#37561;',
 "\x6E\x79" => '&#37559;',
 "\x6E\x7A" => '&#37609;',
 "\x6E\x7B" => '&#37647;',
 "\x6E\x7C" => '&#37626;',
 "\x6E\x7D" => '&#37700;',
 "\x6E\x7E" => '&#37678;',
 "\x6F\x21" => '&#37657;',
 "\x6F\x22" => '&#37666;',
 "\x6F\x23" => '&#37658;',
 "\x6F\x24" => '&#37667;',
 "\x6F\x25" => '&#37690;',
 "\x6F\x26" => '&#37685;',
 "\x6F\x27" => '&#37691;',
 "\x6F\x28" => '&#37724;',
 "\x6F\x29" => '&#37728;',
 "\x6F\x2A" => '&#37756;',
 "\x6F\x2B" => '&#37742;',
 "\x6F\x2C" => '&#37718;',
 "\x6F\x2D" => '&#37808;',
 "\x6F\x2E" => '&#37804;',
 "\x6F\x2F" => '&#37805;',
 "\x6F\x30" => '&#37780;',
 "\x6F\x31" => '&#37817;',
 "\x6F\x32" => '&#37846;',
 "\x6F\x33" => '&#37847;',
 "\x6F\x34" => '&#37864;',
 "\x6F\x35" => '&#37861;',
 "\x6F\x36" => '&#37848;',
 "\x6F\x37" => '&#37827;',
 "\x6F\x38" => '&#37853;',
 "\x6F\x39" => '&#37840;',
 "\x6F\x3A" => '&#37832;',
 "\x6F\x3B" => '&#37860;',
 "\x6F\x3C" => '&#37914;',
 "\x6F\x3D" => '&#37908;',
 "\x6F\x3E" => '&#37907;',
 "\x6F\x3F" => '&#37891;',
 "\x6F\x40" => '&#37895;',
 "\x6F\x41" => '&#37904;',
 "\x6F\x42" => '&#37942;',
 "\x6F\x43" => '&#37931;',
 "\x6F\x44" => '&#37941;',
 "\x6F\x45" => '&#37921;',
 "\x6F\x46" => '&#37946;',
 "\x6F\x47" => '&#37953;',
 "\x6F\x48" => '&#37970;',
 "\x6F\x49" => '&#37956;',
 "\x6F\x4A" => '&#37979;',
 "\x6F\x4B" => '&#37984;',
 "\x6F\x4C" => '&#37986;',
 "\x6F\x4D" => '&#37982;',
 "\x6F\x4E" => '&#37994;',
 "\x6F\x4F" => '&#37417;',
 "\x6F\x50" => '&#38000;',
 "\x6F\x51" => '&#38005;',
 "\x6F\x52" => '&#38007;',
 "\x6F\x53" => '&#38013;',
 "\x6F\x54" => '&#37978;',
 "\x6F\x55" => '&#38012;',
 "\x6F\x56" => '&#38014;',
 "\x6F\x57" => '&#38017;',
 "\x6F\x58" => '&#38015;',
 "\x6F\x59" => '&#38274;',
 "\x6F\x5A" => '&#38279;',
 "\x6F\x5B" => '&#38282;',
 "\x6F\x5C" => '&#38292;',
 "\x6F\x5D" => '&#38294;',
 "\x6F\x5E" => '&#38296;',
 "\x6F\x5F" => '&#38297;',
 "\x6F\x60" => '&#38304;',
 "\x6F\x61" => '&#38312;',
 "\x6F\x62" => '&#38311;',
 "\x6F\x63" => '&#38317;',
 "\x6F\x64" => '&#38332;',
 "\x6F\x65" => '&#38331;',
 "\x6F\x66" => '&#38329;',
 "\x6F\x67" => '&#38334;',
 "\x6F\x68" => '&#38346;',
 "\x6F\x69" => '&#28662;',
 "\x6F\x6A" => '&#38339;',
 "\x6F\x6B" => '&#38349;',
 "\x6F\x6C" => '&#38348;',
 "\x6F\x6D" => '&#38357;',
 "\x6F\x6E" => '&#38356;',
 "\x6F\x6F" => '&#38358;',
 "\x6F\x70" => '&#38364;',
 "\x6F\x71" => '&#38369;',
 "\x6F\x72" => '&#38373;',
 "\x6F\x73" => '&#38370;',
 "\x6F\x74" => '&#38433;',
 "\x6F\x75" => '&#38440;',
 "\x6F\x76" => '&#38446;',
 "\x6F\x77" => '&#38447;',
 "\x6F\x78" => '&#38466;',
 "\x6F\x79" => '&#38476;',
 "\x6F\x7A" => '&#38479;',
 "\x6F\x7B" => '&#38475;',
 "\x6F\x7C" => '&#38519;',
 "\x6F\x7D" => '&#38492;',
 "\x6F\x7E" => '&#38494;',
 "\x70\x21" => '&#38493;',
 "\x70\x22" => '&#38495;',
 "\x70\x23" => '&#38502;',
 "\x70\x24" => '&#38514;',
 "\x70\x25" => '&#38508;',
 "\x70\x26" => '&#38541;',
 "\x70\x27" => '&#38552;',
 "\x70\x28" => '&#38549;',
 "\x70\x29" => '&#38551;',
 "\x70\x2A" => '&#38570;',
 "\x70\x2B" => '&#38567;',
 "\x70\x2C" => '&#38577;',
 "\x70\x2D" => '&#38578;',
 "\x70\x2E" => '&#38576;',
 "\x70\x2F" => '&#38580;',
 "\x70\x30" => '&#38582;',
 "\x70\x31" => '&#38584;',
 "\x70\x32" => '&#38585;',
 "\x70\x33" => '&#38606;',
 "\x70\x34" => '&#38603;',
 "\x70\x35" => '&#38601;',
 "\x70\x36" => '&#38605;',
 "\x70\x37" => '&#35149;',
 "\x70\x38" => '&#38620;',
 "\x70\x39" => '&#38669;',
 "\x70\x3A" => '&#38613;',
 "\x70\x3B" => '&#38649;',
 "\x70\x3C" => '&#38660;',
 "\x70\x3D" => '&#38662;',
 "\x70\x3E" => '&#38664;',
 "\x70\x3F" => '&#38675;',
 "\x70\x40" => '&#38670;',
 "\x70\x41" => '&#38673;',
 "\x70\x42" => '&#38671;',
 "\x70\x43" => '&#38678;',
 "\x70\x44" => '&#38681;',
 "\x70\x45" => '&#38692;',
 "\x70\x46" => '&#38698;',
 "\x70\x47" => '&#38704;',
 "\x70\x48" => '&#38713;',
 "\x70\x49" => '&#38717;',
 "\x70\x4A" => '&#38718;',
 "\x70\x4B" => '&#38724;',
 "\x70\x4C" => '&#38726;',
 "\x70\x4D" => '&#38728;',
 "\x70\x4E" => '&#38722;',
 "\x70\x4F" => '&#38729;',
 "\x70\x50" => '&#38748;',
 "\x70\x51" => '&#38752;',
 "\x70\x52" => '&#38756;',
 "\x70\x53" => '&#38758;',
 "\x70\x54" => '&#38760;',
 "\x70\x55" => '&#21202;',
 "\x70\x56" => '&#38763;',
 "\x70\x57" => '&#38769;',
 "\x70\x58" => '&#38777;',
 "\x70\x59" => '&#38789;',
 "\x70\x5A" => '&#38780;',
 "\x70\x5B" => '&#38785;',
 "\x70\x5C" => '&#38778;',
 "\x70\x5D" => '&#38790;',
 "\x70\x5E" => '&#38795;',
 "\x70\x5F" => '&#38799;',
 "\x70\x60" => '&#38800;',
 "\x70\x61" => '&#38812;',
 "\x70\x62" => '&#38824;',
 "\x70\x63" => '&#38822;',
 "\x70\x64" => '&#38819;',
 "\x70\x65" => '&#38835;',
 "\x70\x66" => '&#38836;',
 "\x70\x67" => '&#38851;',
 "\x70\x68" => '&#38854;',
 "\x70\x69" => '&#38856;',
 "\x70\x6A" => '&#38859;',
 "\x70\x6B" => '&#38876;',
 "\x70\x6C" => '&#38893;',
 "\x70\x6D" => '&#40783;',
 "\x70\x6E" => '&#38898;',
 "\x70\x6F" => '&#31455;',
 "\x70\x70" => '&#38902;',
 "\x70\x71" => '&#38901;',
 "\x70\x72" => '&#38927;',
 "\x70\x73" => '&#38924;',
 "\x70\x74" => '&#38968;',
 "\x70\x75" => '&#38948;',
 "\x70\x76" => '&#38945;',
 "\x70\x77" => '&#38967;',
 "\x70\x78" => '&#38973;',
 "\x70\x79" => '&#38982;',
 "\x70\x7A" => '&#38991;',
 "\x70\x7B" => '&#38987;',
 "\x70\x7C" => '&#39019;',
 "\x70\x7D" => '&#39023;',
 "\x70\x7E" => '&#39024;',
 "\x71\x21" => '&#39025;',
 "\x71\x22" => '&#39028;',
 "\x71\x23" => '&#39027;',
 "\x71\x24" => '&#39082;',
 "\x71\x25" => '&#39087;',
 "\x71\x26" => '&#39089;',
 "\x71\x27" => '&#39094;',
 "\x71\x28" => '&#39108;',
 "\x71\x29" => '&#39107;',
 "\x71\x2A" => '&#39110;',
 "\x71\x2B" => '&#39145;',
 "\x71\x2C" => '&#39147;',
 "\x71\x2D" => '&#39171;',
 "\x71\x2E" => '&#39177;',
 "\x71\x2F" => '&#39186;',
 "\x71\x30" => '&#39188;',
 "\x71\x31" => '&#39192;',
 "\x71\x32" => '&#39201;',
 "\x71\x33" => '&#39197;',
 "\x71\x34" => '&#39198;',
 "\x71\x35" => '&#39204;',
 "\x71\x36" => '&#39200;',
 "\x71\x37" => '&#39212;',
 "\x71\x38" => '&#39214;',
 "\x71\x39" => '&#39229;',
 "\x71\x3A" => '&#39230;',
 "\x71\x3B" => '&#39234;',
 "\x71\x3C" => '&#39241;',
 "\x71\x3D" => '&#39237;',
 "\x71\x3E" => '&#39248;',
 "\x71\x3F" => '&#39243;',
 "\x71\x40" => '&#39249;',
 "\x71\x41" => '&#39250;',
 "\x71\x42" => '&#39244;',
 "\x71\x43" => '&#39253;',
 "\x71\x44" => '&#39319;',
 "\x71\x45" => '&#39320;',
 "\x71\x46" => '&#39333;',
 "\x71\x47" => '&#39341;',
 "\x71\x48" => '&#39342;',
 "\x71\x49" => '&#39356;',
 "\x71\x4A" => '&#39391;',
 "\x71\x4B" => '&#39387;',
 "\x71\x4C" => '&#39389;',
 "\x71\x4D" => '&#39384;',
 "\x71\x4E" => '&#39377;',
 "\x71\x4F" => '&#39405;',
 "\x71\x50" => '&#39406;',
 "\x71\x51" => '&#39409;',
 "\x71\x52" => '&#39410;',
 "\x71\x53" => '&#39419;',
 "\x71\x54" => '&#39416;',
 "\x71\x55" => '&#39425;',
 "\x71\x56" => '&#39439;',
 "\x71\x57" => '&#39429;',
 "\x71\x58" => '&#39394;',
 "\x71\x59" => '&#39449;',
 "\x71\x5A" => '&#39467;',
 "\x71\x5B" => '&#39479;',
 "\x71\x5C" => '&#39493;',
 "\x71\x5D" => '&#39490;',
 "\x71\x5E" => '&#39488;',
 "\x71\x5F" => '&#39491;',
 "\x71\x60" => '&#39486;',
 "\x71\x61" => '&#39509;',
 "\x71\x62" => '&#39501;',
 "\x71\x63" => '&#39515;',
 "\x71\x64" => '&#39511;',
 "\x71\x65" => '&#39519;',
 "\x71\x66" => '&#39522;',
 "\x71\x67" => '&#39525;',
 "\x71\x68" => '&#39524;',
 "\x71\x69" => '&#39529;',
 "\x71\x6A" => '&#39531;',
 "\x71\x6B" => '&#39530;',
 "\x71\x6C" => '&#39597;',
 "\x71\x6D" => '&#39600;',
 "\x71\x6E" => '&#39612;',
 "\x71\x6F" => '&#39616;',
 "\x71\x70" => '&#39631;',
 "\x71\x71" => '&#39633;',
 "\x71\x72" => '&#39635;',
 "\x71\x73" => '&#39636;',
 "\x71\x74" => '&#39646;',
 "\x71\x75" => '&#39647;',
 "\x71\x76" => '&#39650;',
 "\x71\x77" => '&#39651;',
 "\x71\x78" => '&#39654;',
 "\x71\x79" => '&#39663;',
 "\x71\x7A" => '&#39659;',
 "\x71\x7B" => '&#39662;',
 "\x71\x7C" => '&#39668;',
 "\x71\x7D" => '&#39665;',
 "\x71\x7E" => '&#39671;',
 "\x72\x21" => '&#39675;',
 "\x72\x22" => '&#39686;',
 "\x72\x23" => '&#39704;',
 "\x72\x24" => '&#39706;',
 "\x72\x25" => '&#39711;',
 "\x72\x26" => '&#39714;',
 "\x72\x27" => '&#39715;',
 "\x72\x28" => '&#39717;',
 "\x72\x29" => '&#39719;',
 "\x72\x2A" => '&#39720;',
 "\x72\x2B" => '&#39721;',
 "\x72\x2C" => '&#39722;',
 "\x72\x2D" => '&#39726;',
 "\x72\x2E" => '&#39727;',
 "\x72\x2F" => '&#39730;',
 "\x72\x30" => '&#39748;',
 "\x72\x31" => '&#39747;',
 "\x72\x32" => '&#39759;',
 "\x72\x33" => '&#39757;',
 "\x72\x34" => '&#39758;',
 "\x72\x35" => '&#39761;',
 "\x72\x36" => '&#39768;',
 "\x72\x37" => '&#39796;',
 "\x72\x38" => '&#39827;',
 "\x72\x39" => '&#39811;',
 "\x72\x3A" => '&#39825;',
 "\x72\x3B" => '&#39830;',
 "\x72\x3C" => '&#39831;',
 "\x72\x3D" => '&#39839;',
 "\x72\x3E" => '&#39840;',
 "\x72\x3F" => '&#39848;',
 "\x72\x40" => '&#39860;',
 "\x72\x41" => '&#39872;',
 "\x72\x42" => '&#39882;',
 "\x72\x43" => '&#39865;',
 "\x72\x44" => '&#39878;',
 "\x72\x45" => '&#39887;',
 "\x72\x46" => '&#39889;',
 "\x72\x47" => '&#39890;',
 "\x72\x48" => '&#39907;',
 "\x72\x49" => '&#39906;',
 "\x72\x4A" => '&#39908;',
 "\x72\x4B" => '&#39892;',
 "\x72\x4C" => '&#39905;',
 "\x72\x4D" => '&#39994;',
 "\x72\x4E" => '&#39922;',
 "\x72\x4F" => '&#39921;',
 "\x72\x50" => '&#39920;',
 "\x72\x51" => '&#39957;',
 "\x72\x52" => '&#39956;',
 "\x72\x53" => '&#39945;',
 "\x72\x54" => '&#39955;',
 "\x72\x55" => '&#39948;',
 "\x72\x56" => '&#39942;',
 "\x72\x57" => '&#39944;',
 "\x72\x58" => '&#39954;',
 "\x72\x59" => '&#39946;',
 "\x72\x5A" => '&#39940;',
 "\x72\x5B" => '&#39982;',
 "\x72\x5C" => '&#39963;',
 "\x72\x5D" => '&#39973;',
 "\x72\x5E" => '&#39972;',
 "\x72\x5F" => '&#39969;',
 "\x72\x60" => '&#39984;',
 "\x72\x61" => '&#40007;',
 "\x72\x62" => '&#39986;',
 "\x72\x63" => '&#40006;',
 "\x72\x64" => '&#39998;',
 "\x72\x65" => '&#40026;',
 "\x72\x66" => '&#40032;',
 "\x72\x67" => '&#40039;',
 "\x72\x68" => '&#40054;',
 "\x72\x69" => '&#40056;',
 "\x72\x6A" => '&#40167;',
 "\x72\x6B" => '&#40172;',
 "\x72\x6C" => '&#40176;',
 "\x72\x6D" => '&#40201;',
 "\x72\x6E" => '&#40200;',
 "\x72\x6F" => '&#40171;',
 "\x72\x70" => '&#40195;',
 "\x72\x71" => '&#40198;',
 "\x72\x72" => '&#40234;',
 "\x72\x73" => '&#40230;',
 "\x72\x74" => '&#40367;',
 "\x72\x75" => '&#40227;',
 "\x72\x76" => '&#40223;',
 "\x72\x77" => '&#40260;',
 "\x72\x78" => '&#40213;',
 "\x72\x79" => '&#40210;',
 "\x72\x7A" => '&#40257;',
 "\x72\x7B" => '&#40255;',
 "\x72\x7C" => '&#40254;',
 "\x72\x7D" => '&#40262;',
 "\x72\x7E" => '&#40264;',
 "\x73\x21" => '&#40285;',
 "\x73\x22" => '&#40286;',
 "\x73\x23" => '&#40292;',
 "\x73\x24" => '&#40273;',
 "\x73\x25" => '&#40272;',
 "\x73\x26" => '&#40281;',
 "\x73\x27" => '&#40306;',
 "\x73\x28" => '&#40329;',
 "\x73\x29" => '&#40327;',
 "\x73\x2A" => '&#40363;',
 "\x73\x2B" => '&#40303;',
 "\x73\x2C" => '&#40314;',
 "\x73\x2D" => '&#40346;',
 "\x73\x2E" => '&#40356;',
 "\x73\x2F" => '&#40361;',
 "\x73\x30" => '&#40370;',
 "\x73\x31" => '&#40388;',
 "\x73\x32" => '&#40385;',
 "\x73\x33" => '&#40379;',
 "\x73\x34" => '&#40376;',
 "\x73\x35" => '&#40378;',
 "\x73\x36" => '&#40390;',
 "\x73\x37" => '&#40399;',
 "\x73\x38" => '&#40386;',
 "\x73\x39" => '&#40409;',
 "\x73\x3A" => '&#40403;',
 "\x73\x3B" => '&#40440;',
 "\x73\x3C" => '&#40422;',
 "\x73\x3D" => '&#40429;',
 "\x73\x3E" => '&#40431;',
 "\x73\x3F" => '&#40445;',
 "\x73\x40" => '&#40474;',
 "\x73\x41" => '&#40475;',
 "\x73\x42" => '&#40478;',
 "\x73\x43" => '&#40565;',
 "\x73\x44" => '&#40569;',
 "\x73\x45" => '&#40573;',
 "\x73\x46" => '&#40577;',
 "\x73\x47" => '&#40584;',
 "\x73\x48" => '&#40587;',
 "\x73\x49" => '&#40588;',
 "\x73\x4A" => '&#40594;',
 "\x73\x4B" => '&#40597;',
 "\x73\x4C" => '&#40593;',
 "\x73\x4D" => '&#40605;',
 "\x73\x4E" => '&#40613;',
 "\x73\x4F" => '&#40617;',
 "\x73\x50" => '&#40632;',
 "\x73\x51" => '&#40618;',
 "\x73\x52" => '&#40621;',
 "\x73\x53" => '&#38753;',
 "\x73\x54" => '&#40652;',
 "\x73\x55" => '&#40654;',
 "\x73\x56" => '&#40655;',
 "\x73\x57" => '&#40656;',
 "\x73\x58" => '&#40660;',
 "\x73\x59" => '&#40668;',
 "\x73\x5A" => '&#40670;',
 "\x73\x5B" => '&#40669;',
 "\x73\x5C" => '&#40672;',
 "\x73\x5D" => '&#40677;',
 "\x73\x5E" => '&#40680;',
 "\x73\x5F" => '&#40687;',
 "\x73\x60" => '&#40692;',
 "\x73\x61" => '&#40694;',
 "\x73\x62" => '&#40695;',
 "\x73\x63" => '&#40697;',
 "\x73\x64" => '&#40699;',
 "\x73\x65" => '&#40700;',
 "\x73\x66" => '&#40701;',
 "\x73\x67" => '&#40711;',
 "\x73\x68" => '&#40712;',
 "\x73\x69" => '&#30391;',
 "\x73\x6A" => '&#40725;',
 "\x73\x6B" => '&#40737;',
 "\x73\x6C" => '&#40748;',
 "\x73\x6D" => '&#40766;',
 "\x73\x6E" => '&#40778;',
 "\x73\x6F" => '&#40786;',
 "\x73\x70" => '&#40788;',
 "\x73\x71" => '&#40803;',
 "\x73\x72" => '&#40799;',
 "\x73\x73" => '&#40800;',
 "\x73\x74" => '&#40801;',
 "\x73\x75" => '&#40806;',
 "\x73\x76" => '&#40807;',
 "\x73\x77" => '&#40812;',
 "\x73\x78" => '&#40810;',
 "\x73\x79" => '&#40823;',
 "\x73\x7A" => '&#40818;',
 "\x73\x7B" => '&#40822;',
 "\x73\x7C" => '&#40853;',
 "\x73\x7D" => '&#40860;',
 "\x73\x7E" => '&#40864;',
 "\x74\x21" => '&#22575;',
 "\x74\x22" => '&#27079;',
 "\x74\x23" => '&#36953;',
 "\x74\x24" => '&#29796;',
 "\x74\x25" => '&#20956;',
 "\x74\x26" => '&#29081;');

    if (array_key_exists($symbol,$jis0208_1983)) {
        $ret=$jis0208_1983[$symbol];
    } else {
        $ret='?';
    }
    return $ret;
}
?>