# -*- coding: utf-8 -*-

# DO NOT EDIT THIS FILE!
# This file has been autogenerated by dephell <3
# https://github.com/dephell/dephell

try:
    from setuptools import setup
except ImportError:
    from distutils.core import setup

import os.path

readme = ''
here = os.path.abspath(os.path.dirname(__file__))
readme_path = os.path.join(here, 'README.rst')
if os.path.exists(readme_path):
    with open(readme_path, 'rb') as stream:
        readme = stream.read().decode('utf8')

setup(
    long_description=readme,
    name='sqlmodel',
    version='0',
    description='SQLModel, SQL databases in Python, designed for simplicity, compatibility, and robustness.',
    python_requires='==3.*,>=3.6.1',
    project_urls={
        "documentation": "https://sqlmodel.tiangolo.com",
        "homepage": "https://github.com/tiangolo/sqlmodel",
        "repository": "https://github.com/tiangolo/sqlmodel"
    },
    author='Sebastián Ramírez',
    author_email='tiangolo@gmail.com',
    license='MIT',
    classifiers=[
        'Development Status :: 4 - Beta', 'Framework :: AsyncIO',
        'Intended Audience :: Developers',
        'Intended Audience :: Science/Research',
        'Intended Audience :: System Administrators',
        'License :: OSI Approved :: MIT License',
        'Programming Language :: Python :: 3 :: Only',
        'Programming Language :: Python :: 3.6',
        'Programming Language :: Python :: 3.7',
        'Programming Language :: Python :: 3.8',
        'Programming Language :: Python :: 3.9', 'Topic :: Database',
        'Topic :: Database :: Database Engines/Servers', 'Topic :: Internet',
        'Topic :: Internet :: WWW/HTTP :: HTTP Servers',
        'Topic :: Internet :: WWW/HTTP', 'Typing :: Typed'
    ],
    packages=[
        'sqlmodel', 'sqlmodel.engine', 'sqlmodel.ext', 'sqlmodel.ext.asyncio',
        'sqlmodel.orm', 'sqlmodel.pool', 'sqlmodel.sql'
    ],
    package_dir={"": "."},
    package_data={
        "sqlmodel": ["*.typed"],
        "sqlmodel.sql": ["*.jinja2"]
    },
    install_requires=[
        'pydantic==1.*,>=1.8.2', 'sqlalchemy<1.5.0,>=1.4.17',
##        'sqlalchemy2-stubs' # Currently not needed
    ],
    extras_require={
        "dev": [
            "async-exit-stack; python_version == \"3.6.*\" and python_version >= \"3.6.0\"",
            "async-generator; python_version == \"3.6.*\" and python_version >= \"3.6.0\"",
            "autoflake==1.*,>=1.4.0",
            "black==21.*,>=21.5.0.b1; python_version == \"3.*\" and python_version >= \"3.7.0\"",
            "coverage[toml]==5.*,>=5.5.0", "fastapi==0.*,>=0.68.0",
            "flake8==3.*,>=3.9.2", "isort==5.*,>=5.9.3",
            "mdx-include==1.*,>=1.4.1", "mkdocs==1.*,>=1.2.1",
            "mkdocs-material==7.*,>=7.1.9", "mypy==0.*,>=0.812.0",
            "pytest==6.*,>=6.2.4", "requests==2.*,>=2.26.0"
        ]
    },
)
