#!/usr/bin/env python

"""
$Id: exception.py 327 2009-01-12 21:35:38Z inquisb $

This file is part of the sqlmap project, http://sqlmap.sourceforge.net.

Copyright (c) 2006-2009 Bernardo Damele A. G. <bernardo.damele@gmail.com>
                        and Daniele Bellucci <daniele.bellucci@gmail.com>

sqlmap is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free
Software Foundation version 2 of the License.

sqlmap is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
details.

You should have received a copy of the GNU General Public License along
with sqlmap; if not, write to the Free Software Foundation, Inc., 51
Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
"""



import sys

from lib.core.settings import VERSION
from lib.core.settings import VERSION_STRING


class sqlmapConnectionException(Exception):
    pass


class sqlmapDataException(Exception):
    pass


class sqlmapFilePathException(Exception):
    pass


class sqlmapGenericException(Exception):
    pass


class sqlmapMissingMandatoryOptionException(Exception):
    pass


class sqlmapNoneDataException(Exception):
    pass


class sqlmapRegExprException(Exception):
    pass


class sqlmapSyntaxException(Exception):
    pass


class sqlmapUndefinedMethod(Exception):
    pass


class sqlmapMissingPrivileges(Exception):
    pass


class sqlmapNotVulnerableException(Exception):
    pass


class sqlmapThreadException(Exception):
    pass


class sqlmapUnsupportedDBMSException(Exception):
    pass


class sqlmapUnsupportedFeatureException(Exception):
    pass


class sqlmapValueException(Exception):
    pass


def unhandledException():
    errMsg  = "unhandled exception in %s, please copy " % VERSION_STRING
    errMsg += "the command line and the following text and send by e-mail "
    errMsg += "to sqlmap-users@lists.sourceforge.net. The developers will "
    errMsg += "fix it as soon as possible:\nsqlmap version: %s\n" % VERSION
    errMsg += "Python version: %s\n" % sys.version.split()[0]
    errMsg += "Operating system: %s" % sys.platform
    return errMsg


exceptionsTuple = (
                    sqlmapConnectionException,
                    sqlmapDataException,
                    sqlmapFilePathException,
                    sqlmapGenericException,
                    sqlmapMissingMandatoryOptionException,
                    sqlmapNoneDataException,
                    sqlmapRegExprException,
                    sqlmapSyntaxException,
                    sqlmapUndefinedMethod,
                    sqlmapMissingPrivileges,
                    sqlmapNotVulnerableException,
                    sqlmapThreadException,
                    sqlmapUnsupportedDBMSException,
                    sqlmapUnsupportedFeatureException,
                    sqlmapValueException,
                  )
