/* sqlheavy-query-result.c generated by valac 0.12.1, the Vala compiler
 * generated from sqlheavy-query-result.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include "SQLHeavy.h"
#include <sqlite3.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _SqlHeavyQueryResultNextAsyncData SqlHeavyQueryResultNextAsyncData;
typedef struct _Block2Data Block2Data;
#define _g_source_unref0(var) ((var == NULL) ? NULL : (var = (g_source_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _SqlHeavyQueryResultNextInternalAsyncData SqlHeavyQueryResultNextInternalAsyncData;
typedef struct _SqlHeavyQueryResultCompleteAsyncData SqlHeavyQueryResultCompleteAsyncData;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_byte_array_unref0(var) ((var == NULL) ? NULL : (var = (g_byte_array_unref (var), NULL)))

struct _SQLHeavyQueryResultPrivate {
	SQLHeavyQuery* _query;
	SQLHeavyValueArray* _bindings;
	sqlite3_stmt* stmt;
	gboolean stmt_is_owned;
	gint error_code;
	GTimer* execution_timer;
	gboolean _finished;
	gint _field_count;
	GHashTable* _field_names;
};

struct _SqlHeavyQueryResultNextAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SQLHeavyQueryResult* self;
	GCancellable* cancellable;
	gboolean result;
	gint64 insert_id;
	gint64 _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GError * _inner_error_;
};

struct _Block2Data {
	int _ref_count_;
	SQLHeavyQueryResult * self;
	gboolean executing;
	GStaticMutex executing_lock;
	SQLHeavyQueryable* queryable;
	SQLHeavyDatabase* database;
	GThread* thread;
	GError* _error_;
	gint64 insert_id;
	gulong cancellable_sig;
	gboolean step_res;
	GMainContext* thread_context;
	GSource* idle_source;
	GCancellable* cancellable;
	gint steps;
	gpointer _async_data_;
};

struct _SqlHeavyQueryResultNextInternalAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SQLHeavyQueryResult* self;
	GCancellable* cancellable;
	gint steps;
	gint64 last_insert_id;
	gboolean result;
	Block2Data* _data2_;
	SQLHeavyQueryable* _tmp0_;
	SQLHeavyQueryable* _tmp1_;
	SQLHeavyDatabase* _tmp2_;
	GMainContext* _tmp3_;
	GSource* _tmp4_;
	gulong _tmp5_;
	GError * e;
	GError* _tmp6_;
	GError* _tmp7_;
	GError * _inner_error_;
};

struct _SqlHeavyQueryResultCompleteAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SQLHeavyQueryResult* self;
	GCancellable* cancellable;
	gint64 insert_id;
	gint64 _tmp0_;
	GError * _inner_error_;
};


static gpointer sql_heavy_query_result_parent_class = NULL;
static SQLHeavyRecordIface* sql_heavy_query_result_sql_heavy_record_parent_iface = NULL;
static SQLHeavyRecordSetIface* sql_heavy_query_result_sql_heavy_record_set_parent_iface = NULL;

#define SQL_HEAVY_QUERY_RESULT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SQL_HEAVY_TYPE_QUERY_RESULT, SQLHeavyQueryResultPrivate))
enum  {
	SQL_HEAVY_QUERY_RESULT_DUMMY_PROPERTY,
	SQL_HEAVY_QUERY_RESULT_QUERY,
	SQL_HEAVY_QUERY_RESULT_BINDINGS,
	SQL_HEAVY_QUERY_RESULT_FULL_SCAN_STEPS,
	SQL_HEAVY_QUERY_RESULT_SORT_OPERATIONS,
	SQL_HEAVY_QUERY_RESULT_EXECUTION_TIME,
	SQL_HEAVY_QUERY_RESULT_FINISHED,
	SQL_HEAVY_QUERY_RESULT_FIELD_COUNT
};
void sql_heavy_profiling_database_insert (SQLHeavyProfilingDatabase* self, SQLHeavyQueryResult* query_result);
gint sqlite3_finalize (sqlite3_stmt* stmt);
void sql_heavy_query_return_stmt (SQLHeavyQuery* self);
gboolean sql_heavy_query_result_next_internal (SQLHeavyQueryResult* self, GError** error);
static void sql_heavy_query_result_set_finished (SQLHeavyQueryResult* self, gboolean value);
gboolean sql_heavy_error_if_not_ok (gint ec, SQLHeavyQueryable* queryable, GError** error);
static void sql_heavy_query_result_acquire_locks (SQLHeavyQueryResult* self, SQLHeavyQueryable* queryable, SQLHeavyDatabase* database);
void sql_heavy_database_step_lock (SQLHeavyDatabase* self);
static void sql_heavy_query_result_release_locks (SQLHeavyQueryResult* self, SQLHeavyQueryable* queryable, SQLHeavyDatabase* database);
void sql_heavy_database_step_unlock (SQLHeavyDatabase* self);
static gboolean sql_heavy_query_result_real_next (SQLHeavyRecordSet* base, GError** error);
static void sql_heavy_query_result_next_async_data_free (gpointer _data);
static gboolean sql_heavy_query_result_next_async_co (SqlHeavyQueryResultNextAsyncData* data);
void sql_heavy_query_result_next_internal_async (SQLHeavyQueryResult* self, GCancellable* cancellable, gint steps, GAsyncReadyCallback _callback_, gpointer _user_data_);
gboolean sql_heavy_query_result_next_internal_finish (SQLHeavyQueryResult* self, GAsyncResult* _res_, gint64* last_insert_id, GError** error);
static void sql_heavy_query_result_next_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void sql_heavy_query_result_next_internal_async_data_free (gpointer _data);
static gboolean sql_heavy_query_result_next_internal_async_co (SqlHeavyQueryResultNextInternalAsyncData* data);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
static gboolean _sql_heavy_query_result_next_internal_async_co_gsource_func (gpointer self);
static void _lambda4_ (Block2Data* _data2_);
const gchar* sql_heavy_sqlite_errstr (gint ec);
static void __lambda4__g_cancellable_cancelled (GCancellable* _sender, gpointer self);
static void* _lambda5_ (Block2Data* _data2_);
static gpointer __lambda5__gthread_func (gpointer self);
static void sql_heavy_query_result_complete_async_data_free (gpointer _data);
static gboolean sql_heavy_query_result_complete_async_co (SqlHeavyQueryResultCompleteAsyncData* data);
static void sql_heavy_query_result_complete_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gint sql_heavy_query_result_field_check_index (SQLHeavyQueryResult* self, gint field, GError** error);
static gchar* sql_heavy_query_result_real_field_name (SQLHeavyRecord* base, gint field, GError** error);
static gint sql_heavy_query_result_real_field_index (SQLHeavyRecord* base, const gchar* field, GError** error);
static gint* _int_dup (gint* self);
static GType sql_heavy_query_result_real_field_type (SQLHeavyRecord* base, gint field, GError** error);
GType sql_heavy_sqlite_type_to_g_type (gint stype, GError** error);
static void sql_heavy_query_result_real_fetch (SQLHeavyRecord* base, gint field, GValue* result, GError** error);
void sql_heavy_sqlite_value_to_g_value (sqlite3_value* value, GValue* result);
static gchar* sql_heavy_query_result_real_fetch_string (SQLHeavyRecord* base, gint field, GError** error);
static gint sql_heavy_query_result_real_fetch_int (SQLHeavyRecord* base, gint field, GError** error);
static gint64 sql_heavy_query_result_real_fetch_int64 (SQLHeavyRecord* base, gint field, GError** error);
static gdouble sql_heavy_query_result_real_fetch_double (SQLHeavyRecord* base, gint field, GError** error);
static guint8* sql_heavy_query_result_real_fetch_blob (SQLHeavyRecord* base, gint field, int* result_length1, GError** error);
static SQLHeavyRow* sql_heavy_query_result_real_fetch_foreign_row (SQLHeavyRecord* base, gint field, GError** error);
SQLHeavyQueryResult* sql_heavy_query_result_new_no_lock (SQLHeavyQuery* query, GError** error);
SQLHeavyQueryResult* sql_heavy_query_result_construct_no_lock (GType object_type, SQLHeavyQuery* query, GError** error);
SQLHeavyQueryResult* sql_heavy_query_result_new_insert (SQLHeavyQuery* query, gint64* insert_id, GError** error);
SQLHeavyQueryResult* sql_heavy_query_result_construct_insert (GType object_type, SQLHeavyQuery* query, gint64* insert_id, GError** error);
SQLHeavyQueryResult* sql_heavy_query_result_new_no_exec (SQLHeavyQuery* query, GError** error);
SQLHeavyQueryResult* sql_heavy_query_result_construct_no_exec (GType object_type, SQLHeavyQuery* query, GError** error);
static GObject * sql_heavy_query_result_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
sqlite3_stmt* sql_heavy_query_try_to_steal_stmt (SQLHeavyQuery* self);
sqlite3* sql_heavy_database_get_sqlite_db (SQLHeavyDatabase* self);
gint sqlite3_prepare_v2 (sqlite3* db, const gchar* sql, gint n_bytes, sqlite3_stmt** stmt, const gchar** tail);
SQLHeavyValueArray* sql_heavy_query_get_bindings (SQLHeavyQuery* self);
static void sql_heavy_query_result_finalize (GObject* obj);
static void _vala_sql_heavy_query_result_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_sql_heavy_query_result_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
     * Move to the next row in the result set.
     *
     * This internal function is called by {@link next} (among
     * others), and will not acquire any locks.
     *
     * @return true on success, false if the query is finished executing
     * @see next
     */
gboolean sql_heavy_query_result_next_internal (SQLHeavyQueryResult* self, GError** error) {
	gboolean result = FALSE;
	sqlite3_stmt* stmt;
	gint _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	stmt = self->priv->stmt;
	if (self->priv->_finished) {
		result = FALSE;
		return result;
	}
	g_timer_continue (self->priv->execution_timer);
	_tmp0_ = sqlite3_step (stmt);
	self->priv->error_code = _tmp0_;
	g_timer_stop (self->priv->execution_timer);
	switch (self->priv->error_code) {
		case SQLITE_ROW:
		{
			self->priv->error_code = SQLITE_OK;
			g_signal_emit_by_name (self, "received-row");
			result = TRUE;
			return result;
		}
		case SQLITE_DONE:
		{
			sql_heavy_query_result_set_finished (self, TRUE);
			self->priv->error_code = SQLITE_OK;
			result = FALSE;
			return result;
		}
		default:
		{
			SQLHeavyQueryable* _tmp1_ = NULL;
			_tmp1_ = sql_heavy_query_get_queryable (self->priv->_query);
			sql_heavy_error_if_not_ok (self->priv->error_code, _tmp1_, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == SQL_HEAVY_ERROR) {
					g_propagate_error (error, _inner_error_);
					return FALSE;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return FALSE;
				}
			}
			g_assert_not_reached ();
		}
	}
}


/**
     * Acquire locks
     *
     * @param queryable the relevant {@link Queryable}
     * @param database the relevant {@link Database}
     */
static void sql_heavy_query_result_acquire_locks (SQLHeavyQueryResult* self, SQLHeavyQueryable* queryable, SQLHeavyDatabase* database) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (queryable != NULL);
	g_return_if_fail (database != NULL);
	sql_heavy_queryable_lock (queryable);
	sql_heavy_database_step_lock (database);
}


/**
     * Release locks
     *
     * @param queryable the relevant {@link Queryable}
     * @param database the relevant {@link Database}
     */
static void sql_heavy_query_result_release_locks (SQLHeavyQueryResult* self, SQLHeavyQueryable* queryable, SQLHeavyDatabase* database) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (queryable != NULL);
	g_return_if_fail (database != NULL);
	sql_heavy_database_step_unlock (database);
	sql_heavy_queryable_unlock (queryable);
}


/**
     * Move to the next row in the result set.
     *
     * @return true on success, false if the query is finished executing
     * @see next_async
     * @see complete
     */
static gboolean sql_heavy_query_result_real_next (SQLHeavyRecordSet* base, GError** error) {
	SQLHeavyQueryResult * self;
	gboolean result = FALSE;
	SQLHeavyQueryable* _tmp0_ = NULL;
	SQLHeavyQueryable* queryable;
	SQLHeavyDatabase* _tmp1_ = NULL;
	SQLHeavyDatabase* db;
	gboolean _tmp2_;
	gboolean res;
	GError * _inner_error_ = NULL;
	self = (SQLHeavyQueryResult*) base;
	_tmp0_ = sql_heavy_query_get_queryable (self->priv->_query);
	queryable = _tmp0_;
	_tmp1_ = sql_heavy_queryable_get_database (queryable);
	db = _tmp1_;
	sql_heavy_query_result_acquire_locks (self, queryable, db);
	_tmp2_ = sql_heavy_query_result_next_internal (self, &_inner_error_);
	res = _tmp2_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (db);
			return FALSE;
		} else {
			_g_object_unref0 (db);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	sql_heavy_query_result_release_locks (self, queryable, db);
	result = res;
	_g_object_unref0 (db);
	return result;
}


static void sql_heavy_query_result_next_async_data_free (gpointer _data) {
	SqlHeavyQueryResultNextAsyncData* data;
	data = _data;
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->self);
	g_slice_free (SqlHeavyQueryResultNextAsyncData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void sql_heavy_query_result_next_async (SQLHeavyQueryResult* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SqlHeavyQueryResultNextAsyncData* _data_;
	_data_ = g_slice_new0 (SqlHeavyQueryResultNextAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, sql_heavy_query_result_next_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, sql_heavy_query_result_next_async_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->cancellable = _g_object_ref0 (cancellable);
	sql_heavy_query_result_next_async_co (_data_);
}


gboolean sql_heavy_query_result_next_finish (SQLHeavyQueryResult* self, GAsyncResult* _res_, GError** error) {
	gboolean result;
	SqlHeavyQueryResultNextAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return FALSE;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


/**
     * Move to the next result in the result set asynchronously
     *
     * @param cancellable optional cancellable for aborting the operation
     * @return true on success, false if the query is finished executing
     * @see next
     */
static void sql_heavy_query_result_next_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SqlHeavyQueryResultNextAsyncData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	sql_heavy_query_result_next_async_co (data);
}


static gboolean sql_heavy_query_result_next_async_co (SqlHeavyQueryResultNextAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->insert_id = (gint64) 0;
	data->_state_ = 1;
	sql_heavy_query_result_next_internal_async (data->self, data->cancellable, 1, sql_heavy_query_result_next_async_ready, data);
	return FALSE;
	_state_1:
	data->_tmp1_ = sql_heavy_query_result_next_internal_finish (data->self, data->_res_, &data->_tmp0_, &data->_inner_error_);
	data->insert_id = data->_tmp0_;
	data->_tmp2_ = data->_tmp1_;
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	data->result = data->_tmp2_;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void sql_heavy_query_result_next_internal_async_data_free (gpointer _data) {
	SqlHeavyQueryResultNextInternalAsyncData* data;
	data = _data;
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->self);
	g_slice_free (SqlHeavyQueryResultNextInternalAsyncData, data);
}


void sql_heavy_query_result_next_internal_async (SQLHeavyQueryResult* self, GCancellable* cancellable, gint steps, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SqlHeavyQueryResultNextInternalAsyncData* _data_;
	_data_ = g_slice_new0 (SqlHeavyQueryResultNextInternalAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, sql_heavy_query_result_next_internal_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, sql_heavy_query_result_next_internal_async_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->cancellable = _g_object_ref0 (cancellable);
	_data_->steps = steps;
	sql_heavy_query_result_next_internal_async_co (_data_);
}


gboolean sql_heavy_query_result_next_internal_finish (SQLHeavyQueryResult* self, GAsyncResult* _res_, gint64* last_insert_id, GError** error) {
	gboolean result;
	SqlHeavyQueryResultNextInternalAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return FALSE;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	*last_insert_id = _data_->last_insert_id;
	result = _data_->result;
	return result;
}


/**
     * Move to the next result in the result set asynchronously
     *
     * @param cancellable optional cancellable for aborting the operation
     * @param steps number of steps to take through the result set, or 0 for unlimited
     * @return true on success, false if the query is finished executing
     * @see next
     */
static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_g_object_unref0 (_data2_->self);
		_g_source_unref0 (_data2_->idle_source);
		_g_error_free0 (_data2_->_error_);
		_g_object_unref0 (_data2_->database);
		_g_object_unref0 (_data2_->queryable);
		g_static_mutex_free (&_data2_->executing_lock);
		_g_object_unref0 (_data2_->cancellable);
		g_slice_free (Block2Data, _data2_);
	}
}


static gboolean _sql_heavy_query_result_next_internal_async_co_gsource_func (gpointer self) {
	gboolean result;
	result = sql_heavy_query_result_next_internal_async_co (self);
	return result;
}


static void _lambda4_ (Block2Data* _data2_) {
	SQLHeavyQueryResult * self;
	self = _data2_->self;
	g_static_mutex_lock (&_data2_->executing_lock);
	if (_data2_->executing) {
		sql_heavy_database_interrupt (_data2_->database);
	} else {
		const gchar* _tmp0_ = NULL;
		GError* _tmp1_ = NULL;
		_tmp0_ = sql_heavy_sqlite_errstr (SQLITE_INTERRUPT);
		_tmp1_ = g_error_new_literal (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_INTERRUPTED, _tmp0_);
		_g_error_free0 (_data2_->_error_);
		_data2_->_error_ = _tmp1_;
		g_source_attach (_data2_->idle_source, _data2_->thread_context);
		if (_data2_->thread != NULL) {
			g_thread_exit (NULL);
		}
		sql_heavy_query_result_release_locks (self, _data2_->queryable, _data2_->database);
	}
	g_static_mutex_unlock (&_data2_->executing_lock);
}


static void __lambda4__g_cancellable_cancelled (GCancellable* _sender, gpointer self) {
	_lambda4_ (self);
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static void* _lambda5_ (Block2Data* _data2_) {
	SQLHeavyQueryResult * self;
	void* result = NULL;
	gint64 _tmp6_;
	GError * _inner_error_ = NULL;
	self = _data2_->self;
	sql_heavy_query_result_acquire_locks (self, _data2_->queryable, _data2_->database);
	g_static_mutex_lock (&_data2_->executing_lock);
	_data2_->executing = TRUE;
	g_static_mutex_unlock (&_data2_->executing_lock);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		if (!(_data2_->steps != 0)) {
			break;
		}
		if (_data2_->cancellable != NULL) {
			gboolean _tmp2_;
			_tmp2_ = g_cancellable_is_cancelled (_data2_->cancellable);
			_tmp1_ = _tmp2_;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			_tmp0_ = TRUE;
		} else {
			gboolean _tmp3_;
			gboolean _tmp4_;
			_tmp3_ = sql_heavy_query_result_next_internal (self, &_inner_error_);
			_tmp4_ = _tmp3_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == SQL_HEAVY_ERROR) {
					goto __catch25_sql_heavy_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_data2_->step_res = _tmp4_;
			_tmp0_ = !_data2_->step_res;
		}
		if (_tmp0_) {
			break;
		}
		if (_data2_->steps > 0) {
			_data2_->steps--;
		}
	}
	goto __finally25;
	__catch25_sql_heavy_error:
	{
		GError * e;
		GError* _tmp5_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = _g_error_copy0 (e);
		_g_error_free0 (_data2_->_error_);
		_data2_->_error_ = _tmp5_;
		_g_error_free0 (e);
	}
	__finally25:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp6_ = sql_heavy_database_get_last_insert_id (_data2_->database);
	_data2_->insert_id = _tmp6_;
	sql_heavy_query_result_release_locks (self, _data2_->queryable, _data2_->database);
	if (_data2_->cancellable_sig != 0) {
		g_cancellable_disconnect (_data2_->cancellable, _data2_->cancellable_sig);
	}
	g_source_attach (_data2_->idle_source, _data2_->thread_context);
	result = NULL;
	return result;
}


static gpointer __lambda5__gthread_func (gpointer self) {
	gpointer result;
	result = _lambda5_ (self);
	return result;
}


static gboolean sql_heavy_query_result_next_internal_async_co (SqlHeavyQueryResultNextInternalAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_data2_ = g_slice_new0 (Block2Data);
	data->_data2_->_ref_count_ = 1;
	data->_data2_->self = g_object_ref (data->self);
	data->_data2_->cancellable = _g_object_ref0 (data->cancellable);
	data->_data2_->steps = data->steps;
	data->_data2_->_async_data_ = data;
	data->_data2_->executing = FALSE;
	g_static_mutex_init (&data->_data2_->executing_lock);
	data->_tmp0_ = NULL;
	data->_tmp0_ = sql_heavy_query_get_queryable (data->self->priv->_query);
	data->_tmp1_ = _g_object_ref0 (data->_tmp0_);
	data->_data2_->queryable = data->_tmp1_;
	data->_tmp2_ = NULL;
	data->_tmp2_ = sql_heavy_queryable_get_database (data->_data2_->queryable);
	data->_data2_->database = data->_tmp2_;
	data->_data2_->thread = NULL;
	data->_data2_->_error_ = NULL;
	data->_data2_->insert_id = (gint64) 0;
	data->_data2_->cancellable_sig = (gulong) 0;
	data->_data2_->step_res = FALSE;
	data->_tmp3_ = NULL;
	data->_tmp3_ = g_main_context_get_thread_default ();
	data->_data2_->thread_context = data->_tmp3_;
	data->_tmp4_ = NULL;
	data->_tmp4_ = g_idle_source_new ();
	data->_data2_->idle_source = data->_tmp4_;
	g_source_set_callback (data->_data2_->idle_source, _sql_heavy_query_result_next_internal_async_co_gsource_func, data, NULL);
	if (data->_data2_->cancellable != NULL) {
		data->_tmp5_ = g_signal_connect_data (data->_data2_->cancellable, "cancelled", (GCallback) __lambda4__g_cancellable_cancelled, block2_data_ref (data->_data2_), (GClosureNotify) block2_data_unref, 0);
		data->_data2_->cancellable_sig = data->_tmp5_;
	}
	g_thread_create (__lambda5__gthread_func, data->_data2_, FALSE, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == G_THREAD_ERROR) {
			goto __catch24_g_thread_error;
		}
		block2_data_unref (data->_data2_);
		data->_data2_ = NULL;
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	goto __finally24;
	__catch24_g_thread_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		data->_tmp6_ = NULL;
		data->_tmp6_ = g_error_new (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_THREAD, "Thread error: %s (%d)", data->e->message, data->e->code);
		data->_inner_error_ = data->_tmp6_;
		_g_error_free0 (data->e);
		goto __finally24;
	}
	__finally24:
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			block2_data_unref (data->_data2_);
			data->_data2_ = NULL;
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			block2_data_unref (data->_data2_);
			data->_data2_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	data->_state_ = 1;
	return FALSE;
	_state_1:
	;
	if (data->_data2_->_error_ != NULL) {
		data->_tmp7_ = _g_error_copy0 (data->_data2_->_error_);
		data->_inner_error_ = data->_tmp7_;
		if (data->_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			block2_data_unref (data->_data2_);
			data->_data2_ = NULL;
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			block2_data_unref (data->_data2_);
			data->_data2_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	data->last_insert_id = data->_data2_->insert_id;
	data->result = data->_data2_->step_res;
	block2_data_unref (data->_data2_);
	data->_data2_ = NULL;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	block2_data_unref (data->_data2_);
	data->_data2_ = NULL;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


/**
     * Finish iterating through the result set.
     */
void sql_heavy_query_result_complete (SQLHeavyQueryResult* self, GError** error) {
	SQLHeavyQueryable* _tmp0_ = NULL;
	SQLHeavyQueryable* queryable;
	SQLHeavyDatabase* _tmp1_ = NULL;
	SQLHeavyDatabase* db;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = sql_heavy_query_get_queryable (self->priv->_query);
	queryable = _tmp0_;
	_tmp1_ = sql_heavy_queryable_get_database (queryable);
	db = _tmp1_;
	sql_heavy_queryable_lock (queryable);
	sql_heavy_database_step_lock (db);
	while (TRUE) {
		if (!(!self->priv->_finished)) {
			break;
		}
		sql_heavy_query_result_next_internal (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (db);
				return;
			} else {
				_g_object_unref0 (db);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	sql_heavy_database_step_unlock (db);
	sql_heavy_queryable_unlock (queryable);
	_g_object_unref0 (db);
}


static void sql_heavy_query_result_complete_async_data_free (gpointer _data) {
	SqlHeavyQueryResultCompleteAsyncData* data;
	data = _data;
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->self);
	g_slice_free (SqlHeavyQueryResultCompleteAsyncData, data);
}


void sql_heavy_query_result_complete_async (SQLHeavyQueryResult* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SqlHeavyQueryResultCompleteAsyncData* _data_;
	_data_ = g_slice_new0 (SqlHeavyQueryResultCompleteAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, sql_heavy_query_result_complete_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, sql_heavy_query_result_complete_async_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->cancellable = _g_object_ref0 (cancellable);
	sql_heavy_query_result_complete_async_co (_data_);
}


void sql_heavy_query_result_complete_finish (SQLHeavyQueryResult* self, GAsyncResult* _res_, GError** error) {
	SqlHeavyQueryResultCompleteAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
     * Finish iterating through the result set asynchronously
     *
     * @param cancellable optional cancellable for aborting the operation
     */
static void sql_heavy_query_result_complete_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SqlHeavyQueryResultCompleteAsyncData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	sql_heavy_query_result_complete_async_co (data);
}


static gboolean sql_heavy_query_result_complete_async_co (SqlHeavyQueryResultCompleteAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->insert_id = (gint64) 0;
	data->_state_ = 1;
	sql_heavy_query_result_next_internal_async (data->self, data->cancellable, 0, sql_heavy_query_result_complete_async_ready, data);
	return FALSE;
	_state_1:
	sql_heavy_query_result_next_internal_finish (data->self, data->_res_, &data->_tmp0_, &data->_inner_error_);
	data->insert_id = data->_tmp0_;
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


/**
     * {@inheritDoc}
     */
static gint sql_heavy_query_result_field_check_index (SQLHeavyQueryResult* self, gint field, GError** error) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	if (field < 0) {
		_tmp0_ = TRUE;
	} else {
		gint _tmp1_;
		_tmp1_ = sql_heavy_record_get_field_count ((SQLHeavyRecord*) self);
		_tmp0_ = field > _tmp1_;
	}
	if (_tmp0_) {
		const gchar* _tmp2_ = NULL;
		GError* _tmp3_ = NULL;
		_tmp2_ = sql_heavy_sqlite_errstr (SQLITE_RANGE);
		_tmp3_ = g_error_new_literal (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_RANGE, _tmp2_);
		_inner_error_ = _tmp3_;
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	result = field;
	return result;
}


/**
     * {@inheritDoc}
     */
static gchar* sql_heavy_query_result_real_field_name (SQLHeavyRecord* base, gint field, GError** error) {
	SQLHeavyQueryResult * self;
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	GError * _inner_error_ = NULL;
	self = (SQLHeavyQueryResult*) base;
	_tmp0_ = sql_heavy_query_result_field_check_index (self, field, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp2_ = sqlite3_column_name (self->priv->stmt, _tmp1_);
	_tmp3_ = g_strdup (_tmp2_);
	result = _tmp3_;
	return result;
}


/**
     * Name of the table that is the origin of a field
     *
     * @param field index of the field
     * @return the table
     * @see field_origin_table
     */
gchar* sql_heavy_query_result_field_origin_table_name (SQLHeavyQueryResult* self, gint field, GError** error) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = sql_heavy_query_result_field_check_index (self, field, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp2_ = sqlite3_column_table_name (self->priv->stmt, _tmp1_);
	_tmp3_ = g_strdup (_tmp2_);
	result = _tmp3_;
	return result;
}


/**
     * Table that is the origin of a field
     *
     * @param field index of the field
     * @return the table
     * @see field_origin_table_name
     */
SQLHeavyTable* sql_heavy_query_result_field_origin_table (SQLHeavyQueryResult* self, gint field, GError** error) {
	SQLHeavyTable* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	SQLHeavyQueryable* _tmp2_ = NULL;
	gchar* _tmp3_;
	SQLHeavyTable* _tmp4_ = NULL;
	SQLHeavyTable* _tmp5_;
	SQLHeavyTable* _tmp6_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = sql_heavy_query_result_field_origin_table_name (self, field, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp2_ = sql_heavy_query_get_queryable (self->priv->_query);
	_tmp3_ = _tmp1_;
	_tmp4_ = sql_heavy_table_new (_tmp2_, _tmp3_, &_inner_error_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	_tmp6_ = _tmp5_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _tmp6_;
	return result;
}


/**
     * Name of the column that is the origin of a field
     *
     * @param field index of the field
     * @return the table name
     */
gchar* sql_heavy_query_result_field_origin_name (SQLHeavyQueryResult* self, gint field, GError** error) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = sql_heavy_query_result_field_check_index (self, field, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp2_ = sqlite3_column_origin_name (self->priv->stmt, _tmp1_);
	_tmp3_ = g_strdup (_tmp2_);
	result = _tmp3_;
	return result;
}


/**
     * {@inheritDoc}
     */
static gint* _int_dup (gint* self) {
	gint* dup;
	dup = g_new0 (gint, 1);
	memcpy (dup, self, sizeof (gint));
	return dup;
}


static gpointer __int_dup0 (gpointer self) {
	return self ? _int_dup (self) : NULL;
}


static gint sql_heavy_query_result_real_field_index (SQLHeavyRecord* base, const gchar* field, GError** error) {
	SQLHeavyQueryResult * self;
	gint result = 0;
	gconstpointer _tmp6_ = NULL;
	gint* _tmp7_;
	gint* field_number;
	GError * _inner_error_ = NULL;
	self = (SQLHeavyQueryResult*) base;
	g_return_val_if_fail (field != NULL, 0);
	if (self->priv->_field_names == NULL) {
		GHashTable* _tmp0_ = NULL;
		gint _tmp1_;
		gint fields;
		_tmp0_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_free);
		_g_hash_table_unref0 (self->priv->_field_names);
		self->priv->_field_names = _tmp0_;
		_tmp1_ = sql_heavy_record_get_field_count ((SQLHeavyRecord*) self);
		fields = _tmp1_;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp2_;
				_tmp2_ = TRUE;
				while (TRUE) {
					gchar* _tmp3_ = NULL;
					gchar* _tmp4_;
					gint* _tmp5_;
					if (!_tmp2_) {
						i++;
					}
					_tmp2_ = FALSE;
					if (!(i < fields)) {
						break;
					}
					_tmp3_ = sql_heavy_record_field_name ((SQLHeavyRecord*) self, i, &_inner_error_);
					_tmp4_ = _tmp3_;
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == SQL_HEAVY_ERROR) {
							g_propagate_error (error, _inner_error_);
							return 0;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return 0;
						}
					}
					_tmp5_ = __int_dup0 (&i);
					g_hash_table_replace (self->priv->_field_names, _tmp4_, _tmp5_);
				}
			}
		}
	}
	_tmp6_ = g_hash_table_lookup (self->priv->_field_names, field);
	_tmp7_ = __int_dup0 ((gint*) _tmp6_);
	field_number = _tmp7_;
	if (field_number == NULL) {
		const gchar* _tmp8_ = NULL;
		GError* _tmp9_ = NULL;
		_tmp8_ = sql_heavy_sqlite_errstr (SQLITE_RANGE);
		_tmp9_ = g_error_new_literal (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_RANGE, _tmp8_);
		_inner_error_ = _tmp9_;
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (field_number);
			return 0;
		} else {
			_g_free0 (field_number);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	result = (gint) (*field_number);
	_g_free0 (field_number);
	return result;
}


/**
     * {@inheritDoc}
     */
static GType sql_heavy_query_result_real_field_type (SQLHeavyRecord* base, gint field, GError** error) {
	SQLHeavyQueryResult * self;
	GType result = 0UL;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GType _tmp3_;
	GType _tmp4_;
	GError * _inner_error_ = NULL;
	self = (SQLHeavyQueryResult*) base;
	_tmp0_ = sql_heavy_query_result_field_check_index (self, field, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0UL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0UL;
		}
	}
	_tmp2_ = sqlite3_column_type (self->priv->stmt, _tmp1_);
	_tmp3_ = sql_heavy_sqlite_type_to_g_type (_tmp2_, &_inner_error_);
	_tmp4_ = _tmp3_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0UL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0UL;
		}
	}
	result = _tmp4_;
	return result;
}


/**
     * {@inheritDoc}
     */
static void sql_heavy_query_result_real_fetch (SQLHeavyRecord* base, gint field, GValue* result, GError** error) {
	SQLHeavyQueryResult * self;
	gint _tmp0_;
	gint _tmp1_;
	sqlite3_value* _tmp2_ = NULL;
	GValue _tmp3_ = {0};
	GValue _tmp4_ = {0};
	GError * _inner_error_ = NULL;
	self = (SQLHeavyQueryResult*) base;
	_tmp0_ = sql_heavy_query_result_field_check_index (self, field, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp2_ = sqlite3_column_value (self->priv->stmt, _tmp1_);
	sql_heavy_sqlite_value_to_g_value (_tmp2_, &_tmp3_);
	_tmp4_ = _tmp3_;
	*result = _tmp4_;
	return;
}


/**
     * {@inheritDoc}
     */
static gchar* sql_heavy_query_result_real_fetch_string (SQLHeavyRecord* base, gint field, GError** error) {
	SQLHeavyQueryResult * self;
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	GError * _inner_error_ = NULL;
	self = (SQLHeavyQueryResult*) base;
	_tmp0_ = sql_heavy_query_result_field_check_index (self, field, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp2_ = sqlite3_column_text (self->priv->stmt, _tmp1_);
	_tmp3_ = g_strdup (_tmp2_);
	result = _tmp3_;
	return result;
}


/**
     * {@inheritDoc}
     */
static gint sql_heavy_query_result_real_fetch_int (SQLHeavyRecord* base, gint field, GError** error) {
	SQLHeavyQueryResult * self;
	gint result = 0;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GError * _inner_error_ = NULL;
	self = (SQLHeavyQueryResult*) base;
	_tmp0_ = sql_heavy_query_result_field_check_index (self, field, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	_tmp2_ = sqlite3_column_int (self->priv->stmt, _tmp1_);
	result = _tmp2_;
	return result;
}


/**
     * {@inheritDoc}
     */
static gint64 sql_heavy_query_result_real_fetch_int64 (SQLHeavyRecord* base, gint field, GError** error) {
	SQLHeavyQueryResult * self;
	gint64 result = 0LL;
	gint _tmp0_;
	gint _tmp1_;
	gint64 _tmp2_;
	GError * _inner_error_ = NULL;
	self = (SQLHeavyQueryResult*) base;
	_tmp0_ = sql_heavy_query_result_field_check_index (self, field, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0LL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0LL;
		}
	}
	_tmp2_ = sqlite3_column_int64 (self->priv->stmt, _tmp1_);
	result = _tmp2_;
	return result;
}


/**
     * {@inheritDoc}
     */
static gdouble sql_heavy_query_result_real_fetch_double (SQLHeavyRecord* base, gint field, GError** error) {
	SQLHeavyQueryResult * self;
	gdouble result = 0.0;
	gint _tmp0_;
	gint _tmp1_;
	gdouble _tmp2_;
	GError * _inner_error_ = NULL;
	self = (SQLHeavyQueryResult*) base;
	_tmp0_ = sql_heavy_query_result_field_check_index (self, field, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0.0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0.0;
		}
	}
	_tmp2_ = sqlite3_column_double (self->priv->stmt, _tmp1_);
	result = _tmp2_;
	return result;
}


/**
     * {@inheritDoc}
     */
static guint8* sql_heavy_query_result_real_fetch_blob (SQLHeavyRecord* base, gint field, int* result_length1, GError** error) {
	SQLHeavyQueryResult * self;
	guint8* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint8* _tmp3_ = NULL;
	guint8* res;
	gint res_length1;
	gint _res_size_;
	void* _tmp4_ = NULL;
	guint8* _tmp5_;
	GError * _inner_error_ = NULL;
	self = (SQLHeavyQueryResult*) base;
	_tmp0_ = sql_heavy_query_result_field_check_index (self, field, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp2_ = sqlite3_column_bytes (self->priv->stmt, _tmp1_);
	_tmp3_ = g_new0 (guint8, _tmp2_);
	res = _tmp3_;
	res_length1 = _tmp2_;
	_res_size_ = _tmp2_;
	_tmp4_ = sqlite3_column_blob (self->priv->stmt, field);
	memcpy (res, _tmp4_, (gsize) res_length1);
	_tmp5_ = res;
	if (result_length1) {
		*result_length1 = res_length1;
	}
	result = _tmp5_;
	return result;
}


/**
     * {@inheritDoc}
     */
static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static SQLHeavyRow* sql_heavy_query_result_real_fetch_foreign_row (SQLHeavyRecord* base, gint field, GError** error) {
	SQLHeavyQueryResult * self;
	SQLHeavyRow* result = NULL;
	SQLHeavyTable* _tmp0_ = NULL;
	SQLHeavyTable* table;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint foreign_key_idx;
	SQLHeavyTable* _tmp6_ = NULL;
	SQLHeavyTable* foreign_table;
	gchar* _tmp7_ = NULL;
	gchar* foreign_column;
	SQLHeavyQueryable* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_;
	SQLHeavyQuery* _tmp14_ = NULL;
	SQLHeavyQuery* _tmp15_;
	SQLHeavyQuery* q;
	gint64 _tmp16_;
	gint64 _tmp17_;
	SQLHeavyQueryResult* _tmp18_ = NULL;
	SQLHeavyQueryResult* _tmp19_;
	SQLHeavyQueryResult* _tmp20_;
	gint64 _tmp21_;
	gint64 _tmp22_;
	gint64 _tmp23_;
	SQLHeavyRow* _tmp24_ = NULL;
	GError * _inner_error_ = NULL;
	self = (SQLHeavyQueryResult*) base;
	_tmp0_ = sql_heavy_query_result_field_origin_table (self, field, &_inner_error_);
	table = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp1_ = sql_heavy_query_result_field_origin_name (self, field, &_inner_error_);
	_tmp2_ = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (table);
			return NULL;
		} else {
			_g_object_unref0 (table);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp3_ = _tmp2_;
	_tmp4_ = sql_heavy_table_foreign_key_index (table, _tmp3_, &_inner_error_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	foreign_key_idx = _tmp5_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (table);
			return NULL;
		} else {
			_g_object_unref0 (table);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp6_ = sql_heavy_table_foreign_key_table (table, foreign_key_idx, &_inner_error_);
	foreign_table = _tmp6_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (table);
			return NULL;
		} else {
			_g_object_unref0 (table);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp7_ = sql_heavy_table_foreign_key_to (table, foreign_key_idx, &_inner_error_);
	foreign_column = _tmp7_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (foreign_table);
			_g_object_unref0 (table);
			return NULL;
		} else {
			_g_object_unref0 (foreign_table);
			_g_object_unref0 (table);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp8_ = sql_heavy_query_get_queryable (self->priv->_query);
	_tmp9_ = sql_heavy_table_get_name (foreign_table);
	_tmp10_ = string_to_string (_tmp9_);
	_tmp11_ = string_to_string (foreign_column);
	_tmp12_ = g_strconcat ("SELECT `ROWID` FROM `", _tmp10_, "` WHERE `", _tmp11_, "` = :value;", NULL);
	_tmp13_ = _tmp12_;
	_tmp14_ = sql_heavy_query_new (_tmp8_, _tmp13_, &_inner_error_);
	_tmp15_ = _tmp14_;
	_g_free0 (_tmp13_);
	q = _tmp15_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (foreign_column);
			_g_object_unref0 (foreign_table);
			_g_object_unref0 (table);
			return NULL;
		} else {
			_g_free0 (foreign_column);
			_g_object_unref0 (foreign_table);
			_g_object_unref0 (table);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp16_ = sql_heavy_record_fetch_int64 ((SQLHeavyRecord*) self, field, &_inner_error_);
	_tmp17_ = _tmp16_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (q);
			_g_free0 (foreign_column);
			_g_object_unref0 (foreign_table);
			_g_object_unref0 (table);
			return NULL;
		} else {
			_g_object_unref0 (q);
			_g_free0 (foreign_column);
			_g_object_unref0 (foreign_table);
			_g_object_unref0 (table);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	sql_heavy_query_bind_int64 (q, 1, _tmp17_, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (q);
			_g_free0 (foreign_column);
			_g_object_unref0 (foreign_table);
			_g_object_unref0 (table);
			return NULL;
		} else {
			_g_object_unref0 (q);
			_g_free0 (foreign_column);
			_g_object_unref0 (foreign_table);
			_g_object_unref0 (table);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp18_ = sql_heavy_query_execute (q, NULL, &_inner_error_, NULL);
	_tmp19_ = _tmp18_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (q);
			_g_free0 (foreign_column);
			_g_object_unref0 (foreign_table);
			_g_object_unref0 (table);
			return NULL;
		} else {
			_g_object_unref0 (q);
			_g_free0 (foreign_column);
			_g_object_unref0 (foreign_table);
			_g_object_unref0 (table);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp20_ = _tmp19_;
	_tmp21_ = sql_heavy_record_fetch_int64 ((SQLHeavyRecord*) _tmp20_, 0, &_inner_error_);
	_tmp22_ = _tmp21_;
	_g_object_unref0 (_tmp20_);
	_tmp23_ = _tmp22_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (q);
			_g_free0 (foreign_column);
			_g_object_unref0 (foreign_table);
			_g_object_unref0 (table);
			return NULL;
		} else {
			_g_object_unref0 (q);
			_g_free0 (foreign_column);
			_g_object_unref0 (foreign_table);
			_g_object_unref0 (table);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp24_ = sql_heavy_row_new (foreign_table, _tmp23_);
	result = _tmp24_;
	_g_object_unref0 (q);
	_g_free0 (foreign_column);
	_g_object_unref0 (foreign_table);
	_g_object_unref0 (table);
	return result;
}


/**
     * Create a new QueryResult without acquiring locks
     *
     * @param query the relevant query
     */
SQLHeavyQueryResult* sql_heavy_query_result_construct_no_lock (GType object_type, SQLHeavyQuery* query, GError** error) {
	SQLHeavyQueryResult * self = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (query != NULL, NULL);
	self = (SQLHeavyQueryResult*) g_object_new (object_type, "query", query, NULL);
	sql_heavy_query_result_next_internal (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	return self;
}


SQLHeavyQueryResult* sql_heavy_query_result_new_no_lock (SQLHeavyQuery* query, GError** error) {
	return sql_heavy_query_result_construct_no_lock (SQL_HEAVY_TYPE_QUERY_RESULT, query, error);
}


/**
     * Create a new QueryResult and return the {@link Database.last_insert_id}
     *
     * @param query the relevant query
     * @param insert_id location to put the ID of the inserted row
     * @see Query.execute_insert
     */
SQLHeavyQueryResult* sql_heavy_query_result_construct_insert (GType object_type, SQLHeavyQuery* query, gint64* insert_id, GError** error) {
	gint64 _insert_id = 0LL;
	SQLHeavyQueryResult * self = NULL;
	SQLHeavyQueryable* _tmp0_ = NULL;
	SQLHeavyQueryable* queryable;
	SQLHeavyDatabase* _tmp1_ = NULL;
	SQLHeavyDatabase* db;
	gint64 _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (query != NULL, NULL);
	self = (SQLHeavyQueryResult*) g_object_new (object_type, "query", query, NULL);
	_tmp0_ = sql_heavy_query_get_queryable (query);
	queryable = _tmp0_;
	_tmp1_ = sql_heavy_queryable_get_database (queryable);
	db = _tmp1_;
	sql_heavy_query_result_acquire_locks (self, queryable, db);
	sql_heavy_query_result_next_internal (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			goto __catch26_sql_heavy_error;
		}
		_g_object_unref0 (db);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp2_ = sql_heavy_database_get_last_insert_id (db);
	_insert_id = _tmp2_;
	goto __finally26;
	__catch26_sql_heavy_error:
	{
		GError * e;
		GError* _tmp3_;
		e = _inner_error_;
		_inner_error_ = NULL;
		sql_heavy_query_result_release_locks (self, queryable, db);
		_tmp3_ = _g_error_copy0 (e);
		_inner_error_ = _tmp3_;
		_g_error_free0 (e);
		goto __finally26;
	}
	__finally26:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (db);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_object_unref0 (db);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	sql_heavy_query_result_release_locks (self, queryable, db);
	_g_object_unref0 (db);
	if (insert_id) {
		*insert_id = _insert_id;
	}
	return self;
}


SQLHeavyQueryResult* sql_heavy_query_result_new_insert (SQLHeavyQuery* query, gint64* insert_id, GError** error) {
	return sql_heavy_query_result_construct_insert (SQL_HEAVY_TYPE_QUERY_RESULT, query, insert_id, error);
}


/**
     * Create a new QueryResult but do not run it.
     *
     * @param query the relevant query
     */
SQLHeavyQueryResult* sql_heavy_query_result_construct_no_exec (GType object_type, SQLHeavyQuery* query, GError** error) {
	SQLHeavyQueryResult * self = NULL;
	g_return_val_if_fail (query != NULL, NULL);
	self = (SQLHeavyQueryResult*) g_object_new (object_type, "query", query, NULL);
	return self;
}


SQLHeavyQueryResult* sql_heavy_query_result_new_no_exec (SQLHeavyQuery* query, GError** error) {
	return sql_heavy_query_result_construct_no_exec (SQL_HEAVY_TYPE_QUERY_RESULT, query, error);
}


/**
     * Create a new QueryResult
     *
     * @param query the relevant query
     */
SQLHeavyQueryResult* sql_heavy_query_result_construct (GType object_type, SQLHeavyQuery* query, GError** error) {
	SQLHeavyQueryResult * self = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (query != NULL, NULL);
	self = (SQLHeavyQueryResult*) g_object_new (object_type, "query", query, NULL);
	sql_heavy_record_set_next ((SQLHeavyRecordSet*) self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	return self;
}


SQLHeavyQueryResult* sql_heavy_query_result_new (SQLHeavyQuery* query, GError** error) {
	return sql_heavy_query_result_construct (SQL_HEAVY_TYPE_QUERY_RESULT, query, error);
}


SQLHeavyQuery* sql_heavy_query_result_get_query (SQLHeavyQueryResult* self) {
	SQLHeavyQuery* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_query;
	return result;
}


static void sql_heavy_query_result_set_query (SQLHeavyQueryResult* self, SQLHeavyQuery* value) {
	SQLHeavyQuery* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_query);
	self->priv->_query = _tmp0_;
	g_object_notify ((GObject *) self, "query");
}


SQLHeavyValueArray* sql_heavy_query_result_get_bindings (SQLHeavyQueryResult* self) {
	SQLHeavyValueArray* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_bindings;
	return result;
}


static void sql_heavy_query_result_set_bindings (SQLHeavyQueryResult* self, SQLHeavyValueArray* value) {
	SQLHeavyValueArray* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_bindings);
	self->priv->_bindings = _tmp0_;
	g_object_notify ((GObject *) self, "bindings");
}


gint sql_heavy_query_result_get_full_scan_steps (SQLHeavyQueryResult* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = sqlite3_stmt_status (self->priv->stmt, SQLITE_STMTSTATUS_FULLSCAN_STEP, 0);
	result = _tmp0_;
	return result;
}


gint sql_heavy_query_result_get_sort_operations (SQLHeavyQueryResult* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = sqlite3_stmt_status (self->priv->stmt, SQLITE_STMTSTATUS_SORT, 0);
	result = _tmp0_;
	return result;
}


gdouble sql_heavy_query_result_get_execution_time (SQLHeavyQueryResult* self) {
	gdouble result;
	gdouble _tmp0_;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = g_timer_elapsed (self->priv->execution_timer, NULL);
	result = _tmp0_;
	return result;
}


gboolean sql_heavy_query_result_get_finished (SQLHeavyQueryResult* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_finished;
	return result;
}


static void sql_heavy_query_result_set_finished (SQLHeavyQueryResult* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_finished = value;
	g_object_notify ((GObject *) self, "finished");
}


static gint sql_heavy_query_result_real_get_field_count (SQLHeavyRecord* base) {
	gint result;
	SQLHeavyQueryResult* self;
	self = (SQLHeavyQueryResult*) base;
	result = self->priv->_field_count;
	return result;
}


static gpointer _g_byte_array_ref0 (gpointer self) {
	return self ? g_byte_array_ref (self) : NULL;
}


static GObject * sql_heavy_query_result_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SQLHeavyQueryResult * self;
	GTimer* _tmp0_ = NULL;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp10_;
	gint _tmp13_;
	gint bindings_length;
	parent_class = G_OBJECT_CLASS (sql_heavy_query_result_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = SQL_HEAVY_QUERY_RESULT (obj);
	_tmp0_ = g_timer_new ();
	_g_timer_destroy0 (self->priv->execution_timer);
	self->priv->execution_timer = _tmp0_;
	g_timer_stop (self->priv->execution_timer);
	g_timer_reset (self->priv->execution_timer);
	_tmp1_ = sql_heavy_query_try_to_steal_stmt (self->priv->_query);
	self->priv->stmt = _tmp1_;
	if (self->priv->stmt == NULL) {
		SQLHeavyQueryable* _tmp2_ = NULL;
		SQLHeavyDatabase* _tmp3_ = NULL;
		SQLHeavyDatabase* _tmp4_;
		sqlite3* _tmp5_ = NULL;
		sqlite3* _tmp6_;
		sqlite3* db;
		const gchar* _tmp7_ = NULL;
		sqlite3_stmt* _tmp8_ = NULL;
		gint _tmp9_;
		self->priv->stmt_is_owned = TRUE;
		_tmp2_ = sql_heavy_query_get_queryable (self->priv->_query);
		_tmp3_ = sql_heavy_queryable_get_database (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = sql_heavy_database_get_sqlite_db (_tmp4_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		db = _tmp6_;
		_tmp7_ = sql_heavy_query_get_sql (self->priv->_query);
		_tmp9_ = sqlite3_prepare_v2 (db, _tmp7_, -1, &_tmp8_, NULL);
		self->priv->stmt = _tmp8_;
		g_assert (_tmp9_ == SQLITE_OK);
	} else {
		self->priv->stmt_is_owned = FALSE;
	}
	_tmp10_ = sqlite3_column_count (self->priv->stmt);
	self->priv->_field_count = _tmp10_;
	if (self->priv->_bindings == NULL) {
		SQLHeavyValueArray* _tmp11_ = NULL;
		SQLHeavyValueArray* _tmp12_;
		_tmp11_ = sql_heavy_query_get_bindings (self->priv->_query);
		_tmp12_ = _tmp11_;
		sql_heavy_query_result_set_bindings (self, _tmp12_);
		_g_object_unref0 (_tmp12_);
	}
	_tmp13_ = sql_heavy_value_array_get_length (self->priv->_bindings);
	bindings_length = _tmp13_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp14_;
			_tmp14_ = TRUE;
			while (TRUE) {
				GValue* _tmp15_ = NULL;
				GValue* val;
				if (!_tmp14_) {
					i++;
				}
				_tmp14_ = FALSE;
				if (!(i < bindings_length)) {
					break;
				}
				_tmp15_ = sql_heavy_value_array_get (self->priv->_bindings, i);
				val = _tmp15_;
				if (val == NULL) {
					g_critical ("sqlheavy-query-result.vala:459: Incomplete bindings");
				} else {
					GType _tmp16_;
					GType val_t;
					gint index;
					_tmp16_ = G_VALUE_TYPE (val);
					val_t = _tmp16_;
					index = i + 1;
					if (val_t == G_TYPE_STRING) {
						const gchar* _tmp17_ = NULL;
						_tmp17_ = g_value_get_string (val);
						sqlite3_bind_text (self->priv->stmt, index, _tmp17_, -1, NULL);
					} else {
						if (val_t == G_TYPE_INT) {
							gint _tmp18_;
							_tmp18_ = g_value_get_int (val);
							sqlite3_bind_int (self->priv->stmt, index, _tmp18_);
						} else {
							if (val_t == G_TYPE_INT64) {
								gint64 _tmp19_;
								_tmp19_ = g_value_get_int64 (val);
								sqlite3_bind_int64 (self->priv->stmt, index, _tmp19_);
							} else {
								if (val_t == G_TYPE_FLOAT) {
									gfloat _tmp20_;
									_tmp20_ = g_value_get_float (val);
									sqlite3_bind_double (self->priv->stmt, index, (gdouble) _tmp20_);
								} else {
									if (val_t == G_TYPE_DOUBLE) {
										gdouble _tmp21_;
										_tmp21_ = g_value_get_double (val);
										sqlite3_bind_double (self->priv->stmt, index, _tmp21_);
									} else {
										if (val_t == G_TYPE_POINTER) {
											sqlite3_bind_null (self->priv->stmt, index);
										} else {
											if (val_t == G_TYPE_BYTE_ARRAY) {
												GByteArray* _tmp22_;
												GByteArray* ba;
												_tmp22_ = _g_byte_array_ref0 (g_value_get_boxed (val));
												ba = _tmp22_;
												sqlite3_bind_blob (self->priv->stmt, index, ba->data, (gint) ba->len, NULL);
												_g_byte_array_unref0 (ba);
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	return obj;
}


static void sql_heavy_query_result_class_init (SQLHeavyQueryResultClass * klass) {
	sql_heavy_query_result_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SQLHeavyQueryResultPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_sql_heavy_query_result_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sql_heavy_query_result_set_property;
	G_OBJECT_CLASS (klass)->constructor = sql_heavy_query_result_constructor;
	G_OBJECT_CLASS (klass)->finalize = sql_heavy_query_result_finalize;
	/**
	     * The Query associated with this result.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SQL_HEAVY_QUERY_RESULT_QUERY, g_param_spec_object ("query", "query", "query", SQL_HEAVY_TYPE_QUERY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	     * The bindings for this query result
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SQL_HEAVY_QUERY_RESULT_BINDINGS, g_param_spec_object ("bindings", "bindings", "bindings", SQL_HEAVY_TYPE_VALUE_ARRAY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	     * Number of times that SQLite has stepped forward in a table as
	     * part of a full table scan.
	     *
	     * See SQLite documentation at [[http://sqlite.org/c3ref/c_stmtstatus_fullscan_step.html]]
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SQL_HEAVY_QUERY_RESULT_FULL_SCAN_STEPS, g_param_spec_int ("full-scan-steps", "full-scan-steps", "full-scan-steps", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	     * The number of sort operations that have occurred.
	     *
	     * See SQLite documentation at [[http://sqlite.org/c3ref/c_stmtstatus_fullscan_step.html]]
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SQL_HEAVY_QUERY_RESULT_SORT_OPERATIONS, g_param_spec_int ("sort-operations", "sort-operations", "sort-operations", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	     * A timer for determining how much time (wall-clock) has been
	     * spent executing the statement.
	     *
	     * This clock is started and stopped each time step () is called,
	     * and reset when reset () is called.
	     *
	     * @return seconds elapsed
	     * @see Database.enable_profiling
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SQL_HEAVY_QUERY_RESULT_EXECUTION_TIME, g_param_spec_double ("execution-time", "execution-time", "execution-time", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	     * Whether the result set has been iterated through in its
	     * entirety
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SQL_HEAVY_QUERY_RESULT_FINISHED, g_param_spec_boolean ("finished", "finished", "finished", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	     * {@inheritDoc}
	     */
	g_object_class_override_property (G_OBJECT_CLASS (klass), SQL_HEAVY_QUERY_RESULT_FIELD_COUNT, "field-count");
	/**
	     * Signal which is emitted each time a row is recieved.
	     */
	g_signal_new ("received_row", SQL_HEAVY_TYPE_QUERY_RESULT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void sql_heavy_query_result_sql_heavy_record_interface_init (SQLHeavyRecordIface * iface) {
	sql_heavy_query_result_sql_heavy_record_parent_iface = g_type_interface_peek_parent (iface);
	iface->field_name = (gchar* (*)(SQLHeavyRecord* ,gint ,GError**)) sql_heavy_query_result_real_field_name;
	iface->field_index = (gint (*)(SQLHeavyRecord* ,const gchar* ,GError**)) sql_heavy_query_result_real_field_index;
	iface->field_type = (GType (*)(SQLHeavyRecord* ,gint ,GError**)) sql_heavy_query_result_real_field_type;
	iface->fetch = (GValue (*)(SQLHeavyRecord* ,gint ,GValue* ,GError**)) sql_heavy_query_result_real_fetch;
	iface->fetch_string = (gchar* (*)(SQLHeavyRecord* ,gint ,GError**)) sql_heavy_query_result_real_fetch_string;
	iface->fetch_int = (gint (*)(SQLHeavyRecord* ,gint ,GError**)) sql_heavy_query_result_real_fetch_int;
	iface->fetch_int64 = (gint64 (*)(SQLHeavyRecord* ,gint ,GError**)) sql_heavy_query_result_real_fetch_int64;
	iface->fetch_double = (gdouble (*)(SQLHeavyRecord* ,gint ,GError**)) sql_heavy_query_result_real_fetch_double;
	iface->fetch_blob = (guint8* (*)(SQLHeavyRecord* ,gint ,int* ,GError**)) sql_heavy_query_result_real_fetch_blob;
	iface->fetch_foreign_row = (SQLHeavyRow* (*)(SQLHeavyRecord* ,gint ,GError**)) sql_heavy_query_result_real_fetch_foreign_row;
	iface->get_field_count = sql_heavy_query_result_real_get_field_count;
}


static void sql_heavy_query_result_sql_heavy_record_set_interface_init (SQLHeavyRecordSetIface * iface) {
	sql_heavy_query_result_sql_heavy_record_set_parent_iface = g_type_interface_peek_parent (iface);
	iface->next = (gboolean (*)(SQLHeavyRecordSet* ,GError**)) sql_heavy_query_result_real_next;
}


static void sql_heavy_query_result_instance_init (SQLHeavyQueryResult * self) {
	self->priv = SQL_HEAVY_QUERY_RESULT_GET_PRIVATE (self);
	self->priv->error_code = SQLITE_OK;
	self->priv->_field_names = NULL;
}


static void sql_heavy_query_result_finalize (GObject* obj) {
	SQLHeavyQueryResult * self;
	SQLHeavyQuery* query;
	SQLHeavyQueryable* _tmp0_ = NULL;
	SQLHeavyQueryable* queryable;
	SQLHeavyDatabase* _tmp1_ = NULL;
	SQLHeavyDatabase* _tmp2_;
	SQLHeavyProfilingDatabase* _tmp3_ = NULL;
	SQLHeavyProfilingDatabase* _tmp4_;
	SQLHeavyProfilingDatabase* prof_db;
	gboolean _tmp5_;
	self = SQL_HEAVY_QUERY_RESULT (obj);
	query = self->priv->_query;
	_tmp0_ = sql_heavy_query_get_queryable (query);
	queryable = _tmp0_;
	_tmp1_ = sql_heavy_queryable_get_database (queryable);
	_tmp2_ = _tmp1_;
	_tmp3_ = sql_heavy_database_get_profiling_data (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp2_);
	prof_db = _tmp4_;
	g_signal_emit_by_name (queryable, "query-executed", query);
	if (prof_db != NULL) {
		sql_heavy_profiling_database_insert (prof_db, self);
	}
	sqlite3_reset (self->priv->stmt);
	_tmp5_ = sql_heavy_query_get_auto_clear (query);
	if (_tmp5_) {
		sql_heavy_query_clear (query);
	}
	if (self->priv->stmt_is_owned) {
		sqlite3_finalize (self->priv->stmt);
	} else {
		sql_heavy_query_return_stmt (query);
	}
	_g_object_unref0 (self->priv->_query);
	_g_object_unref0 (self->priv->_bindings);
	_g_timer_destroy0 (self->priv->execution_timer);
	_g_hash_table_unref0 (self->priv->_field_names);
	G_OBJECT_CLASS (sql_heavy_query_result_parent_class)->finalize (obj);
}


/**
   * The result of executing a {@link Query}
   */
GType sql_heavy_query_result_get_type (void) {
	static volatile gsize sql_heavy_query_result_type_id__volatile = 0;
	if (g_once_init_enter (&sql_heavy_query_result_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SQLHeavyQueryResultClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sql_heavy_query_result_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SQLHeavyQueryResult), 0, (GInstanceInitFunc) sql_heavy_query_result_instance_init, NULL };
		static const GInterfaceInfo sql_heavy_record_info = { (GInterfaceInitFunc) sql_heavy_query_result_sql_heavy_record_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo sql_heavy_record_set_info = { (GInterfaceInitFunc) sql_heavy_query_result_sql_heavy_record_set_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType sql_heavy_query_result_type_id;
		sql_heavy_query_result_type_id = g_type_register_static (G_TYPE_OBJECT, "SQLHeavyQueryResult", &g_define_type_info, 0);
		g_type_add_interface_static (sql_heavy_query_result_type_id, SQL_HEAVY_TYPE_RECORD, &sql_heavy_record_info);
		g_type_add_interface_static (sql_heavy_query_result_type_id, SQL_HEAVY_TYPE_RECORD_SET, &sql_heavy_record_set_info);
		g_once_init_leave (&sql_heavy_query_result_type_id__volatile, sql_heavy_query_result_type_id);
	}
	return sql_heavy_query_result_type_id__volatile;
}


static void _vala_sql_heavy_query_result_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SQLHeavyQueryResult * self;
	self = SQL_HEAVY_QUERY_RESULT (object);
	switch (property_id) {
		case SQL_HEAVY_QUERY_RESULT_QUERY:
		g_value_set_object (value, sql_heavy_query_result_get_query (self));
		break;
		case SQL_HEAVY_QUERY_RESULT_BINDINGS:
		g_value_set_object (value, sql_heavy_query_result_get_bindings (self));
		break;
		case SQL_HEAVY_QUERY_RESULT_FULL_SCAN_STEPS:
		g_value_set_int (value, sql_heavy_query_result_get_full_scan_steps (self));
		break;
		case SQL_HEAVY_QUERY_RESULT_SORT_OPERATIONS:
		g_value_set_int (value, sql_heavy_query_result_get_sort_operations (self));
		break;
		case SQL_HEAVY_QUERY_RESULT_EXECUTION_TIME:
		g_value_set_double (value, sql_heavy_query_result_get_execution_time (self));
		break;
		case SQL_HEAVY_QUERY_RESULT_FINISHED:
		g_value_set_boolean (value, sql_heavy_query_result_get_finished (self));
		break;
		case SQL_HEAVY_QUERY_RESULT_FIELD_COUNT:
		g_value_set_int (value, sql_heavy_record_get_field_count ((SQLHeavyRecord*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_sql_heavy_query_result_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SQLHeavyQueryResult * self;
	self = SQL_HEAVY_QUERY_RESULT (object);
	switch (property_id) {
		case SQL_HEAVY_QUERY_RESULT_QUERY:
		sql_heavy_query_result_set_query (self, g_value_get_object (value));
		break;
		case SQL_HEAVY_QUERY_RESULT_BINDINGS:
		sql_heavy_query_result_set_bindings (self, g_value_get_object (value));
		break;
		case SQL_HEAVY_QUERY_RESULT_FINISHED:
		sql_heavy_query_result_set_finished (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



