window.pdocSearch = (function(){
/** elasticlunr - http://weixsong.github.io * Copyright (C) 2017 Oliver Nightingale * Copyright (C) 2017 Wei Song * MIT Licensed */!function(){function e(e){if(null===e||"object"!=typeof e)return e;var t=e.constructor();for(var n in e)e.hasOwnProperty(n)&&(t[n]=e[n]);return t}var t=function(e){var n=new t.Index;return n.pipeline.add(t.trimmer,t.stopWordFilter,t.stemmer),e&&e.call(n,n),n};t.version="0.9.5",lunr=t,t.utils={},t.utils.warn=function(e){return function(t){e.console&&console.warn&&console.warn(t)}}(this),t.utils.toString=function(e){return void 0===e||null===e?"":e.toString()},t.EventEmitter=function(){this.events={}},t.EventEmitter.prototype.addListener=function(){var e=Array.prototype.slice.call(arguments),t=e.pop(),n=e;if("function"!=typeof t)throw new TypeError("last argument must be a function");n.forEach(function(e){this.hasHandler(e)||(this.events[e]=[]),this.events[e].push(t)},this)},t.EventEmitter.prototype.removeListener=function(e,t){if(this.hasHandler(e)){var n=this.events[e].indexOf(t);-1!==n&&(this.events[e].splice(n,1),0==this.events[e].length&&delete this.events[e])}},t.EventEmitter.prototype.emit=function(e){if(this.hasHandler(e)){var t=Array.prototype.slice.call(arguments,1);this.events[e].forEach(function(e){e.apply(void 0,t)},this)}},t.EventEmitter.prototype.hasHandler=function(e){return e in this.events},t.tokenizer=function(e){if(!arguments.length||null===e||void 0===e)return[];if(Array.isArray(e)){var n=e.filter(function(e){return null===e||void 0===e?!1:!0});n=n.map(function(e){return t.utils.toString(e).toLowerCase()});var i=[];return n.forEach(function(e){var n=e.split(t.tokenizer.seperator);i=i.concat(n)},this),i}return e.toString().trim().toLowerCase().split(t.tokenizer.seperator)},t.tokenizer.defaultSeperator=/[\s\-]+/,t.tokenizer.seperator=t.tokenizer.defaultSeperator,t.tokenizer.setSeperator=function(e){null!==e&&void 0!==e&&"object"==typeof e&&(t.tokenizer.seperator=e)},t.tokenizer.resetSeperator=function(){t.tokenizer.seperator=t.tokenizer.defaultSeperator},t.tokenizer.getSeperator=function(){return t.tokenizer.seperator},t.Pipeline=function(){this._queue=[]},t.Pipeline.registeredFunctions={},t.Pipeline.registerFunction=function(e,n){n in t.Pipeline.registeredFunctions&&t.utils.warn("Overwriting existing registered function: "+n),e.label=n,t.Pipeline.registeredFunctions[n]=e},t.Pipeline.getRegisteredFunction=function(e){return e in t.Pipeline.registeredFunctions!=!0?null:t.Pipeline.registeredFunctions[e]},t.Pipeline.warnIfFunctionNotRegistered=function(e){var n=e.label&&e.label in this.registeredFunctions;n||t.utils.warn("Function is not registered with pipeline. This may cause problems when serialising the index.\n",e)},t.Pipeline.load=function(e){var n=new t.Pipeline;return e.forEach(function(e){var i=t.Pipeline.getRegisteredFunction(e);if(!i)throw new Error("Cannot load un-registered function: "+e);n.add(i)}),n},t.Pipeline.prototype.add=function(){var e=Array.prototype.slice.call(arguments);e.forEach(function(e){t.Pipeline.warnIfFunctionNotRegistered(e),this._queue.push(e)},this)},t.Pipeline.prototype.after=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i+1,0,n)},t.Pipeline.prototype.before=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i,0,n)},t.Pipeline.prototype.remove=function(e){var t=this._queue.indexOf(e);-1!==t&&this._queue.splice(t,1)},t.Pipeline.prototype.run=function(e){for(var t=[],n=e.length,i=this._queue.length,o=0;n>o;o++){for(var r=e[o],s=0;i>s&&(r=this._queue[s](r,o,e),void 0!==r&&null!==r);s++);void 0!==r&&null!==r&&t.push(r)}return t},t.Pipeline.prototype.reset=function(){this._queue=[]},t.Pipeline.prototype.get=function(){return this._queue},t.Pipeline.prototype.toJSON=function(){return this._queue.map(function(e){return t.Pipeline.warnIfFunctionNotRegistered(e),e.label})},t.Index=function(){this._fields=[],this._ref="id",this.pipeline=new t.Pipeline,this.documentStore=new t.DocumentStore,this.index={},this.eventEmitter=new t.EventEmitter,this._idfCache={},this.on("add","remove","update",function(){this._idfCache={}}.bind(this))},t.Index.prototype.on=function(){var e=Array.prototype.slice.call(arguments);return this.eventEmitter.addListener.apply(this.eventEmitter,e)},t.Index.prototype.off=function(e,t){return this.eventEmitter.removeListener(e,t)},t.Index.load=function(e){e.version!==t.version&&t.utils.warn("version mismatch: current "+t.version+" importing "+e.version);var n=new this;n._fields=e.fields,n._ref=e.ref,n.documentStore=t.DocumentStore.load(e.documentStore),n.pipeline=t.Pipeline.load(e.pipeline),n.index={};for(var i in e.index)n.index[i]=t.InvertedIndex.load(e.index[i]);return n},t.Index.prototype.addField=function(e){return this._fields.push(e),this.index[e]=new t.InvertedIndex,this},t.Index.prototype.setRef=function(e){return this._ref=e,this},t.Index.prototype.saveDocument=function(e){return this.documentStore=new t.DocumentStore(e),this},t.Index.prototype.addDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.addDoc(i,e),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));this.documentStore.addFieldLength(i,n,o.length);var r={};o.forEach(function(e){e in r?r[e]+=1:r[e]=1},this);for(var s in r){var u=r[s];u=Math.sqrt(u),this.index[n].addToken(s,{ref:i,tf:u})}},this),n&&this.eventEmitter.emit("add",e,this)}},t.Index.prototype.removeDocByRef=function(e){if(e&&this.documentStore.isDocStored()!==!1&&this.documentStore.hasDoc(e)){var t=this.documentStore.getDoc(e);this.removeDoc(t,!1)}},t.Index.prototype.removeDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.hasDoc(i)&&(this.documentStore.removeDoc(i),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));o.forEach(function(e){this.index[n].removeToken(e,i)},this)},this),n&&this.eventEmitter.emit("remove",e,this))}},t.Index.prototype.updateDoc=function(e,t){var t=void 0===t?!0:t;this.removeDocByRef(e[this._ref],!1),this.addDoc(e,!1),t&&this.eventEmitter.emit("update",e,this)},t.Index.prototype.idf=function(e,t){var n="@"+t+"/"+e;if(Object.prototype.hasOwnProperty.call(this._idfCache,n))return this._idfCache[n];var i=this.index[t].getDocFreq(e),o=1+Math.log(this.documentStore.length/(i+1));return this._idfCache[n]=o,o},t.Index.prototype.getFields=function(){return this._fields.slice()},t.Index.prototype.search=function(e,n){if(!e)return[];e="string"==typeof e?{any:e}:JSON.parse(JSON.stringify(e));var i=null;null!=n&&(i=JSON.stringify(n));for(var o=new t.Configuration(i,this.getFields()).get(),r={},s=Object.keys(e),u=0;u<s.length;u++){var a=s[u];r[a]=this.pipeline.run(t.tokenizer(e[a]))}var l={};for(var c in o){var d=r[c]||r.any;if(d){var f=this.fieldSearch(d,c,o),h=o[c].boost;for(var p in f)f[p]=f[p]*h;for(var p in f)p in l?l[p]+=f[p]:l[p]=f[p]}}var v,g=[];for(var p in l)v={ref:p,score:l[p]},this.documentStore.hasDoc(p)&&(v.doc=this.documentStore.getDoc(p)),g.push(v);return g.sort(function(e,t){return t.score-e.score}),g},t.Index.prototype.fieldSearch=function(e,t,n){var i=n[t].bool,o=n[t].expand,r=n[t].boost,s=null,u={};return 0!==r?(e.forEach(function(e){var n=[e];1==o&&(n=this.index[t].expandToken(e));var r={};n.forEach(function(n){var o=this.index[t].getDocs(n),a=this.idf(n,t);if(s&&"AND"==i){var l={};for(var c in s)c in o&&(l[c]=o[c]);o=l}n==e&&this.fieldSearchStats(u,n,o);for(var c in o){var d=this.index[t].getTermFrequency(n,c),f=this.documentStore.getFieldLength(c,t),h=1;0!=f&&(h=1/Math.sqrt(f));var p=1;n!=e&&(p=.15*(1-(n.length-e.length)/n.length));var v=d*a*h*p;c in r?r[c]+=v:r[c]=v}},this),s=this.mergeScores(s,r,i)},this),s=this.coordNorm(s,u,e.length)):void 0},t.Index.prototype.mergeScores=function(e,t,n){if(!e)return t;if("AND"==n){var i={};for(var o in t)o in e&&(i[o]=e[o]+t[o]);return i}for(var o in t)o in e?e[o]+=t[o]:e[o]=t[o];return e},t.Index.prototype.fieldSearchStats=function(e,t,n){for(var i in n)i in e?e[i].push(t):e[i]=[t]},t.Index.prototype.coordNorm=function(e,t,n){for(var i in e)if(i in t){var o=t[i].length;e[i]=e[i]*o/n}return e},t.Index.prototype.toJSON=function(){var e={};return this._fields.forEach(function(t){e[t]=this.index[t].toJSON()},this),{version:t.version,fields:this._fields,ref:this._ref,documentStore:this.documentStore.toJSON(),index:e,pipeline:this.pipeline.toJSON()}},t.Index.prototype.use=function(e){var t=Array.prototype.slice.call(arguments,1);t.unshift(this),e.apply(this,t)},t.DocumentStore=function(e){this._save=null===e||void 0===e?!0:e,this.docs={},this.docInfo={},this.length=0},t.DocumentStore.load=function(e){var t=new this;return t.length=e.length,t.docs=e.docs,t.docInfo=e.docInfo,t._save=e.save,t},t.DocumentStore.prototype.isDocStored=function(){return this._save},t.DocumentStore.prototype.addDoc=function(t,n){this.hasDoc(t)||this.length++,this.docs[t]=this._save===!0?e(n):null},t.DocumentStore.prototype.getDoc=function(e){return this.hasDoc(e)===!1?null:this.docs[e]},t.DocumentStore.prototype.hasDoc=function(e){return e in this.docs},t.DocumentStore.prototype.removeDoc=function(e){this.hasDoc(e)&&(delete this.docs[e],delete this.docInfo[e],this.length--)},t.DocumentStore.prototype.addFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&(this.docInfo[e]||(this.docInfo[e]={}),this.docInfo[e][t]=n)},t.DocumentStore.prototype.updateFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&this.addFieldLength(e,t,n)},t.DocumentStore.prototype.getFieldLength=function(e,t){return null===e||void 0===e?0:e in this.docs&&t in this.docInfo[e]?this.docInfo[e][t]:0},t.DocumentStore.prototype.toJSON=function(){return{docs:this.docs,docInfo:this.docInfo,length:this.length,save:this._save}},t.stemmer=function(){var e={ational:"ate",tional:"tion",enci:"ence",anci:"ance",izer:"ize",bli:"ble",alli:"al",entli:"ent",eli:"e",ousli:"ous",ization:"ize",ation:"ate",ator:"ate",alism:"al",iveness:"ive",fulness:"ful",ousness:"ous",aliti:"al",iviti:"ive",biliti:"ble",logi:"log"},t={icate:"ic",ative:"",alize:"al",iciti:"ic",ical:"ic",ful:"",ness:""},n="[^aeiou]",i="[aeiouy]",o=n+"[^aeiouy]*",r=i+"[aeiou]*",s="^("+o+")?"+r+o,u="^("+o+")?"+r+o+"("+r+")?$",a="^("+o+")?"+r+o+r+o,l="^("+o+")?"+i,c=new RegExp(s),d=new RegExp(a),f=new RegExp(u),h=new RegExp(l),p=/^(.+?)(ss|i)es$/,v=/^(.+?)([^s])s$/,g=/^(.+?)eed$/,m=/^(.+?)(ed|ing)$/,y=/.$/,S=/(at|bl|iz)$/,x=new RegExp("([^aeiouylsz])\\1$"),w=new RegExp("^"+o+i+"[^aeiouwxy]$"),I=/^(.+?[^aeiou])y$/,b=/^(.+?)(ational|tional|enci|anci|izer|bli|alli|entli|eli|ousli|ization|ation|ator|alism|iveness|fulness|ousness|aliti|iviti|biliti|logi)$/,E=/^(.+?)(icate|ative|alize|iciti|ical|ful|ness)$/,D=/^(.+?)(al|ance|ence|er|ic|able|ible|ant|ement|ment|ent|ou|ism|ate|iti|ous|ive|ize)$/,F=/^(.+?)(s|t)(ion)$/,_=/^(.+?)e$/,P=/ll$/,k=new RegExp("^"+o+i+"[^aeiouwxy]$"),z=function(n){var i,o,r,s,u,a,l;if(n.length<3)return n;if(r=n.substr(0,1),"y"==r&&(n=r.toUpperCase()+n.substr(1)),s=p,u=v,s.test(n)?n=n.replace(s,"$1$2"):u.test(n)&&(n=n.replace(u,"$1$2")),s=g,u=m,s.test(n)){var z=s.exec(n);s=c,s.test(z[1])&&(s=y,n=n.replace(s,""))}else if(u.test(n)){var z=u.exec(n);i=z[1],u=h,u.test(i)&&(n=i,u=S,a=x,l=w,u.test(n)?n+="e":a.test(n)?(s=y,n=n.replace(s,"")):l.test(n)&&(n+="e"))}if(s=I,s.test(n)){var z=s.exec(n);i=z[1],n=i+"i"}if(s=b,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+e[o])}if(s=E,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+t[o])}if(s=D,u=F,s.test(n)){var z=s.exec(n);i=z[1],s=d,s.test(i)&&(n=i)}else if(u.test(n)){var z=u.exec(n);i=z[1]+z[2],u=d,u.test(i)&&(n=i)}if(s=_,s.test(n)){var z=s.exec(n);i=z[1],s=d,u=f,a=k,(s.test(i)||u.test(i)&&!a.test(i))&&(n=i)}return s=P,u=d,s.test(n)&&u.test(n)&&(s=y,n=n.replace(s,"")),"y"==r&&(n=r.toLowerCase()+n.substr(1)),n};return z}(),t.Pipeline.registerFunction(t.stemmer,"stemmer"),t.stopWordFilter=function(e){return e&&t.stopWordFilter.stopWords[e]!==!0?e:void 0},t.clearStopWords=function(){t.stopWordFilter.stopWords={}},t.addStopWords=function(e){null!=e&&Array.isArray(e)!==!1&&e.forEach(function(e){t.stopWordFilter.stopWords[e]=!0},this)},t.resetStopWords=function(){t.stopWordFilter.stopWords=t.defaultStopWords},t.defaultStopWords={"":!0,a:!0,able:!0,about:!0,across:!0,after:!0,all:!0,almost:!0,also:!0,am:!0,among:!0,an:!0,and:!0,any:!0,are:!0,as:!0,at:!0,be:!0,because:!0,been:!0,but:!0,by:!0,can:!0,cannot:!0,could:!0,dear:!0,did:!0,"do":!0,does:!0,either:!0,"else":!0,ever:!0,every:!0,"for":!0,from:!0,get:!0,got:!0,had:!0,has:!0,have:!0,he:!0,her:!0,hers:!0,him:!0,his:!0,how:!0,however:!0,i:!0,"if":!0,"in":!0,into:!0,is:!0,it:!0,its:!0,just:!0,least:!0,let:!0,like:!0,likely:!0,may:!0,me:!0,might:!0,most:!0,must:!0,my:!0,neither:!0,no:!0,nor:!0,not:!0,of:!0,off:!0,often:!0,on:!0,only:!0,or:!0,other:!0,our:!0,own:!0,rather:!0,said:!0,say:!0,says:!0,she:!0,should:!0,since:!0,so:!0,some:!0,than:!0,that:!0,the:!0,their:!0,them:!0,then:!0,there:!0,these:!0,they:!0,"this":!0,tis:!0,to:!0,too:!0,twas:!0,us:!0,wants:!0,was:!0,we:!0,were:!0,what:!0,when:!0,where:!0,which:!0,"while":!0,who:!0,whom:!0,why:!0,will:!0,"with":!0,would:!0,yet:!0,you:!0,your:!0},t.stopWordFilter.stopWords=t.defaultStopWords,t.Pipeline.registerFunction(t.stopWordFilter,"stopWordFilter"),t.trimmer=function(e){if(null===e||void 0===e)throw new Error("token should not be undefined");return e.replace(/^\W+/,"").replace(/\W+$/,"")},t.Pipeline.registerFunction(t.trimmer,"trimmer"),t.InvertedIndex=function(){this.root={docs:{},df:0}},t.InvertedIndex.load=function(e){var t=new this;return t.root=e.root,t},t.InvertedIndex.prototype.addToken=function(e,t,n){for(var n=n||this.root,i=0;i<=e.length-1;){var o=e[i];o in n||(n[o]={docs:{},df:0}),i+=1,n=n[o]}var r=t.ref;n.docs[r]?n.docs[r]={tf:t.tf}:(n.docs[r]={tf:t.tf},n.df+=1)},t.InvertedIndex.prototype.hasToken=function(e){if(!e)return!1;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return!1;t=t[e[n]]}return!0},t.InvertedIndex.prototype.getNode=function(e){if(!e)return null;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return null;t=t[e[n]]}return t},t.InvertedIndex.prototype.getDocs=function(e){var t=this.getNode(e);return null==t?{}:t.docs},t.InvertedIndex.prototype.getTermFrequency=function(e,t){var n=this.getNode(e);return null==n?0:t in n.docs?n.docs[t].tf:0},t.InvertedIndex.prototype.getDocFreq=function(e){var t=this.getNode(e);return null==t?0:t.df},t.InvertedIndex.prototype.removeToken=function(e,t){if(e){var n=this.getNode(e);null!=n&&t in n.docs&&(delete n.docs[t],n.df-=1)}},t.InvertedIndex.prototype.expandToken=function(e,t,n){if(null==e||""==e)return[];var t=t||[];if(void 0==n&&(n=this.getNode(e),null==n))return t;n.df>0&&t.push(e);for(var i in n)"docs"!==i&&"df"!==i&&this.expandToken(e+i,t,n[i]);return t},t.InvertedIndex.prototype.toJSON=function(){return{root:this.root}},t.Configuration=function(e,n){var e=e||"";if(void 0==n||null==n)throw new Error("fields should not be null");this.config={};var i;try{i=JSON.parse(e),this.buildUserConfig(i,n)}catch(o){t.utils.warn("user configuration parse failed, will use default configuration"),this.buildDefaultConfig(n)}},t.Configuration.prototype.buildDefaultConfig=function(e){this.reset(),e.forEach(function(e){this.config[e]={boost:1,bool:"OR",expand:!1}},this)},t.Configuration.prototype.buildUserConfig=function(e,n){var i="OR",o=!1;if(this.reset(),"bool"in e&&(i=e.bool||i),"expand"in e&&(o=e.expand||o),"fields"in e)for(var r in e.fields)if(n.indexOf(r)>-1){var s=e.fields[r],u=o;void 0!=s.expand&&(u=s.expand),this.config[r]={boost:s.boost||0===s.boost?s.boost:1,bool:s.bool||i,expand:u}}else t.utils.warn("field name in user configuration not found in index instance fields");else this.addAllFields2UserConfig(i,o,n)},t.Configuration.prototype.addAllFields2UserConfig=function(e,t,n){n.forEach(function(n){this.config[n]={boost:1,bool:e,expand:t}},this)},t.Configuration.prototype.get=function(){return this.config},t.Configuration.prototype.reset=function(){this.config={}},lunr.SortedSet=function(){this.length=0,this.elements=[]},lunr.SortedSet.load=function(e){var t=new this;return t.elements=e,t.length=e.length,t},lunr.SortedSet.prototype.add=function(){var e,t;for(e=0;e<arguments.length;e++)t=arguments[e],~this.indexOf(t)||this.elements.splice(this.locationFor(t),0,t);this.length=this.elements.length},lunr.SortedSet.prototype.toArray=function(){return this.elements.slice()},lunr.SortedSet.prototype.map=function(e,t){return this.elements.map(e,t)},lunr.SortedSet.prototype.forEach=function(e,t){return this.elements.forEach(e,t)},lunr.SortedSet.prototype.indexOf=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;){if(r===e)return o;e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o]}return r===e?o:-1},lunr.SortedSet.prototype.locationFor=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;)e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o];return r>e?o:e>r?o+1:void 0},lunr.SortedSet.prototype.intersect=function(e){for(var t=new lunr.SortedSet,n=0,i=0,o=this.length,r=e.length,s=this.elements,u=e.elements;;){if(n>o-1||i>r-1)break;s[n]!==u[i]?s[n]<u[i]?n++:s[n]>u[i]&&i++:(t.add(s[n]),n++,i++)}return t},lunr.SortedSet.prototype.clone=function(){var e=new lunr.SortedSet;return e.elements=this.toArray(),e.length=e.elements.length,e},lunr.SortedSet.prototype.union=function(e){var t,n,i;this.length>=e.length?(t=this,n=e):(t=e,n=this),i=t.clone();for(var o=0,r=n.toArray();o<r.length;o++)i.add(r[o]);return i},lunr.SortedSet.prototype.toJSON=function(){return this.toArray()},function(e,t){"function"==typeof define&&define.amd?define(t):"object"==typeof exports?module.exports=t():e.elasticlunr=t()}(this,function(){return t})}();
    /** pdoc search index */const docs = {"version": "0.9.5", "fields": ["qualname", "fullname", "annotation", "default_value", "signature", "bases", "doc"], "ref": "fullname", "documentStore": {"docs": {"sqlglot": {"fullname": "sqlglot", "modulename": "sqlglot", "kind": "module", "doc": "<p><img src=\"sqlglot.svg\" alt=\"SQLGlot logo\" /></p>\n\n<p>SQLGlot is a no-dependency SQL parser, transpiler, optimizer, and engine. It can be used to format SQL or translate between <a href=\"https://github.com/tobymao/sqlglot/blob/main/sqlglot/dialects/__init__.py\">20 different dialects</a> like <a href=\"https://duckdb.org/\">DuckDB</a>, <a href=\"https://prestodb.io/\">Presto</a>, <a href=\"https://spark.apache.org/\">Spark</a>, <a href=\"https://www.snowflake.com/en/\">Snowflake</a>, and <a href=\"https://cloud.google.com/bigquery/\">BigQuery</a>. It aims to read a wide variety of SQL inputs and output syntactically and semantically correct SQL in the targeted dialects.</p>\n\n<p>It is a very comprehensive generic SQL parser with a robust <a href=\"https://github.com/tobymao/sqlglot/blob/main/tests/\">test suite</a>. It is also quite <a href=\"#benchmarks\">performant</a>, while being written purely in Python.</p>\n\n<p>You can easily <a href=\"#custom-dialects\">customize</a> the parser, <a href=\"#metadata\">analyze</a> queries, traverse expression trees, and programmatically <a href=\"#build-and-modify-sql\">build</a> SQL.</p>\n\n<p>Syntax <a href=\"#parser-errors\">errors</a> are highlighted and dialect incompatibilities can warn or raise depending on configurations. However, it should be noted that SQL validation is not SQLGlot\u2019s goal, so some syntax errors may go unnoticed.</p>\n\n<p>Learn more about the SQLGlot API in the <a href=\"https://sqlglot.com/\">documentation</a>.</p>\n\n<p>Contributions are very welcome in SQLGlot; read the <a href=\"https://github.com/tobymao/sqlglot/blob/main/CONTRIBUTING.md\">contribution guide</a> to get started!</p>\n\n<h2 id=\"table-of-contents\">Table of Contents</h2>\n\n<ul>\n<li><a href=\"#install\">Install</a></li>\n<li><a href=\"#versioning\">Versioning</a></li>\n<li><a href=\"#get-in-touch\">Get in Touch</a></li>\n<li><a href=\"#examples\">Examples</a>\n<ul>\n<li><a href=\"#formatting-and-transpiling\">Formatting and Transpiling</a></li>\n<li><a href=\"#metadata\">Metadata</a></li>\n<li><a href=\"#parser-errors\">Parser Errors</a></li>\n<li><a href=\"#unsupported-errors\">Unsupported Errors</a></li>\n<li><a href=\"#build-and-modify-sql\">Build and Modify SQL</a></li>\n<li><a href=\"#sql-optimizer\">SQL Optimizer</a></li>\n<li><a href=\"#ast-introspection\">AST Introspection</a></li>\n<li><a href=\"#ast-diff\">AST Diff</a></li>\n<li><a href=\"#custom-dialects\">Custom Dialects</a></li>\n<li><a href=\"#sql-execution\">SQL Execution</a></li>\n</ul></li>\n<li><a href=\"#used-by\">Used By</a></li>\n<li><a href=\"#documentation\">Documentation</a></li>\n<li><a href=\"#run-tests-and-lint\">Run Tests and Lint</a></li>\n<li><a href=\"#benchmarks\">Benchmarks</a></li>\n<li><a href=\"#optional-dependencies\">Optional Dependencies</a></li>\n</ul>\n\n<h2 id=\"install\">Install</h2>\n\n<p>From PyPI:</p>\n\n<pre><code>pip3 install sqlglot\n</code></pre>\n\n<p>Or with a local checkout:</p>\n\n<pre><code>make install\n</code></pre>\n\n<p>Requirements for development (optional):</p>\n\n<pre><code>make install-dev\n</code></pre>\n\n<h2 id=\"versioning\">Versioning</h2>\n\n<p>Given a version number <code>MAJOR</code>.<code>MINOR</code>.<code>PATCH</code>, SQLGlot uses the following versioning strategy:</p>\n\n<ul>\n<li>The <code>PATCH</code> version is incremented when there are backwards-compatible fixes or feature additions.</li>\n<li>The <code>MINOR</code> version is incremented when there are backwards-incompatible fixes or feature additions.</li>\n<li>The <code>MAJOR</code> version is incremented when there are significant backwards-incompatible fixes or feature additions.</li>\n</ul>\n\n<h2 id=\"get-in-touch\">Get in Touch</h2>\n\n<p>We'd love to hear from you. Join our community <a href=\"https://tobikodata.com/slack\">Slack channel</a>!</p>\n\n<h2 id=\"examples\">Examples</h2>\n\n<h3 id=\"formatting-and-transpiling\">Formatting and Transpiling</h3>\n\n<p>Easily translate from one dialect to another. For example, date/time functions vary between dialects and can be hard to deal with:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"kn\">import</span> <span class=\"nn\">sqlglot</span>\n<span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">transpile</span><span class=\"p\">(</span><span class=\"s2\">&quot;SELECT EPOCH_MS(1618088028295)&quot;</span><span class=\"p\">,</span> <span class=\"n\">read</span><span class=\"o\">=</span><span class=\"s2\">&quot;duckdb&quot;</span><span class=\"p\">,</span> <span class=\"n\">write</span><span class=\"o\">=</span><span class=\"s2\">&quot;hive&quot;</span><span class=\"p\">)[</span><span class=\"mi\">0</span><span class=\"p\">]</span>\n</code></pre>\n</div>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"s1\">&#39;SELECT FROM_UNIXTIME(1618088028295 / 1000)&#39;</span>\n</code></pre>\n</div>\n\n<p>SQLGlot can even translate custom time formats:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"kn\">import</span> <span class=\"nn\">sqlglot</span>\n<span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">transpile</span><span class=\"p\">(</span><span class=\"s2\">&quot;SELECT STRFTIME(x, &#39;%y-%-m-%S&#39;)&quot;</span><span class=\"p\">,</span> <span class=\"n\">read</span><span class=\"o\">=</span><span class=\"s2\">&quot;duckdb&quot;</span><span class=\"p\">,</span> <span class=\"n\">write</span><span class=\"o\">=</span><span class=\"s2\">&quot;hive&quot;</span><span class=\"p\">)[</span><span class=\"mi\">0</span><span class=\"p\">]</span>\n</code></pre>\n</div>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"ss\">&quot;SELECT DATE_FORMAT(x, &#39;yy-M-ss&#39;)&quot;</span>\n</code></pre>\n</div>\n\n<p>As another example, let's suppose that we want to read in a SQL query that contains a CTE and a cast to <code>REAL</code>, and then transpile it to Spark, which uses backticks for identifiers and <code>FLOAT</code> instead of <code>REAL</code>:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"kn\">import</span> <span class=\"nn\">sqlglot</span>\n\n<span class=\"n\">sql</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;&quot;&quot;WITH baz AS (SELECT a, c FROM foo WHERE a = 1) SELECT f.a, b.b, baz.c, CAST(&quot;b&quot;.&quot;a&quot; AS REAL) d FROM foo f JOIN bar b ON f.a = b.a LEFT JOIN baz ON f.a = baz.a&quot;&quot;&quot;</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">transpile</span><span class=\"p\">(</span><span class=\"n\">sql</span><span class=\"p\">,</span> <span class=\"n\">write</span><span class=\"o\">=</span><span class=\"s2\">&quot;spark&quot;</span><span class=\"p\">,</span> <span class=\"n\">identify</span><span class=\"o\">=</span><span class=\"kc\">True</span><span class=\"p\">,</span> <span class=\"n\">pretty</span><span class=\"o\">=</span><span class=\"kc\">True</span><span class=\"p\">)[</span><span class=\"mi\">0</span><span class=\"p\">])</span>\n</code></pre>\n</div>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"k\">WITH</span><span class=\"w\"> </span><span class=\"o\">`</span><span class=\"n\">baz</span><span class=\"o\">`</span><span class=\"w\"> </span><span class=\"k\">AS</span><span class=\"w\"> </span><span class=\"p\">(</span>\n<span class=\"w\">  </span><span class=\"k\">SELECT</span>\n<span class=\"w\">    </span><span class=\"o\">`</span><span class=\"n\">a</span><span class=\"o\">`</span><span class=\"p\">,</span>\n<span class=\"w\">    </span><span class=\"o\">`</span><span class=\"k\">c</span><span class=\"o\">`</span>\n<span class=\"w\">  </span><span class=\"k\">FROM</span><span class=\"w\"> </span><span class=\"o\">`</span><span class=\"n\">foo</span><span class=\"o\">`</span>\n<span class=\"w\">  </span><span class=\"k\">WHERE</span>\n<span class=\"w\">    </span><span class=\"o\">`</span><span class=\"n\">a</span><span class=\"o\">`</span><span class=\"w\"> </span><span class=\"o\">=</span><span class=\"w\"> </span><span class=\"mi\">1</span>\n<span class=\"p\">)</span>\n<span class=\"k\">SELECT</span>\n<span class=\"w\">  </span><span class=\"o\">`</span><span class=\"n\">f</span><span class=\"o\">`</span><span class=\"p\">.</span><span class=\"o\">`</span><span class=\"n\">a</span><span class=\"o\">`</span><span class=\"p\">,</span>\n<span class=\"w\">  </span><span class=\"o\">`</span><span class=\"n\">b</span><span class=\"o\">`</span><span class=\"p\">.</span><span class=\"o\">`</span><span class=\"n\">b</span><span class=\"o\">`</span><span class=\"p\">,</span>\n<span class=\"w\">  </span><span class=\"o\">`</span><span class=\"n\">baz</span><span class=\"o\">`</span><span class=\"p\">.</span><span class=\"o\">`</span><span class=\"k\">c</span><span class=\"o\">`</span><span class=\"p\">,</span>\n<span class=\"w\">  </span><span class=\"k\">CAST</span><span class=\"p\">(</span><span class=\"o\">`</span><span class=\"n\">b</span><span class=\"o\">`</span><span class=\"p\">.</span><span class=\"o\">`</span><span class=\"n\">a</span><span class=\"o\">`</span><span class=\"w\"> </span><span class=\"k\">AS</span><span class=\"w\"> </span><span class=\"nb\">FLOAT</span><span class=\"p\">)</span><span class=\"w\"> </span><span class=\"k\">AS</span><span class=\"w\"> </span><span class=\"o\">`</span><span class=\"n\">d</span><span class=\"o\">`</span>\n<span class=\"k\">FROM</span><span class=\"w\"> </span><span class=\"o\">`</span><span class=\"n\">foo</span><span class=\"o\">`</span><span class=\"w\"> </span><span class=\"k\">AS</span><span class=\"w\"> </span><span class=\"o\">`</span><span class=\"n\">f</span><span class=\"o\">`</span>\n<span class=\"k\">JOIN</span><span class=\"w\"> </span><span class=\"o\">`</span><span class=\"n\">bar</span><span class=\"o\">`</span><span class=\"w\"> </span><span class=\"k\">AS</span><span class=\"w\"> </span><span class=\"o\">`</span><span class=\"n\">b</span><span class=\"o\">`</span>\n<span class=\"w\">  </span><span class=\"k\">ON</span><span class=\"w\"> </span><span class=\"o\">`</span><span class=\"n\">f</span><span class=\"o\">`</span><span class=\"p\">.</span><span class=\"o\">`</span><span class=\"n\">a</span><span class=\"o\">`</span><span class=\"w\"> </span><span class=\"o\">=</span><span class=\"w\"> </span><span class=\"o\">`</span><span class=\"n\">b</span><span class=\"o\">`</span><span class=\"p\">.</span><span class=\"o\">`</span><span class=\"n\">a</span><span class=\"o\">`</span>\n<span class=\"k\">LEFT</span><span class=\"w\"> </span><span class=\"k\">JOIN</span><span class=\"w\"> </span><span class=\"o\">`</span><span class=\"n\">baz</span><span class=\"o\">`</span>\n<span class=\"w\">  </span><span class=\"k\">ON</span><span class=\"w\"> </span><span class=\"o\">`</span><span class=\"n\">f</span><span class=\"o\">`</span><span class=\"p\">.</span><span class=\"o\">`</span><span class=\"n\">a</span><span class=\"o\">`</span><span class=\"w\"> </span><span class=\"o\">=</span><span class=\"w\"> </span><span class=\"o\">`</span><span class=\"n\">baz</span><span class=\"o\">`</span><span class=\"p\">.</span><span class=\"o\">`</span><span class=\"n\">a</span><span class=\"o\">`</span>\n</code></pre>\n</div>\n\n<p>Comments are also preserved on a best-effort basis when transpiling SQL code:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"n\">sql</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;&quot;&quot;</span>\n<span class=\"s2\">/* multi</span>\n<span class=\"s2\">   line</span>\n<span class=\"s2\">   comment</span>\n<span class=\"s2\">*/</span>\n<span class=\"s2\">SELECT</span>\n<span class=\"s2\">  tbl.cola /* comment 1 */ + tbl.colb /* comment 2 */,</span>\n<span class=\"s2\">  CAST(x AS INT), # comment 3</span>\n<span class=\"s2\">  y               -- comment 4</span>\n<span class=\"s2\">FROM</span>\n<span class=\"s2\">  bar /* comment 5 */,</span>\n<span class=\"s2\">  tbl #          comment 6</span>\n<span class=\"s2\">&quot;&quot;&quot;</span>\n\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">transpile</span><span class=\"p\">(</span><span class=\"n\">sql</span><span class=\"p\">,</span> <span class=\"n\">read</span><span class=\"o\">=</span><span class=\"s1\">&#39;mysql&#39;</span><span class=\"p\">,</span> <span class=\"n\">pretty</span><span class=\"o\">=</span><span class=\"kc\">True</span><span class=\"p\">)[</span><span class=\"mi\">0</span><span class=\"p\">])</span>\n</code></pre>\n</div>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"cm\">/* multi</span>\n<span class=\"cm\">   line</span>\n<span class=\"cm\">   comment</span>\n<span class=\"cm\">*/</span>\n<span class=\"k\">SELECT</span>\n<span class=\"w\">  </span><span class=\"n\">tbl</span><span class=\"p\">.</span><span class=\"n\">cola</span><span class=\"w\"> </span><span class=\"cm\">/* comment 1 */</span><span class=\"w\"> </span><span class=\"o\">+</span><span class=\"w\"> </span><span class=\"n\">tbl</span><span class=\"p\">.</span><span class=\"n\">colb</span><span class=\"w\"> </span><span class=\"cm\">/* comment 2 */</span><span class=\"p\">,</span>\n<span class=\"w\">  </span><span class=\"k\">CAST</span><span class=\"p\">(</span><span class=\"n\">x</span><span class=\"w\"> </span><span class=\"k\">AS</span><span class=\"w\"> </span><span class=\"nb\">INT</span><span class=\"p\">),</span><span class=\"w\"> </span><span class=\"cm\">/* comment 3 */</span>\n<span class=\"w\">  </span><span class=\"n\">y</span><span class=\"w\"> </span><span class=\"cm\">/* comment 4 */</span>\n<span class=\"k\">FROM</span><span class=\"w\"> </span><span class=\"n\">bar</span><span class=\"w\"> </span><span class=\"cm\">/* comment 5 */</span><span class=\"p\">,</span><span class=\"w\"> </span><span class=\"n\">tbl</span><span class=\"w\"> </span><span class=\"cm\">/*          comment 6 */</span>\n</code></pre>\n</div>\n\n<h3 id=\"metadata\">Metadata</h3>\n\n<p>You can explore SQL with expression helpers to do things like find columns and tables:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"kn\">from</span> <span class=\"nn\">sqlglot</span> <span class=\"kn\">import</span> <span class=\"n\">parse_one</span><span class=\"p\">,</span> <span class=\"n\">exp</span>\n\n<span class=\"c1\"># print all column references (a and b)</span>\n<span class=\"k\">for</span> <span class=\"n\">column</span> <span class=\"ow\">in</span> <span class=\"n\">parse_one</span><span class=\"p\">(</span><span class=\"s2\">&quot;SELECT a, b + 1 AS c FROM d&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">find_all</span><span class=\"p\">(</span><span class=\"n\">exp</span><span class=\"o\">.</span><span class=\"n\">Column</span><span class=\"p\">):</span>\n    <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">alias_or_name</span><span class=\"p\">)</span>\n\n<span class=\"c1\"># find all projections in select statements (a and c)</span>\n<span class=\"k\">for</span> <span class=\"n\">select</span> <span class=\"ow\">in</span> <span class=\"n\">parse_one</span><span class=\"p\">(</span><span class=\"s2\">&quot;SELECT a, b + 1 AS c FROM d&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">find_all</span><span class=\"p\">(</span><span class=\"n\">exp</span><span class=\"o\">.</span><span class=\"n\">Select</span><span class=\"p\">):</span>\n    <span class=\"k\">for</span> <span class=\"n\">projection</span> <span class=\"ow\">in</span> <span class=\"n\">select</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"p\">:</span>\n        <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"n\">projection</span><span class=\"o\">.</span><span class=\"n\">alias_or_name</span><span class=\"p\">)</span>\n\n<span class=\"c1\"># find all tables (x, y, z)</span>\n<span class=\"k\">for</span> <span class=\"n\">table</span> <span class=\"ow\">in</span> <span class=\"n\">parse_one</span><span class=\"p\">(</span><span class=\"s2\">&quot;SELECT * FROM x JOIN y JOIN z&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">find_all</span><span class=\"p\">(</span><span class=\"n\">exp</span><span class=\"o\">.</span><span class=\"n\">Table</span><span class=\"p\">):</span>\n    <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"n\">table</span><span class=\"o\">.</span><span class=\"n\">name</span><span class=\"p\">)</span>\n</code></pre>\n</div>\n\n<h3 id=\"parser-errors\">Parser Errors</h3>\n\n<p>When the parser detects an error in the syntax, it raises a ParseError:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"kn\">import</span> <span class=\"nn\">sqlglot</span>\n<span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">transpile</span><span class=\"p\">(</span><span class=\"s2\">&quot;SELECT foo( FROM bar&quot;</span><span class=\"p\">)</span>\n</code></pre>\n</div>\n\n<pre><code>sqlglot.errors.ParseError: Expecting ). Line 1, Col: 13.\n  select foo( FROM bar\n              ~~~~\n</code></pre>\n\n<p>Structured syntax errors are accessible for programmatic use:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"kn\">import</span> <span class=\"nn\">sqlglot</span>\n<span class=\"k\">try</span><span class=\"p\">:</span>\n    <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">transpile</span><span class=\"p\">(</span><span class=\"s2\">&quot;SELECT foo( FROM bar&quot;</span><span class=\"p\">)</span>\n<span class=\"k\">except</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">errors</span><span class=\"o\">.</span><span class=\"n\">ParseError</span> <span class=\"k\">as</span> <span class=\"n\">e</span><span class=\"p\">:</span>\n    <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"n\">e</span><span class=\"o\">.</span><span class=\"n\">errors</span><span class=\"p\">)</span>\n</code></pre>\n</div>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"p\">[{</span>\n  <span class=\"s1\">&#39;description&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Expecting )&#39;</span><span class=\"p\">,</span>\n  <span class=\"s1\">&#39;line&#39;</span><span class=\"p\">:</span> <span class=\"mi\">1</span><span class=\"p\">,</span>\n  <span class=\"s1\">&#39;col&#39;</span><span class=\"p\">:</span> <span class=\"mi\">16</span><span class=\"p\">,</span>\n  <span class=\"s1\">&#39;start_context&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;SELECT foo( &#39;</span><span class=\"p\">,</span>\n  <span class=\"s1\">&#39;highlight&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;FROM&#39;</span><span class=\"p\">,</span>\n  <span class=\"s1\">&#39;end_context&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39; bar&#39;</span><span class=\"p\">,</span>\n  <span class=\"s1\">&#39;into_expression&#39;</span><span class=\"p\">:</span> <span class=\"kc\">None</span><span class=\"p\">,</span>\n<span class=\"p\">}]</span>\n</code></pre>\n</div>\n\n<h3 id=\"unsupported-errors\">Unsupported Errors</h3>\n\n<p>Presto <code>APPROX_DISTINCT</code> supports the accuracy argument which is not supported in Hive:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"kn\">import</span> <span class=\"nn\">sqlglot</span>\n<span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">transpile</span><span class=\"p\">(</span><span class=\"s2\">&quot;SELECT APPROX_DISTINCT(a, 0.1) FROM foo&quot;</span><span class=\"p\">,</span> <span class=\"n\">read</span><span class=\"o\">=</span><span class=\"s2\">&quot;presto&quot;</span><span class=\"p\">,</span> <span class=\"n\">write</span><span class=\"o\">=</span><span class=\"s2\">&quot;hive&quot;</span><span class=\"p\">)</span>\n</code></pre>\n</div>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"n\">APPROX_COUNT_DISTINCT</span><span class=\"w\"> </span><span class=\"n\">does</span><span class=\"w\"> </span><span class=\"k\">not</span><span class=\"w\"> </span><span class=\"n\">support</span><span class=\"w\"> </span><span class=\"n\">accuracy</span>\n<span class=\"s1\">&#39;SELECT APPROX_COUNT_DISTINCT(a) FROM foo&#39;</span>\n</code></pre>\n</div>\n\n<h3 id=\"build-and-modify-sql\">Build and Modify SQL</h3>\n\n<p>SQLGlot supports incrementally building sql expressions:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"kn\">from</span> <span class=\"nn\">sqlglot</span> <span class=\"kn\">import</span> <span class=\"n\">select</span><span class=\"p\">,</span> <span class=\"n\">condition</span>\n\n<span class=\"n\">where</span> <span class=\"o\">=</span> <span class=\"n\">condition</span><span class=\"p\">(</span><span class=\"s2\">&quot;x=1&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">and_</span><span class=\"p\">(</span><span class=\"s2\">&quot;y=1&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">select</span><span class=\"p\">(</span><span class=\"s2\">&quot;*&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">from_</span><span class=\"p\">(</span><span class=\"s2\">&quot;y&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">where</span><span class=\"p\">(</span><span class=\"n\">where</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">()</span>\n</code></pre>\n</div>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"s1\">&#39;SELECT * FROM y WHERE x = 1 AND y = 1&#39;</span>\n</code></pre>\n</div>\n\n<p>You can also modify a parsed tree:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"kn\">from</span> <span class=\"nn\">sqlglot</span> <span class=\"kn\">import</span> <span class=\"n\">parse_one</span>\n<span class=\"n\">parse_one</span><span class=\"p\">(</span><span class=\"s2\">&quot;SELECT x FROM y&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">from_</span><span class=\"p\">(</span><span class=\"s2\">&quot;z&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">()</span>\n</code></pre>\n</div>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"s1\">&#39;SELECT x FROM z&#39;</span>\n</code></pre>\n</div>\n\n<p>There is also a way to recursively transform the parsed tree by applying a mapping function to each tree node:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"kn\">from</span> <span class=\"nn\">sqlglot</span> <span class=\"kn\">import</span> <span class=\"n\">exp</span><span class=\"p\">,</span> <span class=\"n\">parse_one</span>\n\n<span class=\"n\">expression_tree</span> <span class=\"o\">=</span> <span class=\"n\">parse_one</span><span class=\"p\">(</span><span class=\"s2\">&quot;SELECT a FROM x&quot;</span><span class=\"p\">)</span>\n\n<span class=\"k\">def</span> <span class=\"nf\">transformer</span><span class=\"p\">(</span><span class=\"n\">node</span><span class=\"p\">):</span>\n    <span class=\"k\">if</span> <span class=\"nb\">isinstance</span><span class=\"p\">(</span><span class=\"n\">node</span><span class=\"p\">,</span> <span class=\"n\">exp</span><span class=\"o\">.</span><span class=\"n\">Column</span><span class=\"p\">)</span> <span class=\"ow\">and</span> <span class=\"n\">node</span><span class=\"o\">.</span><span class=\"n\">name</span> <span class=\"o\">==</span> <span class=\"s2\">&quot;a&quot;</span><span class=\"p\">:</span>\n        <span class=\"k\">return</span> <span class=\"n\">parse_one</span><span class=\"p\">(</span><span class=\"s2\">&quot;FUN(a)&quot;</span><span class=\"p\">)</span>\n    <span class=\"k\">return</span> <span class=\"n\">node</span>\n\n<span class=\"n\">transformed_tree</span> <span class=\"o\">=</span> <span class=\"n\">expression_tree</span><span class=\"o\">.</span><span class=\"n\">transform</span><span class=\"p\">(</span><span class=\"n\">transformer</span><span class=\"p\">)</span>\n<span class=\"n\">transformed_tree</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">()</span>\n</code></pre>\n</div>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"s1\">&#39;SELECT FUN(a) FROM x&#39;</span>\n</code></pre>\n</div>\n\n<h3 id=\"sql-optimizer\">SQL Optimizer</h3>\n\n<p>SQLGlot can rewrite queries into an \"optimized\" form. It performs a variety of <a href=\"https://github.com/tobymao/sqlglot/blob/main/sqlglot/optimizer/optimizer.py\">techniques</a> to create a new canonical AST. This AST can be used to standardize queries or provide the foundations for implementing an actual engine. For example:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"kn\">import</span> <span class=\"nn\">sqlglot</span>\n<span class=\"kn\">from</span> <span class=\"nn\">sqlglot.optimizer</span> <span class=\"kn\">import</span> <span class=\"n\">optimize</span>\n\n<span class=\"nb\">print</span><span class=\"p\">(</span>\n    <span class=\"n\">optimize</span><span class=\"p\">(</span>\n        <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">parse_one</span><span class=\"p\">(</span><span class=\"s2\">&quot;&quot;&quot;</span>\n<span class=\"s2\">            SELECT A OR (B OR (C AND D))</span>\n<span class=\"s2\">            FROM x</span>\n<span class=\"s2\">            WHERE Z = date &#39;2021-01-01&#39; + INTERVAL &#39;1&#39; month OR 1 = 0</span>\n<span class=\"s2\">        &quot;&quot;&quot;</span><span class=\"p\">),</span>\n        <span class=\"n\">schema</span><span class=\"o\">=</span><span class=\"p\">{</span><span class=\"s2\">&quot;x&quot;</span><span class=\"p\">:</span> <span class=\"p\">{</span><span class=\"s2\">&quot;A&quot;</span><span class=\"p\">:</span> <span class=\"s2\">&quot;INT&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;B&quot;</span><span class=\"p\">:</span> <span class=\"s2\">&quot;INT&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;C&quot;</span><span class=\"p\">:</span> <span class=\"s2\">&quot;INT&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;D&quot;</span><span class=\"p\">:</span> <span class=\"s2\">&quot;INT&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Z&quot;</span><span class=\"p\">:</span> <span class=\"s2\">&quot;STRING&quot;</span><span class=\"p\">}}</span>\n    <span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">(</span><span class=\"n\">pretty</span><span class=\"o\">=</span><span class=\"kc\">True</span><span class=\"p\">)</span>\n<span class=\"p\">)</span>\n</code></pre>\n</div>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"k\">SELECT</span>\n<span class=\"w\">  </span><span class=\"p\">(</span>\n<span class=\"w\">    </span><span class=\"ss\">&quot;x&quot;</span><span class=\"p\">.</span><span class=\"ss\">&quot;a&quot;</span><span class=\"w\"> </span><span class=\"o\">&lt;&gt;</span><span class=\"w\"> </span><span class=\"mi\">0</span><span class=\"w\"> </span><span class=\"k\">OR</span><span class=\"w\"> </span><span class=\"ss\">&quot;x&quot;</span><span class=\"p\">.</span><span class=\"ss\">&quot;b&quot;</span><span class=\"w\"> </span><span class=\"o\">&lt;&gt;</span><span class=\"w\"> </span><span class=\"mi\">0</span><span class=\"w\"> </span><span class=\"k\">OR</span><span class=\"w\"> </span><span class=\"ss\">&quot;x&quot;</span><span class=\"p\">.</span><span class=\"ss\">&quot;c&quot;</span><span class=\"w\"> </span><span class=\"o\">&lt;&gt;</span><span class=\"w\"> </span><span class=\"mi\">0</span>\n<span class=\"w\">  </span><span class=\"p\">)</span>\n<span class=\"w\">  </span><span class=\"k\">AND</span><span class=\"w\"> </span><span class=\"p\">(</span>\n<span class=\"w\">    </span><span class=\"ss\">&quot;x&quot;</span><span class=\"p\">.</span><span class=\"ss\">&quot;a&quot;</span><span class=\"w\"> </span><span class=\"o\">&lt;&gt;</span><span class=\"w\"> </span><span class=\"mi\">0</span><span class=\"w\"> </span><span class=\"k\">OR</span><span class=\"w\"> </span><span class=\"ss\">&quot;x&quot;</span><span class=\"p\">.</span><span class=\"ss\">&quot;b&quot;</span><span class=\"w\"> </span><span class=\"o\">&lt;&gt;</span><span class=\"w\"> </span><span class=\"mi\">0</span><span class=\"w\"> </span><span class=\"k\">OR</span><span class=\"w\"> </span><span class=\"ss\">&quot;x&quot;</span><span class=\"p\">.</span><span class=\"ss\">&quot;d&quot;</span><span class=\"w\"> </span><span class=\"o\">&lt;&gt;</span><span class=\"w\"> </span><span class=\"mi\">0</span>\n<span class=\"w\">  </span><span class=\"p\">)</span><span class=\"w\"> </span><span class=\"k\">AS</span><span class=\"w\"> </span><span class=\"ss\">&quot;_col_0&quot;</span>\n<span class=\"k\">FROM</span><span class=\"w\"> </span><span class=\"ss\">&quot;x&quot;</span><span class=\"w\"> </span><span class=\"k\">AS</span><span class=\"w\"> </span><span class=\"ss\">&quot;x&quot;</span>\n<span class=\"k\">WHERE</span>\n<span class=\"w\">  </span><span class=\"k\">CAST</span><span class=\"p\">(</span><span class=\"ss\">&quot;x&quot;</span><span class=\"p\">.</span><span class=\"ss\">&quot;z&quot;</span><span class=\"w\"> </span><span class=\"k\">AS</span><span class=\"w\"> </span><span class=\"nb\">DATE</span><span class=\"p\">)</span><span class=\"w\"> </span><span class=\"o\">=</span><span class=\"w\"> </span><span class=\"k\">CAST</span><span class=\"p\">(</span><span class=\"s1\">&#39;2021-02-01&#39;</span><span class=\"w\"> </span><span class=\"k\">AS</span><span class=\"w\"> </span><span class=\"nb\">DATE</span><span class=\"p\">)</span>\n</code></pre>\n</div>\n\n<h3 id=\"ast-introspection\">AST Introspection</h3>\n\n<p>You can see the AST version of the sql by calling <code>repr</code>:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"kn\">from</span> <span class=\"nn\">sqlglot</span> <span class=\"kn\">import</span> <span class=\"n\">parse_one</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"nb\">repr</span><span class=\"p\">(</span><span class=\"n\">parse_one</span><span class=\"p\">(</span><span class=\"s2\">&quot;SELECT a + 1 AS z&quot;</span><span class=\"p\">)))</span>\n</code></pre>\n</div>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"p\">(</span><span class=\"n\">SELECT</span> <span class=\"n\">expressions</span><span class=\"p\">:</span>\n  <span class=\"p\">(</span><span class=\"n\">ALIAS</span> <span class=\"n\">this</span><span class=\"p\">:</span>\n    <span class=\"p\">(</span><span class=\"n\">ADD</span> <span class=\"n\">this</span><span class=\"p\">:</span>\n      <span class=\"p\">(</span><span class=\"n\">COLUMN</span> <span class=\"n\">this</span><span class=\"p\">:</span>\n        <span class=\"p\">(</span><span class=\"n\">IDENTIFIER</span> <span class=\"n\">this</span><span class=\"p\">:</span> <span class=\"n\">a</span><span class=\"p\">,</span> <span class=\"n\">quoted</span><span class=\"p\">:</span> <span class=\"kc\">False</span><span class=\"p\">)),</span> <span class=\"n\">expression</span><span class=\"p\">:</span>\n      <span class=\"p\">(</span><span class=\"n\">LITERAL</span> <span class=\"n\">this</span><span class=\"p\">:</span> <span class=\"mi\">1</span><span class=\"p\">,</span> <span class=\"n\">is_string</span><span class=\"p\">:</span> <span class=\"kc\">False</span><span class=\"p\">)),</span> <span class=\"n\">alias</span><span class=\"p\">:</span>\n    <span class=\"p\">(</span><span class=\"n\">IDENTIFIER</span> <span class=\"n\">this</span><span class=\"p\">:</span> <span class=\"n\">z</span><span class=\"p\">,</span> <span class=\"n\">quoted</span><span class=\"p\">:</span> <span class=\"kc\">False</span><span class=\"p\">)))</span>\n</code></pre>\n</div>\n\n<h3 id=\"ast-diff\">AST Diff</h3>\n\n<p>SQLGlot can calculate the difference between two expressions and output changes in a form of a sequence of actions needed to transform a source expression into a target one:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"kn\">from</span> <span class=\"nn\">sqlglot</span> <span class=\"kn\">import</span> <span class=\"n\">diff</span><span class=\"p\">,</span> <span class=\"n\">parse_one</span>\n<span class=\"n\">diff</span><span class=\"p\">(</span><span class=\"n\">parse_one</span><span class=\"p\">(</span><span class=\"s2\">&quot;SELECT a + b, c, d&quot;</span><span class=\"p\">),</span> <span class=\"n\">parse_one</span><span class=\"p\">(</span><span class=\"s2\">&quot;SELECT c, a - b, d&quot;</span><span class=\"p\">))</span>\n</code></pre>\n</div>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"p\">[</span>\n  <span class=\"n\">Remove</span><span class=\"p\">(</span><span class=\"n\">expression</span><span class=\"o\">=</span><span class=\"p\">(</span><span class=\"n\">ADD</span> <span class=\"n\">this</span><span class=\"p\">:</span>\n    <span class=\"p\">(</span><span class=\"n\">COLUMN</span> <span class=\"n\">this</span><span class=\"p\">:</span>\n      <span class=\"p\">(</span><span class=\"n\">IDENTIFIER</span> <span class=\"n\">this</span><span class=\"p\">:</span> <span class=\"n\">a</span><span class=\"p\">,</span> <span class=\"n\">quoted</span><span class=\"p\">:</span> <span class=\"kc\">False</span><span class=\"p\">)),</span> <span class=\"n\">expression</span><span class=\"p\">:</span>\n    <span class=\"p\">(</span><span class=\"n\">COLUMN</span> <span class=\"n\">this</span><span class=\"p\">:</span>\n      <span class=\"p\">(</span><span class=\"n\">IDENTIFIER</span> <span class=\"n\">this</span><span class=\"p\">:</span> <span class=\"n\">b</span><span class=\"p\">,</span> <span class=\"n\">quoted</span><span class=\"p\">:</span> <span class=\"kc\">False</span><span class=\"p\">)))),</span>\n  <span class=\"n\">Insert</span><span class=\"p\">(</span><span class=\"n\">expression</span><span class=\"o\">=</span><span class=\"p\">(</span><span class=\"n\">SUB</span> <span class=\"n\">this</span><span class=\"p\">:</span>\n    <span class=\"p\">(</span><span class=\"n\">COLUMN</span> <span class=\"n\">this</span><span class=\"p\">:</span>\n      <span class=\"p\">(</span><span class=\"n\">IDENTIFIER</span> <span class=\"n\">this</span><span class=\"p\">:</span> <span class=\"n\">a</span><span class=\"p\">,</span> <span class=\"n\">quoted</span><span class=\"p\">:</span> <span class=\"kc\">False</span><span class=\"p\">)),</span> <span class=\"n\">expression</span><span class=\"p\">:</span>\n    <span class=\"p\">(</span><span class=\"n\">COLUMN</span> <span class=\"n\">this</span><span class=\"p\">:</span>\n      <span class=\"p\">(</span><span class=\"n\">IDENTIFIER</span> <span class=\"n\">this</span><span class=\"p\">:</span> <span class=\"n\">b</span><span class=\"p\">,</span> <span class=\"n\">quoted</span><span class=\"p\">:</span> <span class=\"kc\">False</span><span class=\"p\">)))),</span>\n  <span class=\"n\">Move</span><span class=\"p\">(</span><span class=\"n\">expression</span><span class=\"o\">=</span><span class=\"p\">(</span><span class=\"n\">COLUMN</span> <span class=\"n\">this</span><span class=\"p\">:</span>\n    <span class=\"p\">(</span><span class=\"n\">IDENTIFIER</span> <span class=\"n\">this</span><span class=\"p\">:</span> <span class=\"n\">c</span><span class=\"p\">,</span> <span class=\"n\">quoted</span><span class=\"p\">:</span> <span class=\"kc\">False</span><span class=\"p\">))),</span>\n  <span class=\"n\">Keep</span><span class=\"p\">(</span><span class=\"n\">source</span><span class=\"o\">=</span><span class=\"p\">(</span><span class=\"n\">IDENTIFIER</span> <span class=\"n\">this</span><span class=\"p\">:</span> <span class=\"n\">b</span><span class=\"p\">,</span> <span class=\"n\">quoted</span><span class=\"p\">:</span> <span class=\"kc\">False</span><span class=\"p\">),</span> <span class=\"n\">target</span><span class=\"o\">=</span><span class=\"p\">(</span><span class=\"n\">IDENTIFIER</span> <span class=\"n\">this</span><span class=\"p\">:</span> <span class=\"n\">b</span><span class=\"p\">,</span> <span class=\"n\">quoted</span><span class=\"p\">:</span> <span class=\"kc\">False</span><span class=\"p\">)),</span>\n  <span class=\"o\">...</span>\n<span class=\"p\">]</span>\n</code></pre>\n</div>\n\n<p>See also: <a href=\"https://github.com/tobymao/sqlglot/blob/main/posts/sql_diff.md\">Semantic Diff for SQL</a>.</p>\n\n<h3 id=\"custom-dialects\">Custom Dialects</h3>\n\n<p><a href=\"https://github.com/tobymao/sqlglot/tree/main/sqlglot/dialects\">Dialects</a> can be added by subclassing <code>Dialect</code>:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"kn\">from</span> <span class=\"nn\">sqlglot</span> <span class=\"kn\">import</span> <span class=\"n\">exp</span>\n<span class=\"kn\">from</span> <span class=\"nn\">sqlglot.dialects.dialect</span> <span class=\"kn\">import</span> <span class=\"n\">Dialect</span>\n<span class=\"kn\">from</span> <span class=\"nn\">sqlglot.generator</span> <span class=\"kn\">import</span> <span class=\"n\">Generator</span>\n<span class=\"kn\">from</span> <span class=\"nn\">sqlglot.tokens</span> <span class=\"kn\">import</span> <span class=\"n\">Tokenizer</span><span class=\"p\">,</span> <span class=\"n\">TokenType</span>\n\n\n<span class=\"k\">class</span> <span class=\"nc\">Custom</span><span class=\"p\">(</span><span class=\"n\">Dialect</span><span class=\"p\">):</span>\n    <span class=\"k\">class</span> <span class=\"nc\">Tokenizer</span><span class=\"p\">(</span><span class=\"n\">Tokenizer</span><span class=\"p\">):</span>\n        <span class=\"n\">QUOTES</span> <span class=\"o\">=</span> <span class=\"p\">[</span><span class=\"s2\">&quot;&#39;&quot;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;&quot;&#39;</span><span class=\"p\">]</span>\n        <span class=\"n\">IDENTIFIERS</span> <span class=\"o\">=</span> <span class=\"p\">[</span><span class=\"s2\">&quot;`&quot;</span><span class=\"p\">]</span>\n\n        <span class=\"n\">KEYWORDS</span> <span class=\"o\">=</span> <span class=\"p\">{</span>\n            <span class=\"o\">**</span><span class=\"n\">Tokenizer</span><span class=\"o\">.</span><span class=\"n\">KEYWORDS</span><span class=\"p\">,</span>\n            <span class=\"s2\">&quot;INT64&quot;</span><span class=\"p\">:</span> <span class=\"n\">TokenType</span><span class=\"o\">.</span><span class=\"n\">BIGINT</span><span class=\"p\">,</span>\n            <span class=\"s2\">&quot;FLOAT64&quot;</span><span class=\"p\">:</span> <span class=\"n\">TokenType</span><span class=\"o\">.</span><span class=\"n\">DOUBLE</span><span class=\"p\">,</span>\n        <span class=\"p\">}</span>\n\n    <span class=\"k\">class</span> <span class=\"nc\">Generator</span><span class=\"p\">(</span><span class=\"n\">Generator</span><span class=\"p\">):</span>\n        <span class=\"n\">TRANSFORMS</span> <span class=\"o\">=</span> <span class=\"p\">{</span><span class=\"n\">exp</span><span class=\"o\">.</span><span class=\"n\">Array</span><span class=\"p\">:</span> <span class=\"k\">lambda</span> <span class=\"bp\">self</span><span class=\"p\">,</span> <span class=\"n\">e</span><span class=\"p\">:</span> <span class=\"sa\">f</span><span class=\"s2\">&quot;[</span><span class=\"si\">{</span><span class=\"bp\">self</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"p\">(</span><span class=\"n\">e</span><span class=\"p\">)</span><span class=\"si\">}</span><span class=\"s2\">]&quot;</span><span class=\"p\">}</span>\n\n        <span class=\"n\">TYPE_MAPPING</span> <span class=\"o\">=</span> <span class=\"p\">{</span>\n            <span class=\"n\">exp</span><span class=\"o\">.</span><span class=\"n\">DataType</span><span class=\"o\">.</span><span class=\"n\">Type</span><span class=\"o\">.</span><span class=\"n\">TINYINT</span><span class=\"p\">:</span> <span class=\"s2\">&quot;INT64&quot;</span><span class=\"p\">,</span>\n            <span class=\"n\">exp</span><span class=\"o\">.</span><span class=\"n\">DataType</span><span class=\"o\">.</span><span class=\"n\">Type</span><span class=\"o\">.</span><span class=\"n\">SMALLINT</span><span class=\"p\">:</span> <span class=\"s2\">&quot;INT64&quot;</span><span class=\"p\">,</span>\n            <span class=\"n\">exp</span><span class=\"o\">.</span><span class=\"n\">DataType</span><span class=\"o\">.</span><span class=\"n\">Type</span><span class=\"o\">.</span><span class=\"n\">INT</span><span class=\"p\">:</span> <span class=\"s2\">&quot;INT64&quot;</span><span class=\"p\">,</span>\n            <span class=\"n\">exp</span><span class=\"o\">.</span><span class=\"n\">DataType</span><span class=\"o\">.</span><span class=\"n\">Type</span><span class=\"o\">.</span><span class=\"n\">BIGINT</span><span class=\"p\">:</span> <span class=\"s2\">&quot;INT64&quot;</span><span class=\"p\">,</span>\n            <span class=\"n\">exp</span><span class=\"o\">.</span><span class=\"n\">DataType</span><span class=\"o\">.</span><span class=\"n\">Type</span><span class=\"o\">.</span><span class=\"n\">DECIMAL</span><span class=\"p\">:</span> <span class=\"s2\">&quot;NUMERIC&quot;</span><span class=\"p\">,</span>\n            <span class=\"n\">exp</span><span class=\"o\">.</span><span class=\"n\">DataType</span><span class=\"o\">.</span><span class=\"n\">Type</span><span class=\"o\">.</span><span class=\"n\">FLOAT</span><span class=\"p\">:</span> <span class=\"s2\">&quot;FLOAT64&quot;</span><span class=\"p\">,</span>\n            <span class=\"n\">exp</span><span class=\"o\">.</span><span class=\"n\">DataType</span><span class=\"o\">.</span><span class=\"n\">Type</span><span class=\"o\">.</span><span class=\"n\">DOUBLE</span><span class=\"p\">:</span> <span class=\"s2\">&quot;FLOAT64&quot;</span><span class=\"p\">,</span>\n            <span class=\"n\">exp</span><span class=\"o\">.</span><span class=\"n\">DataType</span><span class=\"o\">.</span><span class=\"n\">Type</span><span class=\"o\">.</span><span class=\"n\">BOOLEAN</span><span class=\"p\">:</span> <span class=\"s2\">&quot;BOOL&quot;</span><span class=\"p\">,</span>\n            <span class=\"n\">exp</span><span class=\"o\">.</span><span class=\"n\">DataType</span><span class=\"o\">.</span><span class=\"n\">Type</span><span class=\"o\">.</span><span class=\"n\">TEXT</span><span class=\"p\">:</span> <span class=\"s2\">&quot;STRING&quot;</span><span class=\"p\">,</span>\n        <span class=\"p\">}</span>\n\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"n\">Dialect</span><span class=\"p\">[</span><span class=\"s2\">&quot;custom&quot;</span><span class=\"p\">])</span>\n</code></pre>\n</div>\n\n<pre><code>&lt;class '__main__.Custom'&gt;\n</code></pre>\n\n<h3 id=\"sql-execution\">SQL Execution</h3>\n\n<p>One can even interpret SQL queries using SQLGlot, where the tables are represented as Python dictionaries. Although the engine is not very fast (it's not supposed to be) and is in a relatively early stage of development, it can be useful for unit testing and running SQL natively across Python objects. Additionally, the foundation can be easily integrated with fast compute kernels (arrow, pandas). Below is an example showcasing the execution of a SELECT expression that involves aggregations and JOINs:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"kn\">from</span> <span class=\"nn\">sqlglot.executor</span> <span class=\"kn\">import</span> <span class=\"n\">execute</span>\n\n<span class=\"n\">tables</span> <span class=\"o\">=</span> <span class=\"p\">{</span>\n    <span class=\"s2\">&quot;sushi&quot;</span><span class=\"p\">:</span> <span class=\"p\">[</span>\n        <span class=\"p\">{</span><span class=\"s2\">&quot;id&quot;</span><span class=\"p\">:</span> <span class=\"mi\">1</span><span class=\"p\">,</span> <span class=\"s2\">&quot;price&quot;</span><span class=\"p\">:</span> <span class=\"mf\">1.0</span><span class=\"p\">},</span>\n        <span class=\"p\">{</span><span class=\"s2\">&quot;id&quot;</span><span class=\"p\">:</span> <span class=\"mi\">2</span><span class=\"p\">,</span> <span class=\"s2\">&quot;price&quot;</span><span class=\"p\">:</span> <span class=\"mf\">2.0</span><span class=\"p\">},</span>\n        <span class=\"p\">{</span><span class=\"s2\">&quot;id&quot;</span><span class=\"p\">:</span> <span class=\"mi\">3</span><span class=\"p\">,</span> <span class=\"s2\">&quot;price&quot;</span><span class=\"p\">:</span> <span class=\"mf\">3.0</span><span class=\"p\">},</span>\n    <span class=\"p\">],</span>\n    <span class=\"s2\">&quot;order_items&quot;</span><span class=\"p\">:</span> <span class=\"p\">[</span>\n        <span class=\"p\">{</span><span class=\"s2\">&quot;sushi_id&quot;</span><span class=\"p\">:</span> <span class=\"mi\">1</span><span class=\"p\">,</span> <span class=\"s2\">&quot;order_id&quot;</span><span class=\"p\">:</span> <span class=\"mi\">1</span><span class=\"p\">},</span>\n        <span class=\"p\">{</span><span class=\"s2\">&quot;sushi_id&quot;</span><span class=\"p\">:</span> <span class=\"mi\">1</span><span class=\"p\">,</span> <span class=\"s2\">&quot;order_id&quot;</span><span class=\"p\">:</span> <span class=\"mi\">1</span><span class=\"p\">},</span>\n        <span class=\"p\">{</span><span class=\"s2\">&quot;sushi_id&quot;</span><span class=\"p\">:</span> <span class=\"mi\">2</span><span class=\"p\">,</span> <span class=\"s2\">&quot;order_id&quot;</span><span class=\"p\">:</span> <span class=\"mi\">1</span><span class=\"p\">},</span>\n        <span class=\"p\">{</span><span class=\"s2\">&quot;sushi_id&quot;</span><span class=\"p\">:</span> <span class=\"mi\">3</span><span class=\"p\">,</span> <span class=\"s2\">&quot;order_id&quot;</span><span class=\"p\">:</span> <span class=\"mi\">2</span><span class=\"p\">},</span>\n    <span class=\"p\">],</span>\n    <span class=\"s2\">&quot;orders&quot;</span><span class=\"p\">:</span> <span class=\"p\">[</span>\n        <span class=\"p\">{</span><span class=\"s2\">&quot;id&quot;</span><span class=\"p\">:</span> <span class=\"mi\">1</span><span class=\"p\">,</span> <span class=\"s2\">&quot;user_id&quot;</span><span class=\"p\">:</span> <span class=\"mi\">1</span><span class=\"p\">},</span>\n        <span class=\"p\">{</span><span class=\"s2\">&quot;id&quot;</span><span class=\"p\">:</span> <span class=\"mi\">2</span><span class=\"p\">,</span> <span class=\"s2\">&quot;user_id&quot;</span><span class=\"p\">:</span> <span class=\"mi\">2</span><span class=\"p\">},</span>\n    <span class=\"p\">],</span>\n<span class=\"p\">}</span>\n\n<span class=\"n\">execute</span><span class=\"p\">(</span>\n<span class=\"w\">    </span><span class=\"sd\">&quot;&quot;&quot;</span>\n<span class=\"sd\">    SELECT</span>\n<span class=\"sd\">      o.user_id,</span>\n<span class=\"sd\">      SUM(s.price) AS price</span>\n<span class=\"sd\">    FROM orders o</span>\n<span class=\"sd\">    JOIN order_items i</span>\n<span class=\"sd\">      ON o.id = i.order_id</span>\n<span class=\"sd\">    JOIN sushi s</span>\n<span class=\"sd\">      ON i.sushi_id = s.id</span>\n<span class=\"sd\">    GROUP BY o.user_id</span>\n<span class=\"sd\">    &quot;&quot;&quot;</span><span class=\"p\">,</span>\n    <span class=\"n\">tables</span><span class=\"o\">=</span><span class=\"n\">tables</span>\n<span class=\"p\">)</span>\n</code></pre>\n</div>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"n\">user_id</span> <span class=\"n\">price</span>\n      <span class=\"mi\">1</span>   <span class=\"mf\">4.0</span>\n      <span class=\"mi\">2</span>   <span class=\"mf\">3.0</span>\n</code></pre>\n</div>\n\n<p>See also: <a href=\"https://github.com/tobymao/sqlglot/blob/main/posts/python_sql_engine.md\">Writing a Python SQL engine from scratch</a>.</p>\n\n<h2 id=\"used-by\">Used By</h2>\n\n<ul>\n<li><a href=\"https://github.com/TobikoData/sqlmesh\">SQLMesh</a></li>\n<li><a href=\"https://github.com/fugue-project/fugue\">Fugue</a></li>\n<li><a href=\"https://github.com/ibis-project/ibis\">ibis</a></li>\n<li><a href=\"https://github.com/kelsin/mysql-mimic\">mysql-mimic</a></li>\n<li><a href=\"https://github.com/pinterest/querybook\">Querybook</a></li>\n<li><a href=\"https://github.com/marsupialtail/quokka\">Quokka</a></li>\n<li><a href=\"https://github.com/moj-analytical-services/splink\">Splink</a></li>\n</ul>\n\n<h2 id=\"documentation\">Documentation</h2>\n\n<p>SQLGlot uses <a href=\"https://pdoc.dev/\">pdoc</a> to serve its API documentation.</p>\n\n<p>A hosted version is on the <a href=\"https://sqlglot.com/\">SQLGlot website</a>, or you can build locally with:</p>\n\n<pre><code>make docs-serve\n</code></pre>\n\n<h2 id=\"run-tests-and-lint\">Run Tests and Lint</h2>\n\n<pre><code>make style  # Only linter checks\nmake unit   # Only unit tests\nmake check  # Full test suite &amp; linter checks\n</code></pre>\n\n<h2 id=\"benchmarks\">Benchmarks</h2>\n\n<p><a href=\"https://github.com/tobymao/sqlglot/blob/main/benchmarks/bench.py\">Benchmarks</a> run on Python 3.10.5 in seconds.</p>\n\n<table>\n<thead>\n<tr>\n  <th>Query</th>\n  <th>sqlglot</th>\n  <th>sqlfluff</th>\n  <th>sqltree</th>\n  <th>sqlparse</th>\n  <th>moz_sql_parser</th>\n  <th>sqloxide</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>tpch</td>\n  <td>0.01308 (1.0)</td>\n  <td>1.60626 (122.7)</td>\n  <td>0.01168 (0.893)</td>\n  <td>0.04958 (3.791)</td>\n  <td>0.08543 (6.531)</td>\n  <td>0.00136 (0.104)</td>\n</tr>\n<tr>\n  <td>short</td>\n  <td>0.00109 (1.0)</td>\n  <td>0.14134 (129.2)</td>\n  <td>0.00099 (0.906)</td>\n  <td>0.00342 (3.131)</td>\n  <td>0.00652 (5.970)</td>\n  <td>8.76E-5 (0.080)</td>\n</tr>\n<tr>\n  <td>long</td>\n  <td>0.01399 (1.0)</td>\n  <td>2.12632 (151.9)</td>\n  <td>0.01126 (0.805)</td>\n  <td>0.04410 (3.151)</td>\n  <td>0.06671 (4.767)</td>\n  <td>0.00107 (0.076)</td>\n</tr>\n<tr>\n  <td>crazy</td>\n  <td>0.03969 (1.0)</td>\n  <td>24.3777 (614.1)</td>\n  <td>0.03917 (0.987)</td>\n  <td>11.7043 (294.8)</td>\n  <td>1.03280 (26.02)</td>\n  <td>0.00625 (0.157)</td>\n</tr>\n</tbody>\n</table>\n\n<h2 id=\"optional-dependencies\">Optional Dependencies</h2>\n\n<p>SQLGlot uses <a href=\"https://github.com/dateutil/dateutil\">dateutil</a> to simplify literal timedelta expressions. The optimizer will not simplify expressions like the following if the module cannot be found:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"n\">x</span><span class=\"w\"> </span><span class=\"o\">+</span><span class=\"w\"> </span><span class=\"nb\">interval</span><span class=\"w\"> </span><span class=\"s1\">&#39;1&#39;</span><span class=\"w\"> </span><span class=\"k\">month</span>\n</code></pre>\n</div>\n\n<hr />\n"}, "sqlglot.logger": {"fullname": "sqlglot.logger", "modulename": "sqlglot", "qualname": "logger", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Logger sqlglot (WARNING)&gt;"}, "sqlglot.pretty": {"fullname": "sqlglot.pretty", "modulename": "sqlglot", "qualname": "pretty", "kind": "variable", "doc": "<p>Whether to format generated SQL by default.</p>\n", "default_value": "False"}, "sqlglot.schema": {"fullname": "sqlglot.schema", "modulename": "sqlglot.schema", "kind": "module", "doc": "<p></p>\n"}, "sqlglot.parse": {"fullname": "sqlglot.parse", "modulename": "sqlglot", "qualname": "parse", "kind": "function", "doc": "<p>Parses the given SQL string into a collection of syntax trees, one per parsed SQL statement.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>sql:</strong>  the SQL code string to parse.</li>\n<li><strong>read:</strong>  the SQL dialect to apply during parsing (eg. \"spark\", \"hive\", \"presto\", \"mysql\").</li>\n<li><strong>dialect:</strong>  the SQL dialect (alias for read).</li>\n<li><strong>**opts:</strong>  other <code>sqlglot.parser.Parser</code> options.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The resulting syntax tree collection.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">sql</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">read</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">dialect</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">opts</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "sqlglot.parse_one": {"fullname": "sqlglot.parse_one", "modulename": "sqlglot", "qualname": "parse_one", "kind": "function", "doc": "<p>Parses the given SQL string and returns a syntax tree for the first parsed SQL statement.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>sql:</strong>  the SQL code string to parse.</li>\n<li><strong>read:</strong>  the SQL dialect to apply during parsing (eg. \"spark\", \"hive\", \"presto\", \"mysql\").</li>\n<li><strong>dialect:</strong>  the SQL dialect (alias for read)</li>\n<li><strong>into:</strong>  the SQLGlot Expression to parse into.</li>\n<li><strong>**opts:</strong>  other <code>sqlglot.parser.Parser</code> options.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The syntax tree for the first parsed statement.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">sql</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">read</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">dialect</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">into</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">],</span> <span class=\"n\">Collection</span><span class=\"p\">[</span><span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">]]],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">opts</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span>:</span></span>", "funcdef": "def"}, "sqlglot.transpile": {"fullname": "sqlglot.transpile", "modulename": "sqlglot", "qualname": "transpile", "kind": "function", "doc": "<p>Parses the given SQL string in accordance with the source dialect and returns a list of SQL strings transformed\nto conform to the target dialect. Each string in the returned list represents a single transformed SQL statement.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>sql:</strong>  the SQL code string to transpile.</li>\n<li><strong>read:</strong>  the source dialect used to parse the input string (eg. \"spark\", \"hive\", \"presto\", \"mysql\").</li>\n<li><strong>write:</strong>  the target dialect into which the input should be transformed (eg. \"spark\", \"hive\", \"presto\", \"mysql\").</li>\n<li><strong>identity:</strong>  if set to <code>True</code> and if the target dialect is not specified the source dialect will be used as both:\nthe source and the target dialect.</li>\n<li><strong>error_level:</strong>  the desired error level of the parser.</li>\n<li><strong>**opts:</strong>  other <code>sqlglot.generator.Generator</code> options.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The list of transpiled SQL statements.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">sql</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">read</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">write</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">identity</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">error_level</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">errors</span><span class=\"o\">.</span><span class=\"n\">ErrorLevel</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">opts</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe": {"fullname": "sqlglot.dataframe", "modulename": "sqlglot.dataframe", "kind": "module", "doc": "<h1 id=\"pyspark-dataframe-sql-generator\">PySpark DataFrame SQL Generator</h1>\n\n<p>This is a drop-in replacement for the PySpark DataFrame API that will generate SQL instead of executing DataFrame operations directly. This, when combined with the transpiling support in SQLGlot, allows one to write PySpark DataFrame code and execute it on other engines like <a href=\"https://duckdb.org/\">DuckDB</a>, <a href=\"https://prestodb.io/\">Presto</a>, <a href=\"https://spark.apache.org/\">Spark</a>, <a href=\"https://www.snowflake.com/en/\">Snowflake</a>, and <a href=\"https://cloud.google.com/bigquery/\">BigQuery</a>. </p>\n\n<p>Currently many of the common operations are covered and more functionality will be added over time. Please <a href=\"https://github.com/tobymao/sqlglot/issues\">open an issue</a> or <a href=\"https://github.com/tobymao/sqlglot/pulls\">PR</a> with your feedback or contribution to help influence what should be prioritized next and make sure your use case is properly supported.</p>\n\n<h1 id=\"how-to-use\">How to use</h1>\n\n<h2 id=\"instructions\">Instructions</h2>\n\n<ul>\n<li><a href=\"https://github.com/tobymao/sqlglot/blob/main/README.md#install\">Install SQLGlot</a> and that is all that is required to just generate SQL. <a href=\"#examples\">The examples</a> show generating SQL and then executing that SQL on a specific engine and that will require that engine's client library.</li>\n<li>Find/replace all <code>from pyspark.sql</code> with <code>from sqlglot.dataframe</code>.</li>\n<li>Prior to any <code>spark.read.table</code> or <code>spark.table</code> run <code>sqlglot.schema.add_table('&lt;table_name&gt;', &lt;column_structure&gt;, dialect=\"spark\")</code>.\n<ul>\n<li>The column structure can be defined the following ways:\n<ul>\n<li>Dictionary where the keys are column names and values are string of the Spark SQL type name.\n<ul>\n<li>Ex: <code>{'cola': 'string', 'colb': 'int'}</code></li>\n</ul></li>\n<li>PySpark DataFrame <code>StructType</code> similar to when using <code>createDataFrame</code>.\n<ul>\n<li>Ex: <code>StructType([StructField('cola', StringType()), StructField('colb', IntegerType())])</code></li>\n</ul></li>\n<li>A string of names and types similar to what is supported in <code>createDataFrame</code>.\n<ul>\n<li>Ex: <code>cola: STRING, colb: INT</code></li>\n</ul></li>\n<li>[Not Recommended] A list of string column names without type.\n<ul>\n<li>Ex: <code>['cola', 'colb']</code></li>\n<li>The lack of types may limit functionality in future releases.</li>\n</ul></li>\n</ul></li>\n<li>See <a href=\"#registering-custom-schema-class\">Registering Custom Schema</a> for information on how to skip this step if the information is stored externally.</li>\n</ul></li>\n<li>If your output SQL dialect is not Spark, then configure the SparkSession to use that dialect\n<ul>\n<li>Ex: <code>SparkSession().builder.config(\"sqlframe.dialect\", \"bigquery\").getOrCreate()</code></li>\n<li>See <a href=\"https://github.com/tobymao/sqlglot/tree/main/sqlglot/dialects\">dialects</a> for a full list of dialects.</li>\n</ul></li>\n<li>Add <code>.sql(pretty=True)</code> to your final DataFrame command to return a list of sql statements to run that command.\n<ul>\n<li>In most cases a single SQL statement is returned. Currently the only exception is when caching DataFrames which isn't supported in other dialects.</li>\n<li>Ex: <code>.sql(pretty=True)</code></li>\n</ul></li>\n</ul>\n\n<h2 id=\"examples\">Examples</h2>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"kn\">import</span> <span class=\"nn\">sqlglot</span>\n<span class=\"kn\">from</span> <span class=\"nn\">sqlglot.dataframe.sql.session</span> <span class=\"kn\">import</span> <span class=\"n\">SparkSession</span>\n<span class=\"kn\">from</span> <span class=\"nn\">sqlglot.dataframe.sql</span> <span class=\"kn\">import</span> <span class=\"n\">functions</span> <span class=\"k\">as</span> <span class=\"n\">F</span>\n\n<span class=\"n\">dialect</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;spark&quot;</span>\n\n<span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">schema</span><span class=\"o\">.</span><span class=\"n\">add_table</span><span class=\"p\">(</span>\n  <span class=\"s1\">&#39;employee&#39;</span><span class=\"p\">,</span>\n  <span class=\"p\">{</span>\n    <span class=\"s1\">&#39;employee_id&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;INT&#39;</span><span class=\"p\">,</span>\n    <span class=\"s1\">&#39;fname&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;STRING&#39;</span><span class=\"p\">,</span>\n    <span class=\"s1\">&#39;lname&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;STRING&#39;</span><span class=\"p\">,</span>\n    <span class=\"s1\">&#39;age&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;INT&#39;</span><span class=\"p\">,</span>\n  <span class=\"p\">},</span>\n  <span class=\"n\">dialect</span><span class=\"o\">=</span><span class=\"n\">dialect</span><span class=\"p\">,</span>\n<span class=\"p\">)</span>  <span class=\"c1\"># Register the table structure prior to reading from the table</span>\n\n<span class=\"n\">spark</span> <span class=\"o\">=</span> <span class=\"n\">SparkSession</span><span class=\"o\">.</span><span class=\"n\">builder</span><span class=\"o\">.</span><span class=\"n\">config</span><span class=\"p\">(</span><span class=\"s2\">&quot;sqlframe.dialect&quot;</span><span class=\"p\">,</span> <span class=\"n\">dialect</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">getOrCreate</span><span class=\"p\">()</span>\n\n<span class=\"n\">df</span> <span class=\"o\">=</span> <span class=\"p\">(</span>\n    <span class=\"n\">spark</span>\n    <span class=\"o\">.</span><span class=\"n\">table</span><span class=\"p\">(</span><span class=\"s1\">&#39;employee&#39;</span><span class=\"p\">)</span>\n    <span class=\"o\">.</span><span class=\"n\">groupBy</span><span class=\"p\">(</span><span class=\"n\">F</span><span class=\"o\">.</span><span class=\"n\">col</span><span class=\"p\">(</span><span class=\"s2\">&quot;age&quot;</span><span class=\"p\">))</span>\n    <span class=\"o\">.</span><span class=\"n\">agg</span><span class=\"p\">(</span><span class=\"n\">F</span><span class=\"o\">.</span><span class=\"n\">countDistinct</span><span class=\"p\">(</span><span class=\"n\">F</span><span class=\"o\">.</span><span class=\"n\">col</span><span class=\"p\">(</span><span class=\"s2\">&quot;employee_id&quot;</span><span class=\"p\">))</span><span class=\"o\">.</span><span class=\"n\">alias</span><span class=\"p\">(</span><span class=\"s2\">&quot;num_employees&quot;</span><span class=\"p\">))</span> \n<span class=\"p\">)</span>\n\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"n\">df</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">(</span><span class=\"n\">pretty</span><span class=\"o\">=</span><span class=\"kc\">True</span><span class=\"p\">))</span>\n</code></pre>\n</div>\n\n<pre><code>SELECT\n  `employee`.`age` AS `age`,\n  COUNT(DISTINCT `employee`.`employee_id`) AS `num_employees`\nFROM `employee` AS `employee`\nGROUP BY\n  `employee`.`age`\n</code></pre>\n\n<h2 id=\"registering-custom-schema-class\">Registering Custom Schema Class</h2>\n\n<p>The step of adding <code>sqlglot.schema.add_table</code> can be skipped if you have the column structure stored externally like in a file or from an external metadata table. This can be done by writing a class that implements the <code>sqlglot.schema.Schema</code> abstract class and then assigning that class to <code>sqlglot.schema</code>. </p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"kn\">import</span> <span class=\"nn\">sqlglot</span>\n<span class=\"kn\">from</span> <span class=\"nn\">sqlglot.dataframe.sql.session</span> <span class=\"kn\">import</span> <span class=\"n\">SparkSession</span>\n<span class=\"kn\">from</span> <span class=\"nn\">sqlglot.dataframe.sql</span> <span class=\"kn\">import</span> <span class=\"n\">functions</span> <span class=\"k\">as</span> <span class=\"n\">F</span>\n<span class=\"kn\">from</span> <span class=\"nn\">sqlglot.schema</span> <span class=\"kn\">import</span> <span class=\"n\">Schema</span>\n\n\n<span class=\"k\">class</span> <span class=\"nc\">ExternalSchema</span><span class=\"p\">(</span><span class=\"n\">Schema</span><span class=\"p\">):</span>\n  <span class=\"o\">...</span>\n\n<span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">schema</span> <span class=\"o\">=</span> <span class=\"n\">ExternalSchema</span><span class=\"p\">()</span>\n\n<span class=\"n\">spark</span> <span class=\"o\">=</span> <span class=\"n\">SparkSession</span><span class=\"p\">()</span>  <span class=\"c1\"># Spark will be used by default is not specific in SparkSession config</span>\n\n<span class=\"n\">df</span> <span class=\"o\">=</span> <span class=\"p\">(</span>\n    <span class=\"n\">spark</span>\n    <span class=\"o\">.</span><span class=\"n\">table</span><span class=\"p\">(</span><span class=\"s1\">&#39;employee&#39;</span><span class=\"p\">)</span>\n    <span class=\"o\">.</span><span class=\"n\">groupBy</span><span class=\"p\">(</span><span class=\"n\">F</span><span class=\"o\">.</span><span class=\"n\">col</span><span class=\"p\">(</span><span class=\"s2\">&quot;age&quot;</span><span class=\"p\">))</span>\n    <span class=\"o\">.</span><span class=\"n\">agg</span><span class=\"p\">(</span><span class=\"n\">F</span><span class=\"o\">.</span><span class=\"n\">countDistinct</span><span class=\"p\">(</span><span class=\"n\">F</span><span class=\"o\">.</span><span class=\"n\">col</span><span class=\"p\">(</span><span class=\"s2\">&quot;employee_id&quot;</span><span class=\"p\">))</span><span class=\"o\">.</span><span class=\"n\">alias</span><span class=\"p\">(</span><span class=\"s2\">&quot;num_employees&quot;</span><span class=\"p\">))</span> \n<span class=\"p\">)</span>\n\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"n\">df</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">(</span><span class=\"n\">pretty</span><span class=\"o\">=</span><span class=\"kc\">True</span><span class=\"p\">))</span>\n</code></pre>\n</div>\n\n<h2 id=\"example-implementations\">Example Implementations</h2>\n\n<h3 id=\"bigquery\">Bigquery</h3>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"kn\">from</span> <span class=\"nn\">google.cloud</span> <span class=\"kn\">import</span> <span class=\"n\">bigquery</span>\n<span class=\"kn\">from</span> <span class=\"nn\">sqlglot.dataframe.sql.session</span> <span class=\"kn\">import</span> <span class=\"n\">SparkSession</span>\n<span class=\"kn\">from</span> <span class=\"nn\">sqlglot.dataframe.sql</span> <span class=\"kn\">import</span> <span class=\"n\">types</span>\n<span class=\"kn\">from</span> <span class=\"nn\">sqlglot.dataframe.sql</span> <span class=\"kn\">import</span> <span class=\"n\">functions</span> <span class=\"k\">as</span> <span class=\"n\">F</span>\n\n<span class=\"n\">client</span> <span class=\"o\">=</span> <span class=\"n\">bigquery</span><span class=\"o\">.</span><span class=\"n\">Client</span><span class=\"p\">()</span>\n\n<span class=\"n\">data</span> <span class=\"o\">=</span> <span class=\"p\">[</span>\n    <span class=\"p\">(</span><span class=\"mi\">1</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Jack&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Shephard&quot;</span><span class=\"p\">,</span> <span class=\"mi\">34</span><span class=\"p\">),</span>\n    <span class=\"p\">(</span><span class=\"mi\">2</span><span class=\"p\">,</span> <span class=\"s2\">&quot;John&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Locke&quot;</span><span class=\"p\">,</span> <span class=\"mi\">48</span><span class=\"p\">),</span>\n    <span class=\"p\">(</span><span class=\"mi\">3</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Kate&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Austen&quot;</span><span class=\"p\">,</span> <span class=\"mi\">34</span><span class=\"p\">),</span>\n    <span class=\"p\">(</span><span class=\"mi\">4</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Claire&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Littleton&quot;</span><span class=\"p\">,</span> <span class=\"mi\">22</span><span class=\"p\">),</span>\n    <span class=\"p\">(</span><span class=\"mi\">5</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Hugo&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Reyes&quot;</span><span class=\"p\">,</span> <span class=\"mi\">26</span><span class=\"p\">),</span>\n<span class=\"p\">]</span>\n<span class=\"n\">schema</span> <span class=\"o\">=</span> <span class=\"n\">types</span><span class=\"o\">.</span><span class=\"n\">StructType</span><span class=\"p\">([</span>\n    <span class=\"n\">types</span><span class=\"o\">.</span><span class=\"n\">StructField</span><span class=\"p\">(</span><span class=\"s1\">&#39;employee_id&#39;</span><span class=\"p\">,</span> <span class=\"n\">types</span><span class=\"o\">.</span><span class=\"n\">IntegerType</span><span class=\"p\">(),</span> <span class=\"kc\">False</span><span class=\"p\">),</span>\n    <span class=\"n\">types</span><span class=\"o\">.</span><span class=\"n\">StructField</span><span class=\"p\">(</span><span class=\"s1\">&#39;fname&#39;</span><span class=\"p\">,</span> <span class=\"n\">types</span><span class=\"o\">.</span><span class=\"n\">StringType</span><span class=\"p\">(),</span> <span class=\"kc\">False</span><span class=\"p\">),</span>\n    <span class=\"n\">types</span><span class=\"o\">.</span><span class=\"n\">StructField</span><span class=\"p\">(</span><span class=\"s1\">&#39;lname&#39;</span><span class=\"p\">,</span> <span class=\"n\">types</span><span class=\"o\">.</span><span class=\"n\">StringType</span><span class=\"p\">(),</span> <span class=\"kc\">False</span><span class=\"p\">),</span>\n    <span class=\"n\">types</span><span class=\"o\">.</span><span class=\"n\">StructField</span><span class=\"p\">(</span><span class=\"s1\">&#39;age&#39;</span><span class=\"p\">,</span> <span class=\"n\">types</span><span class=\"o\">.</span><span class=\"n\">IntegerType</span><span class=\"p\">(),</span> <span class=\"kc\">False</span><span class=\"p\">),</span>\n<span class=\"p\">])</span>\n\n<span class=\"n\">sql_statements</span> <span class=\"o\">=</span> <span class=\"p\">(</span>\n    <span class=\"n\">SparkSession</span>\n    <span class=\"o\">.</span><span class=\"n\">builder</span>\n    <span class=\"o\">.</span><span class=\"n\">config</span><span class=\"p\">(</span><span class=\"s2\">&quot;sqlframe.dialect&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;bigquery&quot;</span><span class=\"p\">)</span>\n    <span class=\"o\">.</span><span class=\"n\">getOrCreate</span><span class=\"p\">()</span>\n    <span class=\"o\">.</span><span class=\"n\">createDataFrame</span><span class=\"p\">(</span><span class=\"n\">data</span><span class=\"p\">,</span> <span class=\"n\">schema</span><span class=\"p\">)</span>\n    <span class=\"o\">.</span><span class=\"n\">groupBy</span><span class=\"p\">(</span><span class=\"n\">F</span><span class=\"o\">.</span><span class=\"n\">col</span><span class=\"p\">(</span><span class=\"s2\">&quot;age&quot;</span><span class=\"p\">))</span>\n    <span class=\"o\">.</span><span class=\"n\">agg</span><span class=\"p\">(</span><span class=\"n\">F</span><span class=\"o\">.</span><span class=\"n\">countDistinct</span><span class=\"p\">(</span><span class=\"n\">F</span><span class=\"o\">.</span><span class=\"n\">col</span><span class=\"p\">(</span><span class=\"s2\">&quot;employee_id&quot;</span><span class=\"p\">))</span><span class=\"o\">.</span><span class=\"n\">alias</span><span class=\"p\">(</span><span class=\"s2\">&quot;num_employees&quot;</span><span class=\"p\">))</span>\n    <span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">()</span>\n<span class=\"p\">)</span>\n\n<span class=\"n\">result</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>\n<span class=\"k\">for</span> <span class=\"n\">sql</span> <span class=\"ow\">in</span> <span class=\"n\">sql_statements</span><span class=\"p\">:</span>\n  <span class=\"n\">result</span> <span class=\"o\">=</span> <span class=\"n\">client</span><span class=\"o\">.</span><span class=\"n\">query</span><span class=\"p\">(</span><span class=\"n\">sql</span><span class=\"p\">)</span>\n\n<span class=\"k\">assert</span> <span class=\"n\">result</span> <span class=\"ow\">is</span> <span class=\"ow\">not</span> <span class=\"kc\">None</span>\n<span class=\"k\">for</span> <span class=\"n\">row</span> <span class=\"ow\">in</span> <span class=\"n\">client</span><span class=\"o\">.</span><span class=\"n\">query</span><span class=\"p\">(</span><span class=\"n\">result</span><span class=\"p\">):</span>\n    <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"sa\">f</span><span class=\"s2\">&quot;Age: </span><span class=\"si\">{</span><span class=\"n\">row</span><span class=\"p\">[</span><span class=\"s1\">&#39;age&#39;</span><span class=\"p\">]</span><span class=\"si\">}</span><span class=\"s2\">, Num Employees: </span><span class=\"si\">{</span><span class=\"n\">row</span><span class=\"p\">[</span><span class=\"s1\">&#39;num_employees&#39;</span><span class=\"p\">]</span><span class=\"si\">}</span><span class=\"s2\">&quot;</span><span class=\"p\">)</span>\n</code></pre>\n</div>\n\n<h3 id=\"snowflake\">Snowflake</h3>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"kn\">import</span> <span class=\"nn\">os</span>\n\n<span class=\"kn\">import</span> <span class=\"nn\">snowflake.connector</span>\n<span class=\"kn\">from</span> <span class=\"nn\">sqlglot.dataframe.session</span> <span class=\"kn\">import</span> <span class=\"n\">SparkSession</span>\n<span class=\"kn\">from</span> <span class=\"nn\">sqlglot.dataframe</span> <span class=\"kn\">import</span> <span class=\"n\">types</span>\n<span class=\"kn\">from</span> <span class=\"nn\">sqlglot.dataframe</span> <span class=\"kn\">import</span> <span class=\"n\">functions</span> <span class=\"k\">as</span> <span class=\"n\">F</span>\n\n<span class=\"n\">ctx</span> <span class=\"o\">=</span> <span class=\"n\">snowflake</span><span class=\"o\">.</span><span class=\"n\">connector</span><span class=\"o\">.</span><span class=\"n\">connect</span><span class=\"p\">(</span>\n    <span class=\"n\">user</span><span class=\"o\">=</span><span class=\"n\">os</span><span class=\"o\">.</span><span class=\"n\">environ</span><span class=\"p\">[</span><span class=\"s2\">&quot;SNOWFLAKE_USER&quot;</span><span class=\"p\">],</span>\n    <span class=\"n\">password</span><span class=\"o\">=</span><span class=\"n\">os</span><span class=\"o\">.</span><span class=\"n\">environ</span><span class=\"p\">[</span><span class=\"s2\">&quot;SNOWFLAKE_PASS&quot;</span><span class=\"p\">],</span>\n    <span class=\"n\">account</span><span class=\"o\">=</span><span class=\"n\">os</span><span class=\"o\">.</span><span class=\"n\">environ</span><span class=\"p\">[</span><span class=\"s2\">&quot;SNOWFLAKE_ACCOUNT&quot;</span><span class=\"p\">]</span>\n<span class=\"p\">)</span>\n<span class=\"n\">cs</span> <span class=\"o\">=</span> <span class=\"n\">ctx</span><span class=\"o\">.</span><span class=\"n\">cursor</span><span class=\"p\">()</span>\n\n<span class=\"n\">data</span> <span class=\"o\">=</span> <span class=\"p\">[</span>\n    <span class=\"p\">(</span><span class=\"mi\">1</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Jack&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Shephard&quot;</span><span class=\"p\">,</span> <span class=\"mi\">34</span><span class=\"p\">),</span>\n    <span class=\"p\">(</span><span class=\"mi\">2</span><span class=\"p\">,</span> <span class=\"s2\">&quot;John&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Locke&quot;</span><span class=\"p\">,</span> <span class=\"mi\">48</span><span class=\"p\">),</span>\n    <span class=\"p\">(</span><span class=\"mi\">3</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Kate&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Austen&quot;</span><span class=\"p\">,</span> <span class=\"mi\">34</span><span class=\"p\">),</span>\n    <span class=\"p\">(</span><span class=\"mi\">4</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Claire&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Littleton&quot;</span><span class=\"p\">,</span> <span class=\"mi\">22</span><span class=\"p\">),</span>\n    <span class=\"p\">(</span><span class=\"mi\">5</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Hugo&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Reyes&quot;</span><span class=\"p\">,</span> <span class=\"mi\">26</span><span class=\"p\">),</span>\n<span class=\"p\">]</span>\n<span class=\"n\">schema</span> <span class=\"o\">=</span> <span class=\"n\">types</span><span class=\"o\">.</span><span class=\"n\">StructType</span><span class=\"p\">([</span>\n    <span class=\"n\">types</span><span class=\"o\">.</span><span class=\"n\">StructField</span><span class=\"p\">(</span><span class=\"s1\">&#39;employee_id&#39;</span><span class=\"p\">,</span> <span class=\"n\">types</span><span class=\"o\">.</span><span class=\"n\">IntegerType</span><span class=\"p\">(),</span> <span class=\"kc\">False</span><span class=\"p\">),</span>\n    <span class=\"n\">types</span><span class=\"o\">.</span><span class=\"n\">StructField</span><span class=\"p\">(</span><span class=\"s1\">&#39;fname&#39;</span><span class=\"p\">,</span> <span class=\"n\">types</span><span class=\"o\">.</span><span class=\"n\">StringType</span><span class=\"p\">(),</span> <span class=\"kc\">False</span><span class=\"p\">),</span>\n    <span class=\"n\">types</span><span class=\"o\">.</span><span class=\"n\">StructField</span><span class=\"p\">(</span><span class=\"s1\">&#39;lname&#39;</span><span class=\"p\">,</span> <span class=\"n\">types</span><span class=\"o\">.</span><span class=\"n\">StringType</span><span class=\"p\">(),</span> <span class=\"kc\">False</span><span class=\"p\">),</span>\n    <span class=\"n\">types</span><span class=\"o\">.</span><span class=\"n\">StructField</span><span class=\"p\">(</span><span class=\"s1\">&#39;age&#39;</span><span class=\"p\">,</span> <span class=\"n\">types</span><span class=\"o\">.</span><span class=\"n\">IntegerType</span><span class=\"p\">(),</span> <span class=\"kc\">False</span><span class=\"p\">),</span>\n<span class=\"p\">])</span>\n\n<span class=\"n\">sql_statements</span> <span class=\"o\">=</span> <span class=\"p\">(</span>\n    <span class=\"n\">SparkSession</span>\n    <span class=\"o\">.</span><span class=\"n\">builder</span>\n    <span class=\"o\">.</span><span class=\"n\">config</span><span class=\"p\">(</span><span class=\"s2\">&quot;sqlframe.dialect&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;snowflake&quot;</span><span class=\"p\">)</span>\n    <span class=\"o\">.</span><span class=\"n\">getOrCreate</span><span class=\"p\">()</span>\n    <span class=\"o\">.</span><span class=\"n\">createDataFrame</span><span class=\"p\">(</span><span class=\"n\">data</span><span class=\"p\">,</span> <span class=\"n\">schema</span><span class=\"p\">)</span>\n    <span class=\"o\">.</span><span class=\"n\">groupBy</span><span class=\"p\">(</span><span class=\"n\">F</span><span class=\"o\">.</span><span class=\"n\">col</span><span class=\"p\">(</span><span class=\"s2\">&quot;age&quot;</span><span class=\"p\">))</span>\n    <span class=\"o\">.</span><span class=\"n\">agg</span><span class=\"p\">(</span><span class=\"n\">F</span><span class=\"o\">.</span><span class=\"n\">countDistinct</span><span class=\"p\">(</span><span class=\"n\">F</span><span class=\"o\">.</span><span class=\"n\">col</span><span class=\"p\">(</span><span class=\"s2\">&quot;lname&quot;</span><span class=\"p\">))</span><span class=\"o\">.</span><span class=\"n\">alias</span><span class=\"p\">(</span><span class=\"s2\">&quot;num_employees&quot;</span><span class=\"p\">))</span>\n    <span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">()</span>\n<span class=\"p\">)</span>\n\n<span class=\"k\">try</span><span class=\"p\">:</span>\n    <span class=\"k\">for</span> <span class=\"n\">sql</span> <span class=\"ow\">in</span> <span class=\"n\">sql_statements</span><span class=\"p\">:</span>\n        <span class=\"n\">cs</span><span class=\"o\">.</span><span class=\"n\">execute</span><span class=\"p\">(</span><span class=\"n\">sql</span><span class=\"p\">)</span>\n    <span class=\"n\">results</span> <span class=\"o\">=</span> <span class=\"n\">cs</span><span class=\"o\">.</span><span class=\"n\">fetchall</span><span class=\"p\">()</span>\n    <span class=\"k\">for</span> <span class=\"n\">row</span> <span class=\"ow\">in</span> <span class=\"n\">results</span><span class=\"p\">:</span>\n        <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"sa\">f</span><span class=\"s2\">&quot;Age: </span><span class=\"si\">{</span><span class=\"n\">row</span><span class=\"p\">[</span><span class=\"mi\">0</span><span class=\"p\">]</span><span class=\"si\">}</span><span class=\"s2\">, Num Employees: </span><span class=\"si\">{</span><span class=\"n\">row</span><span class=\"p\">[</span><span class=\"mi\">1</span><span class=\"p\">]</span><span class=\"si\">}</span><span class=\"s2\">&quot;</span><span class=\"p\">)</span>\n<span class=\"k\">finally</span><span class=\"p\">:</span>\n    <span class=\"n\">cs</span><span class=\"o\">.</span><span class=\"n\">close</span><span class=\"p\">()</span>\n<span class=\"n\">ctx</span><span class=\"o\">.</span><span class=\"n\">close</span><span class=\"p\">()</span>\n</code></pre>\n</div>\n\n<h3 id=\"spark\">Spark</h3>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"kn\">from</span> <span class=\"nn\">pyspark.sql.session</span> <span class=\"kn\">import</span> <span class=\"n\">SparkSession</span> <span class=\"k\">as</span> <span class=\"n\">PySparkSession</span>\n<span class=\"kn\">from</span> <span class=\"nn\">sqlglot.dataframe.sql.session</span> <span class=\"kn\">import</span> <span class=\"n\">SparkSession</span>\n<span class=\"kn\">from</span> <span class=\"nn\">sqlglot.dataframe.sql</span> <span class=\"kn\">import</span> <span class=\"n\">types</span>\n<span class=\"kn\">from</span> <span class=\"nn\">sqlglot.dataframe.sql</span> <span class=\"kn\">import</span> <span class=\"n\">functions</span> <span class=\"k\">as</span> <span class=\"n\">F</span>\n\n<span class=\"n\">data</span> <span class=\"o\">=</span> <span class=\"p\">[</span>\n    <span class=\"p\">(</span><span class=\"mi\">1</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Jack&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Shephard&quot;</span><span class=\"p\">,</span> <span class=\"mi\">34</span><span class=\"p\">),</span>\n    <span class=\"p\">(</span><span class=\"mi\">2</span><span class=\"p\">,</span> <span class=\"s2\">&quot;John&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Locke&quot;</span><span class=\"p\">,</span> <span class=\"mi\">48</span><span class=\"p\">),</span>\n    <span class=\"p\">(</span><span class=\"mi\">3</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Kate&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Austen&quot;</span><span class=\"p\">,</span> <span class=\"mi\">34</span><span class=\"p\">),</span>\n    <span class=\"p\">(</span><span class=\"mi\">4</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Claire&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Littleton&quot;</span><span class=\"p\">,</span> <span class=\"mi\">22</span><span class=\"p\">),</span>\n    <span class=\"p\">(</span><span class=\"mi\">5</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Hugo&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Reyes&quot;</span><span class=\"p\">,</span> <span class=\"mi\">26</span><span class=\"p\">),</span>\n<span class=\"p\">]</span>\n<span class=\"n\">schema</span> <span class=\"o\">=</span> <span class=\"n\">types</span><span class=\"o\">.</span><span class=\"n\">StructType</span><span class=\"p\">([</span>\n    <span class=\"n\">types</span><span class=\"o\">.</span><span class=\"n\">StructField</span><span class=\"p\">(</span><span class=\"s1\">&#39;employee_id&#39;</span><span class=\"p\">,</span> <span class=\"n\">types</span><span class=\"o\">.</span><span class=\"n\">IntegerType</span><span class=\"p\">(),</span> <span class=\"kc\">False</span><span class=\"p\">),</span>\n    <span class=\"n\">types</span><span class=\"o\">.</span><span class=\"n\">StructField</span><span class=\"p\">(</span><span class=\"s1\">&#39;fname&#39;</span><span class=\"p\">,</span> <span class=\"n\">types</span><span class=\"o\">.</span><span class=\"n\">StringType</span><span class=\"p\">(),</span> <span class=\"kc\">False</span><span class=\"p\">),</span>\n    <span class=\"n\">types</span><span class=\"o\">.</span><span class=\"n\">StructField</span><span class=\"p\">(</span><span class=\"s1\">&#39;lname&#39;</span><span class=\"p\">,</span> <span class=\"n\">types</span><span class=\"o\">.</span><span class=\"n\">StringType</span><span class=\"p\">(),</span> <span class=\"kc\">False</span><span class=\"p\">),</span>\n    <span class=\"n\">types</span><span class=\"o\">.</span><span class=\"n\">StructField</span><span class=\"p\">(</span><span class=\"s1\">&#39;age&#39;</span><span class=\"p\">,</span> <span class=\"n\">types</span><span class=\"o\">.</span><span class=\"n\">IntegerType</span><span class=\"p\">(),</span> <span class=\"kc\">False</span><span class=\"p\">),</span>\n<span class=\"p\">])</span>\n\n<span class=\"n\">sql_statements</span> <span class=\"o\">=</span> <span class=\"p\">(</span>\n    <span class=\"n\">SparkSession</span><span class=\"p\">()</span>\n    <span class=\"o\">.</span><span class=\"n\">createDataFrame</span><span class=\"p\">(</span><span class=\"n\">data</span><span class=\"p\">,</span> <span class=\"n\">schema</span><span class=\"p\">)</span>\n    <span class=\"o\">.</span><span class=\"n\">groupBy</span><span class=\"p\">(</span><span class=\"n\">F</span><span class=\"o\">.</span><span class=\"n\">col</span><span class=\"p\">(</span><span class=\"s2\">&quot;age&quot;</span><span class=\"p\">))</span>\n    <span class=\"o\">.</span><span class=\"n\">agg</span><span class=\"p\">(</span><span class=\"n\">F</span><span class=\"o\">.</span><span class=\"n\">countDistinct</span><span class=\"p\">(</span><span class=\"n\">F</span><span class=\"o\">.</span><span class=\"n\">col</span><span class=\"p\">(</span><span class=\"s2\">&quot;employee_id&quot;</span><span class=\"p\">))</span><span class=\"o\">.</span><span class=\"n\">alias</span><span class=\"p\">(</span><span class=\"s2\">&quot;num_employees&quot;</span><span class=\"p\">))</span>\n    <span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">()</span>\n<span class=\"p\">)</span>\n\n<span class=\"n\">pyspark</span> <span class=\"o\">=</span> <span class=\"n\">PySparkSession</span><span class=\"o\">.</span><span class=\"n\">builder</span><span class=\"o\">.</span><span class=\"n\">master</span><span class=\"p\">(</span><span class=\"s2\">&quot;local[*]&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">getOrCreate</span><span class=\"p\">()</span>\n\n<span class=\"n\">df</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>\n<span class=\"k\">for</span> <span class=\"n\">sql</span> <span class=\"ow\">in</span> <span class=\"n\">sql_statements</span><span class=\"p\">:</span>\n    <span class=\"n\">df</span> <span class=\"o\">=</span> <span class=\"n\">pyspark</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">(</span><span class=\"n\">sql</span><span class=\"p\">)</span>\n\n<span class=\"k\">assert</span> <span class=\"n\">df</span> <span class=\"ow\">is</span> <span class=\"ow\">not</span> <span class=\"kc\">None</span>\n<span class=\"n\">df</span><span class=\"o\">.</span><span class=\"n\">show</span><span class=\"p\">()</span>\n</code></pre>\n</div>\n\n<h1 id=\"unsupportable-operations\">Unsupportable Operations</h1>\n\n<p>Any operation that lacks a way to represent it in SQL cannot be supported by this tool. An example of this would be rdd operations. Since the DataFrame API though is mostly modeled around SQL concepts most operations can be supported.</p>\n"}, "sqlglot.dataframe.sql": {"fullname": "sqlglot.dataframe.sql", "modulename": "sqlglot.dataframe.sql", "kind": "module", "doc": "<p></p>\n"}, "sqlglot.dataframe.sql.SparkSession": {"fullname": "sqlglot.dataframe.sql.SparkSession", "modulename": "sqlglot.dataframe.sql", "qualname": "SparkSession", "kind": "class", "doc": "<p></p>\n"}, "sqlglot.dataframe.sql.SparkSession.DEFAULT_DIALECT": {"fullname": "sqlglot.dataframe.sql.SparkSession.DEFAULT_DIALECT", "modulename": "sqlglot.dataframe.sql", "qualname": "SparkSession.DEFAULT_DIALECT", "kind": "variable", "doc": "<p></p>\n", "default_value": "&#x27;spark&#x27;"}, "sqlglot.dataframe.sql.SparkSession.read": {"fullname": "sqlglot.dataframe.sql.SparkSession.read", "modulename": "sqlglot.dataframe.sql", "qualname": "SparkSession.read", "kind": "variable", "doc": "<p></p>\n", "annotation": ": sqlglot.dataframe.sql.readwriter.DataFrameReader"}, "sqlglot.dataframe.sql.SparkSession.table": {"fullname": "sqlglot.dataframe.sql.SparkSession.table", "modulename": "sqlglot.dataframe.sql", "qualname": "SparkSession.table", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">tableName</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.SparkSession.createDataFrame": {"fullname": "sqlglot.dataframe.sql.SparkSession.createDataFrame", "modulename": "sqlglot.dataframe.sql", "qualname": "SparkSession.createDataFrame", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Sequence</span><span class=\"p\">[</span><span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"o\">&lt;</span><span class=\"n\">MagicMock</span> <span class=\"nb\">id</span><span class=\"o\">=</span><span class=\"s1\">&#39;140452315022240&#39;</span><span class=\"o\">&gt;</span><span class=\"p\">],</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"o\">&lt;</span><span class=\"n\">MagicMock</span> <span class=\"nb\">id</span><span class=\"o\">=</span><span class=\"s1\">&#39;140452315022240&#39;</span><span class=\"o\">&gt;</span><span class=\"p\">],</span> <span class=\"n\">Tuple</span><span class=\"p\">]]</span>,</span><span class=\"param\">\t<span class=\"n\">schema</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"o\">&lt;</span><span class=\"n\">MagicMock</span> <span class=\"nb\">id</span><span class=\"o\">=</span><span class=\"s1\">&#39;140452314825728&#39;</span><span class=\"o\">&gt;</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">samplingRatio</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">verifySchema</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.SparkSession.sql": {"fullname": "sqlglot.dataframe.sql.SparkSession.sql", "modulename": "sqlglot.dataframe.sql", "qualname": "SparkSession.sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">sqlQuery</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.SparkSession.Builder": {"fullname": "sqlglot.dataframe.sql.SparkSession.Builder", "modulename": "sqlglot.dataframe.sql", "qualname": "SparkSession.Builder", "kind": "class", "doc": "<p></p>\n"}, "sqlglot.dataframe.sql.SparkSession.Builder.SQLFRAME_DIALECT_KEY": {"fullname": "sqlglot.dataframe.sql.SparkSession.Builder.SQLFRAME_DIALECT_KEY", "modulename": "sqlglot.dataframe.sql", "qualname": "SparkSession.Builder.SQLFRAME_DIALECT_KEY", "kind": "variable", "doc": "<p></p>\n", "default_value": "&#x27;sqlframe.dialect&#x27;"}, "sqlglot.dataframe.sql.SparkSession.Builder.dialect": {"fullname": "sqlglot.dataframe.sql.SparkSession.Builder.dialect", "modulename": "sqlglot.dataframe.sql", "qualname": "SparkSession.Builder.dialect", "kind": "variable", "doc": "<p></p>\n"}, "sqlglot.dataframe.sql.SparkSession.Builder.config": {"fullname": "sqlglot.dataframe.sql.SparkSession.Builder.config", "modulename": "sqlglot.dataframe.sql", "qualname": "SparkSession.Builder.config", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">key</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">Any</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">*</span>,</span><span class=\"param\">\t<span class=\"nb\">map</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span><span class=\"p\">:</span> <span class=\"n\">Any</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">session</span><span class=\"o\">.</span><span class=\"n\">SparkSession</span><span class=\"o\">.</span><span class=\"n\">Builder</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.SparkSession.Builder.getOrCreate": {"fullname": "sqlglot.dataframe.sql.SparkSession.Builder.getOrCreate", "modulename": "sqlglot.dataframe.sql", "qualname": "SparkSession.Builder.getOrCreate", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">session</span><span class=\"o\">.</span><span class=\"n\">SparkSession</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.SparkSession.builder": {"fullname": "sqlglot.dataframe.sql.SparkSession.builder", "modulename": "sqlglot.dataframe.sql", "qualname": "SparkSession.builder", "kind": "variable", "doc": "<p></p>\n", "annotation": ": sqlglot.dataframe.sql.session.SparkSession.Builder"}, "sqlglot.dataframe.sql.DataFrame": {"fullname": "sqlglot.dataframe.sql.DataFrame", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame", "kind": "class", "doc": "<p></p>\n"}, "sqlglot.dataframe.sql.DataFrame.__init__": {"fullname": "sqlglot.dataframe.sql.DataFrame.__init__", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">spark</span><span class=\"p\">:</span> <span class=\"o\">&lt;</span><span class=\"n\">MagicMock</span> <span class=\"nb\">id</span><span class=\"o\">=</span><span class=\"s1\">&#39;140452319856048&#39;</span><span class=\"o\">&gt;</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Select</span>,</span><span class=\"param\">\t<span class=\"n\">branch_id</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">sequence_id</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">last_op</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">operations</span><span class=\"o\">.</span><span class=\"n\">Operation</span> <span class=\"o\">=</span> <span class=\"o\">&lt;</span><span class=\"n\">Operation</span><span class=\"o\">.</span><span class=\"n\">INIT</span><span class=\"p\">:</span> <span class=\"o\">-</span><span class=\"mi\">1</span><span class=\"o\">&gt;</span>,</span><span class=\"param\">\t<span class=\"n\">pending_hints</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">output_expression_container</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"o\">&lt;</span><span class=\"n\">MagicMock</span> <span class=\"nb\">id</span><span class=\"o\">=</span><span class=\"s1\">&#39;140452320025888&#39;</span><span class=\"o\">&gt;</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span>)</span>"}, "sqlglot.dataframe.sql.DataFrame.spark": {"fullname": "sqlglot.dataframe.sql.DataFrame.spark", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.spark", "kind": "variable", "doc": "<p></p>\n"}, "sqlglot.dataframe.sql.DataFrame.expression": {"fullname": "sqlglot.dataframe.sql.DataFrame.expression", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.expression", "kind": "variable", "doc": "<p></p>\n"}, "sqlglot.dataframe.sql.DataFrame.branch_id": {"fullname": "sqlglot.dataframe.sql.DataFrame.branch_id", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.branch_id", "kind": "variable", "doc": "<p></p>\n"}, "sqlglot.dataframe.sql.DataFrame.sequence_id": {"fullname": "sqlglot.dataframe.sql.DataFrame.sequence_id", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.sequence_id", "kind": "variable", "doc": "<p></p>\n"}, "sqlglot.dataframe.sql.DataFrame.last_op": {"fullname": "sqlglot.dataframe.sql.DataFrame.last_op", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.last_op", "kind": "variable", "doc": "<p></p>\n"}, "sqlglot.dataframe.sql.DataFrame.pending_hints": {"fullname": "sqlglot.dataframe.sql.DataFrame.pending_hints", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.pending_hints", "kind": "variable", "doc": "<p></p>\n"}, "sqlglot.dataframe.sql.DataFrame.output_expression_container": {"fullname": "sqlglot.dataframe.sql.DataFrame.output_expression_container", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.output_expression_container", "kind": "variable", "doc": "<p></p>\n"}, "sqlglot.dataframe.sql.DataFrame.sparkSession": {"fullname": "sqlglot.dataframe.sql.DataFrame.sparkSession", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.sparkSession", "kind": "variable", "doc": "<p></p>\n"}, "sqlglot.dataframe.sql.DataFrame.write": {"fullname": "sqlglot.dataframe.sql.DataFrame.write", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.write", "kind": "variable", "doc": "<p></p>\n"}, "sqlglot.dataframe.sql.DataFrame.latest_cte_name": {"fullname": "sqlglot.dataframe.sql.DataFrame.latest_cte_name", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.latest_cte_name", "kind": "variable", "doc": "<p></p>\n", "annotation": ": str"}, "sqlglot.dataframe.sql.DataFrame.pending_join_hints": {"fullname": "sqlglot.dataframe.sql.DataFrame.pending_join_hints", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.pending_join_hints", "kind": "variable", "doc": "<p></p>\n"}, "sqlglot.dataframe.sql.DataFrame.pending_partition_hints": {"fullname": "sqlglot.dataframe.sql.DataFrame.pending_partition_hints", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.pending_partition_hints", "kind": "variable", "doc": "<p></p>\n"}, "sqlglot.dataframe.sql.DataFrame.columns": {"fullname": "sqlglot.dataframe.sql.DataFrame.columns", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.columns", "kind": "variable", "doc": "<p></p>\n", "annotation": ": List[str]"}, "sqlglot.dataframe.sql.DataFrame.na": {"fullname": "sqlglot.dataframe.sql.DataFrame.na", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.na", "kind": "variable", "doc": "<p></p>\n", "annotation": ": sqlglot.dataframe.sql.dataframe.DataFrameNaFunctions"}, "sqlglot.dataframe.sql.DataFrame.sql": {"fullname": "sqlglot.dataframe.sql.DataFrame.sql", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">dialect</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"o\">&lt;</span><span class=\"n\">MagicMock</span> <span class=\"nb\">id</span><span class=\"o\">=</span><span class=\"s1\">&#39;140452315728432&#39;</span><span class=\"o\">&gt;</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">optimize</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrame.copy": {"fullname": "sqlglot.dataframe.sql.DataFrame.copy", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.copy", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrame.select": {"fullname": "sqlglot.dataframe.sql.DataFrame.select", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.select", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">*</span><span class=\"n\">cols</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrame.alias": {"fullname": "sqlglot.dataframe.sql.DataFrame.alias", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.alias", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrame.where": {"fullname": "sqlglot.dataframe.sql.DataFrame.where", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.where", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">column</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span><span class=\"p\">,</span> <span class=\"nb\">bool</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrame.filter": {"fullname": "sqlglot.dataframe.sql.DataFrame.filter", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.filter", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">column</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span><span class=\"p\">,</span> <span class=\"nb\">bool</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrame.groupBy": {"fullname": "sqlglot.dataframe.sql.DataFrame.groupBy", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.groupBy", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">*</span><span class=\"n\">cols</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">group</span><span class=\"o\">.</span><span class=\"n\">GroupedData</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrame.agg": {"fullname": "sqlglot.dataframe.sql.DataFrame.agg", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.agg", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">*</span><span class=\"n\">exprs</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrame.join": {"fullname": "sqlglot.dataframe.sql.DataFrame.join", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.join", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">other_df</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>,</span><span class=\"param\">\t<span class=\"n\">on</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">],</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span><span class=\"p\">]]</span>,</span><span class=\"param\">\t<span class=\"n\">how</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;inner&#39;</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrame.orderBy": {"fullname": "sqlglot.dataframe.sql.DataFrame.orderBy", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.orderBy", "kind": "function", "doc": "<p>This implementation lets any ordered columns take priority over whatever is provided in <code>ascending</code>. Spark\nhas irregular behavior and can result in runtime errors. Users shouldn't be mixing the two anyways so this\nis unlikely to come up.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">cols</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">ascending</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">Any</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Any</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrame.sort": {"fullname": "sqlglot.dataframe.sql.DataFrame.sort", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.sort", "kind": "function", "doc": "<p>This implementation lets any ordered columns take priority over whatever is provided in <code>ascending</code>. Spark\nhas irregular behavior and can result in runtime errors. Users shouldn't be mixing the two anyways so this\nis unlikely to come up.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">cols</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">ascending</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">Any</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Any</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrame.union": {"fullname": "sqlglot.dataframe.sql.DataFrame.union", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.union", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">other</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrame.unionAll": {"fullname": "sqlglot.dataframe.sql.DataFrame.unionAll", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.unionAll", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">other</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrame.unionByName": {"fullname": "sqlglot.dataframe.sql.DataFrame.unionByName", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.unionByName", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">other</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>,</span><span class=\"param\">\t<span class=\"n\">allowMissingColumns</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrame.intersect": {"fullname": "sqlglot.dataframe.sql.DataFrame.intersect", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.intersect", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">other</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrame.intersectAll": {"fullname": "sqlglot.dataframe.sql.DataFrame.intersectAll", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.intersectAll", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">other</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrame.exceptAll": {"fullname": "sqlglot.dataframe.sql.DataFrame.exceptAll", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.exceptAll", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">other</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrame.distinct": {"fullname": "sqlglot.dataframe.sql.DataFrame.distinct", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.distinct", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrame.dropDuplicates": {"fullname": "sqlglot.dataframe.sql.DataFrame.dropDuplicates", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.dropDuplicates", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">subset</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrame.dropna": {"fullname": "sqlglot.dataframe.sql.DataFrame.dropna", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.dropna", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">how</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;any&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">thresh</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">subset</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"o\">...</span><span class=\"p\">],</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrame.fillna": {"fullname": "sqlglot.dataframe.sql.DataFrame.fillna", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.fillna", "kind": "function", "doc": "<p>Functionality Difference: If you provide a value to replace a null and that type conflicts\nwith the type of the column then PySpark will just ignore your replacement.\nThis will try to cast them to be the same in some cases. So they won't always match.\nBest to not mix types so make sure replacement is the same type as the column</p>\n\n<p>Possibility for improvement: Use <code>typeof</code> function to get the type of the column\nand check if it matches the type of the value provided. If not then make it null.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"o\">&lt;</span><span class=\"n\">MagicMock</span> <span class=\"nb\">id</span><span class=\"o\">=</span><span class=\"s1\">&#39;140452315832640&#39;</span><span class=\"o\">&gt;</span>,</span><span class=\"param\">\t<span class=\"n\">subset</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"o\">...</span><span class=\"p\">],</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrame.replace": {"fullname": "sqlglot.dataframe.sql.DataFrame.replace", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.replace", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">to_replace</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">,</span> <span class=\"n\">Dict</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">subset</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">Collection</span><span class=\"p\">[</span><span class=\"o\">&lt;</span><span class=\"n\">MagicMock</span> <span class=\"nb\">id</span><span class=\"o\">=</span><span class=\"s1\">&#39;140452313861280&#39;</span><span class=\"o\">&gt;</span><span class=\"p\">],</span> <span class=\"o\">&lt;</span><span class=\"n\">MagicMock</span> <span class=\"nb\">id</span><span class=\"o\">=</span><span class=\"s1\">&#39;140452313861280&#39;</span><span class=\"o\">&gt;</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrame.withColumn": {"fullname": "sqlglot.dataframe.sql.DataFrame.withColumn", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.withColumn", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">colName</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">col</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrame.withColumnRenamed": {"fullname": "sqlglot.dataframe.sql.DataFrame.withColumnRenamed", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.withColumnRenamed", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">existing</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">new</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrame.drop": {"fullname": "sqlglot.dataframe.sql.DataFrame.drop", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.drop", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">cols</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrame.limit": {"fullname": "sqlglot.dataframe.sql.DataFrame.limit", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.limit", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">num</span><span class=\"p\">:</span> <span class=\"nb\">int</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrame.hint": {"fullname": "sqlglot.dataframe.sql.DataFrame.hint", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.hint", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">parameters</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrame.repartition": {"fullname": "sqlglot.dataframe.sql.DataFrame.repartition", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.repartition", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">numPartitions</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"o\">&lt;</span><span class=\"n\">MagicMock</span> <span class=\"nb\">id</span><span class=\"o\">=</span><span class=\"s1\">&#39;140452313784256&#39;</span><span class=\"o\">&gt;</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">cols</span><span class=\"p\">:</span> <span class=\"o\">&lt;</span><span class=\"n\">MagicMock</span> <span class=\"nb\">id</span><span class=\"o\">=</span><span class=\"s1\">&#39;140452314075040&#39;</span><span class=\"o\">&gt;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrame.coalesce": {"fullname": "sqlglot.dataframe.sql.DataFrame.coalesce", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.coalesce", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">numPartitions</span><span class=\"p\">:</span> <span class=\"nb\">int</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrame.cache": {"fullname": "sqlglot.dataframe.sql.DataFrame.cache", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.cache", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrame.persist": {"fullname": "sqlglot.dataframe.sql.DataFrame.persist", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.persist", "kind": "function", "doc": "<p>Storage Level Options: <a href=\"https://spark.apache.org/docs/3.0.0-preview/sql-ref-syntax-aux-cache-cache-table.html\">https://spark.apache.org/docs/3.0.0-preview/sql-ref-syntax-aux-cache-cache-table.html</a></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">storageLevel</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;MEMORY_AND_DISK_SER&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.GroupedData": {"fullname": "sqlglot.dataframe.sql.GroupedData", "modulename": "sqlglot.dataframe.sql", "qualname": "GroupedData", "kind": "class", "doc": "<p></p>\n"}, "sqlglot.dataframe.sql.GroupedData.__init__": {"fullname": "sqlglot.dataframe.sql.GroupedData.__init__", "modulename": "sqlglot.dataframe.sql", "qualname": "GroupedData.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">df</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>,</span><span class=\"param\">\t<span class=\"n\">group_by_cols</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">last_op</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">operations</span><span class=\"o\">.</span><span class=\"n\">Operation</span></span>)</span>"}, "sqlglot.dataframe.sql.GroupedData.spark": {"fullname": "sqlglot.dataframe.sql.GroupedData.spark", "modulename": "sqlglot.dataframe.sql", "qualname": "GroupedData.spark", "kind": "variable", "doc": "<p></p>\n"}, "sqlglot.dataframe.sql.GroupedData.last_op": {"fullname": "sqlglot.dataframe.sql.GroupedData.last_op", "modulename": "sqlglot.dataframe.sql", "qualname": "GroupedData.last_op", "kind": "variable", "doc": "<p></p>\n"}, "sqlglot.dataframe.sql.GroupedData.group_by_cols": {"fullname": "sqlglot.dataframe.sql.GroupedData.group_by_cols", "modulename": "sqlglot.dataframe.sql", "qualname": "GroupedData.group_by_cols", "kind": "variable", "doc": "<p></p>\n"}, "sqlglot.dataframe.sql.GroupedData.agg": {"fullname": "sqlglot.dataframe.sql.GroupedData.agg", "modulename": "sqlglot.dataframe.sql", "qualname": "GroupedData.agg", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">exprs</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span><span class=\"p\">,</span> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">]]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.GroupedData.count": {"fullname": "sqlglot.dataframe.sql.GroupedData.count", "modulename": "sqlglot.dataframe.sql", "qualname": "GroupedData.count", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.GroupedData.mean": {"fullname": "sqlglot.dataframe.sql.GroupedData.mean", "modulename": "sqlglot.dataframe.sql", "qualname": "GroupedData.mean", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">*</span><span class=\"n\">cols</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.GroupedData.avg": {"fullname": "sqlglot.dataframe.sql.GroupedData.avg", "modulename": "sqlglot.dataframe.sql", "qualname": "GroupedData.avg", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">*</span><span class=\"n\">cols</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.GroupedData.max": {"fullname": "sqlglot.dataframe.sql.GroupedData.max", "modulename": "sqlglot.dataframe.sql", "qualname": "GroupedData.max", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">*</span><span class=\"n\">cols</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.GroupedData.min": {"fullname": "sqlglot.dataframe.sql.GroupedData.min", "modulename": "sqlglot.dataframe.sql", "qualname": "GroupedData.min", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">*</span><span class=\"n\">cols</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.GroupedData.sum": {"fullname": "sqlglot.dataframe.sql.GroupedData.sum", "modulename": "sqlglot.dataframe.sql", "qualname": "GroupedData.sum", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">*</span><span class=\"n\">cols</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.GroupedData.pivot": {"fullname": "sqlglot.dataframe.sql.GroupedData.pivot", "modulename": "sqlglot.dataframe.sql", "qualname": "GroupedData.pivot", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">*</span><span class=\"n\">cols</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.Column": {"fullname": "sqlglot.dataframe.sql.Column", "modulename": "sqlglot.dataframe.sql", "qualname": "Column", "kind": "class", "doc": "<p></p>\n"}, "sqlglot.dataframe.sql.Column.__init__": {"fullname": "sqlglot.dataframe.sql.Column.__init__", "modulename": "sqlglot.dataframe.sql", "qualname": "Column.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"o\">&lt;</span><span class=\"n\">MagicMock</span> <span class=\"nb\">id</span><span class=\"o\">=</span><span class=\"s1\">&#39;140452317817648&#39;</span><span class=\"o\">&gt;</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span></span>)</span>"}, "sqlglot.dataframe.sql.Column.expression": {"fullname": "sqlglot.dataframe.sql.Column.expression", "modulename": "sqlglot.dataframe.sql", "qualname": "Column.expression", "kind": "variable", "doc": "<p></p>\n", "annotation": ": sqlglot.expressions.Expression"}, "sqlglot.dataframe.sql.Column.ensure_col": {"fullname": "sqlglot.dataframe.sql.Column.ensure_col", "modulename": "sqlglot.dataframe.sql", "qualname": "Column.ensure_col", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">cls</span>,</span><span class=\"param\">\t<span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"o\">&lt;</span><span class=\"n\">MagicMock</span> <span class=\"nb\">id</span><span class=\"o\">=</span><span class=\"s1\">&#39;140452314678176&#39;</span><span class=\"o\">&gt;</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.Column.ensure_cols": {"fullname": "sqlglot.dataframe.sql.Column.ensure_cols", "modulename": "sqlglot.dataframe.sql", "qualname": "Column.ensure_cols", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">cls</span>,</span><span class=\"param\">\t<span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"o\">&lt;</span><span class=\"n\">MagicMock</span> <span class=\"nb\">id</span><span class=\"o\">=</span><span class=\"s1\">&#39;140452314457488&#39;</span><span class=\"o\">&gt;</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">]]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.Column.invoke_anonymous_function": {"fullname": "sqlglot.dataframe.sql.Column.invoke_anonymous_function", "modulename": "sqlglot.dataframe.sql", "qualname": "Column.invoke_anonymous_function", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">cls</span>,</span><span class=\"param\">\t<span class=\"n\">column</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"o\">&lt;</span><span class=\"n\">MagicMock</span> <span class=\"nb\">id</span><span class=\"o\">=</span><span class=\"s1\">&#39;140452314721072&#39;</span><span class=\"o\">&gt;</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">func_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"o\">&lt;</span><span class=\"n\">MagicMock</span> <span class=\"nb\">id</span><span class=\"o\">=</span><span class=\"s1\">&#39;140452314417088&#39;</span><span class=\"o\">&gt;</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.Column.invoke_expression_over_column": {"fullname": "sqlglot.dataframe.sql.Column.invoke_expression_over_column", "modulename": "sqlglot.dataframe.sql", "qualname": "Column.invoke_expression_over_column", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">cls</span>,</span><span class=\"param\">\t<span class=\"n\">column</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"o\">&lt;</span><span class=\"n\">MagicMock</span> <span class=\"nb\">id</span><span class=\"o\">=</span><span class=\"s1\">&#39;140452314715216&#39;</span><span class=\"o\">&gt;</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">callable_expression</span><span class=\"p\">:</span> <span class=\"n\">Callable</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.Column.binary_op": {"fullname": "sqlglot.dataframe.sql.Column.binary_op", "modulename": "sqlglot.dataframe.sql", "qualname": "Column.binary_op", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">klass</span><span class=\"p\">:</span> <span class=\"n\">Callable</span>,</span><span class=\"param\">\t<span class=\"n\">other</span><span class=\"p\">:</span> <span class=\"o\">&lt;</span><span class=\"n\">MagicMock</span> <span class=\"nb\">id</span><span class=\"o\">=</span><span class=\"s1\">&#39;140452314588704&#39;</span><span class=\"o\">&gt;</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.Column.inverse_binary_op": {"fullname": "sqlglot.dataframe.sql.Column.inverse_binary_op", "modulename": "sqlglot.dataframe.sql", "qualname": "Column.inverse_binary_op", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">klass</span><span class=\"p\">:</span> <span class=\"n\">Callable</span>,</span><span class=\"param\">\t<span class=\"n\">other</span><span class=\"p\">:</span> <span class=\"o\">&lt;</span><span class=\"n\">MagicMock</span> <span class=\"nb\">id</span><span class=\"o\">=</span><span class=\"s1\">&#39;140452314632720&#39;</span><span class=\"o\">&gt;</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.Column.unary_op": {"fullname": "sqlglot.dataframe.sql.Column.unary_op", "modulename": "sqlglot.dataframe.sql", "qualname": "Column.unary_op", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">klass</span><span class=\"p\">:</span> <span class=\"n\">Callable</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.Column.is_alias": {"fullname": "sqlglot.dataframe.sql.Column.is_alias", "modulename": "sqlglot.dataframe.sql", "qualname": "Column.is_alias", "kind": "variable", "doc": "<p></p>\n"}, "sqlglot.dataframe.sql.Column.is_column": {"fullname": "sqlglot.dataframe.sql.Column.is_column", "modulename": "sqlglot.dataframe.sql", "qualname": "Column.is_column", "kind": "variable", "doc": "<p></p>\n"}, "sqlglot.dataframe.sql.Column.column_expression": {"fullname": "sqlglot.dataframe.sql.Column.column_expression", "modulename": "sqlglot.dataframe.sql", "qualname": "Column.column_expression", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Union[sqlglot.expressions.Column, sqlglot.expressions.Literal]"}, "sqlglot.dataframe.sql.Column.alias_or_name": {"fullname": "sqlglot.dataframe.sql.Column.alias_or_name", "modulename": "sqlglot.dataframe.sql", "qualname": "Column.alias_or_name", "kind": "variable", "doc": "<p></p>\n", "annotation": ": str"}, "sqlglot.dataframe.sql.Column.ensure_literal": {"fullname": "sqlglot.dataframe.sql.Column.ensure_literal", "modulename": "sqlglot.dataframe.sql", "qualname": "Column.ensure_literal", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span>, </span><span class=\"param\"><span class=\"n\">value</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.Column.copy": {"fullname": "sqlglot.dataframe.sql.Column.copy", "modulename": "sqlglot.dataframe.sql", "qualname": "Column.copy", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.Column.set_table_name": {"fullname": "sqlglot.dataframe.sql.Column.set_table_name", "modulename": "sqlglot.dataframe.sql", "qualname": "Column.set_table_name", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">table_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">copy</span><span class=\"o\">=</span><span class=\"kc\">False</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.Column.sql": {"fullname": "sqlglot.dataframe.sql.Column.sql", "modulename": "sqlglot.dataframe.sql", "qualname": "Column.sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.Column.alias": {"fullname": "sqlglot.dataframe.sql.Column.alias", "modulename": "sqlglot.dataframe.sql", "qualname": "Column.alias", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.Column.asc": {"fullname": "sqlglot.dataframe.sql.Column.asc", "modulename": "sqlglot.dataframe.sql", "qualname": "Column.asc", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.Column.desc": {"fullname": "sqlglot.dataframe.sql.Column.desc", "modulename": "sqlglot.dataframe.sql", "qualname": "Column.desc", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.Column.asc_nulls_first": {"fullname": "sqlglot.dataframe.sql.Column.asc_nulls_first", "modulename": "sqlglot.dataframe.sql", "qualname": "Column.asc_nulls_first", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.Column.asc_nulls_last": {"fullname": "sqlglot.dataframe.sql.Column.asc_nulls_last", "modulename": "sqlglot.dataframe.sql", "qualname": "Column.asc_nulls_last", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.Column.desc_nulls_first": {"fullname": "sqlglot.dataframe.sql.Column.desc_nulls_first", "modulename": "sqlglot.dataframe.sql", "qualname": "Column.desc_nulls_first", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.Column.desc_nulls_last": {"fullname": "sqlglot.dataframe.sql.Column.desc_nulls_last", "modulename": "sqlglot.dataframe.sql", "qualname": "Column.desc_nulls_last", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.Column.when": {"fullname": "sqlglot.dataframe.sql.Column.when", "modulename": "sqlglot.dataframe.sql", "qualname": "Column.when", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">condition</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span>,</span><span class=\"param\">\t<span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"n\">Any</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.Column.otherwise": {"fullname": "sqlglot.dataframe.sql.Column.otherwise", "modulename": "sqlglot.dataframe.sql", "qualname": "Column.otherwise", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"n\">Any</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.Column.isNull": {"fullname": "sqlglot.dataframe.sql.Column.isNull", "modulename": "sqlglot.dataframe.sql", "qualname": "Column.isNull", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.Column.isNotNull": {"fullname": "sqlglot.dataframe.sql.Column.isNotNull", "modulename": "sqlglot.dataframe.sql", "qualname": "Column.isNotNull", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.Column.cast": {"fullname": "sqlglot.dataframe.sql.Column.cast", "modulename": "sqlglot.dataframe.sql", "qualname": "Column.cast", "kind": "function", "doc": "<p>Functionality Difference: PySpark cast accepts a datatype instance of the datatype class\nSqlglot doesn't currently replicate this class so it only accepts a string</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">dataType</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">types</span><span class=\"o\">.</span><span class=\"n\">DataType</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.Column.startswith": {"fullname": "sqlglot.dataframe.sql.Column.startswith", "modulename": "sqlglot.dataframe.sql", "qualname": "Column.startswith", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.Column.endswith": {"fullname": "sqlglot.dataframe.sql.Column.endswith", "modulename": "sqlglot.dataframe.sql", "qualname": "Column.endswith", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.Column.rlike": {"fullname": "sqlglot.dataframe.sql.Column.rlike", "modulename": "sqlglot.dataframe.sql", "qualname": "Column.rlike", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">regexp</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.Column.like": {"fullname": "sqlglot.dataframe.sql.Column.like", "modulename": "sqlglot.dataframe.sql", "qualname": "Column.like", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">other</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.Column.ilike": {"fullname": "sqlglot.dataframe.sql.Column.ilike", "modulename": "sqlglot.dataframe.sql", "qualname": "Column.ilike", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">other</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.Column.substr": {"fullname": "sqlglot.dataframe.sql.Column.substr", "modulename": "sqlglot.dataframe.sql", "qualname": "Column.substr", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">startPos</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">length</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.Column.isin": {"fullname": "sqlglot.dataframe.sql.Column.isin", "modulename": "sqlglot.dataframe.sql", "qualname": "Column.isin", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">cols</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"o\">&lt;</span><span class=\"n\">MagicMock</span> <span class=\"nb\">id</span><span class=\"o\">=</span><span class=\"s1\">&#39;140452314786560&#39;</span><span class=\"o\">&gt;</span><span class=\"p\">,</span> <span class=\"n\">Iterable</span><span class=\"p\">[</span><span class=\"o\">&lt;</span><span class=\"n\">MagicMock</span> <span class=\"nb\">id</span><span class=\"o\">=</span><span class=\"s1\">&#39;140452314786560&#39;</span><span class=\"o\">&gt;</span><span class=\"p\">]]</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.Column.between": {"fullname": "sqlglot.dataframe.sql.Column.between", "modulename": "sqlglot.dataframe.sql", "qualname": "Column.between", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">lowerBound</span><span class=\"p\">:</span> <span class=\"o\">&lt;</span><span class=\"n\">MagicMock</span> <span class=\"nb\">id</span><span class=\"o\">=</span><span class=\"s1\">&#39;140452312840752&#39;</span><span class=\"o\">&gt;</span>,</span><span class=\"param\">\t<span class=\"n\">upperBound</span><span class=\"p\">:</span> <span class=\"o\">&lt;</span><span class=\"n\">MagicMock</span> <span class=\"nb\">id</span><span class=\"o\">=</span><span class=\"s1\">&#39;140452312878912&#39;</span><span class=\"o\">&gt;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.Column.over": {"fullname": "sqlglot.dataframe.sql.Column.over", "modulename": "sqlglot.dataframe.sql", "qualname": "Column.over", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">window</span><span class=\"p\">:</span> <span class=\"o\">&lt;</span><span class=\"n\">MagicMock</span> <span class=\"nb\">id</span><span class=\"o\">=</span><span class=\"s1\">&#39;140452315623488&#39;</span><span class=\"o\">&gt;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrameNaFunctions": {"fullname": "sqlglot.dataframe.sql.DataFrameNaFunctions", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrameNaFunctions", "kind": "class", "doc": "<p></p>\n"}, "sqlglot.dataframe.sql.DataFrameNaFunctions.__init__": {"fullname": "sqlglot.dataframe.sql.DataFrameNaFunctions.__init__", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrameNaFunctions.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">df</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span></span>)</span>"}, "sqlglot.dataframe.sql.DataFrameNaFunctions.df": {"fullname": "sqlglot.dataframe.sql.DataFrameNaFunctions.df", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrameNaFunctions.df", "kind": "variable", "doc": "<p></p>\n"}, "sqlglot.dataframe.sql.DataFrameNaFunctions.drop": {"fullname": "sqlglot.dataframe.sql.DataFrameNaFunctions.drop", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrameNaFunctions.drop", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">how</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;any&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">thresh</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">subset</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"o\">...</span><span class=\"p\">],</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrameNaFunctions.fill": {"fullname": "sqlglot.dataframe.sql.DataFrameNaFunctions.fill", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrameNaFunctions.fill", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">bool</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]]</span>,</span><span class=\"param\">\t<span class=\"n\">subset</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"o\">...</span><span class=\"p\">],</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrameNaFunctions.replace": {"fullname": "sqlglot.dataframe.sql.DataFrameNaFunctions.replace", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrameNaFunctions.replace", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">to_replace</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">,</span> <span class=\"n\">Dict</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">subset</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.Window": {"fullname": "sqlglot.dataframe.sql.Window", "modulename": "sqlglot.dataframe.sql", "qualname": "Window", "kind": "class", "doc": "<p></p>\n"}, "sqlglot.dataframe.sql.Window.unboundedPreceding": {"fullname": "sqlglot.dataframe.sql.Window.unboundedPreceding", "modulename": "sqlglot.dataframe.sql", "qualname": "Window.unboundedPreceding", "kind": "variable", "doc": "<p></p>\n", "annotation": ": int", "default_value": "-9223372036854775808"}, "sqlglot.dataframe.sql.Window.unboundedFollowing": {"fullname": "sqlglot.dataframe.sql.Window.unboundedFollowing", "modulename": "sqlglot.dataframe.sql", "qualname": "Window.unboundedFollowing", "kind": "variable", "doc": "<p></p>\n", "annotation": ": int", "default_value": "9223372036854775807"}, "sqlglot.dataframe.sql.Window.currentRow": {"fullname": "sqlglot.dataframe.sql.Window.currentRow", "modulename": "sqlglot.dataframe.sql", "qualname": "Window.currentRow", "kind": "variable", "doc": "<p></p>\n", "annotation": ": int", "default_value": "0"}, "sqlglot.dataframe.sql.Window.partitionBy": {"fullname": "sqlglot.dataframe.sql.Window.partitionBy", "modulename": "sqlglot.dataframe.sql", "qualname": "Window.partitionBy", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">cls</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">cols</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"o\">&lt;</span><span class=\"n\">MagicMock</span> <span class=\"nb\">id</span><span class=\"o\">=</span><span class=\"s1\">&#39;140452313196160&#39;</span><span class=\"o\">&gt;</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"o\">&lt;</span><span class=\"n\">MagicMock</span> <span class=\"nb\">id</span><span class=\"o\">=</span><span class=\"s1\">&#39;140452313196160&#39;</span><span class=\"o\">&gt;</span><span class=\"p\">]]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">window</span><span class=\"o\">.</span><span class=\"n\">WindowSpec</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.Window.orderBy": {"fullname": "sqlglot.dataframe.sql.Window.orderBy", "modulename": "sqlglot.dataframe.sql", "qualname": "Window.orderBy", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">cls</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">cols</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"o\">&lt;</span><span class=\"n\">MagicMock</span> <span class=\"nb\">id</span><span class=\"o\">=</span><span class=\"s1\">&#39;140452313545552&#39;</span><span class=\"o\">&gt;</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"o\">&lt;</span><span class=\"n\">MagicMock</span> <span class=\"nb\">id</span><span class=\"o\">=</span><span class=\"s1\">&#39;140452313545552&#39;</span><span class=\"o\">&gt;</span><span class=\"p\">]]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">window</span><span class=\"o\">.</span><span class=\"n\">WindowSpec</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.Window.rowsBetween": {"fullname": "sqlglot.dataframe.sql.Window.rowsBetween", "modulename": "sqlglot.dataframe.sql", "qualname": "Window.rowsBetween", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span>, </span><span class=\"param\"><span class=\"n\">start</span><span class=\"p\">:</span> <span class=\"nb\">int</span>, </span><span class=\"param\"><span class=\"n\">end</span><span class=\"p\">:</span> <span class=\"nb\">int</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">window</span><span class=\"o\">.</span><span class=\"n\">WindowSpec</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.Window.rangeBetween": {"fullname": "sqlglot.dataframe.sql.Window.rangeBetween", "modulename": "sqlglot.dataframe.sql", "qualname": "Window.rangeBetween", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span>, </span><span class=\"param\"><span class=\"n\">start</span><span class=\"p\">:</span> <span class=\"nb\">int</span>, </span><span class=\"param\"><span class=\"n\">end</span><span class=\"p\">:</span> <span class=\"nb\">int</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">window</span><span class=\"o\">.</span><span class=\"n\">WindowSpec</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.WindowSpec": {"fullname": "sqlglot.dataframe.sql.WindowSpec", "modulename": "sqlglot.dataframe.sql", "qualname": "WindowSpec", "kind": "class", "doc": "<p></p>\n"}, "sqlglot.dataframe.sql.WindowSpec.__init__": {"fullname": "sqlglot.dataframe.sql.WindowSpec.__init__", "modulename": "sqlglot.dataframe.sql", "qualname": "WindowSpec.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span> <span class=\"o\">=</span> <span class=\"p\">(</span><span class=\"n\">WINDOW</span> <span class=\"p\">)</span></span>)</span>"}, "sqlglot.dataframe.sql.WindowSpec.expression": {"fullname": "sqlglot.dataframe.sql.WindowSpec.expression", "modulename": "sqlglot.dataframe.sql", "qualname": "WindowSpec.expression", "kind": "variable", "doc": "<p></p>\n"}, "sqlglot.dataframe.sql.WindowSpec.copy": {"fullname": "sqlglot.dataframe.sql.WindowSpec.copy", "modulename": "sqlglot.dataframe.sql", "qualname": "WindowSpec.copy", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.WindowSpec.sql": {"fullname": "sqlglot.dataframe.sql.WindowSpec.sql", "modulename": "sqlglot.dataframe.sql", "qualname": "WindowSpec.sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.WindowSpec.partitionBy": {"fullname": "sqlglot.dataframe.sql.WindowSpec.partitionBy", "modulename": "sqlglot.dataframe.sql", "qualname": "WindowSpec.partitionBy", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">cols</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"o\">&lt;</span><span class=\"n\">MagicMock</span> <span class=\"nb\">id</span><span class=\"o\">=</span><span class=\"s1\">&#39;140452313094016&#39;</span><span class=\"o\">&gt;</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"o\">&lt;</span><span class=\"n\">MagicMock</span> <span class=\"nb\">id</span><span class=\"o\">=</span><span class=\"s1\">&#39;140452313094016&#39;</span><span class=\"o\">&gt;</span><span class=\"p\">]]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">window</span><span class=\"o\">.</span><span class=\"n\">WindowSpec</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.WindowSpec.orderBy": {"fullname": "sqlglot.dataframe.sql.WindowSpec.orderBy", "modulename": "sqlglot.dataframe.sql", "qualname": "WindowSpec.orderBy", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">cols</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"o\">&lt;</span><span class=\"n\">MagicMock</span> <span class=\"nb\">id</span><span class=\"o\">=</span><span class=\"s1\">&#39;140452313178048&#39;</span><span class=\"o\">&gt;</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"o\">&lt;</span><span class=\"n\">MagicMock</span> <span class=\"nb\">id</span><span class=\"o\">=</span><span class=\"s1\">&#39;140452313178048&#39;</span><span class=\"o\">&gt;</span><span class=\"p\">]]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">window</span><span class=\"o\">.</span><span class=\"n\">WindowSpec</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.WindowSpec.rowsBetween": {"fullname": "sqlglot.dataframe.sql.WindowSpec.rowsBetween", "modulename": "sqlglot.dataframe.sql", "qualname": "WindowSpec.rowsBetween", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">start</span><span class=\"p\">:</span> <span class=\"nb\">int</span>, </span><span class=\"param\"><span class=\"n\">end</span><span class=\"p\">:</span> <span class=\"nb\">int</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">window</span><span class=\"o\">.</span><span class=\"n\">WindowSpec</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.WindowSpec.rangeBetween": {"fullname": "sqlglot.dataframe.sql.WindowSpec.rangeBetween", "modulename": "sqlglot.dataframe.sql", "qualname": "WindowSpec.rangeBetween", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">start</span><span class=\"p\">:</span> <span class=\"nb\">int</span>, </span><span class=\"param\"><span class=\"n\">end</span><span class=\"p\">:</span> <span class=\"nb\">int</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">window</span><span class=\"o\">.</span><span class=\"n\">WindowSpec</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrameReader": {"fullname": "sqlglot.dataframe.sql.DataFrameReader", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrameReader", "kind": "class", "doc": "<p></p>\n"}, "sqlglot.dataframe.sql.DataFrameReader.__init__": {"fullname": "sqlglot.dataframe.sql.DataFrameReader.__init__", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrameReader.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">spark</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">session</span><span class=\"o\">.</span><span class=\"n\">SparkSession</span></span>)</span>"}, "sqlglot.dataframe.sql.DataFrameReader.spark": {"fullname": "sqlglot.dataframe.sql.DataFrameReader.spark", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrameReader.spark", "kind": "variable", "doc": "<p></p>\n"}, "sqlglot.dataframe.sql.DataFrameReader.table": {"fullname": "sqlglot.dataframe.sql.DataFrameReader.table", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrameReader.table", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">tableName</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrameWriter": {"fullname": "sqlglot.dataframe.sql.DataFrameWriter", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrameWriter", "kind": "class", "doc": "<p></p>\n"}, "sqlglot.dataframe.sql.DataFrameWriter.__init__": {"fullname": "sqlglot.dataframe.sql.DataFrameWriter.__init__", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrameWriter.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">df</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>,</span><span class=\"param\">\t<span class=\"n\">spark</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">session</span><span class=\"o\">.</span><span class=\"n\">SparkSession</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">mode</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">by_name</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span></span>)</span>"}, "sqlglot.dataframe.sql.DataFrameWriter.copy": {"fullname": "sqlglot.dataframe.sql.DataFrameWriter.copy", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrameWriter.copy", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">readwriter</span><span class=\"o\">.</span><span class=\"n\">DataFrameWriter</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrameWriter.sql": {"fullname": "sqlglot.dataframe.sql.DataFrameWriter.sql", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrameWriter.sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrameWriter.mode": {"fullname": "sqlglot.dataframe.sql.DataFrameWriter.mode", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrameWriter.mode", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">saveMode</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">readwriter</span><span class=\"o\">.</span><span class=\"n\">DataFrameWriter</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrameWriter.byName": {"fullname": "sqlglot.dataframe.sql.DataFrameWriter.byName", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrameWriter.byName", "kind": "variable", "doc": "<p></p>\n"}, "sqlglot.dataframe.sql.DataFrameWriter.insertInto": {"fullname": "sqlglot.dataframe.sql.DataFrameWriter.insertInto", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrameWriter.insertInto", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">tableName</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">overwrite</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">readwriter</span><span class=\"o\">.</span><span class=\"n\">DataFrameWriter</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrameWriter.saveAsTable": {"fullname": "sqlglot.dataframe.sql.DataFrameWriter.saveAsTable", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrameWriter.saveAsTable", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"nb\">format</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">mode</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlglot.dialects": {"fullname": "sqlglot.dialects", "modulename": "sqlglot.dialects", "kind": "module", "doc": "<h2 id=\"dialects\">Dialects</h2>\n\n<p>While there is a SQL standard, most SQL engines support a variation of that standard. This makes it difficult\nto write portable SQL code. SQLGlot bridges all the different variations, called \"dialects\", with an extensible\nSQL transpilation framework. </p>\n\n<p>The base <code>sqlglot.dialects.dialect.Dialect</code> class implements a generic dialect that aims to be as universal as possible.</p>\n\n<p>Each SQL variation has its own <code>Dialect</code> subclass, extending the corresponding <code>Tokenizer</code>, <code>Parser</code> and <code>Generator</code>\nclasses as needed.</p>\n\n<h3 id=\"implementing-a-custom-dialect\">Implementing a custom Dialect</h3>\n\n<p>Consider the following example:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"kn\">from</span> <span class=\"nn\">sqlglot</span> <span class=\"kn\">import</span> <span class=\"n\">exp</span>\n<span class=\"kn\">from</span> <span class=\"nn\">sqlglot.dialects.dialect</span> <span class=\"kn\">import</span> <span class=\"n\">Dialect</span>\n<span class=\"kn\">from</span> <span class=\"nn\">sqlglot.generator</span> <span class=\"kn\">import</span> <span class=\"n\">Generator</span>\n<span class=\"kn\">from</span> <span class=\"nn\">sqlglot.tokens</span> <span class=\"kn\">import</span> <span class=\"n\">Tokenizer</span><span class=\"p\">,</span> <span class=\"n\">TokenType</span>\n\n\n<span class=\"k\">class</span> <span class=\"nc\">Custom</span><span class=\"p\">(</span><span class=\"n\">Dialect</span><span class=\"p\">):</span>\n    <span class=\"k\">class</span> <span class=\"nc\">Tokenizer</span><span class=\"p\">(</span><span class=\"n\">Tokenizer</span><span class=\"p\">):</span>\n        <span class=\"n\">QUOTES</span> <span class=\"o\">=</span> <span class=\"p\">[</span><span class=\"s2\">&quot;&#39;&quot;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;&quot;&#39;</span><span class=\"p\">]</span>\n        <span class=\"n\">IDENTIFIERS</span> <span class=\"o\">=</span> <span class=\"p\">[</span><span class=\"s2\">&quot;`&quot;</span><span class=\"p\">]</span>\n\n        <span class=\"n\">KEYWORDS</span> <span class=\"o\">=</span> <span class=\"p\">{</span>\n            <span class=\"o\">**</span><span class=\"n\">Tokenizer</span><span class=\"o\">.</span><span class=\"n\">KEYWORDS</span><span class=\"p\">,</span>\n            <span class=\"s2\">&quot;INT64&quot;</span><span class=\"p\">:</span> <span class=\"n\">TokenType</span><span class=\"o\">.</span><span class=\"n\">BIGINT</span><span class=\"p\">,</span>\n            <span class=\"s2\">&quot;FLOAT64&quot;</span><span class=\"p\">:</span> <span class=\"n\">TokenType</span><span class=\"o\">.</span><span class=\"n\">DOUBLE</span><span class=\"p\">,</span>\n        <span class=\"p\">}</span>\n\n    <span class=\"k\">class</span> <span class=\"nc\">Generator</span><span class=\"p\">(</span><span class=\"n\">Generator</span><span class=\"p\">):</span>\n        <span class=\"n\">TRANSFORMS</span> <span class=\"o\">=</span> <span class=\"p\">{</span><span class=\"n\">exp</span><span class=\"o\">.</span><span class=\"n\">Array</span><span class=\"p\">:</span> <span class=\"k\">lambda</span> <span class=\"bp\">self</span><span class=\"p\">,</span> <span class=\"n\">e</span><span class=\"p\">:</span> <span class=\"sa\">f</span><span class=\"s2\">&quot;[</span><span class=\"si\">{</span><span class=\"bp\">self</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"p\">(</span><span class=\"n\">e</span><span class=\"p\">)</span><span class=\"si\">}</span><span class=\"s2\">]&quot;</span><span class=\"p\">}</span>\n\n        <span class=\"n\">TYPE_MAPPING</span> <span class=\"o\">=</span> <span class=\"p\">{</span>\n            <span class=\"n\">exp</span><span class=\"o\">.</span><span class=\"n\">DataType</span><span class=\"o\">.</span><span class=\"n\">Type</span><span class=\"o\">.</span><span class=\"n\">TINYINT</span><span class=\"p\">:</span> <span class=\"s2\">&quot;INT64&quot;</span><span class=\"p\">,</span>\n            <span class=\"n\">exp</span><span class=\"o\">.</span><span class=\"n\">DataType</span><span class=\"o\">.</span><span class=\"n\">Type</span><span class=\"o\">.</span><span class=\"n\">SMALLINT</span><span class=\"p\">:</span> <span class=\"s2\">&quot;INT64&quot;</span><span class=\"p\">,</span>\n            <span class=\"n\">exp</span><span class=\"o\">.</span><span class=\"n\">DataType</span><span class=\"o\">.</span><span class=\"n\">Type</span><span class=\"o\">.</span><span class=\"n\">INT</span><span class=\"p\">:</span> <span class=\"s2\">&quot;INT64&quot;</span><span class=\"p\">,</span>\n            <span class=\"n\">exp</span><span class=\"o\">.</span><span class=\"n\">DataType</span><span class=\"o\">.</span><span class=\"n\">Type</span><span class=\"o\">.</span><span class=\"n\">BIGINT</span><span class=\"p\">:</span> <span class=\"s2\">&quot;INT64&quot;</span><span class=\"p\">,</span>\n            <span class=\"n\">exp</span><span class=\"o\">.</span><span class=\"n\">DataType</span><span class=\"o\">.</span><span class=\"n\">Type</span><span class=\"o\">.</span><span class=\"n\">DECIMAL</span><span class=\"p\">:</span> <span class=\"s2\">&quot;NUMERIC&quot;</span><span class=\"p\">,</span>\n            <span class=\"n\">exp</span><span class=\"o\">.</span><span class=\"n\">DataType</span><span class=\"o\">.</span><span class=\"n\">Type</span><span class=\"o\">.</span><span class=\"n\">FLOAT</span><span class=\"p\">:</span> <span class=\"s2\">&quot;FLOAT64&quot;</span><span class=\"p\">,</span>\n            <span class=\"n\">exp</span><span class=\"o\">.</span><span class=\"n\">DataType</span><span class=\"o\">.</span><span class=\"n\">Type</span><span class=\"o\">.</span><span class=\"n\">DOUBLE</span><span class=\"p\">:</span> <span class=\"s2\">&quot;FLOAT64&quot;</span><span class=\"p\">,</span>\n            <span class=\"n\">exp</span><span class=\"o\">.</span><span class=\"n\">DataType</span><span class=\"o\">.</span><span class=\"n\">Type</span><span class=\"o\">.</span><span class=\"n\">BOOLEAN</span><span class=\"p\">:</span> <span class=\"s2\">&quot;BOOL&quot;</span><span class=\"p\">,</span>\n            <span class=\"n\">exp</span><span class=\"o\">.</span><span class=\"n\">DataType</span><span class=\"o\">.</span><span class=\"n\">Type</span><span class=\"o\">.</span><span class=\"n\">TEXT</span><span class=\"p\">:</span> <span class=\"s2\">&quot;STRING&quot;</span><span class=\"p\">,</span>\n        <span class=\"p\">}</span>\n</code></pre>\n</div>\n\n<p>This is a typical example of adding a new dialect implementation in SQLGlot: we specify its identifier and string\ndelimiters, as well as what tokens it uses for its types and how they're associated with SQLGlot types. Since\nthe <code>Expression</code> classes are common for each dialect supported in SQLGlot, we may also need to override the generation\nlogic for some expressions; this is usually done by adding new entries to the <code>TRANSFORMS</code> mapping.</p>\n\n<hr />\n"}, "sqlglot.dialects.bigquery": {"fullname": "sqlglot.dialects.bigquery", "modulename": "sqlglot.dialects.bigquery", "kind": "module", "doc": "<p></p>\n"}, "sqlglot.dialects.bigquery.logger": {"fullname": "sqlglot.dialects.bigquery.logger", "modulename": "sqlglot.dialects.bigquery", "qualname": "logger", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Logger sqlglot (WARNING)&gt;"}, "sqlglot.dialects.bigquery.BigQuery": {"fullname": "sqlglot.dialects.bigquery.BigQuery", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery", "kind": "class", "doc": "<p></p>\n", "bases": "sqlglot.dialects.dialect.Dialect"}, "sqlglot.dialects.bigquery.BigQuery.UNNEST_COLUMN_ONLY": {"fullname": "sqlglot.dialects.bigquery.BigQuery.UNNEST_COLUMN_ONLY", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.UNNEST_COLUMN_ONLY", "kind": "variable", "doc": "<p></p>\n", "default_value": "True"}, "sqlglot.dialects.bigquery.BigQuery.SUPPORTS_USER_DEFINED_TYPES": {"fullname": "sqlglot.dialects.bigquery.BigQuery.SUPPORTS_USER_DEFINED_TYPES", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.SUPPORTS_USER_DEFINED_TYPES", "kind": "variable", "doc": "<p></p>\n", "default_value": "False"}, "sqlglot.dialects.bigquery.BigQuery.SUPPORTS_SEMI_ANTI_JOIN": {"fullname": "sqlglot.dialects.bigquery.BigQuery.SUPPORTS_SEMI_ANTI_JOIN", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.SUPPORTS_SEMI_ANTI_JOIN", "kind": "variable", "doc": "<p></p>\n", "default_value": "False"}, "sqlglot.dialects.bigquery.BigQuery.LOG_BASE_FIRST": {"fullname": "sqlglot.dialects.bigquery.BigQuery.LOG_BASE_FIRST", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.LOG_BASE_FIRST", "kind": "variable", "doc": "<p></p>\n", "default_value": "False"}, "sqlglot.dialects.bigquery.BigQuery.RESOLVES_IDENTIFIERS_AS_UPPERCASE": {"fullname": "sqlglot.dialects.bigquery.BigQuery.RESOLVES_IDENTIFIERS_AS_UPPERCASE", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.RESOLVES_IDENTIFIERS_AS_UPPERCASE", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Optional[bool]", "default_value": "None"}, "sqlglot.dialects.bigquery.BigQuery.NORMALIZE_FUNCTIONS": {"fullname": "sqlglot.dialects.bigquery.BigQuery.NORMALIZE_FUNCTIONS", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.NORMALIZE_FUNCTIONS", "kind": "variable", "doc": "<p></p>\n", "annotation": ": bool | str", "default_value": "False"}, "sqlglot.dialects.bigquery.BigQuery.TIME_MAPPING": {"fullname": "sqlglot.dialects.bigquery.BigQuery.TIME_MAPPING", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.TIME_MAPPING", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict[str, str]", "default_value": "{&#x27;%D&#x27;: &#x27;%m/%d/%y&#x27;}"}, "sqlglot.dialects.bigquery.BigQuery.ESCAPE_SEQUENCES": {"fullname": "sqlglot.dialects.bigquery.BigQuery.ESCAPE_SEQUENCES", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.ESCAPE_SEQUENCES", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict[str, str]", "default_value": "{&#x27;\\\\a&#x27;: &#x27;\\x07&#x27;, &#x27;\\\\b&#x27;: &#x27;\\x08&#x27;, &#x27;\\\\f&#x27;: &#x27;\\x0c&#x27;, &#x27;\\\\n&#x27;: &#x27;\\n&#x27;, &#x27;\\\\r&#x27;: &#x27;\\r&#x27;, &#x27;\\\\t&#x27;: &#x27;\\t&#x27;, &#x27;\\\\v&#x27;: &#x27;\\x0b&#x27;}"}, "sqlglot.dialects.bigquery.BigQuery.FORMAT_MAPPING": {"fullname": "sqlglot.dialects.bigquery.BigQuery.FORMAT_MAPPING", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.FORMAT_MAPPING", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict[str, str]", "default_value": "{&#x27;DD&#x27;: &#x27;%d&#x27;, &#x27;MM&#x27;: &#x27;%m&#x27;, &#x27;MON&#x27;: &#x27;%b&#x27;, &#x27;MONTH&#x27;: &#x27;%B&#x27;, &#x27;YYYY&#x27;: &#x27;%Y&#x27;, &#x27;YY&#x27;: &#x27;%y&#x27;, &#x27;HH&#x27;: &#x27;%I&#x27;, &#x27;HH12&#x27;: &#x27;%I&#x27;, &#x27;HH24&#x27;: &#x27;%H&#x27;, &#x27;MI&#x27;: &#x27;%M&#x27;, &#x27;SS&#x27;: &#x27;%S&#x27;, &#x27;SSSSS&#x27;: &#x27;%f&#x27;, &#x27;TZH&#x27;: &#x27;%z&#x27;}"}, "sqlglot.dialects.bigquery.BigQuery.PSEUDOCOLUMNS": {"fullname": "sqlglot.dialects.bigquery.BigQuery.PSEUDOCOLUMNS", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.PSEUDOCOLUMNS", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Set[str]", "default_value": "{&#x27;_PARTITIONTIME&#x27;, &#x27;_PARTITIONDATE&#x27;}"}, "sqlglot.dialects.bigquery.BigQuery.normalize_identifier": {"fullname": "sqlglot.dialects.bigquery.BigQuery.normalize_identifier", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.normalize_identifier", "kind": "function", "doc": "<p>Normalizes an unquoted identifier to either lower or upper case, thus essentially\nmaking it case-insensitive. If a dialect treats all identifiers as case-insensitive,\nthey will be normalized to lowercase regardless of being quoted or not.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span>, </span><span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"o\">~</span><span class=\"n\">E</span></span><span class=\"return-annotation\">) -> <span class=\"o\">~</span><span class=\"n\">E</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.bigquery.BigQuery.Tokenizer": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Tokenizer", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Tokenizer", "kind": "class", "doc": "<p></p>\n", "bases": "sqlglot.tokens.Tokenizer"}, "sqlglot.dialects.bigquery.BigQuery.Tokenizer.QUOTES": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Tokenizer.QUOTES", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Tokenizer.QUOTES", "kind": "variable", "doc": "<p></p>\n", "default_value": "[&quot;&#x27;&quot;, &#x27;&quot;&#x27;, &#x27;&quot;&quot;&quot;&#x27;, &quot;&#x27;&#x27;&#x27;&quot;]"}, "sqlglot.dialects.bigquery.BigQuery.Tokenizer.COMMENTS": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Tokenizer.COMMENTS", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Tokenizer.COMMENTS", "kind": "variable", "doc": "<p></p>\n", "default_value": "[&#x27;--&#x27;, &#x27;#&#x27;, (&#x27;/*&#x27;, &#x27;*/&#x27;)]"}, "sqlglot.dialects.bigquery.BigQuery.Tokenizer.IDENTIFIERS": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Tokenizer.IDENTIFIERS", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Tokenizer.IDENTIFIERS", "kind": "variable", "doc": "<p></p>\n", "default_value": "[&#x27;`&#x27;]"}, "sqlglot.dialects.bigquery.BigQuery.Tokenizer.STRING_ESCAPES": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Tokenizer.STRING_ESCAPES", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Tokenizer.STRING_ESCAPES", "kind": "variable", "doc": "<p></p>\n", "default_value": "[&#x27;\\\\&#x27;]"}, "sqlglot.dialects.bigquery.BigQuery.Tokenizer.HEX_STRINGS": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Tokenizer.HEX_STRINGS", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Tokenizer.HEX_STRINGS", "kind": "variable", "doc": "<p></p>\n", "default_value": "[(&#x27;0x&#x27;, &#x27;&#x27;), (&#x27;0X&#x27;, &#x27;&#x27;)]"}, "sqlglot.dialects.bigquery.BigQuery.Tokenizer.BYTE_STRINGS": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Tokenizer.BYTE_STRINGS", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Tokenizer.BYTE_STRINGS", "kind": "variable", "doc": "<p></p>\n", "default_value": "[(&quot;b&#x27;&quot;, &quot;&#x27;&quot;), (&quot;B&#x27;&quot;, &quot;&#x27;&quot;), (&#x27;b&quot;&#x27;, &#x27;&quot;&#x27;), (&#x27;B&quot;&#x27;, &#x27;&quot;&#x27;), (&#x27;b&quot;&quot;&quot;&#x27;, &#x27;&quot;&quot;&quot;&#x27;), (&#x27;B&quot;&quot;&quot;&#x27;, &#x27;&quot;&quot;&quot;&#x27;), (&quot;b&#x27;&#x27;&#x27;&quot;, &quot;&#x27;&#x27;&#x27;&quot;), (&quot;B&#x27;&#x27;&#x27;&quot;, &quot;&#x27;&#x27;&#x27;&quot;)]"}, "sqlglot.dialects.bigquery.BigQuery.Tokenizer.RAW_STRINGS": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Tokenizer.RAW_STRINGS", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Tokenizer.RAW_STRINGS", "kind": "variable", "doc": "<p></p>\n", "default_value": "[(&quot;r&#x27;&quot;, &quot;&#x27;&quot;), (&quot;R&#x27;&quot;, &quot;&#x27;&quot;), (&#x27;r&quot;&#x27;, &#x27;&quot;&#x27;), (&#x27;R&quot;&#x27;, &#x27;&quot;&#x27;), (&#x27;r&quot;&quot;&quot;&#x27;, &#x27;&quot;&quot;&quot;&#x27;), (&#x27;R&quot;&quot;&quot;&#x27;, &#x27;&quot;&quot;&quot;&#x27;), (&quot;r&#x27;&#x27;&#x27;&quot;, &quot;&#x27;&#x27;&#x27;&quot;), (&quot;R&#x27;&#x27;&#x27;&quot;, &quot;&#x27;&#x27;&#x27;&quot;)]"}, "sqlglot.dialects.bigquery.BigQuery.Tokenizer.KEYWORDS": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Tokenizer.KEYWORDS", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Tokenizer.KEYWORDS", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;{%&#x27;: &lt;TokenType.BLOCK_START: &#x27;BLOCK_START&#x27;&gt;, &#x27;{%+&#x27;: &lt;TokenType.BLOCK_START: &#x27;BLOCK_START&#x27;&gt;, &#x27;{%-&#x27;: &lt;TokenType.BLOCK_START: &#x27;BLOCK_START&#x27;&gt;, &#x27;%}&#x27;: &lt;TokenType.BLOCK_END: &#x27;BLOCK_END&#x27;&gt;, &#x27;+%}&#x27;: &lt;TokenType.BLOCK_END: &#x27;BLOCK_END&#x27;&gt;, &#x27;-%}&#x27;: &lt;TokenType.BLOCK_END: &#x27;BLOCK_END&#x27;&gt;, &#x27;{{+&#x27;: &lt;TokenType.BLOCK_START: &#x27;BLOCK_START&#x27;&gt;, &#x27;{{-&#x27;: &lt;TokenType.BLOCK_START: &#x27;BLOCK_START&#x27;&gt;, &#x27;+}}&#x27;: &lt;TokenType.BLOCK_END: &#x27;BLOCK_END&#x27;&gt;, &#x27;-}}&#x27;: &lt;TokenType.BLOCK_END: &#x27;BLOCK_END&#x27;&gt;, &#x27;/*+&#x27;: &lt;TokenType.HINT: &#x27;HINT&#x27;&gt;, &#x27;==&#x27;: &lt;TokenType.EQ: &#x27;EQ&#x27;&gt;, &#x27;::&#x27;: &lt;TokenType.DCOLON: &#x27;DCOLON&#x27;&gt;, &#x27;||&#x27;: &lt;TokenType.DPIPE: &#x27;DPIPE&#x27;&gt;, &#x27;&gt;=&#x27;: &lt;TokenType.GTE: &#x27;GTE&#x27;&gt;, &#x27;&lt;=&#x27;: &lt;TokenType.LTE: &#x27;LTE&#x27;&gt;, &#x27;&lt;&gt;&#x27;: &lt;TokenType.NEQ: &#x27;NEQ&#x27;&gt;, &#x27;!=&#x27;: &lt;TokenType.NEQ: &#x27;NEQ&#x27;&gt;, &#x27;&lt;=&gt;&#x27;: &lt;TokenType.NULLSAFE_EQ: &#x27;NULLSAFE_EQ&#x27;&gt;, &#x27;-&gt;&#x27;: &lt;TokenType.ARROW: &#x27;ARROW&#x27;&gt;, &#x27;-&gt;&gt;&#x27;: &lt;TokenType.DARROW: &#x27;DARROW&#x27;&gt;, &#x27;=&gt;&#x27;: &lt;TokenType.FARROW: &#x27;FARROW&#x27;&gt;, &#x27;#&gt;&#x27;: &lt;TokenType.HASH_ARROW: &#x27;HASH_ARROW&#x27;&gt;, &#x27;#&gt;&gt;&#x27;: &lt;TokenType.DHASH_ARROW: &#x27;DHASH_ARROW&#x27;&gt;, &#x27;&lt;-&gt;&#x27;: &lt;TokenType.LR_ARROW: &#x27;LR_ARROW&#x27;&gt;, &#x27;&amp;&amp;&#x27;: &lt;TokenType.DAMP: &#x27;DAMP&#x27;&gt;, &#x27;??&#x27;: &lt;TokenType.DQMARK: &#x27;DQMARK&#x27;&gt;, &#x27;ALL&#x27;: &lt;TokenType.ALL: &#x27;ALL&#x27;&gt;, &#x27;ALWAYS&#x27;: &lt;TokenType.ALWAYS: &#x27;ALWAYS&#x27;&gt;, &#x27;AND&#x27;: &lt;TokenType.AND: &#x27;AND&#x27;&gt;, &#x27;ANTI&#x27;: &lt;TokenType.ANTI: &#x27;ANTI&#x27;&gt;, &#x27;ANY&#x27;: &lt;TokenType.ANY: &#x27;ANY&#x27;&gt;, &#x27;ASC&#x27;: &lt;TokenType.ASC: &#x27;ASC&#x27;&gt;, &#x27;AS&#x27;: &lt;TokenType.ALIAS: &#x27;ALIAS&#x27;&gt;, &#x27;ASOF&#x27;: &lt;TokenType.ASOF: &#x27;ASOF&#x27;&gt;, &#x27;AUTOINCREMENT&#x27;: &lt;TokenType.AUTO_INCREMENT: &#x27;AUTO_INCREMENT&#x27;&gt;, &#x27;AUTO_INCREMENT&#x27;: &lt;TokenType.AUTO_INCREMENT: &#x27;AUTO_INCREMENT&#x27;&gt;, &#x27;BEGIN&#x27;: &lt;TokenType.COMMAND: &#x27;COMMAND&#x27;&gt;, &#x27;BETWEEN&#x27;: &lt;TokenType.BETWEEN: &#x27;BETWEEN&#x27;&gt;, &#x27;CACHE&#x27;: &lt;TokenType.CACHE: &#x27;CACHE&#x27;&gt;, &#x27;UNCACHE&#x27;: &lt;TokenType.UNCACHE: &#x27;UNCACHE&#x27;&gt;, &#x27;CASE&#x27;: &lt;TokenType.CASE: &#x27;CASE&#x27;&gt;, &#x27;CHARACTER SET&#x27;: &lt;TokenType.CHARACTER_SET: &#x27;CHARACTER_SET&#x27;&gt;, &#x27;CLUSTER BY&#x27;: &lt;TokenType.CLUSTER_BY: &#x27;CLUSTER_BY&#x27;&gt;, &#x27;COLLATE&#x27;: &lt;TokenType.COLLATE: &#x27;COLLATE&#x27;&gt;, &#x27;COLUMN&#x27;: &lt;TokenType.COLUMN: &#x27;COLUMN&#x27;&gt;, &#x27;COMMIT&#x27;: &lt;TokenType.COMMIT: &#x27;COMMIT&#x27;&gt;, &#x27;CONNECT BY&#x27;: &lt;TokenType.CONNECT_BY: &#x27;CONNECT_BY&#x27;&gt;, &#x27;CONSTRAINT&#x27;: &lt;TokenType.CONSTRAINT: &#x27;CONSTRAINT&#x27;&gt;, &#x27;CREATE&#x27;: &lt;TokenType.CREATE: &#x27;CREATE&#x27;&gt;, &#x27;CROSS&#x27;: &lt;TokenType.CROSS: &#x27;CROSS&#x27;&gt;, &#x27;CUBE&#x27;: &lt;TokenType.CUBE: &#x27;CUBE&#x27;&gt;, &#x27;CURRENT_DATE&#x27;: &lt;TokenType.CURRENT_DATE: &#x27;CURRENT_DATE&#x27;&gt;, &#x27;CURRENT_TIME&#x27;: &lt;TokenType.CURRENT_TIME: &#x27;CURRENT_TIME&#x27;&gt;, &#x27;CURRENT_TIMESTAMP&#x27;: &lt;TokenType.CURRENT_TIMESTAMP: &#x27;CURRENT_TIMESTAMP&#x27;&gt;, &#x27;CURRENT_USER&#x27;: &lt;TokenType.CURRENT_USER: &#x27;CURRENT_USER&#x27;&gt;, &#x27;DATABASE&#x27;: &lt;TokenType.DATABASE: &#x27;DATABASE&#x27;&gt;, &#x27;DEFAULT&#x27;: &lt;TokenType.DEFAULT: &#x27;DEFAULT&#x27;&gt;, &#x27;DELETE&#x27;: &lt;TokenType.DELETE: &#x27;DELETE&#x27;&gt;, &#x27;DESC&#x27;: &lt;TokenType.DESC: &#x27;DESC&#x27;&gt;, &#x27;DESCRIBE&#x27;: &lt;TokenType.DESCRIBE: &#x27;DESCRIBE&#x27;&gt;, &#x27;DISTINCT&#x27;: &lt;TokenType.DISTINCT: &#x27;DISTINCT&#x27;&gt;, &#x27;DISTRIBUTE BY&#x27;: &lt;TokenType.DISTRIBUTE_BY: &#x27;DISTRIBUTE_BY&#x27;&gt;, &#x27;DROP&#x27;: &lt;TokenType.DROP: &#x27;DROP&#x27;&gt;, &#x27;ELSE&#x27;: &lt;TokenType.ELSE: &#x27;ELSE&#x27;&gt;, &#x27;END&#x27;: &lt;TokenType.END: &#x27;END&#x27;&gt;, &#x27;ESCAPE&#x27;: &lt;TokenType.ESCAPE: &#x27;ESCAPE&#x27;&gt;, &#x27;EXCEPT&#x27;: &lt;TokenType.EXCEPT: &#x27;EXCEPT&#x27;&gt;, &#x27;EXECUTE&#x27;: &lt;TokenType.EXECUTE: &#x27;EXECUTE&#x27;&gt;, &#x27;EXISTS&#x27;: &lt;TokenType.EXISTS: &#x27;EXISTS&#x27;&gt;, &#x27;FALSE&#x27;: &lt;TokenType.FALSE: &#x27;FALSE&#x27;&gt;, &#x27;FETCH&#x27;: &lt;TokenType.FETCH: &#x27;FETCH&#x27;&gt;, &#x27;FILTER&#x27;: &lt;TokenType.FILTER: &#x27;FILTER&#x27;&gt;, &#x27;FIRST&#x27;: &lt;TokenType.FIRST: &#x27;FIRST&#x27;&gt;, &#x27;FULL&#x27;: &lt;TokenType.FULL: &#x27;FULL&#x27;&gt;, &#x27;FUNCTION&#x27;: &lt;TokenType.FUNCTION: &#x27;FUNCTION&#x27;&gt;, &#x27;FOR&#x27;: &lt;TokenType.FOR: &#x27;FOR&#x27;&gt;, &#x27;FOREIGN KEY&#x27;: &lt;TokenType.FOREIGN_KEY: &#x27;FOREIGN_KEY&#x27;&gt;, &#x27;FORMAT&#x27;: &lt;TokenType.FORMAT: &#x27;FORMAT&#x27;&gt;, &#x27;FROM&#x27;: &lt;TokenType.FROM: &#x27;FROM&#x27;&gt;, &#x27;GEOGRAPHY&#x27;: &lt;TokenType.GEOGRAPHY: &#x27;GEOGRAPHY&#x27;&gt;, &#x27;GEOMETRY&#x27;: &lt;TokenType.GEOMETRY: &#x27;GEOMETRY&#x27;&gt;, &#x27;GLOB&#x27;: &lt;TokenType.GLOB: &#x27;GLOB&#x27;&gt;, &#x27;GROUP BY&#x27;: &lt;TokenType.GROUP_BY: &#x27;GROUP_BY&#x27;&gt;, &#x27;GROUPING SETS&#x27;: &lt;TokenType.GROUPING_SETS: &#x27;GROUPING_SETS&#x27;&gt;, &#x27;HAVING&#x27;: &lt;TokenType.HAVING: &#x27;HAVING&#x27;&gt;, &#x27;ILIKE&#x27;: &lt;TokenType.ILIKE: &#x27;ILIKE&#x27;&gt;, &#x27;IN&#x27;: &lt;TokenType.IN: &#x27;IN&#x27;&gt;, &#x27;INDEX&#x27;: &lt;TokenType.INDEX: &#x27;INDEX&#x27;&gt;, &#x27;INET&#x27;: &lt;TokenType.INET: &#x27;INET&#x27;&gt;, &#x27;INNER&#x27;: &lt;TokenType.INNER: &#x27;INNER&#x27;&gt;, &#x27;INSERT&#x27;: &lt;TokenType.INSERT: &#x27;INSERT&#x27;&gt;, &#x27;INTERVAL&#x27;: &lt;TokenType.INTERVAL: &#x27;INTERVAL&#x27;&gt;, &#x27;INTERSECT&#x27;: &lt;TokenType.INTERSECT: &#x27;INTERSECT&#x27;&gt;, &#x27;INTO&#x27;: &lt;TokenType.INTO: &#x27;INTO&#x27;&gt;, &#x27;IS&#x27;: &lt;TokenType.IS: &#x27;IS&#x27;&gt;, &#x27;ISNULL&#x27;: &lt;TokenType.ISNULL: &#x27;ISNULL&#x27;&gt;, &#x27;JOIN&#x27;: &lt;TokenType.JOIN: &#x27;JOIN&#x27;&gt;, &#x27;KEEP&#x27;: &lt;TokenType.KEEP: &#x27;KEEP&#x27;&gt;, &#x27;KILL&#x27;: &lt;TokenType.KILL: &#x27;KILL&#x27;&gt;, &#x27;LATERAL&#x27;: &lt;TokenType.LATERAL: &#x27;LATERAL&#x27;&gt;, &#x27;LEFT&#x27;: &lt;TokenType.LEFT: &#x27;LEFT&#x27;&gt;, &#x27;LIKE&#x27;: &lt;TokenType.LIKE: &#x27;LIKE&#x27;&gt;, &#x27;LIMIT&#x27;: &lt;TokenType.LIMIT: &#x27;LIMIT&#x27;&gt;, &#x27;LOAD&#x27;: &lt;TokenType.LOAD: &#x27;LOAD&#x27;&gt;, &#x27;LOCK&#x27;: &lt;TokenType.LOCK: &#x27;LOCK&#x27;&gt;, &#x27;MERGE&#x27;: &lt;TokenType.MERGE: &#x27;MERGE&#x27;&gt;, &#x27;NATURAL&#x27;: &lt;TokenType.NATURAL: &#x27;NATURAL&#x27;&gt;, &#x27;NEXT&#x27;: &lt;TokenType.NEXT: &#x27;NEXT&#x27;&gt;, &#x27;NOT&#x27;: &lt;TokenType.NOT: &#x27;NOT&#x27;&gt;, &#x27;NOTNULL&#x27;: &lt;TokenType.NOTNULL: &#x27;NOTNULL&#x27;&gt;, &#x27;NULL&#x27;: &lt;TokenType.NULL: &#x27;NULL&#x27;&gt;, &#x27;OBJECT&#x27;: &lt;TokenType.OBJECT: &#x27;OBJECT&#x27;&gt;, &#x27;OFFSET&#x27;: &lt;TokenType.OFFSET: &#x27;OFFSET&#x27;&gt;, &#x27;ON&#x27;: &lt;TokenType.ON: &#x27;ON&#x27;&gt;, &#x27;OR&#x27;: &lt;TokenType.OR: &#x27;OR&#x27;&gt;, &#x27;XOR&#x27;: &lt;TokenType.XOR: &#x27;XOR&#x27;&gt;, &#x27;ORDER BY&#x27;: &lt;TokenType.ORDER_BY: &#x27;ORDER_BY&#x27;&gt;, &#x27;ORDINALITY&#x27;: &lt;TokenType.ORDINALITY: &#x27;ORDINALITY&#x27;&gt;, &#x27;OUTER&#x27;: &lt;TokenType.OUTER: &#x27;OUTER&#x27;&gt;, &#x27;OVER&#x27;: &lt;TokenType.OVER: &#x27;OVER&#x27;&gt;, &#x27;OVERLAPS&#x27;: &lt;TokenType.OVERLAPS: &#x27;OVERLAPS&#x27;&gt;, &#x27;OVERWRITE&#x27;: &lt;TokenType.OVERWRITE: &#x27;OVERWRITE&#x27;&gt;, &#x27;PARTITION&#x27;: &lt;TokenType.PARTITION: &#x27;PARTITION&#x27;&gt;, &#x27;PARTITION BY&#x27;: &lt;TokenType.PARTITION_BY: &#x27;PARTITION_BY&#x27;&gt;, &#x27;PARTITIONED BY&#x27;: &lt;TokenType.PARTITION_BY: &#x27;PARTITION_BY&#x27;&gt;, &#x27;PARTITIONED_BY&#x27;: &lt;TokenType.PARTITION_BY: &#x27;PARTITION_BY&#x27;&gt;, &#x27;PERCENT&#x27;: &lt;TokenType.PERCENT: &#x27;PERCENT&#x27;&gt;, &#x27;PIVOT&#x27;: &lt;TokenType.PIVOT: &#x27;PIVOT&#x27;&gt;, &#x27;PRAGMA&#x27;: &lt;TokenType.PRAGMA: &#x27;PRAGMA&#x27;&gt;, &#x27;PRIMARY KEY&#x27;: &lt;TokenType.PRIMARY_KEY: &#x27;PRIMARY_KEY&#x27;&gt;, &#x27;PROCEDURE&#x27;: &lt;TokenType.PROCEDURE: &#x27;PROCEDURE&#x27;&gt;, &#x27;QUALIFY&#x27;: &lt;TokenType.QUALIFY: &#x27;QUALIFY&#x27;&gt;, &#x27;RANGE&#x27;: &lt;TokenType.RANGE: &#x27;RANGE&#x27;&gt;, &#x27;RECURSIVE&#x27;: &lt;TokenType.RECURSIVE: &#x27;RECURSIVE&#x27;&gt;, &#x27;REGEXP&#x27;: &lt;TokenType.RLIKE: &#x27;RLIKE&#x27;&gt;, &#x27;REPLACE&#x27;: &lt;TokenType.REPLACE: &#x27;REPLACE&#x27;&gt;, &#x27;RETURNING&#x27;: &lt;TokenType.RETURNING: &#x27;RETURNING&#x27;&gt;, &#x27;REFERENCES&#x27;: &lt;TokenType.REFERENCES: &#x27;REFERENCES&#x27;&gt;, &#x27;RIGHT&#x27;: &lt;TokenType.RIGHT: &#x27;RIGHT&#x27;&gt;, &#x27;RLIKE&#x27;: &lt;TokenType.RLIKE: &#x27;RLIKE&#x27;&gt;, &#x27;ROLLBACK&#x27;: &lt;TokenType.ROLLBACK: &#x27;ROLLBACK&#x27;&gt;, &#x27;ROLLUP&#x27;: &lt;TokenType.ROLLUP: &#x27;ROLLUP&#x27;&gt;, &#x27;ROW&#x27;: &lt;TokenType.ROW: &#x27;ROW&#x27;&gt;, &#x27;ROWS&#x27;: &lt;TokenType.ROWS: &#x27;ROWS&#x27;&gt;, &#x27;SCHEMA&#x27;: &lt;TokenType.SCHEMA: &#x27;SCHEMA&#x27;&gt;, &#x27;SELECT&#x27;: &lt;TokenType.SELECT: &#x27;SELECT&#x27;&gt;, &#x27;SEMI&#x27;: &lt;TokenType.SEMI: &#x27;SEMI&#x27;&gt;, &#x27;SET&#x27;: &lt;TokenType.SET: &#x27;SET&#x27;&gt;, &#x27;SETTINGS&#x27;: &lt;TokenType.SETTINGS: &#x27;SETTINGS&#x27;&gt;, &#x27;SHOW&#x27;: &lt;TokenType.SHOW: &#x27;SHOW&#x27;&gt;, &#x27;SIMILAR TO&#x27;: &lt;TokenType.SIMILAR_TO: &#x27;SIMILAR_TO&#x27;&gt;, &#x27;SOME&#x27;: &lt;TokenType.SOME: &#x27;SOME&#x27;&gt;, &#x27;SORT BY&#x27;: &lt;TokenType.SORT_BY: &#x27;SORT_BY&#x27;&gt;, &#x27;START WITH&#x27;: &lt;TokenType.START_WITH: &#x27;START_WITH&#x27;&gt;, &#x27;TABLE&#x27;: &lt;TokenType.TABLE: &#x27;TABLE&#x27;&gt;, &#x27;TABLESAMPLE&#x27;: &lt;TokenType.TABLE_SAMPLE: &#x27;TABLE_SAMPLE&#x27;&gt;, &#x27;TEMP&#x27;: &lt;TokenType.TEMPORARY: &#x27;TEMPORARY&#x27;&gt;, &#x27;TEMPORARY&#x27;: &lt;TokenType.TEMPORARY: &#x27;TEMPORARY&#x27;&gt;, &#x27;THEN&#x27;: &lt;TokenType.THEN: &#x27;THEN&#x27;&gt;, &#x27;TRUE&#x27;: &lt;TokenType.TRUE: &#x27;TRUE&#x27;&gt;, &#x27;UNION&#x27;: &lt;TokenType.UNION: &#x27;UNION&#x27;&gt;, &#x27;UNKNOWN&#x27;: &lt;TokenType.UNKNOWN: &#x27;UNKNOWN&#x27;&gt;, &#x27;UNNEST&#x27;: &lt;TokenType.UNNEST: &#x27;UNNEST&#x27;&gt;, &#x27;UNPIVOT&#x27;: &lt;TokenType.UNPIVOT: &#x27;UNPIVOT&#x27;&gt;, &#x27;UPDATE&#x27;: &lt;TokenType.UPDATE: &#x27;UPDATE&#x27;&gt;, &#x27;USE&#x27;: &lt;TokenType.USE: &#x27;USE&#x27;&gt;, &#x27;USING&#x27;: &lt;TokenType.USING: &#x27;USING&#x27;&gt;, &#x27;UUID&#x27;: &lt;TokenType.UUID: &#x27;UUID&#x27;&gt;, &#x27;VALUES&#x27;: &lt;TokenType.VALUES: &#x27;VALUES&#x27;&gt;, &#x27;VIEW&#x27;: &lt;TokenType.VIEW: &#x27;VIEW&#x27;&gt;, &#x27;VOLATILE&#x27;: &lt;TokenType.VOLATILE: &#x27;VOLATILE&#x27;&gt;, &#x27;WHEN&#x27;: &lt;TokenType.WHEN: &#x27;WHEN&#x27;&gt;, &#x27;WHERE&#x27;: &lt;TokenType.WHERE: &#x27;WHERE&#x27;&gt;, &#x27;WINDOW&#x27;: &lt;TokenType.WINDOW: &#x27;WINDOW&#x27;&gt;, &#x27;WITH&#x27;: &lt;TokenType.WITH: &#x27;WITH&#x27;&gt;, &#x27;APPLY&#x27;: &lt;TokenType.APPLY: &#x27;APPLY&#x27;&gt;, &#x27;ARRAY&#x27;: &lt;TokenType.ARRAY: &#x27;ARRAY&#x27;&gt;, &#x27;BIT&#x27;: &lt;TokenType.BIT: &#x27;BIT&#x27;&gt;, &#x27;BOOL&#x27;: &lt;TokenType.BOOLEAN: &#x27;BOOLEAN&#x27;&gt;, &#x27;BOOLEAN&#x27;: &lt;TokenType.BOOLEAN: &#x27;BOOLEAN&#x27;&gt;, &#x27;BYTE&#x27;: &lt;TokenType.TINYINT: &#x27;TINYINT&#x27;&gt;, &#x27;MEDIUMINT&#x27;: &lt;TokenType.MEDIUMINT: &#x27;MEDIUMINT&#x27;&gt;, &#x27;TINYINT&#x27;: &lt;TokenType.TINYINT: &#x27;TINYINT&#x27;&gt;, &#x27;SHORT&#x27;: &lt;TokenType.SMALLINT: &#x27;SMALLINT&#x27;&gt;, &#x27;SMALLINT&#x27;: &lt;TokenType.SMALLINT: &#x27;SMALLINT&#x27;&gt;, &#x27;INT128&#x27;: &lt;TokenType.INT128: &#x27;INT128&#x27;&gt;, &#x27;INT2&#x27;: &lt;TokenType.SMALLINT: &#x27;SMALLINT&#x27;&gt;, &#x27;INTEGER&#x27;: &lt;TokenType.INT: &#x27;INT&#x27;&gt;, &#x27;INT&#x27;: &lt;TokenType.INT: &#x27;INT&#x27;&gt;, &#x27;INT4&#x27;: &lt;TokenType.INT: &#x27;INT&#x27;&gt;, &#x27;LONG&#x27;: &lt;TokenType.BIGINT: &#x27;BIGINT&#x27;&gt;, &#x27;BIGINT&#x27;: &lt;TokenType.BIGINT: &#x27;BIGINT&#x27;&gt;, &#x27;INT8&#x27;: &lt;TokenType.BIGINT: &#x27;BIGINT&#x27;&gt;, &#x27;DEC&#x27;: &lt;TokenType.DECIMAL: &#x27;DECIMAL&#x27;&gt;, &#x27;DECIMAL&#x27;: &lt;TokenType.DECIMAL: &#x27;DECIMAL&#x27;&gt;, &#x27;BIGDECIMAL&#x27;: &lt;TokenType.BIGDECIMAL: &#x27;BIGDECIMAL&#x27;&gt;, &#x27;BIGNUMERIC&#x27;: &lt;TokenType.BIGDECIMAL: &#x27;BIGDECIMAL&#x27;&gt;, &#x27;MAP&#x27;: &lt;TokenType.MAP: &#x27;MAP&#x27;&gt;, &#x27;NULLABLE&#x27;: &lt;TokenType.NULLABLE: &#x27;NULLABLE&#x27;&gt;, &#x27;NUMBER&#x27;: &lt;TokenType.DECIMAL: &#x27;DECIMAL&#x27;&gt;, &#x27;NUMERIC&#x27;: &lt;TokenType.DECIMAL: &#x27;DECIMAL&#x27;&gt;, &#x27;FIXED&#x27;: &lt;TokenType.DECIMAL: &#x27;DECIMAL&#x27;&gt;, &#x27;REAL&#x27;: &lt;TokenType.FLOAT: &#x27;FLOAT&#x27;&gt;, &#x27;FLOAT&#x27;: &lt;TokenType.FLOAT: &#x27;FLOAT&#x27;&gt;, &#x27;FLOAT4&#x27;: &lt;TokenType.FLOAT: &#x27;FLOAT&#x27;&gt;, &#x27;FLOAT8&#x27;: &lt;TokenType.DOUBLE: &#x27;DOUBLE&#x27;&gt;, &#x27;DOUBLE&#x27;: &lt;TokenType.DOUBLE: &#x27;DOUBLE&#x27;&gt;, &#x27;DOUBLE PRECISION&#x27;: &lt;TokenType.DOUBLE: &#x27;DOUBLE&#x27;&gt;, &#x27;JSON&#x27;: &lt;TokenType.JSON: &#x27;JSON&#x27;&gt;, &#x27;CHAR&#x27;: &lt;TokenType.CHAR: &#x27;CHAR&#x27;&gt;, &#x27;CHARACTER&#x27;: &lt;TokenType.CHAR: &#x27;CHAR&#x27;&gt;, &#x27;NCHAR&#x27;: &lt;TokenType.NCHAR: &#x27;NCHAR&#x27;&gt;, &#x27;VARCHAR&#x27;: &lt;TokenType.VARCHAR: &#x27;VARCHAR&#x27;&gt;, &#x27;VARCHAR2&#x27;: &lt;TokenType.VARCHAR: &#x27;VARCHAR&#x27;&gt;, &#x27;NVARCHAR&#x27;: &lt;TokenType.NVARCHAR: &#x27;NVARCHAR&#x27;&gt;, &#x27;NVARCHAR2&#x27;: &lt;TokenType.NVARCHAR: &#x27;NVARCHAR&#x27;&gt;, &#x27;STR&#x27;: &lt;TokenType.TEXT: &#x27;TEXT&#x27;&gt;, &#x27;STRING&#x27;: &lt;TokenType.TEXT: &#x27;TEXT&#x27;&gt;, &#x27;TEXT&#x27;: &lt;TokenType.TEXT: &#x27;TEXT&#x27;&gt;, &#x27;LONGTEXT&#x27;: &lt;TokenType.LONGTEXT: &#x27;LONGTEXT&#x27;&gt;, &#x27;MEDIUMTEXT&#x27;: &lt;TokenType.MEDIUMTEXT: &#x27;MEDIUMTEXT&#x27;&gt;, &#x27;TINYTEXT&#x27;: &lt;TokenType.TINYTEXT: &#x27;TINYTEXT&#x27;&gt;, &#x27;CLOB&#x27;: &lt;TokenType.TEXT: &#x27;TEXT&#x27;&gt;, &#x27;LONGVARCHAR&#x27;: &lt;TokenType.TEXT: &#x27;TEXT&#x27;&gt;, &#x27;BINARY&#x27;: &lt;TokenType.BINARY: &#x27;BINARY&#x27;&gt;, &#x27;BLOB&#x27;: &lt;TokenType.VARBINARY: &#x27;VARBINARY&#x27;&gt;, &#x27;LONGBLOB&#x27;: &lt;TokenType.LONGBLOB: &#x27;LONGBLOB&#x27;&gt;, &#x27;MEDIUMBLOB&#x27;: &lt;TokenType.MEDIUMBLOB: &#x27;MEDIUMBLOB&#x27;&gt;, &#x27;TINYBLOB&#x27;: &lt;TokenType.TINYBLOB: &#x27;TINYBLOB&#x27;&gt;, &#x27;BYTEA&#x27;: &lt;TokenType.VARBINARY: &#x27;VARBINARY&#x27;&gt;, &#x27;VARBINARY&#x27;: &lt;TokenType.VARBINARY: &#x27;VARBINARY&#x27;&gt;, &#x27;TIME&#x27;: &lt;TokenType.TIME: &#x27;TIME&#x27;&gt;, &#x27;TIMETZ&#x27;: &lt;TokenType.TIMETZ: &#x27;TIMETZ&#x27;&gt;, &#x27;TIMESTAMP&#x27;: &lt;TokenType.TIMESTAMPTZ: &#x27;TIMESTAMPTZ&#x27;&gt;, &#x27;TIMESTAMPTZ&#x27;: &lt;TokenType.TIMESTAMPTZ: &#x27;TIMESTAMPTZ&#x27;&gt;, &#x27;TIMESTAMPLTZ&#x27;: &lt;TokenType.TIMESTAMPLTZ: &#x27;TIMESTAMPLTZ&#x27;&gt;, &#x27;DATE&#x27;: &lt;TokenType.DATE: &#x27;DATE&#x27;&gt;, &#x27;DATETIME&#x27;: &lt;TokenType.DATETIME: &#x27;DATETIME&#x27;&gt;, &#x27;INT4RANGE&#x27;: &lt;TokenType.INT4RANGE: &#x27;INT4RANGE&#x27;&gt;, &#x27;INT4MULTIRANGE&#x27;: &lt;TokenType.INT4MULTIRANGE: &#x27;INT4MULTIRANGE&#x27;&gt;, &#x27;INT8RANGE&#x27;: &lt;TokenType.INT8RANGE: &#x27;INT8RANGE&#x27;&gt;, &#x27;INT8MULTIRANGE&#x27;: &lt;TokenType.INT8MULTIRANGE: &#x27;INT8MULTIRANGE&#x27;&gt;, &#x27;NUMRANGE&#x27;: &lt;TokenType.NUMRANGE: &#x27;NUMRANGE&#x27;&gt;, &#x27;NUMMULTIRANGE&#x27;: &lt;TokenType.NUMMULTIRANGE: &#x27;NUMMULTIRANGE&#x27;&gt;, &#x27;TSRANGE&#x27;: &lt;TokenType.TSRANGE: &#x27;TSRANGE&#x27;&gt;, &#x27;TSMULTIRANGE&#x27;: &lt;TokenType.TSMULTIRANGE: &#x27;TSMULTIRANGE&#x27;&gt;, &#x27;TSTZRANGE&#x27;: &lt;TokenType.TSTZRANGE: &#x27;TSTZRANGE&#x27;&gt;, &#x27;TSTZMULTIRANGE&#x27;: &lt;TokenType.TSTZMULTIRANGE: &#x27;TSTZMULTIRANGE&#x27;&gt;, &#x27;DATERANGE&#x27;: &lt;TokenType.DATERANGE: &#x27;DATERANGE&#x27;&gt;, &#x27;DATEMULTIRANGE&#x27;: &lt;TokenType.DATEMULTIRANGE: &#x27;DATEMULTIRANGE&#x27;&gt;, &#x27;UNIQUE&#x27;: &lt;TokenType.UNIQUE: &#x27;UNIQUE&#x27;&gt;, &#x27;STRUCT&#x27;: &lt;TokenType.STRUCT: &#x27;STRUCT&#x27;&gt;, &#x27;VARIANT&#x27;: &lt;TokenType.VARIANT: &#x27;VARIANT&#x27;&gt;, &#x27;ALTER&#x27;: &lt;TokenType.ALTER: &#x27;ALTER&#x27;&gt;, &#x27;ANALYZE&#x27;: &lt;TokenType.COMMAND: &#x27;COMMAND&#x27;&gt;, &#x27;CALL&#x27;: &lt;TokenType.COMMAND: &#x27;COMMAND&#x27;&gt;, &#x27;COMMENT&#x27;: &lt;TokenType.COMMENT: &#x27;COMMENT&#x27;&gt;, &#x27;COPY&#x27;: &lt;TokenType.COMMAND: &#x27;COMMAND&#x27;&gt;, &#x27;EXPLAIN&#x27;: &lt;TokenType.COMMAND: &#x27;COMMAND&#x27;&gt;, &#x27;GRANT&#x27;: &lt;TokenType.COMMAND: &#x27;COMMAND&#x27;&gt;, &#x27;OPTIMIZE&#x27;: &lt;TokenType.COMMAND: &#x27;COMMAND&#x27;&gt;, &#x27;PREPARE&#x27;: &lt;TokenType.COMMAND: &#x27;COMMAND&#x27;&gt;, &#x27;TRUNCATE&#x27;: &lt;TokenType.COMMAND: &#x27;COMMAND&#x27;&gt;, &#x27;VACUUM&#x27;: &lt;TokenType.COMMAND: &#x27;COMMAND&#x27;&gt;, &#x27;USER-DEFINED&#x27;: &lt;TokenType.USERDEFINED: &#x27;USERDEFINED&#x27;&gt;, &#x27;FOR VERSION&#x27;: &lt;TokenType.VERSION_SNAPSHOT: &#x27;VERSION_SNAPSHOT&#x27;&gt;, &#x27;FOR TIMESTAMP&#x27;: &lt;TokenType.TIMESTAMP_SNAPSHOT: &#x27;TIMESTAMP_SNAPSHOT&#x27;&gt;, &#x27;ANY TYPE&#x27;: &lt;TokenType.VARIANT: &#x27;VARIANT&#x27;&gt;, &#x27;BEGIN TRANSACTION&#x27;: &lt;TokenType.BEGIN: &#x27;BEGIN&#x27;&gt;, &#x27;BYTES&#x27;: &lt;TokenType.BINARY: &#x27;BINARY&#x27;&gt;, &#x27;CURRENT_DATETIME&#x27;: &lt;TokenType.CURRENT_DATETIME: &#x27;CURRENT_DATETIME&#x27;&gt;, &#x27;DECLARE&#x27;: &lt;TokenType.COMMAND: &#x27;COMMAND&#x27;&gt;, &#x27;FLOAT64&#x27;: &lt;TokenType.DOUBLE: &#x27;DOUBLE&#x27;&gt;, &#x27;FOR SYSTEM_TIME&#x27;: &lt;TokenType.TIMESTAMP_SNAPSHOT: &#x27;TIMESTAMP_SNAPSHOT&#x27;&gt;, &#x27;INT64&#x27;: &lt;TokenType.BIGINT: &#x27;BIGINT&#x27;&gt;, &#x27;MODEL&#x27;: &lt;TokenType.MODEL: &#x27;MODEL&#x27;&gt;, &#x27;NOT DETERMINISTIC&#x27;: &lt;TokenType.VOLATILE: &#x27;VOLATILE&#x27;&gt;, &#x27;RECORD&#x27;: &lt;TokenType.STRUCT: &#x27;STRUCT&#x27;&gt;}"}, "sqlglot.dialects.bigquery.BigQuery.Tokenizer.ESCAPE_SEQUENCES": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Tokenizer.ESCAPE_SEQUENCES", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Tokenizer.ESCAPE_SEQUENCES", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict[str, str]", "default_value": "{&#x27;\\\\a&#x27;: &#x27;\\x07&#x27;, &#x27;\\\\b&#x27;: &#x27;\\x08&#x27;, &#x27;\\\\f&#x27;: &#x27;\\x0c&#x27;, &#x27;\\\\n&#x27;: &#x27;\\n&#x27;, &#x27;\\\\r&#x27;: &#x27;\\r&#x27;, &#x27;\\\\t&#x27;: &#x27;\\t&#x27;, &#x27;\\\\v&#x27;: &#x27;\\x0b&#x27;}"}, "sqlglot.dialects.bigquery.BigQuery.Parser": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Parser", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Parser", "kind": "class", "doc": "<p>Parser consumes a list of tokens produced by the Tokenizer and produces a parsed syntax tree.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>error_level:</strong>  The desired error level.\nDefault: ErrorLevel.IMMEDIATE</li>\n<li><strong>error_message_context:</strong>  Determines the amount of context to capture from a\nquery string when displaying the error message (in number of characters).\nDefault: 100</li>\n<li><strong>max_errors:</strong>  Maximum number of error messages to include in a raised ParseError.\nThis is only relevant if error_level is ErrorLevel.RAISE.\nDefault: 3</li>\n</ul>\n", "bases": "sqlglot.parser.Parser"}, "sqlglot.dialects.bigquery.BigQuery.Parser.PREFIXED_PIVOT_COLUMNS": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Parser.PREFIXED_PIVOT_COLUMNS", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Parser.PREFIXED_PIVOT_COLUMNS", "kind": "variable", "doc": "<p></p>\n", "default_value": "True"}, "sqlglot.dialects.bigquery.BigQuery.Parser.LOG_DEFAULTS_TO_LN": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Parser.LOG_DEFAULTS_TO_LN", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Parser.LOG_DEFAULTS_TO_LN", "kind": "variable", "doc": "<p></p>\n", "default_value": "True"}, "sqlglot.dialects.bigquery.BigQuery.Parser.FUNCTIONS": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Parser.FUNCTIONS", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Parser.FUNCTIONS", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;ABS&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Abs&#x27;&gt;&gt;, &#x27;ANY_VALUE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.AnyValue&#x27;&gt;&gt;, &#x27;APPROX_DISTINCT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ApproxDistinct&#x27;&gt;&gt;, &#x27;APPROX_COUNT_DISTINCT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ApproxDistinct&#x27;&gt;&gt;, &#x27;APPROX_QUANTILE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ApproxQuantile&#x27;&gt;&gt;, &#x27;ARRAY&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Array&#x27;&gt;&gt;, &#x27;ARRAY_AGG&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArrayAgg&#x27;&gt;&gt;, &#x27;ARRAY_ALL&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArrayAll&#x27;&gt;&gt;, &#x27;ARRAY_ANY&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArrayAny&#x27;&gt;&gt;, &#x27;ARRAY_CONCAT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArrayConcat&#x27;&gt;&gt;, &#x27;ARRAY_CAT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArrayConcat&#x27;&gt;&gt;, &#x27;ARRAY_CONTAINS&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArrayContains&#x27;&gt;&gt;, &#x27;FILTER&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArrayFilter&#x27;&gt;&gt;, &#x27;ARRAY_FILTER&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArrayFilter&#x27;&gt;&gt;, &#x27;ARRAY_JOIN&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArrayJoin&#x27;&gt;&gt;, &#x27;ARRAY_SIZE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArraySize&#x27;&gt;&gt;, &#x27;ARRAY_SORT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArraySort&#x27;&gt;&gt;, &#x27;ARRAY_SUM&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArraySum&#x27;&gt;&gt;, &#x27;ARRAY_UNION_AGG&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArrayUnionAgg&#x27;&gt;&gt;, &#x27;AVG&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Avg&#x27;&gt;&gt;, &#x27;CASE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Case&#x27;&gt;&gt;, &#x27;CAST&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Cast&#x27;&gt;&gt;, &#x27;CAST_TO_STR_TYPE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.CastToStrType&#x27;&gt;&gt;, &#x27;CEIL&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Ceil&#x27;&gt;&gt;, &#x27;CEILING&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Ceil&#x27;&gt;&gt;, &#x27;CHR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Chr&#x27;&gt;&gt;, &#x27;CHAR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Chr&#x27;&gt;&gt;, &#x27;COALESCE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Coalesce&#x27;&gt;&gt;, &#x27;IFNULL&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Coalesce&#x27;&gt;&gt;, &#x27;NVL&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Coalesce&#x27;&gt;&gt;, &#x27;COLLATE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Collate&#x27;&gt;&gt;, &#x27;CONCAT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Concat&#x27;&gt;&gt;, &#x27;CONCAT_WS&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ConcatWs&#x27;&gt;&gt;, &#x27;COUNT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Count&#x27;&gt;&gt;, &#x27;COUNT_IF&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.CountIf&#x27;&gt;&gt;, &#x27;CURRENT_DATE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.CurrentDate&#x27;&gt;&gt;, &#x27;CURRENT_DATETIME&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.CurrentDatetime&#x27;&gt;&gt;, &#x27;CURRENT_TIME&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.CurrentTime&#x27;&gt;&gt;, &#x27;CURRENT_TIMESTAMP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.CurrentTimestamp&#x27;&gt;&gt;, &#x27;CURRENT_USER&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.CurrentUser&#x27;&gt;&gt;, &#x27;DATE&#x27;: &lt;function _parse_date&gt;, &#x27;DATE_ADD&#x27;: &lt;function parse_date_delta_with_interval.&lt;locals&gt;.func&gt;, &#x27;DATEDIFF&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DateDiff&#x27;&gt;&gt;, &#x27;DATE_DIFF&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DateDiff&#x27;&gt;&gt;, &#x27;DATEFROMPARTS&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DateFromParts&#x27;&gt;&gt;, &#x27;DATE_STR_TO_DATE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DateStrToDate&#x27;&gt;&gt;, &#x27;DATE_SUB&#x27;: &lt;function parse_date_delta_with_interval.&lt;locals&gt;.func&gt;, &#x27;DATE_TO_DATE_STR&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;DATE_TO_DI&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DateToDi&#x27;&gt;&gt;, &#x27;DATE_TRUNC&#x27;: &lt;function BigQuery.Parser.&lt;lambda&gt;&gt;, &#x27;DATETIME_ADD&#x27;: &lt;function parse_date_delta_with_interval.&lt;locals&gt;.func&gt;, &#x27;DATETIME_DIFF&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DatetimeDiff&#x27;&gt;&gt;, &#x27;DATETIME_SUB&#x27;: &lt;function parse_date_delta_with_interval.&lt;locals&gt;.func&gt;, &#x27;DATETIME_TRUNC&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DatetimeTrunc&#x27;&gt;&gt;, &#x27;DAY&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Day&#x27;&gt;&gt;, &#x27;DAY_OF_MONTH&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DayOfMonth&#x27;&gt;&gt;, &#x27;DAYOFMONTH&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DayOfMonth&#x27;&gt;&gt;, &#x27;DAY_OF_WEEK&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DayOfWeek&#x27;&gt;&gt;, &#x27;DAYOFWEEK&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DayOfWeek&#x27;&gt;&gt;, &#x27;DAY_OF_YEAR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DayOfYear&#x27;&gt;&gt;, &#x27;DAYOFYEAR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DayOfYear&#x27;&gt;&gt;, &#x27;DECODE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Decode&#x27;&gt;&gt;, &#x27;DI_TO_DATE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DiToDate&#x27;&gt;&gt;, &#x27;ENCODE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Encode&#x27;&gt;&gt;, &#x27;EXP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Exp&#x27;&gt;&gt;, &#x27;EXPLODE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Explode&#x27;&gt;&gt;, &#x27;EXPLODE_OUTER&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ExplodeOuter&#x27;&gt;&gt;, &#x27;EXTRACT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Extract&#x27;&gt;&gt;, &#x27;FIRST&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.First&#x27;&gt;&gt;, &#x27;FLATTEN&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Flatten&#x27;&gt;&gt;, &#x27;FLOOR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Floor&#x27;&gt;&gt;, &#x27;FROM_BASE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.FromBase&#x27;&gt;&gt;, &#x27;FROM_BASE64&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.FromBase64&#x27;&gt;&gt;, &#x27;GENERATE_SERIES&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.GenerateSeries&#x27;&gt;&gt;, &#x27;GREATEST&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Greatest&#x27;&gt;&gt;, &#x27;GROUP_CONCAT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.GroupConcat&#x27;&gt;&gt;, &#x27;HEX&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Hex&#x27;&gt;&gt;, &#x27;HLL&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Hll&#x27;&gt;&gt;, &#x27;IF&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.If&#x27;&gt;&gt;, &#x27;INITCAP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Initcap&#x27;&gt;&gt;, &#x27;IS_NAN&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.IsNan&#x27;&gt;&gt;, &#x27;ISNAN&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.IsNan&#x27;&gt;&gt;, &#x27;J_S_O_N_ARRAY&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.JSONArray&#x27;&gt;&gt;, &#x27;J_S_O_N_ARRAY_AGG&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.JSONArrayAgg&#x27;&gt;&gt;, &#x27;JSON_ARRAY_CONTAINS&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.JSONArrayContains&#x27;&gt;&gt;, &#x27;JSONB_EXTRACT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.JSONBExtract&#x27;&gt;&gt;, &#x27;JSONB_EXTRACT_SCALAR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.JSONBExtractScalar&#x27;&gt;&gt;, &#x27;JSON_EXTRACT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.JSONExtract&#x27;&gt;&gt;, &#x27;JSON_EXTRACT_SCALAR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.JSONExtractScalar&#x27;&gt;&gt;, &#x27;JSON_FORMAT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.JSONFormat&#x27;&gt;&gt;, &#x27;J_S_O_N_OBJECT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.JSONObject&#x27;&gt;&gt;, &#x27;J_S_O_N_TABLE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.JSONTable&#x27;&gt;&gt;, &#x27;LAST&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Last&#x27;&gt;&gt;, &#x27;LAST_DATE_OF_MONTH&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.LastDateOfMonth&#x27;&gt;&gt;, &#x27;LEAST&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Least&#x27;&gt;&gt;, &#x27;LEFT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Left&#x27;&gt;&gt;, &#x27;LENGTH&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Length&#x27;&gt;&gt;, &#x27;LEN&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Length&#x27;&gt;&gt;, &#x27;LEVENSHTEIN&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Levenshtein&#x27;&gt;&gt;, &#x27;LN&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Ln&#x27;&gt;&gt;, &#x27;LOG&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Log&#x27;&gt;&gt;, &#x27;LOG10&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Log10&#x27;&gt;&gt;, &#x27;LOG2&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Log2&#x27;&gt;&gt;, &#x27;LOGICAL_AND&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.LogicalAnd&#x27;&gt;&gt;, &#x27;BOOL_AND&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.LogicalAnd&#x27;&gt;&gt;, &#x27;BOOLAND_AGG&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.LogicalAnd&#x27;&gt;&gt;, &#x27;LOGICAL_OR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.LogicalOr&#x27;&gt;&gt;, &#x27;BOOL_OR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.LogicalOr&#x27;&gt;&gt;, &#x27;BOOLOR_AGG&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.LogicalOr&#x27;&gt;&gt;, &#x27;LOWER&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Lower&#x27;&gt;&gt;, &#x27;LCASE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Lower&#x27;&gt;&gt;, &#x27;MD5&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.MD5Digest&#x27;&gt;&gt;, &#x27;MD5_DIGEST&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.MD5Digest&#x27;&gt;&gt;, &#x27;MAP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Map&#x27;&gt;&gt;, &#x27;MAP_FROM_ENTRIES&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.MapFromEntries&#x27;&gt;&gt;, &#x27;MATCH_AGAINST&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.MatchAgainst&#x27;&gt;&gt;, &#x27;MAX&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Max&#x27;&gt;&gt;, &#x27;MIN&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Min&#x27;&gt;&gt;, &#x27;MONTH&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Month&#x27;&gt;&gt;, &#x27;MONTHS_BETWEEN&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.MonthsBetween&#x27;&gt;&gt;, &#x27;NEXT_VALUE_FOR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.NextValueFor&#x27;&gt;&gt;, &#x27;NUMBER_TO_STR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.NumberToStr&#x27;&gt;&gt;, &#x27;NVL2&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Nvl2&#x27;&gt;&gt;, &#x27;OPEN_J_S_O_N&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.OpenJSON&#x27;&gt;&gt;, &#x27;PARAMETERIZED_AGG&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ParameterizedAgg&#x27;&gt;&gt;, &#x27;PARSE_JSON&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ParseJSON&#x27;&gt;&gt;, &#x27;JSON_PARSE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ParseJSON&#x27;&gt;&gt;, &#x27;PERCENTILE_CONT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.PercentileCont&#x27;&gt;&gt;, &#x27;PERCENTILE_DISC&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.PercentileDisc&#x27;&gt;&gt;, &#x27;POSEXPLODE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Posexplode&#x27;&gt;&gt;, &#x27;POSEXPLODE_OUTER&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.PosexplodeOuter&#x27;&gt;&gt;, &#x27;POWER&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Pow&#x27;&gt;&gt;, &#x27;POW&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Pow&#x27;&gt;&gt;, &#x27;PREDICT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Predict&#x27;&gt;&gt;, &#x27;QUANTILE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Quantile&#x27;&gt;&gt;, &#x27;RANGE_N&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.RangeN&#x27;&gt;&gt;, &#x27;READ_CSV&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ReadCSV&#x27;&gt;&gt;, &#x27;REDUCE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Reduce&#x27;&gt;&gt;, &#x27;REGEXP_EXTRACT&#x27;: &lt;function BigQuery.Parser.&lt;lambda&gt;&gt;, &#x27;REGEXP_I_LIKE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.RegexpILike&#x27;&gt;&gt;, &#x27;REGEXP_LIKE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.RegexpLike&#x27;&gt;&gt;, &#x27;REGEXP_REPLACE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.RegexpReplace&#x27;&gt;&gt;, &#x27;REGEXP_SPLIT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.RegexpSplit&#x27;&gt;&gt;, &#x27;REPEAT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Repeat&#x27;&gt;&gt;, &#x27;RIGHT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Right&#x27;&gt;&gt;, &#x27;ROUND&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Round&#x27;&gt;&gt;, &#x27;ROW_NUMBER&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.RowNumber&#x27;&gt;&gt;, &#x27;SHA&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.SHA&#x27;&gt;&gt;, &#x27;SHA1&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.SHA&#x27;&gt;&gt;, &#x27;SHA2&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.SHA2&#x27;&gt;&gt;, &#x27;SAFE_CONCAT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.SafeConcat&#x27;&gt;&gt;, &#x27;SAFE_DIVIDE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.SafeDivide&#x27;&gt;&gt;, &#x27;SET_AGG&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.SetAgg&#x27;&gt;&gt;, &#x27;SORT_ARRAY&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.SortArray&#x27;&gt;&gt;, &#x27;SPLIT&#x27;: &lt;function BigQuery.Parser.&lt;lambda&gt;&gt;, &#x27;SQRT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Sqrt&#x27;&gt;&gt;, &#x27;STANDARD_HASH&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StandardHash&#x27;&gt;&gt;, &#x27;STAR_MAP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StarMap&#x27;&gt;&gt;, &#x27;STARTS_WITH&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StartsWith&#x27;&gt;&gt;, &#x27;STARTSWITH&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StartsWith&#x27;&gt;&gt;, &#x27;STDDEV&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Stddev&#x27;&gt;&gt;, &#x27;STDDEV_POP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StddevPop&#x27;&gt;&gt;, &#x27;STDDEV_SAMP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StddevSamp&#x27;&gt;&gt;, &#x27;STR_POSITION&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StrPosition&#x27;&gt;&gt;, &#x27;STR_TO_DATE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StrToDate&#x27;&gt;&gt;, &#x27;STR_TO_MAP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StrToMap&#x27;&gt;&gt;, &#x27;STR_TO_TIME&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StrToTime&#x27;&gt;&gt;, &#x27;STR_TO_UNIX&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StrToUnix&#x27;&gt;&gt;, &#x27;STRUCT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Struct&#x27;&gt;&gt;, &#x27;STRUCT_EXTRACT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StructExtract&#x27;&gt;&gt;, &#x27;STUFF&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Stuff&#x27;&gt;&gt;, &#x27;INSERT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Stuff&#x27;&gt;&gt;, &#x27;SUBSTRING&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Substring&#x27;&gt;&gt;, &#x27;SUM&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Sum&#x27;&gt;&gt;, &#x27;TIME_ADD&#x27;: &lt;function parse_date_delta_with_interval.&lt;locals&gt;.func&gt;, &#x27;TIME_DIFF&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimeDiff&#x27;&gt;&gt;, &#x27;TIME_STR_TO_DATE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimeStrToDate&#x27;&gt;&gt;, &#x27;TIME_STR_TO_TIME&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimeStrToTime&#x27;&gt;&gt;, &#x27;TIME_STR_TO_UNIX&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimeStrToUnix&#x27;&gt;&gt;, &#x27;TIME_SUB&#x27;: &lt;function parse_date_delta_with_interval.&lt;locals&gt;.func&gt;, &#x27;TIME_TO_STR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimeToStr&#x27;&gt;&gt;, &#x27;TIME_TO_TIME_STR&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;TIME_TO_UNIX&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimeToUnix&#x27;&gt;&gt;, &#x27;TIME_TRUNC&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimeTrunc&#x27;&gt;&gt;, &#x27;TIMESTAMP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Timestamp&#x27;&gt;&gt;, &#x27;TIMESTAMP_ADD&#x27;: &lt;function parse_date_delta_with_interval.&lt;locals&gt;.func&gt;, &#x27;TIMESTAMP_DIFF&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimestampDiff&#x27;&gt;&gt;, &#x27;TIMESTAMP_SUB&#x27;: &lt;function parse_date_delta_with_interval.&lt;locals&gt;.func&gt;, &#x27;TIMESTAMP_TRUNC&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimestampTrunc&#x27;&gt;&gt;, &#x27;TO_BASE64&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ToBase64&#x27;&gt;&gt;, &#x27;TO_CHAR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ToChar&#x27;&gt;&gt;, &#x27;TO_DAYS&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ToDays&#x27;&gt;&gt;, &#x27;TRANSFORM&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Transform&#x27;&gt;&gt;, &#x27;TRIM&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Trim&#x27;&gt;&gt;, &#x27;TRY_CAST&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TryCast&#x27;&gt;&gt;, &#x27;TS_OR_DI_TO_DI&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TsOrDiToDi&#x27;&gt;&gt;, &#x27;TS_OR_DS_ADD&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TsOrDsAdd&#x27;&gt;&gt;, &#x27;TS_OR_DS_TO_DATE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TsOrDsToDate&#x27;&gt;&gt;, &#x27;TS_OR_DS_TO_DATE_STR&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;UNHEX&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Unhex&#x27;&gt;&gt;, &#x27;UNIX_TO_STR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.UnixToStr&#x27;&gt;&gt;, &#x27;UNIX_TO_TIME&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.UnixToTime&#x27;&gt;&gt;, &#x27;UNIX_TO_TIME_STR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.UnixToTimeStr&#x27;&gt;&gt;, &#x27;UPPER&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Upper&#x27;&gt;&gt;, &#x27;UCASE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Upper&#x27;&gt;&gt;, &#x27;VAR_MAP&#x27;: &lt;function parse_var_map&gt;, &#x27;VARIANCE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Variance&#x27;&gt;&gt;, &#x27;VARIANCE_SAMP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Variance&#x27;&gt;&gt;, &#x27;VAR_SAMP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Variance&#x27;&gt;&gt;, &#x27;VARIANCE_POP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.VariancePop&#x27;&gt;&gt;, &#x27;VAR_POP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.VariancePop&#x27;&gt;&gt;, &#x27;WEEK&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Week&#x27;&gt;&gt;, &#x27;WEEK_OF_YEAR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.WeekOfYear&#x27;&gt;&gt;, &#x27;WEEKOFYEAR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.WeekOfYear&#x27;&gt;&gt;, &#x27;WHEN&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.When&#x27;&gt;&gt;, &#x27;X_M_L_TABLE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.XMLTable&#x27;&gt;&gt;, &#x27;XOR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Xor&#x27;&gt;&gt;, &#x27;YEAR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Year&#x27;&gt;&gt;, &#x27;GLOB&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;LIKE&#x27;: &lt;function parse_like&gt;, &#x27;DIV&#x27;: &lt;function binary_from_function.&lt;locals&gt;.&lt;lambda&gt;&gt;, &#x27;GENERATE_ARRAY&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.GenerateSeries&#x27;&gt;&gt;, &#x27;TO_HEX&#x27;: &lt;function _parse_to_hex&gt;, &#x27;PARSE_DATE&#x27;: &lt;function BigQuery.Parser.&lt;lambda&gt;&gt;, &#x27;PARSE_TIMESTAMP&#x27;: &lt;function _parse_timestamp&gt;, &#x27;REGEXP_CONTAINS&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.RegexpLike&#x27;&gt;&gt;, &#x27;SHA256&#x27;: &lt;function BigQuery.Parser.&lt;lambda&gt;&gt;, &#x27;SHA512&#x27;: &lt;function BigQuery.Parser.&lt;lambda&gt;&gt;, &#x27;TO_JSON_STRING&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.JSONFormat&#x27;&gt;&gt;}"}, "sqlglot.dialects.bigquery.BigQuery.Parser.FUNCTION_PARSERS": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Parser.FUNCTION_PARSERS", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Parser.FUNCTION_PARSERS", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;ANY_VALUE&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;CAST&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;CONCAT&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;CONCAT_WS&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;CONVERT&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;DECODE&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;EXTRACT&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;JSON_OBJECT&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;JSON_TABLE&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;LOG&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;MATCH&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;OPENJSON&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;POSITION&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;PREDICT&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;SAFE_CAST&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;STRING_AGG&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;SUBSTRING&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;TRY_CAST&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;TRY_CONVERT&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;ARRAY&#x27;: &lt;function BigQuery.Parser.&lt;lambda&gt;&gt;}"}, "sqlglot.dialects.bigquery.BigQuery.Parser.NO_PAREN_FUNCTIONS": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Parser.NO_PAREN_FUNCTIONS", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Parser.NO_PAREN_FUNCTIONS", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&lt;TokenType.CURRENT_DATE: &#x27;CURRENT_DATE&#x27;&gt;: &lt;class &#x27;sqlglot.expressions.CurrentDate&#x27;&gt;, &lt;TokenType.CURRENT_DATETIME: &#x27;CURRENT_DATETIME&#x27;&gt;: &lt;class &#x27;sqlglot.expressions.CurrentDatetime&#x27;&gt;, &lt;TokenType.CURRENT_TIME: &#x27;CURRENT_TIME&#x27;&gt;: &lt;class &#x27;sqlglot.expressions.CurrentTime&#x27;&gt;, &lt;TokenType.CURRENT_TIMESTAMP: &#x27;CURRENT_TIMESTAMP&#x27;&gt;: &lt;class &#x27;sqlglot.expressions.CurrentTimestamp&#x27;&gt;, &lt;TokenType.CURRENT_USER: &#x27;CURRENT_USER&#x27;&gt;: &lt;class &#x27;sqlglot.expressions.CurrentUser&#x27;&gt;}"}, "sqlglot.dialects.bigquery.BigQuery.Parser.NESTED_TYPE_TOKENS": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Parser.NESTED_TYPE_TOKENS", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Parser.NESTED_TYPE_TOKENS", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&lt;TokenType.STRUCT: &#x27;STRUCT&#x27;&gt;, &lt;TokenType.ARRAY: &#x27;ARRAY&#x27;&gt;, &lt;TokenType.NULLABLE: &#x27;NULLABLE&#x27;&gt;, &lt;TokenType.MAP: &#x27;MAP&#x27;&gt;, &lt;TokenType.TABLE: &#x27;TABLE&#x27;&gt;, &lt;TokenType.LOWCARDINALITY: &#x27;LOWCARDINALITY&#x27;&gt;, &lt;TokenType.NESTED: &#x27;NESTED&#x27;&gt;}"}, "sqlglot.dialects.bigquery.BigQuery.Parser.ID_VAR_TOKENS": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Parser.ID_VAR_TOKENS", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Parser.ID_VAR_TOKENS", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&lt;TokenType.DATEMULTIRANGE: &#x27;DATEMULTIRANGE&#x27;&gt;, &lt;TokenType.PERCENT: &#x27;PERCENT&#x27;&gt;, &lt;TokenType.UMEDIUMINT: &#x27;UMEDIUMINT&#x27;&gt;, &lt;TokenType.DOUBLE: &#x27;DOUBLE&#x27;&gt;, &lt;TokenType.PIVOT: &#x27;PIVOT&#x27;&gt;, &lt;TokenType.TRUE: &#x27;TRUE&#x27;&gt;, &lt;TokenType.TEXT: &#x27;TEXT&#x27;&gt;, &lt;TokenType.EXECUTE: &#x27;EXECUTE&#x27;&gt;, &lt;TokenType.DESC: &#x27;DESC&#x27;&gt;, &lt;TokenType.CACHE: &#x27;CACHE&#x27;&gt;, &lt;TokenType.FUNCTION: &#x27;FUNCTION&#x27;&gt;, &lt;TokenType.DATE: &#x27;DATE&#x27;&gt;, &lt;TokenType.BIT: &#x27;BIT&#x27;&gt;, &lt;TokenType.SETTINGS: &#x27;SETTINGS&#x27;&gt;, &lt;TokenType.TINYTEXT: &#x27;TINYTEXT&#x27;&gt;, &lt;TokenType.ROWVERSION: &#x27;ROWVERSION&#x27;&gt;, &lt;TokenType.CURRENT_USER: &#x27;CURRENT_USER&#x27;&gt;, &lt;TokenType.GEOGRAPHY: &#x27;GEOGRAPHY&#x27;&gt;, &lt;TokenType.BIGDECIMAL: &#x27;BIGDECIMAL&#x27;&gt;, &lt;TokenType.INT4MULTIRANGE: &#x27;INT4MULTIRANGE&#x27;&gt;, &lt;TokenType.CASE: &#x27;CASE&#x27;&gt;, &lt;TokenType.ANTI: &#x27;ANTI&#x27;&gt;, &lt;TokenType.EXISTS: &#x27;EXISTS&#x27;&gt;, &lt;TokenType.INDEX: &#x27;INDEX&#x27;&gt;, &lt;TokenType.UUID: &#x27;UUID&#x27;&gt;, &lt;TokenType.LOWCARDINALITY: &#x27;LOWCARDINALITY&#x27;&gt;, &lt;TokenType.UNKNOWN: &#x27;UNKNOWN&#x27;&gt;, &lt;TokenType.MEDIUMINT: &#x27;MEDIUMINT&#x27;&gt;, &lt;TokenType.CURRENT_DATETIME: &#x27;CURRENT_DATETIME&#x27;&gt;, &lt;TokenType.VOLATILE: &#x27;VOLATILE&#x27;&gt;, &lt;TokenType.ALL: &#x27;ALL&#x27;&gt;, &lt;TokenType.TINYBLOB: &#x27;TINYBLOB&#x27;&gt;, &lt;TokenType.TSMULTIRANGE: &#x27;TSMULTIRANGE&#x27;&gt;, &lt;TokenType.TIMETZ: &#x27;TIMETZ&#x27;&gt;, &lt;TokenType.ENUM16: &#x27;ENUM16&#x27;&gt;, &lt;TokenType.SHOW: &#x27;SHOW&#x27;&gt;, &lt;TokenType.OVERLAPS: &#x27;OVERLAPS&#x27;&gt;, &lt;TokenType.SMALLSERIAL: &#x27;SMALLSERIAL&#x27;&gt;, &lt;TokenType.COLLATE: &#x27;COLLATE&#x27;&gt;, &lt;TokenType.COMMENT: &#x27;COMMENT&#x27;&gt;, &lt;TokenType.FILTER: &#x27;FILTER&#x27;&gt;, &lt;TokenType.HLLSKETCH: &#x27;HLLSKETCH&#x27;&gt;, &lt;TokenType.ROWS: &#x27;ROWS&#x27;&gt;, &lt;TokenType.RIGHT: &#x27;RIGHT&#x27;&gt;, &lt;TokenType.VARCHAR: &#x27;VARCHAR&#x27;&gt;, &lt;TokenType.UPDATE: &#x27;UPDATE&#x27;&gt;, &lt;TokenType.DICTIONARY: &#x27;DICTIONARY&#x27;&gt;, &lt;TokenType.WINDOW: &#x27;WINDOW&#x27;&gt;, &lt;TokenType.TABLE: &#x27;TABLE&#x27;&gt;, &lt;TokenType.USERDEFINED: &#x27;USERDEFINED&#x27;&gt;, &lt;TokenType.DIV: &#x27;DIV&#x27;&gt;, &lt;TokenType.UNPIVOT: &#x27;UNPIVOT&#x27;&gt;, &lt;TokenType.FIXEDSTRING: &#x27;FIXEDSTRING&#x27;&gt;, &lt;TokenType.VARIANT: &#x27;VARIANT&#x27;&gt;, &lt;TokenType.BIGINT: &#x27;BIGINT&#x27;&gt;, &lt;TokenType.PARTITION: &#x27;PARTITION&#x27;&gt;, &lt;TokenType.DATERANGE: &#x27;DATERANGE&#x27;&gt;, &lt;TokenType.STRUCT: &#x27;STRUCT&#x27;&gt;, &lt;TokenType.ASC: &#x27;ASC&#x27;&gt;, &lt;TokenType.PRAGMA: &#x27;PRAGMA&#x27;&gt;, &lt;TokenType.PROCEDURE: &#x27;PROCEDURE&#x27;&gt;, &lt;TokenType.SEMI: &#x27;SEMI&#x27;&gt;, &lt;TokenType.SOME: &#x27;SOME&#x27;&gt;, &lt;TokenType.VARBINARY: &#x27;VARBINARY&#x27;&gt;, &lt;TokenType.NUMRANGE: &#x27;NUMRANGE&#x27;&gt;, &lt;TokenType.ESCAPE: &#x27;ESCAPE&#x27;&gt;, &lt;TokenType.ANY: &#x27;ANY&#x27;&gt;, &lt;TokenType.DELETE: &#x27;DELETE&#x27;&gt;, &lt;TokenType.LONGTEXT: &#x27;LONGTEXT&#x27;&gt;, &lt;TokenType.LOAD: &#x27;LOAD&#x27;&gt;, &lt;TokenType.NEXT: &#x27;NEXT&#x27;&gt;, &lt;TokenType.TOP: &#x27;TOP&#x27;&gt;, &lt;TokenType.DEFAULT: &#x27;DEFAULT&#x27;&gt;, &lt;TokenType.TIMESTAMP_MS: &#x27;TIMESTAMP_MS&#x27;&gt;, &lt;TokenType.HSTORE: &#x27;HSTORE&#x27;&gt;, &lt;TokenType.AUTO_INCREMENT: &#x27;AUTO_INCREMENT&#x27;&gt;, &lt;TokenType.OVERWRITE: &#x27;OVERWRITE&#x27;&gt;, &lt;TokenType.IS: &#x27;IS&#x27;&gt;, &lt;TokenType.NULL: &#x27;NULL&#x27;&gt;, &lt;TokenType.TIMESTAMP_NS: &#x27;TIMESTAMP_NS&#x27;&gt;, &lt;TokenType.VAR: &#x27;VAR&#x27;&gt;, &lt;TokenType.UNIQUEIDENTIFIER: &#x27;UNIQUEIDENTIFIER&#x27;&gt;, &lt;TokenType.IPADDRESS: &#x27;IPADDRESS&#x27;&gt;, &lt;TokenType.TIME: &#x27;TIME&#x27;&gt;, &lt;TokenType.TIMESTAMPLTZ: &#x27;TIMESTAMPLTZ&#x27;&gt;, &lt;TokenType.TINYINT: &#x27;TINYINT&#x27;&gt;, &lt;TokenType.UINT128: &#x27;UINT128&#x27;&gt;, &lt;TokenType.UINT256: &#x27;UINT256&#x27;&gt;, &lt;TokenType.NCHAR: &#x27;NCHAR&#x27;&gt;, &lt;TokenType.COMMAND: &#x27;COMMAND&#x27;&gt;, &lt;TokenType.BOOLEAN: &#x27;BOOLEAN&#x27;&gt;, &lt;TokenType.SUPER: &#x27;SUPER&#x27;&gt;, &lt;TokenType.CONSTRAINT: &#x27;CONSTRAINT&#x27;&gt;, &lt;TokenType.UDECIMAL: &#x27;UDECIMAL&#x27;&gt;, &lt;TokenType.REFERENCES: &#x27;REFERENCES&#x27;&gt;, &lt;TokenType.CURRENT_TIMESTAMP: &#x27;CURRENT_TIMESTAMP&#x27;&gt;, &lt;TokenType.INT4RANGE: &#x27;INT4RANGE&#x27;&gt;, &lt;TokenType.VIEW: &#x27;VIEW&#x27;&gt;, &lt;TokenType.BIGSERIAL: &#x27;BIGSERIAL&#x27;&gt;, &lt;TokenType.MONEY: &#x27;MONEY&#x27;&gt;, &lt;TokenType.LEFT: &#x27;LEFT&#x27;&gt;, &lt;TokenType.COMMIT: &#x27;COMMIT&#x27;&gt;, &lt;TokenType.LONGBLOB: &#x27;LONGBLOB&#x27;&gt;, &lt;TokenType.INT8MULTIRANGE: &#x27;INT8MULTIRANGE&#x27;&gt;, &lt;TokenType.DATETIME64: &#x27;DATETIME64&#x27;&gt;, &lt;TokenType.IMAGE: &#x27;IMAGE&#x27;&gt;, &lt;TokenType.UTINYINT: &#x27;UTINYINT&#x27;&gt;, &lt;TokenType.MERGE: &#x27;MERGE&#x27;&gt;, &lt;TokenType.INT128: &#x27;INT128&#x27;&gt;, &lt;TokenType.ENUM8: &#x27;ENUM8&#x27;&gt;, &lt;TokenType.DATABASE: &#x27;DATABASE&#x27;&gt;, &lt;TokenType.SMALLMONEY: &#x27;SMALLMONEY&#x27;&gt;, &lt;TokenType.CURRENT_DATE: &#x27;CURRENT_DATE&#x27;&gt;, &lt;TokenType.TSRANGE: &#x27;TSRANGE&#x27;&gt;, &lt;TokenType.TEMPORARY: &#x27;TEMPORARY&#x27;&gt;, &lt;TokenType.SET: &#x27;SET&#x27;&gt;, &lt;TokenType.INT256: &#x27;INT256&#x27;&gt;, &lt;TokenType.DESCRIBE: &#x27;DESCRIBE&#x27;&gt;, &lt;TokenType.FULL: &#x27;FULL&#x27;&gt;, &lt;TokenType.FORMAT: &#x27;FORMAT&#x27;&gt;, &lt;TokenType.MAP: &#x27;MAP&#x27;&gt;, &lt;TokenType.CURRENT_TIME: &#x27;CURRENT_TIME&#x27;&gt;, &lt;TokenType.END: &#x27;END&#x27;&gt;, &lt;TokenType.UINT: &#x27;UINT&#x27;&gt;, &lt;TokenType.CHAR: &#x27;CHAR&#x27;&gt;, &lt;TokenType.NULLABLE: &#x27;NULLABLE&#x27;&gt;, &lt;TokenType.ROW: &#x27;ROW&#x27;&gt;, &lt;TokenType.MEDIUMBLOB: &#x27;MEDIUMBLOB&#x27;&gt;, &lt;TokenType.INT8RANGE: &#x27;INT8RANGE&#x27;&gt;, &lt;TokenType.FLOAT: &#x27;FLOAT&#x27;&gt;, &lt;TokenType.XML: &#x27;XML&#x27;&gt;, &lt;TokenType.ORDINALITY: &#x27;ORDINALITY&#x27;&gt;, &lt;TokenType.NESTED: &#x27;NESTED&#x27;&gt;, &lt;TokenType.IPPREFIX: &#x27;IPPREFIX&#x27;&gt;, &lt;TokenType.DECIMAL: &#x27;DECIMAL&#x27;&gt;, &lt;TokenType.DATETIME: &#x27;DATETIME&#x27;&gt;, &lt;TokenType.OBJECT_IDENTIFIER: &#x27;OBJECT_IDENTIFIER&#x27;&gt;, &lt;TokenType.TIMESTAMP_S: &#x27;TIMESTAMP_S&#x27;&gt;, &lt;TokenType.SERIAL: &#x27;SERIAL&#x27;&gt;, &lt;TokenType.TIMESTAMPTZ: &#x27;TIMESTAMPTZ&#x27;&gt;, &lt;TokenType.NATURAL: &#x27;NATURAL&#x27;&gt;, &lt;TokenType.COLUMN: &#x27;COLUMN&#x27;&gt;, &lt;TokenType.SCHEMA: &#x27;SCHEMA&#x27;&gt;, &lt;TokenType.OBJECT: &#x27;OBJECT&#x27;&gt;, &lt;TokenType.INET: &#x27;INET&#x27;&gt;, &lt;TokenType.FIRST: &#x27;FIRST&#x27;&gt;, &lt;TokenType.OFFSET: &#x27;OFFSET&#x27;&gt;, &lt;TokenType.JSON: &#x27;JSON&#x27;&gt;, &lt;TokenType.BINARY: &#x27;BINARY&#x27;&gt;, &lt;TokenType.NVARCHAR: &#x27;NVARCHAR&#x27;&gt;, &lt;TokenType.UNIQUE: &#x27;UNIQUE&#x27;&gt;, &lt;TokenType.FALSE: &#x27;FALSE&#x27;&gt;, &lt;TokenType.SMALLINT: &#x27;SMALLINT&#x27;&gt;, &lt;TokenType.KEEP: &#x27;KEEP&#x27;&gt;, &lt;TokenType.GEOMETRY: &#x27;GEOMETRY&#x27;&gt;, &lt;TokenType.TIMESTAMP: &#x27;TIMESTAMP&#x27;&gt;, &lt;TokenType.ARRAY: &#x27;ARRAY&#x27;&gt;, &lt;TokenType.PSEUDO_TYPE: &#x27;PSEUDO_TYPE&#x27;&gt;, &lt;TokenType.MEDIUMTEXT: &#x27;MEDIUMTEXT&#x27;&gt;, &lt;TokenType.USMALLINT: &#x27;USMALLINT&#x27;&gt;, &lt;TokenType.TSTZRANGE: &#x27;TSTZRANGE&#x27;&gt;, &lt;TokenType.RANGE: &#x27;RANGE&#x27;&gt;, &lt;TokenType.TSTZMULTIRANGE: &#x27;TSTZMULTIRANGE&#x27;&gt;, &lt;TokenType.YEAR: &#x27;YEAR&#x27;&gt;, &lt;TokenType.ISNULL: &#x27;ISNULL&#x27;&gt;, &lt;TokenType.UBIGINT: &#x27;UBIGINT&#x27;&gt;, &lt;TokenType.NUMMULTIRANGE: &#x27;NUMMULTIRANGE&#x27;&gt;, &lt;TokenType.INT: &#x27;INT&#x27;&gt;, &lt;TokenType.JSONB: &#x27;JSONB&#x27;&gt;, &lt;TokenType.VALUES: &#x27;VALUES&#x27;&gt;, &lt;TokenType.APPLY: &#x27;APPLY&#x27;&gt;, &lt;TokenType.INTERVAL: &#x27;INTERVAL&#x27;&gt;, &lt;TokenType.MODEL: &#x27;MODEL&#x27;&gt;, &lt;TokenType.BEGIN: &#x27;BEGIN&#x27;&gt;, &lt;TokenType.KILL: &#x27;KILL&#x27;&gt;, &lt;TokenType.ENUM: &#x27;ENUM&#x27;&gt;}"}, "sqlglot.dialects.bigquery.BigQuery.Parser.PROPERTY_PARSERS": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Parser.PROPERTY_PARSERS", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Parser.PROPERTY_PARSERS", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;ALGORITHM&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;AUTO_INCREMENT&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;BLOCKCOMPRESSION&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;CHARSET&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;CHARACTER SET&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;CHECKSUM&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;CLUSTER BY&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;CLUSTERED&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;COLLATE&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;COMMENT&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;COPY&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;DATABLOCKSIZE&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;DEFINER&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;DETERMINISTIC&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;DISTKEY&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;DISTSTYLE&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;ENGINE&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;EXECUTE&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;EXTERNAL&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;FALLBACK&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;FORMAT&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;FREESPACE&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;HEAP&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;IMMUTABLE&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;INPUT&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;JOURNAL&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;LANGUAGE&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;LAYOUT&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;LIFETIME&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;LIKE&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;LOCATION&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;LOCK&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;LOCKING&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;LOG&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;MATERIALIZED&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;MERGEBLOCKRATIO&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;MULTISET&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;NO&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;ON&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;ORDER BY&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;OUTPUT&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;PARTITION BY&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;PARTITIONED BY&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;PARTITIONED_BY&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;PRIMARY KEY&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;RANGE&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;REMOTE&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;RETURNS&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;ROW&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;ROW_FORMAT&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;SAMPLE&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;SET&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;SETTINGS&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;SORTKEY&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;SOURCE&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;STABLE&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;STORED&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;TBLPROPERTIES&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;TEMP&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;TEMPORARY&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;TO&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;TRANSIENT&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;TRANSFORM&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;TTL&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;USING&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;VOLATILE&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;WITH&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;NOT DETERMINISTIC&#x27;: &lt;function BigQuery.Parser.&lt;lambda&gt;&gt;, &#x27;OPTIONS&#x27;: &lt;function BigQuery.Parser.&lt;lambda&gt;&gt;}"}, "sqlglot.dialects.bigquery.BigQuery.Parser.CONSTRAINT_PARSERS": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Parser.CONSTRAINT_PARSERS", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Parser.CONSTRAINT_PARSERS", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;AUTOINCREMENT&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;AUTO_INCREMENT&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;CASESPECIFIC&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;CHARACTER SET&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;CHECK&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;COLLATE&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;COMMENT&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;COMPRESS&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;CLUSTERED&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;NONCLUSTERED&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;DEFAULT&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;ENCODE&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;FOREIGN KEY&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;FORMAT&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;GENERATED&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;IDENTITY&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;INLINE&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;LIKE&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;NOT&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;NULL&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;ON&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;PATH&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;PRIMARY KEY&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;REFERENCES&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;TITLE&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;TTL&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;UNIQUE&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;UPPERCASE&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;WITH&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;OPTIONS&#x27;: &lt;function BigQuery.Parser.&lt;lambda&gt;&gt;}"}, "sqlglot.dialects.bigquery.BigQuery.Parser.RANGE_PARSERS": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Parser.RANGE_PARSERS", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Parser.RANGE_PARSERS", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&lt;TokenType.BETWEEN: &#x27;BETWEEN&#x27;&gt;: &lt;function Parser.&lt;lambda&gt;&gt;, &lt;TokenType.GLOB: &#x27;GLOB&#x27;&gt;: &lt;function binary_range_parser.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;TokenType.ILIKE: &#x27;ILIKE&#x27;&gt;: &lt;function binary_range_parser.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;TokenType.IN: &#x27;IN&#x27;&gt;: &lt;function Parser.&lt;lambda&gt;&gt;, &lt;TokenType.IRLIKE: &#x27;IRLIKE&#x27;&gt;: &lt;function binary_range_parser.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;TokenType.IS: &#x27;IS&#x27;&gt;: &lt;function Parser.&lt;lambda&gt;&gt;, &lt;TokenType.LIKE: &#x27;LIKE&#x27;&gt;: &lt;function binary_range_parser.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;TokenType.RLIKE: &#x27;RLIKE&#x27;&gt;: &lt;function binary_range_parser.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;TokenType.SIMILAR_TO: &#x27;SIMILAR_TO&#x27;&gt;: &lt;function binary_range_parser.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;TokenType.FOR: &#x27;FOR&#x27;&gt;: &lt;function Parser.&lt;lambda&gt;&gt;}"}, "sqlglot.dialects.bigquery.BigQuery.Parser.NULL_TOKENS": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Parser.NULL_TOKENS", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Parser.NULL_TOKENS", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&lt;TokenType.NULL: &#x27;NULL&#x27;&gt;, &lt;TokenType.UNKNOWN: &#x27;UNKNOWN&#x27;&gt;}"}, "sqlglot.dialects.bigquery.BigQuery.Parser.TABLE_ALIAS_TOKENS": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Parser.TABLE_ALIAS_TOKENS", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Parser.TABLE_ALIAS_TOKENS", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&lt;TokenType.DATEMULTIRANGE: &#x27;DATEMULTIRANGE&#x27;&gt;, &lt;TokenType.PERCENT: &#x27;PERCENT&#x27;&gt;, &lt;TokenType.UMEDIUMINT: &#x27;UMEDIUMINT&#x27;&gt;, &lt;TokenType.DOUBLE: &#x27;DOUBLE&#x27;&gt;, &lt;TokenType.PIVOT: &#x27;PIVOT&#x27;&gt;, &lt;TokenType.TRUE: &#x27;TRUE&#x27;&gt;, &lt;TokenType.TEXT: &#x27;TEXT&#x27;&gt;, &lt;TokenType.EXECUTE: &#x27;EXECUTE&#x27;&gt;, &lt;TokenType.DESC: &#x27;DESC&#x27;&gt;, &lt;TokenType.CACHE: &#x27;CACHE&#x27;&gt;, &lt;TokenType.FUNCTION: &#x27;FUNCTION&#x27;&gt;, &lt;TokenType.DATE: &#x27;DATE&#x27;&gt;, &lt;TokenType.BIT: &#x27;BIT&#x27;&gt;, &lt;TokenType.SETTINGS: &#x27;SETTINGS&#x27;&gt;, &lt;TokenType.TINYTEXT: &#x27;TINYTEXT&#x27;&gt;, &lt;TokenType.ROWVERSION: &#x27;ROWVERSION&#x27;&gt;, &lt;TokenType.CURRENT_USER: &#x27;CURRENT_USER&#x27;&gt;, &lt;TokenType.GEOGRAPHY: &#x27;GEOGRAPHY&#x27;&gt;, &lt;TokenType.BIGDECIMAL: &#x27;BIGDECIMAL&#x27;&gt;, &lt;TokenType.INT4MULTIRANGE: &#x27;INT4MULTIRANGE&#x27;&gt;, &lt;TokenType.CASE: &#x27;CASE&#x27;&gt;, &lt;TokenType.ANTI: &#x27;ANTI&#x27;&gt;, &lt;TokenType.EXISTS: &#x27;EXISTS&#x27;&gt;, &lt;TokenType.INDEX: &#x27;INDEX&#x27;&gt;, &lt;TokenType.UUID: &#x27;UUID&#x27;&gt;, &lt;TokenType.LOWCARDINALITY: &#x27;LOWCARDINALITY&#x27;&gt;, &lt;TokenType.UNKNOWN: &#x27;UNKNOWN&#x27;&gt;, &lt;TokenType.MEDIUMINT: &#x27;MEDIUMINT&#x27;&gt;, &lt;TokenType.CURRENT_DATETIME: &#x27;CURRENT_DATETIME&#x27;&gt;, &lt;TokenType.VOLATILE: &#x27;VOLATILE&#x27;&gt;, &lt;TokenType.ALL: &#x27;ALL&#x27;&gt;, &lt;TokenType.TINYBLOB: &#x27;TINYBLOB&#x27;&gt;, &lt;TokenType.TSMULTIRANGE: &#x27;TSMULTIRANGE&#x27;&gt;, &lt;TokenType.TIMETZ: &#x27;TIMETZ&#x27;&gt;, &lt;TokenType.ENUM16: &#x27;ENUM16&#x27;&gt;, &lt;TokenType.SHOW: &#x27;SHOW&#x27;&gt;, &lt;TokenType.OVERLAPS: &#x27;OVERLAPS&#x27;&gt;, &lt;TokenType.SMALLSERIAL: &#x27;SMALLSERIAL&#x27;&gt;, &lt;TokenType.COLLATE: &#x27;COLLATE&#x27;&gt;, &lt;TokenType.COMMENT: &#x27;COMMENT&#x27;&gt;, &lt;TokenType.FILTER: &#x27;FILTER&#x27;&gt;, &lt;TokenType.HLLSKETCH: &#x27;HLLSKETCH&#x27;&gt;, &lt;TokenType.ROWS: &#x27;ROWS&#x27;&gt;, &lt;TokenType.VARCHAR: &#x27;VARCHAR&#x27;&gt;, &lt;TokenType.UPDATE: &#x27;UPDATE&#x27;&gt;, &lt;TokenType.DICTIONARY: &#x27;DICTIONARY&#x27;&gt;, &lt;TokenType.TABLE: &#x27;TABLE&#x27;&gt;, &lt;TokenType.USERDEFINED: &#x27;USERDEFINED&#x27;&gt;, &lt;TokenType.DIV: &#x27;DIV&#x27;&gt;, &lt;TokenType.UNPIVOT: &#x27;UNPIVOT&#x27;&gt;, &lt;TokenType.FIXEDSTRING: &#x27;FIXEDSTRING&#x27;&gt;, &lt;TokenType.VARIANT: &#x27;VARIANT&#x27;&gt;, &lt;TokenType.BIGINT: &#x27;BIGINT&#x27;&gt;, &lt;TokenType.PARTITION: &#x27;PARTITION&#x27;&gt;, &lt;TokenType.DATERANGE: &#x27;DATERANGE&#x27;&gt;, &lt;TokenType.STRUCT: &#x27;STRUCT&#x27;&gt;, &lt;TokenType.ASC: &#x27;ASC&#x27;&gt;, &lt;TokenType.PRAGMA: &#x27;PRAGMA&#x27;&gt;, &lt;TokenType.PROCEDURE: &#x27;PROCEDURE&#x27;&gt;, &lt;TokenType.SEMI: &#x27;SEMI&#x27;&gt;, &lt;TokenType.SOME: &#x27;SOME&#x27;&gt;, &lt;TokenType.VARBINARY: &#x27;VARBINARY&#x27;&gt;, &lt;TokenType.NUMRANGE: &#x27;NUMRANGE&#x27;&gt;, &lt;TokenType.ESCAPE: &#x27;ESCAPE&#x27;&gt;, &lt;TokenType.ANY: &#x27;ANY&#x27;&gt;, &lt;TokenType.DELETE: &#x27;DELETE&#x27;&gt;, &lt;TokenType.LONGTEXT: &#x27;LONGTEXT&#x27;&gt;, &lt;TokenType.LOAD: &#x27;LOAD&#x27;&gt;, &lt;TokenType.NEXT: &#x27;NEXT&#x27;&gt;, &lt;TokenType.TOP: &#x27;TOP&#x27;&gt;, &lt;TokenType.DEFAULT: &#x27;DEFAULT&#x27;&gt;, &lt;TokenType.TIMESTAMP_MS: &#x27;TIMESTAMP_MS&#x27;&gt;, &lt;TokenType.HSTORE: &#x27;HSTORE&#x27;&gt;, &lt;TokenType.AUTO_INCREMENT: &#x27;AUTO_INCREMENT&#x27;&gt;, &lt;TokenType.OVERWRITE: &#x27;OVERWRITE&#x27;&gt;, &lt;TokenType.IS: &#x27;IS&#x27;&gt;, &lt;TokenType.NULL: &#x27;NULL&#x27;&gt;, &lt;TokenType.TIMESTAMP_NS: &#x27;TIMESTAMP_NS&#x27;&gt;, &lt;TokenType.VAR: &#x27;VAR&#x27;&gt;, &lt;TokenType.UNIQUEIDENTIFIER: &#x27;UNIQUEIDENTIFIER&#x27;&gt;, &lt;TokenType.IPADDRESS: &#x27;IPADDRESS&#x27;&gt;, &lt;TokenType.TIME: &#x27;TIME&#x27;&gt;, &lt;TokenType.TIMESTAMPLTZ: &#x27;TIMESTAMPLTZ&#x27;&gt;, &lt;TokenType.TINYINT: &#x27;TINYINT&#x27;&gt;, &lt;TokenType.UINT128: &#x27;UINT128&#x27;&gt;, &lt;TokenType.UINT256: &#x27;UINT256&#x27;&gt;, &lt;TokenType.NCHAR: &#x27;NCHAR&#x27;&gt;, &lt;TokenType.COMMAND: &#x27;COMMAND&#x27;&gt;, &lt;TokenType.BOOLEAN: &#x27;BOOLEAN&#x27;&gt;, &lt;TokenType.SUPER: &#x27;SUPER&#x27;&gt;, &lt;TokenType.CONSTRAINT: &#x27;CONSTRAINT&#x27;&gt;, &lt;TokenType.UDECIMAL: &#x27;UDECIMAL&#x27;&gt;, &lt;TokenType.REFERENCES: &#x27;REFERENCES&#x27;&gt;, &lt;TokenType.CURRENT_TIMESTAMP: &#x27;CURRENT_TIMESTAMP&#x27;&gt;, &lt;TokenType.INT4RANGE: &#x27;INT4RANGE&#x27;&gt;, &lt;TokenType.VIEW: &#x27;VIEW&#x27;&gt;, &lt;TokenType.BIGSERIAL: &#x27;BIGSERIAL&#x27;&gt;, &lt;TokenType.MONEY: &#x27;MONEY&#x27;&gt;, &lt;TokenType.COMMIT: &#x27;COMMIT&#x27;&gt;, &lt;TokenType.LONGBLOB: &#x27;LONGBLOB&#x27;&gt;, &lt;TokenType.INT8MULTIRANGE: &#x27;INT8MULTIRANGE&#x27;&gt;, &lt;TokenType.DATETIME64: &#x27;DATETIME64&#x27;&gt;, &lt;TokenType.IMAGE: &#x27;IMAGE&#x27;&gt;, &lt;TokenType.UTINYINT: &#x27;UTINYINT&#x27;&gt;, &lt;TokenType.MERGE: &#x27;MERGE&#x27;&gt;, &lt;TokenType.INT128: &#x27;INT128&#x27;&gt;, &lt;TokenType.ENUM8: &#x27;ENUM8&#x27;&gt;, &lt;TokenType.DATABASE: &#x27;DATABASE&#x27;&gt;, &lt;TokenType.SMALLMONEY: &#x27;SMALLMONEY&#x27;&gt;, &lt;TokenType.CURRENT_DATE: &#x27;CURRENT_DATE&#x27;&gt;, &lt;TokenType.TSRANGE: &#x27;TSRANGE&#x27;&gt;, &lt;TokenType.TEMPORARY: &#x27;TEMPORARY&#x27;&gt;, &lt;TokenType.SET: &#x27;SET&#x27;&gt;, &lt;TokenType.INT256: &#x27;INT256&#x27;&gt;, &lt;TokenType.DESCRIBE: &#x27;DESCRIBE&#x27;&gt;, &lt;TokenType.MAP: &#x27;MAP&#x27;&gt;, &lt;TokenType.FORMAT: &#x27;FORMAT&#x27;&gt;, &lt;TokenType.CURRENT_TIME: &#x27;CURRENT_TIME&#x27;&gt;, &lt;TokenType.END: &#x27;END&#x27;&gt;, &lt;TokenType.UINT: &#x27;UINT&#x27;&gt;, &lt;TokenType.CHAR: &#x27;CHAR&#x27;&gt;, &lt;TokenType.NULLABLE: &#x27;NULLABLE&#x27;&gt;, &lt;TokenType.ROW: &#x27;ROW&#x27;&gt;, &lt;TokenType.MEDIUMBLOB: &#x27;MEDIUMBLOB&#x27;&gt;, &lt;TokenType.INT8RANGE: &#x27;INT8RANGE&#x27;&gt;, &lt;TokenType.FLOAT: &#x27;FLOAT&#x27;&gt;, &lt;TokenType.XML: &#x27;XML&#x27;&gt;, &lt;TokenType.ORDINALITY: &#x27;ORDINALITY&#x27;&gt;, &lt;TokenType.NESTED: &#x27;NESTED&#x27;&gt;, &lt;TokenType.IPPREFIX: &#x27;IPPREFIX&#x27;&gt;, &lt;TokenType.DECIMAL: &#x27;DECIMAL&#x27;&gt;, &lt;TokenType.DATETIME: &#x27;DATETIME&#x27;&gt;, &lt;TokenType.OBJECT_IDENTIFIER: &#x27;OBJECT_IDENTIFIER&#x27;&gt;, &lt;TokenType.TIMESTAMP_S: &#x27;TIMESTAMP_S&#x27;&gt;, &lt;TokenType.SERIAL: &#x27;SERIAL&#x27;&gt;, &lt;TokenType.TIMESTAMPTZ: &#x27;TIMESTAMPTZ&#x27;&gt;, &lt;TokenType.COLUMN: &#x27;COLUMN&#x27;&gt;, &lt;TokenType.SCHEMA: &#x27;SCHEMA&#x27;&gt;, &lt;TokenType.OBJECT: &#x27;OBJECT&#x27;&gt;, &lt;TokenType.INET: &#x27;INET&#x27;&gt;, &lt;TokenType.FIRST: &#x27;FIRST&#x27;&gt;, &lt;TokenType.JSON: &#x27;JSON&#x27;&gt;, &lt;TokenType.BINARY: &#x27;BINARY&#x27;&gt;, &lt;TokenType.NVARCHAR: &#x27;NVARCHAR&#x27;&gt;, &lt;TokenType.UNIQUE: &#x27;UNIQUE&#x27;&gt;, &lt;TokenType.FALSE: &#x27;FALSE&#x27;&gt;, &lt;TokenType.SMALLINT: &#x27;SMALLINT&#x27;&gt;, &lt;TokenType.KEEP: &#x27;KEEP&#x27;&gt;, &lt;TokenType.GEOMETRY: &#x27;GEOMETRY&#x27;&gt;, &lt;TokenType.TIMESTAMP: &#x27;TIMESTAMP&#x27;&gt;, &lt;TokenType.ARRAY: &#x27;ARRAY&#x27;&gt;, &lt;TokenType.PSEUDO_TYPE: &#x27;PSEUDO_TYPE&#x27;&gt;, &lt;TokenType.MEDIUMTEXT: &#x27;MEDIUMTEXT&#x27;&gt;, &lt;TokenType.USMALLINT: &#x27;USMALLINT&#x27;&gt;, &lt;TokenType.TSTZRANGE: &#x27;TSTZRANGE&#x27;&gt;, &lt;TokenType.RANGE: &#x27;RANGE&#x27;&gt;, &lt;TokenType.TSTZMULTIRANGE: &#x27;TSTZMULTIRANGE&#x27;&gt;, &lt;TokenType.YEAR: &#x27;YEAR&#x27;&gt;, &lt;TokenType.ISNULL: &#x27;ISNULL&#x27;&gt;, &lt;TokenType.UBIGINT: &#x27;UBIGINT&#x27;&gt;, &lt;TokenType.NUMMULTIRANGE: &#x27;NUMMULTIRANGE&#x27;&gt;, &lt;TokenType.INT: &#x27;INT&#x27;&gt;, &lt;TokenType.JSONB: &#x27;JSONB&#x27;&gt;, &lt;TokenType.MODEL: &#x27;MODEL&#x27;&gt;, &lt;TokenType.INTERVAL: &#x27;INTERVAL&#x27;&gt;, &lt;TokenType.BEGIN: &#x27;BEGIN&#x27;&gt;, &lt;TokenType.KILL: &#x27;KILL&#x27;&gt;, &lt;TokenType.ENUM: &#x27;ENUM&#x27;&gt;}"}, "sqlglot.dialects.bigquery.BigQuery.Parser.LOG_BASE_FIRST": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Parser.LOG_BASE_FIRST", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Parser.LOG_BASE_FIRST", "kind": "variable", "doc": "<p></p>\n", "default_value": "False"}, "sqlglot.dialects.bigquery.BigQuery.Parser.TOKENIZER_CLASS": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Parser.TOKENIZER_CLASS", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Parser.TOKENIZER_CLASS", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Type[sqlglot.tokens.Tokenizer]", "default_value": "&lt;class &#x27;sqlglot.dialects.bigquery.BigQuery.Tokenizer&#x27;&gt;"}, "sqlglot.dialects.bigquery.BigQuery.Parser.UNNEST_COLUMN_ONLY": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Parser.UNNEST_COLUMN_ONLY", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Parser.UNNEST_COLUMN_ONLY", "kind": "variable", "doc": "<p></p>\n", "annotation": ": bool", "default_value": "True"}, "sqlglot.dialects.bigquery.BigQuery.Parser.SUPPORTS_USER_DEFINED_TYPES": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Parser.SUPPORTS_USER_DEFINED_TYPES", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Parser.SUPPORTS_USER_DEFINED_TYPES", "kind": "variable", "doc": "<p></p>\n", "default_value": "False"}, "sqlglot.dialects.bigquery.BigQuery.Parser.NORMALIZE_FUNCTIONS": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Parser.NORMALIZE_FUNCTIONS", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Parser.NORMALIZE_FUNCTIONS", "kind": "variable", "doc": "<p></p>\n", "default_value": "False"}, "sqlglot.dialects.bigquery.BigQuery.Parser.SHOW_TRIE": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Parser.SHOW_TRIE", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Parser.SHOW_TRIE", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict", "default_value": "{}"}, "sqlglot.dialects.bigquery.BigQuery.Parser.SET_TRIE": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Parser.SET_TRIE", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Parser.SET_TRIE", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict", "default_value": "{&#x27;GLOBAL&#x27;: {0: True}, &#x27;LOCAL&#x27;: {0: True}, &#x27;SESSION&#x27;: {0: True}, &#x27;TRANSACTION&#x27;: {0: True}}"}, "sqlglot.dialects.bigquery.BigQuery.Parser.FORMAT_MAPPING": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Parser.FORMAT_MAPPING", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Parser.FORMAT_MAPPING", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict[str, str]", "default_value": "{&#x27;DD&#x27;: &#x27;%d&#x27;, &#x27;MM&#x27;: &#x27;%m&#x27;, &#x27;MON&#x27;: &#x27;%b&#x27;, &#x27;MONTH&#x27;: &#x27;%B&#x27;, &#x27;YYYY&#x27;: &#x27;%Y&#x27;, &#x27;YY&#x27;: &#x27;%y&#x27;, &#x27;HH&#x27;: &#x27;%I&#x27;, &#x27;HH12&#x27;: &#x27;%I&#x27;, &#x27;HH24&#x27;: &#x27;%H&#x27;, &#x27;MI&#x27;: &#x27;%M&#x27;, &#x27;SS&#x27;: &#x27;%S&#x27;, &#x27;SSSSS&#x27;: &#x27;%f&#x27;, &#x27;TZH&#x27;: &#x27;%z&#x27;}"}, "sqlglot.dialects.bigquery.BigQuery.Parser.FORMAT_TRIE": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Parser.FORMAT_TRIE", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Parser.FORMAT_TRIE", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict", "default_value": "{&#x27;D&#x27;: {&#x27;D&#x27;: {0: True}}, &#x27;M&#x27;: {&#x27;M&#x27;: {0: True}, &#x27;O&#x27;: {&#x27;N&#x27;: {0: True, &#x27;T&#x27;: {&#x27;H&#x27;: {0: True}}}}, &#x27;I&#x27;: {0: True}}, &#x27;Y&#x27;: {&#x27;Y&#x27;: {&#x27;Y&#x27;: {&#x27;Y&#x27;: {0: True}}, 0: True}}, &#x27;H&#x27;: {&#x27;H&#x27;: {0: True, &#x27;1&#x27;: {&#x27;2&#x27;: {0: True}}, &#x27;2&#x27;: {&#x27;4&#x27;: {0: True}}}}, &#x27;S&#x27;: {&#x27;S&#x27;: {0: True, &#x27;S&#x27;: {&#x27;S&#x27;: {&#x27;S&#x27;: {0: True}}}}}, &#x27;T&#x27;: {&#x27;Z&#x27;: {&#x27;H&#x27;: {0: True}}}}"}, "sqlglot.dialects.bigquery.BigQuery.Parser.TIME_MAPPING": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Parser.TIME_MAPPING", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Parser.TIME_MAPPING", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict[str, str]", "default_value": "{&#x27;%D&#x27;: &#x27;%m/%d/%y&#x27;}"}, "sqlglot.dialects.bigquery.BigQuery.Parser.TIME_TRIE": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Parser.TIME_TRIE", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Parser.TIME_TRIE", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict", "default_value": "{&#x27;%&#x27;: {&#x27;D&#x27;: {0: True}}}"}, "sqlglot.dialects.bigquery.BigQuery.Generator": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Generator", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Generator", "kind": "class", "doc": "<p>Generator converts a given syntax tree to the corresponding SQL string.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>pretty:</strong>  Whether or not to format the produced SQL string.\nDefault: False.</li>\n<li><strong>identify:</strong>  Determines when an identifier should be quoted. Possible values are:\nFalse (default): Never quote, except in cases where it's mandatory by the dialect.\nTrue or 'always': Always quote.\n'safe': Only quote identifiers that are case insensitive.</li>\n<li><strong>normalize:</strong>  Whether or not to normalize identifiers to lowercase.\nDefault: False.</li>\n<li><strong>pad:</strong>  Determines the pad size in a formatted string.\nDefault: 2.</li>\n<li><strong>indent:</strong>  Determines the indentation size in a formatted string.\nDefault: 2.</li>\n<li><strong>normalize_functions:</strong>  Whether or not to normalize all function names. Possible values are:\n\"upper\" or True (default): Convert names to uppercase.\n\"lower\": Convert names to lowercase.\nFalse: Disables function name normalization.</li>\n<li><strong>unsupported_level:</strong>  Determines the generator's behavior when it encounters unsupported expressions.\nDefault ErrorLevel.WARN.</li>\n<li><strong>max_unsupported:</strong>  Maximum number of unsupported messages to include in a raised UnsupportedError.\nThis is only relevant if unsupported_level is ErrorLevel.RAISE.\nDefault: 3</li>\n<li><strong>leading_comma:</strong>  Determines whether or not the comma is leading or trailing in select expressions.\nThis is only relevant when generating in pretty mode.\nDefault: False</li>\n<li><strong>max_text_width:</strong>  The max number of characters in a segment before creating new lines in pretty mode.\nThe default is on the smaller end because the length only represents a segment and not the true\nline length.\nDefault: 80</li>\n<li><strong>comments:</strong>  Whether or not to preserve comments in the output SQL code.\nDefault: True</li>\n</ul>\n", "bases": "sqlglot.generator.Generator"}, "sqlglot.dialects.bigquery.BigQuery.Generator.EXPLICIT_UNION": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Generator.EXPLICIT_UNION", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Generator.EXPLICIT_UNION", "kind": "variable", "doc": "<p></p>\n", "default_value": "True"}, "sqlglot.dialects.bigquery.BigQuery.Generator.INTERVAL_ALLOWS_PLURAL_FORM": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Generator.INTERVAL_ALLOWS_PLURAL_FORM", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Generator.INTERVAL_ALLOWS_PLURAL_FORM", "kind": "variable", "doc": "<p></p>\n", "default_value": "False"}, "sqlglot.dialects.bigquery.BigQuery.Generator.JOIN_HINTS": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Generator.JOIN_HINTS", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Generator.JOIN_HINTS", "kind": "variable", "doc": "<p></p>\n", "default_value": "False"}, "sqlglot.dialects.bigquery.BigQuery.Generator.QUERY_HINTS": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Generator.QUERY_HINTS", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Generator.QUERY_HINTS", "kind": "variable", "doc": "<p></p>\n", "default_value": "False"}, "sqlglot.dialects.bigquery.BigQuery.Generator.TABLE_HINTS": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Generator.TABLE_HINTS", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Generator.TABLE_HINTS", "kind": "variable", "doc": "<p></p>\n", "default_value": "False"}, "sqlglot.dialects.bigquery.BigQuery.Generator.LIMIT_FETCH": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Generator.LIMIT_FETCH", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Generator.LIMIT_FETCH", "kind": "variable", "doc": "<p></p>\n", "default_value": "&#x27;LIMIT&#x27;"}, "sqlglot.dialects.bigquery.BigQuery.Generator.RENAME_TABLE_WITH_DB": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Generator.RENAME_TABLE_WITH_DB", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Generator.RENAME_TABLE_WITH_DB", "kind": "variable", "doc": "<p></p>\n", "default_value": "False"}, "sqlglot.dialects.bigquery.BigQuery.Generator.NVL2_SUPPORTED": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Generator.NVL2_SUPPORTED", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Generator.NVL2_SUPPORTED", "kind": "variable", "doc": "<p></p>\n", "default_value": "False"}, "sqlglot.dialects.bigquery.BigQuery.Generator.UNNEST_WITH_ORDINALITY": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Generator.UNNEST_WITH_ORDINALITY", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Generator.UNNEST_WITH_ORDINALITY", "kind": "variable", "doc": "<p></p>\n", "default_value": "False"}, "sqlglot.dialects.bigquery.BigQuery.Generator.COLLATE_IS_FUNC": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Generator.COLLATE_IS_FUNC", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Generator.COLLATE_IS_FUNC", "kind": "variable", "doc": "<p></p>\n", "default_value": "True"}, "sqlglot.dialects.bigquery.BigQuery.Generator.TRANSFORMS": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Generator.TRANSFORMS", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Generator.TRANSFORMS", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&lt;class &#x27;sqlglot.expressions.DateAdd&#x27;&gt;: &lt;function date_add_interval_sql.&lt;locals&gt;.func&gt;, &lt;class &#x27;sqlglot.expressions.TsOrDsAdd&#x27;&gt;: &lt;function date_add_interval_sql.&lt;locals&gt;.func&gt;, &lt;class &#x27;sqlglot.expressions.CaseSpecificColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.CharacterSetColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.CharacterSetProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.CheckColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.ClusteredColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.CollateColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.CopyGrantsProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.CommentColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.DateFormatColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.DefaultColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.EncodeColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.ExecuteAsProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.ExternalProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.HeapProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.InlineLengthColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.InputModelProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.IntervalSpan&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.LanguageProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.LocationProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.LogProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.MaterializedProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.NoPrimaryIndexProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.NonClusteredColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.NotForReplicationColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.OnCommitProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.OnProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.OnUpdateColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.OutputModelProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.PathColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.RemoteWithConnectionModelProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.ReturnsProperty&#x27;&gt;: &lt;function _returnsproperty_sql&gt;, &lt;class &#x27;sqlglot.expressions.SampleProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.SetProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.SettingsProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.SqlSecurityProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.StabilityProperty&#x27;&gt;: &lt;function BigQuery.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.TemporaryProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.ToTableProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.TransientProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.TransformModelProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.TitleColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.UppercaseColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.VarMap&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.VolatileProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.WithJournalTableProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.ApproxDistinct&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.ArraySize&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.Cast&#x27;&gt;: &lt;function preprocess.&lt;locals&gt;._to_sql&gt;, &lt;class &#x27;sqlglot.expressions.CollateProperty&#x27;&gt;: &lt;function BigQuery.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.Create&#x27;&gt;: &lt;function _create_sql&gt;, &lt;class &#x27;sqlglot.expressions.CTE&#x27;&gt;: &lt;function preprocess.&lt;locals&gt;._to_sql&gt;, &lt;class &#x27;sqlglot.expressions.DateDiff&#x27;&gt;: &lt;function BigQuery.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.DateFromParts&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.DateStrToDate&#x27;&gt;: &lt;function datestrtodate_sql&gt;, &lt;class &#x27;sqlglot.expressions.DateSub&#x27;&gt;: &lt;function date_add_interval_sql.&lt;locals&gt;.func&gt;, &lt;class &#x27;sqlglot.expressions.DatetimeAdd&#x27;&gt;: &lt;function date_add_interval_sql.&lt;locals&gt;.func&gt;, &lt;class &#x27;sqlglot.expressions.DatetimeSub&#x27;&gt;: &lt;function date_add_interval_sql.&lt;locals&gt;.func&gt;, &lt;class &#x27;sqlglot.expressions.DateTrunc&#x27;&gt;: &lt;function BigQuery.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.GenerateSeries&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.GroupConcat&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.Hex&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.If&#x27;&gt;: &lt;function if_sql.&lt;locals&gt;._if_sql&gt;, &lt;class &#x27;sqlglot.expressions.ILike&#x27;&gt;: &lt;function no_ilike_sql&gt;, &lt;class &#x27;sqlglot.expressions.IntDiv&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.JSONFormat&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.JSONKeyValue&#x27;&gt;: &lt;function json_keyvalue_comma_sql&gt;, &lt;class &#x27;sqlglot.expressions.Max&#x27;&gt;: &lt;function max_or_greatest&gt;, &lt;class &#x27;sqlglot.expressions.MD5&#x27;&gt;: &lt;function BigQuery.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.MD5Digest&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.Min&#x27;&gt;: &lt;function min_or_least&gt;, &lt;class &#x27;sqlglot.expressions.PartitionedByProperty&#x27;&gt;: &lt;function BigQuery.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.RegexpExtract&#x27;&gt;: &lt;function BigQuery.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.RegexpReplace&#x27;&gt;: &lt;function regexp_replace_sql&gt;, &lt;class &#x27;sqlglot.expressions.RegexpLike&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.Select&#x27;&gt;: &lt;function preprocess.&lt;locals&gt;._to_sql&gt;, &lt;class &#x27;sqlglot.expressions.SHA2&#x27;&gt;: &lt;function BigQuery.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.StrToDate&#x27;&gt;: &lt;function BigQuery.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.StrToTime&#x27;&gt;: &lt;function BigQuery.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.TimeAdd&#x27;&gt;: &lt;function date_add_interval_sql.&lt;locals&gt;.func&gt;, &lt;class &#x27;sqlglot.expressions.TimeSub&#x27;&gt;: &lt;function date_add_interval_sql.&lt;locals&gt;.func&gt;, &lt;class &#x27;sqlglot.expressions.TimestampAdd&#x27;&gt;: &lt;function date_add_interval_sql.&lt;locals&gt;.func&gt;, &lt;class &#x27;sqlglot.expressions.TimestampSub&#x27;&gt;: &lt;function date_add_interval_sql.&lt;locals&gt;.func&gt;, &lt;class &#x27;sqlglot.expressions.TimeStrToTime&#x27;&gt;: &lt;function timestrtotime_sql&gt;, &lt;class &#x27;sqlglot.expressions.Trim&#x27;&gt;: &lt;function BigQuery.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.TsOrDsToDate&#x27;&gt;: &lt;function ts_or_ds_to_date_sql.&lt;locals&gt;._ts_or_ds_to_date_sql&gt;, &lt;class &#x27;sqlglot.expressions.Unhex&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.Values&#x27;&gt;: &lt;function _derived_table_values_to_unnest&gt;, &lt;class &#x27;sqlglot.expressions.VariancePop&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;}"}, "sqlglot.dialects.bigquery.BigQuery.Generator.TYPE_MAPPING": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Generator.TYPE_MAPPING", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Generator.TYPE_MAPPING", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&lt;Type.NCHAR: &#x27;NCHAR&#x27;&gt;: &#x27;STRING&#x27;, &lt;Type.NVARCHAR: &#x27;NVARCHAR&#x27;&gt;: &#x27;STRING&#x27;, &lt;Type.MEDIUMTEXT: &#x27;MEDIUMTEXT&#x27;&gt;: &#x27;TEXT&#x27;, &lt;Type.LONGTEXT: &#x27;LONGTEXT&#x27;&gt;: &#x27;TEXT&#x27;, &lt;Type.TINYTEXT: &#x27;TINYTEXT&#x27;&gt;: &#x27;TEXT&#x27;, &lt;Type.MEDIUMBLOB: &#x27;MEDIUMBLOB&#x27;&gt;: &#x27;BLOB&#x27;, &lt;Type.LONGBLOB: &#x27;LONGBLOB&#x27;&gt;: &#x27;BLOB&#x27;, &lt;Type.TINYBLOB: &#x27;TINYBLOB&#x27;&gt;: &#x27;BLOB&#x27;, &lt;Type.INET: &#x27;INET&#x27;&gt;: &#x27;INET&#x27;, &lt;Type.BIGDECIMAL: &#x27;BIGDECIMAL&#x27;&gt;: &#x27;BIGNUMERIC&#x27;, &lt;Type.BIGINT: &#x27;BIGINT&#x27;&gt;: &#x27;INT64&#x27;, &lt;Type.BINARY: &#x27;BINARY&#x27;&gt;: &#x27;BYTES&#x27;, &lt;Type.BOOLEAN: &#x27;BOOLEAN&#x27;&gt;: &#x27;BOOL&#x27;, &lt;Type.CHAR: &#x27;CHAR&#x27;&gt;: &#x27;STRING&#x27;, &lt;Type.DECIMAL: &#x27;DECIMAL&#x27;&gt;: &#x27;NUMERIC&#x27;, &lt;Type.DOUBLE: &#x27;DOUBLE&#x27;&gt;: &#x27;FLOAT64&#x27;, &lt;Type.FLOAT: &#x27;FLOAT&#x27;&gt;: &#x27;FLOAT64&#x27;, &lt;Type.INT: &#x27;INT&#x27;&gt;: &#x27;INT64&#x27;, &lt;Type.SMALLINT: &#x27;SMALLINT&#x27;&gt;: &#x27;INT64&#x27;, &lt;Type.TEXT: &#x27;TEXT&#x27;&gt;: &#x27;STRING&#x27;, &lt;Type.TIMESTAMP: &#x27;TIMESTAMP&#x27;&gt;: &#x27;DATETIME&#x27;, &lt;Type.TIMESTAMPTZ: &#x27;TIMESTAMPTZ&#x27;&gt;: &#x27;TIMESTAMP&#x27;, &lt;Type.TIMESTAMPLTZ: &#x27;TIMESTAMPLTZ&#x27;&gt;: &#x27;TIMESTAMP&#x27;, &lt;Type.TINYINT: &#x27;TINYINT&#x27;&gt;: &#x27;INT64&#x27;, &lt;Type.VARBINARY: &#x27;VARBINARY&#x27;&gt;: &#x27;BYTES&#x27;, &lt;Type.VARCHAR: &#x27;VARCHAR&#x27;&gt;: &#x27;STRING&#x27;, &lt;Type.VARIANT: &#x27;VARIANT&#x27;&gt;: &#x27;ANY TYPE&#x27;}"}, "sqlglot.dialects.bigquery.BigQuery.Generator.PROPERTIES_LOCATION": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Generator.PROPERTIES_LOCATION", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Generator.PROPERTIES_LOCATION", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&lt;class &#x27;sqlglot.expressions.AlgorithmProperty&#x27;&gt;: &lt;Location.POST_CREATE: &#x27;POST_CREATE&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.AutoIncrementProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.BlockCompressionProperty&#x27;&gt;: &lt;Location.POST_NAME: &#x27;POST_NAME&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.CharacterSetProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.ChecksumProperty&#x27;&gt;: &lt;Location.POST_NAME: &#x27;POST_NAME&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.CollateProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.CopyGrantsProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.Cluster&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.ClusteredByProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.DataBlocksizeProperty&#x27;&gt;: &lt;Location.POST_NAME: &#x27;POST_NAME&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.DefinerProperty&#x27;&gt;: &lt;Location.POST_CREATE: &#x27;POST_CREATE&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.DictRange&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.DictProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.DistKeyProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.DistStyleProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.EngineProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.ExecuteAsProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.ExternalProperty&#x27;&gt;: &lt;Location.POST_CREATE: &#x27;POST_CREATE&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.FallbackProperty&#x27;&gt;: &lt;Location.POST_NAME: &#x27;POST_NAME&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.FileFormatProperty&#x27;&gt;: &lt;Location.POST_WITH: &#x27;POST_WITH&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.FreespaceProperty&#x27;&gt;: &lt;Location.POST_NAME: &#x27;POST_NAME&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.HeapProperty&#x27;&gt;: &lt;Location.POST_WITH: &#x27;POST_WITH&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.InputModelProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.IsolatedLoadingProperty&#x27;&gt;: &lt;Location.POST_NAME: &#x27;POST_NAME&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.JournalProperty&#x27;&gt;: &lt;Location.POST_NAME: &#x27;POST_NAME&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.LanguageProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.LikeProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.LocationProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.LockingProperty&#x27;&gt;: &lt;Location.POST_ALIAS: &#x27;POST_ALIAS&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.LogProperty&#x27;&gt;: &lt;Location.POST_NAME: &#x27;POST_NAME&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.MaterializedProperty&#x27;&gt;: &lt;Location.POST_CREATE: &#x27;POST_CREATE&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.MergeBlockRatioProperty&#x27;&gt;: &lt;Location.POST_NAME: &#x27;POST_NAME&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.NoPrimaryIndexProperty&#x27;&gt;: &lt;Location.POST_EXPRESSION: &#x27;POST_EXPRESSION&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.OnProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.OnCommitProperty&#x27;&gt;: &lt;Location.POST_EXPRESSION: &#x27;POST_EXPRESSION&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.Order&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.OutputModelProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.PartitionedByProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.PrimaryKey&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.Property&#x27;&gt;: &lt;Location.POST_WITH: &#x27;POST_WITH&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.RemoteWithConnectionModelProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.ReturnsProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.RowFormatProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.RowFormatDelimitedProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.RowFormatSerdeProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.SampleProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.SchemaCommentProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.SerdeProperties&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.Set&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.SettingsProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.SetProperty&#x27;&gt;: &lt;Location.POST_CREATE: &#x27;POST_CREATE&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.SortKeyProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.SqlSecurityProperty&#x27;&gt;: &lt;Location.POST_CREATE: &#x27;POST_CREATE&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.StabilityProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.TemporaryProperty&#x27;&gt;: &lt;Location.POST_CREATE: &#x27;POST_CREATE&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.ToTableProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.TransientProperty&#x27;&gt;: &lt;Location.POST_CREATE: &#x27;POST_CREATE&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.TransformModelProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.MergeTreeTTL&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.VolatileProperty&#x27;&gt;: &lt;Location.UNSUPPORTED: &#x27;UNSUPPORTED&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.WithDataProperty&#x27;&gt;: &lt;Location.POST_EXPRESSION: &#x27;POST_EXPRESSION&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.WithJournalTableProperty&#x27;&gt;: &lt;Location.POST_NAME: &#x27;POST_NAME&#x27;&gt;}"}, "sqlglot.dialects.bigquery.BigQuery.Generator.RESERVED_KEYWORDS": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Generator.RESERVED_KEYWORDS", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Generator.RESERVED_KEYWORDS", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;for&#x27;, &#x27;unbounded&#x27;, &#x27;partition&#x27;, &#x27;where&#x27;, &#x27;rollup&#x27;, &#x27;cast&#x27;, &#x27;enum&#x27;, &#x27;left&#x27;, &#x27;rows&#x27;, &#x27;all&#x27;, &#x27;grouping&#x27;, &#x27;fetch&#x27;, &#x27;collate&#x27;, &#x27;respect&#x27;, &#x27;into&#x27;, &#x27;union&#x27;, &#x27;inner&#x27;, &#x27;default&#x27;, &#x27;desc&#x27;, &#x27;full&#x27;, &#x27;define&#x27;, &#x27;intersect&#x27;, &#x27;true&#x27;, &#x27;by&#x27;, &#x27;of&#x27;, &#x27;treat&#x27;, &#x27;except&#x27;, &#x27;recursive&#x27;, &#x27;asc&#x27;, &#x27;using&#x27;, &#x27;like&#x27;, &#x27;range&#x27;, &#x27;case&#x27;, &#x27;create&#x27;, &#x27;groups&#x27;, &#x27;if&#x27;, &#x27;lateral&#x27;, &#x27;over&#x27;, &#x27;escape&#x27;, &#x27;following&#x27;, &#x27;select&#x27;, &#x27;when&#x27;, &#x27;exclude&#x27;, &#x27;window&#x27;, &#x27;or&#x27;, &#x27;order&#x27;, &#x27;unnest&#x27;, &#x27;null&#x27;, &#x27;assert_rows_modified&#x27;, &#x27;with&#x27;, &#x27;then&#x27;, &#x27;else&#x27;, &#x27;proto&#x27;, &#x27;and&#x27;, &#x27;natural&#x27;, &#x27;false&#x27;, &#x27;hash&#x27;, &#x27;contains&#x27;, &#x27;end&#x27;, &#x27;lookup&#x27;, &#x27;having&#x27;, &#x27;ignore&#x27;, &#x27;as&#x27;, &#x27;not&#x27;, &#x27;between&#x27;, &#x27;new&#x27;, &#x27;set&#x27;, &#x27;distinct&#x27;, &#x27;some&#x27;, &#x27;preceding&#x27;, &#x27;any&#x27;, &#x27;qualify&#x27;, &#x27;exists&#x27;, &#x27;tablesample&#x27;, &#x27;on&#x27;, &#x27;merge&#x27;, &#x27;within&#x27;, &#x27;extract&#x27;, &#x27;in&#x27;, &#x27;right&#x27;, &#x27;is&#x27;, &#x27;at&#x27;, &#x27;join&#x27;, &#x27;cross&#x27;, &#x27;struct&#x27;, &#x27;to&#x27;, &#x27;from&#x27;, &#x27;outer&#x27;, &#x27;no&#x27;, &#x27;array&#x27;, &#x27;nulls&#x27;, &#x27;interval&#x27;, &#x27;cube&#x27;, &#x27;current&#x27;, &#x27;limit&#x27;, &#x27;group&#x27;}"}, "sqlglot.dialects.bigquery.BigQuery.Generator.eq_sql": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Generator.eq_sql", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Generator.eq_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">EQ</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.bigquery.BigQuery.Generator.attimezone_sql": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Generator.attimezone_sql", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Generator.attimezone_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">AtTimeZone</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.bigquery.BigQuery.Generator.trycast_sql": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Generator.trycast_sql", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Generator.trycast_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">TryCast</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.bigquery.BigQuery.Generator.cte_sql": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Generator.cte_sql", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Generator.cte_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">CTE</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.bigquery.BigQuery.Generator.array_sql": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Generator.array_sql", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Generator.array_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Array</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.bigquery.BigQuery.Generator.transaction_sql": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Generator.transaction_sql", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Generator.transaction_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">*</span><span class=\"n\">_</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.bigquery.BigQuery.Generator.commit_sql": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Generator.commit_sql", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Generator.commit_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">*</span><span class=\"n\">_</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.bigquery.BigQuery.Generator.rollback_sql": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Generator.rollback_sql", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Generator.rollback_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">*</span><span class=\"n\">_</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.bigquery.BigQuery.Generator.in_unnest_op": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Generator.in_unnest_op", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Generator.in_unnest_op", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Unnest</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.bigquery.BigQuery.Generator.except_op": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Generator.except_op", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Generator.except_op", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Except</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.bigquery.BigQuery.Generator.intersect_op": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Generator.intersect_op", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Generator.intersect_op", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Intersect</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.bigquery.BigQuery.Generator.with_properties": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Generator.with_properties", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Generator.with_properties", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">properties</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Properties</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.bigquery.BigQuery.Generator.version_sql": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Generator.version_sql", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Generator.version_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Version</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.bigquery.BigQuery.Generator.LOG_BASE_FIRST": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Generator.LOG_BASE_FIRST", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Generator.LOG_BASE_FIRST", "kind": "variable", "doc": "<p></p>\n", "default_value": "False"}, "sqlglot.dialects.bigquery.BigQuery.Generator.INVERSE_TIME_MAPPING": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Generator.INVERSE_TIME_MAPPING", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Generator.INVERSE_TIME_MAPPING", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict[str, str]", "default_value": "{&#x27;%m/%d/%y&#x27;: &#x27;%D&#x27;}"}, "sqlglot.dialects.bigquery.BigQuery.Generator.INVERSE_TIME_TRIE": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Generator.INVERSE_TIME_TRIE", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Generator.INVERSE_TIME_TRIE", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict", "default_value": "{&#x27;%&#x27;: {&#x27;m&#x27;: {&#x27;/&#x27;: {&#x27;%&#x27;: {&#x27;d&#x27;: {&#x27;/&#x27;: {&#x27;%&#x27;: {&#x27;y&#x27;: {0: True}}}}}}}}}"}, "sqlglot.dialects.bigquery.BigQuery.Generator.INVERSE_ESCAPE_SEQUENCES": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Generator.INVERSE_ESCAPE_SEQUENCES", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Generator.INVERSE_ESCAPE_SEQUENCES", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict[str, str]", "default_value": "{&#x27;\\x07&#x27;: &#x27;\\\\a&#x27;, &#x27;\\x08&#x27;: &#x27;\\\\b&#x27;, &#x27;\\x0c&#x27;: &#x27;\\\\f&#x27;, &#x27;\\n&#x27;: &#x27;\\\\n&#x27;, &#x27;\\r&#x27;: &#x27;\\\\r&#x27;, &#x27;\\t&#x27;: &#x27;\\\\t&#x27;, &#x27;\\x0b&#x27;: &#x27;\\\\v&#x27;}"}, "sqlglot.dialects.bigquery.BigQuery.Generator.UNNEST_COLUMN_ONLY": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Generator.UNNEST_COLUMN_ONLY", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Generator.UNNEST_COLUMN_ONLY", "kind": "variable", "doc": "<p></p>\n", "default_value": "True"}, "sqlglot.dialects.bigquery.BigQuery.Generator.NORMALIZE_FUNCTIONS": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Generator.NORMALIZE_FUNCTIONS", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Generator.NORMALIZE_FUNCTIONS", "kind": "variable", "doc": "<p></p>\n", "annotation": ": bool | str", "default_value": "False"}, "sqlglot.dialects.bigquery.BigQuery.Generator.can_identify": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Generator.can_identify", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Generator.can_identify", "kind": "function", "doc": "<p>Checks if text can be identified given an identify option.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>text:</strong>  The text to check.</li>\n<li><strong>identify:</strong>  \"always\" or <code>True</code>: Always returns true.\n\"safe\": True if the identifier is case-insensitive.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>Whether or not the given text can be identified.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">text</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">identify</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;safe&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.bigquery.BigQuery.Generator.QUOTE_START": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Generator.QUOTE_START", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Generator.QUOTE_START", "kind": "variable", "doc": "<p></p>\n", "default_value": "&quot;&#x27;&quot;"}, "sqlglot.dialects.bigquery.BigQuery.Generator.QUOTE_END": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Generator.QUOTE_END", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Generator.QUOTE_END", "kind": "variable", "doc": "<p></p>\n", "default_value": "&quot;&#x27;&quot;"}, "sqlglot.dialects.bigquery.BigQuery.Generator.IDENTIFIER_START": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Generator.IDENTIFIER_START", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Generator.IDENTIFIER_START", "kind": "variable", "doc": "<p></p>\n", "default_value": "&#x27;`&#x27;"}, "sqlglot.dialects.bigquery.BigQuery.Generator.IDENTIFIER_END": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Generator.IDENTIFIER_END", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Generator.IDENTIFIER_END", "kind": "variable", "doc": "<p></p>\n", "default_value": "&#x27;`&#x27;"}, "sqlglot.dialects.bigquery.BigQuery.Generator.TOKENIZER_CLASS": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Generator.TOKENIZER_CLASS", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Generator.TOKENIZER_CLASS", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;class &#x27;sqlglot.dialects.bigquery.BigQuery.Tokenizer&#x27;&gt;"}, "sqlglot.dialects.bigquery.BigQuery.Generator.BIT_START": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Generator.BIT_START", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Generator.BIT_START", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Optional[str]", "default_value": "None"}, "sqlglot.dialects.bigquery.BigQuery.Generator.BIT_END": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Generator.BIT_END", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Generator.BIT_END", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Optional[str]", "default_value": "None"}, "sqlglot.dialects.bigquery.BigQuery.Generator.HEX_START": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Generator.HEX_START", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Generator.HEX_START", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Optional[str]", "default_value": "&#x27;0x&#x27;"}, "sqlglot.dialects.bigquery.BigQuery.Generator.HEX_END": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Generator.HEX_END", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Generator.HEX_END", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Optional[str]", "default_value": "&#x27;&#x27;"}, "sqlglot.dialects.bigquery.BigQuery.Generator.BYTE_START": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Generator.BYTE_START", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Generator.BYTE_START", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Optional[str]", "default_value": "&quot;b&#x27;&quot;"}, "sqlglot.dialects.bigquery.BigQuery.Generator.BYTE_END": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Generator.BYTE_END", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Generator.BYTE_END", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Optional[str]", "default_value": "&quot;&#x27;&quot;"}, "sqlglot.dialects.bigquery.BigQuery.tokenizer_class": {"fullname": "sqlglot.dialects.bigquery.BigQuery.tokenizer_class", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.tokenizer_class", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;class &#x27;sqlglot.dialects.bigquery.BigQuery.Tokenizer&#x27;&gt;"}, "sqlglot.dialects.bigquery.BigQuery.parser_class": {"fullname": "sqlglot.dialects.bigquery.BigQuery.parser_class", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.parser_class", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;class &#x27;sqlglot.dialects.bigquery.BigQuery.Parser&#x27;&gt;"}, "sqlglot.dialects.bigquery.BigQuery.generator_class": {"fullname": "sqlglot.dialects.bigquery.BigQuery.generator_class", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.generator_class", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;class &#x27;sqlglot.dialects.bigquery.BigQuery.Generator&#x27;&gt;"}, "sqlglot.dialects.bigquery.BigQuery.TIME_TRIE": {"fullname": "sqlglot.dialects.bigquery.BigQuery.TIME_TRIE", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.TIME_TRIE", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict", "default_value": "{&#x27;%&#x27;: {&#x27;D&#x27;: {0: True}}}"}, "sqlglot.dialects.bigquery.BigQuery.FORMAT_TRIE": {"fullname": "sqlglot.dialects.bigquery.BigQuery.FORMAT_TRIE", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.FORMAT_TRIE", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict", "default_value": "{&#x27;D&#x27;: {&#x27;D&#x27;: {0: True}}, &#x27;M&#x27;: {&#x27;M&#x27;: {0: True}, &#x27;O&#x27;: {&#x27;N&#x27;: {0: True, &#x27;T&#x27;: {&#x27;H&#x27;: {0: True}}}}, &#x27;I&#x27;: {0: True}}, &#x27;Y&#x27;: {&#x27;Y&#x27;: {&#x27;Y&#x27;: {&#x27;Y&#x27;: {0: True}}, 0: True}}, &#x27;H&#x27;: {&#x27;H&#x27;: {0: True, &#x27;1&#x27;: {&#x27;2&#x27;: {0: True}}, &#x27;2&#x27;: {&#x27;4&#x27;: {0: True}}}}, &#x27;S&#x27;: {&#x27;S&#x27;: {0: True, &#x27;S&#x27;: {&#x27;S&#x27;: {&#x27;S&#x27;: {0: True}}}}}, &#x27;T&#x27;: {&#x27;Z&#x27;: {&#x27;H&#x27;: {0: True}}}}"}, "sqlglot.dialects.bigquery.BigQuery.INVERSE_TIME_MAPPING": {"fullname": "sqlglot.dialects.bigquery.BigQuery.INVERSE_TIME_MAPPING", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.INVERSE_TIME_MAPPING", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict[str, str]", "default_value": "{&#x27;%m/%d/%y&#x27;: &#x27;%D&#x27;}"}, "sqlglot.dialects.bigquery.BigQuery.INVERSE_TIME_TRIE": {"fullname": "sqlglot.dialects.bigquery.BigQuery.INVERSE_TIME_TRIE", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.INVERSE_TIME_TRIE", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict", "default_value": "{&#x27;%&#x27;: {&#x27;m&#x27;: {&#x27;/&#x27;: {&#x27;%&#x27;: {&#x27;d&#x27;: {&#x27;/&#x27;: {&#x27;%&#x27;: {&#x27;y&#x27;: {0: True}}}}}}}}}"}, "sqlglot.dialects.bigquery.BigQuery.INVERSE_ESCAPE_SEQUENCES": {"fullname": "sqlglot.dialects.bigquery.BigQuery.INVERSE_ESCAPE_SEQUENCES", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.INVERSE_ESCAPE_SEQUENCES", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict[str, str]", "default_value": "{&#x27;\\x07&#x27;: &#x27;\\\\a&#x27;, &#x27;\\x08&#x27;: &#x27;\\\\b&#x27;, &#x27;\\x0c&#x27;: &#x27;\\\\f&#x27;, &#x27;\\n&#x27;: &#x27;\\\\n&#x27;, &#x27;\\r&#x27;: &#x27;\\\\r&#x27;, &#x27;\\t&#x27;: &#x27;\\\\t&#x27;, &#x27;\\x0b&#x27;: &#x27;\\\\v&#x27;}"}, "sqlglot.dialects.bigquery.BigQuery.QUOTE_START": {"fullname": "sqlglot.dialects.bigquery.BigQuery.QUOTE_START", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.QUOTE_START", "kind": "variable", "doc": "<p></p>\n", "default_value": "&quot;&#x27;&quot;"}, "sqlglot.dialects.bigquery.BigQuery.QUOTE_END": {"fullname": "sqlglot.dialects.bigquery.BigQuery.QUOTE_END", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.QUOTE_END", "kind": "variable", "doc": "<p></p>\n", "default_value": "&quot;&#x27;&quot;"}, "sqlglot.dialects.bigquery.BigQuery.IDENTIFIER_START": {"fullname": "sqlglot.dialects.bigquery.BigQuery.IDENTIFIER_START", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.IDENTIFIER_START", "kind": "variable", "doc": "<p></p>\n", "default_value": "&#x27;`&#x27;"}, "sqlglot.dialects.bigquery.BigQuery.IDENTIFIER_END": {"fullname": "sqlglot.dialects.bigquery.BigQuery.IDENTIFIER_END", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.IDENTIFIER_END", "kind": "variable", "doc": "<p></p>\n", "default_value": "&#x27;`&#x27;"}, "sqlglot.dialects.bigquery.BigQuery.BIT_START": {"fullname": "sqlglot.dialects.bigquery.BigQuery.BIT_START", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.BIT_START", "kind": "variable", "doc": "<p></p>\n", "default_value": "None"}, "sqlglot.dialects.bigquery.BigQuery.BIT_END": {"fullname": "sqlglot.dialects.bigquery.BigQuery.BIT_END", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.BIT_END", "kind": "variable", "doc": "<p></p>\n", "default_value": "None"}, "sqlglot.dialects.bigquery.BigQuery.HEX_START": {"fullname": "sqlglot.dialects.bigquery.BigQuery.HEX_START", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.HEX_START", "kind": "variable", "doc": "<p></p>\n", "default_value": "&#x27;0x&#x27;"}, "sqlglot.dialects.bigquery.BigQuery.HEX_END": {"fullname": "sqlglot.dialects.bigquery.BigQuery.HEX_END", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.HEX_END", "kind": "variable", "doc": "<p></p>\n", "default_value": "&#x27;&#x27;"}, "sqlglot.dialects.bigquery.BigQuery.BYTE_START": {"fullname": "sqlglot.dialects.bigquery.BigQuery.BYTE_START", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.BYTE_START", "kind": "variable", "doc": "<p></p>\n", "default_value": "&quot;b&#x27;&quot;"}, "sqlglot.dialects.bigquery.BigQuery.BYTE_END": {"fullname": "sqlglot.dialects.bigquery.BigQuery.BYTE_END", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.BYTE_END", "kind": "variable", "doc": "<p></p>\n", "default_value": "&quot;&#x27;&quot;"}, "sqlglot.dialects.clickhouse": {"fullname": "sqlglot.dialects.clickhouse", "modulename": "sqlglot.dialects.clickhouse", "kind": "module", "doc": "<p></p>\n"}, "sqlglot.dialects.clickhouse.ClickHouse": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse", "kind": "class", "doc": "<p></p>\n", "bases": "sqlglot.dialects.dialect.Dialect"}, "sqlglot.dialects.clickhouse.ClickHouse.NORMALIZE_FUNCTIONS": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.NORMALIZE_FUNCTIONS", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.NORMALIZE_FUNCTIONS", "kind": "variable", "doc": "<p></p>\n", "annotation": ": bool | str", "default_value": "False"}, "sqlglot.dialects.clickhouse.ClickHouse.NULL_ORDERING": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.NULL_ORDERING", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.NULL_ORDERING", "kind": "variable", "doc": "<p></p>\n", "default_value": "&#x27;nulls_are_last&#x27;"}, "sqlglot.dialects.clickhouse.ClickHouse.STRICT_STRING_CONCAT": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.STRICT_STRING_CONCAT", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.STRICT_STRING_CONCAT", "kind": "variable", "doc": "<p></p>\n", "default_value": "True"}, "sqlglot.dialects.clickhouse.ClickHouse.SUPPORTS_USER_DEFINED_TYPES": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.SUPPORTS_USER_DEFINED_TYPES", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.SUPPORTS_USER_DEFINED_TYPES", "kind": "variable", "doc": "<p></p>\n", "default_value": "False"}, "sqlglot.dialects.clickhouse.ClickHouse.ESCAPE_SEQUENCES": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.ESCAPE_SEQUENCES", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.ESCAPE_SEQUENCES", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;\\\\0&#x27;: &#x27;\\x00&#x27;}"}, "sqlglot.dialects.clickhouse.ClickHouse.Tokenizer": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Tokenizer", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Tokenizer", "kind": "class", "doc": "<p></p>\n", "bases": "sqlglot.tokens.Tokenizer"}, "sqlglot.dialects.clickhouse.ClickHouse.Tokenizer.COMMENTS": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Tokenizer.COMMENTS", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Tokenizer.COMMENTS", "kind": "variable", "doc": "<p></p>\n", "default_value": "[&#x27;--&#x27;, &#x27;#&#x27;, &#x27;#!&#x27;, (&#x27;/*&#x27;, &#x27;*/&#x27;)]"}, "sqlglot.dialects.clickhouse.ClickHouse.Tokenizer.IDENTIFIERS": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Tokenizer.IDENTIFIERS", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Tokenizer.IDENTIFIERS", "kind": "variable", "doc": "<p></p>\n", "default_value": "[&#x27;&quot;&#x27;, &#x27;`&#x27;]"}, "sqlglot.dialects.clickhouse.ClickHouse.Tokenizer.STRING_ESCAPES": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Tokenizer.STRING_ESCAPES", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Tokenizer.STRING_ESCAPES", "kind": "variable", "doc": "<p></p>\n", "default_value": "[&quot;&#x27;&quot;, &#x27;\\\\&#x27;]"}, "sqlglot.dialects.clickhouse.ClickHouse.Tokenizer.BIT_STRINGS": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Tokenizer.BIT_STRINGS", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Tokenizer.BIT_STRINGS", "kind": "variable", "doc": "<p></p>\n", "default_value": "[(&#x27;0b&#x27;, &#x27;&#x27;)]"}, "sqlglot.dialects.clickhouse.ClickHouse.Tokenizer.HEX_STRINGS": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Tokenizer.HEX_STRINGS", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Tokenizer.HEX_STRINGS", "kind": "variable", "doc": "<p></p>\n", "default_value": "[(&#x27;0x&#x27;, &#x27;&#x27;), (&#x27;0X&#x27;, &#x27;&#x27;)]"}, "sqlglot.dialects.clickhouse.ClickHouse.Tokenizer.HEREDOC_STRINGS": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Tokenizer.HEREDOC_STRINGS", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Tokenizer.HEREDOC_STRINGS", "kind": "variable", "doc": "<p></p>\n", "default_value": "[&#x27;$&#x27;]"}, "sqlglot.dialects.clickhouse.ClickHouse.Tokenizer.KEYWORDS": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Tokenizer.KEYWORDS", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Tokenizer.KEYWORDS", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;{%&#x27;: &lt;TokenType.BLOCK_START: &#x27;BLOCK_START&#x27;&gt;, &#x27;{%+&#x27;: &lt;TokenType.BLOCK_START: &#x27;BLOCK_START&#x27;&gt;, &#x27;{%-&#x27;: &lt;TokenType.BLOCK_START: &#x27;BLOCK_START&#x27;&gt;, &#x27;%}&#x27;: &lt;TokenType.BLOCK_END: &#x27;BLOCK_END&#x27;&gt;, &#x27;+%}&#x27;: &lt;TokenType.BLOCK_END: &#x27;BLOCK_END&#x27;&gt;, &#x27;-%}&#x27;: &lt;TokenType.BLOCK_END: &#x27;BLOCK_END&#x27;&gt;, &#x27;{{+&#x27;: &lt;TokenType.BLOCK_START: &#x27;BLOCK_START&#x27;&gt;, &#x27;{{-&#x27;: &lt;TokenType.BLOCK_START: &#x27;BLOCK_START&#x27;&gt;, &#x27;+}}&#x27;: &lt;TokenType.BLOCK_END: &#x27;BLOCK_END&#x27;&gt;, &#x27;-}}&#x27;: &lt;TokenType.BLOCK_END: &#x27;BLOCK_END&#x27;&gt;, &#x27;/*+&#x27;: &lt;TokenType.HINT: &#x27;HINT&#x27;&gt;, &#x27;==&#x27;: &lt;TokenType.EQ: &#x27;EQ&#x27;&gt;, &#x27;::&#x27;: &lt;TokenType.DCOLON: &#x27;DCOLON&#x27;&gt;, &#x27;||&#x27;: &lt;TokenType.DPIPE: &#x27;DPIPE&#x27;&gt;, &#x27;&gt;=&#x27;: &lt;TokenType.GTE: &#x27;GTE&#x27;&gt;, &#x27;&lt;=&#x27;: &lt;TokenType.LTE: &#x27;LTE&#x27;&gt;, &#x27;&lt;&gt;&#x27;: &lt;TokenType.NEQ: &#x27;NEQ&#x27;&gt;, &#x27;!=&#x27;: &lt;TokenType.NEQ: &#x27;NEQ&#x27;&gt;, &#x27;&lt;=&gt;&#x27;: &lt;TokenType.NULLSAFE_EQ: &#x27;NULLSAFE_EQ&#x27;&gt;, &#x27;-&gt;&#x27;: &lt;TokenType.ARROW: &#x27;ARROW&#x27;&gt;, &#x27;-&gt;&gt;&#x27;: &lt;TokenType.DARROW: &#x27;DARROW&#x27;&gt;, &#x27;=&gt;&#x27;: &lt;TokenType.FARROW: &#x27;FARROW&#x27;&gt;, &#x27;#&gt;&#x27;: &lt;TokenType.HASH_ARROW: &#x27;HASH_ARROW&#x27;&gt;, &#x27;#&gt;&gt;&#x27;: &lt;TokenType.DHASH_ARROW: &#x27;DHASH_ARROW&#x27;&gt;, &#x27;&lt;-&gt;&#x27;: &lt;TokenType.LR_ARROW: &#x27;LR_ARROW&#x27;&gt;, &#x27;&amp;&amp;&#x27;: &lt;TokenType.DAMP: &#x27;DAMP&#x27;&gt;, &#x27;??&#x27;: &lt;TokenType.DQMARK: &#x27;DQMARK&#x27;&gt;, &#x27;ALL&#x27;: &lt;TokenType.ALL: &#x27;ALL&#x27;&gt;, &#x27;ALWAYS&#x27;: &lt;TokenType.ALWAYS: &#x27;ALWAYS&#x27;&gt;, &#x27;AND&#x27;: &lt;TokenType.AND: &#x27;AND&#x27;&gt;, &#x27;ANTI&#x27;: &lt;TokenType.ANTI: &#x27;ANTI&#x27;&gt;, &#x27;ANY&#x27;: &lt;TokenType.ANY: &#x27;ANY&#x27;&gt;, &#x27;ASC&#x27;: &lt;TokenType.ASC: &#x27;ASC&#x27;&gt;, &#x27;AS&#x27;: &lt;TokenType.ALIAS: &#x27;ALIAS&#x27;&gt;, &#x27;ASOF&#x27;: &lt;TokenType.ASOF: &#x27;ASOF&#x27;&gt;, &#x27;AUTOINCREMENT&#x27;: &lt;TokenType.AUTO_INCREMENT: &#x27;AUTO_INCREMENT&#x27;&gt;, &#x27;AUTO_INCREMENT&#x27;: &lt;TokenType.AUTO_INCREMENT: &#x27;AUTO_INCREMENT&#x27;&gt;, &#x27;BEGIN&#x27;: &lt;TokenType.BEGIN: &#x27;BEGIN&#x27;&gt;, &#x27;BETWEEN&#x27;: &lt;TokenType.BETWEEN: &#x27;BETWEEN&#x27;&gt;, &#x27;CACHE&#x27;: &lt;TokenType.CACHE: &#x27;CACHE&#x27;&gt;, &#x27;UNCACHE&#x27;: &lt;TokenType.UNCACHE: &#x27;UNCACHE&#x27;&gt;, &#x27;CASE&#x27;: &lt;TokenType.CASE: &#x27;CASE&#x27;&gt;, &#x27;CHARACTER SET&#x27;: &lt;TokenType.CHARACTER_SET: &#x27;CHARACTER_SET&#x27;&gt;, &#x27;CLUSTER BY&#x27;: &lt;TokenType.CLUSTER_BY: &#x27;CLUSTER_BY&#x27;&gt;, &#x27;COLLATE&#x27;: &lt;TokenType.COLLATE: &#x27;COLLATE&#x27;&gt;, &#x27;COLUMN&#x27;: &lt;TokenType.COLUMN: &#x27;COLUMN&#x27;&gt;, &#x27;COMMIT&#x27;: &lt;TokenType.COMMIT: &#x27;COMMIT&#x27;&gt;, &#x27;CONNECT BY&#x27;: &lt;TokenType.CONNECT_BY: &#x27;CONNECT_BY&#x27;&gt;, &#x27;CONSTRAINT&#x27;: &lt;TokenType.CONSTRAINT: &#x27;CONSTRAINT&#x27;&gt;, &#x27;CREATE&#x27;: &lt;TokenType.CREATE: &#x27;CREATE&#x27;&gt;, &#x27;CROSS&#x27;: &lt;TokenType.CROSS: &#x27;CROSS&#x27;&gt;, &#x27;CUBE&#x27;: &lt;TokenType.CUBE: &#x27;CUBE&#x27;&gt;, &#x27;CURRENT_DATE&#x27;: &lt;TokenType.CURRENT_DATE: &#x27;CURRENT_DATE&#x27;&gt;, &#x27;CURRENT_TIME&#x27;: &lt;TokenType.CURRENT_TIME: &#x27;CURRENT_TIME&#x27;&gt;, &#x27;CURRENT_TIMESTAMP&#x27;: &lt;TokenType.CURRENT_TIMESTAMP: &#x27;CURRENT_TIMESTAMP&#x27;&gt;, &#x27;CURRENT_USER&#x27;: &lt;TokenType.CURRENT_USER: &#x27;CURRENT_USER&#x27;&gt;, &#x27;DATABASE&#x27;: &lt;TokenType.DATABASE: &#x27;DATABASE&#x27;&gt;, &#x27;DEFAULT&#x27;: &lt;TokenType.DEFAULT: &#x27;DEFAULT&#x27;&gt;, &#x27;DELETE&#x27;: &lt;TokenType.DELETE: &#x27;DELETE&#x27;&gt;, &#x27;DESC&#x27;: &lt;TokenType.DESC: &#x27;DESC&#x27;&gt;, &#x27;DESCRIBE&#x27;: &lt;TokenType.DESCRIBE: &#x27;DESCRIBE&#x27;&gt;, &#x27;DISTINCT&#x27;: &lt;TokenType.DISTINCT: &#x27;DISTINCT&#x27;&gt;, &#x27;DISTRIBUTE BY&#x27;: &lt;TokenType.DISTRIBUTE_BY: &#x27;DISTRIBUTE_BY&#x27;&gt;, &#x27;DIV&#x27;: &lt;TokenType.DIV: &#x27;DIV&#x27;&gt;, &#x27;DROP&#x27;: &lt;TokenType.DROP: &#x27;DROP&#x27;&gt;, &#x27;ELSE&#x27;: &lt;TokenType.ELSE: &#x27;ELSE&#x27;&gt;, &#x27;END&#x27;: &lt;TokenType.END: &#x27;END&#x27;&gt;, &#x27;ESCAPE&#x27;: &lt;TokenType.ESCAPE: &#x27;ESCAPE&#x27;&gt;, &#x27;EXCEPT&#x27;: &lt;TokenType.EXCEPT: &#x27;EXCEPT&#x27;&gt;, &#x27;EXECUTE&#x27;: &lt;TokenType.EXECUTE: &#x27;EXECUTE&#x27;&gt;, &#x27;EXISTS&#x27;: &lt;TokenType.EXISTS: &#x27;EXISTS&#x27;&gt;, &#x27;FALSE&#x27;: &lt;TokenType.FALSE: &#x27;FALSE&#x27;&gt;, &#x27;FETCH&#x27;: &lt;TokenType.FETCH: &#x27;FETCH&#x27;&gt;, &#x27;FILTER&#x27;: &lt;TokenType.FILTER: &#x27;FILTER&#x27;&gt;, &#x27;FIRST&#x27;: &lt;TokenType.FIRST: &#x27;FIRST&#x27;&gt;, &#x27;FULL&#x27;: &lt;TokenType.FULL: &#x27;FULL&#x27;&gt;, &#x27;FUNCTION&#x27;: &lt;TokenType.FUNCTION: &#x27;FUNCTION&#x27;&gt;, &#x27;FOR&#x27;: &lt;TokenType.FOR: &#x27;FOR&#x27;&gt;, &#x27;FOREIGN KEY&#x27;: &lt;TokenType.FOREIGN_KEY: &#x27;FOREIGN_KEY&#x27;&gt;, &#x27;FORMAT&#x27;: &lt;TokenType.FORMAT: &#x27;FORMAT&#x27;&gt;, &#x27;FROM&#x27;: &lt;TokenType.FROM: &#x27;FROM&#x27;&gt;, &#x27;GEOGRAPHY&#x27;: &lt;TokenType.GEOGRAPHY: &#x27;GEOGRAPHY&#x27;&gt;, &#x27;GEOMETRY&#x27;: &lt;TokenType.GEOMETRY: &#x27;GEOMETRY&#x27;&gt;, &#x27;GLOB&#x27;: &lt;TokenType.GLOB: &#x27;GLOB&#x27;&gt;, &#x27;GROUP BY&#x27;: &lt;TokenType.GROUP_BY: &#x27;GROUP_BY&#x27;&gt;, &#x27;GROUPING SETS&#x27;: &lt;TokenType.GROUPING_SETS: &#x27;GROUPING_SETS&#x27;&gt;, &#x27;HAVING&#x27;: &lt;TokenType.HAVING: &#x27;HAVING&#x27;&gt;, &#x27;ILIKE&#x27;: &lt;TokenType.ILIKE: &#x27;ILIKE&#x27;&gt;, &#x27;IN&#x27;: &lt;TokenType.IN: &#x27;IN&#x27;&gt;, &#x27;INDEX&#x27;: &lt;TokenType.INDEX: &#x27;INDEX&#x27;&gt;, &#x27;INET&#x27;: &lt;TokenType.INET: &#x27;INET&#x27;&gt;, &#x27;INNER&#x27;: &lt;TokenType.INNER: &#x27;INNER&#x27;&gt;, &#x27;INSERT&#x27;: &lt;TokenType.INSERT: &#x27;INSERT&#x27;&gt;, &#x27;INTERVAL&#x27;: &lt;TokenType.INTERVAL: &#x27;INTERVAL&#x27;&gt;, &#x27;INTERSECT&#x27;: &lt;TokenType.INTERSECT: &#x27;INTERSECT&#x27;&gt;, &#x27;INTO&#x27;: &lt;TokenType.INTO: &#x27;INTO&#x27;&gt;, &#x27;IS&#x27;: &lt;TokenType.IS: &#x27;IS&#x27;&gt;, &#x27;ISNULL&#x27;: &lt;TokenType.ISNULL: &#x27;ISNULL&#x27;&gt;, &#x27;JOIN&#x27;: &lt;TokenType.JOIN: &#x27;JOIN&#x27;&gt;, &#x27;KEEP&#x27;: &lt;TokenType.KEEP: &#x27;KEEP&#x27;&gt;, &#x27;KILL&#x27;: &lt;TokenType.KILL: &#x27;KILL&#x27;&gt;, &#x27;LATERAL&#x27;: &lt;TokenType.LATERAL: &#x27;LATERAL&#x27;&gt;, &#x27;LEFT&#x27;: &lt;TokenType.LEFT: &#x27;LEFT&#x27;&gt;, &#x27;LIKE&#x27;: &lt;TokenType.LIKE: &#x27;LIKE&#x27;&gt;, &#x27;LIMIT&#x27;: &lt;TokenType.LIMIT: &#x27;LIMIT&#x27;&gt;, &#x27;LOAD&#x27;: &lt;TokenType.LOAD: &#x27;LOAD&#x27;&gt;, &#x27;LOCK&#x27;: &lt;TokenType.LOCK: &#x27;LOCK&#x27;&gt;, &#x27;MERGE&#x27;: &lt;TokenType.MERGE: &#x27;MERGE&#x27;&gt;, &#x27;NATURAL&#x27;: &lt;TokenType.NATURAL: &#x27;NATURAL&#x27;&gt;, &#x27;NEXT&#x27;: &lt;TokenType.NEXT: &#x27;NEXT&#x27;&gt;, &#x27;NOT&#x27;: &lt;TokenType.NOT: &#x27;NOT&#x27;&gt;, &#x27;NOTNULL&#x27;: &lt;TokenType.NOTNULL: &#x27;NOTNULL&#x27;&gt;, &#x27;NULL&#x27;: &lt;TokenType.NULL: &#x27;NULL&#x27;&gt;, &#x27;OBJECT&#x27;: &lt;TokenType.OBJECT: &#x27;OBJECT&#x27;&gt;, &#x27;OFFSET&#x27;: &lt;TokenType.OFFSET: &#x27;OFFSET&#x27;&gt;, &#x27;ON&#x27;: &lt;TokenType.ON: &#x27;ON&#x27;&gt;, &#x27;OR&#x27;: &lt;TokenType.OR: &#x27;OR&#x27;&gt;, &#x27;XOR&#x27;: &lt;TokenType.XOR: &#x27;XOR&#x27;&gt;, &#x27;ORDER BY&#x27;: &lt;TokenType.ORDER_BY: &#x27;ORDER_BY&#x27;&gt;, &#x27;ORDINALITY&#x27;: &lt;TokenType.ORDINALITY: &#x27;ORDINALITY&#x27;&gt;, &#x27;OUTER&#x27;: &lt;TokenType.OUTER: &#x27;OUTER&#x27;&gt;, &#x27;OVER&#x27;: &lt;TokenType.OVER: &#x27;OVER&#x27;&gt;, &#x27;OVERLAPS&#x27;: &lt;TokenType.OVERLAPS: &#x27;OVERLAPS&#x27;&gt;, &#x27;OVERWRITE&#x27;: &lt;TokenType.OVERWRITE: &#x27;OVERWRITE&#x27;&gt;, &#x27;PARTITION&#x27;: &lt;TokenType.PARTITION: &#x27;PARTITION&#x27;&gt;, &#x27;PARTITION BY&#x27;: &lt;TokenType.PARTITION_BY: &#x27;PARTITION_BY&#x27;&gt;, &#x27;PARTITIONED BY&#x27;: &lt;TokenType.PARTITION_BY: &#x27;PARTITION_BY&#x27;&gt;, &#x27;PARTITIONED_BY&#x27;: &lt;TokenType.PARTITION_BY: &#x27;PARTITION_BY&#x27;&gt;, &#x27;PERCENT&#x27;: &lt;TokenType.PERCENT: &#x27;PERCENT&#x27;&gt;, &#x27;PIVOT&#x27;: &lt;TokenType.PIVOT: &#x27;PIVOT&#x27;&gt;, &#x27;PRAGMA&#x27;: &lt;TokenType.PRAGMA: &#x27;PRAGMA&#x27;&gt;, &#x27;PRIMARY KEY&#x27;: &lt;TokenType.PRIMARY_KEY: &#x27;PRIMARY_KEY&#x27;&gt;, &#x27;PROCEDURE&#x27;: &lt;TokenType.PROCEDURE: &#x27;PROCEDURE&#x27;&gt;, &#x27;QUALIFY&#x27;: &lt;TokenType.QUALIFY: &#x27;QUALIFY&#x27;&gt;, &#x27;RANGE&#x27;: &lt;TokenType.RANGE: &#x27;RANGE&#x27;&gt;, &#x27;RECURSIVE&#x27;: &lt;TokenType.RECURSIVE: &#x27;RECURSIVE&#x27;&gt;, &#x27;REGEXP&#x27;: &lt;TokenType.RLIKE: &#x27;RLIKE&#x27;&gt;, &#x27;REPLACE&#x27;: &lt;TokenType.REPLACE: &#x27;REPLACE&#x27;&gt;, &#x27;RETURNING&#x27;: &lt;TokenType.RETURNING: &#x27;RETURNING&#x27;&gt;, &#x27;REFERENCES&#x27;: &lt;TokenType.REFERENCES: &#x27;REFERENCES&#x27;&gt;, &#x27;RIGHT&#x27;: &lt;TokenType.RIGHT: &#x27;RIGHT&#x27;&gt;, &#x27;RLIKE&#x27;: &lt;TokenType.RLIKE: &#x27;RLIKE&#x27;&gt;, &#x27;ROLLBACK&#x27;: &lt;TokenType.ROLLBACK: &#x27;ROLLBACK&#x27;&gt;, &#x27;ROLLUP&#x27;: &lt;TokenType.ROLLUP: &#x27;ROLLUP&#x27;&gt;, &#x27;ROW&#x27;: &lt;TokenType.ROW: &#x27;ROW&#x27;&gt;, &#x27;ROWS&#x27;: &lt;TokenType.ROWS: &#x27;ROWS&#x27;&gt;, &#x27;SCHEMA&#x27;: &lt;TokenType.SCHEMA: &#x27;SCHEMA&#x27;&gt;, &#x27;SELECT&#x27;: &lt;TokenType.SELECT: &#x27;SELECT&#x27;&gt;, &#x27;SEMI&#x27;: &lt;TokenType.SEMI: &#x27;SEMI&#x27;&gt;, &#x27;SET&#x27;: &lt;TokenType.SET: &#x27;SET&#x27;&gt;, &#x27;SETTINGS&#x27;: &lt;TokenType.SETTINGS: &#x27;SETTINGS&#x27;&gt;, &#x27;SHOW&#x27;: &lt;TokenType.SHOW: &#x27;SHOW&#x27;&gt;, &#x27;SIMILAR TO&#x27;: &lt;TokenType.SIMILAR_TO: &#x27;SIMILAR_TO&#x27;&gt;, &#x27;SOME&#x27;: &lt;TokenType.SOME: &#x27;SOME&#x27;&gt;, &#x27;SORT BY&#x27;: &lt;TokenType.SORT_BY: &#x27;SORT_BY&#x27;&gt;, &#x27;START WITH&#x27;: &lt;TokenType.START_WITH: &#x27;START_WITH&#x27;&gt;, &#x27;TABLE&#x27;: &lt;TokenType.TABLE: &#x27;TABLE&#x27;&gt;, &#x27;TABLESAMPLE&#x27;: &lt;TokenType.TABLE_SAMPLE: &#x27;TABLE_SAMPLE&#x27;&gt;, &#x27;TEMP&#x27;: &lt;TokenType.TEMPORARY: &#x27;TEMPORARY&#x27;&gt;, &#x27;TEMPORARY&#x27;: &lt;TokenType.TEMPORARY: &#x27;TEMPORARY&#x27;&gt;, &#x27;THEN&#x27;: &lt;TokenType.THEN: &#x27;THEN&#x27;&gt;, &#x27;TRUE&#x27;: &lt;TokenType.TRUE: &#x27;TRUE&#x27;&gt;, &#x27;UNION&#x27;: &lt;TokenType.UNION: &#x27;UNION&#x27;&gt;, &#x27;UNKNOWN&#x27;: &lt;TokenType.UNKNOWN: &#x27;UNKNOWN&#x27;&gt;, &#x27;UNNEST&#x27;: &lt;TokenType.UNNEST: &#x27;UNNEST&#x27;&gt;, &#x27;UNPIVOT&#x27;: &lt;TokenType.UNPIVOT: &#x27;UNPIVOT&#x27;&gt;, &#x27;UPDATE&#x27;: &lt;TokenType.UPDATE: &#x27;UPDATE&#x27;&gt;, &#x27;USE&#x27;: &lt;TokenType.USE: &#x27;USE&#x27;&gt;, &#x27;USING&#x27;: &lt;TokenType.USING: &#x27;USING&#x27;&gt;, &#x27;UUID&#x27;: &lt;TokenType.UUID: &#x27;UUID&#x27;&gt;, &#x27;VALUES&#x27;: &lt;TokenType.VALUES: &#x27;VALUES&#x27;&gt;, &#x27;VIEW&#x27;: &lt;TokenType.VIEW: &#x27;VIEW&#x27;&gt;, &#x27;VOLATILE&#x27;: &lt;TokenType.VOLATILE: &#x27;VOLATILE&#x27;&gt;, &#x27;WHEN&#x27;: &lt;TokenType.WHEN: &#x27;WHEN&#x27;&gt;, &#x27;WHERE&#x27;: &lt;TokenType.WHERE: &#x27;WHERE&#x27;&gt;, &#x27;WINDOW&#x27;: &lt;TokenType.WINDOW: &#x27;WINDOW&#x27;&gt;, &#x27;WITH&#x27;: &lt;TokenType.WITH: &#x27;WITH&#x27;&gt;, &#x27;APPLY&#x27;: &lt;TokenType.APPLY: &#x27;APPLY&#x27;&gt;, &#x27;ARRAY&#x27;: &lt;TokenType.ARRAY: &#x27;ARRAY&#x27;&gt;, &#x27;BIT&#x27;: &lt;TokenType.BIT: &#x27;BIT&#x27;&gt;, &#x27;BOOL&#x27;: &lt;TokenType.BOOLEAN: &#x27;BOOLEAN&#x27;&gt;, &#x27;BOOLEAN&#x27;: &lt;TokenType.BOOLEAN: &#x27;BOOLEAN&#x27;&gt;, &#x27;BYTE&#x27;: &lt;TokenType.TINYINT: &#x27;TINYINT&#x27;&gt;, &#x27;MEDIUMINT&#x27;: &lt;TokenType.MEDIUMINT: &#x27;MEDIUMINT&#x27;&gt;, &#x27;TINYINT&#x27;: &lt;TokenType.TINYINT: &#x27;TINYINT&#x27;&gt;, &#x27;SHORT&#x27;: &lt;TokenType.SMALLINT: &#x27;SMALLINT&#x27;&gt;, &#x27;SMALLINT&#x27;: &lt;TokenType.SMALLINT: &#x27;SMALLINT&#x27;&gt;, &#x27;INT128&#x27;: &lt;TokenType.INT128: &#x27;INT128&#x27;&gt;, &#x27;INT2&#x27;: &lt;TokenType.SMALLINT: &#x27;SMALLINT&#x27;&gt;, &#x27;INTEGER&#x27;: &lt;TokenType.INT: &#x27;INT&#x27;&gt;, &#x27;INT&#x27;: &lt;TokenType.INT: &#x27;INT&#x27;&gt;, &#x27;INT4&#x27;: &lt;TokenType.INT: &#x27;INT&#x27;&gt;, &#x27;LONG&#x27;: &lt;TokenType.BIGINT: &#x27;BIGINT&#x27;&gt;, &#x27;BIGINT&#x27;: &lt;TokenType.BIGINT: &#x27;BIGINT&#x27;&gt;, &#x27;INT8&#x27;: &lt;TokenType.TINYINT: &#x27;TINYINT&#x27;&gt;, &#x27;DEC&#x27;: &lt;TokenType.DECIMAL: &#x27;DECIMAL&#x27;&gt;, &#x27;DECIMAL&#x27;: &lt;TokenType.DECIMAL: &#x27;DECIMAL&#x27;&gt;, &#x27;BIGDECIMAL&#x27;: &lt;TokenType.BIGDECIMAL: &#x27;BIGDECIMAL&#x27;&gt;, &#x27;BIGNUMERIC&#x27;: &lt;TokenType.BIGDECIMAL: &#x27;BIGDECIMAL&#x27;&gt;, &#x27;MAP&#x27;: &lt;TokenType.MAP: &#x27;MAP&#x27;&gt;, &#x27;NULLABLE&#x27;: &lt;TokenType.NULLABLE: &#x27;NULLABLE&#x27;&gt;, &#x27;NUMBER&#x27;: &lt;TokenType.DECIMAL: &#x27;DECIMAL&#x27;&gt;, &#x27;NUMERIC&#x27;: &lt;TokenType.DECIMAL: &#x27;DECIMAL&#x27;&gt;, &#x27;FIXED&#x27;: &lt;TokenType.DECIMAL: &#x27;DECIMAL&#x27;&gt;, &#x27;REAL&#x27;: &lt;TokenType.FLOAT: &#x27;FLOAT&#x27;&gt;, &#x27;FLOAT&#x27;: &lt;TokenType.FLOAT: &#x27;FLOAT&#x27;&gt;, &#x27;FLOAT4&#x27;: &lt;TokenType.FLOAT: &#x27;FLOAT&#x27;&gt;, &#x27;FLOAT8&#x27;: &lt;TokenType.DOUBLE: &#x27;DOUBLE&#x27;&gt;, &#x27;DOUBLE&#x27;: &lt;TokenType.DOUBLE: &#x27;DOUBLE&#x27;&gt;, &#x27;DOUBLE PRECISION&#x27;: &lt;TokenType.DOUBLE: &#x27;DOUBLE&#x27;&gt;, &#x27;JSON&#x27;: &lt;TokenType.JSON: &#x27;JSON&#x27;&gt;, &#x27;CHAR&#x27;: &lt;TokenType.CHAR: &#x27;CHAR&#x27;&gt;, &#x27;CHARACTER&#x27;: &lt;TokenType.CHAR: &#x27;CHAR&#x27;&gt;, &#x27;NCHAR&#x27;: &lt;TokenType.NCHAR: &#x27;NCHAR&#x27;&gt;, &#x27;VARCHAR&#x27;: &lt;TokenType.VARCHAR: &#x27;VARCHAR&#x27;&gt;, &#x27;VARCHAR2&#x27;: &lt;TokenType.VARCHAR: &#x27;VARCHAR&#x27;&gt;, &#x27;NVARCHAR&#x27;: &lt;TokenType.NVARCHAR: &#x27;NVARCHAR&#x27;&gt;, &#x27;NVARCHAR2&#x27;: &lt;TokenType.NVARCHAR: &#x27;NVARCHAR&#x27;&gt;, &#x27;STR&#x27;: &lt;TokenType.TEXT: &#x27;TEXT&#x27;&gt;, &#x27;STRING&#x27;: &lt;TokenType.TEXT: &#x27;TEXT&#x27;&gt;, &#x27;TEXT&#x27;: &lt;TokenType.TEXT: &#x27;TEXT&#x27;&gt;, &#x27;LONGTEXT&#x27;: &lt;TokenType.LONGTEXT: &#x27;LONGTEXT&#x27;&gt;, &#x27;MEDIUMTEXT&#x27;: &lt;TokenType.MEDIUMTEXT: &#x27;MEDIUMTEXT&#x27;&gt;, &#x27;TINYTEXT&#x27;: &lt;TokenType.TINYTEXT: &#x27;TINYTEXT&#x27;&gt;, &#x27;CLOB&#x27;: &lt;TokenType.TEXT: &#x27;TEXT&#x27;&gt;, &#x27;LONGVARCHAR&#x27;: &lt;TokenType.TEXT: &#x27;TEXT&#x27;&gt;, &#x27;BINARY&#x27;: &lt;TokenType.BINARY: &#x27;BINARY&#x27;&gt;, &#x27;BLOB&#x27;: &lt;TokenType.VARBINARY: &#x27;VARBINARY&#x27;&gt;, &#x27;LONGBLOB&#x27;: &lt;TokenType.LONGBLOB: &#x27;LONGBLOB&#x27;&gt;, &#x27;MEDIUMBLOB&#x27;: &lt;TokenType.MEDIUMBLOB: &#x27;MEDIUMBLOB&#x27;&gt;, &#x27;TINYBLOB&#x27;: &lt;TokenType.TINYBLOB: &#x27;TINYBLOB&#x27;&gt;, &#x27;BYTEA&#x27;: &lt;TokenType.VARBINARY: &#x27;VARBINARY&#x27;&gt;, &#x27;VARBINARY&#x27;: &lt;TokenType.VARBINARY: &#x27;VARBINARY&#x27;&gt;, &#x27;TIME&#x27;: &lt;TokenType.TIME: &#x27;TIME&#x27;&gt;, &#x27;TIMETZ&#x27;: &lt;TokenType.TIMETZ: &#x27;TIMETZ&#x27;&gt;, &#x27;TIMESTAMP&#x27;: &lt;TokenType.TIMESTAMP: &#x27;TIMESTAMP&#x27;&gt;, &#x27;TIMESTAMPTZ&#x27;: &lt;TokenType.TIMESTAMPTZ: &#x27;TIMESTAMPTZ&#x27;&gt;, &#x27;TIMESTAMPLTZ&#x27;: &lt;TokenType.TIMESTAMPLTZ: &#x27;TIMESTAMPLTZ&#x27;&gt;, &#x27;DATE&#x27;: &lt;TokenType.DATE: &#x27;DATE&#x27;&gt;, &#x27;DATETIME&#x27;: &lt;TokenType.DATETIME: &#x27;DATETIME&#x27;&gt;, &#x27;INT4RANGE&#x27;: &lt;TokenType.INT4RANGE: &#x27;INT4RANGE&#x27;&gt;, &#x27;INT4MULTIRANGE&#x27;: &lt;TokenType.INT4MULTIRANGE: &#x27;INT4MULTIRANGE&#x27;&gt;, &#x27;INT8RANGE&#x27;: &lt;TokenType.INT8RANGE: &#x27;INT8RANGE&#x27;&gt;, &#x27;INT8MULTIRANGE&#x27;: &lt;TokenType.INT8MULTIRANGE: &#x27;INT8MULTIRANGE&#x27;&gt;, &#x27;NUMRANGE&#x27;: &lt;TokenType.NUMRANGE: &#x27;NUMRANGE&#x27;&gt;, &#x27;NUMMULTIRANGE&#x27;: &lt;TokenType.NUMMULTIRANGE: &#x27;NUMMULTIRANGE&#x27;&gt;, &#x27;TSRANGE&#x27;: &lt;TokenType.TSRANGE: &#x27;TSRANGE&#x27;&gt;, &#x27;TSMULTIRANGE&#x27;: &lt;TokenType.TSMULTIRANGE: &#x27;TSMULTIRANGE&#x27;&gt;, &#x27;TSTZRANGE&#x27;: &lt;TokenType.TSTZRANGE: &#x27;TSTZRANGE&#x27;&gt;, &#x27;TSTZMULTIRANGE&#x27;: &lt;TokenType.TSTZMULTIRANGE: &#x27;TSTZMULTIRANGE&#x27;&gt;, &#x27;DATERANGE&#x27;: &lt;TokenType.DATERANGE: &#x27;DATERANGE&#x27;&gt;, &#x27;DATEMULTIRANGE&#x27;: &lt;TokenType.DATEMULTIRANGE: &#x27;DATEMULTIRANGE&#x27;&gt;, &#x27;UNIQUE&#x27;: &lt;TokenType.UNIQUE: &#x27;UNIQUE&#x27;&gt;, &#x27;STRUCT&#x27;: &lt;TokenType.STRUCT: &#x27;STRUCT&#x27;&gt;, &#x27;VARIANT&#x27;: &lt;TokenType.VARIANT: &#x27;VARIANT&#x27;&gt;, &#x27;ALTER&#x27;: &lt;TokenType.ALTER: &#x27;ALTER&#x27;&gt;, &#x27;ANALYZE&#x27;: &lt;TokenType.COMMAND: &#x27;COMMAND&#x27;&gt;, &#x27;CALL&#x27;: &lt;TokenType.COMMAND: &#x27;COMMAND&#x27;&gt;, &#x27;COMMENT&#x27;: &lt;TokenType.COMMENT: &#x27;COMMENT&#x27;&gt;, &#x27;COPY&#x27;: &lt;TokenType.COMMAND: &#x27;COMMAND&#x27;&gt;, &#x27;EXPLAIN&#x27;: &lt;TokenType.COMMAND: &#x27;COMMAND&#x27;&gt;, &#x27;GRANT&#x27;: &lt;TokenType.COMMAND: &#x27;COMMAND&#x27;&gt;, &#x27;OPTIMIZE&#x27;: &lt;TokenType.COMMAND: &#x27;COMMAND&#x27;&gt;, &#x27;PREPARE&#x27;: &lt;TokenType.COMMAND: &#x27;COMMAND&#x27;&gt;, &#x27;TRUNCATE&#x27;: &lt;TokenType.COMMAND: &#x27;COMMAND&#x27;&gt;, &#x27;VACUUM&#x27;: &lt;TokenType.COMMAND: &#x27;COMMAND&#x27;&gt;, &#x27;USER-DEFINED&#x27;: &lt;TokenType.USERDEFINED: &#x27;USERDEFINED&#x27;&gt;, &#x27;FOR VERSION&#x27;: &lt;TokenType.VERSION_SNAPSHOT: &#x27;VERSION_SNAPSHOT&#x27;&gt;, &#x27;FOR TIMESTAMP&#x27;: &lt;TokenType.TIMESTAMP_SNAPSHOT: &#x27;TIMESTAMP_SNAPSHOT&#x27;&gt;, &#x27;ATTACH&#x27;: &lt;TokenType.COMMAND: &#x27;COMMAND&#x27;&gt;, &#x27;DATETIME64&#x27;: &lt;TokenType.DATETIME64: &#x27;DATETIME64&#x27;&gt;, &#x27;DICTIONARY&#x27;: &lt;TokenType.DICTIONARY: &#x27;DICTIONARY&#x27;&gt;, &#x27;ENUM&#x27;: &lt;TokenType.ENUM: &#x27;ENUM&#x27;&gt;, &#x27;ENUM8&#x27;: &lt;TokenType.ENUM8: &#x27;ENUM8&#x27;&gt;, &#x27;ENUM16&#x27;: &lt;TokenType.ENUM16: &#x27;ENUM16&#x27;&gt;, &#x27;FINAL&#x27;: &lt;TokenType.FINAL: &#x27;FINAL&#x27;&gt;, &#x27;FIXEDSTRING&#x27;: &lt;TokenType.FIXEDSTRING: &#x27;FIXEDSTRING&#x27;&gt;, &#x27;FLOAT32&#x27;: &lt;TokenType.FLOAT: &#x27;FLOAT&#x27;&gt;, &#x27;FLOAT64&#x27;: &lt;TokenType.DOUBLE: &#x27;DOUBLE&#x27;&gt;, &#x27;GLOBAL&#x27;: &lt;TokenType.GLOBAL: &#x27;GLOBAL&#x27;&gt;, &#x27;INT16&#x27;: &lt;TokenType.SMALLINT: &#x27;SMALLINT&#x27;&gt;, &#x27;INT256&#x27;: &lt;TokenType.INT256: &#x27;INT256&#x27;&gt;, &#x27;INT32&#x27;: &lt;TokenType.INT: &#x27;INT&#x27;&gt;, &#x27;INT64&#x27;: &lt;TokenType.BIGINT: &#x27;BIGINT&#x27;&gt;, &#x27;LOWCARDINALITY&#x27;: &lt;TokenType.LOWCARDINALITY: &#x27;LOWCARDINALITY&#x27;&gt;, &#x27;NESTED&#x27;: &lt;TokenType.NESTED: &#x27;NESTED&#x27;&gt;, &#x27;SAMPLE&#x27;: &lt;TokenType.TABLE_SAMPLE: &#x27;TABLE_SAMPLE&#x27;&gt;, &#x27;TUPLE&#x27;: &lt;TokenType.STRUCT: &#x27;STRUCT&#x27;&gt;, &#x27;UINT128&#x27;: &lt;TokenType.UINT128: &#x27;UINT128&#x27;&gt;, &#x27;UINT16&#x27;: &lt;TokenType.USMALLINT: &#x27;USMALLINT&#x27;&gt;, &#x27;UINT256&#x27;: &lt;TokenType.UINT256: &#x27;UINT256&#x27;&gt;, &#x27;UINT32&#x27;: &lt;TokenType.UINT: &#x27;UINT&#x27;&gt;, &#x27;UINT64&#x27;: &lt;TokenType.UBIGINT: &#x27;UBIGINT&#x27;&gt;, &#x27;UINT8&#x27;: &lt;TokenType.UTINYINT: &#x27;UTINYINT&#x27;&gt;}"}, "sqlglot.dialects.clickhouse.ClickHouse.Tokenizer.SINGLE_TOKENS": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Tokenizer.SINGLE_TOKENS", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Tokenizer.SINGLE_TOKENS", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;(&#x27;: &lt;TokenType.L_PAREN: &#x27;L_PAREN&#x27;&gt;, &#x27;)&#x27;: &lt;TokenType.R_PAREN: &#x27;R_PAREN&#x27;&gt;, &#x27;[&#x27;: &lt;TokenType.L_BRACKET: &#x27;L_BRACKET&#x27;&gt;, &#x27;]&#x27;: &lt;TokenType.R_BRACKET: &#x27;R_BRACKET&#x27;&gt;, &#x27;{&#x27;: &lt;TokenType.L_BRACE: &#x27;L_BRACE&#x27;&gt;, &#x27;}&#x27;: &lt;TokenType.R_BRACE: &#x27;R_BRACE&#x27;&gt;, &#x27;&amp;&#x27;: &lt;TokenType.AMP: &#x27;AMP&#x27;&gt;, &#x27;^&#x27;: &lt;TokenType.CARET: &#x27;CARET&#x27;&gt;, &#x27;:&#x27;: &lt;TokenType.COLON: &#x27;COLON&#x27;&gt;, &#x27;,&#x27;: &lt;TokenType.COMMA: &#x27;COMMA&#x27;&gt;, &#x27;.&#x27;: &lt;TokenType.DOT: &#x27;DOT&#x27;&gt;, &#x27;-&#x27;: &lt;TokenType.DASH: &#x27;DASH&#x27;&gt;, &#x27;=&#x27;: &lt;TokenType.EQ: &#x27;EQ&#x27;&gt;, &#x27;&gt;&#x27;: &lt;TokenType.GT: &#x27;GT&#x27;&gt;, &#x27;&lt;&#x27;: &lt;TokenType.LT: &#x27;LT&#x27;&gt;, &#x27;%&#x27;: &lt;TokenType.MOD: &#x27;MOD&#x27;&gt;, &#x27;!&#x27;: &lt;TokenType.NOT: &#x27;NOT&#x27;&gt;, &#x27;|&#x27;: &lt;TokenType.PIPE: &#x27;PIPE&#x27;&gt;, &#x27;+&#x27;: &lt;TokenType.PLUS: &#x27;PLUS&#x27;&gt;, &#x27;;&#x27;: &lt;TokenType.SEMICOLON: &#x27;SEMICOLON&#x27;&gt;, &#x27;/&#x27;: &lt;TokenType.SLASH: &#x27;SLASH&#x27;&gt;, &#x27;\\\\&#x27;: &lt;TokenType.BACKSLASH: &#x27;BACKSLASH&#x27;&gt;, &#x27;*&#x27;: &lt;TokenType.STAR: &#x27;STAR&#x27;&gt;, &#x27;~&#x27;: &lt;TokenType.TILDA: &#x27;TILDA&#x27;&gt;, &#x27;?&#x27;: &lt;TokenType.PLACEHOLDER: &#x27;PLACEHOLDER&#x27;&gt;, &#x27;@&#x27;: &lt;TokenType.PARAMETER: &#x27;PARAMETER&#x27;&gt;, &quot;&#x27;&quot;: &lt;TokenType.QUOTE: &#x27;QUOTE&#x27;&gt;, &#x27;`&#x27;: &lt;TokenType.IDENTIFIER: &#x27;IDENTIFIER&#x27;&gt;, &#x27;&quot;&#x27;: &lt;TokenType.IDENTIFIER: &#x27;IDENTIFIER&#x27;&gt;, &#x27;#&#x27;: &lt;TokenType.HASH: &#x27;HASH&#x27;&gt;, &#x27;$&#x27;: &lt;TokenType.HEREDOC_STRING: &#x27;HEREDOC_STRING&#x27;&gt;}"}, "sqlglot.dialects.clickhouse.ClickHouse.Tokenizer.ESCAPE_SEQUENCES": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Tokenizer.ESCAPE_SEQUENCES", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Tokenizer.ESCAPE_SEQUENCES", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict[str, str]", "default_value": "{&#x27;\\\\0&#x27;: &#x27;\\x00&#x27;}"}, "sqlglot.dialects.clickhouse.ClickHouse.Parser": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Parser", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Parser", "kind": "class", "doc": "<p>Parser consumes a list of tokens produced by the Tokenizer and produces a parsed syntax tree.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>error_level:</strong>  The desired error level.\nDefault: ErrorLevel.IMMEDIATE</li>\n<li><strong>error_message_context:</strong>  Determines the amount of context to capture from a\nquery string when displaying the error message (in number of characters).\nDefault: 100</li>\n<li><strong>max_errors:</strong>  Maximum number of error messages to include in a raised ParseError.\nThis is only relevant if error_level is ErrorLevel.RAISE.\nDefault: 3</li>\n</ul>\n", "bases": "sqlglot.parser.Parser"}, "sqlglot.dialects.clickhouse.ClickHouse.Parser.FUNCTIONS": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Parser.FUNCTIONS", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Parser.FUNCTIONS", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;ABS&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Abs&#x27;&gt;&gt;, &#x27;ANY_VALUE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.AnyValue&#x27;&gt;&gt;, &#x27;APPROX_DISTINCT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ApproxDistinct&#x27;&gt;&gt;, &#x27;APPROX_COUNT_DISTINCT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ApproxDistinct&#x27;&gt;&gt;, &#x27;APPROX_QUANTILE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ApproxQuantile&#x27;&gt;&gt;, &#x27;ARRAY&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Array&#x27;&gt;&gt;, &#x27;ARRAY_AGG&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArrayAgg&#x27;&gt;&gt;, &#x27;ARRAY_ALL&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArrayAll&#x27;&gt;&gt;, &#x27;ARRAY_ANY&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArrayAny&#x27;&gt;&gt;, &#x27;ARRAY_CONCAT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArrayConcat&#x27;&gt;&gt;, &#x27;ARRAY_CAT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArrayConcat&#x27;&gt;&gt;, &#x27;ARRAY_CONTAINS&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArrayContains&#x27;&gt;&gt;, &#x27;FILTER&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArrayFilter&#x27;&gt;&gt;, &#x27;ARRAY_FILTER&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArrayFilter&#x27;&gt;&gt;, &#x27;ARRAY_JOIN&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArrayJoin&#x27;&gt;&gt;, &#x27;ARRAY_SIZE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArraySize&#x27;&gt;&gt;, &#x27;ARRAY_SORT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArraySort&#x27;&gt;&gt;, &#x27;ARRAY_SUM&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArraySum&#x27;&gt;&gt;, &#x27;ARRAY_UNION_AGG&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArrayUnionAgg&#x27;&gt;&gt;, &#x27;AVG&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Avg&#x27;&gt;&gt;, &#x27;CASE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Case&#x27;&gt;&gt;, &#x27;CAST&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Cast&#x27;&gt;&gt;, &#x27;CAST_TO_STR_TYPE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.CastToStrType&#x27;&gt;&gt;, &#x27;CEIL&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Ceil&#x27;&gt;&gt;, &#x27;CEILING&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Ceil&#x27;&gt;&gt;, &#x27;CHR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Chr&#x27;&gt;&gt;, &#x27;CHAR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Chr&#x27;&gt;&gt;, &#x27;COALESCE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Coalesce&#x27;&gt;&gt;, &#x27;IFNULL&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Coalesce&#x27;&gt;&gt;, &#x27;NVL&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Coalesce&#x27;&gt;&gt;, &#x27;COLLATE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Collate&#x27;&gt;&gt;, &#x27;CONCAT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Concat&#x27;&gt;&gt;, &#x27;CONCAT_WS&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ConcatWs&#x27;&gt;&gt;, &#x27;COUNT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Count&#x27;&gt;&gt;, &#x27;COUNT_IF&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.CountIf&#x27;&gt;&gt;, &#x27;CURRENT_DATE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.CurrentDate&#x27;&gt;&gt;, &#x27;CURRENT_DATETIME&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.CurrentDatetime&#x27;&gt;&gt;, &#x27;CURRENT_TIME&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.CurrentTime&#x27;&gt;&gt;, &#x27;CURRENT_TIMESTAMP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.CurrentTimestamp&#x27;&gt;&gt;, &#x27;CURRENT_USER&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.CurrentUser&#x27;&gt;&gt;, &#x27;DATE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Date&#x27;&gt;&gt;, &#x27;DATE_ADD&#x27;: &lt;function ClickHouse.Parser.&lt;lambda&gt;&gt;, &#x27;DATEDIFF&#x27;: &lt;function ClickHouse.Parser.&lt;lambda&gt;&gt;, &#x27;DATE_DIFF&#x27;: &lt;function ClickHouse.Parser.&lt;lambda&gt;&gt;, &#x27;DATEFROMPARTS&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DateFromParts&#x27;&gt;&gt;, &#x27;DATE_STR_TO_DATE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DateStrToDate&#x27;&gt;&gt;, &#x27;DATE_SUB&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DateSub&#x27;&gt;&gt;, &#x27;DATE_TO_DATE_STR&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;DATE_TO_DI&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DateToDi&#x27;&gt;&gt;, &#x27;DATE_TRUNC&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DateTrunc&#x27;&gt;&gt;, &#x27;DATETIME_ADD&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DatetimeAdd&#x27;&gt;&gt;, &#x27;DATETIME_DIFF&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DatetimeDiff&#x27;&gt;&gt;, &#x27;DATETIME_SUB&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DatetimeSub&#x27;&gt;&gt;, &#x27;DATETIME_TRUNC&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DatetimeTrunc&#x27;&gt;&gt;, &#x27;DAY&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Day&#x27;&gt;&gt;, &#x27;DAY_OF_MONTH&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DayOfMonth&#x27;&gt;&gt;, &#x27;DAYOFMONTH&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DayOfMonth&#x27;&gt;&gt;, &#x27;DAY_OF_WEEK&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DayOfWeek&#x27;&gt;&gt;, &#x27;DAYOFWEEK&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DayOfWeek&#x27;&gt;&gt;, &#x27;DAY_OF_YEAR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DayOfYear&#x27;&gt;&gt;, &#x27;DAYOFYEAR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DayOfYear&#x27;&gt;&gt;, &#x27;DECODE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Decode&#x27;&gt;&gt;, &#x27;DI_TO_DATE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DiToDate&#x27;&gt;&gt;, &#x27;ENCODE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Encode&#x27;&gt;&gt;, &#x27;EXP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Exp&#x27;&gt;&gt;, &#x27;EXPLODE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Explode&#x27;&gt;&gt;, &#x27;EXPLODE_OUTER&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ExplodeOuter&#x27;&gt;&gt;, &#x27;EXTRACT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Extract&#x27;&gt;&gt;, &#x27;FIRST&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.First&#x27;&gt;&gt;, &#x27;FLATTEN&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Flatten&#x27;&gt;&gt;, &#x27;FLOOR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Floor&#x27;&gt;&gt;, &#x27;FROM_BASE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.FromBase&#x27;&gt;&gt;, &#x27;FROM_BASE64&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.FromBase64&#x27;&gt;&gt;, &#x27;GENERATE_SERIES&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.GenerateSeries&#x27;&gt;&gt;, &#x27;GREATEST&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Greatest&#x27;&gt;&gt;, &#x27;GROUP_CONCAT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.GroupConcat&#x27;&gt;&gt;, &#x27;HEX&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Hex&#x27;&gt;&gt;, &#x27;HLL&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Hll&#x27;&gt;&gt;, &#x27;IF&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.If&#x27;&gt;&gt;, &#x27;INITCAP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Initcap&#x27;&gt;&gt;, &#x27;IS_NAN&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.IsNan&#x27;&gt;&gt;, &#x27;ISNAN&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.IsNan&#x27;&gt;&gt;, &#x27;J_S_O_N_ARRAY&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.JSONArray&#x27;&gt;&gt;, &#x27;J_S_O_N_ARRAY_AGG&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.JSONArrayAgg&#x27;&gt;&gt;, &#x27;JSON_ARRAY_CONTAINS&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.JSONArrayContains&#x27;&gt;&gt;, &#x27;JSONB_EXTRACT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.JSONBExtract&#x27;&gt;&gt;, &#x27;JSONB_EXTRACT_SCALAR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.JSONBExtractScalar&#x27;&gt;&gt;, &#x27;JSON_EXTRACT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.JSONExtract&#x27;&gt;&gt;, &#x27;JSON_EXTRACT_SCALAR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.JSONExtractScalar&#x27;&gt;&gt;, &#x27;JSON_FORMAT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.JSONFormat&#x27;&gt;&gt;, &#x27;J_S_O_N_OBJECT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.JSONObject&#x27;&gt;&gt;, &#x27;J_S_O_N_TABLE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.JSONTable&#x27;&gt;&gt;, &#x27;LAST&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Last&#x27;&gt;&gt;, &#x27;LAST_DATE_OF_MONTH&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.LastDateOfMonth&#x27;&gt;&gt;, &#x27;LEAST&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Least&#x27;&gt;&gt;, &#x27;LEFT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Left&#x27;&gt;&gt;, &#x27;LENGTH&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Length&#x27;&gt;&gt;, &#x27;LEN&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Length&#x27;&gt;&gt;, &#x27;LEVENSHTEIN&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Levenshtein&#x27;&gt;&gt;, &#x27;LN&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Ln&#x27;&gt;&gt;, &#x27;LOG&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Log&#x27;&gt;&gt;, &#x27;LOG10&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Log10&#x27;&gt;&gt;, &#x27;LOG2&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Log2&#x27;&gt;&gt;, &#x27;LOGICAL_AND&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.LogicalAnd&#x27;&gt;&gt;, &#x27;BOOL_AND&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.LogicalAnd&#x27;&gt;&gt;, &#x27;BOOLAND_AGG&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.LogicalAnd&#x27;&gt;&gt;, &#x27;LOGICAL_OR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.LogicalOr&#x27;&gt;&gt;, &#x27;BOOL_OR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.LogicalOr&#x27;&gt;&gt;, &#x27;BOOLOR_AGG&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.LogicalOr&#x27;&gt;&gt;, &#x27;LOWER&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Lower&#x27;&gt;&gt;, &#x27;LCASE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Lower&#x27;&gt;&gt;, &#x27;MD5&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.MD5&#x27;&gt;&gt;, &#x27;MD5_DIGEST&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.MD5Digest&#x27;&gt;&gt;, &#x27;MAP&#x27;: &lt;function parse_var_map&gt;, &#x27;MAP_FROM_ENTRIES&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.MapFromEntries&#x27;&gt;&gt;, &#x27;MATCH_AGAINST&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.MatchAgainst&#x27;&gt;&gt;, &#x27;MAX&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Max&#x27;&gt;&gt;, &#x27;MIN&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Min&#x27;&gt;&gt;, &#x27;MONTH&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Month&#x27;&gt;&gt;, &#x27;MONTHS_BETWEEN&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.MonthsBetween&#x27;&gt;&gt;, &#x27;NEXT_VALUE_FOR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.NextValueFor&#x27;&gt;&gt;, &#x27;NUMBER_TO_STR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.NumberToStr&#x27;&gt;&gt;, &#x27;NVL2&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Nvl2&#x27;&gt;&gt;, &#x27;OPEN_J_S_O_N&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.OpenJSON&#x27;&gt;&gt;, &#x27;PARAMETERIZED_AGG&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ParameterizedAgg&#x27;&gt;&gt;, &#x27;PARSE_JSON&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ParseJSON&#x27;&gt;&gt;, &#x27;JSON_PARSE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ParseJSON&#x27;&gt;&gt;, &#x27;PERCENTILE_CONT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.PercentileCont&#x27;&gt;&gt;, &#x27;PERCENTILE_DISC&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.PercentileDisc&#x27;&gt;&gt;, &#x27;POSEXPLODE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Posexplode&#x27;&gt;&gt;, &#x27;POSEXPLODE_OUTER&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.PosexplodeOuter&#x27;&gt;&gt;, &#x27;POWER&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Pow&#x27;&gt;&gt;, &#x27;POW&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Pow&#x27;&gt;&gt;, &#x27;PREDICT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Predict&#x27;&gt;&gt;, &#x27;QUANTILE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Quantile&#x27;&gt;&gt;, &#x27;RANGE_N&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.RangeN&#x27;&gt;&gt;, &#x27;READ_CSV&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ReadCSV&#x27;&gt;&gt;, &#x27;REDUCE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Reduce&#x27;&gt;&gt;, &#x27;REGEXP_EXTRACT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.RegexpExtract&#x27;&gt;&gt;, &#x27;REGEXP_I_LIKE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.RegexpILike&#x27;&gt;&gt;, &#x27;REGEXP_LIKE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.RegexpLike&#x27;&gt;&gt;, &#x27;REGEXP_REPLACE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.RegexpReplace&#x27;&gt;&gt;, &#x27;REGEXP_SPLIT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.RegexpSplit&#x27;&gt;&gt;, &#x27;REPEAT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Repeat&#x27;&gt;&gt;, &#x27;RIGHT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Right&#x27;&gt;&gt;, &#x27;ROUND&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Round&#x27;&gt;&gt;, &#x27;ROW_NUMBER&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.RowNumber&#x27;&gt;&gt;, &#x27;SHA&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.SHA&#x27;&gt;&gt;, &#x27;SHA1&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.SHA&#x27;&gt;&gt;, &#x27;SHA2&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.SHA2&#x27;&gt;&gt;, &#x27;SAFE_CONCAT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.SafeConcat&#x27;&gt;&gt;, &#x27;SAFE_DIVIDE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.SafeDivide&#x27;&gt;&gt;, &#x27;SET_AGG&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.SetAgg&#x27;&gt;&gt;, &#x27;SORT_ARRAY&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.SortArray&#x27;&gt;&gt;, &#x27;SPLIT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Split&#x27;&gt;&gt;, &#x27;SQRT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Sqrt&#x27;&gt;&gt;, &#x27;STANDARD_HASH&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StandardHash&#x27;&gt;&gt;, &#x27;STAR_MAP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StarMap&#x27;&gt;&gt;, &#x27;STARTS_WITH&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StartsWith&#x27;&gt;&gt;, &#x27;STARTSWITH&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StartsWith&#x27;&gt;&gt;, &#x27;STDDEV&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Stddev&#x27;&gt;&gt;, &#x27;STDDEV_POP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StddevPop&#x27;&gt;&gt;, &#x27;STDDEV_SAMP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StddevSamp&#x27;&gt;&gt;, &#x27;STR_POSITION&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StrPosition&#x27;&gt;&gt;, &#x27;STR_TO_DATE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StrToDate&#x27;&gt;&gt;, &#x27;STR_TO_MAP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StrToMap&#x27;&gt;&gt;, &#x27;STR_TO_TIME&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StrToTime&#x27;&gt;&gt;, &#x27;STR_TO_UNIX&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StrToUnix&#x27;&gt;&gt;, &#x27;STRUCT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Struct&#x27;&gt;&gt;, &#x27;STRUCT_EXTRACT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StructExtract&#x27;&gt;&gt;, &#x27;STUFF&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Stuff&#x27;&gt;&gt;, &#x27;INSERT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Stuff&#x27;&gt;&gt;, &#x27;SUBSTRING&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Substring&#x27;&gt;&gt;, &#x27;SUM&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Sum&#x27;&gt;&gt;, &#x27;TIME_ADD&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimeAdd&#x27;&gt;&gt;, &#x27;TIME_DIFF&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimeDiff&#x27;&gt;&gt;, &#x27;TIME_STR_TO_DATE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimeStrToDate&#x27;&gt;&gt;, &#x27;TIME_STR_TO_TIME&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimeStrToTime&#x27;&gt;&gt;, &#x27;TIME_STR_TO_UNIX&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimeStrToUnix&#x27;&gt;&gt;, &#x27;TIME_SUB&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimeSub&#x27;&gt;&gt;, &#x27;TIME_TO_STR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimeToStr&#x27;&gt;&gt;, &#x27;TIME_TO_TIME_STR&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;TIME_TO_UNIX&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimeToUnix&#x27;&gt;&gt;, &#x27;TIME_TRUNC&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimeTrunc&#x27;&gt;&gt;, &#x27;TIMESTAMP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Timestamp&#x27;&gt;&gt;, &#x27;TIMESTAMP_ADD&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimestampAdd&#x27;&gt;&gt;, &#x27;TIMESTAMP_DIFF&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimestampDiff&#x27;&gt;&gt;, &#x27;TIMESTAMP_SUB&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimestampSub&#x27;&gt;&gt;, &#x27;TIMESTAMP_TRUNC&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimestampTrunc&#x27;&gt;&gt;, &#x27;TO_BASE64&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ToBase64&#x27;&gt;&gt;, &#x27;TO_CHAR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ToChar&#x27;&gt;&gt;, &#x27;TO_DAYS&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ToDays&#x27;&gt;&gt;, &#x27;TRANSFORM&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Transform&#x27;&gt;&gt;, &#x27;TRIM&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Trim&#x27;&gt;&gt;, &#x27;TRY_CAST&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TryCast&#x27;&gt;&gt;, &#x27;TS_OR_DI_TO_DI&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TsOrDiToDi&#x27;&gt;&gt;, &#x27;TS_OR_DS_ADD&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TsOrDsAdd&#x27;&gt;&gt;, &#x27;TS_OR_DS_TO_DATE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TsOrDsToDate&#x27;&gt;&gt;, &#x27;TS_OR_DS_TO_DATE_STR&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;UNHEX&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Unhex&#x27;&gt;&gt;, &#x27;UNIX_TO_STR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.UnixToStr&#x27;&gt;&gt;, &#x27;UNIX_TO_TIME&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.UnixToTime&#x27;&gt;&gt;, &#x27;UNIX_TO_TIME_STR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.UnixToTimeStr&#x27;&gt;&gt;, &#x27;UPPER&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Upper&#x27;&gt;&gt;, &#x27;UCASE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Upper&#x27;&gt;&gt;, &#x27;VAR_MAP&#x27;: &lt;function parse_var_map&gt;, &#x27;VARIANCE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Variance&#x27;&gt;&gt;, &#x27;VARIANCE_SAMP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Variance&#x27;&gt;&gt;, &#x27;VAR_SAMP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Variance&#x27;&gt;&gt;, &#x27;VARIANCE_POP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.VariancePop&#x27;&gt;&gt;, &#x27;VAR_POP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.VariancePop&#x27;&gt;&gt;, &#x27;WEEK&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Week&#x27;&gt;&gt;, &#x27;WEEK_OF_YEAR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.WeekOfYear&#x27;&gt;&gt;, &#x27;WEEKOFYEAR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.WeekOfYear&#x27;&gt;&gt;, &#x27;WHEN&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.When&#x27;&gt;&gt;, &#x27;X_M_L_TABLE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.XMLTable&#x27;&gt;&gt;, &#x27;XOR&#x27;: &lt;function ClickHouse.Parser.&lt;lambda&gt;&gt;, &#x27;YEAR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Year&#x27;&gt;&gt;, &#x27;GLOB&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;LIKE&#x27;: &lt;function parse_like&gt;, &#x27;ANY&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.AnyValue&#x27;&gt;&gt;, &#x27;DATEADD&#x27;: &lt;function ClickHouse.Parser.&lt;lambda&gt;&gt;, &#x27;MATCH&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.RegexpLike&#x27;&gt;&gt;, &#x27;UNIQ&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ApproxDistinct&#x27;&gt;&gt;}"}, "sqlglot.dialects.clickhouse.ClickHouse.Parser.FUNCTIONS_WITH_ALIASED_ARGS": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Parser.FUNCTIONS_WITH_ALIASED_ARGS", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Parser.FUNCTIONS_WITH_ALIASED_ARGS", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;STRUCT&#x27;, &#x27;TUPLE&#x27;}"}, "sqlglot.dialects.clickhouse.ClickHouse.Parser.FUNCTION_PARSERS": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Parser.FUNCTION_PARSERS", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Parser.FUNCTION_PARSERS", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;ANY_VALUE&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;CAST&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;CONCAT&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;CONCAT_WS&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;CONVERT&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;DECODE&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;EXTRACT&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;JSON_OBJECT&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;JSON_TABLE&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;LOG&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;OPENJSON&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;POSITION&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;PREDICT&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;SAFE_CAST&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;STRING_AGG&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;SUBSTRING&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;TRIM&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;TRY_CAST&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;TRY_CONVERT&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;QUANTILE&#x27;: &lt;function ClickHouse.Parser.&lt;lambda&gt;&gt;}"}, "sqlglot.dialects.clickhouse.ClickHouse.Parser.NO_PAREN_FUNCTION_PARSERS": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Parser.NO_PAREN_FUNCTION_PARSERS", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Parser.NO_PAREN_FUNCTION_PARSERS", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;CASE&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;IF&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;NEXT&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;}"}, "sqlglot.dialects.clickhouse.ClickHouse.Parser.RANGE_PARSERS": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Parser.RANGE_PARSERS", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Parser.RANGE_PARSERS", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&lt;TokenType.BETWEEN: &#x27;BETWEEN&#x27;&gt;: &lt;function Parser.&lt;lambda&gt;&gt;, &lt;TokenType.GLOB: &#x27;GLOB&#x27;&gt;: &lt;function binary_range_parser.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;TokenType.ILIKE: &#x27;ILIKE&#x27;&gt;: &lt;function binary_range_parser.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;TokenType.IN: &#x27;IN&#x27;&gt;: &lt;function Parser.&lt;lambda&gt;&gt;, &lt;TokenType.IRLIKE: &#x27;IRLIKE&#x27;&gt;: &lt;function binary_range_parser.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;TokenType.IS: &#x27;IS&#x27;&gt;: &lt;function Parser.&lt;lambda&gt;&gt;, &lt;TokenType.LIKE: &#x27;LIKE&#x27;&gt;: &lt;function binary_range_parser.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;TokenType.OVERLAPS: &#x27;OVERLAPS&#x27;&gt;: &lt;function binary_range_parser.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;TokenType.RLIKE: &#x27;RLIKE&#x27;&gt;: &lt;function binary_range_parser.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;TokenType.SIMILAR_TO: &#x27;SIMILAR_TO&#x27;&gt;: &lt;function binary_range_parser.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;TokenType.FOR: &#x27;FOR&#x27;&gt;: &lt;function Parser.&lt;lambda&gt;&gt;, &lt;TokenType.GLOBAL: &#x27;GLOBAL&#x27;&gt;: &lt;function ClickHouse.Parser.&lt;lambda&gt;&gt;}"}, "sqlglot.dialects.clickhouse.ClickHouse.Parser.COLUMN_OPERATORS": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Parser.COLUMN_OPERATORS", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Parser.COLUMN_OPERATORS", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&lt;TokenType.DOT: &#x27;DOT&#x27;&gt;: None, &lt;TokenType.DCOLON: &#x27;DCOLON&#x27;&gt;: &lt;function Parser.&lt;lambda&gt;&gt;, &lt;TokenType.ARROW: &#x27;ARROW&#x27;&gt;: &lt;function Parser.&lt;lambda&gt;&gt;, &lt;TokenType.DARROW: &#x27;DARROW&#x27;&gt;: &lt;function Parser.&lt;lambda&gt;&gt;, &lt;TokenType.HASH_ARROW: &#x27;HASH_ARROW&#x27;&gt;: &lt;function Parser.&lt;lambda&gt;&gt;, &lt;TokenType.DHASH_ARROW: &#x27;DHASH_ARROW&#x27;&gt;: &lt;function Parser.&lt;lambda&gt;&gt;}"}, "sqlglot.dialects.clickhouse.ClickHouse.Parser.JOIN_KINDS": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Parser.JOIN_KINDS", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Parser.JOIN_KINDS", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&lt;TokenType.ARRAY: &#x27;ARRAY&#x27;&gt;, &lt;TokenType.ANTI: &#x27;ANTI&#x27;&gt;, &lt;TokenType.ANY: &#x27;ANY&#x27;&gt;, &lt;TokenType.SEMI: &#x27;SEMI&#x27;&gt;, &lt;TokenType.CROSS: &#x27;CROSS&#x27;&gt;, &lt;TokenType.INNER: &#x27;INNER&#x27;&gt;, &lt;TokenType.ASOF: &#x27;ASOF&#x27;&gt;, &lt;TokenType.OUTER: &#x27;OUTER&#x27;&gt;}"}, "sqlglot.dialects.clickhouse.ClickHouse.Parser.TABLE_ALIAS_TOKENS": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Parser.TABLE_ALIAS_TOKENS", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Parser.TABLE_ALIAS_TOKENS", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&lt;TokenType.DATEMULTIRANGE: &#x27;DATEMULTIRANGE&#x27;&gt;, &lt;TokenType.PERCENT: &#x27;PERCENT&#x27;&gt;, &lt;TokenType.UMEDIUMINT: &#x27;UMEDIUMINT&#x27;&gt;, &lt;TokenType.DOUBLE: &#x27;DOUBLE&#x27;&gt;, &lt;TokenType.PIVOT: &#x27;PIVOT&#x27;&gt;, &lt;TokenType.TRUE: &#x27;TRUE&#x27;&gt;, &lt;TokenType.TEXT: &#x27;TEXT&#x27;&gt;, &lt;TokenType.EXECUTE: &#x27;EXECUTE&#x27;&gt;, &lt;TokenType.DESC: &#x27;DESC&#x27;&gt;, &lt;TokenType.CACHE: &#x27;CACHE&#x27;&gt;, &lt;TokenType.FUNCTION: &#x27;FUNCTION&#x27;&gt;, &lt;TokenType.DATE: &#x27;DATE&#x27;&gt;, &lt;TokenType.BIT: &#x27;BIT&#x27;&gt;, &lt;TokenType.TINYTEXT: &#x27;TINYTEXT&#x27;&gt;, &lt;TokenType.ROWVERSION: &#x27;ROWVERSION&#x27;&gt;, &lt;TokenType.CURRENT_USER: &#x27;CURRENT_USER&#x27;&gt;, &lt;TokenType.GEOGRAPHY: &#x27;GEOGRAPHY&#x27;&gt;, &lt;TokenType.BIGDECIMAL: &#x27;BIGDECIMAL&#x27;&gt;, &lt;TokenType.INT4MULTIRANGE: &#x27;INT4MULTIRANGE&#x27;&gt;, &lt;TokenType.CASE: &#x27;CASE&#x27;&gt;, &lt;TokenType.EXISTS: &#x27;EXISTS&#x27;&gt;, &lt;TokenType.INDEX: &#x27;INDEX&#x27;&gt;, &lt;TokenType.UUID: &#x27;UUID&#x27;&gt;, &lt;TokenType.LOWCARDINALITY: &#x27;LOWCARDINALITY&#x27;&gt;, &lt;TokenType.UNKNOWN: &#x27;UNKNOWN&#x27;&gt;, &lt;TokenType.MEDIUMINT: &#x27;MEDIUMINT&#x27;&gt;, &lt;TokenType.CURRENT_DATETIME: &#x27;CURRENT_DATETIME&#x27;&gt;, &lt;TokenType.VOLATILE: &#x27;VOLATILE&#x27;&gt;, &lt;TokenType.ALL: &#x27;ALL&#x27;&gt;, &lt;TokenType.TINYBLOB: &#x27;TINYBLOB&#x27;&gt;, &lt;TokenType.TSMULTIRANGE: &#x27;TSMULTIRANGE&#x27;&gt;, &lt;TokenType.TIMETZ: &#x27;TIMETZ&#x27;&gt;, &lt;TokenType.ENUM16: &#x27;ENUM16&#x27;&gt;, &lt;TokenType.SHOW: &#x27;SHOW&#x27;&gt;, &lt;TokenType.OVERLAPS: &#x27;OVERLAPS&#x27;&gt;, &lt;TokenType.SMALLSERIAL: &#x27;SMALLSERIAL&#x27;&gt;, &lt;TokenType.COLLATE: &#x27;COLLATE&#x27;&gt;, &lt;TokenType.COMMENT: &#x27;COMMENT&#x27;&gt;, &lt;TokenType.FILTER: &#x27;FILTER&#x27;&gt;, &lt;TokenType.HLLSKETCH: &#x27;HLLSKETCH&#x27;&gt;, &lt;TokenType.ROWS: &#x27;ROWS&#x27;&gt;, &lt;TokenType.VARCHAR: &#x27;VARCHAR&#x27;&gt;, &lt;TokenType.UPDATE: &#x27;UPDATE&#x27;&gt;, &lt;TokenType.DICTIONARY: &#x27;DICTIONARY&#x27;&gt;, &lt;TokenType.TABLE: &#x27;TABLE&#x27;&gt;, &lt;TokenType.USERDEFINED: &#x27;USERDEFINED&#x27;&gt;, &lt;TokenType.DIV: &#x27;DIV&#x27;&gt;, &lt;TokenType.UNPIVOT: &#x27;UNPIVOT&#x27;&gt;, &lt;TokenType.FIXEDSTRING: &#x27;FIXEDSTRING&#x27;&gt;, &lt;TokenType.VARIANT: &#x27;VARIANT&#x27;&gt;, &lt;TokenType.BIGINT: &#x27;BIGINT&#x27;&gt;, &lt;TokenType.PARTITION: &#x27;PARTITION&#x27;&gt;, &lt;TokenType.DATERANGE: &#x27;DATERANGE&#x27;&gt;, &lt;TokenType.STRUCT: &#x27;STRUCT&#x27;&gt;, &lt;TokenType.ASC: &#x27;ASC&#x27;&gt;, &lt;TokenType.PRAGMA: &#x27;PRAGMA&#x27;&gt;, &lt;TokenType.PROCEDURE: &#x27;PROCEDURE&#x27;&gt;, &lt;TokenType.SOME: &#x27;SOME&#x27;&gt;, &lt;TokenType.VARBINARY: &#x27;VARBINARY&#x27;&gt;, &lt;TokenType.NUMRANGE: &#x27;NUMRANGE&#x27;&gt;, &lt;TokenType.ESCAPE: &#x27;ESCAPE&#x27;&gt;, &lt;TokenType.DELETE: &#x27;DELETE&#x27;&gt;, &lt;TokenType.LONGTEXT: &#x27;LONGTEXT&#x27;&gt;, &lt;TokenType.LOAD: &#x27;LOAD&#x27;&gt;, &lt;TokenType.NEXT: &#x27;NEXT&#x27;&gt;, &lt;TokenType.TOP: &#x27;TOP&#x27;&gt;, &lt;TokenType.DEFAULT: &#x27;DEFAULT&#x27;&gt;, &lt;TokenType.TIMESTAMP_MS: &#x27;TIMESTAMP_MS&#x27;&gt;, &lt;TokenType.HSTORE: &#x27;HSTORE&#x27;&gt;, &lt;TokenType.AUTO_INCREMENT: &#x27;AUTO_INCREMENT&#x27;&gt;, &lt;TokenType.OVERWRITE: &#x27;OVERWRITE&#x27;&gt;, &lt;TokenType.IS: &#x27;IS&#x27;&gt;, &lt;TokenType.NULL: &#x27;NULL&#x27;&gt;, &lt;TokenType.TIMESTAMP_NS: &#x27;TIMESTAMP_NS&#x27;&gt;, &lt;TokenType.VAR: &#x27;VAR&#x27;&gt;, &lt;TokenType.UNIQUEIDENTIFIER: &#x27;UNIQUEIDENTIFIER&#x27;&gt;, &lt;TokenType.IPADDRESS: &#x27;IPADDRESS&#x27;&gt;, &lt;TokenType.TIME: &#x27;TIME&#x27;&gt;, &lt;TokenType.TIMESTAMPLTZ: &#x27;TIMESTAMPLTZ&#x27;&gt;, &lt;TokenType.TINYINT: &#x27;TINYINT&#x27;&gt;, &lt;TokenType.UINT128: &#x27;UINT128&#x27;&gt;, &lt;TokenType.UINT256: &#x27;UINT256&#x27;&gt;, &lt;TokenType.NCHAR: &#x27;NCHAR&#x27;&gt;, &lt;TokenType.COMMAND: &#x27;COMMAND&#x27;&gt;, &lt;TokenType.BOOLEAN: &#x27;BOOLEAN&#x27;&gt;, &lt;TokenType.SUPER: &#x27;SUPER&#x27;&gt;, &lt;TokenType.CONSTRAINT: &#x27;CONSTRAINT&#x27;&gt;, &lt;TokenType.UDECIMAL: &#x27;UDECIMAL&#x27;&gt;, &lt;TokenType.REFERENCES: &#x27;REFERENCES&#x27;&gt;, &lt;TokenType.CURRENT_TIMESTAMP: &#x27;CURRENT_TIMESTAMP&#x27;&gt;, &lt;TokenType.INT4RANGE: &#x27;INT4RANGE&#x27;&gt;, &lt;TokenType.VIEW: &#x27;VIEW&#x27;&gt;, &lt;TokenType.BIGSERIAL: &#x27;BIGSERIAL&#x27;&gt;, &lt;TokenType.MONEY: &#x27;MONEY&#x27;&gt;, &lt;TokenType.COMMIT: &#x27;COMMIT&#x27;&gt;, &lt;TokenType.LONGBLOB: &#x27;LONGBLOB&#x27;&gt;, &lt;TokenType.INT8MULTIRANGE: &#x27;INT8MULTIRANGE&#x27;&gt;, &lt;TokenType.DATETIME64: &#x27;DATETIME64&#x27;&gt;, &lt;TokenType.IMAGE: &#x27;IMAGE&#x27;&gt;, &lt;TokenType.UTINYINT: &#x27;UTINYINT&#x27;&gt;, &lt;TokenType.MERGE: &#x27;MERGE&#x27;&gt;, &lt;TokenType.INT128: &#x27;INT128&#x27;&gt;, &lt;TokenType.ENUM8: &#x27;ENUM8&#x27;&gt;, &lt;TokenType.DATABASE: &#x27;DATABASE&#x27;&gt;, &lt;TokenType.SMALLMONEY: &#x27;SMALLMONEY&#x27;&gt;, &lt;TokenType.CURRENT_DATE: &#x27;CURRENT_DATE&#x27;&gt;, &lt;TokenType.TSRANGE: &#x27;TSRANGE&#x27;&gt;, &lt;TokenType.TEMPORARY: &#x27;TEMPORARY&#x27;&gt;, &lt;TokenType.SET: &#x27;SET&#x27;&gt;, &lt;TokenType.INT256: &#x27;INT256&#x27;&gt;, &lt;TokenType.DESCRIBE: &#x27;DESCRIBE&#x27;&gt;, &lt;TokenType.MAP: &#x27;MAP&#x27;&gt;, &lt;TokenType.CURRENT_TIME: &#x27;CURRENT_TIME&#x27;&gt;, &lt;TokenType.END: &#x27;END&#x27;&gt;, &lt;TokenType.UINT: &#x27;UINT&#x27;&gt;, &lt;TokenType.CHAR: &#x27;CHAR&#x27;&gt;, &lt;TokenType.NULLABLE: &#x27;NULLABLE&#x27;&gt;, &lt;TokenType.ROW: &#x27;ROW&#x27;&gt;, &lt;TokenType.MEDIUMBLOB: &#x27;MEDIUMBLOB&#x27;&gt;, &lt;TokenType.INT8RANGE: &#x27;INT8RANGE&#x27;&gt;, &lt;TokenType.FLOAT: &#x27;FLOAT&#x27;&gt;, &lt;TokenType.XML: &#x27;XML&#x27;&gt;, &lt;TokenType.ORDINALITY: &#x27;ORDINALITY&#x27;&gt;, &lt;TokenType.NESTED: &#x27;NESTED&#x27;&gt;, &lt;TokenType.IPPREFIX: &#x27;IPPREFIX&#x27;&gt;, &lt;TokenType.DECIMAL: &#x27;DECIMAL&#x27;&gt;, &lt;TokenType.DATETIME: &#x27;DATETIME&#x27;&gt;, &lt;TokenType.OBJECT_IDENTIFIER: &#x27;OBJECT_IDENTIFIER&#x27;&gt;, &lt;TokenType.TIMESTAMP_S: &#x27;TIMESTAMP_S&#x27;&gt;, &lt;TokenType.SERIAL: &#x27;SERIAL&#x27;&gt;, &lt;TokenType.TIMESTAMPTZ: &#x27;TIMESTAMPTZ&#x27;&gt;, &lt;TokenType.COLUMN: &#x27;COLUMN&#x27;&gt;, &lt;TokenType.SCHEMA: &#x27;SCHEMA&#x27;&gt;, &lt;TokenType.OBJECT: &#x27;OBJECT&#x27;&gt;, &lt;TokenType.INET: &#x27;INET&#x27;&gt;, &lt;TokenType.FIRST: &#x27;FIRST&#x27;&gt;, &lt;TokenType.JSON: &#x27;JSON&#x27;&gt;, &lt;TokenType.BINARY: &#x27;BINARY&#x27;&gt;, &lt;TokenType.NVARCHAR: &#x27;NVARCHAR&#x27;&gt;, &lt;TokenType.UNIQUE: &#x27;UNIQUE&#x27;&gt;, &lt;TokenType.FALSE: &#x27;FALSE&#x27;&gt;, &lt;TokenType.SMALLINT: &#x27;SMALLINT&#x27;&gt;, &lt;TokenType.KEEP: &#x27;KEEP&#x27;&gt;, &lt;TokenType.GEOMETRY: &#x27;GEOMETRY&#x27;&gt;, &lt;TokenType.TIMESTAMP: &#x27;TIMESTAMP&#x27;&gt;, &lt;TokenType.PSEUDO_TYPE: &#x27;PSEUDO_TYPE&#x27;&gt;, &lt;TokenType.MEDIUMTEXT: &#x27;MEDIUMTEXT&#x27;&gt;, &lt;TokenType.USMALLINT: &#x27;USMALLINT&#x27;&gt;, &lt;TokenType.TSTZRANGE: &#x27;TSTZRANGE&#x27;&gt;, &lt;TokenType.RANGE: &#x27;RANGE&#x27;&gt;, &lt;TokenType.TSTZMULTIRANGE: &#x27;TSTZMULTIRANGE&#x27;&gt;, &lt;TokenType.YEAR: &#x27;YEAR&#x27;&gt;, &lt;TokenType.ISNULL: &#x27;ISNULL&#x27;&gt;, &lt;TokenType.UBIGINT: &#x27;UBIGINT&#x27;&gt;, &lt;TokenType.NUMMULTIRANGE: &#x27;NUMMULTIRANGE&#x27;&gt;, &lt;TokenType.INT: &#x27;INT&#x27;&gt;, &lt;TokenType.JSONB: &#x27;JSONB&#x27;&gt;, &lt;TokenType.MODEL: &#x27;MODEL&#x27;&gt;, &lt;TokenType.INTERVAL: &#x27;INTERVAL&#x27;&gt;, &lt;TokenType.BEGIN: &#x27;BEGIN&#x27;&gt;, &lt;TokenType.KILL: &#x27;KILL&#x27;&gt;, &lt;TokenType.ENUM: &#x27;ENUM&#x27;&gt;}"}, "sqlglot.dialects.clickhouse.ClickHouse.Parser.LOG_DEFAULTS_TO_LN": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Parser.LOG_DEFAULTS_TO_LN", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Parser.LOG_DEFAULTS_TO_LN", "kind": "variable", "doc": "<p></p>\n", "default_value": "True"}, "sqlglot.dialects.clickhouse.ClickHouse.Parser.QUERY_MODIFIER_PARSERS": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Parser.QUERY_MODIFIER_PARSERS", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Parser.QUERY_MODIFIER_PARSERS", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&lt;TokenType.MATCH_RECOGNIZE: &#x27;MATCH_RECOGNIZE&#x27;&gt;: &lt;function Parser.&lt;lambda&gt;&gt;, &lt;TokenType.WHERE: &#x27;WHERE&#x27;&gt;: &lt;function Parser.&lt;lambda&gt;&gt;, &lt;TokenType.GROUP_BY: &#x27;GROUP_BY&#x27;&gt;: &lt;function Parser.&lt;lambda&gt;&gt;, &lt;TokenType.HAVING: &#x27;HAVING&#x27;&gt;: &lt;function Parser.&lt;lambda&gt;&gt;, &lt;TokenType.QUALIFY: &#x27;QUALIFY&#x27;&gt;: &lt;function Parser.&lt;lambda&gt;&gt;, &lt;TokenType.WINDOW: &#x27;WINDOW&#x27;&gt;: &lt;function Parser.&lt;lambda&gt;&gt;, &lt;TokenType.ORDER_BY: &#x27;ORDER_BY&#x27;&gt;: &lt;function Parser.&lt;lambda&gt;&gt;, &lt;TokenType.LIMIT: &#x27;LIMIT&#x27;&gt;: &lt;function Parser.&lt;lambda&gt;&gt;, &lt;TokenType.FETCH: &#x27;FETCH&#x27;&gt;: &lt;function Parser.&lt;lambda&gt;&gt;, &lt;TokenType.OFFSET: &#x27;OFFSET&#x27;&gt;: &lt;function Parser.&lt;lambda&gt;&gt;, &lt;TokenType.FOR: &#x27;FOR&#x27;&gt;: &lt;function Parser.&lt;lambda&gt;&gt;, &lt;TokenType.LOCK: &#x27;LOCK&#x27;&gt;: &lt;function Parser.&lt;lambda&gt;&gt;, &lt;TokenType.TABLE_SAMPLE: &#x27;TABLE_SAMPLE&#x27;&gt;: &lt;function Parser.&lt;lambda&gt;&gt;, &lt;TokenType.USING: &#x27;USING&#x27;&gt;: &lt;function Parser.&lt;lambda&gt;&gt;, &lt;TokenType.CLUSTER_BY: &#x27;CLUSTER_BY&#x27;&gt;: &lt;function Parser.&lt;lambda&gt;&gt;, &lt;TokenType.DISTRIBUTE_BY: &#x27;DISTRIBUTE_BY&#x27;&gt;: &lt;function Parser.&lt;lambda&gt;&gt;, &lt;TokenType.SORT_BY: &#x27;SORT_BY&#x27;&gt;: &lt;function Parser.&lt;lambda&gt;&gt;, &lt;TokenType.CONNECT_BY: &#x27;CONNECT_BY&#x27;&gt;: &lt;function Parser.&lt;lambda&gt;&gt;, &lt;TokenType.START_WITH: &#x27;START_WITH&#x27;&gt;: &lt;function Parser.&lt;lambda&gt;&gt;, &lt;TokenType.SETTINGS: &#x27;SETTINGS&#x27;&gt;: &lt;function ClickHouse.Parser.&lt;lambda&gt;&gt;, &lt;TokenType.FORMAT: &#x27;FORMAT&#x27;&gt;: &lt;function ClickHouse.Parser.&lt;lambda&gt;&gt;}"}, "sqlglot.dialects.clickhouse.ClickHouse.Parser.TOKENIZER_CLASS": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Parser.TOKENIZER_CLASS", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Parser.TOKENIZER_CLASS", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Type[sqlglot.tokens.Tokenizer]", "default_value": "&lt;class &#x27;sqlglot.dialects.clickhouse.ClickHouse.Tokenizer&#x27;&gt;"}, "sqlglot.dialects.clickhouse.ClickHouse.Parser.STRICT_STRING_CONCAT": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Parser.STRICT_STRING_CONCAT", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Parser.STRICT_STRING_CONCAT", "kind": "variable", "doc": "<p></p>\n", "default_value": "True"}, "sqlglot.dialects.clickhouse.ClickHouse.Parser.SUPPORTS_USER_DEFINED_TYPES": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Parser.SUPPORTS_USER_DEFINED_TYPES", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Parser.SUPPORTS_USER_DEFINED_TYPES", "kind": "variable", "doc": "<p></p>\n", "default_value": "False"}, "sqlglot.dialects.clickhouse.ClickHouse.Parser.NORMALIZE_FUNCTIONS": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Parser.NORMALIZE_FUNCTIONS", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Parser.NORMALIZE_FUNCTIONS", "kind": "variable", "doc": "<p></p>\n", "default_value": "False"}, "sqlglot.dialects.clickhouse.ClickHouse.Parser.NULL_ORDERING": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Parser.NULL_ORDERING", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Parser.NULL_ORDERING", "kind": "variable", "doc": "<p></p>\n", "annotation": ": str", "default_value": "&#x27;nulls_are_last&#x27;"}, "sqlglot.dialects.clickhouse.ClickHouse.Parser.SHOW_TRIE": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Parser.SHOW_TRIE", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Parser.SHOW_TRIE", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict", "default_value": "{}"}, "sqlglot.dialects.clickhouse.ClickHouse.Parser.SET_TRIE": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Parser.SET_TRIE", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Parser.SET_TRIE", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict", "default_value": "{&#x27;GLOBAL&#x27;: {0: True}, &#x27;LOCAL&#x27;: {0: True}, &#x27;SESSION&#x27;: {0: True}, &#x27;TRANSACTION&#x27;: {0: True}}"}, "sqlglot.dialects.clickhouse.ClickHouse.Parser.FORMAT_TRIE": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Parser.FORMAT_TRIE", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Parser.FORMAT_TRIE", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict", "default_value": "{}"}, "sqlglot.dialects.clickhouse.ClickHouse.Parser.TIME_TRIE": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Parser.TIME_TRIE", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Parser.TIME_TRIE", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict", "default_value": "{}"}, "sqlglot.dialects.clickhouse.ClickHouse.Generator": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Generator", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Generator", "kind": "class", "doc": "<p>Generator converts a given syntax tree to the corresponding SQL string.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>pretty:</strong>  Whether or not to format the produced SQL string.\nDefault: False.</li>\n<li><strong>identify:</strong>  Determines when an identifier should be quoted. Possible values are:\nFalse (default): Never quote, except in cases where it's mandatory by the dialect.\nTrue or 'always': Always quote.\n'safe': Only quote identifiers that are case insensitive.</li>\n<li><strong>normalize:</strong>  Whether or not to normalize identifiers to lowercase.\nDefault: False.</li>\n<li><strong>pad:</strong>  Determines the pad size in a formatted string.\nDefault: 2.</li>\n<li><strong>indent:</strong>  Determines the indentation size in a formatted string.\nDefault: 2.</li>\n<li><strong>normalize_functions:</strong>  Whether or not to normalize all function names. Possible values are:\n\"upper\" or True (default): Convert names to uppercase.\n\"lower\": Convert names to lowercase.\nFalse: Disables function name normalization.</li>\n<li><strong>unsupported_level:</strong>  Determines the generator's behavior when it encounters unsupported expressions.\nDefault ErrorLevel.WARN.</li>\n<li><strong>max_unsupported:</strong>  Maximum number of unsupported messages to include in a raised UnsupportedError.\nThis is only relevant if unsupported_level is ErrorLevel.RAISE.\nDefault: 3</li>\n<li><strong>leading_comma:</strong>  Determines whether or not the comma is leading or trailing in select expressions.\nThis is only relevant when generating in pretty mode.\nDefault: False</li>\n<li><strong>max_text_width:</strong>  The max number of characters in a segment before creating new lines in pretty mode.\nThe default is on the smaller end because the length only represents a segment and not the true\nline length.\nDefault: 80</li>\n<li><strong>comments:</strong>  Whether or not to preserve comments in the output SQL code.\nDefault: True</li>\n</ul>\n", "bases": "sqlglot.generator.Generator"}, "sqlglot.dialects.clickhouse.ClickHouse.Generator.QUERY_HINTS": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Generator.QUERY_HINTS", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Generator.QUERY_HINTS", "kind": "variable", "doc": "<p></p>\n", "default_value": "False"}, "sqlglot.dialects.clickhouse.ClickHouse.Generator.STRUCT_DELIMITER": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Generator.STRUCT_DELIMITER", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Generator.STRUCT_DELIMITER", "kind": "variable", "doc": "<p></p>\n", "default_value": "(&#x27;(&#x27;, &#x27;)&#x27;)"}, "sqlglot.dialects.clickhouse.ClickHouse.Generator.NVL2_SUPPORTED": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Generator.NVL2_SUPPORTED", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Generator.NVL2_SUPPORTED", "kind": "variable", "doc": "<p></p>\n", "default_value": "False"}, "sqlglot.dialects.clickhouse.ClickHouse.Generator.TABLESAMPLE_REQUIRES_PARENS": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Generator.TABLESAMPLE_REQUIRES_PARENS", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Generator.TABLESAMPLE_REQUIRES_PARENS", "kind": "variable", "doc": "<p></p>\n", "default_value": "False"}, "sqlglot.dialects.clickhouse.ClickHouse.Generator.STRING_TYPE_MAPPING": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Generator.STRING_TYPE_MAPPING", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Generator.STRING_TYPE_MAPPING", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&lt;Type.CHAR: &#x27;CHAR&#x27;&gt;: &#x27;String&#x27;, &lt;Type.LONGBLOB: &#x27;LONGBLOB&#x27;&gt;: &#x27;String&#x27;, &lt;Type.LONGTEXT: &#x27;LONGTEXT&#x27;&gt;: &#x27;String&#x27;, &lt;Type.MEDIUMBLOB: &#x27;MEDIUMBLOB&#x27;&gt;: &#x27;String&#x27;, &lt;Type.MEDIUMTEXT: &#x27;MEDIUMTEXT&#x27;&gt;: &#x27;String&#x27;, &lt;Type.TINYBLOB: &#x27;TINYBLOB&#x27;&gt;: &#x27;String&#x27;, &lt;Type.TINYTEXT: &#x27;TINYTEXT&#x27;&gt;: &#x27;String&#x27;, &lt;Type.TEXT: &#x27;TEXT&#x27;&gt;: &#x27;String&#x27;, &lt;Type.VARBINARY: &#x27;VARBINARY&#x27;&gt;: &#x27;String&#x27;, &lt;Type.VARCHAR: &#x27;VARCHAR&#x27;&gt;: &#x27;String&#x27;}"}, "sqlglot.dialects.clickhouse.ClickHouse.Generator.TYPE_MAPPING": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Generator.TYPE_MAPPING", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Generator.TYPE_MAPPING", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&lt;Type.NCHAR: &#x27;NCHAR&#x27;&gt;: &#x27;CHAR&#x27;, &lt;Type.NVARCHAR: &#x27;NVARCHAR&#x27;&gt;: &#x27;VARCHAR&#x27;, &lt;Type.MEDIUMTEXT: &#x27;MEDIUMTEXT&#x27;&gt;: &#x27;String&#x27;, &lt;Type.LONGTEXT: &#x27;LONGTEXT&#x27;&gt;: &#x27;String&#x27;, &lt;Type.TINYTEXT: &#x27;TINYTEXT&#x27;&gt;: &#x27;String&#x27;, &lt;Type.MEDIUMBLOB: &#x27;MEDIUMBLOB&#x27;&gt;: &#x27;String&#x27;, &lt;Type.LONGBLOB: &#x27;LONGBLOB&#x27;&gt;: &#x27;String&#x27;, &lt;Type.TINYBLOB: &#x27;TINYBLOB&#x27;&gt;: &#x27;String&#x27;, &lt;Type.INET: &#x27;INET&#x27;&gt;: &#x27;INET&#x27;, &lt;Type.CHAR: &#x27;CHAR&#x27;&gt;: &#x27;String&#x27;, &lt;Type.TEXT: &#x27;TEXT&#x27;&gt;: &#x27;String&#x27;, &lt;Type.VARBINARY: &#x27;VARBINARY&#x27;&gt;: &#x27;String&#x27;, &lt;Type.VARCHAR: &#x27;VARCHAR&#x27;&gt;: &#x27;String&#x27;, &lt;Type.ARRAY: &#x27;ARRAY&#x27;&gt;: &#x27;Array&#x27;, &lt;Type.BIGINT: &#x27;BIGINT&#x27;&gt;: &#x27;Int64&#x27;, &lt;Type.DATETIME64: &#x27;DATETIME64&#x27;&gt;: &#x27;DateTime64&#x27;, &lt;Type.DOUBLE: &#x27;DOUBLE&#x27;&gt;: &#x27;Float64&#x27;, &lt;Type.ENUM: &#x27;ENUM&#x27;&gt;: &#x27;Enum&#x27;, &lt;Type.ENUM8: &#x27;ENUM8&#x27;&gt;: &#x27;Enum8&#x27;, &lt;Type.ENUM16: &#x27;ENUM16&#x27;&gt;: &#x27;Enum16&#x27;, &lt;Type.FIXEDSTRING: &#x27;FIXEDSTRING&#x27;&gt;: &#x27;FixedString&#x27;, &lt;Type.FLOAT: &#x27;FLOAT&#x27;&gt;: &#x27;Float32&#x27;, &lt;Type.INT: &#x27;INT&#x27;&gt;: &#x27;Int32&#x27;, &lt;Type.MEDIUMINT: &#x27;MEDIUMINT&#x27;&gt;: &#x27;Int32&#x27;, &lt;Type.INT128: &#x27;INT128&#x27;&gt;: &#x27;Int128&#x27;, &lt;Type.INT256: &#x27;INT256&#x27;&gt;: &#x27;Int256&#x27;, &lt;Type.LOWCARDINALITY: &#x27;LOWCARDINALITY&#x27;&gt;: &#x27;LowCardinality&#x27;, &lt;Type.MAP: &#x27;MAP&#x27;&gt;: &#x27;Map&#x27;, &lt;Type.NESTED: &#x27;NESTED&#x27;&gt;: &#x27;Nested&#x27;, &lt;Type.NULLABLE: &#x27;NULLABLE&#x27;&gt;: &#x27;Nullable&#x27;, &lt;Type.SMALLINT: &#x27;SMALLINT&#x27;&gt;: &#x27;Int16&#x27;, &lt;Type.STRUCT: &#x27;STRUCT&#x27;&gt;: &#x27;Tuple&#x27;, &lt;Type.TINYINT: &#x27;TINYINT&#x27;&gt;: &#x27;Int8&#x27;, &lt;Type.UBIGINT: &#x27;UBIGINT&#x27;&gt;: &#x27;UInt64&#x27;, &lt;Type.UINT: &#x27;UINT&#x27;&gt;: &#x27;UInt32&#x27;, &lt;Type.UINT128: &#x27;UINT128&#x27;&gt;: &#x27;UInt128&#x27;, &lt;Type.UINT256: &#x27;UINT256&#x27;&gt;: &#x27;UInt256&#x27;, &lt;Type.USMALLINT: &#x27;USMALLINT&#x27;&gt;: &#x27;UInt16&#x27;, &lt;Type.UTINYINT: &#x27;UTINYINT&#x27;&gt;: &#x27;UInt8&#x27;}"}, "sqlglot.dialects.clickhouse.ClickHouse.Generator.TRANSFORMS": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Generator.TRANSFORMS", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Generator.TRANSFORMS", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&lt;class &#x27;sqlglot.expressions.DateAdd&#x27;&gt;: &lt;function ClickHouse.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.TsOrDsAdd&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.CaseSpecificColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.CharacterSetColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.CharacterSetProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.CheckColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.ClusteredColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.CollateColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.CopyGrantsProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.CommentColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.DateFormatColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.DefaultColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.EncodeColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.ExecuteAsProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.ExternalProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.HeapProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.InlineLengthColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.InputModelProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.IntervalSpan&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.LanguageProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.LocationProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.LogProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.MaterializedProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.NoPrimaryIndexProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.NonClusteredColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.NotForReplicationColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.OnCommitProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.OnProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.OnUpdateColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.OutputModelProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.PathColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.RemoteWithConnectionModelProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.ReturnsProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.SampleProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.SetProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.SettingsProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.SqlSecurityProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.StabilityProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.TemporaryProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.ToTableProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.TransientProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.TransformModelProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.TitleColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.UppercaseColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.VarMap&#x27;&gt;: &lt;function ClickHouse.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.VolatileProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.WithJournalTableProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.Select&#x27;&gt;: &lt;function preprocess.&lt;locals&gt;._to_sql&gt;, &lt;class &#x27;sqlglot.expressions.AnyValue&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.ApproxDistinct&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.Array&#x27;&gt;: &lt;function inline_array_sql&gt;, &lt;class &#x27;sqlglot.expressions.CastToStrType&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.DateDiff&#x27;&gt;: &lt;function ClickHouse.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.Final&#x27;&gt;: &lt;function ClickHouse.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.IsNan&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.Map&#x27;&gt;: &lt;function ClickHouse.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.PartitionedByProperty&#x27;&gt;: &lt;function ClickHouse.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.Pivot&#x27;&gt;: &lt;function no_pivot_sql&gt;, &lt;class &#x27;sqlglot.expressions.Quantile&#x27;&gt;: &lt;function _quantile_sql&gt;, &lt;class &#x27;sqlglot.expressions.RegexpLike&#x27;&gt;: &lt;function ClickHouse.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.StartsWith&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.StrPosition&#x27;&gt;: &lt;function ClickHouse.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.Xor&#x27;&gt;: &lt;function ClickHouse.Generator.&lt;lambda&gt;&gt;}"}, "sqlglot.dialects.clickhouse.ClickHouse.Generator.PROPERTIES_LOCATION": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Generator.PROPERTIES_LOCATION", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Generator.PROPERTIES_LOCATION", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&lt;class &#x27;sqlglot.expressions.AlgorithmProperty&#x27;&gt;: &lt;Location.POST_CREATE: &#x27;POST_CREATE&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.AutoIncrementProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.BlockCompressionProperty&#x27;&gt;: &lt;Location.POST_NAME: &#x27;POST_NAME&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.CharacterSetProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.ChecksumProperty&#x27;&gt;: &lt;Location.POST_NAME: &#x27;POST_NAME&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.CollateProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.CopyGrantsProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.Cluster&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.ClusteredByProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.DataBlocksizeProperty&#x27;&gt;: &lt;Location.POST_NAME: &#x27;POST_NAME&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.DefinerProperty&#x27;&gt;: &lt;Location.POST_CREATE: &#x27;POST_CREATE&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.DictRange&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.DictProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.DistKeyProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.DistStyleProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.EngineProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.ExecuteAsProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.ExternalProperty&#x27;&gt;: &lt;Location.POST_CREATE: &#x27;POST_CREATE&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.FallbackProperty&#x27;&gt;: &lt;Location.POST_NAME: &#x27;POST_NAME&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.FileFormatProperty&#x27;&gt;: &lt;Location.POST_WITH: &#x27;POST_WITH&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.FreespaceProperty&#x27;&gt;: &lt;Location.POST_NAME: &#x27;POST_NAME&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.HeapProperty&#x27;&gt;: &lt;Location.POST_WITH: &#x27;POST_WITH&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.InputModelProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.IsolatedLoadingProperty&#x27;&gt;: &lt;Location.POST_NAME: &#x27;POST_NAME&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.JournalProperty&#x27;&gt;: &lt;Location.POST_NAME: &#x27;POST_NAME&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.LanguageProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.LikeProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.LocationProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.LockingProperty&#x27;&gt;: &lt;Location.POST_ALIAS: &#x27;POST_ALIAS&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.LogProperty&#x27;&gt;: &lt;Location.POST_NAME: &#x27;POST_NAME&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.MaterializedProperty&#x27;&gt;: &lt;Location.POST_CREATE: &#x27;POST_CREATE&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.MergeBlockRatioProperty&#x27;&gt;: &lt;Location.POST_NAME: &#x27;POST_NAME&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.NoPrimaryIndexProperty&#x27;&gt;: &lt;Location.POST_EXPRESSION: &#x27;POST_EXPRESSION&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.OnProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.OnCommitProperty&#x27;&gt;: &lt;Location.POST_EXPRESSION: &#x27;POST_EXPRESSION&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.Order&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.OutputModelProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.PartitionedByProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.PrimaryKey&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.Property&#x27;&gt;: &lt;Location.POST_WITH: &#x27;POST_WITH&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.RemoteWithConnectionModelProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.ReturnsProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.RowFormatProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.RowFormatDelimitedProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.RowFormatSerdeProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.SampleProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.SchemaCommentProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.SerdeProperties&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.Set&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.SettingsProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.SetProperty&#x27;&gt;: &lt;Location.POST_CREATE: &#x27;POST_CREATE&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.SortKeyProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.SqlSecurityProperty&#x27;&gt;: &lt;Location.POST_CREATE: &#x27;POST_CREATE&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.StabilityProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.TemporaryProperty&#x27;&gt;: &lt;Location.POST_CREATE: &#x27;POST_CREATE&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.ToTableProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.TransientProperty&#x27;&gt;: &lt;Location.POST_CREATE: &#x27;POST_CREATE&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.TransformModelProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.MergeTreeTTL&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.VolatileProperty&#x27;&gt;: &lt;Location.UNSUPPORTED: &#x27;UNSUPPORTED&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.WithDataProperty&#x27;&gt;: &lt;Location.POST_EXPRESSION: &#x27;POST_EXPRESSION&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.WithJournalTableProperty&#x27;&gt;: &lt;Location.POST_NAME: &#x27;POST_NAME&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.OnCluster&#x27;&gt;: &lt;Location.POST_NAME: &#x27;POST_NAME&#x27;&gt;}"}, "sqlglot.dialects.clickhouse.ClickHouse.Generator.JOIN_HINTS": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Generator.JOIN_HINTS", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Generator.JOIN_HINTS", "kind": "variable", "doc": "<p></p>\n", "default_value": "False"}, "sqlglot.dialects.clickhouse.ClickHouse.Generator.TABLE_HINTS": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Generator.TABLE_HINTS", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Generator.TABLE_HINTS", "kind": "variable", "doc": "<p></p>\n", "default_value": "False"}, "sqlglot.dialects.clickhouse.ClickHouse.Generator.EXPLICIT_UNION": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Generator.EXPLICIT_UNION", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Generator.EXPLICIT_UNION", "kind": "variable", "doc": "<p></p>\n", "default_value": "True"}, "sqlglot.dialects.clickhouse.ClickHouse.Generator.GROUPINGS_SEP": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Generator.GROUPINGS_SEP", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Generator.GROUPINGS_SEP", "kind": "variable", "doc": "<p></p>\n", "default_value": "&#x27;&#x27;"}, "sqlglot.dialects.clickhouse.ClickHouse.Generator.ON_CLUSTER_TARGETS": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Generator.ON_CLUSTER_TARGETS", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Generator.ON_CLUSTER_TARGETS", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;DATABASE&#x27;, &#x27;DICTIONARY&#x27;, &#x27;VIEW&#x27;, &#x27;TABLE&#x27;, &#x27;FUNCTION&#x27;, &#x27;INDEX&#x27;, &#x27;NAMED COLLECTION&#x27;}"}, "sqlglot.dialects.clickhouse.ClickHouse.Generator.eq_sql": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Generator.eq_sql", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Generator.eq_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">EQ</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.clickhouse.ClickHouse.Generator.neq_sql": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Generator.neq_sql", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Generator.neq_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">NEQ</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.clickhouse.ClickHouse.Generator.regexpilike_sql": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Generator.regexpilike_sql", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Generator.regexpilike_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">RegexpILike</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.clickhouse.ClickHouse.Generator.datatype_sql": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Generator.datatype_sql", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Generator.datatype_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">DataType</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.clickhouse.ClickHouse.Generator.safeconcat_sql": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Generator.safeconcat_sql", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Generator.safeconcat_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">SafeConcat</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.clickhouse.ClickHouse.Generator.cte_sql": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Generator.cte_sql", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Generator.cte_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">CTE</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.clickhouse.ClickHouse.Generator.after_limit_modifiers": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Generator.after_limit_modifiers", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Generator.after_limit_modifiers", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.clickhouse.ClickHouse.Generator.parameterizedagg_sql": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Generator.parameterizedagg_sql", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Generator.parameterizedagg_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Anonymous</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.clickhouse.ClickHouse.Generator.placeholder_sql": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Generator.placeholder_sql", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Generator.placeholder_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Placeholder</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.clickhouse.ClickHouse.Generator.oncluster_sql": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Generator.oncluster_sql", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Generator.oncluster_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">OnCluster</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.clickhouse.ClickHouse.Generator.createable_sql": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Generator.createable_sql", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Generator.createable_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Create</span>,</span><span class=\"param\">\t<span class=\"n\">locations</span><span class=\"p\">:</span> <span class=\"n\">DefaultDict</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.clickhouse.ClickHouse.Generator.SELECT_KINDS": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Generator.SELECT_KINDS", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Generator.SELECT_KINDS", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Tuple[str, ...]", "default_value": "()"}, "sqlglot.dialects.clickhouse.ClickHouse.Generator.INVERSE_TIME_MAPPING": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Generator.INVERSE_TIME_MAPPING", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Generator.INVERSE_TIME_MAPPING", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict[str, str]", "default_value": "{}"}, "sqlglot.dialects.clickhouse.ClickHouse.Generator.INVERSE_TIME_TRIE": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Generator.INVERSE_TIME_TRIE", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Generator.INVERSE_TIME_TRIE", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict", "default_value": "{}"}, "sqlglot.dialects.clickhouse.ClickHouse.Generator.INVERSE_ESCAPE_SEQUENCES": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Generator.INVERSE_ESCAPE_SEQUENCES", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Generator.INVERSE_ESCAPE_SEQUENCES", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict[str, str]", "default_value": "{&#x27;\\x00&#x27;: &#x27;\\\\0&#x27;}"}, "sqlglot.dialects.clickhouse.ClickHouse.Generator.STRICT_STRING_CONCAT": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Generator.STRICT_STRING_CONCAT", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Generator.STRICT_STRING_CONCAT", "kind": "variable", "doc": "<p></p>\n", "default_value": "True"}, "sqlglot.dialects.clickhouse.ClickHouse.Generator.NORMALIZE_FUNCTIONS": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Generator.NORMALIZE_FUNCTIONS", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Generator.NORMALIZE_FUNCTIONS", "kind": "variable", "doc": "<p></p>\n", "annotation": ": bool | str", "default_value": "False"}, "sqlglot.dialects.clickhouse.ClickHouse.Generator.NULL_ORDERING": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Generator.NULL_ORDERING", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Generator.NULL_ORDERING", "kind": "variable", "doc": "<p></p>\n", "default_value": "&#x27;nulls_are_last&#x27;"}, "sqlglot.dialects.clickhouse.ClickHouse.Generator.can_identify": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Generator.can_identify", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Generator.can_identify", "kind": "function", "doc": "<p>Checks if text can be identified given an identify option.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>text:</strong>  The text to check.</li>\n<li><strong>identify:</strong>  \"always\" or <code>True</code>: Always returns true.\n\"safe\": True if the identifier is case-insensitive.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>Whether or not the given text can be identified.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">text</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">identify</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;safe&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.clickhouse.ClickHouse.Generator.QUOTE_START": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Generator.QUOTE_START", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Generator.QUOTE_START", "kind": "variable", "doc": "<p></p>\n", "default_value": "&quot;&#x27;&quot;"}, "sqlglot.dialects.clickhouse.ClickHouse.Generator.QUOTE_END": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Generator.QUOTE_END", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Generator.QUOTE_END", "kind": "variable", "doc": "<p></p>\n", "default_value": "&quot;&#x27;&quot;"}, "sqlglot.dialects.clickhouse.ClickHouse.Generator.IDENTIFIER_START": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Generator.IDENTIFIER_START", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Generator.IDENTIFIER_START", "kind": "variable", "doc": "<p></p>\n", "default_value": "&#x27;&quot;&#x27;"}, "sqlglot.dialects.clickhouse.ClickHouse.Generator.IDENTIFIER_END": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Generator.IDENTIFIER_END", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Generator.IDENTIFIER_END", "kind": "variable", "doc": "<p></p>\n", "default_value": "&#x27;&quot;&#x27;"}, "sqlglot.dialects.clickhouse.ClickHouse.Generator.TOKENIZER_CLASS": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Generator.TOKENIZER_CLASS", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Generator.TOKENIZER_CLASS", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;class &#x27;sqlglot.dialects.clickhouse.ClickHouse.Tokenizer&#x27;&gt;"}, "sqlglot.dialects.clickhouse.ClickHouse.Generator.BIT_START": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Generator.BIT_START", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Generator.BIT_START", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Optional[str]", "default_value": "&#x27;0b&#x27;"}, "sqlglot.dialects.clickhouse.ClickHouse.Generator.BIT_END": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Generator.BIT_END", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Generator.BIT_END", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Optional[str]", "default_value": "&#x27;&#x27;"}, "sqlglot.dialects.clickhouse.ClickHouse.Generator.HEX_START": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Generator.HEX_START", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Generator.HEX_START", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Optional[str]", "default_value": "&#x27;0x&#x27;"}, "sqlglot.dialects.clickhouse.ClickHouse.Generator.HEX_END": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Generator.HEX_END", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Generator.HEX_END", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Optional[str]", "default_value": "&#x27;&#x27;"}, "sqlglot.dialects.clickhouse.ClickHouse.Generator.BYTE_START": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Generator.BYTE_START", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Generator.BYTE_START", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Optional[str]", "default_value": "None"}, "sqlglot.dialects.clickhouse.ClickHouse.Generator.BYTE_END": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Generator.BYTE_END", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Generator.BYTE_END", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Optional[str]", "default_value": "None"}, "sqlglot.dialects.clickhouse.ClickHouse.tokenizer_class": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.tokenizer_class", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.tokenizer_class", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;class &#x27;sqlglot.dialects.clickhouse.ClickHouse.Tokenizer&#x27;&gt;"}, "sqlglot.dialects.clickhouse.ClickHouse.parser_class": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.parser_class", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.parser_class", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;class &#x27;sqlglot.dialects.clickhouse.ClickHouse.Parser&#x27;&gt;"}, "sqlglot.dialects.clickhouse.ClickHouse.generator_class": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.generator_class", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.generator_class", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;class &#x27;sqlglot.dialects.clickhouse.ClickHouse.Generator&#x27;&gt;"}, "sqlglot.dialects.clickhouse.ClickHouse.TIME_TRIE": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.TIME_TRIE", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.TIME_TRIE", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict", "default_value": "{}"}, "sqlglot.dialects.clickhouse.ClickHouse.FORMAT_TRIE": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.FORMAT_TRIE", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.FORMAT_TRIE", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict", "default_value": "{}"}, "sqlglot.dialects.clickhouse.ClickHouse.INVERSE_TIME_MAPPING": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.INVERSE_TIME_MAPPING", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.INVERSE_TIME_MAPPING", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict[str, str]", "default_value": "{}"}, "sqlglot.dialects.clickhouse.ClickHouse.INVERSE_TIME_TRIE": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.INVERSE_TIME_TRIE", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.INVERSE_TIME_TRIE", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict", "default_value": "{}"}, "sqlglot.dialects.clickhouse.ClickHouse.INVERSE_ESCAPE_SEQUENCES": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.INVERSE_ESCAPE_SEQUENCES", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.INVERSE_ESCAPE_SEQUENCES", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict[str, str]", "default_value": "{&#x27;\\x00&#x27;: &#x27;\\\\0&#x27;}"}, "sqlglot.dialects.clickhouse.ClickHouse.QUOTE_START": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.QUOTE_START", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.QUOTE_START", "kind": "variable", "doc": "<p></p>\n", "default_value": "&quot;&#x27;&quot;"}, "sqlglot.dialects.clickhouse.ClickHouse.QUOTE_END": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.QUOTE_END", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.QUOTE_END", "kind": "variable", "doc": "<p></p>\n", "default_value": "&quot;&#x27;&quot;"}, "sqlglot.dialects.clickhouse.ClickHouse.IDENTIFIER_START": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.IDENTIFIER_START", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.IDENTIFIER_START", "kind": "variable", "doc": "<p></p>\n", "default_value": "&#x27;&quot;&#x27;"}, "sqlglot.dialects.clickhouse.ClickHouse.IDENTIFIER_END": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.IDENTIFIER_END", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.IDENTIFIER_END", "kind": "variable", "doc": "<p></p>\n", "default_value": "&#x27;&quot;&#x27;"}, "sqlglot.dialects.clickhouse.ClickHouse.BIT_START": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.BIT_START", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.BIT_START", "kind": "variable", "doc": "<p></p>\n", "default_value": "&#x27;0b&#x27;"}, "sqlglot.dialects.clickhouse.ClickHouse.BIT_END": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.BIT_END", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.BIT_END", "kind": "variable", "doc": "<p></p>\n", "default_value": "&#x27;&#x27;"}, "sqlglot.dialects.clickhouse.ClickHouse.HEX_START": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.HEX_START", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.HEX_START", "kind": "variable", "doc": "<p></p>\n", "default_value": "&#x27;0x&#x27;"}, "sqlglot.dialects.clickhouse.ClickHouse.HEX_END": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.HEX_END", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.HEX_END", "kind": "variable", "doc": "<p></p>\n", "default_value": "&#x27;&#x27;"}, "sqlglot.dialects.clickhouse.ClickHouse.BYTE_START": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.BYTE_START", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.BYTE_START", "kind": "variable", "doc": "<p></p>\n", "default_value": "None"}, "sqlglot.dialects.clickhouse.ClickHouse.BYTE_END": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.BYTE_END", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.BYTE_END", "kind": "variable", "doc": "<p></p>\n", "default_value": "None"}, "sqlglot.dialects.databricks": {"fullname": "sqlglot.dialects.databricks", "modulename": "sqlglot.dialects.databricks", "kind": "module", "doc": "<p></p>\n"}, "sqlglot.dialects.databricks.Databricks": {"fullname": "sqlglot.dialects.databricks.Databricks", "modulename": "sqlglot.dialects.databricks", "qualname": "Databricks", "kind": "class", "doc": "<p></p>\n", "bases": "sqlglot.dialects.spark.Spark"}, "sqlglot.dialects.databricks.Databricks.Parser": {"fullname": "sqlglot.dialects.databricks.Databricks.Parser", "modulename": "sqlglot.dialects.databricks", "qualname": "Databricks.Parser", "kind": "class", "doc": "<p>Parser consumes a list of tokens produced by the Tokenizer and produces a parsed syntax tree.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>error_level:</strong>  The desired error level.\nDefault: ErrorLevel.IMMEDIATE</li>\n<li><strong>error_message_context:</strong>  Determines the amount of context to capture from a\nquery string when displaying the error message (in number of characters).\nDefault: 100</li>\n<li><strong>max_errors:</strong>  Maximum number of error messages to include in a raised ParseError.\nThis is only relevant if error_level is ErrorLevel.RAISE.\nDefault: 3</li>\n</ul>\n", "bases": "sqlglot.dialects.spark.Spark.Parser"}, "sqlglot.dialects.databricks.Databricks.Parser.LOG_DEFAULTS_TO_LN": {"fullname": "sqlglot.dialects.databricks.Databricks.Parser.LOG_DEFAULTS_TO_LN", "modulename": "sqlglot.dialects.databricks", "qualname": "Databricks.Parser.LOG_DEFAULTS_TO_LN", "kind": "variable", "doc": "<p></p>\n", "default_value": "True"}, "sqlglot.dialects.databricks.Databricks.Parser.STRICT_CAST": {"fullname": "sqlglot.dialects.databricks.Databricks.Parser.STRICT_CAST", "modulename": "sqlglot.dialects.databricks", "qualname": "Databricks.Parser.STRICT_CAST", "kind": "variable", "doc": "<p></p>\n", "default_value": "True"}, "sqlglot.dialects.databricks.Databricks.Parser.FUNCTIONS": {"fullname": "sqlglot.dialects.databricks.Databricks.Parser.FUNCTIONS", "modulename": "sqlglot.dialects.databricks", "qualname": "Databricks.Parser.FUNCTIONS", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;ABS&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Abs&#x27;&gt;&gt;, &#x27;ANY_VALUE&#x27;: &lt;function Spark.Parser.&lt;lambda&gt;&gt;, &#x27;APPROX_DISTINCT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ApproxDistinct&#x27;&gt;&gt;, &#x27;APPROX_COUNT_DISTINCT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ApproxDistinct&#x27;&gt;&gt;, &#x27;APPROX_QUANTILE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ApproxQuantile&#x27;&gt;&gt;, &#x27;ARRAY&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Array&#x27;&gt;&gt;, &#x27;ARRAY_AGG&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArrayAgg&#x27;&gt;&gt;, &#x27;ARRAY_ALL&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArrayAll&#x27;&gt;&gt;, &#x27;ARRAY_ANY&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArrayAny&#x27;&gt;&gt;, &#x27;ARRAY_CONCAT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArrayConcat&#x27;&gt;&gt;, &#x27;ARRAY_CAT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArrayConcat&#x27;&gt;&gt;, &#x27;ARRAY_CONTAINS&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArrayContains&#x27;&gt;&gt;, &#x27;FILTER&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArrayFilter&#x27;&gt;&gt;, &#x27;ARRAY_FILTER&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArrayFilter&#x27;&gt;&gt;, &#x27;ARRAY_JOIN&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArrayJoin&#x27;&gt;&gt;, &#x27;ARRAY_SIZE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArraySize&#x27;&gt;&gt;, &#x27;ARRAY_SORT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArraySort&#x27;&gt;&gt;, &#x27;ARRAY_SUM&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArraySum&#x27;&gt;&gt;, &#x27;ARRAY_UNION_AGG&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArrayUnionAgg&#x27;&gt;&gt;, &#x27;AVG&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Avg&#x27;&gt;&gt;, &#x27;CASE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Case&#x27;&gt;&gt;, &#x27;CAST&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Cast&#x27;&gt;&gt;, &#x27;CAST_TO_STR_TYPE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.CastToStrType&#x27;&gt;&gt;, &#x27;CEIL&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Ceil&#x27;&gt;&gt;, &#x27;CEILING&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Ceil&#x27;&gt;&gt;, &#x27;CHR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Chr&#x27;&gt;&gt;, &#x27;CHAR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Chr&#x27;&gt;&gt;, &#x27;COALESCE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Coalesce&#x27;&gt;&gt;, &#x27;IFNULL&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Coalesce&#x27;&gt;&gt;, &#x27;NVL&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Coalesce&#x27;&gt;&gt;, &#x27;COLLATE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Collate&#x27;&gt;&gt;, &#x27;CONCAT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Concat&#x27;&gt;&gt;, &#x27;CONCAT_WS&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ConcatWs&#x27;&gt;&gt;, &#x27;COUNT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Count&#x27;&gt;&gt;, &#x27;COUNT_IF&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.CountIf&#x27;&gt;&gt;, &#x27;CURRENT_DATE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.CurrentDate&#x27;&gt;&gt;, &#x27;CURRENT_DATETIME&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.CurrentDatetime&#x27;&gt;&gt;, &#x27;CURRENT_TIME&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.CurrentTime&#x27;&gt;&gt;, &#x27;CURRENT_TIMESTAMP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.CurrentTimestamp&#x27;&gt;&gt;, &#x27;CURRENT_USER&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.CurrentUser&#x27;&gt;&gt;, &#x27;DATE&#x27;: &lt;function _parse_as_cast.&lt;locals&gt;.&lt;lambda&gt;&gt;, &#x27;DATE_ADD&#x27;: &lt;function parse_date_delta.&lt;locals&gt;.inner_func&gt;, &#x27;DATEDIFF&#x27;: &lt;function parse_date_delta.&lt;locals&gt;.inner_func&gt;, &#x27;DATE_DIFF&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DateDiff&#x27;&gt;&gt;, &#x27;DATEFROMPARTS&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DateFromParts&#x27;&gt;&gt;, &#x27;DATE_STR_TO_DATE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DateStrToDate&#x27;&gt;&gt;, &#x27;DATE_SUB&#x27;: &lt;function Hive.Parser.&lt;lambda&gt;&gt;, &#x27;DATE_TO_DATE_STR&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;DATE_TO_DI&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DateToDi&#x27;&gt;&gt;, &#x27;DATE_TRUNC&#x27;: &lt;function Spark2.Parser.&lt;lambda&gt;&gt;, &#x27;DATETIME_ADD&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DatetimeAdd&#x27;&gt;&gt;, &#x27;DATETIME_DIFF&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DatetimeDiff&#x27;&gt;&gt;, &#x27;DATETIME_SUB&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DatetimeSub&#x27;&gt;&gt;, &#x27;DATETIME_TRUNC&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DatetimeTrunc&#x27;&gt;&gt;, &#x27;DAY&#x27;: &lt;function Hive.Parser.&lt;lambda&gt;&gt;, &#x27;DAY_OF_MONTH&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DayOfMonth&#x27;&gt;&gt;, &#x27;DAYOFMONTH&#x27;: &lt;function Spark2.Parser.&lt;lambda&gt;&gt;, &#x27;DAY_OF_WEEK&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DayOfWeek&#x27;&gt;&gt;, &#x27;DAYOFWEEK&#x27;: &lt;function Spark2.Parser.&lt;lambda&gt;&gt;, &#x27;DAY_OF_YEAR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DayOfYear&#x27;&gt;&gt;, &#x27;DAYOFYEAR&#x27;: &lt;function Spark2.Parser.&lt;lambda&gt;&gt;, &#x27;DECODE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Decode&#x27;&gt;&gt;, &#x27;DI_TO_DATE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DiToDate&#x27;&gt;&gt;, &#x27;ENCODE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Encode&#x27;&gt;&gt;, &#x27;EXP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Exp&#x27;&gt;&gt;, &#x27;EXPLODE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Explode&#x27;&gt;&gt;, &#x27;EXPLODE_OUTER&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ExplodeOuter&#x27;&gt;&gt;, &#x27;EXTRACT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Extract&#x27;&gt;&gt;, &#x27;FIRST&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.First&#x27;&gt;&gt;, &#x27;FLATTEN&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Flatten&#x27;&gt;&gt;, &#x27;FLOOR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Floor&#x27;&gt;&gt;, &#x27;FROM_BASE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.FromBase&#x27;&gt;&gt;, &#x27;FROM_BASE64&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.FromBase64&#x27;&gt;&gt;, &#x27;GENERATE_SERIES&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.GenerateSeries&#x27;&gt;&gt;, &#x27;GREATEST&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Greatest&#x27;&gt;&gt;, &#x27;GROUP_CONCAT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.GroupConcat&#x27;&gt;&gt;, &#x27;HEX&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Hex&#x27;&gt;&gt;, &#x27;HLL&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Hll&#x27;&gt;&gt;, &#x27;IF&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.If&#x27;&gt;&gt;, &#x27;INITCAP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Initcap&#x27;&gt;&gt;, &#x27;IS_NAN&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.IsNan&#x27;&gt;&gt;, &#x27;ISNAN&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.IsNan&#x27;&gt;&gt;, &#x27;J_S_O_N_ARRAY&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.JSONArray&#x27;&gt;&gt;, &#x27;J_S_O_N_ARRAY_AGG&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.JSONArrayAgg&#x27;&gt;&gt;, &#x27;JSON_ARRAY_CONTAINS&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.JSONArrayContains&#x27;&gt;&gt;, &#x27;JSONB_EXTRACT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.JSONBExtract&#x27;&gt;&gt;, &#x27;JSONB_EXTRACT_SCALAR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.JSONBExtractScalar&#x27;&gt;&gt;, &#x27;JSON_EXTRACT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.JSONExtract&#x27;&gt;&gt;, &#x27;JSON_EXTRACT_SCALAR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.JSONExtractScalar&#x27;&gt;&gt;, &#x27;JSON_FORMAT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.JSONFormat&#x27;&gt;&gt;, &#x27;J_S_O_N_OBJECT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.JSONObject&#x27;&gt;&gt;, &#x27;J_S_O_N_TABLE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.JSONTable&#x27;&gt;&gt;, &#x27;LAST&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Last&#x27;&gt;&gt;, &#x27;LAST_DATE_OF_MONTH&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.LastDateOfMonth&#x27;&gt;&gt;, &#x27;LEAST&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Least&#x27;&gt;&gt;, &#x27;LEFT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Left&#x27;&gt;&gt;, &#x27;LENGTH&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Length&#x27;&gt;&gt;, &#x27;LEN&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Length&#x27;&gt;&gt;, &#x27;LEVENSHTEIN&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Levenshtein&#x27;&gt;&gt;, &#x27;LN&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Ln&#x27;&gt;&gt;, &#x27;LOG&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Log&#x27;&gt;&gt;, &#x27;LOG10&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Log10&#x27;&gt;&gt;, &#x27;LOG2&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Log2&#x27;&gt;&gt;, &#x27;LOGICAL_AND&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.LogicalAnd&#x27;&gt;&gt;, &#x27;BOOL_AND&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.LogicalAnd&#x27;&gt;&gt;, &#x27;BOOLAND_AGG&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.LogicalAnd&#x27;&gt;&gt;, &#x27;LOGICAL_OR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.LogicalOr&#x27;&gt;&gt;, &#x27;BOOL_OR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.LogicalOr&#x27;&gt;&gt;, &#x27;BOOLOR_AGG&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.LogicalOr&#x27;&gt;&gt;, &#x27;LOWER&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Lower&#x27;&gt;&gt;, &#x27;LCASE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Lower&#x27;&gt;&gt;, &#x27;MD5&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.MD5&#x27;&gt;&gt;, &#x27;MD5_DIGEST&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.MD5Digest&#x27;&gt;&gt;, &#x27;MAP&#x27;: &lt;function parse_var_map&gt;, &#x27;MAP_FROM_ENTRIES&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.MapFromEntries&#x27;&gt;&gt;, &#x27;MATCH_AGAINST&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.MatchAgainst&#x27;&gt;&gt;, &#x27;MAX&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Max&#x27;&gt;&gt;, &#x27;MIN&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Min&#x27;&gt;&gt;, &#x27;MONTH&#x27;: &lt;function Hive.Parser.&lt;lambda&gt;&gt;, &#x27;MONTHS_BETWEEN&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.MonthsBetween&#x27;&gt;&gt;, &#x27;NEXT_VALUE_FOR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.NextValueFor&#x27;&gt;&gt;, &#x27;NUMBER_TO_STR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.NumberToStr&#x27;&gt;&gt;, &#x27;NVL2&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Nvl2&#x27;&gt;&gt;, &#x27;OPEN_J_S_O_N&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.OpenJSON&#x27;&gt;&gt;, &#x27;PARAMETERIZED_AGG&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ParameterizedAgg&#x27;&gt;&gt;, &#x27;PARSE_JSON&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ParseJSON&#x27;&gt;&gt;, &#x27;JSON_PARSE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ParseJSON&#x27;&gt;&gt;, &#x27;PERCENTILE_CONT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.PercentileCont&#x27;&gt;&gt;, &#x27;PERCENTILE_DISC&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.PercentileDisc&#x27;&gt;&gt;, &#x27;POSEXPLODE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Posexplode&#x27;&gt;&gt;, &#x27;POSEXPLODE_OUTER&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.PosexplodeOuter&#x27;&gt;&gt;, &#x27;POWER&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Pow&#x27;&gt;&gt;, &#x27;POW&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Pow&#x27;&gt;&gt;, &#x27;PREDICT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Predict&#x27;&gt;&gt;, &#x27;QUANTILE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Quantile&#x27;&gt;&gt;, &#x27;RANGE_N&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.RangeN&#x27;&gt;&gt;, &#x27;READ_CSV&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ReadCSV&#x27;&gt;&gt;, &#x27;REDUCE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Reduce&#x27;&gt;&gt;, &#x27;REGEXP_EXTRACT&#x27;: &lt;function Hive.Parser.&lt;lambda&gt;&gt;, &#x27;REGEXP_I_LIKE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.RegexpILike&#x27;&gt;&gt;, &#x27;REGEXP_LIKE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.RegexpLike&#x27;&gt;&gt;, &#x27;REGEXP_REPLACE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.RegexpReplace&#x27;&gt;&gt;, &#x27;REGEXP_SPLIT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.RegexpSplit&#x27;&gt;&gt;, &#x27;REPEAT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Repeat&#x27;&gt;&gt;, &#x27;RIGHT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Right&#x27;&gt;&gt;, &#x27;ROUND&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Round&#x27;&gt;&gt;, &#x27;ROW_NUMBER&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.RowNumber&#x27;&gt;&gt;, &#x27;SHA&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.SHA&#x27;&gt;&gt;, &#x27;SHA1&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.SHA&#x27;&gt;&gt;, &#x27;SHA2&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.SHA2&#x27;&gt;&gt;, &#x27;SAFE_CONCAT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.SafeConcat&#x27;&gt;&gt;, &#x27;SAFE_DIVIDE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.SafeDivide&#x27;&gt;&gt;, &#x27;SET_AGG&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.SetAgg&#x27;&gt;&gt;, &#x27;SORT_ARRAY&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.SortArray&#x27;&gt;&gt;, &#x27;SPLIT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.RegexpSplit&#x27;&gt;&gt;, &#x27;SQRT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Sqrt&#x27;&gt;&gt;, &#x27;STANDARD_HASH&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StandardHash&#x27;&gt;&gt;, &#x27;STAR_MAP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StarMap&#x27;&gt;&gt;, &#x27;STARTS_WITH&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StartsWith&#x27;&gt;&gt;, &#x27;STARTSWITH&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StartsWith&#x27;&gt;&gt;, &#x27;STDDEV&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Stddev&#x27;&gt;&gt;, &#x27;STDDEV_POP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StddevPop&#x27;&gt;&gt;, &#x27;STDDEV_SAMP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StddevSamp&#x27;&gt;&gt;, &#x27;STR_POSITION&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StrPosition&#x27;&gt;&gt;, &#x27;STR_TO_DATE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StrToDate&#x27;&gt;&gt;, &#x27;STR_TO_MAP&#x27;: &lt;function Hive.Parser.&lt;lambda&gt;&gt;, &#x27;STR_TO_TIME&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StrToTime&#x27;&gt;&gt;, &#x27;STR_TO_UNIX&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StrToUnix&#x27;&gt;&gt;, &#x27;STRUCT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Struct&#x27;&gt;&gt;, &#x27;STRUCT_EXTRACT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StructExtract&#x27;&gt;&gt;, &#x27;STUFF&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Stuff&#x27;&gt;&gt;, &#x27;INSERT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Stuff&#x27;&gt;&gt;, &#x27;SUBSTRING&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Substring&#x27;&gt;&gt;, &#x27;SUM&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Sum&#x27;&gt;&gt;, &#x27;TIME_ADD&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimeAdd&#x27;&gt;&gt;, &#x27;TIME_DIFF&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimeDiff&#x27;&gt;&gt;, &#x27;TIME_STR_TO_DATE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimeStrToDate&#x27;&gt;&gt;, &#x27;TIME_STR_TO_TIME&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimeStrToTime&#x27;&gt;&gt;, &#x27;TIME_STR_TO_UNIX&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimeStrToUnix&#x27;&gt;&gt;, &#x27;TIME_SUB&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimeSub&#x27;&gt;&gt;, &#x27;TIME_TO_STR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimeToStr&#x27;&gt;&gt;, &#x27;TIME_TO_TIME_STR&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;TIME_TO_UNIX&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimeToUnix&#x27;&gt;&gt;, &#x27;TIME_TRUNC&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimeTrunc&#x27;&gt;&gt;, &#x27;TIMESTAMP&#x27;: &lt;function _parse_as_cast.&lt;locals&gt;.&lt;lambda&gt;&gt;, &#x27;TIMESTAMP_ADD&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimestampAdd&#x27;&gt;&gt;, &#x27;TIMESTAMP_DIFF&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimestampDiff&#x27;&gt;&gt;, &#x27;TIMESTAMP_SUB&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimestampSub&#x27;&gt;&gt;, &#x27;TIMESTAMP_TRUNC&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimestampTrunc&#x27;&gt;&gt;, &#x27;TO_BASE64&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ToBase64&#x27;&gt;&gt;, &#x27;TO_CHAR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ToChar&#x27;&gt;&gt;, &#x27;TO_DAYS&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ToDays&#x27;&gt;&gt;, &#x27;TRANSFORM&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Transform&#x27;&gt;&gt;, &#x27;TRIM&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Trim&#x27;&gt;&gt;, &#x27;TRY_CAST&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TryCast&#x27;&gt;&gt;, &#x27;TS_OR_DI_TO_DI&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TsOrDiToDi&#x27;&gt;&gt;, &#x27;TS_OR_DS_ADD&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TsOrDsAdd&#x27;&gt;&gt;, &#x27;TS_OR_DS_TO_DATE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TsOrDsToDate&#x27;&gt;&gt;, &#x27;TS_OR_DS_TO_DATE_STR&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;UNHEX&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Unhex&#x27;&gt;&gt;, &#x27;UNIX_TO_STR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.UnixToStr&#x27;&gt;&gt;, &#x27;UNIX_TO_TIME&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.UnixToTime&#x27;&gt;&gt;, &#x27;UNIX_TO_TIME_STR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.UnixToTimeStr&#x27;&gt;&gt;, &#x27;UPPER&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Upper&#x27;&gt;&gt;, &#x27;UCASE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Upper&#x27;&gt;&gt;, &#x27;VAR_MAP&#x27;: &lt;function parse_var_map&gt;, &#x27;VARIANCE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Variance&#x27;&gt;&gt;, &#x27;VARIANCE_SAMP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Variance&#x27;&gt;&gt;, &#x27;VAR_SAMP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Variance&#x27;&gt;&gt;, &#x27;VARIANCE_POP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.VariancePop&#x27;&gt;&gt;, &#x27;VAR_POP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.VariancePop&#x27;&gt;&gt;, &#x27;WEEK&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Week&#x27;&gt;&gt;, &#x27;WEEK_OF_YEAR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.WeekOfYear&#x27;&gt;&gt;, &#x27;WEEKOFYEAR&#x27;: &lt;function Spark2.Parser.&lt;lambda&gt;&gt;, &#x27;WHEN&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.When&#x27;&gt;&gt;, &#x27;X_M_L_TABLE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.XMLTable&#x27;&gt;&gt;, &#x27;XOR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Xor&#x27;&gt;&gt;, &#x27;YEAR&#x27;: &lt;function Hive.Parser.&lt;lambda&gt;&gt;, &#x27;GLOB&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;LIKE&#x27;: &lt;function parse_like&gt;, &#x27;BASE64&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ToBase64&#x27;&gt;&gt;, &#x27;COLLECT_LIST&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArrayAgg&#x27;&gt;&gt;, &#x27;COLLECT_SET&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.SetAgg&#x27;&gt;&gt;, &#x27;DATE_FORMAT&#x27;: &lt;function Hive.Parser.&lt;lambda&gt;&gt;, &#x27;FROM_UNIXTIME&#x27;: &lt;function format_time_lambda.&lt;locals&gt;._format_time&gt;, &#x27;GET_JSON_OBJECT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.JSONExtractScalar&#x27;&gt;&gt;, &#x27;LOCATE&#x27;: &lt;function locate_to_strposition&gt;, &#x27;PERCENTILE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Quantile&#x27;&gt;&gt;, &#x27;PERCENTILE_APPROX&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ApproxQuantile&#x27;&gt;&gt;, &#x27;SIZE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArraySize&#x27;&gt;&gt;, &#x27;TO_DATE&#x27;: &lt;function format_time_lambda.&lt;locals&gt;._format_time&gt;, &#x27;TO_JSON&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.JSONFormat&#x27;&gt;&gt;, &#x27;UNBASE64&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.FromBase64&#x27;&gt;&gt;, &#x27;UNIX_TIMESTAMP&#x27;: &lt;function format_time_lambda.&lt;locals&gt;._format_time&gt;, &#x27;AGGREGATE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Reduce&#x27;&gt;&gt;, &#x27;APPROX_PERCENTILE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ApproxQuantile&#x27;&gt;&gt;, &#x27;BOOLEAN&#x27;: &lt;function _parse_as_cast.&lt;locals&gt;.&lt;lambda&gt;&gt;, &#x27;DOUBLE&#x27;: &lt;function _parse_as_cast.&lt;locals&gt;.&lt;lambda&gt;&gt;, &#x27;FLOAT&#x27;: &lt;function _parse_as_cast.&lt;locals&gt;.&lt;lambda&gt;&gt;, &#x27;FROM_UTC_TIMESTAMP&#x27;: &lt;function Spark2.Parser.&lt;lambda&gt;&gt;, &#x27;IIF&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.If&#x27;&gt;&gt;, &#x27;INT&#x27;: &lt;function _parse_as_cast.&lt;locals&gt;.&lt;lambda&gt;&gt;, &#x27;MAP_FROM_ARRAYS&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Map&#x27;&gt;&gt;, &#x27;RLIKE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.RegexpLike&#x27;&gt;&gt;, &#x27;SHIFTLEFT&#x27;: &lt;function binary_from_function.&lt;locals&gt;.&lt;lambda&gt;&gt;, &#x27;SHIFTRIGHT&#x27;: &lt;function binary_from_function.&lt;locals&gt;.&lt;lambda&gt;&gt;, &#x27;STRING&#x27;: &lt;function _parse_as_cast.&lt;locals&gt;.&lt;lambda&gt;&gt;, &#x27;TO_TIMESTAMP&#x27;: &lt;function Spark2.Parser.&lt;lambda&gt;&gt;, &#x27;TO_UNIX_TIMESTAMP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StrToUnix&#x27;&gt;&gt;, &#x27;TRUNC&#x27;: &lt;function Spark2.Parser.&lt;lambda&gt;&gt;, &#x27;DATEADD&#x27;: &lt;function parse_date_delta.&lt;locals&gt;.inner_func&gt;}"}, "sqlglot.dialects.databricks.Databricks.Parser.FACTOR": {"fullname": "sqlglot.dialects.databricks.Databricks.Parser.FACTOR", "modulename": "sqlglot.dialects.databricks", "qualname": "Databricks.Parser.FACTOR", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&lt;TokenType.DIV: &#x27;DIV&#x27;&gt;: &lt;class &#x27;sqlglot.expressions.IntDiv&#x27;&gt;, &lt;TokenType.LR_ARROW: &#x27;LR_ARROW&#x27;&gt;: &lt;class &#x27;sqlglot.expressions.Distance&#x27;&gt;, &lt;TokenType.SLASH: &#x27;SLASH&#x27;&gt;: &lt;class &#x27;sqlglot.expressions.Div&#x27;&gt;, &lt;TokenType.STAR: &#x27;STAR&#x27;&gt;: &lt;class &#x27;sqlglot.expressions.Mul&#x27;&gt;, &lt;TokenType.COLON: &#x27;COLON&#x27;&gt;: &lt;class &#x27;sqlglot.expressions.JSONExtract&#x27;&gt;}"}, "sqlglot.dialects.databricks.Databricks.Parser.TOKENIZER_CLASS": {"fullname": "sqlglot.dialects.databricks.Databricks.Parser.TOKENIZER_CLASS", "modulename": "sqlglot.dialects.databricks", "qualname": "Databricks.Parser.TOKENIZER_CLASS", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Type[sqlglot.tokens.Tokenizer]", "default_value": "&lt;class &#x27;sqlglot.dialects.databricks.Databricks.Tokenizer&#x27;&gt;"}, "sqlglot.dialects.databricks.Databricks.Parser.SHOW_TRIE": {"fullname": "sqlglot.dialects.databricks.Databricks.Parser.SHOW_TRIE", "modulename": "sqlglot.dialects.databricks", "qualname": "Databricks.Parser.SHOW_TRIE", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict", "default_value": "{}"}, "sqlglot.dialects.databricks.Databricks.Parser.SET_TRIE": {"fullname": "sqlglot.dialects.databricks.Databricks.Parser.SET_TRIE", "modulename": "sqlglot.dialects.databricks", "qualname": "Databricks.Parser.SET_TRIE", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict", "default_value": "{&#x27;GLOBAL&#x27;: {0: True}, &#x27;LOCAL&#x27;: {0: True}, &#x27;SESSION&#x27;: {0: True}, &#x27;TRANSACTION&#x27;: {0: True}}"}, "sqlglot.dialects.databricks.Databricks.Parser.FORMAT_TRIE": {"fullname": "sqlglot.dialects.databricks.Databricks.Parser.FORMAT_TRIE", "modulename": "sqlglot.dialects.databricks", "qualname": "Databricks.Parser.FORMAT_TRIE", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict", "default_value": "{&#x27;y&#x27;: {0: True, &#x27;y&#x27;: {&#x27;y&#x27;: {&#x27;y&#x27;: {0: True}}, 0: True}}, &#x27;Y&#x27;: {0: True, &#x27;Y&#x27;: {&#x27;Y&#x27;: {&#x27;Y&#x27;: {0: True}}, 0: True}}, &#x27;M&#x27;: {&#x27;M&#x27;: {&#x27;M&#x27;: {&#x27;M&#x27;: {0: True}, 0: True}, 0: True}, 0: True}, &#x27;d&#x27;: {&#x27;d&#x27;: {0: True}, 0: True}, &#x27;H&#x27;: {&#x27;H&#x27;: {0: True}, 0: True}, &#x27;h&#x27;: {&#x27;h&#x27;: {0: True}, 0: True}, &#x27;m&#x27;: {&#x27;m&#x27;: {0: True}, 0: True}, &#x27;s&#x27;: {&#x27;s&#x27;: {0: True}, 0: True}, &#x27;S&#x27;: {&#x27;S&#x27;: {&#x27;S&#x27;: {&#x27;S&#x27;: {&#x27;S&#x27;: {&#x27;S&#x27;: {0: True}}}}}}, &#x27;a&#x27;: {0: True}, &#x27;D&#x27;: {&#x27;D&#x27;: {0: True}, 0: True}, &#x27;E&#x27;: {0: True, &#x27;E&#x27;: {0: True, &#x27;E&#x27;: {0: True, &#x27;E&#x27;: {0: True}}}}}"}, "sqlglot.dialects.databricks.Databricks.Parser.TIME_TRIE": {"fullname": "sqlglot.dialects.databricks.Databricks.Parser.TIME_TRIE", "modulename": "sqlglot.dialects.databricks", "qualname": "Databricks.Parser.TIME_TRIE", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict", "default_value": "{&#x27;y&#x27;: {0: True, &#x27;y&#x27;: {&#x27;y&#x27;: {&#x27;y&#x27;: {0: True}}, 0: True}}, &#x27;Y&#x27;: {0: True, &#x27;Y&#x27;: {&#x27;Y&#x27;: {&#x27;Y&#x27;: {0: True}}, 0: True}}, &#x27;M&#x27;: {&#x27;M&#x27;: {&#x27;M&#x27;: {&#x27;M&#x27;: {0: True}, 0: True}, 0: True}, 0: True}, &#x27;d&#x27;: {&#x27;d&#x27;: {0: True}, 0: True}, &#x27;H&#x27;: {&#x27;H&#x27;: {0: True}, 0: True}, &#x27;h&#x27;: {&#x27;h&#x27;: {0: True}, 0: True}, &#x27;m&#x27;: {&#x27;m&#x27;: {0: True}, 0: True}, &#x27;s&#x27;: {&#x27;s&#x27;: {0: True}, 0: True}, &#x27;S&#x27;: {&#x27;S&#x27;: {&#x27;S&#x27;: {&#x27;S&#x27;: {&#x27;S&#x27;: {&#x27;S&#x27;: {0: True}}}}}}, &#x27;a&#x27;: {0: True}, &#x27;D&#x27;: {&#x27;D&#x27;: {0: True}, 0: True}, &#x27;E&#x27;: {0: True, &#x27;E&#x27;: {0: True, &#x27;E&#x27;: {0: True, &#x27;E&#x27;: {0: True}}}}}"}, "sqlglot.dialects.databricks.Databricks.Generator": {"fullname": "sqlglot.dialects.databricks.Databricks.Generator", "modulename": "sqlglot.dialects.databricks", "qualname": "Databricks.Generator", "kind": "class", "doc": "<p>Generator converts a given syntax tree to the corresponding SQL string.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>pretty:</strong>  Whether or not to format the produced SQL string.\nDefault: False.</li>\n<li><strong>identify:</strong>  Determines when an identifier should be quoted. Possible values are:\nFalse (default): Never quote, except in cases where it's mandatory by the dialect.\nTrue or 'always': Always quote.\n'safe': Only quote identifiers that are case insensitive.</li>\n<li><strong>normalize:</strong>  Whether or not to normalize identifiers to lowercase.\nDefault: False.</li>\n<li><strong>pad:</strong>  Determines the pad size in a formatted string.\nDefault: 2.</li>\n<li><strong>indent:</strong>  Determines the indentation size in a formatted string.\nDefault: 2.</li>\n<li><strong>normalize_functions:</strong>  Whether or not to normalize all function names. Possible values are:\n\"upper\" or True (default): Convert names to uppercase.\n\"lower\": Convert names to lowercase.\nFalse: Disables function name normalization.</li>\n<li><strong>unsupported_level:</strong>  Determines the generator's behavior when it encounters unsupported expressions.\nDefault ErrorLevel.WARN.</li>\n<li><strong>max_unsupported:</strong>  Maximum number of unsupported messages to include in a raised UnsupportedError.\nThis is only relevant if unsupported_level is ErrorLevel.RAISE.\nDefault: 3</li>\n<li><strong>leading_comma:</strong>  Determines whether or not the comma is leading or trailing in select expressions.\nThis is only relevant when generating in pretty mode.\nDefault: False</li>\n<li><strong>max_text_width:</strong>  The max number of characters in a segment before creating new lines in pretty mode.\nThe default is on the smaller end because the length only represents a segment and not the true\nline length.\nDefault: 80</li>\n<li><strong>comments:</strong>  Whether or not to preserve comments in the output SQL code.\nDefault: True</li>\n</ul>\n", "bases": "sqlglot.dialects.spark.Spark.Generator"}, "sqlglot.dialects.databricks.Databricks.Generator.TRANSFORMS": {"fullname": "sqlglot.dialects.databricks.Databricks.Generator.TRANSFORMS", "modulename": "sqlglot.dialects.databricks", "qualname": "Databricks.Generator.TRANSFORMS", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&lt;class &#x27;sqlglot.expressions.DateAdd&#x27;&gt;: &lt;function generate_date_delta_with_unit_sql&gt;, &lt;class &#x27;sqlglot.expressions.TsOrDsAdd&#x27;&gt;: &lt;function Hive.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.CaseSpecificColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.CharacterSetColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.CharacterSetProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.CheckColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.ClusteredColumnConstraint&#x27;&gt;: &lt;function Hive.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.CollateColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.CopyGrantsProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.CommentColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.DateFormatColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.DefaultColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.EncodeColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.ExecuteAsProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.ExternalProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.HeapProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.InlineLengthColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.InputModelProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.IntervalSpan&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.LanguageProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.LocationProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.LogProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.MaterializedProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.NoPrimaryIndexProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.NonClusteredColumnConstraint&#x27;&gt;: &lt;function Hive.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.NotForReplicationColumnConstraint&#x27;&gt;: &lt;function Hive.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.OnCommitProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.OnProperty&#x27;&gt;: &lt;function Hive.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.OnUpdateColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.OutputModelProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.PathColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.RemoteWithConnectionModelProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.ReturnsProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.SampleProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.SetProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.SettingsProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.SqlSecurityProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.StabilityProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.TemporaryProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.ToTableProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.TransientProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.TransformModelProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.TitleColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.UppercaseColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.VarMap&#x27;&gt;: &lt;function var_map_sql&gt;, &lt;class &#x27;sqlglot.expressions.VolatileProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.WithJournalTableProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.Select&#x27;&gt;: &lt;function preprocess.&lt;locals&gt;._to_sql&gt;, &lt;class &#x27;sqlglot.expressions.Property&#x27;&gt;: &lt;function _property_sql&gt;, &lt;class &#x27;sqlglot.expressions.ApproxDistinct&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.ArrayConcat&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.ArraySize&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.With&#x27;&gt;: &lt;function no_recursive_cte_sql&gt;, &lt;class &#x27;sqlglot.expressions.DateStrToDate&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.DateSub&#x27;&gt;: &lt;function _add_date_sql&gt;, &lt;class &#x27;sqlglot.expressions.DateToDi&#x27;&gt;: &lt;function Hive.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.DiToDate&#x27;&gt;: &lt;function Hive.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.FileFormatProperty&#x27;&gt;: &lt;function Spark2.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.FromBase64&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.If&#x27;&gt;: &lt;function if_sql.&lt;locals&gt;._if_sql&gt;, &lt;class &#x27;sqlglot.expressions.IsNan&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.JSONExtract&#x27;&gt;: &lt;function Databricks.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.JSONExtractScalar&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.JSONFormat&#x27;&gt;: &lt;function _json_format_sql&gt;, &lt;class &#x27;sqlglot.expressions.Map&#x27;&gt;: &lt;function _map_sql&gt;, &lt;class &#x27;sqlglot.expressions.Max&#x27;&gt;: &lt;function max_or_greatest&gt;, &lt;class &#x27;sqlglot.expressions.MD5Digest&#x27;&gt;: &lt;function Hive.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.Min&#x27;&gt;: &lt;function min_or_least&gt;, &lt;class &#x27;sqlglot.expressions.NotNullColumnConstraint&#x27;&gt;: &lt;function Hive.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.Create&#x27;&gt;: &lt;function _create_sql&gt;, &lt;class &#x27;sqlglot.expressions.Quantile&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.ApproxQuantile&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.RegexpExtract&#x27;&gt;: &lt;function regexp_extract_sql&gt;, &lt;class &#x27;sqlglot.expressions.RegexpReplace&#x27;&gt;: &lt;function Spark2.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.RegexpLike&#x27;&gt;: &lt;function Hive.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.RegexpSplit&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.SafeDivide&#x27;&gt;: &lt;function no_safe_divide_sql&gt;, &lt;class &#x27;sqlglot.expressions.SchemaCommentProperty&#x27;&gt;: &lt;function Hive.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.SetAgg&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.Split&#x27;&gt;: &lt;function Hive.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.StrPosition&#x27;&gt;: &lt;function strposition_to_locate_sql&gt;, &lt;class &#x27;sqlglot.expressions.StrToDate&#x27;&gt;: &lt;function _str_to_date&gt;, &lt;class &#x27;sqlglot.expressions.StrToTime&#x27;&gt;: &lt;function Spark2.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.StrToUnix&#x27;&gt;: &lt;function _str_to_unix_sql&gt;, &lt;class &#x27;sqlglot.expressions.StructExtract&#x27;&gt;: &lt;function struct_extract_sql&gt;, &lt;class &#x27;sqlglot.expressions.TimeStrToDate&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.TimeStrToTime&#x27;&gt;: &lt;function timestrtotime_sql&gt;, &lt;class &#x27;sqlglot.expressions.TimeStrToUnix&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.TimeToStr&#x27;&gt;: &lt;function _time_to_str&gt;, &lt;class &#x27;sqlglot.expressions.TimeToUnix&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.ToBase64&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.TsOrDiToDi&#x27;&gt;: &lt;function Hive.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.TsOrDsToDate&#x27;&gt;: &lt;function _to_date_sql&gt;, &lt;class &#x27;sqlglot.expressions.UnixToStr&#x27;&gt;: &lt;function Hive.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.UnixToTime&#x27;&gt;: &lt;function _unix_to_time_sql&gt;, &lt;class &#x27;sqlglot.expressions.UnixToTimeStr&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.PartitionedByProperty&#x27;&gt;: &lt;function Hive.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.SerdeProperties&#x27;&gt;: &lt;function Hive.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.NumberToStr&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.LastDateOfMonth&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.National&#x27;&gt;: &lt;function Hive.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.PrimaryKeyColumnConstraint&#x27;&gt;: &lt;function Hive.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.ArraySum&#x27;&gt;: &lt;function Spark2.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.AtTimeZone&#x27;&gt;: &lt;function Spark2.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.BitwiseLeftShift&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.BitwiseRightShift&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.DateFromParts&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.DateTrunc&#x27;&gt;: &lt;function Spark2.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.DayOfMonth&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.DayOfWeek&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.DayOfYear&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.From&#x27;&gt;: &lt;function preprocess.&lt;locals&gt;._to_sql&gt;, &lt;class &#x27;sqlglot.expressions.Insert&#x27;&gt;: &lt;function move_insert_cte_sql&gt;, &lt;class &#x27;sqlglot.expressions.LogicalAnd&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.LogicalOr&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.Pivot&#x27;&gt;: &lt;function preprocess.&lt;locals&gt;._to_sql&gt;, &lt;class &#x27;sqlglot.expressions.Reduce&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.TimestampTrunc&#x27;&gt;: &lt;function Spark2.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.Trim&#x27;&gt;: &lt;function trim_sql&gt;, &lt;class &#x27;sqlglot.expressions.VariancePop&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.WeekOfYear&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.WithinGroup&#x27;&gt;: &lt;function preprocess.&lt;locals&gt;._to_sql&gt;, &lt;class &#x27;sqlglot.expressions.StartsWith&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.TimestampAdd&#x27;&gt;: &lt;function Spark.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.DateDiff&#x27;&gt;: &lt;function generate_date_delta_with_unit_sql&gt;, &lt;class &#x27;sqlglot.expressions.DatetimeAdd&#x27;&gt;: &lt;function Databricks.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.DatetimeSub&#x27;&gt;: &lt;function Databricks.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.DatetimeDiff&#x27;&gt;: &lt;function Databricks.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.DatetimeTrunc&#x27;&gt;: &lt;function timestamptrunc_sql&gt;, &lt;class &#x27;sqlglot.expressions.ToChar&#x27;&gt;: &lt;function Databricks.Generator.&lt;lambda&gt;&gt;}"}, "sqlglot.dialects.databricks.Databricks.Generator.columndef_sql": {"fullname": "sqlglot.dialects.databricks.Databricks.Generator.columndef_sql", "modulename": "sqlglot.dialects.databricks", "qualname": "Databricks.Generator.columndef_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">ColumnDef</span>, </span><span class=\"param\"><span class=\"n\">sep</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39; &#39;</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.databricks.Databricks.Generator.generatedasidentitycolumnconstraint_sql": {"fullname": "sqlglot.dialects.databricks.Databricks.Generator.generatedasidentitycolumnconstraint_sql", "modulename": "sqlglot.dialects.databricks", "qualname": "Databricks.Generator.generatedasidentitycolumnconstraint_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">GeneratedAsIdentityColumnConstraint</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.databricks.Databricks.Generator.SELECT_KINDS": {"fullname": "sqlglot.dialects.databricks.Databricks.Generator.SELECT_KINDS", "modulename": "sqlglot.dialects.databricks", "qualname": "Databricks.Generator.SELECT_KINDS", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Tuple[str, ...]", "default_value": "()"}, "sqlglot.dialects.databricks.Databricks.Generator.INVERSE_TIME_MAPPING": {"fullname": "sqlglot.dialects.databricks.Databricks.Generator.INVERSE_TIME_MAPPING", "modulename": "sqlglot.dialects.databricks", "qualname": "Databricks.Generator.INVERSE_TIME_MAPPING", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict[str, str]", "default_value": "{&#x27;%Y&#x27;: &#x27;yyyy&#x27;, &#x27;%y&#x27;: &#x27;yy&#x27;, &#x27;%B&#x27;: &#x27;MMMM&#x27;, &#x27;%b&#x27;: &#x27;MMM&#x27;, &#x27;%m&#x27;: &#x27;MM&#x27;, &#x27;%-m&#x27;: &#x27;M&#x27;, &#x27;%d&#x27;: &#x27;dd&#x27;, &#x27;%-d&#x27;: &#x27;d&#x27;, &#x27;%H&#x27;: &#x27;HH&#x27;, &#x27;%-H&#x27;: &#x27;H&#x27;, &#x27;%I&#x27;: &#x27;hh&#x27;, &#x27;%-I&#x27;: &#x27;h&#x27;, &#x27;%M&#x27;: &#x27;mm&#x27;, &#x27;%-M&#x27;: &#x27;m&#x27;, &#x27;%S&#x27;: &#x27;ss&#x27;, &#x27;%-S&#x27;: &#x27;s&#x27;, &#x27;%f&#x27;: &#x27;SSSSSS&#x27;, &#x27;%p&#x27;: &#x27;a&#x27;, &#x27;%j&#x27;: &#x27;DD&#x27;, &#x27;%-j&#x27;: &#x27;D&#x27;, &#x27;%a&#x27;: &#x27;EEE&#x27;, &#x27;%A&#x27;: &#x27;EEEE&#x27;}"}, "sqlglot.dialects.databricks.Databricks.Generator.INVERSE_TIME_TRIE": {"fullname": "sqlglot.dialects.databricks.Databricks.Generator.INVERSE_TIME_TRIE", "modulename": "sqlglot.dialects.databricks", "qualname": "Databricks.Generator.INVERSE_TIME_TRIE", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict", "default_value": "{&#x27;%&#x27;: {&#x27;Y&#x27;: {0: True}, &#x27;y&#x27;: {0: True}, &#x27;B&#x27;: {0: True}, &#x27;b&#x27;: {0: True}, &#x27;m&#x27;: {0: True}, &#x27;-&#x27;: {&#x27;m&#x27;: {0: True}, &#x27;d&#x27;: {0: True}, &#x27;H&#x27;: {0: True}, &#x27;I&#x27;: {0: True}, &#x27;M&#x27;: {0: True}, &#x27;S&#x27;: {0: True}, &#x27;j&#x27;: {0: True}}, &#x27;d&#x27;: {0: True}, &#x27;H&#x27;: {0: True}, &#x27;I&#x27;: {0: True}, &#x27;M&#x27;: {0: True}, &#x27;S&#x27;: {0: True}, &#x27;f&#x27;: {0: True}, &#x27;p&#x27;: {0: True}, &#x27;j&#x27;: {0: True}, &#x27;a&#x27;: {0: True}, &#x27;A&#x27;: {0: True}}}"}, "sqlglot.dialects.databricks.Databricks.Generator.INVERSE_ESCAPE_SEQUENCES": {"fullname": "sqlglot.dialects.databricks.Databricks.Generator.INVERSE_ESCAPE_SEQUENCES", "modulename": "sqlglot.dialects.databricks", "qualname": "Databricks.Generator.INVERSE_ESCAPE_SEQUENCES", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict[str, str]", "default_value": "{}"}, "sqlglot.dialects.databricks.Databricks.Generator.can_identify": {"fullname": "sqlglot.dialects.databricks.Databricks.Generator.can_identify", "modulename": "sqlglot.dialects.databricks", "qualname": "Databricks.Generator.can_identify", "kind": "function", "doc": "<p>Checks if text can be identified given an identify option.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>text:</strong>  The text to check.</li>\n<li><strong>identify:</strong>  \"always\" or <code>True</code>: Always returns true.\n\"safe\": True if the identifier is case-insensitive.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>Whether or not the given text can be identified.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">text</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">identify</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;safe&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.databricks.Databricks.Generator.QUOTE_START": {"fullname": "sqlglot.dialects.databricks.Databricks.Generator.QUOTE_START", "modulename": "sqlglot.dialects.databricks", "qualname": "Databricks.Generator.QUOTE_START", "kind": "variable", "doc": "<p></p>\n", "default_value": "&quot;&#x27;&quot;"}, "sqlglot.dialects.databricks.Databricks.Generator.QUOTE_END": {"fullname": "sqlglot.dialects.databricks.Databricks.Generator.QUOTE_END", "modulename": "sqlglot.dialects.databricks", "qualname": "Databricks.Generator.QUOTE_END", "kind": "variable", "doc": "<p></p>\n", "default_value": "&quot;&#x27;&quot;"}, "sqlglot.dialects.databricks.Databricks.Generator.IDENTIFIER_START": {"fullname": "sqlglot.dialects.databricks.Databricks.Generator.IDENTIFIER_START", "modulename": "sqlglot.dialects.databricks", "qualname": "Databricks.Generator.IDENTIFIER_START", "kind": "variable", "doc": "<p></p>\n", "default_value": "&#x27;`&#x27;"}, "sqlglot.dialects.databricks.Databricks.Generator.IDENTIFIER_END": {"fullname": "sqlglot.dialects.databricks.Databricks.Generator.IDENTIFIER_END", "modulename": "sqlglot.dialects.databricks", "qualname": "Databricks.Generator.IDENTIFIER_END", "kind": "variable", "doc": "<p></p>\n", "default_value": "&#x27;`&#x27;"}, "sqlglot.dialects.databricks.Databricks.Generator.TOKENIZER_CLASS": {"fullname": "sqlglot.dialects.databricks.Databricks.Generator.TOKENIZER_CLASS", "modulename": "sqlglot.dialects.databricks", "qualname": "Databricks.Generator.TOKENIZER_CLASS", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;class &#x27;sqlglot.dialects.databricks.Databricks.Tokenizer&#x27;&gt;"}, "sqlglot.dialects.databricks.Databricks.Generator.BIT_START": {"fullname": "sqlglot.dialects.databricks.Databricks.Generator.BIT_START", "modulename": "sqlglot.dialects.databricks", "qualname": "Databricks.Generator.BIT_START", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Optional[str]", "default_value": "None"}, "sqlglot.dialects.databricks.Databricks.Generator.BIT_END": {"fullname": "sqlglot.dialects.databricks.Databricks.Generator.BIT_END", "modulename": "sqlglot.dialects.databricks", "qualname": "Databricks.Generator.BIT_END", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Optional[str]", "default_value": "None"}, "sqlglot.dialects.databricks.Databricks.Generator.HEX_START": {"fullname": "sqlglot.dialects.databricks.Databricks.Generator.HEX_START", "modulename": "sqlglot.dialects.databricks", "qualname": "Databricks.Generator.HEX_START", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Optional[str]", "default_value": "None"}, "sqlglot.dialects.databricks.Databricks.Generator.HEX_END": {"fullname": "sqlglot.dialects.databricks.Databricks.Generator.HEX_END", "modulename": "sqlglot.dialects.databricks", "qualname": "Databricks.Generator.HEX_END", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Optional[str]", "default_value": "None"}, "sqlglot.dialects.databricks.Databricks.Generator.BYTE_START": {"fullname": "sqlglot.dialects.databricks.Databricks.Generator.BYTE_START", "modulename": "sqlglot.dialects.databricks", "qualname": "Databricks.Generator.BYTE_START", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Optional[str]", "default_value": "None"}, "sqlglot.dialects.databricks.Databricks.Generator.BYTE_END": {"fullname": "sqlglot.dialects.databricks.Databricks.Generator.BYTE_END", "modulename": "sqlglot.dialects.databricks", "qualname": "Databricks.Generator.BYTE_END", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Optional[str]", "default_value": "None"}, "sqlglot.dialects.databricks.Databricks.Tokenizer": {"fullname": "sqlglot.dialects.databricks.Databricks.Tokenizer", "modulename": "sqlglot.dialects.databricks", "qualname": "Databricks.Tokenizer", "kind": "class", "doc": "<p></p>\n", "bases": "sqlglot.dialects.spark.Spark.Tokenizer"}, "sqlglot.dialects.databricks.Databricks.Tokenizer.HEX_STRINGS": {"fullname": "sqlglot.dialects.databricks.Databricks.Tokenizer.HEX_STRINGS", "modulename": "sqlglot.dialects.databricks", "qualname": "Databricks.Tokenizer.HEX_STRINGS", "kind": "variable", "doc": "<p></p>\n", "default_value": "[]"}, "sqlglot.dialects.databricks.Databricks.Tokenizer.SINGLE_TOKENS": {"fullname": "sqlglot.dialects.databricks.Databricks.Tokenizer.SINGLE_TOKENS", "modulename": "sqlglot.dialects.databricks", "qualname": "Databricks.Tokenizer.SINGLE_TOKENS", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;(&#x27;: &lt;TokenType.L_PAREN: &#x27;L_PAREN&#x27;&gt;, &#x27;)&#x27;: &lt;TokenType.R_PAREN: &#x27;R_PAREN&#x27;&gt;, &#x27;[&#x27;: &lt;TokenType.L_BRACKET: &#x27;L_BRACKET&#x27;&gt;, &#x27;]&#x27;: &lt;TokenType.R_BRACKET: &#x27;R_BRACKET&#x27;&gt;, &#x27;{&#x27;: &lt;TokenType.L_BRACE: &#x27;L_BRACE&#x27;&gt;, &#x27;}&#x27;: &lt;TokenType.R_BRACE: &#x27;R_BRACE&#x27;&gt;, &#x27;&amp;&#x27;: &lt;TokenType.AMP: &#x27;AMP&#x27;&gt;, &#x27;^&#x27;: &lt;TokenType.CARET: &#x27;CARET&#x27;&gt;, &#x27;:&#x27;: &lt;TokenType.COLON: &#x27;COLON&#x27;&gt;, &#x27;,&#x27;: &lt;TokenType.COMMA: &#x27;COMMA&#x27;&gt;, &#x27;.&#x27;: &lt;TokenType.DOT: &#x27;DOT&#x27;&gt;, &#x27;-&#x27;: &lt;TokenType.DASH: &#x27;DASH&#x27;&gt;, &#x27;=&#x27;: &lt;TokenType.EQ: &#x27;EQ&#x27;&gt;, &#x27;&gt;&#x27;: &lt;TokenType.GT: &#x27;GT&#x27;&gt;, &#x27;&lt;&#x27;: &lt;TokenType.LT: &#x27;LT&#x27;&gt;, &#x27;%&#x27;: &lt;TokenType.MOD: &#x27;MOD&#x27;&gt;, &#x27;!&#x27;: &lt;TokenType.NOT: &#x27;NOT&#x27;&gt;, &#x27;|&#x27;: &lt;TokenType.PIPE: &#x27;PIPE&#x27;&gt;, &#x27;+&#x27;: &lt;TokenType.PLUS: &#x27;PLUS&#x27;&gt;, &#x27;;&#x27;: &lt;TokenType.SEMICOLON: &#x27;SEMICOLON&#x27;&gt;, &#x27;/&#x27;: &lt;TokenType.SLASH: &#x27;SLASH&#x27;&gt;, &#x27;\\\\&#x27;: &lt;TokenType.BACKSLASH: &#x27;BACKSLASH&#x27;&gt;, &#x27;*&#x27;: &lt;TokenType.STAR: &#x27;STAR&#x27;&gt;, &#x27;~&#x27;: &lt;TokenType.TILDA: &#x27;TILDA&#x27;&gt;, &#x27;?&#x27;: &lt;TokenType.PLACEHOLDER: &#x27;PLACEHOLDER&#x27;&gt;, &#x27;@&#x27;: &lt;TokenType.PARAMETER: &#x27;PARAMETER&#x27;&gt;, &quot;&#x27;&quot;: &lt;TokenType.QUOTE: &#x27;QUOTE&#x27;&gt;, &#x27;`&#x27;: &lt;TokenType.IDENTIFIER: &#x27;IDENTIFIER&#x27;&gt;, &#x27;&quot;&#x27;: &lt;TokenType.IDENTIFIER: &#x27;IDENTIFIER&#x27;&gt;, &#x27;#&#x27;: &lt;TokenType.HASH: &#x27;HASH&#x27;&gt;, &#x27;$&#x27;: &lt;TokenType.PARAMETER: &#x27;PARAMETER&#x27;&gt;}"}, "sqlglot.dialects.databricks.Databricks.tokenizer_class": {"fullname": "sqlglot.dialects.databricks.Databricks.tokenizer_class", "modulename": "sqlglot.dialects.databricks", "qualname": "Databricks.tokenizer_class", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;class &#x27;sqlglot.dialects.databricks.Databricks.Tokenizer&#x27;&gt;"}, "sqlglot.dialects.databricks.Databricks.parser_class": {"fullname": "sqlglot.dialects.databricks.Databricks.parser_class", "modulename": "sqlglot.dialects.databricks", "qualname": "Databricks.parser_class", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;class &#x27;sqlglot.dialects.databricks.Databricks.Parser&#x27;&gt;"}, "sqlglot.dialects.databricks.Databricks.generator_class": {"fullname": "sqlglot.dialects.databricks.Databricks.generator_class", "modulename": "sqlglot.dialects.databricks", "qualname": "Databricks.generator_class", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;class &#x27;sqlglot.dialects.databricks.Databricks.Generator&#x27;&gt;"}, "sqlglot.dialects.databricks.Databricks.TIME_TRIE": {"fullname": "sqlglot.dialects.databricks.Databricks.TIME_TRIE", "modulename": "sqlglot.dialects.databricks", "qualname": "Databricks.TIME_TRIE", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict", "default_value": "{&#x27;y&#x27;: {0: True, &#x27;y&#x27;: {&#x27;y&#x27;: {&#x27;y&#x27;: {0: True}}, 0: True}}, &#x27;Y&#x27;: {0: True, &#x27;Y&#x27;: {&#x27;Y&#x27;: {&#x27;Y&#x27;: {0: True}}, 0: True}}, &#x27;M&#x27;: {&#x27;M&#x27;: {&#x27;M&#x27;: {&#x27;M&#x27;: {0: True}, 0: True}, 0: True}, 0: True}, &#x27;d&#x27;: {&#x27;d&#x27;: {0: True}, 0: True}, &#x27;H&#x27;: {&#x27;H&#x27;: {0: True}, 0: True}, &#x27;h&#x27;: {&#x27;h&#x27;: {0: True}, 0: True}, &#x27;m&#x27;: {&#x27;m&#x27;: {0: True}, 0: True}, &#x27;s&#x27;: {&#x27;s&#x27;: {0: True}, 0: True}, &#x27;S&#x27;: {&#x27;S&#x27;: {&#x27;S&#x27;: {&#x27;S&#x27;: {&#x27;S&#x27;: {&#x27;S&#x27;: {0: True}}}}}}, &#x27;a&#x27;: {0: True}, &#x27;D&#x27;: {&#x27;D&#x27;: {0: True}, 0: True}, &#x27;E&#x27;: {0: True, &#x27;E&#x27;: {0: True, &#x27;E&#x27;: {0: True, &#x27;E&#x27;: {0: True}}}}}"}, "sqlglot.dialects.databricks.Databricks.FORMAT_TRIE": {"fullname": "sqlglot.dialects.databricks.Databricks.FORMAT_TRIE", "modulename": "sqlglot.dialects.databricks", "qualname": "Databricks.FORMAT_TRIE", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict", "default_value": "{&#x27;y&#x27;: {0: True, &#x27;y&#x27;: {&#x27;y&#x27;: {&#x27;y&#x27;: {0: True}}, 0: True}}, &#x27;Y&#x27;: {0: True, &#x27;Y&#x27;: {&#x27;Y&#x27;: {&#x27;Y&#x27;: {0: True}}, 0: True}}, &#x27;M&#x27;: {&#x27;M&#x27;: {&#x27;M&#x27;: {&#x27;M&#x27;: {0: True}, 0: True}, 0: True}, 0: True}, &#x27;d&#x27;: {&#x27;d&#x27;: {0: True}, 0: True}, &#x27;H&#x27;: {&#x27;H&#x27;: {0: True}, 0: True}, &#x27;h&#x27;: {&#x27;h&#x27;: {0: True}, 0: True}, &#x27;m&#x27;: {&#x27;m&#x27;: {0: True}, 0: True}, &#x27;s&#x27;: {&#x27;s&#x27;: {0: True}, 0: True}, &#x27;S&#x27;: {&#x27;S&#x27;: {&#x27;S&#x27;: {&#x27;S&#x27;: {&#x27;S&#x27;: {&#x27;S&#x27;: {0: True}}}}}}, &#x27;a&#x27;: {0: True}, &#x27;D&#x27;: {&#x27;D&#x27;: {0: True}, 0: True}, &#x27;E&#x27;: {0: True, &#x27;E&#x27;: {0: True, &#x27;E&#x27;: {0: True, &#x27;E&#x27;: {0: True}}}}}"}, "sqlglot.dialects.databricks.Databricks.INVERSE_TIME_MAPPING": {"fullname": "sqlglot.dialects.databricks.Databricks.INVERSE_TIME_MAPPING", "modulename": "sqlglot.dialects.databricks", "qualname": "Databricks.INVERSE_TIME_MAPPING", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict[str, str]", "default_value": "{&#x27;%Y&#x27;: &#x27;yyyy&#x27;, &#x27;%y&#x27;: &#x27;yy&#x27;, &#x27;%B&#x27;: &#x27;MMMM&#x27;, &#x27;%b&#x27;: &#x27;MMM&#x27;, &#x27;%m&#x27;: &#x27;MM&#x27;, &#x27;%-m&#x27;: &#x27;M&#x27;, &#x27;%d&#x27;: &#x27;dd&#x27;, &#x27;%-d&#x27;: &#x27;d&#x27;, &#x27;%H&#x27;: &#x27;HH&#x27;, &#x27;%-H&#x27;: &#x27;H&#x27;, &#x27;%I&#x27;: &#x27;hh&#x27;, &#x27;%-I&#x27;: &#x27;h&#x27;, &#x27;%M&#x27;: &#x27;mm&#x27;, &#x27;%-M&#x27;: &#x27;m&#x27;, &#x27;%S&#x27;: &#x27;ss&#x27;, &#x27;%-S&#x27;: &#x27;s&#x27;, &#x27;%f&#x27;: &#x27;SSSSSS&#x27;, &#x27;%p&#x27;: &#x27;a&#x27;, &#x27;%j&#x27;: &#x27;DD&#x27;, &#x27;%-j&#x27;: &#x27;D&#x27;, &#x27;%a&#x27;: &#x27;EEE&#x27;, &#x27;%A&#x27;: &#x27;EEEE&#x27;}"}, "sqlglot.dialects.databricks.Databricks.INVERSE_TIME_TRIE": {"fullname": "sqlglot.dialects.databricks.Databricks.INVERSE_TIME_TRIE", "modulename": "sqlglot.dialects.databricks", "qualname": "Databricks.INVERSE_TIME_TRIE", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict", "default_value": "{&#x27;%&#x27;: {&#x27;Y&#x27;: {0: True}, &#x27;y&#x27;: {0: True}, &#x27;B&#x27;: {0: True}, &#x27;b&#x27;: {0: True}, &#x27;m&#x27;: {0: True}, &#x27;-&#x27;: {&#x27;m&#x27;: {0: True}, &#x27;d&#x27;: {0: True}, &#x27;H&#x27;: {0: True}, &#x27;I&#x27;: {0: True}, &#x27;M&#x27;: {0: True}, &#x27;S&#x27;: {0: True}, &#x27;j&#x27;: {0: True}}, &#x27;d&#x27;: {0: True}, &#x27;H&#x27;: {0: True}, &#x27;I&#x27;: {0: True}, &#x27;M&#x27;: {0: True}, &#x27;S&#x27;: {0: True}, &#x27;f&#x27;: {0: True}, &#x27;p&#x27;: {0: True}, &#x27;j&#x27;: {0: True}, &#x27;a&#x27;: {0: True}, &#x27;A&#x27;: {0: True}}}"}, "sqlglot.dialects.databricks.Databricks.INVERSE_ESCAPE_SEQUENCES": {"fullname": "sqlglot.dialects.databricks.Databricks.INVERSE_ESCAPE_SEQUENCES", "modulename": "sqlglot.dialects.databricks", "qualname": "Databricks.INVERSE_ESCAPE_SEQUENCES", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict[str, str]", "default_value": "{}"}, "sqlglot.dialects.databricks.Databricks.QUOTE_START": {"fullname": "sqlglot.dialects.databricks.Databricks.QUOTE_START", "modulename": "sqlglot.dialects.databricks", "qualname": "Databricks.QUOTE_START", "kind": "variable", "doc": "<p></p>\n", "default_value": "&quot;&#x27;&quot;"}, "sqlglot.dialects.databricks.Databricks.QUOTE_END": {"fullname": "sqlglot.dialects.databricks.Databricks.QUOTE_END", "modulename": "sqlglot.dialects.databricks", "qualname": "Databricks.QUOTE_END", "kind": "variable", "doc": "<p></p>\n", "default_value": "&quot;&#x27;&quot;"}, "sqlglot.dialects.databricks.Databricks.IDENTIFIER_START": {"fullname": "sqlglot.dialects.databricks.Databricks.IDENTIFIER_START", "modulename": "sqlglot.dialects.databricks", "qualname": "Databricks.IDENTIFIER_START", "kind": "variable", "doc": "<p></p>\n", "default_value": "&#x27;`&#x27;"}, "sqlglot.dialects.databricks.Databricks.IDENTIFIER_END": {"fullname": "sqlglot.dialects.databricks.Databricks.IDENTIFIER_END", "modulename": "sqlglot.dialects.databricks", "qualname": "Databricks.IDENTIFIER_END", "kind": "variable", "doc": "<p></p>\n", "default_value": "&#x27;`&#x27;"}, "sqlglot.dialects.databricks.Databricks.BIT_START": {"fullname": "sqlglot.dialects.databricks.Databricks.BIT_START", "modulename": "sqlglot.dialects.databricks", "qualname": "Databricks.BIT_START", "kind": "variable", "doc": "<p></p>\n", "default_value": "None"}, "sqlglot.dialects.databricks.Databricks.BIT_END": {"fullname": "sqlglot.dialects.databricks.Databricks.BIT_END", "modulename": "sqlglot.dialects.databricks", "qualname": "Databricks.BIT_END", "kind": "variable", "doc": "<p></p>\n", "default_value": "None"}, "sqlglot.dialects.databricks.Databricks.HEX_START": {"fullname": "sqlglot.dialects.databricks.Databricks.HEX_START", "modulename": "sqlglot.dialects.databricks", "qualname": "Databricks.HEX_START", "kind": "variable", "doc": "<p></p>\n", "default_value": "None"}, "sqlglot.dialects.databricks.Databricks.HEX_END": {"fullname": "sqlglot.dialects.databricks.Databricks.HEX_END", "modulename": "sqlglot.dialects.databricks", "qualname": "Databricks.HEX_END", "kind": "variable", "doc": "<p></p>\n", "default_value": "None"}, "sqlglot.dialects.databricks.Databricks.BYTE_START": {"fullname": "sqlglot.dialects.databricks.Databricks.BYTE_START", "modulename": "sqlglot.dialects.databricks", "qualname": "Databricks.BYTE_START", "kind": "variable", "doc": "<p></p>\n", "default_value": "None"}, "sqlglot.dialects.databricks.Databricks.BYTE_END": {"fullname": "sqlglot.dialects.databricks.Databricks.BYTE_END", "modulename": "sqlglot.dialects.databricks", "qualname": "Databricks.BYTE_END", "kind": "variable", "doc": "<p></p>\n", "default_value": "None"}, "sqlglot.dialects.dialect": {"fullname": "sqlglot.dialects.dialect", "modulename": "sqlglot.dialects.dialect", "kind": "module", "doc": "<p></p>\n"}, "sqlglot.dialects.dialect.Dialects": {"fullname": "sqlglot.dialects.dialect.Dialects", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialects", "kind": "class", "doc": "<p>An enumeration.</p>\n", "bases": "builtins.str, enum.Enum"}, "sqlglot.dialects.dialect.Dialects.DIALECT": {"fullname": "sqlglot.dialects.dialect.Dialects.DIALECT", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialects.DIALECT", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Dialects.DIALECT: &#x27;&#x27;&gt;"}, "sqlglot.dialects.dialect.Dialects.BIGQUERY": {"fullname": "sqlglot.dialects.dialect.Dialects.BIGQUERY", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialects.BIGQUERY", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Dialects.BIGQUERY: &#x27;bigquery&#x27;&gt;"}, "sqlglot.dialects.dialect.Dialects.CLICKHOUSE": {"fullname": "sqlglot.dialects.dialect.Dialects.CLICKHOUSE", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialects.CLICKHOUSE", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Dialects.CLICKHOUSE: &#x27;clickhouse&#x27;&gt;"}, "sqlglot.dialects.dialect.Dialects.DATABRICKS": {"fullname": "sqlglot.dialects.dialect.Dialects.DATABRICKS", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialects.DATABRICKS", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Dialects.DATABRICKS: &#x27;databricks&#x27;&gt;"}, "sqlglot.dialects.dialect.Dialects.DRILL": {"fullname": "sqlglot.dialects.dialect.Dialects.DRILL", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialects.DRILL", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Dialects.DRILL: &#x27;drill&#x27;&gt;"}, "sqlglot.dialects.dialect.Dialects.DUCKDB": {"fullname": "sqlglot.dialects.dialect.Dialects.DUCKDB", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialects.DUCKDB", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Dialects.DUCKDB: &#x27;duckdb&#x27;&gt;"}, "sqlglot.dialects.dialect.Dialects.HIVE": {"fullname": "sqlglot.dialects.dialect.Dialects.HIVE", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialects.HIVE", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Dialects.HIVE: &#x27;hive&#x27;&gt;"}, "sqlglot.dialects.dialect.Dialects.MYSQL": {"fullname": "sqlglot.dialects.dialect.Dialects.MYSQL", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialects.MYSQL", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Dialects.MYSQL: &#x27;mysql&#x27;&gt;"}, "sqlglot.dialects.dialect.Dialects.ORACLE": {"fullname": "sqlglot.dialects.dialect.Dialects.ORACLE", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialects.ORACLE", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Dialects.ORACLE: &#x27;oracle&#x27;&gt;"}, "sqlglot.dialects.dialect.Dialects.POSTGRES": {"fullname": "sqlglot.dialects.dialect.Dialects.POSTGRES", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialects.POSTGRES", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Dialects.POSTGRES: &#x27;postgres&#x27;&gt;"}, "sqlglot.dialects.dialect.Dialects.PRESTO": {"fullname": "sqlglot.dialects.dialect.Dialects.PRESTO", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialects.PRESTO", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Dialects.PRESTO: &#x27;presto&#x27;&gt;"}, "sqlglot.dialects.dialect.Dialects.REDSHIFT": {"fullname": "sqlglot.dialects.dialect.Dialects.REDSHIFT", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialects.REDSHIFT", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Dialects.REDSHIFT: &#x27;redshift&#x27;&gt;"}, "sqlglot.dialects.dialect.Dialects.SNOWFLAKE": {"fullname": "sqlglot.dialects.dialect.Dialects.SNOWFLAKE", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialects.SNOWFLAKE", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Dialects.SNOWFLAKE: &#x27;snowflake&#x27;&gt;"}, "sqlglot.dialects.dialect.Dialects.SPARK": {"fullname": "sqlglot.dialects.dialect.Dialects.SPARK", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialects.SPARK", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Dialects.SPARK: &#x27;spark&#x27;&gt;"}, "sqlglot.dialects.dialect.Dialects.SPARK2": {"fullname": "sqlglot.dialects.dialect.Dialects.SPARK2", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialects.SPARK2", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Dialects.SPARK2: &#x27;spark2&#x27;&gt;"}, "sqlglot.dialects.dialect.Dialects.SQLITE": {"fullname": "sqlglot.dialects.dialect.Dialects.SQLITE", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialects.SQLITE", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Dialects.SQLITE: &#x27;sqlite&#x27;&gt;"}, "sqlglot.dialects.dialect.Dialects.STARROCKS": {"fullname": "sqlglot.dialects.dialect.Dialects.STARROCKS", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialects.STARROCKS", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Dialects.STARROCKS: &#x27;starrocks&#x27;&gt;"}, "sqlglot.dialects.dialect.Dialects.TABLEAU": {"fullname": "sqlglot.dialects.dialect.Dialects.TABLEAU", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialects.TABLEAU", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Dialects.TABLEAU: &#x27;tableau&#x27;&gt;"}, "sqlglot.dialects.dialect.Dialects.TERADATA": {"fullname": "sqlglot.dialects.dialect.Dialects.TERADATA", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialects.TERADATA", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Dialects.TERADATA: &#x27;teradata&#x27;&gt;"}, "sqlglot.dialects.dialect.Dialects.TRINO": {"fullname": "sqlglot.dialects.dialect.Dialects.TRINO", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialects.TRINO", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Dialects.TRINO: &#x27;trino&#x27;&gt;"}, "sqlglot.dialects.dialect.Dialects.TSQL": {"fullname": "sqlglot.dialects.dialect.Dialects.TSQL", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialects.TSQL", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Dialects.TSQL: &#x27;tsql&#x27;&gt;"}, "sqlglot.dialects.dialect.Dialects.Doris": {"fullname": "sqlglot.dialects.dialect.Dialects.Doris", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialects.Doris", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Dialects.Doris: &#x27;doris&#x27;&gt;"}, "sqlglot.dialects.dialect.Dialect": {"fullname": "sqlglot.dialects.dialect.Dialect", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialect", "kind": "class", "doc": "<p></p>\n"}, "sqlglot.dialects.dialect.Dialect.INDEX_OFFSET": {"fullname": "sqlglot.dialects.dialect.Dialect.INDEX_OFFSET", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialect.INDEX_OFFSET", "kind": "variable", "doc": "<p></p>\n", "default_value": "0"}, "sqlglot.dialects.dialect.Dialect.UNNEST_COLUMN_ONLY": {"fullname": "sqlglot.dialects.dialect.Dialect.UNNEST_COLUMN_ONLY", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialect.UNNEST_COLUMN_ONLY", "kind": "variable", "doc": "<p></p>\n", "default_value": "False"}, "sqlglot.dialects.dialect.Dialect.ALIAS_POST_TABLESAMPLE": {"fullname": "sqlglot.dialects.dialect.Dialect.ALIAS_POST_TABLESAMPLE", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialect.ALIAS_POST_TABLESAMPLE", "kind": "variable", "doc": "<p></p>\n", "default_value": "False"}, "sqlglot.dialects.dialect.Dialect.RESOLVES_IDENTIFIERS_AS_UPPERCASE": {"fullname": "sqlglot.dialects.dialect.Dialect.RESOLVES_IDENTIFIERS_AS_UPPERCASE", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialect.RESOLVES_IDENTIFIERS_AS_UPPERCASE", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Optional[bool]", "default_value": "False"}, "sqlglot.dialects.dialect.Dialect.IDENTIFIERS_CAN_START_WITH_DIGIT": {"fullname": "sqlglot.dialects.dialect.Dialect.IDENTIFIERS_CAN_START_WITH_DIGIT", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialect.IDENTIFIERS_CAN_START_WITH_DIGIT", "kind": "variable", "doc": "<p></p>\n", "default_value": "False"}, "sqlglot.dialects.dialect.Dialect.DPIPE_IS_STRING_CONCAT": {"fullname": "sqlglot.dialects.dialect.Dialect.DPIPE_IS_STRING_CONCAT", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialect.DPIPE_IS_STRING_CONCAT", "kind": "variable", "doc": "<p></p>\n", "default_value": "True"}, "sqlglot.dialects.dialect.Dialect.STRICT_STRING_CONCAT": {"fullname": "sqlglot.dialects.dialect.Dialect.STRICT_STRING_CONCAT", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialect.STRICT_STRING_CONCAT", "kind": "variable", "doc": "<p></p>\n", "default_value": "False"}, "sqlglot.dialects.dialect.Dialect.SUPPORTS_USER_DEFINED_TYPES": {"fullname": "sqlglot.dialects.dialect.Dialect.SUPPORTS_USER_DEFINED_TYPES", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialect.SUPPORTS_USER_DEFINED_TYPES", "kind": "variable", "doc": "<p></p>\n", "default_value": "True"}, "sqlglot.dialects.dialect.Dialect.SUPPORTS_SEMI_ANTI_JOIN": {"fullname": "sqlglot.dialects.dialect.Dialect.SUPPORTS_SEMI_ANTI_JOIN", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialect.SUPPORTS_SEMI_ANTI_JOIN", "kind": "variable", "doc": "<p></p>\n", "default_value": "True"}, "sqlglot.dialects.dialect.Dialect.NORMALIZE_FUNCTIONS": {"fullname": "sqlglot.dialects.dialect.Dialect.NORMALIZE_FUNCTIONS", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialect.NORMALIZE_FUNCTIONS", "kind": "variable", "doc": "<p></p>\n", "annotation": ": bool | str", "default_value": "&#x27;upper&#x27;"}, "sqlglot.dialects.dialect.Dialect.LOG_BASE_FIRST": {"fullname": "sqlglot.dialects.dialect.Dialect.LOG_BASE_FIRST", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialect.LOG_BASE_FIRST", "kind": "variable", "doc": "<p></p>\n", "default_value": "True"}, "sqlglot.dialects.dialect.Dialect.NULL_ORDERING": {"fullname": "sqlglot.dialects.dialect.Dialect.NULL_ORDERING", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialect.NULL_ORDERING", "kind": "variable", "doc": "<p></p>\n", "default_value": "&#x27;nulls_are_small&#x27;"}, "sqlglot.dialects.dialect.Dialect.DATE_FORMAT": {"fullname": "sqlglot.dialects.dialect.Dialect.DATE_FORMAT", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialect.DATE_FORMAT", "kind": "variable", "doc": "<p></p>\n", "default_value": "&quot;&#x27;%Y-%m-%d&#x27;&quot;"}, "sqlglot.dialects.dialect.Dialect.DATEINT_FORMAT": {"fullname": "sqlglot.dialects.dialect.Dialect.DATEINT_FORMAT", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialect.DATEINT_FORMAT", "kind": "variable", "doc": "<p></p>\n", "default_value": "&quot;&#x27;%Y%m%d&#x27;&quot;"}, "sqlglot.dialects.dialect.Dialect.TIME_FORMAT": {"fullname": "sqlglot.dialects.dialect.Dialect.TIME_FORMAT", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialect.TIME_FORMAT", "kind": "variable", "doc": "<p></p>\n", "default_value": "&quot;&#x27;%Y-%m-%d %H:%M:%S&#x27;&quot;"}, "sqlglot.dialects.dialect.Dialect.TIME_MAPPING": {"fullname": "sqlglot.dialects.dialect.Dialect.TIME_MAPPING", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialect.TIME_MAPPING", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict[str, str]", "default_value": "{}"}, "sqlglot.dialects.dialect.Dialect.FORMAT_MAPPING": {"fullname": "sqlglot.dialects.dialect.Dialect.FORMAT_MAPPING", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialect.FORMAT_MAPPING", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict[str, str]", "default_value": "{}"}, "sqlglot.dialects.dialect.Dialect.ESCAPE_SEQUENCES": {"fullname": "sqlglot.dialects.dialect.Dialect.ESCAPE_SEQUENCES", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialect.ESCAPE_SEQUENCES", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict[str, str]", "default_value": "{}"}, "sqlglot.dialects.dialect.Dialect.PSEUDOCOLUMNS": {"fullname": "sqlglot.dialects.dialect.Dialect.PSEUDOCOLUMNS", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialect.PSEUDOCOLUMNS", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Set[str]", "default_value": "set()"}, "sqlglot.dialects.dialect.Dialect.tokenizer_class": {"fullname": "sqlglot.dialects.dialect.Dialect.tokenizer_class", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialect.tokenizer_class", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;class &#x27;sqlglot.tokens.Tokenizer&#x27;&gt;"}, "sqlglot.dialects.dialect.Dialect.parser_class": {"fullname": "sqlglot.dialects.dialect.Dialect.parser_class", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialect.parser_class", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;class &#x27;sqlglot.parser.Parser&#x27;&gt;"}, "sqlglot.dialects.dialect.Dialect.generator_class": {"fullname": "sqlglot.dialects.dialect.Dialect.generator_class", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialect.generator_class", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;class &#x27;sqlglot.generator.Generator&#x27;&gt;"}, "sqlglot.dialects.dialect.Dialect.TIME_TRIE": {"fullname": "sqlglot.dialects.dialect.Dialect.TIME_TRIE", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialect.TIME_TRIE", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict", "default_value": "{}"}, "sqlglot.dialects.dialect.Dialect.FORMAT_TRIE": {"fullname": "sqlglot.dialects.dialect.Dialect.FORMAT_TRIE", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialect.FORMAT_TRIE", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict", "default_value": "{}"}, "sqlglot.dialects.dialect.Dialect.INVERSE_TIME_MAPPING": {"fullname": "sqlglot.dialects.dialect.Dialect.INVERSE_TIME_MAPPING", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialect.INVERSE_TIME_MAPPING", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict[str, str]", "default_value": "{}"}, "sqlglot.dialects.dialect.Dialect.INVERSE_TIME_TRIE": {"fullname": "sqlglot.dialects.dialect.Dialect.INVERSE_TIME_TRIE", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialect.INVERSE_TIME_TRIE", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict", "default_value": "{}"}, "sqlglot.dialects.dialect.Dialect.INVERSE_ESCAPE_SEQUENCES": {"fullname": "sqlglot.dialects.dialect.Dialect.INVERSE_ESCAPE_SEQUENCES", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialect.INVERSE_ESCAPE_SEQUENCES", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict[str, str]", "default_value": "{}"}, "sqlglot.dialects.dialect.Dialect.get_or_raise": {"fullname": "sqlglot.dialects.dialect.Dialect.get_or_raise", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialect.get_or_raise", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">cls</span>,</span><span class=\"param\">\t<span class=\"n\">dialect</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.Dialect.format_time": {"fullname": "sqlglot.dialects.dialect.Dialect.format_time", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialect.format_time", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">cls</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.Dialect.normalize_identifier": {"fullname": "sqlglot.dialects.dialect.Dialect.normalize_identifier", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialect.normalize_identifier", "kind": "function", "doc": "<p>Normalizes an unquoted identifier to either lower or upper case, thus essentially\nmaking it case-insensitive. If a dialect treats all identifiers as case-insensitive,\nthey will be normalized to lowercase regardless of being quoted or not.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span>, </span><span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"o\">~</span><span class=\"n\">E</span></span><span class=\"return-annotation\">) -> <span class=\"o\">~</span><span class=\"n\">E</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.Dialect.case_sensitive": {"fullname": "sqlglot.dialects.dialect.Dialect.case_sensitive", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialect.case_sensitive", "kind": "function", "doc": "<p>Checks if text contains any case sensitive characters, based on the dialect's rules.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span>, </span><span class=\"param\"><span class=\"n\">text</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.Dialect.can_identify": {"fullname": "sqlglot.dialects.dialect.Dialect.can_identify", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialect.can_identify", "kind": "function", "doc": "<p>Checks if text can be identified given an identify option.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>text:</strong>  The text to check.</li>\n<li><strong>identify:</strong>  \"always\" or <code>True</code>: Always returns true.\n\"safe\": True if the identifier is case-insensitive.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>Whether or not the given text can be identified.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span>, </span><span class=\"param\"><span class=\"n\">text</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">identify</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;safe&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.Dialect.quote_identifier": {"fullname": "sqlglot.dialects.dialect.Dialect.quote_identifier", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialect.quote_identifier", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span>, </span><span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"o\">~</span><span class=\"n\">E</span>, </span><span class=\"param\"><span class=\"n\">identify</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"o\">~</span><span class=\"n\">E</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.Dialect.parse": {"fullname": "sqlglot.dialects.dialect.Dialect.parse", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialect.parse", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">sql</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">opts</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.Dialect.parse_into": {"fullname": "sqlglot.dialects.dialect.Dialect.parse_into", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialect.parse_into", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">expression_type</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">],</span> <span class=\"n\">Collection</span><span class=\"p\">[</span><span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">]]]]</span>,</span><span class=\"param\">\t<span class=\"n\">sql</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">opts</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.Dialect.generate": {"fullname": "sqlglot.dialects.dialect.Dialect.generate", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialect.generate", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">opts</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.Dialect.transpile": {"fullname": "sqlglot.dialects.dialect.Dialect.transpile", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialect.transpile", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">sql</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">opts</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.Dialect.tokenize": {"fullname": "sqlglot.dialects.dialect.Dialect.tokenize", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialect.tokenize", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">sql</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">tokens</span><span class=\"o\">.</span><span class=\"n\">Token</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.Dialect.tokenizer": {"fullname": "sqlglot.dialects.dialect.Dialect.tokenizer", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialect.tokenizer", "kind": "variable", "doc": "<p></p>\n", "annotation": ": sqlglot.tokens.Tokenizer"}, "sqlglot.dialects.dialect.Dialect.parser": {"fullname": "sqlglot.dialects.dialect.Dialect.parser", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialect.parser", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">opts</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">parser</span><span class=\"o\">.</span><span class=\"n\">Parser</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.Dialect.generator": {"fullname": "sqlglot.dialects.dialect.Dialect.generator", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialect.generator", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">opts</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.Dialect.QUOTE_START": {"fullname": "sqlglot.dialects.dialect.Dialect.QUOTE_START", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialect.QUOTE_START", "kind": "variable", "doc": "<p></p>\n", "default_value": "&quot;&#x27;&quot;"}, "sqlglot.dialects.dialect.Dialect.QUOTE_END": {"fullname": "sqlglot.dialects.dialect.Dialect.QUOTE_END", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialect.QUOTE_END", "kind": "variable", "doc": "<p></p>\n", "default_value": "&quot;&#x27;&quot;"}, "sqlglot.dialects.dialect.Dialect.IDENTIFIER_START": {"fullname": "sqlglot.dialects.dialect.Dialect.IDENTIFIER_START", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialect.IDENTIFIER_START", "kind": "variable", "doc": "<p></p>\n", "default_value": "&#x27;&quot;&#x27;"}, "sqlglot.dialects.dialect.Dialect.IDENTIFIER_END": {"fullname": "sqlglot.dialects.dialect.Dialect.IDENTIFIER_END", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialect.IDENTIFIER_END", "kind": "variable", "doc": "<p></p>\n", "default_value": "&#x27;&quot;&#x27;"}, "sqlglot.dialects.dialect.Dialect.BIT_START": {"fullname": "sqlglot.dialects.dialect.Dialect.BIT_START", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialect.BIT_START", "kind": "variable", "doc": "<p></p>\n", "default_value": "None"}, "sqlglot.dialects.dialect.Dialect.BIT_END": {"fullname": "sqlglot.dialects.dialect.Dialect.BIT_END", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialect.BIT_END", "kind": "variable", "doc": "<p></p>\n", "default_value": "None"}, "sqlglot.dialects.dialect.Dialect.HEX_START": {"fullname": "sqlglot.dialects.dialect.Dialect.HEX_START", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialect.HEX_START", "kind": "variable", "doc": "<p></p>\n", "default_value": "None"}, "sqlglot.dialects.dialect.Dialect.HEX_END": {"fullname": "sqlglot.dialects.dialect.Dialect.HEX_END", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialect.HEX_END", "kind": "variable", "doc": "<p></p>\n", "default_value": "None"}, "sqlglot.dialects.dialect.Dialect.BYTE_START": {"fullname": "sqlglot.dialects.dialect.Dialect.BYTE_START", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialect.BYTE_START", "kind": "variable", "doc": "<p></p>\n", "default_value": "None"}, "sqlglot.dialects.dialect.Dialect.BYTE_END": {"fullname": "sqlglot.dialects.dialect.Dialect.BYTE_END", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialect.BYTE_END", "kind": "variable", "doc": "<p></p>\n", "default_value": "None"}, "sqlglot.dialects.dialect.DialectType": {"fullname": "sqlglot.dialects.dialect.DialectType", "modulename": "sqlglot.dialects.dialect", "qualname": "DialectType", "kind": "variable", "doc": "<p></p>\n", "default_value": "typing.Union[str, sqlglot.dialects.dialect.Dialect, typing.Type[sqlglot.dialects.dialect.Dialect], NoneType]"}, "sqlglot.dialects.dialect.rename_func": {"fullname": "sqlglot.dialects.dialect.rename_func", "modulename": "sqlglot.dialects.dialect", "qualname": "rename_func", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Callable</span><span class=\"p\">[[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">],</span> <span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.approx_count_distinct_sql": {"fullname": "sqlglot.dialects.dialect.approx_count_distinct_sql", "modulename": "sqlglot.dialects.dialect", "qualname": "approx_count_distinct_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">ApproxDistinct</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.if_sql": {"fullname": "sqlglot.dialects.dialect.if_sql", "modulename": "sqlglot.dialects.dialect", "qualname": "if_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;IF&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">false_value</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Callable</span><span class=\"p\">[[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">If</span><span class=\"p\">],</span> <span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.arrow_json_extract_sql": {"fullname": "sqlglot.dialects.dialect.arrow_json_extract_sql", "modulename": "sqlglot.dialects.dialect", "qualname": "arrow_json_extract_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">JSONExtract</span> <span class=\"o\">|</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">JSONBExtract</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.arrow_json_extract_scalar_sql": {"fullname": "sqlglot.dialects.dialect.arrow_json_extract_scalar_sql", "modulename": "sqlglot.dialects.dialect", "qualname": "arrow_json_extract_scalar_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">JSONExtractScalar</span> <span class=\"o\">|</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">JSONBExtractScalar</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.inline_array_sql": {"fullname": "sqlglot.dialects.dialect.inline_array_sql", "modulename": "sqlglot.dialects.dialect", "qualname": "inline_array_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Array</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.no_ilike_sql": {"fullname": "sqlglot.dialects.dialect.no_ilike_sql", "modulename": "sqlglot.dialects.dialect", "qualname": "no_ilike_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">ILike</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.no_paren_current_date_sql": {"fullname": "sqlglot.dialects.dialect.no_paren_current_date_sql", "modulename": "sqlglot.dialects.dialect", "qualname": "no_paren_current_date_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">CurrentDate</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.no_recursive_cte_sql": {"fullname": "sqlglot.dialects.dialect.no_recursive_cte_sql", "modulename": "sqlglot.dialects.dialect", "qualname": "no_recursive_cte_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">With</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.no_safe_divide_sql": {"fullname": "sqlglot.dialects.dialect.no_safe_divide_sql", "modulename": "sqlglot.dialects.dialect", "qualname": "no_safe_divide_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">SafeDivide</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.no_tablesample_sql": {"fullname": "sqlglot.dialects.dialect.no_tablesample_sql", "modulename": "sqlglot.dialects.dialect", "qualname": "no_tablesample_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">TableSample</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.no_pivot_sql": {"fullname": "sqlglot.dialects.dialect.no_pivot_sql", "modulename": "sqlglot.dialects.dialect", "qualname": "no_pivot_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Pivot</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.no_trycast_sql": {"fullname": "sqlglot.dialects.dialect.no_trycast_sql", "modulename": "sqlglot.dialects.dialect", "qualname": "no_trycast_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">TryCast</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.no_properties_sql": {"fullname": "sqlglot.dialects.dialect.no_properties_sql", "modulename": "sqlglot.dialects.dialect", "qualname": "no_properties_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Properties</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.no_comment_column_constraint_sql": {"fullname": "sqlglot.dialects.dialect.no_comment_column_constraint_sql", "modulename": "sqlglot.dialects.dialect", "qualname": "no_comment_column_constraint_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">CommentColumnConstraint</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.no_map_from_entries_sql": {"fullname": "sqlglot.dialects.dialect.no_map_from_entries_sql", "modulename": "sqlglot.dialects.dialect", "qualname": "no_map_from_entries_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">MapFromEntries</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.str_position_sql": {"fullname": "sqlglot.dialects.dialect.str_position_sql", "modulename": "sqlglot.dialects.dialect", "qualname": "str_position_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">StrPosition</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.struct_extract_sql": {"fullname": "sqlglot.dialects.dialect.struct_extract_sql", "modulename": "sqlglot.dialects.dialect", "qualname": "struct_extract_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">StructExtract</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.var_map_sql": {"fullname": "sqlglot.dialects.dialect.var_map_sql", "modulename": "sqlglot.dialects.dialect", "qualname": "var_map_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Map</span> <span class=\"o\">|</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">VarMap</span>,</span><span class=\"param\">\t<span class=\"n\">map_func_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;MAP&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.format_time_lambda": {"fullname": "sqlglot.dialects.dialect.format_time_lambda", "modulename": "sqlglot.dialects.dialect", "qualname": "format_time_lambda", "kind": "function", "doc": "<p>Helper used for time expressions.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>exp_class:</strong>  the expression class to instantiate.</li>\n<li><strong>dialect:</strong>  target sql dialect.</li>\n<li><strong>default:</strong>  the default format, True being time.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>A callable that can be used to return the appropriately formatted time expression.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">exp_class</span><span class=\"p\">:</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"o\">~</span><span class=\"n\">E</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">dialect</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">default</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">bool</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Callable</span><span class=\"p\">[[</span><span class=\"n\">List</span><span class=\"p\">],</span> <span class=\"o\">~</span><span class=\"n\">E</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.time_format": {"fullname": "sqlglot.dialects.dialect.time_format", "modulename": "sqlglot.dialects.dialect", "qualname": "time_format", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">dialect</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Callable</span><span class=\"p\">[[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">UnixToStr</span> <span class=\"o\">|</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">StrToUnix</span><span class=\"p\">],</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.create_with_partitions_sql": {"fullname": "sqlglot.dialects.dialect.create_with_partitions_sql", "modulename": "sqlglot.dialects.dialect", "qualname": "create_with_partitions_sql", "kind": "function", "doc": "<p>In Hive and Spark, the PARTITIONED BY property acts as an extension of a table's schema. When the\nPARTITIONED BY value is an array of column names, they are transformed into a schema. The corresponding\ncolumns are removed from the create statement.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Create</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.parse_date_delta": {"fullname": "sqlglot.dialects.dialect.parse_date_delta", "modulename": "sqlglot.dialects.dialect", "qualname": "parse_date_delta", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">exp_class</span><span class=\"p\">:</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"o\">~</span><span class=\"n\">E</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">unit_mapping</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Callable</span><span class=\"p\">[[</span><span class=\"n\">List</span><span class=\"p\">],</span> <span class=\"o\">~</span><span class=\"n\">E</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.parse_date_delta_with_interval": {"fullname": "sqlglot.dialects.dialect.parse_date_delta_with_interval", "modulename": "sqlglot.dialects.dialect", "qualname": "parse_date_delta_with_interval", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">expression_class</span><span class=\"p\">:</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"o\">~</span><span class=\"n\">E</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Callable</span><span class=\"p\">[[</span><span class=\"n\">List</span><span class=\"p\">],</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"o\">~</span><span class=\"n\">E</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.date_trunc_to_time": {"fullname": "sqlglot.dialects.dialect.date_trunc_to_time", "modulename": "sqlglot.dialects.dialect", "qualname": "date_trunc_to_time", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"n\">List</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">DateTrunc</span> <span class=\"o\">|</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">TimestampTrunc</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.date_add_interval_sql": {"fullname": "sqlglot.dialects.dialect.date_add_interval_sql", "modulename": "sqlglot.dialects.dialect", "qualname": "date_add_interval_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">data_type</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">kind</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Callable</span><span class=\"p\">[[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">],</span> <span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.timestamptrunc_sql": {"fullname": "sqlglot.dialects.dialect.timestamptrunc_sql", "modulename": "sqlglot.dialects.dialect", "qualname": "timestamptrunc_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">TimestampTrunc</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.no_timestamp_sql": {"fullname": "sqlglot.dialects.dialect.no_timestamp_sql", "modulename": "sqlglot.dialects.dialect", "qualname": "no_timestamp_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Timestamp</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.locate_to_strposition": {"fullname": "sqlglot.dialects.dialect.locate_to_strposition", "modulename": "sqlglot.dialects.dialect", "qualname": "locate_to_strposition", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"n\">List</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.strposition_to_locate_sql": {"fullname": "sqlglot.dialects.dialect.strposition_to_locate_sql", "modulename": "sqlglot.dialects.dialect", "qualname": "strposition_to_locate_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">StrPosition</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.left_to_substring_sql": {"fullname": "sqlglot.dialects.dialect.left_to_substring_sql", "modulename": "sqlglot.dialects.dialect", "qualname": "left_to_substring_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Left</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.right_to_substring_sql": {"fullname": "sqlglot.dialects.dialect.right_to_substring_sql", "modulename": "sqlglot.dialects.dialect", "qualname": "right_to_substring_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Left</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.timestrtotime_sql": {"fullname": "sqlglot.dialects.dialect.timestrtotime_sql", "modulename": "sqlglot.dialects.dialect", "qualname": "timestrtotime_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">TimeStrToTime</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.datestrtodate_sql": {"fullname": "sqlglot.dialects.dialect.datestrtodate_sql", "modulename": "sqlglot.dialects.dialect", "qualname": "datestrtodate_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">DateStrToDate</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.encode_decode_sql": {"fullname": "sqlglot.dialects.dialect.encode_decode_sql", "modulename": "sqlglot.dialects.dialect", "qualname": "encode_decode_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span>,</span><span class=\"param\">\t<span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">replace</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.min_or_least": {"fullname": "sqlglot.dialects.dialect.min_or_least", "modulename": "sqlglot.dialects.dialect", "qualname": "min_or_least", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Min</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.max_or_greatest": {"fullname": "sqlglot.dialects.dialect.max_or_greatest", "modulename": "sqlglot.dialects.dialect", "qualname": "max_or_greatest", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Max</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.count_if_to_sum": {"fullname": "sqlglot.dialects.dialect.count_if_to_sum", "modulename": "sqlglot.dialects.dialect", "qualname": "count_if_to_sum", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">CountIf</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.trim_sql": {"fullname": "sqlglot.dialects.dialect.trim_sql", "modulename": "sqlglot.dialects.dialect", "qualname": "trim_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Trim</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.str_to_time_sql": {"fullname": "sqlglot.dialects.dialect.str_to_time_sql", "modulename": "sqlglot.dialects.dialect", "qualname": "str_to_time_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.ts_or_ds_to_date_sql": {"fullname": "sqlglot.dialects.dialect.ts_or_ds_to_date_sql", "modulename": "sqlglot.dialects.dialect", "qualname": "ts_or_ds_to_date_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">dialect</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Callable</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.concat_to_dpipe_sql": {"fullname": "sqlglot.dialects.dialect.concat_to_dpipe_sql", "modulename": "sqlglot.dialects.dialect", "qualname": "concat_to_dpipe_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Concat</span> <span class=\"o\">|</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">SafeConcat</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.concat_ws_to_dpipe_sql": {"fullname": "sqlglot.dialects.dialect.concat_ws_to_dpipe_sql", "modulename": "sqlglot.dialects.dialect", "qualname": "concat_ws_to_dpipe_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">ConcatWs</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.regexp_extract_sql": {"fullname": "sqlglot.dialects.dialect.regexp_extract_sql", "modulename": "sqlglot.dialects.dialect", "qualname": "regexp_extract_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">RegexpExtract</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.regexp_replace_sql": {"fullname": "sqlglot.dialects.dialect.regexp_replace_sql", "modulename": "sqlglot.dialects.dialect", "qualname": "regexp_replace_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">RegexpReplace</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.pivot_column_names": {"fullname": "sqlglot.dialects.dialect.pivot_column_names", "modulename": "sqlglot.dialects.dialect", "qualname": "pivot_column_names", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">aggregations</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">dialect</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.binary_from_function": {"fullname": "sqlglot.dialects.dialect.binary_from_function", "modulename": "sqlglot.dialects.dialect", "qualname": "binary_from_function", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">expr_type</span><span class=\"p\">:</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"o\">~</span><span class=\"n\">B</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Callable</span><span class=\"p\">[[</span><span class=\"n\">List</span><span class=\"p\">],</span> <span class=\"o\">~</span><span class=\"n\">B</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.parse_timestamp_trunc": {"fullname": "sqlglot.dialects.dialect.parse_timestamp_trunc", "modulename": "sqlglot.dialects.dialect", "qualname": "parse_timestamp_trunc", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"n\">List</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">TimestampTrunc</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.any_value_to_max_sql": {"fullname": "sqlglot.dialects.dialect.any_value_to_max_sql", "modulename": "sqlglot.dialects.dialect", "qualname": "any_value_to_max_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">AnyValue</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.bool_xor_sql": {"fullname": "sqlglot.dialects.dialect.bool_xor_sql", "modulename": "sqlglot.dialects.dialect", "qualname": "bool_xor_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Xor</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.json_keyvalue_comma_sql": {"fullname": "sqlglot.dialects.dialect.json_keyvalue_comma_sql", "modulename": "sqlglot.dialects.dialect", "qualname": "json_keyvalue_comma_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">JSONKeyValue</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.is_parse_json": {"fullname": "sqlglot.dialects.dialect.is_parse_json", "modulename": "sqlglot.dialects.dialect", "qualname": "is_parse_json", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.isnull_to_is_null": {"fullname": "sqlglot.dialects.dialect.isnull_to_is_null", "modulename": "sqlglot.dialects.dialect", "qualname": "isnull_to_is_null", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"n\">List</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.move_insert_cte_sql": {"fullname": "sqlglot.dialects.dialect.move_insert_cte_sql", "modulename": "sqlglot.dialects.dialect", "qualname": "move_insert_cte_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Insert</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.generatedasidentitycolumnconstraint_sql": {"fullname": "sqlglot.dialects.dialect.generatedasidentitycolumnconstraint_sql", "modulename": "sqlglot.dialects.dialect", "qualname": "generatedasidentitycolumnconstraint_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">GeneratedAsIdentityColumnConstraint</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.doris": {"fullname": "sqlglot.dialects.doris", "modulename": "sqlglot.dialects.doris", "kind": "module", "doc": "<p></p>\n"}, "sqlglot.dialects.doris.Doris": {"fullname": "sqlglot.dialects.doris.Doris", "modulename": "sqlglot.dialects.doris", "qualname": "Doris", "kind": "class", "doc": "<p></p>\n", "bases": "sqlglot.dialects.mysql.MySQL"}, "sqlglot.dialects.doris.Doris.DATE_FORMAT": {"fullname": "sqlglot.dialects.doris.Doris.DATE_FORMAT", "modulename": "sqlglot.dialects.doris", "qualname": "Doris.DATE_FORMAT", "kind": "variable", "doc": "<p></p>\n", "default_value": "&quot;&#x27;yyyy-MM-dd&#x27;&quot;"}, "sqlglot.dialects.doris.Doris.DATEINT_FORMAT": {"fullname": "sqlglot.dialects.doris.Doris.DATEINT_FORMAT", "modulename": "sqlglot.dialects.doris", "qualname": "Doris.DATEINT_FORMAT", "kind": "variable", "doc": "<p></p>\n", "default_value": "&quot;&#x27;yyyyMMdd&#x27;&quot;"}, "sqlglot.dialects.doris.Doris.TIME_FORMAT": {"fullname": "sqlglot.dialects.doris.Doris.TIME_FORMAT", "modulename": "sqlglot.dialects.doris", "qualname": "Doris.TIME_FORMAT", "kind": "variable", "doc": "<p></p>\n", "default_value": "&quot;&#x27;yyyy-MM-dd HH:mm:ss&#x27;&quot;"}, "sqlglot.dialects.doris.Doris.Parser": {"fullname": "sqlglot.dialects.doris.Doris.Parser", "modulename": "sqlglot.dialects.doris", "qualname": "Doris.Parser", "kind": "class", "doc": "<p>Parser consumes a list of tokens produced by the Tokenizer and produces a parsed syntax tree.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>error_level:</strong>  The desired error level.\nDefault: ErrorLevel.IMMEDIATE</li>\n<li><strong>error_message_context:</strong>  Determines the amount of context to capture from a\nquery string when displaying the error message (in number of characters).\nDefault: 100</li>\n<li><strong>max_errors:</strong>  Maximum number of error messages to include in a raised ParseError.\nThis is only relevant if error_level is ErrorLevel.RAISE.\nDefault: 3</li>\n</ul>\n", "bases": "sqlglot.dialects.mysql.MySQL.Parser"}, "sqlglot.dialects.doris.Doris.Parser.FUNCTIONS": {"fullname": "sqlglot.dialects.doris.Doris.Parser.FUNCTIONS", "modulename": "sqlglot.dialects.doris", "qualname": "Doris.Parser.FUNCTIONS", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;ABS&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Abs&#x27;&gt;&gt;, &#x27;ANY_VALUE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.AnyValue&#x27;&gt;&gt;, &#x27;APPROX_DISTINCT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ApproxDistinct&#x27;&gt;&gt;, &#x27;APPROX_COUNT_DISTINCT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ApproxDistinct&#x27;&gt;&gt;, &#x27;APPROX_QUANTILE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ApproxQuantile&#x27;&gt;&gt;, &#x27;ARRAY&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Array&#x27;&gt;&gt;, &#x27;ARRAY_AGG&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArrayAgg&#x27;&gt;&gt;, &#x27;ARRAY_ALL&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArrayAll&#x27;&gt;&gt;, &#x27;ARRAY_ANY&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArrayAny&#x27;&gt;&gt;, &#x27;ARRAY_CONCAT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArrayConcat&#x27;&gt;&gt;, &#x27;ARRAY_CAT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArrayConcat&#x27;&gt;&gt;, &#x27;ARRAY_CONTAINS&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArrayContains&#x27;&gt;&gt;, &#x27;FILTER&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArrayFilter&#x27;&gt;&gt;, &#x27;ARRAY_FILTER&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArrayFilter&#x27;&gt;&gt;, &#x27;ARRAY_JOIN&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArrayJoin&#x27;&gt;&gt;, &#x27;ARRAY_SIZE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArraySize&#x27;&gt;&gt;, &#x27;ARRAY_SORT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArraySort&#x27;&gt;&gt;, &#x27;ARRAY_SUM&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArraySum&#x27;&gt;&gt;, &#x27;ARRAY_UNION_AGG&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArrayUnionAgg&#x27;&gt;&gt;, &#x27;AVG&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Avg&#x27;&gt;&gt;, &#x27;CASE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Case&#x27;&gt;&gt;, &#x27;CAST&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Cast&#x27;&gt;&gt;, &#x27;CAST_TO_STR_TYPE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.CastToStrType&#x27;&gt;&gt;, &#x27;CEIL&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Ceil&#x27;&gt;&gt;, &#x27;CEILING&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Ceil&#x27;&gt;&gt;, &#x27;CHR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Chr&#x27;&gt;&gt;, &#x27;CHAR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Chr&#x27;&gt;&gt;, &#x27;COALESCE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Coalesce&#x27;&gt;&gt;, &#x27;IFNULL&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Coalesce&#x27;&gt;&gt;, &#x27;NVL&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Coalesce&#x27;&gt;&gt;, &#x27;COLLATE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Collate&#x27;&gt;&gt;, &#x27;CONCAT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Concat&#x27;&gt;&gt;, &#x27;CONCAT_WS&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ConcatWs&#x27;&gt;&gt;, &#x27;COUNT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Count&#x27;&gt;&gt;, &#x27;COUNT_IF&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.CountIf&#x27;&gt;&gt;, &#x27;CURRENT_DATE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.CurrentDate&#x27;&gt;&gt;, &#x27;CURRENT_DATETIME&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.CurrentDatetime&#x27;&gt;&gt;, &#x27;CURRENT_TIME&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.CurrentTime&#x27;&gt;&gt;, &#x27;CURRENT_TIMESTAMP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.CurrentTimestamp&#x27;&gt;&gt;, &#x27;CURRENT_USER&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.CurrentUser&#x27;&gt;&gt;, &#x27;DATE&#x27;: &lt;function MySQL.Parser.&lt;lambda&gt;&gt;, &#x27;DATE_ADD&#x27;: &lt;function parse_date_delta_with_interval.&lt;locals&gt;.func&gt;, &#x27;DATEDIFF&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DateDiff&#x27;&gt;&gt;, &#x27;DATE_DIFF&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DateDiff&#x27;&gt;&gt;, &#x27;DATEFROMPARTS&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DateFromParts&#x27;&gt;&gt;, &#x27;DATE_STR_TO_DATE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DateStrToDate&#x27;&gt;&gt;, &#x27;DATE_SUB&#x27;: &lt;function parse_date_delta_with_interval.&lt;locals&gt;.func&gt;, &#x27;DATE_TO_DATE_STR&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;DATE_TO_DI&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DateToDi&#x27;&gt;&gt;, &#x27;DATE_TRUNC&#x27;: &lt;function parse_timestamp_trunc&gt;, &#x27;DATETIME_ADD&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DatetimeAdd&#x27;&gt;&gt;, &#x27;DATETIME_DIFF&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DatetimeDiff&#x27;&gt;&gt;, &#x27;DATETIME_SUB&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DatetimeSub&#x27;&gt;&gt;, &#x27;DATETIME_TRUNC&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DatetimeTrunc&#x27;&gt;&gt;, &#x27;DAY&#x27;: &lt;function MySQL.Parser.&lt;lambda&gt;&gt;, &#x27;DAY_OF_MONTH&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DayOfMonth&#x27;&gt;&gt;, &#x27;DAYOFMONTH&#x27;: &lt;function MySQL.Parser.&lt;lambda&gt;&gt;, &#x27;DAY_OF_WEEK&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DayOfWeek&#x27;&gt;&gt;, &#x27;DAYOFWEEK&#x27;: &lt;function MySQL.Parser.&lt;lambda&gt;&gt;, &#x27;DAY_OF_YEAR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DayOfYear&#x27;&gt;&gt;, &#x27;DAYOFYEAR&#x27;: &lt;function MySQL.Parser.&lt;lambda&gt;&gt;, &#x27;DECODE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Decode&#x27;&gt;&gt;, &#x27;DI_TO_DATE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DiToDate&#x27;&gt;&gt;, &#x27;ENCODE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Encode&#x27;&gt;&gt;, &#x27;EXP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Exp&#x27;&gt;&gt;, &#x27;EXPLODE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Explode&#x27;&gt;&gt;, &#x27;EXPLODE_OUTER&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ExplodeOuter&#x27;&gt;&gt;, &#x27;EXTRACT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Extract&#x27;&gt;&gt;, &#x27;FIRST&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.First&#x27;&gt;&gt;, &#x27;FLATTEN&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Flatten&#x27;&gt;&gt;, &#x27;FLOOR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Floor&#x27;&gt;&gt;, &#x27;FROM_BASE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.FromBase&#x27;&gt;&gt;, &#x27;FROM_BASE64&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.FromBase64&#x27;&gt;&gt;, &#x27;GENERATE_SERIES&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.GenerateSeries&#x27;&gt;&gt;, &#x27;GREATEST&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Greatest&#x27;&gt;&gt;, &#x27;GROUP_CONCAT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.GroupConcat&#x27;&gt;&gt;, &#x27;HEX&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Hex&#x27;&gt;&gt;, &#x27;HLL&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Hll&#x27;&gt;&gt;, &#x27;IF&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.If&#x27;&gt;&gt;, &#x27;INITCAP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Initcap&#x27;&gt;&gt;, &#x27;IS_NAN&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.IsNan&#x27;&gt;&gt;, &#x27;ISNAN&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.IsNan&#x27;&gt;&gt;, &#x27;J_S_O_N_ARRAY&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.JSONArray&#x27;&gt;&gt;, &#x27;J_S_O_N_ARRAY_AGG&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.JSONArrayAgg&#x27;&gt;&gt;, &#x27;JSON_ARRAY_CONTAINS&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.JSONArrayContains&#x27;&gt;&gt;, &#x27;JSONB_EXTRACT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.JSONBExtract&#x27;&gt;&gt;, &#x27;JSONB_EXTRACT_SCALAR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.JSONBExtractScalar&#x27;&gt;&gt;, &#x27;JSON_EXTRACT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.JSONExtract&#x27;&gt;&gt;, &#x27;JSON_EXTRACT_SCALAR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.JSONExtractScalar&#x27;&gt;&gt;, &#x27;JSON_FORMAT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.JSONFormat&#x27;&gt;&gt;, &#x27;J_S_O_N_OBJECT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.JSONObject&#x27;&gt;&gt;, &#x27;J_S_O_N_TABLE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.JSONTable&#x27;&gt;&gt;, &#x27;LAST&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Last&#x27;&gt;&gt;, &#x27;LAST_DATE_OF_MONTH&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.LastDateOfMonth&#x27;&gt;&gt;, &#x27;LEAST&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Least&#x27;&gt;&gt;, &#x27;LEFT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Left&#x27;&gt;&gt;, &#x27;LENGTH&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Length&#x27;&gt;&gt;, &#x27;LEN&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Length&#x27;&gt;&gt;, &#x27;LEVENSHTEIN&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Levenshtein&#x27;&gt;&gt;, &#x27;LN&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Ln&#x27;&gt;&gt;, &#x27;LOG&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Log&#x27;&gt;&gt;, &#x27;LOG10&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Log10&#x27;&gt;&gt;, &#x27;LOG2&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Log2&#x27;&gt;&gt;, &#x27;LOGICAL_AND&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.LogicalAnd&#x27;&gt;&gt;, &#x27;BOOL_AND&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.LogicalAnd&#x27;&gt;&gt;, &#x27;BOOLAND_AGG&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.LogicalAnd&#x27;&gt;&gt;, &#x27;LOGICAL_OR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.LogicalOr&#x27;&gt;&gt;, &#x27;BOOL_OR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.LogicalOr&#x27;&gt;&gt;, &#x27;BOOLOR_AGG&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.LogicalOr&#x27;&gt;&gt;, &#x27;LOWER&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Lower&#x27;&gt;&gt;, &#x27;LCASE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Lower&#x27;&gt;&gt;, &#x27;MD5&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.MD5&#x27;&gt;&gt;, &#x27;MD5_DIGEST&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.MD5Digest&#x27;&gt;&gt;, &#x27;MAP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Map&#x27;&gt;&gt;, &#x27;MAP_FROM_ENTRIES&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.MapFromEntries&#x27;&gt;&gt;, &#x27;MATCH_AGAINST&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.MatchAgainst&#x27;&gt;&gt;, &#x27;MAX&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Max&#x27;&gt;&gt;, &#x27;MIN&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Min&#x27;&gt;&gt;, &#x27;MONTH&#x27;: &lt;function MySQL.Parser.&lt;lambda&gt;&gt;, &#x27;MONTHS_BETWEEN&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.MonthsBetween&#x27;&gt;&gt;, &#x27;NEXT_VALUE_FOR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.NextValueFor&#x27;&gt;&gt;, &#x27;NUMBER_TO_STR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.NumberToStr&#x27;&gt;&gt;, &#x27;NVL2&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Nvl2&#x27;&gt;&gt;, &#x27;OPEN_J_S_O_N&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.OpenJSON&#x27;&gt;&gt;, &#x27;PARAMETERIZED_AGG&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ParameterizedAgg&#x27;&gt;&gt;, &#x27;PARSE_JSON&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ParseJSON&#x27;&gt;&gt;, &#x27;JSON_PARSE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ParseJSON&#x27;&gt;&gt;, &#x27;PERCENTILE_CONT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.PercentileCont&#x27;&gt;&gt;, &#x27;PERCENTILE_DISC&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.PercentileDisc&#x27;&gt;&gt;, &#x27;POSEXPLODE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Posexplode&#x27;&gt;&gt;, &#x27;POSEXPLODE_OUTER&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.PosexplodeOuter&#x27;&gt;&gt;, &#x27;POWER&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Pow&#x27;&gt;&gt;, &#x27;POW&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Pow&#x27;&gt;&gt;, &#x27;PREDICT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Predict&#x27;&gt;&gt;, &#x27;QUANTILE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Quantile&#x27;&gt;&gt;, &#x27;RANGE_N&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.RangeN&#x27;&gt;&gt;, &#x27;READ_CSV&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ReadCSV&#x27;&gt;&gt;, &#x27;REDUCE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Reduce&#x27;&gt;&gt;, &#x27;REGEXP_EXTRACT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.RegexpExtract&#x27;&gt;&gt;, &#x27;REGEXP_I_LIKE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.RegexpILike&#x27;&gt;&gt;, &#x27;REGEXP_LIKE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.RegexpLike&#x27;&gt;&gt;, &#x27;REGEXP_REPLACE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.RegexpReplace&#x27;&gt;&gt;, &#x27;REGEXP_SPLIT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.RegexpSplit&#x27;&gt;&gt;, &#x27;REPEAT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Repeat&#x27;&gt;&gt;, &#x27;RIGHT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Right&#x27;&gt;&gt;, &#x27;ROUND&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Round&#x27;&gt;&gt;, &#x27;ROW_NUMBER&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.RowNumber&#x27;&gt;&gt;, &#x27;SHA&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.SHA&#x27;&gt;&gt;, &#x27;SHA1&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.SHA&#x27;&gt;&gt;, &#x27;SHA2&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.SHA2&#x27;&gt;&gt;, &#x27;SAFE_CONCAT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.SafeConcat&#x27;&gt;&gt;, &#x27;SAFE_DIVIDE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.SafeDivide&#x27;&gt;&gt;, &#x27;SET_AGG&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.SetAgg&#x27;&gt;&gt;, &#x27;SORT_ARRAY&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.SortArray&#x27;&gt;&gt;, &#x27;SPLIT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Split&#x27;&gt;&gt;, &#x27;SQRT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Sqrt&#x27;&gt;&gt;, &#x27;STANDARD_HASH&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StandardHash&#x27;&gt;&gt;, &#x27;STAR_MAP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StarMap&#x27;&gt;&gt;, &#x27;STARTS_WITH&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StartsWith&#x27;&gt;&gt;, &#x27;STARTSWITH&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StartsWith&#x27;&gt;&gt;, &#x27;STDDEV&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Stddev&#x27;&gt;&gt;, &#x27;STDDEV_POP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StddevPop&#x27;&gt;&gt;, &#x27;STDDEV_SAMP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StddevSamp&#x27;&gt;&gt;, &#x27;STR_POSITION&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StrPosition&#x27;&gt;&gt;, &#x27;STR_TO_DATE&#x27;: &lt;function _str_to_date&gt;, &#x27;STR_TO_MAP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StrToMap&#x27;&gt;&gt;, &#x27;STR_TO_TIME&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StrToTime&#x27;&gt;&gt;, &#x27;STR_TO_UNIX&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StrToUnix&#x27;&gt;&gt;, &#x27;STRUCT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Struct&#x27;&gt;&gt;, &#x27;STRUCT_EXTRACT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StructExtract&#x27;&gt;&gt;, &#x27;STUFF&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Stuff&#x27;&gt;&gt;, &#x27;INSERT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Stuff&#x27;&gt;&gt;, &#x27;SUBSTRING&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Substring&#x27;&gt;&gt;, &#x27;SUM&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Sum&#x27;&gt;&gt;, &#x27;TIME_ADD&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimeAdd&#x27;&gt;&gt;, &#x27;TIME_DIFF&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimeDiff&#x27;&gt;&gt;, &#x27;TIME_STR_TO_DATE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimeStrToDate&#x27;&gt;&gt;, &#x27;TIME_STR_TO_TIME&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimeStrToTime&#x27;&gt;&gt;, &#x27;TIME_STR_TO_UNIX&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimeStrToUnix&#x27;&gt;&gt;, &#x27;TIME_SUB&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimeSub&#x27;&gt;&gt;, &#x27;TIME_TO_STR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimeToStr&#x27;&gt;&gt;, &#x27;TIME_TO_TIME_STR&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;TIME_TO_UNIX&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimeToUnix&#x27;&gt;&gt;, &#x27;TIME_TRUNC&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimeTrunc&#x27;&gt;&gt;, &#x27;TIMESTAMP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Timestamp&#x27;&gt;&gt;, &#x27;TIMESTAMP_ADD&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimestampAdd&#x27;&gt;&gt;, &#x27;TIMESTAMP_DIFF&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimestampDiff&#x27;&gt;&gt;, &#x27;TIMESTAMP_SUB&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimestampSub&#x27;&gt;&gt;, &#x27;TIMESTAMP_TRUNC&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimestampTrunc&#x27;&gt;&gt;, &#x27;TO_BASE64&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ToBase64&#x27;&gt;&gt;, &#x27;TO_CHAR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ToChar&#x27;&gt;&gt;, &#x27;TO_DAYS&#x27;: &lt;function MySQL.Parser.&lt;lambda&gt;&gt;, &#x27;TRANSFORM&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Transform&#x27;&gt;&gt;, &#x27;TRIM&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Trim&#x27;&gt;&gt;, &#x27;TRY_CAST&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TryCast&#x27;&gt;&gt;, &#x27;TS_OR_DI_TO_DI&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TsOrDiToDi&#x27;&gt;&gt;, &#x27;TS_OR_DS_ADD&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TsOrDsAdd&#x27;&gt;&gt;, &#x27;TS_OR_DS_TO_DATE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TsOrDsToDate&#x27;&gt;&gt;, &#x27;TS_OR_DS_TO_DATE_STR&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;UNHEX&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Unhex&#x27;&gt;&gt;, &#x27;UNIX_TO_STR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.UnixToStr&#x27;&gt;&gt;, &#x27;UNIX_TO_TIME&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.UnixToTime&#x27;&gt;&gt;, &#x27;UNIX_TO_TIME_STR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.UnixToTimeStr&#x27;&gt;&gt;, &#x27;UPPER&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Upper&#x27;&gt;&gt;, &#x27;UCASE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Upper&#x27;&gt;&gt;, &#x27;VAR_MAP&#x27;: &lt;function parse_var_map&gt;, &#x27;VARIANCE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Variance&#x27;&gt;&gt;, &#x27;VARIANCE_SAMP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Variance&#x27;&gt;&gt;, &#x27;VAR_SAMP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Variance&#x27;&gt;&gt;, &#x27;VARIANCE_POP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.VariancePop&#x27;&gt;&gt;, &#x27;VAR_POP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.VariancePop&#x27;&gt;&gt;, &#x27;WEEK&#x27;: &lt;function MySQL.Parser.&lt;lambda&gt;&gt;, &#x27;WEEK_OF_YEAR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.WeekOfYear&#x27;&gt;&gt;, &#x27;WEEKOFYEAR&#x27;: &lt;function MySQL.Parser.&lt;lambda&gt;&gt;, &#x27;WHEN&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.When&#x27;&gt;&gt;, &#x27;X_M_L_TABLE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.XMLTable&#x27;&gt;&gt;, &#x27;XOR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Xor&#x27;&gt;&gt;, &#x27;YEAR&#x27;: &lt;function MySQL.Parser.&lt;lambda&gt;&gt;, &#x27;GLOB&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;LIKE&#x27;: &lt;function parse_like&gt;, &#x27;DATE_FORMAT&#x27;: &lt;function format_time_lambda.&lt;locals&gt;._format_time&gt;, &#x27;INSTR&#x27;: &lt;function MySQL.Parser.&lt;lambda&gt;&gt;, &#x27;ISNULL&#x27;: &lt;function isnull_to_is_null&gt;, &#x27;LOCATE&#x27;: &lt;function locate_to_strposition&gt;, &#x27;MONTHNAME&#x27;: &lt;function MySQL.Parser.&lt;lambda&gt;&gt;, &#x27;REGEXP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.RegexpLike&#x27;&gt;&gt;}"}, "sqlglot.dialects.doris.Doris.Parser.TABLE_ALIAS_TOKENS": {"fullname": "sqlglot.dialects.doris.Doris.Parser.TABLE_ALIAS_TOKENS", "modulename": "sqlglot.dialects.doris", "qualname": "Doris.Parser.TABLE_ALIAS_TOKENS", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&lt;TokenType.DATEMULTIRANGE: &#x27;DATEMULTIRANGE&#x27;&gt;, &lt;TokenType.PERCENT: &#x27;PERCENT&#x27;&gt;, &lt;TokenType.UMEDIUMINT: &#x27;UMEDIUMINT&#x27;&gt;, &lt;TokenType.DOUBLE: &#x27;DOUBLE&#x27;&gt;, &lt;TokenType.PIVOT: &#x27;PIVOT&#x27;&gt;, &lt;TokenType.TRUE: &#x27;TRUE&#x27;&gt;, &lt;TokenType.TEXT: &#x27;TEXT&#x27;&gt;, &lt;TokenType.EXECUTE: &#x27;EXECUTE&#x27;&gt;, &lt;TokenType.DESC: &#x27;DESC&#x27;&gt;, &lt;TokenType.CACHE: &#x27;CACHE&#x27;&gt;, &lt;TokenType.FUNCTION: &#x27;FUNCTION&#x27;&gt;, &lt;TokenType.DATE: &#x27;DATE&#x27;&gt;, &lt;TokenType.BIT: &#x27;BIT&#x27;&gt;, &lt;TokenType.SETTINGS: &#x27;SETTINGS&#x27;&gt;, &lt;TokenType.TINYTEXT: &#x27;TINYTEXT&#x27;&gt;, &lt;TokenType.ROWVERSION: &#x27;ROWVERSION&#x27;&gt;, &lt;TokenType.CURRENT_USER: &#x27;CURRENT_USER&#x27;&gt;, &lt;TokenType.GEOGRAPHY: &#x27;GEOGRAPHY&#x27;&gt;, &lt;TokenType.BIGDECIMAL: &#x27;BIGDECIMAL&#x27;&gt;, &lt;TokenType.INT4MULTIRANGE: &#x27;INT4MULTIRANGE&#x27;&gt;, &lt;TokenType.CASE: &#x27;CASE&#x27;&gt;, &lt;TokenType.ANTI: &#x27;ANTI&#x27;&gt;, &lt;TokenType.EXISTS: &#x27;EXISTS&#x27;&gt;, &lt;TokenType.INDEX: &#x27;INDEX&#x27;&gt;, &lt;TokenType.UUID: &#x27;UUID&#x27;&gt;, &lt;TokenType.LOWCARDINALITY: &#x27;LOWCARDINALITY&#x27;&gt;, &lt;TokenType.UNKNOWN: &#x27;UNKNOWN&#x27;&gt;, &lt;TokenType.MEDIUMINT: &#x27;MEDIUMINT&#x27;&gt;, &lt;TokenType.CURRENT_DATETIME: &#x27;CURRENT_DATETIME&#x27;&gt;, &lt;TokenType.VOLATILE: &#x27;VOLATILE&#x27;&gt;, &lt;TokenType.ALL: &#x27;ALL&#x27;&gt;, &lt;TokenType.TINYBLOB: &#x27;TINYBLOB&#x27;&gt;, &lt;TokenType.TSMULTIRANGE: &#x27;TSMULTIRANGE&#x27;&gt;, &lt;TokenType.TIMETZ: &#x27;TIMETZ&#x27;&gt;, &lt;TokenType.ENUM16: &#x27;ENUM16&#x27;&gt;, &lt;TokenType.SHOW: &#x27;SHOW&#x27;&gt;, &lt;TokenType.OVERLAPS: &#x27;OVERLAPS&#x27;&gt;, &lt;TokenType.SMALLSERIAL: &#x27;SMALLSERIAL&#x27;&gt;, &lt;TokenType.COLLATE: &#x27;COLLATE&#x27;&gt;, &lt;TokenType.COMMENT: &#x27;COMMENT&#x27;&gt;, &lt;TokenType.FILTER: &#x27;FILTER&#x27;&gt;, &lt;TokenType.HLLSKETCH: &#x27;HLLSKETCH&#x27;&gt;, &lt;TokenType.ROWS: &#x27;ROWS&#x27;&gt;, &lt;TokenType.VARCHAR: &#x27;VARCHAR&#x27;&gt;, &lt;TokenType.UPDATE: &#x27;UPDATE&#x27;&gt;, &lt;TokenType.DICTIONARY: &#x27;DICTIONARY&#x27;&gt;, &lt;TokenType.TABLE: &#x27;TABLE&#x27;&gt;, &lt;TokenType.USERDEFINED: &#x27;USERDEFINED&#x27;&gt;, &lt;TokenType.DIV: &#x27;DIV&#x27;&gt;, &lt;TokenType.UNPIVOT: &#x27;UNPIVOT&#x27;&gt;, &lt;TokenType.FIXEDSTRING: &#x27;FIXEDSTRING&#x27;&gt;, &lt;TokenType.VARIANT: &#x27;VARIANT&#x27;&gt;, &lt;TokenType.BIGINT: &#x27;BIGINT&#x27;&gt;, &lt;TokenType.PARTITION: &#x27;PARTITION&#x27;&gt;, &lt;TokenType.DATERANGE: &#x27;DATERANGE&#x27;&gt;, &lt;TokenType.STRUCT: &#x27;STRUCT&#x27;&gt;, &lt;TokenType.ASC: &#x27;ASC&#x27;&gt;, &lt;TokenType.PRAGMA: &#x27;PRAGMA&#x27;&gt;, &lt;TokenType.PROCEDURE: &#x27;PROCEDURE&#x27;&gt;, &lt;TokenType.SEMI: &#x27;SEMI&#x27;&gt;, &lt;TokenType.SOME: &#x27;SOME&#x27;&gt;, &lt;TokenType.VARBINARY: &#x27;VARBINARY&#x27;&gt;, &lt;TokenType.NUMRANGE: &#x27;NUMRANGE&#x27;&gt;, &lt;TokenType.ESCAPE: &#x27;ESCAPE&#x27;&gt;, &lt;TokenType.ANY: &#x27;ANY&#x27;&gt;, &lt;TokenType.DELETE: &#x27;DELETE&#x27;&gt;, &lt;TokenType.LONGTEXT: &#x27;LONGTEXT&#x27;&gt;, &lt;TokenType.LOAD: &#x27;LOAD&#x27;&gt;, &lt;TokenType.NEXT: &#x27;NEXT&#x27;&gt;, &lt;TokenType.TOP: &#x27;TOP&#x27;&gt;, &lt;TokenType.DEFAULT: &#x27;DEFAULT&#x27;&gt;, &lt;TokenType.TIMESTAMP_MS: &#x27;TIMESTAMP_MS&#x27;&gt;, &lt;TokenType.HSTORE: &#x27;HSTORE&#x27;&gt;, &lt;TokenType.AUTO_INCREMENT: &#x27;AUTO_INCREMENT&#x27;&gt;, &lt;TokenType.OVERWRITE: &#x27;OVERWRITE&#x27;&gt;, &lt;TokenType.IS: &#x27;IS&#x27;&gt;, &lt;TokenType.NULL: &#x27;NULL&#x27;&gt;, &lt;TokenType.TIMESTAMP_NS: &#x27;TIMESTAMP_NS&#x27;&gt;, &lt;TokenType.VAR: &#x27;VAR&#x27;&gt;, &lt;TokenType.UNIQUEIDENTIFIER: &#x27;UNIQUEIDENTIFIER&#x27;&gt;, &lt;TokenType.IPADDRESS: &#x27;IPADDRESS&#x27;&gt;, &lt;TokenType.TIME: &#x27;TIME&#x27;&gt;, &lt;TokenType.TIMESTAMPLTZ: &#x27;TIMESTAMPLTZ&#x27;&gt;, &lt;TokenType.TINYINT: &#x27;TINYINT&#x27;&gt;, &lt;TokenType.UINT128: &#x27;UINT128&#x27;&gt;, &lt;TokenType.UINT256: &#x27;UINT256&#x27;&gt;, &lt;TokenType.NCHAR: &#x27;NCHAR&#x27;&gt;, &lt;TokenType.COMMAND: &#x27;COMMAND&#x27;&gt;, &lt;TokenType.BOOLEAN: &#x27;BOOLEAN&#x27;&gt;, &lt;TokenType.SUPER: &#x27;SUPER&#x27;&gt;, &lt;TokenType.CONSTRAINT: &#x27;CONSTRAINT&#x27;&gt;, &lt;TokenType.UDECIMAL: &#x27;UDECIMAL&#x27;&gt;, &lt;TokenType.REFERENCES: &#x27;REFERENCES&#x27;&gt;, &lt;TokenType.CURRENT_TIMESTAMP: &#x27;CURRENT_TIMESTAMP&#x27;&gt;, &lt;TokenType.INT4RANGE: &#x27;INT4RANGE&#x27;&gt;, &lt;TokenType.VIEW: &#x27;VIEW&#x27;&gt;, &lt;TokenType.BIGSERIAL: &#x27;BIGSERIAL&#x27;&gt;, &lt;TokenType.MONEY: &#x27;MONEY&#x27;&gt;, &lt;TokenType.COMMIT: &#x27;COMMIT&#x27;&gt;, &lt;TokenType.LONGBLOB: &#x27;LONGBLOB&#x27;&gt;, &lt;TokenType.INT8MULTIRANGE: &#x27;INT8MULTIRANGE&#x27;&gt;, &lt;TokenType.DATETIME64: &#x27;DATETIME64&#x27;&gt;, &lt;TokenType.IMAGE: &#x27;IMAGE&#x27;&gt;, &lt;TokenType.UTINYINT: &#x27;UTINYINT&#x27;&gt;, &lt;TokenType.MERGE: &#x27;MERGE&#x27;&gt;, &lt;TokenType.INT128: &#x27;INT128&#x27;&gt;, &lt;TokenType.ENUM8: &#x27;ENUM8&#x27;&gt;, &lt;TokenType.DATABASE: &#x27;DATABASE&#x27;&gt;, &lt;TokenType.SMALLMONEY: &#x27;SMALLMONEY&#x27;&gt;, &lt;TokenType.CURRENT_DATE: &#x27;CURRENT_DATE&#x27;&gt;, &lt;TokenType.TSRANGE: &#x27;TSRANGE&#x27;&gt;, &lt;TokenType.TEMPORARY: &#x27;TEMPORARY&#x27;&gt;, &lt;TokenType.SET: &#x27;SET&#x27;&gt;, &lt;TokenType.INT256: &#x27;INT256&#x27;&gt;, &lt;TokenType.DESCRIBE: &#x27;DESCRIBE&#x27;&gt;, &lt;TokenType.MAP: &#x27;MAP&#x27;&gt;, &lt;TokenType.FORMAT: &#x27;FORMAT&#x27;&gt;, &lt;TokenType.CURRENT_TIME: &#x27;CURRENT_TIME&#x27;&gt;, &lt;TokenType.END: &#x27;END&#x27;&gt;, &lt;TokenType.UINT: &#x27;UINT&#x27;&gt;, &lt;TokenType.CHAR: &#x27;CHAR&#x27;&gt;, &lt;TokenType.NULLABLE: &#x27;NULLABLE&#x27;&gt;, &lt;TokenType.ROW: &#x27;ROW&#x27;&gt;, &lt;TokenType.MEDIUMBLOB: &#x27;MEDIUMBLOB&#x27;&gt;, &lt;TokenType.INT8RANGE: &#x27;INT8RANGE&#x27;&gt;, &lt;TokenType.FLOAT: &#x27;FLOAT&#x27;&gt;, &lt;TokenType.XML: &#x27;XML&#x27;&gt;, &lt;TokenType.ORDINALITY: &#x27;ORDINALITY&#x27;&gt;, &lt;TokenType.NESTED: &#x27;NESTED&#x27;&gt;, &lt;TokenType.IPPREFIX: &#x27;IPPREFIX&#x27;&gt;, &lt;TokenType.DECIMAL: &#x27;DECIMAL&#x27;&gt;, &lt;TokenType.DATETIME: &#x27;DATETIME&#x27;&gt;, &lt;TokenType.OBJECT_IDENTIFIER: &#x27;OBJECT_IDENTIFIER&#x27;&gt;, &lt;TokenType.TIMESTAMP_S: &#x27;TIMESTAMP_S&#x27;&gt;, &lt;TokenType.SERIAL: &#x27;SERIAL&#x27;&gt;, &lt;TokenType.TIMESTAMPTZ: &#x27;TIMESTAMPTZ&#x27;&gt;, &lt;TokenType.COLUMN: &#x27;COLUMN&#x27;&gt;, &lt;TokenType.SCHEMA: &#x27;SCHEMA&#x27;&gt;, &lt;TokenType.OBJECT: &#x27;OBJECT&#x27;&gt;, &lt;TokenType.INET: &#x27;INET&#x27;&gt;, &lt;TokenType.FIRST: &#x27;FIRST&#x27;&gt;, &lt;TokenType.JSON: &#x27;JSON&#x27;&gt;, &lt;TokenType.BINARY: &#x27;BINARY&#x27;&gt;, &lt;TokenType.NVARCHAR: &#x27;NVARCHAR&#x27;&gt;, &lt;TokenType.UNIQUE: &#x27;UNIQUE&#x27;&gt;, &lt;TokenType.FALSE: &#x27;FALSE&#x27;&gt;, &lt;TokenType.SMALLINT: &#x27;SMALLINT&#x27;&gt;, &lt;TokenType.KEEP: &#x27;KEEP&#x27;&gt;, &lt;TokenType.GEOMETRY: &#x27;GEOMETRY&#x27;&gt;, &lt;TokenType.TIMESTAMP: &#x27;TIMESTAMP&#x27;&gt;, &lt;TokenType.ARRAY: &#x27;ARRAY&#x27;&gt;, &lt;TokenType.PSEUDO_TYPE: &#x27;PSEUDO_TYPE&#x27;&gt;, &lt;TokenType.MEDIUMTEXT: &#x27;MEDIUMTEXT&#x27;&gt;, &lt;TokenType.USMALLINT: &#x27;USMALLINT&#x27;&gt;, &lt;TokenType.TSTZRANGE: &#x27;TSTZRANGE&#x27;&gt;, &lt;TokenType.RANGE: &#x27;RANGE&#x27;&gt;, &lt;TokenType.TSTZMULTIRANGE: &#x27;TSTZMULTIRANGE&#x27;&gt;, &lt;TokenType.YEAR: &#x27;YEAR&#x27;&gt;, &lt;TokenType.ISNULL: &#x27;ISNULL&#x27;&gt;, &lt;TokenType.UBIGINT: &#x27;UBIGINT&#x27;&gt;, &lt;TokenType.NUMMULTIRANGE: &#x27;NUMMULTIRANGE&#x27;&gt;, &lt;TokenType.INT: &#x27;INT&#x27;&gt;, &lt;TokenType.JSONB: &#x27;JSONB&#x27;&gt;, &lt;TokenType.MODEL: &#x27;MODEL&#x27;&gt;, &lt;TokenType.INTERVAL: &#x27;INTERVAL&#x27;&gt;, &lt;TokenType.BEGIN: &#x27;BEGIN&#x27;&gt;, &lt;TokenType.KILL: &#x27;KILL&#x27;&gt;, &lt;TokenType.ENUM: &#x27;ENUM&#x27;&gt;}"}, "sqlglot.dialects.doris.Doris.Parser.TOKENIZER_CLASS": {"fullname": "sqlglot.dialects.doris.Doris.Parser.TOKENIZER_CLASS", "modulename": "sqlglot.dialects.doris", "qualname": "Doris.Parser.TOKENIZER_CLASS", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Type[sqlglot.tokens.Tokenizer]", "default_value": "&lt;class &#x27;sqlglot.dialects.mysql.MySQL.Tokenizer&#x27;&gt;"}, "sqlglot.dialects.doris.Doris.Parser.SHOW_TRIE": {"fullname": "sqlglot.dialects.doris.Doris.Parser.SHOW_TRIE", "modulename": "sqlglot.dialects.doris", "qualname": "Doris.Parser.SHOW_TRIE", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict", "default_value": "{&#x27;BINARY&#x27;: {&#x27;LOGS&#x27;: {0: True}}, &#x27;MASTER&#x27;: {&#x27;LOGS&#x27;: {0: True}, &#x27;STATUS&#x27;: {0: True}}, &#x27;BINLOG&#x27;: {&#x27;EVENTS&#x27;: {0: True}}, &#x27;CHARACTER&#x27;: {&#x27;SET&#x27;: {0: True}}, &#x27;CHARSET&#x27;: {0: True}, &#x27;COLLATION&#x27;: {0: True}, &#x27;FULL&#x27;: {&#x27;COLUMNS&#x27;: {0: True}, &#x27;PROCESSLIST&#x27;: {0: True}, &#x27;TABLES&#x27;: {0: True}}, &#x27;COLUMNS&#x27;: {0: True}, &#x27;CREATE&#x27;: {&#x27;DATABASE&#x27;: {0: True}, &#x27;EVENT&#x27;: {0: True}, &#x27;FUNCTION&#x27;: {0: True}, &#x27;PROCEDURE&#x27;: {0: True}, &#x27;TABLE&#x27;: {0: True}, &#x27;TRIGGER&#x27;: {0: True}, &#x27;VIEW&#x27;: {0: True}}, &#x27;DATABASES&#x27;: {0: True}, &#x27;ENGINE&#x27;: {0: True}, &#x27;STORAGE&#x27;: {&#x27;ENGINES&#x27;: {0: True}}, &#x27;ENGINES&#x27;: {0: True}, &#x27;ERRORS&#x27;: {0: True}, &#x27;EVENTS&#x27;: {0: True}, &#x27;FUNCTION&#x27;: {&#x27;CODE&#x27;: {0: True}, &#x27;STATUS&#x27;: {0: True}}, &#x27;GRANTS&#x27;: {0: True}, &#x27;INDEX&#x27;: {0: True}, &#x27;OPEN&#x27;: {&#x27;TABLES&#x27;: {0: True}}, &#x27;PLUGINS&#x27;: {0: True}, &#x27;PROCEDURE&#x27;: {&#x27;CODE&#x27;: {0: True}, &#x27;STATUS&#x27;: {0: True}}, &#x27;PRIVILEGES&#x27;: {0: True}, &#x27;PROCESSLIST&#x27;: {0: True}, &#x27;PROFILE&#x27;: {0: True}, &#x27;PROFILES&#x27;: {0: True}, &#x27;RELAYLOG&#x27;: {&#x27;EVENTS&#x27;: {0: True}}, &#x27;REPLICAS&#x27;: {0: True}, &#x27;SLAVE&#x27;: {&#x27;HOSTS&#x27;: {0: True}, &#x27;STATUS&#x27;: {0: True}}, &#x27;REPLICA&#x27;: {&#x27;STATUS&#x27;: {0: True}}, &#x27;GLOBAL&#x27;: {&#x27;STATUS&#x27;: {0: True}, &#x27;VARIABLES&#x27;: {0: True}}, &#x27;SESSION&#x27;: {&#x27;STATUS&#x27;: {0: True}, &#x27;VARIABLES&#x27;: {0: True}}, &#x27;STATUS&#x27;: {0: True}, &#x27;TABLE&#x27;: {&#x27;STATUS&#x27;: {0: True}}, &#x27;TABLES&#x27;: {0: True}, &#x27;TRIGGERS&#x27;: {0: True}, &#x27;VARIABLES&#x27;: {0: True}, &#x27;WARNINGS&#x27;: {0: True}}"}, "sqlglot.dialects.doris.Doris.Parser.SET_TRIE": {"fullname": "sqlglot.dialects.doris.Doris.Parser.SET_TRIE", "modulename": "sqlglot.dialects.doris", "qualname": "Doris.Parser.SET_TRIE", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict", "default_value": "{&#x27;GLOBAL&#x27;: {0: True}, &#x27;LOCAL&#x27;: {0: True}, &#x27;SESSION&#x27;: {0: True}, &#x27;TRANSACTION&#x27;: {0: True}, &#x27;PERSIST&#x27;: {0: True}, &#x27;PERSIST_ONLY&#x27;: {0: True}, &#x27;CHARACTER&#x27;: {&#x27;SET&#x27;: {0: True}}, &#x27;CHARSET&#x27;: {0: True}, &#x27;NAMES&#x27;: {0: True}}"}, "sqlglot.dialects.doris.Doris.Parser.FORMAT_TRIE": {"fullname": "sqlglot.dialects.doris.Doris.Parser.FORMAT_TRIE", "modulename": "sqlglot.dialects.doris", "qualname": "Doris.Parser.FORMAT_TRIE", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict", "default_value": "{&#x27;%&#x27;: {&#x27;M&#x27;: {0: True}, &#x27;c&#x27;: {0: True}, &#x27;e&#x27;: {0: True}, &#x27;h&#x27;: {0: True}, &#x27;i&#x27;: {0: True}, &#x27;s&#x27;: {0: True}, &#x27;u&#x27;: {0: True}, &#x27;k&#x27;: {0: True}, &#x27;l&#x27;: {0: True}, &#x27;T&#x27;: {0: True}, &#x27;W&#x27;: {0: True}}}"}, "sqlglot.dialects.doris.Doris.Parser.TIME_TRIE": {"fullname": "sqlglot.dialects.doris.Doris.Parser.TIME_TRIE", "modulename": "sqlglot.dialects.doris", "qualname": "Doris.Parser.TIME_TRIE", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict", "default_value": "{&#x27;%&#x27;: {&#x27;M&#x27;: {0: True}, &#x27;c&#x27;: {0: True}, &#x27;e&#x27;: {0: True}, &#x27;h&#x27;: {0: True}, &#x27;i&#x27;: {0: True}, &#x27;s&#x27;: {0: True}, &#x27;u&#x27;: {0: True}, &#x27;k&#x27;: {0: True}, &#x27;l&#x27;: {0: True}, &#x27;T&#x27;: {0: True}, &#x27;W&#x27;: {0: True}}}"}, "sqlglot.dialects.doris.Doris.Generator": {"fullname": "sqlglot.dialects.doris.Doris.Generator", "modulename": "sqlglot.dialects.doris", "qualname": "Doris.Generator", "kind": "class", "doc": "<p>Generator converts a given syntax tree to the corresponding SQL string.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>pretty:</strong>  Whether or not to format the produced SQL string.\nDefault: False.</li>\n<li><strong>identify:</strong>  Determines when an identifier should be quoted. Possible values are:\nFalse (default): Never quote, except in cases where it's mandatory by the dialect.\nTrue or 'always': Always quote.\n'safe': Only quote identifiers that are case insensitive.</li>\n<li><strong>normalize:</strong>  Whether or not to normalize identifiers to lowercase.\nDefault: False.</li>\n<li><strong>pad:</strong>  Determines the pad size in a formatted string.\nDefault: 2.</li>\n<li><strong>indent:</strong>  Determines the indentation size in a formatted string.\nDefault: 2.</li>\n<li><strong>normalize_functions:</strong>  Whether or not to normalize all function names. Possible values are:\n\"upper\" or True (default): Convert names to uppercase.\n\"lower\": Convert names to lowercase.\nFalse: Disables function name normalization.</li>\n<li><strong>unsupported_level:</strong>  Determines the generator's behavior when it encounters unsupported expressions.\nDefault ErrorLevel.WARN.</li>\n<li><strong>max_unsupported:</strong>  Maximum number of unsupported messages to include in a raised UnsupportedError.\nThis is only relevant if unsupported_level is ErrorLevel.RAISE.\nDefault: 3</li>\n<li><strong>leading_comma:</strong>  Determines whether or not the comma is leading or trailing in select expressions.\nThis is only relevant when generating in pretty mode.\nDefault: False</li>\n<li><strong>max_text_width:</strong>  The max number of characters in a segment before creating new lines in pretty mode.\nThe default is on the smaller end because the length only represents a segment and not the true\nline length.\nDefault: 80</li>\n<li><strong>comments:</strong>  Whether or not to preserve comments in the output SQL code.\nDefault: True</li>\n</ul>\n", "bases": "sqlglot.dialects.mysql.MySQL.Generator"}, "sqlglot.dialects.doris.Doris.Generator.CAST_MAPPING": {"fullname": "sqlglot.dialects.doris.Doris.Generator.CAST_MAPPING", "modulename": "sqlglot.dialects.doris", "qualname": "Doris.Generator.CAST_MAPPING", "kind": "variable", "doc": "<p></p>\n", "default_value": "{}"}, "sqlglot.dialects.doris.Doris.Generator.TYPE_MAPPING": {"fullname": "sqlglot.dialects.doris.Doris.Generator.TYPE_MAPPING", "modulename": "sqlglot.dialects.doris", "qualname": "Doris.Generator.TYPE_MAPPING", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&lt;Type.NCHAR: &#x27;NCHAR&#x27;&gt;: &#x27;CHAR&#x27;, &lt;Type.NVARCHAR: &#x27;NVARCHAR&#x27;&gt;: &#x27;VARCHAR&#x27;, &lt;Type.INET: &#x27;INET&#x27;&gt;: &#x27;INET&#x27;, &lt;Type.UBIGINT: &#x27;UBIGINT&#x27;&gt;: &#x27;BIGINT&#x27;, &lt;Type.UINT: &#x27;UINT&#x27;&gt;: &#x27;INT&#x27;, &lt;Type.UMEDIUMINT: &#x27;UMEDIUMINT&#x27;&gt;: &#x27;MEDIUMINT&#x27;, &lt;Type.USMALLINT: &#x27;USMALLINT&#x27;&gt;: &#x27;SMALLINT&#x27;, &lt;Type.UTINYINT: &#x27;UTINYINT&#x27;&gt;: &#x27;TINYINT&#x27;, &lt;Type.UDECIMAL: &#x27;UDECIMAL&#x27;&gt;: &#x27;DECIMAL&#x27;, &lt;Type.TIMESTAMP: &#x27;TIMESTAMP&#x27;&gt;: &#x27;DATETIME&#x27;, &lt;Type.TIMESTAMPTZ: &#x27;TIMESTAMPTZ&#x27;&gt;: &#x27;DATETIME&#x27;, &lt;Type.TIMESTAMPLTZ: &#x27;TIMESTAMPLTZ&#x27;&gt;: &#x27;TIMESTAMP&#x27;, &lt;Type.TEXT: &#x27;TEXT&#x27;&gt;: &#x27;STRING&#x27;}"}, "sqlglot.dialects.doris.Doris.Generator.TIMESTAMP_FUNC_TYPES": {"fullname": "sqlglot.dialects.doris.Doris.Generator.TIMESTAMP_FUNC_TYPES", "modulename": "sqlglot.dialects.doris", "qualname": "Doris.Generator.TIMESTAMP_FUNC_TYPES", "kind": "variable", "doc": "<p></p>\n", "default_value": "set()"}, "sqlglot.dialects.doris.Doris.Generator.TRANSFORMS": {"fullname": "sqlglot.dialects.doris.Doris.Generator.TRANSFORMS", "modulename": "sqlglot.dialects.doris", "qualname": "Doris.Generator.TRANSFORMS", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&lt;class &#x27;sqlglot.expressions.DateAdd&#x27;&gt;: &lt;function _remove_ts_or_ds_to_date.&lt;locals&gt;.func&gt;, &lt;class &#x27;sqlglot.expressions.TsOrDsAdd&#x27;&gt;: &lt;function Doris.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.CaseSpecificColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.CharacterSetColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.CharacterSetProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.CheckColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.ClusteredColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.CollateColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.CopyGrantsProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.CommentColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.DateFormatColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.DefaultColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.EncodeColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.ExecuteAsProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.ExternalProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.HeapProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.InlineLengthColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.InputModelProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.IntervalSpan&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.LanguageProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.LocationProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.LogProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.MaterializedProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.NoPrimaryIndexProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.NonClusteredColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.NotForReplicationColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.OnCommitProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.OnProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.OnUpdateColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.OutputModelProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.PathColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.RemoteWithConnectionModelProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.ReturnsProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.SampleProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.SetProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.SettingsProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.SqlSecurityProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.StabilityProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.TemporaryProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.ToTableProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.TransientProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.TransformModelProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.TitleColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.UppercaseColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.VarMap&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.VolatileProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.WithJournalTableProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.CurrentDate&#x27;&gt;: &lt;function no_paren_current_date_sql&gt;, &lt;class &#x27;sqlglot.expressions.DateDiff&#x27;&gt;: &lt;function _remove_ts_or_ds_to_date.&lt;locals&gt;.func&gt;, &lt;class &#x27;sqlglot.expressions.DateStrToDate&#x27;&gt;: &lt;function datestrtodate_sql&gt;, &lt;class &#x27;sqlglot.expressions.DateSub&#x27;&gt;: &lt;function _remove_ts_or_ds_to_date.&lt;locals&gt;.func&gt;, &lt;class &#x27;sqlglot.expressions.DateTrunc&#x27;&gt;: &lt;function Doris.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.Day&#x27;&gt;: &lt;function _remove_ts_or_ds_to_date.&lt;locals&gt;.func&gt;, &lt;class &#x27;sqlglot.expressions.DayOfMonth&#x27;&gt;: &lt;function _remove_ts_or_ds_to_date.&lt;locals&gt;.func&gt;, &lt;class &#x27;sqlglot.expressions.DayOfWeek&#x27;&gt;: &lt;function _remove_ts_or_ds_to_date.&lt;locals&gt;.func&gt;, &lt;class &#x27;sqlglot.expressions.DayOfYear&#x27;&gt;: &lt;function _remove_ts_or_ds_to_date.&lt;locals&gt;.func&gt;, &lt;class &#x27;sqlglot.expressions.GroupConcat&#x27;&gt;: &lt;function MySQL.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.ILike&#x27;&gt;: &lt;function no_ilike_sql&gt;, &lt;class &#x27;sqlglot.expressions.JSONExtractScalar&#x27;&gt;: &lt;function arrow_json_extract_sql&gt;, &lt;class &#x27;sqlglot.expressions.JSONKeyValue&#x27;&gt;: &lt;function json_keyvalue_comma_sql&gt;, &lt;class &#x27;sqlglot.expressions.Max&#x27;&gt;: &lt;function max_or_greatest&gt;, &lt;class &#x27;sqlglot.expressions.Min&#x27;&gt;: &lt;function min_or_least&gt;, &lt;class &#x27;sqlglot.expressions.Month&#x27;&gt;: &lt;function _remove_ts_or_ds_to_date.&lt;locals&gt;.func&gt;, &lt;class &#x27;sqlglot.expressions.NullSafeEQ&#x27;&gt;: &lt;function MySQL.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.NullSafeNEQ&#x27;&gt;: &lt;function MySQL.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.Pivot&#x27;&gt;: &lt;function no_pivot_sql&gt;, &lt;class &#x27;sqlglot.expressions.Select&#x27;&gt;: &lt;function preprocess.&lt;locals&gt;._to_sql&gt;, &lt;class &#x27;sqlglot.expressions.StrPosition&#x27;&gt;: &lt;function strposition_to_locate_sql&gt;, &lt;class &#x27;sqlglot.expressions.StrToDate&#x27;&gt;: &lt;function _str_to_date_sql&gt;, &lt;class &#x27;sqlglot.expressions.StrToTime&#x27;&gt;: &lt;function _str_to_date_sql&gt;, &lt;class &#x27;sqlglot.expressions.Stuff&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.TableSample&#x27;&gt;: &lt;function no_tablesample_sql&gt;, &lt;class &#x27;sqlglot.expressions.TimestampAdd&#x27;&gt;: &lt;function date_add_interval_sql.&lt;locals&gt;.func&gt;, &lt;class &#x27;sqlglot.expressions.TimestampSub&#x27;&gt;: &lt;function date_add_interval_sql.&lt;locals&gt;.func&gt;, &lt;class &#x27;sqlglot.expressions.TimeStrToUnix&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.TimeStrToTime&#x27;&gt;: &lt;function MySQL.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.TimeToStr&#x27;&gt;: &lt;function _remove_ts_or_ds_to_date.&lt;locals&gt;.func&gt;, &lt;class &#x27;sqlglot.expressions.Trim&#x27;&gt;: &lt;function _trim_sql&gt;, &lt;class &#x27;sqlglot.expressions.TryCast&#x27;&gt;: &lt;function no_trycast_sql&gt;, &lt;class &#x27;sqlglot.expressions.TsOrDsToDate&#x27;&gt;: &lt;function Doris.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.Week&#x27;&gt;: &lt;function _remove_ts_or_ds_to_date.&lt;locals&gt;.func&gt;, &lt;class &#x27;sqlglot.expressions.WeekOfYear&#x27;&gt;: &lt;function _remove_ts_or_ds_to_date.&lt;locals&gt;.func&gt;, &lt;class &#x27;sqlglot.expressions.Year&#x27;&gt;: &lt;function _remove_ts_or_ds_to_date.&lt;locals&gt;.func&gt;, &lt;class &#x27;sqlglot.expressions.ApproxDistinct&#x27;&gt;: &lt;function approx_count_distinct_sql&gt;, &lt;class &#x27;sqlglot.expressions.ArrayAgg&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.CurrentTimestamp&#x27;&gt;: &lt;function Doris.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.JSONExtract&#x27;&gt;: &lt;function arrow_json_extract_sql&gt;, &lt;class &#x27;sqlglot.expressions.RegexpLike&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.RegexpSplit&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.SetAgg&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.StrToUnix&#x27;&gt;: &lt;function Doris.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.Split&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.TimeStrToDate&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.ToChar&#x27;&gt;: &lt;function Doris.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.TimeToUnix&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.TimestampTrunc&#x27;&gt;: &lt;function Doris.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.UnixToStr&#x27;&gt;: &lt;function Doris.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.UnixToTime&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.Map&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;}"}, "sqlglot.dialects.doris.Doris.Generator.SELECT_KINDS": {"fullname": "sqlglot.dialects.doris.Doris.Generator.SELECT_KINDS", "modulename": "sqlglot.dialects.doris", "qualname": "Doris.Generator.SELECT_KINDS", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Tuple[str, ...]", "default_value": "()"}, "sqlglot.dialects.doris.Doris.Generator.INVERSE_TIME_MAPPING": {"fullname": "sqlglot.dialects.doris.Doris.Generator.INVERSE_TIME_MAPPING", "modulename": "sqlglot.dialects.doris", "qualname": "Doris.Generator.INVERSE_TIME_MAPPING", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict[str, str]", "default_value": "{&#x27;%B&#x27;: &#x27;%M&#x27;, &#x27;%-m&#x27;: &#x27;%c&#x27;, &#x27;%-d&#x27;: &#x27;%e&#x27;, &#x27;%I&#x27;: &#x27;%h&#x27;, &#x27;%M&#x27;: &#x27;%i&#x27;, &#x27;%S&#x27;: &#x27;%s&#x27;, &#x27;%W&#x27;: &#x27;%u&#x27;, &#x27;%-H&#x27;: &#x27;%k&#x27;, &#x27;%-I&#x27;: &#x27;%l&#x27;, &#x27;%H:%M:%S&#x27;: &#x27;%T&#x27;, &#x27;%a&#x27;: &#x27;%W&#x27;}"}, "sqlglot.dialects.doris.Doris.Generator.INVERSE_TIME_TRIE": {"fullname": "sqlglot.dialects.doris.Doris.Generator.INVERSE_TIME_TRIE", "modulename": "sqlglot.dialects.doris", "qualname": "Doris.Generator.INVERSE_TIME_TRIE", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict", "default_value": "{&#x27;%&#x27;: {&#x27;B&#x27;: {0: True}, &#x27;-&#x27;: {&#x27;m&#x27;: {0: True}, &#x27;d&#x27;: {0: True}, &#x27;H&#x27;: {0: True}, &#x27;I&#x27;: {0: True}}, &#x27;I&#x27;: {0: True}, &#x27;M&#x27;: {0: True}, &#x27;S&#x27;: {0: True}, &#x27;W&#x27;: {0: True}, &#x27;H&#x27;: {&#x27;:&#x27;: {&#x27;%&#x27;: {&#x27;M&#x27;: {&#x27;:&#x27;: {&#x27;%&#x27;: {&#x27;S&#x27;: {0: True}}}}}}}, &#x27;a&#x27;: {0: True}}}"}, "sqlglot.dialects.doris.Doris.Generator.INVERSE_ESCAPE_SEQUENCES": {"fullname": "sqlglot.dialects.doris.Doris.Generator.INVERSE_ESCAPE_SEQUENCES", "modulename": "sqlglot.dialects.doris", "qualname": "Doris.Generator.INVERSE_ESCAPE_SEQUENCES", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict[str, str]", "default_value": "{}"}, "sqlglot.dialects.doris.Doris.Generator.can_identify": {"fullname": "sqlglot.dialects.doris.Doris.Generator.can_identify", "modulename": "sqlglot.dialects.doris", "qualname": "Doris.Generator.can_identify", "kind": "function", "doc": "<p>Checks if text can be identified given an identify option.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>text:</strong>  The text to check.</li>\n<li><strong>identify:</strong>  \"always\" or <code>True</code>: Always returns true.\n\"safe\": True if the identifier is case-insensitive.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>Whether or not the given text can be identified.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">text</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">identify</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;safe&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.doris.Doris.Generator.QUOTE_START": {"fullname": "sqlglot.dialects.doris.Doris.Generator.QUOTE_START", "modulename": "sqlglot.dialects.doris", "qualname": "Doris.Generator.QUOTE_START", "kind": "variable", "doc": "<p></p>\n", "default_value": "&quot;&#x27;&quot;"}, "sqlglot.dialects.doris.Doris.Generator.QUOTE_END": {"fullname": "sqlglot.dialects.doris.Doris.Generator.QUOTE_END", "modulename": "sqlglot.dialects.doris", "qualname": "Doris.Generator.QUOTE_END", "kind": "variable", "doc": "<p></p>\n", "default_value": "&quot;&#x27;&quot;"}, "sqlglot.dialects.doris.Doris.Generator.IDENTIFIER_START": {"fullname": "sqlglot.dialects.doris.Doris.Generator.IDENTIFIER_START", "modulename": "sqlglot.dialects.doris", "qualname": "Doris.Generator.IDENTIFIER_START", "kind": "variable", "doc": "<p></p>\n", "default_value": "&#x27;`&#x27;"}, "sqlglot.dialects.doris.Doris.Generator.IDENTIFIER_END": {"fullname": "sqlglot.dialects.doris.Doris.Generator.IDENTIFIER_END", "modulename": "sqlglot.dialects.doris", "qualname": "Doris.Generator.IDENTIFIER_END", "kind": "variable", "doc": "<p></p>\n", "default_value": "&#x27;`&#x27;"}, "sqlglot.dialects.doris.Doris.Generator.TOKENIZER_CLASS": {"fullname": "sqlglot.dialects.doris.Doris.Generator.TOKENIZER_CLASS", "modulename": "sqlglot.dialects.doris", "qualname": "Doris.Generator.TOKENIZER_CLASS", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;class &#x27;sqlglot.dialects.mysql.MySQL.Tokenizer&#x27;&gt;"}, "sqlglot.dialects.doris.Doris.Generator.BIT_START": {"fullname": "sqlglot.dialects.doris.Doris.Generator.BIT_START", "modulename": "sqlglot.dialects.doris", "qualname": "Doris.Generator.BIT_START", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Optional[str]", "default_value": "&quot;b&#x27;&quot;"}, "sqlglot.dialects.doris.Doris.Generator.BIT_END": {"fullname": "sqlglot.dialects.doris.Doris.Generator.BIT_END", "modulename": "sqlglot.dialects.doris", "qualname": "Doris.Generator.BIT_END", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Optional[str]", "default_value": "&quot;&#x27;&quot;"}, "sqlglot.dialects.doris.Doris.Generator.HEX_START": {"fullname": "sqlglot.dialects.doris.Doris.Generator.HEX_START", "modulename": "sqlglot.dialects.doris", "qualname": "Doris.Generator.HEX_START", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Optional[str]", "default_value": "&quot;x&#x27;&quot;"}, "sqlglot.dialects.doris.Doris.Generator.HEX_END": {"fullname": "sqlglot.dialects.doris.Doris.Generator.HEX_END", "modulename": "sqlglot.dialects.doris", "qualname": "Doris.Generator.HEX_END", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Optional[str]", "default_value": "&quot;&#x27;&quot;"}, "sqlglot.dialects.doris.Doris.Generator.BYTE_START": {"fullname": "sqlglot.dialects.doris.Doris.Generator.BYTE_START", "modulename": "sqlglot.dialects.doris", "qualname": "Doris.Generator.BYTE_START", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Optional[str]", "default_value": "None"}, "sqlglot.dialects.doris.Doris.Generator.BYTE_END": {"fullname": "sqlglot.dialects.doris.Doris.Generator.BYTE_END", "modulename": "sqlglot.dialects.doris", "qualname": "Doris.Generator.BYTE_END", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Optional[str]", "default_value": "None"}, "sqlglot.dialects.doris.Doris.tokenizer_class": {"fullname": "sqlglot.dialects.doris.Doris.tokenizer_class", "modulename": "sqlglot.dialects.doris", "qualname": "Doris.tokenizer_class", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;class &#x27;sqlglot.dialects.mysql.MySQL.Tokenizer&#x27;&gt;"}, "sqlglot.dialects.doris.Doris.parser_class": {"fullname": "sqlglot.dialects.doris.Doris.parser_class", "modulename": "sqlglot.dialects.doris", "qualname": "Doris.parser_class", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;class &#x27;sqlglot.dialects.doris.Doris.Parser&#x27;&gt;"}, "sqlglot.dialects.doris.Doris.generator_class": {"fullname": "sqlglot.dialects.doris.Doris.generator_class", "modulename": "sqlglot.dialects.doris", "qualname": "Doris.generator_class", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;class &#x27;sqlglot.dialects.doris.Doris.Generator&#x27;&gt;"}, "sqlglot.dialects.doris.Doris.TIME_TRIE": {"fullname": "sqlglot.dialects.doris.Doris.TIME_TRIE", "modulename": "sqlglot.dialects.doris", "qualname": "Doris.TIME_TRIE", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict", "default_value": "{&#x27;%&#x27;: {&#x27;M&#x27;: {0: True}, &#x27;c&#x27;: {0: True}, &#x27;e&#x27;: {0: True}, &#x27;h&#x27;: {0: True}, &#x27;i&#x27;: {0: True}, &#x27;s&#x27;: {0: True}, &#x27;u&#x27;: {0: True}, &#x27;k&#x27;: {0: True}, &#x27;l&#x27;: {0: True}, &#x27;T&#x27;: {0: True}, &#x27;W&#x27;: {0: True}}}"}, "sqlglot.dialects.doris.Doris.FORMAT_TRIE": {"fullname": "sqlglot.dialects.doris.Doris.FORMAT_TRIE", "modulename": "sqlglot.dialects.doris", "qualname": "Doris.FORMAT_TRIE", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict", "default_value": "{&#x27;%&#x27;: {&#x27;M&#x27;: {0: True}, &#x27;c&#x27;: {0: True}, &#x27;e&#x27;: {0: True}, &#x27;h&#x27;: {0: True}, &#x27;i&#x27;: {0: True}, &#x27;s&#x27;: {0: True}, &#x27;u&#x27;: {0: True}, &#x27;k&#x27;: {0: True}, &#x27;l&#x27;: {0: True}, &#x27;T&#x27;: {0: True}, &#x27;W&#x27;: {0: True}}}"}, "sqlglot.dialects.doris.Doris.INVERSE_TIME_MAPPING": {"fullname": "sqlglot.dialects.doris.Doris.INVERSE_TIME_MAPPING", "modulename": "sqlglot.dialects.doris", "qualname": "Doris.INVERSE_TIME_MAPPING", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict[str, str]", "default_value": "{&#x27;%B&#x27;: &#x27;%M&#x27;, &#x27;%-m&#x27;: &#x27;%c&#x27;, &#x27;%-d&#x27;: &#x27;%e&#x27;, &#x27;%I&#x27;: &#x27;%h&#x27;, &#x27;%M&#x27;: &#x27;%i&#x27;, &#x27;%S&#x27;: &#x27;%s&#x27;, &#x27;%W&#x27;: &#x27;%u&#x27;, &#x27;%-H&#x27;: &#x27;%k&#x27;, &#x27;%-I&#x27;: &#x27;%l&#x27;, &#x27;%H:%M:%S&#x27;: &#x27;%T&#x27;, &#x27;%a&#x27;: &#x27;%W&#x27;}"}, "sqlglot.dialects.doris.Doris.INVERSE_TIME_TRIE": {"fullname": "sqlglot.dialects.doris.Doris.INVERSE_TIME_TRIE", "modulename": "sqlglot.dialects.doris", "qualname": "Doris.INVERSE_TIME_TRIE", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict", "default_value": "{&#x27;%&#x27;: {&#x27;B&#x27;: {0: True}, &#x27;-&#x27;: {&#x27;m&#x27;: {0: True}, &#x27;d&#x27;: {0: True}, &#x27;H&#x27;: {0: True}, &#x27;I&#x27;: {0: True}}, &#x27;I&#x27;: {0: True}, &#x27;M&#x27;: {0: True}, &#x27;S&#x27;: {0: True}, &#x27;W&#x27;: {0: True}, &#x27;H&#x27;: {&#x27;:&#x27;: {&#x27;%&#x27;: {&#x27;M&#x27;: {&#x27;:&#x27;: {&#x27;%&#x27;: {&#x27;S&#x27;: {0: True}}}}}}}, &#x27;a&#x27;: {0: True}}}"}, "sqlglot.dialects.doris.Doris.INVERSE_ESCAPE_SEQUENCES": {"fullname": "sqlglot.dialects.doris.Doris.INVERSE_ESCAPE_SEQUENCES", "modulename": "sqlglot.dialects.doris", "qualname": "Doris.INVERSE_ESCAPE_SEQUENCES", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict[str, str]", "default_value": "{}"}, "sqlglot.dialects.doris.Doris.QUOTE_START": {"fullname": "sqlglot.dialects.doris.Doris.QUOTE_START", "modulename": "sqlglot.dialects.doris", "qualname": "Doris.QUOTE_START", "kind": "variable", "doc": "<p></p>\n", "default_value": "&quot;&#x27;&quot;"}, "sqlglot.dialects.doris.Doris.QUOTE_END": {"fullname": "sqlglot.dialects.doris.Doris.QUOTE_END", "modulename": "sqlglot.dialects.doris", "qualname": "Doris.QUOTE_END", "kind": "variable", "doc": "<p></p>\n", "default_value": "&quot;&#x27;&quot;"}, "sqlglot.dialects.doris.Doris.IDENTIFIER_START": {"fullname": "sqlglot.dialects.doris.Doris.IDENTIFIER_START", "modulename": "sqlglot.dialects.doris", "qualname": "Doris.IDENTIFIER_START", "kind": "variable", "doc": "<p></p>\n", "default_value": "&#x27;`&#x27;"}, "sqlglot.dialects.doris.Doris.IDENTIFIER_END": {"fullname": "sqlglot.dialects.doris.Doris.IDENTIFIER_END", "modulename": "sqlglot.dialects.doris", "qualname": "Doris.IDENTIFIER_END", "kind": "variable", "doc": "<p></p>\n", "default_value": "&#x27;`&#x27;"}, "sqlglot.dialects.doris.Doris.BIT_START": {"fullname": "sqlglot.dialects.doris.Doris.BIT_START", "modulename": "sqlglot.dialects.doris", "qualname": "Doris.BIT_START", "kind": "variable", "doc": "<p></p>\n", "default_value": "&quot;b&#x27;&quot;"}, "sqlglot.dialects.doris.Doris.BIT_END": {"fullname": "sqlglot.dialects.doris.Doris.BIT_END", "modulename": "sqlglot.dialects.doris", "qualname": "Doris.BIT_END", "kind": "variable", "doc": "<p></p>\n", "default_value": "&quot;&#x27;&quot;"}, "sqlglot.dialects.doris.Doris.HEX_START": {"fullname": "sqlglot.dialects.doris.Doris.HEX_START", "modulename": "sqlglot.dialects.doris", "qualname": "Doris.HEX_START", "kind": "variable", "doc": "<p></p>\n", "default_value": "&quot;x&#x27;&quot;"}, "sqlglot.dialects.doris.Doris.HEX_END": {"fullname": "sqlglot.dialects.doris.Doris.HEX_END", "modulename": "sqlglot.dialects.doris", "qualname": "Doris.HEX_END", "kind": "variable", "doc": "<p></p>\n", "default_value": "&quot;&#x27;&quot;"}, "sqlglot.dialects.doris.Doris.BYTE_START": {"fullname": "sqlglot.dialects.doris.Doris.BYTE_START", "modulename": "sqlglot.dialects.doris", "qualname": "Doris.BYTE_START", "kind": "variable", "doc": "<p></p>\n", "default_value": "None"}, "sqlglot.dialects.doris.Doris.BYTE_END": {"fullname": "sqlglot.dialects.doris.Doris.BYTE_END", "modulename": "sqlglot.dialects.doris", "qualname": "Doris.BYTE_END", "kind": "variable", "doc": "<p></p>\n", "default_value": "None"}, "sqlglot.dialects.drill": {"fullname": "sqlglot.dialects.drill", "modulename": "sqlglot.dialects.drill", "kind": "module", "doc": "<p></p>\n"}, "sqlglot.dialects.drill.Drill": {"fullname": "sqlglot.dialects.drill.Drill", "modulename": "sqlglot.dialects.drill", "qualname": "Drill", "kind": "class", "doc": "<p></p>\n", "bases": "sqlglot.dialects.dialect.Dialect"}, "sqlglot.dialects.drill.Drill.NORMALIZE_FUNCTIONS": {"fullname": "sqlglot.dialects.drill.Drill.NORMALIZE_FUNCTIONS", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.NORMALIZE_FUNCTIONS", "kind": "variable", "doc": "<p></p>\n", "annotation": ": bool | str", "default_value": "False"}, "sqlglot.dialects.drill.Drill.NULL_ORDERING": {"fullname": "sqlglot.dialects.drill.Drill.NULL_ORDERING", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.NULL_ORDERING", "kind": "variable", "doc": "<p></p>\n", "default_value": "&#x27;nulls_are_last&#x27;"}, "sqlglot.dialects.drill.Drill.DATE_FORMAT": {"fullname": "sqlglot.dialects.drill.Drill.DATE_FORMAT", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.DATE_FORMAT", "kind": "variable", "doc": "<p></p>\n", "default_value": "&quot;&#x27;yyyy-MM-dd&#x27;&quot;"}, "sqlglot.dialects.drill.Drill.DATEINT_FORMAT": {"fullname": "sqlglot.dialects.drill.Drill.DATEINT_FORMAT", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.DATEINT_FORMAT", "kind": "variable", "doc": "<p></p>\n", "default_value": "&quot;&#x27;yyyyMMdd&#x27;&quot;"}, "sqlglot.dialects.drill.Drill.TIME_FORMAT": {"fullname": "sqlglot.dialects.drill.Drill.TIME_FORMAT", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.TIME_FORMAT", "kind": "variable", "doc": "<p></p>\n", "default_value": "&quot;&#x27;yyyy-MM-dd HH:mm:ss&#x27;&quot;"}, "sqlglot.dialects.drill.Drill.SUPPORTS_USER_DEFINED_TYPES": {"fullname": "sqlglot.dialects.drill.Drill.SUPPORTS_USER_DEFINED_TYPES", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.SUPPORTS_USER_DEFINED_TYPES", "kind": "variable", "doc": "<p></p>\n", "default_value": "False"}, "sqlglot.dialects.drill.Drill.SUPPORTS_SEMI_ANTI_JOIN": {"fullname": "sqlglot.dialects.drill.Drill.SUPPORTS_SEMI_ANTI_JOIN", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.SUPPORTS_SEMI_ANTI_JOIN", "kind": "variable", "doc": "<p></p>\n", "default_value": "False"}, "sqlglot.dialects.drill.Drill.TIME_MAPPING": {"fullname": "sqlglot.dialects.drill.Drill.TIME_MAPPING", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.TIME_MAPPING", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;y&#x27;: &#x27;%Y&#x27;, &#x27;Y&#x27;: &#x27;%Y&#x27;, &#x27;YYYY&#x27;: &#x27;%Y&#x27;, &#x27;yyyy&#x27;: &#x27;%Y&#x27;, &#x27;YY&#x27;: &#x27;%y&#x27;, &#x27;yy&#x27;: &#x27;%y&#x27;, &#x27;MMMM&#x27;: &#x27;%B&#x27;, &#x27;MMM&#x27;: &#x27;%b&#x27;, &#x27;MM&#x27;: &#x27;%m&#x27;, &#x27;M&#x27;: &#x27;%-m&#x27;, &#x27;dd&#x27;: &#x27;%d&#x27;, &#x27;d&#x27;: &#x27;%-d&#x27;, &#x27;HH&#x27;: &#x27;%H&#x27;, &#x27;H&#x27;: &#x27;%-H&#x27;, &#x27;hh&#x27;: &#x27;%I&#x27;, &#x27;h&#x27;: &#x27;%-I&#x27;, &#x27;mm&#x27;: &#x27;%M&#x27;, &#x27;m&#x27;: &#x27;%-M&#x27;, &#x27;ss&#x27;: &#x27;%S&#x27;, &#x27;s&#x27;: &#x27;%-S&#x27;, &#x27;SSSSSS&#x27;: &#x27;%f&#x27;, &#x27;a&#x27;: &#x27;%p&#x27;, &#x27;DD&#x27;: &#x27;%j&#x27;, &#x27;D&#x27;: &#x27;%-j&#x27;, &#x27;E&#x27;: &#x27;%a&#x27;, &#x27;EE&#x27;: &#x27;%a&#x27;, &#x27;EEE&#x27;: &#x27;%a&#x27;, &#x27;EEEE&#x27;: &#x27;%A&#x27;, &quot;&#x27;&#x27;T&#x27;&#x27;&quot;: &#x27;T&#x27;}"}, "sqlglot.dialects.drill.Drill.Tokenizer": {"fullname": "sqlglot.dialects.drill.Drill.Tokenizer", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.Tokenizer", "kind": "class", "doc": "<p></p>\n", "bases": "sqlglot.tokens.Tokenizer"}, "sqlglot.dialects.drill.Drill.Tokenizer.IDENTIFIERS": {"fullname": "sqlglot.dialects.drill.Drill.Tokenizer.IDENTIFIERS", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.Tokenizer.IDENTIFIERS", "kind": "variable", "doc": "<p></p>\n", "default_value": "[&#x27;`&#x27;]"}, "sqlglot.dialects.drill.Drill.Tokenizer.STRING_ESCAPES": {"fullname": "sqlglot.dialects.drill.Drill.Tokenizer.STRING_ESCAPES", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.Tokenizer.STRING_ESCAPES", "kind": "variable", "doc": "<p></p>\n", "default_value": "[&#x27;\\\\&#x27;]"}, "sqlglot.dialects.drill.Drill.Tokenizer.ENCODE": {"fullname": "sqlglot.dialects.drill.Drill.Tokenizer.ENCODE", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.Tokenizer.ENCODE", "kind": "variable", "doc": "<p></p>\n", "default_value": "&#x27;utf-8&#x27;"}, "sqlglot.dialects.drill.Drill.Parser": {"fullname": "sqlglot.dialects.drill.Drill.Parser", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.Parser", "kind": "class", "doc": "<p>Parser consumes a list of tokens produced by the Tokenizer and produces a parsed syntax tree.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>error_level:</strong>  The desired error level.\nDefault: ErrorLevel.IMMEDIATE</li>\n<li><strong>error_message_context:</strong>  Determines the amount of context to capture from a\nquery string when displaying the error message (in number of characters).\nDefault: 100</li>\n<li><strong>max_errors:</strong>  Maximum number of error messages to include in a raised ParseError.\nThis is only relevant if error_level is ErrorLevel.RAISE.\nDefault: 3</li>\n</ul>\n", "bases": "sqlglot.parser.Parser"}, "sqlglot.dialects.drill.Drill.Parser.STRICT_CAST": {"fullname": "sqlglot.dialects.drill.Drill.Parser.STRICT_CAST", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.Parser.STRICT_CAST", "kind": "variable", "doc": "<p></p>\n", "default_value": "False"}, "sqlglot.dialects.drill.Drill.Parser.CONCAT_NULL_OUTPUTS_STRING": {"fullname": "sqlglot.dialects.drill.Drill.Parser.CONCAT_NULL_OUTPUTS_STRING", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.Parser.CONCAT_NULL_OUTPUTS_STRING", "kind": "variable", "doc": "<p></p>\n", "default_value": "True"}, "sqlglot.dialects.drill.Drill.Parser.FUNCTIONS": {"fullname": "sqlglot.dialects.drill.Drill.Parser.FUNCTIONS", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.Parser.FUNCTIONS", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;ABS&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Abs&#x27;&gt;&gt;, &#x27;ANY_VALUE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.AnyValue&#x27;&gt;&gt;, &#x27;APPROX_DISTINCT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ApproxDistinct&#x27;&gt;&gt;, &#x27;APPROX_COUNT_DISTINCT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ApproxDistinct&#x27;&gt;&gt;, &#x27;APPROX_QUANTILE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ApproxQuantile&#x27;&gt;&gt;, &#x27;ARRAY&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Array&#x27;&gt;&gt;, &#x27;ARRAY_AGG&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArrayAgg&#x27;&gt;&gt;, &#x27;ARRAY_ALL&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArrayAll&#x27;&gt;&gt;, &#x27;ARRAY_ANY&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArrayAny&#x27;&gt;&gt;, &#x27;ARRAY_CONCAT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArrayConcat&#x27;&gt;&gt;, &#x27;ARRAY_CAT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArrayConcat&#x27;&gt;&gt;, &#x27;ARRAY_CONTAINS&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArrayContains&#x27;&gt;&gt;, &#x27;FILTER&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArrayFilter&#x27;&gt;&gt;, &#x27;ARRAY_FILTER&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArrayFilter&#x27;&gt;&gt;, &#x27;ARRAY_JOIN&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArrayJoin&#x27;&gt;&gt;, &#x27;ARRAY_SIZE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArraySize&#x27;&gt;&gt;, &#x27;ARRAY_SORT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArraySort&#x27;&gt;&gt;, &#x27;ARRAY_SUM&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArraySum&#x27;&gt;&gt;, &#x27;ARRAY_UNION_AGG&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArrayUnionAgg&#x27;&gt;&gt;, &#x27;AVG&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Avg&#x27;&gt;&gt;, &#x27;CASE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Case&#x27;&gt;&gt;, &#x27;CAST&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Cast&#x27;&gt;&gt;, &#x27;CAST_TO_STR_TYPE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.CastToStrType&#x27;&gt;&gt;, &#x27;CEIL&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Ceil&#x27;&gt;&gt;, &#x27;CEILING&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Ceil&#x27;&gt;&gt;, &#x27;CHR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Chr&#x27;&gt;&gt;, &#x27;CHAR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Chr&#x27;&gt;&gt;, &#x27;COALESCE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Coalesce&#x27;&gt;&gt;, &#x27;IFNULL&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Coalesce&#x27;&gt;&gt;, &#x27;NVL&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Coalesce&#x27;&gt;&gt;, &#x27;COLLATE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Collate&#x27;&gt;&gt;, &#x27;CONCAT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Concat&#x27;&gt;&gt;, &#x27;CONCAT_WS&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ConcatWs&#x27;&gt;&gt;, &#x27;COUNT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Count&#x27;&gt;&gt;, &#x27;COUNT_IF&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.CountIf&#x27;&gt;&gt;, &#x27;CURRENT_DATE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.CurrentDate&#x27;&gt;&gt;, &#x27;CURRENT_DATETIME&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.CurrentDatetime&#x27;&gt;&gt;, &#x27;CURRENT_TIME&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.CurrentTime&#x27;&gt;&gt;, &#x27;CURRENT_TIMESTAMP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.CurrentTimestamp&#x27;&gt;&gt;, &#x27;CURRENT_USER&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.CurrentUser&#x27;&gt;&gt;, &#x27;DATE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Date&#x27;&gt;&gt;, &#x27;DATE_ADD&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DateAdd&#x27;&gt;&gt;, &#x27;DATEDIFF&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DateDiff&#x27;&gt;&gt;, &#x27;DATE_DIFF&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DateDiff&#x27;&gt;&gt;, &#x27;DATEFROMPARTS&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DateFromParts&#x27;&gt;&gt;, &#x27;DATE_STR_TO_DATE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DateStrToDate&#x27;&gt;&gt;, &#x27;DATE_SUB&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DateSub&#x27;&gt;&gt;, &#x27;DATE_TO_DATE_STR&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;DATE_TO_DI&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DateToDi&#x27;&gt;&gt;, &#x27;DATE_TRUNC&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DateTrunc&#x27;&gt;&gt;, &#x27;DATETIME_ADD&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DatetimeAdd&#x27;&gt;&gt;, &#x27;DATETIME_DIFF&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DatetimeDiff&#x27;&gt;&gt;, &#x27;DATETIME_SUB&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DatetimeSub&#x27;&gt;&gt;, &#x27;DATETIME_TRUNC&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DatetimeTrunc&#x27;&gt;&gt;, &#x27;DAY&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Day&#x27;&gt;&gt;, &#x27;DAY_OF_MONTH&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DayOfMonth&#x27;&gt;&gt;, &#x27;DAYOFMONTH&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DayOfMonth&#x27;&gt;&gt;, &#x27;DAY_OF_WEEK&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DayOfWeek&#x27;&gt;&gt;, &#x27;DAYOFWEEK&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DayOfWeek&#x27;&gt;&gt;, &#x27;DAY_OF_YEAR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DayOfYear&#x27;&gt;&gt;, &#x27;DAYOFYEAR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DayOfYear&#x27;&gt;&gt;, &#x27;DECODE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Decode&#x27;&gt;&gt;, &#x27;DI_TO_DATE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DiToDate&#x27;&gt;&gt;, &#x27;ENCODE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Encode&#x27;&gt;&gt;, &#x27;EXP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Exp&#x27;&gt;&gt;, &#x27;EXPLODE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Explode&#x27;&gt;&gt;, &#x27;EXPLODE_OUTER&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ExplodeOuter&#x27;&gt;&gt;, &#x27;EXTRACT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Extract&#x27;&gt;&gt;, &#x27;FIRST&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.First&#x27;&gt;&gt;, &#x27;FLATTEN&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Flatten&#x27;&gt;&gt;, &#x27;FLOOR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Floor&#x27;&gt;&gt;, &#x27;FROM_BASE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.FromBase&#x27;&gt;&gt;, &#x27;FROM_BASE64&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.FromBase64&#x27;&gt;&gt;, &#x27;GENERATE_SERIES&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.GenerateSeries&#x27;&gt;&gt;, &#x27;GREATEST&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Greatest&#x27;&gt;&gt;, &#x27;GROUP_CONCAT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.GroupConcat&#x27;&gt;&gt;, &#x27;HEX&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Hex&#x27;&gt;&gt;, &#x27;HLL&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Hll&#x27;&gt;&gt;, &#x27;IF&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.If&#x27;&gt;&gt;, &#x27;INITCAP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Initcap&#x27;&gt;&gt;, &#x27;IS_NAN&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.IsNan&#x27;&gt;&gt;, &#x27;ISNAN&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.IsNan&#x27;&gt;&gt;, &#x27;J_S_O_N_ARRAY&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.JSONArray&#x27;&gt;&gt;, &#x27;J_S_O_N_ARRAY_AGG&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.JSONArrayAgg&#x27;&gt;&gt;, &#x27;JSON_ARRAY_CONTAINS&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.JSONArrayContains&#x27;&gt;&gt;, &#x27;JSONB_EXTRACT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.JSONBExtract&#x27;&gt;&gt;, &#x27;JSONB_EXTRACT_SCALAR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.JSONBExtractScalar&#x27;&gt;&gt;, &#x27;JSON_EXTRACT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.JSONExtract&#x27;&gt;&gt;, &#x27;JSON_EXTRACT_SCALAR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.JSONExtractScalar&#x27;&gt;&gt;, &#x27;JSON_FORMAT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.JSONFormat&#x27;&gt;&gt;, &#x27;J_S_O_N_OBJECT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.JSONObject&#x27;&gt;&gt;, &#x27;J_S_O_N_TABLE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.JSONTable&#x27;&gt;&gt;, &#x27;LAST&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Last&#x27;&gt;&gt;, &#x27;LAST_DATE_OF_MONTH&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.LastDateOfMonth&#x27;&gt;&gt;, &#x27;LEAST&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Least&#x27;&gt;&gt;, &#x27;LEFT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Left&#x27;&gt;&gt;, &#x27;LENGTH&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Length&#x27;&gt;&gt;, &#x27;LEN&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Length&#x27;&gt;&gt;, &#x27;LEVENSHTEIN&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Levenshtein&#x27;&gt;&gt;, &#x27;LN&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Ln&#x27;&gt;&gt;, &#x27;LOG&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Log&#x27;&gt;&gt;, &#x27;LOG10&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Log10&#x27;&gt;&gt;, &#x27;LOG2&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Log2&#x27;&gt;&gt;, &#x27;LOGICAL_AND&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.LogicalAnd&#x27;&gt;&gt;, &#x27;BOOL_AND&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.LogicalAnd&#x27;&gt;&gt;, &#x27;BOOLAND_AGG&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.LogicalAnd&#x27;&gt;&gt;, &#x27;LOGICAL_OR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.LogicalOr&#x27;&gt;&gt;, &#x27;BOOL_OR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.LogicalOr&#x27;&gt;&gt;, &#x27;BOOLOR_AGG&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.LogicalOr&#x27;&gt;&gt;, &#x27;LOWER&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Lower&#x27;&gt;&gt;, &#x27;LCASE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Lower&#x27;&gt;&gt;, &#x27;MD5&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.MD5&#x27;&gt;&gt;, &#x27;MD5_DIGEST&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.MD5Digest&#x27;&gt;&gt;, &#x27;MAP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Map&#x27;&gt;&gt;, &#x27;MAP_FROM_ENTRIES&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.MapFromEntries&#x27;&gt;&gt;, &#x27;MATCH_AGAINST&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.MatchAgainst&#x27;&gt;&gt;, &#x27;MAX&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Max&#x27;&gt;&gt;, &#x27;MIN&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Min&#x27;&gt;&gt;, &#x27;MONTH&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Month&#x27;&gt;&gt;, &#x27;MONTHS_BETWEEN&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.MonthsBetween&#x27;&gt;&gt;, &#x27;NEXT_VALUE_FOR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.NextValueFor&#x27;&gt;&gt;, &#x27;NUMBER_TO_STR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.NumberToStr&#x27;&gt;&gt;, &#x27;NVL2&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Nvl2&#x27;&gt;&gt;, &#x27;OPEN_J_S_O_N&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.OpenJSON&#x27;&gt;&gt;, &#x27;PARAMETERIZED_AGG&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ParameterizedAgg&#x27;&gt;&gt;, &#x27;PARSE_JSON&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ParseJSON&#x27;&gt;&gt;, &#x27;JSON_PARSE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ParseJSON&#x27;&gt;&gt;, &#x27;PERCENTILE_CONT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.PercentileCont&#x27;&gt;&gt;, &#x27;PERCENTILE_DISC&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.PercentileDisc&#x27;&gt;&gt;, &#x27;POSEXPLODE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Posexplode&#x27;&gt;&gt;, &#x27;POSEXPLODE_OUTER&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.PosexplodeOuter&#x27;&gt;&gt;, &#x27;POWER&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Pow&#x27;&gt;&gt;, &#x27;POW&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Pow&#x27;&gt;&gt;, &#x27;PREDICT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Predict&#x27;&gt;&gt;, &#x27;QUANTILE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Quantile&#x27;&gt;&gt;, &#x27;RANGE_N&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.RangeN&#x27;&gt;&gt;, &#x27;READ_CSV&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ReadCSV&#x27;&gt;&gt;, &#x27;REDUCE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Reduce&#x27;&gt;&gt;, &#x27;REGEXP_EXTRACT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.RegexpExtract&#x27;&gt;&gt;, &#x27;REGEXP_I_LIKE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.RegexpILike&#x27;&gt;&gt;, &#x27;REGEXP_LIKE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.RegexpLike&#x27;&gt;&gt;, &#x27;REGEXP_REPLACE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.RegexpReplace&#x27;&gt;&gt;, &#x27;REGEXP_SPLIT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.RegexpSplit&#x27;&gt;&gt;, &#x27;REPEAT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Repeat&#x27;&gt;&gt;, &#x27;RIGHT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Right&#x27;&gt;&gt;, &#x27;ROUND&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Round&#x27;&gt;&gt;, &#x27;ROW_NUMBER&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.RowNumber&#x27;&gt;&gt;, &#x27;SHA&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.SHA&#x27;&gt;&gt;, &#x27;SHA1&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.SHA&#x27;&gt;&gt;, &#x27;SHA2&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.SHA2&#x27;&gt;&gt;, &#x27;SAFE_CONCAT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.SafeConcat&#x27;&gt;&gt;, &#x27;SAFE_DIVIDE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.SafeDivide&#x27;&gt;&gt;, &#x27;SET_AGG&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.SetAgg&#x27;&gt;&gt;, &#x27;SORT_ARRAY&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.SortArray&#x27;&gt;&gt;, &#x27;SPLIT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Split&#x27;&gt;&gt;, &#x27;SQRT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Sqrt&#x27;&gt;&gt;, &#x27;STANDARD_HASH&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StandardHash&#x27;&gt;&gt;, &#x27;STAR_MAP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StarMap&#x27;&gt;&gt;, &#x27;STARTS_WITH&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StartsWith&#x27;&gt;&gt;, &#x27;STARTSWITH&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StartsWith&#x27;&gt;&gt;, &#x27;STDDEV&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Stddev&#x27;&gt;&gt;, &#x27;STDDEV_POP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StddevPop&#x27;&gt;&gt;, &#x27;STDDEV_SAMP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StddevSamp&#x27;&gt;&gt;, &#x27;STR_POSITION&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StrPosition&#x27;&gt;&gt;, &#x27;STR_TO_DATE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StrToDate&#x27;&gt;&gt;, &#x27;STR_TO_MAP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StrToMap&#x27;&gt;&gt;, &#x27;STR_TO_TIME&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StrToTime&#x27;&gt;&gt;, &#x27;STR_TO_UNIX&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StrToUnix&#x27;&gt;&gt;, &#x27;STRUCT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Struct&#x27;&gt;&gt;, &#x27;STRUCT_EXTRACT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StructExtract&#x27;&gt;&gt;, &#x27;STUFF&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Stuff&#x27;&gt;&gt;, &#x27;INSERT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Stuff&#x27;&gt;&gt;, &#x27;SUBSTRING&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Substring&#x27;&gt;&gt;, &#x27;SUM&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Sum&#x27;&gt;&gt;, &#x27;TIME_ADD&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimeAdd&#x27;&gt;&gt;, &#x27;TIME_DIFF&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimeDiff&#x27;&gt;&gt;, &#x27;TIME_STR_TO_DATE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimeStrToDate&#x27;&gt;&gt;, &#x27;TIME_STR_TO_TIME&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimeStrToTime&#x27;&gt;&gt;, &#x27;TIME_STR_TO_UNIX&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimeStrToUnix&#x27;&gt;&gt;, &#x27;TIME_SUB&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimeSub&#x27;&gt;&gt;, &#x27;TIME_TO_STR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimeToStr&#x27;&gt;&gt;, &#x27;TIME_TO_TIME_STR&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;TIME_TO_UNIX&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimeToUnix&#x27;&gt;&gt;, &#x27;TIME_TRUNC&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimeTrunc&#x27;&gt;&gt;, &#x27;TIMESTAMP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Timestamp&#x27;&gt;&gt;, &#x27;TIMESTAMP_ADD&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimestampAdd&#x27;&gt;&gt;, &#x27;TIMESTAMP_DIFF&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimestampDiff&#x27;&gt;&gt;, &#x27;TIMESTAMP_SUB&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimestampSub&#x27;&gt;&gt;, &#x27;TIMESTAMP_TRUNC&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimestampTrunc&#x27;&gt;&gt;, &#x27;TO_BASE64&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ToBase64&#x27;&gt;&gt;, &#x27;TO_CHAR&#x27;: &lt;function format_time_lambda.&lt;locals&gt;._format_time&gt;, &#x27;TO_DAYS&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ToDays&#x27;&gt;&gt;, &#x27;TRANSFORM&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Transform&#x27;&gt;&gt;, &#x27;TRIM&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Trim&#x27;&gt;&gt;, &#x27;TRY_CAST&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TryCast&#x27;&gt;&gt;, &#x27;TS_OR_DI_TO_DI&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TsOrDiToDi&#x27;&gt;&gt;, &#x27;TS_OR_DS_ADD&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TsOrDsAdd&#x27;&gt;&gt;, &#x27;TS_OR_DS_TO_DATE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TsOrDsToDate&#x27;&gt;&gt;, &#x27;TS_OR_DS_TO_DATE_STR&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;UNHEX&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Unhex&#x27;&gt;&gt;, &#x27;UNIX_TO_STR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.UnixToStr&#x27;&gt;&gt;, &#x27;UNIX_TO_TIME&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.UnixToTime&#x27;&gt;&gt;, &#x27;UNIX_TO_TIME_STR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.UnixToTimeStr&#x27;&gt;&gt;, &#x27;UPPER&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Upper&#x27;&gt;&gt;, &#x27;UCASE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Upper&#x27;&gt;&gt;, &#x27;VAR_MAP&#x27;: &lt;function parse_var_map&gt;, &#x27;VARIANCE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Variance&#x27;&gt;&gt;, &#x27;VARIANCE_SAMP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Variance&#x27;&gt;&gt;, &#x27;VAR_SAMP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Variance&#x27;&gt;&gt;, &#x27;VARIANCE_POP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.VariancePop&#x27;&gt;&gt;, &#x27;VAR_POP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.VariancePop&#x27;&gt;&gt;, &#x27;WEEK&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Week&#x27;&gt;&gt;, &#x27;WEEK_OF_YEAR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.WeekOfYear&#x27;&gt;&gt;, &#x27;WEEKOFYEAR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.WeekOfYear&#x27;&gt;&gt;, &#x27;WHEN&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.When&#x27;&gt;&gt;, &#x27;X_M_L_TABLE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.XMLTable&#x27;&gt;&gt;, &#x27;XOR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Xor&#x27;&gt;&gt;, &#x27;YEAR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Year&#x27;&gt;&gt;, &#x27;GLOB&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;LIKE&#x27;: &lt;function parse_like&gt;, &#x27;DATE_FORMAT&#x27;: &lt;function format_time_lambda.&lt;locals&gt;._format_time&gt;, &#x27;TO_TIMESTAMP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimeStrToTime&#x27;&gt;&gt;}"}, "sqlglot.dialects.drill.Drill.Parser.LOG_DEFAULTS_TO_LN": {"fullname": "sqlglot.dialects.drill.Drill.Parser.LOG_DEFAULTS_TO_LN", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.Parser.LOG_DEFAULTS_TO_LN", "kind": "variable", "doc": "<p></p>\n", "default_value": "True"}, "sqlglot.dialects.drill.Drill.Parser.TABLE_ALIAS_TOKENS": {"fullname": "sqlglot.dialects.drill.Drill.Parser.TABLE_ALIAS_TOKENS", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.Parser.TABLE_ALIAS_TOKENS", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&lt;TokenType.DATEMULTIRANGE: &#x27;DATEMULTIRANGE&#x27;&gt;, &lt;TokenType.PERCENT: &#x27;PERCENT&#x27;&gt;, &lt;TokenType.UMEDIUMINT: &#x27;UMEDIUMINT&#x27;&gt;, &lt;TokenType.DOUBLE: &#x27;DOUBLE&#x27;&gt;, &lt;TokenType.PIVOT: &#x27;PIVOT&#x27;&gt;, &lt;TokenType.TRUE: &#x27;TRUE&#x27;&gt;, &lt;TokenType.TEXT: &#x27;TEXT&#x27;&gt;, &lt;TokenType.EXECUTE: &#x27;EXECUTE&#x27;&gt;, &lt;TokenType.DESC: &#x27;DESC&#x27;&gt;, &lt;TokenType.CACHE: &#x27;CACHE&#x27;&gt;, &lt;TokenType.FUNCTION: &#x27;FUNCTION&#x27;&gt;, &lt;TokenType.DATE: &#x27;DATE&#x27;&gt;, &lt;TokenType.BIT: &#x27;BIT&#x27;&gt;, &lt;TokenType.SETTINGS: &#x27;SETTINGS&#x27;&gt;, &lt;TokenType.TINYTEXT: &#x27;TINYTEXT&#x27;&gt;, &lt;TokenType.ROWVERSION: &#x27;ROWVERSION&#x27;&gt;, &lt;TokenType.CURRENT_USER: &#x27;CURRENT_USER&#x27;&gt;, &lt;TokenType.GEOGRAPHY: &#x27;GEOGRAPHY&#x27;&gt;, &lt;TokenType.BIGDECIMAL: &#x27;BIGDECIMAL&#x27;&gt;, &lt;TokenType.INT4MULTIRANGE: &#x27;INT4MULTIRANGE&#x27;&gt;, &lt;TokenType.CASE: &#x27;CASE&#x27;&gt;, &lt;TokenType.ANTI: &#x27;ANTI&#x27;&gt;, &lt;TokenType.EXISTS: &#x27;EXISTS&#x27;&gt;, &lt;TokenType.INDEX: &#x27;INDEX&#x27;&gt;, &lt;TokenType.UUID: &#x27;UUID&#x27;&gt;, &lt;TokenType.LOWCARDINALITY: &#x27;LOWCARDINALITY&#x27;&gt;, &lt;TokenType.UNKNOWN: &#x27;UNKNOWN&#x27;&gt;, &lt;TokenType.MEDIUMINT: &#x27;MEDIUMINT&#x27;&gt;, &lt;TokenType.CURRENT_DATETIME: &#x27;CURRENT_DATETIME&#x27;&gt;, &lt;TokenType.VOLATILE: &#x27;VOLATILE&#x27;&gt;, &lt;TokenType.ALL: &#x27;ALL&#x27;&gt;, &lt;TokenType.TINYBLOB: &#x27;TINYBLOB&#x27;&gt;, &lt;TokenType.TSMULTIRANGE: &#x27;TSMULTIRANGE&#x27;&gt;, &lt;TokenType.TIMETZ: &#x27;TIMETZ&#x27;&gt;, &lt;TokenType.ENUM16: &#x27;ENUM16&#x27;&gt;, &lt;TokenType.SHOW: &#x27;SHOW&#x27;&gt;, &lt;TokenType.OVERLAPS: &#x27;OVERLAPS&#x27;&gt;, &lt;TokenType.SMALLSERIAL: &#x27;SMALLSERIAL&#x27;&gt;, &lt;TokenType.COLLATE: &#x27;COLLATE&#x27;&gt;, &lt;TokenType.COMMENT: &#x27;COMMENT&#x27;&gt;, &lt;TokenType.FILTER: &#x27;FILTER&#x27;&gt;, &lt;TokenType.HLLSKETCH: &#x27;HLLSKETCH&#x27;&gt;, &lt;TokenType.ROWS: &#x27;ROWS&#x27;&gt;, &lt;TokenType.VARCHAR: &#x27;VARCHAR&#x27;&gt;, &lt;TokenType.UPDATE: &#x27;UPDATE&#x27;&gt;, &lt;TokenType.DICTIONARY: &#x27;DICTIONARY&#x27;&gt;, &lt;TokenType.TABLE: &#x27;TABLE&#x27;&gt;, &lt;TokenType.USERDEFINED: &#x27;USERDEFINED&#x27;&gt;, &lt;TokenType.DIV: &#x27;DIV&#x27;&gt;, &lt;TokenType.UNPIVOT: &#x27;UNPIVOT&#x27;&gt;, &lt;TokenType.FIXEDSTRING: &#x27;FIXEDSTRING&#x27;&gt;, &lt;TokenType.VARIANT: &#x27;VARIANT&#x27;&gt;, &lt;TokenType.BIGINT: &#x27;BIGINT&#x27;&gt;, &lt;TokenType.PARTITION: &#x27;PARTITION&#x27;&gt;, &lt;TokenType.DATERANGE: &#x27;DATERANGE&#x27;&gt;, &lt;TokenType.STRUCT: &#x27;STRUCT&#x27;&gt;, &lt;TokenType.ASC: &#x27;ASC&#x27;&gt;, &lt;TokenType.PRAGMA: &#x27;PRAGMA&#x27;&gt;, &lt;TokenType.PROCEDURE: &#x27;PROCEDURE&#x27;&gt;, &lt;TokenType.SEMI: &#x27;SEMI&#x27;&gt;, &lt;TokenType.SOME: &#x27;SOME&#x27;&gt;, &lt;TokenType.VARBINARY: &#x27;VARBINARY&#x27;&gt;, &lt;TokenType.NUMRANGE: &#x27;NUMRANGE&#x27;&gt;, &lt;TokenType.ESCAPE: &#x27;ESCAPE&#x27;&gt;, &lt;TokenType.ANY: &#x27;ANY&#x27;&gt;, &lt;TokenType.DELETE: &#x27;DELETE&#x27;&gt;, &lt;TokenType.LONGTEXT: &#x27;LONGTEXT&#x27;&gt;, &lt;TokenType.LOAD: &#x27;LOAD&#x27;&gt;, &lt;TokenType.NEXT: &#x27;NEXT&#x27;&gt;, &lt;TokenType.TOP: &#x27;TOP&#x27;&gt;, &lt;TokenType.DEFAULT: &#x27;DEFAULT&#x27;&gt;, &lt;TokenType.TIMESTAMP_MS: &#x27;TIMESTAMP_MS&#x27;&gt;, &lt;TokenType.HSTORE: &#x27;HSTORE&#x27;&gt;, &lt;TokenType.AUTO_INCREMENT: &#x27;AUTO_INCREMENT&#x27;&gt;, &lt;TokenType.OVERWRITE: &#x27;OVERWRITE&#x27;&gt;, &lt;TokenType.IS: &#x27;IS&#x27;&gt;, &lt;TokenType.NULL: &#x27;NULL&#x27;&gt;, &lt;TokenType.TIMESTAMP_NS: &#x27;TIMESTAMP_NS&#x27;&gt;, &lt;TokenType.VAR: &#x27;VAR&#x27;&gt;, &lt;TokenType.UNIQUEIDENTIFIER: &#x27;UNIQUEIDENTIFIER&#x27;&gt;, &lt;TokenType.IPADDRESS: &#x27;IPADDRESS&#x27;&gt;, &lt;TokenType.TIME: &#x27;TIME&#x27;&gt;, &lt;TokenType.TIMESTAMPLTZ: &#x27;TIMESTAMPLTZ&#x27;&gt;, &lt;TokenType.TINYINT: &#x27;TINYINT&#x27;&gt;, &lt;TokenType.UINT128: &#x27;UINT128&#x27;&gt;, &lt;TokenType.UINT256: &#x27;UINT256&#x27;&gt;, &lt;TokenType.NCHAR: &#x27;NCHAR&#x27;&gt;, &lt;TokenType.COMMAND: &#x27;COMMAND&#x27;&gt;, &lt;TokenType.BOOLEAN: &#x27;BOOLEAN&#x27;&gt;, &lt;TokenType.SUPER: &#x27;SUPER&#x27;&gt;, &lt;TokenType.CONSTRAINT: &#x27;CONSTRAINT&#x27;&gt;, &lt;TokenType.UDECIMAL: &#x27;UDECIMAL&#x27;&gt;, &lt;TokenType.REFERENCES: &#x27;REFERENCES&#x27;&gt;, &lt;TokenType.CURRENT_TIMESTAMP: &#x27;CURRENT_TIMESTAMP&#x27;&gt;, &lt;TokenType.INT4RANGE: &#x27;INT4RANGE&#x27;&gt;, &lt;TokenType.VIEW: &#x27;VIEW&#x27;&gt;, &lt;TokenType.BIGSERIAL: &#x27;BIGSERIAL&#x27;&gt;, &lt;TokenType.MONEY: &#x27;MONEY&#x27;&gt;, &lt;TokenType.COMMIT: &#x27;COMMIT&#x27;&gt;, &lt;TokenType.LONGBLOB: &#x27;LONGBLOB&#x27;&gt;, &lt;TokenType.INT8MULTIRANGE: &#x27;INT8MULTIRANGE&#x27;&gt;, &lt;TokenType.DATETIME64: &#x27;DATETIME64&#x27;&gt;, &lt;TokenType.IMAGE: &#x27;IMAGE&#x27;&gt;, &lt;TokenType.UTINYINT: &#x27;UTINYINT&#x27;&gt;, &lt;TokenType.MERGE: &#x27;MERGE&#x27;&gt;, &lt;TokenType.INT128: &#x27;INT128&#x27;&gt;, &lt;TokenType.ENUM8: &#x27;ENUM8&#x27;&gt;, &lt;TokenType.DATABASE: &#x27;DATABASE&#x27;&gt;, &lt;TokenType.SMALLMONEY: &#x27;SMALLMONEY&#x27;&gt;, &lt;TokenType.CURRENT_DATE: &#x27;CURRENT_DATE&#x27;&gt;, &lt;TokenType.TSRANGE: &#x27;TSRANGE&#x27;&gt;, &lt;TokenType.TEMPORARY: &#x27;TEMPORARY&#x27;&gt;, &lt;TokenType.SET: &#x27;SET&#x27;&gt;, &lt;TokenType.INT256: &#x27;INT256&#x27;&gt;, &lt;TokenType.DESCRIBE: &#x27;DESCRIBE&#x27;&gt;, &lt;TokenType.MAP: &#x27;MAP&#x27;&gt;, &lt;TokenType.FORMAT: &#x27;FORMAT&#x27;&gt;, &lt;TokenType.CURRENT_TIME: &#x27;CURRENT_TIME&#x27;&gt;, &lt;TokenType.END: &#x27;END&#x27;&gt;, &lt;TokenType.UINT: &#x27;UINT&#x27;&gt;, &lt;TokenType.CHAR: &#x27;CHAR&#x27;&gt;, &lt;TokenType.NULLABLE: &#x27;NULLABLE&#x27;&gt;, &lt;TokenType.ROW: &#x27;ROW&#x27;&gt;, &lt;TokenType.MEDIUMBLOB: &#x27;MEDIUMBLOB&#x27;&gt;, &lt;TokenType.INT8RANGE: &#x27;INT8RANGE&#x27;&gt;, &lt;TokenType.FLOAT: &#x27;FLOAT&#x27;&gt;, &lt;TokenType.XML: &#x27;XML&#x27;&gt;, &lt;TokenType.ORDINALITY: &#x27;ORDINALITY&#x27;&gt;, &lt;TokenType.NESTED: &#x27;NESTED&#x27;&gt;, &lt;TokenType.IPPREFIX: &#x27;IPPREFIX&#x27;&gt;, &lt;TokenType.DECIMAL: &#x27;DECIMAL&#x27;&gt;, &lt;TokenType.DATETIME: &#x27;DATETIME&#x27;&gt;, &lt;TokenType.OBJECT_IDENTIFIER: &#x27;OBJECT_IDENTIFIER&#x27;&gt;, &lt;TokenType.TIMESTAMP_S: &#x27;TIMESTAMP_S&#x27;&gt;, &lt;TokenType.SERIAL: &#x27;SERIAL&#x27;&gt;, &lt;TokenType.TIMESTAMPTZ: &#x27;TIMESTAMPTZ&#x27;&gt;, &lt;TokenType.COLUMN: &#x27;COLUMN&#x27;&gt;, &lt;TokenType.SCHEMA: &#x27;SCHEMA&#x27;&gt;, &lt;TokenType.OBJECT: &#x27;OBJECT&#x27;&gt;, &lt;TokenType.INET: &#x27;INET&#x27;&gt;, &lt;TokenType.FIRST: &#x27;FIRST&#x27;&gt;, &lt;TokenType.JSON: &#x27;JSON&#x27;&gt;, &lt;TokenType.BINARY: &#x27;BINARY&#x27;&gt;, &lt;TokenType.NVARCHAR: &#x27;NVARCHAR&#x27;&gt;, &lt;TokenType.UNIQUE: &#x27;UNIQUE&#x27;&gt;, &lt;TokenType.FALSE: &#x27;FALSE&#x27;&gt;, &lt;TokenType.SMALLINT: &#x27;SMALLINT&#x27;&gt;, &lt;TokenType.KEEP: &#x27;KEEP&#x27;&gt;, &lt;TokenType.GEOMETRY: &#x27;GEOMETRY&#x27;&gt;, &lt;TokenType.TIMESTAMP: &#x27;TIMESTAMP&#x27;&gt;, &lt;TokenType.ARRAY: &#x27;ARRAY&#x27;&gt;, &lt;TokenType.PSEUDO_TYPE: &#x27;PSEUDO_TYPE&#x27;&gt;, &lt;TokenType.MEDIUMTEXT: &#x27;MEDIUMTEXT&#x27;&gt;, &lt;TokenType.USMALLINT: &#x27;USMALLINT&#x27;&gt;, &lt;TokenType.TSTZRANGE: &#x27;TSTZRANGE&#x27;&gt;, &lt;TokenType.RANGE: &#x27;RANGE&#x27;&gt;, &lt;TokenType.TSTZMULTIRANGE: &#x27;TSTZMULTIRANGE&#x27;&gt;, &lt;TokenType.YEAR: &#x27;YEAR&#x27;&gt;, &lt;TokenType.ISNULL: &#x27;ISNULL&#x27;&gt;, &lt;TokenType.UBIGINT: &#x27;UBIGINT&#x27;&gt;, &lt;TokenType.NUMMULTIRANGE: &#x27;NUMMULTIRANGE&#x27;&gt;, &lt;TokenType.INT: &#x27;INT&#x27;&gt;, &lt;TokenType.JSONB: &#x27;JSONB&#x27;&gt;, &lt;TokenType.MODEL: &#x27;MODEL&#x27;&gt;, &lt;TokenType.INTERVAL: &#x27;INTERVAL&#x27;&gt;, &lt;TokenType.BEGIN: &#x27;BEGIN&#x27;&gt;, &lt;TokenType.KILL: &#x27;KILL&#x27;&gt;, &lt;TokenType.ENUM: &#x27;ENUM&#x27;&gt;}"}, "sqlglot.dialects.drill.Drill.Parser.TOKENIZER_CLASS": {"fullname": "sqlglot.dialects.drill.Drill.Parser.TOKENIZER_CLASS", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.Parser.TOKENIZER_CLASS", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Type[sqlglot.tokens.Tokenizer]", "default_value": "&lt;class &#x27;sqlglot.dialects.drill.Drill.Tokenizer&#x27;&gt;"}, "sqlglot.dialects.drill.Drill.Parser.SUPPORTS_USER_DEFINED_TYPES": {"fullname": "sqlglot.dialects.drill.Drill.Parser.SUPPORTS_USER_DEFINED_TYPES", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.Parser.SUPPORTS_USER_DEFINED_TYPES", "kind": "variable", "doc": "<p></p>\n", "default_value": "False"}, "sqlglot.dialects.drill.Drill.Parser.NORMALIZE_FUNCTIONS": {"fullname": "sqlglot.dialects.drill.Drill.Parser.NORMALIZE_FUNCTIONS", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.Parser.NORMALIZE_FUNCTIONS", "kind": "variable", "doc": "<p></p>\n", "default_value": "False"}, "sqlglot.dialects.drill.Drill.Parser.NULL_ORDERING": {"fullname": "sqlglot.dialects.drill.Drill.Parser.NULL_ORDERING", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.Parser.NULL_ORDERING", "kind": "variable", "doc": "<p></p>\n", "annotation": ": str", "default_value": "&#x27;nulls_are_last&#x27;"}, "sqlglot.dialects.drill.Drill.Parser.SHOW_TRIE": {"fullname": "sqlglot.dialects.drill.Drill.Parser.SHOW_TRIE", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.Parser.SHOW_TRIE", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict", "default_value": "{}"}, "sqlglot.dialects.drill.Drill.Parser.SET_TRIE": {"fullname": "sqlglot.dialects.drill.Drill.Parser.SET_TRIE", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.Parser.SET_TRIE", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict", "default_value": "{&#x27;GLOBAL&#x27;: {0: True}, &#x27;LOCAL&#x27;: {0: True}, &#x27;SESSION&#x27;: {0: True}, &#x27;TRANSACTION&#x27;: {0: True}}"}, "sqlglot.dialects.drill.Drill.Parser.FORMAT_TRIE": {"fullname": "sqlglot.dialects.drill.Drill.Parser.FORMAT_TRIE", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.Parser.FORMAT_TRIE", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict", "default_value": "{&#x27;y&#x27;: {0: True, &#x27;y&#x27;: {&#x27;y&#x27;: {&#x27;y&#x27;: {0: True}}, 0: True}}, &#x27;Y&#x27;: {0: True, &#x27;Y&#x27;: {&#x27;Y&#x27;: {&#x27;Y&#x27;: {0: True}}, 0: True}}, &#x27;M&#x27;: {&#x27;M&#x27;: {&#x27;M&#x27;: {&#x27;M&#x27;: {0: True}, 0: True}, 0: True}, 0: True}, &#x27;d&#x27;: {&#x27;d&#x27;: {0: True}, 0: True}, &#x27;H&#x27;: {&#x27;H&#x27;: {0: True}, 0: True}, &#x27;h&#x27;: {&#x27;h&#x27;: {0: True}, 0: True}, &#x27;m&#x27;: {&#x27;m&#x27;: {0: True}, 0: True}, &#x27;s&#x27;: {&#x27;s&#x27;: {0: True}, 0: True}, &#x27;S&#x27;: {&#x27;S&#x27;: {&#x27;S&#x27;: {&#x27;S&#x27;: {&#x27;S&#x27;: {&#x27;S&#x27;: {0: True}}}}}}, &#x27;a&#x27;: {0: True}, &#x27;D&#x27;: {&#x27;D&#x27;: {0: True}, 0: True}, &#x27;E&#x27;: {0: True, &#x27;E&#x27;: {0: True, &#x27;E&#x27;: {0: True, &#x27;E&#x27;: {0: True}}}}, &quot;&#x27;&quot;: {&quot;&#x27;&quot;: {&#x27;T&#x27;: {&quot;&#x27;&quot;: {&quot;&#x27;&quot;: {0: True}}}}}}"}, "sqlglot.dialects.drill.Drill.Parser.TIME_MAPPING": {"fullname": "sqlglot.dialects.drill.Drill.Parser.TIME_MAPPING", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.Parser.TIME_MAPPING", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict[str, str]", "default_value": "{&#x27;y&#x27;: &#x27;%Y&#x27;, &#x27;Y&#x27;: &#x27;%Y&#x27;, &#x27;YYYY&#x27;: &#x27;%Y&#x27;, &#x27;yyyy&#x27;: &#x27;%Y&#x27;, &#x27;YY&#x27;: &#x27;%y&#x27;, &#x27;yy&#x27;: &#x27;%y&#x27;, &#x27;MMMM&#x27;: &#x27;%B&#x27;, &#x27;MMM&#x27;: &#x27;%b&#x27;, &#x27;MM&#x27;: &#x27;%m&#x27;, &#x27;M&#x27;: &#x27;%-m&#x27;, &#x27;dd&#x27;: &#x27;%d&#x27;, &#x27;d&#x27;: &#x27;%-d&#x27;, &#x27;HH&#x27;: &#x27;%H&#x27;, &#x27;H&#x27;: &#x27;%-H&#x27;, &#x27;hh&#x27;: &#x27;%I&#x27;, &#x27;h&#x27;: &#x27;%-I&#x27;, &#x27;mm&#x27;: &#x27;%M&#x27;, &#x27;m&#x27;: &#x27;%-M&#x27;, &#x27;ss&#x27;: &#x27;%S&#x27;, &#x27;s&#x27;: &#x27;%-S&#x27;, &#x27;SSSSSS&#x27;: &#x27;%f&#x27;, &#x27;a&#x27;: &#x27;%p&#x27;, &#x27;DD&#x27;: &#x27;%j&#x27;, &#x27;D&#x27;: &#x27;%-j&#x27;, &#x27;E&#x27;: &#x27;%a&#x27;, &#x27;EE&#x27;: &#x27;%a&#x27;, &#x27;EEE&#x27;: &#x27;%a&#x27;, &#x27;EEEE&#x27;: &#x27;%A&#x27;, &quot;&#x27;&#x27;T&#x27;&#x27;&quot;: &#x27;T&#x27;}"}, "sqlglot.dialects.drill.Drill.Parser.TIME_TRIE": {"fullname": "sqlglot.dialects.drill.Drill.Parser.TIME_TRIE", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.Parser.TIME_TRIE", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict", "default_value": "{&#x27;y&#x27;: {0: True, &#x27;y&#x27;: {&#x27;y&#x27;: {&#x27;y&#x27;: {0: True}}, 0: True}}, &#x27;Y&#x27;: {0: True, &#x27;Y&#x27;: {&#x27;Y&#x27;: {&#x27;Y&#x27;: {0: True}}, 0: True}}, &#x27;M&#x27;: {&#x27;M&#x27;: {&#x27;M&#x27;: {&#x27;M&#x27;: {0: True}, 0: True}, 0: True}, 0: True}, &#x27;d&#x27;: {&#x27;d&#x27;: {0: True}, 0: True}, &#x27;H&#x27;: {&#x27;H&#x27;: {0: True}, 0: True}, &#x27;h&#x27;: {&#x27;h&#x27;: {0: True}, 0: True}, &#x27;m&#x27;: {&#x27;m&#x27;: {0: True}, 0: True}, &#x27;s&#x27;: {&#x27;s&#x27;: {0: True}, 0: True}, &#x27;S&#x27;: {&#x27;S&#x27;: {&#x27;S&#x27;: {&#x27;S&#x27;: {&#x27;S&#x27;: {&#x27;S&#x27;: {0: True}}}}}}, &#x27;a&#x27;: {0: True}, &#x27;D&#x27;: {&#x27;D&#x27;: {0: True}, 0: True}, &#x27;E&#x27;: {0: True, &#x27;E&#x27;: {0: True, &#x27;E&#x27;: {0: True, &#x27;E&#x27;: {0: True}}}}, &quot;&#x27;&quot;: {&quot;&#x27;&quot;: {&#x27;T&#x27;: {&quot;&#x27;&quot;: {&quot;&#x27;&quot;: {0: True}}}}}}"}, "sqlglot.dialects.drill.Drill.Generator": {"fullname": "sqlglot.dialects.drill.Drill.Generator", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.Generator", "kind": "class", "doc": "<p>Generator converts a given syntax tree to the corresponding SQL string.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>pretty:</strong>  Whether or not to format the produced SQL string.\nDefault: False.</li>\n<li><strong>identify:</strong>  Determines when an identifier should be quoted. Possible values are:\nFalse (default): Never quote, except in cases where it's mandatory by the dialect.\nTrue or 'always': Always quote.\n'safe': Only quote identifiers that are case insensitive.</li>\n<li><strong>normalize:</strong>  Whether or not to normalize identifiers to lowercase.\nDefault: False.</li>\n<li><strong>pad:</strong>  Determines the pad size in a formatted string.\nDefault: 2.</li>\n<li><strong>indent:</strong>  Determines the indentation size in a formatted string.\nDefault: 2.</li>\n<li><strong>normalize_functions:</strong>  Whether or not to normalize all function names. Possible values are:\n\"upper\" or True (default): Convert names to uppercase.\n\"lower\": Convert names to lowercase.\nFalse: Disables function name normalization.</li>\n<li><strong>unsupported_level:</strong>  Determines the generator's behavior when it encounters unsupported expressions.\nDefault ErrorLevel.WARN.</li>\n<li><strong>max_unsupported:</strong>  Maximum number of unsupported messages to include in a raised UnsupportedError.\nThis is only relevant if unsupported_level is ErrorLevel.RAISE.\nDefault: 3</li>\n<li><strong>leading_comma:</strong>  Determines whether or not the comma is leading or trailing in select expressions.\nThis is only relevant when generating in pretty mode.\nDefault: False</li>\n<li><strong>max_text_width:</strong>  The max number of characters in a segment before creating new lines in pretty mode.\nThe default is on the smaller end because the length only represents a segment and not the true\nline length.\nDefault: 80</li>\n<li><strong>comments:</strong>  Whether or not to preserve comments in the output SQL code.\nDefault: True</li>\n</ul>\n", "bases": "sqlglot.generator.Generator"}, "sqlglot.dialects.drill.Drill.Generator.JOIN_HINTS": {"fullname": "sqlglot.dialects.drill.Drill.Generator.JOIN_HINTS", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.Generator.JOIN_HINTS", "kind": "variable", "doc": "<p></p>\n", "default_value": "False"}, "sqlglot.dialects.drill.Drill.Generator.TABLE_HINTS": {"fullname": "sqlglot.dialects.drill.Drill.Generator.TABLE_HINTS", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.Generator.TABLE_HINTS", "kind": "variable", "doc": "<p></p>\n", "default_value": "False"}, "sqlglot.dialects.drill.Drill.Generator.QUERY_HINTS": {"fullname": "sqlglot.dialects.drill.Drill.Generator.QUERY_HINTS", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.Generator.QUERY_HINTS", "kind": "variable", "doc": "<p></p>\n", "default_value": "False"}, "sqlglot.dialects.drill.Drill.Generator.NVL2_SUPPORTED": {"fullname": "sqlglot.dialects.drill.Drill.Generator.NVL2_SUPPORTED", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.Generator.NVL2_SUPPORTED", "kind": "variable", "doc": "<p></p>\n", "default_value": "False"}, "sqlglot.dialects.drill.Drill.Generator.TYPE_MAPPING": {"fullname": "sqlglot.dialects.drill.Drill.Generator.TYPE_MAPPING", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.Generator.TYPE_MAPPING", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&lt;Type.NCHAR: &#x27;NCHAR&#x27;&gt;: &#x27;VARCHAR&#x27;, &lt;Type.NVARCHAR: &#x27;NVARCHAR&#x27;&gt;: &#x27;VARCHAR&#x27;, &lt;Type.MEDIUMTEXT: &#x27;MEDIUMTEXT&#x27;&gt;: &#x27;TEXT&#x27;, &lt;Type.LONGTEXT: &#x27;LONGTEXT&#x27;&gt;: &#x27;TEXT&#x27;, &lt;Type.TINYTEXT: &#x27;TINYTEXT&#x27;&gt;: &#x27;TEXT&#x27;, &lt;Type.MEDIUMBLOB: &#x27;MEDIUMBLOB&#x27;&gt;: &#x27;BLOB&#x27;, &lt;Type.LONGBLOB: &#x27;LONGBLOB&#x27;&gt;: &#x27;BLOB&#x27;, &lt;Type.TINYBLOB: &#x27;TINYBLOB&#x27;&gt;: &#x27;BLOB&#x27;, &lt;Type.INET: &#x27;INET&#x27;&gt;: &#x27;INET&#x27;, &lt;Type.INT: &#x27;INT&#x27;&gt;: &#x27;INTEGER&#x27;, &lt;Type.SMALLINT: &#x27;SMALLINT&#x27;&gt;: &#x27;INTEGER&#x27;, &lt;Type.TINYINT: &#x27;TINYINT&#x27;&gt;: &#x27;INTEGER&#x27;, &lt;Type.BINARY: &#x27;BINARY&#x27;&gt;: &#x27;VARBINARY&#x27;, &lt;Type.TEXT: &#x27;TEXT&#x27;&gt;: &#x27;VARCHAR&#x27;, &lt;Type.TIMESTAMPLTZ: &#x27;TIMESTAMPLTZ&#x27;&gt;: &#x27;TIMESTAMP&#x27;, &lt;Type.TIMESTAMPTZ: &#x27;TIMESTAMPTZ&#x27;&gt;: &#x27;TIMESTAMP&#x27;, &lt;Type.DATETIME: &#x27;DATETIME&#x27;&gt;: &#x27;TIMESTAMP&#x27;}"}, "sqlglot.dialects.drill.Drill.Generator.PROPERTIES_LOCATION": {"fullname": "sqlglot.dialects.drill.Drill.Generator.PROPERTIES_LOCATION", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.Generator.PROPERTIES_LOCATION", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&lt;class &#x27;sqlglot.expressions.AlgorithmProperty&#x27;&gt;: &lt;Location.POST_CREATE: &#x27;POST_CREATE&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.AutoIncrementProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.BlockCompressionProperty&#x27;&gt;: &lt;Location.POST_NAME: &#x27;POST_NAME&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.CharacterSetProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.ChecksumProperty&#x27;&gt;: &lt;Location.POST_NAME: &#x27;POST_NAME&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.CollateProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.CopyGrantsProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.Cluster&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.ClusteredByProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.DataBlocksizeProperty&#x27;&gt;: &lt;Location.POST_NAME: &#x27;POST_NAME&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.DefinerProperty&#x27;&gt;: &lt;Location.POST_CREATE: &#x27;POST_CREATE&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.DictRange&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.DictProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.DistKeyProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.DistStyleProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.EngineProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.ExecuteAsProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.ExternalProperty&#x27;&gt;: &lt;Location.POST_CREATE: &#x27;POST_CREATE&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.FallbackProperty&#x27;&gt;: &lt;Location.POST_NAME: &#x27;POST_NAME&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.FileFormatProperty&#x27;&gt;: &lt;Location.POST_WITH: &#x27;POST_WITH&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.FreespaceProperty&#x27;&gt;: &lt;Location.POST_NAME: &#x27;POST_NAME&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.HeapProperty&#x27;&gt;: &lt;Location.POST_WITH: &#x27;POST_WITH&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.InputModelProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.IsolatedLoadingProperty&#x27;&gt;: &lt;Location.POST_NAME: &#x27;POST_NAME&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.JournalProperty&#x27;&gt;: &lt;Location.POST_NAME: &#x27;POST_NAME&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.LanguageProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.LikeProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.LocationProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.LockingProperty&#x27;&gt;: &lt;Location.POST_ALIAS: &#x27;POST_ALIAS&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.LogProperty&#x27;&gt;: &lt;Location.POST_NAME: &#x27;POST_NAME&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.MaterializedProperty&#x27;&gt;: &lt;Location.POST_CREATE: &#x27;POST_CREATE&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.MergeBlockRatioProperty&#x27;&gt;: &lt;Location.POST_NAME: &#x27;POST_NAME&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.NoPrimaryIndexProperty&#x27;&gt;: &lt;Location.POST_EXPRESSION: &#x27;POST_EXPRESSION&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.OnProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.OnCommitProperty&#x27;&gt;: &lt;Location.POST_EXPRESSION: &#x27;POST_EXPRESSION&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.Order&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.OutputModelProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.PartitionedByProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.PrimaryKey&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.Property&#x27;&gt;: &lt;Location.POST_WITH: &#x27;POST_WITH&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.RemoteWithConnectionModelProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.ReturnsProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.RowFormatProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.RowFormatDelimitedProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.RowFormatSerdeProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.SampleProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.SchemaCommentProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.SerdeProperties&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.Set&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.SettingsProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.SetProperty&#x27;&gt;: &lt;Location.POST_CREATE: &#x27;POST_CREATE&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.SortKeyProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.SqlSecurityProperty&#x27;&gt;: &lt;Location.POST_CREATE: &#x27;POST_CREATE&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.StabilityProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.TemporaryProperty&#x27;&gt;: &lt;Location.POST_CREATE: &#x27;POST_CREATE&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.ToTableProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.TransientProperty&#x27;&gt;: &lt;Location.POST_CREATE: &#x27;POST_CREATE&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.TransformModelProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.MergeTreeTTL&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.VolatileProperty&#x27;&gt;: &lt;Location.UNSUPPORTED: &#x27;UNSUPPORTED&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.WithDataProperty&#x27;&gt;: &lt;Location.POST_EXPRESSION: &#x27;POST_EXPRESSION&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.WithJournalTableProperty&#x27;&gt;: &lt;Location.POST_NAME: &#x27;POST_NAME&#x27;&gt;}"}, "sqlglot.dialects.drill.Drill.Generator.TRANSFORMS": {"fullname": "sqlglot.dialects.drill.Drill.Generator.TRANSFORMS", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.Generator.TRANSFORMS", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&lt;class &#x27;sqlglot.expressions.DateAdd&#x27;&gt;: &lt;function _date_add_sql.&lt;locals&gt;.func&gt;, &lt;class &#x27;sqlglot.expressions.TsOrDsAdd&#x27;&gt;: &lt;function Drill.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.CaseSpecificColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.CharacterSetColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.CharacterSetProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.CheckColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.ClusteredColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.CollateColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.CopyGrantsProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.CommentColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.DateFormatColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.DefaultColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.EncodeColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.ExecuteAsProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.ExternalProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.HeapProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.InlineLengthColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.InputModelProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.IntervalSpan&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.LanguageProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.LocationProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.LogProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.MaterializedProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.NoPrimaryIndexProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.NonClusteredColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.NotForReplicationColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.OnCommitProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.OnProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.OnUpdateColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.OutputModelProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.PathColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.RemoteWithConnectionModelProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.ReturnsProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.SampleProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.SetProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.SettingsProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.SqlSecurityProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.StabilityProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.TemporaryProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.ToTableProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.TransientProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.TransformModelProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.TitleColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.UppercaseColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.VarMap&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.VolatileProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.WithJournalTableProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.CurrentTimestamp&#x27;&gt;: &lt;function Drill.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.ArrayContains&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.ArraySize&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.Create&#x27;&gt;: &lt;function create_with_partitions_sql&gt;, &lt;class &#x27;sqlglot.expressions.DateStrToDate&#x27;&gt;: &lt;function datestrtodate_sql&gt;, &lt;class &#x27;sqlglot.expressions.DateSub&#x27;&gt;: &lt;function _date_add_sql.&lt;locals&gt;.func&gt;, &lt;class &#x27;sqlglot.expressions.DateToDi&#x27;&gt;: &lt;function Drill.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.DiToDate&#x27;&gt;: &lt;function Drill.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.If&#x27;&gt;: &lt;function Drill.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.ILike&#x27;&gt;: &lt;function Drill.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.Levenshtein&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.PartitionedByProperty&#x27;&gt;: &lt;function Drill.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.RegexpLike&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.StrPosition&#x27;&gt;: &lt;function str_position_sql&gt;, &lt;class &#x27;sqlglot.expressions.StrToDate&#x27;&gt;: &lt;function _str_to_date&gt;, &lt;class &#x27;sqlglot.expressions.Pow&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.Select&#x27;&gt;: &lt;function preprocess.&lt;locals&gt;._to_sql&gt;, &lt;class &#x27;sqlglot.expressions.StrToTime&#x27;&gt;: &lt;function Drill.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.TimeStrToDate&#x27;&gt;: &lt;function Drill.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.TimeStrToTime&#x27;&gt;: &lt;function timestrtotime_sql&gt;, &lt;class &#x27;sqlglot.expressions.TimeStrToUnix&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.TimeToStr&#x27;&gt;: &lt;function Drill.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.TimeToUnix&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.ToChar&#x27;&gt;: &lt;function Drill.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.TryCast&#x27;&gt;: &lt;function no_trycast_sql&gt;, &lt;class &#x27;sqlglot.expressions.TsOrDsToDate&#x27;&gt;: &lt;function ts_or_ds_to_date_sql.&lt;locals&gt;._ts_or_ds_to_date_sql&gt;, &lt;class &#x27;sqlglot.expressions.TsOrDiToDi&#x27;&gt;: &lt;function Drill.Generator.&lt;lambda&gt;&gt;}"}, "sqlglot.dialects.drill.Drill.Generator.normalize_func": {"fullname": "sqlglot.dialects.drill.Drill.Generator.normalize_func", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.Generator.normalize_func", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.drill.Drill.Generator.SELECT_KINDS": {"fullname": "sqlglot.dialects.drill.Drill.Generator.SELECT_KINDS", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.Generator.SELECT_KINDS", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Tuple[str, ...]", "default_value": "()"}, "sqlglot.dialects.drill.Drill.Generator.INVERSE_TIME_MAPPING": {"fullname": "sqlglot.dialects.drill.Drill.Generator.INVERSE_TIME_MAPPING", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.Generator.INVERSE_TIME_MAPPING", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict[str, str]", "default_value": "{&#x27;%Y&#x27;: &#x27;yyyy&#x27;, &#x27;%y&#x27;: &#x27;yy&#x27;, &#x27;%B&#x27;: &#x27;MMMM&#x27;, &#x27;%b&#x27;: &#x27;MMM&#x27;, &#x27;%m&#x27;: &#x27;MM&#x27;, &#x27;%-m&#x27;: &#x27;M&#x27;, &#x27;%d&#x27;: &#x27;dd&#x27;, &#x27;%-d&#x27;: &#x27;d&#x27;, &#x27;%H&#x27;: &#x27;HH&#x27;, &#x27;%-H&#x27;: &#x27;H&#x27;, &#x27;%I&#x27;: &#x27;hh&#x27;, &#x27;%-I&#x27;: &#x27;h&#x27;, &#x27;%M&#x27;: &#x27;mm&#x27;, &#x27;%-M&#x27;: &#x27;m&#x27;, &#x27;%S&#x27;: &#x27;ss&#x27;, &#x27;%-S&#x27;: &#x27;s&#x27;, &#x27;%f&#x27;: &#x27;SSSSSS&#x27;, &#x27;%p&#x27;: &#x27;a&#x27;, &#x27;%j&#x27;: &#x27;DD&#x27;, &#x27;%-j&#x27;: &#x27;D&#x27;, &#x27;%a&#x27;: &#x27;EEE&#x27;, &#x27;%A&#x27;: &#x27;EEEE&#x27;, &#x27;T&#x27;: &quot;&#x27;&#x27;T&#x27;&#x27;&quot;}"}, "sqlglot.dialects.drill.Drill.Generator.INVERSE_TIME_TRIE": {"fullname": "sqlglot.dialects.drill.Drill.Generator.INVERSE_TIME_TRIE", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.Generator.INVERSE_TIME_TRIE", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict", "default_value": "{&#x27;%&#x27;: {&#x27;Y&#x27;: {0: True}, &#x27;y&#x27;: {0: True}, &#x27;B&#x27;: {0: True}, &#x27;b&#x27;: {0: True}, &#x27;m&#x27;: {0: True}, &#x27;-&#x27;: {&#x27;m&#x27;: {0: True}, &#x27;d&#x27;: {0: True}, &#x27;H&#x27;: {0: True}, &#x27;I&#x27;: {0: True}, &#x27;M&#x27;: {0: True}, &#x27;S&#x27;: {0: True}, &#x27;j&#x27;: {0: True}}, &#x27;d&#x27;: {0: True}, &#x27;H&#x27;: {0: True}, &#x27;I&#x27;: {0: True}, &#x27;M&#x27;: {0: True}, &#x27;S&#x27;: {0: True}, &#x27;f&#x27;: {0: True}, &#x27;p&#x27;: {0: True}, &#x27;j&#x27;: {0: True}, &#x27;a&#x27;: {0: True}, &#x27;A&#x27;: {0: True}}, &#x27;T&#x27;: {0: True}}"}, "sqlglot.dialects.drill.Drill.Generator.INVERSE_ESCAPE_SEQUENCES": {"fullname": "sqlglot.dialects.drill.Drill.Generator.INVERSE_ESCAPE_SEQUENCES", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.Generator.INVERSE_ESCAPE_SEQUENCES", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict[str, str]", "default_value": "{}"}, "sqlglot.dialects.drill.Drill.Generator.NORMALIZE_FUNCTIONS": {"fullname": "sqlglot.dialects.drill.Drill.Generator.NORMALIZE_FUNCTIONS", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.Generator.NORMALIZE_FUNCTIONS", "kind": "variable", "doc": "<p></p>\n", "annotation": ": bool | str", "default_value": "False"}, "sqlglot.dialects.drill.Drill.Generator.NULL_ORDERING": {"fullname": "sqlglot.dialects.drill.Drill.Generator.NULL_ORDERING", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.Generator.NULL_ORDERING", "kind": "variable", "doc": "<p></p>\n", "default_value": "&#x27;nulls_are_last&#x27;"}, "sqlglot.dialects.drill.Drill.Generator.can_identify": {"fullname": "sqlglot.dialects.drill.Drill.Generator.can_identify", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.Generator.can_identify", "kind": "function", "doc": "<p>Checks if text can be identified given an identify option.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>text:</strong>  The text to check.</li>\n<li><strong>identify:</strong>  \"always\" or <code>True</code>: Always returns true.\n\"safe\": True if the identifier is case-insensitive.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>Whether or not the given text can be identified.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">text</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">identify</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;safe&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.drill.Drill.Generator.QUOTE_START": {"fullname": "sqlglot.dialects.drill.Drill.Generator.QUOTE_START", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.Generator.QUOTE_START", "kind": "variable", "doc": "<p></p>\n", "default_value": "&quot;&#x27;&quot;"}, "sqlglot.dialects.drill.Drill.Generator.QUOTE_END": {"fullname": "sqlglot.dialects.drill.Drill.Generator.QUOTE_END", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.Generator.QUOTE_END", "kind": "variable", "doc": "<p></p>\n", "default_value": "&quot;&#x27;&quot;"}, "sqlglot.dialects.drill.Drill.Generator.IDENTIFIER_START": {"fullname": "sqlglot.dialects.drill.Drill.Generator.IDENTIFIER_START", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.Generator.IDENTIFIER_START", "kind": "variable", "doc": "<p></p>\n", "default_value": "&#x27;`&#x27;"}, "sqlglot.dialects.drill.Drill.Generator.IDENTIFIER_END": {"fullname": "sqlglot.dialects.drill.Drill.Generator.IDENTIFIER_END", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.Generator.IDENTIFIER_END", "kind": "variable", "doc": "<p></p>\n", "default_value": "&#x27;`&#x27;"}, "sqlglot.dialects.drill.Drill.Generator.TOKENIZER_CLASS": {"fullname": "sqlglot.dialects.drill.Drill.Generator.TOKENIZER_CLASS", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.Generator.TOKENIZER_CLASS", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;class &#x27;sqlglot.dialects.drill.Drill.Tokenizer&#x27;&gt;"}, "sqlglot.dialects.drill.Drill.Generator.BIT_START": {"fullname": "sqlglot.dialects.drill.Drill.Generator.BIT_START", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.Generator.BIT_START", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Optional[str]", "default_value": "None"}, "sqlglot.dialects.drill.Drill.Generator.BIT_END": {"fullname": "sqlglot.dialects.drill.Drill.Generator.BIT_END", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.Generator.BIT_END", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Optional[str]", "default_value": "None"}, "sqlglot.dialects.drill.Drill.Generator.HEX_START": {"fullname": "sqlglot.dialects.drill.Drill.Generator.HEX_START", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.Generator.HEX_START", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Optional[str]", "default_value": "None"}, "sqlglot.dialects.drill.Drill.Generator.HEX_END": {"fullname": "sqlglot.dialects.drill.Drill.Generator.HEX_END", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.Generator.HEX_END", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Optional[str]", "default_value": "None"}, "sqlglot.dialects.drill.Drill.Generator.BYTE_START": {"fullname": "sqlglot.dialects.drill.Drill.Generator.BYTE_START", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.Generator.BYTE_START", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Optional[str]", "default_value": "None"}, "sqlglot.dialects.drill.Drill.Generator.BYTE_END": {"fullname": "sqlglot.dialects.drill.Drill.Generator.BYTE_END", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.Generator.BYTE_END", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Optional[str]", "default_value": "None"}, "sqlglot.dialects.drill.Drill.tokenizer_class": {"fullname": "sqlglot.dialects.drill.Drill.tokenizer_class", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.tokenizer_class", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;class &#x27;sqlglot.dialects.drill.Drill.Tokenizer&#x27;&gt;"}, "sqlglot.dialects.drill.Drill.parser_class": {"fullname": "sqlglot.dialects.drill.Drill.parser_class", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.parser_class", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;class &#x27;sqlglot.dialects.drill.Drill.Parser&#x27;&gt;"}, "sqlglot.dialects.drill.Drill.generator_class": {"fullname": "sqlglot.dialects.drill.Drill.generator_class", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.generator_class", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;class &#x27;sqlglot.dialects.drill.Drill.Generator&#x27;&gt;"}, "sqlglot.dialects.drill.Drill.TIME_TRIE": {"fullname": "sqlglot.dialects.drill.Drill.TIME_TRIE", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.TIME_TRIE", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict", "default_value": "{&#x27;y&#x27;: {0: True, &#x27;y&#x27;: {&#x27;y&#x27;: {&#x27;y&#x27;: {0: True}}, 0: True}}, &#x27;Y&#x27;: {0: True, &#x27;Y&#x27;: {&#x27;Y&#x27;: {&#x27;Y&#x27;: {0: True}}, 0: True}}, &#x27;M&#x27;: {&#x27;M&#x27;: {&#x27;M&#x27;: {&#x27;M&#x27;: {0: True}, 0: True}, 0: True}, 0: True}, &#x27;d&#x27;: {&#x27;d&#x27;: {0: True}, 0: True}, &#x27;H&#x27;: {&#x27;H&#x27;: {0: True}, 0: True}, &#x27;h&#x27;: {&#x27;h&#x27;: {0: True}, 0: True}, &#x27;m&#x27;: {&#x27;m&#x27;: {0: True}, 0: True}, &#x27;s&#x27;: {&#x27;s&#x27;: {0: True}, 0: True}, &#x27;S&#x27;: {&#x27;S&#x27;: {&#x27;S&#x27;: {&#x27;S&#x27;: {&#x27;S&#x27;: {&#x27;S&#x27;: {0: True}}}}}}, &#x27;a&#x27;: {0: True}, &#x27;D&#x27;: {&#x27;D&#x27;: {0: True}, 0: True}, &#x27;E&#x27;: {0: True, &#x27;E&#x27;: {0: True, &#x27;E&#x27;: {0: True, &#x27;E&#x27;: {0: True}}}}, &quot;&#x27;&quot;: {&quot;&#x27;&quot;: {&#x27;T&#x27;: {&quot;&#x27;&quot;: {&quot;&#x27;&quot;: {0: True}}}}}}"}, "sqlglot.dialects.drill.Drill.FORMAT_TRIE": {"fullname": "sqlglot.dialects.drill.Drill.FORMAT_TRIE", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.FORMAT_TRIE", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict", "default_value": "{&#x27;y&#x27;: {0: True, &#x27;y&#x27;: {&#x27;y&#x27;: {&#x27;y&#x27;: {0: True}}, 0: True}}, &#x27;Y&#x27;: {0: True, &#x27;Y&#x27;: {&#x27;Y&#x27;: {&#x27;Y&#x27;: {0: True}}, 0: True}}, &#x27;M&#x27;: {&#x27;M&#x27;: {&#x27;M&#x27;: {&#x27;M&#x27;: {0: True}, 0: True}, 0: True}, 0: True}, &#x27;d&#x27;: {&#x27;d&#x27;: {0: True}, 0: True}, &#x27;H&#x27;: {&#x27;H&#x27;: {0: True}, 0: True}, &#x27;h&#x27;: {&#x27;h&#x27;: {0: True}, 0: True}, &#x27;m&#x27;: {&#x27;m&#x27;: {0: True}, 0: True}, &#x27;s&#x27;: {&#x27;s&#x27;: {0: True}, 0: True}, &#x27;S&#x27;: {&#x27;S&#x27;: {&#x27;S&#x27;: {&#x27;S&#x27;: {&#x27;S&#x27;: {&#x27;S&#x27;: {0: True}}}}}}, &#x27;a&#x27;: {0: True}, &#x27;D&#x27;: {&#x27;D&#x27;: {0: True}, 0: True}, &#x27;E&#x27;: {0: True, &#x27;E&#x27;: {0: True, &#x27;E&#x27;: {0: True, &#x27;E&#x27;: {0: True}}}}, &quot;&#x27;&quot;: {&quot;&#x27;&quot;: {&#x27;T&#x27;: {&quot;&#x27;&quot;: {&quot;&#x27;&quot;: {0: True}}}}}}"}, "sqlglot.dialects.drill.Drill.INVERSE_TIME_MAPPING": {"fullname": "sqlglot.dialects.drill.Drill.INVERSE_TIME_MAPPING", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.INVERSE_TIME_MAPPING", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict[str, str]", "default_value": "{&#x27;%Y&#x27;: &#x27;yyyy&#x27;, &#x27;%y&#x27;: &#x27;yy&#x27;, &#x27;%B&#x27;: &#x27;MMMM&#x27;, &#x27;%b&#x27;: &#x27;MMM&#x27;, &#x27;%m&#x27;: &#x27;MM&#x27;, &#x27;%-m&#x27;: &#x27;M&#x27;, &#x27;%d&#x27;: &#x27;dd&#x27;, &#x27;%-d&#x27;: &#x27;d&#x27;, &#x27;%H&#x27;: &#x27;HH&#x27;, &#x27;%-H&#x27;: &#x27;H&#x27;, &#x27;%I&#x27;: &#x27;hh&#x27;, &#x27;%-I&#x27;: &#x27;h&#x27;, &#x27;%M&#x27;: &#x27;mm&#x27;, &#x27;%-M&#x27;: &#x27;m&#x27;, &#x27;%S&#x27;: &#x27;ss&#x27;, &#x27;%-S&#x27;: &#x27;s&#x27;, &#x27;%f&#x27;: &#x27;SSSSSS&#x27;, &#x27;%p&#x27;: &#x27;a&#x27;, &#x27;%j&#x27;: &#x27;DD&#x27;, &#x27;%-j&#x27;: &#x27;D&#x27;, &#x27;%a&#x27;: &#x27;EEE&#x27;, &#x27;%A&#x27;: &#x27;EEEE&#x27;, &#x27;T&#x27;: &quot;&#x27;&#x27;T&#x27;&#x27;&quot;}"}, "sqlglot.dialects.drill.Drill.INVERSE_TIME_TRIE": {"fullname": "sqlglot.dialects.drill.Drill.INVERSE_TIME_TRIE", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.INVERSE_TIME_TRIE", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict", "default_value": "{&#x27;%&#x27;: {&#x27;Y&#x27;: {0: True}, &#x27;y&#x27;: {0: True}, &#x27;B&#x27;: {0: True}, &#x27;b&#x27;: {0: True}, &#x27;m&#x27;: {0: True}, &#x27;-&#x27;: {&#x27;m&#x27;: {0: True}, &#x27;d&#x27;: {0: True}, &#x27;H&#x27;: {0: True}, &#x27;I&#x27;: {0: True}, &#x27;M&#x27;: {0: True}, &#x27;S&#x27;: {0: True}, &#x27;j&#x27;: {0: True}}, &#x27;d&#x27;: {0: True}, &#x27;H&#x27;: {0: True}, &#x27;I&#x27;: {0: True}, &#x27;M&#x27;: {0: True}, &#x27;S&#x27;: {0: True}, &#x27;f&#x27;: {0: True}, &#x27;p&#x27;: {0: True}, &#x27;j&#x27;: {0: True}, &#x27;a&#x27;: {0: True}, &#x27;A&#x27;: {0: True}}, &#x27;T&#x27;: {0: True}}"}, "sqlglot.dialects.drill.Drill.INVERSE_ESCAPE_SEQUENCES": {"fullname": "sqlglot.dialects.drill.Drill.INVERSE_ESCAPE_SEQUENCES", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.INVERSE_ESCAPE_SEQUENCES", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict[str, str]", "default_value": "{}"}, "sqlglot.dialects.drill.Drill.QUOTE_START": {"fullname": "sqlglot.dialects.drill.Drill.QUOTE_START", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.QUOTE_START", "kind": "variable", "doc": "<p></p>\n", "default_value": "&quot;&#x27;&quot;"}, "sqlglot.dialects.drill.Drill.QUOTE_END": {"fullname": "sqlglot.dialects.drill.Drill.QUOTE_END", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.QUOTE_END", "kind": "variable", "doc": "<p></p>\n", "default_value": "&quot;&#x27;&quot;"}, "sqlglot.dialects.drill.Drill.IDENTIFIER_START": {"fullname": "sqlglot.dialects.drill.Drill.IDENTIFIER_START", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.IDENTIFIER_START", "kind": "variable", "doc": "<p></p>\n", "default_value": "&#x27;`&#x27;"}, "sqlglot.dialects.drill.Drill.IDENTIFIER_END": {"fullname": "sqlglot.dialects.drill.Drill.IDENTIFIER_END", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.IDENTIFIER_END", "kind": "variable", "doc": "<p></p>\n", "default_value": "&#x27;`&#x27;"}, "sqlglot.dialects.drill.Drill.BIT_START": {"fullname": "sqlglot.dialects.drill.Drill.BIT_START", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.BIT_START", "kind": "variable", "doc": "<p></p>\n", "default_value": "None"}, "sqlglot.dialects.drill.Drill.BIT_END": {"fullname": "sqlglot.dialects.drill.Drill.BIT_END", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.BIT_END", "kind": "variable", "doc": "<p></p>\n", "default_value": "None"}, "sqlglot.dialects.drill.Drill.HEX_START": {"fullname": "sqlglot.dialects.drill.Drill.HEX_START", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.HEX_START", "kind": "variable", "doc": "<p></p>\n", "default_value": "None"}, "sqlglot.dialects.drill.Drill.HEX_END": {"fullname": "sqlglot.dialects.drill.Drill.HEX_END", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.HEX_END", "kind": "variable", "doc": "<p></p>\n", "default_value": "None"}, "sqlglot.dialects.drill.Drill.BYTE_START": {"fullname": "sqlglot.dialects.drill.Drill.BYTE_START", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.BYTE_START", "kind": "variable", "doc": "<p></p>\n", "default_value": "None"}, "sqlglot.dialects.drill.Drill.BYTE_END": {"fullname": "sqlglot.dialects.drill.Drill.BYTE_END", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.BYTE_END", "kind": "variable", "doc": "<p></p>\n", "default_value": "None"}, "sqlglot.dialects.duckdb": {"fullname": "sqlglot.dialects.duckdb", "modulename": "sqlglot.dialects.duckdb", "kind": "module", "doc": "<p></p>\n"}, "sqlglot.dialects.duckdb.DuckDB": {"fullname": "sqlglot.dialects.duckdb.DuckDB", "modulename": "sqlglot.dialects.duckdb", "qualname": "DuckDB", "kind": "class", "doc": "<p></p>\n", "bases": "sqlglot.dialects.dialect.Dialect"}, "sqlglot.dialects.duckdb.DuckDB.NULL_ORDERING": {"fullname": "sqlglot.dialects.duckdb.DuckDB.NULL_ORDERING", "modulename": "sqlglot.dialects.duckdb", "qualname": "DuckDB.NULL_ORDERING", "kind": "variable", "doc": "<p></p>\n", "default_value": "&#x27;nulls_are_last&#x27;"}, "sqlglot.dialects.duckdb.DuckDB.SUPPORTS_USER_DEFINED_TYPES": {"fullname": "sqlglot.dialects.duckdb.DuckDB.SUPPORTS_USER_DEFINED_TYPES", "modulename": "sqlglot.dialects.duckdb", "qualname": "DuckDB.SUPPORTS_USER_DEFINED_TYPES", "kind": "variable", "doc": "<p></p>\n", "default_value": "False"}, "sqlglot.dialects.duckdb.DuckDB.RESOLVES_IDENTIFIERS_AS_UPPERCASE": {"fullname": "sqlglot.dialects.duckdb.DuckDB.RESOLVES_IDENTIFIERS_AS_UPPERCASE", "modulename": "sqlglot.dialects.duckdb", "qualname": "DuckDB.RESOLVES_IDENTIFIERS_AS_UPPERCASE", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Optional[bool]", "default_value": "None"}, "sqlglot.dialects.duckdb.DuckDB.Tokenizer": {"fullname": "sqlglot.dialects.duckdb.DuckDB.Tokenizer", "modulename": "sqlglot.dialects.duckdb", "qualname": "DuckDB.Tokenizer", "kind": "class", "doc": "<p></p>\n", "bases": "sqlglot.tokens.Tokenizer"}, "sqlglot.dialects.duckdb.DuckDB.Tokenizer.KEYWORDS": {"fullname": "sqlglot.dialects.duckdb.DuckDB.Tokenizer.KEYWORDS", "modulename": "sqlglot.dialects.duckdb", "qualname": "DuckDB.Tokenizer.KEYWORDS", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;{%&#x27;: &lt;TokenType.BLOCK_START: &#x27;BLOCK_START&#x27;&gt;, &#x27;{%+&#x27;: &lt;TokenType.BLOCK_START: &#x27;BLOCK_START&#x27;&gt;, &#x27;{%-&#x27;: &lt;TokenType.BLOCK_START: &#x27;BLOCK_START&#x27;&gt;, &#x27;%}&#x27;: &lt;TokenType.BLOCK_END: &#x27;BLOCK_END&#x27;&gt;, &#x27;+%}&#x27;: &lt;TokenType.BLOCK_END: &#x27;BLOCK_END&#x27;&gt;, &#x27;-%}&#x27;: &lt;TokenType.BLOCK_END: &#x27;BLOCK_END&#x27;&gt;, &#x27;{{+&#x27;: &lt;TokenType.BLOCK_START: &#x27;BLOCK_START&#x27;&gt;, &#x27;{{-&#x27;: &lt;TokenType.BLOCK_START: &#x27;BLOCK_START&#x27;&gt;, &#x27;+}}&#x27;: &lt;TokenType.BLOCK_END: &#x27;BLOCK_END&#x27;&gt;, &#x27;-}}&#x27;: &lt;TokenType.BLOCK_END: &#x27;BLOCK_END&#x27;&gt;, &#x27;/*+&#x27;: &lt;TokenType.HINT: &#x27;HINT&#x27;&gt;, &#x27;==&#x27;: &lt;TokenType.EQ: &#x27;EQ&#x27;&gt;, &#x27;::&#x27;: &lt;TokenType.DCOLON: &#x27;DCOLON&#x27;&gt;, &#x27;||&#x27;: &lt;TokenType.DPIPE: &#x27;DPIPE&#x27;&gt;, &#x27;&gt;=&#x27;: &lt;TokenType.GTE: &#x27;GTE&#x27;&gt;, &#x27;&lt;=&#x27;: &lt;TokenType.LTE: &#x27;LTE&#x27;&gt;, &#x27;&lt;&gt;&#x27;: &lt;TokenType.NEQ: &#x27;NEQ&#x27;&gt;, &#x27;!=&#x27;: &lt;TokenType.NEQ: &#x27;NEQ&#x27;&gt;, &#x27;&lt;=&gt;&#x27;: &lt;TokenType.NULLSAFE_EQ: &#x27;NULLSAFE_EQ&#x27;&gt;, &#x27;-&gt;&#x27;: &lt;TokenType.ARROW: &#x27;ARROW&#x27;&gt;, &#x27;-&gt;&gt;&#x27;: &lt;TokenType.DARROW: &#x27;DARROW&#x27;&gt;, &#x27;=&gt;&#x27;: &lt;TokenType.FARROW: &#x27;FARROW&#x27;&gt;, &#x27;#&gt;&#x27;: &lt;TokenType.HASH_ARROW: &#x27;HASH_ARROW&#x27;&gt;, &#x27;#&gt;&gt;&#x27;: &lt;TokenType.DHASH_ARROW: &#x27;DHASH_ARROW&#x27;&gt;, &#x27;&lt;-&gt;&#x27;: &lt;TokenType.LR_ARROW: &#x27;LR_ARROW&#x27;&gt;, &#x27;&amp;&amp;&#x27;: &lt;TokenType.DAMP: &#x27;DAMP&#x27;&gt;, &#x27;??&#x27;: &lt;TokenType.DQMARK: &#x27;DQMARK&#x27;&gt;, &#x27;ALL&#x27;: &lt;TokenType.ALL: &#x27;ALL&#x27;&gt;, &#x27;ALWAYS&#x27;: &lt;TokenType.ALWAYS: &#x27;ALWAYS&#x27;&gt;, &#x27;AND&#x27;: &lt;TokenType.AND: &#x27;AND&#x27;&gt;, &#x27;ANTI&#x27;: &lt;TokenType.ANTI: &#x27;ANTI&#x27;&gt;, &#x27;ANY&#x27;: &lt;TokenType.ANY: &#x27;ANY&#x27;&gt;, &#x27;ASC&#x27;: &lt;TokenType.ASC: &#x27;ASC&#x27;&gt;, &#x27;AS&#x27;: &lt;TokenType.ALIAS: &#x27;ALIAS&#x27;&gt;, &#x27;ASOF&#x27;: &lt;TokenType.ASOF: &#x27;ASOF&#x27;&gt;, &#x27;AUTOINCREMENT&#x27;: &lt;TokenType.AUTO_INCREMENT: &#x27;AUTO_INCREMENT&#x27;&gt;, &#x27;AUTO_INCREMENT&#x27;: &lt;TokenType.AUTO_INCREMENT: &#x27;AUTO_INCREMENT&#x27;&gt;, &#x27;BEGIN&#x27;: &lt;TokenType.BEGIN: &#x27;BEGIN&#x27;&gt;, &#x27;BETWEEN&#x27;: &lt;TokenType.BETWEEN: &#x27;BETWEEN&#x27;&gt;, &#x27;CACHE&#x27;: &lt;TokenType.CACHE: &#x27;CACHE&#x27;&gt;, &#x27;UNCACHE&#x27;: &lt;TokenType.UNCACHE: &#x27;UNCACHE&#x27;&gt;, &#x27;CASE&#x27;: &lt;TokenType.CASE: &#x27;CASE&#x27;&gt;, &#x27;CHARACTER SET&#x27;: &lt;TokenType.CHARACTER_SET: &#x27;CHARACTER_SET&#x27;&gt;, &#x27;CLUSTER BY&#x27;: &lt;TokenType.CLUSTER_BY: &#x27;CLUSTER_BY&#x27;&gt;, &#x27;COLLATE&#x27;: &lt;TokenType.COLLATE: &#x27;COLLATE&#x27;&gt;, &#x27;COLUMN&#x27;: &lt;TokenType.COLUMN: &#x27;COLUMN&#x27;&gt;, &#x27;COMMIT&#x27;: &lt;TokenType.COMMIT: &#x27;COMMIT&#x27;&gt;, &#x27;CONNECT BY&#x27;: &lt;TokenType.CONNECT_BY: &#x27;CONNECT_BY&#x27;&gt;, &#x27;CONSTRAINT&#x27;: &lt;TokenType.CONSTRAINT: &#x27;CONSTRAINT&#x27;&gt;, &#x27;CREATE&#x27;: &lt;TokenType.CREATE: &#x27;CREATE&#x27;&gt;, &#x27;CROSS&#x27;: &lt;TokenType.CROSS: &#x27;CROSS&#x27;&gt;, &#x27;CUBE&#x27;: &lt;TokenType.CUBE: &#x27;CUBE&#x27;&gt;, &#x27;CURRENT_DATE&#x27;: &lt;TokenType.CURRENT_DATE: &#x27;CURRENT_DATE&#x27;&gt;, &#x27;CURRENT_TIME&#x27;: &lt;TokenType.CURRENT_TIME: &#x27;CURRENT_TIME&#x27;&gt;, &#x27;CURRENT_TIMESTAMP&#x27;: &lt;TokenType.CURRENT_TIMESTAMP: &#x27;CURRENT_TIMESTAMP&#x27;&gt;, &#x27;CURRENT_USER&#x27;: &lt;TokenType.CURRENT_USER: &#x27;CURRENT_USER&#x27;&gt;, &#x27;DATABASE&#x27;: &lt;TokenType.DATABASE: &#x27;DATABASE&#x27;&gt;, &#x27;DEFAULT&#x27;: &lt;TokenType.DEFAULT: &#x27;DEFAULT&#x27;&gt;, &#x27;DELETE&#x27;: &lt;TokenType.DELETE: &#x27;DELETE&#x27;&gt;, &#x27;DESC&#x27;: &lt;TokenType.DESC: &#x27;DESC&#x27;&gt;, &#x27;DESCRIBE&#x27;: &lt;TokenType.DESCRIBE: &#x27;DESCRIBE&#x27;&gt;, &#x27;DISTINCT&#x27;: &lt;TokenType.DISTINCT: &#x27;DISTINCT&#x27;&gt;, &#x27;DISTRIBUTE BY&#x27;: &lt;TokenType.DISTRIBUTE_BY: &#x27;DISTRIBUTE_BY&#x27;&gt;, &#x27;DIV&#x27;: &lt;TokenType.DIV: &#x27;DIV&#x27;&gt;, &#x27;DROP&#x27;: &lt;TokenType.DROP: &#x27;DROP&#x27;&gt;, &#x27;ELSE&#x27;: &lt;TokenType.ELSE: &#x27;ELSE&#x27;&gt;, &#x27;END&#x27;: &lt;TokenType.END: &#x27;END&#x27;&gt;, &#x27;ESCAPE&#x27;: &lt;TokenType.ESCAPE: &#x27;ESCAPE&#x27;&gt;, &#x27;EXCEPT&#x27;: &lt;TokenType.EXCEPT: &#x27;EXCEPT&#x27;&gt;, &#x27;EXECUTE&#x27;: &lt;TokenType.EXECUTE: &#x27;EXECUTE&#x27;&gt;, &#x27;EXISTS&#x27;: &lt;TokenType.EXISTS: &#x27;EXISTS&#x27;&gt;, &#x27;FALSE&#x27;: &lt;TokenType.FALSE: &#x27;FALSE&#x27;&gt;, &#x27;FETCH&#x27;: &lt;TokenType.FETCH: &#x27;FETCH&#x27;&gt;, &#x27;FILTER&#x27;: &lt;TokenType.FILTER: &#x27;FILTER&#x27;&gt;, &#x27;FIRST&#x27;: &lt;TokenType.FIRST: &#x27;FIRST&#x27;&gt;, &#x27;FULL&#x27;: &lt;TokenType.FULL: &#x27;FULL&#x27;&gt;, &#x27;FUNCTION&#x27;: &lt;TokenType.FUNCTION: &#x27;FUNCTION&#x27;&gt;, &#x27;FOR&#x27;: &lt;TokenType.FOR: &#x27;FOR&#x27;&gt;, &#x27;FOREIGN KEY&#x27;: &lt;TokenType.FOREIGN_KEY: &#x27;FOREIGN_KEY&#x27;&gt;, &#x27;FORMAT&#x27;: &lt;TokenType.FORMAT: &#x27;FORMAT&#x27;&gt;, &#x27;FROM&#x27;: &lt;TokenType.FROM: &#x27;FROM&#x27;&gt;, &#x27;GEOGRAPHY&#x27;: &lt;TokenType.GEOGRAPHY: &#x27;GEOGRAPHY&#x27;&gt;, &#x27;GEOMETRY&#x27;: &lt;TokenType.GEOMETRY: &#x27;GEOMETRY&#x27;&gt;, &#x27;GLOB&#x27;: &lt;TokenType.GLOB: &#x27;GLOB&#x27;&gt;, &#x27;GROUP BY&#x27;: &lt;TokenType.GROUP_BY: &#x27;GROUP_BY&#x27;&gt;, &#x27;GROUPING SETS&#x27;: &lt;TokenType.GROUPING_SETS: &#x27;GROUPING_SETS&#x27;&gt;, &#x27;HAVING&#x27;: &lt;TokenType.HAVING: &#x27;HAVING&#x27;&gt;, &#x27;ILIKE&#x27;: &lt;TokenType.ILIKE: &#x27;ILIKE&#x27;&gt;, &#x27;IN&#x27;: &lt;TokenType.IN: &#x27;IN&#x27;&gt;, &#x27;INDEX&#x27;: &lt;TokenType.INDEX: &#x27;INDEX&#x27;&gt;, &#x27;INET&#x27;: &lt;TokenType.INET: &#x27;INET&#x27;&gt;, &#x27;INNER&#x27;: &lt;TokenType.INNER: &#x27;INNER&#x27;&gt;, &#x27;INSERT&#x27;: &lt;TokenType.INSERT: &#x27;INSERT&#x27;&gt;, &#x27;INTERVAL&#x27;: &lt;TokenType.INTERVAL: &#x27;INTERVAL&#x27;&gt;, &#x27;INTERSECT&#x27;: &lt;TokenType.INTERSECT: &#x27;INTERSECT&#x27;&gt;, &#x27;INTO&#x27;: &lt;TokenType.INTO: &#x27;INTO&#x27;&gt;, &#x27;IS&#x27;: &lt;TokenType.IS: &#x27;IS&#x27;&gt;, &#x27;ISNULL&#x27;: &lt;TokenType.ISNULL: &#x27;ISNULL&#x27;&gt;, &#x27;JOIN&#x27;: &lt;TokenType.JOIN: &#x27;JOIN&#x27;&gt;, &#x27;KEEP&#x27;: &lt;TokenType.KEEP: &#x27;KEEP&#x27;&gt;, &#x27;KILL&#x27;: &lt;TokenType.KILL: &#x27;KILL&#x27;&gt;, &#x27;LATERAL&#x27;: &lt;TokenType.LATERAL: &#x27;LATERAL&#x27;&gt;, &#x27;LEFT&#x27;: &lt;TokenType.LEFT: &#x27;LEFT&#x27;&gt;, &#x27;LIKE&#x27;: &lt;TokenType.LIKE: &#x27;LIKE&#x27;&gt;, &#x27;LIMIT&#x27;: &lt;TokenType.LIMIT: &#x27;LIMIT&#x27;&gt;, &#x27;LOAD&#x27;: &lt;TokenType.LOAD: &#x27;LOAD&#x27;&gt;, &#x27;LOCK&#x27;: &lt;TokenType.LOCK: &#x27;LOCK&#x27;&gt;, &#x27;MERGE&#x27;: &lt;TokenType.MERGE: &#x27;MERGE&#x27;&gt;, &#x27;NATURAL&#x27;: &lt;TokenType.NATURAL: &#x27;NATURAL&#x27;&gt;, &#x27;NEXT&#x27;: &lt;TokenType.NEXT: &#x27;NEXT&#x27;&gt;, &#x27;NOT&#x27;: &lt;TokenType.NOT: &#x27;NOT&#x27;&gt;, &#x27;NOTNULL&#x27;: &lt;TokenType.NOTNULL: &#x27;NOTNULL&#x27;&gt;, &#x27;NULL&#x27;: &lt;TokenType.NULL: &#x27;NULL&#x27;&gt;, &#x27;OBJECT&#x27;: &lt;TokenType.OBJECT: &#x27;OBJECT&#x27;&gt;, &#x27;OFFSET&#x27;: &lt;TokenType.OFFSET: &#x27;OFFSET&#x27;&gt;, &#x27;ON&#x27;: &lt;TokenType.ON: &#x27;ON&#x27;&gt;, &#x27;OR&#x27;: &lt;TokenType.OR: &#x27;OR&#x27;&gt;, &#x27;XOR&#x27;: &lt;TokenType.XOR: &#x27;XOR&#x27;&gt;, &#x27;ORDER BY&#x27;: &lt;TokenType.ORDER_BY: &#x27;ORDER_BY&#x27;&gt;, &#x27;ORDINALITY&#x27;: &lt;TokenType.ORDINALITY: &#x27;ORDINALITY&#x27;&gt;, &#x27;OUTER&#x27;: &lt;TokenType.OUTER: &#x27;OUTER&#x27;&gt;, &#x27;OVER&#x27;: &lt;TokenType.OVER: &#x27;OVER&#x27;&gt;, &#x27;OVERLAPS&#x27;: &lt;TokenType.OVERLAPS: &#x27;OVERLAPS&#x27;&gt;, &#x27;OVERWRITE&#x27;: &lt;TokenType.OVERWRITE: &#x27;OVERWRITE&#x27;&gt;, &#x27;PARTITION&#x27;: &lt;TokenType.PARTITION: &#x27;PARTITION&#x27;&gt;, &#x27;PARTITION BY&#x27;: &lt;TokenType.PARTITION_BY: &#x27;PARTITION_BY&#x27;&gt;, &#x27;PARTITIONED BY&#x27;: &lt;TokenType.PARTITION_BY: &#x27;PARTITION_BY&#x27;&gt;, &#x27;PARTITIONED_BY&#x27;: &lt;TokenType.PARTITION_BY: &#x27;PARTITION_BY&#x27;&gt;, &#x27;PERCENT&#x27;: &lt;TokenType.PERCENT: &#x27;PERCENT&#x27;&gt;, &#x27;PIVOT&#x27;: &lt;TokenType.PIVOT: &#x27;PIVOT&#x27;&gt;, &#x27;PRAGMA&#x27;: &lt;TokenType.PRAGMA: &#x27;PRAGMA&#x27;&gt;, &#x27;PRIMARY KEY&#x27;: &lt;TokenType.PRIMARY_KEY: &#x27;PRIMARY_KEY&#x27;&gt;, &#x27;PROCEDURE&#x27;: &lt;TokenType.PROCEDURE: &#x27;PROCEDURE&#x27;&gt;, &#x27;QUALIFY&#x27;: &lt;TokenType.QUALIFY: &#x27;QUALIFY&#x27;&gt;, &#x27;RANGE&#x27;: &lt;TokenType.RANGE: &#x27;RANGE&#x27;&gt;, &#x27;RECURSIVE&#x27;: &lt;TokenType.RECURSIVE: &#x27;RECURSIVE&#x27;&gt;, &#x27;REGEXP&#x27;: &lt;TokenType.RLIKE: &#x27;RLIKE&#x27;&gt;, &#x27;REPLACE&#x27;: &lt;TokenType.REPLACE: &#x27;REPLACE&#x27;&gt;, &#x27;RETURNING&#x27;: &lt;TokenType.RETURNING: &#x27;RETURNING&#x27;&gt;, &#x27;REFERENCES&#x27;: &lt;TokenType.REFERENCES: &#x27;REFERENCES&#x27;&gt;, &#x27;RIGHT&#x27;: &lt;TokenType.RIGHT: &#x27;RIGHT&#x27;&gt;, &#x27;RLIKE&#x27;: &lt;TokenType.RLIKE: &#x27;RLIKE&#x27;&gt;, &#x27;ROLLBACK&#x27;: &lt;TokenType.ROLLBACK: &#x27;ROLLBACK&#x27;&gt;, &#x27;ROLLUP&#x27;: &lt;TokenType.ROLLUP: &#x27;ROLLUP&#x27;&gt;, &#x27;ROW&#x27;: &lt;TokenType.ROW: &#x27;ROW&#x27;&gt;, &#x27;ROWS&#x27;: &lt;TokenType.ROWS: &#x27;ROWS&#x27;&gt;, &#x27;SCHEMA&#x27;: &lt;TokenType.SCHEMA: &#x27;SCHEMA&#x27;&gt;, &#x27;SELECT&#x27;: &lt;TokenType.SELECT: &#x27;SELECT&#x27;&gt;, &#x27;SEMI&#x27;: &lt;TokenType.SEMI: &#x27;SEMI&#x27;&gt;, &#x27;SET&#x27;: &lt;TokenType.SET: &#x27;SET&#x27;&gt;, &#x27;SETTINGS&#x27;: &lt;TokenType.SETTINGS: &#x27;SETTINGS&#x27;&gt;, &#x27;SHOW&#x27;: &lt;TokenType.SHOW: &#x27;SHOW&#x27;&gt;, &#x27;SIMILAR TO&#x27;: &lt;TokenType.SIMILAR_TO: &#x27;SIMILAR_TO&#x27;&gt;, &#x27;SOME&#x27;: &lt;TokenType.SOME: &#x27;SOME&#x27;&gt;, &#x27;SORT BY&#x27;: &lt;TokenType.SORT_BY: &#x27;SORT_BY&#x27;&gt;, &#x27;START WITH&#x27;: &lt;TokenType.START_WITH: &#x27;START_WITH&#x27;&gt;, &#x27;TABLE&#x27;: &lt;TokenType.TABLE: &#x27;TABLE&#x27;&gt;, &#x27;TABLESAMPLE&#x27;: &lt;TokenType.TABLE_SAMPLE: &#x27;TABLE_SAMPLE&#x27;&gt;, &#x27;TEMP&#x27;: &lt;TokenType.TEMPORARY: &#x27;TEMPORARY&#x27;&gt;, &#x27;TEMPORARY&#x27;: &lt;TokenType.TEMPORARY: &#x27;TEMPORARY&#x27;&gt;, &#x27;THEN&#x27;: &lt;TokenType.THEN: &#x27;THEN&#x27;&gt;, &#x27;TRUE&#x27;: &lt;TokenType.TRUE: &#x27;TRUE&#x27;&gt;, &#x27;UNION&#x27;: &lt;TokenType.UNION: &#x27;UNION&#x27;&gt;, &#x27;UNKNOWN&#x27;: &lt;TokenType.UNKNOWN: &#x27;UNKNOWN&#x27;&gt;, &#x27;UNNEST&#x27;: &lt;TokenType.UNNEST: &#x27;UNNEST&#x27;&gt;, &#x27;UNPIVOT&#x27;: &lt;TokenType.UNPIVOT: &#x27;UNPIVOT&#x27;&gt;, &#x27;UPDATE&#x27;: &lt;TokenType.UPDATE: &#x27;UPDATE&#x27;&gt;, &#x27;USE&#x27;: &lt;TokenType.USE: &#x27;USE&#x27;&gt;, &#x27;USING&#x27;: &lt;TokenType.USING: &#x27;USING&#x27;&gt;, &#x27;UUID&#x27;: &lt;TokenType.UUID: &#x27;UUID&#x27;&gt;, &#x27;VALUES&#x27;: &lt;TokenType.VALUES: &#x27;VALUES&#x27;&gt;, &#x27;VIEW&#x27;: &lt;TokenType.VIEW: &#x27;VIEW&#x27;&gt;, &#x27;VOLATILE&#x27;: &lt;TokenType.VOLATILE: &#x27;VOLATILE&#x27;&gt;, &#x27;WHEN&#x27;: &lt;TokenType.WHEN: &#x27;WHEN&#x27;&gt;, &#x27;WHERE&#x27;: &lt;TokenType.WHERE: &#x27;WHERE&#x27;&gt;, &#x27;WINDOW&#x27;: &lt;TokenType.WINDOW: &#x27;WINDOW&#x27;&gt;, &#x27;WITH&#x27;: &lt;TokenType.WITH: &#x27;WITH&#x27;&gt;, &#x27;APPLY&#x27;: &lt;TokenType.APPLY: &#x27;APPLY&#x27;&gt;, &#x27;ARRAY&#x27;: &lt;TokenType.ARRAY: &#x27;ARRAY&#x27;&gt;, &#x27;BIT&#x27;: &lt;TokenType.BIT: &#x27;BIT&#x27;&gt;, &#x27;BOOL&#x27;: &lt;TokenType.BOOLEAN: &#x27;BOOLEAN&#x27;&gt;, &#x27;BOOLEAN&#x27;: &lt;TokenType.BOOLEAN: &#x27;BOOLEAN&#x27;&gt;, &#x27;BYTE&#x27;: &lt;TokenType.TINYINT: &#x27;TINYINT&#x27;&gt;, &#x27;MEDIUMINT&#x27;: &lt;TokenType.MEDIUMINT: &#x27;MEDIUMINT&#x27;&gt;, &#x27;TINYINT&#x27;: &lt;TokenType.TINYINT: &#x27;TINYINT&#x27;&gt;, &#x27;SHORT&#x27;: &lt;TokenType.SMALLINT: &#x27;SMALLINT&#x27;&gt;, &#x27;SMALLINT&#x27;: &lt;TokenType.SMALLINT: &#x27;SMALLINT&#x27;&gt;, &#x27;INT128&#x27;: &lt;TokenType.INT128: &#x27;INT128&#x27;&gt;, &#x27;INT2&#x27;: &lt;TokenType.SMALLINT: &#x27;SMALLINT&#x27;&gt;, &#x27;INTEGER&#x27;: &lt;TokenType.INT: &#x27;INT&#x27;&gt;, &#x27;INT&#x27;: &lt;TokenType.INT: &#x27;INT&#x27;&gt;, &#x27;INT4&#x27;: &lt;TokenType.INT: &#x27;INT&#x27;&gt;, &#x27;LONG&#x27;: &lt;TokenType.BIGINT: &#x27;BIGINT&#x27;&gt;, &#x27;BIGINT&#x27;: &lt;TokenType.BIGINT: &#x27;BIGINT&#x27;&gt;, &#x27;INT8&#x27;: &lt;TokenType.BIGINT: &#x27;BIGINT&#x27;&gt;, &#x27;DEC&#x27;: &lt;TokenType.DECIMAL: &#x27;DECIMAL&#x27;&gt;, &#x27;DECIMAL&#x27;: &lt;TokenType.DECIMAL: &#x27;DECIMAL&#x27;&gt;, &#x27;BIGDECIMAL&#x27;: &lt;TokenType.BIGDECIMAL: &#x27;BIGDECIMAL&#x27;&gt;, &#x27;BIGNUMERIC&#x27;: &lt;TokenType.BIGDECIMAL: &#x27;BIGDECIMAL&#x27;&gt;, &#x27;MAP&#x27;: &lt;TokenType.MAP: &#x27;MAP&#x27;&gt;, &#x27;NULLABLE&#x27;: &lt;TokenType.NULLABLE: &#x27;NULLABLE&#x27;&gt;, &#x27;NUMBER&#x27;: &lt;TokenType.DECIMAL: &#x27;DECIMAL&#x27;&gt;, &#x27;NUMERIC&#x27;: &lt;TokenType.DECIMAL: &#x27;DECIMAL&#x27;&gt;, &#x27;FIXED&#x27;: &lt;TokenType.DECIMAL: &#x27;DECIMAL&#x27;&gt;, &#x27;REAL&#x27;: &lt;TokenType.FLOAT: &#x27;FLOAT&#x27;&gt;, &#x27;FLOAT&#x27;: &lt;TokenType.FLOAT: &#x27;FLOAT&#x27;&gt;, &#x27;FLOAT4&#x27;: &lt;TokenType.FLOAT: &#x27;FLOAT&#x27;&gt;, &#x27;FLOAT8&#x27;: &lt;TokenType.DOUBLE: &#x27;DOUBLE&#x27;&gt;, &#x27;DOUBLE&#x27;: &lt;TokenType.DOUBLE: &#x27;DOUBLE&#x27;&gt;, &#x27;DOUBLE PRECISION&#x27;: &lt;TokenType.DOUBLE: &#x27;DOUBLE&#x27;&gt;, &#x27;JSON&#x27;: &lt;TokenType.JSON: &#x27;JSON&#x27;&gt;, &#x27;CHAR&#x27;: &lt;TokenType.TEXT: &#x27;TEXT&#x27;&gt;, &#x27;CHARACTER&#x27;: &lt;TokenType.CHAR: &#x27;CHAR&#x27;&gt;, &#x27;NCHAR&#x27;: &lt;TokenType.NCHAR: &#x27;NCHAR&#x27;&gt;, &#x27;VARCHAR&#x27;: &lt;TokenType.VARCHAR: &#x27;VARCHAR&#x27;&gt;, &#x27;VARCHAR2&#x27;: &lt;TokenType.VARCHAR: &#x27;VARCHAR&#x27;&gt;, &#x27;NVARCHAR&#x27;: &lt;TokenType.NVARCHAR: &#x27;NVARCHAR&#x27;&gt;, &#x27;NVARCHAR2&#x27;: &lt;TokenType.NVARCHAR: &#x27;NVARCHAR&#x27;&gt;, &#x27;STR&#x27;: &lt;TokenType.TEXT: &#x27;TEXT&#x27;&gt;, &#x27;STRING&#x27;: &lt;TokenType.VARCHAR: &#x27;VARCHAR&#x27;&gt;, &#x27;TEXT&#x27;: &lt;TokenType.TEXT: &#x27;TEXT&#x27;&gt;, &#x27;LONGTEXT&#x27;: &lt;TokenType.LONGTEXT: &#x27;LONGTEXT&#x27;&gt;, &#x27;MEDIUMTEXT&#x27;: &lt;TokenType.MEDIUMTEXT: &#x27;MEDIUMTEXT&#x27;&gt;, &#x27;TINYTEXT&#x27;: &lt;TokenType.TINYTEXT: &#x27;TINYTEXT&#x27;&gt;, &#x27;CLOB&#x27;: &lt;TokenType.TEXT: &#x27;TEXT&#x27;&gt;, &#x27;LONGVARCHAR&#x27;: &lt;TokenType.TEXT: &#x27;TEXT&#x27;&gt;, &#x27;BINARY&#x27;: &lt;TokenType.VARBINARY: &#x27;VARBINARY&#x27;&gt;, &#x27;BLOB&#x27;: &lt;TokenType.VARBINARY: &#x27;VARBINARY&#x27;&gt;, &#x27;LONGBLOB&#x27;: &lt;TokenType.LONGBLOB: &#x27;LONGBLOB&#x27;&gt;, &#x27;MEDIUMBLOB&#x27;: &lt;TokenType.MEDIUMBLOB: &#x27;MEDIUMBLOB&#x27;&gt;, &#x27;TINYBLOB&#x27;: &lt;TokenType.TINYBLOB: &#x27;TINYBLOB&#x27;&gt;, &#x27;BYTEA&#x27;: &lt;TokenType.VARBINARY: &#x27;VARBINARY&#x27;&gt;, &#x27;VARBINARY&#x27;: &lt;TokenType.VARBINARY: &#x27;VARBINARY&#x27;&gt;, &#x27;TIME&#x27;: &lt;TokenType.TIME: &#x27;TIME&#x27;&gt;, &#x27;TIMETZ&#x27;: &lt;TokenType.TIMETZ: &#x27;TIMETZ&#x27;&gt;, &#x27;TIMESTAMP&#x27;: &lt;TokenType.TIMESTAMP: &#x27;TIMESTAMP&#x27;&gt;, &#x27;TIMESTAMPTZ&#x27;: &lt;TokenType.TIMESTAMPTZ: &#x27;TIMESTAMPTZ&#x27;&gt;, &#x27;TIMESTAMPLTZ&#x27;: &lt;TokenType.TIMESTAMPLTZ: &#x27;TIMESTAMPLTZ&#x27;&gt;, &#x27;DATE&#x27;: &lt;TokenType.DATE: &#x27;DATE&#x27;&gt;, &#x27;DATETIME&#x27;: &lt;TokenType.DATETIME: &#x27;DATETIME&#x27;&gt;, &#x27;INT4RANGE&#x27;: &lt;TokenType.INT4RANGE: &#x27;INT4RANGE&#x27;&gt;, &#x27;INT4MULTIRANGE&#x27;: &lt;TokenType.INT4MULTIRANGE: &#x27;INT4MULTIRANGE&#x27;&gt;, &#x27;INT8RANGE&#x27;: &lt;TokenType.INT8RANGE: &#x27;INT8RANGE&#x27;&gt;, &#x27;INT8MULTIRANGE&#x27;: &lt;TokenType.INT8MULTIRANGE: &#x27;INT8MULTIRANGE&#x27;&gt;, &#x27;NUMRANGE&#x27;: &lt;TokenType.NUMRANGE: &#x27;NUMRANGE&#x27;&gt;, &#x27;NUMMULTIRANGE&#x27;: &lt;TokenType.NUMMULTIRANGE: &#x27;NUMMULTIRANGE&#x27;&gt;, &#x27;TSRANGE&#x27;: &lt;TokenType.TSRANGE: &#x27;TSRANGE&#x27;&gt;, &#x27;TSMULTIRANGE&#x27;: &lt;TokenType.TSMULTIRANGE: &#x27;TSMULTIRANGE&#x27;&gt;, &#x27;TSTZRANGE&#x27;: &lt;TokenType.TSTZRANGE: &#x27;TSTZRANGE&#x27;&gt;, &#x27;TSTZMULTIRANGE&#x27;: &lt;TokenType.TSTZMULTIRANGE: &#x27;TSTZMULTIRANGE&#x27;&gt;, &#x27;DATERANGE&#x27;: &lt;TokenType.DATERANGE: &#x27;DATERANGE&#x27;&gt;, &#x27;DATEMULTIRANGE&#x27;: &lt;TokenType.DATEMULTIRANGE: &#x27;DATEMULTIRANGE&#x27;&gt;, &#x27;UNIQUE&#x27;: &lt;TokenType.UNIQUE: &#x27;UNIQUE&#x27;&gt;, &#x27;STRUCT&#x27;: &lt;TokenType.STRUCT: &#x27;STRUCT&#x27;&gt;, &#x27;VARIANT&#x27;: &lt;TokenType.VARIANT: &#x27;VARIANT&#x27;&gt;, &#x27;ALTER&#x27;: &lt;TokenType.ALTER: &#x27;ALTER&#x27;&gt;, &#x27;ANALYZE&#x27;: &lt;TokenType.COMMAND: &#x27;COMMAND&#x27;&gt;, &#x27;CALL&#x27;: &lt;TokenType.COMMAND: &#x27;COMMAND&#x27;&gt;, &#x27;COMMENT&#x27;: &lt;TokenType.COMMENT: &#x27;COMMENT&#x27;&gt;, &#x27;COPY&#x27;: &lt;TokenType.COMMAND: &#x27;COMMAND&#x27;&gt;, &#x27;EXPLAIN&#x27;: &lt;TokenType.COMMAND: &#x27;COMMAND&#x27;&gt;, &#x27;GRANT&#x27;: &lt;TokenType.COMMAND: &#x27;COMMAND&#x27;&gt;, &#x27;OPTIMIZE&#x27;: &lt;TokenType.COMMAND: &#x27;COMMAND&#x27;&gt;, &#x27;PREPARE&#x27;: &lt;TokenType.COMMAND: &#x27;COMMAND&#x27;&gt;, &#x27;TRUNCATE&#x27;: &lt;TokenType.COMMAND: &#x27;COMMAND&#x27;&gt;, &#x27;VACUUM&#x27;: &lt;TokenType.COMMAND: &#x27;COMMAND&#x27;&gt;, &#x27;USER-DEFINED&#x27;: &lt;TokenType.USERDEFINED: &#x27;USERDEFINED&#x27;&gt;, &#x27;FOR VERSION&#x27;: &lt;TokenType.VERSION_SNAPSHOT: &#x27;VERSION_SNAPSHOT&#x27;&gt;, &#x27;FOR TIMESTAMP&#x27;: &lt;TokenType.TIMESTAMP_SNAPSHOT: &#x27;TIMESTAMP_SNAPSHOT&#x27;&gt;, &#x27;:=&#x27;: &lt;TokenType.EQ: &#x27;EQ&#x27;&gt;, &#x27;//&#x27;: &lt;TokenType.DIV: &#x27;DIV&#x27;&gt;, &#x27;ATTACH&#x27;: &lt;TokenType.COMMAND: &#x27;COMMAND&#x27;&gt;, &#x27;BITSTRING&#x27;: &lt;TokenType.BIT: &#x27;BIT&#x27;&gt;, &#x27;BPCHAR&#x27;: &lt;TokenType.TEXT: &#x27;TEXT&#x27;&gt;, &#x27;CHARACTER VARYING&#x27;: &lt;TokenType.TEXT: &#x27;TEXT&#x27;&gt;, &#x27;EXCLUDE&#x27;: &lt;TokenType.EXCEPT: &#x27;EXCEPT&#x27;&gt;, &#x27;HUGEINT&#x27;: &lt;TokenType.INT128: &#x27;INT128&#x27;&gt;, &#x27;INT1&#x27;: &lt;TokenType.TINYINT: &#x27;TINYINT&#x27;&gt;, &#x27;LOGICAL&#x27;: &lt;TokenType.BOOLEAN: &#x27;BOOLEAN&#x27;&gt;, &#x27;PIVOT_WIDER&#x27;: &lt;TokenType.PIVOT: &#x27;PIVOT&#x27;&gt;, &#x27;SIGNED&#x27;: &lt;TokenType.INT: &#x27;INT&#x27;&gt;, &#x27;UBIGINT&#x27;: &lt;TokenType.UBIGINT: &#x27;UBIGINT&#x27;&gt;, &#x27;UINTEGER&#x27;: &lt;TokenType.UINT: &#x27;UINT&#x27;&gt;, &#x27;USMALLINT&#x27;: &lt;TokenType.USMALLINT: &#x27;USMALLINT&#x27;&gt;, &#x27;UTINYINT&#x27;: &lt;TokenType.UTINYINT: &#x27;UTINYINT&#x27;&gt;, &#x27;TIMESTAMP_S&#x27;: &lt;TokenType.TIMESTAMP_S: &#x27;TIMESTAMP_S&#x27;&gt;, &#x27;TIMESTAMP_MS&#x27;: &lt;TokenType.TIMESTAMP_MS: &#x27;TIMESTAMP_MS&#x27;&gt;, &#x27;TIMESTAMP_NS&#x27;: &lt;TokenType.TIMESTAMP_NS: &#x27;TIMESTAMP_NS&#x27;&gt;, &#x27;TIMESTAMP_US&#x27;: &lt;TokenType.TIMESTAMP: &#x27;TIMESTAMP&#x27;&gt;}"}, "sqlglot.dialects.duckdb.DuckDB.Parser": {"fullname": "sqlglot.dialects.duckdb.DuckDB.Parser", "modulename": "sqlglot.dialects.duckdb", "qualname": "DuckDB.Parser", "kind": "class", "doc": "<p>Parser consumes a list of tokens produced by the Tokenizer and produces a parsed syntax tree.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>error_level:</strong>  The desired error level.\nDefault: ErrorLevel.IMMEDIATE</li>\n<li><strong>error_message_context:</strong>  Determines the amount of context to capture from a\nquery string when displaying the error message (in number of characters).\nDefault: 100</li>\n<li><strong>max_errors:</strong>  Maximum number of error messages to include in a raised ParseError.\nThis is only relevant if error_level is ErrorLevel.RAISE.\nDefault: 3</li>\n</ul>\n", "bases": "sqlglot.parser.Parser"}, "sqlglot.dialects.duckdb.DuckDB.Parser.CONCAT_NULL_OUTPUTS_STRING": {"fullname": "sqlglot.dialects.duckdb.DuckDB.Parser.CONCAT_NULL_OUTPUTS_STRING", "modulename": "sqlglot.dialects.duckdb", "qualname": "DuckDB.Parser.CONCAT_NULL_OUTPUTS_STRING", "kind": "variable", "doc": "<p></p>\n", "default_value": "True"}, "sqlglot.dialects.duckdb.DuckDB.Parser.BITWISE": {"fullname": "sqlglot.dialects.duckdb.DuckDB.Parser.BITWISE", "modulename": "sqlglot.dialects.duckdb", "qualname": "DuckDB.Parser.BITWISE", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&lt;TokenType.AMP: &#x27;AMP&#x27;&gt;: &lt;class &#x27;sqlglot.expressions.BitwiseAnd&#x27;&gt;, &lt;TokenType.CARET: &#x27;CARET&#x27;&gt;: &lt;class &#x27;sqlglot.expressions.BitwiseXor&#x27;&gt;, &lt;TokenType.PIPE: &#x27;PIPE&#x27;&gt;: &lt;class &#x27;sqlglot.expressions.BitwiseOr&#x27;&gt;, &lt;TokenType.DPIPE: &#x27;DPIPE&#x27;&gt;: &lt;class &#x27;sqlglot.expressions.SafeDPipe&#x27;&gt;, &lt;TokenType.TILDA: &#x27;TILDA&#x27;&gt;: &lt;class &#x27;sqlglot.expressions.RegexpLike&#x27;&gt;}"}, "sqlglot.dialects.duckdb.DuckDB.Parser.FUNCTIONS": {"fullname": "sqlglot.dialects.duckdb.DuckDB.Parser.FUNCTIONS", "modulename": "sqlglot.dialects.duckdb", "qualname": "DuckDB.Parser.FUNCTIONS", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;ABS&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Abs&#x27;&gt;&gt;, &#x27;ANY_VALUE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.AnyValue&#x27;&gt;&gt;, &#x27;APPROX_DISTINCT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ApproxDistinct&#x27;&gt;&gt;, &#x27;APPROX_COUNT_DISTINCT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ApproxDistinct&#x27;&gt;&gt;, &#x27;APPROX_QUANTILE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ApproxQuantile&#x27;&gt;&gt;, &#x27;ARRAY&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Array&#x27;&gt;&gt;, &#x27;ARRAY_AGG&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArrayAgg&#x27;&gt;&gt;, &#x27;ARRAY_ALL&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArrayAll&#x27;&gt;&gt;, &#x27;ARRAY_ANY&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArrayAny&#x27;&gt;&gt;, &#x27;ARRAY_CONCAT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArrayConcat&#x27;&gt;&gt;, &#x27;ARRAY_CAT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArrayConcat&#x27;&gt;&gt;, &#x27;ARRAY_CONTAINS&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArrayContains&#x27;&gt;&gt;, &#x27;FILTER&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArrayFilter&#x27;&gt;&gt;, &#x27;ARRAY_FILTER&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArrayFilter&#x27;&gt;&gt;, &#x27;ARRAY_JOIN&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArrayJoin&#x27;&gt;&gt;, &#x27;ARRAY_SIZE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArraySize&#x27;&gt;&gt;, &#x27;ARRAY_SORT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.SortArray&#x27;&gt;&gt;, &#x27;ARRAY_SUM&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArraySum&#x27;&gt;&gt;, &#x27;ARRAY_UNION_AGG&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArrayUnionAgg&#x27;&gt;&gt;, &#x27;AVG&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Avg&#x27;&gt;&gt;, &#x27;CASE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Case&#x27;&gt;&gt;, &#x27;CAST&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Cast&#x27;&gt;&gt;, &#x27;CAST_TO_STR_TYPE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.CastToStrType&#x27;&gt;&gt;, &#x27;CEIL&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Ceil&#x27;&gt;&gt;, &#x27;CEILING&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Ceil&#x27;&gt;&gt;, &#x27;CHR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Chr&#x27;&gt;&gt;, &#x27;CHAR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Chr&#x27;&gt;&gt;, &#x27;COALESCE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Coalesce&#x27;&gt;&gt;, &#x27;IFNULL&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Coalesce&#x27;&gt;&gt;, &#x27;NVL&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Coalesce&#x27;&gt;&gt;, &#x27;COLLATE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Collate&#x27;&gt;&gt;, &#x27;CONCAT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Concat&#x27;&gt;&gt;, &#x27;CONCAT_WS&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ConcatWs&#x27;&gt;&gt;, &#x27;COUNT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Count&#x27;&gt;&gt;, &#x27;COUNT_IF&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.CountIf&#x27;&gt;&gt;, &#x27;CURRENT_DATE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.CurrentDate&#x27;&gt;&gt;, &#x27;CURRENT_DATETIME&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.CurrentDatetime&#x27;&gt;&gt;, &#x27;CURRENT_TIME&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.CurrentTime&#x27;&gt;&gt;, &#x27;CURRENT_TIMESTAMP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.CurrentTimestamp&#x27;&gt;&gt;, &#x27;CURRENT_USER&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.CurrentUser&#x27;&gt;&gt;, &#x27;DATE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Date&#x27;&gt;&gt;, &#x27;DATE_ADD&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DateAdd&#x27;&gt;&gt;, &#x27;DATEDIFF&#x27;: &lt;function _parse_date_diff&gt;, &#x27;DATE_DIFF&#x27;: &lt;function _parse_date_diff&gt;, &#x27;DATEFROMPARTS&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DateFromParts&#x27;&gt;&gt;, &#x27;DATE_STR_TO_DATE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DateStrToDate&#x27;&gt;&gt;, &#x27;DATE_SUB&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DateSub&#x27;&gt;&gt;, &#x27;DATE_TO_DATE_STR&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;DATE_TO_DI&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DateToDi&#x27;&gt;&gt;, &#x27;DATE_TRUNC&#x27;: &lt;function date_trunc_to_time&gt;, &#x27;DATETIME_ADD&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DatetimeAdd&#x27;&gt;&gt;, &#x27;DATETIME_DIFF&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DatetimeDiff&#x27;&gt;&gt;, &#x27;DATETIME_SUB&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DatetimeSub&#x27;&gt;&gt;, &#x27;DATETIME_TRUNC&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DatetimeTrunc&#x27;&gt;&gt;, &#x27;DAY&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Day&#x27;&gt;&gt;, &#x27;DAY_OF_MONTH&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DayOfMonth&#x27;&gt;&gt;, &#x27;DAYOFMONTH&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DayOfMonth&#x27;&gt;&gt;, &#x27;DAY_OF_WEEK&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DayOfWeek&#x27;&gt;&gt;, &#x27;DAYOFWEEK&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DayOfWeek&#x27;&gt;&gt;, &#x27;DAY_OF_YEAR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DayOfYear&#x27;&gt;&gt;, &#x27;DAYOFYEAR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DayOfYear&#x27;&gt;&gt;, &#x27;DECODE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Decode&#x27;&gt;&gt;, &#x27;DI_TO_DATE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DiToDate&#x27;&gt;&gt;, &#x27;ENCODE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Encode&#x27;&gt;&gt;, &#x27;EXP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Exp&#x27;&gt;&gt;, &#x27;EXPLODE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Explode&#x27;&gt;&gt;, &#x27;EXPLODE_OUTER&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ExplodeOuter&#x27;&gt;&gt;, &#x27;EXTRACT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Extract&#x27;&gt;&gt;, &#x27;FIRST&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.First&#x27;&gt;&gt;, &#x27;FLATTEN&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Flatten&#x27;&gt;&gt;, &#x27;FLOOR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Floor&#x27;&gt;&gt;, &#x27;FROM_BASE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.FromBase&#x27;&gt;&gt;, &#x27;FROM_BASE64&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.FromBase64&#x27;&gt;&gt;, &#x27;GENERATE_SERIES&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.GenerateSeries&#x27;&gt;&gt;, &#x27;GREATEST&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Greatest&#x27;&gt;&gt;, &#x27;GROUP_CONCAT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.GroupConcat&#x27;&gt;&gt;, &#x27;HEX&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Hex&#x27;&gt;&gt;, &#x27;HLL&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Hll&#x27;&gt;&gt;, &#x27;IF&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.If&#x27;&gt;&gt;, &#x27;INITCAP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Initcap&#x27;&gt;&gt;, &#x27;IS_NAN&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.IsNan&#x27;&gt;&gt;, &#x27;ISNAN&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.IsNan&#x27;&gt;&gt;, &#x27;J_S_O_N_ARRAY&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.JSONArray&#x27;&gt;&gt;, &#x27;J_S_O_N_ARRAY_AGG&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.JSONArrayAgg&#x27;&gt;&gt;, &#x27;JSON_ARRAY_CONTAINS&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.JSONArrayContains&#x27;&gt;&gt;, &#x27;JSONB_EXTRACT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.JSONBExtract&#x27;&gt;&gt;, &#x27;JSONB_EXTRACT_SCALAR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.JSONBExtractScalar&#x27;&gt;&gt;, &#x27;JSON_EXTRACT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.JSONExtract&#x27;&gt;&gt;, &#x27;JSON_EXTRACT_SCALAR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.JSONExtractScalar&#x27;&gt;&gt;, &#x27;JSON_FORMAT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.JSONFormat&#x27;&gt;&gt;, &#x27;J_S_O_N_OBJECT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.JSONObject&#x27;&gt;&gt;, &#x27;J_S_O_N_TABLE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.JSONTable&#x27;&gt;&gt;, &#x27;LAST&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Last&#x27;&gt;&gt;, &#x27;LAST_DATE_OF_MONTH&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.LastDateOfMonth&#x27;&gt;&gt;, &#x27;LEAST&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Least&#x27;&gt;&gt;, &#x27;LEFT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Left&#x27;&gt;&gt;, &#x27;LENGTH&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Length&#x27;&gt;&gt;, &#x27;LEN&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Length&#x27;&gt;&gt;, &#x27;LEVENSHTEIN&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Levenshtein&#x27;&gt;&gt;, &#x27;LN&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Ln&#x27;&gt;&gt;, &#x27;LOG&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Log&#x27;&gt;&gt;, &#x27;LOG10&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Log10&#x27;&gt;&gt;, &#x27;LOG2&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Log2&#x27;&gt;&gt;, &#x27;LOGICAL_AND&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.LogicalAnd&#x27;&gt;&gt;, &#x27;BOOL_AND&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.LogicalAnd&#x27;&gt;&gt;, &#x27;BOOLAND_AGG&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.LogicalAnd&#x27;&gt;&gt;, &#x27;LOGICAL_OR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.LogicalOr&#x27;&gt;&gt;, &#x27;BOOL_OR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.LogicalOr&#x27;&gt;&gt;, &#x27;BOOLOR_AGG&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.LogicalOr&#x27;&gt;&gt;, &#x27;LOWER&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Lower&#x27;&gt;&gt;, &#x27;LCASE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Lower&#x27;&gt;&gt;, &#x27;MD5&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.MD5&#x27;&gt;&gt;, &#x27;MD5_DIGEST&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.MD5Digest&#x27;&gt;&gt;, &#x27;MAP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Map&#x27;&gt;&gt;, &#x27;MAP_FROM_ENTRIES&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.MapFromEntries&#x27;&gt;&gt;, &#x27;MATCH_AGAINST&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.MatchAgainst&#x27;&gt;&gt;, &#x27;MAX&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Max&#x27;&gt;&gt;, &#x27;MIN&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Min&#x27;&gt;&gt;, &#x27;MONTH&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Month&#x27;&gt;&gt;, &#x27;MONTHS_BETWEEN&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.MonthsBetween&#x27;&gt;&gt;, &#x27;NEXT_VALUE_FOR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.NextValueFor&#x27;&gt;&gt;, &#x27;NUMBER_TO_STR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.NumberToStr&#x27;&gt;&gt;, &#x27;NVL2&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Nvl2&#x27;&gt;&gt;, &#x27;OPEN_J_S_O_N&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.OpenJSON&#x27;&gt;&gt;, &#x27;PARAMETERIZED_AGG&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ParameterizedAgg&#x27;&gt;&gt;, &#x27;PARSE_JSON&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ParseJSON&#x27;&gt;&gt;, &#x27;JSON_PARSE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ParseJSON&#x27;&gt;&gt;, &#x27;PERCENTILE_CONT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.PercentileCont&#x27;&gt;&gt;, &#x27;PERCENTILE_DISC&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.PercentileDisc&#x27;&gt;&gt;, &#x27;POSEXPLODE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Posexplode&#x27;&gt;&gt;, &#x27;POSEXPLODE_OUTER&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.PosexplodeOuter&#x27;&gt;&gt;, &#x27;POWER&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Pow&#x27;&gt;&gt;, &#x27;POW&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Pow&#x27;&gt;&gt;, &#x27;PREDICT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Predict&#x27;&gt;&gt;, &#x27;QUANTILE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Quantile&#x27;&gt;&gt;, &#x27;RANGE_N&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.RangeN&#x27;&gt;&gt;, &#x27;READ_CSV&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ReadCSV&#x27;&gt;&gt;, &#x27;REDUCE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Reduce&#x27;&gt;&gt;, &#x27;REGEXP_EXTRACT&#x27;: &lt;function DuckDB.Parser.&lt;lambda&gt;&gt;, &#x27;REGEXP_I_LIKE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.RegexpILike&#x27;&gt;&gt;, &#x27;REGEXP_LIKE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.RegexpLike&#x27;&gt;&gt;, &#x27;REGEXP_REPLACE&#x27;: &lt;function DuckDB.Parser.&lt;lambda&gt;&gt;, &#x27;REGEXP_SPLIT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.RegexpSplit&#x27;&gt;&gt;, &#x27;REPEAT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Repeat&#x27;&gt;&gt;, &#x27;RIGHT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Right&#x27;&gt;&gt;, &#x27;ROUND&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Round&#x27;&gt;&gt;, &#x27;ROW_NUMBER&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.RowNumber&#x27;&gt;&gt;, &#x27;SHA&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.SHA&#x27;&gt;&gt;, &#x27;SHA1&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.SHA&#x27;&gt;&gt;, &#x27;SHA2&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.SHA2&#x27;&gt;&gt;, &#x27;SAFE_CONCAT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.SafeConcat&#x27;&gt;&gt;, &#x27;SAFE_DIVIDE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.SafeDivide&#x27;&gt;&gt;, &#x27;SET_AGG&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.SetAgg&#x27;&gt;&gt;, &#x27;SORT_ARRAY&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.SortArray&#x27;&gt;&gt;, &#x27;SPLIT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Split&#x27;&gt;&gt;, &#x27;SQRT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Sqrt&#x27;&gt;&gt;, &#x27;STANDARD_HASH&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StandardHash&#x27;&gt;&gt;, &#x27;STAR_MAP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StarMap&#x27;&gt;&gt;, &#x27;STARTS_WITH&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StartsWith&#x27;&gt;&gt;, &#x27;STARTSWITH&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StartsWith&#x27;&gt;&gt;, &#x27;STDDEV&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Stddev&#x27;&gt;&gt;, &#x27;STDDEV_POP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StddevPop&#x27;&gt;&gt;, &#x27;STDDEV_SAMP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StddevSamp&#x27;&gt;&gt;, &#x27;STR_POSITION&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StrPosition&#x27;&gt;&gt;, &#x27;STR_TO_DATE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StrToDate&#x27;&gt;&gt;, &#x27;STR_TO_MAP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StrToMap&#x27;&gt;&gt;, &#x27;STR_TO_TIME&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StrToTime&#x27;&gt;&gt;, &#x27;STR_TO_UNIX&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StrToUnix&#x27;&gt;&gt;, &#x27;STRUCT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Struct&#x27;&gt;&gt;, &#x27;STRUCT_EXTRACT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StructExtract&#x27;&gt;&gt;, &#x27;STUFF&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Stuff&#x27;&gt;&gt;, &#x27;INSERT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Stuff&#x27;&gt;&gt;, &#x27;SUBSTRING&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Substring&#x27;&gt;&gt;, &#x27;SUM&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Sum&#x27;&gt;&gt;, &#x27;TIME_ADD&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimeAdd&#x27;&gt;&gt;, &#x27;TIME_DIFF&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimeDiff&#x27;&gt;&gt;, &#x27;TIME_STR_TO_DATE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimeStrToDate&#x27;&gt;&gt;, &#x27;TIME_STR_TO_TIME&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimeStrToTime&#x27;&gt;&gt;, &#x27;TIME_STR_TO_UNIX&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimeStrToUnix&#x27;&gt;&gt;, &#x27;TIME_SUB&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimeSub&#x27;&gt;&gt;, &#x27;TIME_TO_STR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimeToStr&#x27;&gt;&gt;, &#x27;TIME_TO_TIME_STR&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;TIME_TO_UNIX&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimeToUnix&#x27;&gt;&gt;, &#x27;TIME_TRUNC&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimeTrunc&#x27;&gt;&gt;, &#x27;TIMESTAMP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Timestamp&#x27;&gt;&gt;, &#x27;TIMESTAMP_ADD&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimestampAdd&#x27;&gt;&gt;, &#x27;TIMESTAMP_DIFF&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimestampDiff&#x27;&gt;&gt;, &#x27;TIMESTAMP_SUB&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimestampSub&#x27;&gt;&gt;, &#x27;TIMESTAMP_TRUNC&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimestampTrunc&#x27;&gt;&gt;, &#x27;TO_BASE64&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ToBase64&#x27;&gt;&gt;, &#x27;TO_CHAR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ToChar&#x27;&gt;&gt;, &#x27;TO_DAYS&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ToDays&#x27;&gt;&gt;, &#x27;TRANSFORM&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Transform&#x27;&gt;&gt;, &#x27;TRIM&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Trim&#x27;&gt;&gt;, &#x27;TRY_CAST&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TryCast&#x27;&gt;&gt;, &#x27;TS_OR_DI_TO_DI&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TsOrDiToDi&#x27;&gt;&gt;, &#x27;TS_OR_DS_ADD&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TsOrDsAdd&#x27;&gt;&gt;, &#x27;TS_OR_DS_TO_DATE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TsOrDsToDate&#x27;&gt;&gt;, &#x27;TS_OR_DS_TO_DATE_STR&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;UNHEX&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Unhex&#x27;&gt;&gt;, &#x27;UNIX_TO_STR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.UnixToStr&#x27;&gt;&gt;, &#x27;UNIX_TO_TIME&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.UnixToTime&#x27;&gt;&gt;, &#x27;UNIX_TO_TIME_STR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.UnixToTimeStr&#x27;&gt;&gt;, &#x27;UPPER&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Upper&#x27;&gt;&gt;, &#x27;UCASE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Upper&#x27;&gt;&gt;, &#x27;VAR_MAP&#x27;: &lt;function parse_var_map&gt;, &#x27;VARIANCE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Variance&#x27;&gt;&gt;, &#x27;VARIANCE_SAMP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Variance&#x27;&gt;&gt;, &#x27;VAR_SAMP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Variance&#x27;&gt;&gt;, &#x27;VARIANCE_POP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.VariancePop&#x27;&gt;&gt;, &#x27;VAR_POP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.VariancePop&#x27;&gt;&gt;, &#x27;WEEK&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Week&#x27;&gt;&gt;, &#x27;WEEK_OF_YEAR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.WeekOfYear&#x27;&gt;&gt;, &#x27;WEEKOFYEAR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.WeekOfYear&#x27;&gt;&gt;, &#x27;WHEN&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.When&#x27;&gt;&gt;, &#x27;X_M_L_TABLE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.XMLTable&#x27;&gt;&gt;, &#x27;XOR&#x27;: &lt;function binary_from_function.&lt;locals&gt;.&lt;lambda&gt;&gt;, &#x27;YEAR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Year&#x27;&gt;&gt;, &#x27;GLOB&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;LIKE&#x27;: &lt;function parse_like&gt;, &#x27;ARRAY_LENGTH&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArraySize&#x27;&gt;&gt;, &#x27;ARRAY_REVERSE_SORT&#x27;: &lt;function _sort_array_reverse&gt;, &#x27;DATETRUNC&#x27;: &lt;function date_trunc_to_time&gt;, &#x27;EPOCH&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimeToUnix&#x27;&gt;&gt;, &#x27;EPOCH_MS&#x27;: &lt;function DuckDB.Parser.&lt;lambda&gt;&gt;, &#x27;LIST_REVERSE_SORT&#x27;: &lt;function _sort_array_reverse&gt;, &#x27;LIST_SORT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.SortArray&#x27;&gt;&gt;, &#x27;LIST_VALUE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Array&#x27;&gt;&gt;, &#x27;MEDIAN&#x27;: &lt;function DuckDB.Parser.&lt;lambda&gt;&gt;, &#x27;QUANTILE_CONT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.PercentileCont&#x27;&gt;&gt;, &#x27;QUANTILE_DISC&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.PercentileDisc&#x27;&gt;&gt;, &#x27;REGEXP_MATCHES&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.RegexpLike&#x27;&gt;&gt;, &#x27;STRFTIME&#x27;: &lt;function format_time_lambda.&lt;locals&gt;._format_time&gt;, &#x27;STRING_SPLIT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Split&#x27;&gt;&gt;, &#x27;STRING_SPLIT_REGEX&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.RegexpSplit&#x27;&gt;&gt;, &#x27;STRING_TO_ARRAY&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Split&#x27;&gt;&gt;, &#x27;STRPTIME&#x27;: &lt;function format_time_lambda.&lt;locals&gt;._format_time&gt;, &#x27;STRUCT_PACK&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Struct&#x27;&gt;&gt;, &#x27;STR_SPLIT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Split&#x27;&gt;&gt;, &#x27;STR_SPLIT_REGEX&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.RegexpSplit&#x27;&gt;&gt;, &#x27;TO_TIMESTAMP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.UnixToTime&#x27;&gt;&gt;, &#x27;UNNEST&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Explode&#x27;&gt;&gt;}"}, "sqlglot.dialects.duckdb.DuckDB.Parser.FUNCTION_PARSERS": {"fullname": "sqlglot.dialects.duckdb.DuckDB.Parser.FUNCTION_PARSERS", "modulename": "sqlglot.dialects.duckdb", "qualname": "DuckDB.Parser.FUNCTION_PARSERS", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;ANY_VALUE&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;CAST&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;CONCAT&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;CONCAT_WS&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;CONVERT&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;DECODE&#x27;: &lt;function DuckDB.Parser.&lt;lambda&gt;&gt;, &#x27;EXTRACT&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;JSON_OBJECT&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;JSON_TABLE&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;LOG&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;MATCH&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;OPENJSON&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;POSITION&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;PREDICT&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;SAFE_CAST&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;STRING_AGG&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;SUBSTRING&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;TRIM&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;TRY_CAST&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;TRY_CONVERT&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;ENCODE&#x27;: &lt;function DuckDB.Parser.&lt;lambda&gt;&gt;}"}, "sqlglot.dialects.duckdb.DuckDB.Parser.TABLE_ALIAS_TOKENS": {"fullname": "sqlglot.dialects.duckdb.DuckDB.Parser.TABLE_ALIAS_TOKENS", "modulename": "sqlglot.dialects.duckdb", "qualname": "DuckDB.Parser.TABLE_ALIAS_TOKENS", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&lt;TokenType.DATEMULTIRANGE: &#x27;DATEMULTIRANGE&#x27;&gt;, &lt;TokenType.PERCENT: &#x27;PERCENT&#x27;&gt;, &lt;TokenType.UMEDIUMINT: &#x27;UMEDIUMINT&#x27;&gt;, &lt;TokenType.DOUBLE: &#x27;DOUBLE&#x27;&gt;, &lt;TokenType.PIVOT: &#x27;PIVOT&#x27;&gt;, &lt;TokenType.TRUE: &#x27;TRUE&#x27;&gt;, &lt;TokenType.TEXT: &#x27;TEXT&#x27;&gt;, &lt;TokenType.EXECUTE: &#x27;EXECUTE&#x27;&gt;, &lt;TokenType.DESC: &#x27;DESC&#x27;&gt;, &lt;TokenType.CACHE: &#x27;CACHE&#x27;&gt;, &lt;TokenType.FUNCTION: &#x27;FUNCTION&#x27;&gt;, &lt;TokenType.DATE: &#x27;DATE&#x27;&gt;, &lt;TokenType.BIT: &#x27;BIT&#x27;&gt;, &lt;TokenType.SETTINGS: &#x27;SETTINGS&#x27;&gt;, &lt;TokenType.TINYTEXT: &#x27;TINYTEXT&#x27;&gt;, &lt;TokenType.ROWVERSION: &#x27;ROWVERSION&#x27;&gt;, &lt;TokenType.CURRENT_USER: &#x27;CURRENT_USER&#x27;&gt;, &lt;TokenType.GEOGRAPHY: &#x27;GEOGRAPHY&#x27;&gt;, &lt;TokenType.BIGDECIMAL: &#x27;BIGDECIMAL&#x27;&gt;, &lt;TokenType.INT4MULTIRANGE: &#x27;INT4MULTIRANGE&#x27;&gt;, &lt;TokenType.CASE: &#x27;CASE&#x27;&gt;, &lt;TokenType.EXISTS: &#x27;EXISTS&#x27;&gt;, &lt;TokenType.INDEX: &#x27;INDEX&#x27;&gt;, &lt;TokenType.UUID: &#x27;UUID&#x27;&gt;, &lt;TokenType.LOWCARDINALITY: &#x27;LOWCARDINALITY&#x27;&gt;, &lt;TokenType.UNKNOWN: &#x27;UNKNOWN&#x27;&gt;, &lt;TokenType.MEDIUMINT: &#x27;MEDIUMINT&#x27;&gt;, &lt;TokenType.CURRENT_DATETIME: &#x27;CURRENT_DATETIME&#x27;&gt;, &lt;TokenType.VOLATILE: &#x27;VOLATILE&#x27;&gt;, &lt;TokenType.ALL: &#x27;ALL&#x27;&gt;, &lt;TokenType.TINYBLOB: &#x27;TINYBLOB&#x27;&gt;, &lt;TokenType.TSMULTIRANGE: &#x27;TSMULTIRANGE&#x27;&gt;, &lt;TokenType.TIMETZ: &#x27;TIMETZ&#x27;&gt;, &lt;TokenType.ENUM16: &#x27;ENUM16&#x27;&gt;, &lt;TokenType.SHOW: &#x27;SHOW&#x27;&gt;, &lt;TokenType.OVERLAPS: &#x27;OVERLAPS&#x27;&gt;, &lt;TokenType.SMALLSERIAL: &#x27;SMALLSERIAL&#x27;&gt;, &lt;TokenType.COLLATE: &#x27;COLLATE&#x27;&gt;, &lt;TokenType.COMMENT: &#x27;COMMENT&#x27;&gt;, &lt;TokenType.FILTER: &#x27;FILTER&#x27;&gt;, &lt;TokenType.HLLSKETCH: &#x27;HLLSKETCH&#x27;&gt;, &lt;TokenType.ROWS: &#x27;ROWS&#x27;&gt;, &lt;TokenType.VARCHAR: &#x27;VARCHAR&#x27;&gt;, &lt;TokenType.UPDATE: &#x27;UPDATE&#x27;&gt;, &lt;TokenType.DICTIONARY: &#x27;DICTIONARY&#x27;&gt;, &lt;TokenType.TABLE: &#x27;TABLE&#x27;&gt;, &lt;TokenType.USERDEFINED: &#x27;USERDEFINED&#x27;&gt;, &lt;TokenType.DIV: &#x27;DIV&#x27;&gt;, &lt;TokenType.UNPIVOT: &#x27;UNPIVOT&#x27;&gt;, &lt;TokenType.FIXEDSTRING: &#x27;FIXEDSTRING&#x27;&gt;, &lt;TokenType.VARIANT: &#x27;VARIANT&#x27;&gt;, &lt;TokenType.BIGINT: &#x27;BIGINT&#x27;&gt;, &lt;TokenType.PARTITION: &#x27;PARTITION&#x27;&gt;, &lt;TokenType.DATERANGE: &#x27;DATERANGE&#x27;&gt;, &lt;TokenType.STRUCT: &#x27;STRUCT&#x27;&gt;, &lt;TokenType.ASC: &#x27;ASC&#x27;&gt;, &lt;TokenType.PRAGMA: &#x27;PRAGMA&#x27;&gt;, &lt;TokenType.PROCEDURE: &#x27;PROCEDURE&#x27;&gt;, &lt;TokenType.SOME: &#x27;SOME&#x27;&gt;, &lt;TokenType.VARBINARY: &#x27;VARBINARY&#x27;&gt;, &lt;TokenType.NUMRANGE: &#x27;NUMRANGE&#x27;&gt;, &lt;TokenType.ESCAPE: &#x27;ESCAPE&#x27;&gt;, &lt;TokenType.ANY: &#x27;ANY&#x27;&gt;, &lt;TokenType.DELETE: &#x27;DELETE&#x27;&gt;, &lt;TokenType.LONGTEXT: &#x27;LONGTEXT&#x27;&gt;, &lt;TokenType.LOAD: &#x27;LOAD&#x27;&gt;, &lt;TokenType.NEXT: &#x27;NEXT&#x27;&gt;, &lt;TokenType.TOP: &#x27;TOP&#x27;&gt;, &lt;TokenType.DEFAULT: &#x27;DEFAULT&#x27;&gt;, &lt;TokenType.TIMESTAMP_MS: &#x27;TIMESTAMP_MS&#x27;&gt;, &lt;TokenType.HSTORE: &#x27;HSTORE&#x27;&gt;, &lt;TokenType.AUTO_INCREMENT: &#x27;AUTO_INCREMENT&#x27;&gt;, &lt;TokenType.OVERWRITE: &#x27;OVERWRITE&#x27;&gt;, &lt;TokenType.IS: &#x27;IS&#x27;&gt;, &lt;TokenType.NULL: &#x27;NULL&#x27;&gt;, &lt;TokenType.TIMESTAMP_NS: &#x27;TIMESTAMP_NS&#x27;&gt;, &lt;TokenType.VAR: &#x27;VAR&#x27;&gt;, &lt;TokenType.UNIQUEIDENTIFIER: &#x27;UNIQUEIDENTIFIER&#x27;&gt;, &lt;TokenType.IPADDRESS: &#x27;IPADDRESS&#x27;&gt;, &lt;TokenType.TIME: &#x27;TIME&#x27;&gt;, &lt;TokenType.TIMESTAMPLTZ: &#x27;TIMESTAMPLTZ&#x27;&gt;, &lt;TokenType.TINYINT: &#x27;TINYINT&#x27;&gt;, &lt;TokenType.UINT128: &#x27;UINT128&#x27;&gt;, &lt;TokenType.UINT256: &#x27;UINT256&#x27;&gt;, &lt;TokenType.NCHAR: &#x27;NCHAR&#x27;&gt;, &lt;TokenType.COMMAND: &#x27;COMMAND&#x27;&gt;, &lt;TokenType.BOOLEAN: &#x27;BOOLEAN&#x27;&gt;, &lt;TokenType.SUPER: &#x27;SUPER&#x27;&gt;, &lt;TokenType.CONSTRAINT: &#x27;CONSTRAINT&#x27;&gt;, &lt;TokenType.UDECIMAL: &#x27;UDECIMAL&#x27;&gt;, &lt;TokenType.REFERENCES: &#x27;REFERENCES&#x27;&gt;, &lt;TokenType.CURRENT_TIMESTAMP: &#x27;CURRENT_TIMESTAMP&#x27;&gt;, &lt;TokenType.INT4RANGE: &#x27;INT4RANGE&#x27;&gt;, &lt;TokenType.VIEW: &#x27;VIEW&#x27;&gt;, &lt;TokenType.BIGSERIAL: &#x27;BIGSERIAL&#x27;&gt;, &lt;TokenType.MONEY: &#x27;MONEY&#x27;&gt;, &lt;TokenType.COMMIT: &#x27;COMMIT&#x27;&gt;, &lt;TokenType.LONGBLOB: &#x27;LONGBLOB&#x27;&gt;, &lt;TokenType.INT8MULTIRANGE: &#x27;INT8MULTIRANGE&#x27;&gt;, &lt;TokenType.DATETIME64: &#x27;DATETIME64&#x27;&gt;, &lt;TokenType.IMAGE: &#x27;IMAGE&#x27;&gt;, &lt;TokenType.UTINYINT: &#x27;UTINYINT&#x27;&gt;, &lt;TokenType.MERGE: &#x27;MERGE&#x27;&gt;, &lt;TokenType.INT128: &#x27;INT128&#x27;&gt;, &lt;TokenType.ENUM8: &#x27;ENUM8&#x27;&gt;, &lt;TokenType.DATABASE: &#x27;DATABASE&#x27;&gt;, &lt;TokenType.SMALLMONEY: &#x27;SMALLMONEY&#x27;&gt;, &lt;TokenType.CURRENT_DATE: &#x27;CURRENT_DATE&#x27;&gt;, &lt;TokenType.TSRANGE: &#x27;TSRANGE&#x27;&gt;, &lt;TokenType.TEMPORARY: &#x27;TEMPORARY&#x27;&gt;, &lt;TokenType.SET: &#x27;SET&#x27;&gt;, &lt;TokenType.INT256: &#x27;INT256&#x27;&gt;, &lt;TokenType.DESCRIBE: &#x27;DESCRIBE&#x27;&gt;, &lt;TokenType.MAP: &#x27;MAP&#x27;&gt;, &lt;TokenType.FORMAT: &#x27;FORMAT&#x27;&gt;, &lt;TokenType.CURRENT_TIME: &#x27;CURRENT_TIME&#x27;&gt;, &lt;TokenType.END: &#x27;END&#x27;&gt;, &lt;TokenType.UINT: &#x27;UINT&#x27;&gt;, &lt;TokenType.CHAR: &#x27;CHAR&#x27;&gt;, &lt;TokenType.NULLABLE: &#x27;NULLABLE&#x27;&gt;, &lt;TokenType.ROW: &#x27;ROW&#x27;&gt;, &lt;TokenType.MEDIUMBLOB: &#x27;MEDIUMBLOB&#x27;&gt;, &lt;TokenType.INT8RANGE: &#x27;INT8RANGE&#x27;&gt;, &lt;TokenType.FLOAT: &#x27;FLOAT&#x27;&gt;, &lt;TokenType.XML: &#x27;XML&#x27;&gt;, &lt;TokenType.ORDINALITY: &#x27;ORDINALITY&#x27;&gt;, &lt;TokenType.NESTED: &#x27;NESTED&#x27;&gt;, &lt;TokenType.IPPREFIX: &#x27;IPPREFIX&#x27;&gt;, &lt;TokenType.DECIMAL: &#x27;DECIMAL&#x27;&gt;, &lt;TokenType.DATETIME: &#x27;DATETIME&#x27;&gt;, &lt;TokenType.OBJECT_IDENTIFIER: &#x27;OBJECT_IDENTIFIER&#x27;&gt;, &lt;TokenType.TIMESTAMP_S: &#x27;TIMESTAMP_S&#x27;&gt;, &lt;TokenType.SERIAL: &#x27;SERIAL&#x27;&gt;, &lt;TokenType.TIMESTAMPTZ: &#x27;TIMESTAMPTZ&#x27;&gt;, &lt;TokenType.COLUMN: &#x27;COLUMN&#x27;&gt;, &lt;TokenType.SCHEMA: &#x27;SCHEMA&#x27;&gt;, &lt;TokenType.OBJECT: &#x27;OBJECT&#x27;&gt;, &lt;TokenType.INET: &#x27;INET&#x27;&gt;, &lt;TokenType.FIRST: &#x27;FIRST&#x27;&gt;, &lt;TokenType.JSON: &#x27;JSON&#x27;&gt;, &lt;TokenType.BINARY: &#x27;BINARY&#x27;&gt;, &lt;TokenType.NVARCHAR: &#x27;NVARCHAR&#x27;&gt;, &lt;TokenType.UNIQUE: &#x27;UNIQUE&#x27;&gt;, &lt;TokenType.FALSE: &#x27;FALSE&#x27;&gt;, &lt;TokenType.SMALLINT: &#x27;SMALLINT&#x27;&gt;, &lt;TokenType.KEEP: &#x27;KEEP&#x27;&gt;, &lt;TokenType.GEOMETRY: &#x27;GEOMETRY&#x27;&gt;, &lt;TokenType.TIMESTAMP: &#x27;TIMESTAMP&#x27;&gt;, &lt;TokenType.ARRAY: &#x27;ARRAY&#x27;&gt;, &lt;TokenType.PSEUDO_TYPE: &#x27;PSEUDO_TYPE&#x27;&gt;, &lt;TokenType.MEDIUMTEXT: &#x27;MEDIUMTEXT&#x27;&gt;, &lt;TokenType.USMALLINT: &#x27;USMALLINT&#x27;&gt;, &lt;TokenType.TSTZRANGE: &#x27;TSTZRANGE&#x27;&gt;, &lt;TokenType.RANGE: &#x27;RANGE&#x27;&gt;, &lt;TokenType.TSTZMULTIRANGE: &#x27;TSTZMULTIRANGE&#x27;&gt;, &lt;TokenType.YEAR: &#x27;YEAR&#x27;&gt;, &lt;TokenType.ISNULL: &#x27;ISNULL&#x27;&gt;, &lt;TokenType.UBIGINT: &#x27;UBIGINT&#x27;&gt;, &lt;TokenType.NUMMULTIRANGE: &#x27;NUMMULTIRANGE&#x27;&gt;, &lt;TokenType.INT: &#x27;INT&#x27;&gt;, &lt;TokenType.JSONB: &#x27;JSONB&#x27;&gt;, &lt;TokenType.MODEL: &#x27;MODEL&#x27;&gt;, &lt;TokenType.INTERVAL: &#x27;INTERVAL&#x27;&gt;, &lt;TokenType.BEGIN: &#x27;BEGIN&#x27;&gt;, &lt;TokenType.KILL: &#x27;KILL&#x27;&gt;, &lt;TokenType.ENUM: &#x27;ENUM&#x27;&gt;}"}, "sqlglot.dialects.duckdb.DuckDB.Parser.TOKENIZER_CLASS": {"fullname": "sqlglot.dialects.duckdb.DuckDB.Parser.TOKENIZER_CLASS", "modulename": "sqlglot.dialects.duckdb", "qualname": "DuckDB.Parser.TOKENIZER_CLASS", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Type[sqlglot.tokens.Tokenizer]", "default_value": "&lt;class &#x27;sqlglot.dialects.duckdb.DuckDB.Tokenizer&#x27;&gt;"}, "sqlglot.dialects.duckdb.DuckDB.Parser.SUPPORTS_USER_DEFINED_TYPES": {"fullname": "sqlglot.dialects.duckdb.DuckDB.Parser.SUPPORTS_USER_DEFINED_TYPES", "modulename": "sqlglot.dialects.duckdb", "qualname": "DuckDB.Parser.SUPPORTS_USER_DEFINED_TYPES", "kind": "variable", "doc": "<p></p>\n", "default_value": "False"}, "sqlglot.dialects.duckdb.DuckDB.Parser.NULL_ORDERING": {"fullname": "sqlglot.dialects.duckdb.DuckDB.Parser.NULL_ORDERING", "modulename": "sqlglot.dialects.duckdb", "qualname": "DuckDB.Parser.NULL_ORDERING", "kind": "variable", "doc": "<p></p>\n", "annotation": ": str", "default_value": "&#x27;nulls_are_last&#x27;"}, "sqlglot.dialects.duckdb.DuckDB.Parser.SHOW_TRIE": {"fullname": "sqlglot.dialects.duckdb.DuckDB.Parser.SHOW_TRIE", "modulename": "sqlglot.dialects.duckdb", "qualname": "DuckDB.Parser.SHOW_TRIE", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict", "default_value": "{}"}, "sqlglot.dialects.duckdb.DuckDB.Parser.SET_TRIE": {"fullname": "sqlglot.dialects.duckdb.DuckDB.Parser.SET_TRIE", "modulename": "sqlglot.dialects.duckdb", "qualname": "DuckDB.Parser.SET_TRIE", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict", "default_value": "{&#x27;GLOBAL&#x27;: {0: True}, &#x27;LOCAL&#x27;: {0: True}, &#x27;SESSION&#x27;: {0: True}, &#x27;TRANSACTION&#x27;: {0: True}}"}, "sqlglot.dialects.duckdb.DuckDB.Parser.FORMAT_TRIE": {"fullname": "sqlglot.dialects.duckdb.DuckDB.Parser.FORMAT_TRIE", "modulename": "sqlglot.dialects.duckdb", "qualname": "DuckDB.Parser.FORMAT_TRIE", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict", "default_value": "{}"}, "sqlglot.dialects.duckdb.DuckDB.Parser.TIME_TRIE": {"fullname": "sqlglot.dialects.duckdb.DuckDB.Parser.TIME_TRIE", "modulename": "sqlglot.dialects.duckdb", "qualname": "DuckDB.Parser.TIME_TRIE", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict", "default_value": "{}"}, "sqlglot.dialects.duckdb.DuckDB.Generator": {"fullname": "sqlglot.dialects.duckdb.DuckDB.Generator", "modulename": "sqlglot.dialects.duckdb", "qualname": "DuckDB.Generator", "kind": "class", "doc": "<p>Generator converts a given syntax tree to the corresponding SQL string.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>pretty:</strong>  Whether or not to format the produced SQL string.\nDefault: False.</li>\n<li><strong>identify:</strong>  Determines when an identifier should be quoted. Possible values are:\nFalse (default): Never quote, except in cases where it's mandatory by the dialect.\nTrue or 'always': Always quote.\n'safe': Only quote identifiers that are case insensitive.</li>\n<li><strong>normalize:</strong>  Whether or not to normalize identifiers to lowercase.\nDefault: False.</li>\n<li><strong>pad:</strong>  Determines the pad size in a formatted string.\nDefault: 2.</li>\n<li><strong>indent:</strong>  Determines the indentation size in a formatted string.\nDefault: 2.</li>\n<li><strong>normalize_functions:</strong>  Whether or not to normalize all function names. Possible values are:\n\"upper\" or True (default): Convert names to uppercase.\n\"lower\": Convert names to lowercase.\nFalse: Disables function name normalization.</li>\n<li><strong>unsupported_level:</strong>  Determines the generator's behavior when it encounters unsupported expressions.\nDefault ErrorLevel.WARN.</li>\n<li><strong>max_unsupported:</strong>  Maximum number of unsupported messages to include in a raised UnsupportedError.\nThis is only relevant if unsupported_level is ErrorLevel.RAISE.\nDefault: 3</li>\n<li><strong>leading_comma:</strong>  Determines whether or not the comma is leading or trailing in select expressions.\nThis is only relevant when generating in pretty mode.\nDefault: False</li>\n<li><strong>max_text_width:</strong>  The max number of characters in a segment before creating new lines in pretty mode.\nThe default is on the smaller end because the length only represents a segment and not the true\nline length.\nDefault: 80</li>\n<li><strong>comments:</strong>  Whether or not to preserve comments in the output SQL code.\nDefault: True</li>\n</ul>\n", "bases": "sqlglot.generator.Generator"}, "sqlglot.dialects.duckdb.DuckDB.Generator.JOIN_HINTS": {"fullname": "sqlglot.dialects.duckdb.DuckDB.Generator.JOIN_HINTS", "modulename": "sqlglot.dialects.duckdb", "qualname": "DuckDB.Generator.JOIN_HINTS", "kind": "variable", "doc": "<p></p>\n", "default_value": "False"}, "sqlglot.dialects.duckdb.DuckDB.Generator.TABLE_HINTS": {"fullname": "sqlglot.dialects.duckdb.DuckDB.Generator.TABLE_HINTS", "modulename": "sqlglot.dialects.duckdb", "qualname": "DuckDB.Generator.TABLE_HINTS", "kind": "variable", "doc": "<p></p>\n", "default_value": "False"}, "sqlglot.dialects.duckdb.DuckDB.Generator.QUERY_HINTS": {"fullname": "sqlglot.dialects.duckdb.DuckDB.Generator.QUERY_HINTS", "modulename": "sqlglot.dialects.duckdb", "qualname": "DuckDB.Generator.QUERY_HINTS", "kind": "variable", "doc": "<p></p>\n", "default_value": "False"}, "sqlglot.dialects.duckdb.DuckDB.Generator.LIMIT_FETCH": {"fullname": "sqlglot.dialects.duckdb.DuckDB.Generator.LIMIT_FETCH", "modulename": "sqlglot.dialects.duckdb", "qualname": "DuckDB.Generator.LIMIT_FETCH", "kind": "variable", "doc": "<p></p>\n", "default_value": "&#x27;LIMIT&#x27;"}, "sqlglot.dialects.duckdb.DuckDB.Generator.STRUCT_DELIMITER": {"fullname": "sqlglot.dialects.duckdb.DuckDB.Generator.STRUCT_DELIMITER", "modulename": "sqlglot.dialects.duckdb", "qualname": "DuckDB.Generator.STRUCT_DELIMITER", "kind": "variable", "doc": "<p></p>\n", "default_value": "(&#x27;(&#x27;, &#x27;)&#x27;)"}, "sqlglot.dialects.duckdb.DuckDB.Generator.RENAME_TABLE_WITH_DB": {"fullname": "sqlglot.dialects.duckdb.DuckDB.Generator.RENAME_TABLE_WITH_DB", "modulename": "sqlglot.dialects.duckdb", "qualname": "DuckDB.Generator.RENAME_TABLE_WITH_DB", "kind": "variable", "doc": "<p></p>\n", "default_value": "False"}, "sqlglot.dialects.duckdb.DuckDB.Generator.NVL2_SUPPORTED": {"fullname": "sqlglot.dialects.duckdb.DuckDB.Generator.NVL2_SUPPORTED", "modulename": "sqlglot.dialects.duckdb", "qualname": "DuckDB.Generator.NVL2_SUPPORTED", "kind": "variable", "doc": "<p></p>\n", "default_value": "False"}, "sqlglot.dialects.duckdb.DuckDB.Generator.SEMI_ANTI_JOIN_WITH_SIDE": {"fullname": "sqlglot.dialects.duckdb.DuckDB.Generator.SEMI_ANTI_JOIN_WITH_SIDE", "modulename": "sqlglot.dialects.duckdb", "qualname": "DuckDB.Generator.SEMI_ANTI_JOIN_WITH_SIDE", "kind": "variable", "doc": "<p></p>\n", "default_value": "False"}, "sqlglot.dialects.duckdb.DuckDB.Generator.TRANSFORMS": {"fullname": "sqlglot.dialects.duckdb.DuckDB.Generator.TRANSFORMS", "modulename": "sqlglot.dialects.duckdb", "qualname": "DuckDB.Generator.TRANSFORMS", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&lt;class &#x27;sqlglot.expressions.DateAdd&#x27;&gt;: &lt;function _date_delta_sql&gt;, &lt;class &#x27;sqlglot.expressions.TsOrDsAdd&#x27;&gt;: &lt;function _ts_or_ds_add_sql&gt;, &lt;class &#x27;sqlglot.expressions.CaseSpecificColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.CharacterSetColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.CharacterSetProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.CheckColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.ClusteredColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.CollateColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.CopyGrantsProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.CommentColumnConstraint&#x27;&gt;: &lt;function no_comment_column_constraint_sql&gt;, &lt;class &#x27;sqlglot.expressions.DateFormatColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.DefaultColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.EncodeColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.ExecuteAsProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.ExternalProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.HeapProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.InlineLengthColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.InputModelProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.IntervalSpan&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.LanguageProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.LocationProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.LogProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.MaterializedProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.NoPrimaryIndexProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.NonClusteredColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.NotForReplicationColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.OnCommitProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.OnProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.OnUpdateColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.OutputModelProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.PathColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.RemoteWithConnectionModelProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.ReturnsProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.SampleProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.SetProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.SettingsProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.SqlSecurityProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.StabilityProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.TemporaryProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.ToTableProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.TransientProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.TransformModelProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.TitleColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.UppercaseColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.VarMap&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.VolatileProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.WithJournalTableProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.ApproxDistinct&#x27;&gt;: &lt;function approx_count_distinct_sql&gt;, &lt;class &#x27;sqlglot.expressions.Array&#x27;&gt;: &lt;function DuckDB.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.ArraySize&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.ArraySort&#x27;&gt;: &lt;function _array_sort_sql&gt;, &lt;class &#x27;sqlglot.expressions.ArraySum&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.BitwiseXor&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.CurrentDate&#x27;&gt;: &lt;function DuckDB.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.CurrentTime&#x27;&gt;: &lt;function DuckDB.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.CurrentTimestamp&#x27;&gt;: &lt;function DuckDB.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.DayOfMonth&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.DayOfWeek&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.DayOfYear&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.DataType&#x27;&gt;: &lt;function _datatype_sql&gt;, &lt;class &#x27;sqlglot.expressions.Date&#x27;&gt;: &lt;function _date_sql&gt;, &lt;class &#x27;sqlglot.expressions.DateFromParts&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.DateSub&#x27;&gt;: &lt;function _date_delta_sql&gt;, &lt;class &#x27;sqlglot.expressions.DateDiff&#x27;&gt;: &lt;function DuckDB.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.DateStrToDate&#x27;&gt;: &lt;function datestrtodate_sql&gt;, &lt;class &#x27;sqlglot.expressions.DateToDi&#x27;&gt;: &lt;function DuckDB.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.Decode&#x27;&gt;: &lt;function DuckDB.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.DiToDate&#x27;&gt;: &lt;function DuckDB.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.Encode&#x27;&gt;: &lt;function DuckDB.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.Explode&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.IntDiv&#x27;&gt;: &lt;function DuckDB.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.IsNan&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.JSONExtract&#x27;&gt;: &lt;function arrow_json_extract_sql&gt;, &lt;class &#x27;sqlglot.expressions.JSONExtractScalar&#x27;&gt;: &lt;function arrow_json_extract_scalar_sql&gt;, &lt;class &#x27;sqlglot.expressions.JSONFormat&#x27;&gt;: &lt;function _json_format_sql&gt;, &lt;class &#x27;sqlglot.expressions.JSONBExtract&#x27;&gt;: &lt;function arrow_json_extract_sql&gt;, &lt;class &#x27;sqlglot.expressions.JSONBExtractScalar&#x27;&gt;: &lt;function arrow_json_extract_scalar_sql&gt;, &lt;class &#x27;sqlglot.expressions.LogicalOr&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.LogicalAnd&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.MonthsBetween&#x27;&gt;: &lt;function DuckDB.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.ParseJSON&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.PercentileCont&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.PercentileDisc&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.Properties&#x27;&gt;: &lt;function no_properties_sql&gt;, &lt;class &#x27;sqlglot.expressions.RegexpExtract&#x27;&gt;: &lt;function regexp_extract_sql&gt;, &lt;class &#x27;sqlglot.expressions.RegexpReplace&#x27;&gt;: &lt;function DuckDB.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.RegexpLike&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.RegexpSplit&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.SafeDivide&#x27;&gt;: &lt;function no_safe_divide_sql&gt;, &lt;class &#x27;sqlglot.expressions.Split&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.SortArray&#x27;&gt;: &lt;function _sort_array_sql&gt;, &lt;class &#x27;sqlglot.expressions.StrPosition&#x27;&gt;: &lt;function str_position_sql&gt;, &lt;class &#x27;sqlglot.expressions.StrToDate&#x27;&gt;: &lt;function DuckDB.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.StrToTime&#x27;&gt;: &lt;function str_to_time_sql&gt;, &lt;class &#x27;sqlglot.expressions.StrToUnix&#x27;&gt;: &lt;function DuckDB.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.Struct&#x27;&gt;: &lt;function _struct_sql&gt;, &lt;class &#x27;sqlglot.expressions.Timestamp&#x27;&gt;: &lt;function no_timestamp_sql&gt;, &lt;class &#x27;sqlglot.expressions.TimestampTrunc&#x27;&gt;: &lt;function timestamptrunc_sql&gt;, &lt;class &#x27;sqlglot.expressions.TimeStrToDate&#x27;&gt;: &lt;function DuckDB.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.TimeStrToTime&#x27;&gt;: &lt;function timestrtotime_sql&gt;, &lt;class &#x27;sqlglot.expressions.TimeStrToUnix&#x27;&gt;: &lt;function DuckDB.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.TimeToStr&#x27;&gt;: &lt;function DuckDB.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.TimeToUnix&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.TsOrDiToDi&#x27;&gt;: &lt;function DuckDB.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.TsOrDsToDate&#x27;&gt;: &lt;function ts_or_ds_to_date_sql.&lt;locals&gt;._ts_or_ds_to_date_sql&gt;, &lt;class &#x27;sqlglot.expressions.UnixToStr&#x27;&gt;: &lt;function DuckDB.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.UnixToTime&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.UnixToTimeStr&#x27;&gt;: &lt;function DuckDB.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.VariancePop&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.WeekOfYear&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.Xor&#x27;&gt;: &lt;function bool_xor_sql&gt;}"}, "sqlglot.dialects.duckdb.DuckDB.Generator.TYPE_MAPPING": {"fullname": "sqlglot.dialects.duckdb.DuckDB.Generator.TYPE_MAPPING", "modulename": "sqlglot.dialects.duckdb", "qualname": "DuckDB.Generator.TYPE_MAPPING", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&lt;Type.NCHAR: &#x27;NCHAR&#x27;&gt;: &#x27;TEXT&#x27;, &lt;Type.NVARCHAR: &#x27;NVARCHAR&#x27;&gt;: &#x27;TEXT&#x27;, &lt;Type.MEDIUMTEXT: &#x27;MEDIUMTEXT&#x27;&gt;: &#x27;TEXT&#x27;, &lt;Type.LONGTEXT: &#x27;LONGTEXT&#x27;&gt;: &#x27;TEXT&#x27;, &lt;Type.TINYTEXT: &#x27;TINYTEXT&#x27;&gt;: &#x27;TEXT&#x27;, &lt;Type.MEDIUMBLOB: &#x27;MEDIUMBLOB&#x27;&gt;: &#x27;BLOB&#x27;, &lt;Type.LONGBLOB: &#x27;LONGBLOB&#x27;&gt;: &#x27;BLOB&#x27;, &lt;Type.TINYBLOB: &#x27;TINYBLOB&#x27;&gt;: &#x27;BLOB&#x27;, &lt;Type.INET: &#x27;INET&#x27;&gt;: &#x27;INET&#x27;, &lt;Type.BINARY: &#x27;BINARY&#x27;&gt;: &#x27;BLOB&#x27;, &lt;Type.CHAR: &#x27;CHAR&#x27;&gt;: &#x27;TEXT&#x27;, &lt;Type.FLOAT: &#x27;FLOAT&#x27;&gt;: &#x27;REAL&#x27;, &lt;Type.UINT: &#x27;UINT&#x27;&gt;: &#x27;UINTEGER&#x27;, &lt;Type.VARBINARY: &#x27;VARBINARY&#x27;&gt;: &#x27;BLOB&#x27;, &lt;Type.VARCHAR: &#x27;VARCHAR&#x27;&gt;: &#x27;TEXT&#x27;, &lt;Type.TIMESTAMP_S: &#x27;TIMESTAMP_S&#x27;&gt;: &#x27;TIMESTAMP_S&#x27;, &lt;Type.TIMESTAMP_MS: &#x27;TIMESTAMP_MS&#x27;&gt;: &#x27;TIMESTAMP_MS&#x27;, &lt;Type.TIMESTAMP_NS: &#x27;TIMESTAMP_NS&#x27;&gt;: &#x27;TIMESTAMP_NS&#x27;}"}, "sqlglot.dialects.duckdb.DuckDB.Generator.STAR_MAPPING": {"fullname": "sqlglot.dialects.duckdb.DuckDB.Generator.STAR_MAPPING", "modulename": "sqlglot.dialects.duckdb", "qualname": "DuckDB.Generator.STAR_MAPPING", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;except&#x27;: &#x27;EXCLUDE&#x27;, &#x27;replace&#x27;: &#x27;REPLACE&#x27;}"}, "sqlglot.dialects.duckdb.DuckDB.Generator.UNWRAPPED_INTERVAL_VALUES": {"fullname": "sqlglot.dialects.duckdb.DuckDB.Generator.UNWRAPPED_INTERVAL_VALUES", "modulename": "sqlglot.dialects.duckdb", "qualname": "DuckDB.Generator.UNWRAPPED_INTERVAL_VALUES", "kind": "variable", "doc": "<p></p>\n", "default_value": "(&lt;class &#x27;sqlglot.expressions.Column&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.Literal&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.Paren&#x27;&gt;)"}, "sqlglot.dialects.duckdb.DuckDB.Generator.PROPERTIES_LOCATION": {"fullname": "sqlglot.dialects.duckdb.DuckDB.Generator.PROPERTIES_LOCATION", "modulename": "sqlglot.dialects.duckdb", "qualname": "DuckDB.Generator.PROPERTIES_LOCATION", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&lt;class &#x27;sqlglot.expressions.AlgorithmProperty&#x27;&gt;: &lt;Location.POST_CREATE: &#x27;POST_CREATE&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.AutoIncrementProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.BlockCompressionProperty&#x27;&gt;: &lt;Location.POST_NAME: &#x27;POST_NAME&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.CharacterSetProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.ChecksumProperty&#x27;&gt;: &lt;Location.POST_NAME: &#x27;POST_NAME&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.CollateProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.CopyGrantsProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.Cluster&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.ClusteredByProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.DataBlocksizeProperty&#x27;&gt;: &lt;Location.POST_NAME: &#x27;POST_NAME&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.DefinerProperty&#x27;&gt;: &lt;Location.POST_CREATE: &#x27;POST_CREATE&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.DictRange&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.DictProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.DistKeyProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.DistStyleProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.EngineProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.ExecuteAsProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.ExternalProperty&#x27;&gt;: &lt;Location.POST_CREATE: &#x27;POST_CREATE&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.FallbackProperty&#x27;&gt;: &lt;Location.POST_NAME: &#x27;POST_NAME&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.FileFormatProperty&#x27;&gt;: &lt;Location.POST_WITH: &#x27;POST_WITH&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.FreespaceProperty&#x27;&gt;: &lt;Location.POST_NAME: &#x27;POST_NAME&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.HeapProperty&#x27;&gt;: &lt;Location.POST_WITH: &#x27;POST_WITH&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.InputModelProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.IsolatedLoadingProperty&#x27;&gt;: &lt;Location.POST_NAME: &#x27;POST_NAME&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.JournalProperty&#x27;&gt;: &lt;Location.POST_NAME: &#x27;POST_NAME&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.LanguageProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.LikeProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.LocationProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.LockingProperty&#x27;&gt;: &lt;Location.POST_ALIAS: &#x27;POST_ALIAS&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.LogProperty&#x27;&gt;: &lt;Location.POST_NAME: &#x27;POST_NAME&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.MaterializedProperty&#x27;&gt;: &lt;Location.POST_CREATE: &#x27;POST_CREATE&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.MergeBlockRatioProperty&#x27;&gt;: &lt;Location.POST_NAME: &#x27;POST_NAME&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.NoPrimaryIndexProperty&#x27;&gt;: &lt;Location.POST_EXPRESSION: &#x27;POST_EXPRESSION&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.OnProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.OnCommitProperty&#x27;&gt;: &lt;Location.POST_EXPRESSION: &#x27;POST_EXPRESSION&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.Order&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.OutputModelProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.PartitionedByProperty&#x27;&gt;: &lt;Location.POST_WITH: &#x27;POST_WITH&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.PrimaryKey&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.Property&#x27;&gt;: &lt;Location.POST_WITH: &#x27;POST_WITH&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.RemoteWithConnectionModelProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.ReturnsProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.RowFormatProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.RowFormatDelimitedProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.RowFormatSerdeProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.SampleProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.SchemaCommentProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.SerdeProperties&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.Set&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.SettingsProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.SetProperty&#x27;&gt;: &lt;Location.POST_CREATE: &#x27;POST_CREATE&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.SortKeyProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.SqlSecurityProperty&#x27;&gt;: &lt;Location.POST_CREATE: &#x27;POST_CREATE&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.StabilityProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.TemporaryProperty&#x27;&gt;: &lt;Location.POST_CREATE: &#x27;POST_CREATE&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.ToTableProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.TransientProperty&#x27;&gt;: &lt;Location.POST_CREATE: &#x27;POST_CREATE&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.TransformModelProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.MergeTreeTTL&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.VolatileProperty&#x27;&gt;: &lt;Location.UNSUPPORTED: &#x27;UNSUPPORTED&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.WithDataProperty&#x27;&gt;: &lt;Location.POST_EXPRESSION: &#x27;POST_EXPRESSION&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.WithJournalTableProperty&#x27;&gt;: &lt;Location.POST_NAME: &#x27;POST_NAME&#x27;&gt;}"}, "sqlglot.dialects.duckdb.DuckDB.Generator.interval_sql": {"fullname": "sqlglot.dialects.duckdb.DuckDB.Generator.interval_sql", "modulename": "sqlglot.dialects.duckdb", "qualname": "DuckDB.Generator.interval_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Interval</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.duckdb.DuckDB.Generator.tablesample_sql": {"fullname": "sqlglot.dialects.duckdb.DuckDB.Generator.tablesample_sql", "modulename": "sqlglot.dialects.duckdb", "qualname": "DuckDB.Generator.tablesample_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">TableSample</span>,</span><span class=\"param\">\t<span class=\"n\">seed_prefix</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;SEED&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">sep</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39; AS &#39;</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.duckdb.DuckDB.Generator.SELECT_KINDS": {"fullname": "sqlglot.dialects.duckdb.DuckDB.Generator.SELECT_KINDS", "modulename": "sqlglot.dialects.duckdb", "qualname": "DuckDB.Generator.SELECT_KINDS", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Tuple[str, ...]", "default_value": "()"}, "sqlglot.dialects.duckdb.DuckDB.Generator.INVERSE_TIME_MAPPING": {"fullname": "sqlglot.dialects.duckdb.DuckDB.Generator.INVERSE_TIME_MAPPING", "modulename": "sqlglot.dialects.duckdb", "qualname": "DuckDB.Generator.INVERSE_TIME_MAPPING", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict[str, str]", "default_value": "{}"}, "sqlglot.dialects.duckdb.DuckDB.Generator.INVERSE_TIME_TRIE": {"fullname": "sqlglot.dialects.duckdb.DuckDB.Generator.INVERSE_TIME_TRIE", "modulename": "sqlglot.dialects.duckdb", "qualname": "DuckDB.Generator.INVERSE_TIME_TRIE", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict", "default_value": "{}"}, "sqlglot.dialects.duckdb.DuckDB.Generator.INVERSE_ESCAPE_SEQUENCES": {"fullname": "sqlglot.dialects.duckdb.DuckDB.Generator.INVERSE_ESCAPE_SEQUENCES", "modulename": "sqlglot.dialects.duckdb", "qualname": "DuckDB.Generator.INVERSE_ESCAPE_SEQUENCES", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict[str, str]", "default_value": "{}"}, "sqlglot.dialects.duckdb.DuckDB.Generator.NULL_ORDERING": {"fullname": "sqlglot.dialects.duckdb.DuckDB.Generator.NULL_ORDERING", "modulename": "sqlglot.dialects.duckdb", "qualname": "DuckDB.Generator.NULL_ORDERING", "kind": "variable", "doc": "<p></p>\n", "default_value": "&#x27;nulls_are_last&#x27;"}, "sqlglot.dialects.duckdb.DuckDB.Generator.can_identify": {"fullname": "sqlglot.dialects.duckdb.DuckDB.Generator.can_identify", "modulename": "sqlglot.dialects.duckdb", "qualname": "DuckDB.Generator.can_identify", "kind": "function", "doc": "<p>Checks if text can be identified given an identify option.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>text:</strong>  The text to check.</li>\n<li><strong>identify:</strong>  \"always\" or <code>True</code>: Always returns true.\n\"safe\": True if the identifier is case-insensitive.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>Whether or not the given text can be identified.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">text</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">identify</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;safe&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.duckdb.DuckDB.Generator.QUOTE_START": {"fullname": "sqlglot.dialects.duckdb.DuckDB.Generator.QUOTE_START", "modulename": "sqlglot.dialects.duckdb", "qualname": "DuckDB.Generator.QUOTE_START", "kind": "variable", "doc": "<p></p>\n", "default_value": "&quot;&#x27;&quot;"}, "sqlglot.dialects.duckdb.DuckDB.Generator.QUOTE_END": {"fullname": "sqlglot.dialects.duckdb.DuckDB.Generator.QUOTE_END", "modulename": "sqlglot.dialects.duckdb", "qualname": "DuckDB.Generator.QUOTE_END", "kind": "variable", "doc": "<p></p>\n", "default_value": "&quot;&#x27;&quot;"}, "sqlglot.dialects.duckdb.DuckDB.Generator.IDENTIFIER_START": {"fullname": "sqlglot.dialects.duckdb.DuckDB.Generator.IDENTIFIER_START", "modulename": "sqlglot.dialects.duckdb", "qualname": "DuckDB.Generator.IDENTIFIER_START", "kind": "variable", "doc": "<p></p>\n", "default_value": "&#x27;&quot;&#x27;"}, "sqlglot.dialects.duckdb.DuckDB.Generator.IDENTIFIER_END": {"fullname": "sqlglot.dialects.duckdb.DuckDB.Generator.IDENTIFIER_END", "modulename": "sqlglot.dialects.duckdb", "qualname": "DuckDB.Generator.IDENTIFIER_END", "kind": "variable", "doc": "<p></p>\n", "default_value": "&#x27;&quot;&#x27;"}, "sqlglot.dialects.duckdb.DuckDB.Generator.TOKENIZER_CLASS": {"fullname": "sqlglot.dialects.duckdb.DuckDB.Generator.TOKENIZER_CLASS", "modulename": "sqlglot.dialects.duckdb", "qualname": "DuckDB.Generator.TOKENIZER_CLASS", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;class &#x27;sqlglot.dialects.duckdb.DuckDB.Tokenizer&#x27;&gt;"}, "sqlglot.dialects.duckdb.DuckDB.Generator.BIT_START": {"fullname": "sqlglot.dialects.duckdb.DuckDB.Generator.BIT_START", "modulename": "sqlglot.dialects.duckdb", "qualname": "DuckDB.Generator.BIT_START", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Optional[str]", "default_value": "None"}, "sqlglot.dialects.duckdb.DuckDB.Generator.BIT_END": {"fullname": "sqlglot.dialects.duckdb.DuckDB.Generator.BIT_END", "modulename": "sqlglot.dialects.duckdb", "qualname": "DuckDB.Generator.BIT_END", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Optional[str]", "default_value": "None"}, "sqlglot.dialects.duckdb.DuckDB.Generator.HEX_START": {"fullname": "sqlglot.dialects.duckdb.DuckDB.Generator.HEX_START", "modulename": "sqlglot.dialects.duckdb", "qualname": "DuckDB.Generator.HEX_START", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Optional[str]", "default_value": "None"}, "sqlglot.dialects.duckdb.DuckDB.Generator.HEX_END": {"fullname": "sqlglot.dialects.duckdb.DuckDB.Generator.HEX_END", "modulename": "sqlglot.dialects.duckdb", "qualname": "DuckDB.Generator.HEX_END", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Optional[str]", "default_value": "None"}, "sqlglot.dialects.duckdb.DuckDB.Generator.BYTE_START": {"fullname": "sqlglot.dialects.duckdb.DuckDB.Generator.BYTE_START", "modulename": "sqlglot.dialects.duckdb", "qualname": "DuckDB.Generator.BYTE_START", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Optional[str]", "default_value": "None"}, "sqlglot.dialects.duckdb.DuckDB.Generator.BYTE_END": {"fullname": "sqlglot.dialects.duckdb.DuckDB.Generator.BYTE_END", "modulename": "sqlglot.dialects.duckdb", "qualname": "DuckDB.Generator.BYTE_END", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Optional[str]", "default_value": "None"}, "sqlglot.dialects.duckdb.DuckDB.tokenizer_class": {"fullname": "sqlglot.dialects.duckdb.DuckDB.tokenizer_class", "modulename": "sqlglot.dialects.duckdb", "qualname": "DuckDB.tokenizer_class", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;class &#x27;sqlglot.dialects.duckdb.DuckDB.Tokenizer&#x27;&gt;"}, "sqlglot.dialects.duckdb.DuckDB.parser_class": {"fullname": "sqlglot.dialects.duckdb.DuckDB.parser_class", "modulename": "sqlglot.dialects.duckdb", "qualname": "DuckDB.parser_class", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;class &#x27;sqlglot.dialects.duckdb.DuckDB.Parser&#x27;&gt;"}, "sqlglot.dialects.duckdb.DuckDB.generator_class": {"fullname": "sqlglot.dialects.duckdb.DuckDB.generator_class", "modulename": "sqlglot.dialects.duckdb", "qualname": "DuckDB.generator_class", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;class &#x27;sqlglot.dialects.duckdb.DuckDB.Generator&#x27;&gt;"}, "sqlglot.dialects.duckdb.DuckDB.TIME_TRIE": {"fullname": "sqlglot.dialects.duckdb.DuckDB.TIME_TRIE", "modulename": "sqlglot.dialects.duckdb", "qualname": "DuckDB.TIME_TRIE", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict", "default_value": "{}"}, "sqlglot.dialects.duckdb.DuckDB.FORMAT_TRIE": {"fullname": "sqlglot.dialects.duckdb.DuckDB.FORMAT_TRIE", "modulename": "sqlglot.dialects.duckdb", "qualname": "DuckDB.FORMAT_TRIE", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict", "default_value": "{}"}, "sqlglot.dialects.duckdb.DuckDB.INVERSE_TIME_MAPPING": {"fullname": "sqlglot.dialects.duckdb.DuckDB.INVERSE_TIME_MAPPING", "modulename": "sqlglot.dialects.duckdb", "qualname": "DuckDB.INVERSE_TIME_MAPPING", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict[str, str]", "default_value": "{}"}, "sqlglot.dialects.duckdb.DuckDB.INVERSE_TIME_TRIE": {"fullname": "sqlglot.dialects.duckdb.DuckDB.INVERSE_TIME_TRIE", "modulename": "sqlglot.dialects.duckdb", "qualname": "DuckDB.INVERSE_TIME_TRIE", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict", "default_value": "{}"}, "sqlglot.dialects.duckdb.DuckDB.INVERSE_ESCAPE_SEQUENCES": {"fullname": "sqlglot.dialects.duckdb.DuckDB.INVERSE_ESCAPE_SEQUENCES", "modulename": "sqlglot.dialects.duckdb", "qualname": "DuckDB.INVERSE_ESCAPE_SEQUENCES", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict[str, str]", "default_value": "{}"}, "sqlglot.dialects.duckdb.DuckDB.QUOTE_START": {"fullname": "sqlglot.dialects.duckdb.DuckDB.QUOTE_START", "modulename": "sqlglot.dialects.duckdb", "qualname": "DuckDB.QUOTE_START", "kind": "variable", "doc": "<p></p>\n", "default_value": "&quot;&#x27;&quot;"}, "sqlglot.dialects.duckdb.DuckDB.QUOTE_END": {"fullname": "sqlglot.dialects.duckdb.DuckDB.QUOTE_END", "modulename": "sqlglot.dialects.duckdb", "qualname": "DuckDB.QUOTE_END", "kind": "variable", "doc": "<p></p>\n", "default_value": "&quot;&#x27;&quot;"}, "sqlglot.dialects.duckdb.DuckDB.IDENTIFIER_START": {"fullname": "sqlglot.dialects.duckdb.DuckDB.IDENTIFIER_START", "modulename": "sqlglot.dialects.duckdb", "qualname": "DuckDB.IDENTIFIER_START", "kind": "variable", "doc": "<p></p>\n", "default_value": "&#x27;&quot;&#x27;"}, "sqlglot.dialects.duckdb.DuckDB.IDENTIFIER_END": {"fullname": "sqlglot.dialects.duckdb.DuckDB.IDENTIFIER_END", "modulename": "sqlglot.dialects.duckdb", "qualname": "DuckDB.IDENTIFIER_END", "kind": "variable", "doc": "<p></p>\n", "default_value": "&#x27;&quot;&#x27;"}, "sqlglot.dialects.duckdb.DuckDB.BIT_START": {"fullname": "sqlglot.dialects.duckdb.DuckDB.BIT_START", "modulename": "sqlglot.dialects.duckdb", "qualname": "DuckDB.BIT_START", "kind": "variable", "doc": "<p></p>\n", "default_value": "None"}, "sqlglot.dialects.duckdb.DuckDB.BIT_END": {"fullname": "sqlglot.dialects.duckdb.DuckDB.BIT_END", "modulename": "sqlglot.dialects.duckdb", "qualname": "DuckDB.BIT_END", "kind": "variable", "doc": "<p></p>\n", "default_value": "None"}, "sqlglot.dialects.duckdb.DuckDB.HEX_START": {"fullname": "sqlglot.dialects.duckdb.DuckDB.HEX_START", "modulename": "sqlglot.dialects.duckdb", "qualname": "DuckDB.HEX_START", "kind": "variable", "doc": "<p></p>\n", "default_value": "None"}, "sqlglot.dialects.duckdb.DuckDB.HEX_END": {"fullname": "sqlglot.dialects.duckdb.DuckDB.HEX_END", "modulename": "sqlglot.dialects.duckdb", "qualname": "DuckDB.HEX_END", "kind": "variable", "doc": "<p></p>\n", "default_value": "None"}, "sqlglot.dialects.duckdb.DuckDB.BYTE_START": {"fullname": "sqlglot.dialects.duckdb.DuckDB.BYTE_START", "modulename": "sqlglot.dialects.duckdb", "qualname": "DuckDB.BYTE_START", "kind": "variable", "doc": "<p></p>\n", "default_value": "None"}, "sqlglot.dialects.duckdb.DuckDB.BYTE_END": {"fullname": "sqlglot.dialects.duckdb.DuckDB.BYTE_END", "modulename": "sqlglot.dialects.duckdb", "qualname": "DuckDB.BYTE_END", "kind": "variable", "doc": "<p></p>\n", "default_value": "None"}, "sqlglot.dialects.hive": {"fullname": "sqlglot.dialects.hive", "modulename": "sqlglot.dialects.hive", "kind": "module", "doc": "<p></p>\n"}, "sqlglot.dialects.hive.DATE_DELTA_INTERVAL": {"fullname": "sqlglot.dialects.hive.DATE_DELTA_INTERVAL", "modulename": "sqlglot.dialects.hive", "qualname": "DATE_DELTA_INTERVAL", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;YEAR&#x27;: (&#x27;ADD_MONTHS&#x27;, 12), &#x27;MONTH&#x27;: (&#x27;ADD_MONTHS&#x27;, 1), &#x27;QUARTER&#x27;: (&#x27;ADD_MONTHS&#x27;, 3), &#x27;WEEK&#x27;: (&#x27;DATE_ADD&#x27;, 7), &#x27;DAY&#x27;: (&#x27;DATE_ADD&#x27;, 1)}"}, "sqlglot.dialects.hive.TIME_DIFF_FACTOR": {"fullname": "sqlglot.dialects.hive.TIME_DIFF_FACTOR", "modulename": "sqlglot.dialects.hive", "qualname": "TIME_DIFF_FACTOR", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;MILLISECOND&#x27;: &#x27; * 1000&#x27;, &#x27;SECOND&#x27;: &#x27;&#x27;, &#x27;MINUTE&#x27;: &#x27; / 60&#x27;, &#x27;HOUR&#x27;: &#x27; / 3600&#x27;}"}, "sqlglot.dialects.hive.DIFF_MONTH_SWITCH": {"fullname": "sqlglot.dialects.hive.DIFF_MONTH_SWITCH", "modulename": "sqlglot.dialects.hive", "qualname": "DIFF_MONTH_SWITCH", "kind": "variable", "doc": "<p></p>\n", "default_value": "(&#x27;YEAR&#x27;, &#x27;QUARTER&#x27;, &#x27;MONTH&#x27;)"}, "sqlglot.dialects.hive.Hive": {"fullname": "sqlglot.dialects.hive.Hive", "modulename": "sqlglot.dialects.hive", "qualname": "Hive", "kind": "class", "doc": "<p></p>\n", "bases": "sqlglot.dialects.dialect.Dialect"}, "sqlglot.dialects.hive.Hive.ALIAS_POST_TABLESAMPLE": {"fullname": "sqlglot.dialects.hive.Hive.ALIAS_POST_TABLESAMPLE", "modulename": "sqlglot.dialects.hive", "qualname": "Hive.ALIAS_POST_TABLESAMPLE", "kind": "variable", "doc": "<p></p>\n", "default_value": "True"}, "sqlglot.dialects.hive.Hive.IDENTIFIERS_CAN_START_WITH_DIGIT": {"fullname": "sqlglot.dialects.hive.Hive.IDENTIFIERS_CAN_START_WITH_DIGIT", "modulename": "sqlglot.dialects.hive", "qualname": "Hive.IDENTIFIERS_CAN_START_WITH_DIGIT", "kind": "variable", "doc": "<p></p>\n", "default_value": "True"}, "sqlglot.dialects.hive.Hive.SUPPORTS_USER_DEFINED_TYPES": {"fullname": "sqlglot.dialects.hive.Hive.SUPPORTS_USER_DEFINED_TYPES", "modulename": "sqlglot.dialects.hive", "qualname": "Hive.SUPPORTS_USER_DEFINED_TYPES", "kind": "variable", "doc": "<p></p>\n", "default_value": "False"}, "sqlglot.dialects.hive.Hive.RESOLVES_IDENTIFIERS_AS_UPPERCASE": {"fullname": "sqlglot.dialects.hive.Hive.RESOLVES_IDENTIFIERS_AS_UPPERCASE", "modulename": "sqlglot.dialects.hive", "qualname": "Hive.RESOLVES_IDENTIFIERS_AS_UPPERCASE", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Optional[bool]", "default_value": "None"}, "sqlglot.dialects.hive.Hive.TIME_MAPPING": {"fullname": "sqlglot.dialects.hive.Hive.TIME_MAPPING", "modulename": "sqlglot.dialects.hive", "qualname": "Hive.TIME_MAPPING", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict[str, str]", "default_value": "{&#x27;y&#x27;: &#x27;%Y&#x27;, &#x27;Y&#x27;: &#x27;%Y&#x27;, &#x27;YYYY&#x27;: &#x27;%Y&#x27;, &#x27;yyyy&#x27;: &#x27;%Y&#x27;, &#x27;YY&#x27;: &#x27;%y&#x27;, &#x27;yy&#x27;: &#x27;%y&#x27;, &#x27;MMMM&#x27;: &#x27;%B&#x27;, &#x27;MMM&#x27;: &#x27;%b&#x27;, &#x27;MM&#x27;: &#x27;%m&#x27;, &#x27;M&#x27;: &#x27;%-m&#x27;, &#x27;dd&#x27;: &#x27;%d&#x27;, &#x27;d&#x27;: &#x27;%-d&#x27;, &#x27;HH&#x27;: &#x27;%H&#x27;, &#x27;H&#x27;: &#x27;%-H&#x27;, &#x27;hh&#x27;: &#x27;%I&#x27;, &#x27;h&#x27;: &#x27;%-I&#x27;, &#x27;mm&#x27;: &#x27;%M&#x27;, &#x27;m&#x27;: &#x27;%-M&#x27;, &#x27;ss&#x27;: &#x27;%S&#x27;, &#x27;s&#x27;: &#x27;%-S&#x27;, &#x27;SSSSSS&#x27;: &#x27;%f&#x27;, &#x27;a&#x27;: &#x27;%p&#x27;, &#x27;DD&#x27;: &#x27;%j&#x27;, &#x27;D&#x27;: &#x27;%-j&#x27;, &#x27;E&#x27;: &#x27;%a&#x27;, &#x27;EE&#x27;: &#x27;%a&#x27;, &#x27;EEE&#x27;: &#x27;%a&#x27;, &#x27;EEEE&#x27;: &#x27;%A&#x27;}"}, "sqlglot.dialects.hive.Hive.DATE_FORMAT": {"fullname": "sqlglot.dialects.hive.Hive.DATE_FORMAT", "modulename": "sqlglot.dialects.hive", "qualname": "Hive.DATE_FORMAT", "kind": "variable", "doc": "<p></p>\n", "default_value": "&quot;&#x27;yyyy-MM-dd&#x27;&quot;"}, "sqlglot.dialects.hive.Hive.DATEINT_FORMAT": {"fullname": "sqlglot.dialects.hive.Hive.DATEINT_FORMAT", "modulename": "sqlglot.dialects.hive", "qualname": "Hive.DATEINT_FORMAT", "kind": "variable", "doc": "<p></p>\n", "default_value": "&quot;&#x27;yyyyMMdd&#x27;&quot;"}, "sqlglot.dialects.hive.Hive.TIME_FORMAT": {"fullname": "sqlglot.dialects.hive.Hive.TIME_FORMAT", "modulename": "sqlglot.dialects.hive", "qualname": "Hive.TIME_FORMAT", "kind": "variable", "doc": "<p></p>\n", "default_value": "&quot;&#x27;yyyy-MM-dd HH:mm:ss&#x27;&quot;"}, "sqlglot.dialects.hive.Hive.Tokenizer": {"fullname": "sqlglot.dialects.hive.Hive.Tokenizer", "modulename": "sqlglot.dialects.hive", "qualname": "Hive.Tokenizer", "kind": "class", "doc": "<p></p>\n", "bases": "sqlglot.tokens.Tokenizer"}, "sqlglot.dialects.hive.Hive.Tokenizer.QUOTES": {"fullname": "sqlglot.dialects.hive.Hive.Tokenizer.QUOTES", "modulename": "sqlglot.dialects.hive", "qualname": "Hive.Tokenizer.QUOTES", "kind": "variable", "doc": "<p></p>\n", "default_value": "[&quot;&#x27;&quot;, &#x27;&quot;&#x27;]"}, "sqlglot.dialects.hive.Hive.Tokenizer.IDENTIFIERS": {"fullname": "sqlglot.dialects.hive.Hive.Tokenizer.IDENTIFIERS", "modulename": "sqlglot.dialects.hive", "qualname": "Hive.Tokenizer.IDENTIFIERS", "kind": "variable", "doc": "<p></p>\n", "default_value": "[&#x27;`&#x27;]"}, "sqlglot.dialects.hive.Hive.Tokenizer.STRING_ESCAPES": {"fullname": "sqlglot.dialects.hive.Hive.Tokenizer.STRING_ESCAPES", "modulename": "sqlglot.dialects.hive", "qualname": "Hive.Tokenizer.STRING_ESCAPES", "kind": "variable", "doc": "<p></p>\n", "default_value": "[&#x27;\\\\&#x27;]"}, "sqlglot.dialects.hive.Hive.Tokenizer.ENCODE": {"fullname": "sqlglot.dialects.hive.Hive.Tokenizer.ENCODE", "modulename": "sqlglot.dialects.hive", "qualname": "Hive.Tokenizer.ENCODE", "kind": "variable", "doc": "<p></p>\n", "default_value": "&#x27;utf-8&#x27;"}, "sqlglot.dialects.hive.Hive.Tokenizer.KEYWORDS": {"fullname": "sqlglot.dialects.hive.Hive.Tokenizer.KEYWORDS", "modulename": "sqlglot.dialects.hive", "qualname": "Hive.Tokenizer.KEYWORDS", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;{%&#x27;: &lt;TokenType.BLOCK_START: &#x27;BLOCK_START&#x27;&gt;, &#x27;{%+&#x27;: &lt;TokenType.BLOCK_START: &#x27;BLOCK_START&#x27;&gt;, &#x27;{%-&#x27;: &lt;TokenType.BLOCK_START: &#x27;BLOCK_START&#x27;&gt;, &#x27;%}&#x27;: &lt;TokenType.BLOCK_END: &#x27;BLOCK_END&#x27;&gt;, &#x27;+%}&#x27;: &lt;TokenType.BLOCK_END: &#x27;BLOCK_END&#x27;&gt;, &#x27;-%}&#x27;: &lt;TokenType.BLOCK_END: &#x27;BLOCK_END&#x27;&gt;, &#x27;{{+&#x27;: &lt;TokenType.BLOCK_START: &#x27;BLOCK_START&#x27;&gt;, &#x27;{{-&#x27;: &lt;TokenType.BLOCK_START: &#x27;BLOCK_START&#x27;&gt;, &#x27;+}}&#x27;: &lt;TokenType.BLOCK_END: &#x27;BLOCK_END&#x27;&gt;, &#x27;-}}&#x27;: &lt;TokenType.BLOCK_END: &#x27;BLOCK_END&#x27;&gt;, &#x27;/*+&#x27;: &lt;TokenType.HINT: &#x27;HINT&#x27;&gt;, &#x27;==&#x27;: &lt;TokenType.EQ: &#x27;EQ&#x27;&gt;, &#x27;::&#x27;: &lt;TokenType.DCOLON: &#x27;DCOLON&#x27;&gt;, &#x27;||&#x27;: &lt;TokenType.DPIPE: &#x27;DPIPE&#x27;&gt;, &#x27;&gt;=&#x27;: &lt;TokenType.GTE: &#x27;GTE&#x27;&gt;, &#x27;&lt;=&#x27;: &lt;TokenType.LTE: &#x27;LTE&#x27;&gt;, &#x27;&lt;&gt;&#x27;: &lt;TokenType.NEQ: &#x27;NEQ&#x27;&gt;, &#x27;!=&#x27;: &lt;TokenType.NEQ: &#x27;NEQ&#x27;&gt;, &#x27;&lt;=&gt;&#x27;: &lt;TokenType.NULLSAFE_EQ: &#x27;NULLSAFE_EQ&#x27;&gt;, &#x27;-&gt;&#x27;: &lt;TokenType.ARROW: &#x27;ARROW&#x27;&gt;, &#x27;-&gt;&gt;&#x27;: &lt;TokenType.DARROW: &#x27;DARROW&#x27;&gt;, &#x27;=&gt;&#x27;: &lt;TokenType.FARROW: &#x27;FARROW&#x27;&gt;, &#x27;#&gt;&#x27;: &lt;TokenType.HASH_ARROW: &#x27;HASH_ARROW&#x27;&gt;, &#x27;#&gt;&gt;&#x27;: &lt;TokenType.DHASH_ARROW: &#x27;DHASH_ARROW&#x27;&gt;, &#x27;&lt;-&gt;&#x27;: &lt;TokenType.LR_ARROW: &#x27;LR_ARROW&#x27;&gt;, &#x27;&amp;&amp;&#x27;: &lt;TokenType.DAMP: &#x27;DAMP&#x27;&gt;, &#x27;??&#x27;: &lt;TokenType.DQMARK: &#x27;DQMARK&#x27;&gt;, &#x27;ALL&#x27;: &lt;TokenType.ALL: &#x27;ALL&#x27;&gt;, &#x27;ALWAYS&#x27;: &lt;TokenType.ALWAYS: &#x27;ALWAYS&#x27;&gt;, &#x27;AND&#x27;: &lt;TokenType.AND: &#x27;AND&#x27;&gt;, &#x27;ANTI&#x27;: &lt;TokenType.ANTI: &#x27;ANTI&#x27;&gt;, &#x27;ANY&#x27;: &lt;TokenType.ANY: &#x27;ANY&#x27;&gt;, &#x27;ASC&#x27;: &lt;TokenType.ASC: &#x27;ASC&#x27;&gt;, &#x27;AS&#x27;: &lt;TokenType.ALIAS: &#x27;ALIAS&#x27;&gt;, &#x27;ASOF&#x27;: &lt;TokenType.ASOF: &#x27;ASOF&#x27;&gt;, &#x27;AUTOINCREMENT&#x27;: &lt;TokenType.AUTO_INCREMENT: &#x27;AUTO_INCREMENT&#x27;&gt;, &#x27;AUTO_INCREMENT&#x27;: &lt;TokenType.AUTO_INCREMENT: &#x27;AUTO_INCREMENT&#x27;&gt;, &#x27;BEGIN&#x27;: &lt;TokenType.BEGIN: &#x27;BEGIN&#x27;&gt;, &#x27;BETWEEN&#x27;: &lt;TokenType.BETWEEN: &#x27;BETWEEN&#x27;&gt;, &#x27;CACHE&#x27;: &lt;TokenType.CACHE: &#x27;CACHE&#x27;&gt;, &#x27;UNCACHE&#x27;: &lt;TokenType.UNCACHE: &#x27;UNCACHE&#x27;&gt;, &#x27;CASE&#x27;: &lt;TokenType.CASE: &#x27;CASE&#x27;&gt;, &#x27;CHARACTER SET&#x27;: &lt;TokenType.CHARACTER_SET: &#x27;CHARACTER_SET&#x27;&gt;, &#x27;CLUSTER BY&#x27;: &lt;TokenType.CLUSTER_BY: &#x27;CLUSTER_BY&#x27;&gt;, &#x27;COLLATE&#x27;: &lt;TokenType.COLLATE: &#x27;COLLATE&#x27;&gt;, &#x27;COLUMN&#x27;: &lt;TokenType.COLUMN: &#x27;COLUMN&#x27;&gt;, &#x27;COMMIT&#x27;: &lt;TokenType.COMMIT: &#x27;COMMIT&#x27;&gt;, &#x27;CONNECT BY&#x27;: &lt;TokenType.CONNECT_BY: &#x27;CONNECT_BY&#x27;&gt;, &#x27;CONSTRAINT&#x27;: &lt;TokenType.CONSTRAINT: &#x27;CONSTRAINT&#x27;&gt;, &#x27;CREATE&#x27;: &lt;TokenType.CREATE: &#x27;CREATE&#x27;&gt;, &#x27;CROSS&#x27;: &lt;TokenType.CROSS: &#x27;CROSS&#x27;&gt;, &#x27;CUBE&#x27;: &lt;TokenType.CUBE: &#x27;CUBE&#x27;&gt;, &#x27;CURRENT_DATE&#x27;: &lt;TokenType.CURRENT_DATE: &#x27;CURRENT_DATE&#x27;&gt;, &#x27;CURRENT_TIME&#x27;: &lt;TokenType.CURRENT_TIME: &#x27;CURRENT_TIME&#x27;&gt;, &#x27;CURRENT_TIMESTAMP&#x27;: &lt;TokenType.CURRENT_TIMESTAMP: &#x27;CURRENT_TIMESTAMP&#x27;&gt;, &#x27;CURRENT_USER&#x27;: &lt;TokenType.CURRENT_USER: &#x27;CURRENT_USER&#x27;&gt;, &#x27;DATABASE&#x27;: &lt;TokenType.DATABASE: &#x27;DATABASE&#x27;&gt;, &#x27;DEFAULT&#x27;: &lt;TokenType.DEFAULT: &#x27;DEFAULT&#x27;&gt;, &#x27;DELETE&#x27;: &lt;TokenType.DELETE: &#x27;DELETE&#x27;&gt;, &#x27;DESC&#x27;: &lt;TokenType.DESC: &#x27;DESC&#x27;&gt;, &#x27;DESCRIBE&#x27;: &lt;TokenType.DESCRIBE: &#x27;DESCRIBE&#x27;&gt;, &#x27;DISTINCT&#x27;: &lt;TokenType.DISTINCT: &#x27;DISTINCT&#x27;&gt;, &#x27;DISTRIBUTE BY&#x27;: &lt;TokenType.DISTRIBUTE_BY: &#x27;DISTRIBUTE_BY&#x27;&gt;, &#x27;DIV&#x27;: &lt;TokenType.DIV: &#x27;DIV&#x27;&gt;, &#x27;DROP&#x27;: &lt;TokenType.DROP: &#x27;DROP&#x27;&gt;, &#x27;ELSE&#x27;: &lt;TokenType.ELSE: &#x27;ELSE&#x27;&gt;, &#x27;END&#x27;: &lt;TokenType.END: &#x27;END&#x27;&gt;, &#x27;ESCAPE&#x27;: &lt;TokenType.ESCAPE: &#x27;ESCAPE&#x27;&gt;, &#x27;EXCEPT&#x27;: &lt;TokenType.EXCEPT: &#x27;EXCEPT&#x27;&gt;, &#x27;EXECUTE&#x27;: &lt;TokenType.EXECUTE: &#x27;EXECUTE&#x27;&gt;, &#x27;EXISTS&#x27;: &lt;TokenType.EXISTS: &#x27;EXISTS&#x27;&gt;, &#x27;FALSE&#x27;: &lt;TokenType.FALSE: &#x27;FALSE&#x27;&gt;, &#x27;FETCH&#x27;: &lt;TokenType.FETCH: &#x27;FETCH&#x27;&gt;, &#x27;FILTER&#x27;: &lt;TokenType.FILTER: &#x27;FILTER&#x27;&gt;, &#x27;FIRST&#x27;: &lt;TokenType.FIRST: &#x27;FIRST&#x27;&gt;, &#x27;FULL&#x27;: &lt;TokenType.FULL: &#x27;FULL&#x27;&gt;, &#x27;FUNCTION&#x27;: &lt;TokenType.FUNCTION: &#x27;FUNCTION&#x27;&gt;, &#x27;FOR&#x27;: &lt;TokenType.FOR: &#x27;FOR&#x27;&gt;, &#x27;FOREIGN KEY&#x27;: &lt;TokenType.FOREIGN_KEY: &#x27;FOREIGN_KEY&#x27;&gt;, &#x27;FORMAT&#x27;: &lt;TokenType.FORMAT: &#x27;FORMAT&#x27;&gt;, &#x27;FROM&#x27;: &lt;TokenType.FROM: &#x27;FROM&#x27;&gt;, &#x27;GEOGRAPHY&#x27;: &lt;TokenType.GEOGRAPHY: &#x27;GEOGRAPHY&#x27;&gt;, &#x27;GEOMETRY&#x27;: &lt;TokenType.GEOMETRY: &#x27;GEOMETRY&#x27;&gt;, &#x27;GLOB&#x27;: &lt;TokenType.GLOB: &#x27;GLOB&#x27;&gt;, &#x27;GROUP BY&#x27;: &lt;TokenType.GROUP_BY: &#x27;GROUP_BY&#x27;&gt;, &#x27;GROUPING SETS&#x27;: &lt;TokenType.GROUPING_SETS: &#x27;GROUPING_SETS&#x27;&gt;, &#x27;HAVING&#x27;: &lt;TokenType.HAVING: &#x27;HAVING&#x27;&gt;, &#x27;ILIKE&#x27;: &lt;TokenType.ILIKE: &#x27;ILIKE&#x27;&gt;, &#x27;IN&#x27;: &lt;TokenType.IN: &#x27;IN&#x27;&gt;, &#x27;INDEX&#x27;: &lt;TokenType.INDEX: &#x27;INDEX&#x27;&gt;, &#x27;INET&#x27;: &lt;TokenType.INET: &#x27;INET&#x27;&gt;, &#x27;INNER&#x27;: &lt;TokenType.INNER: &#x27;INNER&#x27;&gt;, &#x27;INSERT&#x27;: &lt;TokenType.INSERT: &#x27;INSERT&#x27;&gt;, &#x27;INTERVAL&#x27;: &lt;TokenType.INTERVAL: &#x27;INTERVAL&#x27;&gt;, &#x27;INTERSECT&#x27;: &lt;TokenType.INTERSECT: &#x27;INTERSECT&#x27;&gt;, &#x27;INTO&#x27;: &lt;TokenType.INTO: &#x27;INTO&#x27;&gt;, &#x27;IS&#x27;: &lt;TokenType.IS: &#x27;IS&#x27;&gt;, &#x27;ISNULL&#x27;: &lt;TokenType.ISNULL: &#x27;ISNULL&#x27;&gt;, &#x27;JOIN&#x27;: &lt;TokenType.JOIN: &#x27;JOIN&#x27;&gt;, &#x27;KEEP&#x27;: &lt;TokenType.KEEP: &#x27;KEEP&#x27;&gt;, &#x27;KILL&#x27;: &lt;TokenType.KILL: &#x27;KILL&#x27;&gt;, &#x27;LATERAL&#x27;: &lt;TokenType.LATERAL: &#x27;LATERAL&#x27;&gt;, &#x27;LEFT&#x27;: &lt;TokenType.LEFT: &#x27;LEFT&#x27;&gt;, &#x27;LIKE&#x27;: &lt;TokenType.LIKE: &#x27;LIKE&#x27;&gt;, &#x27;LIMIT&#x27;: &lt;TokenType.LIMIT: &#x27;LIMIT&#x27;&gt;, &#x27;LOAD&#x27;: &lt;TokenType.LOAD: &#x27;LOAD&#x27;&gt;, &#x27;LOCK&#x27;: &lt;TokenType.LOCK: &#x27;LOCK&#x27;&gt;, &#x27;MERGE&#x27;: &lt;TokenType.MERGE: &#x27;MERGE&#x27;&gt;, &#x27;NATURAL&#x27;: &lt;TokenType.NATURAL: &#x27;NATURAL&#x27;&gt;, &#x27;NEXT&#x27;: &lt;TokenType.NEXT: &#x27;NEXT&#x27;&gt;, &#x27;NOT&#x27;: &lt;TokenType.NOT: &#x27;NOT&#x27;&gt;, &#x27;NOTNULL&#x27;: &lt;TokenType.NOTNULL: &#x27;NOTNULL&#x27;&gt;, &#x27;NULL&#x27;: &lt;TokenType.NULL: &#x27;NULL&#x27;&gt;, &#x27;OBJECT&#x27;: &lt;TokenType.OBJECT: &#x27;OBJECT&#x27;&gt;, &#x27;OFFSET&#x27;: &lt;TokenType.OFFSET: &#x27;OFFSET&#x27;&gt;, &#x27;ON&#x27;: &lt;TokenType.ON: &#x27;ON&#x27;&gt;, &#x27;OR&#x27;: &lt;TokenType.OR: &#x27;OR&#x27;&gt;, &#x27;XOR&#x27;: &lt;TokenType.XOR: &#x27;XOR&#x27;&gt;, &#x27;ORDER BY&#x27;: &lt;TokenType.ORDER_BY: &#x27;ORDER_BY&#x27;&gt;, &#x27;ORDINALITY&#x27;: &lt;TokenType.ORDINALITY: &#x27;ORDINALITY&#x27;&gt;, &#x27;OUTER&#x27;: &lt;TokenType.OUTER: &#x27;OUTER&#x27;&gt;, &#x27;OVER&#x27;: &lt;TokenType.OVER: &#x27;OVER&#x27;&gt;, &#x27;OVERLAPS&#x27;: &lt;TokenType.OVERLAPS: &#x27;OVERLAPS&#x27;&gt;, &#x27;OVERWRITE&#x27;: &lt;TokenType.OVERWRITE: &#x27;OVERWRITE&#x27;&gt;, &#x27;PARTITION&#x27;: &lt;TokenType.PARTITION: &#x27;PARTITION&#x27;&gt;, &#x27;PARTITION BY&#x27;: &lt;TokenType.PARTITION_BY: &#x27;PARTITION_BY&#x27;&gt;, &#x27;PARTITIONED BY&#x27;: &lt;TokenType.PARTITION_BY: &#x27;PARTITION_BY&#x27;&gt;, &#x27;PARTITIONED_BY&#x27;: &lt;TokenType.PARTITION_BY: &#x27;PARTITION_BY&#x27;&gt;, &#x27;PERCENT&#x27;: &lt;TokenType.PERCENT: &#x27;PERCENT&#x27;&gt;, &#x27;PIVOT&#x27;: &lt;TokenType.PIVOT: &#x27;PIVOT&#x27;&gt;, &#x27;PRAGMA&#x27;: &lt;TokenType.PRAGMA: &#x27;PRAGMA&#x27;&gt;, &#x27;PRIMARY KEY&#x27;: &lt;TokenType.PRIMARY_KEY: &#x27;PRIMARY_KEY&#x27;&gt;, &#x27;PROCEDURE&#x27;: &lt;TokenType.PROCEDURE: &#x27;PROCEDURE&#x27;&gt;, &#x27;QUALIFY&#x27;: &lt;TokenType.QUALIFY: &#x27;QUALIFY&#x27;&gt;, &#x27;RANGE&#x27;: &lt;TokenType.RANGE: &#x27;RANGE&#x27;&gt;, &#x27;RECURSIVE&#x27;: &lt;TokenType.RECURSIVE: &#x27;RECURSIVE&#x27;&gt;, &#x27;REGEXP&#x27;: &lt;TokenType.RLIKE: &#x27;RLIKE&#x27;&gt;, &#x27;REPLACE&#x27;: &lt;TokenType.REPLACE: &#x27;REPLACE&#x27;&gt;, &#x27;RETURNING&#x27;: &lt;TokenType.RETURNING: &#x27;RETURNING&#x27;&gt;, &#x27;REFERENCES&#x27;: &lt;TokenType.REFERENCES: &#x27;REFERENCES&#x27;&gt;, &#x27;RIGHT&#x27;: &lt;TokenType.RIGHT: &#x27;RIGHT&#x27;&gt;, &#x27;RLIKE&#x27;: &lt;TokenType.RLIKE: &#x27;RLIKE&#x27;&gt;, &#x27;ROLLBACK&#x27;: &lt;TokenType.ROLLBACK: &#x27;ROLLBACK&#x27;&gt;, &#x27;ROLLUP&#x27;: &lt;TokenType.ROLLUP: &#x27;ROLLUP&#x27;&gt;, &#x27;ROW&#x27;: &lt;TokenType.ROW: &#x27;ROW&#x27;&gt;, &#x27;ROWS&#x27;: &lt;TokenType.ROWS: &#x27;ROWS&#x27;&gt;, &#x27;SCHEMA&#x27;: &lt;TokenType.SCHEMA: &#x27;SCHEMA&#x27;&gt;, &#x27;SELECT&#x27;: &lt;TokenType.SELECT: &#x27;SELECT&#x27;&gt;, &#x27;SEMI&#x27;: &lt;TokenType.SEMI: &#x27;SEMI&#x27;&gt;, &#x27;SET&#x27;: &lt;TokenType.SET: &#x27;SET&#x27;&gt;, &#x27;SETTINGS&#x27;: &lt;TokenType.SETTINGS: &#x27;SETTINGS&#x27;&gt;, &#x27;SHOW&#x27;: &lt;TokenType.SHOW: &#x27;SHOW&#x27;&gt;, &#x27;SIMILAR TO&#x27;: &lt;TokenType.SIMILAR_TO: &#x27;SIMILAR_TO&#x27;&gt;, &#x27;SOME&#x27;: &lt;TokenType.SOME: &#x27;SOME&#x27;&gt;, &#x27;SORT BY&#x27;: &lt;TokenType.SORT_BY: &#x27;SORT_BY&#x27;&gt;, &#x27;START WITH&#x27;: &lt;TokenType.START_WITH: &#x27;START_WITH&#x27;&gt;, &#x27;TABLE&#x27;: &lt;TokenType.TABLE: &#x27;TABLE&#x27;&gt;, &#x27;TABLESAMPLE&#x27;: &lt;TokenType.TABLE_SAMPLE: &#x27;TABLE_SAMPLE&#x27;&gt;, &#x27;TEMP&#x27;: &lt;TokenType.TEMPORARY: &#x27;TEMPORARY&#x27;&gt;, &#x27;TEMPORARY&#x27;: &lt;TokenType.TEMPORARY: &#x27;TEMPORARY&#x27;&gt;, &#x27;THEN&#x27;: &lt;TokenType.THEN: &#x27;THEN&#x27;&gt;, &#x27;TRUE&#x27;: &lt;TokenType.TRUE: &#x27;TRUE&#x27;&gt;, &#x27;UNION&#x27;: &lt;TokenType.UNION: &#x27;UNION&#x27;&gt;, &#x27;UNKNOWN&#x27;: &lt;TokenType.UNKNOWN: &#x27;UNKNOWN&#x27;&gt;, &#x27;UNNEST&#x27;: &lt;TokenType.UNNEST: &#x27;UNNEST&#x27;&gt;, &#x27;UNPIVOT&#x27;: &lt;TokenType.UNPIVOT: &#x27;UNPIVOT&#x27;&gt;, &#x27;UPDATE&#x27;: &lt;TokenType.UPDATE: &#x27;UPDATE&#x27;&gt;, &#x27;USE&#x27;: &lt;TokenType.USE: &#x27;USE&#x27;&gt;, &#x27;USING&#x27;: &lt;TokenType.USING: &#x27;USING&#x27;&gt;, &#x27;UUID&#x27;: &lt;TokenType.UUID: &#x27;UUID&#x27;&gt;, &#x27;VALUES&#x27;: &lt;TokenType.VALUES: &#x27;VALUES&#x27;&gt;, &#x27;VIEW&#x27;: &lt;TokenType.VIEW: &#x27;VIEW&#x27;&gt;, &#x27;VOLATILE&#x27;: &lt;TokenType.VOLATILE: &#x27;VOLATILE&#x27;&gt;, &#x27;WHEN&#x27;: &lt;TokenType.WHEN: &#x27;WHEN&#x27;&gt;, &#x27;WHERE&#x27;: &lt;TokenType.WHERE: &#x27;WHERE&#x27;&gt;, &#x27;WINDOW&#x27;: &lt;TokenType.WINDOW: &#x27;WINDOW&#x27;&gt;, &#x27;WITH&#x27;: &lt;TokenType.WITH: &#x27;WITH&#x27;&gt;, &#x27;APPLY&#x27;: &lt;TokenType.APPLY: &#x27;APPLY&#x27;&gt;, &#x27;ARRAY&#x27;: &lt;TokenType.ARRAY: &#x27;ARRAY&#x27;&gt;, &#x27;BIT&#x27;: &lt;TokenType.BIT: &#x27;BIT&#x27;&gt;, &#x27;BOOL&#x27;: &lt;TokenType.BOOLEAN: &#x27;BOOLEAN&#x27;&gt;, &#x27;BOOLEAN&#x27;: &lt;TokenType.BOOLEAN: &#x27;BOOLEAN&#x27;&gt;, &#x27;BYTE&#x27;: &lt;TokenType.TINYINT: &#x27;TINYINT&#x27;&gt;, &#x27;MEDIUMINT&#x27;: &lt;TokenType.MEDIUMINT: &#x27;MEDIUMINT&#x27;&gt;, &#x27;TINYINT&#x27;: &lt;TokenType.TINYINT: &#x27;TINYINT&#x27;&gt;, &#x27;SHORT&#x27;: &lt;TokenType.SMALLINT: &#x27;SMALLINT&#x27;&gt;, &#x27;SMALLINT&#x27;: &lt;TokenType.SMALLINT: &#x27;SMALLINT&#x27;&gt;, &#x27;INT128&#x27;: &lt;TokenType.INT128: &#x27;INT128&#x27;&gt;, &#x27;INT2&#x27;: &lt;TokenType.SMALLINT: &#x27;SMALLINT&#x27;&gt;, &#x27;INTEGER&#x27;: &lt;TokenType.INT: &#x27;INT&#x27;&gt;, &#x27;INT&#x27;: &lt;TokenType.INT: &#x27;INT&#x27;&gt;, &#x27;INT4&#x27;: &lt;TokenType.INT: &#x27;INT&#x27;&gt;, &#x27;LONG&#x27;: &lt;TokenType.BIGINT: &#x27;BIGINT&#x27;&gt;, &#x27;BIGINT&#x27;: &lt;TokenType.BIGINT: &#x27;BIGINT&#x27;&gt;, &#x27;INT8&#x27;: &lt;TokenType.BIGINT: &#x27;BIGINT&#x27;&gt;, &#x27;DEC&#x27;: &lt;TokenType.DECIMAL: &#x27;DECIMAL&#x27;&gt;, &#x27;DECIMAL&#x27;: &lt;TokenType.DECIMAL: &#x27;DECIMAL&#x27;&gt;, &#x27;BIGDECIMAL&#x27;: &lt;TokenType.BIGDECIMAL: &#x27;BIGDECIMAL&#x27;&gt;, &#x27;BIGNUMERIC&#x27;: &lt;TokenType.BIGDECIMAL: &#x27;BIGDECIMAL&#x27;&gt;, &#x27;MAP&#x27;: &lt;TokenType.MAP: &#x27;MAP&#x27;&gt;, &#x27;NULLABLE&#x27;: &lt;TokenType.NULLABLE: &#x27;NULLABLE&#x27;&gt;, &#x27;NUMBER&#x27;: &lt;TokenType.DECIMAL: &#x27;DECIMAL&#x27;&gt;, &#x27;NUMERIC&#x27;: &lt;TokenType.DECIMAL: &#x27;DECIMAL&#x27;&gt;, &#x27;FIXED&#x27;: &lt;TokenType.DECIMAL: &#x27;DECIMAL&#x27;&gt;, &#x27;REAL&#x27;: &lt;TokenType.FLOAT: &#x27;FLOAT&#x27;&gt;, &#x27;FLOAT&#x27;: &lt;TokenType.FLOAT: &#x27;FLOAT&#x27;&gt;, &#x27;FLOAT4&#x27;: &lt;TokenType.FLOAT: &#x27;FLOAT&#x27;&gt;, &#x27;FLOAT8&#x27;: &lt;TokenType.DOUBLE: &#x27;DOUBLE&#x27;&gt;, &#x27;DOUBLE&#x27;: &lt;TokenType.DOUBLE: &#x27;DOUBLE&#x27;&gt;, &#x27;DOUBLE PRECISION&#x27;: &lt;TokenType.DOUBLE: &#x27;DOUBLE&#x27;&gt;, &#x27;JSON&#x27;: &lt;TokenType.JSON: &#x27;JSON&#x27;&gt;, &#x27;CHAR&#x27;: &lt;TokenType.CHAR: &#x27;CHAR&#x27;&gt;, &#x27;CHARACTER&#x27;: &lt;TokenType.CHAR: &#x27;CHAR&#x27;&gt;, &#x27;NCHAR&#x27;: &lt;TokenType.NCHAR: &#x27;NCHAR&#x27;&gt;, &#x27;VARCHAR&#x27;: &lt;TokenType.VARCHAR: &#x27;VARCHAR&#x27;&gt;, &#x27;VARCHAR2&#x27;: &lt;TokenType.VARCHAR: &#x27;VARCHAR&#x27;&gt;, &#x27;NVARCHAR&#x27;: &lt;TokenType.NVARCHAR: &#x27;NVARCHAR&#x27;&gt;, &#x27;NVARCHAR2&#x27;: &lt;TokenType.NVARCHAR: &#x27;NVARCHAR&#x27;&gt;, &#x27;STR&#x27;: &lt;TokenType.TEXT: &#x27;TEXT&#x27;&gt;, &#x27;STRING&#x27;: &lt;TokenType.TEXT: &#x27;TEXT&#x27;&gt;, &#x27;TEXT&#x27;: &lt;TokenType.TEXT: &#x27;TEXT&#x27;&gt;, &#x27;LONGTEXT&#x27;: &lt;TokenType.LONGTEXT: &#x27;LONGTEXT&#x27;&gt;, &#x27;MEDIUMTEXT&#x27;: &lt;TokenType.MEDIUMTEXT: &#x27;MEDIUMTEXT&#x27;&gt;, &#x27;TINYTEXT&#x27;: &lt;TokenType.TINYTEXT: &#x27;TINYTEXT&#x27;&gt;, &#x27;CLOB&#x27;: &lt;TokenType.TEXT: &#x27;TEXT&#x27;&gt;, &#x27;LONGVARCHAR&#x27;: &lt;TokenType.TEXT: &#x27;TEXT&#x27;&gt;, &#x27;BINARY&#x27;: &lt;TokenType.BINARY: &#x27;BINARY&#x27;&gt;, &#x27;BLOB&#x27;: &lt;TokenType.VARBINARY: &#x27;VARBINARY&#x27;&gt;, &#x27;LONGBLOB&#x27;: &lt;TokenType.LONGBLOB: &#x27;LONGBLOB&#x27;&gt;, &#x27;MEDIUMBLOB&#x27;: &lt;TokenType.MEDIUMBLOB: &#x27;MEDIUMBLOB&#x27;&gt;, &#x27;TINYBLOB&#x27;: &lt;TokenType.TINYBLOB: &#x27;TINYBLOB&#x27;&gt;, &#x27;BYTEA&#x27;: &lt;TokenType.VARBINARY: &#x27;VARBINARY&#x27;&gt;, &#x27;VARBINARY&#x27;: &lt;TokenType.VARBINARY: &#x27;VARBINARY&#x27;&gt;, &#x27;TIME&#x27;: &lt;TokenType.TIME: &#x27;TIME&#x27;&gt;, &#x27;TIMETZ&#x27;: &lt;TokenType.TIMETZ: &#x27;TIMETZ&#x27;&gt;, &#x27;TIMESTAMP&#x27;: &lt;TokenType.TIMESTAMP: &#x27;TIMESTAMP&#x27;&gt;, &#x27;TIMESTAMPTZ&#x27;: &lt;TokenType.TIMESTAMPTZ: &#x27;TIMESTAMPTZ&#x27;&gt;, &#x27;TIMESTAMPLTZ&#x27;: &lt;TokenType.TIMESTAMPLTZ: &#x27;TIMESTAMPLTZ&#x27;&gt;, &#x27;DATE&#x27;: &lt;TokenType.DATE: &#x27;DATE&#x27;&gt;, &#x27;DATETIME&#x27;: &lt;TokenType.DATETIME: &#x27;DATETIME&#x27;&gt;, &#x27;INT4RANGE&#x27;: &lt;TokenType.INT4RANGE: &#x27;INT4RANGE&#x27;&gt;, &#x27;INT4MULTIRANGE&#x27;: &lt;TokenType.INT4MULTIRANGE: &#x27;INT4MULTIRANGE&#x27;&gt;, &#x27;INT8RANGE&#x27;: &lt;TokenType.INT8RANGE: &#x27;INT8RANGE&#x27;&gt;, &#x27;INT8MULTIRANGE&#x27;: &lt;TokenType.INT8MULTIRANGE: &#x27;INT8MULTIRANGE&#x27;&gt;, &#x27;NUMRANGE&#x27;: &lt;TokenType.NUMRANGE: &#x27;NUMRANGE&#x27;&gt;, &#x27;NUMMULTIRANGE&#x27;: &lt;TokenType.NUMMULTIRANGE: &#x27;NUMMULTIRANGE&#x27;&gt;, &#x27;TSRANGE&#x27;: &lt;TokenType.TSRANGE: &#x27;TSRANGE&#x27;&gt;, &#x27;TSMULTIRANGE&#x27;: &lt;TokenType.TSMULTIRANGE: &#x27;TSMULTIRANGE&#x27;&gt;, &#x27;TSTZRANGE&#x27;: &lt;TokenType.TSTZRANGE: &#x27;TSTZRANGE&#x27;&gt;, &#x27;TSTZMULTIRANGE&#x27;: &lt;TokenType.TSTZMULTIRANGE: &#x27;TSTZMULTIRANGE&#x27;&gt;, &#x27;DATERANGE&#x27;: &lt;TokenType.DATERANGE: &#x27;DATERANGE&#x27;&gt;, &#x27;DATEMULTIRANGE&#x27;: &lt;TokenType.DATEMULTIRANGE: &#x27;DATEMULTIRANGE&#x27;&gt;, &#x27;UNIQUE&#x27;: &lt;TokenType.UNIQUE: &#x27;UNIQUE&#x27;&gt;, &#x27;STRUCT&#x27;: &lt;TokenType.STRUCT: &#x27;STRUCT&#x27;&gt;, &#x27;VARIANT&#x27;: &lt;TokenType.VARIANT: &#x27;VARIANT&#x27;&gt;, &#x27;ALTER&#x27;: &lt;TokenType.ALTER: &#x27;ALTER&#x27;&gt;, &#x27;ANALYZE&#x27;: &lt;TokenType.COMMAND: &#x27;COMMAND&#x27;&gt;, &#x27;CALL&#x27;: &lt;TokenType.COMMAND: &#x27;COMMAND&#x27;&gt;, &#x27;COMMENT&#x27;: &lt;TokenType.COMMENT: &#x27;COMMENT&#x27;&gt;, &#x27;COPY&#x27;: &lt;TokenType.COMMAND: &#x27;COMMAND&#x27;&gt;, &#x27;EXPLAIN&#x27;: &lt;TokenType.COMMAND: &#x27;COMMAND&#x27;&gt;, &#x27;GRANT&#x27;: &lt;TokenType.COMMAND: &#x27;COMMAND&#x27;&gt;, &#x27;OPTIMIZE&#x27;: &lt;TokenType.COMMAND: &#x27;COMMAND&#x27;&gt;, &#x27;PREPARE&#x27;: &lt;TokenType.COMMAND: &#x27;COMMAND&#x27;&gt;, &#x27;TRUNCATE&#x27;: &lt;TokenType.COMMAND: &#x27;COMMAND&#x27;&gt;, &#x27;VACUUM&#x27;: &lt;TokenType.COMMAND: &#x27;COMMAND&#x27;&gt;, &#x27;USER-DEFINED&#x27;: &lt;TokenType.USERDEFINED: &#x27;USERDEFINED&#x27;&gt;, &#x27;FOR VERSION&#x27;: &lt;TokenType.VERSION_SNAPSHOT: &#x27;VERSION_SNAPSHOT&#x27;&gt;, &#x27;FOR TIMESTAMP&#x27;: &lt;TokenType.TIMESTAMP_SNAPSHOT: &#x27;TIMESTAMP_SNAPSHOT&#x27;&gt;, &#x27;ADD ARCHIVE&#x27;: &lt;TokenType.COMMAND: &#x27;COMMAND&#x27;&gt;, &#x27;ADD ARCHIVES&#x27;: &lt;TokenType.COMMAND: &#x27;COMMAND&#x27;&gt;, &#x27;ADD FILE&#x27;: &lt;TokenType.COMMAND: &#x27;COMMAND&#x27;&gt;, &#x27;ADD FILES&#x27;: &lt;TokenType.COMMAND: &#x27;COMMAND&#x27;&gt;, &#x27;ADD JAR&#x27;: &lt;TokenType.COMMAND: &#x27;COMMAND&#x27;&gt;, &#x27;ADD JARS&#x27;: &lt;TokenType.COMMAND: &#x27;COMMAND&#x27;&gt;, &#x27;MSCK REPAIR&#x27;: &lt;TokenType.COMMAND: &#x27;COMMAND&#x27;&gt;, &#x27;REFRESH&#x27;: &lt;TokenType.COMMAND: &#x27;COMMAND&#x27;&gt;, &#x27;WITH SERDEPROPERTIES&#x27;: &lt;TokenType.SERDE_PROPERTIES: &#x27;SERDE_PROPERTIES&#x27;&gt;, &#x27;TIMESTAMP AS OF&#x27;: &lt;TokenType.TIMESTAMP_SNAPSHOT: &#x27;TIMESTAMP_SNAPSHOT&#x27;&gt;, &#x27;VERSION AS OF&#x27;: &lt;TokenType.VERSION_SNAPSHOT: &#x27;VERSION_SNAPSHOT&#x27;&gt;}"}, "sqlglot.dialects.hive.Hive.Tokenizer.NUMERIC_LITERALS": {"fullname": "sqlglot.dialects.hive.Hive.Tokenizer.NUMERIC_LITERALS", "modulename": "sqlglot.dialects.hive", "qualname": "Hive.Tokenizer.NUMERIC_LITERALS", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;L&#x27;: &#x27;BIGINT&#x27;, &#x27;S&#x27;: &#x27;SMALLINT&#x27;, &#x27;Y&#x27;: &#x27;TINYINT&#x27;, &#x27;D&#x27;: &#x27;DOUBLE&#x27;, &#x27;F&#x27;: &#x27;FLOAT&#x27;, &#x27;BD&#x27;: &#x27;DECIMAL&#x27;}"}, "sqlglot.dialects.hive.Hive.Tokenizer.IDENTIFIERS_CAN_START_WITH_DIGIT": {"fullname": "sqlglot.dialects.hive.Hive.Tokenizer.IDENTIFIERS_CAN_START_WITH_DIGIT", "modulename": "sqlglot.dialects.hive", "qualname": "Hive.Tokenizer.IDENTIFIERS_CAN_START_WITH_DIGIT", "kind": "variable", "doc": "<p></p>\n", "annotation": ": bool", "default_value": "True"}, "sqlglot.dialects.hive.Hive.Parser": {"fullname": "sqlglot.dialects.hive.Hive.Parser", "modulename": "sqlglot.dialects.hive", "qualname": "Hive.Parser", "kind": "class", "doc": "<p>Parser consumes a list of tokens produced by the Tokenizer and produces a parsed syntax tree.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>error_level:</strong>  The desired error level.\nDefault: ErrorLevel.IMMEDIATE</li>\n<li><strong>error_message_context:</strong>  Determines the amount of context to capture from a\nquery string when displaying the error message (in number of characters).\nDefault: 100</li>\n<li><strong>max_errors:</strong>  Maximum number of error messages to include in a raised ParseError.\nThis is only relevant if error_level is ErrorLevel.RAISE.\nDefault: 3</li>\n</ul>\n", "bases": "sqlglot.parser.Parser"}, "sqlglot.dialects.hive.Hive.Parser.LOG_DEFAULTS_TO_LN": {"fullname": "sqlglot.dialects.hive.Hive.Parser.LOG_DEFAULTS_TO_LN", "modulename": "sqlglot.dialects.hive", "qualname": "Hive.Parser.LOG_DEFAULTS_TO_LN", "kind": "variable", "doc": "<p></p>\n", "default_value": "True"}, "sqlglot.dialects.hive.Hive.Parser.STRICT_CAST": {"fullname": "sqlglot.dialects.hive.Hive.Parser.STRICT_CAST", "modulename": "sqlglot.dialects.hive", "qualname": "Hive.Parser.STRICT_CAST", "kind": "variable", "doc": "<p></p>\n", "default_value": "False"}, "sqlglot.dialects.hive.Hive.Parser.FUNCTIONS": {"fullname": "sqlglot.dialects.hive.Hive.Parser.FUNCTIONS", "modulename": "sqlglot.dialects.hive", "qualname": "Hive.Parser.FUNCTIONS", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;ABS&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Abs&#x27;&gt;&gt;, &#x27;ANY_VALUE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.AnyValue&#x27;&gt;&gt;, &#x27;APPROX_DISTINCT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ApproxDistinct&#x27;&gt;&gt;, &#x27;APPROX_COUNT_DISTINCT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ApproxDistinct&#x27;&gt;&gt;, &#x27;APPROX_QUANTILE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ApproxQuantile&#x27;&gt;&gt;, &#x27;ARRAY&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Array&#x27;&gt;&gt;, &#x27;ARRAY_AGG&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArrayAgg&#x27;&gt;&gt;, &#x27;ARRAY_ALL&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArrayAll&#x27;&gt;&gt;, &#x27;ARRAY_ANY&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArrayAny&#x27;&gt;&gt;, &#x27;ARRAY_CONCAT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArrayConcat&#x27;&gt;&gt;, &#x27;ARRAY_CAT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArrayConcat&#x27;&gt;&gt;, &#x27;ARRAY_CONTAINS&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArrayContains&#x27;&gt;&gt;, &#x27;FILTER&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArrayFilter&#x27;&gt;&gt;, &#x27;ARRAY_FILTER&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArrayFilter&#x27;&gt;&gt;, &#x27;ARRAY_JOIN&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArrayJoin&#x27;&gt;&gt;, &#x27;ARRAY_SIZE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArraySize&#x27;&gt;&gt;, &#x27;ARRAY_SORT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArraySort&#x27;&gt;&gt;, &#x27;ARRAY_SUM&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArraySum&#x27;&gt;&gt;, &#x27;ARRAY_UNION_AGG&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArrayUnionAgg&#x27;&gt;&gt;, &#x27;AVG&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Avg&#x27;&gt;&gt;, &#x27;CASE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Case&#x27;&gt;&gt;, &#x27;CAST&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Cast&#x27;&gt;&gt;, &#x27;CAST_TO_STR_TYPE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.CastToStrType&#x27;&gt;&gt;, &#x27;CEIL&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Ceil&#x27;&gt;&gt;, &#x27;CEILING&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Ceil&#x27;&gt;&gt;, &#x27;CHR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Chr&#x27;&gt;&gt;, &#x27;CHAR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Chr&#x27;&gt;&gt;, &#x27;COALESCE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Coalesce&#x27;&gt;&gt;, &#x27;IFNULL&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Coalesce&#x27;&gt;&gt;, &#x27;NVL&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Coalesce&#x27;&gt;&gt;, &#x27;COLLATE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Collate&#x27;&gt;&gt;, &#x27;CONCAT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Concat&#x27;&gt;&gt;, &#x27;CONCAT_WS&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ConcatWs&#x27;&gt;&gt;, &#x27;COUNT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Count&#x27;&gt;&gt;, &#x27;COUNT_IF&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.CountIf&#x27;&gt;&gt;, &#x27;CURRENT_DATE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.CurrentDate&#x27;&gt;&gt;, &#x27;CURRENT_DATETIME&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.CurrentDatetime&#x27;&gt;&gt;, &#x27;CURRENT_TIME&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.CurrentTime&#x27;&gt;&gt;, &#x27;CURRENT_TIMESTAMP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.CurrentTimestamp&#x27;&gt;&gt;, &#x27;CURRENT_USER&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.CurrentUser&#x27;&gt;&gt;, &#x27;DATE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Date&#x27;&gt;&gt;, &#x27;DATE_ADD&#x27;: &lt;function Hive.Parser.&lt;lambda&gt;&gt;, &#x27;DATEDIFF&#x27;: &lt;function Hive.Parser.&lt;lambda&gt;&gt;, &#x27;DATE_DIFF&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DateDiff&#x27;&gt;&gt;, &#x27;DATEFROMPARTS&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DateFromParts&#x27;&gt;&gt;, &#x27;DATE_STR_TO_DATE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DateStrToDate&#x27;&gt;&gt;, &#x27;DATE_SUB&#x27;: &lt;function Hive.Parser.&lt;lambda&gt;&gt;, &#x27;DATE_TO_DATE_STR&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;DATE_TO_DI&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DateToDi&#x27;&gt;&gt;, &#x27;DATE_TRUNC&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DateTrunc&#x27;&gt;&gt;, &#x27;DATETIME_ADD&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DatetimeAdd&#x27;&gt;&gt;, &#x27;DATETIME_DIFF&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DatetimeDiff&#x27;&gt;&gt;, &#x27;DATETIME_SUB&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DatetimeSub&#x27;&gt;&gt;, &#x27;DATETIME_TRUNC&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DatetimeTrunc&#x27;&gt;&gt;, &#x27;DAY&#x27;: &lt;function Hive.Parser.&lt;lambda&gt;&gt;, &#x27;DAY_OF_MONTH&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DayOfMonth&#x27;&gt;&gt;, &#x27;DAYOFMONTH&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DayOfMonth&#x27;&gt;&gt;, &#x27;DAY_OF_WEEK&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DayOfWeek&#x27;&gt;&gt;, &#x27;DAYOFWEEK&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DayOfWeek&#x27;&gt;&gt;, &#x27;DAY_OF_YEAR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DayOfYear&#x27;&gt;&gt;, &#x27;DAYOFYEAR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DayOfYear&#x27;&gt;&gt;, &#x27;DECODE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Decode&#x27;&gt;&gt;, &#x27;DI_TO_DATE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.DiToDate&#x27;&gt;&gt;, &#x27;ENCODE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Encode&#x27;&gt;&gt;, &#x27;EXP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Exp&#x27;&gt;&gt;, &#x27;EXPLODE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Explode&#x27;&gt;&gt;, &#x27;EXPLODE_OUTER&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ExplodeOuter&#x27;&gt;&gt;, &#x27;EXTRACT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Extract&#x27;&gt;&gt;, &#x27;FIRST&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.First&#x27;&gt;&gt;, &#x27;FLATTEN&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Flatten&#x27;&gt;&gt;, &#x27;FLOOR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Floor&#x27;&gt;&gt;, &#x27;FROM_BASE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.FromBase&#x27;&gt;&gt;, &#x27;FROM_BASE64&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.FromBase64&#x27;&gt;&gt;, &#x27;GENERATE_SERIES&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.GenerateSeries&#x27;&gt;&gt;, &#x27;GREATEST&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Greatest&#x27;&gt;&gt;, &#x27;GROUP_CONCAT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.GroupConcat&#x27;&gt;&gt;, &#x27;HEX&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Hex&#x27;&gt;&gt;, &#x27;HLL&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Hll&#x27;&gt;&gt;, &#x27;IF&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.If&#x27;&gt;&gt;, &#x27;INITCAP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Initcap&#x27;&gt;&gt;, &#x27;IS_NAN&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.IsNan&#x27;&gt;&gt;, &#x27;ISNAN&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.IsNan&#x27;&gt;&gt;, &#x27;J_S_O_N_ARRAY&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.JSONArray&#x27;&gt;&gt;, &#x27;J_S_O_N_ARRAY_AGG&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.JSONArrayAgg&#x27;&gt;&gt;, &#x27;JSON_ARRAY_CONTAINS&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.JSONArrayContains&#x27;&gt;&gt;, &#x27;JSONB_EXTRACT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.JSONBExtract&#x27;&gt;&gt;, &#x27;JSONB_EXTRACT_SCALAR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.JSONBExtractScalar&#x27;&gt;&gt;, &#x27;JSON_EXTRACT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.JSONExtract&#x27;&gt;&gt;, &#x27;JSON_EXTRACT_SCALAR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.JSONExtractScalar&#x27;&gt;&gt;, &#x27;JSON_FORMAT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.JSONFormat&#x27;&gt;&gt;, &#x27;J_S_O_N_OBJECT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.JSONObject&#x27;&gt;&gt;, &#x27;J_S_O_N_TABLE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.JSONTable&#x27;&gt;&gt;, &#x27;LAST&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Last&#x27;&gt;&gt;, &#x27;LAST_DATE_OF_MONTH&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.LastDateOfMonth&#x27;&gt;&gt;, &#x27;LEAST&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Least&#x27;&gt;&gt;, &#x27;LEFT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Left&#x27;&gt;&gt;, &#x27;LENGTH&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Length&#x27;&gt;&gt;, &#x27;LEN&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Length&#x27;&gt;&gt;, &#x27;LEVENSHTEIN&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Levenshtein&#x27;&gt;&gt;, &#x27;LN&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Ln&#x27;&gt;&gt;, &#x27;LOG&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Log&#x27;&gt;&gt;, &#x27;LOG10&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Log10&#x27;&gt;&gt;, &#x27;LOG2&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Log2&#x27;&gt;&gt;, &#x27;LOGICAL_AND&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.LogicalAnd&#x27;&gt;&gt;, &#x27;BOOL_AND&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.LogicalAnd&#x27;&gt;&gt;, &#x27;BOOLAND_AGG&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.LogicalAnd&#x27;&gt;&gt;, &#x27;LOGICAL_OR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.LogicalOr&#x27;&gt;&gt;, &#x27;BOOL_OR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.LogicalOr&#x27;&gt;&gt;, &#x27;BOOLOR_AGG&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.LogicalOr&#x27;&gt;&gt;, &#x27;LOWER&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Lower&#x27;&gt;&gt;, &#x27;LCASE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Lower&#x27;&gt;&gt;, &#x27;MD5&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.MD5&#x27;&gt;&gt;, &#x27;MD5_DIGEST&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.MD5Digest&#x27;&gt;&gt;, &#x27;MAP&#x27;: &lt;function parse_var_map&gt;, &#x27;MAP_FROM_ENTRIES&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.MapFromEntries&#x27;&gt;&gt;, &#x27;MATCH_AGAINST&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.MatchAgainst&#x27;&gt;&gt;, &#x27;MAX&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Max&#x27;&gt;&gt;, &#x27;MIN&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Min&#x27;&gt;&gt;, &#x27;MONTH&#x27;: &lt;function Hive.Parser.&lt;lambda&gt;&gt;, &#x27;MONTHS_BETWEEN&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.MonthsBetween&#x27;&gt;&gt;, &#x27;NEXT_VALUE_FOR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.NextValueFor&#x27;&gt;&gt;, &#x27;NUMBER_TO_STR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.NumberToStr&#x27;&gt;&gt;, &#x27;NVL2&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Nvl2&#x27;&gt;&gt;, &#x27;OPEN_J_S_O_N&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.OpenJSON&#x27;&gt;&gt;, &#x27;PARAMETERIZED_AGG&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ParameterizedAgg&#x27;&gt;&gt;, &#x27;PARSE_JSON&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ParseJSON&#x27;&gt;&gt;, &#x27;JSON_PARSE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ParseJSON&#x27;&gt;&gt;, &#x27;PERCENTILE_CONT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.PercentileCont&#x27;&gt;&gt;, &#x27;PERCENTILE_DISC&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.PercentileDisc&#x27;&gt;&gt;, &#x27;POSEXPLODE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Posexplode&#x27;&gt;&gt;, &#x27;POSEXPLODE_OUTER&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.PosexplodeOuter&#x27;&gt;&gt;, &#x27;POWER&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Pow&#x27;&gt;&gt;, &#x27;POW&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Pow&#x27;&gt;&gt;, &#x27;PREDICT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Predict&#x27;&gt;&gt;, &#x27;QUANTILE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Quantile&#x27;&gt;&gt;, &#x27;RANGE_N&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.RangeN&#x27;&gt;&gt;, &#x27;READ_CSV&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ReadCSV&#x27;&gt;&gt;, &#x27;REDUCE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Reduce&#x27;&gt;&gt;, &#x27;REGEXP_EXTRACT&#x27;: &lt;function Hive.Parser.&lt;lambda&gt;&gt;, &#x27;REGEXP_I_LIKE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.RegexpILike&#x27;&gt;&gt;, &#x27;REGEXP_LIKE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.RegexpLike&#x27;&gt;&gt;, &#x27;REGEXP_REPLACE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.RegexpReplace&#x27;&gt;&gt;, &#x27;REGEXP_SPLIT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.RegexpSplit&#x27;&gt;&gt;, &#x27;REPEAT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Repeat&#x27;&gt;&gt;, &#x27;RIGHT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Right&#x27;&gt;&gt;, &#x27;ROUND&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Round&#x27;&gt;&gt;, &#x27;ROW_NUMBER&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.RowNumber&#x27;&gt;&gt;, &#x27;SHA&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.SHA&#x27;&gt;&gt;, &#x27;SHA1&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.SHA&#x27;&gt;&gt;, &#x27;SHA2&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.SHA2&#x27;&gt;&gt;, &#x27;SAFE_CONCAT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.SafeConcat&#x27;&gt;&gt;, &#x27;SAFE_DIVIDE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.SafeDivide&#x27;&gt;&gt;, &#x27;SET_AGG&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.SetAgg&#x27;&gt;&gt;, &#x27;SORT_ARRAY&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.SortArray&#x27;&gt;&gt;, &#x27;SPLIT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.RegexpSplit&#x27;&gt;&gt;, &#x27;SQRT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Sqrt&#x27;&gt;&gt;, &#x27;STANDARD_HASH&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StandardHash&#x27;&gt;&gt;, &#x27;STAR_MAP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StarMap&#x27;&gt;&gt;, &#x27;STARTS_WITH&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StartsWith&#x27;&gt;&gt;, &#x27;STARTSWITH&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StartsWith&#x27;&gt;&gt;, &#x27;STDDEV&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Stddev&#x27;&gt;&gt;, &#x27;STDDEV_POP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StddevPop&#x27;&gt;&gt;, &#x27;STDDEV_SAMP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StddevSamp&#x27;&gt;&gt;, &#x27;STR_POSITION&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StrPosition&#x27;&gt;&gt;, &#x27;STR_TO_DATE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StrToDate&#x27;&gt;&gt;, &#x27;STR_TO_MAP&#x27;: &lt;function Hive.Parser.&lt;lambda&gt;&gt;, &#x27;STR_TO_TIME&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StrToTime&#x27;&gt;&gt;, &#x27;STR_TO_UNIX&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StrToUnix&#x27;&gt;&gt;, &#x27;STRUCT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Struct&#x27;&gt;&gt;, &#x27;STRUCT_EXTRACT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.StructExtract&#x27;&gt;&gt;, &#x27;STUFF&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Stuff&#x27;&gt;&gt;, &#x27;INSERT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Stuff&#x27;&gt;&gt;, &#x27;SUBSTRING&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Substring&#x27;&gt;&gt;, &#x27;SUM&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Sum&#x27;&gt;&gt;, &#x27;TIME_ADD&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimeAdd&#x27;&gt;&gt;, &#x27;TIME_DIFF&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimeDiff&#x27;&gt;&gt;, &#x27;TIME_STR_TO_DATE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimeStrToDate&#x27;&gt;&gt;, &#x27;TIME_STR_TO_TIME&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimeStrToTime&#x27;&gt;&gt;, &#x27;TIME_STR_TO_UNIX&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimeStrToUnix&#x27;&gt;&gt;, &#x27;TIME_SUB&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimeSub&#x27;&gt;&gt;, &#x27;TIME_TO_STR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimeToStr&#x27;&gt;&gt;, &#x27;TIME_TO_TIME_STR&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;TIME_TO_UNIX&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimeToUnix&#x27;&gt;&gt;, &#x27;TIME_TRUNC&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimeTrunc&#x27;&gt;&gt;, &#x27;TIMESTAMP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Timestamp&#x27;&gt;&gt;, &#x27;TIMESTAMP_ADD&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimestampAdd&#x27;&gt;&gt;, &#x27;TIMESTAMP_DIFF&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimestampDiff&#x27;&gt;&gt;, &#x27;TIMESTAMP_SUB&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimestampSub&#x27;&gt;&gt;, &#x27;TIMESTAMP_TRUNC&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TimestampTrunc&#x27;&gt;&gt;, &#x27;TO_BASE64&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ToBase64&#x27;&gt;&gt;, &#x27;TO_CHAR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ToChar&#x27;&gt;&gt;, &#x27;TO_DAYS&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ToDays&#x27;&gt;&gt;, &#x27;TRANSFORM&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Transform&#x27;&gt;&gt;, &#x27;TRIM&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Trim&#x27;&gt;&gt;, &#x27;TRY_CAST&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TryCast&#x27;&gt;&gt;, &#x27;TS_OR_DI_TO_DI&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TsOrDiToDi&#x27;&gt;&gt;, &#x27;TS_OR_DS_ADD&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TsOrDsAdd&#x27;&gt;&gt;, &#x27;TS_OR_DS_TO_DATE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.TsOrDsToDate&#x27;&gt;&gt;, &#x27;TS_OR_DS_TO_DATE_STR&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;UNHEX&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Unhex&#x27;&gt;&gt;, &#x27;UNIX_TO_STR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.UnixToStr&#x27;&gt;&gt;, &#x27;UNIX_TO_TIME&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.UnixToTime&#x27;&gt;&gt;, &#x27;UNIX_TO_TIME_STR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.UnixToTimeStr&#x27;&gt;&gt;, &#x27;UPPER&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Upper&#x27;&gt;&gt;, &#x27;UCASE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Upper&#x27;&gt;&gt;, &#x27;VAR_MAP&#x27;: &lt;function parse_var_map&gt;, &#x27;VARIANCE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Variance&#x27;&gt;&gt;, &#x27;VARIANCE_SAMP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Variance&#x27;&gt;&gt;, &#x27;VAR_SAMP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Variance&#x27;&gt;&gt;, &#x27;VARIANCE_POP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.VariancePop&#x27;&gt;&gt;, &#x27;VAR_POP&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.VariancePop&#x27;&gt;&gt;, &#x27;WEEK&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Week&#x27;&gt;&gt;, &#x27;WEEK_OF_YEAR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.WeekOfYear&#x27;&gt;&gt;, &#x27;WEEKOFYEAR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.WeekOfYear&#x27;&gt;&gt;, &#x27;WHEN&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.When&#x27;&gt;&gt;, &#x27;X_M_L_TABLE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.XMLTable&#x27;&gt;&gt;, &#x27;XOR&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Xor&#x27;&gt;&gt;, &#x27;YEAR&#x27;: &lt;function Hive.Parser.&lt;lambda&gt;&gt;, &#x27;GLOB&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;LIKE&#x27;: &lt;function parse_like&gt;, &#x27;BASE64&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ToBase64&#x27;&gt;&gt;, &#x27;COLLECT_LIST&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArrayAgg&#x27;&gt;&gt;, &#x27;COLLECT_SET&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.SetAgg&#x27;&gt;&gt;, &#x27;DATE_FORMAT&#x27;: &lt;function Hive.Parser.&lt;lambda&gt;&gt;, &#x27;FROM_UNIXTIME&#x27;: &lt;function format_time_lambda.&lt;locals&gt;._format_time&gt;, &#x27;GET_JSON_OBJECT&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.JSONExtractScalar&#x27;&gt;&gt;, &#x27;LOCATE&#x27;: &lt;function locate_to_strposition&gt;, &#x27;PERCENTILE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.Quantile&#x27;&gt;&gt;, &#x27;PERCENTILE_APPROX&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ApproxQuantile&#x27;&gt;&gt;, &#x27;SIZE&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.ArraySize&#x27;&gt;&gt;, &#x27;TO_DATE&#x27;: &lt;function format_time_lambda.&lt;locals&gt;._format_time&gt;, &#x27;TO_JSON&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.JSONFormat&#x27;&gt;&gt;, &#x27;UNBASE64&#x27;: &lt;bound method Func.from_arg_list of &lt;class &#x27;sqlglot.expressions.FromBase64&#x27;&gt;&gt;, &#x27;UNIX_TIMESTAMP&#x27;: &lt;function format_time_lambda.&lt;locals&gt;._format_time&gt;}"}, "sqlglot.dialects.hive.Hive.Parser.NO_PAREN_FUNCTION_PARSERS": {"fullname": "sqlglot.dialects.hive.Hive.Parser.NO_PAREN_FUNCTION_PARSERS", "modulename": "sqlglot.dialects.hive", "qualname": "Hive.Parser.NO_PAREN_FUNCTION_PARSERS", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;ANY&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;CASE&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;IF&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;NEXT&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;TRANSFORM&#x27;: &lt;function Hive.Parser.&lt;lambda&gt;&gt;}"}, "sqlglot.dialects.hive.Hive.Parser.PROPERTY_PARSERS": {"fullname": "sqlglot.dialects.hive.Hive.Parser.PROPERTY_PARSERS", "modulename": "sqlglot.dialects.hive", "qualname": "Hive.Parser.PROPERTY_PARSERS", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;ALGORITHM&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;AUTO_INCREMENT&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;BLOCKCOMPRESSION&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;CHARSET&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;CHARACTER SET&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;CHECKSUM&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;CLUSTER BY&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;CLUSTERED&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;COLLATE&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;COMMENT&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;COPY&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;DATABLOCKSIZE&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;DEFINER&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;DETERMINISTIC&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;DISTKEY&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;DISTSTYLE&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;ENGINE&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;EXECUTE&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;EXTERNAL&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;FALLBACK&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;FORMAT&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;FREESPACE&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;HEAP&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;IMMUTABLE&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;INPUT&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;JOURNAL&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;LANGUAGE&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;LAYOUT&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;LIFETIME&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;LIKE&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;LOCATION&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;LOCK&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;LOCKING&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;LOG&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;MATERIALIZED&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;MERGEBLOCKRATIO&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;MULTISET&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;NO&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;ON&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;ORDER BY&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;OUTPUT&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;PARTITION BY&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;PARTITIONED BY&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;PARTITIONED_BY&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;PRIMARY KEY&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;RANGE&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;REMOTE&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;RETURNS&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;ROW&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;ROW_FORMAT&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;SAMPLE&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;SET&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;SETTINGS&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;SORTKEY&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;SOURCE&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;STABLE&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;STORED&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;TBLPROPERTIES&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;TEMP&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;TEMPORARY&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;TO&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;TRANSIENT&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;TRANSFORM&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;TTL&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;USING&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;VOLATILE&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;WITH&#x27;: &lt;function Parser.&lt;lambda&gt;&gt;, &#x27;WITH SERDEPROPERTIES&#x27;: &lt;function Hive.Parser.&lt;lambda&gt;&gt;}"}, "sqlglot.dialects.hive.Hive.Parser.TOKENIZER_CLASS": {"fullname": "sqlglot.dialects.hive.Hive.Parser.TOKENIZER_CLASS", "modulename": "sqlglot.dialects.hive", "qualname": "Hive.Parser.TOKENIZER_CLASS", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Type[sqlglot.tokens.Tokenizer]", "default_value": "&lt;class &#x27;sqlglot.dialects.hive.Hive.Tokenizer&#x27;&gt;"}, "sqlglot.dialects.hive.Hive.Parser.ALIAS_POST_TABLESAMPLE": {"fullname": "sqlglot.dialects.hive.Hive.Parser.ALIAS_POST_TABLESAMPLE", "modulename": "sqlglot.dialects.hive", "qualname": "Hive.Parser.ALIAS_POST_TABLESAMPLE", "kind": "variable", "doc": "<p></p>\n", "annotation": ": bool", "default_value": "True"}, "sqlglot.dialects.hive.Hive.Parser.SUPPORTS_USER_DEFINED_TYPES": {"fullname": "sqlglot.dialects.hive.Hive.Parser.SUPPORTS_USER_DEFINED_TYPES", "modulename": "sqlglot.dialects.hive", "qualname": "Hive.Parser.SUPPORTS_USER_DEFINED_TYPES", "kind": "variable", "doc": "<p></p>\n", "default_value": "False"}, "sqlglot.dialects.hive.Hive.Parser.SHOW_TRIE": {"fullname": "sqlglot.dialects.hive.Hive.Parser.SHOW_TRIE", "modulename": "sqlglot.dialects.hive", "qualname": "Hive.Parser.SHOW_TRIE", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict", "default_value": "{}"}, "sqlglot.dialects.hive.Hive.Parser.SET_TRIE": {"fullname": "sqlglot.dialects.hive.Hive.Parser.SET_TRIE", "modulename": "sqlglot.dialects.hive", "qualname": "Hive.Parser.SET_TRIE", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict", "default_value": "{&#x27;GLOBAL&#x27;: {0: True}, &#x27;LOCAL&#x27;: {0: True}, &#x27;SESSION&#x27;: {0: True}, &#x27;TRANSACTION&#x27;: {0: True}}"}, "sqlglot.dialects.hive.Hive.Parser.FORMAT_TRIE": {"fullname": "sqlglot.dialects.hive.Hive.Parser.FORMAT_TRIE", "modulename": "sqlglot.dialects.hive", "qualname": "Hive.Parser.FORMAT_TRIE", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict", "default_value": "{&#x27;y&#x27;: {0: True, &#x27;y&#x27;: {&#x27;y&#x27;: {&#x27;y&#x27;: {0: True}}, 0: True}}, &#x27;Y&#x27;: {0: True, &#x27;Y&#x27;: {&#x27;Y&#x27;: {&#x27;Y&#x27;: {0: True}}, 0: True}}, &#x27;M&#x27;: {&#x27;M&#x27;: {&#x27;M&#x27;: {&#x27;M&#x27;: {0: True}, 0: True}, 0: True}, 0: True}, &#x27;d&#x27;: {&#x27;d&#x27;: {0: True}, 0: True}, &#x27;H&#x27;: {&#x27;H&#x27;: {0: True}, 0: True}, &#x27;h&#x27;: {&#x27;h&#x27;: {0: True}, 0: True}, &#x27;m&#x27;: {&#x27;m&#x27;: {0: True}, 0: True}, &#x27;s&#x27;: {&#x27;s&#x27;: {0: True}, 0: True}, &#x27;S&#x27;: {&#x27;S&#x27;: {&#x27;S&#x27;: {&#x27;S&#x27;: {&#x27;S&#x27;: {&#x27;S&#x27;: {0: True}}}}}}, &#x27;a&#x27;: {0: True}, &#x27;D&#x27;: {&#x27;D&#x27;: {0: True}, 0: True}, &#x27;E&#x27;: {0: True, &#x27;E&#x27;: {0: True, &#x27;E&#x27;: {0: True, &#x27;E&#x27;: {0: True}}}}}"}, "sqlglot.dialects.hive.Hive.Parser.TIME_MAPPING": {"fullname": "sqlglot.dialects.hive.Hive.Parser.TIME_MAPPING", "modulename": "sqlglot.dialects.hive", "qualname": "Hive.Parser.TIME_MAPPING", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict[str, str]", "default_value": "{&#x27;y&#x27;: &#x27;%Y&#x27;, &#x27;Y&#x27;: &#x27;%Y&#x27;, &#x27;YYYY&#x27;: &#x27;%Y&#x27;, &#x27;yyyy&#x27;: &#x27;%Y&#x27;, &#x27;YY&#x27;: &#x27;%y&#x27;, &#x27;yy&#x27;: &#x27;%y&#x27;, &#x27;MMMM&#x27;: &#x27;%B&#x27;, &#x27;MMM&#x27;: &#x27;%b&#x27;, &#x27;MM&#x27;: &#x27;%m&#x27;, &#x27;M&#x27;: &#x27;%-m&#x27;, &#x27;dd&#x27;: &#x27;%d&#x27;, &#x27;d&#x27;: &#x27;%-d&#x27;, &#x27;HH&#x27;: &#x27;%H&#x27;, &#x27;H&#x27;: &#x27;%-H&#x27;, &#x27;hh&#x27;: &#x27;%I&#x27;, &#x27;h&#x27;: &#x27;%-I&#x27;, &#x27;mm&#x27;: &#x27;%M&#x27;, &#x27;m&#x27;: &#x27;%-M&#x27;, &#x27;ss&#x27;: &#x27;%S&#x27;, &#x27;s&#x27;: &#x27;%-S&#x27;, &#x27;SSSSSS&#x27;: &#x27;%f&#x27;, &#x27;a&#x27;: &#x27;%p&#x27;, &#x27;DD&#x27;: &#x27;%j&#x27;, &#x27;D&#x27;: &#x27;%-j&#x27;, &#x27;E&#x27;: &#x27;%a&#x27;, &#x27;EE&#x27;: &#x27;%a&#x27;, &#x27;EEE&#x27;: &#x27;%a&#x27;, &#x27;EEEE&#x27;: &#x27;%A&#x27;}"}, "sqlglot.dialects.hive.Hive.Parser.TIME_TRIE": {"fullname": "sqlglot.dialects.hive.Hive.Parser.TIME_TRIE", "modulename": "sqlglot.dialects.hive", "qualname": "Hive.Parser.TIME_TRIE", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict", "default_value": "{&#x27;y&#x27;: {0: True, &#x27;y&#x27;: {&#x27;y&#x27;: {&#x27;y&#x27;: {0: True}}, 0: True}}, &#x27;Y&#x27;: {0: True, &#x27;Y&#x27;: {&#x27;Y&#x27;: {&#x27;Y&#x27;: {0: True}}, 0: True}}, &#x27;M&#x27;: {&#x27;M&#x27;: {&#x27;M&#x27;: {&#x27;M&#x27;: {0: True}, 0: True}, 0: True}, 0: True}, &#x27;d&#x27;: {&#x27;d&#x27;: {0: True}, 0: True}, &#x27;H&#x27;: {&#x27;H&#x27;: {0: True}, 0: True}, &#x27;h&#x27;: {&#x27;h&#x27;: {0: True}, 0: True}, &#x27;m&#x27;: {&#x27;m&#x27;: {0: True}, 0: True}, &#x27;s&#x27;: {&#x27;s&#x27;: {0: True}, 0: True}, &#x27;S&#x27;: {&#x27;S&#x27;: {&#x27;S&#x27;: {&#x27;S&#x27;: {&#x27;S&#x27;: {&#x27;S&#x27;: {0: True}}}}}}, &#x27;a&#x27;: {0: True}, &#x27;D&#x27;: {&#x27;D&#x27;: {0: True}, 0: True}, &#x27;E&#x27;: {0: True, &#x27;E&#x27;: {0: True, &#x27;E&#x27;: {0: True, &#x27;E&#x27;: {0: True}}}}}"}, "sqlglot.dialects.hive.Hive.Generator": {"fullname": "sqlglot.dialects.hive.Hive.Generator", "modulename": "sqlglot.dialects.hive", "qualname": "Hive.Generator", "kind": "class", "doc": "<p>Generator converts a given syntax tree to the corresponding SQL string.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>pretty:</strong>  Whether or not to format the produced SQL string.\nDefault: False.</li>\n<li><strong>identify:</strong>  Determines when an identifier should be quoted. Possible values are:\nFalse (default): Never quote, except in cases where it's mandatory by the dialect.\nTrue or 'always': Always quote.\n'safe': Only quote identifiers that are case insensitive.</li>\n<li><strong>normalize:</strong>  Whether or not to normalize identifiers to lowercase.\nDefault: False.</li>\n<li><strong>pad:</strong>  Determines the pad size in a formatted string.\nDefault: 2.</li>\n<li><strong>indent:</strong>  Determines the indentation size in a formatted string.\nDefault: 2.</li>\n<li><strong>normalize_functions:</strong>  Whether or not to normalize all function names. Possible values are:\n\"upper\" or True (default): Convert names to uppercase.\n\"lower\": Convert names to lowercase.\nFalse: Disables function name normalization.</li>\n<li><strong>unsupported_level:</strong>  Determines the generator's behavior when it encounters unsupported expressions.\nDefault ErrorLevel.WARN.</li>\n<li><strong>max_unsupported:</strong>  Maximum number of unsupported messages to include in a raised UnsupportedError.\nThis is only relevant if unsupported_level is ErrorLevel.RAISE.\nDefault: 3</li>\n<li><strong>leading_comma:</strong>  Determines whether or not the comma is leading or trailing in select expressions.\nThis is only relevant when generating in pretty mode.\nDefault: False</li>\n<li><strong>max_text_width:</strong>  The max number of characters in a segment before creating new lines in pretty mode.\nThe default is on the smaller end because the length only represents a segment and not the true\nline length.\nDefault: 80</li>\n<li><strong>comments:</strong>  Whether or not to preserve comments in the output SQL code.\nDefault: True</li>\n</ul>\n", "bases": "sqlglot.generator.Generator"}, "sqlglot.dialects.hive.Hive.Generator.LIMIT_FETCH": {"fullname": "sqlglot.dialects.hive.Hive.Generator.LIMIT_FETCH", "modulename": "sqlglot.dialects.hive", "qualname": "Hive.Generator.LIMIT_FETCH", "kind": "variable", "doc": "<p></p>\n", "default_value": "&#x27;LIMIT&#x27;"}, "sqlglot.dialects.hive.Hive.Generator.TABLESAMPLE_WITH_METHOD": {"fullname": "sqlglot.dialects.hive.Hive.Generator.TABLESAMPLE_WITH_METHOD", "modulename": "sqlglot.dialects.hive", "qualname": "Hive.Generator.TABLESAMPLE_WITH_METHOD", "kind": "variable", "doc": "<p></p>\n", "default_value": "False"}, "sqlglot.dialects.hive.Hive.Generator.TABLESAMPLE_SIZE_IS_PERCENT": {"fullname": "sqlglot.dialects.hive.Hive.Generator.TABLESAMPLE_SIZE_IS_PERCENT", "modulename": "sqlglot.dialects.hive", "qualname": "Hive.Generator.TABLESAMPLE_SIZE_IS_PERCENT", "kind": "variable", "doc": "<p></p>\n", "default_value": "True"}, "sqlglot.dialects.hive.Hive.Generator.JOIN_HINTS": {"fullname": "sqlglot.dialects.hive.Hive.Generator.JOIN_HINTS", "modulename": "sqlglot.dialects.hive", "qualname": "Hive.Generator.JOIN_HINTS", "kind": "variable", "doc": "<p></p>\n", "default_value": "False"}, "sqlglot.dialects.hive.Hive.Generator.TABLE_HINTS": {"fullname": "sqlglot.dialects.hive.Hive.Generator.TABLE_HINTS", "modulename": "sqlglot.dialects.hive", "qualname": "Hive.Generator.TABLE_HINTS", "kind": "variable", "doc": "<p></p>\n", "default_value": "False"}, "sqlglot.dialects.hive.Hive.Generator.QUERY_HINTS": {"fullname": "sqlglot.dialects.hive.Hive.Generator.QUERY_HINTS", "modulename": "sqlglot.dialects.hive", "qualname": "Hive.Generator.QUERY_HINTS", "kind": "variable", "doc": "<p></p>\n", "default_value": "False"}, "sqlglot.dialects.hive.Hive.Generator.INDEX_ON": {"fullname": "sqlglot.dialects.hive.Hive.Generator.INDEX_ON", "modulename": "sqlglot.dialects.hive", "qualname": "Hive.Generator.INDEX_ON", "kind": "variable", "doc": "<p></p>\n", "default_value": "&#x27;ON TABLE&#x27;"}, "sqlglot.dialects.hive.Hive.Generator.EXTRACT_ALLOWS_QUOTES": {"fullname": "sqlglot.dialects.hive.Hive.Generator.EXTRACT_ALLOWS_QUOTES", "modulename": "sqlglot.dialects.hive", "qualname": "Hive.Generator.EXTRACT_ALLOWS_QUOTES", "kind": "variable", "doc": "<p></p>\n", "default_value": "False"}, "sqlglot.dialects.hive.Hive.Generator.NVL2_SUPPORTED": {"fullname": "sqlglot.dialects.hive.Hive.Generator.NVL2_SUPPORTED", "modulename": "sqlglot.dialects.hive", "qualname": "Hive.Generator.NVL2_SUPPORTED", "kind": "variable", "doc": "<p></p>\n", "default_value": "False"}, "sqlglot.dialects.hive.Hive.Generator.TYPE_MAPPING": {"fullname": "sqlglot.dialects.hive.Hive.Generator.TYPE_MAPPING", "modulename": "sqlglot.dialects.hive", "qualname": "Hive.Generator.TYPE_MAPPING", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&lt;Type.NCHAR: &#x27;NCHAR&#x27;&gt;: &#x27;CHAR&#x27;, &lt;Type.NVARCHAR: &#x27;NVARCHAR&#x27;&gt;: &#x27;VARCHAR&#x27;, &lt;Type.MEDIUMTEXT: &#x27;MEDIUMTEXT&#x27;&gt;: &#x27;TEXT&#x27;, &lt;Type.LONGTEXT: &#x27;LONGTEXT&#x27;&gt;: &#x27;TEXT&#x27;, &lt;Type.TINYTEXT: &#x27;TINYTEXT&#x27;&gt;: &#x27;TEXT&#x27;, &lt;Type.MEDIUMBLOB: &#x27;MEDIUMBLOB&#x27;&gt;: &#x27;BLOB&#x27;, &lt;Type.LONGBLOB: &#x27;LONGBLOB&#x27;&gt;: &#x27;BLOB&#x27;, &lt;Type.TINYBLOB: &#x27;TINYBLOB&#x27;&gt;: &#x27;BLOB&#x27;, &lt;Type.INET: &#x27;INET&#x27;&gt;: &#x27;INET&#x27;, &lt;Type.BIT: &#x27;BIT&#x27;&gt;: &#x27;BOOLEAN&#x27;, &lt;Type.DATETIME: &#x27;DATETIME&#x27;&gt;: &#x27;TIMESTAMP&#x27;, &lt;Type.TEXT: &#x27;TEXT&#x27;&gt;: &#x27;STRING&#x27;, &lt;Type.TIME: &#x27;TIME&#x27;&gt;: &#x27;TIMESTAMP&#x27;, &lt;Type.TIMESTAMPTZ: &#x27;TIMESTAMPTZ&#x27;&gt;: &#x27;TIMESTAMP&#x27;, &lt;Type.VARBINARY: &#x27;VARBINARY&#x27;&gt;: &#x27;BINARY&#x27;}"}, "sqlglot.dialects.hive.Hive.Generator.TRANSFORMS": {"fullname": "sqlglot.dialects.hive.Hive.Generator.TRANSFORMS", "modulename": "sqlglot.dialects.hive", "qualname": "Hive.Generator.TRANSFORMS", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&lt;class &#x27;sqlglot.expressions.DateAdd&#x27;&gt;: &lt;function _add_date_sql&gt;, &lt;class &#x27;sqlglot.expressions.TsOrDsAdd&#x27;&gt;: &lt;function Hive.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.CaseSpecificColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.CharacterSetColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.CharacterSetProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.CheckColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.ClusteredColumnConstraint&#x27;&gt;: &lt;function Hive.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.CollateColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.CopyGrantsProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.CommentColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.DateFormatColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.DefaultColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.EncodeColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.ExecuteAsProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.ExternalProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.HeapProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.InlineLengthColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.InputModelProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.IntervalSpan&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.LanguageProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.LocationProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.LogProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.MaterializedProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.NoPrimaryIndexProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.NonClusteredColumnConstraint&#x27;&gt;: &lt;function Hive.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.NotForReplicationColumnConstraint&#x27;&gt;: &lt;function Hive.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.OnCommitProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.OnProperty&#x27;&gt;: &lt;function Hive.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.OnUpdateColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.OutputModelProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.PathColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.RemoteWithConnectionModelProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.ReturnsProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.SampleProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.SetProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.SettingsProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.SqlSecurityProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.StabilityProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.TemporaryProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.ToTableProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.TransientProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.TransformModelProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.TitleColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.UppercaseColumnConstraint&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.VarMap&#x27;&gt;: &lt;function var_map_sql&gt;, &lt;class &#x27;sqlglot.expressions.VolatileProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.WithJournalTableProperty&#x27;&gt;: &lt;function Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.Group&#x27;&gt;: &lt;function preprocess.&lt;locals&gt;._to_sql&gt;, &lt;class &#x27;sqlglot.expressions.Select&#x27;&gt;: &lt;function preprocess.&lt;locals&gt;._to_sql&gt;, &lt;class &#x27;sqlglot.expressions.Property&#x27;&gt;: &lt;function _property_sql&gt;, &lt;class &#x27;sqlglot.expressions.AnyValue&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.ApproxDistinct&#x27;&gt;: &lt;function approx_count_distinct_sql&gt;, &lt;class &#x27;sqlglot.expressions.ArrayConcat&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.ArrayJoin&#x27;&gt;: &lt;function Hive.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.ArraySize&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.ArraySort&#x27;&gt;: &lt;function _array_sort_sql&gt;, &lt;class &#x27;sqlglot.expressions.With&#x27;&gt;: &lt;function no_recursive_cte_sql&gt;, &lt;class &#x27;sqlglot.expressions.DateDiff&#x27;&gt;: &lt;function _date_diff_sql&gt;, &lt;class &#x27;sqlglot.expressions.DateStrToDate&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.DateSub&#x27;&gt;: &lt;function _add_date_sql&gt;, &lt;class &#x27;sqlglot.expressions.DateToDi&#x27;&gt;: &lt;function Hive.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.DiToDate&#x27;&gt;: &lt;function Hive.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.FileFormatProperty&#x27;&gt;: &lt;function Hive.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.FromBase64&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.If&#x27;&gt;: &lt;function if_sql.&lt;locals&gt;._if_sql&gt;, &lt;class &#x27;sqlglot.expressions.ILike&#x27;&gt;: &lt;function no_ilike_sql&gt;, &lt;class &#x27;sqlglot.expressions.IsNan&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.JSONExtract&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.JSONExtractScalar&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.JSONFormat&#x27;&gt;: &lt;function _json_format_sql&gt;, &lt;class &#x27;sqlglot.expressions.Left&#x27;&gt;: &lt;function left_to_substring_sql&gt;, &lt;class &#x27;sqlglot.expressions.Map&#x27;&gt;: &lt;function var_map_sql&gt;, &lt;class &#x27;sqlglot.expressions.Max&#x27;&gt;: &lt;function max_or_greatest&gt;, &lt;class &#x27;sqlglot.expressions.MD5Digest&#x27;&gt;: &lt;function Hive.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.Min&#x27;&gt;: &lt;function min_or_least&gt;, &lt;class &#x27;sqlglot.expressions.MonthsBetween&#x27;&gt;: &lt;function Hive.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.NotNullColumnConstraint&#x27;&gt;: &lt;function Hive.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.Create&#x27;&gt;: &lt;function _create_sql&gt;, &lt;class &#x27;sqlglot.expressions.Quantile&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.ApproxQuantile&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.RegexpExtract&#x27;&gt;: &lt;function regexp_extract_sql&gt;, &lt;class &#x27;sqlglot.expressions.RegexpReplace&#x27;&gt;: &lt;function regexp_replace_sql&gt;, &lt;class &#x27;sqlglot.expressions.RegexpLike&#x27;&gt;: &lt;function Hive.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.RegexpSplit&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.Right&#x27;&gt;: &lt;function right_to_substring_sql&gt;, &lt;class &#x27;sqlglot.expressions.SafeDivide&#x27;&gt;: &lt;function no_safe_divide_sql&gt;, &lt;class &#x27;sqlglot.expressions.SchemaCommentProperty&#x27;&gt;: &lt;function Hive.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.SetAgg&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.Split&#x27;&gt;: &lt;function Hive.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.StrPosition&#x27;&gt;: &lt;function strposition_to_locate_sql&gt;, &lt;class &#x27;sqlglot.expressions.StrToDate&#x27;&gt;: &lt;function _str_to_date_sql&gt;, &lt;class &#x27;sqlglot.expressions.StrToTime&#x27;&gt;: &lt;function _str_to_time_sql&gt;, &lt;class &#x27;sqlglot.expressions.StrToUnix&#x27;&gt;: &lt;function _str_to_unix_sql&gt;, &lt;class &#x27;sqlglot.expressions.StructExtract&#x27;&gt;: &lt;function struct_extract_sql&gt;, &lt;class &#x27;sqlglot.expressions.TimeStrToDate&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.TimeStrToTime&#x27;&gt;: &lt;function timestrtotime_sql&gt;, &lt;class &#x27;sqlglot.expressions.TimeStrToUnix&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.TimeToStr&#x27;&gt;: &lt;function _time_to_str&gt;, &lt;class &#x27;sqlglot.expressions.TimeToUnix&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.ToBase64&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.TsOrDiToDi&#x27;&gt;: &lt;function Hive.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.TsOrDsToDate&#x27;&gt;: &lt;function _to_date_sql&gt;, &lt;class &#x27;sqlglot.expressions.TryCast&#x27;&gt;: &lt;function no_trycast_sql&gt;, &lt;class &#x27;sqlglot.expressions.UnixToStr&#x27;&gt;: &lt;function Hive.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.UnixToTime&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.UnixToTimeStr&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.PartitionedByProperty&#x27;&gt;: &lt;function Hive.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.SerdeProperties&#x27;&gt;: &lt;function Hive.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.NumberToStr&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.LastDateOfMonth&#x27;&gt;: &lt;function rename_func.&lt;locals&gt;.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.National&#x27;&gt;: &lt;function Hive.Generator.&lt;lambda&gt;&gt;, &lt;class &#x27;sqlglot.expressions.PrimaryKeyColumnConstraint&#x27;&gt;: &lt;function Hive.Generator.&lt;lambda&gt;&gt;}"}, "sqlglot.dialects.hive.Hive.Generator.PROPERTIES_LOCATION": {"fullname": "sqlglot.dialects.hive.Hive.Generator.PROPERTIES_LOCATION", "modulename": "sqlglot.dialects.hive", "qualname": "Hive.Generator.PROPERTIES_LOCATION", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&lt;class &#x27;sqlglot.expressions.AlgorithmProperty&#x27;&gt;: &lt;Location.POST_CREATE: &#x27;POST_CREATE&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.AutoIncrementProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.BlockCompressionProperty&#x27;&gt;: &lt;Location.POST_NAME: &#x27;POST_NAME&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.CharacterSetProperty&#x27;&gt;: &lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;, &lt;class &#x27;sqlglot.expressions.ChecksumProperty&#x27;&gt;: