window.pdocSearch = (function(){
/** elasticlunr - http://weixsong.github.io * Copyright (C) 2017 Oliver Nightingale * Copyright (C) 2017 Wei Song * MIT Licensed */!function(){function e(e){if(null===e||"object"!=typeof e)return e;var t=e.constructor();for(var n in e)e.hasOwnProperty(n)&&(t[n]=e[n]);return t}var t=function(e){var n=new t.Index;return n.pipeline.add(t.trimmer,t.stopWordFilter,t.stemmer),e&&e.call(n,n),n};t.version="0.9.5",lunr=t,t.utils={},t.utils.warn=function(e){return function(t){e.console&&console.warn&&console.warn(t)}}(this),t.utils.toString=function(e){return void 0===e||null===e?"":e.toString()},t.EventEmitter=function(){this.events={}},t.EventEmitter.prototype.addListener=function(){var e=Array.prototype.slice.call(arguments),t=e.pop(),n=e;if("function"!=typeof t)throw new TypeError("last argument must be a function");n.forEach(function(e){this.hasHandler(e)||(this.events[e]=[]),this.events[e].push(t)},this)},t.EventEmitter.prototype.removeListener=function(e,t){if(this.hasHandler(e)){var n=this.events[e].indexOf(t);-1!==n&&(this.events[e].splice(n,1),0==this.events[e].length&&delete this.events[e])}},t.EventEmitter.prototype.emit=function(e){if(this.hasHandler(e)){var t=Array.prototype.slice.call(arguments,1);this.events[e].forEach(function(e){e.apply(void 0,t)},this)}},t.EventEmitter.prototype.hasHandler=function(e){return e in this.events},t.tokenizer=function(e){if(!arguments.length||null===e||void 0===e)return[];if(Array.isArray(e)){var n=e.filter(function(e){return null===e||void 0===e?!1:!0});n=n.map(function(e){return t.utils.toString(e).toLowerCase()});var i=[];return n.forEach(function(e){var n=e.split(t.tokenizer.seperator);i=i.concat(n)},this),i}return e.toString().trim().toLowerCase().split(t.tokenizer.seperator)},t.tokenizer.defaultSeperator=/[\s\-]+/,t.tokenizer.seperator=t.tokenizer.defaultSeperator,t.tokenizer.setSeperator=function(e){null!==e&&void 0!==e&&"object"==typeof e&&(t.tokenizer.seperator=e)},t.tokenizer.resetSeperator=function(){t.tokenizer.seperator=t.tokenizer.defaultSeperator},t.tokenizer.getSeperator=function(){return t.tokenizer.seperator},t.Pipeline=function(){this._queue=[]},t.Pipeline.registeredFunctions={},t.Pipeline.registerFunction=function(e,n){n in t.Pipeline.registeredFunctions&&t.utils.warn("Overwriting existing registered function: "+n),e.label=n,t.Pipeline.registeredFunctions[n]=e},t.Pipeline.getRegisteredFunction=function(e){return e in t.Pipeline.registeredFunctions!=!0?null:t.Pipeline.registeredFunctions[e]},t.Pipeline.warnIfFunctionNotRegistered=function(e){var n=e.label&&e.label in this.registeredFunctions;n||t.utils.warn("Function is not registered with pipeline. This may cause problems when serialising the index.\n",e)},t.Pipeline.load=function(e){var n=new t.Pipeline;return e.forEach(function(e){var i=t.Pipeline.getRegisteredFunction(e);if(!i)throw new Error("Cannot load un-registered function: "+e);n.add(i)}),n},t.Pipeline.prototype.add=function(){var e=Array.prototype.slice.call(arguments);e.forEach(function(e){t.Pipeline.warnIfFunctionNotRegistered(e),this._queue.push(e)},this)},t.Pipeline.prototype.after=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i+1,0,n)},t.Pipeline.prototype.before=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i,0,n)},t.Pipeline.prototype.remove=function(e){var t=this._queue.indexOf(e);-1!==t&&this._queue.splice(t,1)},t.Pipeline.prototype.run=function(e){for(var t=[],n=e.length,i=this._queue.length,o=0;n>o;o++){for(var r=e[o],s=0;i>s&&(r=this._queue[s](r,o,e),void 0!==r&&null!==r);s++);void 0!==r&&null!==r&&t.push(r)}return t},t.Pipeline.prototype.reset=function(){this._queue=[]},t.Pipeline.prototype.get=function(){return this._queue},t.Pipeline.prototype.toJSON=function(){return this._queue.map(function(e){return t.Pipeline.warnIfFunctionNotRegistered(e),e.label})},t.Index=function(){this._fields=[],this._ref="id",this.pipeline=new t.Pipeline,this.documentStore=new t.DocumentStore,this.index={},this.eventEmitter=new t.EventEmitter,this._idfCache={},this.on("add","remove","update",function(){this._idfCache={}}.bind(this))},t.Index.prototype.on=function(){var e=Array.prototype.slice.call(arguments);return this.eventEmitter.addListener.apply(this.eventEmitter,e)},t.Index.prototype.off=function(e,t){return this.eventEmitter.removeListener(e,t)},t.Index.load=function(e){e.version!==t.version&&t.utils.warn("version mismatch: current "+t.version+" importing "+e.version);var n=new this;n._fields=e.fields,n._ref=e.ref,n.documentStore=t.DocumentStore.load(e.documentStore),n.pipeline=t.Pipeline.load(e.pipeline),n.index={};for(var i in e.index)n.index[i]=t.InvertedIndex.load(e.index[i]);return n},t.Index.prototype.addField=function(e){return this._fields.push(e),this.index[e]=new t.InvertedIndex,this},t.Index.prototype.setRef=function(e){return this._ref=e,this},t.Index.prototype.saveDocument=function(e){return this.documentStore=new t.DocumentStore(e),this},t.Index.prototype.addDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.addDoc(i,e),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));this.documentStore.addFieldLength(i,n,o.length);var r={};o.forEach(function(e){e in r?r[e]+=1:r[e]=1},this);for(var s in r){var u=r[s];u=Math.sqrt(u),this.index[n].addToken(s,{ref:i,tf:u})}},this),n&&this.eventEmitter.emit("add",e,this)}},t.Index.prototype.removeDocByRef=function(e){if(e&&this.documentStore.isDocStored()!==!1&&this.documentStore.hasDoc(e)){var t=this.documentStore.getDoc(e);this.removeDoc(t,!1)}},t.Index.prototype.removeDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.hasDoc(i)&&(this.documentStore.removeDoc(i),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));o.forEach(function(e){this.index[n].removeToken(e,i)},this)},this),n&&this.eventEmitter.emit("remove",e,this))}},t.Index.prototype.updateDoc=function(e,t){var t=void 0===t?!0:t;this.removeDocByRef(e[this._ref],!1),this.addDoc(e,!1),t&&this.eventEmitter.emit("update",e,this)},t.Index.prototype.idf=function(e,t){var n="@"+t+"/"+e;if(Object.prototype.hasOwnProperty.call(this._idfCache,n))return this._idfCache[n];var i=this.index[t].getDocFreq(e),o=1+Math.log(this.documentStore.length/(i+1));return this._idfCache[n]=o,o},t.Index.prototype.getFields=function(){return this._fields.slice()},t.Index.prototype.search=function(e,n){if(!e)return[];e="string"==typeof e?{any:e}:JSON.parse(JSON.stringify(e));var i=null;null!=n&&(i=JSON.stringify(n));for(var o=new t.Configuration(i,this.getFields()).get(),r={},s=Object.keys(e),u=0;u<s.length;u++){var a=s[u];r[a]=this.pipeline.run(t.tokenizer(e[a]))}var l={};for(var c in o){var d=r[c]||r.any;if(d){var f=this.fieldSearch(d,c,o),h=o[c].boost;for(var p in f)f[p]=f[p]*h;for(var p in f)p in l?l[p]+=f[p]:l[p]=f[p]}}var v,g=[];for(var p in l)v={ref:p,score:l[p]},this.documentStore.hasDoc(p)&&(v.doc=this.documentStore.getDoc(p)),g.push(v);return g.sort(function(e,t){return t.score-e.score}),g},t.Index.prototype.fieldSearch=function(e,t,n){var i=n[t].bool,o=n[t].expand,r=n[t].boost,s=null,u={};return 0!==r?(e.forEach(function(e){var n=[e];1==o&&(n=this.index[t].expandToken(e));var r={};n.forEach(function(n){var o=this.index[t].getDocs(n),a=this.idf(n,t);if(s&&"AND"==i){var l={};for(var c in s)c in o&&(l[c]=o[c]);o=l}n==e&&this.fieldSearchStats(u,n,o);for(var c in o){var d=this.index[t].getTermFrequency(n,c),f=this.documentStore.getFieldLength(c,t),h=1;0!=f&&(h=1/Math.sqrt(f));var p=1;n!=e&&(p=.15*(1-(n.length-e.length)/n.length));var v=d*a*h*p;c in r?r[c]+=v:r[c]=v}},this),s=this.mergeScores(s,r,i)},this),s=this.coordNorm(s,u,e.length)):void 0},t.Index.prototype.mergeScores=function(e,t,n){if(!e)return t;if("AND"==n){var i={};for(var o in t)o in e&&(i[o]=e[o]+t[o]);return i}for(var o in t)o in e?e[o]+=t[o]:e[o]=t[o];return e},t.Index.prototype.fieldSearchStats=function(e,t,n){for(var i in n)i in e?e[i].push(t):e[i]=[t]},t.Index.prototype.coordNorm=function(e,t,n){for(var i in e)if(i in t){var o=t[i].length;e[i]=e[i]*o/n}return e},t.Index.prototype.toJSON=function(){var e={};return this._fields.forEach(function(t){e[t]=this.index[t].toJSON()},this),{version:t.version,fields:this._fields,ref:this._ref,documentStore:this.documentStore.toJSON(),index:e,pipeline:this.pipeline.toJSON()}},t.Index.prototype.use=function(e){var t=Array.prototype.slice.call(arguments,1);t.unshift(this),e.apply(this,t)},t.DocumentStore=function(e){this._save=null===e||void 0===e?!0:e,this.docs={},this.docInfo={},this.length=0},t.DocumentStore.load=function(e){var t=new this;return t.length=e.length,t.docs=e.docs,t.docInfo=e.docInfo,t._save=e.save,t},t.DocumentStore.prototype.isDocStored=function(){return this._save},t.DocumentStore.prototype.addDoc=function(t,n){this.hasDoc(t)||this.length++,this.docs[t]=this._save===!0?e(n):null},t.DocumentStore.prototype.getDoc=function(e){return this.hasDoc(e)===!1?null:this.docs[e]},t.DocumentStore.prototype.hasDoc=function(e){return e in this.docs},t.DocumentStore.prototype.removeDoc=function(e){this.hasDoc(e)&&(delete this.docs[e],delete this.docInfo[e],this.length--)},t.DocumentStore.prototype.addFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&(this.docInfo[e]||(this.docInfo[e]={}),this.docInfo[e][t]=n)},t.DocumentStore.prototype.updateFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&this.addFieldLength(e,t,n)},t.DocumentStore.prototype.getFieldLength=function(e,t){return null===e||void 0===e?0:e in this.docs&&t in this.docInfo[e]?this.docInfo[e][t]:0},t.DocumentStore.prototype.toJSON=function(){return{docs:this.docs,docInfo:this.docInfo,length:this.length,save:this._save}},t.stemmer=function(){var e={ational:"ate",tional:"tion",enci:"ence",anci:"ance",izer:"ize",bli:"ble",alli:"al",entli:"ent",eli:"e",ousli:"ous",ization:"ize",ation:"ate",ator:"ate",alism:"al",iveness:"ive",fulness:"ful",ousness:"ous",aliti:"al",iviti:"ive",biliti:"ble",logi:"log"},t={icate:"ic",ative:"",alize:"al",iciti:"ic",ical:"ic",ful:"",ness:""},n="[^aeiou]",i="[aeiouy]",o=n+"[^aeiouy]*",r=i+"[aeiou]*",s="^("+o+")?"+r+o,u="^("+o+")?"+r+o+"("+r+")?$",a="^("+o+")?"+r+o+r+o,l="^("+o+")?"+i,c=new RegExp(s),d=new RegExp(a),f=new RegExp(u),h=new RegExp(l),p=/^(.+?)(ss|i)es$/,v=/^(.+?)([^s])s$/,g=/^(.+?)eed$/,m=/^(.+?)(ed|ing)$/,y=/.$/,S=/(at|bl|iz)$/,x=new RegExp("([^aeiouylsz])\\1$"),w=new RegExp("^"+o+i+"[^aeiouwxy]$"),I=/^(.+?[^aeiou])y$/,b=/^(.+?)(ational|tional|enci|anci|izer|bli|alli|entli|eli|ousli|ization|ation|ator|alism|iveness|fulness|ousness|aliti|iviti|biliti|logi)$/,E=/^(.+?)(icate|ative|alize|iciti|ical|ful|ness)$/,D=/^(.+?)(al|ance|ence|er|ic|able|ible|ant|ement|ment|ent|ou|ism|ate|iti|ous|ive|ize)$/,F=/^(.+?)(s|t)(ion)$/,_=/^(.+?)e$/,P=/ll$/,k=new RegExp("^"+o+i+"[^aeiouwxy]$"),z=function(n){var i,o,r,s,u,a,l;if(n.length<3)return n;if(r=n.substr(0,1),"y"==r&&(n=r.toUpperCase()+n.substr(1)),s=p,u=v,s.test(n)?n=n.replace(s,"$1$2"):u.test(n)&&(n=n.replace(u,"$1$2")),s=g,u=m,s.test(n)){var z=s.exec(n);s=c,s.test(z[1])&&(s=y,n=n.replace(s,""))}else if(u.test(n)){var z=u.exec(n);i=z[1],u=h,u.test(i)&&(n=i,u=S,a=x,l=w,u.test(n)?n+="e":a.test(n)?(s=y,n=n.replace(s,"")):l.test(n)&&(n+="e"))}if(s=I,s.test(n)){var z=s.exec(n);i=z[1],n=i+"i"}if(s=b,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+e[o])}if(s=E,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+t[o])}if(s=D,u=F,s.test(n)){var z=s.exec(n);i=z[1],s=d,s.test(i)&&(n=i)}else if(u.test(n)){var z=u.exec(n);i=z[1]+z[2],u=d,u.test(i)&&(n=i)}if(s=_,s.test(n)){var z=s.exec(n);i=z[1],s=d,u=f,a=k,(s.test(i)||u.test(i)&&!a.test(i))&&(n=i)}return s=P,u=d,s.test(n)&&u.test(n)&&(s=y,n=n.replace(s,"")),"y"==r&&(n=r.toLowerCase()+n.substr(1)),n};return z}(),t.Pipeline.registerFunction(t.stemmer,"stemmer"),t.stopWordFilter=function(e){return e&&t.stopWordFilter.stopWords[e]!==!0?e:void 0},t.clearStopWords=function(){t.stopWordFilter.stopWords={}},t.addStopWords=function(e){null!=e&&Array.isArray(e)!==!1&&e.forEach(function(e){t.stopWordFilter.stopWords[e]=!0},this)},t.resetStopWords=function(){t.stopWordFilter.stopWords=t.defaultStopWords},t.defaultStopWords={"":!0,a:!0,able:!0,about:!0,across:!0,after:!0,all:!0,almost:!0,also:!0,am:!0,among:!0,an:!0,and:!0,any:!0,are:!0,as:!0,at:!0,be:!0,because:!0,been:!0,but:!0,by:!0,can:!0,cannot:!0,could:!0,dear:!0,did:!0,"do":!0,does:!0,either:!0,"else":!0,ever:!0,every:!0,"for":!0,from:!0,get:!0,got:!0,had:!0,has:!0,have:!0,he:!0,her:!0,hers:!0,him:!0,his:!0,how:!0,however:!0,i:!0,"if":!0,"in":!0,into:!0,is:!0,it:!0,its:!0,just:!0,least:!0,let:!0,like:!0,likely:!0,may:!0,me:!0,might:!0,most:!0,must:!0,my:!0,neither:!0,no:!0,nor:!0,not:!0,of:!0,off:!0,often:!0,on:!0,only:!0,or:!0,other:!0,our:!0,own:!0,rather:!0,said:!0,say:!0,says:!0,she:!0,should:!0,since:!0,so:!0,some:!0,than:!0,that:!0,the:!0,their:!0,them:!0,then:!0,there:!0,these:!0,they:!0,"this":!0,tis:!0,to:!0,too:!0,twas:!0,us:!0,wants:!0,was:!0,we:!0,were:!0,what:!0,when:!0,where:!0,which:!0,"while":!0,who:!0,whom:!0,why:!0,will:!0,"with":!0,would:!0,yet:!0,you:!0,your:!0},t.stopWordFilter.stopWords=t.defaultStopWords,t.Pipeline.registerFunction(t.stopWordFilter,"stopWordFilter"),t.trimmer=function(e){if(null===e||void 0===e)throw new Error("token should not be undefined");return e.replace(/^\W+/,"").replace(/\W+$/,"")},t.Pipeline.registerFunction(t.trimmer,"trimmer"),t.InvertedIndex=function(){this.root={docs:{},df:0}},t.InvertedIndex.load=function(e){var t=new this;return t.root=e.root,t},t.InvertedIndex.prototype.addToken=function(e,t,n){for(var n=n||this.root,i=0;i<=e.length-1;){var o=e[i];o in n||(n[o]={docs:{},df:0}),i+=1,n=n[o]}var r=t.ref;n.docs[r]?n.docs[r]={tf:t.tf}:(n.docs[r]={tf:t.tf},n.df+=1)},t.InvertedIndex.prototype.hasToken=function(e){if(!e)return!1;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return!1;t=t[e[n]]}return!0},t.InvertedIndex.prototype.getNode=function(e){if(!e)return null;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return null;t=t[e[n]]}return t},t.InvertedIndex.prototype.getDocs=function(e){var t=this.getNode(e);return null==t?{}:t.docs},t.InvertedIndex.prototype.getTermFrequency=function(e,t){var n=this.getNode(e);return null==n?0:t in n.docs?n.docs[t].tf:0},t.InvertedIndex.prototype.getDocFreq=function(e){var t=this.getNode(e);return null==t?0:t.df},t.InvertedIndex.prototype.removeToken=function(e,t){if(e){var n=this.getNode(e);null!=n&&t in n.docs&&(delete n.docs[t],n.df-=1)}},t.InvertedIndex.prototype.expandToken=function(e,t,n){if(null==e||""==e)return[];var t=t||[];if(void 0==n&&(n=this.getNode(e),null==n))return t;n.df>0&&t.push(e);for(var i in n)"docs"!==i&&"df"!==i&&this.expandToken(e+i,t,n[i]);return t},t.InvertedIndex.prototype.toJSON=function(){return{root:this.root}},t.Configuration=function(e,n){var e=e||"";if(void 0==n||null==n)throw new Error("fields should not be null");this.config={};var i;try{i=JSON.parse(e),this.buildUserConfig(i,n)}catch(o){t.utils.warn("user configuration parse failed, will use default configuration"),this.buildDefaultConfig(n)}},t.Configuration.prototype.buildDefaultConfig=function(e){this.reset(),e.forEach(function(e){this.config[e]={boost:1,bool:"OR",expand:!1}},this)},t.Configuration.prototype.buildUserConfig=function(e,n){var i="OR",o=!1;if(this.reset(),"bool"in e&&(i=e.bool||i),"expand"in e&&(o=e.expand||o),"fields"in e)for(var r in e.fields)if(n.indexOf(r)>-1){var s=e.fields[r],u=o;void 0!=s.expand&&(u=s.expand),this.config[r]={boost:s.boost||0===s.boost?s.boost:1,bool:s.bool||i,expand:u}}else t.utils.warn("field name in user configuration not found in index instance fields");else this.addAllFields2UserConfig(i,o,n)},t.Configuration.prototype.addAllFields2UserConfig=function(e,t,n){n.forEach(function(n){this.config[n]={boost:1,bool:e,expand:t}},this)},t.Configuration.prototype.get=function(){return this.config},t.Configuration.prototype.reset=function(){this.config={}},lunr.SortedSet=function(){this.length=0,this.elements=[]},lunr.SortedSet.load=function(e){var t=new this;return t.elements=e,t.length=e.length,t},lunr.SortedSet.prototype.add=function(){var e,t;for(e=0;e<arguments.length;e++)t=arguments[e],~this.indexOf(t)||this.elements.splice(this.locationFor(t),0,t);this.length=this.elements.length},lunr.SortedSet.prototype.toArray=function(){return this.elements.slice()},lunr.SortedSet.prototype.map=function(e,t){return this.elements.map(e,t)},lunr.SortedSet.prototype.forEach=function(e,t){return this.elements.forEach(e,t)},lunr.SortedSet.prototype.indexOf=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;){if(r===e)return o;e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o]}return r===e?o:-1},lunr.SortedSet.prototype.locationFor=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;)e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o];return r>e?o:e>r?o+1:void 0},lunr.SortedSet.prototype.intersect=function(e){for(var t=new lunr.SortedSet,n=0,i=0,o=this.length,r=e.length,s=this.elements,u=e.elements;;){if(n>o-1||i>r-1)break;s[n]!==u[i]?s[n]<u[i]?n++:s[n]>u[i]&&i++:(t.add(s[n]),n++,i++)}return t},lunr.SortedSet.prototype.clone=function(){var e=new lunr.SortedSet;return e.elements=this.toArray(),e.length=e.elements.length,e},lunr.SortedSet.prototype.union=function(e){var t,n,i;this.length>=e.length?(t=this,n=e):(t=e,n=this),i=t.clone();for(var o=0,r=n.toArray();o<r.length;o++)i.add(r[o]);return i},lunr.SortedSet.prototype.toJSON=function(){return this.toArray()},function(e,t){"function"==typeof define&&define.amd?define(t):"object"==typeof exports?module.exports=t():e.elasticlunr=t()}(this,function(){return t})}();
    /** pdoc search index */const docs = {"version": "0.9.5", "fields": ["qualname", "fullname", "annotation", "default_value", "signature", "bases", "doc"], "ref": "fullname", "documentStore": {"docs": {"sqlglot": {"fullname": "sqlglot", "modulename": "sqlglot", "kind": "module", "doc": "<p><img src=\"sqlglot.svg\" alt=\"SQLGlot logo\" /></p>\n\n<p>SQLGlot is a no-dependency SQL parser, transpiler, optimizer, and engine. It can be used to format SQL or translate between <a href=\"https://github.com/tobymao/sqlglot/blob/main/sqlglot/dialects/__init__.py\">19 different dialects</a> like <a href=\"https://duckdb.org/\">DuckDB</a>, <a href=\"https://prestodb.io/\">Presto</a>, <a href=\"https://spark.apache.org/\">Spark</a>, <a href=\"https://www.snowflake.com/en/\">Snowflake</a>, and <a href=\"https://cloud.google.com/bigquery/\">BigQuery</a>. It aims to read a wide variety of SQL inputs and output syntactically correct SQL in the targeted dialects.</p>\n\n<p>It is a very comprehensive generic SQL parser with a robust <a href=\"https://github.com/tobymao/sqlglot/blob/main/tests/\">test suite</a>. It is also quite <a href=\"#benchmarks\">performant</a>, while being written purely in Python.</p>\n\n<p>You can easily <a href=\"#custom-dialects\">customize</a> the parser, <a href=\"#metadata\">analyze</a> queries, traverse expression trees, and programmatically <a href=\"#build-and-modify-sql\">build</a> SQL.</p>\n\n<p>Syntax <a href=\"#parser-errors\">errors</a> are highlighted and dialect incompatibilities can warn or raise depending on configurations. However, it should be noted that SQL validation is not SQLGlot\u2019s goal, so some syntax errors may go unnoticed.</p>\n\n<p>Contributions are very welcome in SQLGlot; read the <a href=\"https://github.com/tobymao/sqlglot/blob/main/CONTRIBUTING.md\">contribution guide</a> to get started!</p>\n\n<h2 id=\"table-of-contents\">Table of Contents</h2>\n\n<ul>\n<li><a href=\"#install\">Install</a></li>\n<li><a href=\"#versioning\">Versioning</a></li>\n<li><a href=\"#get-in-touch\">Get in Touch</a></li>\n<li><a href=\"#examples\">Examples</a>\n<ul>\n<li><a href=\"#formatting-and-transpiling\">Formatting and Transpiling</a></li>\n<li><a href=\"#metadata\">Metadata</a></li>\n<li><a href=\"#parser-errors\">Parser Errors</a></li>\n<li><a href=\"#unsupported-errors\">Unsupported Errors</a></li>\n<li><a href=\"#build-and-modify-sql\">Build and Modify SQL</a></li>\n<li><a href=\"#sql-optimizer\">SQL Optimizer</a></li>\n<li><a href=\"#ast-introspection\">AST Introspection</a></li>\n<li><a href=\"#ast-diff\">AST Diff</a></li>\n<li><a href=\"#custom-dialects\">Custom Dialects</a></li>\n<li><a href=\"#sql-execution\">SQL Execution</a></li>\n</ul></li>\n<li><a href=\"#used-by\">Used By</a></li>\n<li><a href=\"#documentation\">Documentation</a></li>\n<li><a href=\"#run-tests-and-lint\">Run Tests and Lint</a></li>\n<li><a href=\"#benchmarks\">Benchmarks</a></li>\n<li><a href=\"#optional-dependencies\">Optional Dependencies</a></li>\n</ul>\n\n<h2 id=\"install\">Install</h2>\n\n<p>From PyPI:</p>\n\n<pre><code>pip3 install sqlglot\n</code></pre>\n\n<p>Or with a local checkout:</p>\n\n<pre><code>make install\n</code></pre>\n\n<p>Requirements for development (optional):</p>\n\n<pre><code>make install-dev\n</code></pre>\n\n<h2 id=\"versioning\">Versioning</h2>\n\n<p>Given a version number <code>MAJOR</code>.<code>MINOR</code>.<code>PATCH</code>, SQLGlot uses the following versioning strategy:</p>\n\n<ul>\n<li>The <code>PATCH</code> version is incremented when there are backwards-compatible fixes or feature additions.</li>\n<li>The <code>MINOR</code> version is incremented when there are backwards-incompatible fixes or feature additions.</li>\n<li>The <code>MAJOR</code> version is incremented when there are significant backwards-incompatible fixes or feature additions.</li>\n</ul>\n\n<h2 id=\"get-in-touch\">Get in Touch</h2>\n\n<p>We'd love to hear from you. Join our community <a href=\"https://tobikodata.com/slack\">Slack channel</a>!</p>\n\n<h2 id=\"examples\">Examples</h2>\n\n<h3 id=\"formatting-and-transpiling\">Formatting and Transpiling</h3>\n\n<p>Easily translate from one dialect to another. For example, date/time functions vary from dialects and can be hard to deal with:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"kn\">import</span> <span class=\"nn\">sqlglot</span>\n<span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">transpile</span><span class=\"p\">(</span><span class=\"s2\">&quot;SELECT EPOCH_MS(1618088028295)&quot;</span><span class=\"p\">,</span> <span class=\"n\">read</span><span class=\"o\">=</span><span class=\"s2\">&quot;duckdb&quot;</span><span class=\"p\">,</span> <span class=\"n\">write</span><span class=\"o\">=</span><span class=\"s2\">&quot;hive&quot;</span><span class=\"p\">)[</span><span class=\"mi\">0</span><span class=\"p\">]</span>\n</code></pre>\n</div>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"s1\">&#39;SELECT FROM_UNIXTIME(1618088028295 / 1000)&#39;</span>\n</code></pre>\n</div>\n\n<p>SQLGlot can even translate custom time formats:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"kn\">import</span> <span class=\"nn\">sqlglot</span>\n<span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">transpile</span><span class=\"p\">(</span><span class=\"s2\">&quot;SELECT STRFTIME(x, &#39;%y-%-m-%S&#39;)&quot;</span><span class=\"p\">,</span> <span class=\"n\">read</span><span class=\"o\">=</span><span class=\"s2\">&quot;duckdb&quot;</span><span class=\"p\">,</span> <span class=\"n\">write</span><span class=\"o\">=</span><span class=\"s2\">&quot;hive&quot;</span><span class=\"p\">)[</span><span class=\"mi\">0</span><span class=\"p\">]</span>\n</code></pre>\n</div>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"ss\">&quot;SELECT DATE_FORMAT(x, &#39;yy-M-ss&#39;)&quot;</span>\n</code></pre>\n</div>\n\n<p>As another example, let's suppose that we want to read in a SQL query that contains a CTE and a cast to <code>REAL</code>, and then transpile it to Spark, which uses backticks for identifiers and <code>FLOAT</code> instead of <code>REAL</code>:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"kn\">import</span> <span class=\"nn\">sqlglot</span>\n\n<span class=\"n\">sql</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;&quot;&quot;WITH baz AS (SELECT a, c FROM foo WHERE a = 1) SELECT f.a, b.b, baz.c, CAST(&quot;b&quot;.&quot;a&quot; AS REAL) d FROM foo f JOIN bar b ON f.a = b.a LEFT JOIN baz ON f.a = baz.a&quot;&quot;&quot;</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">transpile</span><span class=\"p\">(</span><span class=\"n\">sql</span><span class=\"p\">,</span> <span class=\"n\">write</span><span class=\"o\">=</span><span class=\"s2\">&quot;spark&quot;</span><span class=\"p\">,</span> <span class=\"n\">identify</span><span class=\"o\">=</span><span class=\"kc\">True</span><span class=\"p\">,</span> <span class=\"n\">pretty</span><span class=\"o\">=</span><span class=\"kc\">True</span><span class=\"p\">)[</span><span class=\"mi\">0</span><span class=\"p\">])</span>\n</code></pre>\n</div>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"k\">WITH</span><span class=\"w\"> </span><span class=\"o\">`</span><span class=\"n\">baz</span><span class=\"o\">`</span><span class=\"w\"> </span><span class=\"k\">AS</span><span class=\"w\"> </span><span class=\"p\">(</span>\n<span class=\"w\">  </span><span class=\"k\">SELECT</span>\n<span class=\"w\">    </span><span class=\"o\">`</span><span class=\"n\">a</span><span class=\"o\">`</span><span class=\"p\">,</span>\n<span class=\"w\">    </span><span class=\"o\">`</span><span class=\"k\">c</span><span class=\"o\">`</span>\n<span class=\"w\">  </span><span class=\"k\">FROM</span><span class=\"w\"> </span><span class=\"o\">`</span><span class=\"n\">foo</span><span class=\"o\">`</span>\n<span class=\"w\">  </span><span class=\"k\">WHERE</span>\n<span class=\"w\">    </span><span class=\"o\">`</span><span class=\"n\">a</span><span class=\"o\">`</span><span class=\"w\"> </span><span class=\"o\">=</span><span class=\"w\"> </span><span class=\"mi\">1</span>\n<span class=\"p\">)</span>\n<span class=\"k\">SELECT</span>\n<span class=\"w\">  </span><span class=\"o\">`</span><span class=\"n\">f</span><span class=\"o\">`</span><span class=\"p\">.</span><span class=\"o\">`</span><span class=\"n\">a</span><span class=\"o\">`</span><span class=\"p\">,</span>\n<span class=\"w\">  </span><span class=\"o\">`</span><span class=\"n\">b</span><span class=\"o\">`</span><span class=\"p\">.</span><span class=\"o\">`</span><span class=\"n\">b</span><span class=\"o\">`</span><span class=\"p\">,</span>\n<span class=\"w\">  </span><span class=\"o\">`</span><span class=\"n\">baz</span><span class=\"o\">`</span><span class=\"p\">.</span><span class=\"o\">`</span><span class=\"k\">c</span><span class=\"o\">`</span><span class=\"p\">,</span>\n<span class=\"w\">  </span><span class=\"k\">CAST</span><span class=\"p\">(</span><span class=\"o\">`</span><span class=\"n\">b</span><span class=\"o\">`</span><span class=\"p\">.</span><span class=\"o\">`</span><span class=\"n\">a</span><span class=\"o\">`</span><span class=\"w\"> </span><span class=\"k\">AS</span><span class=\"w\"> </span><span class=\"nb\">FLOAT</span><span class=\"p\">)</span><span class=\"w\"> </span><span class=\"k\">AS</span><span class=\"w\"> </span><span class=\"o\">`</span><span class=\"n\">d</span><span class=\"o\">`</span>\n<span class=\"k\">FROM</span><span class=\"w\"> </span><span class=\"o\">`</span><span class=\"n\">foo</span><span class=\"o\">`</span><span class=\"w\"> </span><span class=\"k\">AS</span><span class=\"w\"> </span><span class=\"o\">`</span><span class=\"n\">f</span><span class=\"o\">`</span>\n<span class=\"k\">JOIN</span><span class=\"w\"> </span><span class=\"o\">`</span><span class=\"n\">bar</span><span class=\"o\">`</span><span class=\"w\"> </span><span class=\"k\">AS</span><span class=\"w\"> </span><span class=\"o\">`</span><span class=\"n\">b</span><span class=\"o\">`</span>\n<span class=\"w\">  </span><span class=\"k\">ON</span><span class=\"w\"> </span><span class=\"o\">`</span><span class=\"n\">f</span><span class=\"o\">`</span><span class=\"p\">.</span><span class=\"o\">`</span><span class=\"n\">a</span><span class=\"o\">`</span><span class=\"w\"> </span><span class=\"o\">=</span><span class=\"w\"> </span><span class=\"o\">`</span><span class=\"n\">b</span><span class=\"o\">`</span><span class=\"p\">.</span><span class=\"o\">`</span><span class=\"n\">a</span><span class=\"o\">`</span>\n<span class=\"k\">LEFT</span><span class=\"w\"> </span><span class=\"k\">JOIN</span><span class=\"w\"> </span><span class=\"o\">`</span><span class=\"n\">baz</span><span class=\"o\">`</span>\n<span class=\"w\">  </span><span class=\"k\">ON</span><span class=\"w\"> </span><span class=\"o\">`</span><span class=\"n\">f</span><span class=\"o\">`</span><span class=\"p\">.</span><span class=\"o\">`</span><span class=\"n\">a</span><span class=\"o\">`</span><span class=\"w\"> </span><span class=\"o\">=</span><span class=\"w\"> </span><span class=\"o\">`</span><span class=\"n\">baz</span><span class=\"o\">`</span><span class=\"p\">.</span><span class=\"o\">`</span><span class=\"n\">a</span><span class=\"o\">`</span>\n</code></pre>\n</div>\n\n<p>Comments are also preserved in a best-effort basis when transpiling SQL code:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"n\">sql</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;&quot;&quot;</span>\n<span class=\"s2\">/* multi</span>\n<span class=\"s2\">   line</span>\n<span class=\"s2\">   comment</span>\n<span class=\"s2\">*/</span>\n<span class=\"s2\">SELECT</span>\n<span class=\"s2\">  tbl.cola /* comment 1 */ + tbl.colb /* comment 2 */,</span>\n<span class=\"s2\">  CAST(x AS INT), # comment 3</span>\n<span class=\"s2\">  y               -- comment 4</span>\n<span class=\"s2\">FROM</span>\n<span class=\"s2\">  bar /* comment 5 */,</span>\n<span class=\"s2\">  tbl #          comment 6</span>\n<span class=\"s2\">&quot;&quot;&quot;</span>\n\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">transpile</span><span class=\"p\">(</span><span class=\"n\">sql</span><span class=\"p\">,</span> <span class=\"n\">read</span><span class=\"o\">=</span><span class=\"s1\">&#39;mysql&#39;</span><span class=\"p\">,</span> <span class=\"n\">pretty</span><span class=\"o\">=</span><span class=\"kc\">True</span><span class=\"p\">)[</span><span class=\"mi\">0</span><span class=\"p\">])</span>\n</code></pre>\n</div>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"cm\">/* multi</span>\n<span class=\"cm\">   line</span>\n<span class=\"cm\">   comment</span>\n<span class=\"cm\">*/</span>\n<span class=\"k\">SELECT</span>\n<span class=\"w\">  </span><span class=\"n\">tbl</span><span class=\"p\">.</span><span class=\"n\">cola</span><span class=\"w\"> </span><span class=\"cm\">/* comment 1 */</span><span class=\"w\"> </span><span class=\"o\">+</span><span class=\"w\"> </span><span class=\"n\">tbl</span><span class=\"p\">.</span><span class=\"n\">colb</span><span class=\"w\"> </span><span class=\"cm\">/* comment 2 */</span><span class=\"p\">,</span>\n<span class=\"w\">  </span><span class=\"k\">CAST</span><span class=\"p\">(</span><span class=\"n\">x</span><span class=\"w\"> </span><span class=\"k\">AS</span><span class=\"w\"> </span><span class=\"nb\">INT</span><span class=\"p\">),</span><span class=\"w\"> </span><span class=\"cm\">/* comment 3 */</span>\n<span class=\"w\">  </span><span class=\"n\">y</span><span class=\"w\"> </span><span class=\"cm\">/* comment 4 */</span>\n<span class=\"k\">FROM</span><span class=\"w\"> </span><span class=\"n\">bar</span><span class=\"w\"> </span><span class=\"cm\">/* comment 5 */</span><span class=\"p\">,</span><span class=\"w\"> </span><span class=\"n\">tbl</span><span class=\"w\"> </span><span class=\"cm\">/*          comment 6 */</span>\n</code></pre>\n</div>\n\n<h3 id=\"metadata\">Metadata</h3>\n\n<p>You can explore SQL with expression helpers to do things like find columns and tables:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"kn\">from</span> <span class=\"nn\">sqlglot</span> <span class=\"kn\">import</span> <span class=\"n\">parse_one</span><span class=\"p\">,</span> <span class=\"n\">exp</span>\n\n<span class=\"c1\"># print all column references (a and b)</span>\n<span class=\"k\">for</span> <span class=\"n\">column</span> <span class=\"ow\">in</span> <span class=\"n\">parse_one</span><span class=\"p\">(</span><span class=\"s2\">&quot;SELECT a, b + 1 AS c FROM d&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">find_all</span><span class=\"p\">(</span><span class=\"n\">exp</span><span class=\"o\">.</span><span class=\"n\">Column</span><span class=\"p\">):</span>\n    <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">alias_or_name</span><span class=\"p\">)</span>\n\n<span class=\"c1\"># find all projections in select statements (a and c)</span>\n<span class=\"k\">for</span> <span class=\"n\">select</span> <span class=\"ow\">in</span> <span class=\"n\">parse_one</span><span class=\"p\">(</span><span class=\"s2\">&quot;SELECT a, b + 1 AS c FROM d&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">find_all</span><span class=\"p\">(</span><span class=\"n\">exp</span><span class=\"o\">.</span><span class=\"n\">Select</span><span class=\"p\">):</span>\n    <span class=\"k\">for</span> <span class=\"n\">projection</span> <span class=\"ow\">in</span> <span class=\"n\">select</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"p\">:</span>\n        <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"n\">projection</span><span class=\"o\">.</span><span class=\"n\">alias_or_name</span><span class=\"p\">)</span>\n\n<span class=\"c1\"># find all tables (x, y, z)</span>\n<span class=\"k\">for</span> <span class=\"n\">table</span> <span class=\"ow\">in</span> <span class=\"n\">parse_one</span><span class=\"p\">(</span><span class=\"s2\">&quot;SELECT * FROM x JOIN y JOIN z&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">find_all</span><span class=\"p\">(</span><span class=\"n\">exp</span><span class=\"o\">.</span><span class=\"n\">Table</span><span class=\"p\">):</span>\n    <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"n\">table</span><span class=\"o\">.</span><span class=\"n\">name</span><span class=\"p\">)</span>\n</code></pre>\n</div>\n\n<h3 id=\"parser-errors\">Parser Errors</h3>\n\n<p>When the parser detects an error in the syntax, it raises a ParserError:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"kn\">import</span> <span class=\"nn\">sqlglot</span>\n<span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">transpile</span><span class=\"p\">(</span><span class=\"s2\">&quot;SELECT foo( FROM bar&quot;</span><span class=\"p\">)</span>\n</code></pre>\n</div>\n\n<pre><code>sqlglot.errors.ParseError: Expecting ). Line 1, Col: 13.\n  select foo( FROM bar\n              ~~~~\n</code></pre>\n\n<p>Structured syntax errors are accessible for programmatic use:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"kn\">import</span> <span class=\"nn\">sqlglot</span>\n<span class=\"k\">try</span><span class=\"p\">:</span>\n    <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">transpile</span><span class=\"p\">(</span><span class=\"s2\">&quot;SELECT foo( FROM bar&quot;</span><span class=\"p\">)</span>\n<span class=\"k\">except</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">errors</span><span class=\"o\">.</span><span class=\"n\">ParseError</span> <span class=\"k\">as</span> <span class=\"n\">e</span><span class=\"p\">:</span>\n    <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"n\">e</span><span class=\"o\">.</span><span class=\"n\">errors</span><span class=\"p\">)</span>\n</code></pre>\n</div>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"p\">[{</span>\n  <span class=\"s1\">&#39;description&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;Expecting )&#39;</span><span class=\"p\">,</span>\n  <span class=\"s1\">&#39;line&#39;</span><span class=\"p\">:</span> <span class=\"mi\">1</span><span class=\"p\">,</span>\n  <span class=\"s1\">&#39;col&#39;</span><span class=\"p\">:</span> <span class=\"mi\">13</span><span class=\"p\">,</span>\n  <span class=\"s1\">&#39;start_context&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;SELECT foo( &#39;</span><span class=\"p\">,</span>\n  <span class=\"s1\">&#39;highlight&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;FROM&#39;</span><span class=\"p\">,</span>\n  <span class=\"s1\">&#39;end_context&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39; bar&#39;</span>\n<span class=\"p\">}]</span>\n</code></pre>\n</div>\n\n<h3 id=\"unsupported-errors\">Unsupported Errors</h3>\n\n<p>Presto <code>APPROX_DISTINCT</code> supports the accuracy argument which is not supported in Hive:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"kn\">import</span> <span class=\"nn\">sqlglot</span>\n<span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">transpile</span><span class=\"p\">(</span><span class=\"s2\">&quot;SELECT APPROX_DISTINCT(a, 0.1) FROM foo&quot;</span><span class=\"p\">,</span> <span class=\"n\">read</span><span class=\"o\">=</span><span class=\"s2\">&quot;presto&quot;</span><span class=\"p\">,</span> <span class=\"n\">write</span><span class=\"o\">=</span><span class=\"s2\">&quot;hive&quot;</span><span class=\"p\">)</span>\n</code></pre>\n</div>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"n\">APPROX_COUNT_DISTINCT</span><span class=\"w\"> </span><span class=\"n\">does</span><span class=\"w\"> </span><span class=\"k\">not</span><span class=\"w\"> </span><span class=\"n\">support</span><span class=\"w\"> </span><span class=\"n\">accuracy</span>\n<span class=\"s1\">&#39;SELECT APPROX_COUNT_DISTINCT(a) FROM foo&#39;</span>\n</code></pre>\n</div>\n\n<h3 id=\"build-and-modify-sql\">Build and Modify SQL</h3>\n\n<p>SQLGlot supports incrementally building sql expressions:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"kn\">from</span> <span class=\"nn\">sqlglot</span> <span class=\"kn\">import</span> <span class=\"n\">select</span><span class=\"p\">,</span> <span class=\"n\">condition</span>\n\n<span class=\"n\">where</span> <span class=\"o\">=</span> <span class=\"n\">condition</span><span class=\"p\">(</span><span class=\"s2\">&quot;x=1&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">and_</span><span class=\"p\">(</span><span class=\"s2\">&quot;y=1&quot;</span><span class=\"p\">)</span>\n<span class=\"n\">select</span><span class=\"p\">(</span><span class=\"s2\">&quot;*&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">from_</span><span class=\"p\">(</span><span class=\"s2\">&quot;y&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">where</span><span class=\"p\">(</span><span class=\"n\">where</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">()</span>\n</code></pre>\n</div>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"s1\">&#39;SELECT * FROM y WHERE x = 1 AND y = 1&#39;</span>\n</code></pre>\n</div>\n\n<p>You can also modify a parsed tree:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"kn\">from</span> <span class=\"nn\">sqlglot</span> <span class=\"kn\">import</span> <span class=\"n\">parse_one</span>\n<span class=\"n\">parse_one</span><span class=\"p\">(</span><span class=\"s2\">&quot;SELECT x FROM y&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">from_</span><span class=\"p\">(</span><span class=\"s2\">&quot;z&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">()</span>\n</code></pre>\n</div>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"s1\">&#39;SELECT x FROM y, z&#39;</span>\n</code></pre>\n</div>\n\n<p>There is also a way to recursively transform the parsed tree by applying a mapping function to each tree node:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"kn\">from</span> <span class=\"nn\">sqlglot</span> <span class=\"kn\">import</span> <span class=\"n\">exp</span><span class=\"p\">,</span> <span class=\"n\">parse_one</span>\n\n<span class=\"n\">expression_tree</span> <span class=\"o\">=</span> <span class=\"n\">parse_one</span><span class=\"p\">(</span><span class=\"s2\">&quot;SELECT a FROM x&quot;</span><span class=\"p\">)</span>\n\n<span class=\"k\">def</span> <span class=\"nf\">transformer</span><span class=\"p\">(</span><span class=\"n\">node</span><span class=\"p\">):</span>\n    <span class=\"k\">if</span> <span class=\"nb\">isinstance</span><span class=\"p\">(</span><span class=\"n\">node</span><span class=\"p\">,</span> <span class=\"n\">exp</span><span class=\"o\">.</span><span class=\"n\">Column</span><span class=\"p\">)</span> <span class=\"ow\">and</span> <span class=\"n\">node</span><span class=\"o\">.</span><span class=\"n\">name</span> <span class=\"o\">==</span> <span class=\"s2\">&quot;a&quot;</span><span class=\"p\">:</span>\n        <span class=\"k\">return</span> <span class=\"n\">parse_one</span><span class=\"p\">(</span><span class=\"s2\">&quot;FUN(a)&quot;</span><span class=\"p\">)</span>\n    <span class=\"k\">return</span> <span class=\"n\">node</span>\n\n<span class=\"n\">transformed_tree</span> <span class=\"o\">=</span> <span class=\"n\">expression_tree</span><span class=\"o\">.</span><span class=\"n\">transform</span><span class=\"p\">(</span><span class=\"n\">transformer</span><span class=\"p\">)</span>\n<span class=\"n\">transformed_tree</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">()</span>\n</code></pre>\n</div>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"s1\">&#39;SELECT FUN(a) FROM x&#39;</span>\n</code></pre>\n</div>\n\n<h3 id=\"sql-optimizer\">SQL Optimizer</h3>\n\n<p>SQLGlot can rewrite queries into an \"optimized\" form. It performs a variety of <a href=\"https://github.com/tobymao/sqlglot/blob/main/sqlglot/optimizer/optimizer.py\">techniques</a> to create a new canonical AST. This AST can be used to standardize queries or provide the foundations for implementing an actual engine. For example:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"kn\">import</span> <span class=\"nn\">sqlglot</span>\n<span class=\"kn\">from</span> <span class=\"nn\">sqlglot.optimizer</span> <span class=\"kn\">import</span> <span class=\"n\">optimize</span>\n\n<span class=\"nb\">print</span><span class=\"p\">(</span>\n    <span class=\"n\">optimize</span><span class=\"p\">(</span>\n        <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">parse_one</span><span class=\"p\">(</span><span class=\"s2\">&quot;&quot;&quot;</span>\n<span class=\"s2\">            SELECT A OR (B OR (C AND D))</span>\n<span class=\"s2\">            FROM x</span>\n<span class=\"s2\">            WHERE Z = date &#39;2021-01-01&#39; + INTERVAL &#39;1&#39; month OR 1 = 0</span>\n<span class=\"s2\">        &quot;&quot;&quot;</span><span class=\"p\">),</span>\n        <span class=\"n\">schema</span><span class=\"o\">=</span><span class=\"p\">{</span><span class=\"s2\">&quot;x&quot;</span><span class=\"p\">:</span> <span class=\"p\">{</span><span class=\"s2\">&quot;A&quot;</span><span class=\"p\">:</span> <span class=\"s2\">&quot;INT&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;B&quot;</span><span class=\"p\">:</span> <span class=\"s2\">&quot;INT&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;C&quot;</span><span class=\"p\">:</span> <span class=\"s2\">&quot;INT&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;D&quot;</span><span class=\"p\">:</span> <span class=\"s2\">&quot;INT&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Z&quot;</span><span class=\"p\">:</span> <span class=\"s2\">&quot;STRING&quot;</span><span class=\"p\">}}</span>\n    <span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">(</span><span class=\"n\">pretty</span><span class=\"o\">=</span><span class=\"kc\">True</span><span class=\"p\">)</span>\n<span class=\"p\">)</span>\n</code></pre>\n</div>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"k\">SELECT</span>\n<span class=\"w\">  </span><span class=\"p\">(</span>\n<span class=\"w\">    </span><span class=\"ss\">&quot;x&quot;</span><span class=\"p\">.</span><span class=\"ss\">&quot;a&quot;</span><span class=\"w\"> </span><span class=\"o\">&lt;&gt;</span><span class=\"w\"> </span><span class=\"mi\">0</span><span class=\"w\"> </span><span class=\"k\">OR</span><span class=\"w\"> </span><span class=\"ss\">&quot;x&quot;</span><span class=\"p\">.</span><span class=\"ss\">&quot;b&quot;</span><span class=\"w\"> </span><span class=\"o\">&lt;&gt;</span><span class=\"w\"> </span><span class=\"mi\">0</span><span class=\"w\"> </span><span class=\"k\">OR</span><span class=\"w\"> </span><span class=\"ss\">&quot;x&quot;</span><span class=\"p\">.</span><span class=\"ss\">&quot;c&quot;</span><span class=\"w\"> </span><span class=\"o\">&lt;&gt;</span><span class=\"w\"> </span><span class=\"mi\">0</span>\n<span class=\"w\">  </span><span class=\"p\">)</span>\n<span class=\"w\">  </span><span class=\"k\">AND</span><span class=\"w\"> </span><span class=\"p\">(</span>\n<span class=\"w\">    </span><span class=\"ss\">&quot;x&quot;</span><span class=\"p\">.</span><span class=\"ss\">&quot;a&quot;</span><span class=\"w\"> </span><span class=\"o\">&lt;&gt;</span><span class=\"w\"> </span><span class=\"mi\">0</span><span class=\"w\"> </span><span class=\"k\">OR</span><span class=\"w\"> </span><span class=\"ss\">&quot;x&quot;</span><span class=\"p\">.</span><span class=\"ss\">&quot;b&quot;</span><span class=\"w\"> </span><span class=\"o\">&lt;&gt;</span><span class=\"w\"> </span><span class=\"mi\">0</span><span class=\"w\"> </span><span class=\"k\">OR</span><span class=\"w\"> </span><span class=\"ss\">&quot;x&quot;</span><span class=\"p\">.</span><span class=\"ss\">&quot;d&quot;</span><span class=\"w\"> </span><span class=\"o\">&lt;&gt;</span><span class=\"w\"> </span><span class=\"mi\">0</span>\n<span class=\"w\">  </span><span class=\"p\">)</span><span class=\"w\"> </span><span class=\"k\">AS</span><span class=\"w\"> </span><span class=\"ss\">&quot;_col_0&quot;</span>\n<span class=\"k\">FROM</span><span class=\"w\"> </span><span class=\"ss\">&quot;x&quot;</span><span class=\"w\"> </span><span class=\"k\">AS</span><span class=\"w\"> </span><span class=\"ss\">&quot;x&quot;</span>\n<span class=\"k\">WHERE</span>\n<span class=\"w\">  </span><span class=\"k\">CAST</span><span class=\"p\">(</span><span class=\"ss\">&quot;x&quot;</span><span class=\"p\">.</span><span class=\"ss\">&quot;z&quot;</span><span class=\"w\"> </span><span class=\"k\">AS</span><span class=\"w\"> </span><span class=\"nb\">DATE</span><span class=\"p\">)</span><span class=\"w\"> </span><span class=\"o\">=</span><span class=\"w\"> </span><span class=\"k\">CAST</span><span class=\"p\">(</span><span class=\"s1\">&#39;2021-02-01&#39;</span><span class=\"w\"> </span><span class=\"k\">AS</span><span class=\"w\"> </span><span class=\"nb\">DATE</span><span class=\"p\">)</span>\n</code></pre>\n</div>\n\n<h3 id=\"ast-introspection\">AST Introspection</h3>\n\n<p>You can see the AST version of the sql by calling <code>repr</code>:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"kn\">from</span> <span class=\"nn\">sqlglot</span> <span class=\"kn\">import</span> <span class=\"n\">parse_one</span>\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"nb\">repr</span><span class=\"p\">(</span><span class=\"n\">parse_one</span><span class=\"p\">(</span><span class=\"s2\">&quot;SELECT a + 1 AS z&quot;</span><span class=\"p\">)))</span>\n</code></pre>\n</div>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"p\">(</span><span class=\"n\">SELECT</span> <span class=\"n\">expressions</span><span class=\"p\">:</span>\n  <span class=\"p\">(</span><span class=\"n\">ALIAS</span> <span class=\"n\">this</span><span class=\"p\">:</span>\n    <span class=\"p\">(</span><span class=\"n\">ADD</span> <span class=\"n\">this</span><span class=\"p\">:</span>\n      <span class=\"p\">(</span><span class=\"n\">COLUMN</span> <span class=\"n\">this</span><span class=\"p\">:</span>\n        <span class=\"p\">(</span><span class=\"n\">IDENTIFIER</span> <span class=\"n\">this</span><span class=\"p\">:</span> <span class=\"n\">a</span><span class=\"p\">,</span> <span class=\"n\">quoted</span><span class=\"p\">:</span> <span class=\"kc\">False</span><span class=\"p\">)),</span> <span class=\"n\">expression</span><span class=\"p\">:</span>\n      <span class=\"p\">(</span><span class=\"n\">LITERAL</span> <span class=\"n\">this</span><span class=\"p\">:</span> <span class=\"mi\">1</span><span class=\"p\">,</span> <span class=\"n\">is_string</span><span class=\"p\">:</span> <span class=\"kc\">False</span><span class=\"p\">)),</span> <span class=\"n\">alias</span><span class=\"p\">:</span>\n    <span class=\"p\">(</span><span class=\"n\">IDENTIFIER</span> <span class=\"n\">this</span><span class=\"p\">:</span> <span class=\"n\">z</span><span class=\"p\">,</span> <span class=\"n\">quoted</span><span class=\"p\">:</span> <span class=\"kc\">False</span><span class=\"p\">)))</span>\n</code></pre>\n</div>\n\n<h3 id=\"ast-diff\">AST Diff</h3>\n\n<p>SQLGlot can calculate the difference between two expressions and output changes in a form of a sequence of actions needed to transform a source expression into a target one:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"kn\">from</span> <span class=\"nn\">sqlglot</span> <span class=\"kn\">import</span> <span class=\"n\">diff</span><span class=\"p\">,</span> <span class=\"n\">parse_one</span>\n<span class=\"n\">diff</span><span class=\"p\">(</span><span class=\"n\">parse_one</span><span class=\"p\">(</span><span class=\"s2\">&quot;SELECT a + b, c, d&quot;</span><span class=\"p\">),</span> <span class=\"n\">parse_one</span><span class=\"p\">(</span><span class=\"s2\">&quot;SELECT c, a - b, d&quot;</span><span class=\"p\">))</span>\n</code></pre>\n</div>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"p\">[</span>\n  <span class=\"n\">Remove</span><span class=\"p\">(</span><span class=\"n\">expression</span><span class=\"o\">=</span><span class=\"p\">(</span><span class=\"n\">ADD</span> <span class=\"n\">this</span><span class=\"p\">:</span>\n    <span class=\"p\">(</span><span class=\"n\">COLUMN</span> <span class=\"n\">this</span><span class=\"p\">:</span>\n      <span class=\"p\">(</span><span class=\"n\">IDENTIFIER</span> <span class=\"n\">this</span><span class=\"p\">:</span> <span class=\"n\">a</span><span class=\"p\">,</span> <span class=\"n\">quoted</span><span class=\"p\">:</span> <span class=\"kc\">False</span><span class=\"p\">)),</span> <span class=\"n\">expression</span><span class=\"p\">:</span>\n    <span class=\"p\">(</span><span class=\"n\">COLUMN</span> <span class=\"n\">this</span><span class=\"p\">:</span>\n      <span class=\"p\">(</span><span class=\"n\">IDENTIFIER</span> <span class=\"n\">this</span><span class=\"p\">:</span> <span class=\"n\">b</span><span class=\"p\">,</span> <span class=\"n\">quoted</span><span class=\"p\">:</span> <span class=\"kc\">False</span><span class=\"p\">)))),</span>\n  <span class=\"n\">Insert</span><span class=\"p\">(</span><span class=\"n\">expression</span><span class=\"o\">=</span><span class=\"p\">(</span><span class=\"n\">SUB</span> <span class=\"n\">this</span><span class=\"p\">:</span>\n    <span class=\"p\">(</span><span class=\"n\">COLUMN</span> <span class=\"n\">this</span><span class=\"p\">:</span>\n      <span class=\"p\">(</span><span class=\"n\">IDENTIFIER</span> <span class=\"n\">this</span><span class=\"p\">:</span> <span class=\"n\">a</span><span class=\"p\">,</span> <span class=\"n\">quoted</span><span class=\"p\">:</span> <span class=\"kc\">False</span><span class=\"p\">)),</span> <span class=\"n\">expression</span><span class=\"p\">:</span>\n    <span class=\"p\">(</span><span class=\"n\">COLUMN</span> <span class=\"n\">this</span><span class=\"p\">:</span>\n      <span class=\"p\">(</span><span class=\"n\">IDENTIFIER</span> <span class=\"n\">this</span><span class=\"p\">:</span> <span class=\"n\">b</span><span class=\"p\">,</span> <span class=\"n\">quoted</span><span class=\"p\">:</span> <span class=\"kc\">False</span><span class=\"p\">)))),</span>\n  <span class=\"n\">Move</span><span class=\"p\">(</span><span class=\"n\">expression</span><span class=\"o\">=</span><span class=\"p\">(</span><span class=\"n\">COLUMN</span> <span class=\"n\">this</span><span class=\"p\">:</span>\n    <span class=\"p\">(</span><span class=\"n\">IDENTIFIER</span> <span class=\"n\">this</span><span class=\"p\">:</span> <span class=\"n\">c</span><span class=\"p\">,</span> <span class=\"n\">quoted</span><span class=\"p\">:</span> <span class=\"kc\">False</span><span class=\"p\">))),</span>\n  <span class=\"n\">Keep</span><span class=\"p\">(</span><span class=\"n\">source</span><span class=\"o\">=</span><span class=\"p\">(</span><span class=\"n\">IDENTIFIER</span> <span class=\"n\">this</span><span class=\"p\">:</span> <span class=\"n\">b</span><span class=\"p\">,</span> <span class=\"n\">quoted</span><span class=\"p\">:</span> <span class=\"kc\">False</span><span class=\"p\">),</span> <span class=\"n\">target</span><span class=\"o\">=</span><span class=\"p\">(</span><span class=\"n\">IDENTIFIER</span> <span class=\"n\">this</span><span class=\"p\">:</span> <span class=\"n\">b</span><span class=\"p\">,</span> <span class=\"n\">quoted</span><span class=\"p\">:</span> <span class=\"kc\">False</span><span class=\"p\">)),</span>\n  <span class=\"o\">...</span>\n<span class=\"p\">]</span>\n</code></pre>\n</div>\n\n<p>See also: <a href=\"https://github.com/tobymao/sqlglot/blob/main/posts/sql_diff.md\">Semantic Diff for SQL</a>.</p>\n\n<h3 id=\"custom-dialects\">Custom Dialects</h3>\n\n<p><a href=\"https://github.com/tobymao/sqlglot/tree/main/sqlglot/dialects\">Dialects</a> can be added by subclassing <code>Dialect</code>:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"kn\">from</span> <span class=\"nn\">sqlglot</span> <span class=\"kn\">import</span> <span class=\"n\">exp</span>\n<span class=\"kn\">from</span> <span class=\"nn\">sqlglot.dialects.dialect</span> <span class=\"kn\">import</span> <span class=\"n\">Dialect</span>\n<span class=\"kn\">from</span> <span class=\"nn\">sqlglot.generator</span> <span class=\"kn\">import</span> <span class=\"n\">Generator</span>\n<span class=\"kn\">from</span> <span class=\"nn\">sqlglot.tokens</span> <span class=\"kn\">import</span> <span class=\"n\">Tokenizer</span><span class=\"p\">,</span> <span class=\"n\">TokenType</span>\n\n\n<span class=\"k\">class</span> <span class=\"nc\">Custom</span><span class=\"p\">(</span><span class=\"n\">Dialect</span><span class=\"p\">):</span>\n    <span class=\"k\">class</span> <span class=\"nc\">Tokenizer</span><span class=\"p\">(</span><span class=\"n\">Tokenizer</span><span class=\"p\">):</span>\n        <span class=\"n\">QUOTES</span> <span class=\"o\">=</span> <span class=\"p\">[</span><span class=\"s2\">&quot;&#39;&quot;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;&quot;&#39;</span><span class=\"p\">]</span>\n        <span class=\"n\">IDENTIFIERS</span> <span class=\"o\">=</span> <span class=\"p\">[</span><span class=\"s2\">&quot;`&quot;</span><span class=\"p\">]</span>\n\n        <span class=\"n\">KEYWORDS</span> <span class=\"o\">=</span> <span class=\"p\">{</span>\n            <span class=\"o\">**</span><span class=\"n\">Tokenizer</span><span class=\"o\">.</span><span class=\"n\">KEYWORDS</span><span class=\"p\">,</span>\n            <span class=\"s2\">&quot;INT64&quot;</span><span class=\"p\">:</span> <span class=\"n\">TokenType</span><span class=\"o\">.</span><span class=\"n\">BIGINT</span><span class=\"p\">,</span>\n            <span class=\"s2\">&quot;FLOAT64&quot;</span><span class=\"p\">:</span> <span class=\"n\">TokenType</span><span class=\"o\">.</span><span class=\"n\">DOUBLE</span><span class=\"p\">,</span>\n        <span class=\"p\">}</span>\n\n    <span class=\"k\">class</span> <span class=\"nc\">Generator</span><span class=\"p\">(</span><span class=\"n\">Generator</span><span class=\"p\">):</span>\n        <span class=\"n\">TRANSFORMS</span> <span class=\"o\">=</span> <span class=\"p\">{</span><span class=\"n\">exp</span><span class=\"o\">.</span><span class=\"n\">Array</span><span class=\"p\">:</span> <span class=\"k\">lambda</span> <span class=\"bp\">self</span><span class=\"p\">,</span> <span class=\"n\">e</span><span class=\"p\">:</span> <span class=\"sa\">f</span><span class=\"s2\">&quot;[</span><span class=\"si\">{</span><span class=\"bp\">self</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"p\">(</span><span class=\"n\">e</span><span class=\"p\">)</span><span class=\"si\">}</span><span class=\"s2\">]&quot;</span><span class=\"p\">}</span>\n\n        <span class=\"n\">TYPE_MAPPING</span> <span class=\"o\">=</span> <span class=\"p\">{</span>\n            <span class=\"n\">exp</span><span class=\"o\">.</span><span class=\"n\">DataType</span><span class=\"o\">.</span><span class=\"n\">Type</span><span class=\"o\">.</span><span class=\"n\">TINYINT</span><span class=\"p\">:</span> <span class=\"s2\">&quot;INT64&quot;</span><span class=\"p\">,</span>\n            <span class=\"n\">exp</span><span class=\"o\">.</span><span class=\"n\">DataType</span><span class=\"o\">.</span><span class=\"n\">Type</span><span class=\"o\">.</span><span class=\"n\">SMALLINT</span><span class=\"p\">:</span> <span class=\"s2\">&quot;INT64&quot;</span><span class=\"p\">,</span>\n            <span class=\"n\">exp</span><span class=\"o\">.</span><span class=\"n\">DataType</span><span class=\"o\">.</span><span class=\"n\">Type</span><span class=\"o\">.</span><span class=\"n\">INT</span><span class=\"p\">:</span> <span class=\"s2\">&quot;INT64&quot;</span><span class=\"p\">,</span>\n            <span class=\"n\">exp</span><span class=\"o\">.</span><span class=\"n\">DataType</span><span class=\"o\">.</span><span class=\"n\">Type</span><span class=\"o\">.</span><span class=\"n\">BIGINT</span><span class=\"p\">:</span> <span class=\"s2\">&quot;INT64&quot;</span><span class=\"p\">,</span>\n            <span class=\"n\">exp</span><span class=\"o\">.</span><span class=\"n\">DataType</span><span class=\"o\">.</span><span class=\"n\">Type</span><span class=\"o\">.</span><span class=\"n\">DECIMAL</span><span class=\"p\">:</span> <span class=\"s2\">&quot;NUMERIC&quot;</span><span class=\"p\">,</span>\n            <span class=\"n\">exp</span><span class=\"o\">.</span><span class=\"n\">DataType</span><span class=\"o\">.</span><span class=\"n\">Type</span><span class=\"o\">.</span><span class=\"n\">FLOAT</span><span class=\"p\">:</span> <span class=\"s2\">&quot;FLOAT64&quot;</span><span class=\"p\">,</span>\n            <span class=\"n\">exp</span><span class=\"o\">.</span><span class=\"n\">DataType</span><span class=\"o\">.</span><span class=\"n\">Type</span><span class=\"o\">.</span><span class=\"n\">DOUBLE</span><span class=\"p\">:</span> <span class=\"s2\">&quot;FLOAT64&quot;</span><span class=\"p\">,</span>\n            <span class=\"n\">exp</span><span class=\"o\">.</span><span class=\"n\">DataType</span><span class=\"o\">.</span><span class=\"n\">Type</span><span class=\"o\">.</span><span class=\"n\">BOOLEAN</span><span class=\"p\">:</span> <span class=\"s2\">&quot;BOOL&quot;</span><span class=\"p\">,</span>\n            <span class=\"n\">exp</span><span class=\"o\">.</span><span class=\"n\">DataType</span><span class=\"o\">.</span><span class=\"n\">Type</span><span class=\"o\">.</span><span class=\"n\">TEXT</span><span class=\"p\">:</span> <span class=\"s2\">&quot;STRING&quot;</span><span class=\"p\">,</span>\n        <span class=\"p\">}</span>\n\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"n\">Dialect</span><span class=\"p\">[</span><span class=\"s2\">&quot;custom&quot;</span><span class=\"p\">])</span>\n</code></pre>\n</div>\n\n<pre><code>&lt;class '__main__.Custom'&gt;\n</code></pre>\n\n<h3 id=\"sql-execution\">SQL Execution</h3>\n\n<p>One can even interpret SQL queries using SQLGlot, where the tables are represented as Python dictionaries. Although the engine is not very fast (it's not supposed to be) and is in a relatively early stage of development, it can be useful for unit testing and running SQL natively across Python objects. Additionally, the foundation can be easily integrated with fast compute kernels (arrow, pandas). Below is an example showcasing the execution of a SELECT expression that involves aggregations and JOINs:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"kn\">from</span> <span class=\"nn\">sqlglot.executor</span> <span class=\"kn\">import</span> <span class=\"n\">execute</span>\n\n<span class=\"n\">tables</span> <span class=\"o\">=</span> <span class=\"p\">{</span>\n    <span class=\"s2\">&quot;sushi&quot;</span><span class=\"p\">:</span> <span class=\"p\">[</span>\n        <span class=\"p\">{</span><span class=\"s2\">&quot;id&quot;</span><span class=\"p\">:</span> <span class=\"mi\">1</span><span class=\"p\">,</span> <span class=\"s2\">&quot;price&quot;</span><span class=\"p\">:</span> <span class=\"mf\">1.0</span><span class=\"p\">},</span>\n        <span class=\"p\">{</span><span class=\"s2\">&quot;id&quot;</span><span class=\"p\">:</span> <span class=\"mi\">2</span><span class=\"p\">,</span> <span class=\"s2\">&quot;price&quot;</span><span class=\"p\">:</span> <span class=\"mf\">2.0</span><span class=\"p\">},</span>\n        <span class=\"p\">{</span><span class=\"s2\">&quot;id&quot;</span><span class=\"p\">:</span> <span class=\"mi\">3</span><span class=\"p\">,</span> <span class=\"s2\">&quot;price&quot;</span><span class=\"p\">:</span> <span class=\"mf\">3.0</span><span class=\"p\">},</span>\n    <span class=\"p\">],</span>\n    <span class=\"s2\">&quot;order_items&quot;</span><span class=\"p\">:</span> <span class=\"p\">[</span>\n        <span class=\"p\">{</span><span class=\"s2\">&quot;sushi_id&quot;</span><span class=\"p\">:</span> <span class=\"mi\">1</span><span class=\"p\">,</span> <span class=\"s2\">&quot;order_id&quot;</span><span class=\"p\">:</span> <span class=\"mi\">1</span><span class=\"p\">},</span>\n        <span class=\"p\">{</span><span class=\"s2\">&quot;sushi_id&quot;</span><span class=\"p\">:</span> <span class=\"mi\">1</span><span class=\"p\">,</span> <span class=\"s2\">&quot;order_id&quot;</span><span class=\"p\">:</span> <span class=\"mi\">1</span><span class=\"p\">},</span>\n        <span class=\"p\">{</span><span class=\"s2\">&quot;sushi_id&quot;</span><span class=\"p\">:</span> <span class=\"mi\">2</span><span class=\"p\">,</span> <span class=\"s2\">&quot;order_id&quot;</span><span class=\"p\">:</span> <span class=\"mi\">1</span><span class=\"p\">},</span>\n        <span class=\"p\">{</span><span class=\"s2\">&quot;sushi_id&quot;</span><span class=\"p\">:</span> <span class=\"mi\">3</span><span class=\"p\">,</span> <span class=\"s2\">&quot;order_id&quot;</span><span class=\"p\">:</span> <span class=\"mi\">2</span><span class=\"p\">},</span>\n    <span class=\"p\">],</span>\n    <span class=\"s2\">&quot;orders&quot;</span><span class=\"p\">:</span> <span class=\"p\">[</span>\n        <span class=\"p\">{</span><span class=\"s2\">&quot;id&quot;</span><span class=\"p\">:</span> <span class=\"mi\">1</span><span class=\"p\">,</span> <span class=\"s2\">&quot;user_id&quot;</span><span class=\"p\">:</span> <span class=\"mi\">1</span><span class=\"p\">},</span>\n        <span class=\"p\">{</span><span class=\"s2\">&quot;id&quot;</span><span class=\"p\">:</span> <span class=\"mi\">2</span><span class=\"p\">,</span> <span class=\"s2\">&quot;user_id&quot;</span><span class=\"p\">:</span> <span class=\"mi\">2</span><span class=\"p\">},</span>\n    <span class=\"p\">],</span>\n<span class=\"p\">}</span>\n\n<span class=\"n\">execute</span><span class=\"p\">(</span>\n<span class=\"w\">    </span><span class=\"sd\">&quot;&quot;&quot;</span>\n<span class=\"sd\">    SELECT</span>\n<span class=\"sd\">      o.user_id,</span>\n<span class=\"sd\">      SUM(s.price) AS price</span>\n<span class=\"sd\">    FROM orders o</span>\n<span class=\"sd\">    JOIN order_items i</span>\n<span class=\"sd\">      ON o.id = i.order_id</span>\n<span class=\"sd\">    JOIN sushi s</span>\n<span class=\"sd\">      ON i.sushi_id = s.id</span>\n<span class=\"sd\">    GROUP BY o.user_id</span>\n<span class=\"sd\">    &quot;&quot;&quot;</span><span class=\"p\">,</span>\n    <span class=\"n\">tables</span><span class=\"o\">=</span><span class=\"n\">tables</span>\n<span class=\"p\">)</span>\n</code></pre>\n</div>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"n\">user_id</span> <span class=\"n\">price</span>\n      <span class=\"mi\">1</span>   <span class=\"mf\">4.0</span>\n      <span class=\"mi\">2</span>   <span class=\"mf\">3.0</span>\n</code></pre>\n</div>\n\n<p>See also: <a href=\"https://github.com/tobymao/sqlglot/blob/main/posts/python_sql_engine.md\">Writing a Python SQL engine from scratch</a>.</p>\n\n<h2 id=\"used-by\">Used By</h2>\n\n<ul>\n<li><a href=\"https://github.com/TobikoData/sqlmesh\">SQLMesh</a></li>\n<li><a href=\"https://github.com/fugue-project/fugue\">Fugue</a></li>\n<li><a href=\"https://github.com/ibis-project/ibis\">ibis</a></li>\n<li><a href=\"https://github.com/kelsin/mysql-mimic\">mysql-mimic</a></li>\n<li><a href=\"https://github.com/pinterest/querybook\">Querybook</a></li>\n<li><a href=\"https://github.com/marsupialtail/quokka\">Quokka</a></li>\n<li><a href=\"https://github.com/moj-analytical-services/splink\">Splink</a></li>\n</ul>\n\n<h2 id=\"documentation\">Documentation</h2>\n\n<p>SQLGlot uses <a href=\"https://pdoc.dev/\">pdoc</a> to serve its API documentation:</p>\n\n<pre><code>make docs-serve\n</code></pre>\n\n<h2 id=\"run-tests-and-lint\">Run Tests and Lint</h2>\n\n<pre><code>make check  # Set SKIP_INTEGRATION=1 to skip integration tests\n</code></pre>\n\n<h2 id=\"benchmarks\">Benchmarks</h2>\n\n<p><a href=\"https://github.com/tobymao/sqlglot/blob/main/benchmarks/bench.py\">Benchmarks</a> run on Python 3.10.5 in seconds.</p>\n\n<table>\n<thead>\n<tr>\n  <th>Query</th>\n  <th>sqlglot</th>\n  <th>sqlfluff</th>\n  <th>sqltree</th>\n  <th>sqlparse</th>\n  <th>moz_sql_parser</th>\n  <th>sqloxide</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>tpch</td>\n  <td>0.01308 (1.0)</td>\n  <td>1.60626 (122.7)</td>\n  <td>0.01168 (0.893)</td>\n  <td>0.04958 (3.791)</td>\n  <td>0.08543 (6.531)</td>\n  <td>0.00136 (0.104)</td>\n</tr>\n<tr>\n  <td>short</td>\n  <td>0.00109 (1.0)</td>\n  <td>0.14134 (129.2)</td>\n  <td>0.00099 (0.906)</td>\n  <td>0.00342 (3.131)</td>\n  <td>0.00652 (5.970)</td>\n  <td>8.76E-5 (0.080)</td>\n</tr>\n<tr>\n  <td>long</td>\n  <td>0.01399 (1.0)</td>\n  <td>2.12632 (151.9)</td>\n  <td>0.01126 (0.805)</td>\n  <td>0.04410 (3.151)</td>\n  <td>0.06671 (4.767)</td>\n  <td>0.00107 (0.076)</td>\n</tr>\n<tr>\n  <td>crazy</td>\n  <td>0.03969 (1.0)</td>\n  <td>24.3777 (614.1)</td>\n  <td>0.03917 (0.987)</td>\n  <td>11.7043 (294.8)</td>\n  <td>1.03280 (26.02)</td>\n  <td>0.00625 (0.157)</td>\n</tr>\n</tbody>\n</table>\n\n<h2 id=\"optional-dependencies\">Optional Dependencies</h2>\n\n<p>SQLGlot uses <a href=\"https://github.com/dateutil/dateutil\">dateutil</a> to simplify literal timedelta expressions. The optimizer will not simplify expressions like the following if the module cannot be found:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"n\">x</span><span class=\"w\"> </span><span class=\"o\">+</span><span class=\"w\"> </span><span class=\"nb\">interval</span><span class=\"w\"> </span><span class=\"s1\">&#39;1&#39;</span><span class=\"w\"> </span><span class=\"k\">month</span>\n</code></pre>\n</div>\n\n<hr />\n"}, "sqlglot.pretty": {"fullname": "sqlglot.pretty", "modulename": "sqlglot", "qualname": "pretty", "kind": "variable", "doc": "<p>Whether to format generated SQL by default.</p>\n", "default_value": "False"}, "sqlglot.schema": {"fullname": "sqlglot.schema", "modulename": "sqlglot.schema", "kind": "module", "doc": "<p></p>\n"}, "sqlglot.parse": {"fullname": "sqlglot.parse", "modulename": "sqlglot", "qualname": "parse", "kind": "function", "doc": "<p>Parses the given SQL string into a collection of syntax trees, one per parsed SQL statement.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>sql:</strong>  the SQL code string to parse.</li>\n<li><strong>read:</strong>  the SQL dialect to apply during parsing (eg. \"spark\", \"hive\", \"presto\", \"mysql\").</li>\n<li><strong>**opts:</strong>  other <code>sqlglot.parser.Parser</code> options.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The resulting syntax tree collection.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">sql</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">read</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">opts</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "sqlglot.parse_one": {"fullname": "sqlglot.parse_one", "modulename": "sqlglot", "qualname": "parse_one", "kind": "function", "doc": "<p>Parses the given SQL string and returns a syntax tree for the first parsed SQL statement.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>sql:</strong>  the SQL code string to parse.</li>\n<li><strong>read:</strong>  the SQL dialect to apply during parsing (eg. \"spark\", \"hive\", \"presto\", \"mysql\").</li>\n<li><strong>into:</strong>  the SQLGlot Expression to parse into.</li>\n<li><strong>**opts:</strong>  other <code>sqlglot.parser.Parser</code> options.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The syntax tree for the first parsed statement.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">sql</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">read</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">into</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">],</span> <span class=\"n\">Collection</span><span class=\"p\">[</span><span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">]]],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">opts</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span>:</span></span>", "funcdef": "def"}, "sqlglot.transpile": {"fullname": "sqlglot.transpile", "modulename": "sqlglot", "qualname": "transpile", "kind": "function", "doc": "<p>Parses the given SQL string in accordance with the source dialect and returns a list of SQL strings transformed\nto conform to the target dialect. Each string in the returned list represents a single transformed SQL statement.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>sql:</strong>  the SQL code string to transpile.</li>\n<li><strong>read:</strong>  the source dialect used to parse the input string (eg. \"spark\", \"hive\", \"presto\", \"mysql\").</li>\n<li><strong>write:</strong>  the target dialect into which the input should be transformed (eg. \"spark\", \"hive\", \"presto\", \"mysql\").</li>\n<li><strong>identity:</strong>  if set to <code>True</code> and if the target dialect is not specified the source dialect will be used as both:\nthe source and the target dialect.</li>\n<li><strong>error_level:</strong>  the desired error level of the parser.</li>\n<li><strong>**opts:</strong>  other <code>sqlglot.generator.Generator</code> options.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The list of transpiled SQL statements.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">sql</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">read</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">write</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">identity</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">error_level</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">errors</span><span class=\"o\">.</span><span class=\"n\">ErrorLevel</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">opts</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe": {"fullname": "sqlglot.dataframe", "modulename": "sqlglot.dataframe", "kind": "module", "doc": "<h1 id=\"pyspark-dataframe-sql-generator\">PySpark DataFrame SQL Generator</h1>\n\n<p>This is a drop-in replacement for the PySpark DataFrame API that will generate SQL instead of executing DataFrame operations directly. This, when combined with the transpiling support in SQLGlot, allows one to write PySpark DataFrame code and execute it on other engines like <a href=\"https://duckdb.org/\">DuckDB</a>, <a href=\"https://prestodb.io/\">Presto</a>, <a href=\"https://spark.apache.org/\">Spark</a>, <a href=\"https://www.snowflake.com/en/\">Snowflake</a>, and <a href=\"https://cloud.google.com/bigquery/\">BigQuery</a>. </p>\n\n<p>Currently many of the common operations are covered and more functionality will be added over time. Please <a href=\"https://github.com/tobymao/sqlglot/issues\">open an issue</a> or <a href=\"https://github.com/tobymao/sqlglot/pulls\">PR</a> with your feedback or contribution to help influence what should be prioritized next and make sure your use case is properly supported.</p>\n\n<h1 id=\"how-to-use\">How to use</h1>\n\n<h2 id=\"instructions\">Instructions</h2>\n\n<ul>\n<li><a href=\"https://github.com/tobymao/sqlglot/blob/main/README.md#install\">Install SQLGlot</a> and that is all that is required to just generate SQL. <a href=\"#examples\">The examples</a> show generating SQL and then executing that SQL on a specific engine and that will require that engine's client library.</li>\n<li>Find/replace all <code>from pyspark.sql</code> with <code>from sqlglot.dataframe</code>.</li>\n<li>Prior to any <code>spark.read.table</code> or <code>spark.table</code> run <code>sqlglot.schema.add_table('&lt;table_name&gt;', &lt;column_structure&gt;)</code>.\n<ul>\n<li>The column structure can be defined the following ways:\n<ul>\n<li>Dictionary where the keys are column names and values are string of the Spark SQL type name.\n<ul>\n<li>Ex: <code>{'cola': 'string', 'colb': 'int'}</code></li>\n</ul></li>\n<li>PySpark DataFrame <code>StructType</code> similar to when using <code>createDataFrame</code>.\n<ul>\n<li>Ex: <code>StructType([StructField('cola', StringType()), StructField('colb', IntegerType())])</code></li>\n</ul></li>\n<li>A string of names and types similar to what is supported in <code>createDataFrame</code>.\n<ul>\n<li>Ex: <code>cola: STRING, colb: INT</code></li>\n</ul></li>\n<li>[Not Recommended] A list of string column names without type.\n<ul>\n<li>Ex: <code>['cola', 'colb']</code></li>\n<li>The lack of types may limit functionality in future releases.</li>\n</ul></li>\n</ul></li>\n<li>See <a href=\"#registering-custom-schema-class\">Registering Custom Schema</a> for information on how to skip this step if the information is stored externally.</li>\n</ul></li>\n<li>Add <code>.sql(pretty=True)</code> to your final DataFrame command to return a list of sql statements to run that command.\n<ul>\n<li>In most cases a single SQL statement is returned. Currently the only exception is when caching DataFrames which isn't supported in other dialects.  </li>\n<li>Spark is the default output dialect. See <a href=\"https://github.com/tobymao/sqlglot/tree/main/sqlglot/dialects\">dialects</a> for a full list of dialects.</li>\n<li>Ex: <code>.sql(pretty=True, dialect='bigquery')</code></li>\n</ul></li>\n</ul>\n\n<h2 id=\"examples\">Examples</h2>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"kn\">import</span> <span class=\"nn\">sqlglot</span>\n<span class=\"kn\">from</span> <span class=\"nn\">sqlglot.dataframe.sql.session</span> <span class=\"kn\">import</span> <span class=\"n\">SparkSession</span>\n<span class=\"kn\">from</span> <span class=\"nn\">sqlglot.dataframe.sql</span> <span class=\"kn\">import</span> <span class=\"n\">functions</span> <span class=\"k\">as</span> <span class=\"n\">F</span>\n\n<span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">schema</span><span class=\"o\">.</span><span class=\"n\">add_table</span><span class=\"p\">(</span><span class=\"s1\">&#39;employee&#39;</span><span class=\"p\">,</span> <span class=\"p\">{</span>\n  <span class=\"s1\">&#39;employee_id&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;INT&#39;</span><span class=\"p\">,</span>\n  <span class=\"s1\">&#39;fname&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;STRING&#39;</span><span class=\"p\">,</span>\n  <span class=\"s1\">&#39;lname&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;STRING&#39;</span><span class=\"p\">,</span>\n  <span class=\"s1\">&#39;age&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;INT&#39;</span><span class=\"p\">,</span>\n<span class=\"p\">})</span>  <span class=\"c1\"># Register the table structure prior to reading from the table</span>\n\n<span class=\"n\">spark</span> <span class=\"o\">=</span> <span class=\"n\">SparkSession</span><span class=\"p\">()</span>\n\n<span class=\"n\">df</span> <span class=\"o\">=</span> <span class=\"p\">(</span>\n    <span class=\"n\">spark</span>\n    <span class=\"o\">.</span><span class=\"n\">table</span><span class=\"p\">(</span><span class=\"s1\">&#39;employee&#39;</span><span class=\"p\">)</span>\n    <span class=\"o\">.</span><span class=\"n\">groupBy</span><span class=\"p\">(</span><span class=\"n\">F</span><span class=\"o\">.</span><span class=\"n\">col</span><span class=\"p\">(</span><span class=\"s2\">&quot;age&quot;</span><span class=\"p\">))</span>\n    <span class=\"o\">.</span><span class=\"n\">agg</span><span class=\"p\">(</span><span class=\"n\">F</span><span class=\"o\">.</span><span class=\"n\">countDistinct</span><span class=\"p\">(</span><span class=\"n\">F</span><span class=\"o\">.</span><span class=\"n\">col</span><span class=\"p\">(</span><span class=\"s2\">&quot;employee_id&quot;</span><span class=\"p\">))</span><span class=\"o\">.</span><span class=\"n\">alias</span><span class=\"p\">(</span><span class=\"s2\">&quot;num_employees&quot;</span><span class=\"p\">))</span> \n<span class=\"p\">)</span>\n\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"n\">df</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">(</span><span class=\"n\">pretty</span><span class=\"o\">=</span><span class=\"kc\">True</span><span class=\"p\">))</span>  <span class=\"c1\"># Spark will be the dialect used by default</span>\n</code></pre>\n</div>\n\n<pre><code>SELECT\n  `employee`.`age` AS `age`,\n  COUNT(DISTINCT `employee`.`employee_id`) AS `num_employees`\nFROM `employee` AS `employee`\nGROUP BY\n  `employee`.`age`\n</code></pre>\n\n<h2 id=\"registering-custom-schema-class\">Registering Custom Schema Class</h2>\n\n<p>The step of adding <code>sqlglot.schema.add_table</code> can be skipped if you have the column structure stored externally like in a file or from an external metadata table. This can be done by writing a class that implements the <code>sqlglot.schema.Schema</code> abstract class and then assigning that class to <code>sqlglot.schema</code>. </p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"kn\">import</span> <span class=\"nn\">sqlglot</span>\n<span class=\"kn\">from</span> <span class=\"nn\">sqlglot.dataframe.sql.session</span> <span class=\"kn\">import</span> <span class=\"n\">SparkSession</span>\n<span class=\"kn\">from</span> <span class=\"nn\">sqlglot.dataframe.sql</span> <span class=\"kn\">import</span> <span class=\"n\">functions</span> <span class=\"k\">as</span> <span class=\"n\">F</span>\n<span class=\"kn\">from</span> <span class=\"nn\">sqlglot.schema</span> <span class=\"kn\">import</span> <span class=\"n\">Schema</span>\n\n\n<span class=\"k\">class</span> <span class=\"nc\">ExternalSchema</span><span class=\"p\">(</span><span class=\"n\">Schema</span><span class=\"p\">):</span>\n  <span class=\"o\">...</span>\n\n<span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">schema</span> <span class=\"o\">=</span> <span class=\"n\">ExternalSchema</span><span class=\"p\">()</span>\n\n<span class=\"n\">spark</span> <span class=\"o\">=</span> <span class=\"n\">SparkSession</span><span class=\"p\">()</span>\n\n<span class=\"n\">df</span> <span class=\"o\">=</span> <span class=\"p\">(</span>\n    <span class=\"n\">spark</span>\n    <span class=\"o\">.</span><span class=\"n\">table</span><span class=\"p\">(</span><span class=\"s1\">&#39;employee&#39;</span><span class=\"p\">)</span>\n    <span class=\"o\">.</span><span class=\"n\">groupBy</span><span class=\"p\">(</span><span class=\"n\">F</span><span class=\"o\">.</span><span class=\"n\">col</span><span class=\"p\">(</span><span class=\"s2\">&quot;age&quot;</span><span class=\"p\">))</span>\n    <span class=\"o\">.</span><span class=\"n\">agg</span><span class=\"p\">(</span><span class=\"n\">F</span><span class=\"o\">.</span><span class=\"n\">countDistinct</span><span class=\"p\">(</span><span class=\"n\">F</span><span class=\"o\">.</span><span class=\"n\">col</span><span class=\"p\">(</span><span class=\"s2\">&quot;employee_id&quot;</span><span class=\"p\">))</span><span class=\"o\">.</span><span class=\"n\">alias</span><span class=\"p\">(</span><span class=\"s2\">&quot;num_employees&quot;</span><span class=\"p\">))</span> \n<span class=\"p\">)</span>\n\n<span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"n\">df</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">(</span><span class=\"n\">pretty</span><span class=\"o\">=</span><span class=\"kc\">True</span><span class=\"p\">))</span>\n</code></pre>\n</div>\n\n<h2 id=\"example-implementations\">Example Implementations</h2>\n\n<h3 id=\"bigquery\">Bigquery</h3>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"kn\">from</span> <span class=\"nn\">google.cloud</span> <span class=\"kn\">import</span> <span class=\"n\">bigquery</span>\n<span class=\"kn\">from</span> <span class=\"nn\">sqlglot.dataframe.sql.session</span> <span class=\"kn\">import</span> <span class=\"n\">SparkSession</span>\n<span class=\"kn\">from</span> <span class=\"nn\">sqlglot.dataframe.sql</span> <span class=\"kn\">import</span> <span class=\"n\">types</span>\n<span class=\"kn\">from</span> <span class=\"nn\">sqlglot.dataframe.sql</span> <span class=\"kn\">import</span> <span class=\"n\">functions</span> <span class=\"k\">as</span> <span class=\"n\">F</span>\n\n<span class=\"n\">client</span> <span class=\"o\">=</span> <span class=\"n\">bigquery</span><span class=\"o\">.</span><span class=\"n\">Client</span><span class=\"p\">()</span>\n\n<span class=\"n\">data</span> <span class=\"o\">=</span> <span class=\"p\">[</span>\n    <span class=\"p\">(</span><span class=\"mi\">1</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Jack&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Shephard&quot;</span><span class=\"p\">,</span> <span class=\"mi\">34</span><span class=\"p\">),</span>\n    <span class=\"p\">(</span><span class=\"mi\">2</span><span class=\"p\">,</span> <span class=\"s2\">&quot;John&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Locke&quot;</span><span class=\"p\">,</span> <span class=\"mi\">48</span><span class=\"p\">),</span>\n    <span class=\"p\">(</span><span class=\"mi\">3</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Kate&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Austen&quot;</span><span class=\"p\">,</span> <span class=\"mi\">34</span><span class=\"p\">),</span>\n    <span class=\"p\">(</span><span class=\"mi\">4</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Claire&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Littleton&quot;</span><span class=\"p\">,</span> <span class=\"mi\">22</span><span class=\"p\">),</span>\n    <span class=\"p\">(</span><span class=\"mi\">5</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Hugo&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Reyes&quot;</span><span class=\"p\">,</span> <span class=\"mi\">26</span><span class=\"p\">),</span>\n<span class=\"p\">]</span>\n<span class=\"n\">schema</span> <span class=\"o\">=</span> <span class=\"n\">types</span><span class=\"o\">.</span><span class=\"n\">StructType</span><span class=\"p\">([</span>\n    <span class=\"n\">types</span><span class=\"o\">.</span><span class=\"n\">StructField</span><span class=\"p\">(</span><span class=\"s1\">&#39;employee_id&#39;</span><span class=\"p\">,</span> <span class=\"n\">types</span><span class=\"o\">.</span><span class=\"n\">IntegerType</span><span class=\"p\">(),</span> <span class=\"kc\">False</span><span class=\"p\">),</span>\n    <span class=\"n\">types</span><span class=\"o\">.</span><span class=\"n\">StructField</span><span class=\"p\">(</span><span class=\"s1\">&#39;fname&#39;</span><span class=\"p\">,</span> <span class=\"n\">types</span><span class=\"o\">.</span><span class=\"n\">StringType</span><span class=\"p\">(),</span> <span class=\"kc\">False</span><span class=\"p\">),</span>\n    <span class=\"n\">types</span><span class=\"o\">.</span><span class=\"n\">StructField</span><span class=\"p\">(</span><span class=\"s1\">&#39;lname&#39;</span><span class=\"p\">,</span> <span class=\"n\">types</span><span class=\"o\">.</span><span class=\"n\">StringType</span><span class=\"p\">(),</span> <span class=\"kc\">False</span><span class=\"p\">),</span>\n    <span class=\"n\">types</span><span class=\"o\">.</span><span class=\"n\">StructField</span><span class=\"p\">(</span><span class=\"s1\">&#39;age&#39;</span><span class=\"p\">,</span> <span class=\"n\">types</span><span class=\"o\">.</span><span class=\"n\">IntegerType</span><span class=\"p\">(),</span> <span class=\"kc\">False</span><span class=\"p\">),</span>\n<span class=\"p\">])</span>\n\n<span class=\"n\">sql_statements</span> <span class=\"o\">=</span> <span class=\"p\">(</span>\n    <span class=\"n\">SparkSession</span><span class=\"p\">()</span>\n    <span class=\"o\">.</span><span class=\"n\">createDataFrame</span><span class=\"p\">(</span><span class=\"n\">data</span><span class=\"p\">,</span> <span class=\"n\">schema</span><span class=\"p\">)</span>\n    <span class=\"o\">.</span><span class=\"n\">groupBy</span><span class=\"p\">(</span><span class=\"n\">F</span><span class=\"o\">.</span><span class=\"n\">col</span><span class=\"p\">(</span><span class=\"s2\">&quot;age&quot;</span><span class=\"p\">))</span>\n    <span class=\"o\">.</span><span class=\"n\">agg</span><span class=\"p\">(</span><span class=\"n\">F</span><span class=\"o\">.</span><span class=\"n\">countDistinct</span><span class=\"p\">(</span><span class=\"n\">F</span><span class=\"o\">.</span><span class=\"n\">col</span><span class=\"p\">(</span><span class=\"s2\">&quot;employee_id&quot;</span><span class=\"p\">))</span><span class=\"o\">.</span><span class=\"n\">alias</span><span class=\"p\">(</span><span class=\"s2\">&quot;num_employees&quot;</span><span class=\"p\">))</span>\n    <span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">(</span><span class=\"n\">dialect</span><span class=\"o\">=</span><span class=\"s2\">&quot;bigquery&quot;</span><span class=\"p\">)</span>\n<span class=\"p\">)</span>\n\n<span class=\"n\">result</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>\n<span class=\"k\">for</span> <span class=\"n\">sql</span> <span class=\"ow\">in</span> <span class=\"n\">sql_statements</span><span class=\"p\">:</span>\n  <span class=\"n\">result</span> <span class=\"o\">=</span> <span class=\"n\">client</span><span class=\"o\">.</span><span class=\"n\">query</span><span class=\"p\">(</span><span class=\"n\">sql</span><span class=\"p\">)</span>\n\n<span class=\"k\">assert</span> <span class=\"n\">result</span> <span class=\"ow\">is</span> <span class=\"ow\">not</span> <span class=\"kc\">None</span>\n<span class=\"k\">for</span> <span class=\"n\">row</span> <span class=\"ow\">in</span> <span class=\"n\">client</span><span class=\"o\">.</span><span class=\"n\">query</span><span class=\"p\">(</span><span class=\"n\">result</span><span class=\"p\">):</span>\n    <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"sa\">f</span><span class=\"s2\">&quot;Age: </span><span class=\"si\">{</span><span class=\"n\">row</span><span class=\"p\">[</span><span class=\"s1\">&#39;age&#39;</span><span class=\"p\">]</span><span class=\"si\">}</span><span class=\"s2\">, Num Employees: </span><span class=\"si\">{</span><span class=\"n\">row</span><span class=\"p\">[</span><span class=\"s1\">&#39;num_employees&#39;</span><span class=\"p\">]</span><span class=\"si\">}</span><span class=\"s2\">&quot;</span><span class=\"p\">)</span>\n</code></pre>\n</div>\n\n<h3 id=\"snowflake\">Snowflake</h3>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"kn\">import</span> <span class=\"nn\">os</span>\n\n<span class=\"kn\">import</span> <span class=\"nn\">snowflake.connector</span>\n<span class=\"kn\">from</span> <span class=\"nn\">sqlglot.dataframe.session</span> <span class=\"kn\">import</span> <span class=\"n\">SparkSession</span>\n<span class=\"kn\">from</span> <span class=\"nn\">sqlglot.dataframe</span> <span class=\"kn\">import</span> <span class=\"n\">types</span>\n<span class=\"kn\">from</span> <span class=\"nn\">sqlglot.dataframe</span> <span class=\"kn\">import</span> <span class=\"n\">functions</span> <span class=\"k\">as</span> <span class=\"n\">F</span>\n\n<span class=\"n\">ctx</span> <span class=\"o\">=</span> <span class=\"n\">snowflake</span><span class=\"o\">.</span><span class=\"n\">connector</span><span class=\"o\">.</span><span class=\"n\">connect</span><span class=\"p\">(</span>\n    <span class=\"n\">user</span><span class=\"o\">=</span><span class=\"n\">os</span><span class=\"o\">.</span><span class=\"n\">environ</span><span class=\"p\">[</span><span class=\"s2\">&quot;SNOWFLAKE_USER&quot;</span><span class=\"p\">],</span>\n    <span class=\"n\">password</span><span class=\"o\">=</span><span class=\"n\">os</span><span class=\"o\">.</span><span class=\"n\">environ</span><span class=\"p\">[</span><span class=\"s2\">&quot;SNOWFLAKE_PASS&quot;</span><span class=\"p\">],</span>\n    <span class=\"n\">account</span><span class=\"o\">=</span><span class=\"n\">os</span><span class=\"o\">.</span><span class=\"n\">environ</span><span class=\"p\">[</span><span class=\"s2\">&quot;SNOWFLAKE_ACCOUNT&quot;</span><span class=\"p\">]</span>\n<span class=\"p\">)</span>\n<span class=\"n\">cs</span> <span class=\"o\">=</span> <span class=\"n\">ctx</span><span class=\"o\">.</span><span class=\"n\">cursor</span><span class=\"p\">()</span>\n\n<span class=\"n\">data</span> <span class=\"o\">=</span> <span class=\"p\">[</span>\n    <span class=\"p\">(</span><span class=\"mi\">1</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Jack&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Shephard&quot;</span><span class=\"p\">,</span> <span class=\"mi\">34</span><span class=\"p\">),</span>\n    <span class=\"p\">(</span><span class=\"mi\">2</span><span class=\"p\">,</span> <span class=\"s2\">&quot;John&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Locke&quot;</span><span class=\"p\">,</span> <span class=\"mi\">48</span><span class=\"p\">),</span>\n    <span class=\"p\">(</span><span class=\"mi\">3</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Kate&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Austen&quot;</span><span class=\"p\">,</span> <span class=\"mi\">34</span><span class=\"p\">),</span>\n    <span class=\"p\">(</span><span class=\"mi\">4</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Claire&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Littleton&quot;</span><span class=\"p\">,</span> <span class=\"mi\">22</span><span class=\"p\">),</span>\n    <span class=\"p\">(</span><span class=\"mi\">5</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Hugo&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Reyes&quot;</span><span class=\"p\">,</span> <span class=\"mi\">26</span><span class=\"p\">),</span>\n<span class=\"p\">]</span>\n<span class=\"n\">schema</span> <span class=\"o\">=</span> <span class=\"n\">types</span><span class=\"o\">.</span><span class=\"n\">StructType</span><span class=\"p\">([</span>\n    <span class=\"n\">types</span><span class=\"o\">.</span><span class=\"n\">StructField</span><span class=\"p\">(</span><span class=\"s1\">&#39;employee_id&#39;</span><span class=\"p\">,</span> <span class=\"n\">types</span><span class=\"o\">.</span><span class=\"n\">IntegerType</span><span class=\"p\">(),</span> <span class=\"kc\">False</span><span class=\"p\">),</span>\n    <span class=\"n\">types</span><span class=\"o\">.</span><span class=\"n\">StructField</span><span class=\"p\">(</span><span class=\"s1\">&#39;fname&#39;</span><span class=\"p\">,</span> <span class=\"n\">types</span><span class=\"o\">.</span><span class=\"n\">StringType</span><span class=\"p\">(),</span> <span class=\"kc\">False</span><span class=\"p\">),</span>\n    <span class=\"n\">types</span><span class=\"o\">.</span><span class=\"n\">StructField</span><span class=\"p\">(</span><span class=\"s1\">&#39;lname&#39;</span><span class=\"p\">,</span> <span class=\"n\">types</span><span class=\"o\">.</span><span class=\"n\">StringType</span><span class=\"p\">(),</span> <span class=\"kc\">False</span><span class=\"p\">),</span>\n    <span class=\"n\">types</span><span class=\"o\">.</span><span class=\"n\">StructField</span><span class=\"p\">(</span><span class=\"s1\">&#39;age&#39;</span><span class=\"p\">,</span> <span class=\"n\">types</span><span class=\"o\">.</span><span class=\"n\">IntegerType</span><span class=\"p\">(),</span> <span class=\"kc\">False</span><span class=\"p\">),</span>\n<span class=\"p\">])</span>\n\n<span class=\"n\">sql_statements</span> <span class=\"o\">=</span> <span class=\"p\">(</span>\n    <span class=\"n\">SparkSession</span><span class=\"p\">()</span>\n    <span class=\"o\">.</span><span class=\"n\">createDataFrame</span><span class=\"p\">(</span><span class=\"n\">data</span><span class=\"p\">,</span> <span class=\"n\">schema</span><span class=\"p\">)</span>\n    <span class=\"o\">.</span><span class=\"n\">groupBy</span><span class=\"p\">(</span><span class=\"n\">F</span><span class=\"o\">.</span><span class=\"n\">col</span><span class=\"p\">(</span><span class=\"s2\">&quot;age&quot;</span><span class=\"p\">))</span>\n    <span class=\"o\">.</span><span class=\"n\">agg</span><span class=\"p\">(</span><span class=\"n\">F</span><span class=\"o\">.</span><span class=\"n\">countDistinct</span><span class=\"p\">(</span><span class=\"n\">F</span><span class=\"o\">.</span><span class=\"n\">col</span><span class=\"p\">(</span><span class=\"s2\">&quot;lname&quot;</span><span class=\"p\">))</span><span class=\"o\">.</span><span class=\"n\">alias</span><span class=\"p\">(</span><span class=\"s2\">&quot;num_employees&quot;</span><span class=\"p\">))</span>\n    <span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">(</span><span class=\"n\">dialect</span><span class=\"o\">=</span><span class=\"s2\">&quot;snowflake&quot;</span><span class=\"p\">)</span>\n<span class=\"p\">)</span>\n\n<span class=\"k\">try</span><span class=\"p\">:</span>\n    <span class=\"k\">for</span> <span class=\"n\">sql</span> <span class=\"ow\">in</span> <span class=\"n\">sql_statements</span><span class=\"p\">:</span>\n        <span class=\"n\">cs</span><span class=\"o\">.</span><span class=\"n\">execute</span><span class=\"p\">(</span><span class=\"n\">sql</span><span class=\"p\">)</span>\n    <span class=\"n\">results</span> <span class=\"o\">=</span> <span class=\"n\">cs</span><span class=\"o\">.</span><span class=\"n\">fetchall</span><span class=\"p\">()</span>\n    <span class=\"k\">for</span> <span class=\"n\">row</span> <span class=\"ow\">in</span> <span class=\"n\">results</span><span class=\"p\">:</span>\n        <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"sa\">f</span><span class=\"s2\">&quot;Age: </span><span class=\"si\">{</span><span class=\"n\">row</span><span class=\"p\">[</span><span class=\"mi\">0</span><span class=\"p\">]</span><span class=\"si\">}</span><span class=\"s2\">, Num Employees: </span><span class=\"si\">{</span><span class=\"n\">row</span><span class=\"p\">[</span><span class=\"mi\">1</span><span class=\"p\">]</span><span class=\"si\">}</span><span class=\"s2\">&quot;</span><span class=\"p\">)</span>\n<span class=\"k\">finally</span><span class=\"p\">:</span>\n    <span class=\"n\">cs</span><span class=\"o\">.</span><span class=\"n\">close</span><span class=\"p\">()</span>\n<span class=\"n\">ctx</span><span class=\"o\">.</span><span class=\"n\">close</span><span class=\"p\">()</span>\n</code></pre>\n</div>\n\n<h3 id=\"spark\">Spark</h3>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"kn\">from</span> <span class=\"nn\">pyspark.sql.session</span> <span class=\"kn\">import</span> <span class=\"n\">SparkSession</span> <span class=\"k\">as</span> <span class=\"n\">PySparkSession</span>\n<span class=\"kn\">from</span> <span class=\"nn\">sqlglot.dataframe.sql.session</span> <span class=\"kn\">import</span> <span class=\"n\">SparkSession</span>\n<span class=\"kn\">from</span> <span class=\"nn\">sqlglot.dataframe.sql</span> <span class=\"kn\">import</span> <span class=\"n\">types</span>\n<span class=\"kn\">from</span> <span class=\"nn\">sqlglot.dataframe.sql</span> <span class=\"kn\">import</span> <span class=\"n\">functions</span> <span class=\"k\">as</span> <span class=\"n\">F</span>\n\n<span class=\"n\">data</span> <span class=\"o\">=</span> <span class=\"p\">[</span>\n    <span class=\"p\">(</span><span class=\"mi\">1</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Jack&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Shephard&quot;</span><span class=\"p\">,</span> <span class=\"mi\">34</span><span class=\"p\">),</span>\n    <span class=\"p\">(</span><span class=\"mi\">2</span><span class=\"p\">,</span> <span class=\"s2\">&quot;John&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Locke&quot;</span><span class=\"p\">,</span> <span class=\"mi\">48</span><span class=\"p\">),</span>\n    <span class=\"p\">(</span><span class=\"mi\">3</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Kate&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Austen&quot;</span><span class=\"p\">,</span> <span class=\"mi\">34</span><span class=\"p\">),</span>\n    <span class=\"p\">(</span><span class=\"mi\">4</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Claire&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Littleton&quot;</span><span class=\"p\">,</span> <span class=\"mi\">22</span><span class=\"p\">),</span>\n    <span class=\"p\">(</span><span class=\"mi\">5</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Hugo&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;Reyes&quot;</span><span class=\"p\">,</span> <span class=\"mi\">26</span><span class=\"p\">),</span>\n<span class=\"p\">]</span>\n<span class=\"n\">schema</span> <span class=\"o\">=</span> <span class=\"n\">types</span><span class=\"o\">.</span><span class=\"n\">StructType</span><span class=\"p\">([</span>\n    <span class=\"n\">types</span><span class=\"o\">.</span><span class=\"n\">StructField</span><span class=\"p\">(</span><span class=\"s1\">&#39;employee_id&#39;</span><span class=\"p\">,</span> <span class=\"n\">types</span><span class=\"o\">.</span><span class=\"n\">IntegerType</span><span class=\"p\">(),</span> <span class=\"kc\">False</span><span class=\"p\">),</span>\n    <span class=\"n\">types</span><span class=\"o\">.</span><span class=\"n\">StructField</span><span class=\"p\">(</span><span class=\"s1\">&#39;fname&#39;</span><span class=\"p\">,</span> <span class=\"n\">types</span><span class=\"o\">.</span><span class=\"n\">StringType</span><span class=\"p\">(),</span> <span class=\"kc\">False</span><span class=\"p\">),</span>\n    <span class=\"n\">types</span><span class=\"o\">.</span><span class=\"n\">StructField</span><span class=\"p\">(</span><span class=\"s1\">&#39;lname&#39;</span><span class=\"p\">,</span> <span class=\"n\">types</span><span class=\"o\">.</span><span class=\"n\">StringType</span><span class=\"p\">(),</span> <span class=\"kc\">False</span><span class=\"p\">),</span>\n    <span class=\"n\">types</span><span class=\"o\">.</span><span class=\"n\">StructField</span><span class=\"p\">(</span><span class=\"s1\">&#39;age&#39;</span><span class=\"p\">,</span> <span class=\"n\">types</span><span class=\"o\">.</span><span class=\"n\">IntegerType</span><span class=\"p\">(),</span> <span class=\"kc\">False</span><span class=\"p\">),</span>\n<span class=\"p\">])</span>\n\n<span class=\"n\">sql_statements</span> <span class=\"o\">=</span> <span class=\"p\">(</span>\n    <span class=\"n\">SparkSession</span><span class=\"p\">()</span>\n    <span class=\"o\">.</span><span class=\"n\">createDataFrame</span><span class=\"p\">(</span><span class=\"n\">data</span><span class=\"p\">,</span> <span class=\"n\">schema</span><span class=\"p\">)</span>\n    <span class=\"o\">.</span><span class=\"n\">groupBy</span><span class=\"p\">(</span><span class=\"n\">F</span><span class=\"o\">.</span><span class=\"n\">col</span><span class=\"p\">(</span><span class=\"s2\">&quot;age&quot;</span><span class=\"p\">))</span>\n    <span class=\"o\">.</span><span class=\"n\">agg</span><span class=\"p\">(</span><span class=\"n\">F</span><span class=\"o\">.</span><span class=\"n\">countDistinct</span><span class=\"p\">(</span><span class=\"n\">F</span><span class=\"o\">.</span><span class=\"n\">col</span><span class=\"p\">(</span><span class=\"s2\">&quot;employee_id&quot;</span><span class=\"p\">))</span><span class=\"o\">.</span><span class=\"n\">alias</span><span class=\"p\">(</span><span class=\"s2\">&quot;num_employees&quot;</span><span class=\"p\">))</span>\n    <span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">(</span><span class=\"n\">dialect</span><span class=\"o\">=</span><span class=\"s2\">&quot;spark&quot;</span><span class=\"p\">)</span>\n<span class=\"p\">)</span>\n\n<span class=\"n\">pyspark</span> <span class=\"o\">=</span> <span class=\"n\">PySparkSession</span><span class=\"o\">.</span><span class=\"n\">builder</span><span class=\"o\">.</span><span class=\"n\">master</span><span class=\"p\">(</span><span class=\"s2\">&quot;local[*]&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">getOrCreate</span><span class=\"p\">()</span>\n\n<span class=\"n\">df</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>\n<span class=\"k\">for</span> <span class=\"n\">sql</span> <span class=\"ow\">in</span> <span class=\"n\">sql_statements</span><span class=\"p\">:</span>\n    <span class=\"n\">df</span> <span class=\"o\">=</span> <span class=\"n\">pyspark</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">(</span><span class=\"n\">sql</span><span class=\"p\">)</span>\n\n<span class=\"k\">assert</span> <span class=\"n\">df</span> <span class=\"ow\">is</span> <span class=\"ow\">not</span> <span class=\"kc\">None</span>\n<span class=\"n\">df</span><span class=\"o\">.</span><span class=\"n\">show</span><span class=\"p\">()</span>\n</code></pre>\n</div>\n\n<h1 id=\"unsupportable-operations\">Unsupportable Operations</h1>\n\n<p>Any operation that lacks a way to represent it in SQL cannot be supported by this tool. An example of this would be rdd operations. Since the DataFrame API though is mostly modeled around SQL concepts most operations can be supported.</p>\n"}, "sqlglot.dataframe.sql": {"fullname": "sqlglot.dataframe.sql", "modulename": "sqlglot.dataframe.sql", "kind": "module", "doc": "<p></p>\n"}, "sqlglot.dataframe.sql.SparkSession": {"fullname": "sqlglot.dataframe.sql.SparkSession", "modulename": "sqlglot.dataframe.sql", "qualname": "SparkSession", "kind": "class", "doc": "<p></p>\n"}, "sqlglot.dataframe.sql.SparkSession.table": {"fullname": "sqlglot.dataframe.sql.SparkSession.table", "modulename": "sqlglot.dataframe.sql", "qualname": "SparkSession.table", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">tableName</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.SparkSession.createDataFrame": {"fullname": "sqlglot.dataframe.sql.SparkSession.createDataFrame", "modulename": "sqlglot.dataframe.sql", "qualname": "SparkSession.createDataFrame", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"n\">Sequence</span><span class=\"p\">[</span><span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"o\">&lt;</span><span class=\"n\">MagicMock</span> <span class=\"nb\">id</span><span class=\"o\">=</span><span class=\"s1\">&#39;140604724939168&#39;</span><span class=\"o\">&gt;</span><span class=\"p\">],</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"o\">&lt;</span><span class=\"n\">MagicMock</span> <span class=\"nb\">id</span><span class=\"o\">=</span><span class=\"s1\">&#39;140604724939168&#39;</span><span class=\"o\">&gt;</span><span class=\"p\">],</span> <span class=\"n\">Tuple</span><span class=\"p\">]]</span>,</span><span class=\"param\">\t<span class=\"n\">schema</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"o\">&lt;</span><span class=\"n\">MagicMock</span> <span class=\"nb\">id</span><span class=\"o\">=</span><span class=\"s1\">&#39;140604726296240&#39;</span><span class=\"o\">&gt;</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">samplingRatio</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">verifySchema</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.SparkSession.sql": {"fullname": "sqlglot.dataframe.sql.SparkSession.sql", "modulename": "sqlglot.dataframe.sql", "qualname": "SparkSession.sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">sqlQuery</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrame": {"fullname": "sqlglot.dataframe.sql.DataFrame", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame", "kind": "class", "doc": "<p></p>\n"}, "sqlglot.dataframe.sql.DataFrame.__init__": {"fullname": "sqlglot.dataframe.sql.DataFrame.__init__", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">spark</span><span class=\"p\">:</span> <span class=\"o\">&lt;</span><span class=\"n\">MagicMock</span> <span class=\"nb\">id</span><span class=\"o\">=</span><span class=\"s1\">&#39;140604728440864&#39;</span><span class=\"o\">&gt;</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Select</span>,</span><span class=\"param\">\t<span class=\"n\">branch_id</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">sequence_id</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">last_op</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">operations</span><span class=\"o\">.</span><span class=\"n\">Operation</span> <span class=\"o\">=</span> <span class=\"o\">&lt;</span><span class=\"n\">Operation</span><span class=\"o\">.</span><span class=\"n\">INIT</span><span class=\"p\">:</span> <span class=\"o\">-</span><span class=\"mi\">1</span><span class=\"o\">&gt;</span>,</span><span class=\"param\">\t<span class=\"n\">pending_hints</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">output_expression_container</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"o\">&lt;</span><span class=\"n\">MagicMock</span> <span class=\"nb\">id</span><span class=\"o\">=</span><span class=\"s1\">&#39;140604729565168&#39;</span><span class=\"o\">&gt;</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span>)</span>"}, "sqlglot.dataframe.sql.DataFrame.sql": {"fullname": "sqlglot.dataframe.sql.DataFrame.sql", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">dialect</span><span class=\"o\">=</span><span class=\"s1\">&#39;spark&#39;</span>, </span><span class=\"param\"><span class=\"n\">optimize</span><span class=\"o\">=</span><span class=\"kc\">True</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrame.copy": {"fullname": "sqlglot.dataframe.sql.DataFrame.copy", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.copy", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrame.select": {"fullname": "sqlglot.dataframe.sql.DataFrame.select", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.select", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">*</span><span class=\"n\">cols</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrame.alias": {"fullname": "sqlglot.dataframe.sql.DataFrame.alias", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.alias", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrame.where": {"fullname": "sqlglot.dataframe.sql.DataFrame.where", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.where", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">column</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span><span class=\"p\">,</span> <span class=\"nb\">bool</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrame.filter": {"fullname": "sqlglot.dataframe.sql.DataFrame.filter", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.filter", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">column</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span><span class=\"p\">,</span> <span class=\"nb\">bool</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrame.groupBy": {"fullname": "sqlglot.dataframe.sql.DataFrame.groupBy", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.groupBy", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">*</span><span class=\"n\">cols</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">group</span><span class=\"o\">.</span><span class=\"n\">GroupedData</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrame.agg": {"fullname": "sqlglot.dataframe.sql.DataFrame.agg", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.agg", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">*</span><span class=\"n\">exprs</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrame.join": {"fullname": "sqlglot.dataframe.sql.DataFrame.join", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.join", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">other_df</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>,</span><span class=\"param\">\t<span class=\"n\">on</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">],</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span><span class=\"p\">]]</span>,</span><span class=\"param\">\t<span class=\"n\">how</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;inner&#39;</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrame.orderBy": {"fullname": "sqlglot.dataframe.sql.DataFrame.orderBy", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.orderBy", "kind": "function", "doc": "<p>This implementation lets any ordered columns take priority over whatever is provided in <code>ascending</code>. Spark\nhas irregular behavior and can result in runtime errors. Users shouldn't be mixing the two anyways so this\nis unlikely to come up.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">cols</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">ascending</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">Any</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Any</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrame.sort": {"fullname": "sqlglot.dataframe.sql.DataFrame.sort", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.sort", "kind": "function", "doc": "<p>This implementation lets any ordered columns take priority over whatever is provided in <code>ascending</code>. Spark\nhas irregular behavior and can result in runtime errors. Users shouldn't be mixing the two anyways so this\nis unlikely to come up.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">cols</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">ascending</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">Any</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Any</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrame.union": {"fullname": "sqlglot.dataframe.sql.DataFrame.union", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.union", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">other</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrame.unionAll": {"fullname": "sqlglot.dataframe.sql.DataFrame.unionAll", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.unionAll", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">other</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrame.unionByName": {"fullname": "sqlglot.dataframe.sql.DataFrame.unionByName", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.unionByName", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">other</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>,</span><span class=\"param\">\t<span class=\"n\">allowMissingColumns</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrame.intersect": {"fullname": "sqlglot.dataframe.sql.DataFrame.intersect", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.intersect", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">other</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrame.intersectAll": {"fullname": "sqlglot.dataframe.sql.DataFrame.intersectAll", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.intersectAll", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">other</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrame.exceptAll": {"fullname": "sqlglot.dataframe.sql.DataFrame.exceptAll", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.exceptAll", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">other</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrame.distinct": {"fullname": "sqlglot.dataframe.sql.DataFrame.distinct", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.distinct", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrame.dropDuplicates": {"fullname": "sqlglot.dataframe.sql.DataFrame.dropDuplicates", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.dropDuplicates", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">subset</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrame.dropna": {"fullname": "sqlglot.dataframe.sql.DataFrame.dropna", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.dropna", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">how</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;any&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">thresh</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">subset</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"o\">...</span><span class=\"p\">],</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrame.fillna": {"fullname": "sqlglot.dataframe.sql.DataFrame.fillna", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.fillna", "kind": "function", "doc": "<p>Functionality Difference: If you provide a value to replace a null and that type conflicts\nwith the type of the column then PySpark will just ignore your replacement.\nThis will try to cast them to be the same in some cases. So they won't always match.\nBest to not mix types so make sure replacement is the same type as the column</p>\n\n<p>Possibility for improvement: Use <code>typeof</code> function to get the type of the column\nand check if it matches the type of the value provided. If not then make it null.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"o\">&lt;</span><span class=\"n\">MagicMock</span> <span class=\"nb\">id</span><span class=\"o\">=</span><span class=\"s1\">&#39;140604723599328&#39;</span><span class=\"o\">&gt;</span>,</span><span class=\"param\">\t<span class=\"n\">subset</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"o\">...</span><span class=\"p\">],</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrame.replace": {"fullname": "sqlglot.dataframe.sql.DataFrame.replace", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.replace", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">to_replace</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">,</span> <span class=\"n\">Dict</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">subset</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">Collection</span><span class=\"p\">[</span><span class=\"o\">&lt;</span><span class=\"n\">MagicMock</span> <span class=\"nb\">id</span><span class=\"o\">=</span><span class=\"s1\">&#39;140604723535904&#39;</span><span class=\"o\">&gt;</span><span class=\"p\">],</span> <span class=\"o\">&lt;</span><span class=\"n\">MagicMock</span> <span class=\"nb\">id</span><span class=\"o\">=</span><span class=\"s1\">&#39;140604723535904&#39;</span><span class=\"o\">&gt;</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrame.withColumn": {"fullname": "sqlglot.dataframe.sql.DataFrame.withColumn", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.withColumn", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">colName</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">col</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrame.withColumnRenamed": {"fullname": "sqlglot.dataframe.sql.DataFrame.withColumnRenamed", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.withColumnRenamed", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">existing</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">new</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrame.drop": {"fullname": "sqlglot.dataframe.sql.DataFrame.drop", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.drop", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">cols</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrame.limit": {"fullname": "sqlglot.dataframe.sql.DataFrame.limit", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.limit", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">num</span><span class=\"p\">:</span> <span class=\"nb\">int</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrame.hint": {"fullname": "sqlglot.dataframe.sql.DataFrame.hint", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.hint", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">parameters</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrame.repartition": {"fullname": "sqlglot.dataframe.sql.DataFrame.repartition", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.repartition", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">numPartitions</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"o\">&lt;</span><span class=\"n\">MagicMock</span> <span class=\"nb\">id</span><span class=\"o\">=</span><span class=\"s1\">&#39;140604723822992&#39;</span><span class=\"o\">&gt;</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">cols</span><span class=\"p\">:</span> <span class=\"o\">&lt;</span><span class=\"n\">MagicMock</span> <span class=\"nb\">id</span><span class=\"o\">=</span><span class=\"s1\">&#39;140604723880880&#39;</span><span class=\"o\">&gt;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrame.coalesce": {"fullname": "sqlglot.dataframe.sql.DataFrame.coalesce", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.coalesce", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">numPartitions</span><span class=\"p\">:</span> <span class=\"nb\">int</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrame.cache": {"fullname": "sqlglot.dataframe.sql.DataFrame.cache", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.cache", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrame.persist": {"fullname": "sqlglot.dataframe.sql.DataFrame.persist", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrame.persist", "kind": "function", "doc": "<p>Storage Level Options: <a href=\"https://spark.apache.org/docs/3.0.0-preview/sql-ref-syntax-aux-cache-cache-table.html\">https://spark.apache.org/docs/3.0.0-preview/sql-ref-syntax-aux-cache-cache-table.html</a></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">storageLevel</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;MEMORY_AND_DISK_SER&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.GroupedData": {"fullname": "sqlglot.dataframe.sql.GroupedData", "modulename": "sqlglot.dataframe.sql", "qualname": "GroupedData", "kind": "class", "doc": "<p></p>\n"}, "sqlglot.dataframe.sql.GroupedData.__init__": {"fullname": "sqlglot.dataframe.sql.GroupedData.__init__", "modulename": "sqlglot.dataframe.sql", "qualname": "GroupedData.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">df</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>,</span><span class=\"param\">\t<span class=\"n\">group_by_cols</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">last_op</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">operations</span><span class=\"o\">.</span><span class=\"n\">Operation</span></span>)</span>"}, "sqlglot.dataframe.sql.GroupedData.agg": {"fullname": "sqlglot.dataframe.sql.GroupedData.agg", "modulename": "sqlglot.dataframe.sql", "qualname": "GroupedData.agg", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">exprs</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span><span class=\"p\">,</span> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">]]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.GroupedData.count": {"fullname": "sqlglot.dataframe.sql.GroupedData.count", "modulename": "sqlglot.dataframe.sql", "qualname": "GroupedData.count", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.GroupedData.mean": {"fullname": "sqlglot.dataframe.sql.GroupedData.mean", "modulename": "sqlglot.dataframe.sql", "qualname": "GroupedData.mean", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">*</span><span class=\"n\">cols</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.GroupedData.avg": {"fullname": "sqlglot.dataframe.sql.GroupedData.avg", "modulename": "sqlglot.dataframe.sql", "qualname": "GroupedData.avg", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">*</span><span class=\"n\">cols</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.GroupedData.max": {"fullname": "sqlglot.dataframe.sql.GroupedData.max", "modulename": "sqlglot.dataframe.sql", "qualname": "GroupedData.max", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">*</span><span class=\"n\">cols</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.GroupedData.min": {"fullname": "sqlglot.dataframe.sql.GroupedData.min", "modulename": "sqlglot.dataframe.sql", "qualname": "GroupedData.min", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">*</span><span class=\"n\">cols</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.GroupedData.sum": {"fullname": "sqlglot.dataframe.sql.GroupedData.sum", "modulename": "sqlglot.dataframe.sql", "qualname": "GroupedData.sum", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">*</span><span class=\"n\">cols</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.GroupedData.pivot": {"fullname": "sqlglot.dataframe.sql.GroupedData.pivot", "modulename": "sqlglot.dataframe.sql", "qualname": "GroupedData.pivot", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">*</span><span class=\"n\">cols</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.Column": {"fullname": "sqlglot.dataframe.sql.Column", "modulename": "sqlglot.dataframe.sql", "qualname": "Column", "kind": "class", "doc": "<p></p>\n"}, "sqlglot.dataframe.sql.Column.__init__": {"fullname": "sqlglot.dataframe.sql.Column.__init__", "modulename": "sqlglot.dataframe.sql", "qualname": "Column.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"o\">&lt;</span><span class=\"n\">MagicMock</span> <span class=\"nb\">id</span><span class=\"o\">=</span><span class=\"s1\">&#39;140604725847056&#39;</span><span class=\"o\">&gt;</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span></span>)</span>"}, "sqlglot.dataframe.sql.Column.ensure_col": {"fullname": "sqlglot.dataframe.sql.Column.ensure_col", "modulename": "sqlglot.dataframe.sql", "qualname": "Column.ensure_col", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">cls</span>,</span><span class=\"param\">\t<span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"o\">&lt;</span><span class=\"n\">MagicMock</span> <span class=\"nb\">id</span><span class=\"o\">=</span><span class=\"s1\">&#39;140604723943728&#39;</span><span class=\"o\">&gt;</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.Column.ensure_cols": {"fullname": "sqlglot.dataframe.sql.Column.ensure_cols", "modulename": "sqlglot.dataframe.sql", "qualname": "Column.ensure_cols", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">cls</span>,</span><span class=\"param\">\t<span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"o\">&lt;</span><span class=\"n\">MagicMock</span> <span class=\"nb\">id</span><span class=\"o\">=</span><span class=\"s1\">&#39;140604723933680&#39;</span><span class=\"o\">&gt;</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">]]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.Column.invoke_anonymous_function": {"fullname": "sqlglot.dataframe.sql.Column.invoke_anonymous_function", "modulename": "sqlglot.dataframe.sql", "qualname": "Column.invoke_anonymous_function", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">cls</span>,</span><span class=\"param\">\t<span class=\"n\">column</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"o\">&lt;</span><span class=\"n\">MagicMock</span> <span class=\"nb\">id</span><span class=\"o\">=</span><span class=\"s1\">&#39;140604724460464&#39;</span><span class=\"o\">&gt;</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">func_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"o\">&lt;</span><span class=\"n\">MagicMock</span> <span class=\"nb\">id</span><span class=\"o\">=</span><span class=\"s1\">&#39;140604724156480&#39;</span><span class=\"o\">&gt;</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.Column.invoke_expression_over_column": {"fullname": "sqlglot.dataframe.sql.Column.invoke_expression_over_column", "modulename": "sqlglot.dataframe.sql", "qualname": "Column.invoke_expression_over_column", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">cls</span>,</span><span class=\"param\">\t<span class=\"n\">column</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"o\">&lt;</span><span class=\"n\">MagicMock</span> <span class=\"nb\">id</span><span class=\"o\">=</span><span class=\"s1\">&#39;140604724090944&#39;</span><span class=\"o\">&gt;</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">callable_expression</span><span class=\"p\">:</span> <span class=\"n\">Callable</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.Column.binary_op": {"fullname": "sqlglot.dataframe.sql.Column.binary_op", "modulename": "sqlglot.dataframe.sql", "qualname": "Column.binary_op", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">klass</span><span class=\"p\">:</span> <span class=\"n\">Callable</span>,</span><span class=\"param\">\t<span class=\"n\">other</span><span class=\"p\">:</span> <span class=\"o\">&lt;</span><span class=\"n\">MagicMock</span> <span class=\"nb\">id</span><span class=\"o\">=</span><span class=\"s1\">&#39;140604724048944&#39;</span><span class=\"o\">&gt;</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.Column.inverse_binary_op": {"fullname": "sqlglot.dataframe.sql.Column.inverse_binary_op", "modulename": "sqlglot.dataframe.sql", "qualname": "Column.inverse_binary_op", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">klass</span><span class=\"p\">:</span> <span class=\"n\">Callable</span>,</span><span class=\"param\">\t<span class=\"n\">other</span><span class=\"p\">:</span> <span class=\"o\">&lt;</span><span class=\"n\">MagicMock</span> <span class=\"nb\">id</span><span class=\"o\">=</span><span class=\"s1\">&#39;140604724339344&#39;</span><span class=\"o\">&gt;</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.Column.unary_op": {"fullname": "sqlglot.dataframe.sql.Column.unary_op", "modulename": "sqlglot.dataframe.sql", "qualname": "Column.unary_op", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">klass</span><span class=\"p\">:</span> <span class=\"n\">Callable</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.Column.ensure_literal": {"fullname": "sqlglot.dataframe.sql.Column.ensure_literal", "modulename": "sqlglot.dataframe.sql", "qualname": "Column.ensure_literal", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span>, </span><span class=\"param\"><span class=\"n\">value</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.Column.copy": {"fullname": "sqlglot.dataframe.sql.Column.copy", "modulename": "sqlglot.dataframe.sql", "qualname": "Column.copy", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.Column.set_table_name": {"fullname": "sqlglot.dataframe.sql.Column.set_table_name", "modulename": "sqlglot.dataframe.sql", "qualname": "Column.set_table_name", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">table_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">copy</span><span class=\"o\">=</span><span class=\"kc\">False</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.Column.sql": {"fullname": "sqlglot.dataframe.sql.Column.sql", "modulename": "sqlglot.dataframe.sql", "qualname": "Column.sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.Column.alias": {"fullname": "sqlglot.dataframe.sql.Column.alias", "modulename": "sqlglot.dataframe.sql", "qualname": "Column.alias", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.Column.asc": {"fullname": "sqlglot.dataframe.sql.Column.asc", "modulename": "sqlglot.dataframe.sql", "qualname": "Column.asc", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.Column.desc": {"fullname": "sqlglot.dataframe.sql.Column.desc", "modulename": "sqlglot.dataframe.sql", "qualname": "Column.desc", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.Column.asc_nulls_first": {"fullname": "sqlglot.dataframe.sql.Column.asc_nulls_first", "modulename": "sqlglot.dataframe.sql", "qualname": "Column.asc_nulls_first", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.Column.asc_nulls_last": {"fullname": "sqlglot.dataframe.sql.Column.asc_nulls_last", "modulename": "sqlglot.dataframe.sql", "qualname": "Column.asc_nulls_last", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.Column.desc_nulls_first": {"fullname": "sqlglot.dataframe.sql.Column.desc_nulls_first", "modulename": "sqlglot.dataframe.sql", "qualname": "Column.desc_nulls_first", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.Column.desc_nulls_last": {"fullname": "sqlglot.dataframe.sql.Column.desc_nulls_last", "modulename": "sqlglot.dataframe.sql", "qualname": "Column.desc_nulls_last", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.Column.when": {"fullname": "sqlglot.dataframe.sql.Column.when", "modulename": "sqlglot.dataframe.sql", "qualname": "Column.when", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">condition</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span>,</span><span class=\"param\">\t<span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"n\">Any</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.Column.otherwise": {"fullname": "sqlglot.dataframe.sql.Column.otherwise", "modulename": "sqlglot.dataframe.sql", "qualname": "Column.otherwise", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"n\">Any</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.Column.isNull": {"fullname": "sqlglot.dataframe.sql.Column.isNull", "modulename": "sqlglot.dataframe.sql", "qualname": "Column.isNull", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.Column.isNotNull": {"fullname": "sqlglot.dataframe.sql.Column.isNotNull", "modulename": "sqlglot.dataframe.sql", "qualname": "Column.isNotNull", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.Column.cast": {"fullname": "sqlglot.dataframe.sql.Column.cast", "modulename": "sqlglot.dataframe.sql", "qualname": "Column.cast", "kind": "function", "doc": "<p>Functionality Difference: PySpark cast accepts a datatype instance of the datatype class\nSqlglot doesn't currently replicate this class so it only accepts a string</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">dataType</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">types</span><span class=\"o\">.</span><span class=\"n\">DataType</span><span class=\"p\">]</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.Column.startswith": {"fullname": "sqlglot.dataframe.sql.Column.startswith", "modulename": "sqlglot.dataframe.sql", "qualname": "Column.startswith", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.Column.endswith": {"fullname": "sqlglot.dataframe.sql.Column.endswith", "modulename": "sqlglot.dataframe.sql", "qualname": "Column.endswith", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.Column.rlike": {"fullname": "sqlglot.dataframe.sql.Column.rlike", "modulename": "sqlglot.dataframe.sql", "qualname": "Column.rlike", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">regexp</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.Column.like": {"fullname": "sqlglot.dataframe.sql.Column.like", "modulename": "sqlglot.dataframe.sql", "qualname": "Column.like", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">other</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.Column.ilike": {"fullname": "sqlglot.dataframe.sql.Column.ilike", "modulename": "sqlglot.dataframe.sql", "qualname": "Column.ilike", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">other</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.Column.substr": {"fullname": "sqlglot.dataframe.sql.Column.substr", "modulename": "sqlglot.dataframe.sql", "qualname": "Column.substr", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">startPos</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">length</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.Column.isin": {"fullname": "sqlglot.dataframe.sql.Column.isin", "modulename": "sqlglot.dataframe.sql", "qualname": "Column.isin", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">cols</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"o\">&lt;</span><span class=\"n\">MagicMock</span> <span class=\"nb\">id</span><span class=\"o\">=</span><span class=\"s1\">&#39;140604722499344&#39;</span><span class=\"o\">&gt;</span><span class=\"p\">,</span> <span class=\"n\">Iterable</span><span class=\"p\">[</span><span class=\"o\">&lt;</span><span class=\"n\">MagicMock</span> <span class=\"nb\">id</span><span class=\"o\">=</span><span class=\"s1\">&#39;140604722499344&#39;</span><span class=\"o\">&gt;</span><span class=\"p\">]]</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.Column.between": {"fullname": "sqlglot.dataframe.sql.Column.between", "modulename": "sqlglot.dataframe.sql", "qualname": "Column.between", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">lowerBound</span><span class=\"p\">:</span> <span class=\"o\">&lt;</span><span class=\"n\">MagicMock</span> <span class=\"nb\">id</span><span class=\"o\">=</span><span class=\"s1\">&#39;140604722556992&#39;</span><span class=\"o\">&gt;</span>,</span><span class=\"param\">\t<span class=\"n\">upperBound</span><span class=\"p\">:</span> <span class=\"o\">&lt;</span><span class=\"n\">MagicMock</span> <span class=\"nb\">id</span><span class=\"o\">=</span><span class=\"s1\">&#39;140604722616528&#39;</span><span class=\"o\">&gt;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.Column.over": {"fullname": "sqlglot.dataframe.sql.Column.over", "modulename": "sqlglot.dataframe.sql", "qualname": "Column.over", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">window</span><span class=\"p\">:</span> <span class=\"o\">&lt;</span><span class=\"n\">MagicMock</span> <span class=\"nb\">id</span><span class=\"o\">=</span><span class=\"s1\">&#39;140604722692160&#39;</span><span class=\"o\">&gt;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">column</span><span class=\"o\">.</span><span class=\"n\">Column</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrameNaFunctions": {"fullname": "sqlglot.dataframe.sql.DataFrameNaFunctions", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrameNaFunctions", "kind": "class", "doc": "<p></p>\n"}, "sqlglot.dataframe.sql.DataFrameNaFunctions.__init__": {"fullname": "sqlglot.dataframe.sql.DataFrameNaFunctions.__init__", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrameNaFunctions.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">df</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span></span>)</span>"}, "sqlglot.dataframe.sql.DataFrameNaFunctions.drop": {"fullname": "sqlglot.dataframe.sql.DataFrameNaFunctions.drop", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrameNaFunctions.drop", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">how</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;any&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">thresh</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">subset</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"o\">...</span><span class=\"p\">],</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrameNaFunctions.fill": {"fullname": "sqlglot.dataframe.sql.DataFrameNaFunctions.fill", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrameNaFunctions.fill", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">bool</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]]</span>,</span><span class=\"param\">\t<span class=\"n\">subset</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"o\">...</span><span class=\"p\">],</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrameNaFunctions.replace": {"fullname": "sqlglot.dataframe.sql.DataFrameNaFunctions.replace", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrameNaFunctions.replace", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">to_replace</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">,</span> <span class=\"n\">Dict</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">subset</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.Window": {"fullname": "sqlglot.dataframe.sql.Window", "modulename": "sqlglot.dataframe.sql", "qualname": "Window", "kind": "class", "doc": "<p></p>\n"}, "sqlglot.dataframe.sql.Window.partitionBy": {"fullname": "sqlglot.dataframe.sql.Window.partitionBy", "modulename": "sqlglot.dataframe.sql", "qualname": "Window.partitionBy", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">cls</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">cols</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"o\">&lt;</span><span class=\"n\">MagicMock</span> <span class=\"nb\">id</span><span class=\"o\">=</span><span class=\"s1\">&#39;140604722964432&#39;</span><span class=\"o\">&gt;</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"o\">&lt;</span><span class=\"n\">MagicMock</span> <span class=\"nb\">id</span><span class=\"o\">=</span><span class=\"s1\">&#39;140604722964432&#39;</span><span class=\"o\">&gt;</span><span class=\"p\">]]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">window</span><span class=\"o\">.</span><span class=\"n\">WindowSpec</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.Window.orderBy": {"fullname": "sqlglot.dataframe.sql.Window.orderBy", "modulename": "sqlglot.dataframe.sql", "qualname": "Window.orderBy", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">cls</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">cols</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"o\">&lt;</span><span class=\"n\">MagicMock</span> <span class=\"nb\">id</span><span class=\"o\">=</span><span class=\"s1\">&#39;140604723170512&#39;</span><span class=\"o\">&gt;</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"o\">&lt;</span><span class=\"n\">MagicMock</span> <span class=\"nb\">id</span><span class=\"o\">=</span><span class=\"s1\">&#39;140604723170512&#39;</span><span class=\"o\">&gt;</span><span class=\"p\">]]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">window</span><span class=\"o\">.</span><span class=\"n\">WindowSpec</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.Window.rowsBetween": {"fullname": "sqlglot.dataframe.sql.Window.rowsBetween", "modulename": "sqlglot.dataframe.sql", "qualname": "Window.rowsBetween", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span>, </span><span class=\"param\"><span class=\"n\">start</span><span class=\"p\">:</span> <span class=\"nb\">int</span>, </span><span class=\"param\"><span class=\"n\">end</span><span class=\"p\">:</span> <span class=\"nb\">int</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">window</span><span class=\"o\">.</span><span class=\"n\">WindowSpec</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.Window.rangeBetween": {"fullname": "sqlglot.dataframe.sql.Window.rangeBetween", "modulename": "sqlglot.dataframe.sql", "qualname": "Window.rangeBetween", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span>, </span><span class=\"param\"><span class=\"n\">start</span><span class=\"p\">:</span> <span class=\"nb\">int</span>, </span><span class=\"param\"><span class=\"n\">end</span><span class=\"p\">:</span> <span class=\"nb\">int</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">window</span><span class=\"o\">.</span><span class=\"n\">WindowSpec</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.WindowSpec": {"fullname": "sqlglot.dataframe.sql.WindowSpec", "modulename": "sqlglot.dataframe.sql", "qualname": "WindowSpec", "kind": "class", "doc": "<p></p>\n"}, "sqlglot.dataframe.sql.WindowSpec.__init__": {"fullname": "sqlglot.dataframe.sql.WindowSpec.__init__", "modulename": "sqlglot.dataframe.sql", "qualname": "WindowSpec.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span> <span class=\"o\">=</span> <span class=\"p\">(</span><span class=\"n\">WINDOW</span> <span class=\"p\">)</span></span>)</span>"}, "sqlglot.dataframe.sql.WindowSpec.copy": {"fullname": "sqlglot.dataframe.sql.WindowSpec.copy", "modulename": "sqlglot.dataframe.sql", "qualname": "WindowSpec.copy", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.WindowSpec.sql": {"fullname": "sqlglot.dataframe.sql.WindowSpec.sql", "modulename": "sqlglot.dataframe.sql", "qualname": "WindowSpec.sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.WindowSpec.partitionBy": {"fullname": "sqlglot.dataframe.sql.WindowSpec.partitionBy", "modulename": "sqlglot.dataframe.sql", "qualname": "WindowSpec.partitionBy", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">cols</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"o\">&lt;</span><span class=\"n\">MagicMock</span> <span class=\"nb\">id</span><span class=\"o\">=</span><span class=\"s1\">&#39;140604723060480&#39;</span><span class=\"o\">&gt;</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"o\">&lt;</span><span class=\"n\">MagicMock</span> <span class=\"nb\">id</span><span class=\"o\">=</span><span class=\"s1\">&#39;140604723060480&#39;</span><span class=\"o\">&gt;</span><span class=\"p\">]]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">window</span><span class=\"o\">.</span><span class=\"n\">WindowSpec</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.WindowSpec.orderBy": {"fullname": "sqlglot.dataframe.sql.WindowSpec.orderBy", "modulename": "sqlglot.dataframe.sql", "qualname": "WindowSpec.orderBy", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">cols</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"o\">&lt;</span><span class=\"n\">MagicMock</span> <span class=\"nb\">id</span><span class=\"o\">=</span><span class=\"s1\">&#39;140604722718768&#39;</span><span class=\"o\">&gt;</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"o\">&lt;</span><span class=\"n\">MagicMock</span> <span class=\"nb\">id</span><span class=\"o\">=</span><span class=\"s1\">&#39;140604722718768&#39;</span><span class=\"o\">&gt;</span><span class=\"p\">]]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">window</span><span class=\"o\">.</span><span class=\"n\">WindowSpec</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.WindowSpec.rowsBetween": {"fullname": "sqlglot.dataframe.sql.WindowSpec.rowsBetween", "modulename": "sqlglot.dataframe.sql", "qualname": "WindowSpec.rowsBetween", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">start</span><span class=\"p\">:</span> <span class=\"nb\">int</span>, </span><span class=\"param\"><span class=\"n\">end</span><span class=\"p\">:</span> <span class=\"nb\">int</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">window</span><span class=\"o\">.</span><span class=\"n\">WindowSpec</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.WindowSpec.rangeBetween": {"fullname": "sqlglot.dataframe.sql.WindowSpec.rangeBetween", "modulename": "sqlglot.dataframe.sql", "qualname": "WindowSpec.rangeBetween", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">start</span><span class=\"p\">:</span> <span class=\"nb\">int</span>, </span><span class=\"param\"><span class=\"n\">end</span><span class=\"p\">:</span> <span class=\"nb\">int</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">window</span><span class=\"o\">.</span><span class=\"n\">WindowSpec</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrameReader": {"fullname": "sqlglot.dataframe.sql.DataFrameReader", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrameReader", "kind": "class", "doc": "<p></p>\n"}, "sqlglot.dataframe.sql.DataFrameReader.__init__": {"fullname": "sqlglot.dataframe.sql.DataFrameReader.__init__", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrameReader.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">spark</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">session</span><span class=\"o\">.</span><span class=\"n\">SparkSession</span></span>)</span>"}, "sqlglot.dataframe.sql.DataFrameReader.table": {"fullname": "sqlglot.dataframe.sql.DataFrameReader.table", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrameReader.table", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">tableName</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrameWriter": {"fullname": "sqlglot.dataframe.sql.DataFrameWriter", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrameWriter", "kind": "class", "doc": "<p></p>\n"}, "sqlglot.dataframe.sql.DataFrameWriter.__init__": {"fullname": "sqlglot.dataframe.sql.DataFrameWriter.__init__", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrameWriter.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">df</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>,</span><span class=\"param\">\t<span class=\"n\">spark</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">session</span><span class=\"o\">.</span><span class=\"n\">SparkSession</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">mode</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">by_name</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span></span>)</span>"}, "sqlglot.dataframe.sql.DataFrameWriter.copy": {"fullname": "sqlglot.dataframe.sql.DataFrameWriter.copy", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrameWriter.copy", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">readwriter</span><span class=\"o\">.</span><span class=\"n\">DataFrameWriter</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrameWriter.sql": {"fullname": "sqlglot.dataframe.sql.DataFrameWriter.sql", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrameWriter.sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrameWriter.mode": {"fullname": "sqlglot.dataframe.sql.DataFrameWriter.mode", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrameWriter.mode", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">saveMode</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">readwriter</span><span class=\"o\">.</span><span class=\"n\">DataFrameWriter</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrameWriter.insertInto": {"fullname": "sqlglot.dataframe.sql.DataFrameWriter.insertInto", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrameWriter.insertInto", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">tableName</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">overwrite</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dataframe</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"o\">.</span><span class=\"n\">readwriter</span><span class=\"o\">.</span><span class=\"n\">DataFrameWriter</span>:</span></span>", "funcdef": "def"}, "sqlglot.dataframe.sql.DataFrameWriter.saveAsTable": {"fullname": "sqlglot.dataframe.sql.DataFrameWriter.saveAsTable", "modulename": "sqlglot.dataframe.sql", "qualname": "DataFrameWriter.saveAsTable", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"nb\">format</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">mode</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlglot.dialects": {"fullname": "sqlglot.dialects", "modulename": "sqlglot.dialects", "kind": "module", "doc": "<h2 id=\"dialects\">Dialects</h2>\n\n<p>While there is a SQL standard, most SQL engines support a variation of that standard. This makes it difficult\nto write portable SQL code. SQLGlot bridges all the different variations, called \"dialects\", with an extensible\nSQL transpilation framework. </p>\n\n<p>The base <code>sqlglot.dialects.dialect.Dialect</code> class implements a generic dialect that aims to be as universal as possible.</p>\n\n<p>Each SQL variation has its own <code>Dialect</code> subclass, extending the corresponding <code>Tokenizer</code>, <code>Parser</code> and <code>Generator</code>\nclasses as needed.</p>\n\n<h3 id=\"implementing-a-custom-dialect\">Implementing a custom Dialect</h3>\n\n<p>Consider the following example:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"kn\">from</span> <span class=\"nn\">sqlglot</span> <span class=\"kn\">import</span> <span class=\"n\">exp</span>\n<span class=\"kn\">from</span> <span class=\"nn\">sqlglot.dialects.dialect</span> <span class=\"kn\">import</span> <span class=\"n\">Dialect</span>\n<span class=\"kn\">from</span> <span class=\"nn\">sqlglot.generator</span> <span class=\"kn\">import</span> <span class=\"n\">Generator</span>\n<span class=\"kn\">from</span> <span class=\"nn\">sqlglot.tokens</span> <span class=\"kn\">import</span> <span class=\"n\">Tokenizer</span><span class=\"p\">,</span> <span class=\"n\">TokenType</span>\n\n\n<span class=\"k\">class</span> <span class=\"nc\">Custom</span><span class=\"p\">(</span><span class=\"n\">Dialect</span><span class=\"p\">):</span>\n    <span class=\"k\">class</span> <span class=\"nc\">Tokenizer</span><span class=\"p\">(</span><span class=\"n\">Tokenizer</span><span class=\"p\">):</span>\n        <span class=\"n\">QUOTES</span> <span class=\"o\">=</span> <span class=\"p\">[</span><span class=\"s2\">&quot;&#39;&quot;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;&quot;&#39;</span><span class=\"p\">]</span>\n        <span class=\"n\">IDENTIFIERS</span> <span class=\"o\">=</span> <span class=\"p\">[</span><span class=\"s2\">&quot;`&quot;</span><span class=\"p\">]</span>\n\n        <span class=\"n\">KEYWORDS</span> <span class=\"o\">=</span> <span class=\"p\">{</span>\n            <span class=\"o\">**</span><span class=\"n\">Tokenizer</span><span class=\"o\">.</span><span class=\"n\">KEYWORDS</span><span class=\"p\">,</span>\n            <span class=\"s2\">&quot;INT64&quot;</span><span class=\"p\">:</span> <span class=\"n\">TokenType</span><span class=\"o\">.</span><span class=\"n\">BIGINT</span><span class=\"p\">,</span>\n            <span class=\"s2\">&quot;FLOAT64&quot;</span><span class=\"p\">:</span> <span class=\"n\">TokenType</span><span class=\"o\">.</span><span class=\"n\">DOUBLE</span><span class=\"p\">,</span>\n        <span class=\"p\">}</span>\n\n    <span class=\"k\">class</span> <span class=\"nc\">Generator</span><span class=\"p\">(</span><span class=\"n\">Generator</span><span class=\"p\">):</span>\n        <span class=\"n\">TRANSFORMS</span> <span class=\"o\">=</span> <span class=\"p\">{</span><span class=\"n\">exp</span><span class=\"o\">.</span><span class=\"n\">Array</span><span class=\"p\">:</span> <span class=\"k\">lambda</span> <span class=\"bp\">self</span><span class=\"p\">,</span> <span class=\"n\">e</span><span class=\"p\">:</span> <span class=\"sa\">f</span><span class=\"s2\">&quot;[</span><span class=\"si\">{</span><span class=\"bp\">self</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"p\">(</span><span class=\"n\">e</span><span class=\"p\">)</span><span class=\"si\">}</span><span class=\"s2\">]&quot;</span><span class=\"p\">}</span>\n\n        <span class=\"n\">TYPE_MAPPING</span> <span class=\"o\">=</span> <span class=\"p\">{</span>\n            <span class=\"n\">exp</span><span class=\"o\">.</span><span class=\"n\">DataType</span><span class=\"o\">.</span><span class=\"n\">Type</span><span class=\"o\">.</span><span class=\"n\">TINYINT</span><span class=\"p\">:</span> <span class=\"s2\">&quot;INT64&quot;</span><span class=\"p\">,</span>\n            <span class=\"n\">exp</span><span class=\"o\">.</span><span class=\"n\">DataType</span><span class=\"o\">.</span><span class=\"n\">Type</span><span class=\"o\">.</span><span class=\"n\">SMALLINT</span><span class=\"p\">:</span> <span class=\"s2\">&quot;INT64&quot;</span><span class=\"p\">,</span>\n            <span class=\"n\">exp</span><span class=\"o\">.</span><span class=\"n\">DataType</span><span class=\"o\">.</span><span class=\"n\">Type</span><span class=\"o\">.</span><span class=\"n\">INT</span><span class=\"p\">:</span> <span class=\"s2\">&quot;INT64&quot;</span><span class=\"p\">,</span>\n            <span class=\"n\">exp</span><span class=\"o\">.</span><span class=\"n\">DataType</span><span class=\"o\">.</span><span class=\"n\">Type</span><span class=\"o\">.</span><span class=\"n\">BIGINT</span><span class=\"p\">:</span> <span class=\"s2\">&quot;INT64&quot;</span><span class=\"p\">,</span>\n            <span class=\"n\">exp</span><span class=\"o\">.</span><span class=\"n\">DataType</span><span class=\"o\">.</span><span class=\"n\">Type</span><span class=\"o\">.</span><span class=\"n\">DECIMAL</span><span class=\"p\">:</span> <span class=\"s2\">&quot;NUMERIC&quot;</span><span class=\"p\">,</span>\n            <span class=\"n\">exp</span><span class=\"o\">.</span><span class=\"n\">DataType</span><span class=\"o\">.</span><span class=\"n\">Type</span><span class=\"o\">.</span><span class=\"n\">FLOAT</span><span class=\"p\">:</span> <span class=\"s2\">&quot;FLOAT64&quot;</span><span class=\"p\">,</span>\n            <span class=\"n\">exp</span><span class=\"o\">.</span><span class=\"n\">DataType</span><span class=\"o\">.</span><span class=\"n\">Type</span><span class=\"o\">.</span><span class=\"n\">DOUBLE</span><span class=\"p\">:</span> <span class=\"s2\">&quot;FLOAT64&quot;</span><span class=\"p\">,</span>\n            <span class=\"n\">exp</span><span class=\"o\">.</span><span class=\"n\">DataType</span><span class=\"o\">.</span><span class=\"n\">Type</span><span class=\"o\">.</span><span class=\"n\">BOOLEAN</span><span class=\"p\">:</span> <span class=\"s2\">&quot;BOOL&quot;</span><span class=\"p\">,</span>\n            <span class=\"n\">exp</span><span class=\"o\">.</span><span class=\"n\">DataType</span><span class=\"o\">.</span><span class=\"n\">Type</span><span class=\"o\">.</span><span class=\"n\">TEXT</span><span class=\"p\">:</span> <span class=\"s2\">&quot;STRING&quot;</span><span class=\"p\">,</span>\n        <span class=\"p\">}</span>\n</code></pre>\n</div>\n\n<p>This is a typical example of adding a new dialect implementation in SQLGlot: we specify its identifier and string\ndelimiters, as well as what tokens it uses for its types and how they're associated with SQLGlot types. Since\nthe <code>Expression</code> classes are common for each dialect supported in SQLGlot, we may also need to override the generation\nlogic for some expressions; this is usually done by adding new entries to the <code>TRANSFORMS</code> mapping.</p>\n\n<hr />\n"}, "sqlglot.dialects.bigquery": {"fullname": "sqlglot.dialects.bigquery", "modulename": "sqlglot.dialects.bigquery", "kind": "module", "doc": "<p></p>\n"}, "sqlglot.dialects.bigquery.BigQuery": {"fullname": "sqlglot.dialects.bigquery.BigQuery", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery", "kind": "class", "doc": "<p></p>\n", "bases": "sqlglot.dialects.dialect.Dialect"}, "sqlglot.dialects.bigquery.BigQuery.Tokenizer": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Tokenizer", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Tokenizer", "kind": "class", "doc": "<p></p>\n", "bases": "sqlglot.tokens.Tokenizer"}, "sqlglot.dialects.bigquery.BigQuery.Parser": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Parser", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Parser", "kind": "class", "doc": "<p>Parser consumes a list of tokens produced by the <code>sqlglot.tokens.Tokenizer</code> and produces\na parsed syntax tree.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>error_level:</strong>  the desired error level.\nDefault: ErrorLevel.IMMEDIATE</li>\n<li><strong>error_message_context:</strong>  determines the amount of context to capture from a\nquery string when displaying the error message (in number of characters).\nDefault: 50.</li>\n<li><strong>index_offset:</strong>  Index offset for arrays eg ARRAY[0] vs ARRAY[1] as the head of a list.\nDefault: 0</li>\n<li><strong>alias_post_tablesample:</strong>  If the table alias comes after tablesample.\nDefault: False</li>\n<li><strong>max_errors:</strong>  Maximum number of error messages to include in a raised ParseError.\nThis is only relevant if error_level is ErrorLevel.RAISE.\nDefault: 3</li>\n<li><strong>null_ordering:</strong>  Indicates the default null ordering method to use if not explicitly set.\nOptions are \"nulls_are_small\", \"nulls_are_large\", \"nulls_are_last\".\nDefault: \"nulls_are_small\"</li>\n</ul>\n", "bases": "sqlglot.parser.Parser"}, "sqlglot.dialects.bigquery.BigQuery.Generator": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Generator", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Generator", "kind": "class", "doc": "<p>Generator interprets the given syntax tree and produces a SQL string as an output.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>time_mapping (dict):</strong>  the dictionary of custom time mappings in which the key\nrepresents a python time format and the output the target time format</li>\n<li><strong>time_trie (trie):</strong>  a trie of the time_mapping keys</li>\n<li><strong>pretty (bool):</strong>  if set to True the returned string will be formatted. Default: False.</li>\n<li><strong>quote_start (str):</strong>  specifies which starting character to use to delimit quotes. Default: '.</li>\n<li><strong>quote_end (str):</strong>  specifies which ending character to use to delimit quotes. Default: '.</li>\n<li><strong>identifier_start (str):</strong>  specifies which starting character to use to delimit identifiers. Default: \".</li>\n<li><strong>identifier_end (str):</strong>  specifies which ending character to use to delimit identifiers. Default: \".</li>\n<li><strong>bit_start (str):</strong>  specifies which starting character to use to delimit bit literals. Default: None.</li>\n<li><strong>bit_end (str):</strong>  specifies which ending character to use to delimit bit literals. Default: None.</li>\n<li><strong>hex_start (str):</strong>  specifies which starting character to use to delimit hex literals. Default: None.</li>\n<li><strong>hex_end (str):</strong>  specifies which ending character to use to delimit hex literals. Default: None.</li>\n<li><strong>byte_start (str):</strong>  specifies which starting character to use to delimit byte literals. Default: None.</li>\n<li><strong>byte_end (str):</strong>  specifies which ending character to use to delimit byte literals. Default: None.</li>\n<li><strong>raw_start (str):</strong>  specifies which starting character to use to delimit raw literals. Default: None.</li>\n<li><strong>raw_end (str):</strong>  specifies which ending character to use to delimit raw literals. Default: None.</li>\n<li><strong>identify (bool | str):</strong>  'always': always quote, 'safe': quote identifiers if they don't contain an upcase, True defaults to always.</li>\n<li><strong>normalize (bool):</strong>  if set to True all identifiers will lower cased</li>\n<li><strong>string_escape (str):</strong>  specifies a string escape character. Default: '.</li>\n<li><strong>identifier_escape (str):</strong>  specifies an identifier escape character. Default: \".</li>\n<li><strong>pad (int):</strong>  determines padding in a formatted string. Default: 2.</li>\n<li><strong>indent (int):</strong>  determines the size of indentation in a formatted string. Default: 4.</li>\n<li><strong>unnest_column_only (bool):</strong>  if true unnest table aliases are considered only as column aliases</li>\n<li><strong>normalize_functions (str):</strong>  normalize function names, \"upper\", \"lower\", or None\nDefault: \"upper\"</li>\n<li><strong>alias_post_tablesample (bool):</strong>  if the table alias comes after tablesample\nDefault: False</li>\n<li><strong>identifiers_can_start_with_digit (bool):</strong>  if an unquoted identifier can start with digit\nDefault: False</li>\n<li><strong>unsupported_level (ErrorLevel):</strong>  determines the generator's behavior when it encounters\nunsupported expressions. Default ErrorLevel.WARN.</li>\n<li><strong>null_ordering (str):</strong>  Indicates the default null ordering method to use if not explicitly set.\nOptions are \"nulls_are_small\", \"nulls_are_large\", \"nulls_are_last\".\nDefault: \"nulls_are_small\"</li>\n<li><strong>max_unsupported (int):</strong>  Maximum number of unsupported messages to include in a raised UnsupportedError.\nThis is only relevant if unsupported_level is ErrorLevel.RAISE.\nDefault: 3</li>\n<li><strong>leading_comma (bool):</strong>  if the the comma is leading or trailing in select statements\nDefault: False</li>\n<li><strong>max_text_width:</strong>  The max number of characters in a segment before creating new lines in pretty mode.\nThe default is on the smaller end because the length only represents a segment and not the true\nline length.\nDefault: 80</li>\n<li><strong>comments:</strong>  Whether or not to preserve comments in the output SQL code.\nDefault: True</li>\n</ul>\n", "bases": "sqlglot.generator.Generator"}, "sqlglot.dialects.bigquery.BigQuery.Generator.array_sql": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Generator.array_sql", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Generator.array_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Array</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.bigquery.BigQuery.Generator.transaction_sql": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Generator.transaction_sql", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Generator.transaction_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">*</span><span class=\"n\">_</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.bigquery.BigQuery.Generator.commit_sql": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Generator.commit_sql", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Generator.commit_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">*</span><span class=\"n\">_</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.bigquery.BigQuery.Generator.rollback_sql": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Generator.rollback_sql", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Generator.rollback_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">*</span><span class=\"n\">_</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.bigquery.BigQuery.Generator.in_unnest_op": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Generator.in_unnest_op", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Generator.in_unnest_op", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Unnest</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.bigquery.BigQuery.Generator.except_op": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Generator.except_op", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Generator.except_op", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Except</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.bigquery.BigQuery.Generator.intersect_op": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Generator.intersect_op", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Generator.intersect_op", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Intersect</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.bigquery.BigQuery.Generator.with_properties": {"fullname": "sqlglot.dialects.bigquery.BigQuery.Generator.with_properties", "modulename": "sqlglot.dialects.bigquery", "qualname": "BigQuery.Generator.with_properties", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">properties</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Properties</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.clickhouse": {"fullname": "sqlglot.dialects.clickhouse", "modulename": "sqlglot.dialects.clickhouse", "kind": "module", "doc": "<p></p>\n"}, "sqlglot.dialects.clickhouse.ClickHouse": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse", "kind": "class", "doc": "<p></p>\n", "bases": "sqlglot.dialects.dialect.Dialect"}, "sqlglot.dialects.clickhouse.ClickHouse.Tokenizer": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Tokenizer", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Tokenizer", "kind": "class", "doc": "<p></p>\n", "bases": "sqlglot.tokens.Tokenizer"}, "sqlglot.dialects.clickhouse.ClickHouse.Parser": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Parser", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Parser", "kind": "class", "doc": "<p>Parser consumes a list of tokens produced by the <code>sqlglot.tokens.Tokenizer</code> and produces\na parsed syntax tree.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>error_level:</strong>  the desired error level.\nDefault: ErrorLevel.IMMEDIATE</li>\n<li><strong>error_message_context:</strong>  determines the amount of context to capture from a\nquery string when displaying the error message (in number of characters).\nDefault: 50.</li>\n<li><strong>index_offset:</strong>  Index offset for arrays eg ARRAY[0] vs ARRAY[1] as the head of a list.\nDefault: 0</li>\n<li><strong>alias_post_tablesample:</strong>  If the table alias comes after tablesample.\nDefault: False</li>\n<li><strong>max_errors:</strong>  Maximum number of error messages to include in a raised ParseError.\nThis is only relevant if error_level is ErrorLevel.RAISE.\nDefault: 3</li>\n<li><strong>null_ordering:</strong>  Indicates the default null ordering method to use if not explicitly set.\nOptions are \"nulls_are_small\", \"nulls_are_large\", \"nulls_are_last\".\nDefault: \"nulls_are_small\"</li>\n</ul>\n", "bases": "sqlglot.parser.Parser"}, "sqlglot.dialects.clickhouse.ClickHouse.Generator": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Generator", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Generator", "kind": "class", "doc": "<p>Generator interprets the given syntax tree and produces a SQL string as an output.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>time_mapping (dict):</strong>  the dictionary of custom time mappings in which the key\nrepresents a python time format and the output the target time format</li>\n<li><strong>time_trie (trie):</strong>  a trie of the time_mapping keys</li>\n<li><strong>pretty (bool):</strong>  if set to True the returned string will be formatted. Default: False.</li>\n<li><strong>quote_start (str):</strong>  specifies which starting character to use to delimit quotes. Default: '.</li>\n<li><strong>quote_end (str):</strong>  specifies which ending character to use to delimit quotes. Default: '.</li>\n<li><strong>identifier_start (str):</strong>  specifies which starting character to use to delimit identifiers. Default: \".</li>\n<li><strong>identifier_end (str):</strong>  specifies which ending character to use to delimit identifiers. Default: \".</li>\n<li><strong>bit_start (str):</strong>  specifies which starting character to use to delimit bit literals. Default: None.</li>\n<li><strong>bit_end (str):</strong>  specifies which ending character to use to delimit bit literals. Default: None.</li>\n<li><strong>hex_start (str):</strong>  specifies which starting character to use to delimit hex literals. Default: None.</li>\n<li><strong>hex_end (str):</strong>  specifies which ending character to use to delimit hex literals. Default: None.</li>\n<li><strong>byte_start (str):</strong>  specifies which starting character to use to delimit byte literals. Default: None.</li>\n<li><strong>byte_end (str):</strong>  specifies which ending character to use to delimit byte literals. Default: None.</li>\n<li><strong>raw_start (str):</strong>  specifies which starting character to use to delimit raw literals. Default: None.</li>\n<li><strong>raw_end (str):</strong>  specifies which ending character to use to delimit raw literals. Default: None.</li>\n<li><strong>identify (bool | str):</strong>  'always': always quote, 'safe': quote identifiers if they don't contain an upcase, True defaults to always.</li>\n<li><strong>normalize (bool):</strong>  if set to True all identifiers will lower cased</li>\n<li><strong>string_escape (str):</strong>  specifies a string escape character. Default: '.</li>\n<li><strong>identifier_escape (str):</strong>  specifies an identifier escape character. Default: \".</li>\n<li><strong>pad (int):</strong>  determines padding in a formatted string. Default: 2.</li>\n<li><strong>indent (int):</strong>  determines the size of indentation in a formatted string. Default: 4.</li>\n<li><strong>unnest_column_only (bool):</strong>  if true unnest table aliases are considered only as column aliases</li>\n<li><strong>normalize_functions (str):</strong>  normalize function names, \"upper\", \"lower\", or None\nDefault: \"upper\"</li>\n<li><strong>alias_post_tablesample (bool):</strong>  if the table alias comes after tablesample\nDefault: False</li>\n<li><strong>identifiers_can_start_with_digit (bool):</strong>  if an unquoted identifier can start with digit\nDefault: False</li>\n<li><strong>unsupported_level (ErrorLevel):</strong>  determines the generator's behavior when it encounters\nunsupported expressions. Default ErrorLevel.WARN.</li>\n<li><strong>null_ordering (str):</strong>  Indicates the default null ordering method to use if not explicitly set.\nOptions are \"nulls_are_small\", \"nulls_are_large\", \"nulls_are_last\".\nDefault: \"nulls_are_small\"</li>\n<li><strong>max_unsupported (int):</strong>  Maximum number of unsupported messages to include in a raised UnsupportedError.\nThis is only relevant if unsupported_level is ErrorLevel.RAISE.\nDefault: 3</li>\n<li><strong>leading_comma (bool):</strong>  if the the comma is leading or trailing in select statements\nDefault: False</li>\n<li><strong>max_text_width:</strong>  The max number of characters in a segment before creating new lines in pretty mode.\nThe default is on the smaller end because the length only represents a segment and not the true\nline length.\nDefault: 80</li>\n<li><strong>comments:</strong>  Whether or not to preserve comments in the output SQL code.\nDefault: True</li>\n</ul>\n", "bases": "sqlglot.generator.Generator"}, "sqlglot.dialects.clickhouse.ClickHouse.Generator.cte_sql": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Generator.cte_sql", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Generator.cte_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">CTE</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.clickhouse.ClickHouse.Generator.after_limit_modifiers": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Generator.after_limit_modifiers", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Generator.after_limit_modifiers", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.clickhouse.ClickHouse.Generator.parameterizedagg_sql": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Generator.parameterizedagg_sql", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Generator.parameterizedagg_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Anonymous</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.clickhouse.ClickHouse.Generator.placeholder_sql": {"fullname": "sqlglot.dialects.clickhouse.ClickHouse.Generator.placeholder_sql", "modulename": "sqlglot.dialects.clickhouse", "qualname": "ClickHouse.Generator.placeholder_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Placeholder</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.databricks": {"fullname": "sqlglot.dialects.databricks", "modulename": "sqlglot.dialects.databricks", "kind": "module", "doc": "<p></p>\n"}, "sqlglot.dialects.databricks.Databricks": {"fullname": "sqlglot.dialects.databricks.Databricks", "modulename": "sqlglot.dialects.databricks", "qualname": "Databricks", "kind": "class", "doc": "<p></p>\n", "bases": "sqlglot.dialects.spark.Spark"}, "sqlglot.dialects.databricks.Databricks.Parser": {"fullname": "sqlglot.dialects.databricks.Databricks.Parser", "modulename": "sqlglot.dialects.databricks", "qualname": "Databricks.Parser", "kind": "class", "doc": "<p>Parser consumes a list of tokens produced by the <code>sqlglot.tokens.Tokenizer</code> and produces\na parsed syntax tree.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>error_level:</strong>  the desired error level.\nDefault: ErrorLevel.IMMEDIATE</li>\n<li><strong>error_message_context:</strong>  determines the amount of context to capture from a\nquery string when displaying the error message (in number of characters).\nDefault: 50.</li>\n<li><strong>index_offset:</strong>  Index offset for arrays eg ARRAY[0] vs ARRAY[1] as the head of a list.\nDefault: 0</li>\n<li><strong>alias_post_tablesample:</strong>  If the table alias comes after tablesample.\nDefault: False</li>\n<li><strong>max_errors:</strong>  Maximum number of error messages to include in a raised ParseError.\nThis is only relevant if error_level is ErrorLevel.RAISE.\nDefault: 3</li>\n<li><strong>null_ordering:</strong>  Indicates the default null ordering method to use if not explicitly set.\nOptions are \"nulls_are_small\", \"nulls_are_large\", \"nulls_are_last\".\nDefault: \"nulls_are_small\"</li>\n</ul>\n", "bases": "sqlglot.dialects.spark.Spark.Parser"}, "sqlglot.dialects.databricks.Databricks.Generator": {"fullname": "sqlglot.dialects.databricks.Databricks.Generator", "modulename": "sqlglot.dialects.databricks", "qualname": "Databricks.Generator", "kind": "class", "doc": "<p>Generator interprets the given syntax tree and produces a SQL string as an output.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>time_mapping (dict):</strong>  the dictionary of custom time mappings in which the key\nrepresents a python time format and the output the target time format</li>\n<li><strong>time_trie (trie):</strong>  a trie of the time_mapping keys</li>\n<li><strong>pretty (bool):</strong>  if set to True the returned string will be formatted. Default: False.</li>\n<li><strong>quote_start (str):</strong>  specifies which starting character to use to delimit quotes. Default: '.</li>\n<li><strong>quote_end (str):</strong>  specifies which ending character to use to delimit quotes. Default: '.</li>\n<li><strong>identifier_start (str):</strong>  specifies which starting character to use to delimit identifiers. Default: \".</li>\n<li><strong>identifier_end (str):</strong>  specifies which ending character to use to delimit identifiers. Default: \".</li>\n<li><strong>bit_start (str):</strong>  specifies which starting character to use to delimit bit literals. Default: None.</li>\n<li><strong>bit_end (str):</strong>  specifies which ending character to use to delimit bit literals. Default: None.</li>\n<li><strong>hex_start (str):</strong>  specifies which starting character to use to delimit hex literals. Default: None.</li>\n<li><strong>hex_end (str):</strong>  specifies which ending character to use to delimit hex literals. Default: None.</li>\n<li><strong>byte_start (str):</strong>  specifies which starting character to use to delimit byte literals. Default: None.</li>\n<li><strong>byte_end (str):</strong>  specifies which ending character to use to delimit byte literals. Default: None.</li>\n<li><strong>raw_start (str):</strong>  specifies which starting character to use to delimit raw literals. Default: None.</li>\n<li><strong>raw_end (str):</strong>  specifies which ending character to use to delimit raw literals. Default: None.</li>\n<li><strong>identify (bool | str):</strong>  'always': always quote, 'safe': quote identifiers if they don't contain an upcase, True defaults to always.</li>\n<li><strong>normalize (bool):</strong>  if set to True all identifiers will lower cased</li>\n<li><strong>string_escape (str):</strong>  specifies a string escape character. Default: '.</li>\n<li><strong>identifier_escape (str):</strong>  specifies an identifier escape character. Default: \".</li>\n<li><strong>pad (int):</strong>  determines padding in a formatted string. Default: 2.</li>\n<li><strong>indent (int):</strong>  determines the size of indentation in a formatted string. Default: 4.</li>\n<li><strong>unnest_column_only (bool):</strong>  if true unnest table aliases are considered only as column aliases</li>\n<li><strong>normalize_functions (str):</strong>  normalize function names, \"upper\", \"lower\", or None\nDefault: \"upper\"</li>\n<li><strong>alias_post_tablesample (bool):</strong>  if the table alias comes after tablesample\nDefault: False</li>\n<li><strong>identifiers_can_start_with_digit (bool):</strong>  if an unquoted identifier can start with digit\nDefault: False</li>\n<li><strong>unsupported_level (ErrorLevel):</strong>  determines the generator's behavior when it encounters\nunsupported expressions. Default ErrorLevel.WARN.</li>\n<li><strong>null_ordering (str):</strong>  Indicates the default null ordering method to use if not explicitly set.\nOptions are \"nulls_are_small\", \"nulls_are_large\", \"nulls_are_last\".\nDefault: \"nulls_are_small\"</li>\n<li><strong>max_unsupported (int):</strong>  Maximum number of unsupported messages to include in a raised UnsupportedError.\nThis is only relevant if unsupported_level is ErrorLevel.RAISE.\nDefault: 3</li>\n<li><strong>leading_comma (bool):</strong>  if the the comma is leading or trailing in select statements\nDefault: False</li>\n<li><strong>max_text_width:</strong>  The max number of characters in a segment before creating new lines in pretty mode.\nThe default is on the smaller end because the length only represents a segment and not the true\nline length.\nDefault: 80</li>\n<li><strong>comments:</strong>  Whether or not to preserve comments in the output SQL code.\nDefault: True</li>\n</ul>\n", "bases": "sqlglot.dialects.spark.Spark.Generator"}, "sqlglot.dialects.databricks.Databricks.Tokenizer": {"fullname": "sqlglot.dialects.databricks.Databricks.Tokenizer", "modulename": "sqlglot.dialects.databricks", "qualname": "Databricks.Tokenizer", "kind": "class", "doc": "<p></p>\n", "bases": "sqlglot.dialects.spark2.Spark2.Tokenizer"}, "sqlglot.dialects.dialect": {"fullname": "sqlglot.dialects.dialect", "modulename": "sqlglot.dialects.dialect", "kind": "module", "doc": "<p></p>\n"}, "sqlglot.dialects.dialect.Dialects": {"fullname": "sqlglot.dialects.dialect.Dialects", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialects", "kind": "class", "doc": "<p>An enumeration.</p>\n", "bases": "builtins.str, enum.Enum"}, "sqlglot.dialects.dialect.Dialects.DIALECT": {"fullname": "sqlglot.dialects.dialect.Dialects.DIALECT", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialects.DIALECT", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Dialects.DIALECT: &#x27;&#x27;&gt;"}, "sqlglot.dialects.dialect.Dialects.BIGQUERY": {"fullname": "sqlglot.dialects.dialect.Dialects.BIGQUERY", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialects.BIGQUERY", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Dialects.BIGQUERY: &#x27;bigquery&#x27;&gt;"}, "sqlglot.dialects.dialect.Dialects.CLICKHOUSE": {"fullname": "sqlglot.dialects.dialect.Dialects.CLICKHOUSE", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialects.CLICKHOUSE", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Dialects.CLICKHOUSE: &#x27;clickhouse&#x27;&gt;"}, "sqlglot.dialects.dialect.Dialects.DUCKDB": {"fullname": "sqlglot.dialects.dialect.Dialects.DUCKDB", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialects.DUCKDB", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Dialects.DUCKDB: &#x27;duckdb&#x27;&gt;"}, "sqlglot.dialects.dialect.Dialects.HIVE": {"fullname": "sqlglot.dialects.dialect.Dialects.HIVE", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialects.HIVE", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Dialects.HIVE: &#x27;hive&#x27;&gt;"}, "sqlglot.dialects.dialect.Dialects.MYSQL": {"fullname": "sqlglot.dialects.dialect.Dialects.MYSQL", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialects.MYSQL", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Dialects.MYSQL: &#x27;mysql&#x27;&gt;"}, "sqlglot.dialects.dialect.Dialects.ORACLE": {"fullname": "sqlglot.dialects.dialect.Dialects.ORACLE", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialects.ORACLE", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Dialects.ORACLE: &#x27;oracle&#x27;&gt;"}, "sqlglot.dialects.dialect.Dialects.POSTGRES": {"fullname": "sqlglot.dialects.dialect.Dialects.POSTGRES", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialects.POSTGRES", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Dialects.POSTGRES: &#x27;postgres&#x27;&gt;"}, "sqlglot.dialects.dialect.Dialects.PRESTO": {"fullname": "sqlglot.dialects.dialect.Dialects.PRESTO", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialects.PRESTO", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Dialects.PRESTO: &#x27;presto&#x27;&gt;"}, "sqlglot.dialects.dialect.Dialects.REDSHIFT": {"fullname": "sqlglot.dialects.dialect.Dialects.REDSHIFT", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialects.REDSHIFT", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Dialects.REDSHIFT: &#x27;redshift&#x27;&gt;"}, "sqlglot.dialects.dialect.Dialects.SNOWFLAKE": {"fullname": "sqlglot.dialects.dialect.Dialects.SNOWFLAKE", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialects.SNOWFLAKE", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Dialects.SNOWFLAKE: &#x27;snowflake&#x27;&gt;"}, "sqlglot.dialects.dialect.Dialects.SPARK": {"fullname": "sqlglot.dialects.dialect.Dialects.SPARK", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialects.SPARK", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Dialects.SPARK: &#x27;spark&#x27;&gt;"}, "sqlglot.dialects.dialect.Dialects.SPARK2": {"fullname": "sqlglot.dialects.dialect.Dialects.SPARK2", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialects.SPARK2", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Dialects.SPARK2: &#x27;spark2&#x27;&gt;"}, "sqlglot.dialects.dialect.Dialects.SQLITE": {"fullname": "sqlglot.dialects.dialect.Dialects.SQLITE", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialects.SQLITE", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Dialects.SQLITE: &#x27;sqlite&#x27;&gt;"}, "sqlglot.dialects.dialect.Dialects.STARROCKS": {"fullname": "sqlglot.dialects.dialect.Dialects.STARROCKS", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialects.STARROCKS", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Dialects.STARROCKS: &#x27;starrocks&#x27;&gt;"}, "sqlglot.dialects.dialect.Dialects.TABLEAU": {"fullname": "sqlglot.dialects.dialect.Dialects.TABLEAU", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialects.TABLEAU", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Dialects.TABLEAU: &#x27;tableau&#x27;&gt;"}, "sqlglot.dialects.dialect.Dialects.TRINO": {"fullname": "sqlglot.dialects.dialect.Dialects.TRINO", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialects.TRINO", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Dialects.TRINO: &#x27;trino&#x27;&gt;"}, "sqlglot.dialects.dialect.Dialects.TSQL": {"fullname": "sqlglot.dialects.dialect.Dialects.TSQL", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialects.TSQL", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Dialects.TSQL: &#x27;tsql&#x27;&gt;"}, "sqlglot.dialects.dialect.Dialects.DATABRICKS": {"fullname": "sqlglot.dialects.dialect.Dialects.DATABRICKS", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialects.DATABRICKS", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Dialects.DATABRICKS: &#x27;databricks&#x27;&gt;"}, "sqlglot.dialects.dialect.Dialects.DRILL": {"fullname": "sqlglot.dialects.dialect.Dialects.DRILL", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialects.DRILL", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Dialects.DRILL: &#x27;drill&#x27;&gt;"}, "sqlglot.dialects.dialect.Dialects.TERADATA": {"fullname": "sqlglot.dialects.dialect.Dialects.TERADATA", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialects.TERADATA", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Dialects.TERADATA: &#x27;teradata&#x27;&gt;"}, "sqlglot.dialects.dialect.Dialect": {"fullname": "sqlglot.dialects.dialect.Dialect", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialect", "kind": "class", "doc": "<p></p>\n"}, "sqlglot.dialects.dialect.Dialect.get_or_raise": {"fullname": "sqlglot.dialects.dialect.Dialect.get_or_raise", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialect.get_or_raise", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">cls</span>,</span><span class=\"param\">\t<span class=\"n\">dialect</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.Dialect.format_time": {"fullname": "sqlglot.dialects.dialect.Dialect.format_time", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialect.format_time", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">cls</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.Dialect.parse": {"fullname": "sqlglot.dialects.dialect.Dialect.parse", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialect.parse", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">sql</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">opts</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.Dialect.parse_into": {"fullname": "sqlglot.dialects.dialect.Dialect.parse_into", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialect.parse_into", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">expression_type</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">],</span> <span class=\"n\">Collection</span><span class=\"p\">[</span><span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">]]]]</span>,</span><span class=\"param\">\t<span class=\"n\">sql</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">opts</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.Dialect.generate": {"fullname": "sqlglot.dialects.dialect.Dialect.generate", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialect.generate", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">opts</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.Dialect.transpile": {"fullname": "sqlglot.dialects.dialect.Dialect.transpile", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialect.transpile", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">sql</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">opts</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.Dialect.tokenize": {"fullname": "sqlglot.dialects.dialect.Dialect.tokenize", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialect.tokenize", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">sql</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">tokens</span><span class=\"o\">.</span><span class=\"n\">Token</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.Dialect.parser": {"fullname": "sqlglot.dialects.dialect.Dialect.parser", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialect.parser", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">opts</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">parser</span><span class=\"o\">.</span><span class=\"n\">Parser</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.Dialect.generator": {"fullname": "sqlglot.dialects.dialect.Dialect.generator", "modulename": "sqlglot.dialects.dialect", "qualname": "Dialect.generator", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">opts</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.rename_func": {"fullname": "sqlglot.dialects.dialect.rename_func", "modulename": "sqlglot.dialects.dialect", "qualname": "rename_func", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Callable</span><span class=\"p\">[[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">],</span> <span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.approx_count_distinct_sql": {"fullname": "sqlglot.dialects.dialect.approx_count_distinct_sql", "modulename": "sqlglot.dialects.dialect", "qualname": "approx_count_distinct_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">ApproxDistinct</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.if_sql": {"fullname": "sqlglot.dialects.dialect.if_sql", "modulename": "sqlglot.dialects.dialect", "qualname": "if_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">If</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.arrow_json_extract_sql": {"fullname": "sqlglot.dialects.dialect.arrow_json_extract_sql", "modulename": "sqlglot.dialects.dialect", "qualname": "arrow_json_extract_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">JSONExtract</span> <span class=\"o\">|</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">JSONBExtract</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.arrow_json_extract_scalar_sql": {"fullname": "sqlglot.dialects.dialect.arrow_json_extract_scalar_sql", "modulename": "sqlglot.dialects.dialect", "qualname": "arrow_json_extract_scalar_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">JSONExtractScalar</span> <span class=\"o\">|</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">JSONBExtractScalar</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.inline_array_sql": {"fullname": "sqlglot.dialects.dialect.inline_array_sql", "modulename": "sqlglot.dialects.dialect", "qualname": "inline_array_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Array</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.no_ilike_sql": {"fullname": "sqlglot.dialects.dialect.no_ilike_sql", "modulename": "sqlglot.dialects.dialect", "qualname": "no_ilike_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">ILike</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.no_paren_current_date_sql": {"fullname": "sqlglot.dialects.dialect.no_paren_current_date_sql", "modulename": "sqlglot.dialects.dialect", "qualname": "no_paren_current_date_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">CurrentDate</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.no_recursive_cte_sql": {"fullname": "sqlglot.dialects.dialect.no_recursive_cte_sql", "modulename": "sqlglot.dialects.dialect", "qualname": "no_recursive_cte_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">With</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.no_safe_divide_sql": {"fullname": "sqlglot.dialects.dialect.no_safe_divide_sql", "modulename": "sqlglot.dialects.dialect", "qualname": "no_safe_divide_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">SafeDivide</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.no_tablesample_sql": {"fullname": "sqlglot.dialects.dialect.no_tablesample_sql", "modulename": "sqlglot.dialects.dialect", "qualname": "no_tablesample_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">TableSample</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.no_pivot_sql": {"fullname": "sqlglot.dialects.dialect.no_pivot_sql", "modulename": "sqlglot.dialects.dialect", "qualname": "no_pivot_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Pivot</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.no_trycast_sql": {"fullname": "sqlglot.dialects.dialect.no_trycast_sql", "modulename": "sqlglot.dialects.dialect", "qualname": "no_trycast_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">TryCast</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.no_properties_sql": {"fullname": "sqlglot.dialects.dialect.no_properties_sql", "modulename": "sqlglot.dialects.dialect", "qualname": "no_properties_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Properties</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.no_comment_column_constraint_sql": {"fullname": "sqlglot.dialects.dialect.no_comment_column_constraint_sql", "modulename": "sqlglot.dialects.dialect", "qualname": "no_comment_column_constraint_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">CommentColumnConstraint</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.str_position_sql": {"fullname": "sqlglot.dialects.dialect.str_position_sql", "modulename": "sqlglot.dialects.dialect", "qualname": "str_position_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">StrPosition</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.struct_extract_sql": {"fullname": "sqlglot.dialects.dialect.struct_extract_sql", "modulename": "sqlglot.dialects.dialect", "qualname": "struct_extract_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">StructExtract</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.var_map_sql": {"fullname": "sqlglot.dialects.dialect.var_map_sql", "modulename": "sqlglot.dialects.dialect", "qualname": "var_map_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Map</span> <span class=\"o\">|</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">VarMap</span>,</span><span class=\"param\">\t<span class=\"n\">map_func_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;MAP&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.format_time_lambda": {"fullname": "sqlglot.dialects.dialect.format_time_lambda", "modulename": "sqlglot.dialects.dialect", "qualname": "format_time_lambda", "kind": "function", "doc": "<p>Helper used for time expressions.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>exp_class:</strong>  the expression class to instantiate.</li>\n<li><strong>dialect:</strong>  target sql dialect.</li>\n<li><strong>default:</strong>  the default format, True being time.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>A callable that can be used to return the appropriately formatted time expression.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">exp_class</span><span class=\"p\">:</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"o\">~</span><span class=\"n\">E</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">dialect</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">default</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Callable</span><span class=\"p\">[[</span><span class=\"n\">List</span><span class=\"p\">],</span> <span class=\"o\">~</span><span class=\"n\">E</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.create_with_partitions_sql": {"fullname": "sqlglot.dialects.dialect.create_with_partitions_sql", "modulename": "sqlglot.dialects.dialect", "qualname": "create_with_partitions_sql", "kind": "function", "doc": "<p>In Hive and Spark, the PARTITIONED BY property acts as an extension of a table's schema. When the\nPARTITIONED BY value is an array of column names, they are transformed into a schema. The corresponding\ncolumns are removed from the create statement.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Create</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.parse_date_delta": {"fullname": "sqlglot.dialects.dialect.parse_date_delta", "modulename": "sqlglot.dialects.dialect", "qualname": "parse_date_delta", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">exp_class</span><span class=\"p\">:</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"o\">~</span><span class=\"n\">E</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">unit_mapping</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Callable</span><span class=\"p\">[[</span><span class=\"n\">List</span><span class=\"p\">],</span> <span class=\"o\">~</span><span class=\"n\">E</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.parse_date_delta_with_interval": {"fullname": "sqlglot.dialects.dialect.parse_date_delta_with_interval", "modulename": "sqlglot.dialects.dialect", "qualname": "parse_date_delta_with_interval", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">expression_class</span><span class=\"p\">:</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"o\">~</span><span class=\"n\">E</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Callable</span><span class=\"p\">[[</span><span class=\"n\">List</span><span class=\"p\">],</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"o\">~</span><span class=\"n\">E</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.date_trunc_to_time": {"fullname": "sqlglot.dialects.dialect.date_trunc_to_time", "modulename": "sqlglot.dialects.dialect", "qualname": "date_trunc_to_time", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"n\">List</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">DateTrunc</span> <span class=\"o\">|</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">TimestampTrunc</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.timestamptrunc_sql": {"fullname": "sqlglot.dialects.dialect.timestamptrunc_sql", "modulename": "sqlglot.dialects.dialect", "qualname": "timestamptrunc_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">TimestampTrunc</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.locate_to_strposition": {"fullname": "sqlglot.dialects.dialect.locate_to_strposition", "modulename": "sqlglot.dialects.dialect", "qualname": "locate_to_strposition", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"n\">List</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.strposition_to_locate_sql": {"fullname": "sqlglot.dialects.dialect.strposition_to_locate_sql", "modulename": "sqlglot.dialects.dialect", "qualname": "strposition_to_locate_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">StrPosition</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.left_to_substring_sql": {"fullname": "sqlglot.dialects.dialect.left_to_substring_sql", "modulename": "sqlglot.dialects.dialect", "qualname": "left_to_substring_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Left</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.right_to_substring_sql": {"fullname": "sqlglot.dialects.dialect.right_to_substring_sql", "modulename": "sqlglot.dialects.dialect", "qualname": "right_to_substring_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Left</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.timestrtotime_sql": {"fullname": "sqlglot.dialects.dialect.timestrtotime_sql", "modulename": "sqlglot.dialects.dialect", "qualname": "timestrtotime_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">TimeStrToTime</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.datestrtodate_sql": {"fullname": "sqlglot.dialects.dialect.datestrtodate_sql", "modulename": "sqlglot.dialects.dialect", "qualname": "datestrtodate_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">DateStrToDate</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.min_or_least": {"fullname": "sqlglot.dialects.dialect.min_or_least", "modulename": "sqlglot.dialects.dialect", "qualname": "min_or_least", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Min</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.max_or_greatest": {"fullname": "sqlglot.dialects.dialect.max_or_greatest", "modulename": "sqlglot.dialects.dialect", "qualname": "max_or_greatest", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Max</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.count_if_to_sum": {"fullname": "sqlglot.dialects.dialect.count_if_to_sum", "modulename": "sqlglot.dialects.dialect", "qualname": "count_if_to_sum", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">CountIf</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.trim_sql": {"fullname": "sqlglot.dialects.dialect.trim_sql", "modulename": "sqlglot.dialects.dialect", "qualname": "trim_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Trim</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.str_to_time_sql": {"fullname": "sqlglot.dialects.dialect.str_to_time_sql", "modulename": "sqlglot.dialects.dialect", "qualname": "str_to_time_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.ts_or_ds_to_date_sql": {"fullname": "sqlglot.dialects.dialect.ts_or_ds_to_date_sql", "modulename": "sqlglot.dialects.dialect", "qualname": "ts_or_ds_to_date_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">dialect</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Callable</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.dialect.pivot_column_names": {"fullname": "sqlglot.dialects.dialect.pivot_column_names", "modulename": "sqlglot.dialects.dialect", "qualname": "pivot_column_names", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">aggregations</span><span class=\"p\">:</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">dialect</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.drill": {"fullname": "sqlglot.dialects.drill", "modulename": "sqlglot.dialects.drill", "kind": "module", "doc": "<p></p>\n"}, "sqlglot.dialects.drill.Drill": {"fullname": "sqlglot.dialects.drill.Drill", "modulename": "sqlglot.dialects.drill", "qualname": "Drill", "kind": "class", "doc": "<p></p>\n", "bases": "sqlglot.dialects.dialect.Dialect"}, "sqlglot.dialects.drill.Drill.Tokenizer": {"fullname": "sqlglot.dialects.drill.Drill.Tokenizer", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.Tokenizer", "kind": "class", "doc": "<p></p>\n", "bases": "sqlglot.tokens.Tokenizer"}, "sqlglot.dialects.drill.Drill.Parser": {"fullname": "sqlglot.dialects.drill.Drill.Parser", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.Parser", "kind": "class", "doc": "<p>Parser consumes a list of tokens produced by the <code>sqlglot.tokens.Tokenizer</code> and produces\na parsed syntax tree.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>error_level:</strong>  the desired error level.\nDefault: ErrorLevel.IMMEDIATE</li>\n<li><strong>error_message_context:</strong>  determines the amount of context to capture from a\nquery string when displaying the error message (in number of characters).\nDefault: 50.</li>\n<li><strong>index_offset:</strong>  Index offset for arrays eg ARRAY[0] vs ARRAY[1] as the head of a list.\nDefault: 0</li>\n<li><strong>alias_post_tablesample:</strong>  If the table alias comes after tablesample.\nDefault: False</li>\n<li><strong>max_errors:</strong>  Maximum number of error messages to include in a raised ParseError.\nThis is only relevant if error_level is ErrorLevel.RAISE.\nDefault: 3</li>\n<li><strong>null_ordering:</strong>  Indicates the default null ordering method to use if not explicitly set.\nOptions are \"nulls_are_small\", \"nulls_are_large\", \"nulls_are_last\".\nDefault: \"nulls_are_small\"</li>\n</ul>\n", "bases": "sqlglot.parser.Parser"}, "sqlglot.dialects.drill.Drill.Generator": {"fullname": "sqlglot.dialects.drill.Drill.Generator", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.Generator", "kind": "class", "doc": "<p>Generator interprets the given syntax tree and produces a SQL string as an output.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>time_mapping (dict):</strong>  the dictionary of custom time mappings in which the key\nrepresents a python time format and the output the target time format</li>\n<li><strong>time_trie (trie):</strong>  a trie of the time_mapping keys</li>\n<li><strong>pretty (bool):</strong>  if set to True the returned string will be formatted. Default: False.</li>\n<li><strong>quote_start (str):</strong>  specifies which starting character to use to delimit quotes. Default: '.</li>\n<li><strong>quote_end (str):</strong>  specifies which ending character to use to delimit quotes. Default: '.</li>\n<li><strong>identifier_start (str):</strong>  specifies which starting character to use to delimit identifiers. Default: \".</li>\n<li><strong>identifier_end (str):</strong>  specifies which ending character to use to delimit identifiers. Default: \".</li>\n<li><strong>bit_start (str):</strong>  specifies which starting character to use to delimit bit literals. Default: None.</li>\n<li><strong>bit_end (str):</strong>  specifies which ending character to use to delimit bit literals. Default: None.</li>\n<li><strong>hex_start (str):</strong>  specifies which starting character to use to delimit hex literals. Default: None.</li>\n<li><strong>hex_end (str):</strong>  specifies which ending character to use to delimit hex literals. Default: None.</li>\n<li><strong>byte_start (str):</strong>  specifies which starting character to use to delimit byte literals. Default: None.</li>\n<li><strong>byte_end (str):</strong>  specifies which ending character to use to delimit byte literals. Default: None.</li>\n<li><strong>raw_start (str):</strong>  specifies which starting character to use to delimit raw literals. Default: None.</li>\n<li><strong>raw_end (str):</strong>  specifies which ending character to use to delimit raw literals. Default: None.</li>\n<li><strong>identify (bool | str):</strong>  'always': always quote, 'safe': quote identifiers if they don't contain an upcase, True defaults to always.</li>\n<li><strong>normalize (bool):</strong>  if set to True all identifiers will lower cased</li>\n<li><strong>string_escape (str):</strong>  specifies a string escape character. Default: '.</li>\n<li><strong>identifier_escape (str):</strong>  specifies an identifier escape character. Default: \".</li>\n<li><strong>pad (int):</strong>  determines padding in a formatted string. Default: 2.</li>\n<li><strong>indent (int):</strong>  determines the size of indentation in a formatted string. Default: 4.</li>\n<li><strong>unnest_column_only (bool):</strong>  if true unnest table aliases are considered only as column aliases</li>\n<li><strong>normalize_functions (str):</strong>  normalize function names, \"upper\", \"lower\", or None\nDefault: \"upper\"</li>\n<li><strong>alias_post_tablesample (bool):</strong>  if the table alias comes after tablesample\nDefault: False</li>\n<li><strong>identifiers_can_start_with_digit (bool):</strong>  if an unquoted identifier can start with digit\nDefault: False</li>\n<li><strong>unsupported_level (ErrorLevel):</strong>  determines the generator's behavior when it encounters\nunsupported expressions. Default ErrorLevel.WARN.</li>\n<li><strong>null_ordering (str):</strong>  Indicates the default null ordering method to use if not explicitly set.\nOptions are \"nulls_are_small\", \"nulls_are_large\", \"nulls_are_last\".\nDefault: \"nulls_are_small\"</li>\n<li><strong>max_unsupported (int):</strong>  Maximum number of unsupported messages to include in a raised UnsupportedError.\nThis is only relevant if unsupported_level is ErrorLevel.RAISE.\nDefault: 3</li>\n<li><strong>leading_comma (bool):</strong>  if the the comma is leading or trailing in select statements\nDefault: False</li>\n<li><strong>max_text_width:</strong>  The max number of characters in a segment before creating new lines in pretty mode.\nThe default is on the smaller end because the length only represents a segment and not the true\nline length.\nDefault: 80</li>\n<li><strong>comments:</strong>  Whether or not to preserve comments in the output SQL code.\nDefault: True</li>\n</ul>\n", "bases": "sqlglot.generator.Generator"}, "sqlglot.dialects.drill.Drill.Generator.normalize_func": {"fullname": "sqlglot.dialects.drill.Drill.Generator.normalize_func", "modulename": "sqlglot.dialects.drill", "qualname": "Drill.Generator.normalize_func", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.duckdb": {"fullname": "sqlglot.dialects.duckdb", "modulename": "sqlglot.dialects.duckdb", "kind": "module", "doc": "<p></p>\n"}, "sqlglot.dialects.duckdb.DuckDB": {"fullname": "sqlglot.dialects.duckdb.DuckDB", "modulename": "sqlglot.dialects.duckdb", "qualname": "DuckDB", "kind": "class", "doc": "<p></p>\n", "bases": "sqlglot.dialects.dialect.Dialect"}, "sqlglot.dialects.duckdb.DuckDB.Tokenizer": {"fullname": "sqlglot.dialects.duckdb.DuckDB.Tokenizer", "modulename": "sqlglot.dialects.duckdb", "qualname": "DuckDB.Tokenizer", "kind": "class", "doc": "<p></p>\n", "bases": "sqlglot.tokens.Tokenizer"}, "sqlglot.dialects.duckdb.DuckDB.Parser": {"fullname": "sqlglot.dialects.duckdb.DuckDB.Parser", "modulename": "sqlglot.dialects.duckdb", "qualname": "DuckDB.Parser", "kind": "class", "doc": "<p>Parser consumes a list of tokens produced by the <code>sqlglot.tokens.Tokenizer</code> and produces\na parsed syntax tree.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>error_level:</strong>  the desired error level.\nDefault: ErrorLevel.IMMEDIATE</li>\n<li><strong>error_message_context:</strong>  determines the amount of context to capture from a\nquery string when displaying the error message (in number of characters).\nDefault: 50.</li>\n<li><strong>index_offset:</strong>  Index offset for arrays eg ARRAY[0] vs ARRAY[1] as the head of a list.\nDefault: 0</li>\n<li><strong>alias_post_tablesample:</strong>  If the table alias comes after tablesample.\nDefault: False</li>\n<li><strong>max_errors:</strong>  Maximum number of error messages to include in a raised ParseError.\nThis is only relevant if error_level is ErrorLevel.RAISE.\nDefault: 3</li>\n<li><strong>null_ordering:</strong>  Indicates the default null ordering method to use if not explicitly set.\nOptions are \"nulls_are_small\", \"nulls_are_large\", \"nulls_are_last\".\nDefault: \"nulls_are_small\"</li>\n</ul>\n", "bases": "sqlglot.parser.Parser"}, "sqlglot.dialects.duckdb.DuckDB.Generator": {"fullname": "sqlglot.dialects.duckdb.DuckDB.Generator", "modulename": "sqlglot.dialects.duckdb", "qualname": "DuckDB.Generator", "kind": "class", "doc": "<p>Generator interprets the given syntax tree and produces a SQL string as an output.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>time_mapping (dict):</strong>  the dictionary of custom time mappings in which the key\nrepresents a python time format and the output the target time format</li>\n<li><strong>time_trie (trie):</strong>  a trie of the time_mapping keys</li>\n<li><strong>pretty (bool):</strong>  if set to True the returned string will be formatted. Default: False.</li>\n<li><strong>quote_start (str):</strong>  specifies which starting character to use to delimit quotes. Default: '.</li>\n<li><strong>quote_end (str):</strong>  specifies which ending character to use to delimit quotes. Default: '.</li>\n<li><strong>identifier_start (str):</strong>  specifies which starting character to use to delimit identifiers. Default: \".</li>\n<li><strong>identifier_end (str):</strong>  specifies which ending character to use to delimit identifiers. Default: \".</li>\n<li><strong>bit_start (str):</strong>  specifies which starting character to use to delimit bit literals. Default: None.</li>\n<li><strong>bit_end (str):</strong>  specifies which ending character to use to delimit bit literals. Default: None.</li>\n<li><strong>hex_start (str):</strong>  specifies which starting character to use to delimit hex literals. Default: None.</li>\n<li><strong>hex_end (str):</strong>  specifies which ending character to use to delimit hex literals. Default: None.</li>\n<li><strong>byte_start (str):</strong>  specifies which starting character to use to delimit byte literals. Default: None.</li>\n<li><strong>byte_end (str):</strong>  specifies which ending character to use to delimit byte literals. Default: None.</li>\n<li><strong>raw_start (str):</strong>  specifies which starting character to use to delimit raw literals. Default: None.</li>\n<li><strong>raw_end (str):</strong>  specifies which ending character to use to delimit raw literals. Default: None.</li>\n<li><strong>identify (bool | str):</strong>  'always': always quote, 'safe': quote identifiers if they don't contain an upcase, True defaults to always.</li>\n<li><strong>normalize (bool):</strong>  if set to True all identifiers will lower cased</li>\n<li><strong>string_escape (str):</strong>  specifies a string escape character. Default: '.</li>\n<li><strong>identifier_escape (str):</strong>  specifies an identifier escape character. Default: \".</li>\n<li><strong>pad (int):</strong>  determines padding in a formatted string. Default: 2.</li>\n<li><strong>indent (int):</strong>  determines the size of indentation in a formatted string. Default: 4.</li>\n<li><strong>unnest_column_only (bool):</strong>  if true unnest table aliases are considered only as column aliases</li>\n<li><strong>normalize_functions (str):</strong>  normalize function names, \"upper\", \"lower\", or None\nDefault: \"upper\"</li>\n<li><strong>alias_post_tablesample (bool):</strong>  if the table alias comes after tablesample\nDefault: False</li>\n<li><strong>identifiers_can_start_with_digit (bool):</strong>  if an unquoted identifier can start with digit\nDefault: False</li>\n<li><strong>unsupported_level (ErrorLevel):</strong>  determines the generator's behavior when it encounters\nunsupported expressions. Default ErrorLevel.WARN.</li>\n<li><strong>null_ordering (str):</strong>  Indicates the default null ordering method to use if not explicitly set.\nOptions are \"nulls_are_small\", \"nulls_are_large\", \"nulls_are_last\".\nDefault: \"nulls_are_small\"</li>\n<li><strong>max_unsupported (int):</strong>  Maximum number of unsupported messages to include in a raised UnsupportedError.\nThis is only relevant if unsupported_level is ErrorLevel.RAISE.\nDefault: 3</li>\n<li><strong>leading_comma (bool):</strong>  if the the comma is leading or trailing in select statements\nDefault: False</li>\n<li><strong>max_text_width:</strong>  The max number of characters in a segment before creating new lines in pretty mode.\nThe default is on the smaller end because the length only represents a segment and not the true\nline length.\nDefault: 80</li>\n<li><strong>comments:</strong>  Whether or not to preserve comments in the output SQL code.\nDefault: True</li>\n</ul>\n", "bases": "sqlglot.generator.Generator"}, "sqlglot.dialects.duckdb.DuckDB.Generator.tablesample_sql": {"fullname": "sqlglot.dialects.duckdb.DuckDB.Generator.tablesample_sql", "modulename": "sqlglot.dialects.duckdb", "qualname": "DuckDB.Generator.tablesample_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">TableSample</span>,</span><span class=\"param\">\t<span class=\"n\">seed_prefix</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;SEED&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">sep</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39; AS &#39;</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.hive": {"fullname": "sqlglot.dialects.hive", "modulename": "sqlglot.dialects.hive", "kind": "module", "doc": "<p></p>\n"}, "sqlglot.dialects.hive.Hive": {"fullname": "sqlglot.dialects.hive.Hive", "modulename": "sqlglot.dialects.hive", "qualname": "Hive", "kind": "class", "doc": "<p></p>\n", "bases": "sqlglot.dialects.dialect.Dialect"}, "sqlglot.dialects.hive.Hive.Tokenizer": {"fullname": "sqlglot.dialects.hive.Hive.Tokenizer", "modulename": "sqlglot.dialects.hive", "qualname": "Hive.Tokenizer", "kind": "class", "doc": "<p></p>\n", "bases": "sqlglot.tokens.Tokenizer"}, "sqlglot.dialects.hive.Hive.Parser": {"fullname": "sqlglot.dialects.hive.Hive.Parser", "modulename": "sqlglot.dialects.hive", "qualname": "Hive.Parser", "kind": "class", "doc": "<p>Parser consumes a list of tokens produced by the <code>sqlglot.tokens.Tokenizer</code> and produces\na parsed syntax tree.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>error_level:</strong>  the desired error level.\nDefault: ErrorLevel.IMMEDIATE</li>\n<li><strong>error_message_context:</strong>  determines the amount of context to capture from a\nquery string when displaying the error message (in number of characters).\nDefault: 50.</li>\n<li><strong>index_offset:</strong>  Index offset for arrays eg ARRAY[0] vs ARRAY[1] as the head of a list.\nDefault: 0</li>\n<li><strong>alias_post_tablesample:</strong>  If the table alias comes after tablesample.\nDefault: False</li>\n<li><strong>max_errors:</strong>  Maximum number of error messages to include in a raised ParseError.\nThis is only relevant if error_level is ErrorLevel.RAISE.\nDefault: 3</li>\n<li><strong>null_ordering:</strong>  Indicates the default null ordering method to use if not explicitly set.\nOptions are \"nulls_are_small\", \"nulls_are_large\", \"nulls_are_last\".\nDefault: \"nulls_are_small\"</li>\n</ul>\n", "bases": "sqlglot.parser.Parser"}, "sqlglot.dialects.hive.Hive.Generator": {"fullname": "sqlglot.dialects.hive.Hive.Generator", "modulename": "sqlglot.dialects.hive", "qualname": "Hive.Generator", "kind": "class", "doc": "<p>Generator interprets the given syntax tree and produces a SQL string as an output.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>time_mapping (dict):</strong>  the dictionary of custom time mappings in which the key\nrepresents a python time format and the output the target time format</li>\n<li><strong>time_trie (trie):</strong>  a trie of the time_mapping keys</li>\n<li><strong>pretty (bool):</strong>  if set to True the returned string will be formatted. Default: False.</li>\n<li><strong>quote_start (str):</strong>  specifies which starting character to use to delimit quotes. Default: '.</li>\n<li><strong>quote_end (str):</strong>  specifies which ending character to use to delimit quotes. Default: '.</li>\n<li><strong>identifier_start (str):</strong>  specifies which starting character to use to delimit identifiers. Default: \".</li>\n<li><strong>identifier_end (str):</strong>  specifies which ending character to use to delimit identifiers. Default: \".</li>\n<li><strong>bit_start (str):</strong>  specifies which starting character to use to delimit bit literals. Default: None.</li>\n<li><strong>bit_end (str):</strong>  specifies which ending character to use to delimit bit literals. Default: None.</li>\n<li><strong>hex_start (str):</strong>  specifies which starting character to use to delimit hex literals. Default: None.</li>\n<li><strong>hex_end (str):</strong>  specifies which ending character to use to delimit hex literals. Default: None.</li>\n<li><strong>byte_start (str):</strong>  specifies which starting character to use to delimit byte literals. Default: None.</li>\n<li><strong>byte_end (str):</strong>  specifies which ending character to use to delimit byte literals. Default: None.</li>\n<li><strong>raw_start (str):</strong>  specifies which starting character to use to delimit raw literals. Default: None.</li>\n<li><strong>raw_end (str):</strong>  specifies which ending character to use to delimit raw literals. Default: None.</li>\n<li><strong>identify (bool | str):</strong>  'always': always quote, 'safe': quote identifiers if they don't contain an upcase, True defaults to always.</li>\n<li><strong>normalize (bool):</strong>  if set to True all identifiers will lower cased</li>\n<li><strong>string_escape (str):</strong>  specifies a string escape character. Default: '.</li>\n<li><strong>identifier_escape (str):</strong>  specifies an identifier escape character. Default: \".</li>\n<li><strong>pad (int):</strong>  determines padding in a formatted string. Default: 2.</li>\n<li><strong>indent (int):</strong>  determines the size of indentation in a formatted string. Default: 4.</li>\n<li><strong>unnest_column_only (bool):</strong>  if true unnest table aliases are considered only as column aliases</li>\n<li><strong>normalize_functions (str):</strong>  normalize function names, \"upper\", \"lower\", or None\nDefault: \"upper\"</li>\n<li><strong>alias_post_tablesample (bool):</strong>  if the table alias comes after tablesample\nDefault: False</li>\n<li><strong>identifiers_can_start_with_digit (bool):</strong>  if an unquoted identifier can start with digit\nDefault: False</li>\n<li><strong>unsupported_level (ErrorLevel):</strong>  determines the generator's behavior when it encounters\nunsupported expressions. Default ErrorLevel.WARN.</li>\n<li><strong>null_ordering (str):</strong>  Indicates the default null ordering method to use if not explicitly set.\nOptions are \"nulls_are_small\", \"nulls_are_large\", \"nulls_are_last\".\nDefault: \"nulls_are_small\"</li>\n<li><strong>max_unsupported (int):</strong>  Maximum number of unsupported messages to include in a raised UnsupportedError.\nThis is only relevant if unsupported_level is ErrorLevel.RAISE.\nDefault: 3</li>\n<li><strong>leading_comma (bool):</strong>  if the the comma is leading or trailing in select statements\nDefault: False</li>\n<li><strong>max_text_width:</strong>  The max number of characters in a segment before creating new lines in pretty mode.\nThe default is on the smaller end because the length only represents a segment and not the true\nline length.\nDefault: 80</li>\n<li><strong>comments:</strong>  Whether or not to preserve comments in the output SQL code.\nDefault: True</li>\n</ul>\n", "bases": "sqlglot.generator.Generator"}, "sqlglot.dialects.hive.Hive.Generator.arrayagg_sql": {"fullname": "sqlglot.dialects.hive.Hive.Generator.arrayagg_sql", "modulename": "sqlglot.dialects.hive", "qualname": "Hive.Generator.arrayagg_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">ArrayAgg</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.hive.Hive.Generator.with_properties": {"fullname": "sqlglot.dialects.hive.Hive.Generator.with_properties", "modulename": "sqlglot.dialects.hive", "qualname": "Hive.Generator.with_properties", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">properties</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Properties</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.hive.Hive.Generator.datatype_sql": {"fullname": "sqlglot.dialects.hive.Hive.Generator.datatype_sql", "modulename": "sqlglot.dialects.hive", "qualname": "Hive.Generator.datatype_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">DataType</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.hive.Hive.Generator.after_having_modifiers": {"fullname": "sqlglot.dialects.hive.Hive.Generator.after_having_modifiers", "modulename": "sqlglot.dialects.hive", "qualname": "Hive.Generator.after_having_modifiers", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.mysql": {"fullname": "sqlglot.dialects.mysql", "modulename": "sqlglot.dialects.mysql", "kind": "module", "doc": "<p></p>\n"}, "sqlglot.dialects.mysql.MySQL": {"fullname": "sqlglot.dialects.mysql.MySQL", "modulename": "sqlglot.dialects.mysql", "qualname": "MySQL", "kind": "class", "doc": "<p></p>\n", "bases": "sqlglot.dialects.dialect.Dialect"}, "sqlglot.dialects.mysql.MySQL.Tokenizer": {"fullname": "sqlglot.dialects.mysql.MySQL.Tokenizer", "modulename": "sqlglot.dialects.mysql", "qualname": "MySQL.Tokenizer", "kind": "class", "doc": "<p></p>\n", "bases": "sqlglot.tokens.Tokenizer"}, "sqlglot.dialects.mysql.MySQL.Parser": {"fullname": "sqlglot.dialects.mysql.MySQL.Parser", "modulename": "sqlglot.dialects.mysql", "qualname": "MySQL.Parser", "kind": "class", "doc": "<p>Parser consumes a list of tokens produced by the <code>sqlglot.tokens.Tokenizer</code> and produces\na parsed syntax tree.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>error_level:</strong>  the desired error level.\nDefault: ErrorLevel.IMMEDIATE</li>\n<li><strong>error_message_context:</strong>  determines the amount of context to capture from a\nquery string when displaying the error message (in number of characters).\nDefault: 50.</li>\n<li><strong>index_offset:</strong>  Index offset for arrays eg ARRAY[0] vs ARRAY[1] as the head of a list.\nDefault: 0</li>\n<li><strong>alias_post_tablesample:</strong>  If the table alias comes after tablesample.\nDefault: False</li>\n<li><strong>max_errors:</strong>  Maximum number of error messages to include in a raised ParseError.\nThis is only relevant if error_level is ErrorLevel.RAISE.\nDefault: 3</li>\n<li><strong>null_ordering:</strong>  Indicates the default null ordering method to use if not explicitly set.\nOptions are \"nulls_are_small\", \"nulls_are_large\", \"nulls_are_last\".\nDefault: \"nulls_are_small\"</li>\n</ul>\n", "bases": "sqlglot.parser.Parser"}, "sqlglot.dialects.mysql.MySQL.Generator": {"fullname": "sqlglot.dialects.mysql.MySQL.Generator", "modulename": "sqlglot.dialects.mysql", "qualname": "MySQL.Generator", "kind": "class", "doc": "<p>Generator interprets the given syntax tree and produces a SQL string as an output.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>time_mapping (dict):</strong>  the dictionary of custom time mappings in which the key\nrepresents a python time format and the output the target time format</li>\n<li><strong>time_trie (trie):</strong>  a trie of the time_mapping keys</li>\n<li><strong>pretty (bool):</strong>  if set to True the returned string will be formatted. Default: False.</li>\n<li><strong>quote_start (str):</strong>  specifies which starting character to use to delimit quotes. Default: '.</li>\n<li><strong>quote_end (str):</strong>  specifies which ending character to use to delimit quotes. Default: '.</li>\n<li><strong>identifier_start (str):</strong>  specifies which starting character to use to delimit identifiers. Default: \".</li>\n<li><strong>identifier_end (str):</strong>  specifies which ending character to use to delimit identifiers. Default: \".</li>\n<li><strong>bit_start (str):</strong>  specifies which starting character to use to delimit bit literals. Default: None.</li>\n<li><strong>bit_end (str):</strong>  specifies which ending character to use to delimit bit literals. Default: None.</li>\n<li><strong>hex_start (str):</strong>  specifies which starting character to use to delimit hex literals. Default: None.</li>\n<li><strong>hex_end (str):</strong>  specifies which ending character to use to delimit hex literals. Default: None.</li>\n<li><strong>byte_start (str):</strong>  specifies which starting character to use to delimit byte literals. Default: None.</li>\n<li><strong>byte_end (str):</strong>  specifies which ending character to use to delimit byte literals. Default: None.</li>\n<li><strong>raw_start (str):</strong>  specifies which starting character to use to delimit raw literals. Default: None.</li>\n<li><strong>raw_end (str):</strong>  specifies which ending character to use to delimit raw literals. Default: None.</li>\n<li><strong>identify (bool | str):</strong>  'always': always quote, 'safe': quote identifiers if they don't contain an upcase, True defaults to always.</li>\n<li><strong>normalize (bool):</strong>  if set to True all identifiers will lower cased</li>\n<li><strong>string_escape (str):</strong>  specifies a string escape character. Default: '.</li>\n<li><strong>identifier_escape (str):</strong>  specifies an identifier escape character. Default: \".</li>\n<li><strong>pad (int):</strong>  determines padding in a formatted string. Default: 2.</li>\n<li><strong>indent (int):</strong>  determines the size of indentation in a formatted string. Default: 4.</li>\n<li><strong>unnest_column_only (bool):</strong>  if true unnest table aliases are considered only as column aliases</li>\n<li><strong>normalize_functions (str):</strong>  normalize function names, \"upper\", \"lower\", or None\nDefault: \"upper\"</li>\n<li><strong>alias_post_tablesample (bool):</strong>  if the table alias comes after tablesample\nDefault: False</li>\n<li><strong>identifiers_can_start_with_digit (bool):</strong>  if an unquoted identifier can start with digit\nDefault: False</li>\n<li><strong>unsupported_level (ErrorLevel):</strong>  determines the generator's behavior when it encounters\nunsupported expressions. Default ErrorLevel.WARN.</li>\n<li><strong>null_ordering (str):</strong>  Indicates the default null ordering method to use if not explicitly set.\nOptions are \"nulls_are_small\", \"nulls_are_large\", \"nulls_are_last\".\nDefault: \"nulls_are_small\"</li>\n<li><strong>max_unsupported (int):</strong>  Maximum number of unsupported messages to include in a raised UnsupportedError.\nThis is only relevant if unsupported_level is ErrorLevel.RAISE.\nDefault: 3</li>\n<li><strong>leading_comma (bool):</strong>  if the the comma is leading or trailing in select statements\nDefault: False</li>\n<li><strong>max_text_width:</strong>  The max number of characters in a segment before creating new lines in pretty mode.\nThe default is on the smaller end because the length only represents a segment and not the true\nline length.\nDefault: 80</li>\n<li><strong>comments:</strong>  Whether or not to preserve comments in the output SQL code.\nDefault: True</li>\n</ul>\n", "bases": "sqlglot.generator.Generator"}, "sqlglot.dialects.mysql.MySQL.Generator.show_sql": {"fullname": "sqlglot.dialects.mysql.MySQL.Generator.show_sql", "modulename": "sqlglot.dialects.mysql", "qualname": "MySQL.Generator.show_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Show</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.oracle": {"fullname": "sqlglot.dialects.oracle", "modulename": "sqlglot.dialects.oracle", "kind": "module", "doc": "<p></p>\n"}, "sqlglot.dialects.oracle.Oracle": {"fullname": "sqlglot.dialects.oracle.Oracle", "modulename": "sqlglot.dialects.oracle", "qualname": "Oracle", "kind": "class", "doc": "<p></p>\n", "bases": "sqlglot.dialects.dialect.Dialect"}, "sqlglot.dialects.oracle.Oracle.Parser": {"fullname": "sqlglot.dialects.oracle.Oracle.Parser", "modulename": "sqlglot.dialects.oracle", "qualname": "Oracle.Parser", "kind": "class", "doc": "<p>Parser consumes a list of tokens produced by the <code>sqlglot.tokens.Tokenizer</code> and produces\na parsed syntax tree.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>error_level:</strong>  the desired error level.\nDefault: ErrorLevel.IMMEDIATE</li>\n<li><strong>error_message_context:</strong>  determines the amount of context to capture from a\nquery string when displaying the error message (in number of characters).\nDefault: 50.</li>\n<li><strong>index_offset:</strong>  Index offset for arrays eg ARRAY[0] vs ARRAY[1] as the head of a list.\nDefault: 0</li>\n<li><strong>alias_post_tablesample:</strong>  If the table alias comes after tablesample.\nDefault: False</li>\n<li><strong>max_errors:</strong>  Maximum number of error messages to include in a raised ParseError.\nThis is only relevant if error_level is ErrorLevel.RAISE.\nDefault: 3</li>\n<li><strong>null_ordering:</strong>  Indicates the default null ordering method to use if not explicitly set.\nOptions are \"nulls_are_small\", \"nulls_are_large\", \"nulls_are_last\".\nDefault: \"nulls_are_small\"</li>\n</ul>\n", "bases": "sqlglot.parser.Parser"}, "sqlglot.dialects.oracle.Oracle.Generator": {"fullname": "sqlglot.dialects.oracle.Oracle.Generator", "modulename": "sqlglot.dialects.oracle", "qualname": "Oracle.Generator", "kind": "class", "doc": "<p>Generator interprets the given syntax tree and produces a SQL string as an output.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>time_mapping (dict):</strong>  the dictionary of custom time mappings in which the key\nrepresents a python time format and the output the target time format</li>\n<li><strong>time_trie (trie):</strong>  a trie of the time_mapping keys</li>\n<li><strong>pretty (bool):</strong>  if set to True the returned string will be formatted. Default: False.</li>\n<li><strong>quote_start (str):</strong>  specifies which starting character to use to delimit quotes. Default: '.</li>\n<li><strong>quote_end (str):</strong>  specifies which ending character to use to delimit quotes. Default: '.</li>\n<li><strong>identifier_start (str):</strong>  specifies which starting character to use to delimit identifiers. Default: \".</li>\n<li><strong>identifier_end (str):</strong>  specifies which ending character to use to delimit identifiers. Default: \".</li>\n<li><strong>bit_start (str):</strong>  specifies which starting character to use to delimit bit literals. Default: None.</li>\n<li><strong>bit_end (str):</strong>  specifies which ending character to use to delimit bit literals. Default: None.</li>\n<li><strong>hex_start (str):</strong>  specifies which starting character to use to delimit hex literals. Default: None.</li>\n<li><strong>hex_end (str):</strong>  specifies which ending character to use to delimit hex literals. Default: None.</li>\n<li><strong>byte_start (str):</strong>  specifies which starting character to use to delimit byte literals. Default: None.</li>\n<li><strong>byte_end (str):</strong>  specifies which ending character to use to delimit byte literals. Default: None.</li>\n<li><strong>raw_start (str):</strong>  specifies which starting character to use to delimit raw literals. Default: None.</li>\n<li><strong>raw_end (str):</strong>  specifies which ending character to use to delimit raw literals. Default: None.</li>\n<li><strong>identify (bool | str):</strong>  'always': always quote, 'safe': quote identifiers if they don't contain an upcase, True defaults to always.</li>\n<li><strong>normalize (bool):</strong>  if set to True all identifiers will lower cased</li>\n<li><strong>string_escape (str):</strong>  specifies a string escape character. Default: '.</li>\n<li><strong>identifier_escape (str):</strong>  specifies an identifier escape character. Default: \".</li>\n<li><strong>pad (int):</strong>  determines padding in a formatted string. Default: 2.</li>\n<li><strong>indent (int):</strong>  determines the size of indentation in a formatted string. Default: 4.</li>\n<li><strong>unnest_column_only (bool):</strong>  if true unnest table aliases are considered only as column aliases</li>\n<li><strong>normalize_functions (str):</strong>  normalize function names, \"upper\", \"lower\", or None\nDefault: \"upper\"</li>\n<li><strong>alias_post_tablesample (bool):</strong>  if the table alias comes after tablesample\nDefault: False</li>\n<li><strong>identifiers_can_start_with_digit (bool):</strong>  if an unquoted identifier can start with digit\nDefault: False</li>\n<li><strong>unsupported_level (ErrorLevel):</strong>  determines the generator's behavior when it encounters\nunsupported expressions. Default ErrorLevel.WARN.</li>\n<li><strong>null_ordering (str):</strong>  Indicates the default null ordering method to use if not explicitly set.\nOptions are \"nulls_are_small\", \"nulls_are_large\", \"nulls_are_last\".\nDefault: \"nulls_are_small\"</li>\n<li><strong>max_unsupported (int):</strong>  Maximum number of unsupported messages to include in a raised UnsupportedError.\nThis is only relevant if unsupported_level is ErrorLevel.RAISE.\nDefault: 3</li>\n<li><strong>leading_comma (bool):</strong>  if the the comma is leading or trailing in select statements\nDefault: False</li>\n<li><strong>max_text_width:</strong>  The max number of characters in a segment before creating new lines in pretty mode.\nThe default is on the smaller end because the length only represents a segment and not the true\nline length.\nDefault: 80</li>\n<li><strong>comments:</strong>  Whether or not to preserve comments in the output SQL code.\nDefault: True</li>\n</ul>\n", "bases": "sqlglot.generator.Generator"}, "sqlglot.dialects.oracle.Oracle.Generator.offset_sql": {"fullname": "sqlglot.dialects.oracle.Oracle.Generator.offset_sql", "modulename": "sqlglot.dialects.oracle", "qualname": "Oracle.Generator.offset_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Offset</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.oracle.Oracle.Generator.column_sql": {"fullname": "sqlglot.dialects.oracle.Oracle.Generator.column_sql", "modulename": "sqlglot.dialects.oracle", "qualname": "Oracle.Generator.column_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Column</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.oracle.Oracle.Generator.xmltable_sql": {"fullname": "sqlglot.dialects.oracle.Oracle.Generator.xmltable_sql", "modulename": "sqlglot.dialects.oracle", "qualname": "Oracle.Generator.xmltable_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">XMLTable</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.oracle.Oracle.Tokenizer": {"fullname": "sqlglot.dialects.oracle.Oracle.Tokenizer", "modulename": "sqlglot.dialects.oracle", "qualname": "Oracle.Tokenizer", "kind": "class", "doc": "<p></p>\n", "bases": "sqlglot.tokens.Tokenizer"}, "sqlglot.dialects.postgres": {"fullname": "sqlglot.dialects.postgres", "modulename": "sqlglot.dialects.postgres", "kind": "module", "doc": "<p></p>\n"}, "sqlglot.dialects.postgres.Postgres": {"fullname": "sqlglot.dialects.postgres.Postgres", "modulename": "sqlglot.dialects.postgres", "qualname": "Postgres", "kind": "class", "doc": "<p></p>\n", "bases": "sqlglot.dialects.dialect.Dialect"}, "sqlglot.dialects.postgres.Postgres.Tokenizer": {"fullname": "sqlglot.dialects.postgres.Postgres.Tokenizer", "modulename": "sqlglot.dialects.postgres", "qualname": "Postgres.Tokenizer", "kind": "class", "doc": "<p></p>\n", "bases": "sqlglot.tokens.Tokenizer"}, "sqlglot.dialects.postgres.Postgres.Parser": {"fullname": "sqlglot.dialects.postgres.Postgres.Parser", "modulename": "sqlglot.dialects.postgres", "qualname": "Postgres.Parser", "kind": "class", "doc": "<p>Parser consumes a list of tokens produced by the <code>sqlglot.tokens.Tokenizer</code> and produces\na parsed syntax tree.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>error_level:</strong>  the desired error level.\nDefault: ErrorLevel.IMMEDIATE</li>\n<li><strong>error_message_context:</strong>  determines the amount of context to capture from a\nquery string when displaying the error message (in number of characters).\nDefault: 50.</li>\n<li><strong>index_offset:</strong>  Index offset for arrays eg ARRAY[0] vs ARRAY[1] as the head of a list.\nDefault: 0</li>\n<li><strong>alias_post_tablesample:</strong>  If the table alias comes after tablesample.\nDefault: False</li>\n<li><strong>max_errors:</strong>  Maximum number of error messages to include in a raised ParseError.\nThis is only relevant if error_level is ErrorLevel.RAISE.\nDefault: 3</li>\n<li><strong>null_ordering:</strong>  Indicates the default null ordering method to use if not explicitly set.\nOptions are \"nulls_are_small\", \"nulls_are_large\", \"nulls_are_last\".\nDefault: \"nulls_are_small\"</li>\n</ul>\n", "bases": "sqlglot.parser.Parser"}, "sqlglot.dialects.postgres.Postgres.Generator": {"fullname": "sqlglot.dialects.postgres.Postgres.Generator", "modulename": "sqlglot.dialects.postgres", "qualname": "Postgres.Generator", "kind": "class", "doc": "<p>Generator interprets the given syntax tree and produces a SQL string as an output.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>time_mapping (dict):</strong>  the dictionary of custom time mappings in which the key\nrepresents a python time format and the output the target time format</li>\n<li><strong>time_trie (trie):</strong>  a trie of the time_mapping keys</li>\n<li><strong>pretty (bool):</strong>  if set to True the returned string will be formatted. Default: False.</li>\n<li><strong>quote_start (str):</strong>  specifies which starting character to use to delimit quotes. Default: '.</li>\n<li><strong>quote_end (str):</strong>  specifies which ending character to use to delimit quotes. Default: '.</li>\n<li><strong>identifier_start (str):</strong>  specifies which starting character to use to delimit identifiers. Default: \".</li>\n<li><strong>identifier_end (str):</strong>  specifies which ending character to use to delimit identifiers. Default: \".</li>\n<li><strong>bit_start (str):</strong>  specifies which starting character to use to delimit bit literals. Default: None.</li>\n<li><strong>bit_end (str):</strong>  specifies which ending character to use to delimit bit literals. Default: None.</li>\n<li><strong>hex_start (str):</strong>  specifies which starting character to use to delimit hex literals. Default: None.</li>\n<li><strong>hex_end (str):</strong>  specifies which ending character to use to delimit hex literals. Default: None.</li>\n<li><strong>byte_start (str):</strong>  specifies which starting character to use to delimit byte literals. Default: None.</li>\n<li><strong>byte_end (str):</strong>  specifies which ending character to use to delimit byte literals. Default: None.</li>\n<li><strong>raw_start (str):</strong>  specifies which starting character to use to delimit raw literals. Default: None.</li>\n<li><strong>raw_end (str):</strong>  specifies which ending character to use to delimit raw literals. Default: None.</li>\n<li><strong>identify (bool | str):</strong>  'always': always quote, 'safe': quote identifiers if they don't contain an upcase, True defaults to always.</li>\n<li><strong>normalize (bool):</strong>  if set to True all identifiers will lower cased</li>\n<li><strong>string_escape (str):</strong>  specifies a string escape character. Default: '.</li>\n<li><strong>identifier_escape (str):</strong>  specifies an identifier escape character. Default: \".</li>\n<li><strong>pad (int):</strong>  determines padding in a formatted string. Default: 2.</li>\n<li><strong>indent (int):</strong>  determines the size of indentation in a formatted string. Default: 4.</li>\n<li><strong>unnest_column_only (bool):</strong>  if true unnest table aliases are considered only as column aliases</li>\n<li><strong>normalize_functions (str):</strong>  normalize function names, \"upper\", \"lower\", or None\nDefault: \"upper\"</li>\n<li><strong>alias_post_tablesample (bool):</strong>  if the table alias comes after tablesample\nDefault: False</li>\n<li><strong>identifiers_can_start_with_digit (bool):</strong>  if an unquoted identifier can start with digit\nDefault: False</li>\n<li><strong>unsupported_level (ErrorLevel):</strong>  determines the generator's behavior when it encounters\nunsupported expressions. Default ErrorLevel.WARN.</li>\n<li><strong>null_ordering (str):</strong>  Indicates the default null ordering method to use if not explicitly set.\nOptions are \"nulls_are_small\", \"nulls_are_large\", \"nulls_are_last\".\nDefault: \"nulls_are_small\"</li>\n<li><strong>max_unsupported (int):</strong>  Maximum number of unsupported messages to include in a raised UnsupportedError.\nThis is only relevant if unsupported_level is ErrorLevel.RAISE.\nDefault: 3</li>\n<li><strong>leading_comma (bool):</strong>  if the the comma is leading or trailing in select statements\nDefault: False</li>\n<li><strong>max_text_width:</strong>  The max number of characters in a segment before creating new lines in pretty mode.\nThe default is on the smaller end because the length only represents a segment and not the true\nline length.\nDefault: 80</li>\n<li><strong>comments:</strong>  Whether or not to preserve comments in the output SQL code.\nDefault: True</li>\n</ul>\n", "bases": "sqlglot.generator.Generator"}, "sqlglot.dialects.presto": {"fullname": "sqlglot.dialects.presto", "modulename": "sqlglot.dialects.presto", "kind": "module", "doc": "<p></p>\n"}, "sqlglot.dialects.presto.Presto": {"fullname": "sqlglot.dialects.presto.Presto", "modulename": "sqlglot.dialects.presto", "qualname": "Presto", "kind": "class", "doc": "<p></p>\n", "bases": "sqlglot.dialects.dialect.Dialect"}, "sqlglot.dialects.presto.Presto.Tokenizer": {"fullname": "sqlglot.dialects.presto.Presto.Tokenizer", "modulename": "sqlglot.dialects.presto", "qualname": "Presto.Tokenizer", "kind": "class", "doc": "<p></p>\n", "bases": "sqlglot.tokens.Tokenizer"}, "sqlglot.dialects.presto.Presto.Parser": {"fullname": "sqlglot.dialects.presto.Presto.Parser", "modulename": "sqlglot.dialects.presto", "qualname": "Presto.Parser", "kind": "class", "doc": "<p>Parser consumes a list of tokens produced by the <code>sqlglot.tokens.Tokenizer</code> and produces\na parsed syntax tree.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>error_level:</strong>  the desired error level.\nDefault: ErrorLevel.IMMEDIATE</li>\n<li><strong>error_message_context:</strong>  determines the amount of context to capture from a\nquery string when displaying the error message (in number of characters).\nDefault: 50.</li>\n<li><strong>index_offset:</strong>  Index offset for arrays eg ARRAY[0] vs ARRAY[1] as the head of a list.\nDefault: 0</li>\n<li><strong>alias_post_tablesample:</strong>  If the table alias comes after tablesample.\nDefault: False</li>\n<li><strong>max_errors:</strong>  Maximum number of error messages to include in a raised ParseError.\nThis is only relevant if error_level is ErrorLevel.RAISE.\nDefault: 3</li>\n<li><strong>null_ordering:</strong>  Indicates the default null ordering method to use if not explicitly set.\nOptions are \"nulls_are_small\", \"nulls_are_large\", \"nulls_are_last\".\nDefault: \"nulls_are_small\"</li>\n</ul>\n", "bases": "sqlglot.parser.Parser"}, "sqlglot.dialects.presto.Presto.Generator": {"fullname": "sqlglot.dialects.presto.Presto.Generator", "modulename": "sqlglot.dialects.presto", "qualname": "Presto.Generator", "kind": "class", "doc": "<p>Generator interprets the given syntax tree and produces a SQL string as an output.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>time_mapping (dict):</strong>  the dictionary of custom time mappings in which the key\nrepresents a python time format and the output the target time format</li>\n<li><strong>time_trie (trie):</strong>  a trie of the time_mapping keys</li>\n<li><strong>pretty (bool):</strong>  if set to True the returned string will be formatted. Default: False.</li>\n<li><strong>quote_start (str):</strong>  specifies which starting character to use to delimit quotes. Default: '.</li>\n<li><strong>quote_end (str):</strong>  specifies which ending character to use to delimit quotes. Default: '.</li>\n<li><strong>identifier_start (str):</strong>  specifies which starting character to use to delimit identifiers. Default: \".</li>\n<li><strong>identifier_end (str):</strong>  specifies which ending character to use to delimit identifiers. Default: \".</li>\n<li><strong>bit_start (str):</strong>  specifies which starting character to use to delimit bit literals. Default: None.</li>\n<li><strong>bit_end (str):</strong>  specifies which ending character to use to delimit bit literals. Default: None.</li>\n<li><strong>hex_start (str):</strong>  specifies which starting character to use to delimit hex literals. Default: None.</li>\n<li><strong>hex_end (str):</strong>  specifies which ending character to use to delimit hex literals. Default: None.</li>\n<li><strong>byte_start (str):</strong>  specifies which starting character to use to delimit byte literals. Default: None.</li>\n<li><strong>byte_end (str):</strong>  specifies which ending character to use to delimit byte literals. Default: None.</li>\n<li><strong>raw_start (str):</strong>  specifies which starting character to use to delimit raw literals. Default: None.</li>\n<li><strong>raw_end (str):</strong>  specifies which ending character to use to delimit raw literals. Default: None.</li>\n<li><strong>identify (bool | str):</strong>  'always': always quote, 'safe': quote identifiers if they don't contain an upcase, True defaults to always.</li>\n<li><strong>normalize (bool):</strong>  if set to True all identifiers will lower cased</li>\n<li><strong>string_escape (str):</strong>  specifies a string escape character. Default: '.</li>\n<li><strong>identifier_escape (str):</strong>  specifies an identifier escape character. Default: \".</li>\n<li><strong>pad (int):</strong>  determines padding in a formatted string. Default: 2.</li>\n<li><strong>indent (int):</strong>  determines the size of indentation in a formatted string. Default: 4.</li>\n<li><strong>unnest_column_only (bool):</strong>  if true unnest table aliases are considered only as column aliases</li>\n<li><strong>normalize_functions (str):</strong>  normalize function names, \"upper\", \"lower\", or None\nDefault: \"upper\"</li>\n<li><strong>alias_post_tablesample (bool):</strong>  if the table alias comes after tablesample\nDefault: False</li>\n<li><strong>identifiers_can_start_with_digit (bool):</strong>  if an unquoted identifier can start with digit\nDefault: False</li>\n<li><strong>unsupported_level (ErrorLevel):</strong>  determines the generator's behavior when it encounters\nunsupported expressions. Default ErrorLevel.WARN.</li>\n<li><strong>null_ordering (str):</strong>  Indicates the default null ordering method to use if not explicitly set.\nOptions are \"nulls_are_small\", \"nulls_are_large\", \"nulls_are_last\".\nDefault: \"nulls_are_small\"</li>\n<li><strong>max_unsupported (int):</strong>  Maximum number of unsupported messages to include in a raised UnsupportedError.\nThis is only relevant if unsupported_level is ErrorLevel.RAISE.\nDefault: 3</li>\n<li><strong>leading_comma (bool):</strong>  if the the comma is leading or trailing in select statements\nDefault: False</li>\n<li><strong>max_text_width:</strong>  The max number of characters in a segment before creating new lines in pretty mode.\nThe default is on the smaller end because the length only represents a segment and not the true\nline length.\nDefault: 80</li>\n<li><strong>comments:</strong>  Whether or not to preserve comments in the output SQL code.\nDefault: True</li>\n</ul>\n", "bases": "sqlglot.generator.Generator"}, "sqlglot.dialects.presto.Presto.Generator.interval_sql": {"fullname": "sqlglot.dialects.presto.Presto.Generator.interval_sql", "modulename": "sqlglot.dialects.presto", "qualname": "Presto.Generator.interval_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Interval</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.presto.Presto.Generator.transaction_sql": {"fullname": "sqlglot.dialects.presto.Presto.Generator.transaction_sql", "modulename": "sqlglot.dialects.presto", "qualname": "Presto.Generator.transaction_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Transaction</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.presto.Presto.Generator.generateseries_sql": {"fullname": "sqlglot.dialects.presto.Presto.Generator.generateseries_sql", "modulename": "sqlglot.dialects.presto", "qualname": "Presto.Generator.generateseries_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">GenerateSeries</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.redshift": {"fullname": "sqlglot.dialects.redshift", "modulename": "sqlglot.dialects.redshift", "kind": "module", "doc": "<p></p>\n"}, "sqlglot.dialects.redshift.Redshift": {"fullname": "sqlglot.dialects.redshift.Redshift", "modulename": "sqlglot.dialects.redshift", "qualname": "Redshift", "kind": "class", "doc": "<p></p>\n", "bases": "sqlglot.dialects.postgres.Postgres"}, "sqlglot.dialects.redshift.Redshift.Parser": {"fullname": "sqlglot.dialects.redshift.Redshift.Parser", "modulename": "sqlglot.dialects.redshift", "qualname": "Redshift.Parser", "kind": "class", "doc": "<p>Parser consumes a list of tokens produced by the <code>sqlglot.tokens.Tokenizer</code> and produces\na parsed syntax tree.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>error_level:</strong>  the desired error level.\nDefault: ErrorLevel.IMMEDIATE</li>\n<li><strong>error_message_context:</strong>  determines the amount of context to capture from a\nquery string when displaying the error message (in number of characters).\nDefault: 50.</li>\n<li><strong>index_offset:</strong>  Index offset for arrays eg ARRAY[0] vs ARRAY[1] as the head of a list.\nDefault: 0</li>\n<li><strong>alias_post_tablesample:</strong>  If the table alias comes after tablesample.\nDefault: False</li>\n<li><strong>max_errors:</strong>  Maximum number of error messages to include in a raised ParseError.\nThis is only relevant if error_level is ErrorLevel.RAISE.\nDefault: 3</li>\n<li><strong>null_ordering:</strong>  Indicates the default null ordering method to use if not explicitly set.\nOptions are \"nulls_are_small\", \"nulls_are_large\", \"nulls_are_last\".\nDefault: \"nulls_are_small\"</li>\n</ul>\n", "bases": "sqlglot.dialects.postgres.Postgres.Parser"}, "sqlglot.dialects.redshift.Redshift.Tokenizer": {"fullname": "sqlglot.dialects.redshift.Redshift.Tokenizer", "modulename": "sqlglot.dialects.redshift", "qualname": "Redshift.Tokenizer", "kind": "class", "doc": "<p></p>\n", "bases": "sqlglot.dialects.postgres.Postgres.Tokenizer"}, "sqlglot.dialects.redshift.Redshift.Generator": {"fullname": "sqlglot.dialects.redshift.Redshift.Generator", "modulename": "sqlglot.dialects.redshift", "qualname": "Redshift.Generator", "kind": "class", "doc": "<p>Generator interprets the given syntax tree and produces a SQL string as an output.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>time_mapping (dict):</strong>  the dictionary of custom time mappings in which the key\nrepresents a python time format and the output the target time format</li>\n<li><strong>time_trie (trie):</strong>  a trie of the time_mapping keys</li>\n<li><strong>pretty (bool):</strong>  if set to True the returned string will be formatted. Default: False.</li>\n<li><strong>quote_start (str):</strong>  specifies which starting character to use to delimit quotes. Default: '.</li>\n<li><strong>quote_end (str):</strong>  specifies which ending character to use to delimit quotes. Default: '.</li>\n<li><strong>identifier_start (str):</strong>  specifies which starting character to use to delimit identifiers. Default: \".</li>\n<li><strong>identifier_end (str):</strong>  specifies which ending character to use to delimit identifiers. Default: \".</li>\n<li><strong>bit_start (str):</strong>  specifies which starting character to use to delimit bit literals. Default: None.</li>\n<li><strong>bit_end (str):</strong>  specifies which ending character to use to delimit bit literals. Default: None.</li>\n<li><strong>hex_start (str):</strong>  specifies which starting character to use to delimit hex literals. Default: None.</li>\n<li><strong>hex_end (str):</strong>  specifies which ending character to use to delimit hex literals. Default: None.</li>\n<li><strong>byte_start (str):</strong>  specifies which starting character to use to delimit byte literals. Default: None.</li>\n<li><strong>byte_end (str):</strong>  specifies which ending character to use to delimit byte literals. Default: None.</li>\n<li><strong>raw_start (str):</strong>  specifies which starting character to use to delimit raw literals. Default: None.</li>\n<li><strong>raw_end (str):</strong>  specifies which ending character to use to delimit raw literals. Default: None.</li>\n<li><strong>identify (bool | str):</strong>  'always': always quote, 'safe': quote identifiers if they don't contain an upcase, True defaults to always.</li>\n<li><strong>normalize (bool):</strong>  if set to True all identifiers will lower cased</li>\n<li><strong>string_escape (str):</strong>  specifies a string escape character. Default: '.</li>\n<li><strong>identifier_escape (str):</strong>  specifies an identifier escape character. Default: \".</li>\n<li><strong>pad (int):</strong>  determines padding in a formatted string. Default: 2.</li>\n<li><strong>indent (int):</strong>  determines the size of indentation in a formatted string. Default: 4.</li>\n<li><strong>unnest_column_only (bool):</strong>  if true unnest table aliases are considered only as column aliases</li>\n<li><strong>normalize_functions (str):</strong>  normalize function names, \"upper\", \"lower\", or None\nDefault: \"upper\"</li>\n<li><strong>alias_post_tablesample (bool):</strong>  if the table alias comes after tablesample\nDefault: False</li>\n<li><strong>identifiers_can_start_with_digit (bool):</strong>  if an unquoted identifier can start with digit\nDefault: False</li>\n<li><strong>unsupported_level (ErrorLevel):</strong>  determines the generator's behavior when it encounters\nunsupported expressions. Default ErrorLevel.WARN.</li>\n<li><strong>null_ordering (str):</strong>  Indicates the default null ordering method to use if not explicitly set.\nOptions are \"nulls_are_small\", \"nulls_are_large\", \"nulls_are_last\".\nDefault: \"nulls_are_small\"</li>\n<li><strong>max_unsupported (int):</strong>  Maximum number of unsupported messages to include in a raised UnsupportedError.\nThis is only relevant if unsupported_level is ErrorLevel.RAISE.\nDefault: 3</li>\n<li><strong>leading_comma (bool):</strong>  if the the comma is leading or trailing in select statements\nDefault: False</li>\n<li><strong>max_text_width:</strong>  The max number of characters in a segment before creating new lines in pretty mode.\nThe default is on the smaller end because the length only represents a segment and not the true\nline length.\nDefault: 80</li>\n<li><strong>comments:</strong>  Whether or not to preserve comments in the output SQL code.\nDefault: True</li>\n</ul>\n", "bases": "sqlglot.dialects.postgres.Postgres.Generator"}, "sqlglot.dialects.redshift.Redshift.Generator.values_sql": {"fullname": "sqlglot.dialects.redshift.Redshift.Generator.values_sql", "modulename": "sqlglot.dialects.redshift", "qualname": "Redshift.Generator.values_sql", "kind": "function", "doc": "<p>Converts <code>VALUES...</code> expression into a series of unions.</p>\n\n<p>Note: If you have a lot of unions then this will result in a large number of recursive statements to\nevaluate the expression. You may need to increase <code>sys.setrecursionlimit</code> to run and it can also be\nvery slow.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Values</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.redshift.Redshift.Generator.with_properties": {"fullname": "sqlglot.dialects.redshift.Redshift.Generator.with_properties", "modulename": "sqlglot.dialects.redshift", "qualname": "Redshift.Generator.with_properties", "kind": "function", "doc": "<p>Redshift doesn't have <code>WITH</code> as part of their with_properties so we remove it</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">properties</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Properties</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.redshift.Redshift.Generator.datatype_sql": {"fullname": "sqlglot.dialects.redshift.Redshift.Generator.datatype_sql", "modulename": "sqlglot.dialects.redshift", "qualname": "Redshift.Generator.datatype_sql", "kind": "function", "doc": "<p>Redshift converts the <code>TEXT</code> data type to <code>VARCHAR(255)</code> by default when people more generally mean\nVARCHAR of max length which is <code>VARCHAR(max)</code> in Redshift. Therefore if we get a <code>TEXT</code> data type\nwithout precision we convert it to <code>VARCHAR(max)</code> and if it does have precision then we just convert\n<code>TEXT</code> to <code>VARCHAR</code>.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">DataType</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.snowflake": {"fullname": "sqlglot.dialects.snowflake", "modulename": "sqlglot.dialects.snowflake", "kind": "module", "doc": "<p></p>\n"}, "sqlglot.dialects.snowflake.Snowflake": {"fullname": "sqlglot.dialects.snowflake.Snowflake", "modulename": "sqlglot.dialects.snowflake", "qualname": "Snowflake", "kind": "class", "doc": "<p></p>\n", "bases": "sqlglot.dialects.dialect.Dialect"}, "sqlglot.dialects.snowflake.Snowflake.Parser": {"fullname": "sqlglot.dialects.snowflake.Snowflake.Parser", "modulename": "sqlglot.dialects.snowflake", "qualname": "Snowflake.Parser", "kind": "class", "doc": "<p>Parser consumes a list of tokens produced by the <code>sqlglot.tokens.Tokenizer</code> and produces\na parsed syntax tree.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>error_level:</strong>  the desired error level.\nDefault: ErrorLevel.IMMEDIATE</li>\n<li><strong>error_message_context:</strong>  determines the amount of context to capture from a\nquery string when displaying the error message (in number of characters).\nDefault: 50.</li>\n<li><strong>index_offset:</strong>  Index offset for arrays eg ARRAY[0] vs ARRAY[1] as the head of a list.\nDefault: 0</li>\n<li><strong>alias_post_tablesample:</strong>  If the table alias comes after tablesample.\nDefault: False</li>\n<li><strong>max_errors:</strong>  Maximum number of error messages to include in a raised ParseError.\nThis is only relevant if error_level is ErrorLevel.RAISE.\nDefault: 3</li>\n<li><strong>null_ordering:</strong>  Indicates the default null ordering method to use if not explicitly set.\nOptions are \"nulls_are_small\", \"nulls_are_large\", \"nulls_are_last\".\nDefault: \"nulls_are_small\"</li>\n</ul>\n", "bases": "sqlglot.parser.Parser"}, "sqlglot.dialects.snowflake.Snowflake.Tokenizer": {"fullname": "sqlglot.dialects.snowflake.Snowflake.Tokenizer", "modulename": "sqlglot.dialects.snowflake", "qualname": "Snowflake.Tokenizer", "kind": "class", "doc": "<p></p>\n", "bases": "sqlglot.tokens.Tokenizer"}, "sqlglot.dialects.snowflake.Snowflake.Generator": {"fullname": "sqlglot.dialects.snowflake.Snowflake.Generator", "modulename": "sqlglot.dialects.snowflake", "qualname": "Snowflake.Generator", "kind": "class", "doc": "<p>Generator interprets the given syntax tree and produces a SQL string as an output.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>time_mapping (dict):</strong>  the dictionary of custom time mappings in which the key\nrepresents a python time format and the output the target time format</li>\n<li><strong>time_trie (trie):</strong>  a trie of the time_mapping keys</li>\n<li><strong>pretty (bool):</strong>  if set to True the returned string will be formatted. Default: False.</li>\n<li><strong>quote_start (str):</strong>  specifies which starting character to use to delimit quotes. Default: '.</li>\n<li><strong>quote_end (str):</strong>  specifies which ending character to use to delimit quotes. Default: '.</li>\n<li><strong>identifier_start (str):</strong>  specifies which starting character to use to delimit identifiers. Default: \".</li>\n<li><strong>identifier_end (str):</strong>  specifies which ending character to use to delimit identifiers. Default: \".</li>\n<li><strong>bit_start (str):</strong>  specifies which starting character to use to delimit bit literals. Default: None.</li>\n<li><strong>bit_end (str):</strong>  specifies which ending character to use to delimit bit literals. Default: None.</li>\n<li><strong>hex_start (str):</strong>  specifies which starting character to use to delimit hex literals. Default: None.</li>\n<li><strong>hex_end (str):</strong>  specifies which ending character to use to delimit hex literals. Default: None.</li>\n<li><strong>byte_start (str):</strong>  specifies which starting character to use to delimit byte literals. Default: None.</li>\n<li><strong>byte_end (str):</strong>  specifies which ending character to use to delimit byte literals. Default: None.</li>\n<li><strong>raw_start (str):</strong>  specifies which starting character to use to delimit raw literals. Default: None.</li>\n<li><strong>raw_end (str):</strong>  specifies which ending character to use to delimit raw literals. Default: None.</li>\n<li><strong>identify (bool | str):</strong>  'always': always quote, 'safe': quote identifiers if they don't contain an upcase, True defaults to always.</li>\n<li><strong>normalize (bool):</strong>  if set to True all identifiers will lower cased</li>\n<li><strong>string_escape (str):</strong>  specifies a string escape character. Default: '.</li>\n<li><strong>identifier_escape (str):</strong>  specifies an identifier escape character. Default: \".</li>\n<li><strong>pad (int):</strong>  determines padding in a formatted string. Default: 2.</li>\n<li><strong>indent (int):</strong>  determines the size of indentation in a formatted string. Default: 4.</li>\n<li><strong>unnest_column_only (bool):</strong>  if true unnest table aliases are considered only as column aliases</li>\n<li><strong>normalize_functions (str):</strong>  normalize function names, \"upper\", \"lower\", or None\nDefault: \"upper\"</li>\n<li><strong>alias_post_tablesample (bool):</strong>  if the table alias comes after tablesample\nDefault: False</li>\n<li><strong>identifiers_can_start_with_digit (bool):</strong>  if an unquoted identifier can start with digit\nDefault: False</li>\n<li><strong>unsupported_level (ErrorLevel):</strong>  determines the generator's behavior when it encounters\nunsupported expressions. Default ErrorLevel.WARN.</li>\n<li><strong>null_ordering (str):</strong>  Indicates the default null ordering method to use if not explicitly set.\nOptions are \"nulls_are_small\", \"nulls_are_large\", \"nulls_are_last\".\nDefault: \"nulls_are_small\"</li>\n<li><strong>max_unsupported (int):</strong>  Maximum number of unsupported messages to include in a raised UnsupportedError.\nThis is only relevant if unsupported_level is ErrorLevel.RAISE.\nDefault: 3</li>\n<li><strong>leading_comma (bool):</strong>  if the the comma is leading or trailing in select statements\nDefault: False</li>\n<li><strong>max_text_width:</strong>  The max number of characters in a segment before creating new lines in pretty mode.\nThe default is on the smaller end because the length only represents a segment and not the true\nline length.\nDefault: 80</li>\n<li><strong>comments:</strong>  Whether or not to preserve comments in the output SQL code.\nDefault: True</li>\n</ul>\n", "bases": "sqlglot.generator.Generator"}, "sqlglot.dialects.snowflake.Snowflake.Generator.except_op": {"fullname": "sqlglot.dialects.snowflake.Snowflake.Generator.except_op", "modulename": "sqlglot.dialects.snowflake", "qualname": "Snowflake.Generator.except_op", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Except</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.snowflake.Snowflake.Generator.intersect_op": {"fullname": "sqlglot.dialects.snowflake.Snowflake.Generator.intersect_op", "modulename": "sqlglot.dialects.snowflake", "qualname": "Snowflake.Generator.intersect_op", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Intersect</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.snowflake.Snowflake.Generator.settag_sql": {"fullname": "sqlglot.dialects.snowflake.Snowflake.Generator.settag_sql", "modulename": "sqlglot.dialects.snowflake", "qualname": "Snowflake.Generator.settag_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">SetTag</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.snowflake.Snowflake.Generator.describe_sql": {"fullname": "sqlglot.dialects.snowflake.Snowflake.Generator.describe_sql", "modulename": "sqlglot.dialects.snowflake", "qualname": "Snowflake.Generator.describe_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Describe</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.snowflake.Snowflake.Generator.generatedasidentitycolumnconstraint_sql": {"fullname": "sqlglot.dialects.snowflake.Snowflake.Generator.generatedasidentitycolumnconstraint_sql", "modulename": "sqlglot.dialects.snowflake", "qualname": "Snowflake.Generator.generatedasidentitycolumnconstraint_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">GeneratedAsIdentityColumnConstraint</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.spark": {"fullname": "sqlglot.dialects.spark", "modulename": "sqlglot.dialects.spark", "kind": "module", "doc": "<p></p>\n"}, "sqlglot.dialects.spark.Spark": {"fullname": "sqlglot.dialects.spark.Spark", "modulename": "sqlglot.dialects.spark", "qualname": "Spark", "kind": "class", "doc": "<p></p>\n", "bases": "sqlglot.dialects.spark2.Spark2"}, "sqlglot.dialects.spark.Spark.Parser": {"fullname": "sqlglot.dialects.spark.Spark.Parser", "modulename": "sqlglot.dialects.spark", "qualname": "Spark.Parser", "kind": "class", "doc": "<p>Parser consumes a list of tokens produced by the <code>sqlglot.tokens.Tokenizer</code> and produces\na parsed syntax tree.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>error_level:</strong>  the desired error level.\nDefault: ErrorLevel.IMMEDIATE</li>\n<li><strong>error_message_context:</strong>  determines the amount of context to capture from a\nquery string when displaying the error message (in number of characters).\nDefault: 50.</li>\n<li><strong>index_offset:</strong>  Index offset for arrays eg ARRAY[0] vs ARRAY[1] as the head of a list.\nDefault: 0</li>\n<li><strong>alias_post_tablesample:</strong>  If the table alias comes after tablesample.\nDefault: False</li>\n<li><strong>max_errors:</strong>  Maximum number of error messages to include in a raised ParseError.\nThis is only relevant if error_level is ErrorLevel.RAISE.\nDefault: 3</li>\n<li><strong>null_ordering:</strong>  Indicates the default null ordering method to use if not explicitly set.\nOptions are \"nulls_are_small\", \"nulls_are_large\", \"nulls_are_last\".\nDefault: \"nulls_are_small\"</li>\n</ul>\n", "bases": "sqlglot.dialects.spark2.Spark2.Parser"}, "sqlglot.dialects.spark.Spark.Generator": {"fullname": "sqlglot.dialects.spark.Spark.Generator", "modulename": "sqlglot.dialects.spark", "qualname": "Spark.Generator", "kind": "class", "doc": "<p>Generator interprets the given syntax tree and produces a SQL string as an output.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>time_mapping (dict):</strong>  the dictionary of custom time mappings in which the key\nrepresents a python time format and the output the target time format</li>\n<li><strong>time_trie (trie):</strong>  a trie of the time_mapping keys</li>\n<li><strong>pretty (bool):</strong>  if set to True the returned string will be formatted. Default: False.</li>\n<li><strong>quote_start (str):</strong>  specifies which starting character to use to delimit quotes. Default: '.</li>\n<li><strong>quote_end (str):</strong>  specifies which ending character to use to delimit quotes. Default: '.</li>\n<li><strong>identifier_start (str):</strong>  specifies which starting character to use to delimit identifiers. Default: \".</li>\n<li><strong>identifier_end (str):</strong>  specifies which ending character to use to delimit identifiers. Default: \".</li>\n<li><strong>bit_start (str):</strong>  specifies which starting character to use to delimit bit literals. Default: None.</li>\n<li><strong>bit_end (str):</strong>  specifies which ending character to use to delimit bit literals. Default: None.</li>\n<li><strong>hex_start (str):</strong>  specifies which starting character to use to delimit hex literals. Default: None.</li>\n<li><strong>hex_end (str):</strong>  specifies which ending character to use to delimit hex literals. Default: None.</li>\n<li><strong>byte_start (str):</strong>  specifies which starting character to use to delimit byte literals. Default: None.</li>\n<li><strong>byte_end (str):</strong>  specifies which ending character to use to delimit byte literals. Default: None.</li>\n<li><strong>raw_start (str):</strong>  specifies which starting character to use to delimit raw literals. Default: None.</li>\n<li><strong>raw_end (str):</strong>  specifies which ending character to use to delimit raw literals. Default: None.</li>\n<li><strong>identify (bool | str):</strong>  'always': always quote, 'safe': quote identifiers if they don't contain an upcase, True defaults to always.</li>\n<li><strong>normalize (bool):</strong>  if set to True all identifiers will lower cased</li>\n<li><strong>string_escape (str):</strong>  specifies a string escape character. Default: '.</li>\n<li><strong>identifier_escape (str):</strong>  specifies an identifier escape character. Default: \".</li>\n<li><strong>pad (int):</strong>  determines padding in a formatted string. Default: 2.</li>\n<li><strong>indent (int):</strong>  determines the size of indentation in a formatted string. Default: 4.</li>\n<li><strong>unnest_column_only (bool):</strong>  if true unnest table aliases are considered only as column aliases</li>\n<li><strong>normalize_functions (str):</strong>  normalize function names, \"upper\", \"lower\", or None\nDefault: \"upper\"</li>\n<li><strong>alias_post_tablesample (bool):</strong>  if the table alias comes after tablesample\nDefault: False</li>\n<li><strong>identifiers_can_start_with_digit (bool):</strong>  if an unquoted identifier can start with digit\nDefault: False</li>\n<li><strong>unsupported_level (ErrorLevel):</strong>  determines the generator's behavior when it encounters\nunsupported expressions. Default ErrorLevel.WARN.</li>\n<li><strong>null_ordering (str):</strong>  Indicates the default null ordering method to use if not explicitly set.\nOptions are \"nulls_are_small\", \"nulls_are_large\", \"nulls_are_last\".\nDefault: \"nulls_are_small\"</li>\n<li><strong>max_unsupported (int):</strong>  Maximum number of unsupported messages to include in a raised UnsupportedError.\nThis is only relevant if unsupported_level is ErrorLevel.RAISE.\nDefault: 3</li>\n<li><strong>leading_comma (bool):</strong>  if the the comma is leading or trailing in select statements\nDefault: False</li>\n<li><strong>max_text_width:</strong>  The max number of characters in a segment before creating new lines in pretty mode.\nThe default is on the smaller end because the length only represents a segment and not the true\nline length.\nDefault: 80</li>\n<li><strong>comments:</strong>  Whether or not to preserve comments in the output SQL code.\nDefault: True</li>\n</ul>\n", "bases": "sqlglot.dialects.spark2.Spark2.Generator"}, "sqlglot.dialects.spark.Spark.Generator.datediff_sql": {"fullname": "sqlglot.dialects.spark.Spark.Generator.datediff_sql", "modulename": "sqlglot.dialects.spark", "qualname": "Spark.Generator.datediff_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">DateDiff</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.spark2": {"fullname": "sqlglot.dialects.spark2", "modulename": "sqlglot.dialects.spark2", "kind": "module", "doc": "<p></p>\n"}, "sqlglot.dialects.spark2.Spark2": {"fullname": "sqlglot.dialects.spark2.Spark2", "modulename": "sqlglot.dialects.spark2", "qualname": "Spark2", "kind": "class", "doc": "<p></p>\n", "bases": "sqlglot.dialects.hive.Hive"}, "sqlglot.dialects.spark2.Spark2.Parser": {"fullname": "sqlglot.dialects.spark2.Spark2.Parser", "modulename": "sqlglot.dialects.spark2", "qualname": "Spark2.Parser", "kind": "class", "doc": "<p>Parser consumes a list of tokens produced by the <code>sqlglot.tokens.Tokenizer</code> and produces\na parsed syntax tree.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>error_level:</strong>  the desired error level.\nDefault: ErrorLevel.IMMEDIATE</li>\n<li><strong>error_message_context:</strong>  determines the amount of context to capture from a\nquery string when displaying the error message (in number of characters).\nDefault: 50.</li>\n<li><strong>index_offset:</strong>  Index offset for arrays eg ARRAY[0] vs ARRAY[1] as the head of a list.\nDefault: 0</li>\n<li><strong>alias_post_tablesample:</strong>  If the table alias comes after tablesample.\nDefault: False</li>\n<li><strong>max_errors:</strong>  Maximum number of error messages to include in a raised ParseError.\nThis is only relevant if error_level is ErrorLevel.RAISE.\nDefault: 3</li>\n<li><strong>null_ordering:</strong>  Indicates the default null ordering method to use if not explicitly set.\nOptions are \"nulls_are_small\", \"nulls_are_large\", \"nulls_are_last\".\nDefault: \"nulls_are_small\"</li>\n</ul>\n", "bases": "sqlglot.dialects.hive.Hive.Parser"}, "sqlglot.dialects.spark2.Spark2.Generator": {"fullname": "sqlglot.dialects.spark2.Spark2.Generator", "modulename": "sqlglot.dialects.spark2", "qualname": "Spark2.Generator", "kind": "class", "doc": "<p>Generator interprets the given syntax tree and produces a SQL string as an output.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>time_mapping (dict):</strong>  the dictionary of custom time mappings in which the key\nrepresents a python time format and the output the target time format</li>\n<li><strong>time_trie (trie):</strong>  a trie of the time_mapping keys</li>\n<li><strong>pretty (bool):</strong>  if set to True the returned string will be formatted. Default: False.</li>\n<li><strong>quote_start (str):</strong>  specifies which starting character to use to delimit quotes. Default: '.</li>\n<li><strong>quote_end (str):</strong>  specifies which ending character to use to delimit quotes. Default: '.</li>\n<li><strong>identifier_start (str):</strong>  specifies which starting character to use to delimit identifiers. Default: \".</li>\n<li><strong>identifier_end (str):</strong>  specifies which ending character to use to delimit identifiers. Default: \".</li>\n<li><strong>bit_start (str):</strong>  specifies which starting character to use to delimit bit literals. Default: None.</li>\n<li><strong>bit_end (str):</strong>  specifies which ending character to use to delimit bit literals. Default: None.</li>\n<li><strong>hex_start (str):</strong>  specifies which starting character to use to delimit hex literals. Default: None.</li>\n<li><strong>hex_end (str):</strong>  specifies which ending character to use to delimit hex literals. Default: None.</li>\n<li><strong>byte_start (str):</strong>  specifies which starting character to use to delimit byte literals. Default: None.</li>\n<li><strong>byte_end (str):</strong>  specifies which ending character to use to delimit byte literals. Default: None.</li>\n<li><strong>raw_start (str):</strong>  specifies which starting character to use to delimit raw literals. Default: None.</li>\n<li><strong>raw_end (str):</strong>  specifies which ending character to use to delimit raw literals. Default: None.</li>\n<li><strong>identify (bool | str):</strong>  'always': always quote, 'safe': quote identifiers if they don't contain an upcase, True defaults to always.</li>\n<li><strong>normalize (bool):</strong>  if set to True all identifiers will lower cased</li>\n<li><strong>string_escape (str):</strong>  specifies a string escape character. Default: '.</li>\n<li><strong>identifier_escape (str):</strong>  specifies an identifier escape character. Default: \".</li>\n<li><strong>pad (int):</strong>  determines padding in a formatted string. Default: 2.</li>\n<li><strong>indent (int):</strong>  determines the size of indentation in a formatted string. Default: 4.</li>\n<li><strong>unnest_column_only (bool):</strong>  if true unnest table aliases are considered only as column aliases</li>\n<li><strong>normalize_functions (str):</strong>  normalize function names, \"upper\", \"lower\", or None\nDefault: \"upper\"</li>\n<li><strong>alias_post_tablesample (bool):</strong>  if the table alias comes after tablesample\nDefault: False</li>\n<li><strong>identifiers_can_start_with_digit (bool):</strong>  if an unquoted identifier can start with digit\nDefault: False</li>\n<li><strong>unsupported_level (ErrorLevel):</strong>  determines the generator's behavior when it encounters\nunsupported expressions. Default ErrorLevel.WARN.</li>\n<li><strong>null_ordering (str):</strong>  Indicates the default null ordering method to use if not explicitly set.\nOptions are \"nulls_are_small\", \"nulls_are_large\", \"nulls_are_last\".\nDefault: \"nulls_are_small\"</li>\n<li><strong>max_unsupported (int):</strong>  Maximum number of unsupported messages to include in a raised UnsupportedError.\nThis is only relevant if unsupported_level is ErrorLevel.RAISE.\nDefault: 3</li>\n<li><strong>leading_comma (bool):</strong>  if the the comma is leading or trailing in select statements\nDefault: False</li>\n<li><strong>max_text_width:</strong>  The max number of characters in a segment before creating new lines in pretty mode.\nThe default is on the smaller end because the length only represents a segment and not the true\nline length.\nDefault: 80</li>\n<li><strong>comments:</strong>  Whether or not to preserve comments in the output SQL code.\nDefault: True</li>\n</ul>\n", "bases": "sqlglot.dialects.hive.Hive.Generator"}, "sqlglot.dialects.spark2.Spark2.Generator.cast_sql": {"fullname": "sqlglot.dialects.spark2.Spark2.Generator.cast_sql", "modulename": "sqlglot.dialects.spark2", "qualname": "Spark2.Generator.cast_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Cast</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.spark2.Spark2.Generator.columndef_sql": {"fullname": "sqlglot.dialects.spark2.Spark2.Generator.columndef_sql", "modulename": "sqlglot.dialects.spark2", "qualname": "Spark2.Generator.columndef_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">ColumnDef</span>, </span><span class=\"param\"><span class=\"n\">sep</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39; &#39;</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.spark2.Spark2.Tokenizer": {"fullname": "sqlglot.dialects.spark2.Spark2.Tokenizer", "modulename": "sqlglot.dialects.spark2", "qualname": "Spark2.Tokenizer", "kind": "class", "doc": "<p></p>\n", "bases": "sqlglot.dialects.hive.Hive.Tokenizer"}, "sqlglot.dialects.sqlite": {"fullname": "sqlglot.dialects.sqlite", "modulename": "sqlglot.dialects.sqlite", "kind": "module", "doc": "<p></p>\n"}, "sqlglot.dialects.sqlite.SQLite": {"fullname": "sqlglot.dialects.sqlite.SQLite", "modulename": "sqlglot.dialects.sqlite", "qualname": "SQLite", "kind": "class", "doc": "<p></p>\n", "bases": "sqlglot.dialects.dialect.Dialect"}, "sqlglot.dialects.sqlite.SQLite.Tokenizer": {"fullname": "sqlglot.dialects.sqlite.SQLite.Tokenizer", "modulename": "sqlglot.dialects.sqlite", "qualname": "SQLite.Tokenizer", "kind": "class", "doc": "<p></p>\n", "bases": "sqlglot.tokens.Tokenizer"}, "sqlglot.dialects.sqlite.SQLite.Parser": {"fullname": "sqlglot.dialects.sqlite.SQLite.Parser", "modulename": "sqlglot.dialects.sqlite", "qualname": "SQLite.Parser", "kind": "class", "doc": "<p>Parser consumes a list of tokens produced by the <code>sqlglot.tokens.Tokenizer</code> and produces\na parsed syntax tree.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>error_level:</strong>  the desired error level.\nDefault: ErrorLevel.IMMEDIATE</li>\n<li><strong>error_message_context:</strong>  determines the amount of context to capture from a\nquery string when displaying the error message (in number of characters).\nDefault: 50.</li>\n<li><strong>index_offset:</strong>  Index offset for arrays eg ARRAY[0] vs ARRAY[1] as the head of a list.\nDefault: 0</li>\n<li><strong>alias_post_tablesample:</strong>  If the table alias comes after tablesample.\nDefault: False</li>\n<li><strong>max_errors:</strong>  Maximum number of error messages to include in a raised ParseError.\nThis is only relevant if error_level is ErrorLevel.RAISE.\nDefault: 3</li>\n<li><strong>null_ordering:</strong>  Indicates the default null ordering method to use if not explicitly set.\nOptions are \"nulls_are_small\", \"nulls_are_large\", \"nulls_are_last\".\nDefault: \"nulls_are_small\"</li>\n</ul>\n", "bases": "sqlglot.parser.Parser"}, "sqlglot.dialects.sqlite.SQLite.Generator": {"fullname": "sqlglot.dialects.sqlite.SQLite.Generator", "modulename": "sqlglot.dialects.sqlite", "qualname": "SQLite.Generator", "kind": "class", "doc": "<p>Generator interprets the given syntax tree and produces a SQL string as an output.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>time_mapping (dict):</strong>  the dictionary of custom time mappings in which the key\nrepresents a python time format and the output the target time format</li>\n<li><strong>time_trie (trie):</strong>  a trie of the time_mapping keys</li>\n<li><strong>pretty (bool):</strong>  if set to True the returned string will be formatted. Default: False.</li>\n<li><strong>quote_start (str):</strong>  specifies which starting character to use to delimit quotes. Default: '.</li>\n<li><strong>quote_end (str):</strong>  specifies which ending character to use to delimit quotes. Default: '.</li>\n<li><strong>identifier_start (str):</strong>  specifies which starting character to use to delimit identifiers. Default: \".</li>\n<li><strong>identifier_end (str):</strong>  specifies which ending character to use to delimit identifiers. Default: \".</li>\n<li><strong>bit_start (str):</strong>  specifies which starting character to use to delimit bit literals. Default: None.</li>\n<li><strong>bit_end (str):</strong>  specifies which ending character to use to delimit bit literals. Default: None.</li>\n<li><strong>hex_start (str):</strong>  specifies which starting character to use to delimit hex literals. Default: None.</li>\n<li><strong>hex_end (str):</strong>  specifies which ending character to use to delimit hex literals. Default: None.</li>\n<li><strong>byte_start (str):</strong>  specifies which starting character to use to delimit byte literals. Default: None.</li>\n<li><strong>byte_end (str):</strong>  specifies which ending character to use to delimit byte literals. Default: None.</li>\n<li><strong>raw_start (str):</strong>  specifies which starting character to use to delimit raw literals. Default: None.</li>\n<li><strong>raw_end (str):</strong>  specifies which ending character to use to delimit raw literals. Default: None.</li>\n<li><strong>identify (bool | str):</strong>  'always': always quote, 'safe': quote identifiers if they don't contain an upcase, True defaults to always.</li>\n<li><strong>normalize (bool):</strong>  if set to True all identifiers will lower cased</li>\n<li><strong>string_escape (str):</strong>  specifies a string escape character. Default: '.</li>\n<li><strong>identifier_escape (str):</strong>  specifies an identifier escape character. Default: \".</li>\n<li><strong>pad (int):</strong>  determines padding in a formatted string. Default: 2.</li>\n<li><strong>indent (int):</strong>  determines the size of indentation in a formatted string. Default: 4.</li>\n<li><strong>unnest_column_only (bool):</strong>  if true unnest table aliases are considered only as column aliases</li>\n<li><strong>normalize_functions (str):</strong>  normalize function names, \"upper\", \"lower\", or None\nDefault: \"upper\"</li>\n<li><strong>alias_post_tablesample (bool):</strong>  if the table alias comes after tablesample\nDefault: False</li>\n<li><strong>identifiers_can_start_with_digit (bool):</strong>  if an unquoted identifier can start with digit\nDefault: False</li>\n<li><strong>unsupported_level (ErrorLevel):</strong>  determines the generator's behavior when it encounters\nunsupported expressions. Default ErrorLevel.WARN.</li>\n<li><strong>null_ordering (str):</strong>  Indicates the default null ordering method to use if not explicitly set.\nOptions are \"nulls_are_small\", \"nulls_are_large\", \"nulls_are_last\".\nDefault: \"nulls_are_small\"</li>\n<li><strong>max_unsupported (int):</strong>  Maximum number of unsupported messages to include in a raised UnsupportedError.\nThis is only relevant if unsupported_level is ErrorLevel.RAISE.\nDefault: 3</li>\n<li><strong>leading_comma (bool):</strong>  if the the comma is leading or trailing in select statements\nDefault: False</li>\n<li><strong>max_text_width:</strong>  The max number of characters in a segment before creating new lines in pretty mode.\nThe default is on the smaller end because the length only represents a segment and not the true\nline length.\nDefault: 80</li>\n<li><strong>comments:</strong>  Whether or not to preserve comments in the output SQL code.\nDefault: True</li>\n</ul>\n", "bases": "sqlglot.generator.Generator"}, "sqlglot.dialects.sqlite.SQLite.Generator.cast_sql": {"fullname": "sqlglot.dialects.sqlite.SQLite.Generator.cast_sql", "modulename": "sqlglot.dialects.sqlite", "qualname": "SQLite.Generator.cast_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Cast</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.sqlite.SQLite.Generator.datediff_sql": {"fullname": "sqlglot.dialects.sqlite.SQLite.Generator.datediff_sql", "modulename": "sqlglot.dialects.sqlite", "qualname": "SQLite.Generator.datediff_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">DateDiff</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.sqlite.SQLite.Generator.groupconcat_sql": {"fullname": "sqlglot.dialects.sqlite.SQLite.Generator.groupconcat_sql", "modulename": "sqlglot.dialects.sqlite", "qualname": "SQLite.Generator.groupconcat_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">GroupConcat</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.sqlite.SQLite.Generator.least_sql": {"fullname": "sqlglot.dialects.sqlite.SQLite.Generator.least_sql", "modulename": "sqlglot.dialects.sqlite", "qualname": "SQLite.Generator.least_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Least</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.sqlite.SQLite.Generator.transaction_sql": {"fullname": "sqlglot.dialects.sqlite.SQLite.Generator.transaction_sql", "modulename": "sqlglot.dialects.sqlite", "qualname": "SQLite.Generator.transaction_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Transaction</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.starrocks": {"fullname": "sqlglot.dialects.starrocks", "modulename": "sqlglot.dialects.starrocks", "kind": "module", "doc": "<p></p>\n"}, "sqlglot.dialects.starrocks.StarRocks": {"fullname": "sqlglot.dialects.starrocks.StarRocks", "modulename": "sqlglot.dialects.starrocks", "qualname": "StarRocks", "kind": "class", "doc": "<p></p>\n", "bases": "sqlglot.dialects.mysql.MySQL"}, "sqlglot.dialects.starrocks.StarRocks.Parser": {"fullname": "sqlglot.dialects.starrocks.StarRocks.Parser", "modulename": "sqlglot.dialects.starrocks", "qualname": "StarRocks.Parser", "kind": "class", "doc": "<p>Parser consumes a list of tokens produced by the <code>sqlglot.tokens.Tokenizer</code> and produces\na parsed syntax tree.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>error_level:</strong>  the desired error level.\nDefault: ErrorLevel.IMMEDIATE</li>\n<li><strong>error_message_context:</strong>  determines the amount of context to capture from a\nquery string when displaying the error message (in number of characters).\nDefault: 50.</li>\n<li><strong>index_offset:</strong>  Index offset for arrays eg ARRAY[0] vs ARRAY[1] as the head of a list.\nDefault: 0</li>\n<li><strong>alias_post_tablesample:</strong>  If the table alias comes after tablesample.\nDefault: False</li>\n<li><strong>max_errors:</strong>  Maximum number of error messages to include in a raised ParseError.\nThis is only relevant if error_level is ErrorLevel.RAISE.\nDefault: 3</li>\n<li><strong>null_ordering:</strong>  Indicates the default null ordering method to use if not explicitly set.\nOptions are \"nulls_are_small\", \"nulls_are_large\", \"nulls_are_last\".\nDefault: \"nulls_are_small\"</li>\n</ul>\n", "bases": "sqlglot.dialects.mysql.MySQL.Parser"}, "sqlglot.dialects.starrocks.StarRocks.Generator": {"fullname": "sqlglot.dialects.starrocks.StarRocks.Generator", "modulename": "sqlglot.dialects.starrocks", "qualname": "StarRocks.Generator", "kind": "class", "doc": "<p>Generator interprets the given syntax tree and produces a SQL string as an output.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>time_mapping (dict):</strong>  the dictionary of custom time mappings in which the key\nrepresents a python time format and the output the target time format</li>\n<li><strong>time_trie (trie):</strong>  a trie of the time_mapping keys</li>\n<li><strong>pretty (bool):</strong>  if set to True the returned string will be formatted. Default: False.</li>\n<li><strong>quote_start (str):</strong>  specifies which starting character to use to delimit quotes. Default: '.</li>\n<li><strong>quote_end (str):</strong>  specifies which ending character to use to delimit quotes. Default: '.</li>\n<li><strong>identifier_start (str):</strong>  specifies which starting character to use to delimit identifiers. Default: \".</li>\n<li><strong>identifier_end (str):</strong>  specifies which ending character to use to delimit identifiers. Default: \".</li>\n<li><strong>bit_start (str):</strong>  specifies which starting character to use to delimit bit literals. Default: None.</li>\n<li><strong>bit_end (str):</strong>  specifies which ending character to use to delimit bit literals. Default: None.</li>\n<li><strong>hex_start (str):</strong>  specifies which starting character to use to delimit hex literals. Default: None.</li>\n<li><strong>hex_end (str):</strong>  specifies which ending character to use to delimit hex literals. Default: None.</li>\n<li><strong>byte_start (str):</strong>  specifies which starting character to use to delimit byte literals. Default: None.</li>\n<li><strong>byte_end (str):</strong>  specifies which ending character to use to delimit byte literals. Default: None.</li>\n<li><strong>raw_start (str):</strong>  specifies which starting character to use to delimit raw literals. Default: None.</li>\n<li><strong>raw_end (str):</strong>  specifies which ending character to use to delimit raw literals. Default: None.</li>\n<li><strong>identify (bool | str):</strong>  'always': always quote, 'safe': quote identifiers if they don't contain an upcase, True defaults to always.</li>\n<li><strong>normalize (bool):</strong>  if set to True all identifiers will lower cased</li>\n<li><strong>string_escape (str):</strong>  specifies a string escape character. Default: '.</li>\n<li><strong>identifier_escape (str):</strong>  specifies an identifier escape character. Default: \".</li>\n<li><strong>pad (int):</strong>  determines padding in a formatted string. Default: 2.</li>\n<li><strong>indent (int):</strong>  determines the size of indentation in a formatted string. Default: 4.</li>\n<li><strong>unnest_column_only (bool):</strong>  if true unnest table aliases are considered only as column aliases</li>\n<li><strong>normalize_functions (str):</strong>  normalize function names, \"upper\", \"lower\", or None\nDefault: \"upper\"</li>\n<li><strong>alias_post_tablesample (bool):</strong>  if the table alias comes after tablesample\nDefault: False</li>\n<li><strong>identifiers_can_start_with_digit (bool):</strong>  if an unquoted identifier can start with digit\nDefault: False</li>\n<li><strong>unsupported_level (ErrorLevel):</strong>  determines the generator's behavior when it encounters\nunsupported expressions. Default ErrorLevel.WARN.</li>\n<li><strong>null_ordering (str):</strong>  Indicates the default null ordering method to use if not explicitly set.\nOptions are \"nulls_are_small\", \"nulls_are_large\", \"nulls_are_last\".\nDefault: \"nulls_are_small\"</li>\n<li><strong>max_unsupported (int):</strong>  Maximum number of unsupported messages to include in a raised UnsupportedError.\nThis is only relevant if unsupported_level is ErrorLevel.RAISE.\nDefault: 3</li>\n<li><strong>leading_comma (bool):</strong>  if the the comma is leading or trailing in select statements\nDefault: False</li>\n<li><strong>max_text_width:</strong>  The max number of characters in a segment before creating new lines in pretty mode.\nThe default is on the smaller end because the length only represents a segment and not the true\nline length.\nDefault: 80</li>\n<li><strong>comments:</strong>  Whether or not to preserve comments in the output SQL code.\nDefault: True</li>\n</ul>\n", "bases": "sqlglot.dialects.mysql.MySQL.Generator"}, "sqlglot.dialects.tableau": {"fullname": "sqlglot.dialects.tableau", "modulename": "sqlglot.dialects.tableau", "kind": "module", "doc": "<p></p>\n"}, "sqlglot.dialects.tableau.Tableau": {"fullname": "sqlglot.dialects.tableau.Tableau", "modulename": "sqlglot.dialects.tableau", "qualname": "Tableau", "kind": "class", "doc": "<p></p>\n", "bases": "sqlglot.dialects.dialect.Dialect"}, "sqlglot.dialects.tableau.Tableau.Generator": {"fullname": "sqlglot.dialects.tableau.Tableau.Generator", "modulename": "sqlglot.dialects.tableau", "qualname": "Tableau.Generator", "kind": "class", "doc": "<p>Generator interprets the given syntax tree and produces a SQL string as an output.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>time_mapping (dict):</strong>  the dictionary of custom time mappings in which the key\nrepresents a python time format and the output the target time format</li>\n<li><strong>time_trie (trie):</strong>  a trie of the time_mapping keys</li>\n<li><strong>pretty (bool):</strong>  if set to True the returned string will be formatted. Default: False.</li>\n<li><strong>quote_start (str):</strong>  specifies which starting character to use to delimit quotes. Default: '.</li>\n<li><strong>quote_end (str):</strong>  specifies which ending character to use to delimit quotes. Default: '.</li>\n<li><strong>identifier_start (str):</strong>  specifies which starting character to use to delimit identifiers. Default: \".</li>\n<li><strong>identifier_end (str):</strong>  specifies which ending character to use to delimit identifiers. Default: \".</li>\n<li><strong>bit_start (str):</strong>  specifies which starting character to use to delimit bit literals. Default: None.</li>\n<li><strong>bit_end (str):</strong>  specifies which ending character to use to delimit bit literals. Default: None.</li>\n<li><strong>hex_start (str):</strong>  specifies which starting character to use to delimit hex literals. Default: None.</li>\n<li><strong>hex_end (str):</strong>  specifies which ending character to use to delimit hex literals. Default: None.</li>\n<li><strong>byte_start (str):</strong>  specifies which starting character to use to delimit byte literals. Default: None.</li>\n<li><strong>byte_end (str):</strong>  specifies which ending character to use to delimit byte literals. Default: None.</li>\n<li><strong>raw_start (str):</strong>  specifies which starting character to use to delimit raw literals. Default: None.</li>\n<li><strong>raw_end (str):</strong>  specifies which ending character to use to delimit raw literals. Default: None.</li>\n<li><strong>identify (bool | str):</strong>  'always': always quote, 'safe': quote identifiers if they don't contain an upcase, True defaults to always.</li>\n<li><strong>normalize (bool):</strong>  if set to True all identifiers will lower cased</li>\n<li><strong>string_escape (str):</strong>  specifies a string escape character. Default: '.</li>\n<li><strong>identifier_escape (str):</strong>  specifies an identifier escape character. Default: \".</li>\n<li><strong>pad (int):</strong>  determines padding in a formatted string. Default: 2.</li>\n<li><strong>indent (int):</strong>  determines the size of indentation in a formatted string. Default: 4.</li>\n<li><strong>unnest_column_only (bool):</strong>  if true unnest table aliases are considered only as column aliases</li>\n<li><strong>normalize_functions (str):</strong>  normalize function names, \"upper\", \"lower\", or None\nDefault: \"upper\"</li>\n<li><strong>alias_post_tablesample (bool):</strong>  if the table alias comes after tablesample\nDefault: False</li>\n<li><strong>identifiers_can_start_with_digit (bool):</strong>  if an unquoted identifier can start with digit\nDefault: False</li>\n<li><strong>unsupported_level (ErrorLevel):</strong>  determines the generator's behavior when it encounters\nunsupported expressions. Default ErrorLevel.WARN.</li>\n<li><strong>null_ordering (str):</strong>  Indicates the default null ordering method to use if not explicitly set.\nOptions are \"nulls_are_small\", \"nulls_are_large\", \"nulls_are_last\".\nDefault: \"nulls_are_small\"</li>\n<li><strong>max_unsupported (int):</strong>  Maximum number of unsupported messages to include in a raised UnsupportedError.\nThis is only relevant if unsupported_level is ErrorLevel.RAISE.\nDefault: 3</li>\n<li><strong>leading_comma (bool):</strong>  if the the comma is leading or trailing in select statements\nDefault: False</li>\n<li><strong>max_text_width:</strong>  The max number of characters in a segment before creating new lines in pretty mode.\nThe default is on the smaller end because the length only represents a segment and not the true\nline length.\nDefault: 80</li>\n<li><strong>comments:</strong>  Whether or not to preserve comments in the output SQL code.\nDefault: True</li>\n</ul>\n", "bases": "sqlglot.generator.Generator"}, "sqlglot.dialects.tableau.Tableau.Generator.if_sql": {"fullname": "sqlglot.dialects.tableau.Tableau.Generator.if_sql", "modulename": "sqlglot.dialects.tableau", "qualname": "Tableau.Generator.if_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">If</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.tableau.Tableau.Generator.coalesce_sql": {"fullname": "sqlglot.dialects.tableau.Tableau.Generator.coalesce_sql", "modulename": "sqlglot.dialects.tableau", "qualname": "Tableau.Generator.coalesce_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Coalesce</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.tableau.Tableau.Generator.count_sql": {"fullname": "sqlglot.dialects.tableau.Tableau.Generator.count_sql", "modulename": "sqlglot.dialects.tableau", "qualname": "Tableau.Generator.count_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Count</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.tableau.Tableau.Parser": {"fullname": "sqlglot.dialects.tableau.Tableau.Parser", "modulename": "sqlglot.dialects.tableau", "qualname": "Tableau.Parser", "kind": "class", "doc": "<p>Parser consumes a list of tokens produced by the <code>sqlglot.tokens.Tokenizer</code> and produces\na parsed syntax tree.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>error_level:</strong>  the desired error level.\nDefault: ErrorLevel.IMMEDIATE</li>\n<li><strong>error_message_context:</strong>  determines the amount of context to capture from a\nquery string when displaying the error message (in number of characters).\nDefault: 50.</li>\n<li><strong>index_offset:</strong>  Index offset for arrays eg ARRAY[0] vs ARRAY[1] as the head of a list.\nDefault: 0</li>\n<li><strong>alias_post_tablesample:</strong>  If the table alias comes after tablesample.\nDefault: False</li>\n<li><strong>max_errors:</strong>  Maximum number of error messages to include in a raised ParseError.\nThis is only relevant if error_level is ErrorLevel.RAISE.\nDefault: 3</li>\n<li><strong>null_ordering:</strong>  Indicates the default null ordering method to use if not explicitly set.\nOptions are \"nulls_are_small\", \"nulls_are_large\", \"nulls_are_last\".\nDefault: \"nulls_are_small\"</li>\n</ul>\n", "bases": "sqlglot.parser.Parser"}, "sqlglot.dialects.teradata": {"fullname": "sqlglot.dialects.teradata", "modulename": "sqlglot.dialects.teradata", "kind": "module", "doc": "<p></p>\n"}, "sqlglot.dialects.teradata.Teradata": {"fullname": "sqlglot.dialects.teradata.Teradata", "modulename": "sqlglot.dialects.teradata", "qualname": "Teradata", "kind": "class", "doc": "<p></p>\n", "bases": "sqlglot.dialects.dialect.Dialect"}, "sqlglot.dialects.teradata.Teradata.Tokenizer": {"fullname": "sqlglot.dialects.teradata.Teradata.Tokenizer", "modulename": "sqlglot.dialects.teradata", "qualname": "Teradata.Tokenizer", "kind": "class", "doc": "<p></p>\n", "bases": "sqlglot.tokens.Tokenizer"}, "sqlglot.dialects.teradata.Teradata.Parser": {"fullname": "sqlglot.dialects.teradata.Teradata.Parser", "modulename": "sqlglot.dialects.teradata", "qualname": "Teradata.Parser", "kind": "class", "doc": "<p>Parser consumes a list of tokens produced by the <code>sqlglot.tokens.Tokenizer</code> and produces\na parsed syntax tree.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>error_level:</strong>  the desired error level.\nDefault: ErrorLevel.IMMEDIATE</li>\n<li><strong>error_message_context:</strong>  determines the amount of context to capture from a\nquery string when displaying the error message (in number of characters).\nDefault: 50.</li>\n<li><strong>index_offset:</strong>  Index offset for arrays eg ARRAY[0] vs ARRAY[1] as the head of a list.\nDefault: 0</li>\n<li><strong>alias_post_tablesample:</strong>  If the table alias comes after tablesample.\nDefault: False</li>\n<li><strong>max_errors:</strong>  Maximum number of error messages to include in a raised ParseError.\nThis is only relevant if error_level is ErrorLevel.RAISE.\nDefault: 3</li>\n<li><strong>null_ordering:</strong>  Indicates the default null ordering method to use if not explicitly set.\nOptions are \"nulls_are_small\", \"nulls_are_large\", \"nulls_are_last\".\nDefault: \"nulls_are_small\"</li>\n</ul>\n", "bases": "sqlglot.parser.Parser"}, "sqlglot.dialects.teradata.Teradata.Generator": {"fullname": "sqlglot.dialects.teradata.Teradata.Generator", "modulename": "sqlglot.dialects.teradata", "qualname": "Teradata.Generator", "kind": "class", "doc": "<p>Generator interprets the given syntax tree and produces a SQL string as an output.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>time_mapping (dict):</strong>  the dictionary of custom time mappings in which the key\nrepresents a python time format and the output the target time format</li>\n<li><strong>time_trie (trie):</strong>  a trie of the time_mapping keys</li>\n<li><strong>pretty (bool):</strong>  if set to True the returned string will be formatted. Default: False.</li>\n<li><strong>quote_start (str):</strong>  specifies which starting character to use to delimit quotes. Default: '.</li>\n<li><strong>quote_end (str):</strong>  specifies which ending character to use to delimit quotes. Default: '.</li>\n<li><strong>identifier_start (str):</strong>  specifies which starting character to use to delimit identifiers. Default: \".</li>\n<li><strong>identifier_end (str):</strong>  specifies which ending character to use to delimit identifiers. Default: \".</li>\n<li><strong>bit_start (str):</strong>  specifies which starting character to use to delimit bit literals. Default: None.</li>\n<li><strong>bit_end (str):</strong>  specifies which ending character to use to delimit bit literals. Default: None.</li>\n<li><strong>hex_start (str):</strong>  specifies which starting character to use to delimit hex literals. Default: None.</li>\n<li><strong>hex_end (str):</strong>  specifies which ending character to use to delimit hex literals. Default: None.</li>\n<li><strong>byte_start (str):</strong>  specifies which starting character to use to delimit byte literals. Default: None.</li>\n<li><strong>byte_end (str):</strong>  specifies which ending character to use to delimit byte literals. Default: None.</li>\n<li><strong>raw_start (str):</strong>  specifies which starting character to use to delimit raw literals. Default: None.</li>\n<li><strong>raw_end (str):</strong>  specifies which ending character to use to delimit raw literals. Default: None.</li>\n<li><strong>identify (bool | str):</strong>  'always': always quote, 'safe': quote identifiers if they don't contain an upcase, True defaults to always.</li>\n<li><strong>normalize (bool):</strong>  if set to True all identifiers will lower cased</li>\n<li><strong>string_escape (str):</strong>  specifies a string escape character. Default: '.</li>\n<li><strong>identifier_escape (str):</strong>  specifies an identifier escape character. Default: \".</li>\n<li><strong>pad (int):</strong>  determines padding in a formatted string. Default: 2.</li>\n<li><strong>indent (int):</strong>  determines the size of indentation in a formatted string. Default: 4.</li>\n<li><strong>unnest_column_only (bool):</strong>  if true unnest table aliases are considered only as column aliases</li>\n<li><strong>normalize_functions (str):</strong>  normalize function names, \"upper\", \"lower\", or None\nDefault: \"upper\"</li>\n<li><strong>alias_post_tablesample (bool):</strong>  if the table alias comes after tablesample\nDefault: False</li>\n<li><strong>identifiers_can_start_with_digit (bool):</strong>  if an unquoted identifier can start with digit\nDefault: False</li>\n<li><strong>unsupported_level (ErrorLevel):</strong>  determines the generator's behavior when it encounters\nunsupported expressions. Default ErrorLevel.WARN.</li>\n<li><strong>null_ordering (str):</strong>  Indicates the default null ordering method to use if not explicitly set.\nOptions are \"nulls_are_small\", \"nulls_are_large\", \"nulls_are_last\".\nDefault: \"nulls_are_small\"</li>\n<li><strong>max_unsupported (int):</strong>  Maximum number of unsupported messages to include in a raised UnsupportedError.\nThis is only relevant if unsupported_level is ErrorLevel.RAISE.\nDefault: 3</li>\n<li><strong>leading_comma (bool):</strong>  if the the comma is leading or trailing in select statements\nDefault: False</li>\n<li><strong>max_text_width:</strong>  The max number of characters in a segment before creating new lines in pretty mode.\nThe default is on the smaller end because the length only represents a segment and not the true\nline length.\nDefault: 80</li>\n<li><strong>comments:</strong>  Whether or not to preserve comments in the output SQL code.\nDefault: True</li>\n</ul>\n", "bases": "sqlglot.generator.Generator"}, "sqlglot.dialects.teradata.Teradata.Generator.partitionedbyproperty_sql": {"fullname": "sqlglot.dialects.teradata.Teradata.Generator.partitionedbyproperty_sql", "modulename": "sqlglot.dialects.teradata", "qualname": "Teradata.Generator.partitionedbyproperty_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">PartitionedByProperty</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.teradata.Teradata.Generator.update_sql": {"fullname": "sqlglot.dialects.teradata.Teradata.Generator.update_sql", "modulename": "sqlglot.dialects.teradata", "qualname": "Teradata.Generator.update_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Update</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.teradata.Teradata.Generator.mod_sql": {"fullname": "sqlglot.dialects.teradata.Teradata.Generator.mod_sql", "modulename": "sqlglot.dialects.teradata", "qualname": "Teradata.Generator.mod_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Mod</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.teradata.Teradata.Generator.datatype_sql": {"fullname": "sqlglot.dialects.teradata.Teradata.Generator.datatype_sql", "modulename": "sqlglot.dialects.teradata", "qualname": "Teradata.Generator.datatype_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">DataType</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.teradata.Teradata.Generator.rangen_sql": {"fullname": "sqlglot.dialects.teradata.Teradata.Generator.rangen_sql", "modulename": "sqlglot.dialects.teradata", "qualname": "Teradata.Generator.rangen_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">RangeN</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.trino": {"fullname": "sqlglot.dialects.trino", "modulename": "sqlglot.dialects.trino", "kind": "module", "doc": "<p></p>\n"}, "sqlglot.dialects.trino.Trino": {"fullname": "sqlglot.dialects.trino.Trino", "modulename": "sqlglot.dialects.trino", "qualname": "Trino", "kind": "class", "doc": "<p></p>\n", "bases": "sqlglot.dialects.presto.Presto"}, "sqlglot.dialects.trino.Trino.Generator": {"fullname": "sqlglot.dialects.trino.Trino.Generator", "modulename": "sqlglot.dialects.trino", "qualname": "Trino.Generator", "kind": "class", "doc": "<p>Generator interprets the given syntax tree and produces a SQL string as an output.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>time_mapping (dict):</strong>  the dictionary of custom time mappings in which the key\nrepresents a python time format and the output the target time format</li>\n<li><strong>time_trie (trie):</strong>  a trie of the time_mapping keys</li>\n<li><strong>pretty (bool):</strong>  if set to True the returned string will be formatted. Default: False.</li>\n<li><strong>quote_start (str):</strong>  specifies which starting character to use to delimit quotes. Default: '.</li>\n<li><strong>quote_end (str):</strong>  specifies which ending character to use to delimit quotes. Default: '.</li>\n<li><strong>identifier_start (str):</strong>  specifies which starting character to use to delimit identifiers. Default: \".</li>\n<li><strong>identifier_end (str):</strong>  specifies which ending character to use to delimit identifiers. Default: \".</li>\n<li><strong>bit_start (str):</strong>  specifies which starting character to use to delimit bit literals. Default: None.</li>\n<li><strong>bit_end (str):</strong>  specifies which ending character to use to delimit bit literals. Default: None.</li>\n<li><strong>hex_start (str):</strong>  specifies which starting character to use to delimit hex literals. Default: None.</li>\n<li><strong>hex_end (str):</strong>  specifies which ending character to use to delimit hex literals. Default: None.</li>\n<li><strong>byte_start (str):</strong>  specifies which starting character to use to delimit byte literals. Default: None.</li>\n<li><strong>byte_end (str):</strong>  specifies which ending character to use to delimit byte literals. Default: None.</li>\n<li><strong>raw_start (str):</strong>  specifies which starting character to use to delimit raw literals. Default: None.</li>\n<li><strong>raw_end (str):</strong>  specifies which ending character to use to delimit raw literals. Default: None.</li>\n<li><strong>identify (bool | str):</strong>  'always': always quote, 'safe': quote identifiers if they don't contain an upcase, True defaults to always.</li>\n<li><strong>normalize (bool):</strong>  if set to True all identifiers will lower cased</li>\n<li><strong>string_escape (str):</strong>  specifies a string escape character. Default: '.</li>\n<li><strong>identifier_escape (str):</strong>  specifies an identifier escape character. Default: \".</li>\n<li><strong>pad (int):</strong>  determines padding in a formatted string. Default: 2.</li>\n<li><strong>indent (int):</strong>  determines the size of indentation in a formatted string. Default: 4.</li>\n<li><strong>unnest_column_only (bool):</strong>  if true unnest table aliases are considered only as column aliases</li>\n<li><strong>normalize_functions (str):</strong>  normalize function names, \"upper\", \"lower\", or None\nDefault: \"upper\"</li>\n<li><strong>alias_post_tablesample (bool):</strong>  if the table alias comes after tablesample\nDefault: False</li>\n<li><strong>identifiers_can_start_with_digit (bool):</strong>  if an unquoted identifier can start with digit\nDefault: False</li>\n<li><strong>unsupported_level (ErrorLevel):</strong>  determines the generator's behavior when it encounters\nunsupported expressions. Default ErrorLevel.WARN.</li>\n<li><strong>null_ordering (str):</strong>  Indicates the default null ordering method to use if not explicitly set.\nOptions are \"nulls_are_small\", \"nulls_are_large\", \"nulls_are_last\".\nDefault: \"nulls_are_small\"</li>\n<li><strong>max_unsupported (int):</strong>  Maximum number of unsupported messages to include in a raised UnsupportedError.\nThis is only relevant if unsupported_level is ErrorLevel.RAISE.\nDefault: 3</li>\n<li><strong>leading_comma (bool):</strong>  if the the comma is leading or trailing in select statements\nDefault: False</li>\n<li><strong>max_text_width:</strong>  The max number of characters in a segment before creating new lines in pretty mode.\nThe default is on the smaller end because the length only represents a segment and not the true\nline length.\nDefault: 80</li>\n<li><strong>comments:</strong>  Whether or not to preserve comments in the output SQL code.\nDefault: True</li>\n</ul>\n", "bases": "sqlglot.dialects.presto.Presto.Generator"}, "sqlglot.dialects.trino.Trino.Tokenizer": {"fullname": "sqlglot.dialects.trino.Trino.Tokenizer", "modulename": "sqlglot.dialects.trino", "qualname": "Trino.Tokenizer", "kind": "class", "doc": "<p></p>\n", "bases": "sqlglot.dialects.presto.Presto.Tokenizer"}, "sqlglot.dialects.tsql": {"fullname": "sqlglot.dialects.tsql", "modulename": "sqlglot.dialects.tsql", "kind": "module", "doc": "<p></p>\n"}, "sqlglot.dialects.tsql.generate_date_delta_with_unit_sql": {"fullname": "sqlglot.dialects.tsql.generate_date_delta_with_unit_sql", "modulename": "sqlglot.dialects.tsql", "qualname": "generate_date_delta_with_unit_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">generator</span><span class=\"o\">.</span><span class=\"n\">Generator</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">DateAdd</span> <span class=\"o\">|</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">DateDiff</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.tsql.TSQL": {"fullname": "sqlglot.dialects.tsql.TSQL", "modulename": "sqlglot.dialects.tsql", "qualname": "TSQL", "kind": "class", "doc": "<p></p>\n", "bases": "sqlglot.dialects.dialect.Dialect"}, "sqlglot.dialects.tsql.TSQL.Tokenizer": {"fullname": "sqlglot.dialects.tsql.TSQL.Tokenizer", "modulename": "sqlglot.dialects.tsql", "qualname": "TSQL.Tokenizer", "kind": "class", "doc": "<p></p>\n", "bases": "sqlglot.tokens.Tokenizer"}, "sqlglot.dialects.tsql.TSQL.Parser": {"fullname": "sqlglot.dialects.tsql.TSQL.Parser", "modulename": "sqlglot.dialects.tsql", "qualname": "TSQL.Parser", "kind": "class", "doc": "<p>Parser consumes a list of tokens produced by the <code>sqlglot.tokens.Tokenizer</code> and produces\na parsed syntax tree.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>error_level:</strong>  the desired error level.\nDefault: ErrorLevel.IMMEDIATE</li>\n<li><strong>error_message_context:</strong>  determines the amount of context to capture from a\nquery string when displaying the error message (in number of characters).\nDefault: 50.</li>\n<li><strong>index_offset:</strong>  Index offset for arrays eg ARRAY[0] vs ARRAY[1] as the head of a list.\nDefault: 0</li>\n<li><strong>alias_post_tablesample:</strong>  If the table alias comes after tablesample.\nDefault: False</li>\n<li><strong>max_errors:</strong>  Maximum number of error messages to include in a raised ParseError.\nThis is only relevant if error_level is ErrorLevel.RAISE.\nDefault: 3</li>\n<li><strong>null_ordering:</strong>  Indicates the default null ordering method to use if not explicitly set.\nOptions are \"nulls_are_small\", \"nulls_are_large\", \"nulls_are_last\".\nDefault: \"nulls_are_small\"</li>\n</ul>\n", "bases": "sqlglot.parser.Parser"}, "sqlglot.dialects.tsql.TSQL.Generator": {"fullname": "sqlglot.dialects.tsql.TSQL.Generator", "modulename": "sqlglot.dialects.tsql", "qualname": "TSQL.Generator", "kind": "class", "doc": "<p>Generator interprets the given syntax tree and produces a SQL string as an output.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>time_mapping (dict):</strong>  the dictionary of custom time mappings in which the key\nrepresents a python time format and the output the target time format</li>\n<li><strong>time_trie (trie):</strong>  a trie of the time_mapping keys</li>\n<li><strong>pretty (bool):</strong>  if set to True the returned string will be formatted. Default: False.</li>\n<li><strong>quote_start (str):</strong>  specifies which starting character to use to delimit quotes. Default: '.</li>\n<li><strong>quote_end (str):</strong>  specifies which ending character to use to delimit quotes. Default: '.</li>\n<li><strong>identifier_start (str):</strong>  specifies which starting character to use to delimit identifiers. Default: \".</li>\n<li><strong>identifier_end (str):</strong>  specifies which ending character to use to delimit identifiers. Default: \".</li>\n<li><strong>bit_start (str):</strong>  specifies which starting character to use to delimit bit literals. Default: None.</li>\n<li><strong>bit_end (str):</strong>  specifies which ending character to use to delimit bit literals. Default: None.</li>\n<li><strong>hex_start (str):</strong>  specifies which starting character to use to delimit hex literals. Default: None.</li>\n<li><strong>hex_end (str):</strong>  specifies which ending character to use to delimit hex literals. Default: None.</li>\n<li><strong>byte_start (str):</strong>  specifies which starting character to use to delimit byte literals. Default: None.</li>\n<li><strong>byte_end (str):</strong>  specifies which ending character to use to delimit byte literals. Default: None.</li>\n<li><strong>raw_start (str):</strong>  specifies which starting character to use to delimit raw literals. Default: None.</li>\n<li><strong>raw_end (str):</strong>  specifies which ending character to use to delimit raw literals. Default: None.</li>\n<li><strong>identify (bool | str):</strong>  'always': always quote, 'safe': quote identifiers if they don't contain an upcase, True defaults to always.</li>\n<li><strong>normalize (bool):</strong>  if set to True all identifiers will lower cased</li>\n<li><strong>string_escape (str):</strong>  specifies a string escape character. Default: '.</li>\n<li><strong>identifier_escape (str):</strong>  specifies an identifier escape character. Default: \".</li>\n<li><strong>pad (int):</strong>  determines padding in a formatted string. Default: 2.</li>\n<li><strong>indent (int):</strong>  determines the size of indentation in a formatted string. Default: 4.</li>\n<li><strong>unnest_column_only (bool):</strong>  if true unnest table aliases are considered only as column aliases</li>\n<li><strong>normalize_functions (str):</strong>  normalize function names, \"upper\", \"lower\", or None\nDefault: \"upper\"</li>\n<li><strong>alias_post_tablesample (bool):</strong>  if the table alias comes after tablesample\nDefault: False</li>\n<li><strong>identifiers_can_start_with_digit (bool):</strong>  if an unquoted identifier can start with digit\nDefault: False</li>\n<li><strong>unsupported_level (ErrorLevel):</strong>  determines the generator's behavior when it encounters\nunsupported expressions. Default ErrorLevel.WARN.</li>\n<li><strong>null_ordering (str):</strong>  Indicates the default null ordering method to use if not explicitly set.\nOptions are \"nulls_are_small\", \"nulls_are_large\", \"nulls_are_last\".\nDefault: \"nulls_are_small\"</li>\n<li><strong>max_unsupported (int):</strong>  Maximum number of unsupported messages to include in a raised UnsupportedError.\nThis is only relevant if unsupported_level is ErrorLevel.RAISE.\nDefault: 3</li>\n<li><strong>leading_comma (bool):</strong>  if the the comma is leading or trailing in select statements\nDefault: False</li>\n<li><strong>max_text_width:</strong>  The max number of characters in a segment before creating new lines in pretty mode.\nThe default is on the smaller end because the length only represents a segment and not the true\nline length.\nDefault: 80</li>\n<li><strong>comments:</strong>  Whether or not to preserve comments in the output SQL code.\nDefault: True</li>\n</ul>\n", "bases": "sqlglot.generator.Generator"}, "sqlglot.dialects.tsql.TSQL.Generator.offset_sql": {"fullname": "sqlglot.dialects.tsql.TSQL.Generator.offset_sql", "modulename": "sqlglot.dialects.tsql", "qualname": "TSQL.Generator.offset_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Offset</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.tsql.TSQL.Generator.systemtime_sql": {"fullname": "sqlglot.dialects.tsql.TSQL.Generator.systemtime_sql", "modulename": "sqlglot.dialects.tsql", "qualname": "TSQL.Generator.systemtime_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">SystemTime</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.dialects.tsql.TSQL.Generator.returnsproperty_sql": {"fullname": "sqlglot.dialects.tsql.TSQL.Generator.returnsproperty_sql", "modulename": "sqlglot.dialects.tsql", "qualname": "TSQL.Generator.returnsproperty_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">ReturnsProperty</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.diff": {"fullname": "sqlglot.diff", "modulename": "sqlglot.diff", "kind": "module", "doc": "<h1 id=\"semantic-diff-for-sql\">Semantic Diff for SQL</h1>\n\n<p><em>by <a href=\"https://github.com/izeigerman\">Iaroslav Zeigerman</a></em></p>\n\n<h2 id=\"motivation\">Motivation</h2>\n\n<p>Software is constantly changing and evolving, and identifying what has changed and reviewing those changes is an integral part of the development process. SQL code is no exception to this.</p>\n\n<p>Text-based diff tools such as <code>git diff</code>, when applied to a code base, have certain limitations. First, they can only detect insertions and deletions, not movements or updates of individual pieces of code. Second, such tools can only detect changes between lines of text, which is too coarse for something as granular and detailed as source code. Additionally, the outcome of such a diff is dependent on the underlying code formatting, and yields different results if the formatting should change.</p>\n\n<p>Consider the following diff generated by Git:</p>\n\n<p><img src=\"sql_diff_images/git_diff_output.png\" alt=\"Git diff output\" /></p>\n\n<p>Semantically the query hasn\u2019t changed. The two arguments <code>b</code> and <code>c</code> have been swapped (moved), posing no impact on the output of the query. Yet Git replaced the whole affected expression alongside a bulk of unrelated elements.</p>\n\n<p>The alternative to text-based diffing is to compare Abstract Syntax Trees (AST) instead. The main advantage of ASTs are that they are a direct product of code parsing, which represents the underlying code structure at any desired level of granularity. Comparing ASTs may yield extremely precise diffs; changes such as code movements and updates can also be detected. Even more importantly, this approach facilitates additional use cases beyond eyeballing two versions of source code side by side.</p>\n\n<p>The use cases I had in mind for SQL when I decided to embark on this journey of semantic diffing were the following:</p>\n\n<ul>\n<li><strong>Query similarity score.</strong> Identifying which parts the two queries have in common to automatically suggest opportunities for consolidation, creation of intermediate/staging tables, and so on.</li>\n<li><strong>Differentiating between cosmetic / structural changes and functional ones.</strong> For example when a nested query is refactored into a common table expression (CTE), this kind of change doesn\u2019t have any functional impact on either a query or its outcome.</li>\n<li><strong>Automatic suggestions about the need to retroactively backfill data.</strong> This is especially important for pipelines that populate very large tables for which restatement is a runtime-intensive procedure. The ability to discern between simple code movements and actual modifications can help assess the impact of a change and make suggestions accordingly.</li>\n</ul>\n\n<p>The implementation discussed in this post is now a part of the <a href=\"https://github.com/tobymao/sqlglot/\">SQLGlot</a> library. You can find a complete source code in the <a href=\"https://github.com/tobymao/sqlglot/blob/main/sqlglot/diff.py\">diff.py</a> module. The choice of SQLglot was an obvious one due to its simple but powerful API, lack of external dependencies and, more importantly, extensive list of supported SQL dialects.</p>\n\n<h2 id=\"the-search-for-a-solution\">The Search for a Solution</h2>\n\n<p>When it comes to any diffing tool (not just a semantic one), the primary challenge is to match as many elements of compared entities as possible. Once such a set of matching elements is available, deriving a sequence of changes becomes an easy task.</p>\n\n<p>If our elements have unique identifiers associated with them (for example, an element\u2019s ID in DOM), the matching problem is trivial. However, the SQL syntax trees that we are comparing have neither unique keys nor object identifiers that can be used for the purposes of matching. So, how do we suppose to find pairs of nodes that are related?</p>\n\n<p>To better illustrate the problem, consider comparing the following SQL expressions: <code>SELECT a + b + c, d, e</code> and <code>SELECT a - b + c, e, f</code>. Matching individual nodes from respective syntax trees can be visualized as follows:</p>\n\n<p><img src=\"sql_diff_images/figure_1.png\" alt=\"Figure 1: Example of node matching for two SQL expression trees\" />\n<em>Figure 1: Example of node matching for two SQL expression trees.</em></p>\n\n<p>By looking at the figure of node matching for two SQL expression trees above, we conclude that the following changes should be captured by our solution:</p>\n\n<ul>\n<li>Inserted nodes: <code>Sub</code> and <code>f</code>. These are the nodes from the target AST which do not have a matching node in the source AST.</li>\n<li>Removed nodes: <code>Add</code> and <code>d</code>. These are the nodes from the source AST which do not have a counterpart in the target AST.</li>\n<li>Remaining nodes must be identified as unchanged.</li>\n</ul>\n\n<p>It should be clear at this point that if we manage to match nodes in the source tree with their counterparts in the target tree, then computing the diff becomes a trivial matter.</p>\n\n<h3 id=\"naive-brute-force\">Na\u00efve Brute-Force</h3>\n\n<p>The na\u00efve solution would be to try all different permutations of node pair combinations, and see which set of pairs performs the best based on some type of heuristics. The runtime cost of such a solution quickly reaches the escape velocity; if both trees had only 10 nodes each, the number of such sets would approximately be 10! ^ 2 = 3.6M ^ 2 ~= 13 * 10^12. This is a very bad case of factorial complexity (to be precise, it\u2019s actually much worse - O(n! ^ 2) - but I couldn\u2019t come up with a name for it), so there is little need to explore this approach any further.</p>\n\n<h3 id=\"myers-algorithm\">Myers Algorithm</h3>\n\n<p>After the na\u00efve approach was proven to be infeasible, the next question I asked myself was \u201chow does git diff work?\u201d. This question led me to discover the Myers diff algorithm [1]. This algorithm has been designed to compare sequences of strings. At its core, it\u2019s looking for the shortest path on a graph of possible edits that transform the first sequence into the second one, while heavily rewarding those paths that lead to longest subsequences of unchanged elements. There\u2019s a lot of material out there describing this algorithm in greater detail. I found James Coglan\u2019s series of <a href=\"https://blog.jcoglan.com/2017/02/12/the-myers-diff-algorithm-part-1/\">blog posts</a> to be the most comprehensive.</p>\n\n<p>Therefore, I had this \u201cbrilliant\u201d (actually not) idea to transform trees into sequences by traversing them in topological order, and then applying the Myers algorithm on resulting sequences while using a custom heuristics when checking the equality of two nodes. Unsurprisingly, comparing sequences of strings is quite different from comparing hierarchical tree structures, and by flattening trees into sequences, we lose a lot of relevant context. This resulted in a terrible performance of this algorithm on ASTs. It often matched completely unrelated nodes, even when the two trees were mostly the same, and produced extremely inaccurate lists of changes overall. After playing around with it a little and tweaking my equality heuristics to improve accuracy, I ultimately scrapped the whole implementation and went back to the drawing board.</p>\n\n<h2 id=\"change-distiller\">Change Distiller</h2>\n\n<p>The algorithm I settled on at the end was Change Distiller, created by Fluri et al. [2], which in turn is an improvement over the core idea described by Chawathe et al. [3].</p>\n\n<p>The algorithm consists of two high-level steps:</p>\n\n<ol>\n<li><strong>Finding appropriate matchings between pairs of nodes that are part of compared ASTs.</strong> Identifying what is meant by \u201cappropriate\u201d matching is also a part of this step.</li>\n<li><strong>Generating the so-called \u201cedit script\u201d from the matching set built in the 1st step.</strong> The edit script is a sequence of edit operations (for example, insert, remove, update, etc.) on individual tree nodes, such that when applied as transformations on the source AST, it eventually becomes the target AST. In general, the shorter the sequence, the better. The length of the edit script can be used to compare the performance of different algorithms, though this is not the only metric that matters.</li>\n</ol>\n\n<p>The rest of this section is dedicated to the Python implementation of the steps above using the AST implementation provided by the SQLGlot library.</p>\n\n<h3 id=\"building-the-matching-set\">Building the Matching Set</h3>\n\n<h4 id=\"matching-leaves\">Matching Leaves</h4>\n\n<p>We begin composing the matching set by matching the leaf nodes. Leaf nodes are the nodes that do not have any children nodes (such as literals, identifiers, etc.). In order to match them, we gather all the leaf nodes from the source tree and generate a cartesian product with all the leaves from the target tree, while comparing pairs created this way and assigning them a similarity score. During this stage, we also exclude pairs that don\u2019t pass basic matching criteria. Then, we pick pairs that scored the highest while making sure that each node is matched no more than once.</p>\n\n<p>Using the example provided at the beginning of the post, the process of building an initial set of candidate matchings can be seen on Figure 2.</p>\n\n<p><img src=\"sql_diff_images/figure_2.gif\" alt=\"Figure 2: Building a set of candidate matchings between leaf nodes. The third item in each triplet represents a similarity score between two nodes.\" />\n<em>Figure 2: Building a set of candidate matchings between leaf nodes. The third item in each triplet represents a similarity score between two nodes.</em></p>\n\n<p>First, let\u2019s analyze the similarity score. Then, we\u2019ll discuss matching criteria.</p>\n\n<p>The similarity score proposed by Fluri et al. [2] is a <a href=\"https://en.wikipedia.org/wiki/S%C3%B8rensen%E2%80%93Dice_coefficient\">dice coefficient </a>applied to <a href=\"https://en.wikipedia.org/wiki/Bigram\">bigrams</a> of respective node values. A bigram is a sequence of two adjacent elements from a string computed in a sliding window fashion:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"k\">def</span> <span class=\"nf\">bigram</span><span class=\"p\">(</span><span class=\"n\">string</span><span class=\"p\">):</span>\n    <span class=\"n\">count</span> <span class=\"o\">=</span> <span class=\"nb\">max</span><span class=\"p\">(</span><span class=\"mi\">0</span><span class=\"p\">,</span> <span class=\"nb\">len</span><span class=\"p\">(</span><span class=\"n\">string</span><span class=\"p\">)</span> <span class=\"o\">-</span> <span class=\"mi\">1</span><span class=\"p\">)</span>\n    <span class=\"k\">return</span> <span class=\"p\">[</span><span class=\"n\">string</span><span class=\"p\">[</span><span class=\"n\">i</span> <span class=\"p\">:</span> <span class=\"n\">i</span> <span class=\"o\">+</span> <span class=\"mi\">2</span><span class=\"p\">]</span> <span class=\"k\">for</span> <span class=\"n\">i</span> <span class=\"ow\">in</span> <span class=\"nb\">range</span><span class=\"p\">(</span><span class=\"n\">count</span><span class=\"p\">)]</span>\n</code></pre>\n</div>\n\n<p>For reasons that will become clear shortly, we actually need to compute bigram histograms rather than just sequences:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"kn\">from</span> <span class=\"nn\">collections</span> <span class=\"kn\">import</span> <span class=\"n\">defaultdict</span>\n\n<span class=\"k\">def</span> <span class=\"nf\">bigram_histo</span><span class=\"p\">(</span><span class=\"n\">string</span><span class=\"p\">):</span>\n    <span class=\"n\">count</span> <span class=\"o\">=</span> <span class=\"nb\">max</span><span class=\"p\">(</span><span class=\"mi\">0</span><span class=\"p\">,</span> <span class=\"nb\">len</span><span class=\"p\">(</span><span class=\"n\">string</span><span class=\"p\">)</span> <span class=\"o\">-</span> <span class=\"mi\">1</span><span class=\"p\">)</span>\n    <span class=\"n\">bigram_histo</span> <span class=\"o\">=</span> <span class=\"n\">defaultdict</span><span class=\"p\">(</span><span class=\"nb\">int</span><span class=\"p\">)</span>\n    <span class=\"k\">for</span> <span class=\"n\">i</span> <span class=\"ow\">in</span> <span class=\"nb\">range</span><span class=\"p\">(</span><span class=\"n\">count</span><span class=\"p\">):</span>\n        <span class=\"n\">bigram_histo</span><span class=\"p\">[</span><span class=\"n\">string</span><span class=\"p\">[</span><span class=\"n\">i</span> <span class=\"p\">:</span> <span class=\"n\">i</span> <span class=\"o\">+</span> <span class=\"mi\">2</span><span class=\"p\">]]</span> <span class=\"o\">+=</span> <span class=\"mi\">1</span>\n    <span class=\"k\">return</span> <span class=\"n\">bigram_histo</span>\n</code></pre>\n</div>\n\n<p>The dice coefficient formula looks like following:</p>\n\n<p><img src=\"sql_diff_images/dice_coef.png\" alt=\"Dice Coefficient\" /></p>\n\n<p>Where X is a bigram of the source node and Y is a bigram of the second one. What this essentially does is count the number of bigram elements the two nodes have in common, multiply it by 2, and then divide by the total number of elements in both bigrams. This is where bigram histograms come in handy:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"k\">def</span> <span class=\"nf\">dice_coefficient</span><span class=\"p\">(</span><span class=\"n\">source</span><span class=\"p\">,</span> <span class=\"n\">target</span><span class=\"p\">):</span>\n    <span class=\"n\">source_histo</span> <span class=\"o\">=</span> <span class=\"n\">bigram_histo</span><span class=\"p\">(</span><span class=\"n\">source</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">())</span>\n    <span class=\"n\">target_histo</span> <span class=\"o\">=</span> <span class=\"n\">bigram_histo</span><span class=\"p\">(</span><span class=\"n\">target</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">())</span>\n\n    <span class=\"n\">total_grams</span> <span class=\"o\">=</span> <span class=\"p\">(</span>\n        <span class=\"nb\">sum</span><span class=\"p\">(</span><span class=\"n\">source_histo</span><span class=\"o\">.</span><span class=\"n\">values</span><span class=\"p\">())</span> <span class=\"o\">+</span> <span class=\"nb\">sum</span><span class=\"p\">(</span><span class=\"n\">target_histo</span><span class=\"o\">.</span><span class=\"n\">values</span><span class=\"p\">())</span>\n    <span class=\"p\">)</span>\n    <span class=\"k\">if</span> <span class=\"ow\">not</span> <span class=\"n\">total_grams</span><span class=\"p\">:</span>\n        <span class=\"k\">return</span> <span class=\"mf\">1.0</span> <span class=\"k\">if</span> <span class=\"n\">source</span> <span class=\"o\">==</span> <span class=\"n\">target</span> <span class=\"k\">else</span> <span class=\"mf\">0.0</span>\n\n    <span class=\"n\">overlap_len</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>\n    <span class=\"n\">overlapping_grams</span> <span class=\"o\">=</span> <span class=\"nb\">set</span><span class=\"p\">(</span><span class=\"n\">source_histo</span><span class=\"p\">)</span> <span class=\"o\">&amp;</span> <span class=\"nb\">set</span><span class=\"p\">(</span><span class=\"n\">target_histo</span><span class=\"p\">)</span>\n    <span class=\"k\">for</span> <span class=\"n\">g</span> <span class=\"ow\">in</span> <span class=\"n\">overlapping_grams</span><span class=\"p\">:</span>\n        <span class=\"n\">overlap_len</span> <span class=\"o\">+=</span> <span class=\"nb\">min</span><span class=\"p\">(</span><span class=\"n\">source_histo</span><span class=\"p\">[</span><span class=\"n\">g</span><span class=\"p\">],</span> <span class=\"n\">target_histo</span><span class=\"p\">[</span><span class=\"n\">g</span><span class=\"p\">])</span>\n\n    <span class=\"k\">return</span> <span class=\"mi\">2</span> <span class=\"o\">*</span> <span class=\"n\">overlap_len</span> <span class=\"o\">/</span> <span class=\"n\">total_grams</span>\n</code></pre>\n</div>\n\n<p>To compute a bigram given a tree node, we first transform the node into its canonical SQL representation,so that the <code>Literal(123)</code> node becomes just \u201c123\u201d and the <code>Identifier(\u201ca\u201d)</code> node becomes just \u201ca\u201d. We also handle a scenario when strings are too short to derive bigrams. In this case, we fallback to checking the two nodes for equality.</p>\n\n<p>Now when we know how to compute the similarity score, we can take care of the matching criteria for leaf nodes. In the original paper [2], the matching criteria is formalized as follows:</p>\n\n<p><img src=\"sql_diff_images/matching_criteria_1.png\" alt=\"Matching criteria for leaf nodes\" /></p>\n\n<p>The two nodes are matched if two conditions are met:</p>\n\n<ol>\n<li>The node labels match (in our case labels are just node types).</li>\n<li>The similarity score for node values is greater than or equal to some threshold \u201cf\u201d. The authors of the paper recommend setting the value of \u201cf\u201d to 0.6.</li>\n</ol>\n\n<p>With building blocks in place, we can now build a matching set for leaf nodes. First, we generate a list of candidates for matching:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"kn\">from</span> <span class=\"nn\">heapq</span> <span class=\"kn\">import</span> <span class=\"n\">heappush</span><span class=\"p\">,</span> <span class=\"n\">heappop</span>\n\n<span class=\"n\">candidate_matchings</span> <span class=\"o\">=</span> <span class=\"p\">[]</span>\n<span class=\"n\">source_leaves</span> <span class=\"o\">=</span> <span class=\"n\">_get_leaves</span><span class=\"p\">(</span><span class=\"bp\">self</span><span class=\"o\">.</span><span class=\"n\">_source</span><span class=\"p\">)</span>\n<span class=\"n\">target_leaves</span> <span class=\"o\">=</span> <span class=\"n\">_get_leaves</span><span class=\"p\">(</span><span class=\"bp\">self</span><span class=\"o\">.</span><span class=\"n\">_target</span><span class=\"p\">)</span>\n<span class=\"k\">for</span> <span class=\"n\">source_leaf</span> <span class=\"ow\">in</span> <span class=\"n\">source_leaves</span><span class=\"p\">:</span>\n    <span class=\"k\">for</span> <span class=\"n\">target_leaf</span> <span class=\"ow\">in</span> <span class=\"n\">target_leaves</span><span class=\"p\">:</span>\n        <span class=\"k\">if</span> <span class=\"n\">_is_same_type</span><span class=\"p\">(</span><span class=\"n\">source_leaf</span><span class=\"p\">,</span> <span class=\"n\">target_leaf</span><span class=\"p\">):</span>\n            <span class=\"n\">similarity_score</span> <span class=\"o\">=</span> <span class=\"n\">dice_coefficient</span><span class=\"p\">(</span>\n                <span class=\"n\">source_leaf</span><span class=\"p\">,</span> <span class=\"n\">target_leaf</span>\n            <span class=\"p\">)</span>\n            <span class=\"k\">if</span> <span class=\"n\">similarity_score</span> <span class=\"o\">&gt;=</span> <span class=\"mf\">0.6</span><span class=\"p\">:</span>\n                <span class=\"n\">heappush</span><span class=\"p\">(</span>\n                    <span class=\"n\">candidate_matchings</span><span class=\"p\">,</span>\n                    <span class=\"p\">(</span>\n                        <span class=\"o\">-</span><span class=\"n\">similarity_score</span><span class=\"p\">,</span>\n                        <span class=\"nb\">len</span><span class=\"p\">(</span><span class=\"n\">candidate_matchings</span><span class=\"p\">),</span>\n                        <span class=\"n\">source_leaf</span><span class=\"p\">,</span>\n                        <span class=\"n\">target_leaf</span><span class=\"p\">,</span>\n                    <span class=\"p\">),</span>\n                <span class=\"p\">)</span>\n</code></pre>\n</div>\n\n<p>In the implementation above, we push each matching pair onto the heap to automatically maintain the correct order based on the assigned similarity score.</p>\n\n<p>Finally, we build the initial matching set by picking leaf pairs with the highest score:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"n\">matching_set</span> <span class=\"o\">=</span> <span class=\"nb\">set</span><span class=\"p\">()</span>\n<span class=\"k\">while</span> <span class=\"n\">candidate_matchings</span><span class=\"p\">:</span>\n    <span class=\"n\">_</span><span class=\"p\">,</span> <span class=\"n\">_</span><span class=\"p\">,</span> <span class=\"n\">source_leaf</span><span class=\"p\">,</span> <span class=\"n\">target_leaf</span> <span class=\"o\">=</span> <span class=\"n\">heappop</span><span class=\"p\">(</span><span class=\"n\">candidate_matchings</span><span class=\"p\">)</span>\n    <span class=\"k\">if</span> <span class=\"p\">(</span>\n        <span class=\"n\">source_leaf</span> <span class=\"ow\">in</span> <span class=\"n\">unmatched_source_nodes</span>\n        <span class=\"ow\">and</span> <span class=\"n\">target_leaf</span> <span class=\"ow\">in</span> <span class=\"n\">unmatched_target_nodes</span>\n    <span class=\"p\">):</span>\n        <span class=\"n\">matching_set</span><span class=\"o\">.</span><span class=\"n\">add</span><span class=\"p\">((</span><span class=\"n\">source_leaf</span><span class=\"p\">,</span> <span class=\"n\">target_leaf</span><span class=\"p\">))</span>\n        <span class=\"n\">unmatched_source_nodes</span><span class=\"o\">.</span><span class=\"n\">remove</span><span class=\"p\">(</span><span class=\"n\">source_leaf</span><span class=\"p\">)</span>\n        <span class=\"n\">unmatched_target_nodes</span><span class=\"o\">.</span><span class=\"n\">remove</span><span class=\"p\">(</span><span class=\"n\">target_leaf</span><span class=\"p\">)</span>\n</code></pre>\n</div>\n\n<p>To finalize the matching set, we should now proceed with matching inner nodes.</p>\n\n<h4 id=\"matching-inner-nodes\">Matching Inner Nodes</h4>\n\n<p>Matching inner nodes is quite similar to matching leaf nodes, with the following two distinctions:</p>\n\n<ul>\n<li>Rather than ranking a set of possible candidates, we pick the first node pair that passes the matching criteria.</li>\n<li>The matching criteria itself has been extended to account for the number of leaf nodes the pair of inner nodes have in common.</li>\n</ul>\n\n<p><img src=\"sql_diff_images/figure_3.gif\" alt=\"Figure 3: Matching inner nodes based on their type as well as how many of their leaf nodes have been previously matched.\" />\n<em>Figure 3: Matching inner nodes based on their type as well as how many of their leaf nodes have been previously matched.</em></p>\n\n<p>Let\u2019s start with the matching criteria. The criteria is formalized as follows:</p>\n\n<p><img src=\"sql_diff_images/matching_criteria_2.png\" alt=\"Matching criteria for inner nodes\" /></p>\n\n<p>Alongside already familiar similarity score and node type criteria, there is a new one in the middle: the ratio of leaf nodes that the two nodes have in common must exceed some threshold \u201ct\u201d. The recommended value for \u201ct\u201d is also 0.6. Counting the number of common leaf nodes is pretty straightforward, since we already have the complete matching set for leaves. All we need to do is count how many matching pairs do leaf nodes from the two compared inner nodes form.</p>\n\n<p>There are two additional heuristics associated with this matching criteria:</p>\n\n<ul>\n<li>Inner node similarity weighting: if the similarity score between the node values doesn\u2019t pass the threshold \u201cf\u201d but the ratio of common leaf nodes (\u201ct\u201d) is greater than or equal to 0.8, then the matching is considered successful.</li>\n<li>The threshold \u201ct\u201d is reduced to 0.4 for inner nodes with the number of leaf nodes equal to 4 or less, in order to decrease the false negative rate for small subtrees.</li>\n</ul>\n\n<p>We now only have to iterate through the remaining unmatched nodes and form matching pairs based on the outlined criteria:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"n\">leaves_matching_set</span> <span class=\"o\">=</span> <span class=\"n\">matching_set</span><span class=\"o\">.</span><span class=\"n\">copy</span><span class=\"p\">()</span>\n\n<span class=\"k\">for</span> <span class=\"n\">source_node</span> <span class=\"ow\">in</span> <span class=\"n\">unmatched_source_nodes</span><span class=\"o\">.</span><span class=\"n\">copy</span><span class=\"p\">():</span>\n    <span class=\"k\">for</span> <span class=\"n\">target_node</span> <span class=\"ow\">in</span> <span class=\"n\">unmatched_target_nodes</span><span class=\"p\">:</span>\n        <span class=\"k\">if</span> <span class=\"n\">_is_same_type</span><span class=\"p\">(</span><span class=\"n\">source_node</span><span class=\"p\">,</span> <span class=\"n\">target_node</span><span class=\"p\">):</span>\n            <span class=\"n\">source_leaves</span> <span class=\"o\">=</span> <span class=\"nb\">set</span><span class=\"p\">(</span><span class=\"n\">_get_leaves</span><span class=\"p\">(</span><span class=\"n\">source_node</span><span class=\"p\">))</span>\n            <span class=\"n\">target_leaves</span> <span class=\"o\">=</span> <span class=\"nb\">set</span><span class=\"p\">(</span><span class=\"n\">_get_leaves</span><span class=\"p\">(</span><span class=\"n\">target_node</span><span class=\"p\">))</span>\n\n            <span class=\"n\">max_leaves_num</span> <span class=\"o\">=</span> <span class=\"nb\">max</span><span class=\"p\">(</span><span class=\"nb\">len</span><span class=\"p\">(</span><span class=\"n\">source_leaves</span><span class=\"p\">),</span> <span class=\"nb\">len</span><span class=\"p\">(</span><span class=\"n\">target_leaves</span><span class=\"p\">))</span>\n            <span class=\"k\">if</span> <span class=\"n\">max_leaves_num</span><span class=\"p\">:</span>\n                <span class=\"n\">common_leaves_num</span> <span class=\"o\">=</span> <span class=\"nb\">sum</span><span class=\"p\">(</span>\n                    <span class=\"mi\">1</span> <span class=\"k\">if</span> <span class=\"n\">s</span> <span class=\"ow\">in</span> <span class=\"n\">source_leaves</span> <span class=\"ow\">and</span> <span class=\"n\">t</span> <span class=\"ow\">in</span> <span class=\"n\">target_leaves</span> <span class=\"k\">else</span> <span class=\"mi\">0</span>\n                    <span class=\"k\">for</span> <span class=\"n\">s</span><span class=\"p\">,</span> <span class=\"n\">t</span> <span class=\"ow\">in</span> <span class=\"n\">leaves_matching_set</span>\n                <span class=\"p\">)</span>\n                <span class=\"n\">leaf_similarity_score</span> <span class=\"o\">=</span> <span class=\"n\">common_leaves_num</span> <span class=\"o\">/</span> <span class=\"n\">max_leaves_num</span>\n            <span class=\"k\">else</span><span class=\"p\">:</span>\n                <span class=\"n\">leaf_similarity_score</span> <span class=\"o\">=</span> <span class=\"mf\">0.0</span>\n\n            <span class=\"n\">adjusted_t</span> <span class=\"o\">=</span> <span class=\"p\">(</span>\n                <span class=\"mf\">0.6</span>\n                <span class=\"k\">if</span> <span class=\"nb\">min</span><span class=\"p\">(</span><span class=\"nb\">len</span><span class=\"p\">(</span><span class=\"n\">source_leaves</span><span class=\"p\">),</span> <span class=\"nb\">len</span><span class=\"p\">(</span><span class=\"n\">target_leaves</span><span class=\"p\">))</span> <span class=\"o\">&gt;</span> <span class=\"mi\">4</span>\n                <span class=\"k\">else</span> <span class=\"mf\">0.4</span>\n            <span class=\"p\">)</span>\n\n            <span class=\"k\">if</span> <span class=\"n\">leaf_similarity_score</span> <span class=\"o\">&gt;=</span> <span class=\"mf\">0.8</span> <span class=\"ow\">or</span> <span class=\"p\">(</span>\n                <span class=\"n\">leaf_similarity_score</span> <span class=\"o\">&gt;=</span> <span class=\"n\">adjusted_t</span>\n                <span class=\"ow\">and</span> <span class=\"n\">dice_coefficient</span><span class=\"p\">(</span><span class=\"n\">source_node</span><span class=\"p\">,</span> <span class=\"n\">target_node</span><span class=\"p\">)</span> <span class=\"o\">&gt;=</span> <span class=\"mf\">0.6</span>\n            <span class=\"p\">):</span>\n                <span class=\"n\">matching_set</span><span class=\"o\">.</span><span class=\"n\">add</span><span class=\"p\">((</span><span class=\"n\">source_node</span><span class=\"p\">,</span> <span class=\"n\">target_node</span><span class=\"p\">))</span>\n                <span class=\"n\">unmatched_source_nodes</span><span class=\"o\">.</span><span class=\"n\">remove</span><span class=\"p\">(</span><span class=\"n\">source_node</span><span class=\"p\">)</span>\n                <span class=\"n\">unmatched_target_nodes</span><span class=\"o\">.</span><span class=\"n\">remove</span><span class=\"p\">(</span><span class=\"n\">target_node</span><span class=\"p\">)</span>\n                <span class=\"k\">break</span>\n</code></pre>\n</div>\n\n<p>After the matching set is formed, we can proceed with generation of the edit script, which will be the algorithm\u2019s output.</p>\n\n<h3 id=\"generating-the-edit-script\">Generating the Edit Script</h3>\n\n<p>At this point, we should have the following 3 sets at our disposal:</p>\n\n<ul>\n<li>The set of matched node pairs.</li>\n<li>The set of remaining unmatched nodes from the source tree.</li>\n<li>The set of remaining unmatched nodes from the target tree.</li>\n</ul>\n\n<p>We can derive 3 kinds of edits from the matching set: either the node\u2019s value was updated (<strong>Update</strong>), the node was moved to a different position within the tree (<strong>Move</strong>), or the node remained unchanged (<strong>Keep</strong>). Note that the <strong>Move</strong> case is not mutually exclusive with the other two. The node could have been updated or could have remained the same while at the same time its position within its parent node or the parent node itself could have changed. All unmatched nodes from the source tree are the ones that were removed (<strong>Remove</strong>), while unmatched nodes from the target tree are the ones that were inserted (<strong>Insert</strong>).</p>\n\n<p>The latter two cases are pretty straightforward to implement:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"n\">edit_script</span> <span class=\"o\">=</span> <span class=\"p\">[]</span>\n\n<span class=\"k\">for</span> <span class=\"n\">removed_node</span> <span class=\"ow\">in</span> <span class=\"n\">unmatched_source_nodes</span><span class=\"p\">:</span>\n    <span class=\"n\">edit_script</span><span class=\"o\">.</span><span class=\"n\">append</span><span class=\"p\">(</span><span class=\"n\">Remove</span><span class=\"p\">(</span><span class=\"n\">removed_node</span><span class=\"p\">))</span>\n<span class=\"k\">for</span> <span class=\"n\">inserted_node</span> <span class=\"ow\">in</span> <span class=\"n\">unmatched_target_nodes</span><span class=\"p\">:</span>\n    <span class=\"n\">edit_script</span><span class=\"o\">.</span><span class=\"n\">append</span><span class=\"p\">(</span><span class=\"n\">Insert</span><span class=\"p\">(</span><span class=\"n\">inserted_node</span><span class=\"p\">))</span>\n</code></pre>\n</div>\n\n<p>Traversing the matching set requires a little more thought:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"k\">for</span> <span class=\"n\">source_node</span><span class=\"p\">,</span> <span class=\"n\">target_node</span> <span class=\"ow\">in</span> <span class=\"n\">matching_set</span><span class=\"p\">:</span>\n    <span class=\"k\">if</span> <span class=\"p\">(</span>\n        <span class=\"ow\">not</span> <span class=\"nb\">isinstance</span><span class=\"p\">(</span><span class=\"n\">source_node</span><span class=\"p\">,</span> <span class=\"n\">LEAF_EXPRESSION_TYPES</span><span class=\"p\">)</span>\n        <span class=\"ow\">or</span> <span class=\"n\">source_node</span> <span class=\"o\">==</span> <span class=\"n\">target_node</span>\n    <span class=\"p\">):</span>\n        <span class=\"n\">move_edits</span> <span class=\"o\">=</span> <span class=\"n\">generate_move_edits</span><span class=\"p\">(</span>\n            <span class=\"n\">source_node</span><span class=\"p\">,</span> <span class=\"n\">target_node</span><span class=\"p\">,</span> <span class=\"n\">matching_set</span>\n        <span class=\"p\">)</span>\n        <span class=\"n\">edit_script</span><span class=\"o\">.</span><span class=\"n\">extend</span><span class=\"p\">(</span><span class=\"n\">move_edits</span><span class=\"p\">)</span>\n        <span class=\"n\">edit_script</span><span class=\"o\">.</span><span class=\"n\">append</span><span class=\"p\">(</span><span class=\"n\">Keep</span><span class=\"p\">(</span><span class=\"n\">source_node</span><span class=\"p\">,</span> <span class=\"n\">target_node</span><span class=\"p\">))</span>\n    <span class=\"k\">else</span><span class=\"p\">:</span>\n        <span class=\"n\">edit_script</span><span class=\"o\">.</span><span class=\"n\">append</span><span class=\"p\">(</span><span class=\"n\">Update</span><span class=\"p\">(</span><span class=\"n\">source_node</span><span class=\"p\">,</span> <span class=\"n\">target_node</span><span class=\"p\">))</span>\n</code></pre>\n</div>\n\n<p>If a matching pair represents a pair of leaf nodes, we check if they are the same to decide whether an update took place. For inner node pairs, we also need to compare the positions of their respective children to detect node movements. Chawathe et al. [3] suggest applying the <a href=\"https://en.wikipedia.org/wiki/Longest_common_subsequence_problem\">longest common subsequence </a>(LCS) algorithm which, no surprise here, was described by Myers himself [1]. There is a small catch, however: instead of checking the equality of two children nodes, we need to check whether the two nodes form a pair that is a part of our matching set.</p>\n\n<p>Now with this knowledge, the implementation becomes straightforward:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"k\">def</span> <span class=\"nf\">generate_move_edits</span><span class=\"p\">(</span><span class=\"n\">source</span><span class=\"p\">,</span> <span class=\"n\">target</span><span class=\"p\">,</span> <span class=\"n\">matching_set</span><span class=\"p\">):</span>\n    <span class=\"n\">source_children</span> <span class=\"o\">=</span> <span class=\"n\">_get_child_nodes</span><span class=\"p\">(</span><span class=\"n\">source</span><span class=\"p\">)</span>\n    <span class=\"n\">target_children</span> <span class=\"o\">=</span> <span class=\"n\">_get_child_nodes</span><span class=\"p\">(</span><span class=\"n\">target</span><span class=\"p\">)</span>\n\n    <span class=\"n\">lcs</span> <span class=\"o\">=</span> <span class=\"nb\">set</span><span class=\"p\">(</span>\n        <span class=\"n\">_longest_common_subsequence</span><span class=\"p\">(</span>\n            <span class=\"n\">source_children</span><span class=\"p\">,</span>\n            <span class=\"n\">target_children</span><span class=\"p\">,</span>\n            <span class=\"k\">lambda</span> <span class=\"n\">l</span><span class=\"p\">,</span> <span class=\"n\">r</span><span class=\"p\">:</span> <span class=\"p\">(</span><span class=\"n\">l</span><span class=\"p\">,</span> <span class=\"n\">r</span><span class=\"p\">)</span> <span class=\"ow\">in</span> <span class=\"n\">matching_set</span>\n        <span class=\"p\">)</span>\n    <span class=\"p\">)</span>\n\n    <span class=\"n\">move_edits</span> <span class=\"o\">=</span> <span class=\"p\">[]</span>\n    <span class=\"k\">for</span> <span class=\"n\">node</span> <span class=\"ow\">in</span> <span class=\"n\">source_children</span><span class=\"p\">:</span>\n        <span class=\"k\">if</span> <span class=\"n\">node</span> <span class=\"ow\">not</span> <span class=\"ow\">in</span> <span class=\"n\">lcs</span> <span class=\"ow\">and</span> <span class=\"n\">node</span> <span class=\"ow\">not</span> <span class=\"ow\">in</span> <span class=\"n\">unmatched_source_nodes</span><span class=\"p\">:</span>\n            <span class=\"n\">move_edits</span><span class=\"o\">.</span><span class=\"n\">append</span><span class=\"p\">(</span><span class=\"n\">Move</span><span class=\"p\">(</span><span class=\"n\">node</span><span class=\"p\">))</span>\n\n    <span class=\"k\">return</span> <span class=\"n\">move_edits</span>\n</code></pre>\n</div>\n\n<p>I left out the implementation of the LCS algorithm itself here, but there are plenty of implementation choices out there that can be easily looked up.</p>\n\n<h3 id=\"output\">Output</h3>\n\n<p>The implemented algorithm produces the output that resembles the following:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"o\">&gt;&gt;&gt;</span> <span class=\"kn\">from</span> <span class=\"nn\">sqlglot</span> <span class=\"kn\">import</span> <span class=\"n\">parse_one</span><span class=\"p\">,</span> <span class=\"n\">diff</span>\n<span class=\"o\">&gt;&gt;&gt;</span> <span class=\"n\">diff</span><span class=\"p\">(</span><span class=\"n\">parse_one</span><span class=\"p\">(</span><span class=\"s2\">&quot;SELECT a + b + c, d, e&quot;</span><span class=\"p\">),</span> <span class=\"n\">parse_one</span><span class=\"p\">(</span><span class=\"s2\">&quot;SELECT a - b + c, e, f&quot;</span><span class=\"p\">))</span>\n\n<span class=\"n\">Remove</span><span class=\"p\">(</span><span class=\"n\">Add</span><span class=\"p\">)</span>\n<span class=\"n\">Remove</span><span class=\"p\">(</span><span class=\"n\">Column</span><span class=\"p\">(</span><span class=\"n\">d</span><span class=\"p\">))</span>\n<span class=\"n\">Remove</span><span class=\"p\">(</span><span class=\"n\">Identifier</span><span class=\"p\">(</span><span class=\"n\">d</span><span class=\"p\">))</span>\n<span class=\"n\">Insert</span><span class=\"p\">(</span><span class=\"n\">Sub</span><span class=\"p\">)</span>\n<span class=\"n\">Insert</span><span class=\"p\">(</span><span class=\"n\">Column</span><span class=\"p\">(</span><span class=\"n\">f</span><span class=\"p\">))</span>\n<span class=\"n\">Insert</span><span class=\"p\">(</span><span class=\"n\">Identifier</span><span class=\"p\">(</span><span class=\"n\">f</span><span class=\"p\">))</span>\n<span class=\"n\">Keep</span><span class=\"p\">(</span><span class=\"n\">Select</span><span class=\"p\">,</span> <span class=\"n\">Select</span><span class=\"p\">)</span>\n<span class=\"n\">Keep</span><span class=\"p\">(</span><span class=\"n\">Add</span><span class=\"p\">,</span> <span class=\"n\">Add</span><span class=\"p\">)</span>\n<span class=\"n\">Keep</span><span class=\"p\">(</span><span class=\"n\">Column</span><span class=\"p\">(</span><span class=\"n\">a</span><span class=\"p\">),</span> <span class=\"n\">Column</span><span class=\"p\">(</span><span class=\"n\">a</span><span class=\"p\">))</span>\n<span class=\"n\">Keep</span><span class=\"p\">(</span><span class=\"n\">Identifier</span><span class=\"p\">(</span><span class=\"n\">a</span><span class=\"p\">),</span> <span class=\"n\">Identifier</span><span class=\"p\">(</span><span class=\"n\">a</span><span class=\"p\">))</span>\n<span class=\"n\">Keep</span><span class=\"p\">(</span><span class=\"n\">Column</span><span class=\"p\">(</span><span class=\"n\">b</span><span class=\"p\">),</span> <span class=\"n\">Column</span><span class=\"p\">(</span><span class=\"n\">b</span><span class=\"p\">))</span>\n<span class=\"n\">Keep</span><span class=\"p\">(</span><span class=\"n\">Identifier</span><span class=\"p\">(</span><span class=\"n\">b</span><span class=\"p\">),</span> <span class=\"n\">Identifier</span><span class=\"p\">(</span><span class=\"n\">b</span><span class=\"p\">))</span>\n<span class=\"n\">Keep</span><span class=\"p\">(</span><span class=\"n\">Column</span><span class=\"p\">(</span><span class=\"n\">c</span><span class=\"p\">),</span> <span class=\"n\">Column</span><span class=\"p\">(</span><span class=\"n\">c</span><span class=\"p\">))</span>\n<span class=\"n\">Keep</span><span class=\"p\">(</span><span class=\"n\">Identifier</span><span class=\"p\">(</span><span class=\"n\">c</span><span class=\"p\">),</span> <span class=\"n\">Identifier</span><span class=\"p\">(</span><span class=\"n\">c</span><span class=\"p\">))</span>\n<span class=\"n\">Keep</span><span class=\"p\">(</span><span class=\"n\">Column</span><span class=\"p\">(</span><span class=\"n\">e</span><span class=\"p\">),</span> <span class=\"n\">Column</span><span class=\"p\">(</span><span class=\"n\">e</span><span class=\"p\">))</span>\n<span class=\"n\">Keep</span><span class=\"p\">(</span><span class=\"n\">Identifier</span><span class=\"p\">(</span><span class=\"n\">e</span><span class=\"p\">),</span> <span class=\"n\">Identifier</span><span class=\"p\">(</span><span class=\"n\">e</span><span class=\"p\">))</span>\n</code></pre>\n</div>\n\n<p>Note that the output above is abbreviated. The string representation of actual AST nodes is significantly more verbose.</p>\n\n<p>The implementation works especially well when coupled with the SQLGlot\u2019s query optimizer which can be used to produce canonical representations of compared queries:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"o\">&gt;&gt;&gt;</span> <span class=\"n\">schema</span><span class=\"o\">=</span><span class=\"p\">{</span><span class=\"s2\">&quot;t&quot;</span><span class=\"p\">:</span> <span class=\"p\">{</span><span class=\"s2\">&quot;a&quot;</span><span class=\"p\">:</span> <span class=\"s2\">&quot;INT&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;b&quot;</span><span class=\"p\">:</span> <span class=\"s2\">&quot;INT&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;c&quot;</span><span class=\"p\">:</span> <span class=\"s2\">&quot;INT&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;d&quot;</span><span class=\"p\">:</span> <span class=\"s2\">&quot;INT&quot;</span><span class=\"p\">}}</span>\n<span class=\"o\">&gt;&gt;&gt;</span> <span class=\"n\">source</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;&quot;&quot;</span>\n<span class=\"s2\">... SELECT 1 + 1 + a</span>\n<span class=\"s2\">... FROM t</span>\n<span class=\"s2\">... WHERE b = 1 OR (c = 2 AND d = 3)</span>\n<span class=\"s2\">... &quot;&quot;&quot;</span>\n<span class=\"o\">&gt;&gt;&gt;</span> <span class=\"n\">target</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;&quot;&quot;</span>\n<span class=\"s2\">... SELECT 2 + a</span>\n<span class=\"s2\">... FROM t</span>\n<span class=\"s2\">... WHERE (b = 1 OR c = 2) AND (b = 1 OR d = 3)</span>\n<span class=\"s2\">... &quot;&quot;&quot;</span>\n<span class=\"o\">&gt;&gt;&gt;</span> <span class=\"n\">optimized_source</span> <span class=\"o\">=</span> <span class=\"n\">optimize</span><span class=\"p\">(</span><span class=\"n\">parse_one</span><span class=\"p\">(</span><span class=\"n\">source</span><span class=\"p\">),</span> <span class=\"n\">schema</span><span class=\"o\">=</span><span class=\"n\">schema</span><span class=\"p\">)</span>\n<span class=\"o\">&gt;&gt;&gt;</span> <span class=\"n\">optimized_target</span> <span class=\"o\">=</span> <span class=\"n\">optimize</span><span class=\"p\">(</span><span class=\"n\">parse_one</span><span class=\"p\">(</span><span class=\"n\">target</span><span class=\"p\">),</span> <span class=\"n\">schema</span><span class=\"o\">=</span><span class=\"n\">schema</span><span class=\"p\">)</span>\n<span class=\"o\">&gt;&gt;&gt;</span> <span class=\"n\">edit_script</span> <span class=\"o\">=</span> <span class=\"n\">diff</span><span class=\"p\">(</span><span class=\"n\">optimized_source</span><span class=\"p\">,</span> <span class=\"n\">optimized_target</span><span class=\"p\">)</span>\n<span class=\"o\">&gt;&gt;&gt;</span> <span class=\"nb\">sum</span><span class=\"p\">(</span><span class=\"mi\">0</span> <span class=\"k\">if</span> <span class=\"nb\">isinstance</span><span class=\"p\">(</span><span class=\"n\">e</span><span class=\"p\">,</span> <span class=\"n\">Keep</span><span class=\"p\">)</span> <span class=\"k\">else</span> <span class=\"mi\">1</span> <span class=\"k\">for</span> <span class=\"n\">e</span> <span class=\"ow\">in</span> <span class=\"n\">edit_script</span><span class=\"p\">)</span>\n<span class=\"mi\">0</span>\n</code></pre>\n</div>\n\n<h3 id=\"optimizations\">Optimizations</h3>\n\n<p>The worst case runtime complexity of this algorithm is not exactly stellar: O(n^2 * log n^2). This is because of the leaf matching process, which involves ranking a cartesian product between all leaf nodes of compared trees. Unsurprisingly, the algorithm takes a considerable time to finish for bigger queries.</p>\n\n<p>There are still a few basic things we can do in our implementation to help improve performance:</p>\n\n<ul>\n<li>Refer to individual node objects using their identifiers (Python\u2019s <a href=\"https://docs.python.org/3/library/functions.html#id\">id()</a>) instead of direct references in sets. This helps avoid costly recursive hash calculations and equality checks.</li>\n<li>Cache bigram histograms to avoid computing them more than once for the same node.</li>\n<li>Compute the canonical SQL string representation for each tree once while caching string representations of all inner nodes. This prevents redundant tree traversals when bigrams are computed.</li>\n</ul>\n\n<p>At the time of writing only the first two optimizations have been implemented, so there is an opportunity to contribute for anyone who\u2019s interested.</p>\n\n<h2 id=\"alternative-solutions\">Alternative Solutions</h2>\n\n<p>This section is dedicated to solutions that I\u2019ve investigated, but haven\u2019t tried.</p>\n\n<p>First, this section wouldn\u2019t be complete without Tristan Hume\u2019s <a href=\"https://thume.ca/2017/06/17/tree-diffing/\">blog post</a>. Tristan\u2019s solution has a lot in common with the Myers algorithm plus heuristics that is much more clever than what I came up with. The implementation relies on a combination of <a href=\"https://en.wikipedia.org/wiki/Dynamic_programming\">dynamic programming</a> and <a href=\"https://en.wikipedia.org/wiki/A*_search_algorithm\">A* search algorithm</a> to explore the space of possible matchings and pick the best ones. It seemed to have worked well for Tistan\u2019s specific use case, but after my negative experience with the Myers algorithm, I decided to try something different.</p>\n\n<p>Another notable approach is the Gumtree algorithm by Falleri et al. [4]. I discovered this paper after I\u2019d already implemented the algorithm that is the main focus of this post. In sections 5.2 and 5.3 of their paper, the authors compare the two algorithms side by side and claim that Gumtree is significantly better in terms of both runtime performance and accuracy when evaluated on 12 792 pairs of Java source files. This doesn\u2019t surprise me, as the algorithm takes the height of subtrees into account. In my tests, I definitely saw scenarios in which this context would have helped. On top of that, the authors promise O(n^2) runtime complexity in the worst case which, given the Change Distiller's O(n^2 * log n^2), looks particularly tempting. I hope to try this algorithm out at some point, and there is a good chance you see me writing about it in my future posts.</p>\n\n<h2 id=\"conclusion\">Conclusion</h2>\n\n<p>The Change Distiller algorithm yielded quite satisfactory results in most of my tests. The scenarios in which it fell short mostly concerned identical (or very similar) subtrees located in different parts of the AST. In those cases, node mismatches were frequent and, as a result, edit scripts were somewhat suboptimal.</p>\n\n<p>Additionally, the runtime performance of the algorithm leaves a lot to be desired. On trees with 1000 leaf nodes each, the algorithm takes a little under 2 seconds to complete. My implementation still has room for improvement, but this should give you a rough idea of what to expect. It appears that the Gumtree algorithm [4] can help address both of these points. I hope to find bandwidth to work on it soon and then compare the two algorithms side-by-side to find out which one performs better on SQL specifically. In the meantime, Change Distiller definitely gets the job done, and I can now proceed with applying it to some of the use cases I mentioned at the beginning of this post.</p>\n\n<p>I\u2019m also curious to learn whether other folks in the industry faced a similar problem, and how they approached it. If you did something similar, I\u2019m interested to hear about your experience.</p>\n\n<h2 id=\"references\">References</h2>\n\n<p>[1] Eugene W. Myers. <a href=\"http://www.xmailserver.org/diff2.pdf\">An O(ND) Difference Algorithm and Its Variations</a>. Algorithmica 1(2): 251-266 (1986)</p>\n\n<p>[2] B. Fluri, M. Wursch, M. Pinzger, and H. Gall. <a href=\"https://www.researchgate.net/publication/3189787_Change_DistillingTree_Differencing_for_Fine-Grained_Source_Code_Change_Extraction\">Change Distilling: Tree differencing for fine-grained source code change extraction</a>. IEEE Trans. Software Eng., 33(11):725\u2013743, 2007.</p>\n\n<p>[3] S.S. Chawathe, A. Rajaraman, H. Garcia-Molina, and J. Widom. <a href=\"http://ilpubs.stanford.edu:8090/115/1/1995-46.pdf\">Change Detection in Hierarchically Structured Information</a>. Proc. ACM Sigmod Int\u2019l Conf. Management of Data, pp. 493-504, June 1996</p>\n\n<p>[4] Jean-R\u00e9my Falleri, Flor\u00e9al Morandat, Xavier Blanc, Matias Martinez, Martin Monperrus. <a href=\"https://hal.archives-ouvertes.fr/hal-01054552/document\">Fine-grained and Accurate Source Code Differencing</a>. Proceedings of the International Conference on Automated Software Engineering, 2014, V\u00e4steras, Sweden. pp.313-324, 10.1145/2642937.2642982. hal-01054552</p>\n\n<hr />\n"}, "sqlglot.diff.Insert": {"fullname": "sqlglot.diff.Insert", "modulename": "sqlglot.diff", "qualname": "Insert", "kind": "class", "doc": "<p>Indicates that a new node has been inserted</p>\n"}, "sqlglot.diff.Insert.__init__": {"fullname": "sqlglot.diff.Insert.__init__", "modulename": "sqlglot.diff", "qualname": "Insert.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span></span>)</span>"}, "sqlglot.diff.Remove": {"fullname": "sqlglot.diff.Remove", "modulename": "sqlglot.diff", "qualname": "Remove", "kind": "class", "doc": "<p>Indicates that an existing node has been removed</p>\n"}, "sqlglot.diff.Remove.__init__": {"fullname": "sqlglot.diff.Remove.__init__", "modulename": "sqlglot.diff", "qualname": "Remove.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span></span>)</span>"}, "sqlglot.diff.Move": {"fullname": "sqlglot.diff.Move", "modulename": "sqlglot.diff", "qualname": "Move", "kind": "class", "doc": "<p>Indicates that an existing node's position within the tree has changed</p>\n"}, "sqlglot.diff.Move.__init__": {"fullname": "sqlglot.diff.Move.__init__", "modulename": "sqlglot.diff", "qualname": "Move.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span></span>)</span>"}, "sqlglot.diff.Update": {"fullname": "sqlglot.diff.Update", "modulename": "sqlglot.diff", "qualname": "Update", "kind": "class", "doc": "<p>Indicates that an existing node has been updated</p>\n"}, "sqlglot.diff.Update.__init__": {"fullname": "sqlglot.diff.Update.__init__", "modulename": "sqlglot.diff", "qualname": "Update.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">source</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span>,</span><span class=\"param\">\t<span class=\"n\">target</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span></span>)</span>"}, "sqlglot.diff.Keep": {"fullname": "sqlglot.diff.Keep", "modulename": "sqlglot.diff", "qualname": "Keep", "kind": "class", "doc": "<p>Indicates that an existing node hasn't been changed</p>\n"}, "sqlglot.diff.Keep.__init__": {"fullname": "sqlglot.diff.Keep.__init__", "modulename": "sqlglot.diff", "qualname": "Keep.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">source</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span>,</span><span class=\"param\">\t<span class=\"n\">target</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span></span>)</span>"}, "sqlglot.diff.diff": {"fullname": "sqlglot.diff.diff", "modulename": "sqlglot.diff", "qualname": "diff", "kind": "function", "doc": "<p>Returns the list of changes between the source and the target expressions.</p>\n\n<h6 id=\"examples\">Examples:</h6>\n\n<blockquote>\n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">diff</span><span class=\"p\">(</span><span class=\"n\">parse_one</span><span class=\"p\">(</span><span class=\"s2\">&quot;a + b&quot;</span><span class=\"p\">),</span> <span class=\"n\">parse_one</span><span class=\"p\">(</span><span class=\"s2\">&quot;a + c&quot;</span><span class=\"p\">))</span>\n<span class=\"go\">[</span>\n<span class=\"go\">    Remove(expression=(COLUMN this: (IDENTIFIER this: b, quoted: False))),</span>\n<span class=\"go\">    Insert(expression=(COLUMN this: (IDENTIFIER this: c, quoted: False))),</span>\n<span class=\"go\">    Keep(</span>\n<span class=\"go\">        source=(ADD this: ...),</span>\n<span class=\"go\">        target=(ADD this: ...)</span>\n<span class=\"go\">    ),</span>\n<span class=\"go\">    Keep(</span>\n<span class=\"go\">        source=(COLUMN this: (IDENTIFIER this: a, quoted: False)),</span>\n<span class=\"go\">        target=(COLUMN this: (IDENTIFIER this: a, quoted: False))</span>\n<span class=\"go\">    ),</span>\n<span class=\"go\">]</span>\n</code></pre>\n  </div>\n</blockquote>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>source:</strong>  the source expression.</li>\n<li><strong>target:</strong>  the target expression against which the diff should be calculated.</li>\n<li><strong>matchings:</strong>  the list of pre-matched node pairs which is used to help the algorithm's\nheuristics produce better results for subtrees that are known by a caller to be matching.\nNote: expression references in this list must refer to the same node objects that are\nreferenced in source / target trees.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>the list of Insert, Remove, Move, Update and Keep objects for each node in the source and the\n  target expression trees. This list represents a sequence of steps needed to transform the source\n  expression tree into the target one.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">source</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span>,</span><span class=\"param\">\t<span class=\"n\">target</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span>,</span><span class=\"param\">\t<span class=\"n\">matchings</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">]]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span><span class=\"p\">:</span> <span class=\"n\">Any</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">diff</span><span class=\"o\">.</span><span class=\"n\">Insert</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">diff</span><span class=\"o\">.</span><span class=\"n\">Remove</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">diff</span><span class=\"o\">.</span><span class=\"n\">Move</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">diff</span><span class=\"o\">.</span><span class=\"n\">Update</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">diff</span><span class=\"o\">.</span><span class=\"n\">Keep</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "sqlglot.diff.ChangeDistiller": {"fullname": "sqlglot.diff.ChangeDistiller", "modulename": "sqlglot.diff", "qualname": "ChangeDistiller", "kind": "class", "doc": "<p>The implementation of the Change Distiller algorithm described by Beat Fluri and Martin Pinzger in\ntheir paper <a href=\"https://ieeexplore.ieee.org/document/4339230\">https://ieeexplore.ieee.org/document/4339230</a>, which in turn is based on the algorithm by\nChawathe et al. described in <a href=\"http://ilpubs.stanford.edu:8090/115/1/1995-46.pdf\">http://ilpubs.stanford.edu:8090/115/1/1995-46.pdf</a>.</p>\n"}, "sqlglot.diff.ChangeDistiller.__init__": {"fullname": "sqlglot.diff.ChangeDistiller.__init__", "modulename": "sqlglot.diff", "qualname": "ChangeDistiller.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">f</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"mf\">0.6</span>, </span><span class=\"param\"><span class=\"n\">t</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"mf\">0.6</span></span>)</span>"}, "sqlglot.diff.ChangeDistiller.diff": {"fullname": "sqlglot.diff.ChangeDistiller.diff", "modulename": "sqlglot.diff", "qualname": "ChangeDistiller.diff", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">source</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span>,</span><span class=\"param\">\t<span class=\"n\">target</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span>,</span><span class=\"param\">\t<span class=\"n\">matchings</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">]]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">diff</span><span class=\"o\">.</span><span class=\"n\">Insert</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">diff</span><span class=\"o\">.</span><span class=\"n\">Remove</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">diff</span><span class=\"o\">.</span><span class=\"n\">Move</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">diff</span><span class=\"o\">.</span><span class=\"n\">Update</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">diff</span><span class=\"o\">.</span><span class=\"n\">Keep</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "sqlglot.errors": {"fullname": "sqlglot.errors", "modulename": "sqlglot.errors", "kind": "module", "doc": "<p></p>\n"}, "sqlglot.errors.ErrorLevel": {"fullname": "sqlglot.errors.ErrorLevel", "modulename": "sqlglot.errors", "qualname": "ErrorLevel", "kind": "class", "doc": "<p>An enumeration.</p>\n", "bases": "sqlglot.helper.AutoName"}, "sqlglot.errors.ErrorLevel.IGNORE": {"fullname": "sqlglot.errors.ErrorLevel.IGNORE", "modulename": "sqlglot.errors", "qualname": "ErrorLevel.IGNORE", "kind": "variable", "doc": "<p>Ignore all errors.</p>\n", "default_value": "&lt;ErrorLevel.IGNORE: &#x27;IGNORE&#x27;&gt;"}, "sqlglot.errors.ErrorLevel.WARN": {"fullname": "sqlglot.errors.ErrorLevel.WARN", "modulename": "sqlglot.errors", "qualname": "ErrorLevel.WARN", "kind": "variable", "doc": "<p>Log all errors.</p>\n", "default_value": "&lt;ErrorLevel.WARN: &#x27;WARN&#x27;&gt;"}, "sqlglot.errors.ErrorLevel.RAISE": {"fullname": "sqlglot.errors.ErrorLevel.RAISE", "modulename": "sqlglot.errors", "qualname": "ErrorLevel.RAISE", "kind": "variable", "doc": "<p>Collect all errors and raise a single exception.</p>\n", "default_value": "&lt;ErrorLevel.RAISE: &#x27;RAISE&#x27;&gt;"}, "sqlglot.errors.ErrorLevel.IMMEDIATE": {"fullname": "sqlglot.errors.ErrorLevel.IMMEDIATE", "modulename": "sqlglot.errors", "qualname": "ErrorLevel.IMMEDIATE", "kind": "variable", "doc": "<p>Immediately raise an exception on the first error found.</p>\n", "default_value": "&lt;ErrorLevel.IMMEDIATE: &#x27;IMMEDIATE&#x27;&gt;"}, "sqlglot.errors.SqlglotError": {"fullname": "sqlglot.errors.SqlglotError", "modulename": "sqlglot.errors", "qualname": "SqlglotError", "kind": "class", "doc": "<p>Common base class for all non-exit exceptions.</p>\n", "bases": "builtins.Exception"}, "sqlglot.errors.UnsupportedError": {"fullname": "sqlglot.errors.UnsupportedError", "modulename": "sqlglot.errors", "qualname": "UnsupportedError", "kind": "class", "doc": "<p>Common base class for all non-exit exceptions.</p>\n", "bases": "SqlglotError"}, "sqlglot.errors.ParseError": {"fullname": "sqlglot.errors.ParseError", "modulename": "sqlglot.errors", "qualname": "ParseError", "kind": "class", "doc": "<p>Common base class for all non-exit exceptions.</p>\n", "bases": "SqlglotError"}, "sqlglot.errors.ParseError.__init__": {"fullname": "sqlglot.errors.ParseError.__init__", "modulename": "sqlglot.errors", "qualname": "ParseError.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">message</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">errors</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span>)</span>"}, "sqlglot.errors.ParseError.new": {"fullname": "sqlglot.errors.ParseError.new", "modulename": "sqlglot.errors", "qualname": "ParseError.new", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">cls</span>,</span><span class=\"param\">\t<span class=\"n\">message</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">description</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">line</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">col</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">start_context</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">highlight</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">end_context</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">into_expression</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">errors</span><span class=\"o\">.</span><span class=\"n\">ParseError</span>:</span></span>", "funcdef": "def"}, "sqlglot.errors.TokenError": {"fullname": "sqlglot.errors.TokenError", "modulename": "sqlglot.errors", "qualname": "TokenError", "kind": "class", "doc": "<p>Common base class for all non-exit exceptions.</p>\n", "bases": "SqlglotError"}, "sqlglot.errors.OptimizeError": {"fullname": "sqlglot.errors.OptimizeError", "modulename": "sqlglot.errors", "qualname": "OptimizeError", "kind": "class", "doc": "<p>Common base class for all non-exit exceptions.</p>\n", "bases": "SqlglotError"}, "sqlglot.errors.SchemaError": {"fullname": "sqlglot.errors.SchemaError", "modulename": "sqlglot.errors", "qualname": "SchemaError", "kind": "class", "doc": "<p>Common base class for all non-exit exceptions.</p>\n", "bases": "SqlglotError"}, "sqlglot.errors.ExecuteError": {"fullname": "sqlglot.errors.ExecuteError", "modulename": "sqlglot.errors", "qualname": "ExecuteError", "kind": "class", "doc": "<p>Common base class for all non-exit exceptions.</p>\n", "bases": "SqlglotError"}, "sqlglot.errors.concat_messages": {"fullname": "sqlglot.errors.concat_messages", "modulename": "sqlglot.errors", "qualname": "concat_messages", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">errors</span><span class=\"p\">:</span> <span class=\"n\">Sequence</span><span class=\"p\">[</span><span class=\"n\">Any</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"n\">maximum</span><span class=\"p\">:</span> <span class=\"nb\">int</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.errors.merge_errors": {"fullname": "sqlglot.errors.merge_errors", "modulename": "sqlglot.errors", "qualname": "merge_errors", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">errors</span><span class=\"p\">:</span> <span class=\"n\">Sequence</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">errors</span><span class=\"o\">.</span><span class=\"n\">ParseError</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "sqlglot.executor": {"fullname": "sqlglot.executor", "modulename": "sqlglot.executor", "kind": "module", "doc": "<h1 id=\"writing-a-python-sql-engine-from-scratch\">Writing a Python SQL engine from scratch</h1>\n\n<p><a href=\"https://www.linkedin.com/in/toby-mao/\">Toby Mao</a></p>\n\n<h2 id=\"introduction\">Introduction</h2>\n\n<p>When I first started writing SQLGlot in early 2021, my goal was just to translate SQL queries from SparkSQL to Presto and vice versa. However, over the last year and a half, I've ended up with a full-fledged SQL engine. SQLGlot can now parse and transpile between <a href=\"https://github.com/tobymao/sqlglot/blob/main/sqlglot/dialects/__init__.py\">18 SQL dialects</a> and can execute all 24 <a href=\"https://www.tpc.org/tpch/\">TPC-H</a> SQL queries. The parser and engine are all written from scratch using Python.</p>\n\n<p>This post will cover <a href=\"#why\">why</a> I went through the effort of creating a Python SQL engine and <a href=\"#how\">how</a> a simple query goes from a string to actually transforming data. The following steps are briefly summarized:</p>\n\n<ul>\n<li><a href=\"#tokenizing\">Tokenizing</a></li>\n<li><a href=\"#parsing\">Parsing</a></li>\n<li><a href=\"#optimizing\">Optimizing</a></li>\n<li><a href=\"#planning\">Planning</a></li>\n<li><a href=\"#executing\">Executing</a></li>\n</ul>\n\n<h2 id=\"why\">Why?</h2>\n\n<p>I started working on SQLGlot because of my work on the <a href=\"https://netflixtechblog.com/reimagining-experimentation-analysis-at-netflix-71356393af21\">experimentation and metrics platform</a> at Netflix, where I built tools that allowed data scientists to define and compute SQL-based metrics. Netflix relied on multiple engines to query data (Spark, Presto, and Druid), so my team built the metrics platform around <a href=\"https://github.com/kayak/pypika\">PyPika</a>, a Python SQL query builder. This way, definitions could be reused across multiple engines. However, it became quickly apparent that writing python code to programmatically generate SQL was challenging for data scientists, especially those with academic backgrounds, since they were mostly familiar with R and SQL. At the time, the only Python SQL parser was <a href=\"[https://github.com/andialbrecht/sqlparse\">sqlparse</a>, which is not actually a parser but a tokenizer, so having users write raw SQL into the platform wasn't really an option. Some time later, I randomly stumbled across <a href=\"https://craftinginterpreters.com/\">Crafting Interpreters</a> and realized that I could use it as a guide towards creating my own SQL parser/transpiler.</p>\n\n<p>Why did I do this? Isn't a Python SQL engine going to be extremely slow?</p>\n\n<p>The main reason why I ended up building a SQL engine was...just for <strong>entertainment</strong>. It's been fun learning about all the things required to actually run a SQL query, and seeing it actually work is extremely rewarding. Before SQLGlot, I had zero experience with lexers, parsers, or compilers.</p>\n\n<p>In terms of practical use cases, I planned to use the Python SQL engine for unit testing SQL pipelines. Big data pipelines are tough to test because many of the engines are not open source and cannot be run locally. With SQLGlot, you can take a SQL query targeting a warehouse such as <a href=\"https://www.snowflake.com/en/\">Snowflake</a> and seamlessly run it in CI on mock Python data. It's easy to mock data and create arbitrary <a href=\"https://en.wikipedia.org/wiki/User-defined_function\">UDFs</a> because everything is just Python. Although the implementation is slow and unsuitable for large amounts of data (&gt; 1 million rows), there's very little overhead/startup and you can run queries on test data in a couple of milliseconds.</p>\n\n<p>Finally, the components that have been built to support execution can be used as a <strong>foundation</strong> for a faster engine. I'm inspired by what <a href=\"https://github.com/apache/calcite\">Apache Calcite</a> has done for the JVM world. Even though Python is commonly used for data, there hasn't been a Calcite for Python. So, you could say that SQLGlot aims to be that framework. For example, it wouldn't take much work to replace the Python execution engine with numpy/pandas/arrow to become a respectably-performing query engine. The implementation would be able to leverage the parser, optimizer, and logical planner, only needing to implement physical execution. There is a lot of work in the Python ecosystem around high performance vectorized computation, which I think could benefit from a pure Python-based <a href=\"https://en.wikipedia.org/wiki/Abstract_syntax_tree\">AST</a>/<a href=\"https://en.wikipedia.org/wiki/Query_plan\">plan</a>. Parsing and planning doesn't have to be fast when the bottleneck of running queries is processing terabytes of data. So, having a Python-based ecosystem around SQL is beneficial given the ease of development in Python, despite not having bare metal performance.</p>\n\n<p>Parts of SQLGlot's toolkit are being used today by the following:</p>\n\n<ul>\n<li><a href=\"https://github.com/ibis-project/ibis\">Ibis</a>: A Python library that provides a lightweight, universal interface for data wrangling.\n<ul>\n<li>Uses the Python SQL expression builder and leverages the optimizer/planner to convert SQL into dataframe operations.</li>\n</ul></li>\n<li><a href=\"https://github.com/kelsin/mysql-mimic\">mysql-mimic</a>: Pure-Python implementation of the MySQL server wire protocol\n<ul>\n<li>Parses / transforms SQL and executes INFORMATION_SCHEMA queries.</li>\n</ul></li>\n<li><a href=\"https://github.com/marsupialtail/quokka\">Quokka</a>: Push-based vectorized query engine\n<ul>\n<li>Parse and optimizes SQL.</li>\n</ul></li>\n<li><a href=\"https://github.com/moj-analytical-services/splink\">Splink</a>: Fast, accurate and scalable probabilistic data linkage using your choice of SQL backend.\n<ul>\n<li>Transpiles queries.</li>\n</ul></li>\n</ul>\n\n<h2 id=\"how\">How?</h2>\n\n<p>There are many steps involved with actually running a simple query like:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"k\">SELECT</span>\n<span class=\"w\">  </span><span class=\"n\">bar</span><span class=\"p\">.</span><span class=\"n\">a</span><span class=\"p\">,</span>\n<span class=\"w\">  </span><span class=\"n\">b</span><span class=\"w\"> </span><span class=\"o\">+</span><span class=\"w\"> </span><span class=\"mi\">1</span><span class=\"w\"> </span><span class=\"k\">AS</span><span class=\"w\"> </span><span class=\"n\">b</span>\n<span class=\"k\">FROM</span><span class=\"w\"> </span><span class=\"n\">bar</span>\n<span class=\"k\">JOIN</span><span class=\"w\"> </span><span class=\"n\">baz</span>\n<span class=\"w\">  </span><span class=\"k\">ON</span><span class=\"w\"> </span><span class=\"n\">bar</span><span class=\"p\">.</span><span class=\"n\">a</span><span class=\"w\"> </span><span class=\"o\">=</span><span class=\"w\"> </span><span class=\"n\">baz</span><span class=\"p\">.</span><span class=\"n\">a</span>\n<span class=\"k\">WHERE</span><span class=\"w\"> </span><span class=\"n\">bar</span><span class=\"p\">.</span><span class=\"n\">a</span><span class=\"w\"> </span><span class=\"o\">&gt;</span><span class=\"w\"> </span><span class=\"mi\">1</span>\n</code></pre>\n</div>\n\n<p>In this post, I'll walk through all the steps SQLGlot takes to run this query over Python objects.</p>\n\n<h2 id=\"tokenizing\">Tokenizing</h2>\n\n<p>The first step is to convert the sql string into a list of tokens. SQLGlot's tokenizer is quite simple and can be found <a href=\"https://github.com/tobymao/sqlglot/blob/main/sqlglot/tokens.py\">here</a>. In a while loop, it checks each character and either appends the character to the current token, or makes a new token.</p>\n\n<p>Running the SQLGlot tokenizer shows the output.</p>\n\n<p><img src=\"python_sql_engine_images/tokenizer.png\" alt=\"Tokenizer Output\" /></p>\n\n<p>Each keyword has been converted to a SQLGlot Token object. Each token has some metadata associated with it, like line/column information for error messages. Comments are also a part of the token, so that comments can be preserved.</p>\n\n<h2 id=\"parsing\">Parsing</h2>\n\n<p>Once a SQL statement is tokenized, we don't need to worry about white space and other formatting, so it's easier to work with. We can now convert the list of tokens into an AST. The SQLGlot <a href=\"https://github.com/tobymao/sqlglot/blob/main/sqlglot/parser.py\">parser</a> is a handwritten <a href=\"https://en.wikipedia.org/wiki/Recursive_descent_parser\">recursive descent</a> parser.</p>\n\n<p>Similar to the tokenizer, it consumes the tokens sequentially, but it instead uses a recursive algorithm. The tokens are converted into a single AST node that presents the SQL query. The SQLGlot parser was designed to support various dialects, so it contains many options for overriding parsing functionality.</p>\n\n<p><img src=\"python_sql_engine_images/parser.png\" alt=\"Parser Output\" /></p>\n\n<p>The AST is a generic representation of a given SQL query. Each dialect can override or implement its own generator, which can convert an AST object into syntatically-correct SQL.</p>\n\n<h2 id=\"optimizing\">Optimizing</h2>\n\n<p>Once we have our AST, we can transform it into an equivalent query that produces the same results more efficiently. When optimizing queries, most engines first convert the AST into a logical plan and then optimize the plan. However, I chose to <strong>optimize the AST directly</strong> for the following reasons:</p>\n\n<ol>\n<li><p>It's easier to debug and <a href=\"https://github.com/tobymao/sqlglot/blob/main/tests/fixtures/optimizer\">validate</a> the optimizations when the input and output are both SQL.</p></li>\n<li><p>Rules can be applied a la carte to transform SQL into a more desirable form.</p></li>\n<li><p>I wanted a way to generate 'canonical sql'. Having a canonical representation of SQL is useful for understanding if two queries are semantically equivalent (e.g. <code>SELECT 1 + 1</code> and  <code>SELECT 2</code>).</p></li>\n</ol>\n\n<p>I've yet to find another engine that takes this approach, but I'm quite happy with this decision. The optimizer currently does not perform any \"physical optimizations\" such as join reordering. Those are left to the execution layer, as additional statistics and information could become relevant.</p>\n\n<p><img src=\"python_sql_engine_images/optimizer.png\" alt=\"Optimizer Output\" /></p>\n\n<p>The optimizer currently has <a href=\"https://github.com/tobymao/sqlglot/tree/main/sqlglot/optimizer\">17 rules</a>. Each of these rules is applied, transforming the AST in place. The combination of these rules creates \"canonical\" sql that can then be more easily converted into a logical plan and executed.</p>\n\n<p>Some example rules are:</p>\n\n<h3 id=\"qualify_tables-and-qualify_columns\">qualify_tables and qualify_columns</h3>\n\n<ul>\n<li>Adds all db/catalog qualifiers to tables and forces an alias.</li>\n<li>Ensure each column is unambiguous and expand stars.</li>\n</ul>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"k\">SELECT</span><span class=\"w\"> </span><span class=\"o\">*</span><span class=\"w\"> </span><span class=\"k\">FROM</span><span class=\"w\"> </span><span class=\"n\">x</span><span class=\"p\">;</span>\n\n<span class=\"k\">SELECT</span><span class=\"w\"> </span><span class=\"ss\">&quot;db&quot;</span><span class=\"p\">.</span><span class=\"ss\">&quot;x&quot;</span><span class=\"w\"> </span><span class=\"k\">AS</span><span class=\"w\"> </span><span class=\"ss\">&quot;x&quot;</span><span class=\"p\">;</span>\n</code></pre>\n</div>\n\n<h3 id=\"simplify\">simplify</h3>\n\n<p>Boolean and math simplification. Check out all the <a href=\"https://github.com/tobymao/sqlglot/blob/main/tests/fixtures/optimizer/simplify.sql\">test cases</a>.</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"p\">((</span><span class=\"k\">NOT</span><span class=\"w\"> </span><span class=\"k\">FALSE</span><span class=\"p\">)</span><span class=\"w\"> </span><span class=\"k\">AND</span><span class=\"w\"> </span><span class=\"p\">(</span><span class=\"n\">x</span><span class=\"w\"> </span><span class=\"o\">=</span><span class=\"w\"> </span><span class=\"n\">x</span><span class=\"p\">))</span><span class=\"w\"> </span><span class=\"k\">AND</span><span class=\"w\"> </span><span class=\"p\">(</span><span class=\"k\">TRUE</span><span class=\"w\"> </span><span class=\"k\">OR</span><span class=\"w\"> </span><span class=\"mi\">1</span><span class=\"w\"> </span><span class=\"o\">&lt;&gt;</span><span class=\"w\"> </span><span class=\"mi\">3</span><span class=\"p\">);</span>\n<span class=\"n\">x</span><span class=\"w\"> </span><span class=\"o\">=</span><span class=\"w\"> </span><span class=\"n\">x</span><span class=\"p\">;</span>\n\n<span class=\"mi\">1</span><span class=\"w\"> </span><span class=\"o\">+</span><span class=\"w\"> </span><span class=\"mi\">1</span><span class=\"p\">;</span>\n<span class=\"mi\">2</span><span class=\"p\">;</span>\n</code></pre>\n</div>\n\n<h3 id=\"normalize\">normalize</h3>\n\n<p>Attempts to convert all predicates into <a href=\"https://en.wikipedia.org/wiki/Conjunctive_normal_form\">conjunctive normal form</a>.</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"c1\">-- DNF</span>\n<span class=\"p\">(</span><span class=\"n\">A</span><span class=\"w\"> </span><span class=\"k\">AND</span><span class=\"w\"> </span><span class=\"n\">B</span><span class=\"p\">)</span><span class=\"w\"> </span><span class=\"k\">OR</span><span class=\"w\"> </span><span class=\"p\">(</span><span class=\"n\">B</span><span class=\"w\"> </span><span class=\"k\">AND</span><span class=\"w\"> </span><span class=\"k\">C</span><span class=\"w\"> </span><span class=\"k\">AND</span><span class=\"w\"> </span><span class=\"n\">D</span><span class=\"p\">);</span>\n\n<span class=\"c1\">-- CNF</span>\n<span class=\"p\">(</span><span class=\"n\">A</span><span class=\"w\"> </span><span class=\"k\">OR</span><span class=\"w\"> </span><span class=\"k\">C</span><span class=\"p\">)</span><span class=\"w\"> </span><span class=\"k\">AND</span><span class=\"w\"> </span><span class=\"p\">(</span><span class=\"n\">A</span><span class=\"w\"> </span><span class=\"k\">OR</span><span class=\"w\"> </span><span class=\"n\">D</span><span class=\"p\">)</span><span class=\"w\"> </span><span class=\"k\">AND</span><span class=\"w\"> </span><span class=\"n\">B</span><span class=\"p\">;</span>\n</code></pre>\n</div>\n\n<h3 id=\"unnest_subqueries\">unnest_subqueries</h3>\n\n<p>Converts subqueries in predicates into joins.</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"c1\">-- The subquery can be converted into a left join</span>\n<span class=\"k\">SELECT</span><span class=\"w\"> </span><span class=\"o\">*</span>\n<span class=\"k\">FROM</span><span class=\"w\"> </span><span class=\"n\">x</span><span class=\"w\"> </span><span class=\"k\">AS</span><span class=\"w\"> </span><span class=\"n\">x</span>\n<span class=\"k\">WHERE</span><span class=\"w\"> </span><span class=\"p\">(</span>\n<span class=\"w\">  </span><span class=\"k\">SELECT</span><span class=\"w\"> </span><span class=\"n\">y</span><span class=\"p\">.</span><span class=\"n\">a</span><span class=\"w\"> </span><span class=\"k\">AS</span><span class=\"w\"> </span><span class=\"n\">a</span>\n<span class=\"w\">  </span><span class=\"k\">FROM</span><span class=\"w\"> </span><span class=\"n\">y</span><span class=\"w\"> </span><span class=\"k\">AS</span><span class=\"w\"> </span><span class=\"n\">y</span>\n<span class=\"w\">  </span><span class=\"k\">WHERE</span><span class=\"w\"> </span><span class=\"n\">x</span><span class=\"p\">.</span><span class=\"n\">a</span><span class=\"w\"> </span><span class=\"o\">=</span><span class=\"w\"> </span><span class=\"n\">y</span><span class=\"p\">.</span><span class=\"n\">a</span>\n<span class=\"p\">)</span><span class=\"w\"> </span><span class=\"o\">=</span><span class=\"w\"> </span><span class=\"mi\">1</span><span class=\"p\">;</span>\n\n<span class=\"k\">SELECT</span><span class=\"w\"> </span><span class=\"o\">*</span>\n<span class=\"k\">FROM</span><span class=\"w\"> </span><span class=\"n\">x</span><span class=\"w\"> </span><span class=\"k\">AS</span><span class=\"w\"> </span><span class=\"n\">x</span>\n<span class=\"k\">LEFT</span><span class=\"w\"> </span><span class=\"k\">JOIN</span><span class=\"w\"> </span><span class=\"p\">(</span>\n<span class=\"w\">  </span><span class=\"k\">SELECT</span><span class=\"w\"> </span><span class=\"n\">y</span><span class=\"p\">.</span><span class=\"n\">a</span><span class=\"w\"> </span><span class=\"k\">AS</span><span class=\"w\"> </span><span class=\"n\">a</span>\n<span class=\"w\">  </span><span class=\"k\">FROM</span><span class=\"w\"> </span><span class=\"n\">y</span><span class=\"w\"> </span><span class=\"k\">AS</span><span class=\"w\"> </span><span class=\"n\">y</span>\n<span class=\"w\">  </span><span class=\"k\">WHERE</span><span class=\"w\"> </span><span class=\"k\">TRUE</span>\n<span class=\"w\">  </span><span class=\"k\">GROUP</span><span class=\"w\"> </span><span class=\"k\">BY</span><span class=\"w\"> </span><span class=\"n\">y</span><span class=\"p\">.</span><span class=\"n\">a</span>\n<span class=\"p\">)</span><span class=\"w\"> </span><span class=\"k\">AS</span><span class=\"w\"> </span><span class=\"ss\">&quot;_u_0&quot;</span>\n<span class=\"w\">  </span><span class=\"k\">ON</span><span class=\"w\"> </span><span class=\"n\">x</span><span class=\"p\">.</span><span class=\"n\">a</span><span class=\"w\"> </span><span class=\"o\">=</span><span class=\"w\"> </span><span class=\"ss\">&quot;_u_0&quot;</span><span class=\"p\">.</span><span class=\"n\">a</span>\n<span class=\"k\">WHERE</span><span class=\"w\"> </span><span class=\"p\">(</span><span class=\"ss\">&quot;_u_0&quot;</span><span class=\"p\">.</span><span class=\"n\">a</span><span class=\"w\"> </span><span class=\"o\">=</span><span class=\"w\"> </span><span class=\"mi\">1</span><span class=\"w\"> </span><span class=\"k\">AND</span><span class=\"w\"> </span><span class=\"k\">NOT</span><span class=\"w\"> </span><span class=\"ss\">&quot;_u_0&quot;</span><span class=\"p\">.</span><span class=\"n\">a</span><span class=\"w\"> </span><span class=\"k\">IS</span><span class=\"w\"> </span><span class=\"k\">NULL</span><span class=\"p\">)</span>\n</code></pre>\n</div>\n\n<h3 id=\"pushdown_predicates\">pushdown_predicates</h3>\n\n<p>Push down filters into the innermost query.</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"k\">SELECT</span><span class=\"w\"> </span><span class=\"o\">*</span>\n<span class=\"k\">FROM</span><span class=\"w\"> </span><span class=\"p\">(</span>\n<span class=\"w\">  </span><span class=\"k\">SELECT</span><span class=\"w\"> </span><span class=\"o\">*</span>\n<span class=\"w\">  </span><span class=\"k\">FROM</span><span class=\"w\"> </span><span class=\"n\">x</span><span class=\"w\"> </span><span class=\"k\">AS</span><span class=\"w\"> </span><span class=\"n\">x</span>\n<span class=\"p\">)</span><span class=\"w\"> </span><span class=\"k\">AS</span><span class=\"w\"> </span><span class=\"n\">y</span>\n<span class=\"k\">WHERE</span><span class=\"w\"> </span><span class=\"n\">y</span><span class=\"p\">.</span><span class=\"n\">a</span><span class=\"w\"> </span><span class=\"o\">=</span><span class=\"w\"> </span><span class=\"mi\">1</span><span class=\"p\">;</span>\n\n<span class=\"k\">SELECT</span><span class=\"w\"> </span><span class=\"o\">*</span>\n<span class=\"k\">FROM</span><span class=\"w\"> </span><span class=\"p\">(</span>\n<span class=\"w\">  </span><span class=\"k\">SELECT</span><span class=\"w\"> </span><span class=\"o\">*</span>\n<span class=\"w\">  </span><span class=\"k\">FROM</span><span class=\"w\"> </span><span class=\"n\">x</span><span class=\"w\"> </span><span class=\"k\">AS</span><span class=\"w\"> </span><span class=\"n\">x</span>\n<span class=\"w\">  </span><span class=\"k\">WHERE</span><span class=\"w\"> </span><span class=\"n\">y</span><span class=\"p\">.</span><span class=\"n\">a</span><span class=\"w\"> </span><span class=\"o\">=</span><span class=\"w\"> </span><span class=\"mi\">1</span>\n<span class=\"p\">)</span><span class=\"w\"> </span><span class=\"k\">AS</span><span class=\"w\"> </span><span class=\"n\">y</span><span class=\"w\"> </span><span class=\"k\">WHERE</span><span class=\"w\"> </span><span class=\"k\">TRUE</span>\n</code></pre>\n</div>\n\n<h3 id=\"annotate_types\">annotate_types</h3>\n\n<p>Infer all types throughout the AST given schema information and function type definitions.</p>\n\n<h2 id=\"planning\">Planning</h2>\n\n<p>After the SQL AST has been \"optimized\", it's much easier to <a href=\"https://github.com/tobymao/sqlglot/blob/main/sqlglot/planner.py\">convert into a logical plan</a>. The AST is traversed and converted into a <a href=\"https://en.wikipedia.org/wiki/Directed_acyclic_graph\">DAG</a> consisting of one of five steps. The different steps are:</p>\n\n<h3 id=\"scan\">Scan</h3>\n\n<p>Selects columns from a table, applies projections, and finally filters the table.</p>\n\n<h3 id=\"sort\">Sort</h3>\n\n<p>Sorts a table for order by expressions.</p>\n\n<h3 id=\"set\">Set</h3>\n\n<p>Applies the operators union/union all/except/intersect.</p>\n\n<h3 id=\"aggregate\">Aggregate</h3>\n\n<p>Applies an aggregation/group by.</p>\n\n<h3 id=\"join\">Join</h3>\n\n<p>Joins multiple tables together.</p>\n\n<p><img src=\"python_sql_engine_images/planner.png\" alt=\"Planner Output\" /></p>\n\n<p>The logical plan is quite simple and contains the information required to convert it into a physical plan (execution).</p>\n\n<h2 id=\"executing\">Executing</h2>\n\n<p>Finally, we can actually execute the SQL query. The <a href=\"https://github.com/tobymao/sqlglot/blob/main/sqlglot/executor/python.py\">Python engine</a> is not fast, but it's very small (~400 LOC)! It iterates the DAG with a queue and runs each step, passing each intermediary table to the next step.</p>\n\n<p>In order to keep things simple, it evaluates expressions with <code>eval</code>. Because SQLGlot was built primarily to be a transpiler, it was simple to create a \"Python SQL\" dialect. So a SQL expression <code>x + 1</code> can just be converted into <code>scope['x'] + 1</code>.</p>\n\n<p><img src=\"python_sql_engine_images/executor.png\" alt=\"Executor Output\" /></p>\n\n<h2 id=\"whats-next\">What's next</h2>\n\n<p>SQLGlot's main focus will always be on parsing/transpiling, but I plan to continue development on the execution engine. I'd like to pass <a href=\"https://www.tpc.org/tpcds/\">TPC-DS</a>. If someone doesn't beat me to it, I may even take a stab at writing a Pandas/Arrow execution engine.</p>\n\n<p>I'm hoping that over time, SQLGlot will spark the Python SQL ecosystem just like Calcite has for Java.</p>\n\n<h2 id=\"special-thanks\">Special thanks</h2>\n\n<p>SQLGlot would not be what it is without it's core contributors. In particular, the execution engine would not exist without <a href=\"https://github.com/barakalon\">Barak Alon</a> and <a href=\"https://github.com/GeorgeSittas\">George Sittas</a>.</p>\n\n<h2 id=\"get-in-touch\">Get in touch</h2>\n\n<p>If you'd like to chat more about SQLGlot, please join my <a href=\"https://tobikodata.com/slack\">Slack Channel</a>!</p>\n\n<hr />\n"}, "sqlglot.executor.execute": {"fullname": "sqlglot.executor.execute", "modulename": "sqlglot.executor", "qualname": "execute", "kind": "function", "doc": "<p>Run a sql query against data.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>sql:</strong>  a sql statement.</li>\n<li><strong>schema:</strong>  database schema.\nThis can either be an instance of <code>Schema</code> or a mapping in one of the following forms:\n<ol>\n<li>{table: {col: type}}</li>\n<li>{db: {table: {col: type}}}</li>\n<li>{catalog: {db: {table: {col: type}}}}</li>\n</ol></li>\n<li><strong>read:</strong>  the SQL dialect to apply during parsing (eg. \"spark\", \"hive\", \"presto\", \"mysql\").</li>\n<li><strong>tables:</strong>  additional tables to register.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>Simple columnar data structure.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">sql</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span>,</span><span class=\"param\">\t<span class=\"n\">schema</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">schema</span><span class=\"o\">.</span><span class=\"n\">Schema</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">read</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">tables</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">executor</span><span class=\"o\">.</span><span class=\"n\">table</span><span class=\"o\">.</span><span class=\"n\">Table</span>:</span></span>", "funcdef": "def"}, "sqlglot.executor.context": {"fullname": "sqlglot.executor.context", "modulename": "sqlglot.executor.context", "kind": "module", "doc": "<p></p>\n"}, "sqlglot.executor.context.Context": {"fullname": "sqlglot.executor.context.Context", "modulename": "sqlglot.executor.context", "qualname": "Context", "kind": "class", "doc": "<p>Execution context for sql expressions.</p>\n\n<p>Context is used to hold relevant data tables which can then be queried on with eval.</p>\n\n<p>References to columns can either be scalar or vectors. When set_row is used, column references\nevaluate to scalars while set_range evaluates to vectors. This allows convenient and efficient\nevaluation of aggregation functions.</p>\n"}, "sqlglot.executor.context.Context.__init__": {"fullname": "sqlglot.executor.context.Context.__init__", "modulename": "sqlglot.executor.context", "qualname": "Context.__init__", "kind": "function", "doc": "<p>Args\n    tables: representing the scope of the current execution context.\n    env: dictionary of functions within the execution context.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">tables</span><span class=\"p\">:</span> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">executor</span><span class=\"o\">.</span><span class=\"n\">table</span><span class=\"o\">.</span><span class=\"n\">Table</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">env</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span>)</span>"}, "sqlglot.executor.context.Context.eval": {"fullname": "sqlglot.executor.context.Context.eval", "modulename": "sqlglot.executor.context", "qualname": "Context.eval", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">code</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlglot.executor.context.Context.eval_tuple": {"fullname": "sqlglot.executor.context.Context.eval_tuple", "modulename": "sqlglot.executor.context", "qualname": "Context.eval_tuple", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">codes</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlglot.executor.context.Context.add_columns": {"fullname": "sqlglot.executor.context.Context.add_columns", "modulename": "sqlglot.executor.context", "qualname": "Context.add_columns", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">*</span><span class=\"n\">columns</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "sqlglot.executor.context.Context.table_iter": {"fullname": "sqlglot.executor.context.Context.table_iter", "modulename": "sqlglot.executor.context", "qualname": "Context.table_iter", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">table</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Iterator</span><span class=\"p\">[</span><span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">executor</span><span class=\"o\">.</span><span class=\"n\">table</span><span class=\"o\">.</span><span class=\"n\">TableIter</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">executor</span><span class=\"o\">.</span><span class=\"n\">context</span><span class=\"o\">.</span><span class=\"n\">Context</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "sqlglot.executor.context.Context.filter": {"fullname": "sqlglot.executor.context.Context.filter", "modulename": "sqlglot.executor.context", "qualname": "Context.filter", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">condition</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "sqlglot.executor.context.Context.sort": {"fullname": "sqlglot.executor.context.Context.sort", "modulename": "sqlglot.executor.context", "qualname": "Context.sort", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">key</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "sqlglot.executor.context.Context.set_row": {"fullname": "sqlglot.executor.context.Context.set_row", "modulename": "sqlglot.executor.context", "qualname": "Context.set_row", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">row</span><span class=\"p\">:</span> <span class=\"n\">Tuple</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "sqlglot.executor.context.Context.set_index": {"fullname": "sqlglot.executor.context.Context.set_index", "modulename": "sqlglot.executor.context", "qualname": "Context.set_index", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">index</span><span class=\"p\">:</span> <span class=\"nb\">int</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "sqlglot.executor.context.Context.set_range": {"fullname": "sqlglot.executor.context.Context.set_range", "modulename": "sqlglot.executor.context", "qualname": "Context.set_range", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">start</span><span class=\"p\">:</span> <span class=\"nb\">int</span>, </span><span class=\"param\"><span class=\"n\">end</span><span class=\"p\">:</span> <span class=\"nb\">int</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "sqlglot.executor.env": {"fullname": "sqlglot.executor.env", "modulename": "sqlglot.executor.env", "kind": "module", "doc": "<p></p>\n"}, "sqlglot.executor.env.reverse_key": {"fullname": "sqlglot.executor.env.reverse_key", "modulename": "sqlglot.executor.env", "qualname": "reverse_key", "kind": "class", "doc": "<p></p>\n"}, "sqlglot.executor.env.reverse_key.__init__": {"fullname": "sqlglot.executor.env.reverse_key.__init__", "modulename": "sqlglot.executor.env", "qualname": "reverse_key.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">obj</span></span>)</span>"}, "sqlglot.executor.env.filter_nulls": {"fullname": "sqlglot.executor.env.filter_nulls", "modulename": "sqlglot.executor.env", "qualname": "filter_nulls", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">func</span>, </span><span class=\"param\"><span class=\"n\">empty_null</span><span class=\"o\">=</span><span class=\"kc\">True</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlglot.executor.env.null_if_any": {"fullname": "sqlglot.executor.env.null_if_any", "modulename": "sqlglot.executor.env", "qualname": "null_if_any", "kind": "function", "doc": "<p>Decorator that makes a function return <code>None</code> if any of the <code>required</code> arguments are <code>None</code>.</p>\n\n<p>This also supports decoration with no arguments, e.g.:</p>\n\n<pre><code>@null_if_any\ndef foo(a, b): ...\n</code></pre>\n\n<p>In which case all arguments are required.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"o\">*</span><span class=\"n\">required</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlglot.executor.env.str_position": {"fullname": "sqlglot.executor.env.str_position", "modulename": "sqlglot.executor.env", "qualname": "str_position", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">substr</span>, </span><span class=\"param\"><span class=\"n\">this</span>, </span><span class=\"param\"><span class=\"n\">position</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlglot.executor.env.substring": {"fullname": "sqlglot.executor.env.substring", "modulename": "sqlglot.executor.env", "qualname": "substring", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">this</span>, </span><span class=\"param\"><span class=\"n\">start</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">length</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlglot.executor.env.cast": {"fullname": "sqlglot.executor.env.cast", "modulename": "sqlglot.executor.env", "qualname": "cast", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">this</span>, </span><span class=\"param\"><span class=\"n\">to</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlglot.executor.env.ordered": {"fullname": "sqlglot.executor.env.ordered", "modulename": "sqlglot.executor.env", "qualname": "ordered", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">this</span>, </span><span class=\"param\"><span class=\"n\">desc</span>, </span><span class=\"param\"><span class=\"n\">nulls_first</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlglot.executor.env.interval": {"fullname": "sqlglot.executor.env.interval", "modulename": "sqlglot.executor.env", "qualname": "interval", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">this</span>, </span><span class=\"param\"><span class=\"n\">unit</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlglot.executor.python": {"fullname": "sqlglot.executor.python", "modulename": "sqlglot.executor.python", "kind": "module", "doc": "<p></p>\n"}, "sqlglot.executor.python.PythonExecutor": {"fullname": "sqlglot.executor.python.PythonExecutor", "modulename": "sqlglot.executor.python", "qualname": "PythonExecutor", "kind": "class", "doc": "<p></p>\n"}, "sqlglot.executor.python.PythonExecutor.__init__": {"fullname": "sqlglot.executor.python.PythonExecutor.__init__", "modulename": "sqlglot.executor.python", "qualname": "PythonExecutor.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">env</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">tables</span><span class=\"o\">=</span><span class=\"kc\">None</span></span>)</span>"}, "sqlglot.executor.python.PythonExecutor.execute": {"fullname": "sqlglot.executor.python.PythonExecutor.execute", "modulename": "sqlglot.executor.python", "qualname": "PythonExecutor.execute", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">plan</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlglot.executor.python.PythonExecutor.generate": {"fullname": "sqlglot.executor.python.PythonExecutor.generate", "modulename": "sqlglot.executor.python", "qualname": "PythonExecutor.generate", "kind": "function", "doc": "<p>Convert a SQL expression into literal Python code and compile it into bytecode.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">expression</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlglot.executor.python.PythonExecutor.generate_tuple": {"fullname": "sqlglot.executor.python.PythonExecutor.generate_tuple", "modulename": "sqlglot.executor.python", "qualname": "PythonExecutor.generate_tuple", "kind": "function", "doc": "<p>Convert an array of SQL expressions into tuple of Python byte code.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">expressions</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlglot.executor.python.PythonExecutor.context": {"fullname": "sqlglot.executor.python.PythonExecutor.context", "modulename": "sqlglot.executor.python", "qualname": "PythonExecutor.context", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">tables</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlglot.executor.python.PythonExecutor.table": {"fullname": "sqlglot.executor.python.PythonExecutor.table", "modulename": "sqlglot.executor.python", "qualname": "PythonExecutor.table", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">expressions</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlglot.executor.python.PythonExecutor.scan": {"fullname": "sqlglot.executor.python.PythonExecutor.scan", "modulename": "sqlglot.executor.python", "qualname": "PythonExecutor.scan", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">step</span>, </span><span class=\"param\"><span class=\"n\">context</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlglot.executor.python.PythonExecutor.static": {"fullname": "sqlglot.executor.python.PythonExecutor.static", "modulename": "sqlglot.executor.python", "qualname": "PythonExecutor.static", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlglot.executor.python.PythonExecutor.scan_table": {"fullname": "sqlglot.executor.python.PythonExecutor.scan_table", "modulename": "sqlglot.executor.python", "qualname": "PythonExecutor.scan_table", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">step</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlglot.executor.python.PythonExecutor.scan_csv": {"fullname": "sqlglot.executor.python.PythonExecutor.scan_csv", "modulename": "sqlglot.executor.python", "qualname": "PythonExecutor.scan_csv", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">step</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlglot.executor.python.PythonExecutor.join": {"fullname": "sqlglot.executor.python.PythonExecutor.join", "modulename": "sqlglot.executor.python", "qualname": "PythonExecutor.join", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">step</span>, </span><span class=\"param\"><span class=\"n\">context</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlglot.executor.python.PythonExecutor.nested_loop_join": {"fullname": "sqlglot.executor.python.PythonExecutor.nested_loop_join", "modulename": "sqlglot.executor.python", "qualname": "PythonExecutor.nested_loop_join", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">_join</span>, </span><span class=\"param\"><span class=\"n\">source_context</span>, </span><span class=\"param\"><span class=\"n\">join_context</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlglot.executor.python.PythonExecutor.hash_join": {"fullname": "sqlglot.executor.python.PythonExecutor.hash_join", "modulename": "sqlglot.executor.python", "qualname": "PythonExecutor.hash_join", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">join</span>, </span><span class=\"param\"><span class=\"n\">source_context</span>, </span><span class=\"param\"><span class=\"n\">join_context</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlglot.executor.python.PythonExecutor.aggregate": {"fullname": "sqlglot.executor.python.PythonExecutor.aggregate", "modulename": "sqlglot.executor.python", "qualname": "PythonExecutor.aggregate", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">step</span>, </span><span class=\"param\"><span class=\"n\">context</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlglot.executor.python.PythonExecutor.sort": {"fullname": "sqlglot.executor.python.PythonExecutor.sort", "modulename": "sqlglot.executor.python", "qualname": "PythonExecutor.sort", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">step</span>, </span><span class=\"param\"><span class=\"n\">context</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlglot.executor.python.PythonExecutor.set_operation": {"fullname": "sqlglot.executor.python.PythonExecutor.set_operation", "modulename": "sqlglot.executor.python", "qualname": "PythonExecutor.set_operation", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">step</span>, </span><span class=\"param\"><span class=\"n\">context</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlglot.executor.python.Python": {"fullname": "sqlglot.executor.python.Python", "modulename": "sqlglot.executor.python", "qualname": "Python", "kind": "class", "doc": "<p></p>\n", "bases": "sqlglot.dialects.dialect.Dialect"}, "sqlglot.executor.python.Python.Tokenizer": {"fullname": "sqlglot.executor.python.Python.Tokenizer", "modulename": "sqlglot.executor.python", "qualname": "Python.Tokenizer", "kind": "class", "doc": "<p></p>\n", "bases": "sqlglot.tokens.Tokenizer"}, "sqlglot.executor.python.Python.Generator": {"fullname": "sqlglot.executor.python.Python.Generator", "modulename": "sqlglot.executor.python", "qualname": "Python.Generator", "kind": "class", "doc": "<p>Generator interprets the given syntax tree and produces a SQL string as an output.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>time_mapping (dict):</strong>  the dictionary of custom time mappings in which the key\nrepresents a python time format and the output the target time format</li>\n<li><strong>time_trie (trie):</strong>  a trie of the time_mapping keys</li>\n<li><strong>pretty (bool):</strong>  if set to True the returned string will be formatted. Default: False.</li>\n<li><strong>quote_start (str):</strong>  specifies which starting character to use to delimit quotes. Default: '.</li>\n<li><strong>quote_end (str):</strong>  specifies which ending character to use to delimit quotes. Default: '.</li>\n<li><strong>identifier_start (str):</strong>  specifies which starting character to use to delimit identifiers. Default: \".</li>\n<li><strong>identifier_end (str):</strong>  specifies which ending character to use to delimit identifiers. Default: \".</li>\n<li><strong>bit_start (str):</strong>  specifies which starting character to use to delimit bit literals. Default: None.</li>\n<li><strong>bit_end (str):</strong>  specifies which ending character to use to delimit bit literals. Default: None.</li>\n<li><strong>hex_start (str):</strong>  specifies which starting character to use to delimit hex literals. Default: None.</li>\n<li><strong>hex_end (str):</strong>  specifies which ending character to use to delimit hex literals. Default: None.</li>\n<li><strong>byte_start (str):</strong>  specifies which starting character to use to delimit byte literals. Default: None.</li>\n<li><strong>byte_end (str):</strong>  specifies which ending character to use to delimit byte literals. Default: None.</li>\n<li><strong>raw_start (str):</strong>  specifies which starting character to use to delimit raw literals. Default: None.</li>\n<li><strong>raw_end (str):</strong>  specifies which ending character to use to delimit raw literals. Default: None.</li>\n<li><strong>identify (bool | str):</strong>  'always': always quote, 'safe': quote identifiers if they don't contain an upcase, True defaults to always.</li>\n<li><strong>normalize (bool):</strong>  if set to True all identifiers will lower cased</li>\n<li><strong>string_escape (str):</strong>  specifies a string escape character. Default: '.</li>\n<li><strong>identifier_escape (str):</strong>  specifies an identifier escape character. Default: \".</li>\n<li><strong>pad (int):</strong>  determines padding in a formatted string. Default: 2.</li>\n<li><strong>indent (int):</strong>  determines the size of indentation in a formatted string. Default: 4.</li>\n<li><strong>unnest_column_only (bool):</strong>  if true unnest table aliases are considered only as column aliases</li>\n<li><strong>normalize_functions (str):</strong>  normalize function names, \"upper\", \"lower\", or None\nDefault: \"upper\"</li>\n<li><strong>alias_post_tablesample (bool):</strong>  if the table alias comes after tablesample\nDefault: False</li>\n<li><strong>identifiers_can_start_with_digit (bool):</strong>  if an unquoted identifier can start with digit\nDefault: False</li>\n<li><strong>unsupported_level (ErrorLevel):</strong>  determines the generator's behavior when it encounters\nunsupported expressions. Default ErrorLevel.WARN.</li>\n<li><strong>null_ordering (str):</strong>  Indicates the default null ordering method to use if not explicitly set.\nOptions are \"nulls_are_small\", \"nulls_are_large\", \"nulls_are_last\".\nDefault: \"nulls_are_small\"</li>\n<li><strong>max_unsupported (int):</strong>  Maximum number of unsupported messages to include in a raised UnsupportedError.\nThis is only relevant if unsupported_level is ErrorLevel.RAISE.\nDefault: 3</li>\n<li><strong>leading_comma (bool):</strong>  if the the comma is leading or trailing in select statements\nDefault: False</li>\n<li><strong>max_text_width:</strong>  The max number of characters in a segment before creating new lines in pretty mode.\nThe default is on the smaller end because the length only represents a segment and not the true\nline length.\nDefault: 80</li>\n<li><strong>comments:</strong>  Whether or not to preserve comments in the output SQL code.\nDefault: True</li>\n</ul>\n", "bases": "sqlglot.generator.Generator"}, "sqlglot.executor.table": {"fullname": "sqlglot.executor.table", "modulename": "sqlglot.executor.table", "kind": "module", "doc": "<p></p>\n"}, "sqlglot.executor.table.Table": {"fullname": "sqlglot.executor.table.Table", "modulename": "sqlglot.executor.table", "qualname": "Table", "kind": "class", "doc": "<p></p>\n"}, "sqlglot.executor.table.Table.__init__": {"fullname": "sqlglot.executor.table.Table.__init__", "modulename": "sqlglot.executor.table", "qualname": "Table.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">columns</span>, </span><span class=\"param\"><span class=\"n\">rows</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">column_range</span><span class=\"o\">=</span><span class=\"kc\">None</span></span>)</span>"}, "sqlglot.executor.table.Table.add_columns": {"fullname": "sqlglot.executor.table.Table.add_columns", "modulename": "sqlglot.executor.table", "qualname": "Table.add_columns", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">*</span><span class=\"n\">columns</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "sqlglot.executor.table.Table.append": {"fullname": "sqlglot.executor.table.Table.append", "modulename": "sqlglot.executor.table", "qualname": "Table.append", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">row</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlglot.executor.table.Table.pop": {"fullname": "sqlglot.executor.table.Table.pop", "modulename": "sqlglot.executor.table", "qualname": "Table.pop", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlglot.executor.table.TableIter": {"fullname": "sqlglot.executor.table.TableIter", "modulename": "sqlglot.executor.table", "qualname": "TableIter", "kind": "class", "doc": "<p></p>\n"}, "sqlglot.executor.table.TableIter.__init__": {"fullname": "sqlglot.executor.table.TableIter.__init__", "modulename": "sqlglot.executor.table", "qualname": "TableIter.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">table</span></span>)</span>"}, "sqlglot.executor.table.RangeReader": {"fullname": "sqlglot.executor.table.RangeReader", "modulename": "sqlglot.executor.table", "qualname": "RangeReader", "kind": "class", "doc": "<p></p>\n"}, "sqlglot.executor.table.RangeReader.__init__": {"fullname": "sqlglot.executor.table.RangeReader.__init__", "modulename": "sqlglot.executor.table", "qualname": "RangeReader.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">table</span></span>)</span>"}, "sqlglot.executor.table.RowReader": {"fullname": "sqlglot.executor.table.RowReader", "modulename": "sqlglot.executor.table", "qualname": "RowReader", "kind": "class", "doc": "<p></p>\n"}, "sqlglot.executor.table.RowReader.__init__": {"fullname": "sqlglot.executor.table.RowReader.__init__", "modulename": "sqlglot.executor.table", "qualname": "RowReader.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">columns</span>, </span><span class=\"param\"><span class=\"n\">column_range</span><span class=\"o\">=</span><span class=\"kc\">None</span></span>)</span>"}, "sqlglot.executor.table.Tables": {"fullname": "sqlglot.executor.table.Tables", "modulename": "sqlglot.executor.table", "qualname": "Tables", "kind": "class", "doc": "<p>Abstract base class for generic types.</p>\n\n<p>A generic type is typically declared by inheriting from\nthis class parameterized with one or more type variables.\nFor example, a generic mapping type might be defined as::</p>\n\n<p>class Mapping(Generic[KT, VT]):\n      def __getitem__(self, key: KT) -> VT:\n          ...\n      # Etc.</p>\n\n<p>This class can then be used as follows::</p>\n\n<p>def lookup_name(mapping: Mapping[KT, VT], key: KT, default: VT) -> VT:\n      try:\n          return mapping[key]\n      except KeyError:\n          return default</p>\n", "bases": "sqlglot.schema.AbstractMappingSchema[sqlglot.executor.table.Table]"}, "sqlglot.executor.table.ensure_tables": {"fullname": "sqlglot.executor.table.ensure_tables", "modulename": "sqlglot.executor.table", "qualname": "ensure_tables", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">d</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">executor</span><span class=\"o\">.</span><span class=\"n\">table</span><span class=\"o\">.</span><span class=\"n\">Tables</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions": {"fullname": "sqlglot.expressions", "modulename": "sqlglot.expressions", "kind": "module", "doc": "<h2 id=\"expressions\">Expressions</h2>\n\n<p>Every AST node in SQLGlot is represented by a subclass of <code>Expression</code>.</p>\n\n<p>This module contains the implementation of all supported <code>Expression</code> types. Additionally,\nit exposes a number of helper functions, which are mainly used to programmatically build\nSQL expressions, such as <code>sqlglot.expressions.select</code>.</p>\n\n<hr />\n"}, "sqlglot.expressions.Expression": {"fullname": "sqlglot.expressions.Expression", "modulename": "sqlglot.expressions", "qualname": "Expression", "kind": "class", "doc": "<p>The base class for all expressions in a syntax tree. Each Expression encapsulates any necessary\ncontext, such as its child expressions, their names (arg keys), and whether a given child expression\nis optional or not.</p>\n\n<h6 id=\"attributes\">Attributes:</h6>\n\n<ul>\n<li><strong>key:</strong>  a unique key for each class in the Expression hierarchy. This is useful for hashing\nand representing expressions as strings.</li>\n<li><strong>arg_types:</strong>  determines what arguments (child nodes) are supported by an expression. It\nmaps arg keys to booleans that indicate whether the corresponding args are optional.</li>\n<li><strong>parent:</strong>  a reference to the parent expression (or None, in case of root expressions).</li>\n<li><strong>arg_key:</strong>  the arg key an expression is associated with, i.e. the name its parent expression\nuses to refer to it.</li>\n<li><strong>comments:</strong>  a list of comments that are associated with a given expression. This is used in\norder to preserve comments when transpiling SQL code.</li>\n<li><strong>_type:</strong>  the <code>sqlglot.expressions.DataType</code> type of an expression. This is inferred by the\noptimizer, in order to enable some transformations that require type information.</li>\n</ul>\n\n<h6 id=\"example\">Example:</h6>\n\n<blockquote>\n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"k\">class</span> <span class=\"nc\">Foo</span><span class=\"p\">(</span><span class=\"n\">Expression</span><span class=\"p\">):</span>\n<span class=\"gp\">... </span>    <span class=\"n\">arg_types</span> <span class=\"o\">=</span> <span class=\"p\">{</span><span class=\"s2\">&quot;this&quot;</span><span class=\"p\">:</span> <span class=\"kc\">True</span><span class=\"p\">,</span> <span class=\"s2\">&quot;expression&quot;</span><span class=\"p\">:</span> <span class=\"kc\">False</span><span class=\"p\">}</span>\n</code></pre>\n  </div>\n  \n  <p>The above definition informs us that Foo is an Expression that requires an argument called\n  \"this\" and may also optionally receive an argument called \"expression\".</p>\n</blockquote>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>args:</strong>  a mapping used for retrieving the arguments of an expression, given their arg keys.</li>\n</ul>\n"}, "sqlglot.expressions.Expression.__init__": {"fullname": "sqlglot.expressions.Expression.__init__", "modulename": "sqlglot.expressions", "qualname": "Expression.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"o\">**</span><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"n\">Any</span></span>)</span>"}, "sqlglot.expressions.Expression.this": {"fullname": "sqlglot.expressions.Expression.this", "modulename": "sqlglot.expressions", "qualname": "Expression.this", "kind": "variable", "doc": "<p>Retrieves the argument with key \"this\".</p>\n"}, "sqlglot.expressions.Expression.expression": {"fullname": "sqlglot.expressions.Expression.expression", "modulename": "sqlglot.expressions", "qualname": "Expression.expression", "kind": "variable", "doc": "<p>Retrieves the argument with key \"expression\".</p>\n"}, "sqlglot.expressions.Expression.expressions": {"fullname": "sqlglot.expressions.Expression.expressions", "modulename": "sqlglot.expressions", "qualname": "Expression.expressions", "kind": "variable", "doc": "<p>Retrieves the argument with key \"expressions\".</p>\n"}, "sqlglot.expressions.Expression.text": {"fullname": "sqlglot.expressions.Expression.text", "modulename": "sqlglot.expressions", "qualname": "Expression.text", "kind": "function", "doc": "<p>Returns a textual representation of the argument corresponding to \"key\". This can only be used\nfor args that are strings or leaf Expression instances, such as identifiers and literals.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">key</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.Expression.is_string": {"fullname": "sqlglot.expressions.Expression.is_string", "modulename": "sqlglot.expressions", "qualname": "Expression.is_string", "kind": "variable", "doc": "<p>Checks whether a Literal expression is a string.</p>\n", "annotation": ": bool"}, "sqlglot.expressions.Expression.is_number": {"fullname": "sqlglot.expressions.Expression.is_number", "modulename": "sqlglot.expressions", "qualname": "Expression.is_number", "kind": "variable", "doc": "<p>Checks whether a Literal expression is a number.</p>\n", "annotation": ": bool"}, "sqlglot.expressions.Expression.is_int": {"fullname": "sqlglot.expressions.Expression.is_int", "modulename": "sqlglot.expressions", "qualname": "Expression.is_int", "kind": "variable", "doc": "<p>Checks whether a Literal expression is an integer.</p>\n", "annotation": ": bool"}, "sqlglot.expressions.Expression.is_star": {"fullname": "sqlglot.expressions.Expression.is_star", "modulename": "sqlglot.expressions", "qualname": "Expression.is_star", "kind": "variable", "doc": "<p>Checks whether an expression is a star.</p>\n", "annotation": ": bool"}, "sqlglot.expressions.Expression.alias": {"fullname": "sqlglot.expressions.Expression.alias", "modulename": "sqlglot.expressions", "qualname": "Expression.alias", "kind": "variable", "doc": "<p>Returns the alias of the expression, or an empty string if it's not aliased.</p>\n", "annotation": ": str"}, "sqlglot.expressions.Expression.output_name": {"fullname": "sqlglot.expressions.Expression.output_name", "modulename": "sqlglot.expressions", "qualname": "Expression.output_name", "kind": "variable", "doc": "<p>Name of the output column if this expression is a selection.</p>\n\n<p>If the Expression has no output name, an empty string is returned.</p>\n\n<h6 id=\"example\">Example:</h6>\n\n<blockquote>\n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"kn\">from</span> <span class=\"nn\">sqlglot</span> <span class=\"kn\">import</span> <span class=\"n\">parse_one</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">parse_one</span><span class=\"p\">(</span><span class=\"s2\">&quot;SELECT a&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"p\">[</span><span class=\"mi\">0</span><span class=\"p\">]</span><span class=\"o\">.</span><span class=\"n\">output_name</span>\n<span class=\"go\">&#39;a&#39;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">parse_one</span><span class=\"p\">(</span><span class=\"s2\">&quot;SELECT b AS c&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"p\">[</span><span class=\"mi\">0</span><span class=\"p\">]</span><span class=\"o\">.</span><span class=\"n\">output_name</span>\n<span class=\"go\">&#39;c&#39;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">parse_one</span><span class=\"p\">(</span><span class=\"s2\">&quot;SELECT 1 + 2&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"p\">[</span><span class=\"mi\">0</span><span class=\"p\">]</span><span class=\"o\">.</span><span class=\"n\">output_name</span>\n<span class=\"go\">&#39;&#39;</span>\n</code></pre>\n  </div>\n</blockquote>\n", "annotation": ": str"}, "sqlglot.expressions.Expression.copy": {"fullname": "sqlglot.expressions.Expression.copy", "modulename": "sqlglot.expressions", "qualname": "Expression.copy", "kind": "function", "doc": "<p>Returns a deep copy of the expression.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlglot.expressions.Expression.add_comments": {"fullname": "sqlglot.expressions.Expression.add_comments", "modulename": "sqlglot.expressions", "qualname": "Expression.add_comments", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">comments</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.Expression.append": {"fullname": "sqlglot.expressions.Expression.append", "modulename": "sqlglot.expressions", "qualname": "Expression.append", "kind": "function", "doc": "<p>Appends value to arg_key if it's a list or sets it as a new list.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>arg_key (str):</strong>  name of the list expression arg</li>\n<li><strong>value (Any):</strong>  value to append to the list</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">arg_key</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"n\">Any</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.Expression.set": {"fullname": "sqlglot.expressions.Expression.set", "modulename": "sqlglot.expressions", "qualname": "Expression.set", "kind": "function", "doc": "<p>Sets <code>arg_key</code> to <code>value</code>.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>arg_key (str):</strong>  name of the expression arg.</li>\n<li><strong>value:</strong>  value to set the arg to.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">arg_key</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"n\">Any</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.Expression.depth": {"fullname": "sqlglot.expressions.Expression.depth", "modulename": "sqlglot.expressions", "qualname": "Expression.depth", "kind": "variable", "doc": "<p>Returns the depth of this tree.</p>\n", "annotation": ": int"}, "sqlglot.expressions.Expression.iter_expressions": {"fullname": "sqlglot.expressions.Expression.iter_expressions", "modulename": "sqlglot.expressions", "qualname": "Expression.iter_expressions", "kind": "function", "doc": "<p>Yields the key and expression for all arguments, exploding list args.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Iterator</span><span class=\"p\">[</span><span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.Expression.find": {"fullname": "sqlglot.expressions.Expression.find", "modulename": "sqlglot.expressions", "qualname": "Expression.find", "kind": "function", "doc": "<p>Returns the first node in this tree which matches at least one of\nthe specified types.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>expression_types:</strong>  the expression type(s) to match.</li>\n<li><strong>bfs:</strong>  whether to search the AST using the BFS algorithm (DFS is used if false).</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The node which matches the criteria or None if no such node was found.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">*</span><span class=\"n\">expression_types</span><span class=\"p\">:</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"o\">~</span><span class=\"n\">E</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"n\">bfs</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"o\">~</span><span class=\"n\">E</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.Expression.find_all": {"fullname": "sqlglot.expressions.Expression.find_all", "modulename": "sqlglot.expressions", "qualname": "Expression.find_all", "kind": "function", "doc": "<p>Returns a generator object which visits all nodes in this tree and only\nyields those that match at least one of the specified expression types.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>expression_types:</strong>  the expression type(s) to match.</li>\n<li><strong>bfs:</strong>  whether to search the AST using the BFS algorithm (DFS is used if false).</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The generator object.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">*</span><span class=\"n\">expression_types</span><span class=\"p\">:</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"o\">~</span><span class=\"n\">E</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"n\">bfs</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Iterator</span><span class=\"p\">[</span><span class=\"o\">~</span><span class=\"n\">E</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.Expression.find_ancestor": {"fullname": "sqlglot.expressions.Expression.find_ancestor", "modulename": "sqlglot.expressions", "qualname": "Expression.find_ancestor", "kind": "function", "doc": "<p>Returns a nearest parent matching expression_types.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>expression_types:</strong>  the expression type(s) to match.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The parent node.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">*</span><span class=\"n\">expression_types</span><span class=\"p\">:</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"o\">~</span><span class=\"n\">E</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"o\">~</span><span class=\"n\">E</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.Expression.parent_select": {"fullname": "sqlglot.expressions.Expression.parent_select", "modulename": "sqlglot.expressions", "qualname": "Expression.parent_select", "kind": "variable", "doc": "<p>Returns the parent select statement.</p>\n", "annotation": ": Optional[sqlglot.expressions.Select]"}, "sqlglot.expressions.Expression.same_parent": {"fullname": "sqlglot.expressions.Expression.same_parent", "modulename": "sqlglot.expressions", "qualname": "Expression.same_parent", "kind": "variable", "doc": "<p>Returns if the parent is the same class as itself.</p>\n", "annotation": ": bool"}, "sqlglot.expressions.Expression.root": {"fullname": "sqlglot.expressions.Expression.root", "modulename": "sqlglot.expressions", "qualname": "Expression.root", "kind": "function", "doc": "<p>Returns the root expression of this tree.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.Expression.walk": {"fullname": "sqlglot.expressions.Expression.walk", "modulename": "sqlglot.expressions", "qualname": "Expression.walk", "kind": "function", "doc": "<p>Returns a generator object which visits all nodes in this tree.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>bfs (bool):</strong>  if set to True the BFS traversal order will be applied,\notherwise the DFS traversal will be used instead.</li>\n<li><strong>prune ((node, parent, arg_key) -> bool):</strong>  callable that returns True if\nthe generator should stop traversing this branch of the tree.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>the generator object.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">bfs</span><span class=\"o\">=</span><span class=\"kc\">True</span>, </span><span class=\"param\"><span class=\"n\">prune</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlglot.expressions.Expression.dfs": {"fullname": "sqlglot.expressions.Expression.dfs", "modulename": "sqlglot.expressions", "qualname": "Expression.dfs", "kind": "function", "doc": "<p>Returns a generator object which visits all nodes in this tree in\nthe DFS (Depth-first) order.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The generator object.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">parent</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">key</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">prune</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlglot.expressions.Expression.bfs": {"fullname": "sqlglot.expressions.Expression.bfs", "modulename": "sqlglot.expressions", "qualname": "Expression.bfs", "kind": "function", "doc": "<p>Returns a generator object which visits all nodes in this tree in\nthe BFS (Breadth-first) order.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The generator object.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">prune</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlglot.expressions.Expression.unnest": {"fullname": "sqlglot.expressions.Expression.unnest", "modulename": "sqlglot.expressions", "qualname": "Expression.unnest", "kind": "function", "doc": "<p>Returns the first non parenthesis child or self.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlglot.expressions.Expression.unalias": {"fullname": "sqlglot.expressions.Expression.unalias", "modulename": "sqlglot.expressions", "qualname": "Expression.unalias", "kind": "function", "doc": "<p>Returns the inner expression if this is an Alias.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlglot.expressions.Expression.unnest_operands": {"fullname": "sqlglot.expressions.Expression.unnest_operands", "modulename": "sqlglot.expressions", "qualname": "Expression.unnest_operands", "kind": "function", "doc": "<p>Returns unnested operands as a tuple.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlglot.expressions.Expression.flatten": {"fullname": "sqlglot.expressions.Expression.flatten", "modulename": "sqlglot.expressions", "qualname": "Expression.flatten", "kind": "function", "doc": "<p>Returns a generator which yields child nodes who's parents are the same class.</p>\n\n<p>A AND B AND C -> [A, B, C]</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">unnest</span><span class=\"o\">=</span><span class=\"kc\">True</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlglot.expressions.Expression.sql": {"fullname": "sqlglot.expressions.Expression.sql", "modulename": "sqlglot.expressions", "qualname": "Expression.sql", "kind": "function", "doc": "<p>Returns SQL string representation of this tree.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>dialect:</strong>  the dialect of the output SQL string (eg. \"spark\", \"hive\", \"presto\", \"mysql\").</li>\n<li><strong>opts:</strong>  other <code>sqlglot.generator.Generator</code> options.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The SQL string.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">dialect</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">opts</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.Expression.transform": {"fullname": "sqlglot.expressions.Expression.transform", "modulename": "sqlglot.expressions", "qualname": "Expression.transform", "kind": "function", "doc": "<p>Recursively visits all tree nodes (excluding already transformed ones)\nand applies the given transformation function to each node.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>fun (function):</strong>  a function which takes a node as an argument and returns a\nnew transformed node or the same node without modifications. If the function\nreturns None, then the corresponding node will be removed from the syntax tree.</li>\n<li><strong>copy (bool):</strong>  if set to True a new tree instance is constructed, otherwise the tree is\nmodified in place.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The transformed tree.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">fun</span>, </span><span class=\"param\"><span class=\"o\">*</span><span class=\"n\">args</span>, </span><span class=\"param\"><span class=\"n\">copy</span><span class=\"o\">=</span><span class=\"kc\">True</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlglot.expressions.Expression.replace": {"fullname": "sqlglot.expressions.Expression.replace", "modulename": "sqlglot.expressions", "qualname": "Expression.replace", "kind": "function", "doc": "<p>Swap out this expression with a new expression.</p>\n\n<p>For example::</p>\n\n<pre><code>&gt;&gt;&gt; tree = Select().select(\"x\").from_(\"tbl\")\n&gt;&gt;&gt; tree.find(Column).replace(Column(this=\"y\"))\n(COLUMN this: y)\n&gt;&gt;&gt; tree.sql()\n'SELECT y FROM tbl'\n</code></pre>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>expression:</strong>  new node</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The new expression or expressions.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">expression</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlglot.expressions.Expression.pop": {"fullname": "sqlglot.expressions.Expression.pop", "modulename": "sqlglot.expressions", "qualname": "Expression.pop", "kind": "function", "doc": "<p>Remove this expression from its AST.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The popped expression.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span><span class=\"p\">:</span> <span class=\"o\">~</span><span class=\"n\">E</span></span><span class=\"return-annotation\">) -> <span class=\"o\">~</span><span class=\"n\">E</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.Expression.assert_is": {"fullname": "sqlglot.expressions.Expression.assert_is", "modulename": "sqlglot.expressions", "qualname": "Expression.assert_is", "kind": "function", "doc": "<p>Assert that this <code>Expression</code> is an instance of <code>type_</code>.</p>\n\n<p>If it is NOT an instance of <code>type_</code>, this raises an assertion error.\nOtherwise, this returns this expression.</p>\n\n<h6 id=\"examples\">Examples:</h6>\n\n<blockquote>\n  <p>This is useful for type security in chained expressions:</p>\n  \n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"kn\">import</span> <span class=\"nn\">sqlglot</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">parse_one</span><span class=\"p\">(</span><span class=\"s2\">&quot;SELECT x from y&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">assert_is</span><span class=\"p\">(</span><span class=\"n\">Select</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">select</span><span class=\"p\">(</span><span class=\"s2\">&quot;z&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">()</span>\n<span class=\"go\">&#39;SELECT x, z FROM y&#39;</span>\n</code></pre>\n  </div>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">type_</span><span class=\"p\">:</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"o\">~</span><span class=\"n\">E</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"o\">~</span><span class=\"n\">E</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.Expression.error_messages": {"fullname": "sqlglot.expressions.Expression.error_messages", "modulename": "sqlglot.expressions", "qualname": "Expression.error_messages", "kind": "function", "doc": "<p>Checks if this expression is valid (e.g. all mandatory args are set).</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>args:</strong>  a sequence of values that were used to instantiate a Func expression. This is used\nto check that the provided arguments don't exceed the function argument limit.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>A list of error messages for all possible errors that were found.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">Sequence</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.Expression.dump": {"fullname": "sqlglot.expressions.Expression.dump", "modulename": "sqlglot.expressions", "qualname": "Expression.dump", "kind": "function", "doc": "<p>Dump this Expression to a JSON-serializable dict.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlglot.expressions.Expression.load": {"fullname": "sqlglot.expressions.Expression.load", "modulename": "sqlglot.expressions", "qualname": "Expression.load", "kind": "function", "doc": "<p>Load a dict (as returned by <code>Expression.dump</code>) into an Expression instance.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span>, </span><span class=\"param\"><span class=\"n\">obj</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlglot.expressions.Condition": {"fullname": "sqlglot.expressions.Condition", "modulename": "sqlglot.expressions", "qualname": "Condition", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.Condition.and_": {"fullname": "sqlglot.expressions.Condition.and_", "modulename": "sqlglot.expressions", "qualname": "Condition.and_", "kind": "function", "doc": "<p>AND this condition with one or multiple expressions.</p>\n\n<h6 id=\"example\">Example:</h6>\n\n<blockquote>\n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">condition</span><span class=\"p\">(</span><span class=\"s2\">&quot;x=1&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">and_</span><span class=\"p\">(</span><span class=\"s2\">&quot;y=1&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">()</span>\n<span class=\"go\">&#39;x = 1 AND y = 1&#39;</span>\n</code></pre>\n  </div>\n</blockquote>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>*expressions:</strong>  the SQL code strings to parse.\nIf an <code>Expression</code> instance is passed, it will be used as-is.</li>\n<li><strong>dialect:</strong>  the dialect used to parse the input expression.</li>\n<li><strong>copy:</strong>  whether or not to copy the involved expressions (only applies to Expressions).</li>\n<li><strong>opts:</strong>  other options to use to parse the input expressions.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The new And condition.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">expressions</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">dialect</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">copy</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">opts</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Condition</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.Condition.or_": {"fullname": "sqlglot.expressions.Condition.or_", "modulename": "sqlglot.expressions", "qualname": "Condition.or_", "kind": "function", "doc": "<p>OR this condition with one or multiple expressions.</p>\n\n<h6 id=\"example\">Example:</h6>\n\n<blockquote>\n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">condition</span><span class=\"p\">(</span><span class=\"s2\">&quot;x=1&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">or_</span><span class=\"p\">(</span><span class=\"s2\">&quot;y=1&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">()</span>\n<span class=\"go\">&#39;x = 1 OR y = 1&#39;</span>\n</code></pre>\n  </div>\n</blockquote>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>*expressions:</strong>  the SQL code strings to parse.\nIf an <code>Expression</code> instance is passed, it will be used as-is.</li>\n<li><strong>dialect:</strong>  the dialect used to parse the input expression.</li>\n<li><strong>copy:</strong>  whether or not to copy the involved expressions (only applies to Expressions).</li>\n<li><strong>opts:</strong>  other options to use to parse the input expressions.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The new Or condition.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">expressions</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">dialect</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">copy</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">opts</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Condition</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.Condition.not_": {"fullname": "sqlglot.expressions.Condition.not_", "modulename": "sqlglot.expressions", "qualname": "Condition.not_", "kind": "function", "doc": "<p>Wrap this condition with NOT.</p>\n\n<h6 id=\"example\">Example:</h6>\n\n<blockquote>\n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">condition</span><span class=\"p\">(</span><span class=\"s2\">&quot;x=1&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">not_</span><span class=\"p\">()</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">()</span>\n<span class=\"go\">&#39;NOT x = 1&#39;</span>\n</code></pre>\n  </div>\n</blockquote>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>copy:</strong>  whether or not to copy this object.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The new Not instance.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">copy</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlglot.expressions.Condition.as_": {"fullname": "sqlglot.expressions.Condition.as_", "modulename": "sqlglot.expressions", "qualname": "Condition.as_", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">alias</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Identifier</span>,</span><span class=\"param\">\t<span class=\"n\">quoted</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">dialect</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">copy</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">opts</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Alias</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.Condition.isin": {"fullname": "sqlglot.expressions.Condition.isin", "modulename": "sqlglot.expressions", "qualname": "Condition.isin", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">expressions</span><span class=\"p\">:</span> <span class=\"n\">Any</span>,</span><span class=\"param\">\t<span class=\"n\">query</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">copy</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">opts</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">In</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.Condition.between": {"fullname": "sqlglot.expressions.Condition.between", "modulename": "sqlglot.expressions", "qualname": "Condition.between", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">low</span><span class=\"p\">:</span> <span class=\"n\">Any</span>,</span><span class=\"param\">\t<span class=\"n\">high</span><span class=\"p\">:</span> <span class=\"n\">Any</span>,</span><span class=\"param\">\t<span class=\"n\">copy</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">opts</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Between</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.Condition.is_": {"fullname": "sqlglot.expressions.Condition.is_", "modulename": "sqlglot.expressions", "qualname": "Condition.is_", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">other</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Is</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.Condition.like": {"fullname": "sqlglot.expressions.Condition.like", "modulename": "sqlglot.expressions", "qualname": "Condition.like", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">other</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Like</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.Condition.ilike": {"fullname": "sqlglot.expressions.Condition.ilike", "modulename": "sqlglot.expressions", "qualname": "Condition.ilike", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">other</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">ILike</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.Condition.eq": {"fullname": "sqlglot.expressions.Condition.eq", "modulename": "sqlglot.expressions", "qualname": "Condition.eq", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">other</span><span class=\"p\">:</span> <span class=\"n\">Any</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">EQ</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.Condition.neq": {"fullname": "sqlglot.expressions.Condition.neq", "modulename": "sqlglot.expressions", "qualname": "Condition.neq", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">other</span><span class=\"p\">:</span> <span class=\"n\">Any</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">NEQ</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.Condition.rlike": {"fullname": "sqlglot.expressions.Condition.rlike", "modulename": "sqlglot.expressions", "qualname": "Condition.rlike", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">other</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">RegexpLike</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.Predicate": {"fullname": "sqlglot.expressions.Predicate", "modulename": "sqlglot.expressions", "qualname": "Predicate", "kind": "class", "doc": "<p>Relationships like x = y, x &gt; 1, x &gt;= y.</p>\n", "bases": "Condition"}, "sqlglot.expressions.DerivedTable": {"fullname": "sqlglot.expressions.DerivedTable", "modulename": "sqlglot.expressions", "qualname": "DerivedTable", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.Unionable": {"fullname": "sqlglot.expressions.Unionable", "modulename": "sqlglot.expressions", "qualname": "Unionable", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.Unionable.union": {"fullname": "sqlglot.expressions.Unionable.union", "modulename": "sqlglot.expressions", "qualname": "Unionable.union", "kind": "function", "doc": "<p>Builds a UNION expression.</p>\n\n<h6 id=\"example\">Example:</h6>\n\n<blockquote>\n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"kn\">import</span> <span class=\"nn\">sqlglot</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">parse_one</span><span class=\"p\">(</span><span class=\"s2\">&quot;SELECT * FROM foo&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">union</span><span class=\"p\">(</span><span class=\"s2\">&quot;SELECT * FROM bla&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">()</span>\n<span class=\"go\">&#39;SELECT * FROM foo UNION SELECT * FROM bla&#39;</span>\n</code></pre>\n  </div>\n</blockquote>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>expression:</strong>  the SQL code string.\nIf an <code>Expression</code> instance is passed, it will be used as-is.</li>\n<li><strong>distinct:</strong>  set the DISTINCT flag if and only if this is true.</li>\n<li><strong>dialect:</strong>  the dialect used to parse the input expression.</li>\n<li><strong>opts:</strong>  other options to use to parse the input expressions.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The new Union expression.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">distinct</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">dialect</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">opts</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Unionable</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.Unionable.intersect": {"fullname": "sqlglot.expressions.Unionable.intersect", "modulename": "sqlglot.expressions", "qualname": "Unionable.intersect", "kind": "function", "doc": "<p>Builds an INTERSECT expression.</p>\n\n<h6 id=\"example\">Example:</h6>\n\n<blockquote>\n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"kn\">import</span> <span class=\"nn\">sqlglot</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">parse_one</span><span class=\"p\">(</span><span class=\"s2\">&quot;SELECT * FROM foo&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">intersect</span><span class=\"p\">(</span><span class=\"s2\">&quot;SELECT * FROM bla&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">()</span>\n<span class=\"go\">&#39;SELECT * FROM foo INTERSECT SELECT * FROM bla&#39;</span>\n</code></pre>\n  </div>\n</blockquote>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>expression:</strong>  the SQL code string.\nIf an <code>Expression</code> instance is passed, it will be used as-is.</li>\n<li><strong>distinct:</strong>  set the DISTINCT flag if and only if this is true.</li>\n<li><strong>dialect:</strong>  the dialect used to parse the input expression.</li>\n<li><strong>opts:</strong>  other options to use to parse the input expressions.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The new Intersect expression.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">distinct</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">dialect</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">opts</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Unionable</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.Unionable.except_": {"fullname": "sqlglot.expressions.Unionable.except_", "modulename": "sqlglot.expressions", "qualname": "Unionable.except_", "kind": "function", "doc": "<p>Builds an EXCEPT expression.</p>\n\n<h6 id=\"example\">Example:</h6>\n\n<blockquote>\n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"kn\">import</span> <span class=\"nn\">sqlglot</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">parse_one</span><span class=\"p\">(</span><span class=\"s2\">&quot;SELECT * FROM foo&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">except_</span><span class=\"p\">(</span><span class=\"s2\">&quot;SELECT * FROM bla&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">()</span>\n<span class=\"go\">&#39;SELECT * FROM foo EXCEPT SELECT * FROM bla&#39;</span>\n</code></pre>\n  </div>\n</blockquote>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>expression:</strong>  the SQL code string.\nIf an <code>Expression</code> instance is passed, it will be used as-is.</li>\n<li><strong>distinct:</strong>  set the DISTINCT flag if and only if this is true.</li>\n<li><strong>dialect:</strong>  the dialect used to parse the input expression.</li>\n<li><strong>opts:</strong>  other options to use to parse the input expressions.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The new Except expression.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">distinct</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">dialect</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">opts</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Unionable</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.UDTF": {"fullname": "sqlglot.expressions.UDTF", "modulename": "sqlglot.expressions", "qualname": "UDTF", "kind": "class", "doc": "<p></p>\n", "bases": "DerivedTable, Unionable"}, "sqlglot.expressions.Cache": {"fullname": "sqlglot.expressions.Cache", "modulename": "sqlglot.expressions", "qualname": "Cache", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.Uncache": {"fullname": "sqlglot.expressions.Uncache", "modulename": "sqlglot.expressions", "qualname": "Uncache", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.Create": {"fullname": "sqlglot.expressions.Create", "modulename": "sqlglot.expressions", "qualname": "Create", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.Clone": {"fullname": "sqlglot.expressions.Clone", "modulename": "sqlglot.expressions", "qualname": "Clone", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.Describe": {"fullname": "sqlglot.expressions.Describe", "modulename": "sqlglot.expressions", "qualname": "Describe", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.Pragma": {"fullname": "sqlglot.expressions.Pragma", "modulename": "sqlglot.expressions", "qualname": "Pragma", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.Set": {"fullname": "sqlglot.expressions.Set", "modulename": "sqlglot.expressions", "qualname": "Set", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.SetItem": {"fullname": "sqlglot.expressions.SetItem", "modulename": "sqlglot.expressions", "qualname": "SetItem", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.Show": {"fullname": "sqlglot.expressions.Show", "modulename": "sqlglot.expressions", "qualname": "Show", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.UserDefinedFunction": {"fullname": "sqlglot.expressions.UserDefinedFunction", "modulename": "sqlglot.expressions", "qualname": "UserDefinedFunction", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.CharacterSet": {"fullname": "sqlglot.expressions.CharacterSet", "modulename": "sqlglot.expressions", "qualname": "CharacterSet", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.With": {"fullname": "sqlglot.expressions.With", "modulename": "sqlglot.expressions", "qualname": "With", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.WithinGroup": {"fullname": "sqlglot.expressions.WithinGroup", "modulename": "sqlglot.expressions", "qualname": "WithinGroup", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.CTE": {"fullname": "sqlglot.expressions.CTE", "modulename": "sqlglot.expressions", "qualname": "CTE", "kind": "class", "doc": "<p></p>\n", "bases": "DerivedTable"}, "sqlglot.expressions.TableAlias": {"fullname": "sqlglot.expressions.TableAlias", "modulename": "sqlglot.expressions", "qualname": "TableAlias", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.BitString": {"fullname": "sqlglot.expressions.BitString", "modulename": "sqlglot.expressions", "qualname": "BitString", "kind": "class", "doc": "<p></p>\n", "bases": "Condition"}, "sqlglot.expressions.HexString": {"fullname": "sqlglot.expressions.HexString", "modulename": "sqlglot.expressions", "qualname": "HexString", "kind": "class", "doc": "<p></p>\n", "bases": "Condition"}, "sqlglot.expressions.ByteString": {"fullname": "sqlglot.expressions.ByteString", "modulename": "sqlglot.expressions", "qualname": "ByteString", "kind": "class", "doc": "<p></p>\n", "bases": "Condition"}, "sqlglot.expressions.RawString": {"fullname": "sqlglot.expressions.RawString", "modulename": "sqlglot.expressions", "qualname": "RawString", "kind": "class", "doc": "<p></p>\n", "bases": "Condition"}, "sqlglot.expressions.Column": {"fullname": "sqlglot.expressions.Column", "modulename": "sqlglot.expressions", "qualname": "Column", "kind": "class", "doc": "<p></p>\n", "bases": "Condition"}, "sqlglot.expressions.Column.output_name": {"fullname": "sqlglot.expressions.Column.output_name", "modulename": "sqlglot.expressions", "qualname": "Column.output_name", "kind": "variable", "doc": "<p>Name of the output column if this expression is a selection.</p>\n\n<p>If the Expression has no output name, an empty string is returned.</p>\n\n<h6 id=\"example\">Example:</h6>\n\n<blockquote>\n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"kn\">from</span> <span class=\"nn\">sqlglot</span> <span class=\"kn\">import</span> <span class=\"n\">parse_one</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">parse_one</span><span class=\"p\">(</span><span class=\"s2\">&quot;SELECT a&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"p\">[</span><span class=\"mi\">0</span><span class=\"p\">]</span><span class=\"o\">.</span><span class=\"n\">output_name</span>\n<span class=\"go\">&#39;a&#39;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">parse_one</span><span class=\"p\">(</span><span class=\"s2\">&quot;SELECT b AS c&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"p\">[</span><span class=\"mi\">0</span><span class=\"p\">]</span><span class=\"o\">.</span><span class=\"n\">output_name</span>\n<span class=\"go\">&#39;c&#39;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">parse_one</span><span class=\"p\">(</span><span class=\"s2\">&quot;SELECT 1 + 2&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"p\">[</span><span class=\"mi\">0</span><span class=\"p\">]</span><span class=\"o\">.</span><span class=\"n\">output_name</span>\n<span class=\"go\">&#39;&#39;</span>\n</code></pre>\n  </div>\n</blockquote>\n", "annotation": ": str"}, "sqlglot.expressions.Column.parts": {"fullname": "sqlglot.expressions.Column.parts", "modulename": "sqlglot.expressions", "qualname": "Column.parts", "kind": "variable", "doc": "<p>Return the parts of a column in order catalog, db, table, name.</p>\n", "annotation": ": List[sqlglot.expressions.Identifier]"}, "sqlglot.expressions.Column.to_dot": {"fullname": "sqlglot.expressions.Column.to_dot", "modulename": "sqlglot.expressions", "qualname": "Column.to_dot", "kind": "function", "doc": "<p>Converts the column into a dot expression.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Dot</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.ColumnPosition": {"fullname": "sqlglot.expressions.ColumnPosition", "modulename": "sqlglot.expressions", "qualname": "ColumnPosition", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.ColumnDef": {"fullname": "sqlglot.expressions.ColumnDef", "modulename": "sqlglot.expressions", "qualname": "ColumnDef", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.AlterColumn": {"fullname": "sqlglot.expressions.AlterColumn", "modulename": "sqlglot.expressions", "qualname": "AlterColumn", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.RenameTable": {"fullname": "sqlglot.expressions.RenameTable", "modulename": "sqlglot.expressions", "qualname": "RenameTable", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.SetTag": {"fullname": "sqlglot.expressions.SetTag", "modulename": "sqlglot.expressions", "qualname": "SetTag", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.Comment": {"fullname": "sqlglot.expressions.Comment", "modulename": "sqlglot.expressions", "qualname": "Comment", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.MergeTreeTTLAction": {"fullname": "sqlglot.expressions.MergeTreeTTLAction", "modulename": "sqlglot.expressions", "qualname": "MergeTreeTTLAction", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.MergeTreeTTL": {"fullname": "sqlglot.expressions.MergeTreeTTL", "modulename": "sqlglot.expressions", "qualname": "MergeTreeTTL", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.ColumnConstraint": {"fullname": "sqlglot.expressions.ColumnConstraint", "modulename": "sqlglot.expressions", "qualname": "ColumnConstraint", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.ColumnConstraintKind": {"fullname": "sqlglot.expressions.ColumnConstraintKind", "modulename": "sqlglot.expressions", "qualname": "ColumnConstraintKind", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.AutoIncrementColumnConstraint": {"fullname": "sqlglot.expressions.AutoIncrementColumnConstraint", "modulename": "sqlglot.expressions", "qualname": "AutoIncrementColumnConstraint", "kind": "class", "doc": "<p></p>\n", "bases": "ColumnConstraintKind"}, "sqlglot.expressions.CaseSpecificColumnConstraint": {"fullname": "sqlglot.expressions.CaseSpecificColumnConstraint", "modulename": "sqlglot.expressions", "qualname": "CaseSpecificColumnConstraint", "kind": "class", "doc": "<p></p>\n", "bases": "ColumnConstraintKind"}, "sqlglot.expressions.CharacterSetColumnConstraint": {"fullname": "sqlglot.expressions.CharacterSetColumnConstraint", "modulename": "sqlglot.expressions", "qualname": "CharacterSetColumnConstraint", "kind": "class", "doc": "<p></p>\n", "bases": "ColumnConstraintKind"}, "sqlglot.expressions.CheckColumnConstraint": {"fullname": "sqlglot.expressions.CheckColumnConstraint", "modulename": "sqlglot.expressions", "qualname": "CheckColumnConstraint", "kind": "class", "doc": "<p></p>\n", "bases": "ColumnConstraintKind"}, "sqlglot.expressions.CollateColumnConstraint": {"fullname": "sqlglot.expressions.CollateColumnConstraint", "modulename": "sqlglot.expressions", "qualname": "CollateColumnConstraint", "kind": "class", "doc": "<p></p>\n", "bases": "ColumnConstraintKind"}, "sqlglot.expressions.CommentColumnConstraint": {"fullname": "sqlglot.expressions.CommentColumnConstraint", "modulename": "sqlglot.expressions", "qualname": "CommentColumnConstraint", "kind": "class", "doc": "<p></p>\n", "bases": "ColumnConstraintKind"}, "sqlglot.expressions.CompressColumnConstraint": {"fullname": "sqlglot.expressions.CompressColumnConstraint", "modulename": "sqlglot.expressions", "qualname": "CompressColumnConstraint", "kind": "class", "doc": "<p></p>\n", "bases": "ColumnConstraintKind"}, "sqlglot.expressions.DateFormatColumnConstraint": {"fullname": "sqlglot.expressions.DateFormatColumnConstraint", "modulename": "sqlglot.expressions", "qualname": "DateFormatColumnConstraint", "kind": "class", "doc": "<p></p>\n", "bases": "ColumnConstraintKind"}, "sqlglot.expressions.DefaultColumnConstraint": {"fullname": "sqlglot.expressions.DefaultColumnConstraint", "modulename": "sqlglot.expressions", "qualname": "DefaultColumnConstraint", "kind": "class", "doc": "<p></p>\n", "bases": "ColumnConstraintKind"}, "sqlglot.expressions.EncodeColumnConstraint": {"fullname": "sqlglot.expressions.EncodeColumnConstraint", "modulename": "sqlglot.expressions", "qualname": "EncodeColumnConstraint", "kind": "class", "doc": "<p></p>\n", "bases": "ColumnConstraintKind"}, "sqlglot.expressions.GeneratedAsIdentityColumnConstraint": {"fullname": "sqlglot.expressions.GeneratedAsIdentityColumnConstraint", "modulename": "sqlglot.expressions", "qualname": "GeneratedAsIdentityColumnConstraint", "kind": "class", "doc": "<p></p>\n", "bases": "ColumnConstraintKind"}, "sqlglot.expressions.InlineLengthColumnConstraint": {"fullname": "sqlglot.expressions.InlineLengthColumnConstraint", "modulename": "sqlglot.expressions", "qualname": "InlineLengthColumnConstraint", "kind": "class", "doc": "<p></p>\n", "bases": "ColumnConstraintKind"}, "sqlglot.expressions.NotNullColumnConstraint": {"fullname": "sqlglot.expressions.NotNullColumnConstraint", "modulename": "sqlglot.expressions", "qualname": "NotNullColumnConstraint", "kind": "class", "doc": "<p></p>\n", "bases": "ColumnConstraintKind"}, "sqlglot.expressions.OnUpdateColumnConstraint": {"fullname": "sqlglot.expressions.OnUpdateColumnConstraint", "modulename": "sqlglot.expressions", "qualname": "OnUpdateColumnConstraint", "kind": "class", "doc": "<p></p>\n", "bases": "ColumnConstraintKind"}, "sqlglot.expressions.PrimaryKeyColumnConstraint": {"fullname": "sqlglot.expressions.PrimaryKeyColumnConstraint", "modulename": "sqlglot.expressions", "qualname": "PrimaryKeyColumnConstraint", "kind": "class", "doc": "<p></p>\n", "bases": "ColumnConstraintKind"}, "sqlglot.expressions.TitleColumnConstraint": {"fullname": "sqlglot.expressions.TitleColumnConstraint", "modulename": "sqlglot.expressions", "qualname": "TitleColumnConstraint", "kind": "class", "doc": "<p></p>\n", "bases": "ColumnConstraintKind"}, "sqlglot.expressions.UniqueColumnConstraint": {"fullname": "sqlglot.expressions.UniqueColumnConstraint", "modulename": "sqlglot.expressions", "qualname": "UniqueColumnConstraint", "kind": "class", "doc": "<p></p>\n", "bases": "ColumnConstraintKind"}, "sqlglot.expressions.UppercaseColumnConstraint": {"fullname": "sqlglot.expressions.UppercaseColumnConstraint", "modulename": "sqlglot.expressions", "qualname": "UppercaseColumnConstraint", "kind": "class", "doc": "<p></p>\n", "bases": "ColumnConstraintKind"}, "sqlglot.expressions.PathColumnConstraint": {"fullname": "sqlglot.expressions.PathColumnConstraint", "modulename": "sqlglot.expressions", "qualname": "PathColumnConstraint", "kind": "class", "doc": "<p></p>\n", "bases": "ColumnConstraintKind"}, "sqlglot.expressions.Constraint": {"fullname": "sqlglot.expressions.Constraint", "modulename": "sqlglot.expressions", "qualname": "Constraint", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.Delete": {"fullname": "sqlglot.expressions.Delete", "modulename": "sqlglot.expressions", "qualname": "Delete", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.Delete.delete": {"fullname": "sqlglot.expressions.Delete.delete", "modulename": "sqlglot.expressions", "qualname": "Delete.delete", "kind": "function", "doc": "<p>Create a DELETE expression or replace the table on an existing DELETE expression.</p>\n\n<h6 id=\"example\">Example:</h6>\n\n<blockquote>\n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">delete</span><span class=\"p\">(</span><span class=\"s2\">&quot;tbl&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">()</span>\n<span class=\"go\">&#39;DELETE FROM tbl&#39;</span>\n</code></pre>\n  </div>\n</blockquote>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>table:</strong>  the table from which to delete.</li>\n<li><strong>dialect:</strong>  the dialect used to parse the input expression.</li>\n<li><strong>copy:</strong>  if <code>False</code>, modify this expression instance in-place.</li>\n<li><strong>opts:</strong>  other options to use to parse the input expressions.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>Delete: the modified expression.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">table</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">dialect</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">copy</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">opts</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Delete</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.Delete.where": {"fullname": "sqlglot.expressions.Delete.where", "modulename": "sqlglot.expressions", "qualname": "Delete.where", "kind": "function", "doc": "<p>Append to or set the WHERE expressions.</p>\n\n<h6 id=\"example\">Example:</h6>\n\n<blockquote>\n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">delete</span><span class=\"p\">(</span><span class=\"s2\">&quot;tbl&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">where</span><span class=\"p\">(</span><span class=\"s2\">&quot;x = &#39;a&#39; OR x &lt; &#39;b&#39;&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">()</span>\n<span class=\"go\">&quot;DELETE FROM tbl WHERE x = &#39;a&#39; OR x &lt; &#39;b&#39;&quot;</span>\n</code></pre>\n  </div>\n</blockquote>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>*expressions:</strong>  the SQL code strings to parse.\nIf an <code>Expression</code> instance is passed, it will be used as-is.\nMultiple expressions are combined with an AND operator.</li>\n<li><strong>append:</strong>  if <code>True</code>, AND the new expressions to any existing expression.\nOtherwise, this resets the expression.</li>\n<li><strong>dialect:</strong>  the dialect used to parse the input expressions.</li>\n<li><strong>copy:</strong>  if <code>False</code>, modify this expression instance in-place.</li>\n<li><strong>opts:</strong>  other options to use to parse the input expressions.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>Delete: the modified expression.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">expressions</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">append</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">dialect</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">copy</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">opts</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Delete</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.Delete.returning": {"fullname": "sqlglot.expressions.Delete.returning", "modulename": "sqlglot.expressions", "qualname": "Delete.returning", "kind": "function", "doc": "<p>Set the RETURNING expression. Not supported by all dialects.</p>\n\n<h6 id=\"example\">Example:</h6>\n\n<blockquote>\n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">delete</span><span class=\"p\">(</span><span class=\"s2\">&quot;tbl&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">returning</span><span class=\"p\">(</span><span class=\"s2\">&quot;*&quot;</span><span class=\"p\">,</span> <span class=\"n\">dialect</span><span class=\"o\">=</span><span class=\"s2\">&quot;postgres&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">()</span>\n<span class=\"go\">&#39;DELETE FROM tbl RETURNING *&#39;</span>\n</code></pre>\n  </div>\n</blockquote>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>expression:</strong>  the SQL code strings to parse.\nIf an <code>Expression</code> instance is passed, it will be used as-is.</li>\n<li><strong>dialect:</strong>  the dialect used to parse the input expressions.</li>\n<li><strong>copy:</strong>  if <code>False</code>, modify this expression instance in-place.</li>\n<li><strong>opts:</strong>  other options to use to parse the input expressions.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>Delete: the modified expression.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">dialect</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">copy</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">opts</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Delete</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.Drop": {"fullname": "sqlglot.expressions.Drop", "modulename": "sqlglot.expressions", "qualname": "Drop", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.Filter": {"fullname": "sqlglot.expressions.Filter", "modulename": "sqlglot.expressions", "qualname": "Filter", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.Check": {"fullname": "sqlglot.expressions.Check", "modulename": "sqlglot.expressions", "qualname": "Check", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.Directory": {"fullname": "sqlglot.expressions.Directory", "modulename": "sqlglot.expressions", "qualname": "Directory", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.ForeignKey": {"fullname": "sqlglot.expressions.ForeignKey", "modulename": "sqlglot.expressions", "qualname": "ForeignKey", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.PrimaryKey": {"fullname": "sqlglot.expressions.PrimaryKey", "modulename": "sqlglot.expressions", "qualname": "PrimaryKey", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.Into": {"fullname": "sqlglot.expressions.Into", "modulename": "sqlglot.expressions", "qualname": "Into", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.From": {"fullname": "sqlglot.expressions.From", "modulename": "sqlglot.expressions", "qualname": "From", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.Having": {"fullname": "sqlglot.expressions.Having", "modulename": "sqlglot.expressions", "qualname": "Having", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.Hint": {"fullname": "sqlglot.expressions.Hint", "modulename": "sqlglot.expressions", "qualname": "Hint", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.JoinHint": {"fullname": "sqlglot.expressions.JoinHint", "modulename": "sqlglot.expressions", "qualname": "JoinHint", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.Identifier": {"fullname": "sqlglot.expressions.Identifier", "modulename": "sqlglot.expressions", "qualname": "Identifier", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.Identifier.output_name": {"fullname": "sqlglot.expressions.Identifier.output_name", "modulename": "sqlglot.expressions", "qualname": "Identifier.output_name", "kind": "variable", "doc": "<p>Name of the output column if this expression is a selection.</p>\n\n<p>If the Expression has no output name, an empty string is returned.</p>\n\n<h6 id=\"example\">Example:</h6>\n\n<blockquote>\n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"kn\">from</span> <span class=\"nn\">sqlglot</span> <span class=\"kn\">import</span> <span class=\"n\">parse_one</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">parse_one</span><span class=\"p\">(</span><span class=\"s2\">&quot;SELECT a&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"p\">[</span><span class=\"mi\">0</span><span class=\"p\">]</span><span class=\"o\">.</span><span class=\"n\">output_name</span>\n<span class=\"go\">&#39;a&#39;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">parse_one</span><span class=\"p\">(</span><span class=\"s2\">&quot;SELECT b AS c&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"p\">[</span><span class=\"mi\">0</span><span class=\"p\">]</span><span class=\"o\">.</span><span class=\"n\">output_name</span>\n<span class=\"go\">&#39;c&#39;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">parse_one</span><span class=\"p\">(</span><span class=\"s2\">&quot;SELECT 1 + 2&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"p\">[</span><span class=\"mi\">0</span><span class=\"p\">]</span><span class=\"o\">.</span><span class=\"n\">output_name</span>\n<span class=\"go\">&#39;&#39;</span>\n</code></pre>\n  </div>\n</blockquote>\n", "annotation": ": str"}, "sqlglot.expressions.Index": {"fullname": "sqlglot.expressions.Index", "modulename": "sqlglot.expressions", "qualname": "Index", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.Insert": {"fullname": "sqlglot.expressions.Insert", "modulename": "sqlglot.expressions", "qualname": "Insert", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.Insert.with_": {"fullname": "sqlglot.expressions.Insert.with_", "modulename": "sqlglot.expressions", "qualname": "Insert.with_", "kind": "function", "doc": "<p>Append to or set the common table expressions.</p>\n\n<h6 id=\"example\">Example:</h6>\n\n<blockquote>\n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">insert</span><span class=\"p\">(</span><span class=\"s2\">&quot;SELECT x FROM cte&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;t&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">with_</span><span class=\"p\">(</span><span class=\"s2\">&quot;cte&quot;</span><span class=\"p\">,</span> <span class=\"n\">as_</span><span class=\"o\">=</span><span class=\"s2\">&quot;SELECT * FROM tbl&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">()</span>\n<span class=\"go\">&#39;WITH cte AS (SELECT * FROM tbl) INSERT INTO t SELECT x FROM cte&#39;</span>\n</code></pre>\n  </div>\n</blockquote>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>alias:</strong>  the SQL code string to parse as the table name.\nIf an <code>Expression</code> instance is passed, this is used as-is.</li>\n<li><strong>as_:</strong>  the SQL code string to parse as the table expression.\nIf an <code>Expression</code> instance is passed, it will be used as-is.</li>\n<li><strong>recursive:</strong>  set the RECURSIVE part of the expression. Defaults to <code>False</code>.</li>\n<li><strong>append:</strong>  if <code>True</code>, add to any existing expressions.\nOtherwise, this resets the expressions.</li>\n<li><strong>dialect:</strong>  the dialect used to parse the input expression.</li>\n<li><strong>copy:</strong>  if <code>False</code>, modify this expression instance in-place.</li>\n<li><strong>opts:</strong>  other options to use to parse the input expressions.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The modified expression.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">alias</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">as_</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">recursive</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">append</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">dialect</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">copy</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">opts</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Insert</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.OnConflict": {"fullname": "sqlglot.expressions.OnConflict", "modulename": "sqlglot.expressions", "qualname": "OnConflict", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.Returning": {"fullname": "sqlglot.expressions.Returning", "modulename": "sqlglot.expressions", "qualname": "Returning", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.Introducer": {"fullname": "sqlglot.expressions.Introducer", "modulename": "sqlglot.expressions", "qualname": "Introducer", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.National": {"fullname": "sqlglot.expressions.National", "modulename": "sqlglot.expressions", "qualname": "National", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.LoadData": {"fullname": "sqlglot.expressions.LoadData", "modulename": "sqlglot.expressions", "qualname": "LoadData", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.Partition": {"fullname": "sqlglot.expressions.Partition", "modulename": "sqlglot.expressions", "qualname": "Partition", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.Fetch": {"fullname": "sqlglot.expressions.Fetch", "modulename": "sqlglot.expressions", "qualname": "Fetch", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.Group": {"fullname": "sqlglot.expressions.Group", "modulename": "sqlglot.expressions", "qualname": "Group", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.Lambda": {"fullname": "sqlglot.expressions.Lambda", "modulename": "sqlglot.expressions", "qualname": "Lambda", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.Limit": {"fullname": "sqlglot.expressions.Limit", "modulename": "sqlglot.expressions", "qualname": "Limit", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.Literal": {"fullname": "sqlglot.expressions.Literal", "modulename": "sqlglot.expressions", "qualname": "Literal", "kind": "class", "doc": "<p></p>\n", "bases": "Condition"}, "sqlglot.expressions.Literal.number": {"fullname": "sqlglot.expressions.Literal.number", "modulename": "sqlglot.expressions", "qualname": "Literal.number", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span>, </span><span class=\"param\"><span class=\"n\">number</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Literal</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.Literal.string": {"fullname": "sqlglot.expressions.Literal.string", "modulename": "sqlglot.expressions", "qualname": "Literal.string", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span>, </span><span class=\"param\"><span class=\"n\">string</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Literal</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.Literal.output_name": {"fullname": "sqlglot.expressions.Literal.output_name", "modulename": "sqlglot.expressions", "qualname": "Literal.output_name", "kind": "variable", "doc": "<p>Name of the output column if this expression is a selection.</p>\n\n<p>If the Expression has no output name, an empty string is returned.</p>\n\n<h6 id=\"example\">Example:</h6>\n\n<blockquote>\n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"kn\">from</span> <span class=\"nn\">sqlglot</span> <span class=\"kn\">import</span> <span class=\"n\">parse_one</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">parse_one</span><span class=\"p\">(</span><span class=\"s2\">&quot;SELECT a&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"p\">[</span><span class=\"mi\">0</span><span class=\"p\">]</span><span class=\"o\">.</span><span class=\"n\">output_name</span>\n<span class=\"go\">&#39;a&#39;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">parse_one</span><span class=\"p\">(</span><span class=\"s2\">&quot;SELECT b AS c&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"p\">[</span><span class=\"mi\">0</span><span class=\"p\">]</span><span class=\"o\">.</span><span class=\"n\">output_name</span>\n<span class=\"go\">&#39;c&#39;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">parse_one</span><span class=\"p\">(</span><span class=\"s2\">&quot;SELECT 1 + 2&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"p\">[</span><span class=\"mi\">0</span><span class=\"p\">]</span><span class=\"o\">.</span><span class=\"n\">output_name</span>\n<span class=\"go\">&#39;&#39;</span>\n</code></pre>\n  </div>\n</blockquote>\n", "annotation": ": str"}, "sqlglot.expressions.Join": {"fullname": "sqlglot.expressions.Join", "modulename": "sqlglot.expressions", "qualname": "Join", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.Join.on": {"fullname": "sqlglot.expressions.Join.on", "modulename": "sqlglot.expressions", "qualname": "Join.on", "kind": "function", "doc": "<p>Append to or set the ON expressions.</p>\n\n<h6 id=\"example\">Example:</h6>\n\n<blockquote>\n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"kn\">import</span> <span class=\"nn\">sqlglot</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">parse_one</span><span class=\"p\">(</span><span class=\"s2\">&quot;JOIN x&quot;</span><span class=\"p\">,</span> <span class=\"n\">into</span><span class=\"o\">=</span><span class=\"n\">Join</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">on</span><span class=\"p\">(</span><span class=\"s2\">&quot;y = 1&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">()</span>\n<span class=\"go\">&#39;JOIN x ON y = 1&#39;</span>\n</code></pre>\n  </div>\n</blockquote>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>*expressions:</strong>  the SQL code strings to parse.\nIf an <code>Expression</code> instance is passed, it will be used as-is.\nMultiple expressions are combined with an AND operator.</li>\n<li><strong>append:</strong>  if <code>True</code>, AND the new expressions to any existing expression.\nOtherwise, this resets the expression.</li>\n<li><strong>dialect:</strong>  the dialect used to parse the input expressions.</li>\n<li><strong>copy:</strong>  if <code>False</code>, modify this expression instance in-place.</li>\n<li><strong>opts:</strong>  other options to use to parse the input expressions.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The modified Join expression.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">expressions</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">append</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">dialect</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">copy</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">opts</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Join</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.Join.using": {"fullname": "sqlglot.expressions.Join.using", "modulename": "sqlglot.expressions", "qualname": "Join.using", "kind": "function", "doc": "<p>Append to or set the USING expressions.</p>\n\n<h6 id=\"example\">Example:</h6>\n\n<blockquote>\n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"kn\">import</span> <span class=\"nn\">sqlglot</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">parse_one</span><span class=\"p\">(</span><span class=\"s2\">&quot;JOIN x&quot;</span><span class=\"p\">,</span> <span class=\"n\">into</span><span class=\"o\">=</span><span class=\"n\">Join</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">using</span><span class=\"p\">(</span><span class=\"s2\">&quot;foo&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;bla&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">()</span>\n<span class=\"go\">&#39;JOIN x USING (foo, bla)&#39;</span>\n</code></pre>\n  </div>\n</blockquote>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>*expressions:</strong>  the SQL code strings to parse.\nIf an <code>Expression</code> instance is passed, it will be used as-is.</li>\n<li><strong>append:</strong>  if <code>True</code>, concatenate the new expressions to the existing \"using\" list.\nOtherwise, this resets the expression.</li>\n<li><strong>dialect:</strong>  the dialect used to parse the input expressions.</li>\n<li><strong>copy:</strong>  if <code>False</code>, modify this expression instance in-place.</li>\n<li><strong>opts:</strong>  other options to use to parse the input expressions.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The modified Join expression.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">expressions</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">append</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">dialect</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">copy</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">opts</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Join</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.Lateral": {"fullname": "sqlglot.expressions.Lateral", "modulename": "sqlglot.expressions", "qualname": "Lateral", "kind": "class", "doc": "<p></p>\n", "bases": "UDTF"}, "sqlglot.expressions.MatchRecognize": {"fullname": "sqlglot.expressions.MatchRecognize", "modulename": "sqlglot.expressions", "qualname": "MatchRecognize", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.Final": {"fullname": "sqlglot.expressions.Final", "modulename": "sqlglot.expressions", "qualname": "Final", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.Offset": {"fullname": "sqlglot.expressions.Offset", "modulename": "sqlglot.expressions", "qualname": "Offset", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.Order": {"fullname": "sqlglot.expressions.Order", "modulename": "sqlglot.expressions", "qualname": "Order", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.Cluster": {"fullname": "sqlglot.expressions.Cluster", "modulename": "sqlglot.expressions", "qualname": "Cluster", "kind": "class", "doc": "<p></p>\n", "bases": "Order"}, "sqlglot.expressions.Distribute": {"fullname": "sqlglot.expressions.Distribute", "modulename": "sqlglot.expressions", "qualname": "Distribute", "kind": "class", "doc": "<p></p>\n", "bases": "Order"}, "sqlglot.expressions.Sort": {"fullname": "sqlglot.expressions.Sort", "modulename": "sqlglot.expressions", "qualname": "Sort", "kind": "class", "doc": "<p></p>\n", "bases": "Order"}, "sqlglot.expressions.Ordered": {"fullname": "sqlglot.expressions.Ordered", "modulename": "sqlglot.expressions", "qualname": "Ordered", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.Property": {"fullname": "sqlglot.expressions.Property", "modulename": "sqlglot.expressions", "qualname": "Property", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.AlgorithmProperty": {"fullname": "sqlglot.expressions.AlgorithmProperty", "modulename": "sqlglot.expressions", "qualname": "AlgorithmProperty", "kind": "class", "doc": "<p></p>\n", "bases": "Property"}, "sqlglot.expressions.AutoIncrementProperty": {"fullname": "sqlglot.expressions.AutoIncrementProperty", "modulename": "sqlglot.expressions", "qualname": "AutoIncrementProperty", "kind": "class", "doc": "<p></p>\n", "bases": "Property"}, "sqlglot.expressions.BlockCompressionProperty": {"fullname": "sqlglot.expressions.BlockCompressionProperty", "modulename": "sqlglot.expressions", "qualname": "BlockCompressionProperty", "kind": "class", "doc": "<p></p>\n", "bases": "Property"}, "sqlglot.expressions.CharacterSetProperty": {"fullname": "sqlglot.expressions.CharacterSetProperty", "modulename": "sqlglot.expressions", "qualname": "CharacterSetProperty", "kind": "class", "doc": "<p></p>\n", "bases": "Property"}, "sqlglot.expressions.ChecksumProperty": {"fullname": "sqlglot.expressions.ChecksumProperty", "modulename": "sqlglot.expressions", "qualname": "ChecksumProperty", "kind": "class", "doc": "<p></p>\n", "bases": "Property"}, "sqlglot.expressions.CollateProperty": {"fullname": "sqlglot.expressions.CollateProperty", "modulename": "sqlglot.expressions", "qualname": "CollateProperty", "kind": "class", "doc": "<p></p>\n", "bases": "Property"}, "sqlglot.expressions.DataBlocksizeProperty": {"fullname": "sqlglot.expressions.DataBlocksizeProperty", "modulename": "sqlglot.expressions", "qualname": "DataBlocksizeProperty", "kind": "class", "doc": "<p></p>\n", "bases": "Property"}, "sqlglot.expressions.DefinerProperty": {"fullname": "sqlglot.expressions.DefinerProperty", "modulename": "sqlglot.expressions", "qualname": "DefinerProperty", "kind": "class", "doc": "<p></p>\n", "bases": "Property"}, "sqlglot.expressions.DistKeyProperty": {"fullname": "sqlglot.expressions.DistKeyProperty", "modulename": "sqlglot.expressions", "qualname": "DistKeyProperty", "kind": "class", "doc": "<p></p>\n", "bases": "Property"}, "sqlglot.expressions.DistStyleProperty": {"fullname": "sqlglot.expressions.DistStyleProperty", "modulename": "sqlglot.expressions", "qualname": "DistStyleProperty", "kind": "class", "doc": "<p></p>\n", "bases": "Property"}, "sqlglot.expressions.EngineProperty": {"fullname": "sqlglot.expressions.EngineProperty", "modulename": "sqlglot.expressions", "qualname": "EngineProperty", "kind": "class", "doc": "<p></p>\n", "bases": "Property"}, "sqlglot.expressions.ExecuteAsProperty": {"fullname": "sqlglot.expressions.ExecuteAsProperty", "modulename": "sqlglot.expressions", "qualname": "ExecuteAsProperty", "kind": "class", "doc": "<p></p>\n", "bases": "Property"}, "sqlglot.expressions.ExternalProperty": {"fullname": "sqlglot.expressions.ExternalProperty", "modulename": "sqlglot.expressions", "qualname": "ExternalProperty", "kind": "class", "doc": "<p></p>\n", "bases": "Property"}, "sqlglot.expressions.FallbackProperty": {"fullname": "sqlglot.expressions.FallbackProperty", "modulename": "sqlglot.expressions", "qualname": "FallbackProperty", "kind": "class", "doc": "<p></p>\n", "bases": "Property"}, "sqlglot.expressions.FileFormatProperty": {"fullname": "sqlglot.expressions.FileFormatProperty", "modulename": "sqlglot.expressions", "qualname": "FileFormatProperty", "kind": "class", "doc": "<p></p>\n", "bases": "Property"}, "sqlglot.expressions.FreespaceProperty": {"fullname": "sqlglot.expressions.FreespaceProperty", "modulename": "sqlglot.expressions", "qualname": "FreespaceProperty", "kind": "class", "doc": "<p></p>\n", "bases": "Property"}, "sqlglot.expressions.InputOutputFormat": {"fullname": "sqlglot.expressions.InputOutputFormat", "modulename": "sqlglot.expressions", "qualname": "InputOutputFormat", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.IsolatedLoadingProperty": {"fullname": "sqlglot.expressions.IsolatedLoadingProperty", "modulename": "sqlglot.expressions", "qualname": "IsolatedLoadingProperty", "kind": "class", "doc": "<p></p>\n", "bases": "Property"}, "sqlglot.expressions.JournalProperty": {"fullname": "sqlglot.expressions.JournalProperty", "modulename": "sqlglot.expressions", "qualname": "JournalProperty", "kind": "class", "doc": "<p></p>\n", "bases": "Property"}, "sqlglot.expressions.LanguageProperty": {"fullname": "sqlglot.expressions.LanguageProperty", "modulename": "sqlglot.expressions", "qualname": "LanguageProperty", "kind": "class", "doc": "<p></p>\n", "bases": "Property"}, "sqlglot.expressions.DictProperty": {"fullname": "sqlglot.expressions.DictProperty", "modulename": "sqlglot.expressions", "qualname": "DictProperty", "kind": "class", "doc": "<p></p>\n", "bases": "Property"}, "sqlglot.expressions.DictSubProperty": {"fullname": "sqlglot.expressions.DictSubProperty", "modulename": "sqlglot.expressions", "qualname": "DictSubProperty", "kind": "class", "doc": "<p></p>\n", "bases": "Property"}, "sqlglot.expressions.DictRange": {"fullname": "sqlglot.expressions.DictRange", "modulename": "sqlglot.expressions", "qualname": "DictRange", "kind": "class", "doc": "<p></p>\n", "bases": "Property"}, "sqlglot.expressions.LikeProperty": {"fullname": "sqlglot.expressions.LikeProperty", "modulename": "sqlglot.expressions", "qualname": "LikeProperty", "kind": "class", "doc": "<p></p>\n", "bases": "Property"}, "sqlglot.expressions.LocationProperty": {"fullname": "sqlglot.expressions.LocationProperty", "modulename": "sqlglot.expressions", "qualname": "LocationProperty", "kind": "class", "doc": "<p></p>\n", "bases": "Property"}, "sqlglot.expressions.LockingProperty": {"fullname": "sqlglot.expressions.LockingProperty", "modulename": "sqlglot.expressions", "qualname": "LockingProperty", "kind": "class", "doc": "<p></p>\n", "bases": "Property"}, "sqlglot.expressions.LogProperty": {"fullname": "sqlglot.expressions.LogProperty", "modulename": "sqlglot.expressions", "qualname": "LogProperty", "kind": "class", "doc": "<p></p>\n", "bases": "Property"}, "sqlglot.expressions.MaterializedProperty": {"fullname": "sqlglot.expressions.MaterializedProperty", "modulename": "sqlglot.expressions", "qualname": "MaterializedProperty", "kind": "class", "doc": "<p></p>\n", "bases": "Property"}, "sqlglot.expressions.MergeBlockRatioProperty": {"fullname": "sqlglot.expressions.MergeBlockRatioProperty", "modulename": "sqlglot.expressions", "qualname": "MergeBlockRatioProperty", "kind": "class", "doc": "<p></p>\n", "bases": "Property"}, "sqlglot.expressions.NoPrimaryIndexProperty": {"fullname": "sqlglot.expressions.NoPrimaryIndexProperty", "modulename": "sqlglot.expressions", "qualname": "NoPrimaryIndexProperty", "kind": "class", "doc": "<p></p>\n", "bases": "Property"}, "sqlglot.expressions.OnCommitProperty": {"fullname": "sqlglot.expressions.OnCommitProperty", "modulename": "sqlglot.expressions", "qualname": "OnCommitProperty", "kind": "class", "doc": "<p></p>\n", "bases": "Property"}, "sqlglot.expressions.PartitionedByProperty": {"fullname": "sqlglot.expressions.PartitionedByProperty", "modulename": "sqlglot.expressions", "qualname": "PartitionedByProperty", "kind": "class", "doc": "<p></p>\n", "bases": "Property"}, "sqlglot.expressions.ReturnsProperty": {"fullname": "sqlglot.expressions.ReturnsProperty", "modulename": "sqlglot.expressions", "qualname": "ReturnsProperty", "kind": "class", "doc": "<p></p>\n", "bases": "Property"}, "sqlglot.expressions.RowFormatProperty": {"fullname": "sqlglot.expressions.RowFormatProperty", "modulename": "sqlglot.expressions", "qualname": "RowFormatProperty", "kind": "class", "doc": "<p></p>\n", "bases": "Property"}, "sqlglot.expressions.RowFormatDelimitedProperty": {"fullname": "sqlglot.expressions.RowFormatDelimitedProperty", "modulename": "sqlglot.expressions", "qualname": "RowFormatDelimitedProperty", "kind": "class", "doc": "<p></p>\n", "bases": "Property"}, "sqlglot.expressions.RowFormatSerdeProperty": {"fullname": "sqlglot.expressions.RowFormatSerdeProperty", "modulename": "sqlglot.expressions", "qualname": "RowFormatSerdeProperty", "kind": "class", "doc": "<p></p>\n", "bases": "Property"}, "sqlglot.expressions.SchemaCommentProperty": {"fullname": "sqlglot.expressions.SchemaCommentProperty", "modulename": "sqlglot.expressions", "qualname": "SchemaCommentProperty", "kind": "class", "doc": "<p></p>\n", "bases": "Property"}, "sqlglot.expressions.SerdeProperties": {"fullname": "sqlglot.expressions.SerdeProperties", "modulename": "sqlglot.expressions", "qualname": "SerdeProperties", "kind": "class", "doc": "<p></p>\n", "bases": "Property"}, "sqlglot.expressions.SetProperty": {"fullname": "sqlglot.expressions.SetProperty", "modulename": "sqlglot.expressions", "qualname": "SetProperty", "kind": "class", "doc": "<p></p>\n", "bases": "Property"}, "sqlglot.expressions.SettingsProperty": {"fullname": "sqlglot.expressions.SettingsProperty", "modulename": "sqlglot.expressions", "qualname": "SettingsProperty", "kind": "class", "doc": "<p></p>\n", "bases": "Property"}, "sqlglot.expressions.SortKeyProperty": {"fullname": "sqlglot.expressions.SortKeyProperty", "modulename": "sqlglot.expressions", "qualname": "SortKeyProperty", "kind": "class", "doc": "<p></p>\n", "bases": "Property"}, "sqlglot.expressions.SqlSecurityProperty": {"fullname": "sqlglot.expressions.SqlSecurityProperty", "modulename": "sqlglot.expressions", "qualname": "SqlSecurityProperty", "kind": "class", "doc": "<p></p>\n", "bases": "Property"}, "sqlglot.expressions.StabilityProperty": {"fullname": "sqlglot.expressions.StabilityProperty", "modulename": "sqlglot.expressions", "qualname": "StabilityProperty", "kind": "class", "doc": "<p></p>\n", "bases": "Property"}, "sqlglot.expressions.TemporaryProperty": {"fullname": "sqlglot.expressions.TemporaryProperty", "modulename": "sqlglot.expressions", "qualname": "TemporaryProperty", "kind": "class", "doc": "<p></p>\n", "bases": "Property"}, "sqlglot.expressions.TransientProperty": {"fullname": "sqlglot.expressions.TransientProperty", "modulename": "sqlglot.expressions", "qualname": "TransientProperty", "kind": "class", "doc": "<p></p>\n", "bases": "Property"}, "sqlglot.expressions.VolatileProperty": {"fullname": "sqlglot.expressions.VolatileProperty", "modulename": "sqlglot.expressions", "qualname": "VolatileProperty", "kind": "class", "doc": "<p></p>\n", "bases": "Property"}, "sqlglot.expressions.WithDataProperty": {"fullname": "sqlglot.expressions.WithDataProperty", "modulename": "sqlglot.expressions", "qualname": "WithDataProperty", "kind": "class", "doc": "<p></p>\n", "bases": "Property"}, "sqlglot.expressions.WithJournalTableProperty": {"fullname": "sqlglot.expressions.WithJournalTableProperty", "modulename": "sqlglot.expressions", "qualname": "WithJournalTableProperty", "kind": "class", "doc": "<p></p>\n", "bases": "Property"}, "sqlglot.expressions.Properties": {"fullname": "sqlglot.expressions.Properties", "modulename": "sqlglot.expressions", "qualname": "Properties", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.Properties.Location": {"fullname": "sqlglot.expressions.Properties.Location", "modulename": "sqlglot.expressions", "qualname": "Properties.Location", "kind": "class", "doc": "<p>An enumeration.</p>\n", "bases": "sqlglot.helper.AutoName"}, "sqlglot.expressions.Properties.Location.POST_CREATE": {"fullname": "sqlglot.expressions.Properties.Location.POST_CREATE", "modulename": "sqlglot.expressions", "qualname": "Properties.Location.POST_CREATE", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Location.POST_CREATE: &#x27;POST_CREATE&#x27;&gt;"}, "sqlglot.expressions.Properties.Location.POST_NAME": {"fullname": "sqlglot.expressions.Properties.Location.POST_NAME", "modulename": "sqlglot.expressions", "qualname": "Properties.Location.POST_NAME", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Location.POST_NAME: &#x27;POST_NAME&#x27;&gt;"}, "sqlglot.expressions.Properties.Location.POST_SCHEMA": {"fullname": "sqlglot.expressions.Properties.Location.POST_SCHEMA", "modulename": "sqlglot.expressions", "qualname": "Properties.Location.POST_SCHEMA", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Location.POST_SCHEMA: &#x27;POST_SCHEMA&#x27;&gt;"}, "sqlglot.expressions.Properties.Location.POST_WITH": {"fullname": "sqlglot.expressions.Properties.Location.POST_WITH", "modulename": "sqlglot.expressions", "qualname": "Properties.Location.POST_WITH", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Location.POST_WITH: &#x27;POST_WITH&#x27;&gt;"}, "sqlglot.expressions.Properties.Location.POST_ALIAS": {"fullname": "sqlglot.expressions.Properties.Location.POST_ALIAS", "modulename": "sqlglot.expressions", "qualname": "Properties.Location.POST_ALIAS", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Location.POST_ALIAS: &#x27;POST_ALIAS&#x27;&gt;"}, "sqlglot.expressions.Properties.Location.POST_EXPRESSION": {"fullname": "sqlglot.expressions.Properties.Location.POST_EXPRESSION", "modulename": "sqlglot.expressions", "qualname": "Properties.Location.POST_EXPRESSION", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Location.POST_EXPRESSION: &#x27;POST_EXPRESSION&#x27;&gt;"}, "sqlglot.expressions.Properties.Location.POST_INDEX": {"fullname": "sqlglot.expressions.Properties.Location.POST_INDEX", "modulename": "sqlglot.expressions", "qualname": "Properties.Location.POST_INDEX", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Location.POST_INDEX: &#x27;POST_INDEX&#x27;&gt;"}, "sqlglot.expressions.Properties.Location.UNSUPPORTED": {"fullname": "sqlglot.expressions.Properties.Location.UNSUPPORTED", "modulename": "sqlglot.expressions", "qualname": "Properties.Location.UNSUPPORTED", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Location.UNSUPPORTED: &#x27;UNSUPPORTED&#x27;&gt;"}, "sqlglot.expressions.Properties.from_dict": {"fullname": "sqlglot.expressions.Properties.from_dict", "modulename": "sqlglot.expressions", "qualname": "Properties.from_dict", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span>, </span><span class=\"param\"><span class=\"n\">properties_dict</span><span class=\"p\">:</span> <span class=\"n\">Dict</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Properties</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.Qualify": {"fullname": "sqlglot.expressions.Qualify", "modulename": "sqlglot.expressions", "qualname": "Qualify", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.Return": {"fullname": "sqlglot.expressions.Return", "modulename": "sqlglot.expressions", "qualname": "Return", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.Reference": {"fullname": "sqlglot.expressions.Reference", "modulename": "sqlglot.expressions", "qualname": "Reference", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.Tuple": {"fullname": "sqlglot.expressions.Tuple", "modulename": "sqlglot.expressions", "qualname": "Tuple", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.Tuple.isin": {"fullname": "sqlglot.expressions.Tuple.isin", "modulename": "sqlglot.expressions", "qualname": "Tuple.isin", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">expressions</span><span class=\"p\">:</span> <span class=\"n\">Any</span>,</span><span class=\"param\">\t<span class=\"n\">query</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">copy</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">opts</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">In</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.Subqueryable": {"fullname": "sqlglot.expressions.Subqueryable", "modulename": "sqlglot.expressions", "qualname": "Subqueryable", "kind": "class", "doc": "<p></p>\n", "bases": "Unionable"}, "sqlglot.expressions.Subqueryable.subquery": {"fullname": "sqlglot.expressions.Subqueryable.subquery", "modulename": "sqlglot.expressions", "qualname": "Subqueryable.subquery", "kind": "function", "doc": "<p>Convert this expression to an aliased expression that can be used as a Subquery.</p>\n\n<h6 id=\"example\">Example:</h6>\n\n<blockquote>\n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">subquery</span> <span class=\"o\">=</span> <span class=\"n\">Select</span><span class=\"p\">()</span><span class=\"o\">.</span><span class=\"n\">select</span><span class=\"p\">(</span><span class=\"s2\">&quot;x&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">from_</span><span class=\"p\">(</span><span class=\"s2\">&quot;tbl&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">subquery</span><span class=\"p\">()</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">Select</span><span class=\"p\">()</span><span class=\"o\">.</span><span class=\"n\">select</span><span class=\"p\">(</span><span class=\"s2\">&quot;x&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">from_</span><span class=\"p\">(</span><span class=\"n\">subquery</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">()</span>\n<span class=\"go\">&#39;SELECT x FROM (SELECT x FROM tbl)&#39;</span>\n</code></pre>\n  </div>\n</blockquote>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>alias (str | Identifier):</strong>  an optional alias for the subquery</li>\n<li><strong>copy (bool):</strong>  if <code>False</code>, modify this expression instance in-place.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>Alias: the subquery</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">alias</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">copy</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Subquery</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.Subqueryable.limit": {"fullname": "sqlglot.expressions.Subqueryable.limit", "modulename": "sqlglot.expressions", "qualname": "Subqueryable.limit", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">dialect</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">copy</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">opts</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Select</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.Subqueryable.with_": {"fullname": "sqlglot.expressions.Subqueryable.with_", "modulename": "sqlglot.expressions", "qualname": "Subqueryable.with_", "kind": "function", "doc": "<p>Append to or set the common table expressions.</p>\n\n<h6 id=\"example\">Example:</h6>\n\n<blockquote>\n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">Select</span><span class=\"p\">()</span><span class=\"o\">.</span><span class=\"n\">with_</span><span class=\"p\">(</span><span class=\"s2\">&quot;tbl2&quot;</span><span class=\"p\">,</span> <span class=\"n\">as_</span><span class=\"o\">=</span><span class=\"s2\">&quot;SELECT * FROM tbl&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">select</span><span class=\"p\">(</span><span class=\"s2\">&quot;x&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">from_</span><span class=\"p\">(</span><span class=\"s2\">&quot;tbl2&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">()</span>\n<span class=\"go\">&#39;WITH tbl2 AS (SELECT * FROM tbl) SELECT x FROM tbl2&#39;</span>\n</code></pre>\n  </div>\n</blockquote>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>alias:</strong>  the SQL code string to parse as the table name.\nIf an <code>Expression</code> instance is passed, this is used as-is.</li>\n<li><strong>as_:</strong>  the SQL code string to parse as the table expression.\nIf an <code>Expression</code> instance is passed, it will be used as-is.</li>\n<li><strong>recursive:</strong>  set the RECURSIVE part of the expression. Defaults to <code>False</code>.</li>\n<li><strong>append:</strong>  if <code>True</code>, add to any existing expressions.\nOtherwise, this resets the expressions.</li>\n<li><strong>dialect:</strong>  the dialect used to parse the input expression.</li>\n<li><strong>copy:</strong>  if <code>False</code>, modify this expression instance in-place.</li>\n<li><strong>opts:</strong>  other options to use to parse the input expressions.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The modified expression.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">alias</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">as_</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">recursive</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">append</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">dialect</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">copy</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">opts</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Subqueryable</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.Table": {"fullname": "sqlglot.expressions.Table", "modulename": "sqlglot.expressions", "qualname": "Table", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.Table.parts": {"fullname": "sqlglot.expressions.Table.parts", "modulename": "sqlglot.expressions", "qualname": "Table.parts", "kind": "variable", "doc": "<p>Return the parts of a table in order catalog, db, table.</p>\n", "annotation": ": List[sqlglot.expressions.Identifier]"}, "sqlglot.expressions.SystemTime": {"fullname": "sqlglot.expressions.SystemTime", "modulename": "sqlglot.expressions", "qualname": "SystemTime", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.Union": {"fullname": "sqlglot.expressions.Union", "modulename": "sqlglot.expressions", "qualname": "Union", "kind": "class", "doc": "<p></p>\n", "bases": "Subqueryable"}, "sqlglot.expressions.Union.limit": {"fullname": "sqlglot.expressions.Union.limit", "modulename": "sqlglot.expressions", "qualname": "Union.limit", "kind": "function", "doc": "<p>Set the LIMIT expression.</p>\n\n<h6 id=\"example\">Example:</h6>\n\n<blockquote>\n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">select</span><span class=\"p\">(</span><span class=\"s2\">&quot;1&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">union</span><span class=\"p\">(</span><span class=\"n\">select</span><span class=\"p\">(</span><span class=\"s2\">&quot;1&quot;</span><span class=\"p\">))</span><span class=\"o\">.</span><span class=\"n\">limit</span><span class=\"p\">(</span><span class=\"mi\">1</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">()</span>\n<span class=\"go\">&#39;SELECT * FROM (SELECT 1 UNION SELECT 1) AS _l_0 LIMIT 1&#39;</span>\n</code></pre>\n  </div>\n</blockquote>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>expression:</strong>  the SQL code string to parse.\nThis can also be an integer.\nIf a <code>Limit</code> instance is passed, this is used as-is.\nIf another <code>Expression</code> instance is passed, it will be wrapped in a <code>Limit</code>.</li>\n<li><strong>dialect:</strong>  the dialect used to parse the input expression.</li>\n<li><strong>copy:</strong>  if <code>False</code>, modify this expression instance in-place.</li>\n<li><strong>opts:</strong>  other options to use to parse the input expressions.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The limited subqueryable.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">dialect</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">copy</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">opts</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Select</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.Union.select": {"fullname": "sqlglot.expressions.Union.select", "modulename": "sqlglot.expressions", "qualname": "Union.select", "kind": "function", "doc": "<p>Append to or set the SELECT of the union recursively.</p>\n\n<h6 id=\"example\">Example:</h6>\n\n<blockquote>\n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"kn\">from</span> <span class=\"nn\">sqlglot</span> <span class=\"kn\">import</span> <span class=\"n\">parse_one</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">parse_one</span><span class=\"p\">(</span><span class=\"s2\">&quot;select a from x union select a from y union select a from z&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">select</span><span class=\"p\">(</span><span class=\"s2\">&quot;b&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">()</span>\n<span class=\"go\">&#39;SELECT a, b FROM x UNION SELECT a, b FROM y UNION SELECT a, b FROM z&#39;</span>\n</code></pre>\n  </div>\n</blockquote>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>*expressions:</strong>  the SQL code strings to parse.\nIf an <code>Expression</code> instance is passed, it will be used as-is.</li>\n<li><strong>append:</strong>  if <code>True</code>, add to any existing expressions.\nOtherwise, this resets the expressions.</li>\n<li><strong>dialect:</strong>  the dialect used to parse the input expressions.</li>\n<li><strong>copy:</strong>  if <code>False</code>, modify this expression instance in-place.</li>\n<li><strong>opts:</strong>  other options to use to parse the input expressions.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>Union: the modified expression.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">expressions</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">append</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">dialect</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">copy</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">opts</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Union</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.Union.is_star": {"fullname": "sqlglot.expressions.Union.is_star", "modulename": "sqlglot.expressions", "qualname": "Union.is_star", "kind": "variable", "doc": "<p>Checks whether an expression is a star.</p>\n", "annotation": ": bool"}, "sqlglot.expressions.Except": {"fullname": "sqlglot.expressions.Except", "modulename": "sqlglot.expressions", "qualname": "Except", "kind": "class", "doc": "<p></p>\n", "bases": "Union"}, "sqlglot.expressions.Intersect": {"fullname": "sqlglot.expressions.Intersect", "modulename": "sqlglot.expressions", "qualname": "Intersect", "kind": "class", "doc": "<p></p>\n", "bases": "Union"}, "sqlglot.expressions.Unnest": {"fullname": "sqlglot.expressions.Unnest", "modulename": "sqlglot.expressions", "qualname": "Unnest", "kind": "class", "doc": "<p></p>\n", "bases": "UDTF"}, "sqlglot.expressions.Update": {"fullname": "sqlglot.expressions.Update", "modulename": "sqlglot.expressions", "qualname": "Update", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.Values": {"fullname": "sqlglot.expressions.Values", "modulename": "sqlglot.expressions", "qualname": "Values", "kind": "class", "doc": "<p></p>\n", "bases": "UDTF"}, "sqlglot.expressions.Var": {"fullname": "sqlglot.expressions.Var", "modulename": "sqlglot.expressions", "qualname": "Var", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.Schema": {"fullname": "sqlglot.expressions.Schema", "modulename": "sqlglot.expressions", "qualname": "Schema", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.Lock": {"fullname": "sqlglot.expressions.Lock", "modulename": "sqlglot.expressions", "qualname": "Lock", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.Select": {"fullname": "sqlglot.expressions.Select", "modulename": "sqlglot.expressions", "qualname": "Select", "kind": "class", "doc": "<p></p>\n", "bases": "Subqueryable"}, "sqlglot.expressions.Select.from_": {"fullname": "sqlglot.expressions.Select.from_", "modulename": "sqlglot.expressions", "qualname": "Select.from_", "kind": "function", "doc": "<p>Set the FROM expression.</p>\n\n<h6 id=\"example\">Example:</h6>\n\n<blockquote>\n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">Select</span><span class=\"p\">()</span><span class=\"o\">.</span><span class=\"n\">from_</span><span class=\"p\">(</span><span class=\"s2\">&quot;tbl&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">select</span><span class=\"p\">(</span><span class=\"s2\">&quot;x&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">()</span>\n<span class=\"go\">&#39;SELECT x FROM tbl&#39;</span>\n</code></pre>\n  </div>\n</blockquote>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>expression :</strong>  the SQL code strings to parse.\nIf a <code>From</code> instance is passed, this is used as-is.\nIf another <code>Expression</code> instance is passed, it will be wrapped in a <code>From</code>.</li>\n<li><strong>dialect:</strong>  the dialect used to parse the input expression.</li>\n<li><strong>copy:</strong>  if <code>False</code>, modify this expression instance in-place.</li>\n<li><strong>opts:</strong>  other options to use to parse the input expressions.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The modified Select expression.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">dialect</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">copy</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">opts</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Select</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.Select.group_by": {"fullname": "sqlglot.expressions.Select.group_by", "modulename": "sqlglot.expressions", "qualname": "Select.group_by", "kind": "function", "doc": "<p>Set the GROUP BY expression.</p>\n\n<h6 id=\"example\">Example:</h6>\n\n<blockquote>\n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">Select</span><span class=\"p\">()</span><span class=\"o\">.</span><span class=\"n\">from_</span><span class=\"p\">(</span><span class=\"s2\">&quot;tbl&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">select</span><span class=\"p\">(</span><span class=\"s2\">&quot;x&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;COUNT(1)&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">group_by</span><span class=\"p\">(</span><span class=\"s2\">&quot;x&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">()</span>\n<span class=\"go\">&#39;SELECT x, COUNT(1) FROM tbl GROUP BY x&#39;</span>\n</code></pre>\n  </div>\n</blockquote>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>*expressions:</strong>  the SQL code strings to parse.\nIf a <code>Group</code> instance is passed, this is used as-is.\nIf another <code>Expression</code> instance is passed, it will be wrapped in a <code>Group</code>.\nIf nothing is passed in then a group by is not applied to the expression</li>\n<li><strong>append:</strong>  if <code>True</code>, add to any existing expressions.\nOtherwise, this flattens all the <code>Group</code> expression into a single expression.</li>\n<li><strong>dialect:</strong>  the dialect used to parse the input expression.</li>\n<li><strong>copy:</strong>  if <code>False</code>, modify this expression instance in-place.</li>\n<li><strong>opts:</strong>  other options to use to parse the input expressions.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The modified Select expression.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">expressions</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">append</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">dialect</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">copy</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">opts</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Select</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.Select.order_by": {"fullname": "sqlglot.expressions.Select.order_by", "modulename": "sqlglot.expressions", "qualname": "Select.order_by", "kind": "function", "doc": "<p>Set the ORDER BY expression.</p>\n\n<h6 id=\"example\">Example:</h6>\n\n<blockquote>\n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">Select</span><span class=\"p\">()</span><span class=\"o\">.</span><span class=\"n\">from_</span><span class=\"p\">(</span><span class=\"s2\">&quot;tbl&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">select</span><span class=\"p\">(</span><span class=\"s2\">&quot;x&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">order_by</span><span class=\"p\">(</span><span class=\"s2\">&quot;x DESC&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">()</span>\n<span class=\"go\">&#39;SELECT x FROM tbl ORDER BY x DESC&#39;</span>\n</code></pre>\n  </div>\n</blockquote>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>*expressions:</strong>  the SQL code strings to parse.\nIf a <code>Group</code> instance is passed, this is used as-is.\nIf another <code>Expression</code> instance is passed, it will be wrapped in a <code>Order</code>.</li>\n<li><strong>append:</strong>  if <code>True</code>, add to any existing expressions.\nOtherwise, this flattens all the <code>Order</code> expression into a single expression.</li>\n<li><strong>dialect:</strong>  the dialect used to parse the input expression.</li>\n<li><strong>copy:</strong>  if <code>False</code>, modify this expression instance in-place.</li>\n<li><strong>opts:</strong>  other options to use to parse the input expressions.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The modified Select expression.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">expressions</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">append</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">dialect</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">copy</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">opts</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Select</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.Select.sort_by": {"fullname": "sqlglot.expressions.Select.sort_by", "modulename": "sqlglot.expressions", "qualname": "Select.sort_by", "kind": "function", "doc": "<p>Set the SORT BY expression.</p>\n\n<h6 id=\"example\">Example:</h6>\n\n<blockquote>\n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">Select</span><span class=\"p\">()</span><span class=\"o\">.</span><span class=\"n\">from_</span><span class=\"p\">(</span><span class=\"s2\">&quot;tbl&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">select</span><span class=\"p\">(</span><span class=\"s2\">&quot;x&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">sort_by</span><span class=\"p\">(</span><span class=\"s2\">&quot;x DESC&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">(</span><span class=\"n\">dialect</span><span class=\"o\">=</span><span class=\"s2\">&quot;hive&quot;</span><span class=\"p\">)</span>\n<span class=\"go\">&#39;SELECT x FROM tbl SORT BY x DESC&#39;</span>\n</code></pre>\n  </div>\n</blockquote>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>*expressions:</strong>  the SQL code strings to parse.\nIf a <code>Group</code> instance is passed, this is used as-is.\nIf another <code>Expression</code> instance is passed, it will be wrapped in a <code>SORT</code>.</li>\n<li><strong>append:</strong>  if <code>True</code>, add to any existing expressions.\nOtherwise, this flattens all the <code>Order</code> expression into a single expression.</li>\n<li><strong>dialect:</strong>  the dialect used to parse the input expression.</li>\n<li><strong>copy:</strong>  if <code>False</code>, modify this expression instance in-place.</li>\n<li><strong>opts:</strong>  other options to use to parse the input expressions.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The modified Select expression.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">expressions</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">append</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">dialect</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">copy</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">opts</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Select</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.Select.cluster_by": {"fullname": "sqlglot.expressions.Select.cluster_by", "modulename": "sqlglot.expressions", "qualname": "Select.cluster_by", "kind": "function", "doc": "<p>Set the CLUSTER BY expression.</p>\n\n<h6 id=\"example\">Example:</h6>\n\n<blockquote>\n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">Select</span><span class=\"p\">()</span><span class=\"o\">.</span><span class=\"n\">from_</span><span class=\"p\">(</span><span class=\"s2\">&quot;tbl&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">select</span><span class=\"p\">(</span><span class=\"s2\">&quot;x&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">cluster_by</span><span class=\"p\">(</span><span class=\"s2\">&quot;x DESC&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">(</span><span class=\"n\">dialect</span><span class=\"o\">=</span><span class=\"s2\">&quot;hive&quot;</span><span class=\"p\">)</span>\n<span class=\"go\">&#39;SELECT x FROM tbl CLUSTER BY x DESC&#39;</span>\n</code></pre>\n  </div>\n</blockquote>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>*expressions:</strong>  the SQL code strings to parse.\nIf a <code>Group</code> instance is passed, this is used as-is.\nIf another <code>Expression</code> instance is passed, it will be wrapped in a <code>Cluster</code>.</li>\n<li><strong>append:</strong>  if <code>True</code>, add to any existing expressions.\nOtherwise, this flattens all the <code>Order</code> expression into a single expression.</li>\n<li><strong>dialect:</strong>  the dialect used to parse the input expression.</li>\n<li><strong>copy:</strong>  if <code>False</code>, modify this expression instance in-place.</li>\n<li><strong>opts:</strong>  other options to use to parse the input expressions.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The modified Select expression.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">expressions</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">append</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">dialect</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">copy</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">opts</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Select</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.Select.limit": {"fullname": "sqlglot.expressions.Select.limit", "modulename": "sqlglot.expressions", "qualname": "Select.limit", "kind": "function", "doc": "<p>Set the LIMIT expression.</p>\n\n<h6 id=\"example\">Example:</h6>\n\n<blockquote>\n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">Select</span><span class=\"p\">()</span><span class=\"o\">.</span><span class=\"n\">from_</span><span class=\"p\">(</span><span class=\"s2\">&quot;tbl&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">select</span><span class=\"p\">(</span><span class=\"s2\">&quot;x&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">limit</span><span class=\"p\">(</span><span class=\"mi\">10</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">()</span>\n<span class=\"go\">&#39;SELECT x FROM tbl LIMIT 10&#39;</span>\n</code></pre>\n  </div>\n</blockquote>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>expression:</strong>  the SQL code string to parse.\nThis can also be an integer.\nIf a <code>Limit</code> instance is passed, this is used as-is.\nIf another <code>Expression</code> instance is passed, it will be wrapped in a <code>Limit</code>.</li>\n<li><strong>dialect:</strong>  the dialect used to parse the input expression.</li>\n<li><strong>copy:</strong>  if <code>False</code>, modify this expression instance in-place.</li>\n<li><strong>opts:</strong>  other options to use to parse the input expressions.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>Select: the modified expression.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">dialect</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">copy</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">opts</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Select</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.Select.offset": {"fullname": "sqlglot.expressions.Select.offset", "modulename": "sqlglot.expressions", "qualname": "Select.offset", "kind": "function", "doc": "<p>Set the OFFSET expression.</p>\n\n<h6 id=\"example\">Example:</h6>\n\n<blockquote>\n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">Select</span><span class=\"p\">()</span><span class=\"o\">.</span><span class=\"n\">from_</span><span class=\"p\">(</span><span class=\"s2\">&quot;tbl&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">select</span><span class=\"p\">(</span><span class=\"s2\">&quot;x&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">offset</span><span class=\"p\">(</span><span class=\"mi\">10</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">()</span>\n<span class=\"go\">&#39;SELECT x FROM tbl OFFSET 10&#39;</span>\n</code></pre>\n  </div>\n</blockquote>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>expression:</strong>  the SQL code string to parse.\nThis can also be an integer.\nIf a <code>Offset</code> instance is passed, this is used as-is.\nIf another <code>Expression</code> instance is passed, it will be wrapped in a <code>Offset</code>.</li>\n<li><strong>dialect:</strong>  the dialect used to parse the input expression.</li>\n<li><strong>copy:</strong>  if <code>False</code>, modify this expression instance in-place.</li>\n<li><strong>opts:</strong>  other options to use to parse the input expressions.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The modified Select expression.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">dialect</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">copy</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">opts</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Select</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.Select.select": {"fullname": "sqlglot.expressions.Select.select", "modulename": "sqlglot.expressions", "qualname": "Select.select", "kind": "function", "doc": "<p>Append to or set the SELECT expressions.</p>\n\n<h6 id=\"example\">Example:</h6>\n\n<blockquote>\n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">Select</span><span class=\"p\">()</span><span class=\"o\">.</span><span class=\"n\">select</span><span class=\"p\">(</span><span class=\"s2\">&quot;x&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;y&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">()</span>\n<span class=\"go\">&#39;SELECT x, y&#39;</span>\n</code></pre>\n  </div>\n</blockquote>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>*expressions:</strong>  the SQL code strings to parse.\nIf an <code>Expression</code> instance is passed, it will be used as-is.</li>\n<li><strong>append:</strong>  if <code>True</code>, add to any existing expressions.\nOtherwise, this resets the expressions.</li>\n<li><strong>dialect:</strong>  the dialect used to parse the input expressions.</li>\n<li><strong>copy:</strong>  if <code>False</code>, modify this expression instance in-place.</li>\n<li><strong>opts:</strong>  other options to use to parse the input expressions.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The modified Select expression.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">expressions</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">append</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">dialect</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">copy</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">opts</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Select</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.Select.lateral": {"fullname": "sqlglot.expressions.Select.lateral", "modulename": "sqlglot.expressions", "qualname": "Select.lateral", "kind": "function", "doc": "<p>Append to or set the LATERAL expressions.</p>\n\n<h6 id=\"example\">Example:</h6>\n\n<blockquote>\n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">Select</span><span class=\"p\">()</span><span class=\"o\">.</span><span class=\"n\">select</span><span class=\"p\">(</span><span class=\"s2\">&quot;x&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">lateral</span><span class=\"p\">(</span><span class=\"s2\">&quot;OUTER explode(y) tbl2 AS z&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">from_</span><span class=\"p\">(</span><span class=\"s2\">&quot;tbl&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">()</span>\n<span class=\"go\">&#39;SELECT x FROM tbl LATERAL VIEW OUTER EXPLODE(y) tbl2 AS z&#39;</span>\n</code></pre>\n  </div>\n</blockquote>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>*expressions:</strong>  the SQL code strings to parse.\nIf an <code>Expression</code> instance is passed, it will be used as-is.</li>\n<li><strong>append:</strong>  if <code>True</code>, add to any existing expressions.\nOtherwise, this resets the expressions.</li>\n<li><strong>dialect:</strong>  the dialect used to parse the input expressions.</li>\n<li><strong>copy:</strong>  if <code>False</code>, modify this expression instance in-place.</li>\n<li><strong>opts:</strong>  other options to use to parse the input expressions.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The modified Select expression.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">expressions</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">append</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">dialect</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">copy</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">opts</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Select</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.Select.join": {"fullname": "sqlglot.expressions.Select.join", "modulename": "sqlglot.expressions", "qualname": "Select.join", "kind": "function", "doc": "<p>Append to or set the JOIN expressions.</p>\n\n<h6 id=\"example\">Example:</h6>\n\n<blockquote>\n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">Select</span><span class=\"p\">()</span><span class=\"o\">.</span><span class=\"n\">select</span><span class=\"p\">(</span><span class=\"s2\">&quot;*&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">from_</span><span class=\"p\">(</span><span class=\"s2\">&quot;tbl&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">join</span><span class=\"p\">(</span><span class=\"s2\">&quot;tbl2&quot;</span><span class=\"p\">,</span> <span class=\"n\">on</span><span class=\"o\">=</span><span class=\"s2\">&quot;tbl1.y = tbl2.y&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">()</span>\n<span class=\"go\">&#39;SELECT * FROM tbl JOIN tbl2 ON tbl1.y = tbl2.y&#39;</span>\n</code></pre>\n  </div>\n  \n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">Select</span><span class=\"p\">()</span><span class=\"o\">.</span><span class=\"n\">select</span><span class=\"p\">(</span><span class=\"s2\">&quot;1&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">from_</span><span class=\"p\">(</span><span class=\"s2\">&quot;a&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">join</span><span class=\"p\">(</span><span class=\"s2\">&quot;b&quot;</span><span class=\"p\">,</span> <span class=\"n\">using</span><span class=\"o\">=</span><span class=\"p\">[</span><span class=\"s2\">&quot;x&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;y&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;z&quot;</span><span class=\"p\">])</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">()</span>\n<span class=\"go\">&#39;SELECT 1 FROM a JOIN b USING (x, y, z)&#39;</span>\n</code></pre>\n  </div>\n  \n  <p>Use <code>join_type</code> to change the type of join:</p>\n  \n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">Select</span><span class=\"p\">()</span><span class=\"o\">.</span><span class=\"n\">select</span><span class=\"p\">(</span><span class=\"s2\">&quot;*&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">from_</span><span class=\"p\">(</span><span class=\"s2\">&quot;tbl&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">join</span><span class=\"p\">(</span><span class=\"s2\">&quot;tbl2&quot;</span><span class=\"p\">,</span> <span class=\"n\">on</span><span class=\"o\">=</span><span class=\"s2\">&quot;tbl1.y = tbl2.y&quot;</span><span class=\"p\">,</span> <span class=\"n\">join_type</span><span class=\"o\">=</span><span class=\"s2\">&quot;left outer&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">()</span>\n<span class=\"go\">&#39;SELECT * FROM tbl LEFT OUTER JOIN tbl2 ON tbl1.y = tbl2.y&#39;</span>\n</code></pre>\n  </div>\n</blockquote>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>expression:</strong>  the SQL code string to parse.\nIf an <code>Expression</code> instance is passed, it will be used as-is.</li>\n<li><strong>on:</strong>  optionally specify the join \"on\" criteria as a SQL string.\nIf an <code>Expression</code> instance is passed, it will be used as-is.</li>\n<li><strong>using:</strong>  optionally specify the join \"using\" criteria as a SQL string.\nIf an <code>Expression</code> instance is passed, it will be used as-is.</li>\n<li><strong>append:</strong>  if <code>True</code>, add to any existing expressions.\nOtherwise, this resets the expressions.</li>\n<li><strong>join_type:</strong>  if set, alter the parsed join type.</li>\n<li><strong>join_alias:</strong>  an optional alias for the joined source.</li>\n<li><strong>dialect:</strong>  the dialect used to parse the input expressions.</li>\n<li><strong>copy:</strong>  if <code>False</code>, modify this expression instance in-place.</li>\n<li><strong>opts:</strong>  other options to use to parse the input expressions.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>Select: the modified expression.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">on</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">using</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">,</span> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">]],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">append</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">join_type</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">join_alias</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Identifier</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">dialect</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">copy</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">opts</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Select</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.Select.where": {"fullname": "sqlglot.expressions.Select.where", "modulename": "sqlglot.expressions", "qualname": "Select.where", "kind": "function", "doc": "<p>Append to or set the WHERE expressions.</p>\n\n<h6 id=\"example\">Example:</h6>\n\n<blockquote>\n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">Select</span><span class=\"p\">()</span><span class=\"o\">.</span><span class=\"n\">select</span><span class=\"p\">(</span><span class=\"s2\">&quot;x&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">from_</span><span class=\"p\">(</span><span class=\"s2\">&quot;tbl&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">where</span><span class=\"p\">(</span><span class=\"s2\">&quot;x = &#39;a&#39; OR x &lt; &#39;b&#39;&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">()</span>\n<span class=\"go\">&quot;SELECT x FROM tbl WHERE x = &#39;a&#39; OR x &lt; &#39;b&#39;&quot;</span>\n</code></pre>\n  </div>\n</blockquote>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>*expressions:</strong>  the SQL code strings to parse.\nIf an <code>Expression</code> instance is passed, it will be used as-is.\nMultiple expressions are combined with an AND operator.</li>\n<li><strong>append:</strong>  if <code>True</code>, AND the new expressions to any existing expression.\nOtherwise, this resets the expression.</li>\n<li><strong>dialect:</strong>  the dialect used to parse the input expressions.</li>\n<li><strong>copy:</strong>  if <code>False</code>, modify this expression instance in-place.</li>\n<li><strong>opts:</strong>  other options to use to parse the input expressions.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>Select: the modified expression.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">expressions</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">append</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">dialect</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">copy</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">opts</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Select</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.Select.having": {"fullname": "sqlglot.expressions.Select.having", "modulename": "sqlglot.expressions", "qualname": "Select.having", "kind": "function", "doc": "<p>Append to or set the HAVING expressions.</p>\n\n<h6 id=\"example\">Example:</h6>\n\n<blockquote>\n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">Select</span><span class=\"p\">()</span><span class=\"o\">.</span><span class=\"n\">select</span><span class=\"p\">(</span><span class=\"s2\">&quot;x&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;COUNT(y)&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">from_</span><span class=\"p\">(</span><span class=\"s2\">&quot;tbl&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">group_by</span><span class=\"p\">(</span><span class=\"s2\">&quot;x&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">having</span><span class=\"p\">(</span><span class=\"s2\">&quot;COUNT(y) &gt; 3&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">()</span>\n<span class=\"go\">&#39;SELECT x, COUNT(y) FROM tbl GROUP BY x HAVING COUNT(y) &gt; 3&#39;</span>\n</code></pre>\n  </div>\n</blockquote>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>*expressions:</strong>  the SQL code strings to parse.\nIf an <code>Expression</code> instance is passed, it will be used as-is.\nMultiple expressions are combined with an AND operator.</li>\n<li><strong>append:</strong>  if <code>True</code>, AND the new expressions to any existing expression.\nOtherwise, this resets the expression.</li>\n<li><strong>dialect:</strong>  the dialect used to parse the input expressions.</li>\n<li><strong>copy:</strong>  if <code>False</code>, modify this expression instance in-place.</li>\n<li><strong>opts:</strong>  other options to use to parse the input expressions.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The modified Select expression.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">expressions</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">append</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">dialect</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">copy</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">opts</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Select</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.Select.window": {"fullname": "sqlglot.expressions.Select.window", "modulename": "sqlglot.expressions", "qualname": "Select.window", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">expressions</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">append</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">dialect</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">copy</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">opts</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Select</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.Select.qualify": {"fullname": "sqlglot.expressions.Select.qualify", "modulename": "sqlglot.expressions", "qualname": "Select.qualify", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">expressions</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">append</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">dialect</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">copy</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">opts</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Select</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.Select.distinct": {"fullname": "sqlglot.expressions.Select.distinct", "modulename": "sqlglot.expressions", "qualname": "Select.distinct", "kind": "function", "doc": "<p>Set the OFFSET expression.</p>\n\n<h6 id=\"example\">Example:</h6>\n\n<blockquote>\n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">Select</span><span class=\"p\">()</span><span class=\"o\">.</span><span class=\"n\">from_</span><span class=\"p\">(</span><span class=\"s2\">&quot;tbl&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">select</span><span class=\"p\">(</span><span class=\"s2\">&quot;x&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">distinct</span><span class=\"p\">()</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">()</span>\n<span class=\"go\">&#39;SELECT DISTINCT x FROM tbl&#39;</span>\n</code></pre>\n  </div>\n</blockquote>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>ons:</strong>  the expressions to distinct on</li>\n<li><strong>distinct:</strong>  whether the Select should be distinct</li>\n<li><strong>copy:</strong>  if <code>False</code>, modify this expression instance in-place.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>Select: the modified expression.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">ons</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">distinct</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">copy</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Select</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.Select.ctas": {"fullname": "sqlglot.expressions.Select.ctas", "modulename": "sqlglot.expressions", "qualname": "Select.ctas", "kind": "function", "doc": "<p>Convert this expression to a CREATE TABLE AS statement.</p>\n\n<h6 id=\"example\">Example:</h6>\n\n<blockquote>\n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">Select</span><span class=\"p\">()</span><span class=\"o\">.</span><span class=\"n\">select</span><span class=\"p\">(</span><span class=\"s2\">&quot;*&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">from_</span><span class=\"p\">(</span><span class=\"s2\">&quot;tbl&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">ctas</span><span class=\"p\">(</span><span class=\"s2\">&quot;x&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">()</span>\n<span class=\"go\">&#39;CREATE TABLE x AS SELECT * FROM tbl&#39;</span>\n</code></pre>\n  </div>\n</blockquote>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>table:</strong>  the SQL code string to parse as the table name.\nIf another <code>Expression</code> instance is passed, it will be used as-is.</li>\n<li><strong>properties:</strong>  an optional mapping of table properties</li>\n<li><strong>dialect:</strong>  the dialect used to parse the input table.</li>\n<li><strong>copy:</strong>  if <code>False</code>, modify this expression instance in-place.</li>\n<li><strong>opts:</strong>  other options to use to parse the input table.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The new Create expression.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">table</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">properties</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">dialect</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">copy</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">opts</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Create</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.Select.lock": {"fullname": "sqlglot.expressions.Select.lock", "modulename": "sqlglot.expressions", "qualname": "Select.lock", "kind": "function", "doc": "<p>Set the locking read mode for this expression.</p>\n\n<h6 id=\"examples\">Examples:</h6>\n\n<blockquote>\n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">Select</span><span class=\"p\">()</span><span class=\"o\">.</span><span class=\"n\">select</span><span class=\"p\">(</span><span class=\"s2\">&quot;x&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">from_</span><span class=\"p\">(</span><span class=\"s2\">&quot;tbl&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">where</span><span class=\"p\">(</span><span class=\"s2\">&quot;x = &#39;a&#39;&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">lock</span><span class=\"p\">()</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">(</span><span class=\"s2\">&quot;mysql&quot;</span><span class=\"p\">)</span>\n<span class=\"go\">&quot;SELECT x FROM tbl WHERE x = &#39;a&#39; FOR UPDATE&quot;</span>\n</code></pre>\n  </div>\n  \n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">Select</span><span class=\"p\">()</span><span class=\"o\">.</span><span class=\"n\">select</span><span class=\"p\">(</span><span class=\"s2\">&quot;x&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">from_</span><span class=\"p\">(</span><span class=\"s2\">&quot;tbl&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">where</span><span class=\"p\">(</span><span class=\"s2\">&quot;x = &#39;a&#39;&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">lock</span><span class=\"p\">(</span><span class=\"n\">update</span><span class=\"o\">=</span><span class=\"kc\">False</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">(</span><span class=\"s2\">&quot;mysql&quot;</span><span class=\"p\">)</span>\n<span class=\"go\">&quot;SELECT x FROM tbl WHERE x = &#39;a&#39; FOR SHARE&quot;</span>\n</code></pre>\n  </div>\n</blockquote>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>update:</strong>  if <code>True</code>, the locking type will be <code>FOR UPDATE</code>, else it will be <code>FOR SHARE</code>.</li>\n<li><strong>copy:</strong>  if <code>False</code>, modify this expression instance in-place.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The modified expression.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">update</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">copy</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Select</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.Select.is_star": {"fullname": "sqlglot.expressions.Select.is_star", "modulename": "sqlglot.expressions", "qualname": "Select.is_star", "kind": "variable", "doc": "<p>Checks whether an expression is a star.</p>\n", "annotation": ": bool"}, "sqlglot.expressions.Subquery": {"fullname": "sqlglot.expressions.Subquery", "modulename": "sqlglot.expressions", "qualname": "Subquery", "kind": "class", "doc": "<p></p>\n", "bases": "DerivedTable, Unionable"}, "sqlglot.expressions.Subquery.unnest": {"fullname": "sqlglot.expressions.Subquery.unnest", "modulename": "sqlglot.expressions", "qualname": "Subquery.unnest", "kind": "function", "doc": "<p>Returns the first non subquery.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlglot.expressions.Subquery.is_star": {"fullname": "sqlglot.expressions.Subquery.is_star", "modulename": "sqlglot.expressions", "qualname": "Subquery.is_star", "kind": "variable", "doc": "<p>Checks whether an expression is a star.</p>\n", "annotation": ": bool"}, "sqlglot.expressions.Subquery.output_name": {"fullname": "sqlglot.expressions.Subquery.output_name", "modulename": "sqlglot.expressions", "qualname": "Subquery.output_name", "kind": "variable", "doc": "<p>Name of the output column if this expression is a selection.</p>\n\n<p>If the Expression has no output name, an empty string is returned.</p>\n\n<h6 id=\"example\">Example:</h6>\n\n<blockquote>\n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"kn\">from</span> <span class=\"nn\">sqlglot</span> <span class=\"kn\">import</span> <span class=\"n\">parse_one</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">parse_one</span><span class=\"p\">(</span><span class=\"s2\">&quot;SELECT a&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"p\">[</span><span class=\"mi\">0</span><span class=\"p\">]</span><span class=\"o\">.</span><span class=\"n\">output_name</span>\n<span class=\"go\">&#39;a&#39;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">parse_one</span><span class=\"p\">(</span><span class=\"s2\">&quot;SELECT b AS c&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"p\">[</span><span class=\"mi\">0</span><span class=\"p\">]</span><span class=\"o\">.</span><span class=\"n\">output_name</span>\n<span class=\"go\">&#39;c&#39;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">parse_one</span><span class=\"p\">(</span><span class=\"s2\">&quot;SELECT 1 + 2&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"p\">[</span><span class=\"mi\">0</span><span class=\"p\">]</span><span class=\"o\">.</span><span class=\"n\">output_name</span>\n<span class=\"go\">&#39;&#39;</span>\n</code></pre>\n  </div>\n</blockquote>\n", "annotation": ": str"}, "sqlglot.expressions.TableSample": {"fullname": "sqlglot.expressions.TableSample", "modulename": "sqlglot.expressions", "qualname": "TableSample", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.Tag": {"fullname": "sqlglot.expressions.Tag", "modulename": "sqlglot.expressions", "qualname": "Tag", "kind": "class", "doc": "<p>Tags are used for generating arbitrary sql like SELECT <span>x</span>.</p>\n", "bases": "Expression"}, "sqlglot.expressions.Pivot": {"fullname": "sqlglot.expressions.Pivot", "modulename": "sqlglot.expressions", "qualname": "Pivot", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.Window": {"fullname": "sqlglot.expressions.Window", "modulename": "sqlglot.expressions", "qualname": "Window", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.WindowSpec": {"fullname": "sqlglot.expressions.WindowSpec", "modulename": "sqlglot.expressions", "qualname": "WindowSpec", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.Where": {"fullname": "sqlglot.expressions.Where", "modulename": "sqlglot.expressions", "qualname": "Where", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.Star": {"fullname": "sqlglot.expressions.Star", "modulename": "sqlglot.expressions", "qualname": "Star", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.Star.output_name": {"fullname": "sqlglot.expressions.Star.output_name", "modulename": "sqlglot.expressions", "qualname": "Star.output_name", "kind": "variable", "doc": "<p>Name of the output column if this expression is a selection.</p>\n\n<p>If the Expression has no output name, an empty string is returned.</p>\n\n<h6 id=\"example\">Example:</h6>\n\n<blockquote>\n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"kn\">from</span> <span class=\"nn\">sqlglot</span> <span class=\"kn\">import</span> <span class=\"n\">parse_one</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">parse_one</span><span class=\"p\">(</span><span class=\"s2\">&quot;SELECT a&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"p\">[</span><span class=\"mi\">0</span><span class=\"p\">]</span><span class=\"o\">.</span><span class=\"n\">output_name</span>\n<span class=\"go\">&#39;a&#39;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">parse_one</span><span class=\"p\">(</span><span class=\"s2\">&quot;SELECT b AS c&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"p\">[</span><span class=\"mi\">0</span><span class=\"p\">]</span><span class=\"o\">.</span><span class=\"n\">output_name</span>\n<span class=\"go\">&#39;c&#39;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">parse_one</span><span class=\"p\">(</span><span class=\"s2\">&quot;SELECT 1 + 2&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"p\">[</span><span class=\"mi\">0</span><span class=\"p\">]</span><span class=\"o\">.</span><span class=\"n\">output_name</span>\n<span class=\"go\">&#39;&#39;</span>\n</code></pre>\n  </div>\n</blockquote>\n", "annotation": ": str"}, "sqlglot.expressions.Parameter": {"fullname": "sqlglot.expressions.Parameter", "modulename": "sqlglot.expressions", "qualname": "Parameter", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.SessionParameter": {"fullname": "sqlglot.expressions.SessionParameter", "modulename": "sqlglot.expressions", "qualname": "SessionParameter", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.Placeholder": {"fullname": "sqlglot.expressions.Placeholder", "modulename": "sqlglot.expressions", "qualname": "Placeholder", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.Null": {"fullname": "sqlglot.expressions.Null", "modulename": "sqlglot.expressions", "qualname": "Null", "kind": "class", "doc": "<p></p>\n", "bases": "Condition"}, "sqlglot.expressions.Boolean": {"fullname": "sqlglot.expressions.Boolean", "modulename": "sqlglot.expressions", "qualname": "Boolean", "kind": "class", "doc": "<p></p>\n", "bases": "Condition"}, "sqlglot.expressions.DataTypeSize": {"fullname": "sqlglot.expressions.DataTypeSize", "modulename": "sqlglot.expressions", "qualname": "DataTypeSize", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.DataType": {"fullname": "sqlglot.expressions.DataType", "modulename": "sqlglot.expressions", "qualname": "DataType", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.DataType.Type": {"fullname": "sqlglot.expressions.DataType.Type", "modulename": "sqlglot.expressions", "qualname": "DataType.Type", "kind": "class", "doc": "<p>An enumeration.</p>\n", "bases": "sqlglot.helper.AutoName"}, "sqlglot.expressions.DataType.Type.ARRAY": {"fullname": "sqlglot.expressions.DataType.Type.ARRAY", "modulename": "sqlglot.expressions", "qualname": "DataType.Type.ARRAY", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.ARRAY: &#x27;ARRAY&#x27;&gt;"}, "sqlglot.expressions.DataType.Type.BIGDECIMAL": {"fullname": "sqlglot.expressions.DataType.Type.BIGDECIMAL", "modulename": "sqlglot.expressions", "qualname": "DataType.Type.BIGDECIMAL", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.BIGDECIMAL: &#x27;BIGDECIMAL&#x27;&gt;"}, "sqlglot.expressions.DataType.Type.BIGINT": {"fullname": "sqlglot.expressions.DataType.Type.BIGINT", "modulename": "sqlglot.expressions", "qualname": "DataType.Type.BIGINT", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.BIGINT: &#x27;BIGINT&#x27;&gt;"}, "sqlglot.expressions.DataType.Type.BIGSERIAL": {"fullname": "sqlglot.expressions.DataType.Type.BIGSERIAL", "modulename": "sqlglot.expressions", "qualname": "DataType.Type.BIGSERIAL", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.BIGSERIAL: &#x27;BIGSERIAL&#x27;&gt;"}, "sqlglot.expressions.DataType.Type.BINARY": {"fullname": "sqlglot.expressions.DataType.Type.BINARY", "modulename": "sqlglot.expressions", "qualname": "DataType.Type.BINARY", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.BINARY: &#x27;BINARY&#x27;&gt;"}, "sqlglot.expressions.DataType.Type.BIT": {"fullname": "sqlglot.expressions.DataType.Type.BIT", "modulename": "sqlglot.expressions", "qualname": "DataType.Type.BIT", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.BIT: &#x27;BIT&#x27;&gt;"}, "sqlglot.expressions.DataType.Type.BOOLEAN": {"fullname": "sqlglot.expressions.DataType.Type.BOOLEAN", "modulename": "sqlglot.expressions", "qualname": "DataType.Type.BOOLEAN", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.BOOLEAN: &#x27;BOOLEAN&#x27;&gt;"}, "sqlglot.expressions.DataType.Type.CHAR": {"fullname": "sqlglot.expressions.DataType.Type.CHAR", "modulename": "sqlglot.expressions", "qualname": "DataType.Type.CHAR", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.CHAR: &#x27;CHAR&#x27;&gt;"}, "sqlglot.expressions.DataType.Type.DATE": {"fullname": "sqlglot.expressions.DataType.Type.DATE", "modulename": "sqlglot.expressions", "qualname": "DataType.Type.DATE", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.DATE: &#x27;DATE&#x27;&gt;"}, "sqlglot.expressions.DataType.Type.DATETIME": {"fullname": "sqlglot.expressions.DataType.Type.DATETIME", "modulename": "sqlglot.expressions", "qualname": "DataType.Type.DATETIME", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.DATETIME: &#x27;DATETIME&#x27;&gt;"}, "sqlglot.expressions.DataType.Type.DATETIME64": {"fullname": "sqlglot.expressions.DataType.Type.DATETIME64", "modulename": "sqlglot.expressions", "qualname": "DataType.Type.DATETIME64", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.DATETIME64: &#x27;DATETIME64&#x27;&gt;"}, "sqlglot.expressions.DataType.Type.INT4RANGE": {"fullname": "sqlglot.expressions.DataType.Type.INT4RANGE", "modulename": "sqlglot.expressions", "qualname": "DataType.Type.INT4RANGE", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.INT4RANGE: &#x27;INT4RANGE&#x27;&gt;"}, "sqlglot.expressions.DataType.Type.INT4MULTIRANGE": {"fullname": "sqlglot.expressions.DataType.Type.INT4MULTIRANGE", "modulename": "sqlglot.expressions", "qualname": "DataType.Type.INT4MULTIRANGE", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.INT4MULTIRANGE: &#x27;INT4MULTIRANGE&#x27;&gt;"}, "sqlglot.expressions.DataType.Type.INT8RANGE": {"fullname": "sqlglot.expressions.DataType.Type.INT8RANGE", "modulename": "sqlglot.expressions", "qualname": "DataType.Type.INT8RANGE", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.INT8RANGE: &#x27;INT8RANGE&#x27;&gt;"}, "sqlglot.expressions.DataType.Type.INT8MULTIRANGE": {"fullname": "sqlglot.expressions.DataType.Type.INT8MULTIRANGE", "modulename": "sqlglot.expressions", "qualname": "DataType.Type.INT8MULTIRANGE", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.INT8MULTIRANGE: &#x27;INT8MULTIRANGE&#x27;&gt;"}, "sqlglot.expressions.DataType.Type.NUMRANGE": {"fullname": "sqlglot.expressions.DataType.Type.NUMRANGE", "modulename": "sqlglot.expressions", "qualname": "DataType.Type.NUMRANGE", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.NUMRANGE: &#x27;NUMRANGE&#x27;&gt;"}, "sqlglot.expressions.DataType.Type.NUMMULTIRANGE": {"fullname": "sqlglot.expressions.DataType.Type.NUMMULTIRANGE", "modulename": "sqlglot.expressions", "qualname": "DataType.Type.NUMMULTIRANGE", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.NUMMULTIRANGE: &#x27;NUMMULTIRANGE&#x27;&gt;"}, "sqlglot.expressions.DataType.Type.TSRANGE": {"fullname": "sqlglot.expressions.DataType.Type.TSRANGE", "modulename": "sqlglot.expressions", "qualname": "DataType.Type.TSRANGE", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.TSRANGE: &#x27;TSRANGE&#x27;&gt;"}, "sqlglot.expressions.DataType.Type.TSMULTIRANGE": {"fullname": "sqlglot.expressions.DataType.Type.TSMULTIRANGE", "modulename": "sqlglot.expressions", "qualname": "DataType.Type.TSMULTIRANGE", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.TSMULTIRANGE: &#x27;TSMULTIRANGE&#x27;&gt;"}, "sqlglot.expressions.DataType.Type.TSTZRANGE": {"fullname": "sqlglot.expressions.DataType.Type.TSTZRANGE", "modulename": "sqlglot.expressions", "qualname": "DataType.Type.TSTZRANGE", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.TSTZRANGE: &#x27;TSTZRANGE&#x27;&gt;"}, "sqlglot.expressions.DataType.Type.TSTZMULTIRANGE": {"fullname": "sqlglot.expressions.DataType.Type.TSTZMULTIRANGE", "modulename": "sqlglot.expressions", "qualname": "DataType.Type.TSTZMULTIRANGE", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.TSTZMULTIRANGE: &#x27;TSTZMULTIRANGE&#x27;&gt;"}, "sqlglot.expressions.DataType.Type.DATERANGE": {"fullname": "sqlglot.expressions.DataType.Type.DATERANGE", "modulename": "sqlglot.expressions", "qualname": "DataType.Type.DATERANGE", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.DATERANGE: &#x27;DATERANGE&#x27;&gt;"}, "sqlglot.expressions.DataType.Type.DATEMULTIRANGE": {"fullname": "sqlglot.expressions.DataType.Type.DATEMULTIRANGE", "modulename": "sqlglot.expressions", "qualname": "DataType.Type.DATEMULTIRANGE", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.DATEMULTIRANGE: &#x27;DATEMULTIRANGE&#x27;&gt;"}, "sqlglot.expressions.DataType.Type.DECIMAL": {"fullname": "sqlglot.expressions.DataType.Type.DECIMAL", "modulename": "sqlglot.expressions", "qualname": "DataType.Type.DECIMAL", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.DECIMAL: &#x27;DECIMAL&#x27;&gt;"}, "sqlglot.expressions.DataType.Type.DOUBLE": {"fullname": "sqlglot.expressions.DataType.Type.DOUBLE", "modulename": "sqlglot.expressions", "qualname": "DataType.Type.DOUBLE", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.DOUBLE: &#x27;DOUBLE&#x27;&gt;"}, "sqlglot.expressions.DataType.Type.FLOAT": {"fullname": "sqlglot.expressions.DataType.Type.FLOAT", "modulename": "sqlglot.expressions", "qualname": "DataType.Type.FLOAT", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.FLOAT: &#x27;FLOAT&#x27;&gt;"}, "sqlglot.expressions.DataType.Type.GEOGRAPHY": {"fullname": "sqlglot.expressions.DataType.Type.GEOGRAPHY", "modulename": "sqlglot.expressions", "qualname": "DataType.Type.GEOGRAPHY", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.GEOGRAPHY: &#x27;GEOGRAPHY&#x27;&gt;"}, "sqlglot.expressions.DataType.Type.GEOMETRY": {"fullname": "sqlglot.expressions.DataType.Type.GEOMETRY", "modulename": "sqlglot.expressions", "qualname": "DataType.Type.GEOMETRY", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.GEOMETRY: &#x27;GEOMETRY&#x27;&gt;"}, "sqlglot.expressions.DataType.Type.HLLSKETCH": {"fullname": "sqlglot.expressions.DataType.Type.HLLSKETCH", "modulename": "sqlglot.expressions", "qualname": "DataType.Type.HLLSKETCH", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.HLLSKETCH: &#x27;HLLSKETCH&#x27;&gt;"}, "sqlglot.expressions.DataType.Type.HSTORE": {"fullname": "sqlglot.expressions.DataType.Type.HSTORE", "modulename": "sqlglot.expressions", "qualname": "DataType.Type.HSTORE", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.HSTORE: &#x27;HSTORE&#x27;&gt;"}, "sqlglot.expressions.DataType.Type.IMAGE": {"fullname": "sqlglot.expressions.DataType.Type.IMAGE", "modulename": "sqlglot.expressions", "qualname": "DataType.Type.IMAGE", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.IMAGE: &#x27;IMAGE&#x27;&gt;"}, "sqlglot.expressions.DataType.Type.INET": {"fullname": "sqlglot.expressions.DataType.Type.INET", "modulename": "sqlglot.expressions", "qualname": "DataType.Type.INET", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.INET: &#x27;INET&#x27;&gt;"}, "sqlglot.expressions.DataType.Type.INT": {"fullname": "sqlglot.expressions.DataType.Type.INT", "modulename": "sqlglot.expressions", "qualname": "DataType.Type.INT", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.INT: &#x27;INT&#x27;&gt;"}, "sqlglot.expressions.DataType.Type.INT128": {"fullname": "sqlglot.expressions.DataType.Type.INT128", "modulename": "sqlglot.expressions", "qualname": "DataType.Type.INT128", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.INT128: &#x27;INT128&#x27;&gt;"}, "sqlglot.expressions.DataType.Type.INT256": {"fullname": "sqlglot.expressions.DataType.Type.INT256", "modulename": "sqlglot.expressions", "qualname": "DataType.Type.INT256", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.INT256: &#x27;INT256&#x27;&gt;"}, "sqlglot.expressions.DataType.Type.INTERVAL": {"fullname": "sqlglot.expressions.DataType.Type.INTERVAL", "modulename": "sqlglot.expressions", "qualname": "DataType.Type.INTERVAL", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.INTERVAL: &#x27;INTERVAL&#x27;&gt;"}, "sqlglot.expressions.DataType.Type.JSON": {"fullname": "sqlglot.expressions.DataType.Type.JSON", "modulename": "sqlglot.expressions", "qualname": "DataType.Type.JSON", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.JSON: &#x27;JSON&#x27;&gt;"}, "sqlglot.expressions.DataType.Type.JSONB": {"fullname": "sqlglot.expressions.DataType.Type.JSONB", "modulename": "sqlglot.expressions", "qualname": "DataType.Type.JSONB", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.JSONB: &#x27;JSONB&#x27;&gt;"}, "sqlglot.expressions.DataType.Type.LONGBLOB": {"fullname": "sqlglot.expressions.DataType.Type.LONGBLOB", "modulename": "sqlglot.expressions", "qualname": "DataType.Type.LONGBLOB", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.LONGBLOB: &#x27;LONGBLOB&#x27;&gt;"}, "sqlglot.expressions.DataType.Type.LONGTEXT": {"fullname": "sqlglot.expressions.DataType.Type.LONGTEXT", "modulename": "sqlglot.expressions", "qualname": "DataType.Type.LONGTEXT", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.LONGTEXT: &#x27;LONGTEXT&#x27;&gt;"}, "sqlglot.expressions.DataType.Type.MAP": {"fullname": "sqlglot.expressions.DataType.Type.MAP", "modulename": "sqlglot.expressions", "qualname": "DataType.Type.MAP", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.MAP: &#x27;MAP&#x27;&gt;"}, "sqlglot.expressions.DataType.Type.MEDIUMBLOB": {"fullname": "sqlglot.expressions.DataType.Type.MEDIUMBLOB", "modulename": "sqlglot.expressions", "qualname": "DataType.Type.MEDIUMBLOB", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.MEDIUMBLOB: &#x27;MEDIUMBLOB&#x27;&gt;"}, "sqlglot.expressions.DataType.Type.MEDIUMTEXT": {"fullname": "sqlglot.expressions.DataType.Type.MEDIUMTEXT", "modulename": "sqlglot.expressions", "qualname": "DataType.Type.MEDIUMTEXT", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.MEDIUMTEXT: &#x27;MEDIUMTEXT&#x27;&gt;"}, "sqlglot.expressions.DataType.Type.MONEY": {"fullname": "sqlglot.expressions.DataType.Type.MONEY", "modulename": "sqlglot.expressions", "qualname": "DataType.Type.MONEY", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.MONEY: &#x27;MONEY&#x27;&gt;"}, "sqlglot.expressions.DataType.Type.NCHAR": {"fullname": "sqlglot.expressions.DataType.Type.NCHAR", "modulename": "sqlglot.expressions", "qualname": "DataType.Type.NCHAR", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.NCHAR: &#x27;NCHAR&#x27;&gt;"}, "sqlglot.expressions.DataType.Type.NULL": {"fullname": "sqlglot.expressions.DataType.Type.NULL", "modulename": "sqlglot.expressions", "qualname": "DataType.Type.NULL", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.NULL: &#x27;NULL&#x27;&gt;"}, "sqlglot.expressions.DataType.Type.NULLABLE": {"fullname": "sqlglot.expressions.DataType.Type.NULLABLE", "modulename": "sqlglot.expressions", "qualname": "DataType.Type.NULLABLE", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.NULLABLE: &#x27;NULLABLE&#x27;&gt;"}, "sqlglot.expressions.DataType.Type.NVARCHAR": {"fullname": "sqlglot.expressions.DataType.Type.NVARCHAR", "modulename": "sqlglot.expressions", "qualname": "DataType.Type.NVARCHAR", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.NVARCHAR: &#x27;NVARCHAR&#x27;&gt;"}, "sqlglot.expressions.DataType.Type.OBJECT": {"fullname": "sqlglot.expressions.DataType.Type.OBJECT", "modulename": "sqlglot.expressions", "qualname": "DataType.Type.OBJECT", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.OBJECT: &#x27;OBJECT&#x27;&gt;"}, "sqlglot.expressions.DataType.Type.ROWVERSION": {"fullname": "sqlglot.expressions.DataType.Type.ROWVERSION", "modulename": "sqlglot.expressions", "qualname": "DataType.Type.ROWVERSION", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.ROWVERSION: &#x27;ROWVERSION&#x27;&gt;"}, "sqlglot.expressions.DataType.Type.SERIAL": {"fullname": "sqlglot.expressions.DataType.Type.SERIAL", "modulename": "sqlglot.expressions", "qualname": "DataType.Type.SERIAL", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.SERIAL: &#x27;SERIAL&#x27;&gt;"}, "sqlglot.expressions.DataType.Type.SMALLINT": {"fullname": "sqlglot.expressions.DataType.Type.SMALLINT", "modulename": "sqlglot.expressions", "qualname": "DataType.Type.SMALLINT", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.SMALLINT: &#x27;SMALLINT&#x27;&gt;"}, "sqlglot.expressions.DataType.Type.SMALLMONEY": {"fullname": "sqlglot.expressions.DataType.Type.SMALLMONEY", "modulename": "sqlglot.expressions", "qualname": "DataType.Type.SMALLMONEY", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.SMALLMONEY: &#x27;SMALLMONEY&#x27;&gt;"}, "sqlglot.expressions.DataType.Type.SMALLSERIAL": {"fullname": "sqlglot.expressions.DataType.Type.SMALLSERIAL", "modulename": "sqlglot.expressions", "qualname": "DataType.Type.SMALLSERIAL", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.SMALLSERIAL: &#x27;SMALLSERIAL&#x27;&gt;"}, "sqlglot.expressions.DataType.Type.STRUCT": {"fullname": "sqlglot.expressions.DataType.Type.STRUCT", "modulename": "sqlglot.expressions", "qualname": "DataType.Type.STRUCT", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.STRUCT: &#x27;STRUCT&#x27;&gt;"}, "sqlglot.expressions.DataType.Type.SUPER": {"fullname": "sqlglot.expressions.DataType.Type.SUPER", "modulename": "sqlglot.expressions", "qualname": "DataType.Type.SUPER", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.SUPER: &#x27;SUPER&#x27;&gt;"}, "sqlglot.expressions.DataType.Type.TEXT": {"fullname": "sqlglot.expressions.DataType.Type.TEXT", "modulename": "sqlglot.expressions", "qualname": "DataType.Type.TEXT", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.TEXT: &#x27;TEXT&#x27;&gt;"}, "sqlglot.expressions.DataType.Type.TIME": {"fullname": "sqlglot.expressions.DataType.Type.TIME", "modulename": "sqlglot.expressions", "qualname": "DataType.Type.TIME", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.TIME: &#x27;TIME&#x27;&gt;"}, "sqlglot.expressions.DataType.Type.TIMESTAMP": {"fullname": "sqlglot.expressions.DataType.Type.TIMESTAMP", "modulename": "sqlglot.expressions", "qualname": "DataType.Type.TIMESTAMP", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.TIMESTAMP: &#x27;TIMESTAMP&#x27;&gt;"}, "sqlglot.expressions.DataType.Type.TIMESTAMPTZ": {"fullname": "sqlglot.expressions.DataType.Type.TIMESTAMPTZ", "modulename": "sqlglot.expressions", "qualname": "DataType.Type.TIMESTAMPTZ", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.TIMESTAMPTZ: &#x27;TIMESTAMPTZ&#x27;&gt;"}, "sqlglot.expressions.DataType.Type.TIMESTAMPLTZ": {"fullname": "sqlglot.expressions.DataType.Type.TIMESTAMPLTZ", "modulename": "sqlglot.expressions", "qualname": "DataType.Type.TIMESTAMPLTZ", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.TIMESTAMPLTZ: &#x27;TIMESTAMPLTZ&#x27;&gt;"}, "sqlglot.expressions.DataType.Type.TINYINT": {"fullname": "sqlglot.expressions.DataType.Type.TINYINT", "modulename": "sqlglot.expressions", "qualname": "DataType.Type.TINYINT", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.TINYINT: &#x27;TINYINT&#x27;&gt;"}, "sqlglot.expressions.DataType.Type.UBIGINT": {"fullname": "sqlglot.expressions.DataType.Type.UBIGINT", "modulename": "sqlglot.expressions", "qualname": "DataType.Type.UBIGINT", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.UBIGINT: &#x27;UBIGINT&#x27;&gt;"}, "sqlglot.expressions.DataType.Type.UINT": {"fullname": "sqlglot.expressions.DataType.Type.UINT", "modulename": "sqlglot.expressions", "qualname": "DataType.Type.UINT", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.UINT: &#x27;UINT&#x27;&gt;"}, "sqlglot.expressions.DataType.Type.USMALLINT": {"fullname": "sqlglot.expressions.DataType.Type.USMALLINT", "modulename": "sqlglot.expressions", "qualname": "DataType.Type.USMALLINT", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.USMALLINT: &#x27;USMALLINT&#x27;&gt;"}, "sqlglot.expressions.DataType.Type.UTINYINT": {"fullname": "sqlglot.expressions.DataType.Type.UTINYINT", "modulename": "sqlglot.expressions", "qualname": "DataType.Type.UTINYINT", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.UTINYINT: &#x27;UTINYINT&#x27;&gt;"}, "sqlglot.expressions.DataType.Type.UNKNOWN": {"fullname": "sqlglot.expressions.DataType.Type.UNKNOWN", "modulename": "sqlglot.expressions", "qualname": "DataType.Type.UNKNOWN", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.UNKNOWN: &#x27;UNKNOWN&#x27;&gt;"}, "sqlglot.expressions.DataType.Type.UINT128": {"fullname": "sqlglot.expressions.DataType.Type.UINT128", "modulename": "sqlglot.expressions", "qualname": "DataType.Type.UINT128", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.UINT128: &#x27;UINT128&#x27;&gt;"}, "sqlglot.expressions.DataType.Type.UINT256": {"fullname": "sqlglot.expressions.DataType.Type.UINT256", "modulename": "sqlglot.expressions", "qualname": "DataType.Type.UINT256", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.UINT256: &#x27;UINT256&#x27;&gt;"}, "sqlglot.expressions.DataType.Type.UNIQUEIDENTIFIER": {"fullname": "sqlglot.expressions.DataType.Type.UNIQUEIDENTIFIER", "modulename": "sqlglot.expressions", "qualname": "DataType.Type.UNIQUEIDENTIFIER", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.UNIQUEIDENTIFIER: &#x27;UNIQUEIDENTIFIER&#x27;&gt;"}, "sqlglot.expressions.DataType.Type.UUID": {"fullname": "sqlglot.expressions.DataType.Type.UUID", "modulename": "sqlglot.expressions", "qualname": "DataType.Type.UUID", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.UUID: &#x27;UUID&#x27;&gt;"}, "sqlglot.expressions.DataType.Type.VARBINARY": {"fullname": "sqlglot.expressions.DataType.Type.VARBINARY", "modulename": "sqlglot.expressions", "qualname": "DataType.Type.VARBINARY", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.VARBINARY: &#x27;VARBINARY&#x27;&gt;"}, "sqlglot.expressions.DataType.Type.VARCHAR": {"fullname": "sqlglot.expressions.DataType.Type.VARCHAR", "modulename": "sqlglot.expressions", "qualname": "DataType.Type.VARCHAR", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.VARCHAR: &#x27;VARCHAR&#x27;&gt;"}, "sqlglot.expressions.DataType.Type.VARIANT": {"fullname": "sqlglot.expressions.DataType.Type.VARIANT", "modulename": "sqlglot.expressions", "qualname": "DataType.Type.VARIANT", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.VARIANT: &#x27;VARIANT&#x27;&gt;"}, "sqlglot.expressions.DataType.Type.XML": {"fullname": "sqlglot.expressions.DataType.Type.XML", "modulename": "sqlglot.expressions", "qualname": "DataType.Type.XML", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Type.XML: &#x27;XML&#x27;&gt;"}, "sqlglot.expressions.DataType.build": {"fullname": "sqlglot.expressions.DataType.build", "modulename": "sqlglot.expressions", "qualname": "DataType.build", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">cls</span>,</span><span class=\"param\">\t<span class=\"n\">dtype</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">DataType</span> <span class=\"o\">|</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">DataType</span><span class=\"o\">.</span><span class=\"n\">Type</span>,</span><span class=\"param\">\t<span class=\"n\">dialect</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">DataType</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.DataType.is_type": {"fullname": "sqlglot.expressions.DataType.is_type", "modulename": "sqlglot.expressions", "qualname": "DataType.is_type", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">dtypes</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">DataType</span> <span class=\"o\">|</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">DataType</span><span class=\"o\">.</span><span class=\"n\">Type</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.PseudoType": {"fullname": "sqlglot.expressions.PseudoType", "modulename": "sqlglot.expressions", "qualname": "PseudoType", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.SubqueryPredicate": {"fullname": "sqlglot.expressions.SubqueryPredicate", "modulename": "sqlglot.expressions", "qualname": "SubqueryPredicate", "kind": "class", "doc": "<p></p>\n", "bases": "Predicate"}, "sqlglot.expressions.All": {"fullname": "sqlglot.expressions.All", "modulename": "sqlglot.expressions", "qualname": "All", "kind": "class", "doc": "<p></p>\n", "bases": "SubqueryPredicate"}, "sqlglot.expressions.Any": {"fullname": "sqlglot.expressions.Any", "modulename": "sqlglot.expressions", "qualname": "Any", "kind": "class", "doc": "<p></p>\n", "bases": "SubqueryPredicate"}, "sqlglot.expressions.Exists": {"fullname": "sqlglot.expressions.Exists", "modulename": "sqlglot.expressions", "qualname": "Exists", "kind": "class", "doc": "<p></p>\n", "bases": "SubqueryPredicate"}, "sqlglot.expressions.Command": {"fullname": "sqlglot.expressions.Command", "modulename": "sqlglot.expressions", "qualname": "Command", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.Transaction": {"fullname": "sqlglot.expressions.Transaction", "modulename": "sqlglot.expressions", "qualname": "Transaction", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.Commit": {"fullname": "sqlglot.expressions.Commit", "modulename": "sqlglot.expressions", "qualname": "Commit", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.Rollback": {"fullname": "sqlglot.expressions.Rollback", "modulename": "sqlglot.expressions", "qualname": "Rollback", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.AlterTable": {"fullname": "sqlglot.expressions.AlterTable", "modulename": "sqlglot.expressions", "qualname": "AlterTable", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.AddConstraint": {"fullname": "sqlglot.expressions.AddConstraint", "modulename": "sqlglot.expressions", "qualname": "AddConstraint", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.DropPartition": {"fullname": "sqlglot.expressions.DropPartition", "modulename": "sqlglot.expressions", "qualname": "DropPartition", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.Binary": {"fullname": "sqlglot.expressions.Binary", "modulename": "sqlglot.expressions", "qualname": "Binary", "kind": "class", "doc": "<p></p>\n", "bases": "Condition"}, "sqlglot.expressions.Add": {"fullname": "sqlglot.expressions.Add", "modulename": "sqlglot.expressions", "qualname": "Add", "kind": "class", "doc": "<p></p>\n", "bases": "Binary"}, "sqlglot.expressions.Connector": {"fullname": "sqlglot.expressions.Connector", "modulename": "sqlglot.expressions", "qualname": "Connector", "kind": "class", "doc": "<p></p>\n", "bases": "Binary"}, "sqlglot.expressions.And": {"fullname": "sqlglot.expressions.And", "modulename": "sqlglot.expressions", "qualname": "And", "kind": "class", "doc": "<p></p>\n", "bases": "Connector"}, "sqlglot.expressions.Or": {"fullname": "sqlglot.expressions.Or", "modulename": "sqlglot.expressions", "qualname": "Or", "kind": "class", "doc": "<p></p>\n", "bases": "Connector"}, "sqlglot.expressions.BitwiseAnd": {"fullname": "sqlglot.expressions.BitwiseAnd", "modulename": "sqlglot.expressions", "qualname": "BitwiseAnd", "kind": "class", "doc": "<p></p>\n", "bases": "Binary"}, "sqlglot.expressions.BitwiseLeftShift": {"fullname": "sqlglot.expressions.BitwiseLeftShift", "modulename": "sqlglot.expressions", "qualname": "BitwiseLeftShift", "kind": "class", "doc": "<p></p>\n", "bases": "Binary"}, "sqlglot.expressions.BitwiseOr": {"fullname": "sqlglot.expressions.BitwiseOr", "modulename": "sqlglot.expressions", "qualname": "BitwiseOr", "kind": "class", "doc": "<p></p>\n", "bases": "Binary"}, "sqlglot.expressions.BitwiseRightShift": {"fullname": "sqlglot.expressions.BitwiseRightShift", "modulename": "sqlglot.expressions", "qualname": "BitwiseRightShift", "kind": "class", "doc": "<p></p>\n", "bases": "Binary"}, "sqlglot.expressions.BitwiseXor": {"fullname": "sqlglot.expressions.BitwiseXor", "modulename": "sqlglot.expressions", "qualname": "BitwiseXor", "kind": "class", "doc": "<p></p>\n", "bases": "Binary"}, "sqlglot.expressions.Div": {"fullname": "sqlglot.expressions.Div", "modulename": "sqlglot.expressions", "qualname": "Div", "kind": "class", "doc": "<p></p>\n", "bases": "Binary"}, "sqlglot.expressions.Overlaps": {"fullname": "sqlglot.expressions.Overlaps", "modulename": "sqlglot.expressions", "qualname": "Overlaps", "kind": "class", "doc": "<p></p>\n", "bases": "Binary"}, "sqlglot.expressions.Dot": {"fullname": "sqlglot.expressions.Dot", "modulename": "sqlglot.expressions", "qualname": "Dot", "kind": "class", "doc": "<p></p>\n", "bases": "Binary"}, "sqlglot.expressions.Dot.build": {"fullname": "sqlglot.expressions.Dot.build", "modulename": "sqlglot.expressions", "qualname": "Dot.build", "kind": "function", "doc": "<p>Build a Dot object with a sequence of expressions.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">expressions</span><span class=\"p\">:</span> <span class=\"n\">Sequence</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Dot</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.DPipe": {"fullname": "sqlglot.expressions.DPipe", "modulename": "sqlglot.expressions", "qualname": "DPipe", "kind": "class", "doc": "<p></p>\n", "bases": "Binary"}, "sqlglot.expressions.EQ": {"fullname": "sqlglot.expressions.EQ", "modulename": "sqlglot.expressions", "qualname": "EQ", "kind": "class", "doc": "<p></p>\n", "bases": "Binary, Predicate"}, "sqlglot.expressions.NullSafeEQ": {"fullname": "sqlglot.expressions.NullSafeEQ", "modulename": "sqlglot.expressions", "qualname": "NullSafeEQ", "kind": "class", "doc": "<p></p>\n", "bases": "Binary, Predicate"}, "sqlglot.expressions.NullSafeNEQ": {"fullname": "sqlglot.expressions.NullSafeNEQ", "modulename": "sqlglot.expressions", "qualname": "NullSafeNEQ", "kind": "class", "doc": "<p></p>\n", "bases": "Binary, Predicate"}, "sqlglot.expressions.Distance": {"fullname": "sqlglot.expressions.Distance", "modulename": "sqlglot.expressions", "qualname": "Distance", "kind": "class", "doc": "<p></p>\n", "bases": "Binary"}, "sqlglot.expressions.Escape": {"fullname": "sqlglot.expressions.Escape", "modulename": "sqlglot.expressions", "qualname": "Escape", "kind": "class", "doc": "<p></p>\n", "bases": "Binary"}, "sqlglot.expressions.Glob": {"fullname": "sqlglot.expressions.Glob", "modulename": "sqlglot.expressions", "qualname": "Glob", "kind": "class", "doc": "<p></p>\n", "bases": "Binary, Predicate"}, "sqlglot.expressions.GT": {"fullname": "sqlglot.expressions.GT", "modulename": "sqlglot.expressions", "qualname": "GT", "kind": "class", "doc": "<p></p>\n", "bases": "Binary, Predicate"}, "sqlglot.expressions.GTE": {"fullname": "sqlglot.expressions.GTE", "modulename": "sqlglot.expressions", "qualname": "GTE", "kind": "class", "doc": "<p></p>\n", "bases": "Binary, Predicate"}, "sqlglot.expressions.ILike": {"fullname": "sqlglot.expressions.ILike", "modulename": "sqlglot.expressions", "qualname": "ILike", "kind": "class", "doc": "<p></p>\n", "bases": "Binary, Predicate"}, "sqlglot.expressions.ILikeAny": {"fullname": "sqlglot.expressions.ILikeAny", "modulename": "sqlglot.expressions", "qualname": "ILikeAny", "kind": "class", "doc": "<p></p>\n", "bases": "Binary, Predicate"}, "sqlglot.expressions.IntDiv": {"fullname": "sqlglot.expressions.IntDiv", "modulename": "sqlglot.expressions", "qualname": "IntDiv", "kind": "class", "doc": "<p></p>\n", "bases": "Binary"}, "sqlglot.expressions.Is": {"fullname": "sqlglot.expressions.Is", "modulename": "sqlglot.expressions", "qualname": "Is", "kind": "class", "doc": "<p></p>\n", "bases": "Binary, Predicate"}, "sqlglot.expressions.Kwarg": {"fullname": "sqlglot.expressions.Kwarg", "modulename": "sqlglot.expressions", "qualname": "Kwarg", "kind": "class", "doc": "<p>Kwarg in special functions like func(kwarg =&gt; y).</p>\n", "bases": "Binary"}, "sqlglot.expressions.Like": {"fullname": "sqlglot.expressions.Like", "modulename": "sqlglot.expressions", "qualname": "Like", "kind": "class", "doc": "<p></p>\n", "bases": "Binary, Predicate"}, "sqlglot.expressions.LikeAny": {"fullname": "sqlglot.expressions.LikeAny", "modulename": "sqlglot.expressions", "qualname": "LikeAny", "kind": "class", "doc": "<p></p>\n", "bases": "Binary, Predicate"}, "sqlglot.expressions.LT": {"fullname": "sqlglot.expressions.LT", "modulename": "sqlglot.expressions", "qualname": "LT", "kind": "class", "doc": "<p></p>\n", "bases": "Binary, Predicate"}, "sqlglot.expressions.LTE": {"fullname": "sqlglot.expressions.LTE", "modulename": "sqlglot.expressions", "qualname": "LTE", "kind": "class", "doc": "<p></p>\n", "bases": "Binary, Predicate"}, "sqlglot.expressions.Mod": {"fullname": "sqlglot.expressions.Mod", "modulename": "sqlglot.expressions", "qualname": "Mod", "kind": "class", "doc": "<p></p>\n", "bases": "Binary"}, "sqlglot.expressions.Mul": {"fullname": "sqlglot.expressions.Mul", "modulename": "sqlglot.expressions", "qualname": "Mul", "kind": "class", "doc": "<p></p>\n", "bases": "Binary"}, "sqlglot.expressions.NEQ": {"fullname": "sqlglot.expressions.NEQ", "modulename": "sqlglot.expressions", "qualname": "NEQ", "kind": "class", "doc": "<p></p>\n", "bases": "Binary, Predicate"}, "sqlglot.expressions.SimilarTo": {"fullname": "sqlglot.expressions.SimilarTo", "modulename": "sqlglot.expressions", "qualname": "SimilarTo", "kind": "class", "doc": "<p></p>\n", "bases": "Binary, Predicate"}, "sqlglot.expressions.Slice": {"fullname": "sqlglot.expressions.Slice", "modulename": "sqlglot.expressions", "qualname": "Slice", "kind": "class", "doc": "<p></p>\n", "bases": "Binary"}, "sqlglot.expressions.Sub": {"fullname": "sqlglot.expressions.Sub", "modulename": "sqlglot.expressions", "qualname": "Sub", "kind": "class", "doc": "<p></p>\n", "bases": "Binary"}, "sqlglot.expressions.ArrayOverlaps": {"fullname": "sqlglot.expressions.ArrayOverlaps", "modulename": "sqlglot.expressions", "qualname": "ArrayOverlaps", "kind": "class", "doc": "<p></p>\n", "bases": "Binary"}, "sqlglot.expressions.Unary": {"fullname": "sqlglot.expressions.Unary", "modulename": "sqlglot.expressions", "qualname": "Unary", "kind": "class", "doc": "<p></p>\n", "bases": "Condition"}, "sqlglot.expressions.BitwiseNot": {"fullname": "sqlglot.expressions.BitwiseNot", "modulename": "sqlglot.expressions", "qualname": "BitwiseNot", "kind": "class", "doc": "<p></p>\n", "bases": "Unary"}, "sqlglot.expressions.Not": {"fullname": "sqlglot.expressions.Not", "modulename": "sqlglot.expressions", "qualname": "Not", "kind": "class", "doc": "<p></p>\n", "bases": "Unary"}, "sqlglot.expressions.Paren": {"fullname": "sqlglot.expressions.Paren", "modulename": "sqlglot.expressions", "qualname": "Paren", "kind": "class", "doc": "<p></p>\n", "bases": "Unary"}, "sqlglot.expressions.Neg": {"fullname": "sqlglot.expressions.Neg", "modulename": "sqlglot.expressions", "qualname": "Neg", "kind": "class", "doc": "<p></p>\n", "bases": "Unary"}, "sqlglot.expressions.Alias": {"fullname": "sqlglot.expressions.Alias", "modulename": "sqlglot.expressions", "qualname": "Alias", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.Alias.output_name": {"fullname": "sqlglot.expressions.Alias.output_name", "modulename": "sqlglot.expressions", "qualname": "Alias.output_name", "kind": "variable", "doc": "<p>Name of the output column if this expression is a selection.</p>\n\n<p>If the Expression has no output name, an empty string is returned.</p>\n\n<h6 id=\"example\">Example:</h6>\n\n<blockquote>\n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"kn\">from</span> <span class=\"nn\">sqlglot</span> <span class=\"kn\">import</span> <span class=\"n\">parse_one</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">parse_one</span><span class=\"p\">(</span><span class=\"s2\">&quot;SELECT a&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"p\">[</span><span class=\"mi\">0</span><span class=\"p\">]</span><span class=\"o\">.</span><span class=\"n\">output_name</span>\n<span class=\"go\">&#39;a&#39;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">parse_one</span><span class=\"p\">(</span><span class=\"s2\">&quot;SELECT b AS c&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"p\">[</span><span class=\"mi\">0</span><span class=\"p\">]</span><span class=\"o\">.</span><span class=\"n\">output_name</span>\n<span class=\"go\">&#39;c&#39;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">parse_one</span><span class=\"p\">(</span><span class=\"s2\">&quot;SELECT 1 + 2&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"p\">[</span><span class=\"mi\">0</span><span class=\"p\">]</span><span class=\"o\">.</span><span class=\"n\">output_name</span>\n<span class=\"go\">&#39;&#39;</span>\n</code></pre>\n  </div>\n</blockquote>\n", "annotation": ": str"}, "sqlglot.expressions.Aliases": {"fullname": "sqlglot.expressions.Aliases", "modulename": "sqlglot.expressions", "qualname": "Aliases", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.AtTimeZone": {"fullname": "sqlglot.expressions.AtTimeZone", "modulename": "sqlglot.expressions", "qualname": "AtTimeZone", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.Between": {"fullname": "sqlglot.expressions.Between", "modulename": "sqlglot.expressions", "qualname": "Between", "kind": "class", "doc": "<p></p>\n", "bases": "Predicate"}, "sqlglot.expressions.Bracket": {"fullname": "sqlglot.expressions.Bracket", "modulename": "sqlglot.expressions", "qualname": "Bracket", "kind": "class", "doc": "<p></p>\n", "bases": "Condition"}, "sqlglot.expressions.Distinct": {"fullname": "sqlglot.expressions.Distinct", "modulename": "sqlglot.expressions", "qualname": "Distinct", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.In": {"fullname": "sqlglot.expressions.In", "modulename": "sqlglot.expressions", "qualname": "In", "kind": "class", "doc": "<p></p>\n", "bases": "Predicate"}, "sqlglot.expressions.TimeUnit": {"fullname": "sqlglot.expressions.TimeUnit", "modulename": "sqlglot.expressions", "qualname": "TimeUnit", "kind": "class", "doc": "<p>Automatically converts unit arg into a var.</p>\n", "bases": "Expression"}, "sqlglot.expressions.TimeUnit.__init__": {"fullname": "sqlglot.expressions.TimeUnit.__init__", "modulename": "sqlglot.expressions", "qualname": "TimeUnit.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"o\">**</span><span class=\"n\">args</span></span>)</span>"}, "sqlglot.expressions.Interval": {"fullname": "sqlglot.expressions.Interval", "modulename": "sqlglot.expressions", "qualname": "Interval", "kind": "class", "doc": "<p></p>\n", "bases": "TimeUnit"}, "sqlglot.expressions.IgnoreNulls": {"fullname": "sqlglot.expressions.IgnoreNulls", "modulename": "sqlglot.expressions", "qualname": "IgnoreNulls", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.RespectNulls": {"fullname": "sqlglot.expressions.RespectNulls", "modulename": "sqlglot.expressions", "qualname": "RespectNulls", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.Func": {"fullname": "sqlglot.expressions.Func", "modulename": "sqlglot.expressions", "qualname": "Func", "kind": "class", "doc": "<p>The base class for all function expressions.</p>\n\n<h6 id=\"attributes\">Attributes:</h6>\n\n<ul>\n<li><strong>is_var_len_args (bool):</strong>  if set to True the last argument defined in arg_types will be\ntreated as a variable length argument and the argument's value will be stored as a list.</li>\n<li><strong>_sql_names (list):</strong>  determines the SQL name (1st item in the list) and aliases (subsequent items)\nfor this function expression. These values are used to map this node to a name during parsing\nas well as to provide the function's name during SQL string generation. By default the SQL\nname is set to the expression's class name transformed to snake case.</li>\n</ul>\n", "bases": "Condition"}, "sqlglot.expressions.Func.from_arg_list": {"fullname": "sqlglot.expressions.Func.from_arg_list", "modulename": "sqlglot.expressions", "qualname": "Func.from_arg_list", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span>, </span><span class=\"param\"><span class=\"n\">args</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlglot.expressions.Func.sql_names": {"fullname": "sqlglot.expressions.Func.sql_names", "modulename": "sqlglot.expressions", "qualname": "Func.sql_names", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlglot.expressions.Func.sql_name": {"fullname": "sqlglot.expressions.Func.sql_name", "modulename": "sqlglot.expressions", "qualname": "Func.sql_name", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlglot.expressions.Func.default_parser_mappings": {"fullname": "sqlglot.expressions.Func.default_parser_mappings", "modulename": "sqlglot.expressions", "qualname": "Func.default_parser_mappings", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlglot.expressions.AggFunc": {"fullname": "sqlglot.expressions.AggFunc", "modulename": "sqlglot.expressions", "qualname": "AggFunc", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.ParameterizedAgg": {"fullname": "sqlglot.expressions.ParameterizedAgg", "modulename": "sqlglot.expressions", "qualname": "ParameterizedAgg", "kind": "class", "doc": "<p></p>\n", "bases": "AggFunc"}, "sqlglot.expressions.Abs": {"fullname": "sqlglot.expressions.Abs", "modulename": "sqlglot.expressions", "qualname": "Abs", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.Anonymous": {"fullname": "sqlglot.expressions.Anonymous", "modulename": "sqlglot.expressions", "qualname": "Anonymous", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.Hll": {"fullname": "sqlglot.expressions.Hll", "modulename": "sqlglot.expressions", "qualname": "Hll", "kind": "class", "doc": "<p></p>\n", "bases": "AggFunc"}, "sqlglot.expressions.ApproxDistinct": {"fullname": "sqlglot.expressions.ApproxDistinct", "modulename": "sqlglot.expressions", "qualname": "ApproxDistinct", "kind": "class", "doc": "<p></p>\n", "bases": "AggFunc"}, "sqlglot.expressions.Array": {"fullname": "sqlglot.expressions.Array", "modulename": "sqlglot.expressions", "qualname": "Array", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.ToChar": {"fullname": "sqlglot.expressions.ToChar", "modulename": "sqlglot.expressions", "qualname": "ToChar", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.GenerateSeries": {"fullname": "sqlglot.expressions.GenerateSeries", "modulename": "sqlglot.expressions", "qualname": "GenerateSeries", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.ArrayAgg": {"fullname": "sqlglot.expressions.ArrayAgg", "modulename": "sqlglot.expressions", "qualname": "ArrayAgg", "kind": "class", "doc": "<p></p>\n", "bases": "AggFunc"}, "sqlglot.expressions.ArrayAll": {"fullname": "sqlglot.expressions.ArrayAll", "modulename": "sqlglot.expressions", "qualname": "ArrayAll", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.ArrayAny": {"fullname": "sqlglot.expressions.ArrayAny", "modulename": "sqlglot.expressions", "qualname": "ArrayAny", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.ArrayConcat": {"fullname": "sqlglot.expressions.ArrayConcat", "modulename": "sqlglot.expressions", "qualname": "ArrayConcat", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.ArrayContains": {"fullname": "sqlglot.expressions.ArrayContains", "modulename": "sqlglot.expressions", "qualname": "ArrayContains", "kind": "class", "doc": "<p></p>\n", "bases": "Binary, Func"}, "sqlglot.expressions.ArrayContained": {"fullname": "sqlglot.expressions.ArrayContained", "modulename": "sqlglot.expressions", "qualname": "ArrayContained", "kind": "class", "doc": "<p></p>\n", "bases": "Binary"}, "sqlglot.expressions.ArrayFilter": {"fullname": "sqlglot.expressions.ArrayFilter", "modulename": "sqlglot.expressions", "qualname": "ArrayFilter", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.ArrayJoin": {"fullname": "sqlglot.expressions.ArrayJoin", "modulename": "sqlglot.expressions", "qualname": "ArrayJoin", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.ArraySize": {"fullname": "sqlglot.expressions.ArraySize", "modulename": "sqlglot.expressions", "qualname": "ArraySize", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.ArraySort": {"fullname": "sqlglot.expressions.ArraySort", "modulename": "sqlglot.expressions", "qualname": "ArraySort", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.ArraySum": {"fullname": "sqlglot.expressions.ArraySum", "modulename": "sqlglot.expressions", "qualname": "ArraySum", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.ArrayUnionAgg": {"fullname": "sqlglot.expressions.ArrayUnionAgg", "modulename": "sqlglot.expressions", "qualname": "ArrayUnionAgg", "kind": "class", "doc": "<p></p>\n", "bases": "AggFunc"}, "sqlglot.expressions.Avg": {"fullname": "sqlglot.expressions.Avg", "modulename": "sqlglot.expressions", "qualname": "Avg", "kind": "class", "doc": "<p></p>\n", "bases": "AggFunc"}, "sqlglot.expressions.AnyValue": {"fullname": "sqlglot.expressions.AnyValue", "modulename": "sqlglot.expressions", "qualname": "AnyValue", "kind": "class", "doc": "<p></p>\n", "bases": "AggFunc"}, "sqlglot.expressions.Case": {"fullname": "sqlglot.expressions.Case", "modulename": "sqlglot.expressions", "qualname": "Case", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.Case.when": {"fullname": "sqlglot.expressions.Case.when", "modulename": "sqlglot.expressions", "qualname": "Case.when", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">condition</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">then</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">copy</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">opts</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Case</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.Case.else_": {"fullname": "sqlglot.expressions.Case.else_", "modulename": "sqlglot.expressions", "qualname": "Case.else_", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">condition</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">copy</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">opts</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Case</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.Cast": {"fullname": "sqlglot.expressions.Cast", "modulename": "sqlglot.expressions", "qualname": "Cast", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.Cast.output_name": {"fullname": "sqlglot.expressions.Cast.output_name", "modulename": "sqlglot.expressions", "qualname": "Cast.output_name", "kind": "variable", "doc": "<p>Name of the output column if this expression is a selection.</p>\n\n<p>If the Expression has no output name, an empty string is returned.</p>\n\n<h6 id=\"example\">Example:</h6>\n\n<blockquote>\n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"kn\">from</span> <span class=\"nn\">sqlglot</span> <span class=\"kn\">import</span> <span class=\"n\">parse_one</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">parse_one</span><span class=\"p\">(</span><span class=\"s2\">&quot;SELECT a&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"p\">[</span><span class=\"mi\">0</span><span class=\"p\">]</span><span class=\"o\">.</span><span class=\"n\">output_name</span>\n<span class=\"go\">&#39;a&#39;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">parse_one</span><span class=\"p\">(</span><span class=\"s2\">&quot;SELECT b AS c&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"p\">[</span><span class=\"mi\">0</span><span class=\"p\">]</span><span class=\"o\">.</span><span class=\"n\">output_name</span>\n<span class=\"go\">&#39;c&#39;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">parse_one</span><span class=\"p\">(</span><span class=\"s2\">&quot;SELECT 1 + 2&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"p\">[</span><span class=\"mi\">0</span><span class=\"p\">]</span><span class=\"o\">.</span><span class=\"n\">output_name</span>\n<span class=\"go\">&#39;&#39;</span>\n</code></pre>\n  </div>\n</blockquote>\n", "annotation": ": str"}, "sqlglot.expressions.Cast.is_type": {"fullname": "sqlglot.expressions.Cast.is_type", "modulename": "sqlglot.expressions", "qualname": "Cast.is_type", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">dtypes</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">DataType</span> <span class=\"o\">|</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">DataType</span><span class=\"o\">.</span><span class=\"n\">Type</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.CastToStrType": {"fullname": "sqlglot.expressions.CastToStrType", "modulename": "sqlglot.expressions", "qualname": "CastToStrType", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.Collate": {"fullname": "sqlglot.expressions.Collate", "modulename": "sqlglot.expressions", "qualname": "Collate", "kind": "class", "doc": "<p></p>\n", "bases": "Binary"}, "sqlglot.expressions.TryCast": {"fullname": "sqlglot.expressions.TryCast", "modulename": "sqlglot.expressions", "qualname": "TryCast", "kind": "class", "doc": "<p></p>\n", "bases": "Cast"}, "sqlglot.expressions.Ceil": {"fullname": "sqlglot.expressions.Ceil", "modulename": "sqlglot.expressions", "qualname": "Ceil", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.Coalesce": {"fullname": "sqlglot.expressions.Coalesce", "modulename": "sqlglot.expressions", "qualname": "Coalesce", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.Concat": {"fullname": "sqlglot.expressions.Concat", "modulename": "sqlglot.expressions", "qualname": "Concat", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.ConcatWs": {"fullname": "sqlglot.expressions.ConcatWs", "modulename": "sqlglot.expressions", "qualname": "ConcatWs", "kind": "class", "doc": "<p></p>\n", "bases": "Concat"}, "sqlglot.expressions.Count": {"fullname": "sqlglot.expressions.Count", "modulename": "sqlglot.expressions", "qualname": "Count", "kind": "class", "doc": "<p></p>\n", "bases": "AggFunc"}, "sqlglot.expressions.CountIf": {"fullname": "sqlglot.expressions.CountIf", "modulename": "sqlglot.expressions", "qualname": "CountIf", "kind": "class", "doc": "<p></p>\n", "bases": "AggFunc"}, "sqlglot.expressions.CurrentDate": {"fullname": "sqlglot.expressions.CurrentDate", "modulename": "sqlglot.expressions", "qualname": "CurrentDate", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.CurrentDatetime": {"fullname": "sqlglot.expressions.CurrentDatetime", "modulename": "sqlglot.expressions", "qualname": "CurrentDatetime", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.CurrentTime": {"fullname": "sqlglot.expressions.CurrentTime", "modulename": "sqlglot.expressions", "qualname": "CurrentTime", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.CurrentTimestamp": {"fullname": "sqlglot.expressions.CurrentTimestamp", "modulename": "sqlglot.expressions", "qualname": "CurrentTimestamp", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.CurrentUser": {"fullname": "sqlglot.expressions.CurrentUser", "modulename": "sqlglot.expressions", "qualname": "CurrentUser", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.DateAdd": {"fullname": "sqlglot.expressions.DateAdd", "modulename": "sqlglot.expressions", "qualname": "DateAdd", "kind": "class", "doc": "<p></p>\n", "bases": "Func, TimeUnit"}, "sqlglot.expressions.DateSub": {"fullname": "sqlglot.expressions.DateSub", "modulename": "sqlglot.expressions", "qualname": "DateSub", "kind": "class", "doc": "<p></p>\n", "bases": "Func, TimeUnit"}, "sqlglot.expressions.DateDiff": {"fullname": "sqlglot.expressions.DateDiff", "modulename": "sqlglot.expressions", "qualname": "DateDiff", "kind": "class", "doc": "<p></p>\n", "bases": "Func, TimeUnit"}, "sqlglot.expressions.DateTrunc": {"fullname": "sqlglot.expressions.DateTrunc", "modulename": "sqlglot.expressions", "qualname": "DateTrunc", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.DatetimeAdd": {"fullname": "sqlglot.expressions.DatetimeAdd", "modulename": "sqlglot.expressions", "qualname": "DatetimeAdd", "kind": "class", "doc": "<p></p>\n", "bases": "Func, TimeUnit"}, "sqlglot.expressions.DatetimeSub": {"fullname": "sqlglot.expressions.DatetimeSub", "modulename": "sqlglot.expressions", "qualname": "DatetimeSub", "kind": "class", "doc": "<p></p>\n", "bases": "Func, TimeUnit"}, "sqlglot.expressions.DatetimeDiff": {"fullname": "sqlglot.expressions.DatetimeDiff", "modulename": "sqlglot.expressions", "qualname": "DatetimeDiff", "kind": "class", "doc": "<p></p>\n", "bases": "Func, TimeUnit"}, "sqlglot.expressions.DatetimeTrunc": {"fullname": "sqlglot.expressions.DatetimeTrunc", "modulename": "sqlglot.expressions", "qualname": "DatetimeTrunc", "kind": "class", "doc": "<p></p>\n", "bases": "Func, TimeUnit"}, "sqlglot.expressions.DayOfWeek": {"fullname": "sqlglot.expressions.DayOfWeek", "modulename": "sqlglot.expressions", "qualname": "DayOfWeek", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.DayOfMonth": {"fullname": "sqlglot.expressions.DayOfMonth", "modulename": "sqlglot.expressions", "qualname": "DayOfMonth", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.DayOfYear": {"fullname": "sqlglot.expressions.DayOfYear", "modulename": "sqlglot.expressions", "qualname": "DayOfYear", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.WeekOfYear": {"fullname": "sqlglot.expressions.WeekOfYear", "modulename": "sqlglot.expressions", "qualname": "WeekOfYear", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.LastDateOfMonth": {"fullname": "sqlglot.expressions.LastDateOfMonth", "modulename": "sqlglot.expressions", "qualname": "LastDateOfMonth", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.Extract": {"fullname": "sqlglot.expressions.Extract", "modulename": "sqlglot.expressions", "qualname": "Extract", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.TimestampAdd": {"fullname": "sqlglot.expressions.TimestampAdd", "modulename": "sqlglot.expressions", "qualname": "TimestampAdd", "kind": "class", "doc": "<p></p>\n", "bases": "Func, TimeUnit"}, "sqlglot.expressions.TimestampSub": {"fullname": "sqlglot.expressions.TimestampSub", "modulename": "sqlglot.expressions", "qualname": "TimestampSub", "kind": "class", "doc": "<p></p>\n", "bases": "Func, TimeUnit"}, "sqlglot.expressions.TimestampDiff": {"fullname": "sqlglot.expressions.TimestampDiff", "modulename": "sqlglot.expressions", "qualname": "TimestampDiff", "kind": "class", "doc": "<p></p>\n", "bases": "Func, TimeUnit"}, "sqlglot.expressions.TimestampTrunc": {"fullname": "sqlglot.expressions.TimestampTrunc", "modulename": "sqlglot.expressions", "qualname": "TimestampTrunc", "kind": "class", "doc": "<p></p>\n", "bases": "Func, TimeUnit"}, "sqlglot.expressions.TimeAdd": {"fullname": "sqlglot.expressions.TimeAdd", "modulename": "sqlglot.expressions", "qualname": "TimeAdd", "kind": "class", "doc": "<p></p>\n", "bases": "Func, TimeUnit"}, "sqlglot.expressions.TimeSub": {"fullname": "sqlglot.expressions.TimeSub", "modulename": "sqlglot.expressions", "qualname": "TimeSub", "kind": "class", "doc": "<p></p>\n", "bases": "Func, TimeUnit"}, "sqlglot.expressions.TimeDiff": {"fullname": "sqlglot.expressions.TimeDiff", "modulename": "sqlglot.expressions", "qualname": "TimeDiff", "kind": "class", "doc": "<p></p>\n", "bases": "Func, TimeUnit"}, "sqlglot.expressions.TimeTrunc": {"fullname": "sqlglot.expressions.TimeTrunc", "modulename": "sqlglot.expressions", "qualname": "TimeTrunc", "kind": "class", "doc": "<p></p>\n", "bases": "Func, TimeUnit"}, "sqlglot.expressions.DateFromParts": {"fullname": "sqlglot.expressions.DateFromParts", "modulename": "sqlglot.expressions", "qualname": "DateFromParts", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.DateStrToDate": {"fullname": "sqlglot.expressions.DateStrToDate", "modulename": "sqlglot.expressions", "qualname": "DateStrToDate", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.DateToDateStr": {"fullname": "sqlglot.expressions.DateToDateStr", "modulename": "sqlglot.expressions", "qualname": "DateToDateStr", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.DateToDi": {"fullname": "sqlglot.expressions.DateToDi", "modulename": "sqlglot.expressions", "qualname": "DateToDi", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.Day": {"fullname": "sqlglot.expressions.Day", "modulename": "sqlglot.expressions", "qualname": "Day", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.Decode": {"fullname": "sqlglot.expressions.Decode", "modulename": "sqlglot.expressions", "qualname": "Decode", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.DiToDate": {"fullname": "sqlglot.expressions.DiToDate", "modulename": "sqlglot.expressions", "qualname": "DiToDate", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.Encode": {"fullname": "sqlglot.expressions.Encode", "modulename": "sqlglot.expressions", "qualname": "Encode", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.Exp": {"fullname": "sqlglot.expressions.Exp", "modulename": "sqlglot.expressions", "qualname": "Exp", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.Explode": {"fullname": "sqlglot.expressions.Explode", "modulename": "sqlglot.expressions", "qualname": "Explode", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.Floor": {"fullname": "sqlglot.expressions.Floor", "modulename": "sqlglot.expressions", "qualname": "Floor", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.FromBase64": {"fullname": "sqlglot.expressions.FromBase64", "modulename": "sqlglot.expressions", "qualname": "FromBase64", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.ToBase64": {"fullname": "sqlglot.expressions.ToBase64", "modulename": "sqlglot.expressions", "qualname": "ToBase64", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.Greatest": {"fullname": "sqlglot.expressions.Greatest", "modulename": "sqlglot.expressions", "qualname": "Greatest", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.GroupConcat": {"fullname": "sqlglot.expressions.GroupConcat", "modulename": "sqlglot.expressions", "qualname": "GroupConcat", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.Hex": {"fullname": "sqlglot.expressions.Hex", "modulename": "sqlglot.expressions", "qualname": "Hex", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.If": {"fullname": "sqlglot.expressions.If", "modulename": "sqlglot.expressions", "qualname": "If", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.IfNull": {"fullname": "sqlglot.expressions.IfNull", "modulename": "sqlglot.expressions", "qualname": "IfNull", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.Initcap": {"fullname": "sqlglot.expressions.Initcap", "modulename": "sqlglot.expressions", "qualname": "Initcap", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.JSONKeyValue": {"fullname": "sqlglot.expressions.JSONKeyValue", "modulename": "sqlglot.expressions", "qualname": "JSONKeyValue", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.JSONObject": {"fullname": "sqlglot.expressions.JSONObject", "modulename": "sqlglot.expressions", "qualname": "JSONObject", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.OpenJSONColumnDef": {"fullname": "sqlglot.expressions.OpenJSONColumnDef", "modulename": "sqlglot.expressions", "qualname": "OpenJSONColumnDef", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.OpenJSON": {"fullname": "sqlglot.expressions.OpenJSON", "modulename": "sqlglot.expressions", "qualname": "OpenJSON", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.JSONBContains": {"fullname": "sqlglot.expressions.JSONBContains", "modulename": "sqlglot.expressions", "qualname": "JSONBContains", "kind": "class", "doc": "<p></p>\n", "bases": "Binary"}, "sqlglot.expressions.JSONExtract": {"fullname": "sqlglot.expressions.JSONExtract", "modulename": "sqlglot.expressions", "qualname": "JSONExtract", "kind": "class", "doc": "<p></p>\n", "bases": "Binary, Func"}, "sqlglot.expressions.JSONExtractScalar": {"fullname": "sqlglot.expressions.JSONExtractScalar", "modulename": "sqlglot.expressions", "qualname": "JSONExtractScalar", "kind": "class", "doc": "<p></p>\n", "bases": "JSONExtract"}, "sqlglot.expressions.JSONBExtract": {"fullname": "sqlglot.expressions.JSONBExtract", "modulename": "sqlglot.expressions", "qualname": "JSONBExtract", "kind": "class", "doc": "<p></p>\n", "bases": "JSONExtract"}, "sqlglot.expressions.JSONBExtractScalar": {"fullname": "sqlglot.expressions.JSONBExtractScalar", "modulename": "sqlglot.expressions", "qualname": "JSONBExtractScalar", "kind": "class", "doc": "<p></p>\n", "bases": "JSONExtract"}, "sqlglot.expressions.JSONFormat": {"fullname": "sqlglot.expressions.JSONFormat", "modulename": "sqlglot.expressions", "qualname": "JSONFormat", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.Least": {"fullname": "sqlglot.expressions.Least", "modulename": "sqlglot.expressions", "qualname": "Least", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.Left": {"fullname": "sqlglot.expressions.Left", "modulename": "sqlglot.expressions", "qualname": "Left", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.Right": {"fullname": "sqlglot.expressions.Right", "modulename": "sqlglot.expressions", "qualname": "Right", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.Length": {"fullname": "sqlglot.expressions.Length", "modulename": "sqlglot.expressions", "qualname": "Length", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.Levenshtein": {"fullname": "sqlglot.expressions.Levenshtein", "modulename": "sqlglot.expressions", "qualname": "Levenshtein", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.Ln": {"fullname": "sqlglot.expressions.Ln", "modulename": "sqlglot.expressions", "qualname": "Ln", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.Log": {"fullname": "sqlglot.expressions.Log", "modulename": "sqlglot.expressions", "qualname": "Log", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.Log2": {"fullname": "sqlglot.expressions.Log2", "modulename": "sqlglot.expressions", "qualname": "Log2", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.Log10": {"fullname": "sqlglot.expressions.Log10", "modulename": "sqlglot.expressions", "qualname": "Log10", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.LogicalOr": {"fullname": "sqlglot.expressions.LogicalOr", "modulename": "sqlglot.expressions", "qualname": "LogicalOr", "kind": "class", "doc": "<p></p>\n", "bases": "AggFunc"}, "sqlglot.expressions.LogicalAnd": {"fullname": "sqlglot.expressions.LogicalAnd", "modulename": "sqlglot.expressions", "qualname": "LogicalAnd", "kind": "class", "doc": "<p></p>\n", "bases": "AggFunc"}, "sqlglot.expressions.Lower": {"fullname": "sqlglot.expressions.Lower", "modulename": "sqlglot.expressions", "qualname": "Lower", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.Map": {"fullname": "sqlglot.expressions.Map", "modulename": "sqlglot.expressions", "qualname": "Map", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.StarMap": {"fullname": "sqlglot.expressions.StarMap", "modulename": "sqlglot.expressions", "qualname": "StarMap", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.VarMap": {"fullname": "sqlglot.expressions.VarMap", "modulename": "sqlglot.expressions", "qualname": "VarMap", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.MatchAgainst": {"fullname": "sqlglot.expressions.MatchAgainst", "modulename": "sqlglot.expressions", "qualname": "MatchAgainst", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.Max": {"fullname": "sqlglot.expressions.Max", "modulename": "sqlglot.expressions", "qualname": "Max", "kind": "class", "doc": "<p></p>\n", "bases": "AggFunc"}, "sqlglot.expressions.MD5": {"fullname": "sqlglot.expressions.MD5", "modulename": "sqlglot.expressions", "qualname": "MD5", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.Min": {"fullname": "sqlglot.expressions.Min", "modulename": "sqlglot.expressions", "qualname": "Min", "kind": "class", "doc": "<p></p>\n", "bases": "AggFunc"}, "sqlglot.expressions.Month": {"fullname": "sqlglot.expressions.Month", "modulename": "sqlglot.expressions", "qualname": "Month", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.Nvl2": {"fullname": "sqlglot.expressions.Nvl2", "modulename": "sqlglot.expressions", "qualname": "Nvl2", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.Posexplode": {"fullname": "sqlglot.expressions.Posexplode", "modulename": "sqlglot.expressions", "qualname": "Posexplode", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.Pow": {"fullname": "sqlglot.expressions.Pow", "modulename": "sqlglot.expressions", "qualname": "Pow", "kind": "class", "doc": "<p></p>\n", "bases": "Binary, Func"}, "sqlglot.expressions.PercentileCont": {"fullname": "sqlglot.expressions.PercentileCont", "modulename": "sqlglot.expressions", "qualname": "PercentileCont", "kind": "class", "doc": "<p></p>\n", "bases": "AggFunc"}, "sqlglot.expressions.PercentileDisc": {"fullname": "sqlglot.expressions.PercentileDisc", "modulename": "sqlglot.expressions", "qualname": "PercentileDisc", "kind": "class", "doc": "<p></p>\n", "bases": "AggFunc"}, "sqlglot.expressions.Quantile": {"fullname": "sqlglot.expressions.Quantile", "modulename": "sqlglot.expressions", "qualname": "Quantile", "kind": "class", "doc": "<p></p>\n", "bases": "AggFunc"}, "sqlglot.expressions.ApproxQuantile": {"fullname": "sqlglot.expressions.ApproxQuantile", "modulename": "sqlglot.expressions", "qualname": "ApproxQuantile", "kind": "class", "doc": "<p></p>\n", "bases": "Quantile"}, "sqlglot.expressions.RangeN": {"fullname": "sqlglot.expressions.RangeN", "modulename": "sqlglot.expressions", "qualname": "RangeN", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.ReadCSV": {"fullname": "sqlglot.expressions.ReadCSV", "modulename": "sqlglot.expressions", "qualname": "ReadCSV", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.Reduce": {"fullname": "sqlglot.expressions.Reduce", "modulename": "sqlglot.expressions", "qualname": "Reduce", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.RegexpExtract": {"fullname": "sqlglot.expressions.RegexpExtract", "modulename": "sqlglot.expressions", "qualname": "RegexpExtract", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.RegexpLike": {"fullname": "sqlglot.expressions.RegexpLike", "modulename": "sqlglot.expressions", "qualname": "RegexpLike", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.RegexpILike": {"fullname": "sqlglot.expressions.RegexpILike", "modulename": "sqlglot.expressions", "qualname": "RegexpILike", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.RegexpSplit": {"fullname": "sqlglot.expressions.RegexpSplit", "modulename": "sqlglot.expressions", "qualname": "RegexpSplit", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.Repeat": {"fullname": "sqlglot.expressions.Repeat", "modulename": "sqlglot.expressions", "qualname": "Repeat", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.Round": {"fullname": "sqlglot.expressions.Round", "modulename": "sqlglot.expressions", "qualname": "Round", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.RowNumber": {"fullname": "sqlglot.expressions.RowNumber", "modulename": "sqlglot.expressions", "qualname": "RowNumber", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.SafeDivide": {"fullname": "sqlglot.expressions.SafeDivide", "modulename": "sqlglot.expressions", "qualname": "SafeDivide", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.SetAgg": {"fullname": "sqlglot.expressions.SetAgg", "modulename": "sqlglot.expressions", "qualname": "SetAgg", "kind": "class", "doc": "<p></p>\n", "bases": "AggFunc"}, "sqlglot.expressions.SHA": {"fullname": "sqlglot.expressions.SHA", "modulename": "sqlglot.expressions", "qualname": "SHA", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.SHA2": {"fullname": "sqlglot.expressions.SHA2", "modulename": "sqlglot.expressions", "qualname": "SHA2", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.SortArray": {"fullname": "sqlglot.expressions.SortArray", "modulename": "sqlglot.expressions", "qualname": "SortArray", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.Split": {"fullname": "sqlglot.expressions.Split", "modulename": "sqlglot.expressions", "qualname": "Split", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.Substring": {"fullname": "sqlglot.expressions.Substring", "modulename": "sqlglot.expressions", "qualname": "Substring", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.StandardHash": {"fullname": "sqlglot.expressions.StandardHash", "modulename": "sqlglot.expressions", "qualname": "StandardHash", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.StrPosition": {"fullname": "sqlglot.expressions.StrPosition", "modulename": "sqlglot.expressions", "qualname": "StrPosition", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.StrToDate": {"fullname": "sqlglot.expressions.StrToDate", "modulename": "sqlglot.expressions", "qualname": "StrToDate", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.StrToTime": {"fullname": "sqlglot.expressions.StrToTime", "modulename": "sqlglot.expressions", "qualname": "StrToTime", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.StrToUnix": {"fullname": "sqlglot.expressions.StrToUnix", "modulename": "sqlglot.expressions", "qualname": "StrToUnix", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.NumberToStr": {"fullname": "sqlglot.expressions.NumberToStr", "modulename": "sqlglot.expressions", "qualname": "NumberToStr", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.Struct": {"fullname": "sqlglot.expressions.Struct", "modulename": "sqlglot.expressions", "qualname": "Struct", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.StructExtract": {"fullname": "sqlglot.expressions.StructExtract", "modulename": "sqlglot.expressions", "qualname": "StructExtract", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.Sum": {"fullname": "sqlglot.expressions.Sum", "modulename": "sqlglot.expressions", "qualname": "Sum", "kind": "class", "doc": "<p></p>\n", "bases": "AggFunc"}, "sqlglot.expressions.Sqrt": {"fullname": "sqlglot.expressions.Sqrt", "modulename": "sqlglot.expressions", "qualname": "Sqrt", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.Stddev": {"fullname": "sqlglot.expressions.Stddev", "modulename": "sqlglot.expressions", "qualname": "Stddev", "kind": "class", "doc": "<p></p>\n", "bases": "AggFunc"}, "sqlglot.expressions.StddevPop": {"fullname": "sqlglot.expressions.StddevPop", "modulename": "sqlglot.expressions", "qualname": "StddevPop", "kind": "class", "doc": "<p></p>\n", "bases": "AggFunc"}, "sqlglot.expressions.StddevSamp": {"fullname": "sqlglot.expressions.StddevSamp", "modulename": "sqlglot.expressions", "qualname": "StddevSamp", "kind": "class", "doc": "<p></p>\n", "bases": "AggFunc"}, "sqlglot.expressions.TimeToStr": {"fullname": "sqlglot.expressions.TimeToStr", "modulename": "sqlglot.expressions", "qualname": "TimeToStr", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.TimeToTimeStr": {"fullname": "sqlglot.expressions.TimeToTimeStr", "modulename": "sqlglot.expressions", "qualname": "TimeToTimeStr", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.TimeToUnix": {"fullname": "sqlglot.expressions.TimeToUnix", "modulename": "sqlglot.expressions", "qualname": "TimeToUnix", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.TimeStrToDate": {"fullname": "sqlglot.expressions.TimeStrToDate", "modulename": "sqlglot.expressions", "qualname": "TimeStrToDate", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.TimeStrToTime": {"fullname": "sqlglot.expressions.TimeStrToTime", "modulename": "sqlglot.expressions", "qualname": "TimeStrToTime", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.TimeStrToUnix": {"fullname": "sqlglot.expressions.TimeStrToUnix", "modulename": "sqlglot.expressions", "qualname": "TimeStrToUnix", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.Trim": {"fullname": "sqlglot.expressions.Trim", "modulename": "sqlglot.expressions", "qualname": "Trim", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.TsOrDsAdd": {"fullname": "sqlglot.expressions.TsOrDsAdd", "modulename": "sqlglot.expressions", "qualname": "TsOrDsAdd", "kind": "class", "doc": "<p></p>\n", "bases": "Func, TimeUnit"}, "sqlglot.expressions.TsOrDsToDateStr": {"fullname": "sqlglot.expressions.TsOrDsToDateStr", "modulename": "sqlglot.expressions", "qualname": "TsOrDsToDateStr", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.TsOrDsToDate": {"fullname": "sqlglot.expressions.TsOrDsToDate", "modulename": "sqlglot.expressions", "qualname": "TsOrDsToDate", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.TsOrDiToDi": {"fullname": "sqlglot.expressions.TsOrDiToDi", "modulename": "sqlglot.expressions", "qualname": "TsOrDiToDi", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.Unhex": {"fullname": "sqlglot.expressions.Unhex", "modulename": "sqlglot.expressions", "qualname": "Unhex", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.UnixToStr": {"fullname": "sqlglot.expressions.UnixToStr", "modulename": "sqlglot.expressions", "qualname": "UnixToStr", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.UnixToTime": {"fullname": "sqlglot.expressions.UnixToTime", "modulename": "sqlglot.expressions", "qualname": "UnixToTime", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.UnixToTimeStr": {"fullname": "sqlglot.expressions.UnixToTimeStr", "modulename": "sqlglot.expressions", "qualname": "UnixToTimeStr", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.Upper": {"fullname": "sqlglot.expressions.Upper", "modulename": "sqlglot.expressions", "qualname": "Upper", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.Variance": {"fullname": "sqlglot.expressions.Variance", "modulename": "sqlglot.expressions", "qualname": "Variance", "kind": "class", "doc": "<p></p>\n", "bases": "AggFunc"}, "sqlglot.expressions.VariancePop": {"fullname": "sqlglot.expressions.VariancePop", "modulename": "sqlglot.expressions", "qualname": "VariancePop", "kind": "class", "doc": "<p></p>\n", "bases": "AggFunc"}, "sqlglot.expressions.Week": {"fullname": "sqlglot.expressions.Week", "modulename": "sqlglot.expressions", "qualname": "Week", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.XMLTable": {"fullname": "sqlglot.expressions.XMLTable", "modulename": "sqlglot.expressions", "qualname": "XMLTable", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.Year": {"fullname": "sqlglot.expressions.Year", "modulename": "sqlglot.expressions", "qualname": "Year", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.Use": {"fullname": "sqlglot.expressions.Use", "modulename": "sqlglot.expressions", "qualname": "Use", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.Merge": {"fullname": "sqlglot.expressions.Merge", "modulename": "sqlglot.expressions", "qualname": "Merge", "kind": "class", "doc": "<p></p>\n", "bases": "Expression"}, "sqlglot.expressions.When": {"fullname": "sqlglot.expressions.When", "modulename": "sqlglot.expressions", "qualname": "When", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.NextValueFor": {"fullname": "sqlglot.expressions.NextValueFor", "modulename": "sqlglot.expressions", "qualname": "NextValueFor", "kind": "class", "doc": "<p></p>\n", "bases": "Func"}, "sqlglot.expressions.maybe_parse": {"fullname": "sqlglot.expressions.maybe_parse", "modulename": "sqlglot.expressions", "qualname": "maybe_parse", "kind": "function", "doc": "<p>Gracefully handle a possible string or expression.</p>\n\n<h6 id=\"example\">Example:</h6>\n\n<blockquote>\n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">maybe_parse</span><span class=\"p\">(</span><span class=\"s2\">&quot;1&quot;</span><span class=\"p\">)</span>\n<span class=\"go\">(LITERAL this: 1, is_string: False)</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">maybe_parse</span><span class=\"p\">(</span><span class=\"n\">to_identifier</span><span class=\"p\">(</span><span class=\"s2\">&quot;x&quot;</span><span class=\"p\">))</span>\n<span class=\"go\">(IDENTIFIER this: x, quoted: False)</span>\n</code></pre>\n  </div>\n</blockquote>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>sql_or_expression:</strong>  the SQL code string or an expression</li>\n<li><strong>into:</strong>  the SQLGlot Expression to parse into</li>\n<li><strong>dialect:</strong>  the dialect used to parse the input expressions (in the case that an\ninput expression is a SQL string).</li>\n<li><strong>prefix:</strong>  a string to prefix the sql with before it gets parsed\n(automatically includes a space)</li>\n<li><strong>copy:</strong>  whether or not to copy the expression.</li>\n<li><strong>**opts:</strong>  other options to use to parse the input expressions (again, in the case\nthat an input expression is a SQL string).</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>Expression: the parsed or given expression.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">sql_or_expression</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"o\">*</span>,</span><span class=\"param\">\t<span class=\"n\">into</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">],</span> <span class=\"n\">Collection</span><span class=\"p\">[</span><span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">]]],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">dialect</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">prefix</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">copy</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">opts</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.union": {"fullname": "sqlglot.expressions.union", "modulename": "sqlglot.expressions", "qualname": "union", "kind": "function", "doc": "<p>Initializes a syntax tree from one UNION expression.</p>\n\n<h6 id=\"example\">Example:</h6>\n\n<blockquote>\n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">union</span><span class=\"p\">(</span><span class=\"s2\">&quot;SELECT * FROM foo&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;SELECT * FROM bla&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">()</span>\n<span class=\"go\">&#39;SELECT * FROM foo UNION SELECT * FROM bla&#39;</span>\n</code></pre>\n  </div>\n</blockquote>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>left:</strong>  the SQL code string corresponding to the left-hand side.\nIf an <code>Expression</code> instance is passed, it will be used as-is.</li>\n<li><strong>right:</strong>  the SQL code string corresponding to the right-hand side.\nIf an <code>Expression</code> instance is passed, it will be used as-is.</li>\n<li><strong>distinct:</strong>  set the DISTINCT flag if and only if this is true.</li>\n<li><strong>dialect:</strong>  the dialect used to parse the input expression.</li>\n<li><strong>opts:</strong>  other options to use to parse the input expressions.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The new Union instance.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">left</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">right</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">distinct</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">dialect</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">opts</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Union</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.intersect": {"fullname": "sqlglot.expressions.intersect", "modulename": "sqlglot.expressions", "qualname": "intersect", "kind": "function", "doc": "<p>Initializes a syntax tree from one INTERSECT expression.</p>\n\n<h6 id=\"example\">Example:</h6>\n\n<blockquote>\n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">intersect</span><span class=\"p\">(</span><span class=\"s2\">&quot;SELECT * FROM foo&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;SELECT * FROM bla&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">()</span>\n<span class=\"go\">&#39;SELECT * FROM foo INTERSECT SELECT * FROM bla&#39;</span>\n</code></pre>\n  </div>\n</blockquote>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>left:</strong>  the SQL code string corresponding to the left-hand side.\nIf an <code>Expression</code> instance is passed, it will be used as-is.</li>\n<li><strong>right:</strong>  the SQL code string corresponding to the right-hand side.\nIf an <code>Expression</code> instance is passed, it will be used as-is.</li>\n<li><strong>distinct:</strong>  set the DISTINCT flag if and only if this is true.</li>\n<li><strong>dialect:</strong>  the dialect used to parse the input expression.</li>\n<li><strong>opts:</strong>  other options to use to parse the input expressions.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The new Intersect instance.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">left</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">right</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">distinct</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">dialect</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">opts</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Intersect</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.except_": {"fullname": "sqlglot.expressions.except_", "modulename": "sqlglot.expressions", "qualname": "except_", "kind": "function", "doc": "<p>Initializes a syntax tree from one EXCEPT expression.</p>\n\n<h6 id=\"example\">Example:</h6>\n\n<blockquote>\n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">except_</span><span class=\"p\">(</span><span class=\"s2\">&quot;SELECT * FROM foo&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;SELECT * FROM bla&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">()</span>\n<span class=\"go\">&#39;SELECT * FROM foo EXCEPT SELECT * FROM bla&#39;</span>\n</code></pre>\n  </div>\n</blockquote>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>left:</strong>  the SQL code string corresponding to the left-hand side.\nIf an <code>Expression</code> instance is passed, it will be used as-is.</li>\n<li><strong>right:</strong>  the SQL code string corresponding to the right-hand side.\nIf an <code>Expression</code> instance is passed, it will be used as-is.</li>\n<li><strong>distinct:</strong>  set the DISTINCT flag if and only if this is true.</li>\n<li><strong>dialect:</strong>  the dialect used to parse the input expression.</li>\n<li><strong>opts:</strong>  other options to use to parse the input expressions.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The new Except instance.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">left</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">right</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">distinct</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">dialect</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">opts</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Except</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.select": {"fullname": "sqlglot.expressions.select", "modulename": "sqlglot.expressions", "qualname": "select", "kind": "function", "doc": "<p>Initializes a syntax tree from one or multiple SELECT expressions.</p>\n\n<h6 id=\"example\">Example:</h6>\n\n<blockquote>\n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">select</span><span class=\"p\">(</span><span class=\"s2\">&quot;col1&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;col2&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">from_</span><span class=\"p\">(</span><span class=\"s2\">&quot;tbl&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">()</span>\n<span class=\"go\">&#39;SELECT col1, col2 FROM tbl&#39;</span>\n</code></pre>\n  </div>\n</blockquote>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>*expressions:</strong>  the SQL code string to parse as the expressions of a\nSELECT statement. If an Expression instance is passed, this is used as-is.</li>\n<li><strong>dialect:</strong>  the dialect used to parse the input expressions (in the case that an\ninput expression is a SQL string).</li>\n<li><strong>**opts:</strong>  other options to use to parse the input expressions (again, in the case\nthat an input expression is a SQL string).</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>Select: the syntax tree for the SELECT statement.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">expressions</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">dialect</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">opts</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Select</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.from_": {"fullname": "sqlglot.expressions.from_", "modulename": "sqlglot.expressions", "qualname": "from_", "kind": "function", "doc": "<p>Initializes a syntax tree from a FROM expression.</p>\n\n<h6 id=\"example\">Example:</h6>\n\n<blockquote>\n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">from_</span><span class=\"p\">(</span><span class=\"s2\">&quot;tbl&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">select</span><span class=\"p\">(</span><span class=\"s2\">&quot;col1&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;col2&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">()</span>\n<span class=\"go\">&#39;SELECT col1, col2 FROM tbl&#39;</span>\n</code></pre>\n  </div>\n</blockquote>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>*expression:</strong>  the SQL code string to parse as the FROM expressions of a\nSELECT statement. If an Expression instance is passed, this is used as-is.</li>\n<li><strong>dialect:</strong>  the dialect used to parse the input expression (in the case that the\ninput expression is a SQL string).</li>\n<li><strong>**opts:</strong>  other options to use to parse the input expressions (again, in the case\nthat the input expression is a SQL string).</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>Select: the syntax tree for the SELECT statement.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">dialect</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">opts</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Select</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.update": {"fullname": "sqlglot.expressions.update", "modulename": "sqlglot.expressions", "qualname": "update", "kind": "function", "doc": "<p>Creates an update statement.</p>\n\n<h6 id=\"example\">Example:</h6>\n\n<blockquote>\n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">update</span><span class=\"p\">(</span><span class=\"s2\">&quot;my_table&quot;</span><span class=\"p\">,</span> <span class=\"p\">{</span><span class=\"s2\">&quot;x&quot;</span><span class=\"p\">:</span> <span class=\"mi\">1</span><span class=\"p\">,</span> <span class=\"s2\">&quot;y&quot;</span><span class=\"p\">:</span> <span class=\"s2\">&quot;2&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;z&quot;</span><span class=\"p\">:</span> <span class=\"kc\">None</span><span class=\"p\">},</span> <span class=\"n\">from_</span><span class=\"o\">=</span><span class=\"s2\">&quot;baz&quot;</span><span class=\"p\">,</span> <span class=\"n\">where</span><span class=\"o\">=</span><span class=\"s2\">&quot;id &gt; 1&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">()</span>\n<span class=\"go\">&quot;UPDATE my_table SET x = 1, y = &#39;2&#39;, z = NULL FROM baz WHERE id &gt; 1&quot;</span>\n</code></pre>\n  </div>\n</blockquote>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>*properties:</strong>  dictionary of properties to set which are\nauto converted to sql objects eg None -> NULL</li>\n<li><strong>where:</strong>  sql conditional parsed into a WHERE statement</li>\n<li><strong>from_:</strong>  sql statement parsed into a FROM statement</li>\n<li><strong>dialect:</strong>  the dialect used to parse the input expressions.</li>\n<li><strong>**opts:</strong>  other options to use to parse the input expressions.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>Update: the syntax tree for the UPDATE statement.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">table</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Table</span>,</span><span class=\"param\">\t<span class=\"n\">properties</span><span class=\"p\">:</span> <span class=\"nb\">dict</span>,</span><span class=\"param\">\t<span class=\"n\">where</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">from_</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">dialect</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">opts</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Update</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.delete": {"fullname": "sqlglot.expressions.delete", "modulename": "sqlglot.expressions", "qualname": "delete", "kind": "function", "doc": "<p>Builds a delete statement.</p>\n\n<h6 id=\"example\">Example:</h6>\n\n<blockquote>\n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">delete</span><span class=\"p\">(</span><span class=\"s2\">&quot;my_table&quot;</span><span class=\"p\">,</span> <span class=\"n\">where</span><span class=\"o\">=</span><span class=\"s2\">&quot;id &gt; 1&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">()</span>\n<span class=\"go\">&#39;DELETE FROM my_table WHERE id &gt; 1&#39;</span>\n</code></pre>\n  </div>\n</blockquote>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>where:</strong>  sql conditional parsed into a WHERE statement</li>\n<li><strong>returning:</strong>  sql conditional parsed into a RETURNING statement</li>\n<li><strong>dialect:</strong>  the dialect used to parse the input expressions.</li>\n<li><strong>**opts:</strong>  other options to use to parse the input expressions.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>Delete: the syntax tree for the DELETE statement.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">table</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">where</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">returning</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">dialect</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">opts</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Delete</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.insert": {"fullname": "sqlglot.expressions.insert", "modulename": "sqlglot.expressions", "qualname": "insert", "kind": "function", "doc": "<p>Builds an INSERT statement.</p>\n\n<h6 id=\"example\">Example:</h6>\n\n<blockquote>\n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">insert</span><span class=\"p\">(</span><span class=\"s2\">&quot;VALUES (1, 2, 3)&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;tbl&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">()</span>\n<span class=\"go\">&#39;INSERT INTO tbl VALUES (1, 2, 3)&#39;</span>\n</code></pre>\n  </div>\n</blockquote>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>expression:</strong>  the sql string or expression of the INSERT statement</li>\n<li><strong>into:</strong>  the tbl to insert data to.</li>\n<li><strong>columns:</strong>  optionally the table's column names.</li>\n<li><strong>overwrite:</strong>  whether to INSERT OVERWRITE or not.</li>\n<li><strong>dialect:</strong>  the dialect used to parse the input expressions.</li>\n<li><strong>copy:</strong>  whether or not to copy the expression.</li>\n<li><strong>**opts:</strong>  other options to use to parse the input expressions.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>Insert: the syntax tree for the INSERT statement.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">into</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">columns</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">Sequence</span><span class=\"p\">[</span><span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">]]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">overwrite</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">dialect</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">copy</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">opts</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Insert</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.condition": {"fullname": "sqlglot.expressions.condition", "modulename": "sqlglot.expressions", "qualname": "condition", "kind": "function", "doc": "<p>Initialize a logical condition expression.</p>\n\n<h6 id=\"example\">Example:</h6>\n\n<blockquote>\n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">condition</span><span class=\"p\">(</span><span class=\"s2\">&quot;x=1&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">()</span>\n<span class=\"go\">&#39;x = 1&#39;</span>\n</code></pre>\n  </div>\n  \n  <p>This is helpful for composing larger logical syntax trees:</p>\n  \n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">where</span> <span class=\"o\">=</span> <span class=\"n\">condition</span><span class=\"p\">(</span><span class=\"s2\">&quot;x=1&quot;</span><span class=\"p\">)</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">where</span> <span class=\"o\">=</span> <span class=\"n\">where</span><span class=\"o\">.</span><span class=\"n\">and_</span><span class=\"p\">(</span><span class=\"s2\">&quot;y=1&quot;</span><span class=\"p\">)</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">Select</span><span class=\"p\">()</span><span class=\"o\">.</span><span class=\"n\">from_</span><span class=\"p\">(</span><span class=\"s2\">&quot;tbl&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">select</span><span class=\"p\">(</span><span class=\"s2\">&quot;*&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">where</span><span class=\"p\">(</span><span class=\"n\">where</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">()</span>\n<span class=\"go\">&#39;SELECT * FROM tbl WHERE x = 1 AND y = 1&#39;</span>\n</code></pre>\n  </div>\n</blockquote>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>*expression:</strong>  the SQL code string to parse.\nIf an Expression instance is passed, this is used as-is.</li>\n<li><strong>dialect:</strong>  the dialect used to parse the input expression (in the case that the\ninput expression is a SQL string).</li>\n<li><strong>copy:</strong>  Whether or not to copy <code>expression</code> (only applies to expressions).</li>\n<li><strong>**opts:</strong>  other options to use to parse the input expressions (again, in the case\nthat the input expression is a SQL string).</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The new Condition instance</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">dialect</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">copy</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">opts</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Condition</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.and_": {"fullname": "sqlglot.expressions.and_", "modulename": "sqlglot.expressions", "qualname": "and_", "kind": "function", "doc": "<p>Combine multiple conditions with an AND logical operator.</p>\n\n<h6 id=\"example\">Example:</h6>\n\n<blockquote>\n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">and_</span><span class=\"p\">(</span><span class=\"s2\">&quot;x=1&quot;</span><span class=\"p\">,</span> <span class=\"n\">and_</span><span class=\"p\">(</span><span class=\"s2\">&quot;y=1&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;z=1&quot;</span><span class=\"p\">))</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">()</span>\n<span class=\"go\">&#39;x = 1 AND (y = 1 AND z = 1)&#39;</span>\n</code></pre>\n  </div>\n</blockquote>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>*expressions:</strong>  the SQL code strings to parse.\nIf an Expression instance is passed, this is used as-is.</li>\n<li><strong>dialect:</strong>  the dialect used to parse the input expression.</li>\n<li><strong>copy:</strong>  whether or not to copy <code>expressions</code> (only applies to Expressions).</li>\n<li><strong>**opts:</strong>  other options to use to parse the input expressions.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>And: the new condition</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">expressions</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">dialect</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">copy</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">opts</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Condition</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.or_": {"fullname": "sqlglot.expressions.or_", "modulename": "sqlglot.expressions", "qualname": "or_", "kind": "function", "doc": "<p>Combine multiple conditions with an OR logical operator.</p>\n\n<h6 id=\"example\">Example:</h6>\n\n<blockquote>\n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">or_</span><span class=\"p\">(</span><span class=\"s2\">&quot;x=1&quot;</span><span class=\"p\">,</span> <span class=\"n\">or_</span><span class=\"p\">(</span><span class=\"s2\">&quot;y=1&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;z=1&quot;</span><span class=\"p\">))</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">()</span>\n<span class=\"go\">&#39;x = 1 OR (y = 1 OR z = 1)&#39;</span>\n</code></pre>\n  </div>\n</blockquote>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>*expressions:</strong>  the SQL code strings to parse.\nIf an Expression instance is passed, this is used as-is.</li>\n<li><strong>dialect:</strong>  the dialect used to parse the input expression.</li>\n<li><strong>copy:</strong>  whether or not to copy <code>expressions</code> (only applies to Expressions).</li>\n<li><strong>**opts:</strong>  other options to use to parse the input expressions.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>Or: the new condition</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">expressions</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">dialect</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">copy</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">opts</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Condition</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.not_": {"fullname": "sqlglot.expressions.not_", "modulename": "sqlglot.expressions", "qualname": "not_", "kind": "function", "doc": "<p>Wrap a condition with a NOT operator.</p>\n\n<h6 id=\"example\">Example:</h6>\n\n<blockquote>\n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">not_</span><span class=\"p\">(</span><span class=\"s2\">&quot;this_suit=&#39;black&#39;&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">()</span>\n<span class=\"go\">&quot;NOT this_suit = &#39;black&#39;&quot;</span>\n</code></pre>\n  </div>\n</blockquote>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>expression:</strong>  the SQL code string to parse.\nIf an Expression instance is passed, this is used as-is.</li>\n<li><strong>dialect:</strong>  the dialect used to parse the input expression.</li>\n<li><strong>copy:</strong>  whether to copy the expression or not.</li>\n<li><strong>**opts:</strong>  other options to use to parse the input expressions.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The new condition.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">dialect</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">copy</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">opts</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Not</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.paren": {"fullname": "sqlglot.expressions.paren", "modulename": "sqlglot.expressions", "qualname": "paren", "kind": "function", "doc": "<p>Wrap an expression in parentheses.</p>\n\n<h6 id=\"example\">Example:</h6>\n\n<blockquote>\n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">paren</span><span class=\"p\">(</span><span class=\"s2\">&quot;5 + 3&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">()</span>\n<span class=\"go\">&#39;(5 + 3)&#39;</span>\n</code></pre>\n  </div>\n</blockquote>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>expression:</strong>  the SQL code string to parse.\nIf an Expression instance is passed, this is used as-is.</li>\n<li><strong>copy:</strong>  whether to copy the expression or not.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The wrapped expression.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">copy</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Paren</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.to_identifier": {"fullname": "sqlglot.expressions.to_identifier", "modulename": "sqlglot.expressions", "qualname": "to_identifier", "kind": "function", "doc": "<p>Builds an identifier.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>name:</strong>  The name to turn into an identifier.</li>\n<li><strong>quoted:</strong>  Whether or not force quote the identifier.</li>\n<li><strong>copy:</strong>  Whether or not to copy a passed in Identefier node.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The identifier ast node.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">name</span>, </span><span class=\"param\"><span class=\"n\">quoted</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">copy</span><span class=\"o\">=</span><span class=\"kc\">True</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlglot.expressions.to_interval": {"fullname": "sqlglot.expressions.to_interval", "modulename": "sqlglot.expressions", "qualname": "to_interval", "kind": "function", "doc": "<p>Builds an interval expression from a string like '1 day' or '5 months'.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">interval</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Literal</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Interval</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.to_table": {"fullname": "sqlglot.expressions.to_table", "modulename": "sqlglot.expressions", "qualname": "to_table", "kind": "function", "doc": "<p>Create a table expression from a <code>[catalog].[schema].[table]</code> sql path. Catalog and schema are optional.\nIf a table is passed in then that table is returned.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>sql_path:</strong>  a <code>[catalog].[schema].[table]</code> string.</li>\n<li><strong>dialect:</strong>  the source dialect according to which the table name will be parsed.</li>\n<li><strong>kwargs:</strong>  the kwargs to instantiate the resulting <code>Table</code> expression with.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>A table expression.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">sql_path</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Table</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">dialect</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Table</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.to_column": {"fullname": "sqlglot.expressions.to_column", "modulename": "sqlglot.expressions", "qualname": "to_column", "kind": "function", "doc": "<p>Create a column from a <code>[table].[column]</code> sql path. Schema is optional.</p>\n\n<p>If a column is passed in then that column is returned.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>sql_path:</strong>  <code>[table].[column]</code> string</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>Table: A column expression</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">sql_path</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Column</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Column</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.alias_": {"fullname": "sqlglot.expressions.alias_", "modulename": "sqlglot.expressions", "qualname": "alias_", "kind": "function", "doc": "<p>Create an Alias expression.</p>\n\n<h6 id=\"example\">Example:</h6>\n\n<blockquote>\n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">alias_</span><span class=\"p\">(</span><span class=\"s1\">&#39;foo&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;bar&#39;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">()</span>\n<span class=\"go\">&#39;foo AS bar&#39;</span>\n</code></pre>\n  </div>\n  \n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">alias_</span><span class=\"p\">(</span><span class=\"s1\">&#39;(select 1, 2)&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;bar&#39;</span><span class=\"p\">,</span> <span class=\"n\">table</span><span class=\"o\">=</span><span class=\"p\">[</span><span class=\"s1\">&#39;a&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;b&#39;</span><span class=\"p\">])</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">()</span>\n<span class=\"go\">&#39;(SELECT 1, 2) AS bar(a, b)&#39;</span>\n</code></pre>\n  </div>\n</blockquote>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>expression:</strong>  the SQL code strings to parse.\nIf an Expression instance is passed, this is used as-is.</li>\n<li><strong>alias:</strong>  the alias name to use. If the name has\nspecial characters it is quoted.</li>\n<li><strong>table:</strong>  Whether or not to create a table alias, can also be a list of columns.</li>\n<li><strong>quoted:</strong>  whether or not to quote the alias</li>\n<li><strong>dialect:</strong>  the dialect used to parse the input expression.</li>\n<li><strong>copy:</strong>  Whether or not to copy the expression.</li>\n<li><strong>**opts:</strong>  other options to use to parse the input expressions.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>Alias: the aliased expression</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">alias</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Identifier</span>,</span><span class=\"param\">\t<span class=\"n\">table</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">,</span> <span class=\"n\">Sequence</span><span class=\"p\">[</span><span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Identifier</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">quoted</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">dialect</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">copy</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">opts</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlglot.expressions.subquery": {"fullname": "sqlglot.expressions.subquery", "modulename": "sqlglot.expressions", "qualname": "subquery", "kind": "function", "doc": "<p>Build a subquery expression.</p>\n\n<h6 id=\"example\">Example:</h6>\n\n<blockquote>\n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">subquery</span><span class=\"p\">(</span><span class=\"s1\">&#39;select x from tbl&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;bar&#39;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">select</span><span class=\"p\">(</span><span class=\"s1\">&#39;x&#39;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">()</span>\n<span class=\"go\">&#39;SELECT x FROM (SELECT x FROM tbl) AS bar&#39;</span>\n</code></pre>\n  </div>\n</blockquote>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>expression:</strong>  the SQL code strings to parse.\nIf an Expression instance is passed, this is used as-is.</li>\n<li><strong>alias:</strong>  the alias name to use.</li>\n<li><strong>dialect:</strong>  the dialect used to parse the input expression.</li>\n<li><strong>**opts:</strong>  other options to use to parse the input expressions.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>A new Select instance with the subquery expression included.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">alias</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Identifier</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">dialect</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">opts</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Select</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.column": {"fullname": "sqlglot.expressions.column", "modulename": "sqlglot.expressions", "qualname": "column", "kind": "function", "doc": "<p>Build a Column.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>col:</strong>  Column name.</li>\n<li><strong>table:</strong>  Table name.</li>\n<li><strong>db:</strong>  Database name.</li>\n<li><strong>catalog:</strong>  Catalog name.</li>\n<li><strong>quoted:</strong>  Whether to force quotes on the column's identifiers.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The new Column instance.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">col</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Identifier</span>,</span><span class=\"param\">\t<span class=\"n\">table</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Identifier</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">db</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Identifier</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">catalog</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Identifier</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">quoted</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Column</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.cast": {"fullname": "sqlglot.expressions.cast", "modulename": "sqlglot.expressions", "qualname": "cast", "kind": "function", "doc": "<p>Cast an expression to a data type.</p>\n\n<h6 id=\"example\">Example:</h6>\n\n<blockquote>\n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">cast</span><span class=\"p\">(</span><span class=\"s1\">&#39;x + 1&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;int&#39;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">()</span>\n<span class=\"go\">&#39;CAST(x + 1 AS INT)&#39;</span>\n</code></pre>\n  </div>\n</blockquote>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>expression:</strong>  The expression to cast.</li>\n<li><strong>to:</strong>  The datatype to cast to.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The new Cast instance.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">to</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">DataType</span> <span class=\"o\">|</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">DataType</span><span class=\"o\">.</span><span class=\"n\">Type</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">opts</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Cast</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.table_": {"fullname": "sqlglot.expressions.table_", "modulename": "sqlglot.expressions", "qualname": "table_", "kind": "function", "doc": "<p>Build a Table.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>table:</strong>  Table name.</li>\n<li><strong>db:</strong>  Database name.</li>\n<li><strong>catalog:</strong>  Catalog name.</li>\n<li><strong>quote:</strong>  Whether to force quotes on the table's identifiers.</li>\n<li><strong>alias:</strong>  Table's alias.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The new Table instance.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">table</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Identifier</span> <span class=\"o\">|</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">db</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Identifier</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">catalog</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Identifier</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">quoted</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">bool</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">alias</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Identifier</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Table</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.values": {"fullname": "sqlglot.expressions.values", "modulename": "sqlglot.expressions", "qualname": "values", "kind": "function", "doc": "<p>Build VALUES statement.</p>\n\n<h6 id=\"example\">Example:</h6>\n\n<blockquote>\n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">values</span><span class=\"p\">([(</span><span class=\"mi\">1</span><span class=\"p\">,</span> <span class=\"s1\">&#39;2&#39;</span><span class=\"p\">)])</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">()</span>\n<span class=\"go\">&quot;VALUES (1, &#39;2&#39;)&quot;</span>\n</code></pre>\n  </div>\n</blockquote>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>values:</strong>  values statements that will be converted to SQL</li>\n<li><strong>alias:</strong>  optional alias</li>\n<li><strong>columns:</strong>  Optional list of ordered column names or ordered dictionary of column names to types.\nIf either are provided then an alias is also required.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>Values: the Values expression object</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">values</span><span class=\"p\">:</span> <span class=\"n\">Iterable</span><span class=\"p\">[</span><span class=\"n\">Tuple</span><span class=\"p\">[</span><span class=\"n\">Any</span><span class=\"p\">,</span> <span class=\"o\">...</span><span class=\"p\">]]</span>,</span><span class=\"param\">\t<span class=\"n\">alias</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">columns</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">Iterable</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">],</span> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">DataType</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Values</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.var": {"fullname": "sqlglot.expressions.var", "modulename": "sqlglot.expressions", "qualname": "var", "kind": "function", "doc": "<p>Build a SQL variable.</p>\n\n<h6 id=\"example\">Example:</h6>\n\n<blockquote>\n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"nb\">repr</span><span class=\"p\">(</span><span class=\"n\">var</span><span class=\"p\">(</span><span class=\"s1\">&#39;x&#39;</span><span class=\"p\">))</span>\n<span class=\"go\">&#39;(VAR this: x)&#39;</span>\n</code></pre>\n  </div>\n  \n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"nb\">repr</span><span class=\"p\">(</span><span class=\"n\">var</span><span class=\"p\">(</span><span class=\"n\">column</span><span class=\"p\">(</span><span class=\"s1\">&#39;x&#39;</span><span class=\"p\">,</span> <span class=\"n\">table</span><span class=\"o\">=</span><span class=\"s1\">&#39;y&#39;</span><span class=\"p\">)))</span>\n<span class=\"go\">&#39;(VAR this: x)&#39;</span>\n</code></pre>\n  </div>\n</blockquote>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>name:</strong>  The name of the var or an expression who's name will become the var.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The new variable node.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Var</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.rename_table": {"fullname": "sqlglot.expressions.rename_table", "modulename": "sqlglot.expressions", "qualname": "rename_table", "kind": "function", "doc": "<p>Build ALTER TABLE... RENAME... expression</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>old_name:</strong>  The old name of the table</li>\n<li><strong>new_name:</strong>  The new name of the table</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>Alter table expression</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">old_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Table</span>,</span><span class=\"param\">\t<span class=\"n\">new_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Table</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">AlterTable</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.convert": {"fullname": "sqlglot.expressions.convert", "modulename": "sqlglot.expressions", "qualname": "convert", "kind": "function", "doc": "<p>Convert a python value into an expression object.</p>\n\n<p>Raises an error if a conversion is not possible.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>value:</strong>  A python object.</li>\n<li><strong>copy:</strong>  Whether or not to copy <code>value</code> (only applies to Expressions and collections).</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>Expression: the equivalent expression object.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"n\">Any</span>, </span><span class=\"param\"><span class=\"n\">copy</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.replace_children": {"fullname": "sqlglot.expressions.replace_children", "modulename": "sqlglot.expressions", "qualname": "replace_children", "kind": "function", "doc": "<p>Replace children of an expression with the result of a lambda fun(child) -> exp.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span>,</span><span class=\"param\">\t<span class=\"n\">fun</span><span class=\"p\">:</span> <span class=\"n\">Callable</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">args</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.column_table_names": {"fullname": "sqlglot.expressions.column_table_names", "modulename": "sqlglot.expressions", "qualname": "column_table_names", "kind": "function", "doc": "<p>Return all table names referenced through columns in an expression.</p>\n\n<h6 id=\"example\">Example:</h6>\n\n<blockquote>\n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"kn\">import</span> <span class=\"nn\">sqlglot</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">column_table_names</span><span class=\"p\">(</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">parse_one</span><span class=\"p\">(</span><span class=\"s2\">&quot;a.b AND c.d AND c.e&quot;</span><span class=\"p\">))</span>\n<span class=\"go\">[&#39;c&#39;, &#39;a&#39;]</span>\n</code></pre>\n  </div>\n</blockquote>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>expression:</strong>  expression to find table names.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>A list of unique names.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span></span><span class=\"return-annotation\">) -> <span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.table_name": {"fullname": "sqlglot.expressions.table_name", "modulename": "sqlglot.expressions", "qualname": "table_name", "kind": "function", "doc": "<p>Get the full name of a table as a string.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>table:</strong>  table expression node or string.</li>\n</ul>\n\n<h6 id=\"examples\">Examples:</h6>\n\n<blockquote>\n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"kn\">from</span> <span class=\"nn\">sqlglot</span> <span class=\"kn\">import</span> <span class=\"n\">exp</span><span class=\"p\">,</span> <span class=\"n\">parse_one</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">table_name</span><span class=\"p\">(</span><span class=\"n\">parse_one</span><span class=\"p\">(</span><span class=\"s2\">&quot;select * from a.b.c&quot;</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">find</span><span class=\"p\">(</span><span class=\"n\">exp</span><span class=\"o\">.</span><span class=\"n\">Table</span><span class=\"p\">))</span>\n<span class=\"go\">&#39;a.b.c&#39;</span>\n</code></pre>\n  </div>\n</blockquote>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The table name.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">table</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Table</span> <span class=\"o\">|</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.replace_tables": {"fullname": "sqlglot.expressions.replace_tables", "modulename": "sqlglot.expressions", "qualname": "replace_tables", "kind": "function", "doc": "<p>Replace all tables in expression according to the mapping.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>expression:</strong>  expression node to be transformed and replaced.</li>\n<li><strong>mapping:</strong>  mapping of table names.</li>\n</ul>\n\n<h6 id=\"examples\">Examples:</h6>\n\n<blockquote>\n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"kn\">from</span> <span class=\"nn\">sqlglot</span> <span class=\"kn\">import</span> <span class=\"n\">exp</span><span class=\"p\">,</span> <span class=\"n\">parse_one</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">replace_tables</span><span class=\"p\">(</span><span class=\"n\">parse_one</span><span class=\"p\">(</span><span class=\"s2\">&quot;select * from a.b&quot;</span><span class=\"p\">),</span> <span class=\"p\">{</span><span class=\"s2\">&quot;a.b&quot;</span><span class=\"p\">:</span> <span class=\"s2\">&quot;c&quot;</span><span class=\"p\">})</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">()</span>\n<span class=\"go\">&#39;SELECT * FROM c&#39;</span>\n</code></pre>\n  </div>\n</blockquote>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The mapped expression.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"o\">~</span><span class=\"n\">E</span>, </span><span class=\"param\"><span class=\"n\">mapping</span><span class=\"p\">:</span> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"o\">~</span><span class=\"n\">E</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.replace_placeholders": {"fullname": "sqlglot.expressions.replace_placeholders", "modulename": "sqlglot.expressions", "qualname": "replace_placeholders", "kind": "function", "doc": "<p>Replace placeholders in an expression.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>expression:</strong>  expression node to be transformed and replaced.</li>\n<li><strong>args:</strong>  positional names that will substitute unnamed placeholders in the given order.</li>\n<li><strong>kwargs:</strong>  keyword arguments that will substitute named placeholders.</li>\n</ul>\n\n<h6 id=\"examples\">Examples:</h6>\n\n<blockquote>\n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"kn\">from</span> <span class=\"nn\">sqlglot</span> <span class=\"kn\">import</span> <span class=\"n\">exp</span><span class=\"p\">,</span> <span class=\"n\">parse_one</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">replace_placeholders</span><span class=\"p\">(</span>\n<span class=\"gp\">... </span>    <span class=\"n\">parse_one</span><span class=\"p\">(</span><span class=\"s2\">&quot;select * from :tbl where ? = ?&quot;</span><span class=\"p\">),</span>\n<span class=\"gp\">... </span>    <span class=\"n\">exp</span><span class=\"o\">.</span><span class=\"n\">to_identifier</span><span class=\"p\">(</span><span class=\"s2\">&quot;str_col&quot;</span><span class=\"p\">),</span> <span class=\"s2\">&quot;b&quot;</span><span class=\"p\">,</span> <span class=\"n\">tbl</span><span class=\"o\">=</span><span class=\"n\">exp</span><span class=\"o\">.</span><span class=\"n\">to_identifier</span><span class=\"p\">(</span><span class=\"s2\">&quot;foo&quot;</span><span class=\"p\">)</span>\n<span class=\"gp\">... </span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">()</span>\n<span class=\"go\">&quot;SELECT * FROM foo WHERE str_col = &#39;b&#39;&quot;</span>\n</code></pre>\n  </div>\n</blockquote>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The mapped expression.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">args</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.expand": {"fullname": "sqlglot.expressions.expand", "modulename": "sqlglot.expressions", "qualname": "expand", "kind": "function", "doc": "<p>Transforms an expression by expanding all referenced sources into subqueries.</p>\n\n<h6 id=\"examples\">Examples:</h6>\n\n<blockquote>\n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"kn\">from</span> <span class=\"nn\">sqlglot</span> <span class=\"kn\">import</span> <span class=\"n\">parse_one</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">expand</span><span class=\"p\">(</span><span class=\"n\">parse_one</span><span class=\"p\">(</span><span class=\"s2\">&quot;select * from x AS z&quot;</span><span class=\"p\">),</span> <span class=\"p\">{</span><span class=\"s2\">&quot;x&quot;</span><span class=\"p\">:</span> <span class=\"n\">parse_one</span><span class=\"p\">(</span><span class=\"s2\">&quot;select * from y&quot;</span><span class=\"p\">)})</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">()</span>\n<span class=\"go\">&#39;SELECT * FROM (SELECT * FROM y) AS z /* source: x */&#39;</span>\n</code></pre>\n  </div>\n  \n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">expand</span><span class=\"p\">(</span><span class=\"n\">parse_one</span><span class=\"p\">(</span><span class=\"s2\">&quot;select * from x AS z&quot;</span><span class=\"p\">),</span> <span class=\"p\">{</span><span class=\"s2\">&quot;x&quot;</span><span class=\"p\">:</span> <span class=\"n\">parse_one</span><span class=\"p\">(</span><span class=\"s2\">&quot;select * from y&quot;</span><span class=\"p\">),</span> <span class=\"s2\">&quot;y&quot;</span><span class=\"p\">:</span> <span class=\"n\">parse_one</span><span class=\"p\">(</span><span class=\"s2\">&quot;select * from z&quot;</span><span class=\"p\">)})</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">()</span>\n<span class=\"go\">&#39;SELECT * FROM (SELECT * FROM (SELECT * FROM z) AS y /* source: y */) AS z /* source: x */&#39;</span>\n</code></pre>\n  </div>\n</blockquote>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>expression:</strong>  The expression to expand.</li>\n<li><strong>sources:</strong>  A dictionary of name to Subqueryables.</li>\n<li><strong>copy:</strong>  Whether or not to copy the expression during transformation. Defaults to True.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>The transformed expression.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span>,</span><span class=\"param\">\t<span class=\"n\">sources</span><span class=\"p\">:</span> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Subqueryable</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">copy</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.func": {"fullname": "sqlglot.expressions.func", "modulename": "sqlglot.expressions", "qualname": "func", "kind": "function", "doc": "<p>Returns a Func expression.</p>\n\n<h6 id=\"examples\">Examples:</h6>\n\n<blockquote>\n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">func</span><span class=\"p\">(</span><span class=\"s2\">&quot;abs&quot;</span><span class=\"p\">,</span> <span class=\"mi\">5</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">()</span>\n<span class=\"go\">&#39;ABS(5)&#39;</span>\n</code></pre>\n  </div>\n  \n  <div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">func</span><span class=\"p\">(</span><span class=\"s2\">&quot;cast&quot;</span><span class=\"p\">,</span> <span class=\"n\">this</span><span class=\"o\">=</span><span class=\"mi\">5</span><span class=\"p\">,</span> <span class=\"n\">to</span><span class=\"o\">=</span><span class=\"n\">DataType</span><span class=\"o\">.</span><span class=\"n\">build</span><span class=\"p\">(</span><span class=\"s2\">&quot;DOUBLE&quot;</span><span class=\"p\">))</span><span class=\"o\">.</span><span class=\"n\">sql</span><span class=\"p\">()</span>\n<span class=\"go\">&#39;CAST(5 AS DOUBLE)&#39;</span>\n</code></pre>\n  </div>\n</blockquote>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>name:</strong>  the name of the function to build.</li>\n<li><strong>args:</strong>  the args used to instantiate the function of interest.</li>\n<li><strong>dialect:</strong>  the source dialect.</li>\n<li><strong>kwargs:</strong>  the kwargs used to instantiate the function of interest.</li>\n</ul>\n\n<h6 id=\"note\">Note:</h6>\n\n<blockquote>\n  <p>The arguments <code>args</code> and <code>kwargs</code> are mutually exclusive.</p>\n</blockquote>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>An instance of the function of interest, or an anonymous function, if <code>name</code> doesn't\n  correspond to an existing <code>sqlglot.expressions.Func</code> class.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">args</span>,</span><span class=\"param\">\t<span class=\"n\">dialect</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">,</span> <span class=\"n\">Type</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">dialects</span><span class=\"o\">.</span><span class=\"n\">dialect</span><span class=\"o\">.</span><span class=\"n\">Dialect</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Func</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.true": {"fullname": "sqlglot.expressions.true", "modulename": "sqlglot.expressions", "qualname": "true", "kind": "function", "doc": "<p>Returns a true Boolean expression.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Boolean</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.false": {"fullname": "sqlglot.expressions.false", "modulename": "sqlglot.expressions", "qualname": "false", "kind": "function", "doc": "<p>Returns a false Boolean expression.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Boolean</span>:</span></span>", "funcdef": "def"}, "sqlglot.expressions.null": {"fullname": "sqlglot.expressions.null", "modulename": "sqlglot.expressions", "qualname": "null", "kind": "function", "doc": "<p>Returns a Null expression.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">) -> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Null</span>:</span></span>", "funcdef": "def"}, "sqlglot.generator": {"fullname": "sqlglot.generator", "modulename": "sqlglot.generator", "kind": "module", "doc": "<p></p>\n"}, "sqlglot.generator.Generator": {"fullname": "sqlglot.generator.Generator", "modulename": "sqlglot.generator", "qualname": "Generator", "kind": "class", "doc": "<p>Generator interprets the given syntax tree and produces a SQL string as an output.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>time_mapping (dict):</strong>  the dictionary of custom time mappings in which the key\nrepresents a python time format and the output the target time format</li>\n<li><strong>time_trie (trie):</strong>  a trie of the time_mapping keys</li>\n<li><strong>pretty (bool):</strong>  if set to True the returned string will be formatted. Default: False.</li>\n<li><strong>quote_start (str):</strong>  specifies which starting character to use to delimit quotes. Default: '.</li>\n<li><strong>quote_end (str):</strong>  specifies which ending character to use to delimit quotes. Default: '.</li>\n<li><strong>identifier_start (str):</strong>  specifies which starting character to use to delimit identifiers. Default: \".</li>\n<li><strong>identifier_end (str):</strong>  specifies which ending character to use to delimit identifiers. Default: \".</li>\n<li><strong>bit_start (str):</strong>  specifies which starting character to use to delimit bit literals. Default: None.</li>\n<li><strong>bit_end (str):</strong>  specifies which ending character to use to delimit bit literals. Default: None.</li>\n<li><strong>hex_start (str):</strong>  specifies which starting character to use to delimit hex literals. Default: None.</li>\n<li><strong>hex_end (str):</strong>  specifies which ending character to use to delimit hex literals. Default: None.</li>\n<li><strong>byte_start (str):</strong>  specifies which starting character to use to delimit byte literals. Default: None.</li>\n<li><strong>byte_end (str):</strong>  specifies which ending character to use to delimit byte literals. Default: None.</li>\n<li><strong>raw_start (str):</strong>  specifies which starting character to use to delimit raw literals. Default: None.</li>\n<li><strong>raw_end (str):</strong>  specifies which ending character to use to delimit raw literals. Default: None.</li>\n<li><strong>identify (bool | str):</strong>  'always': always quote, 'safe': quote identifiers if they don't contain an upcase, True defaults to always.</li>\n<li><strong>normalize (bool):</strong>  if set to True all identifiers will lower cased</li>\n<li><strong>string_escape (str):</strong>  specifies a string escape character. Default: '.</li>\n<li><strong>identifier_escape (str):</strong>  specifies an identifier escape character. Default: \".</li>\n<li><strong>pad (int):</strong>  determines padding in a formatted string. Default: 2.</li>\n<li><strong>indent (int):</strong>  determines the size of indentation in a formatted string. Default: 4.</li>\n<li><strong>unnest_column_only (bool):</strong>  if true unnest table aliases are considered only as column aliases</li>\n<li><strong>normalize_functions (str):</strong>  normalize function names, \"upper\", \"lower\", or None\nDefault: \"upper\"</li>\n<li><strong>alias_post_tablesample (bool):</strong>  if the table alias comes after tablesample\nDefault: False</li>\n<li><strong>identifiers_can_start_with_digit (bool):</strong>  if an unquoted identifier can start with digit\nDefault: False</li>\n<li><strong>unsupported_level (ErrorLevel):</strong>  determines the generator's behavior when it encounters\nunsupported expressions. Default ErrorLevel.WARN.</li>\n<li><strong>null_ordering (str):</strong>  Indicates the default null ordering method to use if not explicitly set.\nOptions are \"nulls_are_small\", \"nulls_are_large\", \"nulls_are_last\".\nDefault: \"nulls_are_small\"</li>\n<li><strong>max_unsupported (int):</strong>  Maximum number of unsupported messages to include in a raised UnsupportedError.\nThis is only relevant if unsupported_level is ErrorLevel.RAISE.\nDefault: 3</li>\n<li><strong>leading_comma (bool):</strong>  if the the comma is leading or trailing in select statements\nDefault: False</li>\n<li><strong>max_text_width:</strong>  The max number of characters in a segment before creating new lines in pretty mode.\nThe default is on the smaller end because the length only represents a segment and not the true\nline length.\nDefault: 80</li>\n<li><strong>comments:</strong>  Whether or not to preserve comments in the output SQL code.\nDefault: True</li>\n</ul>\n"}, "sqlglot.generator.Generator.__init__": {"fullname": "sqlglot.generator.Generator.__init__", "modulename": "sqlglot.generator", "qualname": "Generator.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">time_mapping</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">time_trie</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">pretty</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">quote_start</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">quote_end</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">identifier_start</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">identifier_end</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">bit_start</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">bit_end</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">hex_start</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">hex_end</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">byte_start</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">byte_end</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">raw_start</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">raw_end</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">identify</span><span class=\"o\">=</span><span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">normalize</span><span class=\"o\">=</span><span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">string_escape</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">identifier_escape</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">pad</span><span class=\"o\">=</span><span class=\"mi\">2</span>,</span><span class=\"param\">\t<span class=\"n\">indent</span><span class=\"o\">=</span><span class=\"mi\">2</span>,</span><span class=\"param\">\t<span class=\"n\">index_offset</span><span class=\"o\">=</span><span class=\"mi\">0</span>,</span><span class=\"param\">\t<span class=\"n\">unnest_column_only</span><span class=\"o\">=</span><span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">alias_post_tablesample</span><span class=\"o\">=</span><span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">identifiers_can_start_with_digit</span><span class=\"o\">=</span><span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">normalize_functions</span><span class=\"o\">=</span><span class=\"s1\">&#39;upper&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">unsupported_level</span><span class=\"o\">=&lt;</span><span class=\"n\">ErrorLevel</span><span class=\"o\">.</span><span class=\"n\">WARN</span><span class=\"p\">:</span> <span class=\"s1\">&#39;WARN&#39;</span><span class=\"o\">&gt;</span>,</span><span class=\"param\">\t<span class=\"n\">null_ordering</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">max_unsupported</span><span class=\"o\">=</span><span class=\"mi\">3</span>,</span><span class=\"param\">\t<span class=\"n\">leading_comma</span><span class=\"o\">=</span><span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">max_text_width</span><span class=\"o\">=</span><span class=\"mi\">80</span>,</span><span class=\"param\">\t<span class=\"n\">comments</span><span class=\"o\">=</span><span class=\"kc\">True</span></span>)</span>"}, "sqlglot.generator.Generator.generate": {"fullname": "sqlglot.generator.Generator.generate", "modulename": "sqlglot.generator", "qualname": "Generator.generate", "kind": "function", "doc": "<p>Generates a SQL string by interpreting the given syntax tree.</p>\n\n<p>Args\n    expression: the syntax tree.\n    cache: an optional sql string cache. this leverages the hash of an expression which is slow, so only use this if you set _hash on each node.</p>\n\n<p>Returns\n    the SQL string.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">cache</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.generator.Generator.unsupported": {"fullname": "sqlglot.generator.Generator.unsupported", "modulename": "sqlglot.generator", "qualname": "Generator.unsupported", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">message</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "sqlglot.generator.Generator.sep": {"fullname": "sqlglot.generator.Generator.sep", "modulename": "sqlglot.generator", "qualname": "Generator.sep", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">sep</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39; &#39;</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.generator.Generator.seg": {"fullname": "sqlglot.generator.Generator.seg", "modulename": "sqlglot.generator", "qualname": "Generator.seg", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">sql</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">sep</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39; &#39;</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.generator.Generator.pad_comment": {"fullname": "sqlglot.generator.Generator.pad_comment", "modulename": "sqlglot.generator", "qualname": "Generator.pad_comment", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">comment</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.generator.Generator.maybe_comment": {"fullname": "sqlglot.generator.Generator.maybe_comment", "modulename": "sqlglot.generator", "qualname": "Generator.maybe_comment", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">sql</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">comments</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">List</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.generator.Generator.wrap": {"fullname": "sqlglot.generator.Generator.wrap", "modulename": "sqlglot.generator", "qualname": "Generator.wrap", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span> <span class=\"o\">|</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.generator.Generator.no_identify": {"fullname": "sqlglot.generator.Generator.no_identify", "modulename": "sqlglot.generator", "qualname": "Generator.no_identify", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">func</span><span class=\"p\">:</span> <span class=\"n\">Callable</span><span class=\"p\">[</span><span class=\"o\">...</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"o\">*</span><span class=\"n\">args</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.generator.Generator.normalize_func": {"fullname": "sqlglot.generator.Generator.normalize_func", "modulename": "sqlglot.generator", "qualname": "Generator.normalize_func", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.generator.Generator.indent": {"fullname": "sqlglot.generator.Generator.indent", "modulename": "sqlglot.generator", "qualname": "Generator.indent", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">sql</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>,</span><span class=\"param\">\t<span class=\"n\">pad</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">skip_first</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">skip_last</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.generator.Generator.sql": {"fullname": "sqlglot.generator.Generator.sql", "modulename": "sqlglot.generator", "qualname": "Generator.sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Expression</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">key</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">comment</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.generator.Generator.uncache_sql": {"fullname": "sqlglot.generator.Generator.uncache_sql", "modulename": "sqlglot.generator", "qualname": "Generator.uncache_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Uncache</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.generator.Generator.cache_sql": {"fullname": "sqlglot.generator.Generator.cache_sql", "modulename": "sqlglot.generator", "qualname": "Generator.cache_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Cache</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.generator.Generator.characterset_sql": {"fullname": "sqlglot.generator.Generator.characterset_sql", "modulename": "sqlglot.generator", "qualname": "Generator.characterset_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">CharacterSet</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.generator.Generator.column_sql": {"fullname": "sqlglot.generator.Generator.column_sql", "modulename": "sqlglot.generator", "qualname": "Generator.column_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">expression</span><span class=\"p\">:</span> <span class=\"n\">sqlglot</span><span class=\"o\">.</span><span class=\"n\">expressions</span><span class=\"o\">.</span><span class=\"n\">Column</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlglot.generator.Generator.columnposition_sql": {"fullname": "sqlglot.generator.Generator.columnposition_sql", "modulename": "sqlglot.generator", "qualname": "Generator.columnposition_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span