/* This file is part of the Springlobby (GPL v2 or later), see COPYING */

/**
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

DO NOT CHANGE THIS FILE!

this file is deprecated and will be replaced with

lsl/networking/tasserver.cpp

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
**/



#include <wx/string.h>
#include <wx/regex.h>
#include <wx/intl.h>
#include <wx/protocol/http.h>
#include <wx/socket.h>
#include <wx/log.h>
#include <wx/tokenzr.h>
#include <wx/platinfo.h>
#include <wx/stopwatch.h>
#include <wx/timer.h>

#include <stdexcept>
#include <algorithm>
#include <map>

#include <lslunitsync/unitsync.h>

#include "utils/base64.h"
#include "utils/md5.h"
#include "tasserver.h"
#include "utils/tasutil.h"
#include "utils/conversion.h"
#include "utils/platform.h"
#include "serverevents.h"
#include "socket.h"
#include "log.h"
#include "utils/slconfig.h"
#include "utils/version.h"
#include "settings.h"


SLCONFIG("/Server/ExitMessage", "Using http://springlobby.info/", "Message which is send when leaving server");
SLCONFIG("/General/CpuID", 0L, "CPUId to be used when logging int to lobbyserver");

// times in milliseconds
#define PING_TIME 30000
#define PING_TIMEOUT 90000
#define PING_DELAY 5000 //first ping is sent after PING_DELAY
#define UDP_KEEP_ALIVE 15000
#define UDP_REPLY_TIMEOUT 10000


struct TASColor {
unsigned int red :
	8;
unsigned int green :
	8;
unsigned int blue :
	8;
unsigned int zero:
	8;
};


union UTASColor {
	int data;
	TASColor color;
	UTASColor(): data(0) {}
};


/*

myteamcolor:  Should be 32-bit signed integer in decimal form (e.g. 255 and not FF) where each color channel should occupy 1 byte (e.g. in hexdecimal: $00BBGGRR, B = blue, G = green, R = red). Example: 255 stands for $000000FF.

*/
int ConvUserStatus(const UserStatus& us);
UserStatus ConvTasclientstatus( const int );

UserBattleStatus ConvTasbattlestatus( const int );
int ConvTasbattlestatus( const UserBattleStatus );

IBattle::StartType IntToStartType( int start );
NatType IntToNatType( int nat );
IBattle::GameType IntToGameType( int gt );


TASServer::TASServer():
	m_ser_ver(0),
	m_connected(false),
	m_online(false),
	m_debug_dont_catch( false ),
	m_id_transmission( true ),
	m_redirecting( false ),
	m_buffer(wxEmptyString),
	m_last_udp_ping(0),
	m_last_ping(PING_DELAY), //no instant ping, delay first ping for PING_DELAY seconds
	m_last_net_packet(0),
	m_lastnotify(wxGetLocalTimeMillis()),
	m_last_id(0),
	m_udp_private_port(0),
	m_nat_helper_port(0),
	m_battle_id(-1),
	m_server_lanmode(false),
	m_account_id_count(0),
	m_do_finalize_join_battle(false),
	m_finalize_join_battle_id(-1)
{
	m_se = new ServerEvents(*this);
	m_relay_host_manager_list.Clear();

	Start(100); // call Update every 100ms
}

TASServer::~TASServer()
{
	Stop();
	Disconnect();
	delete m_se;
	m_se = NULL;
}

bool TASServer::ExecuteSayCommand( const wxString& cmd )
{
	wxArrayString arrayparams = wxStringTokenize( cmd, _T(" ") );
	if ( arrayparams.GetCount() == 0 ) return false;
	wxString subcmd = arrayparams[0];
	wxString params = cmd.AfterFirst( ' ' );
	if ( subcmd == _T("/ingame") ) {
		if ( arrayparams.GetCount() != 2 ) return false;
		SendCmd( _T("GETINGAMETIME"), arrayparams[1] );
		return true;
	} else if ( subcmd == _T("/kick") ) {
		if ( arrayparams.GetCount() < 2 ) return false;
		SendCmd( _T("KICKUSER"), params );
		return true;
	} else if ( subcmd == _T("/ban") ) {
		if ( arrayparams.GetCount() < 2 ) return false;
		SendCmd( _T("BAN"), params );
		return true;
	} else if ( subcmd == _T("/unban") ) {
		if ( arrayparams.GetCount() != 2 ) return false;
		SendCmd( _T("UNBAN"), arrayparams[1] );
		return true;
	} else if ( subcmd == _T("/banlist") ) {
		SendCmd( _T("BANLIST") );
		return true;
	} else if ( subcmd == _T("/topic") ) {
		params.Replace( _T("\n"), _T("\\n") );
		SendCmd( _T("CHANNELTOPIC"), params );
		return true;
	} else if ( subcmd == _T("/chanmsg") ) {
		if ( arrayparams.GetCount() < 2 ) return false;
		SendCmd( _T("CHANNELMESSAGE"), params );
		return true;
	} else if ( subcmd == _T("/ring") ) {
		if ( arrayparams.GetCount() != 2 ) return false;
		SendCmd( _T("RING"), arrayparams[1] );
		return true;
	} else if ( subcmd == _T("/ip") ) {
		if ( arrayparams.GetCount() != 2 ) return false;
		SendCmd( _T("GETIP"), arrayparams[1] );
		return true;
	} else if ( subcmd == _T("/mute") ) {
		if ( arrayparams.GetCount() < 4 ) return false;
		if ( arrayparams.GetCount() > 5 ) return false;
		SendCmd( _T("MUTE"), params );
		return true;
	} else if ( subcmd == _T("/unmute") ) {
		if ( arrayparams.GetCount() != 3 ) return false;
		SendCmd( _T("UNMUTE"), arrayparams[1] + _T(" ") + arrayparams[2] );
		return true;
	} else if ( subcmd == _T("/mutelist") ) {
		if ( arrayparams.GetCount() != 2 ) return false;
		SendCmd( _T("MUTELIST"), arrayparams[1] );
		return true;
	} else if ( subcmd == _T("/lastlogin") ) {
		if ( arrayparams.GetCount() != 2 ) return false;
		SendCmd( _T("GETLASTLOGINTIME"), arrayparams[1] );
		return true;
	} else if ( subcmd == _T("/findip") ) {
		if ( arrayparams.GetCount() != 2 ) return false;
		SendCmd( _T("FINDIP"), arrayparams[1] );
		return true;
	} else if ( subcmd == _T("/lastip") ) {
		if ( arrayparams.GetCount() != 2 ) return false;
		SendCmd( _T("GETLASTIP"), arrayparams[1] );
		return true;
	} else if ( subcmd == _T("/rename") ) {
		if ( arrayparams.GetCount() != 2 ) return false;
		SendCmd( _T("RENAMEACCOUNT"), arrayparams[1] );
		sett().SetServerAccountNick( sett().GetDefaultServer(), arrayparams[1] ); // this code assumes that default server hasn't changed since login ( like it should atm )
		return true;
	} else if ( subcmd == _T("/testmd5") ) {
		ExecuteCommand( _T("SERVERMSG"), GetPasswordHash(params) );
		return true;
	} else if ( subcmd == _T("/hook") ) {
		SendCmd( _T("HOOK"), params );
		return true;
	} else if ( subcmd == _T("/quit") ) {
		Disconnect();
		return true;
	} else if ( subcmd == _T("/changepassword2") ) {
		if ( arrayparams.GetCount() < 2 ) {
			m_se->OnServerMessage("Missing parameter, usage: /changepassword2 newpassword");
			return true;
		}
		wxString oldpassword = sett().GetServerAccountPass( GetServerName() );
		wxString newpassword = GetPasswordHash( params );
		if  ( oldpassword.IsEmpty() || !sett().GetServerAccountSavePass(GetServerName()) ) {
			m_se->OnServerMessage("There is no saved password for this account, please use /changepassword oldpassword newpassword");
			return true;
		}
		SendCmd( _T("CHANGEPASSWORD"), oldpassword + _T(" ") + newpassword );
		return true;
	} else if ( subcmd == _T("/changepassword") ) {
		if ( arrayparams.GetCount() != 3 ) {
			m_se->OnServerMessage("Invalid parameter count, usage: /changepassword oldpassword newpassword");
			return true;
		}
		wxString oldpassword = GetPasswordHash(arrayparams[1]);
		wxString newpassword = GetPasswordHash(arrayparams[2]);
		SendCmd( _T("CHANGEPASSWORD"), oldpassword + _T(" ") + newpassword );
		return true;
	} else if ( subcmd == _T("/ping") ) {
		Ping();
		return true;
	}
	return false;
}


void TASServer::Connect( const wxString& servername ,const wxString& addr, const int port )
{
	m_server_name = servername;
	m_addr = addr;
	m_buffer = wxEmptyString;
	m_sock->Connect( addr, port );
	m_sock->SetSendRateLimit( 800 ); // 1250 is the server limit but 800 just to make sure :)
	m_connected = false;
	m_online = false;
	m_redirecting = false;
	m_agreement.clear();
	m_crc.ResetCRC();
	m_last_net_packet = 0;
	m_lastnotify = wxGetLocalTimeMillis();
	const std::string handle = m_sock->GetHandle();
	if ( !handle.empty() ) {
		m_crc.UpdateData(handle);
	}
}

void TASServer::Disconnect()
{
	if (!m_connected) {
		return;
	}
	m_connected = false;
	SendCmd( _T("EXIT ") + cfg().ReadString(_T("/Server/ExitMessage")) ); // EXIT command for new protocol compatibility
	m_sock->Disconnect();
}

bool TASServer::IsConnected()
{
	return (m_sock->State() == SS_Open) && (m_connected);
}


void TASServer::Register(const wxString& servername, const wxString& host, const int port,const wxString& nick, const wxString& password)
{
	SetUsername(nick);
	SetPassword(password);
	Connect(servername, host, port);
	SendCmd(_T("REGISTER"), nick + _T(" ") + GetPasswordHash( password ) );
}


bool TASServer::IsPasswordHash( const wxString& pass ) const
{
	return pass.length() == 24 && pass[22] == '=' && pass[23] == '=';
}


wxString TASServer::GetPasswordHash( const wxString& pass ) const
{
	if ( IsPasswordHash(pass) ) return pass;

	md5_state_t state;
	md5_byte_t digest[16];
	char hex_output[16*2 + 1];
	int di;

	std::string str = STD_STRING(pass);
	char* cstr = new char [str.size()+1];
	strcpy (cstr, str.c_str());

	md5_init(&state);
	md5_append(&state, (const md5_byte_t *) cstr, strlen( cstr ));
	md5_finish(&state, digest);
	for (di = 0; di < 16; ++di)
		sprintf(hex_output + di * 2, "%02x", digest[di]);
	delete [] cstr;
	const std::string base64pass = base64_encode( digest, 16 );
	return TowxString(base64pass);
}


User& TASServer::GetMe()
{
	return GetUser( GetUserName() );
}
const User& TASServer::GetMe() const
{
	return GetUser( GetUserName() );
}

void TASServer::Login()
{
	slLogDebugFunc("");
	const wxString pass = GetPasswordHash( GetPassword() );
	const wxString protocol = TowxString( m_crc.GetCRC() );
	wxString localaddr = m_sock->GetLocalAddress();
	if ( localaddr.IsEmpty() ) localaddr = _T("*");
	m_id_transmission = false;
	wxFormat login_cmd( _T("%s %s %d %s %s\t%s\ta m sp cl p") );
	const int cpuid = cfg().ReadLong(_T("/General/CpuID"));
	SendCmd ( _T("LOGIN"), (login_cmd % GetUserName() % pass % cpuid % localaddr % TowxString(getSpringlobbyAgent()) % protocol).str() );
	m_id_transmission = true;
}

void TASServer::Logout()
{
	slLogDebugFunc("");
	Disconnect();
}

bool TASServer::IsOnline() const
{
	if ( !m_connected ) return false;
	return m_online;
}


void TASServer::RequestChannels()
{
	SendCmd( _T("CHANNELS") );
}


void TASServer::AcceptAgreement()
{
	SendCmd( _T("CONFIRMAGREEMENT") );
}


void TASServer::Notify()
{
	if (m_sock == NULL) return;
	const wxLongLong now = wxGetLocalTimeMillis();
	const long diff = std::abs((now - m_lastnotify).ToLong());
	const int interval = std::max<long>(GetInterval(), diff);
	m_lastnotify = now;

	m_sock->OnTimer(interval);
	m_last_ping += interval;
	m_last_net_packet += interval;
	m_last_udp_ping += interval;

	if ( !m_connected ) { // We are not formally connected yet, but might be.
		if ( IsConnected() ) {
			m_connected = true;
		}
		return;
	}
	if ( !IsConnected() ) return;


	if (m_last_ping > PING_TIME) { //Send a PING every 30 seconds
		if (interval > PING_TIME) {
			m_last_net_packet = 0; //assume local clock is broken and we received a packed within time
			m_se->OnServerMessage(wxFormat(_("Springlobby hung or stale clock. Got no timer for %d msec")) % interval );
		}
		m_last_ping = 0;
		Ping();
		return;
	}

	if ( m_last_net_packet > PING_TIMEOUT ) {
		m_se->OnServerMessage(wxFormat(_("Timeout assumed, disconnecting. Received no data from server for %d seconds. Last ping send %d seconds ago.")) % (m_last_net_packet / 1000) % (m_last_ping / 1000) );
		m_last_net_packet = 0;
		Disconnect();
		return;
	}

	// joining battle with nat traversal:
	// if we havent finalized joining yet, and udp_reply_timeout seconds has passed since
	// we did UdpPing(our name) , join battle anyway, but with warning message that nat failed.
	// (if we'd receive reply from server, we'd finalize already)
	//
	if (m_do_finalize_join_battle&&(m_last_udp_ping > UDP_REPLY_TIMEOUT)) {
		m_se->OnServerMessage("Failed to punch through NAT, playing this battle might not work for you or for other players.");
		//wxMessageBox()
		FinalizeJoinBattle();
		//wxMessageBox(_("Failed to punch through NAT"), _("Error"), wxICON_INFORMATION, NULL/* m_ui.mw()*/ );
	}

	if ( ( m_last_udp_ping > UDP_KEEP_ALIVE )  ) {
		// Is it time for a nat traversal PING?
		m_last_udp_ping = 0;
		// Nat travelsal "ping"
		if ( m_battle_id != -1 ) {
			IBattle *battle=GetCurrentBattle();
			if ((battle) &&
				( battle->GetNatType() == NAT_Hole_punching || ( battle->GetNatType() == NAT_Fixed_source_ports ) ) && !battle->GetInGame() ) {
				UdpPingTheServer(GetUserName());
				if ( battle->IsFounderMe() ) {
					UdpPingAllClients();
				}
			}
		}
	}
}


void TASServer::ExecuteCommand( const wxString& in )
{
	wxLogMessage( _T("%s"), in.c_str()  );
	wxString cmd;
	wxString params = in;
	long replyid = 0;

	if ( in.empty() ) return;
	try {
		ASSERT_LOGIC( params.AfterFirst( '\n' ).IsEmpty(), _T("losing data") );
	} catch (...) {
		return;
	}
	if ( params[0] == '#' ) {
		wxString id = params.BeforeFirst( ' ' ).AfterFirst( '#' );
		params = params.AfterFirst( ' ' );
		id.ToLong( &replyid );
	}
	cmd = params.BeforeFirst( ' ' ).MakeUpper();
	params = params.AfterFirst( ' ' );

	if ( m_debug_dont_catch ) {
		ExecuteCommand( cmd, params, replyid );
	} else {
		try {
			ExecuteCommand( cmd, params, replyid );
		} catch ( ... ) { // catch everything so the app doesn't crash, may makes odd beahviours but it's better than crashing randomly for normal users
		}
	}
}


void TASServer::ExecuteCommand( const wxString& cmd, const wxString& inparams, int replyid )
{
	wxString params = inparams;
	bool haspass,lanmode = false;
	std::string nick, contry, host, map, title, channel, error, msg, owner, topic, engineName, engineVersion;
	//NatType ntype;
	UserStatus cstatus;
	int tasstatus;
	int tasbstatus;
	UserBattleStatus bstatus;

	if ( cmd == _T("TASSERVER")) {
		m_ser_ver = GetIntParam(params);
		const std::string supported_spring_version = GetWordParam( params );
		m_nat_helper_port = (unsigned long)GetIntParam( params );
		lanmode = GetBoolParam( params );
		m_server_lanmode = lanmode;
		m_se->OnConnected( STD_STRING(m_server_name), "", (m_ser_ver > 0), supported_spring_version, lanmode );
	} else if ( cmd == _T("ACCEPTED") ) {
		if ( m_online ) return; // in case is the server sends WTF
		m_online = true;
		SetUsername(params);
		m_se->OnLogin( );
	} else if ( cmd == _T("MOTD") ) {
		m_se->OnMotd( STD_STRING(params));
	} else if ( cmd == _T("ADDUSER") ) {
		int id;
		nick = GetWordParam( params );
		contry = GetWordParam( params );
		const int cpu = GetIntParam( params );
		if ( params.IsEmpty() ) {
			// if server didn't send any account id to us, fill with an always increasing number
			id = m_account_id_count;
			m_account_id_count++;
		} else {
			id = GetIntParam( params );
		}
		m_se->OnNewUser( nick, contry, cpu, id);
		if ( nick == m_relay_host_bot ) {
			RelayCmd( _T("OPENBATTLE"), m_delayed_open_command ); // relay bot is deployed, send host command
			m_delayed_open_command = wxEmptyString;
		}
	} else if ( cmd == _T("CLIENTSTATUS") ) {
		nick = GetWordParam( params );
		tasstatus = GetIntParam( params );
		cstatus = ConvTasclientstatus( tasstatus );
		m_se->OnUserStatus( nick, cstatus );
	} else if ( cmd == _T("BATTLEOPENED") ) {
		const int id = GetIntParam( params );
		const int type = GetIntParam( params );
		const int nat = GetIntParam( params );
		nick = GetWordParam( params );
		host = GetWordParam( params );
		const int port = GetIntParam( params );
		const int maxplayers = GetIntParam( params );
		haspass = GetBoolParam( params );
		const int rank = GetIntParam( params );
		const std::string hash = LSL::Util::MakeHashUnsigned( GetWordParam( params ) );
		engineName = GetSentenceParam( params );
		engineVersion = GetSentenceParam( params );
		map = GetSentenceParam( params );
		title = GetSentenceParam( params );
		const std::string mod = GetSentenceParam( params );
		m_se->OnBattleOpened( id, (BattleType)type, IntToNatType( nat ), nick, host, port, maxplayers,
				      haspass, rank, hash, engineName, engineVersion, map, title, mod );
		if ( nick == m_relay_host_bot ) {
			GetBattle( id ).SetProxy(m_relay_host_bot);
			JoinBattle( id, sett().GetLastHostPassword() ); // autojoin relayed host battles
		}
	} else if ( cmd == _T("JOINEDBATTLE") ) {
		const int id = GetIntParam( params );
		nick = GetWordParam( params );
		const std::string userScriptPassword = GetWordParam( params );
		m_se->OnUserJoinedBattle( id, nick, userScriptPassword );
	} else if ( cmd == _T("UPDATEBATTLEINFO") ) {
		const int id = GetIntParam( params );
		const int specs = GetIntParam( params );
		haspass = GetBoolParam( params );
		const std::string hash = LSL::Util::MakeHashUnsigned( GetWordParam( params ) );
		map = GetSentenceParam( params );
		m_se->OnBattleInfoUpdated( id, specs, haspass, hash, map );
	} else if ( cmd == _T("LOGININFOEND") ) {
		if ( UserExists( _T("RelayHostManagerList") ) ) SayPrivate( _T("RelayHostManagerList"), _T("!lm") );
		m_se->OnLoginInfoComplete();
	} else if ( cmd == _T("REMOVEUSER") ) {
		nick = GetWordParam( params );
		if ( nick == STD_STRING(GetUserName()) ) return; // to prevent peet doing nasty stuff to you, watch your back!
		m_se->OnUserQuit( nick );
	} else if ( cmd == _T("BATTLECLOSED") ) {
		const int id = GetIntParam( params );
		if ( m_battle_id == id ) m_relay_host_bot.clear();
		m_se->OnBattleClosed( id );
	} else if ( cmd == _T("LEFTBATTLE") ) {
		const int id = GetIntParam( params );
		nick = GetWordParam( params );
		m_se->OnUserLeftBattle( id, nick );
	} else if ( cmd == _T("PONG") ) {
		HandlePong( replyid );
	} else if ( cmd == _T("JOIN") ) {
		channel = GetWordParam( params );
		m_se->OnJoinChannelResult( true, channel, "" );
	} else if ( cmd == _T("JOIN") ) {
		channel = GetWordParam( params );
		error = GetSentenceParam( params );
		m_se->OnJoinChannelResult( false, channel, error );
	} else if ( cmd == _T("SAID") ) {
		channel = GetWordParam( params );
		nick = GetWordParam( params );
		m_se->OnChannelSaid( channel, nick, STD_STRING(params));
	} else if ( cmd == _T("JOINED") ) {
		channel = GetWordParam( params );
		nick = GetWordParam( params );
		m_se->OnUserJoinChannel( channel, nick );
	} else if ( cmd == _T("LEFT") ) {
		channel = GetWordParam( params );
		nick = GetWordParam( params );
		msg = GetSentenceParam( params );
		m_se->OnChannelPart( channel, nick, msg );
	} else if ( cmd == _T("CHANNELTOPIC") ) {
		channel = GetWordParam( params );
		nick = GetWordParam( params );
		int pos = GetIntParam( params );
		params.Replace( _T("\\n"), _T("\n") );
		m_se->OnChannelTopic( channel, nick, STD_STRING(params), pos/1000 );
	} else if ( cmd == _T("SAIDEX") ) {
		channel = GetWordParam( params );
		nick = GetWordParam( params );
		m_se->OnChannelAction( channel, nick, STD_STRING(params));
	} else if ( cmd == _T("CLIENTS") ) {
		channel = GetWordParam( params );
		while (!(nick = GetWordParam( params )).empty()) {
			m_se->OnChannelJoin( channel, nick );
		}
	} else if ( cmd == _T("SAYPRIVATE") ) {
		nick = GetWordParam( params );
		if ( ( ( nick == m_relay_host_bot ) || ( nick == m_relay_host_manager ) ) && params.StartsWith( _T("!") ) ) return; // drop the message
		if ( ( nick == "RelayHostManagerList" ) && ( params == _T("!lm") ) ) return;// drop the message
		if ( nick == "SL_bot" ) {
			if ( params.StartsWith( _T("stats.report") ) ) return;
		}
		m_se->OnPrivateMessage( nick, STD_STRING(params), true );
	} else if ( cmd == _T("SAYPRIVATEEX") ) {
		nick = GetWordParam( params );
		m_se->OnPrivateMessageEx( nick, STD_STRING(params), true );
	} else if ( cmd == _T("SAIDPRIVATE") ) {
		nick = GetWordParam( params );
		if ( nick == m_relay_host_bot ) {
			if ( params.StartsWith(_T("JOINEDBATTLE")) ) {
				GetWordParam( params ); // skip first word, it's the message itself
				/*id =*/
				GetIntParam( params );
				wxString usernick = TowxString(GetWordParam( params ));
				wxString userScriptPassword = TowxString(GetWordParam( params ));
				try {
					User& usr = GetUser(usernick);
					usr.BattleStatus().scriptPassword = STD_STRING(userScriptPassword);
					IBattle* battle = GetCurrentBattle();
					if (battle) {
						if ( battle->CheckBan( usr ) ) return;
					}
					SetRelayIngamePassword( usr );
				} catch (...) {}
				return;
			}
		}
		if ( nick == m_relay_host_manager ) {
			if ( params.StartsWith( _T("\001") ) ) { // error code
				m_se->OnServerMessageBox( STD_STRING(params.AfterFirst( _T(' ') )));
			} else {
				m_relay_host_bot = STD_STRING(params);
			}
			m_relay_host_manager.clear();
			return;
		}
		if ( nick == "RelayHostManagerList") {
			if  ( params.StartsWith(_T("list ")) ) {
				wxString list = params.AfterFirst( _T(' ') );
				m_relay_host_manager_list = wxStringTokenize( list, _T("\t") );
				return;
			}
		}
		m_se->OnPrivateMessage( nick, STD_STRING(params), false );
	} else if ( cmd == _T("SAIDPRIVATEEX") ) {
		nick = GetWordParam( params );
		m_se->OnPrivateMessageEx( nick, STD_STRING(params), false );
	} else if ( cmd == _T("JOINBATTLE") ) {
		const int id = GetIntParam( params );
		const std::string hash = LSL::Util::MakeHashUnsigned( GetWordParam( params ) );
		m_battle_id = id;
		m_se->OnJoinedBattle( id, hash );
		m_se->OnBattleInfoUpdated( m_battle_id );
		try {
			if (GetBattle(id).IsProxy()) RelayCmd(_T("SUPPORTSCRIPTPASSWORD")); // send flag to relayhost marking we support script passwords
		} catch(...) {}
	} else if ( cmd == _T("CLIENTBATTLESTATUS") ) {
		nick = GetWordParam( params );
		tasbstatus = GetIntParam( params );
		bstatus = ConvTasbattlestatus( tasbstatus );
		UTASColor color;
		color.data = GetIntParam( params );
		bstatus.colour = LSL::lslColor(color.color.red, color.color.green, color.color.blue);
		m_se->OnClientBattleStatus( m_battle_id, nick, bstatus );
	} else if ( cmd == _T("ADDSTARTRECT") ) {
		//ADDSTARTRECT allyno left top right bottom
		const int ally = GetIntParam( params );
		const int left = GetIntParam( params );
		const int top = GetIntParam( params );
		const int right = GetIntParam( params );
		const int bottom = GetIntParam( params );;
		m_se->OnBattleStartRectAdd( m_battle_id, ally, left, top, right, bottom );
	} else if ( cmd == _T("REMOVESTARTRECT") ) {
		//REMOVESTARTRECT allyno
		const int ally = GetIntParam( params );
		m_se->OnBattleStartRectRemove( m_battle_id, ally );
	} else if ( cmd == _T("ENABLEALLUNITS") ) {
		//"ENABLEALLUNITS" params: "".
		m_se->OnBattleEnableAllUnits( m_battle_id );
	} else if ( cmd == _T("ENABLEUNITS") ) {
		//ENABLEUNITS unitname1 unitname2
		while ( (nick = GetWordParam( params )) !="" ) {
			m_se->OnBattleEnableUnit( m_battle_id, nick );
		}
	} else if ( cmd == _T("DISABLEUNITS") ) {
		//"DISABLEUNITS" params: "arm_advanced_radar_tower arm_advanced_sonar_station arm_advanced_torpedo_launcher arm_dragons_teeth arm_energy_storage arm_eraser arm_fark arm_fart_mine arm_fibber arm_geothermal_powerplant arm_guardian"
		while ( (nick = GetWordParam( params )) != "" ) {
			m_se->OnBattleDisableUnit( m_battle_id, nick );
		}
	} else if ( cmd == _T("CHANNEL") ) {
		channel = GetWordParam( params );
		const int units = GetIntParam( params );
		topic = GetSentenceParam( params );
		m_se->OnChannelList( channel, units, topic );
	} else if ( cmd == _T("ENDOFCHANNELS") ) {
		//Cmd: ENDOFCHANNELS params:
	} else if ( cmd == _T("REQUESTBATTLESTATUS") ) {
		m_se->OnRequestBattleStatus( m_battle_id );
	} else if ( cmd == _T("SAIDBATTLE") ) {
		nick = GetWordParam( params );
		m_se->OnSaidBattle( m_battle_id, nick, STD_STRING(params));
	} else if ( cmd == _T("SAIDBATTLEEX") ) {
		nick = GetWordParam( params );
		m_se->OnBattleAction( m_battle_id, nick, STD_STRING(params));
	} else if ( cmd == _T("AGREEMENT") ) {
		msg = GetSentenceParam( params );
		m_agreement += msg + "\n";
	} else if ( cmd == _T("AGREEMENTEND") ) {
		m_se->OnAcceptAgreement( m_agreement );
		m_agreement.clear();
	} else if ( cmd == _T("OPENBATTLE") ) {
		m_battle_id = GetIntParam( params );
		m_se->OnHostedBattle( m_battle_id );
	} else if ( cmd == _T("ADDBOT") ) {
		// ADDBOT BATTLE_ID name owner battlestatus teamcolor {AIDLL}
		const int id = GetIntParam( params );
		nick = GetWordParam( params );
		owner = GetWordParam( params );
		tasbstatus = GetIntParam( params );
		bstatus = ConvTasbattlestatus( tasbstatus );
		UTASColor color;
		color.data = GetIntParam( params );
		bstatus.colour = LSL::lslColor( color.color.red, color.color.green, color.color.blue );
		wxString ai = TowxString(GetSentenceParam( params ));
		if ( ai.empty() ) {
			wxLogWarning( wxString::Format( _T("Recieved illegal ADDBOT (empty dll field) from %s for battle %d"), nick.c_str(), id ) );
			ai = _T("INVALID|INVALID");
		}
		if (ai.Find(_T('|')) != -1) {
			bstatus.aiversion = STD_STRING(ai.AfterLast( _T('|') ));
			ai = ai.BeforeLast( _T('|') );
		}
		bstatus.aishortname = STD_STRING(ai);
		bstatus.owner = owner;
		m_se->OnBattleAddBot( id, nick, bstatus );
	} else if ( cmd == _T("UPDATEBOT") ) {
		const int id = GetIntParam( params );
		nick = GetWordParam( params );
		tasbstatus = GetIntParam( params );
		bstatus = ConvTasbattlestatus( tasbstatus );
		UTASColor color;
		color.data = GetIntParam( params );
		bstatus.colour = LSL::lslColor( color.color.red, color.color.green, color.color.blue );
		m_se->OnBattleUpdateBot( id, nick, bstatus );
		//UPDATEBOT BATTLE_ID name battlestatus teamcolor
	} else if ( cmd == _T("REMOVEBOT") ) {
		const int id = GetIntParam( params );
		nick = GetWordParam( params );
		m_se->OnBattleRemoveBot( id, nick );
		//REMOVEBOT BATTLE_ID name
	} else if ( cmd == _T("RING") ) {
		nick = GetWordParam( params );
		m_se->OnRing( nick );
		//RING username
	} else if ( cmd == _T("SERVERMSG") ) {
		m_se->OnServerMessage( STD_STRING(params));
		//SERVERMSG {message}
	} else if ( cmd == _T("JOINBATTLEFAILED") ) {
		msg = GetSentenceParam(params);
		m_se->OnServerMessage("Failed to join battle. " + msg );
		//JOINBATTLEFAILED {reason}
	} else if ( cmd == _T("OPENBATTLEFAILED") ) {
		msg = GetSentenceParam( params );
		m_se->OnServerMessage("Failed to host new battle on server. " + msg );
		//OPENBATTLEFAILED {reason}
	} else if ( cmd == _T("JOINFAILED") ) {
		channel = GetWordParam( params );
		msg = GetSentenceParam( params );
		m_se->OnServerMessage("Failed to join channel #" + channel + ". " + msg );
		//JOINFAILED channame {reason}
	} else if ( cmd == _T("CHANNELMESSAGE") ) {
		channel = GetWordParam( params );
		m_se->OnChannelMessage( channel, STD_STRING(params));
		//CHANNELMESSAGE channame {message}
	} else if ( cmd == _T("FORCELEAVECHANNEL") ) {
		channel = GetWordParam( params );
		nick = GetWordParam( params );
		msg = GetSentenceParam( params );
		m_se->OnChannelPart( channel, GetMe().GetNick(), "Kicked by <" + nick + "> " + msg );
		//FORCELEAVECHANNEL channame username [{reason}]
	} else if ( cmd == _T("DENIED") ) {
		if ( m_online ) return;
		m_last_denied = msg = GetSentenceParam( params );
		m_se->OnLoginDenied( msg );
		Disconnect();
		//Command: "DENIED" params: "Already logged in".
	} else if ( cmd == _T("HOSTPORT") ) {
		unsigned int tmp_port = (unsigned int)GetIntParam( params );
		m_se->OnHostExternalUdpPort( tmp_port );
		//HOSTPORT port
	} else if ( cmd == _T("UDPSOURCEPORT") ) {
		unsigned int tmp_port = (unsigned int)GetIntParam( params );
		m_se->OnMyExternalUdpSourcePort( tmp_port );
		if (m_do_finalize_join_battle)FinalizeJoinBattle();
		//UDPSOURCEPORT port
	} else if (cmd == _T("CLIENTIPPORT")) {
		// clientipport username ip port
		nick=GetWordParam( params );
		wxString ip = TowxString(GetWordParam(params));
		unsigned int u_port = (unsigned int)GetIntParam( params );
		m_se->OnClientIPPort(nick, STD_STRING(ip), u_port);
	} else if ( cmd == _T("SETSCRIPTTAGS") ) {
		wxString command;
		while ( (command = TowxString(GetSentenceParam( params ))) != wxEmptyString ) {
			const std::string key = STD_STRING(command.BeforeFirst( '=' ).Lower());
			const std::string value = STD_STRING(command.AfterFirst( '=' ));
			m_se->OnSetBattleInfo( m_battle_id, key, value );
		}
		m_se->OnBattleInfoUpdated( m_battle_id );
		// !! Command: "SETSCRIPTTAGS" params: "game/startpostype=0	game/maxunits=1000	game/limitdgun=0	game/startmetal=1000	game/gamemode=0	game/ghostedbuildings=-1	game/startenergy=1000	game/diminishingmms=0"
	} else if ( cmd == _T("REMOVESCRIPTTAGS")) {
		std::string key;
		while ( (key = GetWordParam(params)) != "" ) {
			m_se->OnUnsetBattleInfo( m_battle_id, key);
		}
		m_se->OnBattleInfoUpdated(m_battle_id);
	} else if ( cmd == _T("SCRIPTSTART") ) {
		m_se->OnScriptStart( m_battle_id );
		// !! Command: "SCRIPTSTART" params: ""
	} else if ( cmd == _T("SCRIPTEND") ) {
		m_se->OnScriptEnd( m_battle_id );
		// !! Command: "SCRIPTEND" params: ""
	} else if ( cmd == _T("SCRIPT") ) {
		m_se->OnScriptLine(  m_battle_id, STD_STRING(params));
		// !! Command: "SCRIPT" params: "[game]"
	} else if ( cmd == _T("FORCEQUITBATTLE")) {
		m_relay_host_bot.clear();
		m_se->OnKickedFromBattle();
	} else if ( cmd == _T("BROADCAST")) {
		m_se->OnServerBroadcast(STD_STRING(params));
	} else if ( cmd == _T("SERVERMSGBOX")) {
		m_se->OnServerMessageBox(STD_STRING(params));
	} else if ( cmd == _T("REDIRECT") ) {
		if ( m_online ) return;
		std::string address = GetWordParam( params );
		unsigned int u_port = GetIntParam( params );
		if ( address.empty() ) return;
		if ( u_port  == 0 ) u_port  = DEFSETT_DEFAULT_SERVER_PORT;
		m_redirecting = true;
		m_se->OnRedirect( address, u_port , STD_STRING(GetUserName()), STD_STRING(GetPassword()));
	} else if ( cmd == _T("MUTELISTBEGIN") ) {
		m_current_chan_name_mutelist = GetWordParam( params );
		m_se->OnMutelistBegin( m_current_chan_name_mutelist );

	} else if ( cmd == _T("MUTELIST") ) {
		const std::string mutee = GetWordParam( params );
		const std::string description = GetSentenceParam( params );
		m_se->OnMutelistItem( m_current_chan_name_mutelist, mutee, description );
	} else if ( cmd == _T("MUTELISTEND") ) {
		m_se->OnMutelistEnd( m_current_chan_name_mutelist );
		m_current_chan_name_mutelist.clear();
	} else if ( cmd == _T("FORCEJOINBATTLE") ) {
		const int battleID = GetIntParam( params );
		const std::string scriptpw = GetWordParam( params );
		m_se->OnForceJoinBattle( battleID, scriptpw );
	} else if ( cmd == _T("REGISTRATIONACCEPTED")) {
		m_se->RegistrationAccepted(STD_STRING(GetUserName()), STD_STRING(GetPassword()));
	} else if ( cmd == _T("REGISTRATIONDENIED") ) {
		m_se->RegistrationDenied(STD_STRING(params));
	} else {
		wxLogMessage( _T("??? Cmd: %s params: %s"), cmd.c_str(), params.c_str() );
		m_se->OnUnknownCommand( STD_STRING(cmd), STD_STRING(params));
	}
}


void TASServer::RelayCmd(  const wxString& command, const wxString& param )
{
	if ( m_relay_host_bot.empty() ) {
		wxLogWarning( _T("Trying to send relayed commands but no relay bot is set!") );
		return;
	}

	wxString msg = _T("!"); // prefix comma,nds with !
	if ( param.IsEmpty() ) msg << command.Lower();
	else msg << command.Lower() << _T(" ") << param;
	SayPrivate(TowxString(m_relay_host_bot), msg );
}


void TASServer::SendCmd( const wxString& command, const wxString& param )
{
	wxString cmd, msg;
	if ( m_id_transmission ) {
		m_last_id++;
		msg = msg + _T("#") + TowxString( m_last_id ) + _T(" ");
	}
	cmd = command;
	if ( param.IsEmpty() ) msg = msg + cmd + _T("\n");
	else msg = msg + cmd + _T(" ") + param + _T("\n");
	bool send_success = m_sock->Send( msg );
	if ((command == _T("LOGIN")) || command == _T("CHANGEPASSWORD")){
		wxLogMessage( _T("sent: %s ... <password removed>"), command.c_str());
		return;
	}

	if ( command != _T("PING") ) {
		if ( send_success )
			wxLogMessage( _T("sent: %s"), msg.RemoveLast().c_str() );
		else
			wxLogMessage( _T("sending: %s failed"), msg.RemoveLast().c_str() );
	}
}

void TASServer::SetRelayIngamePassword( const User& user )
{
	IBattle* battle = GetCurrentBattle();
	if (battle) {
		if ( !battle->GetInGame() ) return;
	}
	RelayCmd( _T("SETINGAMEPASSWORD"), TowxString(user.GetNick()) + _T(" ") + TowxString(user.BattleStatus().scriptPassword));
}

void TASServer::Ping()
{
	SendCmd( _T("PING") );
	TASPingListItem pli;
	pli.id = m_last_id;
	pli.t = wxGetLocalTimeMillis();
	m_pinglist.push_back ( pli );
}

void TASServer::HandlePong( int replyid )
{
	if (m_pinglist.empty()) //safety, shouldn't happen
		return;

	// server connection is tcp, we assume packets are received in order
	TASPingListItem pli = m_pinglist.back();
	m_pinglist.pop_back();
	if (pli.id == replyid ) {
		m_se->OnPong( (wxGetLocalTimeMillis() - pli.t) );
	}
}


void TASServer::JoinChannel( const wxString& channel, const wxString& key )
{
	//JOIN channame [key]
	slLogDebugFunc("");

	m_channel_pw[channel] = key;
	m_id_transmission = false; // workaround a retarded server bug
	SendCmd ( _T("JOIN"), channel + _T(" ") + key );
	m_id_transmission = true;
}


void TASServer::PartChannel( const wxString& channel )
{
	//LEAVE channame
	slLogDebugFunc("");

	SendCmd( _T("LEAVE"), channel );

}


void TASServer::DoActionChannel( const wxString& channel, const wxString& msg )
{
	//SAYEX channame {message}
	slLogDebugFunc("");

	SendCmd( _T("SAYEX"), channel + _T(" ") + msg );
}


void TASServer::SayChannel( const wxString& channel, const wxString& msg )
{
	//SAY channame {message}
	slLogDebugFunc("");

	SendCmd( _T("SAY"), channel + _T(" ") + msg );
}


void TASServer::SayPrivate( const wxString& nick, const wxString& msg )
{
	//SAYPRIVATE username {message}
	slLogDebugFunc("");

	SendCmd( _T("SAYPRIVATE"), nick + _T(" ") + msg );
}


void TASServer::DoActionPrivate( const wxString& nick, const wxString& msg )
{
	slLogDebugFunc("");
	SendCmd( _T("SAYPRIVATEEX"), nick + _T(" ") + msg );
}


void TASServer::SayBattle( int /*unused*/, const wxString& msg )
{
	slLogDebugFunc("");
	SendCmd( _T("SAYBATTLE"), msg );
}


void TASServer::DoActionBattle( int /*unused*/, const wxString& msg )
{
	slLogDebugFunc("");
	SendCmd( _T("SAYBATTLEEX"), msg );
}


void TASServer::Ring( const wxString& nick )
{
	slLogDebugFunc("");
	try {
		ASSERT_EXCEPTION( m_battle_id != -1, _T("invalid m_battle_id value") );
		ASSERT_EXCEPTION( BattleExists(m_battle_id), _T("battle doesn't exists") );

		IBattle& battle = GetBattle( m_battle_id );
		ASSERT_EXCEPTION( battle.IsFounderMe(), _T("I'm not founder") );

		if ( battle.IsProxy() ) {
			RelayCmd( _T("RING"), nick );
		} else {
			SendCmd( _T("RING"), nick );
		}

	} catch (...) {
		SendCmd( _T("RING"), nick );
	}
}




void TASServer::ModeratorSetChannelTopic( const wxString& channel, const wxString& topic )
{
	wxString msgcopy = topic;
	msgcopy.Replace( _T("\n"), _T("\\n") );
	SendCmd( _T("CHANNELTOPIC"), channel + _T(" ") + msgcopy );
}


void TASServer::ModeratorSetChannelKey( const wxString& channel, const wxString& key)
{
	SendCmd( _T("SETCHANNELKEY"), channel + _T(" ") + key );
}


void TASServer::ModeratorMute( const wxString& channel, const wxString& nick, int duration, bool byip )
{
	SendCmd( _T("MUTE"), channel + _T(" ") + nick + _T(" ") + wxString::Format( _T("%d"), duration) + (byip?_T(" ip"):wxEmptyString )  );
}


void TASServer::ModeratorUnmute( const wxString& channel, const wxString& nick )
{
	SendCmd( _T("UNMUTE"),  channel + _T(" ") + nick );
}


void TASServer::ModeratorKick( const wxString& channel, const wxString& reason )
{
	SendCmd( _T("KICKUSER"), channel + _T(" ") + reason );
}


void TASServer::ModeratorBan( const wxString& /*unused*/, bool /*unused*/ )
{
	// FIXME TASServer::ModeratorBan not yet implemented
}


void TASServer::ModeratorUnban( const wxString& /*unused*/ )
{
	// FIXME TASServer::ModeratorUnban not yet implemented
}


void TASServer::ModeratorGetIP( const wxString& nick )
{
	SendCmd( _T("GETIP"), nick );
}


void TASServer::ModeratorGetLastLogin( const wxString& nick )
{
	SendCmd( _T("GETLASTLOGINTIME"), nick );
}


void TASServer::ModeratorGetLastIP( const wxString& nick )
{
	SendCmd( _T("GETLASTIP"), nick );
}


void TASServer::ModeratorFindByIP( const wxString& ipadress )
{
	SendCmd( _T("FINDIP"), ipadress );
}


void TASServer::AdminGetAccountAccess( const wxString& /*unused*/ )
{
	// FIXME TASServer::AdminGetAccountAccess not yet implemented
}


void TASServer::AdminChangeAccountAccess( const wxString& /*unused*/, const wxString& /*unused*/ )
{
	// FIXME TASServer::AdminChangeAccountAccess not yet implemented
}


void TASServer::AdminSetBotMode( const wxString& nick, bool isbot )
{
	SendCmd( _T("SETBOTMODE"), nick + _T(" ") + (isbot?_T("1"):_T("0")) );
}





void TASServer::HostBattle( BattleOptions bo, const wxString& password )
{
	slLogDebugFunc("");

	// to see ip addresses of users as they join (in the log), pretend you're hosting with NAT.
	int nat_type=bo.nattype;
	/*
	if(nat_type==0 && sett().GetShowIPAddresses()){
	nat_type=1;
	}*/
	wxLogMessage(_T("hosting with nat type %d"),nat_type);

	wxString cmd = wxString::Format( _T("0 %d "), nat_type );
	cmd += (password.IsEmpty())?_T("*"):password;
	cmd += wxString::Format( _T(" %d %d "), bo.port, bo.maxplayers );
	cmd += TowxString(LSL::Util::MakeHashSigned(bo.modhash));
	cmd += wxString::Format( _T(" %d "), bo.rankneeded );
	cmd += TowxString(LSL::Util::MakeHashSigned(bo.maphash)) + _T(" ");
	if (!bo.userelayhost) { //FIXME: relay host hasn't multiversion support yet, see https://github.com/springlobby/springlobby/issues/98
		cmd += TowxString(bo.engineName) + _T("\t");
		cmd += TowxString(bo.engineVersion) + _T("\t");
	}
	cmd += TowxString(bo.mapname) + _T("\t");
	cmd += TowxString(bo.description) + _T("\t");
	cmd += TowxString(bo.modname);

	m_delayed_open_command = wxEmptyString;
	if ( !bo.userelayhost ) {
		SendCmd( _T("OPENBATTLE"), cmd );
	} else {
		if ( bo.relayhost.empty() ) {
			wxArrayString relaylist = GetRelayHostList();
			unsigned int numbots = relaylist.GetCount();
			if ( numbots > 0 ) {
				srand ( time(NULL) );
				unsigned int choice = rand() % numbots;
				m_relay_host_manager = STD_STRING(relaylist[choice]);
				m_delayed_open_command = cmd;
				SayPrivate( TowxString(m_relay_host_manager), _T("!spawn") );
			}
		} else {
			m_relay_host_manager = bo.relayhost;
			m_delayed_open_command = cmd;
			SayPrivate(TowxString(bo.relayhost),_T("!spawn"));
		}
	}

	if (bo.nattype>0)UdpPingTheServer(GetUserName());

	// OPENBATTLE type natType password port maphash {map} {title} {modname}
}


void TASServer::JoinBattle( const int& battleid, const wxString& password )
{
	//JOINBATTLE BATTLE_ID [parameter]
	slLogDebugFunc("");

	m_finalize_join_battle_pw=password;
	m_finalize_join_battle_id=battleid;

	if (BattleExists(battleid)) {
		IBattle *battle=&GetBattle(battleid);

		if (battle) {
			if ( ( battle->GetNatType() == NAT_Hole_punching ) || ( battle->GetNatType() == NAT_Fixed_source_ports ) ) {
				m_udp_private_port=sett().GetClientPort();

				m_last_udp_ping = 0;
				// its important to set time now, to prevent Update()
				// from calling FinalizeJoinBattle() on timeout.
				// m_do_finalize_join_battle must be set to true after setting time, not before.
				m_do_finalize_join_battle=true;
				for (int n=0; n<5; ++n) { // do 5 udp pings with tiny interval
					UdpPingTheServer( GetUserName() );
					// sleep(0);// sleep until end of timeslice.
				}
				m_last_udp_ping = 0;// set time again
			} else {
				// if not using nat, finalize now.
				m_do_finalize_join_battle=true;
				FinalizeJoinBattle();
			}
		} else {
			wxLogMessage( _T("battle doesnt exist (null)") );
		}
	} else {
		wxLogMessage( _T("battle doesnt exist") );
	}
	//SendCmd( _T("JOINBATTLE"), wxString::Format( _T("%d"), battleid ) + _T(" ") + password );
}


void TASServer::FinalizeJoinBattle()
{
	if (m_do_finalize_join_battle) {
		// save scriptPassword so user can rejoin if SL crashes or
		// loosed connection
		wxString scriptPassword;
		if (sett().GetLastBattleId() == m_finalize_join_battle_id) {
			scriptPassword = sett().GetLastScriptPassword();
		} else {
			srand ( time(NULL) );
			scriptPassword = wxString::Format(_T("%04x%04x"), rand()&0xFFFF, rand()&0xFFFF);
			// save assword and write settings file
			sett().SetLastBattleId(m_finalize_join_battle_id);
			sett().SetLastScriptPassword(scriptPassword);
			sett().SaveSettings();
		}
		SendCmd( _T("JOINBATTLE"), wxString::Format( _T("%d %s %s"), m_finalize_join_battle_id, m_finalize_join_battle_pw.c_str(), scriptPassword.c_str()  ) );
		m_do_finalize_join_battle=false;
	}
}


void TASServer::LeaveBattle( const int& /*unused*/ )
{
	//LEAVEBATTLE
	slLogDebugFunc("");
	m_relay_host_bot.clear();
	SendCmd( _T("LEAVEBATTLE") );
}


void TASServer::SendHostInfo( HostInfo update )
{
	slLogDebugFunc("");

	try {
		ASSERT_LOGIC( m_battle_id != -1, _T("invalid m_battle_id value") );
		ASSERT_LOGIC( BattleExists(m_battle_id), _T("battle doesn't exists") );
	} catch (...) {
		return;
	}

	IBattle& battle = GetBattle( m_battle_id );
	try {
		ASSERT_LOGIC( battle.IsFounderMe(), _T("I'm not founder") );
	} catch (...) {
		return;
	}

	//BattleOptions bo = battle.opts();

	if ( ( update & ( IBattle::HI_Map | IBattle::HI_Locked | IBattle::HI_Spectators ) ) > 0 ) {
		// UPDATEBATTLEINFO SpectatorCount locked maphash {mapname}
		wxString cmd = wxString::Format( _T("%d %d "), battle.GetSpectators(), battle.IsLocked() );
		cmd += TowxString(LSL::Util::MakeHashSigned(battle.LoadMap().hash) + " ");
		cmd += TowxString(battle.LoadMap().name);

		if ( !battle.IsProxy() ) SendCmd( _T("UPDATEBATTLEINFO"), cmd );
		else RelayCmd( _T("UPDATEBATTLEINFO"), cmd );
	}
	if ( ( update & IBattle::HI_Send_All_opts ) > 0 ) {
		wxString cmd;
for (const auto& it : battle.CustomBattleOptions().getOptions( LSL::Enum::MapOption )) {
			const wxString newcmd = TowxString("game/mapoptions/" + it.first + "=" + it.second.second + "\t");
			if ( cmd.size() + newcmd.size() > 900 ) { // should be 1024 add margin for relayhost name and command itself
				if ( !battle.IsProxy() ) SendCmd( _T("SETSCRIPTTAGS"), cmd );
				else RelayCmd( _T("SETSCRIPTTAGS"), cmd );
				cmd = wxEmptyString;
			}
			cmd << newcmd;
		}
		for (const auto& it : battle.CustomBattleOptions().getOptions( LSL::Enum::ModOption )) {
			const wxString newcmd = TowxString("game/modoptions/" + it.first + "=" + it.second.second + "\t");
			if ( cmd.size() + newcmd.size() > 900 ) { // should be 1024 add margin for relayhost name and command itself
				if ( !battle.IsProxy() ) SendCmd( _T("SETSCRIPTTAGS"), cmd );
				else RelayCmd( _T("SETSCRIPTTAGS"), cmd );
				cmd = wxEmptyString;
			}
			cmd << newcmd;
		}
		for (const auto& it : battle.CustomBattleOptions().getOptions( LSL::Enum::EngineOption )) {
			const wxString newcmd = TowxString("game/" + it.first + "=" + it.second.second + "\t");
			if ( cmd.size() + newcmd.size() > 900 ) { // should be 1024 add margin for relayhost name and command itself
				if ( !battle.IsProxy() ) SendCmd( _T("SETSCRIPTTAGS"), cmd );
				else RelayCmd( _T("SETSCRIPTTAGS"), cmd );
				cmd = wxEmptyString;
			}
			cmd << newcmd;
		}
		if ( !battle.IsProxy() ) SendCmd( _T("SETSCRIPTTAGS"), cmd );
		else RelayCmd( _T("SETSCRIPTTAGS"), cmd );
	}

	if ( (update & IBattle::HI_StartRects) > 0 ) { // Startrects should be updated.
		unsigned int numrects = battle.GetLastRectIdx();
		for ( unsigned int i = 0; i <= numrects; i++ ) { // Loop through all, and remove updated or deleted.
			wxString cmd;
			BattleStartRect sr = battle.GetStartRect( i );
			if ( !sr.exist ) continue;
			if ( sr.todelete ) {
				if ( !battle.IsProxy() ) SendCmd( _T("REMOVESTARTRECT"), wxString::Format( _T("%d"), i ) );
				else RelayCmd( _T("REMOVESTARTRECT"), wxString::Format( _T("%d"), i ) );
				battle.StartRectRemoved( i );
			} else if ( sr.toadd ) {
				if ( !battle.IsProxy() ) SendCmd( _T("ADDSTARTRECT"), wxString::Format( _T("%d %d %d %d %d"), sr.ally, sr.left, sr.top, sr.right, sr.bottom ) );
				else RelayCmd( _T("ADDSTARTRECT"), wxString::Format( _T("%d %d %d %d %d"), sr.ally, sr.left, sr.top, sr.right, sr.bottom ) );
				battle.StartRectAdded( i );
			} else if ( sr.toresize ) {
				if ( !battle.IsProxy() ) {
					SendCmd( _T("REMOVESTARTRECT"), wxString::Format( _T("%d"), i ) );
					SendCmd( _T("ADDSTARTRECT"), wxString::Format( _T("%d %d %d %d %d"), sr.ally, sr.left, sr.top, sr.right, sr.bottom ) );
				} else {
					RelayCmd( _T("REMOVESTARTRECT"), wxString::Format( _T("%d"), i ) );
					RelayCmd( _T("ADDSTARTRECT"), wxString::Format( _T("%d %d %d %d %d"), sr.ally, sr.left, sr.top, sr.right, sr.bottom ) );
				}
				battle.StartRectResized( i );
			}
		}

	}
	if ( (update & IBattle::HI_Restrictions) > 0 ) {
		std::map<std::string, int> units = battle.RestrictedUnits();
		if ( !battle.IsProxy() ) SendCmd( _T("ENABLEALLUNITS") );
		else RelayCmd( _T("ENABLEALLUNITS") );
		if ( !units.empty() ) {
			wxString msg;
			wxString scriptmsg;
			for ( std::map<std::string, int>::const_iterator itor = units.begin(); itor != units.end(); ++itor ) {
				msg << TowxString(itor->first) + _T(" ");
				scriptmsg << _T("game/restrict/") + TowxString(itor->first) + _T("=") + TowxString(itor->second) + _T('\t'); // this is a serious protocol abuse, but on the other hand, the protocol fucking suck and it's unmaintained so it will do for now
			}
			if ( !battle.IsProxy() ) {
				SendCmd( _T("DISABLEUNITS"), msg );
				SendCmd( _T("SETSCRIPTTAGS"), scriptmsg );
			} else {
				RelayCmd( _T("DISABLEUNITS"), msg );
				RelayCmd( _T("SETSCRIPTTAGS"), scriptmsg );
			}
		}
	}
}


void TASServer::SendHostInfo( const wxString& Tag )
{
	slLogDebugFunc("");

	try {
		ASSERT_LOGIC( m_battle_id != -1, _T("invalid m_battle_id value") );
		ASSERT_LOGIC( BattleExists(m_battle_id), _T("battle doesn't exists") );
	} catch (...) {
		return;
	}

	IBattle& battle = GetBattle( m_battle_id );

	try {
		ASSERT_LOGIC( battle.IsFounderMe(), _T("I'm not founder") );
	} catch (...) {
		return;
	}

	wxString cmd;

	long type;
	Tag.BeforeFirst( '_' ).ToLong( &type );
	const wxString key = Tag.AfterFirst( '_' );
	if ( type == LSL::Enum::MapOption ) {
		cmd << _T("game/mapoptions/") << key << _T("=")
		    << TowxString(battle.CustomBattleOptions().getSingleValue(STD_STRING(key), LSL::Enum::MapOption ));
	} else if ( type == LSL::Enum::ModOption ) {
		cmd << _T("game/modoptions/") << key << _T("=")
		    << TowxString(battle.CustomBattleOptions().getSingleValue(STD_STRING(key), LSL::Enum::ModOption ));
	} else if ( type == LSL::Enum::EngineOption ) {
		cmd << _T("game/") << key << _T("=")
		    << TowxString(battle.CustomBattleOptions().getSingleValue(STD_STRING(key), LSL::Enum::EngineOption ));
	}
	if ( !battle.IsProxy() ) SendCmd( _T("SETSCRIPTTAGS"), cmd );
	else RelayCmd( _T("SETSCRIPTTAGS"), cmd );
}


void TASServer::SendUserPosition( const User& user )
{
	slLogDebugFunc("");

	try {
		ASSERT_LOGIC( m_battle_id != -1, _T("invalid m_battle_id value") );
		ASSERT_LOGIC( BattleExists(m_battle_id), _T("battle doesn't exists") );

		IBattle& battle = GetBattle( m_battle_id );
		ASSERT_LOGIC( battle.IsFounderMe(), _T("I'm not founder") );

		UserBattleStatus status = user.BattleStatus();
		wxString msgx = _T("game/Team") + TowxString( status.team ) + _T("/StartPosX=") + TowxString( status.pos.x );
		wxString msgy = _T("game/Team") + TowxString( status.team ) + _T("/StartPosY=") + TowxString( status.pos.y );
		wxString netmessage = msgx + _T("\t") + msgy;
		if ( battle.IsProxy() ) {
			RelayCmd( _T("SETSCRIPTTAGS"), netmessage );
		} else {
			SendCmd( _T("SETSCRIPTTAGS"), netmessage );
		}
	} catch (...) {
		return;
	}
}

void TASServer::SendRaw( const wxString& raw )
{
	SendCmd( raw );
}


void TASServer::RequestInGameTime( const wxString& nick )
{
	SendCmd( _T("GETINGAMETIME"), nick );
}


IBattle* TASServer::GetCurrentBattle()
{
	try {
		ASSERT_EXCEPTION( m_battle_id != -1, _T("invalid m_battle_id value") );
		ASSERT_LOGIC( BattleExists(m_battle_id), _T("battle doesn't exists") );
	} catch (...) {
		return NULL;
	}

	return &GetBattle( m_battle_id );
}


void TASServer::SendMyBattleStatus( UserBattleStatus& bs )
{
	slLogDebugFunc("");

	const int tasbs = ConvTasbattlestatus( bs );
	UTASColor tascl;
	tascl.color.red = bs.colour.Red();
	tascl.color.green = bs.colour.Green();
	tascl.color.blue = bs.colour.Blue();
	tascl.color.zero = 0;
	//MYBATTLESTATUS battlestatus myteamcolor
	SendCmd( _T("MYBATTLESTATUS"), wxString::Format( _T("%d %d"), tasbs, tascl.data ) );
}


void TASServer::SendMyUserStatus(const UserStatus& us)
{
	slLogDebugFunc("");
	const int taus = ConvUserStatus(us);
	SendCmd( _T("MYSTATUS"), wxString::Format( _T("%d"), taus ) );
}



void TASServer::StartHostedBattle()
{
	slLogDebugFunc("");
	try {
		ASSERT_LOGIC( m_battle_id != -1, _T("Invalid m_battle_id") );
		ASSERT_LOGIC( BattleExists(m_battle_id), _T("battle doesn't exists") );
	} catch (...) {
		return;
	}
	IBattle *battle=GetCurrentBattle();
	if (battle) {
		if ( ( battle->GetNatType() == NAT_Hole_punching ) || ( battle->GetNatType() == NAT_Fixed_source_ports ) ) {
			UdpPingTheServer(GetUserName());
			for (int i=0; i<5; ++i)UdpPingAllClients();
		}
	}

	m_se->OnStartHostedBattle( m_battle_id );
}


void TASServer::ForceSide( int battleid, User& user, int side )
{
	slLogDebugFunc("");
	try {
		ASSERT_LOGIC( m_battle_id != -1, _T("Invalid m_battle_id") );
		ASSERT_LOGIC( BattleExists(m_battle_id), _T("battle doesn't exists") );
		ASSERT_LOGIC( battleid == m_battle_id, _T("Not current battle") );
	} catch (...) {
		return;
	}

	UserBattleStatus status = user.BattleStatus();

	if ( &user == &GetMe() ) {
		status.side = side;
		SendMyBattleStatus( status );
		return;
	}

	if ( status.IsBot() ) {
		status.side = side;
		UpdateBot( battleid, user, status );
	}
}


void TASServer::ForceTeam( int battleid, User& user, int team )
{
	slLogDebugFunc("");
	try {
		ASSERT_LOGIC( m_battle_id != -1, _T("Invalid m_battle_id") );
		ASSERT_LOGIC( BattleExists(m_battle_id), _T("battle doesn't exists") );
		ASSERT_LOGIC( battleid == m_battle_id, _T("Not current battle") );
	} catch (...) {
		return;
	}
	UserBattleStatus status = user.BattleStatus();
	if ( status.IsBot() ) {
		status.team = team;
		UpdateBot( battleid, user, status );
		return;
	}
	if ( &user == &GetMe() ) {
		status.team = team;
		SendMyBattleStatus( status );
		return;
	}
	if ( !GetBattle(battleid).IsFounderMe() ) {
		DoActionBattle( battleid, _T("suggests that ") + TowxString(user.GetNick()) + _T(" changes to team #") + wxString::Format( _T("%d"), team + 1 ) + _T(".") );
		return;
	}

	//FORCETEAMNO username teamno
	if( !GetBattle(battleid).IsProxy() ) SendCmd( _T("FORCETEAMNO"), TowxString(user.GetNick()) + wxString::Format(_T(" %d"), team ) );
	else RelayCmd( _T("FORCETEAMNO"), TowxString(user.GetNick()) + wxString::Format(_T(" %d"), team ) );
}


void TASServer::ForceAlly( int battleid, User& user, int ally )
{
	slLogDebugFunc("");
	try {
		ASSERT_LOGIC( m_battle_id != -1, _T("Invalid m_battle_id") );
		ASSERT_LOGIC( BattleExists(m_battle_id), _T("battle doesn't exists") );
		ASSERT_LOGIC( battleid == m_battle_id, _T("Not current battle") );
	} catch (...) {
		return;
	}
	UserBattleStatus status = user.BattleStatus();
	if ( status.IsBot() ) {
		status.ally = ally;
		UpdateBot( battleid, user, status );
		return;
	}

	if ( &user == &GetMe() ) {
		status.ally = ally;
		SendMyBattleStatus( status );
		return;
	}

	if ( !GetBattle(battleid).IsFounderMe() ) {
		DoActionBattle( battleid, _T("suggests that ") + TowxString(user.GetNick()) + _T(" changes to ally #") + wxString::Format( _T("%d"), ally + 1 ) + _T(".") );
		return;
	}

	//FORCEALLYNO username teamno
	if( !GetBattle(battleid).IsProxy() ) SendCmd( _T("FORCEALLYNO"), TowxString(user.GetNick()) + wxString::Format( _T(" %d"), ally ) );
	else RelayCmd( _T("FORCEALLYNO"), TowxString(user.GetNick()) + wxString::Format( _T(" %d"), ally ) );
}


void TASServer::ForceColour( int battleid, User& user, const LSL::lslColor& col )
{
	slLogDebugFunc("");
	try {
		ASSERT_LOGIC( m_battle_id != -1, _T("Invalid m_battle_id") );
		ASSERT_LOGIC( BattleExists(m_battle_id), _T("battle doesn't exists") );
		ASSERT_LOGIC( battleid == m_battle_id, _T("Not current battle") );
	} catch (...) {
		return;
	}
	UserBattleStatus status = user.BattleStatus();
	if ( status.IsBot() ) {
		status.colour = col;
		UpdateBot( battleid, user, status );
		return;
	}
	if ( &user == &GetMe() ) {
		status.colour = col;
		SendMyBattleStatus( status );
		return;
	}
	if ( !GetBattle(battleid).IsFounderMe() ) {
		DoActionBattle( battleid, _T("sugests that ") + TowxString(user.GetNick()) + _T(" changes colour.") );
		return;
	}

	UTASColor tascl;
	tascl.color.red = col.Red();
	tascl.color.green = col.Green();
	tascl.color.blue = col.Blue();
	tascl.color.zero = 0;
	//FORCETEAMCOLOR username color
	if( !GetBattle(battleid).IsProxy() ) SendCmd( _T("FORCETEAMCOLOR"), TowxString(user.GetNick()) + _T(" ") + wxString::Format( _T("%d"), tascl.data ) );
	else RelayCmd( _T("FORCETEAMCOLOR"), TowxString(user.GetNick()) + _T(" ") + wxString::Format( _T("%d"), tascl.data ) );
}


void TASServer::ForceSpectator( int battleid, User& user, bool spectator )
{
	slLogDebugFunc("");
	try {
		ASSERT_LOGIC( m_battle_id != -1, _T("Invalid m_battle_id") );
		ASSERT_LOGIC( BattleExists(m_battle_id), _T("battle doesn't exists") );
		ASSERT_LOGIC( battleid == m_battle_id, _T("Not current battle") );
	} catch (...) {
		return;
	}
	UserBattleStatus status = user.BattleStatus();
	if ( status.IsBot() ) {
		status.spectator = spectator;
		UpdateBot( battleid, user, status );
		return;
	}
	if ( &user == &GetMe() ) {
		status.spectator = spectator;
		SendMyBattleStatus( status );
		return;
	}
	if ( !GetBattle(battleid).IsFounderMe() ) {
		if ( spectator ) DoActionBattle( battleid, _T("suggests that ") + TowxString(user.GetNick()) + _T(" becomes a spectator.") );
		else DoActionBattle( battleid, _T("suggests that ") + TowxString(user.GetNick()) + _T(" plays.") );
		return;
	}

	//FORCESPECTATORMODE username
	if( !GetBattle(battleid).IsProxy() ) SendCmd( _T("FORCESPECTATORMODE"), TowxString(user.GetNick()) );
	else RelayCmd( _T("FORCESPECTATORMODE"), TowxString(user.GetNick()) );
}


void TASServer::BattleKickPlayer( int battleid, User& user )
{
	slLogDebugFunc("");
	try {
		ASSERT_LOGIC( m_battle_id != -1, _T("Invalid m_battle_id") );
		ASSERT_LOGIC( BattleExists(m_battle_id), _T("battle doesn't exists") );
		ASSERT_LOGIC( battleid == m_battle_id, _T("Not current battle") );
	} catch (...) {
		return;
	}
	UserBattleStatus status = user.BattleStatus();
	if ( status.IsBot() ) {
		RemoveBot( battleid, user );
		return;
	}
	if ( &user == &GetMe() ) {
		LeaveBattle( battleid );
		return;
	}
	if ( !GetBattle(battleid).IsFounderMe() ) {
		DoActionBattle( battleid, _T("thinks ") + TowxString(user.GetNick()) + _T(" should leave.") );
		return;
	}

	//KICKFROMBATTLE username
	if( !GetBattle(battleid).IsProxy() ) {
		user.BattleStatus().scriptPassword = STD_STRING(wxString::Format(_T("%04x%04x"), rand()&0xFFFF, rand()&0xFFFF)); // reset his password to something random, so he can't rejoin
		SetRelayIngamePassword( user );
		SendCmd( _T("KICKFROMBATTLE"), TowxString(user.GetNick()) );
	} else RelayCmd( _T("KICKFROMBATTLE"), TowxString(user.GetNick()) );
}

void TASServer::SetHandicap( int battleid, User& user, int handicap)
{
	slLogDebugFunc("");
	try {
		ASSERT_LOGIC( m_battle_id != -1, _T("Invalid m_battle_id") );
		ASSERT_LOGIC( BattleExists(m_battle_id), _T("battle doesn't exists") );
		ASSERT_LOGIC( battleid == m_battle_id, _T("Not current battle") );
	} catch (...) {
		return;
	}
	UserBattleStatus status = user.BattleStatus();
	if ( status.IsBot() ) {
		status.handicap = handicap;
		UpdateBot( battleid, user, status );
		return;
	}

	if ( !GetBattle(battleid).IsFounderMe() ) {
		DoActionBattle( battleid, _T("thinks ") + TowxString(user.GetNick()) + _T(" should get a ") + wxString::Format( _T("%d"), handicap) + _T("% resource bonus") );
		return;
	}

	//HANDICAP username value
	if( !GetBattle(battleid).IsProxy() ) SendCmd( _T("HANDICAP"), TowxString(user.GetNick()) + wxString::Format( _T(" %d"), handicap ) );
	else RelayCmd( _T("HANDICAP"), TowxString(user.GetNick()) + wxString::Format( _T(" %d"), handicap ) );
}


void TASServer::AddBot( int battleid, const wxString& nick, UserBattleStatus& status )
{
	slLogDebugFunc("");
	try {
		ASSERT_LOGIC( m_battle_id != -1, _T("Invalid m_battle_id") );
		ASSERT_LOGIC( BattleExists(m_battle_id), _T("battle doesn't exists") );
		ASSERT_LOGIC( battleid == m_battle_id, _T("Not current battle") );
	} catch (...) {
		return;
	}

	const int tasbs = ConvTasbattlestatus( status );
	UTASColor tascl;
	tascl.color.red = status.colour.Red();
	tascl.color.green = status.colour.Green();
	tascl.color.blue = status.colour.Blue();
	tascl.color.zero = 0;
	//ADDBOT name battlestatus teamcolor {AIDLL}
	wxString msg;
	wxString ailib;
	ailib += TowxString(status.aishortname);
	ailib += _T("|") +TowxString(status.aiversion);
	SendCmd( _T("ADDBOT"), TowxString(nick) + wxString::Format( _T(" %d %d "), tasbs, tascl.data ) + ailib );
}


void TASServer::RemoveBot( int battleid, User& bot )
{
	slLogDebugFunc("");
	try {
		ASSERT_LOGIC( m_battle_id != -1, _T("Invalid m_battle_id") );
		ASSERT_LOGIC( BattleExists(m_battle_id), _T("battle doesn't exists") );
		ASSERT_LOGIC( battleid == m_battle_id, _T("Not current battle") );
	} catch (...) {
		return;
	}

	IBattle& battle = GetBattle( battleid );
	ASSERT_LOGIC( &bot != 0, _T("Bot does not exist.") );

	if ( !( battle.IsFounderMe() || ( bot.BattleStatus().owner == GetMe().GetNick() ) ) ) {
		DoActionBattle( battleid, _T("thinks the bot ") + TowxString(bot.GetNick()) + _T(" should be removed.") );
		return;
	}

	//REMOVEBOT name
	if( !GetBattle(battleid).IsProxy() ) SendCmd( _T("REMOVEBOT"), TowxString(bot.GetNick()) );
	else RelayCmd( _T("REMOVEBOT"), TowxString(bot.GetNick()) );
}


void TASServer::UpdateBot( int battleid, User& bot, UserBattleStatus& status )
{
	slLogDebugFunc("");
	try {
		ASSERT_LOGIC( m_battle_id != -1, _T("Invalid m_battle_id") );
		ASSERT_LOGIC( BattleExists(m_battle_id), _T("battle doesn't exists") );
		ASSERT_LOGIC( battleid == m_battle_id, _T("Not current battle") );
	} catch (...) {
		return;
	}

	const int tasbs = ConvTasbattlestatus( status );
	UTASColor tascl;
	tascl.color.red = status.colour.Red();
	tascl.color.green = status.colour.Green();
	tascl.color.blue = status.colour.Blue();
	tascl.color.zero = 0;
	//UPDATEBOT name battlestatus teamcolor
	if( !GetBattle(battleid).IsProxy() ) SendCmd( _T("UPDATEBOT"), TowxString(bot.GetNick()) + wxString::Format( _T(" %d %d"), tasbs, tascl.data ) );
	else RelayCmd( _T("UPDATEBOT"), TowxString(bot.GetNick()) + wxString::Format( _T(" %d %d"), tasbs, tascl.data ) );
}

/*
void TASServer::SendScriptToProxy( const wxString& script )
{
	wxArrayString strings = wxStringTokenize( script, _T("\n") );
	int relaylenghtprefix = 10 + 1 + m_relay_host_bot.Len() + 2; // SAYPRIVATE + space + botname + space + exclamation mark lenght
	int lenght = script.size();
	lenght += relaylenghtprefix + 11 + 1; // CLEANSCRIPT command size
	lenght += strings.GetCount() * ( relaylenghtprefix + 16 + 1 ); // num lines * APPENDSCRIPTLINE + space command size ( \n is already counted in script.size)
	lenght += relaylenghtprefix + 9 + 1; // STARTGAME command size
	int time = lenght / m_sock->GetSendRateLimit(); // calculate time in seconds to upload script
	DoActionBattle( m_battle_id, wxString::Format(_T("is preparing to start the game, game will start in approximately %d seconds"),time));
	RelayCmd( _T("CLEANSCRIPT") );
	wxStringTokenizer tkzr( script, _T("\n") );
	while ( tkzr.HasMoreTokens() ) {
		wxString line = tkzr.GetNextToken();
		RelayCmd( _T("APPENDSCRIPTLINE"), line );
	}
	RelayCmd( _T("STARTGAME") );
}


void TASServer::SendScriptToClients( const wxString& script )
{
	SendCmd( _T("SCRIPTSTART") );
	wxStringTokenizer tkzr( script, _T("\n") );
	while ( tkzr.HasMoreTokens() ) {
		wxString line = tkzr.GetNextToken();
		SendCmd( _T("SCRIPT"), line );
	}
	SendCmd( _T("SCRIPTEND") );
}
*/

void TASServer::OnConnected(Socket& /*unused*/ )
{
	slLogDebugFunc("");
	//TASServer* serv = (TASServer*)sock->GetUserdata();
	m_connected = true;
	m_online = false;
	m_relay_host_manager_list.Clear();
	m_last_denied.clear();
	m_last_id = 0;
	m_pinglist.clear();
}


void TASServer::OnDisconnected(Socket& /*unused*/ )
{
	slLogDebugFunc("%d", m_connected);
	const bool connectionwaspresent = m_online || !m_last_denied.empty() || m_redirecting;
	m_last_denied.clear();
	m_connected = false;
	m_online = false;
	m_redirecting = false;
	m_buffer = wxEmptyString;
	m_relay_host_manager_list.Clear();
	m_last_id = 0;
	m_pinglist.clear();
	m_users.Nullify();
	if (m_se != NULL) {
		m_se->OnDisconnected( connectionwaspresent );
		IServer::OnDisconnected();
	}
}


void TASServer::OnDataReceived( Socket& sock )
{
	m_last_net_packet = 0;
	wxString data = sock.Receive();
	m_buffer << data;
	m_buffer.Replace( _T("\r\n"), _T("\n") );
	int returnpos = m_buffer.Find( _T("\n") );
	while ( returnpos != -1 ) {
		wxString cmd = m_buffer.Left( returnpos );
		m_buffer = m_buffer.Mid( returnpos + 1 );
		ExecuteCommand( cmd );
		returnpos = m_buffer.Find( _T("\n") );
	}
}
void TASServer::OnError(const wxString& err)
{
    wxLogError(err);
	if (m_se != NULL) {
		m_se->OnServerMessage(STD_STRING(err));
	}
}


//! @brief Send udp ping.
//! @note used for nat travelsal.

unsigned int TASServer::UdpPing(unsigned int src_port, const wxString &target, unsigned int target_port, const wxString &message)// full parameters version, used to ping all clients when hosting.
{
	int result=0;
	wxLogMessage(_T("UdpPing src_port=%d , target='%s' , target_port=%d , message='%s'"),src_port,target.c_str(),target_port, message.c_str());
	wxIPV4address local_addr;
	local_addr.AnyAddress(); // <--- THATS ESSENTIAL!
	local_addr.Service(src_port);

	wxDatagramSocket udp_socket(local_addr,/* wxSOCKET_WAITALL*/wxSOCKET_NONE);

	wxIPV4address wxaddr;
	wxaddr.Hostname(target);
	wxaddr.Service(target_port);

	if (udp_socket.IsOk()&&!udp_socket.Error()) {
		std::string m=STD_STRING(message);
		udp_socket.SendTo( wxaddr, m.c_str(), m.length() );
		wxIPV4address true_local_addr;
		if (udp_socket.GetLocal(true_local_addr)) {
			result=true_local_addr.Service();
		}
	} else {
		wxLogMessage(_T("socket's IsOk() is false, no UDP ping done."));
	}

	if (udp_socket.Error()) {
		wxLogWarning(_T("wxDatagramSocket Error=%d"),udp_socket.LastError());
	}
	return result;
}

void TASServer::UdpPingTheServer(const wxString &message)
{
	unsigned int port=UdpPing(m_udp_private_port,m_addr,m_nat_helper_port,message);
	if (port>0) {
		m_udp_private_port=port;
		m_se->OnMyInternalUdpSourcePort( m_udp_private_port );
	}
}


// copypasta from spring.cpp , to get users ordered same way as in tasclient.
struct UserOrder {
	int index;// user number for GetUser
	int order;// user order (we'll sort by it)
	bool operator<(UserOrder b) const { // comparison function for sorting
		return order<b.order;
	}
};


void TASServer::UdpPingAllClients()// used when hosting with nat holepunching. has some rudimentary support for fixed source ports.
{
	IBattle *battle=GetCurrentBattle();
	if (!battle)return;
	if (!battle->IsFounderMe())return;
	wxLogMessage(_T("UdpPingAllClients()"));

	// I'm gonna mimic tasclient's behavior.
	// It of course doesnt matter in which order pings are sent,
	// but when doing "fixed source ports", the port must be
	// FIRST_UDP_SOURCEPORT + index of user excluding myself
	// so users must be reindexed in same way as in tasclient
	// to get same source ports for pings.


	// copypasta from spring.cpp
	std::vector<UserOrder> ordered_users;


	for ( UserList::user_map_t::size_type i = 0; i < battle->GetNumUsers(); i++ ) {
		User &user=battle->GetUser(i);
		if (&user == &(battle->GetMe()))continue;// dont include myself (change in copypasta)

		UserOrder tmp;
		tmp.index=i;
		ordered_users.push_back(tmp);
	}
	std::sort(ordered_users.begin(),ordered_users.end());


	for (int i=0; i<int(ordered_users.size()); ++i) {
		User &user=battle->GetUser(ordered_users[i].index);

		wxString ip=TowxString(user.BattleStatus().ip);
		unsigned int port=user.BattleStatus().udpport;

		unsigned int src_port=m_udp_private_port;
		if ( battle->GetNatType() == NAT_Fixed_source_ports ) {
			port = FIRST_UDP_SOURCEPORT + i;
		}

		wxLogMessage(_T(" pinging nick=%s , ip=%s , port=%u"),user.GetNick().c_str(),ip.c_str(),port);

		if (port!=0 && !ip.empty()) {
			UdpPing(src_port,ip,port,_T("hai!"));
		}
	}
}


//! @brief used to check if the NAT is done properly when hosting
int TASServer::TestOpenPort( unsigned int port ) const
{
	wxIPV4address local_addr;
	local_addr.AnyAddress(); // <--- THATS ESSENTIAL!
	local_addr.Service(port);

	wxSocketServer udp_socket(local_addr, wxSOCKET_NONE);

	wxHTTP connect_to_server;
	connect_to_server.SetTimeout( 10 );

	if ( !connect_to_server.Connect( _T("zjt3.com") ) ) return porttest_unreachable;
	connect_to_server.GetInputStream(wxString::Format( _T("/porttest.php?port=%u"), port));

	if (udp_socket.IsOk()) {
		if ( !udp_socket.WaitForAccept( 10 ) ) return porttest_timeout;
	} else {
		wxLogMessage(_T("socket's IsOk() is false, no UDP packets can be checked"));
		return porttest_socketNotOk;
	}
	if (udp_socket.Error()) {
		wxLogMessage(_T("Error=%d"),udp_socket.LastError());
		return porttest_socketError;
	}
	return porttest_pass;
}

wxArrayString TASServer::GetRelayHostList()
{
	if ( UserExists( _T("RelayHostManagerList") ) ) SayPrivate( _T("RelayHostManagerList"), _T("!lm") );
	wxArrayString ret;
	for ( unsigned int i = 0; i < m_relay_host_manager_list.GetCount(); i++ ) {
		try {
			User& manager = GetUser( m_relay_host_manager_list[i] );
			if ( manager.Status().in_game ) continue; // skip the manager is not connected or reports it's ingame ( no slots available ), or it's away ( functionality disabled )
			if ( manager.Status().away ) continue;
			ret.Add( m_relay_host_manager_list[i] );
		} catch(...) {}
	}
	return ret;
}

////////////////////////
// Utility functions
//////////////////////

int ConvUserStatus(const UserStatus& us)
{
	int taus = 0;
	taus += (us.in_game   ? 1 : 0 );
	taus += (us.away      ? 1 : 0 ) << 1;
	taus += (us.rank      % 16    ) << 2;
	taus += (us.moderator ? 1 : 0 ) << 5;
	taus += (us.bot       ? 1 : 0 ) << 6;
	return taus;
}


UserStatus ConvTasclientstatus( const int tas )
{
	//http://springrts.com/dl/LobbyProtocol/ProtocolDescription.html#MYSTATUS:client
	UserStatus stat;
	stat.in_game =   (tas >> 0) & 1;
	stat.away =      (tas >> 1) & 1;
	stat.rank = (UserStatus::RankContainer) ((tas >> 2) % 8);
	stat.moderator = (tas >> 5) & 1;
	stat.bot =       (tas >> 6) & 1;
	assert(ConvUserStatus(stat) == tas);
	return stat;
}

UserBattleStatus ConvTasbattlestatus( const int tas )
{
	UserBattleStatus stat;
	//http://springrts.com/dl/LobbyProtocol/ProtocolDescription.html#MYBATTLESTATUS:client
	stat.ready =      (tas >>  1)  &   1;
	stat.team =       (tas >>  2)  &  15;
	stat.ally =       (tas >>  6)  &  15;
	stat.spectator =  ((tas >> 10)  &   1) == 0;
	stat.handicap =  ((tas >> 11)  & 127) % 101;
	stat.sync =      ((tas >> 22)  &   3) %   3;
 	stat.side =       (tas >> 24)  &  15;
	assert(tas == ConvTasbattlestatus(stat));
	return stat;
}


int ConvTasbattlestatus( UserBattleStatus bs)
{
	int ret = 0; // b0 is reserved
	ret += (bs.ready ? 1:0) << 1; // b1
	ret += (bs.team % 16) << 2; //b2..b5
	ret += (bs.ally % 16) << 6; //b6..b9
	ret += (bs.spectator?0:1) << 10; //b10
	ret += (bs.handicap % 101) << 11; //b11..b17
	//b18..b21 reserverd
	ret += (bs.sync % 3) << 22; //b22..b23
	ret += (bs.side % 16) << 24; //b24..b27
	//b28..31 is unused
	return ret;
}


IBattle::StartType IntToStartType( int start )
{
	switch ( start ) {
	case 0:
		return IBattle::ST_Fixed;
	case 1:
		return IBattle::ST_Random;
	case 2:
		return IBattle::ST_Choose;
	default:
		ASSERT_EXCEPTION( false, _T("invalid value") );
	};
	return IBattle::ST_Fixed;
}


NatType IntToNatType( int nat )
{
	switch ( nat ) {
	case 0:
		return NAT_None;
	case 1:
		return NAT_Hole_punching;
	case 2:
		return NAT_Fixed_source_ports;
	default:
		ASSERT_EXCEPTION( false, _T("invalid value") );
	};
	return NAT_None;
}


IBattle::GameType IntToGameType( int gt )
{
	switch ( gt ) {
	case 0:
		return IBattle::GT_ComContinue;
	case 1:
		return IBattle::GT_ComEnds;
	case 2:
		return IBattle::GT_Lineage;
	default:
		ASSERT_EXCEPTION( false, _T("invalid value") );
	};
	return IBattle::GT_ComContinue;
}
