package test;

import java.util.*;

public class Main {

	private static void printTable(String caption, ArrayList<Double> numbers,
			ArrayList<Integer> colors, Integer[] sortOrder) {

		System.out.println(caption + "\nNo   Num   Color"
				+ "\n----------------");

		for (int i = 0; i < sortOrder.length; i++) {
			System.out.printf("%x    %f     %d\n", i,
					numbers.get(sortOrder[i]), colors.get(sortOrder[i]));

		}
	}

	public static void main(String[] args) {

		final ArrayList<Double> numbers = new ArrayList<Double>();
		numbers.add(1.0);
		numbers.add(4.0);
		numbers.add(3.0);
		numbers.add(4.0);
		numbers.add(2.0);
		numbers.add(6.0);

		ArrayList<Integer> colors = new ArrayList<Integer>();
		colors.add(0x50);
		colors.add(0x34);
		colors.add(0x00);
		colors.add(0xfe);
		colors.add(0xff);
		colors.add(0xff);
		Integer[] sortOrder = new Integer[numbers.size()];

		// Create index array.
		for (int i = 0; i < sortOrder.length; i++) {
			sortOrder[i] = i;
		}
		printTable("\nNot sorted", numbers, colors, sortOrder);

		Arrays.sort(sortOrder, new Comparator<Integer>() {
			public int compare(Integer a, Integer b) {
				return (numbers.get(b) > numbers.get(a)) ? 1 : -1;
			}
		});

		printTable("\nSorted by numbers", numbers, colors, sortOrder);

	}// END: main

}// END: Main
