#!/usr/bin/python3
import os
import sys
import argparse

sys.path.insert(0, '/usr/share/sploitscan/')

from sploitscan import main
from sploitscan import main, display_banner

if __name__ == "__main__":
    display_banner()
    parser = argparse.ArgumentParser(
        description="SploitScan: Fetch and display data from NVD and public exploits for given CVE IDs."
    )
    parser.add_argument(
        "cve_ids",
        type=str,
        nargs="+",
        help="Enter one or more CVE IDs to fetch data. Separate multiple CVE IDs with spaces. Format for each ID: CVE-YYYY-NNNNN (Example: CVE-2023-23397 CVE-2024-12345)",
    )
    parser.add_argument(
        "-e",
        "--export",
        choices=["json", "csv"],
        help="Optional: Export the results to a JSON or CSV file. Specify the format: 'json' or 'csv'.",
    )

    args = parser.parse_args()

    main(args.cve_ids, args.export)
