/* menu.c generated by valac 0.12.0, the Vala compiler
 * generated from menu.vala, do not modify */

/* Copyright (C) 2011 Red Hat, Inc.*/
/* This library is free software; you can redistribute it and/or*/
/* modify it under the terms of the GNU Lesser General Public*/
/* License as published by the Free Software Foundation; either*/
/* version 2.1 of the License, or (at your option) any later version.*/
/* This library is distributed in the hope that it will be useful,*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU*/
/* Lesser General Public License for more details.*/
/* You should have received a copy of the GNU Lesser General Public*/
/* License along with this library; if not, see <http://www.gnu.org/licenses/>.*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <spice/controller_prot.h>
#include <custom.h>


#define SPICE_CTRL_TYPE_MENU_ITEM (spice_ctrl_menu_item_get_type ())
#define SPICE_CTRL_MENU_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_CTRL_TYPE_MENU_ITEM, SpiceCtrlMenuItem))
#define SPICE_CTRL_MENU_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_CTRL_TYPE_MENU_ITEM, SpiceCtrlMenuItemClass))
#define SPICE_CTRL_IS_MENU_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_CTRL_TYPE_MENU_ITEM))
#define SPICE_CTRL_IS_MENU_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_CTRL_TYPE_MENU_ITEM))
#define SPICE_CTRL_MENU_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_CTRL_TYPE_MENU_ITEM, SpiceCtrlMenuItemClass))

typedef struct _SpiceCtrlMenuItem SpiceCtrlMenuItem;
typedef struct _SpiceCtrlMenuItemClass SpiceCtrlMenuItemClass;
typedef struct _SpiceCtrlMenuItemPrivate SpiceCtrlMenuItemPrivate;

#define SPICE_CTRL_TYPE_MENU (spice_ctrl_menu_get_type ())
#define SPICE_CTRL_MENU(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_CTRL_TYPE_MENU, SpiceCtrlMenu))
#define SPICE_CTRL_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_CTRL_TYPE_MENU, SpiceCtrlMenuClass))
#define SPICE_CTRL_IS_MENU(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_CTRL_TYPE_MENU))
#define SPICE_CTRL_IS_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_CTRL_TYPE_MENU))
#define SPICE_CTRL_MENU_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_CTRL_TYPE_MENU, SpiceCtrlMenuClass))

typedef struct _SpiceCtrlMenu SpiceCtrlMenu;
typedef struct _SpiceCtrlMenuClass SpiceCtrlMenuClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _SpiceCtrlMenuPrivate SpiceCtrlMenuPrivate;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _SpiceCtrlMenuItem {
	GObject parent_instance;
	SpiceCtrlMenuItemPrivate * priv;
	SpiceCtrlMenu* submenu;
	gint parent_id;
	gint id;
	gchar* text;
	gchar* accel;
	unsigned int flags;
};

struct _SpiceCtrlMenuItemClass {
	GObjectClass parent_class;
};

typedef enum  {
	SPICE_CTRL_ERROR_VALUE
} SpiceCtrlError;
#define SPICE_CTRL_ERROR spice_ctrl_error_quark ()
struct _SpiceCtrlMenu {
	GObject parent_instance;
	SpiceCtrlMenuPrivate * priv;
	GList* items;
};

struct _SpiceCtrlMenuClass {
	GObjectClass parent_class;
};


static gpointer spice_ctrl_menu_item_parent_class = NULL;
static gpointer spice_ctrl_menu_parent_class = NULL;

GType spice_ctrl_menu_item_get_type (void) G_GNUC_CONST;
GType spice_ctrl_menu_get_type (void) G_GNUC_CONST;
enum  {
	SPICE_CTRL_MENU_ITEM_DUMMY_PROPERTY
};
GQuark spice_ctrl_error_quark (void);
SpiceCtrlMenuItem* spice_ctrl_menu_item_new_from_string (const gchar* str, GError** error);
SpiceCtrlMenuItem* spice_ctrl_menu_item_construct_from_string (GType object_type, const gchar* str, GError** error);
SpiceCtrlMenu* spice_ctrl_menu_new (void);
SpiceCtrlMenu* spice_ctrl_menu_construct (GType object_type);
gchar* spice_ctrl_menu_item_to_string (SpiceCtrlMenuItem* self);
gchar* spice_ctrl_menu_to_string (SpiceCtrlMenu* self);
const gchar* spice_protocol_controller_menu_flags_to_string (unsigned int self);
static const char* _spice_protocol_controller_menu_flags_to_string (unsigned int value);
SpiceCtrlMenuItem* spice_ctrl_menu_item_new (void);
SpiceCtrlMenuItem* spice_ctrl_menu_item_construct (GType object_type);
static void spice_ctrl_menu_item_finalize (GObject* obj);
enum  {
	SPICE_CTRL_MENU_DUMMY_PROPERTY
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
SpiceCtrlMenu* spice_ctrl_menu_find_id (SpiceCtrlMenu* self, gint id);
SpiceCtrlMenu* spice_ctrl_menu_new_from_string (const gchar* str);
SpiceCtrlMenu* spice_ctrl_menu_construct_from_string (GType object_type, const gchar* str);
static void spice_ctrl_menu_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


SpiceCtrlMenuItem* spice_ctrl_menu_item_construct_from_string (GType object_type, const gchar* str, GError** error) {
	SpiceCtrlMenuItem * self = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_ = NULL;
	gchar** params;
	gint params_length1;
	gint _params_size_;
	gboolean _tmp2_;
	gint _tmp4_;
	gint _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_ = NULL;
	gchar** textaccel;
	gint textaccel_length1;
	gint _textaccel_size_;
	gchar* _tmp8_;
	gint _tmp10_;
	SpiceCtrlMenu* _tmp11_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (str != NULL, NULL);
	self = (SpiceCtrlMenuItem*) g_object_new (object_type, NULL);
	_tmp1_ = _tmp0_ = g_strsplit (str, CONTROLLER_MENU_PARAM_DELIMITER, 0);
	params = _tmp1_;
	params_length1 = _vala_array_length (_tmp0_);
	_params_size_ = _vala_array_length (_tmp0_);
	_tmp2_ = g_warn_if (params_length1 != 5);
	if (_tmp2_) {
		GError* _tmp3_ = NULL;
		_tmp3_ = g_error_new_literal (SPICE_CTRL_ERROR, SPICE_CTRL_ERROR_VALUE, "");
		_inner_error_ = _tmp3_;
		if (_inner_error_->domain == SPICE_CTRL_ERROR) {
			g_propagate_error (error, _inner_error_);
			params = (_vala_array_free (params, params_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (self);
			return NULL;
		} else {
			params = (_vala_array_free (params, params_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp4_ = atoi (params[0]);
	self->parent_id = _tmp4_;
	_tmp5_ = atoi (params[1]);
	self->id = _tmp5_;
	_tmp7_ = _tmp6_ = g_strsplit (params[2], "\t", 0);
	textaccel = _tmp7_;
	textaccel_length1 = _vala_array_length (_tmp6_);
	_textaccel_size_ = _vala_array_length (_tmp6_);
	_tmp8_ = g_strdup (textaccel[0]);
	_g_free0 (self->text);
	self->text = _tmp8_;
	if (textaccel_length1 > 1) {
		gchar* _tmp9_;
		_tmp9_ = g_strdup (textaccel[1]);
		_g_free0 (self->accel);
		self->accel = _tmp9_;
	}
	_tmp10_ = atoi (params[3]);
	self->flags = (unsigned int) _tmp10_;
	_tmp11_ = spice_ctrl_menu_new ();
	_g_object_unref0 (self->submenu);
	self->submenu = _tmp11_;
	textaccel = (_vala_array_free (textaccel, textaccel_length1, (GDestroyNotify) g_free), NULL);
	params = (_vala_array_free (params, params_length1, (GDestroyNotify) g_free), NULL);
	return self;
}


SpiceCtrlMenuItem* spice_ctrl_menu_item_new_from_string (const gchar* str, GError** error) {
	return spice_ctrl_menu_item_construct_from_string (SPICE_CTRL_TYPE_MENU_ITEM, str, error);
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static const char* _spice_protocol_controller_menu_flags_to_string (unsigned int value) {
	switch (value) {
		case CONTROLLER_MENU_FLAGS_SEPARATOR:
		return "CONTROLLER_MENU_FLAGS_SEPARATOR";
		case CONTROLLER_MENU_FLAGS_DISABLED:
		return "CONTROLLER_MENU_FLAGS_DISABLED";
		case CONTROLLER_MENU_FLAGS_POPUP:
		return "CONTROLLER_MENU_FLAGS_POPUP";
		case CONTROLLER_MENU_FLAGS_CHECKED:
		return "CONTROLLER_MENU_FLAGS_CHECKED";
		case CONTROLLER_MENU_FLAGS_GRAYED:
		return "CONTROLLER_MENU_FLAGS_GRAYED";
	}
	return NULL;
}


gchar* spice_ctrl_menu_item_to_string (SpiceCtrlMenuItem* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* sub;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	gchar* str;
	const gchar* _tmp9_ = NULL;
	gchar** _tmp10_;
	gchar** _tmp11_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = spice_ctrl_menu_to_string (self->submenu);
	sub = _tmp0_;
	_tmp1_ = g_strdup_printf ("%i", self->parent_id);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup_printf ("%i", self->id);
	_tmp4_ = _tmp3_;
	_tmp5_ = string_to_string (self->text);
	_tmp6_ = _spice_protocol_controller_menu_flags_to_string (self->flags);
	_tmp7_ = g_strconcat ("pid: ", _tmp2_, ", id: ", _tmp4_, ", text: \"", _tmp5_, "\", flags: ", _tmp6_, NULL);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	str = _tmp8_;
	_tmp9_ = string_to_string (sub);
	_tmp11_ = _tmp10_ = g_strsplit (_tmp9_, "\n", 0);
	{
		gchar** l_collection;
		int l_collection_length1;
		int l_it;
		l_collection = _tmp11_;
		l_collection_length1 = _vala_array_length (_tmp10_);
		for (l_it = 0; l_it < _vala_array_length (_tmp10_); l_it = l_it + 1) {
			gchar* _tmp12_;
			gchar* l;
			_tmp12_ = g_strdup (l_collection[l_it]);
			l = _tmp12_;
			{
				const gchar* _tmp13_ = NULL;
				gchar* _tmp14_ = NULL;
				gchar* _tmp15_;
				gchar* _tmp16_;
				if (g_strcmp0 (l, "") == 0) {
					_g_free0 (l);
					continue;
				}
				_tmp13_ = string_to_string (l);
				_tmp14_ = g_strconcat ("\n    ", _tmp13_, NULL);
				_tmp15_ = _tmp14_;
				_tmp16_ = g_strconcat (str, _tmp15_, NULL);
				_g_free0 (str);
				str = _tmp16_;
				_g_free0 (_tmp15_);
				_g_free0 (l);
			}
		}
		l_collection = (_vala_array_free (l_collection, l_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	result = str;
	_g_free0 (sub);
	return result;
}


SpiceCtrlMenuItem* spice_ctrl_menu_item_construct (GType object_type) {
	SpiceCtrlMenuItem * self = NULL;
	self = (SpiceCtrlMenuItem*) g_object_new (object_type, NULL);
	return self;
}


SpiceCtrlMenuItem* spice_ctrl_menu_item_new (void) {
	return spice_ctrl_menu_item_construct (SPICE_CTRL_TYPE_MENU_ITEM);
}


static void spice_ctrl_menu_item_class_init (SpiceCtrlMenuItemClass * klass) {
	spice_ctrl_menu_item_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = spice_ctrl_menu_item_finalize;
}


static void spice_ctrl_menu_item_instance_init (SpiceCtrlMenuItem * self) {
}


static void spice_ctrl_menu_item_finalize (GObject* obj) {
	SpiceCtrlMenuItem * self;
	self = SPICE_CTRL_MENU_ITEM (obj);
	_g_object_unref0 (self->submenu);
	_g_free0 (self->text);
	_g_free0 (self->accel);
	G_OBJECT_CLASS (spice_ctrl_menu_item_parent_class)->finalize (obj);
}


GType spice_ctrl_menu_item_get_type (void) {
	static volatile gsize spice_ctrl_menu_item_type_id__volatile = 0;
	if (g_once_init_enter (&spice_ctrl_menu_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SpiceCtrlMenuItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) spice_ctrl_menu_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SpiceCtrlMenuItem), 0, (GInstanceInitFunc) spice_ctrl_menu_item_instance_init, NULL };
		GType spice_ctrl_menu_item_type_id;
		spice_ctrl_menu_item_type_id = g_type_register_static (G_TYPE_OBJECT, "SpiceCtrlMenuItem", &g_define_type_info, 0);
		g_once_init_leave (&spice_ctrl_menu_item_type_id__volatile, spice_ctrl_menu_item_type_id);
	}
	return spice_ctrl_menu_item_type_id__volatile;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


SpiceCtrlMenu* spice_ctrl_menu_find_id (SpiceCtrlMenu* self, gint id) {
	SpiceCtrlMenu* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (id == 0) {
		SpiceCtrlMenu* _tmp0_;
		_tmp0_ = _g_object_ref0 (self);
		result = _tmp0_;
		return result;
	}
	{
		GList* item_collection;
		GList* item_it;
		item_collection = self->items;
		for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
			SpiceCtrlMenuItem* _tmp1_;
			SpiceCtrlMenuItem* item;
			_tmp1_ = _g_object_ref0 ((SpiceCtrlMenuItem*) item_it->data);
			item = _tmp1_;
			{
				SpiceCtrlMenu* _tmp3_ = NULL;
				SpiceCtrlMenu* menu;
				if (item->id == id) {
					SpiceCtrlMenu* _tmp2_;
					_tmp2_ = _g_object_ref0 (item->submenu);
					result = _tmp2_;
					_g_object_unref0 (item);
					return result;
				}
				_tmp3_ = spice_ctrl_menu_find_id (item->submenu, id);
				menu = _tmp3_;
				if (menu != NULL) {
					result = menu;
					_g_object_unref0 (item);
					return result;
				}
				_g_object_unref0 (menu);
				_g_object_unref0 (item);
			}
		}
	}
	result = NULL;
	return result;
}


SpiceCtrlMenu* spice_ctrl_menu_construct_from_string (GType object_type, const gchar* str) {
	SpiceCtrlMenu * self = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (str != NULL, NULL);
	self = (SpiceCtrlMenu*) g_object_new (object_type, NULL);
	_tmp1_ = _tmp0_ = g_strsplit (str, CONTROLLER_MENU_ITEM_DELIMITER, 0);
	{
		gchar** itemstr_collection;
		int itemstr_collection_length1;
		int itemstr_it;
		itemstr_collection = _tmp1_;
		itemstr_collection_length1 = _vala_array_length (_tmp0_);
		for (itemstr_it = 0; itemstr_it < _vala_array_length (_tmp0_); itemstr_it = itemstr_it + 1) {
			gchar* _tmp2_;
			gchar* itemstr;
			_tmp2_ = g_strdup (itemstr_collection[itemstr_it]);
			itemstr = _tmp2_;
			{
				gint _tmp3_;
				SpiceCtrlMenuItem* _tmp4_ = NULL;
				SpiceCtrlMenuItem* item;
				SpiceCtrlMenu* _tmp5_ = NULL;
				SpiceCtrlMenu* parent;
				SpiceCtrlMenuItem* _tmp7_;
				_tmp3_ = strlen (itemstr);
				if (_tmp3_ == 0) {
					_g_free0 (itemstr);
					continue;
				}
				_tmp4_ = spice_ctrl_menu_item_new_from_string (itemstr, &_inner_error_);
				item = _tmp4_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == SPICE_CTRL_ERROR) {
						goto __catch0_spice_ctrl_error;
					}
					_g_free0 (itemstr);
					itemstr_collection = (_vala_array_free (itemstr_collection, itemstr_collection_length1, (GDestroyNotify) g_free), NULL);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				_tmp5_ = spice_ctrl_menu_find_id (self, item->parent_id);
				parent = _tmp5_;
				if (parent == NULL) {
					GError* _tmp6_ = NULL;
					_tmp6_ = g_error_new_literal (SPICE_CTRL_ERROR, SPICE_CTRL_ERROR_VALUE, "Invalid parent menu id");
					_inner_error_ = _tmp6_;
					_g_object_unref0 (parent);
					_g_object_unref0 (item);
					if (_inner_error_->domain == SPICE_CTRL_ERROR) {
						goto __catch0_spice_ctrl_error;
					}
					_g_object_unref0 (parent);
					_g_object_unref0 (item);
					_g_free0 (itemstr);
					itemstr_collection = (_vala_array_free (itemstr_collection, itemstr_collection_length1, (GDestroyNotify) g_free), NULL);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				_tmp7_ = _g_object_ref0 (item);
				parent->items = g_list_append (parent->items, _tmp7_);
				_g_object_unref0 (parent);
				_g_object_unref0 (item);
				goto __finally0;
				__catch0_spice_ctrl_error:
				{
					GError * e;
					e = _inner_error_;
					_inner_error_ = NULL;
					g_warning ("menu.vala:89: %s", e->message);
					_g_error_free0 (e);
				}
				__finally0:
				if (_inner_error_ != NULL) {
					_g_free0 (itemstr);
					itemstr_collection = (_vala_array_free (itemstr_collection, itemstr_collection_length1, (GDestroyNotify) g_free), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				_g_free0 (itemstr);
			}
		}
		itemstr_collection = (_vala_array_free (itemstr_collection, itemstr_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	return self;
}


SpiceCtrlMenu* spice_ctrl_menu_new_from_string (const gchar* str) {
	return spice_ctrl_menu_construct_from_string (SPICE_CTRL_TYPE_MENU, str);
}


gchar* spice_ctrl_menu_to_string (SpiceCtrlMenu* self) {
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* str;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("");
	str = _tmp0_;
	{
		GList* i_collection;
		GList* i_it;
		i_collection = self->items;
		for (i_it = i_collection; i_it != NULL; i_it = i_it->next) {
			SpiceCtrlMenuItem* _tmp1_;
			SpiceCtrlMenuItem* i;
			_tmp1_ = _g_object_ref0 ((SpiceCtrlMenuItem*) i_it->data);
			i = _tmp1_;
			{
				gchar* _tmp2_ = NULL;
				gchar* _tmp3_;
				gchar* _tmp4_ = NULL;
				gchar* _tmp5_;
				gchar* _tmp6_;
				_tmp2_ = spice_ctrl_menu_item_to_string (i);
				_tmp3_ = _tmp2_;
				_tmp4_ = g_strconcat ("\n", _tmp3_, NULL);
				_tmp5_ = _tmp4_;
				_tmp6_ = g_strconcat (str, _tmp5_, NULL);
				_g_free0 (str);
				str = _tmp6_;
				_g_free0 (_tmp5_);
				_g_free0 (_tmp3_);
				_g_object_unref0 (i);
			}
		}
	}
	result = str;
	return result;
}


SpiceCtrlMenu* spice_ctrl_menu_construct (GType object_type) {
	SpiceCtrlMenu * self = NULL;
	self = (SpiceCtrlMenu*) g_object_new (object_type, NULL);
	return self;
}


SpiceCtrlMenu* spice_ctrl_menu_new (void) {
	return spice_ctrl_menu_construct (SPICE_CTRL_TYPE_MENU);
}


static void spice_ctrl_menu_class_init (SpiceCtrlMenuClass * klass) {
	spice_ctrl_menu_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = spice_ctrl_menu_finalize;
}


static void spice_ctrl_menu_instance_init (SpiceCtrlMenu * self) {
}


static void spice_ctrl_menu_finalize (GObject* obj) {
	SpiceCtrlMenu * self;
	self = SPICE_CTRL_MENU (obj);
	__g_list_free__g_object_unref0_0 (self->items);
	G_OBJECT_CLASS (spice_ctrl_menu_parent_class)->finalize (obj);
}


GType spice_ctrl_menu_get_type (void) {
	static volatile gsize spice_ctrl_menu_type_id__volatile = 0;
	if (g_once_init_enter (&spice_ctrl_menu_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SpiceCtrlMenuClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) spice_ctrl_menu_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SpiceCtrlMenu), 0, (GInstanceInitFunc) spice_ctrl_menu_instance_init, NULL };
		GType spice_ctrl_menu_type_id;
		spice_ctrl_menu_type_id = g_type_register_static (G_TYPE_OBJECT, "SpiceCtrlMenu", &g_define_type_info, 0);
		g_once_init_leave (&spice_ctrl_menu_type_id__volatile, spice_ctrl_menu_type_id);
	}
	return spice_ctrl_menu_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



