/* controller.c generated by valac 0.20.0, the Vala compiler
 * generated from controller.vala, do not modify */

/* Copyright (C) 2011 Red Hat, Inc.*/
/* This library is free software; you can redistribute it and/or*/
/* modify it under the terms of the GNU Lesser General Public*/
/* License as published by the Free Software Foundation; either*/
/* version 2.1 of the License, or (at your option) any later version.*/
/* This library is distributed in the hope that it will be useful,*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU*/
/* Lesser General Public License for more details.*/
/* You should have received a copy of the GNU Lesser General Public*/
/* License along with this library; if not, see <http://www.gnu.org/licenses/>.*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <spice/controller_prot.h>
#include <gio/gio.h>
#include <custom.h>
#include <spice-controller-listener.h>


#define SPICE_CTRL_TYPE_CONTROLLER (spice_ctrl_controller_get_type ())
#define SPICE_CTRL_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_CTRL_TYPE_CONTROLLER, SpiceCtrlController))
#define SPICE_CTRL_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_CTRL_TYPE_CONTROLLER, SpiceCtrlControllerClass))
#define SPICE_CTRL_IS_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_CTRL_TYPE_CONTROLLER))
#define SPICE_CTRL_IS_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_CTRL_TYPE_CONTROLLER))
#define SPICE_CTRL_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_CTRL_TYPE_CONTROLLER, SpiceCtrlControllerClass))

typedef struct _SpiceCtrlController SpiceCtrlController;
typedef struct _SpiceCtrlControllerClass SpiceCtrlControllerClass;
typedef struct _SpiceCtrlControllerPrivate SpiceCtrlControllerPrivate;

#define SPICE_CTRL_TYPE_MENU (spice_ctrl_menu_get_type ())
#define SPICE_CTRL_MENU(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_CTRL_TYPE_MENU, SpiceCtrlMenu))
#define SPICE_CTRL_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_CTRL_TYPE_MENU, SpiceCtrlMenuClass))
#define SPICE_CTRL_IS_MENU(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_CTRL_TYPE_MENU))
#define SPICE_CTRL_IS_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_CTRL_TYPE_MENU))
#define SPICE_CTRL_MENU_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_CTRL_TYPE_MENU, SpiceCtrlMenuClass))

typedef struct _SpiceCtrlMenu SpiceCtrlMenu;
typedef struct _SpiceCtrlMenuClass SpiceCtrlMenuClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _SpiceCtrlControllerSendMsgData SpiceCtrlControllerSendMsgData;
typedef struct _SpiceCtrlControllerHandleClientData SpiceCtrlControllerHandleClientData;
typedef struct _SpiceCtrlControllerListenData SpiceCtrlControllerListenData;

typedef enum  {
	SPICE_CTRL_ERROR_VALUE
} SpiceCtrlError;
#define SPICE_CTRL_ERROR spice_ctrl_error_quark ()
struct _SpiceCtrlController {
	GObject parent_instance;
	SpiceCtrlControllerPrivate * priv;
};

struct _SpiceCtrlControllerClass {
	GObjectClass parent_class;
};

struct _SpiceCtrlControllerPrivate {
	gchar* _host;
	guint32 _port;
	guint32 _sport;
	gchar* _password;
	unsigned int _display_flags;
	gchar* _tls_ciphers;
	gchar* _host_subject;
	gchar* _ca_file;
	gchar* _title;
	gchar* _hotkeys;
	gchar** _secure_channels;
	gint _secure_channels_length1;
	gint __secure_channels_size_;
	gchar** _disable_channels;
	gint _disable_channels_length1;
	gint __disable_channels_size_;
	SpiceCtrlMenu* _menu;
	gboolean _enable_smartcard;
	gboolean _send_cad;
	gchar** _disable_effects;
	gint _disable_effects_length1;
	gint __disable_effects_size_;
	guint32 _color_depth;
	gboolean _enable_usbredir;
	gboolean _enable_usb_autoshare;
	gchar* _usb_filter;
	gchar* _proxy;
	GIOStream* excl_connection;
	gint nclients;
	GList* clients;
};

struct _SpiceCtrlControllerSendMsgData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SpiceCtrlController* self;
	guint8* p;
	gint p_length1;
	gboolean result;
	GIOStream* _tmp0_;
	GIOStream* _tmp1_;
	GOutputStream* _tmp2_;
	GOutputStream* _tmp3_;
	guint8* _tmp4_;
	gint _tmp4__length1;
	guint8* _tmp5_;
	gint _tmp5__length1;
	GList* _tmp6_;
	GList* c_collection;
	GList* c_it;
	GIOStream* _tmp7_;
	GIOStream* c;
	GIOStream* _tmp8_;
	GOutputStream* _tmp9_;
	GOutputStream* _tmp10_;
	guint8* _tmp11_;
	gint _tmp11__length1;
	guint8* _tmp12_;
	gint _tmp12__length1;
	GError* e;
	GError* _tmp13_;
	const gchar* _tmp14_;
	GError * _inner_error_;
};

struct _SpiceCtrlControllerHandleClientData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SpiceCtrlController* self;
	GIOStream* c;
	gboolean excl;
	guint8* _tmp0_;
	guint8* p;
	gint p_length1;
	gint _p_size_;
	guint8* _tmp1_;
	gint _tmp1__length1;
	ControllerInit* init;
	GIOStream* _tmp2_;
	GInputStream* _tmp3_;
	GInputStream* _tmp4_;
	guint8* _tmp5_;
	gint _tmp5__length1;
	ControllerInit* _tmp6_;
	ControllerInitHeader _tmp7_;
	guint32 _tmp8_;
	gboolean _tmp9_;
	ControllerInit* _tmp10_;
	ControllerInitHeader _tmp11_;
	guint32 _tmp12_;
	gboolean _tmp13_;
	ControllerInit* _tmp14_;
	ControllerInitHeader _tmp15_;
	guint32 _tmp16_;
	gboolean _tmp17_;
	ControllerInit* _tmp18_;
	guint64 _tmp19_;
	gboolean _tmp20_;
	GIOStream* _tmp21_;
	gboolean _tmp22_;
	ControllerInit* _tmp23_;
	guint32 _tmp24_;
	gboolean _tmp25_;
	gint _tmp26_;
	gint _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	GIOStream* _tmp32_;
	GIOStream* _tmp33_;
	gboolean _tmp34_;
	gboolean _tmp35_;
	guint8* _tmp36_;
	guint8* t;
	gint t_length1;
	gint _t_size_;
	GIOStream* _tmp37_;
	GInputStream* _tmp38_;
	GInputStream* _tmp39_;
	guint8* _tmp40_;
	gint _tmp40__length1;
	guint8* _tmp41_;
	gint _tmp41__length1;
	ControllerMsg* msg;
	ControllerMsg* _tmp42_;
	guint32 _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	ControllerMsg* _tmp50_;
	guint32 _tmp51_;
	gchar* _tmp52_;
	gchar* _tmp53_;
	gchar* _tmp54_;
	gchar* _tmp55_;
	ControllerMsg* _tmp56_;
	guint32 _tmp57_;
	gboolean _tmp58_;
	ControllerMsg* _tmp59_;
	guint32 _tmp60_;
	ControllerMsg* _tmp61_;
	guint32 _tmp62_;
	gint _tmp63_;
	guint8* _tmp64_;
	gint _tmp64__length1;
	GIOStream* _tmp65_;
	GInputStream* _tmp66_;
	GInputStream* _tmp67_;
	guint8* _tmp68_;
	gint _tmp68__length1;
	ControllerMsg* _tmp69_;
	guint32 _tmp70_;
	ControllerMsg* _tmp71_;
	gboolean _tmp72_;
	GError * _inner_error_;
};

struct _SpiceCtrlControllerListenData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SpiceCtrlController* self;
	gchar* addr;
	const gchar* _tmp0_;
	GObject* _tmp1_;
	GObject* listener;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GObject* _tmp4_;
	GIOStream* _tmp5_;
	GIOStream* _tmp6_;
	GIOStream* c;
	gint _tmp7_;
	GIOStream* _tmp8_;
	GIOStream* _tmp9_;
	GIOStream* _tmp10_;
	GError* e;
	GError* _tmp11_;
	const gchar* _tmp12_;
	GIOStream* _tmp13_;
	GIOStream* _tmp14_;
	gint _tmp15_;
	GError * _inner_error_;
};


static gpointer spice_ctrl_controller_parent_class = NULL;

GQuark spice_ctrl_error_quark (void);
GType spice_ctrl_controller_get_type (void) G_GNUC_CONST;
GType spice_ctrl_menu_get_type (void) G_GNUC_CONST;
#define SPICE_CTRL_CONTROLLER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SPICE_CTRL_TYPE_CONTROLLER, SpiceCtrlControllerPrivate))
enum  {
	SPICE_CTRL_CONTROLLER_DUMMY_PROPERTY,
	SPICE_CTRL_CONTROLLER_HOST,
	SPICE_CTRL_CONTROLLER_PORT,
	SPICE_CTRL_CONTROLLER_SPORT,
	SPICE_CTRL_CONTROLLER_PASSWORD,
	SPICE_CTRL_CONTROLLER_DISPLAY_FLAGS,
	SPICE_CTRL_CONTROLLER_TLS_CIPHERS,
	SPICE_CTRL_CONTROLLER_HOST_SUBJECT,
	SPICE_CTRL_CONTROLLER_CA_FILE,
	SPICE_CTRL_CONTROLLER_TITLE,
	SPICE_CTRL_CONTROLLER_HOTKEYS,
	SPICE_CTRL_CONTROLLER_SECURE_CHANNELS,
	SPICE_CTRL_CONTROLLER_DISABLE_CHANNELS,
	SPICE_CTRL_CONTROLLER_MENU,
	SPICE_CTRL_CONTROLLER_ENABLE_SMARTCARD,
	SPICE_CTRL_CONTROLLER_SEND_CAD,
	SPICE_CTRL_CONTROLLER_DISABLE_EFFECTS,
	SPICE_CTRL_CONTROLLER_COLOR_DEPTH,
	SPICE_CTRL_CONTROLLER_ENABLE_USBREDIR,
	SPICE_CTRL_CONTROLLER_ENABLE_USB_AUTOSHARE,
	SPICE_CTRL_CONTROLLER_USB_FILTER,
	SPICE_CTRL_CONTROLLER_PROXY
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
void spice_ctrl_controller_menu_item_click_msg (SpiceCtrlController* self, gint32 item_id);
void spice_ctrl_controller_send_msg (SpiceCtrlController* self, guint8* p, int p_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
gboolean spice_ctrl_controller_send_msg_finish (SpiceCtrlController* self, GAsyncResult* _res_, GError** error);
static void spice_ctrl_controller_send_msg_data_free (gpointer _data);
static gboolean spice_ctrl_controller_send_msg_co (SpiceCtrlControllerSendMsgData* _data_);
void spice_ctrl_output_stream_write (GOutputStream* stream, guint8* buffer, int buffer_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
void spice_ctrl_output_stream_write_finish (GAsyncResult* _res_, GError** error);
static guint8* _vala_array_dup1 (guint8* self, int length);
static void spice_ctrl_controller_send_msg_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static guint8* _vala_array_dup2 (guint8* self, int length);
static gboolean spice_ctrl_controller_handle_message (SpiceCtrlController* self, ControllerMsg* msg);
static void spice_ctrl_controller_set_host (SpiceCtrlController* self, const gchar* value);
static void spice_ctrl_controller_set_port (SpiceCtrlController* self, guint32 value);
guint32 spice_ctrl_controller_get_port (SpiceCtrlController* self);
static void spice_ctrl_controller_set_sport (SpiceCtrlController* self, guint32 value);
guint32 spice_ctrl_controller_get_sport (SpiceCtrlController* self);
static void spice_ctrl_controller_set_password (SpiceCtrlController* self, const gchar* value);
static void spice_ctrl_controller_set_secure_channels (SpiceCtrlController* self, gchar** value, int value_length1);
static void spice_ctrl_controller_set_disable_channels (SpiceCtrlController* self, gchar** value, int value_length1);
static void spice_ctrl_controller_set_tls_ciphers (SpiceCtrlController* self, const gchar* value);
static void spice_ctrl_controller_set_ca_file (SpiceCtrlController* self, const gchar* value);
static void spice_ctrl_controller_set_host_subject (SpiceCtrlController* self, const gchar* value);
static void spice_ctrl_controller_set_display_flags (SpiceCtrlController* self, unsigned int value);
static void spice_ctrl_controller_set_title (SpiceCtrlController* self, const gchar* value);
static void spice_ctrl_controller_set_enable_smartcard (SpiceCtrlController* self, gboolean value);
SpiceCtrlMenu* spice_ctrl_menu_new_from_string (const gchar* str);
SpiceCtrlMenu* spice_ctrl_menu_construct_from_string (GType object_type, const gchar* str);
static void spice_ctrl_controller_set_menu (SpiceCtrlController* self, SpiceCtrlMenu* value);
static void spice_ctrl_controller_set_send_cad (SpiceCtrlController* self, gboolean value);
static void spice_ctrl_controller_set_hotkeys (SpiceCtrlController* self, const gchar* value);
static void spice_ctrl_controller_set_color_depth (SpiceCtrlController* self, guint32 value);
static void spice_ctrl_controller_set_disable_effects (SpiceCtrlController* self, gchar** value, int value_length1);
static void spice_ctrl_controller_set_enable_usbredir (SpiceCtrlController* self, gboolean value);
static void spice_ctrl_controller_set_enable_usb_autoshare (SpiceCtrlController* self, gboolean value);
static void spice_ctrl_controller_set_usb_filter (SpiceCtrlController* self, const gchar* value);
static void spice_ctrl_controller_set_proxy (SpiceCtrlController* self, const gchar* value);
static void spice_ctrl_controller_handle_client_data_free (gpointer _data);
static void spice_ctrl_controller_handle_client (SpiceCtrlController* self, GIOStream* c, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void spice_ctrl_controller_handle_client_finish (SpiceCtrlController* self, GAsyncResult* _res_, GError** error);
static gboolean spice_ctrl_controller_handle_client_co (SpiceCtrlControllerHandleClientData* _data_);
void spice_ctrl_input_stream_read (GInputStream* stream, guint8* buffer, int buffer_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
void spice_ctrl_input_stream_read_finish (GAsyncResult* _res_, GError** error);
static void spice_ctrl_controller_handle_client_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
SpiceCtrlController* spice_ctrl_controller_new (void);
SpiceCtrlController* spice_ctrl_controller_construct (GType object_type);
static void spice_ctrl_controller_listen_data_free (gpointer _data);
void spice_ctrl_controller_listen (SpiceCtrlController* self, const gchar* addr, GAsyncReadyCallback _callback_, gpointer _user_data_);
void spice_ctrl_controller_listen_finish (SpiceCtrlController* self, GAsyncResult* _res_, GError** error);
static gboolean spice_ctrl_controller_listen_co (SpiceCtrlControllerListenData* _data_);
static void spice_ctrl_controller_listen_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
const gchar* spice_ctrl_controller_get_host (SpiceCtrlController* self);
const gchar* spice_ctrl_controller_get_password (SpiceCtrlController* self);
unsigned int spice_ctrl_controller_get_display_flags (SpiceCtrlController* self);
const gchar* spice_ctrl_controller_get_tls_ciphers (SpiceCtrlController* self);
const gchar* spice_ctrl_controller_get_host_subject (SpiceCtrlController* self);
const gchar* spice_ctrl_controller_get_ca_file (SpiceCtrlController* self);
const gchar* spice_ctrl_controller_get_title (SpiceCtrlController* self);
const gchar* spice_ctrl_controller_get_hotkeys (SpiceCtrlController* self);
gchar** spice_ctrl_controller_get_secure_channels (SpiceCtrlController* self, int* result_length1);
static gchar** _vala_array_dup3 (gchar** self, int length);
gchar** spice_ctrl_controller_get_disable_channels (SpiceCtrlController* self, int* result_length1);
static gchar** _vala_array_dup4 (gchar** self, int length);
SpiceCtrlMenu* spice_ctrl_controller_get_menu (SpiceCtrlController* self);
gboolean spice_ctrl_controller_get_enable_smartcard (SpiceCtrlController* self);
gboolean spice_ctrl_controller_get_send_cad (SpiceCtrlController* self);
gchar** spice_ctrl_controller_get_disable_effects (SpiceCtrlController* self, int* result_length1);
static gchar** _vala_array_dup5 (gchar** self, int length);
guint32 spice_ctrl_controller_get_color_depth (SpiceCtrlController* self);
gboolean spice_ctrl_controller_get_enable_usbredir (SpiceCtrlController* self);
gboolean spice_ctrl_controller_get_enable_usb_autoshare (SpiceCtrlController* self);
const gchar* spice_ctrl_controller_get_usb_filter (SpiceCtrlController* self);
const gchar* spice_ctrl_controller_get_proxy (SpiceCtrlController* self);
static void spice_ctrl_controller_finalize (GObject* obj);
static void _vala_spice_ctrl_controller_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_spice_ctrl_controller_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GQuark spice_ctrl_error_quark (void) {
	return g_quark_from_static_string ("spice_ctrl_error-quark");
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


void spice_ctrl_controller_menu_item_click_msg (SpiceCtrlController* self, gint32 item_id) {
	ControllerValue msg = {0};
	gint32 _tmp0_;
	ControllerValue _tmp1_;
	ControllerMsg _tmp2_;
	guint32 _tmp3_;
	guint8* p;
	gint p_length1;
	gint _p_size_;
	g_return_if_fail (self != NULL);
	memset (&msg, 0, sizeof (ControllerValue));
	msg.base.size = (guint32) sizeof (ControllerValue);
	msg.base.id = (guint32) CONTROLLER_MENU_ITEM_CLICK;
	_tmp0_ = item_id;
	msg.value = (guint32) _tmp0_;
	_tmp1_ = msg;
	_tmp2_ = _tmp1_.base;
	_tmp3_ = _tmp2_.size;
	p = ((guint8*) (&msg)) + 0;
	p_length1 = _tmp3_ - 0;
	_p_size_ = p_length1;
	spice_ctrl_controller_send_msg (self, p, p_length1, NULL, NULL);
}


static void spice_ctrl_controller_send_msg_data_free (gpointer _data) {
	SpiceCtrlControllerSendMsgData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SpiceCtrlControllerSendMsgData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void spice_ctrl_controller_send_msg (SpiceCtrlController* self, guint8* p, int p_length1, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SpiceCtrlControllerSendMsgData* _data_;
	SpiceCtrlController* _tmp0_;
	guint8* _tmp1_;
	gint _tmp1__length1;
	_data_ = g_slice_new0 (SpiceCtrlControllerSendMsgData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, spice_ctrl_controller_send_msg);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, spice_ctrl_controller_send_msg_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = p;
	_tmp1__length1 = p_length1;
	_data_->p = _tmp1_;
	_data_->p_length1 = _tmp1__length1;
	spice_ctrl_controller_send_msg_co (_data_);
}


gboolean spice_ctrl_controller_send_msg_finish (SpiceCtrlController* self, GAsyncResult* _res_, GError** error) {
	gboolean result;
	SpiceCtrlControllerSendMsgData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return FALSE;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static guint8* _vala_array_dup1 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


static void spice_ctrl_controller_send_msg_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SpiceCtrlControllerSendMsgData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	spice_ctrl_controller_send_msg_co (_data_);
}


static guint8* _vala_array_dup2 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


static gboolean spice_ctrl_controller_send_msg_co (SpiceCtrlControllerSendMsgData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = _data_->self->priv->excl_connection;
		if (_data_->_tmp0_ != NULL) {
			_data_->_tmp1_ = _data_->self->priv->excl_connection;
			_data_->_tmp2_ = g_io_stream_get_output_stream (_data_->_tmp1_);
			_data_->_tmp3_ = _data_->_tmp2_;
			_data_->_tmp4_ = _data_->p;
			_data_->_tmp4__length1 = _data_->p_length1;
			_data_->_tmp5_ = (_data_->_tmp4_ != NULL) ? _vala_array_dup1 (_data_->_tmp4_, _data_->_tmp4__length1) : ((gpointer) _data_->_tmp4_);
			_data_->_tmp5__length1 = _data_->_tmp4__length1;
			_data_->_state_ = 1;
			spice_ctrl_output_stream_write (_data_->_tmp3_, _data_->_tmp5_, _data_->_tmp5__length1, spice_ctrl_controller_send_msg_ready, _data_);
			return FALSE;
			_state_1:
			spice_ctrl_output_stream_write_finish (_data_->_res_, &_data_->_inner_error_);
			if (_data_->_inner_error_ != NULL) {
				goto __catch1_g_error;
			}
		} else {
			_data_->_tmp6_ = _data_->self->priv->clients;
			{
				_data_->c_collection = _data_->_tmp6_;
				for (_data_->c_it = _data_->c_collection; _data_->c_it != NULL; _data_->c_it = _data_->c_it->next) {
					_data_->_tmp7_ = _g_object_ref0 ((GIOStream*) _data_->c_it->data);
					_data_->c = _data_->_tmp7_;
					{
						_data_->_tmp8_ = _data_->c;
						_data_->_tmp9_ = g_io_stream_get_output_stream (_data_->_tmp8_);
						_data_->_tmp10_ = _data_->_tmp9_;
						_data_->_tmp11_ = _data_->p;
						_data_->_tmp11__length1 = _data_->p_length1;
						_data_->_tmp12_ = (_data_->_tmp11_ != NULL) ? _vala_array_dup2 (_data_->_tmp11_, _data_->_tmp11__length1) : ((gpointer) _data_->_tmp11_);
						_data_->_tmp12__length1 = _data_->_tmp11__length1;
						_data_->_state_ = 2;
						spice_ctrl_output_stream_write (_data_->_tmp10_, _data_->_tmp12_, _data_->_tmp12__length1, spice_ctrl_controller_send_msg_ready, _data_);
						return FALSE;
						_state_2:
						spice_ctrl_output_stream_write_finish (_data_->_res_, &_data_->_inner_error_);
						if (_data_->_inner_error_ != NULL) {
							_g_object_unref0 (_data_->c);
							goto __catch1_g_error;
						}
						_g_object_unref0 (_data_->c);
					}
				}
			}
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp13_ = _data_->e;
		_data_->_tmp14_ = _data_->_tmp13_->message;
		g_warning ("controller.vala:79: %s", _data_->_tmp14_);
		_g_error_free0 (_data_->e);
	}
	__finally1:
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = TRUE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gboolean spice_ctrl_controller_handle_message (SpiceCtrlController* self, ControllerMsg* msg) {
	gboolean result = FALSE;
	ControllerMsg* _tmp0_;
	ControllerValue* v;
	ControllerMsg* _tmp1_;
	ControllerData* d;
	ControllerData* _tmp2_;
	const gchar* str;
	ControllerMsg* _tmp3_;
	guint32 _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = msg;
	v = (ControllerValue*) _tmp0_;
	_tmp1_ = msg;
	d = (ControllerData*) _tmp1_;
	_tmp2_ = d;
	str = (const gchar*) (&(*_tmp2_).data);
	_tmp3_ = msg;
	_tmp4_ = (*_tmp3_).id;
	switch (_tmp4_) {
		case CONTROLLER_HOST:
		{
			const gchar* _tmp5_;
			const gchar* _tmp6_;
			gchar* _tmp7_ = NULL;
			gchar* _tmp8_;
			_tmp5_ = str;
			spice_ctrl_controller_set_host (self, _tmp5_);
			_tmp6_ = str;
			_tmp7_ = g_strdup_printf ("got HOST: %s", _tmp6_);
			_tmp8_ = _tmp7_;
			g_debug ("controller.vala:97: %s", _tmp8_);
			_g_free0 (_tmp8_);
			break;
		}
		case CONTROLLER_PORT:
		{
			ControllerValue* _tmp9_;
			guint32 _tmp10_;
			guint32 _tmp11_;
			gchar* _tmp12_ = NULL;
			gchar* _tmp13_;
			_tmp9_ = v;
			_tmp10_ = (*_tmp9_).value;
			spice_ctrl_controller_set_port (self, _tmp10_);
			_tmp11_ = self->priv->_port;
			_tmp12_ = g_strdup_printf ("got PORT: %u", (guint) _tmp11_);
			_tmp13_ = _tmp12_;
			g_debug ("controller.vala:101: %s", _tmp13_);
			_g_free0 (_tmp13_);
			break;
		}
		case CONTROLLER_SPORT:
		{
			ControllerValue* _tmp14_;
			guint32 _tmp15_;
			guint32 _tmp16_;
			gchar* _tmp17_ = NULL;
			gchar* _tmp18_;
			_tmp14_ = v;
			_tmp15_ = (*_tmp14_).value;
			spice_ctrl_controller_set_sport (self, _tmp15_);
			_tmp16_ = self->priv->_sport;
			_tmp17_ = g_strdup_printf ("got SPORT: %u", (guint) _tmp16_);
			_tmp18_ = _tmp17_;
			g_debug ("controller.vala:105: %s", _tmp18_);
			_g_free0 (_tmp18_);
			break;
		}
		case CONTROLLER_PASSWORD:
		{
			const gchar* _tmp19_;
			_tmp19_ = str;
			spice_ctrl_controller_set_password (self, _tmp19_);
			g_debug ("controller.vala:109: got PASSWORD");
			break;
		}
		case CONTROLLER_SECURE_CHANNELS:
		{
			const gchar* _tmp20_;
			gchar** _tmp21_;
			gchar** _tmp22_ = NULL;
			gchar** _tmp23_;
			gint _tmp23__length1;
			const gchar* _tmp24_;
			gchar* _tmp25_ = NULL;
			gchar* _tmp26_;
			_tmp20_ = str;
			_tmp22_ = _tmp21_ = g_strsplit (_tmp20_, ",", 0);
			_tmp23_ = _tmp22_;
			_tmp23__length1 = _vala_array_length (_tmp21_);
			spice_ctrl_controller_set_secure_channels (self, _tmp23_, _vala_array_length (_tmp21_));
			_tmp23_ = (_vala_array_free (_tmp23_, _tmp23__length1, (GDestroyNotify) g_free), NULL);
			_tmp24_ = str;
			_tmp25_ = g_strdup_printf ("got SECURE_CHANNELS %s", _tmp24_);
			_tmp26_ = _tmp25_;
			g_debug ("controller.vala:114: %s", _tmp26_);
			_g_free0 (_tmp26_);
			break;
		}
		case CONTROLLER_DISABLE_CHANNELS:
		{
			const gchar* _tmp27_;
			gchar** _tmp28_;
			gchar** _tmp29_ = NULL;
			gchar** _tmp30_;
			gint _tmp30__length1;
			const gchar* _tmp31_;
			gchar* _tmp32_ = NULL;
			gchar* _tmp33_;
			_tmp27_ = str;
			_tmp29_ = _tmp28_ = g_strsplit (_tmp27_, ",", 0);
			_tmp30_ = _tmp29_;
			_tmp30__length1 = _vala_array_length (_tmp28_);
			spice_ctrl_controller_set_disable_channels (self, _tmp30_, _vala_array_length (_tmp28_));
			_tmp30_ = (_vala_array_free (_tmp30_, _tmp30__length1, (GDestroyNotify) g_free), NULL);
			_tmp31_ = str;
			_tmp32_ = g_strdup_printf ("got DISABLE_CHANNELS %s", _tmp31_);
			_tmp33_ = _tmp32_;
			g_debug ("controller.vala:119: %s", _tmp33_);
			_g_free0 (_tmp33_);
			break;
		}
		case CONTROLLER_TLS_CIPHERS:
		{
			const gchar* _tmp34_;
			const gchar* _tmp35_;
			gchar* _tmp36_ = NULL;
			gchar* _tmp37_;
			_tmp34_ = str;
			spice_ctrl_controller_set_tls_ciphers (self, _tmp34_);
			_tmp35_ = str;
			_tmp36_ = g_strdup_printf ("got TLS_CIPHERS %s", _tmp35_);
			_tmp37_ = _tmp36_;
			g_debug ("controller.vala:124: %s", _tmp37_);
			_g_free0 (_tmp37_);
			break;
		}
		case CONTROLLER_CA_FILE:
		{
			const gchar* _tmp38_;
			const gchar* _tmp39_;
			gchar* _tmp40_ = NULL;
			gchar* _tmp41_;
			_tmp38_ = str;
			spice_ctrl_controller_set_ca_file (self, _tmp38_);
			_tmp39_ = str;
			_tmp40_ = g_strdup_printf ("got CA_FILE %s", _tmp39_);
			_tmp41_ = _tmp40_;
			g_debug ("controller.vala:128: %s", _tmp41_);
			_g_free0 (_tmp41_);
			break;
		}
		case CONTROLLER_HOST_SUBJECT:
		{
			const gchar* _tmp42_;
			const gchar* _tmp43_;
			gchar* _tmp44_ = NULL;
			gchar* _tmp45_;
			_tmp42_ = str;
			spice_ctrl_controller_set_host_subject (self, _tmp42_);
			_tmp43_ = str;
			_tmp44_ = g_strdup_printf ("got HOST_SUBJECT %s", _tmp43_);
			_tmp45_ = _tmp44_;
			g_debug ("controller.vala:132: %s", _tmp45_);
			_g_free0 (_tmp45_);
			break;
		}
		case CONTROLLER_FULL_SCREEN:
		{
			ControllerValue* _tmp46_;
			guint32 _tmp47_;
			ControllerValue* _tmp48_;
			guint32 _tmp49_;
			gchar* _tmp50_ = NULL;
			gchar* _tmp51_;
			_tmp46_ = v;
			_tmp47_ = (*_tmp46_).value;
			spice_ctrl_controller_set_display_flags (self, (unsigned int) _tmp47_);
			_tmp48_ = v;
			_tmp49_ = (*_tmp48_).value;
			_tmp50_ = g_strdup_printf ("got FULL_SCREEN 0x%x", (guint) _tmp49_);
			_tmp51_ = _tmp50_;
			g_debug ("controller.vala:137: %s", _tmp51_);
			_g_free0 (_tmp51_);
			break;
		}
		case CONTROLLER_SET_TITLE:
		{
			const gchar* _tmp52_;
			const gchar* _tmp53_;
			gchar* _tmp54_ = NULL;
			gchar* _tmp55_;
			_tmp52_ = str;
			spice_ctrl_controller_set_title (self, _tmp52_);
			_tmp53_ = str;
			_tmp54_ = g_strdup_printf ("got TITLE %s", _tmp53_);
			_tmp55_ = _tmp54_;
			g_debug ("controller.vala:141: %s", _tmp55_);
			_g_free0 (_tmp55_);
			break;
		}
		case CONTROLLER_ENABLE_SMARTCARD:
		{
			ControllerValue* _tmp56_;
			guint32 _tmp57_;
			ControllerValue* _tmp58_;
			guint32 _tmp59_;
			gchar* _tmp60_ = NULL;
			gchar* _tmp61_;
			_tmp56_ = v;
			_tmp57_ = (*_tmp56_).value;
			spice_ctrl_controller_set_enable_smartcard (self, (gboolean) _tmp57_);
			_tmp58_ = v;
			_tmp59_ = (*_tmp58_).value;
			_tmp60_ = g_strdup_printf ("got ENABLE_SMARTCARD 0x%x", (guint) _tmp59_);
			_tmp61_ = _tmp60_;
			g_debug ("controller.vala:145: %s", _tmp61_);
			_g_free0 (_tmp61_);
			break;
		}
		case CONTROLLER_CREATE_MENU:
		{
			const gchar* _tmp62_;
			SpiceCtrlMenu* _tmp63_;
			SpiceCtrlMenu* _tmp64_;
			const gchar* _tmp65_;
			gchar* _tmp66_ = NULL;
			gchar* _tmp67_;
			_tmp62_ = str;
			_tmp63_ = spice_ctrl_menu_new_from_string (_tmp62_);
			_tmp64_ = _tmp63_;
			spice_ctrl_controller_set_menu (self, _tmp64_);
			_g_object_unref0 (_tmp64_);
			_tmp65_ = str;
			_tmp66_ = g_strdup_printf ("got CREATE_MENU %s", _tmp65_);
			_tmp67_ = _tmp66_;
			g_debug ("controller.vala:150: %s", _tmp67_);
			_g_free0 (_tmp67_);
			break;
		}
		case CONTROLLER_DELETE_MENU:
		{
			spice_ctrl_controller_set_menu (self, NULL);
			g_debug ("controller.vala:154: got DELETE_MENU request");
			break;
		}
		case CONTROLLER_SEND_CAD:
		{
			ControllerValue* _tmp68_;
			guint32 _tmp69_;
			ControllerValue* _tmp70_;
			guint32 _tmp71_;
			gchar* _tmp72_ = NULL;
			gchar* _tmp73_;
			_tmp68_ = v;
			_tmp69_ = (*_tmp68_).value;
			spice_ctrl_controller_set_send_cad (self, (gboolean) _tmp69_);
			_tmp70_ = v;
			_tmp71_ = (*_tmp70_).value;
			_tmp72_ = g_strdup_printf ("got SEND_CAD %u", (guint) _tmp71_);
			_tmp73_ = _tmp72_;
			g_debug ("controller.vala:159: %s", _tmp73_);
			_g_free0 (_tmp73_);
			break;
		}
		case CONTROLLER_HOTKEYS:
		{
			const gchar* _tmp74_;
			const gchar* _tmp75_;
			gchar* _tmp76_ = NULL;
			gchar* _tmp77_;
			_tmp74_ = str;
			spice_ctrl_controller_set_hotkeys (self, _tmp74_);
			_tmp75_ = str;
			_tmp76_ = g_strdup_printf ("got HOTKEYS %s", _tmp75_);
			_tmp77_ = _tmp76_;
			g_debug ("controller.vala:164: %s", _tmp77_);
			_g_free0 (_tmp77_);
			break;
		}
		case CONTROLLER_COLOR_DEPTH:
		{
			ControllerValue* _tmp78_;
			guint32 _tmp79_;
			ControllerValue* _tmp80_;
			guint32 _tmp81_;
			gchar* _tmp82_ = NULL;
			gchar* _tmp83_;
			_tmp78_ = v;
			_tmp79_ = (*_tmp78_).value;
			spice_ctrl_controller_set_color_depth (self, _tmp79_);
			_tmp80_ = v;
			_tmp81_ = (*_tmp80_).value;
			_tmp82_ = g_strdup_printf ("got COLOR_DEPTH %u", (guint) _tmp81_);
			_tmp83_ = _tmp82_;
			g_debug ("controller.vala:169: %s", _tmp83_);
			_g_free0 (_tmp83_);
			break;
		}
		case CONTROLLER_DISABLE_EFFECTS:
		{
			const gchar* _tmp84_;
			gchar** _tmp85_;
			gchar** _tmp86_ = NULL;
			gchar** _tmp87_;
			gint _tmp87__length1;
			const gchar* _tmp88_;
			gchar* _tmp89_ = NULL;
			gchar* _tmp90_;
			_tmp84_ = str;
			_tmp86_ = _tmp85_ = g_strsplit (_tmp84_, ",", 0);
			_tmp87_ = _tmp86_;
			_tmp87__length1 = _vala_array_length (_tmp85_);
			spice_ctrl_controller_set_disable_effects (self, _tmp87_, _vala_array_length (_tmp85_));
			_tmp87_ = (_vala_array_free (_tmp87_, _tmp87__length1, (GDestroyNotify) g_free), NULL);
			_tmp88_ = str;
			_tmp89_ = g_strdup_printf ("got DISABLE_EFFECTS %s", _tmp88_);
			_tmp90_ = _tmp89_;
			g_debug ("controller.vala:173: %s", _tmp90_);
			_g_free0 (_tmp90_);
			break;
		}
		case CONTROLLER_CONNECT:
		{
			g_signal_emit_by_name (self, "do-connect");
			g_debug ("controller.vala:178: got CONNECT request");
			break;
		}
		case CONTROLLER_SHOW:
		{
			g_signal_emit_by_name (self, "show");
			g_debug ("controller.vala:182: got SHOW request");
			break;
		}
		case CONTROLLER_HIDE:
		{
			g_signal_emit_by_name (self, "hide");
			g_debug ("controller.vala:186: got HIDE request");
			break;
		}
		case CONTROLLER_ENABLE_USB:
		{
			ControllerValue* _tmp91_;
			guint32 _tmp92_;
			ControllerValue* _tmp93_;
			guint32 _tmp94_;
			gchar* _tmp95_ = NULL;
			gchar* _tmp96_;
			_tmp91_ = v;
			_tmp92_ = (*_tmp91_).value;
			spice_ctrl_controller_set_enable_usbredir (self, (gboolean) _tmp92_);
			_tmp93_ = v;
			_tmp94_ = (*_tmp93_).value;
			_tmp95_ = g_strdup_printf ("got ENABLE_USB %u", (guint) _tmp94_);
			_tmp96_ = _tmp95_;
			g_debug ("controller.vala:190: %s", _tmp96_);
			_g_free0 (_tmp96_);
			break;
		}
		case CONTROLLER_ENABLE_USB_AUTOSHARE:
		{
			ControllerValue* _tmp97_;
			guint32 _tmp98_;
			ControllerValue* _tmp99_;
			guint32 _tmp100_;
			gchar* _tmp101_ = NULL;
			gchar* _tmp102_;
			_tmp97_ = v;
			_tmp98_ = (*_tmp97_).value;
			spice_ctrl_controller_set_enable_usb_autoshare (self, (gboolean) _tmp98_);
			_tmp99_ = v;
			_tmp100_ = (*_tmp99_).value;
			_tmp101_ = g_strdup_printf ("got ENABLE_USB_AUTOSHARE %u", (guint) _tmp100_);
			_tmp102_ = _tmp101_;
			g_debug ("controller.vala:194: %s", _tmp102_);
			_g_free0 (_tmp102_);
			break;
		}
		case CONTROLLER_USB_FILTER:
		{
			const gchar* _tmp103_;
			const gchar* _tmp104_;
			gchar* _tmp105_ = NULL;
			gchar* _tmp106_;
			_tmp103_ = str;
			spice_ctrl_controller_set_usb_filter (self, _tmp103_);
			_tmp104_ = str;
			_tmp105_ = g_strdup_printf ("got USB_FILTER %s", _tmp104_);
			_tmp106_ = _tmp105_;
			g_debug ("controller.vala:198: %s", _tmp106_);
			_g_free0 (_tmp106_);
			break;
		}
		case CONTROLLER_PROXY:
		{
			const gchar* _tmp107_;
			const gchar* _tmp108_;
			gchar* _tmp109_ = NULL;
			gchar* _tmp110_;
			_tmp107_ = str;
			spice_ctrl_controller_set_proxy (self, _tmp107_);
			_tmp108_ = str;
			_tmp109_ = g_strdup_printf ("got PROXY %s", _tmp108_);
			_tmp110_ = _tmp109_;
			g_debug ("controller.vala:202: %s", _tmp110_);
			_g_free0 (_tmp110_);
			break;
		}
		default:
		{
			ControllerMsg* _tmp111_;
			guint32 _tmp112_;
			gchar* _tmp113_ = NULL;
			gchar* _tmp114_;
			_tmp111_ = msg;
			_tmp112_ = (*_tmp111_).id;
			_tmp113_ = g_strdup_printf ("got unknown msg.id %u", (guint) _tmp112_);
			_tmp114_ = _tmp113_;
			g_debug ("controller.vala:205: %s", _tmp114_);
			_g_free0 (_tmp114_);
			g_warn_if_reached ();
			result = FALSE;
			return result;
		}
	}
	result = TRUE;
	return result;
}


static void spice_ctrl_controller_handle_client_data_free (gpointer _data) {
	SpiceCtrlControllerHandleClientData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->c);
	_g_object_unref0 (_data_->self);
	g_slice_free (SpiceCtrlControllerHandleClientData, _data_);
}


static void spice_ctrl_controller_handle_client (SpiceCtrlController* self, GIOStream* c, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SpiceCtrlControllerHandleClientData* _data_;
	SpiceCtrlController* _tmp0_;
	GIOStream* _tmp1_;
	GIOStream* _tmp2_;
	_data_ = g_slice_new0 (SpiceCtrlControllerHandleClientData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, spice_ctrl_controller_handle_client);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, spice_ctrl_controller_handle_client_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = c;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->c);
	_data_->c = _tmp2_;
	spice_ctrl_controller_handle_client_co (_data_);
}


static void spice_ctrl_controller_handle_client_finish (SpiceCtrlController* self, GAsyncResult* _res_, GError** error) {
	SpiceCtrlControllerHandleClientData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void spice_ctrl_controller_handle_client_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SpiceCtrlControllerHandleClientData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	spice_ctrl_controller_handle_client_co (_data_);
}


static gboolean spice_ctrl_controller_handle_client_co (SpiceCtrlControllerHandleClientData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->excl = FALSE;
	g_debug ("controller.vala:215: new socket client, reading init header");
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = g_new0 (guint8, sizeof (ControllerInit));
	_data_->p = _data_->_tmp0_;
	_data_->p_length1 = sizeof (ControllerInit);
	_data_->_p_size_ = _data_->p_length1;
	_data_->_tmp1_ = _data_->p;
	_data_->_tmp1__length1 = _data_->p_length1;
	_data_->init = (ControllerInit*) _data_->_tmp1_;
	_data_->_tmp2_ = _data_->c;
	_data_->_tmp3_ = g_io_stream_get_input_stream (_data_->_tmp2_);
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp5_ = _data_->p;
	_data_->_tmp5__length1 = _data_->p_length1;
	_data_->_state_ = 1;
	spice_ctrl_input_stream_read (_data_->_tmp4_, _data_->_tmp5_, _data_->_tmp5__length1, spice_ctrl_controller_handle_client_ready, _data_);
	return FALSE;
	_state_1:
	spice_ctrl_input_stream_read_finish (_data_->_res_, &_data_->_inner_error_);
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_data_->p = (g_free (_data_->p), NULL);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp6_ = _data_->init;
	_data_->_tmp7_ = (*_data_->_tmp6_).base;
	_data_->_tmp8_ = _data_->_tmp7_.magic;
	_data_->_tmp9_ = FALSE;
	_data_->_tmp9_ = g_warn_if (_data_->_tmp8_ != CONTROLLER_MAGIC);
	if (_data_->_tmp9_) {
		_data_->p = (g_free (_data_->p), NULL);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp10_ = _data_->init;
	_data_->_tmp11_ = (*_data_->_tmp10_).base;
	_data_->_tmp12_ = _data_->_tmp11_.version;
	_data_->_tmp13_ = FALSE;
	_data_->_tmp13_ = g_warn_if (_data_->_tmp12_ != ((guint32) CONTROLLER_VERSION));
	if (_data_->_tmp13_) {
		_data_->p = (g_free (_data_->p), NULL);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp14_ = _data_->init;
	_data_->_tmp15_ = (*_data_->_tmp14_).base;
	_data_->_tmp16_ = _data_->_tmp15_.size;
	_data_->_tmp17_ = FALSE;
	_data_->_tmp17_ = g_warn_if (((gulong) _data_->_tmp16_) < sizeof (ControllerInit));
	if (_data_->_tmp17_) {
		_data_->p = (g_free (_data_->p), NULL);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp18_ = _data_->init;
	_data_->_tmp19_ = (*_data_->_tmp18_).credentials;
	_data_->_tmp20_ = FALSE;
	_data_->_tmp20_ = g_warn_if (_data_->_tmp19_ != ((guint64) 0));
	if (_data_->_tmp20_) {
		_data_->p = (g_free (_data_->p), NULL);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp21_ = _data_->self->priv->excl_connection;
	_data_->_tmp22_ = FALSE;
	_data_->_tmp22_ = g_warn_if (_data_->_tmp21_ != NULL);
	if (_data_->_tmp22_) {
		_data_->p = (g_free (_data_->p), NULL);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp23_ = _data_->init;
	_data_->_tmp24_ = (*_data_->_tmp23_).flags;
	_data_->excl = (gboolean) (_data_->_tmp24_ & CONTROLLER_FLAG_EXCLUSIVE);
	_data_->_tmp25_ = _data_->excl;
	if (_data_->_tmp25_) {
		_data_->_tmp26_ = _data_->self->priv->nclients;
		if (_data_->_tmp26_ > 1) {
			_data_->_tmp27_ = _data_->self->priv->nclients;
			_data_->_tmp28_ = NULL;
			_data_->_tmp28_ = g_strdup_printf ("%i", _data_->_tmp27_);
			_data_->_tmp29_ = _data_->_tmp28_;
			_data_->_tmp30_ = NULL;
			_data_->_tmp30_ = g_strconcat ("Can't make the client exclusive, there is already ", _data_->_tmp29_, " connected clients", NULL);
			_data_->_tmp31_ = _data_->_tmp30_;
			g_warning ("controller.vala:234: %s", _data_->_tmp31_);
			_g_free0 (_data_->_tmp31_);
			_g_free0 (_data_->_tmp29_);
			_data_->p = (g_free (_data_->p), NULL);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp32_ = _data_->c;
		_data_->_tmp33_ = _g_object_ref0 (_data_->_tmp32_);
		_g_object_unref0 (_data_->self->priv->excl_connection);
		_data_->self->priv->excl_connection = _data_->_tmp33_;
	}
	g_signal_emit_by_name (_data_->self, "client-connected");
	{
		_data_->_tmp34_ = TRUE;
		while (TRUE) {
			_data_->_tmp35_ = _data_->_tmp34_;
			if (!_data_->_tmp35_) {
			}
			_data_->_tmp34_ = FALSE;
			_data_->_tmp36_ = NULL;
			_data_->_tmp36_ = g_new0 (guint8, sizeof (ControllerMsg));
			_data_->t = _data_->_tmp36_;
			_data_->t_length1 = sizeof (ControllerMsg);
			_data_->_t_size_ = _data_->t_length1;
			_data_->_tmp37_ = _data_->c;
			_data_->_tmp38_ = g_io_stream_get_input_stream (_data_->_tmp37_);
			_data_->_tmp39_ = _data_->_tmp38_;
			_data_->_tmp40_ = _data_->t;
			_data_->_tmp40__length1 = _data_->t_length1;
			_data_->_state_ = 2;
			spice_ctrl_input_stream_read (_data_->_tmp39_, _data_->_tmp40_, _data_->_tmp40__length1, spice_ctrl_controller_handle_client_ready, _data_);
			return FALSE;
			_state_2:
			spice_ctrl_input_stream_read_finish (_data_->_res_, &_data_->_inner_error_);
			if (_data_->_inner_error_ != NULL) {
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				_data_->t = (g_free (_data_->t), NULL);
				_data_->p = (g_free (_data_->p), NULL);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp41_ = _data_->t;
			_data_->_tmp41__length1 = _data_->t_length1;
			_data_->msg = (ControllerMsg*) _data_->_tmp41_;
			_data_->_tmp42_ = _data_->msg;
			_data_->_tmp43_ = (*_data_->_tmp42_).id;
			_data_->_tmp44_ = NULL;
			_data_->_tmp44_ = g_strdup_printf ("%u", _data_->_tmp43_);
			_data_->_tmp45_ = _data_->_tmp44_;
			_data_->_tmp46_ = g_strconcat ("new message ", _data_->_tmp45_, NULL);
			_data_->_tmp47_ = _data_->_tmp46_;
			_data_->_tmp48_ = g_strconcat (_data_->_tmp47_, "size ", NULL);
			_data_->_tmp49_ = _data_->_tmp48_;
			_data_->_tmp50_ = _data_->msg;
			_data_->_tmp51_ = (*_data_->_tmp50_).size;
			_data_->_tmp52_ = NULL;
			_data_->_tmp52_ = g_strdup_printf ("%u", _data_->_tmp51_);
			_data_->_tmp53_ = _data_->_tmp52_;
			_data_->_tmp54_ = g_strconcat (_data_->_tmp49_, _data_->_tmp53_, NULL);
			_data_->_tmp55_ = _data_->_tmp54_;
			g_debug ("controller.vala:246: %s", _data_->_tmp55_);
			_g_free0 (_data_->_tmp55_);
			_g_free0 (_data_->_tmp53_);
			_g_free0 (_data_->_tmp49_);
			_g_free0 (_data_->_tmp47_);
			_g_free0 (_data_->_tmp45_);
			_data_->_tmp56_ = _data_->msg;
			_data_->_tmp57_ = (*_data_->_tmp56_).size;
			_data_->_tmp58_ = FALSE;
			_data_->_tmp58_ = g_warn_if (((gulong) _data_->_tmp57_) < sizeof (ControllerMsg));
			if (_data_->_tmp58_) {
				_data_->t = (g_free (_data_->t), NULL);
				break;
			}
			_data_->_tmp59_ = _data_->msg;
			_data_->_tmp60_ = (*_data_->_tmp59_).size;
			if (((gulong) _data_->_tmp60_) > sizeof (ControllerMsg)) {
				_data_->_tmp61_ = _data_->msg;
				_data_->_tmp62_ = (*_data_->_tmp61_).size;
				_data_->_tmp63_ = 0;
				_data_->_tmp63_ = (gint) _data_->_tmp62_;
				_data_->t = g_renew (guint8, _data_->t, (gint) _data_->_tmp62_);
				(_data_->_tmp63_ > _data_->t_length1) ? memset (_data_->t + _data_->t_length1, 0, sizeof (guint8) * (_data_->_tmp63_ - _data_->t_length1)) : NULL;
				_data_->t_length1 = _data_->_tmp63_;
				_data_->_t_size_ = _data_->_tmp63_;
				_data_->_tmp64_ = _data_->t;
				_data_->_tmp64__length1 = _data_->t_length1;
				_data_->msg = (ControllerMsg*) _data_->_tmp64_;
				_data_->_tmp65_ = _data_->c;
				_data_->_tmp66_ = g_io_stream_get_input_stream (_data_->_tmp65_);
				_data_->_tmp67_ = _data_->_tmp66_;
				_data_->_tmp68_ = _data_->t;
				_data_->_tmp68__length1 = _data_->t_length1;
				_data_->_tmp69_ = _data_->msg;
				_data_->_tmp70_ = (*_data_->_tmp69_).size;
				_data_->_state_ = 3;
				spice_ctrl_input_stream_read (_data_->_tmp67_, _data_->_tmp68_ + sizeof (ControllerMsg), _data_->_tmp70_ - sizeof (ControllerMsg), spice_ctrl_controller_handle_client_ready, _data_);
				return FALSE;
				_state_3:
				spice_ctrl_input_stream_read_finish (_data_->_res_, &_data_->_inner_error_);
				if (_data_->_inner_error_ != NULL) {
					g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
					g_error_free (_data_->_inner_error_);
					_data_->t = (g_free (_data_->t), NULL);
					_data_->p = (g_free (_data_->p), NULL);
					if (_data_->_state_ == 0) {
						g_simple_async_result_complete_in_idle (_data_->_async_result);
					} else {
						g_simple_async_result_complete (_data_->_async_result);
					}
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
			}
			_data_->_tmp71_ = _data_->msg;
			spice_ctrl_controller_handle_message (_data_->self, _data_->_tmp71_);
			_data_->t = (g_free (_data_->t), NULL);
		}
	}
	_data_->_tmp72_ = _data_->excl;
	if (_data_->_tmp72_) {
		_g_object_unref0 (_data_->self->priv->excl_connection);
		_data_->self->priv->excl_connection = NULL;
	}
	_data_->p = (g_free (_data_->p), NULL);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


SpiceCtrlController* spice_ctrl_controller_construct (GType object_type) {
	SpiceCtrlController * self = NULL;
	self = (SpiceCtrlController*) g_object_new (object_type, NULL);
	return self;
}


SpiceCtrlController* spice_ctrl_controller_new (void) {
	return spice_ctrl_controller_construct (SPICE_CTRL_TYPE_CONTROLLER);
}


static void spice_ctrl_controller_listen_data_free (gpointer _data) {
	SpiceCtrlControllerListenData* _data_;
	_data_ = _data;
	_g_free0 (_data_->addr);
	_g_object_unref0 (_data_->self);
	g_slice_free (SpiceCtrlControllerListenData, _data_);
}


void spice_ctrl_controller_listen (SpiceCtrlController* self, const gchar* addr, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SpiceCtrlControllerListenData* _data_;
	SpiceCtrlController* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	_data_ = g_slice_new0 (SpiceCtrlControllerListenData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, spice_ctrl_controller_listen);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, spice_ctrl_controller_listen_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = addr;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->addr);
	_data_->addr = _tmp2_;
	spice_ctrl_controller_listen_co (_data_);
}


void spice_ctrl_controller_listen_finish (SpiceCtrlController* self, GAsyncResult* _res_, GError** error) {
	SpiceCtrlControllerListenData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void spice_ctrl_controller_listen_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SpiceCtrlControllerListenData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	spice_ctrl_controller_listen_co (_data_);
}


static gboolean spice_ctrl_controller_listen_co (SpiceCtrlControllerListenData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->addr;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = spice_controller_listener_new (_data_->_tmp0_, &_data_->_inner_error_);
	_data_->listener = _data_->_tmp1_;
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp2_ = TRUE;
		while (TRUE) {
			_data_->_tmp3_ = _data_->_tmp2_;
			if (!_data_->_tmp3_) {
			}
			_data_->_tmp2_ = FALSE;
			_data_->_tmp4_ = _data_->listener;
			_data_->_state_ = 1;
			spice_controller_listener_accept_async (_data_->_tmp4_, NULL, spice_ctrl_controller_listen_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp5_ = NULL;
			_data_->_tmp5_ = spice_controller_listener_accept_finish (_data_->_tmp4_, _data_->_res_, NULL, &_data_->_inner_error_);
			_data_->_tmp6_ = _g_object_ref0 (_data_->_tmp5_);
			_data_->c = _data_->_tmp6_;
			if (_data_->_inner_error_ != NULL) {
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				_g_object_unref0 (_data_->listener);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp7_ = _data_->self->priv->nclients;
			_data_->self->priv->nclients = _data_->_tmp7_ + 1;
			_data_->_tmp8_ = _data_->c;
			_data_->_tmp9_ = _g_object_ref0 (_data_->_tmp8_);
			_data_->self->priv->clients = g_list_append (_data_->self->priv->clients, _data_->_tmp9_);
			{
				_data_->_tmp10_ = _data_->c;
				_data_->_state_ = 2;
				spice_ctrl_controller_handle_client (_data_->self, _data_->_tmp10_, spice_ctrl_controller_listen_ready, _data_);
				return FALSE;
				_state_2:
				spice_ctrl_controller_handle_client_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
				if (_data_->_inner_error_ != NULL) {
					goto __catch2_g_error;
				}
			}
			goto __finally2;
			__catch2_g_error:
			{
				_data_->e = _data_->_inner_error_;
				_data_->_inner_error_ = NULL;
				_data_->_tmp11_ = _data_->e;
				_data_->_tmp12_ = _data_->_tmp11_->message;
				g_warning ("controller.vala:277: %s", _data_->_tmp12_);
				_g_error_free0 (_data_->e);
			}
			__finally2:
			if (_data_->_inner_error_ != NULL) {
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				_g_object_unref0 (_data_->c);
				_g_object_unref0 (_data_->listener);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp13_ = _data_->c;
			g_io_stream_close (_data_->_tmp13_, NULL, &_data_->_inner_error_);
			if (_data_->_inner_error_ != NULL) {
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				_g_object_unref0 (_data_->c);
				_g_object_unref0 (_data_->listener);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp14_ = _data_->c;
			_data_->self->priv->clients = g_list_remove (_data_->self->priv->clients, _data_->_tmp14_);
			_data_->_tmp15_ = _data_->self->priv->nclients;
			_data_->self->priv->nclients = _data_->_tmp15_ - 1;
			_g_object_unref0 (_data_->c);
		}
	}
	_g_object_unref0 (_data_->listener);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


const gchar* spice_ctrl_controller_get_host (SpiceCtrlController* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_host;
	result = _tmp0_;
	return result;
}


static void spice_ctrl_controller_set_host (SpiceCtrlController* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_host);
	self->priv->_host = _tmp1_;
	g_object_notify ((GObject *) self, "host");
}


guint32 spice_ctrl_controller_get_port (SpiceCtrlController* self) {
	guint32 result;
	guint32 _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_port;
	result = _tmp0_;
	return result;
}


static void spice_ctrl_controller_set_port (SpiceCtrlController* self, guint32 value) {
	guint32 _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_port = _tmp0_;
	g_object_notify ((GObject *) self, "port");
}


guint32 spice_ctrl_controller_get_sport (SpiceCtrlController* self) {
	guint32 result;
	guint32 _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_sport;
	result = _tmp0_;
	return result;
}


static void spice_ctrl_controller_set_sport (SpiceCtrlController* self, guint32 value) {
	guint32 _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_sport = _tmp0_;
	g_object_notify ((GObject *) self, "sport");
}


const gchar* spice_ctrl_controller_get_password (SpiceCtrlController* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_password;
	result = _tmp0_;
	return result;
}


static void spice_ctrl_controller_set_password (SpiceCtrlController* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_password);
	self->priv->_password = _tmp1_;
	g_object_notify ((GObject *) self, "password");
}


unsigned int spice_ctrl_controller_get_display_flags (SpiceCtrlController* self) {
	unsigned int result;
	unsigned int _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_display_flags;
	result = _tmp0_;
	return result;
}


static void spice_ctrl_controller_set_display_flags (SpiceCtrlController* self, unsigned int value) {
	unsigned int _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_display_flags = _tmp0_;
	g_object_notify ((GObject *) self, "display-flags");
}


const gchar* spice_ctrl_controller_get_tls_ciphers (SpiceCtrlController* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_tls_ciphers;
	result = _tmp0_;
	return result;
}


static void spice_ctrl_controller_set_tls_ciphers (SpiceCtrlController* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_tls_ciphers);
	self->priv->_tls_ciphers = _tmp1_;
	g_object_notify ((GObject *) self, "tls-ciphers");
}


const gchar* spice_ctrl_controller_get_host_subject (SpiceCtrlController* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_host_subject;
	result = _tmp0_;
	return result;
}


static void spice_ctrl_controller_set_host_subject (SpiceCtrlController* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_host_subject);
	self->priv->_host_subject = _tmp1_;
	g_object_notify ((GObject *) self, "host-subject");
}


const gchar* spice_ctrl_controller_get_ca_file (SpiceCtrlController* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_ca_file;
	result = _tmp0_;
	return result;
}


static void spice_ctrl_controller_set_ca_file (SpiceCtrlController* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_ca_file);
	self->priv->_ca_file = _tmp1_;
	g_object_notify ((GObject *) self, "ca-file");
}


const gchar* spice_ctrl_controller_get_title (SpiceCtrlController* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_title;
	result = _tmp0_;
	return result;
}


static void spice_ctrl_controller_set_title (SpiceCtrlController* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_title);
	self->priv->_title = _tmp1_;
	g_object_notify ((GObject *) self, "title");
}


const gchar* spice_ctrl_controller_get_hotkeys (SpiceCtrlController* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_hotkeys;
	result = _tmp0_;
	return result;
}


static void spice_ctrl_controller_set_hotkeys (SpiceCtrlController* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_hotkeys);
	self->priv->_hotkeys = _tmp1_;
	g_object_notify ((GObject *) self, "hotkeys");
}


gchar** spice_ctrl_controller_get_secure_channels (SpiceCtrlController* self, int* result_length1) {
	gchar** result;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_secure_channels;
	_tmp0__length1 = self->priv->_secure_channels_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}


static gchar** _vala_array_dup3 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void spice_ctrl_controller_set_secure_channels (SpiceCtrlController* self, gchar** value, int value_length1) {
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp0__length1 = value_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup3 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	self->priv->_secure_channels = (_vala_array_free (self->priv->_secure_channels, self->priv->_secure_channels_length1, (GDestroyNotify) g_free), NULL);
	self->priv->_secure_channels = _tmp1_;
	self->priv->_secure_channels_length1 = _tmp1__length1;
	self->priv->__secure_channels_size_ = self->priv->_secure_channels_length1;
	g_object_notify ((GObject *) self, "secure-channels");
}


gchar** spice_ctrl_controller_get_disable_channels (SpiceCtrlController* self, int* result_length1) {
	gchar** result;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_disable_channels;
	_tmp0__length1 = self->priv->_disable_channels_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}


static gchar** _vala_array_dup4 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void spice_ctrl_controller_set_disable_channels (SpiceCtrlController* self, gchar** value, int value_length1) {
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp0__length1 = value_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup4 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	self->priv->_disable_channels = (_vala_array_free (self->priv->_disable_channels, self->priv->_disable_channels_length1, (GDestroyNotify) g_free), NULL);
	self->priv->_disable_channels = _tmp1_;
	self->priv->_disable_channels_length1 = _tmp1__length1;
	self->priv->__disable_channels_size_ = self->priv->_disable_channels_length1;
	g_object_notify ((GObject *) self, "disable-channels");
}


SpiceCtrlMenu* spice_ctrl_controller_get_menu (SpiceCtrlController* self) {
	SpiceCtrlMenu* result;
	SpiceCtrlMenu* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_menu;
	result = _tmp0_;
	return result;
}


static void spice_ctrl_controller_set_menu (SpiceCtrlController* self, SpiceCtrlMenu* value) {
	SpiceCtrlMenu* _tmp0_;
	SpiceCtrlMenu* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_menu);
	self->priv->_menu = _tmp1_;
	g_object_notify ((GObject *) self, "menu");
}


gboolean spice_ctrl_controller_get_enable_smartcard (SpiceCtrlController* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_enable_smartcard;
	result = _tmp0_;
	return result;
}


static void spice_ctrl_controller_set_enable_smartcard (SpiceCtrlController* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_enable_smartcard = _tmp0_;
	g_object_notify ((GObject *) self, "enable-smartcard");
}


gboolean spice_ctrl_controller_get_send_cad (SpiceCtrlController* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_send_cad;
	result = _tmp0_;
	return result;
}


static void spice_ctrl_controller_set_send_cad (SpiceCtrlController* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_send_cad = _tmp0_;
	g_object_notify ((GObject *) self, "send-cad");
}


gchar** spice_ctrl_controller_get_disable_effects (SpiceCtrlController* self, int* result_length1) {
	gchar** result;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_disable_effects;
	_tmp0__length1 = self->priv->_disable_effects_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}


static gchar** _vala_array_dup5 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void spice_ctrl_controller_set_disable_effects (SpiceCtrlController* self, gchar** value, int value_length1) {
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp0__length1 = value_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup5 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	self->priv->_disable_effects = (_vala_array_free (self->priv->_disable_effects, self->priv->_disable_effects_length1, (GDestroyNotify) g_free), NULL);
	self->priv->_disable_effects = _tmp1_;
	self->priv->_disable_effects_length1 = _tmp1__length1;
	self->priv->__disable_effects_size_ = self->priv->_disable_effects_length1;
	g_object_notify ((GObject *) self, "disable-effects");
}


guint32 spice_ctrl_controller_get_color_depth (SpiceCtrlController* self) {
	guint32 result;
	guint32 _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_color_depth;
	result = _tmp0_;
	return result;
}


static void spice_ctrl_controller_set_color_depth (SpiceCtrlController* self, guint32 value) {
	guint32 _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_color_depth = _tmp0_;
	g_object_notify ((GObject *) self, "color-depth");
}


gboolean spice_ctrl_controller_get_enable_usbredir (SpiceCtrlController* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_enable_usbredir;
	result = _tmp0_;
	return result;
}


static void spice_ctrl_controller_set_enable_usbredir (SpiceCtrlController* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_enable_usbredir = _tmp0_;
	g_object_notify ((GObject *) self, "enable-usbredir");
}


gboolean spice_ctrl_controller_get_enable_usb_autoshare (SpiceCtrlController* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_enable_usb_autoshare;
	result = _tmp0_;
	return result;
}


static void spice_ctrl_controller_set_enable_usb_autoshare (SpiceCtrlController* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_enable_usb_autoshare = _tmp0_;
	g_object_notify ((GObject *) self, "enable-usb-autoshare");
}


const gchar* spice_ctrl_controller_get_usb_filter (SpiceCtrlController* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_usb_filter;
	result = _tmp0_;
	return result;
}


static void spice_ctrl_controller_set_usb_filter (SpiceCtrlController* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_usb_filter);
	self->priv->_usb_filter = _tmp1_;
	g_object_notify ((GObject *) self, "usb-filter");
}


const gchar* spice_ctrl_controller_get_proxy (SpiceCtrlController* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_proxy;
	result = _tmp0_;
	return result;
}


static void spice_ctrl_controller_set_proxy (SpiceCtrlController* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_proxy);
	self->priv->_proxy = _tmp1_;
	g_object_notify ((GObject *) self, "proxy");
}


static void spice_ctrl_controller_class_init (SpiceCtrlControllerClass * klass) {
	spice_ctrl_controller_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SpiceCtrlControllerPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_spice_ctrl_controller_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_spice_ctrl_controller_set_property;
	G_OBJECT_CLASS (klass)->finalize = spice_ctrl_controller_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_CTRL_CONTROLLER_HOST, g_param_spec_string ("host", "host", "host", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_CTRL_CONTROLLER_PORT, g_param_spec_uint ("port", "port", "port", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_CTRL_CONTROLLER_SPORT, g_param_spec_uint ("sport", "sport", "sport", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_CTRL_CONTROLLER_PASSWORD, g_param_spec_string ("password", "password", "password", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_CTRL_CONTROLLER_DISPLAY_FLAGS, g_param_spec_uint ("display-flags", "display-flags", "display-flags", 0, G_MAXUINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_CTRL_CONTROLLER_TLS_CIPHERS, g_param_spec_string ("tls-ciphers", "tls-ciphers", "tls-ciphers", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_CTRL_CONTROLLER_HOST_SUBJECT, g_param_spec_string ("host-subject", "host-subject", "host-subject", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_CTRL_CONTROLLER_CA_FILE, g_param_spec_string ("ca-file", "ca-file", "ca-file", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_CTRL_CONTROLLER_TITLE, g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_CTRL_CONTROLLER_HOTKEYS, g_param_spec_string ("hotkeys", "hotkeys", "hotkeys", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_CTRL_CONTROLLER_SECURE_CHANNELS, g_param_spec_boxed ("secure-channels", "secure-channels", "secure-channels", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_CTRL_CONTROLLER_DISABLE_CHANNELS, g_param_spec_boxed ("disable-channels", "disable-channels", "disable-channels", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_CTRL_CONTROLLER_MENU, g_param_spec_object ("menu", "menu", "menu", SPICE_CTRL_TYPE_MENU, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_CTRL_CONTROLLER_ENABLE_SMARTCARD, g_param_spec_boolean ("enable-smartcard", "enable-smartcard", "enable-smartcard", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_CTRL_CONTROLLER_SEND_CAD, g_param_spec_boolean ("send-cad", "send-cad", "send-cad", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_CTRL_CONTROLLER_DISABLE_EFFECTS, g_param_spec_boxed ("disable-effects", "disable-effects", "disable-effects", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_CTRL_CONTROLLER_COLOR_DEPTH, g_param_spec_uint ("color-depth", "color-depth", "color-depth", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_CTRL_CONTROLLER_ENABLE_USBREDIR, g_param_spec_boolean ("enable-usbredir", "enable-usbredir", "enable-usbredir", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_CTRL_CONTROLLER_ENABLE_USB_AUTOSHARE, g_param_spec_boolean ("enable-usb-autoshare", "enable-usb-autoshare", "enable-usb-autoshare", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_CTRL_CONTROLLER_USB_FILTER, g_param_spec_string ("usb-filter", "usb-filter", "usb-filter", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_CTRL_CONTROLLER_PROXY, g_param_spec_string ("proxy", "proxy", "proxy", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("do_connect", SPICE_CTRL_TYPE_CONTROLLER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("show", SPICE_CTRL_TYPE_CONTROLLER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("hide", SPICE_CTRL_TYPE_CONTROLLER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("client_connected", SPICE_CTRL_TYPE_CONTROLLER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void spice_ctrl_controller_instance_init (SpiceCtrlController * self) {
	self->priv = SPICE_CTRL_CONTROLLER_GET_PRIVATE (self);
}


static void spice_ctrl_controller_finalize (GObject* obj) {
	SpiceCtrlController * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SPICE_CTRL_TYPE_CONTROLLER, SpiceCtrlController);
	_g_free0 (self->priv->_host);
	_g_free0 (self->priv->_password);
	_g_free0 (self->priv->_tls_ciphers);
	_g_free0 (self->priv->_host_subject);
	_g_free0 (self->priv->_ca_file);
	_g_free0 (self->priv->_title);
	_g_free0 (self->priv->_hotkeys);
	self->priv->_secure_channels = (_vala_array_free (self->priv->_secure_channels, self->priv->_secure_channels_length1, (GDestroyNotify) g_free), NULL);
	self->priv->_disable_channels = (_vala_array_free (self->priv->_disable_channels, self->priv->_disable_channels_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (self->priv->_menu);
	self->priv->_disable_effects = (_vala_array_free (self->priv->_disable_effects, self->priv->_disable_effects_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (self->priv->_usb_filter);
	_g_free0 (self->priv->_proxy);
	_g_object_unref0 (self->priv->excl_connection);
	__g_list_free__g_object_unref0_0 (self->priv->clients);
	G_OBJECT_CLASS (spice_ctrl_controller_parent_class)->finalize (obj);
}


GType spice_ctrl_controller_get_type (void) {
	static volatile gsize spice_ctrl_controller_type_id__volatile = 0;
	if (g_once_init_enter (&spice_ctrl_controller_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SpiceCtrlControllerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) spice_ctrl_controller_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SpiceCtrlController), 0, (GInstanceInitFunc) spice_ctrl_controller_instance_init, NULL };
		GType spice_ctrl_controller_type_id;
		spice_ctrl_controller_type_id = g_type_register_static (G_TYPE_OBJECT, "SpiceCtrlController", &g_define_type_info, 0);
		g_once_init_leave (&spice_ctrl_controller_type_id__volatile, spice_ctrl_controller_type_id);
	}
	return spice_ctrl_controller_type_id__volatile;
}


static void _vala_spice_ctrl_controller_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SpiceCtrlController * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SPICE_CTRL_TYPE_CONTROLLER, SpiceCtrlController);
	switch (property_id) {
		case SPICE_CTRL_CONTROLLER_HOST:
		g_value_set_string (value, spice_ctrl_controller_get_host (self));
		break;
		case SPICE_CTRL_CONTROLLER_PORT:
		g_value_set_uint (value, spice_ctrl_controller_get_port (self));
		break;
		case SPICE_CTRL_CONTROLLER_SPORT:
		g_value_set_uint (value, spice_ctrl_controller_get_sport (self));
		break;
		case SPICE_CTRL_CONTROLLER_PASSWORD:
		g_value_set_string (value, spice_ctrl_controller_get_password (self));
		break;
		case SPICE_CTRL_CONTROLLER_DISPLAY_FLAGS:
		g_value_set_uint (value, spice_ctrl_controller_get_display_flags (self));
		break;
		case SPICE_CTRL_CONTROLLER_TLS_CIPHERS:
		g_value_set_string (value, spice_ctrl_controller_get_tls_ciphers (self));
		break;
		case SPICE_CTRL_CONTROLLER_HOST_SUBJECT:
		g_value_set_string (value, spice_ctrl_controller_get_host_subject (self));
		break;
		case SPICE_CTRL_CONTROLLER_CA_FILE:
		g_value_set_string (value, spice_ctrl_controller_get_ca_file (self));
		break;
		case SPICE_CTRL_CONTROLLER_TITLE:
		g_value_set_string (value, spice_ctrl_controller_get_title (self));
		break;
		case SPICE_CTRL_CONTROLLER_HOTKEYS:
		g_value_set_string (value, spice_ctrl_controller_get_hotkeys (self));
		break;
		case SPICE_CTRL_CONTROLLER_SECURE_CHANNELS:
		{
			int length;
			g_value_set_boxed (value, spice_ctrl_controller_get_secure_channels (self, &length));
		}
		break;
		case SPICE_CTRL_CONTROLLER_DISABLE_CHANNELS:
		{
			int length;
			g_value_set_boxed (value, spice_ctrl_controller_get_disable_channels (self, &length));
		}
		break;
		case SPICE_CTRL_CONTROLLER_MENU:
		g_value_set_object (value, spice_ctrl_controller_get_menu (self));
		break;
		case SPICE_CTRL_CONTROLLER_ENABLE_SMARTCARD:
		g_value_set_boolean (value, spice_ctrl_controller_get_enable_smartcard (self));
		break;
		case SPICE_CTRL_CONTROLLER_SEND_CAD:
		g_value_set_boolean (value, spice_ctrl_controller_get_send_cad (self));
		break;
		case SPICE_CTRL_CONTROLLER_DISABLE_EFFECTS:
		{
			int length;
			g_value_set_boxed (value, spice_ctrl_controller_get_disable_effects (self, &length));
		}
		break;
		case SPICE_CTRL_CONTROLLER_COLOR_DEPTH:
		g_value_set_uint (value, spice_ctrl_controller_get_color_depth (self));
		break;
		case SPICE_CTRL_CONTROLLER_ENABLE_USBREDIR:
		g_value_set_boolean (value, spice_ctrl_controller_get_enable_usbredir (self));
		break;
		case SPICE_CTRL_CONTROLLER_ENABLE_USB_AUTOSHARE:
		g_value_set_boolean (value, spice_ctrl_controller_get_enable_usb_autoshare (self));
		break;
		case SPICE_CTRL_CONTROLLER_USB_FILTER:
		g_value_set_string (value, spice_ctrl_controller_get_usb_filter (self));
		break;
		case SPICE_CTRL_CONTROLLER_PROXY:
		g_value_set_string (value, spice_ctrl_controller_get_proxy (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_spice_ctrl_controller_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SpiceCtrlController * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SPICE_CTRL_TYPE_CONTROLLER, SpiceCtrlController);
	switch (property_id) {
		case SPICE_CTRL_CONTROLLER_HOST:
		spice_ctrl_controller_set_host (self, g_value_get_string (value));
		break;
		case SPICE_CTRL_CONTROLLER_PORT:
		spice_ctrl_controller_set_port (self, g_value_get_uint (value));
		break;
		case SPICE_CTRL_CONTROLLER_SPORT:
		spice_ctrl_controller_set_sport (self, g_value_get_uint (value));
		break;
		case SPICE_CTRL_CONTROLLER_PASSWORD:
		spice_ctrl_controller_set_password (self, g_value_get_string (value));
		break;
		case SPICE_CTRL_CONTROLLER_DISPLAY_FLAGS:
		spice_ctrl_controller_set_display_flags (self, g_value_get_uint (value));
		break;
		case SPICE_CTRL_CONTROLLER_TLS_CIPHERS:
		spice_ctrl_controller_set_tls_ciphers (self, g_value_get_string (value));
		break;
		case SPICE_CTRL_CONTROLLER_HOST_SUBJECT:
		spice_ctrl_controller_set_host_subject (self, g_value_get_string (value));
		break;
		case SPICE_CTRL_CONTROLLER_CA_FILE:
		spice_ctrl_controller_set_ca_file (self, g_value_get_string (value));
		break;
		case SPICE_CTRL_CONTROLLER_TITLE:
		spice_ctrl_controller_set_title (self, g_value_get_string (value));
		break;
		case SPICE_CTRL_CONTROLLER_HOTKEYS:
		spice_ctrl_controller_set_hotkeys (self, g_value_get_string (value));
		break;
		case SPICE_CTRL_CONTROLLER_SECURE_CHANNELS:
		{
			gpointer boxed;
			boxed = g_value_get_boxed (value);
			spice_ctrl_controller_set_secure_channels (self, boxed, g_strv_length (boxed));
		}
		break;
		case SPICE_CTRL_CONTROLLER_DISABLE_CHANNELS:
		{
			gpointer boxed;
			boxed = g_value_get_boxed (value);
			spice_ctrl_controller_set_disable_channels (self, boxed, g_strv_length (boxed));
		}
		break;
		case SPICE_CTRL_CONTROLLER_MENU:
		spice_ctrl_controller_set_menu (self, g_value_get_object (value));
		break;
		case SPICE_CTRL_CONTROLLER_ENABLE_SMARTCARD:
		spice_ctrl_controller_set_enable_smartcard (self, g_value_get_boolean (value));
		break;
		case SPICE_CTRL_CONTROLLER_SEND_CAD:
		spice_ctrl_controller_set_send_cad (self, g_value_get_boolean (value));
		break;
		case SPICE_CTRL_CONTROLLER_DISABLE_EFFECTS:
		{
			gpointer boxed;
			boxed = g_value_get_boxed (value);
			spice_ctrl_controller_set_disable_effects (self, boxed, g_strv_length (boxed));
		}
		break;
		case SPICE_CTRL_CONTROLLER_COLOR_DEPTH:
		spice_ctrl_controller_set_color_depth (self, g_value_get_uint (value));
		break;
		case SPICE_CTRL_CONTROLLER_ENABLE_USBREDIR:
		spice_ctrl_controller_set_enable_usbredir (self, g_value_get_boolean (value));
		break;
		case SPICE_CTRL_CONTROLLER_ENABLE_USB_AUTOSHARE:
		spice_ctrl_controller_set_enable_usb_autoshare (self, g_value_get_boolean (value));
		break;
		case SPICE_CTRL_CONTROLLER_USB_FILTER:
		spice_ctrl_controller_set_usb_filter (self, g_value_get_string (value));
		break;
		case SPICE_CTRL_CONTROLLER_PROXY:
		spice_ctrl_controller_set_proxy (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



