/******************************************************************************
 * THIS FILE IS GENERATED - ANY EDITS WILL BE OVERWRITTEN
 */

#pragma once

#include "converters.h"

namespace Quotient
{

// Data structures

struct RequestMsisdnValidation
{
    /// A unique string generated by the client, and used to identify
    /// thevalidation attempt. It must be a string consisting of the
    /// characters``[0-9a-zA-Z.=_-]``. Its length must not exceed 255 characters
    /// and itmust not be empty.
    QString clientSecret;
    /// The two-letter uppercase ISO country code that the number
    /// in``phone_number`` should be parsed as if it were dialled from.
    QString country;
    /// The phone number to validate.
    QString phoneNumber;
    /// The server will only send an SMS if the ``send_attempt`` is anumber
    /// greater than the most recent one which it has seen,scoped to that
    /// ``country`` + ``phone_number`` + ``client_secret``triple. This is to
    /// avoid repeatedly sending the same SMS inthe case of request retries
    /// between the POSTing user and theidentity server. The client should
    /// increment this value ifthey desire a new SMS (e.g. a reminder) to be
    /// sent.
    int sendAttempt;
    /// Optional. When the validation is completed, the identityserver will
    /// redirect the user to this URL.
    QString nextLink;
};

template <>
struct JsonObjectConverter<RequestMsisdnValidation>
{
    static void dumpTo(QJsonObject& jo, const RequestMsisdnValidation& pod);
    static void fillFrom(const QJsonObject& jo, RequestMsisdnValidation& pod);
};

} // namespace Quotient
