/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Tue Jul 14 19:02:34 2020

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_58 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 32360, "epsg", 32360,
        "WGS 72 / UTM zone 60S", 0, 0,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=60 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 60S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"World_Geodetic_System_1972\",SPHEROID[\"WGS 72\",6378");
    add_srs_wkt (p, 2,
        "135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4322\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",177],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 9,
        "0000],PARAMETER[\"false_northing\",10000000],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 11,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32360\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 32401, "epsg", 32401,
        "WGS 72BE / UTM zone 1N", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=1 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.81");
    add_proj4text (p, 1,
        "4,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 1N\",GEOGCS[\"WGS 72BE\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"432");
    add_srs_wkt (p, 6,
        "4\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_origin\",0],PARAMETER[\"central_meridian\",-17");
    add_srs_wkt (p, 8,
        "7],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"324");
    add_srs_wkt (p, 12,
        "01\"]]");
    p = add_epsg_def_ex (filter, first, last, 32402, "epsg", 32402,
        "WGS 72BE / UTM zone 2N", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=2 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.81");
    add_proj4text (p, 1,
        "4,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 2N\",GEOGCS[\"WGS 72BE\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"432");
    add_srs_wkt (p, 6,
        "4\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_origin\",0],PARAMETER[\"central_meridian\",-17");
    add_srs_wkt (p, 8,
        "1],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"324");
    add_srs_wkt (p, 12,
        "02\"]]");
    p = add_epsg_def_ex (filter, first, last, 32403, "epsg", 32403,
        "WGS 72BE / UTM zone 3N", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=3 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.81");
    add_proj4text (p, 1,
        "4,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 3N\",GEOGCS[\"WGS 72BE\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"432");
    add_srs_wkt (p, 6,
        "4\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_origin\",0],PARAMETER[\"central_meridian\",-16");
    add_srs_wkt (p, 8,
        "5],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"324");
    add_srs_wkt (p, 12,
        "03\"]]");
    p = add_epsg_def_ex (filter, first, last, 32404, "epsg", 32404,
        "WGS 72BE / UTM zone 4N", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=4 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.81");
    add_proj4text (p, 1,
        "4,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 4N\",GEOGCS[\"WGS 72BE\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"432");
    add_srs_wkt (p, 6,
        "4\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_origin\",0],PARAMETER[\"central_meridian\",-15");
    add_srs_wkt (p, 8,
        "9],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"324");
    add_srs_wkt (p, 12,
        "04\"]]");
    p = add_epsg_def_ex (filter, first, last, 32405, "epsg", 32405,
        "WGS 72BE / UTM zone 5N", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=5 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.81");
    add_proj4text (p, 1,
        "4,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 5N\",GEOGCS[\"WGS 72BE\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"432");
    add_srs_wkt (p, 6,
        "4\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_origin\",0],PARAMETER[\"central_meridian\",-15");
    add_srs_wkt (p, 8,
        "3],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"324");
    add_srs_wkt (p, 12,
        "05\"]]");
    p = add_epsg_def_ex (filter, first, last, 32406, "epsg", 32406,
        "WGS 72BE / UTM zone 6N", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=6 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.81");
    add_proj4text (p, 1,
        "4,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 6N\",GEOGCS[\"WGS 72BE\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"432");
    add_srs_wkt (p, 6,
        "4\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_origin\",0],PARAMETER[\"central_meridian\",-14");
    add_srs_wkt (p, 8,
        "7],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"324");
    add_srs_wkt (p, 12,
        "06\"]]");
    p = add_epsg_def_ex (filter, first, last, 32407, "epsg", 32407,
        "WGS 72BE / UTM zone 7N", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=7 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.81");
    add_proj4text (p, 1,
        "4,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 7N\",GEOGCS[\"WGS 72BE\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"432");
    add_srs_wkt (p, 6,
        "4\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_origin\",0],PARAMETER[\"central_meridian\",-14");
    add_srs_wkt (p, 8,
        "1],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"324");
    add_srs_wkt (p, 12,
        "07\"]]");
    p = add_epsg_def_ex (filter, first, last, 32408, "epsg", 32408,
        "WGS 72BE / UTM zone 8N", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=8 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.81");
    add_proj4text (p, 1,
        "4,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 8N\",GEOGCS[\"WGS 72BE\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"432");
    add_srs_wkt (p, 6,
        "4\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_origin\",0],PARAMETER[\"central_meridian\",-13");
    add_srs_wkt (p, 8,
        "5],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"324");
    add_srs_wkt (p, 12,
        "08\"]]");
    p = add_epsg_def_ex (filter, first, last, 32409, "epsg", 32409,
        "WGS 72BE / UTM zone 9N", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=9 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.81");
    add_proj4text (p, 1,
        "4,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 9N\",GEOGCS[\"WGS 72BE\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"432");
    add_srs_wkt (p, 6,
        "4\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_origin\",0],PARAMETER[\"central_meridian\",-12");
    add_srs_wkt (p, 8,
        "9],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"324");
    add_srs_wkt (p, 12,
        "09\"]]");
    p = add_epsg_def_ex (filter, first, last, 32410, "epsg", 32410,
        "WGS 72BE / UTM zone 10N", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=10 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.8");
    add_proj4text (p, 1,
        "14,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 10N\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",-1");
    add_srs_wkt (p, 8,
        "23],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 10,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 11,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 12,
        "2410\"]]");
    p = add_epsg_def_ex (filter, first, last, 32411, "epsg", 32411,
        "WGS 72BE / UTM zone 11N", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=11 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.8");
    add_proj4text (p, 1,
        "14,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 11N\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",-1");
    add_srs_wkt (p, 8,
        "17],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 10,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 11,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 12,
        "2411\"]]");
    p = add_epsg_def_ex (filter, first, last, 32412, "epsg", 32412,
        "WGS 72BE / UTM zone 12N", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=12 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.8");
    add_proj4text (p, 1,
        "14,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 12N\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",-1");
    add_srs_wkt (p, 8,
        "11],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 10,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 11,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 12,
        "2412\"]]");
    p = add_epsg_def_ex (filter, first, last, 32413, "epsg", 32413,
        "WGS 72BE / UTM zone 13N", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=13 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.8");
    add_proj4text (p, 1,
        "14,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 13N\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",-1");
    add_srs_wkt (p, 8,
        "05],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 10,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 11,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 12,
        "2413\"]]");
    p = add_epsg_def_ex (filter, first, last, 32414, "epsg", 32414,
        "WGS 72BE / UTM zone 14N", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=14 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.8");
    add_proj4text (p, 1,
        "14,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 14N\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",-9");
    add_srs_wkt (p, 8,
        "9],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"324");
    add_srs_wkt (p, 12,
        "14\"]]");
    p = add_epsg_def_ex (filter, first, last, 32415, "epsg", 32415,
        "WGS 72BE / UTM zone 15N", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=15 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.8");
    add_proj4text (p, 1,
        "14,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 15N\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",-9");
    add_srs_wkt (p, 8,
        "3],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"324");
    add_srs_wkt (p, 12,
        "15\"]]");
    p = add_epsg_def_ex (filter, first, last, 32416, "epsg", 32416,
        "WGS 72BE / UTM zone 16N", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=16 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.8");
    add_proj4text (p, 1,
        "14,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 16N\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",-8");
    add_srs_wkt (p, 8,
        "7],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"324");
    add_srs_wkt (p, 12,
        "16\"]]");
    p = add_epsg_def_ex (filter, first, last, 32417, "epsg", 32417,
        "WGS 72BE / UTM zone 17N", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=17 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.8");
    add_proj4text (p, 1,
        "14,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 17N\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",-8");
    add_srs_wkt (p, 8,
        "1],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"324");
    add_srs_wkt (p, 12,
        "17\"]]");
    p = add_epsg_def_ex (filter, first, last, 32418, "epsg", 32418,
        "WGS 72BE / UTM zone 18N", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=18 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.8");
    add_proj4text (p, 1,
        "14,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 18N\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",-7");
    add_srs_wkt (p, 8,
        "5],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"324");
    add_srs_wkt (p, 12,
        "18\"]]");
    p = add_epsg_def_ex (filter, first, last, 32419, "epsg", 32419,
        "WGS 72BE / UTM zone 19N", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=19 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.8");
    add_proj4text (p, 1,
        "14,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 19N\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",-6");
    add_srs_wkt (p, 8,
        "9],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"324");
    add_srs_wkt (p, 12,
        "19\"]]");
    p = add_epsg_def_ex (filter, first, last, 32420, "epsg", 32420,
        "WGS 72BE / UTM zone 20N", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.8");
    add_proj4text (p, 1,
        "14,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 20N\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",-6");
    add_srs_wkt (p, 8,
        "3],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"324");
    add_srs_wkt (p, 12,
        "20\"]]");
    p = add_epsg_def_ex (filter, first, last, 32421, "epsg", 32421,
        "WGS 72BE / UTM zone 21N", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=21 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.8");
    add_proj4text (p, 1,
        "14,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 21N\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",-5");
    add_srs_wkt (p, 8,
        "7],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"324");
    add_srs_wkt (p, 12,
        "21\"]]");
    p = add_epsg_def_ex (filter, first, last, 32422, "epsg", 32422,
        "WGS 72BE / UTM zone 22N", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=22 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.8");
    add_proj4text (p, 1,
        "14,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 22N\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",-5");
    add_srs_wkt (p, 8,
        "1],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"324");
    add_srs_wkt (p, 12,
        "22\"]]");
    p = add_epsg_def_ex (filter, first, last, 32423, "epsg", 32423,
        "WGS 72BE / UTM zone 23N", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=23 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.8");
    add_proj4text (p, 1,
        "14,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 23N\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",-4");
    add_srs_wkt (p, 8,
        "5],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"324");
    add_srs_wkt (p, 12,
        "23\"]]");
    p = add_epsg_def_ex (filter, first, last, 32424, "epsg", 32424,
        "WGS 72BE / UTM zone 24N", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=24 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.8");
    add_proj4text (p, 1,
        "14,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 24N\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",-3");
    add_srs_wkt (p, 8,
        "9],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"324");
    add_srs_wkt (p, 12,
        "24\"]]");
    p = add_epsg_def_ex (filter, first, last, 32425, "epsg", 32425,
        "WGS 72BE / UTM zone 25N", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=25 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.8");
    add_proj4text (p, 1,
        "14,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 25N\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",-3");
    add_srs_wkt (p, 8,
        "3],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"324");
    add_srs_wkt (p, 12,
        "25\"]]");
    p = add_epsg_def_ex (filter, first, last, 32426, "epsg", 32426,
        "WGS 72BE / UTM zone 26N", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=26 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.8");
    add_proj4text (p, 1,
        "14,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 26N\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",-2");
    add_srs_wkt (p, 8,
        "7],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"324");
    add_srs_wkt (p, 12,
        "26\"]]");
    p = add_epsg_def_ex (filter, first, last, 32427, "epsg", 32427,
        "WGS 72BE / UTM zone 27N", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=27 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.8");
    add_proj4text (p, 1,
        "14,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 27N\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",-2");
    add_srs_wkt (p, 8,
        "1],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"324");
    add_srs_wkt (p, 12,
        "27\"]]");
    p = add_epsg_def_ex (filter, first, last, 32428, "epsg", 32428,
        "WGS 72BE / UTM zone 28N", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=28 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.8");
    add_proj4text (p, 1,
        "14,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 28N\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",-1");
    add_srs_wkt (p, 8,
        "5],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"324");
    add_srs_wkt (p, 12,
        "28\"]]");
    p = add_epsg_def_ex (filter, first, last, 32429, "epsg", 32429,
        "WGS 72BE / UTM zone 29N", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=29 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.8");
    add_proj4text (p, 1,
        "14,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 29N\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",-9");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_e");
    add_srs_wkt (p, 9,
        "asting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"324");
    add_srs_wkt (p, 12,
        "29\"]]");
    p = add_epsg_def_ex (filter, first, last, 32430, "epsg", 32430,
        "WGS 72BE / UTM zone 30N", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=30 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.8");
    add_proj4text (p, 1,
        "14,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 30N\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",-3");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_e");
    add_srs_wkt (p, 9,
        "asting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"324");
    add_srs_wkt (p, 12,
        "30\"]]");
    p = add_epsg_def_ex (filter, first, last, 32431, "epsg", 32431,
        "WGS 72BE / UTM zone 31N", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=31 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.8");
    add_proj4text (p, 1,
        "14,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 31N\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",3]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_ea");
    add_srs_wkt (p, 9,
        "sting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 10,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",");
    add_srs_wkt (p, 11,
        "EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3243");
    add_srs_wkt (p, 12,
        "1\"]]");
    p = add_epsg_def_ex (filter, first, last, 32432, "epsg", 32432,
        "WGS 72BE / UTM zone 32N", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=32 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.8");
    add_proj4text (p, 1,
        "14,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 32N\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",9]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_ea");
    add_srs_wkt (p, 9,
        "sting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 10,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",");
    add_srs_wkt (p, 11,
        "EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3243");
    add_srs_wkt (p, 12,
        "2\"]]");
    p = add_epsg_def_ex (filter, first, last, 32433, "epsg", 32433,
        "WGS 72BE / UTM zone 33N", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=33 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.8");
    add_proj4text (p, 1,
        "14,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 33N\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",15");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_e");
    add_srs_wkt (p, 9,
        "asting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"324");
    add_srs_wkt (p, 12,
        "33\"]]");
    p = add_epsg_def_ex (filter, first, last, 32434, "epsg", 32434,
        "WGS 72BE / UTM zone 34N", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=34 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.8");
    add_proj4text (p, 1,
        "14,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 34N\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",21");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_e");
    add_srs_wkt (p, 9,
        "asting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"324");
    add_srs_wkt (p, 12,
        "34\"]]");
    p = add_epsg_def_ex (filter, first, last, 32435, "epsg", 32435,
        "WGS 72BE / UTM zone 35N", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=35 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.8");
    add_proj4text (p, 1,
        "14,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 35N\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",27");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_e");
    add_srs_wkt (p, 9,
        "asting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"324");
    add_srs_wkt (p, 12,
        "35\"]]");
    p = add_epsg_def_ex (filter, first, last, 32436, "epsg", 32436,
        "WGS 72BE / UTM zone 36N", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=36 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.8");
    add_proj4text (p, 1,
        "14,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 36N\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",33");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_e");
    add_srs_wkt (p, 9,
        "asting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"324");
    add_srs_wkt (p, 12,
        "36\"]]");
    p = add_epsg_def_ex (filter, first, last, 32437, "epsg", 32437,
        "WGS 72BE / UTM zone 37N", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=37 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.8");
    add_proj4text (p, 1,
        "14,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 37N\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",39");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_e");
    add_srs_wkt (p, 9,
        "asting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"324");
    add_srs_wkt (p, 12,
        "37\"]]");
    p = add_epsg_def_ex (filter, first, last, 32438, "epsg", 32438,
        "WGS 72BE / UTM zone 38N", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=38 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.8");
    add_proj4text (p, 1,
        "14,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 38N\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",45");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_e");
    add_srs_wkt (p, 9,
        "asting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"324");
    add_srs_wkt (p, 12,
        "38\"]]");
    p = add_epsg_def_ex (filter, first, last, 32439, "epsg", 32439,
        "WGS 72BE / UTM zone 39N", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=39 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.8");
    add_proj4text (p, 1,
        "14,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 39N\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",51");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_e");
    add_srs_wkt (p, 9,
        "asting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"324");
    add_srs_wkt (p, 12,
        "39\"]]");
    p = add_epsg_def_ex (filter, first, last, 32440, "epsg", 32440,
        "WGS 72BE / UTM zone 40N", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=40 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.8");
    add_proj4text (p, 1,
        "14,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 40N\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",57");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_e");
    add_srs_wkt (p, 9,
        "asting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"324");
    add_srs_wkt (p, 12,
        "40\"]]");
    p = add_epsg_def_ex (filter, first, last, 32441, "epsg", 32441,
        "WGS 72BE / UTM zone 41N", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=41 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.8");
    add_proj4text (p, 1,
        "14,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 41N\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",63");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_e");
    add_srs_wkt (p, 9,
        "asting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"324");
    add_srs_wkt (p, 12,
        "41\"]]");
    p = add_epsg_def_ex (filter, first, last, 32442, "epsg", 32442,
        "WGS 72BE / UTM zone 42N", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=42 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.8");
    add_proj4text (p, 1,
        "14,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 42N\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",69");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_e");
    add_srs_wkt (p, 9,
        "asting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"324");
    add_srs_wkt (p, 12,
        "42\"]]");
    p = add_epsg_def_ex (filter, first, last, 32443, "epsg", 32443,
        "WGS 72BE / UTM zone 43N", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=43 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.8");
    add_proj4text (p, 1,
        "14,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 43N\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",75");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_e");
    add_srs_wkt (p, 9,
        "asting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"324");
    add_srs_wkt (p, 12,
        "43\"]]");
    p = add_epsg_def_ex (filter, first, last, 32444, "epsg", 32444,
        "WGS 72BE / UTM zone 44N", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=44 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.8");
    add_proj4text (p, 1,
        "14,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 44N\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",81");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_e");
    add_srs_wkt (p, 9,
        "asting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"324");
    add_srs_wkt (p, 12,
        "44\"]]");
    p = add_epsg_def_ex (filter, first, last, 32445, "epsg", 32445,
        "WGS 72BE / UTM zone 45N", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=45 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.8");
    add_proj4text (p, 1,
        "14,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 45N\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",87");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_e");
    add_srs_wkt (p, 9,
        "asting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"324");
    add_srs_wkt (p, 12,
        "45\"]]");
    p = add_epsg_def_ex (filter, first, last, 32446, "epsg", 32446,
        "WGS 72BE / UTM zone 46N", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=46 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.8");
    add_proj4text (p, 1,
        "14,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 46N\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",93");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_e");
    add_srs_wkt (p, 9,
        "asting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"324");
    add_srs_wkt (p, 12,
        "46\"]]");
    p = add_epsg_def_ex (filter, first, last, 32447, "epsg", 32447,
        "WGS 72BE / UTM zone 47N", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=47 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.8");
    add_proj4text (p, 1,
        "14,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 47N\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",99");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_e");
    add_srs_wkt (p, 9,
        "asting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"324");
    add_srs_wkt (p, 12,
        "47\"]]");
    p = add_epsg_def_ex (filter, first, last, 32448, "epsg", 32448,
        "WGS 72BE / UTM zone 48N", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=48 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.8");
    add_proj4text (p, 1,
        "14,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 48N\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",10");
    add_srs_wkt (p, 8,
        "5],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"324");
    add_srs_wkt (p, 12,
        "48\"]]");
    p = add_epsg_def_ex (filter, first, last, 32449, "epsg", 32449,
        "WGS 72BE / UTM zone 49N", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=49 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.8");
    add_proj4text (p, 1,
        "14,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 49N\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",11");
    add_srs_wkt (p, 8,
        "1],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"324");
    add_srs_wkt (p, 12,
        "49\"]]");
    p = add_epsg_def_ex (filter, first, last, 32450, "epsg", 32450,
        "WGS 72BE / UTM zone 50N", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=50 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.8");
    add_proj4text (p, 1,
        "14,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 50N\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",11");
    add_srs_wkt (p, 8,
        "7],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"324");
    add_srs_wkt (p, 12,
        "50\"]]");
    p = add_epsg_def_ex (filter, first, last, 32451, "epsg", 32451,
        "WGS 72BE / UTM zone 51N", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=51 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.8");
    add_proj4text (p, 1,
        "14,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 51N\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",12");
    add_srs_wkt (p, 8,
        "3],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"324");
    add_srs_wkt (p, 12,
        "51\"]]");
    p = add_epsg_def_ex (filter, first, last, 32452, "epsg", 32452,
        "WGS 72BE / UTM zone 52N", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=52 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.8");
    add_proj4text (p, 1,
        "14,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 52N\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",12");
    add_srs_wkt (p, 8,
        "9],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"324");
    add_srs_wkt (p, 12,
        "52\"]]");
    p = add_epsg_def_ex (filter, first, last, 32453, "epsg", 32453,
        "WGS 72BE / UTM zone 53N", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=53 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.8");
    add_proj4text (p, 1,
        "14,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 53N\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",13");
    add_srs_wkt (p, 8,
        "5],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"324");
    add_srs_wkt (p, 12,
        "53\"]]");
    p = add_epsg_def_ex (filter, first, last, 32454, "epsg", 32454,
        "WGS 72BE / UTM zone 54N", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=54 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.8");
    add_proj4text (p, 1,
        "14,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 54N\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",14");
    add_srs_wkt (p, 8,
        "1],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"324");
    add_srs_wkt (p, 12,
        "54\"]]");
    p = add_epsg_def_ex (filter, first, last, 32455, "epsg", 32455,
        "WGS 72BE / UTM zone 55N", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=55 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.8");
    add_proj4text (p, 1,
        "14,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 55N\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",14");
    add_srs_wkt (p, 8,
        "7],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"324");
    add_srs_wkt (p, 12,
        "55\"]]");
    p = add_epsg_def_ex (filter, first, last, 32456, "epsg", 32456,
        "WGS 72BE / UTM zone 56N", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=56 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.8");
    add_proj4text (p, 1,
        "14,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 56N\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",15");
    add_srs_wkt (p, 8,
        "3],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"324");
    add_srs_wkt (p, 12,
        "56\"]]");
    p = add_epsg_def_ex (filter, first, last, 32457, "epsg", 32457,
        "WGS 72BE / UTM zone 57N", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=57 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.8");
    add_proj4text (p, 1,
        "14,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 57N\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",15");
    add_srs_wkt (p, 8,
        "9],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"324");
    add_srs_wkt (p, 12,
        "57\"]]");
    p = add_epsg_def_ex (filter, first, last, 32458, "epsg", 32458,
        "WGS 72BE / UTM zone 58N", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=58 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.8");
    add_proj4text (p, 1,
        "14,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 58N\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",16");
    add_srs_wkt (p, 8,
        "5],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"324");
    add_srs_wkt (p, 12,
        "58\"]]");
    p = add_epsg_def_ex (filter, first, last, 32459, "epsg", 32459,
        "WGS 72BE / UTM zone 59N", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=59 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.8");
    add_proj4text (p, 1,
        "14,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 59N\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",17");
    add_srs_wkt (p, 8,
        "1],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"324");
    add_srs_wkt (p, 12,
        "59\"]]");
    p = add_epsg_def_ex (filter, first, last, 32460, "epsg", 32460,
        "WGS 72BE / UTM zone 60N", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=60 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.8");
    add_proj4text (p, 1,
        "14,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 60N\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",17");
    add_srs_wkt (p, 8,
        "7],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"324");
    add_srs_wkt (p, 12,
        "60\"]]");
    p = add_epsg_def_ex (filter, first, last, 32501, "epsg", 32501,
        "WGS 72BE / UTM zone 1S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=1 +south +ellps=WGS72 +towgs84=0,0,1.9,0");
    add_proj4text (p, 1,
        ",0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 1S\",GEOGCS[\"WGS 72BE\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"432");
    add_srs_wkt (p, 6,
        "4\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_origin\",0],PARAMETER[\"central_meridian\",-17");
    add_srs_wkt (p, 8,
        "7],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",10000000]");
    add_srs_wkt (p, 10,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 11,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"32501\"]]");
    p = add_epsg_def_ex (filter, first, last, 32502, "epsg", 32502,
        "WGS 72BE / UTM zone 2S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=2 +south +ellps=WGS72 +towgs84=0,0,1.9,0");
    add_proj4text (p, 1,
        ",0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 2S\",GEOGCS[\"WGS 72BE\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"432");
    add_srs_wkt (p, 6,
        "4\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_origin\",0],PARAMETER[\"central_meridian\",-17");
    add_srs_wkt (p, 8,
        "1],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",10000000]");
    add_srs_wkt (p, 10,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 11,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"32502\"]]");
    p = add_epsg_def_ex (filter, first, last, 32503, "epsg", 32503,
        "WGS 72BE / UTM zone 3S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=3 +south +ellps=WGS72 +towgs84=0,0,1.9,0");
    add_proj4text (p, 1,
        ",0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 3S\",GEOGCS[\"WGS 72BE\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"432");
    add_srs_wkt (p, 6,
        "4\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_origin\",0],PARAMETER[\"central_meridian\",-16");
    add_srs_wkt (p, 8,
        "5],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",10000000]");
    add_srs_wkt (p, 10,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 11,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"32503\"]]");
    p = add_epsg_def_ex (filter, first, last, 32504, "epsg", 32504,
        "WGS 72BE / UTM zone 4S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=4 +south +ellps=WGS72 +towgs84=0,0,1.9,0");
    add_proj4text (p, 1,
        ",0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 4S\",GEOGCS[\"WGS 72BE\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"432");
    add_srs_wkt (p, 6,
        "4\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_origin\",0],PARAMETER[\"central_meridian\",-15");
    add_srs_wkt (p, 8,
        "9],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",10000000]");
    add_srs_wkt (p, 10,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 11,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"32504\"]]");
    p = add_epsg_def_ex (filter, first, last, 32505, "epsg", 32505,
        "WGS 72BE / UTM zone 5S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=5 +south +ellps=WGS72 +towgs84=0,0,1.9,0");
    add_proj4text (p, 1,
        ",0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 5S\",GEOGCS[\"WGS 72BE\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"432");
    add_srs_wkt (p, 6,
        "4\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_origin\",0],PARAMETER[\"central_meridian\",-15");
    add_srs_wkt (p, 8,
        "3],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",10000000]");
    add_srs_wkt (p, 10,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 11,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"32505\"]]");
    p = add_epsg_def_ex (filter, first, last, 32506, "epsg", 32506,
        "WGS 72BE / UTM zone 6S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=6 +south +ellps=WGS72 +towgs84=0,0,1.9,0");
    add_proj4text (p, 1,
        ",0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 6S\",GEOGCS[\"WGS 72BE\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"432");
    add_srs_wkt (p, 6,
        "4\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_origin\",0],PARAMETER[\"central_meridian\",-14");
    add_srs_wkt (p, 8,
        "7],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",10000000]");
    add_srs_wkt (p, 10,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 11,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"32506\"]]");
    p = add_epsg_def_ex (filter, first, last, 32507, "epsg", 32507,
        "WGS 72BE / UTM zone 7S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=7 +south +ellps=WGS72 +towgs84=0,0,1.9,0");
    add_proj4text (p, 1,
        ",0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 7S\",GEOGCS[\"WGS 72BE\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"432");
    add_srs_wkt (p, 6,
        "4\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_origin\",0],PARAMETER[\"central_meridian\",-14");
    add_srs_wkt (p, 8,
        "1],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",10000000]");
    add_srs_wkt (p, 10,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 11,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"32507\"]]");
    p = add_epsg_def_ex (filter, first, last, 32508, "epsg", 32508,
        "WGS 72BE / UTM zone 8S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=8 +south +ellps=WGS72 +towgs84=0,0,1.9,0");
    add_proj4text (p, 1,
        ",0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 8S\",GEOGCS[\"WGS 72BE\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"432");
    add_srs_wkt (p, 6,
        "4\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_origin\",0],PARAMETER[\"central_meridian\",-13");
    add_srs_wkt (p, 8,
        "5],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",10000000]");
    add_srs_wkt (p, 10,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 11,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"32508\"]]");
    p = add_epsg_def_ex (filter, first, last, 32509, "epsg", 32509,
        "WGS 72BE / UTM zone 9S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=9 +south +ellps=WGS72 +towgs84=0,0,1.9,0");
    add_proj4text (p, 1,
        ",0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 9S\",GEOGCS[\"WGS 72BE\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"432");
    add_srs_wkt (p, 6,
        "4\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_origin\",0],PARAMETER[\"central_meridian\",-12");
    add_srs_wkt (p, 8,
        "9],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",10000000]");
    add_srs_wkt (p, 10,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 11,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"32509\"]]");
    p = add_epsg_def_ex (filter, first, last, 32510, "epsg", 32510,
        "WGS 72BE / UTM zone 10S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=10 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 10S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",-1");
    add_srs_wkt (p, 8,
        "23],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",10000000");
    add_srs_wkt (p, 10,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"32510\"]]");
    p = add_epsg_def_ex (filter, first, last, 32511, "epsg", 32511,
        "WGS 72BE / UTM zone 11S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=11 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 11S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",-1");
    add_srs_wkt (p, 8,
        "17],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",10000000");
    add_srs_wkt (p, 10,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"32511\"]]");
    p = add_epsg_def_ex (filter, first, last, 32512, "epsg", 32512,
        "WGS 72BE / UTM zone 12S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=12 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 12S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",-1");
    add_srs_wkt (p, 8,
        "11],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",10000000");
    add_srs_wkt (p, 10,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"32512\"]]");
    p = add_epsg_def_ex (filter, first, last, 32513, "epsg", 32513,
        "WGS 72BE / UTM zone 13S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=13 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 13S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",-1");
    add_srs_wkt (p, 8,
        "05],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",10000000");
    add_srs_wkt (p, 10,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"32513\"]]");
    p = add_epsg_def_ex (filter, first, last, 32514, "epsg", 32514,
        "WGS 72BE / UTM zone 14S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=14 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 14S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",-9");
    add_srs_wkt (p, 8,
        "9],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",10000000]");
    add_srs_wkt (p, 10,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 11,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"32514\"]]");
    p = add_epsg_def_ex (filter, first, last, 32515, "epsg", 32515,
        "WGS 72BE / UTM zone 15S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=15 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 15S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",-9");
    add_srs_wkt (p, 8,
        "3],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",10000000]");
    add_srs_wkt (p, 10,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 11,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"32515\"]]");
    p = add_epsg_def_ex (filter, first, last, 32516, "epsg", 32516,
        "WGS 72BE / UTM zone 16S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=16 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 16S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",-8");
    add_srs_wkt (p, 8,
        "7],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",10000000]");
    add_srs_wkt (p, 10,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 11,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"32516\"]]");
    p = add_epsg_def_ex (filter, first, last, 32517, "epsg", 32517,
        "WGS 72BE / UTM zone 17S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=17 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 17S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",-8");
    add_srs_wkt (p, 8,
        "1],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",10000000]");
    add_srs_wkt (p, 10,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 11,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"32517\"]]");
    p = add_epsg_def_ex (filter, first, last, 32518, "epsg", 32518,
        "WGS 72BE / UTM zone 18S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=18 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 18S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",-7");
    add_srs_wkt (p, 8,
        "5],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",10000000]");
    add_srs_wkt (p, 10,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 11,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"32518\"]]");
    p = add_epsg_def_ex (filter, first, last, 32519, "epsg", 32519,
        "WGS 72BE / UTM zone 19S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=19 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 19S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",-6");
    add_srs_wkt (p, 8,
        "9],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",10000000]");
    add_srs_wkt (p, 10,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 11,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"32519\"]]");
    p = add_epsg_def_ex (filter, first, last, 32520, "epsg", 32520,
        "WGS 72BE / UTM zone 20S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 20S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",-6");
    add_srs_wkt (p, 8,
        "3],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",10000000]");
    add_srs_wkt (p, 10,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 11,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"32520\"]]");
    p = add_epsg_def_ex (filter, first, last, 32521, "epsg", 32521,
        "WGS 72BE / UTM zone 21S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=21 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 21S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",-5");
    add_srs_wkt (p, 8,
        "7],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",10000000]");
    add_srs_wkt (p, 10,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 11,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"32521\"]]");
    p = add_epsg_def_ex (filter, first, last, 32522, "epsg", 32522,
        "WGS 72BE / UTM zone 22S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=22 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 22S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",-5");
    add_srs_wkt (p, 8,
        "1],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",10000000]");
    add_srs_wkt (p, 10,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 11,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"32522\"]]");
    p = add_epsg_def_ex (filter, first, last, 32523, "epsg", 32523,
        "WGS 72BE / UTM zone 23S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=23 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 23S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",-4");
    add_srs_wkt (p, 8,
        "5],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",10000000]");
    add_srs_wkt (p, 10,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 11,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"32523\"]]");
    p = add_epsg_def_ex (filter, first, last, 32524, "epsg", 32524,
        "WGS 72BE / UTM zone 24S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=24 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 24S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",-3");
    add_srs_wkt (p, 8,
        "9],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",10000000]");
    add_srs_wkt (p, 10,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 11,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"32524\"]]");
    p = add_epsg_def_ex (filter, first, last, 32525, "epsg", 32525,
        "WGS 72BE / UTM zone 25S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=25 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 25S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",-3");
    add_srs_wkt (p, 8,
        "3],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",10000000]");
    add_srs_wkt (p, 10,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 11,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"32525\"]]");
    p = add_epsg_def_ex (filter, first, last, 32526, "epsg", 32526,
        "WGS 72BE / UTM zone 26S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=26 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 26S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",-2");
    add_srs_wkt (p, 8,
        "7],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",10000000]");
    add_srs_wkt (p, 10,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 11,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"32526\"]]");
    p = add_epsg_def_ex (filter, first, last, 32527, "epsg", 32527,
        "WGS 72BE / UTM zone 27S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=27 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 27S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",-2");
    add_srs_wkt (p, 8,
        "1],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",10000000]");
    add_srs_wkt (p, 10,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 11,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"32527\"]]");
    p = add_epsg_def_ex (filter, first, last, 32528, "epsg", 32528,
        "WGS 72BE / UTM zone 28S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=28 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 28S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",-1");
    add_srs_wkt (p, 8,
        "5],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",10000000]");
    add_srs_wkt (p, 10,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 11,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"32528\"]]");
    p = add_epsg_def_ex (filter, first, last, 32529, "epsg", 32529,
        "WGS 72BE / UTM zone 29S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=29 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 29S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",-9");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_e");
    add_srs_wkt (p, 9,
        "asting\",500000],PARAMETER[\"false_northing\",10000000],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 11,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"32529\"]]");
    p = add_epsg_def_ex (filter, first, last, 32530, "epsg", 32530,
        "WGS 72BE / UTM zone 30S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=30 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 30S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",-3");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_e");
    add_srs_wkt (p, 9,
        "asting\",500000],PARAMETER[\"false_northing\",10000000],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 11,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"32530\"]]");
    p = add_epsg_def_ex (filter, first, last, 32531, "epsg", 32531,
        "WGS 72BE / UTM zone 31S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=31 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 31S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",3]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_ea");
    add_srs_wkt (p, 9,
        "sting\",500000],PARAMETER[\"false_northing\",10000000],U");
    add_srs_wkt (p, 10,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eas");
    add_srs_wkt (p, 11,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"32531\"]]");
    p = add_epsg_def_ex (filter, first, last, 32532, "epsg", 32532,
        "WGS 72BE / UTM zone 32S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=32 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 32S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",9]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_ea");
    add_srs_wkt (p, 9,
        "sting\",500000],PARAMETER[\"false_northing\",10000000],U");
    add_srs_wkt (p, 10,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eas");
    add_srs_wkt (p, 11,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"32532\"]]");
    p = add_epsg_def_ex (filter, first, last, 32533, "epsg", 32533,
        "WGS 72BE / UTM zone 33S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=33 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 33S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",15");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_e");
    add_srs_wkt (p, 9,
        "asting\",500000],PARAMETER[\"false_northing\",10000000],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 11,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"32533\"]]");
    p = add_epsg_def_ex (filter, first, last, 32534, "epsg", 32534,
        "WGS 72BE / UTM zone 34S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=34 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 34S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",21");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_e");
    add_srs_wkt (p, 9,
        "asting\",500000],PARAMETER[\"false_northing\",10000000],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 11,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"32534\"]]");
    p = add_epsg_def_ex (filter, first, last, 32535, "epsg", 32535,
        "WGS 72BE / UTM zone 35S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=35 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 35S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",27");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_e");
    add_srs_wkt (p, 9,
        "asting\",500000],PARAMETER[\"false_northing\",10000000],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 11,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"32535\"]]");
    p = add_epsg_def_ex (filter, first, last, 32536, "epsg", 32536,
        "WGS 72BE / UTM zone 36S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=36 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 36S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",33");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_e");
    add_srs_wkt (p, 9,
        "asting\",500000],PARAMETER[\"false_northing\",10000000],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 11,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"32536\"]]");
    p = add_epsg_def_ex (filter, first, last, 32537, "epsg", 32537,
        "WGS 72BE / UTM zone 37S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=37 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 37S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",39");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_e");
    add_srs_wkt (p, 9,
        "asting\",500000],PARAMETER[\"false_northing\",10000000],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 11,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"32537\"]]");
    p = add_epsg_def_ex (filter, first, last, 32538, "epsg", 32538,
        "WGS 72BE / UTM zone 38S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=38 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 38S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",45");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_e");
    add_srs_wkt (p, 9,
        "asting\",500000],PARAMETER[\"false_northing\",10000000],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 11,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"32538\"]]");
    p = add_epsg_def_ex (filter, first, last, 32539, "epsg", 32539,
        "WGS 72BE / UTM zone 39S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=39 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 39S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",51");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_e");
    add_srs_wkt (p, 9,
        "asting\",500000],PARAMETER[\"false_northing\",10000000],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 11,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"32539\"]]");
    p = add_epsg_def_ex (filter, first, last, 32540, "epsg", 32540,
        "WGS 72BE / UTM zone 40S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=40 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 40S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",57");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_e");
    add_srs_wkt (p, 9,
        "asting\",500000],PARAMETER[\"false_northing\",10000000],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 11,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"32540\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

