-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

with SPARK.Ada.Text_IO;
with Sparklalr_Common;

--# inherit Command_Line_Options,
--#         SPARK.Ada.Text_IO,
--#         Sparklalr_Common,
--#         Sparklalr_Goto,
--#         Sparklalr_Memory,
--#         SPARK_Ada_Integer_Text_IO,
--#         Symbols_Dump;

package Sparklalr_Parser
--# own State;
is

   Pa_Table_Size : constant := 20000;

   subtype Pt_Pa_Rec is Natural range 0 .. Pa_Table_Size;

   procedure Init_Pa_List;
   --# global in out State;
   --# derives State from *;

   procedure Init_Pat_Count;
   --# global in out State;
   --# derives State from *;

   procedure Initialise;
   --# global out State;
   --# derives State from ;

   procedure Gen_State_Info;
   --# global in     Sparklalr_Memory.Stat_No;
   --#        in out State;
   --# derives State from *,
   --#                    Sparklalr_Memory.Stat_No;

   procedure Pa_Search (State_Index, Term_Index : in     Integer;
                        Result                  :    out Integer;
                        Pl                      :    out Pt_Pa_Rec);
   --# global in State;
   --# derives Pl,
   --#         Result from State,
   --#                     State_Index,
   --#                     Term_Index;

   procedure Pa_Insert (F                                  : in out SPARK.Ada.Text_IO.File_Type;
                        State_Index, Term_Index, Insertion : in     Integer);
   --# global in     Command_Line_Options.State;
   --#        in     Symbols_Dump.State;
   --#        in out SPARK.Ada.Text_IO.The_Standard_Output;
   --#        in out State;
   --# derives F                                     from *,
   --#                                                    Command_Line_Options.State,
   --#                                                    Symbols_Dump.State,
   --#                                                    Term_Index &
   --#         SPARK.Ada.Text_IO.The_Standard_Output from *,
   --#                                                    Command_Line_Options.State,
   --#                                                    Insertion,
   --#                                                    State_Index,
   --#                                                    Symbols_Dump.State,
   --#                                                    Term_Index &
   --#         State                                 from *,
   --#                                                    Insertion,
   --#                                                    State_Index,
   --#                                                    Term_Index;

   function Action_Equal (Act1, Act2 : in Pt_Pa_Rec) return Boolean;
   --# global in State;

   procedure Pa_Stats (Std_Out : in     Boolean;
                       F       : in out SPARK.Ada.Text_IO.File_Type);
   --# global in     State;
   --#        in out SPARK.Ada.Text_IO.The_Standard_Output;
   --# derives F,
   --#         SPARK.Ada.Text_IO.The_Standard_Output from *,
   --#                                                    State,
   --#                                                    Std_Out;

   procedure Dump_Actions (F      : in out SPARK.Ada.Text_IO.File_Type;
                           Nstate : in     Integer);
   --# global in     State;
   --#        in     Symbols_Dump.State;
   --#        in out SPARK.Ada.Text_IO.The_Standard_Output;
   --# derives F,
   --#         SPARK.Ada.Text_IO.The_Standard_Output from *,
   --#                                                    Nstate,
   --#                                                    State,
   --#                                                    Symbols_Dump.State;

   procedure Action_Gen (State_Var : in Integer);
   --# global in out State;
   --# derives State from *,
   --#                    State_Var;

   procedure Action_Gen_Pa_Out (F              : in out SPARK.Ada.Text_IO.File_Type;
                                State_Var      : in     Integer;
                                Curr_Pat_Index : in out Integer);
   --# global in     Sparklalr_Memory.Prod_Sum;
   --#        in     Symbols_Dump.State;
   --#        in out SPARK.Ada.Text_IO.The_Standard_Output;
   --#        in out State;
   --# derives Curr_Pat_Index,
   --#         State                                 from *,
   --#                                                    State,
   --#                                                    State_Var &
   --#         F                                     from *,
   --#                                                    Curr_Pat_Index,
   --#                                                    Sparklalr_Memory.Prod_Sum,
   --#                                                    State,
   --#                                                    State_Var,
   --#                                                    Symbols_Dump.State &
   --#         SPARK.Ada.Text_IO.The_Standard_Output from *,
   --#                                                    Sparklalr_Memory.Prod_Sum,
   --#                                                    State,
   --#                                                    State_Var,
   --#                                                    Symbols_Dump.State;

   procedure Action_Gen_Pa_Out_Sp
     (F              : in out SPARK.Ada.Text_IO.File_Type;
      State_Var      : in     Integer;
      Curr_Pat_Index : in out Integer);
   --# global in     Sparklalr_Memory.Prod_Sum;
   --#        in     Symbols_Dump.State;
   --#        in out SPARK.Ada.Text_IO.The_Standard_Output;
   --#        in out State;
   --# derives Curr_Pat_Index,
   --#         State                                 from *,
   --#                                                    State,
   --#                                                    State_Var &
   --#         F                                     from *,
   --#                                                    Curr_Pat_Index,
   --#                                                    Sparklalr_Memory.Prod_Sum,
   --#                                                    State,
   --#                                                    State_Var,
   --#                                                    Symbols_Dump.State &
   --#         SPARK.Ada.Text_IO.The_Standard_Output from *,
   --#                                                    Sparklalr_Memory.Prod_Sum,
   --#                                                    State,
   --#                                                    State_Var,
   --#                                                    Symbols_Dump.State;

   function Get_Reduce_State (S : in Sparklalr_Common.State_Range) return Boolean;
   --# global in State;

   function Get_Pat_Count return Integer;
   --# global in State;

   function Get_Pa_List (I : in Sparklalr_Common.State_Range) return Pt_Pa_Rec;
   --# global in State;

end Sparklalr_Parser;
