-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

with SPARK.Ada.Text_IO;

--# inherit SPARK.Ada.Text_IO,
--#         SPARK_Ada_Integer_Text_IO;

package Sparklalr_Common is

   Id_Length   : constant := 50;
   Max_Set     : constant := 255; -- MAXIMUM ORDINAL IN SET
   Line_Length : constant := 128;
   State_Max   : constant := 2047; -- MAXIMUM STATE NUMBER
   Prod_Lim    : constant := 1023; -- MAXIMUM PRODUCTION NUMBER
   Page_Width  : constant := 78; -- Maximum width of output files

   Term_Lim     : constant := Max_Set; -- MAXIMUM TERMINAL NUMBER
   Non_Term_Lim : constant := 511; -- MAXIMUM NUMBER OF NON-TERMINALS
   Max_Sym      : constant := 766; -- = TERM_LIM + NON_TERM_LIM
   Nt_Base      : constant := Term_Lim; -- NON-TERMINAL OFFSET FOR PRDN. TABLE

   Sp_Symbol_Str : constant String := "SP_Symbols.                                       ";

   type Action_Type is (Shift, Reduce);

   subtype Production_Count is Natural range 0 .. Prod_Lim;
   subtype Production_Index is Positive range 1 .. Prod_Lim;

   subtype Id_Length_Count is Natural range 0 .. Id_Length;
   subtype Id_Length_Range is Positive range 1 .. Id_Length;

   subtype Short_Int is Integer range -32767 .. 32767;
   subtype State_Range is Natural range 0 .. State_Max;
   subtype Id_Name is String (Id_Length_Range);

   subtype Term_Range is Natural range 0 .. Term_Lim;
   subtype Non_Term_Range is Positive range 1 .. Non_Term_Lim;
   subtype Sym_Range is Integer range -1 .. Max_Sym;

   procedure Put_File_Output (Std_Out : in     Boolean;
                              File    : in out SPARK.Ada.Text_IO.File_Type;
                              Item    : in     String);
   --# global in out SPARK.Ada.Text_IO.The_Standard_Output;
   --# derives File,
   --#         SPARK.Ada.Text_IO.The_Standard_Output from *,
   --#                                                    Item,
   --#                                                    Std_Out;

   procedure Put_Character_File_Output (Std_Out : in     Boolean;
                                        File    : in out SPARK.Ada.Text_IO.File_Type;
                                        Item    : in     Character);
   --# global in out SPARK.Ada.Text_IO.The_Standard_Output;
   --# derives File,
   --#         SPARK.Ada.Text_IO.The_Standard_Output from *,
   --#                                                    Item,
   --#                                                    Std_Out;

   procedure Put_Line_File_Output (Std_Out : in     Boolean;
                                   File    : in out SPARK.Ada.Text_IO.File_Type;
                                   Item    : in     String);
   --# global in out SPARK.Ada.Text_IO.The_Standard_Output;
   --# derives File,
   --#         SPARK.Ada.Text_IO.The_Standard_Output from *,
   --#                                                    Item,
   --#                                                    Std_Out;

   procedure Put_Integer_File_Output
     (Std_Out : in     Boolean;
      File    : in out SPARK.Ada.Text_IO.File_Type;
      Item    : in     Integer;
      Width   : in     SPARK.Ada.Text_IO.Field);
   --# global in out SPARK.Ada.Text_IO.The_Standard_Output;
   --# derives File,
   --#         SPARK.Ada.Text_IO.The_Standard_Output from *,
   --#                                                    Item,
   --#                                                    Std_Out,
   --#                                                    Width;

   procedure New_Line_File_Output (Std_Out : in     Boolean;
                                   File    : in out SPARK.Ada.Text_IO.File_Type);
   --# global in out SPARK.Ada.Text_IO.The_Standard_Output;
   --# derives File,
   --#         SPARK.Ada.Text_IO.The_Standard_Output from *,
   --#                                                    Std_Out;

   -- Puts C to Fil N times.  N can be zero.
   procedure Put_N_Chars
     (Std_Out : in     Boolean;
      F       : in out SPARK.Ada.Text_IO.File_Type;
      C       : in     Character;
      N       : in     Natural);
   --# global in out SPARK.Ada.Text_IO.The_Standard_Output;
   --# derives F,
   --#         SPARK.Ada.Text_IO.The_Standard_Output from *,
   --#                                                    C,
   --#                                                    N,
   --#                                                    Std_Out;

   procedure Print
     (Std_Out : in     Boolean;
      F       : in out SPARK.Ada.Text_IO.File_Type;
      String1 : in     String;
      Posn    : in out Integer;
      Tab     : in     Integer;
      Comm    : in     Boolean);
   --# global in out SPARK.Ada.Text_IO.The_Standard_Output;
   --# derives F,
   --#         SPARK.Ada.Text_IO.The_Standard_Output from *,
   --#                                                    Comm,
   --#                                                    Posn,
   --#                                                    Std_Out,
   --#                                                    String1,
   --#                                                    Tab &
   --#         Posn                                  from *,
   --#                                                    String1,
   --#                                                    Tab;

   procedure Print2
     (F       : in out SPARK.Ada.Text_IO.File_Type;
      String1 : in     String;
      String2 : in     String;
      Posn    : in out Integer;
      Tab     : in     Integer;
      Comm    : in     Boolean);
   --# global in out SPARK.Ada.Text_IO.The_Standard_Output;
   --# derives F,
   --#         SPARK.Ada.Text_IO.The_Standard_Output from *,
   --#                                                    Comm,
   --#                                                    Posn,
   --#                                                    String1,
   --#                                                    String2,
   --#                                                    Tab &
   --#         Posn                                  from *,
   --#                                                    String1,
   --#                                                    String2,
   --#                                                    Tab;

   function Code (Sr : in Action_Type;
                  C  : in Integer) return Integer;

   function Decode (C : in Integer) return Integer;

end Sparklalr_Common;
