-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

with E_Strings;

--# inherit E_Strings;

package Command_Line is
   subtype Memory_Limit_T is Natural range Natural'First .. Natural'Last / 1024;

   type Solver_T is (Alt_Ergo, CVC3, Yices, Z3);

   type Command_Line_Data_T is record
      Unit_Name    : E_Strings.T;
      Time_Out     : Natural;
      Memory_Limit : Memory_Limit_T; --  In MiB as opposed to kbytes
      Ignore_SIV   : Boolean;
      Plain        : Boolean;
      Show_Help    : Boolean;
      Solver       : Solver_T;
   end record;

   --  Parse command line arguments and options.
   procedure Initialize (Data  : out Command_Line_Data_T;
                         Ok    : out Boolean;
                         Error : out E_Strings.T);

   --  Set the exit status of the program to a non-zero value.
   procedure Set_Exit_Status_Error;

end Command_Line;
