-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (Sem.CompUnit)
procedure wf_tilde
  (Node    : in     STree.SyntaxNode;
   Scope   : in     Dictionary.Scopes;
   EStack  : in out ExpStack.ExpStackType;
   Context : in     Anno_Tilde_Context) is
   StackTop           : Exp_Record;
   SubprogSym, TopSym : Dictionary.Symbol;
   Abstraction        : Dictionary.Abstractions;

begin
   case Context is
      when Precondition =>  -- Tilde not allowed at all
         ExpStack.Pop (StackTop, EStack);
         StackTop.Errors_In_Expression := True;
         ExpStack.Push (StackTop, EStack);
         ErrorHandler.Semantic_Error
           (Err_Num   => 321,
            Reference => ErrorHandler.No_Reference,
            Position  => Node_Position (Node => Node),
            Id_Str    => LexTokenManager.Null_String);
      when FunctionReturn => -- tilde only allowed on imported "stream" variables
         ExpStack.Pop (StackTop, EStack);
         TopSym := StackTop.Other_Symbol;
         -- the test below is sufficient to identify a gloabl of the function which is of mode IN.
         -- This is because eternal variables cannot appear as parameters AND
         -- external variable sof mode OUT cannot be referenced.  Therefore a  variable which is
         -- visible in a function return annotation and which has a mode must be a global of external IN mode.
         if not Dictionary.IsOwnVariableOrConstituentWithMode (TopSym) then
            StackTop.Errors_In_Expression := True;
            ErrorHandler.Semantic_Error
              (Err_Num   => 317,
               Reference => ErrorHandler.No_Reference,
               Position  => Node_Position (Node => Node),
               Id_Str    => LexTokenManager.Null_String);
         end if;
         ExpStack.Push (StackTop, EStack);
      when Postcondition =>  -- Tilde may be allowed
         ExpStack.Pop (StackTop, EStack);
         if StackTop.Sort = Is_Object then -- May be ok, further checks required
            TopSym := StackTop.Other_Symbol;
            if not Dictionary.IsVariable (TopSym) then
               StackTop.Errors_In_Expression := True;
               ErrorHandler.Semantic_Error
                 (Err_Num   => 318,
                  Reference => ErrorHandler.No_Reference,
                  Position  => Node_Position (Node => Node),
                  Id_Str    => LexTokenManager.Null_String);

            elsif StackTop.Type_Symbol /= Dictionary.GetType (TopSym) then
               -- New check that variable is entire
               StackTop.Errors_In_Expression := True;
               ErrorHandler.Semantic_Error
                 (Err_Num   => 320,
                  Reference => ErrorHandler.No_Reference,
                  Position  => Node_Position (Node => Node),
                  Id_Str    => LexTokenManager.Null_String);
            else
               -- It is an entire variable so further checks required
               SubprogSym  := Dictionary.GetEnclosingCompilationUnit (Scope);
               Abstraction := Dictionary.GetAbstraction (SubprogSym, Scope);
               if not (Dictionary.IsImport (Abstraction, SubprogSym, TopSym) and
                         Dictionary.IsExport (Abstraction, SubprogSym, TopSym)) then
                  StackTop.Errors_In_Expression := True;
                  ErrorHandler.Semantic_Error
                    (Err_Num   => 319,
                     Reference => ErrorHandler.No_Reference,
                     Position  => Node_Position (Node => Node),
                     Id_Str    => LexTokenManager.Null_String);
               end if;
            end if;
         else -- Cannot be ok so error message needed
            StackTop.Errors_In_Expression := True;
            if not (StackTop.Sort = Is_Unknown) then
               -- Supress error for unknown things
               ErrorHandler.Semantic_Error
                 (Err_Num   => 318,
                  Reference => ErrorHandler.No_Reference,
                  Position  => Node_Position (Node => Node),
                  Id_Str    => LexTokenManager.Null_String);
            end if;
         end if;
         ExpStack.Push (StackTop, EStack);
   end case;

end wf_tilde;
