-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

-- Overview:
-- Loops through all visible_part_rep below visible_part (passed in as Node)
-- calls approriate wf for NextDerivative node of each.  Cannot directly
-- raise any errors but called procedures can.
----------------------------------------------------------------------------

separate (Sem.CompUnit.Wf_Package_Specification)
procedure Wf_Visible (Node          : in STree.SyntaxNode;
                      Pack_Sym      : in Dictionary.Symbol;
                      Current_Scope : in Dictionary.Scopes) is
   Next_Node, Node_To_Check : STree.SyntaxNode;
   Unused                   : Dictionary.Symbol;

   ------------------------------------------------------------------------

   procedure Wf_Private_Type_Declaration
     (Node          : in STree.SyntaxNode;
      Pack_Sym      : in Dictionary.Symbol;
      Current_Scope : in Dictionary.Scopes)
   --# global in     CommandLineData.Content;
   --#        in     ContextManager.Ops.Unit_Stack;
   --#        in     LexTokenManager.State;
   --#        in out Dictionary.Dict;
   --#        in out ErrorHandler.Error_Context;
   --#        in out SPARK_IO.File_Sys;
   --#        in out STree.Table;
   --# derives Dictionary.Dict            from *,
   --#                                         ContextManager.Ops.Unit_Stack,
   --#                                         Current_Scope,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         Pack_Sym,
   --#                                         STree.Table &
   --#         ErrorHandler.Error_Context from *,
   --#                                         CommandLineData.Content,
   --#                                         Current_Scope,
   --#                                         Dictionary.Dict,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         SPARK_IO.File_Sys,
   --#                                         STree.Table &
   --#         SPARK_IO.File_Sys          from *,
   --#                                         CommandLineData.Content,
   --#                                         ContextManager.Ops.Unit_Stack,
   --#                                         Current_Scope,
   --#                                         Dictionary.Dict,
   --#                                         ErrorHandler.Error_Context,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         Pack_Sym,
   --#                                         STree.Table &
   --#         STree.Table                from *,
   --#                                         Current_Scope,
   --#                                         Dictionary.Dict,
   --#                                         LexTokenManager.State,
   --#                                         Node;
      is separate;

   ------------------------------------------------------------------------

   procedure Wf_Deferred
     (Node          : in STree.SyntaxNode;
      Pack_Sym      : in Dictionary.Symbol;
      Current_Scope : in Dictionary.Scopes)
   --# global in     CommandLineData.Content;
   --#        in     ContextManager.Ops.Unit_Stack;
   --#        in     LexTokenManager.State;
   --#        in out Dictionary.Dict;
   --#        in out ErrorHandler.Error_Context;
   --#        in out SPARK_IO.File_Sys;
   --#        in out STree.Table;
   --# derives Dictionary.Dict            from *,
   --#                                         CommandLineData.Content,
   --#                                         ContextManager.Ops.Unit_Stack,
   --#                                         Current_Scope,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         Pack_Sym,
   --#                                         STree.Table &
   --#         ErrorHandler.Error_Context,
   --#         SPARK_IO.File_Sys          from CommandLineData.Content,
   --#                                         ContextManager.Ops.Unit_Stack,
   --#                                         Current_Scope,
   --#                                         Dictionary.Dict,
   --#                                         ErrorHandler.Error_Context,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         Pack_Sym,
   --#                                         SPARK_IO.File_Sys,
   --#                                         STree.Table &
   --#         STree.Table                from *,
   --#                                         CommandLineData.Content,
   --#                                         Current_Scope,
   --#                                         Dictionary.Dict,
   --#                                         LexTokenManager.State,
   --#                                         Node;
      is separate;

begin -- Wf_Visible

   -- ASSUME Node = visible_part_rep
   SystemErrors.RT_Assert
     (C       => Syntax_Node_Type (Node => Node) = SPSymbols.visible_part_rep,
      Sys_Err => SystemErrors.Invalid_Syntax_Tree,
      Msg     => "Expect Node = visible_part_rep in Wf_Visible");

   Next_Node := Last_Child_Of (Start_Node => Node);
   -- ASSUME Next_Node = visible_part_rep
   SystemErrors.RT_Assert
     (C       => Syntax_Node_Type (Node => Next_Node) = SPSymbols.visible_part_rep,
      Sys_Err => SystemErrors.Invalid_Syntax_Tree,
      Msg     => "Expect Next_Node = visible_part_rep in Wf_Visible");
   while Next_Node /= Node loop
      Node_To_Check := Next_Sibling (Next_Node);
      -- ASSUME Node_To_Check = basic_declarative_item OR private_type_declaration OR
      --                        deferred_constant_declaration OR subprogram_declaration OR
      --                        generic_subprogram_instantiation OR apragma OR renaming_declaration
      if Syntax_Node_Type (Node => Node_To_Check) = SPSymbols.basic_declarative_item then
         -- ASSUME Node_To_Check = basic_declarative_item
         Wf_Basic_Declarative_Item (Node          => Node_To_Check,
                                    Current_Scope => Current_Scope);
      elsif Syntax_Node_Type (Node => Node_To_Check) = SPSymbols.private_type_declaration then
         -- ASSUME Node_To_Check = private_type_declaration
         Wf_Private_Type_Declaration (Node          => Node_To_Check,
                                      Pack_Sym      => Pack_Sym,
                                      Current_Scope => Current_Scope);
      elsif Syntax_Node_Type (Node => Node_To_Check) = SPSymbols.deferred_constant_declaration then
         -- ASSUME Node_To_Check = deferred_constant_declaration
         Wf_Deferred (Node          => Node_To_Check,
                      Pack_Sym      => Pack_Sym,
                      Current_Scope => Current_Scope);
      elsif Syntax_Node_Type (Node => Node_To_Check) = SPSymbols.subprogram_declaration then
         -- ASSUME Node_To_Check = subprogram_declaration
         --# accept Flow, 10, Unused, "Expected ineffective assignment";
         Wf_Subprogram_Declaration (Node            => Node_To_Check,
                                    Current_Scope   => Current_Scope,
                                    The_Subprog_Sym => Unused);
         --# end accept;
      elsif Syntax_Node_Type (Node => Node_To_Check) = SPSymbols.generic_subprogram_instantiation then
         -- ASSUME Node_To_Check = generic_subprogram_instantiation
         wf_generic_subprogram_instantiation (Node_To_Check, Current_Scope);
      elsif Syntax_Node_Type (Node => Node_To_Check) = SPSymbols.apragma then
         -- ASSUME Node_To_Check = apragma
         wf_pragma (Node_To_Check, Current_Scope);
      elsif Syntax_Node_Type (Node => Node_To_Check) = SPSymbols.renaming_declaration then
         -- ASSUME Node_To_Check = renaming_declaration
         Wf_Renaming_Declaration (Node  => Node_To_Check,
                                  Scope => Current_Scope);
      else
         SystemErrors.Fatal_Error
           (Sys_Err => SystemErrors.Invalid_Syntax_Tree,
            Msg     => "Expect Node_To_Check = basic_declarative_item OR private_type_declaration OR deferred_constant_declaration OR subprogram_declaration OR generic_subprogram_instantiation OR apragma OR renaming_declaration in Wf_Visible");
      end if;
      Next_Node := Parent_Node (Current_Node => Next_Node);
   end loop;
   --# accept Flow, 33, Unused, "Expected to be neither referenced nor exported";
end Wf_Visible;
