-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (Sem.CompUnit.Wf_Package_Specification)
procedure CheckStateCanBeInitialized (PackSym  : in Dictionary.Symbol;
                                      AnnoNode : in STree.SyntaxNode) is
   OwnVarIt  : Dictionary.Iterator;
   OwnVarSym : Dictionary.Symbol;

   function PureExportProcedureExists (Sym : Dictionary.Symbol) return Boolean
   --# global in Dictionary.Dict;
   --#        in PackSym;
   is
      Result : Boolean;

      function PureExportProcedureExistsLocal (It : Dictionary.Iterator) return Boolean
      --# global in Dictionary.Dict;
      --#        in Sym;
      is
         Result     : Boolean := False;
         SubprogSym : Dictionary.Symbol;
         LocalIt    : Dictionary.Iterator;

         function IsProcedureOrTask (Sym : Dictionary.Symbol) return Boolean
         --# global in Dictionary.Dict;
         is
         begin
            return Dictionary.IsProcedure (Sym) or else (Dictionary.IsType (Sym) and then Dictionary.TypeIsTask (Sym));
         end IsProcedureOrTask;

      begin
         LocalIt := It;
         while not Dictionary.IsNullIterator (LocalIt) loop
            SubprogSym := Dictionary.CurrentSymbol (LocalIt);
            Result     := IsProcedureOrTask (SubprogSym)
              and then Dictionary.IsExport (Dictionary.IsAbstract, SubprogSym, Sym)
              and then not Dictionary.IsImport (Dictionary.IsAbstract, SubprogSym, Sym);

            exit when Result;

            LocalIt := Dictionary.NextSymbol (LocalIt);
         end loop;
         return Result;
      end PureExportProcedureExistsLocal;

   begin -- PureExportProcedureExists
      Result := PureExportProcedureExistsLocal (Dictionary.FirstVisibleSubprogram (PackSym))
        or else PureExportProcedureExistsLocal (Dictionary.FirstPrivateSubprogram (PackSym));
      if not Result then
         Result := PureExportProcedureExistsLocal (Dictionary.FirstVisibleTaskType (PackSym));
      end if;
      return Result;
   end PureExportProcedureExists;

   -----------------------------------------------------

   procedure IssueWarning (Sym : in Dictionary.Symbol)
   --# global in     AnnoNode;
   --#        in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.State;
   --#        in     STree.Table;
   --#        in out ErrorHandler.Error_Context;
   --#        in out SPARK_IO.File_Sys;
   --# derives ErrorHandler.Error_Context,
   --#         SPARK_IO.File_Sys          from AnnoNode,
   --#                                         CommandLineData.Content,
   --#                                         Dictionary.Dict,
   --#                                         ErrorHandler.Error_Context,
   --#                                         LexTokenManager.State,
   --#                                         SPARK_IO.File_Sys,
   --#                                         STree.Table,
   --#                                         Sym;
   is
      function PlaceToReportError (OwnVarName : LexTokenManager.Lex_String) return LexTokenManager.Token_Position
      --# global in AnnoNode;
      --#        in LexTokenManager.State;
      --#        in STree.Table;
      is
         Result                 : LexTokenManager.Token_Position;
         SearchNode, OwnVarNode : STree.SyntaxNode;
         It                     : STree.Iterator;

      begin
         -- set up default answer.  In practice the loop below should always find the
         -- actual location of an own variable.  If something goes wrong the default
         -- result will point at the end of the package specification
         Result := Node_Position (Node => Last_Sibling_Of (Start_Node => AnnoNode));

         SearchNode := Child_Node (AnnoNode); -- point to own_var_clause

         It := Find_First_Node (Node_Kind    => SPSymbols.own_variable,
                                From_Root    => SearchNode,
                                In_Direction => STree.Down);

         while not STree.IsNull (It) loop
            OwnVarNode := Get_Node (It => It);
            -- check whether the own variable at this point is the one we are looking for
            if LexTokenManager.Lex_String_Case_Insensitive_Compare
              (Lex_Str1 => Node_Lex_String (Node => Last_Child_Of (Start_Node => OwnVarNode)),
               Lex_Str2 => OwnVarName) =
              LexTokenManager.Str_Eq then
               Result := Node_Position (Node => OwnVarNode);
               exit; -- normal exit condition
            end if;
            It := STree.NextNode (It);
         end loop;
         return Result;
      end PlaceToReportError;

   begin -- IssueWarning
      ErrorHandler.Semantic_Warning
        (Err_Num  => 398,
         Position => PlaceToReportError (Dictionary.GetSimpleName (Sym)),
         Id_Str   => Dictionary.GetSimpleName (Sym));
   end IssueWarning;

   -----------------------------------------------------

begin --CheckStateCanBeInitialized
   OwnVarIt := Dictionary.FirstOwnVariable (PackSym);
   while not Dictionary.IsNullIterator (OwnVarIt)  -- exit when no more owns
   loop
      OwnVarSym := Dictionary.CurrentSymbol (OwnVarIt);

      -- if own variable initialized at declaration we don't have to consider
      -- it any further
      if not Dictionary.OwnVariableIsInitialized (OwnVarSym) then
         -- if own variable is moded then it does not need initializing
         if Dictionary.GetOwnVariableMode (OwnVarSym) = Dictionary.DefaultMode then
            -- if it is declared in the visible part we don't have to worry about it
            if not Dictionary.IsDeclared (OwnVarSym) then
               -- if we get here we are interested in whether there is a subprogram which
               -- exports OwnVarSym without also importing it
               if not PureExportProcedureExists (OwnVarSym) then
                  IssueWarning (OwnVarSym);
               end if;
            end if;
         end if;
      end if;
      OwnVarIt := Dictionary.NextSymbol (OwnVarIt);
   end loop;
end CheckStateCanBeInitialized;
