-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (Sem.CompUnit)
procedure wf_package_initialization (Node  : in STree.SyntaxNode;
                                     Scope : in Dictionary.Scopes) is

   StmtNode : STree.SyntaxNode;
   IdentStr : LexTokenManager.Lex_String;
   PackSym  : Dictionary.Symbol;

   ----------------------------------------------------------------

   procedure CheckWhetherInitializationWasNeeded
     (PackSym  : in Dictionary.Symbol;
      Node     : in STree.SyntaxNode;
      IdentStr : in LexTokenManager.Lex_String)
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.State;
   --#        in     STree.Table;
   --#        in out ErrorHandler.Error_Context;
   --#        in out SPARK_IO.File_Sys;
   --# derives ErrorHandler.Error_Context,
   --#         SPARK_IO.File_Sys          from CommandLineData.Content,
   --#                                         Dictionary.Dict,
   --#                                         ErrorHandler.Error_Context,
   --#                                         IdentStr,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         PackSym,
   --#                                         SPARK_IO.File_Sys,
   --#                                         STree.Table;
   is
      ConstituentList, InitOwnVarList : Dictionary.Iterator;
      InitPartNeeded                  : Boolean;
      InitOwnVarSym                   : Dictionary.Symbol;

   begin
      InitPartNeeded := False;
      InitOwnVarList := Dictionary.FirstInitializedOwnVariable (PackSym);
      while not Dictionary.IsNullIterator (InitOwnVarList) loop
         InitOwnVarSym := Dictionary.CurrentSymbol (InitOwnVarList);
         if Dictionary.IsConcreteOwnVariable (InitOwnVarSym) then
            -- filter out own vars initialized at declaration
            if not Dictionary.VariableIsInitialized (InitOwnVarSym) then
               InitPartNeeded := True;
            end if;
         else
            ConstituentList := Dictionary.FirstConstituent (InitOwnVarSym);
            while not Dictionary.IsNullIterator (ConstituentList) loop
               if (not Dictionary.IsOwnVariable (Dictionary.CurrentSymbol (ConstituentList)))
                 and then (not Dictionary.VariableIsInitialized (Dictionary.CurrentSymbol (ConstituentList))) then
                  InitPartNeeded := True;
                  exit;
               end if;
               ConstituentList := Dictionary.NextSymbol (ConstituentList);
            end loop;
         end if;
         exit when InitPartNeeded;
         InitOwnVarList := Dictionary.NextSymbol (InitOwnVarList);
      end loop;

      if not InitPartNeeded then
         ErrorHandler.Semantic_Error
           (Err_Num   => 66,
            Reference => ErrorHandler.No_Reference,
            Position  => Node_Position (Node => Node),
            Id_Str    => IdentStr);
      end if;
   end CheckWhetherInitializationWasNeeded;

   ----------------------------------------------------------------

   function NullInitialization (Node : STree.SyntaxNode) return Boolean
   --# global in STree.Table;
   is
   begin
      return Syntax_Node_Type (Node => Child_Node (Child_Node (Node))) = SPSymbols.statement
        and then Syntax_Node_Type (Node => Child_Node (Child_Node (Child_Node (Child_Node (Node))))) =
        SPSymbols.null_statement;
   end NullInitialization;

   ----------------------------------------------------------------

begin --wf_package_initialization
   PackSym  := Dictionary.GetRegion (Scope);
   IdentStr := Dictionary.GetSimpleName (PackSym);
   StmtNode := Child_Node (Node);

   if Syntax_Node_Type (Node => StmtNode) = SPSymbols.hidden_part then
      ErrorHandler.Hidden_Text
        (Position => Node_Position (Node => StmtNode),
         Unit_Str => IdentStr,
         Unit_Typ => SPSymbols.package_initialization);
   else -- not hidden so check whether it was necessary
      if not NullInitialization (Node) then
         CheckWhetherInitializationWasNeeded (PackSym, Node, IdentStr);
      end if;
   end if;
end wf_package_initialization;
