-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (Sem.CompUnit)
procedure up_wf_task_body (Node  : in     STree.SyntaxNode;
                           Scope : in out Dictionary.Scopes) is
   TaskSym     : Dictionary.Symbol;
   EndNode     : STree.SyntaxNode;
   EndNodeType : SPSymbols.SPSymbol;

   procedure CheckForEndlessLoop (Node : in STree.SyntaxNode)
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.State;
   --#        in     STree.Table;
   --#        in     TaskSym;
   --#        in out ErrorHandler.Error_Context;
   --#        in out SPARK_IO.File_Sys;
   --# derives ErrorHandler.Error_Context,
   --#         SPARK_IO.File_Sys          from CommandLineData.Content,
   --#                                         Dictionary.Dict,
   --#                                         ErrorHandler.Error_Context,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         SPARK_IO.File_Sys,
   --#                                         STree.Table,
   --#                                         TaskSym;
   is
      CurrentNode : STree.SyntaxNode;
      LastLoop    : Dictionary.Symbol;

      function LastStatementFromEndDesignator (Node : STree.SyntaxNode) return STree.SyntaxNode
      --# global in STree.Table;
      is
         Result : STree.SyntaxNode;
      begin
         Result := Child_Node (Parent_Node (Current_Node => Node)); -- pragma_rep
         Result := Next_Sibling (Result); -- declarative_part or seq_of_stat or hidden_part
         if Syntax_Node_Type (Node => Result) /= SPSymbols.hidden_part then -- If whole body hidden, allow to propagate

            if Syntax_Node_Type (Node => Result) /= SPSymbols.sequence_of_statements then
               Result := Next_Sibling (Result); -- seq_of_stat
            end if;
            Result := Child_Node (Result); -- statement or seq_of_stat
            if Syntax_Node_Type (Node => Child_Node (Next_Sibling (Result))) = SPSymbols.justification_statement then

               Result := Child_Node (Result); -- seq_of_stat
            end if;
            if Syntax_Node_Type (Node => Result) /= SPSymbols.statement then
               Result := Next_Sibling (Result); -- statement
            end if;

         end if;
         return Result;
      end LastStatementFromEndDesignator;

   begin -- CheckForEndlessLoop
      CurrentNode := LastStatementFromEndDesignator (Node);
      if Syntax_Node_Type (Node => Child_Node (Child_Node (CurrentNode))) = SPSymbols.loop_statement then
         -- check loop has no exits
         LastLoop := Dictionary.LastMostEnclosingLoop (TaskSym);
         if LastLoop /= Dictionary.NullSymbol and then Dictionary.GetLoopHasExits (LastLoop) then
            ErrorHandler.Semantic_Error
              (Err_Num   => 989,
               Reference => ErrorHandler.No_Reference,
               Position  => Node_Position (Node => Node),
               Id_Str    => LexTokenManager.Null_String);
         end if;
      elsif Syntax_Node_Type (Node => CurrentNode) = SPSymbols.hidden_part then -- Whole body hidden
         null;
      else -- last statement not a loop
         ErrorHandler.Semantic_Error
           (Err_Num   => 989,
            Reference => ErrorHandler.No_Reference,
            Position  => Node_Position (Node => Node),
            Id_Str    => LexTokenManager.Null_String);
      end if;
   end CheckForEndlessLoop;

   ----------------------------------------------------------------------

begin
   TaskSym := Dictionary.GetRegion (Scope);
   EndNode := Last_Sibling_Of (Start_Node => Child_Node (Next_Sibling (Next_Sibling (Child_Node (Node)))));

   -- Check last statement is a plain loop
   EndNodeType := Syntax_Node_Type (Node => EndNode);
   if EndNodeType = SPSymbols.designator or else EndNodeType = SPSymbols.hidden_part then
      CheckForEndlessLoop (EndNode);
   end if;

   CheckSuspendsListAccountedFor (TaskSym, Node);

   -- step out to enclosing scope for continued tree walk
   Scope := Dictionary.GetEnclosingScope (Scope);
end up_wf_task_body;
