-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

with SPARK_IO;

separate (Sem.CompUnit)
procedure down_wf_name_argument_list
  (Node         : in     STree.SyntaxNode;
   Scope        : in     Dictionary.Scopes;
   EStack       : in out ExpStack.ExpStackType;
   HeapParam    : in out Lists.List_Heap;
   Next_Node    :    out STree.SyntaxNode;
   IsAnnotation : in     Boolean) is
   EXP_LOOKUP       : constant Annotation_Symbol_Table :=
     Annotation_Symbol_Table'(False => SPSymbols.expression,
                              True  => SPSymbols.annotation_expression);
   POS_ASSOC_LOOKUP : constant Annotation_Symbol_Table :=
     Annotation_Symbol_Table'
     (False => SPSymbols.positional_argument_association,
      True  => SPSymbols.annotation_positional_argument_association);

   TypeInfo : Exp_Record;
   Ptr      : Lists.List;

begin
   ExpStack.Pop (TypeInfo, EStack);

   case TypeInfo.Sort is
      when Is_Unknown =>
         TypeInfo  := UnknownSymbolRecord;
         Next_Node := STree.NullNode;

      when Is_Type_Mark =>

         if Syntax_Node_Type (Node => Child_Node (Child_Node (Node))) = EXP_LOOKUP (IsAnnotation) then
            Next_Node := Child_Node (Current_Node => Node);
         else
            TypeInfo := UnknownSymbolRecord;
            ErrorHandler.Semantic_Error
              (Err_Num   => 32,
               Reference => ErrorHandler.No_Reference,
               Position  => Node_Position (Node => Parent_Node (Current_Node => Node)),
               Id_Str    => LexTokenManager.Null_String);
            Next_Node := STree.NullNode;
         end if;

      when Is_Function =>
         if Syntax_Node_Type (Node => Child_Node (Node)) = POS_ASSOC_LOOKUP (IsAnnotation) then
            TypeInfo.Param_Count := 0;
         else
            CreateNameList (Ptr, HeapParam);
            TypeInfo.Param_List := Ptr;
         end if;
         if not IsAnnotation then
            TypeInfo.Arg_List_Found := True;
         end if;
         Next_Node := Child_Node (Current_Node => Node);

      when Is_Object =>
         if Dictionary.IsArrayTypeMark (TypeInfo.Type_Symbol, Scope) then

            if Syntax_Node_Type (Node => Child_Node (Node)) = POS_ASSOC_LOOKUP (IsAnnotation) then
               TypeInfo.Param_Count := 0;
               TypeInfo.Is_Static   := False;
               if not IsAnnotation then
                  TypeInfo.Arg_List_Found := True;
               end if;
               Next_Node := Child_Node (Current_Node => Node);
            else
               TypeInfo := UnknownSymbolRecord;
               ErrorHandler.Semantic_Error
                 (Err_Num   => 92,
                  Reference => ErrorHandler.No_Reference,
                  Position  => Node_Position (Node => Node),
                  Id_Str    => LexTokenManager.Null_String);
               Next_Node := STree.NullNode;
            end if;
         else
            TypeInfo := UnknownSymbolRecord;
            ErrorHandler.Semantic_Error
              (Err_Num   => 21,
               Reference => ErrorHandler.No_Reference,
               Position  => Node_Position (Node => Parent_Node (Current_Node => Node)),
               Id_Str    => LexTokenManager.Null_String);
            Next_Node := STree.NullNode;
         end if;

      when others =>
         TypeInfo := UnknownSymbolRecord;
         ErrorHandler.Semantic_Error
           (Err_Num   => 21,
            Reference => ErrorHandler.No_Reference,
            Position  => Node_Position (Node => Parent_Node (Current_Node => Node)),
            Id_Str    => LexTokenManager.Null_String);
         Next_Node := STree.NullNode;
   end case;

   ExpStack.Push (TypeInfo, EStack);

end down_wf_name_argument_list;
