-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (Sem.CompUnit)
procedure CreateInterruptStreamVariable
  (ForPO             : in Dictionary.Symbol;
   TheHandler        : in LexTokenManager.Lex_String;
   TheStreamVariable : in LexTokenManager.Lex_String;
   ErrorNode         : in STree.SyntaxNode) is

   Sym          : Dictionary.Symbol;
   TypeSym      : Dictionary.Symbol;
   SubprogSym   : Dictionary.Symbol;
   UnusedSymbol : Dictionary.Symbol;
   Scope        : Dictionary.Scopes;
   Found        : Boolean;
   It           : Dictionary.Iterator;

begin
   TypeSym := Dictionary.GetType (ForPO);
   Scope   := Dictionary.GetScope (ForPO);

   It    := Dictionary.FirstVisibleSubprogram (TypeSym);
   Found := False;

   -- For all the subprograms in protected type
   while (not Found) and (not Dictionary.IsNullIterator (It)) loop
      SubprogSym := Dictionary.CurrentSymbol (It);

      -- Is it an interrupt handler?
      if Dictionary.IsInterruptHandler (SubprogSym) then

         -- Does the interrupt handler name in the type match the one in the
         -- interrupt property?
         if LexTokenManager.Lex_String_Case_Insensitive_Compare
           (Lex_Str1 => Dictionary.GetSimpleName (SubprogSym),
            Lex_Str2 => TheHandler) =
           LexTokenManager.Str_Eq then

            Found := True;

            -- Check the stream name to which it is mapped is not being used
            -- in this scope.
            Sym := Dictionary.LookupItem (Name              => TheStreamVariable,
                                          Scope             => Scope,
                                          Context           => Dictionary.ProofContext,
                                          Full_Package_Name => False);

            if Sym = Dictionary.NullSymbol then
               -- Create the implicit own variable
               --# accept Flow, 10, UnusedSymbol, "Expected ineffective assignment";
               Dictionary.AddOwnVariable     -- expect ineffective assignment
                 (Name              => TheStreamVariable,
                  ThePackage        => Dictionary.GetOwner (ForPO),
                  Mode              => Dictionary.InMode,
                  IsProtected       => False,
                  IsInterruptStream => True,
                  Comp_Unit         => ContextManager.NullUnit,
                  Reference         => Dictionary.Location'(Start_Position => LexTokenManager.Token_Position'(Start_Line_No => 0,
                                                                                                              Start_Pos     => 0),
                                                            End_Position   => LexTokenManager.Token_Position'(Start_Line_No => 0,
                                                                                                              Start_Pos     => 0)),
                  Variable          => UnusedSymbol);
               --# end accept;

            elsif not (Dictionary.IsOwnVariable (Sym) and then Dictionary.GetOwnVariableIsInterruptStream (Sym)) then
               -- The stream name is being used and is not an interrupt stream. Interrupt streams
               -- can be mapped to more than one handler.
               ErrorHandler.Semantic_Error2
                 (Err_Num   => 954,
                  Reference => ErrorHandler.No_Reference,
                  Position  => Node_Position (Node => ErrorNode),
                  Id_Str1   => Dictionary.GetSimpleName (ForPO),
                  Id_Str2   => TheStreamVariable);
            end if;
         end if;
      end if;
      It := Dictionary.NextSymbol (It);
   end loop;
   if not Found then
      -- The handler name specified in the interrupt property is not an interrupt
      -- handler in the protected type.
      ErrorHandler.Semantic_Error_Lex1_Sym2
        (Err_Num   => 953,
         Reference => ErrorHandler.No_Reference,
         Position  => Node_Position (Node => ErrorNode),
         Id_Str    => TheHandler,
         Sym       => ForPO,
         Sym2      => TypeSym,
         Scope     => Scope);
   end if;
   --# accept Flow, 33, UnusedSymbol, "Expected to be neither referenced nor exported";
end CreateInterruptStreamVariable;
