-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (Sem.CompUnit)
procedure CheckEmbedBodies (CompSym : in Dictionary.Symbol;
                            Node    : in STree.SyntaxNode) is
   PackList        : Dictionary.Iterator;
   EmbeddedPackSym : Dictionary.Symbol;
   Error           : Boolean;

   --------------------------------------------------------------

   procedure CheckForAnyDeclaredSubprograms
     (EmbeddedPackSym : in     Dictionary.Symbol;
      Node            : in     STree.SyntaxNode;
      ErrorFound      :    out Boolean)
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.State;
   --#        in     STree.Table;
   --#        in out ErrorHandler.Error_Context;
   --#        in out SPARK_IO.File_Sys;
   --# derives ErrorFound                 from Dictionary.Dict,
   --#                                         EmbeddedPackSym &
   --#         ErrorHandler.Error_Context,
   --#         SPARK_IO.File_Sys          from CommandLineData.Content,
   --#                                         Dictionary.Dict,
   --#                                         EmbeddedPackSym,
   --#                                         ErrorHandler.Error_Context,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         SPARK_IO.File_Sys,
   --#                                         STree.Table;
   is
      function SubprogWithoutBodyFound (SubprogramIterator : Dictionary.Iterator) return Boolean
      --# global in Dictionary.Dict;
      is
         It     : Dictionary.Iterator;
         Result : Boolean := False;
      begin
         It := SubprogramIterator;
         while not Dictionary.IsNullIterator (It) loop
            if not (Dictionary.HasBody (Dictionary.CurrentSymbol (It))
                      or else Dictionary.IsProofFunction (Dictionary.CurrentSymbol (It))) then
               Result := True;
               exit;
            end if;
            It := Dictionary.NextSymbol (It);
         end loop;
         return Result;
      end SubprogWithoutBodyFound;

   begin
      ErrorFound := False;
      if SubprogWithoutBodyFound (Dictionary.FirstVisibleSubprogram (EmbeddedPackSym))
        or else SubprogWithoutBodyFound (Dictionary.FirstPrivateSubprogram (EmbeddedPackSym)) then
         ErrorFound := True;
         ErrorHandler.Semantic_Error
           (Err_Num   => 62,
            Reference => ErrorHandler.No_Reference,
            Position  => Node_Position (Node => Node),
            Id_Str    => Dictionary.GetSimpleName (EmbeddedPackSym));
      end if;
   end CheckForAnyDeclaredSubprograms;

   -------------------------------------------------------

   procedure CheckAnyOwnVariables (EmbeddedPackSym : in Dictionary.Symbol;
                                   Node            : in STree.SyntaxNode)
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.State;
   --#        in     STree.Table;
   --#        in out ErrorHandler.Error_Context;
   --#        in out SPARK_IO.File_Sys;
   --# derives ErrorHandler.Error_Context,
   --#         SPARK_IO.File_Sys          from CommandLineData.Content,
   --#                                         Dictionary.Dict,
   --#                                         EmbeddedPackSym,
   --#                                         ErrorHandler.Error_Context,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         SPARK_IO.File_Sys,
   --#                                         STree.Table;
   is
      OwnVarIt                                    : Dictionary.Iterator;
      OwnVarSym                                   : Dictionary.Symbol;
      FoundOwnVariableNotInitializedAtDeclaration : Boolean := False;
   begin -- CheckAnyOwnVariables
      OwnVarIt := Dictionary.FirstInitializedOwnVariable (EmbeddedPackSym);
      while OwnVarIt /= Dictionary.NullIterator loop
         OwnVarSym                                   := Dictionary.CurrentSymbol (OwnVarIt);
         FoundOwnVariableNotInitializedAtDeclaration := not Dictionary.IsDeclared (OwnVarSym)
           or else     -- not declared in spec at all
           not Dictionary.VariableIsInitialized (OwnVarSym);   -- declared but not
                                                               --initialized

         exit when FoundOwnVariableNotInitializedAtDeclaration;
         OwnVarIt := Dictionary.NextSymbol (OwnVarIt);
      end loop;

      if FoundOwnVariableNotInitializedAtDeclaration then
         ErrorHandler.Semantic_Error
           (Err_Num   => 62,
            Reference => ErrorHandler.No_Reference,
            Position  => Node_Position (Node => Node),
            Id_Str    => Dictionary.GetSimpleName (EmbeddedPackSym));
      end if;
   end CheckAnyOwnVariables;

   -------------------------------------------------------

begin --CheckEmbeddedPackagesHaveBodies
   PackList := Dictionary.FirstEmbeddedPackage (CompSym);
   while not Dictionary.IsNullIterator (PackList) loop
      EmbeddedPackSym := Dictionary.CurrentSymbol (PackList);
      if not (Dictionary.HasBody (EmbeddedPackSym) or Dictionary.HasBodyStub (EmbeddedPackSym)) then
         CheckForAnyDeclaredSubprograms (EmbeddedPackSym, Node, Error);
         if not Error then
            CheckAnyOwnVariables (EmbeddedPackSym, Node);
         end if;
      end if;
      PackList := Dictionary.NextSymbol (PackList);
   end loop;
end CheckEmbedBodies;
