-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (Dictionary)
function UnaryOperatorIsVisible
  (Name    : SPSymbols.SPSymbol;
   Operand : Symbol;
   Scope   : Scopes)
  return    Boolean
is

   --------------------------------------------------------------------------------

   function UnaryOperatorIsDirectlyVisible (Operand : Symbol;
                                            Scope   : Scopes) return Boolean
   --# global in CommandLineData.Content;
   --#        in Dict;
   is
      IsVisible    : Boolean;
      CurrentScope : Scopes;
      PackSym      : Symbol;
   begin

      if DefinedInPackageStandard (Operand) or else TypeIsUnknown (Operand) then
         IsVisible := True;
      else
         case CommandLineData.Content.Language_Profile is
            when CommandLineData.SPARK83 =>

               IsVisible := InSameImmediatePackage (Scope, GetScope (Operand));

            when CommandLineData.SPARK95 | CommandLineData.SPARK2005 =>

               CurrentScope := Scope;
               loop
                  IsVisible := InSameImmediatePackage (CurrentScope, GetScope (Operand));
                  exit when IsVisible;
                  CurrentScope := GetEnclosingScope (CurrentScope);
                  exit when CurrentScope = GlobalScope;
               end loop;
               if not IsVisible then
                  PackSym := GetLibraryPackage (Scope);
                  if PackSym /= GetPredefinedPackageStandard then
                     loop
                        PackSym := GetPackageParent (PackSym);
                        exit when PackSym = NullSymbol;
                        IsVisible := InSameImmediatePackage (VisibleScope (PackSym), GetScope (Operand));
                        exit when IsVisible;
                     end loop;
                  end if;
               end if;
               IsVisible := IsVisible and then not TypeIsPrivateHere (Operand, Scope);
         end case;
      end if;

      return IsVisible;

   end UnaryOperatorIsDirectlyVisible;

   --------------------------------------------------------------------------------

   function UnaryOperatorIsRenamed
     (Name    : SPSymbols.SPSymbol;
      Operand : Symbol;
      Scope   : Scopes)
     return    Boolean
   --# global in CommandLineData.Content;
   --#        in Dict;
   is
      Current : Scopes;
      Region  : Symbol;
      Found   : Boolean;

      --------------------------------------------------------------------------------

      function IsRenamedInThisScope
        (Name    : SPSymbols.SPSymbol;
         Operand : Symbol;
         Scope   : Scopes)
        return    Boolean
      --# global in Dict;
      is
         Region : Symbol;
         Found  : Boolean;

         --------------------------------------------------------------------------------

         function SearchRenamingDeclarations
           (Name         : SPSymbols.SPSymbol;
            Operand      : Symbol;
            Declarations : Symbol)
           return         Boolean
         --# global in Dict;
         is
            Current : Symbol;
            Item    : Symbol;
         begin

            Current := Declarations;

            loop
               exit when Current = NullSymbol;
               Item := RawDict.GetDeclarationItem (Current);
               exit when RawDict.GetSymbolDiscriminant (Item) = OperatorSymbol
                 and then RawDict.GetOperatorName (Item) = Name
                 and then RawDict.GetOperatorLeftOperand (Item) = NullSymbol
                 and then RawDict.GetOperatorRightOperand (Item) = Operand;
               Current := RawDict.GetNextDeclaration (Current);
            end loop;

            return Current /= NullSymbol;

         end SearchRenamingDeclarations;

         --------------------------------------------------------------------------------

         function IsRenamedInThisPackage
           (Name    : SPSymbols.SPSymbol;
            Operand : Symbol;
            Scope   : Scopes)
           return    Boolean
         --# global in Dict;
         is
            ThisPackage : Symbol;
            Found       : Boolean;

            --------------------------------------------------------------------------------

            function IsRenamedInThisPackageSpecification
              (Name        : SPSymbols.SPSymbol;
               Operand     : Symbol;
               ThisPackage : Symbol)
              return        Boolean
            --# global in Dict;
            is
            begin
               return SearchRenamingDeclarations (Name, Operand, RawDict.GetPackageVisibleRenamingDeclarations (ThisPackage));
            end IsRenamedInThisPackageSpecification;

            --------------------------------------------------------------------------------

            function IsRenamedInThisPackageBody
              (Name        : SPSymbols.SPSymbol;
               Operand     : Symbol;
               ThisPackage : Symbol)
              return        Boolean
            --# global in Dict;
            is
            begin
               return SearchRenamingDeclarations (Name, Operand, RawDict.GetPackageLocalRenamingDeclarations (ThisPackage));
            end IsRenamedInThisPackageBody;

            --------------------------------------------------------------------------------

         begin

            ThisPackage := GetRegion (Scope);

            case Scope.TypeOfScope is
               when Visible | Privat =>
                  Found := IsRenamedInThisPackageSpecification (Name, Operand, ThisPackage);
               when Local =>
                  Found := IsRenamedInThisPackageBody (Name, Operand, ThisPackage)
                    or else IsRenamedInThisPackageSpecification (Name, Operand, ThisPackage);
            end case;

            return Found;

         end IsRenamedInThisPackage;

         --------------------------------------------------------------------------------

         function IsRenamedInThisSubprogram
           (Name       : SPSymbols.SPSymbol;
            Operand    : Symbol;
            Subprogram : Symbol)
           return       Boolean
         --# global in Dict;
         is
         begin
            return SearchRenamingDeclarations (Name, Operand, RawDict.GetSubprogramRenamingDeclarations (Subprogram));
         end IsRenamedInThisSubprogram;

         --------------------------------------------------------------------------------

      begin

         Region := GetRegion (Scope);

         case RawDict.GetSymbolDiscriminant (Region) is
            when PackageSymbol =>
               Found := IsRenamedInThisPackage (Name, Operand, Scope);
            when SubprogramSymbol =>
               Found := IsRenamedInThisSubprogram (Name, Operand, Region);
            when others =>
               Found := False;
         end case;

         return Found;

      end IsRenamedInThisScope;

      --------------------------------------------------------------------------------

   begin

      Current := Scope;

      loop
         Found := IsRenamedInThisScope (Name, Operand, Current);
         exit when Found;
         Region := GetRegion (Current);
         exit when IsPackage (Region) and CommandLineData.Content.Language_Profile = CommandLineData.SPARK83;
         exit when IsMainProgram (Region);
         Current := GetEnclosingScope (Current);
         exit when Current = GlobalScope;
      end loop;

      if Current = GlobalScope then
         Region := GetLibraryPackage (Scope);
         if Region /= GetPredefinedPackageStandard then
            loop
               Region := GetPackageParent (Region);
               exit when Region = NullSymbol;
               Found := IsRenamedInThisScope (Name, Operand, VisibleScope (Region));
               exit when Found;
            end loop;
         end if;
      end if;

      return Found;

   end UnaryOperatorIsRenamed;

   --------------------------------------------------------------------------------
   function TypeIsUsed (TypeSym : Symbol;
                        Scope   : Scopes) return Boolean
   --# global in CommandLineData.Content;
   --#        in Dict;
   is
      Current : Scopes;
      Region  : Symbol;
      Found   : Boolean;

      ------------------

      function IsUsedInThisScope (TypeSym : Symbol;
                                  Scope   : Scopes) return Boolean
      --# global in Dict;
      is
         Region : Symbol;
         Found  : Boolean;

         ------------------

         function IsUsedInThisPackage (TypeSym : Symbol;
                                       Scope   : Scopes) return Boolean
         --# global in Dict;
         is
            Found : Boolean;

         begin --IsUsedInThisPackage
            case Scope.TypeOfScope is
               when Visible =>
                  Found := IsUsedLocally (TypeSym, Scope);
               when Privat =>
                  Found := IsUsedLocally (TypeSym, VisibleScope (GetRegion (Scope)));
               when Local =>
                  Found := IsUsedLocally (TypeSym, Scope) or else IsUsedLocally (TypeSym, VisibleScope (GetRegion (Scope)));
            end case;
            return Found;
         end IsUsedInThisPackage;

         ------------------

      begin --IsUsedInThisScope
         Region := GetRegion (Scope);
         case RawDict.GetSymbolDiscriminant (Region) is
            when PackageSymbol =>
               Found := IsUsedInThisPackage (TypeSym, Scope);
            when SubprogramSymbol =>
               Found := IsUsedLocally (TypeSym, Scope);
            when TypeSymbol => -- Task or Protected
               Found := IsUsedLocally (TypeSym, Scope);
            when others =>
               Found := False;
         end case;

         return Found;

      end IsUsedInThisScope;

      ------------------

   begin --TypeIsUsed
      case CommandLineData.Content.Language_Profile is
         when CommandLineData.SPARK83 =>

            Found := False;

         when CommandLineData.SPARK95 | CommandLineData.SPARK2005 =>

            if DefinedInPackageStandard (TypeSym) then  --can't possible be in a use type clause
               Found := False;

            else
               Current := Scope;

               loop
                  Found := IsUsedInThisScope (TypeSym, Current);
                  exit when Found;
                  Region := GetRegion (Current);
                  exit when IsMainProgram (Region);
                  Current := GetEnclosingScope (Current);
                  exit when Current = GlobalScope;
               end loop;

               if Current = GlobalScope then
                  Region := GetLibraryPackage (Scope);
                  if Region /= GetPredefinedPackageStandard then
                     loop
                        Region := GetPackageParent (Region);
                        exit when Region = NullSymbol;
                        Found := IsUsedInThisScope (TypeSym, VisibleScope (Region));
                        exit when Found;
                     end loop;
                  end if;
               end if;
            end if;
      end case;

      return Found;

   end TypeIsUsed;

   --------------------------------------------------------------------------------

begin
   return UnaryOperatorIsDirectlyVisible (Operand, Scope)
     or else (TypeIsUsed (Operand, Scope) and then TypeExportsOperators (Operand, Scope))
     or else UnaryOperatorIsRenamed (Name, Operand, Scope);
end UnaryOperatorIsVisible;
