/*
 * SpanDSP - a series of DSP components for telephony
 *
 * v29rx_fixed_rrc.h - ITU V.29 modem receive part
 *                     Fixed point RRC filter coeffs.
 *
 * Written by Steve Underwood <steveu@coppice.org>
 *
 * Copyright (C) 2007 Steve Underwood
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2, as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: v29rx_fixed_rrc.h,v 1.2 2007/08/13 11:35:32 steveu Exp $
 */

/* Raised root cosine pulse shaping; Beta = 0.5; 4 symbols either
   side of the centre. We cannot simplify this by using only half
   the filter, as each variant are each skewed by n/PULSESHAPER_COEFF_SETS
   of a sample. Only one is symmetric. */
#define PULSESHAPER_GAIN        32768.0f
#define PULSESHAPER_COEFF_SETS  48
static const complexi16_t pulseshaper[PULSESHAPER_COEFF_SETS][V29_RX_FILTER_STEPS] =
{
    {
        {    -1,    -25},       /* Filter 0 */
        {    12,     -3},
        {   -19,    -31},
        {    28,    -28},
        {   -22,    -14},
        {    16,    -52},
        {   -47,     -3},
        {   -21,   -133},
        {   -44,     18},
        {  -252,   -347},
        {   280,   -328},
        {  -453,   -231},
        {   509,  -2121},
        {  3527,      0},
        {   823,   3430},
        { -1944,    990},
        {  -330,   -387},
        {  -254,    349},
        {  -397,   -164},
        {     7,    -47},
        {  -134,     10},
        {   -14,    -45},
        {   -46,     28},
        {   -19,    -19},
        {   -21,     34},
        {   -34,    -11},
        {     0,     12},
    },
    {
        {    -1,    -13},       /* Filter 1 */
        {    11,     -3},
        {   -19,    -32},
        {    28,    -28},
        {   -24,    -14},
        {    16,    -51},
        {   -50,     -3},
        {   -21,   -133},
        {   -51,     21},
        {  -256,   -353},
        {   274,   -321},
        {  -480,   -244},
        {   517,  -2156},
        {  3543,      0},
        {   819,   3414},
        { -1912,    974},
        {  -311,   -364},
        {  -259,    356},
        {  -391,   -162},
        {     6,    -40},
        {  -135,     10},
        {   -13,    -42},
        {   -47,     28},
        {   -17,    -17},
        {   -21,     35},
        {   -34,    -11},
        {    -1,     13},
    },
    {
        {    -1,    -14},       /* Filter 2 */
        {    10,     -3},
        {   -20,    -32},
        {    27,    -27},
        {   -25,    -15},
        {    16,    -50},
        {   -53,     -4},
        {   -21,   -132},
        {   -58,     24},
        {  -260,   -358},
        {   268,   -314},
        {  -507,   -258},
        {   526,  -2191},
        {  3558,      0},
        {   815,   3397},
        { -1880,    957},
        {  -292,   -342},
        {  -263,    363},
        {  -384,   -159},
        {     5,    -33},
        {  -135,     10},
        {   -12,    -39},
        {   -47,     29},
        {   -16,    -16},
        {   -22,     36},
        {   -33,    -10},
        {    -1,     14},
    },
    {
        {    -1,    -15},       /* Filter 3 */
        {     9,     -3},
        {   -20,    -33},
        {    27,    -27},
        {   -26,    -16},
        {    16,    -49},
        {   -56,     -4},
        {   -20,   -132},
        {   -64,     26},
        {  -263,   -363},
        {   262,   -307},
        {  -534,   -272},
        {   534,  -2225},
        {  3573,      0},
        {   811,   3380},
        { -1847,    941},
        {  -273,   -320},
        {  -268,    369},
        {  -378,   -156},
        {     4,    -27},
        {  -135,     10},
        {   -12,    -37},
        {   -48,     29},
        {   -15,    -15},
        {   -22,     36},
        {   -32,    -10},
        {    -1,     15},
    },
    {
        {    -1,    -15},       /* Filter 4 */
        {     8,     -2},
        {   -20,    -34},
        {    26,    -26},
        {   -28,    -17},
        {    15,    -48},
        {   -59,     -4},
        {   -20,   -131},
        {   -71,     29},
        {  -267,   -368},
        {   255,   -299},
        {  -562,   -286},
        {   542,  -2260},
        {  3587,      0},
        {   807,   3362},
        { -1815,    925},
        {  -255,   -298},
        {  -272,    375},
        {  -371,   -154},
        {     3,    -20},
        {  -135,     10},
        {   -11,    -34},
        {   -48,     29},
        {   -14,    -14},
        {   -22,     37},
        {   -31,    -10},
        {    -1,     15},
    },
    {
        {    -1,    -16},       /* Filter 5 */
        {     7,     -2},
        {   -21,    -34},
        {    25,    -25},
        {   -29,    -17},
        {    15,    -47},
        {   -62,     -4},
        {   -20,   -130},
        {   -78,     32},
        {  -270,   -372},
        {   248,   -291},
        {  -590,   -300},
        {   550,  -2294},
        {  3600,      0},
        {   802,   3343},
        { -1782,    908},
        {  -236,   -277},
        {  -276,    380},
        {  -365,   -151},
        {     2,    -14},
        {  -135,     10},
        {   -10,    -31},
        {   -49,     30},
        {   -13,    -13},
        {   -23,     37},
        {   -30,     -9},
        {    -1,     16},
    },
    {
        {    -1,    -17},       /* Filter 6 */
        {     6,     -2},
        {   -21,    -35},
        {    24,    -24},
        {   -30,    -18},
        {    15,    -46},
        {   -65,     -5},
        {   -20,   -129},
        {   -85,     35},
        {  -274,   -377},
        {   241,   -282},
        {  -618,   -314},
        {   558,  -2328},
        {  3613,      0},
        {   798,   3324},
        { -1750,    891},
        {  -218,   -256},
        {  -280,    385},
        {  -358,   -148},
        {     1,     -7},
        {  -134,     10},
        {    -9,    -28},
        {   -49,     30},
        {   -12,    -12},
        {   -23,     38},
        {   -29,     -9},
        {    -1,     17},
    },
    {
        {    -1,    -18},       /* Filter 7 */
        {     5,     -1},
        {   -22,    -35},
        {    24,    -24},
        {   -31,    -19},
        {    14,    -45},
        {   -67,     -5},
        {   -20,   -127},
        {   -93,     38},
        {  -277,   -381},
        {   233,   -273},
        {  -646,   -329},
        {   567,  -2362},
        {  3625,      0},
        {   793,   3305},
        { -1717,    875},
        {  -201,   -235},
        {  -283,    390},
        {  -351,   -145},
        {     0,     -1},
        {  -134,     10},
        {    -8,    -26},
        {   -50,     30},
        {   -11,    -11},
        {   -23,     39},
        {   -28,     -9},
        {    -1,     18},
    },
    {
        {    -1,    -18},       /* Filter 8 */
        {     5,     -1},
        {   -22,    -36},
        {    23,    -23},
        {   -32,    -20},
        {    14,    -43},
        {   -70,     -5},
        {   -20,   -126},
        {  -100,     41},
        {  -280,   -385},
        {   225,   -264},
        {  -675,   -344},
        {   575,  -2395},
        {  3637,      0},
        {   788,   3284},
        { -1685,    858},
        {  -183,   -214},
        {  -287,    395},
        {  -344,   -142},
        {     0,      4},
        {  -133,     10},
        {    -7,    -23},
        {   -50,     30},
        {   -10,    -10},
        {   -24,     39},
        {   -27,     -9},
        {    -1,     18},
    },
    {
        {    -1,    -19},       /* Filter 9 */
        {     4,     -1},
        {   -22,    -37},
        {    22,    -22},
        {   -34,    -20},
        {    13,    -42},
        {   -73,     -5},
        {   -19,   -125},
        {  -107,     44},
        {  -283,   -389},
        {   217,   -254},
        {  -704,   -358},
        {   583,  -2428},
        {  3647,      0},
        {   783,   3264},
        { -1652,    842},
        {  -166,   -194},
        {  -290,    399},
        {  -337,   -139},
        {    -1,     10},
        {  -133,     10},
        {    -6,    -20},
        {   -50,     30},
        {    -8,     -8},
        {   -24,     39},
        {   -26,     -8},
        {    -1,     19},
    },
    {
        {    -1,    -19},       /* Filter 10 */
        {     3,     -1},
        {   -23,    -37},
        {    21,    -21},
        {   -35,    -21},
        {    13,    -41},
        {   -76,     -6},
        {   -19,   -123},
        {  -115,     47},
        {  -285,   -393},
        {   209,   -245},
        {  -733,   -373},
        {   591,  -2461},
        {  3657,      0},
        {   778,   3242},
        { -1619,    825},
        {  -149,   -174},
        {  -292,    403},
        {  -330,   -136},
        {    -2,     16},
        {  -132,     10},
        {    -5,    -18},
        {   -50,     31},
        {    -7,     -7},
        {   -24,     40},
        {   -25,     -8},
        {    -1,     19},
    },
    {
        {    -1,    -20},       /* Filter 11 */
        {     2,      0},
        {   -23,    -38},
        {    20,    -20},
        {   -36,    -22},
        {    12,    -39},
        {   -79,     -6},
        {   -19,   -121},
        {  -122,     50},
        {  -288,   -397},
        {   200,   -234},
        {  -763,   -388},
        {   598,  -2494},
        {  3667,      0},
        {   773,   3221},
        { -1587,    808},
        {  -132,   -155},
        {  -295,    406},
        {  -322,   -133},
        {    -3,     22},
        {  -131,     10},
        {    -4,    -15},
        {   -50,     31},
        {    -6,     -6},
        {   -24,     40},
        {   -24,     -8},
        {    -1,     20},
    },
    {
        {    -1,    -21},       /* Filter 12 */
        {     1,      0},
        {   -23,    -38},
        {    20,    -20},
        {   -37,    -22},
        {    12,    -38},
        {   -81,     -6},
        {   -18,   -119},
        {  -130,     53},
        {  -290,   -400},
        {   191,   -224},
        {  -792,   -403},
        {   606,  -2527},
        {  3675,      0},
        {   767,   3198},
        { -1554,    792},
        {  -116,   -136},
        {  -297,    409},
        {  -315,   -130},
        {    -4,     28},
        {  -130,     10},
        {    -4,    -12},
        {   -50,     31},
        {    -5,     -5},
        {   -25,     40},
        {   -23,     -7},
        {    -1,     21},
    },
    {
        {    -1,    -21},       /* Filter 13 */
        {     0,      0},
        {   -23,    -39},
        {    19,    -19},
        {   -38,    -23},
        {    11,    -36},
        {   -84,     -6},
        {   -18,   -117},
        {  -137,     56},
        {  -293,   -403},
        {   182,   -213},
        {  -822,   -419},
        {   614,  -2559},
        {  3683,      0},
        {   762,   3175},
        { -1521,    775},
        {  -100,   -117},
        {  -299,    412},
        {  -308,   -127},
        {    -5,     33},
        {  -129,     10},
        {    -3,    -10},
        {   -50,     31},
        {    -4,     -4},
        {   -25,     41},
        {   -22,     -7},
        {    -1,     21},
    },
    {
        {    -1,    -22},       /* Filter 14 */
        {     0,      0},
        {   -24,    -39},
        {    18,    -18},
        {   -39,    -24},
        {    11,    -35},
        {   -87,     -6},
        {   -18,   -115},
        {  -145,     60},
        {  -295,   -406},
        {   172,   -201},
        {  -852,   -434},
        {   622,  -2591},
        {  3691,      0},
        {   756,   3152},
        { -1488,    758},
        {   -84,    -98},
        {  -301,    415},
        {  -300,   -124},
        {    -6,     38},
        {  -128,     10},
        {    -2,     -7},
        {   -50,     31},
        {    -3,     -3},
        {   -25,     41},
        {   -21,     -7},
        {    -1,     22},
    },
    {
        {    -1,    -22},       /* Filter 15 */
        {    -1,      0},
        {   -24,    -39},
        {    17,    -17},
        {   -40,    -24},
        {    10,    -33},
        {   -89,     -7},
        {   -17,   -112},
        {  -152,     63},
        {  -297,   -409},
        {   162,   -190},
        {  -883,   -450},
        {   629,  -2623},
        {  3697,      0},
        {   751,   3128},
        { -1456,    742},
        {   -68,    -80},
        {  -303,    417},
        {  -293,   -121},
        {    -6,     44},
        {  -126,      9},
        {    -1,     -5},
        {   -50,     30},
        {    -1,     -1},
        {   -25,     41},
        {   -20,     -6},
        {    -1,     22},
    },
    {
        {    -1,    -23},       /* Filter 16 */
        {    -2,      0},
        {   -24,    -40},
        {    16,    -16},
        {   -41,    -25},
        {    10,    -31},
        {   -92,     -7},
        {   -17,   -110},
        {  -160,     66},
        {  -299,   -412},
        {   152,   -178},
        {  -913,   -465},
        {   637,  -2654},
        {  3703,      0},
        {   745,   3104},
        { -1423,    725},
        {   -53,    -62},
        {  -304,    419},
        {  -285,   -118},
        {    -7,     49},
        {  -125,      9},
        {     0,     -2},
        {   -50,     30},
        {     0,      0},
        {   -25,     41},
        {   -19,     -6},
        {    -1,     23},
    },
    {
        {    -1,    -23},       /* Filter 17 */
        {    -3,      1},
        {   -24,    -40},
        {    15,    -15},
        {   -42,    -25},
        {     9,    -30},
        {   -95,     -7},
        {   -17,   -107},
        {  -168,     69},
        {  -301,   -414},
        {   141,   -165},
        {  -944,   -481},
        {   644,  -2685},
        {  3708,      0},
        {   739,   3079},
        { -1391,    708},
        {   -38,    -44},
        {  -305,    420},
        {  -277,   -115},
        {    -8,     54},
        {  -124,      9},
        {     0,      0},
        {   -50,     30},
        {     0,      0},
        {   -25,     42},
        {   -18,     -6},
        {    -1,     23},
    },
    {
        {    -1,    -24},       /* Filter 18 */
        {    -4,      1},
        {   -25,    -40},
        {    14,    -14},
        {   -42,    -26},
        {     9,    -28},
        {   -97,     -7},
        {   -16,   -104},
        {  -176,     72},
        {  -302,   -416},
        {   130,   -152},
        {  -975,   -497},
        {   652,  -2716},
        {  3713,      0},
        {   733,   3054},
        { -1358,    692},
        {   -23,    -27},
        {  -306,    422},
        {  -270,   -111},
        {    -9,     58},
        {  -122,      9},
        {     0,      2},
        {   -49,     30},
        {     1,      1},
        {   -25,     42},
        {   -17,     -5},
        {    -1,     24},
    },
    {
        {    -1,    -24},       /* Filter 19 */
        {    -5,      1},
        {   -25,    -41},
        {    13,    -13},
        {   -43,    -26},
        {     8,    -26},
        {   -99,     -7},
        {   -16,   -101},
        {  -183,     76},
        {  -303,   -418},
        {   119,   -139},
        { -1006,   -512},
        {   659,  -2746},
        {  3717,      0},
        {   727,   3028},
        { -1325,    675},
        {    -9,    -10},
        {  -307,    423},
        {  -262,   -108},
        {   -10,     63},
        {  -120,      9},
        {     1,      4},
        {   -49,     30},
        {     2,      2},
        {   -25,     42},
        {   -16,     -5},
        {    -1,     24},
    },
    {
        {    -1,    -24},       /* Filter 20 */
        {    -6,      2},
        {   -25,    -41},
        {    12,    -12},
        {   -44,    -27},
        {     7,    -24},
        {  -102,     -8},
        {   -15,    -98},
        {  -191,     79},
        {  -305,   -420},
        {   107,   -126},
        { -1037,   -528},
        {   666,  -2776},
        {  3720,      0},
        {   720,   3001},
        { -1293,    659},
        {     5,      6},
        {  -308,    423},
        {  -254,   -105},
        {   -10,     68},
        {  -119,      9},
        {     2,      7},
        {   -49,     30},
        {     3,      3},
        {   -25,     42},
        {   -15,     -5},
        {    -1,     24},
    },
    {
        {    -1,    -25},       /* Filter 21 */
        {    -8,      2},
        {   -25,    -41},
        {    11,    -11},
        {   -45,    -27},
        {     7,    -22},
        {  -104,     -8},
        {   -15,    -95},
        {  -199,     82},
        {  -306,   -421},
        {    96,   -112},
        { -1069,   -544},
        {   673,  -2805},
        {  3722,      0},
        {   714,   2975},
        { -1261,    642},
        {    19,     22},
        {  -308,    424},
        {  -246,   -102},
        {   -11,     72},
        {  -117,      9},
        {     3,      9},
        {   -48,     29},
        {     4,      4},
        {   -25,     42},
        {   -14,     -4},
        {    -1,     25},
    },
    {
        {    -2,    -25},       /* Filter 22 */
        {    -9,      2},
        {   -25,    -41},
        {    10,    -10},
        {   -45,    -28},
        {     6,    -20},
        {  -106,     -8},
        {   -14,    -91},
        {  -207,     85},
        {  -307,   -422},
        {    84,    -98},
        { -1101,   -561},
        {   680,  -2835},
        {  3724,      0},
        {   707,   2948},
        { -1228,    626},
        {    32,     38},
        {  -308,    424},
        {  -238,    -98},
        {   -12,     76},
        {  -115,      9},
        {     3,     11},
        {   -48,     29},
        {     5,      5},
        {   -25,     42},
        {   -13,     -4},
        {    -2,     25},
    },
    {
        {    -2,    -25},       /* Filter 23 */
        {   -10,      3},
        {   -25,    -41},
        {     9,     -9},
        {   -46,    -28},
        {     5,    -18},
        {  -109,     -8},
        {   -13,    -88},
        {  -215,     89},
        {  -307,   -423},
        {    71,    -83},
        { -1132,   -577},
        {   687,  -2864},
        {  3725,      0},
        {   701,   2920},
        { -1196,    609},
        {    45,     53},
        {  -308,    424},
        {  -230,    -95},
        {   -12,     80},
        {  -113,      8},
        {     4,     14},
        {   -47,     29},
        {     7,      7},
        {   -25,     42},
        {   -12,     -3},
        {    -2,     25},
    },
    {
        {    -2,    -26},       /* Filter 24 */
        {   -11,      3},
        {   -25,    -42},
        {     8,     -8},
        {   -47,    -28},
        {     5,    -16},
        {  -111,     -8},
        {   -13,    -84},
        {  -223,     92},
        {  -308,   -424},
        {    58,    -68},
        { -1164,   -593},
        {   694,  -2892},
        {  3726,      0},
        {   694,   2892},
        { -1164,    593},
        {    58,     68},
        {  -308,    424},
        {  -223,    -92},
        {   -13,     84},
        {  -111,      8},
        {     5,     16},
        {   -47,     28},
        {     8,      8},
        {   -25,     42},
        {   -11,     -3},
        {    -2,     26},
    },
    {
        {    -2,    -26},       /* Filter 25 */
        {   -12,      3},
        {   -25,    -42},
        {     7,     -7},
        {   -47,    -29},
        {     4,    -14},
        {  -113,     -8},
        {   -12,    -80},
        {  -230,     95},
        {  -308,   -424},
        {    45,    -53},
        { -1196,   -609},
        {   701,  -2920},
        {  3725,      0},
        {   687,   2864},
        { -1132,    577},
        {    71,     83},
        {  -307,    423},
        {  -215,    -89},
        {   -13,     88},
        {  -109,      8},
        {     5,     18},
        {   -46,     28},
        {     9,      9},
        {   -25,     41},
        {   -10,     -3},
        {    -2,     26},
    },
    {
        {    -2,    -26},       /* Filter 26 */
        {   -13,      4},
        {   -25,    -42},
        {     5,     -5},
        {   -48,    -29},
        {     3,    -11},
        {  -115,     -9},
        {   -12,    -76},
        {  -238,     98},
        {  -308,   -424},
        {    32,    -38},
        { -1228,   -626},
        {   707,  -2948},
        {  3724,      0},
        {   680,   2835},
        { -1101,    561},
        {    84,     98},
        {  -307,    422},
        {  -207,    -85},
        {   -14,     91},
        {  -106,      8},
        {     6,     20},
        {   -45,     28},
        {    10,     10},
        {   -25,     41},
        {    -9,     -2},
        {    -2,     26},
    },
    {
        {    -2,    -26},       /* Filter 27 */
        {   -14,      4},
        {   -25,    -42},
        {     4,     -4},
        {   -48,    -29},
        {     3,     -9},
        {  -117,     -9},
        {   -11,    -72},
        {  -246,    102},
        {  -308,   -424},
        {    19,    -22},
        { -1261,   -642},
        {   714,  -2975},
        {  3722,      0},
        {   673,   2805},
        { -1069,    544},
        {    96,    112},
        {  -306,    421},
        {  -199,    -82},
        {   -15,     95},
        {  -104,      8},
        {     7,     22},
        {   -45,     27},
        {    11,     11},
        {   -25,     41},
        {    -8,     -2},
        {    -2,     26},
    },
    {
        {    -2,    -27},       /* Filter 28 */
        {   -15,      5},
        {   -25,    -42},
        {     3,     -3},
        {   -49,    -30},
        {     2,     -7},
        {  -119,     -9},
        {   -10,    -68},
        {  -254,    105},
        {  -308,   -423},
        {     5,     -6},
        { -1293,   -659},
        {   720,  -3001},
        {  3720,      0},
        {   666,   2776},
        { -1037,    528},
        {   107,    126},
        {  -305,    420},
        {  -191,    -79},
        {   -15,     98},
        {  -102,      8},
        {     7,     24},
        {   -44,     27},
        {    12,     12},
        {   -25,     41},
        {    -6,     -2},
        {    -2,     27},
    },
    {
        {    -2,    -27},       /* Filter 29 */
        {   -16,      5},
        {   -25,    -42},
        {     2,     -2},
        {   -49,    -30},
        {     1,     -4},
        {  -120,     -9},
        {   -10,    -63},
        {  -262,    108},
        {  -307,   -423},
        {    -9,     10},
        { -1325,   -675},
        {   727,  -3028},
        {  3717,      0},
        {   659,   2746},
        { -1006,    512},
        {   119,    139},
        {  -303,    418},
        {  -183,    -76},
        {   -16,    101},
        {   -99,      7},
        {     8,     26},
        {   -43,     26},
        {    13,     13},
        {   -25,     41},
        {    -5,     -1},
        {    -2,     27},
    },
    {
        {    -2,    -27},       /* Filter 30 */
        {   -17,      5},
        {   -25,    -42},
        {     1,     -1},
        {   -49,    -30},
        {     0,     -2},
        {  -122,     -9},
        {    -9,    -58},
        {  -270,    111},
        {  -306,   -422},
        {   -23,     27},
        { -1358,   -692},
        {   733,  -3054},
        {  3713,      0},
        {   652,   2716},
        {  -975,    497},
        {   130,    152},
        {  -302,    416},
        {  -176,    -72},
        {   -16,    104},
        {   -97,      7},
        {     9,     28},
        {   -42,     26},
        {    14,     14},
        {   -25,     40},
        {    -4,     -1},
        {    -2,     27},
    },
    {
        {    -2,    -27},       /* Filter 31 */
        {   -18,      6},
        {   -25,    -42},
        {     0,      0},
        {   -50,    -30},
        {     0,      0},
        {  -124,     -9},
        {    -8,    -54},
        {  -277,    115},
        {  -305,   -420},
        {   -38,     44},
        { -1391,   -708},
        {   739,  -3079},
        {  3708,      0},
        {   644,   2685},
        {  -944,    481},
        {   141,    165},
        {  -301,    414},
        {  -168,    -69},
        {   -17,    107},
        {   -95,      7},
        {     9,     30},
        {   -42,     25},
        {    15,     15},
        {   -24,     40},
        {    -3,     -1},
        {    -2,     27},
    },
    {
        {    -2,    -27},       /* Filter 32 */
        {   -19,      6},
        {   -25,    -41},
        {     0,      0},
        {   -50,    -30},
        {     0,      2},
        {  -125,     -9},
        {    -7,    -49},
        {  -285,    118},
        {  -304,   -419},
        {   -53,     62},
        { -1423,   -725},
        {   745,  -3104},
        {  3703,      0},
        {   637,   2654},
        {  -913,    465},
        {   152,    178},
        {  -299,    412},
        {  -160,    -66},
        {   -17,    110},
        {   -92,      7},
        {    10,     31},
        {   -41,     25},
        {    16,     16},
        {   -24,     40},
        {    -2,      0},
        {    -2,     27},
    },
    {
        {    -2,    -27},       /* Filter 33 */
        {   -20,      6},
        {   -25,    -41},
        {    -1,      1},
        {   -50,    -30},
        {    -1,      5},
        {  -126,     -9},
        {    -6,    -44},
        {  -293,    121},
        {  -303,   -417},
        {   -68,     80},
        { -1456,   -742},
        {   751,  -3128},
        {  3697,      0},
        {   629,   2623},
        {  -883,    450},
        {   162,    190},
        {  -297,    409},
        {  -152,    -63},
        {   -17,    112},
        {   -89,      7},
        {    10,     33},
        {   -40,     24},
        {    17,     17},
        {   -24,     39},
        {    -1,      0},
        {    -2,     27},
    },
    {
        {    -2,    -27},       /* Filter 34 */
        {   -21,      7},
        {   -25,    -41},
        {    -3,      3},
        {   -50,    -31},
        {    -2,      7},
        {  -128,    -10},
        {    -6,    -38},
        {  -300,    124},
        {  -301,   -415},
        {   -84,     98},
        { -1488,   -758},
        {   756,  -3152},
        {  3691,      0},
        {   622,   2591},
        {  -852,    434},
        {   172,    201},
        {  -295,    406},
        {  -145,    -60},
        {   -18,    115},
        {   -87,      6},
        {    11,     35},
        {   -39,     24},
        {    18,     18},
        {   -24,     39},
        {     0,      0},
        {    -2,     27},
    },
    {
        {    -2,    -27},       /* Filter 35 */
        {   -22,      7},
        {   -25,    -41},
        {    -4,      4},
        {   -50,    -31},
        {    -3,     10},
        {  -129,    -10},
        {    -5,    -33},
        {  -308,    127},
        {  -299,   -412},
        {  -100,    117},
        { -1521,   -775},
        {   762,  -3175},
        {  3683,      0},
        {   614,   2559},
        {  -822,    419},
        {   182,    213},
        {  -293,    403},
        {  -137,    -56},
        {   -18,    117},
        {   -84,      6},
        {    11,     36},
        {   -38,     23},
        {    19,     19},
        {   -23,     39},
        {     0,      0},
        {    -2,     27},
    },
    {
        {    -2,    -27},       /* Filter 36 */
        {   -23,      7},
        {   -25,    -40},
        {    -5,      5},
        {   -50,    -31},
        {    -4,     12},
        {  -130,    -10},
        {    -4,    -28},
        {  -315,    130},
        {  -297,   -409},
        {  -116,    136},
        { -1554,   -792},
        {   767,  -3198},
        {  3675,      0},
        {   606,   2527},
        {  -792,    403},
        {   191,    224},
        {  -290,    400},
        {  -130,    -53},
        {   -18,    119},
        {   -81,      6},
        {    12,     38},
        {   -37,     22},
        {    20,     20},
        {   -23,     38},
        {     1,      0},
        {    -2,     27},
    },
    {
        {    -2,    -27},       /* Filter 37 */
        {   -24,      8},
        {   -24,    -40},
        {    -6,      6},
        {   -50,    -31},
        {    -4,     15},
        {  -131,    -10},
        {    -3,    -22},
        {  -322,    133},
        {  -295,   -406},
        {  -132,    155},
        { -1587,   -808},
        {   773,  -3221},
        {  3667,      0},
        {   598,   2494},
        {  -763,    388},
        {   200,    234},
        {  -288,    397},
        {  -122,    -50},
        {   -19,    121},
        {   -79,      6},
        {    12,     39},
        {   -36,     22},
        {    20,     20},
        {   -23,     38},
        {     2,      0},
        {    -2,     27},
    },
    {
        {    -2,    -27},       /* Filter 38 */
        {   -25,      8},
        {   -24,    -40},
        {    -7,      7},
        {   -50,    -31},
        {    -5,     18},
        {  -132,    -10},
        {    -2,    -16},
        {  -330,    136},
        {  -292,   -403},
        {  -149,    174},
        { -1619,   -825},
        {   778,  -3242},
        {  3657,      0},
        {   591,   2461},
        {  -733,    373},
        {   209,    245},
        {  -285,    393},
        {  -115,    -47},
        {   -19,    123},
        {   -76,      6},
        {    13,     41},
        {   -35,     21},
        {    21,     21},
        {   -23,     37},
        {     3,      1},
        {    -2,     27},
    },
    {
        {    -2,    -27},       /* Filter 39 */
        {   -26,      8},
        {   -24,    -39},
        {    -8,      8},
        {   -50,    -30},
        {    -6,     20},
        {  -133,    -10},
        {    -1,    -10},
        {  -337,    139},
        {  -290,   -399},
        {  -166,    194},
        { -1652,   -842},
        {   783,  -3264},
        {  3647,      0},
        {   583,   2428},
        {  -704,    358},
        {   217,    254},
        {  -283,    389},
        {  -107,    -44},
        {   -19,    125},
        {   -73,      5},
        {    13,     42},
        {   -34,     20},
        {    22,     22},
        {   -22,     37},
        {     4,      1},
        {    -2,     27},
    },
    {
        {    -2,    -27},       /* Filter 40 */
        {   -27,      9},
        {   -24,    -39},
        {   -10,     10},
        {   -50,    -30},
        {    -7,     23},
        {  -133,    -10},
        {     0,     -4},
        {  -344,    142},
        {  -287,   -395},
        {  -183,    214},
        { -1685,   -858},
        {   788,  -3284},
        {  3637,      0},
        {   575,   2395},
        {  -675,    344},
        {   225,    264},
        {  -280,    385},
        {  -100,    -41},
        {   -20,    126},
        {   -70,      5},
        {    14,     43},
        {   -32,     20},
        {    23,     23},
        {   -22,     36},
        {     5,      1},
        {    -2,     27},
    },
    {
        {    -2,    -26},       /* Filter 41 */
        {   -28,      9},
        {   -23,    -39},
        {   -11,     11},
        {   -50,    -30},
        {    -8,     26},
        {  -134,    -10},
        {     0,      1},
        {  -351,    145},
        {  -283,   -390},
        {  -201,    235},
        { -1717,   -875},
        {   793,  -3305},
        {  3625,      0},
        {   567,   2362},
        {  -646,    329},
        {   233,    273},
        {  -277,    381},
        {   -93,    -38},
        {   -20,    127},
        {   -67,      5},
        {    14,     45},
        {   -31,     19},
        {    24,     24},
        {   -22,     35},
        {     5,      1},
        {    -2,     26},
    },
    {
        {    -2,    -26},       /* Filter 42 */
        {   -29,      9},
        {   -23,    -38},
        {   -12,     12},
        {   -49,    -30},
        {    -9,     28},
        {  -134,    -10},
        {     1,      7},
        {  -358,    148},
        {  -280,   -385},
        {  -218,    256},
        { -1750,   -891},
        {   798,  -3324},
        {  3613,      0},
        {   558,   2328},
        {  -618,    314},
        {   241,    282},
        {  -274,    377},
        {   -85,    -35},
        {   -20,    129},
        {   -65,      5},
        {    15,     46},
        {   -30,     18},
        {    24,     24},
        {   -21,     35},
        {     6,      2},
        {    -2,     26},
    },
    {
        {    -2,    -26},       /* Filter 43 */
        {   -30,      9},
        {   -23,    -37},
        {   -13,     13},
        {   -49,    -30},
        {   -10,     31},
        {  -135,    -10},
        {     2,     14},
        {  -365,    151},
        {  -276,   -380},
        {  -236,    277},
        { -1782,   -908},
        {   802,  -3343},
        {  3600,      0},
        {   550,   2294},
        {  -590,    300},
        {   248,    291},
        {  -270,    372},
        {   -78,    -32},
        {   -20,    130},
        {   -62,      4},
        {    15,     47},
        {   -29,     17},
        {    25,     25},
        {   -21,     34},
        {     7,      2},
        {    -2,     26},
    },
    {
        {    -2,    -26},       /* Filter 44 */
        {   -31,     10},
        {   -22,    -37},
        {   -14,     14},
        {   -48,    -29},
        {   -11,     34},
        {  -135,    -10},
        {     3,     20},
        {  -371,    154},
        {  -272,   -375},
        {  -255,    298},
        { -1815,   -925},
        {   807,  -3362},
        {  3587,      0},
        {   542,   2260},
        {  -562,    286},
        {   255,    299},
        {  -267,    368},
        {   -71,    -29},
        {   -20,    131},
        {   -59,      4},
        {    15,     48},
        {   -28,     17},
        {    26,     26},
        {   -20,     34},
        {     8,      2},
        {    -2,     26},
    },
    {
        {    -2,    -26},       /* Filter 45 */
        {   -32,     10},
        {   -22,    -36},
        {   -15,     15},
        {   -48,    -29},
        {   -12,     37},
        {  -135,    -10},
        {     4,     27},
        {  -378,    156},
        {  -268,   -369},
        {  -273,    320},
        { -1847,   -941},
        {   811,  -3380},
        {  3573,      0},
        {   534,   2225},
        {  -534,    272},
        {   262,    307},
        {  -263,    363},
        {   -64,    -26},
        {   -20,    132},
        {   -56,      4},
        {    16,     49},
        {   -26,     16},
        {    27,     27},
        {   -20,     33},
        {     9,      3},
        {    -2,     26},
    },
    {
        {    -2,    -25},       /* Filter 46 */
        {   -33,     10},
        {   -22,    -36},
        {   -16,     16},
        {   -47,    -29},
        {   -12,     39},
        {  -135,    -10},
        {     5,     33},
        {  -384,    159},
        {  -263,   -363},
        {  -292,    342},
        { -1880,   -957},
        {   815,  -3397},
        {  3558,      0},
        {   526,   2191},
        {  -507,    258},
        {   268,    314},
        {  -260,    358},
        {   -58,    -24},
        {   -21,    132},
        {   -53,      4},
        {    16,     50},
        {   -25,     15},
        {    27,     27},
        {   -20,     32},
        {    10,      3},
        {    -2,     25},
    },
    {
        {    -2,    -25},       /* Filter 47 */
        {   -34,     11},
        {   -21,    -35},
        {   -17,     17},
        {   -47,    -28},
        {   -13,     42},
        {  -135,    -10},
        {     6,     40},
        {  -391,    162},
        {  -259,   -356},
        {  -311,    364},
        { -1912,   -974},
        {   819,  -3414},
        {  3543,      0},
        {   517,   2156},
        {  -480,    244},
        {   274,    321},
        {  -256,    353},
        {   -51,    -21},
        {   -21,    133},
        {   -50,      3},
        {    16,     51},
        {   -24,     14},
        {    28,     28},
        {   -19,     32},
        {    11,      3},
        {    -2,     25},
    },
};

/*- End of file ------------------------------------------------------------*/
