///###////////////////////////////////////////////////////////////////////////
//
// Burton Computer Corporation
// http://www.burton-computer.com
// http://www.cooldevtools.com
// $Id: SimpleTokenSelector.cc 56 2004-10-31 23:10:45Z brian $
//
// Copyright (C) 2000 Burton Computer Corporation
// ALL RIGHTS RESERVED
//
// This program is open source software; you can redistribute it
// and/or modify it under the terms of the Q Public License (QPL)
// version 1.0. Use of this software in whole or in part, including
// linking it (modified or unmodified) into other programs is
// subject to the terms of the QPL.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// Q Public License for more details.
//
// You should have received a copy of the Q Public License
// along with this program; see the file LICENSE.txt.  If not, visit
// the Burton Computer Corporation or CoolDevTools web site
// QPL pages at:
//
//    http://www.burton-computer.com/qpl.html
//    http://www.cooldevtools.com/qpl.html
//

#include "Message.h"
#include "Token.h"
#include "SimpleTokenSelector.h"

SimpleTokenSelector::SimpleTokenSelector(int required_flags,
                                         const string &required_prefix)
:  m_requiredFlags(required_flags),
   m_requiredPrefix(required_prefix)
{
}

SimpleTokenSelector::~SimpleTokenSelector()
{
}

void SimpleTokenSelector::selectTokens(const Message &msg,
                                       vector<Token *> &tokens)
{
  tokens.clear();
  for (int i = 0; i < msg.getTokenCount(); ++i) {
    Token *tok = msg.getToken(i);
    if (starts_with(tok->getWord(), m_requiredPrefix) && ((tok->getFlags() & m_requiredFlags) != 0)) {
      //cerr << "SELECTED: " << tok->getWord() << " (" << tok->getFlags() << ")" << endl;
      tokens.push_back(tok);
    }
  }
}
