///###////////////////////////////////////////////////////////////////////////
//
// Burton Computer Corporation
// http://www.burton-computer.com
// http://www.cooldevtools.com
// $Id: NewVector.h 56 2004-10-31 23:10:45Z brian $
//
// Copyright (C) 2000 Burton Computer Corporation
// ALL RIGHTS RESERVED
//
// This program is open source software; you can redistribute it
// and/or modify it under the terms of the Q Public License (QPL)
// version 1.0. Use of this software in whole or in part, including
// linking it (modified or unmodified) into other programs is
// subject to the terms of the QPL.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// Q Public License for more details.
//
// You should have received a copy of the Q Public License
// along with this program; see the file LICENSE.txt.  If not, visit
// the Burton Computer Corporation or CoolDevTools web site
// QPL pages at:
//
//    http://www.burton-computer.com/qpl.html
//    http://www.cooldevtools.com/qpl.html
//

#ifndef _NewVector_h
#define _NewVector_h

#include <vector>
#include "util.h"

/// Manages a vector of dynamically allocated objects.
/// Deletes the objects when they are removed from the list.
template<class T>
class NewVector
{
public:
  NewVector()
  {
  }

  ~NewVector()
  {
    clear();
  }

  T *operator[](int index) const
  {
      assert(index >= 0);
      assert(index < m_values.size());
      return m_values[index];
  }

  void add(T *p)
  {
      m_values.push_back(p);
  }

  void set(int index, T *p)
  {
      assert(index >= 0);
      assert(index < m_values.size());
      delete m_values[index];
      m_values[index] = p;
  }

  int size() const
  {
      return m_values.size();
  }

  void clear()
  {
      for (ValuesIter i = m_values.begin(); i != m_values.end(); ++i) {
          delete *i;
      }
      m_values.clear();
  }

private:
  /// Not implemented.
  NewVector(const NewVector &);

  /// Not implemented.
  NewVector& operator=(const NewVector &);

  typedef typename vector<T *>::const_iterator ValuesIter;

  vector<T *> m_values;
};

#endif // _NewPtr_h

