///###////////////////////////////////////////////////////////////////////////
//
// Burton Computer Corporation
// http://www.burton-computer.com
// http://www.cooldevtools.com
// $Id: MultiLineJoinedString.cc 56 2004-10-31 23:10:45Z brian $
//
// Copyright (C) 2000 Burton Computer Corporation
// ALL RIGHTS RESERVED
//
// This program is open source software; you can redistribute it
// and/or modify it under the terms of the Q Public License (QPL)
// version 1.0. Use of this software in whole or in part, including
// linking it (modified or unmodified) into other programs is
// subject to the terms of the QPL.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// Q Public License for more details.
//
// You should have received a copy of the Q Public License
// along with this program; see the file LICENSE.txt.  If not, visit
// the Burton Computer Corporation or CoolDevTools web site
// QPL pages at:
//
//    http://www.burton-computer.com/qpl.html
//    http://www.cooldevtools.com/qpl.html
//

#include "MultiLineJoinedString.h"

MultiLineJoinedString::MultiLineJoinedString(const MultiLineStringList &targets)
: m_targets(targets)
{
}

MultiLineJoinedString::~MultiLineJoinedString()
{
}

int MultiLineJoinedString::lineCount() const
{
    int answer = 0;
    for (MultiLineStringList::const_iterator i = m_targets.begin(); i != m_targets.end(); ++i) {
        answer += (*i)->lineCount();
    }
    return answer;
}

const string *MultiLineJoinedString::line(int index) const
{
    assert(index >= 0);
    assert(index < lineCount());

    for (MultiLineStringList::const_iterator i = m_targets.begin(); i != m_targets.end(); ++i) {
        if (index < (*i)->lineCount()) {
            return (*i)->line(index);
        }
        index -= (*i)->lineCount();
    }

    assert(false);
    return 0;
}

