//=================================================================================================
/*!
//  \file blaze/math/SparseVector.h
//  \brief Header file for all basic SparseVector functionality
//
//  Copyright (C) 2012-2020 Klaus Iglberger - All Rights Reserved
//
//  This file is part of the Blaze library. You can redistribute it and/or modify it under
//  the terms of the New (Revised) BSD License. Redistribution and use in source and binary
//  forms, with or without modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright notice, this list of
//     conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright notice, this list
//     of conditions and the following disclaimer in the documentation and/or other materials
//     provided with the distribution.
//  3. Neither the names of the Blaze development group nor the names of its contributors
//     may be used to endorse or promote products derived from this software without specific
//     prior written permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
//  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
//  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
//  SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
//  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
//  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
//  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
//  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
//  ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
*/
//=================================================================================================

#ifndef _BLAZE_MATH_SPARSEVECTOR_H_
#define _BLAZE_MATH_SPARSEVECTOR_H_


//*************************************************************************************************
// Includes
//*************************************************************************************************

#include <blaze/math/expressions/DenseVector.h>
#include <blaze/math/expressions/DVecSVecEqualExpr.h>
#include <blaze/math/expressions/DVecSVecInnerExpr.h>
#include <blaze/math/expressions/DVecSVecKronExpr.h>
#include <blaze/math/expressions/DVecSVecMultExpr.h>
#include <blaze/math/expressions/SparseVector.h>
#include <blaze/math/expressions/SVecDVecDivExpr.h>
#include <blaze/math/expressions/SVecDVecInnerExpr.h>
#include <blaze/math/expressions/SVecDVecKronExpr.h>
#include <blaze/math/expressions/SVecDVecMultExpr.h>
#include <blaze/math/expressions/SVecEvalExpr.h>
#include <blaze/math/expressions/SVecExpandExpr.h>
#include <blaze/math/expressions/SVecMapExpr.h>
#include <blaze/math/expressions/SVecMeanExpr.h>
#include <blaze/math/expressions/SVecNoAliasExpr.h>
#include <blaze/math/expressions/SVecNormExpr.h>
#include <blaze/math/expressions/SVecNoSIMDExpr.h>
#include <blaze/math/expressions/SVecReduceExpr.h>
#include <blaze/math/expressions/SVecRepeatExpr.h>
#include <blaze/math/expressions/SVecScalarDivExpr.h>
#include <blaze/math/expressions/SVecScalarMultExpr.h>
#include <blaze/math/expressions/SVecSerialExpr.h>
#include <blaze/math/expressions/SVecStdDevExpr.h>
#include <blaze/math/expressions/SVecSVecAddExpr.h>
#include <blaze/math/expressions/SVecSVecEqualExpr.h>
#include <blaze/math/expressions/SVecSVecInnerExpr.h>
#include <blaze/math/expressions/SVecSVecKronExpr.h>
#include <blaze/math/expressions/SVecSVecMultExpr.h>
#include <blaze/math/expressions/SVecSVecSubExpr.h>
#include <blaze/math/expressions/SVecTransExpr.h>
#include <blaze/math/expressions/SVecVarExpr.h>
#include <blaze/math/serialization/VectorSerializer.h>
#include <blaze/math/smp/DenseVector.h>
#include <blaze/math/smp/SparseVector.h>
#include <blaze/math/sparse/SparseVector.h>
#include <blaze/math/Vector.h>
#include <blaze/math/views/Subvector.h>

#endif
