# Hybrid assembly

## PacBio and Oxford Nanopore reads

SPAdes can take as input an unlimited number of PacBio and Oxford Nanopore libraries.

PacBio CLR and Oxford Nanopore reads are used for hybrid assemblies (e.g. with Illumina or IonTorrent).
There is no need to pre-correct this kind of data.
SPAdes will use PacBio CLR and Oxford Nanopore reads for gap closure and repeat resolution.

For PacBio you need to provide filtered subreads in FASTQ/FASTA format via
the `--pacbio` option. Oxford Nanopore reads are provided with `--nanopore` option.

PacBio CCS/Reads of Insert reads or pre-corrected (using third-party software) PacBio CLR / Oxford Nanopore reads can be simply provided as single reads to SPAdes.

## Additional contigs

In case you have contigs of the same genome generated by different assembler(s), and you wish to add them into SPAdes assembly,
you can specify additional contigs using `--trusted-contigs` or `--untrusted-contigs`.
The first option is used when high quality contigs are available. These contigs will be used for graph construction, gap closure and repeat resolution.
The second option is either used for less reliable contigs, which may have more errors, or for contigs of unknown quality.
Such contigs will be used only for gap closure and repeat resolution.

Both options allow providing unlimited number of contigs.

Note, that SPAdes **does not** perform assembly using genomes of closely-related species. Only contigs of the same genome should be provided.

