/*
 * QtColorMap.cpp
 *
 *  Created on: Dec 9, 2008
 *      Author: bettini
 */

#include "QtColorMap.h"

namespace srchiliteqt {

QtColorMap::QtColorMap() {
    (*this)["white"] = "#FFFFFF";
    (*this)["black"] = "#000000";
    (*this)["red"] = "#FF0000";
    (*this)["darkred"] = "#990000";
    (*this)["brown"] = "#660000";
    (*this)["yellow"] = "#FFCC00";
    (*this)["cyan"] = "#66FFFF";
    (*this)["blue"] = "#3333FF";
    (*this)["pink"] = "#CC33CC";
    (*this)["purple"] = "#993399";
    (*this)["orange"] = "#FF6600";
    (*this)["brightorange"] = "#FF9900";
    (*this)["green"] = "#33CC00";
    (*this)["brightgreen"] = "#33FF33";
    (*this)["darkgreen"] = "#009900";
    (*this)["teal"] = "#008080";
    (*this)["gray"] = "#808080";
    (*this)["darkblue"] = "#000080";
}

QtColorMap::~QtColorMap() {
}

std::string QtColorMap::getColor(const std::string &color) {
    if (color[0] == '"' && color[color.size()-1] == '"') {
        return color.substr(1, color.size()-2);
    } else {
        return (*this)[color];
    }
}

}
