/*
 * Qt4TextFormatter.cpp
 *
 *  Created on: Dec 8, 2008
 *      Author: Lorenzo Bettini <http://www.lorenzobettini.it>, (C) 2008
 *  Copyright: See COPYING file that comes with this distribution
 */

#include "Qt4TextFormatter.h"
#include "Qt4SyntaxHighlighter.h"

#include <srchilite/formatterparams.h>

//#define SHOW_DEBUG_INFO 1

#ifdef SHOW_DEBUG_INFO
#include <iostream>
#define DEBUG_INFO(x,y) std::cout << x << y << std::endl;
#else
#define DEBUG_INFO(x,y)
#endif

namespace srchiliteqt {

Qt4TextFormatter::Qt4TextFormatter(const std::string &elem_) :
    TextFormatter(elem_), textFormat(new QTextCharFormat),
            qSyntaxHighlighter(0) {
}

Qt4TextFormatter::~Qt4TextFormatter() {
}

void Qt4TextFormatter::setQSyntaxHighlighter(
        QSyntaxHighlighter *qSyntaxHighlighter_) {
    qSyntaxHighlighter
            = dynamic_cast<Qt4SyntaxHighlighter *> (qSyntaxHighlighter_);
}

void Qt4TextFormatter::format(const std::string &s,
        const srchilite::FormatterParams *params) {

    qSyntaxHighlighter->formatString(params->start, s.size(), *textFormat);

    DEBUG_INFO (s + "\n", toString().toStdString());
}

void Qt4TextFormatter::setForegroundColor(const QColor &color) {
    textFormat->setForeground(QBrush(color));
    foregroundColor = color;
}

void Qt4TextFormatter::setBackgroundColor(const QColor &color) {
    textFormat->setBackground(QBrush(color));
    backgroundColor = color;
}

const QString Qt4TextFormatter::toString() const {
    QString s = QString(getElem().c_str()) + ": ";
    QTextCharFormat & format = getQTextCharFormat();
    if (format.fontWeight() == QFont::Bold)
        s += "BOLD ";
    if (format.fontItalic())
        s += "ITALIC ";
    if (format.fontUnderline())
        s += "UNDERLINE ";
    s += "foreground: " + format.foreground().color().name();
    s += " background: " + format.background().color().name();
    s += "\n";

    return s;
}

}
