#ifndef LANGUAGECOMBOBOX_H
#define LANGUAGECOMBOBOX_H

#include <QComboBox>
#include "Qt4SyntaxHighlighter.h"

namespace srchiliteqt {

/**
  * A subclass of QComboBox which provides functionalities for showing
  * and selecting the language definition files of Source-Highlight.
  */
class LanguageComboBox : public QComboBox
{
          Q_OBJECT
public:
    /**
     * @param _highlighter the highlighter object; this will be used only for initialization
     */
    LanguageComboBox(srchiliteqt::Qt4SyntaxHighlighter *_highlighter);

public slots:
    /**
     * Sets the language in the combo
     * @param lang the language name; if the language is not part of the
     * combo list, nothing happens
     */
    void setCurrentLanguage(const QString &lang);

    /**
      * @return the language definition file name currently selected
      */
    const QString getCurrentLanguage() const;
};

}

#endif // LANGUAGECOMBOBOX_H

