
#include "replaygain.h"
#include "config.h"
#include "logger.h"
#include "replaygainpluginloader.h"

#include <qfile.h>

#include <kprocess.h>
#include <klocale.h>
#include <kurl.h>

ReplayGain::ReplayGain( Config* _config, Logger* _logger )
{
    config = _config;
    logger = _logger;
}

ReplayGain::~ReplayGain()
{}

bool ReplayGain::apply( QStringList files, const QString& format, KProcess* proc, int logID, Mode mode )
{
    QStringList params;
    QString param, paramSplinter;

    proc->clearArguments();

    ReplayGainPlugin* plugin = config->replaygainForFormat( format );
    if( plugin == 0 ) { // shouldn't happen
        logger->log( logID, " NULL POINTER: ReplayGain::replaygain( ... ) / plugin" );
        return false;
    }

    param = QString::null;
    if( plugin->replaygain.param ) param.append( " " + plugin->replaygain.param );
    if( mode & remove ) {
        if( plugin->replaygain.remove ) param.append( " " + plugin->replaygain.remove );
    }
    else {
        if( (mode & calc_track) && plugin->replaygain.track ) param.append( " " + plugin->replaygain.track );
        if( (mode & calc_album) && plugin->replaygain.album ) param.append( " " + plugin->replaygain.album );
        if( mode & force ) {
            if( plugin->replaygain.force ) param.append( " " + plugin->replaygain.force );
        }
        else {
            if( plugin->replaygain.skip ) param.append( " " + plugin->replaygain.skip );
        }
    }

//     if( plugin->replaygain.in_files.find("%p") != -1 ) {
//         QString t_str = plugin->replaygain.in_files;
//         t_str.replace( "%p", param );
//         param = plugin->replaygain.bin + " " + t_str;
//     }
//     else {
//         param = plugin->replaygain.bin + param + " " + plugin->replaygain.in_files;
//     }

    QString t_str = plugin->replaygain.in_files;
    t_str.replace( "%p", param );
    param = config->binaries[plugin->replaygain.bin] + " " + t_str;

    // cosmetic surgery
    param.simplifyWhiteSpace();

    params = QStringList::split( ' ', param );

    for( QStringList::Iterator it = params.begin(); it != params.end(); ++it )
    {
        paramSplinter = *it;
        if( paramSplinter == "%i" ) {
            for( QStringList::Iterator b = files.begin(); b != files.end(); ++b ) {
                *(proc) << KURL::decode_string( *b );
            }
        }
        else {
            *(proc) << paramSplinter;
        }
    }

    for( QStringList::Iterator it = files.begin(); it != files.end(); ++it )
    {
        *it = KURL::decode_string( *it );
    }

    param.replace( "%i", "\""+files.join("\" \"")+"\"" );
    logger->log( logID, " " + i18n("Executing") + ": `" + param + "'" );

    proc->setPriority( config->data.general.priority );
    proc->start( KProcess::NotifyOnExit, KProcess::AllOutput );

    return true;
}

//QValueList<float> ReplayGain::getReplayGain( QString file ) {} // obsolete
