<?php
/**
 * $Horde: accounts/lib/base.php,v 1.2.2.3 2003/01/20 06:38:04 ericr Exp $
 *
 * Copyright 2001-2003 Eric Rostetter <eric.rostetter@physics.utexas.edu>
 *
 * See the enclosed file LICENSE for license information (BSD). If you
 * did not receive this file, see http://www.horde.org/bsdl.php.
 *
 * Accounts base inclusion file.
 *
 * This file brings in all of the dependencies that every ACCOUNTS script
 * will need, and sets up objects that all scripts use.
 */

// Find the base file path of Horde
@define('HORDE_BASE', dirname(__FILE__) . '/../..');

// Find the base file path of Accounts
@define('ACCOUNTS_BASE', dirname(__FILE__) . '/..');

// Registry
require_once HORDE_BASE . '/lib/Registry.php';
$registry = &Registry::singleton();
$registry->pushApp('accounts');
$conf = &$GLOBALS['conf'];

// Set the error reporting level in accordance with the config settings.
error_reporting($conf['debug_level']);

// Set the maximum execution time in accordance with the config settings.
set_time_limit($conf['max_exec_time']);

// set the umask according to config settings
if (isset($conf['umask'])) {
    umask($conf['umask']);
}

// Horde base libraries
require_once HORDE_BASE . '/lib/Horde.php';
require_once HORDE_BASE . '/lib/Auth.php';
require_once HORDE_BASE . '/lib/Secret.php';
require_once HORDE_BASE . '/lib/Text.php';
require_once HORDE_BASE . '/lib/Help.php';

// Browser detection library
require_once HORDE_BASE . '/lib/Browser.php';

// Don't allow access unless there is a Horde login
if (!Auth::getAuth()) {
    header('Location: ' . Horde::url($registry->getWebRoot("horde") . '/login.php?url=' . urlencode($_SERVER['PHP_SELF']), true));
    exit;
}

?>
