2.2 Parametri dei Synth

# Paramentri dei Synth: Amp e Pan

Oltre a permetterti di controllare quale nota o quale campione suonare, Sonic Pi fornisce un insieme completo di parametri per inventare e controllare il suono. Ne incontreremo molti in questo tutorial e puoi trovare una trattazione completa nell’help. Per il momento, però, ne introdurremo due tra i più utili: *ampiezza* e *bilanciamento* (in inglese *amplitude* e *pan*). Prima di tutto diamo un’occhiata a cosa sono effettivamente i parametri.

## Parametri

Sonic Pi usa il concetto di parametro per i suoi synth. I parametri sono quantità che vengono passati all’istruzione `play` e che controllano e modificano caratteristiche del suono che ascolti. Ogni synth ha il suo gruppo di parametri per controllare in modo dettagliato il suono generato, ma comunque molti synth hanno in comune alcuni parametri come per esempio `amp:` e quelli che riguardano l’inviluppo (trattati in un paragrafo successivo).
I parametri hanno due parti, il nome (ovvero il nome del controllo) e il valore (il valore a cui vuoi impostare il controllo). Per esempio, potresti avere un parametro che si chiama `cheese:` e volerlo impostare al valore `1`.

I parametri sono passati alle istruzioni `play` usando una virgola `,` seguita dal nome del parametro, per esempio `amp:` (non dimenticare i due punti `:`) e quindi da uno spazio e dal valore del parametro. Per esempio:

```
play 50, cheese: 1
```

(Nota bene che `cheese:` non è un parametro valido, è solo per fare un esempio).

Puoi passare più parametri in una volta separandoli con una virgola:

```
play 50, cheese: 1, beans: 0.5
```

L’ordine dei parametri non conta, quindi questa istruzione ha lo stesso effetto di quella precedente:

```
play 50, beans: 0.5, cheese: 1
```

I parametri che non sono riconosciuti dal synth vengono ignorati (come `cheese` e `beans` che sono ovviamente nomi assurdi per dei parametri!)

Se per sbaglio usi lo stesso parametro due volte con diversi valori, l’ultimo vince. Per esempio `beans` in questa istruzione avrà il valore 2 invece di 0.5:


```
play 50, beans: 0.5, cheese: 3, eggs: 0.1, beans: 2
```

Molte cose in Sonic Pi accettano parametri, quindi passa un po’ di tempo a capire come usarli e sarai pronto! Giochiamo un po’ con il nostro primo parametro `amp:`

## Ampiezza

L’ampiezza è una rappresentazione digitale del volume di un suono. *Un’ampiezza elevata produce un suono forte* mentre *un valore basso di ampiezza produce un suono debole*. Come Sonic Pi usa numeri per rappresentare il tempo e le note, allo stesso modo usa numeri per rappresentare anche l’ampiezza. Un’ampiezza di valore 0 equivale al silenzio (non si sentirà nulla) mentre un’ampiezza di valore 1 equivale al volume normale. Puoi anche forzare l’ampiezza a valori più alti (2, 10, 100), ma vedrai che quando l’ampiezza complessiva di tutti i suoni diventa troppo alta, Sonic Pi usa il cosiddetto compressore per riportarla di nuovo a valori tali da non risultare troppo alti per le orecchie. Ciò può rendere il suono confuso e strano. Perciò prova ad usare ampiezze basse, diciamo tra 0 e 0.5, per evitare la compressione.


## Amp-lificato...!

Per cambiare l’ampiezza di un suono, puoi usare il parametro `amp:`. Ad esempio, per suonare a metà ampiezza, dai un valore di 0.5:
```
play 60, amp: 0.5
```

Per suonare ad ampiezza doppia, dai un valore di 2

```
play 60, amp: 2
```

Il parametro `amp:` modifica soltanto la chiamata a `play` a cui è associato. Così, ad esempio, la prima chiamata a `play` è a metà volume, mentre la seconda è di nuovo sul valore di default:

```
play 60, amp: 0.5
sleep 0.5
play 65
```

Naturalmente puoi usare differenti valori per `amp:` per ogni play:

```
play 50, amp: 0.1
sleep 0.25
play 55, amp: 0.2
sleep 0.25
play 57, amp: 0.4
sleep 0.25
play 62, amp: 1
```

## Panning

Un altro parametro divertente è `pan:`, che controlla la collocazione del suono (*panning*) sul fronte stereofonico. In Sonic Pi usiamo un -1 per posizionare il suono tutto a sinistra, 0 per posizionare il suono al centro e 1 per posizionare il suono tutto a destra. 

Facciamo suonare un beep dall’altoparlante a sinistra:

```
play 60, pan: -1
```

Ora, dall’altoparlante a destra:

```
play 60, pan: 1
```

Infine, facciamolo suonare al centro (che è la posizione di default):

```
play 60, pan: 0
```

E adesso divertiti a cambiare le ampiezze e il panning dei tuoi suoni!