/*
 * $Id: gtkledbar.h,v 1.3 2001/10/29 23:41:48 iain Exp $
 * GTKEXT - Extensions to The GIMP Toolkit
 * Copyright (C) 1998 Gregory McLean
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Cambridge, MA 
 * 02139, USA.
 *
 * Eye candy!
 */

/*
 * DeGNOMEization and fixes - 2002/07/06 Carlos Rodrigues <cer09566@students.fct.unl.pt>
 */

#ifndef __GTKLEDBAR_H__
#define __GTKLEDBAR_H__

#include <gdk/gdk.h>
#include <gtk/gtkvbox.h>
#include "gtkled.h"

G_BEGIN_DECLS
#define GTK_LED_BAR_TYPE (gtk_led_bar_get_type ())
#define GTK_LED_BAR(obj)          G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_LED_BAR_TYPE, GtkLedBar)
#define GTK_LED_BAR_CLASS(klass)  G_TYPE_CHECK_CLASS_CAST ((klass), GTK_LED_BAR_TYPE (), GtkLedBarClass)
#define IS_GTK_LED_BAR(obj)       G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_LED_BAR_TYPE)
#define MAX_SEGMENTS         20
typedef struct _GtkLedBar GtkLedBar;
typedef struct _GtkLedBarClass GtkLedBarClass;

struct _GtkLedBar
{
  GtkVBox vbox;

  GtkWidget *segments[MAX_SEGMENTS];
  gint num_segments;		/* How many segmanets in this bar */
  gint lit_segments;		/* last segment that is lit */
  gint seq_segment;		/* which led in the sequence we are at */
  gint seq_dir;			/* direction */
  gint orientation;		/* horizontal (0), or vertical (1) */
};

struct _GtkLedBarClass
{
  GtkVBoxClass parent_class;
};

GType gtk_led_bar_get_type (void);
GtkWidget *gtk_led_bar_new (gint segments, gint orientation);
gint gtk_led_bar_get_num_segments (GtkWidget * bar);
gint gtk_led_bar_last_lit_segment (GtkWidget * bar);	/* -1 if none */
void gtk_led_bar_light_segments (GtkWidget * bar, gint num);
void gtk_led_bar_unlight_segments (GtkWidget * bar, gint num);
void gtk_led_bar_light_segment (GtkWidget * bar, gint segment);
void gtk_led_bar_unlight_segment (GtkWidget * bar, gint segment);
void gtk_led_bar_light_percent (GtkWidget * bar, gfloat percent);
void gtk_led_bar_sequence_step (GtkWidget * bar);
void gtk_led_bar_clear (GtkWidget * bar);

G_END_DECLS
#endif
/* EOF */
