/* Somaplayer - Copyright (C) 2003-5 bakunin - Andrea Marchesini 
 *                                     <bakunin@autistici.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This program is released under the GPL with the additional exemption that
 * compiling, linking, and/or using OpenSSL is allowed.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
# error Use configure; make; make install
#endif

#include "../player.h"
#include "../other.h"
#include "queue.h"
#include "graphic.h"

static int search_win = 1;
static GtkWidget *search_entry = NULL;
static GtkWidget *search_tv = NULL;

gboolean
search_key_event (GtkWidget * w, GdkEventKey * event, gpointer dummy)
{
  if (event->keyval == GDK_Escape)
    {
      search_window_show (NULL, NULL);
      return TRUE;
    }

  return FALSE;
}

int
search_cmp_fragment (char *a, char *b)
{
  int l1, l2;

  l1 = strlen (a);
  l2 = strlen (b);

  while (l2 <= l1)
    {

      l1 = strlen (a);

      if (!strncasecmp (a, b, l2))
	return 1;

      a++;
    }

  return 0;
}

int
search_cmp (char *a, char *b)
{
  char dump[1024];
  char part[1024];
  int k = 0;
  int i;
  int len = strlen (b);
  int ret = 1;

  strncpy (dump, b, sizeof (dump));
  dump[len] = 0;

  for (i = 0; i < len; i++)
    {
      if (dump[i] == ' ' || dump[i] == '\t' || dump[i] == '\v'
	  || dump[i] == '\n')
	{

	  if (i > k)
	    {
	      strncpy (part, dump + k, i - k);
	      part[i - k] = 0;
	      ret = search_cmp_fragment (a, part);
	      if (!ret)
		break;
	    }
	  k = i + 1;
	}
    }

  if (i > k && ret > 0)
    {
      strncpy (part, dump + k, i - k);
      part[i - k] = 0;
      ret = search_cmp_fragment (a, part);
    }

  return ret;
}

void
search_search (GtkWidget * w, gpointer dummy)
{
  GtkListStore *store;
  GtkTreeIter iter;
  char *text;
  char *utf8;
  list *tmp;

  store =
    (GtkListStore *) gtk_tree_view_get_model (GTK_TREE_VIEW (search_tv));
  text = (char *) gtk_entry_get_text (GTK_ENTRY (search_entry));

  pthread_mutex_lock (&play->m_list);

  tmp = play->first;

  while (gtk_tree_model_iter_nth_child
	 (GTK_TREE_MODEL (store), &iter, NULL, 0))
    gtk_list_store_remove (store, &iter);

  while (tmp)
    {

      if ((text && text[0] && search_cmp (tmp->name, text))
	  || (!text || !text[0]))
	{
	  utf8 =
	    g_convert (tmp->name, strlen (tmp->name), "UTF-8", "ISO-8859-1",
		       NULL, NULL, NULL);
	  gtk_list_store_append (store, &iter);
	  gtk_list_store_set (store, &iter, 0, utf8, 1, tmp, -1);
	  free (utf8);

	}

      tmp = tmp->next;
    }

  pthread_mutex_unlock (&play->m_list);
}

gboolean
search_select (GtkWidget * widget, GdkEventButton * event,
	       GtkTreeSelection * selection)
{
  if (event->type == GDK_2BUTTON_PRESS)
    {
      GtkTreeModel *model;
      GtkTreeIter iter;
      void *data;
      GList *list;

      if ((list = gtk_tree_selection_get_selected_rows (selection, &model)))
	{
	  gtk_tree_model_get_iter (GTK_TREE_MODEL (model), &iter, list->data);
	  gtk_tree_model_get (GTK_TREE_MODEL (model), &iter, 1, &data, -1);
	  gtk_tree_path_free (list->data);

	  play->playlist_selected = data;
	  events.skip = 1;

	  if (events.stop)
	    events.stop = 0;
	  if (events.pause)
	    events.pause = 0;

	  pthread_cond_signal (&play->p_pop);
	  g_list_free (list);

	}

      search_window_show (NULL, NULL);
    }

  return FALSE;
}

void
search_play (GtkWidget * w, GtkTreeSelection * selection)
{
  GtkTreeModel *model;
  GtkTreeIter iter;
  void *data;
  GList *list;

  if ((list = gtk_tree_selection_get_selected_rows (selection, &model)))
    {
      gtk_tree_model_get_iter (GTK_TREE_MODEL (model), &iter, list->data);
      gtk_tree_model_get (GTK_TREE_MODEL (model), &iter, 1, &data, -1);
      gtk_tree_path_free (list->data);

      play->playlist_selected = data;
      events.skip = 1;

      if (events.stop)
	events.stop = 0;
      if (events.pause)
	events.pause = 0;

      pthread_cond_signal (&play->p_pop);

      g_list_free (list);

    }

  search_window_show (NULL, NULL);
}

void
search_queue (GtkWidget * w, GtkTreeSelection * selection)
{
  GtkTreeModel *model;
  GtkTreeIter iter;
  void *data;
  GList *list, *old;

  if ((list = gtk_tree_selection_get_selected_rows (selection, &model)))
    {
      old = list;

      while (list)
	{
	  gtk_tree_model_get_iter (GTK_TREE_MODEL (model), &iter, list->data);
	  gtk_tree_model_get (GTK_TREE_MODEL (model), &iter, 1, &data, -1);
	  gtk_tree_path_free (list->data);

	  queue_insert (data);

	  list = list->next;
	}

      g_list_free (old);

    }
}

GtkWidget *
create_winsearch (void)
{
  GtkWidget *window;
  GtkWidget *box;
  GtkWidget *vbox;
  GtkWidget *hbox;
  GtkWidget *button;
  GtkWidget *sw;
  GtkWidget *label;
  GtkWidget *image;
  GtkListStore *model;
  GtkTreeSelection *selection;
  GtkCellRenderer *renderer;

  char s[1024];

  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  snprintf (s, sizeof (s), _("%s %s - Search file"), NAME, VERSION);
  gtk_window_set_title (GTK_WINDOW (window), s);
  gtk_widget_set_size_request (window, 400, 400);

  g_signal_connect ((gpointer) window, "delete_event",
		    G_CALLBACK (search_window_show), window);

  g_signal_connect ((gpointer) window, "key-press-event",
		    GTK_SIGNAL_FUNC (search_key_event), NULL);

  vbox = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox);
  gtk_container_add (GTK_CONTAINER (window), vbox);

  hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, TRUE, 0);

  sw = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (sw);
  gtk_box_pack_start (GTK_BOX (vbox), sw, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (sw),
				  GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  model = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_POINTER);
  search_tv = gtk_tree_view_new_with_model (GTK_TREE_MODEL (model));
  gtk_tree_view_set_enable_search (GTK_TREE_VIEW (search_tv), FALSE);
  gtk_container_add (GTK_CONTAINER (sw), search_tv);
  gtk_widget_show (search_tv);
  selection = gtk_tree_view_get_selection (GTK_TREE_VIEW (search_tv));
  gtk_tree_selection_set_mode (selection, GTK_SELECTION_MULTIPLE);
  gtk_tree_view_set_rules_hint (GTK_TREE_VIEW (search_tv), TRUE);
  g_object_unref (model);

  g_signal_connect ((gpointer) search_tv, "button-press-event",
		    GTK_SIGNAL_FUNC (search_select), selection);

  renderer = gtk_cell_renderer_text_new ();
  gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (search_tv), -1,
					       "Results", renderer,
					       "text", 0, NULL);

  search_entry = gtk_entry_new ();
  gtk_widget_show (search_entry);
  gtk_box_pack_start (GTK_BOX (hbox), search_entry, TRUE, TRUE, 0);

  gtk_signal_connect (GTK_OBJECT (search_entry), "changed",
		      GTK_SIGNAL_FUNC (search_search), NULL);

  button = gtk_button_new ();
  gtk_widget_show (button);
  gtk_box_pack_start (GTK_BOX (hbox), button, FALSE, FALSE, 0);

  box = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (box);
  gtk_container_add (GTK_CONTAINER (button), box);

  image = gtk_image_new_from_stock ("gtk-find", GTK_ICON_SIZE_MENU);
  gtk_widget_show (image);
  gtk_box_pack_start (GTK_BOX (box), image, FALSE, FALSE, 0);

  label = gtk_label_new_with_mnemonic (_("Search"));
  gtk_widget_show (label);
  gtk_box_pack_start (GTK_BOX (box), label, FALSE, FALSE, 0);

  gtk_signal_connect (GTK_OBJECT (button), "clicked",
		      GTK_SIGNAL_FUNC (search_search), NULL);

  hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, TRUE, 0);

  button = gtk_button_new ();
  gtk_widget_show (button);
  gtk_box_pack_start (GTK_BOX (hbox), button, TRUE, TRUE, 0);

  g_signal_connect ((gpointer) button, "clicked",
		    G_CALLBACK (search_window_show), window);

  box = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (box);
  gtk_container_add (GTK_CONTAINER (button), box);

  image = gtk_image_new_from_stock ("gtk-close", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image);
  gtk_box_pack_start (GTK_BOX (box), image, TRUE, TRUE, 0);

  label = gtk_label_new (_("Close"));
  gtk_widget_show (label);
  gtk_box_pack_start (GTK_BOX (box), label, TRUE, TRUE, 0);

  button = gtk_button_new ();
  gtk_widget_show (button);
  gtk_box_pack_start (GTK_BOX (hbox), button, TRUE, TRUE, 0);

  g_signal_connect ((gpointer) button, "clicked", G_CALLBACK (search_queue),
		    selection);

  box = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (box);
  gtk_container_add (GTK_CONTAINER (button), box);

  image = gtk_image_new_from_stock ("gtk-index", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image);
  gtk_box_pack_start (GTK_BOX (box), image, TRUE, TRUE, 0);

  label = gtk_label_new (_("Queue"));
  gtk_widget_show (label);
  gtk_box_pack_start (GTK_BOX (box), label, TRUE, TRUE, 0);

  button = gtk_button_new ();
  gtk_widget_show (button);
  gtk_box_pack_start (GTK_BOX (hbox), button, TRUE, TRUE, 0);

  g_signal_connect ((gpointer) button, "clicked", G_CALLBACK (search_play),
		    selection);

  box = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (box);
  gtk_container_add (GTK_CONTAINER (button), box);

  image = gtk_image_new_from_stock ("gtk-ok", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image);
  gtk_box_pack_start (GTK_BOX (box), image, TRUE, TRUE, 0);

  label = gtk_label_new (_("Play"));
  gtk_widget_show (label);
  gtk_box_pack_start (GTK_BOX (box), label, TRUE, TRUE, 0);

  return window;
}

int
search_window_show (GtkWidget * w, gpointer data)
{

  if (data || !search_win)
    {
      search_win = 1;
      gtk_widget_hide (winsearch);
    }
  else if (search_win)
    {
      search_search (NULL, search_tv);
      gtk_widget_show (winsearch);
      gtk_widget_grab_focus (search_entry);
      search_win = 0;
    }

  return TRUE;
}

/* EOF */
