#ifndef _SGLIB_H
#define _SGLIB_H
#include "sgtypes.h"
void FractionU64_Reduce(FractionU64_t *frac);
void SGLib_Init(void);

extern uint8_t sglib_onecount_map[256];

static inline int
SGLib_OnecountU32(uint32_t w)
{
        int c=0;
        while (w) {
                c += sglib_onecount_map[w & 255];
                w >>= 8;
        }
        return c;
}

static inline int
SGLib_OnecountU8(uint8_t w)
{
	return sglib_onecount_map[w];
}

static inline uint32_t
GrayEncodeU32(uint32_t to_encode) 
{
        return to_encode ^ (to_encode >> 1);
}
uint32_t GrayDecodeU32(uint32_t to_decode);

#endif
