/*
 * -------------------------------------------------------------------------
 *
 * Dummy sound backend for softgun used when no other sound backend
 * is used. It eats the sound samples and does nothing
 *
 * (C) 2009 Jochen Karrer
 *
 * State:
 *      Working 
 *
 *  This program is free software; you can distribute it and/or modify it
 *  under the terms of the GNU General Public License (Version 2) as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston MA 02111-1307, USA.
 *
 * ------------------------------------------------------------------------
 */


#include <stdio.h>
#include "sound.h"
#include "sgstring.h"
#include "signode.h"

static int 
NullDev_SetSoundFormat(SoundDevice *dev,SoundFormat *format) 
{
	return 0;
}

static int 
NullDev_PlaySamples(SoundDevice *dev,void *data,uint32_t len)
{
	return len;
}

SoundDevice *
NullSound_New(const char *name) 
{
	SoundDevice *sdev = sg_new(SoundDevice);	
	sdev->setSoundFormat = NullDev_SetSoundFormat;
	sdev->playSamples = NullDev_PlaySamples;
	sdev->speedUp = SigNode_New("%s.speed_up",name);
	sdev->speedDown = SigNode_New("%s.speed_down",name);
	if(!sdev->speedUp || ! sdev->speedDown) {
		fprintf(stderr,"Can not create sound speed control lines\n");
		exit(1);
	}
	fprintf(stderr,"Created Null sound device \"%s\" for eating up sound\n",name);
	return sdev;
}
