#include <stdint.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "idecode_m6510.h"
#include "instructions_m6510.h"
#include "sgstring.h"

MOS6510_InstructionProc **mos6510_iProcTab = NULL;
MOS6510_Instruction **mos6510_instrTab = NULL;

static MOS6510_Instruction instrlist[] =  {
{ 0xff,0x00,"BRK",m6510_brk},
{ 0xff,0x01,"ORA",m6510_ora},
{ 0xff,0x02,"JAM",m6510_jam},
{ 0xff,0x03,"SLO",m6510_slo},
{ 0xff,0x04,"NOP",m6510_nop},
{ 0xff,0x05,"ORA",m6510_ora},
{ 0xff,0x06,"ASL",m6510_asl},
{ 0xff,0x07,"SLO",m6510_slo},
{ 0xff,0x08,"PHP",m6510_php},
{ 0xff,0x09,"ORA",m6510_ora},
{ 0xff,0x0a,"ASL_A",m6510_asl_a},
{ 0xff,0x0b,"ANC",m6510_anc},
{ 0xff,0x0c,"NOP",m6510_nop},
{ 0xff,0x0f,"ORA",m6510_ora},
{ 0xff,0x10,"BPL",m6510_bpl},
{ 0xff,0x11,"ORA",m6510_ora},
{ 0xff,0x12,"JAM",m6510_jam},
{ 0xff,0x13,"SLO",m6510_slo},
{ 0xff,0x14,"BPL",m6510_bpl},
{ 0xff,0x15,"ORA",m6510_ora},
{ 0xff,0x16,"ASL",m6510_asl},
{ 0xff,0x17,"SLO",m6510_slo},
{ 0xff,0x18,"CLC",m6510_clc},
{ 0xff,0x19,"ORA",m6510_ora},
{ 0xff,0x1a,"NOP",m6510_nop},
{ 0xff,0x1b,"SLO",m6510_slo},
{ 0xff,0x1c,"NOP",m6510_nop},
{ 0xff,0x1d,"ORA",m6510_ora},
{ 0xff,0x1e,"ASL",m6510_asl},
{ 0xff,0x1f,"SLO",m6510_slo},
{ 0xff,0x20,"JSR",m6510_jsr},
{ 0xff,0x21,"AND",m6510_and},
{ 0xff,0x22,"JAM",m6510_jam},
{ 0xff,0x23,"RLA",m6510_rla},
{ 0xff,0x24,"BIT",m6510_bit},
{ 0xff,0x26,"AND",m6510_and},
{ 0xff,0x27,"RLA",m6510_rla},
{ 0xff,0x28,"PLP",m6510_plp},
{ 0xff,0x29,"AND",m6510_and},
{ 0xff,0x2a,"ROL",m6510_rol},
{ 0xff,0x2b,"ANC",m6510_anc},
{ 0xff,0x2c,"BIT",m6510_bit},
{ 0xff,0x2d,"AND",m6510_and},
{ 0xff,0x2e,"ROL",m6510_rol},
{ 0xff,0x2f,"RLA",m6510_rla},
{ 0xff,0x30,"BMI",m6510_bmi},
{ 0xff,0x31,"AND",m6510_and},
{ 0xff,0x32,"JAM",m6510_jam},
{ 0xff,0x33,"RLA",m6510_rla},
{ 0xff,0x34,"NOP",m6510_nop},
{ 0xff,0x35,"AND",m6510_and},
{ 0xff,0x36,"ROL",m6510_rol},
{ 0xff,0x37,"RLA",m6510_rla},
{ 0xff,0x38,"SEC",m6510_sec},
{ 0xff,0x39,"AND",m6510_and},
{ 0xff,0x3a,"NOP",m6510_nop},
{ 0xff,0x3b,"RLA",m6510_rla},
{ 0xff,0x3c,"NOP",m6510_nop},
{ 0xff,0x3d,"AND",m6510_and},
{ 0xff,0x3e,"ROL",m6510_rol},
{ 0xff,0x3f,"RLA",m6510_rla},
{ 0xff,0x40,"RTI",m6510_rti},
{ 0xff,0x41,"EOR",m6510_eor},
{ 0xff,0x42,"JAM",m6510_jam},
{ 0xff,0x43,"SRE",m6510_sre},
{ 0xff,0x44,"NOP",m6510_nop},
{ 0xff,0x45,"EOR",m6510_eor},
{ 0xff,0x46,"LSR",m6510_lsr},
{ 0xff,0x47,"SRE",m6510_sre},
{ 0xff,0x48,"PHA",m6510_pha},
{ 0xff,0x49,"EOR",m6510_eor},
{ 0xff,0x4a,"LSR",m6510_lsr},
{ 0xff,0x4b,"ASR",m6510_asr},
{ 0xff,0x4c,"JMP",m6510_jmp},
{ 0xff,0x4d,"EOR",m6510_eor},
{ 0xff,0x4e,"LSR",m6510_lsr},
{ 0xff,0x4f,"SRE",m6510_sre},
{ 0xff,0x50,"BVC",m6510_bvc},
{ 0xff,0x51,"EOR",m6510_eor},
{ 0xff,0x52,"JAM",m6510_jam},
{ 0xff,0x53,"SRE",m6510_sre},
{ 0xff,0x54,"NOP",m6510_nop},
{ 0xff,0x55,"EOR",m6510_eor},
{ 0xff,0x56,"LSR",m6510_lsr},
{ 0xff,0x57,"SRE",m6510_sre},
{ 0xff,0x58,"CLI",m6510_cli},
{ 0xff,0x59,"EOR",m6510_eor},
{ 0xff,0x5a,"NOP",m6510_nop},
{ 0xff,0x5b,"SRE",m6510_sre},
{ 0xff,0x5c,"NOP",m6510_nop},
{ 0xff,0x5d,"EOR",m6510_eor},
{ 0xff,0x5e,"LSR",m6510_lsr},
{ 0xff,0x5f,"SRE",m6510_sre},
{ 0xff,0x60,"RTS",m6510_rts},
{ 0xff,0x61,"ADC",m6510_adc},
{ 0xff,0x62,"JAM",m6510_jam},
{ 0xff,0x63,"RRA",m6510_rra},
{ 0xff,0x64,"NOP",m6510_nop},
{ 0xff,0x65,"ADC",m6510_adc},
{ 0xff,0x66,"ROR",m6510_ror},
{ 0xff,0x67,"RRA",m6510_rra},
{ 0xff,0x68,"PLA",m6510_pla},
{ 0xff,0x69,"ADC",m6510_adc},
{ 0xff,0x6a,"ROR",m6510_ror},
{ 0xff,0x6b,"ARR",m6510_arr},
{ 0xff,0x6c,"JMP",m6510_jmp},
{ 0xff,0x6d,"ADC",m6510_adc},
{ 0xff,0x6e,"ROR",m6510_ror},
{ 0xff,0x6f,"RRA",m6510_rra},
{ 0xff,0x70,"BVS",m6510_bvs},
{ 0xff,0x71,"ADC",m6510_adc},
{ 0xff,0x72,"JAM",m6510_jam},
{ 0xff,0x73,"RRA",m6510_rra},
{ 0xff,0x74,"NOP",m6510_nop},
{ 0xff,0x75,"ADC",m6510_adc},
{ 0xff,0x76,"ROR",m6510_ror},
{ 0xff,0x77,"RRA",m6510_rra},
{ 0xff,0x78,"SEI",m6510_sei},
{ 0xff,0x79,"ADC",m6510_adc},
{ 0xff,0x7a,"NOP",m6510_adc},
{ 0xff,0x7b,"RRA",m6510_rra},
{ 0xff,0x7c,"NOP",m6510_nop},
{ 0xff,0x7d,"ADC",m6510_adc},
{ 0xff,0x7e,"ROR",m6510_ror},
{ 0xff,0x7f,"RRA",m6510_rra},
{ 0xff,0x80,"NOP",m6510_nop},
{ 0xff,0x81,"STA",m6510_sta},
{ 0xff,0x82,"NOPjam",m6510_nop},
{ 0xff,0x83,"SAX",m6510_sax},
{ 0xff,0x84,"STY",m6510_sty},
{ 0xff,0x85,"STA",m6510_stx},
{ 0xff,0x86,"STX",m6510_stx},
{ 0xff,0x87,"SAX",m6510_sax},
{ 0xff,0x88,"DEY",m6510_dey},
{ 0xff,0x89,"NOP",m6510_nop},
{ 0xff,0x8a,"TXA",m6510_txa},
{ 0xff,0x8b,"ANE",m6510_ane},
{ 0xff,0x8c,"STY",m6510_sty},
{ 0xff,0x8d,"STA",m6510_sta},
{ 0xff,0x8e,"STX",m6510_stx},
{ 0xff,0x8f,"SAX",m6510_sax},
{ 0xff,0x90,"BCC",m6510_bcc},
{ 0xff,0x91,"STA",m6510_sta},
{ 0xff,0x92,"JAM",m6510_jam},
{ 0xff,0x93,"SHA",m6510_sha},
{ 0xff,0x94,"STY",m6510_sty},
{ 0xff,0x95,"STA",m6510_sta},
{ 0xff,0x96,"STX",m6510_stx},
{ 0xff,0x97,"SAX",m6510_sax},
{ 0xff,0x98,"TYA",m6510_tya},
{ 0xff,0x99,"STA",m6510_sta},
{ 0xff,0x9a,"TXS",m6510_txs},
{ 0xff,0x9b,"SHS",m6510_shs},
{ 0xff,0x9c,"SHY",m6510_shy},
{ 0xff,0x9d,"STA",m6510_sta},
{ 0xff,0x9e,"SHX",m6510_shx},
{ 0xff,0x9f,"SHA",m6510_sha},
{ 0xff,0xa0,"LDY",m6510_ldy},
{ 0xff,0xa1,"LDA",m6510_lda},
{ 0xff,0xa2,"LDX",m6510_ldx},
{ 0xff,0xa3,"LAX",m6510_lax},
{ 0xff,0xa4,"LDY",m6510_ldy},
{ 0xff,0xa5,"LDA",m6510_lda},
{ 0xff,0xa6,"LDX",m6510_ldx},
{ 0xff,0xa7,"LAX",m6510_lax},
{ 0xff,0xa8,"TAY",m6510_tay},
{ 0xff,0xa9,"LDA",m6510_lda},
{ 0xff,0xaa,"TAX",m6510_tax},
{ 0xff,0xab,"LXA",m6510_lxa},
{ 0xff,0xac,"LDY",m6510_ldy},
{ 0xff,0xad,"LDA",m6510_lda},
{ 0xff,0xae,"LDX",m6510_ldx},
{ 0xff,0xaf,"LAX",m6510_lax},
{ 0xff,0xb0,"BCS",m6510_bcs},
{ 0xff,0xb1,"LDA",m6510_lda},
{ 0xff,0xb2,"JAM",m6510_jam},
{ 0xff,0xb3,"LAX",m6510_lax},
{ 0xff,0xb4,"LDY",m6510_ldy},
{ 0xff,0xb5,"LDA",m6510_lda},
{ 0xff,0xb6,"LDX",m6510_ldx},
{ 0xff,0xb7,"LAX",m6510_lax},
{ 0xff,0xb8,"CLV",m6510_clv},
{ 0xff,0xb9,"LDA",m6510_lda},
{ 0xff,0xba,"TSX",m6510_tsx},
{ 0xff,0xbb,"LAS",m6510_las},
{ 0xff,0xbc,"LDY",m6510_ldy},
{ 0xff,0xbd,"LDA",m6510_lda},
{ 0xff,0xbe,"LDX",m6510_ldx},
{ 0xff,0xbf,"LAX",m6510_lax},
{ 0xff,0xc0,"CPY",m6510_cpy},
{ 0xff,0xc1,"CMP",m6510_cmp},
{ 0xff,0xc2,"NOPjam",m6510_nop},
{ 0xff,0xc3,"DCP",m6510_dcp},
{ 0xff,0xc4,"CPY",m6510_cpy},
{ 0xff,0xc5,"CMP",m6510_cmp},
{ 0xff,0xc6,"DEC",m6510_dec},
{ 0xff,0xc7,"DCP",m6510_dcp},
{ 0xff,0xc8,"INY",m6510_iny},
{ 0xff,0xc9,"CMP",m6510_cmp},
{ 0xff,0xca,"DEX",m6510_dex},
{ 0xff,0xcb,"SBX",m6510_sbx},
{ 0xff,0xcc,"CPY",m6510_cpy},
{ 0xff,0xcd,"CMP",m6510_cmp},
{ 0xff,0xce,"DEC",m6510_dec},
{ 0xff,0xcf,"DCP",m6510_dcp},
{ 0xff,0xd0,"BNE",m6510_bne},
{ 0xff,0xd1,"CMP",m6510_cmp},
{ 0xff,0xd2,"JAM",m6510_jam},
{ 0xff,0xd3,"DCP",m6510_dcp},
{ 0xff,0xd4,"NOP",m6510_nop},
{ 0xff,0xd5,"CMP",m6510_cmp},
{ 0xff,0xd6,"DEC",m6510_dec},
{ 0xff,0xd7,"DCP",m6510_dcp},
{ 0xff,0xd8,"CLD",m6510_cld},
{ 0xff,0xd9,"CMP",m6510_cmp},
{ 0xff,0xda,"NOP",m6510_nop},
{ 0xff,0xdb,"DCP",m6510_dcp},
{ 0xff,0xdc,"NOP",m6510_nop},
{ 0xff,0xdd,"CMP",m6510_cmp},
{ 0xff,0xde,"DEC",m6510_dec},
{ 0xff,0xdf,"DCP",m6510_dcp},
{ 0xff,0xe0,"CPX",m6510_cpx},
{ 0xff,0xe1,"SBC",m6510_sbc},
{ 0xff,0xe2,"NOPjam",m6510_nop},
{ 0xff,0xe3,"ISB",m6510_isb},
{ 0xff,0xe4,"CPX",m6510_cpx},
{ 0xff,0xe5,"SBC",m6510_sbc},
{ 0xff,0xe6,"INC",m6510_inc},
{ 0xff,0xe7,"ISB",m6510_isb},
{ 0xff,0xe8,"INX",m6510_inx},
{ 0xff,0xe9,"SBC",m6510_sbc},
{ 0xff,0xea,"NOP",m6510_nop},
{ 0xff,0xeb,"SBC",m6510_sbc},
{ 0xff,0xec,"CPX",m6510_cpx},
{ 0xff,0xed,"SBC",m6510_sbc},
{ 0xff,0xee,"INC",m6510_inc},
{ 0xff,0xef,"ISB",m6510_inc},
{ 0xff,0xf0,"BEQ",m6510_beq},
{ 0xff,0xf1,"SBC",m6510_sbc},
{ 0xff,0xf2,"JAM",m6510_jam},
{ 0xff,0xf3,"ISB",m6510_isb},
{ 0xff,0xf4,"NOP",m6510_nop},
{ 0xff,0xf5,"SBC",m6510_sbc},
{ 0xff,0xf6,"INC",m6510_inc},
{ 0xff,0xf7,"ISB",m6510_isb},
{ 0xff,0xf8,"SED",m6510_sed},
{ 0xff,0xf9,"SBC",m6510_sbc},
{ 0xff,0xfa,"NOP",m6510_nop},
{ 0xff,0xfb,"ISB",m6510_isb},
{ 0xff,0xfc,"NOP",m6510_nop},
{ 0xff,0xfd,"SBC",m6510_sbc},
{ 0xff,0xfe,"INC",m6510_inc},
{ 0xff,0xff,"ISB",m6510_inc}

};

void
Mos6510_IdecoderNew(void) 
{
	MOS6510_Instruction *instr;
	int icode,j;	
	mos6510_iProcTab = sg_calloc(sizeof(MOS6510_InstructionProc *) * 0x100);
        mos6510_instrTab =  sg_calloc(sizeof(MOS6510_Instruction *) * 0x100);

	for(icode=0;icode<256;icode++) {
		for(j=0;j < array_size(instrlist);j++) {
			instr = &instrlist[j];
			if((icode & instr->mask) == instr->icode) {
				mos6510_iProcTab[icode] = instr->proc;
				mos6510_instrTab[icode] = instr;
			}
		}
	}
}
