#include <stdint.h>
#include <diskimage.h>

#define FLG_C	(1<<0)
#define FLG_Z	(1<<1)
#define FLG_N	(1<<2)
#define FLG_V	(1<<3)
#define FLG_S	(1<<4)
#define FLG_H	(1<<5)
#define FLG_T	(1<<6)
#define FLG_I	(1<<7)

typedef struct AVR8_Cpu {
	uint8_t sreg;
	uint16_t sp;
	uint32_t pc;

	/* The memory */
	uint8_t *sram;	
	uint16_t *appmem;
	uint32_t appmem_words;
	uint32_t sram_bytes;
	
	DiskImage *flash_di;

	/* The current instruction */
	uint32_t icode; 
} AVR8_Cpu;

extern AVR8_Cpu gavr8;
static inline uint8_t
AVR8_ReadReg(int reg) 
{
	return gavr8.sram[reg];
}

static inline void
AVR8_WriteReg(uint8_t val,int reg) 
{
	gavr8.sram[reg] = val;
}

static inline uint16_t
AVR8_ReadAppMem(uint32_t word_addr) 
{
	return gavr8.appmem[word_addr & (gavr8.appmem_words - 1)];	
}


#define GET_REG_PC (gavr8.pc)
#define SET_REG_PC(val) (gavr8.pc = (val))
#define ICODE	(gavr8.icode)

void AVR8_Run();
void AVR8_Init(const char *instancename);
