/******************************************************************************
*       SOFA, Simulation Open-Framework Architecture, version 1.0 beta 3      *
*                (c) 2006-2008 MGH, INRIA, USTL, UJF, CNRS                    *
*                                                                             *
* This library is free software; you can redistribute it and/or modify it     *
* under the terms of the GNU Lesser General Public License as published by    *
* the Free Software Foundation; either version 2.1 of the License, or (at     *
* your option) any later version.                                             *
*                                                                             *
* This library is distributed in the hope that it will be useful, but WITHOUT *
* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or       *
* FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License *
* for more details.                                                           *
*                                                                             *
* You should have received a copy of the GNU Lesser General Public License    *
* along with this library; if not, write to the Free Software Foundation,     *
* Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301 USA.          *
*******************************************************************************
*                               SOFA :: Modules                               *
*                                                                             *
* Authors: The SOFA Team and external contributors (see Authors.txt)          *
*                                                                             *
* Contact information: contact@sofa-framework.org                             *
******************************************************************************/

#include <sofa/component/topology/HexahedronSetTopologyAlgorithms.h>
#include <sofa/component/topology/HexahedronSetTopologyAlgorithms.inl>
#include <sofa/defaulttype/Vec3Types.h>
#include <sofa/core/ObjectFactory.h>

namespace sofa
{
namespace component
{
namespace topology
{
	using namespace sofa::defaulttype;
  SOFA_DECL_CLASS(HexahedronSetTopologyAlgorithms)
        int HexahedronSetTopologyAlgorithmsClass = core::RegisterObject("Hexahedron set topology algorithms")
	#ifdef SOFA_FLOAT
	.add< HexahedronSetTopologyAlgorithms<Vec3fTypes> >(true) // default template
	#else
	.add< HexahedronSetTopologyAlgorithms<Vec3dTypes> >(true) // default template    
	#ifndef SOFA_DOUBLE
	.add< HexahedronSetTopologyAlgorithms<Vec3fTypes> >() // default template
	#endif
	#endif
	#ifndef SOFA_FLOAT
	.add< HexahedronSetTopologyAlgorithms<Vec2dTypes> >()
	.add< HexahedronSetTopologyAlgorithms<Vec1dTypes> >()
	#endif
	#ifndef SOFA_DOUBLE
	.add< HexahedronSetTopologyAlgorithms<Vec2fTypes> >()
	.add< HexahedronSetTopologyAlgorithms<Vec1fTypes> >()
	#endif
	;
	#ifndef SOFA_FLOAT
	template class HexahedronSetTopologyAlgorithms<Vec3dTypes>;
	template class HexahedronSetTopologyAlgorithms<Vec2dTypes>;
	template class HexahedronSetTopologyAlgorithms<Vec1dTypes>;
	#endif

	#ifndef SOFA_DOUBLE
	template class HexahedronSetTopologyAlgorithms<Vec3fTypes>;
	template class HexahedronSetTopologyAlgorithms<Vec2fTypes>;
	template class HexahedronSetTopologyAlgorithms<Vec1fTypes>;
	#endif

} // namespace topology

} // namespace component

} // namespace sofa

