/* $Id$ */
/*
** Copyright (C) 2002-2009 Sourcefire, Inc.
** Author(s):   Andrew R. Baker <andrewb@sourcefire.com>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License Version 2 as
** published by the Free Software Foundation.  You may not use, modify or
** distribute this program under any other version of the GNU General
** Public License.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
#ifndef __SIGNATURE_H__
#define __SIGNATURE_H__

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#ifdef OSF1
#include <sys/bitypes.h>
#endif

#include <sys/types.h>
#include <stdio.h>

#include "sfutil/sfghash.h"
#include "sf_types.h"

/* Enable Port Lists */
#define PORTLISTS

struct _OptTreeNode;
struct _SnortConfig;
struct _RuleTreeNode;

/* this contains a list of the URLs for various reference systems */
typedef struct _ReferenceSystemNode
{
    char *name;
    char *url;
    struct _ReferenceSystemNode *next;

} ReferenceSystemNode;

ReferenceSystemNode * ReferenceSystemAdd(ReferenceSystemNode **, char *, char *);
ReferenceSystemNode * ReferenceSystemLookup(ReferenceSystemNode *, char *);
void ParseReferenceSystemConfig(char *args);


/* XXX: update to point to the ReferenceURLNode in the referenceURL list */
typedef struct _ReferenceNode
{
    char *id;
    ReferenceSystemNode *system;
    struct _ReferenceNode *next;

} ReferenceNode;

ReferenceNode * AddReference(struct _SnortConfig *, ReferenceNode **, char *, char *);
void FPrintReference(FILE *, ReferenceNode *);

/* struct for rule classification */
typedef struct _ClassType
{
    char *type;      /* classification type */
    int id;          /* classification id */
    char *name;      /* "pretty" classification name */
    int priority;    /* priority */
    struct _ClassType *next;
} ClassType;

void ParseClassificationConfig(char *);

/* NOTE:  These lookups can only be done during parse time */
ClassType * ClassTypeLookupByType(struct _SnortConfig *, char *);
ClassType * ClassTypeLookupById(struct _SnortConfig *, int);

/*
 *  sid-gid -> otn mapping
 */
typedef struct _OtnKey
{
   uint32_t gid;
   uint32_t sid;

} OtnKey;

#define SI_RULE_FLUSHING_OFF 0
#define SI_RULE_FLUSHING_ON  1

#define SI_RULE_TYPE_DETECT  0
#define SI_RULE_TYPE_DECODE  1
#define SI_RULE_TYPE_PREPROC 2

#ifdef TARGET_BASED
#ifdef PORTLISTS 
typedef struct _ServiceInfo
{
    char *service;
    int16_t service_ordinal;
} ServiceInfo;
#endif
#endif

typedef struct _SigInfo
{
    uint32_t   generator;
    uint32_t   id;
    uint32_t   rev;
    uint32_t   class_id;
    ClassType   *classType;
    uint32_t   priority;
    char        *message;
    ReferenceNode *refs;
    int           shared; /* shared object rule */
    int           rule_type; /* 0-std rule, 1-decoder, rule, 3 preprocessor rule */
    int           rule_flushing; /* 0-disabled, 1-enabled */
    OtnKey otnKey;
#if defined(TARGET_BASED) && defined(PORTLISTS)
    unsigned int num_services;
    ServiceInfo *services;
    char          *os;
#endif
} SigInfo;

SFGHASH * SoRuleOtnLookupNew(void);
void SoRuleOtnLookupAdd(SFGHASH *, struct _OptTreeNode *);
struct _OptTreeNode * SoRuleOtnLookup(SFGHASH *, uint32_t gid, uint32_t sid);
struct _OptTreeNode * SoRuleOtnLookupNext(uint32_t gid, uint32_t sid);
void SoRuleOtnLookupFree(SFGHASH *);

SFGHASH * OtnLookupNew(void);
void OtnLookupAdd(SFGHASH *, struct _OptTreeNode *);
struct _OptTreeNode * OtnLookup(SFGHASH *, uint32_t gid, uint32_t sid);
void OtnLookupFree(SFGHASH *);

void OtnRemove(SFGHASH *, SFGHASH *, struct _OptTreeNode *);
void OtnDeleteData(void *data);
void OtnFree(void *data);

#endif /* SIGNATURE */
