/* xg.c: s7, Ruby, and Forth bindings for gtk/pango/cairo, some of glib
 *   this file generated automatically from makexg.scm and xgdata.scm
 *   needs xen.h
 *
 * reference args initial values are usually ignored, resultant values are returned in a list.
 * null ptrs are passed and returned as #f, trailing "user_data" callback function arguments are optional (default: #f).
 * where supported, "..." args are passed as a list, trailing NULL or -1 should be omitted.
 * 'xg is added to *features*
 *
 * added funcs:
 *    (xg-version): date string.
 *    (c-array->list arr len) derefs each member of arr, returning lisp list, len=#f: null terminated array
 *    (list->c-array lst ctype) packages each member of list as c-type "type" returning (wrapped) c array
 *    (GtkTextIter): GtkTextIter struct
 *    (GtkTreeIter): GtkTreeIter struct
 *    (PangoRectangle): PangoRectangle struct
 *    (cairo_matrix_t): cairo_matrix_t struct (if cairo)
 *
 * omitted functions and macros:
 *     anything with a va_list or GtkArg* argument.
 *     most of the unusual keysym names
 *     all *_CLASS, *_IFACE macros, *_get_type functions
 *     win32-specific functions
 *
 * HISTORY:
 *
 *     --------
 *     26-May-18: remove version checks 2.14, 2.16, 2.18, 2.10, and cairo 1.8 and 1.9.
 *     --------
 *     28-Jul-17: scheme Init_libxg arg added.
 *     --------
 *     17-Mar-16: gtk_enum_t for better signature checks.
 *     --------
 *     29-Oct:    removed ->string.
 *     21-Aug-15: procedure-signature changes.
 *     --------
 *     27-Dec:    integer procedure stuff.
 *     16-Apr:    changed max-args to 8.
 *     6-Mar:     changed most macros.
 *     21-Feb-14: changed _p to _is_.
 *     --------
 *     3-Sep:     use symbol directly in type checks, not the symbol name.
 *     18-Aug:    changed the gtk version macros to reflect the version number.
 *     7-Jun-13:  added mixed arg types to the ... arg lists.
 *     --------
 *     19-Aug-10: removed lots of Gdk stuff -- we assume Gtk 2.9 and cairo now.
 *     28-Jan-10: removed the rest of the struct accessors.
 *     --------
 *     16-Dec-09: removed Guile support.
 *     --------
 *     16-Oct:    removed Gauche support.
 *     1-Sep:     s7 support.
 *     8-Jul-08:  started removing all struct accessors (for Gtk 3).
 *     --------
 *     9-Mar:     removed all *_get_type functions (nearly 300!).
 *     5-Mar-07:  cairo and more gtkprint.
 *     --------
 *     26-Aug:    removed --with-x11, WITH_GTK_AND_X11, xg-x11.h.
 *     4-Aug:     added a form of g_object_get and gtk_settings_get_for_screen.
 *     20-Jul:    gtkprint stuff.
 *     17-Jul:    g_signal_connect and other related macros.
 *     21-Apr:    Gauche support.
 *     29-Mar:    Forth support.
 *     7-Mar-06:  if g_set_error, return the error message, not the GError pointer
 *     --------
 *     9-Jul:     Collapse 2.3.* into 2.3.6, 2.5.* into 2.5.6.
 *     13-Jun:    folded xg-ruby.c into xg.c.
 *     21-Feb:    changed libxm to libxg, xm-version to xg-version.
 *     10-Jan:    plugged some memory leaks.
 *     4-Jan-05:  removed deprecated Xen_VECTOR_ELEMENTS.
 *     --------
 *     8-Dec:     added some g_log handler funcs.
 *     6-Dec:     check for lost callback context.
 *                tightened type (pointer) checking considerably (#f only acceptable if explicit @ used in xgdata.scm).
 *     3-Dec:     changed GPOINTER cast func to accept non-lists.
 *     27-Aug:    removed the PANGO_ENGINE and PANGO_BACKEND stuff.
 *     2-Jun:     gdk_atom_name needs to free return value
 *     28-May:    GtkFileSelection struct support put back in -- need ok_button et al.
 *     14-Apr:    make-target-entry.
 *     4-Apr:     various additions, deletions, and bugfixes for snd-test 26
 *     29-Mar:    support for some ... args.
 *     22-Mar:    g_source_remove and related changes.
 *     12-Feb-04: g_list_nth_data (Kjetil S. Matheussen).
 *     --------
 *     15-Sep:    removed client_window GtkIMMulticontext struct field.
 *     26-May:    removed nugatory GdkInputFunction stuff and some unused type converters.
 *     1-Apr:     gdk_property_get uses scm_mem2string in some cases now.
 *     31-Mar:    gchar* -> xen string bugfix (thanks to Friedrich Delgado Friedrichs).
 *     10-Mar-03: Ruby Xm_Version.
 *     --------
 *     18-Nov:    Ruby/Gtk bugfixes.
 *     25-Oct:    removed (deprecated) gdk_set_pointer_hooks
 *     31-Jul:    removed GTK 1.n support
 *     24-Jul:    changed Guile prefix (R5RS reserves vertical-bar).
 *     19-Jul:    XG_FIELD_PRE for change from using vertical-bar (reserved in R5RS)
 *     2-Jun:     removed deprecated and broken stuff
 *     12-Mar:    support for GtkDestroyNotify callbacks
 *                Ruby support via xg-ruby.c
 *     21-Feb:    #f=NULL throughout, gdk-pixbuf, GTypes.
 *     11-Feb-02: initial version.
 */

#include "mus-config.h"

#if ((!__NetBSD__) && ((_MSC_VER) || (!defined(__STC__)) || (defined(__STDC_VERSION__) && (__STDC_VERSION__ < 199901L))))
  #define __func__ __FUNCTION__
#endif

#if HAVE_EXTENSION_LANGUAGE

#include <string.h>
#include <stdlib.h>
#include <stdint.h>
#include <inttypes.h>

#include <glib.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#if (!GTK_CHECK_VERSION(3, 0, 0))
  #include <gdk/gdkkeysyms.h>
#endif
#include <glib-object.h>
#include <pango/pango.h>
#include <cairo/cairo.h>
#if USE_SND
  /* USE_SND causes xm to use Snd's error handlers which are much smarter than xen's fallback versions */
  #include "snd.h"
#else
  #include "xen.h"
  #define NOT_A_GC_LOC -1
#endif

#ifndef PROC_FALSE
  #if HAVE_RUBY
    #define PROC_FALSE "false"
    #define PROC_TRUE "true"
  #else
    #define PROC_FALSE "#f"
    #define PROC_TRUE  "#t"
  #endif
#endif

/* -------------------------------- GC -------------------------------- */
static Xen_object_type_t xm_obj_tag;
#if HAVE_RUBY
static void *xm_obj_free(Xen obj)
{
  void *xobj;
  xobj = (void *)obj;
  free(xobj);
  return(NULL);
}
#endif
#if HAVE_FORTH
static void xm_obj_free(Xen obj)
{
  void *val;
  val = (void *)Xen_object_ref(obj);
  free(val);
}
#endif
#if HAVE_SCHEME
static s7_pointer xm_obj_free(s7_scheme *sc, s7_pointer obj)
{
  free(s7_c_object_value(obj));
  return(NULL);
}
static s7_pointer s7_equal_xm(s7_scheme *sc, s7_pointer args)
{
  return(s7_make_boolean(sc, s7_car(args) == s7_cadr(args)));
}
#endif
static Xen make_xm_obj(void *ptr)
{
  return(Xen_make_object(xm_obj_tag, ptr, 0, xm_obj_free));
}
static void define_xm_obj(void)
{
#if HAVE_SCHEME
  xm_obj_tag = s7_make_c_type(s7, "<XmObj>");
  s7_c_type_set_gc_free(s7, xm_obj_tag, xm_obj_free);
  s7_c_type_set_is_equal(s7, xm_obj_tag, s7_equal_xm);
#else
  xm_obj_tag = Xen_make_object_type("XmObj", sizeof(void *));
#endif
#if HAVE_FORTH
  fth_set_object_free(xm_obj_tag, xm_obj_free);
#endif
}  

/* prefix for all names */
#if HAVE_SCHEME
  #define Xg_pre ""
  #define Xg_field_pre "."
  #define Xg_post ""
#endif
#if HAVE_RUBY
/* for Ruby, XG PRE needs to be uppercase */
  #define Xg_pre "R"
  #define Xg_post ""
  #define Xg_field_pre "R"
#endif
#if HAVE_FORTH
  #define Xg_pre "F"
  #define Xg_post ""
  #define Xg_field_pre "F"
#endif

static Xen xg_guint___symbol, xg_GDateTime__symbol, xg_GtkWindowHandle__symbol, xg_GtkWindowControls__symbol, xg_GtkWidget___symbol, xg_GdkSurfaceEdge_symbol, xg_GdkTimeCoord__symbol, xg_GtkColorButton__symbol, xg_GtkViewport__symbol, xg_GtkAspectFrame__symbol, xg_GdkKeymapKey__symbol, xg_GdkKeyMatch_symbol, xg_GtkAlternativeTrigger__symbol, xg_GtkMnemonicTrigger__symbol, xg_GtkKeyvalTrigger__symbol, xg_gconstpointer_symbol, xg_GtkShortcutScope_symbol, xg_GtkShortcutController__symbol, xg_GtkNamedAction__symbol, xg_GtkSignalAction__symbol, xg_GtkShortcutFunc_symbol, xg_GtkShortcutActionFlags_symbol, xg_GtkShortcutAction__symbol, xg_GtkShortcutTrigger__symbol, xg_GtkShortcut__symbol, xg_GVariantType__symbol, xg_GMenuItem__symbol, xg_GtkNative__symbol, xg_GVariant__symbol, xg_GtkWidgetActionActivateFunc_symbol, xg_GtkPopover__symbol, xg_GtkTreePath___symbol, xg_GtkMenuButtonCreatePopupFunc_symbol, xg_GtkDropTargetAsync__symbol, xg_gsize__symbol, xg_GtkDropTarget__symbol, xg_GtkDropControllerMotion__symbol, xg_GtkDragIcon__symbol, xg_GtkEventControllerFocus__symbol, xg_GtkConstraintLayout__symbol, xg_GtkConstraintTarget__symbol, xg_GtkConstraintRelation_symbol, xg_GtkConstraintAttribute_symbol, xg_GtkConstraint__symbol, xg_GtkIconLookupFlags_symbol, xg_GtkIconPaintable__symbol, xg_GtkIconTheme__symbol, xg_GtkConstraintStrength_symbol, xg_GtkConstraintGuide__symbol, xg_GtkEventControllerMotion__symbol, xg_GdkVulkanContext__symbol, xg_GError___symbol, xg_GdkFrameClock__symbol, xg_GdkModifierType__symbol, xg_GdkSurfaceState_symbol, xg_GdkToplevelLayout__symbol, xg_GdkToplevel__symbol, xg_GtkPopoverMenu__symbol, xg_GtkPopoverMenuFlags_symbol, xg_GtkCenterLayout__symbol, xg_GtkPopoverMenuBar__symbol, xg_GtkNoSelection__symbol, xg_GtkDragSource__symbol, xg_GdkAnchorHints_symbol, xg_GdkGravity_symbol, xg_GdkPopupLayout__symbol, xg_GdkPopup__symbol, xg_GdkDragSurface__symbol, xg_GtkPropagationLimit_symbol, xg_GtkGestureLongPress__symbol, xg_GtkScaleFormatValueFunc_symbol, xg_GdkContentProvider___symbol, xg_GtkFixedLayoutChild__symbol, xg_GtkTreeDragDest__symbol, xg_GtkTreeListRow__symbol, xg_GtkTreeListModel__symbol, xg_GtkText__symbol, xg_GtkSortListModel__symbol, xg_GtkSliceListModel__symbol, xg_GtkSingleSelection__symbol, xg_GtkPasswordEntry__symbol, xg_GtkMapListModel__symbol, xg_GtkLayoutChild__symbol, xg_GtkGridLayoutChild__symbol, xg_GtkGridLayout__symbol, xg_GtkFlattenListModel__symbol, xg_GtkFilterListModel__symbol, xg_GtkCustomAllocateFunc_symbol, xg_GtkCustomMeasureFunc_symbol, xg_GtkCustomRequestModeFunc_symbol, xg_GtkBoxLayout__symbol, xg_GtkPickFlags_symbol, xg_GtkOverflow_symbol, xg_graphene_point_t__symbol, xg_graphene_matrix_t__symbol, xg_GtkRoot__symbol, xg_GtkWidgetClass__symbol, xg_GtkLayoutManager__symbol, xg_GtkSelectionModel__symbol, xg_GtkStackPage__symbol, xg_GtkNotebookPage__symbol, xg_GskTransform__symbol, xg_GParamSpec__symbol, xg_GObjectClass__symbol, xg_float_symbol, xg_GListModel__symbol, xg_GtkAssistantPage__symbol, xg_GtkAllocation__symbol, xg_GActionGroup__symbol, xg_GtkWidgetPaintable__symbol, xg_GtkVideo__symbol, xg_GtkPicture__symbol, xg_gint64_symbol, xg_GtkMediaFile__symbol, xg_GtkMediaControls__symbol, xg_GtkMediaStream__symbol, xg_GdkTimeCoord___symbol, xg_GdkAxisUse_symbol, xg_GtkGestureStylus__symbol, xg_GtkPropagationPhase_symbol, xg_GdkPaintableFlags_symbol, xg_GdkGLTexture__symbol, xg_GdkDrag__symbol, xg_GdkDrop__symbol, xg_GdkCairoContext__symbol, xg_GdkMemoryFormat_symbol, xg_GdkSurface__symbol, xg_GMenu__symbol, xg_GtkApplicationInhibitFlags_symbol, xg_GApplicationFlags_symbol, xg_GdkDragAction_symbol, xg_GdkPaintable__symbol, xg_GtkIconSize_symbol, xg_GdkCursor__symbol, xg_GBytes__symbol, xg_GInputStream__symbol, xg_GdkContentDeserializer__symbol, xg_GdkContentSerializer__symbol, xg_GOutputStream__symbol, xg_GdkContentFormatsBuilder__symbol, xg_GString__symbol, xg_GdkTexture__symbol, xg_GAsyncResult__symbol, xg_GAsyncReadyCallback_symbol, xg_GCancellable__symbol, xg_GdkContentProvider__symbol, xg_GdkContentFormats__symbol, xg_GdkClipboard__symbol, xg_GdkAppLaunchContext__symbol, xg_GtkEventControllerScroll__symbol, xg_GtkEventControllerScrollFlags_symbol, xg_GtkEventController__symbol, xg_GFile__symbol, xg_GtkCssProvider__symbol, xg_GtkStyleContextPrintFlags_symbol, xg_GtkStyleProvider__symbol, xg_GtkScrollbar__symbol, xg_GtkCenterBox__symbol, xg_GtkCheckButton__symbol, xg_GtkDrawingAreaDrawFunc_symbol, xg_GtkShortcutLabel__symbol, xg_GtkPadActionType_symbol, xg_GtkPadActionEntry__symbol, xg_GtkPadController__symbol, xg_GdkDevicePadFeature_symbol, xg_GdkDevicePad__symbol, xg_GdkSubpixelLayout_symbol, xg_GdkMonitor__symbol, xg_GdkDeviceTool__symbol, xg_GdkAxisFlags_symbol, xg_GdkSeatCapabilities_symbol, xg_GdkSeat__symbol, xg_GtkShortcutsWindow__symbol, xg_GtkStackSidebar__symbol, xg_GtkStyleContext__symbol, xg_GdkGLContext__symbol, xg_GtkGLArea__symbol, xg_GtkPaned__symbol, xg_GtkGestureZoom__symbol, xg_GtkGestureSwipe__symbol, xg_GtkGestureSingle__symbol, xg_GtkGestureRotate__symbol, xg_GtkGesturePan__symbol, xg_GtkGestureDrag__symbol, xg_GdkEventSequence__symbol, xg_GtkEventSequenceState_symbol, xg_GtkGesture__symbol, xg_GtkActionBar__symbol, xg_GtkFlowBox__symbol, xg_GtkFlowBoxChild__symbol, xg_GdkEventType_symbol, xg_GtkSearchBar__symbol, xg_GtkListBox__symbol, xg_GtkListBoxRow__symbol, xg_GtkHeaderBar__symbol, xg_GtkRevealerTransitionType_symbol, xg_GtkRevealer__symbol, xg_GtkStackTransitionType_symbol, xg_GtkStack__symbol, xg_GtkStackSwitcher__symbol, xg_GtkBaselinePosition_symbol, xg_GtkInputHints_symbol, xg_GtkInputPurpose_symbol, xg_GtkLevelBarMode_symbol, xg_GtkLevelBar__symbol, xg_GtkMenuButton__symbol, xg_GtkColorChooser__symbol, xg_GtkApplicationWindow__symbol, xg_GtkApplication__symbol, xg_GMenuModel__symbol, xg_GtkFontChooser__symbol, xg_GtkOverlay__symbol, xg_GtkStateFlags_symbol, xg_GtkWindowGroup__symbol, xg_GIcon__symbol, xg_GtkOrientable__symbol, xg_GtkCellArea__symbol, xg_GtkBorder__symbol, xg_GtkSwitch__symbol, xg_GtkScrollablePolicy_symbol, xg_GtkScrollable__symbol, xg_GtkGrid__symbol, xg_GdkRGBA__symbol, xg_GtkComboBoxText__symbol, xg_GtkAlign_symbol, xg_GtkSizeRequestMode_symbol, xg_cairo_region_overlap_t_symbol, xg_cairo_rectangle_int_t__symbol, xg_double__symbol, xg_cairo_rectangle_t__symbol, xg_cairo_device_t__symbol, xg_cairo_bool_t_symbol, xg_cairo_text_cluster_flags_t__symbol, xg_cairo_text_cluster_t___symbol, xg_cairo_glyph_t___symbol, xg_cairo_text_cluster_flags_t_symbol, xg_cairo_text_cluster_t__symbol, xg_cairo_region_t__symbol, xg_GtkMessageDialog__symbol, xg_GtkOrientation_symbol, xg_GdkDevice__symbol, xg_GtkAccessible__symbol, xg_GtkPackType_symbol, xg_GtkSpinner__symbol, xg_GtkEntryBuffer__symbol, xg_GtkMessageType_symbol, xg_GtkInfoBar__symbol, xg_GtkEntryIconPosition_symbol, xg_GtkSensitivityType_symbol, xg_GtkScaleButton__symbol, xg_GtkTooltip__symbol, xg_cairo_rectangle_list_t__symbol, xg_void__symbol, xg_cairo_filter_t_symbol, xg_cairo_extend_t_symbol, xg_cairo_format_t_symbol, xg_cairo_path_t__symbol, xg_cairo_destroy_func_t_symbol, xg_cairo_user_data_key_t__symbol, xg_cairo_text_extents_t__symbol, xg_cairo_font_extents_t__symbol, xg_cairo_font_face_t__symbol, xg_cairo_glyph_t__symbol, xg_cairo_scaled_font_t__symbol, xg_cairo_font_weight_t_symbol, xg_cairo_font_slant_t_symbol, xg_cairo_hint_metrics_t_symbol, xg_cairo_hint_style_t_symbol, xg_cairo_subpixel_order_t_symbol, xg_cairo_status_t_symbol, xg_bool_symbol, xg_cairo_matrix_t__symbol, xg_cairo_line_join_t_symbol, xg_cairo_line_cap_t_symbol, xg_cairo_fill_rule_t_symbol, xg_cairo_antialias_t_symbol, xg_cairo_operator_t_symbol, xg_cairo_pattern_t__symbol, xg_cairo_content_t_symbol, xg_GtkPageSet_symbol, xg_GtkPageRange__symbol, xg_GtkPrintPages_symbol, xg_GtkPrintQuality_symbol, xg_GtkPrintDuplex_symbol, xg_GtkPaperSize__symbol, xg_GtkPageOrientation_symbol, xg_GtkPrintSettingsFunc_symbol, xg_GtkPageSetupDoneFunc_symbol, xg_GtkPrintStatus_symbol, xg_GtkPrintOperationAction_symbol, xg_GtkPrintOperationResult_symbol, xg_GtkUnit_symbol, xg_GtkPrintSettings__symbol, xg_GtkPrintOperation__symbol, xg_GtkPageSetup__symbol, xg_GtkPrintContext__symbol, xg_cairo_surface_t__symbol, xg_GtkTreeViewGridLines_symbol, xg_GtkRecentData__symbol, xg_time_t_symbol, xg_GtkRecentInfo__symbol, xg_GtkRecentManager__symbol, xg_GtkLinkButton__symbol, xg_GtkAssistantPageType_symbol, xg_GDestroyNotify_symbol, xg_GtkAssistantPageFunc_symbol, xg_GtkAssistant__symbol, xg_GtkIconViewDropPosition_symbol, xg_GValue__symbol, xg_GLogFunc_symbol, xg_PangoMatrix__symbol, xg_PangoRenderPart_symbol, xg_PangoRenderer__symbol, xg_GdkModifierType_symbol, xg_GtkFileChooserButton__symbol, xg_PangoScript_symbol, xg_PangoScriptIter__symbol, xg_PangoAttrFilterFunc_symbol, xg_PangoEllipsizeMode_symbol, xg_GtkIconViewForeachFunc_symbol, xg_gchar___symbol, xg_GtkAboutDialog__symbol, xg_GtkTreeViewRowSeparatorFunc_symbol, xg_GtkCellView__symbol, xg_GtkFileChooser__symbol, xg_GtkCellLayoutDataFunc_symbol, xg_GtkCellLayout__symbol, xg_GtkFileFilterFunc_symbol, xg_GtkFileFilterFlags_symbol, xg_GtkFileFilter__symbol, xg_GSourceFunc_symbol, xg_GtkEntryCompletionMatchFunc_symbol, xg_GtkFontButton__symbol, xg_GtkExpander__symbol, xg_GtkComboBox__symbol, xg_GtkTreeModelFilter__symbol, xg_GtkFileChooserAction_symbol, xg_GdkDisplay__symbol, xg_PangoLayoutRun__symbol, xg_PangoLayoutIter__symbol, xg_PangoLayoutLine__symbol, xg_int__symbol, xg_PangoAlignment_symbol, xg_PangoWrapMode_symbol, xg_PangoItem__symbol, xg_PangoAnalysis__symbol, xg_PangoGlyphString__symbol, xg_PangoFontMap__symbol, xg_PangoGlyph_symbol, xg_PangoFontFace__symbol, xg_PangoFontFace___symbol, xg_PangoFontFamily__symbol, xg_PangoFontMask_symbol, xg_PangoFontDescription___symbol, xg_PangoCoverageLevel_symbol, xg_PangoCoverage__symbol, xg_PangoDirection_symbol, xg_PangoFontMetrics__symbol, xg_PangoFontset__symbol, xg_PangoFont__symbol, xg_PangoFontFamily___symbol, xg_PangoLogAttr__symbol, xg_PangoAttrList___symbol, xg_PangoAttrIterator__symbol, xg_PangoRectangle__symbol, xg_PangoUnderline_symbol, xg_PangoStretch_symbol, xg_PangoVariant_symbol, xg_PangoWeight_symbol, xg_PangoStyle_symbol, xg_guint16_symbol, xg_PangoAttribute__symbol, xg_PangoAttrType_symbol, xg_PangoColor__symbol, xg_GtkWindow__symbol, xg_GtkTextDirection_symbol, xg_PangoContext__symbol, xg_AtkObject__symbol, xg_GtkDirectionType_symbol, xg_GtkTreeViewSearchEqualFunc_symbol, xg_GtkTreeViewDropPosition_symbol, xg_GtkTreeViewMappingFunc_symbol, xg_GtkTreeViewColumnDropFunc_symbol, xg_GList__symbol, xg_GtkTreeViewColumnSizing_symbol, xg_GtkTreeCellDataFunc_symbol, xg_GtkTreeStore__symbol, xg_GtkTreeIterCompareFunc_symbol, xg_GtkSortType_symbol, xg_GtkTreeSortable__symbol, xg_GtkTreeSelectionForeachFunc_symbol, xg_GtkTreeModel___symbol, xg_GtkTreeSelectionFunc_symbol, xg_GtkSelectionMode_symbol, xg_GtkTreeModelSort__symbol, xg_GtkTreeModelForeachFunc_symbol, xg_GtkTreeModelFlags_symbol, xg_GObject__symbol, xg_GtkTreeRowReference__symbol, xg_gint__symbol, xg_GtkTreeDragSource__symbol, xg_GtkToggleButton__symbol, xg_PangoTabArray__symbol, xg_GtkWrapMode_symbol, xg_GtkTextWindowType_symbol, xg_GtkTextView__symbol, xg_GtkTextTagTableForeach_symbol, xg_GtkTextSearchFlags_symbol, xg_GtkTextCharPredicate_symbol, xg_GtkTextMark__symbol, xg_GtkTextChildAnchor__symbol, xg_GtkTextIter__symbol, xg_GtkTextTagTable__symbol, xg_GtkTextBuffer__symbol, xg_GtkStatusbar__symbol, xg_GtkSpinType_symbol, xg_GtkSpinButtonUpdatePolicy_symbol, xg_GtkSpinButton__symbol, xg_GtkSizeGroupMode_symbol, xg_GtkSizeGroup__symbol, xg_GtkSettings__symbol, xg_GtkCornerType_symbol, xg_GtkPolicyType_symbol, xg_GtkScrolledWindow__symbol, xg_GtkScale__symbol, xg_GtkRange__symbol, xg_GtkRadioButton__symbol, xg_GSList__symbol, xg_GtkProgressBar__symbol, xg_GtkPositionType_symbol, xg_GtkNotebook__symbol, xg_PangoLanguage__symbol, xg_GtkListStore__symbol, xg_PangoLayout__symbol, xg_GtkJustification_symbol, xg_GtkLabel__symbol, xg_guint16__symbol, xg_GtkIMContextSimple__symbol, xg_PangoAttrList__symbol, xg_GtkIMContext__symbol, xg_GtkImageType_symbol, xg_GtkImage__symbol, xg_GtkFrame__symbol, xg_GtkFixed__symbol, xg_GtkEntry__symbol, xg_GtkEditable__symbol, xg_etc_symbol, xg_GtkDialog__symbol, xg_GtkCellRendererToggle__symbol, xg_GtkCellRendererText__symbol, xg_GtkCellRendererState_symbol, xg_GtkCellEditable__symbol, xg_GtkCalendar__symbol, xg_GtkButton__symbol, xg_GtkBox__symbol, xg_gdouble_symbol, xg_GtkAdjustment__symbol, xg_GtkAccelLabel__symbol, xg_GdkInterpType_symbol, xg_double_symbol, xg_gfloat_symbol, xg_guchar_symbol, xg_char___symbol, xg_GdkPixbufDestroyNotify_symbol, xg_GError__symbol, xg_char__symbol, xg_guchar__symbol, xg_GdkPixbuf__symbol, xg_GdkColorspace_symbol, xg_GdkRectangle__symbol, xg_guint32_symbol, xg_GSignalMatchType_symbol, xg_GConnectFlags_symbol, xg_GtkDestroyNotify_symbol, xg_GSignalEmissionHook_symbol, xg_gulong_symbol, xg_GSignalInvocationHint__symbol, xg_GQuark_symbol, xg_guint__symbol, xg_GSignalQuery__symbol, xg_GType__symbol, xg_GSignalCMarshaller_symbol, xg_gpointer_symbol, xg_GSignalAccumulator_symbol, xg_GSignalFlags_symbol, xg_GType_symbol, xg_guint_symbol, xg_GClosureNotify_symbol, xg_GCallback_symbol, xg_GClosure__symbol, xg_GNormalizeMode_symbol, xg_glong_symbol, xg_gssize_symbol, xg_gsize_symbol, xg_gunichar__symbol, xg_void_symbol, xg_int_symbol, xg_GtkDrawingArea__symbol, xg_GLogLevelFlags_symbol, xg_GtkIconView__symbol, xg_GtkEntryCompletion__symbol, xg_GtkFileFilterInfo__symbol, xg_gboolean_symbol, xg_GtkTreeSelection__symbol, xg_GtkCellRenderer__symbol, xg_gchar__symbol, xg_gint_symbol, xg_GtkTreeViewColumn__symbol, xg_GtkTreeView__symbol, xg_gunichar_symbol, xg_GtkTreeIter__symbol, xg_GtkTreePath__symbol, xg_GtkTreeModel__symbol, xg_GtkTextTag__symbol, xg_lambda_data_symbol, xg_GtkWidget__symbol, xg_GdkEventMotion__symbol, xg_gdouble__symbol, xg_GdkEvent__symbol, xg_cairo_t__symbol, xg_cairo_font_options_t__symbol, xg_PangoFontDescription__symbol, xg_GtkMenuBar__symbol, xg_GtkEventControllerLegacy__symbol, xg_GtkCellRendererPixbuf__symbol, xg_GtkSeparator__symbol, xg_GdkEventExpose__symbol, xg_GdkEventNoExpose__symbol, xg_GdkEventVisibility__symbol, xg_GdkEventButton__symbol, xg_GdkEventCrossing__symbol, xg_GdkEventFocus__symbol, xg_GdkEventConfigure__symbol, xg_GdkEventProperty__symbol, xg_GdkEventSelection__symbol, xg_GdkEventProximity__symbol, xg_GdkEventSetting__symbol, xg_GdkEventWindowState__symbol, xg_GdkEventDND__symbol, xg_GtkFileChooserDialog__symbol, xg_GtkFileChooserWidget__symbol, xg_GtkCellRendererCombo__symbol, xg_GtkCellRendererProgress__symbol, xg_GtkCellRendererAccel__symbol, xg_GtkCellRendererSpin__symbol, xg_GtkCellRendererSpinner__symbol, xg_GtkFontChooserDialog__symbol, xg_GtkFontChooserWidget__symbol, xg_GtkColorChooserDialog__symbol, xg_GtkColorWidget__symbol, xg_idler_symbol;

#define wrap_for_Xen(Name, Value) Xen_list_2(xg_ ## Name ## _symbol, Xen_wrap_C_pointer(Value))
#define is_wrapped(Name, Value) (Xen_is_pair(Value) && (Xen_car(Value) == xg_ ## Name ## _symbol))

#define Xm_type(Name, XType) \
  static Xen C_to_Xen_ ## Name (XType val) {return(Xen_list_2(xg_ ## Name ## _symbol, C_ulong_to_Xen_ulong(val)));} \
  static XType Xen_to_C_ ## Name (Xen val) {return((XType)Xen_ulong_to_C_ulong(Xen_cadr(val)));} \
  static bool Xen_is_ ## Name (Xen val) {return(is_wrapped(Name, val));}

#define Xm_type_1(Name, XType) \
  static XType Xen_to_C_ ## Name (Xen val) {return((XType)Xen_ulong_to_C_ulong(Xen_cadr(val)));} \
  static bool Xen_is_ ## Name (Xen val) {return(is_wrapped(Name, val));}

#define Xm_type_no_p_2(Name, XType) \
  static Xen C_to_Xen_ ## Name (XType val) {return(wrap_for_Xen(Name, val));}

#define Xm_type_Ptr(Name, XType) \
  static Xen C_to_Xen_ ## Name (XType val) {if (val) return(wrap_for_Xen(Name, val)); return(Xen_false);} \
  static XType Xen_to_C_ ## Name (Xen val) {if (Xen_is_false(val)) return(NULL); return((XType)Xen_unwrap_C_pointer(Xen_cadr(val)));} \
  static bool Xen_is_ ## Name (Xen val) {return(is_wrapped(Name, val));}

#define Xm_type_Ptr_1(Name, XType) \
  static XType Xen_to_C_ ## Name (Xen val) {if (Xen_is_false(val)) return(NULL); return((XType)Xen_unwrap_C_pointer(Xen_cadr(val)));} \
  static bool Xen_is_ ## Name (Xen val) {return(is_wrapped(Name, val));}

#define Xm_type_Ptr_2(Name, XType) \
  static Xen C_to_Xen_ ## Name (XType val) {if (val) return(wrap_for_Xen(Name, val)); return(Xen_false);} \

/* type checks for callback wrappers */
#define Xen_is_GtkCallback(Arg)  Xen_is_false(Arg) || (Xen_is_procedure(Arg) && (Xen_is_aritable(Arg, 2)))
#define Xen_is_GSourceFunc(Arg)  Xen_is_false(Arg) || (Xen_is_procedure(Arg) && (Xen_is_aritable(Arg, 1)))
#define Xen_is_GtkDestroyNotify(Arg)  Xen_is_false(Arg) || (Xen_is_procedure(Arg) && (Xen_is_aritable(Arg, 1)))
#define Xen_is_GtkTextTagTableForeach(Arg)  Xen_is_false(Arg) || (Xen_is_procedure(Arg) && (Xen_is_aritable(Arg, 2)))
#define Xen_is_GtkTreeModelForeachFunc(Arg)  Xen_is_false(Arg) || (Xen_is_procedure(Arg) && (Xen_is_aritable(Arg, 4)))
#define Xen_is_GtkTreeSelectionForeachFunc(Arg)  Xen_is_false(Arg) || (Xen_is_procedure(Arg) && (Xen_is_aritable(Arg, 4)))
#define Xen_is_GtkTextCharPredicate(Arg)  Xen_is_false(Arg) || (Xen_is_procedure(Arg) && (Xen_is_aritable(Arg, 2)))
#define Xen_is_GtkTreeViewColumnDropFunc(Arg)  Xen_is_false(Arg) || (Xen_is_procedure(Arg) && (Xen_is_aritable(Arg, 5)))
#define Xen_is_GtkTreeViewMappingFunc(Arg)  Xen_is_false(Arg) || (Xen_is_procedure(Arg) && (Xen_is_aritable(Arg, 3)))
#define Xen_is_GtkTreeViewSearchEqualFunc(Arg)  Xen_is_false(Arg) || (Xen_is_procedure(Arg) && (Xen_is_aritable(Arg, 5)))
#define Xen_is_GtkTreeCellDataFunc(Arg)  Xen_is_false(Arg) || (Xen_is_procedure(Arg) && (Xen_is_aritable(Arg, 5)))
#define Xen_is_GtkTreeIterCompareFunc(Arg)  Xen_is_false(Arg) || (Xen_is_procedure(Arg) && (Xen_is_aritable(Arg, 4)))
#define Xen_is_GtkTreeSelectionFunc(Arg)  Xen_is_false(Arg) || (Xen_is_procedure(Arg) && (Xen_is_aritable(Arg, 5)))
#define Xen_is_GtkFileFilterFunc(Arg)  Xen_is_false(Arg) || (Xen_is_procedure(Arg) && (Xen_is_aritable(Arg, 2)))
#define Xen_is_GtkEntryCompletionMatchFunc(Arg)  Xen_is_false(Arg) || (Xen_is_procedure(Arg) && (Xen_is_aritable(Arg, 4)))
#define Xen_is_GtkTreeViewRowSeparatorFunc(Arg)  Xen_is_false(Arg) || (Xen_is_procedure(Arg) && (Xen_is_aritable(Arg, 3)))
#define Xen_is_GtkIconViewForeachFunc(Arg)  Xen_is_false(Arg) || (Xen_is_procedure(Arg) && (Xen_is_aritable(Arg, 3)))
#define Xen_is_GLogFunc(Arg)  Xen_is_false(Arg) || (Xen_is_procedure(Arg) && (Xen_is_aritable(Arg, 4)))
#define Xen_is_GtkAssistantPageFunc(Arg)  Xen_is_false(Arg) || (Xen_is_procedure(Arg) && (Xen_is_aritable(Arg, 2)))
#define Xen_is_GDestroyNotify(Arg)  Xen_is_false(Arg) || (Xen_is_procedure(Arg) && (Xen_is_aritable(Arg, 1)))
#define Xen_is_GtkDrawingAreaDrawFunc(Arg)  Xen_is_false(Arg) || (Xen_is_procedure(Arg) && (Xen_is_aritable(Arg, 5)))
#define Xen_is_GCallback(Arg) (Xen_is_procedure(Arg) && ((Xen_is_aritable(Arg, 2)) || (Xen_is_aritable(Arg, 3)) || (Xen_is_aritable(Arg, 4))))
#define Xen_to_C_GtkCallback(Arg) Xen_is_false(Arg) ? NULL : gxg_func2
#define Xen_to_C_GSourceFunc(Arg) Xen_is_false(Arg) ? NULL : gxg_timer_func
#define Xen_to_C_GtkDestroyNotify(Arg) Xen_is_false(Arg) ? NULL : gxg_destroy_func
#define Xen_to_C_GtkTextTagTableForeach(Arg) Xen_is_false(Arg) ? NULL : gxg_text_tag_table_foreach
#define Xen_to_C_GtkTreeModelForeachFunc(Arg) Xen_is_false(Arg) ? NULL : gxg_model_func
#define Xen_to_C_GtkTreeSelectionForeachFunc(Arg) Xen_is_false(Arg) ? NULL : gxg_tree_selection_func
#define Xen_to_C_GtkTextCharPredicate(Arg) Xen_is_false(Arg) ? NULL : gxg_text_char_predicate
#define Xen_to_C_GtkTreeViewColumnDropFunc(Arg) Xen_is_false(Arg) ? NULL : gxg_tree_column
#define Xen_to_C_GtkTreeViewMappingFunc(Arg) Xen_is_false(Arg) ? NULL : gxg_tree_mapping
#define Xen_to_C_GtkTreeViewSearchEqualFunc(Arg) Xen_is_false(Arg) ? NULL : gxg_tree_search
#define Xen_to_C_GtkTreeCellDataFunc(Arg) Xen_is_false(Arg) ? NULL : gxg_cell_data
#define Xen_to_C_GtkTreeIterCompareFunc(Arg) Xen_is_false(Arg) ? NULL : gxg_iter_compare
#define Xen_to_C_GtkTreeSelectionFunc(Arg) Xen_is_false(Arg) ? NULL : gxg_tree_selection
#define Xen_to_C_GtkFileFilterFunc(Arg) Xen_is_false(Arg) ? NULL : gxg_file_filter
#define Xen_to_C_GtkEntryCompletionMatchFunc(Arg) Xen_is_false(Arg) ? NULL : gxg_entry_completion_match
#define Xen_to_C_GtkTreeViewRowSeparatorFunc(Arg) Xen_is_false(Arg) ? NULL : gxg_row_separator
#define Xen_to_C_GtkIconViewForeachFunc(Arg) Xen_is_false(Arg) ? NULL : gxg_icon_view_foreach
#define Xen_to_C_GLogFunc(Arg) Xen_is_false(Arg) ? NULL : gxg_g_message_log_func
#define Xen_to_C_GtkAssistantPageFunc(Arg) Xen_is_false(Arg) ? NULL : gxg_page_func
#define Xen_to_C_GDestroyNotify(Arg) Xen_is_false(Arg) ? NULL : gxg_destroy_func
#define Xen_to_C_GtkDrawingAreaDrawFunc(Arg) Xen_is_false(Arg) ? NULL : gxg_draw_func
#define Xen_to_C_GCallback(Arg) ((Xen_is_aritable(Arg, 4)) ? (GCallback)gxg_func4 : ((Xen_is_aritable(Arg, 3)) ? (GCallback)gxg_func3 : (GCallback)gxg_func2))
#define Xen_to_C_lambda_data(Arg) (gpointer)gxg_ptr
#define Xen_is_lambda_data(Arg) 1
#define C_to_Xen_GtkTreeViewSearchEqualFunc(Arg) wrap_for_Xen(GtkTreeViewSearchEqualFunc, Arg)
#define C_to_Xen_String(Arg) C_string_to_Xen_string((char *)Arg)
static Xen C_to_Xen_GError_(GError *err)
{
  if (err)
    {
      Xen msg;
      msg = C_string_to_Xen_string(err->message);
      g_error_free(err);
      return(msg);
    }
  return(Xen_false);
}


/* ---------------------------------------- types ---------------------------------------- */

Xm_type_Ptr(PangoFontDescription_, PangoFontDescription*)
Xm_type_Ptr(cairo_font_options_t_, cairo_font_options_t*)
Xm_type_Ptr(cairo_t_, cairo_t*)
Xm_type_Ptr(GdkEvent_, GdkEvent*)
Xm_type_Ptr_1(gdouble_, gdouble*)
Xm_type_Ptr(GtkWidget_, GtkWidget*)
Xm_type_Ptr(GtkTextTag_, GtkTextTag*)
Xm_type_Ptr(GtkTreeModel_, GtkTreeModel*)
Xm_type_Ptr(GtkTreePath_, GtkTreePath*)
Xm_type_Ptr(GtkTreeIter_, GtkTreeIter*)
#define C_to_Xen_gunichar(Arg) C_ulong_to_Xen_ulong(Arg)
#define Xen_to_C_gunichar(Arg) (gunichar)(Xen_ulong_to_C_ulong(Arg))
#define Xen_is_gunichar(Arg) Xen_is_ulong(Arg)
Xm_type_Ptr(GtkTreeView_, GtkTreeView*)
Xm_type_Ptr(GtkTreeViewColumn_, GtkTreeViewColumn*)
#define C_to_Xen_gint(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_gint(Arg) (gint)(Xen_integer_to_C_int(Arg))
#define Xen_is_gint(Arg) Xen_is_integer(Arg)
#define C_to_Xen_gchar_(Arg) C_string_to_Xen_string(Arg)
#define Xen_to_C_gchar_(Arg) (gchar*)(Xen_string_to_C_string(Arg))
#define Xen_is_gchar_(Arg) Xen_is_string(Arg)
Xm_type_Ptr(GtkCellRenderer_, GtkCellRenderer*)
Xm_type_Ptr(GtkTreeSelection_, GtkTreeSelection*)
#define C_to_Xen_gboolean(Arg) C_bool_to_Xen_boolean(Arg)
#define Xen_to_C_gboolean(Arg) (gboolean)(Xen_boolean_to_C_bool(Arg))
#define Xen_is_gboolean(Arg) Xen_is_boolean(Arg)
Xm_type_Ptr(GtkFileFilterInfo_, GtkFileFilterInfo*)
Xm_type_Ptr(GtkEntryCompletion_, GtkEntryCompletion*)
Xm_type_Ptr(GtkIconView_, GtkIconView*)
#define C_to_Xen_GLogLevelFlags(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GLogLevelFlags(Arg) (GLogLevelFlags)(Xen_integer_to_C_int(Arg))
#define Xen_is_GLogLevelFlags(Arg) Xen_is_integer(Arg)
#define Xen_to_C_gunichar_(Arg) (gunichar*)(Xen_string_to_C_string(Arg))
#define Xen_is_gunichar_(Arg) Xen_is_string(Arg)
#define C_to_Xen_gsize(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_gsize(Arg) (gsize)(Xen_integer_to_C_int(Arg))
#define Xen_is_gsize(Arg) Xen_is_integer(Arg)
#define Xen_to_C_gssize(Arg) (gssize)(Xen_integer_to_C_int(Arg))
#define Xen_is_gssize(Arg) Xen_is_integer(Arg)
#define C_to_Xen_glong(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GNormalizeMode(Arg) (GNormalizeMode)(Xen_integer_to_C_int(Arg))
#define Xen_is_GNormalizeMode(Arg) Xen_is_integer(Arg)
Xm_type_Ptr(GClosure_, GClosure*)
Xm_type_Ptr_1(GClosureNotify, GClosureNotify)
#define C_to_Xen_guint(Arg) C_ulong_to_Xen_ulong(Arg)
#define Xen_to_C_guint(Arg) (guint)(Xen_ulong_to_C_ulong(Arg))
#define Xen_is_guint(Arg) Xen_is_ulong(Arg)
#define C_to_Xen_GType(Arg) C_ulong_to_Xen_ulong(Arg)
#define Xen_to_C_GType(Arg) (GType)(Xen_ulong_to_C_ulong(Arg))
#define Xen_is_GType(Arg) Xen_is_ulong(Arg)
#define Xen_to_C_GSignalFlags(Arg) (GSignalFlags)(Xen_integer_to_C_int(Arg))
#define Xen_is_GSignalFlags(Arg) Xen_is_integer(Arg)
Xm_type_1(GSignalAccumulator, GSignalAccumulator)
Xm_type_Ptr(gpointer, gpointer)
Xm_type_1(GSignalCMarshaller, GSignalCMarshaller)
Xm_type_Ptr_1(GType_, GType*)
Xm_type_Ptr_1(GSignalQuery_, GSignalQuery*)
Xm_type_Ptr(guint_, guint*)
#define C_to_Xen_GQuark(Arg) C_ulong_to_Xen_ulong(Arg)
#define Xen_to_C_GQuark(Arg) (GQuark)(Xen_ulong_to_C_ulong(Arg))
#define Xen_is_GQuark(Arg) Xen_is_ulong(Arg)
Xm_type_Ptr_2(GSignalInvocationHint_, GSignalInvocationHint*)
#define C_to_Xen_gulong(Arg) C_ulong_to_Xen_ulong(Arg)
#define Xen_to_C_gulong(Arg) (gulong)(Xen_ulong_to_C_ulong(Arg))
#define Xen_is_gulong(Arg) Xen_is_ulong(Arg)
Xm_type_1(GSignalEmissionHook, GSignalEmissionHook)
#define Xen_to_C_GConnectFlags(Arg) (GConnectFlags)(Xen_integer_to_C_int(Arg))
#define Xen_is_GConnectFlags(Arg) Xen_is_integer(Arg)
#define Xen_to_C_GSignalMatchType(Arg) (GSignalMatchType)(Xen_integer_to_C_int(Arg))
#define Xen_is_GSignalMatchType(Arg) Xen_is_integer(Arg)
#define C_to_Xen_guint32(Arg) C_ulong_to_Xen_ulong(Arg)
#define Xen_to_C_guint32(Arg) (guint32)(Xen_ulong_to_C_ulong(Arg))
#define Xen_is_guint32(Arg) Xen_is_ulong(Arg)
Xm_type_Ptr_1(GdkRectangle_, GdkRectangle*)
#define C_to_Xen_GdkColorspace(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GdkColorspace(Arg) (GdkColorspace)(Xen_integer_to_C_int(Arg))
#define Xen_is_GdkColorspace(Arg) Xen_is_integer(Arg)
Xm_type_Ptr(GdkPixbuf_, GdkPixbuf*)
#define C_to_Xen_int(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_int(Arg) (int)(Xen_integer_to_C_int(Arg))
#define Xen_is_int(Arg) Xen_is_integer(Arg)
#define C_to_Xen_guchar_(Arg) C_to_Xen_String(Arg)
#define Xen_to_C_guchar_(Arg) (guchar*)(Xen_string_to_C_string(Arg))
#define Xen_is_guchar_(Arg) Xen_is_string(Arg)
#define C_to_Xen_char_(Arg) C_string_to_Xen_string(Arg)
#define Xen_to_C_char_(Arg) (char*)(Xen_string_to_C_string(Arg))
#define Xen_is_char_(Arg) Xen_is_string(Arg)
Xm_type_1(GdkPixbufDestroyNotify, GdkPixbufDestroyNotify)
Xm_type_Ptr(char__, char**)
#define C_to_Xen_guchar(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_guchar(Arg) (guchar)(Xen_integer_to_C_int(Arg))
#define Xen_is_guchar(Arg) Xen_is_integer(Arg)
#define C_to_Xen_gfloat(Arg) C_double_to_Xen_real(Arg)
#define Xen_to_C_gfloat(Arg) (gfloat)(Xen_real_to_C_double(Arg))
#define Xen_is_gfloat(Arg) Xen_is_number(Arg)
#define C_to_Xen_double(Arg) C_double_to_Xen_real(Arg)
#define Xen_to_C_double(Arg) (double)(Xen_real_to_C_double(Arg))
#define Xen_to_C_GdkInterpType(Arg) (GdkInterpType)(Xen_integer_to_C_int(Arg))
#define Xen_is_GdkInterpType(Arg) Xen_is_integer(Arg)
Xm_type_Ptr_1(GtkAccelLabel_, GtkAccelLabel*)
Xm_type_Ptr(GtkAdjustment_, GtkAdjustment*)
#define C_to_Xen_gdouble(Arg) C_double_to_Xen_real(Arg)
#define Xen_to_C_gdouble(Arg) (gdouble)(Xen_real_to_C_double(Arg))
#define Xen_is_gdouble(Arg) Xen_is_number(Arg)
Xm_type_Ptr_1(GtkBox_, GtkBox*)
Xm_type_Ptr_1(GtkButton_, GtkButton*)
Xm_type_Ptr_1(GtkCalendar_, GtkCalendar*)
Xm_type_Ptr(GtkCellEditable_, GtkCellEditable*)
#define Xen_to_C_GtkCellRendererState(Arg) (GtkCellRendererState)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkCellRendererState(Arg) Xen_is_integer(Arg)
Xm_type_Ptr_1(GtkCellRendererText_, GtkCellRendererText*)
Xm_type_Ptr_1(GtkCellRendererToggle_, GtkCellRendererToggle*)
Xm_type_Ptr_1(GtkDialog_, GtkDialog*)
#define Xen_is_etc(Arg) (Xen_is_list(Arg))
Xm_type_Ptr_1(GtkEditable_, GtkEditable*)
Xm_type_Ptr_1(GtkEntry_, GtkEntry*)
Xm_type_Ptr_1(GtkFixed_, GtkFixed*)
Xm_type_Ptr_1(GtkFrame_, GtkFrame*)
Xm_type_Ptr_1(GtkImage_, GtkImage*)
#define C_to_Xen_GtkImageType(Arg) C_int_to_Xen_integer(Arg)
Xm_type_Ptr(GtkIMContext_, GtkIMContext*)
Xm_type_Ptr(PangoAttrList_, PangoAttrList*)
Xm_type_Ptr_1(GtkIMContextSimple_, GtkIMContextSimple*)
Xm_type_Ptr_1(guint16_, guint16*)
Xm_type_Ptr_1(GtkLabel_, GtkLabel*)
#define C_to_Xen_GtkJustification(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkJustification(Arg) (GtkJustification)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkJustification(Arg) Xen_is_integer(Arg)
Xm_type_Ptr(PangoLayout_, PangoLayout*)
Xm_type_Ptr(GtkListStore_, GtkListStore*)
Xm_type_Ptr(PangoLanguage_, PangoLanguage*)
Xm_type_Ptr_1(GtkNotebook_, GtkNotebook*)
#define C_to_Xen_GtkPositionType(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkPositionType(Arg) (GtkPositionType)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkPositionType(Arg) Xen_is_integer(Arg)
Xm_type_Ptr_1(GtkProgressBar_, GtkProgressBar*)
Xm_type_Ptr(GSList_, GSList*)
Xm_type_Ptr_1(GtkRadioButton_, GtkRadioButton*)
Xm_type_Ptr_1(GtkRange_, GtkRange*)
Xm_type_Ptr_1(GtkScale_, GtkScale*)
Xm_type_Ptr_1(GtkScrolledWindow_, GtkScrolledWindow*)
#define C_to_Xen_GtkPolicyType(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkPolicyType(Arg) (GtkPolicyType)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkPolicyType(Arg) Xen_is_integer(Arg)
#define C_to_Xen_GtkCornerType(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkCornerType(Arg) (GtkCornerType)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkCornerType(Arg) Xen_is_integer(Arg)
Xm_type_Ptr(GtkSettings_, GtkSettings*)
Xm_type_Ptr(GtkSizeGroup_, GtkSizeGroup*)
#define C_to_Xen_GtkSizeGroupMode(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkSizeGroupMode(Arg) (GtkSizeGroupMode)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkSizeGroupMode(Arg) Xen_is_integer(Arg)
Xm_type_Ptr_1(GtkSpinButton_, GtkSpinButton*)
#define C_to_Xen_GtkSpinButtonUpdatePolicy(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkSpinButtonUpdatePolicy(Arg) (GtkSpinButtonUpdatePolicy)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkSpinButtonUpdatePolicy(Arg) Xen_is_integer(Arg)
#define Xen_to_C_GtkSpinType(Arg) (GtkSpinType)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkSpinType(Arg) Xen_is_integer(Arg)
Xm_type_Ptr_1(GtkStatusbar_, GtkStatusbar*)
Xm_type_Ptr(GtkTextBuffer_, GtkTextBuffer*)
Xm_type_Ptr(GtkTextTagTable_, GtkTextTagTable*)
Xm_type_Ptr(GtkTextIter_, GtkTextIter*)
Xm_type_Ptr(GtkTextChildAnchor_, GtkTextChildAnchor*)
Xm_type_Ptr(GtkTextMark_, GtkTextMark*)
#define Xen_to_C_GtkTextSearchFlags(Arg) (GtkTextSearchFlags)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkTextSearchFlags(Arg) Xen_is_integer(Arg)
Xm_type_Ptr_1(GtkTextView_, GtkTextView*)
#define Xen_to_C_GtkTextWindowType(Arg) (GtkTextWindowType)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkTextWindowType(Arg) Xen_is_integer(Arg)
#define C_to_Xen_GtkWrapMode(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkWrapMode(Arg) (GtkWrapMode)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkWrapMode(Arg) Xen_is_integer(Arg)
Xm_type_Ptr(PangoTabArray_, PangoTabArray*)
Xm_type_Ptr_1(GtkToggleButton_, GtkToggleButton*)
Xm_type_Ptr_1(GtkTreeDragSource_, GtkTreeDragSource*)
Xm_type_Ptr(gint_, gint*)
Xm_type_Ptr(GtkTreeRowReference_, GtkTreeRowReference*)
Xm_type_Ptr_1(GObject_, GObject*)
#define C_to_Xen_GtkTreeModelFlags(Arg) C_int_to_Xen_integer(Arg)
Xm_type_Ptr_1(GtkTreeModelSort_, GtkTreeModelSort*)
#define C_to_Xen_GtkSelectionMode(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkSelectionMode(Arg) (GtkSelectionMode)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkSelectionMode(Arg) Xen_is_integer(Arg)
Xm_type_Ptr_1(GtkTreeModel__, GtkTreeModel**)
Xm_type_Ptr_1(GtkTreeSortable_, GtkTreeSortable*)
#define C_to_Xen_GtkSortType(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkSortType(Arg) (GtkSortType)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkSortType(Arg) Xen_is_integer(Arg)
Xm_type_Ptr(GtkTreeStore_, GtkTreeStore*)
#define C_to_Xen_GtkTreeViewColumnSizing(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkTreeViewColumnSizing(Arg) (GtkTreeViewColumnSizing)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkTreeViewColumnSizing(Arg) Xen_is_integer(Arg)
Xm_type_Ptr(GList_, GList*)
#define C_to_Xen_GtkTreeViewDropPosition(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkDirectionType(Arg) (GtkDirectionType)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkDirectionType(Arg) Xen_is_integer(Arg)
Xm_type_Ptr_2(AtkObject_, AtkObject*)
Xm_type_Ptr(PangoContext_, PangoContext*)
#define C_to_Xen_GtkTextDirection(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkTextDirection(Arg) (GtkTextDirection)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkTextDirection(Arg) Xen_is_integer(Arg)
Xm_type_Ptr(GtkWindow_, GtkWindow*)
Xm_type_Ptr(PangoColor_, PangoColor*)
#define C_to_Xen_PangoAttrType(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_PangoAttrType(Arg) (PangoAttrType)(Xen_integer_to_C_int(Arg))
#define Xen_is_PangoAttrType(Arg) Xen_is_integer(Arg)
Xm_type_Ptr(PangoAttribute_, PangoAttribute*)
#define C_to_Xen_guint16(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_guint16(Arg) (guint16)(Xen_integer_to_C_int(Arg))
#define Xen_is_guint16(Arg) Xen_is_integer(Arg)
#define C_to_Xen_PangoStyle(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_PangoStyle(Arg) (PangoStyle)(Xen_integer_to_C_int(Arg))
#define Xen_is_PangoStyle(Arg) Xen_is_integer(Arg)
#define C_to_Xen_PangoWeight(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_PangoWeight(Arg) (PangoWeight)(Xen_integer_to_C_int(Arg))
#define Xen_is_PangoWeight(Arg) Xen_is_integer(Arg)
#define C_to_Xen_PangoVariant(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_PangoVariant(Arg) (PangoVariant)(Xen_integer_to_C_int(Arg))
#define Xen_is_PangoVariant(Arg) Xen_is_integer(Arg)
#define C_to_Xen_PangoStretch(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_PangoStretch(Arg) (PangoStretch)(Xen_integer_to_C_int(Arg))
#define Xen_is_PangoStretch(Arg) Xen_is_integer(Arg)
#define Xen_to_C_PangoUnderline(Arg) (PangoUnderline)(Xen_integer_to_C_int(Arg))
#define Xen_is_PangoUnderline(Arg) Xen_is_integer(Arg)
Xm_type_Ptr_1(PangoRectangle_, PangoRectangle*)
Xm_type_Ptr(PangoAttrIterator_, PangoAttrIterator*)
Xm_type_Ptr_1(PangoAttrList__, PangoAttrList**)
Xm_type_Ptr(PangoLogAttr_, PangoLogAttr*)
Xm_type_Ptr_2(PangoFontFamily__, PangoFontFamily**)
Xm_type_Ptr(PangoFont_, PangoFont*)
Xm_type_Ptr_2(PangoFontset_, PangoFontset*)
Xm_type_Ptr(PangoFontMetrics_, PangoFontMetrics*)
#define C_to_Xen_PangoDirection(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_PangoDirection(Arg) (PangoDirection)(Xen_integer_to_C_int(Arg))
#define Xen_is_PangoDirection(Arg) Xen_is_integer(Arg)
Xm_type_Ptr(PangoCoverage_, PangoCoverage*)
#define C_to_Xen_PangoCoverageLevel(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_PangoCoverageLevel(Arg) (PangoCoverageLevel)(Xen_integer_to_C_int(Arg))
#define Xen_is_PangoCoverageLevel(Arg) Xen_is_integer(Arg)
Xm_type_Ptr_1(PangoFontDescription__, PangoFontDescription**)
#define C_to_Xen_PangoFontMask(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_PangoFontMask(Arg) (PangoFontMask)(Xen_integer_to_C_int(Arg))
#define Xen_is_PangoFontMask(Arg) Xen_is_integer(Arg)
Xm_type_Ptr(PangoFontFamily_, PangoFontFamily*)
Xm_type_Ptr_2(PangoFontFace__, PangoFontFace**)
Xm_type_Ptr(PangoFontFace_, PangoFontFace*)
#define Xen_to_C_PangoGlyph(Arg) (PangoGlyph)(Xen_ulong_to_C_ulong(Arg))
#define Xen_is_PangoGlyph(Arg) Xen_is_ulong(Arg)
Xm_type_Ptr(PangoFontMap_, PangoFontMap*)
Xm_type_Ptr(PangoGlyphString_, PangoGlyphString*)
Xm_type_Ptr_1(PangoAnalysis_, PangoAnalysis*)
Xm_type_Ptr(PangoItem_, PangoItem*)
#define C_to_Xen_PangoWrapMode(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_PangoWrapMode(Arg) (PangoWrapMode)(Xen_integer_to_C_int(Arg))
#define Xen_is_PangoWrapMode(Arg) Xen_is_integer(Arg)
#define C_to_Xen_PangoAlignment(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_PangoAlignment(Arg) (PangoAlignment)(Xen_integer_to_C_int(Arg))
#define Xen_is_PangoAlignment(Arg) Xen_is_integer(Arg)
Xm_type_Ptr(int_, int*)
Xm_type_Ptr(PangoLayoutLine_, PangoLayoutLine*)
Xm_type_Ptr(PangoLayoutIter_, PangoLayoutIter*)
Xm_type_Ptr_2(PangoLayoutRun_, PangoLayoutRun*)
Xm_type_Ptr(GdkDisplay_, GdkDisplay*)
#define C_to_Xen_GtkFileChooserAction(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkFileChooserAction(Arg) (GtkFileChooserAction)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkFileChooserAction(Arg) Xen_is_integer(Arg)
Xm_type_Ptr_1(GtkTreeModelFilter_, GtkTreeModelFilter*)
Xm_type_Ptr_1(GtkComboBox_, GtkComboBox*)
Xm_type_Ptr_1(GtkExpander_, GtkExpander*)
Xm_type_Ptr_1(GtkFontButton_, GtkFontButton*)
Xm_type_Ptr(GtkFileFilter_, GtkFileFilter*)
#define C_to_Xen_GtkFileFilterFlags(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkFileFilterFlags(Arg) (GtkFileFilterFlags)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkFileFilterFlags(Arg) Xen_is_integer(Arg)
Xm_type_Ptr_1(GtkCellLayout_, GtkCellLayout*)
Xm_type_1(GtkCellLayoutDataFunc, GtkCellLayoutDataFunc)
Xm_type_Ptr_1(GtkFileChooser_, GtkFileChooser*)
Xm_type_Ptr_1(GtkCellView_, GtkCellView*)
Xm_type_Ptr_1(GtkAboutDialog_, GtkAboutDialog*)
Xm_type_Ptr(gchar__, gchar**)
#define C_to_Xen_PangoEllipsizeMode(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_PangoEllipsizeMode(Arg) (PangoEllipsizeMode)(Xen_integer_to_C_int(Arg))
#define Xen_is_PangoEllipsizeMode(Arg) Xen_is_integer(Arg)
Xm_type_1(PangoAttrFilterFunc, PangoAttrFilterFunc)
Xm_type_Ptr(PangoScriptIter_, PangoScriptIter*)
#define C_to_Xen_PangoScript(Arg) C_int_to_Xen_integer(Arg)
Xm_type_Ptr_1(GtkFileChooserButton_, GtkFileChooserButton*)
#define C_to_Xen_GdkModifierType(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GdkModifierType(Arg) (GdkModifierType)(Xen_integer_to_C_int(Arg))
#define Xen_is_GdkModifierType(Arg) Xen_is_integer(Arg)
Xm_type_Ptr_1(PangoRenderer_, PangoRenderer*)
#define Xen_to_C_PangoRenderPart(Arg) (PangoRenderPart)(Xen_integer_to_C_int(Arg))
#define Xen_is_PangoRenderPart(Arg) Xen_is_integer(Arg)
Xm_type_Ptr_1(PangoMatrix_, PangoMatrix*)
Xm_type_Ptr_1(GValue_, GValue*)
#define C_to_Xen_GtkIconViewDropPosition(Arg) C_int_to_Xen_integer(Arg)
Xm_type_Ptr_1(GtkAssistant_, GtkAssistant*)
#define C_to_Xen_GtkAssistantPageType(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkAssistantPageType(Arg) (GtkAssistantPageType)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkAssistantPageType(Arg) Xen_is_integer(Arg)
Xm_type_Ptr_1(GtkLinkButton_, GtkLinkButton*)
Xm_type_Ptr(GtkRecentManager_, GtkRecentManager*)
Xm_type_Ptr(GtkRecentInfo_, GtkRecentInfo*)
Xm_type_no_p_2(time_t, time_t)
Xm_type_Ptr_1(GtkRecentData_, GtkRecentData*)
#define C_to_Xen_GtkTreeViewGridLines(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkTreeViewGridLines(Arg) (GtkTreeViewGridLines)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkTreeViewGridLines(Arg) Xen_is_integer(Arg)
Xm_type_Ptr(GtkPrintContext_, GtkPrintContext*)
Xm_type_Ptr(GtkPageSetup_, GtkPageSetup*)
Xm_type_Ptr(GtkPrintOperation_, GtkPrintOperation*)
Xm_type_Ptr(GtkPrintSettings_, GtkPrintSettings*)
#define Xen_to_C_GtkUnit(Arg) (GtkUnit)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkUnit(Arg) Xen_is_integer(Arg)
#define C_to_Xen_GtkPrintOperationResult(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkPrintOperationAction(Arg) (GtkPrintOperationAction)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkPrintOperationAction(Arg) Xen_is_integer(Arg)
#define C_to_Xen_GtkPrintStatus(Arg) C_int_to_Xen_integer(Arg)
Xm_type_1(GtkPageSetupDoneFunc, GtkPageSetupDoneFunc)
Xm_type_1(GtkPrintSettingsFunc, GtkPrintSettingsFunc)
#define C_to_Xen_GtkPageOrientation(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkPageOrientation(Arg) (GtkPageOrientation)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkPageOrientation(Arg) Xen_is_integer(Arg)
Xm_type_Ptr(GtkPaperSize_, GtkPaperSize*)
#define C_to_Xen_GtkPrintDuplex(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkPrintDuplex(Arg) (GtkPrintDuplex)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkPrintDuplex(Arg) Xen_is_integer(Arg)
#define C_to_Xen_GtkPrintQuality(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkPrintQuality(Arg) (GtkPrintQuality)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkPrintQuality(Arg) Xen_is_integer(Arg)
#define C_to_Xen_GtkPrintPages(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkPrintPages(Arg) (GtkPrintPages)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkPrintPages(Arg) Xen_is_integer(Arg)
Xm_type_Ptr(GtkPageRange_, GtkPageRange*)
#define C_to_Xen_GtkPageSet(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkPageSet(Arg) (GtkPageSet)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkPageSet(Arg) Xen_is_integer(Arg)
Xm_type_Ptr_1(GtkTooltip_, GtkTooltip*)
Xm_type_Ptr_1(GtkScaleButton_, GtkScaleButton*)
#define C_to_Xen_GtkSensitivityType(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkSensitivityType(Arg) (GtkSensitivityType)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkSensitivityType(Arg) Xen_is_integer(Arg)
#define Xen_to_C_GtkEntryIconPosition(Arg) (GtkEntryIconPosition)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkEntryIconPosition(Arg) Xen_is_integer(Arg)
Xm_type_Ptr_1(GtkInfoBar_, GtkInfoBar*)
#define C_to_Xen_GtkMessageType(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkMessageType(Arg) (GtkMessageType)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkMessageType(Arg) Xen_is_integer(Arg)
Xm_type_Ptr(GtkEntryBuffer_, GtkEntryBuffer*)
Xm_type_Ptr_1(GtkSpinner_, GtkSpinner*)
#define Xen_to_C_GtkPackType(Arg) (GtkPackType)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkPackType(Arg) Xen_is_integer(Arg)
#if GTK_CHECK_VERSION(3, 0, 0)
Xm_type_Ptr_1(GtkAccessible_, GtkAccessible*)
Xm_type_Ptr(GdkDevice_, GdkDevice*)
#define C_to_Xen_GtkOrientation(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkOrientation(Arg) (GtkOrientation)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkOrientation(Arg) Xen_is_integer(Arg)
Xm_type_Ptr_1(GtkMessageDialog_, GtkMessageDialog*)
Xm_type_Ptr(cairo_region_t_, cairo_region_t*)
#define C_to_Xen_GtkSizeRequestMode(Arg) C_int_to_Xen_integer(Arg)
#define C_to_Xen_GtkAlign(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkAlign(Arg) (GtkAlign)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkAlign(Arg) Xen_is_integer(Arg)
Xm_type_Ptr_1(GtkComboBoxText_, GtkComboBoxText*)
Xm_type_Ptr(GdkRGBA_, GdkRGBA*)
Xm_type_Ptr_1(GtkGrid_, GtkGrid*)
Xm_type_Ptr_1(GtkScrollable_, GtkScrollable*)
#define C_to_Xen_GtkScrollablePolicy(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkScrollablePolicy(Arg) (GtkScrollablePolicy)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkScrollablePolicy(Arg) Xen_is_integer(Arg)
Xm_type_Ptr_1(GtkSwitch_, GtkSwitch*)
Xm_type_Ptr(GtkBorder_, GtkBorder*)
Xm_type_Ptr_1(GtkCellArea_, GtkCellArea*)
Xm_type_Ptr_1(GtkOrientable_, GtkOrientable*)
Xm_type_Ptr_2(GIcon_, GIcon*)
Xm_type_Ptr(GtkWindowGroup_, GtkWindowGroup*)
#define C_to_Xen_GtkStateFlags(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkStateFlags(Arg) (GtkStateFlags)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkStateFlags(Arg) Xen_is_integer(Arg)
#endif

#if GTK_CHECK_VERSION(3, 2, 0)
Xm_type_Ptr_1(GtkOverlay_, GtkOverlay*)
Xm_type_Ptr_1(GtkFontChooser_, GtkFontChooser*)
#endif

#if GTK_CHECK_VERSION(3, 4, 0)
Xm_type_Ptr(GMenuModel_, GMenuModel*)
Xm_type_Ptr_1(GtkApplication_, GtkApplication*)
Xm_type_Ptr_1(GtkApplicationWindow_, GtkApplicationWindow*)
Xm_type_Ptr_1(GtkColorChooser_, GtkColorChooser*)
#endif

#if GTK_CHECK_VERSION(3, 6, 0)
Xm_type_Ptr_1(GtkMenuButton_, GtkMenuButton*)
Xm_type_Ptr_1(GtkLevelBar_, GtkLevelBar*)
#define C_to_Xen_GtkLevelBarMode(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkLevelBarMode(Arg) (GtkLevelBarMode)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkLevelBarMode(Arg) Xen_is_integer(Arg)
#define C_to_Xen_GtkInputPurpose(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkInputPurpose(Arg) (GtkInputPurpose)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkInputPurpose(Arg) Xen_is_integer(Arg)
#define C_to_Xen_GtkInputHints(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkInputHints(Arg) (GtkInputHints)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkInputHints(Arg) Xen_is_integer(Arg)
#endif

#if GTK_CHECK_VERSION(3, 10, 0)
#define C_to_Xen_GtkBaselinePosition(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkBaselinePosition(Arg) (GtkBaselinePosition)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkBaselinePosition(Arg) Xen_is_integer(Arg)
Xm_type_Ptr_1(GtkStackSwitcher_, GtkStackSwitcher*)
Xm_type_Ptr(GtkStack_, GtkStack*)
#define C_to_Xen_GtkStackTransitionType(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkStackTransitionType(Arg) (GtkStackTransitionType)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkStackTransitionType(Arg) Xen_is_integer(Arg)
Xm_type_Ptr_1(GtkRevealer_, GtkRevealer*)
#define C_to_Xen_GtkRevealerTransitionType(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkRevealerTransitionType(Arg) (GtkRevealerTransitionType)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkRevealerTransitionType(Arg) Xen_is_integer(Arg)
Xm_type_Ptr_1(GtkHeaderBar_, GtkHeaderBar*)
Xm_type_Ptr(GtkListBoxRow_, GtkListBoxRow*)
Xm_type_Ptr_1(GtkListBox_, GtkListBox*)
Xm_type_Ptr_1(GtkSearchBar_, GtkSearchBar*)
#define C_to_Xen_GdkEventType(Arg) C_int_to_Xen_integer(Arg)
#endif

#if GTK_CHECK_VERSION(3, 12, 0)
Xm_type_Ptr(GtkFlowBoxChild_, GtkFlowBoxChild*)
Xm_type_Ptr_1(GtkFlowBox_, GtkFlowBox*)
Xm_type_Ptr_1(GtkActionBar_, GtkActionBar*)
#endif

#if GTK_CHECK_VERSION(3, 14, 0)
Xm_type_Ptr_1(GtkGesture_, GtkGesture*)
#define C_to_Xen_GtkEventSequenceState(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkEventSequenceState(Arg) (GtkEventSequenceState)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkEventSequenceState(Arg) Xen_is_integer(Arg)
Xm_type_Ptr(GdkEventSequence_, GdkEventSequence*)
Xm_type_Ptr_1(GtkGestureDrag_, GtkGestureDrag*)
Xm_type_Ptr_1(GtkGesturePan_, GtkGesturePan*)
Xm_type_Ptr_1(GtkGestureRotate_, GtkGestureRotate*)
Xm_type_Ptr_1(GtkGestureSingle_, GtkGestureSingle*)
Xm_type_Ptr_1(GtkGestureSwipe_, GtkGestureSwipe*)
Xm_type_Ptr_1(GtkGestureZoom_, GtkGestureZoom*)
#endif

#if GTK_CHECK_VERSION(3, 16, 0)
Xm_type_Ptr_1(GtkPaned_, GtkPaned*)
Xm_type_Ptr_1(GtkGLArea_, GtkGLArea*)
Xm_type_Ptr(GdkGLContext_, GdkGLContext*)
Xm_type_Ptr_1(GtkStyleContext_, GtkStyleContext*)
Xm_type_Ptr_1(GtkStackSidebar_, GtkStackSidebar*)
#endif

#if GTK_CHECK_VERSION(3, 20, 0)
Xm_type_Ptr_1(GtkShortcutsWindow_, GtkShortcutsWindow*)
Xm_type_Ptr(GdkSeat_, GdkSeat*)
#define C_to_Xen_GdkSeatCapabilities(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GdkSeatCapabilities(Arg) (GdkSeatCapabilities)(Xen_integer_to_C_int(Arg))
#define Xen_is_GdkSeatCapabilities(Arg) Xen_is_integer(Arg)
#endif

#if GTK_CHECK_VERSION(3, 22, 0)
#define C_to_Xen_GdkAxisFlags(Arg) C_int_to_Xen_integer(Arg)
Xm_type_Ptr(GdkDeviceTool_, GdkDeviceTool*)
Xm_type_Ptr_1(GdkMonitor_, GdkMonitor*)
#define C_to_Xen_GdkSubpixelLayout(Arg) C_int_to_Xen_integer(Arg)
Xm_type_Ptr_1(GdkDevicePad_, GdkDevicePad*)
#define Xen_to_C_GdkDevicePadFeature(Arg) (GdkDevicePadFeature)(Xen_integer_to_C_int(Arg))
#define Xen_is_GdkDevicePadFeature(Arg) Xen_is_integer(Arg)
Xm_type_Ptr_1(GtkPadController_, GtkPadController*)
Xm_type_Ptr_1(GtkPadActionEntry_, GtkPadActionEntry*)
#define Xen_to_C_GtkPadActionType(Arg) (GtkPadActionType)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkPadActionType(Arg) Xen_is_integer(Arg)
Xm_type_Ptr_1(GtkShortcutLabel_, GtkShortcutLabel*)
#endif

#if GTK_CHECK_VERSION(3, 92, 0)
Xm_type_Ptr(GtkDrawingArea_, GtkDrawingArea*)
#define C_to_Xen_int(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_int(Arg) (int)(Xen_integer_to_C_int(Arg))
#define Xen_is_int(Arg) Xen_is_integer(Arg)
Xm_type_Ptr_1(GtkCheckButton_, GtkCheckButton*)
Xm_type_Ptr_1(GtkCenterBox_, GtkCenterBox*)
Xm_type_Ptr_1(GtkScrollbar_, GtkScrollbar*)
Xm_type_Ptr_1(GtkStyleProvider_, GtkStyleProvider*)
#define Xen_to_C_GtkStyleContextPrintFlags(Arg) (GtkStyleContextPrintFlags)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkStyleContextPrintFlags(Arg) Xen_is_integer(Arg)
Xm_type_Ptr(GtkCssProvider_, GtkCssProvider*)
Xm_type_Ptr(GFile_, GFile*)
#endif

#if GTK_CHECK_VERSION(3, 94, 0)
Xm_type_Ptr_1(GtkEventController_, GtkEventController*)
#define C_to_Xen_GtkEventControllerScrollFlags(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkEventControllerScrollFlags(Arg) (GtkEventControllerScrollFlags)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkEventControllerScrollFlags(Arg) Xen_is_integer(Arg)
Xm_type_Ptr(GtkEventControllerScroll_, GtkEventControllerScroll*)
Xm_type_Ptr(GdkAppLaunchContext_, GdkAppLaunchContext*)
Xm_type_Ptr(GdkClipboard_, GdkClipboard*)
Xm_type_Ptr(GdkContentFormats_, GdkContentFormats*)
Xm_type_Ptr(GdkContentProvider_, GdkContentProvider*)
Xm_type_Ptr(GCancellable_, GCancellable*)
Xm_type(GAsyncReadyCallback, GAsyncReadyCallback)
Xm_type_Ptr(GAsyncResult_, GAsyncResult*)
Xm_type_Ptr(GdkTexture_, GdkTexture*)
Xm_type_Ptr_1(GString_, GString*)
Xm_type_Ptr(GdkContentFormatsBuilder_, GdkContentFormatsBuilder*)
Xm_type_Ptr(GOutputStream_, GOutputStream*)
Xm_type_Ptr(GdkContentSerializer_, GdkContentSerializer*)
Xm_type_Ptr(GdkContentDeserializer_, GdkContentDeserializer*)
Xm_type_Ptr(GInputStream_, GInputStream*)
Xm_type_Ptr(GBytes_, GBytes*)
Xm_type_Ptr(GdkCursor_, GdkCursor*)
#define C_to_Xen_GtkIconSize(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkIconSize(Arg) (GtkIconSize)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkIconSize(Arg) Xen_is_integer(Arg)
Xm_type_Ptr(GdkPaintable_, GdkPaintable*)
#define Xen_to_C_GdkDragAction(Arg) (GdkDragAction)(Xen_integer_to_C_int(Arg))
#define Xen_is_GdkDragAction(Arg) Xen_is_integer(Arg)
Xm_type(GApplicationFlags, GApplicationFlags)
#define Xen_to_C_GtkApplicationInhibitFlags(Arg) (GtkApplicationInhibitFlags)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkApplicationInhibitFlags(Arg) Xen_is_integer(Arg)
Xm_type_Ptr(GMenu_, GMenu*)
Xm_type_Ptr(GdkSurface_, GdkSurface*)
#define Xen_to_C_GdkMemoryFormat(Arg) (GdkMemoryFormat)(Xen_integer_to_C_int(Arg))
#define Xen_is_GdkMemoryFormat(Arg) Xen_is_integer(Arg)
Xm_type_Ptr(GdkCairoContext_, GdkCairoContext*)
Xm_type_Ptr(GdkDrop_, GdkDrop*)
Xm_type_Ptr(GdkDrag_, GdkDrag*)
Xm_type_Ptr(GdkGLTexture_, GdkGLTexture*)
#define C_to_Xen_GtkPropagationPhase(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkPropagationPhase(Arg) (GtkPropagationPhase)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkPropagationPhase(Arg) Xen_is_integer(Arg)
Xm_type_Ptr(GtkGestureStylus_, GtkGestureStylus*)
#define Xen_to_C_GdkAxisUse(Arg) (GdkAxisUse)(Xen_integer_to_C_int(Arg))
#define Xen_is_GdkAxisUse(Arg) Xen_is_integer(Arg)
Xm_type_Ptr(GdkTimeCoord__, GdkTimeCoord**)
Xm_type_Ptr(GtkMediaStream_, GtkMediaStream*)
Xm_type_Ptr(GtkMediaControls_, GtkMediaControls*)
Xm_type_Ptr(GtkMediaFile_, GtkMediaFile*)
Xm_type(gint64, gint64)
Xm_type_Ptr(GtkPicture_, GtkPicture*)
Xm_type_Ptr(GtkVideo_, GtkVideo*)
Xm_type_Ptr(GtkWidgetPaintable_, GtkWidgetPaintable*)
Xm_type_Ptr_1(GActionGroup_, GActionGroup*)
Xm_type_Ptr_1(GtkAllocation_, GtkAllocation*)
#endif

#if GTK_CHECK_VERSION(3, 96, 0)
Xm_type_Ptr(GtkAssistantPage_, GtkAssistantPage*)
Xm_type_Ptr(GListModel_, GListModel*)
#define Xen_to_C_float(Arg) (float)(Xen_real_to_C_double(Arg))
#define Xen_is_float(Arg) Xen_is_number(Arg)
Xm_type_Ptr(GObjectClass_, GObjectClass*)
Xm_type_Ptr_1(GParamSpec_, GParamSpec*)
Xm_type_Ptr(GskTransform_, GskTransform*)
Xm_type_Ptr_2(GtkNotebookPage_, GtkNotebookPage*)
Xm_type_Ptr(GtkStackPage_, GtkStackPage*)
Xm_type_Ptr(GtkSelectionModel_, GtkSelectionModel*)
Xm_type_Ptr(GtkLayoutManager_, GtkLayoutManager*)
Xm_type_Ptr(GtkWidgetClass_, GtkWidgetClass*)
Xm_type_Ptr(GtkRoot_, GtkRoot*)
Xm_type_Ptr(graphene_matrix_t_, graphene_matrix_t*)
Xm_type_Ptr(graphene_point_t_, graphene_point_t*)
#define C_to_Xen_GtkOverflow(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkOverflow(Arg) (GtkOverflow)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkOverflow(Arg) Xen_is_integer(Arg)
#define Xen_to_C_GtkPickFlags(Arg) (GtkPickFlags)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkPickFlags(Arg) Xen_is_integer(Arg)
Xm_type_Ptr(GtkBoxLayout_, GtkBoxLayout*)
Xm_type(GtkCustomRequestModeFunc, GtkCustomRequestModeFunc)
Xm_type(GtkCustomMeasureFunc, GtkCustomMeasureFunc)
Xm_type(GtkCustomAllocateFunc, GtkCustomAllocateFunc)
Xm_type_Ptr(GtkFilterListModel_, GtkFilterListModel*)
Xm_type_Ptr(GtkFlattenListModel_, GtkFlattenListModel*)
Xm_type_Ptr(GtkGridLayout_, GtkGridLayout*)
Xm_type_Ptr(GtkGridLayoutChild_, GtkGridLayoutChild*)
Xm_type_Ptr(GtkLayoutChild_, GtkLayoutChild*)
Xm_type_Ptr(GtkMapListModel_, GtkMapListModel*)
Xm_type_Ptr(GtkPasswordEntry_, GtkPasswordEntry*)
Xm_type_Ptr(GtkSingleSelection_, GtkSingleSelection*)
Xm_type_Ptr(GtkSliceListModel_, GtkSliceListModel*)
Xm_type_Ptr(GtkSortListModel_, GtkSortListModel*)
Xm_type_Ptr(GtkText_, GtkText*)
Xm_type_Ptr(GtkTreeListModel_, GtkTreeListModel*)
Xm_type_Ptr(GtkTreeListRow_, GtkTreeListRow*)
#endif

#if GTK_CHECK_VERSION(3, 98, 0)
Xm_type_Ptr_1(GtkTreeDragDest_, GtkTreeDragDest*)
Xm_type_Ptr(GtkFixedLayoutChild_, GtkFixedLayoutChild*)
Xm_type_Ptr(GdkContentProvider__, GdkContentProvider**)
Xm_type(GtkScaleFormatValueFunc, GtkScaleFormatValueFunc)
Xm_type_Ptr(GtkGestureLongPress_, GtkGestureLongPress*)
Xm_type(GtkPropagationLimit, GtkPropagationLimit)
Xm_type_Ptr(GdkDragSurface_, GdkDragSurface*)
Xm_type_Ptr(GdkPopup_, GdkPopup*)
Xm_type_Ptr(GdkPopupLayout_, GdkPopupLayout*)
#define Xen_to_C_GdkGravity(Arg) (GdkGravity)(Xen_integer_to_C_int(Arg))
#define Xen_is_GdkGravity(Arg) Xen_is_integer(Arg)
#define Xen_to_C_GdkAnchorHints(Arg) (GdkAnchorHints)(Xen_integer_to_C_int(Arg))
#define Xen_is_GdkAnchorHints(Arg) Xen_is_integer(Arg)
Xm_type_Ptr(GtkDragSource_, GtkDragSource*)
Xm_type_Ptr(GtkNoSelection_, GtkNoSelection*)
Xm_type_Ptr(GtkPopoverMenuBar_, GtkPopoverMenuBar*)
Xm_type_Ptr(GtkCenterLayout_, GtkCenterLayout*)
#define Xen_to_C_GtkPopoverMenuFlags(Arg) (GtkPopoverMenuFlags)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkPopoverMenuFlags(Arg) Xen_is_integer(Arg)
Xm_type_Ptr_1(GtkPopoverMenu_, GtkPopoverMenu*)
Xm_type_Ptr(GdkToplevel_, GdkToplevel*)
Xm_type_Ptr(GdkToplevelLayout_, GdkToplevelLayout*)
#define C_to_Xen_GdkSurfaceState(Arg) C_int_to_Xen_integer(Arg)
Xm_type_Ptr_1(GdkModifierType_, GdkModifierType*)
Xm_type_Ptr(GdkFrameClock_, GdkFrameClock*)
Xm_type_Ptr_1(GError__, GError**)
Xm_type_Ptr(GdkVulkanContext_, GdkVulkanContext*)
Xm_type_Ptr(GtkEventControllerMotion_, GtkEventControllerMotion*)
Xm_type_Ptr(GtkConstraintGuide_, GtkConstraintGuide*)
#define C_to_Xen_GtkConstraintStrength(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkConstraintStrength(Arg) (GtkConstraintStrength)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkConstraintStrength(Arg) Xen_is_integer(Arg)
Xm_type_Ptr(GtkIconTheme_, GtkIconTheme*)
Xm_type_Ptr(GtkIconPaintable_, GtkIconPaintable*)
#define Xen_to_C_GtkIconLookupFlags(Arg) (GtkIconLookupFlags)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkIconLookupFlags(Arg) Xen_is_integer(Arg)
Xm_type_Ptr(GtkConstraint_, GtkConstraint*)
#define C_to_Xen_GtkConstraintAttribute(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkConstraintAttribute(Arg) (GtkConstraintAttribute)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkConstraintAttribute(Arg) Xen_is_integer(Arg)
#define C_to_Xen_GtkConstraintRelation(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkConstraintRelation(Arg) (GtkConstraintRelation)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkConstraintRelation(Arg) Xen_is_integer(Arg)
Xm_type_Ptr(GtkConstraintTarget_, GtkConstraintTarget*)
Xm_type_Ptr(GtkConstraintLayout_, GtkConstraintLayout*)
Xm_type_Ptr(GtkEventControllerFocus_, GtkEventControllerFocus*)
Xm_type_Ptr(GtkDragIcon_, GtkDragIcon*)
Xm_type_Ptr(GtkDropControllerMotion_, GtkDropControllerMotion*)
Xm_type_Ptr(GtkDropTarget_, GtkDropTarget*)
Xm_type_Ptr(gsize_, gsize*)
Xm_type_Ptr(GtkDropTargetAsync_, GtkDropTargetAsync*)
Xm_type(GtkMenuButtonCreatePopupFunc, GtkMenuButtonCreatePopupFunc)
Xm_type_Ptr(GtkTreePath__, GtkTreePath**)
Xm_type_Ptr_1(GtkPopover_, GtkPopover*)
Xm_type(GtkWidgetActionActivateFunc, GtkWidgetActionActivateFunc)
Xm_type_Ptr_1(GVariant_, GVariant*)
Xm_type_Ptr(GtkNative_, GtkNative*)
Xm_type_Ptr(GMenuItem_, GMenuItem*)
Xm_type_Ptr(GVariantType_, GVariantType*)
Xm_type_Ptr(GtkShortcut_, GtkShortcut*)
Xm_type_Ptr(GtkShortcutTrigger_, GtkShortcutTrigger*)
Xm_type_Ptr(GtkShortcutAction_, GtkShortcutAction*)
#define Xen_to_C_GtkShortcutActionFlags(Arg) (GtkShortcutActionFlags)(Xen_integer_to_C_int(Arg))
Xm_type(GtkShortcutFunc, GtkShortcutFunc)
Xm_type_Ptr(GtkSignalAction_, GtkSignalAction*)
Xm_type_Ptr(GtkNamedAction_, GtkNamedAction*)
Xm_type_Ptr(GtkShortcutController_, GtkShortcutController*)
#define C_to_Xen_GtkShortcutScope(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkShortcutScope(Arg) (GtkShortcutScope)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkShortcutScope(Arg) Xen_is_integer(Arg)
Xm_type(gconstpointer, gconstpointer)
Xm_type_Ptr(GtkKeyvalTrigger_, GtkKeyvalTrigger*)
Xm_type_Ptr(GtkMnemonicTrigger_, GtkMnemonicTrigger*)
Xm_type_Ptr(GtkAlternativeTrigger_, GtkAlternativeTrigger*)
#define C_to_Xen_GdkKeyMatch(Arg) C_int_to_Xen_integer(Arg)
Xm_type_Ptr_1(GdkKeymapKey_, GdkKeymapKey*)
Xm_type_Ptr_1(GtkAspectFrame_, GtkAspectFrame*)
Xm_type_Ptr_1(GtkViewport_, GtkViewport*)
Xm_type_Ptr(GtkColorButton_, GtkColorButton*)
Xm_type_Ptr(GdkTimeCoord_, GdkTimeCoord*)
#define Xen_to_C_GdkSurfaceEdge(Arg) (GdkSurfaceEdge)(Xen_integer_to_C_int(Arg))
#define Xen_is_GdkSurfaceEdge(Arg) Xen_is_integer(Arg)
Xm_type_Ptr_2(GtkWidget__, GtkWidget**)
Xm_type_Ptr(GtkWindowControls_, GtkWindowControls*)
Xm_type_Ptr(GtkWindowHandle_, GtkWindowHandle*)
Xm_type_Ptr(GDateTime_, GDateTime*)
Xm_type_Ptr_1(guint__, guint**)
#endif

Xm_type_Ptr(cairo_surface_t_, cairo_surface_t*)
#define C_to_Xen_cairo_content_t(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_cairo_content_t(Arg) (cairo_content_t)(Xen_integer_to_C_int(Arg))
#define Xen_is_cairo_content_t(Arg) Xen_is_integer(Arg)
Xm_type_Ptr(cairo_pattern_t_, cairo_pattern_t*)
#define C_to_Xen_cairo_operator_t(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_cairo_operator_t(Arg) (cairo_operator_t)(Xen_integer_to_C_int(Arg))
#define Xen_is_cairo_operator_t(Arg) Xen_is_integer(Arg)
#define C_to_Xen_cairo_antialias_t(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_cairo_antialias_t(Arg) (cairo_antialias_t)(Xen_integer_to_C_int(Arg))
#define Xen_is_cairo_antialias_t(Arg) Xen_is_integer(Arg)
#define C_to_Xen_cairo_fill_rule_t(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_cairo_fill_rule_t(Arg) (cairo_fill_rule_t)(Xen_integer_to_C_int(Arg))
#define Xen_is_cairo_fill_rule_t(Arg) Xen_is_integer(Arg)
#define C_to_Xen_cairo_line_cap_t(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_cairo_line_cap_t(Arg) (cairo_line_cap_t)(Xen_integer_to_C_int(Arg))
#define Xen_is_cairo_line_cap_t(Arg) Xen_is_integer(Arg)
#define C_to_Xen_cairo_line_join_t(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_cairo_line_join_t(Arg) (cairo_line_join_t)(Xen_integer_to_C_int(Arg))
#define Xen_is_cairo_line_join_t(Arg) Xen_is_integer(Arg)
Xm_type_Ptr_1(cairo_matrix_t_, cairo_matrix_t*)
#define C_to_Xen_bool(Arg) C_bool_to_Xen_boolean(Arg)
#define Xen_to_C_bool(Arg) (bool)(Xen_boolean_to_C_bool(Arg))
#define Xen_is_bool(Arg) Xen_is_boolean(Arg)
#define C_to_Xen_cairo_status_t(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_cairo_status_t(Arg) (cairo_status_t)(Xen_integer_to_C_int(Arg))
#define Xen_is_cairo_status_t(Arg) Xen_is_integer(Arg)
#define C_to_Xen_cairo_subpixel_order_t(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_cairo_subpixel_order_t(Arg) (cairo_subpixel_order_t)(Xen_integer_to_C_int(Arg))
#define Xen_is_cairo_subpixel_order_t(Arg) Xen_is_integer(Arg)
#define C_to_Xen_cairo_hint_style_t(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_cairo_hint_style_t(Arg) (cairo_hint_style_t)(Xen_integer_to_C_int(Arg))
#define Xen_is_cairo_hint_style_t(Arg) Xen_is_integer(Arg)
#define C_to_Xen_cairo_hint_metrics_t(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_cairo_hint_metrics_t(Arg) (cairo_hint_metrics_t)(Xen_integer_to_C_int(Arg))
#define Xen_is_cairo_hint_metrics_t(Arg) Xen_is_integer(Arg)
#define C_to_Xen_cairo_font_slant_t(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_cairo_font_slant_t(Arg) (cairo_font_slant_t)(Xen_integer_to_C_int(Arg))
#define Xen_is_cairo_font_slant_t(Arg) Xen_is_integer(Arg)
#define C_to_Xen_cairo_font_weight_t(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_cairo_font_weight_t(Arg) (cairo_font_weight_t)(Xen_integer_to_C_int(Arg))
#define Xen_is_cairo_font_weight_t(Arg) Xen_is_integer(Arg)
Xm_type_Ptr(cairo_scaled_font_t_, cairo_scaled_font_t*)
Xm_type_Ptr(cairo_glyph_t_, cairo_glyph_t*)
Xm_type_Ptr(cairo_font_face_t_, cairo_font_face_t*)
Xm_type_Ptr_1(cairo_font_extents_t_, cairo_font_extents_t*)
Xm_type_Ptr_1(cairo_text_extents_t_, cairo_text_extents_t*)
Xm_type_Ptr_1(cairo_user_data_key_t_, cairo_user_data_key_t*)
Xm_type_1(cairo_destroy_func_t, cairo_destroy_func_t)
Xm_type_Ptr(cairo_path_t_, cairo_path_t*)
#define C_to_Xen_cairo_format_t(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_cairo_format_t(Arg) (cairo_format_t)(Xen_integer_to_C_int(Arg))
#define Xen_is_cairo_format_t(Arg) Xen_is_integer(Arg)
#define C_to_Xen_cairo_extend_t(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_cairo_extend_t(Arg) (cairo_extend_t)(Xen_integer_to_C_int(Arg))
#define Xen_is_cairo_extend_t(Arg) Xen_is_integer(Arg)
#define C_to_Xen_cairo_filter_t(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_cairo_filter_t(Arg) (cairo_filter_t)(Xen_integer_to_C_int(Arg))
#define Xen_is_cairo_filter_t(Arg) Xen_is_integer(Arg)
Xm_type_Ptr(void_, void*)
Xm_type_Ptr(cairo_rectangle_list_t_, cairo_rectangle_list_t*)
Xm_type_Ptr(cairo_text_cluster_t_, cairo_text_cluster_t*)
#define Xen_to_C_cairo_text_cluster_flags_t(Arg) (cairo_text_cluster_flags_t)(Xen_integer_to_C_int(Arg))
#define Xen_is_cairo_text_cluster_flags_t(Arg) Xen_is_integer(Arg)
Xm_type_Ptr_1(cairo_glyph_t__, cairo_glyph_t**)
Xm_type_Ptr_1(cairo_text_cluster_t__, cairo_text_cluster_t**)
Xm_type_Ptr_1(cairo_text_cluster_flags_t_, cairo_text_cluster_flags_t*)
#define C_to_Xen_cairo_bool_t(Arg) C_int_to_Xen_integer(Arg)
Xm_type_Ptr(cairo_device_t_, cairo_device_t*)
Xm_type_Ptr_1(cairo_rectangle_t_, cairo_rectangle_t*)
Xm_type_Ptr_1(double_, double*)
Xm_type_Ptr_1(cairo_rectangle_int_t_, cairo_rectangle_int_t*)
Xm_type_no_p_2(cairo_region_overlap_t, cairo_region_overlap_t)
#define XLS(a, b) Xen_to_C_gchar_(Xen_list_ref(a, b))
#define XLI(a, b) ((int)Xen_integer_to_C_int(Xen_list_ref(a, b)))
#define XLL(a, b) (Xen_llong_to_C_llong(Xen_list_ref(a, b)))
#define XLG(a, b) Xen_to_C_GType(Xen_list_ref(a, b))
#define XLT(a, b) Xen_to_C_GtkTextTag_(Xen_list_ref(a, b))
#define XLA(a, b) ((Xen_is_integer(Xen_list_ref(a, b))) ? ((gpointer)((intptr_t)XLL(a, b))) : ((Xen_is_string(Xen_list_ref(a, b))) ? ((gpointer)XLS(a, b)) : ((gpointer)XLG(a, b))))

/* -------------------------------- gc protection -------------------------------- */

static Xen xm_protected;
static int xm_protected_size = 0;
static Xen xm_gc_table;
static int last_xm_unprotect = NOT_A_GC_LOC;

static int xm_protect(Xen obj)
{
  int i, new_size;
  Xen new_table;
  if (last_xm_unprotect >= 0)
    {
      i = last_xm_unprotect;
      if (Xen_is_false(Xen_vector_ref(xm_protected, i)))
	{
	  Xen_vector_set(xm_protected, i, obj);
	  last_xm_unprotect = NOT_A_GC_LOC;
	  return(i);
	}
      last_xm_unprotect = NOT_A_GC_LOC;
    }
  for (i = 0; i < xm_protected_size; i++)
    if (Xen_is_false(Xen_vector_ref(xm_protected, i)))
      {
	Xen_vector_set(xm_protected, i, obj);
	return(i);
      }
  new_size = xm_protected_size * 2;
  new_table = Xen_make_vector(new_size, Xen_false);
  for (i = 0; i < xm_protected_size; i++)
    {
      Xen_vector_set(new_table, i, Xen_vector_ref(xm_protected, i));
      Xen_vector_set(xm_protected, i, Xen_false);
    }
  Xen_vector_set(new_table, xm_protected_size, obj);
  Xen_vector_set(xm_gc_table, 0, new_table);
  i = xm_protected_size;
  xm_protected_size = new_size;
  xm_protected = new_table;
  return(i);
}

static void xm_unprotect_at(int ind)
{
  Xen_vector_set(xm_protected, ind, Xen_false);
  last_xm_unprotect = ind;
}



/* ---------------------------------------- callback handlers ---------------------------------------- */

static void gxg_func2(GtkWidget* w, gpointer func_info)
{
  if (!Xen_is_list((Xen)func_info)) return;
  Xen_call_with_2_args(Xen_car((Xen)func_info),
             C_to_Xen_GtkWidget_(w),
             Xen_cadr((Xen)func_info),
             __func__);
}

static gboolean gxg_timer_func(gpointer func_info)
{
  if (!Xen_is_list((Xen)func_info)) return((gboolean)0);
  return(Xen_to_C_gboolean(Xen_call_with_1_arg(Xen_car((Xen)func_info),
                                      Xen_cadr((Xen)func_info),
                                      __func__)));
}

static void gxg_destroy_func(gpointer func_info)
{
  if (!Xen_is_list((Xen)func_info)) return;
  Xen_call_with_1_arg(Xen_cadddr((Xen)func_info),
             Xen_cadr((Xen)func_info),
             __func__);
}

static void gxg_text_tag_table_foreach(GtkTextTag* tag, gpointer func_info)
{
  if (!Xen_is_list((Xen)func_info)) return;
  Xen_call_with_2_args(Xen_car((Xen)func_info),
             C_to_Xen_GtkTextTag_(tag),
             Xen_cadr((Xen)func_info),
             __func__);
}

static gboolean gxg_model_func(GtkTreeModel* model, GtkTreePath* path, GtkTreeIter* iter, gpointer func_info)
{
  if (!Xen_is_list((Xen)func_info)) return((gboolean)0);
  return(Xen_to_C_gboolean(Xen_call_with_4_args(Xen_car((Xen)func_info),
                                      C_to_Xen_GtkTreeModel_(model),
                                      C_to_Xen_GtkTreePath_(path),
                                      C_to_Xen_GtkTreeIter_(iter),
                                      Xen_cadr((Xen)func_info),
                                      __func__)));
}

static void gxg_tree_selection_func(GtkTreeModel* model, GtkTreePath* path, GtkTreeIter* iter, gpointer func_info)
{
  if (!Xen_is_list((Xen)func_info)) return;
  Xen_call_with_4_args(Xen_car((Xen)func_info),
             C_to_Xen_GtkTreeModel_(model),
             C_to_Xen_GtkTreePath_(path),
             C_to_Xen_GtkTreeIter_(iter),
             Xen_cadr((Xen)func_info),
             __func__);
}

static gboolean gxg_text_char_predicate(gunichar ch, gpointer func_info)
{
  if (!Xen_is_list((Xen)func_info)) return((gboolean)0);
  return(Xen_to_C_gboolean(Xen_call_with_2_args(Xen_car((Xen)func_info),
                                      C_to_Xen_gunichar(ch),
                                      Xen_cadr((Xen)func_info),
                                      __func__)));
}

static gboolean gxg_tree_column(GtkTreeView* tree_view, GtkTreeViewColumn* column, GtkTreeViewColumn* prev_column, GtkTreeViewColumn* next_column, gpointer func_info)
{
  if (!Xen_is_list((Xen)func_info)) return((gboolean)0);
  return(Xen_to_C_gboolean(Xen_call_with_5_args(Xen_car((Xen)func_info),
                                      C_to_Xen_GtkTreeView_(tree_view),
                                      C_to_Xen_GtkTreeViewColumn_(column),
                                      C_to_Xen_GtkTreeViewColumn_(prev_column),
                                      C_to_Xen_GtkTreeViewColumn_(next_column),
                                      Xen_cadr((Xen)func_info),
                                      __func__)));
}

static void gxg_tree_mapping(GtkTreeView* tree_view, GtkTreePath* path, gpointer func_info)
{
  if (!Xen_is_list((Xen)func_info)) return;
  Xen_call_with_3_args(Xen_car((Xen)func_info),
             C_to_Xen_GtkTreeView_(tree_view),
             C_to_Xen_GtkTreePath_(path),
             Xen_cadr((Xen)func_info),
             __func__);
}

static gboolean gxg_tree_search(GtkTreeModel* model, gint column, const gchar* key, GtkTreeIter* iter, gpointer func_info)
{
  if (!Xen_is_list((Xen)func_info)) return((gboolean)0);
  return(Xen_to_C_gboolean(Xen_call_with_5_args(Xen_car((Xen)func_info),
                                      C_to_Xen_GtkTreeModel_(model),
                                      C_to_Xen_gint(column),
                                      C_to_Xen_gchar_(key),
                                      C_to_Xen_GtkTreeIter_(iter),
                                      Xen_cadr((Xen)func_info),
                                      __func__)));
}

static void gxg_cell_data(GtkTreeViewColumn* tree_column, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter, gpointer func_info)
{
  if (!Xen_is_list((Xen)func_info)) return;
  Xen_call_with_5_args(Xen_car((Xen)func_info),
             C_to_Xen_GtkTreeViewColumn_(tree_column),
             C_to_Xen_GtkCellRenderer_(cell),
             C_to_Xen_GtkTreeModel_(tree_model),
             C_to_Xen_GtkTreeIter_(iter),
             Xen_cadr((Xen)func_info),
             __func__);
}

static gint gxg_iter_compare(GtkTreeModel* model, GtkTreeIter* a, GtkTreeIter* b, gpointer func_info)
{
  if (!Xen_is_list((Xen)func_info)) return((gint)0);
  return(Xen_to_C_gint(Xen_call_with_4_args(Xen_car((Xen)func_info),
                                  C_to_Xen_GtkTreeModel_(model),
                                  C_to_Xen_GtkTreeIter_(a),
                                  C_to_Xen_GtkTreeIter_(b),
                                  Xen_cadr((Xen)func_info),
                                  __func__)));
}

static gboolean gxg_tree_selection(GtkTreeSelection* selection, GtkTreeModel* model, GtkTreePath* path, gboolean path_currently_selected, gpointer func_info)
{
  if (!Xen_is_list((Xen)func_info)) return((gboolean)0);
  return(Xen_to_C_gboolean(Xen_call_with_5_args(Xen_car((Xen)func_info),
                                      C_to_Xen_GtkTreeSelection_(selection),
                                      C_to_Xen_GtkTreeModel_(model),
                                      C_to_Xen_GtkTreePath_(path),
                                      C_to_Xen_gboolean(path_currently_selected),
                                      Xen_cadr((Xen)func_info),
                                      __func__)));
}

static gboolean gxg_file_filter(const GtkFileFilterInfo* info, gpointer func_info)
{
  if (!Xen_is_list((Xen)func_info)) return((gboolean)0);
  return(Xen_to_C_gboolean(Xen_call_with_2_args(Xen_car((Xen)func_info),
                                      C_to_Xen_GtkFileFilterInfo_((GtkFileFilterInfo *)info),
                                      Xen_cadr((Xen)func_info),
                                      __func__)));
}

static gboolean gxg_entry_completion_match(GtkEntryCompletion* completion, const gchar* key, GtkTreeIter* iter, gpointer func_info)
{
  if (!Xen_is_list((Xen)func_info)) return((gboolean)0);
  return(Xen_to_C_gboolean(Xen_call_with_4_args(Xen_car((Xen)func_info),
                                      C_to_Xen_GtkEntryCompletion_(completion),
                                      C_to_Xen_gchar_(key),
                                      C_to_Xen_GtkTreeIter_(iter),
                                      Xen_cadr((Xen)func_info),
                                      __func__)));
}

static gboolean gxg_row_separator(GtkTreeModel* model, GtkTreeIter* iter, gpointer func_info)
{
  if (!Xen_is_list((Xen)func_info)) return((gboolean)0);
  return(Xen_to_C_gboolean(Xen_call_with_3_args(Xen_car((Xen)func_info),
                                      C_to_Xen_GtkTreeModel_(model),
                                      C_to_Xen_GtkTreeIter_(iter),
                                      Xen_cadr((Xen)func_info),
                                      __func__)));
}

static void gxg_icon_view_foreach(GtkIconView* icon_view, GtkTreePath* path, gpointer func_info)
{
  if (!Xen_is_list((Xen)func_info)) return;
  Xen_call_with_3_args(Xen_car((Xen)func_info),
             C_to_Xen_GtkIconView_(icon_view),
             C_to_Xen_GtkTreePath_(path),
             Xen_cadr((Xen)func_info),
             __func__);
}

static void gxg_g_message_log_func(const gchar* domain, GLogLevelFlags log_level, const gchar* message, gpointer func_info)
{
  if (!Xen_is_list((Xen)func_info)) return;
  Xen_call_with_4_args(Xen_car((Xen)func_info),
             C_to_Xen_gchar_(domain),
             C_to_Xen_GLogLevelFlags(log_level),
             C_to_Xen_gchar_(message),
             Xen_cadr((Xen)func_info),
             __func__);
}

static gint gxg_page_func(gint current_page, gpointer func_info)
{
  if (!Xen_is_list((Xen)func_info)) return((gint)0);
  return(Xen_to_C_gint(Xen_call_with_2_args(Xen_car((Xen)func_info),
                                  C_to_Xen_gint(current_page),
                                  Xen_cadr((Xen)func_info),
                                  __func__)));
}

#if GTK_CHECK_VERSION(3, 92, 0)
static void gxg_draw_func(GtkDrawingArea* self, cairo_t* cr, int width, int height, gpointer func_info)
{
  if (!Xen_is_list((Xen)func_info)) return;
  Xen_call_with_5_args(Xen_car((Xen)func_info),
             C_to_Xen_GtkDrawingArea_(self),
             C_to_Xen_cairo_t_(cr),
             C_to_Xen_int(width),
             C_to_Xen_int(height),
             Xen_cadr((Xen)func_info),
             __func__);
}
#endif


static gboolean gxg_func3(GtkWidget *w, GdkEvent *ev, gpointer data)
{
  return(Xen_boolean_to_C_bool(Xen_call_with_3_args(Xen_car((Xen)data),
                                     C_to_Xen_GtkWidget_(w),
                                     C_to_Xen_GdkEvent_(ev),
                                     Xen_cadr((Xen)data),
                                     __func__)));
}

static gboolean gxg_func4(GtkPrintOperation *op, GtkPrintContext *context, gint page_nr, gpointer data)
{
  return(Xen_boolean_to_C_bool(Xen_call_with_4_args(Xen_car((Xen)data),
                                     C_to_Xen_GtkPrintOperation_(op),
                                     C_to_Xen_GtkPrintContext_(context),
                                     C_int_to_Xen_integer(page_nr),
                                     Xen_cadr((Xen)data),
                                     __func__)));
}

#if (!GTK_CHECK_VERSION(3, 90, 0))
static Xen gxg_gtk_widget_set_events(Xen widget, Xen events)
{
  #define H_gtk_widget_set_events "void gtk_widget_set_events(GtkWidget* widget, gint events)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_set_events", "GtkWidget*");
  Xen_check_type(Xen_is_gint(events), events, 2, "gtk_widget_set_events", "gint");
  gtk_widget_set_events(Xen_to_C_GtkWidget_(widget), Xen_to_C_gint(events));
  return(Xen_false);
}
#endif



/* ---------------------------------------- functions ---------------------------------------- */

static Xen gxg_g_unichar_validate(Xen ch)
{
  #define H_g_unichar_validate "gboolean g_unichar_validate(gunichar ch)"
  Xen_check_type(Xen_is_gunichar(ch), ch, 1, "g_unichar_validate", "gunichar");
  return(C_to_Xen_gboolean(g_unichar_validate(Xen_to_C_gunichar(ch))));
}

static Xen gxg_g_unichar_isalnum(Xen c)
{
  #define H_g_unichar_isalnum "gboolean g_unichar_isalnum(gunichar c)"
  Xen_check_type(Xen_is_gunichar(c), c, 1, "g_unichar_isalnum", "gunichar");
  return(C_to_Xen_gboolean(g_unichar_isalnum(Xen_to_C_gunichar(c))));
}

static Xen gxg_g_unichar_isalpha(Xen c)
{
  #define H_g_unichar_isalpha "gboolean g_unichar_isalpha(gunichar c)"
  Xen_check_type(Xen_is_gunichar(c), c, 1, "g_unichar_isalpha", "gunichar");
  return(C_to_Xen_gboolean(g_unichar_isalpha(Xen_to_C_gunichar(c))));
}

static Xen gxg_g_unichar_iscntrl(Xen c)
{
  #define H_g_unichar_iscntrl "gboolean g_unichar_iscntrl(gunichar c)"
  Xen_check_type(Xen_is_gunichar(c), c, 1, "g_unichar_iscntrl", "gunichar");
  return(C_to_Xen_gboolean(g_unichar_iscntrl(Xen_to_C_gunichar(c))));
}

static Xen gxg_g_unichar_isdefined(Xen c)
{
  #define H_g_unichar_isdefined "gboolean g_unichar_isdefined(gunichar c)"
  Xen_check_type(Xen_is_gunichar(c), c, 1, "g_unichar_isdefined", "gunichar");
  return(C_to_Xen_gboolean(g_unichar_isdefined(Xen_to_C_gunichar(c))));
}

static Xen gxg_g_unichar_isdigit(Xen c)
{
  #define H_g_unichar_isdigit "gboolean g_unichar_isdigit(gunichar c)"
  Xen_check_type(Xen_is_gunichar(c), c, 1, "g_unichar_isdigit", "gunichar");
  return(C_to_Xen_gboolean(g_unichar_isdigit(Xen_to_C_gunichar(c))));
}

static Xen gxg_g_unichar_isgraph(Xen c)
{
  #define H_g_unichar_isgraph "gboolean g_unichar_isgraph(gunichar c)"
  Xen_check_type(Xen_is_gunichar(c), c, 1, "g_unichar_isgraph", "gunichar");
  return(C_to_Xen_gboolean(g_unichar_isgraph(Xen_to_C_gunichar(c))));
}

static Xen gxg_g_unichar_islower(Xen c)
{
  #define H_g_unichar_islower "gboolean g_unichar_islower(gunichar c)"
  Xen_check_type(Xen_is_gunichar(c), c, 1, "g_unichar_islower", "gunichar");
  return(C_to_Xen_gboolean(g_unichar_islower(Xen_to_C_gunichar(c))));
}

static Xen gxg_g_unichar_ismark(Xen c)
{
  #define H_g_unichar_ismark "gboolean g_unichar_ismark(gunichar c)"
  Xen_check_type(Xen_is_gunichar(c), c, 1, "g_unichar_ismark", "gunichar");
  return(C_to_Xen_gboolean(g_unichar_ismark(Xen_to_C_gunichar(c))));
}

static Xen gxg_g_unichar_isprint(Xen c)
{
  #define H_g_unichar_isprint "gboolean g_unichar_isprint(gunichar c)"
  Xen_check_type(Xen_is_gunichar(c), c, 1, "g_unichar_isprint", "gunichar");
  return(C_to_Xen_gboolean(g_unichar_isprint(Xen_to_C_gunichar(c))));
}

static Xen gxg_g_unichar_ispunct(Xen c)
{
  #define H_g_unichar_ispunct "gboolean g_unichar_ispunct(gunichar c)"
  Xen_check_type(Xen_is_gunichar(c), c, 1, "g_unichar_ispunct", "gunichar");
  return(C_to_Xen_gboolean(g_unichar_ispunct(Xen_to_C_gunichar(c))));
}

static Xen gxg_g_unichar_isspace(Xen c)
{
  #define H_g_unichar_isspace "gboolean g_unichar_isspace(gunichar c)"
  Xen_check_type(Xen_is_gunichar(c), c, 1, "g_unichar_isspace", "gunichar");
  return(C_to_Xen_gboolean(g_unichar_isspace(Xen_to_C_gunichar(c))));
}

static Xen gxg_g_unichar_istitle(Xen c)
{
  #define H_g_unichar_istitle "gboolean g_unichar_istitle(gunichar c)"
  Xen_check_type(Xen_is_gunichar(c), c, 1, "g_unichar_istitle", "gunichar");
  return(C_to_Xen_gboolean(g_unichar_istitle(Xen_to_C_gunichar(c))));
}

static Xen gxg_g_unichar_isupper(Xen c)
{
  #define H_g_unichar_isupper "gboolean g_unichar_isupper(gunichar c)"
  Xen_check_type(Xen_is_gunichar(c), c, 1, "g_unichar_isupper", "gunichar");
  return(C_to_Xen_gboolean(g_unichar_isupper(Xen_to_C_gunichar(c))));
}

static Xen gxg_g_unichar_isxdigit(Xen c)
{
  #define H_g_unichar_isxdigit "gboolean g_unichar_isxdigit(gunichar c)"
  Xen_check_type(Xen_is_gunichar(c), c, 1, "g_unichar_isxdigit", "gunichar");
  return(C_to_Xen_gboolean(g_unichar_isxdigit(Xen_to_C_gunichar(c))));
}

static Xen gxg_g_unichar_iswide(Xen c)
{
  #define H_g_unichar_iswide "gboolean g_unichar_iswide(gunichar c)"
  Xen_check_type(Xen_is_gunichar(c), c, 1, "g_unichar_iswide", "gunichar");
  return(C_to_Xen_gboolean(g_unichar_iswide(Xen_to_C_gunichar(c))));
}

static Xen gxg_g_unichar_iswide_cjk(Xen c)
{
  #define H_g_unichar_iswide_cjk "gboolean g_unichar_iswide_cjk(gunichar c)"
  Xen_check_type(Xen_is_gunichar(c), c, 1, "g_unichar_iswide_cjk", "gunichar");
  return(C_to_Xen_gboolean(g_unichar_iswide_cjk(Xen_to_C_gunichar(c))));
}

static Xen gxg_g_unichar_iszerowidth(Xen c)
{
  #define H_g_unichar_iszerowidth "gboolean g_unichar_iszerowidth(gunichar c)"
  Xen_check_type(Xen_is_gunichar(c), c, 1, "g_unichar_iszerowidth", "gunichar");
  return(C_to_Xen_gboolean(g_unichar_iszerowidth(Xen_to_C_gunichar(c))));
}

static Xen gxg_g_unichar_toupper(Xen c)
{
  #define H_g_unichar_toupper "gunichar g_unichar_toupper(gunichar c)"
  Xen_check_type(Xen_is_gunichar(c), c, 1, "g_unichar_toupper", "gunichar");
  return(C_to_Xen_gunichar(g_unichar_toupper(Xen_to_C_gunichar(c))));
}

static Xen gxg_g_unichar_tolower(Xen c)
{
  #define H_g_unichar_tolower "gunichar g_unichar_tolower(gunichar c)"
  Xen_check_type(Xen_is_gunichar(c), c, 1, "g_unichar_tolower", "gunichar");
  return(C_to_Xen_gunichar(g_unichar_tolower(Xen_to_C_gunichar(c))));
}

static Xen gxg_g_unichar_totitle(Xen c)
{
  #define H_g_unichar_totitle "gunichar g_unichar_totitle(gunichar c)"
  Xen_check_type(Xen_is_gunichar(c), c, 1, "g_unichar_totitle", "gunichar");
  return(C_to_Xen_gunichar(g_unichar_totitle(Xen_to_C_gunichar(c))));
}

static Xen gxg_g_unichar_digit_value(Xen c)
{
  #define H_g_unichar_digit_value "gint g_unichar_digit_value(gunichar c)"
  Xen_check_type(Xen_is_gunichar(c), c, 1, "g_unichar_digit_value", "gunichar");
  return(C_to_Xen_gint(g_unichar_digit_value(Xen_to_C_gunichar(c))));
}

static Xen gxg_g_unichar_xdigit_value(Xen c)
{
  #define H_g_unichar_xdigit_value "gint g_unichar_xdigit_value(gunichar c)"
  Xen_check_type(Xen_is_gunichar(c), c, 1, "g_unichar_xdigit_value", "gunichar");
  return(C_to_Xen_gint(g_unichar_xdigit_value(Xen_to_C_gunichar(c))));
}

static Xen gxg_g_unichar_combining_class(Xen uc)
{
  #define H_g_unichar_combining_class "gint g_unichar_combining_class(gunichar uc)"
  Xen_check_type(Xen_is_gunichar(uc), uc, 1, "g_unichar_combining_class", "gunichar");
  return(C_to_Xen_gint(g_unichar_combining_class(Xen_to_C_gunichar(uc))));
}

static Xen gxg_g_unicode_canonical_ordering(Xen string, Xen len)
{
  #define H_g_unicode_canonical_ordering "void g_unicode_canonical_ordering(gunichar* string, gsize len)"
  Xen_check_type(Xen_is_gunichar_(string), string, 1, "g_unicode_canonical_ordering", "gunichar*");
  Xen_check_type(Xen_is_gsize(len), len, 2, "g_unicode_canonical_ordering", "gsize");
  g_unicode_canonical_ordering(Xen_to_C_gunichar_(string), Xen_to_C_gsize(len));
  return(Xen_false);
}

static Xen gxg_g_utf8_get_char(Xen p)
{
  #define H_g_utf8_get_char "gunichar g_utf8_get_char(gchar* p)"
  Xen_check_type(Xen_is_gchar_(p), p, 1, "g_utf8_get_char", "gchar*");
  return(C_to_Xen_gunichar(g_utf8_get_char((const gchar*)Xen_to_C_gchar_(p))));
}

static Xen gxg_g_utf8_get_char_validated(Xen p, Xen max_len)
{
  #define H_g_utf8_get_char_validated "gunichar g_utf8_get_char_validated(gchar* p, gssize max_len)"
  Xen_check_type(Xen_is_gchar_(p), p, 1, "g_utf8_get_char_validated", "gchar*");
  Xen_check_type(Xen_is_gssize(max_len), max_len, 2, "g_utf8_get_char_validated", "gssize");
  return(C_to_Xen_gunichar(g_utf8_get_char_validated((const gchar*)Xen_to_C_gchar_(p), Xen_to_C_gssize(max_len))));
}

static Xen gxg_g_utf8_prev_char(Xen p)
{
  #define H_g_utf8_prev_char "gchar* g_utf8_prev_char(gchar* p)"
  Xen_check_type(Xen_is_gchar_(p), p, 1, "g_utf8_prev_char", "gchar*");
  return(C_to_Xen_gchar_(g_utf8_prev_char((const gchar*)Xen_to_C_gchar_(p))));
}

static Xen gxg_g_utf8_find_next_char(Xen p, Xen end)
{
  #define H_g_utf8_find_next_char "gchar* g_utf8_find_next_char(gchar* p, gchar* end)"
  Xen_check_type(Xen_is_gchar_(p), p, 1, "g_utf8_find_next_char", "gchar*");
  Xen_check_type(Xen_is_gchar_(end), end, 2, "g_utf8_find_next_char", "gchar*");
  return(C_to_Xen_gchar_(g_utf8_find_next_char((const gchar*)Xen_to_C_gchar_(p), (const gchar*)Xen_to_C_gchar_(end))));
}

static Xen gxg_g_utf8_find_prev_char(Xen str, Xen p)
{
  #define H_g_utf8_find_prev_char "gchar* g_utf8_find_prev_char(gchar* str, gchar* p)"
  Xen_check_type(Xen_is_gchar_(str), str, 1, "g_utf8_find_prev_char", "gchar*");
  Xen_check_type(Xen_is_gchar_(p), p, 2, "g_utf8_find_prev_char", "gchar*");
  return(C_to_Xen_gchar_(g_utf8_find_prev_char((const gchar*)Xen_to_C_gchar_(str), (const gchar*)Xen_to_C_gchar_(p))));
}

static Xen gxg_g_utf8_strlen(Xen p, Xen max)
{
  #define H_g_utf8_strlen "glong g_utf8_strlen(gchar* p, gssize max)"
  Xen_check_type(Xen_is_gchar_(p), p, 1, "g_utf8_strlen", "gchar*");
  Xen_check_type(Xen_is_gssize(max), max, 2, "g_utf8_strlen", "gssize");
  return(C_to_Xen_glong(g_utf8_strlen((const gchar*)Xen_to_C_gchar_(p), Xen_to_C_gssize(max))));
}

static Xen gxg_g_utf8_strchr(Xen p, Xen len, Xen c)
{
  #define H_g_utf8_strchr "gchar* g_utf8_strchr(gchar* p, gssize len, gunichar c)"
  Xen_check_type(Xen_is_gchar_(p), p, 1, "g_utf8_strchr", "gchar*");
  Xen_check_type(Xen_is_gssize(len), len, 2, "g_utf8_strchr", "gssize");
  Xen_check_type(Xen_is_gunichar(c), c, 3, "g_utf8_strchr", "gunichar");
  return(C_to_Xen_gchar_(g_utf8_strchr((const gchar*)Xen_to_C_gchar_(p), Xen_to_C_gssize(len), Xen_to_C_gunichar(c))));
}

static Xen gxg_g_utf8_strrchr(Xen p, Xen len, Xen c)
{
  #define H_g_utf8_strrchr "gchar* g_utf8_strrchr(gchar* p, gssize len, gunichar c)"
  Xen_check_type(Xen_is_gchar_(p), p, 1, "g_utf8_strrchr", "gchar*");
  Xen_check_type(Xen_is_gssize(len), len, 2, "g_utf8_strrchr", "gssize");
  Xen_check_type(Xen_is_gunichar(c), c, 3, "g_utf8_strrchr", "gunichar");
  return(C_to_Xen_gchar_(g_utf8_strrchr((const gchar*)Xen_to_C_gchar_(p), Xen_to_C_gssize(len), Xen_to_C_gunichar(c))));
}

static Xen gxg_g_utf8_strreverse(Xen str, Xen len)
{
  #define H_g_utf8_strreverse "gchar* g_utf8_strreverse(gchar* str, gssize len)"
  Xen_check_type(Xen_is_gchar_(str), str, 1, "g_utf8_strreverse", "gchar*");
  Xen_check_type(Xen_is_gssize(len), len, 2, "g_utf8_strreverse", "gssize");
  return(C_to_Xen_gchar_(g_utf8_strreverse((const gchar*)Xen_to_C_gchar_(str), Xen_to_C_gssize(len))));
}

static Xen gxg_g_utf8_validate(Xen str, Xen max_len, Xen ignore_end)
{
  #define H_g_utf8_validate "gboolean g_utf8_validate(gchar* str, gssize max_len, gchar** [end])"
  gchar* ref_end = NULL;
  Xen_check_type(Xen_is_gchar_(str), str, 1, "g_utf8_validate", "gchar*");
  Xen_check_type(Xen_is_gssize(max_len), max_len, 2, "g_utf8_validate", "gssize");
  {
    Xen res_ult;
    res_ult = C_to_Xen_gboolean(g_utf8_validate((const gchar*)Xen_to_C_gchar_(str), Xen_to_C_gssize(max_len), (const gchar**)&ref_end));
    return(Xen_list_2(res_ult, C_to_Xen_gchar_(ref_end)));
   }
}

static Xen gxg_g_utf8_strup(Xen str, Xen len)
{
  #define H_g_utf8_strup "gchar* g_utf8_strup(gchar* str, gssize len)"
  Xen_check_type(Xen_is_gchar_(str), str, 1, "g_utf8_strup", "gchar*");
  Xen_check_type(Xen_is_gssize(len), len, 2, "g_utf8_strup", "gssize");
  return(C_to_Xen_gchar_(g_utf8_strup((const gchar*)Xen_to_C_gchar_(str), Xen_to_C_gssize(len))));
}

static Xen gxg_g_utf8_strdown(Xen str, Xen len)
{
  #define H_g_utf8_strdown "gchar* g_utf8_strdown(gchar* str, gssize len)"
  Xen_check_type(Xen_is_gchar_(str), str, 1, "g_utf8_strdown", "gchar*");
  Xen_check_type(Xen_is_gssize(len), len, 2, "g_utf8_strdown", "gssize");
  return(C_to_Xen_gchar_(g_utf8_strdown((const gchar*)Xen_to_C_gchar_(str), Xen_to_C_gssize(len))));
}

static Xen gxg_g_utf8_casefold(Xen str, Xen len)
{
  #define H_g_utf8_casefold "gchar* g_utf8_casefold(gchar* str, gssize len)"
  Xen_check_type(Xen_is_gchar_(str), str, 1, "g_utf8_casefold", "gchar*");
  Xen_check_type(Xen_is_gssize(len), len, 2, "g_utf8_casefold", "gssize");
  return(C_to_Xen_gchar_(g_utf8_casefold((const gchar*)Xen_to_C_gchar_(str), Xen_to_C_gssize(len))));
}

static Xen gxg_g_utf8_normalize(Xen str, Xen len, Xen mode)
{
  #define H_g_utf8_normalize "gchar* g_utf8_normalize(gchar* str, gssize len, GNormalizeMode mode)"
  Xen_check_type(Xen_is_gchar_(str), str, 1, "g_utf8_normalize", "gchar*");
  Xen_check_type(Xen_is_gssize(len), len, 2, "g_utf8_normalize", "gssize");
  Xen_check_type(Xen_is_GNormalizeMode(mode), mode, 3, "g_utf8_normalize", "GNormalizeMode");
  return(C_to_Xen_gchar_(g_utf8_normalize((const gchar*)Xen_to_C_gchar_(str), Xen_to_C_gssize(len), Xen_to_C_GNormalizeMode(mode))));
}

static Xen gxg_g_utf8_collate(Xen str1, Xen str2)
{
  #define H_g_utf8_collate "gint g_utf8_collate(gchar* str1, gchar* str2)"
  Xen_check_type(Xen_is_gchar_(str1), str1, 1, "g_utf8_collate", "gchar*");
  Xen_check_type(Xen_is_gchar_(str2), str2, 2, "g_utf8_collate", "gchar*");
  return(C_to_Xen_gint(g_utf8_collate((const gchar*)Xen_to_C_gchar_(str1), (const gchar*)Xen_to_C_gchar_(str2))));
}

static Xen gxg_g_utf8_collate_key(Xen str, Xen len)
{
  #define H_g_utf8_collate_key "gchar* g_utf8_collate_key(gchar* str, gssize len)"
  Xen_check_type(Xen_is_gchar_(str), str, 1, "g_utf8_collate_key", "gchar*");
  Xen_check_type(Xen_is_gssize(len), len, 2, "g_utf8_collate_key", "gssize");
  return(C_to_Xen_gchar_(g_utf8_collate_key((const gchar*)Xen_to_C_gchar_(str), Xen_to_C_gssize(len))));
}

static Xen gxg_g_utf8_collate_key_for_filename(Xen str, Xen len)
{
  #define H_g_utf8_collate_key_for_filename "gchar* g_utf8_collate_key_for_filename(gchar* str, gssize len)"
  Xen_check_type(Xen_is_gchar_(str), str, 1, "g_utf8_collate_key_for_filename", "gchar*");
  Xen_check_type(Xen_is_gssize(len), len, 2, "g_utf8_collate_key_for_filename", "gssize");
  return(C_to_Xen_gchar_(g_utf8_collate_key_for_filename((const gchar*)Xen_to_C_gchar_(str), Xen_to_C_gssize(len))));
}

static Xen gxg_g_cclosure_new(Xen func, Xen func_info, Xen destroy_data)
{
  #define H_g_cclosure_new "GClosure* g_cclosure_new(GCallback func, lambda_data func_info, GClosureNotify destroy_data)"
  Xen_check_type(Xen_is_GCallback(func), func, 1, "g_cclosure_new", "GCallback");
  Xen_check_type(Xen_is_lambda_data(func_info) || Xen_is_false(func_info), func_info, 2, "g_cclosure_new", "lambda_data");
  Xen_check_type(Xen_is_GClosureNotify(destroy_data) || Xen_is_false(destroy_data), destroy_data, 3, "g_cclosure_new", "GClosureNotify");
  {
    Xen res_ult;
    int loc;
    Xen gxg_ptr = Xen_list_5(func, func_info, Xen_false, Xen_false, Xen_false);
    loc = xm_protect(gxg_ptr);
    Xen_list_set(gxg_ptr, 2, C_int_to_Xen_integer(loc));
    res_ult = C_to_Xen_GClosure_(g_cclosure_new(Xen_to_C_GCallback(func), Xen_to_C_lambda_data(func_info), Xen_to_C_GClosureNotify(destroy_data)));
    return(res_ult);
   }
}

static Xen gxg_g_signal_newv(Xen arglist)
{
  #define H_g_signal_newv "guint g_signal_newv(gchar* signal_name, GType itype, GSignalFlags signal_flags, \
GClosure* class_closure, GSignalAccumulator accumulator, gpointer accu_data, GSignalCMarshaller c_marshaller, \
GType return_type, guint n_params, GType* param_types)"
  Xen signal_name, itype, signal_flags, class_closure, accumulator, accu_data, c_marshaller, return_type, n_params, param_types;
  signal_name = Xen_list_ref(arglist, 0);
  itype = Xen_list_ref(arglist, 1);
  signal_flags = Xen_list_ref(arglist, 2);
  class_closure = Xen_list_ref(arglist, 3);
  accumulator = Xen_list_ref(arglist, 4);
  accu_data = Xen_list_ref(arglist, 5);
  c_marshaller = Xen_list_ref(arglist, 6);
  return_type = Xen_list_ref(arglist, 7);
  n_params = Xen_list_ref(arglist, 8);
  param_types = Xen_list_ref(arglist, 9);
  Xen_check_type(Xen_is_gchar_(signal_name), signal_name, 1, "g_signal_newv", "gchar*");
  Xen_check_type(Xen_is_GType(itype), itype, 2, "g_signal_newv", "GType");
  Xen_check_type(Xen_is_GSignalFlags(signal_flags), signal_flags, 3, "g_signal_newv", "GSignalFlags");
  Xen_check_type(Xen_is_GClosure_(class_closure) || Xen_is_false(class_closure), class_closure, 4, "g_signal_newv", "GClosure*");
  Xen_check_type(Xen_is_GSignalAccumulator(accumulator), accumulator, 5, "g_signal_newv", "GSignalAccumulator");
  Xen_check_type(Xen_is_gpointer(accu_data), accu_data, 6, "g_signal_newv", "gpointer");
  Xen_check_type(Xen_is_GSignalCMarshaller(c_marshaller), c_marshaller, 7, "g_signal_newv", "GSignalCMarshaller");
  Xen_check_type(Xen_is_GType(return_type), return_type, 8, "g_signal_newv", "GType");
  Xen_check_type(Xen_is_guint(n_params), n_params, 9, "g_signal_newv", "guint");
  Xen_check_type(Xen_is_GType_(param_types), param_types, 10, "g_signal_newv", "GType*");
  return(C_to_Xen_guint(g_signal_newv(Xen_to_C_gchar_(signal_name), Xen_to_C_GType(itype), Xen_to_C_GSignalFlags(signal_flags), 
                                      Xen_to_C_GClosure_(class_closure), Xen_to_C_GSignalAccumulator(accumulator), Xen_to_C_gpointer(accu_data), 
                                      Xen_to_C_GSignalCMarshaller(c_marshaller), Xen_to_C_GType(return_type), Xen_to_C_guint(n_params), 
                                      Xen_to_C_GType_(param_types))));
}

static Xen gxg_g_signal_lookup(Xen name, Xen itype)
{
  #define H_g_signal_lookup "guint g_signal_lookup(gchar* name, GType itype)"
  Xen_check_type(Xen_is_gchar_(name), name, 1, "g_signal_lookup", "gchar*");
  Xen_check_type(Xen_is_GType(itype), itype, 2, "g_signal_lookup", "GType");
  return(C_to_Xen_guint(g_signal_lookup(Xen_to_C_gchar_(name), Xen_to_C_GType(itype))));
}

static Xen gxg_g_signal_name(Xen signal_id)
{
  #define H_g_signal_name "gchar* g_signal_name(guint signal_id)"
  Xen_check_type(Xen_is_guint(signal_id), signal_id, 1, "g_signal_name", "guint");
  return(C_to_Xen_gchar_(g_signal_name(Xen_to_C_guint(signal_id))));
}

static Xen gxg_g_signal_query(Xen signal_id, Xen query)
{
  #define H_g_signal_query "void g_signal_query(guint signal_id, GSignalQuery* query)"
  Xen_check_type(Xen_is_guint(signal_id), signal_id, 1, "g_signal_query", "guint");
  Xen_check_type(Xen_is_GSignalQuery_(query), query, 2, "g_signal_query", "GSignalQuery*");
  g_signal_query(Xen_to_C_guint(signal_id), Xen_to_C_GSignalQuery_(query));
  return(Xen_false);
}

static Xen gxg_g_signal_list_ids(Xen itype, Xen n_ids)
{
  #define H_g_signal_list_ids "guint* g_signal_list_ids(GType itype, guint* n_ids)"
  Xen_check_type(Xen_is_GType(itype), itype, 1, "g_signal_list_ids", "GType");
  Xen_check_type(Xen_is_guint_(n_ids), n_ids, 2, "g_signal_list_ids", "guint*");
  return(C_to_Xen_guint_(g_signal_list_ids(Xen_to_C_GType(itype), Xen_to_C_guint_(n_ids))));
}

static Xen gxg_g_signal_parse_name(Xen detailed_signal, Xen itype, Xen ignore_signal_id_p, Xen ignore_detail_p, Xen force_detail_quark)
{
  #define H_g_signal_parse_name "gboolean g_signal_parse_name(gchar* detailed_signal, GType itype, guint* [signal_id_p], \
GQuark* [detail_p], gboolean force_detail_quark)"
  guint ref_signal_id_p;
  GQuark ref_detail_p;
  Xen_check_type(Xen_is_gchar_(detailed_signal), detailed_signal, 1, "g_signal_parse_name", "gchar*");
  Xen_check_type(Xen_is_GType(itype), itype, 2, "g_signal_parse_name", "GType");
  Xen_check_type(Xen_is_gboolean(force_detail_quark), force_detail_quark, 5, "g_signal_parse_name", "gboolean");
  {
    Xen res_ult;
    res_ult = C_to_Xen_gboolean(g_signal_parse_name(Xen_to_C_gchar_(detailed_signal), Xen_to_C_GType(itype), &ref_signal_id_p, 
                                                    &ref_detail_p, Xen_to_C_gboolean(force_detail_quark)));
    return(Xen_list_3(res_ult, C_to_Xen_guint(ref_signal_id_p), C_to_Xen_GQuark(ref_detail_p)));
   }
}

static Xen gxg_g_signal_get_invocation_hint(Xen instance)
{
  #define H_g_signal_get_invocation_hint "GSignalInvocationHint* g_signal_get_invocation_hint(gpointer instance)"
  Xen_check_type(Xen_is_gpointer(instance), instance, 1, "g_signal_get_invocation_hint", "gpointer");
  return(C_to_Xen_GSignalInvocationHint_(g_signal_get_invocation_hint(Xen_to_C_gpointer(instance))));
}

static Xen gxg_g_signal_stop_emission(Xen instance, Xen signal_id, Xen detail)
{
  #define H_g_signal_stop_emission "void g_signal_stop_emission(gpointer instance, guint signal_id, GQuark detail)"
  Xen_check_type(Xen_is_gpointer(instance), instance, 1, "g_signal_stop_emission", "gpointer");
  Xen_check_type(Xen_is_guint(signal_id), signal_id, 2, "g_signal_stop_emission", "guint");
  Xen_check_type(Xen_is_GQuark(detail), detail, 3, "g_signal_stop_emission", "GQuark");
  g_signal_stop_emission(Xen_to_C_gpointer(instance), Xen_to_C_guint(signal_id), Xen_to_C_GQuark(detail));
  return(Xen_false);
}

static Xen gxg_g_signal_stop_emission_by_name(Xen instance, Xen detailed_signal)
{
  #define H_g_signal_stop_emission_by_name "void g_signal_stop_emission_by_name(gpointer instance, gchar* detailed_signal)"
  Xen_check_type(Xen_is_gpointer(instance), instance, 1, "g_signal_stop_emission_by_name", "gpointer");
  Xen_check_type(Xen_is_gchar_(detailed_signal), detailed_signal, 2, "g_signal_stop_emission_by_name", "gchar*");
  g_signal_stop_emission_by_name(Xen_to_C_gpointer(instance), Xen_to_C_gchar_(detailed_signal));
  return(Xen_false);
}

static Xen gxg_g_signal_add_emission_hook(Xen signal_id, Xen quark, Xen hook_func, Xen func_info, Xen data_destroy)
{
  #define H_g_signal_add_emission_hook "gulong g_signal_add_emission_hook(guint signal_id, GQuark quark, \
GSignalEmissionHook hook_func, lambda_data func_info, GtkDestroyNotify data_destroy)"
  Xen_check_type(Xen_is_guint(signal_id), signal_id, 1, "g_signal_add_emission_hook", "guint");
  Xen_check_type(Xen_is_GQuark(quark), quark, 2, "g_signal_add_emission_hook", "GQuark");
  Xen_check_type(Xen_is_GSignalEmissionHook(hook_func), hook_func, 3, "g_signal_add_emission_hook", "GSignalEmissionHook");
  Xen_check_type(Xen_is_lambda_data(func_info) || Xen_is_false(func_info), func_info, 4, "g_signal_add_emission_hook", "lambda_data");
  Xen_check_type(Xen_is_GtkDestroyNotify(data_destroy), data_destroy, 5, "g_signal_add_emission_hook", "GtkDestroyNotify");
  {
    Xen res_ult;
    Xen gxg_ptr = Xen_list_5(Xen_false, func_info, Xen_false, Xen_false, Xen_false);
    xm_protect(gxg_ptr);
    Xen_list_set(gxg_ptr, 3, data_destroy);
    res_ult = C_to_Xen_gulong(g_signal_add_emission_hook(Xen_to_C_guint(signal_id), Xen_to_C_GQuark(quark), Xen_to_C_GSignalEmissionHook(hook_func), 
                                                         Xen_to_C_lambda_data(func_info), Xen_to_C_GtkDestroyNotify(data_destroy)));
    return(res_ult);
   }
}

static Xen gxg_g_signal_remove_emission_hook(Xen signal_id, Xen hook_id)
{
  #define H_g_signal_remove_emission_hook "void g_signal_remove_emission_hook(guint signal_id, gulong hook_id)"
  Xen_check_type(Xen_is_guint(signal_id), signal_id, 1, "g_signal_remove_emission_hook", "guint");
  Xen_check_type(Xen_is_gulong(hook_id), hook_id, 2, "g_signal_remove_emission_hook", "gulong");
  g_signal_remove_emission_hook(Xen_to_C_guint(signal_id), Xen_to_C_gulong(hook_id));
  return(Xen_false);
}

static Xen gxg_g_signal_has_handler_pending(Xen instance, Xen signal_id, Xen detail, Xen may_be_blocked)
{
  #define H_g_signal_has_handler_pending "gboolean g_signal_has_handler_pending(gpointer instance, guint signal_id, \
GQuark detail, gboolean may_be_blocked)"
  Xen_check_type(Xen_is_gpointer(instance), instance, 1, "g_signal_has_handler_pending", "gpointer");
  Xen_check_type(Xen_is_guint(signal_id), signal_id, 2, "g_signal_has_handler_pending", "guint");
  Xen_check_type(Xen_is_GQuark(detail), detail, 3, "g_signal_has_handler_pending", "GQuark");
  Xen_check_type(Xen_is_gboolean(may_be_blocked), may_be_blocked, 4, "g_signal_has_handler_pending", "gboolean");
  return(C_to_Xen_gboolean(g_signal_has_handler_pending(Xen_to_C_gpointer(instance), Xen_to_C_guint(signal_id), Xen_to_C_GQuark(detail), 
                                                        Xen_to_C_gboolean(may_be_blocked))));
}

static Xen gxg_g_signal_connect_closure_by_id(Xen instance, Xen signal_id, Xen detail, Xen closure, Xen after)
{
  #define H_g_signal_connect_closure_by_id "gulong g_signal_connect_closure_by_id(gpointer instance, \
guint signal_id, GQuark detail, GClosure* closure, gboolean after)"
  Xen_check_type(Xen_is_gpointer(instance), instance, 1, "g_signal_connect_closure_by_id", "gpointer");
  Xen_check_type(Xen_is_guint(signal_id), signal_id, 2, "g_signal_connect_closure_by_id", "guint");
  Xen_check_type(Xen_is_GQuark(detail), detail, 3, "g_signal_connect_closure_by_id", "GQuark");
  Xen_check_type(Xen_is_GClosure_(closure) || Xen_is_false(closure), closure, 4, "g_signal_connect_closure_by_id", "GClosure*");
  Xen_check_type(Xen_is_gboolean(after), after, 5, "g_signal_connect_closure_by_id", "gboolean");
  return(C_to_Xen_gulong(g_signal_connect_closure_by_id(Xen_to_C_gpointer(instance), Xen_to_C_guint(signal_id), Xen_to_C_GQuark(detail), 
                                                        Xen_to_C_GClosure_(closure), Xen_to_C_gboolean(after))));
}

static Xen gxg_g_signal_connect_closure(Xen instance, Xen detailed_signal, Xen closure, Xen after)
{
  #define H_g_signal_connect_closure "gulong g_signal_connect_closure(gpointer instance, gchar* detailed_signal, \
GClosure* closure, gboolean after)"
  Xen_check_type(Xen_is_gpointer(instance), instance, 1, "g_signal_connect_closure", "gpointer");
  Xen_check_type(Xen_is_gchar_(detailed_signal), detailed_signal, 2, "g_signal_connect_closure", "gchar*");
  Xen_check_type(Xen_is_GClosure_(closure) || Xen_is_false(closure), closure, 3, "g_signal_connect_closure", "GClosure*");
  Xen_check_type(Xen_is_gboolean(after), after, 4, "g_signal_connect_closure", "gboolean");
  return(C_to_Xen_gulong(g_signal_connect_closure(Xen_to_C_gpointer(instance), Xen_to_C_gchar_(detailed_signal), Xen_to_C_GClosure_(closure), 
                                                  Xen_to_C_gboolean(after))));
}

static Xen gxg_g_signal_connect_data(Xen instance, Xen detailed_signal, Xen func, Xen func_info, Xen destroy_data, Xen connect_flags)
{
  #define H_g_signal_connect_data "gulong g_signal_connect_data(gpointer instance, gchar* detailed_signal, \
GCallback func, lambda_data func_info, GClosureNotify destroy_data, GConnectFlags connect_flags)"
  Xen_check_type(Xen_is_gpointer(instance), instance, 1, "g_signal_connect_data", "gpointer");
  Xen_check_type(Xen_is_gchar_(detailed_signal), detailed_signal, 2, "g_signal_connect_data", "gchar*");
  Xen_check_type(Xen_is_GCallback(func), func, 3, "g_signal_connect_data", "GCallback");
  Xen_check_type(Xen_is_lambda_data(func_info) || Xen_is_false(func_info), func_info, 4, "g_signal_connect_data", "lambda_data");
  Xen_check_type(Xen_is_GClosureNotify(destroy_data) || Xen_is_false(destroy_data), destroy_data, 5, "g_signal_connect_data", "GClosureNotify");
  Xen_check_type(Xen_is_GConnectFlags(connect_flags), connect_flags, 6, "g_signal_connect_data", "GConnectFlags");
  {
    Xen res_ult;
    int loc;
    Xen gxg_ptr = Xen_list_5(func, func_info, Xen_false, Xen_false, Xen_false);
    loc = xm_protect(gxg_ptr);
    Xen_list_set(gxg_ptr, 2, C_int_to_Xen_integer(loc));
    res_ult = C_to_Xen_gulong(g_signal_connect_data(Xen_to_C_gpointer(instance), Xen_to_C_gchar_(detailed_signal), Xen_to_C_GCallback(func), 
                                                    Xen_to_C_lambda_data(func_info), Xen_to_C_GClosureNotify(destroy_data), 
                                                    Xen_to_C_GConnectFlags(connect_flags)));
    return(res_ult);
   }
}

static Xen gxg_g_signal_handler_block(Xen instance, Xen handler_id)
{
  #define H_g_signal_handler_block "void g_signal_handler_block(gpointer instance, gulong handler_id)"
  Xen_check_type(Xen_is_gpointer(instance), instance, 1, "g_signal_handler_block", "gpointer");
  Xen_check_type(Xen_is_gulong(handler_id), handler_id, 2, "g_signal_handler_block", "gulong");
  g_signal_handler_block(Xen_to_C_gpointer(instance), Xen_to_C_gulong(handler_id));
  return(Xen_false);
}

static Xen gxg_g_signal_handler_unblock(Xen instance, Xen handler_id)
{
  #define H_g_signal_handler_unblock "void g_signal_handler_unblock(gpointer instance, gulong handler_id)"
  Xen_check_type(Xen_is_gpointer(instance), instance, 1, "g_signal_handler_unblock", "gpointer");
  Xen_check_type(Xen_is_gulong(handler_id), handler_id, 2, "g_signal_handler_unblock", "gulong");
  g_signal_handler_unblock(Xen_to_C_gpointer(instance), Xen_to_C_gulong(handler_id));
  return(Xen_false);
}

static Xen gxg_g_signal_handler_disconnect(Xen instance, Xen handler_id)
{
  #define H_g_signal_handler_disconnect "void g_signal_handler_disconnect(gpointer instance, gulong handler_id)"
  Xen_check_type(Xen_is_gpointer(instance), instance, 1, "g_signal_handler_disconnect", "gpointer");
  Xen_check_type(Xen_is_gulong(handler_id), handler_id, 2, "g_signal_handler_disconnect", "gulong");
  g_signal_handler_disconnect(Xen_to_C_gpointer(instance), Xen_to_C_gulong(handler_id));
  return(Xen_false);
}

static Xen gxg_g_signal_handler_is_connected(Xen instance, Xen handler_id)
{
  #define H_g_signal_handler_is_connected "gboolean g_signal_handler_is_connected(gpointer instance, \
gulong handler_id)"
  Xen_check_type(Xen_is_gpointer(instance), instance, 1, "g_signal_handler_is_connected", "gpointer");
  Xen_check_type(Xen_is_gulong(handler_id), handler_id, 2, "g_signal_handler_is_connected", "gulong");
  return(C_to_Xen_gboolean(g_signal_handler_is_connected(Xen_to_C_gpointer(instance), Xen_to_C_gulong(handler_id))));
}

static Xen gxg_g_signal_handler_find(Xen instance, Xen mask, Xen signal_id, Xen detail, Xen closure, Xen func, Xen data)
{
  #define H_g_signal_handler_find "gulong g_signal_handler_find(gpointer instance, GSignalMatchType mask, \
guint signal_id, GQuark detail, GClosure* closure, gpointer func, gpointer data)"
  Xen_check_type(Xen_is_gpointer(instance), instance, 1, "g_signal_handler_find", "gpointer");
  Xen_check_type(Xen_is_GSignalMatchType(mask), mask, 2, "g_signal_handler_find", "GSignalMatchType");
  Xen_check_type(Xen_is_guint(signal_id), signal_id, 3, "g_signal_handler_find", "guint");
  Xen_check_type(Xen_is_GQuark(detail), detail, 4, "g_signal_handler_find", "GQuark");
  Xen_check_type(Xen_is_GClosure_(closure) || Xen_is_false(closure), closure, 5, "g_signal_handler_find", "GClosure*");
  Xen_check_type(Xen_is_gpointer(func), func, 6, "g_signal_handler_find", "gpointer");
  Xen_check_type(Xen_is_gpointer(data), data, 7, "g_signal_handler_find", "gpointer");
  return(C_to_Xen_gulong(g_signal_handler_find(Xen_to_C_gpointer(instance), Xen_to_C_GSignalMatchType(mask), Xen_to_C_guint(signal_id), 
                                               Xen_to_C_GQuark(detail), Xen_to_C_GClosure_(closure), Xen_to_C_gpointer(func), 
                                               Xen_to_C_gpointer(data))));
}

static Xen gxg_g_signal_handlers_block_matched(Xen instance, Xen mask, Xen signal_id, Xen detail, Xen closure, Xen func, Xen data)
{
  #define H_g_signal_handlers_block_matched "guint g_signal_handlers_block_matched(gpointer instance, \
GSignalMatchType mask, guint signal_id, GQuark detail, GClosure* closure, gpointer func, gpointer data)"
  Xen_check_type(Xen_is_gpointer(instance), instance, 1, "g_signal_handlers_block_matched", "gpointer");
  Xen_check_type(Xen_is_GSignalMatchType(mask), mask, 2, "g_signal_handlers_block_matched", "GSignalMatchType");
  Xen_check_type(Xen_is_guint(signal_id), signal_id, 3, "g_signal_handlers_block_matched", "guint");
  Xen_check_type(Xen_is_GQuark(detail), detail, 4, "g_signal_handlers_block_matched", "GQuark");
  Xen_check_type(Xen_is_GClosure_(closure) || Xen_is_false(closure), closure, 5, "g_signal_handlers_block_matched", "GClosure*");
  Xen_check_type(Xen_is_gpointer(func), func, 6, "g_signal_handlers_block_matched", "gpointer");
  Xen_check_type(Xen_is_gpointer(data), data, 7, "g_signal_handlers_block_matched", "gpointer");
  return(C_to_Xen_guint(g_signal_handlers_block_matched(Xen_to_C_gpointer(instance), Xen_to_C_GSignalMatchType(mask), Xen_to_C_guint(signal_id), 
                                                        Xen_to_C_GQuark(detail), Xen_to_C_GClosure_(closure), Xen_to_C_gpointer(func), 
                                                        Xen_to_C_gpointer(data))));
}

static Xen gxg_g_signal_handlers_unblock_matched(Xen instance, Xen mask, Xen signal_id, Xen detail, Xen closure, Xen func, Xen data)
{
  #define H_g_signal_handlers_unblock_matched "guint g_signal_handlers_unblock_matched(gpointer instance, \
GSignalMatchType mask, guint signal_id, GQuark detail, GClosure* closure, gpointer func, gpointer data)"
  Xen_check_type(Xen_is_gpointer(instance), instance, 1, "g_signal_handlers_unblock_matched", "gpointer");
  Xen_check_type(Xen_is_GSignalMatchType(mask), mask, 2, "g_signal_handlers_unblock_matched", "GSignalMatchType");
  Xen_check_type(Xen_is_guint(signal_id), signal_id, 3, "g_signal_handlers_unblock_matched", "guint");
  Xen_check_type(Xen_is_GQuark(detail), detail, 4, "g_signal_handlers_unblock_matched", "GQuark");
  Xen_check_type(Xen_is_GClosure_(closure) || Xen_is_false(closure), closure, 5, "g_signal_handlers_unblock_matched", "GClosure*");
  Xen_check_type(Xen_is_gpointer(func), func, 6, "g_signal_handlers_unblock_matched", "gpointer");
  Xen_check_type(Xen_is_gpointer(data), data, 7, "g_signal_handlers_unblock_matched", "gpointer");
  return(C_to_Xen_guint(g_signal_handlers_unblock_matched(Xen_to_C_gpointer(instance), Xen_to_C_GSignalMatchType(mask), Xen_to_C_guint(signal_id), 
                                                          Xen_to_C_GQuark(detail), Xen_to_C_GClosure_(closure), Xen_to_C_gpointer(func), 
                                                          Xen_to_C_gpointer(data))));
}

static Xen gxg_g_signal_handlers_disconnect_matched(Xen instance, Xen mask, Xen signal_id, Xen detail, Xen closure, Xen func, Xen data)
{
  #define H_g_signal_handlers_disconnect_matched "guint g_signal_handlers_disconnect_matched(gpointer instance, \
GSignalMatchType mask, guint signal_id, GQuark detail, GClosure* closure, gpointer func, gpointer data)"
  Xen_check_type(Xen_is_gpointer(instance), instance, 1, "g_signal_handlers_disconnect_matched", "gpointer");
  Xen_check_type(Xen_is_GSignalMatchType(mask), mask, 2, "g_signal_handlers_disconnect_matched", "GSignalMatchType");
  Xen_check_type(Xen_is_guint(signal_id), signal_id, 3, "g_signal_handlers_disconnect_matched", "guint");
  Xen_check_type(Xen_is_GQuark(detail), detail, 4, "g_signal_handlers_disconnect_matched", "GQuark");
  Xen_check_type(Xen_is_GClosure_(closure) || Xen_is_false(closure), closure, 5, "g_signal_handlers_disconnect_matched", "GClosure*");
  Xen_check_type(Xen_is_gpointer(func), func, 6, "g_signal_handlers_disconnect_matched", "gpointer");
  Xen_check_type(Xen_is_gpointer(data), data, 7, "g_signal_handlers_disconnect_matched", "gpointer");
  return(C_to_Xen_guint(g_signal_handlers_disconnect_matched(Xen_to_C_gpointer(instance), Xen_to_C_GSignalMatchType(mask), 
                                                             Xen_to_C_guint(signal_id), Xen_to_C_GQuark(detail), Xen_to_C_GClosure_(closure), 
                                                             Xen_to_C_gpointer(func), Xen_to_C_gpointer(data))));
}

static Xen gxg_g_signal_handlers_destroy(Xen instance)
{
  #define H_g_signal_handlers_destroy "void g_signal_handlers_destroy(gpointer instance)"
  Xen_check_type(Xen_is_gpointer(instance), instance, 1, "g_signal_handlers_destroy", "gpointer");
  g_signal_handlers_destroy(Xen_to_C_gpointer(instance));
  return(Xen_false);
}

static Xen gxg_g_object_ref(Xen object)
{
  #define H_g_object_ref "gpointer g_object_ref(gpointer object)"
  Xen_check_type(Xen_is_gpointer(object), object, 1, "g_object_ref", "gpointer");
  return(C_to_Xen_gpointer(g_object_ref(Xen_to_C_gpointer(object))));
}

static Xen gxg_g_object_unref(Xen object)
{
  #define H_g_object_unref "void g_object_unref(gpointer object)"
  Xen_check_type(Xen_is_gpointer(object), object, 1, "g_object_unref", "gpointer");
  g_object_unref(Xen_to_C_gpointer(object));
  return(Xen_false);
}

static Xen gxg_gdk_event_get_time(Xen event)
{
  #define H_gdk_event_get_time "guint32 gdk_event_get_time(GdkEvent* event)"
  Xen_check_type(Xen_is_GdkEvent_(event) || Xen_is_false(event), event, 1, "gdk_event_get_time", "GdkEvent*");
  return(C_to_Xen_guint32(gdk_event_get_time(Xen_to_C_GdkEvent_(event))));
}

static Xen gxg_gdk_rectangle_intersect(Xen src1, Xen src2, Xen dest)
{
  #define H_gdk_rectangle_intersect "gboolean gdk_rectangle_intersect(GdkRectangle* src1, GdkRectangle* src2, \
GdkRectangle* dest)"
  Xen_check_type(Xen_is_GdkRectangle_(src1), src1, 1, "gdk_rectangle_intersect", "GdkRectangle*");
  Xen_check_type(Xen_is_GdkRectangle_(src2), src2, 2, "gdk_rectangle_intersect", "GdkRectangle*");
  Xen_check_type(Xen_is_GdkRectangle_(dest), dest, 3, "gdk_rectangle_intersect", "GdkRectangle*");
  return(C_to_Xen_gboolean(gdk_rectangle_intersect(Xen_to_C_GdkRectangle_(src1), Xen_to_C_GdkRectangle_(src2), Xen_to_C_GdkRectangle_(dest))));
}

static Xen gxg_gdk_rectangle_union(Xen src1, Xen src2, Xen dest)
{
  #define H_gdk_rectangle_union "void gdk_rectangle_union(GdkRectangle* src1, GdkRectangle* src2, GdkRectangle* dest)"
  Xen_check_type(Xen_is_GdkRectangle_(src1), src1, 1, "gdk_rectangle_union", "GdkRectangle*");
  Xen_check_type(Xen_is_GdkRectangle_(src2), src2, 2, "gdk_rectangle_union", "GdkRectangle*");
  Xen_check_type(Xen_is_GdkRectangle_(dest), dest, 3, "gdk_rectangle_union", "GdkRectangle*");
  gdk_rectangle_union(Xen_to_C_GdkRectangle_(src1), Xen_to_C_GdkRectangle_(src2), Xen_to_C_GdkRectangle_(dest));
  return(Xen_false);
}

static Xen gxg_gdk_keyval_name(Xen keyval)
{
  #define H_gdk_keyval_name "gchar* gdk_keyval_name(guint keyval)"
  Xen_check_type(Xen_is_guint(keyval), keyval, 1, "gdk_keyval_name", "guint");
  return(C_to_Xen_gchar_(gdk_keyval_name(Xen_to_C_guint(keyval))));
}

static Xen gxg_gdk_keyval_from_name(Xen keyval_name)
{
  #define H_gdk_keyval_from_name "guint gdk_keyval_from_name(gchar* keyval_name)"
  Xen_check_type(Xen_is_gchar_(keyval_name), keyval_name, 1, "gdk_keyval_from_name", "gchar*");
  return(C_to_Xen_guint(gdk_keyval_from_name(Xen_to_C_gchar_(keyval_name))));
}

static Xen gxg_gdk_keyval_convert_case(Xen symbol, Xen ignore_lower, Xen ignore_upper)
{
  #define H_gdk_keyval_convert_case "void gdk_keyval_convert_case(guint symbol, guint* [lower], guint* [upper])"
  guint ref_lower;
  guint ref_upper;
  Xen_check_type(Xen_is_guint(symbol), symbol, 1, "gdk_keyval_convert_case", "guint");
  gdk_keyval_convert_case(Xen_to_C_guint(symbol), &ref_lower, &ref_upper);
  return(Xen_list_2(C_to_Xen_guint(ref_lower), C_to_Xen_guint(ref_upper)));
}

static Xen gxg_gdk_keyval_to_upper(Xen keyval)
{
  #define H_gdk_keyval_to_upper "guint gdk_keyval_to_upper(guint keyval)"
  Xen_check_type(Xen_is_guint(keyval), keyval, 1, "gdk_keyval_to_upper", "guint");
  return(C_to_Xen_guint(gdk_keyval_to_upper(Xen_to_C_guint(keyval))));
}

static Xen gxg_gdk_keyval_to_lower(Xen keyval)
{
  #define H_gdk_keyval_to_lower "guint gdk_keyval_to_lower(guint keyval)"
  Xen_check_type(Xen_is_guint(keyval), keyval, 1, "gdk_keyval_to_lower", "guint");
  return(C_to_Xen_guint(gdk_keyval_to_lower(Xen_to_C_guint(keyval))));
}

static Xen gxg_gdk_keyval_is_upper(Xen keyval)
{
  #define H_gdk_keyval_is_upper "gboolean gdk_keyval_is_upper(guint keyval)"
  Xen_check_type(Xen_is_guint(keyval), keyval, 1, "gdk_keyval_is_upper", "guint");
  return(C_to_Xen_gboolean(gdk_keyval_is_upper(Xen_to_C_guint(keyval))));
}

static Xen gxg_gdk_keyval_is_lower(Xen keyval)
{
  #define H_gdk_keyval_is_lower "gboolean gdk_keyval_is_lower(guint keyval)"
  Xen_check_type(Xen_is_guint(keyval), keyval, 1, "gdk_keyval_is_lower", "guint");
  return(C_to_Xen_gboolean(gdk_keyval_is_lower(Xen_to_C_guint(keyval))));
}

static Xen gxg_gdk_keyval_to_unicode(Xen keyval)
{
  #define H_gdk_keyval_to_unicode "guint32 gdk_keyval_to_unicode(guint keyval)"
  Xen_check_type(Xen_is_guint(keyval), keyval, 1, "gdk_keyval_to_unicode", "guint");
  return(C_to_Xen_guint32(gdk_keyval_to_unicode(Xen_to_C_guint(keyval))));
}

static Xen gxg_gdk_unicode_to_keyval(Xen wc)
{
  #define H_gdk_unicode_to_keyval "guint gdk_unicode_to_keyval(guint32 wc)"
  Xen_check_type(Xen_is_guint32(wc), wc, 1, "gdk_unicode_to_keyval", "guint32");
  return(C_to_Xen_guint(gdk_unicode_to_keyval(Xen_to_C_guint32(wc))));
}

static Xen gxg_gdk_pixbuf_error_quark(void)
{
  #define H_gdk_pixbuf_error_quark "GQuark gdk_pixbuf_error_quark( void)"
  return(C_to_Xen_GQuark(gdk_pixbuf_error_quark()));
}

static Xen gxg_gdk_pixbuf_get_colorspace(Xen pixbuf)
{
  #define H_gdk_pixbuf_get_colorspace "GdkColorspace gdk_pixbuf_get_colorspace(GdkPixbuf* pixbuf)"
  Xen_check_type(Xen_is_GdkPixbuf_(pixbuf), pixbuf, 1, "gdk_pixbuf_get_colorspace", "GdkPixbuf*");
  return(C_to_Xen_GdkColorspace(gdk_pixbuf_get_colorspace(Xen_to_C_GdkPixbuf_(pixbuf))));
}

static Xen gxg_gdk_pixbuf_get_n_channels(Xen pixbuf)
{
  #define H_gdk_pixbuf_get_n_channels "int gdk_pixbuf_get_n_channels(GdkPixbuf* pixbuf)"
  Xen_check_type(Xen_is_GdkPixbuf_(pixbuf), pixbuf, 1, "gdk_pixbuf_get_n_channels", "GdkPixbuf*");
  return(C_to_Xen_int(gdk_pixbuf_get_n_channels(Xen_to_C_GdkPixbuf_(pixbuf))));
}

static Xen gxg_gdk_pixbuf_get_has_alpha(Xen pixbuf)
{
  #define H_gdk_pixbuf_get_has_alpha "gboolean gdk_pixbuf_get_has_alpha(GdkPixbuf* pixbuf)"
  Xen_check_type(Xen_is_GdkPixbuf_(pixbuf), pixbuf, 1, "gdk_pixbuf_get_has_alpha", "GdkPixbuf*");
  return(C_to_Xen_gboolean(gdk_pixbuf_get_has_alpha(Xen_to_C_GdkPixbuf_(pixbuf))));
}

static Xen gxg_gdk_pixbuf_get_bits_per_sample(Xen pixbuf)
{
  #define H_gdk_pixbuf_get_bits_per_sample "int gdk_pixbuf_get_bits_per_sample(GdkPixbuf* pixbuf)"
  Xen_check_type(Xen_is_GdkPixbuf_(pixbuf), pixbuf, 1, "gdk_pixbuf_get_bits_per_sample", "GdkPixbuf*");
  return(C_to_Xen_int(gdk_pixbuf_get_bits_per_sample(Xen_to_C_GdkPixbuf_(pixbuf))));
}

static Xen gxg_gdk_pixbuf_get_pixels(Xen pixbuf)
{
  #define H_gdk_pixbuf_get_pixels "guchar* gdk_pixbuf_get_pixels(GdkPixbuf* pixbuf)"
  Xen_check_type(Xen_is_GdkPixbuf_(pixbuf), pixbuf, 1, "gdk_pixbuf_get_pixels", "GdkPixbuf*");
  return(C_to_Xen_guchar_(gdk_pixbuf_get_pixels(Xen_to_C_GdkPixbuf_(pixbuf))));
}

static Xen gxg_gdk_pixbuf_get_width(Xen pixbuf)
{
  #define H_gdk_pixbuf_get_width "int gdk_pixbuf_get_width(GdkPixbuf* pixbuf)"
  Xen_check_type(Xen_is_GdkPixbuf_(pixbuf), pixbuf, 1, "gdk_pixbuf_get_width", "GdkPixbuf*");
  return(C_to_Xen_int(gdk_pixbuf_get_width(Xen_to_C_GdkPixbuf_(pixbuf))));
}

static Xen gxg_gdk_pixbuf_get_height(Xen pixbuf)
{
  #define H_gdk_pixbuf_get_height "int gdk_pixbuf_get_height(GdkPixbuf* pixbuf)"
  Xen_check_type(Xen_is_GdkPixbuf_(pixbuf), pixbuf, 1, "gdk_pixbuf_get_height", "GdkPixbuf*");
  return(C_to_Xen_int(gdk_pixbuf_get_height(Xen_to_C_GdkPixbuf_(pixbuf))));
}

static Xen gxg_gdk_pixbuf_get_rowstride(Xen pixbuf)
{
  #define H_gdk_pixbuf_get_rowstride "int gdk_pixbuf_get_rowstride(GdkPixbuf* pixbuf)"
  Xen_check_type(Xen_is_GdkPixbuf_(pixbuf), pixbuf, 1, "gdk_pixbuf_get_rowstride", "GdkPixbuf*");
  return(C_to_Xen_int(gdk_pixbuf_get_rowstride(Xen_to_C_GdkPixbuf_(pixbuf))));
}

static Xen gxg_gdk_pixbuf_new(Xen colorspace, Xen has_alpha, Xen bits_per_sample, Xen width, Xen height)
{
  #define H_gdk_pixbuf_new "GdkPixbuf* gdk_pixbuf_new(GdkColorspace colorspace, gboolean has_alpha, int bits_per_sample, \
int width, int height)"
  Xen_check_type(Xen_is_GdkColorspace(colorspace), colorspace, 1, "gdk_pixbuf_new", "GdkColorspace");
  Xen_check_type(Xen_is_gboolean(has_alpha), has_alpha, 2, "gdk_pixbuf_new", "gboolean");
  Xen_check_type(Xen_is_int(bits_per_sample), bits_per_sample, 3, "gdk_pixbuf_new", "int");
  Xen_check_type(Xen_is_int(width), width, 4, "gdk_pixbuf_new", "int");
  Xen_check_type(Xen_is_int(height), height, 5, "gdk_pixbuf_new", "int");
  return(C_to_Xen_GdkPixbuf_(gdk_pixbuf_new(Xen_to_C_GdkColorspace(colorspace), Xen_to_C_gboolean(has_alpha), Xen_to_C_int(bits_per_sample), 
                                            Xen_to_C_int(width), Xen_to_C_int(height))));
}

static Xen gxg_gdk_pixbuf_copy(Xen pixbuf)
{
  #define H_gdk_pixbuf_copy "GdkPixbuf* gdk_pixbuf_copy(GdkPixbuf* pixbuf)"
  Xen_check_type(Xen_is_GdkPixbuf_(pixbuf), pixbuf, 1, "gdk_pixbuf_copy", "GdkPixbuf*");
  return(C_to_Xen_GdkPixbuf_(gdk_pixbuf_copy(Xen_to_C_GdkPixbuf_(pixbuf))));
}

static Xen gxg_gdk_pixbuf_new_subpixbuf(Xen src_pixbuf, Xen src_x, Xen src_y, Xen width, Xen height)
{
  #define H_gdk_pixbuf_new_subpixbuf "GdkPixbuf* gdk_pixbuf_new_subpixbuf(GdkPixbuf* src_pixbuf, int src_x, \
int src_y, int width, int height)"
  Xen_check_type(Xen_is_GdkPixbuf_(src_pixbuf), src_pixbuf, 1, "gdk_pixbuf_new_subpixbuf", "GdkPixbuf*");
  Xen_check_type(Xen_is_int(src_x), src_x, 2, "gdk_pixbuf_new_subpixbuf", "int");
  Xen_check_type(Xen_is_int(src_y), src_y, 3, "gdk_pixbuf_new_subpixbuf", "int");
  Xen_check_type(Xen_is_int(width), width, 4, "gdk_pixbuf_new_subpixbuf", "int");
  Xen_check_type(Xen_is_int(height), height, 5, "gdk_pixbuf_new_subpixbuf", "int");
  return(C_to_Xen_GdkPixbuf_(gdk_pixbuf_new_subpixbuf(Xen_to_C_GdkPixbuf_(src_pixbuf), Xen_to_C_int(src_x), Xen_to_C_int(src_y), 
                                                      Xen_to_C_int(width), Xen_to_C_int(height))));
}

static Xen gxg_gdk_pixbuf_new_from_file(Xen filename, Xen ignore_error)
{
  #define H_gdk_pixbuf_new_from_file "GdkPixbuf* gdk_pixbuf_new_from_file(char* filename, GError** [error])"
  GError* ref_error = NULL;
  Xen_check_type(Xen_is_char_(filename), filename, 1, "gdk_pixbuf_new_from_file", "char*");
  {
    Xen res_ult;
    res_ult = C_to_Xen_GdkPixbuf_(gdk_pixbuf_new_from_file(Xen_to_C_char_(filename), &ref_error));
    return(Xen_list_2(res_ult, C_to_Xen_GError_(ref_error)));
   }
}

static Xen gxg_gdk_pixbuf_new_from_data(Xen arglist)
{
  #define H_gdk_pixbuf_new_from_data "GdkPixbuf* gdk_pixbuf_new_from_data(guchar* data, GdkColorspace colorspace, \
gboolean has_alpha, int bits_per_sample, int width, int height, int rowstride, GdkPixbufDestroyNotify destroy_fn, \
gpointer destroy_fn_data)"
  Xen data, colorspace, has_alpha, bits_per_sample, width, height, rowstride, destroy_fn, destroy_fn_data;
  data = Xen_list_ref(arglist, 0);
  colorspace = Xen_list_ref(arglist, 1);
  has_alpha = Xen_list_ref(arglist, 2);
  bits_per_sample = Xen_list_ref(arglist, 3);
  width = Xen_list_ref(arglist, 4);
  height = Xen_list_ref(arglist, 5);
  rowstride = Xen_list_ref(arglist, 6);
  destroy_fn = Xen_list_ref(arglist, 7);
  destroy_fn_data = Xen_list_ref(arglist, 8);
  Xen_check_type(Xen_is_guchar_(data), data, 1, "gdk_pixbuf_new_from_data", "guchar*");
  Xen_check_type(Xen_is_GdkColorspace(colorspace), colorspace, 2, "gdk_pixbuf_new_from_data", "GdkColorspace");
  Xen_check_type(Xen_is_gboolean(has_alpha), has_alpha, 3, "gdk_pixbuf_new_from_data", "gboolean");
  Xen_check_type(Xen_is_int(bits_per_sample), bits_per_sample, 4, "gdk_pixbuf_new_from_data", "int");
  Xen_check_type(Xen_is_int(width), width, 5, "gdk_pixbuf_new_from_data", "int");
  Xen_check_type(Xen_is_int(height), height, 6, "gdk_pixbuf_new_from_data", "int");
  Xen_check_type(Xen_is_int(rowstride), rowstride, 7, "gdk_pixbuf_new_from_data", "int");
  Xen_check_type(Xen_is_GdkPixbufDestroyNotify(destroy_fn), destroy_fn, 8, "gdk_pixbuf_new_from_data", "GdkPixbufDestroyNotify");
  Xen_check_type(Xen_is_gpointer(destroy_fn_data), destroy_fn_data, 9, "gdk_pixbuf_new_from_data", "gpointer");
  return(C_to_Xen_GdkPixbuf_(gdk_pixbuf_new_from_data(Xen_to_C_guchar_(data), Xen_to_C_GdkColorspace(colorspace), Xen_to_C_gboolean(has_alpha), 
                                                      Xen_to_C_int(bits_per_sample), Xen_to_C_int(width), Xen_to_C_int(height), 
                                                      Xen_to_C_int(rowstride), Xen_to_C_GdkPixbufDestroyNotify(destroy_fn), 
                                                      Xen_to_C_gpointer(destroy_fn_data))));
}

static Xen gxg_gdk_pixbuf_new_from_xpm_data(Xen data)
{
  #define H_gdk_pixbuf_new_from_xpm_data "GdkPixbuf* gdk_pixbuf_new_from_xpm_data(char** data)"
  Xen_check_type(Xen_is_char__(data), data, 1, "gdk_pixbuf_new_from_xpm_data", "char**");
  return(C_to_Xen_GdkPixbuf_(gdk_pixbuf_new_from_xpm_data((const char**)Xen_to_C_char__(data))));
}

static Xen gxg_gdk_pixbuf_fill(Xen pixbuf, Xen pixel)
{
  #define H_gdk_pixbuf_fill "void gdk_pixbuf_fill(GdkPixbuf* pixbuf, guint32 pixel)"
  Xen_check_type(Xen_is_GdkPixbuf_(pixbuf), pixbuf, 1, "gdk_pixbuf_fill", "GdkPixbuf*");
  Xen_check_type(Xen_is_guint32(pixel), pixel, 2, "gdk_pixbuf_fill", "guint32");
  gdk_pixbuf_fill(Xen_to_C_GdkPixbuf_(pixbuf), Xen_to_C_guint32(pixel));
  return(Xen_false);
}

static Xen gxg_gdk_pixbuf_savev(Xen pixbuf, Xen filename, Xen type, Xen option_keys, Xen option_values, Xen ignore_error)
{
  #define H_gdk_pixbuf_savev "gboolean gdk_pixbuf_savev(GdkPixbuf* pixbuf, char* filename, char* type, \
char** option_keys, char** option_values, GError** [error])"
  GError* ref_error = NULL;
  Xen_check_type(Xen_is_GdkPixbuf_(pixbuf), pixbuf, 1, "gdk_pixbuf_savev", "GdkPixbuf*");
  Xen_check_type(Xen_is_char_(filename), filename, 2, "gdk_pixbuf_savev", "char*");
  Xen_check_type(Xen_is_char_(type), type, 3, "gdk_pixbuf_savev", "char*");
  Xen_check_type(Xen_is_char__(option_keys), option_keys, 4, "gdk_pixbuf_savev", "char**");
  Xen_check_type(Xen_is_char__(option_values), option_values, 5, "gdk_pixbuf_savev", "char**");
  {
    Xen res_ult;
    res_ult = C_to_Xen_gboolean(gdk_pixbuf_savev(Xen_to_C_GdkPixbuf_(pixbuf), Xen_to_C_char_(filename), Xen_to_C_char_(type), 
                                                 Xen_to_C_char__(option_keys), Xen_to_C_char__(option_values), &ref_error));
    return(Xen_list_2(res_ult, C_to_Xen_GError_(ref_error)));
   }
}

static Xen gxg_gdk_pixbuf_add_alpha(Xen pixbuf, Xen substitute_color, Xen r, Xen g, Xen b)
{
  #define H_gdk_pixbuf_add_alpha "GdkPixbuf* gdk_pixbuf_add_alpha(GdkPixbuf* pixbuf, gboolean substitute_color, \
guchar r, guchar g, guchar b)"
  Xen_check_type(Xen_is_GdkPixbuf_(pixbuf), pixbuf, 1, "gdk_pixbuf_add_alpha", "GdkPixbuf*");
  Xen_check_type(Xen_is_gboolean(substitute_color), substitute_color, 2, "gdk_pixbuf_add_alpha", "gboolean");
  Xen_check_type(Xen_is_guchar(r), r, 3, "gdk_pixbuf_add_alpha", "guchar");
  Xen_check_type(Xen_is_guchar(g), g, 4, "gdk_pixbuf_add_alpha", "guchar");
  Xen_check_type(Xen_is_guchar(b), b, 5, "gdk_pixbuf_add_alpha", "guchar");
  return(C_to_Xen_GdkPixbuf_(gdk_pixbuf_add_alpha(Xen_to_C_GdkPixbuf_(pixbuf), Xen_to_C_gboolean(substitute_color), Xen_to_C_guchar(r), 
                                                  Xen_to_C_guchar(g), Xen_to_C_guchar(b))));
}

static Xen gxg_gdk_pixbuf_copy_area(Xen arglist)
{
  #define H_gdk_pixbuf_copy_area "void gdk_pixbuf_copy_area(GdkPixbuf* src_pixbuf, int src_x, int src_y, \
int width, int height, GdkPixbuf* dest_pixbuf, int dest_x, int dest_y)"
  Xen src_pixbuf, src_x, src_y, width, height, dest_pixbuf, dest_x, dest_y;
  src_pixbuf = Xen_list_ref(arglist, 0);
  src_x = Xen_list_ref(arglist, 1);
  src_y = Xen_list_ref(arglist, 2);
  width = Xen_list_ref(arglist, 3);
  height = Xen_list_ref(arglist, 4);
  dest_pixbuf = Xen_list_ref(arglist, 5);
  dest_x = Xen_list_ref(arglist, 6);
  dest_y = Xen_list_ref(arglist, 7);
  Xen_check_type(Xen_is_GdkPixbuf_(src_pixbuf), src_pixbuf, 1, "gdk_pixbuf_copy_area", "GdkPixbuf*");
  Xen_check_type(Xen_is_int(src_x), src_x, 2, "gdk_pixbuf_copy_area", "int");
  Xen_check_type(Xen_is_int(src_y), src_y, 3, "gdk_pixbuf_copy_area", "int");
  Xen_check_type(Xen_is_int(width), width, 4, "gdk_pixbuf_copy_area", "int");
  Xen_check_type(Xen_is_int(height), height, 5, "gdk_pixbuf_copy_area", "int");
  Xen_check_type(Xen_is_GdkPixbuf_(dest_pixbuf), dest_pixbuf, 6, "gdk_pixbuf_copy_area", "GdkPixbuf*");
  Xen_check_type(Xen_is_int(dest_x), dest_x, 7, "gdk_pixbuf_copy_area", "int");
  Xen_check_type(Xen_is_int(dest_y), dest_y, 8, "gdk_pixbuf_copy_area", "int");
  gdk_pixbuf_copy_area(Xen_to_C_GdkPixbuf_(src_pixbuf), Xen_to_C_int(src_x), Xen_to_C_int(src_y), Xen_to_C_int(width), Xen_to_C_int(height), 
                       Xen_to_C_GdkPixbuf_(dest_pixbuf), Xen_to_C_int(dest_x), Xen_to_C_int(dest_y));
  return(Xen_false);
}

static Xen gxg_gdk_pixbuf_saturate_and_pixelate(Xen src, Xen dest, Xen saturation, Xen pixelate)
{
  #define H_gdk_pixbuf_saturate_and_pixelate "void gdk_pixbuf_saturate_and_pixelate(GdkPixbuf* src, GdkPixbuf* dest, \
gfloat saturation, gboolean pixelate)"
  Xen_check_type(Xen_is_GdkPixbuf_(src), src, 1, "gdk_pixbuf_saturate_and_pixelate", "GdkPixbuf*");
  Xen_check_type(Xen_is_GdkPixbuf_(dest), dest, 2, "gdk_pixbuf_saturate_and_pixelate", "GdkPixbuf*");
  Xen_check_type(Xen_is_gfloat(saturation), saturation, 3, "gdk_pixbuf_saturate_and_pixelate", "gfloat");
  Xen_check_type(Xen_is_gboolean(pixelate), pixelate, 4, "gdk_pixbuf_saturate_and_pixelate", "gboolean");
  gdk_pixbuf_saturate_and_pixelate(Xen_to_C_GdkPixbuf_(src), Xen_to_C_GdkPixbuf_(dest), Xen_to_C_gfloat(saturation), Xen_to_C_gboolean(pixelate));
  return(Xen_false);
}

static Xen gxg_gdk_pixbuf_scale(Xen arglist)
{
  #define H_gdk_pixbuf_scale "void gdk_pixbuf_scale(GdkPixbuf* src, GdkPixbuf* dest, int dest_x, int dest_y, \
int dest_width, int dest_height, double offset_x, double offset_y, double scale_x, double scale_y, GdkInterpType interp_type)"
  Xen src, dest, dest_x, dest_y, dest_width, dest_height, offset_x, offset_y, scale_x, scale_y, interp_type;
  src = Xen_list_ref(arglist, 0);
  dest = Xen_list_ref(arglist, 1);
  dest_x = Xen_list_ref(arglist, 2);
  dest_y = Xen_list_ref(arglist, 3);
  dest_width = Xen_list_ref(arglist, 4);
  dest_height = Xen_list_ref(arglist, 5);
  offset_x = Xen_list_ref(arglist, 6);
  offset_y = Xen_list_ref(arglist, 7);
  scale_x = Xen_list_ref(arglist, 8);
  scale_y = Xen_list_ref(arglist, 9);
  interp_type = Xen_list_ref(arglist, 10);
  Xen_check_type(Xen_is_GdkPixbuf_(src), src, 1, "gdk_pixbuf_scale", "GdkPixbuf*");
  Xen_check_type(Xen_is_GdkPixbuf_(dest), dest, 2, "gdk_pixbuf_scale", "GdkPixbuf*");
  Xen_check_type(Xen_is_int(dest_x), dest_x, 3, "gdk_pixbuf_scale", "int");
  Xen_check_type(Xen_is_int(dest_y), dest_y, 4, "gdk_pixbuf_scale", "int");
  Xen_check_type(Xen_is_int(dest_width), dest_width, 5, "gdk_pixbuf_scale", "int");
  Xen_check_type(Xen_is_int(dest_height), dest_height, 6, "gdk_pixbuf_scale", "int");
  Xen_check_type(Xen_is_double(offset_x), offset_x, 7, "gdk_pixbuf_scale", "double");
  Xen_check_type(Xen_is_double(offset_y), offset_y, 8, "gdk_pixbuf_scale", "double");
  Xen_check_type(Xen_is_double(scale_x), scale_x, 9, "gdk_pixbuf_scale", "double");
  Xen_check_type(Xen_is_double(scale_y), scale_y, 10, "gdk_pixbuf_scale", "double");
  Xen_check_type(Xen_is_GdkInterpType(interp_type), interp_type, 11, "gdk_pixbuf_scale", "GdkInterpType");
  gdk_pixbuf_scale(Xen_to_C_GdkPixbuf_(src), Xen_to_C_GdkPixbuf_(dest), Xen_to_C_int(dest_x), Xen_to_C_int(dest_y), Xen_to_C_int(dest_width), 
                   Xen_to_C_int(dest_height), Xen_to_C_double(offset_x), Xen_to_C_double(offset_y), Xen_to_C_double(scale_x), 
                   Xen_to_C_double(scale_y), Xen_to_C_GdkInterpType(interp_type));
  return(Xen_false);
}

static Xen gxg_gdk_pixbuf_composite(Xen arglist)
{
  #define H_gdk_pixbuf_composite "void gdk_pixbuf_composite(GdkPixbuf* src, GdkPixbuf* dest, int dest_x, \
int dest_y, int dest_width, int dest_height, double offset_x, double offset_y, double scale_x, double scale_y, \
GdkInterpType interp_type, int overall_alpha)"
  Xen src, dest, dest_x, dest_y, dest_width, dest_height, offset_x, offset_y, scale_x, scale_y, interp_type, overall_alpha;
  src = Xen_list_ref(arglist, 0);
  dest = Xen_list_ref(arglist, 1);
  dest_x = Xen_list_ref(arglist, 2);
  dest_y = Xen_list_ref(arglist, 3);
  dest_width = Xen_list_ref(arglist, 4);
  dest_height = Xen_list_ref(arglist, 5);
  offset_x = Xen_list_ref(arglist, 6);
  offset_y = Xen_list_ref(arglist, 7);
  scale_x = Xen_list_ref(arglist, 8);
  scale_y = Xen_list_ref(arglist, 9);
  interp_type = Xen_list_ref(arglist, 10);
  overall_alpha = Xen_list_ref(arglist, 11);
  Xen_check_type(Xen_is_GdkPixbuf_(src), src, 1, "gdk_pixbuf_composite", "GdkPixbuf*");
  Xen_check_type(Xen_is_GdkPixbuf_(dest), dest, 2, "gdk_pixbuf_composite", "GdkPixbuf*");
  Xen_check_type(Xen_is_int(dest_x), dest_x, 3, "gdk_pixbuf_composite", "int");
  Xen_check_type(Xen_is_int(dest_y), dest_y, 4, "gdk_pixbuf_composite", "int");
  Xen_check_type(Xen_is_int(dest_width), dest_width, 5, "gdk_pixbuf_composite", "int");
  Xen_check_type(Xen_is_int(dest_height), dest_height, 6, "gdk_pixbuf_composite", "int");
  Xen_check_type(Xen_is_double(offset_x), offset_x, 7, "gdk_pixbuf_composite", "double");
  Xen_check_type(Xen_is_double(offset_y), offset_y, 8, "gdk_pixbuf_composite", "double");
  Xen_check_type(Xen_is_double(scale_x), scale_x, 9, "gdk_pixbuf_composite", "double");
  Xen_check_type(Xen_is_double(scale_y), scale_y, 10, "gdk_pixbuf_composite", "double");
  Xen_check_type(Xen_is_GdkInterpType(interp_type), interp_type, 11, "gdk_pixbuf_composite", "GdkInterpType");
  Xen_check_type(Xen_is_int(overall_alpha), overall_alpha, 12, "gdk_pixbuf_composite", "int");
  gdk_pixbuf_composite(Xen_to_C_GdkPixbuf_(src), Xen_to_C_GdkPixbuf_(dest), Xen_to_C_int(dest_x), Xen_to_C_int(dest_y), Xen_to_C_int(dest_width), 
                       Xen_to_C_int(dest_height), Xen_to_C_double(offset_x), Xen_to_C_double(offset_y), Xen_to_C_double(scale_x), 
                       Xen_to_C_double(scale_y), Xen_to_C_GdkInterpType(interp_type), Xen_to_C_int(overall_alpha));
  return(Xen_false);
}

static Xen gxg_gdk_pixbuf_composite_color(Xen arglist)
{
  #define H_gdk_pixbuf_composite_color "void gdk_pixbuf_composite_color(GdkPixbuf* src, GdkPixbuf* dest, \
int dest_x, int dest_y, int dest_width, int dest_height, double offset_x, double offset_y, double scale_x, \
double scale_y, GdkInterpType interp_type, int overall_alpha, int check_x, int check_y, int check_size, \
guint32 color1, guint32 color2)"
  Xen src, dest, dest_x, dest_y, dest_width, dest_height, offset_x, offset_y, scale_x, scale_y, interp_type, overall_alpha, check_x, check_y, check_size, color1, color2;
  src = Xen_list_ref(arglist, 0);
  dest = Xen_list_ref(arglist, 1);
  dest_x = Xen_list_ref(arglist, 2);
  dest_y = Xen_list_ref(arglist, 3);
  dest_width = Xen_list_ref(arglist, 4);
  dest_height = Xen_list_ref(arglist, 5);
  offset_x = Xen_list_ref(arglist, 6);
  offset_y = Xen_list_ref(arglist, 7);
  scale_x = Xen_list_ref(arglist, 8);
  scale_y = Xen_list_ref(arglist, 9);
  interp_type = Xen_list_ref(arglist, 10);
  overall_alpha = Xen_list_ref(arglist, 11);
  check_x = Xen_list_ref(arglist, 12);
  check_y = Xen_list_ref(arglist, 13);
  check_size = Xen_list_ref(arglist, 14);
  color1 = Xen_list_ref(arglist, 15);
  color2 = Xen_list_ref(arglist, 16);
  Xen_check_type(Xen_is_GdkPixbuf_(src), src, 1, "gdk_pixbuf_composite_color", "GdkPixbuf*");
  Xen_check_type(Xen_is_GdkPixbuf_(dest), dest, 2, "gdk_pixbuf_composite_color", "GdkPixbuf*");
  Xen_check_type(Xen_is_int(dest_x), dest_x, 3, "gdk_pixbuf_composite_color", "int");
  Xen_check_type(Xen_is_int(dest_y), dest_y, 4, "gdk_pixbuf_composite_color", "int");
  Xen_check_type(Xen_is_int(dest_width), dest_width, 5, "gdk_pixbuf_composite_color", "int");
  Xen_check_type(Xen_is_int(dest_height), dest_height, 6, "gdk_pixbuf_composite_color", "int");
  Xen_check_type(Xen_is_double(offset_x), offset_x, 7, "gdk_pixbuf_composite_color", "double");
  Xen_check_type(Xen_is_double(offset_y), offset_y, 8, "gdk_pixbuf_composite_color", "double");
  Xen_check_type(Xen_is_double(scale_x), scale_x, 9, "gdk_pixbuf_composite_color", "double");
  Xen_check_type(Xen_is_double(scale_y), scale_y, 10, "gdk_pixbuf_composite_color", "double");
  Xen_check_type(Xen_is_GdkInterpType(interp_type), interp_type, 11, "gdk_pixbuf_composite_color", "GdkInterpType");
  Xen_check_type(Xen_is_int(overall_alpha), overall_alpha, 12, "gdk_pixbuf_composite_color", "int");
  Xen_check_type(Xen_is_int(check_x), check_x, 13, "gdk_pixbuf_composite_color", "int");
  Xen_check_type(Xen_is_int(check_y), check_y, 14, "gdk_pixbuf_composite_color", "int");
  Xen_check_type(Xen_is_int(check_size), check_size, 15, "gdk_pixbuf_composite_color", "int");
  Xen_check_type(Xen_is_guint32(color1), color1, 16, "gdk_pixbuf_composite_color", "guint32");
  Xen_check_type(Xen_is_guint32(color2), color2, 17, "gdk_pixbuf_composite_color", "guint32");
  gdk_pixbuf_composite_color(Xen_to_C_GdkPixbuf_(src), Xen_to_C_GdkPixbuf_(dest), Xen_to_C_int(dest_x), Xen_to_C_int(dest_y), 
                             Xen_to_C_int(dest_width), Xen_to_C_int(dest_height), Xen_to_C_double(offset_x), Xen_to_C_double(offset_y), 
                             Xen_to_C_double(scale_x), Xen_to_C_double(scale_y), Xen_to_C_GdkInterpType(interp_type), Xen_to_C_int(overall_alpha), 
                             Xen_to_C_int(check_x), Xen_to_C_int(check_y), Xen_to_C_int(check_size), Xen_to_C_guint32(color1), 
                             Xen_to_C_guint32(color2));
  return(Xen_false);
}

static Xen gxg_gdk_pixbuf_scale_simple(Xen src, Xen dest_width, Xen dest_height, Xen interp_type)
{
  #define H_gdk_pixbuf_scale_simple "GdkPixbuf* gdk_pixbuf_scale_simple(GdkPixbuf* src, int dest_width, \
int dest_height, GdkInterpType interp_type)"
  Xen_check_type(Xen_is_GdkPixbuf_(src), src, 1, "gdk_pixbuf_scale_simple", "GdkPixbuf*");
  Xen_check_type(Xen_is_int(dest_width), dest_width, 2, "gdk_pixbuf_scale_simple", "int");
  Xen_check_type(Xen_is_int(dest_height), dest_height, 3, "gdk_pixbuf_scale_simple", "int");
  Xen_check_type(Xen_is_GdkInterpType(interp_type), interp_type, 4, "gdk_pixbuf_scale_simple", "GdkInterpType");
  return(C_to_Xen_GdkPixbuf_(gdk_pixbuf_scale_simple(Xen_to_C_GdkPixbuf_(src), Xen_to_C_int(dest_width), Xen_to_C_int(dest_height), 
                                                     Xen_to_C_GdkInterpType(interp_type))));
}

static Xen gxg_gdk_pixbuf_composite_color_simple(Xen arglist)
{
  #define H_gdk_pixbuf_composite_color_simple "GdkPixbuf* gdk_pixbuf_composite_color_simple(GdkPixbuf* src, \
int dest_width, int dest_height, GdkInterpType interp_type, int overall_alpha, int check_size, guint32 color1, \
guint32 color2)"
  Xen src, dest_width, dest_height, interp_type, overall_alpha, check_size, color1, color2;
  src = Xen_list_ref(arglist, 0);
  dest_width = Xen_list_ref(arglist, 1);
  dest_height = Xen_list_ref(arglist, 2);
  interp_type = Xen_list_ref(arglist, 3);
  overall_alpha = Xen_list_ref(arglist, 4);
  check_size = Xen_list_ref(arglist, 5);
  color1 = Xen_list_ref(arglist, 6);
  color2 = Xen_list_ref(arglist, 7);
  Xen_check_type(Xen_is_GdkPixbuf_(src), src, 1, "gdk_pixbuf_composite_color_simple", "GdkPixbuf*");
  Xen_check_type(Xen_is_int(dest_width), dest_width, 2, "gdk_pixbuf_composite_color_simple", "int");
  Xen_check_type(Xen_is_int(dest_height), dest_height, 3, "gdk_pixbuf_composite_color_simple", "int");
  Xen_check_type(Xen_is_GdkInterpType(interp_type), interp_type, 4, "gdk_pixbuf_composite_color_simple", "GdkInterpType");
  Xen_check_type(Xen_is_int(overall_alpha), overall_alpha, 5, "gdk_pixbuf_composite_color_simple", "int");
  Xen_check_type(Xen_is_int(check_size), check_size, 6, "gdk_pixbuf_composite_color_simple", "int");
  Xen_check_type(Xen_is_guint32(color1), color1, 7, "gdk_pixbuf_composite_color_simple", "guint32");
  Xen_check_type(Xen_is_guint32(color2), color2, 8, "gdk_pixbuf_composite_color_simple", "guint32");
  return(C_to_Xen_GdkPixbuf_(gdk_pixbuf_composite_color_simple(Xen_to_C_GdkPixbuf_(src), Xen_to_C_int(dest_width), Xen_to_C_int(dest_height), 
                                                               Xen_to_C_GdkInterpType(interp_type), Xen_to_C_int(overall_alpha), 
                                                               Xen_to_C_int(check_size), Xen_to_C_guint32(color1), Xen_to_C_guint32(color2))));
}

static Xen gxg_gdk_pixbuf_get_option(Xen pixbuf, Xen key)
{
  #define H_gdk_pixbuf_get_option "gchar* gdk_pixbuf_get_option(GdkPixbuf* pixbuf, gchar* key)"
  Xen_check_type(Xen_is_GdkPixbuf_(pixbuf), pixbuf, 1, "gdk_pixbuf_get_option", "GdkPixbuf*");
  Xen_check_type(Xen_is_gchar_(key), key, 2, "gdk_pixbuf_get_option", "gchar*");
  return(C_to_Xen_gchar_(gdk_pixbuf_get_option(Xen_to_C_GdkPixbuf_(pixbuf), Xen_to_C_gchar_(key))));
}

static Xen gxg_gtk_accel_label_new(Xen string)
{
  #define H_gtk_accel_label_new "GtkWidget* gtk_accel_label_new(gchar* string)"
  Xen_check_type(Xen_is_gchar_(string), string, 1, "gtk_accel_label_new", "gchar*");
  return(C_to_Xen_GtkWidget_(gtk_accel_label_new(Xen_to_C_gchar_(string))));
}

static Xen gxg_gtk_accel_label_get_accel_width(Xen accel_label)
{
  #define H_gtk_accel_label_get_accel_width "guint gtk_accel_label_get_accel_width(GtkAccelLabel* accel_label)"
  Xen_check_type(Xen_is_GtkAccelLabel_(accel_label), accel_label, 1, "gtk_accel_label_get_accel_width", "GtkAccelLabel*");
  return(C_to_Xen_guint(gtk_accel_label_get_accel_width(Xen_to_C_GtkAccelLabel_(accel_label))));
}

static Xen gxg_gtk_accel_label_refetch(Xen accel_label)
{
  #define H_gtk_accel_label_refetch "gboolean gtk_accel_label_refetch(GtkAccelLabel* accel_label)"
  Xen_check_type(Xen_is_GtkAccelLabel_(accel_label), accel_label, 1, "gtk_accel_label_refetch", "GtkAccelLabel*");
  return(C_to_Xen_gboolean(gtk_accel_label_refetch(Xen_to_C_GtkAccelLabel_(accel_label))));
}

static Xen gxg_gtk_adjustment_clamp_page(Xen adjustment, Xen lower, Xen upper)
{
  #define H_gtk_adjustment_clamp_page "void gtk_adjustment_clamp_page(GtkAdjustment* adjustment, gdouble lower, \
gdouble upper)"
  Xen_check_type(Xen_is_GtkAdjustment_(adjustment), adjustment, 1, "gtk_adjustment_clamp_page", "GtkAdjustment*");
  Xen_check_type(Xen_is_gdouble(lower), lower, 2, "gtk_adjustment_clamp_page", "gdouble");
  Xen_check_type(Xen_is_gdouble(upper), upper, 3, "gtk_adjustment_clamp_page", "gdouble");
  gtk_adjustment_clamp_page(Xen_to_C_GtkAdjustment_(adjustment), Xen_to_C_gdouble(lower), Xen_to_C_gdouble(upper));
  return(Xen_false);
}

static Xen gxg_gtk_adjustment_get_value(Xen adjustment)
{
  #define H_gtk_adjustment_get_value "gdouble gtk_adjustment_get_value(GtkAdjustment* adjustment)"
  Xen_check_type(Xen_is_GtkAdjustment_(adjustment), adjustment, 1, "gtk_adjustment_get_value", "GtkAdjustment*");
  return(C_to_Xen_gdouble(gtk_adjustment_get_value(Xen_to_C_GtkAdjustment_(adjustment))));
}

static Xen gxg_gtk_adjustment_set_value(Xen adjustment, Xen value)
{
  #define H_gtk_adjustment_set_value "void gtk_adjustment_set_value(GtkAdjustment* adjustment, gdouble value)"
  Xen_check_type(Xen_is_GtkAdjustment_(adjustment), adjustment, 1, "gtk_adjustment_set_value", "GtkAdjustment*");
  Xen_check_type(Xen_is_gdouble(value), value, 2, "gtk_adjustment_set_value", "gdouble");
  gtk_adjustment_set_value(Xen_to_C_GtkAdjustment_(adjustment), Xen_to_C_gdouble(value));
  return(Xen_false);
}

static Xen gxg_gtk_box_set_homogeneous(Xen box, Xen homogeneous)
{
  #define H_gtk_box_set_homogeneous "void gtk_box_set_homogeneous(GtkBox* box, gboolean homogeneous)"
  Xen_check_type(Xen_is_GtkBox_(box), box, 1, "gtk_box_set_homogeneous", "GtkBox*");
  Xen_check_type(Xen_is_gboolean(homogeneous), homogeneous, 2, "gtk_box_set_homogeneous", "gboolean");
  gtk_box_set_homogeneous(Xen_to_C_GtkBox_(box), Xen_to_C_gboolean(homogeneous));
  return(Xen_false);
}

static Xen gxg_gtk_box_get_homogeneous(Xen box)
{
  #define H_gtk_box_get_homogeneous "gboolean gtk_box_get_homogeneous(GtkBox* box)"
  Xen_check_type(Xen_is_GtkBox_(box), box, 1, "gtk_box_get_homogeneous", "GtkBox*");
  return(C_to_Xen_gboolean(gtk_box_get_homogeneous(Xen_to_C_GtkBox_(box))));
}

static Xen gxg_gtk_box_set_spacing(Xen box, Xen spacing)
{
  #define H_gtk_box_set_spacing "void gtk_box_set_spacing(GtkBox* box, gint spacing)"
  Xen_check_type(Xen_is_GtkBox_(box), box, 1, "gtk_box_set_spacing", "GtkBox*");
  Xen_check_type(Xen_is_gint(spacing), spacing, 2, "gtk_box_set_spacing", "gint");
  gtk_box_set_spacing(Xen_to_C_GtkBox_(box), Xen_to_C_gint(spacing));
  return(Xen_false);
}

static Xen gxg_gtk_box_get_spacing(Xen box)
{
  #define H_gtk_box_get_spacing "gint gtk_box_get_spacing(GtkBox* box)"
  Xen_check_type(Xen_is_GtkBox_(box), box, 1, "gtk_box_get_spacing", "GtkBox*");
  return(C_to_Xen_gint(gtk_box_get_spacing(Xen_to_C_GtkBox_(box))));
}

static Xen gxg_gtk_button_new(void)
{
  #define H_gtk_button_new "GtkWidget* gtk_button_new( void)"
  return(C_to_Xen_GtkWidget_(gtk_button_new()));
}

static Xen gxg_gtk_button_new_with_label(Xen label)
{
  #define H_gtk_button_new_with_label "GtkWidget* gtk_button_new_with_label(gchar* label)"
  Xen_check_type(Xen_is_gchar_(label), label, 1, "gtk_button_new_with_label", "gchar*");
  return(C_to_Xen_GtkWidget_(gtk_button_new_with_label(Xen_to_C_gchar_(label))));
}

static Xen gxg_gtk_button_new_with_mnemonic(Xen label)
{
  #define H_gtk_button_new_with_mnemonic "GtkWidget* gtk_button_new_with_mnemonic(gchar* label)"
  Xen_check_type(Xen_is_gchar_(label), label, 1, "gtk_button_new_with_mnemonic", "gchar*");
  return(C_to_Xen_GtkWidget_(gtk_button_new_with_mnemonic(Xen_to_C_gchar_(label))));
}

static Xen gxg_gtk_button_set_label(Xen button, Xen label)
{
  #define H_gtk_button_set_label "void gtk_button_set_label(GtkButton* button, gchar* label)"
  Xen_check_type(Xen_is_GtkButton_(button), button, 1, "gtk_button_set_label", "GtkButton*");
  Xen_check_type(Xen_is_gchar_(label), label, 2, "gtk_button_set_label", "gchar*");
  gtk_button_set_label(Xen_to_C_GtkButton_(button), Xen_to_C_gchar_(label));
  return(Xen_false);
}

static Xen gxg_gtk_button_get_label(Xen button)
{
  #define H_gtk_button_get_label "gchar* gtk_button_get_label(GtkButton* button)"
  Xen_check_type(Xen_is_GtkButton_(button), button, 1, "gtk_button_get_label", "GtkButton*");
  return(C_to_Xen_gchar_(gtk_button_get_label(Xen_to_C_GtkButton_(button))));
}

static Xen gxg_gtk_button_set_use_underline(Xen button, Xen use_underline)
{
  #define H_gtk_button_set_use_underline "void gtk_button_set_use_underline(GtkButton* button, gboolean use_underline)"
  Xen_check_type(Xen_is_GtkButton_(button), button, 1, "gtk_button_set_use_underline", "GtkButton*");
  Xen_check_type(Xen_is_gboolean(use_underline), use_underline, 2, "gtk_button_set_use_underline", "gboolean");
  gtk_button_set_use_underline(Xen_to_C_GtkButton_(button), Xen_to_C_gboolean(use_underline));
  return(Xen_false);
}

static Xen gxg_gtk_button_get_use_underline(Xen button)
{
  #define H_gtk_button_get_use_underline "gboolean gtk_button_get_use_underline(GtkButton* button)"
  Xen_check_type(Xen_is_GtkButton_(button), button, 1, "gtk_button_get_use_underline", "GtkButton*");
  return(C_to_Xen_gboolean(gtk_button_get_use_underline(Xen_to_C_GtkButton_(button))));
}

static Xen gxg_gtk_calendar_new(void)
{
  #define H_gtk_calendar_new "GtkWidget* gtk_calendar_new( void)"
  return(C_to_Xen_GtkWidget_(gtk_calendar_new()));
}

static Xen gxg_gtk_calendar_clear_marks(Xen calendar)
{
  #define H_gtk_calendar_clear_marks "void gtk_calendar_clear_marks(GtkCalendar* calendar)"
  Xen_check_type(Xen_is_GtkCalendar_(calendar), calendar, 1, "gtk_calendar_clear_marks", "GtkCalendar*");
  gtk_calendar_clear_marks(Xen_to_C_GtkCalendar_(calendar));
  return(Xen_false);
}

static Xen gxg_gtk_cell_editable_start_editing(Xen cell_editable, Xen event)
{
  #define H_gtk_cell_editable_start_editing "void gtk_cell_editable_start_editing(GtkCellEditable* cell_editable, \
GdkEvent* event)"
  Xen_check_type(Xen_is_GtkCellEditable_(cell_editable), cell_editable, 1, "gtk_cell_editable_start_editing", "GtkCellEditable*");
  Xen_check_type(Xen_is_GdkEvent_(event) || Xen_is_false(event), event, 2, "gtk_cell_editable_start_editing", "GdkEvent*");
  gtk_cell_editable_start_editing(Xen_to_C_GtkCellEditable_(cell_editable), Xen_to_C_GdkEvent_(event));
  return(Xen_false);
}

static Xen gxg_gtk_cell_editable_editing_done(Xen cell_editable)
{
  #define H_gtk_cell_editable_editing_done "void gtk_cell_editable_editing_done(GtkCellEditable* cell_editable)"
  Xen_check_type(Xen_is_GtkCellEditable_(cell_editable), cell_editable, 1, "gtk_cell_editable_editing_done", "GtkCellEditable*");
  gtk_cell_editable_editing_done(Xen_to_C_GtkCellEditable_(cell_editable));
  return(Xen_false);
}

static Xen gxg_gtk_cell_editable_remove_widget(Xen cell_editable)
{
  #define H_gtk_cell_editable_remove_widget "void gtk_cell_editable_remove_widget(GtkCellEditable* cell_editable)"
  Xen_check_type(Xen_is_GtkCellEditable_(cell_editable), cell_editable, 1, "gtk_cell_editable_remove_widget", "GtkCellEditable*");
  gtk_cell_editable_remove_widget(Xen_to_C_GtkCellEditable_(cell_editable));
  return(Xen_false);
}

static Xen gxg_gtk_cell_renderer_activate(Xen cell, Xen event, Xen widget, Xen path, Xen background_area, Xen cell_area, Xen flags)
{
  #define H_gtk_cell_renderer_activate "gboolean gtk_cell_renderer_activate(GtkCellRenderer* cell, GdkEvent* event, \
GtkWidget* widget, gchar* path, GdkRectangle* background_area, GdkRectangle* cell_area, GtkCellRendererState flags)"
  Xen_check_type(Xen_is_GtkCellRenderer_(cell), cell, 1, "gtk_cell_renderer_activate", "GtkCellRenderer*");
  Xen_check_type(Xen_is_GdkEvent_(event), event, 2, "gtk_cell_renderer_activate", "GdkEvent*");
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 3, "gtk_cell_renderer_activate", "GtkWidget*");
  Xen_check_type(Xen_is_gchar_(path), path, 4, "gtk_cell_renderer_activate", "gchar*");
  Xen_check_type(Xen_is_GdkRectangle_(background_area), background_area, 5, "gtk_cell_renderer_activate", "GdkRectangle*");
  Xen_check_type(Xen_is_GdkRectangle_(cell_area), cell_area, 6, "gtk_cell_renderer_activate", "GdkRectangle*");
  Xen_check_type(Xen_is_GtkCellRendererState(flags), flags, 7, "gtk_cell_renderer_activate", "GtkCellRendererState");
  return(C_to_Xen_gboolean(gtk_cell_renderer_activate(Xen_to_C_GtkCellRenderer_(cell), Xen_to_C_GdkEvent_(event), Xen_to_C_GtkWidget_(widget), 
                                                      Xen_to_C_gchar_(path), Xen_to_C_GdkRectangle_(background_area), Xen_to_C_GdkRectangle_(cell_area), 
                                                      Xen_to_C_GtkCellRendererState(flags))));
}

static Xen gxg_gtk_cell_renderer_start_editing(Xen cell, Xen event, Xen widget, Xen path, Xen background_area, Xen cell_area, Xen flags)
{
  #define H_gtk_cell_renderer_start_editing "GtkCellEditable* gtk_cell_renderer_start_editing(GtkCellRenderer* cell, \
GdkEvent* event, GtkWidget* widget, gchar* path, GdkRectangle* background_area, GdkRectangle* cell_area, \
GtkCellRendererState flags)"
  Xen_check_type(Xen_is_GtkCellRenderer_(cell), cell, 1, "gtk_cell_renderer_start_editing", "GtkCellRenderer*");
  Xen_check_type(Xen_is_GdkEvent_(event) || Xen_is_false(event), event, 2, "gtk_cell_renderer_start_editing", "GdkEvent*");
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 3, "gtk_cell_renderer_start_editing", "GtkWidget*");
  Xen_check_type(Xen_is_gchar_(path), path, 4, "gtk_cell_renderer_start_editing", "gchar*");
  Xen_check_type(Xen_is_GdkRectangle_(background_area), background_area, 5, "gtk_cell_renderer_start_editing", "GdkRectangle*");
  Xen_check_type(Xen_is_GdkRectangle_(cell_area), cell_area, 6, "gtk_cell_renderer_start_editing", "GdkRectangle*");
  Xen_check_type(Xen_is_GtkCellRendererState(flags), flags, 7, "gtk_cell_renderer_start_editing", "GtkCellRendererState");
  return(C_to_Xen_GtkCellEditable_(gtk_cell_renderer_start_editing(Xen_to_C_GtkCellRenderer_(cell), Xen_to_C_GdkEvent_(event), 
                                                                   Xen_to_C_GtkWidget_(widget), Xen_to_C_gchar_(path), Xen_to_C_GdkRectangle_(background_area), 
                                                                   Xen_to_C_GdkRectangle_(cell_area), Xen_to_C_GtkCellRendererState(flags))));
}

static Xen gxg_gtk_cell_renderer_set_fixed_size(Xen cell, Xen width, Xen height)
{
  #define H_gtk_cell_renderer_set_fixed_size "void gtk_cell_renderer_set_fixed_size(GtkCellRenderer* cell, \
gint width, gint height)"
  Xen_check_type(Xen_is_GtkCellRenderer_(cell), cell, 1, "gtk_cell_renderer_set_fixed_size", "GtkCellRenderer*");
  Xen_check_type(Xen_is_gint(width), width, 2, "gtk_cell_renderer_set_fixed_size", "gint");
  Xen_check_type(Xen_is_gint(height), height, 3, "gtk_cell_renderer_set_fixed_size", "gint");
  gtk_cell_renderer_set_fixed_size(Xen_to_C_GtkCellRenderer_(cell), Xen_to_C_gint(width), Xen_to_C_gint(height));
  return(Xen_false);
}

static Xen gxg_gtk_cell_renderer_get_fixed_size(Xen cell, Xen ignore_width, Xen ignore_height)
{
  #define H_gtk_cell_renderer_get_fixed_size "void gtk_cell_renderer_get_fixed_size(GtkCellRenderer* cell, \
gint* [width], gint* [height])"
  gint ref_width;
  gint ref_height;
  Xen_check_type(Xen_is_GtkCellRenderer_(cell), cell, 1, "gtk_cell_renderer_get_fixed_size", "GtkCellRenderer*");
  gtk_cell_renderer_get_fixed_size(Xen_to_C_GtkCellRenderer_(cell), &ref_width, &ref_height);
  return(Xen_list_2(C_to_Xen_gint(ref_width), C_to_Xen_gint(ref_height)));
}

static Xen gxg_gtk_cell_renderer_pixbuf_new(void)
{
  #define H_gtk_cell_renderer_pixbuf_new "GtkCellRenderer* gtk_cell_renderer_pixbuf_new( void)"
  return(C_to_Xen_GtkCellRenderer_(gtk_cell_renderer_pixbuf_new()));
}

static Xen gxg_gtk_cell_renderer_text_new(void)
{
  #define H_gtk_cell_renderer_text_new "GtkCellRenderer* gtk_cell_renderer_text_new( void)"
  return(C_to_Xen_GtkCellRenderer_(gtk_cell_renderer_text_new()));
}

static Xen gxg_gtk_cell_renderer_text_set_fixed_height_from_font(Xen renderer, Xen number_of_rows)
{
  #define H_gtk_cell_renderer_text_set_fixed_height_from_font "void gtk_cell_renderer_text_set_fixed_height_from_font(GtkCellRendererText* renderer, \
gint number_of_rows)"
  Xen_check_type(Xen_is_GtkCellRendererText_(renderer), renderer, 1, "gtk_cell_renderer_text_set_fixed_height_from_font", "GtkCellRendererText*");
  Xen_check_type(Xen_is_gint(number_of_rows), number_of_rows, 2, "gtk_cell_renderer_text_set_fixed_height_from_font", "gint");
  gtk_cell_renderer_text_set_fixed_height_from_font(Xen_to_C_GtkCellRendererText_(renderer), Xen_to_C_gint(number_of_rows));
  return(Xen_false);
}

static Xen gxg_gtk_cell_renderer_toggle_new(void)
{
  #define H_gtk_cell_renderer_toggle_new "GtkCellRenderer* gtk_cell_renderer_toggle_new( void)"
  return(C_to_Xen_GtkCellRenderer_(gtk_cell_renderer_toggle_new()));
}

static Xen gxg_gtk_cell_renderer_toggle_get_radio(Xen toggle)
{
  #define H_gtk_cell_renderer_toggle_get_radio "gboolean gtk_cell_renderer_toggle_get_radio(GtkCellRendererToggle* toggle)"
  Xen_check_type(Xen_is_GtkCellRendererToggle_(toggle), toggle, 1, "gtk_cell_renderer_toggle_get_radio", "GtkCellRendererToggle*");
  return(C_to_Xen_gboolean(gtk_cell_renderer_toggle_get_radio(Xen_to_C_GtkCellRendererToggle_(toggle))));
}

static Xen gxg_gtk_cell_renderer_toggle_set_radio(Xen toggle, Xen radio)
{
  #define H_gtk_cell_renderer_toggle_set_radio "void gtk_cell_renderer_toggle_set_radio(GtkCellRendererToggle* toggle, \
gboolean radio)"
  Xen_check_type(Xen_is_GtkCellRendererToggle_(toggle), toggle, 1, "gtk_cell_renderer_toggle_set_radio", "GtkCellRendererToggle*");
  Xen_check_type(Xen_is_gboolean(radio), radio, 2, "gtk_cell_renderer_toggle_set_radio", "gboolean");
  gtk_cell_renderer_toggle_set_radio(Xen_to_C_GtkCellRendererToggle_(toggle), Xen_to_C_gboolean(radio));
  return(Xen_false);
}

static Xen gxg_gtk_cell_renderer_toggle_get_active(Xen toggle)
{
  #define H_gtk_cell_renderer_toggle_get_active "gboolean gtk_cell_renderer_toggle_get_active(GtkCellRendererToggle* toggle)"
  Xen_check_type(Xen_is_GtkCellRendererToggle_(toggle), toggle, 1, "gtk_cell_renderer_toggle_get_active", "GtkCellRendererToggle*");
  return(C_to_Xen_gboolean(gtk_cell_renderer_toggle_get_active(Xen_to_C_GtkCellRendererToggle_(toggle))));
}

static Xen gxg_gtk_cell_renderer_toggle_set_active(Xen toggle, Xen setting)
{
  #define H_gtk_cell_renderer_toggle_set_active "void gtk_cell_renderer_toggle_set_active(GtkCellRendererToggle* toggle, \
gboolean setting)"
  Xen_check_type(Xen_is_GtkCellRendererToggle_(toggle), toggle, 1, "gtk_cell_renderer_toggle_set_active", "GtkCellRendererToggle*");
  Xen_check_type(Xen_is_gboolean(setting), setting, 2, "gtk_cell_renderer_toggle_set_active", "gboolean");
  gtk_cell_renderer_toggle_set_active(Xen_to_C_GtkCellRendererToggle_(toggle), Xen_to_C_gboolean(setting));
  return(Xen_false);
}

static Xen gxg_gtk_check_button_new(void)
{
  #define H_gtk_check_button_new "GtkWidget* gtk_check_button_new( void)"
  return(C_to_Xen_GtkWidget_(gtk_check_button_new()));
}

static Xen gxg_gtk_check_button_new_with_label(Xen label)
{
  #define H_gtk_check_button_new_with_label "GtkWidget* gtk_check_button_new_with_label(gchar* label)"
  Xen_check_type(Xen_is_gchar_(label), label, 1, "gtk_check_button_new_with_label", "gchar*");
  return(C_to_Xen_GtkWidget_(gtk_check_button_new_with_label(Xen_to_C_gchar_(label))));
}

static Xen gxg_gtk_check_button_new_with_mnemonic(Xen label)
{
  #define H_gtk_check_button_new_with_mnemonic "GtkWidget* gtk_check_button_new_with_mnemonic(gchar* label)"
  Xen_check_type(Xen_is_gchar_(label), label, 1, "gtk_check_button_new_with_mnemonic", "gchar*");
  return(C_to_Xen_GtkWidget_(gtk_check_button_new_with_mnemonic(Xen_to_C_gchar_(label))));
}

static Xen gxg_gtk_dialog_new(void)
{
  #define H_gtk_dialog_new "GtkWidget* gtk_dialog_new( void)"
  return(C_to_Xen_GtkWidget_(gtk_dialog_new()));
}

static Xen gxg_gtk_dialog_add_action_widget(Xen dialog, Xen child, Xen response_id)
{
  #define H_gtk_dialog_add_action_widget "void gtk_dialog_add_action_widget(GtkDialog* dialog, GtkWidget* child, \
gint response_id)"
  Xen_check_type(Xen_is_GtkDialog_(dialog), dialog, 1, "gtk_dialog_add_action_widget", "GtkDialog*");
  Xen_check_type(Xen_is_GtkWidget_(child), child, 2, "gtk_dialog_add_action_widget", "GtkWidget*");
  Xen_check_type(Xen_is_gint(response_id), response_id, 3, "gtk_dialog_add_action_widget", "gint");
  gtk_dialog_add_action_widget(Xen_to_C_GtkDialog_(dialog), Xen_to_C_GtkWidget_(child), Xen_to_C_gint(response_id));
  return(Xen_false);
}

static Xen gxg_gtk_dialog_add_button(Xen dialog, Xen button_text, Xen response_id)
{
  #define H_gtk_dialog_add_button "GtkWidget* gtk_dialog_add_button(GtkDialog* dialog, gchar* button_text, \
gint response_id)"
  Xen_check_type(Xen_is_GtkDialog_(dialog), dialog, 1, "gtk_dialog_add_button", "GtkDialog*");
  Xen_check_type(Xen_is_gchar_(button_text), button_text, 2, "gtk_dialog_add_button", "gchar*");
  Xen_check_type(Xen_is_gint(response_id), response_id, 3, "gtk_dialog_add_button", "gint");
  return(C_to_Xen_GtkWidget_(gtk_dialog_add_button(Xen_to_C_GtkDialog_(dialog), Xen_to_C_gchar_(button_text), Xen_to_C_gint(response_id))));
}

static Xen gxg_gtk_dialog_add_buttons(Xen dialog, Xen buttons)
{
  #define H_gtk_dialog_add_buttons "void gtk_dialog_add_buttons(GtkDialog* dialog, etc buttons)"
  Xen_check_type(Xen_is_GtkDialog_(dialog), dialog, 1, "gtk_dialog_add_buttons", "GtkDialog*");
  Xen_check_type(Xen_is_etc(buttons), buttons, 2, "gtk_dialog_add_buttons", "etc");
  {
    int etc_len = 0;
    GtkDialog* p_arg0;
    if (Xen_is_list(buttons)) etc_len = Xen_list_length(buttons);
    if (etc_len < 2) Xen_out_of_range_error("gtk_dialog_add_buttons", 1, buttons, "... list must have at least 2 entries");
    if (etc_len > 10) Xen_out_of_range_error("gtk_dialog_add_buttons", 1, buttons, "... list too long (max len: 10)");
    if ((etc_len % 2) != 0) Xen_out_of_range_error("gtk_dialog_add_buttons", 1, buttons, "... list len must be multiple of 2");
    p_arg0 = Xen_to_C_GtkDialog_(dialog);
    switch (etc_len)
      {
        case 2: gtk_dialog_add_buttons(p_arg0, XLS(buttons, 0), XLI(buttons, 1), NULL); break;
        case 4: gtk_dialog_add_buttons(p_arg0, XLS(buttons, 0), XLI(buttons, 1), XLS(buttons, 2), XLI(buttons, 3), NULL); break;
        case 6: gtk_dialog_add_buttons(p_arg0, XLS(buttons, 0), XLI(buttons, 1), XLS(buttons, 2), XLI(buttons, 3), XLS(buttons, 4), XLI(buttons, 5), NULL); break;
        case 8: gtk_dialog_add_buttons(p_arg0, XLS(buttons, 0), XLI(buttons, 1), XLS(buttons, 2), XLI(buttons, 3), XLS(buttons, 4), XLI(buttons, 5), XLS(buttons, 6), XLI(buttons, 7), NULL); break;
        case 10: gtk_dialog_add_buttons(p_arg0, XLS(buttons, 0), XLI(buttons, 1), XLS(buttons, 2), XLI(buttons, 3), XLS(buttons, 4), XLI(buttons, 5), XLS(buttons, 6), XLI(buttons, 7), XLS(buttons, 8), XLI(buttons, 9), NULL); break;
      }
    return(Xen_false);
  }
}

static Xen gxg_gtk_dialog_set_response_sensitive(Xen dialog, Xen response_id, Xen setting)
{
  #define H_gtk_dialog_set_response_sensitive "void gtk_dialog_set_response_sensitive(GtkDialog* dialog, \
gint response_id, gboolean setting)"
  Xen_check_type(Xen_is_GtkDialog_(dialog), dialog, 1, "gtk_dialog_set_response_sensitive", "GtkDialog*");
  Xen_check_type(Xen_is_gint(response_id), response_id, 2, "gtk_dialog_set_response_sensitive", "gint");
  Xen_check_type(Xen_is_gboolean(setting), setting, 3, "gtk_dialog_set_response_sensitive", "gboolean");
  gtk_dialog_set_response_sensitive(Xen_to_C_GtkDialog_(dialog), Xen_to_C_gint(response_id), Xen_to_C_gboolean(setting));
  return(Xen_false);
}

static Xen gxg_gtk_dialog_set_default_response(Xen dialog, Xen response_id)
{
  #define H_gtk_dialog_set_default_response "void gtk_dialog_set_default_response(GtkDialog* dialog, \
gint response_id)"
  Xen_check_type(Xen_is_GtkDialog_(dialog), dialog, 1, "gtk_dialog_set_default_response", "GtkDialog*");
  Xen_check_type(Xen_is_gint(response_id), response_id, 2, "gtk_dialog_set_default_response", "gint");
  gtk_dialog_set_default_response(Xen_to_C_GtkDialog_(dialog), Xen_to_C_gint(response_id));
  return(Xen_false);
}

static Xen gxg_gtk_dialog_response(Xen dialog, Xen response_id)
{
  #define H_gtk_dialog_response "void gtk_dialog_response(GtkDialog* dialog, gint response_id)"
  Xen_check_type(Xen_is_GtkDialog_(dialog), dialog, 1, "gtk_dialog_response", "GtkDialog*");
  Xen_check_type(Xen_is_gint(response_id), response_id, 2, "gtk_dialog_response", "gint");
  gtk_dialog_response(Xen_to_C_GtkDialog_(dialog), Xen_to_C_gint(response_id));
  return(Xen_false);
}

static Xen gxg_gtk_drawing_area_new(void)
{
  #define H_gtk_drawing_area_new "GtkWidget* gtk_drawing_area_new( void)"
  return(C_to_Xen_GtkWidget_(gtk_drawing_area_new()));
}

static Xen gxg_gtk_editable_select_region(Xen editable, Xen start, Xen end)
{
  #define H_gtk_editable_select_region "void gtk_editable_select_region(GtkEditable* editable, int start, \
int end)"
  Xen_check_type(Xen_is_GtkEditable_(editable), editable, 1, "gtk_editable_select_region", "GtkEditable*");
  Xen_check_type(Xen_is_int(start), start, 2, "gtk_editable_select_region", "int");
  Xen_check_type(Xen_is_int(end), end, 3, "gtk_editable_select_region", "int");
  gtk_editable_select_region(Xen_to_C_GtkEditable_(editable), Xen_to_C_int(start), Xen_to_C_int(end));
  return(Xen_false);
}

static Xen gxg_gtk_editable_get_selection_bounds(Xen editable, Xen ignore_start, Xen ignore_end)
{
  #define H_gtk_editable_get_selection_bounds "gboolean gtk_editable_get_selection_bounds(GtkEditable* editable, \
int* [start], int* [end])"
  int ref_start;
  int ref_end;
  Xen_check_type(Xen_is_GtkEditable_(editable), editable, 1, "gtk_editable_get_selection_bounds", "GtkEditable*");
  {
    Xen res_ult;
    res_ult = C_to_Xen_gboolean(gtk_editable_get_selection_bounds(Xen_to_C_GtkEditable_(editable), &ref_start, &ref_end));
    return(Xen_list_3(res_ult, C_to_Xen_int(ref_start), C_to_Xen_int(ref_end)));
   }
}

static Xen gxg_gtk_editable_insert_text(Xen editable, Xen new_text, Xen new_text_length, Xen ignore_position)
{
  #define H_gtk_editable_insert_text "void gtk_editable_insert_text(GtkEditable* editable, gchar* new_text, \
int new_text_length, int* [position])"
  int ref_position;
  Xen_check_type(Xen_is_GtkEditable_(editable), editable, 1, "gtk_editable_insert_text", "GtkEditable*");
  Xen_check_type(Xen_is_gchar_(new_text), new_text, 2, "gtk_editable_insert_text", "gchar*");
  Xen_check_type(Xen_is_int(new_text_length), new_text_length, 3, "gtk_editable_insert_text", "int");
  gtk_editable_insert_text(Xen_to_C_GtkEditable_(editable), Xen_to_C_gchar_(new_text), Xen_to_C_int(new_text_length), &ref_position);
  return(Xen_list_1(C_to_Xen_int(ref_position)));
}

static Xen gxg_gtk_editable_delete_text(Xen editable, Xen start_pos, Xen end_pos)
{
  #define H_gtk_editable_delete_text "void gtk_editable_delete_text(GtkEditable* editable, int start_pos, \
int end_pos)"
  Xen_check_type(Xen_is_GtkEditable_(editable), editable, 1, "gtk_editable_delete_text", "GtkEditable*");
  Xen_check_type(Xen_is_int(start_pos), start_pos, 2, "gtk_editable_delete_text", "int");
  Xen_check_type(Xen_is_int(end_pos), end_pos, 3, "gtk_editable_delete_text", "int");
  gtk_editable_delete_text(Xen_to_C_GtkEditable_(editable), Xen_to_C_int(start_pos), Xen_to_C_int(end_pos));
  return(Xen_false);
}

static Xen gxg_gtk_editable_get_chars(Xen editable, Xen start_pos, Xen end_pos)
{
  #define H_gtk_editable_get_chars "gchar* gtk_editable_get_chars(GtkEditable* editable, int start_pos, \
int end_pos)"
  Xen_check_type(Xen_is_GtkEditable_(editable), editable, 1, "gtk_editable_get_chars", "GtkEditable*");
  Xen_check_type(Xen_is_int(start_pos), start_pos, 2, "gtk_editable_get_chars", "int");
  Xen_check_type(Xen_is_int(end_pos), end_pos, 3, "gtk_editable_get_chars", "int");
  {
   gchar* res_ult;
   Xen rtn;
   res_ult = gtk_editable_get_chars(Xen_to_C_GtkEditable_(editable), Xen_to_C_int(start_pos), 
                                                                       Xen_to_C_int(end_pos));
   rtn = C_to_Xen_gchar_(res_ult);
   g_free(res_ult);
   return(rtn);
  }
}

static Xen gxg_gtk_editable_delete_selection(Xen editable)
{
  #define H_gtk_editable_delete_selection "void gtk_editable_delete_selection(GtkEditable* editable)"
  Xen_check_type(Xen_is_GtkEditable_(editable), editable, 1, "gtk_editable_delete_selection", "GtkEditable*");
  gtk_editable_delete_selection(Xen_to_C_GtkEditable_(editable));
  return(Xen_false);
}

static Xen gxg_gtk_editable_set_position(Xen editable, Xen position)
{
  #define H_gtk_editable_set_position "void gtk_editable_set_position(GtkEditable* editable, gint position)"
  Xen_check_type(Xen_is_GtkEditable_(editable), editable, 1, "gtk_editable_set_position", "GtkEditable*");
  Xen_check_type(Xen_is_gint(position), position, 2, "gtk_editable_set_position", "gint");
  gtk_editable_set_position(Xen_to_C_GtkEditable_(editable), Xen_to_C_gint(position));
  return(Xen_false);
}

static Xen gxg_gtk_editable_get_position(Xen editable)
{
  #define H_gtk_editable_get_position "gint gtk_editable_get_position(GtkEditable* editable)"
  Xen_check_type(Xen_is_GtkEditable_(editable), editable, 1, "gtk_editable_get_position", "GtkEditable*");
  return(C_to_Xen_gint(gtk_editable_get_position(Xen_to_C_GtkEditable_(editable))));
}

static Xen gxg_gtk_editable_set_editable(Xen editable, Xen is_editable)
{
  #define H_gtk_editable_set_editable "void gtk_editable_set_editable(GtkEditable* editable, gboolean is_editable)"
  Xen_check_type(Xen_is_GtkEditable_(editable), editable, 1, "gtk_editable_set_editable", "GtkEditable*");
  Xen_check_type(Xen_is_gboolean(is_editable), is_editable, 2, "gtk_editable_set_editable", "gboolean");
  gtk_editable_set_editable(Xen_to_C_GtkEditable_(editable), Xen_to_C_gboolean(is_editable));
  return(Xen_false);
}

static Xen gxg_gtk_editable_get_editable(Xen editable)
{
  #define H_gtk_editable_get_editable "gboolean gtk_editable_get_editable(GtkEditable* editable)"
  Xen_check_type(Xen_is_GtkEditable_(editable), editable, 1, "gtk_editable_get_editable", "GtkEditable*");
  return(C_to_Xen_gboolean(gtk_editable_get_editable(Xen_to_C_GtkEditable_(editable))));
}

static Xen gxg_gtk_entry_new(void)
{
  #define H_gtk_entry_new "GtkWidget* gtk_entry_new( void)"
  return(C_to_Xen_GtkWidget_(gtk_entry_new()));
}

static Xen gxg_gtk_entry_set_visibility(Xen entry, Xen visible)
{
  #define H_gtk_entry_set_visibility "void gtk_entry_set_visibility(GtkEntry* entry, gboolean visible)"
  Xen_check_type(Xen_is_GtkEntry_(entry), entry, 1, "gtk_entry_set_visibility", "GtkEntry*");
  Xen_check_type(Xen_is_gboolean(visible), visible, 2, "gtk_entry_set_visibility", "gboolean");
  gtk_entry_set_visibility(Xen_to_C_GtkEntry_(entry), Xen_to_C_gboolean(visible));
  return(Xen_false);
}

static Xen gxg_gtk_entry_get_visibility(Xen entry)
{
  #define H_gtk_entry_get_visibility "gboolean gtk_entry_get_visibility(GtkEntry* entry)"
  Xen_check_type(Xen_is_GtkEntry_(entry), entry, 1, "gtk_entry_get_visibility", "GtkEntry*");
  return(C_to_Xen_gboolean(gtk_entry_get_visibility(Xen_to_C_GtkEntry_(entry))));
}

static Xen gxg_gtk_entry_set_invisible_char(Xen entry, Xen ch)
{
  #define H_gtk_entry_set_invisible_char "void gtk_entry_set_invisible_char(GtkEntry* entry, gunichar ch)"
  Xen_check_type(Xen_is_GtkEntry_(entry), entry, 1, "gtk_entry_set_invisible_char", "GtkEntry*");
  Xen_check_type(Xen_is_gunichar(ch), ch, 2, "gtk_entry_set_invisible_char", "gunichar");
  gtk_entry_set_invisible_char(Xen_to_C_GtkEntry_(entry), Xen_to_C_gunichar(ch));
  return(Xen_false);
}

static Xen gxg_gtk_entry_get_invisible_char(Xen entry)
{
  #define H_gtk_entry_get_invisible_char "gunichar gtk_entry_get_invisible_char(GtkEntry* entry)"
  Xen_check_type(Xen_is_GtkEntry_(entry), entry, 1, "gtk_entry_get_invisible_char", "GtkEntry*");
  return(C_to_Xen_gunichar(gtk_entry_get_invisible_char(Xen_to_C_GtkEntry_(entry))));
}

static Xen gxg_gtk_entry_set_has_frame(Xen entry, Xen setting)
{
  #define H_gtk_entry_set_has_frame "void gtk_entry_set_has_frame(GtkEntry* entry, gboolean setting)"
  Xen_check_type(Xen_is_GtkEntry_(entry), entry, 1, "gtk_entry_set_has_frame", "GtkEntry*");
  Xen_check_type(Xen_is_gboolean(setting), setting, 2, "gtk_entry_set_has_frame", "gboolean");
  gtk_entry_set_has_frame(Xen_to_C_GtkEntry_(entry), Xen_to_C_gboolean(setting));
  return(Xen_false);
}

static Xen gxg_gtk_entry_get_has_frame(Xen entry)
{
  #define H_gtk_entry_get_has_frame "gboolean gtk_entry_get_has_frame(GtkEntry* entry)"
  Xen_check_type(Xen_is_GtkEntry_(entry), entry, 1, "gtk_entry_get_has_frame", "GtkEntry*");
  return(C_to_Xen_gboolean(gtk_entry_get_has_frame(Xen_to_C_GtkEntry_(entry))));
}

static Xen gxg_gtk_entry_set_max_length(Xen entry, Xen max)
{
  #define H_gtk_entry_set_max_length "void gtk_entry_set_max_length(GtkEntry* entry, gint max)"
  Xen_check_type(Xen_is_GtkEntry_(entry), entry, 1, "gtk_entry_set_max_length", "GtkEntry*");
  Xen_check_type(Xen_is_gint(max), max, 2, "gtk_entry_set_max_length", "gint");
  gtk_entry_set_max_length(Xen_to_C_GtkEntry_(entry), Xen_to_C_gint(max));
  return(Xen_false);
}

static Xen gxg_gtk_entry_get_max_length(Xen entry)
{
  #define H_gtk_entry_get_max_length "gint gtk_entry_get_max_length(GtkEntry* entry)"
  Xen_check_type(Xen_is_GtkEntry_(entry), entry, 1, "gtk_entry_get_max_length", "GtkEntry*");
  return(C_to_Xen_gint(gtk_entry_get_max_length(Xen_to_C_GtkEntry_(entry))));
}

static Xen gxg_gtk_entry_set_activates_default(Xen entry, Xen setting)
{
  #define H_gtk_entry_set_activates_default "void gtk_entry_set_activates_default(GtkEntry* entry, gboolean setting)"
  Xen_check_type(Xen_is_GtkEntry_(entry), entry, 1, "gtk_entry_set_activates_default", "GtkEntry*");
  Xen_check_type(Xen_is_gboolean(setting), setting, 2, "gtk_entry_set_activates_default", "gboolean");
  gtk_entry_set_activates_default(Xen_to_C_GtkEntry_(entry), Xen_to_C_gboolean(setting));
  return(Xen_false);
}

static Xen gxg_gtk_entry_get_activates_default(Xen entry)
{
  #define H_gtk_entry_get_activates_default "gboolean gtk_entry_get_activates_default(GtkEntry* entry)"
  Xen_check_type(Xen_is_GtkEntry_(entry), entry, 1, "gtk_entry_get_activates_default", "GtkEntry*");
  return(C_to_Xen_gboolean(gtk_entry_get_activates_default(Xen_to_C_GtkEntry_(entry))));
}

static Xen gxg_gtk_fixed_new(void)
{
  #define H_gtk_fixed_new "GtkWidget* gtk_fixed_new( void)"
  return(C_to_Xen_GtkWidget_(gtk_fixed_new()));
}

static Xen gxg_gtk_fixed_put(Xen fixed, Xen widget, Xen x, Xen y)
{
  #define H_gtk_fixed_put "void gtk_fixed_put(GtkFixed* fixed, GtkWidget* widget, gint x, gint y)"
  Xen_check_type(Xen_is_GtkFixed_(fixed), fixed, 1, "gtk_fixed_put", "GtkFixed*");
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 2, "gtk_fixed_put", "GtkWidget*");
  Xen_check_type(Xen_is_gint(x), x, 3, "gtk_fixed_put", "gint");
  Xen_check_type(Xen_is_gint(y), y, 4, "gtk_fixed_put", "gint");
  gtk_fixed_put(Xen_to_C_GtkFixed_(fixed), Xen_to_C_GtkWidget_(widget), Xen_to_C_gint(x), Xen_to_C_gint(y));
  return(Xen_false);
}

static Xen gxg_gtk_fixed_move(Xen fixed, Xen widget, Xen x, Xen y)
{
  #define H_gtk_fixed_move "void gtk_fixed_move(GtkFixed* fixed, GtkWidget* widget, gint x, gint y)"
  Xen_check_type(Xen_is_GtkFixed_(fixed), fixed, 1, "gtk_fixed_move", "GtkFixed*");
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 2, "gtk_fixed_move", "GtkWidget*");
  Xen_check_type(Xen_is_gint(x), x, 3, "gtk_fixed_move", "gint");
  Xen_check_type(Xen_is_gint(y), y, 4, "gtk_fixed_move", "gint");
  gtk_fixed_move(Xen_to_C_GtkFixed_(fixed), Xen_to_C_GtkWidget_(widget), Xen_to_C_gint(x), Xen_to_C_gint(y));
  return(Xen_false);
}

static Xen gxg_gtk_frame_new(Xen label)
{
  #define H_gtk_frame_new "GtkWidget* gtk_frame_new(gchar* label)"
  Xen_check_type(Xen_is_gchar_(label), label, 1, "gtk_frame_new", "gchar*");
  return(C_to_Xen_GtkWidget_(gtk_frame_new(Xen_to_C_gchar_(label))));
}

static Xen gxg_gtk_frame_set_label(Xen frame, Xen label)
{
  #define H_gtk_frame_set_label "void gtk_frame_set_label(GtkFrame* frame, gchar* label)"
  Xen_check_type(Xen_is_GtkFrame_(frame), frame, 1, "gtk_frame_set_label", "GtkFrame*");
  Xen_check_type(Xen_is_gchar_(label), label, 2, "gtk_frame_set_label", "gchar*");
  gtk_frame_set_label(Xen_to_C_GtkFrame_(frame), Xen_to_C_gchar_(label));
  return(Xen_false);
}

static Xen gxg_gtk_frame_get_label(Xen frame)
{
  #define H_gtk_frame_get_label "gchar* gtk_frame_get_label(GtkFrame* frame)"
  Xen_check_type(Xen_is_GtkFrame_(frame), frame, 1, "gtk_frame_get_label", "GtkFrame*");
  return(C_to_Xen_gchar_(gtk_frame_get_label(Xen_to_C_GtkFrame_(frame))));
}

static Xen gxg_gtk_frame_set_label_widget(Xen frame, Xen label_widget)
{
  #define H_gtk_frame_set_label_widget "void gtk_frame_set_label_widget(GtkFrame* frame, GtkWidget* label_widget)"
  Xen_check_type(Xen_is_GtkFrame_(frame), frame, 1, "gtk_frame_set_label_widget", "GtkFrame*");
  Xen_check_type(Xen_is_GtkWidget_(label_widget), label_widget, 2, "gtk_frame_set_label_widget", "GtkWidget*");
  gtk_frame_set_label_widget(Xen_to_C_GtkFrame_(frame), Xen_to_C_GtkWidget_(label_widget));
  return(Xen_false);
}

static Xen gxg_gtk_frame_get_label_widget(Xen frame)
{
  #define H_gtk_frame_get_label_widget "GtkWidget* gtk_frame_get_label_widget(GtkFrame* frame)"
  Xen_check_type(Xen_is_GtkFrame_(frame), frame, 1, "gtk_frame_get_label_widget", "GtkFrame*");
  return(C_to_Xen_GtkWidget_(gtk_frame_get_label_widget(Xen_to_C_GtkFrame_(frame))));
}

static Xen gxg_gtk_image_new(void)
{
  #define H_gtk_image_new "GtkWidget* gtk_image_new( void)"
  return(C_to_Xen_GtkWidget_(gtk_image_new()));
}

static Xen gxg_gtk_image_new_from_file(Xen filename)
{
  #define H_gtk_image_new_from_file "GtkWidget* gtk_image_new_from_file(gchar* filename)"
  Xen_check_type(Xen_is_gchar_(filename), filename, 1, "gtk_image_new_from_file", "gchar*");
  return(C_to_Xen_GtkWidget_(gtk_image_new_from_file(Xen_to_C_gchar_(filename))));
}

static Xen gxg_gtk_image_new_from_pixbuf(Xen pixbuf)
{
  #define H_gtk_image_new_from_pixbuf "GtkWidget* gtk_image_new_from_pixbuf(GdkPixbuf* pixbuf)"
  Xen_check_type(Xen_is_GdkPixbuf_(pixbuf) || Xen_is_false(pixbuf), pixbuf, 1, "gtk_image_new_from_pixbuf", "GdkPixbuf*");
  return(C_to_Xen_GtkWidget_(gtk_image_new_from_pixbuf(Xen_to_C_GdkPixbuf_(pixbuf))));
}

static Xen gxg_gtk_image_set_from_file(Xen image, Xen filename)
{
  #define H_gtk_image_set_from_file "void gtk_image_set_from_file(GtkImage* image, gchar* filename)"
  Xen_check_type(Xen_is_GtkImage_(image), image, 1, "gtk_image_set_from_file", "GtkImage*");
  Xen_check_type(Xen_is_gchar_(filename), filename, 2, "gtk_image_set_from_file", "gchar*");
  gtk_image_set_from_file(Xen_to_C_GtkImage_(image), Xen_to_C_gchar_(filename));
  return(Xen_false);
}

static Xen gxg_gtk_image_set_from_pixbuf(Xen image, Xen pixbuf)
{
  #define H_gtk_image_set_from_pixbuf "void gtk_image_set_from_pixbuf(GtkImage* image, GdkPixbuf* pixbuf)"
  Xen_check_type(Xen_is_GtkImage_(image), image, 1, "gtk_image_set_from_pixbuf", "GtkImage*");
  Xen_check_type(Xen_is_GdkPixbuf_(pixbuf) || Xen_is_false(pixbuf), pixbuf, 2, "gtk_image_set_from_pixbuf", "GdkPixbuf*");
  gtk_image_set_from_pixbuf(Xen_to_C_GtkImage_(image), Xen_to_C_GdkPixbuf_(pixbuf));
  return(Xen_false);
}

static Xen gxg_gtk_image_get_storage_type(Xen image)
{
  #define H_gtk_image_get_storage_type "GtkImageType gtk_image_get_storage_type(GtkImage* image)"
  Xen_check_type(Xen_is_GtkImage_(image), image, 1, "gtk_image_get_storage_type", "GtkImage*");
  return(C_to_Xen_GtkImageType(gtk_image_get_storage_type(Xen_to_C_GtkImage_(image))));
}

static Xen gxg_gtk_im_context_get_preedit_string(Xen context, Xen ignore_str, Xen ignore_attrs, Xen ignore_cursor_pos)
{
  #define H_gtk_im_context_get_preedit_string "void gtk_im_context_get_preedit_string(GtkIMContext* context, \
gchar** [str], PangoAttrList** [attrs], gint* [cursor_pos])"
  gchar* ref_str = NULL;
  PangoAttrList* ref_attrs = NULL;
  gint ref_cursor_pos;
  Xen_check_type(Xen_is_GtkIMContext_(context), context, 1, "gtk_im_context_get_preedit_string", "GtkIMContext*");
  gtk_im_context_get_preedit_string(Xen_to_C_GtkIMContext_(context), &ref_str, &ref_attrs, &ref_cursor_pos);
  return(Xen_list_3(C_to_Xen_gchar_(ref_str), C_to_Xen_PangoAttrList_(ref_attrs), C_to_Xen_gint(ref_cursor_pos)));
}

static Xen gxg_gtk_im_context_focus_in(Xen context)
{
  #define H_gtk_im_context_focus_in "void gtk_im_context_focus_in(GtkIMContext* context)"
  Xen_check_type(Xen_is_GtkIMContext_(context), context, 1, "gtk_im_context_focus_in", "GtkIMContext*");
  gtk_im_context_focus_in(Xen_to_C_GtkIMContext_(context));
  return(Xen_false);
}

static Xen gxg_gtk_im_context_focus_out(Xen context)
{
  #define H_gtk_im_context_focus_out "void gtk_im_context_focus_out(GtkIMContext* context)"
  Xen_check_type(Xen_is_GtkIMContext_(context), context, 1, "gtk_im_context_focus_out", "GtkIMContext*");
  gtk_im_context_focus_out(Xen_to_C_GtkIMContext_(context));
  return(Xen_false);
}

static Xen gxg_gtk_im_context_reset(Xen context)
{
  #define H_gtk_im_context_reset "void gtk_im_context_reset(GtkIMContext* context)"
  Xen_check_type(Xen_is_GtkIMContext_(context), context, 1, "gtk_im_context_reset", "GtkIMContext*");
  gtk_im_context_reset(Xen_to_C_GtkIMContext_(context));
  return(Xen_false);
}

static Xen gxg_gtk_im_context_set_cursor_location(Xen context, Xen area)
{
  #define H_gtk_im_context_set_cursor_location "void gtk_im_context_set_cursor_location(GtkIMContext* context, \
GdkRectangle* area)"
  Xen_check_type(Xen_is_GtkIMContext_(context), context, 1, "gtk_im_context_set_cursor_location", "GtkIMContext*");
  Xen_check_type(Xen_is_GdkRectangle_(area), area, 2, "gtk_im_context_set_cursor_location", "GdkRectangle*");
  gtk_im_context_set_cursor_location(Xen_to_C_GtkIMContext_(context), Xen_to_C_GdkRectangle_(area));
  return(Xen_false);
}

static Xen gxg_gtk_im_context_set_use_preedit(Xen context, Xen use_preedit)
{
  #define H_gtk_im_context_set_use_preedit "void gtk_im_context_set_use_preedit(GtkIMContext* context, \
gboolean use_preedit)"
  Xen_check_type(Xen_is_GtkIMContext_(context), context, 1, "gtk_im_context_set_use_preedit", "GtkIMContext*");
  Xen_check_type(Xen_is_gboolean(use_preedit), use_preedit, 2, "gtk_im_context_set_use_preedit", "gboolean");
  gtk_im_context_set_use_preedit(Xen_to_C_GtkIMContext_(context), Xen_to_C_gboolean(use_preedit));
  return(Xen_false);
}

static Xen gxg_gtk_im_context_set_surrounding(Xen context, Xen text, Xen len, Xen cursor_index)
{
  #define H_gtk_im_context_set_surrounding "void gtk_im_context_set_surrounding(GtkIMContext* context, \
gchar* text, gint len, gint cursor_index)"
  Xen_check_type(Xen_is_GtkIMContext_(context), context, 1, "gtk_im_context_set_surrounding", "GtkIMContext*");
  Xen_check_type(Xen_is_gchar_(text), text, 2, "gtk_im_context_set_surrounding", "gchar*");
  Xen_check_type(Xen_is_gint(len), len, 3, "gtk_im_context_set_surrounding", "gint");
  Xen_check_type(Xen_is_gint(cursor_index), cursor_index, 4, "gtk_im_context_set_surrounding", "gint");
  gtk_im_context_set_surrounding(Xen_to_C_GtkIMContext_(context), Xen_to_C_gchar_(text), Xen_to_C_gint(len), Xen_to_C_gint(cursor_index));
  return(Xen_false);
}

static Xen gxg_gtk_im_context_get_surrounding(Xen context, Xen ignore_text, Xen ignore_cursor_index)
{
  #define H_gtk_im_context_get_surrounding "gboolean gtk_im_context_get_surrounding(GtkIMContext* context, \
gchar** [text], gint* [cursor_index])"
  gchar* ref_text = NULL;
  gint ref_cursor_index;
  Xen_check_type(Xen_is_GtkIMContext_(context), context, 1, "gtk_im_context_get_surrounding", "GtkIMContext*");
  {
    Xen res_ult;
    res_ult = C_to_Xen_gboolean(gtk_im_context_get_surrounding(Xen_to_C_GtkIMContext_(context), &ref_text, &ref_cursor_index));
    return(Xen_list_3(res_ult, C_to_Xen_gchar_(ref_text), C_to_Xen_gint(ref_cursor_index)));
   }
}

static Xen gxg_gtk_im_context_delete_surrounding(Xen context, Xen offset, Xen n_chars)
{
  #define H_gtk_im_context_delete_surrounding "gboolean gtk_im_context_delete_surrounding(GtkIMContext* context, \
gint offset, gint n_chars)"
  Xen_check_type(Xen_is_GtkIMContext_(context), context, 1, "gtk_im_context_delete_surrounding", "GtkIMContext*");
  Xen_check_type(Xen_is_gint(offset), offset, 2, "gtk_im_context_delete_surrounding", "gint");
  Xen_check_type(Xen_is_gint(n_chars), n_chars, 3, "gtk_im_context_delete_surrounding", "gint");
  return(C_to_Xen_gboolean(gtk_im_context_delete_surrounding(Xen_to_C_GtkIMContext_(context), Xen_to_C_gint(offset), Xen_to_C_gint(n_chars))));
}

static Xen gxg_gtk_im_context_simple_new(void)
{
  #define H_gtk_im_context_simple_new "GtkIMContext* gtk_im_context_simple_new( void)"
  return(C_to_Xen_GtkIMContext_(gtk_im_context_simple_new()));
}

static Xen gxg_gtk_im_context_simple_add_table(Xen context_simple, Xen data, Xen max_seq_len, Xen n_seqs)
{
  #define H_gtk_im_context_simple_add_table "void gtk_im_context_simple_add_table(GtkIMContextSimple* context_simple, \
guint16* data, gint max_seq_len, gint n_seqs)"
  Xen_check_type(Xen_is_GtkIMContextSimple_(context_simple), context_simple, 1, "gtk_im_context_simple_add_table", "GtkIMContextSimple*");
  Xen_check_type(Xen_is_guint16_(data), data, 2, "gtk_im_context_simple_add_table", "guint16*");
  Xen_check_type(Xen_is_gint(max_seq_len), max_seq_len, 3, "gtk_im_context_simple_add_table", "gint");
  Xen_check_type(Xen_is_gint(n_seqs), n_seqs, 4, "gtk_im_context_simple_add_table", "gint");
  gtk_im_context_simple_add_table(Xen_to_C_GtkIMContextSimple_(context_simple), Xen_to_C_guint16_(data), Xen_to_C_gint(max_seq_len), 
                                  Xen_to_C_gint(n_seqs));
  return(Xen_false);
}

static Xen gxg_gtk_label_new(Xen str)
{
  #define H_gtk_label_new "GtkWidget* gtk_label_new(char* str)"
  Xen_check_type(Xen_is_char_(str), str, 1, "gtk_label_new", "char*");
  return(C_to_Xen_GtkWidget_(gtk_label_new(Xen_to_C_char_(str))));
}

static Xen gxg_gtk_label_new_with_mnemonic(Xen str)
{
  #define H_gtk_label_new_with_mnemonic "GtkWidget* gtk_label_new_with_mnemonic(char* str)"
  Xen_check_type(Xen_is_char_(str), str, 1, "gtk_label_new_with_mnemonic", "char*");
  return(C_to_Xen_GtkWidget_(gtk_label_new_with_mnemonic(Xen_to_C_char_(str))));
}

static Xen gxg_gtk_label_set_text(Xen label, Xen str)
{
  #define H_gtk_label_set_text "void gtk_label_set_text(GtkLabel* label, char* str)"
  Xen_check_type(Xen_is_GtkLabel_(label), label, 1, "gtk_label_set_text", "GtkLabel*");
  Xen_check_type(Xen_is_char_(str), str, 2, "gtk_label_set_text", "char*");
  gtk_label_set_text(Xen_to_C_GtkLabel_(label), Xen_to_C_char_(str));
  return(Xen_false);
}

static Xen gxg_gtk_label_get_text(Xen label)
{
  #define H_gtk_label_get_text "gchar* gtk_label_get_text(GtkLabel* label)"
  Xen_check_type(Xen_is_GtkLabel_(label), label, 1, "gtk_label_get_text", "GtkLabel*");
  return(C_to_Xen_gchar_(gtk_label_get_text(Xen_to_C_GtkLabel_(label))));
}

static Xen gxg_gtk_label_set_attributes(Xen label, Xen attrs)
{
  #define H_gtk_label_set_attributes "void gtk_label_set_attributes(GtkLabel* label, PangoAttrList* attrs)"
  Xen_check_type(Xen_is_GtkLabel_(label), label, 1, "gtk_label_set_attributes", "GtkLabel*");
  Xen_check_type(Xen_is_PangoAttrList_(attrs), attrs, 2, "gtk_label_set_attributes", "PangoAttrList*");
  gtk_label_set_attributes(Xen_to_C_GtkLabel_(label), Xen_to_C_PangoAttrList_(attrs));
  return(Xen_false);
}

static Xen gxg_gtk_label_get_attributes(Xen label)
{
  #define H_gtk_label_get_attributes "PangoAttrList* gtk_label_get_attributes(GtkLabel* label)"
  Xen_check_type(Xen_is_GtkLabel_(label), label, 1, "gtk_label_get_attributes", "GtkLabel*");
  return(C_to_Xen_PangoAttrList_(gtk_label_get_attributes(Xen_to_C_GtkLabel_(label))));
}

static Xen gxg_gtk_label_set_label(Xen label, Xen str)
{
  #define H_gtk_label_set_label "void gtk_label_set_label(GtkLabel* label, gchar* str)"
  Xen_check_type(Xen_is_GtkLabel_(label), label, 1, "gtk_label_set_label", "GtkLabel*");
  Xen_check_type(Xen_is_gchar_(str), str, 2, "gtk_label_set_label", "gchar*");
  gtk_label_set_label(Xen_to_C_GtkLabel_(label), Xen_to_C_gchar_(str));
  return(Xen_false);
}

static Xen gxg_gtk_label_get_label(Xen label)
{
  #define H_gtk_label_get_label "gchar* gtk_label_get_label(GtkLabel* label)"
  Xen_check_type(Xen_is_GtkLabel_(label), label, 1, "gtk_label_get_label", "GtkLabel*");
  return(C_to_Xen_gchar_(gtk_label_get_label(Xen_to_C_GtkLabel_(label))));
}

static Xen gxg_gtk_label_set_markup(Xen label, Xen str)
{
  #define H_gtk_label_set_markup "void gtk_label_set_markup(GtkLabel* label, gchar* str)"
  Xen_check_type(Xen_is_GtkLabel_(label), label, 1, "gtk_label_set_markup", "GtkLabel*");
  Xen_check_type(Xen_is_gchar_(str), str, 2, "gtk_label_set_markup", "gchar*");
  gtk_label_set_markup(Xen_to_C_GtkLabel_(label), Xen_to_C_gchar_(str));
  return(Xen_false);
}

static Xen gxg_gtk_label_set_use_markup(Xen label, Xen setting)
{
  #define H_gtk_label_set_use_markup "void gtk_label_set_use_markup(GtkLabel* label, gboolean setting)"
  Xen_check_type(Xen_is_GtkLabel_(label), label, 1, "gtk_label_set_use_markup", "GtkLabel*");
  Xen_check_type(Xen_is_gboolean(setting), setting, 2, "gtk_label_set_use_markup", "gboolean");
  gtk_label_set_use_markup(Xen_to_C_GtkLabel_(label), Xen_to_C_gboolean(setting));
  return(Xen_false);
}

static Xen gxg_gtk_label_get_use_markup(Xen label)
{
  #define H_gtk_label_get_use_markup "gboolean gtk_label_get_use_markup(GtkLabel* label)"
  Xen_check_type(Xen_is_GtkLabel_(label), label, 1, "gtk_label_get_use_markup", "GtkLabel*");
  return(C_to_Xen_gboolean(gtk_label_get_use_markup(Xen_to_C_GtkLabel_(label))));
}

static Xen gxg_gtk_label_set_use_underline(Xen label, Xen setting)
{
  #define H_gtk_label_set_use_underline "void gtk_label_set_use_underline(GtkLabel* label, gboolean setting)"
  Xen_check_type(Xen_is_GtkLabel_(label), label, 1, "gtk_label_set_use_underline", "GtkLabel*");
  Xen_check_type(Xen_is_gboolean(setting), setting, 2, "gtk_label_set_use_underline", "gboolean");
  gtk_label_set_use_underline(Xen_to_C_GtkLabel_(label), Xen_to_C_gboolean(setting));
  return(Xen_false);
}

static Xen gxg_gtk_label_get_use_underline(Xen label)
{
  #define H_gtk_label_get_use_underline "gboolean gtk_label_get_use_underline(GtkLabel* label)"
  Xen_check_type(Xen_is_GtkLabel_(label), label, 1, "gtk_label_get_use_underline", "GtkLabel*");
  return(C_to_Xen_gboolean(gtk_label_get_use_underline(Xen_to_C_GtkLabel_(label))));
}

static Xen gxg_gtk_label_set_markup_with_mnemonic(Xen label, Xen str)
{
  #define H_gtk_label_set_markup_with_mnemonic "void gtk_label_set_markup_with_mnemonic(GtkLabel* label, \
gchar* str)"
  Xen_check_type(Xen_is_GtkLabel_(label), label, 1, "gtk_label_set_markup_with_mnemonic", "GtkLabel*");
  Xen_check_type(Xen_is_gchar_(str), str, 2, "gtk_label_set_markup_with_mnemonic", "gchar*");
  gtk_label_set_markup_with_mnemonic(Xen_to_C_GtkLabel_(label), Xen_to_C_gchar_(str));
  return(Xen_false);
}

static Xen gxg_gtk_label_get_mnemonic_keyval(Xen label)
{
  #define H_gtk_label_get_mnemonic_keyval "guint gtk_label_get_mnemonic_keyval(GtkLabel* label)"
  Xen_check_type(Xen_is_GtkLabel_(label), label, 1, "gtk_label_get_mnemonic_keyval", "GtkLabel*");
  return(C_to_Xen_guint(gtk_label_get_mnemonic_keyval(Xen_to_C_GtkLabel_(label))));
}

static Xen gxg_gtk_label_set_mnemonic_widget(Xen label, Xen widget)
{
  #define H_gtk_label_set_mnemonic_widget "void gtk_label_set_mnemonic_widget(GtkLabel* label, GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkLabel_(label), label, 1, "gtk_label_set_mnemonic_widget", "GtkLabel*");
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 2, "gtk_label_set_mnemonic_widget", "GtkWidget*");
  gtk_label_set_mnemonic_widget(Xen_to_C_GtkLabel_(label), Xen_to_C_GtkWidget_(widget));
  return(Xen_false);
}

static Xen gxg_gtk_label_get_mnemonic_widget(Xen label)
{
  #define H_gtk_label_get_mnemonic_widget "GtkWidget* gtk_label_get_mnemonic_widget(GtkLabel* label)"
  Xen_check_type(Xen_is_GtkLabel_(label), label, 1, "gtk_label_get_mnemonic_widget", "GtkLabel*");
  return(C_to_Xen_GtkWidget_(gtk_label_get_mnemonic_widget(Xen_to_C_GtkLabel_(label))));
}

static Xen gxg_gtk_label_set_text_with_mnemonic(Xen label, Xen str)
{
  #define H_gtk_label_set_text_with_mnemonic "void gtk_label_set_text_with_mnemonic(GtkLabel* label, \
gchar* str)"
  Xen_check_type(Xen_is_GtkLabel_(label), label, 1, "gtk_label_set_text_with_mnemonic", "GtkLabel*");
  Xen_check_type(Xen_is_gchar_(str), str, 2, "gtk_label_set_text_with_mnemonic", "gchar*");
  gtk_label_set_text_with_mnemonic(Xen_to_C_GtkLabel_(label), Xen_to_C_gchar_(str));
  return(Xen_false);
}

static Xen gxg_gtk_label_set_justify(Xen label, Xen jtype)
{
  #define H_gtk_label_set_justify "void gtk_label_set_justify(GtkLabel* label, GtkJustification jtype)"
  Xen_check_type(Xen_is_GtkLabel_(label), label, 1, "gtk_label_set_justify", "GtkLabel*");
  Xen_check_type(Xen_is_GtkJustification(jtype), jtype, 2, "gtk_label_set_justify", "GtkJustification");
  gtk_label_set_justify(Xen_to_C_GtkLabel_(label), Xen_to_C_GtkJustification(jtype));
  return(Xen_false);
}

static Xen gxg_gtk_label_get_justify(Xen label)
{
  #define H_gtk_label_get_justify "GtkJustification gtk_label_get_justify(GtkLabel* label)"
  Xen_check_type(Xen_is_GtkLabel_(label), label, 1, "gtk_label_get_justify", "GtkLabel*");
  return(C_to_Xen_GtkJustification(gtk_label_get_justify(Xen_to_C_GtkLabel_(label))));
}

static Xen gxg_gtk_label_set_selectable(Xen label, Xen setting)
{
  #define H_gtk_label_set_selectable "void gtk_label_set_selectable(GtkLabel* label, gboolean setting)"
  Xen_check_type(Xen_is_GtkLabel_(label), label, 1, "gtk_label_set_selectable", "GtkLabel*");
  Xen_check_type(Xen_is_gboolean(setting), setting, 2, "gtk_label_set_selectable", "gboolean");
  gtk_label_set_selectable(Xen_to_C_GtkLabel_(label), Xen_to_C_gboolean(setting));
  return(Xen_false);
}

static Xen gxg_gtk_label_get_selectable(Xen label)
{
  #define H_gtk_label_get_selectable "gboolean gtk_label_get_selectable(GtkLabel* label)"
  Xen_check_type(Xen_is_GtkLabel_(label), label, 1, "gtk_label_get_selectable", "GtkLabel*");
  return(C_to_Xen_gboolean(gtk_label_get_selectable(Xen_to_C_GtkLabel_(label))));
}

static Xen gxg_gtk_label_select_region(Xen label, Xen start_offset, Xen end_offset)
{
  #define H_gtk_label_select_region "void gtk_label_select_region(GtkLabel* label, gint start_offset, \
gint end_offset)"
  Xen_check_type(Xen_is_GtkLabel_(label), label, 1, "gtk_label_select_region", "GtkLabel*");
  Xen_check_type(Xen_is_gint(start_offset), start_offset, 2, "gtk_label_select_region", "gint");
  Xen_check_type(Xen_is_gint(end_offset), end_offset, 3, "gtk_label_select_region", "gint");
  gtk_label_select_region(Xen_to_C_GtkLabel_(label), Xen_to_C_gint(start_offset), Xen_to_C_gint(end_offset));
  return(Xen_false);
}

static Xen gxg_gtk_label_get_selection_bounds(Xen label, Xen ignore_start, Xen ignore_end)
{
  #define H_gtk_label_get_selection_bounds "gboolean gtk_label_get_selection_bounds(GtkLabel* label, \
gint* [start], gint* [end])"
  gint ref_start;
  gint ref_end;
  Xen_check_type(Xen_is_GtkLabel_(label), label, 1, "gtk_label_get_selection_bounds", "GtkLabel*");
  {
    Xen res_ult;
    res_ult = C_to_Xen_gboolean(gtk_label_get_selection_bounds(Xen_to_C_GtkLabel_(label), &ref_start, &ref_end));
    return(Xen_list_3(res_ult, C_to_Xen_gint(ref_start), C_to_Xen_gint(ref_end)));
   }
}

static Xen gxg_gtk_label_get_layout(Xen label)
{
  #define H_gtk_label_get_layout "PangoLayout* gtk_label_get_layout(GtkLabel* label)"
  Xen_check_type(Xen_is_GtkLabel_(label), label, 1, "gtk_label_get_layout", "GtkLabel*");
  return(C_to_Xen_PangoLayout_(gtk_label_get_layout(Xen_to_C_GtkLabel_(label))));
}

static Xen gxg_gtk_label_get_layout_offsets(Xen label, Xen ignore_x, Xen ignore_y)
{
  #define H_gtk_label_get_layout_offsets "void gtk_label_get_layout_offsets(GtkLabel* label, gint* [x], \
gint* [y])"
  gint ref_x;
  gint ref_y;
  Xen_check_type(Xen_is_GtkLabel_(label), label, 1, "gtk_label_get_layout_offsets", "GtkLabel*");
  gtk_label_get_layout_offsets(Xen_to_C_GtkLabel_(label), &ref_x, &ref_y);
  return(Xen_list_2(C_to_Xen_gint(ref_x), C_to_Xen_gint(ref_y)));
}

static Xen gxg_gtk_list_store_new(Xen n_columns, Xen types)
{
  #define H_gtk_list_store_new "GtkListStore* gtk_list_store_new(gint n_columns, etc types)"
  Xen_check_type(Xen_is_gint(n_columns), n_columns, 1, "gtk_list_store_new", "gint");
  Xen_check_type(Xen_is_etc(types), types, 2, "gtk_list_store_new", "etc");
  {
    int etc_len = 0;
    GtkListStore* res_ult = NULL;
    gint p_arg0;
    if (Xen_is_list(types)) etc_len = Xen_list_length(types);
    if (etc_len < 1) Xen_out_of_range_error("gtk_list_store_new", 1, types, "... list must have at least 1 entry");
    if (etc_len > 6) Xen_out_of_range_error("gtk_list_store_new", 1, types, "... list too long (max len: 6)");
    p_arg0 = Xen_to_C_gint(n_columns);
    switch (etc_len)
      {
        case 1: res_ult = gtk_list_store_new(p_arg0, XLG(types, 0)); break;
        case 2: res_ult = gtk_list_store_new(p_arg0, XLG(types, 0), XLG(types, 1)); break;
        case 3: res_ult = gtk_list_store_new(p_arg0, XLG(types, 0), XLG(types, 1), XLG(types, 2)); break;
        case 4: res_ult = gtk_list_store_new(p_arg0, XLG(types, 0), XLG(types, 1), XLG(types, 2), XLG(types, 3)); break;
        case 5: res_ult = gtk_list_store_new(p_arg0, XLG(types, 0), XLG(types, 1), XLG(types, 2), XLG(types, 3), XLG(types, 4)); break;
        case 6: res_ult = gtk_list_store_new(p_arg0, XLG(types, 0), XLG(types, 1), XLG(types, 2), XLG(types, 3), XLG(types, 4), XLG(types, 5)); break;
      }
    return(C_to_Xen_GtkListStore_(res_ult));
  }
}

static Xen gxg_gtk_list_store_newv(Xen n_columns, Xen types)
{
  #define H_gtk_list_store_newv "GtkListStore* gtk_list_store_newv(gint n_columns, GType* types)"
  Xen_check_type(Xen_is_gint(n_columns), n_columns, 1, "gtk_list_store_newv", "gint");
  Xen_check_type(Xen_is_GType_(types), types, 2, "gtk_list_store_newv", "GType*");
  return(C_to_Xen_GtkListStore_(gtk_list_store_newv(Xen_to_C_gint(n_columns), Xen_to_C_GType_(types))));
}

static Xen gxg_gtk_list_store_set_column_types(Xen list_store, Xen n_columns, Xen types)
{
  #define H_gtk_list_store_set_column_types "void gtk_list_store_set_column_types(GtkListStore* list_store, \
gint n_columns, GType* types)"
  Xen_check_type(Xen_is_GtkListStore_(list_store), list_store, 1, "gtk_list_store_set_column_types", "GtkListStore*");
  Xen_check_type(Xen_is_gint(n_columns), n_columns, 2, "gtk_list_store_set_column_types", "gint");
  Xen_check_type(Xen_is_GType_(types), types, 3, "gtk_list_store_set_column_types", "GType*");
  gtk_list_store_set_column_types(Xen_to_C_GtkListStore_(list_store), Xen_to_C_gint(n_columns), Xen_to_C_GType_(types));
  return(Xen_false);
}

static Xen gxg_gtk_list_store_set(Xen list_store, Xen iter, Xen values)
{
  #define H_gtk_list_store_set "void gtk_list_store_set(GtkListStore* list_store, GtkTreeIter* iter, \
etc values)"
  Xen_check_type(Xen_is_GtkListStore_(list_store), list_store, 1, "gtk_list_store_set", "GtkListStore*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_list_store_set", "GtkTreeIter*");
  Xen_check_type(Xen_is_etc(values), values, 3, "gtk_list_store_set", "etc");
  {
    int etc_len = 0;
    GtkListStore* p_arg0;
    GtkTreeIter* p_arg1;
    if (Xen_is_list(values)) etc_len = Xen_list_length(values);
    if (etc_len < 2) Xen_out_of_range_error("gtk_list_store_set", 2, values, "... list must have at least 2 entries");
    if (etc_len > 10) Xen_out_of_range_error("gtk_list_store_set", 2, values, "... list too long (max len: 10)");
    if ((etc_len % 2) != 0) Xen_out_of_range_error("gtk_list_store_set", 2, values, "... list len must be multiple of 2");
    p_arg0 = Xen_to_C_GtkListStore_(list_store);
    p_arg1 = Xen_to_C_GtkTreeIter_(iter);
    switch (etc_len)
      {
        case 2: gtk_list_store_set(p_arg0, p_arg1, XLI(values, 0), XLS(values, 1), -1); break;
        case 4: gtk_list_store_set(p_arg0, p_arg1, XLI(values, 0), XLS(values, 1), XLI(values, 2), XLS(values, 3), -1); break;
        case 6: gtk_list_store_set(p_arg0, p_arg1, XLI(values, 0), XLS(values, 1), XLI(values, 2), XLS(values, 3), XLI(values, 4), XLS(values, 5), -1); break;
        case 8: gtk_list_store_set(p_arg0, p_arg1, XLI(values, 0), XLS(values, 1), XLI(values, 2), XLS(values, 3), XLI(values, 4), XLS(values, 5), XLI(values, 6), XLS(values, 7), -1); break;
        case 10: gtk_list_store_set(p_arg0, p_arg1, XLI(values, 0), XLS(values, 1), XLI(values, 2), XLS(values, 3), XLI(values, 4), XLS(values, 5), XLI(values, 6), XLS(values, 7), XLI(values, 8), XLS(values, 9), -1); break;
      }
    return(Xen_false);
  }
}

static Xen gxg_gtk_list_store_insert(Xen list_store, Xen iter, Xen position)
{
  #define H_gtk_list_store_insert "void gtk_list_store_insert(GtkListStore* list_store, GtkTreeIter* iter, \
gint position)"
  Xen_check_type(Xen_is_GtkListStore_(list_store), list_store, 1, "gtk_list_store_insert", "GtkListStore*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_list_store_insert", "GtkTreeIter*");
  Xen_check_type(Xen_is_gint(position), position, 3, "gtk_list_store_insert", "gint");
  gtk_list_store_insert(Xen_to_C_GtkListStore_(list_store), Xen_to_C_GtkTreeIter_(iter), Xen_to_C_gint(position));
  return(Xen_false);
}

static Xen gxg_gtk_list_store_insert_before(Xen list_store, Xen iter, Xen sibling)
{
  #define H_gtk_list_store_insert_before "void gtk_list_store_insert_before(GtkListStore* list_store, \
GtkTreeIter* iter, GtkTreeIter* sibling)"
  Xen_check_type(Xen_is_GtkListStore_(list_store), list_store, 1, "gtk_list_store_insert_before", "GtkListStore*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_list_store_insert_before", "GtkTreeIter*");
  Xen_check_type(Xen_is_GtkTreeIter_(sibling) || Xen_is_false(sibling), sibling, 3, "gtk_list_store_insert_before", "GtkTreeIter*");
  gtk_list_store_insert_before(Xen_to_C_GtkListStore_(list_store), Xen_to_C_GtkTreeIter_(iter), Xen_to_C_GtkTreeIter_(sibling));
  return(Xen_false);
}

static Xen gxg_gtk_list_store_insert_after(Xen list_store, Xen iter, Xen sibling)
{
  #define H_gtk_list_store_insert_after "void gtk_list_store_insert_after(GtkListStore* list_store, GtkTreeIter* iter, \
GtkTreeIter* sibling)"
  Xen_check_type(Xen_is_GtkListStore_(list_store), list_store, 1, "gtk_list_store_insert_after", "GtkListStore*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_list_store_insert_after", "GtkTreeIter*");
  Xen_check_type(Xen_is_GtkTreeIter_(sibling) || Xen_is_false(sibling), sibling, 3, "gtk_list_store_insert_after", "GtkTreeIter*");
  gtk_list_store_insert_after(Xen_to_C_GtkListStore_(list_store), Xen_to_C_GtkTreeIter_(iter), Xen_to_C_GtkTreeIter_(sibling));
  return(Xen_false);
}

static Xen gxg_gtk_list_store_prepend(Xen list_store, Xen iter)
{
  #define H_gtk_list_store_prepend "void gtk_list_store_prepend(GtkListStore* list_store, GtkTreeIter* iter)"
  Xen_check_type(Xen_is_GtkListStore_(list_store), list_store, 1, "gtk_list_store_prepend", "GtkListStore*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_list_store_prepend", "GtkTreeIter*");
  gtk_list_store_prepend(Xen_to_C_GtkListStore_(list_store), Xen_to_C_GtkTreeIter_(iter));
  return(Xen_false);
}

static Xen gxg_gtk_list_store_append(Xen list_store, Xen iter)
{
  #define H_gtk_list_store_append "void gtk_list_store_append(GtkListStore* list_store, GtkTreeIter* iter)"
  Xen_check_type(Xen_is_GtkListStore_(list_store), list_store, 1, "gtk_list_store_append", "GtkListStore*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_list_store_append", "GtkTreeIter*");
  gtk_list_store_append(Xen_to_C_GtkListStore_(list_store), Xen_to_C_GtkTreeIter_(iter));
  return(Xen_false);
}

static Xen gxg_gtk_list_store_clear(Xen list_store)
{
  #define H_gtk_list_store_clear "void gtk_list_store_clear(GtkListStore* list_store)"
  Xen_check_type(Xen_is_GtkListStore_(list_store), list_store, 1, "gtk_list_store_clear", "GtkListStore*");
  gtk_list_store_clear(Xen_to_C_GtkListStore_(list_store));
  return(Xen_false);
}

static Xen gxg_gtk_check_version(Xen required_major, Xen required_minor, Xen required_micro)
{
  #define H_gtk_check_version "gchar* gtk_check_version(guint required_major, guint required_minor, guint required_micro)"
  Xen_check_type(Xen_is_guint(required_major), required_major, 1, "gtk_check_version", "guint");
  Xen_check_type(Xen_is_guint(required_minor), required_minor, 2, "gtk_check_version", "guint");
  Xen_check_type(Xen_is_guint(required_micro), required_micro, 3, "gtk_check_version", "guint");
    return(C_to_Xen_gchar_((gchar*)gtk_check_version(Xen_to_C_guint(required_major), Xen_to_C_guint(required_minor), Xen_to_C_guint(required_micro))));
}

static Xen gxg_gtk_disable_setlocale(void)
{
  #define H_gtk_disable_setlocale "void gtk_disable_setlocale( void)"
  gtk_disable_setlocale();
  return(Xen_false);
}

static Xen gxg_gtk_get_default_language(void)
{
  #define H_gtk_get_default_language "PangoLanguage* gtk_get_default_language( void)"
  return(C_to_Xen_PangoLanguage_(gtk_get_default_language()));
}

static Xen gxg_gtk_notebook_new(void)
{
  #define H_gtk_notebook_new "GtkWidget* gtk_notebook_new( void)"
  return(C_to_Xen_GtkWidget_(gtk_notebook_new()));
}

static Xen gxg_gtk_notebook_remove_page(Xen notebook, Xen page_num)
{
  #define H_gtk_notebook_remove_page "void gtk_notebook_remove_page(GtkNotebook* notebook, gint page_num)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_remove_page", "GtkNotebook*");
  Xen_check_type(Xen_is_gint(page_num), page_num, 2, "gtk_notebook_remove_page", "gint");
  gtk_notebook_remove_page(Xen_to_C_GtkNotebook_(notebook), Xen_to_C_gint(page_num));
  return(Xen_false);
}

static Xen gxg_gtk_notebook_get_current_page(Xen notebook)
{
  #define H_gtk_notebook_get_current_page "gint gtk_notebook_get_current_page(GtkNotebook* notebook)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_get_current_page", "GtkNotebook*");
  return(C_to_Xen_gint(gtk_notebook_get_current_page(Xen_to_C_GtkNotebook_(notebook))));
}

static Xen gxg_gtk_notebook_get_nth_page(Xen notebook, Xen page_num)
{
  #define H_gtk_notebook_get_nth_page "GtkWidget* gtk_notebook_get_nth_page(GtkNotebook* notebook, gint page_num)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_get_nth_page", "GtkNotebook*");
  Xen_check_type(Xen_is_gint(page_num), page_num, 2, "gtk_notebook_get_nth_page", "gint");
  return(C_to_Xen_GtkWidget_(gtk_notebook_get_nth_page(Xen_to_C_GtkNotebook_(notebook), Xen_to_C_gint(page_num))));
}

static Xen gxg_gtk_notebook_page_num(Xen notebook, Xen child)
{
  #define H_gtk_notebook_page_num "gint gtk_notebook_page_num(GtkNotebook* notebook, GtkWidget* child)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_page_num", "GtkNotebook*");
  Xen_check_type(Xen_is_GtkWidget_(child), child, 2, "gtk_notebook_page_num", "GtkWidget*");
  return(C_to_Xen_gint(gtk_notebook_page_num(Xen_to_C_GtkNotebook_(notebook), Xen_to_C_GtkWidget_(child))));
}

static Xen gxg_gtk_notebook_set_current_page(Xen notebook, Xen page_num)
{
  #define H_gtk_notebook_set_current_page "void gtk_notebook_set_current_page(GtkNotebook* notebook, \
gint page_num)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_set_current_page", "GtkNotebook*");
  Xen_check_type(Xen_is_gint(page_num), page_num, 2, "gtk_notebook_set_current_page", "gint");
  gtk_notebook_set_current_page(Xen_to_C_GtkNotebook_(notebook), Xen_to_C_gint(page_num));
  return(Xen_false);
}

static Xen gxg_gtk_notebook_next_page(Xen notebook)
{
  #define H_gtk_notebook_next_page "void gtk_notebook_next_page(GtkNotebook* notebook)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_next_page", "GtkNotebook*");
  gtk_notebook_next_page(Xen_to_C_GtkNotebook_(notebook));
  return(Xen_false);
}

static Xen gxg_gtk_notebook_prev_page(Xen notebook)
{
  #define H_gtk_notebook_prev_page "void gtk_notebook_prev_page(GtkNotebook* notebook)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_prev_page", "GtkNotebook*");
  gtk_notebook_prev_page(Xen_to_C_GtkNotebook_(notebook));
  return(Xen_false);
}

static Xen gxg_gtk_notebook_set_show_border(Xen notebook, Xen show_border)
{
  #define H_gtk_notebook_set_show_border "void gtk_notebook_set_show_border(GtkNotebook* notebook, gboolean show_border)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_set_show_border", "GtkNotebook*");
  Xen_check_type(Xen_is_gboolean(show_border), show_border, 2, "gtk_notebook_set_show_border", "gboolean");
  gtk_notebook_set_show_border(Xen_to_C_GtkNotebook_(notebook), Xen_to_C_gboolean(show_border));
  return(Xen_false);
}

static Xen gxg_gtk_notebook_get_show_border(Xen notebook)
{
  #define H_gtk_notebook_get_show_border "gboolean gtk_notebook_get_show_border(GtkNotebook* notebook)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_get_show_border", "GtkNotebook*");
  return(C_to_Xen_gboolean(gtk_notebook_get_show_border(Xen_to_C_GtkNotebook_(notebook))));
}

static Xen gxg_gtk_notebook_set_show_tabs(Xen notebook, Xen show_tabs)
{
  #define H_gtk_notebook_set_show_tabs "void gtk_notebook_set_show_tabs(GtkNotebook* notebook, gboolean show_tabs)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_set_show_tabs", "GtkNotebook*");
  Xen_check_type(Xen_is_gboolean(show_tabs), show_tabs, 2, "gtk_notebook_set_show_tabs", "gboolean");
  gtk_notebook_set_show_tabs(Xen_to_C_GtkNotebook_(notebook), Xen_to_C_gboolean(show_tabs));
  return(Xen_false);
}

static Xen gxg_gtk_notebook_get_show_tabs(Xen notebook)
{
  #define H_gtk_notebook_get_show_tabs "gboolean gtk_notebook_get_show_tabs(GtkNotebook* notebook)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_get_show_tabs", "GtkNotebook*");
  return(C_to_Xen_gboolean(gtk_notebook_get_show_tabs(Xen_to_C_GtkNotebook_(notebook))));
}

static Xen gxg_gtk_notebook_set_tab_pos(Xen notebook, Xen pos)
{
  #define H_gtk_notebook_set_tab_pos "void gtk_notebook_set_tab_pos(GtkNotebook* notebook, GtkPositionType pos)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_set_tab_pos", "GtkNotebook*");
  Xen_check_type(Xen_is_GtkPositionType(pos), pos, 2, "gtk_notebook_set_tab_pos", "GtkPositionType");
  gtk_notebook_set_tab_pos(Xen_to_C_GtkNotebook_(notebook), Xen_to_C_GtkPositionType(pos));
  return(Xen_false);
}

static Xen gxg_gtk_notebook_get_tab_pos(Xen notebook)
{
  #define H_gtk_notebook_get_tab_pos "GtkPositionType gtk_notebook_get_tab_pos(GtkNotebook* notebook)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_get_tab_pos", "GtkNotebook*");
  return(C_to_Xen_GtkPositionType(gtk_notebook_get_tab_pos(Xen_to_C_GtkNotebook_(notebook))));
}

static Xen gxg_gtk_notebook_set_scrollable(Xen notebook, Xen scrollable)
{
  #define H_gtk_notebook_set_scrollable "void gtk_notebook_set_scrollable(GtkNotebook* notebook, gboolean scrollable)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_set_scrollable", "GtkNotebook*");
  Xen_check_type(Xen_is_gboolean(scrollable), scrollable, 2, "gtk_notebook_set_scrollable", "gboolean");
  gtk_notebook_set_scrollable(Xen_to_C_GtkNotebook_(notebook), Xen_to_C_gboolean(scrollable));
  return(Xen_false);
}

static Xen gxg_gtk_notebook_get_scrollable(Xen notebook)
{
  #define H_gtk_notebook_get_scrollable "gboolean gtk_notebook_get_scrollable(GtkNotebook* notebook)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_get_scrollable", "GtkNotebook*");
  return(C_to_Xen_gboolean(gtk_notebook_get_scrollable(Xen_to_C_GtkNotebook_(notebook))));
}

static Xen gxg_gtk_notebook_popup_enable(Xen notebook)
{
  #define H_gtk_notebook_popup_enable "void gtk_notebook_popup_enable(GtkNotebook* notebook)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_popup_enable", "GtkNotebook*");
  gtk_notebook_popup_enable(Xen_to_C_GtkNotebook_(notebook));
  return(Xen_false);
}

static Xen gxg_gtk_notebook_popup_disable(Xen notebook)
{
  #define H_gtk_notebook_popup_disable "void gtk_notebook_popup_disable(GtkNotebook* notebook)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_popup_disable", "GtkNotebook*");
  gtk_notebook_popup_disable(Xen_to_C_GtkNotebook_(notebook));
  return(Xen_false);
}

static Xen gxg_gtk_notebook_get_tab_label(Xen notebook, Xen child)
{
  #define H_gtk_notebook_get_tab_label "GtkWidget* gtk_notebook_get_tab_label(GtkNotebook* notebook, \
GtkWidget* child)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_get_tab_label", "GtkNotebook*");
  Xen_check_type(Xen_is_GtkWidget_(child), child, 2, "gtk_notebook_get_tab_label", "GtkWidget*");
  return(C_to_Xen_GtkWidget_(gtk_notebook_get_tab_label(Xen_to_C_GtkNotebook_(notebook), Xen_to_C_GtkWidget_(child))));
}

static Xen gxg_gtk_notebook_set_tab_label(Xen notebook, Xen child, Xen tab_label)
{
  #define H_gtk_notebook_set_tab_label "void gtk_notebook_set_tab_label(GtkNotebook* notebook, GtkWidget* child, \
GtkWidget* tab_label)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_set_tab_label", "GtkNotebook*");
  Xen_check_type(Xen_is_GtkWidget_(child), child, 2, "gtk_notebook_set_tab_label", "GtkWidget*");
  Xen_check_type(Xen_is_GtkWidget_(tab_label) || Xen_is_false(tab_label), tab_label, 3, "gtk_notebook_set_tab_label", "GtkWidget*");
  gtk_notebook_set_tab_label(Xen_to_C_GtkNotebook_(notebook), Xen_to_C_GtkWidget_(child), Xen_to_C_GtkWidget_(tab_label));
  return(Xen_false);
}

static Xen gxg_gtk_notebook_set_tab_label_text(Xen notebook, Xen child, Xen tab_text)
{
  #define H_gtk_notebook_set_tab_label_text "void gtk_notebook_set_tab_label_text(GtkNotebook* notebook, \
GtkWidget* child, gchar* tab_text)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_set_tab_label_text", "GtkNotebook*");
  Xen_check_type(Xen_is_GtkWidget_(child), child, 2, "gtk_notebook_set_tab_label_text", "GtkWidget*");
  Xen_check_type(Xen_is_gchar_(tab_text), tab_text, 3, "gtk_notebook_set_tab_label_text", "gchar*");
  gtk_notebook_set_tab_label_text(Xen_to_C_GtkNotebook_(notebook), Xen_to_C_GtkWidget_(child), Xen_to_C_gchar_(tab_text));
  return(Xen_false);
}

static Xen gxg_gtk_notebook_get_tab_label_text(Xen notebook, Xen child)
{
  #define H_gtk_notebook_get_tab_label_text "gchar* gtk_notebook_get_tab_label_text(GtkNotebook* notebook, \
GtkWidget* child)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_get_tab_label_text", "GtkNotebook*");
  Xen_check_type(Xen_is_GtkWidget_(child), child, 2, "gtk_notebook_get_tab_label_text", "GtkWidget*");
  return(C_to_Xen_gchar_(gtk_notebook_get_tab_label_text(Xen_to_C_GtkNotebook_(notebook), Xen_to_C_GtkWidget_(child))));
}

static Xen gxg_gtk_notebook_get_menu_label(Xen notebook, Xen child)
{
  #define H_gtk_notebook_get_menu_label "GtkWidget* gtk_notebook_get_menu_label(GtkNotebook* notebook, \
GtkWidget* child)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_get_menu_label", "GtkNotebook*");
  Xen_check_type(Xen_is_GtkWidget_(child), child, 2, "gtk_notebook_get_menu_label", "GtkWidget*");
  return(C_to_Xen_GtkWidget_(gtk_notebook_get_menu_label(Xen_to_C_GtkNotebook_(notebook), Xen_to_C_GtkWidget_(child))));
}

static Xen gxg_gtk_notebook_set_menu_label(Xen notebook, Xen child, Xen menu_label)
{
  #define H_gtk_notebook_set_menu_label "void gtk_notebook_set_menu_label(GtkNotebook* notebook, GtkWidget* child, \
GtkWidget* menu_label)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_set_menu_label", "GtkNotebook*");
  Xen_check_type(Xen_is_GtkWidget_(child), child, 2, "gtk_notebook_set_menu_label", "GtkWidget*");
  Xen_check_type(Xen_is_GtkWidget_(menu_label), menu_label, 3, "gtk_notebook_set_menu_label", "GtkWidget*");
  gtk_notebook_set_menu_label(Xen_to_C_GtkNotebook_(notebook), Xen_to_C_GtkWidget_(child), Xen_to_C_GtkWidget_(menu_label));
  return(Xen_false);
}

static Xen gxg_gtk_notebook_set_menu_label_text(Xen notebook, Xen child, Xen menu_text)
{
  #define H_gtk_notebook_set_menu_label_text "void gtk_notebook_set_menu_label_text(GtkNotebook* notebook, \
GtkWidget* child, gchar* menu_text)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_set_menu_label_text", "GtkNotebook*");
  Xen_check_type(Xen_is_GtkWidget_(child), child, 2, "gtk_notebook_set_menu_label_text", "GtkWidget*");
  Xen_check_type(Xen_is_gchar_(menu_text), menu_text, 3, "gtk_notebook_set_menu_label_text", "gchar*");
  gtk_notebook_set_menu_label_text(Xen_to_C_GtkNotebook_(notebook), Xen_to_C_GtkWidget_(child), Xen_to_C_gchar_(menu_text));
  return(Xen_false);
}

static Xen gxg_gtk_notebook_get_menu_label_text(Xen notebook, Xen child)
{
  #define H_gtk_notebook_get_menu_label_text "gchar* gtk_notebook_get_menu_label_text(GtkNotebook* notebook, \
GtkWidget* child)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_get_menu_label_text", "GtkNotebook*");
  Xen_check_type(Xen_is_GtkWidget_(child), child, 2, "gtk_notebook_get_menu_label_text", "GtkWidget*");
  return(C_to_Xen_gchar_(gtk_notebook_get_menu_label_text(Xen_to_C_GtkNotebook_(notebook), Xen_to_C_GtkWidget_(child))));
}

static Xen gxg_gtk_notebook_reorder_child(Xen notebook, Xen child, Xen position)
{
  #define H_gtk_notebook_reorder_child "void gtk_notebook_reorder_child(GtkNotebook* notebook, GtkWidget* child, \
gint position)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_reorder_child", "GtkNotebook*");
  Xen_check_type(Xen_is_GtkWidget_(child), child, 2, "gtk_notebook_reorder_child", "GtkWidget*");
  Xen_check_type(Xen_is_gint(position), position, 3, "gtk_notebook_reorder_child", "gint");
  gtk_notebook_reorder_child(Xen_to_C_GtkNotebook_(notebook), Xen_to_C_GtkWidget_(child), Xen_to_C_gint(position));
  return(Xen_false);
}

static Xen gxg_gtk_notebook_append_page(Xen notebook, Xen child, Xen tab_label)
{
  #define H_gtk_notebook_append_page "gint gtk_notebook_append_page(GtkNotebook* notebook, GtkWidget* child, \
GtkWidget* tab_label)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_append_page", "GtkNotebook*");
  Xen_check_type(Xen_is_GtkWidget_(child), child, 2, "gtk_notebook_append_page", "GtkWidget*");
  Xen_check_type(Xen_is_GtkWidget_(tab_label) || Xen_is_false(tab_label), tab_label, 3, "gtk_notebook_append_page", "GtkWidget*");
  return(C_to_Xen_gint(gtk_notebook_append_page(Xen_to_C_GtkNotebook_(notebook), Xen_to_C_GtkWidget_(child), Xen_to_C_GtkWidget_(tab_label))));
}

static Xen gxg_gtk_notebook_append_page_menu(Xen notebook, Xen child, Xen tab_label, Xen menu_label)
{
  #define H_gtk_notebook_append_page_menu "gint gtk_notebook_append_page_menu(GtkNotebook* notebook, \
GtkWidget* child, GtkWidget* tab_label, GtkWidget* menu_label)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_append_page_menu", "GtkNotebook*");
  Xen_check_type(Xen_is_GtkWidget_(child), child, 2, "gtk_notebook_append_page_menu", "GtkWidget*");
  Xen_check_type(Xen_is_GtkWidget_(tab_label) || Xen_is_false(tab_label), tab_label, 3, "gtk_notebook_append_page_menu", "GtkWidget*");
  Xen_check_type(Xen_is_GtkWidget_(menu_label) || Xen_is_false(menu_label), menu_label, 4, "gtk_notebook_append_page_menu", "GtkWidget*");
  return(C_to_Xen_gint(gtk_notebook_append_page_menu(Xen_to_C_GtkNotebook_(notebook), Xen_to_C_GtkWidget_(child), Xen_to_C_GtkWidget_(tab_label), 
                                                     Xen_to_C_GtkWidget_(menu_label))));
}

static Xen gxg_gtk_notebook_prepend_page(Xen notebook, Xen child, Xen tab_label)
{
  #define H_gtk_notebook_prepend_page "gint gtk_notebook_prepend_page(GtkNotebook* notebook, GtkWidget* child, \
GtkWidget* tab_label)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_prepend_page", "GtkNotebook*");
  Xen_check_type(Xen_is_GtkWidget_(child), child, 2, "gtk_notebook_prepend_page", "GtkWidget*");
  Xen_check_type(Xen_is_GtkWidget_(tab_label) || Xen_is_false(tab_label), tab_label, 3, "gtk_notebook_prepend_page", "GtkWidget*");
  return(C_to_Xen_gint(gtk_notebook_prepend_page(Xen_to_C_GtkNotebook_(notebook), Xen_to_C_GtkWidget_(child), Xen_to_C_GtkWidget_(tab_label))));
}

static Xen gxg_gtk_notebook_prepend_page_menu(Xen notebook, Xen child, Xen tab_label, Xen menu_label)
{
  #define H_gtk_notebook_prepend_page_menu "gint gtk_notebook_prepend_page_menu(GtkNotebook* notebook, \
GtkWidget* child, GtkWidget* tab_label, GtkWidget* menu_label)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_prepend_page_menu", "GtkNotebook*");
  Xen_check_type(Xen_is_GtkWidget_(child), child, 2, "gtk_notebook_prepend_page_menu", "GtkWidget*");
  Xen_check_type(Xen_is_GtkWidget_(tab_label) || Xen_is_false(tab_label), tab_label, 3, "gtk_notebook_prepend_page_menu", "GtkWidget*");
  Xen_check_type(Xen_is_GtkWidget_(menu_label) || Xen_is_false(menu_label), menu_label, 4, "gtk_notebook_prepend_page_menu", "GtkWidget*");
  return(C_to_Xen_gint(gtk_notebook_prepend_page_menu(Xen_to_C_GtkNotebook_(notebook), Xen_to_C_GtkWidget_(child), Xen_to_C_GtkWidget_(tab_label), 
                                                      Xen_to_C_GtkWidget_(menu_label))));
}

static Xen gxg_gtk_notebook_insert_page(Xen notebook, Xen child, Xen tab_label, Xen position)
{
  #define H_gtk_notebook_insert_page "gint gtk_notebook_insert_page(GtkNotebook* notebook, GtkWidget* child, \
GtkWidget* tab_label, gint position)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_insert_page", "GtkNotebook*");
  Xen_check_type(Xen_is_GtkWidget_(child), child, 2, "gtk_notebook_insert_page", "GtkWidget*");
  Xen_check_type(Xen_is_GtkWidget_(tab_label) || Xen_is_false(tab_label), tab_label, 3, "gtk_notebook_insert_page", "GtkWidget*");
  Xen_check_type(Xen_is_gint(position), position, 4, "gtk_notebook_insert_page", "gint");
  return(C_to_Xen_gint(gtk_notebook_insert_page(Xen_to_C_GtkNotebook_(notebook), Xen_to_C_GtkWidget_(child), Xen_to_C_GtkWidget_(tab_label), 
                                                Xen_to_C_gint(position))));
}

static Xen gxg_gtk_notebook_insert_page_menu(Xen notebook, Xen child, Xen tab_label, Xen menu_label, Xen position)
{
  #define H_gtk_notebook_insert_page_menu "gint gtk_notebook_insert_page_menu(GtkNotebook* notebook, \
GtkWidget* child, GtkWidget* tab_label, GtkWidget* menu_label, gint position)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_insert_page_menu", "GtkNotebook*");
  Xen_check_type(Xen_is_GtkWidget_(child), child, 2, "gtk_notebook_insert_page_menu", "GtkWidget*");
  Xen_check_type(Xen_is_GtkWidget_(tab_label) || Xen_is_false(tab_label), tab_label, 3, "gtk_notebook_insert_page_menu", "GtkWidget*");
  Xen_check_type(Xen_is_GtkWidget_(menu_label) || Xen_is_false(menu_label), menu_label, 4, "gtk_notebook_insert_page_menu", "GtkWidget*");
  Xen_check_type(Xen_is_gint(position), position, 5, "gtk_notebook_insert_page_menu", "gint");
  return(C_to_Xen_gint(gtk_notebook_insert_page_menu(Xen_to_C_GtkNotebook_(notebook), Xen_to_C_GtkWidget_(child), Xen_to_C_GtkWidget_(tab_label), 
                                                     Xen_to_C_GtkWidget_(menu_label), Xen_to_C_gint(position))));
}

static Xen gxg_gtk_progress_bar_new(void)
{
  #define H_gtk_progress_bar_new "GtkWidget* gtk_progress_bar_new( void)"
  return(C_to_Xen_GtkWidget_(gtk_progress_bar_new()));
}

static Xen gxg_gtk_progress_bar_pulse(Xen pbar)
{
  #define H_gtk_progress_bar_pulse "void gtk_progress_bar_pulse(GtkProgressBar* pbar)"
  Xen_check_type(Xen_is_GtkProgressBar_(pbar), pbar, 1, "gtk_progress_bar_pulse", "GtkProgressBar*");
  gtk_progress_bar_pulse(Xen_to_C_GtkProgressBar_(pbar));
  return(Xen_false);
}

static Xen gxg_gtk_progress_bar_set_text(Xen pbar, Xen text)
{
  #define H_gtk_progress_bar_set_text "void gtk_progress_bar_set_text(GtkProgressBar* pbar, gchar* text)"
  Xen_check_type(Xen_is_GtkProgressBar_(pbar), pbar, 1, "gtk_progress_bar_set_text", "GtkProgressBar*");
  Xen_check_type(Xen_is_gchar_(text), text, 2, "gtk_progress_bar_set_text", "gchar*");
  gtk_progress_bar_set_text(Xen_to_C_GtkProgressBar_(pbar), Xen_to_C_gchar_(text));
  return(Xen_false);
}

static Xen gxg_gtk_progress_bar_set_fraction(Xen pbar, Xen fraction)
{
  #define H_gtk_progress_bar_set_fraction "void gtk_progress_bar_set_fraction(GtkProgressBar* pbar, gdouble fraction)"
  Xen_check_type(Xen_is_GtkProgressBar_(pbar), pbar, 1, "gtk_progress_bar_set_fraction", "GtkProgressBar*");
  Xen_check_type(Xen_is_gdouble(fraction), fraction, 2, "gtk_progress_bar_set_fraction", "gdouble");
  gtk_progress_bar_set_fraction(Xen_to_C_GtkProgressBar_(pbar), Xen_to_C_gdouble(fraction));
  return(Xen_false);
}

static Xen gxg_gtk_progress_bar_set_pulse_step(Xen pbar, Xen fraction)
{
  #define H_gtk_progress_bar_set_pulse_step "void gtk_progress_bar_set_pulse_step(GtkProgressBar* pbar, \
gdouble fraction)"
  Xen_check_type(Xen_is_GtkProgressBar_(pbar), pbar, 1, "gtk_progress_bar_set_pulse_step", "GtkProgressBar*");
  Xen_check_type(Xen_is_gdouble(fraction), fraction, 2, "gtk_progress_bar_set_pulse_step", "gdouble");
  gtk_progress_bar_set_pulse_step(Xen_to_C_GtkProgressBar_(pbar), Xen_to_C_gdouble(fraction));
  return(Xen_false);
}

static Xen gxg_gtk_progress_bar_get_text(Xen pbar)
{
  #define H_gtk_progress_bar_get_text "gchar* gtk_progress_bar_get_text(GtkProgressBar* pbar)"
  Xen_check_type(Xen_is_GtkProgressBar_(pbar), pbar, 1, "gtk_progress_bar_get_text", "GtkProgressBar*");
  return(C_to_Xen_gchar_(gtk_progress_bar_get_text(Xen_to_C_GtkProgressBar_(pbar))));
}

static Xen gxg_gtk_progress_bar_get_fraction(Xen pbar)
{
  #define H_gtk_progress_bar_get_fraction "gdouble gtk_progress_bar_get_fraction(GtkProgressBar* pbar)"
  Xen_check_type(Xen_is_GtkProgressBar_(pbar), pbar, 1, "gtk_progress_bar_get_fraction", "GtkProgressBar*");
  return(C_to_Xen_gdouble(gtk_progress_bar_get_fraction(Xen_to_C_GtkProgressBar_(pbar))));
}

static Xen gxg_gtk_progress_bar_get_pulse_step(Xen pbar)
{
  #define H_gtk_progress_bar_get_pulse_step "gdouble gtk_progress_bar_get_pulse_step(GtkProgressBar* pbar)"
  Xen_check_type(Xen_is_GtkProgressBar_(pbar), pbar, 1, "gtk_progress_bar_get_pulse_step", "GtkProgressBar*");
  return(C_to_Xen_gdouble(gtk_progress_bar_get_pulse_step(Xen_to_C_GtkProgressBar_(pbar))));
}

static Xen gxg_gtk_radio_button_new(Xen group)
{
  #define H_gtk_radio_button_new "GtkWidget* gtk_radio_button_new(GSList* group)"
  Xen_check_type(Xen_is_GSList_(group) || Xen_is_false(group), group, 1, "gtk_radio_button_new", "GSList*");
  return(C_to_Xen_GtkWidget_(gtk_radio_button_new(Xen_to_C_GSList_(group))));
}

static Xen gxg_gtk_radio_button_new_from_widget(Xen group)
{
  #define H_gtk_radio_button_new_from_widget "GtkWidget* gtk_radio_button_new_from_widget(GtkRadioButton* group)"
  Xen_check_type(Xen_is_GtkRadioButton_(group), group, 1, "gtk_radio_button_new_from_widget", "GtkRadioButton*");
  return(C_to_Xen_GtkWidget_(gtk_radio_button_new_from_widget(Xen_to_C_GtkRadioButton_(group))));
}

static Xen gxg_gtk_radio_button_new_with_label(Xen group, Xen label)
{
  #define H_gtk_radio_button_new_with_label "GtkWidget* gtk_radio_button_new_with_label(GSList* group, \
gchar* label)"
  Xen_check_type(Xen_is_GSList_(group) || Xen_is_false(group), group, 1, "gtk_radio_button_new_with_label", "GSList*");
  Xen_check_type(Xen_is_gchar_(label), label, 2, "gtk_radio_button_new_with_label", "gchar*");
  return(C_to_Xen_GtkWidget_(gtk_radio_button_new_with_label(Xen_to_C_GSList_(group), Xen_to_C_gchar_(label))));
}

static Xen gxg_gtk_radio_button_new_with_label_from_widget(Xen group, Xen label)
{
  #define H_gtk_radio_button_new_with_label_from_widget "GtkWidget* gtk_radio_button_new_with_label_from_widget(GtkRadioButton* group, \
gchar* label)"
  Xen_check_type(Xen_is_GtkRadioButton_(group), group, 1, "gtk_radio_button_new_with_label_from_widget", "GtkRadioButton*");
  Xen_check_type(Xen_is_gchar_(label), label, 2, "gtk_radio_button_new_with_label_from_widget", "gchar*");
  return(C_to_Xen_GtkWidget_(gtk_radio_button_new_with_label_from_widget(Xen_to_C_GtkRadioButton_(group), Xen_to_C_gchar_(label))));
}

static Xen gxg_gtk_radio_button_new_with_mnemonic(Xen group, Xen label)
{
  #define H_gtk_radio_button_new_with_mnemonic "GtkWidget* gtk_radio_button_new_with_mnemonic(GSList* group, \
gchar* label)"
  Xen_check_type(Xen_is_GSList_(group) || Xen_is_false(group), group, 1, "gtk_radio_button_new_with_mnemonic", "GSList*");
  Xen_check_type(Xen_is_gchar_(label), label, 2, "gtk_radio_button_new_with_mnemonic", "gchar*");
  return(C_to_Xen_GtkWidget_(gtk_radio_button_new_with_mnemonic(Xen_to_C_GSList_(group), Xen_to_C_gchar_(label))));
}

static Xen gxg_gtk_radio_button_new_with_mnemonic_from_widget(Xen group, Xen label)
{
  #define H_gtk_radio_button_new_with_mnemonic_from_widget "GtkWidget* gtk_radio_button_new_with_mnemonic_from_widget(GtkRadioButton* group, \
gchar* label)"
  Xen_check_type(Xen_is_GtkRadioButton_(group), group, 1, "gtk_radio_button_new_with_mnemonic_from_widget", "GtkRadioButton*");
  Xen_check_type(Xen_is_gchar_(label), label, 2, "gtk_radio_button_new_with_mnemonic_from_widget", "gchar*");
  return(C_to_Xen_GtkWidget_(gtk_radio_button_new_with_mnemonic_from_widget(Xen_to_C_GtkRadioButton_(group), Xen_to_C_gchar_(label))));
}

static Xen gxg_gtk_radio_button_get_group(Xen radio_button)
{
  #define H_gtk_radio_button_get_group "GSList* gtk_radio_button_get_group(GtkRadioButton* radio_button)"
  Xen_check_type(Xen_is_GtkRadioButton_(radio_button), radio_button, 1, "gtk_radio_button_get_group", "GtkRadioButton*");
  return(C_to_Xen_GSList_(gtk_radio_button_get_group(Xen_to_C_GtkRadioButton_(radio_button))));
}

static Xen gxg_gtk_radio_button_set_group(Xen radio_button, Xen group)
{
  #define H_gtk_radio_button_set_group "void gtk_radio_button_set_group(GtkRadioButton* radio_button, \
GSList* group)"
  Xen_check_type(Xen_is_GtkRadioButton_(radio_button), radio_button, 1, "gtk_radio_button_set_group", "GtkRadioButton*");
  Xen_check_type(Xen_is_GSList_(group) || Xen_is_false(group), group, 2, "gtk_radio_button_set_group", "GSList*");
  gtk_radio_button_set_group(Xen_to_C_GtkRadioButton_(radio_button), Xen_to_C_GSList_(group));
  return(Xen_false);
}

static Xen gxg_gtk_range_set_adjustment(Xen range, Xen adjustment)
{
  #define H_gtk_range_set_adjustment "void gtk_range_set_adjustment(GtkRange* range, GtkAdjustment* adjustment)"
  Xen_check_type(Xen_is_GtkRange_(range), range, 1, "gtk_range_set_adjustment", "GtkRange*");
  Xen_check_type(Xen_is_GtkAdjustment_(adjustment) || Xen_is_false(adjustment), adjustment, 2, "gtk_range_set_adjustment", "GtkAdjustment*");
  gtk_range_set_adjustment(Xen_to_C_GtkRange_(range), Xen_to_C_GtkAdjustment_(adjustment));
  return(Xen_false);
}

static Xen gxg_gtk_range_get_adjustment(Xen range)
{
  #define H_gtk_range_get_adjustment "GtkAdjustment* gtk_range_get_adjustment(GtkRange* range)"
  Xen_check_type(Xen_is_GtkRange_(range), range, 1, "gtk_range_get_adjustment", "GtkRange*");
  return(C_to_Xen_GtkAdjustment_(gtk_range_get_adjustment(Xen_to_C_GtkRange_(range))));
}

static Xen gxg_gtk_range_set_inverted(Xen range, Xen setting)
{
  #define H_gtk_range_set_inverted "void gtk_range_set_inverted(GtkRange* range, gboolean setting)"
  Xen_check_type(Xen_is_GtkRange_(range), range, 1, "gtk_range_set_inverted", "GtkRange*");
  Xen_check_type(Xen_is_gboolean(setting), setting, 2, "gtk_range_set_inverted", "gboolean");
  gtk_range_set_inverted(Xen_to_C_GtkRange_(range), Xen_to_C_gboolean(setting));
  return(Xen_false);
}

static Xen gxg_gtk_range_get_inverted(Xen range)
{
  #define H_gtk_range_get_inverted "gboolean gtk_range_get_inverted(GtkRange* range)"
  Xen_check_type(Xen_is_GtkRange_(range), range, 1, "gtk_range_get_inverted", "GtkRange*");
  return(C_to_Xen_gboolean(gtk_range_get_inverted(Xen_to_C_GtkRange_(range))));
}

static Xen gxg_gtk_range_set_increments(Xen range, Xen step, Xen page)
{
  #define H_gtk_range_set_increments "void gtk_range_set_increments(GtkRange* range, gdouble step, gdouble page)"
  Xen_check_type(Xen_is_GtkRange_(range), range, 1, "gtk_range_set_increments", "GtkRange*");
  Xen_check_type(Xen_is_gdouble(step), step, 2, "gtk_range_set_increments", "gdouble");
  Xen_check_type(Xen_is_gdouble(page), page, 3, "gtk_range_set_increments", "gdouble");
  gtk_range_set_increments(Xen_to_C_GtkRange_(range), Xen_to_C_gdouble(step), Xen_to_C_gdouble(page));
  return(Xen_false);
}

static Xen gxg_gtk_range_set_range(Xen range, Xen min, Xen max)
{
  #define H_gtk_range_set_range "void gtk_range_set_range(GtkRange* range, gdouble min, gdouble max)"
  Xen_check_type(Xen_is_GtkRange_(range), range, 1, "gtk_range_set_range", "GtkRange*");
  Xen_check_type(Xen_is_gdouble(min), min, 2, "gtk_range_set_range", "gdouble");
  Xen_check_type(Xen_is_gdouble(max), max, 3, "gtk_range_set_range", "gdouble");
  gtk_range_set_range(Xen_to_C_GtkRange_(range), Xen_to_C_gdouble(min), Xen_to_C_gdouble(max));
  return(Xen_false);
}

static Xen gxg_gtk_range_set_value(Xen range, Xen value)
{
  #define H_gtk_range_set_value "void gtk_range_set_value(GtkRange* range, gdouble value)"
  Xen_check_type(Xen_is_GtkRange_(range), range, 1, "gtk_range_set_value", "GtkRange*");
  Xen_check_type(Xen_is_gdouble(value), value, 2, "gtk_range_set_value", "gdouble");
  gtk_range_set_value(Xen_to_C_GtkRange_(range), Xen_to_C_gdouble(value));
  return(Xen_false);
}

static Xen gxg_gtk_range_get_value(Xen range)
{
  #define H_gtk_range_get_value "gdouble gtk_range_get_value(GtkRange* range)"
  Xen_check_type(Xen_is_GtkRange_(range), range, 1, "gtk_range_get_value", "GtkRange*");
  return(C_to_Xen_gdouble(gtk_range_get_value(Xen_to_C_GtkRange_(range))));
}

static Xen gxg_gtk_scale_set_digits(Xen scale, Xen digits)
{
  #define H_gtk_scale_set_digits "void gtk_scale_set_digits(GtkScale* scale, gint digits)"
  Xen_check_type(Xen_is_GtkScale_(scale), scale, 1, "gtk_scale_set_digits", "GtkScale*");
  Xen_check_type(Xen_is_gint(digits), digits, 2, "gtk_scale_set_digits", "gint");
  gtk_scale_set_digits(Xen_to_C_GtkScale_(scale), Xen_to_C_gint(digits));
  return(Xen_false);
}

static Xen gxg_gtk_scale_get_digits(Xen scale)
{
  #define H_gtk_scale_get_digits "gint gtk_scale_get_digits(GtkScale* scale)"
  Xen_check_type(Xen_is_GtkScale_(scale), scale, 1, "gtk_scale_get_digits", "GtkScale*");
  return(C_to_Xen_gint(gtk_scale_get_digits(Xen_to_C_GtkScale_(scale))));
}

static Xen gxg_gtk_scale_set_draw_value(Xen scale, Xen draw_value)
{
  #define H_gtk_scale_set_draw_value "void gtk_scale_set_draw_value(GtkScale* scale, gboolean draw_value)"
  Xen_check_type(Xen_is_GtkScale_(scale), scale, 1, "gtk_scale_set_draw_value", "GtkScale*");
  Xen_check_type(Xen_is_gboolean(draw_value), draw_value, 2, "gtk_scale_set_draw_value", "gboolean");
  gtk_scale_set_draw_value(Xen_to_C_GtkScale_(scale), Xen_to_C_gboolean(draw_value));
  return(Xen_false);
}

static Xen gxg_gtk_scale_get_draw_value(Xen scale)
{
  #define H_gtk_scale_get_draw_value "gboolean gtk_scale_get_draw_value(GtkScale* scale)"
  Xen_check_type(Xen_is_GtkScale_(scale), scale, 1, "gtk_scale_get_draw_value", "GtkScale*");
  return(C_to_Xen_gboolean(gtk_scale_get_draw_value(Xen_to_C_GtkScale_(scale))));
}

static Xen gxg_gtk_scale_set_value_pos(Xen scale, Xen pos)
{
  #define H_gtk_scale_set_value_pos "void gtk_scale_set_value_pos(GtkScale* scale, GtkPositionType pos)"
  Xen_check_type(Xen_is_GtkScale_(scale), scale, 1, "gtk_scale_set_value_pos", "GtkScale*");
  Xen_check_type(Xen_is_GtkPositionType(pos), pos, 2, "gtk_scale_set_value_pos", "GtkPositionType");
  gtk_scale_set_value_pos(Xen_to_C_GtkScale_(scale), Xen_to_C_GtkPositionType(pos));
  return(Xen_false);
}

static Xen gxg_gtk_scale_get_value_pos(Xen scale)
{
  #define H_gtk_scale_get_value_pos "GtkPositionType gtk_scale_get_value_pos(GtkScale* scale)"
  Xen_check_type(Xen_is_GtkScale_(scale), scale, 1, "gtk_scale_get_value_pos", "GtkScale*");
  return(C_to_Xen_GtkPositionType(gtk_scale_get_value_pos(Xen_to_C_GtkScale_(scale))));
}

static Xen gxg_gtk_scrolled_window_new(Xen hadjustment, Xen vadjustment)
{
  #define H_gtk_scrolled_window_new "GtkWidget* gtk_scrolled_window_new(GtkAdjustment* hadjustment, GtkAdjustment* vadjustment)"
  Xen_check_type(Xen_is_GtkAdjustment_(hadjustment) || Xen_is_false(hadjustment), hadjustment, 1, "gtk_scrolled_window_new", "GtkAdjustment*");
  Xen_check_type(Xen_is_GtkAdjustment_(vadjustment) || Xen_is_false(vadjustment), vadjustment, 2, "gtk_scrolled_window_new", "GtkAdjustment*");
  return(C_to_Xen_GtkWidget_(gtk_scrolled_window_new(Xen_to_C_GtkAdjustment_(hadjustment), Xen_to_C_GtkAdjustment_(vadjustment))));
}

static Xen gxg_gtk_scrolled_window_set_hadjustment(Xen scrolled_window, Xen hadjustment)
{
  #define H_gtk_scrolled_window_set_hadjustment "void gtk_scrolled_window_set_hadjustment(GtkScrolledWindow* scrolled_window, \
GtkAdjustment* hadjustment)"
  Xen_check_type(Xen_is_GtkScrolledWindow_(scrolled_window), scrolled_window, 1, "gtk_scrolled_window_set_hadjustment", "GtkScrolledWindow*");
  Xen_check_type(Xen_is_GtkAdjustment_(hadjustment) || Xen_is_false(hadjustment), hadjustment, 2, "gtk_scrolled_window_set_hadjustment", "GtkAdjustment*");
  gtk_scrolled_window_set_hadjustment(Xen_to_C_GtkScrolledWindow_(scrolled_window), Xen_to_C_GtkAdjustment_(hadjustment));
  return(Xen_false);
}

static Xen gxg_gtk_scrolled_window_set_vadjustment(Xen scrolled_window, Xen hadjustment)
{
  #define H_gtk_scrolled_window_set_vadjustment "void gtk_scrolled_window_set_vadjustment(GtkScrolledWindow* scrolled_window, \
GtkAdjustment* hadjustment)"
  Xen_check_type(Xen_is_GtkScrolledWindow_(scrolled_window), scrolled_window, 1, "gtk_scrolled_window_set_vadjustment", "GtkScrolledWindow*");
  Xen_check_type(Xen_is_GtkAdjustment_(hadjustment) || Xen_is_false(hadjustment), hadjustment, 2, "gtk_scrolled_window_set_vadjustment", "GtkAdjustment*");
  gtk_scrolled_window_set_vadjustment(Xen_to_C_GtkScrolledWindow_(scrolled_window), Xen_to_C_GtkAdjustment_(hadjustment));
  return(Xen_false);
}

static Xen gxg_gtk_scrolled_window_get_hadjustment(Xen scrolled_window)
{
  #define H_gtk_scrolled_window_get_hadjustment "GtkAdjustment* gtk_scrolled_window_get_hadjustment(GtkScrolledWindow* scrolled_window)"
  Xen_check_type(Xen_is_GtkScrolledWindow_(scrolled_window), scrolled_window, 1, "gtk_scrolled_window_get_hadjustment", "GtkScrolledWindow*");
  return(C_to_Xen_GtkAdjustment_(gtk_scrolled_window_get_hadjustment(Xen_to_C_GtkScrolledWindow_(scrolled_window))));
}

static Xen gxg_gtk_scrolled_window_get_vadjustment(Xen scrolled_window)
{
  #define H_gtk_scrolled_window_get_vadjustment "GtkAdjustment* gtk_scrolled_window_get_vadjustment(GtkScrolledWindow* scrolled_window)"
  Xen_check_type(Xen_is_GtkScrolledWindow_(scrolled_window), scrolled_window, 1, "gtk_scrolled_window_get_vadjustment", "GtkScrolledWindow*");
  return(C_to_Xen_GtkAdjustment_(gtk_scrolled_window_get_vadjustment(Xen_to_C_GtkScrolledWindow_(scrolled_window))));
}

static Xen gxg_gtk_scrolled_window_set_policy(Xen scrolled_window, Xen hscrollbar_policy, Xen vscrollbar_policy)
{
  #define H_gtk_scrolled_window_set_policy "void gtk_scrolled_window_set_policy(GtkScrolledWindow* scrolled_window, \
GtkPolicyType hscrollbar_policy, GtkPolicyType vscrollbar_policy)"
  Xen_check_type(Xen_is_GtkScrolledWindow_(scrolled_window), scrolled_window, 1, "gtk_scrolled_window_set_policy", "GtkScrolledWindow*");
  Xen_check_type(Xen_is_GtkPolicyType(hscrollbar_policy), hscrollbar_policy, 2, "gtk_scrolled_window_set_policy", "GtkPolicyType");
  Xen_check_type(Xen_is_GtkPolicyType(vscrollbar_policy), vscrollbar_policy, 3, "gtk_scrolled_window_set_policy", "GtkPolicyType");
  gtk_scrolled_window_set_policy(Xen_to_C_GtkScrolledWindow_(scrolled_window), Xen_to_C_GtkPolicyType(hscrollbar_policy), 
                                 Xen_to_C_GtkPolicyType(vscrollbar_policy));
  return(Xen_false);
}

static Xen gxg_gtk_scrolled_window_get_policy(Xen scrolled_window, Xen ignore_hscrollbar_policy, Xen ignore_vscrollbar_policy)
{
  #define H_gtk_scrolled_window_get_policy "void gtk_scrolled_window_get_policy(GtkScrolledWindow* scrolled_window, \
GtkPolicyType* [hscrollbar_policy], GtkPolicyType* [vscrollbar_policy])"
  GtkPolicyType ref_hscrollbar_policy;
  GtkPolicyType ref_vscrollbar_policy;
  Xen_check_type(Xen_is_GtkScrolledWindow_(scrolled_window), scrolled_window, 1, "gtk_scrolled_window_get_policy", "GtkScrolledWindow*");
  gtk_scrolled_window_get_policy(Xen_to_C_GtkScrolledWindow_(scrolled_window), &ref_hscrollbar_policy, &ref_vscrollbar_policy);
  return(Xen_list_2(C_to_Xen_GtkPolicyType(ref_hscrollbar_policy), C_to_Xen_GtkPolicyType(ref_vscrollbar_policy)));
}

static Xen gxg_gtk_scrolled_window_set_placement(Xen scrolled_window, Xen window_placement)
{
  #define H_gtk_scrolled_window_set_placement "void gtk_scrolled_window_set_placement(GtkScrolledWindow* scrolled_window, \
GtkCornerType window_placement)"
  Xen_check_type(Xen_is_GtkScrolledWindow_(scrolled_window), scrolled_window, 1, "gtk_scrolled_window_set_placement", "GtkScrolledWindow*");
  Xen_check_type(Xen_is_GtkCornerType(window_placement), window_placement, 2, "gtk_scrolled_window_set_placement", "GtkCornerType");
  gtk_scrolled_window_set_placement(Xen_to_C_GtkScrolledWindow_(scrolled_window), Xen_to_C_GtkCornerType(window_placement));
  return(Xen_false);
}

static Xen gxg_gtk_scrolled_window_get_placement(Xen scrolled_window)
{
  #define H_gtk_scrolled_window_get_placement "GtkCornerType gtk_scrolled_window_get_placement(GtkScrolledWindow* scrolled_window)"
  Xen_check_type(Xen_is_GtkScrolledWindow_(scrolled_window), scrolled_window, 1, "gtk_scrolled_window_get_placement", "GtkScrolledWindow*");
  return(C_to_Xen_GtkCornerType(gtk_scrolled_window_get_placement(Xen_to_C_GtkScrolledWindow_(scrolled_window))));
}

static Xen gxg_gtk_settings_get_default(void)
{
  #define H_gtk_settings_get_default "GtkSettings* gtk_settings_get_default( void)"
  return(C_to_Xen_GtkSettings_(gtk_settings_get_default()));
}

static Xen gxg_gtk_size_group_new(Xen mode)
{
  #define H_gtk_size_group_new "GtkSizeGroup* gtk_size_group_new(GtkSizeGroupMode mode)"
  Xen_check_type(Xen_is_GtkSizeGroupMode(mode), mode, 1, "gtk_size_group_new", "GtkSizeGroupMode");
  return(C_to_Xen_GtkSizeGroup_(gtk_size_group_new(Xen_to_C_GtkSizeGroupMode(mode))));
}

static Xen gxg_gtk_size_group_set_mode(Xen size_group, Xen mode)
{
  #define H_gtk_size_group_set_mode "void gtk_size_group_set_mode(GtkSizeGroup* size_group, GtkSizeGroupMode mode)"
  Xen_check_type(Xen_is_GtkSizeGroup_(size_group), size_group, 1, "gtk_size_group_set_mode", "GtkSizeGroup*");
  Xen_check_type(Xen_is_GtkSizeGroupMode(mode), mode, 2, "gtk_size_group_set_mode", "GtkSizeGroupMode");
  gtk_size_group_set_mode(Xen_to_C_GtkSizeGroup_(size_group), Xen_to_C_GtkSizeGroupMode(mode));
  return(Xen_false);
}

static Xen gxg_gtk_size_group_get_mode(Xen size_group)
{
  #define H_gtk_size_group_get_mode "GtkSizeGroupMode gtk_size_group_get_mode(GtkSizeGroup* size_group)"
  Xen_check_type(Xen_is_GtkSizeGroup_(size_group), size_group, 1, "gtk_size_group_get_mode", "GtkSizeGroup*");
  return(C_to_Xen_GtkSizeGroupMode(gtk_size_group_get_mode(Xen_to_C_GtkSizeGroup_(size_group))));
}

static Xen gxg_gtk_size_group_add_widget(Xen size_group, Xen widget)
{
  #define H_gtk_size_group_add_widget "void gtk_size_group_add_widget(GtkSizeGroup* size_group, GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkSizeGroup_(size_group), size_group, 1, "gtk_size_group_add_widget", "GtkSizeGroup*");
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 2, "gtk_size_group_add_widget", "GtkWidget*");
  gtk_size_group_add_widget(Xen_to_C_GtkSizeGroup_(size_group), Xen_to_C_GtkWidget_(widget));
  return(Xen_false);
}

static Xen gxg_gtk_size_group_remove_widget(Xen size_group, Xen widget)
{
  #define H_gtk_size_group_remove_widget "void gtk_size_group_remove_widget(GtkSizeGroup* size_group, \
GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkSizeGroup_(size_group), size_group, 1, "gtk_size_group_remove_widget", "GtkSizeGroup*");
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 2, "gtk_size_group_remove_widget", "GtkWidget*");
  gtk_size_group_remove_widget(Xen_to_C_GtkSizeGroup_(size_group), Xen_to_C_GtkWidget_(widget));
  return(Xen_false);
}

static Xen gxg_gtk_spin_button_configure(Xen spin_button, Xen adjustment, Xen climb_rate, Xen digits)
{
  #define H_gtk_spin_button_configure "void gtk_spin_button_configure(GtkSpinButton* spin_button, GtkAdjustment* adjustment, \
gdouble climb_rate, guint digits)"
  Xen_check_type(Xen_is_GtkSpinButton_(spin_button), spin_button, 1, "gtk_spin_button_configure", "GtkSpinButton*");
  Xen_check_type(Xen_is_GtkAdjustment_(adjustment) || Xen_is_false(adjustment), adjustment, 2, "gtk_spin_button_configure", "GtkAdjustment*");
  Xen_check_type(Xen_is_gdouble(climb_rate), climb_rate, 3, "gtk_spin_button_configure", "gdouble");
  Xen_check_type(Xen_is_guint(digits), digits, 4, "gtk_spin_button_configure", "guint");
  gtk_spin_button_configure(Xen_to_C_GtkSpinButton_(spin_button), Xen_to_C_GtkAdjustment_(adjustment), Xen_to_C_gdouble(climb_rate), 
                            Xen_to_C_guint(digits));
  return(Xen_false);
}

static Xen gxg_gtk_spin_button_new(Xen adjustment, Xen climb_rate, Xen digits)
{
  #define H_gtk_spin_button_new "GtkWidget* gtk_spin_button_new(GtkAdjustment* adjustment, gdouble climb_rate, \
guint digits)"
  Xen_check_type(Xen_is_GtkAdjustment_(adjustment) || Xen_is_false(adjustment), adjustment, 1, "gtk_spin_button_new", "GtkAdjustment*");
  Xen_check_type(Xen_is_gdouble(climb_rate), climb_rate, 2, "gtk_spin_button_new", "gdouble");
  Xen_check_type(Xen_is_guint(digits), digits, 3, "gtk_spin_button_new", "guint");
  return(C_to_Xen_GtkWidget_(gtk_spin_button_new(Xen_to_C_GtkAdjustment_(adjustment), Xen_to_C_gdouble(climb_rate), Xen_to_C_guint(digits))));
}

static Xen gxg_gtk_spin_button_new_with_range(Xen min, Xen max, Xen step)
{
  #define H_gtk_spin_button_new_with_range "GtkWidget* gtk_spin_button_new_with_range(gdouble min, gdouble max, \
gdouble step)"
  Xen_check_type(Xen_is_gdouble(min), min, 1, "gtk_spin_button_new_with_range", "gdouble");
  Xen_check_type(Xen_is_gdouble(max), max, 2, "gtk_spin_button_new_with_range", "gdouble");
  Xen_check_type(Xen_is_gdouble(step), step, 3, "gtk_spin_button_new_with_range", "gdouble");
  return(C_to_Xen_GtkWidget_(gtk_spin_button_new_with_range(Xen_to_C_gdouble(min), Xen_to_C_gdouble(max), Xen_to_C_gdouble(step))));
}

static Xen gxg_gtk_spin_button_set_adjustment(Xen spin_button, Xen adjustment)
{
  #define H_gtk_spin_button_set_adjustment "void gtk_spin_button_set_adjustment(GtkSpinButton* spin_button, \
GtkAdjustment* adjustment)"
  Xen_check_type(Xen_is_GtkSpinButton_(spin_button), spin_button, 1, "gtk_spin_button_set_adjustment", "GtkSpinButton*");
  Xen_check_type(Xen_is_GtkAdjustment_(adjustment) || Xen_is_false(adjustment), adjustment, 2, "gtk_spin_button_set_adjustment", "GtkAdjustment*");
  gtk_spin_button_set_adjustment(Xen_to_C_GtkSpinButton_(spin_button), Xen_to_C_GtkAdjustment_(adjustment));
  return(Xen_false);
}

static Xen gxg_gtk_spin_button_get_adjustment(Xen spin_button)
{
  #define H_gtk_spin_button_get_adjustment "GtkAdjustment* gtk_spin_button_get_adjustment(GtkSpinButton* spin_button)"
  Xen_check_type(Xen_is_GtkSpinButton_(spin_button), spin_button, 1, "gtk_spin_button_get_adjustment", "GtkSpinButton*");
  return(C_to_Xen_GtkAdjustment_(gtk_spin_button_get_adjustment(Xen_to_C_GtkSpinButton_(spin_button))));
}

static Xen gxg_gtk_spin_button_set_digits(Xen spin_button, Xen digits)
{
  #define H_gtk_spin_button_set_digits "void gtk_spin_button_set_digits(GtkSpinButton* spin_button, guint digits)"
  Xen_check_type(Xen_is_GtkSpinButton_(spin_button), spin_button, 1, "gtk_spin_button_set_digits", "GtkSpinButton*");
  Xen_check_type(Xen_is_guint(digits), digits, 2, "gtk_spin_button_set_digits", "guint");
  gtk_spin_button_set_digits(Xen_to_C_GtkSpinButton_(spin_button), Xen_to_C_guint(digits));
  return(Xen_false);
}

static Xen gxg_gtk_spin_button_get_digits(Xen spin_button)
{
  #define H_gtk_spin_button_get_digits "guint gtk_spin_button_get_digits(GtkSpinButton* spin_button)"
  Xen_check_type(Xen_is_GtkSpinButton_(spin_button), spin_button, 1, "gtk_spin_button_get_digits", "GtkSpinButton*");
  return(C_to_Xen_guint(gtk_spin_button_get_digits(Xen_to_C_GtkSpinButton_(spin_button))));
}

static Xen gxg_gtk_spin_button_set_increments(Xen spin_button, Xen step, Xen page)
{
  #define H_gtk_spin_button_set_increments "void gtk_spin_button_set_increments(GtkSpinButton* spin_button, \
gdouble step, gdouble page)"
  Xen_check_type(Xen_is_GtkSpinButton_(spin_button), spin_button, 1, "gtk_spin_button_set_increments", "GtkSpinButton*");
  Xen_check_type(Xen_is_gdouble(step), step, 2, "gtk_spin_button_set_increments", "gdouble");
  Xen_check_type(Xen_is_gdouble(page), page, 3, "gtk_spin_button_set_increments", "gdouble");
  gtk_spin_button_set_increments(Xen_to_C_GtkSpinButton_(spin_button), Xen_to_C_gdouble(step), Xen_to_C_gdouble(page));
  return(Xen_false);
}

static Xen gxg_gtk_spin_button_get_increments(Xen spin_button, Xen ignore_step, Xen ignore_page)
{
  #define H_gtk_spin_button_get_increments "void gtk_spin_button_get_increments(GtkSpinButton* spin_button, \
gdouble* [step], gdouble* [page])"
  gdouble ref_step;
  gdouble ref_page;
  Xen_check_type(Xen_is_GtkSpinButton_(spin_button), spin_button, 1, "gtk_spin_button_get_increments", "GtkSpinButton*");
  gtk_spin_button_get_increments(Xen_to_C_GtkSpinButton_(spin_button), &ref_step, &ref_page);
  return(Xen_list_2(C_to_Xen_gdouble(ref_step), C_to_Xen_gdouble(ref_page)));
}

static Xen gxg_gtk_spin_button_set_range(Xen spin_button, Xen min, Xen max)
{
  #define H_gtk_spin_button_set_range "void gtk_spin_button_set_range(GtkSpinButton* spin_button, gdouble min, \
gdouble max)"
  Xen_check_type(Xen_is_GtkSpinButton_(spin_button), spin_button, 1, "gtk_spin_button_set_range", "GtkSpinButton*");
  Xen_check_type(Xen_is_gdouble(min), min, 2, "gtk_spin_button_set_range", "gdouble");
  Xen_check_type(Xen_is_gdouble(max), max, 3, "gtk_spin_button_set_range", "gdouble");
  gtk_spin_button_set_range(Xen_to_C_GtkSpinButton_(spin_button), Xen_to_C_gdouble(min), Xen_to_C_gdouble(max));
  return(Xen_false);
}

static Xen gxg_gtk_spin_button_get_range(Xen spin_button, Xen ignore_min, Xen ignore_max)
{
  #define H_gtk_spin_button_get_range "void gtk_spin_button_get_range(GtkSpinButton* spin_button, gdouble* [min], \
gdouble* [max])"
  gdouble ref_min;
  gdouble ref_max;
  Xen_check_type(Xen_is_GtkSpinButton_(spin_button), spin_button, 1, "gtk_spin_button_get_range", "GtkSpinButton*");
  gtk_spin_button_get_range(Xen_to_C_GtkSpinButton_(spin_button), &ref_min, &ref_max);
  return(Xen_list_2(C_to_Xen_gdouble(ref_min), C_to_Xen_gdouble(ref_max)));
}

static Xen gxg_gtk_spin_button_get_value(Xen spin_button)
{
  #define H_gtk_spin_button_get_value "gdouble gtk_spin_button_get_value(GtkSpinButton* spin_button)"
  Xen_check_type(Xen_is_GtkSpinButton_(spin_button), spin_button, 1, "gtk_spin_button_get_value", "GtkSpinButton*");
  return(C_to_Xen_gdouble(gtk_spin_button_get_value(Xen_to_C_GtkSpinButton_(spin_button))));
}

static Xen gxg_gtk_spin_button_get_value_as_int(Xen spin_button)
{
  #define H_gtk_spin_button_get_value_as_int "gint gtk_spin_button_get_value_as_int(GtkSpinButton* spin_button)"
  Xen_check_type(Xen_is_GtkSpinButton_(spin_button), spin_button, 1, "gtk_spin_button_get_value_as_int", "GtkSpinButton*");
  return(C_to_Xen_gint(gtk_spin_button_get_value_as_int(Xen_to_C_GtkSpinButton_(spin_button))));
}

static Xen gxg_gtk_spin_button_set_value(Xen spin_button, Xen value)
{
  #define H_gtk_spin_button_set_value "void gtk_spin_button_set_value(GtkSpinButton* spin_button, gdouble value)"
  Xen_check_type(Xen_is_GtkSpinButton_(spin_button), spin_button, 1, "gtk_spin_button_set_value", "GtkSpinButton*");
  Xen_check_type(Xen_is_gdouble(value), value, 2, "gtk_spin_button_set_value", "gdouble");
  gtk_spin_button_set_value(Xen_to_C_GtkSpinButton_(spin_button), Xen_to_C_gdouble(value));
  return(Xen_false);
}

static Xen gxg_gtk_spin_button_set_update_policy(Xen spin_button, Xen policy)
{
  #define H_gtk_spin_button_set_update_policy "void gtk_spin_button_set_update_policy(GtkSpinButton* spin_button, \
GtkSpinButtonUpdatePolicy policy)"
  Xen_check_type(Xen_is_GtkSpinButton_(spin_button), spin_button, 1, "gtk_spin_button_set_update_policy", "GtkSpinButton*");
  Xen_check_type(Xen_is_GtkSpinButtonUpdatePolicy(policy), policy, 2, "gtk_spin_button_set_update_policy", "GtkSpinButtonUpdatePolicy");
  gtk_spin_button_set_update_policy(Xen_to_C_GtkSpinButton_(spin_button), Xen_to_C_GtkSpinButtonUpdatePolicy(policy));
  return(Xen_false);
}

static Xen gxg_gtk_spin_button_get_update_policy(Xen spin_button)
{
  #define H_gtk_spin_button_get_update_policy "GtkSpinButtonUpdatePolicy gtk_spin_button_get_update_policy(GtkSpinButton* spin_button)"
  Xen_check_type(Xen_is_GtkSpinButton_(spin_button), spin_button, 1, "gtk_spin_button_get_update_policy", "GtkSpinButton*");
  return(C_to_Xen_GtkSpinButtonUpdatePolicy(gtk_spin_button_get_update_policy(Xen_to_C_GtkSpinButton_(spin_button))));
}

static Xen gxg_gtk_spin_button_set_numeric(Xen spin_button, Xen numeric)
{
  #define H_gtk_spin_button_set_numeric "void gtk_spin_button_set_numeric(GtkSpinButton* spin_button, \
gboolean numeric)"
  Xen_check_type(Xen_is_GtkSpinButton_(spin_button), spin_button, 1, "gtk_spin_button_set_numeric", "GtkSpinButton*");
  Xen_check_type(Xen_is_gboolean(numeric), numeric, 2, "gtk_spin_button_set_numeric", "gboolean");
  gtk_spin_button_set_numeric(Xen_to_C_GtkSpinButton_(spin_button), Xen_to_C_gboolean(numeric));
  return(Xen_false);
}

static Xen gxg_gtk_spin_button_get_numeric(Xen spin_button)
{
  #define H_gtk_spin_button_get_numeric "gboolean gtk_spin_button_get_numeric(GtkSpinButton* spin_button)"
  Xen_check_type(Xen_is_GtkSpinButton_(spin_button), spin_button, 1, "gtk_spin_button_get_numeric", "GtkSpinButton*");
  return(C_to_Xen_gboolean(gtk_spin_button_get_numeric(Xen_to_C_GtkSpinButton_(spin_button))));
}

static Xen gxg_gtk_spin_button_spin(Xen spin_button, Xen direction, Xen increment)
{
  #define H_gtk_spin_button_spin "void gtk_spin_button_spin(GtkSpinButton* spin_button, GtkSpinType direction, \
gdouble increment)"
  Xen_check_type(Xen_is_GtkSpinButton_(spin_button), spin_button, 1, "gtk_spin_button_spin", "GtkSpinButton*");
  Xen_check_type(Xen_is_GtkSpinType(direction), direction, 2, "gtk_spin_button_spin", "GtkSpinType");
  Xen_check_type(Xen_is_gdouble(increment), increment, 3, "gtk_spin_button_spin", "gdouble");
  gtk_spin_button_spin(Xen_to_C_GtkSpinButton_(spin_button), Xen_to_C_GtkSpinType(direction), Xen_to_C_gdouble(increment));
  return(Xen_false);
}

static Xen gxg_gtk_spin_button_set_wrap(Xen spin_button, Xen wrap)
{
  #define H_gtk_spin_button_set_wrap "void gtk_spin_button_set_wrap(GtkSpinButton* spin_button, gboolean wrap)"
  Xen_check_type(Xen_is_GtkSpinButton_(spin_button), spin_button, 1, "gtk_spin_button_set_wrap", "GtkSpinButton*");
  Xen_check_type(Xen_is_gboolean(wrap), wrap, 2, "gtk_spin_button_set_wrap", "gboolean");
  gtk_spin_button_set_wrap(Xen_to_C_GtkSpinButton_(spin_button), Xen_to_C_gboolean(wrap));
  return(Xen_false);
}

static Xen gxg_gtk_spin_button_get_wrap(Xen spin_button)
{
  #define H_gtk_spin_button_get_wrap "gboolean gtk_spin_button_get_wrap(GtkSpinButton* spin_button)"
  Xen_check_type(Xen_is_GtkSpinButton_(spin_button), spin_button, 1, "gtk_spin_button_get_wrap", "GtkSpinButton*");
  return(C_to_Xen_gboolean(gtk_spin_button_get_wrap(Xen_to_C_GtkSpinButton_(spin_button))));
}

static Xen gxg_gtk_spin_button_set_snap_to_ticks(Xen spin_button, Xen snap_to_ticks)
{
  #define H_gtk_spin_button_set_snap_to_ticks "void gtk_spin_button_set_snap_to_ticks(GtkSpinButton* spin_button, \
gboolean snap_to_ticks)"
  Xen_check_type(Xen_is_GtkSpinButton_(spin_button), spin_button, 1, "gtk_spin_button_set_snap_to_ticks", "GtkSpinButton*");
  Xen_check_type(Xen_is_gboolean(snap_to_ticks), snap_to_ticks, 2, "gtk_spin_button_set_snap_to_ticks", "gboolean");
  gtk_spin_button_set_snap_to_ticks(Xen_to_C_GtkSpinButton_(spin_button), Xen_to_C_gboolean(snap_to_ticks));
  return(Xen_false);
}

static Xen gxg_gtk_spin_button_get_snap_to_ticks(Xen spin_button)
{
  #define H_gtk_spin_button_get_snap_to_ticks "gboolean gtk_spin_button_get_snap_to_ticks(GtkSpinButton* spin_button)"
  Xen_check_type(Xen_is_GtkSpinButton_(spin_button), spin_button, 1, "gtk_spin_button_get_snap_to_ticks", "GtkSpinButton*");
  return(C_to_Xen_gboolean(gtk_spin_button_get_snap_to_ticks(Xen_to_C_GtkSpinButton_(spin_button))));
}

static Xen gxg_gtk_spin_button_update(Xen spin_button)
{
  #define H_gtk_spin_button_update "void gtk_spin_button_update(GtkSpinButton* spin_button)"
  Xen_check_type(Xen_is_GtkSpinButton_(spin_button), spin_button, 1, "gtk_spin_button_update", "GtkSpinButton*");
  gtk_spin_button_update(Xen_to_C_GtkSpinButton_(spin_button));
  return(Xen_false);
}

static Xen gxg_gtk_statusbar_new(void)
{
  #define H_gtk_statusbar_new "GtkWidget* gtk_statusbar_new( void)"
  return(C_to_Xen_GtkWidget_(gtk_statusbar_new()));
}

static Xen gxg_gtk_statusbar_get_context_id(Xen statusbar, Xen context_description)
{
  #define H_gtk_statusbar_get_context_id "guint gtk_statusbar_get_context_id(GtkStatusbar* statusbar, \
gchar* context_description)"
  Xen_check_type(Xen_is_GtkStatusbar_(statusbar), statusbar, 1, "gtk_statusbar_get_context_id", "GtkStatusbar*");
  Xen_check_type(Xen_is_gchar_(context_description), context_description, 2, "gtk_statusbar_get_context_id", "gchar*");
  return(C_to_Xen_guint(gtk_statusbar_get_context_id(Xen_to_C_GtkStatusbar_(statusbar), Xen_to_C_gchar_(context_description))));
}

static Xen gxg_gtk_statusbar_push(Xen statusbar, Xen context_id, Xen text)
{
  #define H_gtk_statusbar_push "guint gtk_statusbar_push(GtkStatusbar* statusbar, guint context_id, gchar* text)"
  Xen_check_type(Xen_is_GtkStatusbar_(statusbar), statusbar, 1, "gtk_statusbar_push", "GtkStatusbar*");
  Xen_check_type(Xen_is_guint(context_id), context_id, 2, "gtk_statusbar_push", "guint");
  Xen_check_type(Xen_is_gchar_(text), text, 3, "gtk_statusbar_push", "gchar*");
  return(C_to_Xen_guint(gtk_statusbar_push(Xen_to_C_GtkStatusbar_(statusbar), Xen_to_C_guint(context_id), Xen_to_C_gchar_(text))));
}

static Xen gxg_gtk_statusbar_pop(Xen statusbar, Xen context_id)
{
  #define H_gtk_statusbar_pop "void gtk_statusbar_pop(GtkStatusbar* statusbar, guint context_id)"
  Xen_check_type(Xen_is_GtkStatusbar_(statusbar), statusbar, 1, "gtk_statusbar_pop", "GtkStatusbar*");
  Xen_check_type(Xen_is_guint(context_id), context_id, 2, "gtk_statusbar_pop", "guint");
  gtk_statusbar_pop(Xen_to_C_GtkStatusbar_(statusbar), Xen_to_C_guint(context_id));
  return(Xen_false);
}

static Xen gxg_gtk_statusbar_remove(Xen statusbar, Xen context_id, Xen message_id)
{
  #define H_gtk_statusbar_remove "void gtk_statusbar_remove(GtkStatusbar* statusbar, guint context_id, \
guint message_id)"
  Xen_check_type(Xen_is_GtkStatusbar_(statusbar), statusbar, 1, "gtk_statusbar_remove", "GtkStatusbar*");
  Xen_check_type(Xen_is_guint(context_id), context_id, 2, "gtk_statusbar_remove", "guint");
  Xen_check_type(Xen_is_guint(message_id), message_id, 3, "gtk_statusbar_remove", "guint");
  gtk_statusbar_remove(Xen_to_C_GtkStatusbar_(statusbar), Xen_to_C_guint(context_id), Xen_to_C_guint(message_id));
  return(Xen_false);
}

static Xen gxg_gtk_text_buffer_new(Xen table)
{
  #define H_gtk_text_buffer_new "GtkTextBuffer* gtk_text_buffer_new(GtkTextTagTable* table)"
  Xen_check_type(Xen_is_GtkTextTagTable_(table) || Xen_is_false(table), table, 1, "gtk_text_buffer_new", "GtkTextTagTable*");
  return(C_to_Xen_GtkTextBuffer_(gtk_text_buffer_new(Xen_to_C_GtkTextTagTable_(table))));
}

static Xen gxg_gtk_text_buffer_get_line_count(Xen buffer)
{
  #define H_gtk_text_buffer_get_line_count "gint gtk_text_buffer_get_line_count(GtkTextBuffer* buffer)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_get_line_count", "GtkTextBuffer*");
  return(C_to_Xen_gint(gtk_text_buffer_get_line_count(Xen_to_C_GtkTextBuffer_(buffer))));
}

static Xen gxg_gtk_text_buffer_get_char_count(Xen buffer)
{
  #define H_gtk_text_buffer_get_char_count "gint gtk_text_buffer_get_char_count(GtkTextBuffer* buffer)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_get_char_count", "GtkTextBuffer*");
  return(C_to_Xen_gint(gtk_text_buffer_get_char_count(Xen_to_C_GtkTextBuffer_(buffer))));
}

static Xen gxg_gtk_text_buffer_get_tag_table(Xen buffer)
{
  #define H_gtk_text_buffer_get_tag_table "GtkTextTagTable* gtk_text_buffer_get_tag_table(GtkTextBuffer* buffer)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_get_tag_table", "GtkTextBuffer*");
  return(C_to_Xen_GtkTextTagTable_(gtk_text_buffer_get_tag_table(Xen_to_C_GtkTextBuffer_(buffer))));
}

static Xen gxg_gtk_text_buffer_set_text(Xen buffer, Xen text, Xen len)
{
  #define H_gtk_text_buffer_set_text "void gtk_text_buffer_set_text(GtkTextBuffer* buffer, gchar* text, \
gint len)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_set_text", "GtkTextBuffer*");
  Xen_check_type(Xen_is_gchar_(text), text, 2, "gtk_text_buffer_set_text", "gchar*");
  Xen_check_type(Xen_is_gint(len), len, 3, "gtk_text_buffer_set_text", "gint");
  gtk_text_buffer_set_text(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_gchar_(text), Xen_to_C_gint(len));
  return(Xen_false);
}

static Xen gxg_gtk_text_buffer_insert(Xen buffer, Xen iter, Xen text, Xen len)
{
  #define H_gtk_text_buffer_insert "void gtk_text_buffer_insert(GtkTextBuffer* buffer, GtkTextIter* iter, \
gchar* text, gint len)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_insert", "GtkTextBuffer*");
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 2, "gtk_text_buffer_insert", "GtkTextIter*");
  Xen_check_type(Xen_is_gchar_(text), text, 3, "gtk_text_buffer_insert", "gchar*");
  Xen_check_type(Xen_is_gint(len), len, 4, "gtk_text_buffer_insert", "gint");
  gtk_text_buffer_insert(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_GtkTextIter_(iter), Xen_to_C_gchar_(text), Xen_to_C_gint(len));
  return(Xen_false);
}

static Xen gxg_gtk_text_buffer_insert_at_cursor(Xen buffer, Xen text, Xen len)
{
  #define H_gtk_text_buffer_insert_at_cursor "void gtk_text_buffer_insert_at_cursor(GtkTextBuffer* buffer, \
gchar* text, gint len)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_insert_at_cursor", "GtkTextBuffer*");
  Xen_check_type(Xen_is_gchar_(text), text, 2, "gtk_text_buffer_insert_at_cursor", "gchar*");
  Xen_check_type(Xen_is_gint(len), len, 3, "gtk_text_buffer_insert_at_cursor", "gint");
  gtk_text_buffer_insert_at_cursor(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_gchar_(text), Xen_to_C_gint(len));
  return(Xen_false);
}

static Xen gxg_gtk_text_buffer_insert_interactive(Xen buffer, Xen iter, Xen text, Xen len, Xen default_editable)
{
  #define H_gtk_text_buffer_insert_interactive "gboolean gtk_text_buffer_insert_interactive(GtkTextBuffer* buffer, \
GtkTextIter* iter, gchar* text, gint len, gboolean default_editable)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_insert_interactive", "GtkTextBuffer*");
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 2, "gtk_text_buffer_insert_interactive", "GtkTextIter*");
  Xen_check_type(Xen_is_gchar_(text), text, 3, "gtk_text_buffer_insert_interactive", "gchar*");
  Xen_check_type(Xen_is_gint(len), len, 4, "gtk_text_buffer_insert_interactive", "gint");
  Xen_check_type(Xen_is_gboolean(default_editable), default_editable, 5, "gtk_text_buffer_insert_interactive", "gboolean");
  return(C_to_Xen_gboolean(gtk_text_buffer_insert_interactive(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_GtkTextIter_(iter), 
                                                              Xen_to_C_gchar_(text), Xen_to_C_gint(len), Xen_to_C_gboolean(default_editable))));
}

static Xen gxg_gtk_text_buffer_insert_interactive_at_cursor(Xen buffer, Xen text, Xen len, Xen default_editable)
{
  #define H_gtk_text_buffer_insert_interactive_at_cursor "gboolean gtk_text_buffer_insert_interactive_at_cursor(GtkTextBuffer* buffer, \
gchar* text, gint len, gboolean default_editable)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_insert_interactive_at_cursor", "GtkTextBuffer*");
  Xen_check_type(Xen_is_gchar_(text), text, 2, "gtk_text_buffer_insert_interactive_at_cursor", "gchar*");
  Xen_check_type(Xen_is_gint(len), len, 3, "gtk_text_buffer_insert_interactive_at_cursor", "gint");
  Xen_check_type(Xen_is_gboolean(default_editable), default_editable, 4, "gtk_text_buffer_insert_interactive_at_cursor", "gboolean");
  return(C_to_Xen_gboolean(gtk_text_buffer_insert_interactive_at_cursor(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_gchar_(text), 
                                                                        Xen_to_C_gint(len), Xen_to_C_gboolean(default_editable))));
}

static Xen gxg_gtk_text_buffer_insert_range(Xen buffer, Xen iter, Xen start, Xen end)
{
  #define H_gtk_text_buffer_insert_range "void gtk_text_buffer_insert_range(GtkTextBuffer* buffer, GtkTextIter* iter, \
GtkTextIter* start, GtkTextIter* end)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_insert_range", "GtkTextBuffer*");
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 2, "gtk_text_buffer_insert_range", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextIter_(start), start, 3, "gtk_text_buffer_insert_range", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextIter_(end), end, 4, "gtk_text_buffer_insert_range", "GtkTextIter*");
  gtk_text_buffer_insert_range(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_GtkTextIter_(iter), Xen_to_C_GtkTextIter_(start), 
                               Xen_to_C_GtkTextIter_(end));
  return(Xen_false);
}

static Xen gxg_gtk_text_buffer_insert_range_interactive(Xen buffer, Xen iter, Xen start, Xen end, Xen default_editable)
{
  #define H_gtk_text_buffer_insert_range_interactive "gboolean gtk_text_buffer_insert_range_interactive(GtkTextBuffer* buffer, \
GtkTextIter* iter, GtkTextIter* start, GtkTextIter* end, gboolean default_editable)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_insert_range_interactive", "GtkTextBuffer*");
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 2, "gtk_text_buffer_insert_range_interactive", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextIter_(start), start, 3, "gtk_text_buffer_insert_range_interactive", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextIter_(end), end, 4, "gtk_text_buffer_insert_range_interactive", "GtkTextIter*");
  Xen_check_type(Xen_is_gboolean(default_editable), default_editable, 5, "gtk_text_buffer_insert_range_interactive", "gboolean");
  return(C_to_Xen_gboolean(gtk_text_buffer_insert_range_interactive(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_GtkTextIter_(iter), 
                                                                    Xen_to_C_GtkTextIter_(start), Xen_to_C_GtkTextIter_(end), 
                                                                    Xen_to_C_gboolean(default_editable))));
}

static Xen gxg_gtk_text_buffer_insert_with_tags(Xen buffer, Xen iter, Xen text, Xen len, Xen tags)
{
  #define H_gtk_text_buffer_insert_with_tags "void gtk_text_buffer_insert_with_tags(GtkTextBuffer* buffer, \
GtkTextIter* iter, gchar* text, gint len, etc tags)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_insert_with_tags", "GtkTextBuffer*");
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 2, "gtk_text_buffer_insert_with_tags", "GtkTextIter*");
  Xen_check_type(Xen_is_gchar_(text), text, 3, "gtk_text_buffer_insert_with_tags", "gchar*");
  Xen_check_type(Xen_is_gint(len), len, 4, "gtk_text_buffer_insert_with_tags", "gint");
  Xen_check_type(Xen_is_etc(tags), tags, 5, "gtk_text_buffer_insert_with_tags", "etc");
  {
    int etc_len = 0;
    GtkTextBuffer* p_arg0;
    GtkTextIter* p_arg1;
    gchar* p_arg2;
    gint p_arg3;
    if (Xen_is_list(tags)) etc_len = Xen_list_length(tags);
    if (etc_len < 1) Xen_out_of_range_error("gtk_text_buffer_insert_with_tags", 4, tags, "... list must have at least 1 entry");
    if (etc_len > 6) Xen_out_of_range_error("gtk_text_buffer_insert_with_tags", 4, tags, "... list too long (max len: 6)");
    p_arg0 = Xen_to_C_GtkTextBuffer_(buffer);
    p_arg1 = Xen_to_C_GtkTextIter_(iter);
    p_arg2 = Xen_to_C_gchar_(text);
    p_arg3 = Xen_to_C_gint(len);
    switch (etc_len)
      {
        case 1: gtk_text_buffer_insert_with_tags(p_arg0, p_arg1, p_arg2, p_arg3, XLT(tags, 0), NULL); break;
        case 2: gtk_text_buffer_insert_with_tags(p_arg0, p_arg1, p_arg2, p_arg3, XLT(tags, 0), XLT(tags, 1), NULL); break;
        case 3: gtk_text_buffer_insert_with_tags(p_arg0, p_arg1, p_arg2, p_arg3, XLT(tags, 0), XLT(tags, 1), XLT(tags, 2), NULL); break;
        case 4: gtk_text_buffer_insert_with_tags(p_arg0, p_arg1, p_arg2, p_arg3, XLT(tags, 0), XLT(tags, 1), XLT(tags, 2), XLT(tags, 3), NULL); break;
        case 5: gtk_text_buffer_insert_with_tags(p_arg0, p_arg1, p_arg2, p_arg3, XLT(tags, 0), XLT(tags, 1), XLT(tags, 2), XLT(tags, 3), XLT(tags, 4), NULL); break;
        case 6: gtk_text_buffer_insert_with_tags(p_arg0, p_arg1, p_arg2, p_arg3, XLT(tags, 0), XLT(tags, 1), XLT(tags, 2), XLT(tags, 3), XLT(tags, 4), XLT(tags, 5), NULL); break;
      }
    return(Xen_false);
  }
}

static Xen gxg_gtk_text_buffer_insert_with_tags_by_name(Xen buffer, Xen iter, Xen text, Xen len, Xen tags)
{
  #define H_gtk_text_buffer_insert_with_tags_by_name "void gtk_text_buffer_insert_with_tags_by_name(GtkTextBuffer* buffer, \
GtkTextIter* iter, gchar* text, gint len, etc tags)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_insert_with_tags_by_name", "GtkTextBuffer*");
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 2, "gtk_text_buffer_insert_with_tags_by_name", "GtkTextIter*");
  Xen_check_type(Xen_is_gchar_(text), text, 3, "gtk_text_buffer_insert_with_tags_by_name", "gchar*");
  Xen_check_type(Xen_is_gint(len), len, 4, "gtk_text_buffer_insert_with_tags_by_name", "gint");
  Xen_check_type(Xen_is_etc(tags), tags, 5, "gtk_text_buffer_insert_with_tags_by_name", "etc");
  {
    int etc_len = 0;
    GtkTextBuffer* p_arg0;
    GtkTextIter* p_arg1;
    gchar* p_arg2;
    gint p_arg3;
    if (Xen_is_list(tags)) etc_len = Xen_list_length(tags);
    if (etc_len < 1) Xen_out_of_range_error("gtk_text_buffer_insert_with_tags_by_name", 4, tags, "... list must have at least 1 entry");
    if (etc_len > 6) Xen_out_of_range_error("gtk_text_buffer_insert_with_tags_by_name", 4, tags, "... list too long (max len: 6)");
    if ((etc_len % 2) != 0) Xen_out_of_range_error("gtk_text_buffer_insert_with_tags_by_name", 4, tags, "... list len must be multiple of 2");
    p_arg0 = Xen_to_C_GtkTextBuffer_(buffer);
    p_arg1 = Xen_to_C_GtkTextIter_(iter);
    p_arg2 = Xen_to_C_gchar_(text);
    p_arg3 = Xen_to_C_gint(len);
    switch (etc_len)
      {
        case 1: gtk_text_buffer_insert_with_tags_by_name(p_arg0, p_arg1, p_arg2, p_arg3, XLS(tags, 0), NULL); break;
        case 3: gtk_text_buffer_insert_with_tags_by_name(p_arg0, p_arg1, p_arg2, p_arg3, XLS(tags, 0), XLI(tags, 1), XLS(tags, 2), NULL); break;
        case 5: gtk_text_buffer_insert_with_tags_by_name(p_arg0, p_arg1, p_arg2, p_arg3, XLS(tags, 0), XLI(tags, 1), XLS(tags, 2), XLI(tags, 3), XLS(tags, 4), NULL); break;
      }
    return(Xen_false);
  }
}

static Xen gxg_gtk_text_buffer_delete(Xen buffer, Xen start, Xen end)
{
  #define H_gtk_text_buffer_delete "void gtk_text_buffer_delete(GtkTextBuffer* buffer, GtkTextIter* start, \
GtkTextIter* end)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_delete", "GtkTextBuffer*");
  Xen_check_type(Xen_is_GtkTextIter_(start), start, 2, "gtk_text_buffer_delete", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextIter_(end), end, 3, "gtk_text_buffer_delete", "GtkTextIter*");
  gtk_text_buffer_delete(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_GtkTextIter_(start), Xen_to_C_GtkTextIter_(end));
  return(Xen_false);
}

static Xen gxg_gtk_text_buffer_delete_interactive(Xen buffer, Xen start_iter, Xen end_iter, Xen default_editable)
{
  #define H_gtk_text_buffer_delete_interactive "gboolean gtk_text_buffer_delete_interactive(GtkTextBuffer* buffer, \
GtkTextIter* start_iter, GtkTextIter* end_iter, gboolean default_editable)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_delete_interactive", "GtkTextBuffer*");
  Xen_check_type(Xen_is_GtkTextIter_(start_iter), start_iter, 2, "gtk_text_buffer_delete_interactive", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextIter_(end_iter), end_iter, 3, "gtk_text_buffer_delete_interactive", "GtkTextIter*");
  Xen_check_type(Xen_is_gboolean(default_editable), default_editable, 4, "gtk_text_buffer_delete_interactive", "gboolean");
  return(C_to_Xen_gboolean(gtk_text_buffer_delete_interactive(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_GtkTextIter_(start_iter), 
                                                              Xen_to_C_GtkTextIter_(end_iter), Xen_to_C_gboolean(default_editable))));
}

static Xen gxg_gtk_text_buffer_get_text(Xen buffer, Xen start, Xen end, Xen include_hidden_chars)
{
  #define H_gtk_text_buffer_get_text "gchar* gtk_text_buffer_get_text(GtkTextBuffer* buffer, GtkTextIter* start, \
GtkTextIter* end, gboolean include_hidden_chars)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_get_text", "GtkTextBuffer*");
  Xen_check_type(Xen_is_GtkTextIter_(start), start, 2, "gtk_text_buffer_get_text", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextIter_(end), end, 3, "gtk_text_buffer_get_text", "GtkTextIter*");
  Xen_check_type(Xen_is_gboolean(include_hidden_chars), include_hidden_chars, 4, "gtk_text_buffer_get_text", "gboolean");
  {
   gchar* res_ult;
   Xen rtn;
   res_ult = gtk_text_buffer_get_text(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_GtkTextIter_(start), 
                                                                         Xen_to_C_GtkTextIter_(end), Xen_to_C_gboolean(include_hidden_chars));
   rtn = C_to_Xen_gchar_(res_ult);
   g_free(res_ult);
   return(rtn);
  }
}

static Xen gxg_gtk_text_buffer_get_slice(Xen buffer, Xen start, Xen end, Xen include_hidden_chars)
{
  #define H_gtk_text_buffer_get_slice "gchar* gtk_text_buffer_get_slice(GtkTextBuffer* buffer, GtkTextIter* start, \
GtkTextIter* end, gboolean include_hidden_chars)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_get_slice", "GtkTextBuffer*");
  Xen_check_type(Xen_is_GtkTextIter_(start), start, 2, "gtk_text_buffer_get_slice", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextIter_(end), end, 3, "gtk_text_buffer_get_slice", "GtkTextIter*");
  Xen_check_type(Xen_is_gboolean(include_hidden_chars), include_hidden_chars, 4, "gtk_text_buffer_get_slice", "gboolean");
  {
   gchar* res_ult;
   Xen rtn;
   res_ult = gtk_text_buffer_get_slice(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_GtkTextIter_(start), 
                                                                          Xen_to_C_GtkTextIter_(end), Xen_to_C_gboolean(include_hidden_chars));
   rtn = C_to_Xen_gchar_(res_ult);
   g_free(res_ult);
   return(rtn);
  }
}

static Xen gxg_gtk_text_buffer_insert_child_anchor(Xen buffer, Xen iter, Xen anchor)
{
  #define H_gtk_text_buffer_insert_child_anchor "void gtk_text_buffer_insert_child_anchor(GtkTextBuffer* buffer, \
GtkTextIter* iter, GtkTextChildAnchor* anchor)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_insert_child_anchor", "GtkTextBuffer*");
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 2, "gtk_text_buffer_insert_child_anchor", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextChildAnchor_(anchor), anchor, 3, "gtk_text_buffer_insert_child_anchor", "GtkTextChildAnchor*");
  gtk_text_buffer_insert_child_anchor(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_GtkTextIter_(iter), Xen_to_C_GtkTextChildAnchor_(anchor));
  return(Xen_false);
}

static Xen gxg_gtk_text_buffer_create_child_anchor(Xen buffer, Xen iter)
{
  #define H_gtk_text_buffer_create_child_anchor "GtkTextChildAnchor* gtk_text_buffer_create_child_anchor(GtkTextBuffer* buffer, \
GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_create_child_anchor", "GtkTextBuffer*");
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 2, "gtk_text_buffer_create_child_anchor", "GtkTextIter*");
  return(C_to_Xen_GtkTextChildAnchor_(gtk_text_buffer_create_child_anchor(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_buffer_create_mark(Xen buffer, Xen mark_name, Xen where, Xen left_gravity)
{
  #define H_gtk_text_buffer_create_mark "GtkTextMark* gtk_text_buffer_create_mark(GtkTextBuffer* buffer, \
gchar* mark_name, GtkTextIter* where, gboolean left_gravity)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_create_mark", "GtkTextBuffer*");
  Xen_check_type(Xen_is_gchar_(mark_name), mark_name, 2, "gtk_text_buffer_create_mark", "gchar*");
  Xen_check_type(Xen_is_GtkTextIter_(where), where, 3, "gtk_text_buffer_create_mark", "GtkTextIter*");
  Xen_check_type(Xen_is_gboolean(left_gravity), left_gravity, 4, "gtk_text_buffer_create_mark", "gboolean");
  return(C_to_Xen_GtkTextMark_(gtk_text_buffer_create_mark(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_gchar_(mark_name), Xen_to_C_GtkTextIter_(where), 
                                                           Xen_to_C_gboolean(left_gravity))));
}

static Xen gxg_gtk_text_buffer_move_mark(Xen buffer, Xen mark, Xen where)
{
  #define H_gtk_text_buffer_move_mark "void gtk_text_buffer_move_mark(GtkTextBuffer* buffer, GtkTextMark* mark, \
GtkTextIter* where)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_move_mark", "GtkTextBuffer*");
  Xen_check_type(Xen_is_GtkTextMark_(mark), mark, 2, "gtk_text_buffer_move_mark", "GtkTextMark*");
  Xen_check_type(Xen_is_GtkTextIter_(where), where, 3, "gtk_text_buffer_move_mark", "GtkTextIter*");
  gtk_text_buffer_move_mark(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_GtkTextMark_(mark), Xen_to_C_GtkTextIter_(where));
  return(Xen_false);
}

static Xen gxg_gtk_text_buffer_delete_mark(Xen buffer, Xen mark)
{
  #define H_gtk_text_buffer_delete_mark "void gtk_text_buffer_delete_mark(GtkTextBuffer* buffer, GtkTextMark* mark)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_delete_mark", "GtkTextBuffer*");
  Xen_check_type(Xen_is_GtkTextMark_(mark), mark, 2, "gtk_text_buffer_delete_mark", "GtkTextMark*");
  gtk_text_buffer_delete_mark(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_GtkTextMark_(mark));
  return(Xen_false);
}

static Xen gxg_gtk_text_buffer_get_mark(Xen buffer, Xen name)
{
  #define H_gtk_text_buffer_get_mark "GtkTextMark* gtk_text_buffer_get_mark(GtkTextBuffer* buffer, gchar* name)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_get_mark", "GtkTextBuffer*");
  Xen_check_type(Xen_is_gchar_(name), name, 2, "gtk_text_buffer_get_mark", "gchar*");
  return(C_to_Xen_GtkTextMark_(gtk_text_buffer_get_mark(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_gchar_(name))));
}

static Xen gxg_gtk_text_buffer_move_mark_by_name(Xen buffer, Xen name, Xen where)
{
  #define H_gtk_text_buffer_move_mark_by_name "void gtk_text_buffer_move_mark_by_name(GtkTextBuffer* buffer, \
gchar* name, GtkTextIter* where)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_move_mark_by_name", "GtkTextBuffer*");
  Xen_check_type(Xen_is_gchar_(name), name, 2, "gtk_text_buffer_move_mark_by_name", "gchar*");
  Xen_check_type(Xen_is_GtkTextIter_(where), where, 3, "gtk_text_buffer_move_mark_by_name", "GtkTextIter*");
  gtk_text_buffer_move_mark_by_name(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_gchar_(name), Xen_to_C_GtkTextIter_(where));
  return(Xen_false);
}

static Xen gxg_gtk_text_buffer_delete_mark_by_name(Xen buffer, Xen name)
{
  #define H_gtk_text_buffer_delete_mark_by_name "void gtk_text_buffer_delete_mark_by_name(GtkTextBuffer* buffer, \
gchar* name)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_delete_mark_by_name", "GtkTextBuffer*");
  Xen_check_type(Xen_is_gchar_(name), name, 2, "gtk_text_buffer_delete_mark_by_name", "gchar*");
  gtk_text_buffer_delete_mark_by_name(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_gchar_(name));
  return(Xen_false);
}

static Xen gxg_gtk_text_buffer_get_insert(Xen buffer)
{
  #define H_gtk_text_buffer_get_insert "GtkTextMark* gtk_text_buffer_get_insert(GtkTextBuffer* buffer)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_get_insert", "GtkTextBuffer*");
  return(C_to_Xen_GtkTextMark_(gtk_text_buffer_get_insert(Xen_to_C_GtkTextBuffer_(buffer))));
}

static Xen gxg_gtk_text_buffer_get_selection_bound(Xen buffer)
{
  #define H_gtk_text_buffer_get_selection_bound "GtkTextMark* gtk_text_buffer_get_selection_bound(GtkTextBuffer* buffer)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_get_selection_bound", "GtkTextBuffer*");
  return(C_to_Xen_GtkTextMark_(gtk_text_buffer_get_selection_bound(Xen_to_C_GtkTextBuffer_(buffer))));
}

static Xen gxg_gtk_text_buffer_place_cursor(Xen buffer, Xen where)
{
  #define H_gtk_text_buffer_place_cursor "void gtk_text_buffer_place_cursor(GtkTextBuffer* buffer, GtkTextIter* where)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_place_cursor", "GtkTextBuffer*");
  Xen_check_type(Xen_is_GtkTextIter_(where), where, 2, "gtk_text_buffer_place_cursor", "GtkTextIter*");
  gtk_text_buffer_place_cursor(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_GtkTextIter_(where));
  return(Xen_false);
}

static Xen gxg_gtk_text_buffer_apply_tag(Xen buffer, Xen tag, Xen start, Xen end)
{
  #define H_gtk_text_buffer_apply_tag "void gtk_text_buffer_apply_tag(GtkTextBuffer* buffer, GtkTextTag* tag, \
GtkTextIter* start, GtkTextIter* end)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_apply_tag", "GtkTextBuffer*");
  Xen_check_type(Xen_is_GtkTextTag_(tag), tag, 2, "gtk_text_buffer_apply_tag", "GtkTextTag*");
  Xen_check_type(Xen_is_GtkTextIter_(start), start, 3, "gtk_text_buffer_apply_tag", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextIter_(end), end, 4, "gtk_text_buffer_apply_tag", "GtkTextIter*");
  gtk_text_buffer_apply_tag(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_GtkTextTag_(tag), Xen_to_C_GtkTextIter_(start), Xen_to_C_GtkTextIter_(end));
  return(Xen_false);
}

static Xen gxg_gtk_text_buffer_remove_tag(Xen buffer, Xen tag, Xen start, Xen end)
{
  #define H_gtk_text_buffer_remove_tag "void gtk_text_buffer_remove_tag(GtkTextBuffer* buffer, GtkTextTag* tag, \
GtkTextIter* start, GtkTextIter* end)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_remove_tag", "GtkTextBuffer*");
  Xen_check_type(Xen_is_GtkTextTag_(tag), tag, 2, "gtk_text_buffer_remove_tag", "GtkTextTag*");
  Xen_check_type(Xen_is_GtkTextIter_(start), start, 3, "gtk_text_buffer_remove_tag", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextIter_(end), end, 4, "gtk_text_buffer_remove_tag", "GtkTextIter*");
  gtk_text_buffer_remove_tag(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_GtkTextTag_(tag), Xen_to_C_GtkTextIter_(start), Xen_to_C_GtkTextIter_(end));
  return(Xen_false);
}

static Xen gxg_gtk_text_buffer_apply_tag_by_name(Xen buffer, Xen name, Xen start, Xen end)
{
  #define H_gtk_text_buffer_apply_tag_by_name "void gtk_text_buffer_apply_tag_by_name(GtkTextBuffer* buffer, \
gchar* name, GtkTextIter* start, GtkTextIter* end)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_apply_tag_by_name", "GtkTextBuffer*");
  Xen_check_type(Xen_is_gchar_(name), name, 2, "gtk_text_buffer_apply_tag_by_name", "gchar*");
  Xen_check_type(Xen_is_GtkTextIter_(start), start, 3, "gtk_text_buffer_apply_tag_by_name", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextIter_(end), end, 4, "gtk_text_buffer_apply_tag_by_name", "GtkTextIter*");
  gtk_text_buffer_apply_tag_by_name(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_gchar_(name), Xen_to_C_GtkTextIter_(start), 
                                    Xen_to_C_GtkTextIter_(end));
  return(Xen_false);
}

static Xen gxg_gtk_text_buffer_remove_tag_by_name(Xen buffer, Xen name, Xen start, Xen end)
{
  #define H_gtk_text_buffer_remove_tag_by_name "void gtk_text_buffer_remove_tag_by_name(GtkTextBuffer* buffer, \
gchar* name, GtkTextIter* start, GtkTextIter* end)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_remove_tag_by_name", "GtkTextBuffer*");
  Xen_check_type(Xen_is_gchar_(name), name, 2, "gtk_text_buffer_remove_tag_by_name", "gchar*");
  Xen_check_type(Xen_is_GtkTextIter_(start), start, 3, "gtk_text_buffer_remove_tag_by_name", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextIter_(end), end, 4, "gtk_text_buffer_remove_tag_by_name", "GtkTextIter*");
  gtk_text_buffer_remove_tag_by_name(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_gchar_(name), Xen_to_C_GtkTextIter_(start), 
                                     Xen_to_C_GtkTextIter_(end));
  return(Xen_false);
}

static Xen gxg_gtk_text_buffer_remove_all_tags(Xen buffer, Xen start, Xen end)
{
  #define H_gtk_text_buffer_remove_all_tags "void gtk_text_buffer_remove_all_tags(GtkTextBuffer* buffer, \
GtkTextIter* start, GtkTextIter* end)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_remove_all_tags", "GtkTextBuffer*");
  Xen_check_type(Xen_is_GtkTextIter_(start), start, 2, "gtk_text_buffer_remove_all_tags", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextIter_(end), end, 3, "gtk_text_buffer_remove_all_tags", "GtkTextIter*");
  gtk_text_buffer_remove_all_tags(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_GtkTextIter_(start), Xen_to_C_GtkTextIter_(end));
  return(Xen_false);
}

static Xen gxg_gtk_text_buffer_create_tag(Xen buffer, Xen tag_name, Xen tags)
{
  #define H_gtk_text_buffer_create_tag "GtkTextTag* gtk_text_buffer_create_tag(GtkTextBuffer* buffer, \
gchar* tag_name, etc tags)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_create_tag", "GtkTextBuffer*");
  Xen_check_type(Xen_is_gchar_(tag_name), tag_name, 2, "gtk_text_buffer_create_tag", "gchar*");
  if (!Xen_is_bound(tags)) tags = Xen_false; 
  else Xen_check_type(Xen_is_etc(tags), tags, 3, "gtk_text_buffer_create_tag", "etc");
  {
    int etc_len = 0;
    GtkTextTag* res_ult = NULL;
    GtkTextBuffer* p_arg0;
    gchar* p_arg1;
    if (Xen_is_list(tags)) etc_len = Xen_list_length(tags);
    if (etc_len > 6) Xen_out_of_range_error("gtk_text_buffer_create_tag", 2, tags, "... list too long (max len: 6)");
    if ((etc_len % 2) != 0) Xen_out_of_range_error("gtk_text_buffer_create_tag", 2, tags, "... list len must be multiple of 2");
    p_arg0 = Xen_to_C_GtkTextBuffer_(buffer);
    p_arg1 = Xen_to_C_gchar_(tag_name);
    switch (etc_len)
      {
        case 0: res_ult = gtk_text_buffer_create_tag(p_arg0, p_arg1, NULL); break;
        case 2: res_ult = gtk_text_buffer_create_tag(p_arg0, p_arg1, XLS(tags, 0), XLA(tags, 1), NULL); break;
        case 4: res_ult = gtk_text_buffer_create_tag(p_arg0, p_arg1, XLS(tags, 0), XLA(tags, 1), XLS(tags, 2), XLA(tags, 3), NULL); break;
        case 6: res_ult = gtk_text_buffer_create_tag(p_arg0, p_arg1, XLS(tags, 0), XLA(tags, 1), XLS(tags, 2), XLA(tags, 3), XLS(tags, 4), XLA(tags, 5), NULL); break;
      }
    return(C_to_Xen_GtkTextTag_(res_ult));
  }
}

static Xen gxg_gtk_text_buffer_get_iter_at_line_offset(Xen buffer, Xen iter, Xen line_number, Xen char_offset)
{
  #define H_gtk_text_buffer_get_iter_at_line_offset "void gtk_text_buffer_get_iter_at_line_offset(GtkTextBuffer* buffer, \
GtkTextIter* iter, gint line_number, gint char_offset)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_get_iter_at_line_offset", "GtkTextBuffer*");
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 2, "gtk_text_buffer_get_iter_at_line_offset", "GtkTextIter*");
  Xen_check_type(Xen_is_gint(line_number), line_number, 3, "gtk_text_buffer_get_iter_at_line_offset", "gint");
  Xen_check_type(Xen_is_gint(char_offset), char_offset, 4, "gtk_text_buffer_get_iter_at_line_offset", "gint");
  gtk_text_buffer_get_iter_at_line_offset(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_GtkTextIter_(iter), Xen_to_C_gint(line_number), 
                                          Xen_to_C_gint(char_offset));
  return(Xen_false);
}

static Xen gxg_gtk_text_buffer_get_iter_at_line_index(Xen buffer, Xen iter, Xen line_number, Xen byte_index)
{
  #define H_gtk_text_buffer_get_iter_at_line_index "void gtk_text_buffer_get_iter_at_line_index(GtkTextBuffer* buffer, \
GtkTextIter* iter, gint line_number, gint byte_index)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_get_iter_at_line_index", "GtkTextBuffer*");
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 2, "gtk_text_buffer_get_iter_at_line_index", "GtkTextIter*");
  Xen_check_type(Xen_is_gint(line_number), line_number, 3, "gtk_text_buffer_get_iter_at_line_index", "gint");
  Xen_check_type(Xen_is_gint(byte_index), byte_index, 4, "gtk_text_buffer_get_iter_at_line_index", "gint");
  gtk_text_buffer_get_iter_at_line_index(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_GtkTextIter_(iter), Xen_to_C_gint(line_number), 
                                         Xen_to_C_gint(byte_index));
  return(Xen_false);
}

static Xen gxg_gtk_text_buffer_get_iter_at_offset(Xen buffer, Xen iter, Xen char_offset)
{
  #define H_gtk_text_buffer_get_iter_at_offset "void gtk_text_buffer_get_iter_at_offset(GtkTextBuffer* buffer, \
GtkTextIter* iter, gint char_offset)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_get_iter_at_offset", "GtkTextBuffer*");
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 2, "gtk_text_buffer_get_iter_at_offset", "GtkTextIter*");
  Xen_check_type(Xen_is_gint(char_offset), char_offset, 3, "gtk_text_buffer_get_iter_at_offset", "gint");
  gtk_text_buffer_get_iter_at_offset(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_GtkTextIter_(iter), Xen_to_C_gint(char_offset));
  return(Xen_false);
}

static Xen gxg_gtk_text_buffer_get_iter_at_line(Xen buffer, Xen iter, Xen line_number)
{
  #define H_gtk_text_buffer_get_iter_at_line "void gtk_text_buffer_get_iter_at_line(GtkTextBuffer* buffer, \
GtkTextIter* iter, gint line_number)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_get_iter_at_line", "GtkTextBuffer*");
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 2, "gtk_text_buffer_get_iter_at_line", "GtkTextIter*");
  Xen_check_type(Xen_is_gint(line_number), line_number, 3, "gtk_text_buffer_get_iter_at_line", "gint");
  gtk_text_buffer_get_iter_at_line(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_GtkTextIter_(iter), Xen_to_C_gint(line_number));
  return(Xen_false);
}

static Xen gxg_gtk_text_buffer_get_start_iter(Xen buffer, Xen iter)
{
  #define H_gtk_text_buffer_get_start_iter "void gtk_text_buffer_get_start_iter(GtkTextBuffer* buffer, \
GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_get_start_iter", "GtkTextBuffer*");
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 2, "gtk_text_buffer_get_start_iter", "GtkTextIter*");
  gtk_text_buffer_get_start_iter(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_GtkTextIter_(iter));
  return(Xen_false);
}

static Xen gxg_gtk_text_buffer_get_end_iter(Xen buffer, Xen iter)
{
  #define H_gtk_text_buffer_get_end_iter "void gtk_text_buffer_get_end_iter(GtkTextBuffer* buffer, GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_get_end_iter", "GtkTextBuffer*");
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 2, "gtk_text_buffer_get_end_iter", "GtkTextIter*");
  gtk_text_buffer_get_end_iter(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_GtkTextIter_(iter));
  return(Xen_false);
}

static Xen gxg_gtk_text_buffer_get_bounds(Xen buffer, Xen start, Xen end)
{
  #define H_gtk_text_buffer_get_bounds "void gtk_text_buffer_get_bounds(GtkTextBuffer* buffer, GtkTextIter* start, \
GtkTextIter* end)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_get_bounds", "GtkTextBuffer*");
  Xen_check_type(Xen_is_GtkTextIter_(start), start, 2, "gtk_text_buffer_get_bounds", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextIter_(end), end, 3, "gtk_text_buffer_get_bounds", "GtkTextIter*");
  gtk_text_buffer_get_bounds(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_GtkTextIter_(start), Xen_to_C_GtkTextIter_(end));
  return(Xen_false);
}

static Xen gxg_gtk_text_buffer_get_iter_at_mark(Xen buffer, Xen iter, Xen mark)
{
  #define H_gtk_text_buffer_get_iter_at_mark "void gtk_text_buffer_get_iter_at_mark(GtkTextBuffer* buffer, \
GtkTextIter* iter, GtkTextMark* mark)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_get_iter_at_mark", "GtkTextBuffer*");
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 2, "gtk_text_buffer_get_iter_at_mark", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextMark_(mark), mark, 3, "gtk_text_buffer_get_iter_at_mark", "GtkTextMark*");
  gtk_text_buffer_get_iter_at_mark(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_GtkTextIter_(iter), Xen_to_C_GtkTextMark_(mark));
  return(Xen_false);
}

static Xen gxg_gtk_text_buffer_get_iter_at_child_anchor(Xen buffer, Xen iter, Xen anchor)
{
  #define H_gtk_text_buffer_get_iter_at_child_anchor "void gtk_text_buffer_get_iter_at_child_anchor(GtkTextBuffer* buffer, \
GtkTextIter* iter, GtkTextChildAnchor* anchor)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_get_iter_at_child_anchor", "GtkTextBuffer*");
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 2, "gtk_text_buffer_get_iter_at_child_anchor", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextChildAnchor_(anchor), anchor, 3, "gtk_text_buffer_get_iter_at_child_anchor", "GtkTextChildAnchor*");
  gtk_text_buffer_get_iter_at_child_anchor(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_GtkTextIter_(iter), Xen_to_C_GtkTextChildAnchor_(anchor));
  return(Xen_false);
}

static Xen gxg_gtk_text_buffer_get_modified(Xen buffer)
{
  #define H_gtk_text_buffer_get_modified "gboolean gtk_text_buffer_get_modified(GtkTextBuffer* buffer)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_get_modified", "GtkTextBuffer*");
  return(C_to_Xen_gboolean(gtk_text_buffer_get_modified(Xen_to_C_GtkTextBuffer_(buffer))));
}

static Xen gxg_gtk_text_buffer_set_modified(Xen buffer, Xen setting)
{
  #define H_gtk_text_buffer_set_modified "void gtk_text_buffer_set_modified(GtkTextBuffer* buffer, gboolean setting)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_set_modified", "GtkTextBuffer*");
  Xen_check_type(Xen_is_gboolean(setting), setting, 2, "gtk_text_buffer_set_modified", "gboolean");
  gtk_text_buffer_set_modified(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_gboolean(setting));
  return(Xen_false);
}

static Xen gxg_gtk_text_buffer_get_selection_bounds(Xen buffer, Xen start, Xen end)
{
  #define H_gtk_text_buffer_get_selection_bounds "gboolean gtk_text_buffer_get_selection_bounds(GtkTextBuffer* buffer, \
GtkTextIter* start, GtkTextIter* end)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_get_selection_bounds", "GtkTextBuffer*");
  Xen_check_type(Xen_is_GtkTextIter_(start), start, 2, "gtk_text_buffer_get_selection_bounds", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextIter_(end), end, 3, "gtk_text_buffer_get_selection_bounds", "GtkTextIter*");
  return(C_to_Xen_gboolean(gtk_text_buffer_get_selection_bounds(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_GtkTextIter_(start), 
                                                                Xen_to_C_GtkTextIter_(end))));
}

static Xen gxg_gtk_text_buffer_delete_selection(Xen buffer, Xen interactive, Xen default_editable)
{
  #define H_gtk_text_buffer_delete_selection "gboolean gtk_text_buffer_delete_selection(GtkTextBuffer* buffer, \
gboolean interactive, gboolean default_editable)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_delete_selection", "GtkTextBuffer*");
  Xen_check_type(Xen_is_gboolean(interactive), interactive, 2, "gtk_text_buffer_delete_selection", "gboolean");
  Xen_check_type(Xen_is_gboolean(default_editable), default_editable, 3, "gtk_text_buffer_delete_selection", "gboolean");
  return(C_to_Xen_gboolean(gtk_text_buffer_delete_selection(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_gboolean(interactive), 
                                                            Xen_to_C_gboolean(default_editable))));
}

static Xen gxg_gtk_text_buffer_begin_user_action(Xen buffer)
{
  #define H_gtk_text_buffer_begin_user_action "void gtk_text_buffer_begin_user_action(GtkTextBuffer* buffer)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_begin_user_action", "GtkTextBuffer*");
  gtk_text_buffer_begin_user_action(Xen_to_C_GtkTextBuffer_(buffer));
  return(Xen_false);
}

static Xen gxg_gtk_text_buffer_end_user_action(Xen buffer)
{
  #define H_gtk_text_buffer_end_user_action "void gtk_text_buffer_end_user_action(GtkTextBuffer* buffer)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_end_user_action", "GtkTextBuffer*");
  gtk_text_buffer_end_user_action(Xen_to_C_GtkTextBuffer_(buffer));
  return(Xen_false);
}

static Xen gxg_gtk_text_child_anchor_new(void)
{
  #define H_gtk_text_child_anchor_new "GtkTextChildAnchor* gtk_text_child_anchor_new( void)"
  return(C_to_Xen_GtkTextChildAnchor_(gtk_text_child_anchor_new()));
}

static Xen gxg_gtk_text_child_anchor_get_deleted(Xen anchor)
{
  #define H_gtk_text_child_anchor_get_deleted "gboolean gtk_text_child_anchor_get_deleted(GtkTextChildAnchor* anchor)"
  Xen_check_type(Xen_is_GtkTextChildAnchor_(anchor), anchor, 1, "gtk_text_child_anchor_get_deleted", "GtkTextChildAnchor*");
  return(C_to_Xen_gboolean(gtk_text_child_anchor_get_deleted(Xen_to_C_GtkTextChildAnchor_(anchor))));
}

static Xen gxg_gtk_text_iter_get_buffer(Xen iter)
{
  #define H_gtk_text_iter_get_buffer "GtkTextBuffer* gtk_text_iter_get_buffer(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_get_buffer", "GtkTextIter*");
  return(C_to_Xen_GtkTextBuffer_(gtk_text_iter_get_buffer(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_copy(Xen iter)
{
  #define H_gtk_text_iter_copy "GtkTextIter* gtk_text_iter_copy(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_copy", "GtkTextIter*");
  return(C_to_Xen_GtkTextIter_(gtk_text_iter_copy(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_free(Xen iter)
{
  #define H_gtk_text_iter_free "void gtk_text_iter_free(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_free", "GtkTextIter*");
  gtk_text_iter_free(Xen_to_C_GtkTextIter_(iter));
  return(Xen_false);
}

static Xen gxg_gtk_text_iter_get_offset(Xen iter)
{
  #define H_gtk_text_iter_get_offset "gint gtk_text_iter_get_offset(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_get_offset", "GtkTextIter*");
  return(C_to_Xen_gint(gtk_text_iter_get_offset(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_get_line(Xen iter)
{
  #define H_gtk_text_iter_get_line "gint gtk_text_iter_get_line(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_get_line", "GtkTextIter*");
  return(C_to_Xen_gint(gtk_text_iter_get_line(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_get_line_offset(Xen iter)
{
  #define H_gtk_text_iter_get_line_offset "gint gtk_text_iter_get_line_offset(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_get_line_offset", "GtkTextIter*");
  return(C_to_Xen_gint(gtk_text_iter_get_line_offset(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_get_line_index(Xen iter)
{
  #define H_gtk_text_iter_get_line_index "gint gtk_text_iter_get_line_index(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_get_line_index", "GtkTextIter*");
  return(C_to_Xen_gint(gtk_text_iter_get_line_index(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_get_visible_line_offset(Xen iter)
{
  #define H_gtk_text_iter_get_visible_line_offset "gint gtk_text_iter_get_visible_line_offset(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_get_visible_line_offset", "GtkTextIter*");
  return(C_to_Xen_gint(gtk_text_iter_get_visible_line_offset(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_get_visible_line_index(Xen iter)
{
  #define H_gtk_text_iter_get_visible_line_index "gint gtk_text_iter_get_visible_line_index(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_get_visible_line_index", "GtkTextIter*");
  return(C_to_Xen_gint(gtk_text_iter_get_visible_line_index(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_get_char(Xen iter)
{
  #define H_gtk_text_iter_get_char "gunichar gtk_text_iter_get_char(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_get_char", "GtkTextIter*");
  return(C_to_Xen_gunichar(gtk_text_iter_get_char(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_get_slice(Xen start, Xen end)
{
  #define H_gtk_text_iter_get_slice "gchar* gtk_text_iter_get_slice(GtkTextIter* start, GtkTextIter* end)"
  Xen_check_type(Xen_is_GtkTextIter_(start), start, 1, "gtk_text_iter_get_slice", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextIter_(end), end, 2, "gtk_text_iter_get_slice", "GtkTextIter*");
  {
   gchar* res_ult;
   Xen rtn;
   res_ult = gtk_text_iter_get_slice(Xen_to_C_GtkTextIter_(start), Xen_to_C_GtkTextIter_(end));
   rtn = C_to_Xen_gchar_(res_ult);
   g_free(res_ult);
   return(rtn);
  }
}

static Xen gxg_gtk_text_iter_get_text(Xen start, Xen end)
{
  #define H_gtk_text_iter_get_text "gchar* gtk_text_iter_get_text(GtkTextIter* start, GtkTextIter* end)"
  Xen_check_type(Xen_is_GtkTextIter_(start), start, 1, "gtk_text_iter_get_text", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextIter_(end), end, 2, "gtk_text_iter_get_text", "GtkTextIter*");
  {
   gchar* res_ult;
   Xen rtn;
   res_ult = gtk_text_iter_get_text(Xen_to_C_GtkTextIter_(start), Xen_to_C_GtkTextIter_(end));
   rtn = C_to_Xen_gchar_(res_ult);
   g_free(res_ult);
   return(rtn);
  }
}

static Xen gxg_gtk_text_iter_get_visible_slice(Xen start, Xen end)
{
  #define H_gtk_text_iter_get_visible_slice "gchar* gtk_text_iter_get_visible_slice(GtkTextIter* start, \
GtkTextIter* end)"
  Xen_check_type(Xen_is_GtkTextIter_(start), start, 1, "gtk_text_iter_get_visible_slice", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextIter_(end), end, 2, "gtk_text_iter_get_visible_slice", "GtkTextIter*");
  {
   gchar* res_ult;
   Xen rtn;
   res_ult = gtk_text_iter_get_visible_slice(Xen_to_C_GtkTextIter_(start), Xen_to_C_GtkTextIter_(end));
   rtn = C_to_Xen_gchar_(res_ult);
   g_free(res_ult);
   return(rtn);
  }
}

static Xen gxg_gtk_text_iter_get_visible_text(Xen start, Xen end)
{
  #define H_gtk_text_iter_get_visible_text "gchar* gtk_text_iter_get_visible_text(GtkTextIter* start, \
GtkTextIter* end)"
  Xen_check_type(Xen_is_GtkTextIter_(start), start, 1, "gtk_text_iter_get_visible_text", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextIter_(end), end, 2, "gtk_text_iter_get_visible_text", "GtkTextIter*");
  {
   gchar* res_ult;
   Xen rtn;
   res_ult = gtk_text_iter_get_visible_text(Xen_to_C_GtkTextIter_(start), Xen_to_C_GtkTextIter_(end));
   rtn = C_to_Xen_gchar_(res_ult);
   g_free(res_ult);
   return(rtn);
  }
}

static Xen gxg_gtk_text_iter_get_marks(Xen iter)
{
  #define H_gtk_text_iter_get_marks "GSList* gtk_text_iter_get_marks(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_get_marks", "GtkTextIter*");
  return(C_to_Xen_GSList_(gtk_text_iter_get_marks(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_get_child_anchor(Xen iter)
{
  #define H_gtk_text_iter_get_child_anchor "GtkTextChildAnchor* gtk_text_iter_get_child_anchor(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_get_child_anchor", "GtkTextIter*");
  return(C_to_Xen_GtkTextChildAnchor_(gtk_text_iter_get_child_anchor(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_get_toggled_tags(Xen iter, Xen toggled_on)
{
  #define H_gtk_text_iter_get_toggled_tags "GSList* gtk_text_iter_get_toggled_tags(GtkTextIter* iter, \
gboolean toggled_on)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_get_toggled_tags", "GtkTextIter*");
  Xen_check_type(Xen_is_gboolean(toggled_on), toggled_on, 2, "gtk_text_iter_get_toggled_tags", "gboolean");
  return(C_to_Xen_GSList_(gtk_text_iter_get_toggled_tags(Xen_to_C_GtkTextIter_(iter), Xen_to_C_gboolean(toggled_on))));
}

static Xen gxg_gtk_text_iter_ends_tag(Xen iter, Xen tag)
{
  #define H_gtk_text_iter_ends_tag "gboolean gtk_text_iter_ends_tag(GtkTextIter* iter, GtkTextTag* tag)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_ends_tag", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextTag_(tag) || Xen_is_false(tag), tag, 2, "gtk_text_iter_ends_tag", "GtkTextTag*");
  return(C_to_Xen_gboolean(gtk_text_iter_ends_tag(Xen_to_C_GtkTextIter_(iter), Xen_to_C_GtkTextTag_(tag))));
}

static Xen gxg_gtk_text_iter_toggles_tag(Xen iter, Xen tag)
{
  #define H_gtk_text_iter_toggles_tag "gboolean gtk_text_iter_toggles_tag(GtkTextIter* iter, GtkTextTag* tag)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_toggles_tag", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextTag_(tag) || Xen_is_false(tag), tag, 2, "gtk_text_iter_toggles_tag", "GtkTextTag*");
  return(C_to_Xen_gboolean(gtk_text_iter_toggles_tag(Xen_to_C_GtkTextIter_(iter), Xen_to_C_GtkTextTag_(tag))));
}

static Xen gxg_gtk_text_iter_has_tag(Xen iter, Xen tag)
{
  #define H_gtk_text_iter_has_tag "gboolean gtk_text_iter_has_tag(GtkTextIter* iter, GtkTextTag* tag)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_has_tag", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextTag_(tag), tag, 2, "gtk_text_iter_has_tag", "GtkTextTag*");
  return(C_to_Xen_gboolean(gtk_text_iter_has_tag(Xen_to_C_GtkTextIter_(iter), Xen_to_C_GtkTextTag_(tag))));
}

static Xen gxg_gtk_text_iter_get_tags(Xen iter)
{
  #define H_gtk_text_iter_get_tags "GSList* gtk_text_iter_get_tags(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_get_tags", "GtkTextIter*");
  return(C_to_Xen_GSList_(gtk_text_iter_get_tags(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_editable(Xen iter, Xen default_setting)
{
  #define H_gtk_text_iter_editable "gboolean gtk_text_iter_editable(GtkTextIter* iter, gboolean default_setting)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_editable", "GtkTextIter*");
  Xen_check_type(Xen_is_gboolean(default_setting), default_setting, 2, "gtk_text_iter_editable", "gboolean");
  return(C_to_Xen_gboolean(gtk_text_iter_editable(Xen_to_C_GtkTextIter_(iter), Xen_to_C_gboolean(default_setting))));
}

static Xen gxg_gtk_text_iter_can_insert(Xen iter, Xen default_editability)
{
  #define H_gtk_text_iter_can_insert "gboolean gtk_text_iter_can_insert(GtkTextIter* iter, gboolean default_editability)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_can_insert", "GtkTextIter*");
  Xen_check_type(Xen_is_gboolean(default_editability), default_editability, 2, "gtk_text_iter_can_insert", "gboolean");
  return(C_to_Xen_gboolean(gtk_text_iter_can_insert(Xen_to_C_GtkTextIter_(iter), Xen_to_C_gboolean(default_editability))));
}

static Xen gxg_gtk_text_iter_starts_word(Xen iter)
{
  #define H_gtk_text_iter_starts_word "gboolean gtk_text_iter_starts_word(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_starts_word", "GtkTextIter*");
  return(C_to_Xen_gboolean(gtk_text_iter_starts_word(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_ends_word(Xen iter)
{
  #define H_gtk_text_iter_ends_word "gboolean gtk_text_iter_ends_word(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_ends_word", "GtkTextIter*");
  return(C_to_Xen_gboolean(gtk_text_iter_ends_word(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_inside_word(Xen iter)
{
  #define H_gtk_text_iter_inside_word "gboolean gtk_text_iter_inside_word(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_inside_word", "GtkTextIter*");
  return(C_to_Xen_gboolean(gtk_text_iter_inside_word(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_starts_sentence(Xen iter)
{
  #define H_gtk_text_iter_starts_sentence "gboolean gtk_text_iter_starts_sentence(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_starts_sentence", "GtkTextIter*");
  return(C_to_Xen_gboolean(gtk_text_iter_starts_sentence(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_ends_sentence(Xen iter)
{
  #define H_gtk_text_iter_ends_sentence "gboolean gtk_text_iter_ends_sentence(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_ends_sentence", "GtkTextIter*");
  return(C_to_Xen_gboolean(gtk_text_iter_ends_sentence(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_inside_sentence(Xen iter)
{
  #define H_gtk_text_iter_inside_sentence "gboolean gtk_text_iter_inside_sentence(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_inside_sentence", "GtkTextIter*");
  return(C_to_Xen_gboolean(gtk_text_iter_inside_sentence(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_starts_line(Xen iter)
{
  #define H_gtk_text_iter_starts_line "gboolean gtk_text_iter_starts_line(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_starts_line", "GtkTextIter*");
  return(C_to_Xen_gboolean(gtk_text_iter_starts_line(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_ends_line(Xen iter)
{
  #define H_gtk_text_iter_ends_line "gboolean gtk_text_iter_ends_line(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_ends_line", "GtkTextIter*");
  return(C_to_Xen_gboolean(gtk_text_iter_ends_line(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_is_cursor_position(Xen iter)
{
  #define H_gtk_text_iter_is_cursor_position "gboolean gtk_text_iter_is_cursor_position(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_is_cursor_position", "GtkTextIter*");
  return(C_to_Xen_gboolean(gtk_text_iter_is_cursor_position(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_get_chars_in_line(Xen iter)
{
  #define H_gtk_text_iter_get_chars_in_line "gint gtk_text_iter_get_chars_in_line(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_get_chars_in_line", "GtkTextIter*");
  return(C_to_Xen_gint(gtk_text_iter_get_chars_in_line(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_get_bytes_in_line(Xen iter)
{
  #define H_gtk_text_iter_get_bytes_in_line "gint gtk_text_iter_get_bytes_in_line(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_get_bytes_in_line", "GtkTextIter*");
  return(C_to_Xen_gint(gtk_text_iter_get_bytes_in_line(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_get_language(Xen iter)
{
  #define H_gtk_text_iter_get_language "PangoLanguage* gtk_text_iter_get_language(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_get_language", "GtkTextIter*");
  return(C_to_Xen_PangoLanguage_(gtk_text_iter_get_language(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_is_end(Xen iter)
{
  #define H_gtk_text_iter_is_end "gboolean gtk_text_iter_is_end(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_is_end", "GtkTextIter*");
  return(C_to_Xen_gboolean(gtk_text_iter_is_end(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_is_start(Xen iter)
{
  #define H_gtk_text_iter_is_start "gboolean gtk_text_iter_is_start(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_is_start", "GtkTextIter*");
  return(C_to_Xen_gboolean(gtk_text_iter_is_start(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_forward_char(Xen iter)
{
  #define H_gtk_text_iter_forward_char "gboolean gtk_text_iter_forward_char(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_forward_char", "GtkTextIter*");
  return(C_to_Xen_gboolean(gtk_text_iter_forward_char(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_backward_char(Xen iter)
{
  #define H_gtk_text_iter_backward_char "gboolean gtk_text_iter_backward_char(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_backward_char", "GtkTextIter*");
  return(C_to_Xen_gboolean(gtk_text_iter_backward_char(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_forward_chars(Xen iter, Xen count)
{
  #define H_gtk_text_iter_forward_chars "gboolean gtk_text_iter_forward_chars(GtkTextIter* iter, gint count)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_forward_chars", "GtkTextIter*");
  Xen_check_type(Xen_is_gint(count), count, 2, "gtk_text_iter_forward_chars", "gint");
  return(C_to_Xen_gboolean(gtk_text_iter_forward_chars(Xen_to_C_GtkTextIter_(iter), Xen_to_C_gint(count))));
}

static Xen gxg_gtk_text_iter_backward_chars(Xen iter, Xen count)
{
  #define H_gtk_text_iter_backward_chars "gboolean gtk_text_iter_backward_chars(GtkTextIter* iter, gint count)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_backward_chars", "GtkTextIter*");
  Xen_check_type(Xen_is_gint(count), count, 2, "gtk_text_iter_backward_chars", "gint");
  return(C_to_Xen_gboolean(gtk_text_iter_backward_chars(Xen_to_C_GtkTextIter_(iter), Xen_to_C_gint(count))));
}

static Xen gxg_gtk_text_iter_forward_line(Xen iter)
{
  #define H_gtk_text_iter_forward_line "gboolean gtk_text_iter_forward_line(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_forward_line", "GtkTextIter*");
  return(C_to_Xen_gboolean(gtk_text_iter_forward_line(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_backward_line(Xen iter)
{
  #define H_gtk_text_iter_backward_line "gboolean gtk_text_iter_backward_line(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_backward_line", "GtkTextIter*");
  return(C_to_Xen_gboolean(gtk_text_iter_backward_line(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_forward_lines(Xen iter, Xen count)
{
  #define H_gtk_text_iter_forward_lines "gboolean gtk_text_iter_forward_lines(GtkTextIter* iter, gint count)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_forward_lines", "GtkTextIter*");
  Xen_check_type(Xen_is_gint(count), count, 2, "gtk_text_iter_forward_lines", "gint");
  return(C_to_Xen_gboolean(gtk_text_iter_forward_lines(Xen_to_C_GtkTextIter_(iter), Xen_to_C_gint(count))));
}

static Xen gxg_gtk_text_iter_backward_lines(Xen iter, Xen count)
{
  #define H_gtk_text_iter_backward_lines "gboolean gtk_text_iter_backward_lines(GtkTextIter* iter, gint count)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_backward_lines", "GtkTextIter*");
  Xen_check_type(Xen_is_gint(count), count, 2, "gtk_text_iter_backward_lines", "gint");
  return(C_to_Xen_gboolean(gtk_text_iter_backward_lines(Xen_to_C_GtkTextIter_(iter), Xen_to_C_gint(count))));
}

static Xen gxg_gtk_text_iter_forward_word_end(Xen iter)
{
  #define H_gtk_text_iter_forward_word_end "gboolean gtk_text_iter_forward_word_end(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_forward_word_end", "GtkTextIter*");
  return(C_to_Xen_gboolean(gtk_text_iter_forward_word_end(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_backward_word_start(Xen iter)
{
  #define H_gtk_text_iter_backward_word_start "gboolean gtk_text_iter_backward_word_start(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_backward_word_start", "GtkTextIter*");
  return(C_to_Xen_gboolean(gtk_text_iter_backward_word_start(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_forward_word_ends(Xen iter, Xen count)
{
  #define H_gtk_text_iter_forward_word_ends "gboolean gtk_text_iter_forward_word_ends(GtkTextIter* iter, \
gint count)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_forward_word_ends", "GtkTextIter*");
  Xen_check_type(Xen_is_gint(count), count, 2, "gtk_text_iter_forward_word_ends", "gint");
  return(C_to_Xen_gboolean(gtk_text_iter_forward_word_ends(Xen_to_C_GtkTextIter_(iter), Xen_to_C_gint(count))));
}

static Xen gxg_gtk_text_iter_backward_word_starts(Xen iter, Xen count)
{
  #define H_gtk_text_iter_backward_word_starts "gboolean gtk_text_iter_backward_word_starts(GtkTextIter* iter, \
gint count)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_backward_word_starts", "GtkTextIter*");
  Xen_check_type(Xen_is_gint(count), count, 2, "gtk_text_iter_backward_word_starts", "gint");
  return(C_to_Xen_gboolean(gtk_text_iter_backward_word_starts(Xen_to_C_GtkTextIter_(iter), Xen_to_C_gint(count))));
}

static Xen gxg_gtk_text_iter_forward_sentence_end(Xen iter)
{
  #define H_gtk_text_iter_forward_sentence_end "gboolean gtk_text_iter_forward_sentence_end(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_forward_sentence_end", "GtkTextIter*");
  return(C_to_Xen_gboolean(gtk_text_iter_forward_sentence_end(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_backward_sentence_start(Xen iter)
{
  #define H_gtk_text_iter_backward_sentence_start "gboolean gtk_text_iter_backward_sentence_start(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_backward_sentence_start", "GtkTextIter*");
  return(C_to_Xen_gboolean(gtk_text_iter_backward_sentence_start(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_forward_sentence_ends(Xen iter, Xen count)
{
  #define H_gtk_text_iter_forward_sentence_ends "gboolean gtk_text_iter_forward_sentence_ends(GtkTextIter* iter, \
gint count)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_forward_sentence_ends", "GtkTextIter*");
  Xen_check_type(Xen_is_gint(count), count, 2, "gtk_text_iter_forward_sentence_ends", "gint");
  return(C_to_Xen_gboolean(gtk_text_iter_forward_sentence_ends(Xen_to_C_GtkTextIter_(iter), Xen_to_C_gint(count))));
}

static Xen gxg_gtk_text_iter_backward_sentence_starts(Xen iter, Xen count)
{
  #define H_gtk_text_iter_backward_sentence_starts "gboolean gtk_text_iter_backward_sentence_starts(GtkTextIter* iter, \
gint count)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_backward_sentence_starts", "GtkTextIter*");
  Xen_check_type(Xen_is_gint(count), count, 2, "gtk_text_iter_backward_sentence_starts", "gint");
  return(C_to_Xen_gboolean(gtk_text_iter_backward_sentence_starts(Xen_to_C_GtkTextIter_(iter), Xen_to_C_gint(count))));
}

static Xen gxg_gtk_text_iter_forward_cursor_position(Xen iter)
{
  #define H_gtk_text_iter_forward_cursor_position "gboolean gtk_text_iter_forward_cursor_position(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_forward_cursor_position", "GtkTextIter*");
  return(C_to_Xen_gboolean(gtk_text_iter_forward_cursor_position(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_backward_cursor_position(Xen iter)
{
  #define H_gtk_text_iter_backward_cursor_position "gboolean gtk_text_iter_backward_cursor_position(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_backward_cursor_position", "GtkTextIter*");
  return(C_to_Xen_gboolean(gtk_text_iter_backward_cursor_position(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_forward_cursor_positions(Xen iter, Xen count)
{
  #define H_gtk_text_iter_forward_cursor_positions "gboolean gtk_text_iter_forward_cursor_positions(GtkTextIter* iter, \
gint count)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_forward_cursor_positions", "GtkTextIter*");
  Xen_check_type(Xen_is_gint(count), count, 2, "gtk_text_iter_forward_cursor_positions", "gint");
  return(C_to_Xen_gboolean(gtk_text_iter_forward_cursor_positions(Xen_to_C_GtkTextIter_(iter), Xen_to_C_gint(count))));
}

static Xen gxg_gtk_text_iter_backward_cursor_positions(Xen iter, Xen count)
{
  #define H_gtk_text_iter_backward_cursor_positions "gboolean gtk_text_iter_backward_cursor_positions(GtkTextIter* iter, \
gint count)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_backward_cursor_positions", "GtkTextIter*");
  Xen_check_type(Xen_is_gint(count), count, 2, "gtk_text_iter_backward_cursor_positions", "gint");
  return(C_to_Xen_gboolean(gtk_text_iter_backward_cursor_positions(Xen_to_C_GtkTextIter_(iter), Xen_to_C_gint(count))));
}

static Xen gxg_gtk_text_iter_set_offset(Xen iter, Xen char_offset)
{
  #define H_gtk_text_iter_set_offset "void gtk_text_iter_set_offset(GtkTextIter* iter, gint char_offset)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_set_offset", "GtkTextIter*");
  Xen_check_type(Xen_is_gint(char_offset), char_offset, 2, "gtk_text_iter_set_offset", "gint");
  gtk_text_iter_set_offset(Xen_to_C_GtkTextIter_(iter), Xen_to_C_gint(char_offset));
  return(Xen_false);
}

static Xen gxg_gtk_text_iter_set_line(Xen iter, Xen line_number)
{
  #define H_gtk_text_iter_set_line "void gtk_text_iter_set_line(GtkTextIter* iter, gint line_number)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_set_line", "GtkTextIter*");
  Xen_check_type(Xen_is_gint(line_number), line_number, 2, "gtk_text_iter_set_line", "gint");
  gtk_text_iter_set_line(Xen_to_C_GtkTextIter_(iter), Xen_to_C_gint(line_number));
  return(Xen_false);
}

static Xen gxg_gtk_text_iter_set_line_offset(Xen iter, Xen char_on_line)
{
  #define H_gtk_text_iter_set_line_offset "void gtk_text_iter_set_line_offset(GtkTextIter* iter, gint char_on_line)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_set_line_offset", "GtkTextIter*");
  Xen_check_type(Xen_is_gint(char_on_line), char_on_line, 2, "gtk_text_iter_set_line_offset", "gint");
  gtk_text_iter_set_line_offset(Xen_to_C_GtkTextIter_(iter), Xen_to_C_gint(char_on_line));
  return(Xen_false);
}

static Xen gxg_gtk_text_iter_set_line_index(Xen iter, Xen byte_on_line)
{
  #define H_gtk_text_iter_set_line_index "void gtk_text_iter_set_line_index(GtkTextIter* iter, gint byte_on_line)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_set_line_index", "GtkTextIter*");
  Xen_check_type(Xen_is_gint(byte_on_line), byte_on_line, 2, "gtk_text_iter_set_line_index", "gint");
  gtk_text_iter_set_line_index(Xen_to_C_GtkTextIter_(iter), Xen_to_C_gint(byte_on_line));
  return(Xen_false);
}

static Xen gxg_gtk_text_iter_forward_to_end(Xen iter)
{
  #define H_gtk_text_iter_forward_to_end "void gtk_text_iter_forward_to_end(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_forward_to_end", "GtkTextIter*");
  gtk_text_iter_forward_to_end(Xen_to_C_GtkTextIter_(iter));
  return(Xen_false);
}

static Xen gxg_gtk_text_iter_forward_to_line_end(Xen iter)
{
  #define H_gtk_text_iter_forward_to_line_end "gboolean gtk_text_iter_forward_to_line_end(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_forward_to_line_end", "GtkTextIter*");
  return(C_to_Xen_gboolean(gtk_text_iter_forward_to_line_end(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_set_visible_line_offset(Xen iter, Xen char_on_line)
{
  #define H_gtk_text_iter_set_visible_line_offset "void gtk_text_iter_set_visible_line_offset(GtkTextIter* iter, \
gint char_on_line)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_set_visible_line_offset", "GtkTextIter*");
  Xen_check_type(Xen_is_gint(char_on_line), char_on_line, 2, "gtk_text_iter_set_visible_line_offset", "gint");
  gtk_text_iter_set_visible_line_offset(Xen_to_C_GtkTextIter_(iter), Xen_to_C_gint(char_on_line));
  return(Xen_false);
}

static Xen gxg_gtk_text_iter_set_visible_line_index(Xen iter, Xen byte_on_line)
{
  #define H_gtk_text_iter_set_visible_line_index "void gtk_text_iter_set_visible_line_index(GtkTextIter* iter, \
gint byte_on_line)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_set_visible_line_index", "GtkTextIter*");
  Xen_check_type(Xen_is_gint(byte_on_line), byte_on_line, 2, "gtk_text_iter_set_visible_line_index", "gint");
  gtk_text_iter_set_visible_line_index(Xen_to_C_GtkTextIter_(iter), Xen_to_C_gint(byte_on_line));
  return(Xen_false);
}

static Xen gxg_gtk_text_iter_forward_to_tag_toggle(Xen iter, Xen tag)
{
  #define H_gtk_text_iter_forward_to_tag_toggle "gboolean gtk_text_iter_forward_to_tag_toggle(GtkTextIter* iter, \
GtkTextTag* tag)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_forward_to_tag_toggle", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextTag_(tag) || Xen_is_false(tag), tag, 2, "gtk_text_iter_forward_to_tag_toggle", "GtkTextTag*");
  return(C_to_Xen_gboolean(gtk_text_iter_forward_to_tag_toggle(Xen_to_C_GtkTextIter_(iter), Xen_to_C_GtkTextTag_(tag))));
}

static Xen gxg_gtk_text_iter_backward_to_tag_toggle(Xen iter, Xen tag)
{
  #define H_gtk_text_iter_backward_to_tag_toggle "gboolean gtk_text_iter_backward_to_tag_toggle(GtkTextIter* iter, \
GtkTextTag* tag)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_backward_to_tag_toggle", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextTag_(tag) || Xen_is_false(tag), tag, 2, "gtk_text_iter_backward_to_tag_toggle", "GtkTextTag*");
  return(C_to_Xen_gboolean(gtk_text_iter_backward_to_tag_toggle(Xen_to_C_GtkTextIter_(iter), Xen_to_C_GtkTextTag_(tag))));
}

static Xen gxg_gtk_text_iter_forward_find_char(Xen iter, Xen pred, Xen func_info, Xen limit)
{
  #define H_gtk_text_iter_forward_find_char "gboolean gtk_text_iter_forward_find_char(GtkTextIter* iter, \
GtkTextCharPredicate pred, lambda_data func_info, GtkTextIter* limit)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_forward_find_char", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextCharPredicate(pred), pred, 2, "gtk_text_iter_forward_find_char", "GtkTextCharPredicate");
  Xen_check_type(Xen_is_lambda_data(func_info) || Xen_is_false(func_info), func_info, 3, "gtk_text_iter_forward_find_char", "lambda_data");
  Xen_check_type(Xen_is_GtkTextIter_(limit) || Xen_is_false(limit), limit, 4, "gtk_text_iter_forward_find_char", "GtkTextIter*");
  {
    Xen res_ult;
    int loc;
    Xen gxg_ptr = Xen_list_5(Xen_false, func_info, Xen_false, Xen_false, Xen_false);
    loc = xm_protect(gxg_ptr);
    Xen_list_set(gxg_ptr, 2, C_int_to_Xen_integer(loc));
    res_ult = C_to_Xen_gboolean(gtk_text_iter_forward_find_char(Xen_to_C_GtkTextIter_(iter), Xen_to_C_GtkTextCharPredicate(pred), 
                                                                Xen_to_C_lambda_data(func_info), Xen_to_C_GtkTextIter_(limit)));
    xm_unprotect_at(loc);
    return(res_ult);
   }
}

static Xen gxg_gtk_text_iter_backward_find_char(Xen iter, Xen pred, Xen func_info, Xen limit)
{
  #define H_gtk_text_iter_backward_find_char "gboolean gtk_text_iter_backward_find_char(GtkTextIter* iter, \
GtkTextCharPredicate pred, lambda_data func_info, GtkTextIter* limit)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_backward_find_char", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextCharPredicate(pred), pred, 2, "gtk_text_iter_backward_find_char", "GtkTextCharPredicate");
  Xen_check_type(Xen_is_lambda_data(func_info) || Xen_is_false(func_info), func_info, 3, "gtk_text_iter_backward_find_char", "lambda_data");
  Xen_check_type(Xen_is_GtkTextIter_(limit) || Xen_is_false(limit), limit, 4, "gtk_text_iter_backward_find_char", "GtkTextIter*");
  {
    Xen res_ult;
    int loc;
    Xen gxg_ptr = Xen_list_5(Xen_false, func_info, Xen_false, Xen_false, Xen_false);
    loc = xm_protect(gxg_ptr);
    Xen_list_set(gxg_ptr, 2, C_int_to_Xen_integer(loc));
    res_ult = C_to_Xen_gboolean(gtk_text_iter_backward_find_char(Xen_to_C_GtkTextIter_(iter), Xen_to_C_GtkTextCharPredicate(pred), 
                                                                 Xen_to_C_lambda_data(func_info), Xen_to_C_GtkTextIter_(limit)));
    xm_unprotect_at(loc);
    return(res_ult);
   }
}

static Xen gxg_gtk_text_iter_forward_search(Xen iter, Xen str, Xen flags, Xen match_start, Xen match_end, Xen limit)
{
  #define H_gtk_text_iter_forward_search "gboolean gtk_text_iter_forward_search(GtkTextIter* iter, gchar* str, \
GtkTextSearchFlags flags, GtkTextIter* match_start, GtkTextIter* match_end, GtkTextIter* limit)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_forward_search", "GtkTextIter*");
  Xen_check_type(Xen_is_gchar_(str), str, 2, "gtk_text_iter_forward_search", "gchar*");
  Xen_check_type(Xen_is_GtkTextSearchFlags(flags), flags, 3, "gtk_text_iter_forward_search", "GtkTextSearchFlags");
  Xen_check_type(Xen_is_GtkTextIter_(match_start) || Xen_is_false(match_start), match_start, 4, "gtk_text_iter_forward_search", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextIter_(match_end) || Xen_is_false(match_end), match_end, 5, "gtk_text_iter_forward_search", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextIter_(limit) || Xen_is_false(limit), limit, 6, "gtk_text_iter_forward_search", "GtkTextIter*");
  return(C_to_Xen_gboolean(gtk_text_iter_forward_search(Xen_to_C_GtkTextIter_(iter), Xen_to_C_gchar_(str), Xen_to_C_GtkTextSearchFlags(flags), 
                                                        Xen_to_C_GtkTextIter_(match_start), Xen_to_C_GtkTextIter_(match_end), 
                                                        Xen_to_C_GtkTextIter_(limit))));
}

static Xen gxg_gtk_text_iter_backward_search(Xen iter, Xen str, Xen flags, Xen match_start, Xen match_end, Xen limit)
{
  #define H_gtk_text_iter_backward_search "gboolean gtk_text_iter_backward_search(GtkTextIter* iter, \
gchar* str, GtkTextSearchFlags flags, GtkTextIter* match_start, GtkTextIter* match_end, GtkTextIter* limit)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_backward_search", "GtkTextIter*");
  Xen_check_type(Xen_is_gchar_(str), str, 2, "gtk_text_iter_backward_search", "gchar*");
  Xen_check_type(Xen_is_GtkTextSearchFlags(flags), flags, 3, "gtk_text_iter_backward_search", "GtkTextSearchFlags");
  Xen_check_type(Xen_is_GtkTextIter_(match_start) || Xen_is_false(match_start), match_start, 4, "gtk_text_iter_backward_search", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextIter_(match_end) || Xen_is_false(match_end), match_end, 5, "gtk_text_iter_backward_search", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextIter_(limit) || Xen_is_false(limit), limit, 6, "gtk_text_iter_backward_search", "GtkTextIter*");
  return(C_to_Xen_gboolean(gtk_text_iter_backward_search(Xen_to_C_GtkTextIter_(iter), Xen_to_C_gchar_(str), Xen_to_C_GtkTextSearchFlags(flags), 
                                                         Xen_to_C_GtkTextIter_(match_start), Xen_to_C_GtkTextIter_(match_end), 
                                                         Xen_to_C_GtkTextIter_(limit))));
}

static Xen gxg_gtk_text_iter_equal(Xen lhs, Xen rhs)
{
  #define H_gtk_text_iter_equal "gboolean gtk_text_iter_equal(GtkTextIter* lhs, GtkTextIter* rhs)"
  Xen_check_type(Xen_is_GtkTextIter_(lhs), lhs, 1, "gtk_text_iter_equal", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextIter_(rhs), rhs, 2, "gtk_text_iter_equal", "GtkTextIter*");
  return(C_to_Xen_gboolean(gtk_text_iter_equal(Xen_to_C_GtkTextIter_(lhs), Xen_to_C_GtkTextIter_(rhs))));
}

static Xen gxg_gtk_text_iter_compare(Xen lhs, Xen rhs)
{
  #define H_gtk_text_iter_compare "gint gtk_text_iter_compare(GtkTextIter* lhs, GtkTextIter* rhs)"
  Xen_check_type(Xen_is_GtkTextIter_(lhs), lhs, 1, "gtk_text_iter_compare", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextIter_(rhs), rhs, 2, "gtk_text_iter_compare", "GtkTextIter*");
  return(C_to_Xen_gint(gtk_text_iter_compare(Xen_to_C_GtkTextIter_(lhs), Xen_to_C_GtkTextIter_(rhs))));
}

static Xen gxg_gtk_text_iter_in_range(Xen iter, Xen start, Xen end)
{
  #define H_gtk_text_iter_in_range "gboolean gtk_text_iter_in_range(GtkTextIter* iter, GtkTextIter* start, \
GtkTextIter* end)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_in_range", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextIter_(start), start, 2, "gtk_text_iter_in_range", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextIter_(end), end, 3, "gtk_text_iter_in_range", "GtkTextIter*");
  return(C_to_Xen_gboolean(gtk_text_iter_in_range(Xen_to_C_GtkTextIter_(iter), Xen_to_C_GtkTextIter_(start), Xen_to_C_GtkTextIter_(end))));
}

static Xen gxg_gtk_text_iter_order(Xen first, Xen second)
{
  #define H_gtk_text_iter_order "void gtk_text_iter_order(GtkTextIter* first, GtkTextIter* second)"
  Xen_check_type(Xen_is_GtkTextIter_(first), first, 1, "gtk_text_iter_order", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextIter_(second), second, 2, "gtk_text_iter_order", "GtkTextIter*");
  gtk_text_iter_order(Xen_to_C_GtkTextIter_(first), Xen_to_C_GtkTextIter_(second));
  return(Xen_false);
}

static Xen gxg_gtk_text_mark_set_visible(Xen mark, Xen setting)
{
  #define H_gtk_text_mark_set_visible "void gtk_text_mark_set_visible(GtkTextMark* mark, gboolean setting)"
  Xen_check_type(Xen_is_GtkTextMark_(mark), mark, 1, "gtk_text_mark_set_visible", "GtkTextMark*");
  Xen_check_type(Xen_is_gboolean(setting), setting, 2, "gtk_text_mark_set_visible", "gboolean");
  gtk_text_mark_set_visible(Xen_to_C_GtkTextMark_(mark), Xen_to_C_gboolean(setting));
  return(Xen_false);
}

static Xen gxg_gtk_text_mark_get_visible(Xen mark)
{
  #define H_gtk_text_mark_get_visible "gboolean gtk_text_mark_get_visible(GtkTextMark* mark)"
  Xen_check_type(Xen_is_GtkTextMark_(mark), mark, 1, "gtk_text_mark_get_visible", "GtkTextMark*");
  return(C_to_Xen_gboolean(gtk_text_mark_get_visible(Xen_to_C_GtkTextMark_(mark))));
}

static Xen gxg_gtk_text_mark_get_name(Xen mark)
{
  #define H_gtk_text_mark_get_name "char* gtk_text_mark_get_name(GtkTextMark* mark)"
  Xen_check_type(Xen_is_GtkTextMark_(mark), mark, 1, "gtk_text_mark_get_name", "GtkTextMark*");
  return(C_to_Xen_char_(gtk_text_mark_get_name(Xen_to_C_GtkTextMark_(mark))));
}

static Xen gxg_gtk_text_mark_get_deleted(Xen mark)
{
  #define H_gtk_text_mark_get_deleted "gboolean gtk_text_mark_get_deleted(GtkTextMark* mark)"
  Xen_check_type(Xen_is_GtkTextMark_(mark), mark, 1, "gtk_text_mark_get_deleted", "GtkTextMark*");
  return(C_to_Xen_gboolean(gtk_text_mark_get_deleted(Xen_to_C_GtkTextMark_(mark))));
}

static Xen gxg_gtk_text_mark_get_buffer(Xen mark)
{
  #define H_gtk_text_mark_get_buffer "GtkTextBuffer* gtk_text_mark_get_buffer(GtkTextMark* mark)"
  Xen_check_type(Xen_is_GtkTextMark_(mark), mark, 1, "gtk_text_mark_get_buffer", "GtkTextMark*");
  return(C_to_Xen_GtkTextBuffer_(gtk_text_mark_get_buffer(Xen_to_C_GtkTextMark_(mark))));
}

static Xen gxg_gtk_text_mark_get_left_gravity(Xen mark)
{
  #define H_gtk_text_mark_get_left_gravity "gboolean gtk_text_mark_get_left_gravity(GtkTextMark* mark)"
  Xen_check_type(Xen_is_GtkTextMark_(mark), mark, 1, "gtk_text_mark_get_left_gravity", "GtkTextMark*");
  return(C_to_Xen_gboolean(gtk_text_mark_get_left_gravity(Xen_to_C_GtkTextMark_(mark))));
}

static Xen gxg_gtk_text_tag_new(Xen name)
{
  #define H_gtk_text_tag_new "GtkTextTag* gtk_text_tag_new(gchar* name)"
  Xen_check_type(Xen_is_gchar_(name), name, 1, "gtk_text_tag_new", "gchar*");
  return(C_to_Xen_GtkTextTag_(gtk_text_tag_new(Xen_to_C_gchar_(name))));
}

static Xen gxg_gtk_text_tag_get_priority(Xen tag)
{
  #define H_gtk_text_tag_get_priority "gint gtk_text_tag_get_priority(GtkTextTag* tag)"
  Xen_check_type(Xen_is_GtkTextTag_(tag), tag, 1, "gtk_text_tag_get_priority", "GtkTextTag*");
  return(C_to_Xen_gint(gtk_text_tag_get_priority(Xen_to_C_GtkTextTag_(tag))));
}

static Xen gxg_gtk_text_tag_set_priority(Xen tag, Xen priority)
{
  #define H_gtk_text_tag_set_priority "void gtk_text_tag_set_priority(GtkTextTag* tag, gint priority)"
  Xen_check_type(Xen_is_GtkTextTag_(tag), tag, 1, "gtk_text_tag_set_priority", "GtkTextTag*");
  Xen_check_type(Xen_is_gint(priority), priority, 2, "gtk_text_tag_set_priority", "gint");
  gtk_text_tag_set_priority(Xen_to_C_GtkTextTag_(tag), Xen_to_C_gint(priority));
  return(Xen_false);
}

static Xen gxg_gtk_text_tag_table_new(void)
{
  #define H_gtk_text_tag_table_new "GtkTextTagTable* gtk_text_tag_table_new( void)"
  return(C_to_Xen_GtkTextTagTable_(gtk_text_tag_table_new()));
}

static Xen gxg_gtk_text_tag_table_add(Xen table, Xen tag)
{
  #define H_gtk_text_tag_table_add "void gtk_text_tag_table_add(GtkTextTagTable* table, GtkTextTag* tag)"
  Xen_check_type(Xen_is_GtkTextTagTable_(table), table, 1, "gtk_text_tag_table_add", "GtkTextTagTable*");
  Xen_check_type(Xen_is_GtkTextTag_(tag), tag, 2, "gtk_text_tag_table_add", "GtkTextTag*");
  gtk_text_tag_table_add(Xen_to_C_GtkTextTagTable_(table), Xen_to_C_GtkTextTag_(tag));
  return(Xen_false);
}

static Xen gxg_gtk_text_tag_table_remove(Xen table, Xen tag)
{
  #define H_gtk_text_tag_table_remove "void gtk_text_tag_table_remove(GtkTextTagTable* table, GtkTextTag* tag)"
  Xen_check_type(Xen_is_GtkTextTagTable_(table), table, 1, "gtk_text_tag_table_remove", "GtkTextTagTable*");
  Xen_check_type(Xen_is_GtkTextTag_(tag), tag, 2, "gtk_text_tag_table_remove", "GtkTextTag*");
  gtk_text_tag_table_remove(Xen_to_C_GtkTextTagTable_(table), Xen_to_C_GtkTextTag_(tag));
  return(Xen_false);
}

static Xen gxg_gtk_text_tag_table_lookup(Xen table, Xen name)
{
  #define H_gtk_text_tag_table_lookup "GtkTextTag* gtk_text_tag_table_lookup(GtkTextTagTable* table, \
gchar* name)"
  Xen_check_type(Xen_is_GtkTextTagTable_(table), table, 1, "gtk_text_tag_table_lookup", "GtkTextTagTable*");
  Xen_check_type(Xen_is_gchar_(name), name, 2, "gtk_text_tag_table_lookup", "gchar*");
  return(C_to_Xen_GtkTextTag_(gtk_text_tag_table_lookup(Xen_to_C_GtkTextTagTable_(table), Xen_to_C_gchar_(name))));
}

static Xen gxg_gtk_text_tag_table_foreach(Xen table, Xen func, Xen func_info)
{
  #define H_gtk_text_tag_table_foreach "void gtk_text_tag_table_foreach(GtkTextTagTable* table, GtkTextTagTableForeach func, \
lambda_data func_info)"
  Xen_check_type(Xen_is_GtkTextTagTable_(table), table, 1, "gtk_text_tag_table_foreach", "GtkTextTagTable*");
  Xen_check_type(Xen_is_GtkTextTagTableForeach(func), func, 2, "gtk_text_tag_table_foreach", "GtkTextTagTableForeach");
  Xen_check_type(Xen_is_lambda_data(func_info) || Xen_is_false(func_info), func_info, 3, "gtk_text_tag_table_foreach", "lambda_data");
  {
    int loc;
    Xen gxg_ptr = Xen_list_5(func, func_info, Xen_false, Xen_false, Xen_false);
    loc = xm_protect(gxg_ptr);
    Xen_list_set(gxg_ptr, 2, C_int_to_Xen_integer(loc));
    gtk_text_tag_table_foreach(Xen_to_C_GtkTextTagTable_(table), Xen_to_C_GtkTextTagTableForeach(func), Xen_to_C_lambda_data(func_info));
    xm_unprotect_at(loc);
    return(Xen_false);
   }
}

static Xen gxg_gtk_text_tag_table_get_size(Xen table)
{
  #define H_gtk_text_tag_table_get_size "gint gtk_text_tag_table_get_size(GtkTextTagTable* table)"
  Xen_check_type(Xen_is_GtkTextTagTable_(table), table, 1, "gtk_text_tag_table_get_size", "GtkTextTagTable*");
  return(C_to_Xen_gint(gtk_text_tag_table_get_size(Xen_to_C_GtkTextTagTable_(table))));
}

static Xen gxg_gtk_text_view_new(void)
{
  #define H_gtk_text_view_new "GtkWidget* gtk_text_view_new( void)"
  return(C_to_Xen_GtkWidget_(gtk_text_view_new()));
}

static Xen gxg_gtk_text_view_new_with_buffer(Xen buffer)
{
  #define H_gtk_text_view_new_with_buffer "GtkWidget* gtk_text_view_new_with_buffer(GtkTextBuffer* buffer)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_view_new_with_buffer", "GtkTextBuffer*");
  return(C_to_Xen_GtkWidget_(gtk_text_view_new_with_buffer(Xen_to_C_GtkTextBuffer_(buffer))));
}

static Xen gxg_gtk_text_view_set_buffer(Xen text_view, Xen buffer)
{
  #define H_gtk_text_view_set_buffer "void gtk_text_view_set_buffer(GtkTextView* text_view, GtkTextBuffer* buffer)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_set_buffer", "GtkTextView*");
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 2, "gtk_text_view_set_buffer", "GtkTextBuffer*");
  gtk_text_view_set_buffer(Xen_to_C_GtkTextView_(text_view), Xen_to_C_GtkTextBuffer_(buffer));
  return(Xen_false);
}

static Xen gxg_gtk_text_view_get_buffer(Xen text_view)
{
  #define H_gtk_text_view_get_buffer "GtkTextBuffer* gtk_text_view_get_buffer(GtkTextView* text_view)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_get_buffer", "GtkTextView*");
  return(C_to_Xen_GtkTextBuffer_(gtk_text_view_get_buffer(Xen_to_C_GtkTextView_(text_view))));
}

static Xen gxg_gtk_text_view_scroll_to_iter(Xen text_view, Xen iter, Xen within_margin, Xen use_align, Xen xalign, Xen yalign)
{
  #define H_gtk_text_view_scroll_to_iter "gboolean gtk_text_view_scroll_to_iter(GtkTextView* text_view, \
GtkTextIter* iter, gdouble within_margin, gboolean use_align, gdouble xalign, gdouble yalign)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_scroll_to_iter", "GtkTextView*");
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 2, "gtk_text_view_scroll_to_iter", "GtkTextIter*");
  Xen_check_type(Xen_is_gdouble(within_margin), within_margin, 3, "gtk_text_view_scroll_to_iter", "gdouble");
  Xen_check_type(Xen_is_gboolean(use_align), use_align, 4, "gtk_text_view_scroll_to_iter", "gboolean");
  Xen_check_type(Xen_is_gdouble(xalign), xalign, 5, "gtk_text_view_scroll_to_iter", "gdouble");
  Xen_check_type(Xen_is_gdouble(yalign), yalign, 6, "gtk_text_view_scroll_to_iter", "gdouble");
  return(C_to_Xen_gboolean(gtk_text_view_scroll_to_iter(Xen_to_C_GtkTextView_(text_view), Xen_to_C_GtkTextIter_(iter), Xen_to_C_gdouble(within_margin), 
                                                        Xen_to_C_gboolean(use_align), Xen_to_C_gdouble(xalign), Xen_to_C_gdouble(yalign))));
}

static Xen gxg_gtk_text_view_scroll_to_mark(Xen text_view, Xen mark, Xen within_margin, Xen use_align, Xen xalign, Xen yalign)
{
  #define H_gtk_text_view_scroll_to_mark "void gtk_text_view_scroll_to_mark(GtkTextView* text_view, GtkTextMark* mark, \
gdouble within_margin, gboolean use_align, gdouble xalign, gdouble yalign)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_scroll_to_mark", "GtkTextView*");
  Xen_check_type(Xen_is_GtkTextMark_(mark), mark, 2, "gtk_text_view_scroll_to_mark", "GtkTextMark*");
  Xen_check_type(Xen_is_gdouble(within_margin), within_margin, 3, "gtk_text_view_scroll_to_mark", "gdouble");
  Xen_check_type(Xen_is_gboolean(use_align), use_align, 4, "gtk_text_view_scroll_to_mark", "gboolean");
  Xen_check_type(Xen_is_gdouble(xalign), xalign, 5, "gtk_text_view_scroll_to_mark", "gdouble");
  Xen_check_type(Xen_is_gdouble(yalign), yalign, 6, "gtk_text_view_scroll_to_mark", "gdouble");
  gtk_text_view_scroll_to_mark(Xen_to_C_GtkTextView_(text_view), Xen_to_C_GtkTextMark_(mark), Xen_to_C_gdouble(within_margin), 
                               Xen_to_C_gboolean(use_align), Xen_to_C_gdouble(xalign), Xen_to_C_gdouble(yalign));
  return(Xen_false);
}

static Xen gxg_gtk_text_view_scroll_mark_onscreen(Xen text_view, Xen mark)
{
  #define H_gtk_text_view_scroll_mark_onscreen "void gtk_text_view_scroll_mark_onscreen(GtkTextView* text_view, \
GtkTextMark* mark)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_scroll_mark_onscreen", "GtkTextView*");
  Xen_check_type(Xen_is_GtkTextMark_(mark), mark, 2, "gtk_text_view_scroll_mark_onscreen", "GtkTextMark*");
  gtk_text_view_scroll_mark_onscreen(Xen_to_C_GtkTextView_(text_view), Xen_to_C_GtkTextMark_(mark));
  return(Xen_false);
}

static Xen gxg_gtk_text_view_move_mark_onscreen(Xen text_view, Xen mark)
{
  #define H_gtk_text_view_move_mark_onscreen "gboolean gtk_text_view_move_mark_onscreen(GtkTextView* text_view, \
GtkTextMark* mark)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_move_mark_onscreen", "GtkTextView*");
  Xen_check_type(Xen_is_GtkTextMark_(mark), mark, 2, "gtk_text_view_move_mark_onscreen", "GtkTextMark*");
  return(C_to_Xen_gboolean(gtk_text_view_move_mark_onscreen(Xen_to_C_GtkTextView_(text_view), Xen_to_C_GtkTextMark_(mark))));
}

static Xen gxg_gtk_text_view_place_cursor_onscreen(Xen text_view)
{
  #define H_gtk_text_view_place_cursor_onscreen "gboolean gtk_text_view_place_cursor_onscreen(GtkTextView* text_view)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_place_cursor_onscreen", "GtkTextView*");
  return(C_to_Xen_gboolean(gtk_text_view_place_cursor_onscreen(Xen_to_C_GtkTextView_(text_view))));
}

static Xen gxg_gtk_text_view_get_visible_rect(Xen text_view, Xen visible_rect)
{
  #define H_gtk_text_view_get_visible_rect "void gtk_text_view_get_visible_rect(GtkTextView* text_view, \
GdkRectangle* visible_rect)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_get_visible_rect", "GtkTextView*");
  Xen_check_type(Xen_is_GdkRectangle_(visible_rect), visible_rect, 2, "gtk_text_view_get_visible_rect", "GdkRectangle*");
  gtk_text_view_get_visible_rect(Xen_to_C_GtkTextView_(text_view), Xen_to_C_GdkRectangle_(visible_rect));
  return(Xen_false);
}

static Xen gxg_gtk_text_view_set_cursor_visible(Xen text_view, Xen setting)
{
  #define H_gtk_text_view_set_cursor_visible "void gtk_text_view_set_cursor_visible(GtkTextView* text_view, \
gboolean setting)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_set_cursor_visible", "GtkTextView*");
  Xen_check_type(Xen_is_gboolean(setting), setting, 2, "gtk_text_view_set_cursor_visible", "gboolean");
  gtk_text_view_set_cursor_visible(Xen_to_C_GtkTextView_(text_view), Xen_to_C_gboolean(setting));
  return(Xen_false);
}

static Xen gxg_gtk_text_view_get_cursor_visible(Xen text_view)
{
  #define H_gtk_text_view_get_cursor_visible "gboolean gtk_text_view_get_cursor_visible(GtkTextView* text_view)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_get_cursor_visible", "GtkTextView*");
  return(C_to_Xen_gboolean(gtk_text_view_get_cursor_visible(Xen_to_C_GtkTextView_(text_view))));
}

static Xen gxg_gtk_text_view_get_iter_location(Xen text_view, Xen iter, Xen location)
{
  #define H_gtk_text_view_get_iter_location "void gtk_text_view_get_iter_location(GtkTextView* text_view, \
GtkTextIter* iter, GdkRectangle* location)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_get_iter_location", "GtkTextView*");
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 2, "gtk_text_view_get_iter_location", "GtkTextIter*");
  Xen_check_type(Xen_is_GdkRectangle_(location), location, 3, "gtk_text_view_get_iter_location", "GdkRectangle*");
  gtk_text_view_get_iter_location(Xen_to_C_GtkTextView_(text_view), Xen_to_C_GtkTextIter_(iter), Xen_to_C_GdkRectangle_(location));
  return(Xen_false);
}

static Xen gxg_gtk_text_view_get_line_yrange(Xen text_view, Xen iter, Xen ignore_y, Xen ignore_height)
{
  #define H_gtk_text_view_get_line_yrange "void gtk_text_view_get_line_yrange(GtkTextView* text_view, \
GtkTextIter* iter, gint* [y], gint* [height])"
  gint ref_y;
  gint ref_height;
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_get_line_yrange", "GtkTextView*");
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 2, "gtk_text_view_get_line_yrange", "GtkTextIter*");
  gtk_text_view_get_line_yrange(Xen_to_C_GtkTextView_(text_view), Xen_to_C_GtkTextIter_(iter), &ref_y, &ref_height);
  return(Xen_list_2(C_to_Xen_gint(ref_y), C_to_Xen_gint(ref_height)));
}

static Xen gxg_gtk_text_view_get_line_at_y(Xen text_view, Xen target_iter, Xen y, Xen ignore_line_top)
{
  #define H_gtk_text_view_get_line_at_y "void gtk_text_view_get_line_at_y(GtkTextView* text_view, GtkTextIter* target_iter, \
gint y, gint* [line_top])"
  gint ref_line_top;
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_get_line_at_y", "GtkTextView*");
  Xen_check_type(Xen_is_GtkTextIter_(target_iter), target_iter, 2, "gtk_text_view_get_line_at_y", "GtkTextIter*");
  Xen_check_type(Xen_is_gint(y), y, 3, "gtk_text_view_get_line_at_y", "gint");
  gtk_text_view_get_line_at_y(Xen_to_C_GtkTextView_(text_view), Xen_to_C_GtkTextIter_(target_iter), Xen_to_C_gint(y), &ref_line_top);
  return(Xen_list_1(C_to_Xen_gint(ref_line_top)));
}

static Xen gxg_gtk_text_view_window_to_buffer_coords(Xen text_view, Xen win, Xen window_x, Xen window_y, Xen ignore_buffer_x, Xen ignore_buffer_y)
{
  #define H_gtk_text_view_window_to_buffer_coords "void gtk_text_view_window_to_buffer_coords(GtkTextView* text_view, \
GtkTextWindowType win, gint window_x, gint window_y, gint* [buffer_x], gint* [buffer_y])"
  gint ref_buffer_x;
  gint ref_buffer_y;
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_window_to_buffer_coords", "GtkTextView*");
  Xen_check_type(Xen_is_GtkTextWindowType(win), win, 2, "gtk_text_view_window_to_buffer_coords", "GtkTextWindowType");
  Xen_check_type(Xen_is_gint(window_x), window_x, 3, "gtk_text_view_window_to_buffer_coords", "gint");
  Xen_check_type(Xen_is_gint(window_y), window_y, 4, "gtk_text_view_window_to_buffer_coords", "gint");
  gtk_text_view_window_to_buffer_coords(Xen_to_C_GtkTextView_(text_view), Xen_to_C_GtkTextWindowType(win), Xen_to_C_gint(window_x), 
                                        Xen_to_C_gint(window_y), &ref_buffer_x, &ref_buffer_y);
  return(Xen_list_2(C_to_Xen_gint(ref_buffer_x), C_to_Xen_gint(ref_buffer_y)));
}

static Xen gxg_gtk_text_view_forward_display_line(Xen text_view, Xen iter)
{
  #define H_gtk_text_view_forward_display_line "gboolean gtk_text_view_forward_display_line(GtkTextView* text_view, \
GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_forward_display_line", "GtkTextView*");
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 2, "gtk_text_view_forward_display_line", "GtkTextIter*");
  return(C_to_Xen_gboolean(gtk_text_view_forward_display_line(Xen_to_C_GtkTextView_(text_view), Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_view_backward_display_line(Xen text_view, Xen iter)
{
  #define H_gtk_text_view_backward_display_line "gboolean gtk_text_view_backward_display_line(GtkTextView* text_view, \
GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_backward_display_line", "GtkTextView*");
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 2, "gtk_text_view_backward_display_line", "GtkTextIter*");
  return(C_to_Xen_gboolean(gtk_text_view_backward_display_line(Xen_to_C_GtkTextView_(text_view), Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_view_forward_display_line_end(Xen text_view, Xen iter)
{
  #define H_gtk_text_view_forward_display_line_end "gboolean gtk_text_view_forward_display_line_end(GtkTextView* text_view, \
GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_forward_display_line_end", "GtkTextView*");
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 2, "gtk_text_view_forward_display_line_end", "GtkTextIter*");
  return(C_to_Xen_gboolean(gtk_text_view_forward_display_line_end(Xen_to_C_GtkTextView_(text_view), Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_view_backward_display_line_start(Xen text_view, Xen iter)
{
  #define H_gtk_text_view_backward_display_line_start "gboolean gtk_text_view_backward_display_line_start(GtkTextView* text_view, \
GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_backward_display_line_start", "GtkTextView*");
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 2, "gtk_text_view_backward_display_line_start", "GtkTextIter*");
  return(C_to_Xen_gboolean(gtk_text_view_backward_display_line_start(Xen_to_C_GtkTextView_(text_view), Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_view_starts_display_line(Xen text_view, Xen iter)
{
  #define H_gtk_text_view_starts_display_line "gboolean gtk_text_view_starts_display_line(GtkTextView* text_view, \
GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_starts_display_line", "GtkTextView*");
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 2, "gtk_text_view_starts_display_line", "GtkTextIter*");
  return(C_to_Xen_gboolean(gtk_text_view_starts_display_line(Xen_to_C_GtkTextView_(text_view), Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_view_move_visually(Xen text_view, Xen iter, Xen count)
{
  #define H_gtk_text_view_move_visually "gboolean gtk_text_view_move_visually(GtkTextView* text_view, \
GtkTextIter* iter, gint count)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_move_visually", "GtkTextView*");
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 2, "gtk_text_view_move_visually", "GtkTextIter*");
  Xen_check_type(Xen_is_gint(count), count, 3, "gtk_text_view_move_visually", "gint");
  return(C_to_Xen_gboolean(gtk_text_view_move_visually(Xen_to_C_GtkTextView_(text_view), Xen_to_C_GtkTextIter_(iter), Xen_to_C_gint(count))));
}

static Xen gxg_gtk_text_view_add_child_at_anchor(Xen text_view, Xen child, Xen anchor)
{
  #define H_gtk_text_view_add_child_at_anchor "void gtk_text_view_add_child_at_anchor(GtkTextView* text_view, \
GtkWidget* child, GtkTextChildAnchor* anchor)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_add_child_at_anchor", "GtkTextView*");
  Xen_check_type(Xen_is_GtkWidget_(child), child, 2, "gtk_text_view_add_child_at_anchor", "GtkWidget*");
  Xen_check_type(Xen_is_GtkTextChildAnchor_(anchor), anchor, 3, "gtk_text_view_add_child_at_anchor", "GtkTextChildAnchor*");
  gtk_text_view_add_child_at_anchor(Xen_to_C_GtkTextView_(text_view), Xen_to_C_GtkWidget_(child), Xen_to_C_GtkTextChildAnchor_(anchor));
  return(Xen_false);
}

static Xen gxg_gtk_text_view_set_wrap_mode(Xen text_view, Xen wrap_mode)
{
  #define H_gtk_text_view_set_wrap_mode "void gtk_text_view_set_wrap_mode(GtkTextView* text_view, GtkWrapMode wrap_mode)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_set_wrap_mode", "GtkTextView*");
  Xen_check_type(Xen_is_GtkWrapMode(wrap_mode), wrap_mode, 2, "gtk_text_view_set_wrap_mode", "GtkWrapMode");
  gtk_text_view_set_wrap_mode(Xen_to_C_GtkTextView_(text_view), Xen_to_C_GtkWrapMode(wrap_mode));
  return(Xen_false);
}

static Xen gxg_gtk_text_view_get_wrap_mode(Xen text_view)
{
  #define H_gtk_text_view_get_wrap_mode "GtkWrapMode gtk_text_view_get_wrap_mode(GtkTextView* text_view)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_get_wrap_mode", "GtkTextView*");
  return(C_to_Xen_GtkWrapMode(gtk_text_view_get_wrap_mode(Xen_to_C_GtkTextView_(text_view))));
}

static Xen gxg_gtk_text_view_set_editable(Xen text_view, Xen setting)
{
  #define H_gtk_text_view_set_editable "void gtk_text_view_set_editable(GtkTextView* text_view, gboolean setting)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_set_editable", "GtkTextView*");
  Xen_check_type(Xen_is_gboolean(setting), setting, 2, "gtk_text_view_set_editable", "gboolean");
  gtk_text_view_set_editable(Xen_to_C_GtkTextView_(text_view), Xen_to_C_gboolean(setting));
  return(Xen_false);
}

static Xen gxg_gtk_text_view_get_editable(Xen text_view)
{
  #define H_gtk_text_view_get_editable "gboolean gtk_text_view_get_editable(GtkTextView* text_view)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_get_editable", "GtkTextView*");
  return(C_to_Xen_gboolean(gtk_text_view_get_editable(Xen_to_C_GtkTextView_(text_view))));
}

static Xen gxg_gtk_text_view_set_pixels_above_lines(Xen text_view, Xen pixels_above_lines)
{
  #define H_gtk_text_view_set_pixels_above_lines "void gtk_text_view_set_pixels_above_lines(GtkTextView* text_view, \
gint pixels_above_lines)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_set_pixels_above_lines", "GtkTextView*");
  Xen_check_type(Xen_is_gint(pixels_above_lines), pixels_above_lines, 2, "gtk_text_view_set_pixels_above_lines", "gint");
  gtk_text_view_set_pixels_above_lines(Xen_to_C_GtkTextView_(text_view), Xen_to_C_gint(pixels_above_lines));
  return(Xen_false);
}

static Xen gxg_gtk_text_view_get_pixels_above_lines(Xen text_view)
{
  #define H_gtk_text_view_get_pixels_above_lines "gint gtk_text_view_get_pixels_above_lines(GtkTextView* text_view)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_get_pixels_above_lines", "GtkTextView*");
  return(C_to_Xen_gint(gtk_text_view_get_pixels_above_lines(Xen_to_C_GtkTextView_(text_view))));
}

static Xen gxg_gtk_text_view_set_pixels_below_lines(Xen text_view, Xen pixels_below_lines)
{
  #define H_gtk_text_view_set_pixels_below_lines "void gtk_text_view_set_pixels_below_lines(GtkTextView* text_view, \
gint pixels_below_lines)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_set_pixels_below_lines", "GtkTextView*");
  Xen_check_type(Xen_is_gint(pixels_below_lines), pixels_below_lines, 2, "gtk_text_view_set_pixels_below_lines", "gint");
  gtk_text_view_set_pixels_below_lines(Xen_to_C_GtkTextView_(text_view), Xen_to_C_gint(pixels_below_lines));
  return(Xen_false);
}

static Xen gxg_gtk_text_view_get_pixels_below_lines(Xen text_view)
{
  #define H_gtk_text_view_get_pixels_below_lines "gint gtk_text_view_get_pixels_below_lines(GtkTextView* text_view)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_get_pixels_below_lines", "GtkTextView*");
  return(C_to_Xen_gint(gtk_text_view_get_pixels_below_lines(Xen_to_C_GtkTextView_(text_view))));
}

static Xen gxg_gtk_text_view_set_pixels_inside_wrap(Xen text_view, Xen pixels_inside_wrap)
{
  #define H_gtk_text_view_set_pixels_inside_wrap "void gtk_text_view_set_pixels_inside_wrap(GtkTextView* text_view, \
gint pixels_inside_wrap)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_set_pixels_inside_wrap", "GtkTextView*");
  Xen_check_type(Xen_is_gint(pixels_inside_wrap), pixels_inside_wrap, 2, "gtk_text_view_set_pixels_inside_wrap", "gint");
  gtk_text_view_set_pixels_inside_wrap(Xen_to_C_GtkTextView_(text_view), Xen_to_C_gint(pixels_inside_wrap));
  return(Xen_false);
}

static Xen gxg_gtk_text_view_get_pixels_inside_wrap(Xen text_view)
{
  #define H_gtk_text_view_get_pixels_inside_wrap "gint gtk_text_view_get_pixels_inside_wrap(GtkTextView* text_view)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_get_pixels_inside_wrap", "GtkTextView*");
  return(C_to_Xen_gint(gtk_text_view_get_pixels_inside_wrap(Xen_to_C_GtkTextView_(text_view))));
}

static Xen gxg_gtk_text_view_set_justification(Xen text_view, Xen justification)
{
  #define H_gtk_text_view_set_justification "void gtk_text_view_set_justification(GtkTextView* text_view, \
GtkJustification justification)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_set_justification", "GtkTextView*");
  Xen_check_type(Xen_is_GtkJustification(justification), justification, 2, "gtk_text_view_set_justification", "GtkJustification");
  gtk_text_view_set_justification(Xen_to_C_GtkTextView_(text_view), Xen_to_C_GtkJustification(justification));
  return(Xen_false);
}

static Xen gxg_gtk_text_view_get_justification(Xen text_view)
{
  #define H_gtk_text_view_get_justification "GtkJustification gtk_text_view_get_justification(GtkTextView* text_view)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_get_justification", "GtkTextView*");
  return(C_to_Xen_GtkJustification(gtk_text_view_get_justification(Xen_to_C_GtkTextView_(text_view))));
}

static Xen gxg_gtk_text_view_set_left_margin(Xen text_view, Xen left_margin)
{
  #define H_gtk_text_view_set_left_margin "void gtk_text_view_set_left_margin(GtkTextView* text_view, \
gint left_margin)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_set_left_margin", "GtkTextView*");
  Xen_check_type(Xen_is_gint(left_margin), left_margin, 2, "gtk_text_view_set_left_margin", "gint");
  gtk_text_view_set_left_margin(Xen_to_C_GtkTextView_(text_view), Xen_to_C_gint(left_margin));
  return(Xen_false);
}

static Xen gxg_gtk_text_view_get_left_margin(Xen text_view)
{
  #define H_gtk_text_view_get_left_margin "gint gtk_text_view_get_left_margin(GtkTextView* text_view)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_get_left_margin", "GtkTextView*");
  return(C_to_Xen_gint(gtk_text_view_get_left_margin(Xen_to_C_GtkTextView_(text_view))));
}

static Xen gxg_gtk_text_view_set_right_margin(Xen text_view, Xen right_margin)
{
  #define H_gtk_text_view_set_right_margin "void gtk_text_view_set_right_margin(GtkTextView* text_view, \
gint right_margin)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_set_right_margin", "GtkTextView*");
  Xen_check_type(Xen_is_gint(right_margin), right_margin, 2, "gtk_text_view_set_right_margin", "gint");
  gtk_text_view_set_right_margin(Xen_to_C_GtkTextView_(text_view), Xen_to_C_gint(right_margin));
  return(Xen_false);
}

static Xen gxg_gtk_text_view_get_right_margin(Xen text_view)
{
  #define H_gtk_text_view_get_right_margin "gint gtk_text_view_get_right_margin(GtkTextView* text_view)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_get_right_margin", "GtkTextView*");
  return(C_to_Xen_gint(gtk_text_view_get_right_margin(Xen_to_C_GtkTextView_(text_view))));
}

static Xen gxg_gtk_text_view_set_indent(Xen text_view, Xen indent)
{
  #define H_gtk_text_view_set_indent "void gtk_text_view_set_indent(GtkTextView* text_view, gint indent)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_set_indent", "GtkTextView*");
  Xen_check_type(Xen_is_gint(indent), indent, 2, "gtk_text_view_set_indent", "gint");
  gtk_text_view_set_indent(Xen_to_C_GtkTextView_(text_view), Xen_to_C_gint(indent));
  return(Xen_false);
}

static Xen gxg_gtk_text_view_get_indent(Xen text_view)
{
  #define H_gtk_text_view_get_indent "gint gtk_text_view_get_indent(GtkTextView* text_view)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_get_indent", "GtkTextView*");
  return(C_to_Xen_gint(gtk_text_view_get_indent(Xen_to_C_GtkTextView_(text_view))));
}

static Xen gxg_gtk_text_view_set_tabs(Xen text_view, Xen tabs)
{
  #define H_gtk_text_view_set_tabs "void gtk_text_view_set_tabs(GtkTextView* text_view, PangoTabArray* tabs)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_set_tabs", "GtkTextView*");
  Xen_check_type(Xen_is_PangoTabArray_(tabs) || Xen_is_false(tabs), tabs, 2, "gtk_text_view_set_tabs", "PangoTabArray*");
  gtk_text_view_set_tabs(Xen_to_C_GtkTextView_(text_view), Xen_to_C_PangoTabArray_(tabs));
  return(Xen_false);
}

static Xen gxg_gtk_text_view_get_tabs(Xen text_view)
{
  #define H_gtk_text_view_get_tabs "PangoTabArray* gtk_text_view_get_tabs(GtkTextView* text_view)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_get_tabs", "GtkTextView*");
  return(C_to_Xen_PangoTabArray_(gtk_text_view_get_tabs(Xen_to_C_GtkTextView_(text_view))));
}

static Xen gxg_gtk_toggle_button_new(void)
{
  #define H_gtk_toggle_button_new "GtkWidget* gtk_toggle_button_new( void)"
  return(C_to_Xen_GtkWidget_(gtk_toggle_button_new()));
}

static Xen gxg_gtk_toggle_button_new_with_label(Xen label)
{
  #define H_gtk_toggle_button_new_with_label "GtkWidget* gtk_toggle_button_new_with_label(gchar* label)"
  Xen_check_type(Xen_is_gchar_(label), label, 1, "gtk_toggle_button_new_with_label", "gchar*");
  return(C_to_Xen_GtkWidget_(gtk_toggle_button_new_with_label(Xen_to_C_gchar_(label))));
}

static Xen gxg_gtk_toggle_button_new_with_mnemonic(Xen label)
{
  #define H_gtk_toggle_button_new_with_mnemonic "GtkWidget* gtk_toggle_button_new_with_mnemonic(gchar* label)"
  Xen_check_type(Xen_is_gchar_(label), label, 1, "gtk_toggle_button_new_with_mnemonic", "gchar*");
  return(C_to_Xen_GtkWidget_(gtk_toggle_button_new_with_mnemonic(Xen_to_C_gchar_(label))));
}

static Xen gxg_gtk_toggle_button_set_active(Xen toggle_button, Xen is_active)
{
  #define H_gtk_toggle_button_set_active "void gtk_toggle_button_set_active(GtkToggleButton* toggle_button, \
gboolean is_active)"
  Xen_check_type(Xen_is_GtkToggleButton_(toggle_button), toggle_button, 1, "gtk_toggle_button_set_active", "GtkToggleButton*");
  Xen_check_type(Xen_is_gboolean(is_active), is_active, 2, "gtk_toggle_button_set_active", "gboolean");
  gtk_toggle_button_set_active(Xen_to_C_GtkToggleButton_(toggle_button), Xen_to_C_gboolean(is_active));
  return(Xen_false);
}

static Xen gxg_gtk_toggle_button_get_active(Xen toggle_button)
{
  #define H_gtk_toggle_button_get_active "gboolean gtk_toggle_button_get_active(GtkToggleButton* toggle_button)"
  Xen_check_type(Xen_is_GtkToggleButton_(toggle_button), toggle_button, 1, "gtk_toggle_button_get_active", "GtkToggleButton*");
  return(C_to_Xen_gboolean(gtk_toggle_button_get_active(Xen_to_C_GtkToggleButton_(toggle_button))));
}

static Xen gxg_gtk_toggle_button_toggled(Xen toggle_button)
{
  #define H_gtk_toggle_button_toggled "void gtk_toggle_button_toggled(GtkToggleButton* toggle_button)"
  Xen_check_type(Xen_is_GtkToggleButton_(toggle_button), toggle_button, 1, "gtk_toggle_button_toggled", "GtkToggleButton*");
  gtk_toggle_button_toggled(Xen_to_C_GtkToggleButton_(toggle_button));
  return(Xen_false);
}

static Xen gxg_gtk_tree_drag_source_row_draggable(Xen drag_source, Xen path)
{
  #define H_gtk_tree_drag_source_row_draggable "gboolean gtk_tree_drag_source_row_draggable(GtkTreeDragSource* drag_source, \
GtkTreePath* path)"
  Xen_check_type(Xen_is_GtkTreeDragSource_(drag_source), drag_source, 1, "gtk_tree_drag_source_row_draggable", "GtkTreeDragSource*");
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 2, "gtk_tree_drag_source_row_draggable", "GtkTreePath*");
  return(C_to_Xen_gboolean(gtk_tree_drag_source_row_draggable(Xen_to_C_GtkTreeDragSource_(drag_source), Xen_to_C_GtkTreePath_(path))));
}

static Xen gxg_gtk_tree_drag_source_drag_data_delete(Xen drag_source, Xen path)
{
  #define H_gtk_tree_drag_source_drag_data_delete "gboolean gtk_tree_drag_source_drag_data_delete(GtkTreeDragSource* drag_source, \
GtkTreePath* path)"
  Xen_check_type(Xen_is_GtkTreeDragSource_(drag_source), drag_source, 1, "gtk_tree_drag_source_drag_data_delete", "GtkTreeDragSource*");
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 2, "gtk_tree_drag_source_drag_data_delete", "GtkTreePath*");
  return(C_to_Xen_gboolean(gtk_tree_drag_source_drag_data_delete(Xen_to_C_GtkTreeDragSource_(drag_source), Xen_to_C_GtkTreePath_(path))));
}

static Xen gxg_gtk_tree_path_new(void)
{
  #define H_gtk_tree_path_new "GtkTreePath* gtk_tree_path_new( void)"
  return(C_to_Xen_GtkTreePath_(gtk_tree_path_new()));
}

static Xen gxg_gtk_tree_path_new_from_string(Xen path)
{
  #define H_gtk_tree_path_new_from_string "GtkTreePath* gtk_tree_path_new_from_string(gchar* path)"
  Xen_check_type(Xen_is_gchar_(path), path, 1, "gtk_tree_path_new_from_string", "gchar*");
  return(C_to_Xen_GtkTreePath_(gtk_tree_path_new_from_string(Xen_to_C_gchar_(path))));
}

static Xen gxg_gtk_tree_path_to_string(Xen path)
{
  #define H_gtk_tree_path_to_string "gchar* gtk_tree_path_to_string(GtkTreePath* path)"
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 1, "gtk_tree_path_to_string", "GtkTreePath*");
  {
   gchar* res_ult;
   Xen rtn;
   res_ult = gtk_tree_path_to_string(Xen_to_C_GtkTreePath_(path));
   rtn = C_to_Xen_gchar_(res_ult);
   g_free(res_ult);
   return(rtn);
  }
}

static Xen gxg_gtk_tree_path_new_first(void)
{
  #define H_gtk_tree_path_new_first "GtkTreePath* gtk_tree_path_new_first( void)"
  return(C_to_Xen_GtkTreePath_(gtk_tree_path_new_first()));
}

static Xen gxg_gtk_tree_path_append_index(Xen path, Xen index)
{
  #define H_gtk_tree_path_append_index "void gtk_tree_path_append_index(GtkTreePath* path, gint index)"
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 1, "gtk_tree_path_append_index", "GtkTreePath*");
  Xen_check_type(Xen_is_gint(index), index, 2, "gtk_tree_path_append_index", "gint");
  gtk_tree_path_append_index(Xen_to_C_GtkTreePath_(path), Xen_to_C_gint(index));
  return(Xen_false);
}

static Xen gxg_gtk_tree_path_prepend_index(Xen path, Xen index)
{
  #define H_gtk_tree_path_prepend_index "void gtk_tree_path_prepend_index(GtkTreePath* path, gint index)"
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 1, "gtk_tree_path_prepend_index", "GtkTreePath*");
  Xen_check_type(Xen_is_gint(index), index, 2, "gtk_tree_path_prepend_index", "gint");
  gtk_tree_path_prepend_index(Xen_to_C_GtkTreePath_(path), Xen_to_C_gint(index));
  return(Xen_false);
}

static Xen gxg_gtk_tree_path_get_depth(Xen path)
{
  #define H_gtk_tree_path_get_depth "gint gtk_tree_path_get_depth(GtkTreePath* path)"
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 1, "gtk_tree_path_get_depth", "GtkTreePath*");
  return(C_to_Xen_gint(gtk_tree_path_get_depth(Xen_to_C_GtkTreePath_(path))));
}

static Xen gxg_gtk_tree_path_get_indices(Xen path)
{
  #define H_gtk_tree_path_get_indices "gint* gtk_tree_path_get_indices(GtkTreePath* path)"
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 1, "gtk_tree_path_get_indices", "GtkTreePath*");
  return(C_to_Xen_gint_(gtk_tree_path_get_indices(Xen_to_C_GtkTreePath_(path))));
}

static Xen gxg_gtk_tree_path_free(Xen path)
{
  #define H_gtk_tree_path_free "void gtk_tree_path_free(GtkTreePath* path)"
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 1, "gtk_tree_path_free", "GtkTreePath*");
  gtk_tree_path_free(Xen_to_C_GtkTreePath_(path));
  return(Xen_false);
}

static Xen gxg_gtk_tree_path_copy(Xen path)
{
  #define H_gtk_tree_path_copy "GtkTreePath* gtk_tree_path_copy(GtkTreePath* path)"
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 1, "gtk_tree_path_copy", "GtkTreePath*");
  return(C_to_Xen_GtkTreePath_(gtk_tree_path_copy(Xen_to_C_GtkTreePath_(path))));
}

static Xen gxg_gtk_tree_path_compare(Xen a, Xen b)
{
  #define H_gtk_tree_path_compare "gint gtk_tree_path_compare(GtkTreePath* a, GtkTreePath* b)"
  Xen_check_type(Xen_is_GtkTreePath_(a), a, 1, "gtk_tree_path_compare", "GtkTreePath*");
  Xen_check_type(Xen_is_GtkTreePath_(b), b, 2, "gtk_tree_path_compare", "GtkTreePath*");
  return(C_to_Xen_gint(gtk_tree_path_compare(Xen_to_C_GtkTreePath_(a), Xen_to_C_GtkTreePath_(b))));
}

static Xen gxg_gtk_tree_path_next(Xen path)
{
  #define H_gtk_tree_path_next "void gtk_tree_path_next(GtkTreePath* path)"
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 1, "gtk_tree_path_next", "GtkTreePath*");
  gtk_tree_path_next(Xen_to_C_GtkTreePath_(path));
  return(Xen_false);
}

static Xen gxg_gtk_tree_path_prev(Xen path)
{
  #define H_gtk_tree_path_prev "gboolean gtk_tree_path_prev(GtkTreePath* path)"
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 1, "gtk_tree_path_prev", "GtkTreePath*");
  return(C_to_Xen_gboolean(gtk_tree_path_prev(Xen_to_C_GtkTreePath_(path))));
}

static Xen gxg_gtk_tree_path_up(Xen path)
{
  #define H_gtk_tree_path_up "gboolean gtk_tree_path_up(GtkTreePath* path)"
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 1, "gtk_tree_path_up", "GtkTreePath*");
  return(C_to_Xen_gboolean(gtk_tree_path_up(Xen_to_C_GtkTreePath_(path))));
}

static Xen gxg_gtk_tree_path_down(Xen path)
{
  #define H_gtk_tree_path_down "void gtk_tree_path_down(GtkTreePath* path)"
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 1, "gtk_tree_path_down", "GtkTreePath*");
  gtk_tree_path_down(Xen_to_C_GtkTreePath_(path));
  return(Xen_false);
}

static Xen gxg_gtk_tree_path_is_ancestor(Xen path, Xen descendant)
{
  #define H_gtk_tree_path_is_ancestor "gboolean gtk_tree_path_is_ancestor(GtkTreePath* path, GtkTreePath* descendant)"
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 1, "gtk_tree_path_is_ancestor", "GtkTreePath*");
  Xen_check_type(Xen_is_GtkTreePath_(descendant), descendant, 2, "gtk_tree_path_is_ancestor", "GtkTreePath*");
  return(C_to_Xen_gboolean(gtk_tree_path_is_ancestor(Xen_to_C_GtkTreePath_(path), Xen_to_C_GtkTreePath_(descendant))));
}

static Xen gxg_gtk_tree_path_is_descendant(Xen path, Xen ancestor)
{
  #define H_gtk_tree_path_is_descendant "gboolean gtk_tree_path_is_descendant(GtkTreePath* path, GtkTreePath* ancestor)"
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 1, "gtk_tree_path_is_descendant", "GtkTreePath*");
  Xen_check_type(Xen_is_GtkTreePath_(ancestor), ancestor, 2, "gtk_tree_path_is_descendant", "GtkTreePath*");
  return(C_to_Xen_gboolean(gtk_tree_path_is_descendant(Xen_to_C_GtkTreePath_(path), Xen_to_C_GtkTreePath_(ancestor))));
}

static Xen gxg_gtk_tree_row_reference_new(Xen model, Xen path)
{
  #define H_gtk_tree_row_reference_new "GtkTreeRowReference* gtk_tree_row_reference_new(GtkTreeModel* model, \
GtkTreePath* path)"
  Xen_check_type(Xen_is_GtkTreeModel_(model), model, 1, "gtk_tree_row_reference_new", "GtkTreeModel*");
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 2, "gtk_tree_row_reference_new", "GtkTreePath*");
  return(C_to_Xen_GtkTreeRowReference_(gtk_tree_row_reference_new(Xen_to_C_GtkTreeModel_(model), Xen_to_C_GtkTreePath_(path))));
}

static Xen gxg_gtk_tree_row_reference_new_proxy(Xen proxy, Xen model, Xen path)
{
  #define H_gtk_tree_row_reference_new_proxy "GtkTreeRowReference* gtk_tree_row_reference_new_proxy(GObject* proxy, \
GtkTreeModel* model, GtkTreePath* path)"
  Xen_check_type(Xen_is_GObject_(proxy), proxy, 1, "gtk_tree_row_reference_new_proxy", "GObject*");
  Xen_check_type(Xen_is_GtkTreeModel_(model), model, 2, "gtk_tree_row_reference_new_proxy", "GtkTreeModel*");
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 3, "gtk_tree_row_reference_new_proxy", "GtkTreePath*");
  return(C_to_Xen_GtkTreeRowReference_(gtk_tree_row_reference_new_proxy(Xen_to_C_GObject_(proxy), Xen_to_C_GtkTreeModel_(model), 
                                                                        Xen_to_C_GtkTreePath_(path))));
}

static Xen gxg_gtk_tree_row_reference_get_path(Xen reference)
{
  #define H_gtk_tree_row_reference_get_path "GtkTreePath* gtk_tree_row_reference_get_path(GtkTreeRowReference* reference)"
  Xen_check_type(Xen_is_GtkTreeRowReference_(reference), reference, 1, "gtk_tree_row_reference_get_path", "GtkTreeRowReference*");
  return(C_to_Xen_GtkTreePath_(gtk_tree_row_reference_get_path(Xen_to_C_GtkTreeRowReference_(reference))));
}

static Xen gxg_gtk_tree_row_reference_valid(Xen reference)
{
  #define H_gtk_tree_row_reference_valid "gboolean gtk_tree_row_reference_valid(GtkTreeRowReference* reference)"
  Xen_check_type(Xen_is_GtkTreeRowReference_(reference), reference, 1, "gtk_tree_row_reference_valid", "GtkTreeRowReference*");
  return(C_to_Xen_gboolean(gtk_tree_row_reference_valid(Xen_to_C_GtkTreeRowReference_(reference))));
}

static Xen gxg_gtk_tree_row_reference_free(Xen reference)
{
  #define H_gtk_tree_row_reference_free "void gtk_tree_row_reference_free(GtkTreeRowReference* reference)"
  Xen_check_type(Xen_is_GtkTreeRowReference_(reference), reference, 1, "gtk_tree_row_reference_free", "GtkTreeRowReference*");
  gtk_tree_row_reference_free(Xen_to_C_GtkTreeRowReference_(reference));
  return(Xen_false);
}

static Xen gxg_gtk_tree_row_reference_inserted(Xen proxy, Xen path)
{
  #define H_gtk_tree_row_reference_inserted "void gtk_tree_row_reference_inserted(GObject* proxy, GtkTreePath* path)"
  Xen_check_type(Xen_is_GObject_(proxy), proxy, 1, "gtk_tree_row_reference_inserted", "GObject*");
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 2, "gtk_tree_row_reference_inserted", "GtkTreePath*");
  gtk_tree_row_reference_inserted(Xen_to_C_GObject_(proxy), Xen_to_C_GtkTreePath_(path));
  return(Xen_false);
}

static Xen gxg_gtk_tree_row_reference_deleted(Xen proxy, Xen path)
{
  #define H_gtk_tree_row_reference_deleted "void gtk_tree_row_reference_deleted(GObject* proxy, GtkTreePath* path)"
  Xen_check_type(Xen_is_GObject_(proxy), proxy, 1, "gtk_tree_row_reference_deleted", "GObject*");
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 2, "gtk_tree_row_reference_deleted", "GtkTreePath*");
  gtk_tree_row_reference_deleted(Xen_to_C_GObject_(proxy), Xen_to_C_GtkTreePath_(path));
  return(Xen_false);
}

static Xen gxg_gtk_tree_row_reference_reordered(Xen proxy, Xen path, Xen iter, Xen new_order)
{
  #define H_gtk_tree_row_reference_reordered "void gtk_tree_row_reference_reordered(GObject* proxy, GtkTreePath* path, \
GtkTreeIter* iter, gint* new_order)"
  Xen_check_type(Xen_is_GObject_(proxy), proxy, 1, "gtk_tree_row_reference_reordered", "GObject*");
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 2, "gtk_tree_row_reference_reordered", "GtkTreePath*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 3, "gtk_tree_row_reference_reordered", "GtkTreeIter*");
  Xen_check_type(Xen_is_gint_(new_order), new_order, 4, "gtk_tree_row_reference_reordered", "gint*");
  gtk_tree_row_reference_reordered(Xen_to_C_GObject_(proxy), Xen_to_C_GtkTreePath_(path), Xen_to_C_GtkTreeIter_(iter), Xen_to_C_gint_(new_order));
  return(Xen_false);
}

static Xen gxg_gtk_tree_iter_copy(Xen iter)
{
  #define H_gtk_tree_iter_copy "GtkTreeIter* gtk_tree_iter_copy(GtkTreeIter* iter)"
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 1, "gtk_tree_iter_copy", "GtkTreeIter*");
  return(C_to_Xen_GtkTreeIter_(gtk_tree_iter_copy(Xen_to_C_GtkTreeIter_(iter))));
}

static Xen gxg_gtk_tree_iter_free(Xen iter)
{
  #define H_gtk_tree_iter_free "void gtk_tree_iter_free(GtkTreeIter* iter)"
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 1, "gtk_tree_iter_free", "GtkTreeIter*");
  gtk_tree_iter_free(Xen_to_C_GtkTreeIter_(iter));
  return(Xen_false);
}

static Xen gxg_gtk_tree_model_get_flags(Xen tree_model)
{
  #define H_gtk_tree_model_get_flags "GtkTreeModelFlags gtk_tree_model_get_flags(GtkTreeModel* tree_model)"
  Xen_check_type(Xen_is_GtkTreeModel_(tree_model), tree_model, 1, "gtk_tree_model_get_flags", "GtkTreeModel*");
  return(C_to_Xen_GtkTreeModelFlags(gtk_tree_model_get_flags(Xen_to_C_GtkTreeModel_(tree_model))));
}

static Xen gxg_gtk_tree_model_get_n_columns(Xen tree_model)
{
  #define H_gtk_tree_model_get_n_columns "gint gtk_tree_model_get_n_columns(GtkTreeModel* tree_model)"
  Xen_check_type(Xen_is_GtkTreeModel_(tree_model), tree_model, 1, "gtk_tree_model_get_n_columns", "GtkTreeModel*");
  return(C_to_Xen_gint(gtk_tree_model_get_n_columns(Xen_to_C_GtkTreeModel_(tree_model))));
}

static Xen gxg_gtk_tree_model_get_column_type(Xen tree_model, Xen index)
{
  #define H_gtk_tree_model_get_column_type "GType gtk_tree_model_get_column_type(GtkTreeModel* tree_model, \
gint index)"
  Xen_check_type(Xen_is_GtkTreeModel_(tree_model), tree_model, 1, "gtk_tree_model_get_column_type", "GtkTreeModel*");
  Xen_check_type(Xen_is_gint(index), index, 2, "gtk_tree_model_get_column_type", "gint");
  return(C_to_Xen_GType(gtk_tree_model_get_column_type(Xen_to_C_GtkTreeModel_(tree_model), Xen_to_C_gint(index))));
}

static Xen gxg_gtk_tree_model_get_iter(Xen tree_model, Xen iter, Xen path)
{
  #define H_gtk_tree_model_get_iter "gboolean gtk_tree_model_get_iter(GtkTreeModel* tree_model, GtkTreeIter* iter, \
GtkTreePath* path)"
  Xen_check_type(Xen_is_GtkTreeModel_(tree_model), tree_model, 1, "gtk_tree_model_get_iter", "GtkTreeModel*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_tree_model_get_iter", "GtkTreeIter*");
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 3, "gtk_tree_model_get_iter", "GtkTreePath*");
  return(C_to_Xen_gboolean(gtk_tree_model_get_iter(Xen_to_C_GtkTreeModel_(tree_model), Xen_to_C_GtkTreeIter_(iter), Xen_to_C_GtkTreePath_(path))));
}

static Xen gxg_gtk_tree_model_get_iter_from_string(Xen tree_model, Xen iter, Xen path_string)
{
  #define H_gtk_tree_model_get_iter_from_string "gboolean gtk_tree_model_get_iter_from_string(GtkTreeModel* tree_model, \
GtkTreeIter* iter, gchar* path_string)"
  Xen_check_type(Xen_is_GtkTreeModel_(tree_model), tree_model, 1, "gtk_tree_model_get_iter_from_string", "GtkTreeModel*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_tree_model_get_iter_from_string", "GtkTreeIter*");
  Xen_check_type(Xen_is_gchar_(path_string), path_string, 3, "gtk_tree_model_get_iter_from_string", "gchar*");
  return(C_to_Xen_gboolean(gtk_tree_model_get_iter_from_string(Xen_to_C_GtkTreeModel_(tree_model), Xen_to_C_GtkTreeIter_(iter), 
                                                               Xen_to_C_gchar_(path_string))));
}

static Xen gxg_gtk_tree_model_get_iter_first(Xen tree_model, Xen iter)
{
  #define H_gtk_tree_model_get_iter_first "gboolean gtk_tree_model_get_iter_first(GtkTreeModel* tree_model, \
GtkTreeIter* iter)"
  Xen_check_type(Xen_is_GtkTreeModel_(tree_model), tree_model, 1, "gtk_tree_model_get_iter_first", "GtkTreeModel*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_tree_model_get_iter_first", "GtkTreeIter*");
  return(C_to_Xen_gboolean(gtk_tree_model_get_iter_first(Xen_to_C_GtkTreeModel_(tree_model), Xen_to_C_GtkTreeIter_(iter))));
}

static Xen gxg_gtk_tree_model_get_path(Xen tree_model, Xen iter)
{
  #define H_gtk_tree_model_get_path "GtkTreePath* gtk_tree_model_get_path(GtkTreeModel* tree_model, GtkTreeIter* iter)"
  Xen_check_type(Xen_is_GtkTreeModel_(tree_model), tree_model, 1, "gtk_tree_model_get_path", "GtkTreeModel*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_tree_model_get_path", "GtkTreeIter*");
  return(C_to_Xen_GtkTreePath_(gtk_tree_model_get_path(Xen_to_C_GtkTreeModel_(tree_model), Xen_to_C_GtkTreeIter_(iter))));
}

static Xen gxg_gtk_tree_model_iter_next(Xen tree_model, Xen iter)
{
  #define H_gtk_tree_model_iter_next "gboolean gtk_tree_model_iter_next(GtkTreeModel* tree_model, GtkTreeIter* iter)"
  Xen_check_type(Xen_is_GtkTreeModel_(tree_model), tree_model, 1, "gtk_tree_model_iter_next", "GtkTreeModel*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_tree_model_iter_next", "GtkTreeIter*");
  return(C_to_Xen_gboolean(gtk_tree_model_iter_next(Xen_to_C_GtkTreeModel_(tree_model), Xen_to_C_GtkTreeIter_(iter))));
}

static Xen gxg_gtk_tree_model_iter_children(Xen tree_model, Xen iter, Xen parent)
{
  #define H_gtk_tree_model_iter_children "gboolean gtk_tree_model_iter_children(GtkTreeModel* tree_model, \
GtkTreeIter* iter, GtkTreeIter* parent)"
  Xen_check_type(Xen_is_GtkTreeModel_(tree_model), tree_model, 1, "gtk_tree_model_iter_children", "GtkTreeModel*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_tree_model_iter_children", "GtkTreeIter*");
  Xen_check_type(Xen_is_GtkTreeIter_(parent) || Xen_is_false(parent), parent, 3, "gtk_tree_model_iter_children", "GtkTreeIter*");
  return(C_to_Xen_gboolean(gtk_tree_model_iter_children(Xen_to_C_GtkTreeModel_(tree_model), Xen_to_C_GtkTreeIter_(iter), 
                                                        Xen_to_C_GtkTreeIter_(parent))));
}

static Xen gxg_gtk_tree_model_iter_has_child(Xen tree_model, Xen iter)
{
  #define H_gtk_tree_model_iter_has_child "gboolean gtk_tree_model_iter_has_child(GtkTreeModel* tree_model, \
GtkTreeIter* iter)"
  Xen_check_type(Xen_is_GtkTreeModel_(tree_model), tree_model, 1, "gtk_tree_model_iter_has_child", "GtkTreeModel*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_tree_model_iter_has_child", "GtkTreeIter*");
  return(C_to_Xen_gboolean(gtk_tree_model_iter_has_child(Xen_to_C_GtkTreeModel_(tree_model), Xen_to_C_GtkTreeIter_(iter))));
}

static Xen gxg_gtk_tree_model_iter_n_children(Xen tree_model, Xen iter)
{
  #define H_gtk_tree_model_iter_n_children "gint gtk_tree_model_iter_n_children(GtkTreeModel* tree_model, \
GtkTreeIter* iter)"
  Xen_check_type(Xen_is_GtkTreeModel_(tree_model), tree_model, 1, "gtk_tree_model_iter_n_children", "GtkTreeModel*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter) || Xen_is_false(iter), iter, 2, "gtk_tree_model_iter_n_children", "GtkTreeIter*");
  return(C_to_Xen_gint(gtk_tree_model_iter_n_children(Xen_to_C_GtkTreeModel_(tree_model), Xen_to_C_GtkTreeIter_(iter))));
}

static Xen gxg_gtk_tree_model_iter_nth_child(Xen tree_model, Xen iter, Xen parent, Xen n)
{
  #define H_gtk_tree_model_iter_nth_child "gboolean gtk_tree_model_iter_nth_child(GtkTreeModel* tree_model, \
GtkTreeIter* iter, GtkTreeIter* parent, gint n)"
  Xen_check_type(Xen_is_GtkTreeModel_(tree_model), tree_model, 1, "gtk_tree_model_iter_nth_child", "GtkTreeModel*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_tree_model_iter_nth_child", "GtkTreeIter*");
  Xen_check_type(Xen_is_GtkTreeIter_(parent) || Xen_is_false(parent), parent, 3, "gtk_tree_model_iter_nth_child", "GtkTreeIter*");
  Xen_check_type(Xen_is_gint(n), n, 4, "gtk_tree_model_iter_nth_child", "gint");
  return(C_to_Xen_gboolean(gtk_tree_model_iter_nth_child(Xen_to_C_GtkTreeModel_(tree_model), Xen_to_C_GtkTreeIter_(iter), 
                                                         Xen_to_C_GtkTreeIter_(parent), Xen_to_C_gint(n))));
}

static Xen gxg_gtk_tree_model_iter_parent(Xen tree_model, Xen iter, Xen child)
{
  #define H_gtk_tree_model_iter_parent "gboolean gtk_tree_model_iter_parent(GtkTreeModel* tree_model, \
GtkTreeIter* iter, GtkTreeIter* child)"
  Xen_check_type(Xen_is_GtkTreeModel_(tree_model), tree_model, 1, "gtk_tree_model_iter_parent", "GtkTreeModel*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_tree_model_iter_parent", "GtkTreeIter*");
  Xen_check_type(Xen_is_GtkTreeIter_(child), child, 3, "gtk_tree_model_iter_parent", "GtkTreeIter*");
  return(C_to_Xen_gboolean(gtk_tree_model_iter_parent(Xen_to_C_GtkTreeModel_(tree_model), Xen_to_C_GtkTreeIter_(iter), Xen_to_C_GtkTreeIter_(child))));
}

static Xen gxg_gtk_tree_model_ref_node(Xen tree_model, Xen iter)
{
  #define H_gtk_tree_model_ref_node "void gtk_tree_model_ref_node(GtkTreeModel* tree_model, GtkTreeIter* iter)"
  Xen_check_type(Xen_is_GtkTreeModel_(tree_model), tree_model, 1, "gtk_tree_model_ref_node", "GtkTreeModel*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_tree_model_ref_node", "GtkTreeIter*");
  gtk_tree_model_ref_node(Xen_to_C_GtkTreeModel_(tree_model), Xen_to_C_GtkTreeIter_(iter));
  return(Xen_false);
}

static Xen gxg_gtk_tree_model_unref_node(Xen tree_model, Xen iter)
{
  #define H_gtk_tree_model_unref_node "void gtk_tree_model_unref_node(GtkTreeModel* tree_model, GtkTreeIter* iter)"
  Xen_check_type(Xen_is_GtkTreeModel_(tree_model), tree_model, 1, "gtk_tree_model_unref_node", "GtkTreeModel*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_tree_model_unref_node", "GtkTreeIter*");
  gtk_tree_model_unref_node(Xen_to_C_GtkTreeModel_(tree_model), Xen_to_C_GtkTreeIter_(iter));
  return(Xen_false);
}

static Xen gxg_gtk_tree_model_foreach(Xen model, Xen func, Xen func_info)
{
  #define H_gtk_tree_model_foreach "void gtk_tree_model_foreach(GtkTreeModel* model, GtkTreeModelForeachFunc func, \
lambda_data func_info)"
  Xen_check_type(Xen_is_GtkTreeModel_(model), model, 1, "gtk_tree_model_foreach", "GtkTreeModel*");
  Xen_check_type(Xen_is_GtkTreeModelForeachFunc(func), func, 2, "gtk_tree_model_foreach", "GtkTreeModelForeachFunc");
  Xen_check_type(Xen_is_lambda_data(func_info) || Xen_is_false(func_info), func_info, 3, "gtk_tree_model_foreach", "lambda_data");
  {
    int loc;
    Xen gxg_ptr = Xen_list_5(func, func_info, Xen_false, Xen_false, Xen_false);
    loc = xm_protect(gxg_ptr);
    Xen_list_set(gxg_ptr, 2, C_int_to_Xen_integer(loc));
    gtk_tree_model_foreach(Xen_to_C_GtkTreeModel_(model), Xen_to_C_GtkTreeModelForeachFunc(func), Xen_to_C_lambda_data(func_info));
    xm_unprotect_at(loc);
    return(Xen_false);
   }
}

static Xen gxg_gtk_tree_model_row_changed(Xen tree_model, Xen path, Xen iter)
{
  #define H_gtk_tree_model_row_changed "void gtk_tree_model_row_changed(GtkTreeModel* tree_model, GtkTreePath* path, \
GtkTreeIter* iter)"
  Xen_check_type(Xen_is_GtkTreeModel_(tree_model), tree_model, 1, "gtk_tree_model_row_changed", "GtkTreeModel*");
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 2, "gtk_tree_model_row_changed", "GtkTreePath*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 3, "gtk_tree_model_row_changed", "GtkTreeIter*");
  gtk_tree_model_row_changed(Xen_to_C_GtkTreeModel_(tree_model), Xen_to_C_GtkTreePath_(path), Xen_to_C_GtkTreeIter_(iter));
  return(Xen_false);
}

static Xen gxg_gtk_tree_model_row_inserted(Xen tree_model, Xen path, Xen iter)
{
  #define H_gtk_tree_model_row_inserted "void gtk_tree_model_row_inserted(GtkTreeModel* tree_model, GtkTreePath* path, \
GtkTreeIter* iter)"
  Xen_check_type(Xen_is_GtkTreeModel_(tree_model), tree_model, 1, "gtk_tree_model_row_inserted", "GtkTreeModel*");
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 2, "gtk_tree_model_row_inserted", "GtkTreePath*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 3, "gtk_tree_model_row_inserted", "GtkTreeIter*");
  gtk_tree_model_row_inserted(Xen_to_C_GtkTreeModel_(tree_model), Xen_to_C_GtkTreePath_(path), Xen_to_C_GtkTreeIter_(iter));
  return(Xen_false);
}

static Xen gxg_gtk_tree_model_row_has_child_toggled(Xen tree_model, Xen path, Xen iter)
{
  #define H_gtk_tree_model_row_has_child_toggled "void gtk_tree_model_row_has_child_toggled(GtkTreeModel* tree_model, \
GtkTreePath* path, GtkTreeIter* iter)"
  Xen_check_type(Xen_is_GtkTreeModel_(tree_model), tree_model, 1, "gtk_tree_model_row_has_child_toggled", "GtkTreeModel*");
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 2, "gtk_tree_model_row_has_child_toggled", "GtkTreePath*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 3, "gtk_tree_model_row_has_child_toggled", "GtkTreeIter*");
  gtk_tree_model_row_has_child_toggled(Xen_to_C_GtkTreeModel_(tree_model), Xen_to_C_GtkTreePath_(path), Xen_to_C_GtkTreeIter_(iter));
  return(Xen_false);
}

static Xen gxg_gtk_tree_model_row_deleted(Xen tree_model, Xen path)
{
  #define H_gtk_tree_model_row_deleted "void gtk_tree_model_row_deleted(GtkTreeModel* tree_model, GtkTreePath* path)"
  Xen_check_type(Xen_is_GtkTreeModel_(tree_model), tree_model, 1, "gtk_tree_model_row_deleted", "GtkTreeModel*");
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 2, "gtk_tree_model_row_deleted", "GtkTreePath*");
  gtk_tree_model_row_deleted(Xen_to_C_GtkTreeModel_(tree_model), Xen_to_C_GtkTreePath_(path));
  return(Xen_false);
}

static Xen gxg_gtk_tree_model_rows_reordered(Xen tree_model, Xen path, Xen iter, Xen new_order)
{
  #define H_gtk_tree_model_rows_reordered "void gtk_tree_model_rows_reordered(GtkTreeModel* tree_model, \
GtkTreePath* path, GtkTreeIter* iter, gint* new_order)"
  Xen_check_type(Xen_is_GtkTreeModel_(tree_model), tree_model, 1, "gtk_tree_model_rows_reordered", "GtkTreeModel*");
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 2, "gtk_tree_model_rows_reordered", "GtkTreePath*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 3, "gtk_tree_model_rows_reordered", "GtkTreeIter*");
  Xen_check_type(Xen_is_gint_(new_order), new_order, 4, "gtk_tree_model_rows_reordered", "gint*");
  gtk_tree_model_rows_reordered(Xen_to_C_GtkTreeModel_(tree_model), Xen_to_C_GtkTreePath_(path), Xen_to_C_GtkTreeIter_(iter), 
                                Xen_to_C_gint_(new_order));
  return(Xen_false);
}

static Xen gxg_gtk_tree_model_sort_new_with_model(Xen child_model)
{
  #define H_gtk_tree_model_sort_new_with_model "GtkTreeModel* gtk_tree_model_sort_new_with_model(GtkTreeModel* child_model)"
  Xen_check_type(Xen_is_GtkTreeModel_(child_model), child_model, 1, "gtk_tree_model_sort_new_with_model", "GtkTreeModel*");
  return(C_to_Xen_GtkTreeModel_(gtk_tree_model_sort_new_with_model(Xen_to_C_GtkTreeModel_(child_model))));
}

static Xen gxg_gtk_tree_model_sort_get_model(Xen tree_model)
{
  #define H_gtk_tree_model_sort_get_model "GtkTreeModel* gtk_tree_model_sort_get_model(GtkTreeModelSort* tree_model)"
  Xen_check_type(Xen_is_GtkTreeModelSort_(tree_model), tree_model, 1, "gtk_tree_model_sort_get_model", "GtkTreeModelSort*");
  return(C_to_Xen_GtkTreeModel_(gtk_tree_model_sort_get_model(Xen_to_C_GtkTreeModelSort_(tree_model))));
}

static Xen gxg_gtk_tree_model_sort_convert_child_path_to_path(Xen tree_model_sort, Xen child_path)
{
  #define H_gtk_tree_model_sort_convert_child_path_to_path "GtkTreePath* gtk_tree_model_sort_convert_child_path_to_path(GtkTreeModelSort* tree_model_sort, \
GtkTreePath* child_path)"
  Xen_check_type(Xen_is_GtkTreeModelSort_(tree_model_sort), tree_model_sort, 1, "gtk_tree_model_sort_convert_child_path_to_path", "GtkTreeModelSort*");
  Xen_check_type(Xen_is_GtkTreePath_(child_path), child_path, 2, "gtk_tree_model_sort_convert_child_path_to_path", "GtkTreePath*");
  return(C_to_Xen_GtkTreePath_(gtk_tree_model_sort_convert_child_path_to_path(Xen_to_C_GtkTreeModelSort_(tree_model_sort), 
                                                                              Xen_to_C_GtkTreePath_(child_path))));
}

static Xen gxg_gtk_tree_model_sort_convert_child_iter_to_iter(Xen tree_model_sort, Xen sort_iter, Xen child_iter)
{
  #define H_gtk_tree_model_sort_convert_child_iter_to_iter "void gtk_tree_model_sort_convert_child_iter_to_iter(GtkTreeModelSort* tree_model_sort, \
GtkTreeIter* sort_iter, GtkTreeIter* child_iter)"
  Xen_check_type(Xen_is_GtkTreeModelSort_(tree_model_sort), tree_model_sort, 1, "gtk_tree_model_sort_convert_child_iter_to_iter", "GtkTreeModelSort*");
  Xen_check_type(Xen_is_GtkTreeIter_(sort_iter), sort_iter, 2, "gtk_tree_model_sort_convert_child_iter_to_iter", "GtkTreeIter*");
  Xen_check_type(Xen_is_GtkTreeIter_(child_iter), child_iter, 3, "gtk_tree_model_sort_convert_child_iter_to_iter", "GtkTreeIter*");
  gtk_tree_model_sort_convert_child_iter_to_iter(Xen_to_C_GtkTreeModelSort_(tree_model_sort), Xen_to_C_GtkTreeIter_(sort_iter), 
                                                 Xen_to_C_GtkTreeIter_(child_iter));
  return(Xen_false);
}

static Xen gxg_gtk_tree_model_sort_convert_path_to_child_path(Xen tree_model_sort, Xen sorted_path)
{
  #define H_gtk_tree_model_sort_convert_path_to_child_path "GtkTreePath* gtk_tree_model_sort_convert_path_to_child_path(GtkTreeModelSort* tree_model_sort, \
GtkTreePath* sorted_path)"
  Xen_check_type(Xen_is_GtkTreeModelSort_(tree_model_sort), tree_model_sort, 1, "gtk_tree_model_sort_convert_path_to_child_path", "GtkTreeModelSort*");
  Xen_check_type(Xen_is_GtkTreePath_(sorted_path), sorted_path, 2, "gtk_tree_model_sort_convert_path_to_child_path", "GtkTreePath*");
  return(C_to_Xen_GtkTreePath_(gtk_tree_model_sort_convert_path_to_child_path(Xen_to_C_GtkTreeModelSort_(tree_model_sort), 
                                                                              Xen_to_C_GtkTreePath_(sorted_path))));
}

static Xen gxg_gtk_tree_model_sort_convert_iter_to_child_iter(Xen tree_model_sort, Xen child_iter, Xen sorted_iter)
{
  #define H_gtk_tree_model_sort_convert_iter_to_child_iter "void gtk_tree_model_sort_convert_iter_to_child_iter(GtkTreeModelSort* tree_model_sort, \
GtkTreeIter* child_iter, GtkTreeIter* sorted_iter)"
  Xen_check_type(Xen_is_GtkTreeModelSort_(tree_model_sort), tree_model_sort, 1, "gtk_tree_model_sort_convert_iter_to_child_iter", "GtkTreeModelSort*");
  Xen_check_type(Xen_is_GtkTreeIter_(child_iter), child_iter, 2, "gtk_tree_model_sort_convert_iter_to_child_iter", "GtkTreeIter*");
  Xen_check_type(Xen_is_GtkTreeIter_(sorted_iter), sorted_iter, 3, "gtk_tree_model_sort_convert_iter_to_child_iter", "GtkTreeIter*");
  gtk_tree_model_sort_convert_iter_to_child_iter(Xen_to_C_GtkTreeModelSort_(tree_model_sort), Xen_to_C_GtkTreeIter_(child_iter), 
                                                 Xen_to_C_GtkTreeIter_(sorted_iter));
  return(Xen_false);
}

static Xen gxg_gtk_tree_model_sort_reset_default_sort_func(Xen tree_model_sort)
{
  #define H_gtk_tree_model_sort_reset_default_sort_func "void gtk_tree_model_sort_reset_default_sort_func(GtkTreeModelSort* tree_model_sort)"
  Xen_check_type(Xen_is_GtkTreeModelSort_(tree_model_sort), tree_model_sort, 1, "gtk_tree_model_sort_reset_default_sort_func", "GtkTreeModelSort*");
  gtk_tree_model_sort_reset_default_sort_func(Xen_to_C_GtkTreeModelSort_(tree_model_sort));
  return(Xen_false);
}

static Xen gxg_gtk_tree_model_sort_clear_cache(Xen tree_model_sort)
{
  #define H_gtk_tree_model_sort_clear_cache "void gtk_tree_model_sort_clear_cache(GtkTreeModelSort* tree_model_sort)"
  Xen_check_type(Xen_is_GtkTreeModelSort_(tree_model_sort), tree_model_sort, 1, "gtk_tree_model_sort_clear_cache", "GtkTreeModelSort*");
  gtk_tree_model_sort_clear_cache(Xen_to_C_GtkTreeModelSort_(tree_model_sort));
  return(Xen_false);
}

static Xen gxg_gtk_tree_selection_set_mode(Xen selection, Xen type)
{
  #define H_gtk_tree_selection_set_mode "void gtk_tree_selection_set_mode(GtkTreeSelection* selection, \
GtkSelectionMode type)"
  Xen_check_type(Xen_is_GtkTreeSelection_(selection), selection, 1, "gtk_tree_selection_set_mode", "GtkTreeSelection*");
  Xen_check_type(Xen_is_GtkSelectionMode(type), type, 2, "gtk_tree_selection_set_mode", "GtkSelectionMode");
  gtk_tree_selection_set_mode(Xen_to_C_GtkTreeSelection_(selection), Xen_to_C_GtkSelectionMode(type));
  return(Xen_false);
}

static Xen gxg_gtk_tree_selection_get_mode(Xen selection)
{
  #define H_gtk_tree_selection_get_mode "GtkSelectionMode gtk_tree_selection_get_mode(GtkTreeSelection* selection)"
  Xen_check_type(Xen_is_GtkTreeSelection_(selection), selection, 1, "gtk_tree_selection_get_mode", "GtkTreeSelection*");
  return(C_to_Xen_GtkSelectionMode(gtk_tree_selection_get_mode(Xen_to_C_GtkTreeSelection_(selection))));
}

static Xen gxg_gtk_tree_selection_set_select_function(Xen selection, Xen func, Xen func_info, Xen destroy)
{
  #define H_gtk_tree_selection_set_select_function "void gtk_tree_selection_set_select_function(GtkTreeSelection* selection, \
GtkTreeSelectionFunc func, lambda_data func_info, GtkDestroyNotify destroy)"
  Xen_check_type(Xen_is_GtkTreeSelection_(selection), selection, 1, "gtk_tree_selection_set_select_function", "GtkTreeSelection*");
  Xen_check_type(Xen_is_GtkTreeSelectionFunc(func), func, 2, "gtk_tree_selection_set_select_function", "GtkTreeSelectionFunc");
  Xen_check_type(Xen_is_lambda_data(func_info) || Xen_is_false(func_info), func_info, 3, "gtk_tree_selection_set_select_function", "lambda_data");
  Xen_check_type(Xen_is_GtkDestroyNotify(destroy), destroy, 4, "gtk_tree_selection_set_select_function", "GtkDestroyNotify");
  {
    Xen gxg_ptr = Xen_list_5(func, func_info, Xen_false, Xen_false, Xen_false);
    xm_protect(gxg_ptr);
    Xen_list_set(gxg_ptr, 3, destroy);
    gtk_tree_selection_set_select_function(Xen_to_C_GtkTreeSelection_(selection), Xen_to_C_GtkTreeSelectionFunc(func), Xen_to_C_lambda_data(func_info), 
                                       Xen_to_C_GtkDestroyNotify(destroy));
    return(Xen_false);
   }
}

static Xen gxg_gtk_tree_selection_get_user_data(Xen selection)
{
  #define H_gtk_tree_selection_get_user_data "gpointer gtk_tree_selection_get_user_data(GtkTreeSelection* selection)"
  Xen_check_type(Xen_is_GtkTreeSelection_(selection), selection, 1, "gtk_tree_selection_get_user_data", "GtkTreeSelection*");
  return(C_to_Xen_gpointer(gtk_tree_selection_get_user_data(Xen_to_C_GtkTreeSelection_(selection))));
}

static Xen gxg_gtk_tree_selection_get_tree_view(Xen selection)
{
  #define H_gtk_tree_selection_get_tree_view "GtkTreeView* gtk_tree_selection_get_tree_view(GtkTreeSelection* selection)"
  Xen_check_type(Xen_is_GtkTreeSelection_(selection), selection, 1, "gtk_tree_selection_get_tree_view", "GtkTreeSelection*");
  return(C_to_Xen_GtkTreeView_(gtk_tree_selection_get_tree_view(Xen_to_C_GtkTreeSelection_(selection))));
}

static Xen gxg_gtk_tree_selection_get_selected(Xen selection, Xen model, Xen iter)
{
  #define H_gtk_tree_selection_get_selected "gboolean gtk_tree_selection_get_selected(GtkTreeSelection* selection, \
GtkTreeModel** model, GtkTreeIter* iter)"
  Xen_check_type(Xen_is_GtkTreeSelection_(selection), selection, 1, "gtk_tree_selection_get_selected", "GtkTreeSelection*");
  Xen_check_type(Xen_is_GtkTreeModel__(model), model, 2, "gtk_tree_selection_get_selected", "GtkTreeModel**");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 3, "gtk_tree_selection_get_selected", "GtkTreeIter*");
  return(C_to_Xen_gboolean(gtk_tree_selection_get_selected(Xen_to_C_GtkTreeSelection_(selection), Xen_to_C_GtkTreeModel__(model), 
                                                           Xen_to_C_GtkTreeIter_(iter))));
}

static Xen gxg_gtk_tree_selection_selected_foreach(Xen selection, Xen func, Xen func_info)
{
  #define H_gtk_tree_selection_selected_foreach "void gtk_tree_selection_selected_foreach(GtkTreeSelection* selection, \
GtkTreeSelectionForeachFunc func, lambda_data func_info)"
  Xen_check_type(Xen_is_GtkTreeSelection_(selection), selection, 1, "gtk_tree_selection_selected_foreach", "GtkTreeSelection*");
  Xen_check_type(Xen_is_GtkTreeSelectionForeachFunc(func), func, 2, "gtk_tree_selection_selected_foreach", "GtkTreeSelectionForeachFunc");
  Xen_check_type(Xen_is_lambda_data(func_info) || Xen_is_false(func_info), func_info, 3, "gtk_tree_selection_selected_foreach", "lambda_data");
  {
    int loc;
    Xen gxg_ptr = Xen_list_5(func, func_info, Xen_false, Xen_false, Xen_false);
    loc = xm_protect(gxg_ptr);
    Xen_list_set(gxg_ptr, 2, C_int_to_Xen_integer(loc));
    gtk_tree_selection_selected_foreach(Xen_to_C_GtkTreeSelection_(selection), Xen_to_C_GtkTreeSelectionForeachFunc(func), Xen_to_C_lambda_data(func_info));
    xm_unprotect_at(loc);
    return(Xen_false);
   }
}

static Xen gxg_gtk_tree_selection_select_path(Xen selection, Xen path)
{
  #define H_gtk_tree_selection_select_path "void gtk_tree_selection_select_path(GtkTreeSelection* selection, \
GtkTreePath* path)"
  Xen_check_type(Xen_is_GtkTreeSelection_(selection), selection, 1, "gtk_tree_selection_select_path", "GtkTreeSelection*");
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 2, "gtk_tree_selection_select_path", "GtkTreePath*");
  gtk_tree_selection_select_path(Xen_to_C_GtkTreeSelection_(selection), Xen_to_C_GtkTreePath_(path));
  return(Xen_false);
}

static Xen gxg_gtk_tree_selection_unselect_path(Xen selection, Xen path)
{
  #define H_gtk_tree_selection_unselect_path "void gtk_tree_selection_unselect_path(GtkTreeSelection* selection, \
GtkTreePath* path)"
  Xen_check_type(Xen_is_GtkTreeSelection_(selection), selection, 1, "gtk_tree_selection_unselect_path", "GtkTreeSelection*");
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 2, "gtk_tree_selection_unselect_path", "GtkTreePath*");
  gtk_tree_selection_unselect_path(Xen_to_C_GtkTreeSelection_(selection), Xen_to_C_GtkTreePath_(path));
  return(Xen_false);
}

static Xen gxg_gtk_tree_selection_select_iter(Xen selection, Xen iter)
{
  #define H_gtk_tree_selection_select_iter "void gtk_tree_selection_select_iter(GtkTreeSelection* selection, \
GtkTreeIter* iter)"
  Xen_check_type(Xen_is_GtkTreeSelection_(selection), selection, 1, "gtk_tree_selection_select_iter", "GtkTreeSelection*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_tree_selection_select_iter", "GtkTreeIter*");
  gtk_tree_selection_select_iter(Xen_to_C_GtkTreeSelection_(selection), Xen_to_C_GtkTreeIter_(iter));
  return(Xen_false);
}

static Xen gxg_gtk_tree_selection_unselect_iter(Xen selection, Xen iter)
{
  #define H_gtk_tree_selection_unselect_iter "void gtk_tree_selection_unselect_iter(GtkTreeSelection* selection, \
GtkTreeIter* iter)"
  Xen_check_type(Xen_is_GtkTreeSelection_(selection), selection, 1, "gtk_tree_selection_unselect_iter", "GtkTreeSelection*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_tree_selection_unselect_iter", "GtkTreeIter*");
  gtk_tree_selection_unselect_iter(Xen_to_C_GtkTreeSelection_(selection), Xen_to_C_GtkTreeIter_(iter));
  return(Xen_false);
}

static Xen gxg_gtk_tree_selection_path_is_selected(Xen selection, Xen path)
{
  #define H_gtk_tree_selection_path_is_selected "gboolean gtk_tree_selection_path_is_selected(GtkTreeSelection* selection, \
GtkTreePath* path)"
  Xen_check_type(Xen_is_GtkTreeSelection_(selection), selection, 1, "gtk_tree_selection_path_is_selected", "GtkTreeSelection*");
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 2, "gtk_tree_selection_path_is_selected", "GtkTreePath*");
  return(C_to_Xen_gboolean(gtk_tree_selection_path_is_selected(Xen_to_C_GtkTreeSelection_(selection), Xen_to_C_GtkTreePath_(path))));
}

static Xen gxg_gtk_tree_selection_iter_is_selected(Xen selection, Xen iter)
{
  #define H_gtk_tree_selection_iter_is_selected "gboolean gtk_tree_selection_iter_is_selected(GtkTreeSelection* selection, \
GtkTreeIter* iter)"
  Xen_check_type(Xen_is_GtkTreeSelection_(selection), selection, 1, "gtk_tree_selection_iter_is_selected", "GtkTreeSelection*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_tree_selection_iter_is_selected", "GtkTreeIter*");
  return(C_to_Xen_gboolean(gtk_tree_selection_iter_is_selected(Xen_to_C_GtkTreeSelection_(selection), Xen_to_C_GtkTreeIter_(iter))));
}

static Xen gxg_gtk_tree_selection_select_all(Xen selection)
{
  #define H_gtk_tree_selection_select_all "void gtk_tree_selection_select_all(GtkTreeSelection* selection)"
  Xen_check_type(Xen_is_GtkTreeSelection_(selection), selection, 1, "gtk_tree_selection_select_all", "GtkTreeSelection*");
  gtk_tree_selection_select_all(Xen_to_C_GtkTreeSelection_(selection));
  return(Xen_false);
}

static Xen gxg_gtk_tree_selection_unselect_all(Xen selection)
{
  #define H_gtk_tree_selection_unselect_all "void gtk_tree_selection_unselect_all(GtkTreeSelection* selection)"
  Xen_check_type(Xen_is_GtkTreeSelection_(selection), selection, 1, "gtk_tree_selection_unselect_all", "GtkTreeSelection*");
  gtk_tree_selection_unselect_all(Xen_to_C_GtkTreeSelection_(selection));
  return(Xen_false);
}

static Xen gxg_gtk_tree_selection_select_range(Xen selection, Xen start_path, Xen end_path)
{
  #define H_gtk_tree_selection_select_range "void gtk_tree_selection_select_range(GtkTreeSelection* selection, \
GtkTreePath* start_path, GtkTreePath* end_path)"
  Xen_check_type(Xen_is_GtkTreeSelection_(selection), selection, 1, "gtk_tree_selection_select_range", "GtkTreeSelection*");
  Xen_check_type(Xen_is_GtkTreePath_(start_path), start_path, 2, "gtk_tree_selection_select_range", "GtkTreePath*");
  Xen_check_type(Xen_is_GtkTreePath_(end_path), end_path, 3, "gtk_tree_selection_select_range", "GtkTreePath*");
  gtk_tree_selection_select_range(Xen_to_C_GtkTreeSelection_(selection), Xen_to_C_GtkTreePath_(start_path), Xen_to_C_GtkTreePath_(end_path));
  return(Xen_false);
}

static Xen gxg_gtk_tree_sortable_sort_column_changed(Xen sortable)
{
  #define H_gtk_tree_sortable_sort_column_changed "void gtk_tree_sortable_sort_column_changed(GtkTreeSortable* sortable)"
  Xen_check_type(Xen_is_GtkTreeSortable_(sortable), sortable, 1, "gtk_tree_sortable_sort_column_changed", "GtkTreeSortable*");
  gtk_tree_sortable_sort_column_changed(Xen_to_C_GtkTreeSortable_(sortable));
  return(Xen_false);
}

static Xen gxg_gtk_tree_sortable_get_sort_column_id(Xen sortable, Xen ignore_sort_column_id, Xen ignore_order)
{
  #define H_gtk_tree_sortable_get_sort_column_id "gboolean gtk_tree_sortable_get_sort_column_id(GtkTreeSortable* sortable, \
gint* [sort_column_id], GtkSortType* [order])"
  gint ref_sort_column_id;
  GtkSortType ref_order;
  Xen_check_type(Xen_is_GtkTreeSortable_(sortable), sortable, 1, "gtk_tree_sortable_get_sort_column_id", "GtkTreeSortable*");
  {
    Xen res_ult;
    res_ult = C_to_Xen_gboolean(gtk_tree_sortable_get_sort_column_id(Xen_to_C_GtkTreeSortable_(sortable), &ref_sort_column_id, 
                                                                     &ref_order));
    return(Xen_list_3(res_ult, C_to_Xen_gint(ref_sort_column_id), C_to_Xen_GtkSortType(ref_order)));
   }
}

static Xen gxg_gtk_tree_sortable_set_sort_column_id(Xen sortable, Xen sort_column_id, Xen order)
{
  #define H_gtk_tree_sortable_set_sort_column_id "void gtk_tree_sortable_set_sort_column_id(GtkTreeSortable* sortable, \
gint sort_column_id, GtkSortType order)"
  Xen_check_type(Xen_is_GtkTreeSortable_(sortable), sortable, 1, "gtk_tree_sortable_set_sort_column_id", "GtkTreeSortable*");
  Xen_check_type(Xen_is_gint(sort_column_id), sort_column_id, 2, "gtk_tree_sortable_set_sort_column_id", "gint");
  Xen_check_type(Xen_is_GtkSortType(order), order, 3, "gtk_tree_sortable_set_sort_column_id", "GtkSortType");
  gtk_tree_sortable_set_sort_column_id(Xen_to_C_GtkTreeSortable_(sortable), Xen_to_C_gint(sort_column_id), Xen_to_C_GtkSortType(order));
  return(Xen_false);
}

static Xen gxg_gtk_tree_sortable_set_sort_func(Xen sortable, Xen sort_column_id, Xen func, Xen func_info, Xen destroy)
{
  #define H_gtk_tree_sortable_set_sort_func "void gtk_tree_sortable_set_sort_func(GtkTreeSortable* sortable, \
gint sort_column_id, GtkTreeIterCompareFunc func, lambda_data func_info, GtkDestroyNotify destroy)"
  Xen_check_type(Xen_is_GtkTreeSortable_(sortable), sortable, 1, "gtk_tree_sortable_set_sort_func", "GtkTreeSortable*");
  Xen_check_type(Xen_is_gint(sort_column_id), sort_column_id, 2, "gtk_tree_sortable_set_sort_func", "gint");
  Xen_check_type(Xen_is_GtkTreeIterCompareFunc(func), func, 3, "gtk_tree_sortable_set_sort_func", "GtkTreeIterCompareFunc");
  Xen_check_type(Xen_is_lambda_data(func_info) || Xen_is_false(func_info), func_info, 4, "gtk_tree_sortable_set_sort_func", "lambda_data");
  Xen_check_type(Xen_is_GtkDestroyNotify(destroy), destroy, 5, "gtk_tree_sortable_set_sort_func", "GtkDestroyNotify");
  {
    Xen gxg_ptr = Xen_list_5(func, func_info, Xen_false, Xen_false, Xen_false);
    xm_protect(gxg_ptr);
    Xen_list_set(gxg_ptr, 3, destroy);
    gtk_tree_sortable_set_sort_func(Xen_to_C_GtkTreeSortable_(sortable), Xen_to_C_gint(sort_column_id), Xen_to_C_GtkTreeIterCompareFunc(func), 
                                Xen_to_C_lambda_data(func_info), Xen_to_C_GtkDestroyNotify(destroy));
    return(Xen_false);
   }
}

static Xen gxg_gtk_tree_sortable_set_default_sort_func(Xen sortable, Xen func, Xen func_info, Xen destroy)
{
  #define H_gtk_tree_sortable_set_default_sort_func "void gtk_tree_sortable_set_default_sort_func(GtkTreeSortable* sortable, \
GtkTreeIterCompareFunc func, lambda_data func_info, GtkDestroyNotify destroy)"
  Xen_check_type(Xen_is_GtkTreeSortable_(sortable), sortable, 1, "gtk_tree_sortable_set_default_sort_func", "GtkTreeSortable*");
  Xen_check_type(Xen_is_GtkTreeIterCompareFunc(func), func, 2, "gtk_tree_sortable_set_default_sort_func", "GtkTreeIterCompareFunc");
  Xen_check_type(Xen_is_lambda_data(func_info) || Xen_is_false(func_info), func_info, 3, "gtk_tree_sortable_set_default_sort_func", "lambda_data");
  Xen_check_type(Xen_is_GtkDestroyNotify(destroy), destroy, 4, "gtk_tree_sortable_set_default_sort_func", "GtkDestroyNotify");
  {
    Xen gxg_ptr = Xen_list_5(func, func_info, Xen_false, Xen_false, Xen_false);
    xm_protect(gxg_ptr);
    Xen_list_set(gxg_ptr, 3, destroy);
    gtk_tree_sortable_set_default_sort_func(Xen_to_C_GtkTreeSortable_(sortable), Xen_to_C_GtkTreeIterCompareFunc(func), Xen_to_C_lambda_data(func_info), 
                                        Xen_to_C_GtkDestroyNotify(destroy));
    return(Xen_false);
   }
}

static Xen gxg_gtk_tree_sortable_has_default_sort_func(Xen sortable)
{
  #define H_gtk_tree_sortable_has_default_sort_func "gboolean gtk_tree_sortable_has_default_sort_func(GtkTreeSortable* sortable)"
  Xen_check_type(Xen_is_GtkTreeSortable_(sortable), sortable, 1, "gtk_tree_sortable_has_default_sort_func", "GtkTreeSortable*");
  return(C_to_Xen_gboolean(gtk_tree_sortable_has_default_sort_func(Xen_to_C_GtkTreeSortable_(sortable))));
}

static Xen gxg_gtk_tree_store_new(Xen n_columns, Xen types)
{
  #define H_gtk_tree_store_new "GtkTreeStore* gtk_tree_store_new(gint n_columns, etc types)"
  Xen_check_type(Xen_is_gint(n_columns), n_columns, 1, "gtk_tree_store_new", "gint");
  Xen_check_type(Xen_is_etc(types), types, 2, "gtk_tree_store_new", "etc");
  {
    int etc_len = 0;
    GtkTreeStore* res_ult = NULL;
    gint p_arg0;
    if (Xen_is_list(types)) etc_len = Xen_list_length(types);
    if (etc_len < 1) Xen_out_of_range_error("gtk_tree_store_new", 1, types, "... list must have at least 1 entry");
    if (etc_len > 6) Xen_out_of_range_error("gtk_tree_store_new", 1, types, "... list too long (max len: 6)");
    p_arg0 = Xen_to_C_gint(n_columns);
    switch (etc_len)
      {
        case 1: res_ult = gtk_tree_store_new(p_arg0, XLG(types, 0)); break;
        case 2: res_ult = gtk_tree_store_new(p_arg0, XLG(types, 0), XLG(types, 1)); break;
        case 3: res_ult = gtk_tree_store_new(p_arg0, XLG(types, 0), XLG(types, 1), XLG(types, 2)); break;
        case 4: res_ult = gtk_tree_store_new(p_arg0, XLG(types, 0), XLG(types, 1), XLG(types, 2), XLG(types, 3)); break;
        case 5: res_ult = gtk_tree_store_new(p_arg0, XLG(types, 0), XLG(types, 1), XLG(types, 2), XLG(types, 3), XLG(types, 4)); break;
        case 6: res_ult = gtk_tree_store_new(p_arg0, XLG(types, 0), XLG(types, 1), XLG(types, 2), XLG(types, 3), XLG(types, 4), XLG(types, 5)); break;
      }
    return(C_to_Xen_GtkTreeStore_(res_ult));
  }
}

static Xen gxg_gtk_tree_store_newv(Xen n_columns, Xen types)
{
  #define H_gtk_tree_store_newv "GtkTreeStore* gtk_tree_store_newv(gint n_columns, GType* types)"
  Xen_check_type(Xen_is_gint(n_columns), n_columns, 1, "gtk_tree_store_newv", "gint");
  Xen_check_type(Xen_is_GType_(types), types, 2, "gtk_tree_store_newv", "GType*");
  return(C_to_Xen_GtkTreeStore_(gtk_tree_store_newv(Xen_to_C_gint(n_columns), Xen_to_C_GType_(types))));
}

static Xen gxg_gtk_tree_store_set_column_types(Xen tree_store, Xen n_columns, Xen types)
{
  #define H_gtk_tree_store_set_column_types "void gtk_tree_store_set_column_types(GtkTreeStore* tree_store, \
gint n_columns, GType* types)"
  Xen_check_type(Xen_is_GtkTreeStore_(tree_store), tree_store, 1, "gtk_tree_store_set_column_types", "GtkTreeStore*");
  Xen_check_type(Xen_is_gint(n_columns), n_columns, 2, "gtk_tree_store_set_column_types", "gint");
  Xen_check_type(Xen_is_GType_(types), types, 3, "gtk_tree_store_set_column_types", "GType*");
  gtk_tree_store_set_column_types(Xen_to_C_GtkTreeStore_(tree_store), Xen_to_C_gint(n_columns), Xen_to_C_GType_(types));
  return(Xen_false);
}

static Xen gxg_gtk_tree_store_set(Xen tree_store, Xen iter, Xen values)
{
  #define H_gtk_tree_store_set "void gtk_tree_store_set(GtkTreeStore* tree_store, GtkTreeIter* iter, \
etc values)"
  Xen_check_type(Xen_is_GtkTreeStore_(tree_store), tree_store, 1, "gtk_tree_store_set", "GtkTreeStore*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_tree_store_set", "GtkTreeIter*");
  Xen_check_type(Xen_is_etc(values), values, 3, "gtk_tree_store_set", "etc");
  {
    int etc_len = 0;
    GtkTreeStore* p_arg0;
    GtkTreeIter* p_arg1;
    if (Xen_is_list(values)) etc_len = Xen_list_length(values);
    if (etc_len < 2) Xen_out_of_range_error("gtk_tree_store_set", 2, values, "... list must have at least 2 entries");
    if (etc_len > 10) Xen_out_of_range_error("gtk_tree_store_set", 2, values, "... list too long (max len: 10)");
    if ((etc_len % 2) != 0) Xen_out_of_range_error("gtk_tree_store_set", 2, values, "... list len must be multiple of 2");
    p_arg0 = Xen_to_C_GtkTreeStore_(tree_store);
    p_arg1 = Xen_to_C_GtkTreeIter_(iter);
    switch (etc_len)
      {
        case 2: gtk_tree_store_set(p_arg0, p_arg1, XLI(values, 0), XLS(values, 1), -1); break;
        case 4: gtk_tree_store_set(p_arg0, p_arg1, XLI(values, 0), XLS(values, 1), XLI(values, 2), XLS(values, 3), -1); break;
        case 6: gtk_tree_store_set(p_arg0, p_arg1, XLI(values, 0), XLS(values, 1), XLI(values, 2), XLS(values, 3), XLI(values, 4), XLS(values, 5), -1); break;
        case 8: gtk_tree_store_set(p_arg0, p_arg1, XLI(values, 0), XLS(values, 1), XLI(values, 2), XLS(values, 3), XLI(values, 4), XLS(values, 5), XLI(values, 6), XLS(values, 7), -1); break;
        case 10: gtk_tree_store_set(p_arg0, p_arg1, XLI(values, 0), XLS(values, 1), XLI(values, 2), XLS(values, 3), XLI(values, 4), XLS(values, 5), XLI(values, 6), XLS(values, 7), XLI(values, 8), XLS(values, 9), -1); break;
      }
    return(Xen_false);
  }
}

static Xen gxg_gtk_tree_store_remove(Xen tree_store, Xen iter)
{
  #define H_gtk_tree_store_remove "void gtk_tree_store_remove(GtkTreeStore* tree_store, GtkTreeIter* iter)"
  Xen_check_type(Xen_is_GtkTreeStore_(tree_store), tree_store, 1, "gtk_tree_store_remove", "GtkTreeStore*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_tree_store_remove", "GtkTreeIter*");
  gtk_tree_store_remove(Xen_to_C_GtkTreeStore_(tree_store), Xen_to_C_GtkTreeIter_(iter));
  return(Xen_false);
}

static Xen gxg_gtk_tree_store_insert(Xen tree_store, Xen iter, Xen parent, Xen position)
{
  #define H_gtk_tree_store_insert "void gtk_tree_store_insert(GtkTreeStore* tree_store, GtkTreeIter* iter, \
GtkTreeIter* parent, gint position)"
  Xen_check_type(Xen_is_GtkTreeStore_(tree_store), tree_store, 1, "gtk_tree_store_insert", "GtkTreeStore*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_tree_store_insert", "GtkTreeIter*");
  Xen_check_type(Xen_is_GtkTreeIter_(parent) || Xen_is_false(parent), parent, 3, "gtk_tree_store_insert", "GtkTreeIter*");
  Xen_check_type(Xen_is_gint(position), position, 4, "gtk_tree_store_insert", "gint");
  gtk_tree_store_insert(Xen_to_C_GtkTreeStore_(tree_store), Xen_to_C_GtkTreeIter_(iter), Xen_to_C_GtkTreeIter_(parent), Xen_to_C_gint(position));
  return(Xen_false);
}

static Xen gxg_gtk_tree_store_insert_before(Xen tree_store, Xen iter, Xen parent, Xen sibling)
{
  #define H_gtk_tree_store_insert_before "void gtk_tree_store_insert_before(GtkTreeStore* tree_store, \
GtkTreeIter* iter, GtkTreeIter* parent, GtkTreeIter* sibling)"
  Xen_check_type(Xen_is_GtkTreeStore_(tree_store), tree_store, 1, "gtk_tree_store_insert_before", "GtkTreeStore*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_tree_store_insert_before", "GtkTreeIter*");
  Xen_check_type(Xen_is_GtkTreeIter_(parent) || Xen_is_false(parent), parent, 3, "gtk_tree_store_insert_before", "GtkTreeIter*");
  Xen_check_type(Xen_is_GtkTreeIter_(sibling) || Xen_is_false(sibling), sibling, 4, "gtk_tree_store_insert_before", "GtkTreeIter*");
  gtk_tree_store_insert_before(Xen_to_C_GtkTreeStore_(tree_store), Xen_to_C_GtkTreeIter_(iter), Xen_to_C_GtkTreeIter_(parent), 
                               Xen_to_C_GtkTreeIter_(sibling));
  return(Xen_false);
}

static Xen gxg_gtk_tree_store_insert_after(Xen tree_store, Xen iter, Xen parent, Xen sibling)
{
  #define H_gtk_tree_store_insert_after "void gtk_tree_store_insert_after(GtkTreeStore* tree_store, GtkTreeIter* iter, \
GtkTreeIter* parent, GtkTreeIter* sibling)"
  Xen_check_type(Xen_is_GtkTreeStore_(tree_store), tree_store, 1, "gtk_tree_store_insert_after", "GtkTreeStore*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_tree_store_insert_after", "GtkTreeIter*");
  Xen_check_type(Xen_is_GtkTreeIter_(parent) || Xen_is_false(parent), parent, 3, "gtk_tree_store_insert_after", "GtkTreeIter*");
  Xen_check_type(Xen_is_GtkTreeIter_(sibling) || Xen_is_false(sibling), sibling, 4, "gtk_tree_store_insert_after", "GtkTreeIter*");
  gtk_tree_store_insert_after(Xen_to_C_GtkTreeStore_(tree_store), Xen_to_C_GtkTreeIter_(iter), Xen_to_C_GtkTreeIter_(parent), 
                              Xen_to_C_GtkTreeIter_(sibling));
  return(Xen_false);
}

static Xen gxg_gtk_tree_store_prepend(Xen tree_store, Xen iter, Xen parent)
{
  #define H_gtk_tree_store_prepend "void gtk_tree_store_prepend(GtkTreeStore* tree_store, GtkTreeIter* iter, \
GtkTreeIter* parent)"
  Xen_check_type(Xen_is_GtkTreeStore_(tree_store), tree_store, 1, "gtk_tree_store_prepend", "GtkTreeStore*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_tree_store_prepend", "GtkTreeIter*");
  Xen_check_type(Xen_is_GtkTreeIter_(parent) || Xen_is_false(parent), parent, 3, "gtk_tree_store_prepend", "GtkTreeIter*");
  gtk_tree_store_prepend(Xen_to_C_GtkTreeStore_(tree_store), Xen_to_C_GtkTreeIter_(iter), Xen_to_C_GtkTreeIter_(parent));
  return(Xen_false);
}

static Xen gxg_gtk_tree_store_append(Xen tree_store, Xen iter, Xen parent)
{
  #define H_gtk_tree_store_append "void gtk_tree_store_append(GtkTreeStore* tree_store, GtkTreeIter* iter, \
GtkTreeIter* parent)"
  Xen_check_type(Xen_is_GtkTreeStore_(tree_store), tree_store, 1, "gtk_tree_store_append", "GtkTreeStore*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_tree_store_append", "GtkTreeIter*");
  Xen_check_type(Xen_is_GtkTreeIter_(parent) || Xen_is_false(parent), parent, 3, "gtk_tree_store_append", "GtkTreeIter*");
  gtk_tree_store_append(Xen_to_C_GtkTreeStore_(tree_store), Xen_to_C_GtkTreeIter_(iter), Xen_to_C_GtkTreeIter_(parent));
  return(Xen_false);
}

static Xen gxg_gtk_tree_store_is_ancestor(Xen tree_store, Xen iter, Xen descendant)
{
  #define H_gtk_tree_store_is_ancestor "gboolean gtk_tree_store_is_ancestor(GtkTreeStore* tree_store, \
GtkTreeIter* iter, GtkTreeIter* descendant)"
  Xen_check_type(Xen_is_GtkTreeStore_(tree_store), tree_store, 1, "gtk_tree_store_is_ancestor", "GtkTreeStore*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_tree_store_is_ancestor", "GtkTreeIter*");
  Xen_check_type(Xen_is_GtkTreeIter_(descendant), descendant, 3, "gtk_tree_store_is_ancestor", "GtkTreeIter*");
  return(C_to_Xen_gboolean(gtk_tree_store_is_ancestor(Xen_to_C_GtkTreeStore_(tree_store), Xen_to_C_GtkTreeIter_(iter), Xen_to_C_GtkTreeIter_(descendant))));
}

static Xen gxg_gtk_tree_store_iter_depth(Xen tree_store, Xen iter)
{
  #define H_gtk_tree_store_iter_depth "gint gtk_tree_store_iter_depth(GtkTreeStore* tree_store, GtkTreeIter* iter)"
  Xen_check_type(Xen_is_GtkTreeStore_(tree_store), tree_store, 1, "gtk_tree_store_iter_depth", "GtkTreeStore*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_tree_store_iter_depth", "GtkTreeIter*");
  return(C_to_Xen_gint(gtk_tree_store_iter_depth(Xen_to_C_GtkTreeStore_(tree_store), Xen_to_C_GtkTreeIter_(iter))));
}

static Xen gxg_gtk_tree_store_clear(Xen tree_store)
{
  #define H_gtk_tree_store_clear "void gtk_tree_store_clear(GtkTreeStore* tree_store)"
  Xen_check_type(Xen_is_GtkTreeStore_(tree_store), tree_store, 1, "gtk_tree_store_clear", "GtkTreeStore*");
  gtk_tree_store_clear(Xen_to_C_GtkTreeStore_(tree_store));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_column_new(void)
{
  #define H_gtk_tree_view_column_new "GtkTreeViewColumn* gtk_tree_view_column_new( void)"
  return(C_to_Xen_GtkTreeViewColumn_(gtk_tree_view_column_new()));
}

static Xen gxg_gtk_tree_view_column_new_with_attributes(Xen title, Xen cell, Xen attributes)
{
  #define H_gtk_tree_view_column_new_with_attributes "GtkTreeViewColumn* gtk_tree_view_column_new_with_attributes(gchar* title, \
GtkCellRenderer* cell, etc attributes)"
  Xen_check_type(Xen_is_gchar_(title), title, 1, "gtk_tree_view_column_new_with_attributes", "gchar*");
  Xen_check_type(Xen_is_GtkCellRenderer_(cell), cell, 2, "gtk_tree_view_column_new_with_attributes", "GtkCellRenderer*");
  Xen_check_type(Xen_is_etc(attributes), attributes, 3, "gtk_tree_view_column_new_with_attributes", "etc");
  {
    int etc_len = 0;
    GtkTreeViewColumn* res_ult = NULL;
    gchar* p_arg0;
    GtkCellRenderer* p_arg1;
    if (Xen_is_list(attributes)) etc_len = Xen_list_length(attributes);
    if (etc_len < 2) Xen_out_of_range_error("gtk_tree_view_column_new_with_attributes", 2, attributes, "... list must have at least 2 entries");
    if (etc_len > 10) Xen_out_of_range_error("gtk_tree_view_column_new_with_attributes", 2, attributes, "... list too long (max len: 10)");
    if ((etc_len % 2) != 0) Xen_out_of_range_error("gtk_tree_view_column_new_with_attributes", 2, attributes, "... list len must be multiple of 2");
    p_arg0 = Xen_to_C_gchar_(title);
    p_arg1 = Xen_to_C_GtkCellRenderer_(cell);
    switch (etc_len)
      {
        case 2: res_ult = gtk_tree_view_column_new_with_attributes(p_arg0, p_arg1, XLS(attributes, 0), XLI(attributes, 1), NULL); break;
        case 4: res_ult = gtk_tree_view_column_new_with_attributes(p_arg0, p_arg1, XLS(attributes, 0), XLI(attributes, 1), XLS(attributes, 2), XLI(attributes, 3), NULL); break;
        case 6: res_ult = gtk_tree_view_column_new_with_attributes(p_arg0, p_arg1, XLS(attributes, 0), XLI(attributes, 1), XLS(attributes, 2), XLI(attributes, 3), XLS(attributes, 4), XLI(attributes, 5), NULL); break;
        case 8: res_ult = gtk_tree_view_column_new_with_attributes(p_arg0, p_arg1, XLS(attributes, 0), XLI(attributes, 1), XLS(attributes, 2), XLI(attributes, 3), XLS(attributes, 4), XLI(attributes, 5), XLS(attributes, 6), XLI(attributes, 7), NULL); break;
        case 10: res_ult = gtk_tree_view_column_new_with_attributes(p_arg0, p_arg1, XLS(attributes, 0), XLI(attributes, 1), XLS(attributes, 2), XLI(attributes, 3), XLS(attributes, 4), XLI(attributes, 5), XLS(attributes, 6), XLI(attributes, 7), XLS(attributes, 8), XLI(attributes, 9), NULL); break;
      }
    return(C_to_Xen_GtkTreeViewColumn_(res_ult));
  }
}

static Xen gxg_gtk_tree_view_column_pack_start(Xen tree_column, Xen cell, Xen expand)
{
  #define H_gtk_tree_view_column_pack_start "void gtk_tree_view_column_pack_start(GtkTreeViewColumn* tree_column, \
GtkCellRenderer* cell, gboolean expand)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_pack_start", "GtkTreeViewColumn*");
  Xen_check_type(Xen_is_GtkCellRenderer_(cell), cell, 2, "gtk_tree_view_column_pack_start", "GtkCellRenderer*");
  Xen_check_type(Xen_is_gboolean(expand), expand, 3, "gtk_tree_view_column_pack_start", "gboolean");
  gtk_tree_view_column_pack_start(Xen_to_C_GtkTreeViewColumn_(tree_column), Xen_to_C_GtkCellRenderer_(cell), Xen_to_C_gboolean(expand));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_column_pack_end(Xen tree_column, Xen cell, Xen expand)
{
  #define H_gtk_tree_view_column_pack_end "void gtk_tree_view_column_pack_end(GtkTreeViewColumn* tree_column, \
GtkCellRenderer* cell, gboolean expand)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_pack_end", "GtkTreeViewColumn*");
  Xen_check_type(Xen_is_GtkCellRenderer_(cell), cell, 2, "gtk_tree_view_column_pack_end", "GtkCellRenderer*");
  Xen_check_type(Xen_is_gboolean(expand), expand, 3, "gtk_tree_view_column_pack_end", "gboolean");
  gtk_tree_view_column_pack_end(Xen_to_C_GtkTreeViewColumn_(tree_column), Xen_to_C_GtkCellRenderer_(cell), Xen_to_C_gboolean(expand));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_column_clear(Xen tree_column)
{
  #define H_gtk_tree_view_column_clear "void gtk_tree_view_column_clear(GtkTreeViewColumn* tree_column)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_clear", "GtkTreeViewColumn*");
  gtk_tree_view_column_clear(Xen_to_C_GtkTreeViewColumn_(tree_column));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_column_add_attribute(Xen tree_column, Xen cell_renderer, Xen attribute, Xen column)
{
  #define H_gtk_tree_view_column_add_attribute "void gtk_tree_view_column_add_attribute(GtkTreeViewColumn* tree_column, \
GtkCellRenderer* cell_renderer, gchar* attribute, gint column)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_add_attribute", "GtkTreeViewColumn*");
  Xen_check_type(Xen_is_GtkCellRenderer_(cell_renderer), cell_renderer, 2, "gtk_tree_view_column_add_attribute", "GtkCellRenderer*");
  Xen_check_type(Xen_is_gchar_(attribute), attribute, 3, "gtk_tree_view_column_add_attribute", "gchar*");
  Xen_check_type(Xen_is_gint(column), column, 4, "gtk_tree_view_column_add_attribute", "gint");
  gtk_tree_view_column_add_attribute(Xen_to_C_GtkTreeViewColumn_(tree_column), Xen_to_C_GtkCellRenderer_(cell_renderer), 
                                     Xen_to_C_gchar_(attribute), Xen_to_C_gint(column));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_column_set_attributes(Xen tree_column, Xen cell_renderer, Xen attributes)
{
  #define H_gtk_tree_view_column_set_attributes "void gtk_tree_view_column_set_attributes(GtkTreeViewColumn* tree_column, \
GtkCellRenderer* cell_renderer, etc attributes)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_set_attributes", "GtkTreeViewColumn*");
  Xen_check_type(Xen_is_GtkCellRenderer_(cell_renderer), cell_renderer, 2, "gtk_tree_view_column_set_attributes", "GtkCellRenderer*");
  Xen_check_type(Xen_is_etc(attributes), attributes, 3, "gtk_tree_view_column_set_attributes", "etc");
  {
    int etc_len = 0;
    GtkTreeViewColumn* p_arg0;
    GtkCellRenderer* p_arg1;
    if (Xen_is_list(attributes)) etc_len = Xen_list_length(attributes);
    if (etc_len < 2) Xen_out_of_range_error("gtk_tree_view_column_set_attributes", 2, attributes, "... list must have at least 2 entries");
    if (etc_len > 10) Xen_out_of_range_error("gtk_tree_view_column_set_attributes", 2, attributes, "... list too long (max len: 10)");
    if ((etc_len % 2) != 0) Xen_out_of_range_error("gtk_tree_view_column_set_attributes", 2, attributes, "... list len must be multiple of 2");
    p_arg0 = Xen_to_C_GtkTreeViewColumn_(tree_column);
    p_arg1 = Xen_to_C_GtkCellRenderer_(cell_renderer);
    switch (etc_len)
      {
        case 2: gtk_tree_view_column_set_attributes(p_arg0, p_arg1, XLS(attributes, 0), XLI(attributes, 1), NULL); break;
        case 4: gtk_tree_view_column_set_attributes(p_arg0, p_arg1, XLS(attributes, 0), XLI(attributes, 1), XLS(attributes, 2), XLI(attributes, 3), NULL); break;
        case 6: gtk_tree_view_column_set_attributes(p_arg0, p_arg1, XLS(attributes, 0), XLI(attributes, 1), XLS(attributes, 2), XLI(attributes, 3), XLS(attributes, 4), XLI(attributes, 5), NULL); break;
        case 8: gtk_tree_view_column_set_attributes(p_arg0, p_arg1, XLS(attributes, 0), XLI(attributes, 1), XLS(attributes, 2), XLI(attributes, 3), XLS(attributes, 4), XLI(attributes, 5), XLS(attributes, 6), XLI(attributes, 7), NULL); break;
        case 10: gtk_tree_view_column_set_attributes(p_arg0, p_arg1, XLS(attributes, 0), XLI(attributes, 1), XLS(attributes, 2), XLI(attributes, 3), XLS(attributes, 4), XLI(attributes, 5), XLS(attributes, 6), XLI(attributes, 7), XLS(attributes, 8), XLI(attributes, 9), NULL); break;
      }
    return(Xen_false);
  }
}

static Xen gxg_gtk_tree_view_column_set_cell_data_func(Xen tree_column, Xen cell_renderer, Xen func, Xen func_info, Xen destroy)
{
  #define H_gtk_tree_view_column_set_cell_data_func "void gtk_tree_view_column_set_cell_data_func(GtkTreeViewColumn* tree_column, \
GtkCellRenderer* cell_renderer, GtkTreeCellDataFunc func, lambda_data func_info, GtkDestroyNotify destroy)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_set_cell_data_func", "GtkTreeViewColumn*");
  Xen_check_type(Xen_is_GtkCellRenderer_(cell_renderer), cell_renderer, 2, "gtk_tree_view_column_set_cell_data_func", "GtkCellRenderer*");
  Xen_check_type(Xen_is_GtkTreeCellDataFunc(func), func, 3, "gtk_tree_view_column_set_cell_data_func", "GtkTreeCellDataFunc");
  Xen_check_type(Xen_is_lambda_data(func_info) || Xen_is_false(func_info), func_info, 4, "gtk_tree_view_column_set_cell_data_func", "lambda_data");
  Xen_check_type(Xen_is_GtkDestroyNotify(destroy), destroy, 5, "gtk_tree_view_column_set_cell_data_func", "GtkDestroyNotify");
  {
    Xen gxg_ptr = Xen_list_5(func, func_info, Xen_false, Xen_false, Xen_false);
    xm_protect(gxg_ptr);
    Xen_list_set(gxg_ptr, 3, destroy);
    gtk_tree_view_column_set_cell_data_func(Xen_to_C_GtkTreeViewColumn_(tree_column), Xen_to_C_GtkCellRenderer_(cell_renderer), 
                                        Xen_to_C_GtkTreeCellDataFunc(func), Xen_to_C_lambda_data(func_info), Xen_to_C_GtkDestroyNotify(destroy));
    return(Xen_false);
   }
}

static Xen gxg_gtk_tree_view_column_clear_attributes(Xen tree_column, Xen cell_renderer)
{
  #define H_gtk_tree_view_column_clear_attributes "void gtk_tree_view_column_clear_attributes(GtkTreeViewColumn* tree_column, \
GtkCellRenderer* cell_renderer)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_clear_attributes", "GtkTreeViewColumn*");
  Xen_check_type(Xen_is_GtkCellRenderer_(cell_renderer), cell_renderer, 2, "gtk_tree_view_column_clear_attributes", "GtkCellRenderer*");
  gtk_tree_view_column_clear_attributes(Xen_to_C_GtkTreeViewColumn_(tree_column), Xen_to_C_GtkCellRenderer_(cell_renderer));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_column_set_spacing(Xen tree_column, Xen spacing)
{
  #define H_gtk_tree_view_column_set_spacing "void gtk_tree_view_column_set_spacing(GtkTreeViewColumn* tree_column, \
gint spacing)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_set_spacing", "GtkTreeViewColumn*");
  Xen_check_type(Xen_is_gint(spacing), spacing, 2, "gtk_tree_view_column_set_spacing", "gint");
  gtk_tree_view_column_set_spacing(Xen_to_C_GtkTreeViewColumn_(tree_column), Xen_to_C_gint(spacing));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_column_get_spacing(Xen tree_column)
{
  #define H_gtk_tree_view_column_get_spacing "gint gtk_tree_view_column_get_spacing(GtkTreeViewColumn* tree_column)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_get_spacing", "GtkTreeViewColumn*");
  return(C_to_Xen_gint(gtk_tree_view_column_get_spacing(Xen_to_C_GtkTreeViewColumn_(tree_column))));
}

static Xen gxg_gtk_tree_view_column_set_visible(Xen tree_column, Xen visible)
{
  #define H_gtk_tree_view_column_set_visible "void gtk_tree_view_column_set_visible(GtkTreeViewColumn* tree_column, \
gboolean visible)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_set_visible", "GtkTreeViewColumn*");
  Xen_check_type(Xen_is_gboolean(visible), visible, 2, "gtk_tree_view_column_set_visible", "gboolean");
  gtk_tree_view_column_set_visible(Xen_to_C_GtkTreeViewColumn_(tree_column), Xen_to_C_gboolean(visible));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_column_get_visible(Xen tree_column)
{
  #define H_gtk_tree_view_column_get_visible "gboolean gtk_tree_view_column_get_visible(GtkTreeViewColumn* tree_column)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_get_visible", "GtkTreeViewColumn*");
  return(C_to_Xen_gboolean(gtk_tree_view_column_get_visible(Xen_to_C_GtkTreeViewColumn_(tree_column))));
}

static Xen gxg_gtk_tree_view_column_set_resizable(Xen tree_column, Xen resizable)
{
  #define H_gtk_tree_view_column_set_resizable "void gtk_tree_view_column_set_resizable(GtkTreeViewColumn* tree_column, \
gboolean resizable)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_set_resizable", "GtkTreeViewColumn*");
  Xen_check_type(Xen_is_gboolean(resizable), resizable, 2, "gtk_tree_view_column_set_resizable", "gboolean");
  gtk_tree_view_column_set_resizable(Xen_to_C_GtkTreeViewColumn_(tree_column), Xen_to_C_gboolean(resizable));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_column_get_resizable(Xen tree_column)
{
  #define H_gtk_tree_view_column_get_resizable "gboolean gtk_tree_view_column_get_resizable(GtkTreeViewColumn* tree_column)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_get_resizable", "GtkTreeViewColumn*");
  return(C_to_Xen_gboolean(gtk_tree_view_column_get_resizable(Xen_to_C_GtkTreeViewColumn_(tree_column))));
}

static Xen gxg_gtk_tree_view_column_set_sizing(Xen tree_column, Xen type)
{
  #define H_gtk_tree_view_column_set_sizing "void gtk_tree_view_column_set_sizing(GtkTreeViewColumn* tree_column, \
GtkTreeViewColumnSizing type)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_set_sizing", "GtkTreeViewColumn*");
  Xen_check_type(Xen_is_GtkTreeViewColumnSizing(type), type, 2, "gtk_tree_view_column_set_sizing", "GtkTreeViewColumnSizing");
  gtk_tree_view_column_set_sizing(Xen_to_C_GtkTreeViewColumn_(tree_column), Xen_to_C_GtkTreeViewColumnSizing(type));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_column_get_sizing(Xen tree_column)
{
  #define H_gtk_tree_view_column_get_sizing "GtkTreeViewColumnSizing gtk_tree_view_column_get_sizing(GtkTreeViewColumn* tree_column)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_get_sizing", "GtkTreeViewColumn*");
  return(C_to_Xen_GtkTreeViewColumnSizing(gtk_tree_view_column_get_sizing(Xen_to_C_GtkTreeViewColumn_(tree_column))));
}

static Xen gxg_gtk_tree_view_column_get_width(Xen tree_column)
{
  #define H_gtk_tree_view_column_get_width "gint gtk_tree_view_column_get_width(GtkTreeViewColumn* tree_column)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_get_width", "GtkTreeViewColumn*");
  return(C_to_Xen_gint(gtk_tree_view_column_get_width(Xen_to_C_GtkTreeViewColumn_(tree_column))));
}

static Xen gxg_gtk_tree_view_column_get_fixed_width(Xen tree_column)
{
  #define H_gtk_tree_view_column_get_fixed_width "gint gtk_tree_view_column_get_fixed_width(GtkTreeViewColumn* tree_column)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_get_fixed_width", "GtkTreeViewColumn*");
  return(C_to_Xen_gint(gtk_tree_view_column_get_fixed_width(Xen_to_C_GtkTreeViewColumn_(tree_column))));
}

static Xen gxg_gtk_tree_view_column_set_fixed_width(Xen tree_column, Xen fixed_width)
{
  #define H_gtk_tree_view_column_set_fixed_width "void gtk_tree_view_column_set_fixed_width(GtkTreeViewColumn* tree_column, \
gint fixed_width)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_set_fixed_width", "GtkTreeViewColumn*");
  Xen_check_type(Xen_is_gint(fixed_width), fixed_width, 2, "gtk_tree_view_column_set_fixed_width", "gint");
  gtk_tree_view_column_set_fixed_width(Xen_to_C_GtkTreeViewColumn_(tree_column), Xen_to_C_gint(fixed_width));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_column_set_min_width(Xen tree_column, Xen min_width)
{
  #define H_gtk_tree_view_column_set_min_width "void gtk_tree_view_column_set_min_width(GtkTreeViewColumn* tree_column, \
gint min_width)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_set_min_width", "GtkTreeViewColumn*");
  Xen_check_type(Xen_is_gint(min_width), min_width, 2, "gtk_tree_view_column_set_min_width", "gint");
  gtk_tree_view_column_set_min_width(Xen_to_C_GtkTreeViewColumn_(tree_column), Xen_to_C_gint(min_width));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_column_get_min_width(Xen tree_column)
{
  #define H_gtk_tree_view_column_get_min_width "gint gtk_tree_view_column_get_min_width(GtkTreeViewColumn* tree_column)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_get_min_width", "GtkTreeViewColumn*");
  return(C_to_Xen_gint(gtk_tree_view_column_get_min_width(Xen_to_C_GtkTreeViewColumn_(tree_column))));
}

static Xen gxg_gtk_tree_view_column_set_max_width(Xen tree_column, Xen max_width)
{
  #define H_gtk_tree_view_column_set_max_width "void gtk_tree_view_column_set_max_width(GtkTreeViewColumn* tree_column, \
gint max_width)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_set_max_width", "GtkTreeViewColumn*");
  Xen_check_type(Xen_is_gint(max_width), max_width, 2, "gtk_tree_view_column_set_max_width", "gint");
  gtk_tree_view_column_set_max_width(Xen_to_C_GtkTreeViewColumn_(tree_column), Xen_to_C_gint(max_width));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_column_get_max_width(Xen tree_column)
{
  #define H_gtk_tree_view_column_get_max_width "gint gtk_tree_view_column_get_max_width(GtkTreeViewColumn* tree_column)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_get_max_width", "GtkTreeViewColumn*");
  return(C_to_Xen_gint(gtk_tree_view_column_get_max_width(Xen_to_C_GtkTreeViewColumn_(tree_column))));
}

static Xen gxg_gtk_tree_view_column_clicked(Xen tree_column)
{
  #define H_gtk_tree_view_column_clicked "void gtk_tree_view_column_clicked(GtkTreeViewColumn* tree_column)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_clicked", "GtkTreeViewColumn*");
  gtk_tree_view_column_clicked(Xen_to_C_GtkTreeViewColumn_(tree_column));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_column_set_title(Xen tree_column, Xen title)
{
  #define H_gtk_tree_view_column_set_title "void gtk_tree_view_column_set_title(GtkTreeViewColumn* tree_column, \
gchar* title)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_set_title", "GtkTreeViewColumn*");
  Xen_check_type(Xen_is_gchar_(title), title, 2, "gtk_tree_view_column_set_title", "gchar*");
  gtk_tree_view_column_set_title(Xen_to_C_GtkTreeViewColumn_(tree_column), Xen_to_C_gchar_(title));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_column_get_title(Xen tree_column)
{
  #define H_gtk_tree_view_column_get_title "gchar* gtk_tree_view_column_get_title(GtkTreeViewColumn* tree_column)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_get_title", "GtkTreeViewColumn*");
  return(C_to_Xen_gchar_(gtk_tree_view_column_get_title(Xen_to_C_GtkTreeViewColumn_(tree_column))));
}

static Xen gxg_gtk_tree_view_column_set_clickable(Xen tree_column, Xen clickable)
{
  #define H_gtk_tree_view_column_set_clickable "void gtk_tree_view_column_set_clickable(GtkTreeViewColumn* tree_column, \
gboolean clickable)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_set_clickable", "GtkTreeViewColumn*");
  Xen_check_type(Xen_is_gboolean(clickable), clickable, 2, "gtk_tree_view_column_set_clickable", "gboolean");
  gtk_tree_view_column_set_clickable(Xen_to_C_GtkTreeViewColumn_(tree_column), Xen_to_C_gboolean(clickable));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_column_get_clickable(Xen tree_column)
{
  #define H_gtk_tree_view_column_get_clickable "gboolean gtk_tree_view_column_get_clickable(GtkTreeViewColumn* tree_column)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_get_clickable", "GtkTreeViewColumn*");
  return(C_to_Xen_gboolean(gtk_tree_view_column_get_clickable(Xen_to_C_GtkTreeViewColumn_(tree_column))));
}

static Xen gxg_gtk_tree_view_column_set_widget(Xen tree_column, Xen widget)
{
  #define H_gtk_tree_view_column_set_widget "void gtk_tree_view_column_set_widget(GtkTreeViewColumn* tree_column, \
GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_set_widget", "GtkTreeViewColumn*");
  Xen_check_type(Xen_is_GtkWidget_(widget) || Xen_is_false(widget), widget, 2, "gtk_tree_view_column_set_widget", "GtkWidget*");
  gtk_tree_view_column_set_widget(Xen_to_C_GtkTreeViewColumn_(tree_column), Xen_to_C_GtkWidget_(widget));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_column_get_widget(Xen tree_column)
{
  #define H_gtk_tree_view_column_get_widget "GtkWidget* gtk_tree_view_column_get_widget(GtkTreeViewColumn* tree_column)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_get_widget", "GtkTreeViewColumn*");
  return(C_to_Xen_GtkWidget_(gtk_tree_view_column_get_widget(Xen_to_C_GtkTreeViewColumn_(tree_column))));
}

static Xen gxg_gtk_tree_view_column_set_alignment(Xen tree_column, Xen xalign)
{
  #define H_gtk_tree_view_column_set_alignment "void gtk_tree_view_column_set_alignment(GtkTreeViewColumn* tree_column, \
gfloat xalign)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_set_alignment", "GtkTreeViewColumn*");
  Xen_check_type(Xen_is_gfloat(xalign), xalign, 2, "gtk_tree_view_column_set_alignment", "gfloat");
  gtk_tree_view_column_set_alignment(Xen_to_C_GtkTreeViewColumn_(tree_column), Xen_to_C_gfloat(xalign));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_column_get_alignment(Xen tree_column)
{
  #define H_gtk_tree_view_column_get_alignment "gfloat gtk_tree_view_column_get_alignment(GtkTreeViewColumn* tree_column)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_get_alignment", "GtkTreeViewColumn*");
  return(C_to_Xen_gfloat(gtk_tree_view_column_get_alignment(Xen_to_C_GtkTreeViewColumn_(tree_column))));
}

static Xen gxg_gtk_tree_view_column_set_reorderable(Xen tree_column, Xen reorderable)
{
  #define H_gtk_tree_view_column_set_reorderable "void gtk_tree_view_column_set_reorderable(GtkTreeViewColumn* tree_column, \
gboolean reorderable)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_set_reorderable", "GtkTreeViewColumn*");
  Xen_check_type(Xen_is_gboolean(reorderable), reorderable, 2, "gtk_tree_view_column_set_reorderable", "gboolean");
  gtk_tree_view_column_set_reorderable(Xen_to_C_GtkTreeViewColumn_(tree_column), Xen_to_C_gboolean(reorderable));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_column_get_reorderable(Xen tree_column)
{
  #define H_gtk_tree_view_column_get_reorderable "gboolean gtk_tree_view_column_get_reorderable(GtkTreeViewColumn* tree_column)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_get_reorderable", "GtkTreeViewColumn*");
  return(C_to_Xen_gboolean(gtk_tree_view_column_get_reorderable(Xen_to_C_GtkTreeViewColumn_(tree_column))));
}

static Xen gxg_gtk_tree_view_column_set_sort_column_id(Xen tree_column, Xen sort_column_id)
{
  #define H_gtk_tree_view_column_set_sort_column_id "void gtk_tree_view_column_set_sort_column_id(GtkTreeViewColumn* tree_column, \
gint sort_column_id)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_set_sort_column_id", "GtkTreeViewColumn*");
  Xen_check_type(Xen_is_gint(sort_column_id), sort_column_id, 2, "gtk_tree_view_column_set_sort_column_id", "gint");
  gtk_tree_view_column_set_sort_column_id(Xen_to_C_GtkTreeViewColumn_(tree_column), Xen_to_C_gint(sort_column_id));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_column_get_sort_column_id(Xen tree_column)
{
  #define H_gtk_tree_view_column_get_sort_column_id "gint gtk_tree_view_column_get_sort_column_id(GtkTreeViewColumn* tree_column)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_get_sort_column_id", "GtkTreeViewColumn*");
  return(C_to_Xen_gint(gtk_tree_view_column_get_sort_column_id(Xen_to_C_GtkTreeViewColumn_(tree_column))));
}

static Xen gxg_gtk_tree_view_column_set_sort_indicator(Xen tree_column, Xen setting)
{
  #define H_gtk_tree_view_column_set_sort_indicator "void gtk_tree_view_column_set_sort_indicator(GtkTreeViewColumn* tree_column, \
gboolean setting)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_set_sort_indicator", "GtkTreeViewColumn*");
  Xen_check_type(Xen_is_gboolean(setting), setting, 2, "gtk_tree_view_column_set_sort_indicator", "gboolean");
  gtk_tree_view_column_set_sort_indicator(Xen_to_C_GtkTreeViewColumn_(tree_column), Xen_to_C_gboolean(setting));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_column_get_sort_indicator(Xen tree_column)
{
  #define H_gtk_tree_view_column_get_sort_indicator "gboolean gtk_tree_view_column_get_sort_indicator(GtkTreeViewColumn* tree_column)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_get_sort_indicator", "GtkTreeViewColumn*");
  return(C_to_Xen_gboolean(gtk_tree_view_column_get_sort_indicator(Xen_to_C_GtkTreeViewColumn_(tree_column))));
}

static Xen gxg_gtk_tree_view_column_set_sort_order(Xen tree_column, Xen order)
{
  #define H_gtk_tree_view_column_set_sort_order "void gtk_tree_view_column_set_sort_order(GtkTreeViewColumn* tree_column, \
GtkSortType order)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_set_sort_order", "GtkTreeViewColumn*");
  Xen_check_type(Xen_is_GtkSortType(order), order, 2, "gtk_tree_view_column_set_sort_order", "GtkSortType");
  gtk_tree_view_column_set_sort_order(Xen_to_C_GtkTreeViewColumn_(tree_column), Xen_to_C_GtkSortType(order));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_column_get_sort_order(Xen tree_column)
{
  #define H_gtk_tree_view_column_get_sort_order "GtkSortType gtk_tree_view_column_get_sort_order(GtkTreeViewColumn* tree_column)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_get_sort_order", "GtkTreeViewColumn*");
  return(C_to_Xen_GtkSortType(gtk_tree_view_column_get_sort_order(Xen_to_C_GtkTreeViewColumn_(tree_column))));
}

static Xen gxg_gtk_tree_view_column_cell_set_cell_data(Xen tree_column, Xen tree_model, Xen iter, Xen is_expander, Xen is_expanded)
{
  #define H_gtk_tree_view_column_cell_set_cell_data "void gtk_tree_view_column_cell_set_cell_data(GtkTreeViewColumn* tree_column, \
GtkTreeModel* tree_model, GtkTreeIter* iter, gboolean is_expander, gboolean is_expanded)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_cell_set_cell_data", "GtkTreeViewColumn*");
  Xen_check_type(Xen_is_GtkTreeModel_(tree_model), tree_model, 2, "gtk_tree_view_column_cell_set_cell_data", "GtkTreeModel*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 3, "gtk_tree_view_column_cell_set_cell_data", "GtkTreeIter*");
  Xen_check_type(Xen_is_gboolean(is_expander), is_expander, 4, "gtk_tree_view_column_cell_set_cell_data", "gboolean");
  Xen_check_type(Xen_is_gboolean(is_expanded), is_expanded, 5, "gtk_tree_view_column_cell_set_cell_data", "gboolean");
  gtk_tree_view_column_cell_set_cell_data(Xen_to_C_GtkTreeViewColumn_(tree_column), Xen_to_C_GtkTreeModel_(tree_model), Xen_to_C_GtkTreeIter_(iter), 
                                          Xen_to_C_gboolean(is_expander), Xen_to_C_gboolean(is_expanded));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_column_cell_is_visible(Xen tree_column)
{
  #define H_gtk_tree_view_column_cell_is_visible "gboolean gtk_tree_view_column_cell_is_visible(GtkTreeViewColumn* tree_column)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_cell_is_visible", "GtkTreeViewColumn*");
  return(C_to_Xen_gboolean(gtk_tree_view_column_cell_is_visible(Xen_to_C_GtkTreeViewColumn_(tree_column))));
}

static Xen gxg_gtk_tree_view_column_cell_get_position(Xen tree_column, Xen cell_renderer, Xen ignore_start_pos, Xen ignore_width)
{
  #define H_gtk_tree_view_column_cell_get_position "gboolean gtk_tree_view_column_cell_get_position(GtkTreeViewColumn* tree_column, \
GtkCellRenderer* cell_renderer, gint* [start_pos], gint* [width])"
  gint ref_start_pos;
  gint ref_width;
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_cell_get_position", "GtkTreeViewColumn*");
  Xen_check_type(Xen_is_GtkCellRenderer_(cell_renderer), cell_renderer, 2, "gtk_tree_view_column_cell_get_position", "GtkCellRenderer*");
  {
    Xen res_ult;
    res_ult = C_to_Xen_gboolean(gtk_tree_view_column_cell_get_position(Xen_to_C_GtkTreeViewColumn_(tree_column), Xen_to_C_GtkCellRenderer_(cell_renderer), 
                                                                       &ref_start_pos, &ref_width));
    return(Xen_list_3(res_ult, C_to_Xen_gint(ref_start_pos), C_to_Xen_gint(ref_width)));
   }
}

static Xen gxg_gtk_tree_view_new(void)
{
  #define H_gtk_tree_view_new "GtkWidget* gtk_tree_view_new( void)"
  return(C_to_Xen_GtkWidget_(gtk_tree_view_new()));
}

static Xen gxg_gtk_tree_view_new_with_model(Xen model)
{
  #define H_gtk_tree_view_new_with_model "GtkWidget* gtk_tree_view_new_with_model(GtkTreeModel* model)"
  Xen_check_type(Xen_is_GtkTreeModel_(model), model, 1, "gtk_tree_view_new_with_model", "GtkTreeModel*");
  return(C_to_Xen_GtkWidget_(gtk_tree_view_new_with_model(Xen_to_C_GtkTreeModel_(model))));
}

static Xen gxg_gtk_tree_view_get_model(Xen tree_view)
{
  #define H_gtk_tree_view_get_model "GtkTreeModel* gtk_tree_view_get_model(GtkTreeView* tree_view)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_get_model", "GtkTreeView*");
  return(C_to_Xen_GtkTreeModel_(gtk_tree_view_get_model(Xen_to_C_GtkTreeView_(tree_view))));
}

static Xen gxg_gtk_tree_view_set_model(Xen tree_view, Xen model)
{
  #define H_gtk_tree_view_set_model "void gtk_tree_view_set_model(GtkTreeView* tree_view, GtkTreeModel* model)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_set_model", "GtkTreeView*");
  Xen_check_type(Xen_is_GtkTreeModel_(model) || Xen_is_false(model), model, 2, "gtk_tree_view_set_model", "GtkTreeModel*");
  gtk_tree_view_set_model(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_GtkTreeModel_(model));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_get_selection(Xen tree_view)
{
  #define H_gtk_tree_view_get_selection "GtkTreeSelection* gtk_tree_view_get_selection(GtkTreeView* tree_view)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_get_selection", "GtkTreeView*");
  return(C_to_Xen_GtkTreeSelection_(gtk_tree_view_get_selection(Xen_to_C_GtkTreeView_(tree_view))));
}

static Xen gxg_gtk_tree_view_get_headers_visible(Xen tree_view)
{
  #define H_gtk_tree_view_get_headers_visible "gboolean gtk_tree_view_get_headers_visible(GtkTreeView* tree_view)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_get_headers_visible", "GtkTreeView*");
  return(C_to_Xen_gboolean(gtk_tree_view_get_headers_visible(Xen_to_C_GtkTreeView_(tree_view))));
}

static Xen gxg_gtk_tree_view_set_headers_visible(Xen tree_view, Xen headers_visible)
{
  #define H_gtk_tree_view_set_headers_visible "void gtk_tree_view_set_headers_visible(GtkTreeView* tree_view, \
gboolean headers_visible)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_set_headers_visible", "GtkTreeView*");
  Xen_check_type(Xen_is_gboolean(headers_visible), headers_visible, 2, "gtk_tree_view_set_headers_visible", "gboolean");
  gtk_tree_view_set_headers_visible(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_gboolean(headers_visible));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_columns_autosize(Xen tree_view)
{
  #define H_gtk_tree_view_columns_autosize "void gtk_tree_view_columns_autosize(GtkTreeView* tree_view)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_columns_autosize", "GtkTreeView*");
  gtk_tree_view_columns_autosize(Xen_to_C_GtkTreeView_(tree_view));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_set_headers_clickable(Xen tree_view, Xen setting)
{
  #define H_gtk_tree_view_set_headers_clickable "void gtk_tree_view_set_headers_clickable(GtkTreeView* tree_view, \
gboolean setting)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_set_headers_clickable", "GtkTreeView*");
  Xen_check_type(Xen_is_gboolean(setting), setting, 2, "gtk_tree_view_set_headers_clickable", "gboolean");
  gtk_tree_view_set_headers_clickable(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_gboolean(setting));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_append_column(Xen tree_view, Xen column)
{
  #define H_gtk_tree_view_append_column "gint gtk_tree_view_append_column(GtkTreeView* tree_view, GtkTreeViewColumn* column)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_append_column", "GtkTreeView*");
  Xen_check_type(Xen_is_GtkTreeViewColumn_(column), column, 2, "gtk_tree_view_append_column", "GtkTreeViewColumn*");
  return(C_to_Xen_gint(gtk_tree_view_append_column(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_GtkTreeViewColumn_(column))));
}

static Xen gxg_gtk_tree_view_remove_column(Xen tree_view, Xen column)
{
  #define H_gtk_tree_view_remove_column "gint gtk_tree_view_remove_column(GtkTreeView* tree_view, GtkTreeViewColumn* column)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_remove_column", "GtkTreeView*");
  Xen_check_type(Xen_is_GtkTreeViewColumn_(column), column, 2, "gtk_tree_view_remove_column", "GtkTreeViewColumn*");
  return(C_to_Xen_gint(gtk_tree_view_remove_column(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_GtkTreeViewColumn_(column))));
}

static Xen gxg_gtk_tree_view_insert_column(Xen tree_view, Xen column, Xen position)
{
  #define H_gtk_tree_view_insert_column "gint gtk_tree_view_insert_column(GtkTreeView* tree_view, GtkTreeViewColumn* column, \
gint position)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_insert_column", "GtkTreeView*");
  Xen_check_type(Xen_is_GtkTreeViewColumn_(column), column, 2, "gtk_tree_view_insert_column", "GtkTreeViewColumn*");
  Xen_check_type(Xen_is_gint(position), position, 3, "gtk_tree_view_insert_column", "gint");
  return(C_to_Xen_gint(gtk_tree_view_insert_column(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_GtkTreeViewColumn_(column), 
                                                   Xen_to_C_gint(position))));
}

static Xen gxg_gtk_tree_view_insert_column_with_attributes(Xen tree_view, Xen position, Xen title, Xen cell, Xen attributes)
{
  #define H_gtk_tree_view_insert_column_with_attributes "gint gtk_tree_view_insert_column_with_attributes(GtkTreeView* tree_view, \
gint position, gchar* title, GtkCellRenderer* cell, etc attributes)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_insert_column_with_attributes", "GtkTreeView*");
  Xen_check_type(Xen_is_gint(position), position, 2, "gtk_tree_view_insert_column_with_attributes", "gint");
  Xen_check_type(Xen_is_gchar_(title), title, 3, "gtk_tree_view_insert_column_with_attributes", "gchar*");
  Xen_check_type(Xen_is_GtkCellRenderer_(cell), cell, 4, "gtk_tree_view_insert_column_with_attributes", "GtkCellRenderer*");
  Xen_check_type(Xen_is_etc(attributes), attributes, 5, "gtk_tree_view_insert_column_with_attributes", "etc");
  {
    int etc_len = 0;
    gint res_ult = 0;
    GtkTreeView* p_arg0;
    gint p_arg1;
    gchar* p_arg2;
    GtkCellRenderer* p_arg3;
    if (Xen_is_list(attributes)) etc_len = Xen_list_length(attributes);
    if (etc_len < 2) Xen_out_of_range_error("gtk_tree_view_insert_column_with_attributes", 4, attributes, "... list must have at least 2 entries");
    if (etc_len > 10) Xen_out_of_range_error("gtk_tree_view_insert_column_with_attributes", 4, attributes, "... list too long (max len: 10)");
    if ((etc_len % 2) != 0) Xen_out_of_range_error("gtk_tree_view_insert_column_with_attributes", 4, attributes, "... list len must be multiple of 2");
    p_arg0 = Xen_to_C_GtkTreeView_(tree_view);
    p_arg1 = Xen_to_C_gint(position);
    p_arg2 = Xen_to_C_gchar_(title);
    p_arg3 = Xen_to_C_GtkCellRenderer_(cell);
    switch (etc_len)
      {
        case 2: res_ult = gtk_tree_view_insert_column_with_attributes(p_arg0, p_arg1, p_arg2, p_arg3, XLS(attributes, 0), XLI(attributes, 1), NULL); break;
        case 4: res_ult = gtk_tree_view_insert_column_with_attributes(p_arg0, p_arg1, p_arg2, p_arg3, XLS(attributes, 0), XLI(attributes, 1), XLS(attributes, 2), XLI(attributes, 3), NULL); break;
        case 6: res_ult = gtk_tree_view_insert_column_with_attributes(p_arg0, p_arg1, p_arg2, p_arg3, XLS(attributes, 0), XLI(attributes, 1), XLS(attributes, 2), XLI(attributes, 3), XLS(attributes, 4), XLI(attributes, 5), NULL); break;
        case 8: res_ult = gtk_tree_view_insert_column_with_attributes(p_arg0, p_arg1, p_arg2, p_arg3, XLS(attributes, 0), XLI(attributes, 1), XLS(attributes, 2), XLI(attributes, 3), XLS(attributes, 4), XLI(attributes, 5), XLS(attributes, 6), XLI(attributes, 7), NULL); break;
        case 10: res_ult = gtk_tree_view_insert_column_with_attributes(p_arg0, p_arg1, p_arg2, p_arg3, XLS(attributes, 0), XLI(attributes, 1), XLS(attributes, 2), XLI(attributes, 3), XLS(attributes, 4), XLI(attributes, 5), XLS(attributes, 6), XLI(attributes, 7), XLS(attributes, 8), XLI(attributes, 9), NULL); break;
      }
    return(C_to_Xen_gint(res_ult));
  }
}

static Xen gxg_gtk_tree_view_insert_column_with_data_func(Xen tree_view, Xen position, Xen title, Xen cell, Xen func, Xen func_info, Xen dnotify)
{
  #define H_gtk_tree_view_insert_column_with_data_func "gint gtk_tree_view_insert_column_with_data_func(GtkTreeView* tree_view, \
gint position, gchar* title, GtkCellRenderer* cell, GtkTreeCellDataFunc func, lambda_data func_info, \
GtkDestroyNotify dnotify)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_insert_column_with_data_func", "GtkTreeView*");
  Xen_check_type(Xen_is_gint(position), position, 2, "gtk_tree_view_insert_column_with_data_func", "gint");
  Xen_check_type(Xen_is_gchar_(title), title, 3, "gtk_tree_view_insert_column_with_data_func", "gchar*");
  Xen_check_type(Xen_is_GtkCellRenderer_(cell), cell, 4, "gtk_tree_view_insert_column_with_data_func", "GtkCellRenderer*");
  Xen_check_type(Xen_is_GtkTreeCellDataFunc(func), func, 5, "gtk_tree_view_insert_column_with_data_func", "GtkTreeCellDataFunc");
  Xen_check_type(Xen_is_lambda_data(func_info) || Xen_is_false(func_info), func_info, 6, "gtk_tree_view_insert_column_with_data_func", "lambda_data");
  Xen_check_type(Xen_is_GtkDestroyNotify(dnotify), dnotify, 7, "gtk_tree_view_insert_column_with_data_func", "GtkDestroyNotify");
  {
    Xen res_ult;
    Xen gxg_ptr = Xen_list_5(func, func_info, Xen_false, Xen_false, Xen_false);
    xm_protect(gxg_ptr);
    Xen_list_set(gxg_ptr, 3, dnotify);
    res_ult = C_to_Xen_gint(gtk_tree_view_insert_column_with_data_func(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_gint(position), 
                                                                       Xen_to_C_gchar_(title), Xen_to_C_GtkCellRenderer_(cell), 
                                                                       Xen_to_C_GtkTreeCellDataFunc(func), Xen_to_C_lambda_data(func_info), 
                                                                       Xen_to_C_GtkDestroyNotify(dnotify)));
    return(res_ult);
   }
}

static Xen gxg_gtk_tree_view_get_column(Xen tree_view, Xen n)
{
  #define H_gtk_tree_view_get_column "GtkTreeViewColumn* gtk_tree_view_get_column(GtkTreeView* tree_view, \
gint n)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_get_column", "GtkTreeView*");
  Xen_check_type(Xen_is_gint(n), n, 2, "gtk_tree_view_get_column", "gint");
  return(C_to_Xen_GtkTreeViewColumn_(gtk_tree_view_get_column(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_gint(n))));
}

static Xen gxg_gtk_tree_view_get_columns(Xen tree_view)
{
  #define H_gtk_tree_view_get_columns "GList* gtk_tree_view_get_columns(GtkTreeView* tree_view)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_get_columns", "GtkTreeView*");
  return(C_to_Xen_GList_(gtk_tree_view_get_columns(Xen_to_C_GtkTreeView_(tree_view))));
}

static Xen gxg_gtk_tree_view_move_column_after(Xen tree_view, Xen column, Xen base_column)
{
  #define H_gtk_tree_view_move_column_after "void gtk_tree_view_move_column_after(GtkTreeView* tree_view, \
GtkTreeViewColumn* column, GtkTreeViewColumn* base_column)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_move_column_after", "GtkTreeView*");
  Xen_check_type(Xen_is_GtkTreeViewColumn_(column), column, 2, "gtk_tree_view_move_column_after", "GtkTreeViewColumn*");
  Xen_check_type(Xen_is_GtkTreeViewColumn_(base_column) || Xen_is_false(base_column), base_column, 3, "gtk_tree_view_move_column_after", "GtkTreeViewColumn*");
  gtk_tree_view_move_column_after(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_GtkTreeViewColumn_(column), Xen_to_C_GtkTreeViewColumn_(base_column));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_set_expander_column(Xen tree_view, Xen column)
{
  #define H_gtk_tree_view_set_expander_column "void gtk_tree_view_set_expander_column(GtkTreeView* tree_view, \
GtkTreeViewColumn* column)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_set_expander_column", "GtkTreeView*");
  Xen_check_type(Xen_is_GtkTreeViewColumn_(column) || Xen_is_false(column), column, 2, "gtk_tree_view_set_expander_column", "GtkTreeViewColumn*");
  gtk_tree_view_set_expander_column(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_GtkTreeViewColumn_(column));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_get_expander_column(Xen tree_view)
{
  #define H_gtk_tree_view_get_expander_column "GtkTreeViewColumn* gtk_tree_view_get_expander_column(GtkTreeView* tree_view)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_get_expander_column", "GtkTreeView*");
  return(C_to_Xen_GtkTreeViewColumn_(gtk_tree_view_get_expander_column(Xen_to_C_GtkTreeView_(tree_view))));
}

static Xen gxg_gtk_tree_view_set_column_drag_function(Xen tree_view, Xen func, Xen func_info, Xen destroy)
{
  #define H_gtk_tree_view_set_column_drag_function "void gtk_tree_view_set_column_drag_function(GtkTreeView* tree_view, \
GtkTreeViewColumnDropFunc func, lambda_data func_info, GtkDestroyNotify destroy)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_set_column_drag_function", "GtkTreeView*");
  Xen_check_type(Xen_is_GtkTreeViewColumnDropFunc(func), func, 2, "gtk_tree_view_set_column_drag_function", "GtkTreeViewColumnDropFunc");
  Xen_check_type(Xen_is_lambda_data(func_info) || Xen_is_false(func_info), func_info, 3, "gtk_tree_view_set_column_drag_function", "lambda_data");
  Xen_check_type(Xen_is_GtkDestroyNotify(destroy), destroy, 4, "gtk_tree_view_set_column_drag_function", "GtkDestroyNotify");
  {
    int loc;
    Xen gxg_ptr = Xen_list_5(func, func_info, Xen_false, Xen_false, Xen_false);
    loc = xm_protect(gxg_ptr);
    Xen_list_set(gxg_ptr, 2, C_int_to_Xen_integer(loc));
    Xen_list_set(gxg_ptr, 3, destroy);
    gtk_tree_view_set_column_drag_function(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_GtkTreeViewColumnDropFunc(func), Xen_to_C_lambda_data(func_info), 
                                       Xen_to_C_GtkDestroyNotify(destroy));
    xm_unprotect_at(loc);
    return(Xen_false);
   }
}

static Xen gxg_gtk_tree_view_scroll_to_point(Xen tree_view, Xen tree_x, Xen tree_y)
{
  #define H_gtk_tree_view_scroll_to_point "void gtk_tree_view_scroll_to_point(GtkTreeView* tree_view, \
gint tree_x, gint tree_y)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_scroll_to_point", "GtkTreeView*");
  Xen_check_type(Xen_is_gint(tree_x), tree_x, 2, "gtk_tree_view_scroll_to_point", "gint");
  Xen_check_type(Xen_is_gint(tree_y), tree_y, 3, "gtk_tree_view_scroll_to_point", "gint");
  gtk_tree_view_scroll_to_point(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_gint(tree_x), Xen_to_C_gint(tree_y));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_scroll_to_cell(Xen tree_view, Xen path, Xen column, Xen use_align, Xen row_align, Xen col_align)
{
  #define H_gtk_tree_view_scroll_to_cell "void gtk_tree_view_scroll_to_cell(GtkTreeView* tree_view, GtkTreePath* path, \
GtkTreeViewColumn* column, gboolean use_align, gfloat row_align, gfloat col_align)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_scroll_to_cell", "GtkTreeView*");
  Xen_check_type(Xen_is_GtkTreePath_(path) || Xen_is_false(path), path, 2, "gtk_tree_view_scroll_to_cell", "GtkTreePath*");
  Xen_check_type(Xen_is_GtkTreeViewColumn_(column) || Xen_is_false(column), column, 3, "gtk_tree_view_scroll_to_cell", "GtkTreeViewColumn*");
  Xen_check_type(Xen_is_gboolean(use_align), use_align, 4, "gtk_tree_view_scroll_to_cell", "gboolean");
  Xen_check_type(Xen_is_gfloat(row_align), row_align, 5, "gtk_tree_view_scroll_to_cell", "gfloat");
  Xen_check_type(Xen_is_gfloat(col_align), col_align, 6, "gtk_tree_view_scroll_to_cell", "gfloat");
  gtk_tree_view_scroll_to_cell(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_GtkTreePath_(path), Xen_to_C_GtkTreeViewColumn_(column), 
                               Xen_to_C_gboolean(use_align), Xen_to_C_gfloat(row_align), Xen_to_C_gfloat(col_align));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_row_activated(Xen tree_view, Xen path, Xen column)
{
  #define H_gtk_tree_view_row_activated "void gtk_tree_view_row_activated(GtkTreeView* tree_view, GtkTreePath* path, \
GtkTreeViewColumn* column)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_row_activated", "GtkTreeView*");
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 2, "gtk_tree_view_row_activated", "GtkTreePath*");
  Xen_check_type(Xen_is_GtkTreeViewColumn_(column), column, 3, "gtk_tree_view_row_activated", "GtkTreeViewColumn*");
  gtk_tree_view_row_activated(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_GtkTreePath_(path), Xen_to_C_GtkTreeViewColumn_(column));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_expand_all(Xen tree_view)
{
  #define H_gtk_tree_view_expand_all "void gtk_tree_view_expand_all(GtkTreeView* tree_view)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_expand_all", "GtkTreeView*");
  gtk_tree_view_expand_all(Xen_to_C_GtkTreeView_(tree_view));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_collapse_all(Xen tree_view)
{
  #define H_gtk_tree_view_collapse_all "void gtk_tree_view_collapse_all(GtkTreeView* tree_view)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_collapse_all", "GtkTreeView*");
  gtk_tree_view_collapse_all(Xen_to_C_GtkTreeView_(tree_view));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_expand_row(Xen tree_view, Xen path, Xen open_all)
{
  #define H_gtk_tree_view_expand_row "gboolean gtk_tree_view_expand_row(GtkTreeView* tree_view, GtkTreePath* path, \
gboolean open_all)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_expand_row", "GtkTreeView*");
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 2, "gtk_tree_view_expand_row", "GtkTreePath*");
  Xen_check_type(Xen_is_gboolean(open_all), open_all, 3, "gtk_tree_view_expand_row", "gboolean");
  return(C_to_Xen_gboolean(gtk_tree_view_expand_row(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_GtkTreePath_(path), Xen_to_C_gboolean(open_all))));
}

static Xen gxg_gtk_tree_view_collapse_row(Xen tree_view, Xen path)
{
  #define H_gtk_tree_view_collapse_row "gboolean gtk_tree_view_collapse_row(GtkTreeView* tree_view, GtkTreePath* path)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_collapse_row", "GtkTreeView*");
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 2, "gtk_tree_view_collapse_row", "GtkTreePath*");
  return(C_to_Xen_gboolean(gtk_tree_view_collapse_row(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_GtkTreePath_(path))));
}

static Xen gxg_gtk_tree_view_map_expanded_rows(Xen tree_view, Xen func, Xen func_info)
{
  #define H_gtk_tree_view_map_expanded_rows "void gtk_tree_view_map_expanded_rows(GtkTreeView* tree_view, \
GtkTreeViewMappingFunc func, lambda_data func_info)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_map_expanded_rows", "GtkTreeView*");
  Xen_check_type(Xen_is_GtkTreeViewMappingFunc(func), func, 2, "gtk_tree_view_map_expanded_rows", "GtkTreeViewMappingFunc");
  Xen_check_type(Xen_is_lambda_data(func_info) || Xen_is_false(func_info), func_info, 3, "gtk_tree_view_map_expanded_rows", "lambda_data");
  {
    int loc;
    Xen gxg_ptr = Xen_list_5(func, func_info, Xen_false, Xen_false, Xen_false);
    loc = xm_protect(gxg_ptr);
    Xen_list_set(gxg_ptr, 2, C_int_to_Xen_integer(loc));
    gtk_tree_view_map_expanded_rows(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_GtkTreeViewMappingFunc(func), Xen_to_C_lambda_data(func_info));
    xm_unprotect_at(loc);
    return(Xen_false);
   }
}

static Xen gxg_gtk_tree_view_row_expanded(Xen tree_view, Xen path)
{
  #define H_gtk_tree_view_row_expanded "gboolean gtk_tree_view_row_expanded(GtkTreeView* tree_view, GtkTreePath* path)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_row_expanded", "GtkTreeView*");
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 2, "gtk_tree_view_row_expanded", "GtkTreePath*");
  return(C_to_Xen_gboolean(gtk_tree_view_row_expanded(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_GtkTreePath_(path))));
}

static Xen gxg_gtk_tree_view_set_reorderable(Xen tree_view, Xen reorderable)
{
  #define H_gtk_tree_view_set_reorderable "void gtk_tree_view_set_reorderable(GtkTreeView* tree_view, \
gboolean reorderable)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_set_reorderable", "GtkTreeView*");
  Xen_check_type(Xen_is_gboolean(reorderable), reorderable, 2, "gtk_tree_view_set_reorderable", "gboolean");
  gtk_tree_view_set_reorderable(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_gboolean(reorderable));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_get_reorderable(Xen tree_view)
{
  #define H_gtk_tree_view_get_reorderable "gboolean gtk_tree_view_get_reorderable(GtkTreeView* tree_view)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_get_reorderable", "GtkTreeView*");
  return(C_to_Xen_gboolean(gtk_tree_view_get_reorderable(Xen_to_C_GtkTreeView_(tree_view))));
}

static Xen gxg_gtk_tree_view_set_cursor(Xen tree_view, Xen path, Xen focus_column, Xen start_editing)
{
  #define H_gtk_tree_view_set_cursor "void gtk_tree_view_set_cursor(GtkTreeView* tree_view, GtkTreePath* path, \
GtkTreeViewColumn* focus_column, gboolean start_editing)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_set_cursor", "GtkTreeView*");
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 2, "gtk_tree_view_set_cursor", "GtkTreePath*");
  Xen_check_type(Xen_is_GtkTreeViewColumn_(focus_column), focus_column, 3, "gtk_tree_view_set_cursor", "GtkTreeViewColumn*");
  Xen_check_type(Xen_is_gboolean(start_editing), start_editing, 4, "gtk_tree_view_set_cursor", "gboolean");
  gtk_tree_view_set_cursor(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_GtkTreePath_(path), Xen_to_C_GtkTreeViewColumn_(focus_column), 
                           Xen_to_C_gboolean(start_editing));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_get_cursor(Xen tree_view, Xen ignore_path, Xen ignore_focus_column)
{
  #define H_gtk_tree_view_get_cursor "void gtk_tree_view_get_cursor(GtkTreeView* tree_view, GtkTreePath** [path], \
GtkTreeViewColumn** [focus_column])"
  GtkTreePath* ref_path = NULL;
  GtkTreeViewColumn* ref_focus_column = NULL;
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_get_cursor", "GtkTreeView*");
  gtk_tree_view_get_cursor(Xen_to_C_GtkTreeView_(tree_view), &ref_path, &ref_focus_column);
  return(Xen_list_2(C_to_Xen_GtkTreePath_(ref_path), C_to_Xen_GtkTreeViewColumn_(ref_focus_column)));
}

static Xen gxg_gtk_tree_view_get_path_at_pos(Xen tree_view, Xen x, Xen y, Xen ignore_path, Xen ignore_column, Xen ignore_cell_x, Xen ignore_cell_y)
{
  #define H_gtk_tree_view_get_path_at_pos "gboolean gtk_tree_view_get_path_at_pos(GtkTreeView* tree_view, \
gint x, gint y, GtkTreePath** [path], GtkTreeViewColumn** [column], gint* [cell_x], gint* [cell_y])"
  GtkTreePath* ref_path = NULL;
  GtkTreeViewColumn* ref_column = NULL;
  gint ref_cell_x;
  gint ref_cell_y;
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_get_path_at_pos", "GtkTreeView*");
  Xen_check_type(Xen_is_gint(x), x, 2, "gtk_tree_view_get_path_at_pos", "gint");
  Xen_check_type(Xen_is_gint(y), y, 3, "gtk_tree_view_get_path_at_pos", "gint");
  {
    Xen res_ult;
    res_ult = C_to_Xen_gboolean(gtk_tree_view_get_path_at_pos(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_gint(x), Xen_to_C_gint(y), 
                                                              &ref_path, &ref_column, &ref_cell_x, &ref_cell_y));
    return(Xen_list_5(res_ult, C_to_Xen_GtkTreePath_(ref_path), C_to_Xen_GtkTreeViewColumn_(ref_column), C_to_Xen_gint(ref_cell_x), C_to_Xen_gint(ref_cell_y)));
   }
}

static Xen gxg_gtk_tree_view_get_cell_area(Xen tree_view, Xen path, Xen column, Xen rect)
{
  #define H_gtk_tree_view_get_cell_area "void gtk_tree_view_get_cell_area(GtkTreeView* tree_view, GtkTreePath* path, \
GtkTreeViewColumn* column, GdkRectangle* rect)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_get_cell_area", "GtkTreeView*");
  Xen_check_type(Xen_is_GtkTreePath_(path) || Xen_is_false(path), path, 2, "gtk_tree_view_get_cell_area", "GtkTreePath*");
  Xen_check_type(Xen_is_GtkTreeViewColumn_(column) || Xen_is_false(column), column, 3, "gtk_tree_view_get_cell_area", "GtkTreeViewColumn*");
  Xen_check_type(Xen_is_GdkRectangle_(rect), rect, 4, "gtk_tree_view_get_cell_area", "GdkRectangle*");
  gtk_tree_view_get_cell_area(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_GtkTreePath_(path), Xen_to_C_GtkTreeViewColumn_(column), 
                              Xen_to_C_GdkRectangle_(rect));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_get_background_area(Xen tree_view, Xen path, Xen column, Xen rect)
{
  #define H_gtk_tree_view_get_background_area "void gtk_tree_view_get_background_area(GtkTreeView* tree_view, \
GtkTreePath* path, GtkTreeViewColumn* column, GdkRectangle* rect)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_get_background_area", "GtkTreeView*");
  Xen_check_type(Xen_is_GtkTreePath_(path) || Xen_is_false(path), path, 2, "gtk_tree_view_get_background_area", "GtkTreePath*");
  Xen_check_type(Xen_is_GtkTreeViewColumn_(column) || Xen_is_false(column), column, 3, "gtk_tree_view_get_background_area", "GtkTreeViewColumn*");
  Xen_check_type(Xen_is_GdkRectangle_(rect), rect, 4, "gtk_tree_view_get_background_area", "GdkRectangle*");
  gtk_tree_view_get_background_area(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_GtkTreePath_(path), Xen_to_C_GtkTreeViewColumn_(column), 
                                    Xen_to_C_GdkRectangle_(rect));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_get_visible_rect(Xen tree_view, Xen visible_rect)
{
  #define H_gtk_tree_view_get_visible_rect "void gtk_tree_view_get_visible_rect(GtkTreeView* tree_view, \
GdkRectangle* visible_rect)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_get_visible_rect", "GtkTreeView*");
  Xen_check_type(Xen_is_GdkRectangle_(visible_rect), visible_rect, 2, "gtk_tree_view_get_visible_rect", "GdkRectangle*");
  gtk_tree_view_get_visible_rect(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_GdkRectangle_(visible_rect));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_unset_rows_drag_source(Xen tree_view)
{
  #define H_gtk_tree_view_unset_rows_drag_source "void gtk_tree_view_unset_rows_drag_source(GtkTreeView* tree_view)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_unset_rows_drag_source", "GtkTreeView*");
  gtk_tree_view_unset_rows_drag_source(Xen_to_C_GtkTreeView_(tree_view));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_get_dest_row_at_pos(Xen tree_view, Xen drag_x, Xen drag_y, Xen ignore_path, Xen ignore_pos)
{
  #define H_gtk_tree_view_get_dest_row_at_pos "gboolean gtk_tree_view_get_dest_row_at_pos(GtkTreeView* tree_view, \
gint drag_x, gint drag_y, GtkTreePath** [path], GtkTreeViewDropPosition* [pos])"
  GtkTreePath* ref_path = NULL;
  GtkTreeViewDropPosition ref_pos;
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_get_dest_row_at_pos", "GtkTreeView*");
  Xen_check_type(Xen_is_gint(drag_x), drag_x, 2, "gtk_tree_view_get_dest_row_at_pos", "gint");
  Xen_check_type(Xen_is_gint(drag_y), drag_y, 3, "gtk_tree_view_get_dest_row_at_pos", "gint");
  {
    Xen res_ult;
    res_ult = C_to_Xen_gboolean(gtk_tree_view_get_dest_row_at_pos(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_gint(drag_x), 
                                                                  Xen_to_C_gint(drag_y), &ref_path, &ref_pos));
    return(Xen_list_3(res_ult, C_to_Xen_GtkTreePath_(ref_path), C_to_Xen_GtkTreeViewDropPosition(ref_pos)));
   }
}

static Xen gxg_gtk_tree_view_set_enable_search(Xen tree_view, Xen enable_search)
{
  #define H_gtk_tree_view_set_enable_search "void gtk_tree_view_set_enable_search(GtkTreeView* tree_view, \
gboolean enable_search)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_set_enable_search", "GtkTreeView*");
  Xen_check_type(Xen_is_gboolean(enable_search), enable_search, 2, "gtk_tree_view_set_enable_search", "gboolean");
  gtk_tree_view_set_enable_search(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_gboolean(enable_search));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_get_enable_search(Xen tree_view)
{
  #define H_gtk_tree_view_get_enable_search "gboolean gtk_tree_view_get_enable_search(GtkTreeView* tree_view)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_get_enable_search", "GtkTreeView*");
  return(C_to_Xen_gboolean(gtk_tree_view_get_enable_search(Xen_to_C_GtkTreeView_(tree_view))));
}

static Xen gxg_gtk_tree_view_get_search_column(Xen tree_view)
{
  #define H_gtk_tree_view_get_search_column "gint gtk_tree_view_get_search_column(GtkTreeView* tree_view)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_get_search_column", "GtkTreeView*");
  return(C_to_Xen_gint(gtk_tree_view_get_search_column(Xen_to_C_GtkTreeView_(tree_view))));
}

static Xen gxg_gtk_tree_view_set_search_column(Xen tree_view, Xen column)
{
  #define H_gtk_tree_view_set_search_column "void gtk_tree_view_set_search_column(GtkTreeView* tree_view, \
gint column)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_set_search_column", "GtkTreeView*");
  Xen_check_type(Xen_is_gint(column), column, 2, "gtk_tree_view_set_search_column", "gint");
  gtk_tree_view_set_search_column(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_gint(column));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_get_search_equal_func(Xen tree_view)
{
  #define H_gtk_tree_view_get_search_equal_func "GtkTreeViewSearchEqualFunc gtk_tree_view_get_search_equal_func(GtkTreeView* tree_view)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_get_search_equal_func", "GtkTreeView*");
  return(C_to_Xen_GtkTreeViewSearchEqualFunc(gtk_tree_view_get_search_equal_func(Xen_to_C_GtkTreeView_(tree_view))));
}

static Xen gxg_gtk_tree_view_set_search_equal_func(Xen tree_view, Xen func, Xen func_info, Xen search_destroy)
{
  #define H_gtk_tree_view_set_search_equal_func "void gtk_tree_view_set_search_equal_func(GtkTreeView* tree_view, \
GtkTreeViewSearchEqualFunc func, lambda_data func_info, GtkDestroyNotify search_destroy)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_set_search_equal_func", "GtkTreeView*");
  Xen_check_type(Xen_is_GtkTreeViewSearchEqualFunc(func), func, 2, "gtk_tree_view_set_search_equal_func", "GtkTreeViewSearchEqualFunc");
  Xen_check_type(Xen_is_lambda_data(func_info) || Xen_is_false(func_info), func_info, 3, "gtk_tree_view_set_search_equal_func", "lambda_data");
  Xen_check_type(Xen_is_GtkDestroyNotify(search_destroy), search_destroy, 4, "gtk_tree_view_set_search_equal_func", "GtkDestroyNotify");
  {
    int loc;
    Xen gxg_ptr = Xen_list_5(func, func_info, Xen_false, Xen_false, Xen_false);
    loc = xm_protect(gxg_ptr);
    Xen_list_set(gxg_ptr, 2, C_int_to_Xen_integer(loc));
    Xen_list_set(gxg_ptr, 3, search_destroy);
    gtk_tree_view_set_search_equal_func(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_GtkTreeViewSearchEqualFunc(func), Xen_to_C_lambda_data(func_info), 
                                    Xen_to_C_GtkDestroyNotify(search_destroy));
    xm_unprotect_at(loc);
    return(Xen_false);
   }
}

static Xen gxg_gtk_viewport_new(Xen hadjustment, Xen vadjustment)
{
  #define H_gtk_viewport_new "GtkWidget* gtk_viewport_new(GtkAdjustment* hadjustment, GtkAdjustment* vadjustment)"
  Xen_check_type(Xen_is_GtkAdjustment_(hadjustment) || Xen_is_false(hadjustment), hadjustment, 1, "gtk_viewport_new", "GtkAdjustment*");
  Xen_check_type(Xen_is_GtkAdjustment_(vadjustment) || Xen_is_false(vadjustment), vadjustment, 2, "gtk_viewport_new", "GtkAdjustment*");
  return(C_to_Xen_GtkWidget_(gtk_viewport_new(Xen_to_C_GtkAdjustment_(hadjustment), Xen_to_C_GtkAdjustment_(vadjustment))));
}

static Xen gxg_gtk_widget_unparent(Xen widget)
{
  #define H_gtk_widget_unparent "void gtk_widget_unparent(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_unparent", "GtkWidget*");
  gtk_widget_unparent(Xen_to_C_GtkWidget_(widget));
  return(Xen_false);
}

static Xen gxg_gtk_widget_show(Xen widget)
{
  #define H_gtk_widget_show "void gtk_widget_show(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_show", "GtkWidget*");
  gtk_widget_show(Xen_to_C_GtkWidget_(widget));
  return(Xen_false);
}

static Xen gxg_gtk_widget_hide(Xen widget)
{
  #define H_gtk_widget_hide "void gtk_widget_hide(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_hide", "GtkWidget*");
  gtk_widget_hide(Xen_to_C_GtkWidget_(widget));
  return(Xen_false);
}

static Xen gxg_gtk_widget_map(Xen widget)
{
  #define H_gtk_widget_map "void gtk_widget_map(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_map", "GtkWidget*");
  gtk_widget_map(Xen_to_C_GtkWidget_(widget));
  return(Xen_false);
}

static Xen gxg_gtk_widget_unmap(Xen widget)
{
  #define H_gtk_widget_unmap "void gtk_widget_unmap(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_unmap", "GtkWidget*");
  gtk_widget_unmap(Xen_to_C_GtkWidget_(widget));
  return(Xen_false);
}

static Xen gxg_gtk_widget_realize(Xen widget)
{
  #define H_gtk_widget_realize "void gtk_widget_realize(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_realize", "GtkWidget*");
  gtk_widget_realize(Xen_to_C_GtkWidget_(widget));
  return(Xen_false);
}

static Xen gxg_gtk_widget_unrealize(Xen widget)
{
  #define H_gtk_widget_unrealize "void gtk_widget_unrealize(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_unrealize", "GtkWidget*");
  gtk_widget_unrealize(Xen_to_C_GtkWidget_(widget));
  return(Xen_false);
}

static Xen gxg_gtk_widget_queue_draw(Xen widget)
{
  #define H_gtk_widget_queue_draw "void gtk_widget_queue_draw(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_queue_draw", "GtkWidget*");
  gtk_widget_queue_draw(Xen_to_C_GtkWidget_(widget));
  return(Xen_false);
}

static Xen gxg_gtk_widget_queue_resize(Xen widget)
{
  #define H_gtk_widget_queue_resize "void gtk_widget_queue_resize(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_queue_resize", "GtkWidget*");
  gtk_widget_queue_resize(Xen_to_C_GtkWidget_(widget));
  return(Xen_false);
}

static Xen gxg_gtk_widget_mnemonic_activate(Xen widget, Xen group_cycling)
{
  #define H_gtk_widget_mnemonic_activate "gboolean gtk_widget_mnemonic_activate(GtkWidget* widget, gboolean group_cycling)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_mnemonic_activate", "GtkWidget*");
  Xen_check_type(Xen_is_gboolean(group_cycling), group_cycling, 2, "gtk_widget_mnemonic_activate", "gboolean");
  return(C_to_Xen_gboolean(gtk_widget_mnemonic_activate(Xen_to_C_GtkWidget_(widget), Xen_to_C_gboolean(group_cycling))));
}

static Xen gxg_gtk_widget_activate(Xen widget)
{
  #define H_gtk_widget_activate "gboolean gtk_widget_activate(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_activate", "GtkWidget*");
  return(C_to_Xen_gboolean(gtk_widget_activate(Xen_to_C_GtkWidget_(widget))));
}

static Xen gxg_gtk_widget_is_focus(Xen widget)
{
  #define H_gtk_widget_is_focus "gboolean gtk_widget_is_focus(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_is_focus", "GtkWidget*");
  return(C_to_Xen_gboolean(gtk_widget_is_focus(Xen_to_C_GtkWidget_(widget))));
}

static Xen gxg_gtk_widget_set_name(Xen widget, Xen name)
{
  #define H_gtk_widget_set_name "void gtk_widget_set_name(GtkWidget* widget, gchar* name)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_set_name", "GtkWidget*");
  Xen_check_type(Xen_is_gchar_(name), name, 2, "gtk_widget_set_name", "gchar*");
  gtk_widget_set_name(Xen_to_C_GtkWidget_(widget), Xen_to_C_gchar_(name));
  return(Xen_false);
}

static Xen gxg_gtk_widget_get_name(Xen widget)
{
  #define H_gtk_widget_get_name "gchar* gtk_widget_get_name(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_get_name", "GtkWidget*");
  return(C_to_Xen_gchar_(gtk_widget_get_name(Xen_to_C_GtkWidget_(widget))));
}

static Xen gxg_gtk_widget_set_sensitive(Xen widget, Xen sensitive)
{
  #define H_gtk_widget_set_sensitive "void gtk_widget_set_sensitive(GtkWidget* widget, gboolean sensitive)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_set_sensitive", "GtkWidget*");
  Xen_check_type(Xen_is_gboolean(sensitive), sensitive, 2, "gtk_widget_set_sensitive", "gboolean");
  gtk_widget_set_sensitive(Xen_to_C_GtkWidget_(widget), Xen_to_C_gboolean(sensitive));
  return(Xen_false);
}

static Xen gxg_gtk_widget_set_parent(Xen widget, Xen parent)
{
  #define H_gtk_widget_set_parent "void gtk_widget_set_parent(GtkWidget* widget, GtkWidget* parent)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_set_parent", "GtkWidget*");
  Xen_check_type(Xen_is_GtkWidget_(parent), parent, 2, "gtk_widget_set_parent", "GtkWidget*");
  gtk_widget_set_parent(Xen_to_C_GtkWidget_(widget), Xen_to_C_GtkWidget_(parent));
  return(Xen_false);
}

static Xen gxg_gtk_widget_set_child_visible(Xen widget, Xen is_visible)
{
  #define H_gtk_widget_set_child_visible "void gtk_widget_set_child_visible(GtkWidget* widget, gboolean is_visible)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_set_child_visible", "GtkWidget*");
  Xen_check_type(Xen_is_gboolean(is_visible), is_visible, 2, "gtk_widget_set_child_visible", "gboolean");
  gtk_widget_set_child_visible(Xen_to_C_GtkWidget_(widget), Xen_to_C_gboolean(is_visible));
  return(Xen_false);
}

static Xen gxg_gtk_widget_get_child_visible(Xen widget)
{
  #define H_gtk_widget_get_child_visible "gboolean gtk_widget_get_child_visible(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_get_child_visible", "GtkWidget*");
  return(C_to_Xen_gboolean(gtk_widget_get_child_visible(Xen_to_C_GtkWidget_(widget))));
}

static Xen gxg_gtk_widget_get_parent(Xen widget)
{
  #define H_gtk_widget_get_parent "GtkWidget* gtk_widget_get_parent(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_get_parent", "GtkWidget*");
  return(C_to_Xen_GtkWidget_(gtk_widget_get_parent(Xen_to_C_GtkWidget_(widget))));
}

static Xen gxg_gtk_widget_child_focus(Xen widget, Xen direction)
{
  #define H_gtk_widget_child_focus "gboolean gtk_widget_child_focus(GtkWidget* widget, GtkDirectionType direction)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_child_focus", "GtkWidget*");
  Xen_check_type(Xen_is_GtkDirectionType(direction), direction, 2, "gtk_widget_child_focus", "GtkDirectionType");
  return(C_to_Xen_gboolean(gtk_widget_child_focus(Xen_to_C_GtkWidget_(widget), Xen_to_C_GtkDirectionType(direction))));
}

static Xen gxg_gtk_widget_set_size_request(Xen widget, Xen width, Xen height)
{
  #define H_gtk_widget_set_size_request "void gtk_widget_set_size_request(GtkWidget* widget, gint width, \
gint height)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_set_size_request", "GtkWidget*");
  Xen_check_type(Xen_is_gint(width), width, 2, "gtk_widget_set_size_request", "gint");
  Xen_check_type(Xen_is_gint(height), height, 3, "gtk_widget_set_size_request", "gint");
  gtk_widget_set_size_request(Xen_to_C_GtkWidget_(widget), Xen_to_C_gint(width), Xen_to_C_gint(height));
  return(Xen_false);
}

static Xen gxg_gtk_widget_get_size_request(Xen widget, Xen ignore_width, Xen ignore_height)
{
  #define H_gtk_widget_get_size_request "void gtk_widget_get_size_request(GtkWidget* widget, gint* [width], \
gint* [height])"
  gint ref_width;
  gint ref_height;
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_get_size_request", "GtkWidget*");
  gtk_widget_get_size_request(Xen_to_C_GtkWidget_(widget), &ref_width, &ref_height);
  return(Xen_list_2(C_to_Xen_gint(ref_width), C_to_Xen_gint(ref_height)));
}

static Xen gxg_gtk_widget_get_ancestor(Xen widget, Xen widget_type)
{
  #define H_gtk_widget_get_ancestor "GtkWidget* gtk_widget_get_ancestor(GtkWidget* widget, GType widget_type)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_get_ancestor", "GtkWidget*");
  Xen_check_type(Xen_is_GType(widget_type), widget_type, 2, "gtk_widget_get_ancestor", "GType");
  return(C_to_Xen_GtkWidget_(gtk_widget_get_ancestor(Xen_to_C_GtkWidget_(widget), Xen_to_C_GType(widget_type))));
}

static Xen gxg_gtk_widget_get_settings(Xen widget)
{
  #define H_gtk_widget_get_settings "GtkSettings* gtk_widget_get_settings(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_get_settings", "GtkWidget*");
  return(C_to_Xen_GtkSettings_(gtk_widget_get_settings(Xen_to_C_GtkWidget_(widget))));
}

static Xen gxg_gtk_widget_get_accessible(Xen widget)
{
  #define H_gtk_widget_get_accessible "AtkObject* gtk_widget_get_accessible(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_get_accessible", "GtkWidget*");
  return(C_to_Xen_AtkObject_(gtk_widget_get_accessible(Xen_to_C_GtkWidget_(widget))));
}

static Xen gxg_gtk_widget_is_ancestor(Xen widget, Xen ancestor)
{
  #define H_gtk_widget_is_ancestor "gboolean gtk_widget_is_ancestor(GtkWidget* widget, GtkWidget* ancestor)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_is_ancestor", "GtkWidget*");
  Xen_check_type(Xen_is_GtkWidget_(ancestor), ancestor, 2, "gtk_widget_is_ancestor", "GtkWidget*");
  return(C_to_Xen_gboolean(gtk_widget_is_ancestor(Xen_to_C_GtkWidget_(widget), Xen_to_C_GtkWidget_(ancestor))));
}

static Xen gxg_gtk_widget_create_pango_context(Xen widget)
{
  #define H_gtk_widget_create_pango_context "PangoContext* gtk_widget_create_pango_context(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_create_pango_context", "GtkWidget*");
  return(C_to_Xen_PangoContext_(gtk_widget_create_pango_context(Xen_to_C_GtkWidget_(widget))));
}

static Xen gxg_gtk_widget_get_pango_context(Xen widget)
{
  #define H_gtk_widget_get_pango_context "PangoContext* gtk_widget_get_pango_context(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_get_pango_context", "GtkWidget*");
  return(C_to_Xen_PangoContext_(gtk_widget_get_pango_context(Xen_to_C_GtkWidget_(widget))));
}

static Xen gxg_gtk_widget_create_pango_layout(Xen widget, Xen text)
{
  #define H_gtk_widget_create_pango_layout "PangoLayout* gtk_widget_create_pango_layout(GtkWidget* widget, \
gchar* text)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_create_pango_layout", "GtkWidget*");
  Xen_check_type(Xen_is_gchar_(text), text, 2, "gtk_widget_create_pango_layout", "gchar*");
  return(C_to_Xen_PangoLayout_(gtk_widget_create_pango_layout(Xen_to_C_GtkWidget_(widget), Xen_to_C_gchar_(text))));
}

static Xen gxg_gtk_widget_set_direction(Xen widget, Xen dir)
{
  #define H_gtk_widget_set_direction "void gtk_widget_set_direction(GtkWidget* widget, GtkTextDirection dir)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_set_direction", "GtkWidget*");
  Xen_check_type(Xen_is_GtkTextDirection(dir), dir, 2, "gtk_widget_set_direction", "GtkTextDirection");
  gtk_widget_set_direction(Xen_to_C_GtkWidget_(widget), Xen_to_C_GtkTextDirection(dir));
  return(Xen_false);
}

static Xen gxg_gtk_widget_get_direction(Xen widget)
{
  #define H_gtk_widget_get_direction "GtkTextDirection gtk_widget_get_direction(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_get_direction", "GtkWidget*");
  return(C_to_Xen_GtkTextDirection(gtk_widget_get_direction(Xen_to_C_GtkWidget_(widget))));
}

static Xen gxg_gtk_widget_set_default_direction(Xen dir)
{
  #define H_gtk_widget_set_default_direction "void gtk_widget_set_default_direction(GtkTextDirection dir)"
  Xen_check_type(Xen_is_GtkTextDirection(dir), dir, 1, "gtk_widget_set_default_direction", "GtkTextDirection");
  gtk_widget_set_default_direction(Xen_to_C_GtkTextDirection(dir));
  return(Xen_false);
}

static Xen gxg_gtk_widget_get_default_direction(void)
{
  #define H_gtk_widget_get_default_direction "GtkTextDirection gtk_widget_get_default_direction( void)"
  return(C_to_Xen_GtkTextDirection(gtk_widget_get_default_direction()));
}

static Xen gxg_gtk_window_is_active(Xen window)
{
  #define H_gtk_window_is_active "gboolean gtk_window_is_active(GtkWindow* window)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_is_active", "GtkWindow*");
  return(C_to_Xen_gboolean(gtk_window_is_active(Xen_to_C_GtkWindow_(window))));
}

static Xen gxg_gtk_window_set_title(Xen window, Xen title)
{
  #define H_gtk_window_set_title "void gtk_window_set_title(GtkWindow* window, gchar* title)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_set_title", "GtkWindow*");
  Xen_check_type(Xen_is_gchar_(title), title, 2, "gtk_window_set_title", "gchar*");
  gtk_window_set_title(Xen_to_C_GtkWindow_(window), Xen_to_C_gchar_(title));
  return(Xen_false);
}

static Xen gxg_gtk_window_set_auto_startup_notification(Xen setting)
{
  #define H_gtk_window_set_auto_startup_notification "void gtk_window_set_auto_startup_notification(gboolean setting)"
  Xen_check_type(Xen_is_gboolean(setting), setting, 1, "gtk_window_set_auto_startup_notification", "gboolean");
  gtk_window_set_auto_startup_notification(Xen_to_C_gboolean(setting));
  return(Xen_false);
}

static Xen gxg_gtk_window_get_title(Xen window)
{
  #define H_gtk_window_get_title "gchar* gtk_window_get_title(GtkWindow* window)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_get_title", "GtkWindow*");
  return(C_to_Xen_gchar_(gtk_window_get_title(Xen_to_C_GtkWindow_(window))));
}

static Xen gxg_gtk_window_set_focus(Xen window, Xen focus)
{
  #define H_gtk_window_set_focus "void gtk_window_set_focus(GtkWindow* window, GtkWidget* focus)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_set_focus", "GtkWindow*");
  Xen_check_type(Xen_is_GtkWidget_(focus) || Xen_is_false(focus), focus, 2, "gtk_window_set_focus", "GtkWidget*");
  gtk_window_set_focus(Xen_to_C_GtkWindow_(window), Xen_to_C_GtkWidget_(focus));
  return(Xen_false);
}

static Xen gxg_gtk_window_get_focus(Xen window)
{
  #define H_gtk_window_get_focus "GtkWidget* gtk_window_get_focus(GtkWindow* window)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_get_focus", "GtkWindow*");
  return(C_to_Xen_GtkWidget_(gtk_window_get_focus(Xen_to_C_GtkWindow_(window))));
}

static Xen gxg_gtk_window_set_transient_for(Xen window, Xen parent)
{
  #define H_gtk_window_set_transient_for "void gtk_window_set_transient_for(GtkWindow* window, GtkWindow* parent)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_set_transient_for", "GtkWindow*");
  Xen_check_type(Xen_is_GtkWindow_(parent) || Xen_is_false(parent), parent, 2, "gtk_window_set_transient_for", "GtkWindow*");
  gtk_window_set_transient_for(Xen_to_C_GtkWindow_(window), Xen_to_C_GtkWindow_(parent));
  return(Xen_false);
}

static Xen gxg_gtk_window_get_transient_for(Xen window)
{
  #define H_gtk_window_get_transient_for "GtkWindow* gtk_window_get_transient_for(GtkWindow* window)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_get_transient_for", "GtkWindow*");
  return(C_to_Xen_GtkWindow_(gtk_window_get_transient_for(Xen_to_C_GtkWindow_(window))));
}

static Xen gxg_gtk_window_set_destroy_with_parent(Xen window, Xen setting)
{
  #define H_gtk_window_set_destroy_with_parent "void gtk_window_set_destroy_with_parent(GtkWindow* window, \
gboolean setting)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_set_destroy_with_parent", "GtkWindow*");
  Xen_check_type(Xen_is_gboolean(setting), setting, 2, "gtk_window_set_destroy_with_parent", "gboolean");
  gtk_window_set_destroy_with_parent(Xen_to_C_GtkWindow_(window), Xen_to_C_gboolean(setting));
  return(Xen_false);
}

static Xen gxg_gtk_window_get_destroy_with_parent(Xen window)
{
  #define H_gtk_window_get_destroy_with_parent "gboolean gtk_window_get_destroy_with_parent(GtkWindow* window)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_get_destroy_with_parent", "GtkWindow*");
  return(C_to_Xen_gboolean(gtk_window_get_destroy_with_parent(Xen_to_C_GtkWindow_(window))));
}

static Xen gxg_gtk_window_set_resizable(Xen window, Xen resizable)
{
  #define H_gtk_window_set_resizable "void gtk_window_set_resizable(GtkWindow* window, gboolean resizable)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_set_resizable", "GtkWindow*");
  Xen_check_type(Xen_is_gboolean(resizable), resizable, 2, "gtk_window_set_resizable", "gboolean");
  gtk_window_set_resizable(Xen_to_C_GtkWindow_(window), Xen_to_C_gboolean(resizable));
  return(Xen_false);
}

static Xen gxg_gtk_window_get_resizable(Xen window)
{
  #define H_gtk_window_get_resizable "gboolean gtk_window_get_resizable(GtkWindow* window)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_get_resizable", "GtkWindow*");
  return(C_to_Xen_gboolean(gtk_window_get_resizable(Xen_to_C_GtkWindow_(window))));
}

static Xen gxg_gtk_window_set_decorated(Xen window, Xen setting)
{
  #define H_gtk_window_set_decorated "void gtk_window_set_decorated(GtkWindow* window, gboolean setting)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_set_decorated", "GtkWindow*");
  Xen_check_type(Xen_is_gboolean(setting), setting, 2, "gtk_window_set_decorated", "gboolean");
  gtk_window_set_decorated(Xen_to_C_GtkWindow_(window), Xen_to_C_gboolean(setting));
  return(Xen_false);
}

static Xen gxg_gtk_window_get_decorated(Xen window)
{
  #define H_gtk_window_get_decorated "gboolean gtk_window_get_decorated(GtkWindow* window)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_get_decorated", "GtkWindow*");
  return(C_to_Xen_gboolean(gtk_window_get_decorated(Xen_to_C_GtkWindow_(window))));
}

static Xen gxg_gtk_window_set_modal(Xen window, Xen modal)
{
  #define H_gtk_window_set_modal "void gtk_window_set_modal(GtkWindow* window, gboolean modal)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_set_modal", "GtkWindow*");
  Xen_check_type(Xen_is_gboolean(modal), modal, 2, "gtk_window_set_modal", "gboolean");
  gtk_window_set_modal(Xen_to_C_GtkWindow_(window), Xen_to_C_gboolean(modal));
  return(Xen_false);
}

static Xen gxg_gtk_window_get_modal(Xen window)
{
  #define H_gtk_window_get_modal "gboolean gtk_window_get_modal(GtkWindow* window)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_get_modal", "GtkWindow*");
  return(C_to_Xen_gboolean(gtk_window_get_modal(Xen_to_C_GtkWindow_(window))));
}

static Xen gxg_gtk_window_list_toplevels(void)
{
  #define H_gtk_window_list_toplevels "GList* gtk_window_list_toplevels( void)"
  return(C_to_Xen_GList_(gtk_window_list_toplevels()));
}

static Xen gxg_gtk_window_present(Xen window)
{
  #define H_gtk_window_present "void gtk_window_present(GtkWindow* window)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_present", "GtkWindow*");
  gtk_window_present(Xen_to_C_GtkWindow_(window));
  return(Xen_false);
}

static Xen gxg_gtk_window_maximize(Xen window)
{
  #define H_gtk_window_maximize "void gtk_window_maximize(GtkWindow* window)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_maximize", "GtkWindow*");
  gtk_window_maximize(Xen_to_C_GtkWindow_(window));
  return(Xen_false);
}

static Xen gxg_gtk_window_unmaximize(Xen window)
{
  #define H_gtk_window_unmaximize "void gtk_window_unmaximize(GtkWindow* window)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_unmaximize", "GtkWindow*");
  gtk_window_unmaximize(Xen_to_C_GtkWindow_(window));
  return(Xen_false);
}

static Xen gxg_gtk_window_set_default_size(Xen window, Xen width, Xen height)
{
  #define H_gtk_window_set_default_size "void gtk_window_set_default_size(GtkWindow* window, gint width, \
gint height)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_set_default_size", "GtkWindow*");
  Xen_check_type(Xen_is_gint(width), width, 2, "gtk_window_set_default_size", "gint");
  Xen_check_type(Xen_is_gint(height), height, 3, "gtk_window_set_default_size", "gint");
  gtk_window_set_default_size(Xen_to_C_GtkWindow_(window), Xen_to_C_gint(width), Xen_to_C_gint(height));
  return(Xen_false);
}

static Xen gxg_gtk_window_get_default_size(Xen window, Xen ignore_width, Xen ignore_height)
{
  #define H_gtk_window_get_default_size "void gtk_window_get_default_size(GtkWindow* window, gint* [width], \
gint* [height])"
  gint ref_width;
  gint ref_height;
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_get_default_size", "GtkWindow*");
  gtk_window_get_default_size(Xen_to_C_GtkWindow_(window), &ref_width, &ref_height);
  return(Xen_list_2(C_to_Xen_gint(ref_width), C_to_Xen_gint(ref_height)));
}

static Xen gxg_gtk_window_resize(Xen window, Xen width, Xen height)
{
  #define H_gtk_window_resize "void gtk_window_resize(GtkWindow* window, gint width, gint height)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_resize", "GtkWindow*");
  Xen_check_type(Xen_is_gint(width), width, 2, "gtk_window_resize", "gint");
  Xen_check_type(Xen_is_gint(height), height, 3, "gtk_window_resize", "gint");
  gtk_window_resize(Xen_to_C_GtkWindow_(window), Xen_to_C_gint(width), Xen_to_C_gint(height));
  return(Xen_false);
}

static Xen gxg_gtk_window_get_size(Xen window, Xen ignore_width, Xen ignore_height)
{
  #define H_gtk_window_get_size "void gtk_window_get_size(GtkWindow* window, gint* [width], gint* [height])"
  gint ref_width;
  gint ref_height;
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_get_size", "GtkWindow*");
  gtk_window_get_size(Xen_to_C_GtkWindow_(window), &ref_width, &ref_height);
  return(Xen_list_2(C_to_Xen_gint(ref_width), C_to_Xen_gint(ref_height)));
}

static Xen gxg_pango_color_copy(Xen src)
{
  #define H_pango_color_copy "PangoColor* pango_color_copy(PangoColor* src)"
  Xen_check_type(Xen_is_PangoColor_(src), src, 1, "pango_color_copy", "PangoColor*");
  return(C_to_Xen_PangoColor_(pango_color_copy(Xen_to_C_PangoColor_(src))));
}

static Xen gxg_pango_color_free(Xen color)
{
  #define H_pango_color_free "void pango_color_free(PangoColor* color)"
  Xen_check_type(Xen_is_PangoColor_(color), color, 1, "pango_color_free", "PangoColor*");
  pango_color_free(Xen_to_C_PangoColor_(color));
  return(Xen_false);
}

static Xen gxg_pango_color_parse(Xen color, Xen spec)
{
  #define H_pango_color_parse "gboolean pango_color_parse(PangoColor* color, char* spec)"
  Xen_check_type(Xen_is_PangoColor_(color), color, 1, "pango_color_parse", "PangoColor*");
  Xen_check_type(Xen_is_char_(spec), spec, 2, "pango_color_parse", "char*");
  return(C_to_Xen_gboolean(pango_color_parse(Xen_to_C_PangoColor_(color), Xen_to_C_char_(spec))));
}

static Xen gxg_pango_attr_type_register(Xen name)
{
  #define H_pango_attr_type_register "PangoAttrType pango_attr_type_register(gchar* name)"
  Xen_check_type(Xen_is_gchar_(name), name, 1, "pango_attr_type_register", "gchar*");
  return(C_to_Xen_PangoAttrType(pango_attr_type_register(Xen_to_C_gchar_(name))));
}

static Xen gxg_pango_attribute_copy(Xen attr)
{
  #define H_pango_attribute_copy "PangoAttribute* pango_attribute_copy(PangoAttribute* attr)"
  Xen_check_type(Xen_is_PangoAttribute_(attr), attr, 1, "pango_attribute_copy", "PangoAttribute*");
  return(C_to_Xen_PangoAttribute_(pango_attribute_copy(Xen_to_C_PangoAttribute_(attr))));
}

static Xen gxg_pango_attribute_destroy(Xen attr)
{
  #define H_pango_attribute_destroy "void pango_attribute_destroy(PangoAttribute* attr)"
  Xen_check_type(Xen_is_PangoAttribute_(attr), attr, 1, "pango_attribute_destroy", "PangoAttribute*");
  pango_attribute_destroy(Xen_to_C_PangoAttribute_(attr));
  return(Xen_false);
}

static Xen gxg_pango_attribute_equal(Xen attr1, Xen attr2)
{
  #define H_pango_attribute_equal "gboolean pango_attribute_equal(PangoAttribute* attr1, PangoAttribute* attr2)"
  Xen_check_type(Xen_is_PangoAttribute_(attr1), attr1, 1, "pango_attribute_equal", "PangoAttribute*");
  Xen_check_type(Xen_is_PangoAttribute_(attr2), attr2, 2, "pango_attribute_equal", "PangoAttribute*");
  return(C_to_Xen_gboolean(pango_attribute_equal(Xen_to_C_PangoAttribute_(attr1), Xen_to_C_PangoAttribute_(attr2))));
}

static Xen gxg_pango_attr_language_new(Xen language)
{
  #define H_pango_attr_language_new "PangoAttribute* pango_attr_language_new(PangoLanguage* language)"
  Xen_check_type(Xen_is_PangoLanguage_(language), language, 1, "pango_attr_language_new", "PangoLanguage*");
  return(C_to_Xen_PangoAttribute_(pango_attr_language_new(Xen_to_C_PangoLanguage_(language))));
}

static Xen gxg_pango_attr_family_new(Xen family)
{
  #define H_pango_attr_family_new "PangoAttribute* pango_attr_family_new(char* family)"
  Xen_check_type(Xen_is_char_(family), family, 1, "pango_attr_family_new", "char*");
  return(C_to_Xen_PangoAttribute_(pango_attr_family_new(Xen_to_C_char_(family))));
}

static Xen gxg_pango_attr_foreground_new(Xen red, Xen green, Xen blue)
{
  #define H_pango_attr_foreground_new "PangoAttribute* pango_attr_foreground_new(guint16 red, guint16 green, \
guint16 blue)"
  Xen_check_type(Xen_is_guint16(red), red, 1, "pango_attr_foreground_new", "guint16");
  Xen_check_type(Xen_is_guint16(green), green, 2, "pango_attr_foreground_new", "guint16");
  Xen_check_type(Xen_is_guint16(blue), blue, 3, "pango_attr_foreground_new", "guint16");
  return(C_to_Xen_PangoAttribute_(pango_attr_foreground_new(Xen_to_C_guint16(red), Xen_to_C_guint16(green), Xen_to_C_guint16(blue))));
}

static Xen gxg_pango_attr_background_new(Xen red, Xen green, Xen blue)
{
  #define H_pango_attr_background_new "PangoAttribute* pango_attr_background_new(guint16 red, guint16 green, \
guint16 blue)"
  Xen_check_type(Xen_is_guint16(red), red, 1, "pango_attr_background_new", "guint16");
  Xen_check_type(Xen_is_guint16(green), green, 2, "pango_attr_background_new", "guint16");
  Xen_check_type(Xen_is_guint16(blue), blue, 3, "pango_attr_background_new", "guint16");
  return(C_to_Xen_PangoAttribute_(pango_attr_background_new(Xen_to_C_guint16(red), Xen_to_C_guint16(green), Xen_to_C_guint16(blue))));
}

static Xen gxg_pango_attr_size_new(Xen size)
{
  #define H_pango_attr_size_new "PangoAttribute* pango_attr_size_new(int size)"
  Xen_check_type(Xen_is_int(size), size, 1, "pango_attr_size_new", "int");
  return(C_to_Xen_PangoAttribute_(pango_attr_size_new(Xen_to_C_int(size))));
}

static Xen gxg_pango_attr_style_new(Xen style)
{
  #define H_pango_attr_style_new "PangoAttribute* pango_attr_style_new(PangoStyle style)"
  Xen_check_type(Xen_is_PangoStyle(style), style, 1, "pango_attr_style_new", "PangoStyle");
  return(C_to_Xen_PangoAttribute_(pango_attr_style_new(Xen_to_C_PangoStyle(style))));
}

static Xen gxg_pango_attr_weight_new(Xen weight)
{
  #define H_pango_attr_weight_new "PangoAttribute* pango_attr_weight_new(PangoWeight weight)"
  Xen_check_type(Xen_is_PangoWeight(weight), weight, 1, "pango_attr_weight_new", "PangoWeight");
  return(C_to_Xen_PangoAttribute_(pango_attr_weight_new(Xen_to_C_PangoWeight(weight))));
}

static Xen gxg_pango_attr_variant_new(Xen variant)
{
  #define H_pango_attr_variant_new "PangoAttribute* pango_attr_variant_new(PangoVariant variant)"
  Xen_check_type(Xen_is_PangoVariant(variant), variant, 1, "pango_attr_variant_new", "PangoVariant");
  return(C_to_Xen_PangoAttribute_(pango_attr_variant_new(Xen_to_C_PangoVariant(variant))));
}

static Xen gxg_pango_attr_stretch_new(Xen stretch)
{
  #define H_pango_attr_stretch_new "PangoAttribute* pango_attr_stretch_new(PangoStretch stretch)"
  Xen_check_type(Xen_is_PangoStretch(stretch), stretch, 1, "pango_attr_stretch_new", "PangoStretch");
  return(C_to_Xen_PangoAttribute_(pango_attr_stretch_new(Xen_to_C_PangoStretch(stretch))));
}

static Xen gxg_pango_attr_font_desc_new(Xen desc)
{
  #define H_pango_attr_font_desc_new "PangoAttribute* pango_attr_font_desc_new(PangoFontDescription* desc)"
  Xen_check_type(Xen_is_PangoFontDescription_(desc), desc, 1, "pango_attr_font_desc_new", "PangoFontDescription*");
  return(C_to_Xen_PangoAttribute_(pango_attr_font_desc_new(Xen_to_C_PangoFontDescription_(desc))));
}

static Xen gxg_pango_attr_underline_new(Xen underline)
{
  #define H_pango_attr_underline_new "PangoAttribute* pango_attr_underline_new(PangoUnderline underline)"
  Xen_check_type(Xen_is_PangoUnderline(underline), underline, 1, "pango_attr_underline_new", "PangoUnderline");
  return(C_to_Xen_PangoAttribute_(pango_attr_underline_new(Xen_to_C_PangoUnderline(underline))));
}

static Xen gxg_pango_attr_strikethrough_new(Xen strikethrough)
{
  #define H_pango_attr_strikethrough_new "PangoAttribute* pango_attr_strikethrough_new(gboolean strikethrough)"
  Xen_check_type(Xen_is_gboolean(strikethrough), strikethrough, 1, "pango_attr_strikethrough_new", "gboolean");
  return(C_to_Xen_PangoAttribute_(pango_attr_strikethrough_new(Xen_to_C_gboolean(strikethrough))));
}

static Xen gxg_pango_attr_rise_new(Xen rise)
{
  #define H_pango_attr_rise_new "PangoAttribute* pango_attr_rise_new(int rise)"
  Xen_check_type(Xen_is_int(rise), rise, 1, "pango_attr_rise_new", "int");
  return(C_to_Xen_PangoAttribute_(pango_attr_rise_new(Xen_to_C_int(rise))));
}

static Xen gxg_pango_attr_shape_new(Xen ink_rect, Xen logical_rect)
{
  #define H_pango_attr_shape_new "PangoAttribute* pango_attr_shape_new(PangoRectangle* ink_rect, PangoRectangle* logical_rect)"
  Xen_check_type(Xen_is_PangoRectangle_(ink_rect), ink_rect, 1, "pango_attr_shape_new", "PangoRectangle*");
  Xen_check_type(Xen_is_PangoRectangle_(logical_rect), logical_rect, 2, "pango_attr_shape_new", "PangoRectangle*");
  return(C_to_Xen_PangoAttribute_(pango_attr_shape_new(Xen_to_C_PangoRectangle_(ink_rect), Xen_to_C_PangoRectangle_(logical_rect))));
}

static Xen gxg_pango_attr_scale_new(Xen scale_factor)
{
  #define H_pango_attr_scale_new "PangoAttribute* pango_attr_scale_new(double scale_factor)"
  Xen_check_type(Xen_is_double(scale_factor), scale_factor, 1, "pango_attr_scale_new", "double");
  return(C_to_Xen_PangoAttribute_(pango_attr_scale_new(Xen_to_C_double(scale_factor))));
}

static Xen gxg_pango_attr_list_new(void)
{
  #define H_pango_attr_list_new "PangoAttrList* pango_attr_list_new( void)"
  return(C_to_Xen_PangoAttrList_(pango_attr_list_new()));
}

static Xen gxg_pango_attr_list_unref(Xen list)
{
  #define H_pango_attr_list_unref "void pango_attr_list_unref(PangoAttrList* list)"
  Xen_check_type(Xen_is_PangoAttrList_(list), list, 1, "pango_attr_list_unref", "PangoAttrList*");
  pango_attr_list_unref(Xen_to_C_PangoAttrList_(list));
  return(Xen_false);
}

static Xen gxg_pango_attr_list_copy(Xen list)
{
  #define H_pango_attr_list_copy "PangoAttrList* pango_attr_list_copy(PangoAttrList* list)"
  Xen_check_type(Xen_is_PangoAttrList_(list), list, 1, "pango_attr_list_copy", "PangoAttrList*");
  return(C_to_Xen_PangoAttrList_(pango_attr_list_copy(Xen_to_C_PangoAttrList_(list))));
}

static Xen gxg_pango_attr_list_insert(Xen list, Xen attr)
{
  #define H_pango_attr_list_insert "void pango_attr_list_insert(PangoAttrList* list, PangoAttribute* attr)"
  Xen_check_type(Xen_is_PangoAttrList_(list), list, 1, "pango_attr_list_insert", "PangoAttrList*");
  Xen_check_type(Xen_is_PangoAttribute_(attr), attr, 2, "pango_attr_list_insert", "PangoAttribute*");
  pango_attr_list_insert(Xen_to_C_PangoAttrList_(list), Xen_to_C_PangoAttribute_(attr));
  return(Xen_false);
}

static Xen gxg_pango_attr_list_insert_before(Xen list, Xen attr)
{
  #define H_pango_attr_list_insert_before "void pango_attr_list_insert_before(PangoAttrList* list, PangoAttribute* attr)"
  Xen_check_type(Xen_is_PangoAttrList_(list), list, 1, "pango_attr_list_insert_before", "PangoAttrList*");
  Xen_check_type(Xen_is_PangoAttribute_(attr), attr, 2, "pango_attr_list_insert_before", "PangoAttribute*");
  pango_attr_list_insert_before(Xen_to_C_PangoAttrList_(list), Xen_to_C_PangoAttribute_(attr));
  return(Xen_false);
}

static Xen gxg_pango_attr_list_change(Xen list, Xen attr)
{
  #define H_pango_attr_list_change "void pango_attr_list_change(PangoAttrList* list, PangoAttribute* attr)"
  Xen_check_type(Xen_is_PangoAttrList_(list), list, 1, "pango_attr_list_change", "PangoAttrList*");
  Xen_check_type(Xen_is_PangoAttribute_(attr), attr, 2, "pango_attr_list_change", "PangoAttribute*");
  pango_attr_list_change(Xen_to_C_PangoAttrList_(list), Xen_to_C_PangoAttribute_(attr));
  return(Xen_false);
}

static Xen gxg_pango_attr_list_splice(Xen list, Xen other, Xen pos, Xen len)
{
  #define H_pango_attr_list_splice "void pango_attr_list_splice(PangoAttrList* list, PangoAttrList* other, \
gint pos, gint len)"
  Xen_check_type(Xen_is_PangoAttrList_(list), list, 1, "pango_attr_list_splice", "PangoAttrList*");
  Xen_check_type(Xen_is_PangoAttrList_(other), other, 2, "pango_attr_list_splice", "PangoAttrList*");
  Xen_check_type(Xen_is_gint(pos), pos, 3, "pango_attr_list_splice", "gint");
  Xen_check_type(Xen_is_gint(len), len, 4, "pango_attr_list_splice", "gint");
  pango_attr_list_splice(Xen_to_C_PangoAttrList_(list), Xen_to_C_PangoAttrList_(other), Xen_to_C_gint(pos), Xen_to_C_gint(len));
  return(Xen_false);
}

static Xen gxg_pango_attr_list_get_iterator(Xen list)
{
  #define H_pango_attr_list_get_iterator "PangoAttrIterator* pango_attr_list_get_iterator(PangoAttrList* list)"
  Xen_check_type(Xen_is_PangoAttrList_(list), list, 1, "pango_attr_list_get_iterator", "PangoAttrList*");
  return(C_to_Xen_PangoAttrIterator_(pango_attr_list_get_iterator(Xen_to_C_PangoAttrList_(list))));
}

static Xen gxg_pango_attr_iterator_range(Xen iterator, Xen ignore_start, Xen ignore_end)
{
  #define H_pango_attr_iterator_range "void pango_attr_iterator_range(PangoAttrIterator* iterator, gint* [start], \
gint* [end])"
  gint ref_start;
  gint ref_end;
  Xen_check_type(Xen_is_PangoAttrIterator_(iterator), iterator, 1, "pango_attr_iterator_range", "PangoAttrIterator*");
  pango_attr_iterator_range(Xen_to_C_PangoAttrIterator_(iterator), &ref_start, &ref_end);
  return(Xen_list_2(C_to_Xen_gint(ref_start), C_to_Xen_gint(ref_end)));
}

static Xen gxg_pango_attr_iterator_next(Xen iterator)
{
  #define H_pango_attr_iterator_next "gboolean pango_attr_iterator_next(PangoAttrIterator* iterator)"
  Xen_check_type(Xen_is_PangoAttrIterator_(iterator), iterator, 1, "pango_attr_iterator_next", "PangoAttrIterator*");
  return(C_to_Xen_gboolean(pango_attr_iterator_next(Xen_to_C_PangoAttrIterator_(iterator))));
}

static Xen gxg_pango_attr_iterator_copy(Xen iterator)
{
  #define H_pango_attr_iterator_copy "PangoAttrIterator* pango_attr_iterator_copy(PangoAttrIterator* iterator)"
  Xen_check_type(Xen_is_PangoAttrIterator_(iterator), iterator, 1, "pango_attr_iterator_copy", "PangoAttrIterator*");
  return(C_to_Xen_PangoAttrIterator_(pango_attr_iterator_copy(Xen_to_C_PangoAttrIterator_(iterator))));
}

static Xen gxg_pango_attr_iterator_destroy(Xen iterator)
{
  #define H_pango_attr_iterator_destroy "void pango_attr_iterator_destroy(PangoAttrIterator* iterator)"
  Xen_check_type(Xen_is_PangoAttrIterator_(iterator), iterator, 1, "pango_attr_iterator_destroy", "PangoAttrIterator*");
  pango_attr_iterator_destroy(Xen_to_C_PangoAttrIterator_(iterator));
  return(Xen_false);
}

static Xen gxg_pango_attr_iterator_get(Xen iterator, Xen type)
{
  #define H_pango_attr_iterator_get "PangoAttribute* pango_attr_iterator_get(PangoAttrIterator* iterator, \
PangoAttrType type)"
  Xen_check_type(Xen_is_PangoAttrIterator_(iterator), iterator, 1, "pango_attr_iterator_get", "PangoAttrIterator*");
  Xen_check_type(Xen_is_PangoAttrType(type), type, 2, "pango_attr_iterator_get", "PangoAttrType");
  return(C_to_Xen_PangoAttribute_(pango_attr_iterator_get(Xen_to_C_PangoAttrIterator_(iterator), Xen_to_C_PangoAttrType(type))));
}

static Xen gxg_pango_attr_iterator_get_font(Xen iterator, Xen desc, Xen ignore_language, Xen ignore_extra_attrs)
{
  #define H_pango_attr_iterator_get_font "void pango_attr_iterator_get_font(PangoAttrIterator* iterator, \
PangoFontDescription* desc, PangoLanguage** [language], GSList** [extra_attrs])"
  PangoLanguage* ref_language = NULL;
  GSList* ref_extra_attrs = NULL;
  Xen_check_type(Xen_is_PangoAttrIterator_(iterator), iterator, 1, "pango_attr_iterator_get_font", "PangoAttrIterator*");
  Xen_check_type(Xen_is_PangoFontDescription_(desc), desc, 2, "pango_attr_iterator_get_font", "PangoFontDescription*");
  pango_attr_iterator_get_font(Xen_to_C_PangoAttrIterator_(iterator), Xen_to_C_PangoFontDescription_(desc), &ref_language, 
                               &ref_extra_attrs);
  return(Xen_list_2(C_to_Xen_PangoLanguage_(ref_language), C_to_Xen_GSList_(ref_extra_attrs)));
}

static Xen gxg_pango_parse_markup(Xen markup_text, Xen length, Xen accel_marker, Xen attr_list, Xen text, Xen accel_char, Xen ignore_error)
{
  #define H_pango_parse_markup "gboolean pango_parse_markup(char* markup_text, int length, gunichar accel_marker, \
PangoAttrList** attr_list, char** text, gunichar* accel_char, GError** [error])"
  GError* ref_error = NULL;
  Xen_check_type(Xen_is_char_(markup_text), markup_text, 1, "pango_parse_markup", "char*");
  Xen_check_type(Xen_is_int(length), length, 2, "pango_parse_markup", "int");
  Xen_check_type(Xen_is_gunichar(accel_marker), accel_marker, 3, "pango_parse_markup", "gunichar");
  Xen_check_type(Xen_is_PangoAttrList__(attr_list), attr_list, 4, "pango_parse_markup", "PangoAttrList**");
  Xen_check_type(Xen_is_char__(text), text, 5, "pango_parse_markup", "char**");
  Xen_check_type(Xen_is_gunichar_(accel_char), accel_char, 6, "pango_parse_markup", "gunichar*");
  {
    Xen res_ult;
    res_ult = C_to_Xen_gboolean(pango_parse_markup(Xen_to_C_char_(markup_text), Xen_to_C_int(length), Xen_to_C_gunichar(accel_marker), 
                                                   Xen_to_C_PangoAttrList__(attr_list), Xen_to_C_char__(text), Xen_to_C_gunichar_(accel_char), 
                                                   &ref_error));
    return(Xen_list_2(res_ult, C_to_Xen_GError_(ref_error)));
   }
}

static Xen gxg_pango_find_paragraph_boundary(Xen text, Xen length, Xen ignore_paragraph_delimiter_index, Xen ignore_next_paragraph_start)
{
  #define H_pango_find_paragraph_boundary "void pango_find_paragraph_boundary(gchar* text, gint length, \
gint* [paragraph_delimiter_index], gint* [next_paragraph_start])"
  gint ref_paragraph_delimiter_index;
  gint ref_next_paragraph_start;
  Xen_check_type(Xen_is_gchar_(text), text, 1, "pango_find_paragraph_boundary", "gchar*");
  Xen_check_type(Xen_is_gint(length), length, 2, "pango_find_paragraph_boundary", "gint");
  pango_find_paragraph_boundary(Xen_to_C_gchar_(text), Xen_to_C_gint(length), &ref_paragraph_delimiter_index, &ref_next_paragraph_start);
  return(Xen_list_2(C_to_Xen_gint(ref_paragraph_delimiter_index), C_to_Xen_gint(ref_next_paragraph_start)));
}

static Xen gxg_pango_get_log_attrs(Xen text, Xen length, Xen level, Xen language, Xen log_attrs, Xen attrs_len)
{
  #define H_pango_get_log_attrs "void pango_get_log_attrs(char* text, int length, int level, PangoLanguage* language, \
PangoLogAttr* log_attrs, int attrs_len)"
  Xen_check_type(Xen_is_char_(text), text, 1, "pango_get_log_attrs", "char*");
  Xen_check_type(Xen_is_int(length), length, 2, "pango_get_log_attrs", "int");
  Xen_check_type(Xen_is_int(level), level, 3, "pango_get_log_attrs", "int");
  Xen_check_type(Xen_is_PangoLanguage_(language), language, 4, "pango_get_log_attrs", "PangoLanguage*");
  Xen_check_type(Xen_is_PangoLogAttr_(log_attrs), log_attrs, 5, "pango_get_log_attrs", "PangoLogAttr*");
  Xen_check_type(Xen_is_int(attrs_len), attrs_len, 6, "pango_get_log_attrs", "int");
  pango_get_log_attrs(Xen_to_C_char_(text), Xen_to_C_int(length), Xen_to_C_int(level), Xen_to_C_PangoLanguage_(language), 
                      Xen_to_C_PangoLogAttr_(log_attrs), Xen_to_C_int(attrs_len));
  return(Xen_false);
}

static Xen gxg_pango_context_list_families(Xen context, Xen ignore_families, Xen ignore_n_families)
{
  #define H_pango_context_list_families "void pango_context_list_families(PangoContext* context, PangoFontFamily*** [families], \
int* [n_families])"
  PangoFontFamily** ref_families = NULL;
  int ref_n_families;
  Xen_check_type(Xen_is_PangoContext_(context), context, 1, "pango_context_list_families", "PangoContext*");
  pango_context_list_families(Xen_to_C_PangoContext_(context), &ref_families, &ref_n_families);
  return(Xen_list_2(C_to_Xen_PangoFontFamily__(ref_families), C_to_Xen_int(ref_n_families)));
}

static Xen gxg_pango_context_load_font(Xen context, Xen desc)
{
  #define H_pango_context_load_font "PangoFont* pango_context_load_font(PangoContext* context, PangoFontDescription* desc)"
  Xen_check_type(Xen_is_PangoContext_(context), context, 1, "pango_context_load_font", "PangoContext*");
  Xen_check_type(Xen_is_PangoFontDescription_(desc), desc, 2, "pango_context_load_font", "PangoFontDescription*");
  return(C_to_Xen_PangoFont_(pango_context_load_font(Xen_to_C_PangoContext_(context), Xen_to_C_PangoFontDescription_(desc))));
}

static Xen gxg_pango_context_load_fontset(Xen context, Xen desc, Xen language)
{
  #define H_pango_context_load_fontset "PangoFontset* pango_context_load_fontset(PangoContext* context, \
PangoFontDescription* desc, PangoLanguage* language)"
  Xen_check_type(Xen_is_PangoContext_(context), context, 1, "pango_context_load_fontset", "PangoContext*");
  Xen_check_type(Xen_is_PangoFontDescription_(desc), desc, 2, "pango_context_load_fontset", "PangoFontDescription*");
  Xen_check_type(Xen_is_PangoLanguage_(language), language, 3, "pango_context_load_fontset", "PangoLanguage*");
  return(C_to_Xen_PangoFontset_(pango_context_load_fontset(Xen_to_C_PangoContext_(context), Xen_to_C_PangoFontDescription_(desc), 
                                                           Xen_to_C_PangoLanguage_(language))));
}

static Xen gxg_pango_context_get_metrics(Xen context, Xen desc, Xen language)
{
  #define H_pango_context_get_metrics "PangoFontMetrics* pango_context_get_metrics(PangoContext* context, \
PangoFontDescription* desc, PangoLanguage* language)"
  Xen_check_type(Xen_is_PangoContext_(context), context, 1, "pango_context_get_metrics", "PangoContext*");
  Xen_check_type(Xen_is_PangoFontDescription_(desc), desc, 2, "pango_context_get_metrics", "PangoFontDescription*");
  Xen_check_type(Xen_is_PangoLanguage_(language), language, 3, "pango_context_get_metrics", "PangoLanguage*");
  return(C_to_Xen_PangoFontMetrics_(pango_context_get_metrics(Xen_to_C_PangoContext_(context), Xen_to_C_PangoFontDescription_(desc), 
                                                              Xen_to_C_PangoLanguage_(language))));
}

static Xen gxg_pango_context_set_font_description(Xen context, Xen desc)
{
  #define H_pango_context_set_font_description "void pango_context_set_font_description(PangoContext* context, \
PangoFontDescription* desc)"
  Xen_check_type(Xen_is_PangoContext_(context), context, 1, "pango_context_set_font_description", "PangoContext*");
  Xen_check_type(Xen_is_PangoFontDescription_(desc), desc, 2, "pango_context_set_font_description", "PangoFontDescription*");
  pango_context_set_font_description(Xen_to_C_PangoContext_(context), Xen_to_C_PangoFontDescription_(desc));
  return(Xen_false);
}

static Xen gxg_pango_context_get_font_description(Xen context)
{
  #define H_pango_context_get_font_description "PangoFontDescription* pango_context_get_font_description(PangoContext* context)"
  Xen_check_type(Xen_is_PangoContext_(context), context, 1, "pango_context_get_font_description", "PangoContext*");
  return(C_to_Xen_PangoFontDescription_(pango_context_get_font_description(Xen_to_C_PangoContext_(context))));
}

static Xen gxg_pango_context_get_language(Xen context)
{
  #define H_pango_context_get_language "PangoLanguage* pango_context_get_language(PangoContext* context)"
  Xen_check_type(Xen_is_PangoContext_(context), context, 1, "pango_context_get_language", "PangoContext*");
  return(C_to_Xen_PangoLanguage_(pango_context_get_language(Xen_to_C_PangoContext_(context))));
}

static Xen gxg_pango_context_set_language(Xen context, Xen language)
{
  #define H_pango_context_set_language "void pango_context_set_language(PangoContext* context, PangoLanguage* language)"
  Xen_check_type(Xen_is_PangoContext_(context), context, 1, "pango_context_set_language", "PangoContext*");
  Xen_check_type(Xen_is_PangoLanguage_(language), language, 2, "pango_context_set_language", "PangoLanguage*");
  pango_context_set_language(Xen_to_C_PangoContext_(context), Xen_to_C_PangoLanguage_(language));
  return(Xen_false);
}

static Xen gxg_pango_context_set_base_dir(Xen context, Xen direction)
{
  #define H_pango_context_set_base_dir "void pango_context_set_base_dir(PangoContext* context, PangoDirection direction)"
  Xen_check_type(Xen_is_PangoContext_(context), context, 1, "pango_context_set_base_dir", "PangoContext*");
  Xen_check_type(Xen_is_PangoDirection(direction), direction, 2, "pango_context_set_base_dir", "PangoDirection");
  pango_context_set_base_dir(Xen_to_C_PangoContext_(context), Xen_to_C_PangoDirection(direction));
  return(Xen_false);
}

static Xen gxg_pango_context_get_base_dir(Xen context)
{
  #define H_pango_context_get_base_dir "PangoDirection pango_context_get_base_dir(PangoContext* context)"
  Xen_check_type(Xen_is_PangoContext_(context), context, 1, "pango_context_get_base_dir", "PangoContext*");
  return(C_to_Xen_PangoDirection(pango_context_get_base_dir(Xen_to_C_PangoContext_(context))));
}

static Xen gxg_pango_itemize(Xen context, Xen text, Xen start_index, Xen length, Xen attrs, Xen cached_iter)
{
  #define H_pango_itemize "GList* pango_itemize(PangoContext* context, char* text, int start_index, int length, \
PangoAttrList* attrs, PangoAttrIterator* cached_iter)"
  Xen_check_type(Xen_is_PangoContext_(context), context, 1, "pango_itemize", "PangoContext*");
  Xen_check_type(Xen_is_char_(text), text, 2, "pango_itemize", "char*");
  Xen_check_type(Xen_is_int(start_index), start_index, 3, "pango_itemize", "int");
  Xen_check_type(Xen_is_int(length), length, 4, "pango_itemize", "int");
  Xen_check_type(Xen_is_PangoAttrList_(attrs), attrs, 5, "pango_itemize", "PangoAttrList*");
  Xen_check_type(Xen_is_PangoAttrIterator_(cached_iter), cached_iter, 6, "pango_itemize", "PangoAttrIterator*");
  return(C_to_Xen_GList_(pango_itemize(Xen_to_C_PangoContext_(context), Xen_to_C_char_(text), Xen_to_C_int(start_index), 
                                       Xen_to_C_int(length), Xen_to_C_PangoAttrList_(attrs), Xen_to_C_PangoAttrIterator_(cached_iter))));
}

static Xen gxg_pango_coverage_new(void)
{
  #define H_pango_coverage_new "PangoCoverage* pango_coverage_new( void)"
  return(C_to_Xen_PangoCoverage_(pango_coverage_new()));
}

static Xen gxg_pango_coverage_ref(Xen coverage)
{
  #define H_pango_coverage_ref "PangoCoverage* pango_coverage_ref(PangoCoverage* coverage)"
  Xen_check_type(Xen_is_PangoCoverage_(coverage), coverage, 1, "pango_coverage_ref", "PangoCoverage*");
  return(C_to_Xen_PangoCoverage_(pango_coverage_ref(Xen_to_C_PangoCoverage_(coverage))));
}

static Xen gxg_pango_coverage_unref(Xen coverage)
{
  #define H_pango_coverage_unref "void pango_coverage_unref(PangoCoverage* coverage)"
  Xen_check_type(Xen_is_PangoCoverage_(coverage), coverage, 1, "pango_coverage_unref", "PangoCoverage*");
  pango_coverage_unref(Xen_to_C_PangoCoverage_(coverage));
  return(Xen_false);
}

static Xen gxg_pango_coverage_copy(Xen coverage)
{
  #define H_pango_coverage_copy "PangoCoverage* pango_coverage_copy(PangoCoverage* coverage)"
  Xen_check_type(Xen_is_PangoCoverage_(coverage), coverage, 1, "pango_coverage_copy", "PangoCoverage*");
  return(C_to_Xen_PangoCoverage_(pango_coverage_copy(Xen_to_C_PangoCoverage_(coverage))));
}

static Xen gxg_pango_coverage_get(Xen coverage, Xen index)
{
  #define H_pango_coverage_get "PangoCoverageLevel pango_coverage_get(PangoCoverage* coverage, int index)"
  Xen_check_type(Xen_is_PangoCoverage_(coverage), coverage, 1, "pango_coverage_get", "PangoCoverage*");
  Xen_check_type(Xen_is_int(index), index, 2, "pango_coverage_get", "int");
  return(C_to_Xen_PangoCoverageLevel(pango_coverage_get(Xen_to_C_PangoCoverage_(coverage), Xen_to_C_int(index))));
}

static Xen gxg_pango_coverage_set(Xen coverage, Xen index, Xen level)
{
  #define H_pango_coverage_set "void pango_coverage_set(PangoCoverage* coverage, int index, PangoCoverageLevel level)"
  Xen_check_type(Xen_is_PangoCoverage_(coverage), coverage, 1, "pango_coverage_set", "PangoCoverage*");
  Xen_check_type(Xen_is_int(index), index, 2, "pango_coverage_set", "int");
  Xen_check_type(Xen_is_PangoCoverageLevel(level), level, 3, "pango_coverage_set", "PangoCoverageLevel");
  pango_coverage_set(Xen_to_C_PangoCoverage_(coverage), Xen_to_C_int(index), Xen_to_C_PangoCoverageLevel(level));
  return(Xen_false);
}

static Xen gxg_pango_font_description_new(void)
{
  #define H_pango_font_description_new "PangoFontDescription* pango_font_description_new( void)"
  return(C_to_Xen_PangoFontDescription_(pango_font_description_new()));
}

static Xen gxg_pango_font_description_copy(Xen desc)
{
  #define H_pango_font_description_copy "PangoFontDescription* pango_font_description_copy(PangoFontDescription* desc)"
  Xen_check_type(Xen_is_PangoFontDescription_(desc), desc, 1, "pango_font_description_copy", "PangoFontDescription*");
  return(C_to_Xen_PangoFontDescription_(pango_font_description_copy(Xen_to_C_PangoFontDescription_(desc))));
}

static Xen gxg_pango_font_description_copy_static(Xen desc)
{
  #define H_pango_font_description_copy_static "PangoFontDescription* pango_font_description_copy_static(PangoFontDescription* desc)"
  Xen_check_type(Xen_is_PangoFontDescription_(desc), desc, 1, "pango_font_description_copy_static", "PangoFontDescription*");
  return(C_to_Xen_PangoFontDescription_(pango_font_description_copy_static(Xen_to_C_PangoFontDescription_(desc))));
}

static Xen gxg_pango_font_description_hash(Xen desc)
{
  #define H_pango_font_description_hash "guint pango_font_description_hash(PangoFontDescription* desc)"
  Xen_check_type(Xen_is_PangoFontDescription_(desc), desc, 1, "pango_font_description_hash", "PangoFontDescription*");
  return(C_to_Xen_guint(pango_font_description_hash(Xen_to_C_PangoFontDescription_(desc))));
}

static Xen gxg_pango_font_description_equal(Xen desc1, Xen desc2)
{
  #define H_pango_font_description_equal "gboolean pango_font_description_equal(PangoFontDescription* desc1, \
PangoFontDescription* desc2)"
  Xen_check_type(Xen_is_PangoFontDescription_(desc1), desc1, 1, "pango_font_description_equal", "PangoFontDescription*");
  Xen_check_type(Xen_is_PangoFontDescription_(desc2), desc2, 2, "pango_font_description_equal", "PangoFontDescription*");
  return(C_to_Xen_gboolean(pango_font_description_equal(Xen_to_C_PangoFontDescription_(desc1), Xen_to_C_PangoFontDescription_(desc2))));
}

static Xen gxg_pango_font_description_free(Xen desc)
{
  #define H_pango_font_description_free "void pango_font_description_free(PangoFontDescription* desc)"
  Xen_check_type(Xen_is_PangoFontDescription_(desc), desc, 1, "pango_font_description_free", "PangoFontDescription*");
  pango_font_description_free(Xen_to_C_PangoFontDescription_(desc));
  return(Xen_false);
}

static Xen gxg_pango_font_descriptions_free(Xen descs, Xen n_descs)
{
  #define H_pango_font_descriptions_free "void pango_font_descriptions_free(PangoFontDescription** descs, \
int n_descs)"
  Xen_check_type(Xen_is_PangoFontDescription__(descs), descs, 1, "pango_font_descriptions_free", "PangoFontDescription**");
  Xen_check_type(Xen_is_int(n_descs), n_descs, 2, "pango_font_descriptions_free", "int");
  pango_font_descriptions_free(Xen_to_C_PangoFontDescription__(descs), Xen_to_C_int(n_descs));
  return(Xen_false);
}

static Xen gxg_pango_font_description_set_family(Xen desc, Xen family)
{
  #define H_pango_font_description_set_family "void pango_font_description_set_family(PangoFontDescription* desc, \
char* family)"
  Xen_check_type(Xen_is_PangoFontDescription_(desc), desc, 1, "pango_font_description_set_family", "PangoFontDescription*");
  Xen_check_type(Xen_is_char_(family), family, 2, "pango_font_description_set_family", "char*");
  pango_font_description_set_family(Xen_to_C_PangoFontDescription_(desc), Xen_to_C_char_(family));
  return(Xen_false);
}

static Xen gxg_pango_font_description_set_family_static(Xen desc, Xen family)
{
  #define H_pango_font_description_set_family_static "void pango_font_description_set_family_static(PangoFontDescription* desc, \
char* family)"
  Xen_check_type(Xen_is_PangoFontDescription_(desc), desc, 1, "pango_font_description_set_family_static", "PangoFontDescription*");
  Xen_check_type(Xen_is_char_(family), family, 2, "pango_font_description_set_family_static", "char*");
  pango_font_description_set_family_static(Xen_to_C_PangoFontDescription_(desc), Xen_to_C_char_(family));
  return(Xen_false);
}

static Xen gxg_pango_font_description_get_family(Xen desc)
{
  #define H_pango_font_description_get_family "char* pango_font_description_get_family(PangoFontDescription* desc)"
  Xen_check_type(Xen_is_PangoFontDescription_(desc), desc, 1, "pango_font_description_get_family", "PangoFontDescription*");
  return(C_to_Xen_char_(pango_font_description_get_family(Xen_to_C_PangoFontDescription_(desc))));
}

static Xen gxg_pango_font_description_set_style(Xen desc, Xen style)
{
  #define H_pango_font_description_set_style "void pango_font_description_set_style(PangoFontDescription* desc, \
PangoStyle style)"
  Xen_check_type(Xen_is_PangoFontDescription_(desc), desc, 1, "pango_font_description_set_style", "PangoFontDescription*");
  Xen_check_type(Xen_is_PangoStyle(style), style, 2, "pango_font_description_set_style", "PangoStyle");
  pango_font_description_set_style(Xen_to_C_PangoFontDescription_(desc), Xen_to_C_PangoStyle(style));
  return(Xen_false);
}

static Xen gxg_pango_font_description_get_style(Xen desc)
{
  #define H_pango_font_description_get_style "PangoStyle pango_font_description_get_style(PangoFontDescription* desc)"
  Xen_check_type(Xen_is_PangoFontDescription_(desc), desc, 1, "pango_font_description_get_style", "PangoFontDescription*");
  return(C_to_Xen_PangoStyle(pango_font_description_get_style(Xen_to_C_PangoFontDescription_(desc))));
}

static Xen gxg_pango_font_description_set_variant(Xen desc, Xen variant)
{
  #define H_pango_font_description_set_variant "void pango_font_description_set_variant(PangoFontDescription* desc, \
PangoVariant variant)"
  Xen_check_type(Xen_is_PangoFontDescription_(desc), desc, 1, "pango_font_description_set_variant", "PangoFontDescription*");
  Xen_check_type(Xen_is_PangoVariant(variant), variant, 2, "pango_font_description_set_variant", "PangoVariant");
  pango_font_description_set_variant(Xen_to_C_PangoFontDescription_(desc), Xen_to_C_PangoVariant(variant));
  return(Xen_false);
}

static Xen gxg_pango_font_description_get_variant(Xen desc)
{
  #define H_pango_font_description_get_variant "PangoVariant pango_font_description_get_variant(PangoFontDescription* desc)"
  Xen_check_type(Xen_is_PangoFontDescription_(desc), desc, 1, "pango_font_description_get_variant", "PangoFontDescription*");
  return(C_to_Xen_PangoVariant(pango_font_description_get_variant(Xen_to_C_PangoFontDescription_(desc))));
}

static Xen gxg_pango_font_description_set_weight(Xen desc, Xen weight)
{
  #define H_pango_font_description_set_weight "void pango_font_description_set_weight(PangoFontDescription* desc, \
PangoWeight weight)"
  Xen_check_type(Xen_is_PangoFontDescription_(desc), desc, 1, "pango_font_description_set_weight", "PangoFontDescription*");
  Xen_check_type(Xen_is_PangoWeight(weight), weight, 2, "pango_font_description_set_weight", "PangoWeight");
  pango_font_description_set_weight(Xen_to_C_PangoFontDescription_(desc), Xen_to_C_PangoWeight(weight));
  return(Xen_false);
}

static Xen gxg_pango_font_description_get_weight(Xen desc)
{
  #define H_pango_font_description_get_weight "PangoWeight pango_font_description_get_weight(PangoFontDescription* desc)"
  Xen_check_type(Xen_is_PangoFontDescription_(desc), desc, 1, "pango_font_description_get_weight", "PangoFontDescription*");
  return(C_to_Xen_PangoWeight(pango_font_description_get_weight(Xen_to_C_PangoFontDescription_(desc))));
}

static Xen gxg_pango_font_description_set_stretch(Xen desc, Xen stretch)
{
  #define H_pango_font_description_set_stretch "void pango_font_description_set_stretch(PangoFontDescription* desc, \
PangoStretch stretch)"
  Xen_check_type(Xen_is_PangoFontDescription_(desc), desc, 1, "pango_font_description_set_stretch", "PangoFontDescription*");
  Xen_check_type(Xen_is_PangoStretch(stretch), stretch, 2, "pango_font_description_set_stretch", "PangoStretch");
  pango_font_description_set_stretch(Xen_to_C_PangoFontDescription_(desc), Xen_to_C_PangoStretch(stretch));
  return(Xen_false);
}

static Xen gxg_pango_font_description_get_stretch(Xen desc)
{
  #define H_pango_font_description_get_stretch "PangoStretch pango_font_description_get_stretch(PangoFontDescription* desc)"
  Xen_check_type(Xen_is_PangoFontDescription_(desc), desc, 1, "pango_font_description_get_stretch", "PangoFontDescription*");
  return(C_to_Xen_PangoStretch(pango_font_description_get_stretch(Xen_to_C_PangoFontDescription_(desc))));
}

static Xen gxg_pango_font_description_set_size(Xen desc, Xen size)
{
  #define H_pango_font_description_set_size "void pango_font_description_set_size(PangoFontDescription* desc, \
gint size)"
  Xen_check_type(Xen_is_PangoFontDescription_(desc), desc, 1, "pango_font_description_set_size", "PangoFontDescription*");
  Xen_check_type(Xen_is_gint(size), size, 2, "pango_font_description_set_size", "gint");
  pango_font_description_set_size(Xen_to_C_PangoFontDescription_(desc), Xen_to_C_gint(size));
  return(Xen_false);
}

static Xen gxg_pango_font_description_get_size(Xen desc)
{
  #define H_pango_font_description_get_size "gint pango_font_description_get_size(PangoFontDescription* desc)"
  Xen_check_type(Xen_is_PangoFontDescription_(desc), desc, 1, "pango_font_description_get_size", "PangoFontDescription*");
  return(C_to_Xen_gint(pango_font_description_get_size(Xen_to_C_PangoFontDescription_(desc))));
}

static Xen gxg_pango_font_description_get_set_fields(Xen desc)
{
  #define H_pango_font_description_get_set_fields "PangoFontMask pango_font_description_get_set_fields(PangoFontDescription* desc)"
  Xen_check_type(Xen_is_PangoFontDescription_(desc), desc, 1, "pango_font_description_get_set_fields", "PangoFontDescription*");
  return(C_to_Xen_PangoFontMask(pango_font_description_get_set_fields(Xen_to_C_PangoFontDescription_(desc))));
}

static Xen gxg_pango_font_description_unset_fields(Xen desc, Xen to_unset)
{
  #define H_pango_font_description_unset_fields "void pango_font_description_unset_fields(PangoFontDescription* desc, \
PangoFontMask to_unset)"
  Xen_check_type(Xen_is_PangoFontDescription_(desc), desc, 1, "pango_font_description_unset_fields", "PangoFontDescription*");
  Xen_check_type(Xen_is_PangoFontMask(to_unset), to_unset, 2, "pango_font_description_unset_fields", "PangoFontMask");
  pango_font_description_unset_fields(Xen_to_C_PangoFontDescription_(desc), Xen_to_C_PangoFontMask(to_unset));
  return(Xen_false);
}

static Xen gxg_pango_font_description_merge(Xen desc, Xen desc_to_merge, Xen replace_existing)
{
  #define H_pango_font_description_merge "void pango_font_description_merge(PangoFontDescription* desc, \
PangoFontDescription* desc_to_merge, gboolean replace_existing)"
  Xen_check_type(Xen_is_PangoFontDescription_(desc), desc, 1, "pango_font_description_merge", "PangoFontDescription*");
  Xen_check_type(Xen_is_PangoFontDescription_(desc_to_merge), desc_to_merge, 2, "pango_font_description_merge", "PangoFontDescription*");
  Xen_check_type(Xen_is_gboolean(replace_existing), replace_existing, 3, "pango_font_description_merge", "gboolean");
  pango_font_description_merge(Xen_to_C_PangoFontDescription_(desc), Xen_to_C_PangoFontDescription_(desc_to_merge), Xen_to_C_gboolean(replace_existing));
  return(Xen_false);
}

static Xen gxg_pango_font_description_merge_static(Xen desc, Xen desc_to_merge, Xen replace_existing)
{
  #define H_pango_font_description_merge_static "void pango_font_description_merge_static(PangoFontDescription* desc, \
PangoFontDescription* desc_to_merge, gboolean replace_existing)"
  Xen_check_type(Xen_is_PangoFontDescription_(desc), desc, 1, "pango_font_description_merge_static", "PangoFontDescription*");
  Xen_check_type(Xen_is_PangoFontDescription_(desc_to_merge), desc_to_merge, 2, "pango_font_description_merge_static", "PangoFontDescription*");
  Xen_check_type(Xen_is_gboolean(replace_existing), replace_existing, 3, "pango_font_description_merge_static", "gboolean");
  pango_font_description_merge_static(Xen_to_C_PangoFontDescription_(desc), Xen_to_C_PangoFontDescription_(desc_to_merge), 
                                      Xen_to_C_gboolean(replace_existing));
  return(Xen_false);
}

static Xen gxg_pango_font_description_better_match(Xen desc, Xen old_match, Xen new_match)
{
  #define H_pango_font_description_better_match "gboolean pango_font_description_better_match(PangoFontDescription* desc, \
PangoFontDescription* old_match, PangoFontDescription* new_match)"
  Xen_check_type(Xen_is_PangoFontDescription_(desc), desc, 1, "pango_font_description_better_match", "PangoFontDescription*");
  Xen_check_type(Xen_is_PangoFontDescription_(old_match), old_match, 2, "pango_font_description_better_match", "PangoFontDescription*");
  Xen_check_type(Xen_is_PangoFontDescription_(new_match), new_match, 3, "pango_font_description_better_match", "PangoFontDescription*");
  return(C_to_Xen_gboolean(pango_font_description_better_match(Xen_to_C_PangoFontDescription_(desc), Xen_to_C_PangoFontDescription_(old_match), 
                                                               Xen_to_C_PangoFontDescription_(new_match))));
}

static Xen gxg_pango_font_description_from_string(Xen str)
{
  #define H_pango_font_description_from_string "PangoFontDescription* pango_font_description_from_string(char* str)"
  Xen_check_type(Xen_is_char_(str), str, 1, "pango_font_description_from_string", "char*");
  return(C_to_Xen_PangoFontDescription_(pango_font_description_from_string(Xen_to_C_char_(str))));
}

static Xen gxg_pango_font_description_to_string(Xen desc)
{
  #define H_pango_font_description_to_string "char* pango_font_description_to_string(PangoFontDescription* desc)"
  Xen_check_type(Xen_is_PangoFontDescription_(desc), desc, 1, "pango_font_description_to_string", "PangoFontDescription*");
  {
   char* res_ult;
   Xen rtn;
   res_ult = pango_font_description_to_string(Xen_to_C_PangoFontDescription_(desc));
   rtn = C_to_Xen_char_(res_ult);
   g_free(res_ult);
   return(rtn);
  }
}

static Xen gxg_pango_font_description_to_filename(Xen desc)
{
  #define H_pango_font_description_to_filename "char* pango_font_description_to_filename(PangoFontDescription* desc)"
  Xen_check_type(Xen_is_PangoFontDescription_(desc), desc, 1, "pango_font_description_to_filename", "PangoFontDescription*");
  {
   char* res_ult;
   Xen rtn;
   res_ult = pango_font_description_to_filename(Xen_to_C_PangoFontDescription_(desc));
   rtn = C_to_Xen_char_(res_ult);
   g_free(res_ult);
   return(rtn);
  }
}

static Xen gxg_pango_font_metrics_ref(Xen metrics)
{
  #define H_pango_font_metrics_ref "PangoFontMetrics* pango_font_metrics_ref(PangoFontMetrics* metrics)"
  Xen_check_type(Xen_is_PangoFontMetrics_(metrics), metrics, 1, "pango_font_metrics_ref", "PangoFontMetrics*");
  return(C_to_Xen_PangoFontMetrics_(pango_font_metrics_ref(Xen_to_C_PangoFontMetrics_(metrics))));
}

static Xen gxg_pango_font_metrics_unref(Xen metrics)
{
  #define H_pango_font_metrics_unref "void pango_font_metrics_unref(PangoFontMetrics* metrics)"
  Xen_check_type(Xen_is_PangoFontMetrics_(metrics), metrics, 1, "pango_font_metrics_unref", "PangoFontMetrics*");
  pango_font_metrics_unref(Xen_to_C_PangoFontMetrics_(metrics));
  return(Xen_false);
}

static Xen gxg_pango_font_metrics_get_ascent(Xen metrics)
{
  #define H_pango_font_metrics_get_ascent "int pango_font_metrics_get_ascent(PangoFontMetrics* metrics)"
  Xen_check_type(Xen_is_PangoFontMetrics_(metrics), metrics, 1, "pango_font_metrics_get_ascent", "PangoFontMetrics*");
  return(C_to_Xen_int(pango_font_metrics_get_ascent(Xen_to_C_PangoFontMetrics_(metrics))));
}

static Xen gxg_pango_font_metrics_get_descent(Xen metrics)
{
  #define H_pango_font_metrics_get_descent "int pango_font_metrics_get_descent(PangoFontMetrics* metrics)"
  Xen_check_type(Xen_is_PangoFontMetrics_(metrics), metrics, 1, "pango_font_metrics_get_descent", "PangoFontMetrics*");
  return(C_to_Xen_int(pango_font_metrics_get_descent(Xen_to_C_PangoFontMetrics_(metrics))));
}

static Xen gxg_pango_font_metrics_get_approximate_char_width(Xen metrics)
{
  #define H_pango_font_metrics_get_approximate_char_width "int pango_font_metrics_get_approximate_char_width(PangoFontMetrics* metrics)"
  Xen_check_type(Xen_is_PangoFontMetrics_(metrics), metrics, 1, "pango_font_metrics_get_approximate_char_width", "PangoFontMetrics*");
  return(C_to_Xen_int(pango_font_metrics_get_approximate_char_width(Xen_to_C_PangoFontMetrics_(metrics))));
}

static Xen gxg_pango_font_metrics_get_approximate_digit_width(Xen metrics)
{
  #define H_pango_font_metrics_get_approximate_digit_width "int pango_font_metrics_get_approximate_digit_width(PangoFontMetrics* metrics)"
  Xen_check_type(Xen_is_PangoFontMetrics_(metrics), metrics, 1, "pango_font_metrics_get_approximate_digit_width", "PangoFontMetrics*");
  return(C_to_Xen_int(pango_font_metrics_get_approximate_digit_width(Xen_to_C_PangoFontMetrics_(metrics))));
}

static Xen gxg_pango_font_family_list_faces(Xen family, Xen ignore_faces, Xen ignore_n_faces)
{
  #define H_pango_font_family_list_faces "void pango_font_family_list_faces(PangoFontFamily* family, \
PangoFontFace*** [faces], int* [n_faces])"
  PangoFontFace** ref_faces = NULL;
  int ref_n_faces;
  Xen_check_type(Xen_is_PangoFontFamily_(family), family, 1, "pango_font_family_list_faces", "PangoFontFamily*");
  pango_font_family_list_faces(Xen_to_C_PangoFontFamily_(family), &ref_faces, &ref_n_faces);
  return(Xen_list_2(C_to_Xen_PangoFontFace__(ref_faces), C_to_Xen_int(ref_n_faces)));
}

static Xen gxg_pango_font_family_get_name(Xen family)
{
  #define H_pango_font_family_get_name "char* pango_font_family_get_name(PangoFontFamily* family)"
  Xen_check_type(Xen_is_PangoFontFamily_(family), family, 1, "pango_font_family_get_name", "PangoFontFamily*");
  return(C_to_Xen_char_(pango_font_family_get_name(Xen_to_C_PangoFontFamily_(family))));
}

static Xen gxg_pango_font_face_describe(Xen face)
{
  #define H_pango_font_face_describe "PangoFontDescription* pango_font_face_describe(PangoFontFace* face)"
  Xen_check_type(Xen_is_PangoFontFace_(face), face, 1, "pango_font_face_describe", "PangoFontFace*");
  return(C_to_Xen_PangoFontDescription_(pango_font_face_describe(Xen_to_C_PangoFontFace_(face))));
}

static Xen gxg_pango_font_face_get_face_name(Xen face)
{
  #define H_pango_font_face_get_face_name "char* pango_font_face_get_face_name(PangoFontFace* face)"
  Xen_check_type(Xen_is_PangoFontFace_(face), face, 1, "pango_font_face_get_face_name", "PangoFontFace*");
  return(C_to_Xen_char_(pango_font_face_get_face_name(Xen_to_C_PangoFontFace_(face))));
}

static Xen gxg_pango_font_describe(Xen font)
{
  #define H_pango_font_describe "PangoFontDescription* pango_font_describe(PangoFont* font)"
  Xen_check_type(Xen_is_PangoFont_(font), font, 1, "pango_font_describe", "PangoFont*");
  return(C_to_Xen_PangoFontDescription_(pango_font_describe(Xen_to_C_PangoFont_(font))));
}

static Xen gxg_pango_font_get_coverage(Xen font, Xen language)
{
  #define H_pango_font_get_coverage "PangoCoverage* pango_font_get_coverage(PangoFont* font, PangoLanguage* language)"
  Xen_check_type(Xen_is_PangoFont_(font), font, 1, "pango_font_get_coverage", "PangoFont*");
  Xen_check_type(Xen_is_PangoLanguage_(language), language, 2, "pango_font_get_coverage", "PangoLanguage*");
  return(C_to_Xen_PangoCoverage_(pango_font_get_coverage(Xen_to_C_PangoFont_(font), Xen_to_C_PangoLanguage_(language))));
}

static Xen gxg_pango_font_get_metrics(Xen font, Xen language)
{
  #define H_pango_font_get_metrics "PangoFontMetrics* pango_font_get_metrics(PangoFont* font, PangoLanguage* language)"
  Xen_check_type(Xen_is_PangoFont_(font), font, 1, "pango_font_get_metrics", "PangoFont*");
  Xen_check_type(Xen_is_PangoLanguage_(language), language, 2, "pango_font_get_metrics", "PangoLanguage*");
  return(C_to_Xen_PangoFontMetrics_(pango_font_get_metrics(Xen_to_C_PangoFont_(font), Xen_to_C_PangoLanguage_(language))));
}

static Xen gxg_pango_font_get_glyph_extents(Xen font, Xen glyph, Xen ink_rect, Xen logical_rect)
{
  #define H_pango_font_get_glyph_extents "void pango_font_get_glyph_extents(PangoFont* font, PangoGlyph glyph, \
PangoRectangle* ink_rect, PangoRectangle* logical_rect)"
  Xen_check_type(Xen_is_PangoFont_(font), font, 1, "pango_font_get_glyph_extents", "PangoFont*");
  Xen_check_type(Xen_is_PangoGlyph(glyph), glyph, 2, "pango_font_get_glyph_extents", "PangoGlyph");
  Xen_check_type(Xen_is_PangoRectangle_(ink_rect), ink_rect, 3, "pango_font_get_glyph_extents", "PangoRectangle*");
  Xen_check_type(Xen_is_PangoRectangle_(logical_rect), logical_rect, 4, "pango_font_get_glyph_extents", "PangoRectangle*");
  pango_font_get_glyph_extents(Xen_to_C_PangoFont_(font), Xen_to_C_PangoGlyph(glyph), Xen_to_C_PangoRectangle_(ink_rect), 
                               Xen_to_C_PangoRectangle_(logical_rect));
  return(Xen_false);
}

static Xen gxg_pango_font_map_load_font(Xen fontmap, Xen context, Xen desc)
{
  #define H_pango_font_map_load_font "PangoFont* pango_font_map_load_font(PangoFontMap* fontmap, PangoContext* context, \
PangoFontDescription* desc)"
  Xen_check_type(Xen_is_PangoFontMap_(fontmap), fontmap, 1, "pango_font_map_load_font", "PangoFontMap*");
  Xen_check_type(Xen_is_PangoContext_(context), context, 2, "pango_font_map_load_font", "PangoContext*");
  Xen_check_type(Xen_is_PangoFontDescription_(desc), desc, 3, "pango_font_map_load_font", "PangoFontDescription*");
  return(C_to_Xen_PangoFont_(pango_font_map_load_font(Xen_to_C_PangoFontMap_(fontmap), Xen_to_C_PangoContext_(context), Xen_to_C_PangoFontDescription_(desc))));
}

static Xen gxg_pango_font_map_load_fontset(Xen fontmap, Xen context, Xen desc, Xen language)
{
  #define H_pango_font_map_load_fontset "PangoFontset* pango_font_map_load_fontset(PangoFontMap* fontmap, \
PangoContext* context, PangoFontDescription* desc, PangoLanguage* language)"
  Xen_check_type(Xen_is_PangoFontMap_(fontmap), fontmap, 1, "pango_font_map_load_fontset", "PangoFontMap*");
  Xen_check_type(Xen_is_PangoContext_(context), context, 2, "pango_font_map_load_fontset", "PangoContext*");
  Xen_check_type(Xen_is_PangoFontDescription_(desc), desc, 3, "pango_font_map_load_fontset", "PangoFontDescription*");
  Xen_check_type(Xen_is_PangoLanguage_(language), language, 4, "pango_font_map_load_fontset", "PangoLanguage*");
  return(C_to_Xen_PangoFontset_(pango_font_map_load_fontset(Xen_to_C_PangoFontMap_(fontmap), Xen_to_C_PangoContext_(context), 
                                                            Xen_to_C_PangoFontDescription_(desc), Xen_to_C_PangoLanguage_(language))));
}

static Xen gxg_pango_font_map_list_families(Xen fontmap, Xen ignore_families, Xen ignore_n_families)
{
  #define H_pango_font_map_list_families "void pango_font_map_list_families(PangoFontMap* fontmap, PangoFontFamily*** [families], \
int* [n_families])"
  PangoFontFamily** ref_families = NULL;
  int ref_n_families;
  Xen_check_type(Xen_is_PangoFontMap_(fontmap), fontmap, 1, "pango_font_map_list_families", "PangoFontMap*");
  pango_font_map_list_families(Xen_to_C_PangoFontMap_(fontmap), &ref_families, &ref_n_families);
  return(Xen_list_2(C_to_Xen_PangoFontFamily__(ref_families), C_to_Xen_int(ref_n_families)));
}

static Xen gxg_pango_glyph_string_new(void)
{
  #define H_pango_glyph_string_new "PangoGlyphString* pango_glyph_string_new( void)"
  return(C_to_Xen_PangoGlyphString_(pango_glyph_string_new()));
}

static Xen gxg_pango_glyph_string_set_size(Xen string, Xen new_len)
{
  #define H_pango_glyph_string_set_size "void pango_glyph_string_set_size(PangoGlyphString* string, gint new_len)"
  Xen_check_type(Xen_is_PangoGlyphString_(string), string, 1, "pango_glyph_string_set_size", "PangoGlyphString*");
  Xen_check_type(Xen_is_gint(new_len), new_len, 2, "pango_glyph_string_set_size", "gint");
  pango_glyph_string_set_size(Xen_to_C_PangoGlyphString_(string), Xen_to_C_gint(new_len));
  return(Xen_false);
}

static Xen gxg_pango_glyph_string_copy(Xen string)
{
  #define H_pango_glyph_string_copy "PangoGlyphString* pango_glyph_string_copy(PangoGlyphString* string)"
  Xen_check_type(Xen_is_PangoGlyphString_(string), string, 1, "pango_glyph_string_copy", "PangoGlyphString*");
  return(C_to_Xen_PangoGlyphString_(pango_glyph_string_copy(Xen_to_C_PangoGlyphString_(string))));
}

static Xen gxg_pango_glyph_string_free(Xen string)
{
  #define H_pango_glyph_string_free "void pango_glyph_string_free(PangoGlyphString* string)"
  Xen_check_type(Xen_is_PangoGlyphString_(string), string, 1, "pango_glyph_string_free", "PangoGlyphString*");
  pango_glyph_string_free(Xen_to_C_PangoGlyphString_(string));
  return(Xen_false);
}

static Xen gxg_pango_glyph_string_extents(Xen glyphs, Xen font, Xen ink_rect, Xen logical_rect)
{
  #define H_pango_glyph_string_extents "void pango_glyph_string_extents(PangoGlyphString* glyphs, PangoFont* font, \
PangoRectangle* ink_rect, PangoRectangle* logical_rect)"
  Xen_check_type(Xen_is_PangoGlyphString_(glyphs), glyphs, 1, "pango_glyph_string_extents", "PangoGlyphString*");
  Xen_check_type(Xen_is_PangoFont_(font), font, 2, "pango_glyph_string_extents", "PangoFont*");
  Xen_check_type(Xen_is_PangoRectangle_(ink_rect), ink_rect, 3, "pango_glyph_string_extents", "PangoRectangle*");
  Xen_check_type(Xen_is_PangoRectangle_(logical_rect), logical_rect, 4, "pango_glyph_string_extents", "PangoRectangle*");
  pango_glyph_string_extents(Xen_to_C_PangoGlyphString_(glyphs), Xen_to_C_PangoFont_(font), Xen_to_C_PangoRectangle_(ink_rect), 
                             Xen_to_C_PangoRectangle_(logical_rect));
  return(Xen_false);
}

static Xen gxg_pango_glyph_string_extents_range(Xen glyphs, Xen start, Xen end, Xen font, Xen ink_rect, Xen logical_rect)
{
  #define H_pango_glyph_string_extents_range "void pango_glyph_string_extents_range(PangoGlyphString* glyphs, \
int start, int end, PangoFont* font, PangoRectangle* ink_rect, PangoRectangle* logical_rect)"
  Xen_check_type(Xen_is_PangoGlyphString_(glyphs), glyphs, 1, "pango_glyph_string_extents_range", "PangoGlyphString*");
  Xen_check_type(Xen_is_int(start), start, 2, "pango_glyph_string_extents_range", "int");
  Xen_check_type(Xen_is_int(end), end, 3, "pango_glyph_string_extents_range", "int");
  Xen_check_type(Xen_is_PangoFont_(font), font, 4, "pango_glyph_string_extents_range", "PangoFont*");
  Xen_check_type(Xen_is_PangoRectangle_(ink_rect), ink_rect, 5, "pango_glyph_string_extents_range", "PangoRectangle*");
  Xen_check_type(Xen_is_PangoRectangle_(logical_rect), logical_rect, 6, "pango_glyph_string_extents_range", "PangoRectangle*");
  pango_glyph_string_extents_range(Xen_to_C_PangoGlyphString_(glyphs), Xen_to_C_int(start), Xen_to_C_int(end), Xen_to_C_PangoFont_(font), 
                                   Xen_to_C_PangoRectangle_(ink_rect), Xen_to_C_PangoRectangle_(logical_rect));
  return(Xen_false);
}

static Xen gxg_pango_glyph_string_get_logical_widths(Xen glyphs, Xen text, Xen length, Xen embedding_level, Xen ignore_logical_widths)
{
  #define H_pango_glyph_string_get_logical_widths "void pango_glyph_string_get_logical_widths(PangoGlyphString* glyphs, \
char* text, int length, int embedding_level, int* [logical_widths])"
  int ref_logical_widths;
  Xen_check_type(Xen_is_PangoGlyphString_(glyphs), glyphs, 1, "pango_glyph_string_get_logical_widths", "PangoGlyphString*");
  Xen_check_type(Xen_is_char_(text), text, 2, "pango_glyph_string_get_logical_widths", "char*");
  Xen_check_type(Xen_is_int(length), length, 3, "pango_glyph_string_get_logical_widths", "int");
  Xen_check_type(Xen_is_int(embedding_level), embedding_level, 4, "pango_glyph_string_get_logical_widths", "int");
  pango_glyph_string_get_logical_widths(Xen_to_C_PangoGlyphString_(glyphs), Xen_to_C_char_(text), Xen_to_C_int(length), Xen_to_C_int(embedding_level), 
                                        &ref_logical_widths);
  return(Xen_list_1(C_to_Xen_int(ref_logical_widths)));
}

static Xen gxg_pango_glyph_string_index_to_x(Xen glyphs, Xen text, Xen length, Xen analysis, Xen index, Xen trailing, Xen ignore_x_pos)
{
  #define H_pango_glyph_string_index_to_x "void pango_glyph_string_index_to_x(PangoGlyphString* glyphs, \
char* text, int length, PangoAnalysis* analysis, int index, gboolean trailing, int* [x_pos])"
  int ref_x_pos;
  Xen_check_type(Xen_is_PangoGlyphString_(glyphs), glyphs, 1, "pango_glyph_string_index_to_x", "PangoGlyphString*");
  Xen_check_type(Xen_is_char_(text), text, 2, "pango_glyph_string_index_to_x", "char*");
  Xen_check_type(Xen_is_int(length), length, 3, "pango_glyph_string_index_to_x", "int");
  Xen_check_type(Xen_is_PangoAnalysis_(analysis), analysis, 4, "pango_glyph_string_index_to_x", "PangoAnalysis*");
  Xen_check_type(Xen_is_int(index), index, 5, "pango_glyph_string_index_to_x", "int");
  Xen_check_type(Xen_is_gboolean(trailing), trailing, 6, "pango_glyph_string_index_to_x", "gboolean");
  pango_glyph_string_index_to_x(Xen_to_C_PangoGlyphString_(glyphs), Xen_to_C_char_(text), Xen_to_C_int(length), Xen_to_C_PangoAnalysis_(analysis), 
                                Xen_to_C_int(index), Xen_to_C_gboolean(trailing), &ref_x_pos);
  return(Xen_list_1(C_to_Xen_int(ref_x_pos)));
}

static Xen gxg_pango_glyph_string_x_to_index(Xen glyphs, Xen text, Xen length, Xen analysis, Xen x_pos, Xen ignore_index, Xen ignore_trailing)
{
  #define H_pango_glyph_string_x_to_index "void pango_glyph_string_x_to_index(PangoGlyphString* glyphs, \
char* text, int length, PangoAnalysis* analysis, int x_pos, int* [index], int* [trailing])"
  int ref_index;
  int ref_trailing;
  Xen_check_type(Xen_is_PangoGlyphString_(glyphs), glyphs, 1, "pango_glyph_string_x_to_index", "PangoGlyphString*");
  Xen_check_type(Xen_is_char_(text), text, 2, "pango_glyph_string_x_to_index", "char*");
  Xen_check_type(Xen_is_int(length), length, 3, "pango_glyph_string_x_to_index", "int");
  Xen_check_type(Xen_is_PangoAnalysis_(analysis), analysis, 4, "pango_glyph_string_x_to_index", "PangoAnalysis*");
  Xen_check_type(Xen_is_int(x_pos), x_pos, 5, "pango_glyph_string_x_to_index", "int");
  pango_glyph_string_x_to_index(Xen_to_C_PangoGlyphString_(glyphs), Xen_to_C_char_(text), Xen_to_C_int(length), Xen_to_C_PangoAnalysis_(analysis), 
                                Xen_to_C_int(x_pos), &ref_index, &ref_trailing);
  return(Xen_list_2(C_to_Xen_int(ref_index), C_to_Xen_int(ref_trailing)));
}

static Xen gxg_pango_shape(Xen text, Xen length, Xen analysis, Xen glyphs)
{
  #define H_pango_shape "void pango_shape(gchar* text, gint length, PangoAnalysis* analysis, PangoGlyphString* glyphs)"
  Xen_check_type(Xen_is_gchar_(text), text, 1, "pango_shape", "gchar*");
  Xen_check_type(Xen_is_gint(length), length, 2, "pango_shape", "gint");
  Xen_check_type(Xen_is_PangoAnalysis_(analysis), analysis, 3, "pango_shape", "PangoAnalysis*");
  Xen_check_type(Xen_is_PangoGlyphString_(glyphs), glyphs, 4, "pango_shape", "PangoGlyphString*");
  pango_shape(Xen_to_C_gchar_(text), Xen_to_C_gint(length), Xen_to_C_PangoAnalysis_(analysis), Xen_to_C_PangoGlyphString_(glyphs));
  return(Xen_false);
}

static Xen gxg_pango_reorder_items(Xen logical_items)
{
  #define H_pango_reorder_items "GList* pango_reorder_items(GList* logical_items)"
  Xen_check_type(Xen_is_GList_(logical_items), logical_items, 1, "pango_reorder_items", "GList*");
  return(C_to_Xen_GList_(pango_reorder_items(Xen_to_C_GList_(logical_items))));
}

static Xen gxg_pango_item_new(void)
{
  #define H_pango_item_new "PangoItem* pango_item_new( void)"
  return(C_to_Xen_PangoItem_(pango_item_new()));
}

static Xen gxg_pango_item_copy(Xen item)
{
  #define H_pango_item_copy "PangoItem* pango_item_copy(PangoItem* item)"
  Xen_check_type(Xen_is_PangoItem_(item), item, 1, "pango_item_copy", "PangoItem*");
  return(C_to_Xen_PangoItem_(pango_item_copy(Xen_to_C_PangoItem_(item))));
}

static Xen gxg_pango_item_free(Xen item)
{
  #define H_pango_item_free "void pango_item_free(PangoItem* item)"
  Xen_check_type(Xen_is_PangoItem_(item), item, 1, "pango_item_free", "PangoItem*");
  pango_item_free(Xen_to_C_PangoItem_(item));
  return(Xen_false);
}

static Xen gxg_pango_item_split(Xen orig, Xen split_index, Xen split_offset)
{
  #define H_pango_item_split "PangoItem* pango_item_split(PangoItem* orig, int split_index, int split_offset)"
  Xen_check_type(Xen_is_PangoItem_(orig), orig, 1, "pango_item_split", "PangoItem*");
  Xen_check_type(Xen_is_int(split_index), split_index, 2, "pango_item_split", "int");
  Xen_check_type(Xen_is_int(split_offset), split_offset, 3, "pango_item_split", "int");
  return(C_to_Xen_PangoItem_(pango_item_split(Xen_to_C_PangoItem_(orig), Xen_to_C_int(split_index), Xen_to_C_int(split_offset))));
}

static Xen gxg_pango_layout_new(Xen context)
{
  #define H_pango_layout_new "PangoLayout* pango_layout_new(PangoContext* context)"
  Xen_check_type(Xen_is_PangoContext_(context), context, 1, "pango_layout_new", "PangoContext*");
  return(C_to_Xen_PangoLayout_(pango_layout_new(Xen_to_C_PangoContext_(context))));
}

static Xen gxg_pango_layout_copy(Xen src)
{
  #define H_pango_layout_copy "PangoLayout* pango_layout_copy(PangoLayout* src)"
  Xen_check_type(Xen_is_PangoLayout_(src), src, 1, "pango_layout_copy", "PangoLayout*");
  return(C_to_Xen_PangoLayout_(pango_layout_copy(Xen_to_C_PangoLayout_(src))));
}

static Xen gxg_pango_layout_get_context(Xen layout)
{
  #define H_pango_layout_get_context "PangoContext* pango_layout_get_context(PangoLayout* layout)"
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_get_context", "PangoLayout*");
  return(C_to_Xen_PangoContext_(pango_layout_get_context(Xen_to_C_PangoLayout_(layout))));
}

static Xen gxg_pango_layout_set_attributes(Xen layout, Xen attrs)
{
  #define H_pango_layout_set_attributes "void pango_layout_set_attributes(PangoLayout* layout, PangoAttrList* attrs)"
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_set_attributes", "PangoLayout*");
  Xen_check_type(Xen_is_PangoAttrList_(attrs), attrs, 2, "pango_layout_set_attributes", "PangoAttrList*");
  pango_layout_set_attributes(Xen_to_C_PangoLayout_(layout), Xen_to_C_PangoAttrList_(attrs));
  return(Xen_false);
}

static Xen gxg_pango_layout_get_attributes(Xen layout)
{
  #define H_pango_layout_get_attributes "PangoAttrList* pango_layout_get_attributes(PangoLayout* layout)"
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_get_attributes", "PangoLayout*");
  return(C_to_Xen_PangoAttrList_(pango_layout_get_attributes(Xen_to_C_PangoLayout_(layout))));
}

static Xen gxg_pango_layout_set_text(Xen layout, Xen text, Xen length)
{
  #define H_pango_layout_set_text "void pango_layout_set_text(PangoLayout* layout, char* text, int length)"
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_set_text", "PangoLayout*");
  Xen_check_type(Xen_is_char_(text), text, 2, "pango_layout_set_text", "char*");
  Xen_check_type(Xen_is_int(length), length, 3, "pango_layout_set_text", "int");
  pango_layout_set_text(Xen_to_C_PangoLayout_(layout), Xen_to_C_char_(text), Xen_to_C_int(length));
  return(Xen_false);
}

static Xen gxg_pango_layout_get_text(Xen layout)
{
  #define H_pango_layout_get_text "char* pango_layout_get_text(PangoLayout* layout)"
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_get_text", "PangoLayout*");
  return(C_to_Xen_char_(pango_layout_get_text(Xen_to_C_PangoLayout_(layout))));
}

static Xen gxg_pango_layout_set_markup(Xen layout, Xen markup, Xen length)
{
  #define H_pango_layout_set_markup "void pango_layout_set_markup(PangoLayout* layout, char* markup, \
int length)"
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_set_markup", "PangoLayout*");
  Xen_check_type(Xen_is_char_(markup), markup, 2, "pango_layout_set_markup", "char*");
  Xen_check_type(Xen_is_int(length), length, 3, "pango_layout_set_markup", "int");
  pango_layout_set_markup(Xen_to_C_PangoLayout_(layout), Xen_to_C_char_(markup), Xen_to_C_int(length));
  return(Xen_false);
}

static Xen gxg_pango_layout_set_markup_with_accel(Xen layout, Xen markup, Xen length, Xen accel_marker, Xen accel_char)
{
  #define H_pango_layout_set_markup_with_accel "void pango_layout_set_markup_with_accel(PangoLayout* layout, \
char* markup, int length, gunichar accel_marker, gunichar* accel_char)"
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_set_markup_with_accel", "PangoLayout*");
  Xen_check_type(Xen_is_char_(markup), markup, 2, "pango_layout_set_markup_with_accel", "char*");
  Xen_check_type(Xen_is_int(length), length, 3, "pango_layout_set_markup_with_accel", "int");
  Xen_check_type(Xen_is_gunichar(accel_marker), accel_marker, 4, "pango_layout_set_markup_with_accel", "gunichar");
  Xen_check_type(Xen_is_gunichar_(accel_char), accel_char, 5, "pango_layout_set_markup_with_accel", "gunichar*");
  pango_layout_set_markup_with_accel(Xen_to_C_PangoLayout_(layout), Xen_to_C_char_(markup), Xen_to_C_int(length), Xen_to_C_gunichar(accel_marker), 
                                     Xen_to_C_gunichar_(accel_char));
  return(Xen_false);
}

static Xen gxg_pango_layout_set_font_description(Xen layout, Xen desc)
{
  #define H_pango_layout_set_font_description "void pango_layout_set_font_description(PangoLayout* layout, \
PangoFontDescription* desc)"
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_set_font_description", "PangoLayout*");
  Xen_check_type(Xen_is_PangoFontDescription_(desc), desc, 2, "pango_layout_set_font_description", "PangoFontDescription*");
  pango_layout_set_font_description(Xen_to_C_PangoLayout_(layout), Xen_to_C_PangoFontDescription_(desc));
  return(Xen_false);
}

static Xen gxg_pango_layout_set_width(Xen layout, Xen width)
{
  #define H_pango_layout_set_width "void pango_layout_set_width(PangoLayout* layout, int width)"
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_set_width", "PangoLayout*");
  Xen_check_type(Xen_is_int(width), width, 2, "pango_layout_set_width", "int");
  pango_layout_set_width(Xen_to_C_PangoLayout_(layout), Xen_to_C_int(width));
  return(Xen_false);
}

static Xen gxg_pango_layout_get_width(Xen layout)
{
  #define H_pango_layout_get_width "int pango_layout_get_width(PangoLayout* layout)"
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_get_width", "PangoLayout*");
  return(C_to_Xen_int(pango_layout_get_width(Xen_to_C_PangoLayout_(layout))));
}

static Xen gxg_pango_layout_set_wrap(Xen layout, Xen wrap)
{
  #define H_pango_layout_set_wrap "void pango_layout_set_wrap(PangoLayout* layout, PangoWrapMode wrap)"
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_set_wrap", "PangoLayout*");
  Xen_check_type(Xen_is_PangoWrapMode(wrap), wrap, 2, "pango_layout_set_wrap", "PangoWrapMode");
  pango_layout_set_wrap(Xen_to_C_PangoLayout_(layout), Xen_to_C_PangoWrapMode(wrap));
  return(Xen_false);
}

static Xen gxg_pango_layout_get_wrap(Xen layout)
{
  #define H_pango_layout_get_wrap "PangoWrapMode pango_layout_get_wrap(PangoLayout* layout)"
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_get_wrap", "PangoLayout*");
  return(C_to_Xen_PangoWrapMode(pango_layout_get_wrap(Xen_to_C_PangoLayout_(layout))));
}

static Xen gxg_pango_layout_set_indent(Xen layout, Xen indent)
{
  #define H_pango_layout_set_indent "void pango_layout_set_indent(PangoLayout* layout, int indent)"
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_set_indent", "PangoLayout*");
  Xen_check_type(Xen_is_int(indent), indent, 2, "pango_layout_set_indent", "int");
  pango_layout_set_indent(Xen_to_C_PangoLayout_(layout), Xen_to_C_int(indent));
  return(Xen_false);
}

static Xen gxg_pango_layout_get_indent(Xen layout)
{
  #define H_pango_layout_get_indent "int pango_layout_get_indent(PangoLayout* layout)"
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_get_indent", "PangoLayout*");
  return(C_to_Xen_int(pango_layout_get_indent(Xen_to_C_PangoLayout_(layout))));
}

static Xen gxg_pango_layout_set_spacing(Xen layout, Xen spacing)
{
  #define H_pango_layout_set_spacing "void pango_layout_set_spacing(PangoLayout* layout, int spacing)"
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_set_spacing", "PangoLayout*");
  Xen_check_type(Xen_is_int(spacing), spacing, 2, "pango_layout_set_spacing", "int");
  pango_layout_set_spacing(Xen_to_C_PangoLayout_(layout), Xen_to_C_int(spacing));
  return(Xen_false);
}

static Xen gxg_pango_layout_get_spacing(Xen layout)
{
  #define H_pango_layout_get_spacing "int pango_layout_get_spacing(PangoLayout* layout)"
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_get_spacing", "PangoLayout*");
  return(C_to_Xen_int(pango_layout_get_spacing(Xen_to_C_PangoLayout_(layout))));
}

static Xen gxg_pango_layout_set_justify(Xen layout, Xen justify)
{
  #define H_pango_layout_set_justify "void pango_layout_set_justify(PangoLayout* layout, gboolean justify)"
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_set_justify", "PangoLayout*");
  Xen_check_type(Xen_is_gboolean(justify), justify, 2, "pango_layout_set_justify", "gboolean");
  pango_layout_set_justify(Xen_to_C_PangoLayout_(layout), Xen_to_C_gboolean(justify));
  return(Xen_false);
}

static Xen gxg_pango_layout_get_justify(Xen layout)
{
  #define H_pango_layout_get_justify "gboolean pango_layout_get_justify(PangoLayout* layout)"
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_get_justify", "PangoLayout*");
  return(C_to_Xen_gboolean(pango_layout_get_justify(Xen_to_C_PangoLayout_(layout))));
}

static Xen gxg_pango_layout_set_alignment(Xen layout, Xen alignment)
{
  #define H_pango_layout_set_alignment "void pango_layout_set_alignment(PangoLayout* layout, PangoAlignment alignment)"
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_set_alignment", "PangoLayout*");
  Xen_check_type(Xen_is_PangoAlignment(alignment), alignment, 2, "pango_layout_set_alignment", "PangoAlignment");
  pango_layout_set_alignment(Xen_to_C_PangoLayout_(layout), Xen_to_C_PangoAlignment(alignment));
  return(Xen_false);
}

static Xen gxg_pango_layout_get_alignment(Xen layout)
{
  #define H_pango_layout_get_alignment "PangoAlignment pango_layout_get_alignment(PangoLayout* layout)"
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_get_alignment", "PangoLayout*");
  return(C_to_Xen_PangoAlignment(pango_layout_get_alignment(Xen_to_C_PangoLayout_(layout))));
}

static Xen gxg_pango_layout_set_tabs(Xen layout, Xen tabs)
{
  #define H_pango_layout_set_tabs "void pango_layout_set_tabs(PangoLayout* layout, PangoTabArray* tabs)"
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_set_tabs", "PangoLayout*");
  Xen_check_type(Xen_is_PangoTabArray_(tabs) || Xen_is_false(tabs), tabs, 2, "pango_layout_set_tabs", "PangoTabArray*");
  pango_layout_set_tabs(Xen_to_C_PangoLayout_(layout), Xen_to_C_PangoTabArray_(tabs));
  return(Xen_false);
}

static Xen gxg_pango_layout_get_tabs(Xen layout)
{
  #define H_pango_layout_get_tabs "PangoTabArray* pango_layout_get_tabs(PangoLayout* layout)"
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_get_tabs", "PangoLayout*");
  return(C_to_Xen_PangoTabArray_(pango_layout_get_tabs(Xen_to_C_PangoLayout_(layout))));
}

static Xen gxg_pango_layout_set_single_paragraph_mode(Xen layout, Xen setting)
{
  #define H_pango_layout_set_single_paragraph_mode "void pango_layout_set_single_paragraph_mode(PangoLayout* layout, \
gboolean setting)"
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_set_single_paragraph_mode", "PangoLayout*");
  Xen_check_type(Xen_is_gboolean(setting), setting, 2, "pango_layout_set_single_paragraph_mode", "gboolean");
  pango_layout_set_single_paragraph_mode(Xen_to_C_PangoLayout_(layout), Xen_to_C_gboolean(setting));
  return(Xen_false);
}

static Xen gxg_pango_layout_get_single_paragraph_mode(Xen layout)
{
  #define H_pango_layout_get_single_paragraph_mode "gboolean pango_layout_get_single_paragraph_mode(PangoLayout* layout)"
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_get_single_paragraph_mode", "PangoLayout*");
  return(C_to_Xen_gboolean(pango_layout_get_single_paragraph_mode(Xen_to_C_PangoLayout_(layout))));
}

static Xen gxg_pango_layout_context_changed(Xen layout)
{
  #define H_pango_layout_context_changed "void pango_layout_context_changed(PangoLayout* layout)"
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_context_changed", "PangoLayout*");
  pango_layout_context_changed(Xen_to_C_PangoLayout_(layout));
  return(Xen_false);
}

static Xen gxg_pango_layout_get_log_attrs(Xen layout, Xen ignore_attrs, Xen ignore_n_attrs)
{
  #define H_pango_layout_get_log_attrs "void pango_layout_get_log_attrs(PangoLayout* layout, PangoLogAttr** [attrs], \
gint* [n_attrs])"
  PangoLogAttr* ref_attrs = NULL;
  gint ref_n_attrs;
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_get_log_attrs", "PangoLayout*");
  pango_layout_get_log_attrs(Xen_to_C_PangoLayout_(layout), &ref_attrs, &ref_n_attrs);
  return(Xen_list_2(C_to_Xen_PangoLogAttr_(ref_attrs), C_to_Xen_gint(ref_n_attrs)));
}

static Xen gxg_pango_layout_index_to_pos(Xen layout, Xen index, Xen pos)
{
  #define H_pango_layout_index_to_pos "void pango_layout_index_to_pos(PangoLayout* layout, int index, \
PangoRectangle* pos)"
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_index_to_pos", "PangoLayout*");
  Xen_check_type(Xen_is_int(index), index, 2, "pango_layout_index_to_pos", "int");
  Xen_check_type(Xen_is_PangoRectangle_(pos), pos, 3, "pango_layout_index_to_pos", "PangoRectangle*");
  pango_layout_index_to_pos(Xen_to_C_PangoLayout_(layout), Xen_to_C_int(index), Xen_to_C_PangoRectangle_(pos));
  return(Xen_false);
}

static Xen gxg_pango_layout_get_cursor_pos(Xen layout, Xen index, Xen strong_pos, Xen weak_pos)
{
  #define H_pango_layout_get_cursor_pos "void pango_layout_get_cursor_pos(PangoLayout* layout, int index, \
PangoRectangle* strong_pos, PangoRectangle* weak_pos)"
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_get_cursor_pos", "PangoLayout*");
  Xen_check_type(Xen_is_int(index), index, 2, "pango_layout_get_cursor_pos", "int");
  Xen_check_type(Xen_is_PangoRectangle_(strong_pos), strong_pos, 3, "pango_layout_get_cursor_pos", "PangoRectangle*");
  Xen_check_type(Xen_is_PangoRectangle_(weak_pos), weak_pos, 4, "pango_layout_get_cursor_pos", "PangoRectangle*");
  pango_layout_get_cursor_pos(Xen_to_C_PangoLayout_(layout), Xen_to_C_int(index), Xen_to_C_PangoRectangle_(strong_pos), Xen_to_C_PangoRectangle_(weak_pos));
  return(Xen_false);
}

static Xen gxg_pango_layout_move_cursor_visually(Xen layout, Xen strong, Xen old_index, Xen old_trailing, Xen direction, Xen new_index, Xen new_trailing)
{
  #define H_pango_layout_move_cursor_visually "void pango_layout_move_cursor_visually(PangoLayout* layout, \
gboolean strong, int old_index, int old_trailing, int direction, int* new_index, int* new_trailing)"
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_move_cursor_visually", "PangoLayout*");
  Xen_check_type(Xen_is_gboolean(strong), strong, 2, "pango_layout_move_cursor_visually", "gboolean");
  Xen_check_type(Xen_is_int(old_index), old_index, 3, "pango_layout_move_cursor_visually", "int");
  Xen_check_type(Xen_is_int(old_trailing), old_trailing, 4, "pango_layout_move_cursor_visually", "int");
  Xen_check_type(Xen_is_int(direction), direction, 5, "pango_layout_move_cursor_visually", "int");
  Xen_check_type(Xen_is_int_(new_index), new_index, 6, "pango_layout_move_cursor_visually", "int*");
  Xen_check_type(Xen_is_int_(new_trailing), new_trailing, 7, "pango_layout_move_cursor_visually", "int*");
  pango_layout_move_cursor_visually(Xen_to_C_PangoLayout_(layout), Xen_to_C_gboolean(strong), Xen_to_C_int(old_index), Xen_to_C_int(old_trailing), 
                                    Xen_to_C_int(direction), Xen_to_C_int_(new_index), Xen_to_C_int_(new_trailing));
  return(Xen_false);
}

static Xen gxg_pango_layout_xy_to_index(Xen layout, Xen x, Xen y, Xen ignore_index, Xen ignore_trailing)
{
  #define H_pango_layout_xy_to_index "gboolean pango_layout_xy_to_index(PangoLayout* layout, int x, int y, \
int* [index], int* [trailing])"
  int ref_index;
  int ref_trailing;
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_xy_to_index", "PangoLayout*");
  Xen_check_type(Xen_is_int(x), x, 2, "pango_layout_xy_to_index", "int");
  Xen_check_type(Xen_is_int(y), y, 3, "pango_layout_xy_to_index", "int");
  {
    Xen res_ult;
    res_ult = C_to_Xen_gboolean(pango_layout_xy_to_index(Xen_to_C_PangoLayout_(layout), Xen_to_C_int(x), Xen_to_C_int(y), 
                                                         &ref_index, &ref_trailing));
    return(Xen_list_3(res_ult, C_to_Xen_int(ref_index), C_to_Xen_int(ref_trailing)));
   }
}

static Xen gxg_pango_layout_get_extents(Xen layout, Xen ink_rect, Xen logical_rect)
{
  #define H_pango_layout_get_extents "void pango_layout_get_extents(PangoLayout* layout, PangoRectangle* ink_rect, \
PangoRectangle* logical_rect)"
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_get_extents", "PangoLayout*");
  Xen_check_type(Xen_is_PangoRectangle_(ink_rect), ink_rect, 2, "pango_layout_get_extents", "PangoRectangle*");
  Xen_check_type(Xen_is_PangoRectangle_(logical_rect), logical_rect, 3, "pango_layout_get_extents", "PangoRectangle*");
  pango_layout_get_extents(Xen_to_C_PangoLayout_(layout), Xen_to_C_PangoRectangle_(ink_rect), Xen_to_C_PangoRectangle_(logical_rect));
  return(Xen_false);
}

static Xen gxg_pango_layout_get_pixel_extents(Xen layout, Xen ink_rect, Xen logical_rect)
{
  #define H_pango_layout_get_pixel_extents "void pango_layout_get_pixel_extents(PangoLayout* layout, \
PangoRectangle* ink_rect, PangoRectangle* logical_rect)"
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_get_pixel_extents", "PangoLayout*");
  Xen_check_type(Xen_is_PangoRectangle_(ink_rect), ink_rect, 2, "pango_layout_get_pixel_extents", "PangoRectangle*");
  Xen_check_type(Xen_is_PangoRectangle_(logical_rect), logical_rect, 3, "pango_layout_get_pixel_extents", "PangoRectangle*");
  pango_layout_get_pixel_extents(Xen_to_C_PangoLayout_(layout), Xen_to_C_PangoRectangle_(ink_rect), Xen_to_C_PangoRectangle_(logical_rect));
  return(Xen_false);
}

static Xen gxg_pango_layout_get_size(Xen layout, Xen ignore_width, Xen ignore_height)
{
  #define H_pango_layout_get_size "void pango_layout_get_size(PangoLayout* layout, int* [width], int* [height])"
  int ref_width;
  int ref_height;
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_get_size", "PangoLayout*");
  pango_layout_get_size(Xen_to_C_PangoLayout_(layout), &ref_width, &ref_height);
  return(Xen_list_2(C_to_Xen_int(ref_width), C_to_Xen_int(ref_height)));
}

static Xen gxg_pango_layout_get_pixel_size(Xen layout, Xen ignore_width, Xen ignore_height)
{
  #define H_pango_layout_get_pixel_size "void pango_layout_get_pixel_size(PangoLayout* layout, int* [width], \
int* [height])"
  int ref_width;
  int ref_height;
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_get_pixel_size", "PangoLayout*");
  pango_layout_get_pixel_size(Xen_to_C_PangoLayout_(layout), &ref_width, &ref_height);
  return(Xen_list_2(C_to_Xen_int(ref_width), C_to_Xen_int(ref_height)));
}

static Xen gxg_pango_layout_get_line_count(Xen layout)
{
  #define H_pango_layout_get_line_count "int pango_layout_get_line_count(PangoLayout* layout)"
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_get_line_count", "PangoLayout*");
  return(C_to_Xen_int(pango_layout_get_line_count(Xen_to_C_PangoLayout_(layout))));
}

static Xen gxg_pango_layout_get_line(Xen layout, Xen line)
{
  #define H_pango_layout_get_line "PangoLayoutLine* pango_layout_get_line(PangoLayout* layout, int line)"
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_get_line", "PangoLayout*");
  Xen_check_type(Xen_is_int(line), line, 2, "pango_layout_get_line", "int");
  return(C_to_Xen_PangoLayoutLine_(pango_layout_get_line(Xen_to_C_PangoLayout_(layout), Xen_to_C_int(line))));
}

static Xen gxg_pango_layout_get_lines(Xen layout)
{
  #define H_pango_layout_get_lines "GSList* pango_layout_get_lines(PangoLayout* layout)"
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_get_lines", "PangoLayout*");
  return(C_to_Xen_GSList_(pango_layout_get_lines(Xen_to_C_PangoLayout_(layout))));
}

static Xen gxg_pango_layout_line_unref(Xen line)
{
  #define H_pango_layout_line_unref "void pango_layout_line_unref(PangoLayoutLine* line)"
  Xen_check_type(Xen_is_PangoLayoutLine_(line), line, 1, "pango_layout_line_unref", "PangoLayoutLine*");
  pango_layout_line_unref(Xen_to_C_PangoLayoutLine_(line));
  return(Xen_false);
}

static Xen gxg_pango_layout_line_x_to_index(Xen line, Xen x_pos, Xen ignore_index, Xen ignore_trailing)
{
  #define H_pango_layout_line_x_to_index "gboolean pango_layout_line_x_to_index(PangoLayoutLine* line, \
int x_pos, int* [index], int* [trailing])"
  int ref_index;
  int ref_trailing;
  Xen_check_type(Xen_is_PangoLayoutLine_(line), line, 1, "pango_layout_line_x_to_index", "PangoLayoutLine*");
  Xen_check_type(Xen_is_int(x_pos), x_pos, 2, "pango_layout_line_x_to_index", "int");
  {
    Xen res_ult;
    res_ult = C_to_Xen_gboolean(pango_layout_line_x_to_index(Xen_to_C_PangoLayoutLine_(line), Xen_to_C_int(x_pos), &ref_index, 
                                                             &ref_trailing));
    return(Xen_list_3(res_ult, C_to_Xen_int(ref_index), C_to_Xen_int(ref_trailing)));
   }
}

static Xen gxg_pango_layout_line_index_to_x(Xen line, Xen index, Xen trailing, Xen ignore_x_pos)
{
  #define H_pango_layout_line_index_to_x "void pango_layout_line_index_to_x(PangoLayoutLine* line, int index, \
gboolean trailing, int* [x_pos])"
  int ref_x_pos;
  Xen_check_type(Xen_is_PangoLayoutLine_(line), line, 1, "pango_layout_line_index_to_x", "PangoLayoutLine*");
  Xen_check_type(Xen_is_int(index), index, 2, "pango_layout_line_index_to_x", "int");
  Xen_check_type(Xen_is_gboolean(trailing), trailing, 3, "pango_layout_line_index_to_x", "gboolean");
  pango_layout_line_index_to_x(Xen_to_C_PangoLayoutLine_(line), Xen_to_C_int(index), Xen_to_C_gboolean(trailing), &ref_x_pos);
  return(Xen_list_1(C_to_Xen_int(ref_x_pos)));
}

static Xen gxg_pango_layout_line_get_x_ranges(Xen line, Xen start_index, Xen end_index, Xen ignore_ranges, Xen ignore_n_ranges)
{
  #define H_pango_layout_line_get_x_ranges "void pango_layout_line_get_x_ranges(PangoLayoutLine* line, \
int start_index, int end_index, int** [ranges], int* [n_ranges])"
  int* ref_ranges = NULL;
  int ref_n_ranges;
  Xen_check_type(Xen_is_PangoLayoutLine_(line), line, 1, "pango_layout_line_get_x_ranges", "PangoLayoutLine*");
  Xen_check_type(Xen_is_int(start_index), start_index, 2, "pango_layout_line_get_x_ranges", "int");
  Xen_check_type(Xen_is_int(end_index), end_index, 3, "pango_layout_line_get_x_ranges", "int");
  pango_layout_line_get_x_ranges(Xen_to_C_PangoLayoutLine_(line), Xen_to_C_int(start_index), Xen_to_C_int(end_index), &ref_ranges, 
                                 &ref_n_ranges);
  return(Xen_list_2(C_to_Xen_int_(ref_ranges), C_to_Xen_int(ref_n_ranges)));
}

static Xen gxg_pango_layout_line_get_extents(Xen line, Xen ink_rect, Xen logical_rect)
{
  #define H_pango_layout_line_get_extents "void pango_layout_line_get_extents(PangoLayoutLine* line, \
PangoRectangle* ink_rect, PangoRectangle* logical_rect)"
  Xen_check_type(Xen_is_PangoLayoutLine_(line), line, 1, "pango_layout_line_get_extents", "PangoLayoutLine*");
  Xen_check_type(Xen_is_PangoRectangle_(ink_rect), ink_rect, 2, "pango_layout_line_get_extents", "PangoRectangle*");
  Xen_check_type(Xen_is_PangoRectangle_(logical_rect), logical_rect, 3, "pango_layout_line_get_extents", "PangoRectangle*");
  pango_layout_line_get_extents(Xen_to_C_PangoLayoutLine_(line), Xen_to_C_PangoRectangle_(ink_rect), Xen_to_C_PangoRectangle_(logical_rect));
  return(Xen_false);
}

static Xen gxg_pango_layout_line_get_pixel_extents(Xen layout_line, Xen ink_rect, Xen logical_rect)
{
  #define H_pango_layout_line_get_pixel_extents "void pango_layout_line_get_pixel_extents(PangoLayoutLine* layout_line, \
PangoRectangle* ink_rect, PangoRectangle* logical_rect)"
  Xen_check_type(Xen_is_PangoLayoutLine_(layout_line), layout_line, 1, "pango_layout_line_get_pixel_extents", "PangoLayoutLine*");
  Xen_check_type(Xen_is_PangoRectangle_(ink_rect), ink_rect, 2, "pango_layout_line_get_pixel_extents", "PangoRectangle*");
  Xen_check_type(Xen_is_PangoRectangle_(logical_rect), logical_rect, 3, "pango_layout_line_get_pixel_extents", "PangoRectangle*");
  pango_layout_line_get_pixel_extents(Xen_to_C_PangoLayoutLine_(layout_line), Xen_to_C_PangoRectangle_(ink_rect), Xen_to_C_PangoRectangle_(logical_rect));
  return(Xen_false);
}

static Xen gxg_pango_layout_get_iter(Xen layout)
{
  #define H_pango_layout_get_iter "PangoLayoutIter* pango_layout_get_iter(PangoLayout* layout)"
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_get_iter", "PangoLayout*");
  return(C_to_Xen_PangoLayoutIter_(pango_layout_get_iter(Xen_to_C_PangoLayout_(layout))));
}

static Xen gxg_pango_layout_iter_free(Xen iter)
{
  #define H_pango_layout_iter_free "void pango_layout_iter_free(PangoLayoutIter* iter)"
  Xen_check_type(Xen_is_PangoLayoutIter_(iter), iter, 1, "pango_layout_iter_free", "PangoLayoutIter*");
  pango_layout_iter_free(Xen_to_C_PangoLayoutIter_(iter));
  return(Xen_false);
}

static Xen gxg_pango_layout_iter_get_index(Xen iter)
{
  #define H_pango_layout_iter_get_index "int pango_layout_iter_get_index(PangoLayoutIter* iter)"
  Xen_check_type(Xen_is_PangoLayoutIter_(iter), iter, 1, "pango_layout_iter_get_index", "PangoLayoutIter*");
  return(C_to_Xen_int(pango_layout_iter_get_index(Xen_to_C_PangoLayoutIter_(iter))));
}

static Xen gxg_pango_layout_iter_get_run(Xen iter)
{
  #define H_pango_layout_iter_get_run "PangoLayoutRun* pango_layout_iter_get_run(PangoLayoutIter* iter)"
  Xen_check_type(Xen_is_PangoLayoutIter_(iter), iter, 1, "pango_layout_iter_get_run", "PangoLayoutIter*");
  return(C_to_Xen_PangoLayoutRun_(pango_layout_iter_get_run(Xen_to_C_PangoLayoutIter_(iter))));
}

static Xen gxg_pango_layout_iter_get_line(Xen iter)
{
  #define H_pango_layout_iter_get_line "PangoLayoutLine* pango_layout_iter_get_line(PangoLayoutIter* iter)"
  Xen_check_type(Xen_is_PangoLayoutIter_(iter), iter, 1, "pango_layout_iter_get_line", "PangoLayoutIter*");
  return(C_to_Xen_PangoLayoutLine_(pango_layout_iter_get_line(Xen_to_C_PangoLayoutIter_(iter))));
}

static Xen gxg_pango_layout_iter_at_last_line(Xen iter)
{
  #define H_pango_layout_iter_at_last_line "gboolean pango_layout_iter_at_last_line(PangoLayoutIter* iter)"
  Xen_check_type(Xen_is_PangoLayoutIter_(iter), iter, 1, "pango_layout_iter_at_last_line", "PangoLayoutIter*");
  return(C_to_Xen_gboolean(pango_layout_iter_at_last_line(Xen_to_C_PangoLayoutIter_(iter))));
}

static Xen gxg_pango_layout_iter_next_char(Xen iter)
{
  #define H_pango_layout_iter_next_char "gboolean pango_layout_iter_next_char(PangoLayoutIter* iter)"
  Xen_check_type(Xen_is_PangoLayoutIter_(iter), iter, 1, "pango_layout_iter_next_char", "PangoLayoutIter*");
  return(C_to_Xen_gboolean(pango_layout_iter_next_char(Xen_to_C_PangoLayoutIter_(iter))));
}

static Xen gxg_pango_layout_iter_next_cluster(Xen iter)
{
  #define H_pango_layout_iter_next_cluster "gboolean pango_layout_iter_next_cluster(PangoLayoutIter* iter)"
  Xen_check_type(Xen_is_PangoLayoutIter_(iter), iter, 1, "pango_layout_iter_next_cluster", "PangoLayoutIter*");
  return(C_to_Xen_gboolean(pango_layout_iter_next_cluster(Xen_to_C_PangoLayoutIter_(iter))));
}

static Xen gxg_pango_layout_iter_next_run(Xen iter)
{
  #define H_pango_layout_iter_next_run "gboolean pango_layout_iter_next_run(PangoLayoutIter* iter)"
  Xen_check_type(Xen_is_PangoLayoutIter_(iter), iter, 1, "pango_layout_iter_next_run", "PangoLayoutIter*");
  return(C_to_Xen_gboolean(pango_layout_iter_next_run(Xen_to_C_PangoLayoutIter_(iter))));
}

static Xen gxg_pango_layout_iter_next_line(Xen iter)
{
  #define H_pango_layout_iter_next_line "gboolean pango_layout_iter_next_line(PangoLayoutIter* iter)"
  Xen_check_type(Xen_is_PangoLayoutIter_(iter), iter, 1, "pango_layout_iter_next_line", "PangoLayoutIter*");
  return(C_to_Xen_gboolean(pango_layout_iter_next_line(Xen_to_C_PangoLayoutIter_(iter))));
}

static Xen gxg_pango_layout_iter_get_char_extents(Xen iter, Xen logical_rect)
{
  #define H_pango_layout_iter_get_char_extents "void pango_layout_iter_get_char_extents(PangoLayoutIter* iter, \
PangoRectangle* logical_rect)"
  Xen_check_type(Xen_is_PangoLayoutIter_(iter), iter, 1, "pango_layout_iter_get_char_extents", "PangoLayoutIter*");
  Xen_check_type(Xen_is_PangoRectangle_(logical_rect), logical_rect, 2, "pango_layout_iter_get_char_extents", "PangoRectangle*");
  pango_layout_iter_get_char_extents(Xen_to_C_PangoLayoutIter_(iter), Xen_to_C_PangoRectangle_(logical_rect));
  return(Xen_false);
}

static Xen gxg_pango_layout_iter_get_cluster_extents(Xen iter, Xen ink_rect, Xen logical_rect)
{
  #define H_pango_layout_iter_get_cluster_extents "void pango_layout_iter_get_cluster_extents(PangoLayoutIter* iter, \
PangoRectangle* ink_rect, PangoRectangle* logical_rect)"
  Xen_check_type(Xen_is_PangoLayoutIter_(iter), iter, 1, "pango_layout_iter_get_cluster_extents", "PangoLayoutIter*");
  Xen_check_type(Xen_is_PangoRectangle_(ink_rect), ink_rect, 2, "pango_layout_iter_get_cluster_extents", "PangoRectangle*");
  Xen_check_type(Xen_is_PangoRectangle_(logical_rect), logical_rect, 3, "pango_layout_iter_get_cluster_extents", "PangoRectangle*");
  pango_layout_iter_get_cluster_extents(Xen_to_C_PangoLayoutIter_(iter), Xen_to_C_PangoRectangle_(ink_rect), Xen_to_C_PangoRectangle_(logical_rect));
  return(Xen_false);
}

static Xen gxg_pango_layout_iter_get_run_extents(Xen iter, Xen ink_rect, Xen logical_rect)
{
  #define H_pango_layout_iter_get_run_extents "void pango_layout_iter_get_run_extents(PangoLayoutIter* iter, \
PangoRectangle* ink_rect, PangoRectangle* logical_rect)"
  Xen_check_type(Xen_is_PangoLayoutIter_(iter), iter, 1, "pango_layout_iter_get_run_extents", "PangoLayoutIter*");
  Xen_check_type(Xen_is_PangoRectangle_(ink_rect), ink_rect, 2, "pango_layout_iter_get_run_extents", "PangoRectangle*");
  Xen_check_type(Xen_is_PangoRectangle_(logical_rect), logical_rect, 3, "pango_layout_iter_get_run_extents", "PangoRectangle*");
  pango_layout_iter_get_run_extents(Xen_to_C_PangoLayoutIter_(iter), Xen_to_C_PangoRectangle_(ink_rect), Xen_to_C_PangoRectangle_(logical_rect));
  return(Xen_false);
}

static Xen gxg_pango_layout_iter_get_line_extents(Xen iter, Xen ink_rect, Xen logical_rect)
{
  #define H_pango_layout_iter_get_line_extents "void pango_layout_iter_get_line_extents(PangoLayoutIter* iter, \
PangoRectangle* ink_rect, PangoRectangle* logical_rect)"
  Xen_check_type(Xen_is_PangoLayoutIter_(iter), iter, 1, "pango_layout_iter_get_line_extents", "PangoLayoutIter*");
  Xen_check_type(Xen_is_PangoRectangle_(ink_rect), ink_rect, 2, "pango_layout_iter_get_line_extents", "PangoRectangle*");
  Xen_check_type(Xen_is_PangoRectangle_(logical_rect), logical_rect, 3, "pango_layout_iter_get_line_extents", "PangoRectangle*");
  pango_layout_iter_get_line_extents(Xen_to_C_PangoLayoutIter_(iter), Xen_to_C_PangoRectangle_(ink_rect), Xen_to_C_PangoRectangle_(logical_rect));
  return(Xen_false);
}

static Xen gxg_pango_layout_iter_get_line_yrange(Xen iter, Xen ignore_y0, Xen ignore_y1)
{
  #define H_pango_layout_iter_get_line_yrange "void pango_layout_iter_get_line_yrange(PangoLayoutIter* iter, \
int* [y0], int* [y1])"
  int ref_y0;
  int ref_y1;
  Xen_check_type(Xen_is_PangoLayoutIter_(iter), iter, 1, "pango_layout_iter_get_line_yrange", "PangoLayoutIter*");
  pango_layout_iter_get_line_yrange(Xen_to_C_PangoLayoutIter_(iter), &ref_y0, &ref_y1);
  return(Xen_list_2(C_to_Xen_int(ref_y0), C_to_Xen_int(ref_y1)));
}

static Xen gxg_pango_layout_iter_get_layout_extents(Xen iter, Xen ink_rect, Xen logical_rect)
{
  #define H_pango_layout_iter_get_layout_extents "void pango_layout_iter_get_layout_extents(PangoLayoutIter* iter, \
PangoRectangle* ink_rect, PangoRectangle* logical_rect)"
  Xen_check_type(Xen_is_PangoLayoutIter_(iter), iter, 1, "pango_layout_iter_get_layout_extents", "PangoLayoutIter*");
  Xen_check_type(Xen_is_PangoRectangle_(ink_rect), ink_rect, 2, "pango_layout_iter_get_layout_extents", "PangoRectangle*");
  Xen_check_type(Xen_is_PangoRectangle_(logical_rect), logical_rect, 3, "pango_layout_iter_get_layout_extents", "PangoRectangle*");
  pango_layout_iter_get_layout_extents(Xen_to_C_PangoLayoutIter_(iter), Xen_to_C_PangoRectangle_(ink_rect), Xen_to_C_PangoRectangle_(logical_rect));
  return(Xen_false);
}

static Xen gxg_pango_layout_iter_get_baseline(Xen iter)
{
  #define H_pango_layout_iter_get_baseline "int pango_layout_iter_get_baseline(PangoLayoutIter* iter)"
  Xen_check_type(Xen_is_PangoLayoutIter_(iter), iter, 1, "pango_layout_iter_get_baseline", "PangoLayoutIter*");
  return(C_to_Xen_int(pango_layout_iter_get_baseline(Xen_to_C_PangoLayoutIter_(iter))));
}

static Xen gxg_pango_language_from_string(Xen language)
{
  #define H_pango_language_from_string "PangoLanguage* pango_language_from_string(char* language)"
  Xen_check_type(Xen_is_char_(language), language, 1, "pango_language_from_string", "char*");
  return(C_to_Xen_PangoLanguage_(pango_language_from_string(Xen_to_C_char_(language))));
}

static Xen gxg_pango_language_matches(Xen language, Xen range_list)
{
  #define H_pango_language_matches "gboolean pango_language_matches(PangoLanguage* language, char* range_list)"
  Xen_check_type(Xen_is_PangoLanguage_(language), language, 1, "pango_language_matches", "PangoLanguage*");
  Xen_check_type(Xen_is_char_(range_list), range_list, 2, "pango_language_matches", "char*");
  return(C_to_Xen_gboolean(pango_language_matches(Xen_to_C_PangoLanguage_(language), Xen_to_C_char_(range_list))));
}

static Xen gxg_G_OBJECT_TYPE(Xen object)
{
  #define H_G_OBJECT_TYPE "GType G_OBJECT_TYPE(GObject* object)"
  Xen_check_type(Xen_is_GObject_(object), object, 1, "G_OBJECT_TYPE", "GObject*");
  return(C_to_Xen_GType(G_OBJECT_TYPE(Xen_to_C_GObject_(object))));
}

static Xen gxg_gtk_tree_model_get_string_from_iter(Xen tree_model, Xen iter)
{
  #define H_gtk_tree_model_get_string_from_iter "gchar* gtk_tree_model_get_string_from_iter(GtkTreeModel* tree_model, \
GtkTreeIter* iter)"
  Xen_check_type(Xen_is_GtkTreeModel_(tree_model), tree_model, 1, "gtk_tree_model_get_string_from_iter", "GtkTreeModel*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_tree_model_get_string_from_iter", "GtkTreeIter*");
  {
   gchar* res_ult;
   Xen rtn;
   res_ult = gtk_tree_model_get_string_from_iter(Xen_to_C_GtkTreeModel_(tree_model), Xen_to_C_GtkTreeIter_(iter));
   rtn = C_to_Xen_gchar_(res_ult);
   g_free(res_ult);
   return(rtn);
  }
}

static Xen gxg_gtk_tree_model_sort_iter_is_valid(Xen tree_model_sort, Xen iter)
{
  #define H_gtk_tree_model_sort_iter_is_valid "gboolean gtk_tree_model_sort_iter_is_valid(GtkTreeModelSort* tree_model_sort, \
GtkTreeIter* iter)"
  Xen_check_type(Xen_is_GtkTreeModelSort_(tree_model_sort), tree_model_sort, 1, "gtk_tree_model_sort_iter_is_valid", "GtkTreeModelSort*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_tree_model_sort_iter_is_valid", "GtkTreeIter*");
  return(C_to_Xen_gboolean(gtk_tree_model_sort_iter_is_valid(Xen_to_C_GtkTreeModelSort_(tree_model_sort), Xen_to_C_GtkTreeIter_(iter))));
}

static Xen gxg_gtk_tree_view_expand_to_path(Xen tree_view, Xen path)
{
  #define H_gtk_tree_view_expand_to_path "void gtk_tree_view_expand_to_path(GtkTreeView* tree_view, GtkTreePath* path)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_expand_to_path", "GtkTreeView*");
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 2, "gtk_tree_view_expand_to_path", "GtkTreePath*");
  gtk_tree_view_expand_to_path(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_GtkTreePath_(path));
  return(Xen_false);
}

static Xen gxg_gtk_tree_selection_get_selected_rows(Xen selection, Xen model)
{
  #define H_gtk_tree_selection_get_selected_rows "GList* gtk_tree_selection_get_selected_rows(GtkTreeSelection* selection, \
GtkTreeModel** model)"
  Xen_check_type(Xen_is_GtkTreeSelection_(selection), selection, 1, "gtk_tree_selection_get_selected_rows", "GtkTreeSelection*");
  Xen_check_type(Xen_is_GtkTreeModel__(model), model, 2, "gtk_tree_selection_get_selected_rows", "GtkTreeModel**");
  return(C_to_Xen_GList_(gtk_tree_selection_get_selected_rows(Xen_to_C_GtkTreeSelection_(selection), Xen_to_C_GtkTreeModel__(model))));
}

static Xen gxg_gtk_tree_selection_count_selected_rows(Xen selection)
{
  #define H_gtk_tree_selection_count_selected_rows "int gtk_tree_selection_count_selected_rows(GtkTreeSelection* selection)"
  Xen_check_type(Xen_is_GtkTreeSelection_(selection), selection, 1, "gtk_tree_selection_count_selected_rows", "GtkTreeSelection*");
  return(C_to_Xen_int(gtk_tree_selection_count_selected_rows(Xen_to_C_GtkTreeSelection_(selection))));
}

static Xen gxg_gtk_notebook_get_n_pages(Xen notebook)
{
  #define H_gtk_notebook_get_n_pages "int gtk_notebook_get_n_pages(GtkNotebook* notebook)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_get_n_pages", "GtkNotebook*");
  return(C_to_Xen_int(gtk_notebook_get_n_pages(Xen_to_C_GtkNotebook_(notebook))));
}

static Xen gxg_gtk_list_store_reorder(Xen store, Xen new_order)
{
  #define H_gtk_list_store_reorder "void gtk_list_store_reorder(GtkListStore* store, int* new_order)"
  Xen_check_type(Xen_is_GtkListStore_(store), store, 1, "gtk_list_store_reorder", "GtkListStore*");
  Xen_check_type(Xen_is_int_(new_order), new_order, 2, "gtk_list_store_reorder", "int*");
  gtk_list_store_reorder(Xen_to_C_GtkListStore_(store), Xen_to_C_int_(new_order));
  return(Xen_false);
}

static Xen gxg_gtk_list_store_swap(Xen store, Xen a, Xen b)
{
  #define H_gtk_list_store_swap "void gtk_list_store_swap(GtkListStore* store, GtkTreeIter* a, GtkTreeIter* b)"
  Xen_check_type(Xen_is_GtkListStore_(store), store, 1, "gtk_list_store_swap", "GtkListStore*");
  Xen_check_type(Xen_is_GtkTreeIter_(a), a, 2, "gtk_list_store_swap", "GtkTreeIter*");
  Xen_check_type(Xen_is_GtkTreeIter_(b), b, 3, "gtk_list_store_swap", "GtkTreeIter*");
  gtk_list_store_swap(Xen_to_C_GtkListStore_(store), Xen_to_C_GtkTreeIter_(a), Xen_to_C_GtkTreeIter_(b));
  return(Xen_false);
}

static Xen gxg_gtk_list_store_move_after(Xen store, Xen iter, Xen position)
{
  #define H_gtk_list_store_move_after "void gtk_list_store_move_after(GtkListStore* store, GtkTreeIter* iter, \
GtkTreeIter* position)"
  Xen_check_type(Xen_is_GtkListStore_(store), store, 1, "gtk_list_store_move_after", "GtkListStore*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_list_store_move_after", "GtkTreeIter*");
  Xen_check_type(Xen_is_GtkTreeIter_(position) || Xen_is_false(position), position, 3, "gtk_list_store_move_after", "GtkTreeIter*");
  gtk_list_store_move_after(Xen_to_C_GtkListStore_(store), Xen_to_C_GtkTreeIter_(iter), Xen_to_C_GtkTreeIter_(position));
  return(Xen_false);
}

static Xen gxg_gtk_list_store_move_before(Xen store, Xen iter, Xen position)
{
  #define H_gtk_list_store_move_before "void gtk_list_store_move_before(GtkListStore* store, GtkTreeIter* iter, \
GtkTreeIter* position)"
  Xen_check_type(Xen_is_GtkListStore_(store), store, 1, "gtk_list_store_move_before", "GtkListStore*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_list_store_move_before", "GtkTreeIter*");
  Xen_check_type(Xen_is_GtkTreeIter_(position) || Xen_is_false(position), position, 3, "gtk_list_store_move_before", "GtkTreeIter*");
  gtk_list_store_move_before(Xen_to_C_GtkListStore_(store), Xen_to_C_GtkTreeIter_(iter), Xen_to_C_GtkTreeIter_(position));
  return(Xen_false);
}

static Xen gxg_gtk_tree_store_reorder(Xen tree_store, Xen parent, Xen new_order)
{
  #define H_gtk_tree_store_reorder "void gtk_tree_store_reorder(GtkTreeStore* tree_store, GtkTreeIter* parent, \
int* new_order)"
  Xen_check_type(Xen_is_GtkTreeStore_(tree_store), tree_store, 1, "gtk_tree_store_reorder", "GtkTreeStore*");
  Xen_check_type(Xen_is_GtkTreeIter_(parent), parent, 2, "gtk_tree_store_reorder", "GtkTreeIter*");
  Xen_check_type(Xen_is_int_(new_order), new_order, 3, "gtk_tree_store_reorder", "int*");
  gtk_tree_store_reorder(Xen_to_C_GtkTreeStore_(tree_store), Xen_to_C_GtkTreeIter_(parent), Xen_to_C_int_(new_order));
  return(Xen_false);
}

static Xen gxg_gtk_tree_store_swap(Xen tree_store, Xen a, Xen b)
{
  #define H_gtk_tree_store_swap "void gtk_tree_store_swap(GtkTreeStore* tree_store, GtkTreeIter* a, GtkTreeIter* b)"
  Xen_check_type(Xen_is_GtkTreeStore_(tree_store), tree_store, 1, "gtk_tree_store_swap", "GtkTreeStore*");
  Xen_check_type(Xen_is_GtkTreeIter_(a), a, 2, "gtk_tree_store_swap", "GtkTreeIter*");
  Xen_check_type(Xen_is_GtkTreeIter_(b), b, 3, "gtk_tree_store_swap", "GtkTreeIter*");
  gtk_tree_store_swap(Xen_to_C_GtkTreeStore_(tree_store), Xen_to_C_GtkTreeIter_(a), Xen_to_C_GtkTreeIter_(b));
  return(Xen_false);
}

static Xen gxg_gdk_display_open(Xen display_name)
{
  #define H_gdk_display_open "GdkDisplay* gdk_display_open(gchar* display_name)"
  Xen_check_type(Xen_is_gchar_(display_name), display_name, 1, "gdk_display_open", "gchar*");
  return(C_to_Xen_GdkDisplay_(gdk_display_open(Xen_to_C_gchar_(display_name))));
}

static Xen gxg_gdk_display_get_name(Xen display)
{
  #define H_gdk_display_get_name "gchar* gdk_display_get_name(GdkDisplay* display)"
  Xen_check_type(Xen_is_GdkDisplay_(display), display, 1, "gdk_display_get_name", "GdkDisplay*");
  return(C_to_Xen_gchar_(gdk_display_get_name(Xen_to_C_GdkDisplay_(display))));
}

static Xen gxg_gdk_display_beep(Xen display)
{
  #define H_gdk_display_beep "void gdk_display_beep(GdkDisplay* display)"
  Xen_check_type(Xen_is_GdkDisplay_(display), display, 1, "gdk_display_beep", "GdkDisplay*");
  gdk_display_beep(Xen_to_C_GdkDisplay_(display));
  return(Xen_false);
}

static Xen gxg_gdk_display_sync(Xen display)
{
  #define H_gdk_display_sync "void gdk_display_sync(GdkDisplay* display)"
  Xen_check_type(Xen_is_GdkDisplay_(display), display, 1, "gdk_display_sync", "GdkDisplay*");
  gdk_display_sync(Xen_to_C_GdkDisplay_(display));
  return(Xen_false);
}

static Xen gxg_gdk_display_close(Xen display)
{
  #define H_gdk_display_close "void gdk_display_close(GdkDisplay* display)"
  Xen_check_type(Xen_is_GdkDisplay_(display), display, 1, "gdk_display_close", "GdkDisplay*");
  gdk_display_close(Xen_to_C_GdkDisplay_(display));
  return(Xen_false);
}

static Xen gxg_gdk_display_get_event(Xen display)
{
  #define H_gdk_display_get_event "GdkEvent* gdk_display_get_event(GdkDisplay* display)"
  Xen_check_type(Xen_is_GdkDisplay_(display), display, 1, "gdk_display_get_event", "GdkDisplay*");
  return(C_to_Xen_GdkEvent_(gdk_display_get_event(Xen_to_C_GdkDisplay_(display))));
}

static Xen gxg_gdk_display_peek_event(Xen display)
{
  #define H_gdk_display_peek_event "GdkEvent* gdk_display_peek_event(GdkDisplay* display)"
  Xen_check_type(Xen_is_GdkDisplay_(display), display, 1, "gdk_display_peek_event", "GdkDisplay*");
  return(C_to_Xen_GdkEvent_(gdk_display_peek_event(Xen_to_C_GdkDisplay_(display))));
}

static Xen gxg_gdk_display_put_event(Xen display, Xen event)
{
  #define H_gdk_display_put_event "void gdk_display_put_event(GdkDisplay* display, GdkEvent* event)"
  Xen_check_type(Xen_is_GdkDisplay_(display), display, 1, "gdk_display_put_event", "GdkDisplay*");
  Xen_check_type(Xen_is_GdkEvent_(event), event, 2, "gdk_display_put_event", "GdkEvent*");
  gdk_display_put_event(Xen_to_C_GdkDisplay_(display), Xen_to_C_GdkEvent_(event));
  return(Xen_false);
}

static Xen gxg_gdk_display_get_default(void)
{
  #define H_gdk_display_get_default "GdkDisplay* gdk_display_get_default( void)"
  return(C_to_Xen_GdkDisplay_(gdk_display_get_default()));
}

static Xen gxg_gtk_widget_get_display(Xen widget)
{
  #define H_gtk_widget_get_display "GdkDisplay* gtk_widget_get_display(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_get_display", "GtkWidget*");
  return(C_to_Xen_GdkDisplay_(gtk_widget_get_display(Xen_to_C_GtkWidget_(widget))));
}

static Xen gxg_g_list_free(Xen list)
{
  #define H_g_list_free "void g_list_free(GList* list)"
  Xen_check_type(Xen_is_GList_(list), list, 1, "g_list_free", "GList*");
  g_list_free(Xen_to_C_GList_(list));
  return(Xen_false);
}

static Xen gxg_g_list_reverse(Xen list)
{
  #define H_g_list_reverse "GList* g_list_reverse(GList* list)"
  Xen_check_type(Xen_is_GList_(list) || Xen_is_false(list), list, 1, "g_list_reverse", "GList*");
  return(C_to_Xen_GList_(g_list_reverse(Xen_to_C_GList_(list))));
}

static Xen gxg_g_list_copy(Xen list)
{
  #define H_g_list_copy "GList* g_list_copy(GList* list)"
  Xen_check_type(Xen_is_GList_(list) || Xen_is_false(list), list, 1, "g_list_copy", "GList*");
  return(C_to_Xen_GList_(g_list_copy(Xen_to_C_GList_(list))));
}

static Xen gxg_g_list_last(Xen list)
{
  #define H_g_list_last "GList* g_list_last(GList* list)"
  Xen_check_type(Xen_is_GList_(list), list, 1, "g_list_last", "GList*");
  return(C_to_Xen_GList_(g_list_last(Xen_to_C_GList_(list))));
}

static Xen gxg_g_list_first(Xen list)
{
  #define H_g_list_first "GList* g_list_first(GList* list)"
  Xen_check_type(Xen_is_GList_(list), list, 1, "g_list_first", "GList*");
  return(C_to_Xen_GList_(g_list_first(Xen_to_C_GList_(list))));
}

static Xen gxg_g_list_length(Xen list)
{
  #define H_g_list_length "guint g_list_length(GList* list)"
  Xen_check_type(Xen_is_GList_(list) || Xen_is_false(list), list, 1, "g_list_length", "GList*");
  return(C_to_Xen_guint(g_list_length(Xen_to_C_GList_(list))));
}

static Xen gxg_g_free(Xen mem)
{
  #define H_g_free "void g_free(gpointer mem)"
  Xen_check_type(Xen_is_gpointer(mem), mem, 1, "g_free", "gpointer");
  g_free(Xen_to_C_gpointer(mem));
  return(Xen_false);
}

static Xen gxg_g_list_remove_link(Xen list, Xen llink)
{
  #define H_g_list_remove_link "GList* g_list_remove_link(GList* list, GList* llink)"
  Xen_check_type(Xen_is_GList_(list), list, 1, "g_list_remove_link", "GList*");
  Xen_check_type(Xen_is_GList_(llink), llink, 2, "g_list_remove_link", "GList*");
  return(C_to_Xen_GList_(g_list_remove_link(Xen_to_C_GList_(list), Xen_to_C_GList_(llink))));
}

static Xen gxg_g_object_get_data(Xen object, Xen key)
{
  #define H_g_object_get_data "gpointer g_object_get_data(GObject* object, gchar* key)"
  Xen_check_type(Xen_is_GObject_(object), object, 1, "g_object_get_data", "GObject*");
  Xen_check_type(Xen_is_gchar_(key), key, 2, "g_object_get_data", "gchar*");
  return(C_to_Xen_gpointer(g_object_get_data(Xen_to_C_GObject_(object), (const gchar*)Xen_to_C_gchar_(key))));
}

static Xen gxg_g_object_set_data(Xen object, Xen key, Xen data)
{
  #define H_g_object_set_data "void g_object_set_data(GObject* object, gchar* key, gpointer data)"
  Xen_check_type(Xen_is_GObject_(object), object, 1, "g_object_set_data", "GObject*");
  Xen_check_type(Xen_is_gchar_(key), key, 2, "g_object_set_data", "gchar*");
  Xen_check_type(Xen_is_gpointer(data), data, 3, "g_object_set_data", "gpointer");
  g_object_set_data(Xen_to_C_GObject_(object), (const gchar*)Xen_to_C_gchar_(key), Xen_to_C_gpointer(data));
  return(Xen_false);
}

static Xen gxg_gdk_display_flush(Xen display)
{
  #define H_gdk_display_flush "void gdk_display_flush(GdkDisplay* display)"
  Xen_check_type(Xen_is_GdkDisplay_(display), display, 1, "gdk_display_flush", "GdkDisplay*");
  gdk_display_flush(Xen_to_C_GdkDisplay_(display));
  return(Xen_false);
}

static Xen gxg_gtk_entry_set_completion(Xen entry, Xen completion)
{
  #define H_gtk_entry_set_completion "void gtk_entry_set_completion(GtkEntry* entry, GtkEntryCompletion* completion)"
  Xen_check_type(Xen_is_GtkEntry_(entry), entry, 1, "gtk_entry_set_completion", "GtkEntry*");
  Xen_check_type(Xen_is_GtkEntryCompletion_(completion), completion, 2, "gtk_entry_set_completion", "GtkEntryCompletion*");
  gtk_entry_set_completion(Xen_to_C_GtkEntry_(entry), Xen_to_C_GtkEntryCompletion_(completion));
  return(Xen_false);
}

static Xen gxg_gtk_entry_get_completion(Xen entry)
{
  #define H_gtk_entry_get_completion "GtkEntryCompletion* gtk_entry_get_completion(GtkEntry* entry)"
  Xen_check_type(Xen_is_GtkEntry_(entry), entry, 1, "gtk_entry_get_completion", "GtkEntry*");
  return(C_to_Xen_GtkEntryCompletion_(gtk_entry_get_completion(Xen_to_C_GtkEntry_(entry))));
}

static Xen gxg_gtk_text_buffer_select_range(Xen buffer, Xen ins, Xen bound)
{
  #define H_gtk_text_buffer_select_range "void gtk_text_buffer_select_range(GtkTextBuffer* buffer, GtkTextIter* ins, \
GtkTextIter* bound)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_select_range", "GtkTextBuffer*");
  Xen_check_type(Xen_is_GtkTextIter_(ins), ins, 2, "gtk_text_buffer_select_range", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextIter_(bound), bound, 3, "gtk_text_buffer_select_range", "GtkTextIter*");
  gtk_text_buffer_select_range(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_GtkTextIter_(ins), Xen_to_C_GtkTextIter_(bound));
  return(Xen_false);
}

static Xen gxg_gtk_text_view_set_overwrite(Xen text_view, Xen overwrite)
{
  #define H_gtk_text_view_set_overwrite "void gtk_text_view_set_overwrite(GtkTextView* text_view, gboolean overwrite)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_set_overwrite", "GtkTextView*");
  Xen_check_type(Xen_is_gboolean(overwrite), overwrite, 2, "gtk_text_view_set_overwrite", "gboolean");
  gtk_text_view_set_overwrite(Xen_to_C_GtkTextView_(text_view), Xen_to_C_gboolean(overwrite));
  return(Xen_false);
}

static Xen gxg_gtk_text_view_get_overwrite(Xen text_view)
{
  #define H_gtk_text_view_get_overwrite "gboolean gtk_text_view_get_overwrite(GtkTextView* text_view)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_get_overwrite", "GtkTextView*");
  return(C_to_Xen_gboolean(gtk_text_view_get_overwrite(Xen_to_C_GtkTextView_(text_view))));
}

static Xen gxg_gtk_text_view_set_accepts_tab(Xen text_view, Xen accepts_tab)
{
  #define H_gtk_text_view_set_accepts_tab "void gtk_text_view_set_accepts_tab(GtkTextView* text_view, \
gboolean accepts_tab)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_set_accepts_tab", "GtkTextView*");
  Xen_check_type(Xen_is_gboolean(accepts_tab), accepts_tab, 2, "gtk_text_view_set_accepts_tab", "gboolean");
  gtk_text_view_set_accepts_tab(Xen_to_C_GtkTextView_(text_view), Xen_to_C_gboolean(accepts_tab));
  return(Xen_false);
}

static Xen gxg_gtk_text_view_get_accepts_tab(Xen text_view)
{
  #define H_gtk_text_view_get_accepts_tab "gboolean gtk_text_view_get_accepts_tab(GtkTextView* text_view)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_get_accepts_tab", "GtkTextView*");
  return(C_to_Xen_gboolean(gtk_text_view_get_accepts_tab(Xen_to_C_GtkTextView_(text_view))));
}

static Xen gxg_gtk_tree_view_column_set_expand(Xen tree_column, Xen expand)
{
  #define H_gtk_tree_view_column_set_expand "void gtk_tree_view_column_set_expand(GtkTreeViewColumn* tree_column, \
gboolean expand)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_set_expand", "GtkTreeViewColumn*");
  Xen_check_type(Xen_is_gboolean(expand), expand, 2, "gtk_tree_view_column_set_expand", "gboolean");
  gtk_tree_view_column_set_expand(Xen_to_C_GtkTreeViewColumn_(tree_column), Xen_to_C_gboolean(expand));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_column_get_expand(Xen tree_column)
{
  #define H_gtk_tree_view_column_get_expand "gboolean gtk_tree_view_column_get_expand(GtkTreeViewColumn* tree_column)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_get_expand", "GtkTreeViewColumn*");
  return(C_to_Xen_gboolean(gtk_tree_view_column_get_expand(Xen_to_C_GtkTreeViewColumn_(tree_column))));
}

static Xen gxg_gtk_file_chooser_dialog_new(Xen title, Xen parent, Xen action, Xen buttons)
{
  #define H_gtk_file_chooser_dialog_new "GtkWidget* gtk_file_chooser_dialog_new(gchar* title, GtkWindow* parent, \
GtkFileChooserAction action, etc buttons)"
  Xen_check_type(Xen_is_gchar_(title), title, 1, "gtk_file_chooser_dialog_new", "gchar*");
  Xen_check_type(Xen_is_GtkWindow_(parent) || Xen_is_false(parent), parent, 2, "gtk_file_chooser_dialog_new", "GtkWindow*");
  Xen_check_type(Xen_is_GtkFileChooserAction(action), action, 3, "gtk_file_chooser_dialog_new", "GtkFileChooserAction");
  if (!Xen_is_bound(buttons)) buttons = Xen_false; 
  else Xen_check_type(Xen_is_etc(buttons), buttons, 4, "gtk_file_chooser_dialog_new", "etc");
  {
    int etc_len = 0;
    GtkWidget* res_ult = NULL;
    gchar* p_arg0;
    GtkWindow* p_arg1;
    GtkFileChooserAction p_arg2;
    if (Xen_is_list(buttons)) etc_len = Xen_list_length(buttons);
    if (etc_len > 10) Xen_out_of_range_error("gtk_file_chooser_dialog_new", 3, buttons, "... list too long (max len: 10)");
    if ((etc_len % 2) != 0) Xen_out_of_range_error("gtk_file_chooser_dialog_new", 3, buttons, "... list len must be multiple of 2");
    p_arg0 = Xen_to_C_gchar_(title);
    p_arg1 = Xen_to_C_GtkWindow_(parent);
    p_arg2 = Xen_to_C_GtkFileChooserAction(action);
    switch (etc_len)
      {
        case 0: res_ult = gtk_file_chooser_dialog_new(p_arg0, p_arg1, p_arg2, NULL, NULL); break;
        case 2: res_ult = gtk_file_chooser_dialog_new(p_arg0, p_arg1, p_arg2, XLS(buttons, 0), XLI(buttons, 1), NULL); break;
        case 4: res_ult = gtk_file_chooser_dialog_new(p_arg0, p_arg1, p_arg2, XLS(buttons, 0), XLI(buttons, 1), XLS(buttons, 2), XLI(buttons, 3), NULL); break;
        case 6: res_ult = gtk_file_chooser_dialog_new(p_arg0, p_arg1, p_arg2, XLS(buttons, 0), XLI(buttons, 1), XLS(buttons, 2), XLI(buttons, 3), XLS(buttons, 4), XLI(buttons, 5), NULL); break;
        case 8: res_ult = gtk_file_chooser_dialog_new(p_arg0, p_arg1, p_arg2, XLS(buttons, 0), XLI(buttons, 1), XLS(buttons, 2), XLI(buttons, 3), XLS(buttons, 4), XLI(buttons, 5), XLS(buttons, 6), XLI(buttons, 7), NULL); break;
        case 10: res_ult = gtk_file_chooser_dialog_new(p_arg0, p_arg1, p_arg2, XLS(buttons, 0), XLI(buttons, 1), XLS(buttons, 2), XLI(buttons, 3), XLS(buttons, 4), XLI(buttons, 5), XLS(buttons, 6), XLI(buttons, 7), XLS(buttons, 8), XLI(buttons, 9), NULL); break;
      }
    return(C_to_Xen_GtkWidget_(res_ult));
  }
}

static Xen gxg_gtk_file_chooser_widget_new(Xen action)
{
  #define H_gtk_file_chooser_widget_new "GtkWidget* gtk_file_chooser_widget_new(GtkFileChooserAction action)"
  Xen_check_type(Xen_is_GtkFileChooserAction(action), action, 1, "gtk_file_chooser_widget_new", "GtkFileChooserAction");
  return(C_to_Xen_GtkWidget_(gtk_file_chooser_widget_new(Xen_to_C_GtkFileChooserAction(action))));
}

static Xen gxg_gtk_tree_model_filter_new(Xen child_model, Xen root)
{
  #define H_gtk_tree_model_filter_new "GtkTreeModel* gtk_tree_model_filter_new(GtkTreeModel* child_model, \
GtkTreePath* root)"
  Xen_check_type(Xen_is_GtkTreeModel_(child_model), child_model, 1, "gtk_tree_model_filter_new", "GtkTreeModel*");
  Xen_check_type(Xen_is_GtkTreePath_(root) || Xen_is_false(root), root, 2, "gtk_tree_model_filter_new", "GtkTreePath*");
  return(C_to_Xen_GtkTreeModel_(gtk_tree_model_filter_new(Xen_to_C_GtkTreeModel_(child_model), Xen_to_C_GtkTreePath_(root))));
}

static Xen gxg_gtk_tree_model_filter_set_visible_column(Xen filter, Xen column)
{
  #define H_gtk_tree_model_filter_set_visible_column "void gtk_tree_model_filter_set_visible_column(GtkTreeModelFilter* filter, \
gint column)"
  Xen_check_type(Xen_is_GtkTreeModelFilter_(filter), filter, 1, "gtk_tree_model_filter_set_visible_column", "GtkTreeModelFilter*");
  Xen_check_type(Xen_is_gint(column), column, 2, "gtk_tree_model_filter_set_visible_column", "gint");
  gtk_tree_model_filter_set_visible_column(Xen_to_C_GtkTreeModelFilter_(filter), Xen_to_C_gint(column));
  return(Xen_false);
}

static Xen gxg_gtk_tree_model_filter_get_model(Xen filter)
{
  #define H_gtk_tree_model_filter_get_model "GtkTreeModel* gtk_tree_model_filter_get_model(GtkTreeModelFilter* filter)"
  Xen_check_type(Xen_is_GtkTreeModelFilter_(filter), filter, 1, "gtk_tree_model_filter_get_model", "GtkTreeModelFilter*");
  return(C_to_Xen_GtkTreeModel_(gtk_tree_model_filter_get_model(Xen_to_C_GtkTreeModelFilter_(filter))));
}

static Xen gxg_gtk_tree_model_filter_convert_iter_to_child_iter(Xen filter, Xen child_iter, Xen filter_iter)
{
  #define H_gtk_tree_model_filter_convert_iter_to_child_iter "void gtk_tree_model_filter_convert_iter_to_child_iter(GtkTreeModelFilter* filter, \
GtkTreeIter* child_iter, GtkTreeIter* filter_iter)"
  Xen_check_type(Xen_is_GtkTreeModelFilter_(filter), filter, 1, "gtk_tree_model_filter_convert_iter_to_child_iter", "GtkTreeModelFilter*");
  Xen_check_type(Xen_is_GtkTreeIter_(child_iter), child_iter, 2, "gtk_tree_model_filter_convert_iter_to_child_iter", "GtkTreeIter*");
  Xen_check_type(Xen_is_GtkTreeIter_(filter_iter), filter_iter, 3, "gtk_tree_model_filter_convert_iter_to_child_iter", "GtkTreeIter*");
  gtk_tree_model_filter_convert_iter_to_child_iter(Xen_to_C_GtkTreeModelFilter_(filter), Xen_to_C_GtkTreeIter_(child_iter), 
                                                   Xen_to_C_GtkTreeIter_(filter_iter));
  return(Xen_false);
}

static Xen gxg_gtk_tree_model_filter_convert_child_path_to_path(Xen filter, Xen child_path)
{
  #define H_gtk_tree_model_filter_convert_child_path_to_path "GtkTreePath* gtk_tree_model_filter_convert_child_path_to_path(GtkTreeModelFilter* filter, \
GtkTreePath* child_path)"
  Xen_check_type(Xen_is_GtkTreeModelFilter_(filter), filter, 1, "gtk_tree_model_filter_convert_child_path_to_path", "GtkTreeModelFilter*");
  Xen_check_type(Xen_is_GtkTreePath_(child_path), child_path, 2, "gtk_tree_model_filter_convert_child_path_to_path", "GtkTreePath*");
  return(C_to_Xen_GtkTreePath_(gtk_tree_model_filter_convert_child_path_to_path(Xen_to_C_GtkTreeModelFilter_(filter), Xen_to_C_GtkTreePath_(child_path))));
}

static Xen gxg_gtk_tree_model_filter_convert_path_to_child_path(Xen path, Xen filter_path)
{
  #define H_gtk_tree_model_filter_convert_path_to_child_path "GtkTreePath* gtk_tree_model_filter_convert_path_to_child_path(GtkTreeModelFilter* path, \
GtkTreePath* filter_path)"
  Xen_check_type(Xen_is_GtkTreeModelFilter_(path), path, 1, "gtk_tree_model_filter_convert_path_to_child_path", "GtkTreeModelFilter*");
  Xen_check_type(Xen_is_GtkTreePath_(filter_path), filter_path, 2, "gtk_tree_model_filter_convert_path_to_child_path", "GtkTreePath*");
  return(C_to_Xen_GtkTreePath_(gtk_tree_model_filter_convert_path_to_child_path(Xen_to_C_GtkTreeModelFilter_(path), Xen_to_C_GtkTreePath_(filter_path))));
}

static Xen gxg_gtk_tree_model_filter_refilter(Xen filter)
{
  #define H_gtk_tree_model_filter_refilter "void gtk_tree_model_filter_refilter(GtkTreeModelFilter* filter)"
  Xen_check_type(Xen_is_GtkTreeModelFilter_(filter), filter, 1, "gtk_tree_model_filter_refilter", "GtkTreeModelFilter*");
  gtk_tree_model_filter_refilter(Xen_to_C_GtkTreeModelFilter_(filter));
  return(Xen_false);
}

static Xen gxg_gtk_tree_model_filter_clear_cache(Xen filter)
{
  #define H_gtk_tree_model_filter_clear_cache "void gtk_tree_model_filter_clear_cache(GtkTreeModelFilter* filter)"
  Xen_check_type(Xen_is_GtkTreeModelFilter_(filter), filter, 1, "gtk_tree_model_filter_clear_cache", "GtkTreeModelFilter*");
  gtk_tree_model_filter_clear_cache(Xen_to_C_GtkTreeModelFilter_(filter));
  return(Xen_false);
}

static Xen gxg_gtk_combo_box_new(void)
{
  #define H_gtk_combo_box_new "GtkWidget* gtk_combo_box_new( void)"
  return(C_to_Xen_GtkWidget_(gtk_combo_box_new()));
}

static Xen gxg_gtk_combo_box_new_with_model(Xen model)
{
  #define H_gtk_combo_box_new_with_model "GtkWidget* gtk_combo_box_new_with_model(GtkTreeModel* model)"
  Xen_check_type(Xen_is_GtkTreeModel_(model), model, 1, "gtk_combo_box_new_with_model", "GtkTreeModel*");
  return(C_to_Xen_GtkWidget_(gtk_combo_box_new_with_model(Xen_to_C_GtkTreeModel_(model))));
}

static Xen gxg_gtk_combo_box_set_model(Xen combo_box, Xen model)
{
  #define H_gtk_combo_box_set_model "void gtk_combo_box_set_model(GtkComboBox* combo_box, GtkTreeModel* model)"
  Xen_check_type(Xen_is_GtkComboBox_(combo_box), combo_box, 1, "gtk_combo_box_set_model", "GtkComboBox*");
  Xen_check_type(Xen_is_GtkTreeModel_(model) || Xen_is_false(model), model, 2, "gtk_combo_box_set_model", "GtkTreeModel*");
  gtk_combo_box_set_model(Xen_to_C_GtkComboBox_(combo_box), Xen_to_C_GtkTreeModel_(model));
  return(Xen_false);
}

static Xen gxg_gtk_combo_box_get_active(Xen combo_box)
{
  #define H_gtk_combo_box_get_active "gint gtk_combo_box_get_active(GtkComboBox* combo_box)"
  Xen_check_type(Xen_is_GtkComboBox_(combo_box), combo_box, 1, "gtk_combo_box_get_active", "GtkComboBox*");
  return(C_to_Xen_gint(gtk_combo_box_get_active(Xen_to_C_GtkComboBox_(combo_box))));
}

static Xen gxg_gtk_combo_box_set_active(Xen combo_box, Xen index)
{
  #define H_gtk_combo_box_set_active "void gtk_combo_box_set_active(GtkComboBox* combo_box, gint index)"
  Xen_check_type(Xen_is_GtkComboBox_(combo_box), combo_box, 1, "gtk_combo_box_set_active", "GtkComboBox*");
  Xen_check_type(Xen_is_gint(index), index, 2, "gtk_combo_box_set_active", "gint");
  gtk_combo_box_set_active(Xen_to_C_GtkComboBox_(combo_box), Xen_to_C_gint(index));
  return(Xen_false);
}

static Xen gxg_gtk_combo_box_get_active_iter(Xen combo_box, Xen iter)
{
  #define H_gtk_combo_box_get_active_iter "gboolean gtk_combo_box_get_active_iter(GtkComboBox* combo_box, \
GtkTreeIter* iter)"
  Xen_check_type(Xen_is_GtkComboBox_(combo_box), combo_box, 1, "gtk_combo_box_get_active_iter", "GtkComboBox*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_combo_box_get_active_iter", "GtkTreeIter*");
  return(C_to_Xen_gboolean(gtk_combo_box_get_active_iter(Xen_to_C_GtkComboBox_(combo_box), Xen_to_C_GtkTreeIter_(iter))));
}

static Xen gxg_gtk_combo_box_set_active_iter(Xen combo_box, Xen iter)
{
  #define H_gtk_combo_box_set_active_iter "void gtk_combo_box_set_active_iter(GtkComboBox* combo_box, \
GtkTreeIter* iter)"
  Xen_check_type(Xen_is_GtkComboBox_(combo_box), combo_box, 1, "gtk_combo_box_set_active_iter", "GtkComboBox*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_combo_box_set_active_iter", "GtkTreeIter*");
  gtk_combo_box_set_active_iter(Xen_to_C_GtkComboBox_(combo_box), Xen_to_C_GtkTreeIter_(iter));
  return(Xen_false);
}

static Xen gxg_gtk_combo_box_get_model(Xen combo_box)
{
  #define H_gtk_combo_box_get_model "GtkTreeModel* gtk_combo_box_get_model(GtkComboBox* combo_box)"
  Xen_check_type(Xen_is_GtkComboBox_(combo_box), combo_box, 1, "gtk_combo_box_get_model", "GtkComboBox*");
  return(C_to_Xen_GtkTreeModel_(gtk_combo_box_get_model(Xen_to_C_GtkComboBox_(combo_box))));
}

static Xen gxg_gtk_expander_new(Xen label)
{
  #define H_gtk_expander_new "GtkWidget* gtk_expander_new(gchar* label)"
  Xen_check_type(Xen_is_gchar_(label), label, 1, "gtk_expander_new", "gchar*");
  return(C_to_Xen_GtkWidget_(gtk_expander_new(Xen_to_C_gchar_(label))));
}

static Xen gxg_gtk_expander_new_with_mnemonic(Xen label)
{
  #define H_gtk_expander_new_with_mnemonic "GtkWidget* gtk_expander_new_with_mnemonic(gchar* label)"
  Xen_check_type(Xen_is_gchar_(label), label, 1, "gtk_expander_new_with_mnemonic", "gchar*");
  return(C_to_Xen_GtkWidget_(gtk_expander_new_with_mnemonic(Xen_to_C_gchar_(label))));
}

static Xen gxg_gtk_expander_set_expanded(Xen expander, Xen expanded)
{
  #define H_gtk_expander_set_expanded "void gtk_expander_set_expanded(GtkExpander* expander, gboolean expanded)"
  Xen_check_type(Xen_is_GtkExpander_(expander), expander, 1, "gtk_expander_set_expanded", "GtkExpander*");
  Xen_check_type(Xen_is_gboolean(expanded), expanded, 2, "gtk_expander_set_expanded", "gboolean");
  gtk_expander_set_expanded(Xen_to_C_GtkExpander_(expander), Xen_to_C_gboolean(expanded));
  return(Xen_false);
}

static Xen gxg_gtk_expander_get_expanded(Xen expander)
{
  #define H_gtk_expander_get_expanded "gboolean gtk_expander_get_expanded(GtkExpander* expander)"
  Xen_check_type(Xen_is_GtkExpander_(expander), expander, 1, "gtk_expander_get_expanded", "GtkExpander*");
  return(C_to_Xen_gboolean(gtk_expander_get_expanded(Xen_to_C_GtkExpander_(expander))));
}

static Xen gxg_gtk_expander_set_label(Xen expander, Xen label)
{
  #define H_gtk_expander_set_label "void gtk_expander_set_label(GtkExpander* expander, gchar* label)"
  Xen_check_type(Xen_is_GtkExpander_(expander), expander, 1, "gtk_expander_set_label", "GtkExpander*");
  Xen_check_type(Xen_is_gchar_(label), label, 2, "gtk_expander_set_label", "gchar*");
  gtk_expander_set_label(Xen_to_C_GtkExpander_(expander), Xen_to_C_gchar_(label));
  return(Xen_false);
}

static Xen gxg_gtk_expander_get_label(Xen expander)
{
  #define H_gtk_expander_get_label "gchar* gtk_expander_get_label(GtkExpander* expander)"
  Xen_check_type(Xen_is_GtkExpander_(expander), expander, 1, "gtk_expander_get_label", "GtkExpander*");
  return(C_to_Xen_gchar_(gtk_expander_get_label(Xen_to_C_GtkExpander_(expander))));
}

static Xen gxg_gtk_expander_set_use_underline(Xen expander, Xen use_underline)
{
  #define H_gtk_expander_set_use_underline "void gtk_expander_set_use_underline(GtkExpander* expander, \
gboolean use_underline)"
  Xen_check_type(Xen_is_GtkExpander_(expander), expander, 1, "gtk_expander_set_use_underline", "GtkExpander*");
  Xen_check_type(Xen_is_gboolean(use_underline), use_underline, 2, "gtk_expander_set_use_underline", "gboolean");
  gtk_expander_set_use_underline(Xen_to_C_GtkExpander_(expander), Xen_to_C_gboolean(use_underline));
  return(Xen_false);
}

static Xen gxg_gtk_expander_get_use_underline(Xen expander)
{
  #define H_gtk_expander_get_use_underline "gboolean gtk_expander_get_use_underline(GtkExpander* expander)"
  Xen_check_type(Xen_is_GtkExpander_(expander), expander, 1, "gtk_expander_get_use_underline", "GtkExpander*");
  return(C_to_Xen_gboolean(gtk_expander_get_use_underline(Xen_to_C_GtkExpander_(expander))));
}

static Xen gxg_gtk_expander_set_label_widget(Xen expander, Xen label_widget)
{
  #define H_gtk_expander_set_label_widget "void gtk_expander_set_label_widget(GtkExpander* expander, \
GtkWidget* label_widget)"
  Xen_check_type(Xen_is_GtkExpander_(expander), expander, 1, "gtk_expander_set_label_widget", "GtkExpander*");
  Xen_check_type(Xen_is_GtkWidget_(label_widget), label_widget, 2, "gtk_expander_set_label_widget", "GtkWidget*");
  gtk_expander_set_label_widget(Xen_to_C_GtkExpander_(expander), Xen_to_C_GtkWidget_(label_widget));
  return(Xen_false);
}

static Xen gxg_gtk_expander_get_label_widget(Xen expander)
{
  #define H_gtk_expander_get_label_widget "GtkWidget* gtk_expander_get_label_widget(GtkExpander* expander)"
  Xen_check_type(Xen_is_GtkExpander_(expander), expander, 1, "gtk_expander_get_label_widget", "GtkExpander*");
  return(C_to_Xen_GtkWidget_(gtk_expander_get_label_widget(Xen_to_C_GtkExpander_(expander))));
}

static Xen gxg_gtk_expander_set_use_markup(Xen expander, Xen use_markup)
{
  #define H_gtk_expander_set_use_markup "void gtk_expander_set_use_markup(GtkExpander* expander, gboolean use_markup)"
  Xen_check_type(Xen_is_GtkExpander_(expander), expander, 1, "gtk_expander_set_use_markup", "GtkExpander*");
  Xen_check_type(Xen_is_gboolean(use_markup), use_markup, 2, "gtk_expander_set_use_markup", "gboolean");
  gtk_expander_set_use_markup(Xen_to_C_GtkExpander_(expander), Xen_to_C_gboolean(use_markup));
  return(Xen_false);
}

static Xen gxg_gtk_expander_get_use_markup(Xen expander)
{
  #define H_gtk_expander_get_use_markup "gboolean gtk_expander_get_use_markup(GtkExpander* expander)"
  Xen_check_type(Xen_is_GtkExpander_(expander), expander, 1, "gtk_expander_get_use_markup", "GtkExpander*");
  return(C_to_Xen_gboolean(gtk_expander_get_use_markup(Xen_to_C_GtkExpander_(expander))));
}

static Xen gxg_gtk_font_button_new(void)
{
  #define H_gtk_font_button_new "GtkWidget* gtk_font_button_new( void)"
  return(C_to_Xen_GtkWidget_(gtk_font_button_new()));
}

static Xen gxg_gtk_font_button_new_with_font(Xen fontname)
{
  #define H_gtk_font_button_new_with_font "GtkWidget* gtk_font_button_new_with_font(gchar* fontname)"
  Xen_check_type(Xen_is_gchar_(fontname), fontname, 1, "gtk_font_button_new_with_font", "gchar*");
  return(C_to_Xen_GtkWidget_(gtk_font_button_new_with_font(Xen_to_C_gchar_(fontname))));
}

static Xen gxg_gtk_font_button_get_title(Xen font_button)
{
  #define H_gtk_font_button_get_title "gchar* gtk_font_button_get_title(GtkFontButton* font_button)"
  Xen_check_type(Xen_is_GtkFontButton_(font_button), font_button, 1, "gtk_font_button_get_title", "GtkFontButton*");
  return(C_to_Xen_gchar_(gtk_font_button_get_title(Xen_to_C_GtkFontButton_(font_button))));
}

static Xen gxg_gtk_font_button_set_title(Xen font_button, Xen title)
{
  #define H_gtk_font_button_set_title "void gtk_font_button_set_title(GtkFontButton* font_button, gchar* title)"
  Xen_check_type(Xen_is_GtkFontButton_(font_button), font_button, 1, "gtk_font_button_set_title", "GtkFontButton*");
  Xen_check_type(Xen_is_gchar_(title), title, 2, "gtk_font_button_set_title", "gchar*");
  gtk_font_button_set_title(Xen_to_C_GtkFontButton_(font_button), Xen_to_C_gchar_(title));
  return(Xen_false);
}

static Xen gxg_gtk_font_button_get_use_font(Xen font_button)
{
  #define H_gtk_font_button_get_use_font "gboolean gtk_font_button_get_use_font(GtkFontButton* font_button)"
  Xen_check_type(Xen_is_GtkFontButton_(font_button), font_button, 1, "gtk_font_button_get_use_font", "GtkFontButton*");
  return(C_to_Xen_gboolean(gtk_font_button_get_use_font(Xen_to_C_GtkFontButton_(font_button))));
}

static Xen gxg_gtk_font_button_set_use_font(Xen font_button, Xen use_font)
{
  #define H_gtk_font_button_set_use_font "void gtk_font_button_set_use_font(GtkFontButton* font_button, \
gboolean use_font)"
  Xen_check_type(Xen_is_GtkFontButton_(font_button), font_button, 1, "gtk_font_button_set_use_font", "GtkFontButton*");
  Xen_check_type(Xen_is_gboolean(use_font), use_font, 2, "gtk_font_button_set_use_font", "gboolean");
  gtk_font_button_set_use_font(Xen_to_C_GtkFontButton_(font_button), Xen_to_C_gboolean(use_font));
  return(Xen_false);
}

static Xen gxg_gtk_font_button_get_use_size(Xen font_button)
{
  #define H_gtk_font_button_get_use_size "gboolean gtk_font_button_get_use_size(GtkFontButton* font_button)"
  Xen_check_type(Xen_is_GtkFontButton_(font_button), font_button, 1, "gtk_font_button_get_use_size", "GtkFontButton*");
  return(C_to_Xen_gboolean(gtk_font_button_get_use_size(Xen_to_C_GtkFontButton_(font_button))));
}

static Xen gxg_gtk_font_button_set_use_size(Xen font_button, Xen use_size)
{
  #define H_gtk_font_button_set_use_size "void gtk_font_button_set_use_size(GtkFontButton* font_button, \
gboolean use_size)"
  Xen_check_type(Xen_is_GtkFontButton_(font_button), font_button, 1, "gtk_font_button_set_use_size", "GtkFontButton*");
  Xen_check_type(Xen_is_gboolean(use_size), use_size, 2, "gtk_font_button_set_use_size", "gboolean");
  gtk_font_button_set_use_size(Xen_to_C_GtkFontButton_(font_button), Xen_to_C_gboolean(use_size));
  return(Xen_false);
}

static Xen gxg_gtk_entry_completion_new(void)
{
  #define H_gtk_entry_completion_new "GtkEntryCompletion* gtk_entry_completion_new( void)"
  return(C_to_Xen_GtkEntryCompletion_(gtk_entry_completion_new()));
}

static Xen gxg_gtk_entry_completion_get_entry(Xen entry)
{
  #define H_gtk_entry_completion_get_entry "GtkWidget* gtk_entry_completion_get_entry(GtkEntryCompletion* entry)"
  Xen_check_type(Xen_is_GtkEntryCompletion_(entry), entry, 1, "gtk_entry_completion_get_entry", "GtkEntryCompletion*");
  return(C_to_Xen_GtkWidget_(gtk_entry_completion_get_entry(Xen_to_C_GtkEntryCompletion_(entry))));
}

static Xen gxg_gtk_entry_completion_set_model(Xen completion, Xen model)
{
  #define H_gtk_entry_completion_set_model "void gtk_entry_completion_set_model(GtkEntryCompletion* completion, \
GtkTreeModel* model)"
  Xen_check_type(Xen_is_GtkEntryCompletion_(completion), completion, 1, "gtk_entry_completion_set_model", "GtkEntryCompletion*");
  Xen_check_type(Xen_is_GtkTreeModel_(model) || Xen_is_false(model), model, 2, "gtk_entry_completion_set_model", "GtkTreeModel*");
  gtk_entry_completion_set_model(Xen_to_C_GtkEntryCompletion_(completion), Xen_to_C_GtkTreeModel_(model));
  return(Xen_false);
}

static Xen gxg_gtk_entry_completion_get_model(Xen completion)
{
  #define H_gtk_entry_completion_get_model "GtkTreeModel* gtk_entry_completion_get_model(GtkEntryCompletion* completion)"
  Xen_check_type(Xen_is_GtkEntryCompletion_(completion), completion, 1, "gtk_entry_completion_get_model", "GtkEntryCompletion*");
  return(C_to_Xen_GtkTreeModel_(gtk_entry_completion_get_model(Xen_to_C_GtkEntryCompletion_(completion))));
}

static Xen gxg_gtk_entry_completion_set_match_func(Xen completion, Xen func, Xen func_info, Xen func_notify)
{
  #define H_gtk_entry_completion_set_match_func "void gtk_entry_completion_set_match_func(GtkEntryCompletion* completion, \
GtkEntryCompletionMatchFunc func, lambda_data func_info, GtkDestroyNotify func_notify)"
  Xen_check_type(Xen_is_GtkEntryCompletion_(completion), completion, 1, "gtk_entry_completion_set_match_func", "GtkEntryCompletion*");
  Xen_check_type(Xen_is_GtkEntryCompletionMatchFunc(func), func, 2, "gtk_entry_completion_set_match_func", "GtkEntryCompletionMatchFunc");
  Xen_check_type(Xen_is_lambda_data(func_info) || Xen_is_false(func_info), func_info, 3, "gtk_entry_completion_set_match_func", "lambda_data");
  Xen_check_type(Xen_is_GtkDestroyNotify(func_notify), func_notify, 4, "gtk_entry_completion_set_match_func", "GtkDestroyNotify");
  {
    Xen gxg_ptr = Xen_list_5(func, func_info, Xen_false, Xen_false, Xen_false);
    xm_protect(gxg_ptr);
    Xen_list_set(gxg_ptr, 3, func_notify);
    gtk_entry_completion_set_match_func(Xen_to_C_GtkEntryCompletion_(completion), Xen_to_C_GtkEntryCompletionMatchFunc(func), 
                                    Xen_to_C_lambda_data(func_info), Xen_to_C_GtkDestroyNotify(func_notify));
    return(Xen_false);
   }
}

static Xen gxg_gtk_entry_completion_set_minimum_key_length(Xen completion, Xen length)
{
  #define H_gtk_entry_completion_set_minimum_key_length "void gtk_entry_completion_set_minimum_key_length(GtkEntryCompletion* completion, \
gint length)"
  Xen_check_type(Xen_is_GtkEntryCompletion_(completion), completion, 1, "gtk_entry_completion_set_minimum_key_length", "GtkEntryCompletion*");
  Xen_check_type(Xen_is_gint(length), length, 2, "gtk_entry_completion_set_minimum_key_length", "gint");
  gtk_entry_completion_set_minimum_key_length(Xen_to_C_GtkEntryCompletion_(completion), Xen_to_C_gint(length));
  return(Xen_false);
}

static Xen gxg_gtk_entry_completion_get_minimum_key_length(Xen completion)
{
  #define H_gtk_entry_completion_get_minimum_key_length "gint gtk_entry_completion_get_minimum_key_length(GtkEntryCompletion* completion)"
  Xen_check_type(Xen_is_GtkEntryCompletion_(completion), completion, 1, "gtk_entry_completion_get_minimum_key_length", "GtkEntryCompletion*");
  return(C_to_Xen_gint(gtk_entry_completion_get_minimum_key_length(Xen_to_C_GtkEntryCompletion_(completion))));
}

static Xen gxg_gtk_entry_completion_complete(Xen completion)
{
  #define H_gtk_entry_completion_complete "void gtk_entry_completion_complete(GtkEntryCompletion* completion)"
  Xen_check_type(Xen_is_GtkEntryCompletion_(completion), completion, 1, "gtk_entry_completion_complete", "GtkEntryCompletion*");
  gtk_entry_completion_complete(Xen_to_C_GtkEntryCompletion_(completion));
  return(Xen_false);
}

static Xen gxg_gtk_entry_completion_insert_action_text(Xen completion, Xen index, Xen text)
{
  #define H_gtk_entry_completion_insert_action_text "void gtk_entry_completion_insert_action_text(GtkEntryCompletion* completion, \
gint index, gchar* text)"
  Xen_check_type(Xen_is_GtkEntryCompletion_(completion), completion, 1, "gtk_entry_completion_insert_action_text", "GtkEntryCompletion*");
  Xen_check_type(Xen_is_gint(index), index, 2, "gtk_entry_completion_insert_action_text", "gint");
  Xen_check_type(Xen_is_gchar_(text), text, 3, "gtk_entry_completion_insert_action_text", "gchar*");
  gtk_entry_completion_insert_action_text(Xen_to_C_GtkEntryCompletion_(completion), Xen_to_C_gint(index), Xen_to_C_gchar_(text));
  return(Xen_false);
}

static Xen gxg_gtk_entry_completion_insert_action_markup(Xen completion, Xen index, Xen markup)
{
  #define H_gtk_entry_completion_insert_action_markup "void gtk_entry_completion_insert_action_markup(GtkEntryCompletion* completion, \
gint index, gchar* markup)"
  Xen_check_type(Xen_is_GtkEntryCompletion_(completion), completion, 1, "gtk_entry_completion_insert_action_markup", "GtkEntryCompletion*");
  Xen_check_type(Xen_is_gint(index), index, 2, "gtk_entry_completion_insert_action_markup", "gint");
  Xen_check_type(Xen_is_gchar_(markup), markup, 3, "gtk_entry_completion_insert_action_markup", "gchar*");
  gtk_entry_completion_insert_action_markup(Xen_to_C_GtkEntryCompletion_(completion), Xen_to_C_gint(index), Xen_to_C_gchar_(markup));
  return(Xen_false);
}

static Xen gxg_gtk_entry_completion_delete_action(Xen completion, Xen index)
{
  #define H_gtk_entry_completion_delete_action "void gtk_entry_completion_delete_action(GtkEntryCompletion* completion, \
gint index)"
  Xen_check_type(Xen_is_GtkEntryCompletion_(completion), completion, 1, "gtk_entry_completion_delete_action", "GtkEntryCompletion*");
  Xen_check_type(Xen_is_gint(index), index, 2, "gtk_entry_completion_delete_action", "gint");
  gtk_entry_completion_delete_action(Xen_to_C_GtkEntryCompletion_(completion), Xen_to_C_gint(index));
  return(Xen_false);
}

static Xen gxg_gtk_entry_completion_set_text_column(Xen completion, Xen column)
{
  #define H_gtk_entry_completion_set_text_column "void gtk_entry_completion_set_text_column(GtkEntryCompletion* completion, \
gint column)"
  Xen_check_type(Xen_is_GtkEntryCompletion_(completion), completion, 1, "gtk_entry_completion_set_text_column", "GtkEntryCompletion*");
  Xen_check_type(Xen_is_gint(column), column, 2, "gtk_entry_completion_set_text_column", "gint");
  gtk_entry_completion_set_text_column(Xen_to_C_GtkEntryCompletion_(completion), Xen_to_C_gint(column));
  return(Xen_false);
}

static Xen gxg_g_timeout_add_full(Xen priority, Xen interval, Xen func, Xen func_info, Xen notify)
{
  #define H_g_timeout_add_full "guint g_timeout_add_full(gint priority, guint interval, GSourceFunc func, \
lambda_data func_info, GtkDestroyNotify notify)"
  Xen_check_type(Xen_is_gint(priority), priority, 1, "g_timeout_add_full", "gint");
  Xen_check_type(Xen_is_guint(interval), interval, 2, "g_timeout_add_full", "guint");
  Xen_check_type(Xen_is_GSourceFunc(func), func, 3, "g_timeout_add_full", "GSourceFunc");
  Xen_check_type(Xen_is_lambda_data(func_info) || Xen_is_false(func_info), func_info, 4, "g_timeout_add_full", "lambda_data");
  Xen_check_type(Xen_is_GtkDestroyNotify(notify), notify, 5, "g_timeout_add_full", "GtkDestroyNotify");
  {
    Xen res_ult;
    int loc;
    Xen gxg_ptr = Xen_list_5(func, func_info, Xen_false, Xen_false, Xen_false);
    loc = xm_protect(gxg_ptr);
    Xen_list_set(gxg_ptr, 2, C_int_to_Xen_integer(loc));
    Xen_list_set(gxg_ptr, 3, notify);
    res_ult = C_to_Xen_guint(g_timeout_add_full(Xen_to_C_gint(priority), Xen_to_C_guint(interval), Xen_to_C_GSourceFunc(func), 
                                                Xen_to_C_lambda_data(func_info), Xen_to_C_GtkDestroyNotify(notify)));
    Xen_list_set(gxg_ptr, 2, Xen_list_3(xg_idler_symbol, res_ult, C_int_to_Xen_integer(loc)));
    return(res_ult);
   }
}

static Xen gxg_g_timeout_add(Xen interval, Xen func, Xen func_info)
{
  #define H_g_timeout_add "guint g_timeout_add(guint interval, GSourceFunc func, lambda_data func_info)"
  Xen_check_type(Xen_is_guint(interval), interval, 1, "g_timeout_add", "guint");
  Xen_check_type(Xen_is_GSourceFunc(func), func, 2, "g_timeout_add", "GSourceFunc");
  Xen_check_type(Xen_is_lambda_data(func_info) || Xen_is_false(func_info), func_info, 3, "g_timeout_add", "lambda_data");
  {
    Xen res_ult;
    int loc;
    Xen gxg_ptr = Xen_list_5(func, func_info, Xen_false, Xen_false, Xen_false);
    loc = xm_protect(gxg_ptr);
    Xen_list_set(gxg_ptr, 2, C_int_to_Xen_integer(loc));
    res_ult = C_to_Xen_guint(g_timeout_add(Xen_to_C_guint(interval), Xen_to_C_GSourceFunc(func), Xen_to_C_lambda_data(func_info)));
    Xen_list_set(gxg_ptr, 2, Xen_list_3(xg_idler_symbol, res_ult, C_int_to_Xen_integer(loc)));
    return(res_ult);
   }
}

static Xen gxg_g_idle_add(Xen func, Xen func_info)
{
  #define H_g_idle_add "guint g_idle_add(GSourceFunc func, lambda_data func_info)"
  Xen_check_type(Xen_is_GSourceFunc(func), func, 1, "g_idle_add", "GSourceFunc");
  Xen_check_type(Xen_is_lambda_data(func_info) || Xen_is_false(func_info), func_info, 2, "g_idle_add", "lambda_data");
  {
    Xen res_ult;
    int loc;
    Xen gxg_ptr = Xen_list_5(func, func_info, Xen_false, Xen_false, Xen_false);
    loc = xm_protect(gxg_ptr);
    Xen_list_set(gxg_ptr, 2, C_int_to_Xen_integer(loc));
    res_ult = C_to_Xen_guint(g_idle_add(Xen_to_C_GSourceFunc(func), Xen_to_C_lambda_data(func_info)));
    Xen_list_set(gxg_ptr, 2, Xen_list_3(xg_idler_symbol, res_ult, C_int_to_Xen_integer(loc)));
    return(res_ult);
   }
}

static Xen gxg_g_idle_add_full(Xen priority, Xen func, Xen func_info, Xen notify)
{
  #define H_g_idle_add_full "guint g_idle_add_full(gint priority, GSourceFunc func, lambda_data func_info, \
GtkDestroyNotify notify)"
  Xen_check_type(Xen_is_gint(priority), priority, 1, "g_idle_add_full", "gint");
  Xen_check_type(Xen_is_GSourceFunc(func), func, 2, "g_idle_add_full", "GSourceFunc");
  Xen_check_type(Xen_is_lambda_data(func_info) || Xen_is_false(func_info), func_info, 3, "g_idle_add_full", "lambda_data");
  Xen_check_type(Xen_is_GtkDestroyNotify(notify), notify, 4, "g_idle_add_full", "GtkDestroyNotify");
  {
    Xen res_ult;
    int loc;
    Xen gxg_ptr = Xen_list_5(func, func_info, Xen_false, Xen_false, Xen_false);
    loc = xm_protect(gxg_ptr);
    Xen_list_set(gxg_ptr, 2, C_int_to_Xen_integer(loc));
    Xen_list_set(gxg_ptr, 3, notify);
    res_ult = C_to_Xen_guint(g_idle_add_full(Xen_to_C_gint(priority), Xen_to_C_GSourceFunc(func), Xen_to_C_lambda_data(func_info), 
                                             Xen_to_C_GtkDestroyNotify(notify)));
    Xen_list_set(gxg_ptr, 2, Xen_list_3(xg_idler_symbol, res_ult, C_int_to_Xen_integer(loc)));
    return(res_ult);
   }
}

static Xen gxg_g_idle_remove_by_data(Xen data)
{
  #define H_g_idle_remove_by_data "gboolean g_idle_remove_by_data(gpointer data)"
  Xen_check_type(Xen_is_gpointer(data), data, 1, "g_idle_remove_by_data", "gpointer");
  xm_unprotect_at(Xen_integer_to_C_int(Xen_caddr(data)));
  return(C_to_Xen_gboolean(g_idle_remove_by_data(Xen_to_C_gpointer(data))));
}

static Xen gxg_g_source_remove(Xen tag)
{
  #define H_g_source_remove "gboolean g_source_remove(guint tag)"
  Xen_check_type(Xen_is_guint(tag), tag, 1, "g_source_remove", "guint");
  xm_unprotect_at(Xen_integer_to_C_int(Xen_caddr(tag)));
  return(C_to_Xen_gboolean(g_source_remove(Xen_to_C_guint(tag))));
}

static Xen gxg_gtk_file_filter_new(void)
{
  #define H_gtk_file_filter_new "GtkFileFilter* gtk_file_filter_new( void)"
  return(C_to_Xen_GtkFileFilter_(gtk_file_filter_new()));
}

static Xen gxg_gtk_file_filter_set_name(Xen filter, Xen name)
{
  #define H_gtk_file_filter_set_name "void gtk_file_filter_set_name(GtkFileFilter* filter, gchar* name)"
  Xen_check_type(Xen_is_GtkFileFilter_(filter), filter, 1, "gtk_file_filter_set_name", "GtkFileFilter*");
  Xen_check_type(Xen_is_gchar_(name), name, 2, "gtk_file_filter_set_name", "gchar*");
  gtk_file_filter_set_name(Xen_to_C_GtkFileFilter_(filter), Xen_to_C_gchar_(name));
  return(Xen_false);
}

static Xen gxg_gtk_file_filter_get_name(Xen filter)
{
  #define H_gtk_file_filter_get_name "gchar* gtk_file_filter_get_name(GtkFileFilter* filter)"
  Xen_check_type(Xen_is_GtkFileFilter_(filter), filter, 1, "gtk_file_filter_get_name", "GtkFileFilter*");
  return(C_to_Xen_gchar_(gtk_file_filter_get_name(Xen_to_C_GtkFileFilter_(filter))));
}

static Xen gxg_gtk_file_filter_add_mime_type(Xen filter, Xen mime_type)
{
  #define H_gtk_file_filter_add_mime_type "void gtk_file_filter_add_mime_type(GtkFileFilter* filter, \
gchar* mime_type)"
  Xen_check_type(Xen_is_GtkFileFilter_(filter), filter, 1, "gtk_file_filter_add_mime_type", "GtkFileFilter*");
  Xen_check_type(Xen_is_gchar_(mime_type), mime_type, 2, "gtk_file_filter_add_mime_type", "gchar*");
  gtk_file_filter_add_mime_type(Xen_to_C_GtkFileFilter_(filter), Xen_to_C_gchar_(mime_type));
  return(Xen_false);
}

static Xen gxg_gtk_file_filter_add_pattern(Xen filter, Xen pattern)
{
  #define H_gtk_file_filter_add_pattern "void gtk_file_filter_add_pattern(GtkFileFilter* filter, gchar* pattern)"
  Xen_check_type(Xen_is_GtkFileFilter_(filter), filter, 1, "gtk_file_filter_add_pattern", "GtkFileFilter*");
  Xen_check_type(Xen_is_gchar_(pattern), pattern, 2, "gtk_file_filter_add_pattern", "gchar*");
  gtk_file_filter_add_pattern(Xen_to_C_GtkFileFilter_(filter), Xen_to_C_gchar_(pattern));
  return(Xen_false);
}

static Xen gxg_gtk_file_filter_add_custom(Xen filter, Xen needed, Xen func, Xen func_info, Xen notify)
{
  #define H_gtk_file_filter_add_custom "void gtk_file_filter_add_custom(GtkFileFilter* filter, GtkFileFilterFlags needed, \
GtkFileFilterFunc func, lambda_data func_info, GtkDestroyNotify notify)"
  Xen_check_type(Xen_is_GtkFileFilter_(filter), filter, 1, "gtk_file_filter_add_custom", "GtkFileFilter*");
  Xen_check_type(Xen_is_GtkFileFilterFlags(needed), needed, 2, "gtk_file_filter_add_custom", "GtkFileFilterFlags");
  Xen_check_type(Xen_is_GtkFileFilterFunc(func), func, 3, "gtk_file_filter_add_custom", "GtkFileFilterFunc");
  Xen_check_type(Xen_is_lambda_data(func_info) || Xen_is_false(func_info), func_info, 4, "gtk_file_filter_add_custom", "lambda_data");
  Xen_check_type(Xen_is_GtkDestroyNotify(notify), notify, 5, "gtk_file_filter_add_custom", "GtkDestroyNotify");
  {
    Xen gxg_ptr = Xen_list_5(func, func_info, Xen_false, Xen_false, Xen_false);
    xm_protect(gxg_ptr);
    Xen_list_set(gxg_ptr, 3, notify);
    gtk_file_filter_add_custom(Xen_to_C_GtkFileFilter_(filter), Xen_to_C_GtkFileFilterFlags(needed), Xen_to_C_GtkFileFilterFunc(func), 
                           Xen_to_C_lambda_data(func_info), Xen_to_C_GtkDestroyNotify(notify));
    return(Xen_false);
   }
}

static Xen gxg_gtk_file_filter_get_needed(Xen filter)
{
  #define H_gtk_file_filter_get_needed "GtkFileFilterFlags gtk_file_filter_get_needed(GtkFileFilter* filter)"
  Xen_check_type(Xen_is_GtkFileFilter_(filter), filter, 1, "gtk_file_filter_get_needed", "GtkFileFilter*");
  return(C_to_Xen_GtkFileFilterFlags(gtk_file_filter_get_needed(Xen_to_C_GtkFileFilter_(filter))));
}

static Xen gxg_gtk_file_filter_filter(Xen filter, Xen filter_info)
{
  #define H_gtk_file_filter_filter "gboolean gtk_file_filter_filter(GtkFileFilter* filter, GtkFileFilterInfo* filter_info)"
  Xen_check_type(Xen_is_GtkFileFilter_(filter), filter, 1, "gtk_file_filter_filter", "GtkFileFilter*");
  Xen_check_type(Xen_is_GtkFileFilterInfo_(filter_info), filter_info, 2, "gtk_file_filter_filter", "GtkFileFilterInfo*");
  return(C_to_Xen_gboolean(gtk_file_filter_filter(Xen_to_C_GtkFileFilter_(filter), Xen_to_C_GtkFileFilterInfo_(filter_info))));
}

static Xen gxg_gtk_cell_layout_pack_start(Xen cell_layout, Xen cell, Xen expand)
{
  #define H_gtk_cell_layout_pack_start "void gtk_cell_layout_pack_start(GtkCellLayout* cell_layout, GtkCellRenderer* cell, \
gboolean expand)"
  Xen_check_type(Xen_is_GtkCellLayout_(cell_layout), cell_layout, 1, "gtk_cell_layout_pack_start", "GtkCellLayout*");
  Xen_check_type(Xen_is_GtkCellRenderer_(cell), cell, 2, "gtk_cell_layout_pack_start", "GtkCellRenderer*");
  Xen_check_type(Xen_is_gboolean(expand), expand, 3, "gtk_cell_layout_pack_start", "gboolean");
  gtk_cell_layout_pack_start(Xen_to_C_GtkCellLayout_(cell_layout), Xen_to_C_GtkCellRenderer_(cell), Xen_to_C_gboolean(expand));
  return(Xen_false);
}

static Xen gxg_gtk_cell_layout_pack_end(Xen cell_layout, Xen cell, Xen expand)
{
  #define H_gtk_cell_layout_pack_end "void gtk_cell_layout_pack_end(GtkCellLayout* cell_layout, GtkCellRenderer* cell, \
gboolean expand)"
  Xen_check_type(Xen_is_GtkCellLayout_(cell_layout), cell_layout, 1, "gtk_cell_layout_pack_end", "GtkCellLayout*");
  Xen_check_type(Xen_is_GtkCellRenderer_(cell), cell, 2, "gtk_cell_layout_pack_end", "GtkCellRenderer*");
  Xen_check_type(Xen_is_gboolean(expand), expand, 3, "gtk_cell_layout_pack_end", "gboolean");
  gtk_cell_layout_pack_end(Xen_to_C_GtkCellLayout_(cell_layout), Xen_to_C_GtkCellRenderer_(cell), Xen_to_C_gboolean(expand));
  return(Xen_false);
}

static Xen gxg_gtk_cell_layout_clear(Xen cell_layout)
{
  #define H_gtk_cell_layout_clear "void gtk_cell_layout_clear(GtkCellLayout* cell_layout)"
  Xen_check_type(Xen_is_GtkCellLayout_(cell_layout), cell_layout, 1, "gtk_cell_layout_clear", "GtkCellLayout*");
  gtk_cell_layout_clear(Xen_to_C_GtkCellLayout_(cell_layout));
  return(Xen_false);
}

static Xen gxg_gtk_cell_layout_set_attributes(Xen cell_layout, Xen cell, Xen attributes)
{
  #define H_gtk_cell_layout_set_attributes "void gtk_cell_layout_set_attributes(GtkCellLayout* cell_layout, \
GtkCellRenderer* cell, etc attributes)"
  Xen_check_type(Xen_is_GtkCellLayout_(cell_layout), cell_layout, 1, "gtk_cell_layout_set_attributes", "GtkCellLayout*");
  Xen_check_type(Xen_is_GtkCellRenderer_(cell), cell, 2, "gtk_cell_layout_set_attributes", "GtkCellRenderer*");
  Xen_check_type(Xen_is_etc(attributes), attributes, 3, "gtk_cell_layout_set_attributes", "etc");
  {
    int etc_len = 0;
    GtkCellLayout* p_arg0;
    GtkCellRenderer* p_arg1;
    if (Xen_is_list(attributes)) etc_len = Xen_list_length(attributes);
    if (etc_len < 2) Xen_out_of_range_error("gtk_cell_layout_set_attributes", 2, attributes, "... list must have at least 2 entries");
    if (etc_len > 10) Xen_out_of_range_error("gtk_cell_layout_set_attributes", 2, attributes, "... list too long (max len: 10)");
    if ((etc_len % 2) != 0) Xen_out_of_range_error("gtk_cell_layout_set_attributes", 2, attributes, "... list len must be multiple of 2");
    p_arg0 = Xen_to_C_GtkCellLayout_(cell_layout);
    p_arg1 = Xen_to_C_GtkCellRenderer_(cell);
    switch (etc_len)
      {
        case 2: gtk_cell_layout_set_attributes(p_arg0, p_arg1, XLS(attributes, 0), XLI(attributes, 1), NULL); break;
        case 4: gtk_cell_layout_set_attributes(p_arg0, p_arg1, XLS(attributes, 0), XLI(attributes, 1), XLS(attributes, 2), XLI(attributes, 3), NULL); break;
        case 6: gtk_cell_layout_set_attributes(p_arg0, p_arg1, XLS(attributes, 0), XLI(attributes, 1), XLS(attributes, 2), XLI(attributes, 3), XLS(attributes, 4), XLI(attributes, 5), NULL); break;
        case 8: gtk_cell_layout_set_attributes(p_arg0, p_arg1, XLS(attributes, 0), XLI(attributes, 1), XLS(attributes, 2), XLI(attributes, 3), XLS(attributes, 4), XLI(attributes, 5), XLS(attributes, 6), XLI(attributes, 7), NULL); break;
        case 10: gtk_cell_layout_set_attributes(p_arg0, p_arg1, XLS(attributes, 0), XLI(attributes, 1), XLS(attributes, 2), XLI(attributes, 3), XLS(attributes, 4), XLI(attributes, 5), XLS(attributes, 6), XLI(attributes, 7), XLS(attributes, 8), XLI(attributes, 9), NULL); break;
      }
    return(Xen_false);
  }
}

static Xen gxg_gtk_cell_layout_add_attribute(Xen cell_layout, Xen cell, Xen attribute, Xen column)
{
  #define H_gtk_cell_layout_add_attribute "void gtk_cell_layout_add_attribute(GtkCellLayout* cell_layout, \
GtkCellRenderer* cell, gchar* attribute, gint column)"
  Xen_check_type(Xen_is_GtkCellLayout_(cell_layout), cell_layout, 1, "gtk_cell_layout_add_attribute", "GtkCellLayout*");
  Xen_check_type(Xen_is_GtkCellRenderer_(cell), cell, 2, "gtk_cell_layout_add_attribute", "GtkCellRenderer*");
  Xen_check_type(Xen_is_gchar_(attribute), attribute, 3, "gtk_cell_layout_add_attribute", "gchar*");
  Xen_check_type(Xen_is_gint(column), column, 4, "gtk_cell_layout_add_attribute", "gint");
  gtk_cell_layout_add_attribute(Xen_to_C_GtkCellLayout_(cell_layout), Xen_to_C_GtkCellRenderer_(cell), Xen_to_C_gchar_(attribute), 
                                Xen_to_C_gint(column));
  return(Xen_false);
}

static Xen gxg_gtk_cell_layout_set_cell_data_func(Xen cell_layout, Xen cell, Xen func, Xen func_info, Xen destroy)
{
  #define H_gtk_cell_layout_set_cell_data_func "void gtk_cell_layout_set_cell_data_func(GtkCellLayout* cell_layout, \
GtkCellRenderer* cell, GtkCellLayoutDataFunc func, lambda_data func_info, GtkDestroyNotify destroy)"
  Xen_check_type(Xen_is_GtkCellLayout_(cell_layout), cell_layout, 1, "gtk_cell_layout_set_cell_data_func", "GtkCellLayout*");
  Xen_check_type(Xen_is_GtkCellRenderer_(cell), cell, 2, "gtk_cell_layout_set_cell_data_func", "GtkCellRenderer*");
  Xen_check_type(Xen_is_GtkCellLayoutDataFunc(func), func, 3, "gtk_cell_layout_set_cell_data_func", "GtkCellLayoutDataFunc");
  Xen_check_type(Xen_is_lambda_data(func_info) || Xen_is_false(func_info), func_info, 4, "gtk_cell_layout_set_cell_data_func", "lambda_data");
  Xen_check_type(Xen_is_GtkDestroyNotify(destroy), destroy, 5, "gtk_cell_layout_set_cell_data_func", "GtkDestroyNotify");
  {
    Xen gxg_ptr = Xen_list_5(func, func_info, Xen_false, Xen_false, Xen_false);
    xm_protect(gxg_ptr);
    Xen_list_set(gxg_ptr, 3, destroy);
    gtk_cell_layout_set_cell_data_func(Xen_to_C_GtkCellLayout_(cell_layout), Xen_to_C_GtkCellRenderer_(cell), Xen_to_C_GtkCellLayoutDataFunc(func), 
                                   Xen_to_C_lambda_data(func_info), Xen_to_C_GtkDestroyNotify(destroy));
    return(Xen_false);
   }
}

static Xen gxg_gtk_cell_layout_clear_attributes(Xen cell_layout, Xen cell)
{
  #define H_gtk_cell_layout_clear_attributes "void gtk_cell_layout_clear_attributes(GtkCellLayout* cell_layout, \
GtkCellRenderer* cell)"
  Xen_check_type(Xen_is_GtkCellLayout_(cell_layout), cell_layout, 1, "gtk_cell_layout_clear_attributes", "GtkCellLayout*");
  Xen_check_type(Xen_is_GtkCellRenderer_(cell), cell, 2, "gtk_cell_layout_clear_attributes", "GtkCellRenderer*");
  gtk_cell_layout_clear_attributes(Xen_to_C_GtkCellLayout_(cell_layout), Xen_to_C_GtkCellRenderer_(cell));
  return(Xen_false);
}

static Xen gxg_gtk_file_chooser_set_action(Xen chooser, Xen action)
{
  #define H_gtk_file_chooser_set_action "void gtk_file_chooser_set_action(GtkFileChooser* chooser, GtkFileChooserAction action)"
  Xen_check_type(Xen_is_GtkFileChooser_(chooser), chooser, 1, "gtk_file_chooser_set_action", "GtkFileChooser*");
  Xen_check_type(Xen_is_GtkFileChooserAction(action), action, 2, "gtk_file_chooser_set_action", "GtkFileChooserAction");
  gtk_file_chooser_set_action(Xen_to_C_GtkFileChooser_(chooser), Xen_to_C_GtkFileChooserAction(action));
  return(Xen_false);
}

static Xen gxg_gtk_file_chooser_get_action(Xen chooser)
{
  #define H_gtk_file_chooser_get_action "GtkFileChooserAction gtk_file_chooser_get_action(GtkFileChooser* chooser)"
  Xen_check_type(Xen_is_GtkFileChooser_(chooser), chooser, 1, "gtk_file_chooser_get_action", "GtkFileChooser*");
  return(C_to_Xen_GtkFileChooserAction(gtk_file_chooser_get_action(Xen_to_C_GtkFileChooser_(chooser))));
}

static Xen gxg_gtk_list_store_remove(Xen list_store, Xen iter)
{
  #define H_gtk_list_store_remove "gboolean gtk_list_store_remove(GtkListStore* list_store, GtkTreeIter* iter)"
  Xen_check_type(Xen_is_GtkListStore_(list_store), list_store, 1, "gtk_list_store_remove", "GtkListStore*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_list_store_remove", "GtkTreeIter*");
  return(C_to_Xen_gboolean(gtk_list_store_remove(Xen_to_C_GtkListStore_(list_store), Xen_to_C_GtkTreeIter_(iter))));
}

static Xen gxg_gtk_cell_layout_reorder(Xen cell_layout, Xen cell, Xen position)
{
  #define H_gtk_cell_layout_reorder "void gtk_cell_layout_reorder(GtkCellLayout* cell_layout, GtkCellRenderer* cell, \
gint position)"
  Xen_check_type(Xen_is_GtkCellLayout_(cell_layout), cell_layout, 1, "gtk_cell_layout_reorder", "GtkCellLayout*");
  Xen_check_type(Xen_is_GtkCellRenderer_(cell), cell, 2, "gtk_cell_layout_reorder", "GtkCellRenderer*");
  Xen_check_type(Xen_is_gint(position), position, 3, "gtk_cell_layout_reorder", "gint");
  gtk_cell_layout_reorder(Xen_to_C_GtkCellLayout_(cell_layout), Xen_to_C_GtkCellRenderer_(cell), Xen_to_C_gint(position));
  return(Xen_false);
}

static Xen gxg_g_list_nth_data(Xen list, Xen n)
{
  #define H_g_list_nth_data "gpointer g_list_nth_data(GList* list, guint n)"
  Xen_check_type(Xen_is_GList_(list), list, 1, "g_list_nth_data", "GList*");
  Xen_check_type(Xen_is_guint(n), n, 2, "g_list_nth_data", "guint");
  return(C_to_Xen_gpointer(g_list_nth_data(Xen_to_C_GList_(list), Xen_to_C_guint(n))));
}

static Xen gxg_gtk_combo_box_popup(Xen combo_box)
{
  #define H_gtk_combo_box_popup "void gtk_combo_box_popup(GtkComboBox* combo_box)"
  Xen_check_type(Xen_is_GtkComboBox_(combo_box), combo_box, 1, "gtk_combo_box_popup", "GtkComboBox*");
  gtk_combo_box_popup(Xen_to_C_GtkComboBox_(combo_box));
  return(Xen_false);
}

static Xen gxg_gtk_combo_box_popdown(Xen combo_box)
{
  #define H_gtk_combo_box_popdown "void gtk_combo_box_popdown(GtkComboBox* combo_box)"
  Xen_check_type(Xen_is_GtkComboBox_(combo_box), combo_box, 1, "gtk_combo_box_popdown", "GtkComboBox*");
  gtk_combo_box_popdown(Xen_to_C_GtkComboBox_(combo_box));
  return(Xen_false);
}

static Xen gxg_gtk_scale_get_layout(Xen scale)
{
  #define H_gtk_scale_get_layout "PangoLayout* gtk_scale_get_layout(GtkScale* scale)"
  Xen_check_type(Xen_is_GtkScale_(scale), scale, 1, "gtk_scale_get_layout", "GtkScale*");
  return(C_to_Xen_PangoLayout_(gtk_scale_get_layout(Xen_to_C_GtkScale_(scale))));
}

static Xen gxg_gtk_scale_get_layout_offsets(Xen scale, Xen ignore_x, Xen ignore_y)
{
  #define H_gtk_scale_get_layout_offsets "void gtk_scale_get_layout_offsets(GtkScale* scale, gint* [x], \
gint* [y])"
  gint ref_x;
  gint ref_y;
  Xen_check_type(Xen_is_GtkScale_(scale), scale, 1, "gtk_scale_get_layout_offsets", "GtkScale*");
  gtk_scale_get_layout_offsets(Xen_to_C_GtkScale_(scale), &ref_x, &ref_y);
  return(Xen_list_2(C_to_Xen_gint(ref_x), C_to_Xen_gint(ref_y)));
}

static Xen gxg_gtk_entry_set_alignment(Xen entry, Xen xalign)
{
  #define H_gtk_entry_set_alignment "void gtk_entry_set_alignment(GtkEntry* entry, gfloat xalign)"
  Xen_check_type(Xen_is_GtkEntry_(entry), entry, 1, "gtk_entry_set_alignment", "GtkEntry*");
  Xen_check_type(Xen_is_gfloat(xalign), xalign, 2, "gtk_entry_set_alignment", "gfloat");
  gtk_entry_set_alignment(Xen_to_C_GtkEntry_(entry), Xen_to_C_gfloat(xalign));
  return(Xen_false);
}

static Xen gxg_gtk_entry_get_alignment(Xen entry)
{
  #define H_gtk_entry_get_alignment "gfloat gtk_entry_get_alignment(GtkEntry* entry)"
  Xen_check_type(Xen_is_GtkEntry_(entry), entry, 1, "gtk_entry_get_alignment", "GtkEntry*");
  return(C_to_Xen_gfloat(gtk_entry_get_alignment(Xen_to_C_GtkEntry_(entry))));
}

static Xen gxg_gtk_widget_list_mnemonic_labels(Xen widget)
{
  #define H_gtk_widget_list_mnemonic_labels "GList* gtk_widget_list_mnemonic_labels(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_list_mnemonic_labels", "GtkWidget*");
  return(C_to_Xen_GList_(gtk_widget_list_mnemonic_labels(Xen_to_C_GtkWidget_(widget))));
}

static Xen gxg_gtk_widget_add_mnemonic_label(Xen widget, Xen label)
{
  #define H_gtk_widget_add_mnemonic_label "void gtk_widget_add_mnemonic_label(GtkWidget* widget, GtkWidget* label)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_add_mnemonic_label", "GtkWidget*");
  Xen_check_type(Xen_is_GtkWidget_(label), label, 2, "gtk_widget_add_mnemonic_label", "GtkWidget*");
  gtk_widget_add_mnemonic_label(Xen_to_C_GtkWidget_(widget), Xen_to_C_GtkWidget_(label));
  return(Xen_false);
}

static Xen gxg_gtk_widget_remove_mnemonic_label(Xen widget, Xen label)
{
  #define H_gtk_widget_remove_mnemonic_label "void gtk_widget_remove_mnemonic_label(GtkWidget* widget, \
GtkWidget* label)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_remove_mnemonic_label", "GtkWidget*");
  Xen_check_type(Xen_is_GtkWidget_(label), label, 2, "gtk_widget_remove_mnemonic_label", "GtkWidget*");
  gtk_widget_remove_mnemonic_label(Xen_to_C_GtkWidget_(widget), Xen_to_C_GtkWidget_(label));
  return(Xen_false);
}

static Xen gxg_g_quark_from_string(Xen string)
{
  #define H_g_quark_from_string "GQuark g_quark_from_string(gchar* string)"
  Xen_check_type(Xen_is_gchar_(string), string, 1, "g_quark_from_string", "gchar*");
  return(C_to_Xen_GQuark(g_quark_from_string(Xen_to_C_gchar_(string))));
}

static Xen gxg_g_quark_to_string(Xen quark)
{
  #define H_g_quark_to_string "gchar* g_quark_to_string(GQuark quark)"
  Xen_check_type(Xen_is_GQuark(quark), quark, 1, "g_quark_to_string", "GQuark");
  return(C_to_Xen_gchar_(g_quark_to_string(Xen_to_C_GQuark(quark))));
}

static Xen gxg_gtk_cell_view_new(void)
{
  #define H_gtk_cell_view_new "GtkWidget* gtk_cell_view_new( void)"
  return(C_to_Xen_GtkWidget_(gtk_cell_view_new()));
}

static Xen gxg_gtk_cell_view_new_with_text(Xen text)
{
  #define H_gtk_cell_view_new_with_text "GtkWidget* gtk_cell_view_new_with_text(gchar* text)"
  Xen_check_type(Xen_is_gchar_(text), text, 1, "gtk_cell_view_new_with_text", "gchar*");
  return(C_to_Xen_GtkWidget_(gtk_cell_view_new_with_text(Xen_to_C_gchar_(text))));
}

static Xen gxg_gtk_cell_view_new_with_markup(Xen markup)
{
  #define H_gtk_cell_view_new_with_markup "GtkWidget* gtk_cell_view_new_with_markup(gchar* markup)"
  Xen_check_type(Xen_is_gchar_(markup), markup, 1, "gtk_cell_view_new_with_markup", "gchar*");
  return(C_to_Xen_GtkWidget_(gtk_cell_view_new_with_markup(Xen_to_C_gchar_(markup))));
}

static Xen gxg_gtk_cell_view_set_model(Xen cell_view, Xen model)
{
  #define H_gtk_cell_view_set_model "void gtk_cell_view_set_model(GtkCellView* cell_view, GtkTreeModel* model)"
  Xen_check_type(Xen_is_GtkCellView_(cell_view), cell_view, 1, "gtk_cell_view_set_model", "GtkCellView*");
  Xen_check_type(Xen_is_GtkTreeModel_(model) || Xen_is_false(model), model, 2, "gtk_cell_view_set_model", "GtkTreeModel*");
  gtk_cell_view_set_model(Xen_to_C_GtkCellView_(cell_view), Xen_to_C_GtkTreeModel_(model));
  return(Xen_false);
}

static Xen gxg_gtk_cell_view_set_displayed_row(Xen cell_view, Xen path)
{
  #define H_gtk_cell_view_set_displayed_row "void gtk_cell_view_set_displayed_row(GtkCellView* cell_view, \
GtkTreePath* path)"
  Xen_check_type(Xen_is_GtkCellView_(cell_view), cell_view, 1, "gtk_cell_view_set_displayed_row", "GtkCellView*");
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 2, "gtk_cell_view_set_displayed_row", "GtkTreePath*");
  gtk_cell_view_set_displayed_row(Xen_to_C_GtkCellView_(cell_view), Xen_to_C_GtkTreePath_(path));
  return(Xen_false);
}

static Xen gxg_gtk_cell_view_get_displayed_row(Xen cell_view)
{
  #define H_gtk_cell_view_get_displayed_row "GtkTreePath* gtk_cell_view_get_displayed_row(GtkCellView* cell_view)"
  Xen_check_type(Xen_is_GtkCellView_(cell_view), cell_view, 1, "gtk_cell_view_get_displayed_row", "GtkCellView*");
  return(C_to_Xen_GtkTreePath_(gtk_cell_view_get_displayed_row(Xen_to_C_GtkCellView_(cell_view))));
}

static Xen gxg_gtk_entry_completion_insert_prefix(Xen completion)
{
  #define H_gtk_entry_completion_insert_prefix "void gtk_entry_completion_insert_prefix(GtkEntryCompletion* completion)"
  Xen_check_type(Xen_is_GtkEntryCompletion_(completion), completion, 1, "gtk_entry_completion_insert_prefix", "GtkEntryCompletion*");
  gtk_entry_completion_insert_prefix(Xen_to_C_GtkEntryCompletion_(completion));
  return(Xen_false);
}

static Xen gxg_gtk_entry_completion_set_inline_completion(Xen completion, Xen inline_completion)
{
  #define H_gtk_entry_completion_set_inline_completion "void gtk_entry_completion_set_inline_completion(GtkEntryCompletion* completion, \
gboolean inline_completion)"
  Xen_check_type(Xen_is_GtkEntryCompletion_(completion), completion, 1, "gtk_entry_completion_set_inline_completion", "GtkEntryCompletion*");
  Xen_check_type(Xen_is_gboolean(inline_completion), inline_completion, 2, "gtk_entry_completion_set_inline_completion", "gboolean");
  gtk_entry_completion_set_inline_completion(Xen_to_C_GtkEntryCompletion_(completion), Xen_to_C_gboolean(inline_completion));
  return(Xen_false);
}

static Xen gxg_gtk_entry_completion_get_inline_completion(Xen completion)
{
  #define H_gtk_entry_completion_get_inline_completion "gboolean gtk_entry_completion_get_inline_completion(GtkEntryCompletion* completion)"
  Xen_check_type(Xen_is_GtkEntryCompletion_(completion), completion, 1, "gtk_entry_completion_get_inline_completion", "GtkEntryCompletion*");
  return(C_to_Xen_gboolean(gtk_entry_completion_get_inline_completion(Xen_to_C_GtkEntryCompletion_(completion))));
}

static Xen gxg_gtk_entry_completion_set_popup_completion(Xen completion, Xen popup_completion)
{
  #define H_gtk_entry_completion_set_popup_completion "void gtk_entry_completion_set_popup_completion(GtkEntryCompletion* completion, \
gboolean popup_completion)"
  Xen_check_type(Xen_is_GtkEntryCompletion_(completion), completion, 1, "gtk_entry_completion_set_popup_completion", "GtkEntryCompletion*");
  Xen_check_type(Xen_is_gboolean(popup_completion), popup_completion, 2, "gtk_entry_completion_set_popup_completion", "gboolean");
  gtk_entry_completion_set_popup_completion(Xen_to_C_GtkEntryCompletion_(completion), Xen_to_C_gboolean(popup_completion));
  return(Xen_false);
}

static Xen gxg_gtk_entry_completion_get_popup_completion(Xen completion)
{
  #define H_gtk_entry_completion_get_popup_completion "gboolean gtk_entry_completion_get_popup_completion(GtkEntryCompletion* completion)"
  Xen_check_type(Xen_is_GtkEntryCompletion_(completion), completion, 1, "gtk_entry_completion_get_popup_completion", "GtkEntryCompletion*");
  return(C_to_Xen_gboolean(gtk_entry_completion_get_popup_completion(Xen_to_C_GtkEntryCompletion_(completion))));
}

static Xen gxg_gtk_entry_completion_get_text_column(Xen completion)
{
  #define H_gtk_entry_completion_get_text_column "gint gtk_entry_completion_get_text_column(GtkEntryCompletion* completion)"
  Xen_check_type(Xen_is_GtkEntryCompletion_(completion), completion, 1, "gtk_entry_completion_get_text_column", "GtkEntryCompletion*");
  return(C_to_Xen_gint(gtk_entry_completion_get_text_column(Xen_to_C_GtkEntryCompletion_(completion))));
}

static Xen gxg_gtk_tree_view_set_fixed_height_mode(Xen tree_view, Xen enable)
{
  #define H_gtk_tree_view_set_fixed_height_mode "void gtk_tree_view_set_fixed_height_mode(GtkTreeView* tree_view, \
gboolean enable)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_set_fixed_height_mode", "GtkTreeView*");
  Xen_check_type(Xen_is_gboolean(enable), enable, 2, "gtk_tree_view_set_fixed_height_mode", "gboolean");
  gtk_tree_view_set_fixed_height_mode(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_gboolean(enable));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_get_fixed_height_mode(Xen tree_view)
{
  #define H_gtk_tree_view_get_fixed_height_mode "gboolean gtk_tree_view_get_fixed_height_mode(GtkTreeView* tree_view)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_get_fixed_height_mode", "GtkTreeView*");
  return(C_to_Xen_gboolean(gtk_tree_view_get_fixed_height_mode(Xen_to_C_GtkTreeView_(tree_view))));
}

static Xen gxg_gtk_tree_view_set_hover_selection(Xen tree_view, Xen hover)
{
  #define H_gtk_tree_view_set_hover_selection "void gtk_tree_view_set_hover_selection(GtkTreeView* tree_view, \
gboolean hover)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_set_hover_selection", "GtkTreeView*");
  Xen_check_type(Xen_is_gboolean(hover), hover, 2, "gtk_tree_view_set_hover_selection", "gboolean");
  gtk_tree_view_set_hover_selection(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_gboolean(hover));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_get_hover_selection(Xen tree_view)
{
  #define H_gtk_tree_view_get_hover_selection "gboolean gtk_tree_view_get_hover_selection(GtkTreeView* tree_view)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_get_hover_selection", "GtkTreeView*");
  return(C_to_Xen_gboolean(gtk_tree_view_get_hover_selection(Xen_to_C_GtkTreeView_(tree_view))));
}

static Xen gxg_gtk_tree_view_set_row_separator_func(Xen tree_view, Xen func, Xen func_info, Xen destroy)
{
  #define H_gtk_tree_view_set_row_separator_func "void gtk_tree_view_set_row_separator_func(GtkTreeView* tree_view, \
GtkTreeViewRowSeparatorFunc func, lambda_data func_info, GtkDestroyNotify destroy)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_set_row_separator_func", "GtkTreeView*");
  Xen_check_type(Xen_is_GtkTreeViewRowSeparatorFunc(func), func, 2, "gtk_tree_view_set_row_separator_func", "GtkTreeViewRowSeparatorFunc");
  Xen_check_type(Xen_is_lambda_data(func_info) || Xen_is_false(func_info), func_info, 3, "gtk_tree_view_set_row_separator_func", "lambda_data");
  Xen_check_type(Xen_is_GtkDestroyNotify(destroy), destroy, 4, "gtk_tree_view_set_row_separator_func", "GtkDestroyNotify");
  {
    Xen gxg_ptr = Xen_list_5(func, func_info, Xen_false, Xen_false, Xen_false);
    xm_protect(gxg_ptr);
    Xen_list_set(gxg_ptr, 3, destroy);
    gtk_tree_view_set_row_separator_func(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_GtkTreeViewRowSeparatorFunc(func), Xen_to_C_lambda_data(func_info), 
                                     Xen_to_C_GtkDestroyNotify(destroy));
    return(Xen_false);
   }
}

static Xen gxg_gtk_window_set_icon_name(Xen window, Xen name)
{
  #define H_gtk_window_set_icon_name "void gtk_window_set_icon_name(GtkWindow* window, gchar* name)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_set_icon_name", "GtkWindow*");
  Xen_check_type(Xen_is_gchar_(name), name, 2, "gtk_window_set_icon_name", "gchar*");
  gtk_window_set_icon_name(Xen_to_C_GtkWindow_(window), Xen_to_C_gchar_(name));
  return(Xen_false);
}

static Xen gxg_gtk_window_get_icon_name(Xen window)
{
  #define H_gtk_window_get_icon_name "gchar* gtk_window_get_icon_name(GtkWindow* window)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_get_icon_name", "GtkWindow*");
  return(C_to_Xen_gchar_(gtk_window_get_icon_name(Xen_to_C_GtkWindow_(window))));
}

static Xen gxg_gtk_window_set_default_icon_name(Xen name)
{
  #define H_gtk_window_set_default_icon_name "void gtk_window_set_default_icon_name(gchar* name)"
  Xen_check_type(Xen_is_gchar_(name), name, 1, "gtk_window_set_default_icon_name", "gchar*");
  gtk_window_set_default_icon_name(Xen_to_C_gchar_(name));
  return(Xen_false);
}

static Xen gxg_gtk_about_dialog_new(void)
{
  #define H_gtk_about_dialog_new "GtkWidget* gtk_about_dialog_new( void)"
  return(C_to_Xen_GtkWidget_(gtk_about_dialog_new()));
}

static Xen gxg_gtk_about_dialog_get_version(Xen about)
{
  #define H_gtk_about_dialog_get_version "gchar* gtk_about_dialog_get_version(GtkAboutDialog* about)"
  Xen_check_type(Xen_is_GtkAboutDialog_(about), about, 1, "gtk_about_dialog_get_version", "GtkAboutDialog*");
  return(C_to_Xen_gchar_(gtk_about_dialog_get_version(Xen_to_C_GtkAboutDialog_(about))));
}

static Xen gxg_gtk_about_dialog_set_version(Xen about, Xen version)
{
  #define H_gtk_about_dialog_set_version "void gtk_about_dialog_set_version(GtkAboutDialog* about, gchar* version)"
  Xen_check_type(Xen_is_GtkAboutDialog_(about), about, 1, "gtk_about_dialog_set_version", "GtkAboutDialog*");
  Xen_check_type(Xen_is_gchar_(version), version, 2, "gtk_about_dialog_set_version", "gchar*");
  gtk_about_dialog_set_version(Xen_to_C_GtkAboutDialog_(about), Xen_to_C_gchar_(version));
  return(Xen_false);
}

static Xen gxg_gtk_about_dialog_get_copyright(Xen about)
{
  #define H_gtk_about_dialog_get_copyright "gchar* gtk_about_dialog_get_copyright(GtkAboutDialog* about)"
  Xen_check_type(Xen_is_GtkAboutDialog_(about), about, 1, "gtk_about_dialog_get_copyright", "GtkAboutDialog*");
  return(C_to_Xen_gchar_(gtk_about_dialog_get_copyright(Xen_to_C_GtkAboutDialog_(about))));
}

static Xen gxg_gtk_about_dialog_set_copyright(Xen about, Xen copyright)
{
  #define H_gtk_about_dialog_set_copyright "void gtk_about_dialog_set_copyright(GtkAboutDialog* about, \
gchar* copyright)"
  Xen_check_type(Xen_is_GtkAboutDialog_(about), about, 1, "gtk_about_dialog_set_copyright", "GtkAboutDialog*");
  Xen_check_type(Xen_is_gchar_(copyright), copyright, 2, "gtk_about_dialog_set_copyright", "gchar*");
  gtk_about_dialog_set_copyright(Xen_to_C_GtkAboutDialog_(about), Xen_to_C_gchar_(copyright));
  return(Xen_false);
}

static Xen gxg_gtk_about_dialog_get_comments(Xen about)
{
  #define H_gtk_about_dialog_get_comments "gchar* gtk_about_dialog_get_comments(GtkAboutDialog* about)"
  Xen_check_type(Xen_is_GtkAboutDialog_(about), about, 1, "gtk_about_dialog_get_comments", "GtkAboutDialog*");
  return(C_to_Xen_gchar_(gtk_about_dialog_get_comments(Xen_to_C_GtkAboutDialog_(about))));
}

static Xen gxg_gtk_about_dialog_set_comments(Xen about, Xen comments)
{
  #define H_gtk_about_dialog_set_comments "void gtk_about_dialog_set_comments(GtkAboutDialog* about, \
gchar* comments)"
  Xen_check_type(Xen_is_GtkAboutDialog_(about), about, 1, "gtk_about_dialog_set_comments", "GtkAboutDialog*");
  Xen_check_type(Xen_is_gchar_(comments), comments, 2, "gtk_about_dialog_set_comments", "gchar*");
  gtk_about_dialog_set_comments(Xen_to_C_GtkAboutDialog_(about), Xen_to_C_gchar_(comments));
  return(Xen_false);
}

static Xen gxg_gtk_about_dialog_get_website(Xen about)
{
  #define H_gtk_about_dialog_get_website "gchar* gtk_about_dialog_get_website(GtkAboutDialog* about)"
  Xen_check_type(Xen_is_GtkAboutDialog_(about), about, 1, "gtk_about_dialog_get_website", "GtkAboutDialog*");
  return(C_to_Xen_gchar_(gtk_about_dialog_get_website(Xen_to_C_GtkAboutDialog_(about))));
}

static Xen gxg_gtk_about_dialog_set_website(Xen about, Xen website)
{
  #define H_gtk_about_dialog_set_website "void gtk_about_dialog_set_website(GtkAboutDialog* about, gchar* website)"
  Xen_check_type(Xen_is_GtkAboutDialog_(about), about, 1, "gtk_about_dialog_set_website", "GtkAboutDialog*");
  Xen_check_type(Xen_is_gchar_(website), website, 2, "gtk_about_dialog_set_website", "gchar*");
  gtk_about_dialog_set_website(Xen_to_C_GtkAboutDialog_(about), Xen_to_C_gchar_(website));
  return(Xen_false);
}

static Xen gxg_gtk_about_dialog_get_website_label(Xen about)
{
  #define H_gtk_about_dialog_get_website_label "gchar* gtk_about_dialog_get_website_label(GtkAboutDialog* about)"
  Xen_check_type(Xen_is_GtkAboutDialog_(about), about, 1, "gtk_about_dialog_get_website_label", "GtkAboutDialog*");
  return(C_to_Xen_gchar_(gtk_about_dialog_get_website_label(Xen_to_C_GtkAboutDialog_(about))));
}

static Xen gxg_gtk_about_dialog_set_website_label(Xen about, Xen website_label)
{
  #define H_gtk_about_dialog_set_website_label "void gtk_about_dialog_set_website_label(GtkAboutDialog* about, \
gchar* website_label)"
  Xen_check_type(Xen_is_GtkAboutDialog_(about), about, 1, "gtk_about_dialog_set_website_label", "GtkAboutDialog*");
  Xen_check_type(Xen_is_gchar_(website_label), website_label, 2, "gtk_about_dialog_set_website_label", "gchar*");
  gtk_about_dialog_set_website_label(Xen_to_C_GtkAboutDialog_(about), Xen_to_C_gchar_(website_label));
  return(Xen_false);
}

static Xen gxg_gtk_about_dialog_get_authors(Xen about)
{
  #define H_gtk_about_dialog_get_authors "gchar** gtk_about_dialog_get_authors(GtkAboutDialog* about)"
  Xen_check_type(Xen_is_GtkAboutDialog_(about), about, 1, "gtk_about_dialog_get_authors", "GtkAboutDialog*");
    return(C_to_Xen_gchar__((gchar**)gtk_about_dialog_get_authors(Xen_to_C_GtkAboutDialog_(about))));
}

static Xen gxg_gtk_about_dialog_set_authors(Xen about, Xen authors)
{
  #define H_gtk_about_dialog_set_authors "void gtk_about_dialog_set_authors(GtkAboutDialog* about, gchar** authors)"
  Xen_check_type(Xen_is_GtkAboutDialog_(about), about, 1, "gtk_about_dialog_set_authors", "GtkAboutDialog*");
  Xen_check_type(Xen_is_gchar__(authors), authors, 2, "gtk_about_dialog_set_authors", "gchar**");
  gtk_about_dialog_set_authors(Xen_to_C_GtkAboutDialog_(about), (const gchar**)Xen_to_C_gchar__(authors));
  return(Xen_false);
}

static Xen gxg_gtk_about_dialog_get_documenters(Xen about)
{
  #define H_gtk_about_dialog_get_documenters "gchar** gtk_about_dialog_get_documenters(GtkAboutDialog* about)"
  Xen_check_type(Xen_is_GtkAboutDialog_(about), about, 1, "gtk_about_dialog_get_documenters", "GtkAboutDialog*");
    return(C_to_Xen_gchar__((gchar**)gtk_about_dialog_get_documenters(Xen_to_C_GtkAboutDialog_(about))));
}

static Xen gxg_gtk_about_dialog_set_documenters(Xen about, Xen documenters)
{
  #define H_gtk_about_dialog_set_documenters "void gtk_about_dialog_set_documenters(GtkAboutDialog* about, \
gchar** documenters)"
  Xen_check_type(Xen_is_GtkAboutDialog_(about), about, 1, "gtk_about_dialog_set_documenters", "GtkAboutDialog*");
  Xen_check_type(Xen_is_gchar__(documenters), documenters, 2, "gtk_about_dialog_set_documenters", "gchar**");
  gtk_about_dialog_set_documenters(Xen_to_C_GtkAboutDialog_(about), (const gchar**)Xen_to_C_gchar__(documenters));
  return(Xen_false);
}

static Xen gxg_gtk_about_dialog_get_artists(Xen about)
{
  #define H_gtk_about_dialog_get_artists "gchar** gtk_about_dialog_get_artists(GtkAboutDialog* about)"
  Xen_check_type(Xen_is_GtkAboutDialog_(about), about, 1, "gtk_about_dialog_get_artists", "GtkAboutDialog*");
    return(C_to_Xen_gchar__((gchar**)gtk_about_dialog_get_artists(Xen_to_C_GtkAboutDialog_(about))));
}

static Xen gxg_gtk_about_dialog_set_artists(Xen about, Xen artists)
{
  #define H_gtk_about_dialog_set_artists "void gtk_about_dialog_set_artists(GtkAboutDialog* about, gchar** artists)"
  Xen_check_type(Xen_is_GtkAboutDialog_(about), about, 1, "gtk_about_dialog_set_artists", "GtkAboutDialog*");
  Xen_check_type(Xen_is_gchar__(artists), artists, 2, "gtk_about_dialog_set_artists", "gchar**");
  gtk_about_dialog_set_artists(Xen_to_C_GtkAboutDialog_(about), (const gchar**)Xen_to_C_gchar__(artists));
  return(Xen_false);
}

static Xen gxg_gtk_about_dialog_get_translator_credits(Xen about)
{
  #define H_gtk_about_dialog_get_translator_credits "gchar* gtk_about_dialog_get_translator_credits(GtkAboutDialog* about)"
  Xen_check_type(Xen_is_GtkAboutDialog_(about), about, 1, "gtk_about_dialog_get_translator_credits", "GtkAboutDialog*");
  return(C_to_Xen_gchar_(gtk_about_dialog_get_translator_credits(Xen_to_C_GtkAboutDialog_(about))));
}

static Xen gxg_gtk_about_dialog_set_translator_credits(Xen about, Xen translator_credits)
{
  #define H_gtk_about_dialog_set_translator_credits "void gtk_about_dialog_set_translator_credits(GtkAboutDialog* about, \
gchar* translator_credits)"
  Xen_check_type(Xen_is_GtkAboutDialog_(about), about, 1, "gtk_about_dialog_set_translator_credits", "GtkAboutDialog*");
  Xen_check_type(Xen_is_gchar_(translator_credits), translator_credits, 2, "gtk_about_dialog_set_translator_credits", "gchar*");
  gtk_about_dialog_set_translator_credits(Xen_to_C_GtkAboutDialog_(about), Xen_to_C_gchar_(translator_credits));
  return(Xen_false);
}

static Xen gxg_gtk_about_dialog_get_program_name(Xen about)
{
  #define H_gtk_about_dialog_get_program_name "gchar* gtk_about_dialog_get_program_name(GtkAboutDialog* about)"
  Xen_check_type(Xen_is_GtkAboutDialog_(about), about, 1, "gtk_about_dialog_get_program_name", "GtkAboutDialog*");
  return(C_to_Xen_gchar_(gtk_about_dialog_get_program_name(Xen_to_C_GtkAboutDialog_(about))));
}

static Xen gxg_gtk_about_dialog_set_program_name(Xen about, Xen name)
{
  #define H_gtk_about_dialog_set_program_name "void gtk_about_dialog_set_program_name(GtkAboutDialog* about, \
gchar* name)"
  Xen_check_type(Xen_is_GtkAboutDialog_(about), about, 1, "gtk_about_dialog_set_program_name", "GtkAboutDialog*");
  Xen_check_type(Xen_is_gchar_(name), name, 2, "gtk_about_dialog_set_program_name", "gchar*");
  gtk_about_dialog_set_program_name(Xen_to_C_GtkAboutDialog_(about), Xen_to_C_gchar_(name));
  return(Xen_false);
}

static Xen gxg_gtk_icon_view_new(void)
{
  #define H_gtk_icon_view_new "GtkWidget* gtk_icon_view_new( void)"
  return(C_to_Xen_GtkWidget_(gtk_icon_view_new()));
}

static Xen gxg_gtk_icon_view_new_with_model(Xen model)
{
  #define H_gtk_icon_view_new_with_model "GtkWidget* gtk_icon_view_new_with_model(GtkTreeModel* model)"
  Xen_check_type(Xen_is_GtkTreeModel_(model), model, 1, "gtk_icon_view_new_with_model", "GtkTreeModel*");
  return(C_to_Xen_GtkWidget_(gtk_icon_view_new_with_model(Xen_to_C_GtkTreeModel_(model))));
}

static Xen gxg_gtk_icon_view_set_model(Xen icon_view, Xen model)
{
  #define H_gtk_icon_view_set_model "void gtk_icon_view_set_model(GtkIconView* icon_view, GtkTreeModel* model)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_set_model", "GtkIconView*");
  Xen_check_type(Xen_is_GtkTreeModel_(model) || Xen_is_false(model), model, 2, "gtk_icon_view_set_model", "GtkTreeModel*");
  gtk_icon_view_set_model(Xen_to_C_GtkIconView_(icon_view), Xen_to_C_GtkTreeModel_(model));
  return(Xen_false);
}

static Xen gxg_gtk_icon_view_get_model(Xen icon_view)
{
  #define H_gtk_icon_view_get_model "GtkTreeModel* gtk_icon_view_get_model(GtkIconView* icon_view)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_get_model", "GtkIconView*");
  return(C_to_Xen_GtkTreeModel_(gtk_icon_view_get_model(Xen_to_C_GtkIconView_(icon_view))));
}

static Xen gxg_gtk_icon_view_set_text_column(Xen icon_view, Xen column)
{
  #define H_gtk_icon_view_set_text_column "void gtk_icon_view_set_text_column(GtkIconView* icon_view, \
gint column)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_set_text_column", "GtkIconView*");
  Xen_check_type(Xen_is_gint(column), column, 2, "gtk_icon_view_set_text_column", "gint");
  gtk_icon_view_set_text_column(Xen_to_C_GtkIconView_(icon_view), Xen_to_C_gint(column));
  return(Xen_false);
}

static Xen gxg_gtk_icon_view_get_text_column(Xen icon_view)
{
  #define H_gtk_icon_view_get_text_column "gint gtk_icon_view_get_text_column(GtkIconView* icon_view)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_get_text_column", "GtkIconView*");
  return(C_to_Xen_gint(gtk_icon_view_get_text_column(Xen_to_C_GtkIconView_(icon_view))));
}

static Xen gxg_gtk_icon_view_set_markup_column(Xen icon_view, Xen column)
{
  #define H_gtk_icon_view_set_markup_column "void gtk_icon_view_set_markup_column(GtkIconView* icon_view, \
gint column)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_set_markup_column", "GtkIconView*");
  Xen_check_type(Xen_is_gint(column), column, 2, "gtk_icon_view_set_markup_column", "gint");
  gtk_icon_view_set_markup_column(Xen_to_C_GtkIconView_(icon_view), Xen_to_C_gint(column));
  return(Xen_false);
}

static Xen gxg_gtk_icon_view_get_markup_column(Xen icon_view)
{
  #define H_gtk_icon_view_get_markup_column "gint gtk_icon_view_get_markup_column(GtkIconView* icon_view)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_get_markup_column", "GtkIconView*");
  return(C_to_Xen_gint(gtk_icon_view_get_markup_column(Xen_to_C_GtkIconView_(icon_view))));
}

static Xen gxg_gtk_icon_view_set_pixbuf_column(Xen icon_view, Xen column)
{
  #define H_gtk_icon_view_set_pixbuf_column "void gtk_icon_view_set_pixbuf_column(GtkIconView* icon_view, \
gint column)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_set_pixbuf_column", "GtkIconView*");
  Xen_check_type(Xen_is_gint(column), column, 2, "gtk_icon_view_set_pixbuf_column", "gint");
  gtk_icon_view_set_pixbuf_column(Xen_to_C_GtkIconView_(icon_view), Xen_to_C_gint(column));
  return(Xen_false);
}

static Xen gxg_gtk_icon_view_get_pixbuf_column(Xen icon_view)
{
  #define H_gtk_icon_view_get_pixbuf_column "gint gtk_icon_view_get_pixbuf_column(GtkIconView* icon_view)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_get_pixbuf_column", "GtkIconView*");
  return(C_to_Xen_gint(gtk_icon_view_get_pixbuf_column(Xen_to_C_GtkIconView_(icon_view))));
}

static Xen gxg_gtk_icon_view_get_path_at_pos(Xen icon_view, Xen x, Xen y)
{
  #define H_gtk_icon_view_get_path_at_pos "GtkTreePath* gtk_icon_view_get_path_at_pos(GtkIconView* icon_view, \
gint x, gint y)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_get_path_at_pos", "GtkIconView*");
  Xen_check_type(Xen_is_gint(x), x, 2, "gtk_icon_view_get_path_at_pos", "gint");
  Xen_check_type(Xen_is_gint(y), y, 3, "gtk_icon_view_get_path_at_pos", "gint");
  return(C_to_Xen_GtkTreePath_(gtk_icon_view_get_path_at_pos(Xen_to_C_GtkIconView_(icon_view), Xen_to_C_gint(x), Xen_to_C_gint(y))));
}

static Xen gxg_gtk_icon_view_selected_foreach(Xen icon_view, Xen func, Xen func_info)
{
  #define H_gtk_icon_view_selected_foreach "void gtk_icon_view_selected_foreach(GtkIconView* icon_view, \
GtkIconViewForeachFunc func, lambda_data func_info)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_selected_foreach", "GtkIconView*");
  Xen_check_type(Xen_is_GtkIconViewForeachFunc(func), func, 2, "gtk_icon_view_selected_foreach", "GtkIconViewForeachFunc");
  Xen_check_type(Xen_is_lambda_data(func_info) || Xen_is_false(func_info), func_info, 3, "gtk_icon_view_selected_foreach", "lambda_data");
  {
    Xen gxg_ptr = Xen_list_5(func, func_info, Xen_false, Xen_false, Xen_false);
    xm_protect(gxg_ptr);
    gtk_icon_view_selected_foreach(Xen_to_C_GtkIconView_(icon_view), Xen_to_C_GtkIconViewForeachFunc(func), Xen_to_C_lambda_data(func_info));
    return(Xen_false);
   }
}

static Xen gxg_gtk_icon_view_set_selection_mode(Xen icon_view, Xen mode)
{
  #define H_gtk_icon_view_set_selection_mode "void gtk_icon_view_set_selection_mode(GtkIconView* icon_view, \
GtkSelectionMode mode)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_set_selection_mode", "GtkIconView*");
  Xen_check_type(Xen_is_GtkSelectionMode(mode), mode, 2, "gtk_icon_view_set_selection_mode", "GtkSelectionMode");
  gtk_icon_view_set_selection_mode(Xen_to_C_GtkIconView_(icon_view), Xen_to_C_GtkSelectionMode(mode));
  return(Xen_false);
}

static Xen gxg_gtk_icon_view_get_selection_mode(Xen icon_view)
{
  #define H_gtk_icon_view_get_selection_mode "GtkSelectionMode gtk_icon_view_get_selection_mode(GtkIconView* icon_view)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_get_selection_mode", "GtkIconView*");
  return(C_to_Xen_GtkSelectionMode(gtk_icon_view_get_selection_mode(Xen_to_C_GtkIconView_(icon_view))));
}

static Xen gxg_gtk_icon_view_select_path(Xen icon_view, Xen path)
{
  #define H_gtk_icon_view_select_path "void gtk_icon_view_select_path(GtkIconView* icon_view, GtkTreePath* path)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_select_path", "GtkIconView*");
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 2, "gtk_icon_view_select_path", "GtkTreePath*");
  gtk_icon_view_select_path(Xen_to_C_GtkIconView_(icon_view), Xen_to_C_GtkTreePath_(path));
  return(Xen_false);
}

static Xen gxg_gtk_icon_view_unselect_path(Xen icon_view, Xen path)
{
  #define H_gtk_icon_view_unselect_path "void gtk_icon_view_unselect_path(GtkIconView* icon_view, GtkTreePath* path)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_unselect_path", "GtkIconView*");
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 2, "gtk_icon_view_unselect_path", "GtkTreePath*");
  gtk_icon_view_unselect_path(Xen_to_C_GtkIconView_(icon_view), Xen_to_C_GtkTreePath_(path));
  return(Xen_false);
}

static Xen gxg_gtk_icon_view_path_is_selected(Xen icon_view, Xen path)
{
  #define H_gtk_icon_view_path_is_selected "gboolean gtk_icon_view_path_is_selected(GtkIconView* icon_view, \
GtkTreePath* path)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_path_is_selected", "GtkIconView*");
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 2, "gtk_icon_view_path_is_selected", "GtkTreePath*");
  return(C_to_Xen_gboolean(gtk_icon_view_path_is_selected(Xen_to_C_GtkIconView_(icon_view), Xen_to_C_GtkTreePath_(path))));
}

static Xen gxg_gtk_icon_view_get_selected_items(Xen icon_view)
{
  #define H_gtk_icon_view_get_selected_items "GList* gtk_icon_view_get_selected_items(GtkIconView* icon_view)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_get_selected_items", "GtkIconView*");
  return(C_to_Xen_GList_(gtk_icon_view_get_selected_items(Xen_to_C_GtkIconView_(icon_view))));
}

static Xen gxg_gtk_icon_view_select_all(Xen icon_view)
{
  #define H_gtk_icon_view_select_all "void gtk_icon_view_select_all(GtkIconView* icon_view)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_select_all", "GtkIconView*");
  gtk_icon_view_select_all(Xen_to_C_GtkIconView_(icon_view));
  return(Xen_false);
}

static Xen gxg_gtk_icon_view_unselect_all(Xen icon_view)
{
  #define H_gtk_icon_view_unselect_all "void gtk_icon_view_unselect_all(GtkIconView* icon_view)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_unselect_all", "GtkIconView*");
  gtk_icon_view_unselect_all(Xen_to_C_GtkIconView_(icon_view));
  return(Xen_false);
}

static Xen gxg_gtk_icon_view_item_activated(Xen icon_view, Xen path)
{
  #define H_gtk_icon_view_item_activated "void gtk_icon_view_item_activated(GtkIconView* icon_view, GtkTreePath* path)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_item_activated", "GtkIconView*");
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 2, "gtk_icon_view_item_activated", "GtkTreePath*");
  gtk_icon_view_item_activated(Xen_to_C_GtkIconView_(icon_view), Xen_to_C_GtkTreePath_(path));
  return(Xen_false);
}

static Xen gxg_gtk_cell_renderer_combo_new(void)
{
  #define H_gtk_cell_renderer_combo_new "GtkCellRenderer* gtk_cell_renderer_combo_new( void)"
  return(C_to_Xen_GtkCellRenderer_(gtk_cell_renderer_combo_new()));
}

static Xen gxg_gtk_cell_renderer_progress_new(void)
{
  #define H_gtk_cell_renderer_progress_new "GtkCellRenderer* gtk_cell_renderer_progress_new( void)"
  return(C_to_Xen_GtkCellRenderer_(gtk_cell_renderer_progress_new()));
}

static Xen gxg_gtk_combo_box_set_row_separator_func(Xen combo_box, Xen func, Xen func_info, Xen destroy)
{
  #define H_gtk_combo_box_set_row_separator_func "void gtk_combo_box_set_row_separator_func(GtkComboBox* combo_box, \
GtkTreeViewRowSeparatorFunc func, lambda_data func_info, GtkDestroyNotify destroy)"
  Xen_check_type(Xen_is_GtkComboBox_(combo_box), combo_box, 1, "gtk_combo_box_set_row_separator_func", "GtkComboBox*");
  Xen_check_type(Xen_is_GtkTreeViewRowSeparatorFunc(func), func, 2, "gtk_combo_box_set_row_separator_func", "GtkTreeViewRowSeparatorFunc");
  Xen_check_type(Xen_is_lambda_data(func_info) || Xen_is_false(func_info), func_info, 3, "gtk_combo_box_set_row_separator_func", "lambda_data");
  Xen_check_type(Xen_is_GtkDestroyNotify(destroy), destroy, 4, "gtk_combo_box_set_row_separator_func", "GtkDestroyNotify");
  {
    Xen gxg_ptr = Xen_list_5(func, func_info, Xen_false, Xen_false, Xen_false);
    xm_protect(gxg_ptr);
    Xen_list_set(gxg_ptr, 3, destroy);
    gtk_combo_box_set_row_separator_func(Xen_to_C_GtkComboBox_(combo_box), Xen_to_C_GtkTreeViewRowSeparatorFunc(func), Xen_to_C_lambda_data(func_info), 
                                     Xen_to_C_GtkDestroyNotify(destroy));
    return(Xen_false);
   }
}

static Xen gxg_gtk_label_set_ellipsize(Xen label, Xen mode)
{
  #define H_gtk_label_set_ellipsize "void gtk_label_set_ellipsize(GtkLabel* label, PangoEllipsizeMode mode)"
  Xen_check_type(Xen_is_GtkLabel_(label), label, 1, "gtk_label_set_ellipsize", "GtkLabel*");
  Xen_check_type(Xen_is_PangoEllipsizeMode(mode), mode, 2, "gtk_label_set_ellipsize", "PangoEllipsizeMode");
  gtk_label_set_ellipsize(Xen_to_C_GtkLabel_(label), Xen_to_C_PangoEllipsizeMode(mode));
  return(Xen_false);
}

static Xen gxg_gtk_label_get_ellipsize(Xen label)
{
  #define H_gtk_label_get_ellipsize "PangoEllipsizeMode gtk_label_get_ellipsize(GtkLabel* label)"
  Xen_check_type(Xen_is_GtkLabel_(label), label, 1, "gtk_label_get_ellipsize", "GtkLabel*");
  return(C_to_Xen_PangoEllipsizeMode(gtk_label_get_ellipsize(Xen_to_C_GtkLabel_(label))));
}

static Xen gxg_pango_attr_fallback_new(Xen enable_fallback)
{
  #define H_pango_attr_fallback_new "PangoAttribute* pango_attr_fallback_new(gboolean enable_fallback)"
  Xen_check_type(Xen_is_gboolean(enable_fallback), enable_fallback, 1, "pango_attr_fallback_new", "gboolean");
  return(C_to_Xen_PangoAttribute_(pango_attr_fallback_new(Xen_to_C_gboolean(enable_fallback))));
}

static Xen gxg_pango_attr_letter_spacing_new(Xen letter_spacing)
{
  #define H_pango_attr_letter_spacing_new "PangoAttribute* pango_attr_letter_spacing_new(int letter_spacing)"
  Xen_check_type(Xen_is_int(letter_spacing), letter_spacing, 1, "pango_attr_letter_spacing_new", "int");
  return(C_to_Xen_PangoAttribute_(pango_attr_letter_spacing_new(Xen_to_C_int(letter_spacing))));
}

static Xen gxg_pango_attr_list_filter(Xen list, Xen func, Xen data)
{
  #define H_pango_attr_list_filter "PangoAttrList* pango_attr_list_filter(PangoAttrList* list, PangoAttrFilterFunc func, \
gpointer data)"
  Xen_check_type(Xen_is_PangoAttrList_(list), list, 1, "pango_attr_list_filter", "PangoAttrList*");
  Xen_check_type(Xen_is_PangoAttrFilterFunc(func), func, 2, "pango_attr_list_filter", "PangoAttrFilterFunc");
  Xen_check_type(Xen_is_gpointer(data), data, 3, "pango_attr_list_filter", "gpointer");
  return(C_to_Xen_PangoAttrList_(pango_attr_list_filter(Xen_to_C_PangoAttrList_(list), Xen_to_C_PangoAttrFilterFunc(func), 
                                                        Xen_to_C_gpointer(data))));
}

static Xen gxg_pango_attr_iterator_get_attrs(Xen iterator)
{
  #define H_pango_attr_iterator_get_attrs "GSList* pango_attr_iterator_get_attrs(PangoAttrIterator* iterator)"
  Xen_check_type(Xen_is_PangoAttrIterator_(iterator), iterator, 1, "pango_attr_iterator_get_attrs", "PangoAttrIterator*");
  return(C_to_Xen_GSList_(pango_attr_iterator_get_attrs(Xen_to_C_PangoAttrIterator_(iterator))));
}

static Xen gxg_pango_font_metrics_get_underline_position(Xen metrics)
{
  #define H_pango_font_metrics_get_underline_position "int pango_font_metrics_get_underline_position(PangoFontMetrics* metrics)"
  Xen_check_type(Xen_is_PangoFontMetrics_(metrics), metrics, 1, "pango_font_metrics_get_underline_position", "PangoFontMetrics*");
  return(C_to_Xen_int(pango_font_metrics_get_underline_position(Xen_to_C_PangoFontMetrics_(metrics))));
}

static Xen gxg_pango_font_metrics_get_underline_thickness(Xen metrics)
{
  #define H_pango_font_metrics_get_underline_thickness "int pango_font_metrics_get_underline_thickness(PangoFontMetrics* metrics)"
  Xen_check_type(Xen_is_PangoFontMetrics_(metrics), metrics, 1, "pango_font_metrics_get_underline_thickness", "PangoFontMetrics*");
  return(C_to_Xen_int(pango_font_metrics_get_underline_thickness(Xen_to_C_PangoFontMetrics_(metrics))));
}

static Xen gxg_pango_font_metrics_get_strikethrough_position(Xen metrics)
{
  #define H_pango_font_metrics_get_strikethrough_position "int pango_font_metrics_get_strikethrough_position(PangoFontMetrics* metrics)"
  Xen_check_type(Xen_is_PangoFontMetrics_(metrics), metrics, 1, "pango_font_metrics_get_strikethrough_position", "PangoFontMetrics*");
  return(C_to_Xen_int(pango_font_metrics_get_strikethrough_position(Xen_to_C_PangoFontMetrics_(metrics))));
}

static Xen gxg_pango_font_metrics_get_strikethrough_thickness(Xen metrics)
{
  #define H_pango_font_metrics_get_strikethrough_thickness "int pango_font_metrics_get_strikethrough_thickness(PangoFontMetrics* metrics)"
  Xen_check_type(Xen_is_PangoFontMetrics_(metrics), metrics, 1, "pango_font_metrics_get_strikethrough_thickness", "PangoFontMetrics*");
  return(C_to_Xen_int(pango_font_metrics_get_strikethrough_thickness(Xen_to_C_PangoFontMetrics_(metrics))));
}

static Xen gxg_pango_font_family_is_monospace(Xen family)
{
  #define H_pango_font_family_is_monospace "gboolean pango_font_family_is_monospace(PangoFontFamily* family)"
  Xen_check_type(Xen_is_PangoFontFamily_(family), family, 1, "pango_font_family_is_monospace", "PangoFontFamily*");
  return(C_to_Xen_gboolean(pango_font_family_is_monospace(Xen_to_C_PangoFontFamily_(family))));
}

static Xen gxg_pango_font_face_list_sizes(Xen face, Xen ignore_sizes, Xen ignore_n_sizes)
{
  #define H_pango_font_face_list_sizes "void pango_font_face_list_sizes(PangoFontFace* face, int** [sizes], \
int* [n_sizes])"
  int* ref_sizes = NULL;
  int ref_n_sizes;
  Xen_check_type(Xen_is_PangoFontFace_(face), face, 1, "pango_font_face_list_sizes", "PangoFontFace*");
  pango_font_face_list_sizes(Xen_to_C_PangoFontFace_(face), &ref_sizes, &ref_n_sizes);
  return(Xen_list_2(C_to_Xen_int_(ref_sizes), C_to_Xen_int(ref_n_sizes)));
}

static Xen gxg_pango_layout_set_auto_dir(Xen layout, Xen auto_dir)
{
  #define H_pango_layout_set_auto_dir "void pango_layout_set_auto_dir(PangoLayout* layout, gboolean auto_dir)"
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_set_auto_dir", "PangoLayout*");
  Xen_check_type(Xen_is_gboolean(auto_dir), auto_dir, 2, "pango_layout_set_auto_dir", "gboolean");
  pango_layout_set_auto_dir(Xen_to_C_PangoLayout_(layout), Xen_to_C_gboolean(auto_dir));
  return(Xen_false);
}

static Xen gxg_pango_layout_get_auto_dir(Xen layout)
{
  #define H_pango_layout_get_auto_dir "gboolean pango_layout_get_auto_dir(PangoLayout* layout)"
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_get_auto_dir", "PangoLayout*");
  return(C_to_Xen_gboolean(pango_layout_get_auto_dir(Xen_to_C_PangoLayout_(layout))));
}

static Xen gxg_pango_script_iter_new(Xen text, Xen length)
{
  #define H_pango_script_iter_new "PangoScriptIter* pango_script_iter_new(char* text, int length)"
  Xen_check_type(Xen_is_char_(text), text, 1, "pango_script_iter_new", "char*");
  Xen_check_type(Xen_is_int(length), length, 2, "pango_script_iter_new", "int");
  return(C_to_Xen_PangoScriptIter_(pango_script_iter_new(Xen_to_C_char_(text), Xen_to_C_int(length))));
}

static Xen gxg_pango_script_iter_get_range(Xen iter, Xen ignore_start, Xen ignore_end, Xen ignore_script)
{
  #define H_pango_script_iter_get_range "void pango_script_iter_get_range(PangoScriptIter* iter, char** [start], \
char** [end], PangoScript* [script])"
  char* ref_start = NULL;
  char* ref_end = NULL;
  PangoScript ref_script;
  Xen_check_type(Xen_is_PangoScriptIter_(iter), iter, 1, "pango_script_iter_get_range", "PangoScriptIter*");
  pango_script_iter_get_range(Xen_to_C_PangoScriptIter_(iter), (const char**)&ref_start, (const char**)&ref_end, &ref_script);
  return(Xen_list_3(C_to_Xen_char_(ref_start), C_to_Xen_char_(ref_end), C_to_Xen_PangoScript(ref_script)));
}

static Xen gxg_pango_script_iter_next(Xen iter)
{
  #define H_pango_script_iter_next "gboolean pango_script_iter_next(PangoScriptIter* iter)"
  Xen_check_type(Xen_is_PangoScriptIter_(iter), iter, 1, "pango_script_iter_next", "PangoScriptIter*");
  return(C_to_Xen_gboolean(pango_script_iter_next(Xen_to_C_PangoScriptIter_(iter))));
}

static Xen gxg_pango_script_iter_free(Xen iter)
{
  #define H_pango_script_iter_free "void pango_script_iter_free(PangoScriptIter* iter)"
  Xen_check_type(Xen_is_PangoScriptIter_(iter), iter, 1, "pango_script_iter_free", "PangoScriptIter*");
  pango_script_iter_free(Xen_to_C_PangoScriptIter_(iter));
  return(Xen_false);
}

static Xen gxg_gtk_file_chooser_button_new_with_dialog(Xen dialog)
{
  #define H_gtk_file_chooser_button_new_with_dialog "GtkWidget* gtk_file_chooser_button_new_with_dialog(GtkWidget* dialog)"
  Xen_check_type(Xen_is_GtkWidget_(dialog), dialog, 1, "gtk_file_chooser_button_new_with_dialog", "GtkWidget*");
  return(C_to_Xen_GtkWidget_(gtk_file_chooser_button_new_with_dialog(Xen_to_C_GtkWidget_(dialog))));
}

static Xen gxg_gtk_file_chooser_button_get_title(Xen button)
{
  #define H_gtk_file_chooser_button_get_title "gchar* gtk_file_chooser_button_get_title(GtkFileChooserButton* button)"
  Xen_check_type(Xen_is_GtkFileChooserButton_(button), button, 1, "gtk_file_chooser_button_get_title", "GtkFileChooserButton*");
  return(C_to_Xen_gchar_(gtk_file_chooser_button_get_title(Xen_to_C_GtkFileChooserButton_(button))));
}

static Xen gxg_gtk_file_chooser_button_set_title(Xen button, Xen title)
{
  #define H_gtk_file_chooser_button_set_title "void gtk_file_chooser_button_set_title(GtkFileChooserButton* button, \
gchar* title)"
  Xen_check_type(Xen_is_GtkFileChooserButton_(button), button, 1, "gtk_file_chooser_button_set_title", "GtkFileChooserButton*");
  Xen_check_type(Xen_is_gchar_(title), title, 2, "gtk_file_chooser_button_set_title", "gchar*");
  gtk_file_chooser_button_set_title(Xen_to_C_GtkFileChooserButton_(button), Xen_to_C_gchar_(title));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_set_hover_expand(Xen tree_view, Xen expand)
{
  #define H_gtk_tree_view_set_hover_expand "void gtk_tree_view_set_hover_expand(GtkTreeView* tree_view, \
gboolean expand)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_set_hover_expand", "GtkTreeView*");
  Xen_check_type(Xen_is_gboolean(expand), expand, 2, "gtk_tree_view_set_hover_expand", "gboolean");
  gtk_tree_view_set_hover_expand(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_gboolean(expand));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_get_hover_expand(Xen tree_view)
{
  #define H_gtk_tree_view_get_hover_expand "gboolean gtk_tree_view_get_hover_expand(GtkTreeView* tree_view)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_get_hover_expand", "GtkTreeView*");
  return(C_to_Xen_gboolean(gtk_tree_view_get_hover_expand(Xen_to_C_GtkTreeView_(tree_view))));
}

static Xen gxg_gtk_about_dialog_get_logo_icon_name(Xen about)
{
  #define H_gtk_about_dialog_get_logo_icon_name "gchar* gtk_about_dialog_get_logo_icon_name(GtkAboutDialog* about)"
  Xen_check_type(Xen_is_GtkAboutDialog_(about), about, 1, "gtk_about_dialog_get_logo_icon_name", "GtkAboutDialog*");
  return(C_to_Xen_gchar_(gtk_about_dialog_get_logo_icon_name(Xen_to_C_GtkAboutDialog_(about))));
}

static Xen gxg_gtk_about_dialog_set_logo_icon_name(Xen about, Xen icon_name)
{
  #define H_gtk_about_dialog_set_logo_icon_name "void gtk_about_dialog_set_logo_icon_name(GtkAboutDialog* about, \
gchar* icon_name)"
  Xen_check_type(Xen_is_GtkAboutDialog_(about), about, 1, "gtk_about_dialog_set_logo_icon_name", "GtkAboutDialog*");
  Xen_check_type(Xen_is_gchar_(icon_name), icon_name, 2, "gtk_about_dialog_set_logo_icon_name", "gchar*");
  gtk_about_dialog_set_logo_icon_name(Xen_to_C_GtkAboutDialog_(about), Xen_to_C_gchar_(icon_name));
  return(Xen_false);
}

static Xen gxg_gtk_accelerator_get_label(Xen accelerator_key, Xen accelerator_mods)
{
  #define H_gtk_accelerator_get_label "gchar* gtk_accelerator_get_label(guint accelerator_key, GdkModifierType accelerator_mods)"
  Xen_check_type(Xen_is_guint(accelerator_key), accelerator_key, 1, "gtk_accelerator_get_label", "guint");
  Xen_check_type(Xen_is_GdkModifierType(accelerator_mods), accelerator_mods, 2, "gtk_accelerator_get_label", "GdkModifierType");
  {
   gchar* res_ult;
   Xen rtn;
   res_ult = gtk_accelerator_get_label(Xen_to_C_guint(accelerator_key), Xen_to_C_GdkModifierType(accelerator_mods));
   rtn = C_to_Xen_gchar_(res_ult);
   g_free(res_ult);
   return(rtn);
  }
}

static Xen gxg_gtk_file_chooser_button_get_width_chars(Xen button)
{
  #define H_gtk_file_chooser_button_get_width_chars "gint gtk_file_chooser_button_get_width_chars(GtkFileChooserButton* button)"
  Xen_check_type(Xen_is_GtkFileChooserButton_(button), button, 1, "gtk_file_chooser_button_get_width_chars", "GtkFileChooserButton*");
  return(C_to_Xen_gint(gtk_file_chooser_button_get_width_chars(Xen_to_C_GtkFileChooserButton_(button))));
}

static Xen gxg_gtk_file_chooser_button_set_width_chars(Xen button, Xen n_chars)
{
  #define H_gtk_file_chooser_button_set_width_chars "void gtk_file_chooser_button_set_width_chars(GtkFileChooserButton* button, \
gint n_chars)"
  Xen_check_type(Xen_is_GtkFileChooserButton_(button), button, 1, "gtk_file_chooser_button_set_width_chars", "GtkFileChooserButton*");
  Xen_check_type(Xen_is_gint(n_chars), n_chars, 2, "gtk_file_chooser_button_set_width_chars", "gint");
  gtk_file_chooser_button_set_width_chars(Xen_to_C_GtkFileChooserButton_(button), Xen_to_C_gint(n_chars));
  return(Xen_false);
}

static Xen gxg_gtk_image_set_pixel_size(Xen image, Xen pixel_size)
{
  #define H_gtk_image_set_pixel_size "void gtk_image_set_pixel_size(GtkImage* image, gint pixel_size)"
  Xen_check_type(Xen_is_GtkImage_(image), image, 1, "gtk_image_set_pixel_size", "GtkImage*");
  Xen_check_type(Xen_is_gint(pixel_size), pixel_size, 2, "gtk_image_set_pixel_size", "gint");
  gtk_image_set_pixel_size(Xen_to_C_GtkImage_(image), Xen_to_C_gint(pixel_size));
  return(Xen_false);
}

static Xen gxg_gtk_image_get_pixel_size(Xen image)
{
  #define H_gtk_image_get_pixel_size "gint gtk_image_get_pixel_size(GtkImage* image)"
  Xen_check_type(Xen_is_GtkImage_(image), image, 1, "gtk_image_get_pixel_size", "GtkImage*");
  return(C_to_Xen_gint(gtk_image_get_pixel_size(Xen_to_C_GtkImage_(image))));
}

static Xen gxg_gtk_label_set_width_chars(Xen label, Xen n_chars)
{
  #define H_gtk_label_set_width_chars "void gtk_label_set_width_chars(GtkLabel* label, gint n_chars)"
  Xen_check_type(Xen_is_GtkLabel_(label), label, 1, "gtk_label_set_width_chars", "GtkLabel*");
  Xen_check_type(Xen_is_gint(n_chars), n_chars, 2, "gtk_label_set_width_chars", "gint");
  gtk_label_set_width_chars(Xen_to_C_GtkLabel_(label), Xen_to_C_gint(n_chars));
  return(Xen_false);
}

static Xen gxg_gtk_label_get_width_chars(Xen label)
{
  #define H_gtk_label_get_width_chars "gint gtk_label_get_width_chars(GtkLabel* label)"
  Xen_check_type(Xen_is_GtkLabel_(label), label, 1, "gtk_label_get_width_chars", "GtkLabel*");
  return(C_to_Xen_gint(gtk_label_get_width_chars(Xen_to_C_GtkLabel_(label))));
}

static Xen gxg_gtk_text_buffer_backspace(Xen buffer, Xen iter, Xen interactive, Xen default_editable)
{
  #define H_gtk_text_buffer_backspace "gboolean gtk_text_buffer_backspace(GtkTextBuffer* buffer, GtkTextIter* iter, \
gboolean interactive, gboolean default_editable)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_backspace", "GtkTextBuffer*");
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 2, "gtk_text_buffer_backspace", "GtkTextIter*");
  Xen_check_type(Xen_is_gboolean(interactive), interactive, 3, "gtk_text_buffer_backspace", "gboolean");
  Xen_check_type(Xen_is_gboolean(default_editable), default_editable, 4, "gtk_text_buffer_backspace", "gboolean");
  return(C_to_Xen_gboolean(gtk_text_buffer_backspace(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_GtkTextIter_(iter), Xen_to_C_gboolean(interactive), 
                                                     Xen_to_C_gboolean(default_editable))));
}

static Xen gxg_gtk_file_filter_add_pixbuf_formats(Xen filter)
{
  #define H_gtk_file_filter_add_pixbuf_formats "void gtk_file_filter_add_pixbuf_formats(GtkFileFilter* filter)"
  Xen_check_type(Xen_is_GtkFileFilter_(filter), filter, 1, "gtk_file_filter_add_pixbuf_formats", "GtkFileFilter*");
  gtk_file_filter_add_pixbuf_formats(Xen_to_C_GtkFileFilter_(filter));
  return(Xen_false);
}

static Xen gxg_gtk_label_set_single_line_mode(Xen label, Xen single_line_mode)
{
  #define H_gtk_label_set_single_line_mode "void gtk_label_set_single_line_mode(GtkLabel* label, gboolean single_line_mode)"
  Xen_check_type(Xen_is_GtkLabel_(label), label, 1, "gtk_label_set_single_line_mode", "GtkLabel*");
  Xen_check_type(Xen_is_gboolean(single_line_mode), single_line_mode, 2, "gtk_label_set_single_line_mode", "gboolean");
  gtk_label_set_single_line_mode(Xen_to_C_GtkLabel_(label), Xen_to_C_gboolean(single_line_mode));
  return(Xen_false);
}

static Xen gxg_gtk_label_get_single_line_mode(Xen label)
{
  #define H_gtk_label_get_single_line_mode "gboolean gtk_label_get_single_line_mode(GtkLabel* label)"
  Xen_check_type(Xen_is_GtkLabel_(label), label, 1, "gtk_label_get_single_line_mode", "GtkLabel*");
  return(C_to_Xen_gboolean(gtk_label_get_single_line_mode(Xen_to_C_GtkLabel_(label))));
}

static Xen gxg_gtk_progress_bar_set_ellipsize(Xen pbar, Xen mode)
{
  #define H_gtk_progress_bar_set_ellipsize "void gtk_progress_bar_set_ellipsize(GtkProgressBar* pbar, \
PangoEllipsizeMode mode)"
  Xen_check_type(Xen_is_GtkProgressBar_(pbar), pbar, 1, "gtk_progress_bar_set_ellipsize", "GtkProgressBar*");
  Xen_check_type(Xen_is_PangoEllipsizeMode(mode), mode, 2, "gtk_progress_bar_set_ellipsize", "PangoEllipsizeMode");
  gtk_progress_bar_set_ellipsize(Xen_to_C_GtkProgressBar_(pbar), Xen_to_C_PangoEllipsizeMode(mode));
  return(Xen_false);
}

static Xen gxg_gtk_progress_bar_get_ellipsize(Xen pbar)
{
  #define H_gtk_progress_bar_get_ellipsize "PangoEllipsizeMode gtk_progress_bar_get_ellipsize(GtkProgressBar* pbar)"
  Xen_check_type(Xen_is_GtkProgressBar_(pbar), pbar, 1, "gtk_progress_bar_get_ellipsize", "GtkProgressBar*");
  return(C_to_Xen_PangoEllipsizeMode(gtk_progress_bar_get_ellipsize(Xen_to_C_GtkProgressBar_(pbar))));
}

static Xen gxg_pango_attr_underline_color_new(Xen red, Xen green, Xen blue)
{
  #define H_pango_attr_underline_color_new "PangoAttribute* pango_attr_underline_color_new(guint16 red, \
guint16 green, guint16 blue)"
  Xen_check_type(Xen_is_guint16(red), red, 1, "pango_attr_underline_color_new", "guint16");
  Xen_check_type(Xen_is_guint16(green), green, 2, "pango_attr_underline_color_new", "guint16");
  Xen_check_type(Xen_is_guint16(blue), blue, 3, "pango_attr_underline_color_new", "guint16");
  return(C_to_Xen_PangoAttribute_(pango_attr_underline_color_new(Xen_to_C_guint16(red), Xen_to_C_guint16(green), Xen_to_C_guint16(blue))));
}

static Xen gxg_pango_attr_strikethrough_color_new(Xen red, Xen green, Xen blue)
{
  #define H_pango_attr_strikethrough_color_new "PangoAttribute* pango_attr_strikethrough_color_new(guint16 red, \
guint16 green, guint16 blue)"
  Xen_check_type(Xen_is_guint16(red), red, 1, "pango_attr_strikethrough_color_new", "guint16");
  Xen_check_type(Xen_is_guint16(green), green, 2, "pango_attr_strikethrough_color_new", "guint16");
  Xen_check_type(Xen_is_guint16(blue), blue, 3, "pango_attr_strikethrough_color_new", "guint16");
  return(C_to_Xen_PangoAttribute_(pango_attr_strikethrough_color_new(Xen_to_C_guint16(red), Xen_to_C_guint16(green), Xen_to_C_guint16(blue))));
}

static Xen gxg_pango_renderer_draw_layout(Xen renderer, Xen layout, Xen x, Xen y)
{
  #define H_pango_renderer_draw_layout "void pango_renderer_draw_layout(PangoRenderer* renderer, PangoLayout* layout, \
int x, int y)"
  Xen_check_type(Xen_is_PangoRenderer_(renderer), renderer, 1, "pango_renderer_draw_layout", "PangoRenderer*");
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 2, "pango_renderer_draw_layout", "PangoLayout*");
  Xen_check_type(Xen_is_int(x), x, 3, "pango_renderer_draw_layout", "int");
  Xen_check_type(Xen_is_int(y), y, 4, "pango_renderer_draw_layout", "int");
  pango_renderer_draw_layout(Xen_to_C_PangoRenderer_(renderer), Xen_to_C_PangoLayout_(layout), Xen_to_C_int(x), Xen_to_C_int(y));
  return(Xen_false);
}

static Xen gxg_pango_renderer_draw_layout_line(Xen renderer, Xen line, Xen x, Xen y)
{
  #define H_pango_renderer_draw_layout_line "void pango_renderer_draw_layout_line(PangoRenderer* renderer, \
PangoLayoutLine* line, int x, int y)"
  Xen_check_type(Xen_is_PangoRenderer_(renderer), renderer, 1, "pango_renderer_draw_layout_line", "PangoRenderer*");
  Xen_check_type(Xen_is_PangoLayoutLine_(line), line, 2, "pango_renderer_draw_layout_line", "PangoLayoutLine*");
  Xen_check_type(Xen_is_int(x), x, 3, "pango_renderer_draw_layout_line", "int");
  Xen_check_type(Xen_is_int(y), y, 4, "pango_renderer_draw_layout_line", "int");
  pango_renderer_draw_layout_line(Xen_to_C_PangoRenderer_(renderer), Xen_to_C_PangoLayoutLine_(line), Xen_to_C_int(x), Xen_to_C_int(y));
  return(Xen_false);
}

static Xen gxg_pango_renderer_draw_glyphs(Xen renderer, Xen font, Xen glyphs, Xen x, Xen y)
{
  #define H_pango_renderer_draw_glyphs "void pango_renderer_draw_glyphs(PangoRenderer* renderer, PangoFont* font, \
PangoGlyphString* glyphs, int x, int y)"
  Xen_check_type(Xen_is_PangoRenderer_(renderer), renderer, 1, "pango_renderer_draw_glyphs", "PangoRenderer*");
  Xen_check_type(Xen_is_PangoFont_(font), font, 2, "pango_renderer_draw_glyphs", "PangoFont*");
  Xen_check_type(Xen_is_PangoGlyphString_(glyphs), glyphs, 3, "pango_renderer_draw_glyphs", "PangoGlyphString*");
  Xen_check_type(Xen_is_int(x), x, 4, "pango_renderer_draw_glyphs", "int");
  Xen_check_type(Xen_is_int(y), y, 5, "pango_renderer_draw_glyphs", "int");
  pango_renderer_draw_glyphs(Xen_to_C_PangoRenderer_(renderer), Xen_to_C_PangoFont_(font), Xen_to_C_PangoGlyphString_(glyphs), 
                             Xen_to_C_int(x), Xen_to_C_int(y));
  return(Xen_false);
}

static Xen gxg_pango_renderer_draw_rectangle(Xen renderer, Xen part, Xen x, Xen y, Xen width, Xen height)
{
  #define H_pango_renderer_draw_rectangle "void pango_renderer_draw_rectangle(PangoRenderer* renderer, \
PangoRenderPart part, int x, int y, int width, int height)"
  Xen_check_type(Xen_is_PangoRenderer_(renderer), renderer, 1, "pango_renderer_draw_rectangle", "PangoRenderer*");
  Xen_check_type(Xen_is_PangoRenderPart(part), part, 2, "pango_renderer_draw_rectangle", "PangoRenderPart");
  Xen_check_type(Xen_is_int(x), x, 3, "pango_renderer_draw_rectangle", "int");
  Xen_check_type(Xen_is_int(y), y, 4, "pango_renderer_draw_rectangle", "int");
  Xen_check_type(Xen_is_int(width), width, 5, "pango_renderer_draw_rectangle", "int");
  Xen_check_type(Xen_is_int(height), height, 6, "pango_renderer_draw_rectangle", "int");
  pango_renderer_draw_rectangle(Xen_to_C_PangoRenderer_(renderer), Xen_to_C_PangoRenderPart(part), Xen_to_C_int(x), Xen_to_C_int(y), 
                                Xen_to_C_int(width), Xen_to_C_int(height));
  return(Xen_false);
}

static Xen gxg_pango_renderer_draw_error_underline(Xen renderer, Xen x, Xen y, Xen width, Xen height)
{
  #define H_pango_renderer_draw_error_underline "void pango_renderer_draw_error_underline(PangoRenderer* renderer, \
int x, int y, int width, int height)"
  Xen_check_type(Xen_is_PangoRenderer_(renderer), renderer, 1, "pango_renderer_draw_error_underline", "PangoRenderer*");
  Xen_check_type(Xen_is_int(x), x, 2, "pango_renderer_draw_error_underline", "int");
  Xen_check_type(Xen_is_int(y), y, 3, "pango_renderer_draw_error_underline", "int");
  Xen_check_type(Xen_is_int(width), width, 4, "pango_renderer_draw_error_underline", "int");
  Xen_check_type(Xen_is_int(height), height, 5, "pango_renderer_draw_error_underline", "int");
  pango_renderer_draw_error_underline(Xen_to_C_PangoRenderer_(renderer), Xen_to_C_int(x), Xen_to_C_int(y), Xen_to_C_int(width), 
                                      Xen_to_C_int(height));
  return(Xen_false);
}

static Xen gxg_pango_renderer_draw_trapezoid(Xen arglist)
{
  #define H_pango_renderer_draw_trapezoid "void pango_renderer_draw_trapezoid(PangoRenderer* renderer, \
PangoRenderPart part, double y1, double x11, double x21, double y2, double x12, double x22)"
  Xen renderer, part, y1, x11, x21, y2, x12, x22;
  renderer = Xen_list_ref(arglist, 0);
  part = Xen_list_ref(arglist, 1);
  y1 = Xen_list_ref(arglist, 2);
  x11 = Xen_list_ref(arglist, 3);
  x21 = Xen_list_ref(arglist, 4);
  y2 = Xen_list_ref(arglist, 5);
  x12 = Xen_list_ref(arglist, 6);
  x22 = Xen_list_ref(arglist, 7);
  Xen_check_type(Xen_is_PangoRenderer_(renderer), renderer, 1, "pango_renderer_draw_trapezoid", "PangoRenderer*");
  Xen_check_type(Xen_is_PangoRenderPart(part), part, 2, "pango_renderer_draw_trapezoid", "PangoRenderPart");
  Xen_check_type(Xen_is_double(y1), y1, 3, "pango_renderer_draw_trapezoid", "double");
  Xen_check_type(Xen_is_double(x11), x11, 4, "pango_renderer_draw_trapezoid", "double");
  Xen_check_type(Xen_is_double(x21), x21, 5, "pango_renderer_draw_trapezoid", "double");
  Xen_check_type(Xen_is_double(y2), y2, 6, "pango_renderer_draw_trapezoid", "double");
  Xen_check_type(Xen_is_double(x12), x12, 7, "pango_renderer_draw_trapezoid", "double");
  Xen_check_type(Xen_is_double(x22), x22, 8, "pango_renderer_draw_trapezoid", "double");
  pango_renderer_draw_trapezoid(Xen_to_C_PangoRenderer_(renderer), Xen_to_C_PangoRenderPart(part), Xen_to_C_double(y1), Xen_to_C_double(x11), 
                                Xen_to_C_double(x21), Xen_to_C_double(y2), Xen_to_C_double(x12), Xen_to_C_double(x22));
  return(Xen_false);
}

static Xen gxg_pango_renderer_draw_glyph(Xen renderer, Xen font, Xen glyph, Xen x, Xen y)
{
  #define H_pango_renderer_draw_glyph "void pango_renderer_draw_glyph(PangoRenderer* renderer, PangoFont* font, \
PangoGlyph glyph, double x, double y)"
  Xen_check_type(Xen_is_PangoRenderer_(renderer), renderer, 1, "pango_renderer_draw_glyph", "PangoRenderer*");
  Xen_check_type(Xen_is_PangoFont_(font), font, 2, "pango_renderer_draw_glyph", "PangoFont*");
  Xen_check_type(Xen_is_PangoGlyph(glyph), glyph, 3, "pango_renderer_draw_glyph", "PangoGlyph");
  Xen_check_type(Xen_is_double(x), x, 4, "pango_renderer_draw_glyph", "double");
  Xen_check_type(Xen_is_double(y), y, 5, "pango_renderer_draw_glyph", "double");
  pango_renderer_draw_glyph(Xen_to_C_PangoRenderer_(renderer), Xen_to_C_PangoFont_(font), Xen_to_C_PangoGlyph(glyph), Xen_to_C_double(x), 
                            Xen_to_C_double(y));
  return(Xen_false);
}

static Xen gxg_pango_renderer_activate(Xen renderer)
{
  #define H_pango_renderer_activate "void pango_renderer_activate(PangoRenderer* renderer)"
  Xen_check_type(Xen_is_PangoRenderer_(renderer), renderer, 1, "pango_renderer_activate", "PangoRenderer*");
  pango_renderer_activate(Xen_to_C_PangoRenderer_(renderer));
  return(Xen_false);
}

static Xen gxg_pango_renderer_deactivate(Xen renderer)
{
  #define H_pango_renderer_deactivate "void pango_renderer_deactivate(PangoRenderer* renderer)"
  Xen_check_type(Xen_is_PangoRenderer_(renderer), renderer, 1, "pango_renderer_deactivate", "PangoRenderer*");
  pango_renderer_deactivate(Xen_to_C_PangoRenderer_(renderer));
  return(Xen_false);
}

static Xen gxg_pango_renderer_part_changed(Xen renderer, Xen part)
{
  #define H_pango_renderer_part_changed "void pango_renderer_part_changed(PangoRenderer* renderer, PangoRenderPart part)"
  Xen_check_type(Xen_is_PangoRenderer_(renderer), renderer, 1, "pango_renderer_part_changed", "PangoRenderer*");
  Xen_check_type(Xen_is_PangoRenderPart(part), part, 2, "pango_renderer_part_changed", "PangoRenderPart");
  pango_renderer_part_changed(Xen_to_C_PangoRenderer_(renderer), Xen_to_C_PangoRenderPart(part));
  return(Xen_false);
}

static Xen gxg_pango_renderer_set_color(Xen renderer, Xen part, Xen color)
{
  #define H_pango_renderer_set_color "void pango_renderer_set_color(PangoRenderer* renderer, PangoRenderPart part, \
PangoColor* color)"
  Xen_check_type(Xen_is_PangoRenderer_(renderer), renderer, 1, "pango_renderer_set_color", "PangoRenderer*");
  Xen_check_type(Xen_is_PangoRenderPart(part), part, 2, "pango_renderer_set_color", "PangoRenderPart");
  Xen_check_type(Xen_is_PangoColor_(color), color, 3, "pango_renderer_set_color", "PangoColor*");
  pango_renderer_set_color(Xen_to_C_PangoRenderer_(renderer), Xen_to_C_PangoRenderPart(part), Xen_to_C_PangoColor_(color));
  return(Xen_false);
}

static Xen gxg_pango_renderer_get_color(Xen renderer, Xen part)
{
  #define H_pango_renderer_get_color "PangoColor* pango_renderer_get_color(PangoRenderer* renderer, PangoRenderPart part)"
  Xen_check_type(Xen_is_PangoRenderer_(renderer), renderer, 1, "pango_renderer_get_color", "PangoRenderer*");
  Xen_check_type(Xen_is_PangoRenderPart(part), part, 2, "pango_renderer_get_color", "PangoRenderPart");
  return(C_to_Xen_PangoColor_(pango_renderer_get_color(Xen_to_C_PangoRenderer_(renderer), Xen_to_C_PangoRenderPart(part))));
}

static Xen gxg_pango_renderer_set_matrix(Xen renderer, Xen matrix)
{
  #define H_pango_renderer_set_matrix "void pango_renderer_set_matrix(PangoRenderer* renderer, PangoMatrix* matrix)"
  Xen_check_type(Xen_is_PangoRenderer_(renderer), renderer, 1, "pango_renderer_set_matrix", "PangoRenderer*");
  Xen_check_type(Xen_is_PangoMatrix_(matrix), matrix, 2, "pango_renderer_set_matrix", "PangoMatrix*");
  pango_renderer_set_matrix(Xen_to_C_PangoRenderer_(renderer), Xen_to_C_PangoMatrix_(matrix));
  return(Xen_false);
}

static Xen gxg_g_log_set_handler(Xen log_domain, Xen log_levels, Xen func, Xen func_info)
{
  #define H_g_log_set_handler "guint g_log_set_handler(gchar* log_domain, GLogLevelFlags log_levels, \
GLogFunc func, lambda_data func_info)"
  Xen_check_type(Xen_is_gchar_(log_domain), log_domain, 1, "g_log_set_handler", "gchar*");
  Xen_check_type(Xen_is_GLogLevelFlags(log_levels), log_levels, 2, "g_log_set_handler", "GLogLevelFlags");
  Xen_check_type(Xen_is_GLogFunc(func), func, 3, "g_log_set_handler", "GLogFunc");
  Xen_check_type(Xen_is_lambda_data(func_info) || Xen_is_false(func_info), func_info, 4, "g_log_set_handler", "lambda_data");
  {
    Xen res_ult;
    Xen gxg_ptr = Xen_list_5(func, func_info, Xen_false, Xen_false, Xen_false);
    xm_protect(gxg_ptr);
    res_ult = C_to_Xen_guint(g_log_set_handler(Xen_to_C_gchar_(log_domain), Xen_to_C_GLogLevelFlags(log_levels), Xen_to_C_GLogFunc(func), 
                                               Xen_to_C_lambda_data(func_info)));
    return(res_ult);
   }
}

static Xen gxg_g_log_remove_handler(Xen log_domain, Xen handler_id)
{
  #define H_g_log_remove_handler "void g_log_remove_handler(gchar* log_domain, guint handler_id)"
  Xen_check_type(Xen_is_gchar_(log_domain), log_domain, 1, "g_log_remove_handler", "gchar*");
  Xen_check_type(Xen_is_guint(handler_id), handler_id, 2, "g_log_remove_handler", "guint");
  g_log_remove_handler(Xen_to_C_gchar_(log_domain), Xen_to_C_guint(handler_id));
  return(Xen_false);
}

static Xen gxg_gtk_cell_renderer_stop_editing(Xen cell, Xen canceled)
{
  #define H_gtk_cell_renderer_stop_editing "void gtk_cell_renderer_stop_editing(GtkCellRenderer* cell, \
gboolean canceled)"
  Xen_check_type(Xen_is_GtkCellRenderer_(cell), cell, 1, "gtk_cell_renderer_stop_editing", "GtkCellRenderer*");
  Xen_check_type(Xen_is_gboolean(canceled), canceled, 2, "gtk_cell_renderer_stop_editing", "gboolean");
  gtk_cell_renderer_stop_editing(Xen_to_C_GtkCellRenderer_(cell), Xen_to_C_gboolean(canceled));
  return(Xen_false);
}

static Xen gxg_gtk_file_chooser_button_new(Xen title, Xen action)
{
  #define H_gtk_file_chooser_button_new "GtkWidget* gtk_file_chooser_button_new(gchar* title, GtkFileChooserAction action)"
  Xen_check_type(Xen_is_gchar_(title), title, 1, "gtk_file_chooser_button_new", "gchar*");
  Xen_check_type(Xen_is_GtkFileChooserAction(action), action, 2, "gtk_file_chooser_button_new", "GtkFileChooserAction");
  return(C_to_Xen_GtkWidget_(gtk_file_chooser_button_new((const gchar*)Xen_to_C_gchar_(title), Xen_to_C_GtkFileChooserAction(action))));
}

static Xen gxg_gtk_icon_view_set_columns(Xen icon_view, Xen columns)
{
  #define H_gtk_icon_view_set_columns "void gtk_icon_view_set_columns(GtkIconView* icon_view, gint columns)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_set_columns", "GtkIconView*");
  Xen_check_type(Xen_is_gint(columns), columns, 2, "gtk_icon_view_set_columns", "gint");
  gtk_icon_view_set_columns(Xen_to_C_GtkIconView_(icon_view), Xen_to_C_gint(columns));
  return(Xen_false);
}

static Xen gxg_gtk_icon_view_get_columns(Xen icon_view)
{
  #define H_gtk_icon_view_get_columns "gint gtk_icon_view_get_columns(GtkIconView* icon_view)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_get_columns", "GtkIconView*");
  return(C_to_Xen_gint(gtk_icon_view_get_columns(Xen_to_C_GtkIconView_(icon_view))));
}

static Xen gxg_gtk_icon_view_set_item_width(Xen icon_view, Xen item_width)
{
  #define H_gtk_icon_view_set_item_width "void gtk_icon_view_set_item_width(GtkIconView* icon_view, gint item_width)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_set_item_width", "GtkIconView*");
  Xen_check_type(Xen_is_gint(item_width), item_width, 2, "gtk_icon_view_set_item_width", "gint");
  gtk_icon_view_set_item_width(Xen_to_C_GtkIconView_(icon_view), Xen_to_C_gint(item_width));
  return(Xen_false);
}

static Xen gxg_gtk_icon_view_get_item_width(Xen icon_view)
{
  #define H_gtk_icon_view_get_item_width "gint gtk_icon_view_get_item_width(GtkIconView* icon_view)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_get_item_width", "GtkIconView*");
  return(C_to_Xen_gint(gtk_icon_view_get_item_width(Xen_to_C_GtkIconView_(icon_view))));
}

static Xen gxg_gtk_icon_view_set_spacing(Xen icon_view, Xen spacing)
{
  #define H_gtk_icon_view_set_spacing "void gtk_icon_view_set_spacing(GtkIconView* icon_view, gint spacing)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_set_spacing", "GtkIconView*");
  Xen_check_type(Xen_is_gint(spacing), spacing, 2, "gtk_icon_view_set_spacing", "gint");
  gtk_icon_view_set_spacing(Xen_to_C_GtkIconView_(icon_view), Xen_to_C_gint(spacing));
  return(Xen_false);
}

static Xen gxg_gtk_icon_view_get_spacing(Xen icon_view)
{
  #define H_gtk_icon_view_get_spacing "gint gtk_icon_view_get_spacing(GtkIconView* icon_view)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_get_spacing", "GtkIconView*");
  return(C_to_Xen_gint(gtk_icon_view_get_spacing(Xen_to_C_GtkIconView_(icon_view))));
}

static Xen gxg_gtk_icon_view_set_row_spacing(Xen icon_view, Xen row_spacing)
{
  #define H_gtk_icon_view_set_row_spacing "void gtk_icon_view_set_row_spacing(GtkIconView* icon_view, \
gint row_spacing)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_set_row_spacing", "GtkIconView*");
  Xen_check_type(Xen_is_gint(row_spacing), row_spacing, 2, "gtk_icon_view_set_row_spacing", "gint");
  gtk_icon_view_set_row_spacing(Xen_to_C_GtkIconView_(icon_view), Xen_to_C_gint(row_spacing));
  return(Xen_false);
}

static Xen gxg_gtk_icon_view_get_row_spacing(Xen icon_view)
{
  #define H_gtk_icon_view_get_row_spacing "gint gtk_icon_view_get_row_spacing(GtkIconView* icon_view)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_get_row_spacing", "GtkIconView*");
  return(C_to_Xen_gint(gtk_icon_view_get_row_spacing(Xen_to_C_GtkIconView_(icon_view))));
}

static Xen gxg_gtk_icon_view_set_column_spacing(Xen icon_view, Xen column_spacing)
{
  #define H_gtk_icon_view_set_column_spacing "void gtk_icon_view_set_column_spacing(GtkIconView* icon_view, \
gint column_spacing)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_set_column_spacing", "GtkIconView*");
  Xen_check_type(Xen_is_gint(column_spacing), column_spacing, 2, "gtk_icon_view_set_column_spacing", "gint");
  gtk_icon_view_set_column_spacing(Xen_to_C_GtkIconView_(icon_view), Xen_to_C_gint(column_spacing));
  return(Xen_false);
}

static Xen gxg_gtk_icon_view_get_column_spacing(Xen icon_view)
{
  #define H_gtk_icon_view_get_column_spacing "gint gtk_icon_view_get_column_spacing(GtkIconView* icon_view)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_get_column_spacing", "GtkIconView*");
  return(C_to_Xen_gint(gtk_icon_view_get_column_spacing(Xen_to_C_GtkIconView_(icon_view))));
}

static Xen gxg_gtk_icon_view_set_margin(Xen icon_view, Xen margin)
{
  #define H_gtk_icon_view_set_margin "void gtk_icon_view_set_margin(GtkIconView* icon_view, gint margin)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_set_margin", "GtkIconView*");
  Xen_check_type(Xen_is_gint(margin), margin, 2, "gtk_icon_view_set_margin", "gint");
  gtk_icon_view_set_margin(Xen_to_C_GtkIconView_(icon_view), Xen_to_C_gint(margin));
  return(Xen_false);
}

static Xen gxg_gtk_icon_view_get_margin(Xen icon_view)
{
  #define H_gtk_icon_view_get_margin "gint gtk_icon_view_get_margin(GtkIconView* icon_view)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_get_margin", "GtkIconView*");
  return(C_to_Xen_gint(gtk_icon_view_get_margin(Xen_to_C_GtkIconView_(icon_view))));
}

static Xen gxg_gtk_label_set_max_width_chars(Xen label, Xen n_chars)
{
  #define H_gtk_label_set_max_width_chars "void gtk_label_set_max_width_chars(GtkLabel* label, gint n_chars)"
  Xen_check_type(Xen_is_GtkLabel_(label), label, 1, "gtk_label_set_max_width_chars", "GtkLabel*");
  Xen_check_type(Xen_is_gint(n_chars), n_chars, 2, "gtk_label_set_max_width_chars", "gint");
  gtk_label_set_max_width_chars(Xen_to_C_GtkLabel_(label), Xen_to_C_gint(n_chars));
  return(Xen_false);
}

static Xen gxg_gtk_label_get_max_width_chars(Xen label)
{
  #define H_gtk_label_get_max_width_chars "gint gtk_label_get_max_width_chars(GtkLabel* label)"
  Xen_check_type(Xen_is_GtkLabel_(label), label, 1, "gtk_label_get_max_width_chars", "GtkLabel*");
  return(C_to_Xen_gint(gtk_label_get_max_width_chars(Xen_to_C_GtkLabel_(label))));
}

static Xen gxg_gtk_list_store_insert_with_values(Xen list_store, Xen iter, Xen position)
{
  #define H_gtk_list_store_insert_with_values "void gtk_list_store_insert_with_values(GtkListStore* list_store, \
GtkTreeIter* iter, gint position, ...)"
  Xen_check_type(Xen_is_GtkListStore_(list_store), list_store, 1, "gtk_list_store_insert_with_values", "GtkListStore*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_list_store_insert_with_values", "GtkTreeIter*");
  Xen_check_type(Xen_is_gint(position), position, 3, "gtk_list_store_insert_with_values", "gint");
  gtk_list_store_insert_with_values(Xen_to_C_GtkListStore_(list_store), Xen_to_C_GtkTreeIter_(iter), Xen_to_C_gint(position));
  return(Xen_false);
}

static Xen gxg_gtk_list_store_insert_with_valuesv(Xen list_store, Xen iter, Xen position, Xen columns, Xen values, Xen n_values)
{
  #define H_gtk_list_store_insert_with_valuesv "void gtk_list_store_insert_with_valuesv(GtkListStore* list_store, \
GtkTreeIter* iter, gint position, gint* columns, GValue* values, gint n_values)"
  Xen_check_type(Xen_is_GtkListStore_(list_store), list_store, 1, "gtk_list_store_insert_with_valuesv", "GtkListStore*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_list_store_insert_with_valuesv", "GtkTreeIter*");
  Xen_check_type(Xen_is_gint(position), position, 3, "gtk_list_store_insert_with_valuesv", "gint");
  Xen_check_type(Xen_is_gint_(columns), columns, 4, "gtk_list_store_insert_with_valuesv", "gint*");
  Xen_check_type(Xen_is_GValue_(values), values, 5, "gtk_list_store_insert_with_valuesv", "GValue*");
  Xen_check_type(Xen_is_gint(n_values), n_values, 6, "gtk_list_store_insert_with_valuesv", "gint");
  gtk_list_store_insert_with_valuesv(Xen_to_C_GtkListStore_(list_store), Xen_to_C_GtkTreeIter_(iter), Xen_to_C_gint(position), 
                                     Xen_to_C_gint_(columns), Xen_to_C_GValue_(values), Xen_to_C_gint(n_values));
  return(Xen_false);
}

static Xen gxg_pango_attr_size_new_absolute(Xen size)
{
  #define H_pango_attr_size_new_absolute "PangoAttribute* pango_attr_size_new_absolute(int size)"
  Xen_check_type(Xen_is_int(size), size, 1, "pango_attr_size_new_absolute", "int");
  return(C_to_Xen_PangoAttribute_(pango_attr_size_new_absolute(Xen_to_C_int(size))));
}

static Xen gxg_pango_font_description_set_absolute_size(Xen desc, Xen size)
{
  #define H_pango_font_description_set_absolute_size "void pango_font_description_set_absolute_size(PangoFontDescription* desc, \
double size)"
  Xen_check_type(Xen_is_PangoFontDescription_(desc), desc, 1, "pango_font_description_set_absolute_size", "PangoFontDescription*");
  Xen_check_type(Xen_is_double(size), size, 2, "pango_font_description_set_absolute_size", "double");
  pango_font_description_set_absolute_size(Xen_to_C_PangoFontDescription_(desc), Xen_to_C_double(size));
  return(Xen_false);
}

static Xen gxg_pango_layout_get_font_description(Xen layout)
{
  #define H_pango_layout_get_font_description "PangoFontDescription* pango_layout_get_font_description(PangoLayout* layout)"
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_get_font_description", "PangoLayout*");
    return(C_to_Xen_PangoFontDescription_((PangoFontDescription*)pango_layout_get_font_description(Xen_to_C_PangoLayout_(layout))));
}

static Xen gxg_gtk_dialog_get_response_for_widget(Xen dialog, Xen widget)
{
  #define H_gtk_dialog_get_response_for_widget "gint gtk_dialog_get_response_for_widget(GtkDialog* dialog, \
GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkDialog_(dialog), dialog, 1, "gtk_dialog_get_response_for_widget", "GtkDialog*");
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 2, "gtk_dialog_get_response_for_widget", "GtkWidget*");
  return(C_to_Xen_gint(gtk_dialog_get_response_for_widget(Xen_to_C_GtkDialog_(dialog), Xen_to_C_GtkWidget_(widget))));
}

static Xen gxg_gtk_entry_completion_set_popup_set_width(Xen completion, Xen popup_set_width)
{
  #define H_gtk_entry_completion_set_popup_set_width "void gtk_entry_completion_set_popup_set_width(GtkEntryCompletion* completion, \
gboolean popup_set_width)"
  Xen_check_type(Xen_is_GtkEntryCompletion_(completion), completion, 1, "gtk_entry_completion_set_popup_set_width", "GtkEntryCompletion*");
  Xen_check_type(Xen_is_gboolean(popup_set_width), popup_set_width, 2, "gtk_entry_completion_set_popup_set_width", "gboolean");
  gtk_entry_completion_set_popup_set_width(Xen_to_C_GtkEntryCompletion_(completion), Xen_to_C_gboolean(popup_set_width));
  return(Xen_false);
}

static Xen gxg_gtk_entry_completion_get_popup_set_width(Xen completion)
{
  #define H_gtk_entry_completion_get_popup_set_width "gboolean gtk_entry_completion_get_popup_set_width(GtkEntryCompletion* completion)"
  Xen_check_type(Xen_is_GtkEntryCompletion_(completion), completion, 1, "gtk_entry_completion_get_popup_set_width", "GtkEntryCompletion*");
  return(C_to_Xen_gboolean(gtk_entry_completion_get_popup_set_width(Xen_to_C_GtkEntryCompletion_(completion))));
}

static Xen gxg_gtk_entry_completion_set_popup_single_match(Xen completion, Xen popup_single_match)
{
  #define H_gtk_entry_completion_set_popup_single_match "void gtk_entry_completion_set_popup_single_match(GtkEntryCompletion* completion, \
gboolean popup_single_match)"
  Xen_check_type(Xen_is_GtkEntryCompletion_(completion), completion, 1, "gtk_entry_completion_set_popup_single_match", "GtkEntryCompletion*");
  Xen_check_type(Xen_is_gboolean(popup_single_match), popup_single_match, 2, "gtk_entry_completion_set_popup_single_match", "gboolean");
  gtk_entry_completion_set_popup_single_match(Xen_to_C_GtkEntryCompletion_(completion), Xen_to_C_gboolean(popup_single_match));
  return(Xen_false);
}

static Xen gxg_gtk_entry_completion_get_popup_single_match(Xen completion)
{
  #define H_gtk_entry_completion_get_popup_single_match "gboolean gtk_entry_completion_get_popup_single_match(GtkEntryCompletion* completion)"
  Xen_check_type(Xen_is_GtkEntryCompletion_(completion), completion, 1, "gtk_entry_completion_get_popup_single_match", "GtkEntryCompletion*");
  return(C_to_Xen_gboolean(gtk_entry_completion_get_popup_single_match(Xen_to_C_GtkEntryCompletion_(completion))));
}

static Xen gxg_gtk_icon_view_get_item_at_pos(Xen icon_view, Xen x, Xen y, Xen ignore_path, Xen ignore_cell)
{
  #define H_gtk_icon_view_get_item_at_pos "gboolean gtk_icon_view_get_item_at_pos(GtkIconView* icon_view, \
gint x, gint y, GtkTreePath** [path], GtkCellRenderer** [cell])"
  GtkTreePath* ref_path = NULL;
  GtkCellRenderer* ref_cell = NULL;
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_get_item_at_pos", "GtkIconView*");
  Xen_check_type(Xen_is_gint(x), x, 2, "gtk_icon_view_get_item_at_pos", "gint");
  Xen_check_type(Xen_is_gint(y), y, 3, "gtk_icon_view_get_item_at_pos", "gint");
  {
    Xen res_ult;
    res_ult = C_to_Xen_gboolean(gtk_icon_view_get_item_at_pos(Xen_to_C_GtkIconView_(icon_view), Xen_to_C_gint(x), Xen_to_C_gint(y), 
                                                              &ref_path, &ref_cell));
    return(Xen_list_3(res_ult, C_to_Xen_GtkTreePath_(ref_path), C_to_Xen_GtkCellRenderer_(ref_cell)));
   }
}

static Xen gxg_gtk_icon_view_get_visible_range(Xen icon_view, Xen ignore_start_path, Xen ignore_end_path)
{
  #define H_gtk_icon_view_get_visible_range "gboolean gtk_icon_view_get_visible_range(GtkIconView* icon_view, \
GtkTreePath** [start_path], GtkTreePath** [end_path])"
  GtkTreePath* ref_start_path = NULL;
  GtkTreePath* ref_end_path = NULL;
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_get_visible_range", "GtkIconView*");
  {
    Xen res_ult;
    res_ult = C_to_Xen_gboolean(gtk_icon_view_get_visible_range(Xen_to_C_GtkIconView_(icon_view), &ref_start_path, &ref_end_path));
    return(Xen_list_3(res_ult, C_to_Xen_GtkTreePath_(ref_start_path), C_to_Xen_GtkTreePath_(ref_end_path)));
   }
}

static Xen gxg_gtk_icon_view_set_cursor(Xen icon_view, Xen path, Xen cell, Xen start_editing)
{
  #define H_gtk_icon_view_set_cursor "void gtk_icon_view_set_cursor(GtkIconView* icon_view, GtkTreePath* path, \
GtkCellRenderer* cell, gboolean start_editing)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_set_cursor", "GtkIconView*");
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 2, "gtk_icon_view_set_cursor", "GtkTreePath*");
  Xen_check_type(Xen_is_GtkCellRenderer_(cell), cell, 3, "gtk_icon_view_set_cursor", "GtkCellRenderer*");
  Xen_check_type(Xen_is_gboolean(start_editing), start_editing, 4, "gtk_icon_view_set_cursor", "gboolean");
  gtk_icon_view_set_cursor(Xen_to_C_GtkIconView_(icon_view), Xen_to_C_GtkTreePath_(path), Xen_to_C_GtkCellRenderer_(cell), 
                           Xen_to_C_gboolean(start_editing));
  return(Xen_false);
}

static Xen gxg_gtk_icon_view_get_cursor(Xen icon_view, Xen ignore_path, Xen ignore_cell)
{
  #define H_gtk_icon_view_get_cursor "gboolean gtk_icon_view_get_cursor(GtkIconView* icon_view, GtkTreePath** [path], \
GtkCellRenderer** [cell])"
  GtkTreePath* ref_path = NULL;
  GtkCellRenderer* ref_cell = NULL;
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_get_cursor", "GtkIconView*");
  {
    Xen res_ult;
    res_ult = C_to_Xen_gboolean(gtk_icon_view_get_cursor(Xen_to_C_GtkIconView_(icon_view), &ref_path, &ref_cell));
    return(Xen_list_3(res_ult, C_to_Xen_GtkTreePath_(ref_path), C_to_Xen_GtkCellRenderer_(ref_cell)));
   }
}

static Xen gxg_gtk_icon_view_scroll_to_path(Xen icon_view, Xen path, Xen use_align, Xen row_align, Xen col_align)
{
  #define H_gtk_icon_view_scroll_to_path "void gtk_icon_view_scroll_to_path(GtkIconView* icon_view, GtkTreePath* path, \
gboolean use_align, gfloat row_align, gfloat col_align)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_scroll_to_path", "GtkIconView*");
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 2, "gtk_icon_view_scroll_to_path", "GtkTreePath*");
  Xen_check_type(Xen_is_gboolean(use_align), use_align, 3, "gtk_icon_view_scroll_to_path", "gboolean");
  Xen_check_type(Xen_is_gfloat(row_align), row_align, 4, "gtk_icon_view_scroll_to_path", "gfloat");
  Xen_check_type(Xen_is_gfloat(col_align), col_align, 5, "gtk_icon_view_scroll_to_path", "gfloat");
  gtk_icon_view_scroll_to_path(Xen_to_C_GtkIconView_(icon_view), Xen_to_C_GtkTreePath_(path), Xen_to_C_gboolean(use_align), 
                               Xen_to_C_gfloat(row_align), Xen_to_C_gfloat(col_align));
  return(Xen_false);
}

static Xen gxg_gtk_icon_view_unset_model_drag_source(Xen icon_view)
{
  #define H_gtk_icon_view_unset_model_drag_source "void gtk_icon_view_unset_model_drag_source(GtkIconView* icon_view)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_unset_model_drag_source", "GtkIconView*");
  gtk_icon_view_unset_model_drag_source(Xen_to_C_GtkIconView_(icon_view));
  return(Xen_false);
}

static Xen gxg_gtk_icon_view_set_reorderable(Xen icon_view, Xen reorderable)
{
  #define H_gtk_icon_view_set_reorderable "void gtk_icon_view_set_reorderable(GtkIconView* icon_view, \
gboolean reorderable)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_set_reorderable", "GtkIconView*");
  Xen_check_type(Xen_is_gboolean(reorderable), reorderable, 2, "gtk_icon_view_set_reorderable", "gboolean");
  gtk_icon_view_set_reorderable(Xen_to_C_GtkIconView_(icon_view), Xen_to_C_gboolean(reorderable));
  return(Xen_false);
}

static Xen gxg_gtk_icon_view_get_reorderable(Xen icon_view)
{
  #define H_gtk_icon_view_get_reorderable "gboolean gtk_icon_view_get_reorderable(GtkIconView* icon_view)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_get_reorderable", "GtkIconView*");
  return(C_to_Xen_gboolean(gtk_icon_view_get_reorderable(Xen_to_C_GtkIconView_(icon_view))));
}

static Xen gxg_gtk_icon_view_get_dest_item_at_pos(Xen icon_view, Xen drag_x, Xen drag_y, Xen ignore_path, Xen ignore_pos)
{
  #define H_gtk_icon_view_get_dest_item_at_pos "gboolean gtk_icon_view_get_dest_item_at_pos(GtkIconView* icon_view, \
gint drag_x, gint drag_y, GtkTreePath** [path], GtkIconViewDropPosition* [pos])"
  GtkTreePath* ref_path = NULL;
  GtkIconViewDropPosition ref_pos;
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_get_dest_item_at_pos", "GtkIconView*");
  Xen_check_type(Xen_is_gint(drag_x), drag_x, 2, "gtk_icon_view_get_dest_item_at_pos", "gint");
  Xen_check_type(Xen_is_gint(drag_y), drag_y, 3, "gtk_icon_view_get_dest_item_at_pos", "gint");
  {
    Xen res_ult;
    res_ult = C_to_Xen_gboolean(gtk_icon_view_get_dest_item_at_pos(Xen_to_C_GtkIconView_(icon_view), Xen_to_C_gint(drag_x), 
                                                                   Xen_to_C_gint(drag_y), &ref_path, &ref_pos));
    return(Xen_list_3(res_ult, C_to_Xen_GtkTreePath_(ref_path), C_to_Xen_GtkIconViewDropPosition(ref_pos)));
   }
}

static Xen gxg_gtk_image_clear(Xen image)
{
  #define H_gtk_image_clear "void gtk_image_clear(GtkImage* image)"
  Xen_check_type(Xen_is_GtkImage_(image), image, 1, "gtk_image_clear", "GtkImage*");
  gtk_image_clear(Xen_to_C_GtkImage_(image));
  return(Xen_false);
}

static Xen gxg_gtk_text_iter_forward_visible_line(Xen iter)
{
  #define H_gtk_text_iter_forward_visible_line "gboolean gtk_text_iter_forward_visible_line(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_forward_visible_line", "GtkTextIter*");
  return(C_to_Xen_gboolean(gtk_text_iter_forward_visible_line(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_backward_visible_line(Xen iter)
{
  #define H_gtk_text_iter_backward_visible_line "gboolean gtk_text_iter_backward_visible_line(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_backward_visible_line", "GtkTextIter*");
  return(C_to_Xen_gboolean(gtk_text_iter_backward_visible_line(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_forward_visible_lines(Xen iter, Xen count)
{
  #define H_gtk_text_iter_forward_visible_lines "gboolean gtk_text_iter_forward_visible_lines(GtkTextIter* iter, \
gint count)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_forward_visible_lines", "GtkTextIter*");
  Xen_check_type(Xen_is_gint(count), count, 2, "gtk_text_iter_forward_visible_lines", "gint");
  return(C_to_Xen_gboolean(gtk_text_iter_forward_visible_lines(Xen_to_C_GtkTextIter_(iter), Xen_to_C_gint(count))));
}

static Xen gxg_gtk_text_iter_backward_visible_lines(Xen iter, Xen count)
{
  #define H_gtk_text_iter_backward_visible_lines "gboolean gtk_text_iter_backward_visible_lines(GtkTextIter* iter, \
gint count)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_backward_visible_lines", "GtkTextIter*");
  Xen_check_type(Xen_is_gint(count), count, 2, "gtk_text_iter_backward_visible_lines", "gint");
  return(C_to_Xen_gboolean(gtk_text_iter_backward_visible_lines(Xen_to_C_GtkTextIter_(iter), Xen_to_C_gint(count))));
}

static Xen gxg_gtk_window_present_with_time(Xen window, Xen timestamp)
{
  #define H_gtk_window_present_with_time "void gtk_window_present_with_time(GtkWindow* window, guint32 timestamp)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_present_with_time", "GtkWindow*");
  Xen_check_type(Xen_is_guint32(timestamp), timestamp, 2, "gtk_window_present_with_time", "guint32");
  gtk_window_present_with_time(Xen_to_C_GtkWindow_(window), Xen_to_C_guint32(timestamp));
  return(Xen_false);
}

static Xen gxg_gtk_tree_row_reference_get_model(Xen reference)
{
  #define H_gtk_tree_row_reference_get_model "GtkTreeModel* gtk_tree_row_reference_get_model(GtkTreeRowReference* reference)"
  Xen_check_type(Xen_is_GtkTreeRowReference_(reference), reference, 1, "gtk_tree_row_reference_get_model", "GtkTreeRowReference*");
  return(C_to_Xen_GtkTreeModel_(gtk_tree_row_reference_get_model(Xen_to_C_GtkTreeRowReference_(reference))));
}

static Xen gxg_gtk_tree_view_column_queue_resize(Xen tree_column)
{
  #define H_gtk_tree_view_column_queue_resize "void gtk_tree_view_column_queue_resize(GtkTreeViewColumn* tree_column)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_queue_resize", "GtkTreeViewColumn*");
  gtk_tree_view_column_queue_resize(Xen_to_C_GtkTreeViewColumn_(tree_column));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_get_visible_range(Xen tree_view, Xen ignore_start_path, Xen ignore_end_path)
{
  #define H_gtk_tree_view_get_visible_range "gboolean gtk_tree_view_get_visible_range(GtkTreeView* tree_view, \
GtkTreePath** [start_path], GtkTreePath** [end_path])"
  GtkTreePath* ref_start_path = NULL;
  GtkTreePath* ref_end_path = NULL;
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_get_visible_range", "GtkTreeView*");
  {
    Xen res_ult;
    res_ult = C_to_Xen_gboolean(gtk_tree_view_get_visible_range(Xen_to_C_GtkTreeView_(tree_view), &ref_start_path, &ref_end_path));
    return(Xen_list_3(res_ult, C_to_Xen_GtkTreePath_(ref_start_path), C_to_Xen_GtkTreePath_(ref_end_path)));
   }
}

static Xen gxg_pango_attr_list_ref(Xen list)
{
  #define H_pango_attr_list_ref "PangoAttrList* pango_attr_list_ref(PangoAttrList* list)"
  Xen_check_type(Xen_is_PangoAttrList_(list), list, 1, "pango_attr_list_ref", "PangoAttrList*");
  return(C_to_Xen_PangoAttrList_(pango_attr_list_ref(Xen_to_C_PangoAttrList_(list))));
}

static Xen gxg_pango_layout_line_ref(Xen line)
{
  #define H_pango_layout_line_ref "PangoLayoutLine* pango_layout_line_ref(PangoLayoutLine* line)"
  Xen_check_type(Xen_is_PangoLayoutLine_(line), line, 1, "pango_layout_line_ref", "PangoLayoutLine*");
  return(C_to_Xen_PangoLayoutLine_(pango_layout_line_ref(Xen_to_C_PangoLayoutLine_(line))));
}

static Xen gxg_pango_layout_index_to_line_x(Xen layout, Xen index_, Xen trailing, Xen ignore_line, Xen ignore_x_pos)
{
  #define H_pango_layout_index_to_line_x "void pango_layout_index_to_line_x(PangoLayout* layout, int index_, \
gboolean trailing, int* [line], int* [x_pos])"
  int ref_line;
  int ref_x_pos;
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_index_to_line_x", "PangoLayout*");
  Xen_check_type(Xen_is_int(index_), index_, 2, "pango_layout_index_to_line_x", "int");
  Xen_check_type(Xen_is_gboolean(trailing), trailing, 3, "pango_layout_index_to_line_x", "gboolean");
  pango_layout_index_to_line_x(Xen_to_C_PangoLayout_(layout), Xen_to_C_int(index_), Xen_to_C_gboolean(trailing), &ref_line, 
                               &ref_x_pos);
  return(Xen_list_2(C_to_Xen_int(ref_line), C_to_Xen_int(ref_x_pos)));
}

static Xen gxg_gdk_display_supports_input_shapes(Xen display)
{
  #define H_gdk_display_supports_input_shapes "gboolean gdk_display_supports_input_shapes(GdkDisplay* display)"
  Xen_check_type(Xen_is_GdkDisplay_(display), display, 1, "gdk_display_supports_input_shapes", "GdkDisplay*");
  return(C_to_Xen_gboolean(gdk_display_supports_input_shapes(Xen_to_C_GdkDisplay_(display))));
}

static Xen gxg_gtk_notebook_get_tab_reorderable(Xen notebook, Xen child)
{
  #define H_gtk_notebook_get_tab_reorderable "gboolean gtk_notebook_get_tab_reorderable(GtkNotebook* notebook, \
GtkWidget* child)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_get_tab_reorderable", "GtkNotebook*");
  Xen_check_type(Xen_is_GtkWidget_(child), child, 2, "gtk_notebook_get_tab_reorderable", "GtkWidget*");
  return(C_to_Xen_gboolean(gtk_notebook_get_tab_reorderable(Xen_to_C_GtkNotebook_(notebook), Xen_to_C_GtkWidget_(child))));
}

static Xen gxg_gtk_notebook_set_tab_reorderable(Xen notebook, Xen child, Xen reorderable)
{
  #define H_gtk_notebook_set_tab_reorderable "void gtk_notebook_set_tab_reorderable(GtkNotebook* notebook, \
GtkWidget* child, gboolean reorderable)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_set_tab_reorderable", "GtkNotebook*");
  Xen_check_type(Xen_is_GtkWidget_(child), child, 2, "gtk_notebook_set_tab_reorderable", "GtkWidget*");
  Xen_check_type(Xen_is_gboolean(reorderable), reorderable, 3, "gtk_notebook_set_tab_reorderable", "gboolean");
  gtk_notebook_set_tab_reorderable(Xen_to_C_GtkNotebook_(notebook), Xen_to_C_GtkWidget_(child), Xen_to_C_gboolean(reorderable));
  return(Xen_false);
}

static Xen gxg_gtk_notebook_get_tab_detachable(Xen notebook, Xen child)
{
  #define H_gtk_notebook_get_tab_detachable "gboolean gtk_notebook_get_tab_detachable(GtkNotebook* notebook, \
GtkWidget* child)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_get_tab_detachable", "GtkNotebook*");
  Xen_check_type(Xen_is_GtkWidget_(child), child, 2, "gtk_notebook_get_tab_detachable", "GtkWidget*");
  return(C_to_Xen_gboolean(gtk_notebook_get_tab_detachable(Xen_to_C_GtkNotebook_(notebook), Xen_to_C_GtkWidget_(child))));
}

static Xen gxg_gtk_notebook_set_tab_detachable(Xen notebook, Xen child, Xen detachable)
{
  #define H_gtk_notebook_set_tab_detachable "void gtk_notebook_set_tab_detachable(GtkNotebook* notebook, \
GtkWidget* child, gboolean detachable)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_set_tab_detachable", "GtkNotebook*");
  Xen_check_type(Xen_is_GtkWidget_(child), child, 2, "gtk_notebook_set_tab_detachable", "GtkWidget*");
  Xen_check_type(Xen_is_gboolean(detachable), detachable, 3, "gtk_notebook_set_tab_detachable", "gboolean");
  gtk_notebook_set_tab_detachable(Xen_to_C_GtkNotebook_(notebook), Xen_to_C_GtkWidget_(child), Xen_to_C_gboolean(detachable));
  return(Xen_false);
}

static Xen gxg_gtk_scrolled_window_unset_placement(Xen scrolled_window)
{
  #define H_gtk_scrolled_window_unset_placement "void gtk_scrolled_window_unset_placement(GtkScrolledWindow* scrolled_window)"
  Xen_check_type(Xen_is_GtkScrolledWindow_(scrolled_window), scrolled_window, 1, "gtk_scrolled_window_unset_placement", "GtkScrolledWindow*");
  gtk_scrolled_window_unset_placement(Xen_to_C_GtkScrolledWindow_(scrolled_window));
  return(Xen_false);
}

static Xen gxg_gtk_size_group_get_widgets(Xen size_group)
{
  #define H_gtk_size_group_get_widgets "GSList* gtk_size_group_get_widgets(GtkSizeGroup* size_group)"
  Xen_check_type(Xen_is_GtkSizeGroup_(size_group), size_group, 1, "gtk_size_group_get_widgets", "GtkSizeGroup*");
  return(C_to_Xen_GSList_(gtk_size_group_get_widgets(Xen_to_C_GtkSizeGroup_(size_group))));
}

static Xen gxg_gtk_text_buffer_get_has_selection(Xen buffer)
{
  #define H_gtk_text_buffer_get_has_selection "gboolean gtk_text_buffer_get_has_selection(GtkTextBuffer* buffer)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_get_has_selection", "GtkTextBuffer*");
  return(C_to_Xen_gboolean(gtk_text_buffer_get_has_selection(Xen_to_C_GtkTextBuffer_(buffer))));
}

static Xen gxg_gtk_tree_view_get_headers_clickable(Xen tree_view)
{
  #define H_gtk_tree_view_get_headers_clickable "gboolean gtk_tree_view_get_headers_clickable(GtkTreeView* tree_view)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_get_headers_clickable", "GtkTreeView*");
  return(C_to_Xen_gboolean(gtk_tree_view_get_headers_clickable(Xen_to_C_GtkTreeView_(tree_view))));
}

static Xen gxg_gtk_window_set_deletable(Xen window, Xen setting)
{
  #define H_gtk_window_set_deletable "void gtk_window_set_deletable(GtkWindow* window, gboolean setting)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_set_deletable", "GtkWindow*");
  Xen_check_type(Xen_is_gboolean(setting), setting, 2, "gtk_window_set_deletable", "gboolean");
  gtk_window_set_deletable(Xen_to_C_GtkWindow_(window), Xen_to_C_gboolean(setting));
  return(Xen_false);
}

static Xen gxg_gtk_window_get_deletable(Xen window)
{
  #define H_gtk_window_get_deletable "gboolean gtk_window_get_deletable(GtkWindow* window)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_get_deletable", "GtkWindow*");
  return(C_to_Xen_gboolean(gtk_window_get_deletable(Xen_to_C_GtkWindow_(window))));
}

static Xen gxg_gtk_assistant_new(void)
{
  #define H_gtk_assistant_new "GtkWidget* gtk_assistant_new( void)"
  return(C_to_Xen_GtkWidget_(gtk_assistant_new()));
}

static Xen gxg_gtk_assistant_get_current_page(Xen assistant)
{
  #define H_gtk_assistant_get_current_page "gint gtk_assistant_get_current_page(GtkAssistant* assistant)"
  Xen_check_type(Xen_is_GtkAssistant_(assistant), assistant, 1, "gtk_assistant_get_current_page", "GtkAssistant*");
  return(C_to_Xen_gint(gtk_assistant_get_current_page(Xen_to_C_GtkAssistant_(assistant))));
}

static Xen gxg_gtk_assistant_set_current_page(Xen assistant, Xen page_num)
{
  #define H_gtk_assistant_set_current_page "void gtk_assistant_set_current_page(GtkAssistant* assistant, \
gint page_num)"
  Xen_check_type(Xen_is_GtkAssistant_(assistant), assistant, 1, "gtk_assistant_set_current_page", "GtkAssistant*");
  Xen_check_type(Xen_is_gint(page_num), page_num, 2, "gtk_assistant_set_current_page", "gint");
  gtk_assistant_set_current_page(Xen_to_C_GtkAssistant_(assistant), Xen_to_C_gint(page_num));
  return(Xen_false);
}

static Xen gxg_gtk_assistant_get_n_pages(Xen assistant)
{
  #define H_gtk_assistant_get_n_pages "gint gtk_assistant_get_n_pages(GtkAssistant* assistant)"
  Xen_check_type(Xen_is_GtkAssistant_(assistant), assistant, 1, "gtk_assistant_get_n_pages", "GtkAssistant*");
  return(C_to_Xen_gint(gtk_assistant_get_n_pages(Xen_to_C_GtkAssistant_(assistant))));
}

static Xen gxg_gtk_assistant_get_nth_page(Xen assistant, Xen page_num)
{
  #define H_gtk_assistant_get_nth_page "GtkWidget* gtk_assistant_get_nth_page(GtkAssistant* assistant, \
gint page_num)"
  Xen_check_type(Xen_is_GtkAssistant_(assistant), assistant, 1, "gtk_assistant_get_nth_page", "GtkAssistant*");
  Xen_check_type(Xen_is_gint(page_num), page_num, 2, "gtk_assistant_get_nth_page", "gint");
  return(C_to_Xen_GtkWidget_(gtk_assistant_get_nth_page(Xen_to_C_GtkAssistant_(assistant), Xen_to_C_gint(page_num))));
}

static Xen gxg_gtk_assistant_prepend_page(Xen assistant, Xen page)
{
  #define H_gtk_assistant_prepend_page "gint gtk_assistant_prepend_page(GtkAssistant* assistant, GtkWidget* page)"
  Xen_check_type(Xen_is_GtkAssistant_(assistant), assistant, 1, "gtk_assistant_prepend_page", "GtkAssistant*");
  Xen_check_type(Xen_is_GtkWidget_(page), page, 2, "gtk_assistant_prepend_page", "GtkWidget*");
  return(C_to_Xen_gint(gtk_assistant_prepend_page(Xen_to_C_GtkAssistant_(assistant), Xen_to_C_GtkWidget_(page))));
}

static Xen gxg_gtk_assistant_append_page(Xen assistant, Xen page)
{
  #define H_gtk_assistant_append_page "gint gtk_assistant_append_page(GtkAssistant* assistant, GtkWidget* page)"
  Xen_check_type(Xen_is_GtkAssistant_(assistant), assistant, 1, "gtk_assistant_append_page", "GtkAssistant*");
  Xen_check_type(Xen_is_GtkWidget_(page), page, 2, "gtk_assistant_append_page", "GtkWidget*");
  return(C_to_Xen_gint(gtk_assistant_append_page(Xen_to_C_GtkAssistant_(assistant), Xen_to_C_GtkWidget_(page))));
}

static Xen gxg_gtk_assistant_insert_page(Xen assistant, Xen page, Xen position)
{
  #define H_gtk_assistant_insert_page "gint gtk_assistant_insert_page(GtkAssistant* assistant, GtkWidget* page, \
gint position)"
  Xen_check_type(Xen_is_GtkAssistant_(assistant), assistant, 1, "gtk_assistant_insert_page", "GtkAssistant*");
  Xen_check_type(Xen_is_GtkWidget_(page), page, 2, "gtk_assistant_insert_page", "GtkWidget*");
  Xen_check_type(Xen_is_gint(position), position, 3, "gtk_assistant_insert_page", "gint");
  return(C_to_Xen_gint(gtk_assistant_insert_page(Xen_to_C_GtkAssistant_(assistant), Xen_to_C_GtkWidget_(page), Xen_to_C_gint(position))));
}

static Xen gxg_gtk_assistant_set_forward_page_func(Xen assistant, Xen page_func, Xen func_info, Xen destroy)
{
  #define H_gtk_assistant_set_forward_page_func "void gtk_assistant_set_forward_page_func(GtkAssistant* assistant, \
GtkAssistantPageFunc page_func, lambda_data func_info, GDestroyNotify destroy)"
  Xen_check_type(Xen_is_GtkAssistant_(assistant), assistant, 1, "gtk_assistant_set_forward_page_func", "GtkAssistant*");
  Xen_check_type(Xen_is_GtkAssistantPageFunc(page_func), page_func, 2, "gtk_assistant_set_forward_page_func", "GtkAssistantPageFunc");
  Xen_check_type(Xen_is_lambda_data(func_info) || Xen_is_false(func_info), func_info, 3, "gtk_assistant_set_forward_page_func", "lambda_data");
  Xen_check_type(Xen_is_GDestroyNotify(destroy), destroy, 4, "gtk_assistant_set_forward_page_func", "GDestroyNotify");
  {
    Xen gxg_ptr = Xen_list_5(Xen_false, func_info, Xen_false, Xen_false, Xen_false);
    xm_protect(gxg_ptr);
    Xen_list_set(gxg_ptr, 3, destroy);
    gtk_assistant_set_forward_page_func(Xen_to_C_GtkAssistant_(assistant), Xen_to_C_GtkAssistantPageFunc(page_func), Xen_to_C_lambda_data(func_info), 
                                    Xen_to_C_GDestroyNotify(destroy));
    return(Xen_false);
   }
}

static Xen gxg_gtk_assistant_set_page_type(Xen assistant, Xen page, Xen type)
{
  #define H_gtk_assistant_set_page_type "void gtk_assistant_set_page_type(GtkAssistant* assistant, GtkWidget* page, \
GtkAssistantPageType type)"
  Xen_check_type(Xen_is_GtkAssistant_(assistant), assistant, 1, "gtk_assistant_set_page_type", "GtkAssistant*");
  Xen_check_type(Xen_is_GtkWidget_(page), page, 2, "gtk_assistant_set_page_type", "GtkWidget*");
  Xen_check_type(Xen_is_GtkAssistantPageType(type), type, 3, "gtk_assistant_set_page_type", "GtkAssistantPageType");
  gtk_assistant_set_page_type(Xen_to_C_GtkAssistant_(assistant), Xen_to_C_GtkWidget_(page), Xen_to_C_GtkAssistantPageType(type));
  return(Xen_false);
}

static Xen gxg_gtk_assistant_get_page_type(Xen assistant, Xen page)
{
  #define H_gtk_assistant_get_page_type "GtkAssistantPageType gtk_assistant_get_page_type(GtkAssistant* assistant, \
GtkWidget* page)"
  Xen_check_type(Xen_is_GtkAssistant_(assistant), assistant, 1, "gtk_assistant_get_page_type", "GtkAssistant*");
  Xen_check_type(Xen_is_GtkWidget_(page), page, 2, "gtk_assistant_get_page_type", "GtkWidget*");
  return(C_to_Xen_GtkAssistantPageType(gtk_assistant_get_page_type(Xen_to_C_GtkAssistant_(assistant), Xen_to_C_GtkWidget_(page))));
}

static Xen gxg_gtk_assistant_set_page_title(Xen assistant, Xen page, Xen title)
{
  #define H_gtk_assistant_set_page_title "void gtk_assistant_set_page_title(GtkAssistant* assistant, \
GtkWidget* page, gchar* title)"
  Xen_check_type(Xen_is_GtkAssistant_(assistant), assistant, 1, "gtk_assistant_set_page_title", "GtkAssistant*");
  Xen_check_type(Xen_is_GtkWidget_(page), page, 2, "gtk_assistant_set_page_title", "GtkWidget*");
  Xen_check_type(Xen_is_gchar_(title), title, 3, "gtk_assistant_set_page_title", "gchar*");
  gtk_assistant_set_page_title(Xen_to_C_GtkAssistant_(assistant), Xen_to_C_GtkWidget_(page), Xen_to_C_gchar_(title));
  return(Xen_false);
}

static Xen gxg_gtk_assistant_get_page_title(Xen assistant, Xen page)
{
  #define H_gtk_assistant_get_page_title "gchar* gtk_assistant_get_page_title(GtkAssistant* assistant, \
GtkWidget* page)"
  Xen_check_type(Xen_is_GtkAssistant_(assistant), assistant, 1, "gtk_assistant_get_page_title", "GtkAssistant*");
  Xen_check_type(Xen_is_GtkWidget_(page), page, 2, "gtk_assistant_get_page_title", "GtkWidget*");
  return(C_to_Xen_gchar_(gtk_assistant_get_page_title(Xen_to_C_GtkAssistant_(assistant), Xen_to_C_GtkWidget_(page))));
}

static Xen gxg_gtk_assistant_set_page_complete(Xen assistant, Xen page, Xen complete)
{
  #define H_gtk_assistant_set_page_complete "void gtk_assistant_set_page_complete(GtkAssistant* assistant, \
GtkWidget* page, gboolean complete)"
  Xen_check_type(Xen_is_GtkAssistant_(assistant), assistant, 1, "gtk_assistant_set_page_complete", "GtkAssistant*");
  Xen_check_type(Xen_is_GtkWidget_(page), page, 2, "gtk_assistant_set_page_complete", "GtkWidget*");
  Xen_check_type(Xen_is_gboolean(complete), complete, 3, "gtk_assistant_set_page_complete", "gboolean");
  gtk_assistant_set_page_complete(Xen_to_C_GtkAssistant_(assistant), Xen_to_C_GtkWidget_(page), Xen_to_C_gboolean(complete));
  return(Xen_false);
}

static Xen gxg_gtk_assistant_get_page_complete(Xen assistant, Xen page)
{
  #define H_gtk_assistant_get_page_complete "gboolean gtk_assistant_get_page_complete(GtkAssistant* assistant, \
GtkWidget* page)"
  Xen_check_type(Xen_is_GtkAssistant_(assistant), assistant, 1, "gtk_assistant_get_page_complete", "GtkAssistant*");
  Xen_check_type(Xen_is_GtkWidget_(page), page, 2, "gtk_assistant_get_page_complete", "GtkWidget*");
  return(C_to_Xen_gboolean(gtk_assistant_get_page_complete(Xen_to_C_GtkAssistant_(assistant), Xen_to_C_GtkWidget_(page))));
}

static Xen gxg_gtk_assistant_add_action_widget(Xen assistant, Xen child)
{
  #define H_gtk_assistant_add_action_widget "void gtk_assistant_add_action_widget(GtkAssistant* assistant, \
GtkWidget* child)"
  Xen_check_type(Xen_is_GtkAssistant_(assistant), assistant, 1, "gtk_assistant_add_action_widget", "GtkAssistant*");
  Xen_check_type(Xen_is_GtkWidget_(child), child, 2, "gtk_assistant_add_action_widget", "GtkWidget*");
  gtk_assistant_add_action_widget(Xen_to_C_GtkAssistant_(assistant), Xen_to_C_GtkWidget_(child));
  return(Xen_false);
}

static Xen gxg_gtk_assistant_remove_action_widget(Xen assistant, Xen child)
{
  #define H_gtk_assistant_remove_action_widget "void gtk_assistant_remove_action_widget(GtkAssistant* assistant, \
GtkWidget* child)"
  Xen_check_type(Xen_is_GtkAssistant_(assistant), assistant, 1, "gtk_assistant_remove_action_widget", "GtkAssistant*");
  Xen_check_type(Xen_is_GtkWidget_(child), child, 2, "gtk_assistant_remove_action_widget", "GtkWidget*");
  gtk_assistant_remove_action_widget(Xen_to_C_GtkAssistant_(assistant), Xen_to_C_GtkWidget_(child));
  return(Xen_false);
}

static Xen gxg_gtk_assistant_update_buttons_state(Xen assistant)
{
  #define H_gtk_assistant_update_buttons_state "void gtk_assistant_update_buttons_state(GtkAssistant* assistant)"
  Xen_check_type(Xen_is_GtkAssistant_(assistant), assistant, 1, "gtk_assistant_update_buttons_state", "GtkAssistant*");
  gtk_assistant_update_buttons_state(Xen_to_C_GtkAssistant_(assistant));
  return(Xen_false);
}

static Xen gxg_gtk_cell_renderer_accel_new(void)
{
  #define H_gtk_cell_renderer_accel_new "GtkCellRenderer* gtk_cell_renderer_accel_new( void)"
  return(C_to_Xen_GtkCellRenderer_(gtk_cell_renderer_accel_new()));
}

static Xen gxg_gtk_cell_renderer_spin_new(void)
{
  #define H_gtk_cell_renderer_spin_new "GtkCellRenderer* gtk_cell_renderer_spin_new( void)"
  return(C_to_Xen_GtkCellRenderer_(gtk_cell_renderer_spin_new()));
}

static Xen gxg_gtk_link_button_new(Xen uri)
{
  #define H_gtk_link_button_new "GtkWidget* gtk_link_button_new(gchar* uri)"
  Xen_check_type(Xen_is_gchar_(uri), uri, 1, "gtk_link_button_new", "gchar*");
  return(C_to_Xen_GtkWidget_(gtk_link_button_new(Xen_to_C_gchar_(uri))));
}

static Xen gxg_gtk_link_button_new_with_label(Xen uri, Xen label)
{
  #define H_gtk_link_button_new_with_label "GtkWidget* gtk_link_button_new_with_label(gchar* uri, gchar* label)"
  Xen_check_type(Xen_is_gchar_(uri), uri, 1, "gtk_link_button_new_with_label", "gchar*");
  Xen_check_type(Xen_is_gchar_(label), label, 2, "gtk_link_button_new_with_label", "gchar*");
  return(C_to_Xen_GtkWidget_(gtk_link_button_new_with_label(Xen_to_C_gchar_(uri), Xen_to_C_gchar_(label))));
}

static Xen gxg_gtk_link_button_get_uri(Xen link_button)
{
  #define H_gtk_link_button_get_uri "gchar* gtk_link_button_get_uri(GtkLinkButton* link_button)"
  Xen_check_type(Xen_is_GtkLinkButton_(link_button), link_button, 1, "gtk_link_button_get_uri", "GtkLinkButton*");
  return(C_to_Xen_gchar_(gtk_link_button_get_uri(Xen_to_C_GtkLinkButton_(link_button))));
}

static Xen gxg_gtk_link_button_set_uri(Xen link_button, Xen uri)
{
  #define H_gtk_link_button_set_uri "void gtk_link_button_set_uri(GtkLinkButton* link_button, gchar* uri)"
  Xen_check_type(Xen_is_GtkLinkButton_(link_button), link_button, 1, "gtk_link_button_set_uri", "GtkLinkButton*");
  Xen_check_type(Xen_is_gchar_(uri), uri, 2, "gtk_link_button_set_uri", "gchar*");
  gtk_link_button_set_uri(Xen_to_C_GtkLinkButton_(link_button), Xen_to_C_gchar_(uri));
  return(Xen_false);
}

static Xen gxg_gtk_recent_manager_error_quark(void)
{
  #define H_gtk_recent_manager_error_quark "GQuark gtk_recent_manager_error_quark( void)"
  return(C_to_Xen_GQuark(gtk_recent_manager_error_quark()));
}

static Xen gxg_gtk_recent_manager_new(void)
{
  #define H_gtk_recent_manager_new "GtkRecentManager* gtk_recent_manager_new( void)"
  return(C_to_Xen_GtkRecentManager_(gtk_recent_manager_new()));
}

static Xen gxg_gtk_recent_manager_get_default(void)
{
  #define H_gtk_recent_manager_get_default "GtkRecentManager* gtk_recent_manager_get_default( void)"
  return(C_to_Xen_GtkRecentManager_(gtk_recent_manager_get_default()));
}

static Xen gxg_gtk_recent_manager_remove_item(Xen manager, Xen uri, Xen ignore_error)
{
  #define H_gtk_recent_manager_remove_item "gboolean gtk_recent_manager_remove_item(GtkRecentManager* manager, \
gchar* uri, GError** [error])"
  GError* ref_error = NULL;
  Xen_check_type(Xen_is_GtkRecentManager_(manager), manager, 1, "gtk_recent_manager_remove_item", "GtkRecentManager*");
  Xen_check_type(Xen_is_gchar_(uri), uri, 2, "gtk_recent_manager_remove_item", "gchar*");
  {
    Xen res_ult;
    res_ult = C_to_Xen_gboolean(gtk_recent_manager_remove_item(Xen_to_C_GtkRecentManager_(manager), Xen_to_C_gchar_(uri), 
                                                               &ref_error));
    return(Xen_list_2(res_ult, C_to_Xen_GError_(ref_error)));
   }
}

static Xen gxg_gtk_recent_manager_lookup_item(Xen manager, Xen uri, Xen ignore_error)
{
  #define H_gtk_recent_manager_lookup_item "GtkRecentInfo* gtk_recent_manager_lookup_item(GtkRecentManager* manager, \
gchar* uri, GError** [error])"
  GError* ref_error = NULL;
  Xen_check_type(Xen_is_GtkRecentManager_(manager), manager, 1, "gtk_recent_manager_lookup_item", "GtkRecentManager*");
  Xen_check_type(Xen_is_gchar_(uri), uri, 2, "gtk_recent_manager_lookup_item", "gchar*");
  {
    Xen res_ult;
    res_ult = C_to_Xen_GtkRecentInfo_(gtk_recent_manager_lookup_item(Xen_to_C_GtkRecentManager_(manager), Xen_to_C_gchar_(uri), 
                                                                     &ref_error));
    return(Xen_list_2(res_ult, C_to_Xen_GError_(ref_error)));
   }
}

static Xen gxg_gtk_recent_manager_has_item(Xen manager, Xen uri)
{
  #define H_gtk_recent_manager_has_item "gboolean gtk_recent_manager_has_item(GtkRecentManager* manager, \
gchar* uri)"
  Xen_check_type(Xen_is_GtkRecentManager_(manager), manager, 1, "gtk_recent_manager_has_item", "GtkRecentManager*");
  Xen_check_type(Xen_is_gchar_(uri), uri, 2, "gtk_recent_manager_has_item", "gchar*");
  return(C_to_Xen_gboolean(gtk_recent_manager_has_item(Xen_to_C_GtkRecentManager_(manager), Xen_to_C_gchar_(uri))));
}

static Xen gxg_gtk_recent_manager_move_item(Xen manager, Xen uri, Xen new_uri, Xen ignore_error)
{
  #define H_gtk_recent_manager_move_item "gboolean gtk_recent_manager_move_item(GtkRecentManager* manager, \
gchar* uri, gchar* new_uri, GError** [error])"
  GError* ref_error = NULL;
  Xen_check_type(Xen_is_GtkRecentManager_(manager), manager, 1, "gtk_recent_manager_move_item", "GtkRecentManager*");
  Xen_check_type(Xen_is_gchar_(uri), uri, 2, "gtk_recent_manager_move_item", "gchar*");
  Xen_check_type(Xen_is_gchar_(new_uri), new_uri, 3, "gtk_recent_manager_move_item", "gchar*");
  {
    Xen res_ult;
    res_ult = C_to_Xen_gboolean(gtk_recent_manager_move_item(Xen_to_C_GtkRecentManager_(manager), Xen_to_C_gchar_(uri), Xen_to_C_gchar_(new_uri), 
                                                             &ref_error));
    return(Xen_list_2(res_ult, C_to_Xen_GError_(ref_error)));
   }
}

static Xen gxg_gtk_recent_manager_get_items(Xen manager)
{
  #define H_gtk_recent_manager_get_items "GList* gtk_recent_manager_get_items(GtkRecentManager* manager)"
  Xen_check_type(Xen_is_GtkRecentManager_(manager), manager, 1, "gtk_recent_manager_get_items", "GtkRecentManager*");
  return(C_to_Xen_GList_(gtk_recent_manager_get_items(Xen_to_C_GtkRecentManager_(manager))));
}

static Xen gxg_gtk_recent_manager_purge_items(Xen manager, Xen ignore_error)
{
  #define H_gtk_recent_manager_purge_items "gint gtk_recent_manager_purge_items(GtkRecentManager* manager, \
GError** [error])"
  GError* ref_error = NULL;
  Xen_check_type(Xen_is_GtkRecentManager_(manager), manager, 1, "gtk_recent_manager_purge_items", "GtkRecentManager*");
  {
    Xen res_ult;
    res_ult = C_to_Xen_gint(gtk_recent_manager_purge_items(Xen_to_C_GtkRecentManager_(manager), &ref_error));
    return(Xen_list_2(res_ult, C_to_Xen_GError_(ref_error)));
   }
}

static Xen gxg_gtk_recent_info_ref(Xen info)
{
  #define H_gtk_recent_info_ref "GtkRecentInfo* gtk_recent_info_ref(GtkRecentInfo* info)"
  Xen_check_type(Xen_is_GtkRecentInfo_(info), info, 1, "gtk_recent_info_ref", "GtkRecentInfo*");
  return(C_to_Xen_GtkRecentInfo_(gtk_recent_info_ref(Xen_to_C_GtkRecentInfo_(info))));
}

static Xen gxg_gtk_recent_info_unref(Xen info)
{
  #define H_gtk_recent_info_unref "void gtk_recent_info_unref(GtkRecentInfo* info)"
  Xen_check_type(Xen_is_GtkRecentInfo_(info), info, 1, "gtk_recent_info_unref", "GtkRecentInfo*");
  gtk_recent_info_unref(Xen_to_C_GtkRecentInfo_(info));
  return(Xen_false);
}

static Xen gxg_gtk_recent_info_get_uri(Xen info)
{
  #define H_gtk_recent_info_get_uri "gchar* gtk_recent_info_get_uri(GtkRecentInfo* info)"
  Xen_check_type(Xen_is_GtkRecentInfo_(info), info, 1, "gtk_recent_info_get_uri", "GtkRecentInfo*");
  return(C_to_Xen_gchar_(gtk_recent_info_get_uri(Xen_to_C_GtkRecentInfo_(info))));
}

static Xen gxg_gtk_recent_info_get_display_name(Xen info)
{
  #define H_gtk_recent_info_get_display_name "gchar* gtk_recent_info_get_display_name(GtkRecentInfo* info)"
  Xen_check_type(Xen_is_GtkRecentInfo_(info), info, 1, "gtk_recent_info_get_display_name", "GtkRecentInfo*");
    return(C_to_Xen_gchar_((gchar*)gtk_recent_info_get_display_name(Xen_to_C_GtkRecentInfo_(info))));
}

static Xen gxg_gtk_recent_info_get_description(Xen info)
{
  #define H_gtk_recent_info_get_description "gchar* gtk_recent_info_get_description(GtkRecentInfo* info)"
  Xen_check_type(Xen_is_GtkRecentInfo_(info), info, 1, "gtk_recent_info_get_description", "GtkRecentInfo*");
    return(C_to_Xen_gchar_((gchar*)gtk_recent_info_get_description(Xen_to_C_GtkRecentInfo_(info))));
}

static Xen gxg_gtk_recent_info_get_mime_type(Xen info)
{
  #define H_gtk_recent_info_get_mime_type "gchar* gtk_recent_info_get_mime_type(GtkRecentInfo* info)"
  Xen_check_type(Xen_is_GtkRecentInfo_(info), info, 1, "gtk_recent_info_get_mime_type", "GtkRecentInfo*");
    return(C_to_Xen_gchar_((gchar*)gtk_recent_info_get_mime_type(Xen_to_C_GtkRecentInfo_(info))));
}

static Xen gxg_gtk_recent_info_get_added(Xen info)
{
  #define H_gtk_recent_info_get_added "time_t gtk_recent_info_get_added(GtkRecentInfo* info)"
  Xen_check_type(Xen_is_GtkRecentInfo_(info), info, 1, "gtk_recent_info_get_added", "GtkRecentInfo*");
  return(C_to_Xen_time_t(gtk_recent_info_get_added(Xen_to_C_GtkRecentInfo_(info))));
}

static Xen gxg_gtk_recent_info_get_modified(Xen info)
{
  #define H_gtk_recent_info_get_modified "time_t gtk_recent_info_get_modified(GtkRecentInfo* info)"
  Xen_check_type(Xen_is_GtkRecentInfo_(info), info, 1, "gtk_recent_info_get_modified", "GtkRecentInfo*");
  return(C_to_Xen_time_t(gtk_recent_info_get_modified(Xen_to_C_GtkRecentInfo_(info))));
}

static Xen gxg_gtk_recent_info_get_visited(Xen info)
{
  #define H_gtk_recent_info_get_visited "time_t gtk_recent_info_get_visited(GtkRecentInfo* info)"
  Xen_check_type(Xen_is_GtkRecentInfo_(info), info, 1, "gtk_recent_info_get_visited", "GtkRecentInfo*");
  return(C_to_Xen_time_t(gtk_recent_info_get_visited(Xen_to_C_GtkRecentInfo_(info))));
}

static Xen gxg_gtk_recent_info_get_private_hint(Xen info)
{
  #define H_gtk_recent_info_get_private_hint "gboolean gtk_recent_info_get_private_hint(GtkRecentInfo* info)"
  Xen_check_type(Xen_is_GtkRecentInfo_(info), info, 1, "gtk_recent_info_get_private_hint", "GtkRecentInfo*");
  return(C_to_Xen_gboolean(gtk_recent_info_get_private_hint(Xen_to_C_GtkRecentInfo_(info))));
}

static Xen gxg_gtk_recent_info_get_applications(Xen info, Xen ignore_length)
{
  #define H_gtk_recent_info_get_applications "gchar** gtk_recent_info_get_applications(GtkRecentInfo* info, \
gsize* [length])"
  gsize ref_length;
  Xen_check_type(Xen_is_GtkRecentInfo_(info), info, 1, "gtk_recent_info_get_applications", "GtkRecentInfo*");
  {
    Xen res_ult;
    res_ult = C_to_Xen_gchar__(gtk_recent_info_get_applications(Xen_to_C_GtkRecentInfo_(info), &ref_length));
    return(Xen_list_2(res_ult, C_to_Xen_gsize(ref_length)));
   }
}

static Xen gxg_gtk_recent_info_last_application(Xen info)
{
  #define H_gtk_recent_info_last_application "gchar* gtk_recent_info_last_application(GtkRecentInfo* info)"
  Xen_check_type(Xen_is_GtkRecentInfo_(info), info, 1, "gtk_recent_info_last_application", "GtkRecentInfo*");
  return(C_to_Xen_gchar_(gtk_recent_info_last_application(Xen_to_C_GtkRecentInfo_(info))));
}

static Xen gxg_gtk_recent_info_has_application(Xen info, Xen app_name)
{
  #define H_gtk_recent_info_has_application "gboolean gtk_recent_info_has_application(GtkRecentInfo* info, \
gchar* app_name)"
  Xen_check_type(Xen_is_GtkRecentInfo_(info), info, 1, "gtk_recent_info_has_application", "GtkRecentInfo*");
  Xen_check_type(Xen_is_gchar_(app_name), app_name, 2, "gtk_recent_info_has_application", "gchar*");
  return(C_to_Xen_gboolean(gtk_recent_info_has_application(Xen_to_C_GtkRecentInfo_(info), Xen_to_C_gchar_(app_name))));
}

static Xen gxg_gtk_recent_info_get_groups(Xen info, Xen ignore_length)
{
  #define H_gtk_recent_info_get_groups "gchar** gtk_recent_info_get_groups(GtkRecentInfo* info, gsize* [length])"
  gsize ref_length;
  Xen_check_type(Xen_is_GtkRecentInfo_(info), info, 1, "gtk_recent_info_get_groups", "GtkRecentInfo*");
  {
    Xen res_ult;
    res_ult = C_to_Xen_gchar__(gtk_recent_info_get_groups(Xen_to_C_GtkRecentInfo_(info), &ref_length));
    return(Xen_list_2(res_ult, C_to_Xen_gsize(ref_length)));
   }
}

static Xen gxg_gtk_recent_info_has_group(Xen info, Xen group_name)
{
  #define H_gtk_recent_info_has_group "gboolean gtk_recent_info_has_group(GtkRecentInfo* info, gchar* group_name)"
  Xen_check_type(Xen_is_GtkRecentInfo_(info), info, 1, "gtk_recent_info_has_group", "GtkRecentInfo*");
  Xen_check_type(Xen_is_gchar_(group_name), group_name, 2, "gtk_recent_info_has_group", "gchar*");
  return(C_to_Xen_gboolean(gtk_recent_info_has_group(Xen_to_C_GtkRecentInfo_(info), Xen_to_C_gchar_(group_name))));
}

static Xen gxg_gtk_recent_info_get_short_name(Xen info)
{
  #define H_gtk_recent_info_get_short_name "gchar* gtk_recent_info_get_short_name(GtkRecentInfo* info)"
  Xen_check_type(Xen_is_GtkRecentInfo_(info), info, 1, "gtk_recent_info_get_short_name", "GtkRecentInfo*");
  return(C_to_Xen_gchar_(gtk_recent_info_get_short_name(Xen_to_C_GtkRecentInfo_(info))));
}

static Xen gxg_gtk_recent_info_get_uri_display(Xen info)
{
  #define H_gtk_recent_info_get_uri_display "gchar* gtk_recent_info_get_uri_display(GtkRecentInfo* info)"
  Xen_check_type(Xen_is_GtkRecentInfo_(info), info, 1, "gtk_recent_info_get_uri_display", "GtkRecentInfo*");
  return(C_to_Xen_gchar_(gtk_recent_info_get_uri_display(Xen_to_C_GtkRecentInfo_(info))));
}

static Xen gxg_gtk_recent_info_get_age(Xen info)
{
  #define H_gtk_recent_info_get_age "gint gtk_recent_info_get_age(GtkRecentInfo* info)"
  Xen_check_type(Xen_is_GtkRecentInfo_(info), info, 1, "gtk_recent_info_get_age", "GtkRecentInfo*");
  return(C_to_Xen_gint(gtk_recent_info_get_age(Xen_to_C_GtkRecentInfo_(info))));
}

static Xen gxg_gtk_recent_info_is_local(Xen info)
{
  #define H_gtk_recent_info_is_local "gboolean gtk_recent_info_is_local(GtkRecentInfo* info)"
  Xen_check_type(Xen_is_GtkRecentInfo_(info), info, 1, "gtk_recent_info_is_local", "GtkRecentInfo*");
  return(C_to_Xen_gboolean(gtk_recent_info_is_local(Xen_to_C_GtkRecentInfo_(info))));
}

static Xen gxg_gtk_recent_info_exists(Xen info)
{
  #define H_gtk_recent_info_exists "gboolean gtk_recent_info_exists(GtkRecentInfo* info)"
  Xen_check_type(Xen_is_GtkRecentInfo_(info), info, 1, "gtk_recent_info_exists", "GtkRecentInfo*");
  return(C_to_Xen_gboolean(gtk_recent_info_exists(Xen_to_C_GtkRecentInfo_(info))));
}

static Xen gxg_gtk_recent_info_match(Xen info_a, Xen info_b)
{
  #define H_gtk_recent_info_match "gboolean gtk_recent_info_match(GtkRecentInfo* info_a, GtkRecentInfo* info_b)"
  Xen_check_type(Xen_is_GtkRecentInfo_(info_a), info_a, 1, "gtk_recent_info_match", "GtkRecentInfo*");
  Xen_check_type(Xen_is_GtkRecentInfo_(info_b), info_b, 2, "gtk_recent_info_match", "GtkRecentInfo*");
  return(C_to_Xen_gboolean(gtk_recent_info_match(Xen_to_C_GtkRecentInfo_(info_a), Xen_to_C_GtkRecentInfo_(info_b))));
}

static Xen gxg_gtk_recent_manager_add_item(Xen manager, Xen uri)
{
  #define H_gtk_recent_manager_add_item "gboolean gtk_recent_manager_add_item(GtkRecentManager* manager, \
gchar* uri)"
  Xen_check_type(Xen_is_GtkRecentManager_(manager), manager, 1, "gtk_recent_manager_add_item", "GtkRecentManager*");
  Xen_check_type(Xen_is_gchar_(uri), uri, 2, "gtk_recent_manager_add_item", "gchar*");
  return(C_to_Xen_gboolean(gtk_recent_manager_add_item(Xen_to_C_GtkRecentManager_(manager), Xen_to_C_gchar_(uri))));
}

static Xen gxg_gtk_recent_manager_add_full(Xen manager, Xen uri, Xen recent_data)
{
  #define H_gtk_recent_manager_add_full "gboolean gtk_recent_manager_add_full(GtkRecentManager* manager, \
gchar* uri, GtkRecentData* recent_data)"
  Xen_check_type(Xen_is_GtkRecentManager_(manager), manager, 1, "gtk_recent_manager_add_full", "GtkRecentManager*");
  Xen_check_type(Xen_is_gchar_(uri), uri, 2, "gtk_recent_manager_add_full", "gchar*");
  Xen_check_type(Xen_is_GtkRecentData_(recent_data), recent_data, 3, "gtk_recent_manager_add_full", "GtkRecentData*");
  return(C_to_Xen_gboolean(gtk_recent_manager_add_full(Xen_to_C_GtkRecentManager_(manager), Xen_to_C_gchar_(uri), Xen_to_C_GtkRecentData_(recent_data))));
}

static Xen gxg_gtk_tree_model_filter_convert_child_iter_to_iter(Xen filter, Xen filter_iter, Xen child_iter)
{
  #define H_gtk_tree_model_filter_convert_child_iter_to_iter "gboolean gtk_tree_model_filter_convert_child_iter_to_iter(GtkTreeModelFilter* filter, \
GtkTreeIter* filter_iter, GtkTreeIter* child_iter)"
  Xen_check_type(Xen_is_GtkTreeModelFilter_(filter), filter, 1, "gtk_tree_model_filter_convert_child_iter_to_iter", "GtkTreeModelFilter*");
  Xen_check_type(Xen_is_GtkTreeIter_(filter_iter), filter_iter, 2, "gtk_tree_model_filter_convert_child_iter_to_iter", "GtkTreeIter*");
  Xen_check_type(Xen_is_GtkTreeIter_(child_iter), child_iter, 3, "gtk_tree_model_filter_convert_child_iter_to_iter", "GtkTreeIter*");
  return(C_to_Xen_gboolean(gtk_tree_model_filter_convert_child_iter_to_iter(Xen_to_C_GtkTreeModelFilter_(filter), Xen_to_C_GtkTreeIter_(filter_iter), 
                                                                            Xen_to_C_GtkTreeIter_(child_iter))));
}

static Xen gxg_gtk_tree_view_get_grid_lines(Xen tree_view)
{
  #define H_gtk_tree_view_get_grid_lines "GtkTreeViewGridLines gtk_tree_view_get_grid_lines(GtkTreeView* tree_view)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_get_grid_lines", "GtkTreeView*");
  return(C_to_Xen_GtkTreeViewGridLines(gtk_tree_view_get_grid_lines(Xen_to_C_GtkTreeView_(tree_view))));
}

static Xen gxg_gtk_tree_view_set_grid_lines(Xen tree_view, Xen grid_lines)
{
  #define H_gtk_tree_view_set_grid_lines "void gtk_tree_view_set_grid_lines(GtkTreeView* tree_view, GtkTreeViewGridLines grid_lines)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_set_grid_lines", "GtkTreeView*");
  Xen_check_type(Xen_is_GtkTreeViewGridLines(grid_lines), grid_lines, 2, "gtk_tree_view_set_grid_lines", "GtkTreeViewGridLines");
  gtk_tree_view_set_grid_lines(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_GtkTreeViewGridLines(grid_lines));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_get_enable_tree_lines(Xen tree_view)
{
  #define H_gtk_tree_view_get_enable_tree_lines "gboolean gtk_tree_view_get_enable_tree_lines(GtkTreeView* tree_view)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_get_enable_tree_lines", "GtkTreeView*");
  return(C_to_Xen_gboolean(gtk_tree_view_get_enable_tree_lines(Xen_to_C_GtkTreeView_(tree_view))));
}

static Xen gxg_gtk_tree_view_set_enable_tree_lines(Xen tree_view, Xen enabled)
{
  #define H_gtk_tree_view_set_enable_tree_lines "void gtk_tree_view_set_enable_tree_lines(GtkTreeView* tree_view, \
gboolean enabled)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_set_enable_tree_lines", "GtkTreeView*");
  Xen_check_type(Xen_is_gboolean(enabled), enabled, 2, "gtk_tree_view_set_enable_tree_lines", "gboolean");
  gtk_tree_view_set_enable_tree_lines(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_gboolean(enabled));
  return(Xen_false);
}

static Xen gxg_gtk_print_context_get_cairo_context(Xen context)
{
  #define H_gtk_print_context_get_cairo_context "cairo_t* gtk_print_context_get_cairo_context(GtkPrintContext* context)"
  Xen_check_type(Xen_is_GtkPrintContext_(context), context, 1, "gtk_print_context_get_cairo_context", "GtkPrintContext*");
  return(C_to_Xen_cairo_t_(gtk_print_context_get_cairo_context(Xen_to_C_GtkPrintContext_(context))));
}

static Xen gxg_gtk_print_context_get_page_setup(Xen context)
{
  #define H_gtk_print_context_get_page_setup "GtkPageSetup* gtk_print_context_get_page_setup(GtkPrintContext* context)"
  Xen_check_type(Xen_is_GtkPrintContext_(context), context, 1, "gtk_print_context_get_page_setup", "GtkPrintContext*");
  return(C_to_Xen_GtkPageSetup_(gtk_print_context_get_page_setup(Xen_to_C_GtkPrintContext_(context))));
}

static Xen gxg_gtk_print_context_get_width(Xen context)
{
  #define H_gtk_print_context_get_width "gdouble gtk_print_context_get_width(GtkPrintContext* context)"
  Xen_check_type(Xen_is_GtkPrintContext_(context), context, 1, "gtk_print_context_get_width", "GtkPrintContext*");
  return(C_to_Xen_gdouble(gtk_print_context_get_width(Xen_to_C_GtkPrintContext_(context))));
}

static Xen gxg_gtk_print_context_get_height(Xen context)
{
  #define H_gtk_print_context_get_height "gdouble gtk_print_context_get_height(GtkPrintContext* context)"
  Xen_check_type(Xen_is_GtkPrintContext_(context), context, 1, "gtk_print_context_get_height", "GtkPrintContext*");
  return(C_to_Xen_gdouble(gtk_print_context_get_height(Xen_to_C_GtkPrintContext_(context))));
}

static Xen gxg_gtk_print_context_get_dpi_x(Xen context)
{
  #define H_gtk_print_context_get_dpi_x "gdouble gtk_print_context_get_dpi_x(GtkPrintContext* context)"
  Xen_check_type(Xen_is_GtkPrintContext_(context), context, 1, "gtk_print_context_get_dpi_x", "GtkPrintContext*");
  return(C_to_Xen_gdouble(gtk_print_context_get_dpi_x(Xen_to_C_GtkPrintContext_(context))));
}

static Xen gxg_gtk_print_context_get_dpi_y(Xen context)
{
  #define H_gtk_print_context_get_dpi_y "gdouble gtk_print_context_get_dpi_y(GtkPrintContext* context)"
  Xen_check_type(Xen_is_GtkPrintContext_(context), context, 1, "gtk_print_context_get_dpi_y", "GtkPrintContext*");
  return(C_to_Xen_gdouble(gtk_print_context_get_dpi_y(Xen_to_C_GtkPrintContext_(context))));
}

static Xen gxg_gtk_print_context_create_pango_context(Xen context)
{
  #define H_gtk_print_context_create_pango_context "PangoContext* gtk_print_context_create_pango_context(GtkPrintContext* context)"
  Xen_check_type(Xen_is_GtkPrintContext_(context), context, 1, "gtk_print_context_create_pango_context", "GtkPrintContext*");
  return(C_to_Xen_PangoContext_(gtk_print_context_create_pango_context(Xen_to_C_GtkPrintContext_(context))));
}

static Xen gxg_gtk_print_context_create_pango_layout(Xen context)
{
  #define H_gtk_print_context_create_pango_layout "PangoLayout* gtk_print_context_create_pango_layout(GtkPrintContext* context)"
  Xen_check_type(Xen_is_GtkPrintContext_(context), context, 1, "gtk_print_context_create_pango_layout", "GtkPrintContext*");
  return(C_to_Xen_PangoLayout_(gtk_print_context_create_pango_layout(Xen_to_C_GtkPrintContext_(context))));
}

static Xen gxg_gtk_print_context_set_cairo_context(Xen context, Xen cr, Xen dpi_x, Xen dpi_y)
{
  #define H_gtk_print_context_set_cairo_context "void gtk_print_context_set_cairo_context(GtkPrintContext* context, \
cairo_t* cr, double dpi_x, double dpi_y)"
  Xen_check_type(Xen_is_GtkPrintContext_(context), context, 1, "gtk_print_context_set_cairo_context", "GtkPrintContext*");
  Xen_check_type(Xen_is_cairo_t_(cr), cr, 2, "gtk_print_context_set_cairo_context", "cairo_t*");
  Xen_check_type(Xen_is_double(dpi_x), dpi_x, 3, "gtk_print_context_set_cairo_context", "double");
  Xen_check_type(Xen_is_double(dpi_y), dpi_y, 4, "gtk_print_context_set_cairo_context", "double");
  gtk_print_context_set_cairo_context(Xen_to_C_GtkPrintContext_(context), Xen_to_C_cairo_t_(cr), Xen_to_C_double(dpi_x), 
                                      Xen_to_C_double(dpi_y));
  return(Xen_false);
}

static Xen gxg_gtk_print_operation_new(void)
{
  #define H_gtk_print_operation_new "GtkPrintOperation* gtk_print_operation_new( void)"
  return(C_to_Xen_GtkPrintOperation_(gtk_print_operation_new()));
}

static Xen gxg_gtk_print_operation_set_default_page_setup(Xen op, Xen default_page_setup)
{
  #define H_gtk_print_operation_set_default_page_setup "void gtk_print_operation_set_default_page_setup(GtkPrintOperation* op, \
GtkPageSetup* default_page_setup)"
  Xen_check_type(Xen_is_GtkPrintOperation_(op), op, 1, "gtk_print_operation_set_default_page_setup", "GtkPrintOperation*");
  Xen_check_type(Xen_is_GtkPageSetup_(default_page_setup), default_page_setup, 2, "gtk_print_operation_set_default_page_setup", "GtkPageSetup*");
  gtk_print_operation_set_default_page_setup(Xen_to_C_GtkPrintOperation_(op), Xen_to_C_GtkPageSetup_(default_page_setup));
  return(Xen_false);
}

static Xen gxg_gtk_print_operation_get_default_page_setup(Xen op)
{
  #define H_gtk_print_operation_get_default_page_setup "GtkPageSetup* gtk_print_operation_get_default_page_setup(GtkPrintOperation* op)"
  Xen_check_type(Xen_is_GtkPrintOperation_(op), op, 1, "gtk_print_operation_get_default_page_setup", "GtkPrintOperation*");
  return(C_to_Xen_GtkPageSetup_(gtk_print_operation_get_default_page_setup(Xen_to_C_GtkPrintOperation_(op))));
}

static Xen gxg_gtk_print_operation_set_print_settings(Xen op, Xen print_settings)
{
  #define H_gtk_print_operation_set_print_settings "void gtk_print_operation_set_print_settings(GtkPrintOperation* op, \
GtkPrintSettings* print_settings)"
  Xen_check_type(Xen_is_GtkPrintOperation_(op), op, 1, "gtk_print_operation_set_print_settings", "GtkPrintOperation*");
  Xen_check_type(Xen_is_GtkPrintSettings_(print_settings), print_settings, 2, "gtk_print_operation_set_print_settings", "GtkPrintSettings*");
  gtk_print_operation_set_print_settings(Xen_to_C_GtkPrintOperation_(op), Xen_to_C_GtkPrintSettings_(print_settings));
  return(Xen_false);
}

static Xen gxg_gtk_print_operation_get_print_settings(Xen op)
{
  #define H_gtk_print_operation_get_print_settings "GtkPrintSettings* gtk_print_operation_get_print_settings(GtkPrintOperation* op)"
  Xen_check_type(Xen_is_GtkPrintOperation_(op), op, 1, "gtk_print_operation_get_print_settings", "GtkPrintOperation*");
  return(C_to_Xen_GtkPrintSettings_(gtk_print_operation_get_print_settings(Xen_to_C_GtkPrintOperation_(op))));
}

static Xen gxg_gtk_print_operation_set_job_name(Xen op, Xen job_name)
{
  #define H_gtk_print_operation_set_job_name "void gtk_print_operation_set_job_name(GtkPrintOperation* op, \
gchar* job_name)"
  Xen_check_type(Xen_is_GtkPrintOperation_(op), op, 1, "gtk_print_operation_set_job_name", "GtkPrintOperation*");
  Xen_check_type(Xen_is_gchar_(job_name), job_name, 2, "gtk_print_operation_set_job_name", "gchar*");
  gtk_print_operation_set_job_name(Xen_to_C_GtkPrintOperation_(op), Xen_to_C_gchar_(job_name));
  return(Xen_false);
}

static Xen gxg_gtk_print_operation_set_n_pages(Xen op, Xen n_pages)
{
  #define H_gtk_print_operation_set_n_pages "void gtk_print_operation_set_n_pages(GtkPrintOperation* op, \
gint n_pages)"
  Xen_check_type(Xen_is_GtkPrintOperation_(op), op, 1, "gtk_print_operation_set_n_pages", "GtkPrintOperation*");
  Xen_check_type(Xen_is_gint(n_pages), n_pages, 2, "gtk_print_operation_set_n_pages", "gint");
  gtk_print_operation_set_n_pages(Xen_to_C_GtkPrintOperation_(op), Xen_to_C_gint(n_pages));
  return(Xen_false);
}

static Xen gxg_gtk_print_operation_set_current_page(Xen op, Xen current_page)
{
  #define H_gtk_print_operation_set_current_page "void gtk_print_operation_set_current_page(GtkPrintOperation* op, \
gint current_page)"
  Xen_check_type(Xen_is_GtkPrintOperation_(op), op, 1, "gtk_print_operation_set_current_page", "GtkPrintOperation*");
  Xen_check_type(Xen_is_gint(current_page), current_page, 2, "gtk_print_operation_set_current_page", "gint");
  gtk_print_operation_set_current_page(Xen_to_C_GtkPrintOperation_(op), Xen_to_C_gint(current_page));
  return(Xen_false);
}

static Xen gxg_gtk_print_operation_set_use_full_page(Xen op, Xen full_page)
{
  #define H_gtk_print_operation_set_use_full_page "void gtk_print_operation_set_use_full_page(GtkPrintOperation* op, \
gboolean full_page)"
  Xen_check_type(Xen_is_GtkPrintOperation_(op), op, 1, "gtk_print_operation_set_use_full_page", "GtkPrintOperation*");
  Xen_check_type(Xen_is_gboolean(full_page), full_page, 2, "gtk_print_operation_set_use_full_page", "gboolean");
  gtk_print_operation_set_use_full_page(Xen_to_C_GtkPrintOperation_(op), Xen_to_C_gboolean(full_page));
  return(Xen_false);
}

static Xen gxg_gtk_print_operation_set_unit(Xen op, Xen unit)
{
  #define H_gtk_print_operation_set_unit "void gtk_print_operation_set_unit(GtkPrintOperation* op, GtkUnit unit)"
  Xen_check_type(Xen_is_GtkPrintOperation_(op), op, 1, "gtk_print_operation_set_unit", "GtkPrintOperation*");
  Xen_check_type(Xen_is_GtkUnit(unit), unit, 2, "gtk_print_operation_set_unit", "GtkUnit");
  gtk_print_operation_set_unit(Xen_to_C_GtkPrintOperation_(op), Xen_to_C_GtkUnit(unit));
  return(Xen_false);
}

static Xen gxg_gtk_print_operation_set_export_filename(Xen op, Xen filename)
{
  #define H_gtk_print_operation_set_export_filename "void gtk_print_operation_set_export_filename(GtkPrintOperation* op, \
gchar* filename)"
  Xen_check_type(Xen_is_GtkPrintOperation_(op), op, 1, "gtk_print_operation_set_export_filename", "GtkPrintOperation*");
  Xen_check_type(Xen_is_gchar_(filename), filename, 2, "gtk_print_operation_set_export_filename", "gchar*");
  gtk_print_operation_set_export_filename(Xen_to_C_GtkPrintOperation_(op), Xen_to_C_gchar_(filename));
  return(Xen_false);
}

static Xen gxg_gtk_print_operation_set_track_print_status(Xen op, Xen track_status)
{
  #define H_gtk_print_operation_set_track_print_status "void gtk_print_operation_set_track_print_status(GtkPrintOperation* op, \
gboolean track_status)"
  Xen_check_type(Xen_is_GtkPrintOperation_(op), op, 1, "gtk_print_operation_set_track_print_status", "GtkPrintOperation*");
  Xen_check_type(Xen_is_gboolean(track_status), track_status, 2, "gtk_print_operation_set_track_print_status", "gboolean");
  gtk_print_operation_set_track_print_status(Xen_to_C_GtkPrintOperation_(op), Xen_to_C_gboolean(track_status));
  return(Xen_false);
}

static Xen gxg_gtk_print_operation_set_show_progress(Xen op, Xen show_progress)
{
  #define H_gtk_print_operation_set_show_progress "void gtk_print_operation_set_show_progress(GtkPrintOperation* op, \
gboolean show_progress)"
  Xen_check_type(Xen_is_GtkPrintOperation_(op), op, 1, "gtk_print_operation_set_show_progress", "GtkPrintOperation*");
  Xen_check_type(Xen_is_gboolean(show_progress), show_progress, 2, "gtk_print_operation_set_show_progress", "gboolean");
  gtk_print_operation_set_show_progress(Xen_to_C_GtkPrintOperation_(op), Xen_to_C_gboolean(show_progress));
  return(Xen_false);
}

static Xen gxg_gtk_print_operation_set_allow_async(Xen op, Xen allow_async)
{
  #define H_gtk_print_operation_set_allow_async "void gtk_print_operation_set_allow_async(GtkPrintOperation* op, \
gboolean allow_async)"
  Xen_check_type(Xen_is_GtkPrintOperation_(op), op, 1, "gtk_print_operation_set_allow_async", "GtkPrintOperation*");
  Xen_check_type(Xen_is_gboolean(allow_async), allow_async, 2, "gtk_print_operation_set_allow_async", "gboolean");
  gtk_print_operation_set_allow_async(Xen_to_C_GtkPrintOperation_(op), Xen_to_C_gboolean(allow_async));
  return(Xen_false);
}

static Xen gxg_gtk_print_operation_set_custom_tab_label(Xen op, Xen label)
{
  #define H_gtk_print_operation_set_custom_tab_label "void gtk_print_operation_set_custom_tab_label(GtkPrintOperation* op, \
gchar* label)"
  Xen_check_type(Xen_is_GtkPrintOperation_(op), op, 1, "gtk_print_operation_set_custom_tab_label", "GtkPrintOperation*");
  Xen_check_type(Xen_is_gchar_(label), label, 2, "gtk_print_operation_set_custom_tab_label", "gchar*");
  gtk_print_operation_set_custom_tab_label(Xen_to_C_GtkPrintOperation_(op), Xen_to_C_gchar_(label));
  return(Xen_false);
}

static Xen gxg_gtk_print_operation_run(Xen op, Xen action, Xen parent, Xen ignore_error)
{
  #define H_gtk_print_operation_run "GtkPrintOperationResult gtk_print_operation_run(GtkPrintOperation* op, \
GtkPrintOperationAction action, GtkWindow* parent, GError** [error])"
  GError* ref_error = NULL;
  Xen_check_type(Xen_is_GtkPrintOperation_(op), op, 1, "gtk_print_operation_run", "GtkPrintOperation*");
  Xen_check_type(Xen_is_GtkPrintOperationAction(action), action, 2, "gtk_print_operation_run", "GtkPrintOperationAction");
  Xen_check_type(Xen_is_GtkWindow_(parent), parent, 3, "gtk_print_operation_run", "GtkWindow*");
  {
    Xen res_ult;
    res_ult = C_to_Xen_GtkPrintOperationResult(gtk_print_operation_run(Xen_to_C_GtkPrintOperation_(op), Xen_to_C_GtkPrintOperationAction(action), 
                                                                       Xen_to_C_GtkWindow_(parent), &ref_error));
    return(Xen_list_2(res_ult, C_to_Xen_GError_(ref_error)));
   }
}

static Xen gxg_gtk_print_operation_get_error(Xen op, Xen ignore_error)
{
  #define H_gtk_print_operation_get_error "void gtk_print_operation_get_error(GtkPrintOperation* op, \
GError** [error])"
  GError* ref_error = NULL;
  Xen_check_type(Xen_is_GtkPrintOperation_(op), op, 1, "gtk_print_operation_get_error", "GtkPrintOperation*");
  gtk_print_operation_get_error(Xen_to_C_GtkPrintOperation_(op), &ref_error);
  return(Xen_list_1(C_to_Xen_GError_(ref_error)));
}

static Xen gxg_gtk_print_operation_get_status(Xen op)
{
  #define H_gtk_print_operation_get_status "GtkPrintStatus gtk_print_operation_get_status(GtkPrintOperation* op)"
  Xen_check_type(Xen_is_GtkPrintOperation_(op), op, 1, "gtk_print_operation_get_status", "GtkPrintOperation*");
  return(C_to_Xen_GtkPrintStatus(gtk_print_operation_get_status(Xen_to_C_GtkPrintOperation_(op))));
}

static Xen gxg_gtk_print_operation_get_status_string(Xen op)
{
  #define H_gtk_print_operation_get_status_string "gchar* gtk_print_operation_get_status_string(GtkPrintOperation* op)"
  Xen_check_type(Xen_is_GtkPrintOperation_(op), op, 1, "gtk_print_operation_get_status_string", "GtkPrintOperation*");
  return(C_to_Xen_gchar_(gtk_print_operation_get_status_string(Xen_to_C_GtkPrintOperation_(op))));
}

static Xen gxg_gtk_print_operation_is_finished(Xen op)
{
  #define H_gtk_print_operation_is_finished "gboolean gtk_print_operation_is_finished(GtkPrintOperation* op)"
  Xen_check_type(Xen_is_GtkPrintOperation_(op), op, 1, "gtk_print_operation_is_finished", "GtkPrintOperation*");
  return(C_to_Xen_gboolean(gtk_print_operation_is_finished(Xen_to_C_GtkPrintOperation_(op))));
}

static Xen gxg_gtk_print_operation_cancel(Xen op)
{
  #define H_gtk_print_operation_cancel "void gtk_print_operation_cancel(GtkPrintOperation* op)"
  Xen_check_type(Xen_is_GtkPrintOperation_(op), op, 1, "gtk_print_operation_cancel", "GtkPrintOperation*");
  gtk_print_operation_cancel(Xen_to_C_GtkPrintOperation_(op));
  return(Xen_false);
}

static Xen gxg_gtk_print_run_page_setup_dialog(Xen parent, Xen page_setup, Xen settings)
{
  #define H_gtk_print_run_page_setup_dialog "GtkPageSetup* gtk_print_run_page_setup_dialog(GtkWindow* parent, \
GtkPageSetup* page_setup, GtkPrintSettings* settings)"
  Xen_check_type(Xen_is_GtkWindow_(parent), parent, 1, "gtk_print_run_page_setup_dialog", "GtkWindow*");
  Xen_check_type(Xen_is_GtkPageSetup_(page_setup), page_setup, 2, "gtk_print_run_page_setup_dialog", "GtkPageSetup*");
  Xen_check_type(Xen_is_GtkPrintSettings_(settings), settings, 3, "gtk_print_run_page_setup_dialog", "GtkPrintSettings*");
  return(C_to_Xen_GtkPageSetup_(gtk_print_run_page_setup_dialog(Xen_to_C_GtkWindow_(parent), Xen_to_C_GtkPageSetup_(page_setup), 
                                                                Xen_to_C_GtkPrintSettings_(settings))));
}

static Xen gxg_gtk_print_run_page_setup_dialog_async(Xen parent, Xen page_setup, Xen settings, Xen done_cb, Xen data)
{
  #define H_gtk_print_run_page_setup_dialog_async "void gtk_print_run_page_setup_dialog_async(GtkWindow* parent, \
GtkPageSetup* page_setup, GtkPrintSettings* settings, GtkPageSetupDoneFunc done_cb, gpointer data)"
  Xen_check_type(Xen_is_GtkWindow_(parent), parent, 1, "gtk_print_run_page_setup_dialog_async", "GtkWindow*");
  Xen_check_type(Xen_is_GtkPageSetup_(page_setup), page_setup, 2, "gtk_print_run_page_setup_dialog_async", "GtkPageSetup*");
  Xen_check_type(Xen_is_GtkPrintSettings_(settings), settings, 3, "gtk_print_run_page_setup_dialog_async", "GtkPrintSettings*");
  Xen_check_type(Xen_is_GtkPageSetupDoneFunc(done_cb), done_cb, 4, "gtk_print_run_page_setup_dialog_async", "GtkPageSetupDoneFunc");
  Xen_check_type(Xen_is_gpointer(data), data, 5, "gtk_print_run_page_setup_dialog_async", "gpointer");
  gtk_print_run_page_setup_dialog_async(Xen_to_C_GtkWindow_(parent), Xen_to_C_GtkPageSetup_(page_setup), Xen_to_C_GtkPrintSettings_(settings), 
                                        Xen_to_C_GtkPageSetupDoneFunc(done_cb), Xen_to_C_gpointer(data));
  return(Xen_false);
}

static Xen gxg_gtk_print_settings_new(void)
{
  #define H_gtk_print_settings_new "GtkPrintSettings* gtk_print_settings_new( void)"
  return(C_to_Xen_GtkPrintSettings_(gtk_print_settings_new()));
}

static Xen gxg_gtk_print_settings_copy(Xen other)
{
  #define H_gtk_print_settings_copy "GtkPrintSettings* gtk_print_settings_copy(GtkPrintSettings* other)"
  Xen_check_type(Xen_is_GtkPrintSettings_(other), other, 1, "gtk_print_settings_copy", "GtkPrintSettings*");
  return(C_to_Xen_GtkPrintSettings_(gtk_print_settings_copy(Xen_to_C_GtkPrintSettings_(other))));
}

static Xen gxg_gtk_print_settings_has_key(Xen settings, Xen key)
{
  #define H_gtk_print_settings_has_key "gboolean gtk_print_settings_has_key(GtkPrintSettings* settings, \
gchar* key)"
  Xen_check_type(Xen_is_GtkPrintSettings_(settings), settings, 1, "gtk_print_settings_has_key", "GtkPrintSettings*");
  Xen_check_type(Xen_is_gchar_(key), key, 2, "gtk_print_settings_has_key", "gchar*");
  return(C_to_Xen_gboolean(gtk_print_settings_has_key(Xen_to_C_GtkPrintSettings_(settings), Xen_to_C_gchar_(key))));
}

static Xen gxg_gtk_print_settings_get(Xen settings, Xen key)
{
  #define H_gtk_print_settings_get "gchar* gtk_print_settings_get(GtkPrintSettings* settings, gchar* key)"
  Xen_check_type(Xen_is_GtkPrintSettings_(settings), settings, 1, "gtk_print_settings_get", "GtkPrintSettings*");
  Xen_check_type(Xen_is_gchar_(key), key, 2, "gtk_print_settings_get", "gchar*");
  return(C_to_Xen_gchar_(gtk_print_settings_get(Xen_to_C_GtkPrintSettings_(settings), Xen_to_C_gchar_(key))));
}

static Xen gxg_gtk_print_settings_set(Xen settings, Xen key, Xen value)
{
  #define H_gtk_print_settings_set "void gtk_print_settings_set(GtkPrintSettings* settings, gchar* key, \
gchar* value)"
  Xen_check_type(Xen_is_GtkPrintSettings_(settings), settings, 1, "gtk_print_settings_set", "GtkPrintSettings*");
  Xen_check_type(Xen_is_gchar_(key), key, 2, "gtk_print_settings_set", "gchar*");
  Xen_check_type(Xen_is_gchar_(value), value, 3, "gtk_print_settings_set", "gchar*");
  gtk_print_settings_set(Xen_to_C_GtkPrintSettings_(settings), Xen_to_C_gchar_(key), Xen_to_C_gchar_(value));
  return(Xen_false);
}

static Xen gxg_gtk_print_settings_unset(Xen settings, Xen key)
{
  #define H_gtk_print_settings_unset "void gtk_print_settings_unset(GtkPrintSettings* settings, gchar* key)"
  Xen_check_type(Xen_is_GtkPrintSettings_(settings), settings, 1, "gtk_print_settings_unset", "GtkPrintSettings*");
  Xen_check_type(Xen_is_gchar_(key), key, 2, "gtk_print_settings_unset", "gchar*");
  gtk_print_settings_unset(Xen_to_C_GtkPrintSettings_(settings), Xen_to_C_gchar_(key));
  return(Xen_false);
}

static Xen gxg_gtk_print_settings_foreach(Xen settings, Xen func, Xen user_data)
{
  #define H_gtk_print_settings_foreach "void gtk_print_settings_foreach(GtkPrintSettings* settings, GtkPrintSettingsFunc func, \
gpointer user_data)"
  Xen_check_type(Xen_is_GtkPrintSettings_(settings), settings, 1, "gtk_print_settings_foreach", "GtkPrintSettings*");
  Xen_check_type(Xen_is_GtkPrintSettingsFunc(func), func, 2, "gtk_print_settings_foreach", "GtkPrintSettingsFunc");
  Xen_check_type(Xen_is_gpointer(user_data), user_data, 3, "gtk_print_settings_foreach", "gpointer");
  gtk_print_settings_foreach(Xen_to_C_GtkPrintSettings_(settings), Xen_to_C_GtkPrintSettingsFunc(func), Xen_to_C_gpointer(user_data));
  return(Xen_false);
}

static Xen gxg_gtk_print_settings_get_bool(Xen settings, Xen key)
{
  #define H_gtk_print_settings_get_bool "gboolean gtk_print_settings_get_bool(GtkPrintSettings* settings, \
gchar* key)"
  Xen_check_type(Xen_is_GtkPrintSettings_(settings), settings, 1, "gtk_print_settings_get_bool", "GtkPrintSettings*");
  Xen_check_type(Xen_is_gchar_(key), key, 2, "gtk_print_settings_get_bool", "gchar*");
  return(C_to_Xen_gboolean(gtk_print_settings_get_bool(Xen_to_C_GtkPrintSettings_(settings), Xen_to_C_gchar_(key))));
}

static Xen gxg_gtk_print_settings_set_bool(Xen settings, Xen key, Xen value)
{
  #define H_gtk_print_settings_set_bool "void gtk_print_settings_set_bool(GtkPrintSettings* settings, \
gchar* key, gboolean value)"
  Xen_check_type(Xen_is_GtkPrintSettings_(settings), settings, 1, "gtk_print_settings_set_bool", "GtkPrintSettings*");
  Xen_check_type(Xen_is_gchar_(key), key, 2, "gtk_print_settings_set_bool", "gchar*");
  Xen_check_type(Xen_is_gboolean(value), value, 3, "gtk_print_settings_set_bool", "gboolean");
  gtk_print_settings_set_bool(Xen_to_C_GtkPrintSettings_(settings), Xen_to_C_gchar_(key), Xen_to_C_gboolean(value));
  return(Xen_false);
}

static Xen gxg_gtk_print_settings_get_double(Xen settings, Xen key)
{
  #define H_gtk_print_settings_get_double "gdouble gtk_print_settings_get_double(GtkPrintSettings* settings, \
gchar* key)"
  Xen_check_type(Xen_is_GtkPrintSettings_(settings), settings, 1, "gtk_print_settings_get_double", "GtkPrintSettings*");
  Xen_check_type(Xen_is_gchar_(key), key, 2, "gtk_print_settings_get_double", "gchar*");
  return(C_to_Xen_gdouble(gtk_print_settings_get_double(Xen_to_C_GtkPrintSettings_(settings), Xen_to_C_gchar_(key))));
}

static Xen gxg_gtk_print_settings_get_double_with_default(Xen settings, Xen key, Xen def)
{
  #define H_gtk_print_settings_get_double_with_default "gdouble gtk_print_settings_get_double_with_default(GtkPrintSettings* settings, \
gchar* key, gdouble def)"
  Xen_check_type(Xen_is_GtkPrintSettings_(settings), settings, 1, "gtk_print_settings_get_double_with_default", "GtkPrintSettings*");
  Xen_check_type(Xen_is_gchar_(key), key, 2, "gtk_print_settings_get_double_with_default", "gchar*");
  Xen_check_type(Xen_is_gdouble(def), def, 3, "gtk_print_settings_get_double_with_default", "gdouble");
  return(C_to_Xen_gdouble(gtk_print_settings_get_double_with_default(Xen_to_C_GtkPrintSettings_(settings), Xen_to_C_gchar_(key), 
                                                                     Xen_to_C_gdouble(def))));
}

static Xen gxg_gtk_print_settings_set_double(Xen settings, Xen key, Xen value)
{
  #define H_gtk_print_settings_set_double "void gtk_print_settings_set_double(GtkPrintSettings* settings, \
gchar* key, gdouble value)"
  Xen_check_type(Xen_is_GtkPrintSettings_(settings), settings, 1, "gtk_print_settings_set_double", "GtkPrintSettings*");
  Xen_check_type(Xen_is_gchar_(key), key, 2, "gtk_print_settings_set_double", "gchar*");
  Xen_check_type(Xen_is_gdouble(value), value, 3, "gtk_print_settings_set_double", "gdouble");
  gtk_print_settings_set_double(Xen_to_C_GtkPrintSettings_(settings), Xen_to_C_gchar_(key), Xen_to_C_gdouble(value));
  return(Xen_false);
}

static Xen gxg_gtk_print_settings_get_length(Xen settings, Xen key, Xen unit)
{
  #define H_gtk_print_settings_get_length "gdouble gtk_print_settings_get_length(GtkPrintSettings* settings, \
gchar* key, GtkUnit unit)"
  Xen_check_type(Xen_is_GtkPrintSettings_(settings), settings, 1, "gtk_print_settings_get_length", "GtkPrintSettings*");
  Xen_check_type(Xen_is_gchar_(key), key, 2, "gtk_print_settings_get_length", "gchar*");
  Xen_check_type(Xen_is_GtkUnit(unit), unit, 3, "gtk_print_settings_get_length", "GtkUnit");
  return(C_to_Xen_gdouble(gtk_print_settings_get_length(Xen_to_C_GtkPrintSettings_(settings), Xen_to_C_gchar_(key), Xen_to_C_GtkUnit(unit))));
}

static Xen gxg_gtk_print_settings_set_length(Xen settings, Xen key, Xen value, Xen unit)
{
  #define H_gtk_print_settings_set_length "void gtk_print_settings_set_length(GtkPrintSettings* settings, \
gchar* key, gdouble value, GtkUnit unit)"
  Xen_check_type(Xen_is_GtkPrintSettings_(settings), settings, 1, "gtk_print_settings_set_length", "GtkPrintSettings*");
  Xen_check_type(Xen_is_gchar_(key), key, 2, "gtk_print_settings_set_length", "gchar*");
  Xen_check_type(Xen_is_gdouble(value), value, 3, "gtk_print_settings_set_length", "gdouble");
  Xen_check_type(Xen_is_GtkUnit(unit), unit, 4, "gtk_print_settings_set_length", "GtkUnit");
  gtk_print_settings_set_length(Xen_to_C_GtkPrintSettings_(settings), Xen_to_C_gchar_(key), Xen_to_C_gdouble(value), Xen_to_C_GtkUnit(unit));
  return(Xen_false);
}

static Xen gxg_gtk_print_settings_get_int(Xen settings, Xen key)
{
  #define H_gtk_print_settings_get_int "gint gtk_print_settings_get_int(GtkPrintSettings* settings, gchar* key)"
  Xen_check_type(Xen_is_GtkPrintSettings_(settings), settings, 1, "gtk_print_settings_get_int", "GtkPrintSettings*");
  Xen_check_type(Xen_is_gchar_(key), key, 2, "gtk_print_settings_get_int", "gchar*");
  return(C_to_Xen_gint(gtk_print_settings_get_int(Xen_to_C_GtkPrintSettings_(settings), Xen_to_C_gchar_(key))));
}

static Xen gxg_gtk_print_settings_get_int_with_default(Xen settings, Xen key, Xen def)
{
  #define H_gtk_print_settings_get_int_with_default "gint gtk_print_settings_get_int_with_default(GtkPrintSettings* settings, \
gchar* key, gint def)"
  Xen_check_type(Xen_is_GtkPrintSettings_(settings), settings, 1, "gtk_print_settings_get_int_with_default", "GtkPrintSettings*");
  Xen_check_type(Xen_is_gchar_(key), key, 2, "gtk_print_settings_get_int_with_default", "gchar*");
  Xen_check_type(Xen_is_gint(def), def, 3, "gtk_print_settings_get_int_with_default", "gint");
  return(C_to_Xen_gint(gtk_print_settings_get_int_with_default(Xen_to_C_GtkPrintSettings_(settings), Xen_to_C_gchar_(key), 
                                                               Xen_to_C_gint(def))));
}

static Xen gxg_gtk_print_settings_set_int(Xen settings, Xen key, Xen value)
{
  #define H_gtk_print_settings_set_int "void gtk_print_settings_set_int(GtkPrintSettings* settings, gchar* key, \
gint value)"
  Xen_check_type(Xen_is_GtkPrintSettings_(settings), settings, 1, "gtk_print_settings_set_int", "GtkPrintSettings*");
  Xen_check_type(Xen_is_gchar_(key), key, 2, "gtk_print_settings_set_int", "gchar*");
  Xen_check_type(Xen_is_gint(value), value, 3, "gtk_print_settings_set_int", "gint");
  gtk_print_settings_set_int(Xen_to_C_GtkPrintSettings_(settings), Xen_to_C_gchar_(key), Xen_to_C_gint(value));
  return(Xen_false);
}

static Xen gxg_gtk_print_settings_get_printer(Xen settings)
{
  #define H_gtk_print_settings_get_printer "gchar* gtk_print_settings_get_printer(GtkPrintSettings* settings)"
  Xen_check_type(Xen_is_GtkPrintSettings_(settings), settings, 1, "gtk_print_settings_get_printer", "GtkPrintSettings*");
  return(C_to_Xen_gchar_(gtk_print_settings_get_printer(Xen_to_C_GtkPrintSettings_(settings))));
}

static Xen gxg_gtk_print_settings_set_printer(Xen settings, Xen printer)
{
  #define H_gtk_print_settings_set_printer "void gtk_print_settings_set_printer(GtkPrintSettings* settings, \
gchar* printer)"
  Xen_check_type(Xen_is_GtkPrintSettings_(settings), settings, 1, "gtk_print_settings_set_printer", "GtkPrintSettings*");
  Xen_check_type(Xen_is_gchar_(printer), printer, 2, "gtk_print_settings_set_printer", "gchar*");
  gtk_print_settings_set_printer(Xen_to_C_GtkPrintSettings_(settings), Xen_to_C_gchar_(printer));
  return(Xen_false);
}

static Xen gxg_gtk_print_settings_get_orientation(Xen settings)
{
  #define H_gtk_print_settings_get_orientation "GtkPageOrientation gtk_print_settings_get_orientation(GtkPrintSettings* settings)"
  Xen_check_type(Xen_is_GtkPrintSettings_(settings), settings, 1, "gtk_print_settings_get_orientation", "GtkPrintSettings*");
  return(C_to_Xen_GtkPageOrientation(gtk_print_settings_get_orientation(Xen_to_C_GtkPrintSettings_(settings))));
}

static Xen gxg_gtk_print_settings_set_orientation(Xen settings, Xen orientation)
{
  #define H_gtk_print_settings_set_orientation "void gtk_print_settings_set_orientation(GtkPrintSettings* settings, \
GtkPageOrientation orientation)"
  Xen_check_type(Xen_is_GtkPrintSettings_(settings), settings, 1, "gtk_print_settings_set_orientation", "GtkPrintSettings*");
  Xen_check_type(Xen_is_GtkPageOrientation(orientation), orientation, 2, "gtk_print_settings_set_orientation", "GtkPageOrientation");
  gtk_print_settings_set_orientation(Xen_to_C_GtkPrintSettings_(settings), Xen_to_C_GtkPageOrientation(orientation));
  return(Xen_false);
}

static Xen gxg_gtk_print_settings_get_paper_size(Xen settings)
{
  #define H_gtk_print_settings_get_paper_size "GtkPaperSize* gtk_print_settings_get_paper_size(GtkPrintSettings* settings)"
  Xen_check_type(Xen_is_GtkPrintSettings_(settings), settings, 1, "gtk_print_settings_get_paper_size", "GtkPrintSettings*");
  return(C_to_Xen_GtkPaperSize_(gtk_print_settings_get_paper_size(Xen_to_C_GtkPrintSettings_(settings))));
}

static Xen gxg_gtk_print_settings_set_paper_size(Xen settings, Xen paper_size)
{
  #define H_gtk_print_settings_set_paper_size "void gtk_print_settings_set_paper_size(GtkPrintSettings* settings, \
GtkPaperSize* paper_size)"
  Xen_check_type(Xen_is_GtkPrintSettings_(settings), settings, 1, "gtk_print_settings_set_paper_size", "GtkPrintSettings*");
  Xen_check_type(Xen_is_GtkPaperSize_(paper_size), paper_size, 2, "gtk_print_settings_set_paper_size", "GtkPaperSize*");
  gtk_print_settings_set_paper_size(Xen_to_C_GtkPrintSettings_(settings), Xen_to_C_GtkPaperSize_(paper_size));
  return(Xen_false);
}

static Xen gxg_gtk_print_settings_get_paper_width(Xen settings, Xen unit)
{
  #define H_gtk_print_settings_get_paper_width "gdouble gtk_print_settings_get_paper_width(GtkPrintSettings* settings, \
GtkUnit unit)"
  Xen_check_type(Xen_is_GtkPrintSettings_(settings), settings, 1, "gtk_print_settings_get_paper_width", "GtkPrintSettings*");
  Xen_check_type(Xen_is_GtkUnit(unit), unit, 2, "gtk_print_settings_get_paper_width", "GtkUnit");
  return(C_to_Xen_gdouble(gtk_print_settings_get_paper_width(Xen_to_C_GtkPrintSettings_(settings), Xen_to_C_GtkUnit(unit))));
}

static Xen gxg_gtk_print_settings_set_paper_width(Xen settings, Xen width, Xen unit)
{
  #define H_gtk_print_settings_set_paper_width "void gtk_print_settings_set_paper_width(GtkPrintSettings* settings, \
gdouble width, GtkUnit unit)"
  Xen_check_type(Xen_is_GtkPrintSettings_(settings), settings, 1, "gtk_print_settings_set_paper_width", "GtkPrintSettings*");
  Xen_check_type(Xen_is_gdouble(width), width, 2, "gtk_print_settings_set_paper_width", "gdouble");
  Xen_check_type(Xen_is_GtkUnit(unit), unit, 3, "gtk_print_settings_set_paper_width", "GtkUnit");
  gtk_print_settings_set_paper_width(Xen_to_C_GtkPrintSettings_(settings), Xen_to_C_gdouble(width), Xen_to_C_GtkUnit(unit));
  return(Xen_false);
}

static Xen gxg_gtk_print_settings_get_paper_height(Xen settings, Xen unit)
{
  #define H_gtk_print_settings_get_paper_height "gdouble gtk_print_settings_get_paper_height(GtkPrintSettings* settings, \
GtkUnit unit)"
  Xen_check_type(Xen_is_GtkPrintSettings_(settings), settings, 1, "gtk_print_settings_get_paper_height", "GtkPrintSettings*");
  Xen_check_type(Xen_is_GtkUnit(unit), unit, 2, "gtk_print_settings_get_paper_height", "GtkUnit");
  return(C_to_Xen_gdouble(gtk_print_settings_get_paper_height(Xen_to_C_GtkPrintSettings_(settings), Xen_to_C_GtkUnit(unit))));
}

static Xen gxg_gtk_print_settings_set_paper_height(Xen settings, Xen height, Xen unit)
{
  #define H_gtk_print_settings_set_paper_height "void gtk_print_settings_set_paper_height(GtkPrintSettings* settings, \
gdouble height, GtkUnit unit)"
  Xen_check_type(Xen_is_GtkPrintSettings_(settings), settings, 1, "gtk_print_settings_set_paper_height", "GtkPrintSettings*");
  Xen_check_type(Xen_is_gdouble(height), height, 2, "gtk_print_settings_set_paper_height", "gdouble");
  Xen_check_type(Xen_is_GtkUnit(unit), unit, 3, "gtk_print_settings_set_paper_height", "GtkUnit");
  gtk_print_settings_set_paper_height(Xen_to_C_GtkPrintSettings_(settings), Xen_to_C_gdouble(height), Xen_to_C_GtkUnit(unit));
  return(Xen_false);
}

static Xen gxg_gtk_print_settings_get_use_color(Xen settings)
{
  #define H_gtk_print_settings_get_use_color "gboolean gtk_print_settings_get_use_color(GtkPrintSettings* settings)"
  Xen_check_type(Xen_is_GtkPrintSettings_(settings), settings, 1, "gtk_print_settings_get_use_color", "GtkPrintSettings*");
  return(C_to_Xen_gboolean(gtk_print_settings_get_use_color(Xen_to_C_GtkPrintSettings_(settings))));
}

static Xen gxg_gtk_print_settings_set_use_color(Xen settings, Xen use_color)
{
  #define H_gtk_print_settings_set_use_color "void gtk_print_settings_set_use_color(GtkPrintSettings* settings, \
gboolean use_color)"
  Xen_check_type(Xen_is_GtkPrintSettings_(settings), settings, 1, "gtk_print_settings_set_use_color", "GtkPrintSettings*");
  Xen_check_type(Xen_is_gboolean(use_color), use_color, 2, "gtk_print_settings_set_use_color", "gboolean");
  gtk_print_settings_set_use_color(Xen_to_C_GtkPrintSettings_(settings), Xen_to_C_gboolean(use_color));
  return(Xen_false);
}

static Xen gxg_gtk_print_settings_get_collate(Xen settings)
{
  #define H_gtk_print_settings_get_collate "gboolean gtk_print_settings_get_collate(GtkPrintSettings* settings)"
  Xen_check_type(Xen_is_GtkPrintSettings_(settings), settings, 1, "gtk_print_settings_get_collate", "GtkPrintSettings*");
  return(C_to_Xen_gboolean(gtk_print_settings_get_collate(Xen_to_C_GtkPrintSettings_(settings))));
}

static Xen gxg_gtk_print_settings_set_collate(Xen settings, Xen collate)
{
  #define H_gtk_print_settings_set_collate "void gtk_print_settings_set_collate(GtkPrintSettings* settings, \
gboolean collate)"
  Xen_check_type(Xen_is_GtkPrintSettings_(settings), settings, 1, "gtk_print_settings_set_collate", "GtkPrintSettings*");
  Xen_check_type(Xen_is_gboolean(collate), collate, 2, "gtk_print_settings_set_collate", "gboolean");
  gtk_print_settings_set_collate(Xen_to_C_GtkPrintSettings_(settings), Xen_to_C_gboolean(collate));
  return(Xen_false);
}

static Xen gxg_gtk_print_settings_get_reverse(Xen settings)
{
  #define H_gtk_print_settings_get_reverse "gboolean gtk_print_settings_get_reverse(GtkPrintSettings* settings)"
  Xen_check_type(Xen_is_GtkPrintSettings_(settings), settings, 1, "gtk_print_settings_get_reverse", "GtkPrintSettings*");
  return(C_to_Xen_gboolean(gtk_print_settings_get_reverse(Xen_to_C_GtkPrintSettings_(settings))));
}

static Xen gxg_gtk_print_settings_set_reverse(Xen settings, Xen reverse)
{
  #define H_gtk_print_settings_set_reverse "void gtk_print_settings_set_reverse(GtkPrintSettings* settings, \
gboolean reverse)"
  Xen_check_type(Xen_is_GtkPrintSettings_(settings), settings, 1, "gtk_print_settings_set_reverse", "GtkPrintSettings*");
  Xen_check_type(Xen_is_gboolean(reverse), reverse, 2, "gtk_print_settings_set_reverse", "gboolean");
  gtk_print_settings_set_reverse(Xen_to_C_GtkPrintSettings_(settings), Xen_to_C_gboolean(reverse));
  return(Xen_false);
}

static Xen gxg_gtk_print_settings_get_duplex(Xen settings)
{
  #define H_gtk_print_settings_get_duplex "GtkPrintDuplex gtk_print_settings_get_duplex(GtkPrintSettings* settings)"
  Xen_check_type(Xen_is_GtkPrintSettings_(settings), settings, 1, "gtk_print_settings_get_duplex", "GtkPrintSettings*");
  return(C_to_Xen_GtkPrintDuplex(gtk_print_settings_get_duplex(Xen_to_C_GtkPrintSettings_(settings))));
}

static Xen gxg_gtk_print_settings_set_duplex(Xen settings, Xen duplex)
{
  #define H_gtk_print_settings_set_duplex "void gtk_print_settings_set_duplex(GtkPrintSettings* settings, \
GtkPrintDuplex duplex)"
  Xen_check_type(Xen_is_GtkPrintSettings_(settings), settings, 1, "gtk_print_settings_set_duplex", "GtkPrintSettings*");
  Xen_check_type(Xen_is_GtkPrintDuplex(duplex), duplex, 2, "gtk_print_settings_set_duplex", "GtkPrintDuplex");
  gtk_print_settings_set_duplex(Xen_to_C_GtkPrintSettings_(settings), Xen_to_C_GtkPrintDuplex(duplex));
  return(Xen_false);
}

static Xen gxg_gtk_print_settings_get_quality(Xen settings)
{
  #define H_gtk_print_settings_get_quality "GtkPrintQuality gtk_print_settings_get_quality(GtkPrintSettings* settings)"
  Xen_check_type(Xen_is_GtkPrintSettings_(settings), settings, 1, "gtk_print_settings_get_quality", "GtkPrintSettings*");
  return(C_to_Xen_GtkPrintQuality(gtk_print_settings_get_quality(Xen_to_C_GtkPrintSettings_(settings))));
}

static Xen gxg_gtk_print_settings_set_quality(Xen settings, Xen quality)
{
  #define H_gtk_print_settings_set_quality "void gtk_print_settings_set_quality(GtkPrintSettings* settings, \
GtkPrintQuality quality)"
  Xen_check_type(Xen_is_GtkPrintSettings_(settings), settings, 1, "gtk_print_settings_set_quality", "GtkPrintSettings*");
  Xen_check_type(Xen_is_GtkPrintQuality(quality), quality, 2, "gtk_print_settings_set_quality", "GtkPrintQuality");
  gtk_print_settings_set_quality(Xen_to_C_GtkPrintSettings_(settings), Xen_to_C_GtkPrintQuality(quality));
  return(Xen_false);
}

static Xen gxg_gtk_print_settings_get_n_copies(Xen settings)
{
  #define H_gtk_print_settings_get_n_copies "gint gtk_print_settings_get_n_copies(GtkPrintSettings* settings)"
  Xen_check_type(Xen_is_GtkPrintSettings_(settings), settings, 1, "gtk_print_settings_get_n_copies", "GtkPrintSettings*");
  return(C_to_Xen_gint(gtk_print_settings_get_n_copies(Xen_to_C_GtkPrintSettings_(settings))));
}

static Xen gxg_gtk_print_settings_set_n_copies(Xen settings, Xen num_copies)
{
  #define H_gtk_print_settings_set_n_copies "void gtk_print_settings_set_n_copies(GtkPrintSettings* settings, \
gint num_copies)"
  Xen_check_type(Xen_is_GtkPrintSettings_(settings), settings, 1, "gtk_print_settings_set_n_copies", "GtkPrintSettings*");
  Xen_check_type(Xen_is_gint(num_copies), num_copies, 2, "gtk_print_settings_set_n_copies", "gint");
  gtk_print_settings_set_n_copies(Xen_to_C_GtkPrintSettings_(settings), Xen_to_C_gint(num_copies));
  return(Xen_false);
}

static Xen gxg_gtk_print_settings_get_number_up(Xen settings)
{
  #define H_gtk_print_settings_get_number_up "gint gtk_print_settings_get_number_up(GtkPrintSettings* settings)"
  Xen_check_type(Xen_is_GtkPrintSettings_(settings), settings, 1, "gtk_print_settings_get_number_up", "GtkPrintSettings*");
  return(C_to_Xen_gint(gtk_print_settings_get_number_up(Xen_to_C_GtkPrintSettings_(settings))));
}

static Xen gxg_gtk_print_settings_set_number_up(Xen settings, Xen number_up)
{
  #define H_gtk_print_settings_set_number_up "void gtk_print_settings_set_number_up(GtkPrintSettings* settings, \
gint number_up)"
  Xen_check_type(Xen_is_GtkPrintSettings_(settings), settings, 1, "gtk_print_settings_set_number_up", "GtkPrintSettings*");
  Xen_check_type(Xen_is_gint(number_up), number_up, 2, "gtk_print_settings_set_number_up", "gint");
  gtk_print_settings_set_number_up(Xen_to_C_GtkPrintSettings_(settings), Xen_to_C_gint(number_up));
  return(Xen_false);
}

static Xen gxg_gtk_print_settings_get_resolution(Xen settings)
{
  #define H_gtk_print_settings_get_resolution "gint gtk_print_settings_get_resolution(GtkPrintSettings* settings)"
  Xen_check_type(Xen_is_GtkPrintSettings_(settings), settings, 1, "gtk_print_settings_get_resolution", "GtkPrintSettings*");
  return(C_to_Xen_gint(gtk_print_settings_get_resolution(Xen_to_C_GtkPrintSettings_(settings))));
}

static Xen gxg_gtk_print_settings_set_resolution(Xen settings, Xen resolution)
{
  #define H_gtk_print_settings_set_resolution "void gtk_print_settings_set_resolution(GtkPrintSettings* settings, \
gint resolution)"
  Xen_check_type(Xen_is_GtkPrintSettings_(settings), settings, 1, "gtk_print_settings_set_resolution", "GtkPrintSettings*");
  Xen_check_type(Xen_is_gint(resolution), resolution, 2, "gtk_print_settings_set_resolution", "gint");
  gtk_print_settings_set_resolution(Xen_to_C_GtkPrintSettings_(settings), Xen_to_C_gint(resolution));
  return(Xen_false);
}

static Xen gxg_gtk_print_settings_get_scale(Xen settings)
{
  #define H_gtk_print_settings_get_scale "gdouble gtk_print_settings_get_scale(GtkPrintSettings* settings)"
  Xen_check_type(Xen_is_GtkPrintSettings_(settings), settings, 1, "gtk_print_settings_get_scale", "GtkPrintSettings*");
  return(C_to_Xen_gdouble(gtk_print_settings_get_scale(Xen_to_C_GtkPrintSettings_(settings))));
}

static Xen gxg_gtk_print_settings_set_scale(Xen settings, Xen scale)
{
  #define H_gtk_print_settings_set_scale "void gtk_print_settings_set_scale(GtkPrintSettings* settings, \
gdouble scale)"
  Xen_check_type(Xen_is_GtkPrintSettings_(settings), settings, 1, "gtk_print_settings_set_scale", "GtkPrintSettings*");
  Xen_check_type(Xen_is_gdouble(scale), scale, 2, "gtk_print_settings_set_scale", "gdouble");
  gtk_print_settings_set_scale(Xen_to_C_GtkPrintSettings_(settings), Xen_to_C_gdouble(scale));
  return(Xen_false);
}

static Xen gxg_gtk_print_settings_get_print_pages(Xen settings)
{
  #define H_gtk_print_settings_get_print_pages "GtkPrintPages gtk_print_settings_get_print_pages(GtkPrintSettings* settings)"
  Xen_check_type(Xen_is_GtkPrintSettings_(settings), settings, 1, "gtk_print_settings_get_print_pages", "GtkPrintSettings*");
  return(C_to_Xen_GtkPrintPages(gtk_print_settings_get_print_pages(Xen_to_C_GtkPrintSettings_(settings))));
}

static Xen gxg_gtk_print_settings_set_print_pages(Xen settings, Xen pages)
{
  #define H_gtk_print_settings_set_print_pages "void gtk_print_settings_set_print_pages(GtkPrintSettings* settings, \
GtkPrintPages pages)"
  Xen_check_type(Xen_is_GtkPrintSettings_(settings), settings, 1, "gtk_print_settings_set_print_pages", "GtkPrintSettings*");
  Xen_check_type(Xen_is_GtkPrintPages(pages), pages, 2, "gtk_print_settings_set_print_pages", "GtkPrintPages");
  gtk_print_settings_set_print_pages(Xen_to_C_GtkPrintSettings_(settings), Xen_to_C_GtkPrintPages(pages));
  return(Xen_false);
}

static Xen gxg_gtk_print_settings_get_page_ranges(Xen settings, Xen num_ranges)
{
  #define H_gtk_print_settings_get_page_ranges "GtkPageRange* gtk_print_settings_get_page_ranges(GtkPrintSettings* settings, \
gint* num_ranges)"
  Xen_check_type(Xen_is_GtkPrintSettings_(settings), settings, 1, "gtk_print_settings_get_page_ranges", "GtkPrintSettings*");
  Xen_check_type(Xen_is_gint_(num_ranges), num_ranges, 2, "gtk_print_settings_get_page_ranges", "gint*");
  return(C_to_Xen_GtkPageRange_(gtk_print_settings_get_page_ranges(Xen_to_C_GtkPrintSettings_(settings), Xen_to_C_gint_(num_ranges))));
}

static Xen gxg_gtk_print_settings_set_page_ranges(Xen settings, Xen page_ranges, Xen num_ranges)
{
  #define H_gtk_print_settings_set_page_ranges "void gtk_print_settings_set_page_ranges(GtkPrintSettings* settings, \
GtkPageRange* page_ranges, gint num_ranges)"
  Xen_check_type(Xen_is_GtkPrintSettings_(settings), settings, 1, "gtk_print_settings_set_page_ranges", "GtkPrintSettings*");
  Xen_check_type(Xen_is_GtkPageRange_(page_ranges), page_ranges, 2, "gtk_print_settings_set_page_ranges", "GtkPageRange*");
  Xen_check_type(Xen_is_gint(num_ranges), num_ranges, 3, "gtk_print_settings_set_page_ranges", "gint");
  gtk_print_settings_set_page_ranges(Xen_to_C_GtkPrintSettings_(settings), Xen_to_C_GtkPageRange_(page_ranges), Xen_to_C_gint(num_ranges));
  return(Xen_false);
}

static Xen gxg_gtk_print_settings_get_page_set(Xen settings)
{
  #define H_gtk_print_settings_get_page_set "GtkPageSet gtk_print_settings_get_page_set(GtkPrintSettings* settings)"
  Xen_check_type(Xen_is_GtkPrintSettings_(settings), settings, 1, "gtk_print_settings_get_page_set", "GtkPrintSettings*");
  return(C_to_Xen_GtkPageSet(gtk_print_settings_get_page_set(Xen_to_C_GtkPrintSettings_(settings))));
}

static Xen gxg_gtk_print_settings_set_page_set(Xen settings, Xen page_set)
{
  #define H_gtk_print_settings_set_page_set "void gtk_print_settings_set_page_set(GtkPrintSettings* settings, \
GtkPageSet page_set)"
  Xen_check_type(Xen_is_GtkPrintSettings_(settings), settings, 1, "gtk_print_settings_set_page_set", "GtkPrintSettings*");
  Xen_check_type(Xen_is_GtkPageSet(page_set), page_set, 2, "gtk_print_settings_set_page_set", "GtkPageSet");
  gtk_print_settings_set_page_set(Xen_to_C_GtkPrintSettings_(settings), Xen_to_C_GtkPageSet(page_set));
  return(Xen_false);
}

static Xen gxg_gtk_print_settings_get_default_source(Xen settings)
{
  #define H_gtk_print_settings_get_default_source "gchar* gtk_print_settings_get_default_source(GtkPrintSettings* settings)"
  Xen_check_type(Xen_is_GtkPrintSettings_(settings), settings, 1, "gtk_print_settings_get_default_source", "GtkPrintSettings*");
  return(C_to_Xen_gchar_(gtk_print_settings_get_default_source(Xen_to_C_GtkPrintSettings_(settings))));
}

static Xen gxg_gtk_print_settings_set_default_source(Xen settings, Xen default_source)
{
  #define H_gtk_print_settings_set_default_source "void gtk_print_settings_set_default_source(GtkPrintSettings* settings, \
gchar* default_source)"
  Xen_check_type(Xen_is_GtkPrintSettings_(settings), settings, 1, "gtk_print_settings_set_default_source", "GtkPrintSettings*");
  Xen_check_type(Xen_is_gchar_(default_source), default_source, 2, "gtk_print_settings_set_default_source", "gchar*");
  gtk_print_settings_set_default_source(Xen_to_C_GtkPrintSettings_(settings), Xen_to_C_gchar_(default_source));
  return(Xen_false);
}

static Xen gxg_gtk_print_settings_get_media_type(Xen settings)
{
  #define H_gtk_print_settings_get_media_type "gchar* gtk_print_settings_get_media_type(GtkPrintSettings* settings)"
  Xen_check_type(Xen_is_GtkPrintSettings_(settings), settings, 1, "gtk_print_settings_get_media_type", "GtkPrintSettings*");
  return(C_to_Xen_gchar_(gtk_print_settings_get_media_type(Xen_to_C_GtkPrintSettings_(settings))));
}

static Xen gxg_gtk_print_settings_set_media_type(Xen settings, Xen media_type)
{
  #define H_gtk_print_settings_set_media_type "void gtk_print_settings_set_media_type(GtkPrintSettings* settings, \
gchar* media_type)"
  Xen_check_type(Xen_is_GtkPrintSettings_(settings), settings, 1, "gtk_print_settings_set_media_type", "GtkPrintSettings*");
  Xen_check_type(Xen_is_gchar_(media_type), media_type, 2, "gtk_print_settings_set_media_type", "gchar*");
  gtk_print_settings_set_media_type(Xen_to_C_GtkPrintSettings_(settings), Xen_to_C_gchar_(media_type));
  return(Xen_false);
}

static Xen gxg_gtk_print_settings_get_dither(Xen settings)
{
  #define H_gtk_print_settings_get_dither "gchar* gtk_print_settings_get_dither(GtkPrintSettings* settings)"
  Xen_check_type(Xen_is_GtkPrintSettings_(settings), settings, 1, "gtk_print_settings_get_dither", "GtkPrintSettings*");
  return(C_to_Xen_gchar_(gtk_print_settings_get_dither(Xen_to_C_GtkPrintSettings_(settings))));
}

static Xen gxg_gtk_print_settings_set_dither(Xen settings, Xen dither)
{
  #define H_gtk_print_settings_set_dither "void gtk_print_settings_set_dither(GtkPrintSettings* settings, \
gchar* dither)"
  Xen_check_type(Xen_is_GtkPrintSettings_(settings), settings, 1, "gtk_print_settings_set_dither", "GtkPrintSettings*");
  Xen_check_type(Xen_is_gchar_(dither), dither, 2, "gtk_print_settings_set_dither", "gchar*");
  gtk_print_settings_set_dither(Xen_to_C_GtkPrintSettings_(settings), Xen_to_C_gchar_(dither));
  return(Xen_false);
}

static Xen gxg_gtk_print_settings_get_finishings(Xen settings)
{
  #define H_gtk_print_settings_get_finishings "gchar* gtk_print_settings_get_finishings(GtkPrintSettings* settings)"
  Xen_check_type(Xen_is_GtkPrintSettings_(settings), settings, 1, "gtk_print_settings_get_finishings", "GtkPrintSettings*");
  return(C_to_Xen_gchar_(gtk_print_settings_get_finishings(Xen_to_C_GtkPrintSettings_(settings))));
}

static Xen gxg_gtk_print_settings_set_finishings(Xen settings, Xen finishings)
{
  #define H_gtk_print_settings_set_finishings "void gtk_print_settings_set_finishings(GtkPrintSettings* settings, \
gchar* finishings)"
  Xen_check_type(Xen_is_GtkPrintSettings_(settings), settings, 1, "gtk_print_settings_set_finishings", "GtkPrintSettings*");
  Xen_check_type(Xen_is_gchar_(finishings), finishings, 2, "gtk_print_settings_set_finishings", "gchar*");
  gtk_print_settings_set_finishings(Xen_to_C_GtkPrintSettings_(settings), Xen_to_C_gchar_(finishings));
  return(Xen_false);
}

static Xen gxg_gtk_print_settings_get_output_bin(Xen settings)
{
  #define H_gtk_print_settings_get_output_bin "gchar* gtk_print_settings_get_output_bin(GtkPrintSettings* settings)"
  Xen_check_type(Xen_is_GtkPrintSettings_(settings), settings, 1, "gtk_print_settings_get_output_bin", "GtkPrintSettings*");
  return(C_to_Xen_gchar_(gtk_print_settings_get_output_bin(Xen_to_C_GtkPrintSettings_(settings))));
}

static Xen gxg_gtk_print_settings_set_output_bin(Xen settings, Xen output_bin)
{
  #define H_gtk_print_settings_set_output_bin "void gtk_print_settings_set_output_bin(GtkPrintSettings* settings, \
gchar* output_bin)"
  Xen_check_type(Xen_is_GtkPrintSettings_(settings), settings, 1, "gtk_print_settings_set_output_bin", "GtkPrintSettings*");
  Xen_check_type(Xen_is_gchar_(output_bin), output_bin, 2, "gtk_print_settings_set_output_bin", "gchar*");
  gtk_print_settings_set_output_bin(Xen_to_C_GtkPrintSettings_(settings), Xen_to_C_gchar_(output_bin));
  return(Xen_false);
}

static Xen gxg_pango_cairo_create_layout(Xen cr)
{
  #define H_pango_cairo_create_layout "PangoLayout* pango_cairo_create_layout(cairo_t* cr)"
  Xen_check_type(Xen_is_cairo_t_(cr), cr, 1, "pango_cairo_create_layout", "cairo_t*");
  return(C_to_Xen_PangoLayout_(pango_cairo_create_layout(Xen_to_C_cairo_t_(cr))));
}

static Xen gxg_pango_cairo_update_layout(Xen cr, Xen layout)
{
  #define H_pango_cairo_update_layout "void pango_cairo_update_layout(cairo_t* cr, PangoLayout* layout)"
  Xen_check_type(Xen_is_cairo_t_(cr), cr, 1, "pango_cairo_update_layout", "cairo_t*");
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 2, "pango_cairo_update_layout", "PangoLayout*");
  pango_cairo_update_layout(Xen_to_C_cairo_t_(cr), Xen_to_C_PangoLayout_(layout));
  return(Xen_false);
}

static Xen gxg_pango_cairo_update_context(Xen cr, Xen context)
{
  #define H_pango_cairo_update_context "void pango_cairo_update_context(cairo_t* cr, PangoContext* context)"
  Xen_check_type(Xen_is_cairo_t_(cr), cr, 1, "pango_cairo_update_context", "cairo_t*");
  Xen_check_type(Xen_is_PangoContext_(context), context, 2, "pango_cairo_update_context", "PangoContext*");
  pango_cairo_update_context(Xen_to_C_cairo_t_(cr), Xen_to_C_PangoContext_(context));
  return(Xen_false);
}

static Xen gxg_pango_cairo_context_set_font_options(Xen context, Xen options)
{
  #define H_pango_cairo_context_set_font_options "void pango_cairo_context_set_font_options(PangoContext* context, \
cairo_font_options_t* options)"
  Xen_check_type(Xen_is_PangoContext_(context), context, 1, "pango_cairo_context_set_font_options", "PangoContext*");
  Xen_check_type(Xen_is_cairo_font_options_t_(options), options, 2, "pango_cairo_context_set_font_options", "cairo_font_options_t*");
  pango_cairo_context_set_font_options(Xen_to_C_PangoContext_(context), Xen_to_C_cairo_font_options_t_(options));
  return(Xen_false);
}

static Xen gxg_pango_cairo_context_get_font_options(Xen context)
{
  #define H_pango_cairo_context_get_font_options "cairo_font_options_t* pango_cairo_context_get_font_options(PangoContext* context)"
  Xen_check_type(Xen_is_PangoContext_(context), context, 1, "pango_cairo_context_get_font_options", "PangoContext*");
    return(C_to_Xen_cairo_font_options_t_((cairo_font_options_t*)pango_cairo_context_get_font_options(Xen_to_C_PangoContext_(context))));
}

static Xen gxg_pango_cairo_context_set_resolution(Xen context, Xen dpi)
{
  #define H_pango_cairo_context_set_resolution "void pango_cairo_context_set_resolution(PangoContext* context, \
gdouble dpi)"
  Xen_check_type(Xen_is_PangoContext_(context), context, 1, "pango_cairo_context_set_resolution", "PangoContext*");
  Xen_check_type(Xen_is_gdouble(dpi), dpi, 2, "pango_cairo_context_set_resolution", "gdouble");
  pango_cairo_context_set_resolution(Xen_to_C_PangoContext_(context), Xen_to_C_gdouble(dpi));
  return(Xen_false);
}

static Xen gxg_pango_cairo_context_get_resolution(Xen context)
{
  #define H_pango_cairo_context_get_resolution "gdouble pango_cairo_context_get_resolution(PangoContext* context)"
  Xen_check_type(Xen_is_PangoContext_(context), context, 1, "pango_cairo_context_get_resolution", "PangoContext*");
  return(C_to_Xen_gdouble(pango_cairo_context_get_resolution(Xen_to_C_PangoContext_(context))));
}

static Xen gxg_pango_cairo_show_glyph_string(Xen cr, Xen font, Xen glyphs)
{
  #define H_pango_cairo_show_glyph_string "void pango_cairo_show_glyph_string(cairo_t* cr, PangoFont* font, \
PangoGlyphString* glyphs)"
  Xen_check_type(Xen_is_cairo_t_(cr), cr, 1, "pango_cairo_show_glyph_string", "cairo_t*");
  Xen_check_type(Xen_is_PangoFont_(font), font, 2, "pango_cairo_show_glyph_string", "PangoFont*");
  Xen_check_type(Xen_is_PangoGlyphString_(glyphs), glyphs, 3, "pango_cairo_show_glyph_string", "PangoGlyphString*");
  pango_cairo_show_glyph_string(Xen_to_C_cairo_t_(cr), Xen_to_C_PangoFont_(font), Xen_to_C_PangoGlyphString_(glyphs));
  return(Xen_false);
}

static Xen gxg_pango_cairo_show_layout_line(Xen cr, Xen line)
{
  #define H_pango_cairo_show_layout_line "void pango_cairo_show_layout_line(cairo_t* cr, PangoLayoutLine* line)"
  Xen_check_type(Xen_is_cairo_t_(cr), cr, 1, "pango_cairo_show_layout_line", "cairo_t*");
  Xen_check_type(Xen_is_PangoLayoutLine_(line), line, 2, "pango_cairo_show_layout_line", "PangoLayoutLine*");
  pango_cairo_show_layout_line(Xen_to_C_cairo_t_(cr), Xen_to_C_PangoLayoutLine_(line));
  return(Xen_false);
}

static Xen gxg_pango_cairo_show_layout(Xen cr, Xen layout)
{
  #define H_pango_cairo_show_layout "void pango_cairo_show_layout(cairo_t* cr, PangoLayout* layout)"
  Xen_check_type(Xen_is_cairo_t_(cr), cr, 1, "pango_cairo_show_layout", "cairo_t*");
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 2, "pango_cairo_show_layout", "PangoLayout*");
  pango_cairo_show_layout(Xen_to_C_cairo_t_(cr), Xen_to_C_PangoLayout_(layout));
  return(Xen_false);
}

static Xen gxg_pango_cairo_show_error_underline(Xen cr, Xen x, Xen y, Xen width, Xen height)
{
  #define H_pango_cairo_show_error_underline "void pango_cairo_show_error_underline(cairo_t* cr, gdouble x, \
gdouble y, gdouble width, gdouble height)"
  Xen_check_type(Xen_is_cairo_t_(cr), cr, 1, "pango_cairo_show_error_underline", "cairo_t*");
  Xen_check_type(Xen_is_gdouble(x), x, 2, "pango_cairo_show_error_underline", "gdouble");
  Xen_check_type(Xen_is_gdouble(y), y, 3, "pango_cairo_show_error_underline", "gdouble");
  Xen_check_type(Xen_is_gdouble(width), width, 4, "pango_cairo_show_error_underline", "gdouble");
  Xen_check_type(Xen_is_gdouble(height), height, 5, "pango_cairo_show_error_underline", "gdouble");
  pango_cairo_show_error_underline(Xen_to_C_cairo_t_(cr), Xen_to_C_gdouble(x), Xen_to_C_gdouble(y), Xen_to_C_gdouble(width), 
                                   Xen_to_C_gdouble(height));
  return(Xen_false);
}

static Xen gxg_pango_cairo_glyph_string_path(Xen cr, Xen font, Xen glyphs)
{
  #define H_pango_cairo_glyph_string_path "void pango_cairo_glyph_string_path(cairo_t* cr, PangoFont* font, \
PangoGlyphString* glyphs)"
  Xen_check_type(Xen_is_cairo_t_(cr), cr, 1, "pango_cairo_glyph_string_path", "cairo_t*");
  Xen_check_type(Xen_is_PangoFont_(font), font, 2, "pango_cairo_glyph_string_path", "PangoFont*");
  Xen_check_type(Xen_is_PangoGlyphString_(glyphs), glyphs, 3, "pango_cairo_glyph_string_path", "PangoGlyphString*");
  pango_cairo_glyph_string_path(Xen_to_C_cairo_t_(cr), Xen_to_C_PangoFont_(font), Xen_to_C_PangoGlyphString_(glyphs));
  return(Xen_false);
}

static Xen gxg_pango_cairo_layout_line_path(Xen cr, Xen line)
{
  #define H_pango_cairo_layout_line_path "void pango_cairo_layout_line_path(cairo_t* cr, PangoLayoutLine* line)"
  Xen_check_type(Xen_is_cairo_t_(cr), cr, 1, "pango_cairo_layout_line_path", "cairo_t*");
  Xen_check_type(Xen_is_PangoLayoutLine_(line), line, 2, "pango_cairo_layout_line_path", "PangoLayoutLine*");
  pango_cairo_layout_line_path(Xen_to_C_cairo_t_(cr), Xen_to_C_PangoLayoutLine_(line));
  return(Xen_false);
}

static Xen gxg_pango_cairo_layout_path(Xen cr, Xen layout)
{
  #define H_pango_cairo_layout_path "void pango_cairo_layout_path(cairo_t* cr, PangoLayout* layout)"
  Xen_check_type(Xen_is_cairo_t_(cr), cr, 1, "pango_cairo_layout_path", "cairo_t*");
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 2, "pango_cairo_layout_path", "PangoLayout*");
  pango_cairo_layout_path(Xen_to_C_cairo_t_(cr), Xen_to_C_PangoLayout_(layout));
  return(Xen_false);
}

static Xen gxg_pango_cairo_error_underline_path(Xen cr, Xen x, Xen y, Xen width, Xen height)
{
  #define H_pango_cairo_error_underline_path "void pango_cairo_error_underline_path(cairo_t* cr, gdouble x, \
gdouble y, gdouble width, gdouble height)"
  Xen_check_type(Xen_is_cairo_t_(cr), cr, 1, "pango_cairo_error_underline_path", "cairo_t*");
  Xen_check_type(Xen_is_gdouble(x), x, 2, "pango_cairo_error_underline_path", "gdouble");
  Xen_check_type(Xen_is_gdouble(y), y, 3, "pango_cairo_error_underline_path", "gdouble");
  Xen_check_type(Xen_is_gdouble(width), width, 4, "pango_cairo_error_underline_path", "gdouble");
  Xen_check_type(Xen_is_gdouble(height), height, 5, "pango_cairo_error_underline_path", "gdouble");
  pango_cairo_error_underline_path(Xen_to_C_cairo_t_(cr), Xen_to_C_gdouble(x), Xen_to_C_gdouble(y), Xen_to_C_gdouble(width), 
                                   Xen_to_C_gdouble(height));
  return(Xen_false);
}

static Xen gxg_gdk_cairo_set_source_pixbuf(Xen cr, Xen pixbuf, Xen pixbuf_x, Xen pixbuf_y)
{
  #define H_gdk_cairo_set_source_pixbuf "void gdk_cairo_set_source_pixbuf(cairo_t* cr, GdkPixbuf* pixbuf, \
gdouble pixbuf_x, gdouble pixbuf_y)"
  Xen_check_type(Xen_is_cairo_t_(cr), cr, 1, "gdk_cairo_set_source_pixbuf", "cairo_t*");
  Xen_check_type(Xen_is_GdkPixbuf_(pixbuf), pixbuf, 2, "gdk_cairo_set_source_pixbuf", "GdkPixbuf*");
  Xen_check_type(Xen_is_gdouble(pixbuf_x), pixbuf_x, 3, "gdk_cairo_set_source_pixbuf", "gdouble");
  Xen_check_type(Xen_is_gdouble(pixbuf_y), pixbuf_y, 4, "gdk_cairo_set_source_pixbuf", "gdouble");
  gdk_cairo_set_source_pixbuf(Xen_to_C_cairo_t_(cr), Xen_to_C_GdkPixbuf_(pixbuf), Xen_to_C_gdouble(pixbuf_x), Xen_to_C_gdouble(pixbuf_y));
  return(Xen_false);
}

static Xen gxg_gdk_cairo_rectangle(Xen cr, Xen rectangle)
{
  #define H_gdk_cairo_rectangle "void gdk_cairo_rectangle(cairo_t* cr, GdkRectangle* rectangle)"
  Xen_check_type(Xen_is_cairo_t_(cr), cr, 1, "gdk_cairo_rectangle", "cairo_t*");
  Xen_check_type(Xen_is_GdkRectangle_(rectangle), rectangle, 2, "gdk_cairo_rectangle", "GdkRectangle*");
  gdk_cairo_rectangle(Xen_to_C_cairo_t_(cr), Xen_to_C_GdkRectangle_(rectangle));
  return(Xen_false);
}

static Xen gxg_gtk_cell_layout_get_cells(Xen cell_layout)
{
  #define H_gtk_cell_layout_get_cells "GList* gtk_cell_layout_get_cells(GtkCellLayout* cell_layout)"
  Xen_check_type(Xen_is_GtkCellLayout_(cell_layout), cell_layout, 1, "gtk_cell_layout_get_cells", "GtkCellLayout*");
  return(C_to_Xen_GList_(gtk_cell_layout_get_cells(Xen_to_C_GtkCellLayout_(cell_layout))));
}

static Xen gxg_gtk_entry_completion_set_inline_selection(Xen completion, Xen inline_selection)
{
  #define H_gtk_entry_completion_set_inline_selection "void gtk_entry_completion_set_inline_selection(GtkEntryCompletion* completion, \
gboolean inline_selection)"
  Xen_check_type(Xen_is_GtkEntryCompletion_(completion), completion, 1, "gtk_entry_completion_set_inline_selection", "GtkEntryCompletion*");
  Xen_check_type(Xen_is_gboolean(inline_selection), inline_selection, 2, "gtk_entry_completion_set_inline_selection", "gboolean");
  gtk_entry_completion_set_inline_selection(Xen_to_C_GtkEntryCompletion_(completion), Xen_to_C_gboolean(inline_selection));
  return(Xen_false);
}

static Xen gxg_gtk_entry_completion_get_inline_selection(Xen completion)
{
  #define H_gtk_entry_completion_get_inline_selection "gboolean gtk_entry_completion_get_inline_selection(GtkEntryCompletion* completion)"
  Xen_check_type(Xen_is_GtkEntryCompletion_(completion), completion, 1, "gtk_entry_completion_get_inline_selection", "GtkEntryCompletion*");
  return(C_to_Xen_gboolean(gtk_entry_completion_get_inline_selection(Xen_to_C_GtkEntryCompletion_(completion))));
}

static Xen gxg_gtk_entry_completion_get_completion_prefix(Xen completion)
{
  #define H_gtk_entry_completion_get_completion_prefix "gchar* gtk_entry_completion_get_completion_prefix(GtkEntryCompletion* completion)"
  Xen_check_type(Xen_is_GtkEntryCompletion_(completion), completion, 1, "gtk_entry_completion_get_completion_prefix", "GtkEntryCompletion*");
  return(C_to_Xen_gchar_(gtk_entry_completion_get_completion_prefix(Xen_to_C_GtkEntryCompletion_(completion))));
}

static Xen gxg_gtk_print_settings_new_from_file(Xen file_name, Xen ignore_error)
{
  #define H_gtk_print_settings_new_from_file "GtkPrintSettings* gtk_print_settings_new_from_file(gchar* file_name, \
GError** [error])"
  GError* ref_error = NULL;
  Xen_check_type(Xen_is_gchar_(file_name), file_name, 1, "gtk_print_settings_new_from_file", "gchar*");
  {
    Xen res_ult;
    res_ult = C_to_Xen_GtkPrintSettings_(gtk_print_settings_new_from_file(Xen_to_C_gchar_(file_name), &ref_error));
    return(Xen_list_2(res_ult, C_to_Xen_GError_(ref_error)));
   }
}

static Xen gxg_gtk_print_settings_to_file(Xen settings, Xen file_name, Xen ignore_error)
{
  #define H_gtk_print_settings_to_file "gboolean gtk_print_settings_to_file(GtkPrintSettings* settings, \
gchar* file_name, GError** [error])"
  GError* ref_error = NULL;
  Xen_check_type(Xen_is_GtkPrintSettings_(settings), settings, 1, "gtk_print_settings_to_file", "GtkPrintSettings*");
  Xen_check_type(Xen_is_gchar_(file_name), file_name, 2, "gtk_print_settings_to_file", "gchar*");
  {
    Xen res_ult;
    res_ult = C_to_Xen_gboolean(gtk_print_settings_to_file(Xen_to_C_GtkPrintSettings_(settings), Xen_to_C_gchar_(file_name), 
                                                           &ref_error));
    return(Xen_list_2(res_ult, C_to_Xen_GError_(ref_error)));
   }
}

static Xen gxg_gtk_range_set_show_fill_level(Xen range, Xen show_fill_level)
{
  #define H_gtk_range_set_show_fill_level "void gtk_range_set_show_fill_level(GtkRange* range,  gboolean, \
show_fill_level)"
  Xen_check_type(Xen_is_GtkRange_(range), range, 1, "gtk_range_set_show_fill_level", "GtkRange*");
  Xen_check_type(Xen_is_gboolean(show_fill_level), show_fill_level, 2, "gtk_range_set_show_fill_level", "gboolean");
  gtk_range_set_show_fill_level(Xen_to_C_GtkRange_(range), Xen_to_C_gboolean(show_fill_level));
  return(Xen_false);
}

static Xen gxg_gtk_range_get_show_fill_level(Xen range)
{
  #define H_gtk_range_get_show_fill_level "gboolean gtk_range_get_show_fill_level(GtkRange* range)"
  Xen_check_type(Xen_is_GtkRange_(range), range, 1, "gtk_range_get_show_fill_level", "GtkRange*");
  return(C_to_Xen_gboolean(gtk_range_get_show_fill_level(Xen_to_C_GtkRange_(range))));
}

static Xen gxg_gtk_range_set_restrict_to_fill_level(Xen range, Xen restrict_to_fill_level)
{
  #define H_gtk_range_set_restrict_to_fill_level "void gtk_range_set_restrict_to_fill_level(GtkRange* range, \
 gboolean, restrict_to_fill_level)"
  Xen_check_type(Xen_is_GtkRange_(range), range, 1, "gtk_range_set_restrict_to_fill_level", "GtkRange*");
  Xen_check_type(Xen_is_gboolean(restrict_to_fill_level), restrict_to_fill_level, 2, "gtk_range_set_restrict_to_fill_level", "gboolean");
  gtk_range_set_restrict_to_fill_level(Xen_to_C_GtkRange_(range), Xen_to_C_gboolean(restrict_to_fill_level));
  return(Xen_false);
}

static Xen gxg_gtk_range_get_restrict_to_fill_level(Xen range)
{
  #define H_gtk_range_get_restrict_to_fill_level "gboolean gtk_range_get_restrict_to_fill_level(GtkRange* range)"
  Xen_check_type(Xen_is_GtkRange_(range), range, 1, "gtk_range_get_restrict_to_fill_level", "GtkRange*");
  return(C_to_Xen_gboolean(gtk_range_get_restrict_to_fill_level(Xen_to_C_GtkRange_(range))));
}

static Xen gxg_gtk_range_set_fill_level(Xen range, Xen fill_level)
{
  #define H_gtk_range_set_fill_level "void gtk_range_set_fill_level(GtkRange* range,  gdouble, fill_level)"
  Xen_check_type(Xen_is_GtkRange_(range), range, 1, "gtk_range_set_fill_level", "GtkRange*");
  Xen_check_type(Xen_is_gdouble(fill_level), fill_level, 2, "gtk_range_set_fill_level", "gdouble");
  gtk_range_set_fill_level(Xen_to_C_GtkRange_(range), Xen_to_C_gdouble(fill_level));
  return(Xen_false);
}

static Xen gxg_gtk_range_get_fill_level(Xen range)
{
  #define H_gtk_range_get_fill_level "gdouble gtk_range_get_fill_level(GtkRange* range)"
  Xen_check_type(Xen_is_GtkRange_(range), range, 1, "gtk_range_get_fill_level", "GtkRange*");
  return(C_to_Xen_gdouble(gtk_range_get_fill_level(Xen_to_C_GtkRange_(range))));
}

static Xen gxg_gtk_tree_view_set_show_expanders(Xen tree_view, Xen enabled)
{
  #define H_gtk_tree_view_set_show_expanders "void gtk_tree_view_set_show_expanders(GtkTreeView* tree_view, \
gboolean enabled)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_set_show_expanders", "GtkTreeView*");
  Xen_check_type(Xen_is_gboolean(enabled), enabled, 2, "gtk_tree_view_set_show_expanders", "gboolean");
  gtk_tree_view_set_show_expanders(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_gboolean(enabled));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_get_show_expanders(Xen tree_view)
{
  #define H_gtk_tree_view_get_show_expanders "gboolean gtk_tree_view_get_show_expanders(GtkTreeView* tree_view)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_get_show_expanders", "GtkTreeView*");
  return(C_to_Xen_gboolean(gtk_tree_view_get_show_expanders(Xen_to_C_GtkTreeView_(tree_view))));
}

static Xen gxg_gtk_tree_view_set_level_indentation(Xen tree_view, Xen indentation)
{
  #define H_gtk_tree_view_set_level_indentation "void gtk_tree_view_set_level_indentation(GtkTreeView* tree_view, \
gint indentation)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_set_level_indentation", "GtkTreeView*");
  Xen_check_type(Xen_is_gint(indentation), indentation, 2, "gtk_tree_view_set_level_indentation", "gint");
  gtk_tree_view_set_level_indentation(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_gint(indentation));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_get_level_indentation(Xen tree_view)
{
  #define H_gtk_tree_view_get_level_indentation "gint gtk_tree_view_get_level_indentation(GtkTreeView* tree_view)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_get_level_indentation", "GtkTreeView*");
  return(C_to_Xen_gint(gtk_tree_view_get_level_indentation(Xen_to_C_GtkTreeView_(tree_view))));
}

static Xen gxg_gtk_widget_keynav_failed(Xen widget, Xen direction)
{
  #define H_gtk_widget_keynav_failed "gboolean gtk_widget_keynav_failed(GtkWidget* widget, GtkDirectionType direction)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_keynav_failed", "GtkWidget*");
  Xen_check_type(Xen_is_GtkDirectionType(direction), direction, 2, "gtk_widget_keynav_failed", "GtkDirectionType");
  return(C_to_Xen_gboolean(gtk_widget_keynav_failed(Xen_to_C_GtkWidget_(widget), Xen_to_C_GtkDirectionType(direction))));
}

static Xen gxg_gtk_widget_error_bell(Xen widget)
{
  #define H_gtk_widget_error_bell "void gtk_widget_error_bell(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_error_bell", "GtkWidget*");
  gtk_widget_error_bell(Xen_to_C_GtkWidget_(widget));
  return(Xen_false);
}

static Xen gxg_gtk_widget_trigger_tooltip_query(Xen widget)
{
  #define H_gtk_widget_trigger_tooltip_query "void gtk_widget_trigger_tooltip_query(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_trigger_tooltip_query", "GtkWidget*");
  gtk_widget_trigger_tooltip_query(Xen_to_C_GtkWidget_(widget));
  return(Xen_false);
}

static Xen gxg_gtk_window_set_startup_id(Xen window, Xen startup_id)
{
  #define H_gtk_window_set_startup_id "void gtk_window_set_startup_id(GtkWindow* window, gchar* startup_id)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_set_startup_id", "GtkWindow*");
  Xen_check_type(Xen_is_gchar_(startup_id), startup_id, 2, "gtk_window_set_startup_id", "gchar*");
  gtk_window_set_startup_id(Xen_to_C_GtkWindow_(window), Xen_to_C_gchar_(startup_id));
  return(Xen_false);
}

static Xen gxg_gtk_text_buffer_add_mark(Xen buffer, Xen mark, Xen where)
{
  #define H_gtk_text_buffer_add_mark "void gtk_text_buffer_add_mark(GtkTextBuffer* buffer, GtkTextMark* mark, \
GtkTextIter* where)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_add_mark", "GtkTextBuffer*");
  Xen_check_type(Xen_is_GtkTextMark_(mark), mark, 2, "gtk_text_buffer_add_mark", "GtkTextMark*");
  Xen_check_type(Xen_is_GtkTextIter_(where), where, 3, "gtk_text_buffer_add_mark", "GtkTextIter*");
  gtk_text_buffer_add_mark(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_GtkTextMark_(mark), Xen_to_C_GtkTextIter_(where));
  return(Xen_false);
}

static Xen gxg_gtk_text_mark_new(Xen name, Xen left_gravity)
{
  #define H_gtk_text_mark_new "GtkTextMark* gtk_text_mark_new(gchar* name, gboolean left_gravity)"
  Xen_check_type(Xen_is_gchar_(name), name, 1, "gtk_text_mark_new", "gchar*");
  Xen_check_type(Xen_is_gboolean(left_gravity), left_gravity, 2, "gtk_text_mark_new", "gboolean");
  return(C_to_Xen_GtkTextMark_(gtk_text_mark_new(Xen_to_C_gchar_(name), Xen_to_C_gboolean(left_gravity))));
}

static Xen gxg_gtk_tree_view_column_get_tree_view(Xen tree_column)
{
  #define H_gtk_tree_view_column_get_tree_view "GtkWidget* gtk_tree_view_column_get_tree_view(GtkTreeViewColumn* tree_column)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_get_tree_view", "GtkTreeViewColumn*");
  return(C_to_Xen_GtkWidget_(gtk_tree_view_column_get_tree_view(Xen_to_C_GtkTreeViewColumn_(tree_column))));
}

static Xen gxg_gtk_tooltip_set_text(Xen tooltip, Xen text)
{
  #define H_gtk_tooltip_set_text "void gtk_tooltip_set_text(GtkTooltip* tooltip, gchar* text)"
  Xen_check_type(Xen_is_GtkTooltip_(tooltip), tooltip, 1, "gtk_tooltip_set_text", "GtkTooltip*");
  Xen_check_type(Xen_is_gchar_(text), text, 2, "gtk_tooltip_set_text", "gchar*");
  gtk_tooltip_set_text(Xen_to_C_GtkTooltip_(tooltip), (const gchar*)Xen_to_C_gchar_(text));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_convert_widget_to_tree_coords(Xen tree_view, Xen wx, Xen wy, Xen ignore_tx, Xen ignore_ty)
{
  #define H_gtk_tree_view_convert_widget_to_tree_coords "void gtk_tree_view_convert_widget_to_tree_coords(GtkTreeView* tree_view, \
gint wx, gint wy, gint* [tx], gint* [ty])"
  gint ref_tx;
  gint ref_ty;
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_convert_widget_to_tree_coords", "GtkTreeView*");
  Xen_check_type(Xen_is_gint(wx), wx, 2, "gtk_tree_view_convert_widget_to_tree_coords", "gint");
  Xen_check_type(Xen_is_gint(wy), wy, 3, "gtk_tree_view_convert_widget_to_tree_coords", "gint");
  gtk_tree_view_convert_widget_to_tree_coords(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_gint(wx), Xen_to_C_gint(wy), &ref_tx, 
                                              &ref_ty);
  return(Xen_list_2(C_to_Xen_gint(ref_tx), C_to_Xen_gint(ref_ty)));
}

static Xen gxg_gtk_tree_view_convert_tree_to_widget_coords(Xen tree_view, Xen tx, Xen ty, Xen ignore_wx, Xen ignore_wy)
{
  #define H_gtk_tree_view_convert_tree_to_widget_coords "void gtk_tree_view_convert_tree_to_widget_coords(GtkTreeView* tree_view, \
gint tx, gint ty, gint* [wx], gint* [wy])"
  gint ref_wx;
  gint ref_wy;
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_convert_tree_to_widget_coords", "GtkTreeView*");
  Xen_check_type(Xen_is_gint(tx), tx, 2, "gtk_tree_view_convert_tree_to_widget_coords", "gint");
  Xen_check_type(Xen_is_gint(ty), ty, 3, "gtk_tree_view_convert_tree_to_widget_coords", "gint");
  gtk_tree_view_convert_tree_to_widget_coords(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_gint(tx), Xen_to_C_gint(ty), &ref_wx, 
                                              &ref_wy);
  return(Xen_list_2(C_to_Xen_gint(ref_wx), C_to_Xen_gint(ref_wy)));
}

static Xen gxg_gtk_tree_view_convert_widget_to_bin_window_coords(Xen tree_view, Xen wx, Xen wy, Xen ignore_bx, Xen ignore_by)
{
  #define H_gtk_tree_view_convert_widget_to_bin_window_coords "void gtk_tree_view_convert_widget_to_bin_window_coords(GtkTreeView* tree_view, \
gint wx, gint wy, gint* [bx], gint* [by])"
  gint ref_bx;
  gint ref_by;
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_convert_widget_to_bin_window_coords", "GtkTreeView*");
  Xen_check_type(Xen_is_gint(wx), wx, 2, "gtk_tree_view_convert_widget_to_bin_window_coords", "gint");
  Xen_check_type(Xen_is_gint(wy), wy, 3, "gtk_tree_view_convert_widget_to_bin_window_coords", "gint");
  gtk_tree_view_convert_widget_to_bin_window_coords(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_gint(wx), Xen_to_C_gint(wy), 
                                                    &ref_bx, &ref_by);
  return(Xen_list_2(C_to_Xen_gint(ref_bx), C_to_Xen_gint(ref_by)));
}

static Xen gxg_gtk_tree_view_convert_bin_window_to_widget_coords(Xen tree_view, Xen bx, Xen by, Xen ignore_wx, Xen ignore_wy)
{
  #define H_gtk_tree_view_convert_bin_window_to_widget_coords "void gtk_tree_view_convert_bin_window_to_widget_coords(GtkTreeView* tree_view, \
gint bx, gint by, gint* [wx], gint* [wy])"
  gint ref_wx;
  gint ref_wy;
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_convert_bin_window_to_widget_coords", "GtkTreeView*");
  Xen_check_type(Xen_is_gint(bx), bx, 2, "gtk_tree_view_convert_bin_window_to_widget_coords", "gint");
  Xen_check_type(Xen_is_gint(by), by, 3, "gtk_tree_view_convert_bin_window_to_widget_coords", "gint");
  gtk_tree_view_convert_bin_window_to_widget_coords(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_gint(bx), Xen_to_C_gint(by), 
                                                    &ref_wx, &ref_wy);
  return(Xen_list_2(C_to_Xen_gint(ref_wx), C_to_Xen_gint(ref_wy)));
}

static Xen gxg_gtk_tree_view_convert_tree_to_bin_window_coords(Xen tree_view, Xen tx, Xen ty, Xen ignore_bx, Xen ignore_by)
{
  #define H_gtk_tree_view_convert_tree_to_bin_window_coords "void gtk_tree_view_convert_tree_to_bin_window_coords(GtkTreeView* tree_view, \
gint tx, gint ty, gint* [bx], gint* [by])"
  gint ref_bx;
  gint ref_by;
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_convert_tree_to_bin_window_coords", "GtkTreeView*");
  Xen_check_type(Xen_is_gint(tx), tx, 2, "gtk_tree_view_convert_tree_to_bin_window_coords", "gint");
  Xen_check_type(Xen_is_gint(ty), ty, 3, "gtk_tree_view_convert_tree_to_bin_window_coords", "gint");
  gtk_tree_view_convert_tree_to_bin_window_coords(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_gint(tx), Xen_to_C_gint(ty), 
                                                  &ref_bx, &ref_by);
  return(Xen_list_2(C_to_Xen_gint(ref_bx), C_to_Xen_gint(ref_by)));
}

static Xen gxg_gtk_tree_view_convert_bin_window_to_tree_coords(Xen tree_view, Xen bx, Xen by, Xen ignore_tx, Xen ignore_ty)
{
  #define H_gtk_tree_view_convert_bin_window_to_tree_coords "void gtk_tree_view_convert_bin_window_to_tree_coords(GtkTreeView* tree_view, \
gint bx, gint by, gint* [tx], gint* [ty])"
  gint ref_tx;
  gint ref_ty;
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_convert_bin_window_to_tree_coords", "GtkTreeView*");
  Xen_check_type(Xen_is_gint(bx), bx, 2, "gtk_tree_view_convert_bin_window_to_tree_coords", "gint");
  Xen_check_type(Xen_is_gint(by), by, 3, "gtk_tree_view_convert_bin_window_to_tree_coords", "gint");
  gtk_tree_view_convert_bin_window_to_tree_coords(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_gint(bx), Xen_to_C_gint(by), 
                                                  &ref_tx, &ref_ty);
  return(Xen_list_2(C_to_Xen_gint(ref_tx), C_to_Xen_gint(ref_ty)));
}

static Xen gxg_gtk_widget_set_tooltip_text(Xen widget, Xen text)
{
  #define H_gtk_widget_set_tooltip_text "void gtk_widget_set_tooltip_text(GtkWidget* widget, gchar* text)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_set_tooltip_text", "GtkWidget*");
  Xen_check_type(Xen_is_gchar_(text), text, 2, "gtk_widget_set_tooltip_text", "gchar*");
  gtk_widget_set_tooltip_text(Xen_to_C_GtkWidget_(widget), (const gchar*)Xen_to_C_gchar_(text));
  return(Xen_false);
}

static Xen gxg_gtk_widget_get_tooltip_text(Xen widget)
{
  #define H_gtk_widget_get_tooltip_text "gchar* gtk_widget_get_tooltip_text(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_get_tooltip_text", "GtkWidget*");
  return(C_to_Xen_gchar_(gtk_widget_get_tooltip_text(Xen_to_C_GtkWidget_(widget))));
}

static Xen gxg_gtk_widget_set_tooltip_markup(Xen widget, Xen markup)
{
  #define H_gtk_widget_set_tooltip_markup "void gtk_widget_set_tooltip_markup(GtkWidget* widget, gchar* markup)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_set_tooltip_markup", "GtkWidget*");
  Xen_check_type(Xen_is_gchar_(markup), markup, 2, "gtk_widget_set_tooltip_markup", "gchar*");
  gtk_widget_set_tooltip_markup(Xen_to_C_GtkWidget_(widget), (const gchar*)Xen_to_C_gchar_(markup));
  return(Xen_false);
}

static Xen gxg_gtk_widget_get_tooltip_markup(Xen widget)
{
  #define H_gtk_widget_get_tooltip_markup "gchar* gtk_widget_get_tooltip_markup(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_get_tooltip_markup", "GtkWidget*");
  return(C_to_Xen_gchar_(gtk_widget_get_tooltip_markup(Xen_to_C_GtkWidget_(widget))));
}

static Xen gxg_gtk_tree_view_is_rubber_banding_active(Xen tree_view)
{
  #define H_gtk_tree_view_is_rubber_banding_active "gboolean gtk_tree_view_is_rubber_banding_active(GtkTreeView* tree_view)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_is_rubber_banding_active", "GtkTreeView*");
  return(C_to_Xen_gboolean(gtk_tree_view_is_rubber_banding_active(Xen_to_C_GtkTreeView_(tree_view))));
}

static Xen gxg_gtk_icon_view_set_tooltip_item(Xen icon_view, Xen tooltip, Xen path)
{
  #define H_gtk_icon_view_set_tooltip_item "void gtk_icon_view_set_tooltip_item(GtkIconView* icon_view, \
GtkTooltip* tooltip, GtkTreePath* path)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_set_tooltip_item", "GtkIconView*");
  Xen_check_type(Xen_is_GtkTooltip_(tooltip), tooltip, 2, "gtk_icon_view_set_tooltip_item", "GtkTooltip*");
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 3, "gtk_icon_view_set_tooltip_item", "GtkTreePath*");
  gtk_icon_view_set_tooltip_item(Xen_to_C_GtkIconView_(icon_view), Xen_to_C_GtkTooltip_(tooltip), Xen_to_C_GtkTreePath_(path));
  return(Xen_false);
}

static Xen gxg_gtk_icon_view_set_tooltip_cell(Xen icon_view, Xen tooltip, Xen path, Xen cell)
{
  #define H_gtk_icon_view_set_tooltip_cell "void gtk_icon_view_set_tooltip_cell(GtkIconView* icon_view, \
GtkTooltip* tooltip, GtkTreePath* path, GtkCellRenderer* cell)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_set_tooltip_cell", "GtkIconView*");
  Xen_check_type(Xen_is_GtkTooltip_(tooltip), tooltip, 2, "gtk_icon_view_set_tooltip_cell", "GtkTooltip*");
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 3, "gtk_icon_view_set_tooltip_cell", "GtkTreePath*");
  Xen_check_type(Xen_is_GtkCellRenderer_(cell), cell, 4, "gtk_icon_view_set_tooltip_cell", "GtkCellRenderer*");
  gtk_icon_view_set_tooltip_cell(Xen_to_C_GtkIconView_(icon_view), Xen_to_C_GtkTooltip_(tooltip), Xen_to_C_GtkTreePath_(path), 
                                 Xen_to_C_GtkCellRenderer_(cell));
  return(Xen_false);
}

static Xen gxg_gtk_icon_view_get_tooltip_context(Xen icon_view, Xen ignore_x, Xen ignore_y, Xen keyboard_tip, Xen ignore_model, Xen ignore_path, Xen iter)
{
  #define H_gtk_icon_view_get_tooltip_context "gboolean gtk_icon_view_get_tooltip_context(GtkIconView* icon_view, \
gint* [x], gint* [y], gboolean keyboard_tip, GtkTreeModel** [model], GtkTreePath** [path], GtkTreeIter* iter)"
  gint ref_x;
  gint ref_y;
  GtkTreeModel* ref_model = NULL;
  GtkTreePath* ref_path = NULL;
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_get_tooltip_context", "GtkIconView*");
  Xen_check_type(Xen_is_gboolean(keyboard_tip), keyboard_tip, 4, "gtk_icon_view_get_tooltip_context", "gboolean");
  Xen_check_type(Xen_is_GtkTreeIter_(iter) || Xen_is_false(iter), iter, 7, "gtk_icon_view_get_tooltip_context", "GtkTreeIter*");
  {
    Xen res_ult;
    res_ult = C_to_Xen_gboolean(gtk_icon_view_get_tooltip_context(Xen_to_C_GtkIconView_(icon_view), &ref_x, &ref_y, Xen_to_C_gboolean(keyboard_tip), 
                                                                  &ref_model, &ref_path, Xen_to_C_GtkTreeIter_(iter)));
    return(Xen_list_5(res_ult, C_to_Xen_gint(ref_x), C_to_Xen_gint(ref_y), C_to_Xen_GtkTreeModel_(ref_model), C_to_Xen_GtkTreePath_(ref_path)));
   }
}

static Xen gxg_gtk_icon_view_set_tooltip_column(Xen icon_view, Xen column)
{
  #define H_gtk_icon_view_set_tooltip_column "void gtk_icon_view_set_tooltip_column(GtkIconView* icon_view, \
gint column)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_set_tooltip_column", "GtkIconView*");
  Xen_check_type(Xen_is_gint(column), column, 2, "gtk_icon_view_set_tooltip_column", "gint");
  gtk_icon_view_set_tooltip_column(Xen_to_C_GtkIconView_(icon_view), Xen_to_C_gint(column));
  return(Xen_false);
}

static Xen gxg_gtk_icon_view_get_tooltip_column(Xen icon_view )
{
  #define H_gtk_icon_view_get_tooltip_column "gint gtk_icon_view_get_tooltip_column(GtkIconView* icon_view, \
)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view ), icon_view , 1, "gtk_icon_view_get_tooltip_column", "GtkIconView*");
  return(C_to_Xen_gint(gtk_icon_view_get_tooltip_column(Xen_to_C_GtkIconView_(icon_view ))));
}

static Xen gxg_gtk_tooltip_set_tip_area(Xen tooltip, Xen rect)
{
  #define H_gtk_tooltip_set_tip_area "void gtk_tooltip_set_tip_area(GtkTooltip* tooltip, GdkRectangle* rect)"
  Xen_check_type(Xen_is_GtkTooltip_(tooltip), tooltip, 1, "gtk_tooltip_set_tip_area", "GtkTooltip*");
  Xen_check_type(Xen_is_GdkRectangle_(rect), rect, 2, "gtk_tooltip_set_tip_area", "GdkRectangle*");
  gtk_tooltip_set_tip_area(Xen_to_C_GtkTooltip_(tooltip), Xen_to_C_GdkRectangle_(rect));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_set_tooltip_row(Xen tree_view, Xen tooltip, Xen path)
{
  #define H_gtk_tree_view_set_tooltip_row "void gtk_tree_view_set_tooltip_row(GtkTreeView* tree_view, \
GtkTooltip* tooltip, GtkTreePath* path)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_set_tooltip_row", "GtkTreeView*");
  Xen_check_type(Xen_is_GtkTooltip_(tooltip), tooltip, 2, "gtk_tree_view_set_tooltip_row", "GtkTooltip*");
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 3, "gtk_tree_view_set_tooltip_row", "GtkTreePath*");
  gtk_tree_view_set_tooltip_row(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_GtkTooltip_(tooltip), Xen_to_C_GtkTreePath_(path));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_set_tooltip_cell(Xen tree_view, Xen tooltip, Xen path, Xen column, Xen cell)
{
  #define H_gtk_tree_view_set_tooltip_cell "void gtk_tree_view_set_tooltip_cell(GtkTreeView* tree_view, \
GtkTooltip* tooltip, GtkTreePath* path, GtkTreeViewColumn* column, GtkCellRenderer* cell)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_set_tooltip_cell", "GtkTreeView*");
  Xen_check_type(Xen_is_GtkTooltip_(tooltip), tooltip, 2, "gtk_tree_view_set_tooltip_cell", "GtkTooltip*");
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 3, "gtk_tree_view_set_tooltip_cell", "GtkTreePath*");
  Xen_check_type(Xen_is_GtkTreeViewColumn_(column), column, 4, "gtk_tree_view_set_tooltip_cell", "GtkTreeViewColumn*");
  Xen_check_type(Xen_is_GtkCellRenderer_(cell), cell, 5, "gtk_tree_view_set_tooltip_cell", "GtkCellRenderer*");
  gtk_tree_view_set_tooltip_cell(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_GtkTooltip_(tooltip), Xen_to_C_GtkTreePath_(path), 
                                 Xen_to_C_GtkTreeViewColumn_(column), Xen_to_C_GtkCellRenderer_(cell));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_get_tooltip_context(Xen tree_view, Xen ignore_x, Xen ignore_y, Xen keyboard_tip, Xen ignore_model, Xen ignore_path, Xen iter)
{
  #define H_gtk_tree_view_get_tooltip_context "gboolean gtk_tree_view_get_tooltip_context(GtkTreeView* tree_view, \
gint* [x], gint* [y], gboolean keyboard_tip, GtkTreeModel** [model], GtkTreePath** [path], GtkTreeIter* iter)"
  gint ref_x;
  gint ref_y;
  GtkTreeModel* ref_model = NULL;
  GtkTreePath* ref_path = NULL;
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_get_tooltip_context", "GtkTreeView*");
  Xen_check_type(Xen_is_gboolean(keyboard_tip), keyboard_tip, 4, "gtk_tree_view_get_tooltip_context", "gboolean");
  Xen_check_type(Xen_is_GtkTreeIter_(iter) || Xen_is_false(iter), iter, 7, "gtk_tree_view_get_tooltip_context", "GtkTreeIter*");
  {
    Xen res_ult;
    res_ult = C_to_Xen_gboolean(gtk_tree_view_get_tooltip_context(Xen_to_C_GtkTreeView_(tree_view), &ref_x, &ref_y, Xen_to_C_gboolean(keyboard_tip), 
                                                                  &ref_model, &ref_path, Xen_to_C_GtkTreeIter_(iter)));
    return(Xen_list_5(res_ult, C_to_Xen_gint(ref_x), C_to_Xen_gint(ref_y), C_to_Xen_GtkTreeModel_(ref_model), C_to_Xen_GtkTreePath_(ref_path)));
   }
}

static Xen gxg_gtk_tree_view_set_tooltip_column(Xen tree_view, Xen column)
{
  #define H_gtk_tree_view_set_tooltip_column "void gtk_tree_view_set_tooltip_column(GtkTreeView* tree_view, \
gint column)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_set_tooltip_column", "GtkTreeView*");
  Xen_check_type(Xen_is_gint(column), column, 2, "gtk_tree_view_set_tooltip_column", "gint");
  gtk_tree_view_set_tooltip_column(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_gint(column));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_get_tooltip_column(Xen tree_view )
{
  #define H_gtk_tree_view_get_tooltip_column "gint gtk_tree_view_get_tooltip_column(GtkTreeView* tree_view, \
)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view ), tree_view , 1, "gtk_tree_view_get_tooltip_column", "GtkTreeView*");
  return(C_to_Xen_gint(gtk_tree_view_get_tooltip_column(Xen_to_C_GtkTreeView_(tree_view ))));
}

static Xen gxg_gtk_widget_set_has_tooltip(Xen widget, Xen has_tooltip)
{
  #define H_gtk_widget_set_has_tooltip "void gtk_widget_set_has_tooltip(GtkWidget* widget, gboolean has_tooltip)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_set_has_tooltip", "GtkWidget*");
  Xen_check_type(Xen_is_gboolean(has_tooltip), has_tooltip, 2, "gtk_widget_set_has_tooltip", "gboolean");
  gtk_widget_set_has_tooltip(Xen_to_C_GtkWidget_(widget), Xen_to_C_gboolean(has_tooltip));
  return(Xen_false);
}

static Xen gxg_gtk_widget_get_has_tooltip(Xen widget)
{
  #define H_gtk_widget_get_has_tooltip "gboolean gtk_widget_get_has_tooltip(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_get_has_tooltip", "GtkWidget*");
  return(C_to_Xen_gboolean(gtk_widget_get_has_tooltip(Xen_to_C_GtkWidget_(widget))));
}

static Xen gxg_gtk_dialog_get_content_area(Xen dialog)
{
  #define H_gtk_dialog_get_content_area "GtkWidget* gtk_dialog_get_content_area(GtkDialog* dialog)"
  Xen_check_type(Xen_is_GtkDialog_(dialog), dialog, 1, "gtk_dialog_get_content_area", "GtkDialog*");
  return(C_to_Xen_GtkWidget_(gtk_dialog_get_content_area(Xen_to_C_GtkDialog_(dialog))));
}

static Xen gxg_gtk_entry_set_overwrite_mode(Xen entry, Xen overwrite)
{
  #define H_gtk_entry_set_overwrite_mode "void gtk_entry_set_overwrite_mode(GtkEntry* entry, gboolean overwrite)"
  Xen_check_type(Xen_is_GtkEntry_(entry), entry, 1, "gtk_entry_set_overwrite_mode", "GtkEntry*");
  Xen_check_type(Xen_is_gboolean(overwrite), overwrite, 2, "gtk_entry_set_overwrite_mode", "gboolean");
  gtk_entry_set_overwrite_mode(Xen_to_C_GtkEntry_(entry), Xen_to_C_gboolean(overwrite));
  return(Xen_false);
}

static Xen gxg_gtk_entry_get_overwrite_mode(Xen entry)
{
  #define H_gtk_entry_get_overwrite_mode "gboolean gtk_entry_get_overwrite_mode(GtkEntry* entry)"
  Xen_check_type(Xen_is_GtkEntry_(entry), entry, 1, "gtk_entry_get_overwrite_mode", "GtkEntry*");
  return(C_to_Xen_gboolean(gtk_entry_get_overwrite_mode(Xen_to_C_GtkEntry_(entry))));
}

static Xen gxg_gtk_entry_get_text_length(Xen entry)
{
  #define H_gtk_entry_get_text_length "guint16 gtk_entry_get_text_length(GtkEntry* entry)"
  Xen_check_type(Xen_is_GtkEntry_(entry), entry, 1, "gtk_entry_get_text_length", "GtkEntry*");
  return(C_to_Xen_guint16(gtk_entry_get_text_length(Xen_to_C_GtkEntry_(entry))));
}

static Xen gxg_gtk_scale_button_get_plus_button(Xen button)
{
  #define H_gtk_scale_button_get_plus_button "GtkWidget* gtk_scale_button_get_plus_button(GtkScaleButton* button)"
  Xen_check_type(Xen_is_GtkScaleButton_(button), button, 1, "gtk_scale_button_get_plus_button", "GtkScaleButton*");
  return(C_to_Xen_GtkWidget_(gtk_scale_button_get_plus_button(Xen_to_C_GtkScaleButton_(button))));
}

static Xen gxg_gtk_scale_button_get_minus_button(Xen button)
{
  #define H_gtk_scale_button_get_minus_button "GtkWidget* gtk_scale_button_get_minus_button(GtkScaleButton* button)"
  Xen_check_type(Xen_is_GtkScaleButton_(button), button, 1, "gtk_scale_button_get_minus_button", "GtkScaleButton*");
  return(C_to_Xen_GtkWidget_(gtk_scale_button_get_minus_button(Xen_to_C_GtkScaleButton_(button))));
}

static Xen gxg_gtk_scale_button_get_popup(Xen button)
{
  #define H_gtk_scale_button_get_popup "GtkWidget* gtk_scale_button_get_popup(GtkScaleButton* button)"
  Xen_check_type(Xen_is_GtkScaleButton_(button), button, 1, "gtk_scale_button_get_popup", "GtkScaleButton*");
  return(C_to_Xen_GtkWidget_(gtk_scale_button_get_popup(Xen_to_C_GtkScaleButton_(button))));
}

static Xen gxg_gtk_adjustment_get_lower(Xen adjustment)
{
  #define H_gtk_adjustment_get_lower "gdouble gtk_adjustment_get_lower(GtkAdjustment* adjustment)"
  Xen_check_type(Xen_is_GtkAdjustment_(adjustment), adjustment, 1, "gtk_adjustment_get_lower", "GtkAdjustment*");
  return(C_to_Xen_gdouble(gtk_adjustment_get_lower(Xen_to_C_GtkAdjustment_(adjustment))));
}

static Xen gxg_gtk_adjustment_set_lower(Xen adjustment, Xen lower)
{
  #define H_gtk_adjustment_set_lower "void gtk_adjustment_set_lower(GtkAdjustment* adjustment, gdouble lower)"
  Xen_check_type(Xen_is_GtkAdjustment_(adjustment), adjustment, 1, "gtk_adjustment_set_lower", "GtkAdjustment*");
  Xen_check_type(Xen_is_gdouble(lower), lower, 2, "gtk_adjustment_set_lower", "gdouble");
  gtk_adjustment_set_lower(Xen_to_C_GtkAdjustment_(adjustment), Xen_to_C_gdouble(lower));
  return(Xen_false);
}

static Xen gxg_gtk_adjustment_get_upper(Xen adjustment)
{
  #define H_gtk_adjustment_get_upper "gdouble gtk_adjustment_get_upper(GtkAdjustment* adjustment)"
  Xen_check_type(Xen_is_GtkAdjustment_(adjustment), adjustment, 1, "gtk_adjustment_get_upper", "GtkAdjustment*");
  return(C_to_Xen_gdouble(gtk_adjustment_get_upper(Xen_to_C_GtkAdjustment_(adjustment))));
}

static Xen gxg_gtk_adjustment_set_upper(Xen adjustment, Xen upper)
{
  #define H_gtk_adjustment_set_upper "void gtk_adjustment_set_upper(GtkAdjustment* adjustment, gdouble upper)"
  Xen_check_type(Xen_is_GtkAdjustment_(adjustment), adjustment, 1, "gtk_adjustment_set_upper", "GtkAdjustment*");
  Xen_check_type(Xen_is_gdouble(upper), upper, 2, "gtk_adjustment_set_upper", "gdouble");
  gtk_adjustment_set_upper(Xen_to_C_GtkAdjustment_(adjustment), Xen_to_C_gdouble(upper));
  return(Xen_false);
}

static Xen gxg_gtk_adjustment_get_step_increment(Xen adjustment)
{
  #define H_gtk_adjustment_get_step_increment "gdouble gtk_adjustment_get_step_increment(GtkAdjustment* adjustment)"
  Xen_check_type(Xen_is_GtkAdjustment_(adjustment), adjustment, 1, "gtk_adjustment_get_step_increment", "GtkAdjustment*");
  return(C_to_Xen_gdouble(gtk_adjustment_get_step_increment(Xen_to_C_GtkAdjustment_(adjustment))));
}

static Xen gxg_gtk_adjustment_set_step_increment(Xen adjustment, Xen step_increment)
{
  #define H_gtk_adjustment_set_step_increment "void gtk_adjustment_set_step_increment(GtkAdjustment* adjustment, \
gdouble step_increment)"
  Xen_check_type(Xen_is_GtkAdjustment_(adjustment), adjustment, 1, "gtk_adjustment_set_step_increment", "GtkAdjustment*");
  Xen_check_type(Xen_is_gdouble(step_increment), step_increment, 2, "gtk_adjustment_set_step_increment", "gdouble");
  gtk_adjustment_set_step_increment(Xen_to_C_GtkAdjustment_(adjustment), Xen_to_C_gdouble(step_increment));
  return(Xen_false);
}

static Xen gxg_gtk_adjustment_get_page_increment(Xen adjustment)
{
  #define H_gtk_adjustment_get_page_increment "gdouble gtk_adjustment_get_page_increment(GtkAdjustment* adjustment)"
  Xen_check_type(Xen_is_GtkAdjustment_(adjustment), adjustment, 1, "gtk_adjustment_get_page_increment", "GtkAdjustment*");
  return(C_to_Xen_gdouble(gtk_adjustment_get_page_increment(Xen_to_C_GtkAdjustment_(adjustment))));
}

static Xen gxg_gtk_adjustment_set_page_increment(Xen adjustment, Xen page_increment)
{
  #define H_gtk_adjustment_set_page_increment "void gtk_adjustment_set_page_increment(GtkAdjustment* adjustment, \
gdouble page_increment)"
  Xen_check_type(Xen_is_GtkAdjustment_(adjustment), adjustment, 1, "gtk_adjustment_set_page_increment", "GtkAdjustment*");
  Xen_check_type(Xen_is_gdouble(page_increment), page_increment, 2, "gtk_adjustment_set_page_increment", "gdouble");
  gtk_adjustment_set_page_increment(Xen_to_C_GtkAdjustment_(adjustment), Xen_to_C_gdouble(page_increment));
  return(Xen_false);
}

static Xen gxg_gtk_adjustment_get_page_size(Xen adjustment)
{
  #define H_gtk_adjustment_get_page_size "gdouble gtk_adjustment_get_page_size(GtkAdjustment* adjustment)"
  Xen_check_type(Xen_is_GtkAdjustment_(adjustment), adjustment, 1, "gtk_adjustment_get_page_size", "GtkAdjustment*");
  return(C_to_Xen_gdouble(gtk_adjustment_get_page_size(Xen_to_C_GtkAdjustment_(adjustment))));
}

static Xen gxg_gtk_adjustment_set_page_size(Xen adjustment, Xen page_size)
{
  #define H_gtk_adjustment_set_page_size "void gtk_adjustment_set_page_size(GtkAdjustment* adjustment, \
gdouble page_size)"
  Xen_check_type(Xen_is_GtkAdjustment_(adjustment), adjustment, 1, "gtk_adjustment_set_page_size", "GtkAdjustment*");
  Xen_check_type(Xen_is_gdouble(page_size), page_size, 2, "gtk_adjustment_set_page_size", "gdouble");
  gtk_adjustment_set_page_size(Xen_to_C_GtkAdjustment_(adjustment), Xen_to_C_gdouble(page_size));
  return(Xen_false);
}

static Xen gxg_gtk_adjustment_configure(Xen adjustment, Xen value, Xen lower, Xen upper, Xen step_increment, Xen page_increment, Xen page_size)
{
  #define H_gtk_adjustment_configure "void gtk_adjustment_configure(GtkAdjustment* adjustment, gdouble value, \
gdouble lower, gdouble upper, gdouble step_increment, gdouble page_increment, gdouble page_size)"
  Xen_check_type(Xen_is_GtkAdjustment_(adjustment), adjustment, 1, "gtk_adjustment_configure", "GtkAdjustment*");
  Xen_check_type(Xen_is_gdouble(value), value, 2, "gtk_adjustment_configure", "gdouble");
  Xen_check_type(Xen_is_gdouble(lower), lower, 3, "gtk_adjustment_configure", "gdouble");
  Xen_check_type(Xen_is_gdouble(upper), upper, 4, "gtk_adjustment_configure", "gdouble");
  Xen_check_type(Xen_is_gdouble(step_increment), step_increment, 5, "gtk_adjustment_configure", "gdouble");
  Xen_check_type(Xen_is_gdouble(page_increment), page_increment, 6, "gtk_adjustment_configure", "gdouble");
  Xen_check_type(Xen_is_gdouble(page_size), page_size, 7, "gtk_adjustment_configure", "gdouble");
  gtk_adjustment_configure(Xen_to_C_GtkAdjustment_(adjustment), Xen_to_C_gdouble(value), Xen_to_C_gdouble(lower), Xen_to_C_gdouble(upper), 
                           Xen_to_C_gdouble(step_increment), Xen_to_C_gdouble(page_increment), Xen_to_C_gdouble(page_size));
  return(Xen_false);
}

static Xen gxg_gtk_combo_box_set_button_sensitivity(Xen combo_box, Xen sensitivity)
{
  #define H_gtk_combo_box_set_button_sensitivity "void gtk_combo_box_set_button_sensitivity(GtkComboBox* combo_box, \
GtkSensitivityType sensitivity)"
  Xen_check_type(Xen_is_GtkComboBox_(combo_box), combo_box, 1, "gtk_combo_box_set_button_sensitivity", "GtkComboBox*");
  Xen_check_type(Xen_is_GtkSensitivityType(sensitivity), sensitivity, 2, "gtk_combo_box_set_button_sensitivity", "GtkSensitivityType");
  gtk_combo_box_set_button_sensitivity(Xen_to_C_GtkComboBox_(combo_box), Xen_to_C_GtkSensitivityType(sensitivity));
  return(Xen_false);
}

static Xen gxg_gtk_combo_box_get_button_sensitivity(Xen combo_box)
{
  #define H_gtk_combo_box_get_button_sensitivity "GtkSensitivityType gtk_combo_box_get_button_sensitivity(GtkComboBox* combo_box)"
  Xen_check_type(Xen_is_GtkComboBox_(combo_box), combo_box, 1, "gtk_combo_box_get_button_sensitivity", "GtkComboBox*");
  return(C_to_Xen_GtkSensitivityType(gtk_combo_box_get_button_sensitivity(Xen_to_C_GtkComboBox_(combo_box))));
}

static Xen gxg_gtk_window_get_default_widget(Xen window)
{
  #define H_gtk_window_get_default_widget "GtkWidget* gtk_window_get_default_widget(GtkWindow* window)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_get_default_widget", "GtkWindow*");
  return(C_to_Xen_GtkWidget_(gtk_window_get_default_widget(Xen_to_C_GtkWindow_(window))));
}

static Xen gxg_gtk_link_button_get_visited(Xen link_button)
{
  #define H_gtk_link_button_get_visited "gboolean gtk_link_button_get_visited(GtkLinkButton* link_button)"
  Xen_check_type(Xen_is_GtkLinkButton_(link_button), link_button, 1, "gtk_link_button_get_visited", "GtkLinkButton*");
  return(C_to_Xen_gboolean(gtk_link_button_get_visited(Xen_to_C_GtkLinkButton_(link_button))));
}

static Xen gxg_gtk_link_button_set_visited(Xen link_button, Xen visited)
{
  #define H_gtk_link_button_set_visited "void gtk_link_button_set_visited(GtkLinkButton* link_button, \
bool visited)"
  Xen_check_type(Xen_is_GtkLinkButton_(link_button), link_button, 1, "gtk_link_button_set_visited", "GtkLinkButton*");
  Xen_check_type(Xen_is_bool(visited), visited, 2, "gtk_link_button_set_visited", "bool");
  gtk_link_button_set_visited(Xen_to_C_GtkLinkButton_(link_button), Xen_to_C_bool(visited));
  return(Xen_false);
}

static Xen gxg_gtk_cell_view_get_model(Xen cell_view)
{
  #define H_gtk_cell_view_get_model "GtkTreeModel* gtk_cell_view_get_model(GtkCellView* cell_view)"
  Xen_check_type(Xen_is_GtkCellView_(cell_view), cell_view, 1, "gtk_cell_view_get_model", "GtkCellView*");
  return(C_to_Xen_GtkTreeModel_(gtk_cell_view_get_model(Xen_to_C_GtkCellView_(cell_view))));
}

static Xen gxg_gtk_entry_unset_invisible_char(Xen entry)
{
  #define H_gtk_entry_unset_invisible_char "void gtk_entry_unset_invisible_char(GtkEntry* entry)"
  Xen_check_type(Xen_is_GtkEntry_(entry), entry, 1, "gtk_entry_unset_invisible_char", "GtkEntry*");
  gtk_entry_unset_invisible_char(Xen_to_C_GtkEntry_(entry));
  return(Xen_false);
}

static Xen gxg_gtk_entry_set_progress_fraction(Xen entry, Xen fraction)
{
  #define H_gtk_entry_set_progress_fraction "void gtk_entry_set_progress_fraction(GtkEntry* entry, gdouble fraction)"
  Xen_check_type(Xen_is_GtkEntry_(entry), entry, 1, "gtk_entry_set_progress_fraction", "GtkEntry*");
  Xen_check_type(Xen_is_gdouble(fraction), fraction, 2, "gtk_entry_set_progress_fraction", "gdouble");
  gtk_entry_set_progress_fraction(Xen_to_C_GtkEntry_(entry), Xen_to_C_gdouble(fraction));
  return(Xen_false);
}

static Xen gxg_gtk_entry_get_progress_fraction(Xen entry)
{
  #define H_gtk_entry_get_progress_fraction "gdouble gtk_entry_get_progress_fraction(GtkEntry* entry)"
  Xen_check_type(Xen_is_GtkEntry_(entry), entry, 1, "gtk_entry_get_progress_fraction", "GtkEntry*");
  return(C_to_Xen_gdouble(gtk_entry_get_progress_fraction(Xen_to_C_GtkEntry_(entry))));
}

static Xen gxg_gtk_entry_set_progress_pulse_step(Xen entry, Xen fraction)
{
  #define H_gtk_entry_set_progress_pulse_step "void gtk_entry_set_progress_pulse_step(GtkEntry* entry, \
gdouble fraction)"
  Xen_check_type(Xen_is_GtkEntry_(entry), entry, 1, "gtk_entry_set_progress_pulse_step", "GtkEntry*");
  Xen_check_type(Xen_is_gdouble(fraction), fraction, 2, "gtk_entry_set_progress_pulse_step", "gdouble");
  gtk_entry_set_progress_pulse_step(Xen_to_C_GtkEntry_(entry), Xen_to_C_gdouble(fraction));
  return(Xen_false);
}

static Xen gxg_gtk_entry_get_progress_pulse_step(Xen entry)
{
  #define H_gtk_entry_get_progress_pulse_step "gdouble gtk_entry_get_progress_pulse_step(GtkEntry* entry)"
  Xen_check_type(Xen_is_GtkEntry_(entry), entry, 1, "gtk_entry_get_progress_pulse_step", "GtkEntry*");
  return(C_to_Xen_gdouble(gtk_entry_get_progress_pulse_step(Xen_to_C_GtkEntry_(entry))));
}

static Xen gxg_gtk_entry_progress_pulse(Xen entry)
{
  #define H_gtk_entry_progress_pulse "void gtk_entry_progress_pulse(GtkEntry* entry)"
  Xen_check_type(Xen_is_GtkEntry_(entry), entry, 1, "gtk_entry_progress_pulse", "GtkEntry*");
  gtk_entry_progress_pulse(Xen_to_C_GtkEntry_(entry));
  return(Xen_false);
}

static Xen gxg_gtk_entry_get_icon_name(Xen entry, Xen icon_pos)
{
  #define H_gtk_entry_get_icon_name "gchar* gtk_entry_get_icon_name(GtkEntry* entry, GtkEntryIconPosition icon_pos)"
  Xen_check_type(Xen_is_GtkEntry_(entry), entry, 1, "gtk_entry_get_icon_name", "GtkEntry*");
  Xen_check_type(Xen_is_GtkEntryIconPosition(icon_pos), icon_pos, 2, "gtk_entry_get_icon_name", "GtkEntryIconPosition");
  return(C_to_Xen_gchar_(gtk_entry_get_icon_name(Xen_to_C_GtkEntry_(entry), Xen_to_C_GtkEntryIconPosition(icon_pos))));
}

static Xen gxg_gtk_entry_set_icon_activatable(Xen entry, Xen icon_pos, Xen activatable)
{
  #define H_gtk_entry_set_icon_activatable "void gtk_entry_set_icon_activatable(GtkEntry* entry, GtkEntryIconPosition icon_pos, \
gboolean activatable)"
  Xen_check_type(Xen_is_GtkEntry_(entry), entry, 1, "gtk_entry_set_icon_activatable", "GtkEntry*");
  Xen_check_type(Xen_is_GtkEntryIconPosition(icon_pos), icon_pos, 2, "gtk_entry_set_icon_activatable", "GtkEntryIconPosition");
  Xen_check_type(Xen_is_gboolean(activatable), activatable, 3, "gtk_entry_set_icon_activatable", "gboolean");
  gtk_entry_set_icon_activatable(Xen_to_C_GtkEntry_(entry), Xen_to_C_GtkEntryIconPosition(icon_pos), Xen_to_C_gboolean(activatable));
  return(Xen_false);
}

static Xen gxg_gtk_entry_get_icon_activatable(Xen entry, Xen icon_pos)
{
  #define H_gtk_entry_get_icon_activatable "gboolean gtk_entry_get_icon_activatable(GtkEntry* entry, \
GtkEntryIconPosition icon_pos)"
  Xen_check_type(Xen_is_GtkEntry_(entry), entry, 1, "gtk_entry_get_icon_activatable", "GtkEntry*");
  Xen_check_type(Xen_is_GtkEntryIconPosition(icon_pos), icon_pos, 2, "gtk_entry_get_icon_activatable", "GtkEntryIconPosition");
  return(C_to_Xen_gboolean(gtk_entry_get_icon_activatable(Xen_to_C_GtkEntry_(entry), Xen_to_C_GtkEntryIconPosition(icon_pos))));
}

static Xen gxg_gtk_entry_set_icon_sensitive(Xen entry, Xen icon_pos, Xen sensitive)
{
  #define H_gtk_entry_set_icon_sensitive "void gtk_entry_set_icon_sensitive(GtkEntry* entry, GtkEntryIconPosition icon_pos, \
gboolean sensitive)"
  Xen_check_type(Xen_is_GtkEntry_(entry), entry, 1, "gtk_entry_set_icon_sensitive", "GtkEntry*");
  Xen_check_type(Xen_is_GtkEntryIconPosition(icon_pos), icon_pos, 2, "gtk_entry_set_icon_sensitive", "GtkEntryIconPosition");
  Xen_check_type(Xen_is_gboolean(sensitive), sensitive, 3, "gtk_entry_set_icon_sensitive", "gboolean");
  gtk_entry_set_icon_sensitive(Xen_to_C_GtkEntry_(entry), Xen_to_C_GtkEntryIconPosition(icon_pos), Xen_to_C_gboolean(sensitive));
  return(Xen_false);
}

static Xen gxg_gtk_entry_get_icon_sensitive(Xen entry, Xen icon_pos)
{
  #define H_gtk_entry_get_icon_sensitive "gboolean gtk_entry_get_icon_sensitive(GtkEntry* entry, GtkEntryIconPosition icon_pos)"
  Xen_check_type(Xen_is_GtkEntry_(entry), entry, 1, "gtk_entry_get_icon_sensitive", "GtkEntry*");
  Xen_check_type(Xen_is_GtkEntryIconPosition(icon_pos), icon_pos, 2, "gtk_entry_get_icon_sensitive", "GtkEntryIconPosition");
  return(C_to_Xen_gboolean(gtk_entry_get_icon_sensitive(Xen_to_C_GtkEntry_(entry), Xen_to_C_GtkEntryIconPosition(icon_pos))));
}

static Xen gxg_gtk_entry_get_icon_at_pos(Xen entry, Xen x, Xen y)
{
  #define H_gtk_entry_get_icon_at_pos "gint gtk_entry_get_icon_at_pos(GtkEntry* entry, gint x, gint y)"
  Xen_check_type(Xen_is_GtkEntry_(entry), entry, 1, "gtk_entry_get_icon_at_pos", "GtkEntry*");
  Xen_check_type(Xen_is_gint(x), x, 2, "gtk_entry_get_icon_at_pos", "gint");
  Xen_check_type(Xen_is_gint(y), y, 3, "gtk_entry_get_icon_at_pos", "gint");
  return(C_to_Xen_gint(gtk_entry_get_icon_at_pos(Xen_to_C_GtkEntry_(entry), Xen_to_C_gint(x), Xen_to_C_gint(y))));
}

static Xen gxg_gtk_entry_set_icon_tooltip_text(Xen entry, Xen icon_pos, Xen tooltip)
{
  #define H_gtk_entry_set_icon_tooltip_text "void gtk_entry_set_icon_tooltip_text(GtkEntry* entry, GtkEntryIconPosition icon_pos, \
gchar* tooltip)"
  Xen_check_type(Xen_is_GtkEntry_(entry), entry, 1, "gtk_entry_set_icon_tooltip_text", "GtkEntry*");
  Xen_check_type(Xen_is_GtkEntryIconPosition(icon_pos), icon_pos, 2, "gtk_entry_set_icon_tooltip_text", "GtkEntryIconPosition");
  Xen_check_type(Xen_is_gchar_(tooltip), tooltip, 3, "gtk_entry_set_icon_tooltip_text", "gchar*");
  gtk_entry_set_icon_tooltip_text(Xen_to_C_GtkEntry_(entry), Xen_to_C_GtkEntryIconPosition(icon_pos), Xen_to_C_gchar_(tooltip));
  return(Xen_false);
}

static Xen gxg_gtk_entry_set_icon_tooltip_markup(Xen entry, Xen icon_pos, Xen tooltip)
{
  #define H_gtk_entry_set_icon_tooltip_markup "void gtk_entry_set_icon_tooltip_markup(GtkEntry* entry, \
GtkEntryIconPosition icon_pos, gchar* tooltip)"
  Xen_check_type(Xen_is_GtkEntry_(entry), entry, 1, "gtk_entry_set_icon_tooltip_markup", "GtkEntry*");
  Xen_check_type(Xen_is_GtkEntryIconPosition(icon_pos), icon_pos, 2, "gtk_entry_set_icon_tooltip_markup", "GtkEntryIconPosition");
  Xen_check_type(Xen_is_gchar_(tooltip), tooltip, 3, "gtk_entry_set_icon_tooltip_markup", "gchar*");
  gtk_entry_set_icon_tooltip_markup(Xen_to_C_GtkEntry_(entry), Xen_to_C_GtkEntryIconPosition(icon_pos), Xen_to_C_gchar_(tooltip));
  return(Xen_false);
}

static Xen gxg_gtk_entry_get_icon_tooltip_text(Xen entry, Xen icon_pos)
{
  #define H_gtk_entry_get_icon_tooltip_text "gchar* gtk_entry_get_icon_tooltip_text(GtkEntry* entry, \
GtkEntryIconPosition icon_pos)"
  Xen_check_type(Xen_is_GtkEntry_(entry), entry, 1, "gtk_entry_get_icon_tooltip_text", "GtkEntry*");
  Xen_check_type(Xen_is_GtkEntryIconPosition(icon_pos), icon_pos, 2, "gtk_entry_get_icon_tooltip_text", "GtkEntryIconPosition");
  return(C_to_Xen_gchar_(gtk_entry_get_icon_tooltip_text(Xen_to_C_GtkEntry_(entry), Xen_to_C_GtkEntryIconPosition(icon_pos))));
}

static Xen gxg_gtk_entry_get_icon_tooltip_markup(Xen entry, Xen icon_pos)
{
  #define H_gtk_entry_get_icon_tooltip_markup "gchar* gtk_entry_get_icon_tooltip_markup(GtkEntry* entry, \
GtkEntryIconPosition icon_pos)"
  Xen_check_type(Xen_is_GtkEntry_(entry), entry, 1, "gtk_entry_get_icon_tooltip_markup", "GtkEntry*");
  Xen_check_type(Xen_is_GtkEntryIconPosition(icon_pos), icon_pos, 2, "gtk_entry_get_icon_tooltip_markup", "GtkEntryIconPosition");
  return(C_to_Xen_gchar_(gtk_entry_get_icon_tooltip_markup(Xen_to_C_GtkEntry_(entry), Xen_to_C_GtkEntryIconPosition(icon_pos))));
}

static Xen gxg_gtk_scale_add_mark(Xen scale, Xen value, Xen position, Xen markup)
{
  #define H_gtk_scale_add_mark "void gtk_scale_add_mark(GtkScale* scale, gdouble value, GtkPositionType position, \
gchar* markup)"
  Xen_check_type(Xen_is_GtkScale_(scale), scale, 1, "gtk_scale_add_mark", "GtkScale*");
  Xen_check_type(Xen_is_gdouble(value), value, 2, "gtk_scale_add_mark", "gdouble");
  Xen_check_type(Xen_is_GtkPositionType(position), position, 3, "gtk_scale_add_mark", "GtkPositionType");
  Xen_check_type(Xen_is_gchar_(markup), markup, 4, "gtk_scale_add_mark", "gchar*");
  gtk_scale_add_mark(Xen_to_C_GtkScale_(scale), Xen_to_C_gdouble(value), Xen_to_C_GtkPositionType(position), Xen_to_C_gchar_(markup));
  return(Xen_false);
}

static Xen gxg_gtk_scale_clear_marks(Xen scale)
{
  #define H_gtk_scale_clear_marks "void gtk_scale_clear_marks(GtkScale* scale)"
  Xen_check_type(Xen_is_GtkScale_(scale), scale, 1, "gtk_scale_clear_marks", "GtkScale*");
  gtk_scale_clear_marks(Xen_to_C_GtkScale_(scale));
  return(Xen_false);
}

static Xen gxg_gtk_window_get_default_icon_name(void)
{
  #define H_gtk_window_get_default_icon_name "gchar* gtk_window_get_default_icon_name( void)"
  return(C_to_Xen_gchar_(gtk_window_get_default_icon_name()));
}

static Xen gxg_gtk_label_get_current_uri(Xen label)
{
  #define H_gtk_label_get_current_uri "gchar* gtk_label_get_current_uri(GtkLabel* label)"
  Xen_check_type(Xen_is_GtkLabel_(label), label, 1, "gtk_label_get_current_uri", "GtkLabel*");
  return(C_to_Xen_gchar_(gtk_label_get_current_uri(Xen_to_C_GtkLabel_(label))));
}

static Xen gxg_gtk_info_bar_new(void)
{
  #define H_gtk_info_bar_new "GtkWidget* gtk_info_bar_new( void)"
  return(C_to_Xen_GtkWidget_(gtk_info_bar_new()));
}

static Xen gxg_gtk_info_bar_add_action_widget(Xen info_bar, Xen child, Xen response_id)
{
  #define H_gtk_info_bar_add_action_widget "void gtk_info_bar_add_action_widget(GtkInfoBar* info_bar, \
GtkWidget* child, gint response_id)"
  Xen_check_type(Xen_is_GtkInfoBar_(info_bar), info_bar, 1, "gtk_info_bar_add_action_widget", "GtkInfoBar*");
  Xen_check_type(Xen_is_GtkWidget_(child), child, 2, "gtk_info_bar_add_action_widget", "GtkWidget*");
  Xen_check_type(Xen_is_gint(response_id), response_id, 3, "gtk_info_bar_add_action_widget", "gint");
  gtk_info_bar_add_action_widget(Xen_to_C_GtkInfoBar_(info_bar), Xen_to_C_GtkWidget_(child), Xen_to_C_gint(response_id));
  return(Xen_false);
}

static Xen gxg_gtk_info_bar_add_button(Xen info_bar, Xen button_text, Xen response_id)
{
  #define H_gtk_info_bar_add_button "GtkWidget* gtk_info_bar_add_button(GtkInfoBar* info_bar, gchar* button_text, \
gint response_id)"
  Xen_check_type(Xen_is_GtkInfoBar_(info_bar), info_bar, 1, "gtk_info_bar_add_button", "GtkInfoBar*");
  Xen_check_type(Xen_is_gchar_(button_text), button_text, 2, "gtk_info_bar_add_button", "gchar*");
  Xen_check_type(Xen_is_gint(response_id), response_id, 3, "gtk_info_bar_add_button", "gint");
  return(C_to_Xen_GtkWidget_(gtk_info_bar_add_button(Xen_to_C_GtkInfoBar_(info_bar), Xen_to_C_gchar_(button_text), Xen_to_C_gint(response_id))));
}

static Xen gxg_gtk_info_bar_set_response_sensitive(Xen info_bar, Xen response_id, Xen setting)
{
  #define H_gtk_info_bar_set_response_sensitive "void gtk_info_bar_set_response_sensitive(GtkInfoBar* info_bar, \
gint response_id, gboolean setting)"
  Xen_check_type(Xen_is_GtkInfoBar_(info_bar), info_bar, 1, "gtk_info_bar_set_response_sensitive", "GtkInfoBar*");
  Xen_check_type(Xen_is_gint(response_id), response_id, 2, "gtk_info_bar_set_response_sensitive", "gint");
  Xen_check_type(Xen_is_gboolean(setting), setting, 3, "gtk_info_bar_set_response_sensitive", "gboolean");
  gtk_info_bar_set_response_sensitive(Xen_to_C_GtkInfoBar_(info_bar), Xen_to_C_gint(response_id), Xen_to_C_gboolean(setting));
  return(Xen_false);
}

static Xen gxg_gtk_info_bar_set_default_response(Xen info_bar, Xen response_id)
{
  #define H_gtk_info_bar_set_default_response "void gtk_info_bar_set_default_response(GtkInfoBar* info_bar, \
gint response_id)"
  Xen_check_type(Xen_is_GtkInfoBar_(info_bar), info_bar, 1, "gtk_info_bar_set_default_response", "GtkInfoBar*");
  Xen_check_type(Xen_is_gint(response_id), response_id, 2, "gtk_info_bar_set_default_response", "gint");
  gtk_info_bar_set_default_response(Xen_to_C_GtkInfoBar_(info_bar), Xen_to_C_gint(response_id));
  return(Xen_false);
}

static Xen gxg_gtk_info_bar_response(Xen info_bar, Xen response_id)
{
  #define H_gtk_info_bar_response "void gtk_info_bar_response(GtkInfoBar* info_bar, gint response_id)"
  Xen_check_type(Xen_is_GtkInfoBar_(info_bar), info_bar, 1, "gtk_info_bar_response", "GtkInfoBar*");
  Xen_check_type(Xen_is_gint(response_id), response_id, 2, "gtk_info_bar_response", "gint");
  gtk_info_bar_response(Xen_to_C_GtkInfoBar_(info_bar), Xen_to_C_gint(response_id));
  return(Xen_false);
}

static Xen gxg_gtk_info_bar_set_message_type(Xen info_bar, Xen message_type)
{
  #define H_gtk_info_bar_set_message_type "void gtk_info_bar_set_message_type(GtkInfoBar* info_bar, GtkMessageType message_type)"
  Xen_check_type(Xen_is_GtkInfoBar_(info_bar), info_bar, 1, "gtk_info_bar_set_message_type", "GtkInfoBar*");
  Xen_check_type(Xen_is_GtkMessageType(message_type), message_type, 2, "gtk_info_bar_set_message_type", "GtkMessageType");
  gtk_info_bar_set_message_type(Xen_to_C_GtkInfoBar_(info_bar), Xen_to_C_GtkMessageType(message_type));
  return(Xen_false);
}

static Xen gxg_gtk_info_bar_get_message_type(Xen info_bar)
{
  #define H_gtk_info_bar_get_message_type "GtkMessageType gtk_info_bar_get_message_type(GtkInfoBar* info_bar)"
  Xen_check_type(Xen_is_GtkInfoBar_(info_bar), info_bar, 1, "gtk_info_bar_get_message_type", "GtkInfoBar*");
  return(C_to_Xen_GtkMessageType(gtk_info_bar_get_message_type(Xen_to_C_GtkInfoBar_(info_bar))));
}

static Xen gxg_gtk_entry_new_with_buffer(Xen buffer)
{
  #define H_gtk_entry_new_with_buffer "GtkWidget* gtk_entry_new_with_buffer(GtkEntryBuffer* buffer)"
  Xen_check_type(Xen_is_GtkEntryBuffer_(buffer), buffer, 1, "gtk_entry_new_with_buffer", "GtkEntryBuffer*");
  return(C_to_Xen_GtkWidget_(gtk_entry_new_with_buffer(Xen_to_C_GtkEntryBuffer_(buffer))));
}

static Xen gxg_gtk_entry_get_buffer(Xen entry)
{
  #define H_gtk_entry_get_buffer "GtkEntryBuffer* gtk_entry_get_buffer(GtkEntry* entry)"
  Xen_check_type(Xen_is_GtkEntry_(entry), entry, 1, "gtk_entry_get_buffer", "GtkEntry*");
  return(C_to_Xen_GtkEntryBuffer_(gtk_entry_get_buffer(Xen_to_C_GtkEntry_(entry))));
}

static Xen gxg_gtk_entry_set_buffer(Xen entry, Xen buffer)
{
  #define H_gtk_entry_set_buffer "void gtk_entry_set_buffer(GtkEntry* entry, GtkEntryBuffer* buffer)"
  Xen_check_type(Xen_is_GtkEntry_(entry), entry, 1, "gtk_entry_set_buffer", "GtkEntry*");
  Xen_check_type(Xen_is_GtkEntryBuffer_(buffer), buffer, 2, "gtk_entry_set_buffer", "GtkEntryBuffer*");
  gtk_entry_set_buffer(Xen_to_C_GtkEntry_(entry), Xen_to_C_GtkEntryBuffer_(buffer));
  return(Xen_false);
}

static Xen gxg_gtk_print_operation_set_embed_page_setup(Xen op, Xen embed)
{
  #define H_gtk_print_operation_set_embed_page_setup "void gtk_print_operation_set_embed_page_setup(GtkPrintOperation* op, \
gboolean embed)"
  Xen_check_type(Xen_is_GtkPrintOperation_(op), op, 1, "gtk_print_operation_set_embed_page_setup", "GtkPrintOperation*");
  Xen_check_type(Xen_is_gboolean(embed), embed, 2, "gtk_print_operation_set_embed_page_setup", "gboolean");
  gtk_print_operation_set_embed_page_setup(Xen_to_C_GtkPrintOperation_(op), Xen_to_C_gboolean(embed));
  return(Xen_false);
}

static Xen gxg_gtk_print_operation_get_embed_page_setup(Xen op)
{
  #define H_gtk_print_operation_get_embed_page_setup "gboolean gtk_print_operation_get_embed_page_setup(GtkPrintOperation* op)"
  Xen_check_type(Xen_is_GtkPrintOperation_(op), op, 1, "gtk_print_operation_get_embed_page_setup", "GtkPrintOperation*");
  return(C_to_Xen_gboolean(gtk_print_operation_get_embed_page_setup(Xen_to_C_GtkPrintOperation_(op))));
}

static Xen gxg_gtk_entry_buffer_new(Xen initial_chars, Xen n_initial_chars)
{
  #define H_gtk_entry_buffer_new "GtkEntryBuffer* gtk_entry_buffer_new(gchar* initial_chars, gint n_initial_chars)"
  Xen_check_type(Xen_is_gchar_(initial_chars), initial_chars, 1, "gtk_entry_buffer_new", "gchar*");
  Xen_check_type(Xen_is_gint(n_initial_chars), n_initial_chars, 2, "gtk_entry_buffer_new", "gint");
  return(C_to_Xen_GtkEntryBuffer_(gtk_entry_buffer_new(Xen_to_C_gchar_(initial_chars), Xen_to_C_gint(n_initial_chars))));
}

static Xen gxg_gtk_entry_buffer_get_bytes(Xen buffer)
{
  #define H_gtk_entry_buffer_get_bytes "gsize gtk_entry_buffer_get_bytes(GtkEntryBuffer* buffer)"
  Xen_check_type(Xen_is_GtkEntryBuffer_(buffer), buffer, 1, "gtk_entry_buffer_get_bytes", "GtkEntryBuffer*");
  return(C_to_Xen_gsize(gtk_entry_buffer_get_bytes(Xen_to_C_GtkEntryBuffer_(buffer))));
}

static Xen gxg_gtk_entry_buffer_get_length(Xen buffer)
{
  #define H_gtk_entry_buffer_get_length "guint gtk_entry_buffer_get_length(GtkEntryBuffer* buffer)"
  Xen_check_type(Xen_is_GtkEntryBuffer_(buffer), buffer, 1, "gtk_entry_buffer_get_length", "GtkEntryBuffer*");
  return(C_to_Xen_guint(gtk_entry_buffer_get_length(Xen_to_C_GtkEntryBuffer_(buffer))));
}

static Xen gxg_gtk_entry_buffer_get_text(Xen buffer)
{
  #define H_gtk_entry_buffer_get_text "gchar* gtk_entry_buffer_get_text(GtkEntryBuffer* buffer)"
  Xen_check_type(Xen_is_GtkEntryBuffer_(buffer), buffer, 1, "gtk_entry_buffer_get_text", "GtkEntryBuffer*");
  return(C_to_Xen_gchar_(gtk_entry_buffer_get_text(Xen_to_C_GtkEntryBuffer_(buffer))));
}

static Xen gxg_gtk_entry_buffer_set_text(Xen buffer, Xen chars, Xen n_chars)
{
  #define H_gtk_entry_buffer_set_text "void gtk_entry_buffer_set_text(GtkEntryBuffer* buffer, gchar* chars, \
gint n_chars)"
  Xen_check_type(Xen_is_GtkEntryBuffer_(buffer), buffer, 1, "gtk_entry_buffer_set_text", "GtkEntryBuffer*");
  Xen_check_type(Xen_is_gchar_(chars), chars, 2, "gtk_entry_buffer_set_text", "gchar*");
  Xen_check_type(Xen_is_gint(n_chars), n_chars, 3, "gtk_entry_buffer_set_text", "gint");
  gtk_entry_buffer_set_text(Xen_to_C_GtkEntryBuffer_(buffer), Xen_to_C_gchar_(chars), Xen_to_C_gint(n_chars));
  return(Xen_false);
}

static Xen gxg_gtk_entry_buffer_set_max_length(Xen buffer, Xen max_length)
{
  #define H_gtk_entry_buffer_set_max_length "void gtk_entry_buffer_set_max_length(GtkEntryBuffer* buffer, \
guint max_length)"
  Xen_check_type(Xen_is_GtkEntryBuffer_(buffer), buffer, 1, "gtk_entry_buffer_set_max_length", "GtkEntryBuffer*");
  Xen_check_type(Xen_is_guint(max_length), max_length, 2, "gtk_entry_buffer_set_max_length", "guint");
  gtk_entry_buffer_set_max_length(Xen_to_C_GtkEntryBuffer_(buffer), Xen_to_C_guint(max_length));
  return(Xen_false);
}

static Xen gxg_gtk_entry_buffer_get_max_length(Xen buffer)
{
  #define H_gtk_entry_buffer_get_max_length "guint gtk_entry_buffer_get_max_length(GtkEntryBuffer* buffer)"
  Xen_check_type(Xen_is_GtkEntryBuffer_(buffer), buffer, 1, "gtk_entry_buffer_get_max_length", "GtkEntryBuffer*");
  return(C_to_Xen_guint(gtk_entry_buffer_get_max_length(Xen_to_C_GtkEntryBuffer_(buffer))));
}

static Xen gxg_gtk_entry_buffer_insert_text(Xen buffer, Xen position, Xen chars, Xen n_chars)
{
  #define H_gtk_entry_buffer_insert_text "guint gtk_entry_buffer_insert_text(GtkEntryBuffer* buffer, \
guint position, gchar* chars, gint n_chars)"
  Xen_check_type(Xen_is_GtkEntryBuffer_(buffer), buffer, 1, "gtk_entry_buffer_insert_text", "GtkEntryBuffer*");
  Xen_check_type(Xen_is_guint(position), position, 2, "gtk_entry_buffer_insert_text", "guint");
  Xen_check_type(Xen_is_gchar_(chars), chars, 3, "gtk_entry_buffer_insert_text", "gchar*");
  Xen_check_type(Xen_is_gint(n_chars), n_chars, 4, "gtk_entry_buffer_insert_text", "gint");
  return(C_to_Xen_guint(gtk_entry_buffer_insert_text(Xen_to_C_GtkEntryBuffer_(buffer), Xen_to_C_guint(position), Xen_to_C_gchar_(chars), 
                                                     Xen_to_C_gint(n_chars))));
}

static Xen gxg_gtk_entry_buffer_delete_text(Xen buffer, Xen position, Xen n_chars)
{
  #define H_gtk_entry_buffer_delete_text "guint gtk_entry_buffer_delete_text(GtkEntryBuffer* buffer, \
guint position, gint n_chars)"
  Xen_check_type(Xen_is_GtkEntryBuffer_(buffer), buffer, 1, "gtk_entry_buffer_delete_text", "GtkEntryBuffer*");
  Xen_check_type(Xen_is_guint(position), position, 2, "gtk_entry_buffer_delete_text", "guint");
  Xen_check_type(Xen_is_gint(n_chars), n_chars, 3, "gtk_entry_buffer_delete_text", "gint");
  return(C_to_Xen_guint(gtk_entry_buffer_delete_text(Xen_to_C_GtkEntryBuffer_(buffer), Xen_to_C_guint(position), Xen_to_C_gint(n_chars))));
}

static Xen gxg_gtk_entry_buffer_emit_inserted_text(Xen buffer, Xen position, Xen chars, Xen n_chars)
{
  #define H_gtk_entry_buffer_emit_inserted_text "void gtk_entry_buffer_emit_inserted_text(GtkEntryBuffer* buffer, \
guint position, gchar* chars, guint n_chars)"
  Xen_check_type(Xen_is_GtkEntryBuffer_(buffer), buffer, 1, "gtk_entry_buffer_emit_inserted_text", "GtkEntryBuffer*");
  Xen_check_type(Xen_is_guint(position), position, 2, "gtk_entry_buffer_emit_inserted_text", "guint");
  Xen_check_type(Xen_is_gchar_(chars), chars, 3, "gtk_entry_buffer_emit_inserted_text", "gchar*");
  Xen_check_type(Xen_is_guint(n_chars), n_chars, 4, "gtk_entry_buffer_emit_inserted_text", "guint");
  gtk_entry_buffer_emit_inserted_text(Xen_to_C_GtkEntryBuffer_(buffer), Xen_to_C_guint(position), Xen_to_C_gchar_(chars), 
                                      Xen_to_C_guint(n_chars));
  return(Xen_false);
}

static Xen gxg_gtk_entry_buffer_emit_deleted_text(Xen buffer, Xen position, Xen n_chars)
{
  #define H_gtk_entry_buffer_emit_deleted_text "void gtk_entry_buffer_emit_deleted_text(GtkEntryBuffer* buffer, \
guint position, guint n_chars)"
  Xen_check_type(Xen_is_GtkEntryBuffer_(buffer), buffer, 1, "gtk_entry_buffer_emit_deleted_text", "GtkEntryBuffer*");
  Xen_check_type(Xen_is_guint(position), position, 2, "gtk_entry_buffer_emit_deleted_text", "guint");
  Xen_check_type(Xen_is_guint(n_chars), n_chars, 3, "gtk_entry_buffer_emit_deleted_text", "guint");
  gtk_entry_buffer_emit_deleted_text(Xen_to_C_GtkEntryBuffer_(buffer), Xen_to_C_guint(position), Xen_to_C_guint(n_chars));
  return(Xen_false);
}

static Xen gxg_gtk_cell_renderer_set_alignment(Xen cell, Xen xalign, Xen yalign)
{
  #define H_gtk_cell_renderer_set_alignment "void gtk_cell_renderer_set_alignment(GtkCellRenderer* cell, \
gfloat xalign, gfloat yalign)"
  Xen_check_type(Xen_is_GtkCellRenderer_(cell), cell, 1, "gtk_cell_renderer_set_alignment", "GtkCellRenderer*");
  Xen_check_type(Xen_is_gfloat(xalign), xalign, 2, "gtk_cell_renderer_set_alignment", "gfloat");
  Xen_check_type(Xen_is_gfloat(yalign), yalign, 3, "gtk_cell_renderer_set_alignment", "gfloat");
  gtk_cell_renderer_set_alignment(Xen_to_C_GtkCellRenderer_(cell), Xen_to_C_gfloat(xalign), Xen_to_C_gfloat(yalign));
  return(Xen_false);
}

static Xen gxg_gtk_cell_renderer_get_alignment(Xen cell, Xen ignore_xalign, Xen ignore_yalign)
{
  #define H_gtk_cell_renderer_get_alignment "void gtk_cell_renderer_get_alignment(GtkCellRenderer* cell, \
gfloat* [xalign], gfloat* [yalign])"
  gfloat ref_xalign;
  gfloat ref_yalign;
  Xen_check_type(Xen_is_GtkCellRenderer_(cell), cell, 1, "gtk_cell_renderer_get_alignment", "GtkCellRenderer*");
  gtk_cell_renderer_get_alignment(Xen_to_C_GtkCellRenderer_(cell), &ref_xalign, &ref_yalign);
  return(Xen_list_2(C_to_Xen_gfloat(ref_xalign), C_to_Xen_gfloat(ref_yalign)));
}

static Xen gxg_gtk_cell_renderer_set_padding(Xen cell, Xen xpad, Xen ypad)
{
  #define H_gtk_cell_renderer_set_padding "void gtk_cell_renderer_set_padding(GtkCellRenderer* cell, \
gint xpad, gint ypad)"
  Xen_check_type(Xen_is_GtkCellRenderer_(cell), cell, 1, "gtk_cell_renderer_set_padding", "GtkCellRenderer*");
  Xen_check_type(Xen_is_gint(xpad), xpad, 2, "gtk_cell_renderer_set_padding", "gint");
  Xen_check_type(Xen_is_gint(ypad), ypad, 3, "gtk_cell_renderer_set_padding", "gint");
  gtk_cell_renderer_set_padding(Xen_to_C_GtkCellRenderer_(cell), Xen_to_C_gint(xpad), Xen_to_C_gint(ypad));
  return(Xen_false);
}

static Xen gxg_gtk_cell_renderer_get_padding(Xen cell, Xen ignore_xpad, Xen ignore_ypad)
{
  #define H_gtk_cell_renderer_get_padding "void gtk_cell_renderer_get_padding(GtkCellRenderer* cell, \
gint* [xpad], gint* [ypad])"
  gint ref_xpad;
  gint ref_ypad;
  Xen_check_type(Xen_is_GtkCellRenderer_(cell), cell, 1, "gtk_cell_renderer_get_padding", "GtkCellRenderer*");
  gtk_cell_renderer_get_padding(Xen_to_C_GtkCellRenderer_(cell), &ref_xpad, &ref_ypad);
  return(Xen_list_2(C_to_Xen_gint(ref_xpad), C_to_Xen_gint(ref_ypad)));
}

static Xen gxg_gtk_cell_renderer_set_visible(Xen cell, Xen visible)
{
  #define H_gtk_cell_renderer_set_visible "void gtk_cell_renderer_set_visible(GtkCellRenderer* cell, \
gboolean visible)"
  Xen_check_type(Xen_is_GtkCellRenderer_(cell), cell, 1, "gtk_cell_renderer_set_visible", "GtkCellRenderer*");
  Xen_check_type(Xen_is_gboolean(visible), visible, 2, "gtk_cell_renderer_set_visible", "gboolean");
  gtk_cell_renderer_set_visible(Xen_to_C_GtkCellRenderer_(cell), Xen_to_C_gboolean(visible));
  return(Xen_false);
}

static Xen gxg_gtk_cell_renderer_get_visible(Xen cell)
{
  #define H_gtk_cell_renderer_get_visible "gboolean gtk_cell_renderer_get_visible(GtkCellRenderer* cell)"
  Xen_check_type(Xen_is_GtkCellRenderer_(cell), cell, 1, "gtk_cell_renderer_get_visible", "GtkCellRenderer*");
  return(C_to_Xen_gboolean(gtk_cell_renderer_get_visible(Xen_to_C_GtkCellRenderer_(cell))));
}

static Xen gxg_gtk_cell_renderer_set_sensitive(Xen cell, Xen sensitive)
{
  #define H_gtk_cell_renderer_set_sensitive "void gtk_cell_renderer_set_sensitive(GtkCellRenderer* cell, \
gboolean sensitive)"
  Xen_check_type(Xen_is_GtkCellRenderer_(cell), cell, 1, "gtk_cell_renderer_set_sensitive", "GtkCellRenderer*");
  Xen_check_type(Xen_is_gboolean(sensitive), sensitive, 2, "gtk_cell_renderer_set_sensitive", "gboolean");
  gtk_cell_renderer_set_sensitive(Xen_to_C_GtkCellRenderer_(cell), Xen_to_C_gboolean(sensitive));
  return(Xen_false);
}

static Xen gxg_gtk_cell_renderer_get_sensitive(Xen cell)
{
  #define H_gtk_cell_renderer_get_sensitive "gboolean gtk_cell_renderer_get_sensitive(GtkCellRenderer* cell)"
  Xen_check_type(Xen_is_GtkCellRenderer_(cell), cell, 1, "gtk_cell_renderer_get_sensitive", "GtkCellRenderer*");
  return(C_to_Xen_gboolean(gtk_cell_renderer_get_sensitive(Xen_to_C_GtkCellRenderer_(cell))));
}

static Xen gxg_gtk_cell_renderer_toggle_get_activatable(Xen toggle)
{
  #define H_gtk_cell_renderer_toggle_get_activatable "gboolean gtk_cell_renderer_toggle_get_activatable(GtkCellRendererToggle* toggle)"
  Xen_check_type(Xen_is_GtkCellRendererToggle_(toggle), toggle, 1, "gtk_cell_renderer_toggle_get_activatable", "GtkCellRendererToggle*");
  return(C_to_Xen_gboolean(gtk_cell_renderer_toggle_get_activatable(Xen_to_C_GtkCellRendererToggle_(toggle))));
}

static Xen gxg_gtk_cell_renderer_toggle_set_activatable(Xen toggle, Xen setting)
{
  #define H_gtk_cell_renderer_toggle_set_activatable "void gtk_cell_renderer_toggle_set_activatable(GtkCellRendererToggle* toggle, \
gboolean setting)"
  Xen_check_type(Xen_is_GtkCellRendererToggle_(toggle), toggle, 1, "gtk_cell_renderer_toggle_set_activatable", "GtkCellRendererToggle*");
  Xen_check_type(Xen_is_gboolean(setting), setting, 2, "gtk_cell_renderer_toggle_set_activatable", "gboolean");
  gtk_cell_renderer_toggle_set_activatable(Xen_to_C_GtkCellRendererToggle_(toggle), Xen_to_C_gboolean(setting));
  return(Xen_false);
}

static Xen gxg_gtk_widget_set_can_focus(Xen widget, Xen can_focus)
{
  #define H_gtk_widget_set_can_focus "void gtk_widget_set_can_focus(GtkWidget* widget, gboolean can_focus)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_set_can_focus", "GtkWidget*");
  Xen_check_type(Xen_is_gboolean(can_focus), can_focus, 2, "gtk_widget_set_can_focus", "gboolean");
  gtk_widget_set_can_focus(Xen_to_C_GtkWidget_(widget), Xen_to_C_gboolean(can_focus));
  return(Xen_false);
}

static Xen gxg_gtk_widget_get_can_focus(Xen widget)
{
  #define H_gtk_widget_get_can_focus "gboolean gtk_widget_get_can_focus(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_get_can_focus", "GtkWidget*");
  return(C_to_Xen_gboolean(gtk_widget_get_can_focus(Xen_to_C_GtkWidget_(widget))));
}

static Xen gxg_gtk_widget_has_focus(Xen widget)
{
  #define H_gtk_widget_has_focus "gboolean gtk_widget_has_focus(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_has_focus", "GtkWidget*");
  return(C_to_Xen_gboolean(gtk_widget_has_focus(Xen_to_C_GtkWidget_(widget))));
}

static Xen gxg_gtk_widget_has_default(Xen widget)
{
  #define H_gtk_widget_has_default "gboolean gtk_widget_has_default(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_has_default", "GtkWidget*");
  return(C_to_Xen_gboolean(gtk_widget_has_default(Xen_to_C_GtkWidget_(widget))));
}

static Xen gxg_gtk_widget_get_sensitive(Xen widget)
{
  #define H_gtk_widget_get_sensitive "gboolean gtk_widget_get_sensitive(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_get_sensitive", "GtkWidget*");
  return(C_to_Xen_gboolean(gtk_widget_get_sensitive(Xen_to_C_GtkWidget_(widget))));
}

static Xen gxg_gtk_widget_is_sensitive(Xen widget)
{
  #define H_gtk_widget_is_sensitive "gboolean gtk_widget_is_sensitive(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_is_sensitive", "GtkWidget*");
  return(C_to_Xen_gboolean(gtk_widget_is_sensitive(Xen_to_C_GtkWidget_(widget))));
}

static Xen gxg_gtk_icon_view_set_item_padding(Xen icon_view, Xen item_padding)
{
  #define H_gtk_icon_view_set_item_padding "void gtk_icon_view_set_item_padding(GtkIconView* icon_view, \
gint item_padding)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_set_item_padding", "GtkIconView*");
  Xen_check_type(Xen_is_gint(item_padding), item_padding, 2, "gtk_icon_view_set_item_padding", "gint");
  gtk_icon_view_set_item_padding(Xen_to_C_GtkIconView_(icon_view), Xen_to_C_gint(item_padding));
  return(Xen_false);
}

static Xen gxg_gtk_icon_view_get_item_padding(Xen icon_view)
{
  #define H_gtk_icon_view_get_item_padding "gint gtk_icon_view_get_item_padding(GtkIconView* icon_view)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_get_item_padding", "GtkIconView*");
  return(C_to_Xen_gint(gtk_icon_view_get_item_padding(Xen_to_C_GtkIconView_(icon_view))));
}

static Xen gxg_gtk_widget_set_visible(Xen widget, Xen visible)
{
  #define H_gtk_widget_set_visible "void gtk_widget_set_visible(GtkWidget* widget, gboolean visible)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_set_visible", "GtkWidget*");
  Xen_check_type(Xen_is_gboolean(visible), visible, 2, "gtk_widget_set_visible", "gboolean");
  gtk_widget_set_visible(Xen_to_C_GtkWidget_(widget), Xen_to_C_gboolean(visible));
  return(Xen_false);
}

static Xen gxg_gtk_widget_get_visible(Xen widget)
{
  #define H_gtk_widget_get_visible "gboolean gtk_widget_get_visible(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_get_visible", "GtkWidget*");
  return(C_to_Xen_gboolean(gtk_widget_get_visible(Xen_to_C_GtkWidget_(widget))));
}

static Xen gxg_gtk_range_set_flippable(Xen range, Xen flippable)
{
  #define H_gtk_range_set_flippable "void gtk_range_set_flippable(GtkRange* range, gboolean flippable)"
  Xen_check_type(Xen_is_GtkRange_(range), range, 1, "gtk_range_set_flippable", "GtkRange*");
  Xen_check_type(Xen_is_gboolean(flippable), flippable, 2, "gtk_range_set_flippable", "gboolean");
  gtk_range_set_flippable(Xen_to_C_GtkRange_(range), Xen_to_C_gboolean(flippable));
  return(Xen_false);
}

static Xen gxg_gtk_range_get_flippable(Xen range)
{
  #define H_gtk_range_get_flippable "gboolean gtk_range_get_flippable(GtkRange* range)"
  Xen_check_type(Xen_is_GtkRange_(range), range, 1, "gtk_range_get_flippable", "GtkRange*");
  return(C_to_Xen_gboolean(gtk_range_get_flippable(Xen_to_C_GtkRange_(range))));
}

static Xen gxg_gtk_widget_is_drawable(Xen widget)
{
  #define H_gtk_widget_is_drawable "gboolean gtk_widget_is_drawable(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_is_drawable", "GtkWidget*");
  return(C_to_Xen_gboolean(gtk_widget_is_drawable(Xen_to_C_GtkWidget_(widget))));
}

static Xen gxg_gtk_widget_set_receives_default(Xen widget, Xen receives_default)
{
  #define H_gtk_widget_set_receives_default "void gtk_widget_set_receives_default(GtkWidget* widget, \
gboolean receives_default)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_set_receives_default", "GtkWidget*");
  Xen_check_type(Xen_is_gboolean(receives_default), receives_default, 2, "gtk_widget_set_receives_default", "gboolean");
  gtk_widget_set_receives_default(Xen_to_C_GtkWidget_(widget), Xen_to_C_gboolean(receives_default));
  return(Xen_false);
}

static Xen gxg_gtk_widget_get_receives_default(Xen widget)
{
  #define H_gtk_widget_get_receives_default "gboolean gtk_widget_get_receives_default(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_get_receives_default", "GtkWidget*");
  return(C_to_Xen_gboolean(gtk_widget_get_receives_default(Xen_to_C_GtkWidget_(widget))));
}

static Xen gxg_gtk_dialog_get_widget_for_response(Xen dialog, Xen response_id)
{
  #define H_gtk_dialog_get_widget_for_response "GtkWidget* gtk_dialog_get_widget_for_response(GtkDialog* dialog, \
gint response_id)"
  Xen_check_type(Xen_is_GtkDialog_(dialog), dialog, 1, "gtk_dialog_get_widget_for_response", "GtkDialog*");
  Xen_check_type(Xen_is_gint(response_id), response_id, 2, "gtk_dialog_get_widget_for_response", "gint");
  return(C_to_Xen_GtkWidget_(gtk_dialog_get_widget_for_response(Xen_to_C_GtkDialog_(dialog), Xen_to_C_gint(response_id))));
}

static Xen gxg_gtk_spinner_new(void)
{
  #define H_gtk_spinner_new "GtkWidget* gtk_spinner_new( void)"
  return(C_to_Xen_GtkWidget_(gtk_spinner_new()));
}

static Xen gxg_gtk_spinner_start(Xen spinner)
{
  #define H_gtk_spinner_start "void gtk_spinner_start(GtkSpinner* spinner)"
  Xen_check_type(Xen_is_GtkSpinner_(spinner), spinner, 1, "gtk_spinner_start", "GtkSpinner*");
  gtk_spinner_start(Xen_to_C_GtkSpinner_(spinner));
  return(Xen_false);
}

static Xen gxg_gtk_spinner_stop(Xen spinner)
{
  #define H_gtk_spinner_stop "void gtk_spinner_stop(GtkSpinner* spinner)"
  Xen_check_type(Xen_is_GtkSpinner_(spinner), spinner, 1, "gtk_spinner_stop", "GtkSpinner*");
  gtk_spinner_stop(Xen_to_C_GtkSpinner_(spinner));
  return(Xen_false);
}

static Xen gxg_gtk_cell_renderer_spinner_new(void)
{
  #define H_gtk_cell_renderer_spinner_new "GtkCellRenderer* gtk_cell_renderer_spinner_new( void)"
  return(C_to_Xen_GtkCellRenderer_(gtk_cell_renderer_spinner_new()));
}

static Xen gxg_gtk_notebook_get_action_widget(Xen notebook, Xen pack_type)
{
  #define H_gtk_notebook_get_action_widget "GtkWidget* gtk_notebook_get_action_widget(GtkNotebook* notebook, \
GtkPackType pack_type)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_get_action_widget", "GtkNotebook*");
  Xen_check_type(Xen_is_GtkPackType(pack_type), pack_type, 2, "gtk_notebook_get_action_widget", "GtkPackType");
  return(C_to_Xen_GtkWidget_(gtk_notebook_get_action_widget(Xen_to_C_GtkNotebook_(notebook), Xen_to_C_GtkPackType(pack_type))));
}

static Xen gxg_gtk_notebook_set_action_widget(Xen notebook, Xen widget, Xen pack_type)
{
  #define H_gtk_notebook_set_action_widget "void gtk_notebook_set_action_widget(GtkNotebook* notebook, \
GtkWidget* widget, GtkPackType pack_type)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_set_action_widget", "GtkNotebook*");
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 2, "gtk_notebook_set_action_widget", "GtkWidget*");
  Xen_check_type(Xen_is_GtkPackType(pack_type), pack_type, 3, "gtk_notebook_set_action_widget", "GtkPackType");
  gtk_notebook_set_action_widget(Xen_to_C_GtkNotebook_(notebook), Xen_to_C_GtkWidget_(widget), Xen_to_C_GtkPackType(pack_type));
  return(Xen_false);
}

static Xen gxg_gtk_window_set_mnemonics_visible(Xen window, Xen setting)
{
  #define H_gtk_window_set_mnemonics_visible "void gtk_window_set_mnemonics_visible(GtkWindow* window, \
gboolean setting)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_set_mnemonics_visible", "GtkWindow*");
  Xen_check_type(Xen_is_gboolean(setting), setting, 2, "gtk_window_set_mnemonics_visible", "gboolean");
  gtk_window_set_mnemonics_visible(Xen_to_C_GtkWindow_(window), Xen_to_C_gboolean(setting));
  return(Xen_false);
}

static Xen gxg_gtk_window_get_mnemonics_visible(Xen window)
{
  #define H_gtk_window_get_mnemonics_visible "gboolean gtk_window_get_mnemonics_visible(GtkWindow* window)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_get_mnemonics_visible", "GtkWindow*");
  return(C_to_Xen_gboolean(gtk_window_get_mnemonics_visible(Xen_to_C_GtkWindow_(window))));
}

static Xen gxg_gtk_range_set_slider_size_fixed(Xen range, Xen size_fixed)
{
  #define H_gtk_range_set_slider_size_fixed "void gtk_range_set_slider_size_fixed(GtkRange* range, gboolean size_fixed)"
  Xen_check_type(Xen_is_GtkRange_(range), range, 1, "gtk_range_set_slider_size_fixed", "GtkRange*");
  Xen_check_type(Xen_is_gboolean(size_fixed), size_fixed, 2, "gtk_range_set_slider_size_fixed", "gboolean");
  gtk_range_set_slider_size_fixed(Xen_to_C_GtkRange_(range), Xen_to_C_gboolean(size_fixed));
  return(Xen_false);
}

static Xen gxg_gtk_range_get_slider_size_fixed(Xen range)
{
  #define H_gtk_range_get_slider_size_fixed "gboolean gtk_range_get_slider_size_fixed(GtkRange* range)"
  Xen_check_type(Xen_is_GtkRange_(range), range, 1, "gtk_range_get_slider_size_fixed", "GtkRange*");
  return(C_to_Xen_gboolean(gtk_range_get_slider_size_fixed(Xen_to_C_GtkRange_(range))));
}

static Xen gxg_gtk_range_get_range_rect(Xen range, Xen range_rect)
{
  #define H_gtk_range_get_range_rect "void gtk_range_get_range_rect(GtkRange* range, GdkRectangle* range_rect)"
  Xen_check_type(Xen_is_GtkRange_(range), range, 1, "gtk_range_get_range_rect", "GtkRange*");
  Xen_check_type(Xen_is_GdkRectangle_(range_rect), range_rect, 2, "gtk_range_get_range_rect", "GdkRectangle*");
  gtk_range_get_range_rect(Xen_to_C_GtkRange_(range), Xen_to_C_GdkRectangle_(range_rect));
  return(Xen_false);
}

static Xen gxg_gtk_range_get_slider_range(Xen range, Xen ignore_slider_start, Xen ignore_slider_end)
{
  #define H_gtk_range_get_slider_range "void gtk_range_get_slider_range(GtkRange* range, gint* [slider_start], \
gint* [slider_end])"
  gint ref_slider_start;
  gint ref_slider_end;
  Xen_check_type(Xen_is_GtkRange_(range), range, 1, "gtk_range_get_slider_range", "GtkRange*");
  gtk_range_get_slider_range(Xen_to_C_GtkRange_(range), &ref_slider_start, &ref_slider_end);
  return(Xen_list_2(C_to_Xen_gint(ref_slider_start), C_to_Xen_gint(ref_slider_end)));
}

static Xen gxg_gtk_widget_get_realized(Xen widget)
{
  #define H_gtk_widget_get_realized "gboolean gtk_widget_get_realized(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_get_realized", "GtkWidget*");
  return(C_to_Xen_gboolean(gtk_widget_get_realized(Xen_to_C_GtkWidget_(widget))));
}

static Xen gxg_gtk_widget_get_mapped(Xen widget)
{
  #define H_gtk_widget_get_mapped "gboolean gtk_widget_get_mapped(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_get_mapped", "GtkWidget*");
  return(C_to_Xen_gboolean(gtk_widget_get_mapped(Xen_to_C_GtkWidget_(widget))));
}

#if GTK_CHECK_VERSION(3, 0, 0)
static Xen gxg_gtk_accessible_get_widget(Xen accessible)
{
  #define H_gtk_accessible_get_widget "GtkWidget* gtk_accessible_get_widget(GtkAccessible* accessible)"
  Xen_check_type(Xen_is_GtkAccessible_(accessible), accessible, 1, "gtk_accessible_get_widget", "GtkAccessible*");
  return(C_to_Xen_GtkWidget_(gtk_accessible_get_widget(Xen_to_C_GtkAccessible_(accessible))));
}

static Xen gxg_gdk_event_get_device(Xen event)
{
  #define H_gdk_event_get_device "GdkDevice* gdk_event_get_device(GdkEvent* event)"
  Xen_check_type(Xen_is_GdkEvent_(event), event, 1, "gdk_event_get_device", "GdkEvent*");
  return(C_to_Xen_GdkDevice_(gdk_event_get_device(Xen_to_C_GdkEvent_(event))));
}

static Xen gxg_gdk_events_get_distance(Xen event1, Xen event2, Xen ignore_distance)
{
  #define H_gdk_events_get_distance "gboolean gdk_events_get_distance(GdkEvent* event1, GdkEvent* event2, \
gdouble* [distance])"
  gdouble ref_distance;
  Xen_check_type(Xen_is_GdkEvent_(event1), event1, 1, "gdk_events_get_distance", "GdkEvent*");
  Xen_check_type(Xen_is_GdkEvent_(event2), event2, 2, "gdk_events_get_distance", "GdkEvent*");
  {
    Xen res_ult;
    res_ult = C_to_Xen_gboolean(gdk_events_get_distance(Xen_to_C_GdkEvent_(event1), Xen_to_C_GdkEvent_(event2), &ref_distance));
    return(Xen_list_2(res_ult, C_to_Xen_gdouble(ref_distance)));
   }
}

static Xen gxg_gdk_events_get_angle(Xen event1, Xen event2, Xen ignore_angle)
{
  #define H_gdk_events_get_angle "gboolean gdk_events_get_angle(GdkEvent* event1, GdkEvent* event2, gdouble* [angle])"
  gdouble ref_angle;
  Xen_check_type(Xen_is_GdkEvent_(event1), event1, 1, "gdk_events_get_angle", "GdkEvent*");
  Xen_check_type(Xen_is_GdkEvent_(event2), event2, 2, "gdk_events_get_angle", "GdkEvent*");
  {
    Xen res_ult;
    res_ult = C_to_Xen_gboolean(gdk_events_get_angle(Xen_to_C_GdkEvent_(event1), Xen_to_C_GdkEvent_(event2), &ref_angle));
    return(Xen_list_2(res_ult, C_to_Xen_gdouble(ref_angle)));
   }
}

static Xen gxg_gdk_events_get_center(Xen event1, Xen event2, Xen ignore_x, Xen ignore_y)
{
  #define H_gdk_events_get_center "gboolean gdk_events_get_center(GdkEvent* event1, GdkEvent* event2, \
gdouble* [x], gdouble* [y])"
  gdouble ref_x;
  gdouble ref_y;
  Xen_check_type(Xen_is_GdkEvent_(event1), event1, 1, "gdk_events_get_center", "GdkEvent*");
  Xen_check_type(Xen_is_GdkEvent_(event2), event2, 2, "gdk_events_get_center", "GdkEvent*");
  {
    Xen res_ult;
    res_ult = C_to_Xen_gboolean(gdk_events_get_center(Xen_to_C_GdkEvent_(event1), Xen_to_C_GdkEvent_(event2), &ref_x, &ref_y));
    return(Xen_list_3(res_ult, C_to_Xen_gdouble(ref_x), C_to_Xen_gdouble(ref_y)));
   }
}

static Xen gxg_gtk_combo_box_popup_for_device(Xen combo_box, Xen device)
{
  #define H_gtk_combo_box_popup_for_device "void gtk_combo_box_popup_for_device(GtkComboBox* combo_box, \
GdkDevice* device)"
  Xen_check_type(Xen_is_GtkComboBox_(combo_box), combo_box, 1, "gtk_combo_box_popup_for_device", "GtkComboBox*");
  Xen_check_type(Xen_is_GdkDevice_(device), device, 2, "gtk_combo_box_popup_for_device", "GdkDevice*");
  gtk_combo_box_popup_for_device(Xen_to_C_GtkComboBox_(combo_box), Xen_to_C_GdkDevice_(device));
  return(Xen_false);
}

static Xen gxg_gtk_paned_new(Xen orientation)
{
  #define H_gtk_paned_new "GtkWidget* gtk_paned_new(GtkOrientation orientation)"
  Xen_check_type(Xen_is_GtkOrientation(orientation), orientation, 1, "gtk_paned_new", "GtkOrientation");
  return(C_to_Xen_GtkWidget_(gtk_paned_new(Xen_to_C_GtkOrientation(orientation))));
}

static Xen gxg_gtk_scale_new(Xen orientation, Xen adjustment)
{
  #define H_gtk_scale_new "GtkWidget* gtk_scale_new(GtkOrientation orientation, GtkAdjustment* adjustment)"
  Xen_check_type(Xen_is_GtkOrientation(orientation), orientation, 1, "gtk_scale_new", "GtkOrientation");
  Xen_check_type(Xen_is_GtkAdjustment_(adjustment), adjustment, 2, "gtk_scale_new", "GtkAdjustment*");
  return(C_to_Xen_GtkWidget_(gtk_scale_new(Xen_to_C_GtkOrientation(orientation), Xen_to_C_GtkAdjustment_(adjustment))));
}

static Xen gxg_gtk_scale_new_with_range(Xen orientation, Xen min, Xen max, Xen step)
{
  #define H_gtk_scale_new_with_range "GtkWidget* gtk_scale_new_with_range(GtkOrientation orientation, \
gdouble min, gdouble max, gdouble step)"
  Xen_check_type(Xen_is_GtkOrientation(orientation), orientation, 1, "gtk_scale_new_with_range", "GtkOrientation");
  Xen_check_type(Xen_is_gdouble(min), min, 2, "gtk_scale_new_with_range", "gdouble");
  Xen_check_type(Xen_is_gdouble(max), max, 3, "gtk_scale_new_with_range", "gdouble");
  Xen_check_type(Xen_is_gdouble(step), step, 4, "gtk_scale_new_with_range", "gdouble");
  return(C_to_Xen_GtkWidget_(gtk_scale_new_with_range(Xen_to_C_GtkOrientation(orientation), Xen_to_C_gdouble(min), Xen_to_C_gdouble(max), 
                                                      Xen_to_C_gdouble(step))));
}

static Xen gxg_gtk_scrollbar_new(Xen orientation, Xen adjustment)
{
  #define H_gtk_scrollbar_new "GtkWidget* gtk_scrollbar_new(GtkOrientation orientation, GtkAdjustment* adjustment)"
  Xen_check_type(Xen_is_GtkOrientation(orientation), orientation, 1, "gtk_scrollbar_new", "GtkOrientation");
  Xen_check_type(Xen_is_GtkAdjustment_(adjustment), adjustment, 2, "gtk_scrollbar_new", "GtkAdjustment*");
  return(C_to_Xen_GtkWidget_(gtk_scrollbar_new(Xen_to_C_GtkOrientation(orientation), Xen_to_C_GtkAdjustment_(adjustment))));
}

static Xen gxg_gtk_separator_new(Xen orientation)
{
  #define H_gtk_separator_new "GtkWidget* gtk_separator_new(GtkOrientation orientation)"
  Xen_check_type(Xen_is_GtkOrientation(orientation), orientation, 1, "gtk_separator_new", "GtkOrientation");
  return(C_to_Xen_GtkWidget_(gtk_separator_new(Xen_to_C_GtkOrientation(orientation))));
}

static Xen gxg_gtk_widget_device_is_shadowed(Xen widget, Xen device)
{
  #define H_gtk_widget_device_is_shadowed "gboolean gtk_widget_device_is_shadowed(GtkWidget* widget, \
GdkDevice* device)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_device_is_shadowed", "GtkWidget*");
  Xen_check_type(Xen_is_GdkDevice_(device), device, 2, "gtk_widget_device_is_shadowed", "GdkDevice*");
  return(C_to_Xen_gboolean(gtk_widget_device_is_shadowed(Xen_to_C_GtkWidget_(widget), Xen_to_C_GdkDevice_(device))));
}

static Xen gxg_gtk_widget_get_support_multidevice(Xen widget)
{
  #define H_gtk_widget_get_support_multidevice "gboolean gtk_widget_get_support_multidevice(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_get_support_multidevice", "GtkWidget*");
  return(C_to_Xen_gboolean(gtk_widget_get_support_multidevice(Xen_to_C_GtkWidget_(widget))));
}

static Xen gxg_gtk_widget_set_support_multidevice(Xen widget, Xen support_multidevice)
{
  #define H_gtk_widget_set_support_multidevice "void gtk_widget_set_support_multidevice(GtkWidget* widget, \
gboolean support_multidevice)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_set_support_multidevice", "GtkWidget*");
  Xen_check_type(Xen_is_gboolean(support_multidevice), support_multidevice, 2, "gtk_widget_set_support_multidevice", "gboolean");
  gtk_widget_set_support_multidevice(Xen_to_C_GtkWidget_(widget), Xen_to_C_gboolean(support_multidevice));
  return(Xen_false);
}

static Xen gxg_gtk_icon_view_get_item_row(Xen icon_view, Xen path)
{
  #define H_gtk_icon_view_get_item_row "gint gtk_icon_view_get_item_row(GtkIconView* icon_view, GtkTreePath* path)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_get_item_row", "GtkIconView*");
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 2, "gtk_icon_view_get_item_row", "GtkTreePath*");
  return(C_to_Xen_gint(gtk_icon_view_get_item_row(Xen_to_C_GtkIconView_(icon_view), Xen_to_C_GtkTreePath_(path))));
}

static Xen gxg_gtk_icon_view_get_item_column(Xen icon_view, Xen path)
{
  #define H_gtk_icon_view_get_item_column "gint gtk_icon_view_get_item_column(GtkIconView* icon_view, \
GtkTreePath* path)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_get_item_column", "GtkIconView*");
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 2, "gtk_icon_view_get_item_column", "GtkTreePath*");
  return(C_to_Xen_gint(gtk_icon_view_get_item_column(Xen_to_C_GtkIconView_(icon_view), Xen_to_C_GtkTreePath_(path))));
}

static Xen gxg_gtk_statusbar_remove_all(Xen statusbar, Xen context_id)
{
  #define H_gtk_statusbar_remove_all "void gtk_statusbar_remove_all(GtkStatusbar* statusbar, guint context_id)"
  Xen_check_type(Xen_is_GtkStatusbar_(statusbar), statusbar, 1, "gtk_statusbar_remove_all", "GtkStatusbar*");
  Xen_check_type(Xen_is_guint(context_id), context_id, 2, "gtk_statusbar_remove_all", "guint");
  gtk_statusbar_remove_all(Xen_to_C_GtkStatusbar_(statusbar), Xen_to_C_guint(context_id));
  return(Xen_false);
}

static Xen gxg_gtk_window_has_group(Xen window)
{
  #define H_gtk_window_has_group "gboolean gtk_window_has_group(GtkWindow* window)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_has_group", "GtkWindow*");
  return(C_to_Xen_gboolean(gtk_window_has_group(Xen_to_C_GtkWindow_(window))));
}

static Xen gxg_gtk_calendar_mark_day(Xen calendar, Xen day)
{
  #define H_gtk_calendar_mark_day "void gtk_calendar_mark_day(GtkCalendar* calendar, guint day)"
  Xen_check_type(Xen_is_GtkCalendar_(calendar), calendar, 1, "gtk_calendar_mark_day", "GtkCalendar*");
  Xen_check_type(Xen_is_guint(day), day, 2, "gtk_calendar_mark_day", "guint");
  gtk_calendar_mark_day(Xen_to_C_GtkCalendar_(calendar), Xen_to_C_guint(day));
  return(Xen_false);
}

static Xen gxg_gtk_calendar_unmark_day(Xen calendar, Xen day)
{
  #define H_gtk_calendar_unmark_day "void gtk_calendar_unmark_day(GtkCalendar* calendar, guint day)"
  Xen_check_type(Xen_is_GtkCalendar_(calendar), calendar, 1, "gtk_calendar_unmark_day", "GtkCalendar*");
  Xen_check_type(Xen_is_guint(day), day, 2, "gtk_calendar_unmark_day", "guint");
  gtk_calendar_unmark_day(Xen_to_C_GtkCalendar_(calendar), Xen_to_C_guint(day));
  return(Xen_false);
}

static Xen gxg_gtk_accessible_set_widget(Xen accessible, Xen widget)
{
  #define H_gtk_accessible_set_widget "void gtk_accessible_set_widget(GtkAccessible* accessible, GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkAccessible_(accessible), accessible, 1, "gtk_accessible_set_widget", "GtkAccessible*");
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 2, "gtk_accessible_set_widget", "GtkWidget*");
  gtk_accessible_set_widget(Xen_to_C_GtkAccessible_(accessible), Xen_to_C_GtkWidget_(widget));
  return(Xen_false);
}

static Xen gxg_gtk_message_dialog_get_message_area(Xen message_dialog)
{
  #define H_gtk_message_dialog_get_message_area "GtkWidget* gtk_message_dialog_get_message_area(GtkMessageDialog* message_dialog)"
  Xen_check_type(Xen_is_GtkMessageDialog_(message_dialog), message_dialog, 1, "gtk_message_dialog_get_message_area", "GtkMessageDialog*");
  return(C_to_Xen_GtkWidget_(gtk_message_dialog_get_message_area(Xen_to_C_GtkMessageDialog_(message_dialog))));
}

static Xen gxg_gdk_pango_layout_line_get_clip_region(Xen line, Xen x_origin, Xen y_origin, Xen index_ranges, Xen n_ranges)
{
  #define H_gdk_pango_layout_line_get_clip_region "cairo_region_t* gdk_pango_layout_line_get_clip_region(PangoLayoutLine* line, \
gint x_origin, gint y_origin, gint* index_ranges, gint n_ranges)"
  Xen_check_type(Xen_is_PangoLayoutLine_(line), line, 1, "gdk_pango_layout_line_get_clip_region", "PangoLayoutLine*");
  Xen_check_type(Xen_is_gint(x_origin), x_origin, 2, "gdk_pango_layout_line_get_clip_region", "gint");
  Xen_check_type(Xen_is_gint(y_origin), y_origin, 3, "gdk_pango_layout_line_get_clip_region", "gint");
  Xen_check_type(Xen_is_gint_(index_ranges), index_ranges, 4, "gdk_pango_layout_line_get_clip_region", "gint*");
  Xen_check_type(Xen_is_gint(n_ranges), n_ranges, 5, "gdk_pango_layout_line_get_clip_region", "gint");
  return(C_to_Xen_cairo_region_t_(gdk_pango_layout_line_get_clip_region(Xen_to_C_PangoLayoutLine_(line), Xen_to_C_gint(x_origin), 
                                                                        Xen_to_C_gint(y_origin), Xen_to_C_gint_(index_ranges), 
                                                                        Xen_to_C_gint(n_ranges))));
}

static Xen gxg_gdk_pango_layout_get_clip_region(Xen layout, Xen x_origin, Xen y_origin, Xen index_ranges, Xen n_ranges)
{
  #define H_gdk_pango_layout_get_clip_region "cairo_region_t* gdk_pango_layout_get_clip_region(PangoLayout* layout, \
gint x_origin, gint y_origin, gint* index_ranges, gint n_ranges)"
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "gdk_pango_layout_get_clip_region", "PangoLayout*");
  Xen_check_type(Xen_is_gint(x_origin), x_origin, 2, "gdk_pango_layout_get_clip_region", "gint");
  Xen_check_type(Xen_is_gint(y_origin), y_origin, 3, "gdk_pango_layout_get_clip_region", "gint");
  Xen_check_type(Xen_is_gint_(index_ranges), index_ranges, 4, "gdk_pango_layout_get_clip_region", "gint*");
  Xen_check_type(Xen_is_gint(n_ranges), n_ranges, 5, "gdk_pango_layout_get_clip_region", "gint");
  return(C_to_Xen_cairo_region_t_(gdk_pango_layout_get_clip_region(Xen_to_C_PangoLayout_(layout), Xen_to_C_gint(x_origin), 
                                                                   Xen_to_C_gint(y_origin), Xen_to_C_gint_(index_ranges), 
                                                                   Xen_to_C_gint(n_ranges))));
}

static Xen gxg_gdk_display_is_closed(Xen display)
{
  #define H_gdk_display_is_closed "gboolean gdk_display_is_closed(GdkDisplay* display)"
  Xen_check_type(Xen_is_GdkDisplay_(display), display, 1, "gdk_display_is_closed", "GdkDisplay*");
  return(C_to_Xen_gboolean(gdk_display_is_closed(Xen_to_C_GdkDisplay_(display))));
}

static Xen gxg_gtk_calendar_get_day_is_marked(Xen calendar, Xen day)
{
  #define H_gtk_calendar_get_day_is_marked "gboolean gtk_calendar_get_day_is_marked(GtkCalendar* calendar, \
guint day)"
  Xen_check_type(Xen_is_GtkCalendar_(calendar), calendar, 1, "gtk_calendar_get_day_is_marked", "GtkCalendar*");
  Xen_check_type(Xen_is_guint(day), day, 2, "gtk_calendar_get_day_is_marked", "guint");
  return(C_to_Xen_gboolean(gtk_calendar_get_day_is_marked(Xen_to_C_GtkCalendar_(calendar), Xen_to_C_guint(day))));
}

static Xen gxg_gtk_progress_bar_set_inverted(Xen pbar, Xen inverted)
{
  #define H_gtk_progress_bar_set_inverted "void gtk_progress_bar_set_inverted(GtkProgressBar* pbar, gboolean inverted)"
  Xen_check_type(Xen_is_GtkProgressBar_(pbar), pbar, 1, "gtk_progress_bar_set_inverted", "GtkProgressBar*");
  Xen_check_type(Xen_is_gboolean(inverted), inverted, 2, "gtk_progress_bar_set_inverted", "gboolean");
  gtk_progress_bar_set_inverted(Xen_to_C_GtkProgressBar_(pbar), Xen_to_C_gboolean(inverted));
  return(Xen_false);
}

static Xen gxg_gtk_progress_bar_get_inverted(Xen pbar)
{
  #define H_gtk_progress_bar_get_inverted "gboolean gtk_progress_bar_get_inverted(GtkProgressBar* pbar)"
  Xen_check_type(Xen_is_GtkProgressBar_(pbar), pbar, 1, "gtk_progress_bar_get_inverted", "GtkProgressBar*");
  return(C_to_Xen_gboolean(gtk_progress_bar_get_inverted(Xen_to_C_GtkProgressBar_(pbar))));
}

static Xen gxg_gtk_radio_button_join_group(Xen radio_button, Xen group_source)
{
  #define H_gtk_radio_button_join_group "void gtk_radio_button_join_group(GtkRadioButton* radio_button, \
GtkRadioButton* group_source)"
  Xen_check_type(Xen_is_GtkRadioButton_(radio_button), radio_button, 1, "gtk_radio_button_join_group", "GtkRadioButton*");
  Xen_check_type(Xen_is_GtkRadioButton_(group_source), group_source, 2, "gtk_radio_button_join_group", "GtkRadioButton*");
  gtk_radio_button_join_group(Xen_to_C_GtkRadioButton_(radio_button), Xen_to_C_GtkRadioButton_(group_source));
  return(Xen_false);
}

static Xen gxg_gtk_adjustment_new(Xen value, Xen lower, Xen upper, Xen step_increment, Xen page_increment, Xen page_size)
{
  #define H_gtk_adjustment_new "GtkAdjustment* gtk_adjustment_new(gdouble value, gdouble lower, gdouble upper, \
gdouble step_increment, gdouble page_increment, gdouble page_size)"
  Xen_check_type(Xen_is_gdouble(value), value, 1, "gtk_adjustment_new", "gdouble");
  Xen_check_type(Xen_is_gdouble(lower), lower, 2, "gtk_adjustment_new", "gdouble");
  Xen_check_type(Xen_is_gdouble(upper), upper, 3, "gtk_adjustment_new", "gdouble");
  Xen_check_type(Xen_is_gdouble(step_increment), step_increment, 4, "gtk_adjustment_new", "gdouble");
  Xen_check_type(Xen_is_gdouble(page_increment), page_increment, 5, "gtk_adjustment_new", "gdouble");
  Xen_check_type(Xen_is_gdouble(page_size), page_size, 6, "gtk_adjustment_new", "gdouble");
  return(C_to_Xen_GtkAdjustment_(gtk_adjustment_new(Xen_to_C_gdouble(value), Xen_to_C_gdouble(lower), Xen_to_C_gdouble(upper), 
                                                    Xen_to_C_gdouble(step_increment), Xen_to_C_gdouble(page_increment), Xen_to_C_gdouble(page_size))));
}

static Xen gxg_gtk_icon_view_create_drag_icon(Xen icon_view, Xen path)
{
  #define H_gtk_icon_view_create_drag_icon "cairo_surface_t* gtk_icon_view_create_drag_icon(GtkIconView* icon_view, \
GtkTreePath* path)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_create_drag_icon", "GtkIconView*");
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 2, "gtk_icon_view_create_drag_icon", "GtkTreePath*");
  return(C_to_Xen_cairo_surface_t_(gtk_icon_view_create_drag_icon(Xen_to_C_GtkIconView_(icon_view), Xen_to_C_GtkTreePath_(path))));
}

static Xen gxg_gtk_tree_view_create_row_drag_icon(Xen tree_view, Xen path)
{
  #define H_gtk_tree_view_create_row_drag_icon "cairo_surface_t* gtk_tree_view_create_row_drag_icon(GtkTreeView* tree_view, \
GtkTreePath* path)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_create_row_drag_icon", "GtkTreeView*");
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 2, "gtk_tree_view_create_row_drag_icon", "GtkTreePath*");
  return(C_to_Xen_cairo_surface_t_(gtk_tree_view_create_row_drag_icon(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_GtkTreePath_(path))));
}

static Xen gxg_gdk_cairo_region_create_from_surface(Xen surface)
{
  #define H_gdk_cairo_region_create_from_surface "cairo_region_t* gdk_cairo_region_create_from_surface(cairo_surface_t* surface)"
  Xen_check_type(Xen_is_cairo_surface_t_(surface), surface, 1, "gdk_cairo_region_create_from_surface", "cairo_surface_t*");
  return(C_to_Xen_cairo_region_t_(gdk_cairo_region_create_from_surface(Xen_to_C_cairo_surface_t_(surface))));
}

static Xen gxg_gtk_cell_renderer_get_request_mode(Xen cell)
{
  #define H_gtk_cell_renderer_get_request_mode "GtkSizeRequestMode gtk_cell_renderer_get_request_mode(GtkCellRenderer* cell)"
  Xen_check_type(Xen_is_GtkCellRenderer_(cell), cell, 1, "gtk_cell_renderer_get_request_mode", "GtkCellRenderer*");
  return(C_to_Xen_GtkSizeRequestMode(gtk_cell_renderer_get_request_mode(Xen_to_C_GtkCellRenderer_(cell))));
}

static Xen gxg_gtk_cell_renderer_get_preferred_width(Xen cell, Xen widget, Xen ignore_minimum_size, Xen ignore_natural_size)
{
  #define H_gtk_cell_renderer_get_preferred_width "void gtk_cell_renderer_get_preferred_width(GtkCellRenderer* cell, \
GtkWidget* widget, gint* [minimum_size], gint* [natural_size])"
  gint ref_minimum_size;
  gint ref_natural_size;
  Xen_check_type(Xen_is_GtkCellRenderer_(cell), cell, 1, "gtk_cell_renderer_get_preferred_width", "GtkCellRenderer*");
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 2, "gtk_cell_renderer_get_preferred_width", "GtkWidget*");
  gtk_cell_renderer_get_preferred_width(Xen_to_C_GtkCellRenderer_(cell), Xen_to_C_GtkWidget_(widget), &ref_minimum_size, 
                                        &ref_natural_size);
  return(Xen_list_2(C_to_Xen_gint(ref_minimum_size), C_to_Xen_gint(ref_natural_size)));
}

static Xen gxg_gtk_cell_renderer_get_preferred_height_for_width(Xen cell, Xen widget, Xen width, Xen ignore_minimum_height, Xen ignore_natural_height)
{
  #define H_gtk_cell_renderer_get_preferred_height_for_width "void gtk_cell_renderer_get_preferred_height_for_width(GtkCellRenderer* cell, \
GtkWidget* widget, gint width, gint* [minimum_height], gint* [natural_height])"
  gint ref_minimum_height;
  gint ref_natural_height;
  Xen_check_type(Xen_is_GtkCellRenderer_(cell), cell, 1, "gtk_cell_renderer_get_preferred_height_for_width", "GtkCellRenderer*");
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 2, "gtk_cell_renderer_get_preferred_height_for_width", "GtkWidget*");
  Xen_check_type(Xen_is_gint(width), width, 3, "gtk_cell_renderer_get_preferred_height_for_width", "gint");
  gtk_cell_renderer_get_preferred_height_for_width(Xen_to_C_GtkCellRenderer_(cell), Xen_to_C_GtkWidget_(widget), Xen_to_C_gint(width), 
                                                   &ref_minimum_height, &ref_natural_height);
  return(Xen_list_2(C_to_Xen_gint(ref_minimum_height), C_to_Xen_gint(ref_natural_height)));
}

static Xen gxg_gtk_cell_renderer_get_preferred_height(Xen cell, Xen widget, Xen ignore_minimum_size, Xen ignore_natural_size)
{
  #define H_gtk_cell_renderer_get_preferred_height "void gtk_cell_renderer_get_preferred_height(GtkCellRenderer* cell, \
GtkWidget* widget, gint* [minimum_size], gint* [natural_size])"
  gint ref_minimum_size;
  gint ref_natural_size;
  Xen_check_type(Xen_is_GtkCellRenderer_(cell), cell, 1, "gtk_cell_renderer_get_preferred_height", "GtkCellRenderer*");
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 2, "gtk_cell_renderer_get_preferred_height", "GtkWidget*");
  gtk_cell_renderer_get_preferred_height(Xen_to_C_GtkCellRenderer_(cell), Xen_to_C_GtkWidget_(widget), &ref_minimum_size, 
                                         &ref_natural_size);
  return(Xen_list_2(C_to_Xen_gint(ref_minimum_size), C_to_Xen_gint(ref_natural_size)));
}

static Xen gxg_gtk_cell_renderer_get_preferred_width_for_height(Xen cell, Xen widget, Xen height, Xen ignore_minimum_width, Xen ignore_natural_width)
{
  #define H_gtk_cell_renderer_get_preferred_width_for_height "void gtk_cell_renderer_get_preferred_width_for_height(GtkCellRenderer* cell, \
GtkWidget* widget, gint height, gint* [minimum_width], gint* [natural_width])"
  gint ref_minimum_width;
  gint ref_natural_width;
  Xen_check_type(Xen_is_GtkCellRenderer_(cell), cell, 1, "gtk_cell_renderer_get_preferred_width_for_height", "GtkCellRenderer*");
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 2, "gtk_cell_renderer_get_preferred_width_for_height", "GtkWidget*");
  Xen_check_type(Xen_is_gint(height), height, 3, "gtk_cell_renderer_get_preferred_width_for_height", "gint");
  gtk_cell_renderer_get_preferred_width_for_height(Xen_to_C_GtkCellRenderer_(cell), Xen_to_C_GtkWidget_(widget), Xen_to_C_gint(height), 
                                                   &ref_minimum_width, &ref_natural_width);
  return(Xen_list_2(C_to_Xen_gint(ref_minimum_width), C_to_Xen_gint(ref_natural_width)));
}

static Xen gxg_gtk_notebook_set_group_name(Xen notebook, Xen group_name)
{
  #define H_gtk_notebook_set_group_name "void gtk_notebook_set_group_name(GtkNotebook* notebook, gchar* group_name)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_set_group_name", "GtkNotebook*");
  Xen_check_type(Xen_is_gchar_(group_name), group_name, 2, "gtk_notebook_set_group_name", "gchar*");
  gtk_notebook_set_group_name(Xen_to_C_GtkNotebook_(notebook), (const gchar*)Xen_to_C_gchar_(group_name));
  return(Xen_false);
}

static Xen gxg_gtk_notebook_get_group_name(Xen notebook)
{
  #define H_gtk_notebook_get_group_name "gchar* gtk_notebook_get_group_name(GtkNotebook* notebook)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_get_group_name", "GtkNotebook*");
    return(C_to_Xen_gchar_((gchar*)gtk_notebook_get_group_name(Xen_to_C_GtkNotebook_(notebook))));
}

static Xen gxg_gtk_widget_get_request_mode(Xen widget)
{
  #define H_gtk_widget_get_request_mode "GtkSizeRequestMode gtk_widget_get_request_mode(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_get_request_mode", "GtkWidget*");
  return(C_to_Xen_GtkSizeRequestMode(gtk_widget_get_request_mode(Xen_to_C_GtkWidget_(widget))));
}

static Xen gxg_gtk_widget_get_allocated_width(Xen widget)
{
  #define H_gtk_widget_get_allocated_width "int gtk_widget_get_allocated_width(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_get_allocated_width", "GtkWidget*");
  return(C_to_Xen_int(gtk_widget_get_allocated_width(Xen_to_C_GtkWidget_(widget))));
}

static Xen gxg_gtk_widget_get_allocated_height(Xen widget)
{
  #define H_gtk_widget_get_allocated_height "int gtk_widget_get_allocated_height(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_get_allocated_height", "GtkWidget*");
  return(C_to_Xen_int(gtk_widget_get_allocated_height(Xen_to_C_GtkWidget_(widget))));
}

static Xen gxg_gtk_widget_get_halign(Xen widget)
{
  #define H_gtk_widget_get_halign "GtkAlign gtk_widget_get_halign(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_get_halign", "GtkWidget*");
  return(C_to_Xen_GtkAlign(gtk_widget_get_halign(Xen_to_C_GtkWidget_(widget))));
}

static Xen gxg_gtk_widget_set_halign(Xen widget, Xen align)
{
  #define H_gtk_widget_set_halign "void gtk_widget_set_halign(GtkWidget* widget, GtkAlign align)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_set_halign", "GtkWidget*");
  Xen_check_type(Xen_is_GtkAlign(align), align, 2, "gtk_widget_set_halign", "GtkAlign");
  gtk_widget_set_halign(Xen_to_C_GtkWidget_(widget), Xen_to_C_GtkAlign(align));
  return(Xen_false);
}

static Xen gxg_gtk_widget_get_valign(Xen widget)
{
  #define H_gtk_widget_get_valign "GtkAlign gtk_widget_get_valign(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_get_valign", "GtkWidget*");
  return(C_to_Xen_GtkAlign(gtk_widget_get_valign(Xen_to_C_GtkWidget_(widget))));
}

static Xen gxg_gtk_widget_set_valign(Xen widget, Xen align)
{
  #define H_gtk_widget_set_valign "void gtk_widget_set_valign(GtkWidget* widget, GtkAlign align)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_set_valign", "GtkWidget*");
  Xen_check_type(Xen_is_GtkAlign(align), align, 2, "gtk_widget_set_valign", "GtkAlign");
  gtk_widget_set_valign(Xen_to_C_GtkWidget_(widget), Xen_to_C_GtkAlign(align));
  return(Xen_false);
}

static Xen gxg_gtk_widget_get_margin_top(Xen widget)
{
  #define H_gtk_widget_get_margin_top "gint gtk_widget_get_margin_top(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_get_margin_top", "GtkWidget*");
  return(C_to_Xen_gint(gtk_widget_get_margin_top(Xen_to_C_GtkWidget_(widget))));
}

static Xen gxg_gtk_widget_set_margin_top(Xen widget, Xen margin)
{
  #define H_gtk_widget_set_margin_top "void gtk_widget_set_margin_top(GtkWidget* widget, gint margin)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_set_margin_top", "GtkWidget*");
  Xen_check_type(Xen_is_gint(margin), margin, 2, "gtk_widget_set_margin_top", "gint");
  gtk_widget_set_margin_top(Xen_to_C_GtkWidget_(widget), Xen_to_C_gint(margin));
  return(Xen_false);
}

static Xen gxg_gtk_widget_get_margin_bottom(Xen widget)
{
  #define H_gtk_widget_get_margin_bottom "gint gtk_widget_get_margin_bottom(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_get_margin_bottom", "GtkWidget*");
  return(C_to_Xen_gint(gtk_widget_get_margin_bottom(Xen_to_C_GtkWidget_(widget))));
}

static Xen gxg_gtk_widget_set_margin_bottom(Xen widget, Xen margin)
{
  #define H_gtk_widget_set_margin_bottom "void gtk_widget_set_margin_bottom(GtkWidget* widget, gint margin)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_set_margin_bottom", "GtkWidget*");
  Xen_check_type(Xen_is_gint(margin), margin, 2, "gtk_widget_set_margin_bottom", "gint");
  gtk_widget_set_margin_bottom(Xen_to_C_GtkWidget_(widget), Xen_to_C_gint(margin));
  return(Xen_false);
}

static Xen gxg_gtk_combo_box_new_with_entry(void)
{
  #define H_gtk_combo_box_new_with_entry "GtkWidget* gtk_combo_box_new_with_entry( void)"
  return(C_to_Xen_GtkWidget_(gtk_combo_box_new_with_entry()));
}

static Xen gxg_gtk_combo_box_get_has_entry(Xen combo_box)
{
  #define H_gtk_combo_box_get_has_entry "gboolean gtk_combo_box_get_has_entry(GtkComboBox* combo_box)"
  Xen_check_type(Xen_is_GtkComboBox_(combo_box), combo_box, 1, "gtk_combo_box_get_has_entry", "GtkComboBox*");
  return(C_to_Xen_gboolean(gtk_combo_box_get_has_entry(Xen_to_C_GtkComboBox_(combo_box))));
}

static Xen gxg_gtk_combo_box_set_entry_text_column(Xen combo_box, Xen text_column)
{
  #define H_gtk_combo_box_set_entry_text_column "void gtk_combo_box_set_entry_text_column(GtkComboBox* combo_box, \
gint text_column)"
  Xen_check_type(Xen_is_GtkComboBox_(combo_box), combo_box, 1, "gtk_combo_box_set_entry_text_column", "GtkComboBox*");
  Xen_check_type(Xen_is_gint(text_column), text_column, 2, "gtk_combo_box_set_entry_text_column", "gint");
  gtk_combo_box_set_entry_text_column(Xen_to_C_GtkComboBox_(combo_box), Xen_to_C_gint(text_column));
  return(Xen_false);
}

static Xen gxg_gtk_combo_box_get_entry_text_column(Xen combo_box)
{
  #define H_gtk_combo_box_get_entry_text_column "gint gtk_combo_box_get_entry_text_column(GtkComboBox* combo_box)"
  Xen_check_type(Xen_is_GtkComboBox_(combo_box), combo_box, 1, "gtk_combo_box_get_entry_text_column", "GtkComboBox*");
  return(C_to_Xen_gint(gtk_combo_box_get_entry_text_column(Xen_to_C_GtkComboBox_(combo_box))));
}

static Xen gxg_gtk_widget_get_hexpand(Xen widget)
{
  #define H_gtk_widget_get_hexpand "gboolean gtk_widget_get_hexpand(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_get_hexpand", "GtkWidget*");
  return(C_to_Xen_gboolean(gtk_widget_get_hexpand(Xen_to_C_GtkWidget_(widget))));
}

static Xen gxg_gtk_widget_set_hexpand(Xen widget, Xen expand)
{
  #define H_gtk_widget_set_hexpand "void gtk_widget_set_hexpand(GtkWidget* widget, gboolean expand)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_set_hexpand", "GtkWidget*");
  Xen_check_type(Xen_is_gboolean(expand), expand, 2, "gtk_widget_set_hexpand", "gboolean");
  gtk_widget_set_hexpand(Xen_to_C_GtkWidget_(widget), Xen_to_C_gboolean(expand));
  return(Xen_false);
}

static Xen gxg_gtk_widget_get_hexpand_set(Xen widget)
{
  #define H_gtk_widget_get_hexpand_set "gboolean gtk_widget_get_hexpand_set(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_get_hexpand_set", "GtkWidget*");
  return(C_to_Xen_gboolean(gtk_widget_get_hexpand_set(Xen_to_C_GtkWidget_(widget))));
}

static Xen gxg_gtk_widget_set_hexpand_set(Xen widget, Xen set)
{
  #define H_gtk_widget_set_hexpand_set "void gtk_widget_set_hexpand_set(GtkWidget* widget, gboolean set)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_set_hexpand_set", "GtkWidget*");
  Xen_check_type(Xen_is_gboolean(set), set, 2, "gtk_widget_set_hexpand_set", "gboolean");
  gtk_widget_set_hexpand_set(Xen_to_C_GtkWidget_(widget), Xen_to_C_gboolean(set));
  return(Xen_false);
}

static Xen gxg_gtk_widget_get_vexpand(Xen widget)
{
  #define H_gtk_widget_get_vexpand "gboolean gtk_widget_get_vexpand(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_get_vexpand", "GtkWidget*");
  return(C_to_Xen_gboolean(gtk_widget_get_vexpand(Xen_to_C_GtkWidget_(widget))));
}

static Xen gxg_gtk_widget_set_vexpand(Xen widget, Xen expand)
{
  #define H_gtk_widget_set_vexpand "void gtk_widget_set_vexpand(GtkWidget* widget, gboolean expand)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_set_vexpand", "GtkWidget*");
  Xen_check_type(Xen_is_gboolean(expand), expand, 2, "gtk_widget_set_vexpand", "gboolean");
  gtk_widget_set_vexpand(Xen_to_C_GtkWidget_(widget), Xen_to_C_gboolean(expand));
  return(Xen_false);
}

static Xen gxg_gtk_widget_get_vexpand_set(Xen widget)
{
  #define H_gtk_widget_get_vexpand_set "gboolean gtk_widget_get_vexpand_set(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_get_vexpand_set", "GtkWidget*");
  return(C_to_Xen_gboolean(gtk_widget_get_vexpand_set(Xen_to_C_GtkWidget_(widget))));
}

static Xen gxg_gtk_widget_set_vexpand_set(Xen widget, Xen set)
{
  #define H_gtk_widget_set_vexpand_set "void gtk_widget_set_vexpand_set(GtkWidget* widget, gboolean set)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_set_vexpand_set", "GtkWidget*");
  Xen_check_type(Xen_is_gboolean(set), set, 2, "gtk_widget_set_vexpand_set", "gboolean");
  gtk_widget_set_vexpand_set(Xen_to_C_GtkWidget_(widget), Xen_to_C_gboolean(set));
  return(Xen_false);
}

static Xen gxg_gtk_widget_compute_expand(Xen widget, Xen orientation)
{
  #define H_gtk_widget_compute_expand "gboolean gtk_widget_compute_expand(GtkWidget* widget, GtkOrientation orientation)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_compute_expand", "GtkWidget*");
  Xen_check_type(Xen_is_GtkOrientation(orientation), orientation, 2, "gtk_widget_compute_expand", "GtkOrientation");
  return(C_to_Xen_gboolean(gtk_widget_compute_expand(Xen_to_C_GtkWidget_(widget), Xen_to_C_GtkOrientation(orientation))));
}

static Xen gxg_gtk_combo_box_text_new(void)
{
  #define H_gtk_combo_box_text_new "GtkWidget* gtk_combo_box_text_new( void)"
  return(C_to_Xen_GtkWidget_(gtk_combo_box_text_new()));
}

static Xen gxg_gtk_combo_box_text_new_with_entry(void)
{
  #define H_gtk_combo_box_text_new_with_entry "GtkWidget* gtk_combo_box_text_new_with_entry( void)"
  return(C_to_Xen_GtkWidget_(gtk_combo_box_text_new_with_entry()));
}

static Xen gxg_gtk_combo_box_text_append_text(Xen combo_box, Xen text)
{
  #define H_gtk_combo_box_text_append_text "void gtk_combo_box_text_append_text(GtkComboBoxText* combo_box, \
gchar* text)"
  Xen_check_type(Xen_is_GtkComboBoxText_(combo_box), combo_box, 1, "gtk_combo_box_text_append_text", "GtkComboBoxText*");
  Xen_check_type(Xen_is_gchar_(text), text, 2, "gtk_combo_box_text_append_text", "gchar*");
  gtk_combo_box_text_append_text(Xen_to_C_GtkComboBoxText_(combo_box), (const gchar*)Xen_to_C_gchar_(text));
  return(Xen_false);
}

static Xen gxg_gtk_combo_box_text_insert_text(Xen combo_box, Xen position, Xen text)
{
  #define H_gtk_combo_box_text_insert_text "void gtk_combo_box_text_insert_text(GtkComboBoxText* combo_box, \
gint position, gchar* text)"
  Xen_check_type(Xen_is_GtkComboBoxText_(combo_box), combo_box, 1, "gtk_combo_box_text_insert_text", "GtkComboBoxText*");
  Xen_check_type(Xen_is_gint(position), position, 2, "gtk_combo_box_text_insert_text", "gint");
  Xen_check_type(Xen_is_gchar_(text), text, 3, "gtk_combo_box_text_insert_text", "gchar*");
  gtk_combo_box_text_insert_text(Xen_to_C_GtkComboBoxText_(combo_box), Xen_to_C_gint(position), (const gchar*)Xen_to_C_gchar_(text));
  return(Xen_false);
}

static Xen gxg_gtk_combo_box_text_prepend_text(Xen combo_box, Xen text)
{
  #define H_gtk_combo_box_text_prepend_text "void gtk_combo_box_text_prepend_text(GtkComboBoxText* combo_box, \
gchar* text)"
  Xen_check_type(Xen_is_GtkComboBoxText_(combo_box), combo_box, 1, "gtk_combo_box_text_prepend_text", "GtkComboBoxText*");
  Xen_check_type(Xen_is_gchar_(text), text, 2, "gtk_combo_box_text_prepend_text", "gchar*");
  gtk_combo_box_text_prepend_text(Xen_to_C_GtkComboBoxText_(combo_box), (const gchar*)Xen_to_C_gchar_(text));
  return(Xen_false);
}

static Xen gxg_gtk_combo_box_text_remove(Xen combo_box, Xen position)
{
  #define H_gtk_combo_box_text_remove "void gtk_combo_box_text_remove(GtkComboBoxText* combo_box, gint position)"
  Xen_check_type(Xen_is_GtkComboBoxText_(combo_box), combo_box, 1, "gtk_combo_box_text_remove", "GtkComboBoxText*");
  Xen_check_type(Xen_is_gint(position), position, 2, "gtk_combo_box_text_remove", "gint");
  gtk_combo_box_text_remove(Xen_to_C_GtkComboBoxText_(combo_box), Xen_to_C_gint(position));
  return(Xen_false);
}

static Xen gxg_gtk_combo_box_text_get_active_text(Xen combo_box)
{
  #define H_gtk_combo_box_text_get_active_text "gchar* gtk_combo_box_text_get_active_text(GtkComboBoxText* combo_box)"
  Xen_check_type(Xen_is_GtkComboBoxText_(combo_box), combo_box, 1, "gtk_combo_box_text_get_active_text", "GtkComboBoxText*");
  return(C_to_Xen_gchar_(gtk_combo_box_text_get_active_text(Xen_to_C_GtkComboBoxText_(combo_box))));
}

static Xen gxg_gdk_cairo_set_source_rgba(Xen cr, Xen rgba)
{
  #define H_gdk_cairo_set_source_rgba "void gdk_cairo_set_source_rgba(cairo_t* cr, GdkRGBA* rgba)"
  Xen_check_type(Xen_is_cairo_t_(cr), cr, 1, "gdk_cairo_set_source_rgba", "cairo_t*");
  Xen_check_type(Xen_is_GdkRGBA_(rgba), rgba, 2, "gdk_cairo_set_source_rgba", "GdkRGBA*");
  gdk_cairo_set_source_rgba(Xen_to_C_cairo_t_(cr), Xen_to_C_GdkRGBA_(rgba));
  return(Xen_false);
}

static Xen gxg_gtk_combo_box_text_remove_all(Xen combo_box)
{
  #define H_gtk_combo_box_text_remove_all "void gtk_combo_box_text_remove_all(GtkComboBoxText* combo_box)"
  Xen_check_type(Xen_is_GtkComboBoxText_(combo_box), combo_box, 1, "gtk_combo_box_text_remove_all", "GtkComboBoxText*");
  gtk_combo_box_text_remove_all(Xen_to_C_GtkComboBoxText_(combo_box));
  return(Xen_false);
}

static Xen gxg_gtk_combo_box_set_popup_fixed_width(Xen combo_box, Xen fixed)
{
  #define H_gtk_combo_box_set_popup_fixed_width "void gtk_combo_box_set_popup_fixed_width(GtkComboBox* combo_box, \
gboolean fixed)"
  Xen_check_type(Xen_is_GtkComboBox_(combo_box), combo_box, 1, "gtk_combo_box_set_popup_fixed_width", "GtkComboBox*");
  Xen_check_type(Xen_is_gboolean(fixed), fixed, 2, "gtk_combo_box_set_popup_fixed_width", "gboolean");
  gtk_combo_box_set_popup_fixed_width(Xen_to_C_GtkComboBox_(combo_box), Xen_to_C_gboolean(fixed));
  return(Xen_false);
}

static Xen gxg_gtk_combo_box_get_popup_fixed_width(Xen combo_box)
{
  #define H_gtk_combo_box_get_popup_fixed_width "gboolean gtk_combo_box_get_popup_fixed_width(GtkComboBox* combo_box)"
  Xen_check_type(Xen_is_GtkComboBox_(combo_box), combo_box, 1, "gtk_combo_box_get_popup_fixed_width", "GtkComboBox*");
  return(C_to_Xen_gboolean(gtk_combo_box_get_popup_fixed_width(Xen_to_C_GtkComboBox_(combo_box))));
}

static Xen gxg_gtk_scrolled_window_get_min_content_width(Xen scrolled_window)
{
  #define H_gtk_scrolled_window_get_min_content_width "gint gtk_scrolled_window_get_min_content_width(GtkScrolledWindow* scrolled_window)"
  Xen_check_type(Xen_is_GtkScrolledWindow_(scrolled_window), scrolled_window, 1, "gtk_scrolled_window_get_min_content_width", "GtkScrolledWindow*");
  return(C_to_Xen_gint(gtk_scrolled_window_get_min_content_width(Xen_to_C_GtkScrolledWindow_(scrolled_window))));
}

static Xen gxg_gtk_scrolled_window_set_min_content_width(Xen scrolled_window, Xen width)
{
  #define H_gtk_scrolled_window_set_min_content_width "void gtk_scrolled_window_set_min_content_width(GtkScrolledWindow* scrolled_window, \
gint width)"
  Xen_check_type(Xen_is_GtkScrolledWindow_(scrolled_window), scrolled_window, 1, "gtk_scrolled_window_set_min_content_width", "GtkScrolledWindow*");
  Xen_check_type(Xen_is_gint(width), width, 2, "gtk_scrolled_window_set_min_content_width", "gint");
  gtk_scrolled_window_set_min_content_width(Xen_to_C_GtkScrolledWindow_(scrolled_window), Xen_to_C_gint(width));
  return(Xen_false);
}

static Xen gxg_gtk_scrolled_window_get_min_content_height(Xen scrolled_window)
{
  #define H_gtk_scrolled_window_get_min_content_height "gint gtk_scrolled_window_get_min_content_height(GtkScrolledWindow* scrolled_window)"
  Xen_check_type(Xen_is_GtkScrolledWindow_(scrolled_window), scrolled_window, 1, "gtk_scrolled_window_get_min_content_height", "GtkScrolledWindow*");
  return(C_to_Xen_gint(gtk_scrolled_window_get_min_content_height(Xen_to_C_GtkScrolledWindow_(scrolled_window))));
}

static Xen gxg_gtk_scrolled_window_set_min_content_height(Xen scrolled_window, Xen height)
{
  #define H_gtk_scrolled_window_set_min_content_height "void gtk_scrolled_window_set_min_content_height(GtkScrolledWindow* scrolled_window, \
gint height)"
  Xen_check_type(Xen_is_GtkScrolledWindow_(scrolled_window), scrolled_window, 1, "gtk_scrolled_window_set_min_content_height", "GtkScrolledWindow*");
  Xen_check_type(Xen_is_gint(height), height, 2, "gtk_scrolled_window_set_min_content_height", "gint");
  gtk_scrolled_window_set_min_content_height(Xen_to_C_GtkScrolledWindow_(scrolled_window), Xen_to_C_gint(height));
  return(Xen_false);
}

static Xen gxg_gtk_grid_new(void)
{
  #define H_gtk_grid_new "GtkWidget* gtk_grid_new( void)"
  return(C_to_Xen_GtkWidget_(gtk_grid_new()));
}

static Xen gxg_gtk_grid_attach(Xen grid, Xen child, Xen left, Xen top, Xen width, Xen height)
{
  #define H_gtk_grid_attach "void gtk_grid_attach(GtkGrid* grid, GtkWidget* child, gint left, gint top, \
gint width, gint height)"
  Xen_check_type(Xen_is_GtkGrid_(grid), grid, 1, "gtk_grid_attach", "GtkGrid*");
  Xen_check_type(Xen_is_GtkWidget_(child), child, 2, "gtk_grid_attach", "GtkWidget*");
  Xen_check_type(Xen_is_gint(left), left, 3, "gtk_grid_attach", "gint");
  Xen_check_type(Xen_is_gint(top), top, 4, "gtk_grid_attach", "gint");
  Xen_check_type(Xen_is_gint(width), width, 5, "gtk_grid_attach", "gint");
  Xen_check_type(Xen_is_gint(height), height, 6, "gtk_grid_attach", "gint");
  gtk_grid_attach(Xen_to_C_GtkGrid_(grid), Xen_to_C_GtkWidget_(child), Xen_to_C_gint(left), Xen_to_C_gint(top), Xen_to_C_gint(width), 
                  Xen_to_C_gint(height));
  return(Xen_false);
}

static Xen gxg_gtk_grid_attach_next_to(Xen grid, Xen child, Xen sibling, Xen side, Xen width, Xen height)
{
  #define H_gtk_grid_attach_next_to "void gtk_grid_attach_next_to(GtkGrid* grid, GtkWidget* child, GtkWidget* sibling, \
GtkPositionType side, gint width, gint height)"
  Xen_check_type(Xen_is_GtkGrid_(grid), grid, 1, "gtk_grid_attach_next_to", "GtkGrid*");
  Xen_check_type(Xen_is_GtkWidget_(child), child, 2, "gtk_grid_attach_next_to", "GtkWidget*");
  Xen_check_type(Xen_is_GtkWidget_(sibling), sibling, 3, "gtk_grid_attach_next_to", "GtkWidget*");
  Xen_check_type(Xen_is_GtkPositionType(side), side, 4, "gtk_grid_attach_next_to", "GtkPositionType");
  Xen_check_type(Xen_is_gint(width), width, 5, "gtk_grid_attach_next_to", "gint");
  Xen_check_type(Xen_is_gint(height), height, 6, "gtk_grid_attach_next_to", "gint");
  gtk_grid_attach_next_to(Xen_to_C_GtkGrid_(grid), Xen_to_C_GtkWidget_(child), Xen_to_C_GtkWidget_(sibling), Xen_to_C_GtkPositionType(side), 
                          Xen_to_C_gint(width), Xen_to_C_gint(height));
  return(Xen_false);
}

static Xen gxg_gtk_grid_set_row_homogeneous(Xen grid, Xen homogeneous)
{
  #define H_gtk_grid_set_row_homogeneous "void gtk_grid_set_row_homogeneous(GtkGrid* grid, gboolean homogeneous)"
  Xen_check_type(Xen_is_GtkGrid_(grid), grid, 1, "gtk_grid_set_row_homogeneous", "GtkGrid*");
  Xen_check_type(Xen_is_gboolean(homogeneous), homogeneous, 2, "gtk_grid_set_row_homogeneous", "gboolean");
  gtk_grid_set_row_homogeneous(Xen_to_C_GtkGrid_(grid), Xen_to_C_gboolean(homogeneous));
  return(Xen_false);
}

static Xen gxg_gtk_grid_get_row_homogeneous(Xen grid)
{
  #define H_gtk_grid_get_row_homogeneous "gboolean gtk_grid_get_row_homogeneous(GtkGrid* grid)"
  Xen_check_type(Xen_is_GtkGrid_(grid), grid, 1, "gtk_grid_get_row_homogeneous", "GtkGrid*");
  return(C_to_Xen_gboolean(gtk_grid_get_row_homogeneous(Xen_to_C_GtkGrid_(grid))));
}

static Xen gxg_gtk_grid_set_row_spacing(Xen grid, Xen spacing)
{
  #define H_gtk_grid_set_row_spacing "void gtk_grid_set_row_spacing(GtkGrid* grid, guint spacing)"
  Xen_check_type(Xen_is_GtkGrid_(grid), grid, 1, "gtk_grid_set_row_spacing", "GtkGrid*");
  Xen_check_type(Xen_is_guint(spacing), spacing, 2, "gtk_grid_set_row_spacing", "guint");
  gtk_grid_set_row_spacing(Xen_to_C_GtkGrid_(grid), Xen_to_C_guint(spacing));
  return(Xen_false);
}

static Xen gxg_gtk_grid_get_row_spacing(Xen grid)
{
  #define H_gtk_grid_get_row_spacing "guint gtk_grid_get_row_spacing(GtkGrid* grid)"
  Xen_check_type(Xen_is_GtkGrid_(grid), grid, 1, "gtk_grid_get_row_spacing", "GtkGrid*");
  return(C_to_Xen_guint(gtk_grid_get_row_spacing(Xen_to_C_GtkGrid_(grid))));
}

static Xen gxg_gtk_grid_set_column_homogeneous(Xen grid, Xen homogeneous)
{
  #define H_gtk_grid_set_column_homogeneous "void gtk_grid_set_column_homogeneous(GtkGrid* grid, gboolean homogeneous)"
  Xen_check_type(Xen_is_GtkGrid_(grid), grid, 1, "gtk_grid_set_column_homogeneous", "GtkGrid*");
  Xen_check_type(Xen_is_gboolean(homogeneous), homogeneous, 2, "gtk_grid_set_column_homogeneous", "gboolean");
  gtk_grid_set_column_homogeneous(Xen_to_C_GtkGrid_(grid), Xen_to_C_gboolean(homogeneous));
  return(Xen_false);
}

static Xen gxg_gtk_grid_get_column_homogeneous(Xen grid)
{
  #define H_gtk_grid_get_column_homogeneous "gboolean gtk_grid_get_column_homogeneous(GtkGrid* grid)"
  Xen_check_type(Xen_is_GtkGrid_(grid), grid, 1, "gtk_grid_get_column_homogeneous", "GtkGrid*");
  return(C_to_Xen_gboolean(gtk_grid_get_column_homogeneous(Xen_to_C_GtkGrid_(grid))));
}

static Xen gxg_gtk_grid_set_column_spacing(Xen grid, Xen spacing)
{
  #define H_gtk_grid_set_column_spacing "void gtk_grid_set_column_spacing(GtkGrid* grid, guint spacing)"
  Xen_check_type(Xen_is_GtkGrid_(grid), grid, 1, "gtk_grid_set_column_spacing", "GtkGrid*");
  Xen_check_type(Xen_is_guint(spacing), spacing, 2, "gtk_grid_set_column_spacing", "guint");
  gtk_grid_set_column_spacing(Xen_to_C_GtkGrid_(grid), Xen_to_C_guint(spacing));
  return(Xen_false);
}

static Xen gxg_gtk_grid_get_column_spacing(Xen grid)
{
  #define H_gtk_grid_get_column_spacing "guint gtk_grid_get_column_spacing(GtkGrid* grid)"
  Xen_check_type(Xen_is_GtkGrid_(grid), grid, 1, "gtk_grid_get_column_spacing", "GtkGrid*");
  return(C_to_Xen_guint(gtk_grid_get_column_spacing(Xen_to_C_GtkGrid_(grid))));
}

static Xen gxg_gtk_scrollable_get_hadjustment(Xen scrollable)
{
  #define H_gtk_scrollable_get_hadjustment "GtkAdjustment* gtk_scrollable_get_hadjustment(GtkScrollable* scrollable)"
  Xen_check_type(Xen_is_GtkScrollable_(scrollable), scrollable, 1, "gtk_scrollable_get_hadjustment", "GtkScrollable*");
  return(C_to_Xen_GtkAdjustment_(gtk_scrollable_get_hadjustment(Xen_to_C_GtkScrollable_(scrollable))));
}

static Xen gxg_gtk_scrollable_set_hadjustment(Xen scrollable, Xen hadjustment)
{
  #define H_gtk_scrollable_set_hadjustment "void gtk_scrollable_set_hadjustment(GtkScrollable* scrollable, \
GtkAdjustment* hadjustment)"
  Xen_check_type(Xen_is_GtkScrollable_(scrollable), scrollable, 1, "gtk_scrollable_set_hadjustment", "GtkScrollable*");
  Xen_check_type(Xen_is_GtkAdjustment_(hadjustment), hadjustment, 2, "gtk_scrollable_set_hadjustment", "GtkAdjustment*");
  gtk_scrollable_set_hadjustment(Xen_to_C_GtkScrollable_(scrollable), Xen_to_C_GtkAdjustment_(hadjustment));
  return(Xen_false);
}

static Xen gxg_gtk_scrollable_get_vadjustment(Xen scrollable)
{
  #define H_gtk_scrollable_get_vadjustment "GtkAdjustment* gtk_scrollable_get_vadjustment(GtkScrollable* scrollable)"
  Xen_check_type(Xen_is_GtkScrollable_(scrollable), scrollable, 1, "gtk_scrollable_get_vadjustment", "GtkScrollable*");
  return(C_to_Xen_GtkAdjustment_(gtk_scrollable_get_vadjustment(Xen_to_C_GtkScrollable_(scrollable))));
}

static Xen gxg_gtk_scrollable_set_vadjustment(Xen scrollable, Xen vadjustment)
{
  #define H_gtk_scrollable_set_vadjustment "void gtk_scrollable_set_vadjustment(GtkScrollable* scrollable, \
GtkAdjustment* vadjustment)"
  Xen_check_type(Xen_is_GtkScrollable_(scrollable), scrollable, 1, "gtk_scrollable_set_vadjustment", "GtkScrollable*");
  Xen_check_type(Xen_is_GtkAdjustment_(vadjustment), vadjustment, 2, "gtk_scrollable_set_vadjustment", "GtkAdjustment*");
  gtk_scrollable_set_vadjustment(Xen_to_C_GtkScrollable_(scrollable), Xen_to_C_GtkAdjustment_(vadjustment));
  return(Xen_false);
}

static Xen gxg_gtk_assistant_next_page(Xen assistant)
{
  #define H_gtk_assistant_next_page "void gtk_assistant_next_page(GtkAssistant* assistant)"
  Xen_check_type(Xen_is_GtkAssistant_(assistant), assistant, 1, "gtk_assistant_next_page", "GtkAssistant*");
  gtk_assistant_next_page(Xen_to_C_GtkAssistant_(assistant));
  return(Xen_false);
}

static Xen gxg_gtk_assistant_previous_page(Xen assistant)
{
  #define H_gtk_assistant_previous_page "void gtk_assistant_previous_page(GtkAssistant* assistant)"
  Xen_check_type(Xen_is_GtkAssistant_(assistant), assistant, 1, "gtk_assistant_previous_page", "GtkAssistant*");
  gtk_assistant_previous_page(Xen_to_C_GtkAssistant_(assistant));
  return(Xen_false);
}

static Xen gxg_gtk_combo_box_new_with_model_and_entry(Xen model)
{
  #define H_gtk_combo_box_new_with_model_and_entry "GtkWidget* gtk_combo_box_new_with_model_and_entry(GtkTreeModel* model)"
  Xen_check_type(Xen_is_GtkTreeModel_(model), model, 1, "gtk_combo_box_new_with_model_and_entry", "GtkTreeModel*");
  return(C_to_Xen_GtkWidget_(gtk_combo_box_new_with_model_and_entry(Xen_to_C_GtkTreeModel_(model))));
}

static Xen gxg_gtk_scrollable_get_hscroll_policy(Xen scrollable)
{
  #define H_gtk_scrollable_get_hscroll_policy "GtkScrollablePolicy gtk_scrollable_get_hscroll_policy(GtkScrollable* scrollable)"
  Xen_check_type(Xen_is_GtkScrollable_(scrollable), scrollable, 1, "gtk_scrollable_get_hscroll_policy", "GtkScrollable*");
  return(C_to_Xen_GtkScrollablePolicy(gtk_scrollable_get_hscroll_policy(Xen_to_C_GtkScrollable_(scrollable))));
}

static Xen gxg_gtk_scrollable_set_hscroll_policy(Xen scrollable, Xen policy)
{
  #define H_gtk_scrollable_set_hscroll_policy "void gtk_scrollable_set_hscroll_policy(GtkScrollable* scrollable, \
GtkScrollablePolicy policy)"
  Xen_check_type(Xen_is_GtkScrollable_(scrollable), scrollable, 1, "gtk_scrollable_set_hscroll_policy", "GtkScrollable*");
  Xen_check_type(Xen_is_GtkScrollablePolicy(policy), policy, 2, "gtk_scrollable_set_hscroll_policy", "GtkScrollablePolicy");
  gtk_scrollable_set_hscroll_policy(Xen_to_C_GtkScrollable_(scrollable), Xen_to_C_GtkScrollablePolicy(policy));
  return(Xen_false);
}

static Xen gxg_gtk_scrollable_get_vscroll_policy(Xen scrollable)
{
  #define H_gtk_scrollable_get_vscroll_policy "GtkScrollablePolicy gtk_scrollable_get_vscroll_policy(GtkScrollable* scrollable)"
  Xen_check_type(Xen_is_GtkScrollable_(scrollable), scrollable, 1, "gtk_scrollable_get_vscroll_policy", "GtkScrollable*");
  return(C_to_Xen_GtkScrollablePolicy(gtk_scrollable_get_vscroll_policy(Xen_to_C_GtkScrollable_(scrollable))));
}

static Xen gxg_gtk_scrollable_set_vscroll_policy(Xen scrollable, Xen policy)
{
  #define H_gtk_scrollable_set_vscroll_policy "void gtk_scrollable_set_vscroll_policy(GtkScrollable* scrollable, \
GtkScrollablePolicy policy)"
  Xen_check_type(Xen_is_GtkScrollable_(scrollable), scrollable, 1, "gtk_scrollable_set_vscroll_policy", "GtkScrollable*");
  Xen_check_type(Xen_is_GtkScrollablePolicy(policy), policy, 2, "gtk_scrollable_set_vscroll_policy", "GtkScrollablePolicy");
  gtk_scrollable_set_vscroll_policy(Xen_to_C_GtkScrollable_(scrollable), Xen_to_C_GtkScrollablePolicy(policy));
  return(Xen_false);
}

static Xen gxg_gtk_switch_new(void)
{
  #define H_gtk_switch_new "GtkWidget* gtk_switch_new( void)"
  return(C_to_Xen_GtkWidget_(gtk_switch_new()));
}

static Xen gxg_gtk_switch_set_active(Xen sw, Xen is_active)
{
  #define H_gtk_switch_set_active "void gtk_switch_set_active(GtkSwitch* sw, gboolean is_active)"
  Xen_check_type(Xen_is_GtkSwitch_(sw), sw, 1, "gtk_switch_set_active", "GtkSwitch*");
  Xen_check_type(Xen_is_gboolean(is_active), is_active, 2, "gtk_switch_set_active", "gboolean");
  gtk_switch_set_active(Xen_to_C_GtkSwitch_(sw), Xen_to_C_gboolean(is_active));
  return(Xen_false);
}

static Xen gxg_gtk_switch_get_active(Xen sw)
{
  #define H_gtk_switch_get_active "gboolean gtk_switch_get_active(GtkSwitch* sw)"
  Xen_check_type(Xen_is_GtkSwitch_(sw), sw, 1, "gtk_switch_get_active", "GtkSwitch*");
  return(C_to_Xen_gboolean(gtk_switch_get_active(Xen_to_C_GtkSwitch_(sw))));
}

static Xen gxg_gtk_border_new(void)
{
  #define H_gtk_border_new "GtkBorder* gtk_border_new( void)"
  return(C_to_Xen_GtkBorder_(gtk_border_new()));
}

static Xen gxg_gtk_border_copy(Xen border_)
{
  #define H_gtk_border_copy "GtkBorder* gtk_border_copy(GtkBorder* border_)"
  Xen_check_type(Xen_is_GtkBorder_(border_), border_, 1, "gtk_border_copy", "GtkBorder*");
  return(C_to_Xen_GtkBorder_(gtk_border_copy(Xen_to_C_GtkBorder_(border_))));
}

static Xen gxg_gtk_border_free(Xen border_)
{
  #define H_gtk_border_free "void gtk_border_free(GtkBorder* border_)"
  Xen_check_type(Xen_is_GtkBorder_(border_), border_, 1, "gtk_border_free", "GtkBorder*");
  gtk_border_free(Xen_to_C_GtkBorder_(border_));
  return(Xen_false);
}

static Xen gxg_gtk_combo_box_get_id_column(Xen combo_box)
{
  #define H_gtk_combo_box_get_id_column "gint gtk_combo_box_get_id_column(GtkComboBox* combo_box)"
  Xen_check_type(Xen_is_GtkComboBox_(combo_box), combo_box, 1, "gtk_combo_box_get_id_column", "GtkComboBox*");
  return(C_to_Xen_gint(gtk_combo_box_get_id_column(Xen_to_C_GtkComboBox_(combo_box))));
}

static Xen gxg_gtk_combo_box_set_id_column(Xen combo_box, Xen id_column)
{
  #define H_gtk_combo_box_set_id_column "void gtk_combo_box_set_id_column(GtkComboBox* combo_box, gint id_column)"
  Xen_check_type(Xen_is_GtkComboBox_(combo_box), combo_box, 1, "gtk_combo_box_set_id_column", "GtkComboBox*");
  Xen_check_type(Xen_is_gint(id_column), id_column, 2, "gtk_combo_box_set_id_column", "gint");
  gtk_combo_box_set_id_column(Xen_to_C_GtkComboBox_(combo_box), Xen_to_C_gint(id_column));
  return(Xen_false);
}

static Xen gxg_gtk_combo_box_get_active_id(Xen combo_box)
{
  #define H_gtk_combo_box_get_active_id "gchar* gtk_combo_box_get_active_id(GtkComboBox* combo_box)"
  Xen_check_type(Xen_is_GtkComboBox_(combo_box), combo_box, 1, "gtk_combo_box_get_active_id", "GtkComboBox*");
  return(C_to_Xen_gchar_(gtk_combo_box_get_active_id(Xen_to_C_GtkComboBox_(combo_box))));
}

static Xen gxg_gtk_combo_box_text_insert(Xen combo_box, Xen position, Xen id, Xen text)
{
  #define H_gtk_combo_box_text_insert "void gtk_combo_box_text_insert(GtkComboBoxText* combo_box, gint position, \
gchar* id, gchar* text)"
  Xen_check_type(Xen_is_GtkComboBoxText_(combo_box), combo_box, 1, "gtk_combo_box_text_insert", "GtkComboBoxText*");
  Xen_check_type(Xen_is_gint(position), position, 2, "gtk_combo_box_text_insert", "gint");
  Xen_check_type(Xen_is_gchar_(id), id, 3, "gtk_combo_box_text_insert", "gchar*");
  Xen_check_type(Xen_is_gchar_(text), text, 4, "gtk_combo_box_text_insert", "gchar*");
  gtk_combo_box_text_insert(Xen_to_C_GtkComboBoxText_(combo_box), Xen_to_C_gint(position), (const gchar*)Xen_to_C_gchar_(id), (const gchar*)Xen_to_C_gchar_(text));
  return(Xen_false);
}

static Xen gxg_gtk_combo_box_text_append(Xen combo_box, Xen id, Xen text)
{
  #define H_gtk_combo_box_text_append "void gtk_combo_box_text_append(GtkComboBoxText* combo_box, gchar* id, \
gchar* text)"
  Xen_check_type(Xen_is_GtkComboBoxText_(combo_box), combo_box, 1, "gtk_combo_box_text_append", "GtkComboBoxText*");
  Xen_check_type(Xen_is_gchar_(id), id, 2, "gtk_combo_box_text_append", "gchar*");
  Xen_check_type(Xen_is_gchar_(text), text, 3, "gtk_combo_box_text_append", "gchar*");
  gtk_combo_box_text_append(Xen_to_C_GtkComboBoxText_(combo_box), (const gchar*)Xen_to_C_gchar_(id), (const gchar*)Xen_to_C_gchar_(text));
  return(Xen_false);
}

static Xen gxg_gtk_combo_box_text_prepend(Xen combo_box, Xen id, Xen text)
{
  #define H_gtk_combo_box_text_prepend "void gtk_combo_box_text_prepend(GtkComboBoxText* combo_box, gchar* id, \
gchar* text)"
  Xen_check_type(Xen_is_GtkComboBoxText_(combo_box), combo_box, 1, "gtk_combo_box_text_prepend", "GtkComboBoxText*");
  Xen_check_type(Xen_is_gchar_(id), id, 2, "gtk_combo_box_text_prepend", "gchar*");
  Xen_check_type(Xen_is_gchar_(text), text, 3, "gtk_combo_box_text_prepend", "gchar*");
  gtk_combo_box_text_prepend(Xen_to_C_GtkComboBoxText_(combo_box), (const gchar*)Xen_to_C_gchar_(id), (const gchar*)Xen_to_C_gchar_(text));
  return(Xen_false);
}

static Xen gxg_gtk_box_new(Xen orientation, Xen spacing)
{
  #define H_gtk_box_new "GtkWidget* gtk_box_new(GtkOrientation orientation, gint spacing)"
  Xen_check_type(Xen_is_GtkOrientation(orientation), orientation, 1, "gtk_box_new", "GtkOrientation");
  Xen_check_type(Xen_is_gint(spacing), spacing, 2, "gtk_box_new", "gint");
  return(C_to_Xen_GtkWidget_(gtk_box_new(Xen_to_C_GtkOrientation(orientation), Xen_to_C_gint(spacing))));
}

static Xen gxg_gtk_tree_view_set_cursor_on_cell(Xen tree_view, Xen path, Xen focus_column, Xen focus_cell, Xen start_editing)
{
  #define H_gtk_tree_view_set_cursor_on_cell "void gtk_tree_view_set_cursor_on_cell(GtkTreeView* tree_view, \
GtkTreePath* path, GtkTreeViewColumn* focus_column, GtkCellRenderer* focus_cell, gboolean start_editing)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_set_cursor_on_cell", "GtkTreeView*");
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 2, "gtk_tree_view_set_cursor_on_cell", "GtkTreePath*");
  Xen_check_type(Xen_is_GtkTreeViewColumn_(focus_column), focus_column, 3, "gtk_tree_view_set_cursor_on_cell", "GtkTreeViewColumn*");
  Xen_check_type(Xen_is_GtkCellRenderer_(focus_cell), focus_cell, 4, "gtk_tree_view_set_cursor_on_cell", "GtkCellRenderer*");
  Xen_check_type(Xen_is_gboolean(start_editing), start_editing, 5, "gtk_tree_view_set_cursor_on_cell", "gboolean");
  gtk_tree_view_set_cursor_on_cell(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_GtkTreePath_(path), Xen_to_C_GtkTreeViewColumn_(focus_column), 
                                   Xen_to_C_GtkCellRenderer_(focus_cell), Xen_to_C_gboolean(start_editing));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_set_rubber_banding(Xen tree_view, Xen enable)
{
  #define H_gtk_tree_view_set_rubber_banding "void gtk_tree_view_set_rubber_banding(GtkTreeView* tree_view, \
gboolean enable)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_set_rubber_banding", "GtkTreeView*");
  Xen_check_type(Xen_is_gboolean(enable), enable, 2, "gtk_tree_view_set_rubber_banding", "gboolean");
  gtk_tree_view_set_rubber_banding(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_gboolean(enable));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_get_rubber_banding(Xen tree_view)
{
  #define H_gtk_tree_view_get_rubber_banding "gboolean gtk_tree_view_get_rubber_banding(GtkTreeView* tree_view)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_get_rubber_banding", "GtkTreeView*");
  return(C_to_Xen_gboolean(gtk_tree_view_get_rubber_banding(Xen_to_C_GtkTreeView_(tree_view))));
}

static Xen gxg_gtk_tooltip_set_markup(Xen tooltip, Xen markup)
{
  #define H_gtk_tooltip_set_markup "void gtk_tooltip_set_markup(GtkTooltip* tooltip, gchar* markup)"
  Xen_check_type(Xen_is_GtkTooltip_(tooltip), tooltip, 1, "gtk_tooltip_set_markup", "GtkTooltip*");
  Xen_check_type(Xen_is_gchar_(markup), markup, 2, "gtk_tooltip_set_markup", "gchar*");
  gtk_tooltip_set_markup(Xen_to_C_GtkTooltip_(tooltip), (const gchar*)Xen_to_C_gchar_(markup));
  return(Xen_false);
}

static Xen gxg_gtk_tooltip_set_custom(Xen tooltip, Xen custom_widget)
{
  #define H_gtk_tooltip_set_custom "void gtk_tooltip_set_custom(GtkTooltip* tooltip, GtkWidget* custom_widget)"
  Xen_check_type(Xen_is_GtkTooltip_(tooltip), tooltip, 1, "gtk_tooltip_set_custom", "GtkTooltip*");
  Xen_check_type(Xen_is_GtkWidget_(custom_widget), custom_widget, 2, "gtk_tooltip_set_custom", "GtkWidget*");
  gtk_tooltip_set_custom(Xen_to_C_GtkTooltip_(tooltip), Xen_to_C_GtkWidget_(custom_widget));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_column_new_with_area(Xen area)
{
  #define H_gtk_tree_view_column_new_with_area "GtkTreeViewColumn* gtk_tree_view_column_new_with_area(GtkCellArea* area)"
  Xen_check_type(Xen_is_GtkCellArea_(area), area, 1, "gtk_tree_view_column_new_with_area", "GtkCellArea*");
  return(C_to_Xen_GtkTreeViewColumn_(gtk_tree_view_column_new_with_area(Xen_to_C_GtkCellArea_(area))));
}

static Xen gxg_gtk_tree_view_column_get_button(Xen tree_column)
{
  #define H_gtk_tree_view_column_get_button "GtkWidget* gtk_tree_view_column_get_button(GtkTreeViewColumn* tree_column)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_get_button", "GtkTreeViewColumn*");
  return(C_to_Xen_GtkWidget_(gtk_tree_view_column_get_button(Xen_to_C_GtkTreeViewColumn_(tree_column))));
}

static Xen gxg_gtk_tree_view_column_focus_cell(Xen tree_column, Xen cell)
{
  #define H_gtk_tree_view_column_focus_cell "void gtk_tree_view_column_focus_cell(GtkTreeViewColumn* tree_column, \
GtkCellRenderer* cell)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_focus_cell", "GtkTreeViewColumn*");
  Xen_check_type(Xen_is_GtkCellRenderer_(cell), cell, 2, "gtk_tree_view_column_focus_cell", "GtkCellRenderer*");
  gtk_tree_view_column_focus_cell(Xen_to_C_GtkTreeViewColumn_(tree_column), Xen_to_C_GtkCellRenderer_(cell));
  return(Xen_false);
}

static Xen gxg_gtk_orientable_set_orientation(Xen orientable, Xen orientation)
{
  #define H_gtk_orientable_set_orientation "void gtk_orientable_set_orientation(GtkOrientable* orientable, \
GtkOrientation orientation)"
  Xen_check_type(Xen_is_GtkOrientable_(orientable), orientable, 1, "gtk_orientable_set_orientation", "GtkOrientable*");
  Xen_check_type(Xen_is_GtkOrientation(orientation), orientation, 2, "gtk_orientable_set_orientation", "GtkOrientation");
  gtk_orientable_set_orientation(Xen_to_C_GtkOrientable_(orientable), Xen_to_C_GtkOrientation(orientation));
  return(Xen_false);
}

static Xen gxg_gtk_orientable_get_orientation(Xen orientable)
{
  #define H_gtk_orientable_get_orientation "GtkOrientation gtk_orientable_get_orientation(GtkOrientable* orientable)"
  Xen_check_type(Xen_is_GtkOrientable_(orientable), orientable, 1, "gtk_orientable_get_orientation", "GtkOrientable*");
  return(C_to_Xen_GtkOrientation(gtk_orientable_get_orientation(Xen_to_C_GtkOrientable_(orientable))));
}

static Xen gxg_gtk_get_major_version(void)
{
  #define H_gtk_get_major_version "guint gtk_get_major_version( void)"
    return(C_to_Xen_guint((guint)gtk_get_major_version()));
}

static Xen gxg_gtk_get_minor_version(void)
{
  #define H_gtk_get_minor_version "guint gtk_get_minor_version( void)"
    return(C_to_Xen_guint((guint)gtk_get_minor_version()));
}

static Xen gxg_gtk_get_micro_version(void)
{
  #define H_gtk_get_micro_version "guint gtk_get_micro_version( void)"
    return(C_to_Xen_guint((guint)gtk_get_micro_version()));
}

static Xen gxg_gtk_get_binary_age(void)
{
  #define H_gtk_get_binary_age "guint gtk_get_binary_age( void)"
    return(C_to_Xen_guint((guint)gtk_get_binary_age()));
}

static Xen gxg_gtk_get_interface_age(void)
{
  #define H_gtk_get_interface_age "guint gtk_get_interface_age( void)"
    return(C_to_Xen_guint((guint)gtk_get_interface_age()));
}

static Xen gxg_gtk_progress_bar_set_show_text(Xen pbar, Xen show_text)
{
  #define H_gtk_progress_bar_set_show_text "void gtk_progress_bar_set_show_text(GtkProgressBar* pbar, \
gboolean show_text)"
  Xen_check_type(Xen_is_GtkProgressBar_(pbar), pbar, 1, "gtk_progress_bar_set_show_text", "GtkProgressBar*");
  Xen_check_type(Xen_is_gboolean(show_text), show_text, 2, "gtk_progress_bar_set_show_text", "gboolean");
  gtk_progress_bar_set_show_text(Xen_to_C_GtkProgressBar_(pbar), Xen_to_C_gboolean(show_text));
  return(Xen_false);
}

static Xen gxg_gtk_progress_bar_get_show_text(Xen pbar)
{
  #define H_gtk_progress_bar_get_show_text "gboolean gtk_progress_bar_get_show_text(GtkProgressBar* pbar)"
  Xen_check_type(Xen_is_GtkProgressBar_(pbar), pbar, 1, "gtk_progress_bar_get_show_text", "GtkProgressBar*");
  return(C_to_Xen_gboolean(gtk_progress_bar_get_show_text(Xen_to_C_GtkProgressBar_(pbar))));
}

static Xen gxg_gtk_entry_get_icon_storage_type(Xen entry, Xen icon_pos)
{
  #define H_gtk_entry_get_icon_storage_type "GtkImageType gtk_entry_get_icon_storage_type(GtkEntry* entry, \
GtkEntryIconPosition icon_pos)"
  Xen_check_type(Xen_is_GtkEntry_(entry), entry, 1, "gtk_entry_get_icon_storage_type", "GtkEntry*");
  Xen_check_type(Xen_is_GtkEntryIconPosition(icon_pos), icon_pos, 2, "gtk_entry_get_icon_storage_type", "GtkEntryIconPosition");
  return(C_to_Xen_GtkImageType(gtk_entry_get_icon_storage_type(Xen_to_C_GtkEntry_(entry), Xen_to_C_GtkEntryIconPosition(icon_pos))));
}

static Xen gxg_gtk_entry_get_icon_gicon(Xen entry, Xen icon_pos)
{
  #define H_gtk_entry_get_icon_gicon "GIcon* gtk_entry_get_icon_gicon(GtkEntry* entry, GtkEntryIconPosition icon_pos)"
  Xen_check_type(Xen_is_GtkEntry_(entry), entry, 1, "gtk_entry_get_icon_gicon", "GtkEntry*");
  Xen_check_type(Xen_is_GtkEntryIconPosition(icon_pos), icon_pos, 2, "gtk_entry_get_icon_gicon", "GtkEntryIconPosition");
  return(C_to_Xen_GIcon_(gtk_entry_get_icon_gicon(Xen_to_C_GtkEntry_(entry), Xen_to_C_GtkEntryIconPosition(icon_pos))));
}

static Xen gxg_gtk_assistant_commit(Xen assistant)
{
  #define H_gtk_assistant_commit "void gtk_assistant_commit(GtkAssistant* assistant)"
  Xen_check_type(Xen_is_GtkAssistant_(assistant), assistant, 1, "gtk_assistant_commit", "GtkAssistant*");
  gtk_assistant_commit(Xen_to_C_GtkAssistant_(assistant));
  return(Xen_false);
}

static Xen gxg_gtk_window_fullscreen(Xen window)
{
  #define H_gtk_window_fullscreen "void gtk_window_fullscreen(GtkWindow* window)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_fullscreen", "GtkWindow*");
  gtk_window_fullscreen(Xen_to_C_GtkWindow_(window));
  return(Xen_false);
}

static Xen gxg_gtk_window_unfullscreen(Xen window)
{
  #define H_gtk_window_unfullscreen "void gtk_window_unfullscreen(GtkWindow* window)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_unfullscreen", "GtkWindow*");
  gtk_window_unfullscreen(Xen_to_C_GtkWindow_(window));
  return(Xen_false);
}

static Xen gxg_gtk_window_group_add_window(Xen window_group, Xen window)
{
  #define H_gtk_window_group_add_window "void gtk_window_group_add_window(GtkWindowGroup* window_group, \
GtkWindow* window)"
  Xen_check_type(Xen_is_GtkWindowGroup_(window_group), window_group, 1, "gtk_window_group_add_window", "GtkWindowGroup*");
  Xen_check_type(Xen_is_GtkWindow_(window), window, 2, "gtk_window_group_add_window", "GtkWindow*");
  gtk_window_group_add_window(Xen_to_C_GtkWindowGroup_(window_group), Xen_to_C_GtkWindow_(window));
  return(Xen_false);
}

static Xen gxg_gtk_window_group_remove_window(Xen window_group, Xen window)
{
  #define H_gtk_window_group_remove_window "void gtk_window_group_remove_window(GtkWindowGroup* window_group, \
GtkWindow* window)"
  Xen_check_type(Xen_is_GtkWindowGroup_(window_group), window_group, 1, "gtk_window_group_remove_window", "GtkWindowGroup*");
  Xen_check_type(Xen_is_GtkWindow_(window), window, 2, "gtk_window_group_remove_window", "GtkWindow*");
  gtk_window_group_remove_window(Xen_to_C_GtkWindowGroup_(window_group), Xen_to_C_GtkWindow_(window));
  return(Xen_false);
}

static Xen gxg_gtk_window_group_new(void)
{
  #define H_gtk_window_group_new "GtkWindowGroup* gtk_window_group_new( void)"
  return(C_to_Xen_GtkWindowGroup_(gtk_window_group_new()));
}

static Xen gxg_gtk_window_get_group(Xen window)
{
  #define H_gtk_window_get_group "GtkWindowGroup* gtk_window_get_group(GtkWindow* window)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_get_group", "GtkWindow*");
  return(C_to_Xen_GtkWindowGroup_(gtk_window_get_group(Xen_to_C_GtkWindow_(window))));
}

static Xen gxg_gtk_window_group_list_windows(Xen window_group)
{
  #define H_gtk_window_group_list_windows "GList* gtk_window_group_list_windows(GtkWindowGroup* window_group)"
  Xen_check_type(Xen_is_GtkWindowGroup_(window_group), window_group, 1, "gtk_window_group_list_windows", "GtkWindowGroup*");
  return(C_to_Xen_GList_(gtk_window_group_list_windows(Xen_to_C_GtkWindowGroup_(window_group))));
}

static Xen gxg_gtk_icon_view_set_item_orientation(Xen icon_view, Xen orientation)
{
  #define H_gtk_icon_view_set_item_orientation "void gtk_icon_view_set_item_orientation(GtkIconView* icon_view, \
GtkOrientation orientation)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_set_item_orientation", "GtkIconView*");
  Xen_check_type(Xen_is_GtkOrientation(orientation), orientation, 2, "gtk_icon_view_set_item_orientation", "GtkOrientation");
  gtk_icon_view_set_item_orientation(Xen_to_C_GtkIconView_(icon_view), Xen_to_C_GtkOrientation(orientation));
  return(Xen_false);
}

static Xen gxg_gtk_icon_view_get_item_orientation(Xen icon_view)
{
  #define H_gtk_icon_view_get_item_orientation "GtkOrientation gtk_icon_view_get_item_orientation(GtkIconView* ic