/* libgtk_s7.c */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <stdbool.h>
#include "s7.h"

#if ((!__NetBSD__) && ((_MSC_VER) || (!defined(__STC__)) || (defined(__STDC_VERSION__) && (__STDC_VERSION__ < 199901L))))
  #define __func__ __FUNCTION__
#endif

#include <string.h>
#include <stdlib.h>
#include <stdint.h>
#include <inttypes.h>

#include <glib.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#if (!GTK_CHECK_VERSION(3, 0, 0))
  #include <gdk/gdkkeysyms.h>
#endif
#include <glib-object.h>
#include <pango/pango.h>
#include <cairo/cairo.h>
static s7_pointer lg_true, lg_false;
static bool lg_boolean(s7_pointer val) {return(val != lg_false);}
#define lg_make_c_pointer_with_type(Sc, Type, Ptr) s7_make_c_pointer_with_type(Sc, (void *)Ptr, Type, lg_false)


static int xm_obj_tag;
static s7_pointer xm_obj_free(s7_scheme *sc, s7_pointer obj)
{
  free(s7_c_object_value(obj));
  return(NULL);
}
static s7_pointer s7_equal_xm(s7_scheme *sc, s7_pointer args)
{
  return(s7_make_boolean(sc, s7_car(args) == s7_cadr(args)));
}
static s7_pointer make_xm_obj(s7_scheme *sc, void *ptr)
{
  return(s7_make_c_object(sc, xm_obj_tag, ptr));
}
static void define_xm_obj(s7_scheme *sc)
{
  xm_obj_tag = s7_make_c_type(sc, "<gtk_s7>");
  s7_c_type_set_gc_free(sc, xm_obj_tag, xm_obj_free);
  s7_c_type_set_is_equal(sc, xm_obj_tag, s7_equal_xm);
}  

static s7_pointer guint___sym, GDateTime__sym, GtkWindowHandle__sym, GtkWindowControls__sym, GtkWidget___sym,
                  GdkTimeCoord__sym, GtkColorButton__sym, GtkViewport__sym, GtkAspectFrame__sym, GdkKeymapKey__sym,
                  GtkAlternativeTrigger__sym, GtkMnemonicTrigger__sym, GtkKeyvalTrigger__sym, gconstpointer_sym, GtkShortcutController__sym,
                  GtkNamedAction__sym, GtkSignalAction__sym, GtkShortcutFunc_sym, GtkShortcutAction__sym, GtkShortcutTrigger__sym,
                  GtkShortcut__sym, GVariantType__sym, GMenuItem__sym, GtkNative__sym, GVariant__sym,
                  GtkWidgetActionActivateFunc_sym, GtkPopover__sym, GtkTreePath___sym, GtkMenuButtonCreatePopupFunc_sym, GtkDropTargetAsync__sym,
                  gsize__sym, GtkDropTarget__sym, GtkDropControllerMotion__sym, GtkDragIcon__sym, GtkEventControllerFocus__sym,
                  GtkConstraintLayout__sym, GtkConstraintTarget__sym, GtkConstraint__sym, GtkIconPaintable__sym, GtkIconTheme__sym,
                  GtkConstraintGuide__sym, GtkEventControllerMotion__sym, GdkVulkanContext__sym, GError___sym, GdkFrameClock__sym,
                  GdkModifierType__sym, GdkToplevelLayout__sym, GdkToplevel__sym, GtkPopoverMenu__sym, GtkCenterLayout__sym,
                  GtkPopoverMenuBar__sym, GtkNoSelection__sym, GtkDragSource__sym, GdkPopupLayout__sym, GdkPopup__sym,
                  GdkDragSurface__sym, GtkPropagationLimit_sym, GtkGestureLongPress__sym, GtkScaleFormatValueFunc_sym, GdkContentProvider___sym,
                  GtkFixedLayoutChild__sym, GtkTreeDragDest__sym, GtkTreeListRow__sym, GtkTreeListModel__sym, GtkText__sym,
                  GtkSortListModel__sym, GtkSliceListModel__sym, GtkSingleSelection__sym, GtkPasswordEntry__sym, GtkMapListModel__sym,
                  GtkLayoutChild__sym, GtkGridLayoutChild__sym, GtkGridLayout__sym, GtkFlattenListModel__sym, GtkFilterListModel__sym,
                  GtkCustomAllocateFunc_sym, GtkCustomMeasureFunc_sym, GtkCustomRequestModeFunc_sym, GtkBoxLayout__sym, graphene_point_t__sym,
                  graphene_matrix_t__sym, GtkRoot__sym, GtkWidgetClass__sym, GtkLayoutManager__sym, GtkSelectionModel__sym,
                  GtkStackPage__sym, GtkNotebookPage__sym, GskTransform__sym, GParamSpec__sym, GObjectClass__sym,
                  GListModel__sym, GtkAssistantPage__sym, GtkAllocation__sym, GActionGroup__sym, GtkWidgetPaintable__sym,
                  GtkVideo__sym, GtkPicture__sym, gint64_sym, GtkMediaFile__sym, GtkMediaControls__sym,
                  GtkMediaStream__sym, GdkTimeCoord___sym, GtkGestureStylus__sym, GdkGLTexture__sym, GdkDrag__sym,
                  GdkDrop__sym, GdkCairoContext__sym, GdkSurface__sym, GMenu__sym, GApplicationFlags_sym,
                  GdkPaintable__sym, GdkCursor__sym, GBytes__sym, GInputStream__sym, GdkContentDeserializer__sym,
                  GdkContentSerializer__sym, GOutputStream__sym, GdkContentFormatsBuilder__sym, GString__sym, GdkTexture__sym,
                  GAsyncResult__sym, GAsyncReadyCallback_sym, GCancellable__sym, GdkContentProvider__sym, GdkContentFormats__sym,
                  GdkClipboard__sym, GdkAppLaunchContext__sym, GtkEventControllerScroll__sym, GtkEventController__sym, GFile__sym,
                  GtkCssProvider__sym, GtkStyleProvider__sym, GtkScrollbar__sym, GtkCenterBox__sym, GtkCheckButton__sym,
                  GtkDrawingAreaDrawFunc_sym, GtkShortcutLabel__sym, GtkPadActionEntry__sym, GtkPadController__sym, GdkDevicePad__sym,
                  GdkMonitor__sym, GdkDeviceTool__sym, GdkSeat__sym, GtkShortcutsWindow__sym, GtkStackSidebar__sym,
                  GtkStyleContext__sym, GdkGLContext__sym, GtkGLArea__sym, GtkPaned__sym, GtkGestureZoom__sym,
                  GtkGestureSwipe__sym, GtkGestureSingle__sym, GtkGestureRotate__sym, GtkGesturePan__sym, GtkGestureDrag__sym,
                  GdkEventSequence__sym, GtkGesture__sym, GtkActionBar__sym, GtkFlowBox__sym, GtkFlowBoxChild__sym,
                  GtkSearchBar__sym, GtkListBox__sym, GtkListBoxRow__sym, GtkHeaderBar__sym, GtkRevealer__sym,
                  GtkStack__sym, GtkStackSwitcher__sym, GtkLevelBar__sym, GtkMenuButton__sym, GtkColorChooser__sym,
                  GtkApplicationWindow__sym, GtkApplication__sym, GMenuModel__sym, GtkFontChooser__sym, GtkOverlay__sym,
                  GtkWindowGroup__sym, GIcon__sym, GtkOrientable__sym, GtkCellArea__sym, GtkBorder__sym,
                  GtkSwitch__sym, GtkScrollable__sym, GtkGrid__sym, GdkRGBA__sym, GtkComboBoxText__sym,
                  cairo_region_overlap_t_sym, cairo_rectangle_int_t__sym, double__sym, cairo_rectangle_t__sym, cairo_device_t__sym,
                  cairo_text_cluster_flags_t__sym, cairo_text_cluster_t___sym, cairo_glyph_t___sym, cairo_text_cluster_t__sym, cairo_region_t__sym,
                  GtkMessageDialog__sym, GdkDevice__sym, GtkAccessible__sym, GtkSpinner__sym, GtkEntryBuffer__sym,
                  GtkInfoBar__sym, GtkScaleButton__sym, GtkTooltip__sym, cairo_rectangle_list_t__sym, void__sym,
                  cairo_path_t__sym, cairo_destroy_func_t_sym, cairo_user_data_key_t__sym, cairo_text_extents_t__sym, cairo_font_extents_t__sym,
                  cairo_font_face_t__sym, cairo_glyph_t__sym, cairo_scaled_font_t__sym, cairo_matrix_t__sym, cairo_pattern_t__sym,
                  GtkPageRange__sym, GtkPaperSize__sym, GtkPrintSettingsFunc_sym, GtkPageSetupDoneFunc_sym, GtkPrintSettings__sym,
                  GtkPrintOperation__sym, GtkPageSetup__sym, GtkPrintContext__sym, cairo_surface_t__sym, GtkRecentData__sym,
                  GtkRecentInfo__sym, GtkRecentManager__sym, GtkLinkButton__sym, GDestroyNotify_sym, GtkAssistantPageFunc_sym,
                  GtkAssistant__sym, GValue__sym, GLogFunc_sym, PangoMatrix__sym, PangoRenderer__sym,
                  GtkFileChooserButton__sym, PangoScriptIter__sym, PangoAttrFilterFunc_sym, GtkIconViewForeachFunc_sym, gchar___sym,
                  GtkAboutDialog__sym, GtkTreeViewRowSeparatorFunc_sym, GtkCellView__sym, GtkFileChooser__sym, GtkCellLayoutDataFunc_sym,
                  GtkCellLayout__sym, GtkFileFilterFunc_sym, GtkFileFilter__sym, GSourceFunc_sym, GtkEntryCompletionMatchFunc_sym,
                  GtkFontButton__sym, GtkExpander__sym, GtkComboBox__sym, GtkTreeModelFilter__sym, GdkDisplay__sym,
                  PangoLayoutRun__sym, PangoLayoutIter__sym, PangoLayoutLine__sym, int__sym, PangoItem__sym,
                  PangoAnalysis__sym, PangoGlyphString__sym, PangoFontMap__sym, PangoFontFace__sym, PangoFontFace___sym,
                  PangoFontFamily__sym, PangoFontDescription___sym, PangoCoverage__sym, PangoFontMetrics__sym, PangoFontset__sym,
                  PangoFont__sym, PangoFontFamily___sym, PangoLogAttr__sym, PangoAttrList___sym, PangoAttrIterator__sym,
                  PangoRectangle__sym, PangoAttribute__sym, PangoColor__sym, GtkWindow__sym, PangoContext__sym,
                  AtkObject__sym, GtkTreeViewSearchEqualFunc_sym, GtkTreeViewMappingFunc_sym, GtkTreeViewColumnDropFunc_sym, GList__sym,
                  GtkTreeCellDataFunc_sym, GtkTreeStore__sym, GtkTreeIterCompareFunc_sym, GtkTreeSortable__sym, GtkTreeSelectionForeachFunc_sym,
                  GtkTreeModel___sym, GtkTreeSelectionFunc_sym, GtkTreeModelSort__sym, GtkTreeModelForeachFunc_sym, GObject__sym,
                  GtkTreeRowReference__sym, gint__sym, GtkTreeDragSource__sym, GtkToggleButton__sym, PangoTabArray__sym,
                  GtkTextView__sym, GtkTextTagTableForeach_sym, GtkTextCharPredicate_sym, GtkTextMark__sym, GtkTextChildAnchor__sym,
                  GtkTextIter__sym, GtkTextTagTable__sym, GtkTextBuffer__sym, GtkStatusbar__sym, GtkSpinButton__sym,
                  GtkSizeGroup__sym, GtkSettings__sym, GtkScrolledWindow__sym, GtkScale__sym, GtkRange__sym,
                  GtkRadioButton__sym, GSList__sym, GtkProgressBar__sym, GtkNotebook__sym, PangoLanguage__sym,
                  GtkListStore__sym, PangoLayout__sym, GtkLabel__sym, guint16__sym, GtkIMContextSimple__sym,
                  PangoAttrList__sym, GtkIMContext__sym, GtkImage__sym, GtkFrame__sym, GtkFixed__sym,
                  GtkEntry__sym, GtkEditable__sym, etc_sym, GtkDialog__sym, GtkCellRendererToggle__sym,
                  GtkCellRendererText__sym, GtkCellEditable__sym, GtkCalendar__sym, GtkButton__sym, GtkBox__sym,
                  GtkAdjustment__sym, GtkAccelLabel__sym, char___sym, GdkPixbufDestroyNotify_sym, GError__sym,
                  guchar__sym, GdkPixbuf__sym, GdkRectangle__sym, GtkDestroyNotify_sym, GSignalEmissionHook_sym,
                  GSignalInvocationHint__sym, guint__sym, GSignalQuery__sym, GType__sym, GSignalCMarshaller_sym,
                  gpointer_sym, GSignalAccumulator_sym, GClosureNotify_sym, GCallback_sym, GClosure__sym,
                  gunichar__sym, void_sym, GtkDrawingArea__sym, GtkIconView__sym, GtkEntryCompletion__sym,
                  GtkFileFilterInfo__sym, GtkTreeSelection__sym, GtkCellRenderer__sym, GtkTreeViewColumn__sym, GtkTreeView__sym,
                  GtkTreeIter__sym, GtkTreePath__sym, GtkTreeModel__sym, GtkTextTag__sym, lambda_data_sym,
                  GtkWidget__sym, GdkEventMotion__sym, gdouble__sym, GdkEvent__sym, cairo_t__sym,
                  cairo_font_options_t__sym, PangoFontDescription__sym, GtkMenuBar__sym, GtkEventControllerLegacy__sym, GtkCellRendererPixbuf__sym,
                  GtkSeparator__sym, GdkEventExpose__sym, GdkEventNoExpose__sym, GdkEventVisibility__sym, GdkEventButton__sym,
                  GdkEventCrossing__sym, GdkEventFocus__sym, GdkEventConfigure__sym, GdkEventProperty__sym, GdkEventSelection__sym,
                  GdkEventProximity__sym, GdkEventSetting__sym, GdkEventWindowState__sym, GdkEventDND__sym, GtkFileChooserDialog__sym,
                  GtkFileChooserWidget__sym, GtkCellRendererCombo__sym, GtkCellRendererProgress__sym, GtkCellRendererAccel__sym, GtkCellRendererSpin__sym,
                  GtkCellRendererSpinner__sym, GtkFontChooserDialog__sym, GtkFontChooserWidget__sym, GtkColorChooserDialog__sym, GtkColorWidget__sym;

#define lg_is_list(Arg) s7_is_list(sc, Arg)
static s7_scheme *cbsc = NULL;
static void lg_func2(GtkWidget* w, gpointer func_info)
{
  if (!s7_is_list(cbsc, (s7_pointer)func_info)) return;
  s7_call(cbsc, 
    s7_car((s7_pointer)func_info), 
           s7_list(cbsc, 2,
                   lg_make_c_pointer_with_type(cbsc, GtkWidget__sym, w),
                   s7_cadr((s7_pointer)func_info)));
}

static gboolean lg_timer_func(gpointer func_info)
{
  if (!s7_is_list(cbsc, (s7_pointer)func_info)) return((gboolean)0);
  return((gboolean)lg_boolean(s7_call(cbsc, 
    s7_car((s7_pointer)func_info), 
           s7_list(cbsc, 1,
                   s7_cadr((s7_pointer)func_info)))));
}

static void lg_destroy_func(gpointer func_info)
{
  if (!s7_is_list(cbsc, (s7_pointer)func_info)) return;
  s7_call(cbsc, 
    s7_cadddr((s7_pointer)func_info), 
           s7_list(cbsc, 1,
                   s7_cadr((s7_pointer)func_info)));
}

static void lg_text_tag_table_foreach(GtkTextTag* tag, gpointer func_info)
{
  if (!s7_is_list(cbsc, (s7_pointer)func_info)) return;
  s7_call(cbsc, 
    s7_car((s7_pointer)func_info), 
           s7_list(cbsc, 2,
                   lg_make_c_pointer_with_type(cbsc, GtkTextTag__sym, tag),
                   s7_cadr((s7_pointer)func_info)));
}

static gboolean lg_model_func(GtkTreeModel* model, GtkTreePath* path, GtkTreeIter* iter, gpointer func_info)
{
  if (!s7_is_list(cbsc, (s7_pointer)func_info)) return((gboolean)0);
  return((gboolean)lg_boolean(s7_call(cbsc, 
    s7_car((s7_pointer)func_info), 
           s7_list(cbsc, 4,
                   lg_make_c_pointer_with_type(cbsc, GtkTreeModel__sym, model),
                   lg_make_c_pointer_with_type(cbsc, GtkTreePath__sym, path),
                   lg_make_c_pointer_with_type(cbsc, GtkTreeIter__sym, iter),
                   s7_cadr((s7_pointer)func_info)))));
}

static void lg_tree_selection_func(GtkTreeModel* model, GtkTreePath* path, GtkTreeIter* iter, gpointer func_info)
{
  if (!s7_is_list(cbsc, (s7_pointer)func_info)) return;
  s7_call(cbsc, 
    s7_car((s7_pointer)func_info), 
           s7_list(cbsc, 4,
                   lg_make_c_pointer_with_type(cbsc, GtkTreeModel__sym, model),
                   lg_make_c_pointer_with_type(cbsc, GtkTreePath__sym, path),
                   lg_make_c_pointer_with_type(cbsc, GtkTreeIter__sym, iter),
                   s7_cadr((s7_pointer)func_info)));
}

static gboolean lg_text_char_predicate(gunichar ch, gpointer func_info)
{
  if (!s7_is_list(cbsc, (s7_pointer)func_info)) return((gboolean)0);
  return((gboolean)lg_boolean(s7_call(cbsc, 
    s7_car((s7_pointer)func_info), 
           s7_list(cbsc, 2,
                   s7_make_integer(cbsc, ch),
                   s7_cadr((s7_pointer)func_info)))));
}

static gboolean lg_tree_column(GtkTreeView* tree_view, GtkTreeViewColumn* column, GtkTreeViewColumn* prev_column, GtkTreeViewColumn* next_column, gpointer func_info)
{
  if (!s7_is_list(cbsc, (s7_pointer)func_info)) return((gboolean)0);
  return((gboolean)lg_boolean(s7_call(cbsc, 
    s7_car((s7_pointer)func_info), 
           s7_list(cbsc, 5,
                   lg_make_c_pointer_with_type(cbsc, GtkTreeView__sym, tree_view),
                   lg_make_c_pointer_with_type(cbsc, GtkTreeViewColumn__sym, column),
                   lg_make_c_pointer_with_type(cbsc, GtkTreeViewColumn__sym, prev_column),
                   lg_make_c_pointer_with_type(cbsc, GtkTreeViewColumn__sym, next_column),
                   s7_cadr((s7_pointer)func_info)))));
}

static void lg_tree_mapping(GtkTreeView* tree_view, GtkTreePath* path, gpointer func_info)
{
  if (!s7_is_list(cbsc, (s7_pointer)func_info)) return;
  s7_call(cbsc, 
    s7_car((s7_pointer)func_info), 
           s7_list(cbsc, 3,
                   lg_make_c_pointer_with_type(cbsc, GtkTreeView__sym, tree_view),
                   lg_make_c_pointer_with_type(cbsc, GtkTreePath__sym, path),
                   s7_cadr((s7_pointer)func_info)));
}

static gboolean lg_tree_search(GtkTreeModel* model, gint column, const gchar* key, GtkTreeIter* iter, gpointer func_info)
{
  if (!s7_is_list(cbsc, (s7_pointer)func_info)) return((gboolean)0);
  return((gboolean)lg_boolean(s7_call(cbsc, 
    s7_car((s7_pointer)func_info), 
           s7_list(cbsc, 5,
                   lg_make_c_pointer_with_type(cbsc, GtkTreeModel__sym, model),
                   s7_make_integer(cbsc, column),
                   s7_make_string(cbsc, key),
                   lg_make_c_pointer_with_type(cbsc, GtkTreeIter__sym, iter),
                   s7_cadr((s7_pointer)func_info)))));
}

static void lg_cell_data(GtkTreeViewColumn* tree_column, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter, gpointer func_info)
{
  if (!s7_is_list(cbsc, (s7_pointer)func_info)) return;
  s7_call(cbsc, 
    s7_car((s7_pointer)func_info), 
           s7_list(cbsc, 5,
                   lg_make_c_pointer_with_type(cbsc, GtkTreeViewColumn__sym, tree_column),
                   lg_make_c_pointer_with_type(cbsc, GtkCellRenderer__sym, cell),
                   lg_make_c_pointer_with_type(cbsc, GtkTreeModel__sym, tree_model),
                   lg_make_c_pointer_with_type(cbsc, GtkTreeIter__sym, iter),
                   s7_cadr((s7_pointer)func_info)));
}

static gint lg_iter_compare(GtkTreeModel* model, GtkTreeIter* a, GtkTreeIter* b, gpointer func_info)
{
  if (!s7_is_list(cbsc, (s7_pointer)func_info)) return((gint)0);
  return((gint)s7_integer(s7_call(cbsc, 
    s7_car((s7_pointer)func_info), 
           s7_list(cbsc, 4,
                   lg_make_c_pointer_with_type(cbsc, GtkTreeModel__sym, model),
                   lg_make_c_pointer_with_type(cbsc, GtkTreeIter__sym, a),
                   lg_make_c_pointer_with_type(cbsc, GtkTreeIter__sym, b),
                   s7_cadr((s7_pointer)func_info)))));
}

static gboolean lg_tree_selection(GtkTreeSelection* selection, GtkTreeModel* model, GtkTreePath* path, gboolean path_currently_selected, gpointer func_info)
{
  if (!s7_is_list(cbsc, (s7_pointer)func_info)) return((gboolean)0);
  return((gboolean)lg_boolean(s7_call(cbsc, 
    s7_car((s7_pointer)func_info), 
           s7_list(cbsc, 5,
                   lg_make_c_pointer_with_type(cbsc, GtkTreeSelection__sym, selection),
                   lg_make_c_pointer_with_type(cbsc, GtkTreeModel__sym, model),
                   lg_make_c_pointer_with_type(cbsc, GtkTreePath__sym, path),
                   s7_make_boolean(cbsc, path_currently_selected),
                   s7_cadr((s7_pointer)func_info)))));
}

static gboolean lg_file_filter(const GtkFileFilterInfo* info, gpointer func_info)
{
  if (!s7_is_list(cbsc, (s7_pointer)func_info)) return((gboolean)0);
  return((gboolean)lg_boolean(s7_call(cbsc, 
    s7_car((s7_pointer)func_info), 
           s7_list(cbsc, 2,
                   lg_make_c_pointer_with_type(cbsc, GtkFileFilterInfo__sym, (void *)info),
                   s7_cadr((s7_pointer)func_info)))));
}

static gboolean lg_entry_completion_match(GtkEntryCompletion* completion, const gchar* key, GtkTreeIter* iter, gpointer func_info)
{
  if (!s7_is_list(cbsc, (s7_pointer)func_info)) return((gboolean)0);
  return((gboolean)lg_boolean(s7_call(cbsc, 
    s7_car((s7_pointer)func_info), 
           s7_list(cbsc, 4,
                   lg_make_c_pointer_with_type(cbsc, GtkEntryCompletion__sym, completion),
                   s7_make_string(cbsc, key),
                   lg_make_c_pointer_with_type(cbsc, GtkTreeIter__sym, iter),
                   s7_cadr((s7_pointer)func_info)))));
}

static gboolean lg_row_separator(GtkTreeModel* model, GtkTreeIter* iter, gpointer func_info)
{
  if (!s7_is_list(cbsc, (s7_pointer)func_info)) return((gboolean)0);
  return((gboolean)lg_boolean(s7_call(cbsc, 
    s7_car((s7_pointer)func_info), 
           s7_list(cbsc, 3,
                   lg_make_c_pointer_with_type(cbsc, GtkTreeModel__sym, model),
                   lg_make_c_pointer_with_type(cbsc, GtkTreeIter__sym, iter),
                   s7_cadr((s7_pointer)func_info)))));
}

static void lg_icon_view_foreach(GtkIconView* icon_view, GtkTreePath* path, gpointer func_info)
{
  if (!s7_is_list(cbsc, (s7_pointer)func_info)) return;
  s7_call(cbsc, 
    s7_car((s7_pointer)func_info), 
           s7_list(cbsc, 3,
                   lg_make_c_pointer_with_type(cbsc, GtkIconView__sym, icon_view),
                   lg_make_c_pointer_with_type(cbsc, GtkTreePath__sym, path),
                   s7_cadr((s7_pointer)func_info)));
}

static void lg_g_message_log_func(const gchar* domain, GLogLevelFlags log_level, const gchar* message, gpointer func_info)
{
  if (!s7_is_list(cbsc, (s7_pointer)func_info)) return;
  s7_call(cbsc, 
    s7_car((s7_pointer)func_info), 
           s7_list(cbsc, 4,
                   s7_make_string(cbsc, domain),
                   s7_make_integer(cbsc, log_level),
                   s7_make_string(cbsc, message),
                   s7_cadr((s7_pointer)func_info)));
}

static gint lg_page_func(gint current_page, gpointer func_info)
{
  if (!s7_is_list(cbsc, (s7_pointer)func_info)) return((gint)0);
  return((gint)s7_integer(s7_call(cbsc, 
    s7_car((s7_pointer)func_info), 
           s7_list(cbsc, 2,
                   s7_make_integer(cbsc, current_page),
                   s7_cadr((s7_pointer)func_info)))));
}

#if GTK_CHECK_VERSION(3, 92, 0)
static void lg_draw_func(GtkDrawingArea* self, cairo_t* cr, int width, int height, gpointer func_info)
{
  if (!s7_is_list(cbsc, (s7_pointer)func_info)) return;
  s7_call(cbsc, 
    s7_car((s7_pointer)func_info), 
           s7_list(cbsc, 5,
                   lg_make_c_pointer_with_type(cbsc, GtkDrawingArea__sym, self),
                   lg_make_c_pointer_with_type(cbsc, cairo_t__sym, cr),
                   s7_make_integer(cbsc, width),
                   s7_make_integer(cbsc, height),
                   s7_cadr((s7_pointer)func_info)));
}
#endif


static gboolean lg_func3(GtkWidget *w, GdkEvent *ev, gpointer data)
{
  return(s7_call(cbsc, s7_car((s7_pointer)data),
                       s7_list(cbsc, 3, s7_make_c_pointer_with_type(cbsc, w, GtkWidget__sym, lg_false),
                                        s7_make_c_pointer_with_type(cbsc, ev, GdkEvent__sym, lg_false),
                                        (s7_is_pair(s7_cdr((s7_pointer)data))) ? (s7_cadr((s7_pointer)data)) : s7_nil(cbsc))) != lg_false);
}

static gboolean lg_func4(GtkPrintOperation *op, GtkPrintContext *context, gint page_nr, gpointer data)
{
  return(s7_call(cbsc, s7_car((s7_pointer)data),
                       s7_list(cbsc, 4, s7_make_c_pointer_with_type(cbsc, op, GtkPrintOperation__sym, lg_false),
                                        s7_make_c_pointer_with_type(cbsc, context, GtkPrintContext__sym, lg_false),
                                        s7_make_integer(cbsc, page_nr),
                                        (s7_is_pair(s7_cdr((s7_pointer)data))) ? (s7_cadr((s7_pointer)data)) : s7_nil(cbsc))) != lg_false);
}

static s7_pointer lg_g_unichar_validate(s7_scheme *sc, s7_pointer args)
{
  #define H_g_unichar_validate "gboolean g_unichar_validate(gunichar ch)"
  s7_pointer ch;
  ch = s7_car(args);
  if (!s7_is_integer(ch)) s7_wrong_type_arg_error(sc, "g_unichar_validate", 1, ch, "gunichar");
  return(s7_make_boolean(sc, g_unichar_validate((gunichar)s7_integer(ch))));
}

static s7_pointer lg_g_unichar_isalnum(s7_scheme *sc, s7_pointer args)
{
  #define H_g_unichar_isalnum "gboolean g_unichar_isalnum(gunichar c)"
  s7_pointer c;
  c = s7_car(args);
  if (!s7_is_integer(c)) s7_wrong_type_arg_error(sc, "g_unichar_isalnum", 1, c, "gunichar");
  return(s7_make_boolean(sc, g_unichar_isalnum((gunichar)s7_integer(c))));
}

static s7_pointer lg_g_unichar_isalpha(s7_scheme *sc, s7_pointer args)
{
  #define H_g_unichar_isalpha "gboolean g_unichar_isalpha(gunichar c)"
  s7_pointer c;
  c = s7_car(args);
  if (!s7_is_integer(c)) s7_wrong_type_arg_error(sc, "g_unichar_isalpha", 1, c, "gunichar");
  return(s7_make_boolean(sc, g_unichar_isalpha((gunichar)s7_integer(c))));
}

static s7_pointer lg_g_unichar_iscntrl(s7_scheme *sc, s7_pointer args)
{
  #define H_g_unichar_iscntrl "gboolean g_unichar_iscntrl(gunichar c)"
  s7_pointer c;
  c = s7_car(args);
  if (!s7_is_integer(c)) s7_wrong_type_arg_error(sc, "g_unichar_iscntrl", 1, c, "gunichar");
  return(s7_make_boolean(sc, g_unichar_iscntrl((gunichar)s7_integer(c))));
}

static s7_pointer lg_g_unichar_isdefined(s7_scheme *sc, s7_pointer args)
{
  #define H_g_unichar_isdefined "gboolean g_unichar_isdefined(gunichar c)"
  s7_pointer c;
  c = s7_car(args);
  if (!s7_is_integer(c)) s7_wrong_type_arg_error(sc, "g_unichar_isdefined", 1, c, "gunichar");
  return(s7_make_boolean(sc, g_unichar_isdefined((gunichar)s7_integer(c))));
}

static s7_pointer lg_g_unichar_isdigit(s7_scheme *sc, s7_pointer args)
{
  #define H_g_unichar_isdigit "gboolean g_unichar_isdigit(gunichar c)"
  s7_pointer c;
  c = s7_car(args);
  if (!s7_is_integer(c)) s7_wrong_type_arg_error(sc, "g_unichar_isdigit", 1, c, "gunichar");
  return(s7_make_boolean(sc, g_unichar_isdigit((gunichar)s7_integer(c))));
}

static s7_pointer lg_g_unichar_isgraph(s7_scheme *sc, s7_pointer args)
{
  #define H_g_unichar_isgraph "gboolean g_unichar_isgraph(gunichar c)"
  s7_pointer c;
  c = s7_car(args);
  if (!s7_is_integer(c)) s7_wrong_type_arg_error(sc, "g_unichar_isgraph", 1, c, "gunichar");
  return(s7_make_boolean(sc, g_unichar_isgraph((gunichar)s7_integer(c))));
}

static s7_pointer lg_g_unichar_islower(s7_scheme *sc, s7_pointer args)
{
  #define H_g_unichar_islower "gboolean g_unichar_islower(gunichar c)"
  s7_pointer c;
  c = s7_car(args);
  if (!s7_is_integer(c)) s7_wrong_type_arg_error(sc, "g_unichar_islower", 1, c, "gunichar");
  return(s7_make_boolean(sc, g_unichar_islower((gunichar)s7_integer(c))));
}

static s7_pointer lg_g_unichar_ismark(s7_scheme *sc, s7_pointer args)
{
  #define H_g_unichar_ismark "gboolean g_unichar_ismark(gunichar c)"
  s7_pointer c;
  c = s7_car(args);
  if (!s7_is_integer(c)) s7_wrong_type_arg_error(sc, "g_unichar_ismark", 1, c, "gunichar");
  return(s7_make_boolean(sc, g_unichar_ismark((gunichar)s7_integer(c))));
}

static s7_pointer lg_g_unichar_isprint(s7_scheme *sc, s7_pointer args)
{
  #define H_g_unichar_isprint "gboolean g_unichar_isprint(gunichar c)"
  s7_pointer c;
  c = s7_car(args);
  if (!s7_is_integer(c)) s7_wrong_type_arg_error(sc, "g_unichar_isprint", 1, c, "gunichar");
  return(s7_make_boolean(sc, g_unichar_isprint((gunichar)s7_integer(c))));
}

static s7_pointer lg_g_unichar_ispunct(s7_scheme *sc, s7_pointer args)
{
  #define H_g_unichar_ispunct "gboolean g_unichar_ispunct(gunichar c)"
  s7_pointer c;
  c = s7_car(args);
  if (!s7_is_integer(c)) s7_wrong_type_arg_error(sc, "g_unichar_ispunct", 1, c, "gunichar");
  return(s7_make_boolean(sc, g_unichar_ispunct((gunichar)s7_integer(c))));
}

static s7_pointer lg_g_unichar_isspace(s7_scheme *sc, s7_pointer args)
{
  #define H_g_unichar_isspace "gboolean g_unichar_isspace(gunichar c)"
  s7_pointer c;
  c = s7_car(args);
  if (!s7_is_integer(c)) s7_wrong_type_arg_error(sc, "g_unichar_isspace", 1, c, "gunichar");
  return(s7_make_boolean(sc, g_unichar_isspace((gunichar)s7_integer(c))));
}

static s7_pointer lg_g_unichar_istitle(s7_scheme *sc, s7_pointer args)
{
  #define H_g_unichar_istitle "gboolean g_unichar_istitle(gunichar c)"
  s7_pointer c;
  c = s7_car(args);
  if (!s7_is_integer(c)) s7_wrong_type_arg_error(sc, "g_unichar_istitle", 1, c, "gunichar");
  return(s7_make_boolean(sc, g_unichar_istitle((gunichar)s7_integer(c))));
}

static s7_pointer lg_g_unichar_isupper(s7_scheme *sc, s7_pointer args)
{
  #define H_g_unichar_isupper "gboolean g_unichar_isupper(gunichar c)"
  s7_pointer c;
  c = s7_car(args);
  if (!s7_is_integer(c)) s7_wrong_type_arg_error(sc, "g_unichar_isupper", 1, c, "gunichar");
  return(s7_make_boolean(sc, g_unichar_isupper((gunichar)s7_integer(c))));
}

static s7_pointer lg_g_unichar_isxdigit(s7_scheme *sc, s7_pointer args)
{
  #define H_g_unichar_isxdigit "gboolean g_unichar_isxdigit(gunichar c)"
  s7_pointer c;
  c = s7_car(args);
  if (!s7_is_integer(c)) s7_wrong_type_arg_error(sc, "g_unichar_isxdigit", 1, c, "gunichar");
  return(s7_make_boolean(sc, g_unichar_isxdigit((gunichar)s7_integer(c))));
}

static s7_pointer lg_g_unichar_iswide(s7_scheme *sc, s7_pointer args)
{
  #define H_g_unichar_iswide "gboolean g_unichar_iswide(gunichar c)"
  s7_pointer c;
  c = s7_car(args);
  if (!s7_is_integer(c)) s7_wrong_type_arg_error(sc, "g_unichar_iswide", 1, c, "gunichar");
  return(s7_make_boolean(sc, g_unichar_iswide((gunichar)s7_integer(c))));
}

static s7_pointer lg_g_unichar_iswide_cjk(s7_scheme *sc, s7_pointer args)
{
  #define H_g_unichar_iswide_cjk "gboolean g_unichar_iswide_cjk(gunichar c)"
  s7_pointer c;
  c = s7_car(args);
  if (!s7_is_integer(c)) s7_wrong_type_arg_error(sc, "g_unichar_iswide_cjk", 1, c, "gunichar");
  return(s7_make_boolean(sc, g_unichar_iswide_cjk((gunichar)s7_integer(c))));
}

static s7_pointer lg_g_unichar_iszerowidth(s7_scheme *sc, s7_pointer args)
{
  #define H_g_unichar_iszerowidth "gboolean g_unichar_iszerowidth(gunichar c)"
  s7_pointer c;
  c = s7_car(args);
  if (!s7_is_integer(c)) s7_wrong_type_arg_error(sc, "g_unichar_iszerowidth", 1, c, "gunichar");
  return(s7_make_boolean(sc, g_unichar_iszerowidth((gunichar)s7_integer(c))));
}

static s7_pointer lg_g_unichar_toupper(s7_scheme *sc, s7_pointer args)
{
  #define H_g_unichar_toupper "gunichar g_unichar_toupper(gunichar c)"
  s7_pointer c;
  c = s7_car(args);
  if (!s7_is_integer(c)) s7_wrong_type_arg_error(sc, "g_unichar_toupper", 1, c, "gunichar");
  return(s7_make_integer(sc, g_unichar_toupper((gunichar)s7_integer(c))));
}

static s7_pointer lg_g_unichar_tolower(s7_scheme *sc, s7_pointer args)
{
  #define H_g_unichar_tolower "gunichar g_unichar_tolower(gunichar c)"
  s7_pointer c;
  c = s7_car(args);
  if (!s7_is_integer(c)) s7_wrong_type_arg_error(sc, "g_unichar_tolower", 1, c, "gunichar");
  return(s7_make_integer(sc, g_unichar_tolower((gunichar)s7_integer(c))));
}

static s7_pointer lg_g_unichar_totitle(s7_scheme *sc, s7_pointer args)
{
  #define H_g_unichar_totitle "gunichar g_unichar_totitle(gunichar c)"
  s7_pointer c;
  c = s7_car(args);
  if (!s7_is_integer(c)) s7_wrong_type_arg_error(sc, "g_unichar_totitle", 1, c, "gunichar");
  return(s7_make_integer(sc, g_unichar_totitle((gunichar)s7_integer(c))));
}

static s7_pointer lg_g_unichar_digit_value(s7_scheme *sc, s7_pointer args)
{
  #define H_g_unichar_digit_value "gint g_unichar_digit_value(gunichar c)"
  s7_pointer c;
  c = s7_car(args);
  if (!s7_is_integer(c)) s7_wrong_type_arg_error(sc, "g_unichar_digit_value", 1, c, "gunichar");
  return(s7_make_integer(sc, g_unichar_digit_value((gunichar)s7_integer(c))));
}

static s7_pointer lg_g_unichar_xdigit_value(s7_scheme *sc, s7_pointer args)
{
  #define H_g_unichar_xdigit_value "gint g_unichar_xdigit_value(gunichar c)"
  s7_pointer c;
  c = s7_car(args);
  if (!s7_is_integer(c)) s7_wrong_type_arg_error(sc, "g_unichar_xdigit_value", 1, c, "gunichar");
  return(s7_make_integer(sc, g_unichar_xdigit_value((gunichar)s7_integer(c))));
}

static s7_pointer lg_g_unichar_combining_class(s7_scheme *sc, s7_pointer args)
{
  #define H_g_unichar_combining_class "gint g_unichar_combining_class(gunichar uc)"
  s7_pointer uc;
  uc = s7_car(args);
  if (!s7_is_integer(uc)) s7_wrong_type_arg_error(sc, "g_unichar_combining_class", 1, uc, "gunichar");
  return(s7_make_integer(sc, g_unichar_combining_class((gunichar)s7_integer(uc))));
}

static s7_pointer lg_g_unicode_canonical_ordering(s7_scheme *sc, s7_pointer args)
{
  #define H_g_unicode_canonical_ordering "void g_unicode_canonical_ordering(gunichar* string, gsize len)"
  s7_pointer _p;
  s7_pointer string, len;
  _p = args;
  string = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(string, gunichar__sym)) s7_wrong_type_arg_error(sc, "g_unicode_canonical_ordering", 1, string, "gunichar*");
  len = s7_car(_p);
  if (!s7_is_integer(len)) s7_wrong_type_arg_error(sc, "g_unicode_canonical_ordering", 2, len, "gsize");
  g_unicode_canonical_ordering((gunichar*)s7_c_pointer(string), (gsize)s7_integer(len));
  return(lg_false);
}

static s7_pointer lg_g_utf8_get_char(s7_scheme *sc, s7_pointer args)
{
  #define H_g_utf8_get_char "gunichar g_utf8_get_char(gchar* p)"
  s7_pointer p;
  p = s7_car(args);
  if (!s7_is_string(p)) s7_wrong_type_arg_error(sc, "g_utf8_get_char", 1, p, "gchar*");
  return(s7_make_integer(sc, g_utf8_get_char((const gchar*)s7_string(p))));
}

static s7_pointer lg_g_utf8_get_char_validated(s7_scheme *sc, s7_pointer args)
{
  #define H_g_utf8_get_char_validated "gunichar g_utf8_get_char_validated(gchar* p, gssize max_len)"
  s7_pointer _p;
  s7_pointer p, max_len;
  _p = args;
  p = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(p)) s7_wrong_type_arg_error(sc, "g_utf8_get_char_validated", 1, p, "gchar*");
  max_len = s7_car(_p);
  if (!s7_is_integer(max_len)) s7_wrong_type_arg_error(sc, "g_utf8_get_char_validated", 2, max_len, "gssize");
  return(s7_make_integer(sc, g_utf8_get_char_validated((const gchar*)s7_string(p), (gssize)s7_integer(max_len))));
}

static s7_pointer lg_g_utf8_prev_char(s7_scheme *sc, s7_pointer args)
{
  #define H_g_utf8_prev_char "gchar* g_utf8_prev_char(gchar* p)"
  s7_pointer p;
  p = s7_car(args);
  if (!s7_is_string(p)) s7_wrong_type_arg_error(sc, "g_utf8_prev_char", 1, p, "gchar*");
  return(s7_make_string(sc, g_utf8_prev_char((const gchar*)s7_string(p))));
}

static s7_pointer lg_g_utf8_find_next_char(s7_scheme *sc, s7_pointer args)
{
  #define H_g_utf8_find_next_char "gchar* g_utf8_find_next_char(gchar* p, gchar* end)"
  s7_pointer _p;
  s7_pointer p, end;
  _p = args;
  p = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(p)) s7_wrong_type_arg_error(sc, "g_utf8_find_next_char", 1, p, "gchar*");
  end = s7_car(_p);
  if (!s7_is_string(end)) s7_wrong_type_arg_error(sc, "g_utf8_find_next_char", 2, end, "gchar*");
  return(s7_make_string(sc, g_utf8_find_next_char((const gchar*)s7_string(p), (const gchar*)s7_string(end))));
}

static s7_pointer lg_g_utf8_find_prev_char(s7_scheme *sc, s7_pointer args)
{
  #define H_g_utf8_find_prev_char "gchar* g_utf8_find_prev_char(gchar* str, gchar* p)"
  s7_pointer _p;
  s7_pointer str, p;
  _p = args;
  str = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(str)) s7_wrong_type_arg_error(sc, "g_utf8_find_prev_char", 1, str, "gchar*");
  p = s7_car(_p);
  if (!s7_is_string(p)) s7_wrong_type_arg_error(sc, "g_utf8_find_prev_char", 2, p, "gchar*");
  return(s7_make_string(sc, g_utf8_find_prev_char((const gchar*)s7_string(str), (const gchar*)s7_string(p))));
}

static s7_pointer lg_g_utf8_strlen(s7_scheme *sc, s7_pointer args)
{
  #define H_g_utf8_strlen "glong g_utf8_strlen(gchar* p, gssize max)"
  s7_pointer _p;
  s7_pointer p, max;
  _p = args;
  p = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(p)) s7_wrong_type_arg_error(sc, "g_utf8_strlen", 1, p, "gchar*");
  max = s7_car(_p);
  if (!s7_is_integer(max)) s7_wrong_type_arg_error(sc, "g_utf8_strlen", 2, max, "gssize");
  return(s7_make_integer(sc, g_utf8_strlen((const gchar*)s7_string(p), (gssize)s7_integer(max))));
}

static s7_pointer lg_g_utf8_strchr(s7_scheme *sc, s7_pointer args)
{
  #define H_g_utf8_strchr "gchar* g_utf8_strchr(gchar* p, gssize len, gunichar c)"
  s7_pointer _p;
  s7_pointer p, len, c;
  _p = args;
  p = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(p)) s7_wrong_type_arg_error(sc, "g_utf8_strchr", 1, p, "gchar*");
  len = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(len)) s7_wrong_type_arg_error(sc, "g_utf8_strchr", 2, len, "gssize");
  c = s7_car(_p);
  if (!s7_is_integer(c)) s7_wrong_type_arg_error(sc, "g_utf8_strchr", 3, c, "gunichar");
  return(s7_make_string(sc, g_utf8_strchr((const gchar*)s7_string(p), (gssize)s7_integer(len), (gunichar)s7_integer(c))));
}

static s7_pointer lg_g_utf8_strrchr(s7_scheme *sc, s7_pointer args)
{
  #define H_g_utf8_strrchr "gchar* g_utf8_strrchr(gchar* p, gssize len, gunichar c)"
  s7_pointer _p;
  s7_pointer p, len, c;
  _p = args;
  p = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(p)) s7_wrong_type_arg_error(sc, "g_utf8_strrchr", 1, p, "gchar*");
  len = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(len)) s7_wrong_type_arg_error(sc, "g_utf8_strrchr", 2, len, "gssize");
  c = s7_car(_p);
  if (!s7_is_integer(c)) s7_wrong_type_arg_error(sc, "g_utf8_strrchr", 3, c, "gunichar");
  return(s7_make_string(sc, g_utf8_strrchr((const gchar*)s7_string(p), (gssize)s7_integer(len), (gunichar)s7_integer(c))));
}

static s7_pointer lg_g_utf8_strreverse(s7_scheme *sc, s7_pointer args)
{
  #define H_g_utf8_strreverse "gchar* g_utf8_strreverse(gchar* str, gssize len)"
  s7_pointer _p;
  s7_pointer str, len;
  _p = args;
  str = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(str)) s7_wrong_type_arg_error(sc, "g_utf8_strreverse", 1, str, "gchar*");
  len = s7_car(_p);
  if (!s7_is_integer(len)) s7_wrong_type_arg_error(sc, "g_utf8_strreverse", 2, len, "gssize");
  return(s7_make_string(sc, g_utf8_strreverse((const gchar*)s7_string(str), (gssize)s7_integer(len))));
}

static s7_pointer lg_g_utf8_validate(s7_scheme *sc, s7_pointer args)
{
  #define H_g_utf8_validate "gboolean g_utf8_validate(gchar* str, gssize max_len, gchar** [end])"
  s7_pointer _p;
  s7_pointer str, max_len;
  gchar* ref_end = NULL;
  _p = args;
  str = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(str)) s7_wrong_type_arg_error(sc, "g_utf8_validate", 1, str, "gchar*");
  max_len = s7_car(_p);
  if (!s7_is_integer(max_len)) s7_wrong_type_arg_error(sc, "g_utf8_validate", 2, max_len, "gssize");
  {
    s7_pointer res_ult;
    res_ult = s7_make_boolean(sc, g_utf8_validate((const gchar*)s7_string(str), (gssize)s7_integer(max_len), (const gchar**)&ref_end));
      return(s7_list(sc, 2, res_ult, s7_make_string(sc, ref_end)));
   }
}

static s7_pointer lg_g_utf8_strup(s7_scheme *sc, s7_pointer args)
{
  #define H_g_utf8_strup "gchar* g_utf8_strup(gchar* str, gssize len)"
  s7_pointer _p;
  s7_pointer str, len;
  _p = args;
  str = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(str)) s7_wrong_type_arg_error(sc, "g_utf8_strup", 1, str, "gchar*");
  len = s7_car(_p);
  if (!s7_is_integer(len)) s7_wrong_type_arg_error(sc, "g_utf8_strup", 2, len, "gssize");
  return(s7_make_string(sc, g_utf8_strup((const gchar*)s7_string(str), (gssize)s7_integer(len))));
}

static s7_pointer lg_g_utf8_strdown(s7_scheme *sc, s7_pointer args)
{
  #define H_g_utf8_strdown "gchar* g_utf8_strdown(gchar* str, gssize len)"
  s7_pointer _p;
  s7_pointer str, len;
  _p = args;
  str = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(str)) s7_wrong_type_arg_error(sc, "g_utf8_strdown", 1, str, "gchar*");
  len = s7_car(_p);
  if (!s7_is_integer(len)) s7_wrong_type_arg_error(sc, "g_utf8_strdown", 2, len, "gssize");
  return(s7_make_string(sc, g_utf8_strdown((const gchar*)s7_string(str), (gssize)s7_integer(len))));
}

static s7_pointer lg_g_utf8_casefold(s7_scheme *sc, s7_pointer args)
{
  #define H_g_utf8_casefold "gchar* g_utf8_casefold(gchar* str, gssize len)"
  s7_pointer _p;
  s7_pointer str, len;
  _p = args;
  str = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(str)) s7_wrong_type_arg_error(sc, "g_utf8_casefold", 1, str, "gchar*");
  len = s7_car(_p);
  if (!s7_is_integer(len)) s7_wrong_type_arg_error(sc, "g_utf8_casefold", 2, len, "gssize");
  return(s7_make_string(sc, g_utf8_casefold((const gchar*)s7_string(str), (gssize)s7_integer(len))));
}

static s7_pointer lg_g_utf8_normalize(s7_scheme *sc, s7_pointer args)
{
  #define H_g_utf8_normalize "gchar* g_utf8_normalize(gchar* str, gssize len, GNormalizeMode mode)"
  s7_pointer _p;
  s7_pointer str, len, mode;
  _p = args;
  str = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(str)) s7_wrong_type_arg_error(sc, "g_utf8_normalize", 1, str, "gchar*");
  len = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(len)) s7_wrong_type_arg_error(sc, "g_utf8_normalize", 2, len, "gssize");
  mode = s7_car(_p);
  if (!s7_is_integer(mode)) s7_wrong_type_arg_error(sc, "g_utf8_normalize", 3, mode, "GNormalizeMode");
  return(s7_make_string(sc, g_utf8_normalize((const gchar*)s7_string(str), (gssize)s7_integer(len), (GNormalizeMode)s7_integer(mode))));
}

static s7_pointer lg_g_utf8_collate(s7_scheme *sc, s7_pointer args)
{
  #define H_g_utf8_collate "gint g_utf8_collate(gchar* str1, gchar* str2)"
  s7_pointer _p;
  s7_pointer str1, str2;
  _p = args;
  str1 = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(str1)) s7_wrong_type_arg_error(sc, "g_utf8_collate", 1, str1, "gchar*");
  str2 = s7_car(_p);
  if (!s7_is_string(str2)) s7_wrong_type_arg_error(sc, "g_utf8_collate", 2, str2, "gchar*");
  return(s7_make_integer(sc, g_utf8_collate((const gchar*)s7_string(str1), (const gchar*)s7_string(str2))));
}

static s7_pointer lg_g_utf8_collate_key(s7_scheme *sc, s7_pointer args)
{
  #define H_g_utf8_collate_key "gchar* g_utf8_collate_key(gchar* str, gssize len)"
  s7_pointer _p;
  s7_pointer str, len;
  _p = args;
  str = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(str)) s7_wrong_type_arg_error(sc, "g_utf8_collate_key", 1, str, "gchar*");
  len = s7_car(_p);
  if (!s7_is_integer(len)) s7_wrong_type_arg_error(sc, "g_utf8_collate_key", 2, len, "gssize");
  return(s7_make_string(sc, g_utf8_collate_key((const gchar*)s7_string(str), (gssize)s7_integer(len))));
}

static s7_pointer lg_g_utf8_collate_key_for_filename(s7_scheme *sc, s7_pointer args)
{
  #define H_g_utf8_collate_key_for_filename "gchar* g_utf8_collate_key_for_filename(gchar* str, gssize len)"
  s7_pointer _p;
  s7_pointer str, len;
  _p = args;
  str = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(str)) s7_wrong_type_arg_error(sc, "g_utf8_collate_key_for_filename", 1, str, "gchar*");
  len = s7_car(_p);
  if (!s7_is_integer(len)) s7_wrong_type_arg_error(sc, "g_utf8_collate_key_for_filename", 2, len, "gssize");
  return(s7_make_string(sc, g_utf8_collate_key_for_filename((const gchar*)s7_string(str), (gssize)s7_integer(len))));
}

static s7_pointer lg_g_cclosure_new(s7_scheme *sc, s7_pointer args)
{
  #define H_g_cclosure_new "GClosure* g_cclosure_new(GCallback func, lambda_data func_info, GClosureNotify destroy_data)"
  s7_pointer _p;
  s7_pointer func, func_info, destroy_data;
  _p = args;
  func = s7_car(_p); _p = s7_cdr(_p);
  func_info = s7_car(_p); _p = s7_cdr(_p);
  destroy_data = s7_car(_p);
  if ((!s7_is_c_pointer_of_type(destroy_data, GClosureNotify_sym)) && (destroy_data != lg_false)) s7_wrong_type_arg_error(sc, "g_cclosure_new", 3, destroy_data, "GClosureNotify");
  {
    s7_pointer res_ult;
    int loc;
    s7_pointer lg_ptr = s7_list(sc, 5, func, func_info, lg_false, lg_false, lg_false);
    loc = s7_gc_protect(sc, lg_ptr);
    s7_list_set(sc, lg_ptr, 2, s7_make_integer(sc, loc));
    res_ult = lg_make_c_pointer_with_type(sc, GClosure__sym, g_cclosure_new(((s7_is_aritable(sc, func, 4)) ? (GCallback)lg_func4 : ((s7_is_aritable(sc, func, 3)) ? (GCallback)lg_func3 : (GCallback)lg_func2)), (gpointer)lg_ptr, NULL));
    return(res_ult);
   }
}

static s7_pointer lg_g_signal_newv(s7_scheme *sc, s7_pointer args)
{
  #define H_g_signal_newv "guint g_signal_newv(gchar* signal_name, GType itype, GSignalFlags signal_flags, \
GClosure* class_closure, GSignalAccumulator accumulator, gpointer accu_data, GSignalCMarshaller c_marshaller, \
GType return_type, guint n_params, GType* param_types)"
  s7_pointer _p;
  s7_pointer signal_name, itype, signal_flags, class_closure, accumulator, accu_data, c_marshaller, return_type, n_params, param_types;
  _p = args;
  signal_name = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(signal_name)) s7_wrong_type_arg_error(sc, "g_signal_newv", 1, signal_name, "gchar*");
  itype = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(itype)) s7_wrong_type_arg_error(sc, "g_signal_newv", 2, itype, "GType");
  signal_flags = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(signal_flags)) s7_wrong_type_arg_error(sc, "g_signal_newv", 3, signal_flags, "GSignalFlags");
  class_closure = s7_car(_p); _p = s7_cdr(_p);
  if ((!s7_is_c_pointer_of_type(class_closure, GClosure__sym)) && (class_closure != lg_false)) s7_wrong_type_arg_error(sc, "g_signal_newv", 4, class_closure, "GClosure*");
  accumulator = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(accumulator, GSignalAccumulator_sym)) s7_wrong_type_arg_error(sc, "g_signal_newv", 5, accumulator, "GSignalAccumulator");
  accu_data = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(accu_data, gpointer_sym)) s7_wrong_type_arg_error(sc, "g_signal_newv", 6, accu_data, "gpointer");
  c_marshaller = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(c_marshaller, GSignalCMarshaller_sym)) s7_wrong_type_arg_error(sc, "g_signal_newv", 7, c_marshaller, "GSignalCMarshaller");
  return_type = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(return_type)) s7_wrong_type_arg_error(sc, "g_signal_newv", 8, return_type, "GType");
  n_params = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(n_params)) s7_wrong_type_arg_error(sc, "g_signal_newv", 9, n_params, "guint");
  param_types = s7_car(_p);
  if (!s7_is_c_pointer_of_type(param_types, GType__sym)) s7_wrong_type_arg_error(sc, "g_signal_newv", 10, param_types, "GType*");
  return(s7_make_integer(sc, g_signal_newv((gchar*)s7_string(signal_name), (GType)s7_integer(itype), (GSignalFlags)s7_integer(signal_flags), (class_closure == lg_false) ? NULL : (GClosure*)s7_c_pointer(class_closure), (GSignalAccumulator)s7_c_pointer(accumulator), (gpointer)s7_c_pointer(accu_data), (GSignalCMarshaller)s7_c_pointer(c_marshaller), (GType)s7_integer(return_type), (guint)s7_integer(n_params), (GType*)s7_c_pointer(param_types))));
}

static s7_pointer lg_g_signal_lookup(s7_scheme *sc, s7_pointer args)
{
  #define H_g_signal_lookup "guint g_signal_lookup(gchar* name, GType itype)"
  s7_pointer _p;
  s7_pointer name, itype;
  _p = args;
  name = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(name)) s7_wrong_type_arg_error(sc, "g_signal_lookup", 1, name, "gchar*");
  itype = s7_car(_p);
  if (!s7_is_integer(itype)) s7_wrong_type_arg_error(sc, "g_signal_lookup", 2, itype, "GType");
  return(s7_make_integer(sc, g_signal_lookup((gchar*)s7_string(name), (GType)s7_integer(itype))));
}

static s7_pointer lg_g_signal_name(s7_scheme *sc, s7_pointer args)
{
  #define H_g_signal_name "gchar* g_signal_name(guint signal_id)"
  s7_pointer signal_id;
  signal_id = s7_car(args);
  if (!s7_is_integer(signal_id)) s7_wrong_type_arg_error(sc, "g_signal_name", 1, signal_id, "guint");
  return(s7_make_string(sc, g_signal_name((guint)s7_integer(signal_id))));
}

static s7_pointer lg_g_signal_query(s7_scheme *sc, s7_pointer args)
{
  #define H_g_signal_query "void g_signal_query(guint signal_id, GSignalQuery* query)"
  s7_pointer _p;
  s7_pointer signal_id, query;
  _p = args;
  signal_id = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(signal_id)) s7_wrong_type_arg_error(sc, "g_signal_query", 1, signal_id, "guint");
  query = s7_car(_p);
  if (!s7_is_c_pointer_of_type(query, GSignalQuery__sym)) s7_wrong_type_arg_error(sc, "g_signal_query", 2, query, "GSignalQuery*");
  g_signal_query((guint)s7_integer(signal_id), (GSignalQuery*)s7_c_pointer(query));
  return(lg_false);
}

static s7_pointer lg_g_signal_list_ids(s7_scheme *sc, s7_pointer args)
{
  #define H_g_signal_list_ids "guint* g_signal_list_ids(GType itype, guint* n_ids)"
  s7_pointer _p;
  s7_pointer itype, n_ids;
  _p = args;
  itype = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(itype)) s7_wrong_type_arg_error(sc, "g_signal_list_ids", 1, itype, "GType");
  n_ids = s7_car(_p);
  if (!s7_is_c_pointer_of_type(n_ids, guint__sym)) s7_wrong_type_arg_error(sc, "g_signal_list_ids", 2, n_ids, "guint*");
  return(lg_make_c_pointer_with_type(sc, guint__sym, g_signal_list_ids((GType)s7_integer(itype), (guint*)s7_c_pointer(n_ids))));
}

static s7_pointer lg_g_signal_parse_name(s7_scheme *sc, s7_pointer args)
{
  #define H_g_signal_parse_name "gboolean g_signal_parse_name(gchar* detailed_signal, GType itype, guint* [signal_id_p], \
GQuark* [detail_p], gboolean force_detail_quark)"
  s7_pointer _p;
  s7_pointer detailed_signal, itype, force_detail_quark;
  guint ref_signal_id_p;
  GQuark ref_detail_p;
  _p = args;
  detailed_signal = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(detailed_signal)) s7_wrong_type_arg_error(sc, "g_signal_parse_name", 1, detailed_signal, "gchar*");
  itype = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(itype)) s7_wrong_type_arg_error(sc, "g_signal_parse_name", 2, itype, "GType");
  force_detail_quark = s7_car(_p);
  if (!s7_is_boolean(force_detail_quark)) s7_wrong_type_arg_error(sc, "g_signal_parse_name", 5, force_detail_quark, "gboolean");
  {
    s7_pointer res_ult;
    res_ult = s7_make_boolean(sc, g_signal_parse_name((gchar*)s7_string(detailed_signal), (GType)s7_integer(itype), &ref_signal_id_p, &ref_detail_p, (gboolean)lg_boolean(force_detail_quark)));
      return(s7_list(sc, 3, res_ult, s7_make_integer(sc, ref_signal_id_p), s7_make_integer(sc, ref_detail_p)));
   }
}

static s7_pointer lg_g_signal_get_invocation_hint(s7_scheme *sc, s7_pointer args)
{
  #define H_g_signal_get_invocation_hint "GSignalInvocationHint* g_signal_get_invocation_hint(gpointer instance)"
  s7_pointer instance;
  instance = s7_car(args);
  if (!s7_is_c_pointer_of_type(instance, gpointer_sym)) s7_wrong_type_arg_error(sc, "g_signal_get_invocation_hint", 1, instance, "gpointer");
  return(lg_make_c_pointer_with_type(sc, GSignalInvocationHint__sym, g_signal_get_invocation_hint((gpointer)s7_c_pointer(instance))));
}

static s7_pointer lg_g_signal_stop_emission(s7_scheme *sc, s7_pointer args)
{
  #define H_g_signal_stop_emission "void g_signal_stop_emission(gpointer instance, guint signal_id, GQuark detail)"
  s7_pointer _p;
  s7_pointer instance, signal_id, detail;
  _p = args;
  instance = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(instance, gpointer_sym)) s7_wrong_type_arg_error(sc, "g_signal_stop_emission", 1, instance, "gpointer");
  signal_id = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(signal_id)) s7_wrong_type_arg_error(sc, "g_signal_stop_emission", 2, signal_id, "guint");
  detail = s7_car(_p);
  if (!s7_is_integer(detail)) s7_wrong_type_arg_error(sc, "g_signal_stop_emission", 3, detail, "GQuark");
  g_signal_stop_emission((gpointer)s7_c_pointer(instance), (guint)s7_integer(signal_id), (GQuark)s7_integer(detail));
  return(lg_false);
}

static s7_pointer lg_g_signal_stop_emission_by_name(s7_scheme *sc, s7_pointer args)
{
  #define H_g_signal_stop_emission_by_name "void g_signal_stop_emission_by_name(gpointer instance, gchar* detailed_signal)"
  s7_pointer _p;
  s7_pointer instance, detailed_signal;
  _p = args;
  instance = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(instance, gpointer_sym)) s7_wrong_type_arg_error(sc, "g_signal_stop_emission_by_name", 1, instance, "gpointer");
  detailed_signal = s7_car(_p);
  if (!s7_is_string(detailed_signal)) s7_wrong_type_arg_error(sc, "g_signal_stop_emission_by_name", 2, detailed_signal, "gchar*");
  g_signal_stop_emission_by_name((gpointer)s7_c_pointer(instance), (gchar*)s7_string(detailed_signal));
  return(lg_false);
}

static s7_pointer lg_g_signal_add_emission_hook(s7_scheme *sc, s7_pointer args)
{
  #define H_g_signal_add_emission_hook "gulong g_signal_add_emission_hook(guint signal_id, GQuark quark, \
GSignalEmissionHook hook_func, lambda_data func_info, GtkDestroyNotify data_destroy)"
  s7_pointer _p;
  s7_pointer signal_id, quark, hook_func, func_info, data_destroy;
  _p = args;
  signal_id = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(signal_id)) s7_wrong_type_arg_error(sc, "g_signal_add_emission_hook", 1, signal_id, "guint");
  quark = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(quark)) s7_wrong_type_arg_error(sc, "g_signal_add_emission_hook", 2, quark, "GQuark");
  hook_func = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(hook_func, GSignalEmissionHook_sym)) s7_wrong_type_arg_error(sc, "g_signal_add_emission_hook", 3, hook_func, "GSignalEmissionHook");
  func_info = s7_car(_p); _p = s7_cdr(_p);
  data_destroy = s7_car(_p);
  {
    s7_pointer res_ult;
    s7_pointer lg_ptr = s7_list(sc, 5, lg_false, func_info, lg_false, lg_false, lg_false);
    s7_gc_protect(sc, lg_ptr);
    s7_list_set(sc, lg_ptr, 3, data_destroy);
    res_ult = s7_make_integer(sc, g_signal_add_emission_hook((guint)s7_integer(signal_id), (GQuark)s7_integer(quark), (GSignalEmissionHook)s7_c_pointer(hook_func), (gpointer)lg_ptr, lg_destroy_func));
    return(res_ult);
   }
}

static s7_pointer lg_g_signal_remove_emission_hook(s7_scheme *sc, s7_pointer args)
{
  #define H_g_signal_remove_emission_hook "void g_signal_remove_emission_hook(guint signal_id, gulong hook_id)"
  s7_pointer _p;
  s7_pointer signal_id, hook_id;
  _p = args;
  signal_id = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(signal_id)) s7_wrong_type_arg_error(sc, "g_signal_remove_emission_hook", 1, signal_id, "guint");
  hook_id = s7_car(_p);
  if (!s7_is_integer(hook_id)) s7_wrong_type_arg_error(sc, "g_signal_remove_emission_hook", 2, hook_id, "gulong");
  g_signal_remove_emission_hook((guint)s7_integer(signal_id), (gulong)s7_integer(hook_id));
  return(lg_false);
}

static s7_pointer lg_g_signal_has_handler_pending(s7_scheme *sc, s7_pointer args)
{
  #define H_g_signal_has_handler_pending "gboolean g_signal_has_handler_pending(gpointer instance, guint signal_id, \
GQuark detail, gboolean may_be_blocked)"
  s7_pointer _p;
  s7_pointer instance, signal_id, detail, may_be_blocked;
  _p = args;
  instance = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(instance, gpointer_sym)) s7_wrong_type_arg_error(sc, "g_signal_has_handler_pending", 1, instance, "gpointer");
  signal_id = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(signal_id)) s7_wrong_type_arg_error(sc, "g_signal_has_handler_pending", 2, signal_id, "guint");
  detail = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(detail)) s7_wrong_type_arg_error(sc, "g_signal_has_handler_pending", 3, detail, "GQuark");
  may_be_blocked = s7_car(_p);
  if (!s7_is_boolean(may_be_blocked)) s7_wrong_type_arg_error(sc, "g_signal_has_handler_pending", 4, may_be_blocked, "gboolean");
  return(s7_make_boolean(sc, g_signal_has_handler_pending((gpointer)s7_c_pointer(instance), (guint)s7_integer(signal_id), (GQuark)s7_integer(detail), (gboolean)lg_boolean(may_be_blocked))));
}

static s7_pointer lg_g_signal_connect_closure_by_id(s7_scheme *sc, s7_pointer args)
{
  #define H_g_signal_connect_closure_by_id "gulong g_signal_connect_closure_by_id(gpointer instance, \
guint signal_id, GQuark detail, GClosure* closure, gboolean after)"
  s7_pointer _p;
  s7_pointer instance, signal_id, detail, closure, after;
  _p = args;
  instance = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(instance, gpointer_sym)) s7_wrong_type_arg_error(sc, "g_signal_connect_closure_by_id", 1, instance, "gpointer");
  signal_id = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(signal_id)) s7_wrong_type_arg_error(sc, "g_signal_connect_closure_by_id", 2, signal_id, "guint");
  detail = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(detail)) s7_wrong_type_arg_error(sc, "g_signal_connect_closure_by_id", 3, detail, "GQuark");
  closure = s7_car(_p); _p = s7_cdr(_p);
  if ((!s7_is_c_pointer_of_type(closure, GClosure__sym)) && (closure != lg_false)) s7_wrong_type_arg_error(sc, "g_signal_connect_closure_by_id", 4, closure, "GClosure*");
  after = s7_car(_p);
  if (!s7_is_boolean(after)) s7_wrong_type_arg_error(sc, "g_signal_connect_closure_by_id", 5, after, "gboolean");
  return(s7_make_integer(sc, g_signal_connect_closure_by_id((gpointer)s7_c_pointer(instance), (guint)s7_integer(signal_id), (GQuark)s7_integer(detail), (closure == lg_false) ? NULL : (GClosure*)s7_c_pointer(closure), (gboolean)lg_boolean(after))));
}

static s7_pointer lg_g_signal_connect_closure(s7_scheme *sc, s7_pointer args)
{
  #define H_g_signal_connect_closure "gulong g_signal_connect_closure(gpointer instance, gchar* detailed_signal, \
GClosure* closure, gboolean after)"
  s7_pointer _p;
  s7_pointer instance, detailed_signal, closure, after;
  _p = args;
  instance = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(instance, gpointer_sym)) s7_wrong_type_arg_error(sc, "g_signal_connect_closure", 1, instance, "gpointer");
  detailed_signal = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(detailed_signal)) s7_wrong_type_arg_error(sc, "g_signal_connect_closure", 2, detailed_signal, "gchar*");
  closure = s7_car(_p); _p = s7_cdr(_p);
  if ((!s7_is_c_pointer_of_type(closure, GClosure__sym)) && (closure != lg_false)) s7_wrong_type_arg_error(sc, "g_signal_connect_closure", 3, closure, "GClosure*");
  after = s7_car(_p);
  if (!s7_is_boolean(after)) s7_wrong_type_arg_error(sc, "g_signal_connect_closure", 4, after, "gboolean");
  return(s7_make_integer(sc, g_signal_connect_closure((gpointer)s7_c_pointer(instance), (gchar*)s7_string(detailed_signal), (closure == lg_false) ? NULL : (GClosure*)s7_c_pointer(closure), (gboolean)lg_boolean(after))));
}

static s7_pointer lg_g_signal_connect_data(s7_scheme *sc, s7_pointer args)
{
  #define H_g_signal_connect_data "gulong g_signal_connect_data(gpointer instance, gchar* detailed_signal, \
GCallback func, lambda_data func_info, GClosureNotify destroy_data, GConnectFlags connect_flags)"
  s7_pointer _p;
  s7_pointer instance, detailed_signal, func, func_info, destroy_data, connect_flags;
  _p = args;
  instance = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(instance, gpointer_sym)) s7_wrong_type_arg_error(sc, "g_signal_connect_data", 1, instance, "gpointer");
  detailed_signal = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(detailed_signal)) s7_wrong_type_arg_error(sc, "g_signal_connect_data", 2, detailed_signal, "gchar*");
  func = s7_car(_p); _p = s7_cdr(_p);
  func_info = s7_car(_p); _p = s7_cdr(_p);
  destroy_data = s7_car(_p); _p = s7_cdr(_p);
  if ((!s7_is_c_pointer_of_type(destroy_data, GClosureNotify_sym)) && (destroy_data != lg_false)) s7_wrong_type_arg_error(sc, "g_signal_connect_data", 5, destroy_data, "GClosureNotify");
  connect_flags = s7_car(_p);
  if (!s7_is_integer(connect_flags)) s7_wrong_type_arg_error(sc, "g_signal_connect_data", 6, connect_flags, "GConnectFlags");
  {
    s7_pointer res_ult;
    int loc;
    s7_pointer lg_ptr = s7_list(sc, 5, func, func_info, lg_false, lg_false, lg_false);
    loc = s7_gc_protect(sc, lg_ptr);
    s7_list_set(sc, lg_ptr, 2, s7_make_integer(sc, loc));
    res_ult = s7_make_integer(sc, g_signal_connect_data((gpointer)s7_c_pointer(instance), (gchar*)s7_string(detailed_signal), ((s7_is_aritable(sc, func, 4)) ? (GCallback)lg_func4 : ((s7_is_aritable(sc, func, 3)) ? (GCallback)lg_func3 : (GCallback)lg_func2)), (gpointer)lg_ptr, NULL, (GConnectFlags)s7_integer(connect_flags)));
    return(res_ult);
   }
}

static s7_pointer lg_g_signal_handler_block(s7_scheme *sc, s7_pointer args)
{
  #define H_g_signal_handler_block "void g_signal_handler_block(gpointer instance, gulong handler_id)"
  s7_pointer _p;
  s7_pointer instance, handler_id;
  _p = args;
  instance = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(instance, gpointer_sym)) s7_wrong_type_arg_error(sc, "g_signal_handler_block", 1, instance, "gpointer");
  handler_id = s7_car(_p);
  if (!s7_is_integer(handler_id)) s7_wrong_type_arg_error(sc, "g_signal_handler_block", 2, handler_id, "gulong");
  g_signal_handler_block((gpointer)s7_c_pointer(instance), (gulong)s7_integer(handler_id));
  return(lg_false);
}

static s7_pointer lg_g_signal_handler_unblock(s7_scheme *sc, s7_pointer args)
{
  #define H_g_signal_handler_unblock "void g_signal_handler_unblock(gpointer instance, gulong handler_id)"
  s7_pointer _p;
  s7_pointer instance, handler_id;
  _p = args;
  instance = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(instance, gpointer_sym)) s7_wrong_type_arg_error(sc, "g_signal_handler_unblock", 1, instance, "gpointer");
  handler_id = s7_car(_p);
  if (!s7_is_integer(handler_id)) s7_wrong_type_arg_error(sc, "g_signal_handler_unblock", 2, handler_id, "gulong");
  g_signal_handler_unblock((gpointer)s7_c_pointer(instance), (gulong)s7_integer(handler_id));
  return(lg_false);
}

static s7_pointer lg_g_signal_handler_disconnect(s7_scheme *sc, s7_pointer args)
{
  #define H_g_signal_handler_disconnect "void g_signal_handler_disconnect(gpointer instance, gulong handler_id)"
  s7_pointer _p;
  s7_pointer instance, handler_id;
  _p = args;
  instance = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(instance, gpointer_sym)) s7_wrong_type_arg_error(sc, "g_signal_handler_disconnect", 1, instance, "gpointer");
  handler_id = s7_car(_p);
  if (!s7_is_integer(handler_id)) s7_wrong_type_arg_error(sc, "g_signal_handler_disconnect", 2, handler_id, "gulong");
  g_signal_handler_disconnect((gpointer)s7_c_pointer(instance), (gulong)s7_integer(handler_id));
  return(lg_false);
}

static s7_pointer lg_g_signal_handler_is_connected(s7_scheme *sc, s7_pointer args)
{
  #define H_g_signal_handler_is_connected "gboolean g_signal_handler_is_connected(gpointer instance, \
gulong handler_id)"
  s7_pointer _p;
  s7_pointer instance, handler_id;
  _p = args;
  instance = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(instance, gpointer_sym)) s7_wrong_type_arg_error(sc, "g_signal_handler_is_connected", 1, instance, "gpointer");
  handler_id = s7_car(_p);
  if (!s7_is_integer(handler_id)) s7_wrong_type_arg_error(sc, "g_signal_handler_is_connected", 2, handler_id, "gulong");
  return(s7_make_boolean(sc, g_signal_handler_is_connected((gpointer)s7_c_pointer(instance), (gulong)s7_integer(handler_id))));
}

static s7_pointer lg_g_signal_handler_find(s7_scheme *sc, s7_pointer args)
{
  #define H_g_signal_handler_find "gulong g_signal_handler_find(gpointer instance, GSignalMatchType mask, \
guint signal_id, GQuark detail, GClosure* closure, gpointer func, gpointer data)"
  s7_pointer _p;
  s7_pointer instance, mask, signal_id, detail, closure, func, data;
  _p = args;
  instance = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(instance, gpointer_sym)) s7_wrong_type_arg_error(sc, "g_signal_handler_find", 1, instance, "gpointer");
  mask = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(mask)) s7_wrong_type_arg_error(sc, "g_signal_handler_find", 2, mask, "GSignalMatchType");
  signal_id = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(signal_id)) s7_wrong_type_arg_error(sc, "g_signal_handler_find", 3, signal_id, "guint");
  detail = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(detail)) s7_wrong_type_arg_error(sc, "g_signal_handler_find", 4, detail, "GQuark");
  closure = s7_car(_p); _p = s7_cdr(_p);
  if ((!s7_is_c_pointer_of_type(closure, GClosure__sym)) && (closure != lg_false)) s7_wrong_type_arg_error(sc, "g_signal_handler_find", 5, closure, "GClosure*");
  func = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(func, gpointer_sym)) s7_wrong_type_arg_error(sc, "g_signal_handler_find", 6, func, "gpointer");
  data = s7_car(_p);
  if (!s7_is_c_pointer_of_type(data, gpointer_sym)) s7_wrong_type_arg_error(sc, "g_signal_handler_find", 7, data, "gpointer");
  return(s7_make_integer(sc, g_signal_handler_find((gpointer)s7_c_pointer(instance), (GSignalMatchType)s7_integer(mask), (guint)s7_integer(signal_id), (GQuark)s7_integer(detail), (closure == lg_false) ? NULL : (GClosure*)s7_c_pointer(closure), (gpointer)s7_c_pointer(func), (gpointer)s7_c_pointer(data))));
}

static s7_pointer lg_g_signal_handlers_block_matched(s7_scheme *sc, s7_pointer args)
{
  #define H_g_signal_handlers_block_matched "guint g_signal_handlers_block_matched(gpointer instance, \
GSignalMatchType mask, guint signal_id, GQuark detail, GClosure* closure, gpointer func, gpointer data)"
  s7_pointer _p;
  s7_pointer instance, mask, signal_id, detail, closure, func, data;
  _p = args;
  instance = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(instance, gpointer_sym)) s7_wrong_type_arg_error(sc, "g_signal_handlers_block_matched", 1, instance, "gpointer");
  mask = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(mask)) s7_wrong_type_arg_error(sc, "g_signal_handlers_block_matched", 2, mask, "GSignalMatchType");
  signal_id = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(signal_id)) s7_wrong_type_arg_error(sc, "g_signal_handlers_block_matched", 3, signal_id, "guint");
  detail = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(detail)) s7_wrong_type_arg_error(sc, "g_signal_handlers_block_matched", 4, detail, "GQuark");
  closure = s7_car(_p); _p = s7_cdr(_p);
  if ((!s7_is_c_pointer_of_type(closure, GClosure__sym)) && (closure != lg_false)) s7_wrong_type_arg_error(sc, "g_signal_handlers_block_matched", 5, closure, "GClosure*");
  func = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(func, gpointer_sym)) s7_wrong_type_arg_error(sc, "g_signal_handlers_block_matched", 6, func, "gpointer");
  data = s7_car(_p);
  if (!s7_is_c_pointer_of_type(data, gpointer_sym)) s7_wrong_type_arg_error(sc, "g_signal_handlers_block_matched", 7, data, "gpointer");
  return(s7_make_integer(sc, g_signal_handlers_block_matched((gpointer)s7_c_pointer(instance), (GSignalMatchType)s7_integer(mask), (guint)s7_integer(signal_id), (GQuark)s7_integer(detail), (closure == lg_false) ? NULL : (GClosure*)s7_c_pointer(closure), (gpointer)s7_c_pointer(func), (gpointer)s7_c_pointer(data))));
}

static s7_pointer lg_g_signal_handlers_unblock_matched(s7_scheme *sc, s7_pointer args)
{
  #define H_g_signal_handlers_unblock_matched "guint g_signal_handlers_unblock_matched(gpointer instance, \
GSignalMatchType mask, guint signal_id, GQuark detail, GClosure* closure, gpointer func, gpointer data)"
  s7_pointer _p;
  s7_pointer instance, mask, signal_id, detail, closure, func, data;
  _p = args;
  instance = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(instance, gpointer_sym)) s7_wrong_type_arg_error(sc, "g_signal_handlers_unblock_matched", 1, instance, "gpointer");
  mask = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(mask)) s7_wrong_type_arg_error(sc, "g_signal_handlers_unblock_matched", 2, mask, "GSignalMatchType");
  signal_id = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(signal_id)) s7_wrong_type_arg_error(sc, "g_signal_handlers_unblock_matched", 3, signal_id, "guint");
  detail = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(detail)) s7_wrong_type_arg_error(sc, "g_signal_handlers_unblock_matched", 4, detail, "GQuark");
  closure = s7_car(_p); _p = s7_cdr(_p);
  if ((!s7_is_c_pointer_of_type(closure, GClosure__sym)) && (closure != lg_false)) s7_wrong_type_arg_error(sc, "g_signal_handlers_unblock_matched", 5, closure, "GClosure*");
  func = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(func, gpointer_sym)) s7_wrong_type_arg_error(sc, "g_signal_handlers_unblock_matched", 6, func, "gpointer");
  data = s7_car(_p);
  if (!s7_is_c_pointer_of_type(data, gpointer_sym)) s7_wrong_type_arg_error(sc, "g_signal_handlers_unblock_matched", 7, data, "gpointer");
  return(s7_make_integer(sc, g_signal_handlers_unblock_matched((gpointer)s7_c_pointer(instance), (GSignalMatchType)s7_integer(mask), (guint)s7_integer(signal_id), (GQuark)s7_integer(detail), (closure == lg_false) ? NULL : (GClosure*)s7_c_pointer(closure), (gpointer)s7_c_pointer(func), (gpointer)s7_c_pointer(data))));
}

static s7_pointer lg_g_signal_handlers_disconnect_matched(s7_scheme *sc, s7_pointer args)
{
  #define H_g_signal_handlers_disconnect_matched "guint g_signal_handlers_disconnect_matched(gpointer instance, \
GSignalMatchType mask, guint signal_id, GQuark detail, GClosure* closure, gpointer func, gpointer data)"
  s7_pointer _p;
  s7_pointer instance, mask, signal_id, detail, closure, func, data;
  _p = args;
  instance = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(instance, gpointer_sym)) s7_wrong_type_arg_error(sc, "g_signal_handlers_disconnect_matched", 1, instance, "gpointer");
  mask = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(mask)) s7_wrong_type_arg_error(sc, "g_signal_handlers_disconnect_matched", 2, mask, "GSignalMatchType");
  signal_id = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(signal_id)) s7_wrong_type_arg_error(sc, "g_signal_handlers_disconnect_matched", 3, signal_id, "guint");
  detail = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(detail)) s7_wrong_type_arg_error(sc, "g_signal_handlers_disconnect_matched", 4, detail, "GQuark");
  closure = s7_car(_p); _p = s7_cdr(_p);
  if ((!s7_is_c_pointer_of_type(closure, GClosure__sym)) && (closure != lg_false)) s7_wrong_type_arg_error(sc, "g_signal_handlers_disconnect_matched", 5, closure, "GClosure*");
  func = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(func, gpointer_sym)) s7_wrong_type_arg_error(sc, "g_signal_handlers_disconnect_matched", 6, func, "gpointer");
  data = s7_car(_p);
  if (!s7_is_c_pointer_of_type(data, gpointer_sym)) s7_wrong_type_arg_error(sc, "g_signal_handlers_disconnect_matched", 7, data, "gpointer");
  return(s7_make_integer(sc, g_signal_handlers_disconnect_matched((gpointer)s7_c_pointer(instance), (GSignalMatchType)s7_integer(mask), (guint)s7_integer(signal_id), (GQuark)s7_integer(detail), (closure == lg_false) ? NULL : (GClosure*)s7_c_pointer(closure), (gpointer)s7_c_pointer(func), (gpointer)s7_c_pointer(data))));
}

static s7_pointer lg_g_signal_handlers_destroy(s7_scheme *sc, s7_pointer args)
{
  #define H_g_signal_handlers_destroy "void g_signal_handlers_destroy(gpointer instance)"
  s7_pointer instance;
  instance = s7_car(args);
  if (!s7_is_c_pointer_of_type(instance, gpointer_sym)) s7_wrong_type_arg_error(sc, "g_signal_handlers_destroy", 1, instance, "gpointer");
  g_signal_handlers_destroy((gpointer)s7_c_pointer(instance));
  return(lg_false);
}

static s7_pointer lg_g_object_ref(s7_scheme *sc, s7_pointer args)
{
  #define H_g_object_ref "gpointer g_object_ref(gpointer object)"
  s7_pointer object;
  object = s7_car(args);
  if (!s7_is_c_pointer_of_type(object, gpointer_sym)) s7_wrong_type_arg_error(sc, "g_object_ref", 1, object, "gpointer");
  return(lg_make_c_pointer_with_type(sc, gpointer_sym, g_object_ref((gpointer)s7_c_pointer(object))));
}

static s7_pointer lg_g_object_unref(s7_scheme *sc, s7_pointer args)
{
  #define H_g_object_unref "void g_object_unref(gpointer object)"
  s7_pointer object;
  object = s7_car(args);
  if (!s7_is_c_pointer_of_type(object, gpointer_sym)) s7_wrong_type_arg_error(sc, "g_object_unref", 1, object, "gpointer");
  g_object_unref((gpointer)s7_c_pointer(object));
  return(lg_false);
}

static s7_pointer lg_gdk_event_get_time(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_event_get_time "guint32 gdk_event_get_time(GdkEvent* event)"
  s7_pointer event;
  event = s7_car(args);
  if ((!s7_is_c_pointer_of_type(event, GdkEvent__sym)) && (event != lg_false)) s7_wrong_type_arg_error(sc, "gdk_event_get_time", 1, event, "GdkEvent*");
  return(s7_make_integer(sc, gdk_event_get_time((GdkEvent*)s7_c_pointer(event))));
}

static s7_pointer lg_gdk_rectangle_intersect(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_rectangle_intersect "gboolean gdk_rectangle_intersect(GdkRectangle* src1, GdkRectangle* src2, \
GdkRectangle* dest)"
  s7_pointer _p;
  s7_pointer src1, src2, dest;
  _p = args;
  src1 = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(src1, GdkRectangle__sym)) s7_wrong_type_arg_error(sc, "gdk_rectangle_intersect", 1, src1, "GdkRectangle*");
  src2 = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(src2, GdkRectangle__sym)) s7_wrong_type_arg_error(sc, "gdk_rectangle_intersect", 2, src2, "GdkRectangle*");
  dest = s7_car(_p);
  if (!s7_is_c_pointer_of_type(dest, GdkRectangle__sym)) s7_wrong_type_arg_error(sc, "gdk_rectangle_intersect", 3, dest, "GdkRectangle*");
  return(s7_make_boolean(sc, gdk_rectangle_intersect((GdkRectangle*)s7_c_pointer(src1), (GdkRectangle*)s7_c_pointer(src2), (GdkRectangle*)s7_c_pointer(dest))));
}

static s7_pointer lg_gdk_rectangle_union(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_rectangle_union "void gdk_rectangle_union(GdkRectangle* src1, GdkRectangle* src2, GdkRectangle* dest)"
  s7_pointer _p;
  s7_pointer src1, src2, dest;
  _p = args;
  src1 = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(src1, GdkRectangle__sym)) s7_wrong_type_arg_error(sc, "gdk_rectangle_union", 1, src1, "GdkRectangle*");
  src2 = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(src2, GdkRectangle__sym)) s7_wrong_type_arg_error(sc, "gdk_rectangle_union", 2, src2, "GdkRectangle*");
  dest = s7_car(_p);
  if (!s7_is_c_pointer_of_type(dest, GdkRectangle__sym)) s7_wrong_type_arg_error(sc, "gdk_rectangle_union", 3, dest, "GdkRectangle*");
  gdk_rectangle_union((GdkRectangle*)s7_c_pointer(src1), (GdkRectangle*)s7_c_pointer(src2), (GdkRectangle*)s7_c_pointer(dest));
  return(lg_false);
}

static s7_pointer lg_gdk_keyval_name(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_keyval_name "gchar* gdk_keyval_name(guint keyval)"
  s7_pointer keyval;
  keyval = s7_car(args);
  if (!s7_is_integer(keyval)) s7_wrong_type_arg_error(sc, "gdk_keyval_name", 1, keyval, "guint");
  return(s7_make_string(sc, gdk_keyval_name((guint)s7_integer(keyval))));
}

static s7_pointer lg_gdk_keyval_from_name(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_keyval_from_name "guint gdk_keyval_from_name(gchar* keyval_name)"
  s7_pointer keyval_name;
  keyval_name = s7_car(args);
  if (!s7_is_string(keyval_name)) s7_wrong_type_arg_error(sc, "gdk_keyval_from_name", 1, keyval_name, "gchar*");
  return(s7_make_integer(sc, gdk_keyval_from_name((gchar*)s7_string(keyval_name))));
}

static s7_pointer lg_gdk_keyval_convert_case(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_keyval_convert_case "void gdk_keyval_convert_case(guint symbol, guint* [lower], guint* [upper])"
  s7_pointer _p;
  s7_pointer symbol;
  guint ref_lower;
  guint ref_upper;
  _p = args;
  symbol = s7_car(_p);
  if (!s7_is_integer(symbol)) s7_wrong_type_arg_error(sc, "gdk_keyval_convert_case", 1, symbol, "guint");
  gdk_keyval_convert_case((guint)s7_integer(symbol), &ref_lower, &ref_upper);
    return(s7_list(sc, 2, s7_make_integer(sc, ref_lower), s7_make_integer(sc, ref_upper)));
}

static s7_pointer lg_gdk_keyval_to_upper(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_keyval_to_upper "guint gdk_keyval_to_upper(guint keyval)"
  s7_pointer keyval;
  keyval = s7_car(args);
  if (!s7_is_integer(keyval)) s7_wrong_type_arg_error(sc, "gdk_keyval_to_upper", 1, keyval, "guint");
  return(s7_make_integer(sc, gdk_keyval_to_upper((guint)s7_integer(keyval))));
}

static s7_pointer lg_gdk_keyval_to_lower(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_keyval_to_lower "guint gdk_keyval_to_lower(guint keyval)"
  s7_pointer keyval;
  keyval = s7_car(args);
  if (!s7_is_integer(keyval)) s7_wrong_type_arg_error(sc, "gdk_keyval_to_lower", 1, keyval, "guint");
  return(s7_make_integer(sc, gdk_keyval_to_lower((guint)s7_integer(keyval))));
}

static s7_pointer lg_gdk_keyval_is_upper(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_keyval_is_upper "gboolean gdk_keyval_is_upper(guint keyval)"
  s7_pointer keyval;
  keyval = s7_car(args);
  if (!s7_is_integer(keyval)) s7_wrong_type_arg_error(sc, "gdk_keyval_is_upper", 1, keyval, "guint");
  return(s7_make_boolean(sc, gdk_keyval_is_upper((guint)s7_integer(keyval))));
}

static s7_pointer lg_gdk_keyval_is_lower(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_keyval_is_lower "gboolean gdk_keyval_is_lower(guint keyval)"
  s7_pointer keyval;
  keyval = s7_car(args);
  if (!s7_is_integer(keyval)) s7_wrong_type_arg_error(sc, "gdk_keyval_is_lower", 1, keyval, "guint");
  return(s7_make_boolean(sc, gdk_keyval_is_lower((guint)s7_integer(keyval))));
}

static s7_pointer lg_gdk_keyval_to_unicode(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_keyval_to_unicode "guint32 gdk_keyval_to_unicode(guint keyval)"
  s7_pointer keyval;
  keyval = s7_car(args);
  if (!s7_is_integer(keyval)) s7_wrong_type_arg_error(sc, "gdk_keyval_to_unicode", 1, keyval, "guint");
  return(s7_make_integer(sc, gdk_keyval_to_unicode((guint)s7_integer(keyval))));
}

static s7_pointer lg_gdk_unicode_to_keyval(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_unicode_to_keyval "guint gdk_unicode_to_keyval(guint32 wc)"
  s7_pointer wc;
  wc = s7_car(args);
  if (!s7_is_integer(wc)) s7_wrong_type_arg_error(sc, "gdk_unicode_to_keyval", 1, wc, "guint32");
  return(s7_make_integer(sc, gdk_unicode_to_keyval((guint32)s7_integer(wc))));
}

static s7_pointer lg_gdk_pixbuf_error_quark(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_pixbuf_error_quark "GQuark gdk_pixbuf_error_quark( void)"
  return(s7_make_integer(sc, gdk_pixbuf_error_quark()));
}

static s7_pointer lg_gdk_pixbuf_get_colorspace(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_pixbuf_get_colorspace "GdkColorspace gdk_pixbuf_get_colorspace(GdkPixbuf* pixbuf)"
  s7_pointer pixbuf;
  pixbuf = s7_car(args);
  if (!s7_is_c_pointer_of_type(pixbuf, GdkPixbuf__sym)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_get_colorspace", 1, pixbuf, "GdkPixbuf*");
  return(s7_make_integer(sc, gdk_pixbuf_get_colorspace((GdkPixbuf*)s7_c_pointer(pixbuf))));
}

static s7_pointer lg_gdk_pixbuf_get_n_channels(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_pixbuf_get_n_channels "int gdk_pixbuf_get_n_channels(GdkPixbuf* pixbuf)"
  s7_pointer pixbuf;
  pixbuf = s7_car(args);
  if (!s7_is_c_pointer_of_type(pixbuf, GdkPixbuf__sym)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_get_n_channels", 1, pixbuf, "GdkPixbuf*");
  return(s7_make_integer(sc, gdk_pixbuf_get_n_channels((GdkPixbuf*)s7_c_pointer(pixbuf))));
}

static s7_pointer lg_gdk_pixbuf_get_has_alpha(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_pixbuf_get_has_alpha "gboolean gdk_pixbuf_get_has_alpha(GdkPixbuf* pixbuf)"
  s7_pointer pixbuf;
  pixbuf = s7_car(args);
  if (!s7_is_c_pointer_of_type(pixbuf, GdkPixbuf__sym)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_get_has_alpha", 1, pixbuf, "GdkPixbuf*");
  return(s7_make_boolean(sc, gdk_pixbuf_get_has_alpha((GdkPixbuf*)s7_c_pointer(pixbuf))));
}

static s7_pointer lg_gdk_pixbuf_get_bits_per_sample(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_pixbuf_get_bits_per_sample "int gdk_pixbuf_get_bits_per_sample(GdkPixbuf* pixbuf)"
  s7_pointer pixbuf;
  pixbuf = s7_car(args);
  if (!s7_is_c_pointer_of_type(pixbuf, GdkPixbuf__sym)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_get_bits_per_sample", 1, pixbuf, "GdkPixbuf*");
  return(s7_make_integer(sc, gdk_pixbuf_get_bits_per_sample((GdkPixbuf*)s7_c_pointer(pixbuf))));
}

static s7_pointer lg_gdk_pixbuf_get_pixels(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_pixbuf_get_pixels "guchar* gdk_pixbuf_get_pixels(GdkPixbuf* pixbuf)"
  s7_pointer pixbuf;
  pixbuf = s7_car(args);
  if (!s7_is_c_pointer_of_type(pixbuf, GdkPixbuf__sym)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_get_pixels", 1, pixbuf, "GdkPixbuf*");
  return(lg_make_c_pointer_with_type(sc, guchar__sym, gdk_pixbuf_get_pixels((GdkPixbuf*)s7_c_pointer(pixbuf))));
}

static s7_pointer lg_gdk_pixbuf_get_width(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_pixbuf_get_width "int gdk_pixbuf_get_width(GdkPixbuf* pixbuf)"
  s7_pointer pixbuf;
  pixbuf = s7_car(args);
  if (!s7_is_c_pointer_of_type(pixbuf, GdkPixbuf__sym)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_get_width", 1, pixbuf, "GdkPixbuf*");
  return(s7_make_integer(sc, gdk_pixbuf_get_width((GdkPixbuf*)s7_c_pointer(pixbuf))));
}

static s7_pointer lg_gdk_pixbuf_get_height(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_pixbuf_get_height "int gdk_pixbuf_get_height(GdkPixbuf* pixbuf)"
  s7_pointer pixbuf;
  pixbuf = s7_car(args);
  if (!s7_is_c_pointer_of_type(pixbuf, GdkPixbuf__sym)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_get_height", 1, pixbuf, "GdkPixbuf*");
  return(s7_make_integer(sc, gdk_pixbuf_get_height((GdkPixbuf*)s7_c_pointer(pixbuf))));
}

static s7_pointer lg_gdk_pixbuf_get_rowstride(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_pixbuf_get_rowstride "int gdk_pixbuf_get_rowstride(GdkPixbuf* pixbuf)"
  s7_pointer pixbuf;
  pixbuf = s7_car(args);
  if (!s7_is_c_pointer_of_type(pixbuf, GdkPixbuf__sym)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_get_rowstride", 1, pixbuf, "GdkPixbuf*");
  return(s7_make_integer(sc, gdk_pixbuf_get_rowstride((GdkPixbuf*)s7_c_pointer(pixbuf))));
}

static s7_pointer lg_gdk_pixbuf_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_pixbuf_new "GdkPixbuf* gdk_pixbuf_new(GdkColorspace colorspace, gboolean has_alpha, int bits_per_sample, \
int width, int height)"
  s7_pointer _p;
  s7_pointer colorspace, has_alpha, bits_per_sample, width, height;
  _p = args;
  colorspace = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(colorspace)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_new", 1, colorspace, "GdkColorspace");
  has_alpha = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_boolean(has_alpha)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_new", 2, has_alpha, "gboolean");
  bits_per_sample = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(bits_per_sample)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_new", 3, bits_per_sample, "int");
  width = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(width)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_new", 4, width, "int");
  height = s7_car(_p);
  if (!s7_is_integer(height)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_new", 5, height, "int");
  return(lg_make_c_pointer_with_type(sc, GdkPixbuf__sym, gdk_pixbuf_new((GdkColorspace)s7_integer(colorspace), (gboolean)lg_boolean(has_alpha), (int)s7_integer(bits_per_sample), (int)s7_integer(width), (int)s7_integer(height))));
}

static s7_pointer lg_gdk_pixbuf_copy(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_pixbuf_copy "GdkPixbuf* gdk_pixbuf_copy(GdkPixbuf* pixbuf)"
  s7_pointer pixbuf;
  pixbuf = s7_car(args);
  if (!s7_is_c_pointer_of_type(pixbuf, GdkPixbuf__sym)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_copy", 1, pixbuf, "GdkPixbuf*");
  return(lg_make_c_pointer_with_type(sc, GdkPixbuf__sym, gdk_pixbuf_copy((GdkPixbuf*)s7_c_pointer(pixbuf))));
}

static s7_pointer lg_gdk_pixbuf_new_subpixbuf(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_pixbuf_new_subpixbuf "GdkPixbuf* gdk_pixbuf_new_subpixbuf(GdkPixbuf* src_pixbuf, int src_x, \
int src_y, int width, int height)"
  s7_pointer _p;
  s7_pointer src_pixbuf, src_x, src_y, width, height;
  _p = args;
  src_pixbuf = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(src_pixbuf, GdkPixbuf__sym)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_new_subpixbuf", 1, src_pixbuf, "GdkPixbuf*");
  src_x = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(src_x)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_new_subpixbuf", 2, src_x, "int");
  src_y = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(src_y)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_new_subpixbuf", 3, src_y, "int");
  width = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(width)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_new_subpixbuf", 4, width, "int");
  height = s7_car(_p);
  if (!s7_is_integer(height)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_new_subpixbuf", 5, height, "int");
  return(lg_make_c_pointer_with_type(sc, GdkPixbuf__sym, gdk_pixbuf_new_subpixbuf((GdkPixbuf*)s7_c_pointer(src_pixbuf), (int)s7_integer(src_x), (int)s7_integer(src_y), (int)s7_integer(width), (int)s7_integer(height))));
}

static s7_pointer lg_gdk_pixbuf_new_from_file(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_pixbuf_new_from_file "GdkPixbuf* gdk_pixbuf_new_from_file(char* filename, GError** [error])"
  s7_pointer _p;
  s7_pointer filename;
  GError* ref_error = NULL;
  _p = args;
  filename = s7_car(_p);
  if (!s7_is_string(filename)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_new_from_file", 1, filename, "char*");
  {
    s7_pointer res_ult;
    res_ult = lg_make_c_pointer_with_type(sc, GdkPixbuf__sym, gdk_pixbuf_new_from_file((char*)s7_string(filename), &ref_error));
      return(s7_list(sc, 2, res_ult, s7_make_c_pointer(sc, ref_error)));
   }
}

static s7_pointer lg_gdk_pixbuf_new_from_data(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_pixbuf_new_from_data "GdkPixbuf* gdk_pixbuf_new_from_data(guchar* data, GdkColorspace colorspace, \
gboolean has_alpha, int bits_per_sample, int width, int height, int rowstride, GdkPixbufDestroyNotify destroy_fn, \
gpointer destroy_fn_data)"
  s7_pointer _p;
  s7_pointer data, colorspace, has_alpha, bits_per_sample, width, height, rowstride, destroy_fn, destroy_fn_data;
  _p = args;
  data = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(data, guchar__sym)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_new_from_data", 1, data, "guchar*");
  colorspace = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(colorspace)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_new_from_data", 2, colorspace, "GdkColorspace");
  has_alpha = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_boolean(has_alpha)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_new_from_data", 3, has_alpha, "gboolean");
  bits_per_sample = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(bits_per_sample)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_new_from_data", 4, bits_per_sample, "int");
  width = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(width)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_new_from_data", 5, width, "int");
  height = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(height)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_new_from_data", 6, height, "int");
  rowstride = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(rowstride)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_new_from_data", 7, rowstride, "int");
  destroy_fn = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(destroy_fn, GdkPixbufDestroyNotify_sym)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_new_from_data", 8, destroy_fn, "GdkPixbufDestroyNotify");
  destroy_fn_data = s7_car(_p);
  if (!s7_is_c_pointer_of_type(destroy_fn_data, gpointer_sym)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_new_from_data", 9, destroy_fn_data, "gpointer");
  return(lg_make_c_pointer_with_type(sc, GdkPixbuf__sym, gdk_pixbuf_new_from_data((guchar*)s7_c_pointer(data), (GdkColorspace)s7_integer(colorspace), (gboolean)lg_boolean(has_alpha), (int)s7_integer(bits_per_sample), (int)s7_integer(width), (int)s7_integer(height), (int)s7_integer(rowstride), (GdkPixbufDestroyNotify)s7_c_pointer(destroy_fn), (gpointer)s7_c_pointer(destroy_fn_data))));
}

static s7_pointer lg_gdk_pixbuf_new_from_xpm_data(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_pixbuf_new_from_xpm_data "GdkPixbuf* gdk_pixbuf_new_from_xpm_data(char** data)"
  s7_pointer data;
  data = s7_car(args);
  if (!s7_is_c_pointer_of_type(data, char___sym)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_new_from_xpm_data", 1, data, "char**");
  return(lg_make_c_pointer_with_type(sc, GdkPixbuf__sym, gdk_pixbuf_new_from_xpm_data((const char**)s7_c_pointer(data))));
}

static s7_pointer lg_gdk_pixbuf_fill(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_pixbuf_fill "void gdk_pixbuf_fill(GdkPixbuf* pixbuf, guint32 pixel)"
  s7_pointer _p;
  s7_pointer pixbuf, pixel;
  _p = args;
  pixbuf = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(pixbuf, GdkPixbuf__sym)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_fill", 1, pixbuf, "GdkPixbuf*");
  pixel = s7_car(_p);
  if (!s7_is_integer(pixel)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_fill", 2, pixel, "guint32");
  gdk_pixbuf_fill((GdkPixbuf*)s7_c_pointer(pixbuf), (guint32)s7_integer(pixel));
  return(lg_false);
}

static s7_pointer lg_gdk_pixbuf_savev(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_pixbuf_savev "gboolean gdk_pixbuf_savev(GdkPixbuf* pixbuf, char* filename, char* type, \
char** option_keys, char** option_values, GError** [error])"
  s7_pointer _p;
  s7_pointer pixbuf, filename, type, option_keys, option_values;
  GError* ref_error = NULL;
  _p = args;
  pixbuf = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(pixbuf, GdkPixbuf__sym)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_savev", 1, pixbuf, "GdkPixbuf*");
  filename = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(filename)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_savev", 2, filename, "char*");
  type = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(type)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_savev", 3, type, "char*");
  option_keys = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(option_keys, char___sym)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_savev", 4, option_keys, "char**");
  option_values = s7_car(_p);
  if (!s7_is_c_pointer_of_type(option_values, char___sym)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_savev", 5, option_values, "char**");
  {
    s7_pointer res_ult;
    res_ult = s7_make_boolean(sc, gdk_pixbuf_savev((GdkPixbuf*)s7_c_pointer(pixbuf), (char*)s7_string(filename), (char*)s7_string(type), (char**)s7_c_pointer(option_keys), (char**)s7_c_pointer(option_values), &ref_error));
      return(s7_list(sc, 2, res_ult, s7_make_c_pointer(sc, ref_error)));
   }
}

static s7_pointer lg_gdk_pixbuf_add_alpha(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_pixbuf_add_alpha "GdkPixbuf* gdk_pixbuf_add_alpha(GdkPixbuf* pixbuf, gboolean substitute_color, \
guchar r, guchar g, guchar b)"
  s7_pointer _p;
  s7_pointer pixbuf, substitute_color, r, g, b;
  _p = args;
  pixbuf = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(pixbuf, GdkPixbuf__sym)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_add_alpha", 1, pixbuf, "GdkPixbuf*");
  substitute_color = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_boolean(substitute_color)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_add_alpha", 2, substitute_color, "gboolean");
  r = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(r)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_add_alpha", 3, r, "guchar");
  g = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(g)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_add_alpha", 4, g, "guchar");
  b = s7_car(_p);
  if (!s7_is_integer(b)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_add_alpha", 5, b, "guchar");
  return(lg_make_c_pointer_with_type(sc, GdkPixbuf__sym, gdk_pixbuf_add_alpha((GdkPixbuf*)s7_c_pointer(pixbuf), (gboolean)lg_boolean(substitute_color), (guchar)s7_integer(r), (guchar)s7_integer(g), (guchar)s7_integer(b))));
}

static s7_pointer lg_gdk_pixbuf_copy_area(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_pixbuf_copy_area "void gdk_pixbuf_copy_area(GdkPixbuf* src_pixbuf, int src_x, int src_y, \
int width, int height, GdkPixbuf* dest_pixbuf, int dest_x, int dest_y)"
  s7_pointer _p;
  s7_pointer src_pixbuf, src_x, src_y, width, height, dest_pixbuf, dest_x, dest_y;
  _p = args;
  src_pixbuf = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(src_pixbuf, GdkPixbuf__sym)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_copy_area", 1, src_pixbuf, "GdkPixbuf*");
  src_x = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(src_x)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_copy_area", 2, src_x, "int");
  src_y = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(src_y)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_copy_area", 3, src_y, "int");
  width = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(width)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_copy_area", 4, width, "int");
  height = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(height)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_copy_area", 5, height, "int");
  dest_pixbuf = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(dest_pixbuf, GdkPixbuf__sym)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_copy_area", 6, dest_pixbuf, "GdkPixbuf*");
  dest_x = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(dest_x)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_copy_area", 7, dest_x, "int");
  dest_y = s7_car(_p);
  if (!s7_is_integer(dest_y)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_copy_area", 8, dest_y, "int");
  gdk_pixbuf_copy_area((GdkPixbuf*)s7_c_pointer(src_pixbuf), (int)s7_integer(src_x), (int)s7_integer(src_y), (int)s7_integer(width), (int)s7_integer(height), (GdkPixbuf*)s7_c_pointer(dest_pixbuf), (int)s7_integer(dest_x), (int)s7_integer(dest_y));
  return(lg_false);
}

static s7_pointer lg_gdk_pixbuf_saturate_and_pixelate(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_pixbuf_saturate_and_pixelate "void gdk_pixbuf_saturate_and_pixelate(GdkPixbuf* src, GdkPixbuf* dest, \
gfloat saturation, gboolean pixelate)"
  s7_pointer _p;
  s7_pointer src, dest, saturation, pixelate;
  _p = args;
  src = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(src, GdkPixbuf__sym)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_saturate_and_pixelate", 1, src, "GdkPixbuf*");
  dest = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(dest, GdkPixbuf__sym)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_saturate_and_pixelate", 2, dest, "GdkPixbuf*");
  saturation = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(saturation)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_saturate_and_pixelate", 3, saturation, "gfloat");
  pixelate = s7_car(_p);
  if (!s7_is_boolean(pixelate)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_saturate_and_pixelate", 4, pixelate, "gboolean");
  gdk_pixbuf_saturate_and_pixelate((GdkPixbuf*)s7_c_pointer(src), (GdkPixbuf*)s7_c_pointer(dest), (gfloat)s7_real(saturation), (gboolean)lg_boolean(pixelate));
  return(lg_false);
}

static s7_pointer lg_gdk_pixbuf_scale(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_pixbuf_scale "void gdk_pixbuf_scale(GdkPixbuf* src, GdkPixbuf* dest, int dest_x, int dest_y, \
int dest_width, int dest_height, double offset_x, double offset_y, double scale_x, double scale_y, GdkInterpType interp_type)"
  s7_pointer _p;
  s7_pointer src, dest, dest_x, dest_y, dest_width, dest_height, offset_x, offset_y, scale_x, scale_y, interp_type;
  _p = args;
  src = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(src, GdkPixbuf__sym)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_scale", 1, src, "GdkPixbuf*");
  dest = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(dest, GdkPixbuf__sym)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_scale", 2, dest, "GdkPixbuf*");
  dest_x = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(dest_x)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_scale", 3, dest_x, "int");
  dest_y = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(dest_y)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_scale", 4, dest_y, "int");
  dest_width = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(dest_width)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_scale", 5, dest_width, "int");
  dest_height = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(dest_height)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_scale", 6, dest_height, "int");
  offset_x = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(offset_x)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_scale", 7, offset_x, "double");
  offset_y = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(offset_y)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_scale", 8, offset_y, "double");
  scale_x = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(scale_x)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_scale", 9, scale_x, "double");
  scale_y = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(scale_y)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_scale", 10, scale_y, "double");
  interp_type = s7_car(_p);
  if (!s7_is_integer(interp_type)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_scale", 11, interp_type, "GdkInterpType");
  gdk_pixbuf_scale((GdkPixbuf*)s7_c_pointer(src), (GdkPixbuf*)s7_c_pointer(dest), (int)s7_integer(dest_x), (int)s7_integer(dest_y), (int)s7_integer(dest_width), (int)s7_integer(dest_height), (double)s7_real(offset_x), (double)s7_real(offset_y), (double)s7_real(scale_x), (double)s7_real(scale_y), (GdkInterpType)s7_integer(interp_type));
  return(lg_false);
}

static s7_pointer lg_gdk_pixbuf_composite(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_pixbuf_composite "void gdk_pixbuf_composite(GdkPixbuf* src, GdkPixbuf* dest, int dest_x, \
int dest_y, int dest_width, int dest_height, double offset_x, double offset_y, double scale_x, double scale_y, \
GdkInterpType interp_type, int overall_alpha)"
  s7_pointer _p;
  s7_pointer src, dest, dest_x, dest_y, dest_width, dest_height, offset_x, offset_y, scale_x, scale_y, interp_type, overall_alpha;
  _p = args;
  src = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(src, GdkPixbuf__sym)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_composite", 1, src, "GdkPixbuf*");
  dest = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(dest, GdkPixbuf__sym)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_composite", 2, dest, "GdkPixbuf*");
  dest_x = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(dest_x)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_composite", 3, dest_x, "int");
  dest_y = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(dest_y)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_composite", 4, dest_y, "int");
  dest_width = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(dest_width)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_composite", 5, dest_width, "int");
  dest_height = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(dest_height)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_composite", 6, dest_height, "int");
  offset_x = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(offset_x)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_composite", 7, offset_x, "double");
  offset_y = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(offset_y)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_composite", 8, offset_y, "double");
  scale_x = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(scale_x)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_composite", 9, scale_x, "double");
  scale_y = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(scale_y)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_composite", 10, scale_y, "double");
  interp_type = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(interp_type)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_composite", 11, interp_type, "GdkInterpType");
  overall_alpha = s7_car(_p);
  if (!s7_is_integer(overall_alpha)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_composite", 12, overall_alpha, "int");
  gdk_pixbuf_composite((GdkPixbuf*)s7_c_pointer(src), (GdkPixbuf*)s7_c_pointer(dest), (int)s7_integer(dest_x), (int)s7_integer(dest_y), (int)s7_integer(dest_width), (int)s7_integer(dest_height), (double)s7_real(offset_x), (double)s7_real(offset_y), (double)s7_real(scale_x), (double)s7_real(scale_y), (GdkInterpType)s7_integer(interp_type), (int)s7_integer(overall_alpha));
  return(lg_false);
}

static s7_pointer lg_gdk_pixbuf_composite_color(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_pixbuf_composite_color "void gdk_pixbuf_composite_color(GdkPixbuf* src, GdkPixbuf* dest, \
int dest_x, int dest_y, int dest_width, int dest_height, double offset_x, double offset_y, double scale_x, \
double scale_y, GdkInterpType interp_type, int overall_alpha, int check_x, int check_y, int check_size, \
guint32 color1, guint32 color2)"
  s7_pointer _p;
  s7_pointer src, dest, dest_x, dest_y, dest_width, dest_height, offset_x, offset_y, scale_x, scale_y, interp_type, overall_alpha, check_x, check_y, check_size, color1, color2;
  _p = args;
  src = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(src, GdkPixbuf__sym)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_composite_color", 1, src, "GdkPixbuf*");
  dest = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(dest, GdkPixbuf__sym)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_composite_color", 2, dest, "GdkPixbuf*");
  dest_x = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(dest_x)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_composite_color", 3, dest_x, "int");
  dest_y = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(dest_y)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_composite_color", 4, dest_y, "int");
  dest_width = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(dest_width)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_composite_color", 5, dest_width, "int");
  dest_height = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(dest_height)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_composite_color", 6, dest_height, "int");
  offset_x = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(offset_x)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_composite_color", 7, offset_x, "double");
  offset_y = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(offset_y)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_composite_color", 8, offset_y, "double");
  scale_x = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(scale_x)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_composite_color", 9, scale_x, "double");
  scale_y = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(scale_y)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_composite_color", 10, scale_y, "double");
  interp_type = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(interp_type)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_composite_color", 11, interp_type, "GdkInterpType");
  overall_alpha = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(overall_alpha)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_composite_color", 12, overall_alpha, "int");
  check_x = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(check_x)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_composite_color", 13, check_x, "int");
  check_y = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(check_y)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_composite_color", 14, check_y, "int");
  check_size = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(check_size)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_composite_color", 15, check_size, "int");
  color1 = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(color1)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_composite_color", 16, color1, "guint32");
  color2 = s7_car(_p);
  if (!s7_is_integer(color2)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_composite_color", 17, color2, "guint32");
  gdk_pixbuf_composite_color((GdkPixbuf*)s7_c_pointer(src), (GdkPixbuf*)s7_c_pointer(dest), (int)s7_integer(dest_x), (int)s7_integer(dest_y), (int)s7_integer(dest_width), (int)s7_integer(dest_height), (double)s7_real(offset_x), (double)s7_real(offset_y), (double)s7_real(scale_x), (double)s7_real(scale_y), (GdkInterpType)s7_integer(interp_type), (int)s7_integer(overall_alpha), (int)s7_integer(check_x), (int)s7_integer(check_y), (int)s7_integer(check_size), (guint32)s7_integer(color1), (guint32)s7_integer(color2));
  return(lg_false);
}

static s7_pointer lg_gdk_pixbuf_scale_simple(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_pixbuf_scale_simple "GdkPixbuf* gdk_pixbuf_scale_simple(GdkPixbuf* src, int dest_width, \
int dest_height, GdkInterpType interp_type)"
  s7_pointer _p;
  s7_pointer src, dest_width, dest_height, interp_type;
  _p = args;
  src = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(src, GdkPixbuf__sym)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_scale_simple", 1, src, "GdkPixbuf*");
  dest_width = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(dest_width)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_scale_simple", 2, dest_width, "int");
  dest_height = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(dest_height)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_scale_simple", 3, dest_height, "int");
  interp_type = s7_car(_p);
  if (!s7_is_integer(interp_type)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_scale_simple", 4, interp_type, "GdkInterpType");
  return(lg_make_c_pointer_with_type(sc, GdkPixbuf__sym, gdk_pixbuf_scale_simple((GdkPixbuf*)s7_c_pointer(src), (int)s7_integer(dest_width), (int)s7_integer(dest_height), (GdkInterpType)s7_integer(interp_type))));
}

static s7_pointer lg_gdk_pixbuf_composite_color_simple(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_pixbuf_composite_color_simple "GdkPixbuf* gdk_pixbuf_composite_color_simple(GdkPixbuf* src, \
int dest_width, int dest_height, GdkInterpType interp_type, int overall_alpha, int check_size, guint32 color1, \
guint32 color2)"
  s7_pointer _p;
  s7_pointer src, dest_width, dest_height, interp_type, overall_alpha, check_size, color1, color2;
  _p = args;
  src = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(src, GdkPixbuf__sym)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_composite_color_simple", 1, src, "GdkPixbuf*");
  dest_width = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(dest_width)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_composite_color_simple", 2, dest_width, "int");
  dest_height = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(dest_height)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_composite_color_simple", 3, dest_height, "int");
  interp_type = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(interp_type)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_composite_color_simple", 4, interp_type, "GdkInterpType");
  overall_alpha = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(overall_alpha)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_composite_color_simple", 5, overall_alpha, "int");
  check_size = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(check_size)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_composite_color_simple", 6, check_size, "int");
  color1 = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(color1)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_composite_color_simple", 7, color1, "guint32");
  color2 = s7_car(_p);
  if (!s7_is_integer(color2)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_composite_color_simple", 8, color2, "guint32");
  return(lg_make_c_pointer_with_type(sc, GdkPixbuf__sym, gdk_pixbuf_composite_color_simple((GdkPixbuf*)s7_c_pointer(src), (int)s7_integer(dest_width), (int)s7_integer(dest_height), (GdkInterpType)s7_integer(interp_type), (int)s7_integer(overall_alpha), (int)s7_integer(check_size), (guint32)s7_integer(color1), (guint32)s7_integer(color2))));
}

static s7_pointer lg_gdk_pixbuf_get_option(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_pixbuf_get_option "gchar* gdk_pixbuf_get_option(GdkPixbuf* pixbuf, gchar* key)"
  s7_pointer _p;
  s7_pointer pixbuf, key;
  _p = args;
  pixbuf = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(pixbuf, GdkPixbuf__sym)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_get_option", 1, pixbuf, "GdkPixbuf*");
  key = s7_car(_p);
  if (!s7_is_string(key)) s7_wrong_type_arg_error(sc, "gdk_pixbuf_get_option", 2, key, "gchar*");
  return(s7_make_string(sc, gdk_pixbuf_get_option((GdkPixbuf*)s7_c_pointer(pixbuf), (gchar*)s7_string(key))));
}

static s7_pointer lg_gtk_accel_label_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_accel_label_new "GtkWidget* gtk_accel_label_new(gchar* string)"
  s7_pointer string;
  string = s7_car(args);
  if (!s7_is_string(string)) s7_wrong_type_arg_error(sc, "gtk_accel_label_new", 1, string, "gchar*");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_accel_label_new((gchar*)s7_string(string))));
}

static s7_pointer lg_gtk_accel_label_get_accel_width(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_accel_label_get_accel_width "guint gtk_accel_label_get_accel_width(GtkAccelLabel* accel_label)"
  s7_pointer accel_label;
  accel_label = s7_car(args);
  if (!s7_is_c_pointer_of_type(accel_label, GtkAccelLabel__sym)) s7_wrong_type_arg_error(sc, "gtk_accel_label_get_accel_width", 1, accel_label, "GtkAccelLabel*");
  return(s7_make_integer(sc, gtk_accel_label_get_accel_width((GtkAccelLabel*)s7_c_pointer(accel_label))));
}

static s7_pointer lg_gtk_accel_label_refetch(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_accel_label_refetch "gboolean gtk_accel_label_refetch(GtkAccelLabel* accel_label)"
  s7_pointer accel_label;
  accel_label = s7_car(args);
  if (!s7_is_c_pointer_of_type(accel_label, GtkAccelLabel__sym)) s7_wrong_type_arg_error(sc, "gtk_accel_label_refetch", 1, accel_label, "GtkAccelLabel*");
  return(s7_make_boolean(sc, gtk_accel_label_refetch((GtkAccelLabel*)s7_c_pointer(accel_label))));
}

static s7_pointer lg_gtk_adjustment_clamp_page(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_adjustment_clamp_page "void gtk_adjustment_clamp_page(GtkAdjustment* adjustment, gdouble lower, \
gdouble upper)"
  s7_pointer _p;
  s7_pointer adjustment, lower, upper;
  _p = args;
  adjustment = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(adjustment, GtkAdjustment__sym)) s7_wrong_type_arg_error(sc, "gtk_adjustment_clamp_page", 1, adjustment, "GtkAdjustment*");
  lower = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(lower)) s7_wrong_type_arg_error(sc, "gtk_adjustment_clamp_page", 2, lower, "gdouble");
  upper = s7_car(_p);
  if (!s7_is_real(upper)) s7_wrong_type_arg_error(sc, "gtk_adjustment_clamp_page", 3, upper, "gdouble");
  gtk_adjustment_clamp_page((GtkAdjustment*)s7_c_pointer(adjustment), (gdouble)s7_real(lower), (gdouble)s7_real(upper));
  return(lg_false);
}

static s7_pointer lg_gtk_adjustment_get_value(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_adjustment_get_value "gdouble gtk_adjustment_get_value(GtkAdjustment* adjustment)"
  s7_pointer adjustment;
  adjustment = s7_car(args);
  if (!s7_is_c_pointer_of_type(adjustment, GtkAdjustment__sym)) s7_wrong_type_arg_error(sc, "gtk_adjustment_get_value", 1, adjustment, "GtkAdjustment*");
  return(s7_make_real(sc, gtk_adjustment_get_value((GtkAdjustment*)s7_c_pointer(adjustment))));
}

static s7_pointer lg_gtk_adjustment_set_value(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_adjustment_set_value "void gtk_adjustment_set_value(GtkAdjustment* adjustment, gdouble value)"
  s7_pointer _p;
  s7_pointer adjustment, value;
  _p = args;
  adjustment = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(adjustment, GtkAdjustment__sym)) s7_wrong_type_arg_error(sc, "gtk_adjustment_set_value", 1, adjustment, "GtkAdjustment*");
  value = s7_car(_p);
  if (!s7_is_real(value)) s7_wrong_type_arg_error(sc, "gtk_adjustment_set_value", 2, value, "gdouble");
  gtk_adjustment_set_value((GtkAdjustment*)s7_c_pointer(adjustment), (gdouble)s7_real(value));
  return(lg_false);
}

static s7_pointer lg_gtk_box_set_homogeneous(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_box_set_homogeneous "void gtk_box_set_homogeneous(GtkBox* box, gboolean homogeneous)"
  s7_pointer _p;
  s7_pointer box, homogeneous;
  _p = args;
  box = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(box, GtkBox__sym)) s7_wrong_type_arg_error(sc, "gtk_box_set_homogeneous", 1, box, "GtkBox*");
  homogeneous = s7_car(_p);
  if (!s7_is_boolean(homogeneous)) s7_wrong_type_arg_error(sc, "gtk_box_set_homogeneous", 2, homogeneous, "gboolean");
  gtk_box_set_homogeneous((GtkBox*)s7_c_pointer(box), (gboolean)lg_boolean(homogeneous));
  return(lg_false);
}

static s7_pointer lg_gtk_box_get_homogeneous(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_box_get_homogeneous "gboolean gtk_box_get_homogeneous(GtkBox* box)"
  s7_pointer box;
  box = s7_car(args);
  if (!s7_is_c_pointer_of_type(box, GtkBox__sym)) s7_wrong_type_arg_error(sc, "gtk_box_get_homogeneous", 1, box, "GtkBox*");
  return(s7_make_boolean(sc, gtk_box_get_homogeneous((GtkBox*)s7_c_pointer(box))));
}

static s7_pointer lg_gtk_box_set_spacing(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_box_set_spacing "void gtk_box_set_spacing(GtkBox* box, gint spacing)"
  s7_pointer _p;
  s7_pointer box, spacing;
  _p = args;
  box = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(box, GtkBox__sym)) s7_wrong_type_arg_error(sc, "gtk_box_set_spacing", 1, box, "GtkBox*");
  spacing = s7_car(_p);
  if (!s7_is_integer(spacing)) s7_wrong_type_arg_error(sc, "gtk_box_set_spacing", 2, spacing, "gint");
  gtk_box_set_spacing((GtkBox*)s7_c_pointer(box), (gint)s7_integer(spacing));
  return(lg_false);
}

static s7_pointer lg_gtk_box_get_spacing(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_box_get_spacing "gint gtk_box_get_spacing(GtkBox* box)"
  s7_pointer box;
  box = s7_car(args);
  if (!s7_is_c_pointer_of_type(box, GtkBox__sym)) s7_wrong_type_arg_error(sc, "gtk_box_get_spacing", 1, box, "GtkBox*");
  return(s7_make_integer(sc, gtk_box_get_spacing((GtkBox*)s7_c_pointer(box))));
}

static s7_pointer lg_gtk_button_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_button_new "GtkWidget* gtk_button_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_button_new()));
}

static s7_pointer lg_gtk_button_new_with_label(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_button_new_with_label "GtkWidget* gtk_button_new_with_label(gchar* label)"
  s7_pointer label;
  label = s7_car(args);
  if (!s7_is_string(label)) s7_wrong_type_arg_error(sc, "gtk_button_new_with_label", 1, label, "gchar*");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_button_new_with_label((gchar*)s7_string(label))));
}

static s7_pointer lg_gtk_button_new_with_mnemonic(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_button_new_with_mnemonic "GtkWidget* gtk_button_new_with_mnemonic(gchar* label)"
  s7_pointer label;
  label = s7_car(args);
  if (!s7_is_string(label)) s7_wrong_type_arg_error(sc, "gtk_button_new_with_mnemonic", 1, label, "gchar*");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_button_new_with_mnemonic((gchar*)s7_string(label))));
}

static s7_pointer lg_gtk_button_set_label(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_button_set_label "void gtk_button_set_label(GtkButton* button, gchar* label)"
  s7_pointer _p;
  s7_pointer button, label;
  _p = args;
  button = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(button, GtkButton__sym)) s7_wrong_type_arg_error(sc, "gtk_button_set_label", 1, button, "GtkButton*");
  label = s7_car(_p);
  if (!s7_is_string(label)) s7_wrong_type_arg_error(sc, "gtk_button_set_label", 2, label, "gchar*");
  gtk_button_set_label((GtkButton*)s7_c_pointer(button), (gchar*)s7_string(label));
  return(lg_false);
}

static s7_pointer lg_gtk_button_get_label(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_button_get_label "gchar* gtk_button_get_label(GtkButton* button)"
  s7_pointer button;
  button = s7_car(args);
  if (!s7_is_c_pointer_of_type(button, GtkButton__sym)) s7_wrong_type_arg_error(sc, "gtk_button_get_label", 1, button, "GtkButton*");
  return(s7_make_string(sc, gtk_button_get_label((GtkButton*)s7_c_pointer(button))));
}

static s7_pointer lg_gtk_button_set_use_underline(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_button_set_use_underline "void gtk_button_set_use_underline(GtkButton* button, gboolean use_underline)"
  s7_pointer _p;
  s7_pointer button, use_underline;
  _p = args;
  button = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(button, GtkButton__sym)) s7_wrong_type_arg_error(sc, "gtk_button_set_use_underline", 1, button, "GtkButton*");
  use_underline = s7_car(_p);
  if (!s7_is_boolean(use_underline)) s7_wrong_type_arg_error(sc, "gtk_button_set_use_underline", 2, use_underline, "gboolean");
  gtk_button_set_use_underline((GtkButton*)s7_c_pointer(button), (gboolean)lg_boolean(use_underline));
  return(lg_false);
}

static s7_pointer lg_gtk_button_get_use_underline(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_button_get_use_underline "gboolean gtk_button_get_use_underline(GtkButton* button)"
  s7_pointer button;
  button = s7_car(args);
  if (!s7_is_c_pointer_of_type(button, GtkButton__sym)) s7_wrong_type_arg_error(sc, "gtk_button_get_use_underline", 1, button, "GtkButton*");
  return(s7_make_boolean(sc, gtk_button_get_use_underline((GtkButton*)s7_c_pointer(button))));
}

static s7_pointer lg_gtk_calendar_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_calendar_new "GtkWidget* gtk_calendar_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_calendar_new()));
}

static s7_pointer lg_gtk_calendar_clear_marks(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_calendar_clear_marks "void gtk_calendar_clear_marks(GtkCalendar* calendar)"
  s7_pointer calendar;
  calendar = s7_car(args);
  if (!s7_is_c_pointer_of_type(calendar, GtkCalendar__sym)) s7_wrong_type_arg_error(sc, "gtk_calendar_clear_marks", 1, calendar, "GtkCalendar*");
  gtk_calendar_clear_marks((GtkCalendar*)s7_c_pointer(calendar));
  return(lg_false);
}

static s7_pointer lg_gtk_cell_editable_start_editing(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_editable_start_editing "void gtk_cell_editable_start_editing(GtkCellEditable* cell_editable, \
GdkEvent* event)"
  s7_pointer _p;
  s7_pointer cell_editable, event;
  _p = args;
  cell_editable = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(cell_editable, GtkCellEditable__sym)) s7_wrong_type_arg_error(sc, "gtk_cell_editable_start_editing", 1, cell_editable, "GtkCellEditable*");
  event = s7_car(_p);
  if ((!s7_is_c_pointer_of_type(event, GdkEvent__sym)) && (event != lg_false)) s7_wrong_type_arg_error(sc, "gtk_cell_editable_start_editing", 2, event, "GdkEvent*");
  gtk_cell_editable_start_editing((GtkCellEditable*)s7_c_pointer(cell_editable), (GdkEvent*)s7_c_pointer(event));
  return(lg_false);
}

static s7_pointer lg_gtk_cell_editable_editing_done(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_editable_editing_done "void gtk_cell_editable_editing_done(GtkCellEditable* cell_editable)"
  s7_pointer cell_editable;
  cell_editable = s7_car(args);
  if (!s7_is_c_pointer_of_type(cell_editable, GtkCellEditable__sym)) s7_wrong_type_arg_error(sc, "gtk_cell_editable_editing_done", 1, cell_editable, "GtkCellEditable*");
  gtk_cell_editable_editing_done((GtkCellEditable*)s7_c_pointer(cell_editable));
  return(lg_false);
}

static s7_pointer lg_gtk_cell_editable_remove_widget(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_editable_remove_widget "void gtk_cell_editable_remove_widget(GtkCellEditable* cell_editable)"
  s7_pointer cell_editable;
  cell_editable = s7_car(args);
  if (!s7_is_c_pointer_of_type(cell_editable, GtkCellEditable__sym)) s7_wrong_type_arg_error(sc, "gtk_cell_editable_remove_widget", 1, cell_editable, "GtkCellEditable*");
  gtk_cell_editable_remove_widget((GtkCellEditable*)s7_c_pointer(cell_editable));
  return(lg_false);
}

static s7_pointer lg_gtk_cell_renderer_activate(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_renderer_activate "gboolean gtk_cell_renderer_activate(GtkCellRenderer* cell, GdkEvent* event, \
GtkWidget* widget, gchar* path, GdkRectangle* background_area, GdkRectangle* cell_area, GtkCellRendererState flags)"
  s7_pointer _p;
  s7_pointer cell, event, widget, path, background_area, cell_area, flags;
  _p = args;
  cell = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(cell, GtkCellRenderer__sym)) s7_wrong_type_arg_error(sc, "gtk_cell_renderer_activate", 1, cell, "GtkCellRenderer*");
  event = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(event, GdkEvent__sym)) s7_wrong_type_arg_error(sc, "gtk_cell_renderer_activate", 2, event, "GdkEvent*");
  widget = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(widget, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_cell_renderer_activate", 3, widget, "GtkWidget*");
  path = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(path)) s7_wrong_type_arg_error(sc, "gtk_cell_renderer_activate", 4, path, "gchar*");
  background_area = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(background_area, GdkRectangle__sym)) s7_wrong_type_arg_error(sc, "gtk_cell_renderer_activate", 5, background_area, "GdkRectangle*");
  cell_area = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(cell_area, GdkRectangle__sym)) s7_wrong_type_arg_error(sc, "gtk_cell_renderer_activate", 6, cell_area, "GdkRectangle*");
  flags = s7_car(_p);
  if (!s7_is_integer(flags)) s7_wrong_type_arg_error(sc, "gtk_cell_renderer_activate", 7, flags, "GtkCellRendererState");
  return(s7_make_boolean(sc, gtk_cell_renderer_activate((GtkCellRenderer*)s7_c_pointer(cell), (GdkEvent*)s7_c_pointer(event), (GtkWidget*)s7_c_pointer(widget), (gchar*)s7_string(path), (GdkRectangle*)s7_c_pointer(background_area), (GdkRectangle*)s7_c_pointer(cell_area), (GtkCellRendererState)s7_integer(flags))));
}

static s7_pointer lg_gtk_cell_renderer_start_editing(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_renderer_start_editing "GtkCellEditable* gtk_cell_renderer_start_editing(GtkCellRenderer* cell, \
GdkEvent* event, GtkWidget* widget, gchar* path, GdkRectangle* background_area, GdkRectangle* cell_area, \
GtkCellRendererState flags)"
  s7_pointer _p;
  s7_pointer cell, event, widget, path, background_area, cell_area, flags;
  _p = args;
  cell = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(cell, GtkCellRenderer__sym)) s7_wrong_type_arg_error(sc, "gtk_cell_renderer_start_editing", 1, cell, "GtkCellRenderer*");
  event = s7_car(_p); _p = s7_cdr(_p);
  if ((!s7_is_c_pointer_of_type(event, GdkEvent__sym)) && (event != lg_false)) s7_wrong_type_arg_error(sc, "gtk_cell_renderer_start_editing", 2, event, "GdkEvent*");
  widget = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(widget, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_cell_renderer_start_editing", 3, widget, "GtkWidget*");
  path = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(path)) s7_wrong_type_arg_error(sc, "gtk_cell_renderer_start_editing", 4, path, "gchar*");
  background_area = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(background_area, GdkRectangle__sym)) s7_wrong_type_arg_error(sc, "gtk_cell_renderer_start_editing", 5, background_area, "GdkRectangle*");
  cell_area = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(cell_area, GdkRectangle__sym)) s7_wrong_type_arg_error(sc, "gtk_cell_renderer_start_editing", 6, cell_area, "GdkRectangle*");
  flags = s7_car(_p);
  if (!s7_is_integer(flags)) s7_wrong_type_arg_error(sc, "gtk_cell_renderer_start_editing", 7, flags, "GtkCellRendererState");
  return(lg_make_c_pointer_with_type(sc, GtkCellEditable__sym, gtk_cell_renderer_start_editing((GtkCellRenderer*)s7_c_pointer(cell), (GdkEvent*)s7_c_pointer(event), (GtkWidget*)s7_c_pointer(widget), (gchar*)s7_string(path), (GdkRectangle*)s7_c_pointer(background_area), (GdkRectangle*)s7_c_pointer(cell_area), (GtkCellRendererState)s7_integer(flags))));
}

static s7_pointer lg_gtk_cell_renderer_set_fixed_size(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_renderer_set_fixed_size "void gtk_cell_renderer_set_fixed_size(GtkCellRenderer* cell, \
gint width, gint height)"
  s7_pointer _p;
  s7_pointer cell, width, height;
  _p = args;
  cell = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(cell, GtkCellRenderer__sym)) s7_wrong_type_arg_error(sc, "gtk_cell_renderer_set_fixed_size", 1, cell, "GtkCellRenderer*");
  width = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(width)) s7_wrong_type_arg_error(sc, "gtk_cell_renderer_set_fixed_size", 2, width, "gint");
  height = s7_car(_p);
  if (!s7_is_integer(height)) s7_wrong_type_arg_error(sc, "gtk_cell_renderer_set_fixed_size", 3, height, "gint");
  gtk_cell_renderer_set_fixed_size((GtkCellRenderer*)s7_c_pointer(cell), (gint)s7_integer(width), (gint)s7_integer(height));
  return(lg_false);
}

static s7_pointer lg_gtk_cell_renderer_get_fixed_size(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_renderer_get_fixed_size "void gtk_cell_renderer_get_fixed_size(GtkCellRenderer* cell, \
gint* [width], gint* [height])"
  s7_pointer _p;
  s7_pointer cell;
  gint ref_width;
  gint ref_height;
  _p = args;
  cell = s7_car(_p);
  if (!s7_is_c_pointer_of_type(cell, GtkCellRenderer__sym)) s7_wrong_type_arg_error(sc, "gtk_cell_renderer_get_fixed_size", 1, cell, "GtkCellRenderer*");
  gtk_cell_renderer_get_fixed_size((GtkCellRenderer*)s7_c_pointer(cell), &ref_width, &ref_height);
    return(s7_list(sc, 2, s7_make_integer(sc, ref_width), s7_make_integer(sc, ref_height)));
}

static s7_pointer lg_gtk_cell_renderer_pixbuf_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_renderer_pixbuf_new "GtkCellRenderer* gtk_cell_renderer_pixbuf_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkCellRenderer__sym, gtk_cell_renderer_pixbuf_new()));
}

static s7_pointer lg_gtk_cell_renderer_text_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_renderer_text_new "GtkCellRenderer* gtk_cell_renderer_text_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkCellRenderer__sym, gtk_cell_renderer_text_new()));
}

static s7_pointer lg_gtk_cell_renderer_text_set_fixed_height_from_font(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_renderer_text_set_fixed_height_from_font "void gtk_cell_renderer_text_set_fixed_height_from_font(GtkCellRendererText* renderer, \
gint number_of_rows)"
  s7_pointer _p;
  s7_pointer renderer, number_of_rows;
  _p = args;
  renderer = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(renderer, GtkCellRendererText__sym)) s7_wrong_type_arg_error(sc, "gtk_cell_renderer_text_set_fixed_height_from_font", 1, renderer, "GtkCellRendererText*");
  number_of_rows = s7_car(_p);
  if (!s7_is_integer(number_of_rows)) s7_wrong_type_arg_error(sc, "gtk_cell_renderer_text_set_fixed_height_from_font", 2, number_of_rows, "gint");
  gtk_cell_renderer_text_set_fixed_height_from_font((GtkCellRendererText*)s7_c_pointer(renderer), (gint)s7_integer(number_of_rows));
  return(lg_false);
}

static s7_pointer lg_gtk_cell_renderer_toggle_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_renderer_toggle_new "GtkCellRenderer* gtk_cell_renderer_toggle_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkCellRenderer__sym, gtk_cell_renderer_toggle_new()));
}

static s7_pointer lg_gtk_cell_renderer_toggle_get_radio(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_renderer_toggle_get_radio "gboolean gtk_cell_renderer_toggle_get_radio(GtkCellRendererToggle* toggle)"
  s7_pointer toggle;
  toggle = s7_car(args);
  if (!s7_is_c_pointer_of_type(toggle, GtkCellRendererToggle__sym)) s7_wrong_type_arg_error(sc, "gtk_cell_renderer_toggle_get_radio", 1, toggle, "GtkCellRendererToggle*");
  return(s7_make_boolean(sc, gtk_cell_renderer_toggle_get_radio((GtkCellRendererToggle*)s7_c_pointer(toggle))));
}

static s7_pointer lg_gtk_cell_renderer_toggle_set_radio(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_renderer_toggle_set_radio "void gtk_cell_renderer_toggle_set_radio(GtkCellRendererToggle* toggle, \
gboolean radio)"
  s7_pointer _p;
  s7_pointer toggle, radio;
  _p = args;
  toggle = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(toggle, GtkCellRendererToggle__sym)) s7_wrong_type_arg_error(sc, "gtk_cell_renderer_toggle_set_radio", 1, toggle, "GtkCellRendererToggle*");
  radio = s7_car(_p);
  if (!s7_is_boolean(radio)) s7_wrong_type_arg_error(sc, "gtk_cell_renderer_toggle_set_radio", 2, radio, "gboolean");
  gtk_cell_renderer_toggle_set_radio((GtkCellRendererToggle*)s7_c_pointer(toggle), (gboolean)lg_boolean(radio));
  return(lg_false);
}

static s7_pointer lg_gtk_cell_renderer_toggle_get_active(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_renderer_toggle_get_active "gboolean gtk_cell_renderer_toggle_get_active(GtkCellRendererToggle* toggle)"
  s7_pointer toggle;
  toggle = s7_car(args);
  if (!s7_is_c_pointer_of_type(toggle, GtkCellRendererToggle__sym)) s7_wrong_type_arg_error(sc, "gtk_cell_renderer_toggle_get_active", 1, toggle, "GtkCellRendererToggle*");
  return(s7_make_boolean(sc, gtk_cell_renderer_toggle_get_active((GtkCellRendererToggle*)s7_c_pointer(toggle))));
}

static s7_pointer lg_gtk_cell_renderer_toggle_set_active(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_renderer_toggle_set_active "void gtk_cell_renderer_toggle_set_active(GtkCellRendererToggle* toggle, \
gboolean setting)"
  s7_pointer _p;
  s7_pointer toggle, setting;
  _p = args;
  toggle = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(toggle, GtkCellRendererToggle__sym)) s7_wrong_type_arg_error(sc, "gtk_cell_renderer_toggle_set_active", 1, toggle, "GtkCellRendererToggle*");
  setting = s7_car(_p);
  if (!s7_is_boolean(setting)) s7_wrong_type_arg_error(sc, "gtk_cell_renderer_toggle_set_active", 2, setting, "gboolean");
  gtk_cell_renderer_toggle_set_active((GtkCellRendererToggle*)s7_c_pointer(toggle), (gboolean)lg_boolean(setting));
  return(lg_false);
}

static s7_pointer lg_gtk_check_button_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_check_button_new "GtkWidget* gtk_check_button_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_check_button_new()));
}

static s7_pointer lg_gtk_check_button_new_with_label(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_check_button_new_with_label "GtkWidget* gtk_check_button_new_with_label(gchar* label)"
  s7_pointer label;
  label = s7_car(args);
  if (!s7_is_string(label)) s7_wrong_type_arg_error(sc, "gtk_check_button_new_with_label", 1, label, "gchar*");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_check_button_new_with_label((gchar*)s7_string(label))));
}

static s7_pointer lg_gtk_check_button_new_with_mnemonic(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_check_button_new_with_mnemonic "GtkWidget* gtk_check_button_new_with_mnemonic(gchar* label)"
  s7_pointer label;
  label = s7_car(args);
  if (!s7_is_string(label)) s7_wrong_type_arg_error(sc, "gtk_check_button_new_with_mnemonic", 1, label, "gchar*");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_check_button_new_with_mnemonic((gchar*)s7_string(label))));
}

static s7_pointer lg_gtk_dialog_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_dialog_new "GtkWidget* gtk_dialog_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_dialog_new()));
}

static s7_pointer lg_gtk_dialog_add_action_widget(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_dialog_add_action_widget "void gtk_dialog_add_action_widget(GtkDialog* dialog, GtkWidget* child, \
gint response_id)"
  s7_pointer _p;
  s7_pointer dialog, child, response_id;
  _p = args;
  dialog = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(dialog, GtkDialog__sym)) s7_wrong_type_arg_error(sc, "gtk_dialog_add_action_widget", 1, dialog, "GtkDialog*");
  child = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(child, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_dialog_add_action_widget", 2, child, "GtkWidget*");
  response_id = s7_car(_p);
  if (!s7_is_integer(response_id)) s7_wrong_type_arg_error(sc, "gtk_dialog_add_action_widget", 3, response_id, "gint");
  gtk_dialog_add_action_widget((GtkDialog*)s7_c_pointer(dialog), (GtkWidget*)s7_c_pointer(child), (gint)s7_integer(response_id));
  return(lg_false);
}

static s7_pointer lg_gtk_dialog_add_button(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_dialog_add_button "GtkWidget* gtk_dialog_add_button(GtkDialog* dialog, gchar* button_text, \
gint response_id)"
  s7_pointer _p;
  s7_pointer dialog, button_text, response_id;
  _p = args;
  dialog = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(dialog, GtkDialog__sym)) s7_wrong_type_arg_error(sc, "gtk_dialog_add_button", 1, dialog, "GtkDialog*");
  button_text = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(button_text)) s7_wrong_type_arg_error(sc, "gtk_dialog_add_button", 2, button_text, "gchar*");
  response_id = s7_car(_p);
  if (!s7_is_integer(response_id)) s7_wrong_type_arg_error(sc, "gtk_dialog_add_button", 3, response_id, "gint");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_dialog_add_button((GtkDialog*)s7_c_pointer(dialog), (gchar*)s7_string(button_text), (gint)s7_integer(response_id))));
}

static s7_pointer lg_gtk_dialog_add_buttons(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_dialog_add_buttons "void gtk_dialog_add_buttons(GtkDialog* dialog, etc buttons)"
  s7_pointer _p;
  s7_pointer dialog, buttons;
  _p = args;
  dialog = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(dialog, GtkDialog__sym)) s7_wrong_type_arg_error(sc, "gtk_dialog_add_buttons", 1, dialog, "GtkDialog*");
  buttons = s7_car(_p);
  if (!lg_is_list(buttons)) s7_wrong_type_arg_error(sc, "gtk_dialog_add_buttons", 2, buttons, "etc");
  {
    int etc_len = 0;
    GtkDialog* p_arg0;
    if (s7_is_list(sc, buttons)) etc_len = s7_list_length(sc, buttons);
    if (etc_len < 2) s7_out_of_range_error(sc, "gtk_dialog_add_buttons", 1, buttons, "... list must have at least 2 entries");
    if (etc_len > 10) s7_out_of_range_error(sc, "gtk_dialog_add_buttons", 1, buttons, "... list too long (max len: 10)");
    if ((etc_len % 2) != 0) s7_out_of_range_error(sc, "gtk_dialog_add_buttons", 1, buttons, "... list len must be multiple of 2");
    p_arg0 = (GtkDialog*)s7_c_pointer(dialog);
    switch (etc_len)
      {
        case 2: gtk_dialog_add_buttons(p_arg0, s7_string(s7_list_ref(sc, buttons, 0)), s7_integer(s7_list_ref(sc, buttons, 1)), NULL); break;
        case 4: gtk_dialog_add_buttons(p_arg0, s7_string(s7_list_ref(sc, buttons, 0)), s7_integer(s7_list_ref(sc, buttons, 1)), s7_string(s7_list_ref(sc, buttons, 2)), s7_integer(s7_list_ref(sc, buttons, 3)), NULL); break;
        case 6: gtk_dialog_add_buttons(p_arg0, s7_string(s7_list_ref(sc, buttons, 0)), s7_integer(s7_list_ref(sc, buttons, 1)), s7_string(s7_list_ref(sc, buttons, 2)), s7_integer(s7_list_ref(sc, buttons, 3)), s7_string(s7_list_ref(sc, buttons, 4)), s7_integer(s7_list_ref(sc, buttons, 5)), NULL); break;
        case 8: gtk_dialog_add_buttons(p_arg0, s7_string(s7_list_ref(sc, buttons, 0)), s7_integer(s7_list_ref(sc, buttons, 1)), s7_string(s7_list_ref(sc, buttons, 2)), s7_integer(s7_list_ref(sc, buttons, 3)), s7_string(s7_list_ref(sc, buttons, 4)), s7_integer(s7_list_ref(sc, buttons, 5)), s7_string(s7_list_ref(sc, buttons, 6)), s7_integer(s7_list_ref(sc, buttons, 7)), NULL); break;
        case 10: gtk_dialog_add_buttons(p_arg0, s7_string(s7_list_ref(sc, buttons, 0)), s7_integer(s7_list_ref(sc, buttons, 1)), s7_string(s7_list_ref(sc, buttons, 2)), s7_integer(s7_list_ref(sc, buttons, 3)), s7_string(s7_list_ref(sc, buttons, 4)), s7_integer(s7_list_ref(sc, buttons, 5)), s7_string(s7_list_ref(sc, buttons, 6)), s7_integer(s7_list_ref(sc, buttons, 7)), s7_string(s7_list_ref(sc, buttons, 8)), s7_integer(s7_list_ref(sc, buttons, 9)), NULL); break;
      }
    return(lg_false);
  }
}

static s7_pointer lg_gtk_dialog_set_response_sensitive(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_dialog_set_response_sensitive "void gtk_dialog_set_response_sensitive(GtkDialog* dialog, \
gint response_id, gboolean setting)"
  s7_pointer _p;
  s7_pointer dialog, response_id, setting;
  _p = args;
  dialog = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(dialog, GtkDialog__sym)) s7_wrong_type_arg_error(sc, "gtk_dialog_set_response_sensitive", 1, dialog, "GtkDialog*");
  response_id = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(response_id)) s7_wrong_type_arg_error(sc, "gtk_dialog_set_response_sensitive", 2, response_id, "gint");
  setting = s7_car(_p);
  if (!s7_is_boolean(setting)) s7_wrong_type_arg_error(sc, "gtk_dialog_set_response_sensitive", 3, setting, "gboolean");
  gtk_dialog_set_response_sensitive((GtkDialog*)s7_c_pointer(dialog), (gint)s7_integer(response_id), (gboolean)lg_boolean(setting));
  return(lg_false);
}

static s7_pointer lg_gtk_dialog_set_default_response(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_dialog_set_default_response "void gtk_dialog_set_default_response(GtkDialog* dialog, \
gint response_id)"
  s7_pointer _p;
  s7_pointer dialog, response_id;
  _p = args;
  dialog = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(dialog, GtkDialog__sym)) s7_wrong_type_arg_error(sc, "gtk_dialog_set_default_response", 1, dialog, "GtkDialog*");
  response_id = s7_car(_p);
  if (!s7_is_integer(response_id)) s7_wrong_type_arg_error(sc, "gtk_dialog_set_default_response", 2, response_id, "gint");
  gtk_dialog_set_default_response((GtkDialog*)s7_c_pointer(dialog), (gint)s7_integer(response_id));
  return(lg_false);
}

static s7_pointer lg_gtk_dialog_response(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_dialog_response "void gtk_dialog_response(GtkDialog* dialog, gint response_id)"
  s7_pointer _p;
  s7_pointer dialog, response_id;
  _p = args;
  dialog = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(dialog, GtkDialog__sym)) s7_wrong_type_arg_error(sc, "gtk_dialog_response", 1, dialog, "GtkDialog*");
  response_id = s7_car(_p);
  if (!s7_is_integer(response_id)) s7_wrong_type_arg_error(sc, "gtk_dialog_response", 2, response_id, "gint");
  gtk_dialog_response((GtkDialog*)s7_c_pointer(dialog), (gint)s7_integer(response_id));
  return(lg_false);
}

static s7_pointer lg_gtk_drawing_area_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_drawing_area_new "GtkWidget* gtk_drawing_area_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_drawing_area_new()));
}

static s7_pointer lg_gtk_editable_select_region(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_editable_select_region "void gtk_editable_select_region(GtkEditable* editable, int start, \
int end)"
  s7_pointer _p;
  s7_pointer editable, start, end;
  _p = args;
  editable = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(editable, GtkEditable__sym)) s7_wrong_type_arg_error(sc, "gtk_editable_select_region", 1, editable, "GtkEditable*");
  start = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(start)) s7_wrong_type_arg_error(sc, "gtk_editable_select_region", 2, start, "int");
  end = s7_car(_p);
  if (!s7_is_integer(end)) s7_wrong_type_arg_error(sc, "gtk_editable_select_region", 3, end, "int");
  gtk_editable_select_region((GtkEditable*)s7_c_pointer(editable), (int)s7_integer(start), (int)s7_integer(end));
  return(lg_false);
}

static s7_pointer lg_gtk_editable_get_selection_bounds(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_editable_get_selection_bounds "gboolean gtk_editable_get_selection_bounds(GtkEditable* editable, \
int* [start], int* [end])"
  s7_pointer _p;
  s7_pointer editable;
  int ref_start;
  int ref_end;
  _p = args;
  editable = s7_car(_p);
  if (!s7_is_c_pointer_of_type(editable, GtkEditable__sym)) s7_wrong_type_arg_error(sc, "gtk_editable_get_selection_bounds", 1, editable, "GtkEditable*");
  {
    s7_pointer res_ult;
    res_ult = s7_make_boolean(sc, gtk_editable_get_selection_bounds((GtkEditable*)s7_c_pointer(editable), &ref_start, &ref_end));
      return(s7_list(sc, 3, res_ult, s7_make_integer(sc, ref_start), s7_make_integer(sc, ref_end)));
   }
}

static s7_pointer lg_gtk_editable_insert_text(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_editable_insert_text "void gtk_editable_insert_text(GtkEditable* editable, gchar* new_text, \
int new_text_length, int* [position])"
  s7_pointer _p;
  s7_pointer editable, new_text, new_text_length;
  int ref_position;
  _p = args;
  editable = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(editable, GtkEditable__sym)) s7_wrong_type_arg_error(sc, "gtk_editable_insert_text", 1, editable, "GtkEditable*");
  new_text = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(new_text)) s7_wrong_type_arg_error(sc, "gtk_editable_insert_text", 2, new_text, "gchar*");
  new_text_length = s7_car(_p);
  if (!s7_is_integer(new_text_length)) s7_wrong_type_arg_error(sc, "gtk_editable_insert_text", 3, new_text_length, "int");
  gtk_editable_insert_text((GtkEditable*)s7_c_pointer(editable), (gchar*)s7_string(new_text), (int)s7_integer(new_text_length), &ref_position);
    return(s7_list(sc, 1, s7_make_integer(sc, ref_position)));
}

static s7_pointer lg_gtk_editable_delete_text(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_editable_delete_text "void gtk_editable_delete_text(GtkEditable* editable, int start_pos, \
int end_pos)"
  s7_pointer _p;
  s7_pointer editable, start_pos, end_pos;
  _p = args;
  editable = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(editable, GtkEditable__sym)) s7_wrong_type_arg_error(sc, "gtk_editable_delete_text", 1, editable, "GtkEditable*");
  start_pos = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(start_pos)) s7_wrong_type_arg_error(sc, "gtk_editable_delete_text", 2, start_pos, "int");
  end_pos = s7_car(_p);
  if (!s7_is_integer(end_pos)) s7_wrong_type_arg_error(sc, "gtk_editable_delete_text", 3, end_pos, "int");
  gtk_editable_delete_text((GtkEditable*)s7_c_pointer(editable), (int)s7_integer(start_pos), (int)s7_integer(end_pos));
  return(lg_false);
}

static s7_pointer lg_gtk_editable_get_chars(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_editable_get_chars "gchar* gtk_editable_get_chars(GtkEditable* editable, int start_pos, \
int end_pos)"
  s7_pointer _p;
  s7_pointer editable, start_pos, end_pos;
  _p = args;
  editable = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(editable, GtkEditable__sym)) s7_wrong_type_arg_error(sc, "gtk_editable_get_chars", 1, editable, "GtkEditable*");
  start_pos = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(start_pos)) s7_wrong_type_arg_error(sc, "gtk_editable_get_chars", 2, start_pos, "int");
  end_pos = s7_car(_p);
  if (!s7_is_integer(end_pos)) s7_wrong_type_arg_error(sc, "gtk_editable_get_chars", 3, end_pos, "int");
  {
    gchar* res_ult;
    s7_pointer rtn;
    res_ult = gtk_editable_get_chars((GtkEditable*)s7_c_pointer(editable), (int)s7_integer(start_pos), (int)s7_integer(end_pos));
    rtn = s7_make_string(sc, res_ult);
    g_free(res_ult);
    return(rtn);
  }
}

static s7_pointer lg_gtk_editable_delete_selection(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_editable_delete_selection "void gtk_editable_delete_selection(GtkEditable* editable)"
  s7_pointer editable;
  editable = s7_car(args);
  if (!s7_is_c_pointer_of_type(editable, GtkEditable__sym)) s7_wrong_type_arg_error(sc, "gtk_editable_delete_selection", 1, editable, "GtkEditable*");
  gtk_editable_delete_selection((GtkEditable*)s7_c_pointer(editable));
  return(lg_false);
}

static s7_pointer lg_gtk_editable_set_position(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_editable_set_position "void gtk_editable_set_position(GtkEditable* editable, gint position)"
  s7_pointer _p;
  s7_pointer editable, position;
  _p = args;
  editable = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(editable, GtkEditable__sym)) s7_wrong_type_arg_error(sc, "gtk_editable_set_position", 1, editable, "GtkEditable*");
  position = s7_car(_p);
  if (!s7_is_integer(position)) s7_wrong_type_arg_error(sc, "gtk_editable_set_position", 2, position, "gint");
  gtk_editable_set_position((GtkEditable*)s7_c_pointer(editable), (gint)s7_integer(position));
  return(lg_false);
}

static s7_pointer lg_gtk_editable_get_position(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_editable_get_position "gint gtk_editable_get_position(GtkEditable* editable)"
  s7_pointer editable;
  editable = s7_car(args);
  if (!s7_is_c_pointer_of_type(editable, GtkEditable__sym)) s7_wrong_type_arg_error(sc, "gtk_editable_get_position", 1, editable, "GtkEditable*");
  return(s7_make_integer(sc, gtk_editable_get_position((GtkEditable*)s7_c_pointer(editable))));
}

static s7_pointer lg_gtk_editable_set_editable(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_editable_set_editable "void gtk_editable_set_editable(GtkEditable* editable, gboolean is_editable)"
  s7_pointer _p;
  s7_pointer editable, is_editable;
  _p = args;
  editable = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(editable, GtkEditable__sym)) s7_wrong_type_arg_error(sc, "gtk_editable_set_editable", 1, editable, "GtkEditable*");
  is_editable = s7_car(_p);
  if (!s7_is_boolean(is_editable)) s7_wrong_type_arg_error(sc, "gtk_editable_set_editable", 2, is_editable, "gboolean");
  gtk_editable_set_editable((GtkEditable*)s7_c_pointer(editable), (gboolean)lg_boolean(is_editable));
  return(lg_false);
}

static s7_pointer lg_gtk_editable_get_editable(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_editable_get_editable "gboolean gtk_editable_get_editable(GtkEditable* editable)"
  s7_pointer editable;
  editable = s7_car(args);
  if (!s7_is_c_pointer_of_type(editable, GtkEditable__sym)) s7_wrong_type_arg_error(sc, "gtk_editable_get_editable", 1, editable, "GtkEditable*");
  return(s7_make_boolean(sc, gtk_editable_get_editable((GtkEditable*)s7_c_pointer(editable))));
}

static s7_pointer lg_gtk_entry_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_new "GtkWidget* gtk_entry_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_entry_new()));
}

static s7_pointer lg_gtk_entry_set_visibility(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_set_visibility "void gtk_entry_set_visibility(GtkEntry* entry, gboolean visible)"
  s7_pointer _p;
  s7_pointer entry, visible;
  _p = args;
  entry = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(entry, GtkEntry__sym)) s7_wrong_type_arg_error(sc, "gtk_entry_set_visibility", 1, entry, "GtkEntry*");
  visible = s7_car(_p);
  if (!s7_is_boolean(visible)) s7_wrong_type_arg_error(sc, "gtk_entry_set_visibility", 2, visible, "gboolean");
  gtk_entry_set_visibility((GtkEntry*)s7_c_pointer(entry), (gboolean)lg_boolean(visible));
  return(lg_false);
}

static s7_pointer lg_gtk_entry_get_visibility(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_get_visibility "gboolean gtk_entry_get_visibility(GtkEntry* entry)"
  s7_pointer entry;
  entry = s7_car(args);
  if (!s7_is_c_pointer_of_type(entry, GtkEntry__sym)) s7_wrong_type_arg_error(sc, "gtk_entry_get_visibility", 1, entry, "GtkEntry*");
  return(s7_make_boolean(sc, gtk_entry_get_visibility((GtkEntry*)s7_c_pointer(entry))));
}

static s7_pointer lg_gtk_entry_set_invisible_char(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_set_invisible_char "void gtk_entry_set_invisible_char(GtkEntry* entry, gunichar ch)"
  s7_pointer _p;
  s7_pointer entry, ch;
  _p = args;
  entry = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(entry, GtkEntry__sym)) s7_wrong_type_arg_error(sc, "gtk_entry_set_invisible_char", 1, entry, "GtkEntry*");
  ch = s7_car(_p);
  if (!s7_is_integer(ch)) s7_wrong_type_arg_error(sc, "gtk_entry_set_invisible_char", 2, ch, "gunichar");
  gtk_entry_set_invisible_char((GtkEntry*)s7_c_pointer(entry), (gunichar)s7_integer(ch));
  return(lg_false);
}

static s7_pointer lg_gtk_entry_get_invisible_char(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_get_invisible_char "gunichar gtk_entry_get_invisible_char(GtkEntry* entry)"
  s7_pointer entry;
  entry = s7_car(args);
  if (!s7_is_c_pointer_of_type(entry, GtkEntry__sym)) s7_wrong_type_arg_error(sc, "gtk_entry_get_invisible_char", 1, entry, "GtkEntry*");
  return(s7_make_integer(sc, gtk_entry_get_invisible_char((GtkEntry*)s7_c_pointer(entry))));
}

static s7_pointer lg_gtk_entry_set_has_frame(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_set_has_frame "void gtk_entry_set_has_frame(GtkEntry* entry, gboolean setting)"
  s7_pointer _p;
  s7_pointer entry, setting;
  _p = args;
  entry = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(entry, GtkEntry__sym)) s7_wrong_type_arg_error(sc, "gtk_entry_set_has_frame", 1, entry, "GtkEntry*");
  setting = s7_car(_p);
  if (!s7_is_boolean(setting)) s7_wrong_type_arg_error(sc, "gtk_entry_set_has_frame", 2, setting, "gboolean");
  gtk_entry_set_has_frame((GtkEntry*)s7_c_pointer(entry), (gboolean)lg_boolean(setting));
  return(lg_false);
}

static s7_pointer lg_gtk_entry_get_has_frame(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_get_has_frame "gboolean gtk_entry_get_has_frame(GtkEntry* entry)"
  s7_pointer entry;
  entry = s7_car(args);
  if (!s7_is_c_pointer_of_type(entry, GtkEntry__sym)) s7_wrong_type_arg_error(sc, "gtk_entry_get_has_frame", 1, entry, "GtkEntry*");
  return(s7_make_boolean(sc, gtk_entry_get_has_frame((GtkEntry*)s7_c_pointer(entry))));
}

static s7_pointer lg_gtk_entry_set_max_length(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_set_max_length "void gtk_entry_set_max_length(GtkEntry* entry, gint max)"
  s7_pointer _p;
  s7_pointer entry, max;
  _p = args;
  entry = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(entry, GtkEntry__sym)) s7_wrong_type_arg_error(sc, "gtk_entry_set_max_length", 1, entry, "GtkEntry*");
  max = s7_car(_p);
  if (!s7_is_integer(max)) s7_wrong_type_arg_error(sc, "gtk_entry_set_max_length", 2, max, "gint");
  gtk_entry_set_max_length((GtkEntry*)s7_c_pointer(entry), (gint)s7_integer(max));
  return(lg_false);
}

static s7_pointer lg_gtk_entry_get_max_length(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_get_max_length "gint gtk_entry_get_max_length(GtkEntry* entry)"
  s7_pointer entry;
  entry = s7_car(args);
  if (!s7_is_c_pointer_of_type(entry, GtkEntry__sym)) s7_wrong_type_arg_error(sc, "gtk_entry_get_max_length", 1, entry, "GtkEntry*");
  return(s7_make_integer(sc, gtk_entry_get_max_length((GtkEntry*)s7_c_pointer(entry))));
}

static s7_pointer lg_gtk_entry_set_activates_default(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_set_activates_default "void gtk_entry_set_activates_default(GtkEntry* entry, gboolean setting)"
  s7_pointer _p;
  s7_pointer entry, setting;
  _p = args;
  entry = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(entry, GtkEntry__sym)) s7_wrong_type_arg_error(sc, "gtk_entry_set_activates_default", 1, entry, "GtkEntry*");
  setting = s7_car(_p);
  if (!s7_is_boolean(setting)) s7_wrong_type_arg_error(sc, "gtk_entry_set_activates_default", 2, setting, "gboolean");
  gtk_entry_set_activates_default((GtkEntry*)s7_c_pointer(entry), (gboolean)lg_boolean(setting));
  return(lg_false);
}

static s7_pointer lg_gtk_entry_get_activates_default(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_get_activates_default "gboolean gtk_entry_get_activates_default(GtkEntry* entry)"
  s7_pointer entry;
  entry = s7_car(args);
  if (!s7_is_c_pointer_of_type(entry, GtkEntry__sym)) s7_wrong_type_arg_error(sc, "gtk_entry_get_activates_default", 1, entry, "GtkEntry*");
  return(s7_make_boolean(sc, gtk_entry_get_activates_default((GtkEntry*)s7_c_pointer(entry))));
}

static s7_pointer lg_gtk_fixed_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_fixed_new "GtkWidget* gtk_fixed_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_fixed_new()));
}

static s7_pointer lg_gtk_fixed_put(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_fixed_put "void gtk_fixed_put(GtkFixed* fixed, GtkWidget* widget, gint x, gint y)"
  s7_pointer _p;
  s7_pointer fixed, widget, x, y;
  _p = args;
  fixed = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(fixed, GtkFixed__sym)) s7_wrong_type_arg_error(sc, "gtk_fixed_put", 1, fixed, "GtkFixed*");
  widget = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(widget, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_fixed_put", 2, widget, "GtkWidget*");
  x = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(x)) s7_wrong_type_arg_error(sc, "gtk_fixed_put", 3, x, "gint");
  y = s7_car(_p);
  if (!s7_is_integer(y)) s7_wrong_type_arg_error(sc, "gtk_fixed_put", 4, y, "gint");
  gtk_fixed_put((GtkFixed*)s7_c_pointer(fixed), (GtkWidget*)s7_c_pointer(widget), (gint)s7_integer(x), (gint)s7_integer(y));
  return(lg_false);
}

static s7_pointer lg_gtk_fixed_move(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_fixed_move "void gtk_fixed_move(GtkFixed* fixed, GtkWidget* widget, gint x, gint y)"
  s7_pointer _p;
  s7_pointer fixed, widget, x, y;
  _p = args;
  fixed = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(fixed, GtkFixed__sym)) s7_wrong_type_arg_error(sc, "gtk_fixed_move", 1, fixed, "GtkFixed*");
  widget = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(widget, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_fixed_move", 2, widget, "GtkWidget*");
  x = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(x)) s7_wrong_type_arg_error(sc, "gtk_fixed_move", 3, x, "gint");
  y = s7_car(_p);
  if (!s7_is_integer(y)) s7_wrong_type_arg_error(sc, "gtk_fixed_move", 4, y, "gint");
  gtk_fixed_move((GtkFixed*)s7_c_pointer(fixed), (GtkWidget*)s7_c_pointer(widget), (gint)s7_integer(x), (gint)s7_integer(y));
  return(lg_false);
}

static s7_pointer lg_gtk_frame_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_frame_new "GtkWidget* gtk_frame_new(gchar* label)"
  s7_pointer label;
  label = s7_car(args);
  if (!s7_is_string(label)) s7_wrong_type_arg_error(sc, "gtk_frame_new", 1, label, "gchar*");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_frame_new((gchar*)s7_string(label))));
}

static s7_pointer lg_gtk_frame_set_label(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_frame_set_label "void gtk_frame_set_label(GtkFrame* frame, gchar* label)"
  s7_pointer _p;
  s7_pointer frame, label;
  _p = args;
  frame = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(frame, GtkFrame__sym)) s7_wrong_type_arg_error(sc, "gtk_frame_set_label", 1, frame, "GtkFrame*");
  label = s7_car(_p);
  if (!s7_is_string(label)) s7_wrong_type_arg_error(sc, "gtk_frame_set_label", 2, label, "gchar*");
  gtk_frame_set_label((GtkFrame*)s7_c_pointer(frame), (gchar*)s7_string(label));
  return(lg_false);
}

static s7_pointer lg_gtk_frame_get_label(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_frame_get_label "gchar* gtk_frame_get_label(GtkFrame* frame)"
  s7_pointer frame;
  frame = s7_car(args);
  if (!s7_is_c_pointer_of_type(frame, GtkFrame__sym)) s7_wrong_type_arg_error(sc, "gtk_frame_get_label", 1, frame, "GtkFrame*");
  return(s7_make_string(sc, gtk_frame_get_label((GtkFrame*)s7_c_pointer(frame))));
}

static s7_pointer lg_gtk_frame_set_label_widget(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_frame_set_label_widget "void gtk_frame_set_label_widget(GtkFrame* frame, GtkWidget* label_widget)"
  s7_pointer _p;
  s7_pointer frame, label_widget;
  _p = args;
  frame = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(frame, GtkFrame__sym)) s7_wrong_type_arg_error(sc, "gtk_frame_set_label_widget", 1, frame, "GtkFrame*");
  label_widget = s7_car(_p);
  if (!s7_is_c_pointer_of_type(label_widget, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_frame_set_label_widget", 2, label_widget, "GtkWidget*");
  gtk_frame_set_label_widget((GtkFrame*)s7_c_pointer(frame), (GtkWidget*)s7_c_pointer(label_widget));
  return(lg_false);
}

static s7_pointer lg_gtk_frame_get_label_widget(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_frame_get_label_widget "GtkWidget* gtk_frame_get_label_widget(GtkFrame* frame)"
  s7_pointer frame;
  frame = s7_car(args);
  if (!s7_is_c_pointer_of_type(frame, GtkFrame__sym)) s7_wrong_type_arg_error(sc, "gtk_frame_get_label_widget", 1, frame, "GtkFrame*");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_frame_get_label_widget((GtkFrame*)s7_c_pointer(frame))));
}

static s7_pointer lg_gtk_image_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_image_new "GtkWidget* gtk_image_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_image_new()));
}

static s7_pointer lg_gtk_image_new_from_file(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_image_new_from_file "GtkWidget* gtk_image_new_from_file(gchar* filename)"
  s7_pointer filename;
  filename = s7_car(args);
  if (!s7_is_string(filename)) s7_wrong_type_arg_error(sc, "gtk_image_new_from_file", 1, filename, "gchar*");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_image_new_from_file((gchar*)s7_string(filename))));
}

static s7_pointer lg_gtk_image_new_from_pixbuf(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_image_new_from_pixbuf "GtkWidget* gtk_image_new_from_pixbuf(GdkPixbuf* pixbuf)"
  s7_pointer pixbuf;
  pixbuf = s7_car(args);
  if ((!s7_is_c_pointer_of_type(pixbuf, GdkPixbuf__sym)) && (pixbuf != lg_false)) s7_wrong_type_arg_error(sc, "gtk_image_new_from_pixbuf", 1, pixbuf, "GdkPixbuf*");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_image_new_from_pixbuf((GdkPixbuf*)s7_c_pointer(pixbuf))));
}

static s7_pointer lg_gtk_image_set_from_file(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_image_set_from_file "void gtk_image_set_from_file(GtkImage* image, gchar* filename)"
  s7_pointer _p;
  s7_pointer image, filename;
  _p = args;
  image = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(image, GtkImage__sym)) s7_wrong_type_arg_error(sc, "gtk_image_set_from_file", 1, image, "GtkImage*");
  filename = s7_car(_p);
  if (!s7_is_string(filename)) s7_wrong_type_arg_error(sc, "gtk_image_set_from_file", 2, filename, "gchar*");
  gtk_image_set_from_file((GtkImage*)s7_c_pointer(image), (gchar*)s7_string(filename));
  return(lg_false);
}

static s7_pointer lg_gtk_image_set_from_pixbuf(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_image_set_from_pixbuf "void gtk_image_set_from_pixbuf(GtkImage* image, GdkPixbuf* pixbuf)"
  s7_pointer _p;
  s7_pointer image, pixbuf;
  _p = args;
  image = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(image, GtkImage__sym)) s7_wrong_type_arg_error(sc, "gtk_image_set_from_pixbuf", 1, image, "GtkImage*");
  pixbuf = s7_car(_p);
  if ((!s7_is_c_pointer_of_type(pixbuf, GdkPixbuf__sym)) && (pixbuf != lg_false)) s7_wrong_type_arg_error(sc, "gtk_image_set_from_pixbuf", 2, pixbuf, "GdkPixbuf*");
  gtk_image_set_from_pixbuf((GtkImage*)s7_c_pointer(image), (GdkPixbuf*)s7_c_pointer(pixbuf));
  return(lg_false);
}

static s7_pointer lg_gtk_image_get_storage_type(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_image_get_storage_type "GtkImageType gtk_image_get_storage_type(GtkImage* image)"
  s7_pointer image;
  image = s7_car(args);
  if (!s7_is_c_pointer_of_type(image, GtkImage__sym)) s7_wrong_type_arg_error(sc, "gtk_image_get_storage_type", 1, image, "GtkImage*");
  return(s7_make_integer(sc, gtk_image_get_storage_type((GtkImage*)s7_c_pointer(image))));
}

static s7_pointer lg_gtk_im_context_get_preedit_string(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_im_context_get_preedit_string "void gtk_im_context_get_preedit_string(GtkIMContext* context, \
gchar** [str], PangoAttrList** [attrs], gint* [cursor_pos])"
  s7_pointer _p;
  s7_pointer context;
  gchar* ref_str = NULL;
  PangoAttrList* ref_attrs = NULL;
  gint ref_cursor_pos;
  _p = args;
  context = s7_car(_p);
  if (!s7_is_c_pointer_of_type(context, GtkIMContext__sym)) s7_wrong_type_arg_error(sc, "gtk_im_context_get_preedit_string", 1, context, "GtkIMContext*");
  gtk_im_context_get_preedit_string((GtkIMContext*)s7_c_pointer(context), &ref_str, &ref_attrs, &ref_cursor_pos);
    return(s7_list(sc, 3, s7_make_string(sc, ref_str), s7_make_c_pointer(sc, ref_attrs), s7_make_integer(sc, ref_cursor_pos)));
}

static s7_pointer lg_gtk_im_context_focus_in(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_im_context_focus_in "void gtk_im_context_focus_in(GtkIMContext* context)"
  s7_pointer context;
  context = s7_car(args);
  if (!s7_is_c_pointer_of_type(context, GtkIMContext__sym)) s7_wrong_type_arg_error(sc, "gtk_im_context_focus_in", 1, context, "GtkIMContext*");
  gtk_im_context_focus_in((GtkIMContext*)s7_c_pointer(context));
  return(lg_false);
}

static s7_pointer lg_gtk_im_context_focus_out(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_im_context_focus_out "void gtk_im_context_focus_out(GtkIMContext* context)"
  s7_pointer context;
  context = s7_car(args);
  if (!s7_is_c_pointer_of_type(context, GtkIMContext__sym)) s7_wrong_type_arg_error(sc, "gtk_im_context_focus_out", 1, context, "GtkIMContext*");
  gtk_im_context_focus_out((GtkIMContext*)s7_c_pointer(context));
  return(lg_false);
}

static s7_pointer lg_gtk_im_context_reset(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_im_context_reset "void gtk_im_context_reset(GtkIMContext* context)"
  s7_pointer context;
  context = s7_car(args);
  if (!s7_is_c_pointer_of_type(context, GtkIMContext__sym)) s7_wrong_type_arg_error(sc, "gtk_im_context_reset", 1, context, "GtkIMContext*");
  gtk_im_context_reset((GtkIMContext*)s7_c_pointer(context));
  return(lg_false);
}

static s7_pointer lg_gtk_im_context_set_cursor_location(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_im_context_set_cursor_location "void gtk_im_context_set_cursor_location(GtkIMContext* context, \
GdkRectangle* area)"
  s7_pointer _p;
  s7_pointer context, area;
  _p = args;
  context = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(context, GtkIMContext__sym)) s7_wrong_type_arg_error(sc, "gtk_im_context_set_cursor_location", 1, context, "GtkIMContext*");
  area = s7_car(_p);
  if (!s7_is_c_pointer_of_type(area, GdkRectangle__sym)) s7_wrong_type_arg_error(sc, "gtk_im_context_set_cursor_location", 2, area, "GdkRectangle*");
  gtk_im_context_set_cursor_location((GtkIMContext*)s7_c_pointer(context), (GdkRectangle*)s7_c_pointer(area));
  return(lg_false);
}

static s7_pointer lg_gtk_im_context_set_use_preedit(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_im_context_set_use_preedit "void gtk_im_context_set_use_preedit(GtkIMContext* context, \
gboolean use_preedit)"
  s7_pointer _p;
  s7_pointer context, use_preedit;
  _p = args;
  context = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(context, GtkIMContext__sym)) s7_wrong_type_arg_error(sc, "gtk_im_context_set_use_preedit", 1, context, "GtkIMContext*");
  use_preedit = s7_car(_p);
  if (!s7_is_boolean(use_preedit)) s7_wrong_type_arg_error(sc, "gtk_im_context_set_use_preedit", 2, use_preedit, "gboolean");
  gtk_im_context_set_use_preedit((GtkIMContext*)s7_c_pointer(context), (gboolean)lg_boolean(use_preedit));
  return(lg_false);
}

static s7_pointer lg_gtk_im_context_set_surrounding(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_im_context_set_surrounding "void gtk_im_context_set_surrounding(GtkIMContext* context, \
gchar* text, gint len, gint cursor_index)"
  s7_pointer _p;
  s7_pointer context, text, len, cursor_index;
  _p = args;
  context = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(context, GtkIMContext__sym)) s7_wrong_type_arg_error(sc, "gtk_im_context_set_surrounding", 1, context, "GtkIMContext*");
  text = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(text)) s7_wrong_type_arg_error(sc, "gtk_im_context_set_surrounding", 2, text, "gchar*");
  len = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(len)) s7_wrong_type_arg_error(sc, "gtk_im_context_set_surrounding", 3, len, "gint");
  cursor_index = s7_car(_p);
  if (!s7_is_integer(cursor_index)) s7_wrong_type_arg_error(sc, "gtk_im_context_set_surrounding", 4, cursor_index, "gint");
  gtk_im_context_set_surrounding((GtkIMContext*)s7_c_pointer(context), (gchar*)s7_string(text), (gint)s7_integer(len), (gint)s7_integer(cursor_index));
  return(lg_false);
}

static s7_pointer lg_gtk_im_context_get_surrounding(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_im_context_get_surrounding "gboolean gtk_im_context_get_surrounding(GtkIMContext* context, \
gchar** [text], gint* [cursor_index])"
  s7_pointer _p;
  s7_pointer context;
  gchar* ref_text = NULL;
  gint ref_cursor_index;
  _p = args;
  context = s7_car(_p);
  if (!s7_is_c_pointer_of_type(context, GtkIMContext__sym)) s7_wrong_type_arg_error(sc, "gtk_im_context_get_surrounding", 1, context, "GtkIMContext*");
  {
    s7_pointer res_ult;
    res_ult = s7_make_boolean(sc, gtk_im_context_get_surrounding((GtkIMContext*)s7_c_pointer(context), &ref_text, &ref_cursor_index));
      return(s7_list(sc, 3, res_ult, s7_make_string(sc, ref_text), s7_make_integer(sc, ref_cursor_index)));
   }
}

static s7_pointer lg_gtk_im_context_delete_surrounding(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_im_context_delete_surrounding "gboolean gtk_im_context_delete_surrounding(GtkIMContext* context, \
gint offset, gint n_chars)"
  s7_pointer _p;
  s7_pointer context, offset, n_chars;
  _p = args;
  context = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(context, GtkIMContext__sym)) s7_wrong_type_arg_error(sc, "gtk_im_context_delete_surrounding", 1, context, "GtkIMContext*");
  offset = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(offset)) s7_wrong_type_arg_error(sc, "gtk_im_context_delete_surrounding", 2, offset, "gint");
  n_chars = s7_car(_p);
  if (!s7_is_integer(n_chars)) s7_wrong_type_arg_error(sc, "gtk_im_context_delete_surrounding", 3, n_chars, "gint");
  return(s7_make_boolean(sc, gtk_im_context_delete_surrounding((GtkIMContext*)s7_c_pointer(context), (gint)s7_integer(offset), (gint)s7_integer(n_chars))));
}

static s7_pointer lg_gtk_im_context_simple_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_im_context_simple_new "GtkIMContext* gtk_im_context_simple_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkIMContext__sym, gtk_im_context_simple_new()));
}

static s7_pointer lg_gtk_im_context_simple_add_table(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_im_context_simple_add_table "void gtk_im_context_simple_add_table(GtkIMContextSimple* context_simple, \
guint16* data, gint max_seq_len, gint n_seqs)"
  s7_pointer _p;
  s7_pointer context_simple, data, max_seq_len, n_seqs;
  _p = args;
  context_simple = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(context_simple, GtkIMContextSimple__sym)) s7_wrong_type_arg_error(sc, "gtk_im_context_simple_add_table", 1, context_simple, "GtkIMContextSimple*");
  data = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(data, guint16__sym)) s7_wrong_type_arg_error(sc, "gtk_im_context_simple_add_table", 2, data, "guint16*");
  max_seq_len = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(max_seq_len)) s7_wrong_type_arg_error(sc, "gtk_im_context_simple_add_table", 3, max_seq_len, "gint");
  n_seqs = s7_car(_p);
  if (!s7_is_integer(n_seqs)) s7_wrong_type_arg_error(sc, "gtk_im_context_simple_add_table", 4, n_seqs, "gint");
  gtk_im_context_simple_add_table((GtkIMContextSimple*)s7_c_pointer(context_simple), (guint16*)s7_c_pointer(data), (gint)s7_integer(max_seq_len), (gint)s7_integer(n_seqs));
  return(lg_false);
}

static s7_pointer lg_gtk_label_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_label_new "GtkWidget* gtk_label_new(char* str)"
  s7_pointer str;
  str = s7_car(args);
  if (!s7_is_string(str)) s7_wrong_type_arg_error(sc, "gtk_label_new", 1, str, "char*");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_label_new((char*)s7_string(str))));
}

static s7_pointer lg_gtk_label_new_with_mnemonic(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_label_new_with_mnemonic "GtkWidget* gtk_label_new_with_mnemonic(char* str)"
  s7_pointer str;
  str = s7_car(args);
  if (!s7_is_string(str)) s7_wrong_type_arg_error(sc, "gtk_label_new_with_mnemonic", 1, str, "char*");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_label_new_with_mnemonic((char*)s7_string(str))));
}

static s7_pointer lg_gtk_label_set_text(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_label_set_text "void gtk_label_set_text(GtkLabel* label, char* str)"
  s7_pointer _p;
  s7_pointer label, str;
  _p = args;
  label = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(label, GtkLabel__sym)) s7_wrong_type_arg_error(sc, "gtk_label_set_text", 1, label, "GtkLabel*");
  str = s7_car(_p);
  if (!s7_is_string(str)) s7_wrong_type_arg_error(sc, "gtk_label_set_text", 2, str, "char*");
  gtk_label_set_text((GtkLabel*)s7_c_pointer(label), (char*)s7_string(str));
  return(lg_false);
}

static s7_pointer lg_gtk_label_get_text(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_label_get_text "gchar* gtk_label_get_text(GtkLabel* label)"
  s7_pointer label;
  label = s7_car(args);
  if (!s7_is_c_pointer_of_type(label, GtkLabel__sym)) s7_wrong_type_arg_error(sc, "gtk_label_get_text", 1, label, "GtkLabel*");
  return(s7_make_string(sc, gtk_label_get_text((GtkLabel*)s7_c_pointer(label))));
}

static s7_pointer lg_gtk_label_set_attributes(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_label_set_attributes "void gtk_label_set_attributes(GtkLabel* label, PangoAttrList* attrs)"
  s7_pointer _p;
  s7_pointer label, attrs;
  _p = args;
  label = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(label, GtkLabel__sym)) s7_wrong_type_arg_error(sc, "gtk_label_set_attributes", 1, label, "GtkLabel*");
  attrs = s7_car(_p);
  if (!s7_is_c_pointer_of_type(attrs, PangoAttrList__sym)) s7_wrong_type_arg_error(sc, "gtk_label_set_attributes", 2, attrs, "PangoAttrList*");
  gtk_label_set_attributes((GtkLabel*)s7_c_pointer(label), (PangoAttrList*)s7_c_pointer(attrs));
  return(lg_false);
}

static s7_pointer lg_gtk_label_get_attributes(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_label_get_attributes "PangoAttrList* gtk_label_get_attributes(GtkLabel* label)"
  s7_pointer label;
  label = s7_car(args);
  if (!s7_is_c_pointer_of_type(label, GtkLabel__sym)) s7_wrong_type_arg_error(sc, "gtk_label_get_attributes", 1, label, "GtkLabel*");
  return(lg_make_c_pointer_with_type(sc, PangoAttrList__sym, gtk_label_get_attributes((GtkLabel*)s7_c_pointer(label))));
}

static s7_pointer lg_gtk_label_set_label(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_label_set_label "void gtk_label_set_label(GtkLabel* label, gchar* str)"
  s7_pointer _p;
  s7_pointer label, str;
  _p = args;
  label = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(label, GtkLabel__sym)) s7_wrong_type_arg_error(sc, "gtk_label_set_label", 1, label, "GtkLabel*");
  str = s7_car(_p);
  if (!s7_is_string(str)) s7_wrong_type_arg_error(sc, "gtk_label_set_label", 2, str, "gchar*");
  gtk_label_set_label((GtkLabel*)s7_c_pointer(label), (gchar*)s7_string(str));
  return(lg_false);
}

static s7_pointer lg_gtk_label_get_label(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_label_get_label "gchar* gtk_label_get_label(GtkLabel* label)"
  s7_pointer label;
  label = s7_car(args);
  if (!s7_is_c_pointer_of_type(label, GtkLabel__sym)) s7_wrong_type_arg_error(sc, "gtk_label_get_label", 1, label, "GtkLabel*");
  return(s7_make_string(sc, gtk_label_get_label((GtkLabel*)s7_c_pointer(label))));
}

static s7_pointer lg_gtk_label_set_markup(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_label_set_markup "void gtk_label_set_markup(GtkLabel* label, gchar* str)"
  s7_pointer _p;
  s7_pointer label, str;
  _p = args;
  label = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(label, GtkLabel__sym)) s7_wrong_type_arg_error(sc, "gtk_label_set_markup", 1, label, "GtkLabel*");
  str = s7_car(_p);
  if (!s7_is_string(str)) s7_wrong_type_arg_error(sc, "gtk_label_set_markup", 2, str, "gchar*");
  gtk_label_set_markup((GtkLabel*)s7_c_pointer(label), (gchar*)s7_string(str));
  return(lg_false);
}

static s7_pointer lg_gtk_label_set_use_markup(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_label_set_use_markup "void gtk_label_set_use_markup(GtkLabel* label, gboolean setting)"
  s7_pointer _p;
  s7_pointer label, setting;
  _p = args;
  label = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(label, GtkLabel__sym)) s7_wrong_type_arg_error(sc, "gtk_label_set_use_markup", 1, label, "GtkLabel*");
  setting = s7_car(_p);
  if (!s7_is_boolean(setting)) s7_wrong_type_arg_error(sc, "gtk_label_set_use_markup", 2, setting, "gboolean");
  gtk_label_set_use_markup((GtkLabel*)s7_c_pointer(label), (gboolean)lg_boolean(setting));
  return(lg_false);
}

static s7_pointer lg_gtk_label_get_use_markup(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_label_get_use_markup "gboolean gtk_label_get_use_markup(GtkLabel* label)"
  s7_pointer label;
  label = s7_car(args);
  if (!s7_is_c_pointer_of_type(label, GtkLabel__sym)) s7_wrong_type_arg_error(sc, "gtk_label_get_use_markup", 1, label, "GtkLabel*");
  return(s7_make_boolean(sc, gtk_label_get_use_markup((GtkLabel*)s7_c_pointer(label))));
}

static s7_pointer lg_gtk_label_set_use_underline(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_label_set_use_underline "void gtk_label_set_use_underline(GtkLabel* label, gboolean setting)"
  s7_pointer _p;
  s7_pointer label, setting;
  _p = args;
  label = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(label, GtkLabel__sym)) s7_wrong_type_arg_error(sc, "gtk_label_set_use_underline", 1, label, "GtkLabel*");
  setting = s7_car(_p);
  if (!s7_is_boolean(setting)) s7_wrong_type_arg_error(sc, "gtk_label_set_use_underline", 2, setting, "gboolean");
  gtk_label_set_use_underline((GtkLabel*)s7_c_pointer(label), (gboolean)lg_boolean(setting));
  return(lg_false);
}

static s7_pointer lg_gtk_label_get_use_underline(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_label_get_use_underline "gboolean gtk_label_get_use_underline(GtkLabel* label)"
  s7_pointer label;
  label = s7_car(args);
  if (!s7_is_c_pointer_of_type(label, GtkLabel__sym)) s7_wrong_type_arg_error(sc, "gtk_label_get_use_underline", 1, label, "GtkLabel*");
  return(s7_make_boolean(sc, gtk_label_get_use_underline((GtkLabel*)s7_c_pointer(label))));
}

static s7_pointer lg_gtk_label_set_markup_with_mnemonic(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_label_set_markup_with_mnemonic "void gtk_label_set_markup_with_mnemonic(GtkLabel* label, \
gchar* str)"
  s7_pointer _p;
  s7_pointer label, str;
  _p = args;
  label = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(label, GtkLabel__sym)) s7_wrong_type_arg_error(sc, "gtk_label_set_markup_with_mnemonic", 1, label, "GtkLabel*");
  str = s7_car(_p);
  if (!s7_is_string(str)) s7_wrong_type_arg_error(sc, "gtk_label_set_markup_with_mnemonic", 2, str, "gchar*");
  gtk_label_set_markup_with_mnemonic((GtkLabel*)s7_c_pointer(label), (gchar*)s7_string(str));
  return(lg_false);
}

static s7_pointer lg_gtk_label_get_mnemonic_keyval(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_label_get_mnemonic_keyval "guint gtk_label_get_mnemonic_keyval(GtkLabel* label)"
  s7_pointer label;
  label = s7_car(args);
  if (!s7_is_c_pointer_of_type(label, GtkLabel__sym)) s7_wrong_type_arg_error(sc, "gtk_label_get_mnemonic_keyval", 1, label, "GtkLabel*");
  return(s7_make_integer(sc, gtk_label_get_mnemonic_keyval((GtkLabel*)s7_c_pointer(label))));
}

static s7_pointer lg_gtk_label_set_mnemonic_widget(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_label_set_mnemonic_widget "void gtk_label_set_mnemonic_widget(GtkLabel* label, GtkWidget* widget)"
  s7_pointer _p;
  s7_pointer label, widget;
  _p = args;
  label = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(label, GtkLabel__sym)) s7_wrong_type_arg_error(sc, "gtk_label_set_mnemonic_widget", 1, label, "GtkLabel*");
  widget = s7_car(_p);
  if (!s7_is_c_pointer_of_type(widget, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_label_set_mnemonic_widget", 2, widget, "GtkWidget*");
  gtk_label_set_mnemonic_widget((GtkLabel*)s7_c_pointer(label), (GtkWidget*)s7_c_pointer(widget));
  return(lg_false);
}

static s7_pointer lg_gtk_label_get_mnemonic_widget(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_label_get_mnemonic_widget "GtkWidget* gtk_label_get_mnemonic_widget(GtkLabel* label)"
  s7_pointer label;
  label = s7_car(args);
  if (!s7_is_c_pointer_of_type(label, GtkLabel__sym)) s7_wrong_type_arg_error(sc, "gtk_label_get_mnemonic_widget", 1, label, "GtkLabel*");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_label_get_mnemonic_widget((GtkLabel*)s7_c_pointer(label))));
}

static s7_pointer lg_gtk_label_set_text_with_mnemonic(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_label_set_text_with_mnemonic "void gtk_label_set_text_with_mnemonic(GtkLabel* label, \
gchar* str)"
  s7_pointer _p;
  s7_pointer label, str;
  _p = args;
  label = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(label, GtkLabel__sym)) s7_wrong_type_arg_error(sc, "gtk_label_set_text_with_mnemonic", 1, label, "GtkLabel*");
  str = s7_car(_p);
  if (!s7_is_string(str)) s7_wrong_type_arg_error(sc, "gtk_label_set_text_with_mnemonic", 2, str, "gchar*");
  gtk_label_set_text_with_mnemonic((GtkLabel*)s7_c_pointer(label), (gchar*)s7_string(str));
  return(lg_false);
}

static s7_pointer lg_gtk_label_set_justify(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_label_set_justify "void gtk_label_set_justify(GtkLabel* label, GtkJustification jtype)"
  s7_pointer _p;
  s7_pointer label, jtype;
  _p = args;
  label = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(label, GtkLabel__sym)) s7_wrong_type_arg_error(sc, "gtk_label_set_justify", 1, label, "GtkLabel*");
  jtype = s7_car(_p);
  if (!s7_is_integer(jtype)) s7_wrong_type_arg_error(sc, "gtk_label_set_justify", 2, jtype, "GtkJustification");
  gtk_label_set_justify((GtkLabel*)s7_c_pointer(label), (GtkJustification)s7_integer(jtype));
  return(lg_false);
}

static s7_pointer lg_gtk_label_get_justify(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_label_get_justify "GtkJustification gtk_label_get_justify(GtkLabel* label)"
  s7_pointer label;
  label = s7_car(args);
  if (!s7_is_c_pointer_of_type(label, GtkLabel__sym)) s7_wrong_type_arg_error(sc, "gtk_label_get_justify", 1, label, "GtkLabel*");
  return(s7_make_integer(sc, gtk_label_get_justify((GtkLabel*)s7_c_pointer(label))));
}

static s7_pointer lg_gtk_label_set_selectable(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_label_set_selectable "void gtk_label_set_selectable(GtkLabel* label, gboolean setting)"
  s7_pointer _p;
  s7_pointer label, setting;
  _p = args;
  label = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(label, GtkLabel__sym)) s7_wrong_type_arg_error(sc, "gtk_label_set_selectable", 1, label, "GtkLabel*");
  setting = s7_car(_p);
  if (!s7_is_boolean(setting)) s7_wrong_type_arg_error(sc, "gtk_label_set_selectable", 2, setting, "gboolean");
  gtk_label_set_selectable((GtkLabel*)s7_c_pointer(label), (gboolean)lg_boolean(setting));
  return(lg_false);
}

static s7_pointer lg_gtk_label_get_selectable(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_label_get_selectable "gboolean gtk_label_get_selectable(GtkLabel* label)"
  s7_pointer label;
  label = s7_car(args);
  if (!s7_is_c_pointer_of_type(label, GtkLabel__sym)) s7_wrong_type_arg_error(sc, "gtk_label_get_selectable", 1, label, "GtkLabel*");
  return(s7_make_boolean(sc, gtk_label_get_selectable((GtkLabel*)s7_c_pointer(label))));
}

static s7_pointer lg_gtk_label_select_region(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_label_select_region "void gtk_label_select_region(GtkLabel* label, gint start_offset, \
gint end_offset)"
  s7_pointer _p;
  s7_pointer label, start_offset, end_offset;
  _p = args;
  label = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(label, GtkLabel__sym)) s7_wrong_type_arg_error(sc, "gtk_label_select_region", 1, label, "GtkLabel*");
  start_offset = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(start_offset)) s7_wrong_type_arg_error(sc, "gtk_label_select_region", 2, start_offset, "gint");
  end_offset = s7_car(_p);
  if (!s7_is_integer(end_offset)) s7_wrong_type_arg_error(sc, "gtk_label_select_region", 3, end_offset, "gint");
  gtk_label_select_region((GtkLabel*)s7_c_pointer(label), (gint)s7_integer(start_offset), (gint)s7_integer(end_offset));
  return(lg_false);
}

static s7_pointer lg_gtk_label_get_selection_bounds(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_label_get_selection_bounds "gboolean gtk_label_get_selection_bounds(GtkLabel* label, \
gint* [start], gint* [end])"
  s7_pointer _p;
  s7_pointer label;
  gint ref_start;
  gint ref_end;
  _p = args;
  label = s7_car(_p);
  if (!s7_is_c_pointer_of_type(label, GtkLabel__sym)) s7_wrong_type_arg_error(sc, "gtk_label_get_selection_bounds", 1, label, "GtkLabel*");
  {
    s7_pointer res_ult;
    res_ult = s7_make_boolean(sc, gtk_label_get_selection_bounds((GtkLabel*)s7_c_pointer(label), &ref_start, &ref_end));
      return(s7_list(sc, 3, res_ult, s7_make_integer(sc, ref_start), s7_make_integer(sc, ref_end)));
   }
}

static s7_pointer lg_gtk_label_get_layout(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_label_get_layout "PangoLayout* gtk_label_get_layout(GtkLabel* label)"
  s7_pointer label;
  label = s7_car(args);
  if (!s7_is_c_pointer_of_type(label, GtkLabel__sym)) s7_wrong_type_arg_error(sc, "gtk_label_get_layout", 1, label, "GtkLabel*");
  return(lg_make_c_pointer_with_type(sc, PangoLayout__sym, gtk_label_get_layout((GtkLabel*)s7_c_pointer(label))));
}

static s7_pointer lg_gtk_label_get_layout_offsets(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_label_get_layout_offsets "void gtk_label_get_layout_offsets(GtkLabel* label, gint* [x], \
gint* [y])"
  s7_pointer _p;
  s7_pointer label;
  gint ref_x;
  gint ref_y;
  _p = args;
  label = s7_car(_p);
  if (!s7_is_c_pointer_of_type(label, GtkLabel__sym)) s7_wrong_type_arg_error(sc, "gtk_label_get_layout_offsets", 1, label, "GtkLabel*");
  gtk_label_get_layout_offsets((GtkLabel*)s7_c_pointer(label), &ref_x, &ref_y);
    return(s7_list(sc, 2, s7_make_integer(sc, ref_x), s7_make_integer(sc, ref_y)));
}

static s7_pointer lg_gtk_list_store_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_list_store_new "GtkListStore* gtk_list_store_new(gint n_columns, etc types)"
  s7_pointer _p;
  s7_pointer n_columns, types;
  _p = args;
  n_columns = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(n_columns)) s7_wrong_type_arg_error(sc, "gtk_list_store_new", 1, n_columns, "gint");
  types = s7_car(_p);
  if (!lg_is_list(types)) s7_wrong_type_arg_error(sc, "gtk_list_store_new", 2, types, "etc");
  {
    int etc_len = 0;
    GtkListStore* res_ult = NULL;
    gint p_arg0;
    if (s7_is_list(sc, types)) etc_len = s7_list_length(sc, types);
    if (etc_len < 1) s7_out_of_range_error(sc, "gtk_list_store_new", 1, types, "... list must have at least 1 entry");
    if (etc_len > 6) s7_out_of_range_error(sc, "gtk_list_store_new", 1, types, "... list too long (max len: 6)");
    p_arg0 = (gint)s7_integer(n_columns);
    switch (etc_len)
      {
        case 1: res_ult = gtk_list_store_new(p_arg0, s7_c_pointer(s7_list_ref(sc, types, 0))); break;
        case 2: res_ult = gtk_list_store_new(p_arg0, s7_c_pointer(s7_list_ref(sc, types, 0)), s7_c_pointer(s7_list_ref(sc, types, 1))); break;
        case 3: res_ult = gtk_list_store_new(p_arg0, s7_c_pointer(s7_list_ref(sc, types, 0)), s7_c_pointer(s7_list_ref(sc, types, 1)), s7_c_pointer(s7_list_ref(sc, types, 2))); break;
        case 4: res_ult = gtk_list_store_new(p_arg0, s7_c_pointer(s7_list_ref(sc, types, 0)), s7_c_pointer(s7_list_ref(sc, types, 1)), s7_c_pointer(s7_list_ref(sc, types, 2)), s7_c_pointer(s7_list_ref(sc, types, 3))); break;
        case 5: res_ult = gtk_list_store_new(p_arg0, s7_c_pointer(s7_list_ref(sc, types, 0)), s7_c_pointer(s7_list_ref(sc, types, 1)), s7_c_pointer(s7_list_ref(sc, types, 2)), s7_c_pointer(s7_list_ref(sc, types, 3)), s7_c_pointer(s7_list_ref(sc, types, 4))); break;
        case 6: res_ult = gtk_list_store_new(p_arg0, s7_c_pointer(s7_list_ref(sc, types, 0)), s7_c_pointer(s7_list_ref(sc, types, 1)), s7_c_pointer(s7_list_ref(sc, types, 2)), s7_c_pointer(s7_list_ref(sc, types, 3)), s7_c_pointer(s7_list_ref(sc, types, 4)), s7_c_pointer(s7_list_ref(sc, types, 5))); break;
      }
    return(s7_make_c_pointer(sc, res_ult));
  }
}

static s7_pointer lg_gtk_list_store_newv(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_list_store_newv "GtkListStore* gtk_list_store_newv(gint n_columns, GType* types)"
  s7_pointer _p;
  s7_pointer n_columns, types;
  _p = args;
  n_columns = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(n_columns)) s7_wrong_type_arg_error(sc, "gtk_list_store_newv", 1, n_columns, "gint");
  types = s7_car(_p);
  if (!s7_is_c_pointer_of_type(types, GType__sym)) s7_wrong_type_arg_error(sc, "gtk_list_store_newv", 2, types, "GType*");
  return(lg_make_c_pointer_with_type(sc, GtkListStore__sym, gtk_list_store_newv((gint)s7_integer(n_columns), (GType*)s7_c_pointer(types))));
}

static s7_pointer lg_gtk_list_store_set_column_types(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_list_store_set_column_types "void gtk_list_store_set_column_types(GtkListStore* list_store, \
gint n_columns, GType* types)"
  s7_pointer _p;
  s7_pointer list_store, n_columns, types;
  _p = args;
  list_store = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(list_store, GtkListStore__sym)) s7_wrong_type_arg_error(sc, "gtk_list_store_set_column_types", 1, list_store, "GtkListStore*");
  n_columns = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(n_columns)) s7_wrong_type_arg_error(sc, "gtk_list_store_set_column_types", 2, n_columns, "gint");
  types = s7_car(_p);
  if (!s7_is_c_pointer_of_type(types, GType__sym)) s7_wrong_type_arg_error(sc, "gtk_list_store_set_column_types", 3, types, "GType*");
  gtk_list_store_set_column_types((GtkListStore*)s7_c_pointer(list_store), (gint)s7_integer(n_columns), (GType*)s7_c_pointer(types));
  return(lg_false);
}

static s7_pointer lg_gtk_list_store_set(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_list_store_set "void gtk_list_store_set(GtkListStore* list_store, GtkTreeIter* iter, \
etc values)"
  s7_pointer _p;
  s7_pointer list_store, iter, values;
  _p = args;
  list_store = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(list_store, GtkListStore__sym)) s7_wrong_type_arg_error(sc, "gtk_list_store_set", 1, list_store, "GtkListStore*");
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTreeIter__sym)) s7_wrong_type_arg_error(sc, "gtk_list_store_set", 2, iter, "GtkTreeIter*");
  values = s7_car(_p);
  if (!lg_is_list(values)) s7_wrong_type_arg_error(sc, "gtk_list_store_set", 3, values, "etc");
  {
    int etc_len = 0;
    GtkListStore* p_arg0;
    GtkTreeIter* p_arg1;
    if (s7_is_list(sc, values)) etc_len = s7_list_length(sc, values);
    if (etc_len < 2) s7_out_of_range_error(sc, "gtk_list_store_set", 2, values, "... list must have at least 2 entries");
    if (etc_len > 10) s7_out_of_range_error(sc, "gtk_list_store_set", 2, values, "... list too long (max len: 10)");
    if ((etc_len % 2) != 0) s7_out_of_range_error(sc, "gtk_list_store_set", 2, values, "... list len must be multiple of 2");
    p_arg0 = (GtkListStore*)s7_c_pointer(list_store);
    p_arg1 = (GtkTreeIter*)s7_c_pointer(iter);
    switch (etc_len)
      {
        case 2: gtk_list_store_set(p_arg0, p_arg1, s7_integer(s7_list_ref(sc, values, 0)), s7_string(s7_list_ref(sc, values, 1)), -1); break;
        case 4: gtk_list_store_set(p_arg0, p_arg1, s7_integer(s7_list_ref(sc, values, 0)), s7_string(s7_list_ref(sc, values, 1)), s7_integer(s7_list_ref(sc, values, 2)), s7_string(s7_list_ref(sc, values, 3)), -1); break;
        case 6: gtk_list_store_set(p_arg0, p_arg1, s7_integer(s7_list_ref(sc, values, 0)), s7_string(s7_list_ref(sc, values, 1)), s7_integer(s7_list_ref(sc, values, 2)), s7_string(s7_list_ref(sc, values, 3)), s7_integer(s7_list_ref(sc, values, 4)), s7_string(s7_list_ref(sc, values, 5)), -1); break;
        case 8: gtk_list_store_set(p_arg0, p_arg1, s7_integer(s7_list_ref(sc, values, 0)), s7_string(s7_list_ref(sc, values, 1)), s7_integer(s7_list_ref(sc, values, 2)), s7_string(s7_list_ref(sc, values, 3)), s7_integer(s7_list_ref(sc, values, 4)), s7_string(s7_list_ref(sc, values, 5)), s7_integer(s7_list_ref(sc, values, 6)), s7_string(s7_list_ref(sc, values, 7)), -1); break;
        case 10: gtk_list_store_set(p_arg0, p_arg1, s7_integer(s7_list_ref(sc, values, 0)), s7_string(s7_list_ref(sc, values, 1)), s7_integer(s7_list_ref(sc, values, 2)), s7_string(s7_list_ref(sc, values, 3)), s7_integer(s7_list_ref(sc, values, 4)), s7_string(s7_list_ref(sc, values, 5)), s7_integer(s7_list_ref(sc, values, 6)), s7_string(s7_list_ref(sc, values, 7)), s7_integer(s7_list_ref(sc, values, 8)), s7_string(s7_list_ref(sc, values, 9)), -1); break;
      }
    return(lg_false);
  }
}

static s7_pointer lg_gtk_list_store_insert(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_list_store_insert "void gtk_list_store_insert(GtkListStore* list_store, GtkTreeIter* iter, \
gint position)"
  s7_pointer _p;
  s7_pointer list_store, iter, position;
  _p = args;
  list_store = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(list_store, GtkListStore__sym)) s7_wrong_type_arg_error(sc, "gtk_list_store_insert", 1, list_store, "GtkListStore*");
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTreeIter__sym)) s7_wrong_type_arg_error(sc, "gtk_list_store_insert", 2, iter, "GtkTreeIter*");
  position = s7_car(_p);
  if (!s7_is_integer(position)) s7_wrong_type_arg_error(sc, "gtk_list_store_insert", 3, position, "gint");
  gtk_list_store_insert((GtkListStore*)s7_c_pointer(list_store), (GtkTreeIter*)s7_c_pointer(iter), (gint)s7_integer(position));
  return(lg_false);
}

static s7_pointer lg_gtk_list_store_insert_before(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_list_store_insert_before "void gtk_list_store_insert_before(GtkListStore* list_store, \
GtkTreeIter* iter, GtkTreeIter* sibling)"
  s7_pointer _p;
  s7_pointer list_store, iter, sibling;
  _p = args;
  list_store = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(list_store, GtkListStore__sym)) s7_wrong_type_arg_error(sc, "gtk_list_store_insert_before", 1, list_store, "GtkListStore*");
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTreeIter__sym)) s7_wrong_type_arg_error(sc, "gtk_list_store_insert_before", 2, iter, "GtkTreeIter*");
  sibling = s7_car(_p);
  if ((!s7_is_c_pointer_of_type(sibling, GtkTreeIter__sym)) && (sibling != lg_false)) s7_wrong_type_arg_error(sc, "gtk_list_store_insert_before", 3, sibling, "GtkTreeIter*");
  gtk_list_store_insert_before((GtkListStore*)s7_c_pointer(list_store), (GtkTreeIter*)s7_c_pointer(iter), (GtkTreeIter*)s7_c_pointer(sibling));
  return(lg_false);
}

static s7_pointer lg_gtk_list_store_insert_after(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_list_store_insert_after "void gtk_list_store_insert_after(GtkListStore* list_store, GtkTreeIter* iter, \
GtkTreeIter* sibling)"
  s7_pointer _p;
  s7_pointer list_store, iter, sibling;
  _p = args;
  list_store = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(list_store, GtkListStore__sym)) s7_wrong_type_arg_error(sc, "gtk_list_store_insert_after", 1, list_store, "GtkListStore*");
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTreeIter__sym)) s7_wrong_type_arg_error(sc, "gtk_list_store_insert_after", 2, iter, "GtkTreeIter*");
  sibling = s7_car(_p);
  if ((!s7_is_c_pointer_of_type(sibling, GtkTreeIter__sym)) && (sibling != lg_false)) s7_wrong_type_arg_error(sc, "gtk_list_store_insert_after", 3, sibling, "GtkTreeIter*");
  gtk_list_store_insert_after((GtkListStore*)s7_c_pointer(list_store), (GtkTreeIter*)s7_c_pointer(iter), (GtkTreeIter*)s7_c_pointer(sibling));
  return(lg_false);
}

static s7_pointer lg_gtk_list_store_prepend(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_list_store_prepend "void gtk_list_store_prepend(GtkListStore* list_store, GtkTreeIter* iter)"
  s7_pointer _p;
  s7_pointer list_store, iter;
  _p = args;
  list_store = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(list_store, GtkListStore__sym)) s7_wrong_type_arg_error(sc, "gtk_list_store_prepend", 1, list_store, "GtkListStore*");
  iter = s7_car(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTreeIter__sym)) s7_wrong_type_arg_error(sc, "gtk_list_store_prepend", 2, iter, "GtkTreeIter*");
  gtk_list_store_prepend((GtkListStore*)s7_c_pointer(list_store), (GtkTreeIter*)s7_c_pointer(iter));
  return(lg_false);
}

static s7_pointer lg_gtk_list_store_append(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_list_store_append "void gtk_list_store_append(GtkListStore* list_store, GtkTreeIter* iter)"
  s7_pointer _p;
  s7_pointer list_store, iter;
  _p = args;
  list_store = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(list_store, GtkListStore__sym)) s7_wrong_type_arg_error(sc, "gtk_list_store_append", 1, list_store, "GtkListStore*");
  iter = s7_car(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTreeIter__sym)) s7_wrong_type_arg_error(sc, "gtk_list_store_append", 2, iter, "GtkTreeIter*");
  gtk_list_store_append((GtkListStore*)s7_c_pointer(list_store), (GtkTreeIter*)s7_c_pointer(iter));
  return(lg_false);
}

static s7_pointer lg_gtk_list_store_clear(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_list_store_clear "void gtk_list_store_clear(GtkListStore* list_store)"
  s7_pointer list_store;
  list_store = s7_car(args);
  if (!s7_is_c_pointer_of_type(list_store, GtkListStore__sym)) s7_wrong_type_arg_error(sc, "gtk_list_store_clear", 1, list_store, "GtkListStore*");
  gtk_list_store_clear((GtkListStore*)s7_c_pointer(list_store));
  return(lg_false);
}

static s7_pointer lg_gtk_check_version(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_check_version "gchar* gtk_check_version(guint required_major, guint required_minor, guint required_micro)"
  s7_pointer _p;
  s7_pointer required_major, required_minor, required_micro;
  _p = args;
  required_major = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(required_major)) s7_wrong_type_arg_error(sc, "gtk_check_version", 1, required_major, "guint");
  required_minor = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(required_minor)) s7_wrong_type_arg_error(sc, "gtk_check_version", 2, required_minor, "guint");
  required_micro = s7_car(_p);
  if (!s7_is_integer(required_micro)) s7_wrong_type_arg_error(sc, "gtk_check_version", 3, required_micro, "guint");
    return(s7_make_string(sc, (gchar*)gtk_check_version((guint)s7_integer(required_major), (guint)s7_integer(required_minor), (guint)s7_integer(required_micro))));
}

static s7_pointer lg_gtk_disable_setlocale(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_disable_setlocale "void gtk_disable_setlocale( void)"
  gtk_disable_setlocale();
  return(lg_false);
}

static s7_pointer lg_gtk_get_default_language(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_get_default_language "PangoLanguage* gtk_get_default_language( void)"
  return(lg_make_c_pointer_with_type(sc, PangoLanguage__sym, gtk_get_default_language()));
}

static s7_pointer lg_gtk_notebook_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_new "GtkWidget* gtk_notebook_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_notebook_new()));
}

static s7_pointer lg_gtk_notebook_remove_page(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_remove_page "void gtk_notebook_remove_page(GtkNotebook* notebook, gint page_num)"
  s7_pointer _p;
  s7_pointer notebook, page_num;
  _p = args;
  notebook = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(notebook, GtkNotebook__sym)) s7_wrong_type_arg_error(sc, "gtk_notebook_remove_page", 1, notebook, "GtkNotebook*");
  page_num = s7_car(_p);
  if (!s7_is_integer(page_num)) s7_wrong_type_arg_error(sc, "gtk_notebook_remove_page", 2, page_num, "gint");
  gtk_notebook_remove_page((GtkNotebook*)s7_c_pointer(notebook), (gint)s7_integer(page_num));
  return(lg_false);
}

static s7_pointer lg_gtk_notebook_get_current_page(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_get_current_page "gint gtk_notebook_get_current_page(GtkNotebook* notebook)"
  s7_pointer notebook;
  notebook = s7_car(args);
  if (!s7_is_c_pointer_of_type(notebook, GtkNotebook__sym)) s7_wrong_type_arg_error(sc, "gtk_notebook_get_current_page", 1, notebook, "GtkNotebook*");
  return(s7_make_integer(sc, gtk_notebook_get_current_page((GtkNotebook*)s7_c_pointer(notebook))));
}

static s7_pointer lg_gtk_notebook_get_nth_page(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_get_nth_page "GtkWidget* gtk_notebook_get_nth_page(GtkNotebook* notebook, gint page_num)"
  s7_pointer _p;
  s7_pointer notebook, page_num;
  _p = args;
  notebook = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(notebook, GtkNotebook__sym)) s7_wrong_type_arg_error(sc, "gtk_notebook_get_nth_page", 1, notebook, "GtkNotebook*");
  page_num = s7_car(_p);
  if (!s7_is_integer(page_num)) s7_wrong_type_arg_error(sc, "gtk_notebook_get_nth_page", 2, page_num, "gint");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_notebook_get_nth_page((GtkNotebook*)s7_c_pointer(notebook), (gint)s7_integer(page_num))));
}

static s7_pointer lg_gtk_notebook_page_num(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_page_num "gint gtk_notebook_page_num(GtkNotebook* notebook, GtkWidget* child)"
  s7_pointer _p;
  s7_pointer notebook, child;
  _p = args;
  notebook = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(notebook, GtkNotebook__sym)) s7_wrong_type_arg_error(sc, "gtk_notebook_page_num", 1, notebook, "GtkNotebook*");
  child = s7_car(_p);
  if (!s7_is_c_pointer_of_type(child, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_notebook_page_num", 2, child, "GtkWidget*");
  return(s7_make_integer(sc, gtk_notebook_page_num((GtkNotebook*)s7_c_pointer(notebook), (GtkWidget*)s7_c_pointer(child))));
}

static s7_pointer lg_gtk_notebook_set_current_page(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_set_current_page "void gtk_notebook_set_current_page(GtkNotebook* notebook, \
gint page_num)"
  s7_pointer _p;
  s7_pointer notebook, page_num;
  _p = args;
  notebook = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(notebook, GtkNotebook__sym)) s7_wrong_type_arg_error(sc, "gtk_notebook_set_current_page", 1, notebook, "GtkNotebook*");
  page_num = s7_car(_p);
  if (!s7_is_integer(page_num)) s7_wrong_type_arg_error(sc, "gtk_notebook_set_current_page", 2, page_num, "gint");
  gtk_notebook_set_current_page((GtkNotebook*)s7_c_pointer(notebook), (gint)s7_integer(page_num));
  return(lg_false);
}

static s7_pointer lg_gtk_notebook_next_page(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_next_page "void gtk_notebook_next_page(GtkNotebook* notebook)"
  s7_pointer notebook;
  notebook = s7_car(args);
  if (!s7_is_c_pointer_of_type(notebook, GtkNotebook__sym)) s7_wrong_type_arg_error(sc, "gtk_notebook_next_page", 1, notebook, "GtkNotebook*");
  gtk_notebook_next_page((GtkNotebook*)s7_c_pointer(notebook));
  return(lg_false);
}

static s7_pointer lg_gtk_notebook_prev_page(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_prev_page "void gtk_notebook_prev_page(GtkNotebook* notebook)"
  s7_pointer notebook;
  notebook = s7_car(args);
  if (!s7_is_c_pointer_of_type(notebook, GtkNotebook__sym)) s7_wrong_type_arg_error(sc, "gtk_notebook_prev_page", 1, notebook, "GtkNotebook*");
  gtk_notebook_prev_page((GtkNotebook*)s7_c_pointer(notebook));
  return(lg_false);
}

static s7_pointer lg_gtk_notebook_set_show_border(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_set_show_border "void gtk_notebook_set_show_border(GtkNotebook* notebook, gboolean show_border)"
  s7_pointer _p;
  s7_pointer notebook, show_border;
  _p = args;
  notebook = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(notebook, GtkNotebook__sym)) s7_wrong_type_arg_error(sc, "gtk_notebook_set_show_border", 1, notebook, "GtkNotebook*");
  show_border = s7_car(_p);
  if (!s7_is_boolean(show_border)) s7_wrong_type_arg_error(sc, "gtk_notebook_set_show_border", 2, show_border, "gboolean");
  gtk_notebook_set_show_border((GtkNotebook*)s7_c_pointer(notebook), (gboolean)lg_boolean(show_border));
  return(lg_false);
}

static s7_pointer lg_gtk_notebook_get_show_border(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_get_show_border "gboolean gtk_notebook_get_show_border(GtkNotebook* notebook)"
  s7_pointer notebook;
  notebook = s7_car(args);
  if (!s7_is_c_pointer_of_type(notebook, GtkNotebook__sym)) s7_wrong_type_arg_error(sc, "gtk_notebook_get_show_border", 1, notebook, "GtkNotebook*");
  return(s7_make_boolean(sc, gtk_notebook_get_show_border((GtkNotebook*)s7_c_pointer(notebook))));
}

static s7_pointer lg_gtk_notebook_set_show_tabs(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_set_show_tabs "void gtk_notebook_set_show_tabs(GtkNotebook* notebook, gboolean show_tabs)"
  s7_pointer _p;
  s7_pointer notebook, show_tabs;
  _p = args;
  notebook = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(notebook, GtkNotebook__sym)) s7_wrong_type_arg_error(sc, "gtk_notebook_set_show_tabs", 1, notebook, "GtkNotebook*");
  show_tabs = s7_car(_p);
  if (!s7_is_boolean(show_tabs)) s7_wrong_type_arg_error(sc, "gtk_notebook_set_show_tabs", 2, show_tabs, "gboolean");
  gtk_notebook_set_show_tabs((GtkNotebook*)s7_c_pointer(notebook), (gboolean)lg_boolean(show_tabs));
  return(lg_false);
}

static s7_pointer lg_gtk_notebook_get_show_tabs(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_get_show_tabs "gboolean gtk_notebook_get_show_tabs(GtkNotebook* notebook)"
  s7_pointer notebook;
  notebook = s7_car(args);
  if (!s7_is_c_pointer_of_type(notebook, GtkNotebook__sym)) s7_wrong_type_arg_error(sc, "gtk_notebook_get_show_tabs", 1, notebook, "GtkNotebook*");
  return(s7_make_boolean(sc, gtk_notebook_get_show_tabs((GtkNotebook*)s7_c_pointer(notebook))));
}

static s7_pointer lg_gtk_notebook_set_tab_pos(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_set_tab_pos "void gtk_notebook_set_tab_pos(GtkNotebook* notebook, GtkPositionType pos)"
  s7_pointer _p;
  s7_pointer notebook, pos;
  _p = args;
  notebook = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(notebook, GtkNotebook__sym)) s7_wrong_type_arg_error(sc, "gtk_notebook_set_tab_pos", 1, notebook, "GtkNotebook*");
  pos = s7_car(_p);
  if (!s7_is_integer(pos)) s7_wrong_type_arg_error(sc, "gtk_notebook_set_tab_pos", 2, pos, "GtkPositionType");
  gtk_notebook_set_tab_pos((GtkNotebook*)s7_c_pointer(notebook), (GtkPositionType)s7_integer(pos));
  return(lg_false);
}

static s7_pointer lg_gtk_notebook_get_tab_pos(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_get_tab_pos "GtkPositionType gtk_notebook_get_tab_pos(GtkNotebook* notebook)"
  s7_pointer notebook;
  notebook = s7_car(args);
  if (!s7_is_c_pointer_of_type(notebook, GtkNotebook__sym)) s7_wrong_type_arg_error(sc, "gtk_notebook_get_tab_pos", 1, notebook, "GtkNotebook*");
  return(s7_make_integer(sc, gtk_notebook_get_tab_pos((GtkNotebook*)s7_c_pointer(notebook))));
}

static s7_pointer lg_gtk_notebook_set_scrollable(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_set_scrollable "void gtk_notebook_set_scrollable(GtkNotebook* notebook, gboolean scrollable)"
  s7_pointer _p;
  s7_pointer notebook, scrollable;
  _p = args;
  notebook = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(notebook, GtkNotebook__sym)) s7_wrong_type_arg_error(sc, "gtk_notebook_set_scrollable", 1, notebook, "GtkNotebook*");
  scrollable = s7_car(_p);
  if (!s7_is_boolean(scrollable)) s7_wrong_type_arg_error(sc, "gtk_notebook_set_scrollable", 2, scrollable, "gboolean");
  gtk_notebook_set_scrollable((GtkNotebook*)s7_c_pointer(notebook), (gboolean)lg_boolean(scrollable));
  return(lg_false);
}

static s7_pointer lg_gtk_notebook_get_scrollable(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_get_scrollable "gboolean gtk_notebook_get_scrollable(GtkNotebook* notebook)"
  s7_pointer notebook;
  notebook = s7_car(args);
  if (!s7_is_c_pointer_of_type(notebook, GtkNotebook__sym)) s7_wrong_type_arg_error(sc, "gtk_notebook_get_scrollable", 1, notebook, "GtkNotebook*");
  return(s7_make_boolean(sc, gtk_notebook_get_scrollable((GtkNotebook*)s7_c_pointer(notebook))));
}

static s7_pointer lg_gtk_notebook_popup_enable(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_popup_enable "void gtk_notebook_popup_enable(GtkNotebook* notebook)"
  s7_pointer notebook;
  notebook = s7_car(args);
  if (!s7_is_c_pointer_of_type(notebook, GtkNotebook__sym)) s7_wrong_type_arg_error(sc, "gtk_notebook_popup_enable", 1, notebook, "GtkNotebook*");
  gtk_notebook_popup_enable((GtkNotebook*)s7_c_pointer(notebook));
  return(lg_false);
}

static s7_pointer lg_gtk_notebook_popup_disable(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_popup_disable "void gtk_notebook_popup_disable(GtkNotebook* notebook)"
  s7_pointer notebook;
  notebook = s7_car(args);
  if (!s7_is_c_pointer_of_type(notebook, GtkNotebook__sym)) s7_wrong_type_arg_error(sc, "gtk_notebook_popup_disable", 1, notebook, "GtkNotebook*");
  gtk_notebook_popup_disable((GtkNotebook*)s7_c_pointer(notebook));
  return(lg_false);
}

static s7_pointer lg_gtk_notebook_get_tab_label(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_get_tab_label "GtkWidget* gtk_notebook_get_tab_label(GtkNotebook* notebook, \
GtkWidget* child)"
  s7_pointer _p;
  s7_pointer notebook, child;
  _p = args;
  notebook = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(notebook, GtkNotebook__sym)) s7_wrong_type_arg_error(sc, "gtk_notebook_get_tab_label", 1, notebook, "GtkNotebook*");
  child = s7_car(_p);
  if (!s7_is_c_pointer_of_type(child, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_notebook_get_tab_label", 2, child, "GtkWidget*");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_notebook_get_tab_label((GtkNotebook*)s7_c_pointer(notebook), (GtkWidget*)s7_c_pointer(child))));
}

static s7_pointer lg_gtk_notebook_set_tab_label(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_set_tab_label "void gtk_notebook_set_tab_label(GtkNotebook* notebook, GtkWidget* child, \
GtkWidget* tab_label)"
  s7_pointer _p;
  s7_pointer notebook, child, tab_label;
  _p = args;
  notebook = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(notebook, GtkNotebook__sym)) s7_wrong_type_arg_error(sc, "gtk_notebook_set_tab_label", 1, notebook, "GtkNotebook*");
  child = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(child, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_notebook_set_tab_label", 2, child, "GtkWidget*");
  tab_label = s7_car(_p);
  if ((!s7_is_c_pointer_of_type(tab_label, GtkWidget__sym)) && (tab_label != lg_false)) s7_wrong_type_arg_error(sc, "gtk_notebook_set_tab_label", 3, tab_label, "GtkWidget*");
  gtk_notebook_set_tab_label((GtkNotebook*)s7_c_pointer(notebook), (GtkWidget*)s7_c_pointer(child), (GtkWidget*)s7_c_pointer(tab_label));
  return(lg_false);
}

static s7_pointer lg_gtk_notebook_set_tab_label_text(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_set_tab_label_text "void gtk_notebook_set_tab_label_text(GtkNotebook* notebook, \
GtkWidget* child, gchar* tab_text)"
  s7_pointer _p;
  s7_pointer notebook, child, tab_text;
  _p = args;
  notebook = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(notebook, GtkNotebook__sym)) s7_wrong_type_arg_error(sc, "gtk_notebook_set_tab_label_text", 1, notebook, "GtkNotebook*");
  child = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(child, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_notebook_set_tab_label_text", 2, child, "GtkWidget*");
  tab_text = s7_car(_p);
  if (!s7_is_string(tab_text)) s7_wrong_type_arg_error(sc, "gtk_notebook_set_tab_label_text", 3, tab_text, "gchar*");
  gtk_notebook_set_tab_label_text((GtkNotebook*)s7_c_pointer(notebook), (GtkWidget*)s7_c_pointer(child), (gchar*)s7_string(tab_text));
  return(lg_false);
}

static s7_pointer lg_gtk_notebook_get_tab_label_text(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_get_tab_label_text "gchar* gtk_notebook_get_tab_label_text(GtkNotebook* notebook, \
GtkWidget* child)"
  s7_pointer _p;
  s7_pointer notebook, child;
  _p = args;
  notebook = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(notebook, GtkNotebook__sym)) s7_wrong_type_arg_error(sc, "gtk_notebook_get_tab_label_text", 1, notebook, "GtkNotebook*");
  child = s7_car(_p);
  if (!s7_is_c_pointer_of_type(child, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_notebook_get_tab_label_text", 2, child, "GtkWidget*");
  return(s7_make_string(sc, gtk_notebook_get_tab_label_text((GtkNotebook*)s7_c_pointer(notebook), (GtkWidget*)s7_c_pointer(child))));
}

static s7_pointer lg_gtk_notebook_get_menu_label(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_get_menu_label "GtkWidget* gtk_notebook_get_menu_label(GtkNotebook* notebook, \
GtkWidget* child)"
  s7_pointer _p;
  s7_pointer notebook, child;
  _p = args;
  notebook = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(notebook, GtkNotebook__sym)) s7_wrong_type_arg_error(sc, "gtk_notebook_get_menu_label", 1, notebook, "GtkNotebook*");
  child = s7_car(_p);
  if (!s7_is_c_pointer_of_type(child, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_notebook_get_menu_label", 2, child, "GtkWidget*");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_notebook_get_menu_label((GtkNotebook*)s7_c_pointer(notebook), (GtkWidget*)s7_c_pointer(child))));
}

static s7_pointer lg_gtk_notebook_set_menu_label(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_set_menu_label "void gtk_notebook_set_menu_label(GtkNotebook* notebook, GtkWidget* child, \
GtkWidget* menu_label)"
  s7_pointer _p;
  s7_pointer notebook, child, menu_label;
  _p = args;
  notebook = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(notebook, GtkNotebook__sym)) s7_wrong_type_arg_error(sc, "gtk_notebook_set_menu_label", 1, notebook, "GtkNotebook*");
  child = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(child, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_notebook_set_menu_label", 2, child, "GtkWidget*");
  menu_label = s7_car(_p);
  if (!s7_is_c_pointer_of_type(menu_label, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_notebook_set_menu_label", 3, menu_label, "GtkWidget*");
  gtk_notebook_set_menu_label((GtkNotebook*)s7_c_pointer(notebook), (GtkWidget*)s7_c_pointer(child), (GtkWidget*)s7_c_pointer(menu_label));
  return(lg_false);
}

static s7_pointer lg_gtk_notebook_set_menu_label_text(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_set_menu_label_text "void gtk_notebook_set_menu_label_text(GtkNotebook* notebook, \
GtkWidget* child, gchar* menu_text)"
  s7_pointer _p;
  s7_pointer notebook, child, menu_text;
  _p = args;
  notebook = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(notebook, GtkNotebook__sym)) s7_wrong_type_arg_error(sc, "gtk_notebook_set_menu_label_text", 1, notebook, "GtkNotebook*");
  child = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(child, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_notebook_set_menu_label_text", 2, child, "GtkWidget*");
  menu_text = s7_car(_p);
  if (!s7_is_string(menu_text)) s7_wrong_type_arg_error(sc, "gtk_notebook_set_menu_label_text", 3, menu_text, "gchar*");
  gtk_notebook_set_menu_label_text((GtkNotebook*)s7_c_pointer(notebook), (GtkWidget*)s7_c_pointer(child), (gchar*)s7_string(menu_text));
  return(lg_false);
}

static s7_pointer lg_gtk_notebook_get_menu_label_text(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_get_menu_label_text "gchar* gtk_notebook_get_menu_label_text(GtkNotebook* notebook, \
GtkWidget* child)"
  s7_pointer _p;
  s7_pointer notebook, child;
  _p = args;
  notebook = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(notebook, GtkNotebook__sym)) s7_wrong_type_arg_error(sc, "gtk_notebook_get_menu_label_text", 1, notebook, "GtkNotebook*");
  child = s7_car(_p);
  if (!s7_is_c_pointer_of_type(child, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_notebook_get_menu_label_text", 2, child, "GtkWidget*");
  return(s7_make_string(sc, gtk_notebook_get_menu_label_text((GtkNotebook*)s7_c_pointer(notebook), (GtkWidget*)s7_c_pointer(child))));
}

static s7_pointer lg_gtk_notebook_reorder_child(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_reorder_child "void gtk_notebook_reorder_child(GtkNotebook* notebook, GtkWidget* child, \
gint position)"
  s7_pointer _p;
  s7_pointer notebook, child, position;
  _p = args;
  notebook = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(notebook, GtkNotebook__sym)) s7_wrong_type_arg_error(sc, "gtk_notebook_reorder_child", 1, notebook, "GtkNotebook*");
  child = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(child, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_notebook_reorder_child", 2, child, "GtkWidget*");
  position = s7_car(_p);
  if (!s7_is_integer(position)) s7_wrong_type_arg_error(sc, "gtk_notebook_reorder_child", 3, position, "gint");
  gtk_notebook_reorder_child((GtkNotebook*)s7_c_pointer(notebook), (GtkWidget*)s7_c_pointer(child), (gint)s7_integer(position));
  return(lg_false);
}

static s7_pointer lg_gtk_notebook_append_page(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_append_page "gint gtk_notebook_append_page(GtkNotebook* notebook, GtkWidget* child, \
GtkWidget* tab_label)"
  s7_pointer _p;
  s7_pointer notebook, child, tab_label;
  _p = args;
  notebook = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(notebook, GtkNotebook__sym)) s7_wrong_type_arg_error(sc, "gtk_notebook_append_page", 1, notebook, "GtkNotebook*");
  child = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(child, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_notebook_append_page", 2, child, "GtkWidget*");
  tab_label = s7_car(_p);
  if ((!s7_is_c_pointer_of_type(tab_label, GtkWidget__sym)) && (tab_label != lg_false)) s7_wrong_type_arg_error(sc, "gtk_notebook_append_page", 3, tab_label, "GtkWidget*");
  return(s7_make_integer(sc, gtk_notebook_append_page((GtkNotebook*)s7_c_pointer(notebook), (GtkWidget*)s7_c_pointer(child), (GtkWidget*)s7_c_pointer(tab_label))));
}

static s7_pointer lg_gtk_notebook_append_page_menu(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_append_page_menu "gint gtk_notebook_append_page_menu(GtkNotebook* notebook, \
GtkWidget* child, GtkWidget* tab_label, GtkWidget* menu_label)"
  s7_pointer _p;
  s7_pointer notebook, child, tab_label, menu_label;
  _p = args;
  notebook = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(notebook, GtkNotebook__sym)) s7_wrong_type_arg_error(sc, "gtk_notebook_append_page_menu", 1, notebook, "GtkNotebook*");
  child = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(child, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_notebook_append_page_menu", 2, child, "GtkWidget*");
  tab_label = s7_car(_p); _p = s7_cdr(_p);
  if ((!s7_is_c_pointer_of_type(tab_label, GtkWidget__sym)) && (tab_label != lg_false)) s7_wrong_type_arg_error(sc, "gtk_notebook_append_page_menu", 3, tab_label, "GtkWidget*");
  menu_label = s7_car(_p);
  if ((!s7_is_c_pointer_of_type(menu_label, GtkWidget__sym)) && (menu_label != lg_false)) s7_wrong_type_arg_error(sc, "gtk_notebook_append_page_menu", 4, menu_label, "GtkWidget*");
  return(s7_make_integer(sc, gtk_notebook_append_page_menu((GtkNotebook*)s7_c_pointer(notebook), (GtkWidget*)s7_c_pointer(child), (GtkWidget*)s7_c_pointer(tab_label), (GtkWidget*)s7_c_pointer(menu_label))));
}

static s7_pointer lg_gtk_notebook_prepend_page(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_prepend_page "gint gtk_notebook_prepend_page(GtkNotebook* notebook, GtkWidget* child, \
GtkWidget* tab_label)"
  s7_pointer _p;
  s7_pointer notebook, child, tab_label;
  _p = args;
  notebook = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(notebook, GtkNotebook__sym)) s7_wrong_type_arg_error(sc, "gtk_notebook_prepend_page", 1, notebook, "GtkNotebook*");
  child = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(child, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_notebook_prepend_page", 2, child, "GtkWidget*");
  tab_label = s7_car(_p);
  if ((!s7_is_c_pointer_of_type(tab_label, GtkWidget__sym)) && (tab_label != lg_false)) s7_wrong_type_arg_error(sc, "gtk_notebook_prepend_page", 3, tab_label, "GtkWidget*");
  return(s7_make_integer(sc, gtk_notebook_prepend_page((GtkNotebook*)s7_c_pointer(notebook), (GtkWidget*)s7_c_pointer(child), (GtkWidget*)s7_c_pointer(tab_label))));
}

static s7_pointer lg_gtk_notebook_prepend_page_menu(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_prepend_page_menu "gint gtk_notebook_prepend_page_menu(GtkNotebook* notebook, \
GtkWidget* child, GtkWidget* tab_label, GtkWidget* menu_label)"
  s7_pointer _p;
  s7_pointer notebook, child, tab_label, menu_label;
  _p = args;
  notebook = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(notebook, GtkNotebook__sym)) s7_wrong_type_arg_error(sc, "gtk_notebook_prepend_page_menu", 1, notebook, "GtkNotebook*");
  child = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(child, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_notebook_prepend_page_menu", 2, child, "GtkWidget*");
  tab_label = s7_car(_p); _p = s7_cdr(_p);
  if ((!s7_is_c_pointer_of_type(tab_label, GtkWidget__sym)) && (tab_label != lg_false)) s7_wrong_type_arg_error(sc, "gtk_notebook_prepend_page_menu", 3, tab_label, "GtkWidget*");
  menu_label = s7_car(_p);
  if ((!s7_is_c_pointer_of_type(menu_label, GtkWidget__sym)) && (menu_label != lg_false)) s7_wrong_type_arg_error(sc, "gtk_notebook_prepend_page_menu", 4, menu_label, "GtkWidget*");
  return(s7_make_integer(sc, gtk_notebook_prepend_page_menu((GtkNotebook*)s7_c_pointer(notebook), (GtkWidget*)s7_c_pointer(child), (GtkWidget*)s7_c_pointer(tab_label), (GtkWidget*)s7_c_pointer(menu_label))));
}

static s7_pointer lg_gtk_notebook_insert_page(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_insert_page "gint gtk_notebook_insert_page(GtkNotebook* notebook, GtkWidget* child, \
GtkWidget* tab_label, gint position)"
  s7_pointer _p;
  s7_pointer notebook, child, tab_label, position;
  _p = args;
  notebook = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(notebook, GtkNotebook__sym)) s7_wrong_type_arg_error(sc, "gtk_notebook_insert_page", 1, notebook, "GtkNotebook*");
  child = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(child, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_notebook_insert_page", 2, child, "GtkWidget*");
  tab_label = s7_car(_p); _p = s7_cdr(_p);
  if ((!s7_is_c_pointer_of_type(tab_label, GtkWidget__sym)) && (tab_label != lg_false)) s7_wrong_type_arg_error(sc, "gtk_notebook_insert_page", 3, tab_label, "GtkWidget*");
  position = s7_car(_p);
  if (!s7_is_integer(position)) s7_wrong_type_arg_error(sc, "gtk_notebook_insert_page", 4, position, "gint");
  return(s7_make_integer(sc, gtk_notebook_insert_page((GtkNotebook*)s7_c_pointer(notebook), (GtkWidget*)s7_c_pointer(child), (GtkWidget*)s7_c_pointer(tab_label), (gint)s7_integer(position))));
}

static s7_pointer lg_gtk_notebook_insert_page_menu(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_insert_page_menu "gint gtk_notebook_insert_page_menu(GtkNotebook* notebook, \
GtkWidget* child, GtkWidget* tab_label, GtkWidget* menu_label, gint position)"
  s7_pointer _p;
  s7_pointer notebook, child, tab_label, menu_label, position;
  _p = args;
  notebook = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(notebook, GtkNotebook__sym)) s7_wrong_type_arg_error(sc, "gtk_notebook_insert_page_menu", 1, notebook, "GtkNotebook*");
  child = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(child, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_notebook_insert_page_menu", 2, child, "GtkWidget*");
  tab_label = s7_car(_p); _p = s7_cdr(_p);
  if ((!s7_is_c_pointer_of_type(tab_label, GtkWidget__sym)) && (tab_label != lg_false)) s7_wrong_type_arg_error(sc, "gtk_notebook_insert_page_menu", 3, tab_label, "GtkWidget*");
  menu_label = s7_car(_p); _p = s7_cdr(_p);
  if ((!s7_is_c_pointer_of_type(menu_label, GtkWidget__sym)) && (menu_label != lg_false)) s7_wrong_type_arg_error(sc, "gtk_notebook_insert_page_menu", 4, menu_label, "GtkWidget*");
  position = s7_car(_p);
  if (!s7_is_integer(position)) s7_wrong_type_arg_error(sc, "gtk_notebook_insert_page_menu", 5, position, "gint");
  return(s7_make_integer(sc, gtk_notebook_insert_page_menu((GtkNotebook*)s7_c_pointer(notebook), (GtkWidget*)s7_c_pointer(child), (GtkWidget*)s7_c_pointer(tab_label), (GtkWidget*)s7_c_pointer(menu_label), (gint)s7_integer(position))));
}

static s7_pointer lg_gtk_progress_bar_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_progress_bar_new "GtkWidget* gtk_progress_bar_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_progress_bar_new()));
}

static s7_pointer lg_gtk_progress_bar_pulse(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_progress_bar_pulse "void gtk_progress_bar_pulse(GtkProgressBar* pbar)"
  s7_pointer pbar;
  pbar = s7_car(args);
  if (!s7_is_c_pointer_of_type(pbar, GtkProgressBar__sym)) s7_wrong_type_arg_error(sc, "gtk_progress_bar_pulse", 1, pbar, "GtkProgressBar*");
  gtk_progress_bar_pulse((GtkProgressBar*)s7_c_pointer(pbar));
  return(lg_false);
}

static s7_pointer lg_gtk_progress_bar_set_text(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_progress_bar_set_text "void gtk_progress_bar_set_text(GtkProgressBar* pbar, gchar* text)"
  s7_pointer _p;
  s7_pointer pbar, text;
  _p = args;
  pbar = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(pbar, GtkProgressBar__sym)) s7_wrong_type_arg_error(sc, "gtk_progress_bar_set_text", 1, pbar, "GtkProgressBar*");
  text = s7_car(_p);
  if (!s7_is_string(text)) s7_wrong_type_arg_error(sc, "gtk_progress_bar_set_text", 2, text, "gchar*");
  gtk_progress_bar_set_text((GtkProgressBar*)s7_c_pointer(pbar), (gchar*)s7_string(text));
  return(lg_false);
}

static s7_pointer lg_gtk_progress_bar_set_fraction(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_progress_bar_set_fraction "void gtk_progress_bar_set_fraction(GtkProgressBar* pbar, gdouble fraction)"
  s7_pointer _p;
  s7_pointer pbar, fraction;
  _p = args;
  pbar = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(pbar, GtkProgressBar__sym)) s7_wrong_type_arg_error(sc, "gtk_progress_bar_set_fraction", 1, pbar, "GtkProgressBar*");
  fraction = s7_car(_p);
  if (!s7_is_real(fraction)) s7_wrong_type_arg_error(sc, "gtk_progress_bar_set_fraction", 2, fraction, "gdouble");
  gtk_progress_bar_set_fraction((GtkProgressBar*)s7_c_pointer(pbar), (gdouble)s7_real(fraction));
  return(lg_false);
}

static s7_pointer lg_gtk_progress_bar_set_pulse_step(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_progress_bar_set_pulse_step "void gtk_progress_bar_set_pulse_step(GtkProgressBar* pbar, \
gdouble fraction)"
  s7_pointer _p;
  s7_pointer pbar, fraction;
  _p = args;
  pbar = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(pbar, GtkProgressBar__sym)) s7_wrong_type_arg_error(sc, "gtk_progress_bar_set_pulse_step", 1, pbar, "GtkProgressBar*");
  fraction = s7_car(_p);
  if (!s7_is_real(fraction)) s7_wrong_type_arg_error(sc, "gtk_progress_bar_set_pulse_step", 2, fraction, "gdouble");
  gtk_progress_bar_set_pulse_step((GtkProgressBar*)s7_c_pointer(pbar), (gdouble)s7_real(fraction));
  return(lg_false);
}

static s7_pointer lg_gtk_progress_bar_get_text(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_progress_bar_get_text "gchar* gtk_progress_bar_get_text(GtkProgressBar* pbar)"
  s7_pointer pbar;
  pbar = s7_car(args);
  if (!s7_is_c_pointer_of_type(pbar, GtkProgressBar__sym)) s7_wrong_type_arg_error(sc, "gtk_progress_bar_get_text", 1, pbar, "GtkProgressBar*");
  return(s7_make_string(sc, gtk_progress_bar_get_text((GtkProgressBar*)s7_c_pointer(pbar))));
}

static s7_pointer lg_gtk_progress_bar_get_fraction(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_progress_bar_get_fraction "gdouble gtk_progress_bar_get_fraction(GtkProgressBar* pbar)"
  s7_pointer pbar;
  pbar = s7_car(args);
  if (!s7_is_c_pointer_of_type(pbar, GtkProgressBar__sym)) s7_wrong_type_arg_error(sc, "gtk_progress_bar_get_fraction", 1, pbar, "GtkProgressBar*");
  return(s7_make_real(sc, gtk_progress_bar_get_fraction((GtkProgressBar*)s7_c_pointer(pbar))));
}

static s7_pointer lg_gtk_progress_bar_get_pulse_step(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_progress_bar_get_pulse_step "gdouble gtk_progress_bar_get_pulse_step(GtkProgressBar* pbar)"
  s7_pointer pbar;
  pbar = s7_car(args);
  if (!s7_is_c_pointer_of_type(pbar, GtkProgressBar__sym)) s7_wrong_type_arg_error(sc, "gtk_progress_bar_get_pulse_step", 1, pbar, "GtkProgressBar*");
  return(s7_make_real(sc, gtk_progress_bar_get_pulse_step((GtkProgressBar*)s7_c_pointer(pbar))));
}

static s7_pointer lg_gtk_radio_button_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_radio_button_new "GtkWidget* gtk_radio_button_new(GSList* group)"
  s7_pointer group;
  group = s7_car(args);
  if ((!s7_is_c_pointer_of_type(group, GSList__sym)) && (group != lg_false)) s7_wrong_type_arg_error(sc, "gtk_radio_button_new", 1, group, "GSList*");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_radio_button_new((GSList*)s7_c_pointer(group))));
}

static s7_pointer lg_gtk_radio_button_new_from_widget(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_radio_button_new_from_widget "GtkWidget* gtk_radio_button_new_from_widget(GtkRadioButton* group)"
  s7_pointer group;
  group = s7_car(args);
  if (!s7_is_c_pointer_of_type(group, GtkRadioButton__sym)) s7_wrong_type_arg_error(sc, "gtk_radio_button_new_from_widget", 1, group, "GtkRadioButton*");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_radio_button_new_from_widget((GtkRadioButton*)s7_c_pointer(group))));
}

static s7_pointer lg_gtk_radio_button_new_with_label(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_radio_button_new_with_label "GtkWidget* gtk_radio_button_new_with_label(GSList* group, \
gchar* label)"
  s7_pointer _p;
  s7_pointer group, label;
  _p = args;
  group = s7_car(_p); _p = s7_cdr(_p);
  if ((!s7_is_c_pointer_of_type(group, GSList__sym)) && (group != lg_false)) s7_wrong_type_arg_error(sc, "gtk_radio_button_new_with_label", 1, group, "GSList*");
  label = s7_car(_p);
  if (!s7_is_string(label)) s7_wrong_type_arg_error(sc, "gtk_radio_button_new_with_label", 2, label, "gchar*");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_radio_button_new_with_label((GSList*)s7_c_pointer(group), (gchar*)s7_string(label))));
}

static s7_pointer lg_gtk_radio_button_new_with_label_from_widget(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_radio_button_new_with_label_from_widget "GtkWidget* gtk_radio_button_new_with_label_from_widget(GtkRadioButton* group, \
gchar* label)"
  s7_pointer _p;
  s7_pointer group, label;
  _p = args;
  group = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(group, GtkRadioButton__sym)) s7_wrong_type_arg_error(sc, "gtk_radio_button_new_with_label_from_widget", 1, group, "GtkRadioButton*");
  label = s7_car(_p);
  if (!s7_is_string(label)) s7_wrong_type_arg_error(sc, "gtk_radio_button_new_with_label_from_widget", 2, label, "gchar*");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_radio_button_new_with_label_from_widget((GtkRadioButton*)s7_c_pointer(group), (gchar*)s7_string(label))));
}

static s7_pointer lg_gtk_radio_button_new_with_mnemonic(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_radio_button_new_with_mnemonic "GtkWidget* gtk_radio_button_new_with_mnemonic(GSList* group, \
gchar* label)"
  s7_pointer _p;
  s7_pointer group, label;
  _p = args;
  group = s7_car(_p); _p = s7_cdr(_p);
  if ((!s7_is_c_pointer_of_type(group, GSList__sym)) && (group != lg_false)) s7_wrong_type_arg_error(sc, "gtk_radio_button_new_with_mnemonic", 1, group, "GSList*");
  label = s7_car(_p);
  if (!s7_is_string(label)) s7_wrong_type_arg_error(sc, "gtk_radio_button_new_with_mnemonic", 2, label, "gchar*");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_radio_button_new_with_mnemonic((GSList*)s7_c_pointer(group), (gchar*)s7_string(label))));
}

static s7_pointer lg_gtk_radio_button_new_with_mnemonic_from_widget(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_radio_button_new_with_mnemonic_from_widget "GtkWidget* gtk_radio_button_new_with_mnemonic_from_widget(GtkRadioButton* group, \
gchar* label)"
  s7_pointer _p;
  s7_pointer group, label;
  _p = args;
  group = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(group, GtkRadioButton__sym)) s7_wrong_type_arg_error(sc, "gtk_radio_button_new_with_mnemonic_from_widget", 1, group, "GtkRadioButton*");
  label = s7_car(_p);
  if (!s7_is_string(label)) s7_wrong_type_arg_error(sc, "gtk_radio_button_new_with_mnemonic_from_widget", 2, label, "gchar*");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_radio_button_new_with_mnemonic_from_widget((GtkRadioButton*)s7_c_pointer(group), (gchar*)s7_string(label))));
}

static s7_pointer lg_gtk_radio_button_get_group(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_radio_button_get_group "GSList* gtk_radio_button_get_group(GtkRadioButton* radio_button)"
  s7_pointer radio_button;
  radio_button = s7_car(args);
  if (!s7_is_c_pointer_of_type(radio_button, GtkRadioButton__sym)) s7_wrong_type_arg_error(sc, "gtk_radio_button_get_group", 1, radio_button, "GtkRadioButton*");
  return(lg_make_c_pointer_with_type(sc, GSList__sym, gtk_radio_button_get_group((GtkRadioButton*)s7_c_pointer(radio_button))));
}

static s7_pointer lg_gtk_radio_button_set_group(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_radio_button_set_group "void gtk_radio_button_set_group(GtkRadioButton* radio_button, \
GSList* group)"
  s7_pointer _p;
  s7_pointer radio_button, group;
  _p = args;
  radio_button = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(radio_button, GtkRadioButton__sym)) s7_wrong_type_arg_error(sc, "gtk_radio_button_set_group", 1, radio_button, "GtkRadioButton*");
  group = s7_car(_p);
  if ((!s7_is_c_pointer_of_type(group, GSList__sym)) && (group != lg_false)) s7_wrong_type_arg_error(sc, "gtk_radio_button_set_group", 2, group, "GSList*");
  gtk_radio_button_set_group((GtkRadioButton*)s7_c_pointer(radio_button), (GSList*)s7_c_pointer(group));
  return(lg_false);
}

static s7_pointer lg_gtk_range_set_adjustment(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_range_set_adjustment "void gtk_range_set_adjustment(GtkRange* range, GtkAdjustment* adjustment)"
  s7_pointer _p;
  s7_pointer range, adjustment;
  _p = args;
  range = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(range, GtkRange__sym)) s7_wrong_type_arg_error(sc, "gtk_range_set_adjustment", 1, range, "GtkRange*");
  adjustment = s7_car(_p);
  if ((!s7_is_c_pointer_of_type(adjustment, GtkAdjustment__sym)) && (adjustment != lg_false)) s7_wrong_type_arg_error(sc, "gtk_range_set_adjustment", 2, adjustment, "GtkAdjustment*");
  gtk_range_set_adjustment((GtkRange*)s7_c_pointer(range), (GtkAdjustment*)s7_c_pointer(adjustment));
  return(lg_false);
}

static s7_pointer lg_gtk_range_get_adjustment(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_range_get_adjustment "GtkAdjustment* gtk_range_get_adjustment(GtkRange* range)"
  s7_pointer range;
  range = s7_car(args);
  if (!s7_is_c_pointer_of_type(range, GtkRange__sym)) s7_wrong_type_arg_error(sc, "gtk_range_get_adjustment", 1, range, "GtkRange*");
  return(lg_make_c_pointer_with_type(sc, GtkAdjustment__sym, gtk_range_get_adjustment((GtkRange*)s7_c_pointer(range))));
}

static s7_pointer lg_gtk_range_set_inverted(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_range_set_inverted "void gtk_range_set_inverted(GtkRange* range, gboolean setting)"
  s7_pointer _p;
  s7_pointer range, setting;
  _p = args;
  range = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(range, GtkRange__sym)) s7_wrong_type_arg_error(sc, "gtk_range_set_inverted", 1, range, "GtkRange*");
  setting = s7_car(_p);
  if (!s7_is_boolean(setting)) s7_wrong_type_arg_error(sc, "gtk_range_set_inverted", 2, setting, "gboolean");
  gtk_range_set_inverted((GtkRange*)s7_c_pointer(range), (gboolean)lg_boolean(setting));
  return(lg_false);
}

static s7_pointer lg_gtk_range_get_inverted(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_range_get_inverted "gboolean gtk_range_get_inverted(GtkRange* range)"
  s7_pointer range;
  range = s7_car(args);
  if (!s7_is_c_pointer_of_type(range, GtkRange__sym)) s7_wrong_type_arg_error(sc, "gtk_range_get_inverted", 1, range, "GtkRange*");
  return(s7_make_boolean(sc, gtk_range_get_inverted((GtkRange*)s7_c_pointer(range))));
}

static s7_pointer lg_gtk_range_set_increments(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_range_set_increments "void gtk_range_set_increments(GtkRange* range, gdouble step, gdouble page)"
  s7_pointer _p;
  s7_pointer range, step, page;
  _p = args;
  range = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(range, GtkRange__sym)) s7_wrong_type_arg_error(sc, "gtk_range_set_increments", 1, range, "GtkRange*");
  step = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(step)) s7_wrong_type_arg_error(sc, "gtk_range_set_increments", 2, step, "gdouble");
  page = s7_car(_p);
  if (!s7_is_real(page)) s7_wrong_type_arg_error(sc, "gtk_range_set_increments", 3, page, "gdouble");
  gtk_range_set_increments((GtkRange*)s7_c_pointer(range), (gdouble)s7_real(step), (gdouble)s7_real(page));
  return(lg_false);
}

static s7_pointer lg_gtk_range_set_range(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_range_set_range "void gtk_range_set_range(GtkRange* range, gdouble min, gdouble max)"
  s7_pointer _p;
  s7_pointer range, min, max;
  _p = args;
  range = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(range, GtkRange__sym)) s7_wrong_type_arg_error(sc, "gtk_range_set_range", 1, range, "GtkRange*");
  min = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(min)) s7_wrong_type_arg_error(sc, "gtk_range_set_range", 2, min, "gdouble");
  max = s7_car(_p);
  if (!s7_is_real(max)) s7_wrong_type_arg_error(sc, "gtk_range_set_range", 3, max, "gdouble");
  gtk_range_set_range((GtkRange*)s7_c_pointer(range), (gdouble)s7_real(min), (gdouble)s7_real(max));
  return(lg_false);
}

static s7_pointer lg_gtk_range_set_value(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_range_set_value "void gtk_range_set_value(GtkRange* range, gdouble value)"
  s7_pointer _p;
  s7_pointer range, value;
  _p = args;
  range = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(range, GtkRange__sym)) s7_wrong_type_arg_error(sc, "gtk_range_set_value", 1, range, "GtkRange*");
  value = s7_car(_p);
  if (!s7_is_real(value)) s7_wrong_type_arg_error(sc, "gtk_range_set_value", 2, value, "gdouble");
  gtk_range_set_value((GtkRange*)s7_c_pointer(range), (gdouble)s7_real(value));
  return(lg_false);
}

static s7_pointer lg_gtk_range_get_value(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_range_get_value "gdouble gtk_range_get_value(GtkRange* range)"
  s7_pointer range;
  range = s7_car(args);
  if (!s7_is_c_pointer_of_type(range, GtkRange__sym)) s7_wrong_type_arg_error(sc, "gtk_range_get_value", 1, range, "GtkRange*");
  return(s7_make_real(sc, gtk_range_get_value((GtkRange*)s7_c_pointer(range))));
}

static s7_pointer lg_gtk_scale_set_digits(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_scale_set_digits "void gtk_scale_set_digits(GtkScale* scale, gint digits)"
  s7_pointer _p;
  s7_pointer scale, digits;
  _p = args;
  scale = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(scale, GtkScale__sym)) s7_wrong_type_arg_error(sc, "gtk_scale_set_digits", 1, scale, "GtkScale*");
  digits = s7_car(_p);
  if (!s7_is_integer(digits)) s7_wrong_type_arg_error(sc, "gtk_scale_set_digits", 2, digits, "gint");
  gtk_scale_set_digits((GtkScale*)s7_c_pointer(scale), (gint)s7_integer(digits));
  return(lg_false);
}

static s7_pointer lg_gtk_scale_get_digits(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_scale_get_digits "gint gtk_scale_get_digits(GtkScale* scale)"
  s7_pointer scale;
  scale = s7_car(args);
  if (!s7_is_c_pointer_of_type(scale, GtkScale__sym)) s7_wrong_type_arg_error(sc, "gtk_scale_get_digits", 1, scale, "GtkScale*");
  return(s7_make_integer(sc, gtk_scale_get_digits((GtkScale*)s7_c_pointer(scale))));
}

static s7_pointer lg_gtk_scale_set_draw_value(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_scale_set_draw_value "void gtk_scale_set_draw_value(GtkScale* scale, gboolean draw_value)"
  s7_pointer _p;
  s7_pointer scale, draw_value;
  _p = args;
  scale = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(scale, GtkScale__sym)) s7_wrong_type_arg_error(sc, "gtk_scale_set_draw_value", 1, scale, "GtkScale*");
  draw_value = s7_car(_p);
  if (!s7_is_boolean(draw_value)) s7_wrong_type_arg_error(sc, "gtk_scale_set_draw_value", 2, draw_value, "gboolean");
  gtk_scale_set_draw_value((GtkScale*)s7_c_pointer(scale), (gboolean)lg_boolean(draw_value));
  return(lg_false);
}

static s7_pointer lg_gtk_scale_get_draw_value(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_scale_get_draw_value "gboolean gtk_scale_get_draw_value(GtkScale* scale)"
  s7_pointer scale;
  scale = s7_car(args);
  if (!s7_is_c_pointer_of_type(scale, GtkScale__sym)) s7_wrong_type_arg_error(sc, "gtk_scale_get_draw_value", 1, scale, "GtkScale*");
  return(s7_make_boolean(sc, gtk_scale_get_draw_value((GtkScale*)s7_c_pointer(scale))));
}

static s7_pointer lg_gtk_scale_set_value_pos(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_scale_set_value_pos "void gtk_scale_set_value_pos(GtkScale* scale, GtkPositionType pos)"
  s7_pointer _p;
  s7_pointer scale, pos;
  _p = args;
  scale = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(scale, GtkScale__sym)) s7_wrong_type_arg_error(sc, "gtk_scale_set_value_pos", 1, scale, "GtkScale*");
  pos = s7_car(_p);
  if (!s7_is_integer(pos)) s7_wrong_type_arg_error(sc, "gtk_scale_set_value_pos", 2, pos, "GtkPositionType");
  gtk_scale_set_value_pos((GtkScale*)s7_c_pointer(scale), (GtkPositionType)s7_integer(pos));
  return(lg_false);
}

static s7_pointer lg_gtk_scale_get_value_pos(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_scale_get_value_pos "GtkPositionType gtk_scale_get_value_pos(GtkScale* scale)"
  s7_pointer scale;
  scale = s7_car(args);
  if (!s7_is_c_pointer_of_type(scale, GtkScale__sym)) s7_wrong_type_arg_error(sc, "gtk_scale_get_value_pos", 1, scale, "GtkScale*");
  return(s7_make_integer(sc, gtk_scale_get_value_pos((GtkScale*)s7_c_pointer(scale))));
}

static s7_pointer lg_gtk_scrolled_window_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_scrolled_window_new "GtkWidget* gtk_scrolled_window_new(GtkAdjustment* hadjustment, GtkAdjustment* vadjustment)"
  s7_pointer _p;
  s7_pointer hadjustment, vadjustment;
  _p = args;
  hadjustment = s7_car(_p); _p = s7_cdr(_p);
  if ((!s7_is_c_pointer_of_type(hadjustment, GtkAdjustment__sym)) && (hadjustment != lg_false)) s7_wrong_type_arg_error(sc, "gtk_scrolled_window_new", 1, hadjustment, "GtkAdjustment*");
  vadjustment = s7_car(_p);
  if ((!s7_is_c_pointer_of_type(vadjustment, GtkAdjustment__sym)) && (vadjustment != lg_false)) s7_wrong_type_arg_error(sc, "gtk_scrolled_window_new", 2, vadjustment, "GtkAdjustment*");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_scrolled_window_new((GtkAdjustment*)s7_c_pointer(hadjustment), (GtkAdjustment*)s7_c_pointer(vadjustment))));
}

static s7_pointer lg_gtk_scrolled_window_set_hadjustment(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_scrolled_window_set_hadjustment "void gtk_scrolled_window_set_hadjustment(GtkScrolledWindow* scrolled_window, \
GtkAdjustment* hadjustment)"
  s7_pointer _p;
  s7_pointer scrolled_window, hadjustment;
  _p = args;
  scrolled_window = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(scrolled_window, GtkScrolledWindow__sym)) s7_wrong_type_arg_error(sc, "gtk_scrolled_window_set_hadjustment", 1, scrolled_window, "GtkScrolledWindow*");
  hadjustment = s7_car(_p);
  if ((!s7_is_c_pointer_of_type(hadjustment, GtkAdjustment__sym)) && (hadjustment != lg_false)) s7_wrong_type_arg_error(sc, "gtk_scrolled_window_set_hadjustment", 2, hadjustment, "GtkAdjustment*");
  gtk_scrolled_window_set_hadjustment((GtkScrolledWindow*)s7_c_pointer(scrolled_window), (GtkAdjustment*)s7_c_pointer(hadjustment));
  return(lg_false);
}

static s7_pointer lg_gtk_scrolled_window_set_vadjustment(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_scrolled_window_set_vadjustment "void gtk_scrolled_window_set_vadjustment(GtkScrolledWindow* scrolled_window, \
GtkAdjustment* hadjustment)"
  s7_pointer _p;
  s7_pointer scrolled_window, hadjustment;
  _p = args;
  scrolled_window = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(scrolled_window, GtkScrolledWindow__sym)) s7_wrong_type_arg_error(sc, "gtk_scrolled_window_set_vadjustment", 1, scrolled_window, "GtkScrolledWindow*");
  hadjustment = s7_car(_p);
  if ((!s7_is_c_pointer_of_type(hadjustment, GtkAdjustment__sym)) && (hadjustment != lg_false)) s7_wrong_type_arg_error(sc, "gtk_scrolled_window_set_vadjustment", 2, hadjustment, "GtkAdjustment*");
  gtk_scrolled_window_set_vadjustment((GtkScrolledWindow*)s7_c_pointer(scrolled_window), (GtkAdjustment*)s7_c_pointer(hadjustment));
  return(lg_false);
}

static s7_pointer lg_gtk_scrolled_window_get_hadjustment(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_scrolled_window_get_hadjustment "GtkAdjustment* gtk_scrolled_window_get_hadjustment(GtkScrolledWindow* scrolled_window)"
  s7_pointer scrolled_window;
  scrolled_window = s7_car(args);
  if (!s7_is_c_pointer_of_type(scrolled_window, GtkScrolledWindow__sym)) s7_wrong_type_arg_error(sc, "gtk_scrolled_window_get_hadjustment", 1, scrolled_window, "GtkScrolledWindow*");
  return(lg_make_c_pointer_with_type(sc, GtkAdjustment__sym, gtk_scrolled_window_get_hadjustment((GtkScrolledWindow*)s7_c_pointer(scrolled_window))));
}

static s7_pointer lg_gtk_scrolled_window_get_vadjustment(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_scrolled_window_get_vadjustment "GtkAdjustment* gtk_scrolled_window_get_vadjustment(GtkScrolledWindow* scrolled_window)"
  s7_pointer scrolled_window;
  scrolled_window = s7_car(args);
  if (!s7_is_c_pointer_of_type(scrolled_window, GtkScrolledWindow__sym)) s7_wrong_type_arg_error(sc, "gtk_scrolled_window_get_vadjustment", 1, scrolled_window, "GtkScrolledWindow*");
  return(lg_make_c_pointer_with_type(sc, GtkAdjustment__sym, gtk_scrolled_window_get_vadjustment((GtkScrolledWindow*)s7_c_pointer(scrolled_window))));
}

static s7_pointer lg_gtk_scrolled_window_set_policy(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_scrolled_window_set_policy "void gtk_scrolled_window_set_policy(GtkScrolledWindow* scrolled_window, \
GtkPolicyType hscrollbar_policy, GtkPolicyType vscrollbar_policy)"
  s7_pointer _p;
  s7_pointer scrolled_window, hscrollbar_policy, vscrollbar_policy;
  _p = args;
  scrolled_window = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(scrolled_window, GtkScrolledWindow__sym)) s7_wrong_type_arg_error(sc, "gtk_scrolled_window_set_policy", 1, scrolled_window, "GtkScrolledWindow*");
  hscrollbar_policy = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(hscrollbar_policy)) s7_wrong_type_arg_error(sc, "gtk_scrolled_window_set_policy", 2, hscrollbar_policy, "GtkPolicyType");
  vscrollbar_policy = s7_car(_p);
  if (!s7_is_integer(vscrollbar_policy)) s7_wrong_type_arg_error(sc, "gtk_scrolled_window_set_policy", 3, vscrollbar_policy, "GtkPolicyType");
  gtk_scrolled_window_set_policy((GtkScrolledWindow*)s7_c_pointer(scrolled_window), (GtkPolicyType)s7_integer(hscrollbar_policy), (GtkPolicyType)s7_integer(vscrollbar_policy));
  return(lg_false);
}

static s7_pointer lg_gtk_scrolled_window_get_policy(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_scrolled_window_get_policy "void gtk_scrolled_window_get_policy(GtkScrolledWindow* scrolled_window, \
GtkPolicyType* [hscrollbar_policy], GtkPolicyType* [vscrollbar_policy])"
  s7_pointer _p;
  s7_pointer scrolled_window;
  GtkPolicyType ref_hscrollbar_policy;
  GtkPolicyType ref_vscrollbar_policy;
  _p = args;
  scrolled_window = s7_car(_p);
  if (!s7_is_c_pointer_of_type(scrolled_window, GtkScrolledWindow__sym)) s7_wrong_type_arg_error(sc, "gtk_scrolled_window_get_policy", 1, scrolled_window, "GtkScrolledWindow*");
  gtk_scrolled_window_get_policy((GtkScrolledWindow*)s7_c_pointer(scrolled_window), &ref_hscrollbar_policy, &ref_vscrollbar_policy);
    return(s7_list(sc, 2, s7_make_integer(sc, ref_hscrollbar_policy), s7_make_integer(sc, ref_vscrollbar_policy)));
}

static s7_pointer lg_gtk_scrolled_window_set_placement(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_scrolled_window_set_placement "void gtk_scrolled_window_set_placement(GtkScrolledWindow* scrolled_window, \
GtkCornerType window_placement)"
  s7_pointer _p;
  s7_pointer scrolled_window, window_placement;
  _p = args;
  scrolled_window = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(scrolled_window, GtkScrolledWindow__sym)) s7_wrong_type_arg_error(sc, "gtk_scrolled_window_set_placement", 1, scrolled_window, "GtkScrolledWindow*");
  window_placement = s7_car(_p);
  if (!s7_is_integer(window_placement)) s7_wrong_type_arg_error(sc, "gtk_scrolled_window_set_placement", 2, window_placement, "GtkCornerType");
  gtk_scrolled_window_set_placement((GtkScrolledWindow*)s7_c_pointer(scrolled_window), (GtkCornerType)s7_integer(window_placement));
  return(lg_false);
}

static s7_pointer lg_gtk_scrolled_window_get_placement(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_scrolled_window_get_placement "GtkCornerType gtk_scrolled_window_get_placement(GtkScrolledWindow* scrolled_window)"
  s7_pointer scrolled_window;
  scrolled_window = s7_car(args);
  if (!s7_is_c_pointer_of_type(scrolled_window, GtkScrolledWindow__sym)) s7_wrong_type_arg_error(sc, "gtk_scrolled_window_get_placement", 1, scrolled_window, "GtkScrolledWindow*");
  return(s7_make_integer(sc, gtk_scrolled_window_get_placement((GtkScrolledWindow*)s7_c_pointer(scrolled_window))));
}

static s7_pointer lg_gtk_settings_get_default(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_settings_get_default "GtkSettings* gtk_settings_get_default( void)"
  return(lg_make_c_pointer_with_type(sc, GtkSettings__sym, gtk_settings_get_default()));
}

static s7_pointer lg_gtk_size_group_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_size_group_new "GtkSizeGroup* gtk_size_group_new(GtkSizeGroupMode mode)"
  s7_pointer mode;
  mode = s7_car(args);
  if (!s7_is_integer(mode)) s7_wrong_type_arg_error(sc, "gtk_size_group_new", 1, mode, "GtkSizeGroupMode");
  return(lg_make_c_pointer_with_type(sc, GtkSizeGroup__sym, gtk_size_group_new((GtkSizeGroupMode)s7_integer(mode))));
}

static s7_pointer lg_gtk_size_group_set_mode(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_size_group_set_mode "void gtk_size_group_set_mode(GtkSizeGroup* size_group, GtkSizeGroupMode mode)"
  s7_pointer _p;
  s7_pointer size_group, mode;
  _p = args;
  size_group = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(size_group, GtkSizeGroup__sym)) s7_wrong_type_arg_error(sc, "gtk_size_group_set_mode", 1, size_group, "GtkSizeGroup*");
  mode = s7_car(_p);
  if (!s7_is_integer(mode)) s7_wrong_type_arg_error(sc, "gtk_size_group_set_mode", 2, mode, "GtkSizeGroupMode");
  gtk_size_group_set_mode((GtkSizeGroup*)s7_c_pointer(size_group), (GtkSizeGroupMode)s7_integer(mode));
  return(lg_false);
}

static s7_pointer lg_gtk_size_group_get_mode(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_size_group_get_mode "GtkSizeGroupMode gtk_size_group_get_mode(GtkSizeGroup* size_group)"
  s7_pointer size_group;
  size_group = s7_car(args);
  if (!s7_is_c_pointer_of_type(size_group, GtkSizeGroup__sym)) s7_wrong_type_arg_error(sc, "gtk_size_group_get_mode", 1, size_group, "GtkSizeGroup*");
  return(s7_make_integer(sc, gtk_size_group_get_mode((GtkSizeGroup*)s7_c_pointer(size_group))));
}

static s7_pointer lg_gtk_size_group_add_widget(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_size_group_add_widget "void gtk_size_group_add_widget(GtkSizeGroup* size_group, GtkWidget* widget)"
  s7_pointer _p;
  s7_pointer size_group, widget;
  _p = args;
  size_group = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(size_group, GtkSizeGroup__sym)) s7_wrong_type_arg_error(sc, "gtk_size_group_add_widget", 1, size_group, "GtkSizeGroup*");
  widget = s7_car(_p);
  if (!s7_is_c_pointer_of_type(widget, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_size_group_add_widget", 2, widget, "GtkWidget*");
  gtk_size_group_add_widget((GtkSizeGroup*)s7_c_pointer(size_group), (GtkWidget*)s7_c_pointer(widget));
  return(lg_false);
}

static s7_pointer lg_gtk_size_group_remove_widget(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_size_group_remove_widget "void gtk_size_group_remove_widget(GtkSizeGroup* size_group, \
GtkWidget* widget)"
  s7_pointer _p;
  s7_pointer size_group, widget;
  _p = args;
  size_group = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(size_group, GtkSizeGroup__sym)) s7_wrong_type_arg_error(sc, "gtk_size_group_remove_widget", 1, size_group, "GtkSizeGroup*");
  widget = s7_car(_p);
  if (!s7_is_c_pointer_of_type(widget, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_size_group_remove_widget", 2, widget, "GtkWidget*");
  gtk_size_group_remove_widget((GtkSizeGroup*)s7_c_pointer(size_group), (GtkWidget*)s7_c_pointer(widget));
  return(lg_false);
}

static s7_pointer lg_gtk_spin_button_configure(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_spin_button_configure "void gtk_spin_button_configure(GtkSpinButton* spin_button, GtkAdjustment* adjustment, \
gdouble climb_rate, guint digits)"
  s7_pointer _p;
  s7_pointer spin_button, adjustment, climb_rate, digits;
  _p = args;
  spin_button = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(spin_button, GtkSpinButton__sym)) s7_wrong_type_arg_error(sc, "gtk_spin_button_configure", 1, spin_button, "GtkSpinButton*");
  adjustment = s7_car(_p); _p = s7_cdr(_p);
  if ((!s7_is_c_pointer_of_type(adjustment, GtkAdjustment__sym)) && (adjustment != lg_false)) s7_wrong_type_arg_error(sc, "gtk_spin_button_configure", 2, adjustment, "GtkAdjustment*");
  climb_rate = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(climb_rate)) s7_wrong_type_arg_error(sc, "gtk_spin_button_configure", 3, climb_rate, "gdouble");
  digits = s7_car(_p);
  if (!s7_is_integer(digits)) s7_wrong_type_arg_error(sc, "gtk_spin_button_configure", 4, digits, "guint");
  gtk_spin_button_configure((GtkSpinButton*)s7_c_pointer(spin_button), (GtkAdjustment*)s7_c_pointer(adjustment), (gdouble)s7_real(climb_rate), (guint)s7_integer(digits));
  return(lg_false);
}

static s7_pointer lg_gtk_spin_button_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_spin_button_new "GtkWidget* gtk_spin_button_new(GtkAdjustment* adjustment, gdouble climb_rate, \
guint digits)"
  s7_pointer _p;
  s7_pointer adjustment, climb_rate, digits;
  _p = args;
  adjustment = s7_car(_p); _p = s7_cdr(_p);
  if ((!s7_is_c_pointer_of_type(adjustment, GtkAdjustment__sym)) && (adjustment != lg_false)) s7_wrong_type_arg_error(sc, "gtk_spin_button_new", 1, adjustment, "GtkAdjustment*");
  climb_rate = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(climb_rate)) s7_wrong_type_arg_error(sc, "gtk_spin_button_new", 2, climb_rate, "gdouble");
  digits = s7_car(_p);
  if (!s7_is_integer(digits)) s7_wrong_type_arg_error(sc, "gtk_spin_button_new", 3, digits, "guint");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_spin_button_new((GtkAdjustment*)s7_c_pointer(adjustment), (gdouble)s7_real(climb_rate), (guint)s7_integer(digits))));
}

static s7_pointer lg_gtk_spin_button_new_with_range(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_spin_button_new_with_range "GtkWidget* gtk_spin_button_new_with_range(gdouble min, gdouble max, \
gdouble step)"
  s7_pointer _p;
  s7_pointer min, max, step;
  _p = args;
  min = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(min)) s7_wrong_type_arg_error(sc, "gtk_spin_button_new_with_range", 1, min, "gdouble");
  max = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(max)) s7_wrong_type_arg_error(sc, "gtk_spin_button_new_with_range", 2, max, "gdouble");
  step = s7_car(_p);
  if (!s7_is_real(step)) s7_wrong_type_arg_error(sc, "gtk_spin_button_new_with_range", 3, step, "gdouble");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_spin_button_new_with_range((gdouble)s7_real(min), (gdouble)s7_real(max), (gdouble)s7_real(step))));
}

static s7_pointer lg_gtk_spin_button_set_adjustment(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_spin_button_set_adjustment "void gtk_spin_button_set_adjustment(GtkSpinButton* spin_button, \
GtkAdjustment* adjustment)"
  s7_pointer _p;
  s7_pointer spin_button, adjustment;
  _p = args;
  spin_button = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(spin_button, GtkSpinButton__sym)) s7_wrong_type_arg_error(sc, "gtk_spin_button_set_adjustment", 1, spin_button, "GtkSpinButton*");
  adjustment = s7_car(_p);
  if ((!s7_is_c_pointer_of_type(adjustment, GtkAdjustment__sym)) && (adjustment != lg_false)) s7_wrong_type_arg_error(sc, "gtk_spin_button_set_adjustment", 2, adjustment, "GtkAdjustment*");
  gtk_spin_button_set_adjustment((GtkSpinButton*)s7_c_pointer(spin_button), (GtkAdjustment*)s7_c_pointer(adjustment));
  return(lg_false);
}

static s7_pointer lg_gtk_spin_button_get_adjustment(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_spin_button_get_adjustment "GtkAdjustment* gtk_spin_button_get_adjustment(GtkSpinButton* spin_button)"
  s7_pointer spin_button;
  spin_button = s7_car(args);
  if (!s7_is_c_pointer_of_type(spin_button, GtkSpinButton__sym)) s7_wrong_type_arg_error(sc, "gtk_spin_button_get_adjustment", 1, spin_button, "GtkSpinButton*");
  return(lg_make_c_pointer_with_type(sc, GtkAdjustment__sym, gtk_spin_button_get_adjustment((GtkSpinButton*)s7_c_pointer(spin_button))));
}

static s7_pointer lg_gtk_spin_button_set_digits(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_spin_button_set_digits "void gtk_spin_button_set_digits(GtkSpinButton* spin_button, guint digits)"
  s7_pointer _p;
  s7_pointer spin_button, digits;
  _p = args;
  spin_button = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(spin_button, GtkSpinButton__sym)) s7_wrong_type_arg_error(sc, "gtk_spin_button_set_digits", 1, spin_button, "GtkSpinButton*");
  digits = s7_car(_p);
  if (!s7_is_integer(digits)) s7_wrong_type_arg_error(sc, "gtk_spin_button_set_digits", 2, digits, "guint");
  gtk_spin_button_set_digits((GtkSpinButton*)s7_c_pointer(spin_button), (guint)s7_integer(digits));
  return(lg_false);
}

static s7_pointer lg_gtk_spin_button_get_digits(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_spin_button_get_digits "guint gtk_spin_button_get_digits(GtkSpinButton* spin_button)"
  s7_pointer spin_button;
  spin_button = s7_car(args);
  if (!s7_is_c_pointer_of_type(spin_button, GtkSpinButton__sym)) s7_wrong_type_arg_error(sc, "gtk_spin_button_get_digits", 1, spin_button, "GtkSpinButton*");
  return(s7_make_integer(sc, gtk_spin_button_get_digits((GtkSpinButton*)s7_c_pointer(spin_button))));
}

static s7_pointer lg_gtk_spin_button_set_increments(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_spin_button_set_increments "void gtk_spin_button_set_increments(GtkSpinButton* spin_button, \
gdouble step, gdouble page)"
  s7_pointer _p;
  s7_pointer spin_button, step, page;
  _p = args;
  spin_button = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(spin_button, GtkSpinButton__sym)) s7_wrong_type_arg_error(sc, "gtk_spin_button_set_increments", 1, spin_button, "GtkSpinButton*");
  step = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(step)) s7_wrong_type_arg_error(sc, "gtk_spin_button_set_increments", 2, step, "gdouble");
  page = s7_car(_p);
  if (!s7_is_real(page)) s7_wrong_type_arg_error(sc, "gtk_spin_button_set_increments", 3, page, "gdouble");
  gtk_spin_button_set_increments((GtkSpinButton*)s7_c_pointer(spin_button), (gdouble)s7_real(step), (gdouble)s7_real(page));
  return(lg_false);
}

static s7_pointer lg_gtk_spin_button_get_increments(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_spin_button_get_increments "void gtk_spin_button_get_increments(GtkSpinButton* spin_button, \
gdouble* [step], gdouble* [page])"
  s7_pointer _p;
  s7_pointer spin_button;
  gdouble ref_step;
  gdouble ref_page;
  _p = args;
  spin_button = s7_car(_p);
  if (!s7_is_c_pointer_of_type(spin_button, GtkSpinButton__sym)) s7_wrong_type_arg_error(sc, "gtk_spin_button_get_increments", 1, spin_button, "GtkSpinButton*");
  gtk_spin_button_get_increments((GtkSpinButton*)s7_c_pointer(spin_button), &ref_step, &ref_page);
    return(s7_list(sc, 2, s7_make_real(sc, ref_step), s7_make_real(sc, ref_page)));
}

static s7_pointer lg_gtk_spin_button_set_range(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_spin_button_set_range "void gtk_spin_button_set_range(GtkSpinButton* spin_button, gdouble min, \
gdouble max)"
  s7_pointer _p;
  s7_pointer spin_button, min, max;
  _p = args;
  spin_button = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(spin_button, GtkSpinButton__sym)) s7_wrong_type_arg_error(sc, "gtk_spin_button_set_range", 1, spin_button, "GtkSpinButton*");
  min = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(min)) s7_wrong_type_arg_error(sc, "gtk_spin_button_set_range", 2, min, "gdouble");
  max = s7_car(_p);
  if (!s7_is_real(max)) s7_wrong_type_arg_error(sc, "gtk_spin_button_set_range", 3, max, "gdouble");
  gtk_spin_button_set_range((GtkSpinButton*)s7_c_pointer(spin_button), (gdouble)s7_real(min), (gdouble)s7_real(max));
  return(lg_false);
}

static s7_pointer lg_gtk_spin_button_get_range(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_spin_button_get_range "void gtk_spin_button_get_range(GtkSpinButton* spin_button, gdouble* [min], \
gdouble* [max])"
  s7_pointer _p;
  s7_pointer spin_button;
  gdouble ref_min;
  gdouble ref_max;
  _p = args;
  spin_button = s7_car(_p);
  if (!s7_is_c_pointer_of_type(spin_button, GtkSpinButton__sym)) s7_wrong_type_arg_error(sc, "gtk_spin_button_get_range", 1, spin_button, "GtkSpinButton*");
  gtk_spin_button_get_range((GtkSpinButton*)s7_c_pointer(spin_button), &ref_min, &ref_max);
    return(s7_list(sc, 2, s7_make_real(sc, ref_min), s7_make_real(sc, ref_max)));
}

static s7_pointer lg_gtk_spin_button_get_value(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_spin_button_get_value "gdouble gtk_spin_button_get_value(GtkSpinButton* spin_button)"
  s7_pointer spin_button;
  spin_button = s7_car(args);
  if (!s7_is_c_pointer_of_type(spin_button, GtkSpinButton__sym)) s7_wrong_type_arg_error(sc, "gtk_spin_button_get_value", 1, spin_button, "GtkSpinButton*");
  return(s7_make_real(sc, gtk_spin_button_get_value((GtkSpinButton*)s7_c_pointer(spin_button))));
}

static s7_pointer lg_gtk_spin_button_get_value_as_int(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_spin_button_get_value_as_int "gint gtk_spin_button_get_value_as_int(GtkSpinButton* spin_button)"
  s7_pointer spin_button;
  spin_button = s7_car(args);
  if (!s7_is_c_pointer_of_type(spin_button, GtkSpinButton__sym)) s7_wrong_type_arg_error(sc, "gtk_spin_button_get_value_as_int", 1, spin_button, "GtkSpinButton*");
  return(s7_make_integer(sc, gtk_spin_button_get_value_as_int((GtkSpinButton*)s7_c_pointer(spin_button))));
}

static s7_pointer lg_gtk_spin_button_set_value(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_spin_button_set_value "void gtk_spin_button_set_value(GtkSpinButton* spin_button, gdouble value)"
  s7_pointer _p;
  s7_pointer spin_button, value;
  _p = args;
  spin_button = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(spin_button, GtkSpinButton__sym)) s7_wrong_type_arg_error(sc, "gtk_spin_button_set_value", 1, spin_button, "GtkSpinButton*");
  value = s7_car(_p);
  if (!s7_is_real(value)) s7_wrong_type_arg_error(sc, "gtk_spin_button_set_value", 2, value, "gdouble");
  gtk_spin_button_set_value((GtkSpinButton*)s7_c_pointer(spin_button), (gdouble)s7_real(value));
  return(lg_false);
}

static s7_pointer lg_gtk_spin_button_set_update_policy(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_spin_button_set_update_policy "void gtk_spin_button_set_update_policy(GtkSpinButton* spin_button, \
GtkSpinButtonUpdatePolicy policy)"
  s7_pointer _p;
  s7_pointer spin_button, policy;
  _p = args;
  spin_button = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(spin_button, GtkSpinButton__sym)) s7_wrong_type_arg_error(sc, "gtk_spin_button_set_update_policy", 1, spin_button, "GtkSpinButton*");
  policy = s7_car(_p);
  if (!s7_is_integer(policy)) s7_wrong_type_arg_error(sc, "gtk_spin_button_set_update_policy", 2, policy, "GtkSpinButtonUpdatePolicy");
  gtk_spin_button_set_update_policy((GtkSpinButton*)s7_c_pointer(spin_button), (GtkSpinButtonUpdatePolicy)s7_integer(policy));
  return(lg_false);
}

static s7_pointer lg_gtk_spin_button_get_update_policy(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_spin_button_get_update_policy "GtkSpinButtonUpdatePolicy gtk_spin_button_get_update_policy(GtkSpinButton* spin_button)"
  s7_pointer spin_button;
  spin_button = s7_car(args);
  if (!s7_is_c_pointer_of_type(spin_button, GtkSpinButton__sym)) s7_wrong_type_arg_error(sc, "gtk_spin_button_get_update_policy", 1, spin_button, "GtkSpinButton*");
  return(s7_make_integer(sc, gtk_spin_button_get_update_policy((GtkSpinButton*)s7_c_pointer(spin_button))));
}

static s7_pointer lg_gtk_spin_button_set_numeric(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_spin_button_set_numeric "void gtk_spin_button_set_numeric(GtkSpinButton* spin_button, \
gboolean numeric)"
  s7_pointer _p;
  s7_pointer spin_button, numeric;
  _p = args;
  spin_button = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(spin_button, GtkSpinButton__sym)) s7_wrong_type_arg_error(sc, "gtk_spin_button_set_numeric", 1, spin_button, "GtkSpinButton*");
  numeric = s7_car(_p);
  if (!s7_is_boolean(numeric)) s7_wrong_type_arg_error(sc, "gtk_spin_button_set_numeric", 2, numeric, "gboolean");
  gtk_spin_button_set_numeric((GtkSpinButton*)s7_c_pointer(spin_button), (gboolean)lg_boolean(numeric));
  return(lg_false);
}

static s7_pointer lg_gtk_spin_button_get_numeric(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_spin_button_get_numeric "gboolean gtk_spin_button_get_numeric(GtkSpinButton* spin_button)"
  s7_pointer spin_button;
  spin_button = s7_car(args);
  if (!s7_is_c_pointer_of_type(spin_button, GtkSpinButton__sym)) s7_wrong_type_arg_error(sc, "gtk_spin_button_get_numeric", 1, spin_button, "GtkSpinButton*");
  return(s7_make_boolean(sc, gtk_spin_button_get_numeric((GtkSpinButton*)s7_c_pointer(spin_button))));
}

static s7_pointer lg_gtk_spin_button_spin(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_spin_button_spin "void gtk_spin_button_spin(GtkSpinButton* spin_button, GtkSpinType direction, \
gdouble increment)"
  s7_pointer _p;
  s7_pointer spin_button, direction, increment;
  _p = args;
  spin_button = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(spin_button, GtkSpinButton__sym)) s7_wrong_type_arg_error(sc, "gtk_spin_button_spin", 1, spin_button, "GtkSpinButton*");
  direction = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(direction)) s7_wrong_type_arg_error(sc, "gtk_spin_button_spin", 2, direction, "GtkSpinType");
  increment = s7_car(_p);
  if (!s7_is_real(increment)) s7_wrong_type_arg_error(sc, "gtk_spin_button_spin", 3, increment, "gdouble");
  gtk_spin_button_spin((GtkSpinButton*)s7_c_pointer(spin_button), (GtkSpinType)s7_integer(direction), (gdouble)s7_real(increment));
  return(lg_false);
}

static s7_pointer lg_gtk_spin_button_set_wrap(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_spin_button_set_wrap "void gtk_spin_button_set_wrap(GtkSpinButton* spin_button, gboolean wrap)"
  s7_pointer _p;
  s7_pointer spin_button, wrap;
  _p = args;
  spin_button = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(spin_button, GtkSpinButton__sym)) s7_wrong_type_arg_error(sc, "gtk_spin_button_set_wrap", 1, spin_button, "GtkSpinButton*");
  wrap = s7_car(_p);
  if (!s7_is_boolean(wrap)) s7_wrong_type_arg_error(sc, "gtk_spin_button_set_wrap", 2, wrap, "gboolean");
  gtk_spin_button_set_wrap((GtkSpinButton*)s7_c_pointer(spin_button), (gboolean)lg_boolean(wrap));
  return(lg_false);
}

static s7_pointer lg_gtk_spin_button_get_wrap(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_spin_button_get_wrap "gboolean gtk_spin_button_get_wrap(GtkSpinButton* spin_button)"
  s7_pointer spin_button;
  spin_button = s7_car(args);
  if (!s7_is_c_pointer_of_type(spin_button, GtkSpinButton__sym)) s7_wrong_type_arg_error(sc, "gtk_spin_button_get_wrap", 1, spin_button, "GtkSpinButton*");
  return(s7_make_boolean(sc, gtk_spin_button_get_wrap((GtkSpinButton*)s7_c_pointer(spin_button))));
}

static s7_pointer lg_gtk_spin_button_set_snap_to_ticks(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_spin_button_set_snap_to_ticks "void gtk_spin_button_set_snap_to_ticks(GtkSpinButton* spin_button, \
gboolean snap_to_ticks)"
  s7_pointer _p;
  s7_pointer spin_button, snap_to_ticks;
  _p = args;
  spin_button = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(spin_button, GtkSpinButton__sym)) s7_wrong_type_arg_error(sc, "gtk_spin_button_set_snap_to_ticks", 1, spin_button, "GtkSpinButton*");
  snap_to_ticks = s7_car(_p);
  if (!s7_is_boolean(snap_to_ticks)) s7_wrong_type_arg_error(sc, "gtk_spin_button_set_snap_to_ticks", 2, snap_to_ticks, "gboolean");
  gtk_spin_button_set_snap_to_ticks((GtkSpinButton*)s7_c_pointer(spin_button), (gboolean)lg_boolean(snap_to_ticks));
  return(lg_false);
}

static s7_pointer lg_gtk_spin_button_get_snap_to_ticks(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_spin_button_get_snap_to_ticks "gboolean gtk_spin_button_get_snap_to_ticks(GtkSpinButton* spin_button)"
  s7_pointer spin_button;
  spin_button = s7_car(args);
  if (!s7_is_c_pointer_of_type(spin_button, GtkSpinButton__sym)) s7_wrong_type_arg_error(sc, "gtk_spin_button_get_snap_to_ticks", 1, spin_button, "GtkSpinButton*");
  return(s7_make_boolean(sc, gtk_spin_button_get_snap_to_ticks((GtkSpinButton*)s7_c_pointer(spin_button))));
}

static s7_pointer lg_gtk_spin_button_update(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_spin_button_update "void gtk_spin_button_update(GtkSpinButton* spin_button)"
  s7_pointer spin_button;
  spin_button = s7_car(args);
  if (!s7_is_c_pointer_of_type(spin_button, GtkSpinButton__sym)) s7_wrong_type_arg_error(sc, "gtk_spin_button_update", 1, spin_button, "GtkSpinButton*");
  gtk_spin_button_update((GtkSpinButton*)s7_c_pointer(spin_button));
  return(lg_false);
}

static s7_pointer lg_gtk_statusbar_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_statusbar_new "GtkWidget* gtk_statusbar_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_statusbar_new()));
}

static s7_pointer lg_gtk_statusbar_get_context_id(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_statusbar_get_context_id "guint gtk_statusbar_get_context_id(GtkStatusbar* statusbar, \
gchar* context_description)"
  s7_pointer _p;
  s7_pointer statusbar, context_description;
  _p = args;
  statusbar = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(statusbar, GtkStatusbar__sym)) s7_wrong_type_arg_error(sc, "gtk_statusbar_get_context_id", 1, statusbar, "GtkStatusbar*");
  context_description = s7_car(_p);
  if (!s7_is_string(context_description)) s7_wrong_type_arg_error(sc, "gtk_statusbar_get_context_id", 2, context_description, "gchar*");
  return(s7_make_integer(sc, gtk_statusbar_get_context_id((GtkStatusbar*)s7_c_pointer(statusbar), (gchar*)s7_string(context_description))));
}

static s7_pointer lg_gtk_statusbar_push(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_statusbar_push "guint gtk_statusbar_push(GtkStatusbar* statusbar, guint context_id, gchar* text)"
  s7_pointer _p;
  s7_pointer statusbar, context_id, text;
  _p = args;
  statusbar = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(statusbar, GtkStatusbar__sym)) s7_wrong_type_arg_error(sc, "gtk_statusbar_push", 1, statusbar, "GtkStatusbar*");
  context_id = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(context_id)) s7_wrong_type_arg_error(sc, "gtk_statusbar_push", 2, context_id, "guint");
  text = s7_car(_p);
  if (!s7_is_string(text)) s7_wrong_type_arg_error(sc, "gtk_statusbar_push", 3, text, "gchar*");
  return(s7_make_integer(sc, gtk_statusbar_push((GtkStatusbar*)s7_c_pointer(statusbar), (guint)s7_integer(context_id), (gchar*)s7_string(text))));
}

static s7_pointer lg_gtk_statusbar_pop(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_statusbar_pop "void gtk_statusbar_pop(GtkStatusbar* statusbar, guint context_id)"
  s7_pointer _p;
  s7_pointer statusbar, context_id;
  _p = args;
  statusbar = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(statusbar, GtkStatusbar__sym)) s7_wrong_type_arg_error(sc, "gtk_statusbar_pop", 1, statusbar, "GtkStatusbar*");
  context_id = s7_car(_p);
  if (!s7_is_integer(context_id)) s7_wrong_type_arg_error(sc, "gtk_statusbar_pop", 2, context_id, "guint");
  gtk_statusbar_pop((GtkStatusbar*)s7_c_pointer(statusbar), (guint)s7_integer(context_id));
  return(lg_false);
}

static s7_pointer lg_gtk_statusbar_remove(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_statusbar_remove "void gtk_statusbar_remove(GtkStatusbar* statusbar, guint context_id, \
guint message_id)"
  s7_pointer _p;
  s7_pointer statusbar, context_id, message_id;
  _p = args;
  statusbar = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(statusbar, GtkStatusbar__sym)) s7_wrong_type_arg_error(sc, "gtk_statusbar_remove", 1, statusbar, "GtkStatusbar*");
  context_id = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(context_id)) s7_wrong_type_arg_error(sc, "gtk_statusbar_remove", 2, context_id, "guint");
  message_id = s7_car(_p);
  if (!s7_is_integer(message_id)) s7_wrong_type_arg_error(sc, "gtk_statusbar_remove", 3, message_id, "guint");
  gtk_statusbar_remove((GtkStatusbar*)s7_c_pointer(statusbar), (guint)s7_integer(context_id), (guint)s7_integer(message_id));
  return(lg_false);
}

static s7_pointer lg_gtk_text_buffer_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_new "GtkTextBuffer* gtk_text_buffer_new(GtkTextTagTable* table)"
  s7_pointer table;
  table = s7_car(args);
  if ((!s7_is_c_pointer_of_type(table, GtkTextTagTable__sym)) && (table != lg_false)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_new", 1, table, "GtkTextTagTable*");
  return(lg_make_c_pointer_with_type(sc, GtkTextBuffer__sym, gtk_text_buffer_new((GtkTextTagTable*)s7_c_pointer(table))));
}

static s7_pointer lg_gtk_text_buffer_get_line_count(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_get_line_count "gint gtk_text_buffer_get_line_count(GtkTextBuffer* buffer)"
  s7_pointer buffer;
  buffer = s7_car(args);
  if (!s7_is_c_pointer_of_type(buffer, GtkTextBuffer__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_get_line_count", 1, buffer, "GtkTextBuffer*");
  return(s7_make_integer(sc, gtk_text_buffer_get_line_count((GtkTextBuffer*)s7_c_pointer(buffer))));
}

static s7_pointer lg_gtk_text_buffer_get_char_count(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_get_char_count "gint gtk_text_buffer_get_char_count(GtkTextBuffer* buffer)"
  s7_pointer buffer;
  buffer = s7_car(args);
  if (!s7_is_c_pointer_of_type(buffer, GtkTextBuffer__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_get_char_count", 1, buffer, "GtkTextBuffer*");
  return(s7_make_integer(sc, gtk_text_buffer_get_char_count((GtkTextBuffer*)s7_c_pointer(buffer))));
}

static s7_pointer lg_gtk_text_buffer_get_tag_table(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_get_tag_table "GtkTextTagTable* gtk_text_buffer_get_tag_table(GtkTextBuffer* buffer)"
  s7_pointer buffer;
  buffer = s7_car(args);
  if (!s7_is_c_pointer_of_type(buffer, GtkTextBuffer__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_get_tag_table", 1, buffer, "GtkTextBuffer*");
  return(lg_make_c_pointer_with_type(sc, GtkTextTagTable__sym, gtk_text_buffer_get_tag_table((GtkTextBuffer*)s7_c_pointer(buffer))));
}

static s7_pointer lg_gtk_text_buffer_set_text(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_set_text "void gtk_text_buffer_set_text(GtkTextBuffer* buffer, gchar* text, \
gint len)"
  s7_pointer _p;
  s7_pointer buffer, text, len;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(buffer, GtkTextBuffer__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_set_text", 1, buffer, "GtkTextBuffer*");
  text = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(text)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_set_text", 2, text, "gchar*");
  len = s7_car(_p);
  if (!s7_is_integer(len)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_set_text", 3, len, "gint");
  gtk_text_buffer_set_text((GtkTextBuffer*)s7_c_pointer(buffer), (gchar*)s7_string(text), (gint)s7_integer(len));
  return(lg_false);
}

static s7_pointer lg_gtk_text_buffer_insert(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_insert "void gtk_text_buffer_insert(GtkTextBuffer* buffer, GtkTextIter* iter, \
gchar* text, gint len)"
  s7_pointer _p;
  s7_pointer buffer, iter, text, len;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(buffer, GtkTextBuffer__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_insert", 1, buffer, "GtkTextBuffer*");
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_insert", 2, iter, "GtkTextIter*");
  text = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(text)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_insert", 3, text, "gchar*");
  len = s7_car(_p);
  if (!s7_is_integer(len)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_insert", 4, len, "gint");
  gtk_text_buffer_insert((GtkTextBuffer*)s7_c_pointer(buffer), (GtkTextIter*)s7_c_pointer(iter), (gchar*)s7_string(text), (gint)s7_integer(len));
  return(lg_false);
}

static s7_pointer lg_gtk_text_buffer_insert_at_cursor(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_insert_at_cursor "void gtk_text_buffer_insert_at_cursor(GtkTextBuffer* buffer, \
gchar* text, gint len)"
  s7_pointer _p;
  s7_pointer buffer, text, len;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(buffer, GtkTextBuffer__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_insert_at_cursor", 1, buffer, "GtkTextBuffer*");
  text = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(text)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_insert_at_cursor", 2, text, "gchar*");
  len = s7_car(_p);
  if (!s7_is_integer(len)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_insert_at_cursor", 3, len, "gint");
  gtk_text_buffer_insert_at_cursor((GtkTextBuffer*)s7_c_pointer(buffer), (gchar*)s7_string(text), (gint)s7_integer(len));
  return(lg_false);
}

static s7_pointer lg_gtk_text_buffer_insert_interactive(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_insert_interactive "gboolean gtk_text_buffer_insert_interactive(GtkTextBuffer* buffer, \
GtkTextIter* iter, gchar* text, gint len, gboolean default_editable)"
  s7_pointer _p;
  s7_pointer buffer, iter, text, len, default_editable;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(buffer, GtkTextBuffer__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_insert_interactive", 1, buffer, "GtkTextBuffer*");
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_insert_interactive", 2, iter, "GtkTextIter*");
  text = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(text)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_insert_interactive", 3, text, "gchar*");
  len = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(len)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_insert_interactive", 4, len, "gint");
  default_editable = s7_car(_p);
  if (!s7_is_boolean(default_editable)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_insert_interactive", 5, default_editable, "gboolean");
  return(s7_make_boolean(sc, gtk_text_buffer_insert_interactive((GtkTextBuffer*)s7_c_pointer(buffer), (GtkTextIter*)s7_c_pointer(iter), (gchar*)s7_string(text), (gint)s7_integer(len), (gboolean)lg_boolean(default_editable))));
}

static s7_pointer lg_gtk_text_buffer_insert_interactive_at_cursor(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_insert_interactive_at_cursor "gboolean gtk_text_buffer_insert_interactive_at_cursor(GtkTextBuffer* buffer, \
gchar* text, gint len, gboolean default_editable)"
  s7_pointer _p;
  s7_pointer buffer, text, len, default_editable;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(buffer, GtkTextBuffer__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_insert_interactive_at_cursor", 1, buffer, "GtkTextBuffer*");
  text = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(text)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_insert_interactive_at_cursor", 2, text, "gchar*");
  len = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(len)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_insert_interactive_at_cursor", 3, len, "gint");
  default_editable = s7_car(_p);
  if (!s7_is_boolean(default_editable)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_insert_interactive_at_cursor", 4, default_editable, "gboolean");
  return(s7_make_boolean(sc, gtk_text_buffer_insert_interactive_at_cursor((GtkTextBuffer*)s7_c_pointer(buffer), (gchar*)s7_string(text), (gint)s7_integer(len), (gboolean)lg_boolean(default_editable))));
}

static s7_pointer lg_gtk_text_buffer_insert_range(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_insert_range "void gtk_text_buffer_insert_range(GtkTextBuffer* buffer, GtkTextIter* iter, \
GtkTextIter* start, GtkTextIter* end)"
  s7_pointer _p;
  s7_pointer buffer, iter, start, end;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(buffer, GtkTextBuffer__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_insert_range", 1, buffer, "GtkTextBuffer*");
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_insert_range", 2, iter, "GtkTextIter*");
  start = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(start, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_insert_range", 3, start, "GtkTextIter*");
  end = s7_car(_p);
  if (!s7_is_c_pointer_of_type(end, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_insert_range", 4, end, "GtkTextIter*");
  gtk_text_buffer_insert_range((GtkTextBuffer*)s7_c_pointer(buffer), (GtkTextIter*)s7_c_pointer(iter), (GtkTextIter*)s7_c_pointer(start), (GtkTextIter*)s7_c_pointer(end));
  return(lg_false);
}

static s7_pointer lg_gtk_text_buffer_insert_range_interactive(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_insert_range_interactive "gboolean gtk_text_buffer_insert_range_interactive(GtkTextBuffer* buffer, \
GtkTextIter* iter, GtkTextIter* start, GtkTextIter* end, gboolean default_editable)"
  s7_pointer _p;
  s7_pointer buffer, iter, start, end, default_editable;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(buffer, GtkTextBuffer__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_insert_range_interactive", 1, buffer, "GtkTextBuffer*");
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_insert_range_interactive", 2, iter, "GtkTextIter*");
  start = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(start, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_insert_range_interactive", 3, start, "GtkTextIter*");
  end = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(end, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_insert_range_interactive", 4, end, "GtkTextIter*");
  default_editable = s7_car(_p);
  if (!s7_is_boolean(default_editable)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_insert_range_interactive", 5, default_editable, "gboolean");
  return(s7_make_boolean(sc, gtk_text_buffer_insert_range_interactive((GtkTextBuffer*)s7_c_pointer(buffer), (GtkTextIter*)s7_c_pointer(iter), (GtkTextIter*)s7_c_pointer(start), (GtkTextIter*)s7_c_pointer(end), (gboolean)lg_boolean(default_editable))));
}

static s7_pointer lg_gtk_text_buffer_insert_with_tags(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_insert_with_tags "void gtk_text_buffer_insert_with_tags(GtkTextBuffer* buffer, \
GtkTextIter* iter, gchar* text, gint len, etc tags)"
  s7_pointer _p;
  s7_pointer buffer, iter, text, len, tags;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(buffer, GtkTextBuffer__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_insert_with_tags", 1, buffer, "GtkTextBuffer*");
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_insert_with_tags", 2, iter, "GtkTextIter*");
  text = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(text)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_insert_with_tags", 3, text, "gchar*");
  len = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(len)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_insert_with_tags", 4, len, "gint");
  tags = s7_car(_p);
  if (!lg_is_list(tags)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_insert_with_tags", 5, tags, "etc");
  {
    int etc_len = 0;
    GtkTextBuffer* p_arg0;
    GtkTextIter* p_arg1;
    gchar* p_arg2;
    gint p_arg3;
    if (s7_is_list(sc, tags)) etc_len = s7_list_length(sc, tags);
    if (etc_len < 1) s7_out_of_range_error(sc, "gtk_text_buffer_insert_with_tags", 4, tags, "... list must have at least 1 entry");
    if (etc_len > 6) s7_out_of_range_error(sc, "gtk_text_buffer_insert_with_tags", 4, tags, "... list too long (max len: 6)");
    p_arg0 = (GtkTextBuffer*)s7_c_pointer(buffer);
    p_arg1 = (GtkTextIter*)s7_c_pointer(iter);
    p_arg2 = (gchar*)s7_string(text);
    p_arg3 = (gint)s7_integer(len);
    switch (etc_len)
      {
        case 1: gtk_text_buffer_insert_with_tags(p_arg0, p_arg1, p_arg2, p_arg3, (GtkTextTag*)s7_c_pointer(s7_list_ref(sc, tags, 0)), NULL); break;
        case 2: gtk_text_buffer_insert_with_tags(p_arg0, p_arg1, p_arg2, p_arg3, (GtkTextTag*)s7_c_pointer(s7_list_ref(sc, tags, 0)), (GtkTextTag*)s7_c_pointer(s7_list_ref(sc, tags, 1)), NULL); break;
        case 3: gtk_text_buffer_insert_with_tags(p_arg0, p_arg1, p_arg2, p_arg3, (GtkTextTag*)s7_c_pointer(s7_list_ref(sc, tags, 0)), (GtkTextTag*)s7_c_pointer(s7_list_ref(sc, tags, 1)), (GtkTextTag*)s7_c_pointer(s7_list_ref(sc, tags, 2)), NULL); break;
        case 4: gtk_text_buffer_insert_with_tags(p_arg0, p_arg1, p_arg2, p_arg3, (GtkTextTag*)s7_c_pointer(s7_list_ref(sc, tags, 0)), (GtkTextTag*)s7_c_pointer(s7_list_ref(sc, tags, 1)), (GtkTextTag*)s7_c_pointer(s7_list_ref(sc, tags, 2)), (GtkTextTag*)s7_c_pointer(s7_list_ref(sc, tags, 3)), NULL); break;
        case 5: gtk_text_buffer_insert_with_tags(p_arg0, p_arg1, p_arg2, p_arg3, (GtkTextTag*)s7_c_pointer(s7_list_ref(sc, tags, 0)), (GtkTextTag*)s7_c_pointer(s7_list_ref(sc, tags, 1)), (GtkTextTag*)s7_c_pointer(s7_list_ref(sc, tags, 2)), (GtkTextTag*)s7_c_pointer(s7_list_ref(sc, tags, 3)), (GtkTextTag*)s7_c_pointer(s7_list_ref(sc, tags, 4)), NULL); break;
        case 6: gtk_text_buffer_insert_with_tags(p_arg0, p_arg1, p_arg2, p_arg3, (GtkTextTag*)s7_c_pointer(s7_list_ref(sc, tags, 0)), (GtkTextTag*)s7_c_pointer(s7_list_ref(sc, tags, 1)), (GtkTextTag*)s7_c_pointer(s7_list_ref(sc, tags, 2)), (GtkTextTag*)s7_c_pointer(s7_list_ref(sc, tags, 3)), (GtkTextTag*)s7_c_pointer(s7_list_ref(sc, tags, 4)), (GtkTextTag*)s7_c_pointer(s7_list_ref(sc, tags, 5)), NULL); break;
      }
    return(lg_false);
  }
}

static s7_pointer lg_gtk_text_buffer_insert_with_tags_by_name(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_insert_with_tags_by_name "void gtk_text_buffer_insert_with_tags_by_name(GtkTextBuffer* buffer, \
GtkTextIter* iter, gchar* text, gint len, etc tags)"
  s7_pointer _p;
  s7_pointer buffer, iter, text, len, tags;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(buffer, GtkTextBuffer__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_insert_with_tags_by_name", 1, buffer, "GtkTextBuffer*");
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_insert_with_tags_by_name", 2, iter, "GtkTextIter*");
  text = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(text)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_insert_with_tags_by_name", 3, text, "gchar*");
  len = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(len)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_insert_with_tags_by_name", 4, len, "gint");
  tags = s7_car(_p);
  if (!lg_is_list(tags)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_insert_with_tags_by_name", 5, tags, "etc");
  {
    int etc_len = 0;
    GtkTextBuffer* p_arg0;
    GtkTextIter* p_arg1;
    gchar* p_arg2;
    gint p_arg3;
    if (s7_is_list(sc, tags)) etc_len = s7_list_length(sc, tags);
    if (etc_len < 1) s7_out_of_range_error(sc, "gtk_text_buffer_insert_with_tags_by_name", 4, tags, "... list must have at least 1 entry");
    if (etc_len > 6) s7_out_of_range_error(sc, "gtk_text_buffer_insert_with_tags_by_name", 4, tags, "... list too long (max len: 6)");
    if ((etc_len % 2) != 0) s7_out_of_range_error(sc, "gtk_text_buffer_insert_with_tags_by_name", 4, tags, "... list len must be multiple of 2");
    p_arg0 = (GtkTextBuffer*)s7_c_pointer(buffer);
    p_arg1 = (GtkTextIter*)s7_c_pointer(iter);
    p_arg2 = (gchar*)s7_string(text);
    p_arg3 = (gint)s7_integer(len);
    switch (etc_len)
      {
        case 1: gtk_text_buffer_insert_with_tags_by_name(p_arg0, p_arg1, p_arg2, p_arg3, s7_string(s7_list_ref(sc, tags, 0)), NULL); break;
        case 3: gtk_text_buffer_insert_with_tags_by_name(p_arg0, p_arg1, p_arg2, p_arg3, s7_string(s7_list_ref(sc, tags, 0)), s7_integer(s7_list_ref(sc, tags, 1)), s7_string(s7_list_ref(sc, tags, 2)), NULL); break;
        case 5: gtk_text_buffer_insert_with_tags_by_name(p_arg0, p_arg1, p_arg2, p_arg3, s7_string(s7_list_ref(sc, tags, 0)), s7_integer(s7_list_ref(sc, tags, 1)), s7_string(s7_list_ref(sc, tags, 2)), s7_integer(s7_list_ref(sc, tags, 3)), s7_string(s7_list_ref(sc, tags, 4)), NULL); break;
      }
    return(lg_false);
  }
}

static s7_pointer lg_gtk_text_buffer_delete(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_delete "void gtk_text_buffer_delete(GtkTextBuffer* buffer, GtkTextIter* start, \
GtkTextIter* end)"
  s7_pointer _p;
  s7_pointer buffer, start, end;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(buffer, GtkTextBuffer__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_delete", 1, buffer, "GtkTextBuffer*");
  start = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(start, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_delete", 2, start, "GtkTextIter*");
  end = s7_car(_p);
  if (!s7_is_c_pointer_of_type(end, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_delete", 3, end, "GtkTextIter*");
  gtk_text_buffer_delete((GtkTextBuffer*)s7_c_pointer(buffer), (GtkTextIter*)s7_c_pointer(start), (GtkTextIter*)s7_c_pointer(end));
  return(lg_false);
}

static s7_pointer lg_gtk_text_buffer_delete_interactive(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_delete_interactive "gboolean gtk_text_buffer_delete_interactive(GtkTextBuffer* buffer, \
GtkTextIter* start_iter, GtkTextIter* end_iter, gboolean default_editable)"
  s7_pointer _p;
  s7_pointer buffer, start_iter, end_iter, default_editable;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(buffer, GtkTextBuffer__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_delete_interactive", 1, buffer, "GtkTextBuffer*");
  start_iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(start_iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_delete_interactive", 2, start_iter, "GtkTextIter*");
  end_iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(end_iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_delete_interactive", 3, end_iter, "GtkTextIter*");
  default_editable = s7_car(_p);
  if (!s7_is_boolean(default_editable)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_delete_interactive", 4, default_editable, "gboolean");
  return(s7_make_boolean(sc, gtk_text_buffer_delete_interactive((GtkTextBuffer*)s7_c_pointer(buffer), (GtkTextIter*)s7_c_pointer(start_iter), (GtkTextIter*)s7_c_pointer(end_iter), (gboolean)lg_boolean(default_editable))));
}

static s7_pointer lg_gtk_text_buffer_get_text(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_get_text "gchar* gtk_text_buffer_get_text(GtkTextBuffer* buffer, GtkTextIter* start, \
GtkTextIter* end, gboolean include_hidden_chars)"
  s7_pointer _p;
  s7_pointer buffer, start, end, include_hidden_chars;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(buffer, GtkTextBuffer__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_get_text", 1, buffer, "GtkTextBuffer*");
  start = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(start, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_get_text", 2, start, "GtkTextIter*");
  end = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(end, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_get_text", 3, end, "GtkTextIter*");
  include_hidden_chars = s7_car(_p);
  if (!s7_is_boolean(include_hidden_chars)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_get_text", 4, include_hidden_chars, "gboolean");
  {
    gchar* res_ult;
    s7_pointer rtn;
    res_ult = gtk_text_buffer_get_text((GtkTextBuffer*)s7_c_pointer(buffer), (GtkTextIter*)s7_c_pointer(start), (GtkTextIter*)s7_c_pointer(end), (gboolean)lg_boolean(include_hidden_chars));
    rtn = s7_make_string(sc, res_ult);
    g_free(res_ult);
    return(rtn);
  }
}

static s7_pointer lg_gtk_text_buffer_get_slice(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_get_slice "gchar* gtk_text_buffer_get_slice(GtkTextBuffer* buffer, GtkTextIter* start, \
GtkTextIter* end, gboolean include_hidden_chars)"
  s7_pointer _p;
  s7_pointer buffer, start, end, include_hidden_chars;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(buffer, GtkTextBuffer__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_get_slice", 1, buffer, "GtkTextBuffer*");
  start = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(start, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_get_slice", 2, start, "GtkTextIter*");
  end = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(end, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_get_slice", 3, end, "GtkTextIter*");
  include_hidden_chars = s7_car(_p);
  if (!s7_is_boolean(include_hidden_chars)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_get_slice", 4, include_hidden_chars, "gboolean");
  {
    gchar* res_ult;
    s7_pointer rtn;
    res_ult = gtk_text_buffer_get_slice((GtkTextBuffer*)s7_c_pointer(buffer), (GtkTextIter*)s7_c_pointer(start), (GtkTextIter*)s7_c_pointer(end), (gboolean)lg_boolean(include_hidden_chars));
    rtn = s7_make_string(sc, res_ult);
    g_free(res_ult);
    return(rtn);
  }
}

static s7_pointer lg_gtk_text_buffer_insert_child_anchor(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_insert_child_anchor "void gtk_text_buffer_insert_child_anchor(GtkTextBuffer* buffer, \
GtkTextIter* iter, GtkTextChildAnchor* anchor)"
  s7_pointer _p;
  s7_pointer buffer, iter, anchor;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(buffer, GtkTextBuffer__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_insert_child_anchor", 1, buffer, "GtkTextBuffer*");
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_insert_child_anchor", 2, iter, "GtkTextIter*");
  anchor = s7_car(_p);
  if (!s7_is_c_pointer_of_type(anchor, GtkTextChildAnchor__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_insert_child_anchor", 3, anchor, "GtkTextChildAnchor*");
  gtk_text_buffer_insert_child_anchor((GtkTextBuffer*)s7_c_pointer(buffer), (GtkTextIter*)s7_c_pointer(iter), (GtkTextChildAnchor*)s7_c_pointer(anchor));
  return(lg_false);
}

static s7_pointer lg_gtk_text_buffer_create_child_anchor(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_create_child_anchor "GtkTextChildAnchor* gtk_text_buffer_create_child_anchor(GtkTextBuffer* buffer, \
GtkTextIter* iter)"
  s7_pointer _p;
  s7_pointer buffer, iter;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(buffer, GtkTextBuffer__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_create_child_anchor", 1, buffer, "GtkTextBuffer*");
  iter = s7_car(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_create_child_anchor", 2, iter, "GtkTextIter*");
  return(lg_make_c_pointer_with_type(sc, GtkTextChildAnchor__sym, gtk_text_buffer_create_child_anchor((GtkTextBuffer*)s7_c_pointer(buffer), (GtkTextIter*)s7_c_pointer(iter))));
}

static s7_pointer lg_gtk_text_buffer_create_mark(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_create_mark "GtkTextMark* gtk_text_buffer_create_mark(GtkTextBuffer* buffer, \
gchar* mark_name, GtkTextIter* where, gboolean left_gravity)"
  s7_pointer _p;
  s7_pointer buffer, mark_name, where, left_gravity;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(buffer, GtkTextBuffer__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_create_mark", 1, buffer, "GtkTextBuffer*");
  mark_name = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(mark_name)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_create_mark", 2, mark_name, "gchar*");
  where = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(where, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_create_mark", 3, where, "GtkTextIter*");
  left_gravity = s7_car(_p);
  if (!s7_is_boolean(left_gravity)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_create_mark", 4, left_gravity, "gboolean");
  return(lg_make_c_pointer_with_type(sc, GtkTextMark__sym, gtk_text_buffer_create_mark((GtkTextBuffer*)s7_c_pointer(buffer), (gchar*)s7_string(mark_name), (GtkTextIter*)s7_c_pointer(where), (gboolean)lg_boolean(left_gravity))));
}

static s7_pointer lg_gtk_text_buffer_move_mark(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_move_mark "void gtk_text_buffer_move_mark(GtkTextBuffer* buffer, GtkTextMark* mark, \
GtkTextIter* where)"
  s7_pointer _p;
  s7_pointer buffer, mark, where;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(buffer, GtkTextBuffer__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_move_mark", 1, buffer, "GtkTextBuffer*");
  mark = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(mark, GtkTextMark__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_move_mark", 2, mark, "GtkTextMark*");
  where = s7_car(_p);
  if (!s7_is_c_pointer_of_type(where, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_move_mark", 3, where, "GtkTextIter*");
  gtk_text_buffer_move_mark((GtkTextBuffer*)s7_c_pointer(buffer), (GtkTextMark*)s7_c_pointer(mark), (GtkTextIter*)s7_c_pointer(where));
  return(lg_false);
}

static s7_pointer lg_gtk_text_buffer_delete_mark(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_delete_mark "void gtk_text_buffer_delete_mark(GtkTextBuffer* buffer, GtkTextMark* mark)"
  s7_pointer _p;
  s7_pointer buffer, mark;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(buffer, GtkTextBuffer__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_delete_mark", 1, buffer, "GtkTextBuffer*");
  mark = s7_car(_p);
  if (!s7_is_c_pointer_of_type(mark, GtkTextMark__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_delete_mark", 2, mark, "GtkTextMark*");
  gtk_text_buffer_delete_mark((GtkTextBuffer*)s7_c_pointer(buffer), (GtkTextMark*)s7_c_pointer(mark));
  return(lg_false);
}

static s7_pointer lg_gtk_text_buffer_get_mark(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_get_mark "GtkTextMark* gtk_text_buffer_get_mark(GtkTextBuffer* buffer, gchar* name)"
  s7_pointer _p;
  s7_pointer buffer, name;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(buffer, GtkTextBuffer__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_get_mark", 1, buffer, "GtkTextBuffer*");
  name = s7_car(_p);
  if (!s7_is_string(name)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_get_mark", 2, name, "gchar*");
  return(lg_make_c_pointer_with_type(sc, GtkTextMark__sym, gtk_text_buffer_get_mark((GtkTextBuffer*)s7_c_pointer(buffer), (gchar*)s7_string(name))));
}

static s7_pointer lg_gtk_text_buffer_move_mark_by_name(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_move_mark_by_name "void gtk_text_buffer_move_mark_by_name(GtkTextBuffer* buffer, \
gchar* name, GtkTextIter* where)"
  s7_pointer _p;
  s7_pointer buffer, name, where;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(buffer, GtkTextBuffer__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_move_mark_by_name", 1, buffer, "GtkTextBuffer*");
  name = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(name)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_move_mark_by_name", 2, name, "gchar*");
  where = s7_car(_p);
  if (!s7_is_c_pointer_of_type(where, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_move_mark_by_name", 3, where, "GtkTextIter*");
  gtk_text_buffer_move_mark_by_name((GtkTextBuffer*)s7_c_pointer(buffer), (gchar*)s7_string(name), (GtkTextIter*)s7_c_pointer(where));
  return(lg_false);
}

static s7_pointer lg_gtk_text_buffer_delete_mark_by_name(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_delete_mark_by_name "void gtk_text_buffer_delete_mark_by_name(GtkTextBuffer* buffer, \
gchar* name)"
  s7_pointer _p;
  s7_pointer buffer, name;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(buffer, GtkTextBuffer__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_delete_mark_by_name", 1, buffer, "GtkTextBuffer*");
  name = s7_car(_p);
  if (!s7_is_string(name)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_delete_mark_by_name", 2, name, "gchar*");
  gtk_text_buffer_delete_mark_by_name((GtkTextBuffer*)s7_c_pointer(buffer), (gchar*)s7_string(name));
  return(lg_false);
}

static s7_pointer lg_gtk_text_buffer_get_insert(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_get_insert "GtkTextMark* gtk_text_buffer_get_insert(GtkTextBuffer* buffer)"
  s7_pointer buffer;
  buffer = s7_car(args);
  if (!s7_is_c_pointer_of_type(buffer, GtkTextBuffer__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_get_insert", 1, buffer, "GtkTextBuffer*");
  return(lg_make_c_pointer_with_type(sc, GtkTextMark__sym, gtk_text_buffer_get_insert((GtkTextBuffer*)s7_c_pointer(buffer))));
}

static s7_pointer lg_gtk_text_buffer_get_selection_bound(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_get_selection_bound "GtkTextMark* gtk_text_buffer_get_selection_bound(GtkTextBuffer* buffer)"
  s7_pointer buffer;
  buffer = s7_car(args);
  if (!s7_is_c_pointer_of_type(buffer, GtkTextBuffer__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_get_selection_bound", 1, buffer, "GtkTextBuffer*");
  return(lg_make_c_pointer_with_type(sc, GtkTextMark__sym, gtk_text_buffer_get_selection_bound((GtkTextBuffer*)s7_c_pointer(buffer))));
}

static s7_pointer lg_gtk_text_buffer_place_cursor(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_place_cursor "void gtk_text_buffer_place_cursor(GtkTextBuffer* buffer, GtkTextIter* where)"
  s7_pointer _p;
  s7_pointer buffer, where;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(buffer, GtkTextBuffer__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_place_cursor", 1, buffer, "GtkTextBuffer*");
  where = s7_car(_p);
  if (!s7_is_c_pointer_of_type(where, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_place_cursor", 2, where, "GtkTextIter*");
  gtk_text_buffer_place_cursor((GtkTextBuffer*)s7_c_pointer(buffer), (GtkTextIter*)s7_c_pointer(where));
  return(lg_false);
}

static s7_pointer lg_gtk_text_buffer_apply_tag(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_apply_tag "void gtk_text_buffer_apply_tag(GtkTextBuffer* buffer, GtkTextTag* tag, \
GtkTextIter* start, GtkTextIter* end)"
  s7_pointer _p;
  s7_pointer buffer, tag, start, end;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(buffer, GtkTextBuffer__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_apply_tag", 1, buffer, "GtkTextBuffer*");
  tag = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tag, GtkTextTag__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_apply_tag", 2, tag, "GtkTextTag*");
  start = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(start, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_apply_tag", 3, start, "GtkTextIter*");
  end = s7_car(_p);
  if (!s7_is_c_pointer_of_type(end, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_apply_tag", 4, end, "GtkTextIter*");
  gtk_text_buffer_apply_tag((GtkTextBuffer*)s7_c_pointer(buffer), (GtkTextTag*)s7_c_pointer(tag), (GtkTextIter*)s7_c_pointer(start), (GtkTextIter*)s7_c_pointer(end));
  return(lg_false);
}

static s7_pointer lg_gtk_text_buffer_remove_tag(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_remove_tag "void gtk_text_buffer_remove_tag(GtkTextBuffer* buffer, GtkTextTag* tag, \
GtkTextIter* start, GtkTextIter* end)"
  s7_pointer _p;
  s7_pointer buffer, tag, start, end;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(buffer, GtkTextBuffer__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_remove_tag", 1, buffer, "GtkTextBuffer*");
  tag = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tag, GtkTextTag__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_remove_tag", 2, tag, "GtkTextTag*");
  start = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(start, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_remove_tag", 3, start, "GtkTextIter*");
  end = s7_car(_p);
  if (!s7_is_c_pointer_of_type(end, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_remove_tag", 4, end, "GtkTextIter*");
  gtk_text_buffer_remove_tag((GtkTextBuffer*)s7_c_pointer(buffer), (GtkTextTag*)s7_c_pointer(tag), (GtkTextIter*)s7_c_pointer(start), (GtkTextIter*)s7_c_pointer(end));
  return(lg_false);
}

static s7_pointer lg_gtk_text_buffer_apply_tag_by_name(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_apply_tag_by_name "void gtk_text_buffer_apply_tag_by_name(GtkTextBuffer* buffer, \
gchar* name, GtkTextIter* start, GtkTextIter* end)"
  s7_pointer _p;
  s7_pointer buffer, name, start, end;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(buffer, GtkTextBuffer__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_apply_tag_by_name", 1, buffer, "GtkTextBuffer*");
  name = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(name)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_apply_tag_by_name", 2, name, "gchar*");
  start = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(start, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_apply_tag_by_name", 3, start, "GtkTextIter*");
  end = s7_car(_p);
  if (!s7_is_c_pointer_of_type(end, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_apply_tag_by_name", 4, end, "GtkTextIter*");
  gtk_text_buffer_apply_tag_by_name((GtkTextBuffer*)s7_c_pointer(buffer), (gchar*)s7_string(name), (GtkTextIter*)s7_c_pointer(start), (GtkTextIter*)s7_c_pointer(end));
  return(lg_false);
}

static s7_pointer lg_gtk_text_buffer_remove_tag_by_name(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_remove_tag_by_name "void gtk_text_buffer_remove_tag_by_name(GtkTextBuffer* buffer, \
gchar* name, GtkTextIter* start, GtkTextIter* end)"
  s7_pointer _p;
  s7_pointer buffer, name, start, end;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(buffer, GtkTextBuffer__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_remove_tag_by_name", 1, buffer, "GtkTextBuffer*");
  name = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(name)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_remove_tag_by_name", 2, name, "gchar*");
  start = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(start, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_remove_tag_by_name", 3, start, "GtkTextIter*");
  end = s7_car(_p);
  if (!s7_is_c_pointer_of_type(end, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_remove_tag_by_name", 4, end, "GtkTextIter*");
  gtk_text_buffer_remove_tag_by_name((GtkTextBuffer*)s7_c_pointer(buffer), (gchar*)s7_string(name), (GtkTextIter*)s7_c_pointer(start), (GtkTextIter*)s7_c_pointer(end));
  return(lg_false);
}

static s7_pointer lg_gtk_text_buffer_remove_all_tags(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_remove_all_tags "void gtk_text_buffer_remove_all_tags(GtkTextBuffer* buffer, \
GtkTextIter* start, GtkTextIter* end)"
  s7_pointer _p;
  s7_pointer buffer, start, end;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(buffer, GtkTextBuffer__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_remove_all_tags", 1, buffer, "GtkTextBuffer*");
  start = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(start, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_remove_all_tags", 2, start, "GtkTextIter*");
  end = s7_car(_p);
  if (!s7_is_c_pointer_of_type(end, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_remove_all_tags", 3, end, "GtkTextIter*");
  gtk_text_buffer_remove_all_tags((GtkTextBuffer*)s7_c_pointer(buffer), (GtkTextIter*)s7_c_pointer(start), (GtkTextIter*)s7_c_pointer(end));
  return(lg_false);
}

static s7_pointer lg_gtk_text_buffer_create_tag(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_create_tag "GtkTextTag* gtk_text_buffer_create_tag(GtkTextBuffer* buffer, \
gchar* tag_name, etc tags)"
  s7_pointer _p;
  s7_pointer buffer, tag_name, tags;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(buffer, GtkTextBuffer__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_create_tag", 1, buffer, "GtkTextBuffer*");
  tag_name = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(tag_name)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_create_tag", 2, tag_name, "gchar*");
  tags = s7_car(_p);
  if ((!lg_is_list(tags)) && (tags != lg_false)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_create_tag", 3, tags, "etc");
  {
    int etc_len = 0;
    GtkTextTag* res_ult = NULL;
    GtkTextBuffer* p_arg0;
    gchar* p_arg1;
    if (s7_is_list(sc, tags)) etc_len = s7_list_length(sc, tags);
    if (etc_len > 6) s7_out_of_range_error(sc, "gtk_text_buffer_create_tag", 2, tags, "... list too long (max len: 6)");
    if ((etc_len % 2) != 0) s7_out_of_range_error(sc, "gtk_text_buffer_create_tag", 2, tags, "... list len must be multiple of 2");
    p_arg0 = (GtkTextBuffer*)s7_c_pointer(buffer);
    p_arg1 = (gchar*)s7_string(tag_name);
    switch (etc_len)
      {
        case 0: res_ult = gtk_text_buffer_create_tag(p_arg0, p_arg1, NULL); break;
        case 2: res_ult = gtk_text_buffer_create_tag(p_arg0, p_arg1, s7_string(s7_list_ref(sc, tags, 0)), s7_c_pointer(s7_list_ref(sc, tags, 1)), NULL); break;
        case 4: res_ult = gtk_text_buffer_create_tag(p_arg0, p_arg1, s7_string(s7_list_ref(sc, tags, 0)), s7_c_pointer(s7_list_ref(sc, tags, 1)), s7_string(s7_list_ref(sc, tags, 2)), s7_c_pointer(s7_list_ref(sc, tags, 3)), NULL); break;
        case 6: res_ult = gtk_text_buffer_create_tag(p_arg0, p_arg1, s7_string(s7_list_ref(sc, tags, 0)), s7_c_pointer(s7_list_ref(sc, tags, 1)), s7_string(s7_list_ref(sc, tags, 2)), s7_c_pointer(s7_list_ref(sc, tags, 3)), s7_string(s7_list_ref(sc, tags, 4)), s7_c_pointer(s7_list_ref(sc, tags, 5)), NULL); break;
      }
    return(s7_make_c_pointer(sc, res_ult));
  }
}

static s7_pointer lg_gtk_text_buffer_get_iter_at_line_offset(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_get_iter_at_line_offset "void gtk_text_buffer_get_iter_at_line_offset(GtkTextBuffer* buffer, \
GtkTextIter* iter, gint line_number, gint char_offset)"
  s7_pointer _p;
  s7_pointer buffer, iter, line_number, char_offset;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(buffer, GtkTextBuffer__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_get_iter_at_line_offset", 1, buffer, "GtkTextBuffer*");
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_get_iter_at_line_offset", 2, iter, "GtkTextIter*");
  line_number = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(line_number)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_get_iter_at_line_offset", 3, line_number, "gint");
  char_offset = s7_car(_p);
  if (!s7_is_integer(char_offset)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_get_iter_at_line_offset", 4, char_offset, "gint");
  gtk_text_buffer_get_iter_at_line_offset((GtkTextBuffer*)s7_c_pointer(buffer), (GtkTextIter*)s7_c_pointer(iter), (gint)s7_integer(line_number), (gint)s7_integer(char_offset));
  return(lg_false);
}

static s7_pointer lg_gtk_text_buffer_get_iter_at_line_index(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_get_iter_at_line_index "void gtk_text_buffer_get_iter_at_line_index(GtkTextBuffer* buffer, \
GtkTextIter* iter, gint line_number, gint byte_index)"
  s7_pointer _p;
  s7_pointer buffer, iter, line_number, byte_index;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(buffer, GtkTextBuffer__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_get_iter_at_line_index", 1, buffer, "GtkTextBuffer*");
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_get_iter_at_line_index", 2, iter, "GtkTextIter*");
  line_number = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(line_number)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_get_iter_at_line_index", 3, line_number, "gint");
  byte_index = s7_car(_p);
  if (!s7_is_integer(byte_index)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_get_iter_at_line_index", 4, byte_index, "gint");
  gtk_text_buffer_get_iter_at_line_index((GtkTextBuffer*)s7_c_pointer(buffer), (GtkTextIter*)s7_c_pointer(iter), (gint)s7_integer(line_number), (gint)s7_integer(byte_index));
  return(lg_false);
}

static s7_pointer lg_gtk_text_buffer_get_iter_at_offset(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_get_iter_at_offset "void gtk_text_buffer_get_iter_at_offset(GtkTextBuffer* buffer, \
GtkTextIter* iter, gint char_offset)"
  s7_pointer _p;
  s7_pointer buffer, iter, char_offset;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(buffer, GtkTextBuffer__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_get_iter_at_offset", 1, buffer, "GtkTextBuffer*");
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_get_iter_at_offset", 2, iter, "GtkTextIter*");
  char_offset = s7_car(_p);
  if (!s7_is_integer(char_offset)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_get_iter_at_offset", 3, char_offset, "gint");
  gtk_text_buffer_get_iter_at_offset((GtkTextBuffer*)s7_c_pointer(buffer), (GtkTextIter*)s7_c_pointer(iter), (gint)s7_integer(char_offset));
  return(lg_false);
}

static s7_pointer lg_gtk_text_buffer_get_iter_at_line(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_get_iter_at_line "void gtk_text_buffer_get_iter_at_line(GtkTextBuffer* buffer, \
GtkTextIter* iter, gint line_number)"
  s7_pointer _p;
  s7_pointer buffer, iter, line_number;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(buffer, GtkTextBuffer__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_get_iter_at_line", 1, buffer, "GtkTextBuffer*");
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_get_iter_at_line", 2, iter, "GtkTextIter*");
  line_number = s7_car(_p);
  if (!s7_is_integer(line_number)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_get_iter_at_line", 3, line_number, "gint");
  gtk_text_buffer_get_iter_at_line((GtkTextBuffer*)s7_c_pointer(buffer), (GtkTextIter*)s7_c_pointer(iter), (gint)s7_integer(line_number));
  return(lg_false);
}

static s7_pointer lg_gtk_text_buffer_get_start_iter(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_get_start_iter "void gtk_text_buffer_get_start_iter(GtkTextBuffer* buffer, \
GtkTextIter* iter)"
  s7_pointer _p;
  s7_pointer buffer, iter;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(buffer, GtkTextBuffer__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_get_start_iter", 1, buffer, "GtkTextBuffer*");
  iter = s7_car(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_get_start_iter", 2, iter, "GtkTextIter*");
  gtk_text_buffer_get_start_iter((GtkTextBuffer*)s7_c_pointer(buffer), (GtkTextIter*)s7_c_pointer(iter));
  return(lg_false);
}

static s7_pointer lg_gtk_text_buffer_get_end_iter(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_get_end_iter "void gtk_text_buffer_get_end_iter(GtkTextBuffer* buffer, GtkTextIter* iter)"
  s7_pointer _p;
  s7_pointer buffer, iter;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(buffer, GtkTextBuffer__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_get_end_iter", 1, buffer, "GtkTextBuffer*");
  iter = s7_car(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_get_end_iter", 2, iter, "GtkTextIter*");
  gtk_text_buffer_get_end_iter((GtkTextBuffer*)s7_c_pointer(buffer), (GtkTextIter*)s7_c_pointer(iter));
  return(lg_false);
}

static s7_pointer lg_gtk_text_buffer_get_bounds(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_get_bounds "void gtk_text_buffer_get_bounds(GtkTextBuffer* buffer, GtkTextIter* start, \
GtkTextIter* end)"
  s7_pointer _p;
  s7_pointer buffer, start, end;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(buffer, GtkTextBuffer__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_get_bounds", 1, buffer, "GtkTextBuffer*");
  start = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(start, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_get_bounds", 2, start, "GtkTextIter*");
  end = s7_car(_p);
  if (!s7_is_c_pointer_of_type(end, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_get_bounds", 3, end, "GtkTextIter*");
  gtk_text_buffer_get_bounds((GtkTextBuffer*)s7_c_pointer(buffer), (GtkTextIter*)s7_c_pointer(start), (GtkTextIter*)s7_c_pointer(end));
  return(lg_false);
}

static s7_pointer lg_gtk_text_buffer_get_iter_at_mark(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_get_iter_at_mark "void gtk_text_buffer_get_iter_at_mark(GtkTextBuffer* buffer, \
GtkTextIter* iter, GtkTextMark* mark)"
  s7_pointer _p;
  s7_pointer buffer, iter, mark;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(buffer, GtkTextBuffer__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_get_iter_at_mark", 1, buffer, "GtkTextBuffer*");
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_get_iter_at_mark", 2, iter, "GtkTextIter*");
  mark = s7_car(_p);
  if (!s7_is_c_pointer_of_type(mark, GtkTextMark__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_get_iter_at_mark", 3, mark, "GtkTextMark*");
  gtk_text_buffer_get_iter_at_mark((GtkTextBuffer*)s7_c_pointer(buffer), (GtkTextIter*)s7_c_pointer(iter), (GtkTextMark*)s7_c_pointer(mark));
  return(lg_false);
}

static s7_pointer lg_gtk_text_buffer_get_iter_at_child_anchor(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_get_iter_at_child_anchor "void gtk_text_buffer_get_iter_at_child_anchor(GtkTextBuffer* buffer, \
GtkTextIter* iter, GtkTextChildAnchor* anchor)"
  s7_pointer _p;
  s7_pointer buffer, iter, anchor;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(buffer, GtkTextBuffer__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_get_iter_at_child_anchor", 1, buffer, "GtkTextBuffer*");
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_get_iter_at_child_anchor", 2, iter, "GtkTextIter*");
  anchor = s7_car(_p);
  if (!s7_is_c_pointer_of_type(anchor, GtkTextChildAnchor__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_get_iter_at_child_anchor", 3, anchor, "GtkTextChildAnchor*");
  gtk_text_buffer_get_iter_at_child_anchor((GtkTextBuffer*)s7_c_pointer(buffer), (GtkTextIter*)s7_c_pointer(iter), (GtkTextChildAnchor*)s7_c_pointer(anchor));
  return(lg_false);
}

static s7_pointer lg_gtk_text_buffer_get_modified(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_get_modified "gboolean gtk_text_buffer_get_modified(GtkTextBuffer* buffer)"
  s7_pointer buffer;
  buffer = s7_car(args);
  if (!s7_is_c_pointer_of_type(buffer, GtkTextBuffer__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_get_modified", 1, buffer, "GtkTextBuffer*");
  return(s7_make_boolean(sc, gtk_text_buffer_get_modified((GtkTextBuffer*)s7_c_pointer(buffer))));
}

static s7_pointer lg_gtk_text_buffer_set_modified(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_set_modified "void gtk_text_buffer_set_modified(GtkTextBuffer* buffer, gboolean setting)"
  s7_pointer _p;
  s7_pointer buffer, setting;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(buffer, GtkTextBuffer__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_set_modified", 1, buffer, "GtkTextBuffer*");
  setting = s7_car(_p);
  if (!s7_is_boolean(setting)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_set_modified", 2, setting, "gboolean");
  gtk_text_buffer_set_modified((GtkTextBuffer*)s7_c_pointer(buffer), (gboolean)lg_boolean(setting));
  return(lg_false);
}

static s7_pointer lg_gtk_text_buffer_get_selection_bounds(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_get_selection_bounds "gboolean gtk_text_buffer_get_selection_bounds(GtkTextBuffer* buffer, \
GtkTextIter* start, GtkTextIter* end)"
  s7_pointer _p;
  s7_pointer buffer, start, end;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(buffer, GtkTextBuffer__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_get_selection_bounds", 1, buffer, "GtkTextBuffer*");
  start = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(start, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_get_selection_bounds", 2, start, "GtkTextIter*");
  end = s7_car(_p);
  if (!s7_is_c_pointer_of_type(end, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_get_selection_bounds", 3, end, "GtkTextIter*");
  return(s7_make_boolean(sc, gtk_text_buffer_get_selection_bounds((GtkTextBuffer*)s7_c_pointer(buffer), (GtkTextIter*)s7_c_pointer(start), (GtkTextIter*)s7_c_pointer(end))));
}

static s7_pointer lg_gtk_text_buffer_delete_selection(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_delete_selection "gboolean gtk_text_buffer_delete_selection(GtkTextBuffer* buffer, \
gboolean interactive, gboolean default_editable)"
  s7_pointer _p;
  s7_pointer buffer, interactive, default_editable;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(buffer, GtkTextBuffer__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_delete_selection", 1, buffer, "GtkTextBuffer*");
  interactive = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_boolean(interactive)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_delete_selection", 2, interactive, "gboolean");
  default_editable = s7_car(_p);
  if (!s7_is_boolean(default_editable)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_delete_selection", 3, default_editable, "gboolean");
  return(s7_make_boolean(sc, gtk_text_buffer_delete_selection((GtkTextBuffer*)s7_c_pointer(buffer), (gboolean)lg_boolean(interactive), (gboolean)lg_boolean(default_editable))));
}

static s7_pointer lg_gtk_text_buffer_begin_user_action(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_begin_user_action "void gtk_text_buffer_begin_user_action(GtkTextBuffer* buffer)"
  s7_pointer buffer;
  buffer = s7_car(args);
  if (!s7_is_c_pointer_of_type(buffer, GtkTextBuffer__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_begin_user_action", 1, buffer, "GtkTextBuffer*");
  gtk_text_buffer_begin_user_action((GtkTextBuffer*)s7_c_pointer(buffer));
  return(lg_false);
}

static s7_pointer lg_gtk_text_buffer_end_user_action(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_end_user_action "void gtk_text_buffer_end_user_action(GtkTextBuffer* buffer)"
  s7_pointer buffer;
  buffer = s7_car(args);
  if (!s7_is_c_pointer_of_type(buffer, GtkTextBuffer__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_end_user_action", 1, buffer, "GtkTextBuffer*");
  gtk_text_buffer_end_user_action((GtkTextBuffer*)s7_c_pointer(buffer));
  return(lg_false);
}

static s7_pointer lg_gtk_text_child_anchor_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_child_anchor_new "GtkTextChildAnchor* gtk_text_child_anchor_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkTextChildAnchor__sym, gtk_text_child_anchor_new()));
}

static s7_pointer lg_gtk_text_child_anchor_get_deleted(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_child_anchor_get_deleted "gboolean gtk_text_child_anchor_get_deleted(GtkTextChildAnchor* anchor)"
  s7_pointer anchor;
  anchor = s7_car(args);
  if (!s7_is_c_pointer_of_type(anchor, GtkTextChildAnchor__sym)) s7_wrong_type_arg_error(sc, "gtk_text_child_anchor_get_deleted", 1, anchor, "GtkTextChildAnchor*");
  return(s7_make_boolean(sc, gtk_text_child_anchor_get_deleted((GtkTextChildAnchor*)s7_c_pointer(anchor))));
}

static s7_pointer lg_gtk_text_iter_get_buffer(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_get_buffer "GtkTextBuffer* gtk_text_iter_get_buffer(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_get_buffer", 1, iter, "GtkTextIter*");
  return(lg_make_c_pointer_with_type(sc, GtkTextBuffer__sym, gtk_text_iter_get_buffer((GtkTextIter*)s7_c_pointer(iter))));
}

static s7_pointer lg_gtk_text_iter_copy(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_copy "GtkTextIter* gtk_text_iter_copy(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_copy", 1, iter, "GtkTextIter*");
  return(lg_make_c_pointer_with_type(sc, GtkTextIter__sym, gtk_text_iter_copy((GtkTextIter*)s7_c_pointer(iter))));
}

static s7_pointer lg_gtk_text_iter_free(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_free "void gtk_text_iter_free(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_free", 1, iter, "GtkTextIter*");
  gtk_text_iter_free((GtkTextIter*)s7_c_pointer(iter));
  return(lg_false);
}

static s7_pointer lg_gtk_text_iter_get_offset(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_get_offset "gint gtk_text_iter_get_offset(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_get_offset", 1, iter, "GtkTextIter*");
  return(s7_make_integer(sc, gtk_text_iter_get_offset((GtkTextIter*)s7_c_pointer(iter))));
}

static s7_pointer lg_gtk_text_iter_get_line(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_get_line "gint gtk_text_iter_get_line(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_get_line", 1, iter, "GtkTextIter*");
  return(s7_make_integer(sc, gtk_text_iter_get_line((GtkTextIter*)s7_c_pointer(iter))));
}

static s7_pointer lg_gtk_text_iter_get_line_offset(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_get_line_offset "gint gtk_text_iter_get_line_offset(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_get_line_offset", 1, iter, "GtkTextIter*");
  return(s7_make_integer(sc, gtk_text_iter_get_line_offset((GtkTextIter*)s7_c_pointer(iter))));
}

static s7_pointer lg_gtk_text_iter_get_line_index(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_get_line_index "gint gtk_text_iter_get_line_index(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_get_line_index", 1, iter, "GtkTextIter*");
  return(s7_make_integer(sc, gtk_text_iter_get_line_index((GtkTextIter*)s7_c_pointer(iter))));
}

static s7_pointer lg_gtk_text_iter_get_visible_line_offset(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_get_visible_line_offset "gint gtk_text_iter_get_visible_line_offset(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_get_visible_line_offset", 1, iter, "GtkTextIter*");
  return(s7_make_integer(sc, gtk_text_iter_get_visible_line_offset((GtkTextIter*)s7_c_pointer(iter))));
}

static s7_pointer lg_gtk_text_iter_get_visible_line_index(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_get_visible_line_index "gint gtk_text_iter_get_visible_line_index(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_get_visible_line_index", 1, iter, "GtkTextIter*");
  return(s7_make_integer(sc, gtk_text_iter_get_visible_line_index((GtkTextIter*)s7_c_pointer(iter))));
}

static s7_pointer lg_gtk_text_iter_get_char(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_get_char "gunichar gtk_text_iter_get_char(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_get_char", 1, iter, "GtkTextIter*");
  return(s7_make_integer(sc, gtk_text_iter_get_char((GtkTextIter*)s7_c_pointer(iter))));
}

static s7_pointer lg_gtk_text_iter_get_slice(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_get_slice "gchar* gtk_text_iter_get_slice(GtkTextIter* start, GtkTextIter* end)"
  s7_pointer _p;
  s7_pointer start, end;
  _p = args;
  start = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(start, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_get_slice", 1, start, "GtkTextIter*");
  end = s7_car(_p);
  if (!s7_is_c_pointer_of_type(end, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_get_slice", 2, end, "GtkTextIter*");
  {
    gchar* res_ult;
    s7_pointer rtn;
    res_ult = gtk_text_iter_get_slice((GtkTextIter*)s7_c_pointer(start), (GtkTextIter*)s7_c_pointer(end));
    rtn = s7_make_string(sc, res_ult);
    g_free(res_ult);
    return(rtn);
  }
}

static s7_pointer lg_gtk_text_iter_get_text(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_get_text "gchar* gtk_text_iter_get_text(GtkTextIter* start, GtkTextIter* end)"
  s7_pointer _p;
  s7_pointer start, end;
  _p = args;
  start = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(start, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_get_text", 1, start, "GtkTextIter*");
  end = s7_car(_p);
  if (!s7_is_c_pointer_of_type(end, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_get_text", 2, end, "GtkTextIter*");
  {
    gchar* res_ult;
    s7_pointer rtn;
    res_ult = gtk_text_iter_get_text((GtkTextIter*)s7_c_pointer(start), (GtkTextIter*)s7_c_pointer(end));
    rtn = s7_make_string(sc, res_ult);
    g_free(res_ult);
    return(rtn);
  }
}

static s7_pointer lg_gtk_text_iter_get_visible_slice(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_get_visible_slice "gchar* gtk_text_iter_get_visible_slice(GtkTextIter* start, \
GtkTextIter* end)"
  s7_pointer _p;
  s7_pointer start, end;
  _p = args;
  start = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(start, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_get_visible_slice", 1, start, "GtkTextIter*");
  end = s7_car(_p);
  if (!s7_is_c_pointer_of_type(end, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_get_visible_slice", 2, end, "GtkTextIter*");
  {
    gchar* res_ult;
    s7_pointer rtn;
    res_ult = gtk_text_iter_get_visible_slice((GtkTextIter*)s7_c_pointer(start), (GtkTextIter*)s7_c_pointer(end));
    rtn = s7_make_string(sc, res_ult);
    g_free(res_ult);
    return(rtn);
  }
}

static s7_pointer lg_gtk_text_iter_get_visible_text(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_get_visible_text "gchar* gtk_text_iter_get_visible_text(GtkTextIter* start, \
GtkTextIter* end)"
  s7_pointer _p;
  s7_pointer start, end;
  _p = args;
  start = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(start, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_get_visible_text", 1, start, "GtkTextIter*");
  end = s7_car(_p);
  if (!s7_is_c_pointer_of_type(end, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_get_visible_text", 2, end, "GtkTextIter*");
  {
    gchar* res_ult;
    s7_pointer rtn;
    res_ult = gtk_text_iter_get_visible_text((GtkTextIter*)s7_c_pointer(start), (GtkTextIter*)s7_c_pointer(end));
    rtn = s7_make_string(sc, res_ult);
    g_free(res_ult);
    return(rtn);
  }
}

static s7_pointer lg_gtk_text_iter_get_marks(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_get_marks "GSList* gtk_text_iter_get_marks(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_get_marks", 1, iter, "GtkTextIter*");
  return(lg_make_c_pointer_with_type(sc, GSList__sym, gtk_text_iter_get_marks((GtkTextIter*)s7_c_pointer(iter))));
}

static s7_pointer lg_gtk_text_iter_get_child_anchor(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_get_child_anchor "GtkTextChildAnchor* gtk_text_iter_get_child_anchor(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_get_child_anchor", 1, iter, "GtkTextIter*");
  return(lg_make_c_pointer_with_type(sc, GtkTextChildAnchor__sym, gtk_text_iter_get_child_anchor((GtkTextIter*)s7_c_pointer(iter))));
}

static s7_pointer lg_gtk_text_iter_get_toggled_tags(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_get_toggled_tags "GSList* gtk_text_iter_get_toggled_tags(GtkTextIter* iter, \
gboolean toggled_on)"
  s7_pointer _p;
  s7_pointer iter, toggled_on;
  _p = args;
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_get_toggled_tags", 1, iter, "GtkTextIter*");
  toggled_on = s7_car(_p);
  if (!s7_is_boolean(toggled_on)) s7_wrong_type_arg_error(sc, "gtk_text_iter_get_toggled_tags", 2, toggled_on, "gboolean");
  return(lg_make_c_pointer_with_type(sc, GSList__sym, gtk_text_iter_get_toggled_tags((GtkTextIter*)s7_c_pointer(iter), (gboolean)lg_boolean(toggled_on))));
}

static s7_pointer lg_gtk_text_iter_ends_tag(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_ends_tag "gboolean gtk_text_iter_ends_tag(GtkTextIter* iter, GtkTextTag* tag)"
  s7_pointer _p;
  s7_pointer iter, tag;
  _p = args;
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_ends_tag", 1, iter, "GtkTextIter*");
  tag = s7_car(_p);
  if ((!s7_is_c_pointer_of_type(tag, GtkTextTag__sym)) && (tag != lg_false)) s7_wrong_type_arg_error(sc, "gtk_text_iter_ends_tag", 2, tag, "GtkTextTag*");
  return(s7_make_boolean(sc, gtk_text_iter_ends_tag((GtkTextIter*)s7_c_pointer(iter), (GtkTextTag*)s7_c_pointer(tag))));
}

static s7_pointer lg_gtk_text_iter_toggles_tag(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_toggles_tag "gboolean gtk_text_iter_toggles_tag(GtkTextIter* iter, GtkTextTag* tag)"
  s7_pointer _p;
  s7_pointer iter, tag;
  _p = args;
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_toggles_tag", 1, iter, "GtkTextIter*");
  tag = s7_car(_p);
  if ((!s7_is_c_pointer_of_type(tag, GtkTextTag__sym)) && (tag != lg_false)) s7_wrong_type_arg_error(sc, "gtk_text_iter_toggles_tag", 2, tag, "GtkTextTag*");
  return(s7_make_boolean(sc, gtk_text_iter_toggles_tag((GtkTextIter*)s7_c_pointer(iter), (GtkTextTag*)s7_c_pointer(tag))));
}

static s7_pointer lg_gtk_text_iter_has_tag(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_has_tag "gboolean gtk_text_iter_has_tag(GtkTextIter* iter, GtkTextTag* tag)"
  s7_pointer _p;
  s7_pointer iter, tag;
  _p = args;
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_has_tag", 1, iter, "GtkTextIter*");
  tag = s7_car(_p);
  if (!s7_is_c_pointer_of_type(tag, GtkTextTag__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_has_tag", 2, tag, "GtkTextTag*");
  return(s7_make_boolean(sc, gtk_text_iter_has_tag((GtkTextIter*)s7_c_pointer(iter), (GtkTextTag*)s7_c_pointer(tag))));
}

static s7_pointer lg_gtk_text_iter_get_tags(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_get_tags "GSList* gtk_text_iter_get_tags(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_get_tags", 1, iter, "GtkTextIter*");
  return(lg_make_c_pointer_with_type(sc, GSList__sym, gtk_text_iter_get_tags((GtkTextIter*)s7_c_pointer(iter))));
}

static s7_pointer lg_gtk_text_iter_editable(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_editable "gboolean gtk_text_iter_editable(GtkTextIter* iter, gboolean default_setting)"
  s7_pointer _p;
  s7_pointer iter, default_setting;
  _p = args;
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_editable", 1, iter, "GtkTextIter*");
  default_setting = s7_car(_p);
  if (!s7_is_boolean(default_setting)) s7_wrong_type_arg_error(sc, "gtk_text_iter_editable", 2, default_setting, "gboolean");
  return(s7_make_boolean(sc, gtk_text_iter_editable((GtkTextIter*)s7_c_pointer(iter), (gboolean)lg_boolean(default_setting))));
}

static s7_pointer lg_gtk_text_iter_can_insert(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_can_insert "gboolean gtk_text_iter_can_insert(GtkTextIter* iter, gboolean default_editability)"
  s7_pointer _p;
  s7_pointer iter, default_editability;
  _p = args;
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_can_insert", 1, iter, "GtkTextIter*");
  default_editability = s7_car(_p);
  if (!s7_is_boolean(default_editability)) s7_wrong_type_arg_error(sc, "gtk_text_iter_can_insert", 2, default_editability, "gboolean");
  return(s7_make_boolean(sc, gtk_text_iter_can_insert((GtkTextIter*)s7_c_pointer(iter), (gboolean)lg_boolean(default_editability))));
}

static s7_pointer lg_gtk_text_iter_starts_word(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_starts_word "gboolean gtk_text_iter_starts_word(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_starts_word", 1, iter, "GtkTextIter*");
  return(s7_make_boolean(sc, gtk_text_iter_starts_word((GtkTextIter*)s7_c_pointer(iter))));
}

static s7_pointer lg_gtk_text_iter_ends_word(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_ends_word "gboolean gtk_text_iter_ends_word(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_ends_word", 1, iter, "GtkTextIter*");
  return(s7_make_boolean(sc, gtk_text_iter_ends_word((GtkTextIter*)s7_c_pointer(iter))));
}

static s7_pointer lg_gtk_text_iter_inside_word(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_inside_word "gboolean gtk_text_iter_inside_word(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_inside_word", 1, iter, "GtkTextIter*");
  return(s7_make_boolean(sc, gtk_text_iter_inside_word((GtkTextIter*)s7_c_pointer(iter))));
}

static s7_pointer lg_gtk_text_iter_starts_sentence(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_starts_sentence "gboolean gtk_text_iter_starts_sentence(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_starts_sentence", 1, iter, "GtkTextIter*");
  return(s7_make_boolean(sc, gtk_text_iter_starts_sentence((GtkTextIter*)s7_c_pointer(iter))));
}

static s7_pointer lg_gtk_text_iter_ends_sentence(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_ends_sentence "gboolean gtk_text_iter_ends_sentence(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_ends_sentence", 1, iter, "GtkTextIter*");
  return(s7_make_boolean(sc, gtk_text_iter_ends_sentence((GtkTextIter*)s7_c_pointer(iter))));
}

static s7_pointer lg_gtk_text_iter_inside_sentence(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_inside_sentence "gboolean gtk_text_iter_inside_sentence(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_inside_sentence", 1, iter, "GtkTextIter*");
  return(s7_make_boolean(sc, gtk_text_iter_inside_sentence((GtkTextIter*)s7_c_pointer(iter))));
}

static s7_pointer lg_gtk_text_iter_starts_line(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_starts_line "gboolean gtk_text_iter_starts_line(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_starts_line", 1, iter, "GtkTextIter*");
  return(s7_make_boolean(sc, gtk_text_iter_starts_line((GtkTextIter*)s7_c_pointer(iter))));
}

static s7_pointer lg_gtk_text_iter_ends_line(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_ends_line "gboolean gtk_text_iter_ends_line(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_ends_line", 1, iter, "GtkTextIter*");
  return(s7_make_boolean(sc, gtk_text_iter_ends_line((GtkTextIter*)s7_c_pointer(iter))));
}

static s7_pointer lg_gtk_text_iter_is_cursor_position(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_is_cursor_position "gboolean gtk_text_iter_is_cursor_position(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_is_cursor_position", 1, iter, "GtkTextIter*");
  return(s7_make_boolean(sc, gtk_text_iter_is_cursor_position((GtkTextIter*)s7_c_pointer(iter))));
}

static s7_pointer lg_gtk_text_iter_get_chars_in_line(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_get_chars_in_line "gint gtk_text_iter_get_chars_in_line(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_get_chars_in_line", 1, iter, "GtkTextIter*");
  return(s7_make_integer(sc, gtk_text_iter_get_chars_in_line((GtkTextIter*)s7_c_pointer(iter))));
}

static s7_pointer lg_gtk_text_iter_get_bytes_in_line(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_get_bytes_in_line "gint gtk_text_iter_get_bytes_in_line(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_get_bytes_in_line", 1, iter, "GtkTextIter*");
  return(s7_make_integer(sc, gtk_text_iter_get_bytes_in_line((GtkTextIter*)s7_c_pointer(iter))));
}

static s7_pointer lg_gtk_text_iter_get_language(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_get_language "PangoLanguage* gtk_text_iter_get_language(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_get_language", 1, iter, "GtkTextIter*");
  return(lg_make_c_pointer_with_type(sc, PangoLanguage__sym, gtk_text_iter_get_language((GtkTextIter*)s7_c_pointer(iter))));
}

static s7_pointer lg_gtk_text_iter_is_end(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_is_end "gboolean gtk_text_iter_is_end(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_is_end", 1, iter, "GtkTextIter*");
  return(s7_make_boolean(sc, gtk_text_iter_is_end((GtkTextIter*)s7_c_pointer(iter))));
}

static s7_pointer lg_gtk_text_iter_is_start(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_is_start "gboolean gtk_text_iter_is_start(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_is_start", 1, iter, "GtkTextIter*");
  return(s7_make_boolean(sc, gtk_text_iter_is_start((GtkTextIter*)s7_c_pointer(iter))));
}

static s7_pointer lg_gtk_text_iter_forward_char(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_forward_char "gboolean gtk_text_iter_forward_char(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_forward_char", 1, iter, "GtkTextIter*");
  return(s7_make_boolean(sc, gtk_text_iter_forward_char((GtkTextIter*)s7_c_pointer(iter))));
}

static s7_pointer lg_gtk_text_iter_backward_char(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_backward_char "gboolean gtk_text_iter_backward_char(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_backward_char", 1, iter, "GtkTextIter*");
  return(s7_make_boolean(sc, gtk_text_iter_backward_char((GtkTextIter*)s7_c_pointer(iter))));
}

static s7_pointer lg_gtk_text_iter_forward_chars(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_forward_chars "gboolean gtk_text_iter_forward_chars(GtkTextIter* iter, gint count)"
  s7_pointer _p;
  s7_pointer iter, count;
  _p = args;
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_forward_chars", 1, iter, "GtkTextIter*");
  count = s7_car(_p);
  if (!s7_is_integer(count)) s7_wrong_type_arg_error(sc, "gtk_text_iter_forward_chars", 2, count, "gint");
  return(s7_make_boolean(sc, gtk_text_iter_forward_chars((GtkTextIter*)s7_c_pointer(iter), (gint)s7_integer(count))));
}

static s7_pointer lg_gtk_text_iter_backward_chars(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_backward_chars "gboolean gtk_text_iter_backward_chars(GtkTextIter* iter, gint count)"
  s7_pointer _p;
  s7_pointer iter, count;
  _p = args;
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_backward_chars", 1, iter, "GtkTextIter*");
  count = s7_car(_p);
  if (!s7_is_integer(count)) s7_wrong_type_arg_error(sc, "gtk_text_iter_backward_chars", 2, count, "gint");
  return(s7_make_boolean(sc, gtk_text_iter_backward_chars((GtkTextIter*)s7_c_pointer(iter), (gint)s7_integer(count))));
}

static s7_pointer lg_gtk_text_iter_forward_line(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_forward_line "gboolean gtk_text_iter_forward_line(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_forward_line", 1, iter, "GtkTextIter*");
  return(s7_make_boolean(sc, gtk_text_iter_forward_line((GtkTextIter*)s7_c_pointer(iter))));
}

static s7_pointer lg_gtk_text_iter_backward_line(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_backward_line "gboolean gtk_text_iter_backward_line(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_backward_line", 1, iter, "GtkTextIter*");
  return(s7_make_boolean(sc, gtk_text_iter_backward_line((GtkTextIter*)s7_c_pointer(iter))));
}

static s7_pointer lg_gtk_text_iter_forward_lines(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_forward_lines "gboolean gtk_text_iter_forward_lines(GtkTextIter* iter, gint count)"
  s7_pointer _p;
  s7_pointer iter, count;
  _p = args;
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_forward_lines", 1, iter, "GtkTextIter*");
  count = s7_car(_p);
  if (!s7_is_integer(count)) s7_wrong_type_arg_error(sc, "gtk_text_iter_forward_lines", 2, count, "gint");
  return(s7_make_boolean(sc, gtk_text_iter_forward_lines((GtkTextIter*)s7_c_pointer(iter), (gint)s7_integer(count))));
}

static s7_pointer lg_gtk_text_iter_backward_lines(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_backward_lines "gboolean gtk_text_iter_backward_lines(GtkTextIter* iter, gint count)"
  s7_pointer _p;
  s7_pointer iter, count;
  _p = args;
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_backward_lines", 1, iter, "GtkTextIter*");
  count = s7_car(_p);
  if (!s7_is_integer(count)) s7_wrong_type_arg_error(sc, "gtk_text_iter_backward_lines", 2, count, "gint");
  return(s7_make_boolean(sc, gtk_text_iter_backward_lines((GtkTextIter*)s7_c_pointer(iter), (gint)s7_integer(count))));
}

static s7_pointer lg_gtk_text_iter_forward_word_end(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_forward_word_end "gboolean gtk_text_iter_forward_word_end(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_forward_word_end", 1, iter, "GtkTextIter*");
  return(s7_make_boolean(sc, gtk_text_iter_forward_word_end((GtkTextIter*)s7_c_pointer(iter))));
}

static s7_pointer lg_gtk_text_iter_backward_word_start(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_backward_word_start "gboolean gtk_text_iter_backward_word_start(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_backward_word_start", 1, iter, "GtkTextIter*");
  return(s7_make_boolean(sc, gtk_text_iter_backward_word_start((GtkTextIter*)s7_c_pointer(iter))));
}

static s7_pointer lg_gtk_text_iter_forward_word_ends(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_forward_word_ends "gboolean gtk_text_iter_forward_word_ends(GtkTextIter* iter, \
gint count)"
  s7_pointer _p;
  s7_pointer iter, count;
  _p = args;
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_forward_word_ends", 1, iter, "GtkTextIter*");
  count = s7_car(_p);
  if (!s7_is_integer(count)) s7_wrong_type_arg_error(sc, "gtk_text_iter_forward_word_ends", 2, count, "gint");
  return(s7_make_boolean(sc, gtk_text_iter_forward_word_ends((GtkTextIter*)s7_c_pointer(iter), (gint)s7_integer(count))));
}

static s7_pointer lg_gtk_text_iter_backward_word_starts(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_backward_word_starts "gboolean gtk_text_iter_backward_word_starts(GtkTextIter* iter, \
gint count)"
  s7_pointer _p;
  s7_pointer iter, count;
  _p = args;
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_backward_word_starts", 1, iter, "GtkTextIter*");
  count = s7_car(_p);
  if (!s7_is_integer(count)) s7_wrong_type_arg_error(sc, "gtk_text_iter_backward_word_starts", 2, count, "gint");
  return(s7_make_boolean(sc, gtk_text_iter_backward_word_starts((GtkTextIter*)s7_c_pointer(iter), (gint)s7_integer(count))));
}

static s7_pointer lg_gtk_text_iter_forward_sentence_end(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_forward_sentence_end "gboolean gtk_text_iter_forward_sentence_end(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_forward_sentence_end", 1, iter, "GtkTextIter*");
  return(s7_make_boolean(sc, gtk_text_iter_forward_sentence_end((GtkTextIter*)s7_c_pointer(iter))));
}

static s7_pointer lg_gtk_text_iter_backward_sentence_start(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_backward_sentence_start "gboolean gtk_text_iter_backward_sentence_start(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_backward_sentence_start", 1, iter, "GtkTextIter*");
  return(s7_make_boolean(sc, gtk_text_iter_backward_sentence_start((GtkTextIter*)s7_c_pointer(iter))));
}

static s7_pointer lg_gtk_text_iter_forward_sentence_ends(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_forward_sentence_ends "gboolean gtk_text_iter_forward_sentence_ends(GtkTextIter* iter, \
gint count)"
  s7_pointer _p;
  s7_pointer iter, count;
  _p = args;
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_forward_sentence_ends", 1, iter, "GtkTextIter*");
  count = s7_car(_p);
  if (!s7_is_integer(count)) s7_wrong_type_arg_error(sc, "gtk_text_iter_forward_sentence_ends", 2, count, "gint");
  return(s7_make_boolean(sc, gtk_text_iter_forward_sentence_ends((GtkTextIter*)s7_c_pointer(iter), (gint)s7_integer(count))));
}

static s7_pointer lg_gtk_text_iter_backward_sentence_starts(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_backward_sentence_starts "gboolean gtk_text_iter_backward_sentence_starts(GtkTextIter* iter, \
gint count)"
  s7_pointer _p;
  s7_pointer iter, count;
  _p = args;
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_backward_sentence_starts", 1, iter, "GtkTextIter*");
  count = s7_car(_p);
  if (!s7_is_integer(count)) s7_wrong_type_arg_error(sc, "gtk_text_iter_backward_sentence_starts", 2, count, "gint");
  return(s7_make_boolean(sc, gtk_text_iter_backward_sentence_starts((GtkTextIter*)s7_c_pointer(iter), (gint)s7_integer(count))));
}

static s7_pointer lg_gtk_text_iter_forward_cursor_position(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_forward_cursor_position "gboolean gtk_text_iter_forward_cursor_position(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_forward_cursor_position", 1, iter, "GtkTextIter*");
  return(s7_make_boolean(sc, gtk_text_iter_forward_cursor_position((GtkTextIter*)s7_c_pointer(iter))));
}

static s7_pointer lg_gtk_text_iter_backward_cursor_position(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_backward_cursor_position "gboolean gtk_text_iter_backward_cursor_position(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_backward_cursor_position", 1, iter, "GtkTextIter*");
  return(s7_make_boolean(sc, gtk_text_iter_backward_cursor_position((GtkTextIter*)s7_c_pointer(iter))));
}

static s7_pointer lg_gtk_text_iter_forward_cursor_positions(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_forward_cursor_positions "gboolean gtk_text_iter_forward_cursor_positions(GtkTextIter* iter, \
gint count)"
  s7_pointer _p;
  s7_pointer iter, count;
  _p = args;
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_forward_cursor_positions", 1, iter, "GtkTextIter*");
  count = s7_car(_p);
  if (!s7_is_integer(count)) s7_wrong_type_arg_error(sc, "gtk_text_iter_forward_cursor_positions", 2, count, "gint");
  return(s7_make_boolean(sc, gtk_text_iter_forward_cursor_positions((GtkTextIter*)s7_c_pointer(iter), (gint)s7_integer(count))));
}

static s7_pointer lg_gtk_text_iter_backward_cursor_positions(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_backward_cursor_positions "gboolean gtk_text_iter_backward_cursor_positions(GtkTextIter* iter, \
gint count)"
  s7_pointer _p;
  s7_pointer iter, count;
  _p = args;
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_backward_cursor_positions", 1, iter, "GtkTextIter*");
  count = s7_car(_p);
  if (!s7_is_integer(count)) s7_wrong_type_arg_error(sc, "gtk_text_iter_backward_cursor_positions", 2, count, "gint");
  return(s7_make_boolean(sc, gtk_text_iter_backward_cursor_positions((GtkTextIter*)s7_c_pointer(iter), (gint)s7_integer(count))));
}

static s7_pointer lg_gtk_text_iter_set_offset(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_set_offset "void gtk_text_iter_set_offset(GtkTextIter* iter, gint char_offset)"
  s7_pointer _p;
  s7_pointer iter, char_offset;
  _p = args;
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_set_offset", 1, iter, "GtkTextIter*");
  char_offset = s7_car(_p);
  if (!s7_is_integer(char_offset)) s7_wrong_type_arg_error(sc, "gtk_text_iter_set_offset", 2, char_offset, "gint");
  gtk_text_iter_set_offset((GtkTextIter*)s7_c_pointer(iter), (gint)s7_integer(char_offset));
  return(lg_false);
}

static s7_pointer lg_gtk_text_iter_set_line(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_set_line "void gtk_text_iter_set_line(GtkTextIter* iter, gint line_number)"
  s7_pointer _p;
  s7_pointer iter, line_number;
  _p = args;
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_set_line", 1, iter, "GtkTextIter*");
  line_number = s7_car(_p);
  if (!s7_is_integer(line_number)) s7_wrong_type_arg_error(sc, "gtk_text_iter_set_line", 2, line_number, "gint");
  gtk_text_iter_set_line((GtkTextIter*)s7_c_pointer(iter), (gint)s7_integer(line_number));
  return(lg_false);
}

static s7_pointer lg_gtk_text_iter_set_line_offset(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_set_line_offset "void gtk_text_iter_set_line_offset(GtkTextIter* iter, gint char_on_line)"
  s7_pointer _p;
  s7_pointer iter, char_on_line;
  _p = args;
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_set_line_offset", 1, iter, "GtkTextIter*");
  char_on_line = s7_car(_p);
  if (!s7_is_integer(char_on_line)) s7_wrong_type_arg_error(sc, "gtk_text_iter_set_line_offset", 2, char_on_line, "gint");
  gtk_text_iter_set_line_offset((GtkTextIter*)s7_c_pointer(iter), (gint)s7_integer(char_on_line));
  return(lg_false);
}

static s7_pointer lg_gtk_text_iter_set_line_index(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_set_line_index "void gtk_text_iter_set_line_index(GtkTextIter* iter, gint byte_on_line)"
  s7_pointer _p;
  s7_pointer iter, byte_on_line;
  _p = args;
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_set_line_index", 1, iter, "GtkTextIter*");
  byte_on_line = s7_car(_p);
  if (!s7_is_integer(byte_on_line)) s7_wrong_type_arg_error(sc, "gtk_text_iter_set_line_index", 2, byte_on_line, "gint");
  gtk_text_iter_set_line_index((GtkTextIter*)s7_c_pointer(iter), (gint)s7_integer(byte_on_line));
  return(lg_false);
}

static s7_pointer lg_gtk_text_iter_forward_to_end(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_forward_to_end "void gtk_text_iter_forward_to_end(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_forward_to_end", 1, iter, "GtkTextIter*");
  gtk_text_iter_forward_to_end((GtkTextIter*)s7_c_pointer(iter));
  return(lg_false);
}

static s7_pointer lg_gtk_text_iter_forward_to_line_end(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_forward_to_line_end "gboolean gtk_text_iter_forward_to_line_end(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_forward_to_line_end", 1, iter, "GtkTextIter*");
  return(s7_make_boolean(sc, gtk_text_iter_forward_to_line_end((GtkTextIter*)s7_c_pointer(iter))));
}

static s7_pointer lg_gtk_text_iter_set_visible_line_offset(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_set_visible_line_offset "void gtk_text_iter_set_visible_line_offset(GtkTextIter* iter, \
gint char_on_line)"
  s7_pointer _p;
  s7_pointer iter, char_on_line;
  _p = args;
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_set_visible_line_offset", 1, iter, "GtkTextIter*");
  char_on_line = s7_car(_p);
  if (!s7_is_integer(char_on_line)) s7_wrong_type_arg_error(sc, "gtk_text_iter_set_visible_line_offset", 2, char_on_line, "gint");
  gtk_text_iter_set_visible_line_offset((GtkTextIter*)s7_c_pointer(iter), (gint)s7_integer(char_on_line));
  return(lg_false);
}

static s7_pointer lg_gtk_text_iter_set_visible_line_index(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_set_visible_line_index "void gtk_text_iter_set_visible_line_index(GtkTextIter* iter, \
gint byte_on_line)"
  s7_pointer _p;
  s7_pointer iter, byte_on_line;
  _p = args;
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_set_visible_line_index", 1, iter, "GtkTextIter*");
  byte_on_line = s7_car(_p);
  if (!s7_is_integer(byte_on_line)) s7_wrong_type_arg_error(sc, "gtk_text_iter_set_visible_line_index", 2, byte_on_line, "gint");
  gtk_text_iter_set_visible_line_index((GtkTextIter*)s7_c_pointer(iter), (gint)s7_integer(byte_on_line));
  return(lg_false);
}

static s7_pointer lg_gtk_text_iter_forward_to_tag_toggle(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_forward_to_tag_toggle "gboolean gtk_text_iter_forward_to_tag_toggle(GtkTextIter* iter, \
GtkTextTag* tag)"
  s7_pointer _p;
  s7_pointer iter, tag;
  _p = args;
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_forward_to_tag_toggle", 1, iter, "GtkTextIter*");
  tag = s7_car(_p);
  if ((!s7_is_c_pointer_of_type(tag, GtkTextTag__sym)) && (tag != lg_false)) s7_wrong_type_arg_error(sc, "gtk_text_iter_forward_to_tag_toggle", 2, tag, "GtkTextTag*");
  return(s7_make_boolean(sc, gtk_text_iter_forward_to_tag_toggle((GtkTextIter*)s7_c_pointer(iter), (GtkTextTag*)s7_c_pointer(tag))));
}

static s7_pointer lg_gtk_text_iter_backward_to_tag_toggle(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_backward_to_tag_toggle "gboolean gtk_text_iter_backward_to_tag_toggle(GtkTextIter* iter, \
GtkTextTag* tag)"
  s7_pointer _p;
  s7_pointer iter, tag;
  _p = args;
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_backward_to_tag_toggle", 1, iter, "GtkTextIter*");
  tag = s7_car(_p);
  if ((!s7_is_c_pointer_of_type(tag, GtkTextTag__sym)) && (tag != lg_false)) s7_wrong_type_arg_error(sc, "gtk_text_iter_backward_to_tag_toggle", 2, tag, "GtkTextTag*");
  return(s7_make_boolean(sc, gtk_text_iter_backward_to_tag_toggle((GtkTextIter*)s7_c_pointer(iter), (GtkTextTag*)s7_c_pointer(tag))));
}

static s7_pointer lg_gtk_text_iter_forward_find_char(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_forward_find_char "gboolean gtk_text_iter_forward_find_char(GtkTextIter* iter, \
GtkTextCharPredicate pred, lambda_data func_info, GtkTextIter* limit)"
  s7_pointer _p;
  s7_pointer iter /* , pred */ , func_info, limit;
  _p = args;
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_forward_find_char", 1, iter, "GtkTextIter*");
  /* pred = s7_car(_p); */ _p = s7_cdr(_p);
  func_info = s7_car(_p); _p = s7_cdr(_p);
  limit = s7_car(_p);
  if ((!s7_is_c_pointer_of_type(limit, GtkTextIter__sym)) && (limit != lg_false)) s7_wrong_type_arg_error(sc, "gtk_text_iter_forward_find_char", 4, limit, "GtkTextIter*");
  {
    s7_pointer res_ult;
    int loc;
    s7_pointer lg_ptr = s7_list(sc, 5, lg_false, func_info, lg_false, lg_false, lg_false);
    loc = s7_gc_protect(sc, lg_ptr);
    s7_list_set(sc, lg_ptr, 2, s7_make_integer(sc, loc));
    res_ult = s7_make_boolean(sc, gtk_text_iter_forward_find_char((GtkTextIter*)s7_c_pointer(iter), lg_text_char_predicate, (gpointer)lg_ptr, (GtkTextIter*)s7_c_pointer(limit)));
    return(res_ult);
   }
}

static s7_pointer lg_gtk_text_iter_backward_find_char(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_backward_find_char "gboolean gtk_text_iter_backward_find_char(GtkTextIter* iter, \
GtkTextCharPredicate pred, lambda_data func_info, GtkTextIter* limit)"
  s7_pointer _p;
  s7_pointer iter /* , pred */ , func_info, limit;
  _p = args;
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_backward_find_char", 1, iter, "GtkTextIter*");
  /* pred = s7_car(_p); */ _p = s7_cdr(_p);
  func_info = s7_car(_p); _p = s7_cdr(_p);
  limit = s7_car(_p);
  if ((!s7_is_c_pointer_of_type(limit, GtkTextIter__sym)) && (limit != lg_false)) s7_wrong_type_arg_error(sc, "gtk_text_iter_backward_find_char", 4, limit, "GtkTextIter*");
  {
    s7_pointer res_ult;
    int loc;
    s7_pointer lg_ptr = s7_list(sc, 5, lg_false, func_info, lg_false, lg_false, lg_false);
    loc = s7_gc_protect(sc, lg_ptr);
    s7_list_set(sc, lg_ptr, 2, s7_make_integer(sc, loc));
    res_ult = s7_make_boolean(sc, gtk_text_iter_backward_find_char((GtkTextIter*)s7_c_pointer(iter), lg_text_char_predicate, (gpointer)lg_ptr, (GtkTextIter*)s7_c_pointer(limit)));
    return(res_ult);
   }
}

static s7_pointer lg_gtk_text_iter_forward_search(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_forward_search "gboolean gtk_text_iter_forward_search(GtkTextIter* iter, gchar* str, \
GtkTextSearchFlags flags, GtkTextIter* match_start, GtkTextIter* match_end, GtkTextIter* limit)"
  s7_pointer _p;
  s7_pointer iter, str, flags, match_start, match_end, limit;
  _p = args;
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_forward_search", 1, iter, "GtkTextIter*");
  str = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(str)) s7_wrong_type_arg_error(sc, "gtk_text_iter_forward_search", 2, str, "gchar*");
  flags = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(flags)) s7_wrong_type_arg_error(sc, "gtk_text_iter_forward_search", 3, flags, "GtkTextSearchFlags");
  match_start = s7_car(_p); _p = s7_cdr(_p);
  if ((!s7_is_c_pointer_of_type(match_start, GtkTextIter__sym)) && (match_start != lg_false)) s7_wrong_type_arg_error(sc, "gtk_text_iter_forward_search", 4, match_start, "GtkTextIter*");
  match_end = s7_car(_p); _p = s7_cdr(_p);
  if ((!s7_is_c_pointer_of_type(match_end, GtkTextIter__sym)) && (match_end != lg_false)) s7_wrong_type_arg_error(sc, "gtk_text_iter_forward_search", 5, match_end, "GtkTextIter*");
  limit = s7_car(_p);
  if ((!s7_is_c_pointer_of_type(limit, GtkTextIter__sym)) && (limit != lg_false)) s7_wrong_type_arg_error(sc, "gtk_text_iter_forward_search", 6, limit, "GtkTextIter*");
  return(s7_make_boolean(sc, gtk_text_iter_forward_search((GtkTextIter*)s7_c_pointer(iter), (gchar*)s7_string(str), (GtkTextSearchFlags)s7_integer(flags), (GtkTextIter*)s7_c_pointer(match_start), (GtkTextIter*)s7_c_pointer(match_end), (GtkTextIter*)s7_c_pointer(limit))));
}

static s7_pointer lg_gtk_text_iter_backward_search(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_backward_search "gboolean gtk_text_iter_backward_search(GtkTextIter* iter, \
gchar* str, GtkTextSearchFlags flags, GtkTextIter* match_start, GtkTextIter* match_end, GtkTextIter* limit)"
  s7_pointer _p;
  s7_pointer iter, str, flags, match_start, match_end, limit;
  _p = args;
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_backward_search", 1, iter, "GtkTextIter*");
  str = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(str)) s7_wrong_type_arg_error(sc, "gtk_text_iter_backward_search", 2, str, "gchar*");
  flags = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(flags)) s7_wrong_type_arg_error(sc, "gtk_text_iter_backward_search", 3, flags, "GtkTextSearchFlags");
  match_start = s7_car(_p); _p = s7_cdr(_p);
  if ((!s7_is_c_pointer_of_type(match_start, GtkTextIter__sym)) && (match_start != lg_false)) s7_wrong_type_arg_error(sc, "gtk_text_iter_backward_search", 4, match_start, "GtkTextIter*");
  match_end = s7_car(_p); _p = s7_cdr(_p);
  if ((!s7_is_c_pointer_of_type(match_end, GtkTextIter__sym)) && (match_end != lg_false)) s7_wrong_type_arg_error(sc, "gtk_text_iter_backward_search", 5, match_end, "GtkTextIter*");
  limit = s7_car(_p);
  if ((!s7_is_c_pointer_of_type(limit, GtkTextIter__sym)) && (limit != lg_false)) s7_wrong_type_arg_error(sc, "gtk_text_iter_backward_search", 6, limit, "GtkTextIter*");
  return(s7_make_boolean(sc, gtk_text_iter_backward_search((GtkTextIter*)s7_c_pointer(iter), (gchar*)s7_string(str), (GtkTextSearchFlags)s7_integer(flags), (GtkTextIter*)s7_c_pointer(match_start), (GtkTextIter*)s7_c_pointer(match_end), (GtkTextIter*)s7_c_pointer(limit))));
}

static s7_pointer lg_gtk_text_iter_equal(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_equal "gboolean gtk_text_iter_equal(GtkTextIter* lhs, GtkTextIter* rhs)"
  s7_pointer _p;
  s7_pointer lhs, rhs;
  _p = args;
  lhs = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(lhs, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_equal", 1, lhs, "GtkTextIter*");
  rhs = s7_car(_p);
  if (!s7_is_c_pointer_of_type(rhs, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_equal", 2, rhs, "GtkTextIter*");
  return(s7_make_boolean(sc, gtk_text_iter_equal((GtkTextIter*)s7_c_pointer(lhs), (GtkTextIter*)s7_c_pointer(rhs))));
}

static s7_pointer lg_gtk_text_iter_compare(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_compare "gint gtk_text_iter_compare(GtkTextIter* lhs, GtkTextIter* rhs)"
  s7_pointer _p;
  s7_pointer lhs, rhs;
  _p = args;
  lhs = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(lhs, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_compare", 1, lhs, "GtkTextIter*");
  rhs = s7_car(_p);
  if (!s7_is_c_pointer_of_type(rhs, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_compare", 2, rhs, "GtkTextIter*");
  return(s7_make_integer(sc, gtk_text_iter_compare((GtkTextIter*)s7_c_pointer(lhs), (GtkTextIter*)s7_c_pointer(rhs))));
}

static s7_pointer lg_gtk_text_iter_in_range(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_in_range "gboolean gtk_text_iter_in_range(GtkTextIter* iter, GtkTextIter* start, \
GtkTextIter* end)"
  s7_pointer _p;
  s7_pointer iter, start, end;
  _p = args;
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_in_range", 1, iter, "GtkTextIter*");
  start = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(start, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_in_range", 2, start, "GtkTextIter*");
  end = s7_car(_p);
  if (!s7_is_c_pointer_of_type(end, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_in_range", 3, end, "GtkTextIter*");
  return(s7_make_boolean(sc, gtk_text_iter_in_range((GtkTextIter*)s7_c_pointer(iter), (GtkTextIter*)s7_c_pointer(start), (GtkTextIter*)s7_c_pointer(end))));
}

static s7_pointer lg_gtk_text_iter_order(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_order "void gtk_text_iter_order(GtkTextIter* first, GtkTextIter* second)"
  s7_pointer _p;
  s7_pointer first, second;
  _p = args;
  first = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(first, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_order", 1, first, "GtkTextIter*");
  second = s7_car(_p);
  if (!s7_is_c_pointer_of_type(second, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_order", 2, second, "GtkTextIter*");
  gtk_text_iter_order((GtkTextIter*)s7_c_pointer(first), (GtkTextIter*)s7_c_pointer(second));
  return(lg_false);
}

static s7_pointer lg_gtk_text_mark_set_visible(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_mark_set_visible "void gtk_text_mark_set_visible(GtkTextMark* mark, gboolean setting)"
  s7_pointer _p;
  s7_pointer mark, setting;
  _p = args;
  mark = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(mark, GtkTextMark__sym)) s7_wrong_type_arg_error(sc, "gtk_text_mark_set_visible", 1, mark, "GtkTextMark*");
  setting = s7_car(_p);
  if (!s7_is_boolean(setting)) s7_wrong_type_arg_error(sc, "gtk_text_mark_set_visible", 2, setting, "gboolean");
  gtk_text_mark_set_visible((GtkTextMark*)s7_c_pointer(mark), (gboolean)lg_boolean(setting));
  return(lg_false);
}

static s7_pointer lg_gtk_text_mark_get_visible(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_mark_get_visible "gboolean gtk_text_mark_get_visible(GtkTextMark* mark)"
  s7_pointer mark;
  mark = s7_car(args);
  if (!s7_is_c_pointer_of_type(mark, GtkTextMark__sym)) s7_wrong_type_arg_error(sc, "gtk_text_mark_get_visible", 1, mark, "GtkTextMark*");
  return(s7_make_boolean(sc, gtk_text_mark_get_visible((GtkTextMark*)s7_c_pointer(mark))));
}

static s7_pointer lg_gtk_text_mark_get_name(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_mark_get_name "char* gtk_text_mark_get_name(GtkTextMark* mark)"
  s7_pointer mark;
  mark = s7_car(args);
  if (!s7_is_c_pointer_of_type(mark, GtkTextMark__sym)) s7_wrong_type_arg_error(sc, "gtk_text_mark_get_name", 1, mark, "GtkTextMark*");
  return(s7_make_string(sc, gtk_text_mark_get_name((GtkTextMark*)s7_c_pointer(mark))));
}

static s7_pointer lg_gtk_text_mark_get_deleted(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_mark_get_deleted "gboolean gtk_text_mark_get_deleted(GtkTextMark* mark)"
  s7_pointer mark;
  mark = s7_car(args);
  if (!s7_is_c_pointer_of_type(mark, GtkTextMark__sym)) s7_wrong_type_arg_error(sc, "gtk_text_mark_get_deleted", 1, mark, "GtkTextMark*");
  return(s7_make_boolean(sc, gtk_text_mark_get_deleted((GtkTextMark*)s7_c_pointer(mark))));
}

static s7_pointer lg_gtk_text_mark_get_buffer(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_mark_get_buffer "GtkTextBuffer* gtk_text_mark_get_buffer(GtkTextMark* mark)"
  s7_pointer mark;
  mark = s7_car(args);
  if (!s7_is_c_pointer_of_type(mark, GtkTextMark__sym)) s7_wrong_type_arg_error(sc, "gtk_text_mark_get_buffer", 1, mark, "GtkTextMark*");
  return(lg_make_c_pointer_with_type(sc, GtkTextBuffer__sym, gtk_text_mark_get_buffer((GtkTextMark*)s7_c_pointer(mark))));
}

static s7_pointer lg_gtk_text_mark_get_left_gravity(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_mark_get_left_gravity "gboolean gtk_text_mark_get_left_gravity(GtkTextMark* mark)"
  s7_pointer mark;
  mark = s7_car(args);
  if (!s7_is_c_pointer_of_type(mark, GtkTextMark__sym)) s7_wrong_type_arg_error(sc, "gtk_text_mark_get_left_gravity", 1, mark, "GtkTextMark*");
  return(s7_make_boolean(sc, gtk_text_mark_get_left_gravity((GtkTextMark*)s7_c_pointer(mark))));
}

static s7_pointer lg_gtk_text_tag_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_tag_new "GtkTextTag* gtk_text_tag_new(gchar* name)"
  s7_pointer name;
  name = s7_car(args);
  if (!s7_is_string(name)) s7_wrong_type_arg_error(sc, "gtk_text_tag_new", 1, name, "gchar*");
  return(lg_make_c_pointer_with_type(sc, GtkTextTag__sym, gtk_text_tag_new((gchar*)s7_string(name))));
}

static s7_pointer lg_gtk_text_tag_get_priority(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_tag_get_priority "gint gtk_text_tag_get_priority(GtkTextTag* tag)"
  s7_pointer tag;
  tag = s7_car(args);
  if (!s7_is_c_pointer_of_type(tag, GtkTextTag__sym)) s7_wrong_type_arg_error(sc, "gtk_text_tag_get_priority", 1, tag, "GtkTextTag*");
  return(s7_make_integer(sc, gtk_text_tag_get_priority((GtkTextTag*)s7_c_pointer(tag))));
}

static s7_pointer lg_gtk_text_tag_set_priority(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_tag_set_priority "void gtk_text_tag_set_priority(GtkTextTag* tag, gint priority)"
  s7_pointer _p;
  s7_pointer tag, priority;
  _p = args;
  tag = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tag, GtkTextTag__sym)) s7_wrong_type_arg_error(sc, "gtk_text_tag_set_priority", 1, tag, "GtkTextTag*");
  priority = s7_car(_p);
  if (!s7_is_integer(priority)) s7_wrong_type_arg_error(sc, "gtk_text_tag_set_priority", 2, priority, "gint");
  gtk_text_tag_set_priority((GtkTextTag*)s7_c_pointer(tag), (gint)s7_integer(priority));
  return(lg_false);
}

static s7_pointer lg_gtk_text_tag_table_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_tag_table_new "GtkTextTagTable* gtk_text_tag_table_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkTextTagTable__sym, gtk_text_tag_table_new()));
}

static s7_pointer lg_gtk_text_tag_table_add(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_tag_table_add "void gtk_text_tag_table_add(GtkTextTagTable* table, GtkTextTag* tag)"
  s7_pointer _p;
  s7_pointer table, tag;
  _p = args;
  table = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(table, GtkTextTagTable__sym)) s7_wrong_type_arg_error(sc, "gtk_text_tag_table_add", 1, table, "GtkTextTagTable*");
  tag = s7_car(_p);
  if (!s7_is_c_pointer_of_type(tag, GtkTextTag__sym)) s7_wrong_type_arg_error(sc, "gtk_text_tag_table_add", 2, tag, "GtkTextTag*");
  gtk_text_tag_table_add((GtkTextTagTable*)s7_c_pointer(table), (GtkTextTag*)s7_c_pointer(tag));
  return(lg_false);
}

static s7_pointer lg_gtk_text_tag_table_remove(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_tag_table_remove "void gtk_text_tag_table_remove(GtkTextTagTable* table, GtkTextTag* tag)"
  s7_pointer _p;
  s7_pointer table, tag;
  _p = args;
  table = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(table, GtkTextTagTable__sym)) s7_wrong_type_arg_error(sc, "gtk_text_tag_table_remove", 1, table, "GtkTextTagTable*");
  tag = s7_car(_p);
  if (!s7_is_c_pointer_of_type(tag, GtkTextTag__sym)) s7_wrong_type_arg_error(sc, "gtk_text_tag_table_remove", 2, tag, "GtkTextTag*");
  gtk_text_tag_table_remove((GtkTextTagTable*)s7_c_pointer(table), (GtkTextTag*)s7_c_pointer(tag));
  return(lg_false);
}

static s7_pointer lg_gtk_text_tag_table_lookup(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_tag_table_lookup "GtkTextTag* gtk_text_tag_table_lookup(GtkTextTagTable* table, \
gchar* name)"
  s7_pointer _p;
  s7_pointer table, name;
  _p = args;
  table = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(table, GtkTextTagTable__sym)) s7_wrong_type_arg_error(sc, "gtk_text_tag_table_lookup", 1, table, "GtkTextTagTable*");
  name = s7_car(_p);
  if (!s7_is_string(name)) s7_wrong_type_arg_error(sc, "gtk_text_tag_table_lookup", 2, name, "gchar*");
  return(lg_make_c_pointer_with_type(sc, GtkTextTag__sym, gtk_text_tag_table_lookup((GtkTextTagTable*)s7_c_pointer(table), (gchar*)s7_string(name))));
}

static s7_pointer lg_gtk_text_tag_table_foreach(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_tag_table_foreach "void gtk_text_tag_table_foreach(GtkTextTagTable* table, GtkTextTagTableForeach func, \
lambda_data func_info)"
  s7_pointer _p;
  s7_pointer table, func, func_info;
  _p = args;
  table = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(table, GtkTextTagTable__sym)) s7_wrong_type_arg_error(sc, "gtk_text_tag_table_foreach", 1, table, "GtkTextTagTable*");
  func = s7_car(_p); _p = s7_cdr(_p);
  func_info = s7_car(_p);
  {
    int loc;
    s7_pointer lg_ptr = s7_list(sc, 5, func, func_info, lg_false, lg_false, lg_false);
    loc = s7_gc_protect(sc, lg_ptr);
    s7_list_set(sc, lg_ptr, 2, s7_make_integer(sc, loc));
    gtk_text_tag_table_foreach((GtkTextTagTable*)s7_c_pointer(table), lg_text_tag_table_foreach, (gpointer)lg_ptr);
    return(lg_false);
   }
}

static s7_pointer lg_gtk_text_tag_table_get_size(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_tag_table_get_size "gint gtk_text_tag_table_get_size(GtkTextTagTable* table)"
  s7_pointer table;
  table = s7_car(args);
  if (!s7_is_c_pointer_of_type(table, GtkTextTagTable__sym)) s7_wrong_type_arg_error(sc, "gtk_text_tag_table_get_size", 1, table, "GtkTextTagTable*");
  return(s7_make_integer(sc, gtk_text_tag_table_get_size((GtkTextTagTable*)s7_c_pointer(table))));
}

static s7_pointer lg_gtk_text_view_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_new "GtkWidget* gtk_text_view_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_text_view_new()));
}

static s7_pointer lg_gtk_text_view_new_with_buffer(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_new_with_buffer "GtkWidget* gtk_text_view_new_with_buffer(GtkTextBuffer* buffer)"
  s7_pointer buffer;
  buffer = s7_car(args);
  if (!s7_is_c_pointer_of_type(buffer, GtkTextBuffer__sym)) s7_wrong_type_arg_error(sc, "gtk_text_view_new_with_buffer", 1, buffer, "GtkTextBuffer*");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_text_view_new_with_buffer((GtkTextBuffer*)s7_c_pointer(buffer))));
}

static s7_pointer lg_gtk_text_view_set_buffer(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_set_buffer "void gtk_text_view_set_buffer(GtkTextView* text_view, GtkTextBuffer* buffer)"
  s7_pointer _p;
  s7_pointer text_view, buffer;
  _p = args;
  text_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(text_view, GtkTextView__sym)) s7_wrong_type_arg_error(sc, "gtk_text_view_set_buffer", 1, text_view, "GtkTextView*");
  buffer = s7_car(_p);
  if (!s7_is_c_pointer_of_type(buffer, GtkTextBuffer__sym)) s7_wrong_type_arg_error(sc, "gtk_text_view_set_buffer", 2, buffer, "GtkTextBuffer*");
  gtk_text_view_set_buffer((GtkTextView*)s7_c_pointer(text_view), (GtkTextBuffer*)s7_c_pointer(buffer));
  return(lg_false);
}

static s7_pointer lg_gtk_text_view_get_buffer(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_get_buffer "GtkTextBuffer* gtk_text_view_get_buffer(GtkTextView* text_view)"
  s7_pointer text_view;
  text_view = s7_car(args);
  if (!s7_is_c_pointer_of_type(text_view, GtkTextView__sym)) s7_wrong_type_arg_error(sc, "gtk_text_view_get_buffer", 1, text_view, "GtkTextView*");
  return(lg_make_c_pointer_with_type(sc, GtkTextBuffer__sym, gtk_text_view_get_buffer((GtkTextView*)s7_c_pointer(text_view))));
}

static s7_pointer lg_gtk_text_view_scroll_to_iter(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_scroll_to_iter "gboolean gtk_text_view_scroll_to_iter(GtkTextView* text_view, \
GtkTextIter* iter, gdouble within_margin, gboolean use_align, gdouble xalign, gdouble yalign)"
  s7_pointer _p;
  s7_pointer text_view, iter, within_margin, use_align, xalign, yalign;
  _p = args;
  text_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(text_view, GtkTextView__sym)) s7_wrong_type_arg_error(sc, "gtk_text_view_scroll_to_iter", 1, text_view, "GtkTextView*");
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_view_scroll_to_iter", 2, iter, "GtkTextIter*");
  within_margin = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(within_margin)) s7_wrong_type_arg_error(sc, "gtk_text_view_scroll_to_iter", 3, within_margin, "gdouble");
  use_align = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_boolean(use_align)) s7_wrong_type_arg_error(sc, "gtk_text_view_scroll_to_iter", 4, use_align, "gboolean");
  xalign = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(xalign)) s7_wrong_type_arg_error(sc, "gtk_text_view_scroll_to_iter", 5, xalign, "gdouble");
  yalign = s7_car(_p);
  if (!s7_is_real(yalign)) s7_wrong_type_arg_error(sc, "gtk_text_view_scroll_to_iter", 6, yalign, "gdouble");
  return(s7_make_boolean(sc, gtk_text_view_scroll_to_iter((GtkTextView*)s7_c_pointer(text_view), (GtkTextIter*)s7_c_pointer(iter), (gdouble)s7_real(within_margin), (gboolean)lg_boolean(use_align), (gdouble)s7_real(xalign), (gdouble)s7_real(yalign))));
}

static s7_pointer lg_gtk_text_view_scroll_to_mark(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_scroll_to_mark "void gtk_text_view_scroll_to_mark(GtkTextView* text_view, GtkTextMark* mark, \
gdouble within_margin, gboolean use_align, gdouble xalign, gdouble yalign)"
  s7_pointer _p;
  s7_pointer text_view, mark, within_margin, use_align, xalign, yalign;
  _p = args;
  text_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(text_view, GtkTextView__sym)) s7_wrong_type_arg_error(sc, "gtk_text_view_scroll_to_mark", 1, text_view, "GtkTextView*");
  mark = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(mark, GtkTextMark__sym)) s7_wrong_type_arg_error(sc, "gtk_text_view_scroll_to_mark", 2, mark, "GtkTextMark*");
  within_margin = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(within_margin)) s7_wrong_type_arg_error(sc, "gtk_text_view_scroll_to_mark", 3, within_margin, "gdouble");
  use_align = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_boolean(use_align)) s7_wrong_type_arg_error(sc, "gtk_text_view_scroll_to_mark", 4, use_align, "gboolean");
  xalign = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(xalign)) s7_wrong_type_arg_error(sc, "gtk_text_view_scroll_to_mark", 5, xalign, "gdouble");
  yalign = s7_car(_p);
  if (!s7_is_real(yalign)) s7_wrong_type_arg_error(sc, "gtk_text_view_scroll_to_mark", 6, yalign, "gdouble");
  gtk_text_view_scroll_to_mark((GtkTextView*)s7_c_pointer(text_view), (GtkTextMark*)s7_c_pointer(mark), (gdouble)s7_real(within_margin), (gboolean)lg_boolean(use_align), (gdouble)s7_real(xalign), (gdouble)s7_real(yalign));
  return(lg_false);
}

static s7_pointer lg_gtk_text_view_scroll_mark_onscreen(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_scroll_mark_onscreen "void gtk_text_view_scroll_mark_onscreen(GtkTextView* text_view, \
GtkTextMark* mark)"
  s7_pointer _p;
  s7_pointer text_view, mark;
  _p = args;
  text_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(text_view, GtkTextView__sym)) s7_wrong_type_arg_error(sc, "gtk_text_view_scroll_mark_onscreen", 1, text_view, "GtkTextView*");
  mark = s7_car(_p);
  if (!s7_is_c_pointer_of_type(mark, GtkTextMark__sym)) s7_wrong_type_arg_error(sc, "gtk_text_view_scroll_mark_onscreen", 2, mark, "GtkTextMark*");
  gtk_text_view_scroll_mark_onscreen((GtkTextView*)s7_c_pointer(text_view), (GtkTextMark*)s7_c_pointer(mark));
  return(lg_false);
}

static s7_pointer lg_gtk_text_view_move_mark_onscreen(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_move_mark_onscreen "gboolean gtk_text_view_move_mark_onscreen(GtkTextView* text_view, \
GtkTextMark* mark)"
  s7_pointer _p;
  s7_pointer text_view, mark;
  _p = args;
  text_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(text_view, GtkTextView__sym)) s7_wrong_type_arg_error(sc, "gtk_text_view_move_mark_onscreen", 1, text_view, "GtkTextView*");
  mark = s7_car(_p);
  if (!s7_is_c_pointer_of_type(mark, GtkTextMark__sym)) s7_wrong_type_arg_error(sc, "gtk_text_view_move_mark_onscreen", 2, mark, "GtkTextMark*");
  return(s7_make_boolean(sc, gtk_text_view_move_mark_onscreen((GtkTextView*)s7_c_pointer(text_view), (GtkTextMark*)s7_c_pointer(mark))));
}

static s7_pointer lg_gtk_text_view_place_cursor_onscreen(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_place_cursor_onscreen "gboolean gtk_text_view_place_cursor_onscreen(GtkTextView* text_view)"
  s7_pointer text_view;
  text_view = s7_car(args);
  if (!s7_is_c_pointer_of_type(text_view, GtkTextView__sym)) s7_wrong_type_arg_error(sc, "gtk_text_view_place_cursor_onscreen", 1, text_view, "GtkTextView*");
  return(s7_make_boolean(sc, gtk_text_view_place_cursor_onscreen((GtkTextView*)s7_c_pointer(text_view))));
}

static s7_pointer lg_gtk_text_view_get_visible_rect(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_get_visible_rect "void gtk_text_view_get_visible_rect(GtkTextView* text_view, \
GdkRectangle* visible_rect)"
  s7_pointer _p;
  s7_pointer text_view, visible_rect;
  _p = args;
  text_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(text_view, GtkTextView__sym)) s7_wrong_type_arg_error(sc, "gtk_text_view_get_visible_rect", 1, text_view, "GtkTextView*");
  visible_rect = s7_car(_p);
  if (!s7_is_c_pointer_of_type(visible_rect, GdkRectangle__sym)) s7_wrong_type_arg_error(sc, "gtk_text_view_get_visible_rect", 2, visible_rect, "GdkRectangle*");
  gtk_text_view_get_visible_rect((GtkTextView*)s7_c_pointer(text_view), (GdkRectangle*)s7_c_pointer(visible_rect));
  return(lg_false);
}

static s7_pointer lg_gtk_text_view_set_cursor_visible(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_set_cursor_visible "void gtk_text_view_set_cursor_visible(GtkTextView* text_view, \
gboolean setting)"
  s7_pointer _p;
  s7_pointer text_view, setting;
  _p = args;
  text_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(text_view, GtkTextView__sym)) s7_wrong_type_arg_error(sc, "gtk_text_view_set_cursor_visible", 1, text_view, "GtkTextView*");
  setting = s7_car(_p);
  if (!s7_is_boolean(setting)) s7_wrong_type_arg_error(sc, "gtk_text_view_set_cursor_visible", 2, setting, "gboolean");
  gtk_text_view_set_cursor_visible((GtkTextView*)s7_c_pointer(text_view), (gboolean)lg_boolean(setting));
  return(lg_false);
}

static s7_pointer lg_gtk_text_view_get_cursor_visible(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_get_cursor_visible "gboolean gtk_text_view_get_cursor_visible(GtkTextView* text_view)"
  s7_pointer text_view;
  text_view = s7_car(args);
  if (!s7_is_c_pointer_of_type(text_view, GtkTextView__sym)) s7_wrong_type_arg_error(sc, "gtk_text_view_get_cursor_visible", 1, text_view, "GtkTextView*");
  return(s7_make_boolean(sc, gtk_text_view_get_cursor_visible((GtkTextView*)s7_c_pointer(text_view))));
}

static s7_pointer lg_gtk_text_view_get_iter_location(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_get_iter_location "void gtk_text_view_get_iter_location(GtkTextView* text_view, \
GtkTextIter* iter, GdkRectangle* location)"
  s7_pointer _p;
  s7_pointer text_view, iter, location;
  _p = args;
  text_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(text_view, GtkTextView__sym)) s7_wrong_type_arg_error(sc, "gtk_text_view_get_iter_location", 1, text_view, "GtkTextView*");
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_view_get_iter_location", 2, iter, "GtkTextIter*");
  location = s7_car(_p);
  if (!s7_is_c_pointer_of_type(location, GdkRectangle__sym)) s7_wrong_type_arg_error(sc, "gtk_text_view_get_iter_location", 3, location, "GdkRectangle*");
  gtk_text_view_get_iter_location((GtkTextView*)s7_c_pointer(text_view), (GtkTextIter*)s7_c_pointer(iter), (GdkRectangle*)s7_c_pointer(location));
  return(lg_false);
}

static s7_pointer lg_gtk_text_view_get_line_yrange(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_get_line_yrange "void gtk_text_view_get_line_yrange(GtkTextView* text_view, \
GtkTextIter* iter, gint* [y], gint* [height])"
  s7_pointer _p;
  s7_pointer text_view, iter;
  gint ref_y;
  gint ref_height;
  _p = args;
  text_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(text_view, GtkTextView__sym)) s7_wrong_type_arg_error(sc, "gtk_text_view_get_line_yrange", 1, text_view, "GtkTextView*");
  iter = s7_car(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_view_get_line_yrange", 2, iter, "GtkTextIter*");
  gtk_text_view_get_line_yrange((GtkTextView*)s7_c_pointer(text_view), (GtkTextIter*)s7_c_pointer(iter), &ref_y, &ref_height);
    return(s7_list(sc, 2, s7_make_integer(sc, ref_y), s7_make_integer(sc, ref_height)));
}

static s7_pointer lg_gtk_text_view_get_line_at_y(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_get_line_at_y "void gtk_text_view_get_line_at_y(GtkTextView* text_view, GtkTextIter* target_iter, \
gint y, gint* [line_top])"
  s7_pointer _p;
  s7_pointer text_view, target_iter, y;
  gint ref_line_top;
  _p = args;
  text_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(text_view, GtkTextView__sym)) s7_wrong_type_arg_error(sc, "gtk_text_view_get_line_at_y", 1, text_view, "GtkTextView*");
  target_iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(target_iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_view_get_line_at_y", 2, target_iter, "GtkTextIter*");
  y = s7_car(_p);
  if (!s7_is_integer(y)) s7_wrong_type_arg_error(sc, "gtk_text_view_get_line_at_y", 3, y, "gint");
  gtk_text_view_get_line_at_y((GtkTextView*)s7_c_pointer(text_view), (GtkTextIter*)s7_c_pointer(target_iter), (gint)s7_integer(y), &ref_line_top);
    return(s7_list(sc, 1, s7_make_integer(sc, ref_line_top)));
}

static s7_pointer lg_gtk_text_view_window_to_buffer_coords(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_window_to_buffer_coords "void gtk_text_view_window_to_buffer_coords(GtkTextView* text_view, \
GtkTextWindowType win, gint window_x, gint window_y, gint* [buffer_x], gint* [buffer_y])"
  s7_pointer _p;
  s7_pointer text_view, win, window_x, window_y;
  gint ref_buffer_x;
  gint ref_buffer_y;
  _p = args;
  text_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(text_view, GtkTextView__sym)) s7_wrong_type_arg_error(sc, "gtk_text_view_window_to_buffer_coords", 1, text_view, "GtkTextView*");
  win = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(win)) s7_wrong_type_arg_error(sc, "gtk_text_view_window_to_buffer_coords", 2, win, "GtkTextWindowType");
  window_x = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(window_x)) s7_wrong_type_arg_error(sc, "gtk_text_view_window_to_buffer_coords", 3, window_x, "gint");
  window_y = s7_car(_p);
  if (!s7_is_integer(window_y)) s7_wrong_type_arg_error(sc, "gtk_text_view_window_to_buffer_coords", 4, window_y, "gint");
  gtk_text_view_window_to_buffer_coords((GtkTextView*)s7_c_pointer(text_view), (GtkTextWindowType)s7_integer(win), (gint)s7_integer(window_x), (gint)s7_integer(window_y), &ref_buffer_x, &ref_buffer_y);
    return(s7_list(sc, 2, s7_make_integer(sc, ref_buffer_x), s7_make_integer(sc, ref_buffer_y)));
}

static s7_pointer lg_gtk_text_view_forward_display_line(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_forward_display_line "gboolean gtk_text_view_forward_display_line(GtkTextView* text_view, \
GtkTextIter* iter)"
  s7_pointer _p;
  s7_pointer text_view, iter;
  _p = args;
  text_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(text_view, GtkTextView__sym)) s7_wrong_type_arg_error(sc, "gtk_text_view_forward_display_line", 1, text_view, "GtkTextView*");
  iter = s7_car(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_view_forward_display_line", 2, iter, "GtkTextIter*");
  return(s7_make_boolean(sc, gtk_text_view_forward_display_line((GtkTextView*)s7_c_pointer(text_view), (GtkTextIter*)s7_c_pointer(iter))));
}

static s7_pointer lg_gtk_text_view_backward_display_line(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_backward_display_line "gboolean gtk_text_view_backward_display_line(GtkTextView* text_view, \
GtkTextIter* iter)"
  s7_pointer _p;
  s7_pointer text_view, iter;
  _p = args;
  text_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(text_view, GtkTextView__sym)) s7_wrong_type_arg_error(sc, "gtk_text_view_backward_display_line", 1, text_view, "GtkTextView*");
  iter = s7_car(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_view_backward_display_line", 2, iter, "GtkTextIter*");
  return(s7_make_boolean(sc, gtk_text_view_backward_display_line((GtkTextView*)s7_c_pointer(text_view), (GtkTextIter*)s7_c_pointer(iter))));
}

static s7_pointer lg_gtk_text_view_forward_display_line_end(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_forward_display_line_end "gboolean gtk_text_view_forward_display_line_end(GtkTextView* text_view, \
GtkTextIter* iter)"
  s7_pointer _p;
  s7_pointer text_view, iter;
  _p = args;
  text_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(text_view, GtkTextView__sym)) s7_wrong_type_arg_error(sc, "gtk_text_view_forward_display_line_end", 1, text_view, "GtkTextView*");
  iter = s7_car(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_view_forward_display_line_end", 2, iter, "GtkTextIter*");
  return(s7_make_boolean(sc, gtk_text_view_forward_display_line_end((GtkTextView*)s7_c_pointer(text_view), (GtkTextIter*)s7_c_pointer(iter))));
}

static s7_pointer lg_gtk_text_view_backward_display_line_start(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_backward_display_line_start "gboolean gtk_text_view_backward_display_line_start(GtkTextView* text_view, \
GtkTextIter* iter)"
  s7_pointer _p;
  s7_pointer text_view, iter;
  _p = args;
  text_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(text_view, GtkTextView__sym)) s7_wrong_type_arg_error(sc, "gtk_text_view_backward_display_line_start", 1, text_view, "GtkTextView*");
  iter = s7_car(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_view_backward_display_line_start", 2, iter, "GtkTextIter*");
  return(s7_make_boolean(sc, gtk_text_view_backward_display_line_start((GtkTextView*)s7_c_pointer(text_view), (GtkTextIter*)s7_c_pointer(iter))));
}

static s7_pointer lg_gtk_text_view_starts_display_line(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_starts_display_line "gboolean gtk_text_view_starts_display_line(GtkTextView* text_view, \
GtkTextIter* iter)"
  s7_pointer _p;
  s7_pointer text_view, iter;
  _p = args;
  text_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(text_view, GtkTextView__sym)) s7_wrong_type_arg_error(sc, "gtk_text_view_starts_display_line", 1, text_view, "GtkTextView*");
  iter = s7_car(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_view_starts_display_line", 2, iter, "GtkTextIter*");
  return(s7_make_boolean(sc, gtk_text_view_starts_display_line((GtkTextView*)s7_c_pointer(text_view), (GtkTextIter*)s7_c_pointer(iter))));
}

static s7_pointer lg_gtk_text_view_move_visually(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_move_visually "gboolean gtk_text_view_move_visually(GtkTextView* text_view, \
GtkTextIter* iter, gint count)"
  s7_pointer _p;
  s7_pointer text_view, iter, count;
  _p = args;
  text_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(text_view, GtkTextView__sym)) s7_wrong_type_arg_error(sc, "gtk_text_view_move_visually", 1, text_view, "GtkTextView*");
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_view_move_visually", 2, iter, "GtkTextIter*");
  count = s7_car(_p);
  if (!s7_is_integer(count)) s7_wrong_type_arg_error(sc, "gtk_text_view_move_visually", 3, count, "gint");
  return(s7_make_boolean(sc, gtk_text_view_move_visually((GtkTextView*)s7_c_pointer(text_view), (GtkTextIter*)s7_c_pointer(iter), (gint)s7_integer(count))));
}

static s7_pointer lg_gtk_text_view_add_child_at_anchor(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_add_child_at_anchor "void gtk_text_view_add_child_at_anchor(GtkTextView* text_view, \
GtkWidget* child, GtkTextChildAnchor* anchor)"
  s7_pointer _p;
  s7_pointer text_view, child, anchor;
  _p = args;
  text_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(text_view, GtkTextView__sym)) s7_wrong_type_arg_error(sc, "gtk_text_view_add_child_at_anchor", 1, text_view, "GtkTextView*");
  child = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(child, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_text_view_add_child_at_anchor", 2, child, "GtkWidget*");
  anchor = s7_car(_p);
  if (!s7_is_c_pointer_of_type(anchor, GtkTextChildAnchor__sym)) s7_wrong_type_arg_error(sc, "gtk_text_view_add_child_at_anchor", 3, anchor, "GtkTextChildAnchor*");
  gtk_text_view_add_child_at_anchor((GtkTextView*)s7_c_pointer(text_view), (GtkWidget*)s7_c_pointer(child), (GtkTextChildAnchor*)s7_c_pointer(anchor));
  return(lg_false);
}

static s7_pointer lg_gtk_text_view_set_wrap_mode(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_set_wrap_mode "void gtk_text_view_set_wrap_mode(GtkTextView* text_view, GtkWrapMode wrap_mode)"
  s7_pointer _p;
  s7_pointer text_view, wrap_mode;
  _p = args;
  text_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(text_view, GtkTextView__sym)) s7_wrong_type_arg_error(sc, "gtk_text_view_set_wrap_mode", 1, text_view, "GtkTextView*");
  wrap_mode = s7_car(_p);
  if (!s7_is_integer(wrap_mode)) s7_wrong_type_arg_error(sc, "gtk_text_view_set_wrap_mode", 2, wrap_mode, "GtkWrapMode");
  gtk_text_view_set_wrap_mode((GtkTextView*)s7_c_pointer(text_view), (GtkWrapMode)s7_integer(wrap_mode));
  return(lg_false);
}

static s7_pointer lg_gtk_text_view_get_wrap_mode(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_get_wrap_mode "GtkWrapMode gtk_text_view_get_wrap_mode(GtkTextView* text_view)"
  s7_pointer text_view;
  text_view = s7_car(args);
  if (!s7_is_c_pointer_of_type(text_view, GtkTextView__sym)) s7_wrong_type_arg_error(sc, "gtk_text_view_get_wrap_mode", 1, text_view, "GtkTextView*");
  return(s7_make_integer(sc, gtk_text_view_get_wrap_mode((GtkTextView*)s7_c_pointer(text_view))));
}

static s7_pointer lg_gtk_text_view_set_editable(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_set_editable "void gtk_text_view_set_editable(GtkTextView* text_view, gboolean setting)"
  s7_pointer _p;
  s7_pointer text_view, setting;
  _p = args;
  text_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(text_view, GtkTextView__sym)) s7_wrong_type_arg_error(sc, "gtk_text_view_set_editable", 1, text_view, "GtkTextView*");
  setting = s7_car(_p);
  if (!s7_is_boolean(setting)) s7_wrong_type_arg_error(sc, "gtk_text_view_set_editable", 2, setting, "gboolean");
  gtk_text_view_set_editable((GtkTextView*)s7_c_pointer(text_view), (gboolean)lg_boolean(setting));
  return(lg_false);
}

static s7_pointer lg_gtk_text_view_get_editable(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_get_editable "gboolean gtk_text_view_get_editable(GtkTextView* text_view)"
  s7_pointer text_view;
  text_view = s7_car(args);
  if (!s7_is_c_pointer_of_type(text_view, GtkTextView__sym)) s7_wrong_type_arg_error(sc, "gtk_text_view_get_editable", 1, text_view, "GtkTextView*");
  return(s7_make_boolean(sc, gtk_text_view_get_editable((GtkTextView*)s7_c_pointer(text_view))));
}

static s7_pointer lg_gtk_text_view_set_pixels_above_lines(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_set_pixels_above_lines "void gtk_text_view_set_pixels_above_lines(GtkTextView* text_view, \
gint pixels_above_lines)"
  s7_pointer _p;
  s7_pointer text_view, pixels_above_lines;
  _p = args;
  text_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(text_view, GtkTextView__sym)) s7_wrong_type_arg_error(sc, "gtk_text_view_set_pixels_above_lines", 1, text_view, "GtkTextView*");
  pixels_above_lines = s7_car(_p);
  if (!s7_is_integer(pixels_above_lines)) s7_wrong_type_arg_error(sc, "gtk_text_view_set_pixels_above_lines", 2, pixels_above_lines, "gint");
  gtk_text_view_set_pixels_above_lines((GtkTextView*)s7_c_pointer(text_view), (gint)s7_integer(pixels_above_lines));
  return(lg_false);
}

static s7_pointer lg_gtk_text_view_get_pixels_above_lines(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_get_pixels_above_lines "gint gtk_text_view_get_pixels_above_lines(GtkTextView* text_view)"
  s7_pointer text_view;
  text_view = s7_car(args);
  if (!s7_is_c_pointer_of_type(text_view, GtkTextView__sym)) s7_wrong_type_arg_error(sc, "gtk_text_view_get_pixels_above_lines", 1, text_view, "GtkTextView*");
  return(s7_make_integer(sc, gtk_text_view_get_pixels_above_lines((GtkTextView*)s7_c_pointer(text_view))));
}

static s7_pointer lg_gtk_text_view_set_pixels_below_lines(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_set_pixels_below_lines "void gtk_text_view_set_pixels_below_lines(GtkTextView* text_view, \
gint pixels_below_lines)"
  s7_pointer _p;
  s7_pointer text_view, pixels_below_lines;
  _p = args;
  text_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(text_view, GtkTextView__sym)) s7_wrong_type_arg_error(sc, "gtk_text_view_set_pixels_below_lines", 1, text_view, "GtkTextView*");
  pixels_below_lines = s7_car(_p);
  if (!s7_is_integer(pixels_below_lines)) s7_wrong_type_arg_error(sc, "gtk_text_view_set_pixels_below_lines", 2, pixels_below_lines, "gint");
  gtk_text_view_set_pixels_below_lines((GtkTextView*)s7_c_pointer(text_view), (gint)s7_integer(pixels_below_lines));
  return(lg_false);
}

static s7_pointer lg_gtk_text_view_get_pixels_below_lines(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_get_pixels_below_lines "gint gtk_text_view_get_pixels_below_lines(GtkTextView* text_view)"
  s7_pointer text_view;
  text_view = s7_car(args);
  if (!s7_is_c_pointer_of_type(text_view, GtkTextView__sym)) s7_wrong_type_arg_error(sc, "gtk_text_view_get_pixels_below_lines", 1, text_view, "GtkTextView*");
  return(s7_make_integer(sc, gtk_text_view_get_pixels_below_lines((GtkTextView*)s7_c_pointer(text_view))));
}

static s7_pointer lg_gtk_text_view_set_pixels_inside_wrap(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_set_pixels_inside_wrap "void gtk_text_view_set_pixels_inside_wrap(GtkTextView* text_view, \
gint pixels_inside_wrap)"
  s7_pointer _p;
  s7_pointer text_view, pixels_inside_wrap;
  _p = args;
  text_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(text_view, GtkTextView__sym)) s7_wrong_type_arg_error(sc, "gtk_text_view_set_pixels_inside_wrap", 1, text_view, "GtkTextView*");
  pixels_inside_wrap = s7_car(_p);
  if (!s7_is_integer(pixels_inside_wrap)) s7_wrong_type_arg_error(sc, "gtk_text_view_set_pixels_inside_wrap", 2, pixels_inside_wrap, "gint");
  gtk_text_view_set_pixels_inside_wrap((GtkTextView*)s7_c_pointer(text_view), (gint)s7_integer(pixels_inside_wrap));
  return(lg_false);
}

static s7_pointer lg_gtk_text_view_get_pixels_inside_wrap(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_get_pixels_inside_wrap "gint gtk_text_view_get_pixels_inside_wrap(GtkTextView* text_view)"
  s7_pointer text_view;
  text_view = s7_car(args);
  if (!s7_is_c_pointer_of_type(text_view, GtkTextView__sym)) s7_wrong_type_arg_error(sc, "gtk_text_view_get_pixels_inside_wrap", 1, text_view, "GtkTextView*");
  return(s7_make_integer(sc, gtk_text_view_get_pixels_inside_wrap((GtkTextView*)s7_c_pointer(text_view))));
}

static s7_pointer lg_gtk_text_view_set_justification(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_set_justification "void gtk_text_view_set_justification(GtkTextView* text_view, \
GtkJustification justification)"
  s7_pointer _p;
  s7_pointer text_view, justification;
  _p = args;
  text_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(text_view, GtkTextView__sym)) s7_wrong_type_arg_error(sc, "gtk_text_view_set_justification", 1, text_view, "GtkTextView*");
  justification = s7_car(_p);
  if (!s7_is_integer(justification)) s7_wrong_type_arg_error(sc, "gtk_text_view_set_justification", 2, justification, "GtkJustification");
  gtk_text_view_set_justification((GtkTextView*)s7_c_pointer(text_view), (GtkJustification)s7_integer(justification));
  return(lg_false);
}

static s7_pointer lg_gtk_text_view_get_justification(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_get_justification "GtkJustification gtk_text_view_get_justification(GtkTextView* text_view)"
  s7_pointer text_view;
  text_view = s7_car(args);
  if (!s7_is_c_pointer_of_type(text_view, GtkTextView__sym)) s7_wrong_type_arg_error(sc, "gtk_text_view_get_justification", 1, text_view, "GtkTextView*");
  return(s7_make_integer(sc, gtk_text_view_get_justification((GtkTextView*)s7_c_pointer(text_view))));
}

static s7_pointer lg_gtk_text_view_set_left_margin(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_set_left_margin "void gtk_text_view_set_left_margin(GtkTextView* text_view, \
gint left_margin)"
  s7_pointer _p;
  s7_pointer text_view, left_margin;
  _p = args;
  text_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(text_view, GtkTextView__sym)) s7_wrong_type_arg_error(sc, "gtk_text_view_set_left_margin", 1, text_view, "GtkTextView*");
  left_margin = s7_car(_p);
  if (!s7_is_integer(left_margin)) s7_wrong_type_arg_error(sc, "gtk_text_view_set_left_margin", 2, left_margin, "gint");
  gtk_text_view_set_left_margin((GtkTextView*)s7_c_pointer(text_view), (gint)s7_integer(left_margin));
  return(lg_false);
}

static s7_pointer lg_gtk_text_view_get_left_margin(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_get_left_margin "gint gtk_text_view_get_left_margin(GtkTextView* text_view)"
  s7_pointer text_view;
  text_view = s7_car(args);
  if (!s7_is_c_pointer_of_type(text_view, GtkTextView__sym)) s7_wrong_type_arg_error(sc, "gtk_text_view_get_left_margin", 1, text_view, "GtkTextView*");
  return(s7_make_integer(sc, gtk_text_view_get_left_margin((GtkTextView*)s7_c_pointer(text_view))));
}

static s7_pointer lg_gtk_text_view_set_right_margin(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_set_right_margin "void gtk_text_view_set_right_margin(GtkTextView* text_view, \
gint right_margin)"
  s7_pointer _p;
  s7_pointer text_view, right_margin;
  _p = args;
  text_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(text_view, GtkTextView__sym)) s7_wrong_type_arg_error(sc, "gtk_text_view_set_right_margin", 1, text_view, "GtkTextView*");
  right_margin = s7_car(_p);
  if (!s7_is_integer(right_margin)) s7_wrong_type_arg_error(sc, "gtk_text_view_set_right_margin", 2, right_margin, "gint");
  gtk_text_view_set_right_margin((GtkTextView*)s7_c_pointer(text_view), (gint)s7_integer(right_margin));
  return(lg_false);
}

static s7_pointer lg_gtk_text_view_get_right_margin(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_get_right_margin "gint gtk_text_view_get_right_margin(GtkTextView* text_view)"
  s7_pointer text_view;
  text_view = s7_car(args);
  if (!s7_is_c_pointer_of_type(text_view, GtkTextView__sym)) s7_wrong_type_arg_error(sc, "gtk_text_view_get_right_margin", 1, text_view, "GtkTextView*");
  return(s7_make_integer(sc, gtk_text_view_get_right_margin((GtkTextView*)s7_c_pointer(text_view))));
}

static s7_pointer lg_gtk_text_view_set_indent(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_set_indent "void gtk_text_view_set_indent(GtkTextView* text_view, gint indent)"
  s7_pointer _p;
  s7_pointer text_view, indent;
  _p = args;
  text_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(text_view, GtkTextView__sym)) s7_wrong_type_arg_error(sc, "gtk_text_view_set_indent", 1, text_view, "GtkTextView*");
  indent = s7_car(_p);
  if (!s7_is_integer(indent)) s7_wrong_type_arg_error(sc, "gtk_text_view_set_indent", 2, indent, "gint");
  gtk_text_view_set_indent((GtkTextView*)s7_c_pointer(text_view), (gint)s7_integer(indent));
  return(lg_false);
}

static s7_pointer lg_gtk_text_view_get_indent(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_get_indent "gint gtk_text_view_get_indent(GtkTextView* text_view)"
  s7_pointer text_view;
  text_view = s7_car(args);
  if (!s7_is_c_pointer_of_type(text_view, GtkTextView__sym)) s7_wrong_type_arg_error(sc, "gtk_text_view_get_indent", 1, text_view, "GtkTextView*");
  return(s7_make_integer(sc, gtk_text_view_get_indent((GtkTextView*)s7_c_pointer(text_view))));
}

static s7_pointer lg_gtk_text_view_set_tabs(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_set_tabs "void gtk_text_view_set_tabs(GtkTextView* text_view, PangoTabArray* tabs)"
  s7_pointer _p;
  s7_pointer text_view, tabs;
  _p = args;
  text_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(text_view, GtkTextView__sym)) s7_wrong_type_arg_error(sc, "gtk_text_view_set_tabs", 1, text_view, "GtkTextView*");
  tabs = s7_car(_p);
  if ((!s7_is_c_pointer_of_type(tabs, PangoTabArray__sym)) && (tabs != lg_false)) s7_wrong_type_arg_error(sc, "gtk_text_view_set_tabs", 2, tabs, "PangoTabArray*");
  gtk_text_view_set_tabs((GtkTextView*)s7_c_pointer(text_view), (PangoTabArray*)s7_c_pointer(tabs));
  return(lg_false);
}

static s7_pointer lg_gtk_text_view_get_tabs(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_get_tabs "PangoTabArray* gtk_text_view_get_tabs(GtkTextView* text_view)"
  s7_pointer text_view;
  text_view = s7_car(args);
  if (!s7_is_c_pointer_of_type(text_view, GtkTextView__sym)) s7_wrong_type_arg_error(sc, "gtk_text_view_get_tabs", 1, text_view, "GtkTextView*");
  return(lg_make_c_pointer_with_type(sc, PangoTabArray__sym, gtk_text_view_get_tabs((GtkTextView*)s7_c_pointer(text_view))));
}

static s7_pointer lg_gtk_toggle_button_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_toggle_button_new "GtkWidget* gtk_toggle_button_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_toggle_button_new()));
}

static s7_pointer lg_gtk_toggle_button_new_with_label(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_toggle_button_new_with_label "GtkWidget* gtk_toggle_button_new_with_label(gchar* label)"
  s7_pointer label;
  label = s7_car(args);
  if (!s7_is_string(label)) s7_wrong_type_arg_error(sc, "gtk_toggle_button_new_with_label", 1, label, "gchar*");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_toggle_button_new_with_label((gchar*)s7_string(label))));
}

static s7_pointer lg_gtk_toggle_button_new_with_mnemonic(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_toggle_button_new_with_mnemonic "GtkWidget* gtk_toggle_button_new_with_mnemonic(gchar* label)"
  s7_pointer label;
  label = s7_car(args);
  if (!s7_is_string(label)) s7_wrong_type_arg_error(sc, "gtk_toggle_button_new_with_mnemonic", 1, label, "gchar*");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_toggle_button_new_with_mnemonic((gchar*)s7_string(label))));
}

static s7_pointer lg_gtk_toggle_button_set_active(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_toggle_button_set_active "void gtk_toggle_button_set_active(GtkToggleButton* toggle_button, \
gboolean is_active)"
  s7_pointer _p;
  s7_pointer toggle_button, is_active;
  _p = args;
  toggle_button = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(toggle_button, GtkToggleButton__sym)) s7_wrong_type_arg_error(sc, "gtk_toggle_button_set_active", 1, toggle_button, "GtkToggleButton*");
  is_active = s7_car(_p);
  if (!s7_is_boolean(is_active)) s7_wrong_type_arg_error(sc, "gtk_toggle_button_set_active", 2, is_active, "gboolean");
  gtk_toggle_button_set_active((GtkToggleButton*)s7_c_pointer(toggle_button), (gboolean)lg_boolean(is_active));
  return(lg_false);
}

static s7_pointer lg_gtk_toggle_button_get_active(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_toggle_button_get_active "gboolean gtk_toggle_button_get_active(GtkToggleButton* toggle_button)"
  s7_pointer toggle_button;
  toggle_button = s7_car(args);
  if (!s7_is_c_pointer_of_type(toggle_button, GtkToggleButton__sym)) s7_wrong_type_arg_error(sc, "gtk_toggle_button_get_active", 1, toggle_button, "GtkToggleButton*");
  return(s7_make_boolean(sc, gtk_toggle_button_get_active((GtkToggleButton*)s7_c_pointer(toggle_button))));
}

static s7_pointer lg_gtk_toggle_button_toggled(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_toggle_button_toggled "void gtk_toggle_button_toggled(GtkToggleButton* toggle_button)"
  s7_pointer toggle_button;
  toggle_button = s7_car(args);
  if (!s7_is_c_pointer_of_type(toggle_button, GtkToggleButton__sym)) s7_wrong_type_arg_error(sc, "gtk_toggle_button_toggled", 1, toggle_button, "GtkToggleButton*");
  gtk_toggle_button_toggled((GtkToggleButton*)s7_c_pointer(toggle_button));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_drag_source_row_draggable(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_drag_source_row_draggable "gboolean gtk_tree_drag_source_row_draggable(GtkTreeDragSource* drag_source, \
GtkTreePath* path)"
  s7_pointer _p;
  s7_pointer drag_source, path;
  _p = args;
  drag_source = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(drag_source, GtkTreeDragSource__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_drag_source_row_draggable", 1, drag_source, "GtkTreeDragSource*");
  path = s7_car(_p);
  if (!s7_is_c_pointer_of_type(path, GtkTreePath__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_drag_source_row_draggable", 2, path, "GtkTreePath*");
  return(s7_make_boolean(sc, gtk_tree_drag_source_row_draggable((GtkTreeDragSource*)s7_c_pointer(drag_source), (GtkTreePath*)s7_c_pointer(path))));
}

static s7_pointer lg_gtk_tree_drag_source_drag_data_delete(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_drag_source_drag_data_delete "gboolean gtk_tree_drag_source_drag_data_delete(GtkTreeDragSource* drag_source, \
GtkTreePath* path)"
  s7_pointer _p;
  s7_pointer drag_source, path;
  _p = args;
  drag_source = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(drag_source, GtkTreeDragSource__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_drag_source_drag_data_delete", 1, drag_source, "GtkTreeDragSource*");
  path = s7_car(_p);
  if (!s7_is_c_pointer_of_type(path, GtkTreePath__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_drag_source_drag_data_delete", 2, path, "GtkTreePath*");
  return(s7_make_boolean(sc, gtk_tree_drag_source_drag_data_delete((GtkTreeDragSource*)s7_c_pointer(drag_source), (GtkTreePath*)s7_c_pointer(path))));
}

static s7_pointer lg_gtk_tree_path_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_path_new "GtkTreePath* gtk_tree_path_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkTreePath__sym, gtk_tree_path_new()));
}

static s7_pointer lg_gtk_tree_path_new_from_string(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_path_new_from_string "GtkTreePath* gtk_tree_path_new_from_string(gchar* path)"
  s7_pointer path;
  path = s7_car(args);
  if (!s7_is_string(path)) s7_wrong_type_arg_error(sc, "gtk_tree_path_new_from_string", 1, path, "gchar*");
  return(lg_make_c_pointer_with_type(sc, GtkTreePath__sym, gtk_tree_path_new_from_string((gchar*)s7_string(path))));
}

static s7_pointer lg_gtk_tree_path_to_string(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_path_to_string "gchar* gtk_tree_path_to_string(GtkTreePath* path)"
  s7_pointer path;
  path = s7_car(args);
  if (!s7_is_c_pointer_of_type(path, GtkTreePath__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_path_to_string", 1, path, "GtkTreePath*");
  {
    gchar* res_ult;
    s7_pointer rtn;
    res_ult = gtk_tree_path_to_string((GtkTreePath*)s7_c_pointer(path));
    rtn = s7_make_string(sc, res_ult);
    g_free(res_ult);
    return(rtn);
  }
}

static s7_pointer lg_gtk_tree_path_new_first(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_path_new_first "GtkTreePath* gtk_tree_path_new_first( void)"
  return(lg_make_c_pointer_with_type(sc, GtkTreePath__sym, gtk_tree_path_new_first()));
}

static s7_pointer lg_gtk_tree_path_append_index(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_path_append_index "void gtk_tree_path_append_index(GtkTreePath* path, gint index)"
  s7_pointer _p;
  s7_pointer path, index;
  _p = args;
  path = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(path, GtkTreePath__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_path_append_index", 1, path, "GtkTreePath*");
  index = s7_car(_p);
  if (!s7_is_integer(index)) s7_wrong_type_arg_error(sc, "gtk_tree_path_append_index", 2, index, "gint");
  gtk_tree_path_append_index((GtkTreePath*)s7_c_pointer(path), (gint)s7_integer(index));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_path_prepend_index(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_path_prepend_index "void gtk_tree_path_prepend_index(GtkTreePath* path, gint index)"
  s7_pointer _p;
  s7_pointer path, index;
  _p = args;
  path = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(path, GtkTreePath__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_path_prepend_index", 1, path, "GtkTreePath*");
  index = s7_car(_p);
  if (!s7_is_integer(index)) s7_wrong_type_arg_error(sc, "gtk_tree_path_prepend_index", 2, index, "gint");
  gtk_tree_path_prepend_index((GtkTreePath*)s7_c_pointer(path), (gint)s7_integer(index));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_path_get_depth(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_path_get_depth "gint gtk_tree_path_get_depth(GtkTreePath* path)"
  s7_pointer path;
  path = s7_car(args);
  if (!s7_is_c_pointer_of_type(path, GtkTreePath__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_path_get_depth", 1, path, "GtkTreePath*");
  return(s7_make_integer(sc, gtk_tree_path_get_depth((GtkTreePath*)s7_c_pointer(path))));
}

static s7_pointer lg_gtk_tree_path_get_indices(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_path_get_indices "gint* gtk_tree_path_get_indices(GtkTreePath* path)"
  s7_pointer path;
  path = s7_car(args);
  if (!s7_is_c_pointer_of_type(path, GtkTreePath__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_path_get_indices", 1, path, "GtkTreePath*");
  return(lg_make_c_pointer_with_type(sc, gint__sym, gtk_tree_path_get_indices((GtkTreePath*)s7_c_pointer(path))));
}

static s7_pointer lg_gtk_tree_path_free(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_path_free "void gtk_tree_path_free(GtkTreePath* path)"
  s7_pointer path;
  path = s7_car(args);
  if (!s7_is_c_pointer_of_type(path, GtkTreePath__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_path_free", 1, path, "GtkTreePath*");
  gtk_tree_path_free((GtkTreePath*)s7_c_pointer(path));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_path_copy(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_path_copy "GtkTreePath* gtk_tree_path_copy(GtkTreePath* path)"
  s7_pointer path;
  path = s7_car(args);
  if (!s7_is_c_pointer_of_type(path, GtkTreePath__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_path_copy", 1, path, "GtkTreePath*");
  return(lg_make_c_pointer_with_type(sc, GtkTreePath__sym, gtk_tree_path_copy((GtkTreePath*)s7_c_pointer(path))));
}

static s7_pointer lg_gtk_tree_path_compare(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_path_compare "gint gtk_tree_path_compare(GtkTreePath* a, GtkTreePath* b)"
  s7_pointer _p;
  s7_pointer a, b;
  _p = args;
  a = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(a, GtkTreePath__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_path_compare", 1, a, "GtkTreePath*");
  b = s7_car(_p);
  if (!s7_is_c_pointer_of_type(b, GtkTreePath__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_path_compare", 2, b, "GtkTreePath*");
  return(s7_make_integer(sc, gtk_tree_path_compare((GtkTreePath*)s7_c_pointer(a), (GtkTreePath*)s7_c_pointer(b))));
}

static s7_pointer lg_gtk_tree_path_next(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_path_next "void gtk_tree_path_next(GtkTreePath* path)"
  s7_pointer path;
  path = s7_car(args);
  if (!s7_is_c_pointer_of_type(path, GtkTreePath__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_path_next", 1, path, "GtkTreePath*");
  gtk_tree_path_next((GtkTreePath*)s7_c_pointer(path));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_path_prev(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_path_prev "gboolean gtk_tree_path_prev(GtkTreePath* path)"
  s7_pointer path;
  path = s7_car(args);
  if (!s7_is_c_pointer_of_type(path, GtkTreePath__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_path_prev", 1, path, "GtkTreePath*");
  return(s7_make_boolean(sc, gtk_tree_path_prev((GtkTreePath*)s7_c_pointer(path))));
}

static s7_pointer lg_gtk_tree_path_up(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_path_up "gboolean gtk_tree_path_up(GtkTreePath* path)"
  s7_pointer path;
  path = s7_car(args);
  if (!s7_is_c_pointer_of_type(path, GtkTreePath__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_path_up", 1, path, "GtkTreePath*");
  return(s7_make_boolean(sc, gtk_tree_path_up((GtkTreePath*)s7_c_pointer(path))));
}

static s7_pointer lg_gtk_tree_path_down(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_path_down "void gtk_tree_path_down(GtkTreePath* path)"
  s7_pointer path;
  path = s7_car(args);
  if (!s7_is_c_pointer_of_type(path, GtkTreePath__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_path_down", 1, path, "GtkTreePath*");
  gtk_tree_path_down((GtkTreePath*)s7_c_pointer(path));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_path_is_ancestor(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_path_is_ancestor "gboolean gtk_tree_path_is_ancestor(GtkTreePath* path, GtkTreePath* descendant)"
  s7_pointer _p;
  s7_pointer path, descendant;
  _p = args;
  path = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(path, GtkTreePath__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_path_is_ancestor", 1, path, "GtkTreePath*");
  descendant = s7_car(_p);
  if (!s7_is_c_pointer_of_type(descendant, GtkTreePath__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_path_is_ancestor", 2, descendant, "GtkTreePath*");
  return(s7_make_boolean(sc, gtk_tree_path_is_ancestor((GtkTreePath*)s7_c_pointer(path), (GtkTreePath*)s7_c_pointer(descendant))));
}

static s7_pointer lg_gtk_tree_path_is_descendant(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_path_is_descendant "gboolean gtk_tree_path_is_descendant(GtkTreePath* path, GtkTreePath* ancestor)"
  s7_pointer _p;
  s7_pointer path, ancestor;
  _p = args;
  path = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(path, GtkTreePath__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_path_is_descendant", 1, path, "GtkTreePath*");
  ancestor = s7_car(_p);
  if (!s7_is_c_pointer_of_type(ancestor, GtkTreePath__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_path_is_descendant", 2, ancestor, "GtkTreePath*");
  return(s7_make_boolean(sc, gtk_tree_path_is_descendant((GtkTreePath*)s7_c_pointer(path), (GtkTreePath*)s7_c_pointer(ancestor))));
}

static s7_pointer lg_gtk_tree_row_reference_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_row_reference_new "GtkTreeRowReference* gtk_tree_row_reference_new(GtkTreeModel* model, \
GtkTreePath* path)"
  s7_pointer _p;
  s7_pointer model, path;
  _p = args;
  model = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(model, GtkTreeModel__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_row_reference_new", 1, model, "GtkTreeModel*");
  path = s7_car(_p);
  if (!s7_is_c_pointer_of_type(path, GtkTreePath__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_row_reference_new", 2, path, "GtkTreePath*");
  return(lg_make_c_pointer_with_type(sc, GtkTreeRowReference__sym, gtk_tree_row_reference_new((GtkTreeModel*)s7_c_pointer(model), (GtkTreePath*)s7_c_pointer(path))));
}

static s7_pointer lg_gtk_tree_row_reference_new_proxy(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_row_reference_new_proxy "GtkTreeRowReference* gtk_tree_row_reference_new_proxy(GObject* proxy, \
GtkTreeModel* model, GtkTreePath* path)"
  s7_pointer _p;
  s7_pointer proxy, model, path;
  _p = args;
  proxy = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(proxy, GObject__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_row_reference_new_proxy", 1, proxy, "GObject*");
  model = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(model, GtkTreeModel__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_row_reference_new_proxy", 2, model, "GtkTreeModel*");
  path = s7_car(_p);
  if (!s7_is_c_pointer_of_type(path, GtkTreePath__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_row_reference_new_proxy", 3, path, "GtkTreePath*");
  return(lg_make_c_pointer_with_type(sc, GtkTreeRowReference__sym, gtk_tree_row_reference_new_proxy((GObject*)s7_c_pointer(proxy), (GtkTreeModel*)s7_c_pointer(model), (GtkTreePath*)s7_c_pointer(path))));
}

static s7_pointer lg_gtk_tree_row_reference_get_path(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_row_reference_get_path "GtkTreePath* gtk_tree_row_reference_get_path(GtkTreeRowReference* reference)"
  s7_pointer reference;
  reference = s7_car(args);
  if (!s7_is_c_pointer_of_type(reference, GtkTreeRowReference__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_row_reference_get_path", 1, reference, "GtkTreeRowReference*");
  return(lg_make_c_pointer_with_type(sc, GtkTreePath__sym, gtk_tree_row_reference_get_path((GtkTreeRowReference*)s7_c_pointer(reference))));
}

static s7_pointer lg_gtk_tree_row_reference_valid(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_row_reference_valid "gboolean gtk_tree_row_reference_valid(GtkTreeRowReference* reference)"
  s7_pointer reference;
  reference = s7_car(args);
  if (!s7_is_c_pointer_of_type(reference, GtkTreeRowReference__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_row_reference_valid", 1, reference, "GtkTreeRowReference*");
  return(s7_make_boolean(sc, gtk_tree_row_reference_valid((GtkTreeRowReference*)s7_c_pointer(reference))));
}

static s7_pointer lg_gtk_tree_row_reference_free(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_row_reference_free "void gtk_tree_row_reference_free(GtkTreeRowReference* reference)"
  s7_pointer reference;
  reference = s7_car(args);
  if (!s7_is_c_pointer_of_type(reference, GtkTreeRowReference__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_row_reference_free", 1, reference, "GtkTreeRowReference*");
  gtk_tree_row_reference_free((GtkTreeRowReference*)s7_c_pointer(reference));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_row_reference_inserted(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_row_reference_inserted "void gtk_tree_row_reference_inserted(GObject* proxy, GtkTreePath* path)"
  s7_pointer _p;
  s7_pointer proxy, path;
  _p = args;
  proxy = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(proxy, GObject__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_row_reference_inserted", 1, proxy, "GObject*");
  path = s7_car(_p);
  if (!s7_is_c_pointer_of_type(path, GtkTreePath__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_row_reference_inserted", 2, path, "GtkTreePath*");
  gtk_tree_row_reference_inserted((GObject*)s7_c_pointer(proxy), (GtkTreePath*)s7_c_pointer(path));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_row_reference_deleted(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_row_reference_deleted "void gtk_tree_row_reference_deleted(GObject* proxy, GtkTreePath* path)"
  s7_pointer _p;
  s7_pointer proxy, path;
  _p = args;
  proxy = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(proxy, GObject__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_row_reference_deleted", 1, proxy, "GObject*");
  path = s7_car(_p);
  if (!s7_is_c_pointer_of_type(path, GtkTreePath__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_row_reference_deleted", 2, path, "GtkTreePath*");
  gtk_tree_row_reference_deleted((GObject*)s7_c_pointer(proxy), (GtkTreePath*)s7_c_pointer(path));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_row_reference_reordered(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_row_reference_reordered "void gtk_tree_row_reference_reordered(GObject* proxy, GtkTreePath* path, \
GtkTreeIter* iter, gint* new_order)"
  s7_pointer _p;
  s7_pointer proxy, path, iter, new_order;
  _p = args;
  proxy = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(proxy, GObject__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_row_reference_reordered", 1, proxy, "GObject*");
  path = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(path, GtkTreePath__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_row_reference_reordered", 2, path, "GtkTreePath*");
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTreeIter__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_row_reference_reordered", 3, iter, "GtkTreeIter*");
  new_order = s7_car(_p);
  if (!s7_is_c_pointer_of_type(new_order, gint__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_row_reference_reordered", 4, new_order, "gint*");
  gtk_tree_row_reference_reordered((GObject*)s7_c_pointer(proxy), (GtkTreePath*)s7_c_pointer(path), (GtkTreeIter*)s7_c_pointer(iter), (gint*)s7_c_pointer(new_order));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_iter_copy(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_iter_copy "GtkTreeIter* gtk_tree_iter_copy(GtkTreeIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  if (!s7_is_c_pointer_of_type(iter, GtkTreeIter__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_iter_copy", 1, iter, "GtkTreeIter*");
  return(lg_make_c_pointer_with_type(sc, GtkTreeIter__sym, gtk_tree_iter_copy((GtkTreeIter*)s7_c_pointer(iter))));
}

static s7_pointer lg_gtk_tree_iter_free(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_iter_free "void gtk_tree_iter_free(GtkTreeIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  if (!s7_is_c_pointer_of_type(iter, GtkTreeIter__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_iter_free", 1, iter, "GtkTreeIter*");
  gtk_tree_iter_free((GtkTreeIter*)s7_c_pointer(iter));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_model_get_flags(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_get_flags "GtkTreeModelFlags gtk_tree_model_get_flags(GtkTreeModel* tree_model)"
  s7_pointer tree_model;
  tree_model = s7_car(args);
  if (!s7_is_c_pointer_of_type(tree_model, GtkTreeModel__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_get_flags", 1, tree_model, "GtkTreeModel*");
  return(s7_make_integer(sc, gtk_tree_model_get_flags((GtkTreeModel*)s7_c_pointer(tree_model))));
}

static s7_pointer lg_gtk_tree_model_get_n_columns(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_get_n_columns "gint gtk_tree_model_get_n_columns(GtkTreeModel* tree_model)"
  s7_pointer tree_model;
  tree_model = s7_car(args);
  if (!s7_is_c_pointer_of_type(tree_model, GtkTreeModel__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_get_n_columns", 1, tree_model, "GtkTreeModel*");
  return(s7_make_integer(sc, gtk_tree_model_get_n_columns((GtkTreeModel*)s7_c_pointer(tree_model))));
}

static s7_pointer lg_gtk_tree_model_get_column_type(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_get_column_type "GType gtk_tree_model_get_column_type(GtkTreeModel* tree_model, \
gint index)"
  s7_pointer _p;
  s7_pointer tree_model, index;
  _p = args;
  tree_model = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_model, GtkTreeModel__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_get_column_type", 1, tree_model, "GtkTreeModel*");
  index = s7_car(_p);
  if (!s7_is_integer(index)) s7_wrong_type_arg_error(sc, "gtk_tree_model_get_column_type", 2, index, "gint");
  return(s7_make_integer(sc, gtk_tree_model_get_column_type((GtkTreeModel*)s7_c_pointer(tree_model), (gint)s7_integer(index))));
}

static s7_pointer lg_gtk_tree_model_get_iter(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_get_iter "gboolean gtk_tree_model_get_iter(GtkTreeModel* tree_model, GtkTreeIter* iter, \
GtkTreePath* path)"
  s7_pointer _p;
  s7_pointer tree_model, iter, path;
  _p = args;
  tree_model = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_model, GtkTreeModel__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_get_iter", 1, tree_model, "GtkTreeModel*");
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTreeIter__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_get_iter", 2, iter, "GtkTreeIter*");
  path = s7_car(_p);
  if (!s7_is_c_pointer_of_type(path, GtkTreePath__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_get_iter", 3, path, "GtkTreePath*");
  return(s7_make_boolean(sc, gtk_tree_model_get_iter((GtkTreeModel*)s7_c_pointer(tree_model), (GtkTreeIter*)s7_c_pointer(iter), (GtkTreePath*)s7_c_pointer(path))));
}

static s7_pointer lg_gtk_tree_model_get_iter_from_string(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_get_iter_from_string "gboolean gtk_tree_model_get_iter_from_string(GtkTreeModel* tree_model, \
GtkTreeIter* iter, gchar* path_string)"
  s7_pointer _p;
  s7_pointer tree_model, iter, path_string;
  _p = args;
  tree_model = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_model, GtkTreeModel__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_get_iter_from_string", 1, tree_model, "GtkTreeModel*");
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTreeIter__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_get_iter_from_string", 2, iter, "GtkTreeIter*");
  path_string = s7_car(_p);
  if (!s7_is_string(path_string)) s7_wrong_type_arg_error(sc, "gtk_tree_model_get_iter_from_string", 3, path_string, "gchar*");
  return(s7_make_boolean(sc, gtk_tree_model_get_iter_from_string((GtkTreeModel*)s7_c_pointer(tree_model), (GtkTreeIter*)s7_c_pointer(iter), (gchar*)s7_string(path_string))));
}

static s7_pointer lg_gtk_tree_model_get_iter_first(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_get_iter_first "gboolean gtk_tree_model_get_iter_first(GtkTreeModel* tree_model, \
GtkTreeIter* iter)"
  s7_pointer _p;
  s7_pointer tree_model, iter;
  _p = args;
  tree_model = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_model, GtkTreeModel__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_get_iter_first", 1, tree_model, "GtkTreeModel*");
  iter = s7_car(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTreeIter__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_get_iter_first", 2, iter, "GtkTreeIter*");
  return(s7_make_boolean(sc, gtk_tree_model_get_iter_first((GtkTreeModel*)s7_c_pointer(tree_model), (GtkTreeIter*)s7_c_pointer(iter))));
}

static s7_pointer lg_gtk_tree_model_get_path(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_get_path "GtkTreePath* gtk_tree_model_get_path(GtkTreeModel* tree_model, GtkTreeIter* iter)"
  s7_pointer _p;
  s7_pointer tree_model, iter;
  _p = args;
  tree_model = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_model, GtkTreeModel__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_get_path", 1, tree_model, "GtkTreeModel*");
  iter = s7_car(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTreeIter__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_get_path", 2, iter, "GtkTreeIter*");
  return(lg_make_c_pointer_with_type(sc, GtkTreePath__sym, gtk_tree_model_get_path((GtkTreeModel*)s7_c_pointer(tree_model), (GtkTreeIter*)s7_c_pointer(iter))));
}

static s7_pointer lg_gtk_tree_model_iter_next(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_iter_next "gboolean gtk_tree_model_iter_next(GtkTreeModel* tree_model, GtkTreeIter* iter)"
  s7_pointer _p;
  s7_pointer tree_model, iter;
  _p = args;
  tree_model = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_model, GtkTreeModel__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_iter_next", 1, tree_model, "GtkTreeModel*");
  iter = s7_car(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTreeIter__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_iter_next", 2, iter, "GtkTreeIter*");
  return(s7_make_boolean(sc, gtk_tree_model_iter_next((GtkTreeModel*)s7_c_pointer(tree_model), (GtkTreeIter*)s7_c_pointer(iter))));
}

static s7_pointer lg_gtk_tree_model_iter_children(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_iter_children "gboolean gtk_tree_model_iter_children(GtkTreeModel* tree_model, \
GtkTreeIter* iter, GtkTreeIter* parent)"
  s7_pointer _p;
  s7_pointer tree_model, iter, parent;
  _p = args;
  tree_model = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_model, GtkTreeModel__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_iter_children", 1, tree_model, "GtkTreeModel*");
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTreeIter__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_iter_children", 2, iter, "GtkTreeIter*");
  parent = s7_car(_p);
  if ((!s7_is_c_pointer_of_type(parent, GtkTreeIter__sym)) && (parent != lg_false)) s7_wrong_type_arg_error(sc, "gtk_tree_model_iter_children", 3, parent, "GtkTreeIter*");
  return(s7_make_boolean(sc, gtk_tree_model_iter_children((GtkTreeModel*)s7_c_pointer(tree_model), (GtkTreeIter*)s7_c_pointer(iter), (GtkTreeIter*)s7_c_pointer(parent))));
}

static s7_pointer lg_gtk_tree_model_iter_has_child(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_iter_has_child "gboolean gtk_tree_model_iter_has_child(GtkTreeModel* tree_model, \
GtkTreeIter* iter)"
  s7_pointer _p;
  s7_pointer tree_model, iter;
  _p = args;
  tree_model = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_model, GtkTreeModel__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_iter_has_child", 1, tree_model, "GtkTreeModel*");
  iter = s7_car(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTreeIter__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_iter_has_child", 2, iter, "GtkTreeIter*");
  return(s7_make_boolean(sc, gtk_tree_model_iter_has_child((GtkTreeModel*)s7_c_pointer(tree_model), (GtkTreeIter*)s7_c_pointer(iter))));
}

static s7_pointer lg_gtk_tree_model_iter_n_children(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_iter_n_children "gint gtk_tree_model_iter_n_children(GtkTreeModel* tree_model, \
GtkTreeIter* iter)"
  s7_pointer _p;
  s7_pointer tree_model, iter;
  _p = args;
  tree_model = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_model, GtkTreeModel__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_iter_n_children", 1, tree_model, "GtkTreeModel*");
  iter = s7_car(_p);
  if ((!s7_is_c_pointer_of_type(iter, GtkTreeIter__sym)) && (iter != lg_false)) s7_wrong_type_arg_error(sc, "gtk_tree_model_iter_n_children", 2, iter, "GtkTreeIter*");
  return(s7_make_integer(sc, gtk_tree_model_iter_n_children((GtkTreeModel*)s7_c_pointer(tree_model), (GtkTreeIter*)s7_c_pointer(iter))));
}

static s7_pointer lg_gtk_tree_model_iter_nth_child(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_iter_nth_child "gboolean gtk_tree_model_iter_nth_child(GtkTreeModel* tree_model, \
GtkTreeIter* iter, GtkTreeIter* parent, gint n)"
  s7_pointer _p;
  s7_pointer tree_model, iter, parent, n;
  _p = args;
  tree_model = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_model, GtkTreeModel__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_iter_nth_child", 1, tree_model, "GtkTreeModel*");
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTreeIter__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_iter_nth_child", 2, iter, "GtkTreeIter*");
  parent = s7_car(_p); _p = s7_cdr(_p);
  if ((!s7_is_c_pointer_of_type(parent, GtkTreeIter__sym)) && (parent != lg_false)) s7_wrong_type_arg_error(sc, "gtk_tree_model_iter_nth_child", 3, parent, "GtkTreeIter*");
  n = s7_car(_p);
  if (!s7_is_integer(n)) s7_wrong_type_arg_error(sc, "gtk_tree_model_iter_nth_child", 4, n, "gint");
  return(s7_make_boolean(sc, gtk_tree_model_iter_nth_child((GtkTreeModel*)s7_c_pointer(tree_model), (GtkTreeIter*)s7_c_pointer(iter), (GtkTreeIter*)s7_c_pointer(parent), (gint)s7_integer(n))));
}

static s7_pointer lg_gtk_tree_model_iter_parent(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_iter_parent "gboolean gtk_tree_model_iter_parent(GtkTreeModel* tree_model, \
GtkTreeIter* iter, GtkTreeIter* child)"
  s7_pointer _p;
  s7_pointer tree_model, iter, child;
  _p = args;
  tree_model = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_model, GtkTreeModel__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_iter_parent", 1, tree_model, "GtkTreeModel*");
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTreeIter__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_iter_parent", 2, iter, "GtkTreeIter*");
  child = s7_car(_p);
  if (!s7_is_c_pointer_of_type(child, GtkTreeIter__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_iter_parent", 3, child, "GtkTreeIter*");
  return(s7_make_boolean(sc, gtk_tree_model_iter_parent((GtkTreeModel*)s7_c_pointer(tree_model), (GtkTreeIter*)s7_c_pointer(iter), (GtkTreeIter*)s7_c_pointer(child))));
}

static s7_pointer lg_gtk_tree_model_ref_node(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_ref_node "void gtk_tree_model_ref_node(GtkTreeModel* tree_model, GtkTreeIter* iter)"
  s7_pointer _p;
  s7_pointer tree_model, iter;
  _p = args;
  tree_model = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_model, GtkTreeModel__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_ref_node", 1, tree_model, "GtkTreeModel*");
  iter = s7_car(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTreeIter__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_ref_node", 2, iter, "GtkTreeIter*");
  gtk_tree_model_ref_node((GtkTreeModel*)s7_c_pointer(tree_model), (GtkTreeIter*)s7_c_pointer(iter));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_model_unref_node(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_unref_node "void gtk_tree_model_unref_node(GtkTreeModel* tree_model, GtkTreeIter* iter)"
  s7_pointer _p;
  s7_pointer tree_model, iter;
  _p = args;
  tree_model = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_model, GtkTreeModel__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_unref_node", 1, tree_model, "GtkTreeModel*");
  iter = s7_car(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTreeIter__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_unref_node", 2, iter, "GtkTreeIter*");
  gtk_tree_model_unref_node((GtkTreeModel*)s7_c_pointer(tree_model), (GtkTreeIter*)s7_c_pointer(iter));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_model_foreach(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_foreach "void gtk_tree_model_foreach(GtkTreeModel* model, GtkTreeModelForeachFunc func, \
lambda_data func_info)"
  s7_pointer _p;
  s7_pointer model, func, func_info;
  _p = args;
  model = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(model, GtkTreeModel__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_foreach", 1, model, "GtkTreeModel*");
  func = s7_car(_p); _p = s7_cdr(_p);
  func_info = s7_car(_p);
  {
    int loc;
    s7_pointer lg_ptr = s7_list(sc, 5, func, func_info, lg_false, lg_false, lg_false);
    loc = s7_gc_protect(sc, lg_ptr);
    s7_list_set(sc, lg_ptr, 2, s7_make_integer(sc, loc));
    gtk_tree_model_foreach((GtkTreeModel*)s7_c_pointer(model), lg_model_func, (gpointer)lg_ptr);
    return(lg_false);
   }
}

static s7_pointer lg_gtk_tree_model_row_changed(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_row_changed "void gtk_tree_model_row_changed(GtkTreeModel* tree_model, GtkTreePath* path, \
GtkTreeIter* iter)"
  s7_pointer _p;
  s7_pointer tree_model, path, iter;
  _p = args;
  tree_model = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_model, GtkTreeModel__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_row_changed", 1, tree_model, "GtkTreeModel*");
  path = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(path, GtkTreePath__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_row_changed", 2, path, "GtkTreePath*");
  iter = s7_car(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTreeIter__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_row_changed", 3, iter, "GtkTreeIter*");
  gtk_tree_model_row_changed((GtkTreeModel*)s7_c_pointer(tree_model), (GtkTreePath*)s7_c_pointer(path), (GtkTreeIter*)s7_c_pointer(iter));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_model_row_inserted(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_row_inserted "void gtk_tree_model_row_inserted(GtkTreeModel* tree_model, GtkTreePath* path, \
GtkTreeIter* iter)"
  s7_pointer _p;
  s7_pointer tree_model, path, iter;
  _p = args;
  tree_model = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_model, GtkTreeModel__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_row_inserted", 1, tree_model, "GtkTreeModel*");
  path = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(path, GtkTreePath__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_row_inserted", 2, path, "GtkTreePath*");
  iter = s7_car(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTreeIter__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_row_inserted", 3, iter, "GtkTreeIter*");
  gtk_tree_model_row_inserted((GtkTreeModel*)s7_c_pointer(tree_model), (GtkTreePath*)s7_c_pointer(path), (GtkTreeIter*)s7_c_pointer(iter));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_model_row_has_child_toggled(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_row_has_child_toggled "void gtk_tree_model_row_has_child_toggled(GtkTreeModel* tree_model, \
GtkTreePath* path, GtkTreeIter* iter)"
  s7_pointer _p;
  s7_pointer tree_model, path, iter;
  _p = args;
  tree_model = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_model, GtkTreeModel__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_row_has_child_toggled", 1, tree_model, "GtkTreeModel*");
  path = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(path, GtkTreePath__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_row_has_child_toggled", 2, path, "GtkTreePath*");
  iter = s7_car(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTreeIter__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_row_has_child_toggled", 3, iter, "GtkTreeIter*");
  gtk_tree_model_row_has_child_toggled((GtkTreeModel*)s7_c_pointer(tree_model), (GtkTreePath*)s7_c_pointer(path), (GtkTreeIter*)s7_c_pointer(iter));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_model_row_deleted(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_row_deleted "void gtk_tree_model_row_deleted(GtkTreeModel* tree_model, GtkTreePath* path)"
  s7_pointer _p;
  s7_pointer tree_model, path;
  _p = args;
  tree_model = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_model, GtkTreeModel__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_row_deleted", 1, tree_model, "GtkTreeModel*");
  path = s7_car(_p);
  if (!s7_is_c_pointer_of_type(path, GtkTreePath__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_row_deleted", 2, path, "GtkTreePath*");
  gtk_tree_model_row_deleted((GtkTreeModel*)s7_c_pointer(tree_model), (GtkTreePath*)s7_c_pointer(path));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_model_rows_reordered(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_rows_reordered "void gtk_tree_model_rows_reordered(GtkTreeModel* tree_model, \
GtkTreePath* path, GtkTreeIter* iter, gint* new_order)"
  s7_pointer _p;
  s7_pointer tree_model, path, iter, new_order;
  _p = args;
  tree_model = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_model, GtkTreeModel__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_rows_reordered", 1, tree_model, "GtkTreeModel*");
  path = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(path, GtkTreePath__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_rows_reordered", 2, path, "GtkTreePath*");
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTreeIter__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_rows_reordered", 3, iter, "GtkTreeIter*");
  new_order = s7_car(_p);
  if (!s7_is_c_pointer_of_type(new_order, gint__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_rows_reordered", 4, new_order, "gint*");
  gtk_tree_model_rows_reordered((GtkTreeModel*)s7_c_pointer(tree_model), (GtkTreePath*)s7_c_pointer(path), (GtkTreeIter*)s7_c_pointer(iter), (gint*)s7_c_pointer(new_order));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_model_sort_new_with_model(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_sort_new_with_model "GtkTreeModel* gtk_tree_model_sort_new_with_model(GtkTreeModel* child_model)"
  s7_pointer child_model;
  child_model = s7_car(args);
  if (!s7_is_c_pointer_of_type(child_model, GtkTreeModel__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_sort_new_with_model", 1, child_model, "GtkTreeModel*");
  return(lg_make_c_pointer_with_type(sc, GtkTreeModel__sym, gtk_tree_model_sort_new_with_model((GtkTreeModel*)s7_c_pointer(child_model))));
}

static s7_pointer lg_gtk_tree_model_sort_get_model(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_sort_get_model "GtkTreeModel* gtk_tree_model_sort_get_model(GtkTreeModelSort* tree_model)"
  s7_pointer tree_model;
  tree_model = s7_car(args);
  if (!s7_is_c_pointer_of_type(tree_model, GtkTreeModelSort__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_sort_get_model", 1, tree_model, "GtkTreeModelSort*");
  return(lg_make_c_pointer_with_type(sc, GtkTreeModel__sym, gtk_tree_model_sort_get_model((GtkTreeModelSort*)s7_c_pointer(tree_model))));
}

static s7_pointer lg_gtk_tree_model_sort_convert_child_path_to_path(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_sort_convert_child_path_to_path "GtkTreePath* gtk_tree_model_sort_convert_child_path_to_path(GtkTreeModelSort* tree_model_sort, \
GtkTreePath* child_path)"
  s7_pointer _p;
  s7_pointer tree_model_sort, child_path;
  _p = args;
  tree_model_sort = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_model_sort, GtkTreeModelSort__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_sort_convert_child_path_to_path", 1, tree_model_sort, "GtkTreeModelSort*");
  child_path = s7_car(_p);
  if (!s7_is_c_pointer_of_type(child_path, GtkTreePath__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_sort_convert_child_path_to_path", 2, child_path, "GtkTreePath*");
  return(lg_make_c_pointer_with_type(sc, GtkTreePath__sym, gtk_tree_model_sort_convert_child_path_to_path((GtkTreeModelSort*)s7_c_pointer(tree_model_sort), (GtkTreePath*)s7_c_pointer(child_path))));
}

static s7_pointer lg_gtk_tree_model_sort_convert_child_iter_to_iter(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_sort_convert_child_iter_to_iter "void gtk_tree_model_sort_convert_child_iter_to_iter(GtkTreeModelSort* tree_model_sort, \
GtkTreeIter* sort_iter, GtkTreeIter* child_iter)"
  s7_pointer _p;
  s7_pointer tree_model_sort, sort_iter, child_iter;
  _p = args;
  tree_model_sort = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_model_sort, GtkTreeModelSort__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_sort_convert_child_iter_to_iter", 1, tree_model_sort, "GtkTreeModelSort*");
  sort_iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(sort_iter, GtkTreeIter__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_sort_convert_child_iter_to_iter", 2, sort_iter, "GtkTreeIter*");
  child_iter = s7_car(_p);
  if (!s7_is_c_pointer_of_type(child_iter, GtkTreeIter__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_sort_convert_child_iter_to_iter", 3, child_iter, "GtkTreeIter*");
  gtk_tree_model_sort_convert_child_iter_to_iter((GtkTreeModelSort*)s7_c_pointer(tree_model_sort), (GtkTreeIter*)s7_c_pointer(sort_iter), (GtkTreeIter*)s7_c_pointer(child_iter));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_model_sort_convert_path_to_child_path(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_sort_convert_path_to_child_path "GtkTreePath* gtk_tree_model_sort_convert_path_to_child_path(GtkTreeModelSort* tree_model_sort, \
GtkTreePath* sorted_path)"
  s7_pointer _p;
  s7_pointer tree_model_sort, sorted_path;
  _p = args;
  tree_model_sort = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_model_sort, GtkTreeModelSort__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_sort_convert_path_to_child_path", 1, tree_model_sort, "GtkTreeModelSort*");
  sorted_path = s7_car(_p);
  if (!s7_is_c_pointer_of_type(sorted_path, GtkTreePath__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_sort_convert_path_to_child_path", 2, sorted_path, "GtkTreePath*");
  return(lg_make_c_pointer_with_type(sc, GtkTreePath__sym, gtk_tree_model_sort_convert_path_to_child_path((GtkTreeModelSort*)s7_c_pointer(tree_model_sort), (GtkTreePath*)s7_c_pointer(sorted_path))));
}

static s7_pointer lg_gtk_tree_model_sort_convert_iter_to_child_iter(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_sort_convert_iter_to_child_iter "void gtk_tree_model_sort_convert_iter_to_child_iter(GtkTreeModelSort* tree_model_sort, \
GtkTreeIter* child_iter, GtkTreeIter* sorted_iter)"
  s7_pointer _p;
  s7_pointer tree_model_sort, child_iter, sorted_iter;
  _p = args;
  tree_model_sort = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_model_sort, GtkTreeModelSort__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_sort_convert_iter_to_child_iter", 1, tree_model_sort, "GtkTreeModelSort*");
  child_iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(child_iter, GtkTreeIter__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_sort_convert_iter_to_child_iter", 2, child_iter, "GtkTreeIter*");
  sorted_iter = s7_car(_p);
  if (!s7_is_c_pointer_of_type(sorted_iter, GtkTreeIter__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_sort_convert_iter_to_child_iter", 3, sorted_iter, "GtkTreeIter*");
  gtk_tree_model_sort_convert_iter_to_child_iter((GtkTreeModelSort*)s7_c_pointer(tree_model_sort), (GtkTreeIter*)s7_c_pointer(child_iter), (GtkTreeIter*)s7_c_pointer(sorted_iter));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_model_sort_reset_default_sort_func(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_sort_reset_default_sort_func "void gtk_tree_model_sort_reset_default_sort_func(GtkTreeModelSort* tree_model_sort)"
  s7_pointer tree_model_sort;
  tree_model_sort = s7_car(args);
  if (!s7_is_c_pointer_of_type(tree_model_sort, GtkTreeModelSort__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_sort_reset_default_sort_func", 1, tree_model_sort, "GtkTreeModelSort*");
  gtk_tree_model_sort_reset_default_sort_func((GtkTreeModelSort*)s7_c_pointer(tree_model_sort));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_model_sort_clear_cache(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_sort_clear_cache "void gtk_tree_model_sort_clear_cache(GtkTreeModelSort* tree_model_sort)"
  s7_pointer tree_model_sort;
  tree_model_sort = s7_car(args);
  if (!s7_is_c_pointer_of_type(tree_model_sort, GtkTreeModelSort__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_sort_clear_cache", 1, tree_model_sort, "GtkTreeModelSort*");
  gtk_tree_model_sort_clear_cache((GtkTreeModelSort*)s7_c_pointer(tree_model_sort));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_selection_set_mode(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_selection_set_mode "void gtk_tree_selection_set_mode(GtkTreeSelection* selection, \
GtkSelectionMode type)"
  s7_pointer _p;
  s7_pointer selection, type;
  _p = args;
  selection = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(selection, GtkTreeSelection__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_selection_set_mode", 1, selection, "GtkTreeSelection*");
  type = s7_car(_p);
  if (!s7_is_integer(type)) s7_wrong_type_arg_error(sc, "gtk_tree_selection_set_mode", 2, type, "GtkSelectionMode");
  gtk_tree_selection_set_mode((GtkTreeSelection*)s7_c_pointer(selection), (GtkSelectionMode)s7_integer(type));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_selection_get_mode(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_selection_get_mode "GtkSelectionMode gtk_tree_selection_get_mode(GtkTreeSelection* selection)"
  s7_pointer selection;
  selection = s7_car(args);
  if (!s7_is_c_pointer_of_type(selection, GtkTreeSelection__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_selection_get_mode", 1, selection, "GtkTreeSelection*");
  return(s7_make_integer(sc, gtk_tree_selection_get_mode((GtkTreeSelection*)s7_c_pointer(selection))));
}

static s7_pointer lg_gtk_tree_selection_set_select_function(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_selection_set_select_function "void gtk_tree_selection_set_select_function(GtkTreeSelection* selection, \
GtkTreeSelectionFunc func, lambda_data func_info, GtkDestroyNotify destroy)"
  s7_pointer _p;
  s7_pointer selection, func, func_info, destroy;
  _p = args;
  selection = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(selection, GtkTreeSelection__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_selection_set_select_function", 1, selection, "GtkTreeSelection*");
  func = s7_car(_p); _p = s7_cdr(_p);
  func_info = s7_car(_p); _p = s7_cdr(_p);
  destroy = s7_car(_p);
  {
    s7_pointer lg_ptr = s7_list(sc, 5, func, func_info, lg_false, lg_false, lg_false);
    s7_gc_protect(sc, lg_ptr);
    s7_list_set(sc, lg_ptr, 3, destroy);
    gtk_tree_selection_set_select_function((GtkTreeSelection*)s7_c_pointer(selection), lg_tree_selection, (gpointer)lg_ptr, lg_destroy_func);
    return(lg_false);
   }
}

static s7_pointer lg_gtk_tree_selection_get_user_data(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_selection_get_user_data "gpointer gtk_tree_selection_get_user_data(GtkTreeSelection* selection)"
  s7_pointer selection;
  selection = s7_car(args);
  if (!s7_is_c_pointer_of_type(selection, GtkTreeSelection__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_selection_get_user_data", 1, selection, "GtkTreeSelection*");
  return(lg_make_c_pointer_with_type(sc, gpointer_sym, gtk_tree_selection_get_user_data((GtkTreeSelection*)s7_c_pointer(selection))));
}

static s7_pointer lg_gtk_tree_selection_get_tree_view(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_selection_get_tree_view "GtkTreeView* gtk_tree_selection_get_tree_view(GtkTreeSelection* selection)"
  s7_pointer selection;
  selection = s7_car(args);
  if (!s7_is_c_pointer_of_type(selection, GtkTreeSelection__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_selection_get_tree_view", 1, selection, "GtkTreeSelection*");
  return(lg_make_c_pointer_with_type(sc, GtkTreeView__sym, gtk_tree_selection_get_tree_view((GtkTreeSelection*)s7_c_pointer(selection))));
}

static s7_pointer lg_gtk_tree_selection_get_selected(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_selection_get_selected "gboolean gtk_tree_selection_get_selected(GtkTreeSelection* selection, \
GtkTreeModel** model, GtkTreeIter* iter)"
  s7_pointer _p;
  s7_pointer selection, model, iter;
  _p = args;
  selection = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(selection, GtkTreeSelection__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_selection_get_selected", 1, selection, "GtkTreeSelection*");
  model = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(model, GtkTreeModel___sym)) s7_wrong_type_arg_error(sc, "gtk_tree_selection_get_selected", 2, model, "GtkTreeModel**");
  iter = s7_car(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTreeIter__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_selection_get_selected", 3, iter, "GtkTreeIter*");
  return(s7_make_boolean(sc, gtk_tree_selection_get_selected((GtkTreeSelection*)s7_c_pointer(selection), (GtkTreeModel**)s7_c_pointer(model), (GtkTreeIter*)s7_c_pointer(iter))));
}

static s7_pointer lg_gtk_tree_selection_selected_foreach(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_selection_selected_foreach "void gtk_tree_selection_selected_foreach(GtkTreeSelection* selection, \
GtkTreeSelectionForeachFunc func, lambda_data func_info)"
  s7_pointer _p;
  s7_pointer selection, func, func_info;
  _p = args;
  selection = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(selection, GtkTreeSelection__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_selection_selected_foreach", 1, selection, "GtkTreeSelection*");
  func = s7_car(_p); _p = s7_cdr(_p);
  func_info = s7_car(_p);
  {
    int loc;
    s7_pointer lg_ptr = s7_list(sc, 5, func, func_info, lg_false, lg_false, lg_false);
    loc = s7_gc_protect(sc, lg_ptr);
    s7_list_set(sc, lg_ptr, 2, s7_make_integer(sc, loc));
    gtk_tree_selection_selected_foreach((GtkTreeSelection*)s7_c_pointer(selection), lg_tree_selection_func, (gpointer)lg_ptr);
    return(lg_false);
   }
}

static s7_pointer lg_gtk_tree_selection_select_path(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_selection_select_path "void gtk_tree_selection_select_path(GtkTreeSelection* selection, \
GtkTreePath* path)"
  s7_pointer _p;
  s7_pointer selection, path;
  _p = args;
  selection = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(selection, GtkTreeSelection__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_selection_select_path", 1, selection, "GtkTreeSelection*");
  path = s7_car(_p);
  if (!s7_is_c_pointer_of_type(path, GtkTreePath__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_selection_select_path", 2, path, "GtkTreePath*");
  gtk_tree_selection_select_path((GtkTreeSelection*)s7_c_pointer(selection), (GtkTreePath*)s7_c_pointer(path));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_selection_unselect_path(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_selection_unselect_path "void gtk_tree_selection_unselect_path(GtkTreeSelection* selection, \
GtkTreePath* path)"
  s7_pointer _p;
  s7_pointer selection, path;
  _p = args;
  selection = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(selection, GtkTreeSelection__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_selection_unselect_path", 1, selection, "GtkTreeSelection*");
  path = s7_car(_p);
  if (!s7_is_c_pointer_of_type(path, GtkTreePath__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_selection_unselect_path", 2, path, "GtkTreePath*");
  gtk_tree_selection_unselect_path((GtkTreeSelection*)s7_c_pointer(selection), (GtkTreePath*)s7_c_pointer(path));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_selection_select_iter(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_selection_select_iter "void gtk_tree_selection_select_iter(GtkTreeSelection* selection, \
GtkTreeIter* iter)"
  s7_pointer _p;
  s7_pointer selection, iter;
  _p = args;
  selection = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(selection, GtkTreeSelection__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_selection_select_iter", 1, selection, "GtkTreeSelection*");
  iter = s7_car(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTreeIter__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_selection_select_iter", 2, iter, "GtkTreeIter*");
  gtk_tree_selection_select_iter((GtkTreeSelection*)s7_c_pointer(selection), (GtkTreeIter*)s7_c_pointer(iter));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_selection_unselect_iter(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_selection_unselect_iter "void gtk_tree_selection_unselect_iter(GtkTreeSelection* selection, \
GtkTreeIter* iter)"
  s7_pointer _p;
  s7_pointer selection, iter;
  _p = args;
  selection = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(selection, GtkTreeSelection__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_selection_unselect_iter", 1, selection, "GtkTreeSelection*");
  iter = s7_car(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTreeIter__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_selection_unselect_iter", 2, iter, "GtkTreeIter*");
  gtk_tree_selection_unselect_iter((GtkTreeSelection*)s7_c_pointer(selection), (GtkTreeIter*)s7_c_pointer(iter));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_selection_path_is_selected(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_selection_path_is_selected "gboolean gtk_tree_selection_path_is_selected(GtkTreeSelection* selection, \
GtkTreePath* path)"
  s7_pointer _p;
  s7_pointer selection, path;
  _p = args;
  selection = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(selection, GtkTreeSelection__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_selection_path_is_selected", 1, selection, "GtkTreeSelection*");
  path = s7_car(_p);
  if (!s7_is_c_pointer_of_type(path, GtkTreePath__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_selection_path_is_selected", 2, path, "GtkTreePath*");
  return(s7_make_boolean(sc, gtk_tree_selection_path_is_selected((GtkTreeSelection*)s7_c_pointer(selection), (GtkTreePath*)s7_c_pointer(path))));
}

static s7_pointer lg_gtk_tree_selection_iter_is_selected(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_selection_iter_is_selected "gboolean gtk_tree_selection_iter_is_selected(GtkTreeSelection* selection, \
GtkTreeIter* iter)"
  s7_pointer _p;
  s7_pointer selection, iter;
  _p = args;
  selection = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(selection, GtkTreeSelection__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_selection_iter_is_selected", 1, selection, "GtkTreeSelection*");
  iter = s7_car(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTreeIter__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_selection_iter_is_selected", 2, iter, "GtkTreeIter*");
  return(s7_make_boolean(sc, gtk_tree_selection_iter_is_selected((GtkTreeSelection*)s7_c_pointer(selection), (GtkTreeIter*)s7_c_pointer(iter))));
}

static s7_pointer lg_gtk_tree_selection_select_all(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_selection_select_all "void gtk_tree_selection_select_all(GtkTreeSelection* selection)"
  s7_pointer selection;
  selection = s7_car(args);
  if (!s7_is_c_pointer_of_type(selection, GtkTreeSelection__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_selection_select_all", 1, selection, "GtkTreeSelection*");
  gtk_tree_selection_select_all((GtkTreeSelection*)s7_c_pointer(selection));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_selection_unselect_all(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_selection_unselect_all "void gtk_tree_selection_unselect_all(GtkTreeSelection* selection)"
  s7_pointer selection;
  selection = s7_car(args);
  if (!s7_is_c_pointer_of_type(selection, GtkTreeSelection__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_selection_unselect_all", 1, selection, "GtkTreeSelection*");
  gtk_tree_selection_unselect_all((GtkTreeSelection*)s7_c_pointer(selection));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_selection_select_range(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_selection_select_range "void gtk_tree_selection_select_range(GtkTreeSelection* selection, \
GtkTreePath* start_path, GtkTreePath* end_path)"
  s7_pointer _p;
  s7_pointer selection, start_path, end_path;
  _p = args;
  selection = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(selection, GtkTreeSelection__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_selection_select_range", 1, selection, "GtkTreeSelection*");
  start_path = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(start_path, GtkTreePath__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_selection_select_range", 2, start_path, "GtkTreePath*");
  end_path = s7_car(_p);
  if (!s7_is_c_pointer_of_type(end_path, GtkTreePath__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_selection_select_range", 3, end_path, "GtkTreePath*");
  gtk_tree_selection_select_range((GtkTreeSelection*)s7_c_pointer(selection), (GtkTreePath*)s7_c_pointer(start_path), (GtkTreePath*)s7_c_pointer(end_path));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_sortable_sort_column_changed(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_sortable_sort_column_changed "void gtk_tree_sortable_sort_column_changed(GtkTreeSortable* sortable)"
  s7_pointer sortable;
  sortable = s7_car(args);
  if (!s7_is_c_pointer_of_type(sortable, GtkTreeSortable__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_sortable_sort_column_changed", 1, sortable, "GtkTreeSortable*");
  gtk_tree_sortable_sort_column_changed((GtkTreeSortable*)s7_c_pointer(sortable));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_sortable_get_sort_column_id(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_sortable_get_sort_column_id "gboolean gtk_tree_sortable_get_sort_column_id(GtkTreeSortable* sortable, \
gint* [sort_column_id], GtkSortType* [order])"
  s7_pointer _p;
  s7_pointer sortable;
  gint ref_sort_column_id;
  GtkSortType ref_order;
  _p = args;
  sortable = s7_car(_p);
  if (!s7_is_c_pointer_of_type(sortable, GtkTreeSortable__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_sortable_get_sort_column_id", 1, sortable, "GtkTreeSortable*");
  {
    s7_pointer res_ult;
    res_ult = s7_make_boolean(sc, gtk_tree_sortable_get_sort_column_id((GtkTreeSortable*)s7_c_pointer(sortable), &ref_sort_column_id, &ref_order));
      return(s7_list(sc, 3, res_ult, s7_make_integer(sc, ref_sort_column_id), s7_make_integer(sc, ref_order)));
   }
}

static s7_pointer lg_gtk_tree_sortable_set_sort_column_id(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_sortable_set_sort_column_id "void gtk_tree_sortable_set_sort_column_id(GtkTreeSortable* sortable, \
gint sort_column_id, GtkSortType order)"
  s7_pointer _p;
  s7_pointer sortable, sort_column_id, order;
  _p = args;
  sortable = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(sortable, GtkTreeSortable__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_sortable_set_sort_column_id", 1, sortable, "GtkTreeSortable*");
  sort_column_id = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(sort_column_id)) s7_wrong_type_arg_error(sc, "gtk_tree_sortable_set_sort_column_id", 2, sort_column_id, "gint");
  order = s7_car(_p);
  if (!s7_is_integer(order)) s7_wrong_type_arg_error(sc, "gtk_tree_sortable_set_sort_column_id", 3, order, "GtkSortType");
  gtk_tree_sortable_set_sort_column_id((GtkTreeSortable*)s7_c_pointer(sortable), (gint)s7_integer(sort_column_id), (GtkSortType)s7_integer(order));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_sortable_set_sort_func(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_sortable_set_sort_func "void gtk_tree_sortable_set_sort_func(GtkTreeSortable* sortable, \
gint sort_column_id, GtkTreeIterCompareFunc func, lambda_data func_info, GtkDestroyNotify destroy)"
  s7_pointer _p;
  s7_pointer sortable, sort_column_id, func, func_info, destroy;
  _p = args;
  sortable = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(sortable, GtkTreeSortable__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_sortable_set_sort_func", 1, sortable, "GtkTreeSortable*");
  sort_column_id = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(sort_column_id)) s7_wrong_type_arg_error(sc, "gtk_tree_sortable_set_sort_func", 2, sort_column_id, "gint");
  func = s7_car(_p); _p = s7_cdr(_p);
  func_info = s7_car(_p); _p = s7_cdr(_p);
  destroy = s7_car(_p);
  {
    s7_pointer lg_ptr = s7_list(sc, 5, func, func_info, lg_false, lg_false, lg_false);
    s7_gc_protect(sc, lg_ptr);
    s7_list_set(sc, lg_ptr, 3, destroy);
    gtk_tree_sortable_set_sort_func((GtkTreeSortable*)s7_c_pointer(sortable), (gint)s7_integer(sort_column_id), lg_iter_compare, (gpointer)lg_ptr, lg_destroy_func);
    return(lg_false);
   }
}

static s7_pointer lg_gtk_tree_sortable_set_default_sort_func(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_sortable_set_default_sort_func "void gtk_tree_sortable_set_default_sort_func(GtkTreeSortable* sortable, \
GtkTreeIterCompareFunc func, lambda_data func_info, GtkDestroyNotify destroy)"
  s7_pointer _p;
  s7_pointer sortable, func, func_info, destroy;
  _p = args;
  sortable = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(sortable, GtkTreeSortable__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_sortable_set_default_sort_func", 1, sortable, "GtkTreeSortable*");
  func = s7_car(_p); _p = s7_cdr(_p);
  func_info = s7_car(_p); _p = s7_cdr(_p);
  destroy = s7_car(_p);
  {
    s7_pointer lg_ptr = s7_list(sc, 5, func, func_info, lg_false, lg_false, lg_false);
    s7_gc_protect(sc, lg_ptr);
    s7_list_set(sc, lg_ptr, 3, destroy);
    gtk_tree_sortable_set_default_sort_func((GtkTreeSortable*)s7_c_pointer(sortable), lg_iter_compare, (gpointer)lg_ptr, lg_destroy_func);
    return(lg_false);
   }
}

static s7_pointer lg_gtk_tree_sortable_has_default_sort_func(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_sortable_has_default_sort_func "gboolean gtk_tree_sortable_has_default_sort_func(GtkTreeSortable* sortable)"
  s7_pointer sortable;
  sortable = s7_car(args);
  if (!s7_is_c_pointer_of_type(sortable, GtkTreeSortable__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_sortable_has_default_sort_func", 1, sortable, "GtkTreeSortable*");
  return(s7_make_boolean(sc, gtk_tree_sortable_has_default_sort_func((GtkTreeSortable*)s7_c_pointer(sortable))));
}

static s7_pointer lg_gtk_tree_store_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_store_new "GtkTreeStore* gtk_tree_store_new(gint n_columns, etc types)"
  s7_pointer _p;
  s7_pointer n_columns, types;
  _p = args;
  n_columns = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(n_columns)) s7_wrong_type_arg_error(sc, "gtk_tree_store_new", 1, n_columns, "gint");
  types = s7_car(_p);
  if (!lg_is_list(types)) s7_wrong_type_arg_error(sc, "gtk_tree_store_new", 2, types, "etc");
  {
    int etc_len = 0;
    GtkTreeStore* res_ult = NULL;
    gint p_arg0;
    if (s7_is_list(sc, types)) etc_len = s7_list_length(sc, types);
    if (etc_len < 1) s7_out_of_range_error(sc, "gtk_tree_store_new", 1, types, "... list must have at least 1 entry");
    if (etc_len > 6) s7_out_of_range_error(sc, "gtk_tree_store_new", 1, types, "... list too long (max len: 6)");
    p_arg0 = (gint)s7_integer(n_columns);
    switch (etc_len)
      {
        case 1: res_ult = gtk_tree_store_new(p_arg0, s7_c_pointer(s7_list_ref(sc, types, 0))); break;
        case 2: res_ult = gtk_tree_store_new(p_arg0, s7_c_pointer(s7_list_ref(sc, types, 0)), s7_c_pointer(s7_list_ref(sc, types, 1))); break;
        case 3: res_ult = gtk_tree_store_new(p_arg0, s7_c_pointer(s7_list_ref(sc, types, 0)), s7_c_pointer(s7_list_ref(sc, types, 1)), s7_c_pointer(s7_list_ref(sc, types, 2))); break;
        case 4: res_ult = gtk_tree_store_new(p_arg0, s7_c_pointer(s7_list_ref(sc, types, 0)), s7_c_pointer(s7_list_ref(sc, types, 1)), s7_c_pointer(s7_list_ref(sc, types, 2)), s7_c_pointer(s7_list_ref(sc, types, 3))); break;
        case 5: res_ult = gtk_tree_store_new(p_arg0, s7_c_pointer(s7_list_ref(sc, types, 0)), s7_c_pointer(s7_list_ref(sc, types, 1)), s7_c_pointer(s7_list_ref(sc, types, 2)), s7_c_pointer(s7_list_ref(sc, types, 3)), s7_c_pointer(s7_list_ref(sc, types, 4))); break;
        case 6: res_ult = gtk_tree_store_new(p_arg0, s7_c_pointer(s7_list_ref(sc, types, 0)), s7_c_pointer(s7_list_ref(sc, types, 1)), s7_c_pointer(s7_list_ref(sc, types, 2)), s7_c_pointer(s7_list_ref(sc, types, 3)), s7_c_pointer(s7_list_ref(sc, types, 4)), s7_c_pointer(s7_list_ref(sc, types, 5))); break;
      }
    return(s7_make_c_pointer(sc, res_ult));
  }
}

static s7_pointer lg_gtk_tree_store_newv(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_store_newv "GtkTreeStore* gtk_tree_store_newv(gint n_columns, GType* types)"
  s7_pointer _p;
  s7_pointer n_columns, types;
  _p = args;
  n_columns = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(n_columns)) s7_wrong_type_arg_error(sc, "gtk_tree_store_newv", 1, n_columns, "gint");
  types = s7_car(_p);
  if (!s7_is_c_pointer_of_type(types, GType__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_store_newv", 2, types, "GType*");
  return(lg_make_c_pointer_with_type(sc, GtkTreeStore__sym, gtk_tree_store_newv((gint)s7_integer(n_columns), (GType*)s7_c_pointer(types))));
}

static s7_pointer lg_gtk_tree_store_set_column_types(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_store_set_column_types "void gtk_tree_store_set_column_types(GtkTreeStore* tree_store, \
gint n_columns, GType* types)"
  s7_pointer _p;
  s7_pointer tree_store, n_columns, types;
  _p = args;
  tree_store = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_store, GtkTreeStore__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_store_set_column_types", 1, tree_store, "GtkTreeStore*");
  n_columns = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(n_columns)) s7_wrong_type_arg_error(sc, "gtk_tree_store_set_column_types", 2, n_columns, "gint");
  types = s7_car(_p);
  if (!s7_is_c_pointer_of_type(types, GType__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_store_set_column_types", 3, types, "GType*");
  gtk_tree_store_set_column_types((GtkTreeStore*)s7_c_pointer(tree_store), (gint)s7_integer(n_columns), (GType*)s7_c_pointer(types));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_store_set(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_store_set "void gtk_tree_store_set(GtkTreeStore* tree_store, GtkTreeIter* iter, \
etc values)"
  s7_pointer _p;
  s7_pointer tree_store, iter, values;
  _p = args;
  tree_store = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_store, GtkTreeStore__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_store_set", 1, tree_store, "GtkTreeStore*");
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTreeIter__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_store_set", 2, iter, "GtkTreeIter*");
  values = s7_car(_p);
  if (!lg_is_list(values)) s7_wrong_type_arg_error(sc, "gtk_tree_store_set", 3, values, "etc");
  {
    int etc_len = 0;
    GtkTreeStore* p_arg0;
    GtkTreeIter* p_arg1;
    if (s7_is_list(sc, values)) etc_len = s7_list_length(sc, values);
    if (etc_len < 2) s7_out_of_range_error(sc, "gtk_tree_store_set", 2, values, "... list must have at least 2 entries");
    if (etc_len > 10) s7_out_of_range_error(sc, "gtk_tree_store_set", 2, values, "... list too long (max len: 10)");
    if ((etc_len % 2) != 0) s7_out_of_range_error(sc, "gtk_tree_store_set", 2, values, "... list len must be multiple of 2");
    p_arg0 = (GtkTreeStore*)s7_c_pointer(tree_store);
    p_arg1 = (GtkTreeIter*)s7_c_pointer(iter);
    switch (etc_len)
      {
        case 2: gtk_tree_store_set(p_arg0, p_arg1, s7_integer(s7_list_ref(sc, values, 0)), s7_string(s7_list_ref(sc, values, 1)), -1); break;
        case 4: gtk_tree_store_set(p_arg0, p_arg1, s7_integer(s7_list_ref(sc, values, 0)), s7_string(s7_list_ref(sc, values, 1)), s7_integer(s7_list_ref(sc, values, 2)), s7_string(s7_list_ref(sc, values, 3)), -1); break;
        case 6: gtk_tree_store_set(p_arg0, p_arg1, s7_integer(s7_list_ref(sc, values, 0)), s7_string(s7_list_ref(sc, values, 1)), s7_integer(s7_list_ref(sc, values, 2)), s7_string(s7_list_ref(sc, values, 3)), s7_integer(s7_list_ref(sc, values, 4)), s7_string(s7_list_ref(sc, values, 5)), -1); break;
        case 8: gtk_tree_store_set(p_arg0, p_arg1, s7_integer(s7_list_ref(sc, values, 0)), s7_string(s7_list_ref(sc, values, 1)), s7_integer(s7_list_ref(sc, values, 2)), s7_string(s7_list_ref(sc, values, 3)), s7_integer(s7_list_ref(sc, values, 4)), s7_string(s7_list_ref(sc, values, 5)), s7_integer(s7_list_ref(sc, values, 6)), s7_string(s7_list_ref(sc, values, 7)), -1); break;
        case 10: gtk_tree_store_set(p_arg0, p_arg1, s7_integer(s7_list_ref(sc, values, 0)), s7_string(s7_list_ref(sc, values, 1)), s7_integer(s7_list_ref(sc, values, 2)), s7_string(s7_list_ref(sc, values, 3)), s7_integer(s7_list_ref(sc, values, 4)), s7_string(s7_list_ref(sc, values, 5)), s7_integer(s7_list_ref(sc, values, 6)), s7_string(s7_list_ref(sc, values, 7)), s7_integer(s7_list_ref(sc, values, 8)), s7_string(s7_list_ref(sc, values, 9)), -1); break;
      }
    return(lg_false);
  }
}

static s7_pointer lg_gtk_tree_store_remove(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_store_remove "void gtk_tree_store_remove(GtkTreeStore* tree_store, GtkTreeIter* iter)"
  s7_pointer _p;
  s7_pointer tree_store, iter;
  _p = args;
  tree_store = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_store, GtkTreeStore__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_store_remove", 1, tree_store, "GtkTreeStore*");
  iter = s7_car(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTreeIter__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_store_remove", 2, iter, "GtkTreeIter*");
  gtk_tree_store_remove((GtkTreeStore*)s7_c_pointer(tree_store), (GtkTreeIter*)s7_c_pointer(iter));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_store_insert(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_store_insert "void gtk_tree_store_insert(GtkTreeStore* tree_store, GtkTreeIter* iter, \
GtkTreeIter* parent, gint position)"
  s7_pointer _p;
  s7_pointer tree_store, iter, parent, position;
  _p = args;
  tree_store = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_store, GtkTreeStore__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_store_insert", 1, tree_store, "GtkTreeStore*");
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTreeIter__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_store_insert", 2, iter, "GtkTreeIter*");
  parent = s7_car(_p); _p = s7_cdr(_p);
  if ((!s7_is_c_pointer_of_type(parent, GtkTreeIter__sym)) && (parent != lg_false)) s7_wrong_type_arg_error(sc, "gtk_tree_store_insert", 3, parent, "GtkTreeIter*");
  position = s7_car(_p);
  if (!s7_is_integer(position)) s7_wrong_type_arg_error(sc, "gtk_tree_store_insert", 4, position, "gint");
  gtk_tree_store_insert((GtkTreeStore*)s7_c_pointer(tree_store), (GtkTreeIter*)s7_c_pointer(iter), (GtkTreeIter*)s7_c_pointer(parent), (gint)s7_integer(position));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_store_insert_before(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_store_insert_before "void gtk_tree_store_insert_before(GtkTreeStore* tree_store, \
GtkTreeIter* iter, GtkTreeIter* parent, GtkTreeIter* sibling)"
  s7_pointer _p;
  s7_pointer tree_store, iter, parent, sibling;
  _p = args;
  tree_store = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_store, GtkTreeStore__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_store_insert_before", 1, tree_store, "GtkTreeStore*");
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTreeIter__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_store_insert_before", 2, iter, "GtkTreeIter*");
  parent = s7_car(_p); _p = s7_cdr(_p);
  if ((!s7_is_c_pointer_of_type(parent, GtkTreeIter__sym)) && (parent != lg_false)) s7_wrong_type_arg_error(sc, "gtk_tree_store_insert_before", 3, parent, "GtkTreeIter*");
  sibling = s7_car(_p);
  if ((!s7_is_c_pointer_of_type(sibling, GtkTreeIter__sym)) && (sibling != lg_false)) s7_wrong_type_arg_error(sc, "gtk_tree_store_insert_before", 4, sibling, "GtkTreeIter*");
  gtk_tree_store_insert_before((GtkTreeStore*)s7_c_pointer(tree_store), (GtkTreeIter*)s7_c_pointer(iter), (GtkTreeIter*)s7_c_pointer(parent), (GtkTreeIter*)s7_c_pointer(sibling));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_store_insert_after(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_store_insert_after "void gtk_tree_store_insert_after(GtkTreeStore* tree_store, GtkTreeIter* iter, \
GtkTreeIter* parent, GtkTreeIter* sibling)"
  s7_pointer _p;
  s7_pointer tree_store, iter, parent, sibling;
  _p = args;
  tree_store = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_store, GtkTreeStore__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_store_insert_after", 1, tree_store, "GtkTreeStore*");
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTreeIter__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_store_insert_after", 2, iter, "GtkTreeIter*");
  parent = s7_car(_p); _p = s7_cdr(_p);
  if ((!s7_is_c_pointer_of_type(parent, GtkTreeIter__sym)) && (parent != lg_false)) s7_wrong_type_arg_error(sc, "gtk_tree_store_insert_after", 3, parent, "GtkTreeIter*");
  sibling = s7_car(_p);
  if ((!s7_is_c_pointer_of_type(sibling, GtkTreeIter__sym)) && (sibling != lg_false)) s7_wrong_type_arg_error(sc, "gtk_tree_store_insert_after", 4, sibling, "GtkTreeIter*");
  gtk_tree_store_insert_after((GtkTreeStore*)s7_c_pointer(tree_store), (GtkTreeIter*)s7_c_pointer(iter), (GtkTreeIter*)s7_c_pointer(parent), (GtkTreeIter*)s7_c_pointer(sibling));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_store_prepend(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_store_prepend "void gtk_tree_store_prepend(GtkTreeStore* tree_store, GtkTreeIter* iter, \
GtkTreeIter* parent)"
  s7_pointer _p;
  s7_pointer tree_store, iter, parent;
  _p = args;
  tree_store = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_store, GtkTreeStore__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_store_prepend", 1, tree_store, "GtkTreeStore*");
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTreeIter__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_store_prepend", 2, iter, "GtkTreeIter*");
  parent = s7_car(_p);
  if ((!s7_is_c_pointer_of_type(parent, GtkTreeIter__sym)) && (parent != lg_false)) s7_wrong_type_arg_error(sc, "gtk_tree_store_prepend", 3, parent, "GtkTreeIter*");
  gtk_tree_store_prepend((GtkTreeStore*)s7_c_pointer(tree_store), (GtkTreeIter*)s7_c_pointer(iter), (GtkTreeIter*)s7_c_pointer(parent));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_store_append(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_store_append "void gtk_tree_store_append(GtkTreeStore* tree_store, GtkTreeIter* iter, \
GtkTreeIter* parent)"
  s7_pointer _p;
  s7_pointer tree_store, iter, parent;
  _p = args;
  tree_store = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_store, GtkTreeStore__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_store_append", 1, tree_store, "GtkTreeStore*");
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTreeIter__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_store_append", 2, iter, "GtkTreeIter*");
  parent = s7_car(_p);
  if ((!s7_is_c_pointer_of_type(parent, GtkTreeIter__sym)) && (parent != lg_false)) s7_wrong_type_arg_error(sc, "gtk_tree_store_append", 3, parent, "GtkTreeIter*");
  gtk_tree_store_append((GtkTreeStore*)s7_c_pointer(tree_store), (GtkTreeIter*)s7_c_pointer(iter), (GtkTreeIter*)s7_c_pointer(parent));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_store_is_ancestor(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_store_is_ancestor "gboolean gtk_tree_store_is_ancestor(GtkTreeStore* tree_store, \
GtkTreeIter* iter, GtkTreeIter* descendant)"
  s7_pointer _p;
  s7_pointer tree_store, iter, descendant;
  _p = args;
  tree_store = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_store, GtkTreeStore__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_store_is_ancestor", 1, tree_store, "GtkTreeStore*");
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTreeIter__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_store_is_ancestor", 2, iter, "GtkTreeIter*");
  descendant = s7_car(_p);
  if (!s7_is_c_pointer_of_type(descendant, GtkTreeIter__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_store_is_ancestor", 3, descendant, "GtkTreeIter*");
  return(s7_make_boolean(sc, gtk_tree_store_is_ancestor((GtkTreeStore*)s7_c_pointer(tree_store), (GtkTreeIter*)s7_c_pointer(iter), (GtkTreeIter*)s7_c_pointer(descendant))));
}

static s7_pointer lg_gtk_tree_store_iter_depth(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_store_iter_depth "gint gtk_tree_store_iter_depth(GtkTreeStore* tree_store, GtkTreeIter* iter)"
  s7_pointer _p;
  s7_pointer tree_store, iter;
  _p = args;
  tree_store = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_store, GtkTreeStore__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_store_iter_depth", 1, tree_store, "GtkTreeStore*");
  iter = s7_car(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTreeIter__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_store_iter_depth", 2, iter, "GtkTreeIter*");
  return(s7_make_integer(sc, gtk_tree_store_iter_depth((GtkTreeStore*)s7_c_pointer(tree_store), (GtkTreeIter*)s7_c_pointer(iter))));
}

static s7_pointer lg_gtk_tree_store_clear(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_store_clear "void gtk_tree_store_clear(GtkTreeStore* tree_store)"
  s7_pointer tree_store;
  tree_store = s7_car(args);
  if (!s7_is_c_pointer_of_type(tree_store, GtkTreeStore__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_store_clear", 1, tree_store, "GtkTreeStore*");
  gtk_tree_store_clear((GtkTreeStore*)s7_c_pointer(tree_store));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_column_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_new "GtkTreeViewColumn* gtk_tree_view_column_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkTreeViewColumn__sym, gtk_tree_view_column_new()));
}

static s7_pointer lg_gtk_tree_view_column_new_with_attributes(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_new_with_attributes "GtkTreeViewColumn* gtk_tree_view_column_new_with_attributes(gchar* title, \
GtkCellRenderer* cell, etc attributes)"
  s7_pointer _p;
  s7_pointer title, cell, attributes;
  _p = args;
  title = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(title)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_new_with_attributes", 1, title, "gchar*");
  cell = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(cell, GtkCellRenderer__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_new_with_attributes", 2, cell, "GtkCellRenderer*");
  attributes = s7_car(_p);
  if (!lg_is_list(attributes)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_new_with_attributes", 3, attributes, "etc");
  {
    int etc_len = 0;
    GtkTreeViewColumn* res_ult = NULL;
    gchar* p_arg0;
    GtkCellRenderer* p_arg1;
    if (s7_is_list(sc, attributes)) etc_len = s7_list_length(sc, attributes);
    if (etc_len < 2) s7_out_of_range_error(sc, "gtk_tree_view_column_new_with_attributes", 2, attributes, "... list must have at least 2 entries");
    if (etc_len > 10) s7_out_of_range_error(sc, "gtk_tree_view_column_new_with_attributes", 2, attributes, "... list too long (max len: 10)");
    if ((etc_len % 2) != 0) s7_out_of_range_error(sc, "gtk_tree_view_column_new_with_attributes", 2, attributes, "... list len must be multiple of 2");
    p_arg0 = (gchar*)s7_string(title);
    p_arg1 = (GtkCellRenderer*)s7_c_pointer(cell);
    switch (etc_len)
      {
        case 2: res_ult = gtk_tree_view_column_new_with_attributes(p_arg0, p_arg1, s7_string(s7_list_ref(sc, attributes, 0)), s7_integer(s7_list_ref(sc, attributes, 1)), NULL); break;
        case 4: res_ult = gtk_tree_view_column_new_with_attributes(p_arg0, p_arg1, s7_string(s7_list_ref(sc, attributes, 0)), s7_integer(s7_list_ref(sc, attributes, 1)), s7_string(s7_list_ref(sc, attributes, 2)), s7_integer(s7_list_ref(sc, attributes, 3)), NULL); break;
        case 6: res_ult = gtk_tree_view_column_new_with_attributes(p_arg0, p_arg1, s7_string(s7_list_ref(sc, attributes, 0)), s7_integer(s7_list_ref(sc, attributes, 1)), s7_string(s7_list_ref(sc, attributes, 2)), s7_integer(s7_list_ref(sc, attributes, 3)), s7_string(s7_list_ref(sc, attributes, 4)), s7_integer(s7_list_ref(sc, attributes, 5)), NULL); break;
        case 8: res_ult = gtk_tree_view_column_new_with_attributes(p_arg0, p_arg1, s7_string(s7_list_ref(sc, attributes, 0)), s7_integer(s7_list_ref(sc, attributes, 1)), s7_string(s7_list_ref(sc, attributes, 2)), s7_integer(s7_list_ref(sc, attributes, 3)), s7_string(s7_list_ref(sc, attributes, 4)), s7_integer(s7_list_ref(sc, attributes, 5)), s7_string(s7_list_ref(sc, attributes, 6)), s7_integer(s7_list_ref(sc, attributes, 7)), NULL); break;
        case 10: res_ult = gtk_tree_view_column_new_with_attributes(p_arg0, p_arg1, s7_string(s7_list_ref(sc, attributes, 0)), s7_integer(s7_list_ref(sc, attributes, 1)), s7_string(s7_list_ref(sc, attributes, 2)), s7_integer(s7_list_ref(sc, attributes, 3)), s7_string(s7_list_ref(sc, attributes, 4)), s7_integer(s7_list_ref(sc, attributes, 5)), s7_string(s7_list_ref(sc, attributes, 6)), s7_integer(s7_list_ref(sc, attributes, 7)), s7_string(s7_list_ref(sc, attributes, 8)), s7_integer(s7_list_ref(sc, attributes, 9)), NULL); break;
      }
    return(s7_make_c_pointer(sc, res_ult));
  }
}

static s7_pointer lg_gtk_tree_view_column_pack_start(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_pack_start "void gtk_tree_view_column_pack_start(GtkTreeViewColumn* tree_column, \
GtkCellRenderer* cell, gboolean expand)"
  s7_pointer _p;
  s7_pointer tree_column, cell, expand;
  _p = args;
  tree_column = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_column, GtkTreeViewColumn__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_pack_start", 1, tree_column, "GtkTreeViewColumn*");
  cell = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(cell, GtkCellRenderer__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_pack_start", 2, cell, "GtkCellRenderer*");
  expand = s7_car(_p);
  if (!s7_is_boolean(expand)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_pack_start", 3, expand, "gboolean");
  gtk_tree_view_column_pack_start((GtkTreeViewColumn*)s7_c_pointer(tree_column), (GtkCellRenderer*)s7_c_pointer(cell), (gboolean)lg_boolean(expand));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_column_pack_end(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_pack_end "void gtk_tree_view_column_pack_end(GtkTreeViewColumn* tree_column, \
GtkCellRenderer* cell, gboolean expand)"
  s7_pointer _p;
  s7_pointer tree_column, cell, expand;
  _p = args;
  tree_column = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_column, GtkTreeViewColumn__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_pack_end", 1, tree_column, "GtkTreeViewColumn*");
  cell = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(cell, GtkCellRenderer__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_pack_end", 2, cell, "GtkCellRenderer*");
  expand = s7_car(_p);
  if (!s7_is_boolean(expand)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_pack_end", 3, expand, "gboolean");
  gtk_tree_view_column_pack_end((GtkTreeViewColumn*)s7_c_pointer(tree_column), (GtkCellRenderer*)s7_c_pointer(cell), (gboolean)lg_boolean(expand));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_column_clear(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_clear "void gtk_tree_view_column_clear(GtkTreeViewColumn* tree_column)"
  s7_pointer tree_column;
  tree_column = s7_car(args);
  if (!s7_is_c_pointer_of_type(tree_column, GtkTreeViewColumn__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_clear", 1, tree_column, "GtkTreeViewColumn*");
  gtk_tree_view_column_clear((GtkTreeViewColumn*)s7_c_pointer(tree_column));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_column_add_attribute(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_add_attribute "void gtk_tree_view_column_add_attribute(GtkTreeViewColumn* tree_column, \
GtkCellRenderer* cell_renderer, gchar* attribute, gint column)"
  s7_pointer _p;
  s7_pointer tree_column, cell_renderer, attribute, column;
  _p = args;
  tree_column = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_column, GtkTreeViewColumn__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_add_attribute", 1, tree_column, "GtkTreeViewColumn*");
  cell_renderer = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(cell_renderer, GtkCellRenderer__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_add_attribute", 2, cell_renderer, "GtkCellRenderer*");
  attribute = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(attribute)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_add_attribute", 3, attribute, "gchar*");
  column = s7_car(_p);
  if (!s7_is_integer(column)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_add_attribute", 4, column, "gint");
  gtk_tree_view_column_add_attribute((GtkTreeViewColumn*)s7_c_pointer(tree_column), (GtkCellRenderer*)s7_c_pointer(cell_renderer), (gchar*)s7_string(attribute), (gint)s7_integer(column));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_column_set_attributes(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_set_attributes "void gtk_tree_view_column_set_attributes(GtkTreeViewColumn* tree_column, \
GtkCellRenderer* cell_renderer, etc attributes)"
  s7_pointer _p;
  s7_pointer tree_column, cell_renderer, attributes;
  _p = args;
  tree_column = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_column, GtkTreeViewColumn__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_set_attributes", 1, tree_column, "GtkTreeViewColumn*");
  cell_renderer = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(cell_renderer, GtkCellRenderer__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_set_attributes", 2, cell_renderer, "GtkCellRenderer*");
  attributes = s7_car(_p);
  if (!lg_is_list(attributes)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_set_attributes", 3, attributes, "etc");
  {
    int etc_len = 0;
    GtkTreeViewColumn* p_arg0;
    GtkCellRenderer* p_arg1;
    if (s7_is_list(sc, attributes)) etc_len = s7_list_length(sc, attributes);
    if (etc_len < 2) s7_out_of_range_error(sc, "gtk_tree_view_column_set_attributes", 2, attributes, "... list must have at least 2 entries");
    if (etc_len > 10) s7_out_of_range_error(sc, "gtk_tree_view_column_set_attributes", 2, attributes, "... list too long (max len: 10)");
    if ((etc_len % 2) != 0) s7_out_of_range_error(sc, "gtk_tree_view_column_set_attributes", 2, attributes, "... list len must be multiple of 2");
    p_arg0 = (GtkTreeViewColumn*)s7_c_pointer(tree_column);
    p_arg1 = (GtkCellRenderer*)s7_c_pointer(cell_renderer);
    switch (etc_len)
      {
        case 2: gtk_tree_view_column_set_attributes(p_arg0, p_arg1, s7_string(s7_list_ref(sc, attributes, 0)), s7_integer(s7_list_ref(sc, attributes, 1)), NULL); break;
        case 4: gtk_tree_view_column_set_attributes(p_arg0, p_arg1, s7_string(s7_list_ref(sc, attributes, 0)), s7_integer(s7_list_ref(sc, attributes, 1)), s7_string(s7_list_ref(sc, attributes, 2)), s7_integer(s7_list_ref(sc, attributes, 3)), NULL); break;
        case 6: gtk_tree_view_column_set_attributes(p_arg0, p_arg1, s7_string(s7_list_ref(sc, attributes, 0)), s7_integer(s7_list_ref(sc, attributes, 1)), s7_string(s7_list_ref(sc, attributes, 2)), s7_integer(s7_list_ref(sc, attributes, 3)), s7_string(s7_list_ref(sc, attributes, 4)), s7_integer(s7_list_ref(sc, attributes, 5)), NULL); break;
        case 8: gtk_tree_view_column_set_attributes(p_arg0, p_arg1, s7_string(s7_list_ref(sc, attributes, 0)), s7_integer(s7_list_ref(sc, attributes, 1)), s7_string(s7_list_ref(sc, attributes, 2)), s7_integer(s7_list_ref(sc, attributes, 3)), s7_string(s7_list_ref(sc, attributes, 4)), s7_integer(s7_list_ref(sc, attributes, 5)), s7_string(s7_list_ref(sc, attributes, 6)), s7_integer(s7_list_ref(sc, attributes, 7)), NULL); break;
        case 10: gtk_tree_view_column_set_attributes(p_arg0, p_arg1, s7_string(s7_list_ref(sc, attributes, 0)), s7_integer(s7_list_ref(sc, attributes, 1)), s7_string(s7_list_ref(sc, attributes, 2)), s7_integer(s7_list_ref(sc, attributes, 3)), s7_string(s7_list_ref(sc, attributes, 4)), s7_integer(s7_list_ref(sc, attributes, 5)), s7_string(s7_list_ref(sc, attributes, 6)), s7_integer(s7_list_ref(sc, attributes, 7)), s7_string(s7_list_ref(sc, attributes, 8)), s7_integer(s7_list_ref(sc, attributes, 9)), NULL); break;
      }
    return(lg_false);
  }
}

static s7_pointer lg_gtk_tree_view_column_set_cell_data_func(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_set_cell_data_func "void gtk_tree_view_column_set_cell_data_func(GtkTreeViewColumn* tree_column, \
GtkCellRenderer* cell_renderer, GtkTreeCellDataFunc func, lambda_data func_info, GtkDestroyNotify destroy)"
  s7_pointer _p;
  s7_pointer tree_column, cell_renderer, func, func_info, destroy;
  _p = args;
  tree_column = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_column, GtkTreeViewColumn__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_set_cell_data_func", 1, tree_column, "GtkTreeViewColumn*");
  cell_renderer = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(cell_renderer, GtkCellRenderer__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_set_cell_data_func", 2, cell_renderer, "GtkCellRenderer*");
  func = s7_car(_p); _p = s7_cdr(_p);
  func_info = s7_car(_p); _p = s7_cdr(_p);
  destroy = s7_car(_p);
  {
    s7_pointer lg_ptr = s7_list(sc, 5, func, func_info, lg_false, lg_false, lg_false);
    s7_gc_protect(sc, lg_ptr);
    s7_list_set(sc, lg_ptr, 3, destroy);
    gtk_tree_view_column_set_cell_data_func((GtkTreeViewColumn*)s7_c_pointer(tree_column), (GtkCellRenderer*)s7_c_pointer(cell_renderer), lg_cell_data, (gpointer)lg_ptr, lg_destroy_func);
    return(lg_false);
   }
}

static s7_pointer lg_gtk_tree_view_column_clear_attributes(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_clear_attributes "void gtk_tree_view_column_clear_attributes(GtkTreeViewColumn* tree_column, \
GtkCellRenderer* cell_renderer)"
  s7_pointer _p;
  s7_pointer tree_column, cell_renderer;
  _p = args;
  tree_column = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_column, GtkTreeViewColumn__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_clear_attributes", 1, tree_column, "GtkTreeViewColumn*");
  cell_renderer = s7_car(_p);
  if (!s7_is_c_pointer_of_type(cell_renderer, GtkCellRenderer__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_clear_attributes", 2, cell_renderer, "GtkCellRenderer*");
  gtk_tree_view_column_clear_attributes((GtkTreeViewColumn*)s7_c_pointer(tree_column), (GtkCellRenderer*)s7_c_pointer(cell_renderer));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_column_set_spacing(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_set_spacing "void gtk_tree_view_column_set_spacing(GtkTreeViewColumn* tree_column, \
gint spacing)"
  s7_pointer _p;
  s7_pointer tree_column, spacing;
  _p = args;
  tree_column = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_column, GtkTreeViewColumn__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_set_spacing", 1, tree_column, "GtkTreeViewColumn*");
  spacing = s7_car(_p);
  if (!s7_is_integer(spacing)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_set_spacing", 2, spacing, "gint");
  gtk_tree_view_column_set_spacing((GtkTreeViewColumn*)s7_c_pointer(tree_column), (gint)s7_integer(spacing));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_column_get_spacing(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_get_spacing "gint gtk_tree_view_column_get_spacing(GtkTreeViewColumn* tree_column)"
  s7_pointer tree_column;
  tree_column = s7_car(args);
  if (!s7_is_c_pointer_of_type(tree_column, GtkTreeViewColumn__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_get_spacing", 1, tree_column, "GtkTreeViewColumn*");
  return(s7_make_integer(sc, gtk_tree_view_column_get_spacing((GtkTreeViewColumn*)s7_c_pointer(tree_column))));
}

static s7_pointer lg_gtk_tree_view_column_set_visible(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_set_visible "void gtk_tree_view_column_set_visible(GtkTreeViewColumn* tree_column, \
gboolean visible)"
  s7_pointer _p;
  s7_pointer tree_column, visible;
  _p = args;
  tree_column = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_column, GtkTreeViewColumn__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_set_visible", 1, tree_column, "GtkTreeViewColumn*");
  visible = s7_car(_p);
  if (!s7_is_boolean(visible)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_set_visible", 2, visible, "gboolean");
  gtk_tree_view_column_set_visible((GtkTreeViewColumn*)s7_c_pointer(tree_column), (gboolean)lg_boolean(visible));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_column_get_visible(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_get_visible "gboolean gtk_tree_view_column_get_visible(GtkTreeViewColumn* tree_column)"
  s7_pointer tree_column;
  tree_column = s7_car(args);
  if (!s7_is_c_pointer_of_type(tree_column, GtkTreeViewColumn__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_get_visible", 1, tree_column, "GtkTreeViewColumn*");
  return(s7_make_boolean(sc, gtk_tree_view_column_get_visible((GtkTreeViewColumn*)s7_c_pointer(tree_column))));
}

static s7_pointer lg_gtk_tree_view_column_set_resizable(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_set_resizable "void gtk_tree_view_column_set_resizable(GtkTreeViewColumn* tree_column, \
gboolean resizable)"
  s7_pointer _p;
  s7_pointer tree_column, resizable;
  _p = args;
  tree_column = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_column, GtkTreeViewColumn__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_set_resizable", 1, tree_column, "GtkTreeViewColumn*");
  resizable = s7_car(_p);
  if (!s7_is_boolean(resizable)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_set_resizable", 2, resizable, "gboolean");
  gtk_tree_view_column_set_resizable((GtkTreeViewColumn*)s7_c_pointer(tree_column), (gboolean)lg_boolean(resizable));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_column_get_resizable(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_get_resizable "gboolean gtk_tree_view_column_get_resizable(GtkTreeViewColumn* tree_column)"
  s7_pointer tree_column;
  tree_column = s7_car(args);
  if (!s7_is_c_pointer_of_type(tree_column, GtkTreeViewColumn__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_get_resizable", 1, tree_column, "GtkTreeViewColumn*");
  return(s7_make_boolean(sc, gtk_tree_view_column_get_resizable((GtkTreeViewColumn*)s7_c_pointer(tree_column))));
}

static s7_pointer lg_gtk_tree_view_column_set_sizing(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_set_sizing "void gtk_tree_view_column_set_sizing(GtkTreeViewColumn* tree_column, \
GtkTreeViewColumnSizing type)"
  s7_pointer _p;
  s7_pointer tree_column, type;
  _p = args;
  tree_column = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_column, GtkTreeViewColumn__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_set_sizing", 1, tree_column, "GtkTreeViewColumn*");
  type = s7_car(_p);
  if (!s7_is_integer(type)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_set_sizing", 2, type, "GtkTreeViewColumnSizing");
  gtk_tree_view_column_set_sizing((GtkTreeViewColumn*)s7_c_pointer(tree_column), (GtkTreeViewColumnSizing)s7_integer(type));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_column_get_sizing(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_get_sizing "GtkTreeViewColumnSizing gtk_tree_view_column_get_sizing(GtkTreeViewColumn* tree_column)"
  s7_pointer tree_column;
  tree_column = s7_car(args);
  if (!s7_is_c_pointer_of_type(tree_column, GtkTreeViewColumn__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_get_sizing", 1, tree_column, "GtkTreeViewColumn*");
  return(s7_make_integer(sc, gtk_tree_view_column_get_sizing((GtkTreeViewColumn*)s7_c_pointer(tree_column))));
}

static s7_pointer lg_gtk_tree_view_column_get_width(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_get_width "gint gtk_tree_view_column_get_width(GtkTreeViewColumn* tree_column)"
  s7_pointer tree_column;
  tree_column = s7_car(args);
  if (!s7_is_c_pointer_of_type(tree_column, GtkTreeViewColumn__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_get_width", 1, tree_column, "GtkTreeViewColumn*");
  return(s7_make_integer(sc, gtk_tree_view_column_get_width((GtkTreeViewColumn*)s7_c_pointer(tree_column))));
}

static s7_pointer lg_gtk_tree_view_column_get_fixed_width(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_get_fixed_width "gint gtk_tree_view_column_get_fixed_width(GtkTreeViewColumn* tree_column)"
  s7_pointer tree_column;
  tree_column = s7_car(args);
  if (!s7_is_c_pointer_of_type(tree_column, GtkTreeViewColumn__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_get_fixed_width", 1, tree_column, "GtkTreeViewColumn*");
  return(s7_make_integer(sc, gtk_tree_view_column_get_fixed_width((GtkTreeViewColumn*)s7_c_pointer(tree_column))));
}

static s7_pointer lg_gtk_tree_view_column_set_fixed_width(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_set_fixed_width "void gtk_tree_view_column_set_fixed_width(GtkTreeViewColumn* tree_column, \
gint fixed_width)"
  s7_pointer _p;
  s7_pointer tree_column, fixed_width;
  _p = args;
  tree_column = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_column, GtkTreeViewColumn__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_set_fixed_width", 1, tree_column, "GtkTreeViewColumn*");
  fixed_width = s7_car(_p);
  if (!s7_is_integer(fixed_width)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_set_fixed_width", 2, fixed_width, "gint");
  gtk_tree_view_column_set_fixed_width((GtkTreeViewColumn*)s7_c_pointer(tree_column), (gint)s7_integer(fixed_width));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_column_set_min_width(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_set_min_width "void gtk_tree_view_column_set_min_width(GtkTreeViewColumn* tree_column, \
gint min_width)"
  s7_pointer _p;
  s7_pointer tree_column, min_width;
  _p = args;
  tree_column = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_column, GtkTreeViewColumn__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_set_min_width", 1, tree_column, "GtkTreeViewColumn*");
  min_width = s7_car(_p);
  if (!s7_is_integer(min_width)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_set_min_width", 2, min_width, "gint");
  gtk_tree_view_column_set_min_width((GtkTreeViewColumn*)s7_c_pointer(tree_column), (gint)s7_integer(min_width));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_column_get_min_width(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_get_min_width "gint gtk_tree_view_column_get_min_width(GtkTreeViewColumn* tree_column)"
  s7_pointer tree_column;
  tree_column = s7_car(args);
  if (!s7_is_c_pointer_of_type(tree_column, GtkTreeViewColumn__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_get_min_width", 1, tree_column, "GtkTreeViewColumn*");
  return(s7_make_integer(sc, gtk_tree_view_column_get_min_width((GtkTreeViewColumn*)s7_c_pointer(tree_column))));
}

static s7_pointer lg_gtk_tree_view_column_set_max_width(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_set_max_width "void gtk_tree_view_column_set_max_width(GtkTreeViewColumn* tree_column, \
gint max_width)"
  s7_pointer _p;
  s7_pointer tree_column, max_width;
  _p = args;
  tree_column = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_column, GtkTreeViewColumn__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_set_max_width", 1, tree_column, "GtkTreeViewColumn*");
  max_width = s7_car(_p);
  if (!s7_is_integer(max_width)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_set_max_width", 2, max_width, "gint");
  gtk_tree_view_column_set_max_width((GtkTreeViewColumn*)s7_c_pointer(tree_column), (gint)s7_integer(max_width));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_column_get_max_width(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_get_max_width "gint gtk_tree_view_column_get_max_width(GtkTreeViewColumn* tree_column)"
  s7_pointer tree_column;
  tree_column = s7_car(args);
  if (!s7_is_c_pointer_of_type(tree_column, GtkTreeViewColumn__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_get_max_width", 1, tree_column, "GtkTreeViewColumn*");
  return(s7_make_integer(sc, gtk_tree_view_column_get_max_width((GtkTreeViewColumn*)s7_c_pointer(tree_column))));
}

static s7_pointer lg_gtk_tree_view_column_clicked(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_clicked "void gtk_tree_view_column_clicked(GtkTreeViewColumn* tree_column)"
  s7_pointer tree_column;
  tree_column = s7_car(args);
  if (!s7_is_c_pointer_of_type(tree_column, GtkTreeViewColumn__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_clicked", 1, tree_column, "GtkTreeViewColumn*");
  gtk_tree_view_column_clicked((GtkTreeViewColumn*)s7_c_pointer(tree_column));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_column_set_title(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_set_title "void gtk_tree_view_column_set_title(GtkTreeViewColumn* tree_column, \
gchar* title)"
  s7_pointer _p;
  s7_pointer tree_column, title;
  _p = args;
  tree_column = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_column, GtkTreeViewColumn__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_set_title", 1, tree_column, "GtkTreeViewColumn*");
  title = s7_car(_p);
  if (!s7_is_string(title)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_set_title", 2, title, "gchar*");
  gtk_tree_view_column_set_title((GtkTreeViewColumn*)s7_c_pointer(tree_column), (gchar*)s7_string(title));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_column_get_title(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_get_title "gchar* gtk_tree_view_column_get_title(GtkTreeViewColumn* tree_column)"
  s7_pointer tree_column;
  tree_column = s7_car(args);
  if (!s7_is_c_pointer_of_type(tree_column, GtkTreeViewColumn__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_get_title", 1, tree_column, "GtkTreeViewColumn*");
  return(s7_make_string(sc, gtk_tree_view_column_get_title((GtkTreeViewColumn*)s7_c_pointer(tree_column))));
}

static s7_pointer lg_gtk_tree_view_column_set_clickable(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_set_clickable "void gtk_tree_view_column_set_clickable(GtkTreeViewColumn* tree_column, \
gboolean clickable)"
  s7_pointer _p;
  s7_pointer tree_column, clickable;
  _p = args;
  tree_column = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_column, GtkTreeViewColumn__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_set_clickable", 1, tree_column, "GtkTreeViewColumn*");
  clickable = s7_car(_p);
  if (!s7_is_boolean(clickable)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_set_clickable", 2, clickable, "gboolean");
  gtk_tree_view_column_set_clickable((GtkTreeViewColumn*)s7_c_pointer(tree_column), (gboolean)lg_boolean(clickable));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_column_get_clickable(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_get_clickable "gboolean gtk_tree_view_column_get_clickable(GtkTreeViewColumn* tree_column)"
  s7_pointer tree_column;
  tree_column = s7_car(args);
  if (!s7_is_c_pointer_of_type(tree_column, GtkTreeViewColumn__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_get_clickable", 1, tree_column, "GtkTreeViewColumn*");
  return(s7_make_boolean(sc, gtk_tree_view_column_get_clickable((GtkTreeViewColumn*)s7_c_pointer(tree_column))));
}

static s7_pointer lg_gtk_tree_view_column_set_widget(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_set_widget "void gtk_tree_view_column_set_widget(GtkTreeViewColumn* tree_column, \
GtkWidget* widget)"
  s7_pointer _p;
  s7_pointer tree_column, widget;
  _p = args;
  tree_column = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_column, GtkTreeViewColumn__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_set_widget", 1, tree_column, "GtkTreeViewColumn*");
  widget = s7_car(_p);
  if ((!s7_is_c_pointer_of_type(widget, GtkWidget__sym)) && (widget != lg_false)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_set_widget", 2, widget, "GtkWidget*");
  gtk_tree_view_column_set_widget((GtkTreeViewColumn*)s7_c_pointer(tree_column), (GtkWidget*)s7_c_pointer(widget));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_column_get_widget(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_get_widget "GtkWidget* gtk_tree_view_column_get_widget(GtkTreeViewColumn* tree_column)"
  s7_pointer tree_column;
  tree_column = s7_car(args);
  if (!s7_is_c_pointer_of_type(tree_column, GtkTreeViewColumn__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_get_widget", 1, tree_column, "GtkTreeViewColumn*");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_tree_view_column_get_widget((GtkTreeViewColumn*)s7_c_pointer(tree_column))));
}

static s7_pointer lg_gtk_tree_view_column_set_alignment(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_set_alignment "void gtk_tree_view_column_set_alignment(GtkTreeViewColumn* tree_column, \
gfloat xalign)"
  s7_pointer _p;
  s7_pointer tree_column, xalign;
  _p = args;
  tree_column = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_column, GtkTreeViewColumn__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_set_alignment", 1, tree_column, "GtkTreeViewColumn*");
  xalign = s7_car(_p);
  if (!s7_is_real(xalign)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_set_alignment", 2, xalign, "gfloat");
  gtk_tree_view_column_set_alignment((GtkTreeViewColumn*)s7_c_pointer(tree_column), (gfloat)s7_real(xalign));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_column_get_alignment(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_get_alignment "gfloat gtk_tree_view_column_get_alignment(GtkTreeViewColumn* tree_column)"
  s7_pointer tree_column;
  tree_column = s7_car(args);
  if (!s7_is_c_pointer_of_type(tree_column, GtkTreeViewColumn__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_get_alignment", 1, tree_column, "GtkTreeViewColumn*");
  return(s7_make_real(sc, gtk_tree_view_column_get_alignment((GtkTreeViewColumn*)s7_c_pointer(tree_column))));
}

static s7_pointer lg_gtk_tree_view_column_set_reorderable(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_set_reorderable "void gtk_tree_view_column_set_reorderable(GtkTreeViewColumn* tree_column, \
gboolean reorderable)"
  s7_pointer _p;
  s7_pointer tree_column, reorderable;
  _p = args;
  tree_column = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_column, GtkTreeViewColumn__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_set_reorderable", 1, tree_column, "GtkTreeViewColumn*");
  reorderable = s7_car(_p);
  if (!s7_is_boolean(reorderable)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_set_reorderable", 2, reorderable, "gboolean");
  gtk_tree_view_column_set_reorderable((GtkTreeViewColumn*)s7_c_pointer(tree_column), (gboolean)lg_boolean(reorderable));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_column_get_reorderable(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_get_reorderable "gboolean gtk_tree_view_column_get_reorderable(GtkTreeViewColumn* tree_column)"
  s7_pointer tree_column;
  tree_column = s7_car(args);
  if (!s7_is_c_pointer_of_type(tree_column, GtkTreeViewColumn__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_get_reorderable", 1, tree_column, "GtkTreeViewColumn*");
  return(s7_make_boolean(sc, gtk_tree_view_column_get_reorderable((GtkTreeViewColumn*)s7_c_pointer(tree_column))));
}

static s7_pointer lg_gtk_tree_view_column_set_sort_column_id(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_set_sort_column_id "void gtk_tree_view_column_set_sort_column_id(GtkTreeViewColumn* tree_column, \
gint sort_column_id)"
  s7_pointer _p;
  s7_pointer tree_column, sort_column_id;
  _p = args;
  tree_column = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_column, GtkTreeViewColumn__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_set_sort_column_id", 1, tree_column, "GtkTreeViewColumn*");
  sort_column_id = s7_car(_p);
  if (!s7_is_integer(sort_column_id)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_set_sort_column_id", 2, sort_column_id, "gint");
  gtk_tree_view_column_set_sort_column_id((GtkTreeViewColumn*)s7_c_pointer(tree_column), (gint)s7_integer(sort_column_id));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_column_get_sort_column_id(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_get_sort_column_id "gint gtk_tree_view_column_get_sort_column_id(GtkTreeViewColumn* tree_column)"
  s7_pointer tree_column;
  tree_column = s7_car(args);
  if (!s7_is_c_pointer_of_type(tree_column, GtkTreeViewColumn__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_get_sort_column_id", 1, tree_column, "GtkTreeViewColumn*");
  return(s7_make_integer(sc, gtk_tree_view_column_get_sort_column_id((GtkTreeViewColumn*)s7_c_pointer(tree_column))));
}

static s7_pointer lg_gtk_tree_view_column_set_sort_indicator(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_set_sort_indicator "void gtk_tree_view_column_set_sort_indicator(GtkTreeViewColumn* tree_column, \
gboolean setting)"
  s7_pointer _p;
  s7_pointer tree_column, setting;
  _p = args;
  tree_column = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_column, GtkTreeViewColumn__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_set_sort_indicator", 1, tree_column, "GtkTreeViewColumn*");
  setting = s7_car(_p);
  if (!s7_is_boolean(setting)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_set_sort_indicator", 2, setting, "gboolean");
  gtk_tree_view_column_set_sort_indicator((GtkTreeViewColumn*)s7_c_pointer(tree_column), (gboolean)lg_boolean(setting));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_column_get_sort_indicator(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_get_sort_indicator "gboolean gtk_tree_view_column_get_sort_indicator(GtkTreeViewColumn* tree_column)"
  s7_pointer tree_column;
  tree_column = s7_car(args);
  if (!s7_is_c_pointer_of_type(tree_column, GtkTreeViewColumn__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_get_sort_indicator", 1, tree_column, "GtkTreeViewColumn*");
  return(s7_make_boolean(sc, gtk_tree_view_column_get_sort_indicator((GtkTreeViewColumn*)s7_c_pointer(tree_column))));
}

static s7_pointer lg_gtk_tree_view_column_set_sort_order(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_set_sort_order "void gtk_tree_view_column_set_sort_order(GtkTreeViewColumn* tree_column, \
GtkSortType order)"
  s7_pointer _p;
  s7_pointer tree_column, order;
  _p = args;
  tree_column = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_column, GtkTreeViewColumn__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_set_sort_order", 1, tree_column, "GtkTreeViewColumn*");
  order = s7_car(_p);
  if (!s7_is_integer(order)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_set_sort_order", 2, order, "GtkSortType");
  gtk_tree_view_column_set_sort_order((GtkTreeViewColumn*)s7_c_pointer(tree_column), (GtkSortType)s7_integer(order));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_column_get_sort_order(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_get_sort_order "GtkSortType gtk_tree_view_column_get_sort_order(GtkTreeViewColumn* tree_column)"
  s7_pointer tree_column;
  tree_column = s7_car(args);
  if (!s7_is_c_pointer_of_type(tree_column, GtkTreeViewColumn__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_get_sort_order", 1, tree_column, "GtkTreeViewColumn*");
  return(s7_make_integer(sc, gtk_tree_view_column_get_sort_order((GtkTreeViewColumn*)s7_c_pointer(tree_column))));
}

static s7_pointer lg_gtk_tree_view_column_cell_set_cell_data(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_cell_set_cell_data "void gtk_tree_view_column_cell_set_cell_data(GtkTreeViewColumn* tree_column, \
GtkTreeModel* tree_model, GtkTreeIter* iter, gboolean is_expander, gboolean is_expanded)"
  s7_pointer _p;
  s7_pointer tree_column, tree_model, iter, is_expander, is_expanded;
  _p = args;
  tree_column = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_column, GtkTreeViewColumn__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_cell_set_cell_data", 1, tree_column, "GtkTreeViewColumn*");
  tree_model = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_model, GtkTreeModel__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_cell_set_cell_data", 2, tree_model, "GtkTreeModel*");
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTreeIter__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_cell_set_cell_data", 3, iter, "GtkTreeIter*");
  is_expander = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_boolean(is_expander)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_cell_set_cell_data", 4, is_expander, "gboolean");
  is_expanded = s7_car(_p);
  if (!s7_is_boolean(is_expanded)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_cell_set_cell_data", 5, is_expanded, "gboolean");
  gtk_tree_view_column_cell_set_cell_data((GtkTreeViewColumn*)s7_c_pointer(tree_column), (GtkTreeModel*)s7_c_pointer(tree_model), (GtkTreeIter*)s7_c_pointer(iter), (gboolean)lg_boolean(is_expander), (gboolean)lg_boolean(is_expanded));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_column_cell_is_visible(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_cell_is_visible "gboolean gtk_tree_view_column_cell_is_visible(GtkTreeViewColumn* tree_column)"
  s7_pointer tree_column;
  tree_column = s7_car(args);
  if (!s7_is_c_pointer_of_type(tree_column, GtkTreeViewColumn__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_cell_is_visible", 1, tree_column, "GtkTreeViewColumn*");
  return(s7_make_boolean(sc, gtk_tree_view_column_cell_is_visible((GtkTreeViewColumn*)s7_c_pointer(tree_column))));
}

static s7_pointer lg_gtk_tree_view_column_cell_get_position(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_cell_get_position "gboolean gtk_tree_view_column_cell_get_position(GtkTreeViewColumn* tree_column, \
GtkCellRenderer* cell_renderer, gint* [start_pos], gint* [width])"
  s7_pointer _p;
  s7_pointer tree_column, cell_renderer;
  gint ref_start_pos;
  gint ref_width;
  _p = args;
  tree_column = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_column, GtkTreeViewColumn__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_cell_get_position", 1, tree_column, "GtkTreeViewColumn*");
  cell_renderer = s7_car(_p);
  if (!s7_is_c_pointer_of_type(cell_renderer, GtkCellRenderer__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_cell_get_position", 2, cell_renderer, "GtkCellRenderer*");
  {
    s7_pointer res_ult;
    res_ult = s7_make_boolean(sc, gtk_tree_view_column_cell_get_position((GtkTreeViewColumn*)s7_c_pointer(tree_column), (GtkCellRenderer*)s7_c_pointer(cell_renderer), &ref_start_pos, &ref_width));
      return(s7_list(sc, 3, res_ult, s7_make_integer(sc, ref_start_pos), s7_make_integer(sc, ref_width)));
   }
}

static s7_pointer lg_gtk_tree_view_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_new "GtkWidget* gtk_tree_view_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_tree_view_new()));
}

static s7_pointer lg_gtk_tree_view_new_with_model(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_new_with_model "GtkWidget* gtk_tree_view_new_with_model(GtkTreeModel* model)"
  s7_pointer model;
  model = s7_car(args);
  if (!s7_is_c_pointer_of_type(model, GtkTreeModel__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_new_with_model", 1, model, "GtkTreeModel*");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_tree_view_new_with_model((GtkTreeModel*)s7_c_pointer(model))));
}

static s7_pointer lg_gtk_tree_view_get_model(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_get_model "GtkTreeModel* gtk_tree_view_get_model(GtkTreeView* tree_view)"
  s7_pointer tree_view;
  tree_view = s7_car(args);
  if (!s7_is_c_pointer_of_type(tree_view, GtkTreeView__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_get_model", 1, tree_view, "GtkTreeView*");
  return(lg_make_c_pointer_with_type(sc, GtkTreeModel__sym, gtk_tree_view_get_model((GtkTreeView*)s7_c_pointer(tree_view))));
}

static s7_pointer lg_gtk_tree_view_set_model(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_set_model "void gtk_tree_view_set_model(GtkTreeView* tree_view, GtkTreeModel* model)"
  s7_pointer _p;
  s7_pointer tree_view, model;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_view, GtkTreeView__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_set_model", 1, tree_view, "GtkTreeView*");
  model = s7_car(_p);
  if ((!s7_is_c_pointer_of_type(model, GtkTreeModel__sym)) && (model != lg_false)) s7_wrong_type_arg_error(sc, "gtk_tree_view_set_model", 2, model, "GtkTreeModel*");
  gtk_tree_view_set_model((GtkTreeView*)s7_c_pointer(tree_view), (GtkTreeModel*)s7_c_pointer(model));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_get_selection(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_get_selection "GtkTreeSelection* gtk_tree_view_get_selection(GtkTreeView* tree_view)"
  s7_pointer tree_view;
  tree_view = s7_car(args);
  if (!s7_is_c_pointer_of_type(tree_view, GtkTreeView__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_get_selection", 1, tree_view, "GtkTreeView*");
  return(lg_make_c_pointer_with_type(sc, GtkTreeSelection__sym, gtk_tree_view_get_selection((GtkTreeView*)s7_c_pointer(tree_view))));
}

static s7_pointer lg_gtk_tree_view_get_headers_visible(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_get_headers_visible "gboolean gtk_tree_view_get_headers_visible(GtkTreeView* tree_view)"
  s7_pointer tree_view;
  tree_view = s7_car(args);
  if (!s7_is_c_pointer_of_type(tree_view, GtkTreeView__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_get_headers_visible", 1, tree_view, "GtkTreeView*");
  return(s7_make_boolean(sc, gtk_tree_view_get_headers_visible((GtkTreeView*)s7_c_pointer(tree_view))));
}

static s7_pointer lg_gtk_tree_view_set_headers_visible(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_set_headers_visible "void gtk_tree_view_set_headers_visible(GtkTreeView* tree_view, \
gboolean headers_visible)"
  s7_pointer _p;
  s7_pointer tree_view, headers_visible;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_view, GtkTreeView__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_set_headers_visible", 1, tree_view, "GtkTreeView*");
  headers_visible = s7_car(_p);
  if (!s7_is_boolean(headers_visible)) s7_wrong_type_arg_error(sc, "gtk_tree_view_set_headers_visible", 2, headers_visible, "gboolean");
  gtk_tree_view_set_headers_visible((GtkTreeView*)s7_c_pointer(tree_view), (gboolean)lg_boolean(headers_visible));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_columns_autosize(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_columns_autosize "void gtk_tree_view_columns_autosize(GtkTreeView* tree_view)"
  s7_pointer tree_view;
  tree_view = s7_car(args);
  if (!s7_is_c_pointer_of_type(tree_view, GtkTreeView__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_columns_autosize", 1, tree_view, "GtkTreeView*");
  gtk_tree_view_columns_autosize((GtkTreeView*)s7_c_pointer(tree_view));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_set_headers_clickable(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_set_headers_clickable "void gtk_tree_view_set_headers_clickable(GtkTreeView* tree_view, \
gboolean setting)"
  s7_pointer _p;
  s7_pointer tree_view, setting;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_view, GtkTreeView__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_set_headers_clickable", 1, tree_view, "GtkTreeView*");
  setting = s7_car(_p);
  if (!s7_is_boolean(setting)) s7_wrong_type_arg_error(sc, "gtk_tree_view_set_headers_clickable", 2, setting, "gboolean");
  gtk_tree_view_set_headers_clickable((GtkTreeView*)s7_c_pointer(tree_view), (gboolean)lg_boolean(setting));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_append_column(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_append_column "gint gtk_tree_view_append_column(GtkTreeView* tree_view, GtkTreeViewColumn* column)"
  s7_pointer _p;
  s7_pointer tree_view, column;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_view, GtkTreeView__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_append_column", 1, tree_view, "GtkTreeView*");
  column = s7_car(_p);
  if (!s7_is_c_pointer_of_type(column, GtkTreeViewColumn__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_append_column", 2, column, "GtkTreeViewColumn*");
  return(s7_make_integer(sc, gtk_tree_view_append_column((GtkTreeView*)s7_c_pointer(tree_view), (GtkTreeViewColumn*)s7_c_pointer(column))));
}

static s7_pointer lg_gtk_tree_view_remove_column(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_remove_column "gint gtk_tree_view_remove_column(GtkTreeView* tree_view, GtkTreeViewColumn* column)"
  s7_pointer _p;
  s7_pointer tree_view, column;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_view, GtkTreeView__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_remove_column", 1, tree_view, "GtkTreeView*");
  column = s7_car(_p);
  if (!s7_is_c_pointer_of_type(column, GtkTreeViewColumn__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_remove_column", 2, column, "GtkTreeViewColumn*");
  return(s7_make_integer(sc, gtk_tree_view_remove_column((GtkTreeView*)s7_c_pointer(tree_view), (GtkTreeViewColumn*)s7_c_pointer(column))));
}

static s7_pointer lg_gtk_tree_view_insert_column(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_insert_column "gint gtk_tree_view_insert_column(GtkTreeView* tree_view, GtkTreeViewColumn* column, \
gint position)"
  s7_pointer _p;
  s7_pointer tree_view, column, position;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_view, GtkTreeView__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_insert_column", 1, tree_view, "GtkTreeView*");
  column = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(column, GtkTreeViewColumn__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_insert_column", 2, column, "GtkTreeViewColumn*");
  position = s7_car(_p);
  if (!s7_is_integer(position)) s7_wrong_type_arg_error(sc, "gtk_tree_view_insert_column", 3, position, "gint");
  return(s7_make_integer(sc, gtk_tree_view_insert_column((GtkTreeView*)s7_c_pointer(tree_view), (GtkTreeViewColumn*)s7_c_pointer(column), (gint)s7_integer(position))));
}

static s7_pointer lg_gtk_tree_view_insert_column_with_attributes(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_insert_column_with_attributes "gint gtk_tree_view_insert_column_with_attributes(GtkTreeView* tree_view, \
gint position, gchar* title, GtkCellRenderer* cell, etc attributes)"
  s7_pointer _p;
  s7_pointer tree_view, position, title, cell, attributes;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_view, GtkTreeView__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_insert_column_with_attributes", 1, tree_view, "GtkTreeView*");
  position = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(position)) s7_wrong_type_arg_error(sc, "gtk_tree_view_insert_column_with_attributes", 2, position, "gint");
  title = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(title)) s7_wrong_type_arg_error(sc, "gtk_tree_view_insert_column_with_attributes", 3, title, "gchar*");
  cell = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(cell, GtkCellRenderer__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_insert_column_with_attributes", 4, cell, "GtkCellRenderer*");
  attributes = s7_car(_p);
  if (!lg_is_list(attributes)) s7_wrong_type_arg_error(sc, "gtk_tree_view_insert_column_with_attributes", 5, attributes, "etc");
  {
    int etc_len = 0;
    gint res_ult = 0;
    GtkTreeView* p_arg0;
    gint p_arg1;
    gchar* p_arg2;
    GtkCellRenderer* p_arg3;
    if (s7_is_list(sc, attributes)) etc_len = s7_list_length(sc, attributes);
    if (etc_len < 2) s7_out_of_range_error(sc, "gtk_tree_view_insert_column_with_attributes", 4, attributes, "... list must have at least 2 entries");
    if (etc_len > 10) s7_out_of_range_error(sc, "gtk_tree_view_insert_column_with_attributes", 4, attributes, "... list too long (max len: 10)");
    if ((etc_len % 2) != 0) s7_out_of_range_error(sc, "gtk_tree_view_insert_column_with_attributes", 4, attributes, "... list len must be multiple of 2");
    p_arg0 = (GtkTreeView*)s7_c_pointer(tree_view);
    p_arg1 = (gint)s7_integer(position);
    p_arg2 = (gchar*)s7_string(title);
    p_arg3 = (GtkCellRenderer*)s7_c_pointer(cell);
    switch (etc_len)
      {
        case 2: res_ult = gtk_tree_view_insert_column_with_attributes(p_arg0, p_arg1, p_arg2, p_arg3, s7_string(s7_list_ref(sc, attributes, 0)), s7_integer(s7_list_ref(sc, attributes, 1)), NULL); break;
        case 4: res_ult = gtk_tree_view_insert_column_with_attributes(p_arg0, p_arg1, p_arg2, p_arg3, s7_string(s7_list_ref(sc, attributes, 0)), s7_integer(s7_list_ref(sc, attributes, 1)), s7_string(s7_list_ref(sc, attributes, 2)), s7_integer(s7_list_ref(sc, attributes, 3)), NULL); break;
        case 6: res_ult = gtk_tree_view_insert_column_with_attributes(p_arg0, p_arg1, p_arg2, p_arg3, s7_string(s7_list_ref(sc, attributes, 0)), s7_integer(s7_list_ref(sc, attributes, 1)), s7_string(s7_list_ref(sc, attributes, 2)), s7_integer(s7_list_ref(sc, attributes, 3)), s7_string(s7_list_ref(sc, attributes, 4)), s7_integer(s7_list_ref(sc, attributes, 5)), NULL); break;
        case 8: res_ult = gtk_tree_view_insert_column_with_attributes(p_arg0, p_arg1, p_arg2, p_arg3, s7_string(s7_list_ref(sc, attributes, 0)), s7_integer(s7_list_ref(sc, attributes, 1)), s7_string(s7_list_ref(sc, attributes, 2)), s7_integer(s7_list_ref(sc, attributes, 3)), s7_string(s7_list_ref(sc, attributes, 4)), s7_integer(s7_list_ref(sc, attributes, 5)), s7_string(s7_list_ref(sc, attributes, 6)), s7_integer(s7_list_ref(sc, attributes, 7)), NULL); break;
        case 10: res_ult = gtk_tree_view_insert_column_with_attributes(p_arg0, p_arg1, p_arg2, p_arg3, s7_string(s7_list_ref(sc, attributes, 0)), s7_integer(s7_list_ref(sc, attributes, 1)), s7_string(s7_list_ref(sc, attributes, 2)), s7_integer(s7_list_ref(sc, attributes, 3)), s7_string(s7_list_ref(sc, attributes, 4)), s7_integer(s7_list_ref(sc, attributes, 5)), s7_string(s7_list_ref(sc, attributes, 6)), s7_integer(s7_list_ref(sc, attributes, 7)), s7_string(s7_list_ref(sc, attributes, 8)), s7_integer(s7_list_ref(sc, attributes, 9)), NULL); break;
      }
    return(s7_make_integer(sc, res_ult));
  }
}

static s7_pointer lg_gtk_tree_view_insert_column_with_data_func(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_insert_column_with_data_func "gint gtk_tree_view_insert_column_with_data_func(GtkTreeView* tree_view, \
gint position, gchar* title, GtkCellRenderer* cell, GtkTreeCellDataFunc func, lambda_data func_info, \
GtkDestroyNotify dnotify)"
  s7_pointer _p;
  s7_pointer tree_view, position, title, cell, func, func_info, dnotify;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_view, GtkTreeView__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_insert_column_with_data_func", 1, tree_view, "GtkTreeView*");
  position = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(position)) s7_wrong_type_arg_error(sc, "gtk_tree_view_insert_column_with_data_func", 2, position, "gint");
  title = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(title)) s7_wrong_type_arg_error(sc, "gtk_tree_view_insert_column_with_data_func", 3, title, "gchar*");
  cell = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(cell, GtkCellRenderer__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_insert_column_with_data_func", 4, cell, "GtkCellRenderer*");
  func = s7_car(_p); _p = s7_cdr(_p);
  func_info = s7_car(_p); _p = s7_cdr(_p);
  dnotify = s7_car(_p);
  {
    s7_pointer res_ult;
    s7_pointer lg_ptr = s7_list(sc, 5, func, func_info, lg_false, lg_false, lg_false);
    s7_gc_protect(sc, lg_ptr);
    s7_list_set(sc, lg_ptr, 3, dnotify);
    res_ult = s7_make_integer(sc, gtk_tree_view_insert_column_with_data_func((GtkTreeView*)s7_c_pointer(tree_view), (gint)s7_integer(position), (gchar*)s7_string(title), (GtkCellRenderer*)s7_c_pointer(cell), lg_cell_data, (gpointer)lg_ptr, lg_destroy_func));
    return(res_ult);
   }
}

static s7_pointer lg_gtk_tree_view_get_column(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_get_column "GtkTreeViewColumn* gtk_tree_view_get_column(GtkTreeView* tree_view, \
gint n)"
  s7_pointer _p;
  s7_pointer tree_view, n;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_view, GtkTreeView__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_get_column", 1, tree_view, "GtkTreeView*");
  n = s7_car(_p);
  if (!s7_is_integer(n)) s7_wrong_type_arg_error(sc, "gtk_tree_view_get_column", 2, n, "gint");
  return(lg_make_c_pointer_with_type(sc, GtkTreeViewColumn__sym, gtk_tree_view_get_column((GtkTreeView*)s7_c_pointer(tree_view), (gint)s7_integer(n))));
}

static s7_pointer lg_gtk_tree_view_get_columns(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_get_columns "GList* gtk_tree_view_get_columns(GtkTreeView* tree_view)"
  s7_pointer tree_view;
  tree_view = s7_car(args);
  if (!s7_is_c_pointer_of_type(tree_view, GtkTreeView__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_get_columns", 1, tree_view, "GtkTreeView*");
  return(lg_make_c_pointer_with_type(sc, GList__sym, gtk_tree_view_get_columns((GtkTreeView*)s7_c_pointer(tree_view))));
}

static s7_pointer lg_gtk_tree_view_move_column_after(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_move_column_after "void gtk_tree_view_move_column_after(GtkTreeView* tree_view, \
GtkTreeViewColumn* column, GtkTreeViewColumn* base_column)"
  s7_pointer _p;
  s7_pointer tree_view, column, base_column;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_view, GtkTreeView__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_move_column_after", 1, tree_view, "GtkTreeView*");
  column = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(column, GtkTreeViewColumn__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_move_column_after", 2, column, "GtkTreeViewColumn*");
  base_column = s7_car(_p);
  if ((!s7_is_c_pointer_of_type(base_column, GtkTreeViewColumn__sym)) && (base_column != lg_false)) s7_wrong_type_arg_error(sc, "gtk_tree_view_move_column_after", 3, base_column, "GtkTreeViewColumn*");
  gtk_tree_view_move_column_after((GtkTreeView*)s7_c_pointer(tree_view), (GtkTreeViewColumn*)s7_c_pointer(column), (GtkTreeViewColumn*)s7_c_pointer(base_column));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_set_expander_column(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_set_expander_column "void gtk_tree_view_set_expander_column(GtkTreeView* tree_view, \
GtkTreeViewColumn* column)"
  s7_pointer _p;
  s7_pointer tree_view, column;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_view, GtkTreeView__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_set_expander_column", 1, tree_view, "GtkTreeView*");
  column = s7_car(_p);
  if ((!s7_is_c_pointer_of_type(column, GtkTreeViewColumn__sym)) && (column != lg_false)) s7_wrong_type_arg_error(sc, "gtk_tree_view_set_expander_column", 2, column, "GtkTreeViewColumn*");
  gtk_tree_view_set_expander_column((GtkTreeView*)s7_c_pointer(tree_view), (GtkTreeViewColumn*)s7_c_pointer(column));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_get_expander_column(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_get_expander_column "GtkTreeViewColumn* gtk_tree_view_get_expander_column(GtkTreeView* tree_view)"
  s7_pointer tree_view;
  tree_view = s7_car(args);
  if (!s7_is_c_pointer_of_type(tree_view, GtkTreeView__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_get_expander_column", 1, tree_view, "GtkTreeView*");
  return(lg_make_c_pointer_with_type(sc, GtkTreeViewColumn__sym, gtk_tree_view_get_expander_column((GtkTreeView*)s7_c_pointer(tree_view))));
}

static s7_pointer lg_gtk_tree_view_set_column_drag_function(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_set_column_drag_function "void gtk_tree_view_set_column_drag_function(GtkTreeView* tree_view, \
GtkTreeViewColumnDropFunc func, lambda_data func_info, GtkDestroyNotify destroy)"
  s7_pointer _p;
  s7_pointer tree_view, func, func_info, destroy;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_view, GtkTreeView__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_set_column_drag_function", 1, tree_view, "GtkTreeView*");
  func = s7_car(_p); _p = s7_cdr(_p);
  func_info = s7_car(_p); _p = s7_cdr(_p);
  destroy = s7_car(_p);
  {
    int loc;
    s7_pointer lg_ptr = s7_list(sc, 5, func, func_info, lg_false, lg_false, lg_false);
    loc = s7_gc_protect(sc, lg_ptr);
    s7_list_set(sc, lg_ptr, 2, s7_make_integer(sc, loc));
    s7_list_set(sc, lg_ptr, 3, destroy);
    gtk_tree_view_set_column_drag_function((GtkTreeView*)s7_c_pointer(tree_view), lg_tree_column, (gpointer)lg_ptr, lg_destroy_func);
    return(lg_false);
   }
}

static s7_pointer lg_gtk_tree_view_scroll_to_point(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_scroll_to_point "void gtk_tree_view_scroll_to_point(GtkTreeView* tree_view, \
gint tree_x, gint tree_y)"
  s7_pointer _p;
  s7_pointer tree_view, tree_x, tree_y;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_view, GtkTreeView__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_scroll_to_point", 1, tree_view, "GtkTreeView*");
  tree_x = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(tree_x)) s7_wrong_type_arg_error(sc, "gtk_tree_view_scroll_to_point", 2, tree_x, "gint");
  tree_y = s7_car(_p);
  if (!s7_is_integer(tree_y)) s7_wrong_type_arg_error(sc, "gtk_tree_view_scroll_to_point", 3, tree_y, "gint");
  gtk_tree_view_scroll_to_point((GtkTreeView*)s7_c_pointer(tree_view), (gint)s7_integer(tree_x), (gint)s7_integer(tree_y));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_scroll_to_cell(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_scroll_to_cell "void gtk_tree_view_scroll_to_cell(GtkTreeView* tree_view, GtkTreePath* path, \
GtkTreeViewColumn* column, gboolean use_align, gfloat row_align, gfloat col_align)"
  s7_pointer _p;
  s7_pointer tree_view, path, column, use_align, row_align, col_align;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_view, GtkTreeView__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_scroll_to_cell", 1, tree_view, "GtkTreeView*");
  path = s7_car(_p); _p = s7_cdr(_p);
  if ((!s7_is_c_pointer_of_type(path, GtkTreePath__sym)) && (path != lg_false)) s7_wrong_type_arg_error(sc, "gtk_tree_view_scroll_to_cell", 2, path, "GtkTreePath*");
  column = s7_car(_p); _p = s7_cdr(_p);
  if ((!s7_is_c_pointer_of_type(column, GtkTreeViewColumn__sym)) && (column != lg_false)) s7_wrong_type_arg_error(sc, "gtk_tree_view_scroll_to_cell", 3, column, "GtkTreeViewColumn*");
  use_align = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_boolean(use_align)) s7_wrong_type_arg_error(sc, "gtk_tree_view_scroll_to_cell", 4, use_align, "gboolean");
  row_align = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(row_align)) s7_wrong_type_arg_error(sc, "gtk_tree_view_scroll_to_cell", 5, row_align, "gfloat");
  col_align = s7_car(_p);
  if (!s7_is_real(col_align)) s7_wrong_type_arg_error(sc, "gtk_tree_view_scroll_to_cell", 6, col_align, "gfloat");
  gtk_tree_view_scroll_to_cell((GtkTreeView*)s7_c_pointer(tree_view), (GtkTreePath*)s7_c_pointer(path), (GtkTreeViewColumn*)s7_c_pointer(column), (gboolean)lg_boolean(use_align), (gfloat)s7_real(row_align), (gfloat)s7_real(col_align));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_row_activated(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_row_activated "void gtk_tree_view_row_activated(GtkTreeView* tree_view, GtkTreePath* path, \
GtkTreeViewColumn* column)"
  s7_pointer _p;
  s7_pointer tree_view, path, column;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_view, GtkTreeView__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_row_activated", 1, tree_view, "GtkTreeView*");
  path = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(path, GtkTreePath__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_row_activated", 2, path, "GtkTreePath*");
  column = s7_car(_p);
  if (!s7_is_c_pointer_of_type(column, GtkTreeViewColumn__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_row_activated", 3, column, "GtkTreeViewColumn*");
  gtk_tree_view_row_activated((GtkTreeView*)s7_c_pointer(tree_view), (GtkTreePath*)s7_c_pointer(path), (GtkTreeViewColumn*)s7_c_pointer(column));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_expand_all(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_expand_all "void gtk_tree_view_expand_all(GtkTreeView* tree_view)"
  s7_pointer tree_view;
  tree_view = s7_car(args);
  if (!s7_is_c_pointer_of_type(tree_view, GtkTreeView__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_expand_all", 1, tree_view, "GtkTreeView*");
  gtk_tree_view_expand_all((GtkTreeView*)s7_c_pointer(tree_view));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_collapse_all(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_collapse_all "void gtk_tree_view_collapse_all(GtkTreeView* tree_view)"
  s7_pointer tree_view;
  tree_view = s7_car(args);
  if (!s7_is_c_pointer_of_type(tree_view, GtkTreeView__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_collapse_all", 1, tree_view, "GtkTreeView*");
  gtk_tree_view_collapse_all((GtkTreeView*)s7_c_pointer(tree_view));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_expand_row(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_expand_row "gboolean gtk_tree_view_expand_row(GtkTreeView* tree_view, GtkTreePath* path, \
gboolean open_all)"
  s7_pointer _p;
  s7_pointer tree_view, path, open_all;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_view, GtkTreeView__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_expand_row", 1, tree_view, "GtkTreeView*");
  path = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(path, GtkTreePath__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_expand_row", 2, path, "GtkTreePath*");
  open_all = s7_car(_p);
  if (!s7_is_boolean(open_all)) s7_wrong_type_arg_error(sc, "gtk_tree_view_expand_row", 3, open_all, "gboolean");
  return(s7_make_boolean(sc, gtk_tree_view_expand_row((GtkTreeView*)s7_c_pointer(tree_view), (GtkTreePath*)s7_c_pointer(path), (gboolean)lg_boolean(open_all))));
}

static s7_pointer lg_gtk_tree_view_collapse_row(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_collapse_row "gboolean gtk_tree_view_collapse_row(GtkTreeView* tree_view, GtkTreePath* path)"
  s7_pointer _p;
  s7_pointer tree_view, path;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_view, GtkTreeView__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_collapse_row", 1, tree_view, "GtkTreeView*");
  path = s7_car(_p);
  if (!s7_is_c_pointer_of_type(path, GtkTreePath__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_collapse_row", 2, path, "GtkTreePath*");
  return(s7_make_boolean(sc, gtk_tree_view_collapse_row((GtkTreeView*)s7_c_pointer(tree_view), (GtkTreePath*)s7_c_pointer(path))));
}

static s7_pointer lg_gtk_tree_view_map_expanded_rows(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_map_expanded_rows "void gtk_tree_view_map_expanded_rows(GtkTreeView* tree_view, \
GtkTreeViewMappingFunc func, lambda_data func_info)"
  s7_pointer _p;
  s7_pointer tree_view, func, func_info;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_view, GtkTreeView__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_map_expanded_rows", 1, tree_view, "GtkTreeView*");
  func = s7_car(_p); _p = s7_cdr(_p);
  func_info = s7_car(_p);
  {
    int loc;
    s7_pointer lg_ptr = s7_list(sc, 5, func, func_info, lg_false, lg_false, lg_false);
    loc = s7_gc_protect(sc, lg_ptr);
    s7_list_set(sc, lg_ptr, 2, s7_make_integer(sc, loc));
    gtk_tree_view_map_expanded_rows((GtkTreeView*)s7_c_pointer(tree_view), lg_tree_mapping, (gpointer)lg_ptr);
    return(lg_false);
   }
}

static s7_pointer lg_gtk_tree_view_row_expanded(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_row_expanded "gboolean gtk_tree_view_row_expanded(GtkTreeView* tree_view, GtkTreePath* path)"
  s7_pointer _p;
  s7_pointer tree_view, path;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_view, GtkTreeView__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_row_expanded", 1, tree_view, "GtkTreeView*");
  path = s7_car(_p);
  if (!s7_is_c_pointer_of_type(path, GtkTreePath__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_row_expanded", 2, path, "GtkTreePath*");
  return(s7_make_boolean(sc, gtk_tree_view_row_expanded((GtkTreeView*)s7_c_pointer(tree_view), (GtkTreePath*)s7_c_pointer(path))));
}

static s7_pointer lg_gtk_tree_view_set_reorderable(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_set_reorderable "void gtk_tree_view_set_reorderable(GtkTreeView* tree_view, \
gboolean reorderable)"
  s7_pointer _p;
  s7_pointer tree_view, reorderable;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_view, GtkTreeView__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_set_reorderable", 1, tree_view, "GtkTreeView*");
  reorderable = s7_car(_p);
  if (!s7_is_boolean(reorderable)) s7_wrong_type_arg_error(sc, "gtk_tree_view_set_reorderable", 2, reorderable, "gboolean");
  gtk_tree_view_set_reorderable((GtkTreeView*)s7_c_pointer(tree_view), (gboolean)lg_boolean(reorderable));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_get_reorderable(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_get_reorderable "gboolean gtk_tree_view_get_reorderable(GtkTreeView* tree_view)"
  s7_pointer tree_view;
  tree_view = s7_car(args);
  if (!s7_is_c_pointer_of_type(tree_view, GtkTreeView__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_get_reorderable", 1, tree_view, "GtkTreeView*");
  return(s7_make_boolean(sc, gtk_tree_view_get_reorderable((GtkTreeView*)s7_c_pointer(tree_view))));
}

static s7_pointer lg_gtk_tree_view_set_cursor(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_set_cursor "void gtk_tree_view_set_cursor(GtkTreeView* tree_view, GtkTreePath* path, \
GtkTreeViewColumn* focus_column, gboolean start_editing)"
  s7_pointer _p;
  s7_pointer tree_view, path, focus_column, start_editing;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_view, GtkTreeView__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_set_cursor", 1, tree_view, "GtkTreeView*");
  path = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(path, GtkTreePath__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_set_cursor", 2, path, "GtkTreePath*");
  focus_column = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(focus_column, GtkTreeViewColumn__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_set_cursor", 3, focus_column, "GtkTreeViewColumn*");
  start_editing = s7_car(_p);
  if (!s7_is_boolean(start_editing)) s7_wrong_type_arg_error(sc, "gtk_tree_view_set_cursor", 4, start_editing, "gboolean");
  gtk_tree_view_set_cursor((GtkTreeView*)s7_c_pointer(tree_view), (GtkTreePath*)s7_c_pointer(path), (GtkTreeViewColumn*)s7_c_pointer(focus_column), (gboolean)lg_boolean(start_editing));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_get_cursor(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_get_cursor "void gtk_tree_view_get_cursor(GtkTreeView* tree_view, GtkTreePath** [path], \
GtkTreeViewColumn** [focus_column])"
  s7_pointer _p;
  s7_pointer tree_view;
  GtkTreePath* ref_path = NULL;
  GtkTreeViewColumn* ref_focus_column = NULL;
  _p = args;
  tree_view = s7_car(_p);
  if (!s7_is_c_pointer_of_type(tree_view, GtkTreeView__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_get_cursor", 1, tree_view, "GtkTreeView*");
  gtk_tree_view_get_cursor((GtkTreeView*)s7_c_pointer(tree_view), &ref_path, &ref_focus_column);
    return(s7_list(sc, 2, s7_make_c_pointer(sc, ref_path), s7_make_c_pointer(sc, ref_focus_column)));
}

static s7_pointer lg_gtk_tree_view_get_path_at_pos(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_get_path_at_pos "gboolean gtk_tree_view_get_path_at_pos(GtkTreeView* tree_view, \
gint x, gint y, GtkTreePath** [path], GtkTreeViewColumn** [column], gint* [cell_x], gint* [cell_y])"
  s7_pointer _p;
  s7_pointer tree_view, x, y;
  GtkTreePath* ref_path = NULL;
  GtkTreeViewColumn* ref_column = NULL;
  gint ref_cell_x;
  gint ref_cell_y;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_view, GtkTreeView__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_get_path_at_pos", 1, tree_view, "GtkTreeView*");
  x = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(x)) s7_wrong_type_arg_error(sc, "gtk_tree_view_get_path_at_pos", 2, x, "gint");
  y = s7_car(_p);
  if (!s7_is_integer(y)) s7_wrong_type_arg_error(sc, "gtk_tree_view_get_path_at_pos", 3, y, "gint");
  {
    s7_pointer res_ult;
    res_ult = s7_make_boolean(sc, gtk_tree_view_get_path_at_pos((GtkTreeView*)s7_c_pointer(tree_view), (gint)s7_integer(x), (gint)s7_integer(y), &ref_path, &ref_column, &ref_cell_x, &ref_cell_y));
      return(s7_list(sc, 5, res_ult, s7_make_c_pointer(sc, ref_path), s7_make_c_pointer(sc, ref_column), s7_make_integer(sc, ref_cell_x), s7_make_integer(sc, ref_cell_y)));
   }
}

static s7_pointer lg_gtk_tree_view_get_cell_area(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_get_cell_area "void gtk_tree_view_get_cell_area(GtkTreeView* tree_view, GtkTreePath* path, \
GtkTreeViewColumn* column, GdkRectangle* rect)"
  s7_pointer _p;
  s7_pointer tree_view, path, column, rect;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_view, GtkTreeView__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_get_cell_area", 1, tree_view, "GtkTreeView*");
  path = s7_car(_p); _p = s7_cdr(_p);
  if ((!s7_is_c_pointer_of_type(path, GtkTreePath__sym)) && (path != lg_false)) s7_wrong_type_arg_error(sc, "gtk_tree_view_get_cell_area", 2, path, "GtkTreePath*");
  column = s7_car(_p); _p = s7_cdr(_p);
  if ((!s7_is_c_pointer_of_type(column, GtkTreeViewColumn__sym)) && (column != lg_false)) s7_wrong_type_arg_error(sc, "gtk_tree_view_get_cell_area", 3, column, "GtkTreeViewColumn*");
  rect = s7_car(_p);
  if (!s7_is_c_pointer_of_type(rect, GdkRectangle__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_get_cell_area", 4, rect, "GdkRectangle*");
  gtk_tree_view_get_cell_area((GtkTreeView*)s7_c_pointer(tree_view), (GtkTreePath*)s7_c_pointer(path), (GtkTreeViewColumn*)s7_c_pointer(column), (GdkRectangle*)s7_c_pointer(rect));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_get_background_area(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_get_background_area "void gtk_tree_view_get_background_area(GtkTreeView* tree_view, \
GtkTreePath* path, GtkTreeViewColumn* column, GdkRectangle* rect)"
  s7_pointer _p;
  s7_pointer tree_view, path, column, rect;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_view, GtkTreeView__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_get_background_area", 1, tree_view, "GtkTreeView*");
  path = s7_car(_p); _p = s7_cdr(_p);
  if ((!s7_is_c_pointer_of_type(path, GtkTreePath__sym)) && (path != lg_false)) s7_wrong_type_arg_error(sc, "gtk_tree_view_get_background_area", 2, path, "GtkTreePath*");
  column = s7_car(_p); _p = s7_cdr(_p);
  if ((!s7_is_c_pointer_of_type(column, GtkTreeViewColumn__sym)) && (column != lg_false)) s7_wrong_type_arg_error(sc, "gtk_tree_view_get_background_area", 3, column, "GtkTreeViewColumn*");
  rect = s7_car(_p);
  if (!s7_is_c_pointer_of_type(rect, GdkRectangle__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_get_background_area", 4, rect, "GdkRectangle*");
  gtk_tree_view_get_background_area((GtkTreeView*)s7_c_pointer(tree_view), (GtkTreePath*)s7_c_pointer(path), (GtkTreeViewColumn*)s7_c_pointer(column), (GdkRectangle*)s7_c_pointer(rect));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_get_visible_rect(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_get_visible_rect "void gtk_tree_view_get_visible_rect(GtkTreeView* tree_view, \
GdkRectangle* visible_rect)"
  s7_pointer _p;
  s7_pointer tree_view, visible_rect;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_view, GtkTreeView__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_get_visible_rect", 1, tree_view, "GtkTreeView*");
  visible_rect = s7_car(_p);
  if (!s7_is_c_pointer_of_type(visible_rect, GdkRectangle__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_get_visible_rect", 2, visible_rect, "GdkRectangle*");
  gtk_tree_view_get_visible_rect((GtkTreeView*)s7_c_pointer(tree_view), (GdkRectangle*)s7_c_pointer(visible_rect));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_unset_rows_drag_source(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_unset_rows_drag_source "void gtk_tree_view_unset_rows_drag_source(GtkTreeView* tree_view)"
  s7_pointer tree_view;
  tree_view = s7_car(args);
  if (!s7_is_c_pointer_of_type(tree_view, GtkTreeView__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_unset_rows_drag_source", 1, tree_view, "GtkTreeView*");
  gtk_tree_view_unset_rows_drag_source((GtkTreeView*)s7_c_pointer(tree_view));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_get_dest_row_at_pos(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_get_dest_row_at_pos "gboolean gtk_tree_view_get_dest_row_at_pos(GtkTreeView* tree_view, \
gint drag_x, gint drag_y, GtkTreePath** [path], GtkTreeViewDropPosition* [pos])"
  s7_pointer _p;
  s7_pointer tree_view, drag_x, drag_y;
  GtkTreePath* ref_path = NULL;
  GtkTreeViewDropPosition ref_pos;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_view, GtkTreeView__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_get_dest_row_at_pos", 1, tree_view, "GtkTreeView*");
  drag_x = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(drag_x)) s7_wrong_type_arg_error(sc, "gtk_tree_view_get_dest_row_at_pos", 2, drag_x, "gint");
  drag_y = s7_car(_p);
  if (!s7_is_integer(drag_y)) s7_wrong_type_arg_error(sc, "gtk_tree_view_get_dest_row_at_pos", 3, drag_y, "gint");
  {
    s7_pointer res_ult;
    res_ult = s7_make_boolean(sc, gtk_tree_view_get_dest_row_at_pos((GtkTreeView*)s7_c_pointer(tree_view), (gint)s7_integer(drag_x), (gint)s7_integer(drag_y), &ref_path, &ref_pos));
      return(s7_list(sc, 3, res_ult, s7_make_c_pointer(sc, ref_path), s7_make_integer(sc, ref_pos)));
   }
}

static s7_pointer lg_gtk_tree_view_set_enable_search(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_set_enable_search "void gtk_tree_view_set_enable_search(GtkTreeView* tree_view, \
gboolean enable_search)"
  s7_pointer _p;
  s7_pointer tree_view, enable_search;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_view, GtkTreeView__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_set_enable_search", 1, tree_view, "GtkTreeView*");
  enable_search = s7_car(_p);
  if (!s7_is_boolean(enable_search)) s7_wrong_type_arg_error(sc, "gtk_tree_view_set_enable_search", 2, enable_search, "gboolean");
  gtk_tree_view_set_enable_search((GtkTreeView*)s7_c_pointer(tree_view), (gboolean)lg_boolean(enable_search));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_get_enable_search(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_get_enable_search "gboolean gtk_tree_view_get_enable_search(GtkTreeView* tree_view)"
  s7_pointer tree_view;
  tree_view = s7_car(args);
  if (!s7_is_c_pointer_of_type(tree_view, GtkTreeView__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_get_enable_search", 1, tree_view, "GtkTreeView*");
  return(s7_make_boolean(sc, gtk_tree_view_get_enable_search((GtkTreeView*)s7_c_pointer(tree_view))));
}

static s7_pointer lg_gtk_tree_view_get_search_column(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_get_search_column "gint gtk_tree_view_get_search_column(GtkTreeView* tree_view)"
  s7_pointer tree_view;
  tree_view = s7_car(args);
  if (!s7_is_c_pointer_of_type(tree_view, GtkTreeView__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_get_search_column", 1, tree_view, "GtkTreeView*");
  return(s7_make_integer(sc, gtk_tree_view_get_search_column((GtkTreeView*)s7_c_pointer(tree_view))));
}

static s7_pointer lg_gtk_tree_view_set_search_column(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_set_search_column "void gtk_tree_view_set_search_column(GtkTreeView* tree_view, \
gint column)"
  s7_pointer _p;
  s7_pointer tree_view, column;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_view, GtkTreeView__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_set_search_column", 1, tree_view, "GtkTreeView*");
  column = s7_car(_p);
  if (!s7_is_integer(column)) s7_wrong_type_arg_error(sc, "gtk_tree_view_set_search_column", 2, column, "gint");
  gtk_tree_view_set_search_column((GtkTreeView*)s7_c_pointer(tree_view), (gint)s7_integer(column));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_get_search_equal_func(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_get_search_equal_func "GtkTreeViewSearchEqualFunc gtk_tree_view_get_search_equal_func(GtkTreeView* tree_view)"
  s7_pointer tree_view;
  tree_view = s7_car(args);
  if (!s7_is_c_pointer_of_type(tree_view, GtkTreeView__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_get_search_equal_func", 1, tree_view, "GtkTreeView*");
  return(lg_make_c_pointer_with_type(sc, GtkTreeViewSearchEqualFunc_sym, gtk_tree_view_get_search_equal_func((GtkTreeView*)s7_c_pointer(tree_view))));
}

static s7_pointer lg_gtk_tree_view_set_search_equal_func(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_set_search_equal_func "void gtk_tree_view_set_search_equal_func(GtkTreeView* tree_view, \
GtkTreeViewSearchEqualFunc func, lambda_data func_info, GtkDestroyNotify search_destroy)"
  s7_pointer _p;
  s7_pointer tree_view, func, func_info, search_destroy;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_view, GtkTreeView__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_set_search_equal_func", 1, tree_view, "GtkTreeView*");
  func = s7_car(_p); _p = s7_cdr(_p);
  func_info = s7_car(_p); _p = s7_cdr(_p);
  search_destroy = s7_car(_p);
  {
    int loc;
    s7_pointer lg_ptr = s7_list(sc, 5, func, func_info, lg_false, lg_false, lg_false);
    loc = s7_gc_protect(sc, lg_ptr);
    s7_list_set(sc, lg_ptr, 2, s7_make_integer(sc, loc));
    s7_list_set(sc, lg_ptr, 3, search_destroy);
    gtk_tree_view_set_search_equal_func((GtkTreeView*)s7_c_pointer(tree_view), lg_tree_search, (gpointer)lg_ptr, lg_destroy_func);
    return(lg_false);
   }
}

static s7_pointer lg_gtk_viewport_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_viewport_new "GtkWidget* gtk_viewport_new(GtkAdjustment* hadjustment, GtkAdjustment* vadjustment)"
  s7_pointer _p;
  s7_pointer hadjustment, vadjustment;
  _p = args;
  hadjustment = s7_car(_p); _p = s7_cdr(_p);
  if ((!s7_is_c_pointer_of_type(hadjustment, GtkAdjustment__sym)) && (hadjustment != lg_false)) s7_wrong_type_arg_error(sc, "gtk_viewport_new", 1, hadjustment, "GtkAdjustment*");
  vadjustment = s7_car(_p);
  if ((!s7_is_c_pointer_of_type(vadjustment, GtkAdjustment__sym)) && (vadjustment != lg_false)) s7_wrong_type_arg_error(sc, "gtk_viewport_new", 2, vadjustment, "GtkAdjustment*");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_viewport_new((GtkAdjustment*)s7_c_pointer(hadjustment), (GtkAdjustment*)s7_c_pointer(vadjustment))));
}

static s7_pointer lg_gtk_widget_unparent(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_unparent "void gtk_widget_unparent(GtkWidget* widget)"
  s7_pointer widget;
  widget = s7_car(args);
  if (!s7_is_c_pointer_of_type(widget, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_widget_unparent", 1, widget, "GtkWidget*");
  gtk_widget_unparent((GtkWidget*)s7_c_pointer(widget));
  return(lg_false);
}

static s7_pointer lg_gtk_widget_show(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_show "void gtk_widget_show(GtkWidget* widget)"
  s7_pointer widget;
  widget = s7_car(args);
  if (!s7_is_c_pointer_of_type(widget, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_widget_show", 1, widget, "GtkWidget*");
  gtk_widget_show((GtkWidget*)s7_c_pointer(widget));
  return(lg_false);
}

static s7_pointer lg_gtk_widget_hide(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_hide "void gtk_widget_hide(GtkWidget* widget)"
  s7_pointer widget;
  widget = s7_car(args);
  if (!s7_is_c_pointer_of_type(widget, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_widget_hide", 1, widget, "GtkWidget*");
  gtk_widget_hide((GtkWidget*)s7_c_pointer(widget));
  return(lg_false);
}

static s7_pointer lg_gtk_widget_map(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_map "void gtk_widget_map(GtkWidget* widget)"
  s7_pointer widget;
  widget = s7_car(args);
  if (!s7_is_c_pointer_of_type(widget, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_widget_map", 1, widget, "GtkWidget*");
  gtk_widget_map((GtkWidget*)s7_c_pointer(widget));
  return(lg_false);
}

static s7_pointer lg_gtk_widget_unmap(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_unmap "void gtk_widget_unmap(GtkWidget* widget)"
  s7_pointer widget;
  widget = s7_car(args);
  if (!s7_is_c_pointer_of_type(widget, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_widget_unmap", 1, widget, "GtkWidget*");
  gtk_widget_unmap((GtkWidget*)s7_c_pointer(widget));
  return(lg_false);
}

static s7_pointer lg_gtk_widget_realize(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_realize "void gtk_widget_realize(GtkWidget* widget)"
  s7_pointer widget;
  widget = s7_car(args);
  if (!s7_is_c_pointer_of_type(widget, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_widget_realize", 1, widget, "GtkWidget*");
  gtk_widget_realize((GtkWidget*)s7_c_pointer(widget));
  return(lg_false);
}

static s7_pointer lg_gtk_widget_unrealize(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_unrealize "void gtk_widget_unrealize(GtkWidget* widget)"
  s7_pointer widget;
  widget = s7_car(args);
  if (!s7_is_c_pointer_of_type(widget, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_widget_unrealize", 1, widget, "GtkWidget*");
  gtk_widget_unrealize((GtkWidget*)s7_c_pointer(widget));
  return(lg_false);
}

static s7_pointer lg_gtk_widget_queue_draw(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_queue_draw "void gtk_widget_queue_draw(GtkWidget* widget)"
  s7_pointer widget;
  widget = s7_car(args);
  if (!s7_is_c_pointer_of_type(widget, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_widget_queue_draw", 1, widget, "GtkWidget*");
  gtk_widget_queue_draw((GtkWidget*)s7_c_pointer(widget));
  return(lg_false);
}

static s7_pointer lg_gtk_widget_queue_resize(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_queue_resize "void gtk_widget_queue_resize(GtkWidget* widget)"
  s7_pointer widget;
  widget = s7_car(args);
  if (!s7_is_c_pointer_of_type(widget, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_widget_queue_resize", 1, widget, "GtkWidget*");
  gtk_widget_queue_resize((GtkWidget*)s7_c_pointer(widget));
  return(lg_false);
}

static s7_pointer lg_gtk_widget_mnemonic_activate(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_mnemonic_activate "gboolean gtk_widget_mnemonic_activate(GtkWidget* widget, gboolean group_cycling)"
  s7_pointer _p;
  s7_pointer widget, group_cycling;
  _p = args;
  widget = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(widget, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_widget_mnemonic_activate", 1, widget, "GtkWidget*");
  group_cycling = s7_car(_p);
  if (!s7_is_boolean(group_cycling)) s7_wrong_type_arg_error(sc, "gtk_widget_mnemonic_activate", 2, group_cycling, "gboolean");
  return(s7_make_boolean(sc, gtk_widget_mnemonic_activate((GtkWidget*)s7_c_pointer(widget), (gboolean)lg_boolean(group_cycling))));
}

static s7_pointer lg_gtk_widget_activate(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_activate "gboolean gtk_widget_activate(GtkWidget* widget)"
  s7_pointer widget;
  widget = s7_car(args);
  if (!s7_is_c_pointer_of_type(widget, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_widget_activate", 1, widget, "GtkWidget*");
  return(s7_make_boolean(sc, gtk_widget_activate((GtkWidget*)s7_c_pointer(widget))));
}

static s7_pointer lg_gtk_widget_is_focus(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_is_focus "gboolean gtk_widget_is_focus(GtkWidget* widget)"
  s7_pointer widget;
  widget = s7_car(args);
  if (!s7_is_c_pointer_of_type(widget, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_widget_is_focus", 1, widget, "GtkWidget*");
  return(s7_make_boolean(sc, gtk_widget_is_focus((GtkWidget*)s7_c_pointer(widget))));
}

static s7_pointer lg_gtk_widget_set_name(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_set_name "void gtk_widget_set_name(GtkWidget* widget, gchar* name)"
  s7_pointer _p;
  s7_pointer widget, name;
  _p = args;
  widget = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(widget, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_widget_set_name", 1, widget, "GtkWidget*");
  name = s7_car(_p);
  if (!s7_is_string(name)) s7_wrong_type_arg_error(sc, "gtk_widget_set_name", 2, name, "gchar*");
  gtk_widget_set_name((GtkWidget*)s7_c_pointer(widget), (gchar*)s7_string(name));
  return(lg_false);
}

static s7_pointer lg_gtk_widget_get_name(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_get_name "gchar* gtk_widget_get_name(GtkWidget* widget)"
  s7_pointer widget;
  widget = s7_car(args);
  if (!s7_is_c_pointer_of_type(widget, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_widget_get_name", 1, widget, "GtkWidget*");
  return(s7_make_string(sc, gtk_widget_get_name((GtkWidget*)s7_c_pointer(widget))));
}

static s7_pointer lg_gtk_widget_set_sensitive(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_set_sensitive "void gtk_widget_set_sensitive(GtkWidget* widget, gboolean sensitive)"
  s7_pointer _p;
  s7_pointer widget, sensitive;
  _p = args;
  widget = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(widget, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_widget_set_sensitive", 1, widget, "GtkWidget*");
  sensitive = s7_car(_p);
  if (!s7_is_boolean(sensitive)) s7_wrong_type_arg_error(sc, "gtk_widget_set_sensitive", 2, sensitive, "gboolean");
  gtk_widget_set_sensitive((GtkWidget*)s7_c_pointer(widget), (gboolean)lg_boolean(sensitive));
  return(lg_false);
}

static s7_pointer lg_gtk_widget_set_parent(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_set_parent "void gtk_widget_set_parent(GtkWidget* widget, GtkWidget* parent)"
  s7_pointer _p;
  s7_pointer widget, parent;
  _p = args;
  widget = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(widget, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_widget_set_parent", 1, widget, "GtkWidget*");
  parent = s7_car(_p);
  if (!s7_is_c_pointer_of_type(parent, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_widget_set_parent", 2, parent, "GtkWidget*");
  gtk_widget_set_parent((GtkWidget*)s7_c_pointer(widget), (GtkWidget*)s7_c_pointer(parent));
  return(lg_false);
}

static s7_pointer lg_gtk_widget_set_child_visible(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_set_child_visible "void gtk_widget_set_child_visible(GtkWidget* widget, gboolean is_visible)"
  s7_pointer _p;
  s7_pointer widget, is_visible;
  _p = args;
  widget = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(widget, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_widget_set_child_visible", 1, widget, "GtkWidget*");
  is_visible = s7_car(_p);
  if (!s7_is_boolean(is_visible)) s7_wrong_type_arg_error(sc, "gtk_widget_set_child_visible", 2, is_visible, "gboolean");
  gtk_widget_set_child_visible((GtkWidget*)s7_c_pointer(widget), (gboolean)lg_boolean(is_visible));
  return(lg_false);
}

static s7_pointer lg_gtk_widget_get_child_visible(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_get_child_visible "gboolean gtk_widget_get_child_visible(GtkWidget* widget)"
  s7_pointer widget;
  widget = s7_car(args);
  if (!s7_is_c_pointer_of_type(widget, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_widget_get_child_visible", 1, widget, "GtkWidget*");
  return(s7_make_boolean(sc, gtk_widget_get_child_visible((GtkWidget*)s7_c_pointer(widget))));
}

static s7_pointer lg_gtk_widget_get_parent(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_get_parent "GtkWidget* gtk_widget_get_parent(GtkWidget* widget)"
  s7_pointer widget;
  widget = s7_car(args);
  if (!s7_is_c_pointer_of_type(widget, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_widget_get_parent", 1, widget, "GtkWidget*");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_widget_get_parent((GtkWidget*)s7_c_pointer(widget))));
}

static s7_pointer lg_gtk_widget_child_focus(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_child_focus "gboolean gtk_widget_child_focus(GtkWidget* widget, GtkDirectionType direction)"
  s7_pointer _p;
  s7_pointer widget, direction;
  _p = args;
  widget = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(widget, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_widget_child_focus", 1, widget, "GtkWidget*");
  direction = s7_car(_p);
  if (!s7_is_integer(direction)) s7_wrong_type_arg_error(sc, "gtk_widget_child_focus", 2, direction, "GtkDirectionType");
  return(s7_make_boolean(sc, gtk_widget_child_focus((GtkWidget*)s7_c_pointer(widget), (GtkDirectionType)s7_integer(direction))));
}

static s7_pointer lg_gtk_widget_set_size_request(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_set_size_request "void gtk_widget_set_size_request(GtkWidget* widget, gint width, \
gint height)"
  s7_pointer _p;
  s7_pointer widget, width, height;
  _p = args;
  widget = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(widget, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_widget_set_size_request", 1, widget, "GtkWidget*");
  width = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(width)) s7_wrong_type_arg_error(sc, "gtk_widget_set_size_request", 2, width, "gint");
  height = s7_car(_p);
  if (!s7_is_integer(height)) s7_wrong_type_arg_error(sc, "gtk_widget_set_size_request", 3, height, "gint");
  gtk_widget_set_size_request((GtkWidget*)s7_c_pointer(widget), (gint)s7_integer(width), (gint)s7_integer(height));
  return(lg_false);
}

static s7_pointer lg_gtk_widget_get_size_request(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_get_size_request "void gtk_widget_get_size_request(GtkWidget* widget, gint* [width], \
gint* [height])"
  s7_pointer _p;
  s7_pointer widget;
  gint ref_width;
  gint ref_height;
  _p = args;
  widget = s7_car(_p);
  if (!s7_is_c_pointer_of_type(widget, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_widget_get_size_request", 1, widget, "GtkWidget*");
  gtk_widget_get_size_request((GtkWidget*)s7_c_pointer(widget), &ref_width, &ref_height);
    return(s7_list(sc, 2, s7_make_integer(sc, ref_width), s7_make_integer(sc, ref_height)));
}

static s7_pointer lg_gtk_widget_get_ancestor(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_get_ancestor "GtkWidget* gtk_widget_get_ancestor(GtkWidget* widget, GType widget_type)"
  s7_pointer _p;
  s7_pointer widget, widget_type;
  _p = args;
  widget = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(widget, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_widget_get_ancestor", 1, widget, "GtkWidget*");
  widget_type = s7_car(_p);
  if (!s7_is_integer(widget_type)) s7_wrong_type_arg_error(sc, "gtk_widget_get_ancestor", 2, widget_type, "GType");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_widget_get_ancestor((GtkWidget*)s7_c_pointer(widget), (GType)s7_integer(widget_type))));
}

static s7_pointer lg_gtk_widget_get_settings(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_get_settings "GtkSettings* gtk_widget_get_settings(GtkWidget* widget)"
  s7_pointer widget;
  widget = s7_car(args);
  if (!s7_is_c_pointer_of_type(widget, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_widget_get_settings", 1, widget, "GtkWidget*");
  return(lg_make_c_pointer_with_type(sc, GtkSettings__sym, gtk_widget_get_settings((GtkWidget*)s7_c_pointer(widget))));
}

static s7_pointer lg_gtk_widget_get_accessible(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_get_accessible "AtkObject* gtk_widget_get_accessible(GtkWidget* widget)"
  s7_pointer widget;
  widget = s7_car(args);
  if (!s7_is_c_pointer_of_type(widget, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_widget_get_accessible", 1, widget, "GtkWidget*");
  return(lg_make_c_pointer_with_type(sc, AtkObject__sym, gtk_widget_get_accessible((GtkWidget*)s7_c_pointer(widget))));
}

static s7_pointer lg_gtk_widget_is_ancestor(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_is_ancestor "gboolean gtk_widget_is_ancestor(GtkWidget* widget, GtkWidget* ancestor)"
  s7_pointer _p;
  s7_pointer widget, ancestor;
  _p = args;
  widget = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(widget, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_widget_is_ancestor", 1, widget, "GtkWidget*");
  ancestor = s7_car(_p);
  if (!s7_is_c_pointer_of_type(ancestor, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_widget_is_ancestor", 2, ancestor, "GtkWidget*");
  return(s7_make_boolean(sc, gtk_widget_is_ancestor((GtkWidget*)s7_c_pointer(widget), (GtkWidget*)s7_c_pointer(ancestor))));
}

static s7_pointer lg_gtk_widget_create_pango_context(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_create_pango_context "PangoContext* gtk_widget_create_pango_context(GtkWidget* widget)"
  s7_pointer widget;
  widget = s7_car(args);
  if (!s7_is_c_pointer_of_type(widget, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_widget_create_pango_context", 1, widget, "GtkWidget*");
  return(lg_make_c_pointer_with_type(sc, PangoContext__sym, gtk_widget_create_pango_context((GtkWidget*)s7_c_pointer(widget))));
}

static s7_pointer lg_gtk_widget_get_pango_context(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_get_pango_context "PangoContext* gtk_widget_get_pango_context(GtkWidget* widget)"
  s7_pointer widget;
  widget = s7_car(args);
  if (!s7_is_c_pointer_of_type(widget, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_widget_get_pango_context", 1, widget, "GtkWidget*");
  return(lg_make_c_pointer_with_type(sc, PangoContext__sym, gtk_widget_get_pango_context((GtkWidget*)s7_c_pointer(widget))));
}

static s7_pointer lg_gtk_widget_create_pango_layout(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_create_pango_layout "PangoLayout* gtk_widget_create_pango_layout(GtkWidget* widget, \
gchar* text)"
  s7_pointer _p;
  s7_pointer widget, text;
  _p = args;
  widget = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(widget, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_widget_create_pango_layout", 1, widget, "GtkWidget*");
  text = s7_car(_p);
  if (!s7_is_string(text)) s7_wrong_type_arg_error(sc, "gtk_widget_create_pango_layout", 2, text, "gchar*");
  return(lg_make_c_pointer_with_type(sc, PangoLayout__sym, gtk_widget_create_pango_layout((GtkWidget*)s7_c_pointer(widget), (gchar*)s7_string(text))));
}

static s7_pointer lg_gtk_widget_set_direction(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_set_direction "void gtk_widget_set_direction(GtkWidget* widget, GtkTextDirection dir)"
  s7_pointer _p;
  s7_pointer widget, dir;
  _p = args;
  widget = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(widget, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_widget_set_direction", 1, widget, "GtkWidget*");
  dir = s7_car(_p);
  if (!s7_is_integer(dir)) s7_wrong_type_arg_error(sc, "gtk_widget_set_direction", 2, dir, "GtkTextDirection");
  gtk_widget_set_direction((GtkWidget*)s7_c_pointer(widget), (GtkTextDirection)s7_integer(dir));
  return(lg_false);
}

static s7_pointer lg_gtk_widget_get_direction(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_get_direction "GtkTextDirection gtk_widget_get_direction(GtkWidget* widget)"
  s7_pointer widget;
  widget = s7_car(args);
  if (!s7_is_c_pointer_of_type(widget, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_widget_get_direction", 1, widget, "GtkWidget*");
  return(s7_make_integer(sc, gtk_widget_get_direction((GtkWidget*)s7_c_pointer(widget))));
}

static s7_pointer lg_gtk_widget_set_default_direction(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_set_default_direction "void gtk_widget_set_default_direction(GtkTextDirection dir)"
  s7_pointer dir;
  dir = s7_car(args);
  if (!s7_is_integer(dir)) s7_wrong_type_arg_error(sc, "gtk_widget_set_default_direction", 1, dir, "GtkTextDirection");
  gtk_widget_set_default_direction((GtkTextDirection)s7_integer(dir));
  return(lg_false);
}

static s7_pointer lg_gtk_widget_get_default_direction(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_get_default_direction "GtkTextDirection gtk_widget_get_default_direction( void)"
  return(s7_make_integer(sc, gtk_widget_get_default_direction()));
}

static s7_pointer lg_gtk_window_is_active(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_window_is_active "gboolean gtk_window_is_active(GtkWindow* window)"
  s7_pointer window;
  window = s7_car(args);
  if (!s7_is_c_pointer_of_type(window, GtkWindow__sym)) s7_wrong_type_arg_error(sc, "gtk_window_is_active", 1, window, "GtkWindow*");
  return(s7_make_boolean(sc, gtk_window_is_active((GtkWindow*)s7_c_pointer(window))));
}

static s7_pointer lg_gtk_window_set_title(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_window_set_title "void gtk_window_set_title(GtkWindow* window, gchar* title)"
  s7_pointer _p;
  s7_pointer window, title;
  _p = args;
  window = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(window, GtkWindow__sym)) s7_wrong_type_arg_error(sc, "gtk_window_set_title", 1, window, "GtkWindow*");
  title = s7_car(_p);
  if (!s7_is_string(title)) s7_wrong_type_arg_error(sc, "gtk_window_set_title", 2, title, "gchar*");
  gtk_window_set_title((GtkWindow*)s7_c_pointer(window), (gchar*)s7_string(title));
  return(lg_false);
}

static s7_pointer lg_gtk_window_set_auto_startup_notification(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_window_set_auto_startup_notification "void gtk_window_set_auto_startup_notification(gboolean setting)"
  s7_pointer setting;
  setting = s7_car(args);
  if (!s7_is_boolean(setting)) s7_wrong_type_arg_error(sc, "gtk_window_set_auto_startup_notification", 1, setting, "gboolean");
  gtk_window_set_auto_startup_notification((gboolean)lg_boolean(setting));
  return(lg_false);
}

static s7_pointer lg_gtk_window_get_title(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_window_get_title "gchar* gtk_window_get_title(GtkWindow* window)"
  s7_pointer window;
  window = s7_car(args);
  if (!s7_is_c_pointer_of_type(window, GtkWindow__sym)) s7_wrong_type_arg_error(sc, "gtk_window_get_title", 1, window, "GtkWindow*");
  return(s7_make_string(sc, gtk_window_get_title((GtkWindow*)s7_c_pointer(window))));
}

static s7_pointer lg_gtk_window_set_focus(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_window_set_focus "void gtk_window_set_focus(GtkWindow* window, GtkWidget* focus)"
  s7_pointer _p;
  s7_pointer window, focus;
  _p = args;
  window = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(window, GtkWindow__sym)) s7_wrong_type_arg_error(sc, "gtk_window_set_focus", 1, window, "GtkWindow*");
  focus = s7_car(_p);
  if ((!s7_is_c_pointer_of_type(focus, GtkWidget__sym)) && (focus != lg_false)) s7_wrong_type_arg_error(sc, "gtk_window_set_focus", 2, focus, "GtkWidget*");
  gtk_window_set_focus((GtkWindow*)s7_c_pointer(window), (GtkWidget*)s7_c_pointer(focus));
  return(lg_false);
}

static s7_pointer lg_gtk_window_get_focus(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_window_get_focus "GtkWidget* gtk_window_get_focus(GtkWindow* window)"
  s7_pointer window;
  window = s7_car(args);
  if (!s7_is_c_pointer_of_type(window, GtkWindow__sym)) s7_wrong_type_arg_error(sc, "gtk_window_get_focus", 1, window, "GtkWindow*");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_window_get_focus((GtkWindow*)s7_c_pointer(window))));
}

static s7_pointer lg_gtk_window_set_transient_for(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_window_set_transient_for "void gtk_window_set_transient_for(GtkWindow* window, GtkWindow* parent)"
  s7_pointer _p;
  s7_pointer window, parent;
  _p = args;
  window = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(window, GtkWindow__sym)) s7_wrong_type_arg_error(sc, "gtk_window_set_transient_for", 1, window, "GtkWindow*");
  parent = s7_car(_p);
  if ((!s7_is_c_pointer_of_type(parent, GtkWindow__sym)) && (parent != lg_false)) s7_wrong_type_arg_error(sc, "gtk_window_set_transient_for", 2, parent, "GtkWindow*");
  gtk_window_set_transient_for((GtkWindow*)s7_c_pointer(window), (GtkWindow*)s7_c_pointer(parent));
  return(lg_false);
}

static s7_pointer lg_gtk_window_get_transient_for(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_window_get_transient_for "GtkWindow* gtk_window_get_transient_for(GtkWindow* window)"
  s7_pointer window;
  window = s7_car(args);
  if (!s7_is_c_pointer_of_type(window, GtkWindow__sym)) s7_wrong_type_arg_error(sc, "gtk_window_get_transient_for", 1, window, "GtkWindow*");
  return(lg_make_c_pointer_with_type(sc, GtkWindow__sym, gtk_window_get_transient_for((GtkWindow*)s7_c_pointer(window))));
}

static s7_pointer lg_gtk_window_set_destroy_with_parent(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_window_set_destroy_with_parent "void gtk_window_set_destroy_with_parent(GtkWindow* window, \
gboolean setting)"
  s7_pointer _p;
  s7_pointer window, setting;
  _p = args;
  window = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(window, GtkWindow__sym)) s7_wrong_type_arg_error(sc, "gtk_window_set_destroy_with_parent", 1, window, "GtkWindow*");
  setting = s7_car(_p);
  if (!s7_is_boolean(setting)) s7_wrong_type_arg_error(sc, "gtk_window_set_destroy_with_parent", 2, setting, "gboolean");
  gtk_window_set_destroy_with_parent((GtkWindow*)s7_c_pointer(window), (gboolean)lg_boolean(setting));
  return(lg_false);
}

static s7_pointer lg_gtk_window_get_destroy_with_parent(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_window_get_destroy_with_parent "gboolean gtk_window_get_destroy_with_parent(GtkWindow* window)"
  s7_pointer window;
  window = s7_car(args);
  if (!s7_is_c_pointer_of_type(window, GtkWindow__sym)) s7_wrong_type_arg_error(sc, "gtk_window_get_destroy_with_parent", 1, window, "GtkWindow*");
  return(s7_make_boolean(sc, gtk_window_get_destroy_with_parent((GtkWindow*)s7_c_pointer(window))));
}

static s7_pointer lg_gtk_window_set_resizable(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_window_set_resizable "void gtk_window_set_resizable(GtkWindow* window, gboolean resizable)"
  s7_pointer _p;
  s7_pointer window, resizable;
  _p = args;
  window = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(window, GtkWindow__sym)) s7_wrong_type_arg_error(sc, "gtk_window_set_resizable", 1, window, "GtkWindow*");
  resizable = s7_car(_p);
  if (!s7_is_boolean(resizable)) s7_wrong_type_arg_error(sc, "gtk_window_set_resizable", 2, resizable, "gboolean");
  gtk_window_set_resizable((GtkWindow*)s7_c_pointer(window), (gboolean)lg_boolean(resizable));
  return(lg_false);
}

static s7_pointer lg_gtk_window_get_resizable(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_window_get_resizable "gboolean gtk_window_get_resizable(GtkWindow* window)"
  s7_pointer window;
  window = s7_car(args);
  if (!s7_is_c_pointer_of_type(window, GtkWindow__sym)) s7_wrong_type_arg_error(sc, "gtk_window_get_resizable", 1, window, "GtkWindow*");
  return(s7_make_boolean(sc, gtk_window_get_resizable((GtkWindow*)s7_c_pointer(window))));
}

static s7_pointer lg_gtk_window_set_decorated(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_window_set_decorated "void gtk_window_set_decorated(GtkWindow* window, gboolean setting)"
  s7_pointer _p;
  s7_pointer window, setting;
  _p = args;
  window = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(window, GtkWindow__sym)) s7_wrong_type_arg_error(sc, "gtk_window_set_decorated", 1, window, "GtkWindow*");
  setting = s7_car(_p);
  if (!s7_is_boolean(setting)) s7_wrong_type_arg_error(sc, "gtk_window_set_decorated", 2, setting, "gboolean");
  gtk_window_set_decorated((GtkWindow*)s7_c_pointer(window), (gboolean)lg_boolean(setting));
  return(lg_false);
}

static s7_pointer lg_gtk_window_get_decorated(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_window_get_decorated "gboolean gtk_window_get_decorated(GtkWindow* window)"
  s7_pointer window;
  window = s7_car(args);
  if (!s7_is_c_pointer_of_type(window, GtkWindow__sym)) s7_wrong_type_arg_error(sc, "gtk_window_get_decorated", 1, window, "GtkWindow*");
  return(s7_make_boolean(sc, gtk_window_get_decorated((GtkWindow*)s7_c_pointer(window))));
}

static s7_pointer lg_gtk_window_set_modal(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_window_set_modal "void gtk_window_set_modal(GtkWindow* window, gboolean modal)"
  s7_pointer _p;
  s7_pointer window, modal;
  _p = args;
  window = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(window, GtkWindow__sym)) s7_wrong_type_arg_error(sc, "gtk_window_set_modal", 1, window, "GtkWindow*");
  modal = s7_car(_p);
  if (!s7_is_boolean(modal)) s7_wrong_type_arg_error(sc, "gtk_window_set_modal", 2, modal, "gboolean");
  gtk_window_set_modal((GtkWindow*)s7_c_pointer(window), (gboolean)lg_boolean(modal));
  return(lg_false);
}

static s7_pointer lg_gtk_window_get_modal(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_window_get_modal "gboolean gtk_window_get_modal(GtkWindow* window)"
  s7_pointer window;
  window = s7_car(args);
  if (!s7_is_c_pointer_of_type(window, GtkWindow__sym)) s7_wrong_type_arg_error(sc, "gtk_window_get_modal", 1, window, "GtkWindow*");
  return(s7_make_boolean(sc, gtk_window_get_modal((GtkWindow*)s7_c_pointer(window))));
}

static s7_pointer lg_gtk_window_list_toplevels(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_window_list_toplevels "GList* gtk_window_list_toplevels( void)"
  return(lg_make_c_pointer_with_type(sc, GList__sym, gtk_window_list_toplevels()));
}

static s7_pointer lg_gtk_window_present(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_window_present "void gtk_window_present(GtkWindow* window)"
  s7_pointer window;
  window = s7_car(args);
  if (!s7_is_c_pointer_of_type(window, GtkWindow__sym)) s7_wrong_type_arg_error(sc, "gtk_window_present", 1, window, "GtkWindow*");
  gtk_window_present((GtkWindow*)s7_c_pointer(window));
  return(lg_false);
}

static s7_pointer lg_gtk_window_maximize(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_window_maximize "void gtk_window_maximize(GtkWindow* window)"
  s7_pointer window;
  window = s7_car(args);
  if (!s7_is_c_pointer_of_type(window, GtkWindow__sym)) s7_wrong_type_arg_error(sc, "gtk_window_maximize", 1, window, "GtkWindow*");
  gtk_window_maximize((GtkWindow*)s7_c_pointer(window));
  return(lg_false);
}

static s7_pointer lg_gtk_window_unmaximize(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_window_unmaximize "void gtk_window_unmaximize(GtkWindow* window)"
  s7_pointer window;
  window = s7_car(args);
  if (!s7_is_c_pointer_of_type(window, GtkWindow__sym)) s7_wrong_type_arg_error(sc, "gtk_window_unmaximize", 1, window, "GtkWindow*");
  gtk_window_unmaximize((GtkWindow*)s7_c_pointer(window));
  return(lg_false);
}

static s7_pointer lg_gtk_window_set_default_size(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_window_set_default_size "void gtk_window_set_default_size(GtkWindow* window, gint width, \
gint height)"
  s7_pointer _p;
  s7_pointer window, width, height;
  _p = args;
  window = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(window, GtkWindow__sym)) s7_wrong_type_arg_error(sc, "gtk_window_set_default_size", 1, window, "GtkWindow*");
  width = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(width)) s7_wrong_type_arg_error(sc, "gtk_window_set_default_size", 2, width, "gint");
  height = s7_car(_p);
  if (!s7_is_integer(height)) s7_wrong_type_arg_error(sc, "gtk_window_set_default_size", 3, height, "gint");
  gtk_window_set_default_size((GtkWindow*)s7_c_pointer(window), (gint)s7_integer(width), (gint)s7_integer(height));
  return(lg_false);
}

static s7_pointer lg_gtk_window_get_default_size(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_window_get_default_size "void gtk_window_get_default_size(GtkWindow* window, gint* [width], \
gint* [height])"
  s7_pointer _p;
  s7_pointer window;
  gint ref_width;
  gint ref_height;
  _p = args;
  window = s7_car(_p);
  if (!s7_is_c_pointer_of_type(window, GtkWindow__sym)) s7_wrong_type_arg_error(sc, "gtk_window_get_default_size", 1, window, "GtkWindow*");
  gtk_window_get_default_size((GtkWindow*)s7_c_pointer(window), &ref_width, &ref_height);
    return(s7_list(sc, 2, s7_make_integer(sc, ref_width), s7_make_integer(sc, ref_height)));
}

static s7_pointer lg_gtk_window_resize(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_window_resize "void gtk_window_resize(GtkWindow* window, gint width, gint height)"
  s7_pointer _p;
  s7_pointer window, width, height;
  _p = args;
  window = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(window, GtkWindow__sym)) s7_wrong_type_arg_error(sc, "gtk_window_resize", 1, window, "GtkWindow*");
  width = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(width)) s7_wrong_type_arg_error(sc, "gtk_window_resize", 2, width, "gint");
  height = s7_car(_p);
  if (!s7_is_integer(height)) s7_wrong_type_arg_error(sc, "gtk_window_resize", 3, height, "gint");
  gtk_window_resize((GtkWindow*)s7_c_pointer(window), (gint)s7_integer(width), (gint)s7_integer(height));
  return(lg_false);
}

static s7_pointer lg_gtk_window_get_size(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_window_get_size "void gtk_window_get_size(GtkWindow* window, gint* [width], gint* [height])"
  s7_pointer _p;
  s7_pointer window;
  gint ref_width;
  gint ref_height;
  _p = args;
  window = s7_car(_p);
  if (!s7_is_c_pointer_of_type(window, GtkWindow__sym)) s7_wrong_type_arg_error(sc, "gtk_window_get_size", 1, window, "GtkWindow*");
  gtk_window_get_size((GtkWindow*)s7_c_pointer(window), &ref_width, &ref_height);
    return(s7_list(sc, 2, s7_make_integer(sc, ref_width), s7_make_integer(sc, ref_height)));
}

static s7_pointer lg_pango_color_copy(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_color_copy "PangoColor* pango_color_copy(PangoColor* src)"
  s7_pointer src;
  src = s7_car(args);
  if (!s7_is_c_pointer_of_type(src, PangoColor__sym)) s7_wrong_type_arg_error(sc, "pango_color_copy", 1, src, "PangoColor*");
  return(lg_make_c_pointer_with_type(sc, PangoColor__sym, pango_color_copy((PangoColor*)s7_c_pointer(src))));
}

static s7_pointer lg_pango_color_free(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_color_free "void pango_color_free(PangoColor* color)"
  s7_pointer color;
  color = s7_car(args);
  if (!s7_is_c_pointer_of_type(color, PangoColor__sym)) s7_wrong_type_arg_error(sc, "pango_color_free", 1, color, "PangoColor*");
  pango_color_free((PangoColor*)s7_c_pointer(color));
  return(lg_false);
}

static s7_pointer lg_pango_color_parse(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_color_parse "gboolean pango_color_parse(PangoColor* color, char* spec)"
  s7_pointer _p;
  s7_pointer color, spec;
  _p = args;
  color = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(color, PangoColor__sym)) s7_wrong_type_arg_error(sc, "pango_color_parse", 1, color, "PangoColor*");
  spec = s7_car(_p);
  if (!s7_is_string(spec)) s7_wrong_type_arg_error(sc, "pango_color_parse", 2, spec, "char*");
  return(s7_make_boolean(sc, pango_color_parse((PangoColor*)s7_c_pointer(color), (char*)s7_string(spec))));
}

static s7_pointer lg_pango_attr_type_register(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_type_register "PangoAttrType pango_attr_type_register(gchar* name)"
  s7_pointer name;
  name = s7_car(args);
  if (!s7_is_string(name)) s7_wrong_type_arg_error(sc, "pango_attr_type_register", 1, name, "gchar*");
  return(s7_make_integer(sc, pango_attr_type_register((gchar*)s7_string(name))));
}

static s7_pointer lg_pango_attribute_copy(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attribute_copy "PangoAttribute* pango_attribute_copy(PangoAttribute* attr)"
  s7_pointer attr;
  attr = s7_car(args);
  if (!s7_is_c_pointer_of_type(attr, PangoAttribute__sym)) s7_wrong_type_arg_error(sc, "pango_attribute_copy", 1, attr, "PangoAttribute*");
  return(lg_make_c_pointer_with_type(sc, PangoAttribute__sym, pango_attribute_copy((PangoAttribute*)s7_c_pointer(attr))));
}

static s7_pointer lg_pango_attribute_destroy(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attribute_destroy "void pango_attribute_destroy(PangoAttribute* attr)"
  s7_pointer attr;
  attr = s7_car(args);
  if (!s7_is_c_pointer_of_type(attr, PangoAttribute__sym)) s7_wrong_type_arg_error(sc, "pango_attribute_destroy", 1, attr, "PangoAttribute*");
  pango_attribute_destroy((PangoAttribute*)s7_c_pointer(attr));
  return(lg_false);
}

static s7_pointer lg_pango_attribute_equal(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attribute_equal "gboolean pango_attribute_equal(PangoAttribute* attr1, PangoAttribute* attr2)"
  s7_pointer _p;
  s7_pointer attr1, attr2;
  _p = args;
  attr1 = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(attr1, PangoAttribute__sym)) s7_wrong_type_arg_error(sc, "pango_attribute_equal", 1, attr1, "PangoAttribute*");
  attr2 = s7_car(_p);
  if (!s7_is_c_pointer_of_type(attr2, PangoAttribute__sym)) s7_wrong_type_arg_error(sc, "pango_attribute_equal", 2, attr2, "PangoAttribute*");
  return(s7_make_boolean(sc, pango_attribute_equal((PangoAttribute*)s7_c_pointer(attr1), (PangoAttribute*)s7_c_pointer(attr2))));
}

static s7_pointer lg_pango_attr_language_new(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_language_new "PangoAttribute* pango_attr_language_new(PangoLanguage* language)"
  s7_pointer language;
  language = s7_car(args);
  if (!s7_is_c_pointer_of_type(language, PangoLanguage__sym)) s7_wrong_type_arg_error(sc, "pango_attr_language_new", 1, language, "PangoLanguage*");
  return(lg_make_c_pointer_with_type(sc, PangoAttribute__sym, pango_attr_language_new((PangoLanguage*)s7_c_pointer(language))));
}

static s7_pointer lg_pango_attr_family_new(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_family_new "PangoAttribute* pango_attr_family_new(char* family)"
  s7_pointer family;
  family = s7_car(args);
  if (!s7_is_string(family)) s7_wrong_type_arg_error(sc, "pango_attr_family_new", 1, family, "char*");
  return(lg_make_c_pointer_with_type(sc, PangoAttribute__sym, pango_attr_family_new((char*)s7_string(family))));
}

static s7_pointer lg_pango_attr_foreground_new(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_foreground_new "PangoAttribute* pango_attr_foreground_new(guint16 red, guint16 green, \
guint16 blue)"
  s7_pointer _p;
  s7_pointer red, green, blue;
  _p = args;
  red = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(red)) s7_wrong_type_arg_error(sc, "pango_attr_foreground_new", 1, red, "guint16");
  green = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(green)) s7_wrong_type_arg_error(sc, "pango_attr_foreground_new", 2, green, "guint16");
  blue = s7_car(_p);
  if (!s7_is_integer(blue)) s7_wrong_type_arg_error(sc, "pango_attr_foreground_new", 3, blue, "guint16");
  return(lg_make_c_pointer_with_type(sc, PangoAttribute__sym, pango_attr_foreground_new((guint16)s7_integer(red), (guint16)s7_integer(green), (guint16)s7_integer(blue))));
}

static s7_pointer lg_pango_attr_background_new(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_background_new "PangoAttribute* pango_attr_background_new(guint16 red, guint16 green, \
guint16 blue)"
  s7_pointer _p;
  s7_pointer red, green, blue;
  _p = args;
  red = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(red)) s7_wrong_type_arg_error(sc, "pango_attr_background_new", 1, red, "guint16");
  green = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(green)) s7_wrong_type_arg_error(sc, "pango_attr_background_new", 2, green, "guint16");
  blue = s7_car(_p);
  if (!s7_is_integer(blue)) s7_wrong_type_arg_error(sc, "pango_attr_background_new", 3, blue, "guint16");
  return(lg_make_c_pointer_with_type(sc, PangoAttribute__sym, pango_attr_background_new((guint16)s7_integer(red), (guint16)s7_integer(green), (guint16)s7_integer(blue))));
}

static s7_pointer lg_pango_attr_size_new(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_size_new "PangoAttribute* pango_attr_size_new(int size)"
  s7_pointer size;
  size = s7_car(args);
  if (!s7_is_integer(size)) s7_wrong_type_arg_error(sc, "pango_attr_size_new", 1, size, "int");
  return(lg_make_c_pointer_with_type(sc, PangoAttribute__sym, pango_attr_size_new((int)s7_integer(size))));
}

static s7_pointer lg_pango_attr_style_new(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_style_new "PangoAttribute* pango_attr_style_new(PangoStyle style)"
  s7_pointer style;
  style = s7_car(args);
  if (!s7_is_integer(style)) s7_wrong_type_arg_error(sc, "pango_attr_style_new", 1, style, "PangoStyle");
  return(lg_make_c_pointer_with_type(sc, PangoAttribute__sym, pango_attr_style_new((PangoStyle)s7_integer(style))));
}

static s7_pointer lg_pango_attr_weight_new(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_weight_new "PangoAttribute* pango_attr_weight_new(PangoWeight weight)"
  s7_pointer weight;
  weight = s7_car(args);
  if (!s7_is_integer(weight)) s7_wrong_type_arg_error(sc, "pango_attr_weight_new", 1, weight, "PangoWeight");
  return(lg_make_c_pointer_with_type(sc, PangoAttribute__sym, pango_attr_weight_new((PangoWeight)s7_integer(weight))));
}

static s7_pointer lg_pango_attr_variant_new(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_variant_new "PangoAttribute* pango_attr_variant_new(PangoVariant variant)"
  s7_pointer variant;
  variant = s7_car(args);
  if (!s7_is_integer(variant)) s7_wrong_type_arg_error(sc, "pango_attr_variant_new", 1, variant, "PangoVariant");
  return(lg_make_c_pointer_with_type(sc, PangoAttribute__sym, pango_attr_variant_new((PangoVariant)s7_integer(variant))));
}

static s7_pointer lg_pango_attr_stretch_new(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_stretch_new "PangoAttribute* pango_attr_stretch_new(PangoStretch stretch)"
  s7_pointer stretch;
  stretch = s7_car(args);
  if (!s7_is_integer(stretch)) s7_wrong_type_arg_error(sc, "pango_attr_stretch_new", 1, stretch, "PangoStretch");
  return(lg_make_c_pointer_with_type(sc, PangoAttribute__sym, pango_attr_stretch_new((PangoStretch)s7_integer(stretch))));
}

static s7_pointer lg_pango_attr_font_desc_new(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_font_desc_new "PangoAttribute* pango_attr_font_desc_new(PangoFontDescription* desc)"
  s7_pointer desc;
  desc = s7_car(args);
  if (!s7_is_c_pointer_of_type(desc, PangoFontDescription__sym)) s7_wrong_type_arg_error(sc, "pango_attr_font_desc_new", 1, desc, "PangoFontDescription*");
  return(lg_make_c_pointer_with_type(sc, PangoAttribute__sym, pango_attr_font_desc_new((PangoFontDescription*)s7_c_pointer(desc))));
}

static s7_pointer lg_pango_attr_underline_new(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_underline_new "PangoAttribute* pango_attr_underline_new(PangoUnderline underline)"
  s7_pointer underline;
  underline = s7_car(args);
  if (!s7_is_integer(underline)) s7_wrong_type_arg_error(sc, "pango_attr_underline_new", 1, underline, "PangoUnderline");
  return(lg_make_c_pointer_with_type(sc, PangoAttribute__sym, pango_attr_underline_new((PangoUnderline)s7_integer(underline))));
}

static s7_pointer lg_pango_attr_strikethrough_new(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_strikethrough_new "PangoAttribute* pango_attr_strikethrough_new(gboolean strikethrough)"
  s7_pointer strikethrough;
  strikethrough = s7_car(args);
  if (!s7_is_boolean(strikethrough)) s7_wrong_type_arg_error(sc, "pango_attr_strikethrough_new", 1, strikethrough, "gboolean");
  return(lg_make_c_pointer_with_type(sc, PangoAttribute__sym, pango_attr_strikethrough_new((gboolean)lg_boolean(strikethrough))));
}

static s7_pointer lg_pango_attr_rise_new(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_rise_new "PangoAttribute* pango_attr_rise_new(int rise)"
  s7_pointer rise;
  rise = s7_car(args);
  if (!s7_is_integer(rise)) s7_wrong_type_arg_error(sc, "pango_attr_rise_new", 1, rise, "int");
  return(lg_make_c_pointer_with_type(sc, PangoAttribute__sym, pango_attr_rise_new((int)s7_integer(rise))));
}

static s7_pointer lg_pango_attr_shape_new(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_shape_new "PangoAttribute* pango_attr_shape_new(PangoRectangle* ink_rect, PangoRectangle* logical_rect)"
  s7_pointer _p;
  s7_pointer ink_rect, logical_rect;
  _p = args;
  ink_rect = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(ink_rect, PangoRectangle__sym)) s7_wrong_type_arg_error(sc, "pango_attr_shape_new", 1, ink_rect, "PangoRectangle*");
  logical_rect = s7_car(_p);
  if (!s7_is_c_pointer_of_type(logical_rect, PangoRectangle__sym)) s7_wrong_type_arg_error(sc, "pango_attr_shape_new", 2, logical_rect, "PangoRectangle*");
  return(lg_make_c_pointer_with_type(sc, PangoAttribute__sym, pango_attr_shape_new((PangoRectangle*)s7_c_pointer(ink_rect), (PangoRectangle*)s7_c_pointer(logical_rect))));
}

static s7_pointer lg_pango_attr_scale_new(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_scale_new "PangoAttribute* pango_attr_scale_new(double scale_factor)"
  s7_pointer scale_factor;
  scale_factor = s7_car(args);
  if (!s7_is_real(scale_factor)) s7_wrong_type_arg_error(sc, "pango_attr_scale_new", 1, scale_factor, "double");
  return(lg_make_c_pointer_with_type(sc, PangoAttribute__sym, pango_attr_scale_new((double)s7_real(scale_factor))));
}

static s7_pointer lg_pango_attr_list_new(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_list_new "PangoAttrList* pango_attr_list_new( void)"
  return(lg_make_c_pointer_with_type(sc, PangoAttrList__sym, pango_attr_list_new()));
}

static s7_pointer lg_pango_attr_list_unref(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_list_unref "void pango_attr_list_unref(PangoAttrList* list)"
  s7_pointer list;
  list = s7_car(args);
  if (!s7_is_c_pointer_of_type(list, PangoAttrList__sym)) s7_wrong_type_arg_error(sc, "pango_attr_list_unref", 1, list, "PangoAttrList*");
  pango_attr_list_unref((PangoAttrList*)s7_c_pointer(list));
  return(lg_false);
}

static s7_pointer lg_pango_attr_list_copy(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_list_copy "PangoAttrList* pango_attr_list_copy(PangoAttrList* list)"
  s7_pointer list;
  list = s7_car(args);
  if (!s7_is_c_pointer_of_type(list, PangoAttrList__sym)) s7_wrong_type_arg_error(sc, "pango_attr_list_copy", 1, list, "PangoAttrList*");
  return(lg_make_c_pointer_with_type(sc, PangoAttrList__sym, pango_attr_list_copy((PangoAttrList*)s7_c_pointer(list))));
}

static s7_pointer lg_pango_attr_list_insert(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_list_insert "void pango_attr_list_insert(PangoAttrList* list, PangoAttribute* attr)"
  s7_pointer _p;
  s7_pointer list, attr;
  _p = args;
  list = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(list, PangoAttrList__sym)) s7_wrong_type_arg_error(sc, "pango_attr_list_insert", 1, list, "PangoAttrList*");
  attr = s7_car(_p);
  if (!s7_is_c_pointer_of_type(attr, PangoAttribute__sym)) s7_wrong_type_arg_error(sc, "pango_attr_list_insert", 2, attr, "PangoAttribute*");
  pango_attr_list_insert((PangoAttrList*)s7_c_pointer(list), (PangoAttribute*)s7_c_pointer(attr));
  return(lg_false);
}

static s7_pointer lg_pango_attr_list_insert_before(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_list_insert_before "void pango_attr_list_insert_before(PangoAttrList* list, PangoAttribute* attr)"
  s7_pointer _p;
  s7_pointer list, attr;
  _p = args;
  list = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(list, PangoAttrList__sym)) s7_wrong_type_arg_error(sc, "pango_attr_list_insert_before", 1, list, "PangoAttrList*");
  attr = s7_car(_p);
  if (!s7_is_c_pointer_of_type(attr, PangoAttribute__sym)) s7_wrong_type_arg_error(sc, "pango_attr_list_insert_before", 2, attr, "PangoAttribute*");
  pango_attr_list_insert_before((PangoAttrList*)s7_c_pointer(list), (PangoAttribute*)s7_c_pointer(attr));
  return(lg_false);
}

static s7_pointer lg_pango_attr_list_change(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_list_change "void pango_attr_list_change(PangoAttrList* list, PangoAttribute* attr)"
  s7_pointer _p;
  s7_pointer list, attr;
  _p = args;
  list = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(list, PangoAttrList__sym)) s7_wrong_type_arg_error(sc, "pango_attr_list_change", 1, list, "PangoAttrList*");
  attr = s7_car(_p);
  if (!s7_is_c_pointer_of_type(attr, PangoAttribute__sym)) s7_wrong_type_arg_error(sc, "pango_attr_list_change", 2, attr, "PangoAttribute*");
  pango_attr_list_change((PangoAttrList*)s7_c_pointer(list), (PangoAttribute*)s7_c_pointer(attr));
  return(lg_false);
}

static s7_pointer lg_pango_attr_list_splice(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_list_splice "void pango_attr_list_splice(PangoAttrList* list, PangoAttrList* other, \
gint pos, gint len)"
  s7_pointer _p;
  s7_pointer list, other, pos, len;
  _p = args;
  list = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(list, PangoAttrList__sym)) s7_wrong_type_arg_error(sc, "pango_attr_list_splice", 1, list, "PangoAttrList*");
  other = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(other, PangoAttrList__sym)) s7_wrong_type_arg_error(sc, "pango_attr_list_splice", 2, other, "PangoAttrList*");
  pos = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(pos)) s7_wrong_type_arg_error(sc, "pango_attr_list_splice", 3, pos, "gint");
  len = s7_car(_p);
  if (!s7_is_integer(len)) s7_wrong_type_arg_error(sc, "pango_attr_list_splice", 4, len, "gint");
  pango_attr_list_splice((PangoAttrList*)s7_c_pointer(list), (PangoAttrList*)s7_c_pointer(other), (gint)s7_integer(pos), (gint)s7_integer(len));
  return(lg_false);
}

static s7_pointer lg_pango_attr_list_get_iterator(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_list_get_iterator "PangoAttrIterator* pango_attr_list_get_iterator(PangoAttrList* list)"
  s7_pointer list;
  list = s7_car(args);
  if (!s7_is_c_pointer_of_type(list, PangoAttrList__sym)) s7_wrong_type_arg_error(sc, "pango_attr_list_get_iterator", 1, list, "PangoAttrList*");
  return(lg_make_c_pointer_with_type(sc, PangoAttrIterator__sym, pango_attr_list_get_iterator((PangoAttrList*)s7_c_pointer(list))));
}

static s7_pointer lg_pango_attr_iterator_range(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_iterator_range "void pango_attr_iterator_range(PangoAttrIterator* iterator, gint* [start], \
gint* [end])"
  s7_pointer _p;
  s7_pointer iterator;
  gint ref_start;
  gint ref_end;
  _p = args;
  iterator = s7_car(_p);
  if (!s7_is_c_pointer_of_type(iterator, PangoAttrIterator__sym)) s7_wrong_type_arg_error(sc, "pango_attr_iterator_range", 1, iterator, "PangoAttrIterator*");
  pango_attr_iterator_range((PangoAttrIterator*)s7_c_pointer(iterator), &ref_start, &ref_end);
    return(s7_list(sc, 2, s7_make_integer(sc, ref_start), s7_make_integer(sc, ref_end)));
}

static s7_pointer lg_pango_attr_iterator_next(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_iterator_next "gboolean pango_attr_iterator_next(PangoAttrIterator* iterator)"
  s7_pointer iterator;
  iterator = s7_car(args);
  if (!s7_is_c_pointer_of_type(iterator, PangoAttrIterator__sym)) s7_wrong_type_arg_error(sc, "pango_attr_iterator_next", 1, iterator, "PangoAttrIterator*");
  return(s7_make_boolean(sc, pango_attr_iterator_next((PangoAttrIterator*)s7_c_pointer(iterator))));
}

static s7_pointer lg_pango_attr_iterator_copy(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_iterator_copy "PangoAttrIterator* pango_attr_iterator_copy(PangoAttrIterator* iterator)"
  s7_pointer iterator;
  iterator = s7_car(args);
  if (!s7_is_c_pointer_of_type(iterator, PangoAttrIterator__sym)) s7_wrong_type_arg_error(sc, "pango_attr_iterator_copy", 1, iterator, "PangoAttrIterator*");
  return(lg_make_c_pointer_with_type(sc, PangoAttrIterator__sym, pango_attr_iterator_copy((PangoAttrIterator*)s7_c_pointer(iterator))));
}

static s7_pointer lg_pango_attr_iterator_destroy(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_iterator_destroy "void pango_attr_iterator_destroy(PangoAttrIterator* iterator)"
  s7_pointer iterator;
  iterator = s7_car(args);
  if (!s7_is_c_pointer_of_type(iterator, PangoAttrIterator__sym)) s7_wrong_type_arg_error(sc, "pango_attr_iterator_destroy", 1, iterator, "PangoAttrIterator*");
  pango_attr_iterator_destroy((PangoAttrIterator*)s7_c_pointer(iterator));
  return(lg_false);
}

static s7_pointer lg_pango_attr_iterator_get(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_iterator_get "PangoAttribute* pango_attr_iterator_get(PangoAttrIterator* iterator, \
PangoAttrType type)"
  s7_pointer _p;
  s7_pointer iterator, type;
  _p = args;
  iterator = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iterator, PangoAttrIterator__sym)) s7_wrong_type_arg_error(sc, "pango_attr_iterator_get", 1, iterator, "PangoAttrIterator*");
  type = s7_car(_p);
  if (!s7_is_integer(type)) s7_wrong_type_arg_error(sc, "pango_attr_iterator_get", 2, type, "PangoAttrType");
  return(lg_make_c_pointer_with_type(sc, PangoAttribute__sym, pango_attr_iterator_get((PangoAttrIterator*)s7_c_pointer(iterator), (PangoAttrType)s7_integer(type))));
}

static s7_pointer lg_pango_attr_iterator_get_font(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_iterator_get_font "void pango_attr_iterator_get_font(PangoAttrIterator* iterator, \
PangoFontDescription* desc, PangoLanguage** [language], GSList** [extra_attrs])"
  s7_pointer _p;
  s7_pointer iterator, desc;
  PangoLanguage* ref_language = NULL;
  GSList* ref_extra_attrs = NULL;
  _p = args;
  iterator = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iterator, PangoAttrIterator__sym)) s7_wrong_type_arg_error(sc, "pango_attr_iterator_get_font", 1, iterator, "PangoAttrIterator*");
  desc = s7_car(_p);
  if (!s7_is_c_pointer_of_type(desc, PangoFontDescription__sym)) s7_wrong_type_arg_error(sc, "pango_attr_iterator_get_font", 2, desc, "PangoFontDescription*");
  pango_attr_iterator_get_font((PangoAttrIterator*)s7_c_pointer(iterator), (PangoFontDescription*)s7_c_pointer(desc), &ref_language, &ref_extra_attrs);
    return(s7_list(sc, 2, s7_make_c_pointer(sc, ref_language), s7_make_c_pointer(sc, ref_extra_attrs)));
}

static s7_pointer lg_pango_parse_markup(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_parse_markup "gboolean pango_parse_markup(char* markup_text, int length, gunichar accel_marker, \
PangoAttrList** attr_list, char** text, gunichar* accel_char, GError** [error])"
  s7_pointer _p;
  s7_pointer markup_text, length, accel_marker, attr_list, text, accel_char;
  GError* ref_error = NULL;
  _p = args;
  markup_text = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(markup_text)) s7_wrong_type_arg_error(sc, "pango_parse_markup", 1, markup_text, "char*");
  length = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(length)) s7_wrong_type_arg_error(sc, "pango_parse_markup", 2, length, "int");
  accel_marker = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(accel_marker)) s7_wrong_type_arg_error(sc, "pango_parse_markup", 3, accel_marker, "gunichar");
  attr_list = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(attr_list, PangoAttrList___sym)) s7_wrong_type_arg_error(sc, "pango_parse_markup", 4, attr_list, "PangoAttrList**");
  text = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(text, char___sym)) s7_wrong_type_arg_error(sc, "pango_parse_markup", 5, text, "char**");
  accel_char = s7_car(_p);
  if (!s7_is_c_pointer_of_type(accel_char, gunichar__sym)) s7_wrong_type_arg_error(sc, "pango_parse_markup", 6, accel_char, "gunichar*");
  {
    s7_pointer res_ult;
    res_ult = s7_make_boolean(sc, pango_parse_markup((char*)s7_string(markup_text), (int)s7_integer(length), (gunichar)s7_integer(accel_marker), (PangoAttrList**)s7_c_pointer(attr_list), (char**)s7_c_pointer(text), (gunichar*)s7_c_pointer(accel_char), &ref_error));
      return(s7_list(sc, 2, res_ult, s7_make_c_pointer(sc, ref_error)));
   }
}

static s7_pointer lg_pango_find_paragraph_boundary(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_find_paragraph_boundary "void pango_find_paragraph_boundary(gchar* text, gint length, \
gint* [paragraph_delimiter_index], gint* [next_paragraph_start])"
  s7_pointer _p;
  s7_pointer text, length;
  gint ref_paragraph_delimiter_index;
  gint ref_next_paragraph_start;
  _p = args;
  text = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(text)) s7_wrong_type_arg_error(sc, "pango_find_paragraph_boundary", 1, text, "gchar*");
  length = s7_car(_p);
  if (!s7_is_integer(length)) s7_wrong_type_arg_error(sc, "pango_find_paragraph_boundary", 2, length, "gint");
  pango_find_paragraph_boundary((gchar*)s7_string(text), (gint)s7_integer(length), &ref_paragraph_delimiter_index, &ref_next_paragraph_start);
    return(s7_list(sc, 2, s7_make_integer(sc, ref_paragraph_delimiter_index), s7_make_integer(sc, ref_next_paragraph_start)));
}

static s7_pointer lg_pango_get_log_attrs(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_get_log_attrs "void pango_get_log_attrs(char* text, int length, int level, PangoLanguage* language, \
PangoLogAttr* log_attrs, int attrs_len)"
  s7_pointer _p;
  s7_pointer text, length, level, language, log_attrs, attrs_len;
  _p = args;
  text = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(text)) s7_wrong_type_arg_error(sc, "pango_get_log_attrs", 1, text, "char*");
  length = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(length)) s7_wrong_type_arg_error(sc, "pango_get_log_attrs", 2, length, "int");
  level = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(level)) s7_wrong_type_arg_error(sc, "pango_get_log_attrs", 3, level, "int");
  language = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(language, PangoLanguage__sym)) s7_wrong_type_arg_error(sc, "pango_get_log_attrs", 4, language, "PangoLanguage*");
  log_attrs = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(log_attrs, PangoLogAttr__sym)) s7_wrong_type_arg_error(sc, "pango_get_log_attrs", 5, log_attrs, "PangoLogAttr*");
  attrs_len = s7_car(_p);
  if (!s7_is_integer(attrs_len)) s7_wrong_type_arg_error(sc, "pango_get_log_attrs", 6, attrs_len, "int");
  pango_get_log_attrs((char*)s7_string(text), (int)s7_integer(length), (int)s7_integer(level), (PangoLanguage*)s7_c_pointer(language), (PangoLogAttr*)s7_c_pointer(log_attrs), (int)s7_integer(attrs_len));
  return(lg_false);
}

static s7_pointer lg_pango_context_list_families(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_context_list_families "void pango_context_list_families(PangoContext* context, PangoFontFamily*** [families], \
int* [n_families])"
  s7_pointer _p;
  s7_pointer context;
  PangoFontFamily** ref_families = NULL;
  int ref_n_families;
  _p = args;
  context = s7_car(_p);
  if (!s7_is_c_pointer_of_type(context, PangoContext__sym)) s7_wrong_type_arg_error(sc, "pango_context_list_families", 1, context, "PangoContext*");
  pango_context_list_families((PangoContext*)s7_c_pointer(context), &ref_families, &ref_n_families);
    return(s7_list(sc, 2, s7_make_c_pointer(sc, ref_families), s7_make_integer(sc, ref_n_families)));
}

static s7_pointer lg_pango_context_load_font(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_context_load_font "PangoFont* pango_context_load_font(PangoContext* context, PangoFontDescription* desc)"
  s7_pointer _p;
  s7_pointer context, desc;
  _p = args;
  context = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(context, PangoContext__sym)) s7_wrong_type_arg_error(sc, "pango_context_load_font", 1, context, "PangoContext*");
  desc = s7_car(_p);
  if (!s7_is_c_pointer_of_type(desc, PangoFontDescription__sym)) s7_wrong_type_arg_error(sc, "pango_context_load_font", 2, desc, "PangoFontDescription*");
  return(lg_make_c_pointer_with_type(sc, PangoFont__sym, pango_context_load_font((PangoContext*)s7_c_pointer(context), (PangoFontDescription*)s7_c_pointer(desc))));
}

static s7_pointer lg_pango_context_load_fontset(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_context_load_fontset "PangoFontset* pango_context_load_fontset(PangoContext* context, \
PangoFontDescription* desc, PangoLanguage* language)"
  s7_pointer _p;
  s7_pointer context, desc, language;
  _p = args;
  context = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(context, PangoContext__sym)) s7_wrong_type_arg_error(sc, "pango_context_load_fontset", 1, context, "PangoContext*");
  desc = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(desc, PangoFontDescription__sym)) s7_wrong_type_arg_error(sc, "pango_context_load_fontset", 2, desc, "PangoFontDescription*");
  language = s7_car(_p);
  if (!s7_is_c_pointer_of_type(language, PangoLanguage__sym)) s7_wrong_type_arg_error(sc, "pango_context_load_fontset", 3, language, "PangoLanguage*");
  return(lg_make_c_pointer_with_type(sc, PangoFontset__sym, pango_context_load_fontset((PangoContext*)s7_c_pointer(context), (PangoFontDescription*)s7_c_pointer(desc), (PangoLanguage*)s7_c_pointer(language))));
}

static s7_pointer lg_pango_context_get_metrics(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_context_get_metrics "PangoFontMetrics* pango_context_get_metrics(PangoContext* context, \
PangoFontDescription* desc, PangoLanguage* language)"
  s7_pointer _p;
  s7_pointer context, desc, language;
  _p = args;
  context = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(context, PangoContext__sym)) s7_wrong_type_arg_error(sc, "pango_context_get_metrics", 1, context, "PangoContext*");
  desc = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(desc, PangoFontDescription__sym)) s7_wrong_type_arg_error(sc, "pango_context_get_metrics", 2, desc, "PangoFontDescription*");
  language = s7_car(_p);
  if (!s7_is_c_pointer_of_type(language, PangoLanguage__sym)) s7_wrong_type_arg_error(sc, "pango_context_get_metrics", 3, language, "PangoLanguage*");
  return(lg_make_c_pointer_with_type(sc, PangoFontMetrics__sym, pango_context_get_metrics((PangoContext*)s7_c_pointer(context), (PangoFontDescription*)s7_c_pointer(desc), (PangoLanguage*)s7_c_pointer(language))));
}

static s7_pointer lg_pango_context_set_font_description(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_context_set_font_description "void pango_context_set_font_description(PangoContext* context, \
PangoFontDescription* desc)"
  s7_pointer _p;
  s7_pointer context, desc;
  _p = args;
  context = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(context, PangoContext__sym)) s7_wrong_type_arg_error(sc, "pango_context_set_font_description", 1, context, "PangoContext*");
  desc = s7_car(_p);
  if (!s7_is_c_pointer_of_type(desc, PangoFontDescription__sym)) s7_wrong_type_arg_error(sc, "pango_context_set_font_description", 2, desc, "PangoFontDescription*");
  pango_context_set_font_description((PangoContext*)s7_c_pointer(context), (PangoFontDescription*)s7_c_pointer(desc));
  return(lg_false);
}

static s7_pointer lg_pango_context_get_font_description(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_context_get_font_description "PangoFontDescription* pango_context_get_font_description(PangoContext* context)"
  s7_pointer context;
  context = s7_car(args);
  if (!s7_is_c_pointer_of_type(context, PangoContext__sym)) s7_wrong_type_arg_error(sc, "pango_context_get_font_description", 1, context, "PangoContext*");
  return(lg_make_c_pointer_with_type(sc, PangoFontDescription__sym, pango_context_get_font_description((PangoContext*)s7_c_pointer(context))));
}

static s7_pointer lg_pango_context_get_language(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_context_get_language "PangoLanguage* pango_context_get_language(PangoContext* context)"
  s7_pointer context;
  context = s7_car(args);
  if (!s7_is_c_pointer_of_type(context, PangoContext__sym)) s7_wrong_type_arg_error(sc, "pango_context_get_language", 1, context, "PangoContext*");
  return(lg_make_c_pointer_with_type(sc, PangoLanguage__sym, pango_context_get_language((PangoContext*)s7_c_pointer(context))));
}

static s7_pointer lg_pango_context_set_language(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_context_set_language "void pango_context_set_language(PangoContext* context, PangoLanguage* language)"
  s7_pointer _p;
  s7_pointer context, language;
  _p = args;
  context = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(context, PangoContext__sym)) s7_wrong_type_arg_error(sc, "pango_context_set_language", 1, context, "PangoContext*");
  language = s7_car(_p);
  if (!s7_is_c_pointer_of_type(language, PangoLanguage__sym)) s7_wrong_type_arg_error(sc, "pango_context_set_language", 2, language, "PangoLanguage*");
  pango_context_set_language((PangoContext*)s7_c_pointer(context), (PangoLanguage*)s7_c_pointer(language));
  return(lg_false);
}

static s7_pointer lg_pango_context_set_base_dir(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_context_set_base_dir "void pango_context_set_base_dir(PangoContext* context, PangoDirection direction)"
  s7_pointer _p;
  s7_pointer context, direction;
  _p = args;
  context = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(context, PangoContext__sym)) s7_wrong_type_arg_error(sc, "pango_context_set_base_dir", 1, context, "PangoContext*");
  direction = s7_car(_p);
  if (!s7_is_integer(direction)) s7_wrong_type_arg_error(sc, "pango_context_set_base_dir", 2, direction, "PangoDirection");
  pango_context_set_base_dir((PangoContext*)s7_c_pointer(context), (PangoDirection)s7_integer(direction));
  return(lg_false);
}

static s7_pointer lg_pango_context_get_base_dir(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_context_get_base_dir "PangoDirection pango_context_get_base_dir(PangoContext* context)"
  s7_pointer context;
  context = s7_car(args);
  if (!s7_is_c_pointer_of_type(context, PangoContext__sym)) s7_wrong_type_arg_error(sc, "pango_context_get_base_dir", 1, context, "PangoContext*");
  return(s7_make_integer(sc, pango_context_get_base_dir((PangoContext*)s7_c_pointer(context))));
}

static s7_pointer lg_pango_itemize(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_itemize "GList* pango_itemize(PangoContext* context, char* text, int start_index, int length, \
PangoAttrList* attrs, PangoAttrIterator* cached_iter)"
  s7_pointer _p;
  s7_pointer context, text, start_index, length, attrs, cached_iter;
  _p = args;
  context = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(context, PangoContext__sym)) s7_wrong_type_arg_error(sc, "pango_itemize", 1, context, "PangoContext*");
  text = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(text)) s7_wrong_type_arg_error(sc, "pango_itemize", 2, text, "char*");
  start_index = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(start_index)) s7_wrong_type_arg_error(sc, "pango_itemize", 3, start_index, "int");
  length = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(length)) s7_wrong_type_arg_error(sc, "pango_itemize", 4, length, "int");
  attrs = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(attrs, PangoAttrList__sym)) s7_wrong_type_arg_error(sc, "pango_itemize", 5, attrs, "PangoAttrList*");
  cached_iter = s7_car(_p);
  if (!s7_is_c_pointer_of_type(cached_iter, PangoAttrIterator__sym)) s7_wrong_type_arg_error(sc, "pango_itemize", 6, cached_iter, "PangoAttrIterator*");
  return(lg_make_c_pointer_with_type(sc, GList__sym, pango_itemize((PangoContext*)s7_c_pointer(context), (char*)s7_string(text), (int)s7_integer(start_index), (int)s7_integer(length), (PangoAttrList*)s7_c_pointer(attrs), (PangoAttrIterator*)s7_c_pointer(cached_iter))));
}

static s7_pointer lg_pango_coverage_new(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_coverage_new "PangoCoverage* pango_coverage_new( void)"
  return(lg_make_c_pointer_with_type(sc, PangoCoverage__sym, pango_coverage_new()));
}

static s7_pointer lg_pango_coverage_ref(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_coverage_ref "PangoCoverage* pango_coverage_ref(PangoCoverage* coverage)"
  s7_pointer coverage;
  coverage = s7_car(args);
  if (!s7_is_c_pointer_of_type(coverage, PangoCoverage__sym)) s7_wrong_type_arg_error(sc, "pango_coverage_ref", 1, coverage, "PangoCoverage*");
  return(lg_make_c_pointer_with_type(sc, PangoCoverage__sym, pango_coverage_ref((PangoCoverage*)s7_c_pointer(coverage))));
}

static s7_pointer lg_pango_coverage_unref(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_coverage_unref "void pango_coverage_unref(PangoCoverage* coverage)"
  s7_pointer coverage;
  coverage = s7_car(args);
  if (!s7_is_c_pointer_of_type(coverage, PangoCoverage__sym)) s7_wrong_type_arg_error(sc, "pango_coverage_unref", 1, coverage, "PangoCoverage*");
  pango_coverage_unref((PangoCoverage*)s7_c_pointer(coverage));
  return(lg_false);
}

static s7_pointer lg_pango_coverage_copy(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_coverage_copy "PangoCoverage* pango_coverage_copy(PangoCoverage* coverage)"
  s7_pointer coverage;
  coverage = s7_car(args);
  if (!s7_is_c_pointer_of_type(coverage, PangoCoverage__sym)) s7_wrong_type_arg_error(sc, "pango_coverage_copy", 1, coverage, "PangoCoverage*");
  return(lg_make_c_pointer_with_type(sc, PangoCoverage__sym, pango_coverage_copy((PangoCoverage*)s7_c_pointer(coverage))));
}

static s7_pointer lg_pango_coverage_get(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_coverage_get "PangoCoverageLevel pango_coverage_get(PangoCoverage* coverage, int index)"
  s7_pointer _p;
  s7_pointer coverage, index;
  _p = args;
  coverage = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(coverage, PangoCoverage__sym)) s7_wrong_type_arg_error(sc, "pango_coverage_get", 1, coverage, "PangoCoverage*");
  index = s7_car(_p);
  if (!s7_is_integer(index)) s7_wrong_type_arg_error(sc, "pango_coverage_get", 2, index, "int");
  return(s7_make_integer(sc, pango_coverage_get((PangoCoverage*)s7_c_pointer(coverage), (int)s7_integer(index))));
}

static s7_pointer lg_pango_coverage_set(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_coverage_set "void pango_coverage_set(PangoCoverage* coverage, int index, PangoCoverageLevel level)"
  s7_pointer _p;
  s7_pointer coverage, index, level;
  _p = args;
  coverage = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(coverage, PangoCoverage__sym)) s7_wrong_type_arg_error(sc, "pango_coverage_set", 1, coverage, "PangoCoverage*");
  index = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(index)) s7_wrong_type_arg_error(sc, "pango_coverage_set", 2, index, "int");
  level = s7_car(_p);
  if (!s7_is_integer(level)) s7_wrong_type_arg_error(sc, "pango_coverage_set", 3, level, "PangoCoverageLevel");
  pango_coverage_set((PangoCoverage*)s7_c_pointer(coverage), (int)s7_integer(index), (PangoCoverageLevel)s7_integer(level));
  return(lg_false);
}

static s7_pointer lg_pango_font_description_new(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_description_new "PangoFontDescription* pango_font_description_new( void)"
  return(lg_make_c_pointer_with_type(sc, PangoFontDescription__sym, pango_font_description_new()));
}

static s7_pointer lg_pango_font_description_copy(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_description_copy "PangoFontDescription* pango_font_description_copy(PangoFontDescription* desc)"
  s7_pointer desc;
  desc = s7_car(args);
  if (!s7_is_c_pointer_of_type(desc, PangoFontDescription__sym)) s7_wrong_type_arg_error(sc, "pango_font_description_copy", 1, desc, "PangoFontDescription*");
  return(lg_make_c_pointer_with_type(sc, PangoFontDescription__sym, pango_font_description_copy((PangoFontDescription*)s7_c_pointer(desc))));
}

static s7_pointer lg_pango_font_description_copy_static(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_description_copy_static "PangoFontDescription* pango_font_description_copy_static(PangoFontDescription* desc)"
  s7_pointer desc;
  desc = s7_car(args);
  if (!s7_is_c_pointer_of_type(desc, PangoFontDescription__sym)) s7_wrong_type_arg_error(sc, "pango_font_description_copy_static", 1, desc, "PangoFontDescription*");
  return(lg_make_c_pointer_with_type(sc, PangoFontDescription__sym, pango_font_description_copy_static((PangoFontDescription*)s7_c_pointer(desc))));
}

static s7_pointer lg_pango_font_description_hash(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_description_hash "guint pango_font_description_hash(PangoFontDescription* desc)"
  s7_pointer desc;
  desc = s7_car(args);
  if (!s7_is_c_pointer_of_type(desc, PangoFontDescription__sym)) s7_wrong_type_arg_error(sc, "pango_font_description_hash", 1, desc, "PangoFontDescription*");
  return(s7_make_integer(sc, pango_font_description_hash((PangoFontDescription*)s7_c_pointer(desc))));
}

static s7_pointer lg_pango_font_description_equal(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_description_equal "gboolean pango_font_description_equal(PangoFontDescription* desc1, \
PangoFontDescription* desc2)"
  s7_pointer _p;
  s7_pointer desc1, desc2;
  _p = args;
  desc1 = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(desc1, PangoFontDescription__sym)) s7_wrong_type_arg_error(sc, "pango_font_description_equal", 1, desc1, "PangoFontDescription*");
  desc2 = s7_car(_p);
  if (!s7_is_c_pointer_of_type(desc2, PangoFontDescription__sym)) s7_wrong_type_arg_error(sc, "pango_font_description_equal", 2, desc2, "PangoFontDescription*");
  return(s7_make_boolean(sc, pango_font_description_equal((PangoFontDescription*)s7_c_pointer(desc1), (PangoFontDescription*)s7_c_pointer(desc2))));
}

static s7_pointer lg_pango_font_description_free(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_description_free "void pango_font_description_free(PangoFontDescription* desc)"
  s7_pointer desc;
  desc = s7_car(args);
  if (!s7_is_c_pointer_of_type(desc, PangoFontDescription__sym)) s7_wrong_type_arg_error(sc, "pango_font_description_free", 1, desc, "PangoFontDescription*");
  pango_font_description_free((PangoFontDescription*)s7_c_pointer(desc));
  return(lg_false);
}

static s7_pointer lg_pango_font_descriptions_free(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_descriptions_free "void pango_font_descriptions_free(PangoFontDescription** descs, \
int n_descs)"
  s7_pointer _p;
  s7_pointer descs, n_descs;
  _p = args;
  descs = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(descs, PangoFontDescription___sym)) s7_wrong_type_arg_error(sc, "pango_font_descriptions_free", 1, descs, "PangoFontDescription**");
  n_descs = s7_car(_p);
  if (!s7_is_integer(n_descs)) s7_wrong_type_arg_error(sc, "pango_font_descriptions_free", 2, n_descs, "int");
  pango_font_descriptions_free((PangoFontDescription**)s7_c_pointer(descs), (int)s7_integer(n_descs));
  return(lg_false);
}

static s7_pointer lg_pango_font_description_set_family(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_description_set_family "void pango_font_description_set_family(PangoFontDescription* desc, \
char* family)"
  s7_pointer _p;
  s7_pointer desc, family;
  _p = args;
  desc = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(desc, PangoFontDescription__sym)) s7_wrong_type_arg_error(sc, "pango_font_description_set_family", 1, desc, "PangoFontDescription*");
  family = s7_car(_p);
  if (!s7_is_string(family)) s7_wrong_type_arg_error(sc, "pango_font_description_set_family", 2, family, "char*");
  pango_font_description_set_family((PangoFontDescription*)s7_c_pointer(desc), (char*)s7_string(family));
  return(lg_false);
}

static s7_pointer lg_pango_font_description_set_family_static(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_description_set_family_static "void pango_font_description_set_family_static(PangoFontDescription* desc, \
char* family)"
  s7_pointer _p;
  s7_pointer desc, family;
  _p = args;
  desc = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(desc, PangoFontDescription__sym)) s7_wrong_type_arg_error(sc, "pango_font_description_set_family_static", 1, desc, "PangoFontDescription*");
  family = s7_car(_p);
  if (!s7_is_string(family)) s7_wrong_type_arg_error(sc, "pango_font_description_set_family_static", 2, family, "char*");
  pango_font_description_set_family_static((PangoFontDescription*)s7_c_pointer(desc), (char*)s7_string(family));
  return(lg_false);
}

static s7_pointer lg_pango_font_description_get_family(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_description_get_family "char* pango_font_description_get_family(PangoFontDescription* desc)"
  s7_pointer desc;
  desc = s7_car(args);
  if (!s7_is_c_pointer_of_type(desc, PangoFontDescription__sym)) s7_wrong_type_arg_error(sc, "pango_font_description_get_family", 1, desc, "PangoFontDescription*");
  return(s7_make_string(sc, pango_font_description_get_family((PangoFontDescription*)s7_c_pointer(desc))));
}

static s7_pointer lg_pango_font_description_set_style(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_description_set_style "void pango_font_description_set_style(PangoFontDescription* desc, \
PangoStyle style)"
  s7_pointer _p;
  s7_pointer desc, style;
  _p = args;
  desc = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(desc, PangoFontDescription__sym)) s7_wrong_type_arg_error(sc, "pango_font_description_set_style", 1, desc, "PangoFontDescription*");
  style = s7_car(_p);
  if (!s7_is_integer(style)) s7_wrong_type_arg_error(sc, "pango_font_description_set_style", 2, style, "PangoStyle");
  pango_font_description_set_style((PangoFontDescription*)s7_c_pointer(desc), (PangoStyle)s7_integer(style));
  return(lg_false);
}

static s7_pointer lg_pango_font_description_get_style(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_description_get_style "PangoStyle pango_font_description_get_style(PangoFontDescription* desc)"
  s7_pointer desc;
  desc = s7_car(args);
  if (!s7_is_c_pointer_of_type(desc, PangoFontDescription__sym)) s7_wrong_type_arg_error(sc, "pango_font_description_get_style", 1, desc, "PangoFontDescription*");
  return(s7_make_integer(sc, pango_font_description_get_style((PangoFontDescription*)s7_c_pointer(desc))));
}

static s7_pointer lg_pango_font_description_set_variant(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_description_set_variant "void pango_font_description_set_variant(PangoFontDescription* desc, \
PangoVariant variant)"
  s7_pointer _p;
  s7_pointer desc, variant;
  _p = args;
  desc = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(desc, PangoFontDescription__sym)) s7_wrong_type_arg_error(sc, "pango_font_description_set_variant", 1, desc, "PangoFontDescription*");
  variant = s7_car(_p);
  if (!s7_is_integer(variant)) s7_wrong_type_arg_error(sc, "pango_font_description_set_variant", 2, variant, "PangoVariant");
  pango_font_description_set_variant((PangoFontDescription*)s7_c_pointer(desc), (PangoVariant)s7_integer(variant));
  return(lg_false);
}

static s7_pointer lg_pango_font_description_get_variant(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_description_get_variant "PangoVariant pango_font_description_get_variant(PangoFontDescription* desc)"
  s7_pointer desc;
  desc = s7_car(args);
  if (!s7_is_c_pointer_of_type(desc, PangoFontDescription__sym)) s7_wrong_type_arg_error(sc, "pango_font_description_get_variant", 1, desc, "PangoFontDescription*");
  return(s7_make_integer(sc, pango_font_description_get_variant((PangoFontDescription*)s7_c_pointer(desc))));
}

static s7_pointer lg_pango_font_description_set_weight(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_description_set_weight "void pango_font_description_set_weight(PangoFontDescription* desc, \
PangoWeight weight)"
  s7_pointer _p;
  s7_pointer desc, weight;
  _p = args;
  desc = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(desc, PangoFontDescription__sym)) s7_wrong_type_arg_error(sc, "pango_font_description_set_weight", 1, desc, "PangoFontDescription*");
  weight = s7_car(_p);
  if (!s7_is_integer(weight)) s7_wrong_type_arg_error(sc, "pango_font_description_set_weight", 2, weight, "PangoWeight");
  pango_font_description_set_weight((PangoFontDescription*)s7_c_pointer(desc), (PangoWeight)s7_integer(weight));
  return(lg_false);
}

static s7_pointer lg_pango_font_description_get_weight(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_description_get_weight "PangoWeight pango_font_description_get_weight(PangoFontDescription* desc)"
  s7_pointer desc;
  desc = s7_car(args);
  if (!s7_is_c_pointer_of_type(desc, PangoFontDescription__sym)) s7_wrong_type_arg_error(sc, "pango_font_description_get_weight", 1, desc, "PangoFontDescription*");
  return(s7_make_integer(sc, pango_font_description_get_weight((PangoFontDescription*)s7_c_pointer(desc))));
}

static s7_pointer lg_pango_font_description_set_stretch(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_description_set_stretch "void pango_font_description_set_stretch(PangoFontDescription* desc, \
PangoStretch stretch)"
  s7_pointer _p;
  s7_pointer desc, stretch;
  _p = args;
  desc = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(desc, PangoFontDescription__sym)) s7_wrong_type_arg_error(sc, "pango_font_description_set_stretch", 1, desc, "PangoFontDescription*");
  stretch = s7_car(_p);
  if (!s7_is_integer(stretch)) s7_wrong_type_arg_error(sc, "pango_font_description_set_stretch", 2, stretch, "PangoStretch");
  pango_font_description_set_stretch((PangoFontDescription*)s7_c_pointer(desc), (PangoStretch)s7_integer(stretch));
  return(lg_false);
}

static s7_pointer lg_pango_font_description_get_stretch(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_description_get_stretch "PangoStretch pango_font_description_get_stretch(PangoFontDescription* desc)"
  s7_pointer desc;
  desc = s7_car(args);
  if (!s7_is_c_pointer_of_type(desc, PangoFontDescription__sym)) s7_wrong_type_arg_error(sc, "pango_font_description_get_stretch", 1, desc, "PangoFontDescription*");
  return(s7_make_integer(sc, pango_font_description_get_stretch((PangoFontDescription*)s7_c_pointer(desc))));
}

static s7_pointer lg_pango_font_description_set_size(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_description_set_size "void pango_font_description_set_size(PangoFontDescription* desc, \
gint size)"
  s7_pointer _p;
  s7_pointer desc, size;
  _p = args;
  desc = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(desc, PangoFontDescription__sym)) s7_wrong_type_arg_error(sc, "pango_font_description_set_size", 1, desc, "PangoFontDescription*");
  size = s7_car(_p);
  if (!s7_is_integer(size)) s7_wrong_type_arg_error(sc, "pango_font_description_set_size", 2, size, "gint");
  pango_font_description_set_size((PangoFontDescription*)s7_c_pointer(desc), (gint)s7_integer(size));
  return(lg_false);
}

static s7_pointer lg_pango_font_description_get_size(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_description_get_size "gint pango_font_description_get_size(PangoFontDescription* desc)"
  s7_pointer desc;
  desc = s7_car(args);
  if (!s7_is_c_pointer_of_type(desc, PangoFontDescription__sym)) s7_wrong_type_arg_error(sc, "pango_font_description_get_size", 1, desc, "PangoFontDescription*");
  return(s7_make_integer(sc, pango_font_description_get_size((PangoFontDescription*)s7_c_pointer(desc))));
}

static s7_pointer lg_pango_font_description_get_set_fields(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_description_get_set_fields "PangoFontMask pango_font_description_get_set_fields(PangoFontDescription* desc)"
  s7_pointer desc;
  desc = s7_car(args);
  if (!s7_is_c_pointer_of_type(desc, PangoFontDescription__sym)) s7_wrong_type_arg_error(sc, "pango_font_description_get_set_fields", 1, desc, "PangoFontDescription*");
  return(s7_make_integer(sc, pango_font_description_get_set_fields((PangoFontDescription*)s7_c_pointer(desc))));
}

static s7_pointer lg_pango_font_description_unset_fields(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_description_unset_fields "void pango_font_description_unset_fields(PangoFontDescription* desc, \
PangoFontMask to_unset)"
  s7_pointer _p;
  s7_pointer desc, to_unset;
  _p = args;
  desc = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(desc, PangoFontDescription__sym)) s7_wrong_type_arg_error(sc, "pango_font_description_unset_fields", 1, desc, "PangoFontDescription*");
  to_unset = s7_car(_p);
  if (!s7_is_integer(to_unset)) s7_wrong_type_arg_error(sc, "pango_font_description_unset_fields", 2, to_unset, "PangoFontMask");
  pango_font_description_unset_fields((PangoFontDescription*)s7_c_pointer(desc), (PangoFontMask)s7_integer(to_unset));
  return(lg_false);
}

static s7_pointer lg_pango_font_description_merge(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_description_merge "void pango_font_description_merge(PangoFontDescription* desc, \
PangoFontDescription* desc_to_merge, gboolean replace_existing)"
  s7_pointer _p;
  s7_pointer desc, desc_to_merge, replace_existing;
  _p = args;
  desc = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(desc, PangoFontDescription__sym)) s7_wrong_type_arg_error(sc, "pango_font_description_merge", 1, desc, "PangoFontDescription*");
  desc_to_merge = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(desc_to_merge, PangoFontDescription__sym)) s7_wrong_type_arg_error(sc, "pango_font_description_merge", 2, desc_to_merge, "PangoFontDescription*");
  replace_existing = s7_car(_p);
  if (!s7_is_boolean(replace_existing)) s7_wrong_type_arg_error(sc, "pango_font_description_merge", 3, replace_existing, "gboolean");
  pango_font_description_merge((PangoFontDescription*)s7_c_pointer(desc), (PangoFontDescription*)s7_c_pointer(desc_to_merge), (gboolean)lg_boolean(replace_existing));
  return(lg_false);
}

static s7_pointer lg_pango_font_description_merge_static(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_description_merge_static "void pango_font_description_merge_static(PangoFontDescription* desc, \
PangoFontDescription* desc_to_merge, gboolean replace_existing)"
  s7_pointer _p;
  s7_pointer desc, desc_to_merge, replace_existing;
  _p = args;
  desc = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(desc, PangoFontDescription__sym)) s7_wrong_type_arg_error(sc, "pango_font_description_merge_static", 1, desc, "PangoFontDescription*");
  desc_to_merge = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(desc_to_merge, PangoFontDescription__sym)) s7_wrong_type_arg_error(sc, "pango_font_description_merge_static", 2, desc_to_merge, "PangoFontDescription*");
  replace_existing = s7_car(_p);
  if (!s7_is_boolean(replace_existing)) s7_wrong_type_arg_error(sc, "pango_font_description_merge_static", 3, replace_existing, "gboolean");
  pango_font_description_merge_static((PangoFontDescription*)s7_c_pointer(desc), (PangoFontDescription*)s7_c_pointer(desc_to_merge), (gboolean)lg_boolean(replace_existing));
  return(lg_false);
}

static s7_pointer lg_pango_font_description_better_match(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_description_better_match "gboolean pango_font_description_better_match(PangoFontDescription* desc, \
PangoFontDescription* old_match, PangoFontDescription* new_match)"
  s7_pointer _p;
  s7_pointer desc, old_match, new_match;
  _p = args;
  desc = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(desc, PangoFontDescription__sym)) s7_wrong_type_arg_error(sc, "pango_font_description_better_match", 1, desc, "PangoFontDescription*");
  old_match = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(old_match, PangoFontDescription__sym)) s7_wrong_type_arg_error(sc, "pango_font_description_better_match", 2, old_match, "PangoFontDescription*");
  new_match = s7_car(_p);
  if (!s7_is_c_pointer_of_type(new_match, PangoFontDescription__sym)) s7_wrong_type_arg_error(sc, "pango_font_description_better_match", 3, new_match, "PangoFontDescription*");
  return(s7_make_boolean(sc, pango_font_description_better_match((PangoFontDescription*)s7_c_pointer(desc), (PangoFontDescription*)s7_c_pointer(old_match), (PangoFontDescription*)s7_c_pointer(new_match))));
}

static s7_pointer lg_pango_font_description_from_string(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_description_from_string "PangoFontDescription* pango_font_description_from_string(char* str)"
  s7_pointer str;
  str = s7_car(args);
  if (!s7_is_string(str)) s7_wrong_type_arg_error(sc, "pango_font_description_from_string", 1, str, "char*");
  return(lg_make_c_pointer_with_type(sc, PangoFontDescription__sym, pango_font_description_from_string((char*)s7_string(str))));
}

static s7_pointer lg_pango_font_description_to_string(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_description_to_string "char* pango_font_description_to_string(PangoFontDescription* desc)"
  s7_pointer desc;
  desc = s7_car(args);
  if (!s7_is_c_pointer_of_type(desc, PangoFontDescription__sym)) s7_wrong_type_arg_error(sc, "pango_font_description_to_string", 1, desc, "PangoFontDescription*");
  {
    char* res_ult;
    s7_pointer rtn;
    res_ult = pango_font_description_to_string((PangoFontDescription*)s7_c_pointer(desc));
    rtn = s7_make_string(sc, res_ult);
    g_free(res_ult);
    return(rtn);
  }
}

static s7_pointer lg_pango_font_description_to_filename(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_description_to_filename "char* pango_font_description_to_filename(PangoFontDescription* desc)"
  s7_pointer desc;
  desc = s7_car(args);
  if (!s7_is_c_pointer_of_type(desc, PangoFontDescription__sym)) s7_wrong_type_arg_error(sc, "pango_font_description_to_filename", 1, desc, "PangoFontDescription*");
  {
    char* res_ult;
    s7_pointer rtn;
    res_ult = pango_font_description_to_filename((PangoFontDescription*)s7_c_pointer(desc));
    rtn = s7_make_string(sc, res_ult);
    g_free(res_ult);
    return(rtn);
  }
}

static s7_pointer lg_pango_font_metrics_ref(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_metrics_ref "PangoFontMetrics* pango_font_metrics_ref(PangoFontMetrics* metrics)"
  s7_pointer metrics;
  metrics = s7_car(args);
  if (!s7_is_c_pointer_of_type(metrics, PangoFontMetrics__sym)) s7_wrong_type_arg_error(sc, "pango_font_metrics_ref", 1, metrics, "PangoFontMetrics*");
  return(lg_make_c_pointer_with_type(sc, PangoFontMetrics__sym, pango_font_metrics_ref((PangoFontMetrics*)s7_c_pointer(metrics))));
}

static s7_pointer lg_pango_font_metrics_unref(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_metrics_unref "void pango_font_metrics_unref(PangoFontMetrics* metrics)"
  s7_pointer metrics;
  metrics = s7_car(args);
  if (!s7_is_c_pointer_of_type(metrics, PangoFontMetrics__sym)) s7_wrong_type_arg_error(sc, "pango_font_metrics_unref", 1, metrics, "PangoFontMetrics*");
  pango_font_metrics_unref((PangoFontMetrics*)s7_c_pointer(metrics));
  return(lg_false);
}

static s7_pointer lg_pango_font_metrics_get_ascent(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_metrics_get_ascent "int pango_font_metrics_get_ascent(PangoFontMetrics* metrics)"
  s7_pointer metrics;
  metrics = s7_car(args);
  if (!s7_is_c_pointer_of_type(metrics, PangoFontMetrics__sym)) s7_wrong_type_arg_error(sc, "pango_font_metrics_get_ascent", 1, metrics, "PangoFontMetrics*");
  return(s7_make_integer(sc, pango_font_metrics_get_ascent((PangoFontMetrics*)s7_c_pointer(metrics))));
}

static s7_pointer lg_pango_font_metrics_get_descent(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_metrics_get_descent "int pango_font_metrics_get_descent(PangoFontMetrics* metrics)"
  s7_pointer metrics;
  metrics = s7_car(args);
  if (!s7_is_c_pointer_of_type(metrics, PangoFontMetrics__sym)) s7_wrong_type_arg_error(sc, "pango_font_metrics_get_descent", 1, metrics, "PangoFontMetrics*");
  return(s7_make_integer(sc, pango_font_metrics_get_descent((PangoFontMetrics*)s7_c_pointer(metrics))));
}

static s7_pointer lg_pango_font_metrics_get_approximate_char_width(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_metrics_get_approximate_char_width "int pango_font_metrics_get_approximate_char_width(PangoFontMetrics* metrics)"
  s7_pointer metrics;
  metrics = s7_car(args);
  if (!s7_is_c_pointer_of_type(metrics, PangoFontMetrics__sym)) s7_wrong_type_arg_error(sc, "pango_font_metrics_get_approximate_char_width", 1, metrics, "PangoFontMetrics*");
  return(s7_make_integer(sc, pango_font_metrics_get_approximate_char_width((PangoFontMetrics*)s7_c_pointer(metrics))));
}

static s7_pointer lg_pango_font_metrics_get_approximate_digit_width(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_metrics_get_approximate_digit_width "int pango_font_metrics_get_approximate_digit_width(PangoFontMetrics* metrics)"
  s7_pointer metrics;
  metrics = s7_car(args);
  if (!s7_is_c_pointer_of_type(metrics, PangoFontMetrics__sym)) s7_wrong_type_arg_error(sc, "pango_font_metrics_get_approximate_digit_width", 1, metrics, "PangoFontMetrics*");
  return(s7_make_integer(sc, pango_font_metrics_get_approximate_digit_width((PangoFontMetrics*)s7_c_pointer(metrics))));
}

static s7_pointer lg_pango_font_family_list_faces(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_family_list_faces "void pango_font_family_list_faces(PangoFontFamily* family, \
PangoFontFace*** [faces], int* [n_faces])"
  s7_pointer _p;
  s7_pointer family;
  PangoFontFace** ref_faces = NULL;
  int ref_n_faces;
  _p = args;
  family = s7_car(_p);
  if (!s7_is_c_pointer_of_type(family, PangoFontFamily__sym)) s7_wrong_type_arg_error(sc, "pango_font_family_list_faces", 1, family, "PangoFontFamily*");
  pango_font_family_list_faces((PangoFontFamily*)s7_c_pointer(family), &ref_faces, &ref_n_faces);
    return(s7_list(sc, 2, s7_make_c_pointer(sc, ref_faces), s7_make_integer(sc, ref_n_faces)));
}

static s7_pointer lg_pango_font_family_get_name(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_family_get_name "char* pango_font_family_get_name(PangoFontFamily* family)"
  s7_pointer family;
  family = s7_car(args);
  if (!s7_is_c_pointer_of_type(family, PangoFontFamily__sym)) s7_wrong_type_arg_error(sc, "pango_font_family_get_name", 1, family, "PangoFontFamily*");
  return(s7_make_string(sc, pango_font_family_get_name((PangoFontFamily*)s7_c_pointer(family))));
}

static s7_pointer lg_pango_font_face_describe(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_face_describe "PangoFontDescription* pango_font_face_describe(PangoFontFace* face)"
  s7_pointer face;
  face = s7_car(args);
  if (!s7_is_c_pointer_of_type(face, PangoFontFace__sym)) s7_wrong_type_arg_error(sc, "pango_font_face_describe", 1, face, "PangoFontFace*");
  return(lg_make_c_pointer_with_type(sc, PangoFontDescription__sym, pango_font_face_describe((PangoFontFace*)s7_c_pointer(face))));
}

static s7_pointer lg_pango_font_face_get_face_name(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_face_get_face_name "char* pango_font_face_get_face_name(PangoFontFace* face)"
  s7_pointer face;
  face = s7_car(args);
  if (!s7_is_c_pointer_of_type(face, PangoFontFace__sym)) s7_wrong_type_arg_error(sc, "pango_font_face_get_face_name", 1, face, "PangoFontFace*");
  return(s7_make_string(sc, pango_font_face_get_face_name((PangoFontFace*)s7_c_pointer(face))));
}

static s7_pointer lg_pango_font_describe(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_describe "PangoFontDescription* pango_font_describe(PangoFont* font)"
  s7_pointer font;
  font = s7_car(args);
  if (!s7_is_c_pointer_of_type(font, PangoFont__sym)) s7_wrong_type_arg_error(sc, "pango_font_describe", 1, font, "PangoFont*");
  return(lg_make_c_pointer_with_type(sc, PangoFontDescription__sym, pango_font_describe((PangoFont*)s7_c_pointer(font))));
}

static s7_pointer lg_pango_font_get_coverage(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_get_coverage "PangoCoverage* pango_font_get_coverage(PangoFont* font, PangoLanguage* language)"
  s7_pointer _p;
  s7_pointer font, language;
  _p = args;
  font = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(font, PangoFont__sym)) s7_wrong_type_arg_error(sc, "pango_font_get_coverage", 1, font, "PangoFont*");
  language = s7_car(_p);
  if (!s7_is_c_pointer_of_type(language, PangoLanguage__sym)) s7_wrong_type_arg_error(sc, "pango_font_get_coverage", 2, language, "PangoLanguage*");
  return(lg_make_c_pointer_with_type(sc, PangoCoverage__sym, pango_font_get_coverage((PangoFont*)s7_c_pointer(font), (PangoLanguage*)s7_c_pointer(language))));
}

static s7_pointer lg_pango_font_get_metrics(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_get_metrics "PangoFontMetrics* pango_font_get_metrics(PangoFont* font, PangoLanguage* language)"
  s7_pointer _p;
  s7_pointer font, language;
  _p = args;
  font = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(font, PangoFont__sym)) s7_wrong_type_arg_error(sc, "pango_font_get_metrics", 1, font, "PangoFont*");
  language = s7_car(_p);
  if (!s7_is_c_pointer_of_type(language, PangoLanguage__sym)) s7_wrong_type_arg_error(sc, "pango_font_get_metrics", 2, language, "PangoLanguage*");
  return(lg_make_c_pointer_with_type(sc, PangoFontMetrics__sym, pango_font_get_metrics((PangoFont*)s7_c_pointer(font), (PangoLanguage*)s7_c_pointer(language))));
}

static s7_pointer lg_pango_font_get_glyph_extents(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_get_glyph_extents "void pango_font_get_glyph_extents(PangoFont* font, PangoGlyph glyph, \
PangoRectangle* ink_rect, PangoRectangle* logical_rect)"
  s7_pointer _p;
  s7_pointer font, glyph, ink_rect, logical_rect;
  _p = args;
  font = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(font, PangoFont__sym)) s7_wrong_type_arg_error(sc, "pango_font_get_glyph_extents", 1, font, "PangoFont*");
  glyph = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(glyph)) s7_wrong_type_arg_error(sc, "pango_font_get_glyph_extents", 2, glyph, "PangoGlyph");
  ink_rect = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(ink_rect, PangoRectangle__sym)) s7_wrong_type_arg_error(sc, "pango_font_get_glyph_extents", 3, ink_rect, "PangoRectangle*");
  logical_rect = s7_car(_p);
  if (!s7_is_c_pointer_of_type(logical_rect, PangoRectangle__sym)) s7_wrong_type_arg_error(sc, "pango_font_get_glyph_extents", 4, logical_rect, "PangoRectangle*");
  pango_font_get_glyph_extents((PangoFont*)s7_c_pointer(font), (PangoGlyph)s7_integer(glyph), (PangoRectangle*)s7_c_pointer(ink_rect), (PangoRectangle*)s7_c_pointer(logical_rect));
  return(lg_false);
}

static s7_pointer lg_pango_font_map_load_font(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_map_load_font "PangoFont* pango_font_map_load_font(PangoFontMap* fontmap, PangoContext* context, \
PangoFontDescription* desc)"
  s7_pointer _p;
  s7_pointer fontmap, context, desc;
  _p = args;
  fontmap = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(fontmap, PangoFontMap__sym)) s7_wrong_type_arg_error(sc, "pango_font_map_load_font", 1, fontmap, "PangoFontMap*");
  context = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(context, PangoContext__sym)) s7_wrong_type_arg_error(sc, "pango_font_map_load_font", 2, context, "PangoContext*");
  desc = s7_car(_p);
  if (!s7_is_c_pointer_of_type(desc, PangoFontDescription__sym)) s7_wrong_type_arg_error(sc, "pango_font_map_load_font", 3, desc, "PangoFontDescription*");
  return(lg_make_c_pointer_with_type(sc, PangoFont__sym, pango_font_map_load_font((PangoFontMap*)s7_c_pointer(fontmap), (PangoContext*)s7_c_pointer(context), (PangoFontDescription*)s7_c_pointer(desc))));
}

static s7_pointer lg_pango_font_map_load_fontset(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_map_load_fontset "PangoFontset* pango_font_map_load_fontset(PangoFontMap* fontmap, \
PangoContext* context, PangoFontDescription* desc, PangoLanguage* language)"
  s7_pointer _p;
  s7_pointer fontmap, context, desc, language;
  _p = args;
  fontmap = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(fontmap, PangoFontMap__sym)) s7_wrong_type_arg_error(sc, "pango_font_map_load_fontset", 1, fontmap, "PangoFontMap*");
  context = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(context, PangoContext__sym)) s7_wrong_type_arg_error(sc, "pango_font_map_load_fontset", 2, context, "PangoContext*");
  desc = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(desc, PangoFontDescription__sym)) s7_wrong_type_arg_error(sc, "pango_font_map_load_fontset", 3, desc, "PangoFontDescription*");
  language = s7_car(_p);
  if (!s7_is_c_pointer_of_type(language, PangoLanguage__sym)) s7_wrong_type_arg_error(sc, "pango_font_map_load_fontset", 4, language, "PangoLanguage*");
  return(lg_make_c_pointer_with_type(sc, PangoFontset__sym, pango_font_map_load_fontset((PangoFontMap*)s7_c_pointer(fontmap), (PangoContext*)s7_c_pointer(context), (PangoFontDescription*)s7_c_pointer(desc), (PangoLanguage*)s7_c_pointer(language))));
}

static s7_pointer lg_pango_font_map_list_families(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_map_list_families "void pango_font_map_list_families(PangoFontMap* fontmap, PangoFontFamily*** [families], \
int* [n_families])"
  s7_pointer _p;
  s7_pointer fontmap;
  PangoFontFamily** ref_families = NULL;
  int ref_n_families;
  _p = args;
  fontmap = s7_car(_p);
  if (!s7_is_c_pointer_of_type(fontmap, PangoFontMap__sym)) s7_wrong_type_arg_error(sc, "pango_font_map_list_families", 1, fontmap, "PangoFontMap*");
  pango_font_map_list_families((PangoFontMap*)s7_c_pointer(fontmap), &ref_families, &ref_n_families);
    return(s7_list(sc, 2, s7_make_c_pointer(sc, ref_families), s7_make_integer(sc, ref_n_families)));
}

static s7_pointer lg_pango_glyph_string_new(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_glyph_string_new "PangoGlyphString* pango_glyph_string_new( void)"
  return(lg_make_c_pointer_with_type(sc, PangoGlyphString__sym, pango_glyph_string_new()));
}

static s7_pointer lg_pango_glyph_string_set_size(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_glyph_string_set_size "void pango_glyph_string_set_size(PangoGlyphString* string, gint new_len)"
  s7_pointer _p;
  s7_pointer string, new_len;
  _p = args;
  string = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(string, PangoGlyphString__sym)) s7_wrong_type_arg_error(sc, "pango_glyph_string_set_size", 1, string, "PangoGlyphString*");
  new_len = s7_car(_p);
  if (!s7_is_integer(new_len)) s7_wrong_type_arg_error(sc, "pango_glyph_string_set_size", 2, new_len, "gint");
  pango_glyph_string_set_size((PangoGlyphString*)s7_c_pointer(string), (gint)s7_integer(new_len));
  return(lg_false);
}

static s7_pointer lg_pango_glyph_string_copy(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_glyph_string_copy "PangoGlyphString* pango_glyph_string_copy(PangoGlyphString* string)"
  s7_pointer string;
  string = s7_car(args);
  if (!s7_is_c_pointer_of_type(string, PangoGlyphString__sym)) s7_wrong_type_arg_error(sc, "pango_glyph_string_copy", 1, string, "PangoGlyphString*");
  return(lg_make_c_pointer_with_type(sc, PangoGlyphString__sym, pango_glyph_string_copy((PangoGlyphString*)s7_c_pointer(string))));
}

static s7_pointer lg_pango_glyph_string_free(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_glyph_string_free "void pango_glyph_string_free(PangoGlyphString* string)"
  s7_pointer string;
  string = s7_car(args);
  if (!s7_is_c_pointer_of_type(string, PangoGlyphString__sym)) s7_wrong_type_arg_error(sc, "pango_glyph_string_free", 1, string, "PangoGlyphString*");
  pango_glyph_string_free((PangoGlyphString*)s7_c_pointer(string));
  return(lg_false);
}

static s7_pointer lg_pango_glyph_string_extents(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_glyph_string_extents "void pango_glyph_string_extents(PangoGlyphString* glyphs, PangoFont* font, \
PangoRectangle* ink_rect, PangoRectangle* logical_rect)"
  s7_pointer _p;
  s7_pointer glyphs, font, ink_rect, logical_rect;
  _p = args;
  glyphs = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(glyphs, PangoGlyphString__sym)) s7_wrong_type_arg_error(sc, "pango_glyph_string_extents", 1, glyphs, "PangoGlyphString*");
  font = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(font, PangoFont__sym)) s7_wrong_type_arg_error(sc, "pango_glyph_string_extents", 2, font, "PangoFont*");
  ink_rect = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(ink_rect, PangoRectangle__sym)) s7_wrong_type_arg_error(sc, "pango_glyph_string_extents", 3, ink_rect, "PangoRectangle*");
  logical_rect = s7_car(_p);
  if (!s7_is_c_pointer_of_type(logical_rect, PangoRectangle__sym)) s7_wrong_type_arg_error(sc, "pango_glyph_string_extents", 4, logical_rect, "PangoRectangle*");
  pango_glyph_string_extents((PangoGlyphString*)s7_c_pointer(glyphs), (PangoFont*)s7_c_pointer(font), (PangoRectangle*)s7_c_pointer(ink_rect), (PangoRectangle*)s7_c_pointer(logical_rect));
  return(lg_false);
}

static s7_pointer lg_pango_glyph_string_extents_range(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_glyph_string_extents_range "void pango_glyph_string_extents_range(PangoGlyphString* glyphs, \
int start, int end, PangoFont* font, PangoRectangle* ink_rect, PangoRectangle* logical_rect)"
  s7_pointer _p;
  s7_pointer glyphs, start, end, font, ink_rect, logical_rect;
  _p = args;
  glyphs = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(glyphs, PangoGlyphString__sym)) s7_wrong_type_arg_error(sc, "pango_glyph_string_extents_range", 1, glyphs, "PangoGlyphString*");
  start = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(start)) s7_wrong_type_arg_error(sc, "pango_glyph_string_extents_range", 2, start, "int");
  end = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(end)) s7_wrong_type_arg_error(sc, "pango_glyph_string_extents_range", 3, end, "int");
  font = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(font, PangoFont__sym)) s7_wrong_type_arg_error(sc, "pango_glyph_string_extents_range", 4, font, "PangoFont*");
  ink_rect = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(ink_rect, PangoRectangle__sym)) s7_wrong_type_arg_error(sc, "pango_glyph_string_extents_range", 5, ink_rect, "PangoRectangle*");
  logical_rect = s7_car(_p);
  if (!s7_is_c_pointer_of_type(logical_rect, PangoRectangle__sym)) s7_wrong_type_arg_error(sc, "pango_glyph_string_extents_range", 6, logical_rect, "PangoRectangle*");
  pango_glyph_string_extents_range((PangoGlyphString*)s7_c_pointer(glyphs), (int)s7_integer(start), (int)s7_integer(end), (PangoFont*)s7_c_pointer(font), (PangoRectangle*)s7_c_pointer(ink_rect), (PangoRectangle*)s7_c_pointer(logical_rect));
  return(lg_false);
}

static s7_pointer lg_pango_glyph_string_get_logical_widths(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_glyph_string_get_logical_widths "void pango_glyph_string_get_logical_widths(PangoGlyphString* glyphs, \
char* text, int length, int embedding_level, int* [logical_widths])"
  s7_pointer _p;
  s7_pointer glyphs, text, length, embedding_level;
  int ref_logical_widths;
  _p = args;
  glyphs = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(glyphs, PangoGlyphString__sym)) s7_wrong_type_arg_error(sc, "pango_glyph_string_get_logical_widths", 1, glyphs, "PangoGlyphString*");
  text = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(text)) s7_wrong_type_arg_error(sc, "pango_glyph_string_get_logical_widths", 2, text, "char*");
  length = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(length)) s7_wrong_type_arg_error(sc, "pango_glyph_string_get_logical_widths", 3, length, "int");
  embedding_level = s7_car(_p);
  if (!s7_is_integer(embedding_level)) s7_wrong_type_arg_error(sc, "pango_glyph_string_get_logical_widths", 4, embedding_level, "int");
  pango_glyph_string_get_logical_widths((PangoGlyphString*)s7_c_pointer(glyphs), (char*)s7_string(text), (int)s7_integer(length), (int)s7_integer(embedding_level), &ref_logical_widths);
    return(s7_list(sc, 1, s7_make_integer(sc, ref_logical_widths)));
}

static s7_pointer lg_pango_glyph_string_index_to_x(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_glyph_string_index_to_x "void pango_glyph_string_index_to_x(PangoGlyphString* glyphs, \
char* text, int length, PangoAnalysis* analysis, int index, gboolean trailing, int* [x_pos])"
  s7_pointer _p;
  s7_pointer glyphs, text, length, analysis, index, trailing;
  int ref_x_pos;
  _p = args;
  glyphs = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(glyphs, PangoGlyphString__sym)) s7_wrong_type_arg_error(sc, "pango_glyph_string_index_to_x", 1, glyphs, "PangoGlyphString*");
  text = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(text)) s7_wrong_type_arg_error(sc, "pango_glyph_string_index_to_x", 2, text, "char*");
  length = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(length)) s7_wrong_type_arg_error(sc, "pango_glyph_string_index_to_x", 3, length, "int");
  analysis = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(analysis, PangoAnalysis__sym)) s7_wrong_type_arg_error(sc, "pango_glyph_string_index_to_x", 4, analysis, "PangoAnalysis*");
  index = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(index)) s7_wrong_type_arg_error(sc, "pango_glyph_string_index_to_x", 5, index, "int");
  trailing = s7_car(_p);
  if (!s7_is_boolean(trailing)) s7_wrong_type_arg_error(sc, "pango_glyph_string_index_to_x", 6, trailing, "gboolean");
  pango_glyph_string_index_to_x((PangoGlyphString*)s7_c_pointer(glyphs), (char*)s7_string(text), (int)s7_integer(length), (PangoAnalysis*)s7_c_pointer(analysis), (int)s7_integer(index), (gboolean)lg_boolean(trailing), &ref_x_pos);
    return(s7_list(sc, 1, s7_make_integer(sc, ref_x_pos)));
}

static s7_pointer lg_pango_glyph_string_x_to_index(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_glyph_string_x_to_index "void pango_glyph_string_x_to_index(PangoGlyphString* glyphs, \
char* text, int length, PangoAnalysis* analysis, int x_pos, int* [index], int* [trailing])"
  s7_pointer _p;
  s7_pointer glyphs, text, length, analysis, x_pos;
  int ref_index;
  int ref_trailing;
  _p = args;
  glyphs = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(glyphs, PangoGlyphString__sym)) s7_wrong_type_arg_error(sc, "pango_glyph_string_x_to_index", 1, glyphs, "PangoGlyphString*");
  text = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(text)) s7_wrong_type_arg_error(sc, "pango_glyph_string_x_to_index", 2, text, "char*");
  length = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(length)) s7_wrong_type_arg_error(sc, "pango_glyph_string_x_to_index", 3, length, "int");
  analysis = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(analysis, PangoAnalysis__sym)) s7_wrong_type_arg_error(sc, "pango_glyph_string_x_to_index", 4, analysis, "PangoAnalysis*");
  x_pos = s7_car(_p);
  if (!s7_is_integer(x_pos)) s7_wrong_type_arg_error(sc, "pango_glyph_string_x_to_index", 5, x_pos, "int");
  pango_glyph_string_x_to_index((PangoGlyphString*)s7_c_pointer(glyphs), (char*)s7_string(text), (int)s7_integer(length), (PangoAnalysis*)s7_c_pointer(analysis), (int)s7_integer(x_pos), &ref_index, &ref_trailing);
    return(s7_list(sc, 2, s7_make_integer(sc, ref_index), s7_make_integer(sc, ref_trailing)));
}

static s7_pointer lg_pango_shape(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_shape "void pango_shape(gchar* text, gint length, PangoAnalysis* analysis, PangoGlyphString* glyphs)"
  s7_pointer _p;
  s7_pointer text, length, analysis, glyphs;
  _p = args;
  text = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(text)) s7_wrong_type_arg_error(sc, "pango_shape", 1, text, "gchar*");
  length = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(length)) s7_wrong_type_arg_error(sc, "pango_shape", 2, length, "gint");
  analysis = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(analysis, PangoAnalysis__sym)) s7_wrong_type_arg_error(sc, "pango_shape", 3, analysis, "PangoAnalysis*");
  glyphs = s7_car(_p);
  if (!s7_is_c_pointer_of_type(glyphs, PangoGlyphString__sym)) s7_wrong_type_arg_error(sc, "pango_shape", 4, glyphs, "PangoGlyphString*");
  pango_shape((gchar*)s7_string(text), (gint)s7_integer(length), (PangoAnalysis*)s7_c_pointer(analysis), (PangoGlyphString*)s7_c_pointer(glyphs));
  return(lg_false);
}

static s7_pointer lg_pango_reorder_items(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_reorder_items "GList* pango_reorder_items(GList* logical_items)"
  s7_pointer logical_items;
  logical_items = s7_car(args);
  if (!s7_is_c_pointer_of_type(logical_items, GList__sym)) s7_wrong_type_arg_error(sc, "pango_reorder_items", 1, logical_items, "GList*");
  return(lg_make_c_pointer_with_type(sc, GList__sym, pango_reorder_items((GList*)s7_c_pointer(logical_items))));
}

static s7_pointer lg_pango_item_new(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_item_new "PangoItem* pango_item_new( void)"
  return(lg_make_c_pointer_with_type(sc, PangoItem__sym, pango_item_new()));
}

static s7_pointer lg_pango_item_copy(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_item_copy "PangoItem* pango_item_copy(PangoItem* item)"
  s7_pointer item;
  item = s7_car(args);
  if (!s7_is_c_pointer_of_type(item, PangoItem__sym)) s7_wrong_type_arg_error(sc, "pango_item_copy", 1, item, "PangoItem*");
  return(lg_make_c_pointer_with_type(sc, PangoItem__sym, pango_item_copy((PangoItem*)s7_c_pointer(item))));
}

static s7_pointer lg_pango_item_free(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_item_free "void pango_item_free(PangoItem* item)"
  s7_pointer item;
  item = s7_car(args);
  if (!s7_is_c_pointer_of_type(item, PangoItem__sym)) s7_wrong_type_arg_error(sc, "pango_item_free", 1, item, "PangoItem*");
  pango_item_free((PangoItem*)s7_c_pointer(item));
  return(lg_false);
}

static s7_pointer lg_pango_item_split(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_item_split "PangoItem* pango_item_split(PangoItem* orig, int split_index, int split_offset)"
  s7_pointer _p;
  s7_pointer orig, split_index, split_offset;
  _p = args;
  orig = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(orig, PangoItem__sym)) s7_wrong_type_arg_error(sc, "pango_item_split", 1, orig, "PangoItem*");
  split_index = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(split_index)) s7_wrong_type_arg_error(sc, "pango_item_split", 2, split_index, "int");
  split_offset = s7_car(_p);
  if (!s7_is_integer(split_offset)) s7_wrong_type_arg_error(sc, "pango_item_split", 3, split_offset, "int");
  return(lg_make_c_pointer_with_type(sc, PangoItem__sym, pango_item_split((PangoItem*)s7_c_pointer(orig), (int)s7_integer(split_index), (int)s7_integer(split_offset))));
}

static s7_pointer lg_pango_layout_new(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_new "PangoLayout* pango_layout_new(PangoContext* context)"
  s7_pointer context;
  context = s7_car(args);
  if (!s7_is_c_pointer_of_type(context, PangoContext__sym)) s7_wrong_type_arg_error(sc, "pango_layout_new", 1, context, "PangoContext*");
  return(lg_make_c_pointer_with_type(sc, PangoLayout__sym, pango_layout_new((PangoContext*)s7_c_pointer(context))));
}

static s7_pointer lg_pango_layout_copy(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_copy "PangoLayout* pango_layout_copy(PangoLayout* src)"
  s7_pointer src;
  src = s7_car(args);
  if (!s7_is_c_pointer_of_type(src, PangoLayout__sym)) s7_wrong_type_arg_error(sc, "pango_layout_copy", 1, src, "PangoLayout*");
  return(lg_make_c_pointer_with_type(sc, PangoLayout__sym, pango_layout_copy((PangoLayout*)s7_c_pointer(src))));
}

static s7_pointer lg_pango_layout_get_context(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_get_context "PangoContext* pango_layout_get_context(PangoLayout* layout)"
  s7_pointer layout;
  layout = s7_car(args);
  if (!s7_is_c_pointer_of_type(layout, PangoLayout__sym)) s7_wrong_type_arg_error(sc, "pango_layout_get_context", 1, layout, "PangoLayout*");
  return(lg_make_c_pointer_with_type(sc, PangoContext__sym, pango_layout_get_context((PangoLayout*)s7_c_pointer(layout))));
}

static s7_pointer lg_pango_layout_set_attributes(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_set_attributes "void pango_layout_set_attributes(PangoLayout* layout, PangoAttrList* attrs)"
  s7_pointer _p;
  s7_pointer layout, attrs;
  _p = args;
  layout = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(layout, PangoLayout__sym)) s7_wrong_type_arg_error(sc, "pango_layout_set_attributes", 1, layout, "PangoLayout*");
  attrs = s7_car(_p);
  if (!s7_is_c_pointer_of_type(attrs, PangoAttrList__sym)) s7_wrong_type_arg_error(sc, "pango_layout_set_attributes", 2, attrs, "PangoAttrList*");
  pango_layout_set_attributes((PangoLayout*)s7_c_pointer(layout), (PangoAttrList*)s7_c_pointer(attrs));
  return(lg_false);
}

static s7_pointer lg_pango_layout_get_attributes(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_get_attributes "PangoAttrList* pango_layout_get_attributes(PangoLayout* layout)"
  s7_pointer layout;
  layout = s7_car(args);
  if (!s7_is_c_pointer_of_type(layout, PangoLayout__sym)) s7_wrong_type_arg_error(sc, "pango_layout_get_attributes", 1, layout, "PangoLayout*");
  return(lg_make_c_pointer_with_type(sc, PangoAttrList__sym, pango_layout_get_attributes((PangoLayout*)s7_c_pointer(layout))));
}

static s7_pointer lg_pango_layout_set_text(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_set_text "void pango_layout_set_text(PangoLayout* layout, char* text, int length)"
  s7_pointer _p;
  s7_pointer layout, text, length;
  _p = args;
  layout = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(layout, PangoLayout__sym)) s7_wrong_type_arg_error(sc, "pango_layout_set_text", 1, layout, "PangoLayout*");
  text = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(text)) s7_wrong_type_arg_error(sc, "pango_layout_set_text", 2, text, "char*");
  length = s7_car(_p);
  if (!s7_is_integer(length)) s7_wrong_type_arg_error(sc, "pango_layout_set_text", 3, length, "int");
  pango_layout_set_text((PangoLayout*)s7_c_pointer(layout), (char*)s7_string(text), (int)s7_integer(length));
  return(lg_false);
}

static s7_pointer lg_pango_layout_get_text(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_get_text "char* pango_layout_get_text(PangoLayout* layout)"
  s7_pointer layout;
  layout = s7_car(args);
  if (!s7_is_c_pointer_of_type(layout, PangoLayout__sym)) s7_wrong_type_arg_error(sc, "pango_layout_get_text", 1, layout, "PangoLayout*");
  return(s7_make_string(sc, pango_layout_get_text((PangoLayout*)s7_c_pointer(layout))));
}

static s7_pointer lg_pango_layout_set_markup(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_set_markup "void pango_layout_set_markup(PangoLayout* layout, char* markup, \
int length)"
  s7_pointer _p;
  s7_pointer layout, markup, length;
  _p = args;
  layout = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(layout, PangoLayout__sym)) s7_wrong_type_arg_error(sc, "pango_layout_set_markup", 1, layout, "PangoLayout*");
  markup = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(markup)) s7_wrong_type_arg_error(sc, "pango_layout_set_markup", 2, markup, "char*");
  length = s7_car(_p);
  if (!s7_is_integer(length)) s7_wrong_type_arg_error(sc, "pango_layout_set_markup", 3, length, "int");
  pango_layout_set_markup((PangoLayout*)s7_c_pointer(layout), (char*)s7_string(markup), (int)s7_integer(length));
  return(lg_false);
}

static s7_pointer lg_pango_layout_set_markup_with_accel(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_set_markup_with_accel "void pango_layout_set_markup_with_accel(PangoLayout* layout, \
char* markup, int length, gunichar accel_marker, gunichar* accel_char)"
  s7_pointer _p;
  s7_pointer layout, markup, length, accel_marker, accel_char;
  _p = args;
  layout = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(layout, PangoLayout__sym)) s7_wrong_type_arg_error(sc, "pango_layout_set_markup_with_accel", 1, layout, "PangoLayout*");
  markup = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(markup)) s7_wrong_type_arg_error(sc, "pango_layout_set_markup_with_accel", 2, markup, "char*");
  length = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(length)) s7_wrong_type_arg_error(sc, "pango_layout_set_markup_with_accel", 3, length, "int");
  accel_marker = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(accel_marker)) s7_wrong_type_arg_error(sc, "pango_layout_set_markup_with_accel", 4, accel_marker, "gunichar");
  accel_char = s7_car(_p);
  if (!s7_is_c_pointer_of_type(accel_char, gunichar__sym)) s7_wrong_type_arg_error(sc, "pango_layout_set_markup_with_accel", 5, accel_char, "gunichar*");
  pango_layout_set_markup_with_accel((PangoLayout*)s7_c_pointer(layout), (char*)s7_string(markup), (int)s7_integer(length), (gunichar)s7_integer(accel_marker), (gunichar*)s7_c_pointer(accel_char));
  return(lg_false);
}

static s7_pointer lg_pango_layout_set_font_description(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_set_font_description "void pango_layout_set_font_description(PangoLayout* layout, \
PangoFontDescription* desc)"
  s7_pointer _p;
  s7_pointer layout, desc;
  _p = args;
  layout = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(layout, PangoLayout__sym)) s7_wrong_type_arg_error(sc, "pango_layout_set_font_description", 1, layout, "PangoLayout*");
  desc = s7_car(_p);
  if (!s7_is_c_pointer_of_type(desc, PangoFontDescription__sym)) s7_wrong_type_arg_error(sc, "pango_layout_set_font_description", 2, desc, "PangoFontDescription*");
  pango_layout_set_font_description((PangoLayout*)s7_c_pointer(layout), (PangoFontDescription*)s7_c_pointer(desc));
  return(lg_false);
}

static s7_pointer lg_pango_layout_set_width(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_set_width "void pango_layout_set_width(PangoLayout* layout, int width)"
  s7_pointer _p;
  s7_pointer layout, width;
  _p = args;
  layout = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(layout, PangoLayout__sym)) s7_wrong_type_arg_error(sc, "pango_layout_set_width", 1, layout, "PangoLayout*");
  width = s7_car(_p);
  if (!s7_is_integer(width)) s7_wrong_type_arg_error(sc, "pango_layout_set_width", 2, width, "int");
  pango_layout_set_width((PangoLayout*)s7_c_pointer(layout), (int)s7_integer(width));
  return(lg_false);
}

static s7_pointer lg_pango_layout_get_width(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_get_width "int pango_layout_get_width(PangoLayout* layout)"
  s7_pointer layout;
  layout = s7_car(args);
  if (!s7_is_c_pointer_of_type(layout, PangoLayout__sym)) s7_wrong_type_arg_error(sc, "pango_layout_get_width", 1, layout, "PangoLayout*");
  return(s7_make_integer(sc, pango_layout_get_width((PangoLayout*)s7_c_pointer(layout))));
}

static s7_pointer lg_pango_layout_set_wrap(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_set_wrap "void pango_layout_set_wrap(PangoLayout* layout, PangoWrapMode wrap)"
  s7_pointer _p;
  s7_pointer layout, wrap;
  _p = args;
  layout = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(layout, PangoLayout__sym)) s7_wrong_type_arg_error(sc, "pango_layout_set_wrap", 1, layout, "PangoLayout*");
  wrap = s7_car(_p);
  if (!s7_is_integer(wrap)) s7_wrong_type_arg_error(sc, "pango_layout_set_wrap", 2, wrap, "PangoWrapMode");
  pango_layout_set_wrap((PangoLayout*)s7_c_pointer(layout), (PangoWrapMode)s7_integer(wrap));
  return(lg_false);
}

static s7_pointer lg_pango_layout_get_wrap(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_get_wrap "PangoWrapMode pango_layout_get_wrap(PangoLayout* layout)"
  s7_pointer layout;
  layout = s7_car(args);
  if (!s7_is_c_pointer_of_type(layout, PangoLayout__sym)) s7_wrong_type_arg_error(sc, "pango_layout_get_wrap", 1, layout, "PangoLayout*");
  return(s7_make_integer(sc, pango_layout_get_wrap((PangoLayout*)s7_c_pointer(layout))));
}

static s7_pointer lg_pango_layout_set_indent(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_set_indent "void pango_layout_set_indent(PangoLayout* layout, int indent)"
  s7_pointer _p;
  s7_pointer layout, indent;
  _p = args;
  layout = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(layout, PangoLayout__sym)) s7_wrong_type_arg_error(sc, "pango_layout_set_indent", 1, layout, "PangoLayout*");
  indent = s7_car(_p);
  if (!s7_is_integer(indent)) s7_wrong_type_arg_error(sc, "pango_layout_set_indent", 2, indent, "int");
  pango_layout_set_indent((PangoLayout*)s7_c_pointer(layout), (int)s7_integer(indent));
  return(lg_false);
}

static s7_pointer lg_pango_layout_get_indent(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_get_indent "int pango_layout_get_indent(PangoLayout* layout)"
  s7_pointer layout;
  layout = s7_car(args);
  if (!s7_is_c_pointer_of_type(layout, PangoLayout__sym)) s7_wrong_type_arg_error(sc, "pango_layout_get_indent", 1, layout, "PangoLayout*");
  return(s7_make_integer(sc, pango_layout_get_indent((PangoLayout*)s7_c_pointer(layout))));
}

static s7_pointer lg_pango_layout_set_spacing(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_set_spacing "void pango_layout_set_spacing(PangoLayout* layout, int spacing)"
  s7_pointer _p;
  s7_pointer layout, spacing;
  _p = args;
  layout = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(layout, PangoLayout__sym)) s7_wrong_type_arg_error(sc, "pango_layout_set_spacing", 1, layout, "PangoLayout*");
  spacing = s7_car(_p);
  if (!s7_is_integer(spacing)) s7_wrong_type_arg_error(sc, "pango_layout_set_spacing", 2, spacing, "int");
  pango_layout_set_spacing((PangoLayout*)s7_c_pointer(layout), (int)s7_integer(spacing));
  return(lg_false);
}

static s7_pointer lg_pango_layout_get_spacing(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_get_spacing "int pango_layout_get_spacing(PangoLayout* layout)"
  s7_pointer layout;
  layout = s7_car(args);
  if (!s7_is_c_pointer_of_type(layout, PangoLayout__sym)) s7_wrong_type_arg_error(sc, "pango_layout_get_spacing", 1, layout, "PangoLayout*");
  return(s7_make_integer(sc, pango_layout_get_spacing((PangoLayout*)s7_c_pointer(layout))));
}

static s7_pointer lg_pango_layout_set_justify(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_set_justify "void pango_layout_set_justify(PangoLayout* layout, gboolean justify)"
  s7_pointer _p;
  s7_pointer layout, justify;
  _p = args;
  layout = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(layout, PangoLayout__sym)) s7_wrong_type_arg_error(sc, "pango_layout_set_justify", 1, layout, "PangoLayout*");
  justify = s7_car(_p);
  if (!s7_is_boolean(justify)) s7_wrong_type_arg_error(sc, "pango_layout_set_justify", 2, justify, "gboolean");
  pango_layout_set_justify((PangoLayout*)s7_c_pointer(layout), (gboolean)lg_boolean(justify));
  return(lg_false);
}

static s7_pointer lg_pango_layout_get_justify(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_get_justify "gboolean pango_layout_get_justify(PangoLayout* layout)"
  s7_pointer layout;
  layout = s7_car(args);
  if (!s7_is_c_pointer_of_type(layout, PangoLayout__sym)) s7_wrong_type_arg_error(sc, "pango_layout_get_justify", 1, layout, "PangoLayout*");
  return(s7_make_boolean(sc, pango_layout_get_justify((PangoLayout*)s7_c_pointer(layout))));
}

static s7_pointer lg_pango_layout_set_alignment(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_set_alignment "void pango_layout_set_alignment(PangoLayout* layout, PangoAlignment alignment)"
  s7_pointer _p;
  s7_pointer layout, alignment;
  _p = args;
  layout = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(layout, PangoLayout__sym)) s7_wrong_type_arg_error(sc, "pango_layout_set_alignment", 1, layout, "PangoLayout*");
  alignment = s7_car(_p);
  if (!s7_is_integer(alignment)) s7_wrong_type_arg_error(sc, "pango_layout_set_alignment", 2, alignment, "PangoAlignment");
  pango_layout_set_alignment((PangoLayout*)s7_c_pointer(layout), (PangoAlignment)s7_integer(alignment));
  return(lg_false);
}

static s7_pointer lg_pango_layout_get_alignment(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_get_alignment "PangoAlignment pango_layout_get_alignment(PangoLayout* layout)"
  s7_pointer layout;
  layout = s7_car(args);
  if (!s7_is_c_pointer_of_type(layout, PangoLayout__sym)) s7_wrong_type_arg_error(sc, "pango_layout_get_alignment", 1, layout, "PangoLayout*");
  return(s7_make_integer(sc, pango_layout_get_alignment((PangoLayout*)s7_c_pointer(layout))));
}

static s7_pointer lg_pango_layout_set_tabs(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_set_tabs "void pango_layout_set_tabs(PangoLayout* layout, PangoTabArray* tabs)"
  s7_pointer _p;
  s7_pointer layout, tabs;
  _p = args;
  layout = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(layout, PangoLayout__sym)) s7_wrong_type_arg_error(sc, "pango_layout_set_tabs", 1, layout, "PangoLayout*");
  tabs = s7_car(_p);
  if ((!s7_is_c_pointer_of_type(tabs, PangoTabArray__sym)) && (tabs != lg_false)) s7_wrong_type_arg_error(sc, "pango_layout_set_tabs", 2, tabs, "PangoTabArray*");
  pango_layout_set_tabs((PangoLayout*)s7_c_pointer(layout), (PangoTabArray*)s7_c_pointer(tabs));
  return(lg_false);
}

static s7_pointer lg_pango_layout_get_tabs(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_get_tabs "PangoTabArray* pango_layout_get_tabs(PangoLayout* layout)"
  s7_pointer layout;
  layout = s7_car(args);
  if (!s7_is_c_pointer_of_type(layout, PangoLayout__sym)) s7_wrong_type_arg_error(sc, "pango_layout_get_tabs", 1, layout, "PangoLayout*");
  return(lg_make_c_pointer_with_type(sc, PangoTabArray__sym, pango_layout_get_tabs((PangoLayout*)s7_c_pointer(layout))));
}

static s7_pointer lg_pango_layout_set_single_paragraph_mode(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_set_single_paragraph_mode "void pango_layout_set_single_paragraph_mode(PangoLayout* layout, \
gboolean setting)"
  s7_pointer _p;
  s7_pointer layout, setting;
  _p = args;
  layout = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(layout, PangoLayout__sym)) s7_wrong_type_arg_error(sc, "pango_layout_set_single_paragraph_mode", 1, layout, "PangoLayout*");
  setting = s7_car(_p);
  if (!s7_is_boolean(setting)) s7_wrong_type_arg_error(sc, "pango_layout_set_single_paragraph_mode", 2, setting, "gboolean");
  pango_layout_set_single_paragraph_mode((PangoLayout*)s7_c_pointer(layout), (gboolean)lg_boolean(setting));
  return(lg_false);
}

static s7_pointer lg_pango_layout_get_single_paragraph_mode(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_get_single_paragraph_mode "gboolean pango_layout_get_single_paragraph_mode(PangoLayout* layout)"
  s7_pointer layout;
  layout = s7_car(args);
  if (!s7_is_c_pointer_of_type(layout, PangoLayout__sym)) s7_wrong_type_arg_error(sc, "pango_layout_get_single_paragraph_mode", 1, layout, "PangoLayout*");
  return(s7_make_boolean(sc, pango_layout_get_single_paragraph_mode((PangoLayout*)s7_c_pointer(layout))));
}

static s7_pointer lg_pango_layout_context_changed(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_context_changed "void pango_layout_context_changed(PangoLayout* layout)"
  s7_pointer layout;
  layout = s7_car(args);
  if (!s7_is_c_pointer_of_type(layout, PangoLayout__sym)) s7_wrong_type_arg_error(sc, "pango_layout_context_changed", 1, layout, "PangoLayout*");
  pango_layout_context_changed((PangoLayout*)s7_c_pointer(layout));
  return(lg_false);
}

static s7_pointer lg_pango_layout_get_log_attrs(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_get_log_attrs "void pango_layout_get_log_attrs(PangoLayout* layout, PangoLogAttr** [attrs], \
gint* [n_attrs])"
  s7_pointer _p;
  s7_pointer layout;
  PangoLogAttr* ref_attrs = NULL;
  gint ref_n_attrs;
  _p = args;
  layout = s7_car(_p);
  if (!s7_is_c_pointer_of_type(layout, PangoLayout__sym)) s7_wrong_type_arg_error(sc, "pango_layout_get_log_attrs", 1, layout, "PangoLayout*");
  pango_layout_get_log_attrs((PangoLayout*)s7_c_pointer(layout), &ref_attrs, &ref_n_attrs);
    return(s7_list(sc, 2, s7_make_c_pointer(sc, ref_attrs), s7_make_integer(sc, ref_n_attrs)));
}

static s7_pointer lg_pango_layout_index_to_pos(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_index_to_pos "void pango_layout_index_to_pos(PangoLayout* layout, int index, \
PangoRectangle* pos)"
  s7_pointer _p;
  s7_pointer layout, index, pos;
  _p = args;
  layout = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(layout, PangoLayout__sym)) s7_wrong_type_arg_error(sc, "pango_layout_index_to_pos", 1, layout, "PangoLayout*");
  index = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(index)) s7_wrong_type_arg_error(sc, "pango_layout_index_to_pos", 2, index, "int");
  pos = s7_car(_p);
  if (!s7_is_c_pointer_of_type(pos, PangoRectangle__sym)) s7_wrong_type_arg_error(sc, "pango_layout_index_to_pos", 3, pos, "PangoRectangle*");
  pango_layout_index_to_pos((PangoLayout*)s7_c_pointer(layout), (int)s7_integer(index), (PangoRectangle*)s7_c_pointer(pos));
  return(lg_false);
}

static s7_pointer lg_pango_layout_get_cursor_pos(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_get_cursor_pos "void pango_layout_get_cursor_pos(PangoLayout* layout, int index, \
PangoRectangle* strong_pos, PangoRectangle* weak_pos)"
  s7_pointer _p;
  s7_pointer layout, index, strong_pos, weak_pos;
  _p = args;
  layout = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(layout, PangoLayout__sym)) s7_wrong_type_arg_error(sc, "pango_layout_get_cursor_pos", 1, layout, "PangoLayout*");
  index = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(index)) s7_wrong_type_arg_error(sc, "pango_layout_get_cursor_pos", 2, index, "int");
  strong_pos = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(strong_pos, PangoRectangle__sym)) s7_wrong_type_arg_error(sc, "pango_layout_get_cursor_pos", 3, strong_pos, "PangoRectangle*");
  weak_pos = s7_car(_p);
  if (!s7_is_c_pointer_of_type(weak_pos, PangoRectangle__sym)) s7_wrong_type_arg_error(sc, "pango_layout_get_cursor_pos", 4, weak_pos, "PangoRectangle*");
  pango_layout_get_cursor_pos((PangoLayout*)s7_c_pointer(layout), (int)s7_integer(index), (PangoRectangle*)s7_c_pointer(strong_pos), (PangoRectangle*)s7_c_pointer(weak_pos));
  return(lg_false);
}

static s7_pointer lg_pango_layout_move_cursor_visually(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_move_cursor_visually "void pango_layout_move_cursor_visually(PangoLayout* layout, \
gboolean strong, int old_index, int old_trailing, int direction, int* new_index, int* new_trailing)"
  s7_pointer _p;
  s7_pointer layout, strong, old_index, old_trailing, direction, new_index, new_trailing;
  _p = args;
  layout = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(layout, PangoLayout__sym)) s7_wrong_type_arg_error(sc, "pango_layout_move_cursor_visually", 1, layout, "PangoLayout*");
  strong = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_boolean(strong)) s7_wrong_type_arg_error(sc, "pango_layout_move_cursor_visually", 2, strong, "gboolean");
  old_index = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(old_index)) s7_wrong_type_arg_error(sc, "pango_layout_move_cursor_visually", 3, old_index, "int");
  old_trailing = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(old_trailing)) s7_wrong_type_arg_error(sc, "pango_layout_move_cursor_visually", 4, old_trailing, "int");
  direction = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(direction)) s7_wrong_type_arg_error(sc, "pango_layout_move_cursor_visually", 5, direction, "int");
  new_index = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(new_index, int__sym)) s7_wrong_type_arg_error(sc, "pango_layout_move_cursor_visually", 6, new_index, "int*");
  new_trailing = s7_car(_p);
  if (!s7_is_c_pointer_of_type(new_trailing, int__sym)) s7_wrong_type_arg_error(sc, "pango_layout_move_cursor_visually", 7, new_trailing, "int*");
  pango_layout_move_cursor_visually((PangoLayout*)s7_c_pointer(layout), (gboolean)lg_boolean(strong), (int)s7_integer(old_index), (int)s7_integer(old_trailing), (int)s7_integer(direction), (int*)s7_c_pointer(new_index), (int*)s7_c_pointer(new_trailing));
  return(lg_false);
}

static s7_pointer lg_pango_layout_xy_to_index(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_xy_to_index "gboolean pango_layout_xy_to_index(PangoLayout* layout, int x, int y, \
int* [index], int* [trailing])"
  s7_pointer _p;
  s7_pointer layout, x, y;
  int ref_index;
  int ref_trailing;
  _p = args;
  layout = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(layout, PangoLayout__sym)) s7_wrong_type_arg_error(sc, "pango_layout_xy_to_index", 1, layout, "PangoLayout*");
  x = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(x)) s7_wrong_type_arg_error(sc, "pango_layout_xy_to_index", 2, x, "int");
  y = s7_car(_p);
  if (!s7_is_integer(y)) s7_wrong_type_arg_error(sc, "pango_layout_xy_to_index", 3, y, "int");
  {
    s7_pointer res_ult;
    res_ult = s7_make_boolean(sc, pango_layout_xy_to_index((PangoLayout*)s7_c_pointer(layout), (int)s7_integer(x), (int)s7_integer(y), &ref_index, &ref_trailing));
      return(s7_list(sc, 3, res_ult, s7_make_integer(sc, ref_index), s7_make_integer(sc, ref_trailing)));
   }
}

static s7_pointer lg_pango_layout_get_extents(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_get_extents "void pango_layout_get_extents(PangoLayout* layout, PangoRectangle* ink_rect, \
PangoRectangle* logical_rect)"
  s7_pointer _p;
  s7_pointer layout, ink_rect, logical_rect;
  _p = args;
  layout = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(layout, PangoLayout__sym)) s7_wrong_type_arg_error(sc, "pango_layout_get_extents", 1, layout, "PangoLayout*");
  ink_rect = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(ink_rect, PangoRectangle__sym)) s7_wrong_type_arg_error(sc, "pango_layout_get_extents", 2, ink_rect, "PangoRectangle*");
  logical_rect = s7_car(_p);
  if (!s7_is_c_pointer_of_type(logical_rect, PangoRectangle__sym)) s7_wrong_type_arg_error(sc, "pango_layout_get_extents", 3, logical_rect, "PangoRectangle*");
  pango_layout_get_extents((PangoLayout*)s7_c_pointer(layout), (PangoRectangle*)s7_c_pointer(ink_rect), (PangoRectangle*)s7_c_pointer(logical_rect));
  return(lg_false);
}

static s7_pointer lg_pango_layout_get_pixel_extents(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_get_pixel_extents "void pango_layout_get_pixel_extents(PangoLayout* layout, \
PangoRectangle* ink_rect, PangoRectangle* logical_rect)"
  s7_pointer _p;
  s7_pointer layout, ink_rect, logical_rect;
  _p = args;
  layout = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(layout, PangoLayout__sym)) s7_wrong_type_arg_error(sc, "pango_layout_get_pixel_extents", 1, layout, "PangoLayout*");
  ink_rect = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(ink_rect, PangoRectangle__sym)) s7_wrong_type_arg_error(sc, "pango_layout_get_pixel_extents", 2, ink_rect, "PangoRectangle*");
  logical_rect = s7_car(_p);
  if (!s7_is_c_pointer_of_type(logical_rect, PangoRectangle__sym)) s7_wrong_type_arg_error(sc, "pango_layout_get_pixel_extents", 3, logical_rect, "PangoRectangle*");
  pango_layout_get_pixel_extents((PangoLayout*)s7_c_pointer(layout), (PangoRectangle*)s7_c_pointer(ink_rect), (PangoRectangle*)s7_c_pointer(logical_rect));
  return(lg_false);
}

static s7_pointer lg_pango_layout_get_size(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_get_size "void pango_layout_get_size(PangoLayout* layout, int* [width], int* [height])"
  s7_pointer _p;
  s7_pointer layout;
  int ref_width;
  int ref_height;
  _p = args;
  layout = s7_car(_p);
  if (!s7_is_c_pointer_of_type(layout, PangoLayout__sym)) s7_wrong_type_arg_error(sc, "pango_layout_get_size", 1, layout, "PangoLayout*");
  pango_layout_get_size((PangoLayout*)s7_c_pointer(layout), &ref_width, &ref_height);
    return(s7_list(sc, 2, s7_make_integer(sc, ref_width), s7_make_integer(sc, ref_height)));
}

static s7_pointer lg_pango_layout_get_pixel_size(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_get_pixel_size "void pango_layout_get_pixel_size(PangoLayout* layout, int* [width], \
int* [height])"
  s7_pointer _p;
  s7_pointer layout;
  int ref_width;
  int ref_height;
  _p = args;
  layout = s7_car(_p);
  if (!s7_is_c_pointer_of_type(layout, PangoLayout__sym)) s7_wrong_type_arg_error(sc, "pango_layout_get_pixel_size", 1, layout, "PangoLayout*");
  pango_layout_get_pixel_size((PangoLayout*)s7_c_pointer(layout), &ref_width, &ref_height);
    return(s7_list(sc, 2, s7_make_integer(sc, ref_width), s7_make_integer(sc, ref_height)));
}

static s7_pointer lg_pango_layout_get_line_count(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_get_line_count "int pango_layout_get_line_count(PangoLayout* layout)"
  s7_pointer layout;
  layout = s7_car(args);
  if (!s7_is_c_pointer_of_type(layout, PangoLayout__sym)) s7_wrong_type_arg_error(sc, "pango_layout_get_line_count", 1, layout, "PangoLayout*");
  return(s7_make_integer(sc, pango_layout_get_line_count((PangoLayout*)s7_c_pointer(layout))));
}

static s7_pointer lg_pango_layout_get_line(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_get_line "PangoLayoutLine* pango_layout_get_line(PangoLayout* layout, int line)"
  s7_pointer _p;
  s7_pointer layout, line;
  _p = args;
  layout = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(layout, PangoLayout__sym)) s7_wrong_type_arg_error(sc, "pango_layout_get_line", 1, layout, "PangoLayout*");
  line = s7_car(_p);
  if (!s7_is_integer(line)) s7_wrong_type_arg_error(sc, "pango_layout_get_line", 2, line, "int");
  return(lg_make_c_pointer_with_type(sc, PangoLayoutLine__sym, pango_layout_get_line((PangoLayout*)s7_c_pointer(layout), (int)s7_integer(line))));
}

static s7_pointer lg_pango_layout_get_lines(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_get_lines "GSList* pango_layout_get_lines(PangoLayout* layout)"
  s7_pointer layout;
  layout = s7_car(args);
  if (!s7_is_c_pointer_of_type(layout, PangoLayout__sym)) s7_wrong_type_arg_error(sc, "pango_layout_get_lines", 1, layout, "PangoLayout*");
  return(lg_make_c_pointer_with_type(sc, GSList__sym, pango_layout_get_lines((PangoLayout*)s7_c_pointer(layout))));
}

static s7_pointer lg_pango_layout_line_unref(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_line_unref "void pango_layout_line_unref(PangoLayoutLine* line)"
  s7_pointer line;
  line = s7_car(args);
  if (!s7_is_c_pointer_of_type(line, PangoLayoutLine__sym)) s7_wrong_type_arg_error(sc, "pango_layout_line_unref", 1, line, "PangoLayoutLine*");
  pango_layout_line_unref((PangoLayoutLine*)s7_c_pointer(line));
  return(lg_false);
}

static s7_pointer lg_pango_layout_line_x_to_index(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_line_x_to_index "gboolean pango_layout_line_x_to_index(PangoLayoutLine* line, \
int x_pos, int* [index], int* [trailing])"
  s7_pointer _p;
  s7_pointer line, x_pos;
  int ref_index;
  int ref_trailing;
  _p = args;
  line = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(line, PangoLayoutLine__sym)) s7_wrong_type_arg_error(sc, "pango_layout_line_x_to_index", 1, line, "PangoLayoutLine*");
  x_pos = s7_car(_p);
  if (!s7_is_integer(x_pos)) s7_wrong_type_arg_error(sc, "pango_layout_line_x_to_index", 2, x_pos, "int");
  {
    s7_pointer res_ult;
    res_ult = s7_make_boolean(sc, pango_layout_line_x_to_index((PangoLayoutLine*)s7_c_pointer(line), (int)s7_integer(x_pos), &ref_index, &ref_trailing));
      return(s7_list(sc, 3, res_ult, s7_make_integer(sc, ref_index), s7_make_integer(sc, ref_trailing)));
   }
}

static s7_pointer lg_pango_layout_line_index_to_x(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_line_index_to_x "void pango_layout_line_index_to_x(PangoLayoutLine* line, int index, \
gboolean trailing, int* [x_pos])"
  s7_pointer _p;
  s7_pointer line, index, trailing;
  int ref_x_pos;
  _p = args;
  line = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(line, PangoLayoutLine__sym)) s7_wrong_type_arg_error(sc, "pango_layout_line_index_to_x", 1, line, "PangoLayoutLine*");
  index = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(index)) s7_wrong_type_arg_error(sc, "pango_layout_line_index_to_x", 2, index, "int");
  trailing = s7_car(_p);
  if (!s7_is_boolean(trailing)) s7_wrong_type_arg_error(sc, "pango_layout_line_index_to_x", 3, trailing, "gboolean");
  pango_layout_line_index_to_x((PangoLayoutLine*)s7_c_pointer(line), (int)s7_integer(index), (gboolean)lg_boolean(trailing), &ref_x_pos);
    return(s7_list(sc, 1, s7_make_integer(sc, ref_x_pos)));
}

static s7_pointer lg_pango_layout_line_get_x_ranges(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_line_get_x_ranges "void pango_layout_line_get_x_ranges(PangoLayoutLine* line, \
int start_index, int end_index, int** [ranges], int* [n_ranges])"
  s7_pointer _p;
  s7_pointer line, start_index, end_index;
  int* ref_ranges = NULL;
  int ref_n_ranges;
  _p = args;
  line = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(line, PangoLayoutLine__sym)) s7_wrong_type_arg_error(sc, "pango_layout_line_get_x_ranges", 1, line, "PangoLayoutLine*");
  start_index = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(start_index)) s7_wrong_type_arg_error(sc, "pango_layout_line_get_x_ranges", 2, start_index, "int");
  end_index = s7_car(_p);
  if (!s7_is_integer(end_index)) s7_wrong_type_arg_error(sc, "pango_layout_line_get_x_ranges", 3, end_index, "int");
  pango_layout_line_get_x_ranges((PangoLayoutLine*)s7_c_pointer(line), (int)s7_integer(start_index), (int)s7_integer(end_index), &ref_ranges, &ref_n_ranges);
    return(s7_list(sc, 2, s7_make_c_pointer(sc, ref_ranges), s7_make_integer(sc, ref_n_ranges)));
}

static s7_pointer lg_pango_layout_line_get_extents(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_line_get_extents "void pango_layout_line_get_extents(PangoLayoutLine* line, \
PangoRectangle* ink_rect, PangoRectangle* logical_rect)"
  s7_pointer _p;
  s7_pointer line, ink_rect, logical_rect;
  _p = args;
  line = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(line, PangoLayoutLine__sym)) s7_wrong_type_arg_error(sc, "pango_layout_line_get_extents", 1, line, "PangoLayoutLine*");
  ink_rect = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(ink_rect, PangoRectangle__sym)) s7_wrong_type_arg_error(sc, "pango_layout_line_get_extents", 2, ink_rect, "PangoRectangle*");
  logical_rect = s7_car(_p);
  if (!s7_is_c_pointer_of_type(logical_rect, PangoRectangle__sym)) s7_wrong_type_arg_error(sc, "pango_layout_line_get_extents", 3, logical_rect, "PangoRectangle*");
  pango_layout_line_get_extents((PangoLayoutLine*)s7_c_pointer(line), (PangoRectangle*)s7_c_pointer(ink_rect), (PangoRectangle*)s7_c_pointer(logical_rect));
  return(lg_false);
}

static s7_pointer lg_pango_layout_line_get_pixel_extents(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_line_get_pixel_extents "void pango_layout_line_get_pixel_extents(PangoLayoutLine* layout_line, \
PangoRectangle* ink_rect, PangoRectangle* logical_rect)"
  s7_pointer _p;
  s7_pointer layout_line, ink_rect, logical_rect;
  _p = args;
  layout_line = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(layout_line, PangoLayoutLine__sym)) s7_wrong_type_arg_error(sc, "pango_layout_line_get_pixel_extents", 1, layout_line, "PangoLayoutLine*");
  ink_rect = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(ink_rect, PangoRectangle__sym)) s7_wrong_type_arg_error(sc, "pango_layout_line_get_pixel_extents", 2, ink_rect, "PangoRectangle*");
  logical_rect = s7_car(_p);
  if (!s7_is_c_pointer_of_type(logical_rect, PangoRectangle__sym)) s7_wrong_type_arg_error(sc, "pango_layout_line_get_pixel_extents", 3, logical_rect, "PangoRectangle*");
  pango_layout_line_get_pixel_extents((PangoLayoutLine*)s7_c_pointer(layout_line), (PangoRectangle*)s7_c_pointer(ink_rect), (PangoRectangle*)s7_c_pointer(logical_rect));
  return(lg_false);
}

static s7_pointer lg_pango_layout_get_iter(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_get_iter "PangoLayoutIter* pango_layout_get_iter(PangoLayout* layout)"
  s7_pointer layout;
  layout = s7_car(args);
  if (!s7_is_c_pointer_of_type(layout, PangoLayout__sym)) s7_wrong_type_arg_error(sc, "pango_layout_get_iter", 1, layout, "PangoLayout*");
  return(lg_make_c_pointer_with_type(sc, PangoLayoutIter__sym, pango_layout_get_iter((PangoLayout*)s7_c_pointer(layout))));
}

static s7_pointer lg_pango_layout_iter_free(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_iter_free "void pango_layout_iter_free(PangoLayoutIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  if (!s7_is_c_pointer_of_type(iter, PangoLayoutIter__sym)) s7_wrong_type_arg_error(sc, "pango_layout_iter_free", 1, iter, "PangoLayoutIter*");
  pango_layout_iter_free((PangoLayoutIter*)s7_c_pointer(iter));
  return(lg_false);
}

static s7_pointer lg_pango_layout_iter_get_index(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_iter_get_index "int pango_layout_iter_get_index(PangoLayoutIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  if (!s7_is_c_pointer_of_type(iter, PangoLayoutIter__sym)) s7_wrong_type_arg_error(sc, "pango_layout_iter_get_index", 1, iter, "PangoLayoutIter*");
  return(s7_make_integer(sc, pango_layout_iter_get_index((PangoLayoutIter*)s7_c_pointer(iter))));
}

static s7_pointer lg_pango_layout_iter_get_run(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_iter_get_run "PangoLayoutRun* pango_layout_iter_get_run(PangoLayoutIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  if (!s7_is_c_pointer_of_type(iter, PangoLayoutIter__sym)) s7_wrong_type_arg_error(sc, "pango_layout_iter_get_run", 1, iter, "PangoLayoutIter*");
  return(lg_make_c_pointer_with_type(sc, PangoLayoutRun__sym, pango_layout_iter_get_run((PangoLayoutIter*)s7_c_pointer(iter))));
}

static s7_pointer lg_pango_layout_iter_get_line(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_iter_get_line "PangoLayoutLine* pango_layout_iter_get_line(PangoLayoutIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  if (!s7_is_c_pointer_of_type(iter, PangoLayoutIter__sym)) s7_wrong_type_arg_error(sc, "pango_layout_iter_get_line", 1, iter, "PangoLayoutIter*");
  return(lg_make_c_pointer_with_type(sc, PangoLayoutLine__sym, pango_layout_iter_get_line((PangoLayoutIter*)s7_c_pointer(iter))));
}

static s7_pointer lg_pango_layout_iter_at_last_line(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_iter_at_last_line "gboolean pango_layout_iter_at_last_line(PangoLayoutIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  if (!s7_is_c_pointer_of_type(iter, PangoLayoutIter__sym)) s7_wrong_type_arg_error(sc, "pango_layout_iter_at_last_line", 1, iter, "PangoLayoutIter*");
  return(s7_make_boolean(sc, pango_layout_iter_at_last_line((PangoLayoutIter*)s7_c_pointer(iter))));
}

static s7_pointer lg_pango_layout_iter_next_char(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_iter_next_char "gboolean pango_layout_iter_next_char(PangoLayoutIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  if (!s7_is_c_pointer_of_type(iter, PangoLayoutIter__sym)) s7_wrong_type_arg_error(sc, "pango_layout_iter_next_char", 1, iter, "PangoLayoutIter*");
  return(s7_make_boolean(sc, pango_layout_iter_next_char((PangoLayoutIter*)s7_c_pointer(iter))));
}

static s7_pointer lg_pango_layout_iter_next_cluster(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_iter_next_cluster "gboolean pango_layout_iter_next_cluster(PangoLayoutIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  if (!s7_is_c_pointer_of_type(iter, PangoLayoutIter__sym)) s7_wrong_type_arg_error(sc, "pango_layout_iter_next_cluster", 1, iter, "PangoLayoutIter*");
  return(s7_make_boolean(sc, pango_layout_iter_next_cluster((PangoLayoutIter*)s7_c_pointer(iter))));
}

static s7_pointer lg_pango_layout_iter_next_run(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_iter_next_run "gboolean pango_layout_iter_next_run(PangoLayoutIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  if (!s7_is_c_pointer_of_type(iter, PangoLayoutIter__sym)) s7_wrong_type_arg_error(sc, "pango_layout_iter_next_run", 1, iter, "PangoLayoutIter*");
  return(s7_make_boolean(sc, pango_layout_iter_next_run((PangoLayoutIter*)s7_c_pointer(iter))));
}

static s7_pointer lg_pango_layout_iter_next_line(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_iter_next_line "gboolean pango_layout_iter_next_line(PangoLayoutIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  if (!s7_is_c_pointer_of_type(iter, PangoLayoutIter__sym)) s7_wrong_type_arg_error(sc, "pango_layout_iter_next_line", 1, iter, "PangoLayoutIter*");
  return(s7_make_boolean(sc, pango_layout_iter_next_line((PangoLayoutIter*)s7_c_pointer(iter))));
}

static s7_pointer lg_pango_layout_iter_get_char_extents(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_iter_get_char_extents "void pango_layout_iter_get_char_extents(PangoLayoutIter* iter, \
PangoRectangle* logical_rect)"
  s7_pointer _p;
  s7_pointer iter, logical_rect;
  _p = args;
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, PangoLayoutIter__sym)) s7_wrong_type_arg_error(sc, "pango_layout_iter_get_char_extents", 1, iter, "PangoLayoutIter*");
  logical_rect = s7_car(_p);
  if (!s7_is_c_pointer_of_type(logical_rect, PangoRectangle__sym)) s7_wrong_type_arg_error(sc, "pango_layout_iter_get_char_extents", 2, logical_rect, "PangoRectangle*");
  pango_layout_iter_get_char_extents((PangoLayoutIter*)s7_c_pointer(iter), (PangoRectangle*)s7_c_pointer(logical_rect));
  return(lg_false);
}

static s7_pointer lg_pango_layout_iter_get_cluster_extents(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_iter_get_cluster_extents "void pango_layout_iter_get_cluster_extents(PangoLayoutIter* iter, \
PangoRectangle* ink_rect, PangoRectangle* logical_rect)"
  s7_pointer _p;
  s7_pointer iter, ink_rect, logical_rect;
  _p = args;
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, PangoLayoutIter__sym)) s7_wrong_type_arg_error(sc, "pango_layout_iter_get_cluster_extents", 1, iter, "PangoLayoutIter*");
  ink_rect = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(ink_rect, PangoRectangle__sym)) s7_wrong_type_arg_error(sc, "pango_layout_iter_get_cluster_extents", 2, ink_rect, "PangoRectangle*");
  logical_rect = s7_car(_p);
  if (!s7_is_c_pointer_of_type(logical_rect, PangoRectangle__sym)) s7_wrong_type_arg_error(sc, "pango_layout_iter_get_cluster_extents", 3, logical_rect, "PangoRectangle*");
  pango_layout_iter_get_cluster_extents((PangoLayoutIter*)s7_c_pointer(iter), (PangoRectangle*)s7_c_pointer(ink_rect), (PangoRectangle*)s7_c_pointer(logical_rect));
  return(lg_false);
}

static s7_pointer lg_pango_layout_iter_get_run_extents(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_iter_get_run_extents "void pango_layout_iter_get_run_extents(PangoLayoutIter* iter, \
PangoRectangle* ink_rect, PangoRectangle* logical_rect)"
  s7_pointer _p;
  s7_pointer iter, ink_rect, logical_rect;
  _p = args;
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, PangoLayoutIter__sym)) s7_wrong_type_arg_error(sc, "pango_layout_iter_get_run_extents", 1, iter, "PangoLayoutIter*");
  ink_rect = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(ink_rect, PangoRectangle__sym)) s7_wrong_type_arg_error(sc, "pango_layout_iter_get_run_extents", 2, ink_rect, "PangoRectangle*");
  logical_rect = s7_car(_p);
  if (!s7_is_c_pointer_of_type(logical_rect, PangoRectangle__sym)) s7_wrong_type_arg_error(sc, "pango_layout_iter_get_run_extents", 3, logical_rect, "PangoRectangle*");
  pango_layout_iter_get_run_extents((PangoLayoutIter*)s7_c_pointer(iter), (PangoRectangle*)s7_c_pointer(ink_rect), (PangoRectangle*)s7_c_pointer(logical_rect));
  return(lg_false);
}

static s7_pointer lg_pango_layout_iter_get_line_extents(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_iter_get_line_extents "void pango_layout_iter_get_line_extents(PangoLayoutIter* iter, \
PangoRectangle* ink_rect, PangoRectangle* logical_rect)"
  s7_pointer _p;
  s7_pointer iter, ink_rect, logical_rect;
  _p = args;
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, PangoLayoutIter__sym)) s7_wrong_type_arg_error(sc, "pango_layout_iter_get_line_extents", 1, iter, "PangoLayoutIter*");
  ink_rect = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(ink_rect, PangoRectangle__sym)) s7_wrong_type_arg_error(sc, "pango_layout_iter_get_line_extents", 2, ink_rect, "PangoRectangle*");
  logical_rect = s7_car(_p);
  if (!s7_is_c_pointer_of_type(logical_rect, PangoRectangle__sym)) s7_wrong_type_arg_error(sc, "pango_layout_iter_get_line_extents", 3, logical_rect, "PangoRectangle*");
  pango_layout_iter_get_line_extents((PangoLayoutIter*)s7_c_pointer(iter), (PangoRectangle*)s7_c_pointer(ink_rect), (PangoRectangle*)s7_c_pointer(logical_rect));
  return(lg_false);
}

static s7_pointer lg_pango_layout_iter_get_line_yrange(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_iter_get_line_yrange "void pango_layout_iter_get_line_yrange(PangoLayoutIter* iter, \
int* [y0], int* [y1])"
  s7_pointer _p;
  s7_pointer iter;
  int ref_y0;
  int ref_y1;
  _p = args;
  iter = s7_car(_p);
  if (!s7_is_c_pointer_of_type(iter, PangoLayoutIter__sym)) s7_wrong_type_arg_error(sc, "pango_layout_iter_get_line_yrange", 1, iter, "PangoLayoutIter*");
  pango_layout_iter_get_line_yrange((PangoLayoutIter*)s7_c_pointer(iter), &ref_y0, &ref_y1);
    return(s7_list(sc, 2, s7_make_integer(sc, ref_y0), s7_make_integer(sc, ref_y1)));
}

static s7_pointer lg_pango_layout_iter_get_layout_extents(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_iter_get_layout_extents "void pango_layout_iter_get_layout_extents(PangoLayoutIter* iter, \
PangoRectangle* ink_rect, PangoRectangle* logical_rect)"
  s7_pointer _p;
  s7_pointer iter, ink_rect, logical_rect;
  _p = args;
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, PangoLayoutIter__sym)) s7_wrong_type_arg_error(sc, "pango_layout_iter_get_layout_extents", 1, iter, "PangoLayoutIter*");
  ink_rect = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(ink_rect, PangoRectangle__sym)) s7_wrong_type_arg_error(sc, "pango_layout_iter_get_layout_extents", 2, ink_rect, "PangoRectangle*");
  logical_rect = s7_car(_p);
  if (!s7_is_c_pointer_of_type(logical_rect, PangoRectangle__sym)) s7_wrong_type_arg_error(sc, "pango_layout_iter_get_layout_extents", 3, logical_rect, "PangoRectangle*");
  pango_layout_iter_get_layout_extents((PangoLayoutIter*)s7_c_pointer(iter), (PangoRectangle*)s7_c_pointer(ink_rect), (PangoRectangle*)s7_c_pointer(logical_rect));
  return(lg_false);
}

static s7_pointer lg_pango_layout_iter_get_baseline(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_iter_get_baseline "int pango_layout_iter_get_baseline(PangoLayoutIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  if (!s7_is_c_pointer_of_type(iter, PangoLayoutIter__sym)) s7_wrong_type_arg_error(sc, "pango_layout_iter_get_baseline", 1, iter, "PangoLayoutIter*");
  return(s7_make_integer(sc, pango_layout_iter_get_baseline((PangoLayoutIter*)s7_c_pointer(iter))));
}

static s7_pointer lg_pango_language_from_string(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_language_from_string "PangoLanguage* pango_language_from_string(char* language)"
  s7_pointer language;
  language = s7_car(args);
  if (!s7_is_string(language)) s7_wrong_type_arg_error(sc, "pango_language_from_string", 1, language, "char*");
  return(lg_make_c_pointer_with_type(sc, PangoLanguage__sym, pango_language_from_string((char*)s7_string(language))));
}

static s7_pointer lg_pango_language_matches(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_language_matches "gboolean pango_language_matches(PangoLanguage* language, char* range_list)"
  s7_pointer _p;
  s7_pointer language, range_list;
  _p = args;
  language = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(language, PangoLanguage__sym)) s7_wrong_type_arg_error(sc, "pango_language_matches", 1, language, "PangoLanguage*");
  range_list = s7_car(_p);
  if (!s7_is_string(range_list)) s7_wrong_type_arg_error(sc, "pango_language_matches", 2, range_list, "char*");
  return(s7_make_boolean(sc, pango_language_matches((PangoLanguage*)s7_c_pointer(language), (char*)s7_string(range_list))));
}

static s7_pointer lg_G_OBJECT_TYPE(s7_scheme *sc, s7_pointer args)
{
  #define H_G_OBJECT_TYPE "GType G_OBJECT_TYPE(GObject* object)"
  s7_pointer object;
  object = s7_car(args);
  if (!s7_is_c_pointer_of_type(object, GObject__sym)) s7_wrong_type_arg_error(sc, "G_OBJECT_TYPE", 1, object, "GObject*");
  return(s7_make_integer(sc, G_OBJECT_TYPE((GObject*)s7_c_pointer(object))));
}

static s7_pointer lg_gtk_tree_model_get_string_from_iter(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_get_string_from_iter "gchar* gtk_tree_model_get_string_from_iter(GtkTreeModel* tree_model, \
GtkTreeIter* iter)"
  s7_pointer _p;
  s7_pointer tree_model, iter;
  _p = args;
  tree_model = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_model, GtkTreeModel__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_get_string_from_iter", 1, tree_model, "GtkTreeModel*");
  iter = s7_car(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTreeIter__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_get_string_from_iter", 2, iter, "GtkTreeIter*");
  {
    gchar* res_ult;
    s7_pointer rtn;
    res_ult = gtk_tree_model_get_string_from_iter((GtkTreeModel*)s7_c_pointer(tree_model), (GtkTreeIter*)s7_c_pointer(iter));
    rtn = s7_make_string(sc, res_ult);
    g_free(res_ult);
    return(rtn);
  }
}

static s7_pointer lg_gtk_tree_model_sort_iter_is_valid(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_sort_iter_is_valid "gboolean gtk_tree_model_sort_iter_is_valid(GtkTreeModelSort* tree_model_sort, \
GtkTreeIter* iter)"
  s7_pointer _p;
  s7_pointer tree_model_sort, iter;
  _p = args;
  tree_model_sort = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_model_sort, GtkTreeModelSort__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_sort_iter_is_valid", 1, tree_model_sort, "GtkTreeModelSort*");
  iter = s7_car(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTreeIter__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_sort_iter_is_valid", 2, iter, "GtkTreeIter*");
  return(s7_make_boolean(sc, gtk_tree_model_sort_iter_is_valid((GtkTreeModelSort*)s7_c_pointer(tree_model_sort), (GtkTreeIter*)s7_c_pointer(iter))));
}

static s7_pointer lg_gtk_tree_view_expand_to_path(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_expand_to_path "void gtk_tree_view_expand_to_path(GtkTreeView* tree_view, GtkTreePath* path)"
  s7_pointer _p;
  s7_pointer tree_view, path;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_view, GtkTreeView__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_expand_to_path", 1, tree_view, "GtkTreeView*");
  path = s7_car(_p);
  if (!s7_is_c_pointer_of_type(path, GtkTreePath__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_expand_to_path", 2, path, "GtkTreePath*");
  gtk_tree_view_expand_to_path((GtkTreeView*)s7_c_pointer(tree_view), (GtkTreePath*)s7_c_pointer(path));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_selection_get_selected_rows(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_selection_get_selected_rows "GList* gtk_tree_selection_get_selected_rows(GtkTreeSelection* selection, \
GtkTreeModel** model)"
  s7_pointer _p;
  s7_pointer selection, model;
  _p = args;
  selection = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(selection, GtkTreeSelection__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_selection_get_selected_rows", 1, selection, "GtkTreeSelection*");
  model = s7_car(_p);
  if (!s7_is_c_pointer_of_type(model, GtkTreeModel___sym)) s7_wrong_type_arg_error(sc, "gtk_tree_selection_get_selected_rows", 2, model, "GtkTreeModel**");
  return(lg_make_c_pointer_with_type(sc, GList__sym, gtk_tree_selection_get_selected_rows((GtkTreeSelection*)s7_c_pointer(selection), (GtkTreeModel**)s7_c_pointer(model))));
}

static s7_pointer lg_gtk_tree_selection_count_selected_rows(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_selection_count_selected_rows "int gtk_tree_selection_count_selected_rows(GtkTreeSelection* selection)"
  s7_pointer selection;
  selection = s7_car(args);
  if (!s7_is_c_pointer_of_type(selection, GtkTreeSelection__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_selection_count_selected_rows", 1, selection, "GtkTreeSelection*");
  return(s7_make_integer(sc, gtk_tree_selection_count_selected_rows((GtkTreeSelection*)s7_c_pointer(selection))));
}

static s7_pointer lg_gtk_notebook_get_n_pages(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_get_n_pages "int gtk_notebook_get_n_pages(GtkNotebook* notebook)"
  s7_pointer notebook;
  notebook = s7_car(args);
  if (!s7_is_c_pointer_of_type(notebook, GtkNotebook__sym)) s7_wrong_type_arg_error(sc, "gtk_notebook_get_n_pages", 1, notebook, "GtkNotebook*");
  return(s7_make_integer(sc, gtk_notebook_get_n_pages((GtkNotebook*)s7_c_pointer(notebook))));
}

static s7_pointer lg_gtk_list_store_reorder(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_list_store_reorder "void gtk_list_store_reorder(GtkListStore* store, int* new_order)"
  s7_pointer _p;
  s7_pointer store, new_order;
  _p = args;
  store = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(store, GtkListStore__sym)) s7_wrong_type_arg_error(sc, "gtk_list_store_reorder", 1, store, "GtkListStore*");
  new_order = s7_car(_p);
  if (!s7_is_c_pointer_of_type(new_order, int__sym)) s7_wrong_type_arg_error(sc, "gtk_list_store_reorder", 2, new_order, "int*");
  gtk_list_store_reorder((GtkListStore*)s7_c_pointer(store), (int*)s7_c_pointer(new_order));
  return(lg_false);
}

static s7_pointer lg_gtk_list_store_swap(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_list_store_swap "void gtk_list_store_swap(GtkListStore* store, GtkTreeIter* a, GtkTreeIter* b)"
  s7_pointer _p;
  s7_pointer store, a, b;
  _p = args;
  store = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(store, GtkListStore__sym)) s7_wrong_type_arg_error(sc, "gtk_list_store_swap", 1, store, "GtkListStore*");
  a = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(a, GtkTreeIter__sym)) s7_wrong_type_arg_error(sc, "gtk_list_store_swap", 2, a, "GtkTreeIter*");
  b = s7_car(_p);
  if (!s7_is_c_pointer_of_type(b, GtkTreeIter__sym)) s7_wrong_type_arg_error(sc, "gtk_list_store_swap", 3, b, "GtkTreeIter*");
  gtk_list_store_swap((GtkListStore*)s7_c_pointer(store), (GtkTreeIter*)s7_c_pointer(a), (GtkTreeIter*)s7_c_pointer(b));
  return(lg_false);
}

static s7_pointer lg_gtk_list_store_move_after(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_list_store_move_after "void gtk_list_store_move_after(GtkListStore* store, GtkTreeIter* iter, \
GtkTreeIter* position)"
  s7_pointer _p;
  s7_pointer store, iter, position;
  _p = args;
  store = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(store, GtkListStore__sym)) s7_wrong_type_arg_error(sc, "gtk_list_store_move_after", 1, store, "GtkListStore*");
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTreeIter__sym)) s7_wrong_type_arg_error(sc, "gtk_list_store_move_after", 2, iter, "GtkTreeIter*");
  position = s7_car(_p);
  if ((!s7_is_c_pointer_of_type(position, GtkTreeIter__sym)) && (position != lg_false)) s7_wrong_type_arg_error(sc, "gtk_list_store_move_after", 3, position, "GtkTreeIter*");
  gtk_list_store_move_after((GtkListStore*)s7_c_pointer(store), (GtkTreeIter*)s7_c_pointer(iter), (GtkTreeIter*)s7_c_pointer(position));
  return(lg_false);
}

static s7_pointer lg_gtk_list_store_move_before(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_list_store_move_before "void gtk_list_store_move_before(GtkListStore* store, GtkTreeIter* iter, \
GtkTreeIter* position)"
  s7_pointer _p;
  s7_pointer store, iter, position;
  _p = args;
  store = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(store, GtkListStore__sym)) s7_wrong_type_arg_error(sc, "gtk_list_store_move_before", 1, store, "GtkListStore*");
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTreeIter__sym)) s7_wrong_type_arg_error(sc, "gtk_list_store_move_before", 2, iter, "GtkTreeIter*");
  position = s7_car(_p);
  if ((!s7_is_c_pointer_of_type(position, GtkTreeIter__sym)) && (position != lg_false)) s7_wrong_type_arg_error(sc, "gtk_list_store_move_before", 3, position, "GtkTreeIter*");
  gtk_list_store_move_before((GtkListStore*)s7_c_pointer(store), (GtkTreeIter*)s7_c_pointer(iter), (GtkTreeIter*)s7_c_pointer(position));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_store_reorder(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_store_reorder "void gtk_tree_store_reorder(GtkTreeStore* tree_store, GtkTreeIter* parent, \
int* new_order)"
  s7_pointer _p;
  s7_pointer tree_store, parent, new_order;
  _p = args;
  tree_store = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_store, GtkTreeStore__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_store_reorder", 1, tree_store, "GtkTreeStore*");
  parent = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(parent, GtkTreeIter__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_store_reorder", 2, parent, "GtkTreeIter*");
  new_order = s7_car(_p);
  if (!s7_is_c_pointer_of_type(new_order, int__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_store_reorder", 3, new_order, "int*");
  gtk_tree_store_reorder((GtkTreeStore*)s7_c_pointer(tree_store), (GtkTreeIter*)s7_c_pointer(parent), (int*)s7_c_pointer(new_order));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_store_swap(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_store_swap "void gtk_tree_store_swap(GtkTreeStore* tree_store, GtkTreeIter* a, GtkTreeIter* b)"
  s7_pointer _p;
  s7_pointer tree_store, a, b;
  _p = args;
  tree_store = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_store, GtkTreeStore__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_store_swap", 1, tree_store, "GtkTreeStore*");
  a = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(a, GtkTreeIter__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_store_swap", 2, a, "GtkTreeIter*");
  b = s7_car(_p);
  if (!s7_is_c_pointer_of_type(b, GtkTreeIter__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_store_swap", 3, b, "GtkTreeIter*");
  gtk_tree_store_swap((GtkTreeStore*)s7_c_pointer(tree_store), (GtkTreeIter*)s7_c_pointer(a), (GtkTreeIter*)s7_c_pointer(b));
  return(lg_false);
}

static s7_pointer lg_gdk_display_open(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_display_open "GdkDisplay* gdk_display_open(gchar* display_name)"
  s7_pointer display_name;
  display_name = s7_car(args);
  if (!s7_is_string(display_name)) s7_wrong_type_arg_error(sc, "gdk_display_open", 1, display_name, "gchar*");
  return(lg_make_c_pointer_with_type(sc, GdkDisplay__sym, gdk_display_open((gchar*)s7_string(display_name))));
}

static s7_pointer lg_gdk_display_get_name(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_display_get_name "gchar* gdk_display_get_name(GdkDisplay* display)"
  s7_pointer display;
  display = s7_car(args);
  if (!s7_is_c_pointer_of_type(display, GdkDisplay__sym)) s7_wrong_type_arg_error(sc, "gdk_display_get_name", 1, display, "GdkDisplay*");
  return(s7_make_string(sc, gdk_display_get_name((GdkDisplay*)s7_c_pointer(display))));
}

static s7_pointer lg_gdk_display_beep(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_display_beep "void gdk_display_beep(GdkDisplay* display)"
  s7_pointer display;
  display = s7_car(args);
  if (!s7_is_c_pointer_of_type(display, GdkDisplay__sym)) s7_wrong_type_arg_error(sc, "gdk_display_beep", 1, display, "GdkDisplay*");
  gdk_display_beep((GdkDisplay*)s7_c_pointer(display));
  return(lg_false);
}

static s7_pointer lg_gdk_display_sync(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_display_sync "void gdk_display_sync(GdkDisplay* display)"
  s7_pointer display;
  display = s7_car(args);
  if (!s7_is_c_pointer_of_type(display, GdkDisplay__sym)) s7_wrong_type_arg_error(sc, "gdk_display_sync", 1, display, "GdkDisplay*");
  gdk_display_sync((GdkDisplay*)s7_c_pointer(display));
  return(lg_false);
}

static s7_pointer lg_gdk_display_close(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_display_close "void gdk_display_close(GdkDisplay* display)"
  s7_pointer display;
  display = s7_car(args);
  if (!s7_is_c_pointer_of_type(display, GdkDisplay__sym)) s7_wrong_type_arg_error(sc, "gdk_display_close", 1, display, "GdkDisplay*");
  gdk_display_close((GdkDisplay*)s7_c_pointer(display));
  return(lg_false);
}

static s7_pointer lg_gdk_display_get_event(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_display_get_event "GdkEvent* gdk_display_get_event(GdkDisplay* display)"
  s7_pointer display;
  display = s7_car(args);
  if (!s7_is_c_pointer_of_type(display, GdkDisplay__sym)) s7_wrong_type_arg_error(sc, "gdk_display_get_event", 1, display, "GdkDisplay*");
  return(lg_make_c_pointer_with_type(sc, GdkEvent__sym, gdk_display_get_event((GdkDisplay*)s7_c_pointer(display))));
}

static s7_pointer lg_gdk_display_peek_event(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_display_peek_event "GdkEvent* gdk_display_peek_event(GdkDisplay* display)"
  s7_pointer display;
  display = s7_car(args);
  if (!s7_is_c_pointer_of_type(display, GdkDisplay__sym)) s7_wrong_type_arg_error(sc, "gdk_display_peek_event", 1, display, "GdkDisplay*");
  return(lg_make_c_pointer_with_type(sc, GdkEvent__sym, gdk_display_peek_event((GdkDisplay*)s7_c_pointer(display))));
}

static s7_pointer lg_gdk_display_put_event(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_display_put_event "void gdk_display_put_event(GdkDisplay* display, GdkEvent* event)"
  s7_pointer _p;
  s7_pointer display, event;
  _p = args;
  display = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(display, GdkDisplay__sym)) s7_wrong_type_arg_error(sc, "gdk_display_put_event", 1, display, "GdkDisplay*");
  event = s7_car(_p);
  if (!s7_is_c_pointer_of_type(event, GdkEvent__sym)) s7_wrong_type_arg_error(sc, "gdk_display_put_event", 2, event, "GdkEvent*");
  gdk_display_put_event((GdkDisplay*)s7_c_pointer(display), (GdkEvent*)s7_c_pointer(event));
  return(lg_false);
}

static s7_pointer lg_gdk_display_get_default(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_display_get_default "GdkDisplay* gdk_display_get_default( void)"
  return(lg_make_c_pointer_with_type(sc, GdkDisplay__sym, gdk_display_get_default()));
}

static s7_pointer lg_gtk_widget_get_display(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_get_display "GdkDisplay* gtk_widget_get_display(GtkWidget* widget)"
  s7_pointer widget;
  widget = s7_car(args);
  if (!s7_is_c_pointer_of_type(widget, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_widget_get_display", 1, widget, "GtkWidget*");
  return(lg_make_c_pointer_with_type(sc, GdkDisplay__sym, gtk_widget_get_display((GtkWidget*)s7_c_pointer(widget))));
}

static s7_pointer lg_g_list_free(s7_scheme *sc, s7_pointer args)
{
  #define H_g_list_free "void g_list_free(GList* list)"
  s7_pointer list;
  list = s7_car(args);
  if (!s7_is_c_pointer_of_type(list, GList__sym)) s7_wrong_type_arg_error(sc, "g_list_free", 1, list, "GList*");
  g_list_free((GList*)s7_c_pointer(list));
  return(lg_false);
}

static s7_pointer lg_g_list_reverse(s7_scheme *sc, s7_pointer args)
{
  #define H_g_list_reverse "GList* g_list_reverse(GList* list)"
  s7_pointer list;
  list = s7_car(args);
  if ((!s7_is_c_pointer_of_type(list, GList__sym)) && (list != lg_false)) s7_wrong_type_arg_error(sc, "g_list_reverse", 1, list, "GList*");
  return(lg_make_c_pointer_with_type(sc, GList__sym, g_list_reverse((GList*)s7_c_pointer(list))));
}

static s7_pointer lg_g_list_copy(s7_scheme *sc, s7_pointer args)
{
  #define H_g_list_copy "GList* g_list_copy(GList* list)"
  s7_pointer list;
  list = s7_car(args);
  if ((!s7_is_c_pointer_of_type(list, GList__sym)) && (list != lg_false)) s7_wrong_type_arg_error(sc, "g_list_copy", 1, list, "GList*");
  return(lg_make_c_pointer_with_type(sc, GList__sym, g_list_copy((GList*)s7_c_pointer(list))));
}

static s7_pointer lg_g_list_last(s7_scheme *sc, s7_pointer args)
{
  #define H_g_list_last "GList* g_list_last(GList* list)"
  s7_pointer list;
  list = s7_car(args);
  if (!s7_is_c_pointer_of_type(list, GList__sym)) s7_wrong_type_arg_error(sc, "g_list_last", 1, list, "GList*");
  return(lg_make_c_pointer_with_type(sc, GList__sym, g_list_last((GList*)s7_c_pointer(list))));
}

static s7_pointer lg_g_list_first(s7_scheme *sc, s7_pointer args)
{
  #define H_g_list_first "GList* g_list_first(GList* list)"
  s7_pointer list;
  list = s7_car(args);
  if (!s7_is_c_pointer_of_type(list, GList__sym)) s7_wrong_type_arg_error(sc, "g_list_first", 1, list, "GList*");
  return(lg_make_c_pointer_with_type(sc, GList__sym, g_list_first((GList*)s7_c_pointer(list))));
}

static s7_pointer lg_g_list_length(s7_scheme *sc, s7_pointer args)
{
  #define H_g_list_length "guint g_list_length(GList* list)"
  s7_pointer list;
  list = s7_car(args);
  if ((!s7_is_c_pointer_of_type(list, GList__sym)) && (list != lg_false)) s7_wrong_type_arg_error(sc, "g_list_length", 1, list, "GList*");
  return(s7_make_integer(sc, g_list_length((GList*)s7_c_pointer(list))));
}

static s7_pointer lg_g_free(s7_scheme *sc, s7_pointer args)
{
  #define H_g_free "void g_free(gpointer mem)"
  s7_pointer mem;
  mem = s7_car(args);
  if (!s7_is_c_pointer_of_type(mem, gpointer_sym)) s7_wrong_type_arg_error(sc, "g_free", 1, mem, "gpointer");
  g_free((gpointer)s7_c_pointer(mem));
  return(lg_false);
}

static s7_pointer lg_g_list_remove_link(s7_scheme *sc, s7_pointer args)
{
  #define H_g_list_remove_link "GList* g_list_remove_link(GList* list, GList* llink)"
  s7_pointer _p;
  s7_pointer list, llink;
  _p = args;
  list = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(list, GList__sym)) s7_wrong_type_arg_error(sc, "g_list_remove_link", 1, list, "GList*");
  llink = s7_car(_p);
  if (!s7_is_c_pointer_of_type(llink, GList__sym)) s7_wrong_type_arg_error(sc, "g_list_remove_link", 2, llink, "GList*");
  return(lg_make_c_pointer_with_type(sc, GList__sym, g_list_remove_link((GList*)s7_c_pointer(list), (GList*)s7_c_pointer(llink))));
}

static s7_pointer lg_g_object_get_data(s7_scheme *sc, s7_pointer args)
{
  #define H_g_object_get_data "gpointer g_object_get_data(GObject* object, gchar* key)"
  s7_pointer _p;
  s7_pointer object, key;
  _p = args;
  object = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(object, GObject__sym)) s7_wrong_type_arg_error(sc, "g_object_get_data", 1, object, "GObject*");
  key = s7_car(_p);
  if (!s7_is_string(key)) s7_wrong_type_arg_error(sc, "g_object_get_data", 2, key, "gchar*");
  return(lg_make_c_pointer_with_type(sc, gpointer_sym, g_object_get_data((GObject*)s7_c_pointer(object), (const gchar*)s7_string(key))));
}

static s7_pointer lg_g_object_set_data(s7_scheme *sc, s7_pointer args)
{
  #define H_g_object_set_data "void g_object_set_data(GObject* object, gchar* key, gpointer data)"
  s7_pointer _p;
  s7_pointer object, key, data;
  _p = args;
  object = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(object, GObject__sym)) s7_wrong_type_arg_error(sc, "g_object_set_data", 1, object, "GObject*");
  key = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(key)) s7_wrong_type_arg_error(sc, "g_object_set_data", 2, key, "gchar*");
  data = s7_car(_p);
  if (!s7_is_c_pointer_of_type(data, gpointer_sym)) s7_wrong_type_arg_error(sc, "g_object_set_data", 3, data, "gpointer");
  g_object_set_data((GObject*)s7_c_pointer(object), (const gchar*)s7_string(key), (gpointer)s7_c_pointer(data));
  return(lg_false);
}

static s7_pointer lg_gdk_display_flush(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_display_flush "void gdk_display_flush(GdkDisplay* display)"
  s7_pointer display;
  display = s7_car(args);
  if (!s7_is_c_pointer_of_type(display, GdkDisplay__sym)) s7_wrong_type_arg_error(sc, "gdk_display_flush", 1, display, "GdkDisplay*");
  gdk_display_flush((GdkDisplay*)s7_c_pointer(display));
  return(lg_false);
}

static s7_pointer lg_gtk_entry_set_completion(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_set_completion "void gtk_entry_set_completion(GtkEntry* entry, GtkEntryCompletion* completion)"
  s7_pointer _p;
  s7_pointer entry, completion;
  _p = args;
  entry = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(entry, GtkEntry__sym)) s7_wrong_type_arg_error(sc, "gtk_entry_set_completion", 1, entry, "GtkEntry*");
  completion = s7_car(_p);
  if (!s7_is_c_pointer_of_type(completion, GtkEntryCompletion__sym)) s7_wrong_type_arg_error(sc, "gtk_entry_set_completion", 2, completion, "GtkEntryCompletion*");
  gtk_entry_set_completion((GtkEntry*)s7_c_pointer(entry), (GtkEntryCompletion*)s7_c_pointer(completion));
  return(lg_false);
}

static s7_pointer lg_gtk_entry_get_completion(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_get_completion "GtkEntryCompletion* gtk_entry_get_completion(GtkEntry* entry)"
  s7_pointer entry;
  entry = s7_car(args);
  if (!s7_is_c_pointer_of_type(entry, GtkEntry__sym)) s7_wrong_type_arg_error(sc, "gtk_entry_get_completion", 1, entry, "GtkEntry*");
  return(lg_make_c_pointer_with_type(sc, GtkEntryCompletion__sym, gtk_entry_get_completion((GtkEntry*)s7_c_pointer(entry))));
}

static s7_pointer lg_gtk_text_buffer_select_range(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_select_range "void gtk_text_buffer_select_range(GtkTextBuffer* buffer, GtkTextIter* ins, \
GtkTextIter* bound)"
  s7_pointer _p;
  s7_pointer buffer, ins, bound;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(buffer, GtkTextBuffer__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_select_range", 1, buffer, "GtkTextBuffer*");
  ins = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(ins, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_select_range", 2, ins, "GtkTextIter*");
  bound = s7_car(_p);
  if (!s7_is_c_pointer_of_type(bound, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_select_range", 3, bound, "GtkTextIter*");
  gtk_text_buffer_select_range((GtkTextBuffer*)s7_c_pointer(buffer), (GtkTextIter*)s7_c_pointer(ins), (GtkTextIter*)s7_c_pointer(bound));
  return(lg_false);
}

static s7_pointer lg_gtk_text_view_set_overwrite(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_set_overwrite "void gtk_text_view_set_overwrite(GtkTextView* text_view, gboolean overwrite)"
  s7_pointer _p;
  s7_pointer text_view, overwrite;
  _p = args;
  text_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(text_view, GtkTextView__sym)) s7_wrong_type_arg_error(sc, "gtk_text_view_set_overwrite", 1, text_view, "GtkTextView*");
  overwrite = s7_car(_p);
  if (!s7_is_boolean(overwrite)) s7_wrong_type_arg_error(sc, "gtk_text_view_set_overwrite", 2, overwrite, "gboolean");
  gtk_text_view_set_overwrite((GtkTextView*)s7_c_pointer(text_view), (gboolean)lg_boolean(overwrite));
  return(lg_false);
}

static s7_pointer lg_gtk_text_view_get_overwrite(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_get_overwrite "gboolean gtk_text_view_get_overwrite(GtkTextView* text_view)"
  s7_pointer text_view;
  text_view = s7_car(args);
  if (!s7_is_c_pointer_of_type(text_view, GtkTextView__sym)) s7_wrong_type_arg_error(sc, "gtk_text_view_get_overwrite", 1, text_view, "GtkTextView*");
  return(s7_make_boolean(sc, gtk_text_view_get_overwrite((GtkTextView*)s7_c_pointer(text_view))));
}

static s7_pointer lg_gtk_text_view_set_accepts_tab(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_set_accepts_tab "void gtk_text_view_set_accepts_tab(GtkTextView* text_view, \
gboolean accepts_tab)"
  s7_pointer _p;
  s7_pointer text_view, accepts_tab;
  _p = args;
  text_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(text_view, GtkTextView__sym)) s7_wrong_type_arg_error(sc, "gtk_text_view_set_accepts_tab", 1, text_view, "GtkTextView*");
  accepts_tab = s7_car(_p);
  if (!s7_is_boolean(accepts_tab)) s7_wrong_type_arg_error(sc, "gtk_text_view_set_accepts_tab", 2, accepts_tab, "gboolean");
  gtk_text_view_set_accepts_tab((GtkTextView*)s7_c_pointer(text_view), (gboolean)lg_boolean(accepts_tab));
  return(lg_false);
}

static s7_pointer lg_gtk_text_view_get_accepts_tab(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_view_get_accepts_tab "gboolean gtk_text_view_get_accepts_tab(GtkTextView* text_view)"
  s7_pointer text_view;
  text_view = s7_car(args);
  if (!s7_is_c_pointer_of_type(text_view, GtkTextView__sym)) s7_wrong_type_arg_error(sc, "gtk_text_view_get_accepts_tab", 1, text_view, "GtkTextView*");
  return(s7_make_boolean(sc, gtk_text_view_get_accepts_tab((GtkTextView*)s7_c_pointer(text_view))));
}

static s7_pointer lg_gtk_tree_view_column_set_expand(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_set_expand "void gtk_tree_view_column_set_expand(GtkTreeViewColumn* tree_column, \
gboolean expand)"
  s7_pointer _p;
  s7_pointer tree_column, expand;
  _p = args;
  tree_column = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_column, GtkTreeViewColumn__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_set_expand", 1, tree_column, "GtkTreeViewColumn*");
  expand = s7_car(_p);
  if (!s7_is_boolean(expand)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_set_expand", 2, expand, "gboolean");
  gtk_tree_view_column_set_expand((GtkTreeViewColumn*)s7_c_pointer(tree_column), (gboolean)lg_boolean(expand));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_column_get_expand(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_get_expand "gboolean gtk_tree_view_column_get_expand(GtkTreeViewColumn* tree_column)"
  s7_pointer tree_column;
  tree_column = s7_car(args);
  if (!s7_is_c_pointer_of_type(tree_column, GtkTreeViewColumn__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_get_expand", 1, tree_column, "GtkTreeViewColumn*");
  return(s7_make_boolean(sc, gtk_tree_view_column_get_expand((GtkTreeViewColumn*)s7_c_pointer(tree_column))));
}

static s7_pointer lg_gtk_file_chooser_dialog_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_file_chooser_dialog_new "GtkWidget* gtk_file_chooser_dialog_new(gchar* title, GtkWindow* parent, \
GtkFileChooserAction action, etc buttons)"
  s7_pointer _p;
  s7_pointer title, parent, action, buttons;
  _p = args;
  title = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(title)) s7_wrong_type_arg_error(sc, "gtk_file_chooser_dialog_new", 1, title, "gchar*");
  parent = s7_car(_p); _p = s7_cdr(_p);
  if ((!s7_is_c_pointer_of_type(parent, GtkWindow__sym)) && (parent != lg_false)) s7_wrong_type_arg_error(sc, "gtk_file_chooser_dialog_new", 2, parent, "GtkWindow*");
  action = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(action)) s7_wrong_type_arg_error(sc, "gtk_file_chooser_dialog_new", 3, action, "GtkFileChooserAction");
  buttons = s7_car(_p);
  if ((!lg_is_list(buttons)) && (buttons != lg_false)) s7_wrong_type_arg_error(sc, "gtk_file_chooser_dialog_new", 4, buttons, "etc");
  {
    int etc_len = 0;
    GtkWidget* res_ult = NULL;
    gchar* p_arg0;
    GtkWindow* p_arg1;
    GtkFileChooserAction p_arg2;
    if (s7_is_list(sc, buttons)) etc_len = s7_list_length(sc, buttons);
    if (etc_len > 10) s7_out_of_range_error(sc, "gtk_file_chooser_dialog_new", 3, buttons, "... list too long (max len: 10)");
    if ((etc_len % 2) != 0) s7_out_of_range_error(sc, "gtk_file_chooser_dialog_new", 3, buttons, "... list len must be multiple of 2");
    p_arg0 = (gchar*)s7_string(title);
    p_arg1 = (GtkWindow*)s7_c_pointer(parent);
    p_arg2 = (GtkFileChooserAction)s7_integer(action);
    switch (etc_len)
      {
        case 0: res_ult = gtk_file_chooser_dialog_new(p_arg0, p_arg1, p_arg2, NULL, NULL); break;
        case 2: res_ult = gtk_file_chooser_dialog_new(p_arg0, p_arg1, p_arg2, s7_string(s7_list_ref(sc, buttons, 0)), s7_integer(s7_list_ref(sc, buttons, 1)), NULL); break;
        case 4: res_ult = gtk_file_chooser_dialog_new(p_arg0, p_arg1, p_arg2, s7_string(s7_list_ref(sc, buttons, 0)), s7_integer(s7_list_ref(sc, buttons, 1)), s7_string(s7_list_ref(sc, buttons, 2)), s7_integer(s7_list_ref(sc, buttons, 3)), NULL); break;
        case 6: res_ult = gtk_file_chooser_dialog_new(p_arg0, p_arg1, p_arg2, s7_string(s7_list_ref(sc, buttons, 0)), s7_integer(s7_list_ref(sc, buttons, 1)), s7_string(s7_list_ref(sc, buttons, 2)), s7_integer(s7_list_ref(sc, buttons, 3)), s7_string(s7_list_ref(sc, buttons, 4)), s7_integer(s7_list_ref(sc, buttons, 5)), NULL); break;
        case 8: res_ult = gtk_file_chooser_dialog_new(p_arg0, p_arg1, p_arg2, s7_string(s7_list_ref(sc, buttons, 0)), s7_integer(s7_list_ref(sc, buttons, 1)), s7_string(s7_list_ref(sc, buttons, 2)), s7_integer(s7_list_ref(sc, buttons, 3)), s7_string(s7_list_ref(sc, buttons, 4)), s7_integer(s7_list_ref(sc, buttons, 5)), s7_string(s7_list_ref(sc, buttons, 6)), s7_integer(s7_list_ref(sc, buttons, 7)), NULL); break;
        case 10: res_ult = gtk_file_chooser_dialog_new(p_arg0, p_arg1, p_arg2, s7_string(s7_list_ref(sc, buttons, 0)), s7_integer(s7_list_ref(sc, buttons, 1)), s7_string(s7_list_ref(sc, buttons, 2)), s7_integer(s7_list_ref(sc, buttons, 3)), s7_string(s7_list_ref(sc, buttons, 4)), s7_integer(s7_list_ref(sc, buttons, 5)), s7_string(s7_list_ref(sc, buttons, 6)), s7_integer(s7_list_ref(sc, buttons, 7)), s7_string(s7_list_ref(sc, buttons, 8)), s7_integer(s7_list_ref(sc, buttons, 9)), NULL); break;
      }
    return(s7_make_c_pointer(sc, res_ult));
  }
}

static s7_pointer lg_gtk_file_chooser_widget_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_file_chooser_widget_new "GtkWidget* gtk_file_chooser_widget_new(GtkFileChooserAction action)"
  s7_pointer action;
  action = s7_car(args);
  if (!s7_is_integer(action)) s7_wrong_type_arg_error(sc, "gtk_file_chooser_widget_new", 1, action, "GtkFileChooserAction");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_file_chooser_widget_new((GtkFileChooserAction)s7_integer(action))));
}

static s7_pointer lg_gtk_tree_model_filter_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_filter_new "GtkTreeModel* gtk_tree_model_filter_new(GtkTreeModel* child_model, \
GtkTreePath* root)"
  s7_pointer _p;
  s7_pointer child_model, root;
  _p = args;
  child_model = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(child_model, GtkTreeModel__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_filter_new", 1, child_model, "GtkTreeModel*");
  root = s7_car(_p);
  if ((!s7_is_c_pointer_of_type(root, GtkTreePath__sym)) && (root != lg_false)) s7_wrong_type_arg_error(sc, "gtk_tree_model_filter_new", 2, root, "GtkTreePath*");
  return(lg_make_c_pointer_with_type(sc, GtkTreeModel__sym, gtk_tree_model_filter_new((GtkTreeModel*)s7_c_pointer(child_model), (GtkTreePath*)s7_c_pointer(root))));
}

static s7_pointer lg_gtk_tree_model_filter_set_visible_column(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_filter_set_visible_column "void gtk_tree_model_filter_set_visible_column(GtkTreeModelFilter* filter, \
gint column)"
  s7_pointer _p;
  s7_pointer filter, column;
  _p = args;
  filter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(filter, GtkTreeModelFilter__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_filter_set_visible_column", 1, filter, "GtkTreeModelFilter*");
  column = s7_car(_p);
  if (!s7_is_integer(column)) s7_wrong_type_arg_error(sc, "gtk_tree_model_filter_set_visible_column", 2, column, "gint");
  gtk_tree_model_filter_set_visible_column((GtkTreeModelFilter*)s7_c_pointer(filter), (gint)s7_integer(column));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_model_filter_get_model(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_filter_get_model "GtkTreeModel* gtk_tree_model_filter_get_model(GtkTreeModelFilter* filter)"
  s7_pointer filter;
  filter = s7_car(args);
  if (!s7_is_c_pointer_of_type(filter, GtkTreeModelFilter__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_filter_get_model", 1, filter, "GtkTreeModelFilter*");
  return(lg_make_c_pointer_with_type(sc, GtkTreeModel__sym, gtk_tree_model_filter_get_model((GtkTreeModelFilter*)s7_c_pointer(filter))));
}

static s7_pointer lg_gtk_tree_model_filter_convert_iter_to_child_iter(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_filter_convert_iter_to_child_iter "void gtk_tree_model_filter_convert_iter_to_child_iter(GtkTreeModelFilter* filter, \
GtkTreeIter* child_iter, GtkTreeIter* filter_iter)"
  s7_pointer _p;
  s7_pointer filter, child_iter, filter_iter;
  _p = args;
  filter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(filter, GtkTreeModelFilter__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_filter_convert_iter_to_child_iter", 1, filter, "GtkTreeModelFilter*");
  child_iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(child_iter, GtkTreeIter__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_filter_convert_iter_to_child_iter", 2, child_iter, "GtkTreeIter*");
  filter_iter = s7_car(_p);
  if (!s7_is_c_pointer_of_type(filter_iter, GtkTreeIter__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_filter_convert_iter_to_child_iter", 3, filter_iter, "GtkTreeIter*");
  gtk_tree_model_filter_convert_iter_to_child_iter((GtkTreeModelFilter*)s7_c_pointer(filter), (GtkTreeIter*)s7_c_pointer(child_iter), (GtkTreeIter*)s7_c_pointer(filter_iter));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_model_filter_convert_child_path_to_path(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_filter_convert_child_path_to_path "GtkTreePath* gtk_tree_model_filter_convert_child_path_to_path(GtkTreeModelFilter* filter, \
GtkTreePath* child_path)"
  s7_pointer _p;
  s7_pointer filter, child_path;
  _p = args;
  filter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(filter, GtkTreeModelFilter__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_filter_convert_child_path_to_path", 1, filter, "GtkTreeModelFilter*");
  child_path = s7_car(_p);
  if (!s7_is_c_pointer_of_type(child_path, GtkTreePath__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_filter_convert_child_path_to_path", 2, child_path, "GtkTreePath*");
  return(lg_make_c_pointer_with_type(sc, GtkTreePath__sym, gtk_tree_model_filter_convert_child_path_to_path((GtkTreeModelFilter*)s7_c_pointer(filter), (GtkTreePath*)s7_c_pointer(child_path))));
}

static s7_pointer lg_gtk_tree_model_filter_convert_path_to_child_path(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_filter_convert_path_to_child_path "GtkTreePath* gtk_tree_model_filter_convert_path_to_child_path(GtkTreeModelFilter* path, \
GtkTreePath* filter_path)"
  s7_pointer _p;
  s7_pointer path, filter_path;
  _p = args;
  path = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(path, GtkTreeModelFilter__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_filter_convert_path_to_child_path", 1, path, "GtkTreeModelFilter*");
  filter_path = s7_car(_p);
  if (!s7_is_c_pointer_of_type(filter_path, GtkTreePath__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_filter_convert_path_to_child_path", 2, filter_path, "GtkTreePath*");
  return(lg_make_c_pointer_with_type(sc, GtkTreePath__sym, gtk_tree_model_filter_convert_path_to_child_path((GtkTreeModelFilter*)s7_c_pointer(path), (GtkTreePath*)s7_c_pointer(filter_path))));
}

static s7_pointer lg_gtk_tree_model_filter_refilter(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_filter_refilter "void gtk_tree_model_filter_refilter(GtkTreeModelFilter* filter)"
  s7_pointer filter;
  filter = s7_car(args);
  if (!s7_is_c_pointer_of_type(filter, GtkTreeModelFilter__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_filter_refilter", 1, filter, "GtkTreeModelFilter*");
  gtk_tree_model_filter_refilter((GtkTreeModelFilter*)s7_c_pointer(filter));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_model_filter_clear_cache(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_filter_clear_cache "void gtk_tree_model_filter_clear_cache(GtkTreeModelFilter* filter)"
  s7_pointer filter;
  filter = s7_car(args);
  if (!s7_is_c_pointer_of_type(filter, GtkTreeModelFilter__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_filter_clear_cache", 1, filter, "GtkTreeModelFilter*");
  gtk_tree_model_filter_clear_cache((GtkTreeModelFilter*)s7_c_pointer(filter));
  return(lg_false);
}

static s7_pointer lg_gtk_combo_box_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_combo_box_new "GtkWidget* gtk_combo_box_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_combo_box_new()));
}

static s7_pointer lg_gtk_combo_box_new_with_model(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_combo_box_new_with_model "GtkWidget* gtk_combo_box_new_with_model(GtkTreeModel* model)"
  s7_pointer model;
  model = s7_car(args);
  if (!s7_is_c_pointer_of_type(model, GtkTreeModel__sym)) s7_wrong_type_arg_error(sc, "gtk_combo_box_new_with_model", 1, model, "GtkTreeModel*");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_combo_box_new_with_model((GtkTreeModel*)s7_c_pointer(model))));
}

static s7_pointer lg_gtk_combo_box_set_model(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_combo_box_set_model "void gtk_combo_box_set_model(GtkComboBox* combo_box, GtkTreeModel* model)"
  s7_pointer _p;
  s7_pointer combo_box, model;
  _p = args;
  combo_box = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(combo_box, GtkComboBox__sym)) s7_wrong_type_arg_error(sc, "gtk_combo_box_set_model", 1, combo_box, "GtkComboBox*");
  model = s7_car(_p);
  if ((!s7_is_c_pointer_of_type(model, GtkTreeModel__sym)) && (model != lg_false)) s7_wrong_type_arg_error(sc, "gtk_combo_box_set_model", 2, model, "GtkTreeModel*");
  gtk_combo_box_set_model((GtkComboBox*)s7_c_pointer(combo_box), (GtkTreeModel*)s7_c_pointer(model));
  return(lg_false);
}

static s7_pointer lg_gtk_combo_box_get_active(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_combo_box_get_active "gint gtk_combo_box_get_active(GtkComboBox* combo_box)"
  s7_pointer combo_box;
  combo_box = s7_car(args);
  if (!s7_is_c_pointer_of_type(combo_box, GtkComboBox__sym)) s7_wrong_type_arg_error(sc, "gtk_combo_box_get_active", 1, combo_box, "GtkComboBox*");
  return(s7_make_integer(sc, gtk_combo_box_get_active((GtkComboBox*)s7_c_pointer(combo_box))));
}

static s7_pointer lg_gtk_combo_box_set_active(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_combo_box_set_active "void gtk_combo_box_set_active(GtkComboBox* combo_box, gint index)"
  s7_pointer _p;
  s7_pointer combo_box, index;
  _p = args;
  combo_box = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(combo_box, GtkComboBox__sym)) s7_wrong_type_arg_error(sc, "gtk_combo_box_set_active", 1, combo_box, "GtkComboBox*");
  index = s7_car(_p);
  if (!s7_is_integer(index)) s7_wrong_type_arg_error(sc, "gtk_combo_box_set_active", 2, index, "gint");
  gtk_combo_box_set_active((GtkComboBox*)s7_c_pointer(combo_box), (gint)s7_integer(index));
  return(lg_false);
}

static s7_pointer lg_gtk_combo_box_get_active_iter(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_combo_box_get_active_iter "gboolean gtk_combo_box_get_active_iter(GtkComboBox* combo_box, \
GtkTreeIter* iter)"
  s7_pointer _p;
  s7_pointer combo_box, iter;
  _p = args;
  combo_box = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(combo_box, GtkComboBox__sym)) s7_wrong_type_arg_error(sc, "gtk_combo_box_get_active_iter", 1, combo_box, "GtkComboBox*");
  iter = s7_car(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTreeIter__sym)) s7_wrong_type_arg_error(sc, "gtk_combo_box_get_active_iter", 2, iter, "GtkTreeIter*");
  return(s7_make_boolean(sc, gtk_combo_box_get_active_iter((GtkComboBox*)s7_c_pointer(combo_box), (GtkTreeIter*)s7_c_pointer(iter))));
}

static s7_pointer lg_gtk_combo_box_set_active_iter(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_combo_box_set_active_iter "void gtk_combo_box_set_active_iter(GtkComboBox* combo_box, \
GtkTreeIter* iter)"
  s7_pointer _p;
  s7_pointer combo_box, iter;
  _p = args;
  combo_box = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(combo_box, GtkComboBox__sym)) s7_wrong_type_arg_error(sc, "gtk_combo_box_set_active_iter", 1, combo_box, "GtkComboBox*");
  iter = s7_car(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTreeIter__sym)) s7_wrong_type_arg_error(sc, "gtk_combo_box_set_active_iter", 2, iter, "GtkTreeIter*");
  gtk_combo_box_set_active_iter((GtkComboBox*)s7_c_pointer(combo_box), (GtkTreeIter*)s7_c_pointer(iter));
  return(lg_false);
}

static s7_pointer lg_gtk_combo_box_get_model(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_combo_box_get_model "GtkTreeModel* gtk_combo_box_get_model(GtkComboBox* combo_box)"
  s7_pointer combo_box;
  combo_box = s7_car(args);
  if (!s7_is_c_pointer_of_type(combo_box, GtkComboBox__sym)) s7_wrong_type_arg_error(sc, "gtk_combo_box_get_model", 1, combo_box, "GtkComboBox*");
  return(lg_make_c_pointer_with_type(sc, GtkTreeModel__sym, gtk_combo_box_get_model((GtkComboBox*)s7_c_pointer(combo_box))));
}

static s7_pointer lg_gtk_expander_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_expander_new "GtkWidget* gtk_expander_new(gchar* label)"
  s7_pointer label;
  label = s7_car(args);
  if (!s7_is_string(label)) s7_wrong_type_arg_error(sc, "gtk_expander_new", 1, label, "gchar*");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_expander_new((gchar*)s7_string(label))));
}

static s7_pointer lg_gtk_expander_new_with_mnemonic(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_expander_new_with_mnemonic "GtkWidget* gtk_expander_new_with_mnemonic(gchar* label)"
  s7_pointer label;
  label = s7_car(args);
  if (!s7_is_string(label)) s7_wrong_type_arg_error(sc, "gtk_expander_new_with_mnemonic", 1, label, "gchar*");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_expander_new_with_mnemonic((gchar*)s7_string(label))));
}

static s7_pointer lg_gtk_expander_set_expanded(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_expander_set_expanded "void gtk_expander_set_expanded(GtkExpander* expander, gboolean expanded)"
  s7_pointer _p;
  s7_pointer expander, expanded;
  _p = args;
  expander = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(expander, GtkExpander__sym)) s7_wrong_type_arg_error(sc, "gtk_expander_set_expanded", 1, expander, "GtkExpander*");
  expanded = s7_car(_p);
  if (!s7_is_boolean(expanded)) s7_wrong_type_arg_error(sc, "gtk_expander_set_expanded", 2, expanded, "gboolean");
  gtk_expander_set_expanded((GtkExpander*)s7_c_pointer(expander), (gboolean)lg_boolean(expanded));
  return(lg_false);
}

static s7_pointer lg_gtk_expander_get_expanded(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_expander_get_expanded "gboolean gtk_expander_get_expanded(GtkExpander* expander)"
  s7_pointer expander;
  expander = s7_car(args);
  if (!s7_is_c_pointer_of_type(expander, GtkExpander__sym)) s7_wrong_type_arg_error(sc, "gtk_expander_get_expanded", 1, expander, "GtkExpander*");
  return(s7_make_boolean(sc, gtk_expander_get_expanded((GtkExpander*)s7_c_pointer(expander))));
}

static s7_pointer lg_gtk_expander_set_label(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_expander_set_label "void gtk_expander_set_label(GtkExpander* expander, gchar* label)"
  s7_pointer _p;
  s7_pointer expander, label;
  _p = args;
  expander = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(expander, GtkExpander__sym)) s7_wrong_type_arg_error(sc, "gtk_expander_set_label", 1, expander, "GtkExpander*");
  label = s7_car(_p);
  if (!s7_is_string(label)) s7_wrong_type_arg_error(sc, "gtk_expander_set_label", 2, label, "gchar*");
  gtk_expander_set_label((GtkExpander*)s7_c_pointer(expander), (gchar*)s7_string(label));
  return(lg_false);
}

static s7_pointer lg_gtk_expander_get_label(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_expander_get_label "gchar* gtk_expander_get_label(GtkExpander* expander)"
  s7_pointer expander;
  expander = s7_car(args);
  if (!s7_is_c_pointer_of_type(expander, GtkExpander__sym)) s7_wrong_type_arg_error(sc, "gtk_expander_get_label", 1, expander, "GtkExpander*");
  return(s7_make_string(sc, gtk_expander_get_label((GtkExpander*)s7_c_pointer(expander))));
}

static s7_pointer lg_gtk_expander_set_use_underline(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_expander_set_use_underline "void gtk_expander_set_use_underline(GtkExpander* expander, \
gboolean use_underline)"
  s7_pointer _p;
  s7_pointer expander, use_underline;
  _p = args;
  expander = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(expander, GtkExpander__sym)) s7_wrong_type_arg_error(sc, "gtk_expander_set_use_underline", 1, expander, "GtkExpander*");
  use_underline = s7_car(_p);
  if (!s7_is_boolean(use_underline)) s7_wrong_type_arg_error(sc, "gtk_expander_set_use_underline", 2, use_underline, "gboolean");
  gtk_expander_set_use_underline((GtkExpander*)s7_c_pointer(expander), (gboolean)lg_boolean(use_underline));
  return(lg_false);
}

static s7_pointer lg_gtk_expander_get_use_underline(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_expander_get_use_underline "gboolean gtk_expander_get_use_underline(GtkExpander* expander)"
  s7_pointer expander;
  expander = s7_car(args);
  if (!s7_is_c_pointer_of_type(expander, GtkExpander__sym)) s7_wrong_type_arg_error(sc, "gtk_expander_get_use_underline", 1, expander, "GtkExpander*");
  return(s7_make_boolean(sc, gtk_expander_get_use_underline((GtkExpander*)s7_c_pointer(expander))));
}

static s7_pointer lg_gtk_expander_set_label_widget(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_expander_set_label_widget "void gtk_expander_set_label_widget(GtkExpander* expander, \
GtkWidget* label_widget)"
  s7_pointer _p;
  s7_pointer expander, label_widget;
  _p = args;
  expander = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(expander, GtkExpander__sym)) s7_wrong_type_arg_error(sc, "gtk_expander_set_label_widget", 1, expander, "GtkExpander*");
  label_widget = s7_car(_p);
  if (!s7_is_c_pointer_of_type(label_widget, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_expander_set_label_widget", 2, label_widget, "GtkWidget*");
  gtk_expander_set_label_widget((GtkExpander*)s7_c_pointer(expander), (GtkWidget*)s7_c_pointer(label_widget));
  return(lg_false);
}

static s7_pointer lg_gtk_expander_get_label_widget(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_expander_get_label_widget "GtkWidget* gtk_expander_get_label_widget(GtkExpander* expander)"
  s7_pointer expander;
  expander = s7_car(args);
  if (!s7_is_c_pointer_of_type(expander, GtkExpander__sym)) s7_wrong_type_arg_error(sc, "gtk_expander_get_label_widget", 1, expander, "GtkExpander*");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_expander_get_label_widget((GtkExpander*)s7_c_pointer(expander))));
}

static s7_pointer lg_gtk_expander_set_use_markup(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_expander_set_use_markup "void gtk_expander_set_use_markup(GtkExpander* expander, gboolean use_markup)"
  s7_pointer _p;
  s7_pointer expander, use_markup;
  _p = args;
  expander = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(expander, GtkExpander__sym)) s7_wrong_type_arg_error(sc, "gtk_expander_set_use_markup", 1, expander, "GtkExpander*");
  use_markup = s7_car(_p);
  if (!s7_is_boolean(use_markup)) s7_wrong_type_arg_error(sc, "gtk_expander_set_use_markup", 2, use_markup, "gboolean");
  gtk_expander_set_use_markup((GtkExpander*)s7_c_pointer(expander), (gboolean)lg_boolean(use_markup));
  return(lg_false);
}

static s7_pointer lg_gtk_expander_get_use_markup(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_expander_get_use_markup "gboolean gtk_expander_get_use_markup(GtkExpander* expander)"
  s7_pointer expander;
  expander = s7_car(args);
  if (!s7_is_c_pointer_of_type(expander, GtkExpander__sym)) s7_wrong_type_arg_error(sc, "gtk_expander_get_use_markup", 1, expander, "GtkExpander*");
  return(s7_make_boolean(sc, gtk_expander_get_use_markup((GtkExpander*)s7_c_pointer(expander))));
}

static s7_pointer lg_gtk_font_button_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_font_button_new "GtkWidget* gtk_font_button_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_font_button_new()));
}

static s7_pointer lg_gtk_font_button_new_with_font(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_font_button_new_with_font "GtkWidget* gtk_font_button_new_with_font(gchar* fontname)"
  s7_pointer fontname;
  fontname = s7_car(args);
  if (!s7_is_string(fontname)) s7_wrong_type_arg_error(sc, "gtk_font_button_new_with_font", 1, fontname, "gchar*");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_font_button_new_with_font((gchar*)s7_string(fontname))));
}

static s7_pointer lg_gtk_font_button_get_title(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_font_button_get_title "gchar* gtk_font_button_get_title(GtkFontButton* font_button)"
  s7_pointer font_button;
  font_button = s7_car(args);
  if (!s7_is_c_pointer_of_type(font_button, GtkFontButton__sym)) s7_wrong_type_arg_error(sc, "gtk_font_button_get_title", 1, font_button, "GtkFontButton*");
  return(s7_make_string(sc, gtk_font_button_get_title((GtkFontButton*)s7_c_pointer(font_button))));
}

static s7_pointer lg_gtk_font_button_set_title(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_font_button_set_title "void gtk_font_button_set_title(GtkFontButton* font_button, gchar* title)"
  s7_pointer _p;
  s7_pointer font_button, title;
  _p = args;
  font_button = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(font_button, GtkFontButton__sym)) s7_wrong_type_arg_error(sc, "gtk_font_button_set_title", 1, font_button, "GtkFontButton*");
  title = s7_car(_p);
  if (!s7_is_string(title)) s7_wrong_type_arg_error(sc, "gtk_font_button_set_title", 2, title, "gchar*");
  gtk_font_button_set_title((GtkFontButton*)s7_c_pointer(font_button), (gchar*)s7_string(title));
  return(lg_false);
}

static s7_pointer lg_gtk_font_button_get_use_font(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_font_button_get_use_font "gboolean gtk_font_button_get_use_font(GtkFontButton* font_button)"
  s7_pointer font_button;
  font_button = s7_car(args);
  if (!s7_is_c_pointer_of_type(font_button, GtkFontButton__sym)) s7_wrong_type_arg_error(sc, "gtk_font_button_get_use_font", 1, font_button, "GtkFontButton*");
  return(s7_make_boolean(sc, gtk_font_button_get_use_font((GtkFontButton*)s7_c_pointer(font_button))));
}

static s7_pointer lg_gtk_font_button_set_use_font(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_font_button_set_use_font "void gtk_font_button_set_use_font(GtkFontButton* font_button, \
gboolean use_font)"
  s7_pointer _p;
  s7_pointer font_button, use_font;
  _p = args;
  font_button = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(font_button, GtkFontButton__sym)) s7_wrong_type_arg_error(sc, "gtk_font_button_set_use_font", 1, font_button, "GtkFontButton*");
  use_font = s7_car(_p);
  if (!s7_is_boolean(use_font)) s7_wrong_type_arg_error(sc, "gtk_font_button_set_use_font", 2, use_font, "gboolean");
  gtk_font_button_set_use_font((GtkFontButton*)s7_c_pointer(font_button), (gboolean)lg_boolean(use_font));
  return(lg_false);
}

static s7_pointer lg_gtk_font_button_get_use_size(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_font_button_get_use_size "gboolean gtk_font_button_get_use_size(GtkFontButton* font_button)"
  s7_pointer font_button;
  font_button = s7_car(args);
  if (!s7_is_c_pointer_of_type(font_button, GtkFontButton__sym)) s7_wrong_type_arg_error(sc, "gtk_font_button_get_use_size", 1, font_button, "GtkFontButton*");
  return(s7_make_boolean(sc, gtk_font_button_get_use_size((GtkFontButton*)s7_c_pointer(font_button))));
}

static s7_pointer lg_gtk_font_button_set_use_size(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_font_button_set_use_size "void gtk_font_button_set_use_size(GtkFontButton* font_button, \
gboolean use_size)"
  s7_pointer _p;
  s7_pointer font_button, use_size;
  _p = args;
  font_button = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(font_button, GtkFontButton__sym)) s7_wrong_type_arg_error(sc, "gtk_font_button_set_use_size", 1, font_button, "GtkFontButton*");
  use_size = s7_car(_p);
  if (!s7_is_boolean(use_size)) s7_wrong_type_arg_error(sc, "gtk_font_button_set_use_size", 2, use_size, "gboolean");
  gtk_font_button_set_use_size((GtkFontButton*)s7_c_pointer(font_button), (gboolean)lg_boolean(use_size));
  return(lg_false);
}

static s7_pointer lg_gtk_entry_completion_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_completion_new "GtkEntryCompletion* gtk_entry_completion_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkEntryCompletion__sym, gtk_entry_completion_new()));
}

static s7_pointer lg_gtk_entry_completion_get_entry(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_completion_get_entry "GtkWidget* gtk_entry_completion_get_entry(GtkEntryCompletion* entry)"
  s7_pointer entry;
  entry = s7_car(args);
  if (!s7_is_c_pointer_of_type(entry, GtkEntryCompletion__sym)) s7_wrong_type_arg_error(sc, "gtk_entry_completion_get_entry", 1, entry, "GtkEntryCompletion*");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_entry_completion_get_entry((GtkEntryCompletion*)s7_c_pointer(entry))));
}

static s7_pointer lg_gtk_entry_completion_set_model(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_completion_set_model "void gtk_entry_completion_set_model(GtkEntryCompletion* completion, \
GtkTreeModel* model)"
  s7_pointer _p;
  s7_pointer completion, model;
  _p = args;
  completion = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(completion, GtkEntryCompletion__sym)) s7_wrong_type_arg_error(sc, "gtk_entry_completion_set_model", 1, completion, "GtkEntryCompletion*");
  model = s7_car(_p);
  if ((!s7_is_c_pointer_of_type(model, GtkTreeModel__sym)) && (model != lg_false)) s7_wrong_type_arg_error(sc, "gtk_entry_completion_set_model", 2, model, "GtkTreeModel*");
  gtk_entry_completion_set_model((GtkEntryCompletion*)s7_c_pointer(completion), (GtkTreeModel*)s7_c_pointer(model));
  return(lg_false);
}

static s7_pointer lg_gtk_entry_completion_get_model(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_completion_get_model "GtkTreeModel* gtk_entry_completion_get_model(GtkEntryCompletion* completion)"
  s7_pointer completion;
  completion = s7_car(args);
  if (!s7_is_c_pointer_of_type(completion, GtkEntryCompletion__sym)) s7_wrong_type_arg_error(sc, "gtk_entry_completion_get_model", 1, completion, "GtkEntryCompletion*");
  return(lg_make_c_pointer_with_type(sc, GtkTreeModel__sym, gtk_entry_completion_get_model((GtkEntryCompletion*)s7_c_pointer(completion))));
}

static s7_pointer lg_gtk_entry_completion_set_match_func(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_completion_set_match_func "void gtk_entry_completion_set_match_func(GtkEntryCompletion* completion, \
GtkEntryCompletionMatchFunc func, lambda_data func_info, GtkDestroyNotify func_notify)"
  s7_pointer _p;
  s7_pointer completion, func, func_info, func_notify;
  _p = args;
  completion = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(completion, GtkEntryCompletion__sym)) s7_wrong_type_arg_error(sc, "gtk_entry_completion_set_match_func", 1, completion, "GtkEntryCompletion*");
  func = s7_car(_p); _p = s7_cdr(_p);
  func_info = s7_car(_p); _p = s7_cdr(_p);
  func_notify = s7_car(_p);
  {
    s7_pointer lg_ptr = s7_list(sc, 5, func, func_info, lg_false, lg_false, lg_false);
    s7_gc_protect(sc, lg_ptr);
    s7_list_set(sc, lg_ptr, 3, func_notify);
    gtk_entry_completion_set_match_func((GtkEntryCompletion*)s7_c_pointer(completion), lg_entry_completion_match, (gpointer)lg_ptr, lg_destroy_func);
    return(lg_false);
   }
}

static s7_pointer lg_gtk_entry_completion_set_minimum_key_length(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_completion_set_minimum_key_length "void gtk_entry_completion_set_minimum_key_length(GtkEntryCompletion* completion, \
gint length)"
  s7_pointer _p;
  s7_pointer completion, length;
  _p = args;
  completion = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(completion, GtkEntryCompletion__sym)) s7_wrong_type_arg_error(sc, "gtk_entry_completion_set_minimum_key_length", 1, completion, "GtkEntryCompletion*");
  length = s7_car(_p);
  if (!s7_is_integer(length)) s7_wrong_type_arg_error(sc, "gtk_entry_completion_set_minimum_key_length", 2, length, "gint");
  gtk_entry_completion_set_minimum_key_length((GtkEntryCompletion*)s7_c_pointer(completion), (gint)s7_integer(length));
  return(lg_false);
}

static s7_pointer lg_gtk_entry_completion_get_minimum_key_length(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_completion_get_minimum_key_length "gint gtk_entry_completion_get_minimum_key_length(GtkEntryCompletion* completion)"
  s7_pointer completion;
  completion = s7_car(args);
  if (!s7_is_c_pointer_of_type(completion, GtkEntryCompletion__sym)) s7_wrong_type_arg_error(sc, "gtk_entry_completion_get_minimum_key_length", 1, completion, "GtkEntryCompletion*");
  return(s7_make_integer(sc, gtk_entry_completion_get_minimum_key_length((GtkEntryCompletion*)s7_c_pointer(completion))));
}

static s7_pointer lg_gtk_entry_completion_complete(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_completion_complete "void gtk_entry_completion_complete(GtkEntryCompletion* completion)"
  s7_pointer completion;
  completion = s7_car(args);
  if (!s7_is_c_pointer_of_type(completion, GtkEntryCompletion__sym)) s7_wrong_type_arg_error(sc, "gtk_entry_completion_complete", 1, completion, "GtkEntryCompletion*");
  gtk_entry_completion_complete((GtkEntryCompletion*)s7_c_pointer(completion));
  return(lg_false);
}

static s7_pointer lg_gtk_entry_completion_insert_action_text(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_completion_insert_action_text "void gtk_entry_completion_insert_action_text(GtkEntryCompletion* completion, \
gint index, gchar* text)"
  s7_pointer _p;
  s7_pointer completion, index, text;
  _p = args;
  completion = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(completion, GtkEntryCompletion__sym)) s7_wrong_type_arg_error(sc, "gtk_entry_completion_insert_action_text", 1, completion, "GtkEntryCompletion*");
  index = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(index)) s7_wrong_type_arg_error(sc, "gtk_entry_completion_insert_action_text", 2, index, "gint");
  text = s7_car(_p);
  if (!s7_is_string(text)) s7_wrong_type_arg_error(sc, "gtk_entry_completion_insert_action_text", 3, text, "gchar*");
  gtk_entry_completion_insert_action_text((GtkEntryCompletion*)s7_c_pointer(completion), (gint)s7_integer(index), (gchar*)s7_string(text));
  return(lg_false);
}

static s7_pointer lg_gtk_entry_completion_insert_action_markup(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_completion_insert_action_markup "void gtk_entry_completion_insert_action_markup(GtkEntryCompletion* completion, \
gint index, gchar* markup)"
  s7_pointer _p;
  s7_pointer completion, index, markup;
  _p = args;
  completion = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(completion, GtkEntryCompletion__sym)) s7_wrong_type_arg_error(sc, "gtk_entry_completion_insert_action_markup", 1, completion, "GtkEntryCompletion*");
  index = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(index)) s7_wrong_type_arg_error(sc, "gtk_entry_completion_insert_action_markup", 2, index, "gint");
  markup = s7_car(_p);
  if (!s7_is_string(markup)) s7_wrong_type_arg_error(sc, "gtk_entry_completion_insert_action_markup", 3, markup, "gchar*");
  gtk_entry_completion_insert_action_markup((GtkEntryCompletion*)s7_c_pointer(completion), (gint)s7_integer(index), (gchar*)s7_string(markup));
  return(lg_false);
}

static s7_pointer lg_gtk_entry_completion_delete_action(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_completion_delete_action "void gtk_entry_completion_delete_action(GtkEntryCompletion* completion, \
gint index)"
  s7_pointer _p;
  s7_pointer completion, index;
  _p = args;
  completion = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(completion, GtkEntryCompletion__sym)) s7_wrong_type_arg_error(sc, "gtk_entry_completion_delete_action", 1, completion, "GtkEntryCompletion*");
  index = s7_car(_p);
  if (!s7_is_integer(index)) s7_wrong_type_arg_error(sc, "gtk_entry_completion_delete_action", 2, index, "gint");
  gtk_entry_completion_delete_action((GtkEntryCompletion*)s7_c_pointer(completion), (gint)s7_integer(index));
  return(lg_false);
}

static s7_pointer lg_gtk_entry_completion_set_text_column(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_completion_set_text_column "void gtk_entry_completion_set_text_column(GtkEntryCompletion* completion, \
gint column)"
  s7_pointer _p;
  s7_pointer completion, column;
  _p = args;
  completion = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(completion, GtkEntryCompletion__sym)) s7_wrong_type_arg_error(sc, "gtk_entry_completion_set_text_column", 1, completion, "GtkEntryCompletion*");
  column = s7_car(_p);
  if (!s7_is_integer(column)) s7_wrong_type_arg_error(sc, "gtk_entry_completion_set_text_column", 2, column, "gint");
  gtk_entry_completion_set_text_column((GtkEntryCompletion*)s7_c_pointer(completion), (gint)s7_integer(column));
  return(lg_false);
}

static s7_pointer lg_g_timeout_add_full(s7_scheme *sc, s7_pointer args)
{
  #define H_g_timeout_add_full "guint g_timeout_add_full(gint priority, guint interval, GSourceFunc func, \
lambda_data func_info, GtkDestroyNotify notify)"
  s7_pointer _p;
  s7_pointer priority, interval, func, func_info, notify;
  _p = args;
  priority = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(priority)) s7_wrong_type_arg_error(sc, "g_timeout_add_full", 1, priority, "gint");
  interval = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(interval)) s7_wrong_type_arg_error(sc, "g_timeout_add_full", 2, interval, "guint");
  func = s7_car(_p); _p = s7_cdr(_p);
  func_info = s7_car(_p); _p = s7_cdr(_p);
  notify = s7_car(_p);
  {
    s7_pointer res_ult;
    int loc;
    s7_pointer lg_ptr = s7_list(sc, 5, func, func_info, lg_false, lg_false, lg_false);
    loc = s7_gc_protect(sc, lg_ptr);
    s7_list_set(sc, lg_ptr, 2, s7_make_integer(sc, loc));
    s7_list_set(sc, lg_ptr, 3, notify);
    res_ult = s7_make_integer(sc, g_timeout_add_full((gint)s7_integer(priority), (guint)s7_integer(interval), lg_timer_func, (gpointer)lg_ptr, lg_destroy_func));
    return(res_ult);
   }
}

static s7_pointer lg_g_timeout_add(s7_scheme *sc, s7_pointer args)
{
  #define H_g_timeout_add "guint g_timeout_add(guint interval, GSourceFunc func, lambda_data func_info)"
  s7_pointer _p;
  s7_pointer interval, func, func_info;
  _p = args;
  interval = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(interval)) s7_wrong_type_arg_error(sc, "g_timeout_add", 1, interval, "guint");
  func = s7_car(_p); _p = s7_cdr(_p);
  func_info = s7_car(_p);
  {
    s7_pointer res_ult;
    int loc;
    s7_pointer lg_ptr = s7_list(sc, 5, func, func_info, lg_false, lg_false, lg_false);
    loc = s7_gc_protect(sc, lg_ptr);
    s7_list_set(sc, lg_ptr, 2, s7_make_integer(sc, loc));
    res_ult = s7_make_integer(sc, g_timeout_add((guint)s7_integer(interval), lg_timer_func, (gpointer)lg_ptr));
    return(res_ult);
   }
}

static s7_pointer lg_g_idle_add(s7_scheme *sc, s7_pointer args)
{
  #define H_g_idle_add "guint g_idle_add(GSourceFunc func, lambda_data func_info)"
  s7_pointer _p;
  s7_pointer func, func_info;
  _p = args;
  func = s7_car(_p); _p = s7_cdr(_p);
  func_info = s7_car(_p);
  {
    s7_pointer res_ult;
    int loc;
    s7_pointer lg_ptr = s7_list(sc, 5, func, func_info, lg_false, lg_false, lg_false);
    loc = s7_gc_protect(sc, lg_ptr);
    s7_list_set(sc, lg_ptr, 2, s7_make_integer(sc, loc));
    res_ult = s7_make_integer(sc, g_idle_add(lg_timer_func, (gpointer)lg_ptr));
    return(res_ult);
   }
}

static s7_pointer lg_g_idle_add_full(s7_scheme *sc, s7_pointer args)
{
  #define H_g_idle_add_full "guint g_idle_add_full(gint priority, GSourceFunc func, lambda_data func_info, \
GtkDestroyNotify notify)"
  s7_pointer _p;
  s7_pointer priority, func, func_info, notify;
  _p = args;
  priority = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(priority)) s7_wrong_type_arg_error(sc, "g_idle_add_full", 1, priority, "gint");
  func = s7_car(_p); _p = s7_cdr(_p);
  func_info = s7_car(_p); _p = s7_cdr(_p);
  notify = s7_car(_p);
  {
    s7_pointer res_ult;
    int loc;
    s7_pointer lg_ptr = s7_list(sc, 5, func, func_info, lg_false, lg_false, lg_false);
    loc = s7_gc_protect(sc, lg_ptr);
    s7_list_set(sc, lg_ptr, 2, s7_make_integer(sc, loc));
    s7_list_set(sc, lg_ptr, 3, notify);
    res_ult = s7_make_integer(sc, g_idle_add_full((gint)s7_integer(priority), lg_timer_func, (gpointer)lg_ptr, lg_destroy_func));
    return(res_ult);
   }
}

static s7_pointer lg_g_idle_remove_by_data(s7_scheme *sc, s7_pointer args)
{
  #define H_g_idle_remove_by_data "gboolean g_idle_remove_by_data(gpointer data)"
  s7_pointer data;
  data = s7_car(args);
  if (!s7_is_c_pointer_of_type(data, gpointer_sym)) s7_wrong_type_arg_error(sc, "g_idle_remove_by_data", 1, data, "gpointer");
  return(s7_make_boolean(sc, g_idle_remove_by_data((gpointer)s7_c_pointer(data))));
}

static s7_pointer lg_g_source_remove(s7_scheme *sc, s7_pointer args)
{
  #define H_g_source_remove "gboolean g_source_remove(guint tag)"
  s7_pointer tag;
  tag = s7_car(args);
  if (!s7_is_integer(tag)) s7_wrong_type_arg_error(sc, "g_source_remove", 1, tag, "guint");
  return(s7_make_boolean(sc, g_source_remove((guint)s7_integer(tag))));
}

static s7_pointer lg_gtk_file_filter_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_file_filter_new "GtkFileFilter* gtk_file_filter_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkFileFilter__sym, gtk_file_filter_new()));
}

static s7_pointer lg_gtk_file_filter_set_name(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_file_filter_set_name "void gtk_file_filter_set_name(GtkFileFilter* filter, gchar* name)"
  s7_pointer _p;
  s7_pointer filter, name;
  _p = args;
  filter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(filter, GtkFileFilter__sym)) s7_wrong_type_arg_error(sc, "gtk_file_filter_set_name", 1, filter, "GtkFileFilter*");
  name = s7_car(_p);
  if (!s7_is_string(name)) s7_wrong_type_arg_error(sc, "gtk_file_filter_set_name", 2, name, "gchar*");
  gtk_file_filter_set_name((GtkFileFilter*)s7_c_pointer(filter), (gchar*)s7_string(name));
  return(lg_false);
}

static s7_pointer lg_gtk_file_filter_get_name(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_file_filter_get_name "gchar* gtk_file_filter_get_name(GtkFileFilter* filter)"
  s7_pointer filter;
  filter = s7_car(args);
  if (!s7_is_c_pointer_of_type(filter, GtkFileFilter__sym)) s7_wrong_type_arg_error(sc, "gtk_file_filter_get_name", 1, filter, "GtkFileFilter*");
  return(s7_make_string(sc, gtk_file_filter_get_name((GtkFileFilter*)s7_c_pointer(filter))));
}

static s7_pointer lg_gtk_file_filter_add_mime_type(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_file_filter_add_mime_type "void gtk_file_filter_add_mime_type(GtkFileFilter* filter, \
gchar* mime_type)"
  s7_pointer _p;
  s7_pointer filter, mime_type;
  _p = args;
  filter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(filter, GtkFileFilter__sym)) s7_wrong_type_arg_error(sc, "gtk_file_filter_add_mime_type", 1, filter, "GtkFileFilter*");
  mime_type = s7_car(_p);
  if (!s7_is_string(mime_type)) s7_wrong_type_arg_error(sc, "gtk_file_filter_add_mime_type", 2, mime_type, "gchar*");
  gtk_file_filter_add_mime_type((GtkFileFilter*)s7_c_pointer(filter), (gchar*)s7_string(mime_type));
  return(lg_false);
}

static s7_pointer lg_gtk_file_filter_add_pattern(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_file_filter_add_pattern "void gtk_file_filter_add_pattern(GtkFileFilter* filter, gchar* pattern)"
  s7_pointer _p;
  s7_pointer filter, pattern;
  _p = args;
  filter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(filter, GtkFileFilter__sym)) s7_wrong_type_arg_error(sc, "gtk_file_filter_add_pattern", 1, filter, "GtkFileFilter*");
  pattern = s7_car(_p);
  if (!s7_is_string(pattern)) s7_wrong_type_arg_error(sc, "gtk_file_filter_add_pattern", 2, pattern, "gchar*");
  gtk_file_filter_add_pattern((GtkFileFilter*)s7_c_pointer(filter), (gchar*)s7_string(pattern));
  return(lg_false);
}

static s7_pointer lg_gtk_file_filter_add_custom(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_file_filter_add_custom "void gtk_file_filter_add_custom(GtkFileFilter* filter, GtkFileFilterFlags needed, \
GtkFileFilterFunc func, lambda_data func_info, GtkDestroyNotify notify)"
  s7_pointer _p;
  s7_pointer filter, needed, func, func_info, notify;
  _p = args;
  filter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(filter, GtkFileFilter__sym)) s7_wrong_type_arg_error(sc, "gtk_file_filter_add_custom", 1, filter, "GtkFileFilter*");
  needed = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(needed)) s7_wrong_type_arg_error(sc, "gtk_file_filter_add_custom", 2, needed, "GtkFileFilterFlags");
  func = s7_car(_p); _p = s7_cdr(_p);
  func_info = s7_car(_p); _p = s7_cdr(_p);
  notify = s7_car(_p);
  {
    s7_pointer lg_ptr = s7_list(sc, 5, func, func_info, lg_false, lg_false, lg_false);
    s7_gc_protect(sc, lg_ptr);
    s7_list_set(sc, lg_ptr, 3, notify);
    gtk_file_filter_add_custom((GtkFileFilter*)s7_c_pointer(filter), (GtkFileFilterFlags)s7_integer(needed), lg_file_filter, (gpointer)lg_ptr, lg_destroy_func);
    return(lg_false);
   }
}

static s7_pointer lg_gtk_file_filter_get_needed(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_file_filter_get_needed "GtkFileFilterFlags gtk_file_filter_get_needed(GtkFileFilter* filter)"
  s7_pointer filter;
  filter = s7_car(args);
  if (!s7_is_c_pointer_of_type(filter, GtkFileFilter__sym)) s7_wrong_type_arg_error(sc, "gtk_file_filter_get_needed", 1, filter, "GtkFileFilter*");
  return(s7_make_integer(sc, gtk_file_filter_get_needed((GtkFileFilter*)s7_c_pointer(filter))));
}

static s7_pointer lg_gtk_file_filter_filter(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_file_filter_filter "gboolean gtk_file_filter_filter(GtkFileFilter* filter, GtkFileFilterInfo* filter_info)"
  s7_pointer _p;
  s7_pointer filter, filter_info;
  _p = args;
  filter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(filter, GtkFileFilter__sym)) s7_wrong_type_arg_error(sc, "gtk_file_filter_filter", 1, filter, "GtkFileFilter*");
  filter_info = s7_car(_p);
  if (!s7_is_c_pointer_of_type(filter_info, GtkFileFilterInfo__sym)) s7_wrong_type_arg_error(sc, "gtk_file_filter_filter", 2, filter_info, "GtkFileFilterInfo*");
  return(s7_make_boolean(sc, gtk_file_filter_filter((GtkFileFilter*)s7_c_pointer(filter), (GtkFileFilterInfo*)s7_c_pointer(filter_info))));
}

static s7_pointer lg_gtk_cell_layout_pack_start(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_layout_pack_start "void gtk_cell_layout_pack_start(GtkCellLayout* cell_layout, GtkCellRenderer* cell, \
gboolean expand)"
  s7_pointer _p;
  s7_pointer cell_layout, cell, expand;
  _p = args;
  cell_layout = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(cell_layout, GtkCellLayout__sym)) s7_wrong_type_arg_error(sc, "gtk_cell_layout_pack_start", 1, cell_layout, "GtkCellLayout*");
  cell = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(cell, GtkCellRenderer__sym)) s7_wrong_type_arg_error(sc, "gtk_cell_layout_pack_start", 2, cell, "GtkCellRenderer*");
  expand = s7_car(_p);
  if (!s7_is_boolean(expand)) s7_wrong_type_arg_error(sc, "gtk_cell_layout_pack_start", 3, expand, "gboolean");
  gtk_cell_layout_pack_start((GtkCellLayout*)s7_c_pointer(cell_layout), (GtkCellRenderer*)s7_c_pointer(cell), (gboolean)lg_boolean(expand));
  return(lg_false);
}

static s7_pointer lg_gtk_cell_layout_pack_end(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_layout_pack_end "void gtk_cell_layout_pack_end(GtkCellLayout* cell_layout, GtkCellRenderer* cell, \
gboolean expand)"
  s7_pointer _p;
  s7_pointer cell_layout, cell, expand;
  _p = args;
  cell_layout = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(cell_layout, GtkCellLayout__sym)) s7_wrong_type_arg_error(sc, "gtk_cell_layout_pack_end", 1, cell_layout, "GtkCellLayout*");
  cell = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(cell, GtkCellRenderer__sym)) s7_wrong_type_arg_error(sc, "gtk_cell_layout_pack_end", 2, cell, "GtkCellRenderer*");
  expand = s7_car(_p);
  if (!s7_is_boolean(expand)) s7_wrong_type_arg_error(sc, "gtk_cell_layout_pack_end", 3, expand, "gboolean");
  gtk_cell_layout_pack_end((GtkCellLayout*)s7_c_pointer(cell_layout), (GtkCellRenderer*)s7_c_pointer(cell), (gboolean)lg_boolean(expand));
  return(lg_false);
}

static s7_pointer lg_gtk_cell_layout_clear(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_layout_clear "void gtk_cell_layout_clear(GtkCellLayout* cell_layout)"
  s7_pointer cell_layout;
  cell_layout = s7_car(args);
  if (!s7_is_c_pointer_of_type(cell_layout, GtkCellLayout__sym)) s7_wrong_type_arg_error(sc, "gtk_cell_layout_clear", 1, cell_layout, "GtkCellLayout*");
  gtk_cell_layout_clear((GtkCellLayout*)s7_c_pointer(cell_layout));
  return(lg_false);
}

static s7_pointer lg_gtk_cell_layout_set_attributes(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_layout_set_attributes "void gtk_cell_layout_set_attributes(GtkCellLayout* cell_layout, \
GtkCellRenderer* cell, etc attributes)"
  s7_pointer _p;
  s7_pointer cell_layout, cell, attributes;
  _p = args;
  cell_layout = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(cell_layout, GtkCellLayout__sym)) s7_wrong_type_arg_error(sc, "gtk_cell_layout_set_attributes", 1, cell_layout, "GtkCellLayout*");
  cell = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(cell, GtkCellRenderer__sym)) s7_wrong_type_arg_error(sc, "gtk_cell_layout_set_attributes", 2, cell, "GtkCellRenderer*");
  attributes = s7_car(_p);
  if (!lg_is_list(attributes)) s7_wrong_type_arg_error(sc, "gtk_cell_layout_set_attributes", 3, attributes, "etc");
  {
    int etc_len = 0;
    GtkCellLayout* p_arg0;
    GtkCellRenderer* p_arg1;
    if (s7_is_list(sc, attributes)) etc_len = s7_list_length(sc, attributes);
    if (etc_len < 2) s7_out_of_range_error(sc, "gtk_cell_layout_set_attributes", 2, attributes, "... list must have at least 2 entries");
    if (etc_len > 10) s7_out_of_range_error(sc, "gtk_cell_layout_set_attributes", 2, attributes, "... list too long (max len: 10)");
    if ((etc_len % 2) != 0) s7_out_of_range_error(sc, "gtk_cell_layout_set_attributes", 2, attributes, "... list len must be multiple of 2");
    p_arg0 = (GtkCellLayout*)s7_c_pointer(cell_layout);
    p_arg1 = (GtkCellRenderer*)s7_c_pointer(cell);
    switch (etc_len)
      {
        case 2: gtk_cell_layout_set_attributes(p_arg0, p_arg1, s7_string(s7_list_ref(sc, attributes, 0)), s7_integer(s7_list_ref(sc, attributes, 1)), NULL); break;
        case 4: gtk_cell_layout_set_attributes(p_arg0, p_arg1, s7_string(s7_list_ref(sc, attributes, 0)), s7_integer(s7_list_ref(sc, attributes, 1)), s7_string(s7_list_ref(sc, attributes, 2)), s7_integer(s7_list_ref(sc, attributes, 3)), NULL); break;
        case 6: gtk_cell_layout_set_attributes(p_arg0, p_arg1, s7_string(s7_list_ref(sc, attributes, 0)), s7_integer(s7_list_ref(sc, attributes, 1)), s7_string(s7_list_ref(sc, attributes, 2)), s7_integer(s7_list_ref(sc, attributes, 3)), s7_string(s7_list_ref(sc, attributes, 4)), s7_integer(s7_list_ref(sc, attributes, 5)), NULL); break;
        case 8: gtk_cell_layout_set_attributes(p_arg0, p_arg1, s7_string(s7_list_ref(sc, attributes, 0)), s7_integer(s7_list_ref(sc, attributes, 1)), s7_string(s7_list_ref(sc, attributes, 2)), s7_integer(s7_list_ref(sc, attributes, 3)), s7_string(s7_list_ref(sc, attributes, 4)), s7_integer(s7_list_ref(sc, attributes, 5)), s7_string(s7_list_ref(sc, attributes, 6)), s7_integer(s7_list_ref(sc, attributes, 7)), NULL); break;
        case 10: gtk_cell_layout_set_attributes(p_arg0, p_arg1, s7_string(s7_list_ref(sc, attributes, 0)), s7_integer(s7_list_ref(sc, attributes, 1)), s7_string(s7_list_ref(sc, attributes, 2)), s7_integer(s7_list_ref(sc, attributes, 3)), s7_string(s7_list_ref(sc, attributes, 4)), s7_integer(s7_list_ref(sc, attributes, 5)), s7_string(s7_list_ref(sc, attributes, 6)), s7_integer(s7_list_ref(sc, attributes, 7)), s7_string(s7_list_ref(sc, attributes, 8)), s7_integer(s7_list_ref(sc, attributes, 9)), NULL); break;
      }
    return(lg_false);
  }
}

static s7_pointer lg_gtk_cell_layout_add_attribute(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_layout_add_attribute "void gtk_cell_layout_add_attribute(GtkCellLayout* cell_layout, \
GtkCellRenderer* cell, gchar* attribute, gint column)"
  s7_pointer _p;
  s7_pointer cell_layout, cell, attribute, column;
  _p = args;
  cell_layout = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(cell_layout, GtkCellLayout__sym)) s7_wrong_type_arg_error(sc, "gtk_cell_layout_add_attribute", 1, cell_layout, "GtkCellLayout*");
  cell = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(cell, GtkCellRenderer__sym)) s7_wrong_type_arg_error(sc, "gtk_cell_layout_add_attribute", 2, cell, "GtkCellRenderer*");
  attribute = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(attribute)) s7_wrong_type_arg_error(sc, "gtk_cell_layout_add_attribute", 3, attribute, "gchar*");
  column = s7_car(_p);
  if (!s7_is_integer(column)) s7_wrong_type_arg_error(sc, "gtk_cell_layout_add_attribute", 4, column, "gint");
  gtk_cell_layout_add_attribute((GtkCellLayout*)s7_c_pointer(cell_layout), (GtkCellRenderer*)s7_c_pointer(cell), (gchar*)s7_string(attribute), (gint)s7_integer(column));
  return(lg_false);
}

static s7_pointer lg_gtk_cell_layout_set_cell_data_func(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_layout_set_cell_data_func "void gtk_cell_layout_set_cell_data_func(GtkCellLayout* cell_layout, \
GtkCellRenderer* cell, GtkCellLayoutDataFunc func, lambda_data func_info, GtkDestroyNotify destroy)"
  s7_pointer _p;
  s7_pointer cell_layout, cell, func, func_info, destroy;
  _p = args;
  cell_layout = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(cell_layout, GtkCellLayout__sym)) s7_wrong_type_arg_error(sc, "gtk_cell_layout_set_cell_data_func", 1, cell_layout, "GtkCellLayout*");
  cell = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(cell, GtkCellRenderer__sym)) s7_wrong_type_arg_error(sc, "gtk_cell_layout_set_cell_data_func", 2, cell, "GtkCellRenderer*");
  func = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(func, GtkCellLayoutDataFunc_sym)) s7_wrong_type_arg_error(sc, "gtk_cell_layout_set_cell_data_func", 3, func, "GtkCellLayoutDataFunc");
  func_info = s7_car(_p); _p = s7_cdr(_p);
  destroy = s7_car(_p);
  {
    s7_pointer lg_ptr = s7_list(sc, 5, func, func_info, lg_false, lg_false, lg_false);
    s7_gc_protect(sc, lg_ptr);
    s7_list_set(sc, lg_ptr, 3, destroy);
    gtk_cell_layout_set_cell_data_func((GtkCellLayout*)s7_c_pointer(cell_layout), (GtkCellRenderer*)s7_c_pointer(cell), (GtkCellLayoutDataFunc)s7_c_pointer(func), (gpointer)lg_ptr, lg_destroy_func);
    return(lg_false);
   }
}

static s7_pointer lg_gtk_cell_layout_clear_attributes(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_layout_clear_attributes "void gtk_cell_layout_clear_attributes(GtkCellLayout* cell_layout, \
GtkCellRenderer* cell)"
  s7_pointer _p;
  s7_pointer cell_layout, cell;
  _p = args;
  cell_layout = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(cell_layout, GtkCellLayout__sym)) s7_wrong_type_arg_error(sc, "gtk_cell_layout_clear_attributes", 1, cell_layout, "GtkCellLayout*");
  cell = s7_car(_p);
  if (!s7_is_c_pointer_of_type(cell, GtkCellRenderer__sym)) s7_wrong_type_arg_error(sc, "gtk_cell_layout_clear_attributes", 2, cell, "GtkCellRenderer*");
  gtk_cell_layout_clear_attributes((GtkCellLayout*)s7_c_pointer(cell_layout), (GtkCellRenderer*)s7_c_pointer(cell));
  return(lg_false);
}

static s7_pointer lg_gtk_file_chooser_set_action(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_file_chooser_set_action "void gtk_file_chooser_set_action(GtkFileChooser* chooser, GtkFileChooserAction action)"
  s7_pointer _p;
  s7_pointer chooser, action;
  _p = args;
  chooser = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(chooser, GtkFileChooser__sym)) s7_wrong_type_arg_error(sc, "gtk_file_chooser_set_action", 1, chooser, "GtkFileChooser*");
  action = s7_car(_p);
  if (!s7_is_integer(action)) s7_wrong_type_arg_error(sc, "gtk_file_chooser_set_action", 2, action, "GtkFileChooserAction");
  gtk_file_chooser_set_action((GtkFileChooser*)s7_c_pointer(chooser), (GtkFileChooserAction)s7_integer(action));
  return(lg_false);
}

static s7_pointer lg_gtk_file_chooser_get_action(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_file_chooser_get_action "GtkFileChooserAction gtk_file_chooser_get_action(GtkFileChooser* chooser)"
  s7_pointer chooser;
  chooser = s7_car(args);
  if (!s7_is_c_pointer_of_type(chooser, GtkFileChooser__sym)) s7_wrong_type_arg_error(sc, "gtk_file_chooser_get_action", 1, chooser, "GtkFileChooser*");
  return(s7_make_integer(sc, gtk_file_chooser_get_action((GtkFileChooser*)s7_c_pointer(chooser))));
}

static s7_pointer lg_gtk_list_store_remove(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_list_store_remove "gboolean gtk_list_store_remove(GtkListStore* list_store, GtkTreeIter* iter)"
  s7_pointer _p;
  s7_pointer list_store, iter;
  _p = args;
  list_store = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(list_store, GtkListStore__sym)) s7_wrong_type_arg_error(sc, "gtk_list_store_remove", 1, list_store, "GtkListStore*");
  iter = s7_car(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTreeIter__sym)) s7_wrong_type_arg_error(sc, "gtk_list_store_remove", 2, iter, "GtkTreeIter*");
  return(s7_make_boolean(sc, gtk_list_store_remove((GtkListStore*)s7_c_pointer(list_store), (GtkTreeIter*)s7_c_pointer(iter))));
}

static s7_pointer lg_gtk_cell_layout_reorder(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_layout_reorder "void gtk_cell_layout_reorder(GtkCellLayout* cell_layout, GtkCellRenderer* cell, \
gint position)"
  s7_pointer _p;
  s7_pointer cell_layout, cell, position;
  _p = args;
  cell_layout = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(cell_layout, GtkCellLayout__sym)) s7_wrong_type_arg_error(sc, "gtk_cell_layout_reorder", 1, cell_layout, "GtkCellLayout*");
  cell = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(cell, GtkCellRenderer__sym)) s7_wrong_type_arg_error(sc, "gtk_cell_layout_reorder", 2, cell, "GtkCellRenderer*");
  position = s7_car(_p);
  if (!s7_is_integer(position)) s7_wrong_type_arg_error(sc, "gtk_cell_layout_reorder", 3, position, "gint");
  gtk_cell_layout_reorder((GtkCellLayout*)s7_c_pointer(cell_layout), (GtkCellRenderer*)s7_c_pointer(cell), (gint)s7_integer(position));
  return(lg_false);
}

static s7_pointer lg_g_list_nth_data(s7_scheme *sc, s7_pointer args)
{
  #define H_g_list_nth_data "gpointer g_list_nth_data(GList* list, guint n)"
  s7_pointer _p;
  s7_pointer list, n;
  _p = args;
  list = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(list, GList__sym)) s7_wrong_type_arg_error(sc, "g_list_nth_data", 1, list, "GList*");
  n = s7_car(_p);
  if (!s7_is_integer(n)) s7_wrong_type_arg_error(sc, "g_list_nth_data", 2, n, "guint");
  return(lg_make_c_pointer_with_type(sc, gpointer_sym, g_list_nth_data((GList*)s7_c_pointer(list), (guint)s7_integer(n))));
}

static s7_pointer lg_gtk_combo_box_popup(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_combo_box_popup "void gtk_combo_box_popup(GtkComboBox* combo_box)"
  s7_pointer combo_box;
  combo_box = s7_car(args);
  if (!s7_is_c_pointer_of_type(combo_box, GtkComboBox__sym)) s7_wrong_type_arg_error(sc, "gtk_combo_box_popup", 1, combo_box, "GtkComboBox*");
  gtk_combo_box_popup((GtkComboBox*)s7_c_pointer(combo_box));
  return(lg_false);
}

static s7_pointer lg_gtk_combo_box_popdown(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_combo_box_popdown "void gtk_combo_box_popdown(GtkComboBox* combo_box)"
  s7_pointer combo_box;
  combo_box = s7_car(args);
  if (!s7_is_c_pointer_of_type(combo_box, GtkComboBox__sym)) s7_wrong_type_arg_error(sc, "gtk_combo_box_popdown", 1, combo_box, "GtkComboBox*");
  gtk_combo_box_popdown((GtkComboBox*)s7_c_pointer(combo_box));
  return(lg_false);
}

static s7_pointer lg_gtk_scale_get_layout(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_scale_get_layout "PangoLayout* gtk_scale_get_layout(GtkScale* scale)"
  s7_pointer scale;
  scale = s7_car(args);
  if (!s7_is_c_pointer_of_type(scale, GtkScale__sym)) s7_wrong_type_arg_error(sc, "gtk_scale_get_layout", 1, scale, "GtkScale*");
  return(lg_make_c_pointer_with_type(sc, PangoLayout__sym, gtk_scale_get_layout((GtkScale*)s7_c_pointer(scale))));
}

static s7_pointer lg_gtk_scale_get_layout_offsets(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_scale_get_layout_offsets "void gtk_scale_get_layout_offsets(GtkScale* scale, gint* [x], \
gint* [y])"
  s7_pointer _p;
  s7_pointer scale;
  gint ref_x;
  gint ref_y;
  _p = args;
  scale = s7_car(_p);
  if (!s7_is_c_pointer_of_type(scale, GtkScale__sym)) s7_wrong_type_arg_error(sc, "gtk_scale_get_layout_offsets", 1, scale, "GtkScale*");
  gtk_scale_get_layout_offsets((GtkScale*)s7_c_pointer(scale), &ref_x, &ref_y);
    return(s7_list(sc, 2, s7_make_integer(sc, ref_x), s7_make_integer(sc, ref_y)));
}

static s7_pointer lg_gtk_entry_set_alignment(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_set_alignment "void gtk_entry_set_alignment(GtkEntry* entry, gfloat xalign)"
  s7_pointer _p;
  s7_pointer entry, xalign;
  _p = args;
  entry = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(entry, GtkEntry__sym)) s7_wrong_type_arg_error(sc, "gtk_entry_set_alignment", 1, entry, "GtkEntry*");
  xalign = s7_car(_p);
  if (!s7_is_real(xalign)) s7_wrong_type_arg_error(sc, "gtk_entry_set_alignment", 2, xalign, "gfloat");
  gtk_entry_set_alignment((GtkEntry*)s7_c_pointer(entry), (gfloat)s7_real(xalign));
  return(lg_false);
}

static s7_pointer lg_gtk_entry_get_alignment(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_get_alignment "gfloat gtk_entry_get_alignment(GtkEntry* entry)"
  s7_pointer entry;
  entry = s7_car(args);
  if (!s7_is_c_pointer_of_type(entry, GtkEntry__sym)) s7_wrong_type_arg_error(sc, "gtk_entry_get_alignment", 1, entry, "GtkEntry*");
  return(s7_make_real(sc, gtk_entry_get_alignment((GtkEntry*)s7_c_pointer(entry))));
}

static s7_pointer lg_gtk_widget_list_mnemonic_labels(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_list_mnemonic_labels "GList* gtk_widget_list_mnemonic_labels(GtkWidget* widget)"
  s7_pointer widget;
  widget = s7_car(args);
  if (!s7_is_c_pointer_of_type(widget, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_widget_list_mnemonic_labels", 1, widget, "GtkWidget*");
  return(lg_make_c_pointer_with_type(sc, GList__sym, gtk_widget_list_mnemonic_labels((GtkWidget*)s7_c_pointer(widget))));
}

static s7_pointer lg_gtk_widget_add_mnemonic_label(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_add_mnemonic_label "void gtk_widget_add_mnemonic_label(GtkWidget* widget, GtkWidget* label)"
  s7_pointer _p;
  s7_pointer widget, label;
  _p = args;
  widget = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(widget, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_widget_add_mnemonic_label", 1, widget, "GtkWidget*");
  label = s7_car(_p);
  if (!s7_is_c_pointer_of_type(label, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_widget_add_mnemonic_label", 2, label, "GtkWidget*");
  gtk_widget_add_mnemonic_label((GtkWidget*)s7_c_pointer(widget), (GtkWidget*)s7_c_pointer(label));
  return(lg_false);
}

static s7_pointer lg_gtk_widget_remove_mnemonic_label(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_widget_remove_mnemonic_label "void gtk_widget_remove_mnemonic_label(GtkWidget* widget, \
GtkWidget* label)"
  s7_pointer _p;
  s7_pointer widget, label;
  _p = args;
  widget = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(widget, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_widget_remove_mnemonic_label", 1, widget, "GtkWidget*");
  label = s7_car(_p);
  if (!s7_is_c_pointer_of_type(label, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_widget_remove_mnemonic_label", 2, label, "GtkWidget*");
  gtk_widget_remove_mnemonic_label((GtkWidget*)s7_c_pointer(widget), (GtkWidget*)s7_c_pointer(label));
  return(lg_false);
}

static s7_pointer lg_g_quark_from_string(s7_scheme *sc, s7_pointer args)
{
  #define H_g_quark_from_string "GQuark g_quark_from_string(gchar* string)"
  s7_pointer string;
  string = s7_car(args);
  if (!s7_is_string(string)) s7_wrong_type_arg_error(sc, "g_quark_from_string", 1, string, "gchar*");
  return(s7_make_integer(sc, g_quark_from_string((gchar*)s7_string(string))));
}

static s7_pointer lg_g_quark_to_string(s7_scheme *sc, s7_pointer args)
{
  #define H_g_quark_to_string "gchar* g_quark_to_string(GQuark quark)"
  s7_pointer quark;
  quark = s7_car(args);
  if (!s7_is_integer(quark)) s7_wrong_type_arg_error(sc, "g_quark_to_string", 1, quark, "GQuark");
  return(s7_make_string(sc, g_quark_to_string((GQuark)s7_integer(quark))));
}

static s7_pointer lg_gtk_cell_view_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_view_new "GtkWidget* gtk_cell_view_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_cell_view_new()));
}

static s7_pointer lg_gtk_cell_view_new_with_text(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_view_new_with_text "GtkWidget* gtk_cell_view_new_with_text(gchar* text)"
  s7_pointer text;
  text = s7_car(args);
  if (!s7_is_string(text)) s7_wrong_type_arg_error(sc, "gtk_cell_view_new_with_text", 1, text, "gchar*");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_cell_view_new_with_text((gchar*)s7_string(text))));
}

static s7_pointer lg_gtk_cell_view_new_with_markup(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_view_new_with_markup "GtkWidget* gtk_cell_view_new_with_markup(gchar* markup)"
  s7_pointer markup;
  markup = s7_car(args);
  if (!s7_is_string(markup)) s7_wrong_type_arg_error(sc, "gtk_cell_view_new_with_markup", 1, markup, "gchar*");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_cell_view_new_with_markup((gchar*)s7_string(markup))));
}

static s7_pointer lg_gtk_cell_view_set_model(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_view_set_model "void gtk_cell_view_set_model(GtkCellView* cell_view, GtkTreeModel* model)"
  s7_pointer _p;
  s7_pointer cell_view, model;
  _p = args;
  cell_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(cell_view, GtkCellView__sym)) s7_wrong_type_arg_error(sc, "gtk_cell_view_set_model", 1, cell_view, "GtkCellView*");
  model = s7_car(_p);
  if ((!s7_is_c_pointer_of_type(model, GtkTreeModel__sym)) && (model != lg_false)) s7_wrong_type_arg_error(sc, "gtk_cell_view_set_model", 2, model, "GtkTreeModel*");
  gtk_cell_view_set_model((GtkCellView*)s7_c_pointer(cell_view), (GtkTreeModel*)s7_c_pointer(model));
  return(lg_false);
}

static s7_pointer lg_gtk_cell_view_set_displayed_row(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_view_set_displayed_row "void gtk_cell_view_set_displayed_row(GtkCellView* cell_view, \
GtkTreePath* path)"
  s7_pointer _p;
  s7_pointer cell_view, path;
  _p = args;
  cell_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(cell_view, GtkCellView__sym)) s7_wrong_type_arg_error(sc, "gtk_cell_view_set_displayed_row", 1, cell_view, "GtkCellView*");
  path = s7_car(_p);
  if (!s7_is_c_pointer_of_type(path, GtkTreePath__sym)) s7_wrong_type_arg_error(sc, "gtk_cell_view_set_displayed_row", 2, path, "GtkTreePath*");
  gtk_cell_view_set_displayed_row((GtkCellView*)s7_c_pointer(cell_view), (GtkTreePath*)s7_c_pointer(path));
  return(lg_false);
}

static s7_pointer lg_gtk_cell_view_get_displayed_row(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_view_get_displayed_row "GtkTreePath* gtk_cell_view_get_displayed_row(GtkCellView* cell_view)"
  s7_pointer cell_view;
  cell_view = s7_car(args);
  if (!s7_is_c_pointer_of_type(cell_view, GtkCellView__sym)) s7_wrong_type_arg_error(sc, "gtk_cell_view_get_displayed_row", 1, cell_view, "GtkCellView*");
  return(lg_make_c_pointer_with_type(sc, GtkTreePath__sym, gtk_cell_view_get_displayed_row((GtkCellView*)s7_c_pointer(cell_view))));
}

static s7_pointer lg_gtk_entry_completion_insert_prefix(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_completion_insert_prefix "void gtk_entry_completion_insert_prefix(GtkEntryCompletion* completion)"
  s7_pointer completion;
  completion = s7_car(args);
  if (!s7_is_c_pointer_of_type(completion, GtkEntryCompletion__sym)) s7_wrong_type_arg_error(sc, "gtk_entry_completion_insert_prefix", 1, completion, "GtkEntryCompletion*");
  gtk_entry_completion_insert_prefix((GtkEntryCompletion*)s7_c_pointer(completion));
  return(lg_false);
}

static s7_pointer lg_gtk_entry_completion_set_inline_completion(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_completion_set_inline_completion "void gtk_entry_completion_set_inline_completion(GtkEntryCompletion* completion, \
gboolean inline_completion)"
  s7_pointer _p;
  s7_pointer completion, inline_completion;
  _p = args;
  completion = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(completion, GtkEntryCompletion__sym)) s7_wrong_type_arg_error(sc, "gtk_entry_completion_set_inline_completion", 1, completion, "GtkEntryCompletion*");
  inline_completion = s7_car(_p);
  if (!s7_is_boolean(inline_completion)) s7_wrong_type_arg_error(sc, "gtk_entry_completion_set_inline_completion", 2, inline_completion, "gboolean");
  gtk_entry_completion_set_inline_completion((GtkEntryCompletion*)s7_c_pointer(completion), (gboolean)lg_boolean(inline_completion));
  return(lg_false);
}

static s7_pointer lg_gtk_entry_completion_get_inline_completion(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_completion_get_inline_completion "gboolean gtk_entry_completion_get_inline_completion(GtkEntryCompletion* completion)"
  s7_pointer completion;
  completion = s7_car(args);
  if (!s7_is_c_pointer_of_type(completion, GtkEntryCompletion__sym)) s7_wrong_type_arg_error(sc, "gtk_entry_completion_get_inline_completion", 1, completion, "GtkEntryCompletion*");
  return(s7_make_boolean(sc, gtk_entry_completion_get_inline_completion((GtkEntryCompletion*)s7_c_pointer(completion))));
}

static s7_pointer lg_gtk_entry_completion_set_popup_completion(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_completion_set_popup_completion "void gtk_entry_completion_set_popup_completion(GtkEntryCompletion* completion, \
gboolean popup_completion)"
  s7_pointer _p;
  s7_pointer completion, popup_completion;
  _p = args;
  completion = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(completion, GtkEntryCompletion__sym)) s7_wrong_type_arg_error(sc, "gtk_entry_completion_set_popup_completion", 1, completion, "GtkEntryCompletion*");
  popup_completion = s7_car(_p);
  if (!s7_is_boolean(popup_completion)) s7_wrong_type_arg_error(sc, "gtk_entry_completion_set_popup_completion", 2, popup_completion, "gboolean");
  gtk_entry_completion_set_popup_completion((GtkEntryCompletion*)s7_c_pointer(completion), (gboolean)lg_boolean(popup_completion));
  return(lg_false);
}

static s7_pointer lg_gtk_entry_completion_get_popup_completion(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_completion_get_popup_completion "gboolean gtk_entry_completion_get_popup_completion(GtkEntryCompletion* completion)"
  s7_pointer completion;
  completion = s7_car(args);
  if (!s7_is_c_pointer_of_type(completion, GtkEntryCompletion__sym)) s7_wrong_type_arg_error(sc, "gtk_entry_completion_get_popup_completion", 1, completion, "GtkEntryCompletion*");
  return(s7_make_boolean(sc, gtk_entry_completion_get_popup_completion((GtkEntryCompletion*)s7_c_pointer(completion))));
}

static s7_pointer lg_gtk_entry_completion_get_text_column(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_completion_get_text_column "gint gtk_entry_completion_get_text_column(GtkEntryCompletion* completion)"
  s7_pointer completion;
  completion = s7_car(args);
  if (!s7_is_c_pointer_of_type(completion, GtkEntryCompletion__sym)) s7_wrong_type_arg_error(sc, "gtk_entry_completion_get_text_column", 1, completion, "GtkEntryCompletion*");
  return(s7_make_integer(sc, gtk_entry_completion_get_text_column((GtkEntryCompletion*)s7_c_pointer(completion))));
}

static s7_pointer lg_gtk_tree_view_set_fixed_height_mode(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_set_fixed_height_mode "void gtk_tree_view_set_fixed_height_mode(GtkTreeView* tree_view, \
gboolean enable)"
  s7_pointer _p;
  s7_pointer tree_view, enable;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_view, GtkTreeView__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_set_fixed_height_mode", 1, tree_view, "GtkTreeView*");
  enable = s7_car(_p);
  if (!s7_is_boolean(enable)) s7_wrong_type_arg_error(sc, "gtk_tree_view_set_fixed_height_mode", 2, enable, "gboolean");
  gtk_tree_view_set_fixed_height_mode((GtkTreeView*)s7_c_pointer(tree_view), (gboolean)lg_boolean(enable));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_get_fixed_height_mode(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_get_fixed_height_mode "gboolean gtk_tree_view_get_fixed_height_mode(GtkTreeView* tree_view)"
  s7_pointer tree_view;
  tree_view = s7_car(args);
  if (!s7_is_c_pointer_of_type(tree_view, GtkTreeView__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_get_fixed_height_mode", 1, tree_view, "GtkTreeView*");
  return(s7_make_boolean(sc, gtk_tree_view_get_fixed_height_mode((GtkTreeView*)s7_c_pointer(tree_view))));
}

static s7_pointer lg_gtk_tree_view_set_hover_selection(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_set_hover_selection "void gtk_tree_view_set_hover_selection(GtkTreeView* tree_view, \
gboolean hover)"
  s7_pointer _p;
  s7_pointer tree_view, hover;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_view, GtkTreeView__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_set_hover_selection", 1, tree_view, "GtkTreeView*");
  hover = s7_car(_p);
  if (!s7_is_boolean(hover)) s7_wrong_type_arg_error(sc, "gtk_tree_view_set_hover_selection", 2, hover, "gboolean");
  gtk_tree_view_set_hover_selection((GtkTreeView*)s7_c_pointer(tree_view), (gboolean)lg_boolean(hover));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_get_hover_selection(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_get_hover_selection "gboolean gtk_tree_view_get_hover_selection(GtkTreeView* tree_view)"
  s7_pointer tree_view;
  tree_view = s7_car(args);
  if (!s7_is_c_pointer_of_type(tree_view, GtkTreeView__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_get_hover_selection", 1, tree_view, "GtkTreeView*");
  return(s7_make_boolean(sc, gtk_tree_view_get_hover_selection((GtkTreeView*)s7_c_pointer(tree_view))));
}

static s7_pointer lg_gtk_tree_view_set_row_separator_func(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_set_row_separator_func "void gtk_tree_view_set_row_separator_func(GtkTreeView* tree_view, \
GtkTreeViewRowSeparatorFunc func, lambda_data func_info, GtkDestroyNotify destroy)"
  s7_pointer _p;
  s7_pointer tree_view, func, func_info, destroy;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_view, GtkTreeView__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_set_row_separator_func", 1, tree_view, "GtkTreeView*");
  func = s7_car(_p); _p = s7_cdr(_p);
  func_info = s7_car(_p); _p = s7_cdr(_p);
  destroy = s7_car(_p);
  {
    s7_pointer lg_ptr = s7_list(sc, 5, func, func_info, lg_false, lg_false, lg_false);
    s7_gc_protect(sc, lg_ptr);
    s7_list_set(sc, lg_ptr, 3, destroy);
    gtk_tree_view_set_row_separator_func((GtkTreeView*)s7_c_pointer(tree_view), lg_row_separator, (gpointer)lg_ptr, lg_destroy_func);
    return(lg_false);
   }
}

static s7_pointer lg_gtk_window_set_icon_name(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_window_set_icon_name "void gtk_window_set_icon_name(GtkWindow* window, gchar* name)"
  s7_pointer _p;
  s7_pointer window, name;
  _p = args;
  window = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(window, GtkWindow__sym)) s7_wrong_type_arg_error(sc, "gtk_window_set_icon_name", 1, window, "GtkWindow*");
  name = s7_car(_p);
  if (!s7_is_string(name)) s7_wrong_type_arg_error(sc, "gtk_window_set_icon_name", 2, name, "gchar*");
  gtk_window_set_icon_name((GtkWindow*)s7_c_pointer(window), (gchar*)s7_string(name));
  return(lg_false);
}

static s7_pointer lg_gtk_window_get_icon_name(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_window_get_icon_name "gchar* gtk_window_get_icon_name(GtkWindow* window)"
  s7_pointer window;
  window = s7_car(args);
  if (!s7_is_c_pointer_of_type(window, GtkWindow__sym)) s7_wrong_type_arg_error(sc, "gtk_window_get_icon_name", 1, window, "GtkWindow*");
  return(s7_make_string(sc, gtk_window_get_icon_name((GtkWindow*)s7_c_pointer(window))));
}

static s7_pointer lg_gtk_window_set_default_icon_name(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_window_set_default_icon_name "void gtk_window_set_default_icon_name(gchar* name)"
  s7_pointer name;
  name = s7_car(args);
  if (!s7_is_string(name)) s7_wrong_type_arg_error(sc, "gtk_window_set_default_icon_name", 1, name, "gchar*");
  gtk_window_set_default_icon_name((gchar*)s7_string(name));
  return(lg_false);
}

static s7_pointer lg_gtk_about_dialog_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_about_dialog_new "GtkWidget* gtk_about_dialog_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_about_dialog_new()));
}

static s7_pointer lg_gtk_about_dialog_get_version(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_about_dialog_get_version "gchar* gtk_about_dialog_get_version(GtkAboutDialog* about)"
  s7_pointer about;
  about = s7_car(args);
  if (!s7_is_c_pointer_of_type(about, GtkAboutDialog__sym)) s7_wrong_type_arg_error(sc, "gtk_about_dialog_get_version", 1, about, "GtkAboutDialog*");
  return(s7_make_string(sc, gtk_about_dialog_get_version((GtkAboutDialog*)s7_c_pointer(about))));
}

static s7_pointer lg_gtk_about_dialog_set_version(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_about_dialog_set_version "void gtk_about_dialog_set_version(GtkAboutDialog* about, gchar* version)"
  s7_pointer _p;
  s7_pointer about, version;
  _p = args;
  about = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(about, GtkAboutDialog__sym)) s7_wrong_type_arg_error(sc, "gtk_about_dialog_set_version", 1, about, "GtkAboutDialog*");
  version = s7_car(_p);
  if (!s7_is_string(version)) s7_wrong_type_arg_error(sc, "gtk_about_dialog_set_version", 2, version, "gchar*");
  gtk_about_dialog_set_version((GtkAboutDialog*)s7_c_pointer(about), (gchar*)s7_string(version));
  return(lg_false);
}

static s7_pointer lg_gtk_about_dialog_get_copyright(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_about_dialog_get_copyright "gchar* gtk_about_dialog_get_copyright(GtkAboutDialog* about)"
  s7_pointer about;
  about = s7_car(args);
  if (!s7_is_c_pointer_of_type(about, GtkAboutDialog__sym)) s7_wrong_type_arg_error(sc, "gtk_about_dialog_get_copyright", 1, about, "GtkAboutDialog*");
  return(s7_make_string(sc, gtk_about_dialog_get_copyright((GtkAboutDialog*)s7_c_pointer(about))));
}

static s7_pointer lg_gtk_about_dialog_set_copyright(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_about_dialog_set_copyright "void gtk_about_dialog_set_copyright(GtkAboutDialog* about, \
gchar* copyright)"
  s7_pointer _p;
  s7_pointer about, copyright;
  _p = args;
  about = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(about, GtkAboutDialog__sym)) s7_wrong_type_arg_error(sc, "gtk_about_dialog_set_copyright", 1, about, "GtkAboutDialog*");
  copyright = s7_car(_p);
  if (!s7_is_string(copyright)) s7_wrong_type_arg_error(sc, "gtk_about_dialog_set_copyright", 2, copyright, "gchar*");
  gtk_about_dialog_set_copyright((GtkAboutDialog*)s7_c_pointer(about), (gchar*)s7_string(copyright));
  return(lg_false);
}

static s7_pointer lg_gtk_about_dialog_get_comments(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_about_dialog_get_comments "gchar* gtk_about_dialog_get_comments(GtkAboutDialog* about)"
  s7_pointer about;
  about = s7_car(args);
  if (!s7_is_c_pointer_of_type(about, GtkAboutDialog__sym)) s7_wrong_type_arg_error(sc, "gtk_about_dialog_get_comments", 1, about, "GtkAboutDialog*");
  return(s7_make_string(sc, gtk_about_dialog_get_comments((GtkAboutDialog*)s7_c_pointer(about))));
}

static s7_pointer lg_gtk_about_dialog_set_comments(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_about_dialog_set_comments "void gtk_about_dialog_set_comments(GtkAboutDialog* about, \
gchar* comments)"
  s7_pointer _p;
  s7_pointer about, comments;
  _p = args;
  about = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(about, GtkAboutDialog__sym)) s7_wrong_type_arg_error(sc, "gtk_about_dialog_set_comments", 1, about, "GtkAboutDialog*");
  comments = s7_car(_p);
  if (!s7_is_string(comments)) s7_wrong_type_arg_error(sc, "gtk_about_dialog_set_comments", 2, comments, "gchar*");
  gtk_about_dialog_set_comments((GtkAboutDialog*)s7_c_pointer(about), (gchar*)s7_string(comments));
  return(lg_false);
}

static s7_pointer lg_gtk_about_dialog_get_website(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_about_dialog_get_website "gchar* gtk_about_dialog_get_website(GtkAboutDialog* about)"
  s7_pointer about;
  about = s7_car(args);
  if (!s7_is_c_pointer_of_type(about, GtkAboutDialog__sym)) s7_wrong_type_arg_error(sc, "gtk_about_dialog_get_website", 1, about, "GtkAboutDialog*");
  return(s7_make_string(sc, gtk_about_dialog_get_website((GtkAboutDialog*)s7_c_pointer(about))));
}

static s7_pointer lg_gtk_about_dialog_set_website(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_about_dialog_set_website "void gtk_about_dialog_set_website(GtkAboutDialog* about, gchar* website)"
  s7_pointer _p;
  s7_pointer about, website;
  _p = args;
  about = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(about, GtkAboutDialog__sym)) s7_wrong_type_arg_error(sc, "gtk_about_dialog_set_website", 1, about, "GtkAboutDialog*");
  website = s7_car(_p);
  if (!s7_is_string(website)) s7_wrong_type_arg_error(sc, "gtk_about_dialog_set_website", 2, website, "gchar*");
  gtk_about_dialog_set_website((GtkAboutDialog*)s7_c_pointer(about), (gchar*)s7_string(website));
  return(lg_false);
}

static s7_pointer lg_gtk_about_dialog_get_website_label(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_about_dialog_get_website_label "gchar* gtk_about_dialog_get_website_label(GtkAboutDialog* about)"
  s7_pointer about;
  about = s7_car(args);
  if (!s7_is_c_pointer_of_type(about, GtkAboutDialog__sym)) s7_wrong_type_arg_error(sc, "gtk_about_dialog_get_website_label", 1, about, "GtkAboutDialog*");
  return(s7_make_string(sc, gtk_about_dialog_get_website_label((GtkAboutDialog*)s7_c_pointer(about))));
}

static s7_pointer lg_gtk_about_dialog_set_website_label(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_about_dialog_set_website_label "void gtk_about_dialog_set_website_label(GtkAboutDialog* about, \
gchar* website_label)"
  s7_pointer _p;
  s7_pointer about, website_label;
  _p = args;
  about = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(about, GtkAboutDialog__sym)) s7_wrong_type_arg_error(sc, "gtk_about_dialog_set_website_label", 1, about, "GtkAboutDialog*");
  website_label = s7_car(_p);
  if (!s7_is_string(website_label)) s7_wrong_type_arg_error(sc, "gtk_about_dialog_set_website_label", 2, website_label, "gchar*");
  gtk_about_dialog_set_website_label((GtkAboutDialog*)s7_c_pointer(about), (gchar*)s7_string(website_label));
  return(lg_false);
}

static s7_pointer lg_gtk_about_dialog_get_authors(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_about_dialog_get_authors "gchar** gtk_about_dialog_get_authors(GtkAboutDialog* about)"
  s7_pointer about;
  about = s7_car(args);
  if (!s7_is_c_pointer_of_type(about, GtkAboutDialog__sym)) s7_wrong_type_arg_error(sc, "gtk_about_dialog_get_authors", 1, about, "GtkAboutDialog*");
    return(lg_make_c_pointer_with_type(sc, gchar___sym, (gchar**)gtk_about_dialog_get_authors((GtkAboutDialog*)s7_c_pointer(about))));
}

static s7_pointer lg_gtk_about_dialog_set_authors(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_about_dialog_set_authors "void gtk_about_dialog_set_authors(GtkAboutDialog* about, gchar** authors)"
  s7_pointer _p;
  s7_pointer about, authors;
  _p = args;
  about = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(about, GtkAboutDialog__sym)) s7_wrong_type_arg_error(sc, "gtk_about_dialog_set_authors", 1, about, "GtkAboutDialog*");
  authors = s7_car(_p);
  if (!s7_is_c_pointer_of_type(authors, gchar___sym)) s7_wrong_type_arg_error(sc, "gtk_about_dialog_set_authors", 2, authors, "gchar**");
  gtk_about_dialog_set_authors((GtkAboutDialog*)s7_c_pointer(about), (const gchar**)s7_c_pointer(authors));
  return(lg_false);
}

static s7_pointer lg_gtk_about_dialog_get_documenters(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_about_dialog_get_documenters "gchar** gtk_about_dialog_get_documenters(GtkAboutDialog* about)"
  s7_pointer about;
  about = s7_car(args);
  if (!s7_is_c_pointer_of_type(about, GtkAboutDialog__sym)) s7_wrong_type_arg_error(sc, "gtk_about_dialog_get_documenters", 1, about, "GtkAboutDialog*");
    return(lg_make_c_pointer_with_type(sc, gchar___sym, (gchar**)gtk_about_dialog_get_documenters((GtkAboutDialog*)s7_c_pointer(about))));
}

static s7_pointer lg_gtk_about_dialog_set_documenters(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_about_dialog_set_documenters "void gtk_about_dialog_set_documenters(GtkAboutDialog* about, \
gchar** documenters)"
  s7_pointer _p;
  s7_pointer about, documenters;
  _p = args;
  about = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(about, GtkAboutDialog__sym)) s7_wrong_type_arg_error(sc, "gtk_about_dialog_set_documenters", 1, about, "GtkAboutDialog*");
  documenters = s7_car(_p);
  if (!s7_is_c_pointer_of_type(documenters, gchar___sym)) s7_wrong_type_arg_error(sc, "gtk_about_dialog_set_documenters", 2, documenters, "gchar**");
  gtk_about_dialog_set_documenters((GtkAboutDialog*)s7_c_pointer(about), (const gchar**)s7_c_pointer(documenters));
  return(lg_false);
}

static s7_pointer lg_gtk_about_dialog_get_artists(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_about_dialog_get_artists "gchar** gtk_about_dialog_get_artists(GtkAboutDialog* about)"
  s7_pointer about;
  about = s7_car(args);
  if (!s7_is_c_pointer_of_type(about, GtkAboutDialog__sym)) s7_wrong_type_arg_error(sc, "gtk_about_dialog_get_artists", 1, about, "GtkAboutDialog*");
    return(lg_make_c_pointer_with_type(sc, gchar___sym, (gchar**)gtk_about_dialog_get_artists((GtkAboutDialog*)s7_c_pointer(about))));
}

static s7_pointer lg_gtk_about_dialog_set_artists(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_about_dialog_set_artists "void gtk_about_dialog_set_artists(GtkAboutDialog* about, gchar** artists)"
  s7_pointer _p;
  s7_pointer about, artists;
  _p = args;
  about = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(about, GtkAboutDialog__sym)) s7_wrong_type_arg_error(sc, "gtk_about_dialog_set_artists", 1, about, "GtkAboutDialog*");
  artists = s7_car(_p);
  if (!s7_is_c_pointer_of_type(artists, gchar___sym)) s7_wrong_type_arg_error(sc, "gtk_about_dialog_set_artists", 2, artists, "gchar**");
  gtk_about_dialog_set_artists((GtkAboutDialog*)s7_c_pointer(about), (const gchar**)s7_c_pointer(artists));
  return(lg_false);
}

static s7_pointer lg_gtk_about_dialog_get_translator_credits(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_about_dialog_get_translator_credits "gchar* gtk_about_dialog_get_translator_credits(GtkAboutDialog* about)"
  s7_pointer about;
  about = s7_car(args);
  if (!s7_is_c_pointer_of_type(about, GtkAboutDialog__sym)) s7_wrong_type_arg_error(sc, "gtk_about_dialog_get_translator_credits", 1, about, "GtkAboutDialog*");
  return(s7_make_string(sc, gtk_about_dialog_get_translator_credits((GtkAboutDialog*)s7_c_pointer(about))));
}

static s7_pointer lg_gtk_about_dialog_set_translator_credits(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_about_dialog_set_translator_credits "void gtk_about_dialog_set_translator_credits(GtkAboutDialog* about, \
gchar* translator_credits)"
  s7_pointer _p;
  s7_pointer about, translator_credits;
  _p = args;
  about = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(about, GtkAboutDialog__sym)) s7_wrong_type_arg_error(sc, "gtk_about_dialog_set_translator_credits", 1, about, "GtkAboutDialog*");
  translator_credits = s7_car(_p);
  if (!s7_is_string(translator_credits)) s7_wrong_type_arg_error(sc, "gtk_about_dialog_set_translator_credits", 2, translator_credits, "gchar*");
  gtk_about_dialog_set_translator_credits((GtkAboutDialog*)s7_c_pointer(about), (gchar*)s7_string(translator_credits));
  return(lg_false);
}

static s7_pointer lg_gtk_about_dialog_get_program_name(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_about_dialog_get_program_name "gchar* gtk_about_dialog_get_program_name(GtkAboutDialog* about)"
  s7_pointer about;
  about = s7_car(args);
  if (!s7_is_c_pointer_of_type(about, GtkAboutDialog__sym)) s7_wrong_type_arg_error(sc, "gtk_about_dialog_get_program_name", 1, about, "GtkAboutDialog*");
  return(s7_make_string(sc, gtk_about_dialog_get_program_name((GtkAboutDialog*)s7_c_pointer(about))));
}

static s7_pointer lg_gtk_about_dialog_set_program_name(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_about_dialog_set_program_name "void gtk_about_dialog_set_program_name(GtkAboutDialog* about, \
gchar* name)"
  s7_pointer _p;
  s7_pointer about, name;
  _p = args;
  about = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(about, GtkAboutDialog__sym)) s7_wrong_type_arg_error(sc, "gtk_about_dialog_set_program_name", 1, about, "GtkAboutDialog*");
  name = s7_car(_p);
  if (!s7_is_string(name)) s7_wrong_type_arg_error(sc, "gtk_about_dialog_set_program_name", 2, name, "gchar*");
  gtk_about_dialog_set_program_name((GtkAboutDialog*)s7_c_pointer(about), (gchar*)s7_string(name));
  return(lg_false);
}

static s7_pointer lg_gtk_icon_view_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_new "GtkWidget* gtk_icon_view_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_icon_view_new()));
}

static s7_pointer lg_gtk_icon_view_new_with_model(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_new_with_model "GtkWidget* gtk_icon_view_new_with_model(GtkTreeModel* model)"
  s7_pointer model;
  model = s7_car(args);
  if (!s7_is_c_pointer_of_type(model, GtkTreeModel__sym)) s7_wrong_type_arg_error(sc, "gtk_icon_view_new_with_model", 1, model, "GtkTreeModel*");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_icon_view_new_with_model((GtkTreeModel*)s7_c_pointer(model))));
}

static s7_pointer lg_gtk_icon_view_set_model(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_set_model "void gtk_icon_view_set_model(GtkIconView* icon_view, GtkTreeModel* model)"
  s7_pointer _p;
  s7_pointer icon_view, model;
  _p = args;
  icon_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(icon_view, GtkIconView__sym)) s7_wrong_type_arg_error(sc, "gtk_icon_view_set_model", 1, icon_view, "GtkIconView*");
  model = s7_car(_p);
  if ((!s7_is_c_pointer_of_type(model, GtkTreeModel__sym)) && (model != lg_false)) s7_wrong_type_arg_error(sc, "gtk_icon_view_set_model", 2, model, "GtkTreeModel*");
  gtk_icon_view_set_model((GtkIconView*)s7_c_pointer(icon_view), (GtkTreeModel*)s7_c_pointer(model));
  return(lg_false);
}

static s7_pointer lg_gtk_icon_view_get_model(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_get_model "GtkTreeModel* gtk_icon_view_get_model(GtkIconView* icon_view)"
  s7_pointer icon_view;
  icon_view = s7_car(args);
  if (!s7_is_c_pointer_of_type(icon_view, GtkIconView__sym)) s7_wrong_type_arg_error(sc, "gtk_icon_view_get_model", 1, icon_view, "GtkIconView*");
  return(lg_make_c_pointer_with_type(sc, GtkTreeModel__sym, gtk_icon_view_get_model((GtkIconView*)s7_c_pointer(icon_view))));
}

static s7_pointer lg_gtk_icon_view_set_text_column(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_set_text_column "void gtk_icon_view_set_text_column(GtkIconView* icon_view, \
gint column)"
  s7_pointer _p;
  s7_pointer icon_view, column;
  _p = args;
  icon_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(icon_view, GtkIconView__sym)) s7_wrong_type_arg_error(sc, "gtk_icon_view_set_text_column", 1, icon_view, "GtkIconView*");
  column = s7_car(_p);
  if (!s7_is_integer(column)) s7_wrong_type_arg_error(sc, "gtk_icon_view_set_text_column", 2, column, "gint");
  gtk_icon_view_set_text_column((GtkIconView*)s7_c_pointer(icon_view), (gint)s7_integer(column));
  return(lg_false);
}

static s7_pointer lg_gtk_icon_view_get_text_column(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_get_text_column "gint gtk_icon_view_get_text_column(GtkIconView* icon_view)"
  s7_pointer icon_view;
  icon_view = s7_car(args);
  if (!s7_is_c_pointer_of_type(icon_view, GtkIconView__sym)) s7_wrong_type_arg_error(sc, "gtk_icon_view_get_text_column", 1, icon_view, "GtkIconView*");
  return(s7_make_integer(sc, gtk_icon_view_get_text_column((GtkIconView*)s7_c_pointer(icon_view))));
}

static s7_pointer lg_gtk_icon_view_set_markup_column(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_set_markup_column "void gtk_icon_view_set_markup_column(GtkIconView* icon_view, \
gint column)"
  s7_pointer _p;
  s7_pointer icon_view, column;
  _p = args;
  icon_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(icon_view, GtkIconView__sym)) s7_wrong_type_arg_error(sc, "gtk_icon_view_set_markup_column", 1, icon_view, "GtkIconView*");
  column = s7_car(_p);
  if (!s7_is_integer(column)) s7_wrong_type_arg_error(sc, "gtk_icon_view_set_markup_column", 2, column, "gint");
  gtk_icon_view_set_markup_column((GtkIconView*)s7_c_pointer(icon_view), (gint)s7_integer(column));
  return(lg_false);
}

static s7_pointer lg_gtk_icon_view_get_markup_column(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_get_markup_column "gint gtk_icon_view_get_markup_column(GtkIconView* icon_view)"
  s7_pointer icon_view;
  icon_view = s7_car(args);
  if (!s7_is_c_pointer_of_type(icon_view, GtkIconView__sym)) s7_wrong_type_arg_error(sc, "gtk_icon_view_get_markup_column", 1, icon_view, "GtkIconView*");
  return(s7_make_integer(sc, gtk_icon_view_get_markup_column((GtkIconView*)s7_c_pointer(icon_view))));
}

static s7_pointer lg_gtk_icon_view_set_pixbuf_column(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_set_pixbuf_column "void gtk_icon_view_set_pixbuf_column(GtkIconView* icon_view, \
gint column)"
  s7_pointer _p;
  s7_pointer icon_view, column;
  _p = args;
  icon_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(icon_view, GtkIconView__sym)) s7_wrong_type_arg_error(sc, "gtk_icon_view_set_pixbuf_column", 1, icon_view, "GtkIconView*");
  column = s7_car(_p);
  if (!s7_is_integer(column)) s7_wrong_type_arg_error(sc, "gtk_icon_view_set_pixbuf_column", 2, column, "gint");
  gtk_icon_view_set_pixbuf_column((GtkIconView*)s7_c_pointer(icon_view), (gint)s7_integer(column));
  return(lg_false);
}

static s7_pointer lg_gtk_icon_view_get_pixbuf_column(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_get_pixbuf_column "gint gtk_icon_view_get_pixbuf_column(GtkIconView* icon_view)"
  s7_pointer icon_view;
  icon_view = s7_car(args);
  if (!s7_is_c_pointer_of_type(icon_view, GtkIconView__sym)) s7_wrong_type_arg_error(sc, "gtk_icon_view_get_pixbuf_column", 1, icon_view, "GtkIconView*");
  return(s7_make_integer(sc, gtk_icon_view_get_pixbuf_column((GtkIconView*)s7_c_pointer(icon_view))));
}

static s7_pointer lg_gtk_icon_view_get_path_at_pos(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_get_path_at_pos "GtkTreePath* gtk_icon_view_get_path_at_pos(GtkIconView* icon_view, \
gint x, gint y)"
  s7_pointer _p;
  s7_pointer icon_view, x, y;
  _p = args;
  icon_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(icon_view, GtkIconView__sym)) s7_wrong_type_arg_error(sc, "gtk_icon_view_get_path_at_pos", 1, icon_view, "GtkIconView*");
  x = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(x)) s7_wrong_type_arg_error(sc, "gtk_icon_view_get_path_at_pos", 2, x, "gint");
  y = s7_car(_p);
  if (!s7_is_integer(y)) s7_wrong_type_arg_error(sc, "gtk_icon_view_get_path_at_pos", 3, y, "gint");
  return(lg_make_c_pointer_with_type(sc, GtkTreePath__sym, gtk_icon_view_get_path_at_pos((GtkIconView*)s7_c_pointer(icon_view), (gint)s7_integer(x), (gint)s7_integer(y))));
}

static s7_pointer lg_gtk_icon_view_selected_foreach(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_selected_foreach "void gtk_icon_view_selected_foreach(GtkIconView* icon_view, \
GtkIconViewForeachFunc func, lambda_data func_info)"
  s7_pointer _p;
  s7_pointer icon_view, func, func_info;
  _p = args;
  icon_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(icon_view, GtkIconView__sym)) s7_wrong_type_arg_error(sc, "gtk_icon_view_selected_foreach", 1, icon_view, "GtkIconView*");
  func = s7_car(_p); _p = s7_cdr(_p);
  func_info = s7_car(_p);
  {
    s7_pointer lg_ptr = s7_list(sc, 5, func, func_info, lg_false, lg_false, lg_false);
    s7_gc_protect(sc, lg_ptr);
    gtk_icon_view_selected_foreach((GtkIconView*)s7_c_pointer(icon_view), lg_icon_view_foreach, (gpointer)lg_ptr);
    return(lg_false);
   }
}

static s7_pointer lg_gtk_icon_view_set_selection_mode(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_set_selection_mode "void gtk_icon_view_set_selection_mode(GtkIconView* icon_view, \
GtkSelectionMode mode)"
  s7_pointer _p;
  s7_pointer icon_view, mode;
  _p = args;
  icon_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(icon_view, GtkIconView__sym)) s7_wrong_type_arg_error(sc, "gtk_icon_view_set_selection_mode", 1, icon_view, "GtkIconView*");
  mode = s7_car(_p);
  if (!s7_is_integer(mode)) s7_wrong_type_arg_error(sc, "gtk_icon_view_set_selection_mode", 2, mode, "GtkSelectionMode");
  gtk_icon_view_set_selection_mode((GtkIconView*)s7_c_pointer(icon_view), (GtkSelectionMode)s7_integer(mode));
  return(lg_false);
}

static s7_pointer lg_gtk_icon_view_get_selection_mode(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_get_selection_mode "GtkSelectionMode gtk_icon_view_get_selection_mode(GtkIconView* icon_view)"
  s7_pointer icon_view;
  icon_view = s7_car(args);
  if (!s7_is_c_pointer_of_type(icon_view, GtkIconView__sym)) s7_wrong_type_arg_error(sc, "gtk_icon_view_get_selection_mode", 1, icon_view, "GtkIconView*");
  return(s7_make_integer(sc, gtk_icon_view_get_selection_mode((GtkIconView*)s7_c_pointer(icon_view))));
}

static s7_pointer lg_gtk_icon_view_select_path(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_select_path "void gtk_icon_view_select_path(GtkIconView* icon_view, GtkTreePath* path)"
  s7_pointer _p;
  s7_pointer icon_view, path;
  _p = args;
  icon_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(icon_view, GtkIconView__sym)) s7_wrong_type_arg_error(sc, "gtk_icon_view_select_path", 1, icon_view, "GtkIconView*");
  path = s7_car(_p);
  if (!s7_is_c_pointer_of_type(path, GtkTreePath__sym)) s7_wrong_type_arg_error(sc, "gtk_icon_view_select_path", 2, path, "GtkTreePath*");
  gtk_icon_view_select_path((GtkIconView*)s7_c_pointer(icon_view), (GtkTreePath*)s7_c_pointer(path));
  return(lg_false);
}

static s7_pointer lg_gtk_icon_view_unselect_path(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_unselect_path "void gtk_icon_view_unselect_path(GtkIconView* icon_view, GtkTreePath* path)"
  s7_pointer _p;
  s7_pointer icon_view, path;
  _p = args;
  icon_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(icon_view, GtkIconView__sym)) s7_wrong_type_arg_error(sc, "gtk_icon_view_unselect_path", 1, icon_view, "GtkIconView*");
  path = s7_car(_p);
  if (!s7_is_c_pointer_of_type(path, GtkTreePath__sym)) s7_wrong_type_arg_error(sc, "gtk_icon_view_unselect_path", 2, path, "GtkTreePath*");
  gtk_icon_view_unselect_path((GtkIconView*)s7_c_pointer(icon_view), (GtkTreePath*)s7_c_pointer(path));
  return(lg_false);
}

static s7_pointer lg_gtk_icon_view_path_is_selected(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_path_is_selected "gboolean gtk_icon_view_path_is_selected(GtkIconView* icon_view, \
GtkTreePath* path)"
  s7_pointer _p;
  s7_pointer icon_view, path;
  _p = args;
  icon_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(icon_view, GtkIconView__sym)) s7_wrong_type_arg_error(sc, "gtk_icon_view_path_is_selected", 1, icon_view, "GtkIconView*");
  path = s7_car(_p);
  if (!s7_is_c_pointer_of_type(path, GtkTreePath__sym)) s7_wrong_type_arg_error(sc, "gtk_icon_view_path_is_selected", 2, path, "GtkTreePath*");
  return(s7_make_boolean(sc, gtk_icon_view_path_is_selected((GtkIconView*)s7_c_pointer(icon_view), (GtkTreePath*)s7_c_pointer(path))));
}

static s7_pointer lg_gtk_icon_view_get_selected_items(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_get_selected_items "GList* gtk_icon_view_get_selected_items(GtkIconView* icon_view)"
  s7_pointer icon_view;
  icon_view = s7_car(args);
  if (!s7_is_c_pointer_of_type(icon_view, GtkIconView__sym)) s7_wrong_type_arg_error(sc, "gtk_icon_view_get_selected_items", 1, icon_view, "GtkIconView*");
  return(lg_make_c_pointer_with_type(sc, GList__sym, gtk_icon_view_get_selected_items((GtkIconView*)s7_c_pointer(icon_view))));
}

static s7_pointer lg_gtk_icon_view_select_all(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_select_all "void gtk_icon_view_select_all(GtkIconView* icon_view)"
  s7_pointer icon_view;
  icon_view = s7_car(args);
  if (!s7_is_c_pointer_of_type(icon_view, GtkIconView__sym)) s7_wrong_type_arg_error(sc, "gtk_icon_view_select_all", 1, icon_view, "GtkIconView*");
  gtk_icon_view_select_all((GtkIconView*)s7_c_pointer(icon_view));
  return(lg_false);
}

static s7_pointer lg_gtk_icon_view_unselect_all(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_unselect_all "void gtk_icon_view_unselect_all(GtkIconView* icon_view)"
  s7_pointer icon_view;
  icon_view = s7_car(args);
  if (!s7_is_c_pointer_of_type(icon_view, GtkIconView__sym)) s7_wrong_type_arg_error(sc, "gtk_icon_view_unselect_all", 1, icon_view, "GtkIconView*");
  gtk_icon_view_unselect_all((GtkIconView*)s7_c_pointer(icon_view));
  return(lg_false);
}

static s7_pointer lg_gtk_icon_view_item_activated(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_item_activated "void gtk_icon_view_item_activated(GtkIconView* icon_view, GtkTreePath* path)"
  s7_pointer _p;
  s7_pointer icon_view, path;
  _p = args;
  icon_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(icon_view, GtkIconView__sym)) s7_wrong_type_arg_error(sc, "gtk_icon_view_item_activated", 1, icon_view, "GtkIconView*");
  path = s7_car(_p);
  if (!s7_is_c_pointer_of_type(path, GtkTreePath__sym)) s7_wrong_type_arg_error(sc, "gtk_icon_view_item_activated", 2, path, "GtkTreePath*");
  gtk_icon_view_item_activated((GtkIconView*)s7_c_pointer(icon_view), (GtkTreePath*)s7_c_pointer(path));
  return(lg_false);
}

static s7_pointer lg_gtk_cell_renderer_combo_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_renderer_combo_new "GtkCellRenderer* gtk_cell_renderer_combo_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkCellRenderer__sym, gtk_cell_renderer_combo_new()));
}

static s7_pointer lg_gtk_cell_renderer_progress_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_renderer_progress_new "GtkCellRenderer* gtk_cell_renderer_progress_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkCellRenderer__sym, gtk_cell_renderer_progress_new()));
}

static s7_pointer lg_gtk_combo_box_set_row_separator_func(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_combo_box_set_row_separator_func "void gtk_combo_box_set_row_separator_func(GtkComboBox* combo_box, \
GtkTreeViewRowSeparatorFunc func, lambda_data func_info, GtkDestroyNotify destroy)"
  s7_pointer _p;
  s7_pointer combo_box, func, func_info, destroy;
  _p = args;
  combo_box = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(combo_box, GtkComboBox__sym)) s7_wrong_type_arg_error(sc, "gtk_combo_box_set_row_separator_func", 1, combo_box, "GtkComboBox*");
  func = s7_car(_p); _p = s7_cdr(_p);
  func_info = s7_car(_p); _p = s7_cdr(_p);
  destroy = s7_car(_p);
  {
    s7_pointer lg_ptr = s7_list(sc, 5, func, func_info, lg_false, lg_false, lg_false);
    s7_gc_protect(sc, lg_ptr);
    s7_list_set(sc, lg_ptr, 3, destroy);
    gtk_combo_box_set_row_separator_func((GtkComboBox*)s7_c_pointer(combo_box), lg_row_separator, (gpointer)lg_ptr, lg_destroy_func);
    return(lg_false);
   }
}

static s7_pointer lg_gtk_label_set_ellipsize(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_label_set_ellipsize "void gtk_label_set_ellipsize(GtkLabel* label, PangoEllipsizeMode mode)"
  s7_pointer _p;
  s7_pointer label, mode;
  _p = args;
  label = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(label, GtkLabel__sym)) s7_wrong_type_arg_error(sc, "gtk_label_set_ellipsize", 1, label, "GtkLabel*");
  mode = s7_car(_p);
  if (!s7_is_integer(mode)) s7_wrong_type_arg_error(sc, "gtk_label_set_ellipsize", 2, mode, "PangoEllipsizeMode");
  gtk_label_set_ellipsize((GtkLabel*)s7_c_pointer(label), (PangoEllipsizeMode)s7_integer(mode));
  return(lg_false);
}

static s7_pointer lg_gtk_label_get_ellipsize(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_label_get_ellipsize "PangoEllipsizeMode gtk_label_get_ellipsize(GtkLabel* label)"
  s7_pointer label;
  label = s7_car(args);
  if (!s7_is_c_pointer_of_type(label, GtkLabel__sym)) s7_wrong_type_arg_error(sc, "gtk_label_get_ellipsize", 1, label, "GtkLabel*");
  return(s7_make_integer(sc, gtk_label_get_ellipsize((GtkLabel*)s7_c_pointer(label))));
}

static s7_pointer lg_pango_attr_fallback_new(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_fallback_new "PangoAttribute* pango_attr_fallback_new(gboolean enable_fallback)"
  s7_pointer enable_fallback;
  enable_fallback = s7_car(args);
  if (!s7_is_boolean(enable_fallback)) s7_wrong_type_arg_error(sc, "pango_attr_fallback_new", 1, enable_fallback, "gboolean");
  return(lg_make_c_pointer_with_type(sc, PangoAttribute__sym, pango_attr_fallback_new((gboolean)lg_boolean(enable_fallback))));
}

static s7_pointer lg_pango_attr_letter_spacing_new(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_letter_spacing_new "PangoAttribute* pango_attr_letter_spacing_new(int letter_spacing)"
  s7_pointer letter_spacing;
  letter_spacing = s7_car(args);
  if (!s7_is_integer(letter_spacing)) s7_wrong_type_arg_error(sc, "pango_attr_letter_spacing_new", 1, letter_spacing, "int");
  return(lg_make_c_pointer_with_type(sc, PangoAttribute__sym, pango_attr_letter_spacing_new((int)s7_integer(letter_spacing))));
}

static s7_pointer lg_pango_attr_list_filter(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_list_filter "PangoAttrList* pango_attr_list_filter(PangoAttrList* list, PangoAttrFilterFunc func, \
gpointer data)"
  s7_pointer _p;
  s7_pointer list, func, data;
  _p = args;
  list = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(list, PangoAttrList__sym)) s7_wrong_type_arg_error(sc, "pango_attr_list_filter", 1, list, "PangoAttrList*");
  func = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(func, PangoAttrFilterFunc_sym)) s7_wrong_type_arg_error(sc, "pango_attr_list_filter", 2, func, "PangoAttrFilterFunc");
  data = s7_car(_p);
  if (!s7_is_c_pointer_of_type(data, gpointer_sym)) s7_wrong_type_arg_error(sc, "pango_attr_list_filter", 3, data, "gpointer");
  return(lg_make_c_pointer_with_type(sc, PangoAttrList__sym, pango_attr_list_filter((PangoAttrList*)s7_c_pointer(list), (PangoAttrFilterFunc)s7_c_pointer(func), (gpointer)s7_c_pointer(data))));
}

static s7_pointer lg_pango_attr_iterator_get_attrs(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_iterator_get_attrs "GSList* pango_attr_iterator_get_attrs(PangoAttrIterator* iterator)"
  s7_pointer iterator;
  iterator = s7_car(args);
  if (!s7_is_c_pointer_of_type(iterator, PangoAttrIterator__sym)) s7_wrong_type_arg_error(sc, "pango_attr_iterator_get_attrs", 1, iterator, "PangoAttrIterator*");
  return(lg_make_c_pointer_with_type(sc, GSList__sym, pango_attr_iterator_get_attrs((PangoAttrIterator*)s7_c_pointer(iterator))));
}

static s7_pointer lg_pango_font_metrics_get_underline_position(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_metrics_get_underline_position "int pango_font_metrics_get_underline_position(PangoFontMetrics* metrics)"
  s7_pointer metrics;
  metrics = s7_car(args);
  if (!s7_is_c_pointer_of_type(metrics, PangoFontMetrics__sym)) s7_wrong_type_arg_error(sc, "pango_font_metrics_get_underline_position", 1, metrics, "PangoFontMetrics*");
  return(s7_make_integer(sc, pango_font_metrics_get_underline_position((PangoFontMetrics*)s7_c_pointer(metrics))));
}

static s7_pointer lg_pango_font_metrics_get_underline_thickness(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_metrics_get_underline_thickness "int pango_font_metrics_get_underline_thickness(PangoFontMetrics* metrics)"
  s7_pointer metrics;
  metrics = s7_car(args);
  if (!s7_is_c_pointer_of_type(metrics, PangoFontMetrics__sym)) s7_wrong_type_arg_error(sc, "pango_font_metrics_get_underline_thickness", 1, metrics, "PangoFontMetrics*");
  return(s7_make_integer(sc, pango_font_metrics_get_underline_thickness((PangoFontMetrics*)s7_c_pointer(metrics))));
}

static s7_pointer lg_pango_font_metrics_get_strikethrough_position(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_metrics_get_strikethrough_position "int pango_font_metrics_get_strikethrough_position(PangoFontMetrics* metrics)"
  s7_pointer metrics;
  metrics = s7_car(args);
  if (!s7_is_c_pointer_of_type(metrics, PangoFontMetrics__sym)) s7_wrong_type_arg_error(sc, "pango_font_metrics_get_strikethrough_position", 1, metrics, "PangoFontMetrics*");
  return(s7_make_integer(sc, pango_font_metrics_get_strikethrough_position((PangoFontMetrics*)s7_c_pointer(metrics))));
}

static s7_pointer lg_pango_font_metrics_get_strikethrough_thickness(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_metrics_get_strikethrough_thickness "int pango_font_metrics_get_strikethrough_thickness(PangoFontMetrics* metrics)"
  s7_pointer metrics;
  metrics = s7_car(args);
  if (!s7_is_c_pointer_of_type(metrics, PangoFontMetrics__sym)) s7_wrong_type_arg_error(sc, "pango_font_metrics_get_strikethrough_thickness", 1, metrics, "PangoFontMetrics*");
  return(s7_make_integer(sc, pango_font_metrics_get_strikethrough_thickness((PangoFontMetrics*)s7_c_pointer(metrics))));
}

static s7_pointer lg_pango_font_family_is_monospace(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_family_is_monospace "gboolean pango_font_family_is_monospace(PangoFontFamily* family)"
  s7_pointer family;
  family = s7_car(args);
  if (!s7_is_c_pointer_of_type(family, PangoFontFamily__sym)) s7_wrong_type_arg_error(sc, "pango_font_family_is_monospace", 1, family, "PangoFontFamily*");
  return(s7_make_boolean(sc, pango_font_family_is_monospace((PangoFontFamily*)s7_c_pointer(family))));
}

static s7_pointer lg_pango_font_face_list_sizes(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_face_list_sizes "void pango_font_face_list_sizes(PangoFontFace* face, int** [sizes], \
int* [n_sizes])"
  s7_pointer _p;
  s7_pointer face;
  int* ref_sizes = NULL;
  int ref_n_sizes;
  _p = args;
  face = s7_car(_p);
  if (!s7_is_c_pointer_of_type(face, PangoFontFace__sym)) s7_wrong_type_arg_error(sc, "pango_font_face_list_sizes", 1, face, "PangoFontFace*");
  pango_font_face_list_sizes((PangoFontFace*)s7_c_pointer(face), &ref_sizes, &ref_n_sizes);
    return(s7_list(sc, 2, s7_make_c_pointer(sc, ref_sizes), s7_make_integer(sc, ref_n_sizes)));
}

static s7_pointer lg_pango_layout_set_auto_dir(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_set_auto_dir "void pango_layout_set_auto_dir(PangoLayout* layout, gboolean auto_dir)"
  s7_pointer _p;
  s7_pointer layout, auto_dir;
  _p = args;
  layout = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(layout, PangoLayout__sym)) s7_wrong_type_arg_error(sc, "pango_layout_set_auto_dir", 1, layout, "PangoLayout*");
  auto_dir = s7_car(_p);
  if (!s7_is_boolean(auto_dir)) s7_wrong_type_arg_error(sc, "pango_layout_set_auto_dir", 2, auto_dir, "gboolean");
  pango_layout_set_auto_dir((PangoLayout*)s7_c_pointer(layout), (gboolean)lg_boolean(auto_dir));
  return(lg_false);
}

static s7_pointer lg_pango_layout_get_auto_dir(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_get_auto_dir "gboolean pango_layout_get_auto_dir(PangoLayout* layout)"
  s7_pointer layout;
  layout = s7_car(args);
  if (!s7_is_c_pointer_of_type(layout, PangoLayout__sym)) s7_wrong_type_arg_error(sc, "pango_layout_get_auto_dir", 1, layout, "PangoLayout*");
  return(s7_make_boolean(sc, pango_layout_get_auto_dir((PangoLayout*)s7_c_pointer(layout))));
}

static s7_pointer lg_pango_script_iter_new(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_script_iter_new "PangoScriptIter* pango_script_iter_new(char* text, int length)"
  s7_pointer _p;
  s7_pointer text, length;
  _p = args;
  text = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(text)) s7_wrong_type_arg_error(sc, "pango_script_iter_new", 1, text, "char*");
  length = s7_car(_p);
  if (!s7_is_integer(length)) s7_wrong_type_arg_error(sc, "pango_script_iter_new", 2, length, "int");
  return(lg_make_c_pointer_with_type(sc, PangoScriptIter__sym, pango_script_iter_new((char*)s7_string(text), (int)s7_integer(length))));
}

static s7_pointer lg_pango_script_iter_get_range(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_script_iter_get_range "void pango_script_iter_get_range(PangoScriptIter* iter, char** [start], \
char** [end], PangoScript* [script])"
  s7_pointer _p;
  s7_pointer iter;
  char* ref_start = NULL;
  char* ref_end = NULL;
  PangoScript ref_script;
  _p = args;
  iter = s7_car(_p);
  if (!s7_is_c_pointer_of_type(iter, PangoScriptIter__sym)) s7_wrong_type_arg_error(sc, "pango_script_iter_get_range", 1, iter, "PangoScriptIter*");
  pango_script_iter_get_range((PangoScriptIter*)s7_c_pointer(iter), (const char**)&ref_start, (const char**)&ref_end, &ref_script);
    return(s7_list(sc, 3, s7_make_string(sc, ref_start), s7_make_string(sc, ref_end), s7_make_integer(sc, ref_script)));
}

static s7_pointer lg_pango_script_iter_next(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_script_iter_next "gboolean pango_script_iter_next(PangoScriptIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  if (!s7_is_c_pointer_of_type(iter, PangoScriptIter__sym)) s7_wrong_type_arg_error(sc, "pango_script_iter_next", 1, iter, "PangoScriptIter*");
  return(s7_make_boolean(sc, pango_script_iter_next((PangoScriptIter*)s7_c_pointer(iter))));
}

static s7_pointer lg_pango_script_iter_free(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_script_iter_free "void pango_script_iter_free(PangoScriptIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  if (!s7_is_c_pointer_of_type(iter, PangoScriptIter__sym)) s7_wrong_type_arg_error(sc, "pango_script_iter_free", 1, iter, "PangoScriptIter*");
  pango_script_iter_free((PangoScriptIter*)s7_c_pointer(iter));
  return(lg_false);
}

static s7_pointer lg_gtk_file_chooser_button_new_with_dialog(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_file_chooser_button_new_with_dialog "GtkWidget* gtk_file_chooser_button_new_with_dialog(GtkWidget* dialog)"
  s7_pointer dialog;
  dialog = s7_car(args);
  if (!s7_is_c_pointer_of_type(dialog, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_file_chooser_button_new_with_dialog", 1, dialog, "GtkWidget*");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_file_chooser_button_new_with_dialog((GtkWidget*)s7_c_pointer(dialog))));
}

static s7_pointer lg_gtk_file_chooser_button_get_title(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_file_chooser_button_get_title "gchar* gtk_file_chooser_button_get_title(GtkFileChooserButton* button)"
  s7_pointer button;
  button = s7_car(args);
  if (!s7_is_c_pointer_of_type(button, GtkFileChooserButton__sym)) s7_wrong_type_arg_error(sc, "gtk_file_chooser_button_get_title", 1, button, "GtkFileChooserButton*");
  return(s7_make_string(sc, gtk_file_chooser_button_get_title((GtkFileChooserButton*)s7_c_pointer(button))));
}

static s7_pointer lg_gtk_file_chooser_button_set_title(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_file_chooser_button_set_title "void gtk_file_chooser_button_set_title(GtkFileChooserButton* button, \
gchar* title)"
  s7_pointer _p;
  s7_pointer button, title;
  _p = args;
  button = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(button, GtkFileChooserButton__sym)) s7_wrong_type_arg_error(sc, "gtk_file_chooser_button_set_title", 1, button, "GtkFileChooserButton*");
  title = s7_car(_p);
  if (!s7_is_string(title)) s7_wrong_type_arg_error(sc, "gtk_file_chooser_button_set_title", 2, title, "gchar*");
  gtk_file_chooser_button_set_title((GtkFileChooserButton*)s7_c_pointer(button), (gchar*)s7_string(title));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_set_hover_expand(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_set_hover_expand "void gtk_tree_view_set_hover_expand(GtkTreeView* tree_view, \
gboolean expand)"
  s7_pointer _p;
  s7_pointer tree_view, expand;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_view, GtkTreeView__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_set_hover_expand", 1, tree_view, "GtkTreeView*");
  expand = s7_car(_p);
  if (!s7_is_boolean(expand)) s7_wrong_type_arg_error(sc, "gtk_tree_view_set_hover_expand", 2, expand, "gboolean");
  gtk_tree_view_set_hover_expand((GtkTreeView*)s7_c_pointer(tree_view), (gboolean)lg_boolean(expand));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_get_hover_expand(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_get_hover_expand "gboolean gtk_tree_view_get_hover_expand(GtkTreeView* tree_view)"
  s7_pointer tree_view;
  tree_view = s7_car(args);
  if (!s7_is_c_pointer_of_type(tree_view, GtkTreeView__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_get_hover_expand", 1, tree_view, "GtkTreeView*");
  return(s7_make_boolean(sc, gtk_tree_view_get_hover_expand((GtkTreeView*)s7_c_pointer(tree_view))));
}

static s7_pointer lg_gtk_about_dialog_get_logo_icon_name(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_about_dialog_get_logo_icon_name "gchar* gtk_about_dialog_get_logo_icon_name(GtkAboutDialog* about)"
  s7_pointer about;
  about = s7_car(args);
  if (!s7_is_c_pointer_of_type(about, GtkAboutDialog__sym)) s7_wrong_type_arg_error(sc, "gtk_about_dialog_get_logo_icon_name", 1, about, "GtkAboutDialog*");
  return(s7_make_string(sc, gtk_about_dialog_get_logo_icon_name((GtkAboutDialog*)s7_c_pointer(about))));
}

static s7_pointer lg_gtk_about_dialog_set_logo_icon_name(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_about_dialog_set_logo_icon_name "void gtk_about_dialog_set_logo_icon_name(GtkAboutDialog* about, \
gchar* icon_name)"
  s7_pointer _p;
  s7_pointer about, icon_name;
  _p = args;
  about = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(about, GtkAboutDialog__sym)) s7_wrong_type_arg_error(sc, "gtk_about_dialog_set_logo_icon_name", 1, about, "GtkAboutDialog*");
  icon_name = s7_car(_p);
  if (!s7_is_string(icon_name)) s7_wrong_type_arg_error(sc, "gtk_about_dialog_set_logo_icon_name", 2, icon_name, "gchar*");
  gtk_about_dialog_set_logo_icon_name((GtkAboutDialog*)s7_c_pointer(about), (gchar*)s7_string(icon_name));
  return(lg_false);
}

static s7_pointer lg_gtk_accelerator_get_label(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_accelerator_get_label "gchar* gtk_accelerator_get_label(guint accelerator_key, GdkModifierType accelerator_mods)"
  s7_pointer _p;
  s7_pointer accelerator_key, accelerator_mods;
  _p = args;
  accelerator_key = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(accelerator_key)) s7_wrong_type_arg_error(sc, "gtk_accelerator_get_label", 1, accelerator_key, "guint");
  accelerator_mods = s7_car(_p);
  if (!s7_is_integer(accelerator_mods)) s7_wrong_type_arg_error(sc, "gtk_accelerator_get_label", 2, accelerator_mods, "GdkModifierType");
  {
    gchar* res_ult;
    s7_pointer rtn;
    res_ult = gtk_accelerator_get_label((guint)s7_integer(accelerator_key), (GdkModifierType)s7_integer(accelerator_mods));
    rtn = s7_make_string(sc, res_ult);
    g_free(res_ult);
    return(rtn);
  }
}

static s7_pointer lg_gtk_file_chooser_button_get_width_chars(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_file_chooser_button_get_width_chars "gint gtk_file_chooser_button_get_width_chars(GtkFileChooserButton* button)"
  s7_pointer button;
  button = s7_car(args);
  if (!s7_is_c_pointer_of_type(button, GtkFileChooserButton__sym)) s7_wrong_type_arg_error(sc, "gtk_file_chooser_button_get_width_chars", 1, button, "GtkFileChooserButton*");
  return(s7_make_integer(sc, gtk_file_chooser_button_get_width_chars((GtkFileChooserButton*)s7_c_pointer(button))));
}

static s7_pointer lg_gtk_file_chooser_button_set_width_chars(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_file_chooser_button_set_width_chars "void gtk_file_chooser_button_set_width_chars(GtkFileChooserButton* button, \
gint n_chars)"
  s7_pointer _p;
  s7_pointer button, n_chars;
  _p = args;
  button = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(button, GtkFileChooserButton__sym)) s7_wrong_type_arg_error(sc, "gtk_file_chooser_button_set_width_chars", 1, button, "GtkFileChooserButton*");
  n_chars = s7_car(_p);
  if (!s7_is_integer(n_chars)) s7_wrong_type_arg_error(sc, "gtk_file_chooser_button_set_width_chars", 2, n_chars, "gint");
  gtk_file_chooser_button_set_width_chars((GtkFileChooserButton*)s7_c_pointer(button), (gint)s7_integer(n_chars));
  return(lg_false);
}

static s7_pointer lg_gtk_image_set_pixel_size(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_image_set_pixel_size "void gtk_image_set_pixel_size(GtkImage* image, gint pixel_size)"
  s7_pointer _p;
  s7_pointer image, pixel_size;
  _p = args;
  image = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(image, GtkImage__sym)) s7_wrong_type_arg_error(sc, "gtk_image_set_pixel_size", 1, image, "GtkImage*");
  pixel_size = s7_car(_p);
  if (!s7_is_integer(pixel_size)) s7_wrong_type_arg_error(sc, "gtk_image_set_pixel_size", 2, pixel_size, "gint");
  gtk_image_set_pixel_size((GtkImage*)s7_c_pointer(image), (gint)s7_integer(pixel_size));
  return(lg_false);
}

static s7_pointer lg_gtk_image_get_pixel_size(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_image_get_pixel_size "gint gtk_image_get_pixel_size(GtkImage* image)"
  s7_pointer image;
  image = s7_car(args);
  if (!s7_is_c_pointer_of_type(image, GtkImage__sym)) s7_wrong_type_arg_error(sc, "gtk_image_get_pixel_size", 1, image, "GtkImage*");
  return(s7_make_integer(sc, gtk_image_get_pixel_size((GtkImage*)s7_c_pointer(image))));
}

static s7_pointer lg_gtk_label_set_width_chars(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_label_set_width_chars "void gtk_label_set_width_chars(GtkLabel* label, gint n_chars)"
  s7_pointer _p;
  s7_pointer label, n_chars;
  _p = args;
  label = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(label, GtkLabel__sym)) s7_wrong_type_arg_error(sc, "gtk_label_set_width_chars", 1, label, "GtkLabel*");
  n_chars = s7_car(_p);
  if (!s7_is_integer(n_chars)) s7_wrong_type_arg_error(sc, "gtk_label_set_width_chars", 2, n_chars, "gint");
  gtk_label_set_width_chars((GtkLabel*)s7_c_pointer(label), (gint)s7_integer(n_chars));
  return(lg_false);
}

static s7_pointer lg_gtk_label_get_width_chars(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_label_get_width_chars "gint gtk_label_get_width_chars(GtkLabel* label)"
  s7_pointer label;
  label = s7_car(args);
  if (!s7_is_c_pointer_of_type(label, GtkLabel__sym)) s7_wrong_type_arg_error(sc, "gtk_label_get_width_chars", 1, label, "GtkLabel*");
  return(s7_make_integer(sc, gtk_label_get_width_chars((GtkLabel*)s7_c_pointer(label))));
}

static s7_pointer lg_gtk_text_buffer_backspace(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_backspace "gboolean gtk_text_buffer_backspace(GtkTextBuffer* buffer, GtkTextIter* iter, \
gboolean interactive, gboolean default_editable)"
  s7_pointer _p;
  s7_pointer buffer, iter, interactive, default_editable;
  _p = args;
  buffer = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(buffer, GtkTextBuffer__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_backspace", 1, buffer, "GtkTextBuffer*");
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_backspace", 2, iter, "GtkTextIter*");
  interactive = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_boolean(interactive)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_backspace", 3, interactive, "gboolean");
  default_editable = s7_car(_p);
  if (!s7_is_boolean(default_editable)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_backspace", 4, default_editable, "gboolean");
  return(s7_make_boolean(sc, gtk_text_buffer_backspace((GtkTextBuffer*)s7_c_pointer(buffer), (GtkTextIter*)s7_c_pointer(iter), (gboolean)lg_boolean(interactive), (gboolean)lg_boolean(default_editable))));
}

static s7_pointer lg_gtk_file_filter_add_pixbuf_formats(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_file_filter_add_pixbuf_formats "void gtk_file_filter_add_pixbuf_formats(GtkFileFilter* filter)"
  s7_pointer filter;
  filter = s7_car(args);
  if (!s7_is_c_pointer_of_type(filter, GtkFileFilter__sym)) s7_wrong_type_arg_error(sc, "gtk_file_filter_add_pixbuf_formats", 1, filter, "GtkFileFilter*");
  gtk_file_filter_add_pixbuf_formats((GtkFileFilter*)s7_c_pointer(filter));
  return(lg_false);
}

static s7_pointer lg_gtk_label_set_single_line_mode(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_label_set_single_line_mode "void gtk_label_set_single_line_mode(GtkLabel* label, gboolean single_line_mode)"
  s7_pointer _p;
  s7_pointer label, single_line_mode;
  _p = args;
  label = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(label, GtkLabel__sym)) s7_wrong_type_arg_error(sc, "gtk_label_set_single_line_mode", 1, label, "GtkLabel*");
  single_line_mode = s7_car(_p);
  if (!s7_is_boolean(single_line_mode)) s7_wrong_type_arg_error(sc, "gtk_label_set_single_line_mode", 2, single_line_mode, "gboolean");
  gtk_label_set_single_line_mode((GtkLabel*)s7_c_pointer(label), (gboolean)lg_boolean(single_line_mode));
  return(lg_false);
}

static s7_pointer lg_gtk_label_get_single_line_mode(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_label_get_single_line_mode "gboolean gtk_label_get_single_line_mode(GtkLabel* label)"
  s7_pointer label;
  label = s7_car(args);
  if (!s7_is_c_pointer_of_type(label, GtkLabel__sym)) s7_wrong_type_arg_error(sc, "gtk_label_get_single_line_mode", 1, label, "GtkLabel*");
  return(s7_make_boolean(sc, gtk_label_get_single_line_mode((GtkLabel*)s7_c_pointer(label))));
}

static s7_pointer lg_gtk_progress_bar_set_ellipsize(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_progress_bar_set_ellipsize "void gtk_progress_bar_set_ellipsize(GtkProgressBar* pbar, \
PangoEllipsizeMode mode)"
  s7_pointer _p;
  s7_pointer pbar, mode;
  _p = args;
  pbar = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(pbar, GtkProgressBar__sym)) s7_wrong_type_arg_error(sc, "gtk_progress_bar_set_ellipsize", 1, pbar, "GtkProgressBar*");
  mode = s7_car(_p);
  if (!s7_is_integer(mode)) s7_wrong_type_arg_error(sc, "gtk_progress_bar_set_ellipsize", 2, mode, "PangoEllipsizeMode");
  gtk_progress_bar_set_ellipsize((GtkProgressBar*)s7_c_pointer(pbar), (PangoEllipsizeMode)s7_integer(mode));
  return(lg_false);
}

static s7_pointer lg_gtk_progress_bar_get_ellipsize(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_progress_bar_get_ellipsize "PangoEllipsizeMode gtk_progress_bar_get_ellipsize(GtkProgressBar* pbar)"
  s7_pointer pbar;
  pbar = s7_car(args);
  if (!s7_is_c_pointer_of_type(pbar, GtkProgressBar__sym)) s7_wrong_type_arg_error(sc, "gtk_progress_bar_get_ellipsize", 1, pbar, "GtkProgressBar*");
  return(s7_make_integer(sc, gtk_progress_bar_get_ellipsize((GtkProgressBar*)s7_c_pointer(pbar))));
}

static s7_pointer lg_pango_attr_underline_color_new(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_underline_color_new "PangoAttribute* pango_attr_underline_color_new(guint16 red, \
guint16 green, guint16 blue)"
  s7_pointer _p;
  s7_pointer red, green, blue;
  _p = args;
  red = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(red)) s7_wrong_type_arg_error(sc, "pango_attr_underline_color_new", 1, red, "guint16");
  green = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(green)) s7_wrong_type_arg_error(sc, "pango_attr_underline_color_new", 2, green, "guint16");
  blue = s7_car(_p);
  if (!s7_is_integer(blue)) s7_wrong_type_arg_error(sc, "pango_attr_underline_color_new", 3, blue, "guint16");
  return(lg_make_c_pointer_with_type(sc, PangoAttribute__sym, pango_attr_underline_color_new((guint16)s7_integer(red), (guint16)s7_integer(green), (guint16)s7_integer(blue))));
}

static s7_pointer lg_pango_attr_strikethrough_color_new(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_strikethrough_color_new "PangoAttribute* pango_attr_strikethrough_color_new(guint16 red, \
guint16 green, guint16 blue)"
  s7_pointer _p;
  s7_pointer red, green, blue;
  _p = args;
  red = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(red)) s7_wrong_type_arg_error(sc, "pango_attr_strikethrough_color_new", 1, red, "guint16");
  green = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(green)) s7_wrong_type_arg_error(sc, "pango_attr_strikethrough_color_new", 2, green, "guint16");
  blue = s7_car(_p);
  if (!s7_is_integer(blue)) s7_wrong_type_arg_error(sc, "pango_attr_strikethrough_color_new", 3, blue, "guint16");
  return(lg_make_c_pointer_with_type(sc, PangoAttribute__sym, pango_attr_strikethrough_color_new((guint16)s7_integer(red), (guint16)s7_integer(green), (guint16)s7_integer(blue))));
}

static s7_pointer lg_pango_renderer_draw_layout(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_renderer_draw_layout "void pango_renderer_draw_layout(PangoRenderer* renderer, PangoLayout* layout, \
int x, int y)"
  s7_pointer _p;
  s7_pointer renderer, layout, x, y;
  _p = args;
  renderer = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(renderer, PangoRenderer__sym)) s7_wrong_type_arg_error(sc, "pango_renderer_draw_layout", 1, renderer, "PangoRenderer*");
  layout = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(layout, PangoLayout__sym)) s7_wrong_type_arg_error(sc, "pango_renderer_draw_layout", 2, layout, "PangoLayout*");
  x = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(x)) s7_wrong_type_arg_error(sc, "pango_renderer_draw_layout", 3, x, "int");
  y = s7_car(_p);
  if (!s7_is_integer(y)) s7_wrong_type_arg_error(sc, "pango_renderer_draw_layout", 4, y, "int");
  pango_renderer_draw_layout((PangoRenderer*)s7_c_pointer(renderer), (PangoLayout*)s7_c_pointer(layout), (int)s7_integer(x), (int)s7_integer(y));
  return(lg_false);
}

static s7_pointer lg_pango_renderer_draw_layout_line(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_renderer_draw_layout_line "void pango_renderer_draw_layout_line(PangoRenderer* renderer, \
PangoLayoutLine* line, int x, int y)"
  s7_pointer _p;
  s7_pointer renderer, line, x, y;
  _p = args;
  renderer = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(renderer, PangoRenderer__sym)) s7_wrong_type_arg_error(sc, "pango_renderer_draw_layout_line", 1, renderer, "PangoRenderer*");
  line = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(line, PangoLayoutLine__sym)) s7_wrong_type_arg_error(sc, "pango_renderer_draw_layout_line", 2, line, "PangoLayoutLine*");
  x = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(x)) s7_wrong_type_arg_error(sc, "pango_renderer_draw_layout_line", 3, x, "int");
  y = s7_car(_p);
  if (!s7_is_integer(y)) s7_wrong_type_arg_error(sc, "pango_renderer_draw_layout_line", 4, y, "int");
  pango_renderer_draw_layout_line((PangoRenderer*)s7_c_pointer(renderer), (PangoLayoutLine*)s7_c_pointer(line), (int)s7_integer(x), (int)s7_integer(y));
  return(lg_false);
}

static s7_pointer lg_pango_renderer_draw_glyphs(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_renderer_draw_glyphs "void pango_renderer_draw_glyphs(PangoRenderer* renderer, PangoFont* font, \
PangoGlyphString* glyphs, int x, int y)"
  s7_pointer _p;
  s7_pointer renderer, font, glyphs, x, y;
  _p = args;
  renderer = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(renderer, PangoRenderer__sym)) s7_wrong_type_arg_error(sc, "pango_renderer_draw_glyphs", 1, renderer, "PangoRenderer*");
  font = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(font, PangoFont__sym)) s7_wrong_type_arg_error(sc, "pango_renderer_draw_glyphs", 2, font, "PangoFont*");
  glyphs = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(glyphs, PangoGlyphString__sym)) s7_wrong_type_arg_error(sc, "pango_renderer_draw_glyphs", 3, glyphs, "PangoGlyphString*");
  x = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(x)) s7_wrong_type_arg_error(sc, "pango_renderer_draw_glyphs", 4, x, "int");
  y = s7_car(_p);
  if (!s7_is_integer(y)) s7_wrong_type_arg_error(sc, "pango_renderer_draw_glyphs", 5, y, "int");
  pango_renderer_draw_glyphs((PangoRenderer*)s7_c_pointer(renderer), (PangoFont*)s7_c_pointer(font), (PangoGlyphString*)s7_c_pointer(glyphs), (int)s7_integer(x), (int)s7_integer(y));
  return(lg_false);
}

static s7_pointer lg_pango_renderer_draw_rectangle(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_renderer_draw_rectangle "void pango_renderer_draw_rectangle(PangoRenderer* renderer, \
PangoRenderPart part, int x, int y, int width, int height)"
  s7_pointer _p;
  s7_pointer renderer, part, x, y, width, height;
  _p = args;
  renderer = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(renderer, PangoRenderer__sym)) s7_wrong_type_arg_error(sc, "pango_renderer_draw_rectangle", 1, renderer, "PangoRenderer*");
  part = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(part)) s7_wrong_type_arg_error(sc, "pango_renderer_draw_rectangle", 2, part, "PangoRenderPart");
  x = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(x)) s7_wrong_type_arg_error(sc, "pango_renderer_draw_rectangle", 3, x, "int");
  y = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(y)) s7_wrong_type_arg_error(sc, "pango_renderer_draw_rectangle", 4, y, "int");
  width = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(width)) s7_wrong_type_arg_error(sc, "pango_renderer_draw_rectangle", 5, width, "int");
  height = s7_car(_p);
  if (!s7_is_integer(height)) s7_wrong_type_arg_error(sc, "pango_renderer_draw_rectangle", 6, height, "int");
  pango_renderer_draw_rectangle((PangoRenderer*)s7_c_pointer(renderer), (PangoRenderPart)s7_integer(part), (int)s7_integer(x), (int)s7_integer(y), (int)s7_integer(width), (int)s7_integer(height));
  return(lg_false);
}

static s7_pointer lg_pango_renderer_draw_error_underline(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_renderer_draw_error_underline "void pango_renderer_draw_error_underline(PangoRenderer* renderer, \
int x, int y, int width, int height)"
  s7_pointer _p;
  s7_pointer renderer, x, y, width, height;
  _p = args;
  renderer = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(renderer, PangoRenderer__sym)) s7_wrong_type_arg_error(sc, "pango_renderer_draw_error_underline", 1, renderer, "PangoRenderer*");
  x = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(x)) s7_wrong_type_arg_error(sc, "pango_renderer_draw_error_underline", 2, x, "int");
  y = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(y)) s7_wrong_type_arg_error(sc, "pango_renderer_draw_error_underline", 3, y, "int");
  width = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(width)) s7_wrong_type_arg_error(sc, "pango_renderer_draw_error_underline", 4, width, "int");
  height = s7_car(_p);
  if (!s7_is_integer(height)) s7_wrong_type_arg_error(sc, "pango_renderer_draw_error_underline", 5, height, "int");
  pango_renderer_draw_error_underline((PangoRenderer*)s7_c_pointer(renderer), (int)s7_integer(x), (int)s7_integer(y), (int)s7_integer(width), (int)s7_integer(height));
  return(lg_false);
}

static s7_pointer lg_pango_renderer_draw_trapezoid(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_renderer_draw_trapezoid "void pango_renderer_draw_trapezoid(PangoRenderer* renderer, \
PangoRenderPart part, double y1, double x11, double x21, double y2, double x12, double x22)"
  s7_pointer _p;
  s7_pointer renderer, part, y1, x11, x21, y2, x12, x22;
  _p = args;
  renderer = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(renderer, PangoRenderer__sym)) s7_wrong_type_arg_error(sc, "pango_renderer_draw_trapezoid", 1, renderer, "PangoRenderer*");
  part = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(part)) s7_wrong_type_arg_error(sc, "pango_renderer_draw_trapezoid", 2, part, "PangoRenderPart");
  y1 = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(y1)) s7_wrong_type_arg_error(sc, "pango_renderer_draw_trapezoid", 3, y1, "double");
  x11 = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(x11)) s7_wrong_type_arg_error(sc, "pango_renderer_draw_trapezoid", 4, x11, "double");
  x21 = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(x21)) s7_wrong_type_arg_error(sc, "pango_renderer_draw_trapezoid", 5, x21, "double");
  y2 = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(y2)) s7_wrong_type_arg_error(sc, "pango_renderer_draw_trapezoid", 6, y2, "double");
  x12 = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(x12)) s7_wrong_type_arg_error(sc, "pango_renderer_draw_trapezoid", 7, x12, "double");
  x22 = s7_car(_p);
  if (!s7_is_real(x22)) s7_wrong_type_arg_error(sc, "pango_renderer_draw_trapezoid", 8, x22, "double");
  pango_renderer_draw_trapezoid((PangoRenderer*)s7_c_pointer(renderer), (PangoRenderPart)s7_integer(part), (double)s7_real(y1), (double)s7_real(x11), (double)s7_real(x21), (double)s7_real(y2), (double)s7_real(x12), (double)s7_real(x22));
  return(lg_false);
}

static s7_pointer lg_pango_renderer_draw_glyph(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_renderer_draw_glyph "void pango_renderer_draw_glyph(PangoRenderer* renderer, PangoFont* font, \
PangoGlyph glyph, double x, double y)"
  s7_pointer _p;
  s7_pointer renderer, font, glyph, x, y;
  _p = args;
  renderer = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(renderer, PangoRenderer__sym)) s7_wrong_type_arg_error(sc, "pango_renderer_draw_glyph", 1, renderer, "PangoRenderer*");
  font = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(font, PangoFont__sym)) s7_wrong_type_arg_error(sc, "pango_renderer_draw_glyph", 2, font, "PangoFont*");
  glyph = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(glyph)) s7_wrong_type_arg_error(sc, "pango_renderer_draw_glyph", 3, glyph, "PangoGlyph");
  x = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(x)) s7_wrong_type_arg_error(sc, "pango_renderer_draw_glyph", 4, x, "double");
  y = s7_car(_p);
  if (!s7_is_real(y)) s7_wrong_type_arg_error(sc, "pango_renderer_draw_glyph", 5, y, "double");
  pango_renderer_draw_glyph((PangoRenderer*)s7_c_pointer(renderer), (PangoFont*)s7_c_pointer(font), (PangoGlyph)s7_integer(glyph), (double)s7_real(x), (double)s7_real(y));
  return(lg_false);
}

static s7_pointer lg_pango_renderer_activate(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_renderer_activate "void pango_renderer_activate(PangoRenderer* renderer)"
  s7_pointer renderer;
  renderer = s7_car(args);
  if (!s7_is_c_pointer_of_type(renderer, PangoRenderer__sym)) s7_wrong_type_arg_error(sc, "pango_renderer_activate", 1, renderer, "PangoRenderer*");
  pango_renderer_activate((PangoRenderer*)s7_c_pointer(renderer));
  return(lg_false);
}

static s7_pointer lg_pango_renderer_deactivate(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_renderer_deactivate "void pango_renderer_deactivate(PangoRenderer* renderer)"
  s7_pointer renderer;
  renderer = s7_car(args);
  if (!s7_is_c_pointer_of_type(renderer, PangoRenderer__sym)) s7_wrong_type_arg_error(sc, "pango_renderer_deactivate", 1, renderer, "PangoRenderer*");
  pango_renderer_deactivate((PangoRenderer*)s7_c_pointer(renderer));
  return(lg_false);
}

static s7_pointer lg_pango_renderer_part_changed(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_renderer_part_changed "void pango_renderer_part_changed(PangoRenderer* renderer, PangoRenderPart part)"
  s7_pointer _p;
  s7_pointer renderer, part;
  _p = args;
  renderer = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(renderer, PangoRenderer__sym)) s7_wrong_type_arg_error(sc, "pango_renderer_part_changed", 1, renderer, "PangoRenderer*");
  part = s7_car(_p);
  if (!s7_is_integer(part)) s7_wrong_type_arg_error(sc, "pango_renderer_part_changed", 2, part, "PangoRenderPart");
  pango_renderer_part_changed((PangoRenderer*)s7_c_pointer(renderer), (PangoRenderPart)s7_integer(part));
  return(lg_false);
}

static s7_pointer lg_pango_renderer_set_color(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_renderer_set_color "void pango_renderer_set_color(PangoRenderer* renderer, PangoRenderPart part, \
PangoColor* color)"
  s7_pointer _p;
  s7_pointer renderer, part, color;
  _p = args;
  renderer = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(renderer, PangoRenderer__sym)) s7_wrong_type_arg_error(sc, "pango_renderer_set_color", 1, renderer, "PangoRenderer*");
  part = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(part)) s7_wrong_type_arg_error(sc, "pango_renderer_set_color", 2, part, "PangoRenderPart");
  color = s7_car(_p);
  if (!s7_is_c_pointer_of_type(color, PangoColor__sym)) s7_wrong_type_arg_error(sc, "pango_renderer_set_color", 3, color, "PangoColor*");
  pango_renderer_set_color((PangoRenderer*)s7_c_pointer(renderer), (PangoRenderPart)s7_integer(part), (PangoColor*)s7_c_pointer(color));
  return(lg_false);
}

static s7_pointer lg_pango_renderer_get_color(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_renderer_get_color "PangoColor* pango_renderer_get_color(PangoRenderer* renderer, PangoRenderPart part)"
  s7_pointer _p;
  s7_pointer renderer, part;
  _p = args;
  renderer = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(renderer, PangoRenderer__sym)) s7_wrong_type_arg_error(sc, "pango_renderer_get_color", 1, renderer, "PangoRenderer*");
  part = s7_car(_p);
  if (!s7_is_integer(part)) s7_wrong_type_arg_error(sc, "pango_renderer_get_color", 2, part, "PangoRenderPart");
  return(lg_make_c_pointer_with_type(sc, PangoColor__sym, pango_renderer_get_color((PangoRenderer*)s7_c_pointer(renderer), (PangoRenderPart)s7_integer(part))));
}

static s7_pointer lg_pango_renderer_set_matrix(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_renderer_set_matrix "void pango_renderer_set_matrix(PangoRenderer* renderer, PangoMatrix* matrix)"
  s7_pointer _p;
  s7_pointer renderer, matrix;
  _p = args;
  renderer = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(renderer, PangoRenderer__sym)) s7_wrong_type_arg_error(sc, "pango_renderer_set_matrix", 1, renderer, "PangoRenderer*");
  matrix = s7_car(_p);
  if (!s7_is_c_pointer_of_type(matrix, PangoMatrix__sym)) s7_wrong_type_arg_error(sc, "pango_renderer_set_matrix", 2, matrix, "PangoMatrix*");
  pango_renderer_set_matrix((PangoRenderer*)s7_c_pointer(renderer), (PangoMatrix*)s7_c_pointer(matrix));
  return(lg_false);
}

static s7_pointer lg_g_log_set_handler(s7_scheme *sc, s7_pointer args)
{
  #define H_g_log_set_handler "guint g_log_set_handler(gchar* log_domain, GLogLevelFlags log_levels, \
GLogFunc func, lambda_data func_info)"
  s7_pointer _p;
  s7_pointer log_domain, log_levels, func, func_info;
  _p = args;
  log_domain = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(log_domain)) s7_wrong_type_arg_error(sc, "g_log_set_handler", 1, log_domain, "gchar*");
  log_levels = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(log_levels)) s7_wrong_type_arg_error(sc, "g_log_set_handler", 2, log_levels, "GLogLevelFlags");
  func = s7_car(_p); _p = s7_cdr(_p);
  func_info = s7_car(_p);
  {
    s7_pointer res_ult;
    s7_pointer lg_ptr = s7_list(sc, 5, func, func_info, lg_false, lg_false, lg_false);
    s7_gc_protect(sc, lg_ptr);
    res_ult = s7_make_integer(sc, g_log_set_handler((gchar*)s7_string(log_domain), (GLogLevelFlags)s7_integer(log_levels), lg_g_message_log_func, (gpointer)lg_ptr));
    return(res_ult);
   }
}

static s7_pointer lg_g_log_remove_handler(s7_scheme *sc, s7_pointer args)
{
  #define H_g_log_remove_handler "void g_log_remove_handler(gchar* log_domain, guint handler_id)"
  s7_pointer _p;
  s7_pointer log_domain, handler_id;
  _p = args;
  log_domain = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(log_domain)) s7_wrong_type_arg_error(sc, "g_log_remove_handler", 1, log_domain, "gchar*");
  handler_id = s7_car(_p);
  if (!s7_is_integer(handler_id)) s7_wrong_type_arg_error(sc, "g_log_remove_handler", 2, handler_id, "guint");
  g_log_remove_handler((gchar*)s7_string(log_domain), (guint)s7_integer(handler_id));
  return(lg_false);
}

static s7_pointer lg_gtk_cell_renderer_stop_editing(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_renderer_stop_editing "void gtk_cell_renderer_stop_editing(GtkCellRenderer* cell, \
gboolean canceled)"
  s7_pointer _p;
  s7_pointer cell, canceled;
  _p = args;
  cell = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(cell, GtkCellRenderer__sym)) s7_wrong_type_arg_error(sc, "gtk_cell_renderer_stop_editing", 1, cell, "GtkCellRenderer*");
  canceled = s7_car(_p);
  if (!s7_is_boolean(canceled)) s7_wrong_type_arg_error(sc, "gtk_cell_renderer_stop_editing", 2, canceled, "gboolean");
  gtk_cell_renderer_stop_editing((GtkCellRenderer*)s7_c_pointer(cell), (gboolean)lg_boolean(canceled));
  return(lg_false);
}

static s7_pointer lg_gtk_file_chooser_button_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_file_chooser_button_new "GtkWidget* gtk_file_chooser_button_new(gchar* title, GtkFileChooserAction action)"
  s7_pointer _p;
  s7_pointer title, action;
  _p = args;
  title = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(title)) s7_wrong_type_arg_error(sc, "gtk_file_chooser_button_new", 1, title, "gchar*");
  action = s7_car(_p);
  if (!s7_is_integer(action)) s7_wrong_type_arg_error(sc, "gtk_file_chooser_button_new", 2, action, "GtkFileChooserAction");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_file_chooser_button_new((const gchar*)s7_string(title), (GtkFileChooserAction)s7_integer(action))));
}

static s7_pointer lg_gtk_icon_view_set_columns(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_set_columns "void gtk_icon_view_set_columns(GtkIconView* icon_view, gint columns)"
  s7_pointer _p;
  s7_pointer icon_view, columns;
  _p = args;
  icon_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(icon_view, GtkIconView__sym)) s7_wrong_type_arg_error(sc, "gtk_icon_view_set_columns", 1, icon_view, "GtkIconView*");
  columns = s7_car(_p);
  if (!s7_is_integer(columns)) s7_wrong_type_arg_error(sc, "gtk_icon_view_set_columns", 2, columns, "gint");
  gtk_icon_view_set_columns((GtkIconView*)s7_c_pointer(icon_view), (gint)s7_integer(columns));
  return(lg_false);
}

static s7_pointer lg_gtk_icon_view_get_columns(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_get_columns "gint gtk_icon_view_get_columns(GtkIconView* icon_view)"
  s7_pointer icon_view;
  icon_view = s7_car(args);
  if (!s7_is_c_pointer_of_type(icon_view, GtkIconView__sym)) s7_wrong_type_arg_error(sc, "gtk_icon_view_get_columns", 1, icon_view, "GtkIconView*");
  return(s7_make_integer(sc, gtk_icon_view_get_columns((GtkIconView*)s7_c_pointer(icon_view))));
}

static s7_pointer lg_gtk_icon_view_set_item_width(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_set_item_width "void gtk_icon_view_set_item_width(GtkIconView* icon_view, gint item_width)"
  s7_pointer _p;
  s7_pointer icon_view, item_width;
  _p = args;
  icon_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(icon_view, GtkIconView__sym)) s7_wrong_type_arg_error(sc, "gtk_icon_view_set_item_width", 1, icon_view, "GtkIconView*");
  item_width = s7_car(_p);
  if (!s7_is_integer(item_width)) s7_wrong_type_arg_error(sc, "gtk_icon_view_set_item_width", 2, item_width, "gint");
  gtk_icon_view_set_item_width((GtkIconView*)s7_c_pointer(icon_view), (gint)s7_integer(item_width));
  return(lg_false);
}

static s7_pointer lg_gtk_icon_view_get_item_width(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_get_item_width "gint gtk_icon_view_get_item_width(GtkIconView* icon_view)"
  s7_pointer icon_view;
  icon_view = s7_car(args);
  if (!s7_is_c_pointer_of_type(icon_view, GtkIconView__sym)) s7_wrong_type_arg_error(sc, "gtk_icon_view_get_item_width", 1, icon_view, "GtkIconView*");
  return(s7_make_integer(sc, gtk_icon_view_get_item_width((GtkIconView*)s7_c_pointer(icon_view))));
}

static s7_pointer lg_gtk_icon_view_set_spacing(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_set_spacing "void gtk_icon_view_set_spacing(GtkIconView* icon_view, gint spacing)"
  s7_pointer _p;
  s7_pointer icon_view, spacing;
  _p = args;
  icon_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(icon_view, GtkIconView__sym)) s7_wrong_type_arg_error(sc, "gtk_icon_view_set_spacing", 1, icon_view, "GtkIconView*");
  spacing = s7_car(_p);
  if (!s7_is_integer(spacing)) s7_wrong_type_arg_error(sc, "gtk_icon_view_set_spacing", 2, spacing, "gint");
  gtk_icon_view_set_spacing((GtkIconView*)s7_c_pointer(icon_view), (gint)s7_integer(spacing));
  return(lg_false);
}

static s7_pointer lg_gtk_icon_view_get_spacing(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_get_spacing "gint gtk_icon_view_get_spacing(GtkIconView* icon_view)"
  s7_pointer icon_view;
  icon_view = s7_car(args);
  if (!s7_is_c_pointer_of_type(icon_view, GtkIconView__sym)) s7_wrong_type_arg_error(sc, "gtk_icon_view_get_spacing", 1, icon_view, "GtkIconView*");
  return(s7_make_integer(sc, gtk_icon_view_get_spacing((GtkIconView*)s7_c_pointer(icon_view))));
}

static s7_pointer lg_gtk_icon_view_set_row_spacing(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_set_row_spacing "void gtk_icon_view_set_row_spacing(GtkIconView* icon_view, \
gint row_spacing)"
  s7_pointer _p;
  s7_pointer icon_view, row_spacing;
  _p = args;
  icon_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(icon_view, GtkIconView__sym)) s7_wrong_type_arg_error(sc, "gtk_icon_view_set_row_spacing", 1, icon_view, "GtkIconView*");
  row_spacing = s7_car(_p);
  if (!s7_is_integer(row_spacing)) s7_wrong_type_arg_error(sc, "gtk_icon_view_set_row_spacing", 2, row_spacing, "gint");
  gtk_icon_view_set_row_spacing((GtkIconView*)s7_c_pointer(icon_view), (gint)s7_integer(row_spacing));
  return(lg_false);
}

static s7_pointer lg_gtk_icon_view_get_row_spacing(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_get_row_spacing "gint gtk_icon_view_get_row_spacing(GtkIconView* icon_view)"
  s7_pointer icon_view;
  icon_view = s7_car(args);
  if (!s7_is_c_pointer_of_type(icon_view, GtkIconView__sym)) s7_wrong_type_arg_error(sc, "gtk_icon_view_get_row_spacing", 1, icon_view, "GtkIconView*");
  return(s7_make_integer(sc, gtk_icon_view_get_row_spacing((GtkIconView*)s7_c_pointer(icon_view))));
}

static s7_pointer lg_gtk_icon_view_set_column_spacing(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_set_column_spacing "void gtk_icon_view_set_column_spacing(GtkIconView* icon_view, \
gint column_spacing)"
  s7_pointer _p;
  s7_pointer icon_view, column_spacing;
  _p = args;
  icon_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(icon_view, GtkIconView__sym)) s7_wrong_type_arg_error(sc, "gtk_icon_view_set_column_spacing", 1, icon_view, "GtkIconView*");
  column_spacing = s7_car(_p);
  if (!s7_is_integer(column_spacing)) s7_wrong_type_arg_error(sc, "gtk_icon_view_set_column_spacing", 2, column_spacing, "gint");
  gtk_icon_view_set_column_spacing((GtkIconView*)s7_c_pointer(icon_view), (gint)s7_integer(column_spacing));
  return(lg_false);
}

static s7_pointer lg_gtk_icon_view_get_column_spacing(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_get_column_spacing "gint gtk_icon_view_get_column_spacing(GtkIconView* icon_view)"
  s7_pointer icon_view;
  icon_view = s7_car(args);
  if (!s7_is_c_pointer_of_type(icon_view, GtkIconView__sym)) s7_wrong_type_arg_error(sc, "gtk_icon_view_get_column_spacing", 1, icon_view, "GtkIconView*");
  return(s7_make_integer(sc, gtk_icon_view_get_column_spacing((GtkIconView*)s7_c_pointer(icon_view))));
}

static s7_pointer lg_gtk_icon_view_set_margin(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_set_margin "void gtk_icon_view_set_margin(GtkIconView* icon_view, gint margin)"
  s7_pointer _p;
  s7_pointer icon_view, margin;
  _p = args;
  icon_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(icon_view, GtkIconView__sym)) s7_wrong_type_arg_error(sc, "gtk_icon_view_set_margin", 1, icon_view, "GtkIconView*");
  margin = s7_car(_p);
  if (!s7_is_integer(margin)) s7_wrong_type_arg_error(sc, "gtk_icon_view_set_margin", 2, margin, "gint");
  gtk_icon_view_set_margin((GtkIconView*)s7_c_pointer(icon_view), (gint)s7_integer(margin));
  return(lg_false);
}

static s7_pointer lg_gtk_icon_view_get_margin(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_get_margin "gint gtk_icon_view_get_margin(GtkIconView* icon_view)"
  s7_pointer icon_view;
  icon_view = s7_car(args);
  if (!s7_is_c_pointer_of_type(icon_view, GtkIconView__sym)) s7_wrong_type_arg_error(sc, "gtk_icon_view_get_margin", 1, icon_view, "GtkIconView*");
  return(s7_make_integer(sc, gtk_icon_view_get_margin((GtkIconView*)s7_c_pointer(icon_view))));
}

static s7_pointer lg_gtk_label_set_max_width_chars(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_label_set_max_width_chars "void gtk_label_set_max_width_chars(GtkLabel* label, gint n_chars)"
  s7_pointer _p;
  s7_pointer label, n_chars;
  _p = args;
  label = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(label, GtkLabel__sym)) s7_wrong_type_arg_error(sc, "gtk_label_set_max_width_chars", 1, label, "GtkLabel*");
  n_chars = s7_car(_p);
  if (!s7_is_integer(n_chars)) s7_wrong_type_arg_error(sc, "gtk_label_set_max_width_chars", 2, n_chars, "gint");
  gtk_label_set_max_width_chars((GtkLabel*)s7_c_pointer(label), (gint)s7_integer(n_chars));
  return(lg_false);
}

static s7_pointer lg_gtk_label_get_max_width_chars(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_label_get_max_width_chars "gint gtk_label_get_max_width_chars(GtkLabel* label)"
  s7_pointer label;
  label = s7_car(args);
  if (!s7_is_c_pointer_of_type(label, GtkLabel__sym)) s7_wrong_type_arg_error(sc, "gtk_label_get_max_width_chars", 1, label, "GtkLabel*");
  return(s7_make_integer(sc, gtk_label_get_max_width_chars((GtkLabel*)s7_c_pointer(label))));
}

static s7_pointer lg_gtk_list_store_insert_with_values(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_list_store_insert_with_values "void gtk_list_store_insert_with_values(GtkListStore* list_store, \
GtkTreeIter* iter, gint position, ...)"
  s7_pointer _p;
  s7_pointer list_store, iter, position;
  _p = args;
  list_store = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(list_store, GtkListStore__sym)) s7_wrong_type_arg_error(sc, "gtk_list_store_insert_with_values", 1, list_store, "GtkListStore*");
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTreeIter__sym)) s7_wrong_type_arg_error(sc, "gtk_list_store_insert_with_values", 2, iter, "GtkTreeIter*");
  position = s7_car(_p);
  if (!s7_is_integer(position)) s7_wrong_type_arg_error(sc, "gtk_list_store_insert_with_values", 3, position, "gint");
  gtk_list_store_insert_with_values((GtkListStore*)s7_c_pointer(list_store), (GtkTreeIter*)s7_c_pointer(iter), (gint)s7_integer(position));
  return(lg_false);
}

static s7_pointer lg_gtk_list_store_insert_with_valuesv(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_list_store_insert_with_valuesv "void gtk_list_store_insert_with_valuesv(GtkListStore* list_store, \
GtkTreeIter* iter, gint position, gint* columns, GValue* values, gint n_values)"
  s7_pointer _p;
  s7_pointer list_store, iter, position, columns, values, n_values;
  _p = args;
  list_store = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(list_store, GtkListStore__sym)) s7_wrong_type_arg_error(sc, "gtk_list_store_insert_with_valuesv", 1, list_store, "GtkListStore*");
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTreeIter__sym)) s7_wrong_type_arg_error(sc, "gtk_list_store_insert_with_valuesv", 2, iter, "GtkTreeIter*");
  position = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(position)) s7_wrong_type_arg_error(sc, "gtk_list_store_insert_with_valuesv", 3, position, "gint");
  columns = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(columns, gint__sym)) s7_wrong_type_arg_error(sc, "gtk_list_store_insert_with_valuesv", 4, columns, "gint*");
  values = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(values, GValue__sym)) s7_wrong_type_arg_error(sc, "gtk_list_store_insert_with_valuesv", 5, values, "GValue*");
  n_values = s7_car(_p);
  if (!s7_is_integer(n_values)) s7_wrong_type_arg_error(sc, "gtk_list_store_insert_with_valuesv", 6, n_values, "gint");
  gtk_list_store_insert_with_valuesv((GtkListStore*)s7_c_pointer(list_store), (GtkTreeIter*)s7_c_pointer(iter), (gint)s7_integer(position), (gint*)s7_c_pointer(columns), (GValue*)s7_c_pointer(values), (gint)s7_integer(n_values));
  return(lg_false);
}

static s7_pointer lg_pango_attr_size_new_absolute(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_size_new_absolute "PangoAttribute* pango_attr_size_new_absolute(int size)"
  s7_pointer size;
  size = s7_car(args);
  if (!s7_is_integer(size)) s7_wrong_type_arg_error(sc, "pango_attr_size_new_absolute", 1, size, "int");
  return(lg_make_c_pointer_with_type(sc, PangoAttribute__sym, pango_attr_size_new_absolute((int)s7_integer(size))));
}

static s7_pointer lg_pango_font_description_set_absolute_size(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_font_description_set_absolute_size "void pango_font_description_set_absolute_size(PangoFontDescription* desc, \
double size)"
  s7_pointer _p;
  s7_pointer desc, size;
  _p = args;
  desc = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(desc, PangoFontDescription__sym)) s7_wrong_type_arg_error(sc, "pango_font_description_set_absolute_size", 1, desc, "PangoFontDescription*");
  size = s7_car(_p);
  if (!s7_is_real(size)) s7_wrong_type_arg_error(sc, "pango_font_description_set_absolute_size", 2, size, "double");
  pango_font_description_set_absolute_size((PangoFontDescription*)s7_c_pointer(desc), (double)s7_real(size));
  return(lg_false);
}

static s7_pointer lg_pango_layout_get_font_description(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_get_font_description "PangoFontDescription* pango_layout_get_font_description(PangoLayout* layout)"
  s7_pointer layout;
  layout = s7_car(args);
  if (!s7_is_c_pointer_of_type(layout, PangoLayout__sym)) s7_wrong_type_arg_error(sc, "pango_layout_get_font_description", 1, layout, "PangoLayout*");
    return(lg_make_c_pointer_with_type(sc, PangoFontDescription__sym, (PangoFontDescription*)pango_layout_get_font_description((PangoLayout*)s7_c_pointer(layout))));
}

static s7_pointer lg_gtk_dialog_get_response_for_widget(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_dialog_get_response_for_widget "gint gtk_dialog_get_response_for_widget(GtkDialog* dialog, \
GtkWidget* widget)"
  s7_pointer _p;
  s7_pointer dialog, widget;
  _p = args;
  dialog = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(dialog, GtkDialog__sym)) s7_wrong_type_arg_error(sc, "gtk_dialog_get_response_for_widget", 1, dialog, "GtkDialog*");
  widget = s7_car(_p);
  if (!s7_is_c_pointer_of_type(widget, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_dialog_get_response_for_widget", 2, widget, "GtkWidget*");
  return(s7_make_integer(sc, gtk_dialog_get_response_for_widget((GtkDialog*)s7_c_pointer(dialog), (GtkWidget*)s7_c_pointer(widget))));
}

static s7_pointer lg_gtk_entry_completion_set_popup_set_width(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_completion_set_popup_set_width "void gtk_entry_completion_set_popup_set_width(GtkEntryCompletion* completion, \
gboolean popup_set_width)"
  s7_pointer _p;
  s7_pointer completion, popup_set_width;
  _p = args;
  completion = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(completion, GtkEntryCompletion__sym)) s7_wrong_type_arg_error(sc, "gtk_entry_completion_set_popup_set_width", 1, completion, "GtkEntryCompletion*");
  popup_set_width = s7_car(_p);
  if (!s7_is_boolean(popup_set_width)) s7_wrong_type_arg_error(sc, "gtk_entry_completion_set_popup_set_width", 2, popup_set_width, "gboolean");
  gtk_entry_completion_set_popup_set_width((GtkEntryCompletion*)s7_c_pointer(completion), (gboolean)lg_boolean(popup_set_width));
  return(lg_false);
}

static s7_pointer lg_gtk_entry_completion_get_popup_set_width(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_completion_get_popup_set_width "gboolean gtk_entry_completion_get_popup_set_width(GtkEntryCompletion* completion)"
  s7_pointer completion;
  completion = s7_car(args);
  if (!s7_is_c_pointer_of_type(completion, GtkEntryCompletion__sym)) s7_wrong_type_arg_error(sc, "gtk_entry_completion_get_popup_set_width", 1, completion, "GtkEntryCompletion*");
  return(s7_make_boolean(sc, gtk_entry_completion_get_popup_set_width((GtkEntryCompletion*)s7_c_pointer(completion))));
}

static s7_pointer lg_gtk_entry_completion_set_popup_single_match(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_completion_set_popup_single_match "void gtk_entry_completion_set_popup_single_match(GtkEntryCompletion* completion, \
gboolean popup_single_match)"
  s7_pointer _p;
  s7_pointer completion, popup_single_match;
  _p = args;
  completion = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(completion, GtkEntryCompletion__sym)) s7_wrong_type_arg_error(sc, "gtk_entry_completion_set_popup_single_match", 1, completion, "GtkEntryCompletion*");
  popup_single_match = s7_car(_p);
  if (!s7_is_boolean(popup_single_match)) s7_wrong_type_arg_error(sc, "gtk_entry_completion_set_popup_single_match", 2, popup_single_match, "gboolean");
  gtk_entry_completion_set_popup_single_match((GtkEntryCompletion*)s7_c_pointer(completion), (gboolean)lg_boolean(popup_single_match));
  return(lg_false);
}

static s7_pointer lg_gtk_entry_completion_get_popup_single_match(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_entry_completion_get_popup_single_match "gboolean gtk_entry_completion_get_popup_single_match(GtkEntryCompletion* completion)"
  s7_pointer completion;
  completion = s7_car(args);
  if (!s7_is_c_pointer_of_type(completion, GtkEntryCompletion__sym)) s7_wrong_type_arg_error(sc, "gtk_entry_completion_get_popup_single_match", 1, completion, "GtkEntryCompletion*");
  return(s7_make_boolean(sc, gtk_entry_completion_get_popup_single_match((GtkEntryCompletion*)s7_c_pointer(completion))));
}

static s7_pointer lg_gtk_icon_view_get_item_at_pos(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_get_item_at_pos "gboolean gtk_icon_view_get_item_at_pos(GtkIconView* icon_view, \
gint x, gint y, GtkTreePath** [path], GtkCellRenderer** [cell])"
  s7_pointer _p;
  s7_pointer icon_view, x, y;
  GtkTreePath* ref_path = NULL;
  GtkCellRenderer* ref_cell = NULL;
  _p = args;
  icon_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(icon_view, GtkIconView__sym)) s7_wrong_type_arg_error(sc, "gtk_icon_view_get_item_at_pos", 1, icon_view, "GtkIconView*");
  x = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(x)) s7_wrong_type_arg_error(sc, "gtk_icon_view_get_item_at_pos", 2, x, "gint");
  y = s7_car(_p);
  if (!s7_is_integer(y)) s7_wrong_type_arg_error(sc, "gtk_icon_view_get_item_at_pos", 3, y, "gint");
  {
    s7_pointer res_ult;
    res_ult = s7_make_boolean(sc, gtk_icon_view_get_item_at_pos((GtkIconView*)s7_c_pointer(icon_view), (gint)s7_integer(x), (gint)s7_integer(y), &ref_path, &ref_cell));
      return(s7_list(sc, 3, res_ult, s7_make_c_pointer(sc, ref_path), s7_make_c_pointer(sc, ref_cell)));
   }
}

static s7_pointer lg_gtk_icon_view_get_visible_range(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_get_visible_range "gboolean gtk_icon_view_get_visible_range(GtkIconView* icon_view, \
GtkTreePath** [start_path], GtkTreePath** [end_path])"
  s7_pointer _p;
  s7_pointer icon_view;
  GtkTreePath* ref_start_path = NULL;
  GtkTreePath* ref_end_path = NULL;
  _p = args;
  icon_view = s7_car(_p);
  if (!s7_is_c_pointer_of_type(icon_view, GtkIconView__sym)) s7_wrong_type_arg_error(sc, "gtk_icon_view_get_visible_range", 1, icon_view, "GtkIconView*");
  {
    s7_pointer res_ult;
    res_ult = s7_make_boolean(sc, gtk_icon_view_get_visible_range((GtkIconView*)s7_c_pointer(icon_view), &ref_start_path, &ref_end_path));
      return(s7_list(sc, 3, res_ult, s7_make_c_pointer(sc, ref_start_path), s7_make_c_pointer(sc, ref_end_path)));
   }
}

static s7_pointer lg_gtk_icon_view_set_cursor(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_set_cursor "void gtk_icon_view_set_cursor(GtkIconView* icon_view, GtkTreePath* path, \
GtkCellRenderer* cell, gboolean start_editing)"
  s7_pointer _p;
  s7_pointer icon_view, path, cell, start_editing;
  _p = args;
  icon_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(icon_view, GtkIconView__sym)) s7_wrong_type_arg_error(sc, "gtk_icon_view_set_cursor", 1, icon_view, "GtkIconView*");
  path = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(path, GtkTreePath__sym)) s7_wrong_type_arg_error(sc, "gtk_icon_view_set_cursor", 2, path, "GtkTreePath*");
  cell = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(cell, GtkCellRenderer__sym)) s7_wrong_type_arg_error(sc, "gtk_icon_view_set_cursor", 3, cell, "GtkCellRenderer*");
  start_editing = s7_car(_p);
  if (!s7_is_boolean(start_editing)) s7_wrong_type_arg_error(sc, "gtk_icon_view_set_cursor", 4, start_editing, "gboolean");
  gtk_icon_view_set_cursor((GtkIconView*)s7_c_pointer(icon_view), (GtkTreePath*)s7_c_pointer(path), (GtkCellRenderer*)s7_c_pointer(cell), (gboolean)lg_boolean(start_editing));
  return(lg_false);
}

static s7_pointer lg_gtk_icon_view_get_cursor(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_get_cursor "gboolean gtk_icon_view_get_cursor(GtkIconView* icon_view, GtkTreePath** [path], \
GtkCellRenderer** [cell])"
  s7_pointer _p;
  s7_pointer icon_view;
  GtkTreePath* ref_path = NULL;
  GtkCellRenderer* ref_cell = NULL;
  _p = args;
  icon_view = s7_car(_p);
  if (!s7_is_c_pointer_of_type(icon_view, GtkIconView__sym)) s7_wrong_type_arg_error(sc, "gtk_icon_view_get_cursor", 1, icon_view, "GtkIconView*");
  {
    s7_pointer res_ult;
    res_ult = s7_make_boolean(sc, gtk_icon_view_get_cursor((GtkIconView*)s7_c_pointer(icon_view), &ref_path, &ref_cell));
      return(s7_list(sc, 3, res_ult, s7_make_c_pointer(sc, ref_path), s7_make_c_pointer(sc, ref_cell)));
   }
}

static s7_pointer lg_gtk_icon_view_scroll_to_path(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_scroll_to_path "void gtk_icon_view_scroll_to_path(GtkIconView* icon_view, GtkTreePath* path, \
gboolean use_align, gfloat row_align, gfloat col_align)"
  s7_pointer _p;
  s7_pointer icon_view, path, use_align, row_align, col_align;
  _p = args;
  icon_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(icon_view, GtkIconView__sym)) s7_wrong_type_arg_error(sc, "gtk_icon_view_scroll_to_path", 1, icon_view, "GtkIconView*");
  path = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(path, GtkTreePath__sym)) s7_wrong_type_arg_error(sc, "gtk_icon_view_scroll_to_path", 2, path, "GtkTreePath*");
  use_align = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_boolean(use_align)) s7_wrong_type_arg_error(sc, "gtk_icon_view_scroll_to_path", 3, use_align, "gboolean");
  row_align = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(row_align)) s7_wrong_type_arg_error(sc, "gtk_icon_view_scroll_to_path", 4, row_align, "gfloat");
  col_align = s7_car(_p);
  if (!s7_is_real(col_align)) s7_wrong_type_arg_error(sc, "gtk_icon_view_scroll_to_path", 5, col_align, "gfloat");
  gtk_icon_view_scroll_to_path((GtkIconView*)s7_c_pointer(icon_view), (GtkTreePath*)s7_c_pointer(path), (gboolean)lg_boolean(use_align), (gfloat)s7_real(row_align), (gfloat)s7_real(col_align));
  return(lg_false);
}

static s7_pointer lg_gtk_icon_view_unset_model_drag_source(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_unset_model_drag_source "void gtk_icon_view_unset_model_drag_source(GtkIconView* icon_view)"
  s7_pointer icon_view;
  icon_view = s7_car(args);
  if (!s7_is_c_pointer_of_type(icon_view, GtkIconView__sym)) s7_wrong_type_arg_error(sc, "gtk_icon_view_unset_model_drag_source", 1, icon_view, "GtkIconView*");
  gtk_icon_view_unset_model_drag_source((GtkIconView*)s7_c_pointer(icon_view));
  return(lg_false);
}

static s7_pointer lg_gtk_icon_view_set_reorderable(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_set_reorderable "void gtk_icon_view_set_reorderable(GtkIconView* icon_view, \
gboolean reorderable)"
  s7_pointer _p;
  s7_pointer icon_view, reorderable;
  _p = args;
  icon_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(icon_view, GtkIconView__sym)) s7_wrong_type_arg_error(sc, "gtk_icon_view_set_reorderable", 1, icon_view, "GtkIconView*");
  reorderable = s7_car(_p);
  if (!s7_is_boolean(reorderable)) s7_wrong_type_arg_error(sc, "gtk_icon_view_set_reorderable", 2, reorderable, "gboolean");
  gtk_icon_view_set_reorderable((GtkIconView*)s7_c_pointer(icon_view), (gboolean)lg_boolean(reorderable));
  return(lg_false);
}

static s7_pointer lg_gtk_icon_view_get_reorderable(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_get_reorderable "gboolean gtk_icon_view_get_reorderable(GtkIconView* icon_view)"
  s7_pointer icon_view;
  icon_view = s7_car(args);
  if (!s7_is_c_pointer_of_type(icon_view, GtkIconView__sym)) s7_wrong_type_arg_error(sc, "gtk_icon_view_get_reorderable", 1, icon_view, "GtkIconView*");
  return(s7_make_boolean(sc, gtk_icon_view_get_reorderable((GtkIconView*)s7_c_pointer(icon_view))));
}

static s7_pointer lg_gtk_icon_view_get_dest_item_at_pos(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_icon_view_get_dest_item_at_pos "gboolean gtk_icon_view_get_dest_item_at_pos(GtkIconView* icon_view, \
gint drag_x, gint drag_y, GtkTreePath** [path], GtkIconViewDropPosition* [pos])"
  s7_pointer _p;
  s7_pointer icon_view, drag_x, drag_y;
  GtkTreePath* ref_path = NULL;
  GtkIconViewDropPosition ref_pos;
  _p = args;
  icon_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(icon_view, GtkIconView__sym)) s7_wrong_type_arg_error(sc, "gtk_icon_view_get_dest_item_at_pos", 1, icon_view, "GtkIconView*");
  drag_x = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(drag_x)) s7_wrong_type_arg_error(sc, "gtk_icon_view_get_dest_item_at_pos", 2, drag_x, "gint");
  drag_y = s7_car(_p);
  if (!s7_is_integer(drag_y)) s7_wrong_type_arg_error(sc, "gtk_icon_view_get_dest_item_at_pos", 3, drag_y, "gint");
  {
    s7_pointer res_ult;
    res_ult = s7_make_boolean(sc, gtk_icon_view_get_dest_item_at_pos((GtkIconView*)s7_c_pointer(icon_view), (gint)s7_integer(drag_x), (gint)s7_integer(drag_y), &ref_path, &ref_pos));
      return(s7_list(sc, 3, res_ult, s7_make_c_pointer(sc, ref_path), s7_make_integer(sc, ref_pos)));
   }
}

static s7_pointer lg_gtk_image_clear(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_image_clear "void gtk_image_clear(GtkImage* image)"
  s7_pointer image;
  image = s7_car(args);
  if (!s7_is_c_pointer_of_type(image, GtkImage__sym)) s7_wrong_type_arg_error(sc, "gtk_image_clear", 1, image, "GtkImage*");
  gtk_image_clear((GtkImage*)s7_c_pointer(image));
  return(lg_false);
}

static s7_pointer lg_gtk_text_iter_forward_visible_line(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_forward_visible_line "gboolean gtk_text_iter_forward_visible_line(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_forward_visible_line", 1, iter, "GtkTextIter*");
  return(s7_make_boolean(sc, gtk_text_iter_forward_visible_line((GtkTextIter*)s7_c_pointer(iter))));
}

static s7_pointer lg_gtk_text_iter_backward_visible_line(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_backward_visible_line "gboolean gtk_text_iter_backward_visible_line(GtkTextIter* iter)"
  s7_pointer iter;
  iter = s7_car(args);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_backward_visible_line", 1, iter, "GtkTextIter*");
  return(s7_make_boolean(sc, gtk_text_iter_backward_visible_line((GtkTextIter*)s7_c_pointer(iter))));
}

static s7_pointer lg_gtk_text_iter_forward_visible_lines(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_forward_visible_lines "gboolean gtk_text_iter_forward_visible_lines(GtkTextIter* iter, \
gint count)"
  s7_pointer _p;
  s7_pointer iter, count;
  _p = args;
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_forward_visible_lines", 1, iter, "GtkTextIter*");
  count = s7_car(_p);
  if (!s7_is_integer(count)) s7_wrong_type_arg_error(sc, "gtk_text_iter_forward_visible_lines", 2, count, "gint");
  return(s7_make_boolean(sc, gtk_text_iter_forward_visible_lines((GtkTextIter*)s7_c_pointer(iter), (gint)s7_integer(count))));
}

static s7_pointer lg_gtk_text_iter_backward_visible_lines(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_iter_backward_visible_lines "gboolean gtk_text_iter_backward_visible_lines(GtkTextIter* iter, \
gint count)"
  s7_pointer _p;
  s7_pointer iter, count;
  _p = args;
  iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(iter, GtkTextIter__sym)) s7_wrong_type_arg_error(sc, "gtk_text_iter_backward_visible_lines", 1, iter, "GtkTextIter*");
  count = s7_car(_p);
  if (!s7_is_integer(count)) s7_wrong_type_arg_error(sc, "gtk_text_iter_backward_visible_lines", 2, count, "gint");
  return(s7_make_boolean(sc, gtk_text_iter_backward_visible_lines((GtkTextIter*)s7_c_pointer(iter), (gint)s7_integer(count))));
}

static s7_pointer lg_gtk_window_present_with_time(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_window_present_with_time "void gtk_window_present_with_time(GtkWindow* window, guint32 timestamp)"
  s7_pointer _p;
  s7_pointer window, timestamp;
  _p = args;
  window = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(window, GtkWindow__sym)) s7_wrong_type_arg_error(sc, "gtk_window_present_with_time", 1, window, "GtkWindow*");
  timestamp = s7_car(_p);
  if (!s7_is_integer(timestamp)) s7_wrong_type_arg_error(sc, "gtk_window_present_with_time", 2, timestamp, "guint32");
  gtk_window_present_with_time((GtkWindow*)s7_c_pointer(window), (guint32)s7_integer(timestamp));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_row_reference_get_model(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_row_reference_get_model "GtkTreeModel* gtk_tree_row_reference_get_model(GtkTreeRowReference* reference)"
  s7_pointer reference;
  reference = s7_car(args);
  if (!s7_is_c_pointer_of_type(reference, GtkTreeRowReference__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_row_reference_get_model", 1, reference, "GtkTreeRowReference*");
  return(lg_make_c_pointer_with_type(sc, GtkTreeModel__sym, gtk_tree_row_reference_get_model((GtkTreeRowReference*)s7_c_pointer(reference))));
}

static s7_pointer lg_gtk_tree_view_column_queue_resize(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_column_queue_resize "void gtk_tree_view_column_queue_resize(GtkTreeViewColumn* tree_column)"
  s7_pointer tree_column;
  tree_column = s7_car(args);
  if (!s7_is_c_pointer_of_type(tree_column, GtkTreeViewColumn__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_column_queue_resize", 1, tree_column, "GtkTreeViewColumn*");
  gtk_tree_view_column_queue_resize((GtkTreeViewColumn*)s7_c_pointer(tree_column));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_get_visible_range(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_get_visible_range "gboolean gtk_tree_view_get_visible_range(GtkTreeView* tree_view, \
GtkTreePath** [start_path], GtkTreePath** [end_path])"
  s7_pointer _p;
  s7_pointer tree_view;
  GtkTreePath* ref_start_path = NULL;
  GtkTreePath* ref_end_path = NULL;
  _p = args;
  tree_view = s7_car(_p);
  if (!s7_is_c_pointer_of_type(tree_view, GtkTreeView__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_get_visible_range", 1, tree_view, "GtkTreeView*");
  {
    s7_pointer res_ult;
    res_ult = s7_make_boolean(sc, gtk_tree_view_get_visible_range((GtkTreeView*)s7_c_pointer(tree_view), &ref_start_path, &ref_end_path));
      return(s7_list(sc, 3, res_ult, s7_make_c_pointer(sc, ref_start_path), s7_make_c_pointer(sc, ref_end_path)));
   }
}

static s7_pointer lg_pango_attr_list_ref(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_attr_list_ref "PangoAttrList* pango_attr_list_ref(PangoAttrList* list)"
  s7_pointer list;
  list = s7_car(args);
  if (!s7_is_c_pointer_of_type(list, PangoAttrList__sym)) s7_wrong_type_arg_error(sc, "pango_attr_list_ref", 1, list, "PangoAttrList*");
  return(lg_make_c_pointer_with_type(sc, PangoAttrList__sym, pango_attr_list_ref((PangoAttrList*)s7_c_pointer(list))));
}

static s7_pointer lg_pango_layout_line_ref(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_line_ref "PangoLayoutLine* pango_layout_line_ref(PangoLayoutLine* line)"
  s7_pointer line;
  line = s7_car(args);
  if (!s7_is_c_pointer_of_type(line, PangoLayoutLine__sym)) s7_wrong_type_arg_error(sc, "pango_layout_line_ref", 1, line, "PangoLayoutLine*");
  return(lg_make_c_pointer_with_type(sc, PangoLayoutLine__sym, pango_layout_line_ref((PangoLayoutLine*)s7_c_pointer(line))));
}

static s7_pointer lg_pango_layout_index_to_line_x(s7_scheme *sc, s7_pointer args)
{
  #define H_pango_layout_index_to_line_x "void pango_layout_index_to_line_x(PangoLayout* layout, int index_, \
gboolean trailing, int* [line], int* [x_pos])"
  s7_pointer _p;
  s7_pointer layout, index_, trailing;
  int ref_line;
  int ref_x_pos;
  _p = args;
  layout = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(layout, PangoLayout__sym)) s7_wrong_type_arg_error(sc, "pango_layout_index_to_line_x", 1, layout, "PangoLayout*");
  index_ = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(index_)) s7_wrong_type_arg_error(sc, "pango_layout_index_to_line_x", 2, index_, "int");
  trailing = s7_car(_p);
  if (!s7_is_boolean(trailing)) s7_wrong_type_arg_error(sc, "pango_layout_index_to_line_x", 3, trailing, "gboolean");
  pango_layout_index_to_line_x((PangoLayout*)s7_c_pointer(layout), (int)s7_integer(index_), (gboolean)lg_boolean(trailing), &ref_line, &ref_x_pos);
    return(s7_list(sc, 2, s7_make_integer(sc, ref_line), s7_make_integer(sc, ref_x_pos)));
}

static s7_pointer lg_gdk_display_supports_input_shapes(s7_scheme *sc, s7_pointer args)
{
  #define H_gdk_display_supports_input_shapes "gboolean gdk_display_supports_input_shapes(GdkDisplay* display)"
  s7_pointer display;
  display = s7_car(args);
  if (!s7_is_c_pointer_of_type(display, GdkDisplay__sym)) s7_wrong_type_arg_error(sc, "gdk_display_supports_input_shapes", 1, display, "GdkDisplay*");
  return(s7_make_boolean(sc, gdk_display_supports_input_shapes((GdkDisplay*)s7_c_pointer(display))));
}

static s7_pointer lg_gtk_notebook_get_tab_reorderable(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_get_tab_reorderable "gboolean gtk_notebook_get_tab_reorderable(GtkNotebook* notebook, \
GtkWidget* child)"
  s7_pointer _p;
  s7_pointer notebook, child;
  _p = args;
  notebook = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(notebook, GtkNotebook__sym)) s7_wrong_type_arg_error(sc, "gtk_notebook_get_tab_reorderable", 1, notebook, "GtkNotebook*");
  child = s7_car(_p);
  if (!s7_is_c_pointer_of_type(child, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_notebook_get_tab_reorderable", 2, child, "GtkWidget*");
  return(s7_make_boolean(sc, gtk_notebook_get_tab_reorderable((GtkNotebook*)s7_c_pointer(notebook), (GtkWidget*)s7_c_pointer(child))));
}

static s7_pointer lg_gtk_notebook_set_tab_reorderable(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_set_tab_reorderable "void gtk_notebook_set_tab_reorderable(GtkNotebook* notebook, \
GtkWidget* child, gboolean reorderable)"
  s7_pointer _p;
  s7_pointer notebook, child, reorderable;
  _p = args;
  notebook = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(notebook, GtkNotebook__sym)) s7_wrong_type_arg_error(sc, "gtk_notebook_set_tab_reorderable", 1, notebook, "GtkNotebook*");
  child = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(child, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_notebook_set_tab_reorderable", 2, child, "GtkWidget*");
  reorderable = s7_car(_p);
  if (!s7_is_boolean(reorderable)) s7_wrong_type_arg_error(sc, "gtk_notebook_set_tab_reorderable", 3, reorderable, "gboolean");
  gtk_notebook_set_tab_reorderable((GtkNotebook*)s7_c_pointer(notebook), (GtkWidget*)s7_c_pointer(child), (gboolean)lg_boolean(reorderable));
  return(lg_false);
}

static s7_pointer lg_gtk_notebook_get_tab_detachable(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_get_tab_detachable "gboolean gtk_notebook_get_tab_detachable(GtkNotebook* notebook, \
GtkWidget* child)"
  s7_pointer _p;
  s7_pointer notebook, child;
  _p = args;
  notebook = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(notebook, GtkNotebook__sym)) s7_wrong_type_arg_error(sc, "gtk_notebook_get_tab_detachable", 1, notebook, "GtkNotebook*");
  child = s7_car(_p);
  if (!s7_is_c_pointer_of_type(child, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_notebook_get_tab_detachable", 2, child, "GtkWidget*");
  return(s7_make_boolean(sc, gtk_notebook_get_tab_detachable((GtkNotebook*)s7_c_pointer(notebook), (GtkWidget*)s7_c_pointer(child))));
}

static s7_pointer lg_gtk_notebook_set_tab_detachable(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_notebook_set_tab_detachable "void gtk_notebook_set_tab_detachable(GtkNotebook* notebook, \
GtkWidget* child, gboolean detachable)"
  s7_pointer _p;
  s7_pointer notebook, child, detachable;
  _p = args;
  notebook = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(notebook, GtkNotebook__sym)) s7_wrong_type_arg_error(sc, "gtk_notebook_set_tab_detachable", 1, notebook, "GtkNotebook*");
  child = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(child, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_notebook_set_tab_detachable", 2, child, "GtkWidget*");
  detachable = s7_car(_p);
  if (!s7_is_boolean(detachable)) s7_wrong_type_arg_error(sc, "gtk_notebook_set_tab_detachable", 3, detachable, "gboolean");
  gtk_notebook_set_tab_detachable((GtkNotebook*)s7_c_pointer(notebook), (GtkWidget*)s7_c_pointer(child), (gboolean)lg_boolean(detachable));
  return(lg_false);
}

static s7_pointer lg_gtk_scrolled_window_unset_placement(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_scrolled_window_unset_placement "void gtk_scrolled_window_unset_placement(GtkScrolledWindow* scrolled_window)"
  s7_pointer scrolled_window;
  scrolled_window = s7_car(args);
  if (!s7_is_c_pointer_of_type(scrolled_window, GtkScrolledWindow__sym)) s7_wrong_type_arg_error(sc, "gtk_scrolled_window_unset_placement", 1, scrolled_window, "GtkScrolledWindow*");
  gtk_scrolled_window_unset_placement((GtkScrolledWindow*)s7_c_pointer(scrolled_window));
  return(lg_false);
}

static s7_pointer lg_gtk_size_group_get_widgets(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_size_group_get_widgets "GSList* gtk_size_group_get_widgets(GtkSizeGroup* size_group)"
  s7_pointer size_group;
  size_group = s7_car(args);
  if (!s7_is_c_pointer_of_type(size_group, GtkSizeGroup__sym)) s7_wrong_type_arg_error(sc, "gtk_size_group_get_widgets", 1, size_group, "GtkSizeGroup*");
  return(lg_make_c_pointer_with_type(sc, GSList__sym, gtk_size_group_get_widgets((GtkSizeGroup*)s7_c_pointer(size_group))));
}

static s7_pointer lg_gtk_text_buffer_get_has_selection(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_text_buffer_get_has_selection "gboolean gtk_text_buffer_get_has_selection(GtkTextBuffer* buffer)"
  s7_pointer buffer;
  buffer = s7_car(args);
  if (!s7_is_c_pointer_of_type(buffer, GtkTextBuffer__sym)) s7_wrong_type_arg_error(sc, "gtk_text_buffer_get_has_selection", 1, buffer, "GtkTextBuffer*");
  return(s7_make_boolean(sc, gtk_text_buffer_get_has_selection((GtkTextBuffer*)s7_c_pointer(buffer))));
}

static s7_pointer lg_gtk_tree_view_get_headers_clickable(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_get_headers_clickable "gboolean gtk_tree_view_get_headers_clickable(GtkTreeView* tree_view)"
  s7_pointer tree_view;
  tree_view = s7_car(args);
  if (!s7_is_c_pointer_of_type(tree_view, GtkTreeView__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_get_headers_clickable", 1, tree_view, "GtkTreeView*");
  return(s7_make_boolean(sc, gtk_tree_view_get_headers_clickable((GtkTreeView*)s7_c_pointer(tree_view))));
}

static s7_pointer lg_gtk_window_set_deletable(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_window_set_deletable "void gtk_window_set_deletable(GtkWindow* window, gboolean setting)"
  s7_pointer _p;
  s7_pointer window, setting;
  _p = args;
  window = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(window, GtkWindow__sym)) s7_wrong_type_arg_error(sc, "gtk_window_set_deletable", 1, window, "GtkWindow*");
  setting = s7_car(_p);
  if (!s7_is_boolean(setting)) s7_wrong_type_arg_error(sc, "gtk_window_set_deletable", 2, setting, "gboolean");
  gtk_window_set_deletable((GtkWindow*)s7_c_pointer(window), (gboolean)lg_boolean(setting));
  return(lg_false);
}

static s7_pointer lg_gtk_window_get_deletable(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_window_get_deletable "gboolean gtk_window_get_deletable(GtkWindow* window)"
  s7_pointer window;
  window = s7_car(args);
  if (!s7_is_c_pointer_of_type(window, GtkWindow__sym)) s7_wrong_type_arg_error(sc, "gtk_window_get_deletable", 1, window, "GtkWindow*");
  return(s7_make_boolean(sc, gtk_window_get_deletable((GtkWindow*)s7_c_pointer(window))));
}

static s7_pointer lg_gtk_assistant_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_assistant_new "GtkWidget* gtk_assistant_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_assistant_new()));
}

static s7_pointer lg_gtk_assistant_get_current_page(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_assistant_get_current_page "gint gtk_assistant_get_current_page(GtkAssistant* assistant)"
  s7_pointer assistant;
  assistant = s7_car(args);
  if (!s7_is_c_pointer_of_type(assistant, GtkAssistant__sym)) s7_wrong_type_arg_error(sc, "gtk_assistant_get_current_page", 1, assistant, "GtkAssistant*");
  return(s7_make_integer(sc, gtk_assistant_get_current_page((GtkAssistant*)s7_c_pointer(assistant))));
}

static s7_pointer lg_gtk_assistant_set_current_page(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_assistant_set_current_page "void gtk_assistant_set_current_page(GtkAssistant* assistant, \
gint page_num)"
  s7_pointer _p;
  s7_pointer assistant, page_num;
  _p = args;
  assistant = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(assistant, GtkAssistant__sym)) s7_wrong_type_arg_error(sc, "gtk_assistant_set_current_page", 1, assistant, "GtkAssistant*");
  page_num = s7_car(_p);
  if (!s7_is_integer(page_num)) s7_wrong_type_arg_error(sc, "gtk_assistant_set_current_page", 2, page_num, "gint");
  gtk_assistant_set_current_page((GtkAssistant*)s7_c_pointer(assistant), (gint)s7_integer(page_num));
  return(lg_false);
}

static s7_pointer lg_gtk_assistant_get_n_pages(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_assistant_get_n_pages "gint gtk_assistant_get_n_pages(GtkAssistant* assistant)"
  s7_pointer assistant;
  assistant = s7_car(args);
  if (!s7_is_c_pointer_of_type(assistant, GtkAssistant__sym)) s7_wrong_type_arg_error(sc, "gtk_assistant_get_n_pages", 1, assistant, "GtkAssistant*");
  return(s7_make_integer(sc, gtk_assistant_get_n_pages((GtkAssistant*)s7_c_pointer(assistant))));
}

static s7_pointer lg_gtk_assistant_get_nth_page(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_assistant_get_nth_page "GtkWidget* gtk_assistant_get_nth_page(GtkAssistant* assistant, \
gint page_num)"
  s7_pointer _p;
  s7_pointer assistant, page_num;
  _p = args;
  assistant = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(assistant, GtkAssistant__sym)) s7_wrong_type_arg_error(sc, "gtk_assistant_get_nth_page", 1, assistant, "GtkAssistant*");
  page_num = s7_car(_p);
  if (!s7_is_integer(page_num)) s7_wrong_type_arg_error(sc, "gtk_assistant_get_nth_page", 2, page_num, "gint");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_assistant_get_nth_page((GtkAssistant*)s7_c_pointer(assistant), (gint)s7_integer(page_num))));
}

static s7_pointer lg_gtk_assistant_prepend_page(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_assistant_prepend_page "gint gtk_assistant_prepend_page(GtkAssistant* assistant, GtkWidget* page)"
  s7_pointer _p;
  s7_pointer assistant, page;
  _p = args;
  assistant = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(assistant, GtkAssistant__sym)) s7_wrong_type_arg_error(sc, "gtk_assistant_prepend_page", 1, assistant, "GtkAssistant*");
  page = s7_car(_p);
  if (!s7_is_c_pointer_of_type(page, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_assistant_prepend_page", 2, page, "GtkWidget*");
  return(s7_make_integer(sc, gtk_assistant_prepend_page((GtkAssistant*)s7_c_pointer(assistant), (GtkWidget*)s7_c_pointer(page))));
}

static s7_pointer lg_gtk_assistant_append_page(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_assistant_append_page "gint gtk_assistant_append_page(GtkAssistant* assistant, GtkWidget* page)"
  s7_pointer _p;
  s7_pointer assistant, page;
  _p = args;
  assistant = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(assistant, GtkAssistant__sym)) s7_wrong_type_arg_error(sc, "gtk_assistant_append_page", 1, assistant, "GtkAssistant*");
  page = s7_car(_p);
  if (!s7_is_c_pointer_of_type(page, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_assistant_append_page", 2, page, "GtkWidget*");
  return(s7_make_integer(sc, gtk_assistant_append_page((GtkAssistant*)s7_c_pointer(assistant), (GtkWidget*)s7_c_pointer(page))));
}

static s7_pointer lg_gtk_assistant_insert_page(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_assistant_insert_page "gint gtk_assistant_insert_page(GtkAssistant* assistant, GtkWidget* page, \
gint position)"
  s7_pointer _p;
  s7_pointer assistant, page, position;
  _p = args;
  assistant = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(assistant, GtkAssistant__sym)) s7_wrong_type_arg_error(sc, "gtk_assistant_insert_page", 1, assistant, "GtkAssistant*");
  page = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(page, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_assistant_insert_page", 2, page, "GtkWidget*");
  position = s7_car(_p);
  if (!s7_is_integer(position)) s7_wrong_type_arg_error(sc, "gtk_assistant_insert_page", 3, position, "gint");
  return(s7_make_integer(sc, gtk_assistant_insert_page((GtkAssistant*)s7_c_pointer(assistant), (GtkWidget*)s7_c_pointer(page), (gint)s7_integer(position))));
}

static s7_pointer lg_gtk_assistant_set_forward_page_func(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_assistant_set_forward_page_func "void gtk_assistant_set_forward_page_func(GtkAssistant* assistant, \
GtkAssistantPageFunc page_func, lambda_data func_info, GDestroyNotify destroy)"
  s7_pointer _p;
  s7_pointer assistant /* , page_func */ , func_info, destroy;
  _p = args;
  assistant = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(assistant, GtkAssistant__sym)) s7_wrong_type_arg_error(sc, "gtk_assistant_set_forward_page_func", 1, assistant, "GtkAssistant*");
  /* page_func = s7_car(_p); */ _p = s7_cdr(_p);
  func_info = s7_car(_p); _p = s7_cdr(_p);
  destroy = s7_car(_p);
  {
    s7_pointer lg_ptr = s7_list(sc, 5, lg_false, func_info, lg_false, lg_false, lg_false);
    s7_gc_protect(sc, lg_ptr);
    s7_list_set(sc, lg_ptr, 3, destroy);
    gtk_assistant_set_forward_page_func((GtkAssistant*)s7_c_pointer(assistant), lg_page_func, (gpointer)lg_ptr, lg_destroy_func);
    return(lg_false);
   }
}

static s7_pointer lg_gtk_assistant_set_page_type(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_assistant_set_page_type "void gtk_assistant_set_page_type(GtkAssistant* assistant, GtkWidget* page, \
GtkAssistantPageType type)"
  s7_pointer _p;
  s7_pointer assistant, page, type;
  _p = args;
  assistant = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(assistant, GtkAssistant__sym)) s7_wrong_type_arg_error(sc, "gtk_assistant_set_page_type", 1, assistant, "GtkAssistant*");
  page = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(page, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_assistant_set_page_type", 2, page, "GtkWidget*");
  type = s7_car(_p);
  if (!s7_is_integer(type)) s7_wrong_type_arg_error(sc, "gtk_assistant_set_page_type", 3, type, "GtkAssistantPageType");
  gtk_assistant_set_page_type((GtkAssistant*)s7_c_pointer(assistant), (GtkWidget*)s7_c_pointer(page), (GtkAssistantPageType)s7_integer(type));
  return(lg_false);
}

static s7_pointer lg_gtk_assistant_get_page_type(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_assistant_get_page_type "GtkAssistantPageType gtk_assistant_get_page_type(GtkAssistant* assistant, \
GtkWidget* page)"
  s7_pointer _p;
  s7_pointer assistant, page;
  _p = args;
  assistant = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(assistant, GtkAssistant__sym)) s7_wrong_type_arg_error(sc, "gtk_assistant_get_page_type", 1, assistant, "GtkAssistant*");
  page = s7_car(_p);
  if (!s7_is_c_pointer_of_type(page, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_assistant_get_page_type", 2, page, "GtkWidget*");
  return(s7_make_integer(sc, gtk_assistant_get_page_type((GtkAssistant*)s7_c_pointer(assistant), (GtkWidget*)s7_c_pointer(page))));
}

static s7_pointer lg_gtk_assistant_set_page_title(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_assistant_set_page_title "void gtk_assistant_set_page_title(GtkAssistant* assistant, \
GtkWidget* page, gchar* title)"
  s7_pointer _p;
  s7_pointer assistant, page, title;
  _p = args;
  assistant = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(assistant, GtkAssistant__sym)) s7_wrong_type_arg_error(sc, "gtk_assistant_set_page_title", 1, assistant, "GtkAssistant*");
  page = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(page, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_assistant_set_page_title", 2, page, "GtkWidget*");
  title = s7_car(_p);
  if (!s7_is_string(title)) s7_wrong_type_arg_error(sc, "gtk_assistant_set_page_title", 3, title, "gchar*");
  gtk_assistant_set_page_title((GtkAssistant*)s7_c_pointer(assistant), (GtkWidget*)s7_c_pointer(page), (gchar*)s7_string(title));
  return(lg_false);
}

static s7_pointer lg_gtk_assistant_get_page_title(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_assistant_get_page_title "gchar* gtk_assistant_get_page_title(GtkAssistant* assistant, \
GtkWidget* page)"
  s7_pointer _p;
  s7_pointer assistant, page;
  _p = args;
  assistant = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(assistant, GtkAssistant__sym)) s7_wrong_type_arg_error(sc, "gtk_assistant_get_page_title", 1, assistant, "GtkAssistant*");
  page = s7_car(_p);
  if (!s7_is_c_pointer_of_type(page, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_assistant_get_page_title", 2, page, "GtkWidget*");
  return(s7_make_string(sc, gtk_assistant_get_page_title((GtkAssistant*)s7_c_pointer(assistant), (GtkWidget*)s7_c_pointer(page))));
}

static s7_pointer lg_gtk_assistant_set_page_complete(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_assistant_set_page_complete "void gtk_assistant_set_page_complete(GtkAssistant* assistant, \
GtkWidget* page, gboolean complete)"
  s7_pointer _p;
  s7_pointer assistant, page, complete;
  _p = args;
  assistant = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(assistant, GtkAssistant__sym)) s7_wrong_type_arg_error(sc, "gtk_assistant_set_page_complete", 1, assistant, "GtkAssistant*");
  page = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(page, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_assistant_set_page_complete", 2, page, "GtkWidget*");
  complete = s7_car(_p);
  if (!s7_is_boolean(complete)) s7_wrong_type_arg_error(sc, "gtk_assistant_set_page_complete", 3, complete, "gboolean");
  gtk_assistant_set_page_complete((GtkAssistant*)s7_c_pointer(assistant), (GtkWidget*)s7_c_pointer(page), (gboolean)lg_boolean(complete));
  return(lg_false);
}

static s7_pointer lg_gtk_assistant_get_page_complete(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_assistant_get_page_complete "gboolean gtk_assistant_get_page_complete(GtkAssistant* assistant, \
GtkWidget* page)"
  s7_pointer _p;
  s7_pointer assistant, page;
  _p = args;
  assistant = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(assistant, GtkAssistant__sym)) s7_wrong_type_arg_error(sc, "gtk_assistant_get_page_complete", 1, assistant, "GtkAssistant*");
  page = s7_car(_p);
  if (!s7_is_c_pointer_of_type(page, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_assistant_get_page_complete", 2, page, "GtkWidget*");
  return(s7_make_boolean(sc, gtk_assistant_get_page_complete((GtkAssistant*)s7_c_pointer(assistant), (GtkWidget*)s7_c_pointer(page))));
}

static s7_pointer lg_gtk_assistant_add_action_widget(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_assistant_add_action_widget "void gtk_assistant_add_action_widget(GtkAssistant* assistant, \
GtkWidget* child)"
  s7_pointer _p;
  s7_pointer assistant, child;
  _p = args;
  assistant = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(assistant, GtkAssistant__sym)) s7_wrong_type_arg_error(sc, "gtk_assistant_add_action_widget", 1, assistant, "GtkAssistant*");
  child = s7_car(_p);
  if (!s7_is_c_pointer_of_type(child, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_assistant_add_action_widget", 2, child, "GtkWidget*");
  gtk_assistant_add_action_widget((GtkAssistant*)s7_c_pointer(assistant), (GtkWidget*)s7_c_pointer(child));
  return(lg_false);
}

static s7_pointer lg_gtk_assistant_remove_action_widget(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_assistant_remove_action_widget "void gtk_assistant_remove_action_widget(GtkAssistant* assistant, \
GtkWidget* child)"
  s7_pointer _p;
  s7_pointer assistant, child;
  _p = args;
  assistant = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(assistant, GtkAssistant__sym)) s7_wrong_type_arg_error(sc, "gtk_assistant_remove_action_widget", 1, assistant, "GtkAssistant*");
  child = s7_car(_p);
  if (!s7_is_c_pointer_of_type(child, GtkWidget__sym)) s7_wrong_type_arg_error(sc, "gtk_assistant_remove_action_widget", 2, child, "GtkWidget*");
  gtk_assistant_remove_action_widget((GtkAssistant*)s7_c_pointer(assistant), (GtkWidget*)s7_c_pointer(child));
  return(lg_false);
}

static s7_pointer lg_gtk_assistant_update_buttons_state(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_assistant_update_buttons_state "void gtk_assistant_update_buttons_state(GtkAssistant* assistant)"
  s7_pointer assistant;
  assistant = s7_car(args);
  if (!s7_is_c_pointer_of_type(assistant, GtkAssistant__sym)) s7_wrong_type_arg_error(sc, "gtk_assistant_update_buttons_state", 1, assistant, "GtkAssistant*");
  gtk_assistant_update_buttons_state((GtkAssistant*)s7_c_pointer(assistant));
  return(lg_false);
}

static s7_pointer lg_gtk_cell_renderer_accel_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_renderer_accel_new "GtkCellRenderer* gtk_cell_renderer_accel_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkCellRenderer__sym, gtk_cell_renderer_accel_new()));
}

static s7_pointer lg_gtk_cell_renderer_spin_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_cell_renderer_spin_new "GtkCellRenderer* gtk_cell_renderer_spin_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkCellRenderer__sym, gtk_cell_renderer_spin_new()));
}

static s7_pointer lg_gtk_link_button_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_link_button_new "GtkWidget* gtk_link_button_new(gchar* uri)"
  s7_pointer uri;
  uri = s7_car(args);
  if (!s7_is_string(uri)) s7_wrong_type_arg_error(sc, "gtk_link_button_new", 1, uri, "gchar*");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_link_button_new((gchar*)s7_string(uri))));
}

static s7_pointer lg_gtk_link_button_new_with_label(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_link_button_new_with_label "GtkWidget* gtk_link_button_new_with_label(gchar* uri, gchar* label)"
  s7_pointer _p;
  s7_pointer uri, label;
  _p = args;
  uri = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(uri)) s7_wrong_type_arg_error(sc, "gtk_link_button_new_with_label", 1, uri, "gchar*");
  label = s7_car(_p);
  if (!s7_is_string(label)) s7_wrong_type_arg_error(sc, "gtk_link_button_new_with_label", 2, label, "gchar*");
  return(lg_make_c_pointer_with_type(sc, GtkWidget__sym, gtk_link_button_new_with_label((gchar*)s7_string(uri), (gchar*)s7_string(label))));
}

static s7_pointer lg_gtk_link_button_get_uri(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_link_button_get_uri "gchar* gtk_link_button_get_uri(GtkLinkButton* link_button)"
  s7_pointer link_button;
  link_button = s7_car(args);
  if (!s7_is_c_pointer_of_type(link_button, GtkLinkButton__sym)) s7_wrong_type_arg_error(sc, "gtk_link_button_get_uri", 1, link_button, "GtkLinkButton*");
  return(s7_make_string(sc, gtk_link_button_get_uri((GtkLinkButton*)s7_c_pointer(link_button))));
}

static s7_pointer lg_gtk_link_button_set_uri(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_link_button_set_uri "void gtk_link_button_set_uri(GtkLinkButton* link_button, gchar* uri)"
  s7_pointer _p;
  s7_pointer link_button, uri;
  _p = args;
  link_button = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(link_button, GtkLinkButton__sym)) s7_wrong_type_arg_error(sc, "gtk_link_button_set_uri", 1, link_button, "GtkLinkButton*");
  uri = s7_car(_p);
  if (!s7_is_string(uri)) s7_wrong_type_arg_error(sc, "gtk_link_button_set_uri", 2, uri, "gchar*");
  gtk_link_button_set_uri((GtkLinkButton*)s7_c_pointer(link_button), (gchar*)s7_string(uri));
  return(lg_false);
}

static s7_pointer lg_gtk_recent_manager_error_quark(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_recent_manager_error_quark "GQuark gtk_recent_manager_error_quark( void)"
  return(s7_make_integer(sc, gtk_recent_manager_error_quark()));
}

static s7_pointer lg_gtk_recent_manager_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_recent_manager_new "GtkRecentManager* gtk_recent_manager_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkRecentManager__sym, gtk_recent_manager_new()));
}

static s7_pointer lg_gtk_recent_manager_get_default(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_recent_manager_get_default "GtkRecentManager* gtk_recent_manager_get_default( void)"
  return(lg_make_c_pointer_with_type(sc, GtkRecentManager__sym, gtk_recent_manager_get_default()));
}

static s7_pointer lg_gtk_recent_manager_remove_item(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_recent_manager_remove_item "gboolean gtk_recent_manager_remove_item(GtkRecentManager* manager, \
gchar* uri, GError** [error])"
  s7_pointer _p;
  s7_pointer manager, uri;
  GError* ref_error = NULL;
  _p = args;
  manager = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(manager, GtkRecentManager__sym)) s7_wrong_type_arg_error(sc, "gtk_recent_manager_remove_item", 1, manager, "GtkRecentManager*");
  uri = s7_car(_p);
  if (!s7_is_string(uri)) s7_wrong_type_arg_error(sc, "gtk_recent_manager_remove_item", 2, uri, "gchar*");
  {
    s7_pointer res_ult;
    res_ult = s7_make_boolean(sc, gtk_recent_manager_remove_item((GtkRecentManager*)s7_c_pointer(manager), (gchar*)s7_string(uri), &ref_error));
      return(s7_list(sc, 2, res_ult, s7_make_c_pointer(sc, ref_error)));
   }
}

static s7_pointer lg_gtk_recent_manager_lookup_item(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_recent_manager_lookup_item "GtkRecentInfo* gtk_recent_manager_lookup_item(GtkRecentManager* manager, \
gchar* uri, GError** [error])"
  s7_pointer _p;
  s7_pointer manager, uri;
  GError* ref_error = NULL;
  _p = args;
  manager = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(manager, GtkRecentManager__sym)) s7_wrong_type_arg_error(sc, "gtk_recent_manager_lookup_item", 1, manager, "GtkRecentManager*");
  uri = s7_car(_p);
  if (!s7_is_string(uri)) s7_wrong_type_arg_error(sc, "gtk_recent_manager_lookup_item", 2, uri, "gchar*");
  {
    s7_pointer res_ult;
    res_ult = lg_make_c_pointer_with_type(sc, GtkRecentInfo__sym, gtk_recent_manager_lookup_item((GtkRecentManager*)s7_c_pointer(manager), (gchar*)s7_string(uri), &ref_error));
      return(s7_list(sc, 2, res_ult, s7_make_c_pointer(sc, ref_error)));
   }
}

static s7_pointer lg_gtk_recent_manager_has_item(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_recent_manager_has_item "gboolean gtk_recent_manager_has_item(GtkRecentManager* manager, \
gchar* uri)"
  s7_pointer _p;
  s7_pointer manager, uri;
  _p = args;
  manager = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(manager, GtkRecentManager__sym)) s7_wrong_type_arg_error(sc, "gtk_recent_manager_has_item", 1, manager, "GtkRecentManager*");
  uri = s7_car(_p);
  if (!s7_is_string(uri)) s7_wrong_type_arg_error(sc, "gtk_recent_manager_has_item", 2, uri, "gchar*");
  return(s7_make_boolean(sc, gtk_recent_manager_has_item((GtkRecentManager*)s7_c_pointer(manager), (gchar*)s7_string(uri))));
}

static s7_pointer lg_gtk_recent_manager_move_item(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_recent_manager_move_item "gboolean gtk_recent_manager_move_item(GtkRecentManager* manager, \
gchar* uri, gchar* new_uri, GError** [error])"
  s7_pointer _p;
  s7_pointer manager, uri, new_uri;
  GError* ref_error = NULL;
  _p = args;
  manager = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(manager, GtkRecentManager__sym)) s7_wrong_type_arg_error(sc, "gtk_recent_manager_move_item", 1, manager, "GtkRecentManager*");
  uri = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(uri)) s7_wrong_type_arg_error(sc, "gtk_recent_manager_move_item", 2, uri, "gchar*");
  new_uri = s7_car(_p);
  if (!s7_is_string(new_uri)) s7_wrong_type_arg_error(sc, "gtk_recent_manager_move_item", 3, new_uri, "gchar*");
  {
    s7_pointer res_ult;
    res_ult = s7_make_boolean(sc, gtk_recent_manager_move_item((GtkRecentManager*)s7_c_pointer(manager), (gchar*)s7_string(uri), (gchar*)s7_string(new_uri), &ref_error));
      return(s7_list(sc, 2, res_ult, s7_make_c_pointer(sc, ref_error)));
   }
}

static s7_pointer lg_gtk_recent_manager_get_items(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_recent_manager_get_items "GList* gtk_recent_manager_get_items(GtkRecentManager* manager)"
  s7_pointer manager;
  manager = s7_car(args);
  if (!s7_is_c_pointer_of_type(manager, GtkRecentManager__sym)) s7_wrong_type_arg_error(sc, "gtk_recent_manager_get_items", 1, manager, "GtkRecentManager*");
  return(lg_make_c_pointer_with_type(sc, GList__sym, gtk_recent_manager_get_items((GtkRecentManager*)s7_c_pointer(manager))));
}

static s7_pointer lg_gtk_recent_manager_purge_items(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_recent_manager_purge_items "gint gtk_recent_manager_purge_items(GtkRecentManager* manager, \
GError** [error])"
  s7_pointer _p;
  s7_pointer manager;
  GError* ref_error = NULL;
  _p = args;
  manager = s7_car(_p);
  if (!s7_is_c_pointer_of_type(manager, GtkRecentManager__sym)) s7_wrong_type_arg_error(sc, "gtk_recent_manager_purge_items", 1, manager, "GtkRecentManager*");
  {
    s7_pointer res_ult;
    res_ult = s7_make_integer(sc, gtk_recent_manager_purge_items((GtkRecentManager*)s7_c_pointer(manager), &ref_error));
      return(s7_list(sc, 2, res_ult, s7_make_c_pointer(sc, ref_error)));
   }
}

static s7_pointer lg_gtk_recent_info_ref(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_recent_info_ref "GtkRecentInfo* gtk_recent_info_ref(GtkRecentInfo* info)"
  s7_pointer info;
  info = s7_car(args);
  if (!s7_is_c_pointer_of_type(info, GtkRecentInfo__sym)) s7_wrong_type_arg_error(sc, "gtk_recent_info_ref", 1, info, "GtkRecentInfo*");
  return(lg_make_c_pointer_with_type(sc, GtkRecentInfo__sym, gtk_recent_info_ref((GtkRecentInfo*)s7_c_pointer(info))));
}

static s7_pointer lg_gtk_recent_info_unref(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_recent_info_unref "void gtk_recent_info_unref(GtkRecentInfo* info)"
  s7_pointer info;
  info = s7_car(args);
  if (!s7_is_c_pointer_of_type(info, GtkRecentInfo__sym)) s7_wrong_type_arg_error(sc, "gtk_recent_info_unref", 1, info, "GtkRecentInfo*");
  gtk_recent_info_unref((GtkRecentInfo*)s7_c_pointer(info));
  return(lg_false);
}

static s7_pointer lg_gtk_recent_info_get_uri(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_recent_info_get_uri "gchar* gtk_recent_info_get_uri(GtkRecentInfo* info)"
  s7_pointer info;
  info = s7_car(args);
  if (!s7_is_c_pointer_of_type(info, GtkRecentInfo__sym)) s7_wrong_type_arg_error(sc, "gtk_recent_info_get_uri", 1, info, "GtkRecentInfo*");
  return(s7_make_string(sc, gtk_recent_info_get_uri((GtkRecentInfo*)s7_c_pointer(info))));
}

static s7_pointer lg_gtk_recent_info_get_display_name(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_recent_info_get_display_name "gchar* gtk_recent_info_get_display_name(GtkRecentInfo* info)"
  s7_pointer info;
  info = s7_car(args);
  if (!s7_is_c_pointer_of_type(info, GtkRecentInfo__sym)) s7_wrong_type_arg_error(sc, "gtk_recent_info_get_display_name", 1, info, "GtkRecentInfo*");
    return(s7_make_string(sc, (gchar*)gtk_recent_info_get_display_name((GtkRecentInfo*)s7_c_pointer(info))));
}

static s7_pointer lg_gtk_recent_info_get_description(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_recent_info_get_description "gchar* gtk_recent_info_get_description(GtkRecentInfo* info)"
  s7_pointer info;
  info = s7_car(args);
  if (!s7_is_c_pointer_of_type(info, GtkRecentInfo__sym)) s7_wrong_type_arg_error(sc, "gtk_recent_info_get_description", 1, info, "GtkRecentInfo*");
    return(s7_make_string(sc, (gchar*)gtk_recent_info_get_description((GtkRecentInfo*)s7_c_pointer(info))));
}

static s7_pointer lg_gtk_recent_info_get_mime_type(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_recent_info_get_mime_type "gchar* gtk_recent_info_get_mime_type(GtkRecentInfo* info)"
  s7_pointer info;
  info = s7_car(args);
  if (!s7_is_c_pointer_of_type(info, GtkRecentInfo__sym)) s7_wrong_type_arg_error(sc, "gtk_recent_info_get_mime_type", 1, info, "GtkRecentInfo*");
    return(s7_make_string(sc, (gchar*)gtk_recent_info_get_mime_type((GtkRecentInfo*)s7_c_pointer(info))));
}

static s7_pointer lg_gtk_recent_info_get_added(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_recent_info_get_added "time_t gtk_recent_info_get_added(GtkRecentInfo* info)"
  s7_pointer info;
  info = s7_car(args);
  if (!s7_is_c_pointer_of_type(info, GtkRecentInfo__sym)) s7_wrong_type_arg_error(sc, "gtk_recent_info_get_added", 1, info, "GtkRecentInfo*");
  return(s7_make_integer(sc, gtk_recent_info_get_added((GtkRecentInfo*)s7_c_pointer(info))));
}

static s7_pointer lg_gtk_recent_info_get_modified(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_recent_info_get_modified "time_t gtk_recent_info_get_modified(GtkRecentInfo* info)"
  s7_pointer info;
  info = s7_car(args);
  if (!s7_is_c_pointer_of_type(info, GtkRecentInfo__sym)) s7_wrong_type_arg_error(sc, "gtk_recent_info_get_modified", 1, info, "GtkRecentInfo*");
  return(s7_make_integer(sc, gtk_recent_info_get_modified((GtkRecentInfo*)s7_c_pointer(info))));
}

static s7_pointer lg_gtk_recent_info_get_visited(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_recent_info_get_visited "time_t gtk_recent_info_get_visited(GtkRecentInfo* info)"
  s7_pointer info;
  info = s7_car(args);
  if (!s7_is_c_pointer_of_type(info, GtkRecentInfo__sym)) s7_wrong_type_arg_error(sc, "gtk_recent_info_get_visited", 1, info, "GtkRecentInfo*");
  return(s7_make_integer(sc, gtk_recent_info_get_visited((GtkRecentInfo*)s7_c_pointer(info))));
}

static s7_pointer lg_gtk_recent_info_get_private_hint(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_recent_info_get_private_hint "gboolean gtk_recent_info_get_private_hint(GtkRecentInfo* info)"
  s7_pointer info;
  info = s7_car(args);
  if (!s7_is_c_pointer_of_type(info, GtkRecentInfo__sym)) s7_wrong_type_arg_error(sc, "gtk_recent_info_get_private_hint", 1, info, "GtkRecentInfo*");
  return(s7_make_boolean(sc, gtk_recent_info_get_private_hint((GtkRecentInfo*)s7_c_pointer(info))));
}

static s7_pointer lg_gtk_recent_info_get_applications(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_recent_info_get_applications "gchar** gtk_recent_info_get_applications(GtkRecentInfo* info, \
gsize* [length])"
  s7_pointer _p;
  s7_pointer info;
  gsize ref_length;
  _p = args;
  info = s7_car(_p);
  if (!s7_is_c_pointer_of_type(info, GtkRecentInfo__sym)) s7_wrong_type_arg_error(sc, "gtk_recent_info_get_applications", 1, info, "GtkRecentInfo*");
  {
    s7_pointer res_ult;
    res_ult = lg_make_c_pointer_with_type(sc, gchar___sym, gtk_recent_info_get_applications((GtkRecentInfo*)s7_c_pointer(info), &ref_length));
      return(s7_list(sc, 2, res_ult, s7_make_integer(sc, ref_length)));
   }
}

static s7_pointer lg_gtk_recent_info_last_application(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_recent_info_last_application "gchar* gtk_recent_info_last_application(GtkRecentInfo* info)"
  s7_pointer info;
  info = s7_car(args);
  if (!s7_is_c_pointer_of_type(info, GtkRecentInfo__sym)) s7_wrong_type_arg_error(sc, "gtk_recent_info_last_application", 1, info, "GtkRecentInfo*");
  return(s7_make_string(sc, gtk_recent_info_last_application((GtkRecentInfo*)s7_c_pointer(info))));
}

static s7_pointer lg_gtk_recent_info_has_application(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_recent_info_has_application "gboolean gtk_recent_info_has_application(GtkRecentInfo* info, \
gchar* app_name)"
  s7_pointer _p;
  s7_pointer info, app_name;
  _p = args;
  info = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(info, GtkRecentInfo__sym)) s7_wrong_type_arg_error(sc, "gtk_recent_info_has_application", 1, info, "GtkRecentInfo*");
  app_name = s7_car(_p);
  if (!s7_is_string(app_name)) s7_wrong_type_arg_error(sc, "gtk_recent_info_has_application", 2, app_name, "gchar*");
  return(s7_make_boolean(sc, gtk_recent_info_has_application((GtkRecentInfo*)s7_c_pointer(info), (gchar*)s7_string(app_name))));
}

static s7_pointer lg_gtk_recent_info_get_groups(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_recent_info_get_groups "gchar** gtk_recent_info_get_groups(GtkRecentInfo* info, gsize* [length])"
  s7_pointer _p;
  s7_pointer info;
  gsize ref_length;
  _p = args;
  info = s7_car(_p);
  if (!s7_is_c_pointer_of_type(info, GtkRecentInfo__sym)) s7_wrong_type_arg_error(sc, "gtk_recent_info_get_groups", 1, info, "GtkRecentInfo*");
  {
    s7_pointer res_ult;
    res_ult = lg_make_c_pointer_with_type(sc, gchar___sym, gtk_recent_info_get_groups((GtkRecentInfo*)s7_c_pointer(info), &ref_length));
      return(s7_list(sc, 2, res_ult, s7_make_integer(sc, ref_length)));
   }
}

static s7_pointer lg_gtk_recent_info_has_group(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_recent_info_has_group "gboolean gtk_recent_info_has_group(GtkRecentInfo* info, gchar* group_name)"
  s7_pointer _p;
  s7_pointer info, group_name;
  _p = args;
  info = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(info, GtkRecentInfo__sym)) s7_wrong_type_arg_error(sc, "gtk_recent_info_has_group", 1, info, "GtkRecentInfo*");
  group_name = s7_car(_p);
  if (!s7_is_string(group_name)) s7_wrong_type_arg_error(sc, "gtk_recent_info_has_group", 2, group_name, "gchar*");
  return(s7_make_boolean(sc, gtk_recent_info_has_group((GtkRecentInfo*)s7_c_pointer(info), (gchar*)s7_string(group_name))));
}

static s7_pointer lg_gtk_recent_info_get_short_name(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_recent_info_get_short_name "gchar* gtk_recent_info_get_short_name(GtkRecentInfo* info)"
  s7_pointer info;
  info = s7_car(args);
  if (!s7_is_c_pointer_of_type(info, GtkRecentInfo__sym)) s7_wrong_type_arg_error(sc, "gtk_recent_info_get_short_name", 1, info, "GtkRecentInfo*");
  return(s7_make_string(sc, gtk_recent_info_get_short_name((GtkRecentInfo*)s7_c_pointer(info))));
}

static s7_pointer lg_gtk_recent_info_get_uri_display(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_recent_info_get_uri_display "gchar* gtk_recent_info_get_uri_display(GtkRecentInfo* info)"
  s7_pointer info;
  info = s7_car(args);
  if (!s7_is_c_pointer_of_type(info, GtkRecentInfo__sym)) s7_wrong_type_arg_error(sc, "gtk_recent_info_get_uri_display", 1, info, "GtkRecentInfo*");
  return(s7_make_string(sc, gtk_recent_info_get_uri_display((GtkRecentInfo*)s7_c_pointer(info))));
}

static s7_pointer lg_gtk_recent_info_get_age(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_recent_info_get_age "gint gtk_recent_info_get_age(GtkRecentInfo* info)"
  s7_pointer info;
  info = s7_car(args);
  if (!s7_is_c_pointer_of_type(info, GtkRecentInfo__sym)) s7_wrong_type_arg_error(sc, "gtk_recent_info_get_age", 1, info, "GtkRecentInfo*");
  return(s7_make_integer(sc, gtk_recent_info_get_age((GtkRecentInfo*)s7_c_pointer(info))));
}

static s7_pointer lg_gtk_recent_info_is_local(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_recent_info_is_local "gboolean gtk_recent_info_is_local(GtkRecentInfo* info)"
  s7_pointer info;
  info = s7_car(args);
  if (!s7_is_c_pointer_of_type(info, GtkRecentInfo__sym)) s7_wrong_type_arg_error(sc, "gtk_recent_info_is_local", 1, info, "GtkRecentInfo*");
  return(s7_make_boolean(sc, gtk_recent_info_is_local((GtkRecentInfo*)s7_c_pointer(info))));
}

static s7_pointer lg_gtk_recent_info_exists(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_recent_info_exists "gboolean gtk_recent_info_exists(GtkRecentInfo* info)"
  s7_pointer info;
  info = s7_car(args);
  if (!s7_is_c_pointer_of_type(info, GtkRecentInfo__sym)) s7_wrong_type_arg_error(sc, "gtk_recent_info_exists", 1, info, "GtkRecentInfo*");
  return(s7_make_boolean(sc, gtk_recent_info_exists((GtkRecentInfo*)s7_c_pointer(info))));
}

static s7_pointer lg_gtk_recent_info_match(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_recent_info_match "gboolean gtk_recent_info_match(GtkRecentInfo* info_a, GtkRecentInfo* info_b)"
  s7_pointer _p;
  s7_pointer info_a, info_b;
  _p = args;
  info_a = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(info_a, GtkRecentInfo__sym)) s7_wrong_type_arg_error(sc, "gtk_recent_info_match", 1, info_a, "GtkRecentInfo*");
  info_b = s7_car(_p);
  if (!s7_is_c_pointer_of_type(info_b, GtkRecentInfo__sym)) s7_wrong_type_arg_error(sc, "gtk_recent_info_match", 2, info_b, "GtkRecentInfo*");
  return(s7_make_boolean(sc, gtk_recent_info_match((GtkRecentInfo*)s7_c_pointer(info_a), (GtkRecentInfo*)s7_c_pointer(info_b))));
}

static s7_pointer lg_gtk_recent_manager_add_item(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_recent_manager_add_item "gboolean gtk_recent_manager_add_item(GtkRecentManager* manager, \
gchar* uri)"
  s7_pointer _p;
  s7_pointer manager, uri;
  _p = args;
  manager = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(manager, GtkRecentManager__sym)) s7_wrong_type_arg_error(sc, "gtk_recent_manager_add_item", 1, manager, "GtkRecentManager*");
  uri = s7_car(_p);
  if (!s7_is_string(uri)) s7_wrong_type_arg_error(sc, "gtk_recent_manager_add_item", 2, uri, "gchar*");
  return(s7_make_boolean(sc, gtk_recent_manager_add_item((GtkRecentManager*)s7_c_pointer(manager), (gchar*)s7_string(uri))));
}

static s7_pointer lg_gtk_recent_manager_add_full(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_recent_manager_add_full "gboolean gtk_recent_manager_add_full(GtkRecentManager* manager, \
gchar* uri, GtkRecentData* recent_data)"
  s7_pointer _p;
  s7_pointer manager, uri, recent_data;
  _p = args;
  manager = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(manager, GtkRecentManager__sym)) s7_wrong_type_arg_error(sc, "gtk_recent_manager_add_full", 1, manager, "GtkRecentManager*");
  uri = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_string(uri)) s7_wrong_type_arg_error(sc, "gtk_recent_manager_add_full", 2, uri, "gchar*");
  recent_data = s7_car(_p);
  if (!s7_is_c_pointer_of_type(recent_data, GtkRecentData__sym)) s7_wrong_type_arg_error(sc, "gtk_recent_manager_add_full", 3, recent_data, "GtkRecentData*");
  return(s7_make_boolean(sc, gtk_recent_manager_add_full((GtkRecentManager*)s7_c_pointer(manager), (gchar*)s7_string(uri), (GtkRecentData*)s7_c_pointer(recent_data))));
}

static s7_pointer lg_gtk_tree_model_filter_convert_child_iter_to_iter(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_model_filter_convert_child_iter_to_iter "gboolean gtk_tree_model_filter_convert_child_iter_to_iter(GtkTreeModelFilter* filter, \
GtkTreeIter* filter_iter, GtkTreeIter* child_iter)"
  s7_pointer _p;
  s7_pointer filter, filter_iter, child_iter;
  _p = args;
  filter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(filter, GtkTreeModelFilter__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_filter_convert_child_iter_to_iter", 1, filter, "GtkTreeModelFilter*");
  filter_iter = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(filter_iter, GtkTreeIter__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_filter_convert_child_iter_to_iter", 2, filter_iter, "GtkTreeIter*");
  child_iter = s7_car(_p);
  if (!s7_is_c_pointer_of_type(child_iter, GtkTreeIter__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_model_filter_convert_child_iter_to_iter", 3, child_iter, "GtkTreeIter*");
  return(s7_make_boolean(sc, gtk_tree_model_filter_convert_child_iter_to_iter((GtkTreeModelFilter*)s7_c_pointer(filter), (GtkTreeIter*)s7_c_pointer(filter_iter), (GtkTreeIter*)s7_c_pointer(child_iter))));
}

static s7_pointer lg_gtk_tree_view_get_grid_lines(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_get_grid_lines "GtkTreeViewGridLines gtk_tree_view_get_grid_lines(GtkTreeView* tree_view)"
  s7_pointer tree_view;
  tree_view = s7_car(args);
  if (!s7_is_c_pointer_of_type(tree_view, GtkTreeView__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_get_grid_lines", 1, tree_view, "GtkTreeView*");
  return(s7_make_integer(sc, gtk_tree_view_get_grid_lines((GtkTreeView*)s7_c_pointer(tree_view))));
}

static s7_pointer lg_gtk_tree_view_set_grid_lines(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_set_grid_lines "void gtk_tree_view_set_grid_lines(GtkTreeView* tree_view, GtkTreeViewGridLines grid_lines)"
  s7_pointer _p;
  s7_pointer tree_view, grid_lines;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_view, GtkTreeView__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_set_grid_lines", 1, tree_view, "GtkTreeView*");
  grid_lines = s7_car(_p);
  if (!s7_is_integer(grid_lines)) s7_wrong_type_arg_error(sc, "gtk_tree_view_set_grid_lines", 2, grid_lines, "GtkTreeViewGridLines");
  gtk_tree_view_set_grid_lines((GtkTreeView*)s7_c_pointer(tree_view), (GtkTreeViewGridLines)s7_integer(grid_lines));
  return(lg_false);
}

static s7_pointer lg_gtk_tree_view_get_enable_tree_lines(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_get_enable_tree_lines "gboolean gtk_tree_view_get_enable_tree_lines(GtkTreeView* tree_view)"
  s7_pointer tree_view;
  tree_view = s7_car(args);
  if (!s7_is_c_pointer_of_type(tree_view, GtkTreeView__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_get_enable_tree_lines", 1, tree_view, "GtkTreeView*");
  return(s7_make_boolean(sc, gtk_tree_view_get_enable_tree_lines((GtkTreeView*)s7_c_pointer(tree_view))));
}

static s7_pointer lg_gtk_tree_view_set_enable_tree_lines(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_tree_view_set_enable_tree_lines "void gtk_tree_view_set_enable_tree_lines(GtkTreeView* tree_view, \
gboolean enabled)"
  s7_pointer _p;
  s7_pointer tree_view, enabled;
  _p = args;
  tree_view = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(tree_view, GtkTreeView__sym)) s7_wrong_type_arg_error(sc, "gtk_tree_view_set_enable_tree_lines", 1, tree_view, "GtkTreeView*");
  enabled = s7_car(_p);
  if (!s7_is_boolean(enabled)) s7_wrong_type_arg_error(sc, "gtk_tree_view_set_enable_tree_lines", 2, enabled, "gboolean");
  gtk_tree_view_set_enable_tree_lines((GtkTreeView*)s7_c_pointer(tree_view), (gboolean)lg_boolean(enabled));
  return(lg_false);
}

static s7_pointer lg_gtk_print_context_get_cairo_context(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_context_get_cairo_context "cairo_t* gtk_print_context_get_cairo_context(GtkPrintContext* context)"
  s7_pointer context;
  context = s7_car(args);
  if (!s7_is_c_pointer_of_type(context, GtkPrintContext__sym)) s7_wrong_type_arg_error(sc, "gtk_print_context_get_cairo_context", 1, context, "GtkPrintContext*");
  return(lg_make_c_pointer_with_type(sc, cairo_t__sym, gtk_print_context_get_cairo_context((GtkPrintContext*)s7_c_pointer(context))));
}

static s7_pointer lg_gtk_print_context_get_page_setup(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_context_get_page_setup "GtkPageSetup* gtk_print_context_get_page_setup(GtkPrintContext* context)"
  s7_pointer context;
  context = s7_car(args);
  if (!s7_is_c_pointer_of_type(context, GtkPrintContext__sym)) s7_wrong_type_arg_error(sc, "gtk_print_context_get_page_setup", 1, context, "GtkPrintContext*");
  return(lg_make_c_pointer_with_type(sc, GtkPageSetup__sym, gtk_print_context_get_page_setup((GtkPrintContext*)s7_c_pointer(context))));
}

static s7_pointer lg_gtk_print_context_get_width(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_context_get_width "gdouble gtk_print_context_get_width(GtkPrintContext* context)"
  s7_pointer context;
  context = s7_car(args);
  if (!s7_is_c_pointer_of_type(context, GtkPrintContext__sym)) s7_wrong_type_arg_error(sc, "gtk_print_context_get_width", 1, context, "GtkPrintContext*");
  return(s7_make_real(sc, gtk_print_context_get_width((GtkPrintContext*)s7_c_pointer(context))));
}

static s7_pointer lg_gtk_print_context_get_height(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_context_get_height "gdouble gtk_print_context_get_height(GtkPrintContext* context)"
  s7_pointer context;
  context = s7_car(args);
  if (!s7_is_c_pointer_of_type(context, GtkPrintContext__sym)) s7_wrong_type_arg_error(sc, "gtk_print_context_get_height", 1, context, "GtkPrintContext*");
  return(s7_make_real(sc, gtk_print_context_get_height((GtkPrintContext*)s7_c_pointer(context))));
}

static s7_pointer lg_gtk_print_context_get_dpi_x(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_context_get_dpi_x "gdouble gtk_print_context_get_dpi_x(GtkPrintContext* context)"
  s7_pointer context;
  context = s7_car(args);
  if (!s7_is_c_pointer_of_type(context, GtkPrintContext__sym)) s7_wrong_type_arg_error(sc, "gtk_print_context_get_dpi_x", 1, context, "GtkPrintContext*");
  return(s7_make_real(sc, gtk_print_context_get_dpi_x((GtkPrintContext*)s7_c_pointer(context))));
}

static s7_pointer lg_gtk_print_context_get_dpi_y(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_context_get_dpi_y "gdouble gtk_print_context_get_dpi_y(GtkPrintContext* context)"
  s7_pointer context;
  context = s7_car(args);
  if (!s7_is_c_pointer_of_type(context, GtkPrintContext__sym)) s7_wrong_type_arg_error(sc, "gtk_print_context_get_dpi_y", 1, context, "GtkPrintContext*");
  return(s7_make_real(sc, gtk_print_context_get_dpi_y((GtkPrintContext*)s7_c_pointer(context))));
}

static s7_pointer lg_gtk_print_context_create_pango_context(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_context_create_pango_context "PangoContext* gtk_print_context_create_pango_context(GtkPrintContext* context)"
  s7_pointer context;
  context = s7_car(args);
  if (!s7_is_c_pointer_of_type(context, GtkPrintContext__sym)) s7_wrong_type_arg_error(sc, "gtk_print_context_create_pango_context", 1, context, "GtkPrintContext*");
  return(lg_make_c_pointer_with_type(sc, PangoContext__sym, gtk_print_context_create_pango_context((GtkPrintContext*)s7_c_pointer(context))));
}

static s7_pointer lg_gtk_print_context_create_pango_layout(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_context_create_pango_layout "PangoLayout* gtk_print_context_create_pango_layout(GtkPrintContext* context)"
  s7_pointer context;
  context = s7_car(args);
  if (!s7_is_c_pointer_of_type(context, GtkPrintContext__sym)) s7_wrong_type_arg_error(sc, "gtk_print_context_create_pango_layout", 1, context, "GtkPrintContext*");
  return(lg_make_c_pointer_with_type(sc, PangoLayout__sym, gtk_print_context_create_pango_layout((GtkPrintContext*)s7_c_pointer(context))));
}

static s7_pointer lg_gtk_print_context_set_cairo_context(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_context_set_cairo_context "void gtk_print_context_set_cairo_context(GtkPrintContext* context, \
cairo_t* cr, double dpi_x, double dpi_y)"
  s7_pointer _p;
  s7_pointer context, cr, dpi_x, dpi_y;
  _p = args;
  context = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(context, GtkPrintContext__sym)) s7_wrong_type_arg_error(sc, "gtk_print_context_set_cairo_context", 1, context, "GtkPrintContext*");
  cr = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(cr, cairo_t__sym)) s7_wrong_type_arg_error(sc, "gtk_print_context_set_cairo_context", 2, cr, "cairo_t*");
  dpi_x = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_real(dpi_x)) s7_wrong_type_arg_error(sc, "gtk_print_context_set_cairo_context", 3, dpi_x, "double");
  dpi_y = s7_car(_p);
  if (!s7_is_real(dpi_y)) s7_wrong_type_arg_error(sc, "gtk_print_context_set_cairo_context", 4, dpi_y, "double");
  gtk_print_context_set_cairo_context((GtkPrintContext*)s7_c_pointer(context), (cairo_t*)s7_c_pointer(cr), (double)s7_real(dpi_x), (double)s7_real(dpi_y));
  return(lg_false);
}

static s7_pointer lg_gtk_print_operation_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_operation_new "GtkPrintOperation* gtk_print_operation_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkPrintOperation__sym, gtk_print_operation_new()));
}

static s7_pointer lg_gtk_print_operation_set_default_page_setup(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_operation_set_default_page_setup "void gtk_print_operation_set_default_page_setup(GtkPrintOperation* op, \
GtkPageSetup* default_page_setup)"
  s7_pointer _p;
  s7_pointer op, default_page_setup;
  _p = args;
  op = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(op, GtkPrintOperation__sym)) s7_wrong_type_arg_error(sc, "gtk_print_operation_set_default_page_setup", 1, op, "GtkPrintOperation*");
  default_page_setup = s7_car(_p);
  if (!s7_is_c_pointer_of_type(default_page_setup, GtkPageSetup__sym)) s7_wrong_type_arg_error(sc, "gtk_print_operation_set_default_page_setup", 2, default_page_setup, "GtkPageSetup*");
  gtk_print_operation_set_default_page_setup((GtkPrintOperation*)s7_c_pointer(op), (GtkPageSetup*)s7_c_pointer(default_page_setup));
  return(lg_false);
}

static s7_pointer lg_gtk_print_operation_get_default_page_setup(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_operation_get_default_page_setup "GtkPageSetup* gtk_print_operation_get_default_page_setup(GtkPrintOperation* op)"
  s7_pointer op;
  op = s7_car(args);
  if (!s7_is_c_pointer_of_type(op, GtkPrintOperation__sym)) s7_wrong_type_arg_error(sc, "gtk_print_operation_get_default_page_setup", 1, op, "GtkPrintOperation*");
  return(lg_make_c_pointer_with_type(sc, GtkPageSetup__sym, gtk_print_operation_get_default_page_setup((GtkPrintOperation*)s7_c_pointer(op))));
}

static s7_pointer lg_gtk_print_operation_set_print_settings(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_operation_set_print_settings "void gtk_print_operation_set_print_settings(GtkPrintOperation* op, \
GtkPrintSettings* print_settings)"
  s7_pointer _p;
  s7_pointer op, print_settings;
  _p = args;
  op = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(op, GtkPrintOperation__sym)) s7_wrong_type_arg_error(sc, "gtk_print_operation_set_print_settings", 1, op, "GtkPrintOperation*");
  print_settings = s7_car(_p);
  if (!s7_is_c_pointer_of_type(print_settings, GtkPrintSettings__sym)) s7_wrong_type_arg_error(sc, "gtk_print_operation_set_print_settings", 2, print_settings, "GtkPrintSettings*");
  gtk_print_operation_set_print_settings((GtkPrintOperation*)s7_c_pointer(op), (GtkPrintSettings*)s7_c_pointer(print_settings));
  return(lg_false);
}

static s7_pointer lg_gtk_print_operation_get_print_settings(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_operation_get_print_settings "GtkPrintSettings* gtk_print_operation_get_print_settings(GtkPrintOperation* op)"
  s7_pointer op;
  op = s7_car(args);
  if (!s7_is_c_pointer_of_type(op, GtkPrintOperation__sym)) s7_wrong_type_arg_error(sc, "gtk_print_operation_get_print_settings", 1, op, "GtkPrintOperation*");
  return(lg_make_c_pointer_with_type(sc, GtkPrintSettings__sym, gtk_print_operation_get_print_settings((GtkPrintOperation*)s7_c_pointer(op))));
}

static s7_pointer lg_gtk_print_operation_set_job_name(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_operation_set_job_name "void gtk_print_operation_set_job_name(GtkPrintOperation* op, \
gchar* job_name)"
  s7_pointer _p;
  s7_pointer op, job_name;
  _p = args;
  op = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(op, GtkPrintOperation__sym)) s7_wrong_type_arg_error(sc, "gtk_print_operation_set_job_name", 1, op, "GtkPrintOperation*");
  job_name = s7_car(_p);
  if (!s7_is_string(job_name)) s7_wrong_type_arg_error(sc, "gtk_print_operation_set_job_name", 2, job_name, "gchar*");
  gtk_print_operation_set_job_name((GtkPrintOperation*)s7_c_pointer(op), (gchar*)s7_string(job_name));
  return(lg_false);
}

static s7_pointer lg_gtk_print_operation_set_n_pages(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_operation_set_n_pages "void gtk_print_operation_set_n_pages(GtkPrintOperation* op, \
gint n_pages)"
  s7_pointer _p;
  s7_pointer op, n_pages;
  _p = args;
  op = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(op, GtkPrintOperation__sym)) s7_wrong_type_arg_error(sc, "gtk_print_operation_set_n_pages", 1, op, "GtkPrintOperation*");
  n_pages = s7_car(_p);
  if (!s7_is_integer(n_pages)) s7_wrong_type_arg_error(sc, "gtk_print_operation_set_n_pages", 2, n_pages, "gint");
  gtk_print_operation_set_n_pages((GtkPrintOperation*)s7_c_pointer(op), (gint)s7_integer(n_pages));
  return(lg_false);
}

static s7_pointer lg_gtk_print_operation_set_current_page(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_operation_set_current_page "void gtk_print_operation_set_current_page(GtkPrintOperation* op, \
gint current_page)"
  s7_pointer _p;
  s7_pointer op, current_page;
  _p = args;
  op = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(op, GtkPrintOperation__sym)) s7_wrong_type_arg_error(sc, "gtk_print_operation_set_current_page", 1, op, "GtkPrintOperation*");
  current_page = s7_car(_p);
  if (!s7_is_integer(current_page)) s7_wrong_type_arg_error(sc, "gtk_print_operation_set_current_page", 2, current_page, "gint");
  gtk_print_operation_set_current_page((GtkPrintOperation*)s7_c_pointer(op), (gint)s7_integer(current_page));
  return(lg_false);
}

static s7_pointer lg_gtk_print_operation_set_use_full_page(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_operation_set_use_full_page "void gtk_print_operation_set_use_full_page(GtkPrintOperation* op, \
gboolean full_page)"
  s7_pointer _p;
  s7_pointer op, full_page;
  _p = args;
  op = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(op, GtkPrintOperation__sym)) s7_wrong_type_arg_error(sc, "gtk_print_operation_set_use_full_page", 1, op, "GtkPrintOperation*");
  full_page = s7_car(_p);
  if (!s7_is_boolean(full_page)) s7_wrong_type_arg_error(sc, "gtk_print_operation_set_use_full_page", 2, full_page, "gboolean");
  gtk_print_operation_set_use_full_page((GtkPrintOperation*)s7_c_pointer(op), (gboolean)lg_boolean(full_page));
  return(lg_false);
}

static s7_pointer lg_gtk_print_operation_set_unit(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_operation_set_unit "void gtk_print_operation_set_unit(GtkPrintOperation* op, GtkUnit unit)"
  s7_pointer _p;
  s7_pointer op, unit;
  _p = args;
  op = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(op, GtkPrintOperation__sym)) s7_wrong_type_arg_error(sc, "gtk_print_operation_set_unit", 1, op, "GtkPrintOperation*");
  unit = s7_car(_p);
  if (!s7_is_integer(unit)) s7_wrong_type_arg_error(sc, "gtk_print_operation_set_unit", 2, unit, "GtkUnit");
  gtk_print_operation_set_unit((GtkPrintOperation*)s7_c_pointer(op), (GtkUnit)s7_integer(unit));
  return(lg_false);
}

static s7_pointer lg_gtk_print_operation_set_export_filename(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_operation_set_export_filename "void gtk_print_operation_set_export_filename(GtkPrintOperation* op, \
gchar* filename)"
  s7_pointer _p;
  s7_pointer op, filename;
  _p = args;
  op = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(op, GtkPrintOperation__sym)) s7_wrong_type_arg_error(sc, "gtk_print_operation_set_export_filename", 1, op, "GtkPrintOperation*");
  filename = s7_car(_p);
  if (!s7_is_string(filename)) s7_wrong_type_arg_error(sc, "gtk_print_operation_set_export_filename", 2, filename, "gchar*");
  gtk_print_operation_set_export_filename((GtkPrintOperation*)s7_c_pointer(op), (gchar*)s7_string(filename));
  return(lg_false);
}

static s7_pointer lg_gtk_print_operation_set_track_print_status(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_operation_set_track_print_status "void gtk_print_operation_set_track_print_status(GtkPrintOperation* op, \
gboolean track_status)"
  s7_pointer _p;
  s7_pointer op, track_status;
  _p = args;
  op = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(op, GtkPrintOperation__sym)) s7_wrong_type_arg_error(sc, "gtk_print_operation_set_track_print_status", 1, op, "GtkPrintOperation*");
  track_status = s7_car(_p);
  if (!s7_is_boolean(track_status)) s7_wrong_type_arg_error(sc, "gtk_print_operation_set_track_print_status", 2, track_status, "gboolean");
  gtk_print_operation_set_track_print_status((GtkPrintOperation*)s7_c_pointer(op), (gboolean)lg_boolean(track_status));
  return(lg_false);
}

static s7_pointer lg_gtk_print_operation_set_show_progress(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_operation_set_show_progress "void gtk_print_operation_set_show_progress(GtkPrintOperation* op, \
gboolean show_progress)"
  s7_pointer _p;
  s7_pointer op, show_progress;
  _p = args;
  op = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(op, GtkPrintOperation__sym)) s7_wrong_type_arg_error(sc, "gtk_print_operation_set_show_progress", 1, op, "GtkPrintOperation*");
  show_progress = s7_car(_p);
  if (!s7_is_boolean(show_progress)) s7_wrong_type_arg_error(sc, "gtk_print_operation_set_show_progress", 2, show_progress, "gboolean");
  gtk_print_operation_set_show_progress((GtkPrintOperation*)s7_c_pointer(op), (gboolean)lg_boolean(show_progress));
  return(lg_false);
}

static s7_pointer lg_gtk_print_operation_set_allow_async(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_operation_set_allow_async "void gtk_print_operation_set_allow_async(GtkPrintOperation* op, \
gboolean allow_async)"
  s7_pointer _p;
  s7_pointer op, allow_async;
  _p = args;
  op = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(op, GtkPrintOperation__sym)) s7_wrong_type_arg_error(sc, "gtk_print_operation_set_allow_async", 1, op, "GtkPrintOperation*");
  allow_async = s7_car(_p);
  if (!s7_is_boolean(allow_async)) s7_wrong_type_arg_error(sc, "gtk_print_operation_set_allow_async", 2, allow_async, "gboolean");
  gtk_print_operation_set_allow_async((GtkPrintOperation*)s7_c_pointer(op), (gboolean)lg_boolean(allow_async));
  return(lg_false);
}

static s7_pointer lg_gtk_print_operation_set_custom_tab_label(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_operation_set_custom_tab_label "void gtk_print_operation_set_custom_tab_label(GtkPrintOperation* op, \
gchar* label)"
  s7_pointer _p;
  s7_pointer op, label;
  _p = args;
  op = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(op, GtkPrintOperation__sym)) s7_wrong_type_arg_error(sc, "gtk_print_operation_set_custom_tab_label", 1, op, "GtkPrintOperation*");
  label = s7_car(_p);
  if (!s7_is_string(label)) s7_wrong_type_arg_error(sc, "gtk_print_operation_set_custom_tab_label", 2, label, "gchar*");
  gtk_print_operation_set_custom_tab_label((GtkPrintOperation*)s7_c_pointer(op), (gchar*)s7_string(label));
  return(lg_false);
}

static s7_pointer lg_gtk_print_operation_run(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_operation_run "GtkPrintOperationResult gtk_print_operation_run(GtkPrintOperation* op, \
GtkPrintOperationAction action, GtkWindow* parent, GError** [error])"
  s7_pointer _p;
  s7_pointer op, action, parent;
  GError* ref_error = NULL;
  _p = args;
  op = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(op, GtkPrintOperation__sym)) s7_wrong_type_arg_error(sc, "gtk_print_operation_run", 1, op, "GtkPrintOperation*");
  action = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_integer(action)) s7_wrong_type_arg_error(sc, "gtk_print_operation_run", 2, action, "GtkPrintOperationAction");
  parent = s7_car(_p);
  if (!s7_is_c_pointer_of_type(parent, GtkWindow__sym)) s7_wrong_type_arg_error(sc, "gtk_print_operation_run", 3, parent, "GtkWindow*");
  {
    s7_pointer res_ult;
    res_ult = s7_make_integer(sc, gtk_print_operation_run((GtkPrintOperation*)s7_c_pointer(op), (GtkPrintOperationAction)s7_integer(action), (GtkWindow*)s7_c_pointer(parent), &ref_error));
      return(s7_list(sc, 2, res_ult, s7_make_c_pointer(sc, ref_error)));
   }
}

static s7_pointer lg_gtk_print_operation_get_error(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_operation_get_error "void gtk_print_operation_get_error(GtkPrintOperation* op, \
GError** [error])"
  s7_pointer _p;
  s7_pointer op;
  GError* ref_error = NULL;
  _p = args;
  op = s7_car(_p);
  if (!s7_is_c_pointer_of_type(op, GtkPrintOperation__sym)) s7_wrong_type_arg_error(sc, "gtk_print_operation_get_error", 1, op, "GtkPrintOperation*");
  gtk_print_operation_get_error((GtkPrintOperation*)s7_c_pointer(op), &ref_error);
    return(s7_list(sc, 1, s7_make_c_pointer(sc, ref_error)));
}

static s7_pointer lg_gtk_print_operation_get_status(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_operation_get_status "GtkPrintStatus gtk_print_operation_get_status(GtkPrintOperation* op)"
  s7_pointer op;
  op = s7_car(args);
  if (!s7_is_c_pointer_of_type(op, GtkPrintOperation__sym)) s7_wrong_type_arg_error(sc, "gtk_print_operation_get_status", 1, op, "GtkPrintOperation*");
  return(s7_make_integer(sc, gtk_print_operation_get_status((GtkPrintOperation*)s7_c_pointer(op))));
}

static s7_pointer lg_gtk_print_operation_get_status_string(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_operation_get_status_string "gchar* gtk_print_operation_get_status_string(GtkPrintOperation* op)"
  s7_pointer op;
  op = s7_car(args);
  if (!s7_is_c_pointer_of_type(op, GtkPrintOperation__sym)) s7_wrong_type_arg_error(sc, "gtk_print_operation_get_status_string", 1, op, "GtkPrintOperation*");
  return(s7_make_string(sc, gtk_print_operation_get_status_string((GtkPrintOperation*)s7_c_pointer(op))));
}

static s7_pointer lg_gtk_print_operation_is_finished(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_operation_is_finished "gboolean gtk_print_operation_is_finished(GtkPrintOperation* op)"
  s7_pointer op;
  op = s7_car(args);
  if (!s7_is_c_pointer_of_type(op, GtkPrintOperation__sym)) s7_wrong_type_arg_error(sc, "gtk_print_operation_is_finished", 1, op, "GtkPrintOperation*");
  return(s7_make_boolean(sc, gtk_print_operation_is_finished((GtkPrintOperation*)s7_c_pointer(op))));
}

static s7_pointer lg_gtk_print_operation_cancel(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_operation_cancel "void gtk_print_operation_cancel(GtkPrintOperation* op)"
  s7_pointer op;
  op = s7_car(args);
  if (!s7_is_c_pointer_of_type(op, GtkPrintOperation__sym)) s7_wrong_type_arg_error(sc, "gtk_print_operation_cancel", 1, op, "GtkPrintOperation*");
  gtk_print_operation_cancel((GtkPrintOperation*)s7_c_pointer(op));
  return(lg_false);
}

static s7_pointer lg_gtk_print_run_page_setup_dialog(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_run_page_setup_dialog "GtkPageSetup* gtk_print_run_page_setup_dialog(GtkWindow* parent, \
GtkPageSetup* page_setup, GtkPrintSettings* settings)"
  s7_pointer _p;
  s7_pointer parent, page_setup, settings;
  _p = args;
  parent = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(parent, GtkWindow__sym)) s7_wrong_type_arg_error(sc, "gtk_print_run_page_setup_dialog", 1, parent, "GtkWindow*");
  page_setup = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(page_setup, GtkPageSetup__sym)) s7_wrong_type_arg_error(sc, "gtk_print_run_page_setup_dialog", 2, page_setup, "GtkPageSetup*");
  settings = s7_car(_p);
  if (!s7_is_c_pointer_of_type(settings, GtkPrintSettings__sym)) s7_wrong_type_arg_error(sc, "gtk_print_run_page_setup_dialog", 3, settings, "GtkPrintSettings*");
  return(lg_make_c_pointer_with_type(sc, GtkPageSetup__sym, gtk_print_run_page_setup_dialog((GtkWindow*)s7_c_pointer(parent), (GtkPageSetup*)s7_c_pointer(page_setup), (GtkPrintSettings*)s7_c_pointer(settings))));
}

static s7_pointer lg_gtk_print_run_page_setup_dialog_async(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_run_page_setup_dialog_async "void gtk_print_run_page_setup_dialog_async(GtkWindow* parent, \
GtkPageSetup* page_setup, GtkPrintSettings* settings, GtkPageSetupDoneFunc done_cb, gpointer data)"
  s7_pointer _p;
  s7_pointer parent, page_setup, settings, done_cb, data;
  _p = args;
  parent = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(parent, GtkWindow__sym)) s7_wrong_type_arg_error(sc, "gtk_print_run_page_setup_dialog_async", 1, parent, "GtkWindow*");
  page_setup = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(page_setup, GtkPageSetup__sym)) s7_wrong_type_arg_error(sc, "gtk_print_run_page_setup_dialog_async", 2, page_setup, "GtkPageSetup*");
  settings = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(settings, GtkPrintSettings__sym)) s7_wrong_type_arg_error(sc, "gtk_print_run_page_setup_dialog_async", 3, settings, "GtkPrintSettings*");
  done_cb = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(done_cb, GtkPageSetupDoneFunc_sym)) s7_wrong_type_arg_error(sc, "gtk_print_run_page_setup_dialog_async", 4, done_cb, "GtkPageSetupDoneFunc");
  data = s7_car(_p);
  if (!s7_is_c_pointer_of_type(data, gpointer_sym)) s7_wrong_type_arg_error(sc, "gtk_print_run_page_setup_dialog_async", 5, data, "gpointer");
  gtk_print_run_page_setup_dialog_async((GtkWindow*)s7_c_pointer(parent), (GtkPageSetup*)s7_c_pointer(page_setup), (GtkPrintSettings*)s7_c_pointer(settings), (GtkPageSetupDoneFunc)s7_c_pointer(done_cb), (gpointer)s7_c_pointer(data));
  return(lg_false);
}

static s7_pointer lg_gtk_print_settings_new(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_settings_new "GtkPrintSettings* gtk_print_settings_new( void)"
  return(lg_make_c_pointer_with_type(sc, GtkPrintSettings__sym, gtk_print_settings_new()));
}

static s7_pointer lg_gtk_print_settings_copy(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_settings_copy "GtkPrintSettings* gtk_print_settings_copy(GtkPrintSettings* other)"
  s7_pointer other;
  other = s7_car(args);
  if (!s7_is_c_pointer_of_type(other, GtkPrintSettings__sym)) s7_wrong_type_arg_error(sc, "gtk_print_settings_copy", 1, other, "GtkPrintSettings*");
  return(lg_make_c_pointer_with_type(sc, GtkPrintSettings__sym, gtk_print_settings_copy((GtkPrintSettings*)s7_c_pointer(other))));
}

static s7_pointer lg_gtk_print_settings_has_key(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_settings_has_key "gboolean gtk_print_settings_has_key(GtkPrintSettings* settings, \
gchar* key)"
  s7_pointer _p;
  s7_pointer settings, key;
  _p = args;
  settings = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(settings, GtkPrintSettings__sym)) s7_wrong_type_arg_error(sc, "gtk_print_settings_has_key", 1, settings, "GtkPrintSettings*");
  key = s7_car(_p);
  if (!s7_is_string(key)) s7_wrong_type_arg_error(sc, "gtk_print_settings_has_key", 2, key, "gchar*");
  return(s7_make_boolean(sc, gtk_print_settings_has_key((GtkPrintSettings*)s7_c_pointer(settings), (gchar*)s7_string(key))));
}

static s7_pointer lg_gtk_print_settings_get(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_settings_get "gchar* gtk_print_settings_get(GtkPrintSettings* settings, gchar* key)"
  s7_pointer _p;
  s7_pointer settings, key;
  _p = args;
  settings = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(settings, GtkPrintSettings__sym)) s7_wrong_type_arg_error(sc, "gtk_print_settings_get", 1, settings, "GtkPrintSettings*");
  key = s7_car(_p);
  if (!s7_is_string(key)) s7_wrong_type_arg_error(sc, "gtk_print_settings_get", 2, key, "gchar*");
  return(s7_make_string(sc, gtk_print_settings_get((GtkPrintSettings*)s7_c_pointer(settings), (gchar*)s7_string(key))));
}

static s7_pointer lg_gtk_print_settings_set(s7_scheme *sc, s7_pointer args)
{
  #define H_gtk_print_settings_set "void gtk_print_settings_set(GtkPrintSettings* settings, gchar* key, \
gchar* value)"
  s7_pointer _p;
  s7_pointer settings, key, value;
  _p = args;
  settings = s7_car(_p); _p = s7_cdr(_p);
  if (!s7_is_c_pointer_of_type(settings, GtkPrintSettings__sym)) s7_wrong_type_arg_error(sc, "gtk_print_settings_set"